/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzdu;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzeb;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzpy;

@zzmb
public class zzfa {
    private final zzjr zzzU = new zzjr();
    private final Context mContext;
    private final zzeb zzrB;
    private AdListener zzyE;
    private zzdt zzyD;
    private zzep zzzZ;
    private String zztq;
    private String zzAd;
    private AppEventListener zzzq;
    private PlayStorePurchaseListener zzAc;
    private InAppPurchaseListener zzAa;
    private PublisherInterstitialAd zzAh;
    private OnCustomRenderedAdLoadedListener zzAb;
    private Correlator zzzY;
    private RewardedVideoAdListener zzcI;
    private boolean zzAi;

    public zzfa(Context context) {
        this(context, zzeb.zzey(), null);
    }

    public zzfa(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzeb.zzey(), publisherInterstitialAd);
    }

    public zzfa(Context context, zzeb zzeb2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzrB = zzeb2;
        this.zzAh = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zzyE;
    }

    public String getAdUnitId() {
        return this.zztq;
    }

    public AppEventListener getAppEventListener() {
        return this.zzzq;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzAa;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzAb;
    }

    public boolean isLoaded() {
        try {
            if (this.zzzZ == null) {
                return false;
            }
            return this.zzzZ.isReady();
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public boolean isLoading() {
        try {
            if (this.zzzZ == null) {
                return false;
            }
            return this.zzzZ.isLoading();
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public void zza(zzey zzey2) {
        try {
            if (this.zzzZ == null) {
                this.zzS("loadAd");
            }
            if (this.zzzZ.zzb(this.zzrB.zza(this.mContext, zzey2))) {
                this.zzzU.zzi(zzey2.zzeY());
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzyE = adListener;
            if (this.zzzZ != null) {
                this.zzzZ.zza(adListener != null ? new zzdv(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zzdt zzdt2) {
        try {
            this.zzyD = zzdt2;
            if (this.zzzZ != null) {
                this.zzzZ.zza(zzdt2 != null ? new zzdu(zzdt2) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String string) {
        if (this.zztq != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zztq = string;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzzq = appEventListener;
            if (this.zzzZ != null) {
                this.zzzZ.zza(appEventListener != null ? new zzee(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzAc != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzAa = inAppPurchaseListener;
            if (this.zzzZ != null) {
                this.zzzZ.zza(inAppPurchaseListener != null ? new zzle(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzAb = onCustomRenderedAdLoadedListener;
            if (this.zzzZ != null) {
                this.zzzZ.zza(onCustomRenderedAdLoadedListener != null ? new zzgk(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String string) {
        if (this.zzAa != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zzAc = playStorePurchaseListener;
            this.zzAd = string;
            if (this.zzzZ != null) {
                this.zzzZ.zza(playStorePurchaseListener != null ? new zzli(playStorePurchaseListener) : null, string);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzzY = correlator;
        try {
            if (this.zzzZ != null) {
                this.zzzZ.zza(this.zzzY == null ? null : this.zzzY.zzbr());
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set correlator.", remoteException);
        }
    }

    public void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzcI = rewardedVideoAdListener;
            if (this.zzzZ != null) {
                this.zzzZ.zza(rewardedVideoAdListener != null ? new zznw(rewardedVideoAdListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the AdListener.", remoteException);
        }
    }

    public void zzd(boolean bl) {
        this.zzAi = bl;
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzzZ != null) {
                return this.zzzZ.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzT("show");
            this.zzzZ.showInterstitial();
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to show interstitial.", remoteException);
        }
    }

    private void zzS(String string) throws RemoteException {
        if (this.zztq == null) {
            this.zzT(string);
        }
        zzec zzec2 = this.zzAi ? zzec.zzez() : new zzec();
        this.zzzZ = zzeh.zzeP().zzb(this.mContext, zzec2, this.zztq, this.zzzU);
        if (this.zzyE != null) {
            this.zzzZ.zza(new zzdv(this.zzyE));
        }
        if (this.zzyD != null) {
            this.zzzZ.zza(new zzdu(this.zzyD));
        }
        if (this.zzzq != null) {
            this.zzzZ.zza(new zzee(this.zzzq));
        }
        if (this.zzAa != null) {
            this.zzzZ.zza(new zzle(this.zzAa));
        }
        if (this.zzAc != null) {
            this.zzzZ.zza(new zzli(this.zzAc), this.zzAd);
        }
        if (this.zzAb != null) {
            this.zzzZ.zza(new zzgk(this.zzAb));
        }
        if (this.zzzY != null) {
            this.zzzZ.zza(this.zzzY.zzbr());
        }
        if (this.zzcI != null) {
            this.zzzZ.zza(new zznw(this.zzcI));
        }
    }

    private void zzT(String string) {
        if (this.zzzZ == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

