/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzmj;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmy;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqi;

@zzmb
public abstract class zzmf
implements zzme.zza,
zzpk<Void> {
    private final zzqi<zzmh> zzQV;
    private final zzme.zza zzQW;
    private final Object zzrN = new Object();

    public zzmf(zzqi<zzmh> zzqi2, zzme.zza zza2) {
        this.zzQV = zzqi2;
        this.zzQW = zza2;
    }

    public abstract void zziY();

    public abstract zzmq zziZ();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzmk zzmk2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzQW.zzb(zzmk2);
            this.zziY();
        }
    }

    public Void zzit() {
        final zzmq zzmq2 = this.zziZ();
        if (zzmq2 == null) {
            this.zzQW.zzb(new zzmk(0));
            this.zziY();
            return null;
        }
        this.zzQV.zza(new zzqi.zzc<zzmh>(){

            public void zzc(zzmh zzmh2) {
                if (!zzmf.this.zza(zzmq2, zzmh2)) {
                    zzmf.this.zziY();
                }
            }

            @Override
            public /* synthetic */ void zzd(Object object) {
                this.zzc((zzmh)((Object)object));
            }
        }, new zzqi.zza(){

            @Override
            public void run() {
                zzmf.this.zziY();
            }
        });
        return null;
    }

    @Override
    public void cancel() {
        this.zziY();
    }

    boolean zza(zzmq zzmq2, zzmh zzmh2) {
        try {
            zzmq2.zza(zzmh2, new zzmj(this));
            return true;
        }
        catch (RemoteException remoteException) {
            zzpe.zzc((String)"Could not fetch ad response from ad request service.", (Throwable)remoteException);
            zzv.zzcN().zza(remoteException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (NullPointerException nullPointerException) {
            zzpe.zzc((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)nullPointerException);
            zzv.zzcN().zza(nullPointerException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (SecurityException securityException) {
            zzpe.zzc((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)securityException);
            zzv.zzcN().zza(securityException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (Throwable throwable) {
            zzpe.zzc((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)throwable);
            zzv.zzcN().zza(throwable, "AdRequestClientTask.getAdResponseFromService");
        }
        this.zzQW.zzb(new zzmk(0));
        return false;
    }

    @Override
    public /* synthetic */ Object zziw() {
        return this.zzit();
    }

    @zzmb
    public static class zzb
    extends zzmf
    implements zzf.zzb,
    zzf.zzc {
        private Context mContext;
        private zzqa zztr;
        private zzqi<zzmh> zzQV;
        private final zzme.zza zzQW;
        private final Object zzrN = new Object();
        protected zzmg zzQZ;
        private boolean zzRa;

        public zzb(Context context, zzqa zzqa2, zzqi<zzmh> zzqi2, zzme.zza zza2) {
            super(zzqi2, zza2);
            Looper looper;
            this.mContext = context;
            this.zztr = zzqa2;
            this.zzQV = zzqi2;
            this.zzQW = zza2;
            if (zzfx.zzBE.get().booleanValue()) {
                this.zzRa = true;
                looper = zzv.zzcZ().zzkC();
            } else {
                looper = context.getMainLooper();
            }
            this.zzQZ = new zzmg(context, looper, this, this, this.zztr.zzYc);
            this.connect();
        }

        protected void connect() {
            this.zzQZ.zzwT();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzmq zziZ() {
            Object object = this.zzrN;
            synchronized (object) {
                try {
                    return this.zzQZ.zzjb();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zziY() {
            Object object = this.zzrN;
            synchronized (object) {
                if (this.zzQZ.isConnected() || this.zzQZ.isConnecting()) {
                    this.zzQZ.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzRa) {
                    zzv.zzcZ().zzkD();
                    this.zzRa = false;
                }
            }
        }

        zzpk zzja() {
            return new zza(this.mContext, this.zzQV, this.zzQW);
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzpe.zzbc((String)"Cannot connect to remote service, fallback to local instance.");
            zzpk zzpk2 = this.zzja();
            zzpk2.zziw();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzv.zzcJ().zzb(this.mContext, this.zztr.zzaZ, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle bundle) {
            ((zzmf)this).zziw();
        }

        public void onConnectionSuspended(int n) {
            zzpe.zzbc((String)"Disconnected from remote ad request service.");
        }

        @Override
        public /* synthetic */ Object zziw() {
            return super.zzit();
        }
    }

    @zzmb
    public static final class zza
    extends zzmf {
        private final Context mContext;

        public zza(Context context, zzqi<zzmh> zzqi2, zzme.zza zza2) {
            super(zzqi2, zza2);
            this.mContext = context;
        }

        @Override
        public zzmq zziZ() {
            zzfq zzfq2 = new zzfq(zzfx.zzAR.get());
            return zzmz.zza(this.mContext, zzfq2, zzmy.zzjf());
        }

        @Override
        public void zziY() {
        }

        @Override
        public /* synthetic */ Object zziw() {
            return super.zzit();
        }
    }
}

