/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzjs;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.internal.zzox;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqp;
import java.util.ArrayList;
import java.util.UUID;

@zzmb
public abstract class zzb
extends zza
implements zzh,
zzj,
zzt,
zzhz,
zzjk {
    protected final zzjs zzsD;
    private final Messenger mMessenger;
    protected transient boolean zzsE;

    public zzb(Context context, zzec zzec2, String string2, zzjs zzjs2, zzqa zzqa2, zzd zzd2) {
        this(new zzw(context, zzec2, string2, zzqa2), zzjs2, null, zzd2);
    }

    protected zzb(zzw zzw2, zzjs zzjs2, @Nullable zzs zzs2, zzd zzd2) {
        super(zzw2, zzs2, zzd2);
        this.zzsD = zzjs2;
        this.mMessenger = new Messenger((Handler)new zzkw(this.zzsw.zzqr));
        this.zzsE = false;
    }

    @Override
    public boolean zza(zzdy zzdy2, zzgf zzgf2) {
        if (!this.zzbM()) {
            return false;
        }
        Bundle bundle = zzv.zzcJ().zzK(this.zzsw.zzqr);
        this.zzsv.cancel();
        this.zzsw.zzvF = 0;
        zzox zzox2 = null;
        if (zzfx.zzEp.get().booleanValue()) {
            zzox2 = zzv.zzcN().zzjY();
            zzv.zzdf().zza(this.zzsw.zzqr, this.zzsw.zzvf, false, zzox2, zzox2.zzjI(), this.zzsw.zzvd);
        }
        zzmh.zza zza2 = this.zza(zzdy2, bundle, zzox2);
        zzgf2.zzg("seq_num", zza2.zzRg);
        zzgf2.zzg("request_id", zza2.zzRr);
        zzgf2.zzg("session_id", zza2.zzRh);
        if (zza2.zzRe != null) {
            zzgf2.zzg("app_version", String.valueOf(zza2.zzRe.versionCode));
        }
        this.zzsw.zzvh = zzv.zzcF().zza(this.zzsw.zzqr, zza2, this.zzsw.zzve, this);
        return true;
    }

    @Override
    public void zzb(zzov zzov2) {
        super.zzb(zzov2);
        if (zzov2.zzKA != null) {
            zzpe.zzbc((String)"Disable the debug gesture detector on the mediation ad frame.");
            if (this.zzsw.zzvg != null) {
                this.zzsw.zzvg.zzdu();
            }
            zzpe.zzbc((String)"Pinging network fill URLs.");
            zzv.zzdc().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, zzov2, this.zzsw.zzvd, false, zzov2.zzKA.zzJN);
            if (zzov2.zzVr != null && zzov2.zzVr.zzKb != null && zzov2.zzVr.zzKb.size() > 0) {
                zzpe.zzbc((String)"Pinging urls remotely");
                zzv.zzcJ().zza(this.zzsw.zzqr, zzov2.zzVr.zzKb);
            }
        } else {
            zzpe.zzbc((String)"Enable the debug gesture detector on the admob ad frame.");
            if (this.zzsw.zzvg != null) {
                this.zzsw.zzvg.zzdt();
            }
        }
        if (zzov2.errorCode == 3 && zzov2.zzVr != null && zzov2.zzVr.zzKa != null) {
            zzpe.zzbc((String)"Pinging no fill URLs.");
            zzv.zzdc().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, zzov2, this.zzsw.zzvd, false, zzov2.zzVr.zzKa);
        }
    }

    @Override
    protected boolean zza(@Nullable zzov zzov2, zzov zzov3) {
        if (zzov2 != null && zzov2.zzKD != null) {
            zzov2.zzKD.zza((zzjk)null);
        }
        if (zzov3.zzKD != null) {
            zzov3.zzKD.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzov3.zzVr != null) {
            n = zzov3.zzVr.zzKk;
            n2 = zzov3.zzVr.zzKl;
        }
        this.zzsw.zzvD.zzj(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzsw.zzvk == null) {
            zzpe.zzbe((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzsw.zzvk.zzVr != null && this.zzsw.zzvk.zzVr.zzJY != null) {
            zzv.zzdc().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, this.zzsw.zzvk, this.zzsw.zzvd, false, this.zzsw.zzvk.zzVr.zzJY);
        }
        if (this.zzsw.zzvk.zzKA != null && this.zzsw.zzvk.zzKA.zzJL != null) {
            zzv.zzdc().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, this.zzsw.zzvk, this.zzsw.zzvd, false, this.zzsw.zzvk.zzKA.zzJL);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzov zzov2) {
        zzdy zzdy2;
        boolean bl = false;
        if (this.zzsx != null) {
            zzdy2 = this.zzsx;
            this.zzsx = null;
        } else {
            zzdy2 = zzov2.zzRd;
            bl = zzdy2.extras != null ? zzdy2.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(zzdy2, zzov2, bl);
    }

    protected boolean zza(zzdy zzdy2, zzov zzov2, boolean bl) {
        if (!bl && this.zzsw.zzdm()) {
            if (zzov2.zzKe > 0L) {
                this.zzsv.zza(zzdy2, zzov2.zzKe);
            } else if (zzov2.zzVr != null && zzov2.zzVr.zzKe > 0L) {
                this.zzsv.zza(zzdy2, zzov2.zzVr.zzKe);
            } else if (!zzov2.zzRK && zzov2.errorCode == 2) {
                this.zzsv.zzh(zzdy2);
            }
        }
        return this.zzsv.zzcv();
    }

    @Override
    public void pause() {
        zzac.zzdn((String)"pause must be called on the main UI thread.");
        if (this.zzsw.zzvk != null && this.zzsw.zzvk.zzMZ != null && this.zzsw.zzdm()) {
            zzv.zzcL().zzl(this.zzsw.zzvk.zzMZ);
        }
        if (this.zzsw.zzvk != null && this.zzsw.zzvk.zzKB != null) {
            try {
                this.zzsw.zzvk.zzKB.pause();
            }
            catch (RemoteException remoteException) {
                zzpe.zzbe((String)"Could not pause mediation adapter.");
            }
        }
        this.zzsy.zzl(this.zzsw.zzvk);
        this.zzsv.pause();
    }

    @Override
    public void resume() {
        zzac.zzdn((String)"resume must be called on the main UI thread.");
        zzqp zzqp2 = null;
        if (this.zzsw.zzvk != null && this.zzsw.zzvk.zzMZ != null) {
            zzqp2 = this.zzsw.zzvk.zzMZ;
        }
        if (zzqp2 != null && this.zzsw.zzdm()) {
            zzv.zzcL().zzm(this.zzsw.zzvk.zzMZ);
        }
        if (this.zzsw.zzvk != null && this.zzsw.zzvk.zzKB != null) {
            try {
                this.zzsw.zzvk.zzKB.resume();
            }
            catch (RemoteException remoteException) {
                zzpe.zzbe((String)"Could not resume mediation adapter.");
            }
        }
        if (zzqp2 == null || !zzqp2.zzlc()) {
            this.zzsv.resume();
        }
        this.zzsy.zzm(this.zzsw.zzvk);
    }

    @Override
    protected boolean zzc(zzdy zzdy2) {
        return super.zzc(zzdy2) && !this.zzsE;
    }

    protected boolean zzbM() {
        boolean bl = true;
        if (!zzv.zzcJ().zza(this.zzsw.zzqr.getPackageManager(), this.zzsw.zzqr.getPackageName(), "android.permission.INTERNET") || !zzv.zzcJ().zzy(this.zzsw.zzqr)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzbN() {
        this.zzsy.zzj(this.zzsw.zzvk);
        this.zzsE = false;
        this.zzbH();
        this.zzsw.zzvm.zzjB();
    }

    @Override
    public void zzbO() {
        this.zzsE = true;
        this.zzbJ();
    }

    @Override
    public void onPause() {
        this.zzsy.zzl(this.zzsw.zzvk);
    }

    @Override
    public void onResume() {
        this.zzsy.zzm(this.zzsw.zzvk);
    }

    @Override
    public void zzbP() {
        this.onAdClicked();
    }

    @Override
    public void zzbQ() {
        this.zzbN();
    }

    @Override
    public void zzbR() {
        this.zzbE();
    }

    @Override
    public void zzbS() {
        this.zzbO();
    }

    @Override
    public void zzbT() {
        if (this.zzsw.zzvk != null) {
            String string2 = this.zzsw.zzvk.zzKC;
            zzpe.zzbe((String)new StringBuilder(74 + String.valueOf(string2).length()).append("Mediation adapter ").append(string2).append(" refreshed, but mediation adapters should never refresh.").toString());
        }
        this.zza(this.zzsw.zzvk, true);
        this.zzbK();
    }

    @Override
    public void zzbU() {
        this.recordImpression();
    }

    private zzmh.zza zza(zzdy zzdy2, Bundle bundle, zzox zzox2) {
        String string2;
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzsw.zzqr.getApplicationInfo();
        try {
            packageManager = this.zzsw.zzqr.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzsw.zzqr.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzsw.zzvg != null && this.zzsw.zzvg.getParent() != null) {
            object = new int[2];
            this.zzsw.zzvg.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzsw.zzvg.getWidth();
            int n3 = this.zzsw.zzvg.getHeight();
            int n4 = 0;
            if (this.zzsw.zzvg.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzv.zzcN().zzjL();
        this.zzsw.zzvm = new zzow((String)object, this.zzsw.zzvd);
        this.zzsw.zzvm.zzt(zzdy2);
        String string3 = zzv.zzcJ().zza(this.zzsw.zzqr, (View)this.zzsw.zzvg, this.zzsw.zzvj);
        long l = 0L;
        if (this.zzsw.zzvq != null) {
            try {
                l = this.zzsw.zzvq.getValue();
            }
            catch (RemoteException remoteException) {
                zzpe.zzbe((String)"Cannot get correlation id, default to 0.");
            }
        }
        String string4 = UUID.randomUUID().toString();
        Bundle bundle3 = zzv.zzcN().zza(this.zzsw.zzqr, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzsw.zzvw.size(); n += 1) {
            arrayList.add((String)this.zzsw.zzvw.keyAt(n));
        }
        n = this.zzsw.zzvr != null ? 1 : 0;
        boolean bl = this.zzsw.zzvs != null && zzv.zzcN().zzkb();
        String string5 = "";
        if (zzfx.zzEH.get().booleanValue()) {
            zzpe.zzbc((String)"Getting webview cookie from CookieManager.");
            string2 = zzv.zzcL().zzL(this.zzsw.zzqr);
            if (string2 != null) {
                string5 = string2.getCookie("googleads.g.doubleclick.net");
            }
        }
        string2 = null;
        if (zzox2 != null) {
            string2 = zzox2.zzjH();
        }
        return new zzmh.zza(bundle2, zzdy2, this.zzsw.zzvj, this.zzsw.zzvd, applicationInfo, packageInfo, (String)object, zzv.zzcN().getSessionId(), this.zzsw.zzvf, bundle3, this.zzsw.zzvB, arrayList, bundle, zzv.zzcN().zzjP(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string3, l, string4, zzfx.zzfn(), this.zzsw.zzvc, this.zzsw.zzvx, new zzmo(n != 0, bl, false), this.zzsw.zzdq(), zzv.zzcJ().zzco(), zzv.zzcJ().zzcq(), zzv.zzcJ().zzI(this.zzsw.zzqr), zzv.zzcJ().zzs((View)this.zzsw.zzvg), this.zzsw.zzqr instanceof Activity, zzv.zzcN().zzjU(), string5, string2, zzv.zzcN().zzjX(), zzv.zzdg().zzgf(), zzv.zzcJ().zzko(), zzv.zzcR().zzky());
    }

    @Override
    public void zza(zzkz zzkz2) {
        zzac.zzdn((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzsw.zzvr = zzkz2;
    }

    @Override
    public void zza(zzld zzld2, @Nullable String string2) {
        zzac.zzdn((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzsw.zzvC = new zzk(string2);
        this.zzsw.zzvs = zzld2;
        if (!zzv.zzcN().zzjO() && zzld2 != null) {
            new zzc(this.zzsw.zzqr, this.zzsw.zzvs, this.zzsw.zzvC).zziw();
        }
    }

    @Override
    public void zza(String string2, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string2, arrayList, this.zzsw.zzqr, this.zzsw.zzvf.zzaZ);
        if (this.zzsw.zzvr == null) {
            zzpe.zzbe((String)"InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzeh.zzeO().zzP(this.zzsw.zzqr)) {
                zzpe.zzbe((String)"Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzsw.zzvs == null) {
                zzpe.zzbe((String)"PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzsw.zzvC == null) {
                zzpe.zzbe((String)"PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzsw.zzvG) {
                zzpe.zzbe((String)"An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzsw.zzvG = true;
            try {
                if (!this.zzsw.zzvs.isValidPurchase(string2)) {
                    this.zzsw.zzvG = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                zzpe.zzbe((String)"Could not start In-App purchase.");
                this.zzsw.zzvG = false;
                return;
            }
            zzv.zzcX().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzYd, new GInAppPurchaseManagerInfoParcel(this.zzsw.zzqr, this.zzsw.zzvC, (zzky)zzd2, this));
        } else {
            try {
                this.zzsw.zzvr.zza((zzky)zzd2);
            }
            catch (RemoteException remoteException) {
                zzpe.zzbe((String)"Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string2, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzsw.zzvs != null) {
                this.zzsw.zzvs.zza((zzlc)new zzg(this.zzsw.zzqr, string2, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            zzpe.zzbe((String)"Fail to invoke PlayStorePurchaseListener.");
        }
        zzpi.zzWR.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzv.zzcX().zzd(intent);
                zzv.zzcX();
                if (n == 0 && zzb.this.zzsw.zzvk != null && zzb.this.zzsw.zzvk.zzMZ != null && zzb.this.zzsw.zzvk.zzMZ.zzkT() != null) {
                    zzb.this.zzsw.zzvk.zzMZ.zzkT().close();
                }
                zzb.this.zzsw.zzvG = false;
            }
        }, 500L);
    }

    public void recordImpression() {
        this.zza(this.zzsw.zzvk, false);
    }

    protected void zza(@Nullable zzov zzov2, boolean bl) {
        if (zzov2 == null) {
            zzpe.zzbe((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzov2);
        if (zzov2.zzVr != null && zzov2.zzVr.zzJZ != null) {
            zzv.zzdc().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, zzov2, this.zzsw.zzvd, bl, zzov2.zzVr.zzJZ);
        }
        if (zzov2.zzKA != null && zzov2.zzKA.zzJM != null) {
            zzv.zzdc().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, zzov2, this.zzsw.zzvd, bl, zzov2.zzKA.zzJM);
        }
    }

    public String getMediationAdapterClassName() {
        if (this.zzsw.zzvk == null) {
            return null;
        }
        return this.zzsw.zzvk.zzKC;
    }

    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }

    @Override
    public void zzbV() {
        zzv.zzcJ().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzsv.pause();
            }
        });
    }

    @Override
    public void zzbW() {
        zzv.zzcJ().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzsv.resume();
            }
        });
    }
}

