/*
 * $Id: Operand.java,v 1.2 2006/01/13 20:32:13 Yuki Exp $
 */
package hsplet.variable;

import java.io.Serializable;

/**
 * HSP ̃Iyh킷NXB
 * <p>
 * HSP ŎgpϐE萔EZʂׂ͂ẴNXpB
 * </p>
 * Iyh͎
 * <ul>
 * <li>z̃CfbNXItZbg擾郁\bhB</li>
 * <li>Java ̃v~eBu╶ɕϊ郁\bhB</li>
 * <li>EύXnZq\bhB</li>
 * <li>񍀉Zq\bhB</li>
 * <li>f[^̃oCgւ̒ڃANZX\bhB</li>
 * </ul>
 * 琬B
 * <p>
 * قƂǂ̃\bh abstract Ȃ̂ŁApNX͓K؂ɂB
 * </p>
 * 
 * @author Yuki
 * @version $Revision: 1.2 $, $Date: 2006/01/13 20:32:13 $
 */
public abstract class Operand implements Serializable {

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: Operand.java,v 1.2 2006/01/13 20:32:13 Yuki Exp $";

	/**
	 * f[^̌^B
	 * 
	 * @author Yuki
	 */
	public static final class Type {

		/** f[^̌^AgpB */
		public static final int UNKNOWN = 0;

		/** f[^̌^Ax\萔B */
		public static final int LABEL = 1;

		/** f[^̌^A\萔B */
		public static final int STRING = 2;

		/** f[^̌^A\萔B */
		public static final int DOUBLE = 3;

		/** f[^̌^A\萔B */
		public static final int INTEGER = 4;

		/** f[^̌^Apr͕sB */
		public static final int MODULE = 5;
	}

	/**
	 * f[^̌^擾B
	 * 
	 * @return f[^̌^B
	 */
	public abstract int getType();

	/**
	 * z̈ꎟڂ̗vf擾B
	 * 
	 * @return z̈ꎟڂ̗vfB
	 */
	public abstract int l0();

	/**
	 * z̓񎟌ڂ̗vf擾B
	 * 
	 * @return z̓񎟌ڂ̗vfB
	 */
	public abstract int l1();

	/**
	 * z̎Oڂ̗vf擾B
	 * 
	 * @return z̎Oڂ̗vfB
	 */
	public abstract int l2();

	/**
	 * z̎lڂ̗vf擾B
	 * 
	 * @return z̎lڂ̗vfB
	 */
	public abstract int l3();

	/**
	 * 񎟌źAꎟɊZvf̃CfbNX擾B
	 * <p>
	 * HSPLet 3.0 ł͍̂߂ɔzׂ͂ĈꎟŊǗB 񎟌ȏ̃CfbNX͗vfɈꎟɊZĂ珈B
	 * </p>
	 * 
	 * @param i0 ꎟڂ̃CfbNXB
	 * @param i1 񎟌ڂ̃CfbNXB
	 * @return ꎟɊZvfԍB
	 */
	public abstract int getIndex(final int i0, final int i1);

	/**
	 * OźAꎟɊZvf̃CfbNX擾B
	 * <p>
	 * HSPLet 3.0 ł͍̂߂ɔzׂ͂ĈꎟŊǗB 񎟌ȏ̃CfbNX͗vfɈꎟɊZĂ珈B
	 * </p>
	 * 
	 * @param i0 ꎟڂ̃CfbNXB
	 * @param i1 񎟌ڂ̃CfbNXB
	 * @param i2 Oڂ̃CfbNXB
	 * @return ꎟɊZvfԍB
	 */
	public abstract int getIndex(final int i0, final int i1, final int i2);

	/**
	 * lźAꎟɊZvf̃CfbNX擾B
	 * <p>
	 * HSPLet 3.0 ł͍̂߂ɔzׂ͂ĈꎟŊǗB 񎟌ȏ̃CfbNX͗vfɈꎟɊZĂ珈B
	 * </p>
	 * 
	 * @param i0 ꎟڂ̃CfbNXB
	 * @param i1 񎟌ڂ̃CfbNXB
	 * @param i2 Oڂ̃CfbNXB
	 * @param i3 lڂ̃CfbNXB
	 * @return ꎟɊZvfԍB
	 */
	public abstract int getIndex(final int i0, final int i1, final int i2,
			final int i3);

	/**
	 * ̃IuWFNg̕l擾B
	 * <p>
	 * ̃IuWFNǧ^񂶂ȂƂ͕ϊsB
	 * </p>
	 * 
	 * @return IuWFNg̕lB
	 */
	//@Override
	public final String toString() {

		return toString(0);
	}

	/**
	 * ̃IuWFNg̕l擾B
	 * <p>
	 * ̃IuWFNǧ^񂶂ȂƂ͕ϊsB
	 * </p>
	 * 
	 * @param index l擾vfԍB
	 * @return IuWFNg̕lB
	 */
	public abstract String toString(final int index);

	/**
	 * ̃IuWFNg̕l擾B
	 * <p>
	 * ̃IuWFNǧ^񂶂ȂƂ͕ϊsB
	 * </p>
	 * 
	 * @param index l擾vfԍB
	 * @return IuWFNg̕lB
	 */
	public abstract ByteString toByteString(final int index);

	/**
	 * ̃IuWFNg̐l擾B
	 * <p>
	 * ̃IuWFNǧ^ȂƂ͕ϊsB
	 * </p>
	 * 
	 * @param index l擾vfԍB
	 * @return IuWFNg̐lB
	 */
	public abstract int toInt(final int index);

	/**
	 * ̃IuWFNg̏l擾B
	 * <p>
	 * ̃IuWFNǧ^ȂƂ͕ϊsB
	 * </p>
	 * 
	 * @param index l擾vfԍB
	 * @return IuWFNg̏lB
	 */
	public abstract double toDouble(final int index);

	/**
	 * IuWFNgւ̎QƂ擾B
	 * <p>
	 * ̃\bhԂIuWFNg͂̃IuWFNg̎w肳ꂽvfQƂĂB QƃIuWFNg̒lύXÃIuWFNg̒lύXƂ݂ɔfB
	 * </p>
	 * <p>
	 * ̒lɂĂ͂̃IuWFNggԂ\B
	 * </p>
	 * 
	 * @param index vfԍB
	 * @return ̃IuWFNgւ̎QƁB
	 */
	public Operand ref(final int index) {

		if (index == 0) {
			return this;
		} else {

			return new Reference(this, index);
		}
	}

	/**
	 * IuWFNg̒lCNgB
	 * 
	 * @param index CNgvfԍB
	 */
	public abstract void inc(final int index);

	/**
	 * IuWFNg̒lfNgB
	 * 
	 * @param index fNgvfԍB
	 */
	public abstract void dec(final int index);

	/**
	 * sB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assign(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ZsB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignAdd(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ZsB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignSub(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ZsB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignMul(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ZsB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignDiv(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ]sB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignMod(final int index, final Operand rhs,
			final int rhi);

	/**
	 * rbg_ϑsB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignAnd(final int index, final Operand rhs,
			final int rhi);

	/**
	 * rbg_asB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignOr(final int index, final Operand rhs,
			final int rhi);

	/**
	 * rbgr_asB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignXor(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ErbgVtgsB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignSr(final int index, final Operand rhs,
			final int rhi);

	/**
	 * rbgVtgsB
	 * 
	 * @param index vfԍB
	 * @param rhs IuWFNgB
	 * @param rhi vfԍB
	 */
	public abstract void assignSl(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ZsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand add(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ZsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand sub(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ZsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand mul(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ZsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand div(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ]߂B
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand mod(final int index, final Operand rhs,
			final int rhi);

	/**
	 * rbg_ς߂B
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand and(final int index, final Operand rhs,
			final int rhi);

	/**
	 * rbg_a߂B
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand or(final int index, final Operand rhs, final int rhi);

	/**
	 * rbgr_a߂B
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand xor(final int index, final Operand rhs,
			final int rhi);

	/**
	 * ErbgVtgsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand sl(final int index, final Operand rhs, final int rhi);

	/**
	 * rbgVtgsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand sr(final int index, final Operand rhs, final int rhi);

	/**
	 * ==rsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand eq(final int index, final Operand rhs, final int rhi);

	/**
	 * !=rsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand ne(final int index, final Operand rhs, final int rhi);

	/**
	 * &gt;rsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand gt(final int index, final Operand rhs, final int rhi);

	/**
	 * &lt;rsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand lt(final int index, final Operand rhs, final int rhi);

	/**
	 * &gt;=rsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand ge(final int index, final Operand rhs, final int rhi);

	/**
	 * &lt;=rsB
	 * 
	 * @param index vfԍB
	 * @param rhs EIyhB
	 * @param rhi EIyh̗vfԍB
	 * @return ZʁB
	 */
	public abstract Operand le(final int index, final Operand rhs, final int rhi);

	/**
	 * IuWFNg̃oCg擾B
	 * 
	 * @param index vfԍB
	 * @param offset ItZbgB
	 * @return IuWFNg̃oCglB
	 */
	public abstract byte peek(int index, int offset);

	/**
	 * IuWFNg̃oCgݒ肷B
	 * 
	 * @param index vfԍB
	 * @param offset ItZbgB
	 * @param value ݒ肷lB
	 */
	public abstract void poke(int index, int offset, byte value);

	/**
	 * T|[gȂZqgpꂽƂɗO𔭐B
	 * @param operator ZqB
	 * @return UnsupportedOperationException ׂOB
	 */
	public UnsupportedOperationException unsupportedOperator(
			final String operator) {

		return new UnsupportedOperationException("Zq " + operator + " ͌^ "
				+ getType() + " ɂ͎gpł܂B");
	}
}
