/*
 * Decompiled with CFR 0.152.
 */
package hsplet.function;

import hsplet.Context;
import hsplet.function.FunctionBase;
import hsplet.function.JumpStatement;
import hsplet.gui.Bgscr;
import hsplet.gui.Bmscr;
import hsplet.gui.Buffer;
import hsplet.gui.Button;
import hsplet.gui.Chkbox;
import hsplet.gui.Combox;
import hsplet.gui.GraphicsRenderer;
import hsplet.gui.HSPControl;
import hsplet.gui.Input;
import hsplet.gui.Listbox;
import hsplet.gui.Mesbox;
import hsplet.gui.Password;
import hsplet.gui.Screen;
import hsplet.media.HSPMedia;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GuiCommand
extends FunctionBase {
    private static final String fileVersionID = "$Id: GuiCommand.java,v 1.14 2006/05/20 06:12:07 Yuki Exp $";

    private static void addObject(Context context, Bmscr win, HSPControl obj, Dimension size) {
        if (win.contents != null) {
            int nullIndex;
            Component co = obj.asComponent();
            co.setLocation(win.cx, win.cy);
            co.setSize(size);
            win.cy += Math.max(size.height, win.mindy);
            win.contents.add(co);
            context.listener.listen(obj);
            if (win.objfont != null) {
                co.setFont(win.objfont);
            }
            if ((nullIndex = win.controls.indexOf(null)) < 0) {
                win.controls.add(obj);
                context.stat.value = win.controls.size() - 1;
            } else {
                win.controls.set(nullIndex, obj);
                context.stat.value = nullIndex;
            }
            obj.asComponent().setVisible(true);
            obj.asComponent().repaint();
        } else {
            context.stat.value = 0;
        }
    }

    public static void button(Context context, JumpStatement jump, String text, int label) {
        if (text == null) {
            context.error(5, "button", "text");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.contents != null) {
            Button obj = new Button(text, context, jump == null ? JumpStatement.Goto : jump, label);
            GuiCommand.addObject(context, win, obj, new Dimension(win.owidth, win.oheight));
        }
    }

    public static void chgdips(Context context, Operand v, int vi) {
        context.error(21, "chgdisp");
        context.stat.value = 2;
    }

    public static void exec(Context context, String fileName, int mode, String command) {
        if (fileName == null) {
            context.error(5, "exec", "fileName");
            return;
        }
        try {
            URL url = new URL(context.curdir, fileName);
            context.showPage(url, command == null || command.length() == 0 ? "_blank" : command);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            context.error(14, "exec", fileName);
        }
    }

    public static void dialog(final Context context, final String text, int type, final String title) {
        final Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        Component parent = win.component == null ? ((Bmscr)context.windows.get((int)0)).component : win.component;
        block2 : switch (type) {
            case 0: {
                JOptionPane.showMessageDialog(parent, text, title, 1);
                context.stat.value = 1;
                break;
            }
            case 1: {
                JOptionPane.showMessageDialog(parent, text, title, 2);
                context.stat.value = 1;
                break;
            }
            case 2: {
                switch (JOptionPane.showConfirmDialog(parent, text, title, 0, 1)) {
                    case 0: {
                        context.stat.value = 6;
                        break;
                    }
                    case 1: {
                        context.stat.value = 7;
                    }
                }
                break;
            }
            case 3: {
                switch (JOptionPane.showConfirmDialog(parent, text, title, 0, 2)) {
                    case 0: {
                        context.stat.value = 6;
                        break;
                    }
                    case 1: {
                        context.stat.value = 7;
                    }
                }
                break;
            }
            case 16: 
            case 17: {
                JFileChooser chooser = new JFileChooser(context.curdir.getFile());
                chooser.setFileSelectionMode(0);
                if (text != null && !text.equals("*")) {
                    chooser.setFileFilter(new FileFilter(){

                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith("." + text.toLowerCase());
                        }

                        public String getDescription() {
                            return String.valueOf(title) + " (*." + text + ")";
                        }
                    });
                }
                int result = type == 16 ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent);
                switch (result) {
                    case 0: {
                        context.stat.value = 1;
                        try {
                            context.refstr.value.assign(chooser.getSelectedFile().toURL().toString());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        break block2;
                    }
                }
                context.stat.value = 0;
                break;
            }
            case 32: 
            case 33: {
                context.stat.value = 0;
                final JColorChooser chooser = new JColorChooser(win.color);
                JDialog dialog = JColorChooser.createDialog(parent, title, true, chooser, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        win.color = chooser.getColor();
                        win.backGraphics.setColor(win.color);
                        context.stat.value = 1;
                    }
                }, null);
                ((Component)dialog).setVisible(true);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                context.error(3, "dialog", "type==" + type);
                return;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void mmload(Context context, String fileName, int id, int mode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void mmplay(Context context, int id) {
        if (id < 0 || id >= context.medias.size() || context.medias.get(id) == null) {
            context.error(3, "mmplay", "id==" + id);
            return;
        }
        ((HSPMedia)context.medias.get(id)).setPosition(0);
        ((HSPMedia)context.medias.get(id)).play();
    }

    public static void mmstop(Context context) {
        int i = 0;
        while (i < context.medias.size()) {
            if (context.medias.get(i) != null) {
                ((HSPMedia)context.medias.get(i)).stop();
            }
            ++i;
        }
    }

    public static void mci(Context context, String command) {
        if (command == null) {
            context.error(5, "mci", "command");
            return;
        }
        context.mci.exec(command);
    }

    public static void pset(Context context, int x, int y) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (x >= 0 && y >= 0 && x < win.backImage.getWidth() && y < win.backImage.getHeight()) {
            win.backImage.setRGB(x, y, win.color.getRGB());
        }
        win.redraw(x, y, 1, 1);
    }

    public static void pget(Context context, int x, int y) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.color = x >= 0 && y >= 0 && x < win.backImage.getWidth() && y < win.backImage.getHeight() ? new Color(win.backImage.getRGB(x, y)) : Color.white;
        Graphics2D g = win.backGraphics;
        g.setColor(win.color);
    }

    public static void syscolor(Context context, int type) {
        Color color;
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        switch (type) {
            case 0: {
                color = SystemColor.scrollbar;
                break;
            }
            case 1: {
                color = SystemColor.desktop;
                break;
            }
            case 2: {
                color = SystemColor.activeCaption;
                break;
            }
            case 3: {
                color = SystemColor.inactiveCaption;
                break;
            }
            case 4: {
                color = SystemColor.menu;
                break;
            }
            case 5: {
                color = SystemColor.window;
                break;
            }
            case 6: {
                color = SystemColor.windowBorder;
                break;
            }
            case 7: {
                color = SystemColor.menuText;
                break;
            }
            case 8: {
                color = SystemColor.windowText;
                break;
            }
            case 9: {
                color = SystemColor.activeCaptionText;
                break;
            }
            case 10: {
                color = SystemColor.activeCaptionBorder;
                break;
            }
            case 11: {
                color = SystemColor.inactiveCaptionBorder;
                break;
            }
            case 12: {
                color = SystemColor.desktop;
                break;
            }
            case 13: {
                color = SystemColor.textHighlight;
                break;
            }
            case 14: {
                color = SystemColor.textHighlightText;
                break;
            }
            case 15: {
                color = SystemColor.control;
                break;
            }
            case 16: {
                color = SystemColor.controlShadow;
                break;
            }
            case 17: {
                color = SystemColor.textInactiveText;
                break;
            }
            case 18: {
                color = SystemColor.controlText;
                break;
            }
            case 19: {
                color = SystemColor.inactiveCaptionText;
                break;
            }
            case 20: {
                color = SystemColor.controlLtHighlight;
                break;
            }
            case 21: {
                color = SystemColor.controlDkShadow;
                break;
            }
            case 22: {
                color = SystemColor.controlHighlight;
                break;
            }
            case 23: {
                color = SystemColor.infoText;
                break;
            }
            case 24: {
                color = SystemColor.info;
                break;
            }
            case 26: {
                color = SystemColor.controlText;
                break;
            }
            case 27: {
                color = SystemColor.activeCaption;
                break;
            }
            case 28: {
                color = SystemColor.inactiveCaption;
                break;
            }
            case 29: {
                color = SystemColor.controlHighlight;
                break;
            }
            case 30: {
                color = SystemColor.menu;
                break;
            }
            default: {
                context.error(3, "syscolor", "type==" + type);
                color = win.color;
            }
        }
        win.color = color;
        win.backGraphics.setColor(color);
    }

    public static void mes(Context context, String text) {
        if (text == null) {
            context.error(5, "mes", "text");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        Graphics2D g = win.backGraphics;
        FontMetrics metrics = win.backGraphics.getFontMetrics();
        win.mesw = 0;
        win.mesh = metrics.getFont().getSize();
        int ascent = metrics.getAscent() - (metrics.getHeight() - win.mesh) / 2;
        BufferedReader r = new BufferedReader(new StringReader(String.valueOf(text) + "\r\n"));
        Object oldAntiAliasing = win.backGraphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        Object oldRenering = win.backGraphics.getRenderingHint(RenderingHints.KEY_RENDERING);
        if ((win.fontStyle & 0x10) != 0) {
            win.backGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            win.backGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        while (true) {
            try {
                String line = r.readLine();
                if (line == null) break;
                g.drawString(line, win.cx, win.cy + ascent);
                win.mesw = g.getFontMetrics().stringWidth(line);
                if ((win.fontStyle & 4) != 0) {
                    g.drawLine(win.cx, win.cy + win.mesh - 1, win.cx + win.mesw - 1, win.cy + win.mesh - 1);
                }
                if ((win.fontStyle & 8) != 0) {
                    g.drawLine(win.cx, win.cy + win.mesh / 2, win.cx + win.mesw - 1, win.cy + win.mesh / 2);
                }
                win.redraw(win.cx, win.cy, win.mesw, win.mesh);
                win.cy += Math.max(win.mindy, win.mesh);
            }
            catch (IOException iOException) {}
        }
        win.backGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAntiAliasing);
        win.backGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, oldRenering);
    }

    public static void title(Context context, String text) {
        if (text == null) {
            context.error(5, "title", "text");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.screen.setTitle(text);
    }

    public static void pos(Context context, Operand xv, int xvi, Operand yv, int yvi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.cx = FunctionBase.toInt(xv, xvi, win.cx);
        win.cy = FunctionBase.toInt(yv, yvi, win.cy);
    }

    public static void circle(Context context, int x1, int y1, Operand x2v, int x2vi, Operand y2v, int y2vi, Operand typev, int typevi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        Graphics2D g = win.backGraphics;
        int x2 = FunctionBase.toInt(x2v, x2vi, win.backImage.getWidth() - 1);
        int y2 = FunctionBase.toInt(y2v, y2vi, win.backImage.getHeight() - 1);
        int l = Math.min(x1, x2);
        int t = Math.min(y1, y2);
        int r = Math.max(x1, x2) + 1;
        int b = Math.max(y1, y2) + 1;
        if (FunctionBase.toInt(typev, typevi, 1) == 0) {
            g.drawOval(l, t, r - l, b - t);
        } else {
            g.fillOval(l, t, r - l, b - t);
        }
        win.redraw(l, t, r - l, b - t);
    }

    public static void cls(Context context, int mode) {
        Color color;
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        switch (mode) {
            default: {
                color = Color.white;
                break;
            }
            case 1: {
                color = Color.lightGray;
                break;
            }
            case 2: {
                color = Color.gray;
                break;
            }
            case 3: {
                color = Color.darkGray;
                break;
            }
            case 4: {
                color = Color.black;
            }
        }
        win.init(color);
        win.redraw(0, 0, win.backImage.getWidth(), win.backImage.getHeight());
    }

    public static void font(Context context, String name, Operand sizev, int sizevi, int style) {
        if (name == null) {
            context.error(5, "font", "name");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.font = new Font(name, style & 3, FunctionBase.toInt(sizev, sizevi, 18));
        win.fontStyle = style;
        Graphics2D g = win.backGraphics;
        g.setFont(win.font);
    }

    public static void sysfont(Context context, int type) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        switch (type) {
            case 0: {
                win.font = new Font("Monospaced", 0, 18);
                win.fontStyle = win.font.getStyle();
                break;
            }
            case 10: {
                win.font = new Font("Monospaced", 0, 18);
                win.fontStyle = win.font.getStyle();
                break;
            }
            case 11: {
                win.font = new Font("DialogInput", 0, 13);
                win.fontStyle = win.font.getStyle();
                break;
            }
            case 12: {
                win.font = new Font("Dialog", 0, 13);
                win.fontStyle = win.font.getStyle();
                break;
            }
            case 13: {
                win.font = new Font("Monospaced", 0, 18);
                win.fontStyle = win.font.getStyle();
                break;
            }
            case 17: {
                win.font = ((Bmscr)context.windows.get((int)0)).component.getFont();
                win.fontStyle = win.font.getStyle();
            }
        }
        Graphics2D g = win.backGraphics;
        g.setFont(win.font);
    }

    public static void objsize(Context context, Operand wv, int wvi, Operand hv, int hvi, int dy) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.owidth = FunctionBase.toInt(wv, wvi, 64);
        win.oheight = FunctionBase.toInt(hv, hvi, 24);
        win.mindy = dy;
    }

    public static void picload(Context context, String fileName, int mode) {
        if (fileName == null) {
            context.error(5, "picload", "fileName");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        try {
            InputStream in = context.getResource(fileName);
            if (in == null) {
                context.error(13, "picload", fileName);
                return;
            }
            try {
                BufferedImage image = ImageIO.read(in);
                if (mode == 0) {
                    win.init(Color.white, new Dimension(image.getWidth(), image.getHeight()));
                }
                win.backGraphics.drawImage((Image)image, win.cx, win.cy, null);
                win.redraw(win.cx, win.cy, image.getWidth(), image.getHeight());
                image.flush();
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            context.error(13, "picload", fileName);
        }
    }

    public static void color(Context context, int red, int green, int blue) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.color = new Color(red % 256, green % 256, blue % 256, 255);
        Graphics2D g = win.backGraphics;
        g.setColor(win.color);
    }

    public static void palcolor(Context context, Operand v, int vi) {
        context.error(21, "palcolor");
    }

    public static void palette(Context context, Operand v, int vi) {
        context.error(21, "palette");
    }

    public static void redraw(Context context, Operand modev, int modevi, int x, int y, Operand wv, int wvi, Operand hv, int hvi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.contents == null) {
            return;
        }
        int mode = FunctionBase.toInt(modev, modevi, 1);
        int w = FunctionBase.toInt(wv, wvi, win.contents.getWidth());
        int h = FunctionBase.toInt(hv, hvi, win.contents.getHeight());
        if (w < 0) {
            context.error(3, "width", "w==" + w);
            return;
        }
        if (h < 0) {
            context.error(3, "width", "h==" + h);
            return;
        }
        win.redraw = mode & 1;
        if ((mode & 2) == 0) {
            win.redraw(x, y, w, h);
        }
    }

    public static void width(Context context, Operand wv, int wvi, Operand hv, int hvi, Operand lv, int lvi, Operand tv, int tvi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.contents == null) {
            return;
        }
        int w = FunctionBase.toInt(wv, wvi, win.contents.getWidth());
        int h = FunctionBase.toInt(hv, hvi, win.contents.getHeight());
        if (w < 0) {
            context.error(3, "width", "w==" + w);
            return;
        }
        if (h < 0) {
            context.error(3, "width", "h==" + h);
            return;
        }
        if (win.contents != null) {
            win.contents.setPreferredSize(new Dimension(w, h));
            win.contents.setSize(w, h);
        }
        if (win.window != null) {
            int l = FunctionBase.toInt(hv, hvi, win.window.getX());
            int t = FunctionBase.toInt(tv, tvi, win.window.getY());
            ((Component)win.window).setLocation(l, t);
        }
    }

    public static void gsel(Context context, int id, int mode) {
        if (id < 0 || id >= context.windows.size() || context.windows.get(id) == null) {
            context.error(3, "gsel", "id==" + id);
        }
        context.targetWindow = id;
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        switch (mode) {
            case -1: {
                if (win.component == null) break;
                win.component.setVisible(false);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                if (win.component == null) break;
                win.component.setVisible(true);
                win.component.requestFocus();
                break;
            }
            case 2: {
                if (win.component != null) {
                    win.component.setVisible(true);
                    win.component.requestFocus();
                }
                context.error(21, "gsel", "mode==" + mode);
                break;
            }
            default: {
                context.error(3, "gsel", "mode==" + mode);
                return;
            }
        }
    }

    public static void gcopy(Context context, int srcId, int sx, int sy, Operand wv, int wvi, Operand hv, int hvi) {
        if (srcId < 0 || srcId >= context.windows.size() || context.windows.get(srcId) == null) {
            context.error(3, "gcopy", "srcId==" + srcId);
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        Bmscr src = (Bmscr)context.windows.get(srcId);
        int w = FunctionBase.toInt(wv, wvi, win.gwidth);
        int h = FunctionBase.toInt(hv, hvi, win.gheight);
        GraphicsRenderer.gcopy(win, win.cx, win.cy, src.backImage, sx, sy, w, h);
        win.redraw(win.cx, win.cy, w, h);
    }

    public static void gzoom(Context context, int dw, int dh, int srcId, int sx, int sy, Operand wv, int wvi, Operand hv, int hvi, int mode) {
        if (srcId < 0 || srcId >= context.windows.size() || context.windows.get(srcId) == null) {
            context.error(3, "gzoom", "srcId==" + srcId);
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        Bmscr src = (Bmscr)context.windows.get(srcId);
        int dx = win.cx;
        int dy = win.cy;
        int sw = FunctionBase.toInt(wv, wvi, win.gwidth);
        int sh = FunctionBase.toInt(hv, hvi, win.gheight);
        Object oldAntiAliasing = win.backGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldRenering = win.backGraphics.getRenderingHint(RenderingHints.KEY_RENDERING);
        boolean runningOnMac = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (dw < 0 || dh < 0 || sw < 0 || sh < 0) {
            int[] dxs = new int[]{dx, dx + dw, dx + dw, dx};
            int[] dys = new int[]{dy, dy, dy + dh, dy + dh};
            int[] sxs = new int[]{sx, sx + sw, sx + sw, sx};
            int[] sys = new int[]{sy, sy, sy + sh, sy + sh};
            int oldMode = win.gmode;
            win.gmode = 0;
            try {
                GraphicsRenderer.gsquare(win, dxs, dys, src.backImage, sxs, sys);
            }
            finally {
                win.gmode = oldMode;
            }
        } else {
            if (mode == 1) {
                win.backGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                win.backGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            win.backGraphics.drawImage(src.backImage, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
            win.backGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAliasing);
            win.backGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, oldRenering);
        }
        win.redraw(win.cx, win.cy, Math.abs(dw), Math.abs(dh));
    }

    public static void gmode(Context context, int mode, int w, int h, int alpha) {
        if (mode < 0 || mode >= 8) {
            context.error(3, "gmode", "mode==" + mode);
            return;
        }
        if (mode == 7) {
            context.error(21, "gmode", "mode==" + mode);
            return;
        }
        if (w < 0) {
            context.error(3, "gmode", "w==" + w);
            return;
        }
        if (h < 0) {
            context.error(3, "gmode", "h==" + h);
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.gmode = mode;
        win.gwidth = w;
        win.gheight = h;
        win.galpha = alpha >= 256 ? 256 : (alpha < 0 ? 0 : alpha);
        win.transColor = win.color;
    }

    public static void bmpsave(Context context, Operand v, int vi) {
        context.error(21, "bmpsave");
    }

    public static void hsvcolor(Context context, int h, int s, int v) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.color = Color.getHSBColor((float)(h % 192) / 192.0f, s > 256 ? 1.0f : (float)s / 256.0f, (float)v > 256.0f ? 1.0f : (float)v / 256.0f);
        Graphics2D g = win.backGraphics;
        g.setColor(win.color);
    }

    public static void getkey(Context context, Operand v, int vi, int key) {
        v.assign(vi, Scalar.fromValue(context.keyPressed[key] ? 1 : 0), 0);
    }

    public static void chkbox(Context context, String text, Operand v, int vi) {
        if (text == null) {
            context.error(5, "chkbox", "text");
            return;
        }
        if (v == null) {
            context.error(5, "chkbox", "v");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.contents != null) {
            Chkbox obj = new Chkbox(text, (Variable)v, vi);
            GuiCommand.addObject(context, win, obj, new Dimension(win.owidth, win.oheight));
        }
    }

    public static void listbobx(Context context, Operand v, int vi, int height, String items) {
        if (v == null) {
            context.error(5, "listbox", "v");
            return;
        }
        if (items == null) {
            context.error(5, "listbox", "items");
            return;
        }
        if (height < 0) {
            context.error(3, "combox", "height==" + height);
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.contents != null) {
            Listbox obj = new Listbox((Variable)v, vi, items.split("\\r?\\n"));
            GuiCommand.addObject(context, win, obj, new Dimension(win.owidth, win.oheight + height));
        }
    }

    public static void combox(Context context, Operand v, int vi, int height, String items) {
        if (v == null) {
            context.error(5, "combox", "v");
            return;
        }
        if (items == null) {
            context.error(5, "combox", "items");
            return;
        }
        if (height < 0) {
            context.error(3, "combox", "height==" + height);
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.contents != null) {
            Combox obj = new Combox((Variable)v, vi, items.split("\\r?\\n"));
            GuiCommand.addObject(context, win, obj, new Dimension(win.owidth, win.oheight));
            obj.setMaximumRowCount((win.oheight + height) / obj.getFont().getSize());
        }
    }

    public static void input(Context context, Operand v, int vi, Operand wv, int wvi, Operand hv, int hvi, int length, int password) {
        if (v == null) {
            context.error(5, "input", "v");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        int w = FunctionBase.toInt(wv, wvi, win.owidth);
        int h = FunctionBase.toInt(hv, hvi, win.oheight);
        if (w < 0) {
            context.error(3, "mesbox", "w==" + w);
            return;
        }
        if (h < 0) {
            context.error(3, "mesbox", "h==" + h);
            return;
        }
        if (win.contents != null) {
            if (password == 0) {
                Input obj = new Input((Variable)v, vi, length);
                GuiCommand.addObject(context, win, obj, new Dimension(w, h));
            } else {
                Password obj = new Password((Variable)v, vi, length);
                GuiCommand.addObject(context, win, obj, new Dimension(w, h));
            }
        }
    }

    public static void mesbox(Context context, Operand v, int vi, Operand wv, int wvi, Operand hv, int hvi, Operand typev, int typevi) {
        if (v == null) {
            context.error(5, "mesbox", "v");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        int w = FunctionBase.toInt(wv, wvi, win.owidth);
        int h = FunctionBase.toInt(hv, hvi, win.oheight);
        int type = FunctionBase.toInt(typev, typevi, 1);
        if (w < 0) {
            context.error(3, "mesbox", "w==" + w);
            return;
        }
        if (h < 0) {
            context.error(3, "mesbox", "h==" + h);
            return;
        }
        if (win.contents != null) {
            Mesbox obj = new Mesbox((Variable)v, vi, (type & 1) != 0, (type & 4) != 0);
            GuiCommand.addObject(context, win, obj, new Dimension(w, h));
        }
    }

    public static void buffer(Context context, int id, Operand wv, int wvi, Operand hv, int hvi) {
        if (id < 0) {
            context.error(3, "buffer", "id==" + id);
            return;
        }
        int w = FunctionBase.toInt(wv, wvi, 640);
        int h = FunctionBase.toInt(hv, hvi, 480);
        if (w < 0) {
            context.error(3, "screen", "w==" + w);
            return;
        }
        if (h < 0) {
            context.error(3, "screen", "h==" + h);
            return;
        }
        context.targetWindow = id;
        if (id == 0) {
            Bmscr win = (Bmscr)context.windows.get(0);
            win.init(Color.white, new Dimension(w, h));
            win.contents.setPreferredSize(new Dimension(w, h));
            win.contents.setSize(new Dimension(w, h));
            if (win.component != null) {
                win.component.setVisible(true);
            }
        } else {
            GuiCommand.setScreen(context, id, new Buffer(new Dimension(w, h)).getBmscr());
        }
    }

    public static void screen(Context context, int id, Operand wv, int wvi, Operand hv, int hvi, int mode, Operand lv, int lvi, Operand tv, int tvi, Operand vwv, int vwvi, Operand vhv, int vhvi) {
        if (id < 0) {
            context.error(3, "screen", "id==" + id);
            return;
        }
        int w = FunctionBase.toInt(wv, wvi, 640);
        int h = FunctionBase.toInt(hv, hvi, 480);
        int l = FunctionBase.toInt(lv, lvi, Integer.MIN_VALUE);
        int t = FunctionBase.toInt(tv, tvi, Integer.MIN_VALUE);
        int vw = FunctionBase.toInt(vwv, vwvi, w);
        int vh = FunctionBase.toInt(vhv, vhvi, h);
        if (w < 0) {
            context.error(3, "screen", "w==" + w);
            return;
        }
        if (h < 0) {
            context.error(3, "screen", "h==" + h);
            return;
        }
        if (vw < 0) {
            context.error(3, "screen", "vw==" + vw);
            return;
        }
        if (vh < 0) {
            context.error(3, "screen", "vh==" + vh);
            return;
        }
        context.targetWindow = id;
        if (id == 0) {
            Bmscr win = (Bmscr)context.windows.get(0);
            win.init(Color.white, new Dimension(w, h));
            win.contents.setPreferredSize(new Dimension(vw, vh));
            win.contents.setSize(new Dimension(vw, vh));
            if (win.component != null) {
                win.component.setVisible(true);
            }
        } else {
            Screen s = new Screen(new Dimension(w, h), mode, new Point(l, t), new Dimension(vw, vh));
            GuiCommand.setScreen(context, id, s.getBmscr());
            if ((mode & 2) == 0) {
                ((Component)s).setVisible(true);
            }
        }
    }

    public static void bgscr(Context context, int id, Operand wv, int wvi, Operand hv, int hvi, int mode, Operand lv, int lvi, Operand tv, int tvi, Operand vwv, int vwvi, Operand vhv, int vhvi) {
        if (id < 0) {
            context.error(3, "bgscr", "id==" + id);
            return;
        }
        int w = FunctionBase.toInt(wv, wvi, 640);
        int h = FunctionBase.toInt(hv, hvi, 480);
        int l = FunctionBase.toInt(lv, lvi, Integer.MIN_VALUE);
        int t = FunctionBase.toInt(tv, tvi, Integer.MIN_VALUE);
        int vw = FunctionBase.toInt(vwv, vwvi, w);
        int vh = FunctionBase.toInt(vhv, vhvi, h);
        if (w < 0) {
            context.error(3, "bgscr", "w==" + w);
            return;
        }
        if (h < 0) {
            context.error(3, "bgscr", "h==" + h);
            return;
        }
        if (vw < 0) {
            context.error(3, "bgscr", "vw==" + vw);
            return;
        }
        if (vh < 0) {
            context.error(3, "bgscr", "vh==" + vh);
            return;
        }
        context.targetWindow = id;
        if (id == 0) {
            Bmscr win = (Bmscr)context.windows.get(0);
            win.init(Color.white, new Dimension(w, h));
            win.contents.setPreferredSize(new Dimension(vw, vh));
            win.contents.setSize(new Dimension(vw, vh));
            if (win.component != null) {
                win.component.setVisible(true);
            }
        } else {
            Bgscr s = new Bgscr(new Dimension(w, h), mode, new Point(l, t), new Dimension(vw, vh));
            GuiCommand.setScreen(context, id, s.getBmscr());
            if ((mode & 2) == 0) {
                ((Component)s).setVisible(true);
            }
        }
    }

    private static void setScreen(Context context, int id, Bmscr screen) {
        while (context.windows.size() <= id) {
            context.windows.add(null);
        }
        if (context.windows.get(id) != null) {
            Bmscr existing = (Bmscr)context.windows.get(id);
            if (existing.window != null) {
                existing.window.dispose();
            } else if (existing.component != null) {
                if (existing.component.getParent() != null) {
                    existing.component.getParent().remove(existing.component);
                } else {
                    existing.component.setVisible(false);
                }
            }
        }
        context.windows.set(id, screen);
        context.listener.listen(screen);
    }

    public static void mouse(Context context, Operand v, int vi) {
        context.error(21, "mouse");
    }

    public static void objsel(Context context, int id) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (id < 0) {
            context.stat.value = 0;
            int i = 0;
            while (i < win.controls.size()) {
                if (win.controls.get(i) != null && ((HSPControl)win.controls.get(i)).asComponent().hasFocus()) {
                    context.stat.value = i;
                    return;
                }
                ++i;
            }
        } else if (id < win.controls.size() && win.controls.get(id) != null) {
            ((HSPControl)win.controls.get(id)).asComponent().requestFocus();
        }
    }

    public static void groll(Context context, int x, int y) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        win.originx = x;
        win.originy = y;
        win.redraw(0, 0, win.backImage.getWidth(), win.backImage.getHeight());
    }

    public static void line(Context context, int x2, int y2, Operand x1v, int x1vi, Operand y1v, int y1vi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        Graphics2D g = win.backGraphics;
        int x1 = FunctionBase.toInt(x1v, x1vi, win.cx);
        int y1 = FunctionBase.toInt(y1v, y1vi, win.cy);
        if (x2 >= 0 && y2 >= 0 && x2 < win.backImage.getWidth() && y2 < win.backImage.getHeight()) {
            int last = win.backImage.getRGB(x2, y2);
            g.drawLine(x1, y1, x2, y2);
            win.backImage.setRGB(x2, y2, last);
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
        win.cx = x2;
        win.cy = y2;
        int l = Math.min(x1, x2);
        int t = Math.min(y1, y2);
        int r = Math.max(x1, x2);
        int b = Math.max(y1, y2);
        win.redraw(l, t, r - l, b - t);
    }

    public static void clrobj(Context context, int start, Operand ev, int evi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        int end = Math.min(win.controls.size(), (FunctionBase.toInt(ev, evi, -1) & 0xFFFFFF) + 1);
        if (win.contents != null) {
            int i = start;
            while (i < end) {
                if (win.controls.get(i) != null) {
                    win.contents.remove(((HSPControl)win.controls.get(i)).asComponent());
                    win.controls.set(i, null);
                }
                ++i;
            }
        }
    }

    public static void boxf(Context context, int x1, int y1, Operand x2v, int x2vi, Operand y2v, int y2vi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        Graphics2D g = win.backGraphics;
        int x2 = FunctionBase.toInt(x2v, x2vi, win.backImage.getWidth() - 1);
        int y2 = FunctionBase.toInt(y2v, y2vi, win.backImage.getHeight() - 1);
        int l = Math.min(x1, x2);
        int t = Math.min(y1, y2);
        int r = Math.max(x1, x2) + 1;
        int b = Math.max(y1, y2) + 1;
        g.fillRect(l, t, r - l, b - t);
        win.redraw(l, t, r - l, b - t);
    }

    public static void objprm(Context context, int id, Operand v, int vi) {
        if (v == null) {
            context.error(5, "objprm", "v");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.controls.get(id) != null) {
            ((HSPControl)win.controls.get(id)).setValue(v, vi);
        }
    }

    public static void objmode(Context context, int fontMode, int tabMode) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        switch (fontMode) {
            case 0: {
                win.objfont = new Font("Monospaced", 0, 16);
                break;
            }
            case 1: {
                win.objfont = null;
                break;
            }
            case 2: {
                win.objfont = win.font;
            }
        }
    }

    public static void stick(Context context, Operand v, int vi, int notrigerMask) {
        if (v == null) {
            context.error(5, "stick", "v");
            return;
        }
        if (context.stickTriggerTime < System.currentTimeMillis() - 500L) {
            context.stickTrigger = 0;
        }
        v.assign(vi, Scalar.fromValue(context.stickState & notrigerMask | context.stickTrigger & ~notrigerMask), 0);
        context.stickTrigger = 0;
    }

    public static void grect(Context context, int cx, int cy, double angle, Operand wv, int wvi, Operand hv, int hvi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        int sw = FunctionBase.toInt(wv, wvi, win.gwidth);
        int sh = FunctionBase.toInt(hv, hvi, win.gheight);
        int w = sw / 2 - 1;
        int h = sh / 2 - 1;
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        int[] dx = new int[]{(int)((double)(-w) * co + (double)h * si) + cx - 1, (int)((double)w * co + (double)h * si) + cx - 1, (int)((double)w * co - (double)h * si) + cx - 1, (int)((double)(-w) * co - (double)h * si) + cx - 1};
        int[] dy = new int[]{(int)((double)(-w) * si - (double)h * co) + cy - 1, (int)((double)w * si - (double)h * co) + cy - 1, (int)((double)w * si + (double)h * co) + cy - 1, (int)((double)(-w) * si + (double)h * co) + cy - 1};
        GraphicsRenderer.gsquare(win, dx, dy);
        int l = Math.min(Math.min(Math.min(dx[0], dx[1]), dx[2]), dx[3]);
        int t = Math.min(Math.min(Math.min(dy[0], dy[1]), dy[2]), dy[3]);
        int r = Math.max(Math.max(Math.max(dx[0], dx[1]), dx[2]), dx[3]);
        int b = Math.max(Math.max(Math.max(dy[0], dy[1]), dy[2]), dy[3]);
        win.redraw(l, t, r - l, b - t);
    }

    public static void grotate(Context context, int id, int sx, int sy, double angle, Operand dwv, int dwi, Operand dhv, int dhi) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        int dw = FunctionBase.toInt(dwv, dwi, win.gwidth);
        int dh = FunctionBase.toInt(dhv, dhi, win.gheight);
        double w = (double)(dw / 2) - 0.5;
        double h = (double)(dh / 2) - 0.5;
        int cx = win.cx;
        int cy = win.cy;
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        int[] dx = new int[]{(int)Math.round(-w * co + h * si) + cx, (int)Math.round(w * co + h * si) + cx, (int)Math.round(w * co - h * si) + cx, (int)Math.round(-w * co - h * si) + cx};
        int[] dy = new int[]{(int)Math.round(-w * si - h * co) + cy, (int)Math.round(w * si - h * co) + cy, (int)Math.round(w * si + h * co) + cy, (int)Math.round(-w * si + h * co) + cy};
        int[] sxs = new int[]{sx, sx + win.gwidth - 1, sx + win.gwidth - 1, sx};
        int[] sys = new int[]{sy, sy, sy + win.gheight - 1, sy + win.gheight - 1};
        GraphicsRenderer.gsquare(win, dx, dy, ((Bmscr)context.windows.get((int)id)).backImage, sxs, sys);
        int l = Math.min(Math.min(Math.min(dx[0], dx[1]), dx[2]), dx[3]);
        int t = Math.min(Math.min(Math.min(dy[0], dy[1]), dy[2]), dy[3]);
        int r = Math.max(Math.max(Math.max(dx[0], dx[1]), dx[2]), dx[3]);
        int b = Math.max(Math.max(Math.max(dy[0], dy[1]), dy[2]), dy[3]);
        win.redraw(l, t, r - l, b - t);
    }

    public static void gsquare(Context context, int id, Operand dxs, int dxi, Operand dys, int dyi, Operand sxs, int sxi, Operand sys, int syi) {
        if (dxs == null) {
            context.error(5, "gsquare", "dxs");
            return;
        }
        if (dys == null) {
            context.error(5, "gsquare", "dys");
            return;
        }
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        int[] dx = new int[]{dxs.toInt(dxi), dxs.toInt(dxi + 1), dxs.toInt(dxi + 2), dxs.toInt(dxi + 3)};
        int[] dy = new int[]{dys.toInt(dyi), dys.toInt(dyi + 1), dys.toInt(dyi + 2), dys.toInt(dyi + 3)};
        if (id >= 0) {
            if (id >= context.windows.size() || context.windows.get(id) == null) {
                context.error(3, "gsquare", "id==" + id);
                return;
            }
            if (sxs == null) {
                context.error(5, "gsquare", "sxs");
                return;
            }
            if (sys == null) {
                context.error(5, "gsquare", "sys");
                return;
            }
            int[] sx = new int[]{sxs.toInt(sxi), sxs.toInt(sxi + 1), sxs.toInt(sxi + 2), sxs.toInt(sxi + 3)};
            int[] sy = new int[]{sys.toInt(syi), sys.toInt(syi + 1), sys.toInt(syi + 2), sys.toInt(syi + 3)};
            GraphicsRenderer.gsquare(win, dx, dy, ((Bmscr)context.windows.get((int)id)).backImage, sx, sy);
        } else {
            GraphicsRenderer.gsquare(win, dx, dy);
        }
        int l = Math.min(Math.min(Math.min(dx[0], dx[1]), dx[2]), dx[3]);
        int t = Math.min(Math.min(Math.min(dy[0], dy[1]), dy[2]), dy[3]);
        int r = Math.max(Math.max(Math.max(dx[0], dx[1]), dx[2]), dx[3]);
        int b = Math.max(Math.max(Math.max(dy[0], dy[1]), dy[2]), dy[3]);
        win.redraw(l, t, r - l, b - t);
    }
}

