/*
 * Decompiled with CFR 0.152.
 */
package hsplet.variable;

import hsplet.variable.ByteString;
import hsplet.variable.DoubleScalar;
import hsplet.variable.IntScalar;
import hsplet.variable.Label;
import hsplet.variable.Operand;
import hsplet.variable.StringScalar;

public abstract class Scalar
extends Operand {
    private static final String fileVersionID = "$Id: Scalar.java,v 1.3 2006/02/11 18:00:37 Yuki Exp $";
    private static final Scalar[] intCache = new Scalar[256];

    static {
        int i = 0;
        while (i < intCache.length) {
            Scalar.intCache[i] = new IntScalar(i - 128);
            ++i;
        }
    }

    public static Scalar fromValue(String rawValue) {
        return new StringScalar(rawValue);
    }

    public static Scalar fromValue(ByteString rawValue) {
        return new StringScalar(rawValue);
    }

    public static Scalar fromValue(double rawValue) {
        return new DoubleScalar(rawValue);
    }

    public static Scalar fromValue(int rawValue) {
        if (rawValue >= -128 && rawValue <= 127) {
            return intCache[rawValue + 128];
        }
        return new IntScalar(rawValue);
    }

    public static Scalar fromLabel(int rawValue) {
        return new Label(rawValue);
    }

    public int getIndex(int i0, int i1) {
        return 0;
    }

    public int getIndex(int i0, int i1, int i2) {
        return 0;
    }

    public int getIndex(int i0, int i1, int i2, int i3) {
        return 0;
    }

    public int l0() {
        return 1;
    }

    public int l1() {
        return 1;
    }

    public int l2() {
        return 1;
    }

    public int l3() {
        return 1;
    }
}

