/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.internal.zzrd;
import java.util.Date;
import java.util.Set;

@zzmb
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
MediationRewardedVideoAdAdapter,
zzrd {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    protected AdView zzcC;
    protected InterstitialAd zzcD;
    private AdLoader zzcE;
    private Context zzcF;
    private InterstitialAd zzcG;
    private MediationRewardedVideoAdListener zzcH;
    final RewardedVideoAdListener zzcI = new RewardedVideoAdListener(){

        @Override
        public void onRewardedVideoAdLoaded() {
            AbstractAdViewAdapter.this.zzcH.onAdLoaded(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdOpened() {
            AbstractAdViewAdapter.this.zzcH.onAdOpened(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoStarted() {
            AbstractAdViewAdapter.this.zzcH.onVideoStarted(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdClosed() {
            AbstractAdViewAdapter.this.zzcH.onAdClosed(AbstractAdViewAdapter.this);
            AbstractAdViewAdapter.this.zzcG = null;
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {
            AbstractAdViewAdapter.this.zzcH.onRewarded(AbstractAdViewAdapter.this, rewardItem);
        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            AbstractAdViewAdapter.this.zzcH.onAdLeftApplication(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int n) {
            AbstractAdViewAdapter.this.zzcH.onAdFailedToLoad(AbstractAdViewAdapter.this, n);
        }
    };

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(zzeh.zzeO().zzO(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzcC != null) {
            this.zzcC.destroy();
            this.zzcC = null;
        }
        if (this.zzcD != null) {
            this.zzcD = null;
        }
        if (this.zzcE != null) {
            this.zzcE = null;
        }
        if (this.zzcG != null) {
            this.zzcG = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzcC != null) {
            this.zzcC.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzcC != null) {
            this.zzcC.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcC = new AdView(context);
        this.zzcC.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzcC.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcC.setAdListener(new zzc(this, mediationBannerListener));
        this.zzcC.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzcC;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcD = new InterstitialAd(context);
        this.zzcD.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcD.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzcD.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showInterstitial() {
        this.zzcD.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzak(1).zzlL();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        AdLoader.Builder builder = this.zza(context, bundle.getString(AD_UNIT_ID_PARAMETER)).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        this.zzcE = builder.build();
        this.zzcE.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    AdLoader.Builder zza(Context context, String string) {
        return new AdLoader.Builder(context, string);
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzcF = context.getApplicationContext();
        this.zzcH = mediationRewardedVideoAdListener;
        this.zzcH.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzcF == null || this.zzcH == null) {
            zzpy.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzcG = new InterstitialAd(this.zzcF);
        this.zzcG.zzd(true);
        this.zzcG.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcG.setRewardedVideoAdListener(this.zzcI);
        this.zzcG.loadAd(this.zza(this.zzcF, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzcG.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzcH != null;
    }

    static class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzcL;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzcL = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcL);
            }
        }
    }

    static class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzcK;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzcK = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcK);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    zzdt {
        final AbstractAdViewAdapter zzcM;
        final MediationNativeListener zzcP;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzcM = abstractAdViewAdapter;
            this.zzcP = mediationNativeListener;
        }

        @Override
        public void onAdLoaded() {
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzcP.onAdFailedToLoad(this.zzcM, n);
        }

        @Override
        public void onAdOpened() {
            this.zzcP.onAdOpened(this.zzcM);
        }

        @Override
        public void onAdClosed() {
            this.zzcP.onAdClosed(this.zzcM);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzcP.onAdLeftApplication(this.zzcM);
        }

        @Override
        public void onAdClicked() {
            this.zzcP.onAdClicked(this.zzcM);
        }

        @Override
        public void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzcP.onAdLoaded(this.zzcM, new zza(nativeAppInstallAd));
        }

        @Override
        public void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzcP.onAdLoaded(this.zzcM, new zzb(nativeContentAd));
        }
    }

    static final class zzd
    extends AdListener
    implements zzdt {
        final AbstractAdViewAdapter zzcM;
        final MediationInterstitialListener zzcO;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzcM = abstractAdViewAdapter;
            this.zzcO = mediationInterstitialListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzcO.onAdLoaded(this.zzcM);
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzcO.onAdFailedToLoad(this.zzcM, n);
        }

        @Override
        public void onAdOpened() {
            this.zzcO.onAdOpened(this.zzcM);
        }

        @Override
        public void onAdClosed() {
            this.zzcO.onAdClosed(this.zzcM);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzcO.onAdLeftApplication(this.zzcM);
        }

        @Override
        public void onAdClicked() {
            this.zzcO.onAdClicked(this.zzcM);
        }
    }

    static final class zzc
    extends AdListener
    implements zzdt {
        final AbstractAdViewAdapter zzcM;
        final MediationBannerListener zzcN;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzcM = abstractAdViewAdapter;
            this.zzcN = mediationBannerListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzcN.onAdLoaded(this.zzcM);
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzcN.onAdFailedToLoad(this.zzcM, n);
        }

        @Override
        public void onAdOpened() {
            this.zzcN.onAdOpened(this.zzcM);
        }

        @Override
        public void onAdClosed() {
            this.zzcN.onAdClosed(this.zzcM);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzcN.onAdLeftApplication(this.zzcM);
        }

        @Override
        public void onAdClicked() {
            this.zzcN.onAdClicked(this.zzcM);
        }
    }
}

