/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T zzaQd;
    private Bundle zzaQe;
    private LinkedList<zza> zzaQf;
    private final zzf<T> zzaQg = new zzf<T>(){

        public void zza(T t) {
            zza.this.zzaQd = t;
            for (zza zza2 : zza.this.zzaQf) {
                zza2.zzb(zza.this.zzaQd);
            }
            zza.this.zzaQf.clear();
            zza.this.zzaQe = null;
        }
    };

    public T zzAY() {
        return this.zzaQd;
    }

    private void zzgk(int n) {
        while (!this.zzaQf.isEmpty() && this.zzaQf.getLast().getState() >= n) {
            this.zzaQf.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.zzaQd != null) {
            zza2.zzb((LifecycleDelegate)this.zzaQd);
            return;
        }
        if (this.zzaQf == null) {
            this.zzaQf = new LinkedList();
        }
        this.zzaQf.add(zza2);
        if (bundle != null) {
            if (this.zzaQe == null) {
                this.zzaQe = (Bundle)bundle.clone();
            } else {
                this.zzaQe.putAll(bundle);
            }
        }
        this.zza(this.zzaQg);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle bundle, final Bundle bundle2) {
        this.zza(bundle2, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaQd.onInflate(activity, bundle, bundle2);
            }
        });
    }

    public void onCreate(final Bundle bundle) {
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaQd.onCreate(bundle);
            }
        });
    }

    public View onCreateView(final LayoutInflater layoutInflater, final ViewGroup viewGroup, final Bundle bundle) {
        final FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.zzaQd.onCreateView(layoutInflater, viewGroup, bundle));
            }
        });
        if (this.zzaQd == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        zza.zza(frameLayout, GoogleApiAvailability.getInstance());
    }

    @VisibleForTesting
    static void zza(FrameLayout frameLayout, GoogleApiAvailability googleApiAvailability) {
        final Context context = frameLayout.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = zzh.zzi(context, n);
        String string3 = zzh.zzk(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        final Intent intent = googleApiAvailability.zzb(context, n, null);
        if (intent != null) {
            Button button = new Button(context);
            button.setId(16908313);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        context.startActivity(intent);
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Log.e((String)"DeferredLifecycleHelper", (String)"Failed to start resolution intent", (Throwable)activityNotFoundException);
                    }
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaQd.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaQd.onResume();
            }
        });
    }

    public void onPause() {
        if (this.zzaQd != null) {
            this.zzaQd.onPause();
        } else {
            this.zzgk(5);
        }
    }

    public void onStop() {
        if (this.zzaQd != null) {
            this.zzaQd.onStop();
        } else {
            this.zzgk(4);
        }
    }

    public void onDestroyView() {
        if (this.zzaQd != null) {
            this.zzaQd.onDestroyView();
        } else {
            this.zzgk(2);
        }
    }

    public void onDestroy() {
        if (this.zzaQd != null) {
            this.zzaQd.onDestroy();
        } else {
            this.zzgk(1);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.zzaQd != null) {
            this.zzaQd.onSaveInstanceState(bundle);
        } else if (this.zzaQe != null) {
            bundle.putAll(this.zzaQe);
        }
    }

    public void onLowMemory() {
        if (this.zzaQd != null) {
            this.zzaQd.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

