/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzqp;
import java.util.Map;
import java.util.Set;

@zzmb
public class zzkj
extends zzko {
    static final Set<String> zzLq = zzf.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzLr = "top-right";
    private boolean zzLs = true;
    private int zzLt = 0;
    private int zzLu = 0;
    private int zzrH = -1;
    private int zzLv = 0;
    private int zzLw = 0;
    private int zzrG = -1;
    private final Object zzrN = new Object();
    private final zzqp zzGt;
    private final Activity zzLg;
    private zzec zzum;
    private ImageView zzLx;
    private LinearLayout zzLy;
    private zzkp zzLz;
    private PopupWindow zzLA;
    private RelativeLayout zzLB;
    private ViewGroup zzLC;

    public zzkj(zzqp zzqp2, zzkp zzkp2) {
        super(zzqp2, "resize");
        this.zzGt = zzqp2;
        this.zzLg = zzqp2.zzkR();
        this.zzLz = zzkp2;
    }

    private void zzj(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzrG = zzv.zzcJ().zzaW(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzrH = zzv.zzcJ().zzaW(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzLv = zzv.zzcJ().zzaW(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzLw = zzv.zzcJ().zzaW(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzLs = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzLr = string2;
        }
    }

    boolean zzgP() {
        return this.zzrG > -1 && this.zzrH > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, String> map) {
        Object object = this.zzrN;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzLg == null) {
                this.zzay("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzGt.zzbD() == null) {
                this.zzay("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzGt.zzbD().zzzl) {
                this.zzay("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzGt.zzkZ()) {
                this.zzay("Cannot resize an expanded banner.");
                return;
            }
            this.zzj(map);
            if (!this.zzgP()) {
                this.zzay("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzLg.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzay("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzgQ();
            if (nArray == null) {
                this.zzay("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzeh.zzeO().zzb((Context)this.zzLg, this.zzrG);
            int n2 = zzeh.zzeO().zzb((Context)this.zzLg, this.zzrH);
            ViewParent viewParent = this.zzGt.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzGt.getView());
                if (this.zzLA == null) {
                    this.zzLC = (ViewGroup)viewParent;
                    bitmap = zzv.zzcJ().zzp(this.zzGt.getView());
                    this.zzLx = new ImageView((Context)this.zzLg);
                    this.zzLx.setImageBitmap(bitmap);
                    this.zzum = this.zzGt.zzbD();
                    this.zzLC.addView((View)this.zzLx);
                } else {
                    this.zzLA.dismiss();
                }
            } else {
                this.zzay("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzLB = new RelativeLayout((Context)this.zzLg);
            this.zzLB.setBackgroundColor(0);
            this.zzLB.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzLA = zzv.zzcJ().zza((View)this.zzLB, n, n2, false);
            this.zzLA.setOutsideTouchable(true);
            this.zzLA.setTouchable(true);
            this.zzLA.setClippingEnabled(!this.zzLs);
            this.zzLB.addView(this.zzGt.getView(), -1, -1);
            this.zzLy = new LinearLayout((Context)this.zzLg);
            bitmap = new RelativeLayout.LayoutParams(zzeh.zzeO().zzb((Context)this.zzLg, 50), zzeh.zzeO().zzb((Context)this.zzLg, 50));
            switch (this.zzLr) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzLy.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzkj.this.zzs(true);
                }
            });
            this.zzLy.setContentDescription((CharSequence)"Close button");
            this.zzLB.addView((View)this.zzLy, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzLA.showAtLocation(window.getDecorView(), 0, zzeh.zzeO().zzb((Context)this.zzLg, nArray[0]), zzeh.zzeO().zzb((Context)this.zzLg, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(runtimeException.getMessage());
                this.zzay(string2.length() != 0 ? "Cannot show popup window: ".concat(string2) : new String("Cannot show popup window: "));
                this.zzLB.removeView(this.zzGt.getView());
                if (this.zzLC != null) {
                    this.zzLC.removeView((View)this.zzLx);
                    this.zzLC.addView(this.zzGt.getView());
                    this.zzGt.zza(this.zzum);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzGt.zza(new zzec((Context)this.zzLg, new AdSize(this.zzrG, this.zzrH)));
            this.zzc(nArray[0], nArray[1]);
            this.zzaA("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzs(boolean bl) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzLA != null) {
                this.zzLA.dismiss();
                this.zzLB.removeView(this.zzGt.getView());
                if (this.zzLC != null) {
                    this.zzLC.removeView((View)this.zzLx);
                    this.zzLC.addView(this.zzGt.getView());
                    this.zzGt.zza(this.zzum);
                }
                if (bl) {
                    this.zzaA("default");
                    if (this.zzLz != null) {
                        this.zzLz.zzbZ();
                    }
                }
                this.zzLA = null;
                this.zzLB = null;
                this.zzLC = null;
                this.zzLy = null;
            }
        }
    }

    private int[] zzgQ() {
        if (!this.zzgS()) {
            return null;
        }
        if (this.zzLs) {
            return new int[]{this.zzLt + this.zzLv, this.zzLu + this.zzLw};
        }
        int[] nArray = zzv.zzcJ().zzi(this.zzLg);
        int[] nArray2 = zzv.zzcJ().zzk(this.zzLg);
        int n = nArray[0];
        int n2 = this.zzLt + this.zzLv;
        int n3 = this.zzLu + this.zzLw;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzrG > n) {
            n2 = n - this.zzrG;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzrH > nArray2[1]) {
            n3 = nArray2[1] - this.zzrH;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzLt = n;
            this.zzLu = n2;
            if (this.zzLA != null && bl) {
                int[] nArray = this.zzgQ();
                if (nArray != null) {
                    this.zzLA.update(zzeh.zzeO().zzb((Context)this.zzLg, nArray[0]), zzeh.zzeO().zzb((Context)this.zzLg, nArray[1]), this.zzLA.getWidth(), this.zzLA.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzs(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzLz != null) {
            this.zzLz.zza(n, n2, this.zzrG, this.zzrH);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzv.zzcJ().zzk(this.zzLg)[0];
        this.zzb(n, n2 - n3, this.zzrG, this.zzrH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzgR() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzLA != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzLt = n;
        this.zzLu = n2;
    }

    boolean zzgS() {
        int[] nArray = zzv.zzcJ().zzi(this.zzLg);
        int[] nArray2 = zzv.zzcJ().zzk(this.zzLg);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzrG < 50 || this.zzrG > n) {
            zzpe.zzbe((String)"Width is too small or too large.");
            return false;
        }
        if (this.zzrH < 50 || this.zzrH > n2) {
            zzpe.zzbe((String)"Height is too small or too large.");
            return false;
        }
        if (this.zzrH == n2 && this.zzrG == n) {
            zzpe.zzbe((String)"Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzLs) {
            int n3;
            int n4;
            switch (this.zzLr) {
                case "top-left": {
                    n4 = this.zzLt + this.zzLv;
                    n3 = this.zzLu + this.zzLw;
                    break;
                }
                case "top-center": {
                    n4 = this.zzLt + this.zzLv + this.zzrG / 2 - 25;
                    n3 = this.zzLu + this.zzLw;
                    break;
                }
                case "center": {
                    n4 = this.zzLt + this.zzLv + this.zzrG / 2 - 25;
                    n3 = this.zzLu + this.zzLw + this.zzrH / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = this.zzLt + this.zzLv;
                    n3 = this.zzLu + this.zzLw + this.zzrH - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = this.zzLt + this.zzLv + this.zzrG / 2 - 25;
                    n3 = this.zzLu + this.zzLw + this.zzrH - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = this.zzLt + this.zzLv + this.zzrG - 50;
                    n3 = this.zzLu + this.zzLw + this.zzrH - 50;
                    break;
                }
                default: {
                    n4 = this.zzLt + this.zzLv + this.zzrG - 50;
                    n3 = this.zzLu + this.zzLw;
                }
            }
            if (n4 < 0 || n4 + 50 > n || n3 < nArray2[0] || n3 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

