/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;

public abstract class ResultCallbacks<R extends Result>
implements ResultCallback<R> {
    @Override
    public final void onResult(@NonNull R r) {
        Status status = r.getStatus();
        if (status.isSuccess()) {
            this.onSuccess(r);
        } else {
            this.onFailure(status);
            if (r instanceof Releasable) {
                try {
                    ((Releasable)r).release();
                }
                catch (RuntimeException runtimeException) {
                    String string2 = String.valueOf(r);
                    Log.w((String)"ResultCallbacks", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
                }
            }
        }
    }

    public abstract void onSuccess(@NonNull R var1);

    public abstract void onFailure(@NonNull Status var1);
}

