/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzabg;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzzx;
import java.lang.ref.WeakReference;

public class zzabp<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzaBM = null;
    private zzabp<? extends Result> zzaBN = null;
    private volatile ResultCallbacks<? super R> zzaBO = null;
    private PendingResult<R> zzaBP = null;
    private final Object zzayO = new Object();
    private Status zzaBQ = null;
    private final WeakReference<GoogleApiClient> zzayQ;
    private final zza zzaBR;
    private boolean zzaBS = false;

    public zzabp(WeakReference<GoogleApiClient> weakReference) {
        zzac.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzayQ = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzayQ.get();
        this.zzaBR = new zza(googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzayO;
        synchronized (object) {
            zzac.zza((this.zzaBM == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzac.zza((this.zzaBO == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaBM = resultTransform;
            zzabp<R> zzabp2 = new zzabp<R>(this.zzayQ);
            this.zzaBN = zzabp2;
            this.zzwt();
            return zzabp2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzayO;
        synchronized (object) {
            zzac.zza((this.zzaBO == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzac.zza((this.zzaBM == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaBO = resultCallbacks;
            this.zzwt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(R r) {
        Object object = this.zzayO;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzaBM != null) {
                    zzabg.zzvR().submit(new Runnable((Result)r){
                        final /* synthetic */ Result zzaBT;
                        {
                            this.zzaBT = result;
                        }

                        @Override
                        @WorkerThread
                        public void run() {
                            try {
                                zzzx.zzayN.set(true);
                                PendingResult pendingResult = zzabp.this.zzaBM.onSuccess(this.zzaBT);
                                zzabp.this.zzaBR.sendMessage(zzabp.this.zzaBR.obtainMessage(0, pendingResult));
                            }
                            catch (RuntimeException runtimeException) {
                                zzabp.this.zzaBR.sendMessage(zzabp.this.zzaBR.obtainMessage(1, runtimeException));
                            }
                            finally {
                                zzzx.zzayN.set(false);
                                zzabp.this.zzd(this.zzaBT);
                                GoogleApiClient googleApiClient = (GoogleApiClient)zzabp.this.zzayQ.get();
                                if (googleApiClient != null) {
                                    googleApiClient.zzb(zzabp.this);
                                }
                            }
                        }
                    });
                } else if (this.zzwv()) {
                    this.zzaBO.onSuccess(r);
                }
            } else {
                this.zzD(r.getStatus());
                this.zzd((Result)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(PendingResult<?> pendingResult) {
        Object object = this.zzayO;
        synchronized (object) {
            this.zzaBP = pendingResult;
            this.zzwt();
        }
    }

    private void zzwt() {
        if (this.zzaBM == null && this.zzaBO == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzayQ.get();
        if (!this.zzaBS && this.zzaBM != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzaBS = true;
        }
        if (this.zzaBQ != null) {
            this.zzE(this.zzaBQ);
        } else if (this.zzaBP != null) {
            this.zzaBP.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzD(Status status) {
        Object object = this.zzayO;
        synchronized (object) {
            this.zzaBQ = status;
            this.zzE(this.zzaBQ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzE(Status status) {
        Object object = this.zzayO;
        synchronized (object) {
            if (this.zzaBM != null) {
                Status status2 = this.zzaBM.onFailure(status);
                zzac.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzD(status2);
            } else if (this.zzwv()) {
                this.zzaBO.onFailure(status);
            }
        }
    }

    void zzwu() {
        this.zzaBO = null;
    }

    private boolean zzwv() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzayQ.get();
        return this.zzaBO != null && googleApiClient != null;
    }

    private void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    PendingResult pendingResult = (PendingResult)message.obj;
                    Object object = zzabp.this.zzayO;
                    synchronized (object) {
                        if (pendingResult == null) {
                            ((zzabp)zzabp.this.zzaBN).zzD(new Status(13, "Transform returned null"));
                        } else if (pendingResult instanceof zzabh) {
                            ((zzabp)zzabp.this.zzaBN).zzD(((zzabh)pendingResult).getStatus());
                        } else {
                            zzabp.this.zzaBN.zza(pendingResult);
                        }
                        break;
                    }
                }
                case 1: {
                    RuntimeException runtimeException = (RuntimeException)message.obj;
                    String string2 = String.valueOf(runtimeException.getMessage());
                    Log.e((String)"TransformedResultImpl", (String)(string2.length() != 0 ? "Runtime exception on the transformation worker thread: ".concat(string2) : new String("Runtime exception on the transformation worker thread: ")));
                    throw runtimeException;
                }
                default: {
                    int n = message.what;
                    Log.e((String)"TransformedResultImpl", (String)new StringBuilder(70).append("TransformationResultHandler received unknown message type: ").append(n).toString());
                }
            }
        }
    }
}

