/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzaal;
import com.google.android.gms.internal.zzaan;
import com.google.android.gms.internal.zzaau;
import com.google.android.gms.internal.zzabi;
import com.google.android.gms.internal.zzaxn;
import com.google.android.gms.internal.zzaxo;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.internal.zzzy;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzaaa
implements zzaau {
    private final Context mContext;
    private final zzaal zzazd;
    private final Looper zzrx;
    private final zzaan zzaze;
    private final zzaan zzazf;
    private final Map<Api.zzc<?>, zzaan> zzazg;
    private final Set<zzabi> zzazh = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzazi;
    private Bundle zzazj;
    private ConnectionResult zzazk = null;
    private ConnectionResult zzazl = null;
    private boolean zzazm = false;
    private final Lock zzazn;
    private int zzazo = 0;

    public static zzaaa zza(Context context, zzaal zzaal2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zzaxn, zzaxo> zza2, ArrayList<zzzy> arrayList) {
        Object object;
        Api.zze zze2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzqS()) {
                zze2 = object;
            }
            if (object.zzqD()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzac.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc3 = api.zzuH();
            if (arrayMap2.containsKey(zzc3)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc3)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the apiTypeMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzzy>();
        ArrayList<zzzy> arrayList2 = new ArrayList<zzzy>();
        for (zzzy zzzy2 : arrayList) {
            if (arrayMap5.containsKey(zzzy2.zzawb)) {
                ((ArrayList)object).add(zzzy2);
                continue;
            }
            if (arrayMap.containsKey(zzzy2.zzawb)) {
                arrayList2.add(zzzy2);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the apiTypeMap");
        }
        return new zzaaa(context, zzaal2, lock, looper, zzc2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzg2, zza2, zze2, (ArrayList<zzzy>)object, arrayList2, (Map<Api<?>, Integer>)arrayMap5, (Map<Api<?>, Integer>)arrayMap);
    }

    private zzaaa(Context context, zzaal zzaal2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzg zzg2, Api.zza<? extends zzaxn, zzaxo> zza2, Api.zze zze2, ArrayList<zzzy> arrayList, ArrayList<zzzy> arrayList2, Map<Api<?>, Integer> map3, Map<Api<?>, Integer> map4) {
        this.mContext = context;
        this.zzazd = zzaal2;
        this.zzazn = lock;
        this.zzrx = looper;
        this.zzazi = zze2;
        this.zzaze = new zzaan(context, this.zzazd, lock, looper, zzc2, map2, null, map4, null, arrayList2, new zza());
        this.zzazf = new zzaan(context, this.zzazd, lock, looper, zzc2, map, zzg2, map3, zza2, arrayList, new zzb());
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc3 : map2.keySet()) {
            arrayMap.put(zzc3, (Object)this.zzaze);
        }
        for (Api.zzc<?> zzc3 : map.keySet()) {
            arrayMap.put(zzc3, (Object)this.zzazf);
        }
        this.zzazg = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzzv.zza<R, A>> T zza(@NonNull T t) {
        if (this.zzc(t)) {
            if (this.zzvp()) {
                t.zzA(new Status(4, null, this.zzvq()));
                return t;
            }
            return this.zzazf.zza(t);
        }
        return this.zzaze.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzzv.zza<? extends Result, A>> T zzb(@NonNull T t) {
        if (this.zzc(t)) {
            if (this.zzvp()) {
                t.zzA(new Status(4, null, this.zzvq()));
                return t;
            }
            return this.zzazf.zzb(t);
        }
        return this.zzaze.zzb(t);
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzazg.get(api.zzuH()).equals(this.zzazf)) {
            if (this.zzvp()) {
                return new ConnectionResult(4, this.zzvq());
            }
            return this.zzazf.getConnectionResult(api);
        }
        return this.zzaze.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.zzazo = 2;
        this.zzazm = false;
        this.zzvl();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.zzazl = null;
        this.zzazk = null;
        this.zzazo = 0;
        this.zzaze.disconnect();
        this.zzazf.disconnect();
        this.zzvo();
    }

    @Override
    public boolean isConnected() {
        this.zzazn.lock();
        try {
            boolean bl = this.zzaze.isConnected() && (this.zzvk() || this.zzvp() || this.zzazo == 1);
            return bl;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.zzazn.lock();
        try {
            boolean bl = this.zzazo == 2;
            return bl;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public boolean zza(zzabi zzabi2) {
        this.zzazn.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzvk()) {
                this.zzazh.add(zzabi2);
                if (this.zzazo == 0) {
                    this.zzazo = 1;
                }
                this.zzazl = null;
                this.zzazf.connect();
                return true;
            }
        }
        finally {
            this.zzazn.unlock();
        }
        return false;
    }

    @Override
    public void zzvj() {
        this.zzaze.zzvj();
        this.zzazf.zzvj();
    }

    @Override
    public void zzuN() {
        this.zzazn.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzazf.disconnect();
            this.zzazl = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzrx);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzaaa.this.zzazn.lock();
                        try {
                            zzaaa.this.zzvm();
                        }
                        finally {
                            zzaaa.this.zzazn.unlock();
                        }
                    }
                });
            } else {
                this.zzvo();
            }
        }
        finally {
            this.zzazn.unlock();
        }
    }

    public boolean zzvk() {
        return this.zzazf.isConnected();
    }

    private void zzvl() {
        this.zzazl = null;
        this.zzazk = null;
        this.zzaze.connect();
        this.zzazf.connect();
    }

    private void zzvm() {
        if (zzaaa.zzb(this.zzazk)) {
            if (zzaaa.zzb(this.zzazl) || this.zzvp()) {
                this.zzvn();
            } else if (this.zzazl != null) {
                if (this.zzazo == 1) {
                    this.zzvo();
                } else {
                    this.zza(this.zzazl);
                    this.zzaze.disconnect();
                }
            }
        } else if (this.zzazk != null && zzaaa.zzb(this.zzazl)) {
            this.zzazf.disconnect();
            this.zza(this.zzazk);
        } else if (this.zzazk != null && this.zzazl != null) {
            ConnectionResult connectionResult = this.zzazk;
            if (this.zzazf.zzaAJ < this.zzaze.zzaAJ) {
                connectionResult = this.zzazl;
            }
            this.zza(connectionResult);
        }
    }

    private void zzvn() {
        switch (this.zzazo) {
            case 2: {
                this.zzazd.zzo(this.zzazj);
            }
            case 1: {
                this.zzvo();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
            }
        }
        this.zzazo = 0;
    }

    private void zza(ConnectionResult connectionResult) {
        switch (this.zzazo) {
            case 2: {
                this.zzazd.zzc(connectionResult);
            }
            case 1: {
                this.zzvo();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzazo = 0;
    }

    private void zzvo() {
        for (zzabi zzabi2 : this.zzazh) {
            zzabi2.zzqR();
        }
        this.zzazh.clear();
    }

    private void zzb(int n, boolean bl) {
        this.zzazd.zzc(n, bl);
        this.zzazl = null;
        this.zzazk = null;
    }

    private boolean zzvp() {
        return this.zzazl != null && this.zzazl.getErrorCode() == 4;
    }

    private boolean zzc(zzzv.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzuH();
        zzac.zzb((boolean)this.zzazg.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzazg.get(zzc2).equals(this.zzazf);
    }

    @Nullable
    private PendingIntent zzvq() {
        if (this.zzazi == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzazd.getSessionId(), (Intent)this.zzazi.zzqT(), (int)0x8000000);
    }

    private void zzn(Bundle bundle) {
        if (this.zzazj == null) {
            this.zzazj = bundle;
        } else if (bundle != null) {
            this.zzazj.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzazf.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzaze.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    private class zzb
    implements zzaau.zza {
        private zzb() {
        }

        @Override
        public void zzo(@Nullable Bundle bundle) {
            zzaaa.this.zzazn.lock();
            try {
                zzaaa.this.zzazl = ConnectionResult.zzawX;
                zzaaa.this.zzvm();
            }
            finally {
                zzaaa.this.zzazn.unlock();
            }
        }

        @Override
        public void zzc(@NonNull ConnectionResult connectionResult) {
            zzaaa.this.zzazn.lock();
            try {
                zzaaa.this.zzazl = connectionResult;
                zzaaa.this.zzvm();
            }
            finally {
                zzaaa.this.zzazn.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzaaa.this.zzazn.lock();
            try {
                if (zzaaa.this.zzazm) {
                    zzaaa.this.zzazm = false;
                    zzaaa.this.zzb(n, bl);
                    return;
                }
                zzaaa.this.zzazm = true;
                zzaaa.this.zzaze.onConnectionSuspended(n);
            }
            finally {
                zzaaa.this.zzazn.unlock();
            }
        }
    }

    private class zza
    implements zzaau.zza {
        private zza() {
        }

        @Override
        public void zzo(@Nullable Bundle bundle) {
            zzaaa.this.zzazn.lock();
            try {
                zzaaa.this.zzn(bundle);
                zzaaa.this.zzazk = ConnectionResult.zzawX;
                zzaaa.this.zzvm();
            }
            finally {
                zzaaa.this.zzazn.unlock();
            }
        }

        @Override
        public void zzc(@NonNull ConnectionResult connectionResult) {
            zzaaa.this.zzazn.lock();
            try {
                zzaaa.this.zzazk = connectionResult;
                zzaaa.this.zzvm();
            }
            finally {
                zzaaa.this.zzazn.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzaaa.this.zzazn.lock();
            try {
                if (zzaaa.this.zzazm || zzaaa.this.zzazl == null || !zzaaa.this.zzazl.isSuccess()) {
                    zzaaa.this.zzazm = false;
                    zzaaa.this.zzb(n, bl);
                    return;
                }
                zzaaa.this.zzazm = true;
                zzaaa.this.zzazf.onConnectionSuspended(n);
            }
            finally {
                zzaaa.this.zzazn.unlock();
            }
        }
    }
}

