/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgb;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpw;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqu;
import com.google.android.gms.internal.zzqv;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
class zzqt
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzqp {
    private final zza zzYX;
    private final Object zzrN = new Object();
    @Nullable
    private final zzav zzGr;
    private final zzqa zztr;
    private final zzt zzYY;
    private final zzd zzsz;
    private zzqq zzYZ;
    private zze zzZa;
    private zzec zzum;
    private boolean zzZb;
    private boolean zzZc;
    private boolean zzZd;
    private boolean zzZe;
    private Boolean zzWh;
    private int zzZf;
    private boolean zzZg = true;
    boolean zzZh = false;
    private String zzOn = "";
    private zzqu zzZi;
    private boolean zzZj;
    private boolean zzZk;
    private zzgs zzZl;
    private int zzZm;
    private int zzZn;
    private zzgd zzZo;
    private zzgd zzOo;
    private zzgd zzZp;
    private zzge zzZq;
    private WeakReference<View.OnClickListener> zzZr;
    private zze zzZs;
    private zzpw zzvP;
    private int zzLR = -1;
    private int zzLQ = -1;
    private int zzLT = -1;
    private int zzLU = -1;
    private Map<String, zzil> zzZt;
    private final WindowManager zzwf;

    static zzqt zzb(Context context, zzec zzec2, boolean bl, boolean bl2, @Nullable zzav zzav2, zzqa zzqa2, zzgf zzgf2, zzt zzt2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzqt(zza2, zzec2, bl, bl2, zzav2, zzqa2, zzgf2, zzt2, zzd2);
    }

    protected zzqt(zza zza2, zzec zzec2, boolean bl, boolean bl2, @Nullable zzav zzav2, zzqa zzqa2, zzgf zzgf2, zzt zzt2, zzd zzd2) {
        super((Context)zza2);
        this.zzYX = zza2;
        this.zzum = zzec2;
        this.zzZd = bl;
        this.zzZf = -1;
        this.zzGr = zzav2;
        this.zztr = zzqa2;
        this.zzYY = zzt2;
        this.zzsz = zzd2;
        this.zzwf = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzv.zzcJ().zza((Context)zza2, zzqa2.zzaZ, webSettings);
        zzv.zzcL().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzlF();
        if (zzs.zzyD()) {
            this.addJavascriptInterface(new zzqv(this), "googleAdsJsInterface");
        }
        if (zzs.zzyx()) {
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
        }
        this.zzvP = new zzpw(this.zzYX.zzkR(), (View)this, this, null);
        this.zzd(zzgf2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzqq) {
            this.zzYZ = (zzqq)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzbz() {
        return this.zzsz;
    }

    public boolean zzlA() {
        int n;
        int n2;
        if (!this.zzkV().zzdz() && !this.zzkV().zzlo()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzv.zzcJ().zza(this.zzwf);
        int n3 = zzeh.zzeO().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzeh.zzeO().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzkR();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzv.zzcJ().zzh(activity);
            n2 = zzeh.zzeO().zzb(displayMetrics, nArray[0]);
            n = zzeh.zzeO().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzLQ == n3 && this.zzLR == n4 && this.zzLT == n2 && this.zzLU == n) {
            return false;
        }
        boolean bl = this.zzLQ != n3 || this.zzLR != n4;
        this.zzLQ = n3;
        this.zzLR = n4;
        this.zzLT = n2;
        this.zzLU = n;
        new zzko(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzwf.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzv.zzcJ().zzP(map);
        }
        catch (JSONException jSONException) {
            zzpe.zzbe((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzpe.zzbe((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbi(String string2) {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzpe.zzbe((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String string2) {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    String string3 = String.valueOf(throwable);
                    zzpe.zzbe((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
                }
            } else {
                zzpe.zzbe((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbf(String string2) {
        Object object = this.zzrN;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                String string3 = String.valueOf(throwable);
                zzpe.zzbe((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String string2, String string3, String string4) {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzpe.zzbe((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzpe.zzbe((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzpe.zzbe((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzbj(String string2) {
        if (zzs.zzyF()) {
            if (this.zzjT() == null) {
                this.zzlB();
            }
            if (this.zzjT().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                String string3 = String.valueOf(string2);
                this.zzbi(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            }
        } else {
            String string4 = String.valueOf(string2);
            this.zzbi(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzlB() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzWh = zzv.zzcN().zzjT();
            if (this.zzWh == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(Boolean bl) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzWh = bl;
        }
        zzv.zzcN().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzjT() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzWh;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzi(string2, string3);
    }

    @Override
    public void zzi(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzbj(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzpe.zzbc((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzbj(stringBuilder.toString());
    }

    @Override
    public void zzkP() {
        this.zzlC();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zztr.zzaZ);
        this.zza("onhide", hashMap);
    }

    @Override
    public void zzK(int n) {
        if (n == 0) {
            this.zzlD();
        }
        this.zzlC();
        if (this.zzZq.zzfv() != null) {
            this.zzZq.zzfv().zzg("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zztr.zzaZ);
        this.zza("onhide", hashMap);
    }

    private void zzlC() {
        zzgb.zza(this.zzZq.zzfv(), this.zzOo, "aeh2");
    }

    private void zzlD() {
        zzgb.zza(this.zzZq.zzfv(), this.zzOo, "aebb2");
    }

    @Override
    public void zzhp() {
        if (this.zzZo == null) {
            zzgb.zza(this.zzZq.zzfv(), this.zzOo, "aes2");
            this.zzZo = zzgb.zzb(this.zzZq.zzfv());
            this.zzZq.zza("native:view_show", this.zzZo);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zztr.zzaZ);
        this.zza("onshow", hashMap);
    }

    @Override
    public void zzkQ() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzv.zzcJ().zzcq()));
        hashMap.put("app_volume", String.valueOf(zzv.zzcJ().zzco()));
        hashMap.put("device_volume", String.valueOf(zzv.zzcJ().zzH(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zze zzkT() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zze zzkU() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzec zzbD() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzum;
        }
    }

    @Override
    public zzqq zzkV() {
        return this.zzYZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzkW() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZb;
        }
    }

    @Override
    public zzav zzkX() {
        return this.zzGr;
    }

    @Override
    public zzqa zzkY() {
        return this.zztr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzkZ() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZd;
        }
    }

    public void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzv.zzcJ().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzpe.zzbc((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzkV().zzlo()) {
            Object object = this.zzrN;
            synchronized (object) {
                if (this.zzZl != null) {
                    this.zzZl.zzc(motionEvent);
                }
            }
        } else if (this.zzGr != null) {
            this.zzGr.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (zzfx.zzCp.get().booleanValue()) {
            boolean bl;
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            boolean bl2 = bl = motionEvent.getActionMasked() == 8;
            if (bl && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int n, int n2) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzZd || this.zzum.zzzn) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzum.zzzo) {
                int n3;
                if (zzfx.zzEe.get().booleanValue() || !zzs.zzyD()) {
                    super.onMeasure(n, n2);
                    return;
                }
                this.zza("/contentHeight", this.zzlE());
                String string2 = "(function() {  var height = -1;  if (document.body) { height = document.body.offsetHeight;}  else if (document.documentElement) {      height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  window.googleAdsJsInterface.notify(url);  })();";
                this.zzbj(string2);
                float f = this.zzYX.getResources().getDisplayMetrics().density;
                int n4 = View.MeasureSpec.getSize((int)n);
                switch (this.zzZn) {
                    case -1: {
                        n3 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n3 = (int)((float)this.zzZn * f);
                    }
                }
                this.setMeasuredDimension(n4, n3);
                return;
            }
            if (this.zzum.zzzl) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzwf.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzum.widthPixels > n9 || this.zzum.heightPixels > n10) {
                float f = this.zzYX.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzum.widthPixels / f);
                int n12 = (int)((float)this.zzum.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzpe.zzbe((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzum.widthPixels, this.zzum.heightPixels);
            }
        }
    }

    zzhx zzlE() {
        return new zzhx(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(zzqp zzqp2, Map<String, String> map) {
                String string2;
                if (map != null && !TextUtils.isEmpty((CharSequence)(string2 = map.get("height")))) {
                    try {
                        int n = Integer.parseInt(string2);
                        Object object = zzqt.this.zzrN;
                        synchronized (object) {
                            if (zzqt.this.zzZn != n) {
                                zzqt.this.zzZn = n;
                                zzqt.this.requestLayout();
                            }
                        }
                    }
                    catch (Exception exception) {
                        zzpe.zzc((String)"Exception occurred while getting webview content height", (Throwable)exception);
                    }
                }
            }
        };
    }

    public void onGlobalLayout() {
        boolean bl = this.zzlA();
        zze zze2 = this.zzkT();
        if (zze2 != null && bl) {
            zze2.zzho();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, zzec zzec2, zzgf zzgf2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzvP.zzkF();
            this.setContext(context);
            this.zzZa = null;
            this.zzum = zzec2;
            this.zzZd = false;
            this.zzZb = false;
            this.zzOn = "";
            this.zzZf = -1;
            zzv.zzcL().zzm(this);
            this.loadUrl("about:blank");
            this.zzYZ.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzZg = true;
            this.zzZh = false;
            this.zzZi = null;
            this.zzd(zzgf2);
            this.zzZj = false;
            this.zzZm = 0;
            zzv.zzdg().zze(this);
            this.zzlI();
        }
    }

    private void zzd(zzgf zzgf2) {
        this.zzlJ();
        this.zzZq = new zzge(new zzgf(true, "make_wv", this.zzum.zzzk));
        this.zzZq.zzfv().zzc(zzgf2);
        this.zzOo = zzgb.zzb(this.zzZq.zzfv());
        this.zzZq.zza("native:view_create", this.zzOo);
        this.zzZp = null;
        this.zzZo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zze zze2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZa = zze2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(zze zze2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZs = zze2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzec zzec2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzum = zzec2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzJ(boolean bl) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZd = bl;
            this.zzlF();
        }
    }

    @Override
    public void zzli() {
        this.zzvP.zzkE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzrN;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzvP.onAttachedToWindow();
            }
            boolean bl = this.zzZj;
            if (this.zzkV() != null && this.zzkV().zzlo()) {
                bl = true;
                if (!this.zzZk) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzkV().zzlp();
                    if (onGlobalLayoutListener != null) {
                        zzv.zzdh().zza(this.getView(), onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzkV().zzlq()) != null) {
                        zzv.zzdh().zza(this.getView(), onScrollChangedListener);
                    }
                    this.zzZk = true;
                }
            }
            this.zzO(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzvP.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzZk && this.zzkV() != null && this.zzkV().zzlo() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzkV().zzlp();
                if (onGlobalLayoutListener != null) {
                    zzv.zzcL().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzkV().zzlq()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzZk = false;
            }
        }
        this.zzO(false);
    }

    @Override
    public void setContext(Context context) {
        this.zzYX.setBaseContext(context);
        this.zzvP.zzl(this.zzYX.zzkR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzK(boolean bl) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzZa != null) {
                this.zzZa.zza(this.zzYZ.zzdz(), bl);
            } else {
                this.zzZb = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int n) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZf = n;
            if (this.zzZa != null) {
                this.zzZa.setRequestedOrientation(this.zzZf);
            }
        }
    }

    @Override
    public Activity zzkR() {
        return this.zzYX.zzkR();
    }

    @Override
    public Context zzkS() {
        return this.zzYX.zzkS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzlF() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzZd || this.zzum.zzzl) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzpe.zzbc((String)"Disabling hardware acceleration on an overlay.");
                    this.zzlG();
                } else {
                    zzpe.zzbc((String)"Enabling hardware acceleration on an overlay.");
                    this.zzlH();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzpe.zzbc((String)"Disabling hardware acceleration on an AdView.");
                this.zzlG();
            } else {
                zzpe.zzbc((String)"Enabling hardware acceleration on an AdView.");
                this.zzlH();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzlG() {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.zzZe) {
                zzv.zzcL().zzu((View)this);
            }
            this.zzZe = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzlH() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzZe) {
                zzv.zzcL().zzt((View)this);
            }
            this.zzZe = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzlJ();
            this.zzvP.zzkF();
            if (this.zzZa != null) {
                this.zzZa.close();
                this.zzZa.onDestroy();
                this.zzZa = null;
            }
            this.zzYZ.reset();
            if (this.zzZc) {
                return;
            }
            zzv.zzdg().zze(this);
            this.zzlI();
            this.zzZc = true;
            zzpe.v("Initiating WebView self destruct sequence in 3...");
            this.zzYZ.zzls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.zzZc) {
                this.zzYZ.reset();
                zzv.zzdg().zze(this);
                this.zzlI();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzla() {
        Object object = this.zzrN;
        synchronized (object) {
            zzpe.v("Destroying WebView!");
            zzpi.zzWR.post(new Runnable(){

                @Override
                public void run() {
                    zzqt.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZc;
        }
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzkV() != null && this.zzkV().zzlz() != null) {
            this.zzkV().zzlz().zzcc();
        }
    }

    @Override
    public void zzlj() {
        if (this.zzZp == null) {
            this.zzZp = zzgb.zzb(this.zzZq.zzfv());
            this.zzZq.zza("native:view_load", this.zzZp);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzyx()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Could not pause webview.", (Throwable)exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzyx()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Could not resume webview.", (Throwable)exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Could not stop loading webview.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzL(boolean bl) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZg = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzlb() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzlc() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbV() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZh = true;
            if (this.zzYY != null) {
                this.zzYY.zzbV();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbW() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZh = false;
            if (this.zzYY != null) {
                this.zzYY.zzbW();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzlI() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbg(String string2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzOn = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzOn;
        }
    }

    @Override
    public zzqo zzld() {
        return null;
    }

    @Override
    public zzgd zzle() {
        return this.zzOo;
    }

    @Override
    public zzge zzlf() {
        return this.zzZq;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzZr = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public View.OnClickListener zzlk() {
        return (View.OnClickListener)this.zzZr.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzgs zzgs2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZl = zzgs2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzgs zzll() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzqu zzlg() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzqu zzqu2) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzZi != null) {
                zzpe.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzZi = zzqu2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzlh() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzZm > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzM(boolean bl) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZm += bl ? 1 : -1;
            if (this.zzZm <= 0 && this.zzZa != null) {
                this.zzZa.zzhr();
            }
        }
    }

    private void zzlJ() {
        if (this.zzZq == null) {
            return;
        }
        zzgf zzgf2 = this.zzZq.zzfv();
        if (zzgf2 != null && zzv.zzcN().zzjN() != null) {
            zzv.zzcN().zzjN().zza(zzgf2);
        }
    }

    @Override
    public void zzlm() {
        this.setBackgroundColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzcv.zza zza2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzZj = zza2.zzxb;
        }
        this.zzO(zza2.zzxb);
    }

    private void zzO(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public void zza(String string2, zzhx zzhx2) {
        if (this.zzYZ != null) {
            this.zzYZ.zza(string2, zzhx2);
        }
    }

    @Override
    public void zzb(String string2, zzhx zzhx2) {
        if (this.zzYZ != null) {
            this.zzYZ.zzb(string2, zzhx2);
        }
    }

    @zzmb
    public static class zza
    extends MutableContextWrapper {
        private Activity zzXO;
        private Context zzvZ;
        private Context zzZv;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context context) {
            this.zzvZ = context.getApplicationContext();
            this.zzXO = context instanceof Activity ? (Activity)context : null;
            this.zzZv = context;
            super.setBaseContext(this.zzvZ);
        }

        public void startActivity(Intent intent) {
            if (this.zzXO != null) {
                this.zzXO.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzvZ.startActivity(intent);
            }
        }

        public Activity zzkR() {
            return this.zzXO;
        }

        public Object getSystemService(String string2) {
            return this.zzZv.getSystemService(string2);
        }

        public Context zzkS() {
            return this.zzZv;
        }
    }
}

