/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpl;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import java.util.Collections;
import java.util.Map;

@zzmb
public class zze
extends zzkr.zza
implements com.google.android.gms.ads.internal.overlay.zzv {
    static final int zzMx = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzMy;
    zzqp zzGt;
    zzc zzMz;
    zzp zzMA;
    boolean zzMB = false;
    FrameLayout zzMC;
    WebChromeClient.CustomViewCallback zzMD;
    boolean zzME = false;
    boolean zzMF = false;
    zzb zzMG;
    boolean zzMH = false;
    int zzMI = 0;
    zzm zzMJ;
    private final Object zzMK = new Object();
    private Runnable zzML;
    private boolean zzMM;
    private boolean zzMN;
    private boolean zzMO = false;
    private boolean zzMP = false;
    private boolean zzMQ = true;

    public zze(Activity activity) {
        this.mActivity = activity;
        this.zzMJ = new zzt();
    }

    public void close() {
        this.zzMI = 2;
        this.mActivity.finish();
    }

    public void zzhi() {
        if (this.zzMy != null && this.zzMB) {
            this.setRequestedOrientation(this.zzMy.orientation);
        }
        if (this.zzMC != null) {
            this.mActivity.setContentView((View)this.zzMG);
            this.zzbp();
            this.zzMC.removeAllViews();
            this.zzMC = null;
        }
        if (this.zzMD != null) {
            this.zzMD.onCustomViewHidden();
            this.zzMD = null;
        }
        this.zzMB = false;
    }

    @Override
    public void zzhj() {
        this.zzMI = 1;
        this.mActivity.finish();
    }

    public void onBackPressed() {
        this.zzMI = 0;
    }

    public boolean zzhk() {
        boolean bl;
        this.zzMI = 0;
        if (this.zzGt == null) {
            return true;
        }
        boolean bl2 = bl = this.zzGt.zzlb();
        if (!bl) {
            this.zzGt.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzME = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzMy = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzMy == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzMy.zzvf.zzYc > 7500000) {
                this.zzMI = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzMQ = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzMF = this.zzMy.zzNi != null ? this.zzMy.zzNi.zztH : false;
            if (zzfx.zzDJ.get().booleanValue() && this.zzMF && this.zzMy.zzNi.zztM != -1) {
                new zzd().zziw();
            }
            if (bundle == null) {
                if (this.zzMy.zzMY != null && this.zzMQ) {
                    this.zzMy.zzMY.zzbO();
                }
                if (this.zzMy.zzNf != 1 && this.zzMy.zzMX != null) {
                    this.zzMy.zzMX.onAdClicked();
                }
            }
            this.zzMG = new zzb((Context)this.mActivity, this.zzMy.zzNh);
            this.zzMG.setId(1000);
            switch (this.zzMy.zzNf) {
                case 1: {
                    this.zzA(false);
                    break;
                }
                case 2: {
                    this.zzMz = new zzc(this.zzMy.zzMZ);
                    this.zzA(false);
                    break;
                }
                case 3: {
                    this.zzA(true);
                    break;
                }
                case 4: {
                    if (this.zzME) {
                        this.zzMI = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzv.zzcG().zza((Context)this.mActivity, this.zzMy.zzMW, this.zzMy.zzNe)) {
                        this.zzMI = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzpe.zzbe((String)zza2.getMessage());
            this.zzMI = 3;
            this.mActivity.finish();
        }
    }

    public void onRestart() {
    }

    public void onStart() {
        boolean bl = zzfx.zzEZ.get();
        if (bl) {
            if (this.zzGt != null && !this.zzGt.isDestroyed()) {
                zzv.zzcL().zzm(this.zzGt);
            } else {
                zzpe.zzbe((String)"The webview does not exist. Ignoring action.");
            }
        }
    }

    public void onResume() {
        boolean bl;
        if (this.zzMy != null && this.zzMy.zzNf == 4) {
            if (this.zzME) {
                this.zzMI = 3;
                this.mActivity.finish();
            } else {
                this.zzME = true;
            }
        }
        if (this.zzMy.zzMY != null) {
            this.zzMy.zzMY.onResume();
        }
        if (!(bl = zzfx.zzEZ.get().booleanValue())) {
            if (this.zzGt != null && !this.zzGt.isDestroyed()) {
                zzv.zzcL().zzm(this.zzGt);
            } else {
                zzpe.zzbe((String)"The webview does not exist. Ignoring action.");
            }
        }
    }

    public void onPause() {
        boolean bl;
        this.zzhi();
        if (this.zzMy.zzMY != null) {
            this.zzMy.zzMY.onPause();
        }
        if (!((bl = zzfx.zzEZ.get().booleanValue()) || this.zzGt == null || this.mActivity.isFinishing() && this.zzMz != null)) {
            zzv.zzcL().zzl(this.zzGt);
        }
        this.zzhm();
    }

    public void onActivityResult(int n, int n2, Intent intent) {
    }

    public void zzn(com.google.android.gms.dynamic.zzd zzd2) {
        if (zzfx.zzEY.get().booleanValue() && zzs.isAtLeastN()) {
            Configuration configuration = (Configuration)com.google.android.gms.dynamic.zze.zzE((com.google.android.gms.dynamic.zzd)zzd2);
            if (zzv.zzcJ().zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
            } else {
                this.mActivity.getWindow().addFlags(2048);
                this.mActivity.getWindow().clearFlags(1024);
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzME);
    }

    public void onStop() {
        boolean bl = zzfx.zzEZ.get();
        if (bl && this.zzGt != null && (!this.mActivity.isFinishing() || this.zzMz == null)) {
            zzv.zzcL().zzl(this.zzGt);
        }
        this.zzhm();
    }

    public void onDestroy() {
        if (this.zzGt != null) {
            this.zzMG.removeView(this.zzGt.getView());
        }
        this.zzhm();
    }

    public void zzz(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzMA = new zzp((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzMA.zza(bl, this.zzMy.zzNc);
        this.zzMG.addView((View)this.zzMA, (ViewGroup.LayoutParams)layoutParams);
    }

    public void zzbp() {
        this.zzMN = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzMA != null) {
            this.zzMA.zza(bl, bl2);
        }
    }

    public void zzhl() {
        this.zzMG.removeView((View)this.zzMA);
        this.zzz(true);
    }

    public void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzMC = new FrameLayout((Context)this.mActivity);
        this.zzMC.setBackgroundColor(-16777216);
        this.zzMC.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzMC);
        this.zzbp();
        this.zzMD = customViewCallback;
        this.zzMB = true;
    }

    protected void zzA(boolean bl) throws zza {
        com.google.android.gms.ads.internal.zzd zzd2;
        zzn zzn2;
        zzqq zzqq2;
        boolean bl2;
        Window window;
        if (!this.zzMN) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (zzs.isAtLeastN() && zzfx.zzEY.get().booleanValue()) {
            bl3 = zzv.zzcJ().zza(this.mActivity, this.mActivity.getResources().getConfiguration());
        }
        boolean bl4 = bl2 = this.zzMy.zzNi != null && this.zzMy.zzNi.zztI;
        if ((!this.zzMF || bl2) && bl3) {
            window.setFlags(1024, 1024);
        }
        boolean bl5 = (zzqq2 = this.zzMy.zzMZ.zzkV()) != null ? zzqq2.zzdz() : false;
        this.zzMH = false;
        if (bl5) {
            if (this.zzMy.orientation == zzv.zzcL().zzkp()) {
                this.zzMH = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzMy.orientation == zzv.zzcL().zzkq()) {
                this.zzMH = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzMH;
        zzpe.zzbc((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzMy.orientation);
        if (zzv.zzcL().zza(window)) {
            zzpe.zzbc((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzMF) {
            this.zzMG.setBackgroundColor(-16777216);
        } else {
            this.zzMG.setBackgroundColor(zzMx);
        }
        this.mActivity.setContentView((View)this.zzMG);
        this.zzbp();
        if (bl) {
            this.zzGt = zzv.zzcK().zza((Context)this.mActivity, this.zzMy.zzMZ.zzbD(), true, bl5, null, this.zzMy.zzvf, null, null, this.zzMy.zzMZ.zzbz());
            this.zzGt.zzkV().zza(null, null, this.zzMy.zzNa, this.zzMy.zzNe, true, this.zzMy.zzNg, null, this.zzMy.zzMZ.zzkV().zzln(), null, null);
            this.zzGt.zzkV().zza(new zzqq.zza(this){

                @Override
                public void zza(zzqp zzqp2, boolean bl) {
                    zzqp2.zzhp();
                }
            });
            if (this.zzMy.url != null) {
                this.zzGt.loadUrl(this.zzMy.url);
            } else if (this.zzMy.zzNd != null) {
                this.zzGt.loadDataWithBaseURL(this.zzMy.zzNb, this.zzMy.zzNd, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzMy.zzMZ != null) {
                this.zzMy.zzMZ.zzc(this);
            }
        } else {
            this.zzGt = this.zzMy.zzMZ;
            this.zzGt.setContext((Context)this.mActivity);
        }
        this.zzGt.zzb(this);
        ViewParent viewParent = this.zzGt.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzGt.getView());
        }
        if (this.zzMF) {
            this.zzGt.zzlm();
        }
        this.zzMG.addView(this.zzGt.getView(), -1, -1);
        if (!bl && !this.zzMH) {
            this.zzhp();
        }
        this.zzz(bl5);
        if (this.zzGt.zzkW()) {
            this.zza(bl5, true);
        }
        zzn zzn3 = zzn2 = (zzd2 = this.zzGt.zzbz()) != null ? zzd2.zzsO : null;
        if (zzn2 != null) {
            this.zzMJ = zzn2.zza(this.mActivity, this.zzGt, this.zzMG);
        } else {
            zzpe.zzbe((String)"Appstreaming controller is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzhm() {
        if (!this.mActivity.isFinishing() || this.zzMO) {
            return;
        }
        this.zzMO = true;
        if (this.zzGt != null) {
            this.zzK(this.zzMI);
            Object object = this.zzMK;
            synchronized (object) {
                if (!this.zzMM && this.zzGt.zzlh()) {
                    this.zzML = new Runnable(){

                        @Override
                        public void run() {
                            zze.this.zzhn();
                        }
                    };
                    zzpi.zzWR.postDelayed(this.zzML, zzfx.zzCz.get().longValue());
                    return;
                }
            }
        }
        this.zzhn();
    }

    void zzhn() {
        if (this.zzMP) {
            return;
        }
        this.zzMP = true;
        if (this.zzGt != null) {
            this.zzMG.removeView(this.zzGt.getView());
            if (this.zzMz != null) {
                this.zzGt.setContext(this.zzMz.zzqr);
                this.zzGt.zzJ(false);
                this.zzMz.parent.addView(this.zzGt.getView(), this.zzMz.index, this.zzMz.zzMT);
                this.zzMz = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzGt.setContext(this.mActivity.getApplicationContext());
            }
            this.zzGt = null;
        }
        if (this.zzMy != null && this.zzMy.zzMY != null) {
            this.zzMy.zzMY.zzbN();
        }
    }

    public void zzho() {
        if (this.zzMH) {
            this.zzMH = false;
            this.zzhp();
        }
    }

    protected void zzhp() {
        this.zzGt.zzhp();
    }

    protected void zzK(int n) {
        this.zzGt.zzK(n);
    }

    public void zzg(zzqp zzqp2, Map<String, String> map) {
    }

    public void zzhq() {
        this.zzMG.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzhr() {
        Object object = this.zzMK;
        synchronized (object) {
            this.zzMM = true;
            if (this.zzML != null) {
                zzpi.zzWR.removeCallbacks(this.zzML);
                zzpi.zzWR.post(this.zzML);
            }
        }
    }

    @zzmb
    private class zzd
    extends zzpd {
        private zzd() {
        }

        @Override
        public void zzcm() {
            Bitmap bitmap = zzv.zzde().zza(zze.this.zzMy.zzNi.zztM);
            if (bitmap != null) {
                final Drawable drawable = zzv.zzcL().zza((Context)zze.this.mActivity, bitmap, zze.this.zzMy.zzNi.zztK, zze.this.zzMy.zzNi.zztL);
                zzpi.zzWR.post(new Runnable(){

                    @Override
                    public void run() {
                        zze.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzmb
    static class zzb
    extends RelativeLayout {
        zzpl zzvO;
        boolean zzMS;

        public zzb(Context context, String string2) {
            super(context);
            this.zzvO = new zzpl(context, string2);
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (!this.zzMS) {
                this.zzvO.zzg(motionEvent);
            }
            return false;
        }

        void disable() {
            this.zzMS = true;
        }
    }

    @zzmb
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzMT;
        public final ViewGroup parent;
        public final Context zzqr;

        public zzc(zzqp zzqp2) throws zza {
            this.zzMT = zzqp2.getLayoutParams();
            ViewParent viewParent = zzqp2.getParent();
            this.zzqr = zzqp2.zzkS();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.parent = (ViewGroup)viewParent;
            this.index = this.parent.indexOfChild(zzqp2.getView());
            this.parent.removeView(zzqp2.getView());
            zzqp2.zzJ(true);
        }
    }

    @zzmb
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

