/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;

public final class Status
extends zza
implements Result,
ReflectedParcelable {
    public static final Status zzayh = new Status(0);
    public static final Status zzayi = new Status(14);
    public static final Status zzayj = new Status(8);
    public static final Status zzayk = new Status(15);
    public static final Status zzayl = new Status(16);
    public static final Status zzaym = new Status(17);
    public static final Status zzayn = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzh();
    final int mVersionCode;
    private final int zzauz;
    private final String zzawY;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.mVersionCode = n;
        this.zzauz = n2;
        this.zzawY = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    PendingIntent zzuT() {
        return this.mPendingIntent;
    }

    @Nullable
    public String getStatusMessage() {
        return this.zzawY;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzauz <= 0;
    }

    public boolean isCanceled() {
        return this.zzauz == 16;
    }

    public boolean isInterrupted() {
        return this.zzauz == 14;
    }

    public int getStatusCode() {
        return this.zzauz;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzaa.hashCode(this.mVersionCode, this.zzauz, this.zzawY, this.mPendingIntent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.mVersionCode == status.mVersionCode && this.zzauz == status.zzauz && zzaa.equal(this.zzawY, status.zzawY) && zzaa.equal(this.mPendingIntent, status.mPendingIntent);
    }

    public String zzuU() {
        if (this.zzawY != null) {
            return this.zzawY;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzauz);
    }

    public String toString() {
        return zzaa.zzv(this).zzg("statusCode", this.zzuU()).zzg("resolution", this.mPendingIntent).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

