/**
 * @license
 * Copyright (C) 1997-2014, Onion Software/onitama.
 * Copyright (C) 2014, zakki.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.  Redistributions in binary
 * form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided
 * with the distribution.  Neither the name of the Onion Software nor the names
 * of its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 **/
var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer;buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[(function($0,$1){{var d=document.getElementById("hsp3dishFontDiv");if(!d){d=document.createElement("div");d.id="hsp3dishFontDiv";d.style.setProperty("width","auto");d.style.setProperty("height","auto");d.style.setProperty("position","absolute");d.style.setProperty("visibility","hidden")}d.style.setProperty("font",$1+"px 'sans-serif'");document.body.appendChild(d);var t=document.createTextNode(Pointer_stringify($0));if(d.hasChildNodes())d.removeChild(d.firstChild);d.appendChild(t)}}),(function(){{var d=document.getElementById("hsp3dishFontDiv");return d.clientWidth}}),(function(){{var d=document.getElementById("hsp3dishFontDiv");return d.clientHeight}}),(function($0,$1,$2,$3){{var canvas=document.getElementById("hsp3dishFontCanvas");if(canvas){document.body.removeChild(canvas)}canvas=document.createElement("canvas");canvas.id="hsp3dishFontCanvas";canvas.style.setProperty("visibility","hidden");canvas.width=$2;canvas.height=$3;document.body.appendChild(canvas);var context=canvas.getContext("2d");context.font=$1+"px 'sans-serif'";var msg=Pointer_stringify($0);context.clearRect(0,0,$2,$3);context.fillStyle="rgba(255, 255, 255, 255)";context.fillText(msg,0,$1);console.log(msg);GLctx.texImage2D(GLctx.TEXTURE_2D,0,GLctx.RGBA,GLctx.RGBA,GLctx.UNSIGNED_BYTE,canvas)}}),(function($0){{var dir=Pointer_stringify($0);FS.mkdir(dir);FS.mount(IDBFS,{},dir);FS.syncfs(true,(function(err){console.log(err);ccall("hsp3dish_sync_done","v","",[])}))}}),(function($0){{var dir=Pointer_stringify($0);FS.syncfs((function(err){console.log("syncfs",err)}))}}),(function($0){{console.log(Pointer_stringify($0))}})];function _emscripten_asm_const_0(code){return ASM_CONSTS[code]()}function _emscripten_asm_const_1(code,a0){return ASM_CONSTS[code](a0)}function _emscripten_asm_const_2(code,a0,a1){return ASM_CONSTS[code](a0,a1)}function _emscripten_asm_const_4(code,a0,a1,a2,a3){return ASM_CONSTS[code](a0,a1,a2,a3)}STATIC_BASE=8;STATICTOP=STATIC_BASE+37872;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_hsp3int_cpp()})},{func:(function(){__GLOBAL__sub_I_hsp3dish_cpp()})});allocate([208,91,0,0,244,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,92,0,0,76,126,0,0,224,0,0,0,0,0,0,0,236,91,0,0,89,126,0,0,236,91,0,0,102,126,0,0,20,92,0,0,115,126,0,0,232,0,0,0,0,0,0,0,20,92,0,0,148,126,0,0,240,0,0,0,0,0,0,0,20,92,0,0,218,126,0,0,240,0,0,0,0,0,0,0,20,92,0,0,182,126,0,0,16,1,0,0,0,0,0,0,20,92,0,0,252,126,0,0,240,0,0,0,0,0,0,0,20,92,0,0,29,127,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([128,191,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,186,232,62,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,13,0,0,0,15,0,0,0,17,0,0,0,19,0,0,0,23,0,0,0,27,0,0,0,31,0,0,0,35,0,0,0,43,0,0,0,51,0,0,0,59,0,0,0,67,0,0,0,83,0,0,0,99,0,0,0,115,0,0,0,131,0,0,0,163,0,0,0,195,0,0,0,227,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,7,0,0,0,9,0,0,0,13,0,0,0,17,0,0,0,25,0,0,0,33,0,0,0,49,0,0,0,65,0,0,0,97,0,0,0,129,0,0,0,193,0,0,0,1,1,0,0,129,1,0,0,1,2,0,0,1,3,0,0,1,4,0,0,1,6,0,0,1,8,0,0,1,12,0,0,1,16,0,0,1,24,0,0,1,32,0,0,1,48,0,0,1,64,0,0,1,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,9,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,11,0,0,0,11,0,0,0,12,0,0,0,12,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,15,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,255,0,0,0,255,1,0,0,255,3,0,0,255,7,0,0,255,15,0,0,255,31,0,0,255,63,0,0,255,127,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,208,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,48,1,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,3,0,0,0,7,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,64,1,0,0,3,0,0,0,8,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,58,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,93,0,0,128,93,0,0,240,93,0,0,240,93,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,5,0,0,0,214,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,5,0,0,0,206,141,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,5,0,0,0,198,137,0,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,4,0,4,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,32,0,32,0,114,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,80,77,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,97,116,97,46,100,112,109,0,64,0,13,10,0,149,207,144,148,150,188,0,140,94,0,40,37,100,44,37,100,44,37,100,44,37,100,41,0,148,122,151,241,0,131,130,129,91,131,104,0,142,103,151,112,131,84,131,67,131,89,0,131,111,131,98,131,116,131,64,131,84,131,67,131,89,0,40,147,224,151,101,37,100,98,121,116,101,115,130,204,136,234,149,148,130,240,149,142,166,130,181,130,196,130,162,130,220,130,183,41,13,10,0,147,224,151,101,58,0,76,65,66,69,76,32,36,37,48,56,120,0,83,84,82,85,67,84,32,40,69,109,112,116,121,41,0,83,84,82,85,67,84,32,73,68,37,100,45,37,100,32,80,84,82,36,37,48,56,120,32,83,73,90,69,37,100,40,37,100,41,0,67,79,77,80,84,82,32,36,37,48,56,120,0,40,148,122,151,241,130,204,136,234,149,148,130,190,130,175,130,240,149,142,166,41,13,10,0,40,37,100,41,61,37,115,13,10,0,37,48,52,88,0,32,37,48,50,88,0,37,115,58,37,52,100,13,10,0,56,72,83,80,69,82,82,79,82,0,32,35,43,45,46,48,49,50,51,52,53,54,55,56,57,0,100,111,117,98,108,101,0,105,110,116,0,108,97,98,101,108,0,115,116,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,0,37,102,0,115,116,114,117,99,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,101,120,58,73,68,37,100,32,40,37,100,44,37,100,41,40,37,100,120,37,100,41,0,84,101,120,58,102,97,105,108,101,100,0,84,101,120,58,73,68,37,100,32,40,37,100,44,37,100,41,32,67,108,101,97,114,0,123,32,118,97,114,32,100,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,39,104,115,112,51,100,105,115,104,70,111,110,116,68,105,118,39,41,59,32,105,102,32,40,33,100,41,32,123,32,100,32,61,32,100,111,99,117,109,101,110,116,46,99,114,101,97,116,101,69,108,101,109,101,110,116,40,34,100,105,118,34,41,59,32,100,46,105,100,32,61,32,39,104,115,112,51,100,105,115,104,70,111,110,116,68,105,118,39,59,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,119,105,100,116,104,34,44,32,34,97,117,116,111,34,41,59,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,104,101,105,103,104,116,34,44,32,34,97,117,116,111,34,41,59,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,112,111,115,105,116,105,111,110,34,44,32,34,97,98,115,111,108,117,116,101,34,41,59,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,118,105,115,105,98,105,108,105,116,121,34,44,32,34,104,105,100,100,101,110,34,41,59,32,125,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,102,111,110,116,34,44,32,36,49,32,43,32,34,112,120,32,39,115,97,110,115,45,115,101,114,105,102,39,34,41,59,32,100,111,99,117,109,101,110,116,46,98,111,100,121,46,97,112,112,101,110,100,67,104,105,108,100,40,100,41,59,32,118,97,114,32,116,32,61,32,100,111,99,117,109,101,110,116,46,99,114,101,97,116,101,84,101,120,116,78,111,100,101,40,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,41,59,32,105,102,32,40,100,46,104,97,115,67,104,105,108,100,78,111,100,101,115,40,41,41,32,100,46,114,101,109,111,118,101,67,104,105,108,100,40,100,46,102,105,114,115,116,67,104,105,108,100,41,59,32,100,46,97,112,112,101,110,100,67,104,105,108,100,40,116,41,59,32,125,0,123,32,118,97,114,32,100,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,39,104,115,112,51,100,105,115,104,70,111,110,116,68,105,118,39,41,59,32,114,101,116,117,114,110,32,100,46,99,108,105,101,110,116,87,105,100,116,104,59,32,125,0,123,32,118,97,114,32,100,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,39,104,115,112,51,100,105,115,104,70,111,110,116,68,105,118,39,41,59,32,114,101,116,117,114,110,32,100,46,99,108,105,101,110,116,72,101,105,103,104,116,59,32,125,0,123,32,118,97,114,32,99,97,110,118,97,115,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,39,104,115,112,51,100,105,115,104,70,111,110,116,67,97,110,118,97,115,39,41,59,32,105,102,32,40,99,97,110,118,97,115,41,32,123,32,100,111,99,117,109,101,110,116,46,98,111,100,121,46,114,101,109,111,118,101,67,104,105,108,100,40,99,97,110,118,97,115,41,59,32,125,32,99,97,110,118,97,115,32,61,32,100,111,99,117,109,101,110,116,46,99,114,101,97,116,101,69,108,101,109,101,110,116,40,34,99,97,110,118,97,115,34,41,59,32,99,97,110,118,97,115,46,105,100,32,61,32,39,104,115,112,51,100,105,115,104,70,111,110,116,67,97,110,118,97,115,39,59,32,99,97,110,118,97,115,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,118,105,115,105,98,105,108,105,116,121,34,44,32,34,104,105,100,100,101,110,34,41,59,32,99,97,110,118,97,115,46,119,105,100,116,104,32,61,32,36,50,59,32,99,97,110,118,97,115,46,104,101,105,103,104,116,32,61,32,36,51,59,32,100,111,99,117,109,101,110,116,46,98,111,100,121,46,97,112,112,101,110,100,67,104,105,108,100,40,99,97,110,118,97,115,41,59,32,118,97,114,32,99,111,110,116,101,120,116,32,61,32,99,97,110,118,97,115,46,103,101,116,67,111,110,116,101,120,116,40,34,50,100,34,41,59,32,99,111,110,116,101,120,116,46,102,111,110,116,32,61,32,36,49,32,43,32,34,112,120,32,39,115,97,110,115,45,115,101,114,105,102,39,34,59,32,118,97,114,32,109,115,103,32,61,32,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,59,32,99,111,110,116,101,120,116,46,99,108,101,97,114,82,101,99,116,32,40,32,48,32,44,32,48,32,44,32,36,50,32,44,32,36,51,41,59,32,99,111,110,116,101,120,116,46,102,105,108,108,83,116,121,108,101,32,61,32,39,114,103,98,97,40,50,53,53,44,32,50,53,53,44,32,50,53,53,44,32,50,53,53,41,39,59,32,99,111,110,116,101,120,116,46,102,105,108,108,84,101,120,116,40,109,115,103,44,32,48,44,32,36,49,41,59,32,99,111,110,115,111,108,101,46,108,111,103,40,109,115,103,41,59,32,71,76,99,116,120,46,116,101,120,73,109,97,103,101,50,68,40,71,76,99,116,120,46,84,69,88,84,85,82,69,95,50,68,44,32,48,44,32,71,76,99,116,120,46,82,71,66,65,44,32,71,76,99,116,120,46,82,71,66,65,44,32,71,76,99,116,120,46,85,78,83,73,71,78,69,68,95,66,89,84,69,44,32,99,97,110,118,97,115,41,59,32,125,0,0,0,0,0,73,110,105,116,58,72,71,73,79,83,99,114,101,101,110,40,37,100,44,37,100,41,0,83,99,97,108,101,40,37,102,44,37,102,41,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+22310);allocate([72,83,80,72,69,68,126,126,0,95,49,95,95,95,95,95,95,95,95,95,50,95,95,95,95,95,95,95,95,95,51,95,95,95,95,95,95,0,72,83,80,95,87,88,0,72,83,80,95,87,89,0,72,83,80,95,83,88,0,72,83,80,95,83,89,0,72,83,80,95,65,85,84,79,83,67,65,76,69,0,72,83,80,95,70,80,83,0,72,83,80,95,76,73,77,73,84,95,83,84,69,80,0,83,99,114,101,101,110,32,37,102,32,37,102,10,0,72,83,80,95,83,89,78,67,95,68,73,82,0,73,78,73,84,32,37,100,120,37,100,32,37,115,10,0,72,83,80,68,105,115,104,32,118,101,114,51,46,53,98,101,116,97,51,0,83,116,97,114,116,117,112,32,102,97,105,108,101,100,46,0,85,110,97,98,108,101,32,116,111,32,105,110,105,116,105,97,108,105,122,101,32,83,68,76,58,32,37,115,10,0,85,110,97,98,108,101,32,116,111,32,115,101,116,32,118,105,100,101,111,32,109,111,100,101,58,32,37,115,10,0,101,109,115,99,114,105,112,116,101,110,0,35,69,114,114,111,114,32,37,100,10,45,45,62,37,115,10,0,35,69,114,114,111,114,32,37,100,32,105,110,32,108,105,110,101,32,37,100,32,40,37,115,41,10,45,45,62,37,115,10,0,0,83,121,110,99,0,79,86,69,82,32,72,83,80,95,76,73,77,73,84,95,83,84,69,80,32,37,100,10,0,123,32,118,97,114,32,100,105,114,32,61,32,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,59,32,70,83,46,109,107,100,105,114,40,100,105,114,41,59,32,70,83,46,109,111,117,110,116,40,73,68,66,70,83,44,32,123,125,44,32,100,105,114,41,59,32,70,83,46,115,121,110,99,102,115,40,116,114,117,101,44,32,102,117,110,99,116,105,111,110,32,40,101,114,114,41,32,123,32,99,111,110,115,111,108,101,46,108,111,103,40,101,114,114,41,59,32,99,99,97,108,108,40,39,104,115,112,51,100,105,115,104,95,115,121,110,99,95,100,111,110,101,39,44,32,39,118,39,44,32,39,39,44,32,91,93,41,59,32,125,41,59,32,125,0,110,97,109,101,0,101,114,114,111,114,0,115,121,110,99,102,115,0,123,32,118,97,114,32,100,105,114,32,61,32,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,59,32,70,83,46,115,121,110,99,102,115,40,102,117,110,99,116,105,111,110,32,40,101,114,114,41,32,123,32,99,111,110,115,111,108,101,46,108,111,103,40,34,115,121,110,99,102,115,34,44,32,101,114,114,41,59,32,125,41,59,32,125,0,114,101,116,32,61,61,32,48,0,101,109,115,99,114,105,112,116,101,110,47,109,109,109,97,110,46,99,112,112,0,77,77,77,97,110,0,91,77,77,77,97,110,93,32,76,111,97,100,101,100,32,37,115,32,111,110,32,98,97,110,107,32,35,37,100,0,80,79,83,84,0,227,131,128,227,130,166,227,131,179,227,131,173,227,131,188,227,131,137,228,184,173,227,129,171,227,130,168,227,131,169,227,131,188,227,129,140,231,153,186,231,148,159,227,129,151,227,129,190,227,129,151,227,129,159,40,37,100,58,37,115,41,0,35,63,82,65,68,73,65,78,67,69,10,0,111,117,116,111,102,109,101,109,0,117,110,107,110,111,119,110,32,105,109,97,103,101,32,116,121,112,101,0,35,63,82,65,68,73,65,78,67,69,0,70,79,82,77,65,84,61,51,50,45,98,105,116,95,114,108,101,95,114,103,98,101,0,45,89,32,0,43,88,32,0,110,111,116,32,71,73,70,0,0,137,80,78,71,13,10,26,10,98,97,100,32,112,110,103,32,115,105,103,0,109,117,108,116,105,112,108,101,32,73,72,68,82,0,98,97,100,32,73,72,68,82,32,108,101,110,0,116,111,111,32,108,97,114,103,101,0,56,98,105,116,32,111,110,108,121,0,98,97,100,32,99,116,121,112,101,0,98,97,100,32,99,111,109,112,32,109,101,116,104,111,100,0,98,97,100,32,102,105,108,116,101,114,32,109,101,116,104,111,100,0,98,97,100,32,105,110,116,101,114,108,97,99,101,32,109,101,116,104,111,100,0,48,45,112,105,120,101,108,32,105,109,97,103,101,0,102,105,114,115,116,32,110,111,116,32,73,72,68,82,0,105,110,118,97,108,105,100,32,80,76,84,69,0,116,82,78,83,32,97,102,116,101,114,32,73,68,65,84,0,116,82,78,83,32,98,101,102,111,114,101,32,80,76,84,69,0,98,97,100,32,116,82,78,83,32,108,101,110,0,116,82,78,83,32,119,105,116,104,32,97,108,112,104,97,0,110,111,32,80,76,84,69,0,111,117,116,111,102,100,97,116,97,0,110,111,32,73,68,65,84,0,111,117,116,95,110,32,61,61,32,50,32,124,124,32,111,117,116,95,110,32,61,61,32,52,0,101,109,115,99,114,105,112,116,101,110,47,115,116,98,95,105,109,97,103,101,46,99,0,99,111,109,112,117,116,101,95,116,114,97,110,115,112,97,114,101,110,99,121,0,115,45,62,105,109,103,95,111,117,116,95,110,32,61,61,32,52,0,115,116,98,105,95,100,101,95,105,112,104,111,110,101,0,88,88,88,88,32,99,104,117,110,107,32,110,111,116,32,107,110,111,119,110,0,111,117,116,95,110,32,61,61,32,115,45,62,105,109,103,95,110,32,124,124,32,111,117,116,95,110,32,61,61,32,115,45,62,105,109,103,95,110,43,49,0,99,114,101,97,116,101,95,112,110,103,95,105,109,97,103,101,95,114,97,119,0,110,111,116,32,101,110,111,117,103,104,32,112,105,120,101,108,115,0,105,110,118,97,108,105,100,32,102,105,108,116,101,114,0,0,1,0,5,6,105,109,103,95,110,43,49,32,61,61,32,111,117,116,95,110,0,110,111,32,83,79,73,0,110,111,32,83,79,70,0,98,97,100,32,83,79,70,32,108,101,110,0,111,110,108,121,32,56,45,98,105,116,0,110,111,32,104,101,97,100,101,114,32,104,101,105,103,104,116,0,48,32,119,105,100,116,104,0,98,97,100,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,98,97,100,32,99,111,109,112,111,110,101,110,116,32,73,68,0,98,97,100,32,72,0,98,97,100,32,86,0,98,97,100,32,84,81,0,101,120,112,101,99,116,101,100,32,109,97,114,107,101,114,0,112,114,111,103,114,101,115,115,105,118,101,32,106,112,101,103,0,98,97,100,32,68,82,73,32,108,101,110,0,98,97,100,32,68,81,84,32,116,121,112,101,0,98,97,100,32,68,81,84,32,116,97,98,108,101,0,0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,98,97,100,32,68,72,84,32,104,101,97,100,101,114,0,98,97,100,32,99,111,100,101,32,108,101,110,103,116,104,115,0,98,97,100,32,122,108,105,98,32,104,101,97,100,101,114,0,110,111,32,112,114,101,115,101,116,32,100,105,99,116,0,98,97,100,32,99,111,109,112,114,101,115,115,105,111,110,0,122,45,62,99,111,100,101,95,98,117,102,102,101,114,32,60,32,40,49,85,32,60,60,32,122,45,62,110,117,109,95,98,105,116,115,41,0,102,105,108,108,95,98,105,116,115,0,97,45,62,110,117,109,95,98,105,116,115,32,61,61,32,48,0,112,97,114,115,101,95,117,110,99,111,109,112,114,101,115,115,101,100,95,98,108,111,99,107,0,122,108,105,98,32,99,111,114,114,117,112,116,0,114,101,97,100,32,112,97,115,116,32,98,117,102,102,101,114,0,111,117,116,112,117,116,32,98,117,102,102,101,114,32,108,105,109,105,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15,99,32,62,61,32,48,32,38,38,32,99,32,60,32,49,57,0,99,111,109,112,117,116,101,95,104,117,102,102,109,97,110,95,99,111,100,101,115,0,99,32,61,61,32,49,56,0,98,97,100,32,99,111,100,101,108,101,110,103,116,104,115,0,98,97,100,32,104,117,102,102,109,97,110,32,99,111,100,101,0,98,97,100,32,100,105,115,116,0,122,45,62,115,105,122,101,91,98,93,32,61,61,32,115,0,122,104,117,102,102,109,97,110,95,100,101,99,111,100,101,0,115,105,122,101,115,91,105,93,32,60,61,32,40,49,32,60,60,32,105,41,0,122,98,117,105,108,100,95,104,117,102,102,109,97,110,0,110,111,116,32,72,68,82,0,117,110,115,117,112,112,111,114,116,101,100,32,102,111,114,109,97,116,0,117,110,115,117,112,112,111,114,116,101,100,32,100,97,116,97,32,108,97,121,111,117,116,0,105,110,118,97,108,105,100,32,100,101,99,111,100,101,100,32,115,99,97,110,108,105,110,101,32,108,101,110,103,116,104,0,98,97,100,32,114,101,113,95,99,111,109,112,0,98,97,100,32,83,79,83,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,98,97,100,32,83,79,83,32,108,101,110,0,98,97,100,32,68,67,32,104,117,102,102,0,98,97,100,32,65,67,32,104,117,102,102,0,98,97,100,32,83,79,83,0,110,111,116,32,66,77,80,0,117,110,107,110,111,119,110,32,66,77,80,0,98,97,100,32,66,77,80,0,109,111,110,111,99,104,114,111,109,101,0,66,77,80,32,82,76,69,0,104,115,122,32,61,61,32,49,48,56,0,98,109,112,95,108,111,97,100,0,105,110,118,97,108,105,100,0,98,97,100,32,98,112,112,0,98,97,100,32,109,97,115,107,115,0,98,97,100,32,73,109,97,103,101,32,68,101,115,99,114,105,112,116,111,114,0,109,105,115,115,105,110,103,32,99,111,108,111,114,32,116,97,98,108,101,0,110,111,32,99,108,101,97,114,32,99,111,100,101,0,116,111,111,32,109,97,110,121,32,99,111,100,101,115,0,105,108,108,101,103,97,108,32,99,111,100,101,32,105,110,32,114,97,115,116,101,114,0,117,110,107,110,111,119,110,32,99,111,100,101,0,110,111,116,32,80,83,68,0,119,114,111,110,103,32,118,101,114,115,105,111,110,0,119,114,111,110,103,32,99,104,97,110,110,101,108,32,99,111,117,110,116,0,117,110,115,117,112,112,111,114,116,101,100,32,98,105,116,32,100,101,112,116,104,0,119,114,111,110,103,32,99,111,108,111,114,32,102,111,114,109,97,116,0,83,128,246,52,0,80,73,67,84,0,98,97,100,32,102,105,108,101,0,98,97,100,32,102,111,114,109,97,116,0,98,97,100,32,112,97,108,101,116,116,101,0,114,101,113,95,99,111,109,112,32,62,61,32,49,32,38,38,32,114,101,113,95,99,111,109,112,32,60,61,32,52,0,99,111,110,118,101,114,116,95,102,111,114,109,97,116,0,48,0,40,40,40,106,45,62,99,111,100,101,95,98,117,102,102,101,114,41,32,62,62,32,40,51,50,32,45,32,104,45,62,115,105,122,101,91,99,93,41,41,32,38,32,98,109,97,115,107,91,104,45,62,115,105,122,101,91,99,93,93,41,32,61,61,32,104,45,62,99,111,100,101,91,99,93,0,100,101,99,111,100,101,0,119,98,0,114,43,98,0,10,0,123,32,99,111,110,115,111,108,101,46,108,111,103,40,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,41,59,32,125,0,83,116,57,98,97,100,95,97,108,108,111,99,0,83,116,57,101,120,99,101,112,116,105,111,110,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,101,110,117,109,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,116,104,114,101,119,32,97,110,32,101,120,99,101,112,116,105,111,110,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,67,58,92,69,109,115,99,114,105,112,116,101,110,92,101,109,115,99,114,105,112,116,101,110,92,49,46,51,53,46,48,92,115,121,115,116,101,109,92,105,110,99,108,117,100,101,92,108,105,98,99,120,120,92,115,116,114,105,110,103,0,95,95,116,104,114,111,119,95,108,101,110,103,116,104,95,101,114,114,111,114,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,117,110,99,97,117,103,104,116,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,105,110,102,105,110,105,116,121,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5,0,114,119,97],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+29326);allocate([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+37326);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}function _atexit(func,arg){__ATEXIT__.unshift({func:func,arg:arg})}function ___cxa_atexit(){return _atexit.apply(null,arguments)}Module["_i64Subtract"]=_i64Subtract;var GL={counter:1,lastError:0,buffers:[],mappedBuffers:{},programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],vaos:[],contexts:[],currentContext:null,currArrayBuffer:0,currElementArrayBuffer:0,byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],programInfos:{},stringCache:{},packAlignment:4,unpackAlignment:4,init:(function(){GL.createLog2ceilLookup(GL.MAX_TEMP_BUFFER_SIZE);GL.miniTempBuffer=new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);for(var i=0;i<GL.MINI_TEMP_BUFFER_SIZE;i++){GL.miniTempBufferViews[i]=GL.miniTempBuffer.subarray(0,i+1)}}),recordError:function recordError(errorCode){if(!GL.lastError){GL.lastError=errorCode}},getNewId:(function(table){var ret=GL.counter++;for(var i=table.length;i<ret;i++){table[i]=null}return ret}),MINI_TEMP_BUFFER_SIZE:16,miniTempBuffer:null,miniTempBufferViews:[0],MAX_TEMP_BUFFER_SIZE:2097152,numTempVertexBuffersPerSize:64,log2ceilLookup:null,createLog2ceilLookup:(function(maxValue){GL.log2ceilLookup=new Uint8Array(maxValue+1);var log2=0;var pow2=1;GL.log2ceilLookup[0]=0;for(var i=1;i<=maxValue;++i){if(i>pow2){pow2<<=1;++log2}GL.log2ceilLookup[i]=log2}}),generateTempBuffers:(function(quads,context){var largestIndex=GL.log2ceilLookup[GL.MAX_TEMP_BUFFER_SIZE];context.tempVertexBufferCounters1=[];context.tempVertexBufferCounters2=[];context.tempVertexBufferCounters1.length=context.tempVertexBufferCounters2.length=largestIndex+1;context.tempVertexBuffers1=[];context.tempVertexBuffers2=[];context.tempVertexBuffers1.length=context.tempVertexBuffers2.length=largestIndex+1;context.tempIndexBuffers=[];context.tempIndexBuffers.length=largestIndex+1;for(var i=0;i<=largestIndex;++i){context.tempIndexBuffers[i]=null;context.tempVertexBufferCounters1[i]=context.tempVertexBufferCounters2[i]=0;var ringbufferLength=GL.numTempVertexBuffersPerSize;context.tempVertexBuffers1[i]=[];context.tempVertexBuffers2[i]=[];var ringbuffer1=context.tempVertexBuffers1[i];var ringbuffer2=context.tempVertexBuffers2[i];ringbuffer1.length=ringbuffer2.length=ringbufferLength;for(var j=0;j<ringbufferLength;++j){ringbuffer1[j]=ringbuffer2[j]=null}}if(quads){context.tempQuadIndexBuffer=GLctx.createBuffer();context.GLctx.bindBuffer(context.GLctx.ELEMENT_ARRAY_BUFFER,context.tempQuadIndexBuffer);var numIndexes=GL.MAX_TEMP_BUFFER_SIZE>>1;var quadIndexes=new Uint16Array(numIndexes);var i=0,v=0;while(1){quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+1;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v+3;if(i>=numIndexes)break;v+=4}context.GLctx.bufferData(context.GLctx.ELEMENT_ARRAY_BUFFER,quadIndexes,context.GLctx.STATIC_DRAW);context.GLctx.bindBuffer(context.GLctx.ELEMENT_ARRAY_BUFFER,null)}}),getTempVertexBuffer:function getTempVertexBuffer(sizeBytes){var idx=GL.log2ceilLookup[sizeBytes];var ringbuffer=GL.currentContext.tempVertexBuffers1[idx];var nextFreeBufferIndex=GL.currentContext.tempVertexBufferCounters1[idx];GL.currentContext.tempVertexBufferCounters1[idx]=GL.currentContext.tempVertexBufferCounters1[idx]+1&GL.numTempVertexBuffersPerSize-1;var vbo=ringbuffer[nextFreeBufferIndex];if(vbo){return vbo}var prevVBO=GLctx.getParameter(GLctx.ARRAY_BUFFER_BINDING);ringbuffer[nextFreeBufferIndex]=GLctx.createBuffer();GLctx.bindBuffer(GLctx.ARRAY_BUFFER,ringbuffer[nextFreeBufferIndex]);GLctx.bufferData(GLctx.ARRAY_BUFFER,1<<idx,GLctx.DYNAMIC_DRAW);GLctx.bindBuffer(GLctx.ARRAY_BUFFER,prevVBO);return ringbuffer[nextFreeBufferIndex]},getTempIndexBuffer:function getTempIndexBuffer(sizeBytes){var idx=GL.log2ceilLookup[sizeBytes];var ibo=GL.currentContext.tempIndexBuffers[idx];if(ibo){return ibo}var prevIBO=GLctx.getParameter(GLctx.ELEMENT_ARRAY_BUFFER_BINDING);GL.currentContext.tempIndexBuffers[idx]=GLctx.createBuffer();GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.currentContext.tempIndexBuffers[idx]);GLctx.bufferData(GLctx.ELEMENT_ARRAY_BUFFER,1<<idx,GLctx.DYNAMIC_DRAW);GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,prevIBO);return GL.currentContext.tempIndexBuffers[idx]},newRenderingFrameStarted:function newRenderingFrameStarted(){if(!GL.currentContext){return}var vb=GL.currentContext.tempVertexBuffers1;GL.currentContext.tempVertexBuffers1=GL.currentContext.tempVertexBuffers2;GL.currentContext.tempVertexBuffers2=vb;vb=GL.currentContext.tempVertexBufferCounters1;GL.currentContext.tempVertexBufferCounters1=GL.currentContext.tempVertexBufferCounters2;GL.currentContext.tempVertexBufferCounters2=vb;var largestIndex=GL.log2ceilLookup[GL.MAX_TEMP_BUFFER_SIZE];for(var i=0;i<=largestIndex;++i){GL.currentContext.tempVertexBufferCounters1[i]=0}},findToken:(function(source,token){function isIdentChar(ch){if(ch>=48&&ch<=57)return true;if(ch>=65&&ch<=90)return true;if(ch>=97&&ch<=122)return true;return false}var i=-1;do{i=source.indexOf(token,i+1);if(i<0){break}if(i>0&&isIdentChar(source[i-1])){continue}i+=token.length;if(i<source.length-1&&isIdentChar(source[i+1])){continue}return true}while(true);return false}),getSource:(function(shader,count,string,length){var source="";for(var i=0;i<count;++i){var frag;if(length){var len=HEAP32[length+i*4>>2];if(len<0){frag=Pointer_stringify(HEAP32[string+i*4>>2])}else{frag=Pointer_stringify(HEAP32[string+i*4>>2],len)}}else{frag=Pointer_stringify(HEAP32[string+i*4>>2])}source+=frag}type=GLctx.getShaderParameter(GL.shaders[shader],35663);if(type==35632){if(GL.findToken(source,"dFdx")||GL.findToken(source,"dFdy")||GL.findToken(source,"fwidth")){source="#extension GL_OES_standard_derivatives : enable\n"+source;var extension=GLctx.getExtension("OES_standard_derivatives")}}return source}),createContext:(function(canvas,webGLContextAttributes){if(typeof webGLContextAttributes.majorVersion==="undefined"&&typeof webGLContextAttributes.minorVersion==="undefined"){webGLContextAttributes.majorVersion=1;webGLContextAttributes.minorVersion=0}var ctx;var errorInfo="?";function onContextCreationError(event){errorInfo=event.statusMessage||errorInfo}try{canvas.addEventListener("webglcontextcreationerror",onContextCreationError,false);try{if(webGLContextAttributes.majorVersion==1&&webGLContextAttributes.minorVersion==0){ctx=canvas.getContext("webgl",webGLContextAttributes)||canvas.getContext("experimental-webgl",webGLContextAttributes)}else if(webGLContextAttributes.majorVersion==2&&webGLContextAttributes.minorVersion==0){ctx=canvas.getContext("webgl2",webGLContextAttributes)||canvas.getContext("experimental-webgl2",webGLContextAttributes)}else{throw"Unsupported WebGL context version "+majorVersion+"."+minorVersion+"!"}}finally{canvas.removeEventListener("webglcontextcreationerror",onContextCreationError,false)}if(!ctx)throw":("}catch(e){Module.print("Could not create canvas: "+[errorInfo,e,JSON.stringify(webGLContextAttributes)]);return 0}if(!ctx)return 0;return GL.registerContext(ctx,webGLContextAttributes)}),registerContext:(function(ctx,webGLContextAttributes){var handle=GL.getNewId(GL.contexts);var context={handle:handle,version:webGLContextAttributes.majorVersion,GLctx:ctx};if(ctx.canvas)ctx.canvas.GLctxObject=context;GL.contexts[handle]=context;if(typeof webGLContextAttributes["enableExtensionsByDefault"]==="undefined"||webGLContextAttributes.enableExtensionsByDefault){GL.initExtensions(context)}return handle}),makeContextCurrent:(function(contextHandle){var context=GL.contexts[contextHandle];if(!context)return false;GLctx=Module.ctx=context.GLctx;GL.currentContext=context;return true}),getContext:(function(contextHandle){return GL.contexts[contextHandle]}),deleteContext:(function(contextHandle){if(GL.currentContext===GL.contexts[contextHandle])GL.currentContext=null;if(typeof JSEvents==="object")JSEvents.removeAllHandlersOnTarget(GL.contexts[contextHandle].GLctx.canvas);if(GL.contexts[contextHandle]&&GL.contexts[contextHandle].GLctx.canvas)GL.contexts[contextHandle].GLctx.canvas.GLctxObject=undefined;GL.contexts[contextHandle]=null}),initExtensions:(function(context){if(!context)context=GL.currentContext;if(context.initExtensionsDone)return;context.initExtensionsDone=true;var GLctx=context.GLctx;context.maxVertexAttribs=GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);context.compressionExt=GLctx.getExtension("WEBGL_compressed_texture_s3tc");context.anisotropicExt=GLctx.getExtension("EXT_texture_filter_anisotropic");if(context.version<2){var instancedArraysExt=GLctx.getExtension("ANGLE_instanced_arrays");if(instancedArraysExt){GLctx["vertexAttribDivisor"]=(function(index,divisor){instancedArraysExt["vertexAttribDivisorANGLE"](index,divisor)});GLctx["drawArraysInstanced"]=(function(mode,first,count,primcount){instancedArraysExt["drawArraysInstancedANGLE"](mode,first,count,primcount)});GLctx["drawElementsInstanced"]=(function(mode,count,type,indices,primcount){instancedArraysExt["drawElementsInstancedANGLE"](mode,count,type,indices,primcount)})}var vaoExt=GLctx.getExtension("OES_vertex_array_object");if(vaoExt){GLctx["createVertexArray"]=(function(){return vaoExt["createVertexArrayOES"]()});GLctx["deleteVertexArray"]=(function(vao){vaoExt["deleteVertexArrayOES"](vao)});GLctx["bindVertexArray"]=(function(vao){vaoExt["bindVertexArrayOES"](vao)});GLctx["isVertexArray"]=(function(vao){return vaoExt["isVertexArrayOES"](vao)})}var drawBuffersExt=GLctx.getExtension("WEBGL_draw_buffers");if(drawBuffersExt){GLctx["drawBuffers"]=(function(n,bufs){drawBuffersExt["drawBuffersWEBGL"](n,bufs)})}}var automaticallyEnabledExtensions=["OES_texture_float","OES_texture_half_float","OES_standard_derivatives","OES_vertex_array_object","WEBGL_compressed_texture_s3tc","WEBGL_depth_texture","OES_element_index_uint","EXT_texture_filter_anisotropic","ANGLE_instanced_arrays","OES_texture_float_linear","OES_texture_half_float_linear","WEBGL_compressed_texture_atc","WEBGL_compressed_texture_pvrtc","EXT_color_buffer_half_float","WEBGL_color_buffer_float","EXT_frag_depth","EXT_sRGB","WEBGL_draw_buffers","WEBGL_shared_resources","EXT_shader_texture_lod"];function shouldEnableAutomatically(extension){var ret=false;automaticallyEnabledExtensions.forEach((function(include){if(ext.indexOf(include)!=-1){ret=true}}));return ret}var exts=GLctx.getSupportedExtensions();if(exts&&exts.length>0){GLctx.getSupportedExtensions().forEach((function(ext){if(automaticallyEnabledExtensions.indexOf(ext)!=-1){GLctx.getExtension(ext)}}))}}),populateUniformTable:(function(program){var p=GL.programs[program];GL.programInfos[program]={uniforms:{},maxUniformLength:0,maxAttributeLength:-1};var ptable=GL.programInfos[program];var utable=ptable.uniforms;var numUniforms=GLctx.getProgramParameter(p,GLctx.ACTIVE_UNIFORMS);for(var i=0;i<numUniforms;++i){var u=GLctx.getActiveUniform(p,i);var name=u.name;ptable.maxUniformLength=Math.max(ptable.maxUniformLength,name.length+1);if(name.indexOf("]",name.length-1)!==-1){var ls=name.lastIndexOf("[");name=name.slice(0,ls)}var loc=GLctx.getUniformLocation(p,name);var id=GL.getNewId(GL.uniforms);utable[name]=[u.size,id];GL.uniforms[id]=loc;for(var j=1;j<u.size;++j){var n=name+"["+j+"]";loc=GLctx.getUniformLocation(p,n);id=GL.getNewId(GL.uniforms);GL.uniforms[id]=loc}}})};function _glClearColor(x0,x1,x2,x3){GLctx.clearColor(x0,x1,x2,x3)}Module["_i64Add"]=_i64Add;function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var fd=process.stdin.fd;var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null);if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.buffer.byteLength:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var errored=false;var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){flags&=~32768;if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,curr,WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var _stdin=allocate(1,"i32*",ALLOC_STATIC);var _stdout=allocate(1,"i32*",ALLOC_STATIC);var _stderr=allocate(1,"i32*",ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if((flags&2097155)!==0||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}var mounts=FS.getMounts(FS.root.mount);var completed=0;function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=mounts.length){callback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){if(err===ERRNO_CODES.EISDIR)err=ERRNO_CODES.EPERM;throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto").randomBytes(1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno]};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperty(lazyArray,"length",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})});Object.defineProperty(lazyArray,"chunkSize",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperty(node,"usedBytes",{get:(function(){return this.contents.length})});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};function _emscripten_set_main_loop_timing(mode,value){Browser.mainLoop.timingMode=mode;Browser.mainLoop.timingValue=value;if(!Browser.mainLoop.func){return 1}if(mode==0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setTimeout(){setTimeout(Browser.mainLoop.runner,value)};Browser.mainLoop.method="timeout"}else if(mode==1){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_rAF(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}else if(mode==2){if(!window["setImmediate"]){var setImmediates=[];var emscriptenMainLoopMessageId="__emcc";function Browser_setImmediate_messageHandler(event){if(event.source===window&&event.data===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}}window.addEventListener("message",Browser_setImmediate_messageHandler,true);window["setImmediate"]=function Browser_emulated_setImmediate(func){setImmediates.push(func);window.postMessage(emscriptenMainLoopMessageId,"*")}}Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setImmediate(){window["setImmediate"](Browser.mainLoop.runner)};Browser.mainLoop.method="immediate"}return 0}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg,noSetTiming){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");Browser.mainLoop.func=func;Browser.mainLoop.arg=arg;var thisMainLoopId=Browser.mainLoop.currentlyRunningMainloop;Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();setTimeout(Browser.mainLoop.runner,0);return}if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;Browser.mainLoop.currentFrameNumber=Browser.mainLoop.currentFrameNumber+1|0;if(Browser.mainLoop.timingMode==1&&Browser.mainLoop.timingValue>1&&Browser.mainLoop.currentFrameNumber%Browser.mainLoop.timingValue!=0){Browser.mainLoop.scheduler();return}GL.newRenderingFrameStarted();if(Browser.mainLoop.method==="timeout"&&Module.ctx){Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter((function(){if(typeof arg!=="undefined"){Runtime.dynCall("vi",func,[arg])}else{Runtime.dynCall("v",func)}}));if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;if(typeof SDL==="object"&&SDL.audio&&SDL.audio.queueNewAudioData)SDL.audio.queueNewAudioData();Browser.mainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0)_emscripten_set_main_loop_timing(0,1e3/fps);else _emscripten_set_main_loop_timing(1,1);Browser.mainLoop.scheduler()}if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:(function(){Browser.mainLoop.scheduler=null;Browser.mainLoop.currentlyRunningMainloop++}),resume:(function(){Browser.mainLoop.currentlyRunningMainloop++;var timingMode=Browser.mainLoop.timingMode;var timingValue=Browser.mainLoop.timingValue;var func=Browser.mainLoop.func;Browser.mainLoop.func=null;_emscripten_set_main_loop(func,0,false,Browser.mainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);Browser.mainLoop.scheduler()}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx&&canvas==Module.canvas)return Module.ctx;var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}canvas.style.backgroundColor="black"}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas,vrDevice){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;Browser.vrDevice=vrDevice;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;if(typeof Browser.vrDevice==="undefined")Browser.vrDevice=null;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);if(vrDevice){canvasContainer.requestFullScreen({vrDisplay:vrDevice})}else{canvasContainer.requestFullScreen()}}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=false}),resumeAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=true;if(Browser.queuedAsyncCallbacks.length>0){var callbacks=Browser.queuedAsyncCallbacks;Browser.queuedAsyncCallbacks=[];callbacks.forEach((function(func){func()}))}}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=event.wheelDelta;break;case"wheel":delta=event["deltaY"];break;default:throw"unrecognized mouse wheel event: "+event.type}return delta}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];if(!last)last=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),xhrLoad:(function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)}),asyncLoad:(function(url,onload,onerror,noRunDep){Browser.xhrLoad(url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}),wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:(function(){var handle=Browser.nextWgetRequestHandle;Browser.nextWgetRequestHandle++;return handle})};function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function _free(){}Module["_free"]=_free;var _environ=allocate(1,"i32*",ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]=ENV["LOGNAME"]="web_user";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/web_user";ENV["LANG"]="C";ENV["_"]=Module["thisProgram"];poolPtr=allocate(TOTAL_ENV_SIZE,"i8",ALLOC_STATIC);envPtr=allocate(MAX_ENV_VALUES*4,"i8*",ALLOC_STATIC);HEAP32[envPtr>>2]=poolPtr;HEAP32[_environ>>2]=envPtr}else{envPtr=HEAP32[_environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in env){if(typeof env[key]==="string"){var line=key+"="+env[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}var ENV={};function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocate(intArrayFromString(ENV[name]),"i8",ALLOC_NORMAL);return _getenv.ret}function _putenv(string){if(string===0){___setErrNo(ERRNO_CODES.EINVAL);return-1}string=Pointer_stringify(string);var splitPoint=string.indexOf("=");if(string===""||string.indexOf("=")===-1){___setErrNo(ERRNO_CODES.EINVAL);return-1}var name=string.slice(0,splitPoint);var value=string.slice(splitPoint+1);if(!(name in ENV)||ENV[name]!==value){ENV[name]=value;___buildEnvironment(ENV)}return 0}function _SDL_RWFromConstMem(mem,size){var id=SDL.rwops.length;SDL.rwops.push({bytes:mem,count:size});return id}function _TTF_FontHeight(font){var fontData=SDL.fonts[font];return fontData.size}function _TTF_SizeText(font,text,w,h){var fontData=SDL.fonts[font];if(w){HEAP32[w>>2]=SDL.estimateTextWidth(fontData,Pointer_stringify(text))}if(h){HEAP32[h>>2]=fontData.size}return 0}function _TTF_RenderText_Solid(font,text,color){text=Pointer_stringify(text)||" ";var fontData=SDL.fonts[font];var w=SDL.estimateTextWidth(fontData,text);var h=fontData.size;var color=SDL.loadColorToCSSRGB(color);var fontString=h+"px "+fontData.name;var surf=SDL.makeSurface(w,h,0,false,"text:"+text);var surfData=SDL.surfaces[surf];surfData.ctx.save();surfData.ctx.fillStyle=color;surfData.ctx.font=fontString;surfData.ctx.textBaseline="top";surfData.ctx.fillText(text,0,0);surfData.ctx.restore();return surf}function _Mix_HaltMusic(){var audio=SDL.music.audio;if(audio){audio.src=audio.src;audio.currentPosition=0;audio.pause()}SDL.music.audio=null;if(SDL.hookMusicFinished){Runtime.dynCall("v",SDL.hookMusicFinished)}return 0}function _Mix_PlayMusic(id,loops){if(SDL.music.audio){if(!SDL.music.audio.paused)Module.printErr("Music is already playing. "+SDL.music.source);SDL.music.audio.pause()}var info=SDL.audios[id];var audio;if(info.webAudio){audio={};audio.resource=info;audio.paused=false;audio.currentPosition=0;audio.play=(function(){SDL.playWebAudio(this)});audio.pause=(function(){SDL.pauseWebAudio(this)})}else if(info.audio){audio=info.audio}audio["onended"]=(function(){if(SDL.music.audio==this)_Mix_HaltMusic()});audio.loop=loops!=0;audio.volume=SDL.music.volume;SDL.music.audio=audio;audio.play();return 0}function _Mix_FreeChunk(id){SDL.audios[id]=null}function _Mix_LoadWAV_RW(rwopsID,freesrc){var rwops=SDL.rwops[rwopsID];if(rwops===undefined)return 0;var filename="";var audio;var webAudio;var bytes;if(rwops.filename!==undefined){filename=PATH.resolve(rwops.filename);var raw=Module["preloadedAudios"][filename];if(!raw){if(raw===null)Module.printErr("Trying to reuse preloaded audio, but freePreloadedMediaOnUse is set!");if(!Module.noAudioDecoding)Runtime.warnOnce("Cannot find preloaded audio "+filename);try{bytes=FS.readFile(filename)}catch(e){Module.printErr("Couldn't find file for: "+filename);return 0}}if(Module["freePreloadedMediaOnUse"]){Module["preloadedAudios"][filename]=null}audio=raw}else if(rwops.bytes!==undefined){if(SDL.webAudioAvailable())bytes=HEAPU8.buffer.slice(rwops.bytes,rwops.bytes+rwops.count);else bytes=HEAPU8.subarray(rwops.bytes,rwops.bytes+rwops.count)}else{return 0}var arrayBuffer=bytes?bytes.buffer||bytes:bytes;var canPlayWithWebAudio=Module["SDL_canPlayWithWebAudio"]===undefined||Module["SDL_canPlayWithWebAudio"](filename,arrayBuffer);if(bytes!==undefined&&SDL.webAudioAvailable()&&canPlayWithWebAudio){audio=undefined;webAudio={};webAudio.onDecodeComplete=[];function onDecodeComplete(data){webAudio.decodedBuffer=data;webAudio.onDecodeComplete.forEach((function(e){e()}));webAudio.onDecodeComplete=undefined}SDL.audioContext["decodeAudioData"](arrayBuffer,onDecodeComplete)}else if(audio===undefined&&bytes){var blob=new Blob([bytes],{type:rwops.mimetype});var url=URL.createObjectURL(blob);audio=new Audio;audio.src=url;audio.mozAudioChannelType="content"}var id=SDL.audios.length;SDL.audios.push({source:filename,audio:audio,webAudio:webAudio});return id}function _Mix_PlayChannel(channel,id,loops){var info=SDL.audios[id];if(!info)return-1;if(!info.audio&&!info.webAudio)return-1;if(channel==-1){for(var i=SDL.channelMinimumNumber;i<SDL.numChannels;i++){if(!SDL.channels[i].audio){channel=i;break}}if(channel==-1){Module.printErr("All "+SDL.numChannels+" channels in use!");return-1}}var channelInfo=SDL.channels[channel];var audio;if(info.webAudio){audio={};audio.resource=info;audio.paused=false;audio.currentPosition=0;audio.play=(function(){SDL.playWebAudio(this)});audio.pause=(function(){SDL.pauseWebAudio(this)})}else{audio=info.audio.cloneNode(true);audio.numChannels=info.audio.numChannels;audio.frequency=info.audio.frequency}audio["onended"]=function SDL_audio_onended(){if(channelInfo.audio==this){channelInfo.audio.paused=true;channelInfo.audio=null}if(SDL.channelFinished)Runtime.getFuncWrapper(SDL.channelFinished,"vi")(channel)};channelInfo.audio=audio;audio.loop=loops!=0;audio.volume=channelInfo.volume;audio.play();return channel}function _SDL_PauseAudio(pauseOn){if(!SDL.audio){return}if(pauseOn){if(SDL.audio.timer!==undefined){clearTimeout(SDL.audio.timer);SDL.audio.numAudioTimersPending=0;SDL.audio.timer=undefined}}else if(!SDL.audio.timer){SDL.audio.numAudioTimersPending=1;SDL.audio.timer=Browser.safeSetTimeout(SDL.audio.caller,1)}SDL.audio.paused=pauseOn}function _SDL_CloseAudio(){if(SDL.audio){_SDL_PauseAudio(1);_free(SDL.audio.buffer);SDL.audio=null;SDL.allocateChannels(0)}}function _SDL_LockSurface(surf){var surfData=SDL.surfaces[surf];surfData.locked++;if(surfData.locked>1)return 0;if(!surfData.buffer){surfData.buffer=_malloc(surfData.width*surfData.height*4);HEAP32[surf+20>>2]=surfData.buffer}HEAP32[surf+20>>2]=surfData.buffer;if(surf==SDL.screen&&Module.screenIsReadOnly&&surfData.image)return 0;if(SDL.defaults.discardOnLock){if(!surfData.image){surfData.image=surfData.ctx.createImageData(surfData.width,surfData.height)}if(!SDL.defaults.opaqueFrontBuffer)return}else{surfData.image=surfData.ctx.getImageData(0,0,surfData.width,surfData.height)}if(surf==SDL.screen&&SDL.defaults.opaqueFrontBuffer){var data=surfData.image.data;var num=data.length;for(var i=0;i<num/4;i++){data[i*4+3]=255}}if(SDL.defaults.copyOnLock&&!SDL.defaults.discardOnLock){if(surfData.isFlagSet(2097152)){throw"CopyOnLock is not supported for SDL_LockSurface with SDL_HWPALETTE flag set"+(new Error).stack}else{HEAPU8.set(surfData.image.data,surfData.buffer)}}return 0}function _SDL_FreeRW(rwopsID){SDL.rwops[rwopsID]=null;while(SDL.rwops.length>0&&SDL.rwops[SDL.rwops.length-1]===null){SDL.rwops.pop()}}function _IMG_Load_RW(rwopsID,freeSrc){try{function cleanup(){if(rwops&&freeSrc)_SDL_FreeRW(rwopsID)}function addCleanup(func){var old=cleanup;cleanup=function added_cleanup(){old();func()}}function callStbImage(func,params){var x=Module["_malloc"](4);var y=Module["_malloc"](4);var comp=Module["_malloc"](4);addCleanup((function(){Module["_free"](x);Module["_free"](y);Module["_free"](comp);if(data)Module["_stbi_image_free"](data)}));var data=Module["_"+func].apply(null,params.concat([x,y,comp,0]));if(!data)return null;return{rawData:true,data:data,width:HEAP32[x>>2],height:HEAP32[y>>2],size:HEAP32[x>>2]*HEAP32[y>>2]*HEAP32[comp>>2],bpp:HEAP32[comp>>2]}}var rwops=SDL.rwops[rwopsID];if(rwops===undefined){return 0}var filename=rwops.filename;if(filename===undefined){Runtime.warnOnce("Only file names that have been preloaded are supported for IMG_Load_RW. Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js), or package files with --use-preload-plugins");return 0}if(!raw){filename=PATH.resolve(filename);var raw=Module["preloadedImages"][filename];if(!raw){if(raw===null)Module.printErr("Trying to reuse preloaded image, but freePreloadedMediaOnUse is set!");Runtime.warnOnce("Cannot find preloaded image "+filename);Runtime.warnOnce("Cannot find preloaded image "+filename+". Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js), or package files with --use-preload-plugins");return 0}else if(Module["freePreloadedMediaOnUse"]){Module["preloadedImages"][filename]=null}}var surf=SDL.makeSurface(raw.width,raw.height,0,false,"load:"+filename);var surfData=SDL.surfaces[surf];surfData.ctx.globalCompositeOperation="copy";if(!raw.rawData){surfData.ctx.drawImage(raw,0,0,raw.width,raw.height,0,0,raw.width,raw.height)}else{var imageData=surfData.ctx.getImageData(0,0,surfData.width,surfData.height);if(raw.bpp==4){imageData.data.set(HEAPU8.subarray(raw.data,raw.data+raw.size))}else if(raw.bpp==3){var pixels=raw.size/3;var data=imageData.data;var sourcePtr=raw.data;var destPtr=0;for(var i=0;i<pixels;i++){data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=255}}else if(raw.bpp==1){var pixels=raw.size;var data=imageData.data;var sourcePtr=raw.data;var destPtr=0;for(var i=0;i<pixels;i++){var value=HEAPU8[sourcePtr++>>0];data[destPtr++]=value;data[destPtr++]=value;data[destPtr++]=value;data[destPtr++]=255}}else{Module.printErr("cannot handle bpp "+raw.bpp);return 0}surfData.ctx.putImageData(imageData,0,0)}surfData.ctx.globalCompositeOperation="source-over";_SDL_LockSurface(surf);surfData.locked--;if(SDL.GL){surfData.canvas=surfData.ctx=null}return surf}finally{cleanup()}}function _SDL_RWFromFile(_name,mode){var id=SDL.rwops.length;var name=Pointer_stringify(_name);SDL.rwops.push({filename:name,mimetype:Browser.getMimetype(name)});return id}function _IMG_Load(filename){var rwops=_SDL_RWFromFile(filename);var result=_IMG_Load_RW(rwops,1);return result}function _SDL_UpperBlitScaled(src,srcrect,dst,dstrect){return SDL.blitSurface(src,srcrect,dst,dstrect,true)}function _SDL_UpperBlit(src,srcrect,dst,dstrect){return SDL.blitSurface(src,srcrect,dst,dstrect,false)}function _SDL_GetTicks(){return Date.now()-SDL.startTime|0}var SDL={defaults:{width:320,height:200,copyOnLock:true,discardOnLock:false,opaqueFrontBuffer:true},version:null,surfaces:{},canvasPool:[],events:[],fonts:[null],audios:[null],rwops:[null],music:{audio:null,volume:1},mixerFrequency:22050,mixerFormat:32784,mixerNumChannels:2,mixerChunkSize:1024,channelMinimumNumber:0,GL:false,glAttributes:{0:3,1:3,2:2,3:0,4:0,5:1,6:16,7:0,8:0,9:0,10:0,11:0,12:0,13:0,14:0,15:1,16:0,17:0,18:0},keyboardState:null,keyboardMap:{},canRequestFullscreen:false,isRequestingFullscreen:false,textInput:false,startTime:null,initFlags:0,buttonState:0,modState:0,DOMButtons:[0,0,0],DOMEventToSDLEvent:{},TOUCH_DEFAULT_ID:0,eventHandler:null,eventHandlerContext:null,eventHandlerTemp:0,keyCodes:{16:1249,17:1248,18:1250,20:1081,33:1099,34:1102,35:1101,36:1098,37:1104,38:1106,39:1103,40:1105,44:316,45:1097,46:127,91:1251,93:1125,96:1122,97:1113,98:1114,99:1115,100:1116,101:1117,102:1118,103:1119,104:1120,105:1121,106:1109,107:1111,109:1110,110:1123,111:1108,112:1082,113:1083,114:1084,115:1085,116:1086,117:1087,118:1088,119:1089,120:1090,121:1091,122:1092,123:1093,124:1128,125:1129,126:1130,127:1131,128:1132,129:1133,130:1134,131:1135,132:1136,133:1137,134:1138,135:1139,144:1107,160:94,161:33,162:34,163:35,164:36,165:37,166:38,167:95,168:40,169:41,170:42,171:43,172:124,173:45,174:123,175:125,176:126,181:127,182:129,183:128,188:44,190:46,191:47,192:96,219:91,220:92,221:93,222:39,224:1251},scanCodes:{8:42,9:43,13:40,27:41,32:44,35:204,39:53,44:54,46:55,47:56,48:39,49:30,50:31,51:32,52:33,53:34,54:35,55:36,56:37,57:38,58:203,59:51,61:46,91:47,92:49,93:48,96:52,97:4,98:5,99:6,100:7,101:8,102:9,103:10,104:11,105:12,106:13,107:14,108:15,109:16,110:17,111:18,112:19,113:20,114:21,115:22,116:23,117:24,118:25,119:26,120:27,121:28,122:29,127:76,305:224,308:226,316:70},loadRect:(function(rect){return{x:HEAP32[rect+0>>2],y:HEAP32[rect+4>>2],w:HEAP32[rect+8>>2],h:HEAP32[rect+12>>2]}}),updateRect:(function(rect,r){HEAP32[rect>>2]=r.x;HEAP32[rect+4>>2]=r.y;HEAP32[rect+8>>2]=r.w;HEAP32[rect+12>>2]=r.h}),intersectionOfRects:(function(first,second){var leftX=Math.max(first.x,second.x);var leftY=Math.max(first.y,second.y);var rightX=Math.min(first.x+first.w,second.x+second.w);var rightY=Math.min(first.y+first.h,second.y+second.h);return{x:leftX,y:leftY,w:Math.max(leftX,rightX)-leftX,h:Math.max(leftY,rightY)-leftY}}),checkPixelFormat:(function(fmt){}),loadColorToCSSRGB:(function(color){var rgba=HEAP32[color>>2];return"rgb("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+")"}),loadColorToCSSRGBA:(function(color){var rgba=HEAP32[color>>2];return"rgba("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+","+(rgba>>24&255)/255+")"}),translateColorToCSSRGBA:(function(rgba){return"rgba("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+","+(rgba>>>24)/255+")"}),translateRGBAToCSSRGBA:(function(r,g,b,a){return"rgba("+(r&255)+","+(g&255)+","+(b&255)+","+(a&255)/255+")"}),translateRGBAToColor:(function(r,g,b,a){return r|g<<8|b<<16|a<<24}),makeSurface:(function(width,height,flags,usePageCanvas,source,rmask,gmask,bmask,amask){flags=flags||0;var is_SDL_HWSURFACE=flags&1;var is_SDL_HWPALETTE=flags&2097152;var is_SDL_OPENGL=flags&67108864;var surf=_malloc(60);var pixelFormat=_malloc(44);var bpp=is_SDL_HWPALETTE?1:4;var buffer=0;if(!is_SDL_HWSURFACE&&!is_SDL_OPENGL){buffer=_malloc(width*height*4)}HEAP32[surf>>2]=flags;HEAP32[surf+4>>2]=pixelFormat;HEAP32[surf+8>>2]=width;HEAP32[surf+12>>2]=height;HEAP32[surf+16>>2]=width*bpp;HEAP32[surf+20>>2]=buffer;HEAP32[surf+36>>2]=0;HEAP32[surf+40>>2]=0;HEAP32[surf+44>>2]=Module["canvas"].width;HEAP32[surf+48>>2]=Module["canvas"].height;HEAP32[surf+56>>2]=1;HEAP32[pixelFormat>>2]=-2042224636;HEAP32[pixelFormat+4>>2]=0;HEAP8[pixelFormat+8>>0]=bpp*8;HEAP8[pixelFormat+9>>0]=bpp;HEAP32[pixelFormat+12>>2]=rmask||255;HEAP32[pixelFormat+16>>2]=gmask||65280;HEAP32[pixelFormat+20>>2]=bmask||16711680;HEAP32[pixelFormat+24>>2]=amask||4278190080;SDL.GL=SDL.GL||is_SDL_OPENGL;var canvas;if(!usePageCanvas){if(SDL.canvasPool.length>0){canvas=SDL.canvasPool.pop()}else{canvas=document.createElement("canvas")}canvas.width=width;canvas.height=height}else{canvas=Module["canvas"]}var webGLContextAttributes={antialias:SDL.glAttributes[13]!=0&&SDL.glAttributes[14]>1,depth:SDL.glAttributes[6]>0,stencil:SDL.glAttributes[7]>0};var ctx=Browser.createContext(canvas,is_SDL_OPENGL,usePageCanvas,webGLContextAttributes);SDL.surfaces[surf]={width:width,height:height,canvas:canvas,ctx:ctx,surf:surf,buffer:buffer,pixelFormat:pixelFormat,alpha:255,flags:flags,locked:0,usePageCanvas:usePageCanvas,source:source,isFlagSet:(function(flag){return flags&flag})};return surf}),copyIndexedColorData:(function(surfData,rX,rY,rW,rH){if(!surfData.colors){return}var fullWidth=Module["canvas"].width;var fullHeight=Module["canvas"].height;var startX=rX||0;var startY=rY||0;var endX=(rW||fullWidth-startX)+startX;var endY=(rH||fullHeight-startY)+startY;var buffer=surfData.buffer;if(!surfData.image.data32){surfData.image.data32=new Uint32Array(surfData.image.data.buffer)}var data32=surfData.image.data32;var colors32=surfData.colors32;for(var y=startY;y<endY;++y){var base=y*fullWidth;for(var x=startX;x<endX;++x){data32[base+x]=colors32[HEAPU8[buffer+base+x>>0]]}}}),freeSurface:(function(surf){var refcountPointer=surf+56;var refcount=HEAP32[refcountPointer>>2];if(refcount>1){HEAP32[refcountPointer>>2]=refcount-1;return}var info=SDL.surfaces[surf];if(!info.usePageCanvas&&info.canvas)SDL.canvasPool.push(info.canvas);if(info.buffer)_free(info.buffer);_free(info.pixelFormat);_free(surf);SDL.surfaces[surf]=null;if(surf===SDL.screen){SDL.screen=null}}),blitSurface__deps:["SDL_LockSurface"],blitSurface:(function(src,srcrect,dst,dstrect,scale){var srcData=SDL.surfaces[src];var dstData=SDL.surfaces[dst];var sr,dr;if(srcrect){sr=SDL.loadRect(srcrect)}else{sr={x:0,y:0,w:srcData.width,h:srcData.height}}if(dstrect){dr=SDL.loadRect(dstrect)}else{dr={x:0,y:0,w:srcData.width,h:srcData.height}}if(dstData.clipRect){var widthScale=!scale||sr.w===0?1:sr.w/dr.w;var heightScale=!scale||sr.h===0?1:sr.h/dr.h;dr=SDL.intersectionOfRects(dstData.clipRect,dr);sr.w=dr.w*widthScale;sr.h=dr.h*heightScale;if(dstrect){SDL.updateRect(dstrect,dr)}}var blitw,blith;if(scale){blitw=dr.w;blith=dr.h}else{blitw=sr.w;blith=sr.h}if(sr.w===0||sr.h===0||blitw===0||blith===0){return 0}var oldAlpha=dstData.ctx.globalAlpha;dstData.ctx.globalAlpha=srcData.alpha/255;dstData.ctx.drawImage(srcData.canvas,sr.x,sr.y,sr.w,sr.h,dr.x,dr.y,blitw,blith);dstData.ctx.globalAlpha=oldAlpha;if(dst!=SDL.screen){Runtime.warnOnce("WARNING: copying canvas data to memory for compatibility");_SDL_LockSurface(dst);dstData.locked--}return 0}),downFingers:{},savedKeydown:null,receiveEvent:(function(event){function unpressAllPressedKeys(){for(var code in SDL.keyboardMap){SDL.events.push({type:"keyup",keyCode:SDL.keyboardMap[code]})}}switch(event.type){case"touchstart":case"touchmove":{event.preventDefault();var touches=[];if(event.type==="touchstart"){for(var i=0;i<event.touches.length;i++){var touch=event.touches[i];if(SDL.downFingers[touch.identifier]!=true){SDL.downFingers[touch.identifier]=true;touches.push(touch)}}}else{touches=event.touches}var firstTouch=touches[0];if(event.type=="touchstart"){SDL.DOMButtons[0]=1}var mouseEventType;switch(event.type){case"touchstart":mouseEventType="mousedown";break;case"touchmove":mouseEventType="mousemove";break}var mouseEvent={type:mouseEventType,button:0,pageX:firstTouch.clientX,pageY:firstTouch.clientY};SDL.events.push(mouseEvent);for(var i=0;i<touches.length;i++){var touch=touches[i];SDL.events.push({type:event.type,touch:touch})}break};case"touchend":{event.preventDefault();for(var i=0;i<event.changedTouches.length;i++){var touch=event.changedTouches[i];if(SDL.downFingers[touch.identifier]===true){delete SDL.downFingers[touch.identifier]}}var mouseEvent={type:"mouseup",button:0,pageX:event.changedTouches[0].clientX,pageY:event.changedTouches[0].clientY};SDL.DOMButtons[0]=0;SDL.events.push(mouseEvent);for(var i=0;i<event.changedTouches.length;i++){var touch=event.changedTouches[i];SDL.events.push({type:"touchend",touch:touch})}break};case"DOMMouseScroll":case"mousewheel":case"wheel":var delta=-Browser.getMouseWheelDelta(event);delta=delta==0?0:delta>0?Math.max(delta,1):Math.min(delta,-1);var button=delta>0?3:4;SDL.events.push({type:"mousedown",button:button,pageX:event.pageX,pageY:event.pageY});SDL.events.push({type:"mouseup",button:button,pageX:event.pageX,pageY:event.pageY});SDL.events.push({type:"wheel",deltaX:0,deltaY:delta});event.preventDefault();break;case"mousemove":if(SDL.DOMButtons[0]===1){SDL.events.push({type:"touchmove",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}})}if(Browser.pointerLock){if("mozMovementX"in event){event["movementX"]=event["mozMovementX"];event["movementY"]=event["mozMovementY"]}if(event["movementX"]==0&&event["movementY"]==0){event.preventDefault();return}};case"keydown":case"keyup":case"keypress":case"mousedown":case"mouseup":if(event.type!=="keydown"||!SDL.unicode&&!SDL.textInput||event.keyCode===8||event.keyCode===9){event.preventDefault()}if(event.type=="mousedown"){SDL.DOMButtons[event.button]=1;SDL.events.push({type:"touchstart",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}})}else if(event.type=="mouseup"){if(!SDL.DOMButtons[event.button]){return}SDL.events.push({type:"touchend",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}});SDL.DOMButtons[event.button]=0}if(event.type==="keydown"||event.type==="mousedown"){SDL.canRequestFullscreen=true}else if(event.type==="keyup"||event.type==="mouseup"){if(SDL.isRequestingFullscreen){Module["requestFullScreen"](true,true);SDL.isRequestingFullscreen=false}SDL.canRequestFullscreen=false}if(event.type==="keypress"&&SDL.savedKeydown){SDL.savedKeydown.keypressCharCode=event.charCode;SDL.savedKeydown=null}else if(event.type==="keydown"){SDL.savedKeydown=event}if(event.type!=="keypress"||SDL.textInput){SDL.events.push(event)}break;case"mouseout":for(var i=0;i<3;i++){if(SDL.DOMButtons[i]){SDL.events.push({type:"mouseup",button:i,pageX:event.pageX,pageY:event.pageY});SDL.DOMButtons[i]=0}}event.preventDefault();break;case"focus":SDL.events.push(event);event.preventDefault();break;case"blur":SDL.events.push(event);unpressAllPressedKeys();event.preventDefault();break;case"visibilitychange":SDL.events.push({type:"visibilitychange",visible:!document.hidden});unpressAllPressedKeys();event.preventDefault();break;case"unload":if(Browser.mainLoop.runner){SDL.events.push(event);Browser.mainLoop.runner()}return;case"resize":SDL.events.push(event);if(event.preventDefault){event.preventDefault()}break}if(SDL.events.length>=1e4){Module.printErr("SDL event queue full, dropping events");SDL.events=SDL.events.slice(0,1e4)}SDL.flushEventsToHandler();return}),lookupKeyCodeForEvent:(function(event){var code=event.keyCode;if(code>=65&&code<=90){code+=32}else{code=SDL.keyCodes[event.keyCode]||event.keyCode;if(event.location===KeyboardEvent.DOM_KEY_LOCATION_RIGHT&&code>=(224|1<<10)&&code<=(227|1<<10)){code+=4}}return code}),handleEvent:(function(event){if(event.handled)return;event.handled=true;switch(event.type){case"touchstart":case"touchend":case"touchmove":{Browser.calculateMouseEvent(event);break};case"keydown":case"keyup":{var down=event.type==="keydown";var code=SDL.lookupKeyCodeForEvent(event);HEAP8[SDL.keyboardState+code>>0]=down;SDL.modState=(HEAP8[SDL.keyboardState+1248>>0]?64:0)|(HEAP8[SDL.keyboardState+1249>>0]?1:0)|(HEAP8[SDL.keyboardState+1250>>0]?256:0)|(HEAP8[SDL.keyboardState+1252>>0]?128:0)|(HEAP8[SDL.keyboardState+1253>>0]?2:0)|(HEAP8[SDL.keyboardState+1254>>0]?512:0);if(down){SDL.keyboardMap[code]=event.keyCode}else{delete SDL.keyboardMap[code]}break};case"mousedown":case"mouseup":if(event.type=="mousedown"){SDL.buttonState|=1<<event.button}else if(event.type=="mouseup"){SDL.buttonState&=~(1<<event.button)};case"mousemove":{Browser.calculateMouseEvent(event);break}}}),flushEventsToHandler:(function(){if(!SDL.eventHandler)return;while(SDL.pollEvent(SDL.eventHandlerTemp)){Runtime.dynCall("iii",SDL.eventHandler,[SDL.eventHandlerContext,SDL.eventHandlerTemp])}}),pollEvent:(function(ptr){if(SDL.initFlags&512&&SDL.joystickEventState){SDL.queryJoysticks()}if(ptr){while(SDL.events.length>0){if(SDL.makeCEvent(SDL.events.shift(),ptr)!==false)return 1}return 0}else{return SDL.events.length>0}}),makeCEvent:(function(event,ptr){if(typeof event==="number"){_memcpy(ptr,event,28);_free(event);return}SDL.handleEvent(event);switch(event.type){case"keydown":case"keyup":{var down=event.type==="keydown";var key=SDL.lookupKeyCodeForEvent(event);var scan;if(key>=1024){scan=key-1024}else{scan=SDL.scanCodes[key]||key}HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+8>>0]=down?1:0;HEAP8[ptr+9>>0]=0;HEAP32[ptr+12>>2]=scan;HEAP32[ptr+16>>2]=key;HEAP16[ptr+20>>1]=SDL.modState;HEAP32[ptr+24>>2]=event.keypressCharCode||key;break};case"keypress":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];var cStr=intArrayFromString(String.fromCharCode(event.charCode));for(var i=0;i<cStr.length;++i){HEAP8[ptr+(8+i)>>0]=cStr[i]}break};case"mousedown":case"mouseup":case"mousemove":{if(event.type!="mousemove"){var down=event.type==="mousedown";HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP32[ptr+8>>2]=0;HEAP32[ptr+12>>2]=0;HEAP8[ptr+16>>0]=event.button+1;HEAP8[ptr+17>>0]=down?1:0;HEAP32[ptr+20>>2]=Browser.mouseX;HEAP32[ptr+24>>2]=Browser.mouseY}else{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP32[ptr+8>>2]=0;HEAP32[ptr+12>>2]=0;HEAP32[ptr+16>>2]=SDL.buttonState;HEAP32[ptr+20>>2]=Browser.mouseX;HEAP32[ptr+24>>2]=Browser.mouseY;HEAP32[ptr+28>>2]=Browser.mouseMovementX;HEAP32[ptr+32>>2]=Browser.mouseMovementY}break};case"wheel":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+16>>2]=event.deltaX;HEAP32[ptr+20>>2]=event.deltaY;break};case"touchstart":case"touchend":case"touchmove":{var touch=event.touch;if(!Browser.touches[touch.identifier])break;var w=Module["canvas"].width;var h=Module["canvas"].height;var x=Browser.touches[touch.identifier].x/w;var y=Browser.touches[touch.identifier].y/h;var lx=Browser.lastTouches[touch.identifier].x/w;var ly=Browser.lastTouches[touch.identifier].y/h;var dx=x-lx;var dy=y-ly;if(touch["deviceID"]===undefined)touch.deviceID=SDL.TOUCH_DEFAULT_ID;if(dx===0&&dy===0&&event.type==="touchmove")return false;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=_SDL_GetTicks();tempI64=[touch.deviceID>>>0,(tempDouble=touch.deviceID,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr+8>>2]=tempI64[0],HEAP32[ptr+12>>2]=tempI64[1];tempI64=[touch.identifier>>>0,(tempDouble=touch.identifier,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr+16>>2]=tempI64[0],HEAP32[ptr+20>>2]=tempI64[1];HEAPF32[ptr+24>>2]=x;HEAPF32[ptr+28>>2]=y;HEAPF32[ptr+32>>2]=dx;HEAPF32[ptr+36>>2]=dy;if(touch.force!==undefined){HEAPF32[ptr+40>>2]=touch.force}else{HEAPF32[ptr+40>>2]=event.type=="touchend"?0:1}break};case"unload":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];break};case"resize":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=event.w;HEAP32[ptr+8>>2]=event.h;break};case"joystick_button_up":case"joystick_button_down":{var state=event.type==="joystick_button_up"?0:1;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+4>>0]=event.index;HEAP8[ptr+5>>0]=event.button;HEAP8[ptr+6>>0]=state;break};case"joystick_axis_motion":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+4>>0]=event.index;HEAP8[ptr+5>>0]=event.axis;HEAP32[ptr+8>>2]=SDL.joystickAxisValueConversion(event.value);break};case"focus":{var SDL_WINDOWEVENT_FOCUS_GAINED=12;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=SDL_WINDOWEVENT_FOCUS_GAINED;break};case"blur":{var SDL_WINDOWEVENT_FOCUS_LOST=13;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=SDL_WINDOWEVENT_FOCUS_LOST;break};case"visibilitychange":{var SDL_WINDOWEVENT_SHOWN=1;var SDL_WINDOWEVENT_HIDDEN=2;var visibilityEventID=event.visible?SDL_WINDOWEVENT_SHOWN:SDL_WINDOWEVENT_HIDDEN;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=visibilityEventID;break};default:throw"Unhandled SDL event: "+event.type}}),estimateTextWidth:(function(fontData,text){var h=fontData.size;var fontString=h+"px "+fontData.name;var tempCtx=SDL.ttfContext;tempCtx.save();tempCtx.font=fontString;var ret=tempCtx.measureText(text).width|0;tempCtx.restore();return ret}),allocateChannels:(function(num){if(SDL.numChannels&&SDL.numChannels>=num&&num!=0)return;SDL.numChannels=num;SDL.channels=[];for(var i=0;i<num;i++){SDL.channels[i]={audio:null,volume:1}}}),setGetVolume:(function(info,volume){if(!info)return 0;var ret=info.volume*128;if(volume!=-1){info.volume=Math.min(Math.max(volume,0),128)/128;if(info.audio){try{info.audio.volume=info.volume;if(info.audio.webAudioGainNode)info.audio.webAudioGainNode["gain"]["value"]=info.volume}catch(e){Module.printErr("setGetVolume failed to set audio volume: "+e)}}}return ret}),setPannerPosition:(function(info,x,y,z){if(!info)return;if(info.audio){if(info.audio.webAudioPannerNode){info.audio.webAudioPannerNode["setPosition"](x,y,z)}}}),playWebAudio:(function(audio){if(!audio)return;if(audio.webAudioNode)return;if(!SDL.webAudioAvailable())return;try{var webAudio=audio.resource.webAudio;audio.paused=false;if(!webAudio.decodedBuffer){if(webAudio.onDecodeComplete===undefined)abort("Cannot play back audio object that was not loaded");webAudio.onDecodeComplete.push((function(){if(!audio.paused)SDL.playWebAudio(audio)}));return}audio.webAudioNode=SDL.audioContext["createBufferSource"]();audio.webAudioNode["buffer"]=webAudio.decodedBuffer;audio.webAudioNode["loop"]=audio.loop;audio.webAudioNode["onended"]=(function(){audio["onended"]()});audio.webAudioPannerNode=SDL.audioContext["createPanner"]();audio.webAudioPannerNode["panningModel"]="equalpower";audio.webAudioGainNode=SDL.audioContext["createGain"]();audio.webAudioGainNode["gain"]["value"]=audio.volume;audio.webAudioNode["connect"](audio.webAudioPannerNode);audio.webAudioPannerNode["connect"](audio.webAudioGainNode);audio.webAudioGainNode["connect"](SDL.audioContext["destination"]);audio.webAudioNode["start"](0,audio.currentPosition);audio.startTime=SDL.audioContext["currentTime"]-audio.currentPosition}catch(e){Module.printErr("playWebAudio failed: "+e)}}),pauseWebAudio:(function(audio){if(!audio)return;if(audio.webAudioNode){try{audio.currentPosition=(SDL.audioContext["currentTime"]-audio.startTime)%audio.resource.webAudio.decodedBuffer.duration;audio.webAudioNode["onended"]=undefined;audio.webAudioNode.stop();audio.webAudioNode=undefined}catch(e){Module.printErr("pauseWebAudio failed: "+e)}}audio.paused=true}),openAudioContext:(function(){if(!SDL.audioContext){if(typeof AudioContext!=="undefined")SDL.audioContext=new AudioContext;else if(typeof webkitAudioContext!=="undefined")SDL.audioContext=new webkitAudioContext}}),webAudioAvailable:(function(){return!!SDL.audioContext}),fillWebAudioBufferFromHeap:(function(heapPtr,sizeSamplesPerChannel,dstAudioBuffer){var numChannels=SDL.audio.channels;for(var c=0;c<numChannels;++c){var channelData=dstAudioBuffer["getChannelData"](c);if(channelData.length!=sizeSamplesPerChannel){throw"Web Audio output buffer length mismatch! Destination size: "+channelData.length+" samples vs expected "+sizeSamplesPerChannel+" samples!"}if(SDL.audio.format==32784){for(var j=0;j<sizeSamplesPerChannel;++j){channelData[j]=HEAP16[heapPtr+(j*numChannels+c)*2>>1]/32768}}else if(SDL.audio.format==8){for(var j=0;j<sizeSamplesPerChannel;++j){var v=HEAP8[heapPtr+(j*numChannels+c)>>0];channelData[j]=(v>=0?v-128:v+128)/128}}}}),debugSurface:(function(surfData){console.log("dumping surface "+[surfData.surf,surfData.source,surfData.width,surfData.height]);var image=surfData.ctx.getImageData(0,0,surfData.width,surfData.height);var data=image.data;var num=Math.min(surfData.width,surfData.height);for(var i=0;i<num;i++){console.log("   diagonal "+i+":"+[data[i*surfData.width*4+i*4+0],data[i*surfData.width*4+i*4+1],data[i*surfData.width*4+i*4+2],data[i*surfData.width*4+i*4+3]])}}),joystickEventState:1,lastJoystickState:{},joystickNamePool:{},recordJoystickState:(function(joystick,state){var buttons=new Array(state.buttons.length);for(var i=0;i<state.buttons.length;i++){buttons[i]=SDL.getJoystickButtonState(state.buttons[i])}SDL.lastJoystickState[joystick]={buttons:buttons,axes:state.axes.slice(0),timestamp:state.timestamp,index:state.index,id:state.id}}),getJoystickButtonState:(function(button){if(typeof button==="object"){return button.pressed}else{return button>0}}),queryJoysticks:(function(){for(var joystick in SDL.lastJoystickState){var state=SDL.getGamepad(joystick-1);var prevState=SDL.lastJoystickState[joystick];if(typeof state.timestamp!=="number"||state.timestamp!==prevState.timestamp){var i;for(i=0;i<state.buttons.length;i++){var buttonState=SDL.getJoystickButtonState(state.buttons[i]);if(buttonState!==prevState.buttons[i]){SDL.events.push({type:buttonState?"joystick_button_down":"joystick_button_up",joystick:joystick,index:joystick-1,button:i})}}for(i=0;i<state.axes.length;i++){if(state.axes[i]!==prevState.axes[i]){SDL.events.push({type:"joystick_axis_motion",joystick:joystick,index:joystick-1,axis:i,value:state.axes[i]})}}SDL.recordJoystickState(joystick,state)}}}),joystickAxisValueConversion:(function(value){return Math.ceil((value+1)*32767.5-32768)}),getGamepads:(function(){var fcn=navigator.getGamepads||navigator.webkitGamepads||navigator.mozGamepads||navigator.gamepads||navigator.webkitGetGamepads;if(fcn!==undefined){return fcn.apply(navigator)}else{return[]}}),getGamepad:(function(deviceIndex){var gamepads=SDL.getGamepads();if(gamepads.length>deviceIndex&&deviceIndex>=0){return gamepads[deviceIndex]}return null})};function _Mix_OpenAudio(frequency,format,channels,chunksize){SDL.openAudioContext();SDL.allocateChannels(32);SDL.mixerFrequency=frequency;SDL.mixerFormat=format;SDL.mixerNumChannels=channels;SDL.mixerChunkSize=chunksize;return 0}function _Mix_Volume(channel,volume){if(channel==-1){for(var i=0;i<SDL.numChannels-1;i++){_Mix_Volume(i,volume)}return _Mix_Volume(SDL.numChannels-1,volume)}return SDL.setGetVolume(SDL.channels[channel],volume)}function _Mix_Playing(channel){if(channel===-1){var count=0;for(var i=0;i<SDL.channels.length;i++){count+=_Mix_Playing(i)}return count}var info=SDL.channels[channel];if(info&&info.audio&&!info.audio.paused){return 1}return 0}var _emscripten_landingpad=true;var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);ret=ret.slice(0,Math.max(0,bufsize));writeStringToMemory(ret,buf,true);return ret.length}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall195(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___cxa_free_exception(ptr){try{return _free(ptr)}catch(e){}}function ___cxa_end_catch(){if(___cxa_end_catch.rethrown){___cxa_end_catch.rethrown=false;return}asm["setThrew"](0);var ptr=EXCEPTIONS.caught.pop();if(ptr){EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr));EXCEPTIONS.last=0}}function _glBindTexture(target,texture){GLctx.bindTexture(target,texture?GL.textures[texture]:null)}var GLImmediate={MapTreeLib:null,spawnMapTreeLib:(function(){function CNaiveListMap(){var list=[];this.insert=function CNaiveListMap_insert(key,val){if(this.contains(key|0))return false;list.push([key,val]);return true};var __contains_i;this.contains=function CNaiveListMap_contains(key){for(__contains_i=0;__contains_i<list.length;++__contains_i){if(list[__contains_i][0]===key)return true}return false};var __get_i;this.get=function CNaiveListMap_get(key){for(__get_i=0;__get_i<list.length;++__get_i){if(list[__get_i][0]===key)return list[__get_i][1]}return undefined}}function CMapTree(){function CNLNode(){var map=new CNaiveListMap;this.child=function CNLNode_child(keyFrag){if(!map.contains(keyFrag|0)){map.insert(keyFrag|0,new CNLNode)}return map.get(keyFrag|0)};this.value=undefined;this.get=function CNLNode_get(){return this.value};this.set=function CNLNode_set(val){this.value=val}}function CKeyView(root){var cur;this.reset=function CKeyView_reset(){cur=root;return this};this.reset();this.next=function CKeyView_next(keyFrag){cur=cur.child(keyFrag);return this};this.get=function CKeyView_get(){return cur.get()};this.set=function CKeyView_set(val){cur.set(val)}}var root;var staticKeyView;this.createKeyView=function CNLNode_createKeyView(){return new CKeyView(root)};this.clear=function CNLNode_clear(){root=new CNLNode;staticKeyView=this.createKeyView()};this.clear();this.getStaticKeyView=function CNLNode_getStaticKeyView(){staticKeyView.reset();return staticKeyView}}return{create:(function(){return new CMapTree})}}),TexEnvJIT:null,spawnTexEnvJIT:(function(){var GL_TEXTURE0=33984;var GL_TEXTURE_1D=3552;var GL_TEXTURE_2D=3553;var GL_TEXTURE_3D=32879;var GL_TEXTURE_CUBE_MAP=34067;var GL_TEXTURE_ENV=8960;var GL_TEXTURE_ENV_MODE=8704;var GL_TEXTURE_ENV_COLOR=8705;var GL_TEXTURE_CUBE_MAP_POSITIVE_X=34069;var GL_TEXTURE_CUBE_MAP_NEGATIVE_X=34070;var GL_TEXTURE_CUBE_MAP_POSITIVE_Y=34071;var GL_TEXTURE_CUBE_MAP_NEGATIVE_Y=34072;var GL_TEXTURE_CUBE_MAP_POSITIVE_Z=34073;var GL_TEXTURE_CUBE_MAP_NEGATIVE_Z=34074;var GL_SRC0_RGB=34176;var GL_SRC1_RGB=34177;var GL_SRC2_RGB=34178;var GL_SRC0_ALPHA=34184;var GL_SRC1_ALPHA=34185;var GL_SRC2_ALPHA=34186;var GL_OPERAND0_RGB=34192;var GL_OPERAND1_RGB=34193;var GL_OPERAND2_RGB=34194;var GL_OPERAND0_ALPHA=34200;var GL_OPERAND1_ALPHA=34201;var GL_OPERAND2_ALPHA=34202;var GL_COMBINE_RGB=34161;var GL_COMBINE_ALPHA=34162;var GL_RGB_SCALE=34163;var GL_ALPHA_SCALE=3356;var GL_ADD=260;var GL_BLEND=3042;var GL_REPLACE=7681;var GL_MODULATE=8448;var GL_DECAL=8449;var GL_COMBINE=34160;var GL_SUBTRACT=34023;var GL_INTERPOLATE=34165;var GL_TEXTURE=5890;var GL_CONSTANT=34166;var GL_PRIMARY_COLOR=34167;var GL_PREVIOUS=34168;var GL_SRC_COLOR=768;var GL_ONE_MINUS_SRC_COLOR=769;var GL_SRC_ALPHA=770;var GL_ONE_MINUS_SRC_ALPHA=771;var GL_RGB=6407;var GL_RGBA=6408;var TEXENVJIT_NAMESPACE_PREFIX="tej_";var TEX_UNIT_UNIFORM_PREFIX="uTexUnit";var TEX_COORD_VARYING_PREFIX="vTexCoord";var PRIM_COLOR_VARYING="vPrimColor";var TEX_MATRIX_UNIFORM_PREFIX="uTexMatrix";var s_texUnits=null;var s_activeTexture=0;var s_requiredTexUnitsForPass=[];function abort(info){assert(false,"[TexEnvJIT] ABORT: "+info)}function abort_noSupport(info){abort("No support: "+info)}function abort_sanity(info){abort("Sanity failure: "+info)}function genTexUnitSampleExpr(texUnitID){var texUnit=s_texUnits[texUnitID];var texType=texUnit.getTexType();var func=null;switch(texType){case GL_TEXTURE_1D:func="texture2D";break;case GL_TEXTURE_2D:func="texture2D";break;case GL_TEXTURE_3D:return abort_noSupport("No support for 3D textures.");case GL_TEXTURE_CUBE_MAP:func="textureCube";break;default:return abort_sanity("Unknown texType: 0x"+texType.toString(16))}var texCoordExpr=TEX_COORD_VARYING_PREFIX+texUnitID;if(TEX_MATRIX_UNIFORM_PREFIX!=null){texCoordExpr="("+TEX_MATRIX_UNIFORM_PREFIX+texUnitID+" * "+texCoordExpr+")"}return func+"("+TEX_UNIT_UNIFORM_PREFIX+texUnitID+", "+texCoordExpr+".xy)"}function getTypeFromCombineOp(op){switch(op){case GL_SRC_COLOR:case GL_ONE_MINUS_SRC_COLOR:return"vec3";case GL_SRC_ALPHA:case GL_ONE_MINUS_SRC_ALPHA:return"float"}return abort_noSupport("Unsupported combiner op: 0x"+op.toString(16))}function getCurTexUnit(){return s_texUnits[s_activeTexture]}function genCombinerSourceExpr(texUnitID,constantExpr,previousVar,src,op){var srcExpr=null;switch(src){case GL_TEXTURE:srcExpr=genTexUnitSampleExpr(texUnitID);break;case GL_CONSTANT:srcExpr=constantExpr;break;case GL_PRIMARY_COLOR:srcExpr=PRIM_COLOR_VARYING;break;case GL_PREVIOUS:srcExpr=previousVar;break;default:return abort_noSupport("Unsupported combiner src: 0x"+src.toString(16))}var expr=null;switch(op){case GL_SRC_COLOR:expr=srcExpr+".rgb";break;case GL_ONE_MINUS_SRC_COLOR:expr="(vec3(1.0) - "+srcExpr+".rgb)";break;case GL_SRC_ALPHA:expr=srcExpr+".a";break;case GL_ONE_MINUS_SRC_ALPHA:expr="(1.0 - "+srcExpr+".a)";break;default:return abort_noSupport("Unsupported combiner op: 0x"+op.toString(16))}return expr}function valToFloatLiteral(val){if(val==Math.round(val))return val+".0";return val}function CTexEnv(){this.mode=GL_MODULATE;this.colorCombiner=GL_MODULATE;this.alphaCombiner=GL_MODULATE;this.colorScale=1;this.alphaScale=1;this.envColor=[0,0,0,0];this.colorSrc=[GL_TEXTURE,GL_PREVIOUS,GL_CONSTANT];this.alphaSrc=[GL_TEXTURE,GL_PREVIOUS,GL_CONSTANT];this.colorOp=[GL_SRC_COLOR,GL_SRC_COLOR,GL_SRC_ALPHA];this.alphaOp=[GL_SRC_ALPHA,GL_SRC_ALPHA,GL_SRC_ALPHA];this.traverseKey={7681:0,8448:1,260:2,3042:3,8449:4,34160:5,34023:3,34165:4,5890:0,34166:1,34167:2,34168:3,768:0,769:1,770:2,768:3};this.key0=-1;this.key1=0;this.key2=0;this.computeKey0=(function(){var k=this.traverseKey;var key=k[this.mode]*1638400;key+=k[this.colorCombiner]*327680;key+=k[this.alphaCombiner]*65536;key+=(this.colorScale-1)*16384;key+=(this.alphaScale-1)*4096;key+=k[this.colorSrc[0]]*1024;key+=k[this.colorSrc[1]]*256;key+=k[this.colorSrc[2]]*64;key+=k[this.alphaSrc[0]]*16;key+=k[this.alphaSrc[1]]*4;key+=k[this.alphaSrc[2]];return key});this.computeKey1=(function(){var k=this.traverseKey;key=k[this.colorOp[0]]*4096;key+=k[this.colorOp[1]]*1024;key+=k[this.colorOp[2]]*256;key+=k[this.alphaOp[0]]*16;key+=k[this.alphaOp[1]]*4;key+=k[this.alphaOp[2]];return key});this.computeKey2=(function(){return this.envColor[0]*16777216+this.envColor[1]*65536+this.envColor[2]*256+1+this.envColor[3]});this.recomputeKey=(function(){this.key0=this.computeKey0();this.key1=this.computeKey1();this.key2=this.computeKey2()});this.invalidateKey=(function(){this.key0=-1;GLImmediate.currentRenderer=null})}function CTexUnit(){this.env=new CTexEnv;this.enabled_tex1D=false;this.enabled_tex2D=false;this.enabled_tex3D=false;this.enabled_texCube=false;this.texTypesEnabled=0;this.traverseState=function CTexUnit_traverseState(keyView){if(this.texTypesEnabled){if(this.env.key0==-1){this.env.recomputeKey()}keyView.next(this.texTypesEnabled|this.env.key0<<4);keyView.next(this.env.key1);keyView.next(this.env.key2)}else{keyView.next(0)}}}CTexUnit.prototype.enabled=function CTexUnit_enabled(){return this.texTypesEnabled};CTexUnit.prototype.genPassLines=function CTexUnit_genPassLines(passOutputVar,passInputVar,texUnitID){if(!this.enabled()){return["vec4 "+passOutputVar+" = "+passInputVar+";"]}var lines=this.env.genPassLines(passOutputVar,passInputVar,texUnitID).join("\n");var texLoadLines="";var texLoadRegex=/(texture.*?\(.*?\))/g;var loadCounter=0;var load;while(load=texLoadRegex.exec(lines)){var texLoadExpr=load[1];var secondOccurrence=lines.slice(load.index+1).indexOf(texLoadExpr);if(secondOccurrence!=-1){var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texLoadVar=prefix+"texload"+loadCounter++;var texLoadLine="vec4 "+texLoadVar+" = "+texLoadExpr+";\n";texLoadLines+=texLoadLine+"\n";lines=lines.split(texLoadExpr).join(texLoadVar);texLoadRegex=/(texture.*\(.*\))/g}}return[texLoadLines+lines]};CTexUnit.prototype.getTexType=function CTexUnit_getTexType(){if(this.enabled_texCube){return GL_TEXTURE_CUBE_MAP}else if(this.enabled_tex3D){return GL_TEXTURE_3D}else if(this.enabled_tex2D){return GL_TEXTURE_2D}else if(this.enabled_tex1D){return GL_TEXTURE_1D}return 0};CTexEnv.prototype.genPassLines=function CTexEnv_genPassLines(passOutputVar,passInputVar,texUnitID){switch(this.mode){case GL_REPLACE:{return["vec4 "+passOutputVar+" = "+genTexUnitSampleExpr(texUnitID)+";"]};case GL_ADD:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";","vec3 "+colorVar+" = "+passInputVar+".rgb + "+texVar+".rgb;","float "+alphaVar+" = "+passInputVar+".a * "+texVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]};case GL_MODULATE:{var line=["vec4 "+passOutputVar," = ",passInputVar," * ",genTexUnitSampleExpr(texUnitID),";"];return[line.join("")]};case GL_DECAL:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";",["vec3 "+colorVar+" = ",passInputVar+".rgb * (1.0 - "+texVar+".a)"," + ",texVar+".rgb * "+texVar+".a",";"].join(""),"float "+alphaVar+" = "+passInputVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]};case GL_BLEND:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";",["vec3 "+colorVar+" = ",passInputVar+".rgb * (1.0 - "+texVar+".rgb)"," + ",PRIM_COLOR_VARYING+".rgb * "+texVar+".rgb",";"].join(""),"float "+alphaVar+" = "+texVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]};case GL_COMBINE:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";var colorLines=this.genCombinerLines(true,colorVar,passInputVar,texUnitID,this.colorCombiner,this.colorSrc,this.colorOp);var alphaLines=this.genCombinerLines(false,alphaVar,passInputVar,texUnitID,this.alphaCombiner,this.alphaSrc,this.alphaOp);var scaledColor=this.colorScale==1?colorVar:colorVar+" * "+valToFloatLiteral(this.colorScale);var scaledAlpha=this.alphaScale==1?alphaVar:alphaVar+" * "+valToFloatLiteral(this.alphaScale);var line=["vec4 "+passOutputVar," = ","vec4(",scaledColor,", ",scaledAlpha,")",";"].join("");return[].concat(colorLines,alphaLines,[line])}}return abort_noSupport("Unsupported TexEnv mode: 0x"+this.mode.toString(16))};CTexEnv.prototype.genCombinerLines=function CTexEnv_getCombinerLines(isColor,outputVar,passInputVar,texUnitID,combiner,srcArr,opArr){var argsNeeded=null;switch(combiner){case GL_REPLACE:argsNeeded=1;break;case GL_MODULATE:case GL_ADD:case GL_SUBTRACT:argsNeeded=2;break;case GL_INTERPOLATE:argsNeeded=3;break;default:return abort_noSupport("Unsupported combiner: 0x"+combiner.toString(16))}var constantExpr=["vec4(",valToFloatLiteral(this.envColor[0]),", ",valToFloatLiteral(this.envColor[1]),", ",valToFloatLiteral(this.envColor[2]),", ",valToFloatLiteral(this.envColor[3]),")"].join("");var src0Expr=argsNeeded>=1?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[0],opArr[0]):null;var src1Expr=argsNeeded>=2?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[1],opArr[1]):null;var src2Expr=argsNeeded>=3?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[2],opArr[2]):null;var outputType=isColor?"vec3":"float";var lines=null;switch(combiner){case GL_REPLACE:{var line=[outputType+" "+outputVar," = ",src0Expr,";"];lines=[line.join("")];break};case GL_MODULATE:{var line=[outputType+" "+outputVar+" = ",src0Expr+" * "+src1Expr,";"];lines=[line.join("")];break};case GL_ADD:{var line=[outputType+" "+outputVar+" = ",src0Expr+" + "+src1Expr,";"];lines=[line.join("")];break};case GL_SUBTRACT:{var line=[outputType+" "+outputVar+" = ",src0Expr+" - "+src1Expr,";"];lines=[line.join("")];break};case GL_INTERPOLATE:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var arg2Var=prefix+"colorSrc2";var arg2Line=getTypeFromCombineOp(this.colorOp[2])+" "+arg2Var+" = "+src2Expr+";";var line=[outputType+" "+outputVar," = ",src0Expr+" * "+arg2Var," + ",src1Expr+" * (1.0 - "+arg2Var+")",";"];lines=[arg2Line,line.join("")];break};default:return abort_sanity("Unmatched TexEnv.colorCombiner?")}return lines};return{init:(function(gl,specifiedMaxTextureImageUnits){var maxTexUnits=0;if(specifiedMaxTextureImageUnits){maxTexUnits=specifiedMaxTextureImageUnits}else if(gl){maxTexUnits=gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS)}s_texUnits=[];for(var i=0;i<maxTexUnits;i++){s_texUnits.push(new CTexUnit)}}),setGLSLVars:(function(uTexUnitPrefix,vTexCoordPrefix,vPrimColor,uTexMatrixPrefix){TEX_UNIT_UNIFORM_PREFIX=uTexUnitPrefix;TEX_COORD_VARYING_PREFIX=vTexCoordPrefix;PRIM_COLOR_VARYING=vPrimColor;TEX_MATRIX_UNIFORM_PREFIX=uTexMatrixPrefix}),genAllPassLines:(function(resultDest,indentSize){indentSize=indentSize||0;s_requiredTexUnitsForPass.length=0;var lines=[];var lastPassVar=PRIM_COLOR_VARYING;for(var i=0;i<s_texUnits.length;i++){if(!s_texUnits[i].enabled())continue;s_requiredTexUnitsForPass.push(i);var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+i+"_";var passOutputVar=prefix+"result";var newLines=s_texUnits[i].genPassLines(passOutputVar,lastPassVar,i);lines=lines.concat(newLines,[""]);lastPassVar=passOutputVar}lines.push(resultDest+" = "+lastPassVar+";");var indent="";for(var i=0;i<indentSize;i++)indent+=" ";var output=indent+lines.join("\n"+indent);return output}),getUsedTexUnitList:(function(){return s_requiredTexUnitsForPass}),traverseState:(function(keyView){for(var i=0;i<s_texUnits.length;i++){s_texUnits[i].traverseState(keyView)}}),getTexUnitType:(function(texUnitID){return s_texUnits[texUnitID].getTexType()}),hook_activeTexture:(function(texture){s_activeTexture=texture-GL_TEXTURE0}),hook_enable:(function(cap){var cur=getCurTexUnit();switch(cap){case GL_TEXTURE_1D:if(!cur.enabled_tex1D){GLImmediate.currentRenderer=null;cur.enabled_tex1D=true;cur.texTypesEnabled|=1}break;case GL_TEXTURE_2D:if(!cur.enabled_tex2D){GLImmediate.currentRenderer=null;cur.enabled_tex2D=true;cur.texTypesEnabled|=2}break;case GL_TEXTURE_3D:if(!cur.enabled_tex3D){GLImmediate.currentRenderer=null;cur.enabled_tex3D=true;cur.texTypesEnabled|=4}break;case GL_TEXTURE_CUBE_MAP:if(!cur.enabled_texCube){GLImmediate.currentRenderer=null;cur.enabled_texCube=true;cur.texTypesEnabled|=8}break}}),hook_disable:(function(cap){var cur=getCurTexUnit();switch(cap){case GL_TEXTURE_1D:if(cur.enabled_tex1D){GLImmediate.currentRenderer=null;cur.enabled_tex1D=false;cur.texTypesEnabled&=~1}break;case GL_TEXTURE_2D:if(cur.enabled_tex2D){GLImmediate.currentRenderer=null;cur.enabled_tex2D=false;cur.texTypesEnabled&=~2}break;case GL_TEXTURE_3D:if(cur.enabled_tex3D){GLImmediate.currentRenderer=null;cur.enabled_tex3D=false;cur.texTypesEnabled&=~4}break;case GL_TEXTURE_CUBE_MAP:if(cur.enabled_texCube){GLImmediate.currentRenderer=null;cur.enabled_texCube=false;cur.texTypesEnabled&=~8}break}}),hook_texEnvf:(function(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_RGB_SCALE:if(env.colorScale!=param){env.invalidateKey();env.colorScale=param}break;case GL_ALPHA_SCALE:if(env.alphaScale!=param){env.invalidateKey();env.alphaScale=param}break;default:Module.printErr("WARNING: Unhandled `pname` in call to `glTexEnvf`.")}}),hook_texEnvi:(function(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_MODE:if(env.mode!=param){env.invalidateKey();env.mode=param}break;case GL_COMBINE_RGB:if(env.colorCombiner!=param){env.invalidateKey();env.colorCombiner=param}break;case GL_COMBINE_ALPHA:if(env.alphaCombiner!=param){env.invalidateKey();env.alphaCombiner=param}break;case GL_SRC0_RGB:if(env.colorSrc[0]!=param){env.invalidateKey();env.colorSrc[0]=param}break;case GL_SRC1_RGB:if(env.colorSrc[1]!=param){env.invalidateKey();env.colorSrc[1]=param}break;case GL_SRC2_RGB:if(env.colorSrc[2]!=param){env.invalidateKey();env.colorSrc[2]=param}break;case GL_SRC0_ALPHA:if(env.alphaSrc[0]!=param){env.invalidateKey();env.alphaSrc[0]=param}break;case GL_SRC1_ALPHA:if(env.alphaSrc[1]!=param){env.invalidateKey();env.alphaSrc[1]=param}break;case GL_SRC2_ALPHA:if(env.alphaSrc[2]!=param){env.invalidateKey();env.alphaSrc[2]=param}break;case GL_OPERAND0_RGB:if(env.colorOp[0]!=param){env.invalidateKey();env.colorOp[0]=param}break;case GL_OPERAND1_RGB:if(env.colorOp[1]!=param){env.invalidateKey();env.colorOp[1]=param}break;case GL_OPERAND2_RGB:if(env.colorOp[2]!=param){env.invalidateKey();env.colorOp[2]=param}break;case GL_OPERAND0_ALPHA:if(env.alphaOp[0]!=param){env.invalidateKey();env.alphaOp[0]=param}break;case GL_OPERAND1_ALPHA:if(env.alphaOp[1]!=param){env.invalidateKey();env.alphaOp[1]=param}break;case GL_OPERAND2_ALPHA:if(env.alphaOp[2]!=param){env.invalidateKey();env.alphaOp[2]=param}break;case GL_RGB_SCALE:if(env.colorScale!=param){env.invalidateKey();env.colorScale=param}break;case GL_ALPHA_SCALE:if(env.alphaScale!=param){env.invalidateKey();env.alphaScale=param}break;default:Module.printErr("WARNING: Unhandled `pname` in call to `glTexEnvi`.")}}),hook_texEnvfv:(function(target,pname,params){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_COLOR:{for(var i=0;i<4;i++){var param=HEAPF32[params+i*4>>2];if(env.envColor[i]!=param){env.invalidateKey();env.envColor[i]=param}}break};default:Module.printErr("WARNING: Unhandled `pname` in call to `glTexEnvfv`.")}}),hook_getTexEnviv:(function(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_MODE:HEAP32[param>>2]=env.mode;return;case GL_TEXTURE_ENV_COLOR:HEAP32[param>>2]=Math.max(Math.min(env.envColor[0]*255,255,-255));HEAP32[param+1>>2]=Math.max(Math.min(env.envColor[1]*255,255,-255));HEAP32[param+2>>2]=Math.max(Math.min(env.envColor[2]*255,255,-255));HEAP32[param+3>>2]=Math.max(Math.min(env.envColor[3]*255,255,-255));return;case GL_COMBINE_RGB:HEAP32[param>>2]=env.colorCombiner;return;case GL_COMBINE_ALPHA:HEAP32[param>>2]=env.alphaCombiner;return;case GL_SRC0_RGB:HEAP32[param>>2]=env.colorSrc[0];return;case GL_SRC1_RGB:HEAP32[param>>2]=env.colorSrc[1];return;case GL_SRC2_RGB:HEAP32[param>>2]=env.colorSrc[2];return;case GL_SRC0_ALPHA:HEAP32[param>>2]=env.alphaSrc[0];return;case GL_SRC1_ALPHA:HEAP32[param>>2]=env.alphaSrc[1];return;case GL_SRC2_ALPHA:HEAP32[param>>2]=env.alphaSrc[2];return;case GL_OPERAND0_RGB:HEAP32[param>>2]=env.colorOp[0];return;case GL_OPERAND1_RGB:HEAP32[param>>2]=env.colorOp[1];return;case GL_OPERAND2_RGB:HEAP32[param>>2]=env.colorOp[2];return;case GL_OPERAND0_ALPHA:HEAP32[param>>2]=env.alphaOp[0];return;case GL_OPERAND1_ALPHA:HEAP32[param>>2]=env.alphaOp[1];return;case GL_OPERAND2_ALPHA:HEAP32[param>>2]=env.alphaOp[2];return;case GL_RGB_SCALE:HEAP32[param>>2]=env.colorScale;return;case GL_ALPHA_SCALE:HEAP32[param>>2]=env.alphaScale;return;default:Module.printErr("WARNING: Unhandled `pname` in call to `glGetTexEnvi`.")}}),hook_getTexEnvfv:(function(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_COLOR:HEAPF32[param>>2]=env.envColor[0];HEAPF32[param+4>>2]=env.envColor[1];HEAPF32[param+8>>2]=env.envColor[2];HEAPF32[param+12>>2]=env.envColor[3];return}})}}),vertexData:null,vertexDataU8:null,tempData:null,indexData:null,vertexCounter:0,mode:-1,rendererCache:null,rendererComponents:[],rendererComponentPointer:0,lastRenderer:null,lastArrayBuffer:null,lastProgram:null,lastStride:-1,matrix:[],matrixStack:[],currentMatrix:0,tempMatrix:null,matricesModified:false,useTextureMatrix:false,VERTEX:0,NORMAL:1,COLOR:2,TEXTURE0:3,NUM_ATTRIBUTES:-1,MAX_TEXTURES:-1,totalEnabledClientAttributes:0,enabledClientAttributes:[0,0],clientAttributes:[],liveClientAttributes:[],currentRenderer:null,modifiedClientAttributes:false,clientActiveTexture:0,clientColor:null,usedTexUnitList:[],fixedFunctionProgram:null,setClientAttribute:function setClientAttribute(name,size,type,stride,pointer){var attrib=GLImmediate.clientAttributes[name];if(!attrib){for(var i=0;i<=name;i++){if(!GLImmediate.clientAttributes[i]){GLImmediate.clientAttributes[i]={name:name,size:size,type:type,stride:stride,pointer:pointer,offset:0}}}}else{attrib.name=name;attrib.size=size;attrib.type=type;attrib.stride=stride;attrib.pointer=pointer;attrib.offset=0}GLImmediate.modifiedClientAttributes=true},addRendererComponent:function addRendererComponent(name,size,type){if(!GLImmediate.rendererComponents[name]){GLImmediate.rendererComponents[name]=1;GLImmediate.enabledClientAttributes[name]=true;GLImmediate.setClientAttribute(name,size,type,0,GLImmediate.rendererComponentPointer);GLImmediate.rendererComponentPointer+=size*GL.byteSizeByType[type-GL.byteSizeByTypeRoot]}else{GLImmediate.rendererComponents[name]++}},disableBeginEndClientAttributes:function disableBeginEndClientAttributes(){for(var i=0;i<GLImmediate.NUM_ATTRIBUTES;i++){if(GLImmediate.rendererComponents[i])GLImmediate.enabledClientAttributes[i]=false}},getRenderer:function getRenderer(){if(GLImmediate.currentRenderer){return GLImmediate.currentRenderer}var attributes=GLImmediate.liveClientAttributes;var cacheMap=GLImmediate.rendererCache;var keyView=cacheMap.getStaticKeyView().reset();var enabledAttributesKey=0;for(var i=0;i<attributes.length;i++){enabledAttributesKey|=1<<attributes[i].name}var fogParam=0;if(GLEmulation.fogEnabled){switch(GLEmulation.fogMode){case 2049:fogParam=1;break;case 9729:fogParam=2;break;default:fogParam=3;break}}keyView.next(enabledAttributesKey<<2|fogParam);keyView.next(GL.currProgram);if(!GL.currProgram){GLImmediate.TexEnvJIT.traverseState(keyView)}var renderer=keyView.get();if(!renderer){renderer=GLImmediate.createRenderer();GLImmediate.currentRenderer=renderer;keyView.set(renderer);return renderer}GLImmediate.currentRenderer=renderer;return renderer},createRenderer:function createRenderer(renderer){var useCurrProgram=!!GL.currProgram;var hasTextures=false;for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var texAttribName=GLImmediate.TEXTURE0+i;if(!GLImmediate.enabledClientAttributes[texAttribName])continue;hasTextures=true}var ret={init:function init(){var uTexUnitPrefix="u_texUnit";var aTexCoordPrefix="a_texCoord";var vTexCoordPrefix="v_texCoord";var vPrimColor="v_color";var uTexMatrixPrefix=GLImmediate.useTextureMatrix?"u_textureMatrix":null;if(useCurrProgram){if(GL.shaderInfos[GL.programShaders[GL.currProgram][0]].type==GLctx.VERTEX_SHADER){this.vertexShader=GL.shaders[GL.programShaders[GL.currProgram][0]];this.fragmentShader=GL.shaders[GL.programShaders[GL.currProgram][1]]}else{this.vertexShader=GL.shaders[GL.programShaders[GL.currProgram][1]];this.fragmentShader=GL.shaders[GL.programShaders[GL.currProgram][0]]}this.program=GL.programs[GL.currProgram];this.usedTexUnitList=[]}else{if(GLEmulation.fogEnabled){switch(GLEmulation.fogMode){case 2049:var fogFormula="  float fog = exp(-u_fogDensity * u_fogDensity * ecDistance * ecDistance); \n";break;case 9729:var fogFormula="  float fog = (u_fogEnd - ecDistance) * u_fogScale; \n";break;default:var fogFormula="  float fog = exp(-u_fogDensity * ecDistance); \n";break}}GLImmediate.TexEnvJIT.setGLSLVars(uTexUnitPrefix,vTexCoordPrefix,vPrimColor,uTexMatrixPrefix);var fsTexEnvPass=GLImmediate.TexEnvJIT.genAllPassLines("gl_FragColor",2);var texUnitAttribList="";var texUnitVaryingList="";var texUnitUniformList="";var vsTexCoordInits="";this.usedTexUnitList=GLImmediate.TexEnvJIT.getUsedTexUnitList();for(var i=0;i<this.usedTexUnitList.length;i++){var texUnit=this.usedTexUnitList[i];texUnitAttribList+="attribute vec4 "+aTexCoordPrefix+texUnit+";\n";texUnitVaryingList+="varying vec4 "+vTexCoordPrefix+texUnit+";\n";texUnitUniformList+="uniform sampler2D "+uTexUnitPrefix+texUnit+";\n";vsTexCoordInits+="  "+vTexCoordPrefix+texUnit+" = "+aTexCoordPrefix+texUnit+";\n";if(GLImmediate.useTextureMatrix){texUnitUniformList+="uniform mat4 "+uTexMatrixPrefix+texUnit+";\n"}}var vsFogVaryingInit=null;if(GLEmulation.fogEnabled){vsFogVaryingInit="  v_fogFragCoord = abs(ecPosition.z);\n"}var vsSource=["attribute vec4 a_position;","attribute vec4 a_color;","varying vec4 v_color;",texUnitAttribList,texUnitVaryingList,GLEmulation.fogEnabled?"varying float v_fogFragCoord;":null,"uniform mat4 u_modelView;","uniform mat4 u_projection;","void main()","{","  vec4 ecPosition = u_modelView * a_position;","  gl_Position = u_projection * ecPosition;","  v_color = a_color;",vsTexCoordInits,vsFogVaryingInit,"}",""].join("\n").replace(/\n\n+/g,"\n");this.vertexShader=GLctx.createShader(GLctx.VERTEX_SHADER);GLctx.shaderSource(this.vertexShader,vsSource);GLctx.compileShader(this.vertexShader);var fogHeaderIfNeeded=null;if(GLEmulation.fogEnabled){fogHeaderIfNeeded=["","varying float v_fogFragCoord; ","uniform vec4 u_fogColor;      ","uniform float u_fogEnd;       ","uniform float u_fogScale;     ","uniform float u_fogDensity;   ","float ffog(in float ecDistance) { ",fogFormula,"  fog = clamp(fog, 0.0, 1.0); ","  return fog;                 ","}",""].join("\n")}var fogPass=null;if(GLEmulation.fogEnabled){fogPass="gl_FragColor = vec4(mix(u_fogColor.rgb, gl_FragColor.rgb, ffog(v_fogFragCoord)), gl_FragColor.a);\n"}var fsSource=["precision mediump float;",texUnitVaryingList,texUnitUniformList,"varying vec4 v_color;",fogHeaderIfNeeded,"void main()","{",fsTexEnvPass,fogPass,"}",""].join("\n").replace(/\n\n+/g,"\n");this.fragmentShader=GLctx.createShader(GLctx.FRAGMENT_SHADER);GLctx.shaderSource(this.fragmentShader,fsSource);GLctx.compileShader(this.fragmentShader);this.program=GLctx.createProgram();GLctx.attachShader(this.program,this.vertexShader);GLctx.attachShader(this.program,this.fragmentShader);GLctx.bindAttribLocation(this.program,GLImmediate.VERTEX,"a_position");GLctx.bindAttribLocation(this.program,GLImmediate.COLOR,"a_color");GLctx.bindAttribLocation(this.program,GLImmediate.NORMAL,"a_normal");var maxVertexAttribs=GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);for(var i=0;i<GLImmediate.MAX_TEXTURES&&GLImmediate.TEXTURE0+i<maxVertexAttribs;i++){GLctx.bindAttribLocation(this.program,GLImmediate.TEXTURE0+i,"a_texCoord"+i);GLctx.bindAttribLocation(this.program,GLImmediate.TEXTURE0+i,aTexCoordPrefix+i)}GLctx.linkProgram(this.program)}this.textureMatrixVersion=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];this.positionLocation=GLctx.getAttribLocation(this.program,"a_position");this.texCoordLocations=[];for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){if(!GLImmediate.enabledClientAttributes[GLImmediate.TEXTURE0+i]){this.texCoordLocations[i]=-1;continue}if(useCurrProgram){this.texCoordLocations[i]=GLctx.getAttribLocation(this.program,"a_texCoord"+i)}else{this.texCoordLocations[i]=GLctx.getAttribLocation(this.program,aTexCoordPrefix+i)}}this.colorLocation=GLctx.getAttribLocation(this.program,"a_color");if(!useCurrProgram){var prevBoundProg=GLctx.getParameter(GLctx.CURRENT_PROGRAM);GLctx.useProgram(this.program);{for(var i=0;i<this.usedTexUnitList.length;i++){var texUnitID=this.usedTexUnitList[i];var texSamplerLoc=GLctx.getUniformLocation(this.program,uTexUnitPrefix+texUnitID);GLctx.uniform1i(texSamplerLoc,texUnitID)}}GLctx.vertexAttrib4fv(this.colorLocation,[1,1,1,1]);GLctx.useProgram(prevBoundProg)}this.textureMatrixLocations=[];for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){this.textureMatrixLocations[i]=GLctx.getUniformLocation(this.program,"u_textureMatrix"+i)}this.normalLocation=GLctx.getAttribLocation(this.program,"a_normal");this.modelViewLocation=GLctx.getUniformLocation(this.program,"u_modelView");this.projectionLocation=GLctx.getUniformLocation(this.program,"u_projection");this.hasTextures=hasTextures;this.hasNormal=GLImmediate.enabledClientAttributes[GLImmediate.NORMAL]&&GLImmediate.clientAttributes[GLImmediate.NORMAL].size>0&&this.normalLocation>=0;this.hasColor=this.colorLocation===0||this.colorLocation>0;this.floatType=GLctx.FLOAT;this.fogColorLocation=GLctx.getUniformLocation(this.program,"u_fogColor");this.fogEndLocation=GLctx.getUniformLocation(this.program,"u_fogEnd");this.fogScaleLocation=GLctx.getUniformLocation(this.program,"u_fogScale");this.fogDensityLocation=GLctx.getUniformLocation(this.program,"u_fogDensity");this.hasFog=!!(this.fogColorLocation||this.fogEndLocation||this.fogScaleLocation||this.fogDensityLocation)},prepare:function prepare(){var arrayBuffer;if(!GL.currArrayBuffer){var start=GLImmediate.firstVertex*GLImmediate.stride;var end=GLImmediate.lastVertex*GLImmediate.stride;arrayBuffer=GL.getTempVertexBuffer(end)}else{arrayBuffer=GL.currArrayBuffer}var lastRenderer=GLImmediate.lastRenderer;var canSkip=this==lastRenderer&&arrayBuffer==GLImmediate.lastArrayBuffer&&(GL.currProgram||this.program)==GLImmediate.lastProgram&&GLImmediate.stride==GLImmediate.lastStride&&!GLImmediate.matricesModified;if(!canSkip&&lastRenderer)lastRenderer.cleanup();if(!GL.currArrayBuffer){if(arrayBuffer!=GLImmediate.lastArrayBuffer){GLctx.bindBuffer(GLctx.ARRAY_BUFFER,arrayBuffer);GLImmediate.lastArrayBuffer=arrayBuffer}GLctx.bufferSubData(GLctx.ARRAY_BUFFER,start,GLImmediate.vertexData.subarray(start>>2,end>>2))}if(canSkip)return;GLImmediate.lastRenderer=this;GLImmediate.lastProgram=GL.currProgram||this.program;GLImmediate.lastStride==GLImmediate.stride;GLImmediate.matricesModified=false;if(!GL.currProgram){if(GLImmediate.fixedFunctionProgram!=this.program){GLctx.useProgram(this.program);GLImmediate.fixedFunctionProgram=this.program}}if(this.modelViewLocation&&this.modelViewMatrixVersion!=GLImmediate.matrixVersion[0]){this.modelViewMatrixVersion=GLImmediate.matrixVersion[0];GLctx.uniformMatrix4fv(this.modelViewLocation,false,GLImmediate.matrix[0])}if(this.projectionLocation&&this.projectionMatrixVersion!=GLImmediate.matrixVersion[1]){this.projectionMatrixVersion=GLImmediate.matrixVersion[1];GLctx.uniformMatrix4fv(this.projectionLocation,false,GLImmediate.matrix[1])}var clientAttributes=GLImmediate.clientAttributes;var posAttr=clientAttributes[GLImmediate.VERTEX];GLctx.vertexAttribPointer(this.positionLocation,posAttr.size,posAttr.type,false,GLImmediate.stride,posAttr.offset);GLctx.enableVertexAttribArray(this.positionLocation);if(this.hasNormal){var normalAttr=clientAttributes[GLImmediate.NORMAL];GLctx.vertexAttribPointer(this.normalLocation,normalAttr.size,normalAttr.type,true,GLImmediate.stride,normalAttr.offset);GLctx.enableVertexAttribArray(this.normalLocation)}if(this.hasTextures){for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var attribLoc=this.texCoordLocations[i];if(attribLoc===undefined||attribLoc<0)continue;var texAttr=clientAttributes[GLImmediate.TEXTURE0+i];if(texAttr.size){GLctx.vertexAttribPointer(attribLoc,texAttr.size,texAttr.type,false,GLImmediate.stride,texAttr.offset);GLctx.enableVertexAttribArray(attribLoc)}else{GLctx.vertexAttrib4f(attribLoc,0,0,0,1);GLctx.disableVertexAttribArray(attribLoc)}var t=2+i;if(this.textureMatrixLocations[i]&&this.textureMatrixVersion[t]!=GLImmediate.matrixVersion[t]){this.textureMatrixVersion[t]=GLImmediate.matrixVersion[t];GLctx.uniformMatrix4fv(this.textureMatrixLocations[i],false,GLImmediate.matrix[t])}}}if(GLImmediate.enabledClientAttributes[GLImmediate.COLOR]){var colorAttr=clientAttributes[GLImmediate.COLOR];GLctx.vertexAttribPointer(this.colorLocation,colorAttr.size,colorAttr.type,true,GLImmediate.stride,colorAttr.offset);GLctx.enableVertexAttribArray(this.colorLocation)}else if(this.hasColor){GLctx.disableVertexAttribArray(this.colorLocation);GLctx.vertexAttrib4fv(this.colorLocation,GLImmediate.clientColor)}if(this.hasFog){if(this.fogColorLocation)GLctx.uniform4fv(this.fogColorLocation,GLEmulation.fogColor);if(this.fogEndLocation)GLctx.uniform1f(this.fogEndLocation,GLEmulation.fogEnd);if(this.fogScaleLocation)GLctx.uniform1f(this.fogScaleLocation,1/(GLEmulation.fogEnd-GLEmulation.fogStart));if(this.fogDensityLocation)GLctx.uniform1f(this.fogDensityLocation,GLEmulation.fogDensity)}},cleanup:function cleanup(){GLctx.disableVertexAttribArray(this.positionLocation);if(this.hasTextures){for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){if(GLImmediate.enabledClientAttributes[GLImmediate.TEXTURE0+i]&&this.texCoordLocations[i]>=0){GLctx.disableVertexAttribArray(this.texCoordLocations[i])}}}if(this.hasColor){GLctx.disableVertexAttribArray(this.colorLocation)}if(this.hasNormal){GLctx.disableVertexAttribArray(this.normalLocation)}if(!GL.currProgram){GLctx.useProgram(null);GLImmediate.fixedFunctionProgram=0}if(!GL.currArrayBuffer){GLctx.bindBuffer(GLctx.ARRAY_BUFFER,null);GLImmediate.lastArrayBuffer=null}GLImmediate.lastRenderer=null;GLImmediate.lastProgram=null;GLImmediate.matricesModified=true}};ret.init();return ret},setupFuncs:(function(){_glDrawArrays=_emscripten_glDrawArrays=function _glDrawArrays(mode,first,count){if(GLImmediate.totalEnabledClientAttributes==0&&mode<=6){GLctx.drawArrays(mode,first,count);return}GLImmediate.prepareClientAttributes(count,false);GLImmediate.mode=mode;if(!GL.currArrayBuffer){GLImmediate.vertexData=HEAPF32.subarray(GLImmediate.vertexPointer>>2,GLImmediate.vertexPointer+(first+count)*GLImmediate.stride>>2);GLImmediate.firstVertex=first;GLImmediate.lastVertex=first+count}GLImmediate.flush(null,first);GLImmediate.mode=-1};_glDrawElements=_emscripten_glDrawElements=function _glDrawElements(mode,count,type,indices,start,end){if(GLImmediate.totalEnabledClientAttributes==0&&mode<=6&&GL.currElementArrayBuffer){GLctx.drawElements(mode,count,type,indices);return}GLImmediate.prepareClientAttributes(count,false);GLImmediate.mode=mode;if(!GL.currArrayBuffer){GLImmediate.firstVertex=end?start:TOTAL_MEMORY;GLImmediate.lastVertex=end?end+1:0;GLImmediate.vertexData=HEAPF32.subarray(GLImmediate.vertexPointer>>2,end?GLImmediate.vertexPointer+(end+1)*GLImmediate.stride>>2:undefined)}GLImmediate.flush(count,0,indices);GLImmediate.mode=-1};GLImmediate.MapTreeLib=GLImmediate.spawnMapTreeLib();GLImmediate.spawnMapTreeLib=null;GLImmediate.TexEnvJIT=GLImmediate.spawnTexEnvJIT();GLImmediate.spawnTexEnvJIT=null;GLImmediate.setupHooks()}),setupHooks:(function(){if(!GLEmulation.hasRunInit){GLEmulation.init()}var glActiveTexture=_glActiveTexture;_glActiveTexture=_emscripten_glActiveTexture=function _glActiveTexture(texture){GLImmediate.TexEnvJIT.hook_activeTexture(texture);glActiveTexture(texture)};var glEnable=_glEnable;_glEnable=_emscripten_glEnable=function _glEnable(cap){GLImmediate.TexEnvJIT.hook_enable(cap);glEnable(cap)};var glDisable=_glDisable;_glDisable=_emscripten_glDisable=function _glDisable(cap){GLImmediate.TexEnvJIT.hook_disable(cap);glDisable(cap)};var glTexEnvf=typeof _glTexEnvf!="undefined"?_glTexEnvf:(function(){});_glTexEnvf=_emscripten_glTexEnvf=function _glTexEnvf(target,pname,param){GLImmediate.TexEnvJIT.hook_texEnvf(target,pname,param)};var glTexEnvi=typeof _glTexEnvi!="undefined"?_glTexEnvi:(function(){});_glTexEnvi=_emscripten_glTexEnvi=function _glTexEnvi(target,pname,param){GLImmediate.TexEnvJIT.hook_texEnvi(target,pname,param)};var glTexEnvfv=typeof _glTexEnvfv!="undefined"?_glTexEnvfv:(function(){});_glTexEnvfv=_emscripten_glTexEnvfv=function _glTexEnvfv(target,pname,param){GLImmediate.TexEnvJIT.hook_texEnvfv(target,pname,param)};_glGetTexEnviv=function _glGetTexEnviv(target,pname,param){GLImmediate.TexEnvJIT.hook_getTexEnviv(target,pname,param)};_glGetTexEnvfv=function _glGetTexEnvfv(target,pname,param){GLImmediate.TexEnvJIT.hook_getTexEnvfv(target,pname,param)};var glGetIntegerv=_glGetIntegerv;_glGetIntegerv=_emscripten_glGetIntegerv=function _glGetIntegerv(pname,params){switch(pname){case 35725:{var cur=GLctx.getParameter(GLctx.CURRENT_PROGRAM);if(cur==GLImmediate.fixedFunctionProgram){HEAP32[params>>2]=0;return}break}}glGetIntegerv(pname,params)}}),initted:false,init:(function(){Module.printErr("WARNING: using emscripten GL immediate mode emulation. This is very limited in what it supports");GLImmediate.initted=true;if(!Module.useWebGL)return;GLImmediate.MAX_TEXTURES=Module["GL_MAX_TEXTURE_IMAGE_UNITS"]||GLctx.getParameter(GLctx.MAX_TEXTURE_IMAGE_UNITS);GLImmediate.TexEnvJIT.init(GLctx,GLImmediate.MAX_TEXTURES);GLImmediate.NUM_ATTRIBUTES=3+GLImmediate.MAX_TEXTURES;GLImmediate.clientAttributes=[];GLEmulation.enabledClientAttribIndices=[];for(var i=0;i<GLImmediate.NUM_ATTRIBUTES;i++){GLImmediate.clientAttributes.push({});GLEmulation.enabledClientAttribIndices.push(false)}GLImmediate.matrix=[];GLImmediate.matrixStack=[];GLImmediate.matrixVersion=[];for(var i=0;i<2+GLImmediate.MAX_TEXTURES;i++){GLImmediate.matrixStack.push([]);GLImmediate.matrixVersion.push(0);GLImmediate.matrix.push(GLImmediate.matrixLib.mat4.create());GLImmediate.matrixLib.mat4.identity(GLImmediate.matrix[i])}GLImmediate.rendererCache=GLImmediate.MapTreeLib.create();GLImmediate.tempData=new Float32Array(GL.MAX_TEMP_BUFFER_SIZE>>2);GLImmediate.indexData=new Uint16Array(GL.MAX_TEMP_BUFFER_SIZE>>1);GLImmediate.vertexDataU8=new Uint8Array(GLImmediate.tempData.buffer);GL.generateTempBuffers(true,GL.currentContext);GLImmediate.clientColor=new Float32Array([1,1,1,1])}),prepareClientAttributes:function prepareClientAttributes(count,beginEnd){if(!GLImmediate.modifiedClientAttributes){GLImmediate.vertexCounter=GLImmediate.stride*count/4;return}GLImmediate.modifiedClientAttributes=false;var clientStartPointer=2147483647;var bytes=0;var minStride=2147483647;var maxStride=0;var attributes=GLImmediate.liveClientAttributes;attributes.length=0;for(var i=0;i<3+GLImmediate.MAX_TEXTURES;i++){if(GLImmediate.enabledClientAttributes[i]){var attr=GLImmediate.clientAttributes[i];attributes.push(attr);clientStartPointer=Math.min(clientStartPointer,attr.pointer);attr.sizeBytes=attr.size*GL.byteSizeByType[attr.type-GL.byteSizeByTypeRoot];bytes+=attr.sizeBytes;minStride=Math.min(minStride,attr.stride);maxStride=Math.max(maxStride,attr.stride)}}if((minStride!=maxStride||maxStride<bytes)&&!beginEnd){if(!GLImmediate.restrideBuffer)GLImmediate.restrideBuffer=_malloc(GL.MAX_TEMP_BUFFER_SIZE);var start=GLImmediate.restrideBuffer;bytes=0;for(var i=0;i<attributes.length;i++){var attr=attributes[i];var size=attr.sizeBytes;if(size%4!=0)size+=4-size%4;attr.offset=bytes;bytes+=size}for(var i=0;i<attributes.length;i++){var attr=attributes[i];var srcStride=Math.max(attr.sizeBytes,attr.stride);if((srcStride&3)==0&&(attr.sizeBytes&3)==0){var size4=attr.sizeBytes>>2;var srcStride4=Math.max(attr.sizeBytes,attr.stride)>>2;for(var j=0;j<count;j++){for(var k=0;k<size4;k++){HEAP32[(start+attr.offset+bytes*j>>2)+k]=HEAP32[(attr.pointer>>2)+j*srcStride4+k]}}}else{for(var j=0;j<count;j++){for(var k=0;k<attr.sizeBytes;k++){HEAP8[start+attr.offset+bytes*j+k]=HEAP8[attr.pointer+j*srcStride+k]}}}attr.pointer=start+attr.offset}GLImmediate.stride=bytes;GLImmediate.vertexPointer=start}else{if(GL.currArrayBuffer){GLImmediate.vertexPointer=0}else{GLImmediate.vertexPointer=clientStartPointer}for(var i=0;i<attributes.length;i++){var attr=attributes[i];attr.offset=attr.pointer-GLImmediate.vertexPointer}GLImmediate.stride=Math.max(maxStride,bytes)}if(!beginEnd){GLImmediate.vertexCounter=GLImmediate.stride*count/4}},flush:function flush(numProvidedIndexes,startIndex,ptr){startIndex=startIndex||0;ptr=ptr||0;var renderer=GLImmediate.getRenderer();var numVertexes=4*GLImmediate.vertexCounter/GLImmediate.stride;if(!numVertexes)return;var emulatedElementArrayBuffer=false;var numIndexes=0;if(numProvidedIndexes){numIndexes=numProvidedIndexes;if(!GL.currArrayBuffer&&GLImmediate.firstVertex>GLImmediate.lastVertex){for(var i=0;i<numProvidedIndexes;i++){var currIndex=HEAPU16[ptr+i*2>>1];GLImmediate.firstVertex=Math.min(GLImmediate.firstVertex,currIndex);GLImmediate.lastVertex=Math.max(GLImmediate.lastVertex,currIndex+1)}}if(!GL.currElementArrayBuffer){var indexBuffer=GL.getTempIndexBuffer(numProvidedIndexes<<1);GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,indexBuffer);GLctx.bufferSubData(GLctx.ELEMENT_ARRAY_BUFFER,0,HEAPU16.subarray(ptr>>1,ptr+(numProvidedIndexes<<1)>>1));ptr=0;emulatedElementArrayBuffer=true}}else if(GLImmediate.mode>6){if(GLImmediate.mode!=7)throw"unsupported immediate mode "+GLImmediate.mode;ptr=GLImmediate.firstVertex*3;var numQuads=numVertexes/4;numIndexes=numQuads*6;GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.currentContext.tempQuadIndexBuffer);emulatedElementArrayBuffer=true}renderer.prepare();if(numIndexes){GLctx.drawElements(GLctx.TRIANGLES,numIndexes,GLctx.UNSIGNED_SHORT,ptr)}else{GLctx.drawArrays(GLImmediate.mode,startIndex,numVertexes)}if(emulatedElementArrayBuffer){GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.buffers[GL.currElementArrayBuffer]||null)}}};GLImmediate.matrixLib=(function(){var vec3={};var mat3={};var mat4={};var quat4={};var MatrixArray=Float32Array;vec3.create=(function(vec){var dest=new MatrixArray(3);if(vec){dest[0]=vec[0];dest[1]=vec[1];dest[2]=vec[2]}else{dest[0]=dest[1]=dest[2]=0}return dest});vec3.set=(function(vec,dest){dest[0]=vec[0];dest[1]=vec[1];dest[2]=vec[2];return dest});vec3.add=(function(vec,vec2,dest){if(!dest||vec===dest){vec[0]+=vec2[0];vec[1]+=vec2[1];vec[2]+=vec2[2];return vec}dest[0]=vec[0]+vec2[0];dest[1]=vec[1]+vec2[1];dest[2]=vec[2]+vec2[2];return dest});vec3.subtract=(function(vec,vec2,dest){if(!dest||vec===dest){vec[0]-=vec2[0];vec[1]-=vec2[1];vec[2]-=vec2[2];return vec}dest[0]=vec[0]-vec2[0];dest[1]=vec[1]-vec2[1];dest[2]=vec[2]-vec2[2];return dest});vec3.multiply=(function(vec,vec2,dest){if(!dest||vec===dest){vec[0]*=vec2[0];vec[1]*=vec2[1];vec[2]*=vec2[2];return vec}dest[0]=vec[0]*vec2[0];dest[1]=vec[1]*vec2[1];dest[2]=vec[2]*vec2[2];return dest});vec3.negate=(function(vec,dest){if(!dest){dest=vec}dest[0]=-vec[0];dest[1]=-vec[1];dest[2]=-vec[2];return dest});vec3.scale=(function(vec,val,dest){if(!dest||vec===dest){vec[0]*=val;vec[1]*=val;vec[2]*=val;return vec}dest[0]=vec[0]*val;dest[1]=vec[1]*val;dest[2]=vec[2]*val;return dest});vec3.normalize=(function(vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],len=Math.sqrt(x*x+y*y+z*z);if(!len){dest[0]=0;dest[1]=0;dest[2]=0;return dest}else if(len===1){dest[0]=x;dest[1]=y;dest[2]=z;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;return dest});vec3.cross=(function(vec,vec2,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],x2=vec2[0],y2=vec2[1],z2=vec2[2];dest[0]=y*z2-z*y2;dest[1]=z*x2-x*z2;dest[2]=x*y2-y*x2;return dest});vec3.length=(function(vec){var x=vec[0],y=vec[1],z=vec[2];return Math.sqrt(x*x+y*y+z*z)});vec3.dot=(function(vec,vec2){return vec[0]*vec2[0]+vec[1]*vec2[1]+vec[2]*vec2[2]});vec3.direction=(function(vec,vec2,dest){if(!dest){dest=vec}var x=vec[0]-vec2[0],y=vec[1]-vec2[1],z=vec[2]-vec2[2],len=Math.sqrt(x*x+y*y+z*z);if(!len){dest[0]=0;dest[1]=0;dest[2]=0;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;return dest});vec3.lerp=(function(vec,vec2,lerp,dest){if(!dest){dest=vec}dest[0]=vec[0]+lerp*(vec2[0]-vec[0]);dest[1]=vec[1]+lerp*(vec2[1]-vec[1]);dest[2]=vec[2]+lerp*(vec2[2]-vec[2]);return dest});vec3.dist=(function(vec,vec2){var x=vec2[0]-vec[0],y=vec2[1]-vec[1],z=vec2[2]-vec[2];return Math.sqrt(x*x+y*y+z*z)});vec3.unproject=(function(vec,view,proj,viewport,dest){if(!dest){dest=vec}var m=mat4.create();var v=new MatrixArray(4);v[0]=(vec[0]-viewport[0])*2/viewport[2]-1;v[1]=(vec[1]-viewport[1])*2/viewport[3]-1;v[2]=2*vec[2]-1;v[3]=1;mat4.multiply(proj,view,m);if(!mat4.inverse(m)){return null}mat4.multiplyVec4(m,v);if(v[3]===0){return null}dest[0]=v[0]/v[3];dest[1]=v[1]/v[3];dest[2]=v[2]/v[3];return dest});vec3.str=(function(vec){return"["+vec[0]+", "+vec[1]+", "+vec[2]+"]"});mat3.create=(function(mat){var dest=new MatrixArray(9);if(mat){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8]}return dest});mat3.set=(function(mat,dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];return dest});mat3.identity=(function(dest){if(!dest){dest=mat3.create()}dest[0]=1;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=1;dest[5]=0;dest[6]=0;dest[7]=0;dest[8]=1;return dest});mat3.transpose=(function(mat,dest){if(!dest||mat===dest){var a01=mat[1],a02=mat[2],a12=mat[5];mat[1]=mat[3];mat[2]=mat[6];mat[3]=a01;mat[5]=mat[7];mat[6]=a02;mat[7]=a12;return mat}dest[0]=mat[0];dest[1]=mat[3];dest[2]=mat[6];dest[3]=mat[1];dest[4]=mat[4];dest[5]=mat[7];dest[6]=mat[2];dest[7]=mat[5];dest[8]=mat[8];return dest});mat3.toMat4=(function(mat,dest){if(!dest){dest=mat4.create()}dest[15]=1;dest[14]=0;dest[13]=0;dest[12]=0;dest[11]=0;dest[10]=mat[8];dest[9]=mat[7];dest[8]=mat[6];dest[7]=0;dest[6]=mat[5];dest[5]=mat[4];dest[4]=mat[3];dest[3]=0;dest[2]=mat[2];dest[1]=mat[1];dest[0]=mat[0];return dest});mat3.str=(function(mat){return"["+mat[0]+", "+mat[1]+", "+mat[2]+", "+mat[3]+", "+mat[4]+", "+mat[5]+", "+mat[6]+", "+mat[7]+", "+mat[8]+"]"});mat4.create=(function(mat){var dest=new MatrixArray(16);if(mat){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}return dest});mat4.set=(function(mat,dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15];return dest});mat4.identity=(function(dest){if(!dest){dest=mat4.create()}dest[0]=1;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=1;dest[6]=0;dest[7]=0;dest[8]=0;dest[9]=0;dest[10]=1;dest[11]=0;dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest});mat4.transpose=(function(mat,dest){if(!dest||mat===dest){var a01=mat[1],a02=mat[2],a03=mat[3],a12=mat[6],a13=mat[7],a23=mat[11];mat[1]=mat[4];mat[2]=mat[8];mat[3]=mat[12];mat[4]=a01;mat[6]=mat[9];mat[7]=mat[13];mat[8]=a02;mat[9]=a12;mat[11]=mat[14];mat[12]=a03;mat[13]=a13;mat[14]=a23;return mat}dest[0]=mat[0];dest[1]=mat[4];dest[2]=mat[8];dest[3]=mat[12];dest[4]=mat[1];dest[5]=mat[5];dest[6]=mat[9];dest[7]=mat[13];dest[8]=mat[2];dest[9]=mat[6];dest[10]=mat[10];dest[11]=mat[14];dest[12]=mat[3];dest[13]=mat[7];dest[14]=mat[11];dest[15]=mat[15];return dest});mat4.determinant=(function(mat){var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15];return a30*a21*a12*a03-a20*a31*a12*a03-a30*a11*a22*a03+a10*a31*a22*a03+a20*a11*a32*a03-a10*a21*a32*a03-a30*a21*a02*a13+a20*a31*a02*a13+a30*a01*a22*a13-a00*a31*a22*a13-a20*a01*a32*a13+a00*a21*a32*a13+a30*a11*a02*a23-a10*a31*a02*a23-a30*a01*a12*a23+a00*a31*a12*a23+a10*a01*a32*a23-a00*a11*a32*a23-a20*a11*a02*a33+a10*a21*a02*a33+a20*a01*a12*a33-a00*a21*a12*a33-a10*a01*a22*a33+a00*a11*a22*a33});mat4.inverse=(function(mat,dest){if(!dest){dest=mat}var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15],b00=a00*a11-a01*a10,b01=a00*a12-a02*a10,b02=a00*a13-a03*a10,b03=a01*a12-a02*a11,b04=a01*a13-a03*a11,b05=a02*a13-a03*a12,b06=a20*a31-a21*a30,b07=a20*a32-a22*a30,b08=a20*a33-a23*a30,b09=a21*a32-a22*a31,b10=a21*a33-a23*a31,b11=a22*a33-a23*a32,d=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06,invDet;if(!d){return null}invDet=1/d;dest[0]=(a11*b11-a12*b10+a13*b09)*invDet;dest[1]=(-a01*b11+a02*b10-a03*b09)*invDet;dest[2]=(a31*b05-a32*b04+a33*b03)*invDet;dest[3]=(-a21*b05+a22*b04-a23*b03)*invDet;dest[4]=(-a10*b11+a12*b08-a13*b07)*invDet;dest[5]=(a00*b11-a02*b08+a03*b07)*invDet;dest[6]=(-a30*b05+a32*b02-a33*b01)*invDet;dest[7]=(a20*b05-a22*b02+a23*b01)*invDet;dest[8]=(a10*b10-a11*b08+a13*b06)*invDet;dest[9]=(-a00*b10+a01*b08-a03*b06)*invDet;dest[10]=(a30*b04-a31*b02+a33*b00)*invDet;dest[11]=(-a20*b04+a21*b02-a23*b00)*invDet;dest[12]=(-a10*b09+a11*b07-a12*b06)*invDet;dest[13]=(a00*b09-a01*b07+a02*b06)*invDet;dest[14]=(-a30*b03+a31*b01-a32*b00)*invDet;dest[15]=(a20*b03-a21*b01+a22*b00)*invDet;return dest});mat4.toRotationMat=(function(mat,dest){if(!dest){dest=mat4.create()}dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest});mat4.toMat3=(function(mat,dest){if(!dest){dest=mat3.create()}dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[4];dest[4]=mat[5];dest[5]=mat[6];dest[6]=mat[8];dest[7]=mat[9];dest[8]=mat[10];return dest});mat4.toInverseMat3=(function(mat,dest){var a00=mat[0],a01=mat[1],a02=mat[2],a10=mat[4],a11=mat[5],a12=mat[6],a20=mat[8],a21=mat[9],a22=mat[10],b01=a22*a11-a12*a21,b11=-a22*a10+a12*a20,b21=a21*a10-a11*a20,d=a00*b01+a01*b11+a02*b21,id;if(!d){return null}id=1/d;if(!dest){dest=mat3.create()}dest[0]=b01*id;dest[1]=(-a22*a01+a02*a21)*id;dest[2]=(a12*a01-a02*a11)*id;dest[3]=b11*id;dest[4]=(a22*a00-a02*a20)*id;dest[5]=(-a12*a00+a02*a10)*id;dest[6]=b21*id;dest[7]=(-a21*a00+a01*a20)*id;dest[8]=(a11*a00-a01*a10)*id;return dest});mat4.multiply=(function(mat,mat2,dest){if(!dest){dest=mat}var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15],b00=mat2[0],b01=mat2[1],b02=mat2[2],b03=mat2[3],b10=mat2[4],b11=mat2[5],b12=mat2[6],b13=mat2[7],b20=mat2[8],b21=mat2[9],b22=mat2[10],b23=mat2[11],b30=mat2[12],b31=mat2[13],b32=mat2[14],b33=mat2[15];dest[0]=b00*a00+b01*a10+b02*a20+b03*a30;dest[1]=b00*a01+b01*a11+b02*a21+b03*a31;dest[2]=b00*a02+b01*a12+b02*a22+b03*a32;dest[3]=b00*a03+b01*a13+b02*a23+b03*a33;dest[4]=b10*a00+b11*a10+b12*a20+b13*a30;dest[5]=b10*a01+b11*a11+b12*a21+b13*a31;dest[6]=b10*a02+b11*a12+b12*a22+b13*a32;dest[7]=b10*a03+b11*a13+b12*a23+b13*a33;dest[8]=b20*a00+b21*a10+b22*a20+b23*a30;dest[9]=b20*a01+b21*a11+b22*a21+b23*a31;dest[10]=b20*a02+b21*a12+b22*a22+b23*a32;dest[11]=b20*a03+b21*a13+b22*a23+b23*a33;dest[12]=b30*a00+b31*a10+b32*a20+b33*a30;dest[13]=b30*a01+b31*a11+b32*a21+b33*a31;dest[14]=b30*a02+b31*a12+b32*a22+b33*a32;dest[15]=b30*a03+b31*a13+b32*a23+b33*a33;return dest});mat4.multiplyVec3=(function(mat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2];dest[0]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12];dest[1]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13];dest[2]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14];return dest});mat4.multiplyVec4=(function(mat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],w=vec[3];dest[0]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12]*w;dest[1]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13]*w;dest[2]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14]*w;dest[3]=mat[3]*x+mat[7]*y+mat[11]*z+mat[15]*w;return dest});mat4.translate=(function(mat,vec,dest){var x=vec[0],y=vec[1],z=vec[2],a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23;if(!dest||mat===dest){mat[12]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12];mat[13]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13];mat[14]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14];mat[15]=mat[3]*x+mat[7]*y+mat[11]*z+mat[15];return mat}a00=mat[0];a01=mat[1];a02=mat[2];a03=mat[3];a10=mat[4];a11=mat[5];a12=mat[6];a13=mat[7];a20=mat[8];a21=mat[9];a22=mat[10];a23=mat[11];dest[0]=a00;dest[1]=a01;dest[2]=a02;dest[3]=a03;dest[4]=a10;dest[5]=a11;dest[6]=a12;dest[7]=a13;dest[8]=a20;dest[9]=a21;dest[10]=a22;dest[11]=a23;dest[12]=a00*x+a10*y+a20*z+mat[12];dest[13]=a01*x+a11*y+a21*z+mat[13];dest[14]=a02*x+a12*y+a22*z+mat[14];dest[15]=a03*x+a13*y+a23*z+mat[15];return dest});mat4.scale=(function(mat,vec,dest){var x=vec[0],y=vec[1],z=vec[2];if(!dest||mat===dest){mat[0]*=x;mat[1]*=x;mat[2]*=x;mat[3]*=x;mat[4]*=y;mat[5]*=y;mat[6]*=y;mat[7]*=y;mat[8]*=z;mat[9]*=z;mat[10]*=z;mat[11]*=z;return mat}dest[0]=mat[0]*x;dest[1]=mat[1]*x;dest[2]=mat[2]*x;dest[3]=mat[3]*x;dest[4]=mat[4]*y;dest[5]=mat[5]*y;dest[6]=mat[6]*y;dest[7]=mat[7]*y;dest[8]=mat[8]*z;dest[9]=mat[9]*z;dest[10]=mat[10]*z;dest[11]=mat[11]*z;dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15];return dest});mat4.rotate=(function(mat,angle,axis,dest){var x=axis[0],y=axis[1],z=axis[2],len=Math.sqrt(x*x+y*y+z*z),s,c,t,a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23,b00,b01,b02,b10,b11,b12,b20,b21,b22;if(!len){return null}if(len!==1){len=1/len;x*=len;y*=len;z*=len}s=Math.sin(angle);c=Math.cos(angle);t=1-c;a00=mat[0];a01=mat[1];a02=mat[2];a03=mat[3];a10=mat[4];a11=mat[5];a12=mat[6];a13=mat[7];a20=mat[8];a21=mat[9];a22=mat[10];a23=mat[11];b00=x*x*t+c;b01=y*x*t+z*s;b02=z*x*t-y*s;b10=x*y*t-z*s;b11=y*y*t+c;b12=z*y*t+x*s;b20=x*z*t+y*s;b21=y*z*t-x*s;b22=z*z*t+c;if(!dest){dest=mat}else if(mat!==dest){dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*b00+a10*b01+a20*b02;dest[1]=a01*b00+a11*b01+a21*b02;dest[2]=a02*b00+a12*b01+a22*b02;dest[3]=a03*b00+a13*b01+a23*b02;dest[4]=a00*b10+a10*b11+a20*b12;dest[5]=a01*b10+a11*b11+a21*b12;dest[6]=a02*b10+a12*b11+a22*b12;dest[7]=a03*b10+a13*b11+a23*b12;dest[8]=a00*b20+a10*b21+a20*b22;dest[9]=a01*b20+a11*b21+a21*b22;dest[10]=a02*b20+a12*b21+a22*b22;dest[11]=a03*b20+a13*b21+a23*b22;return dest});mat4.rotateX=(function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11];if(!dest){dest=mat}else if(mat!==dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[4]=a10*c+a20*s;dest[5]=a11*c+a21*s;dest[6]=a12*c+a22*s;dest[7]=a13*c+a23*s;dest[8]=a10*-s+a20*c;dest[9]=a11*-s+a21*c;dest[10]=a12*-s+a22*c;dest[11]=a13*-s+a23*c;return dest});mat4.rotateY=(function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11];if(!dest){dest=mat}else if(mat!==dest){dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*c+a20*-s;dest[1]=a01*c+a21*-s;dest[2]=a02*c+a22*-s;dest[3]=a03*c+a23*-s;dest[8]=a00*s+a20*c;dest[9]=a01*s+a21*c;dest[10]=a02*s+a22*c;dest[11]=a03*s+a23*c;return dest});mat4.rotateZ=(function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7];if(!dest){dest=mat}else if(mat!==dest){dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*c+a10*s;dest[1]=a01*c+a11*s;dest[2]=a02*c+a12*s;dest[3]=a03*c+a13*s;dest[4]=a00*-s+a10*c;dest[5]=a01*-s+a11*c;dest[6]=a02*-s+a12*c;dest[7]=a03*-s+a13*c;return dest});mat4.frustum=(function(left,right,bottom,top,near,far,dest){if(!dest){dest=mat4.create()}var rl=right-left,tb=top-bottom,fn=far-near;dest[0]=near*2/rl;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=near*2/tb;dest[6]=0;dest[7]=0;dest[8]=(right+left)/rl;dest[9]=(top+bottom)/tb;dest[10]=-(far+near)/fn;dest[11]=-1;dest[12]=0;dest[13]=0;dest[14]=-(far*near*2)/fn;dest[15]=0;return dest});mat4.perspective=(function(fovy,aspect,near,far,dest){var top=near*Math.tan(fovy*Math.PI/360),right=top*aspect;return mat4.frustum(-right,right,-top,top,near,far,dest)});mat4.ortho=(function(left,right,bottom,top,near,far,dest){if(!dest){dest=mat4.create()}var rl=right-left,tb=top-bottom,fn=far-near;dest[0]=2/rl;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=2/tb;dest[6]=0;dest[7]=0;dest[8]=0;dest[9]=0;dest[10]=-2/fn;dest[11]=0;dest[12]=-(left+right)/rl;dest[13]=-(top+bottom)/tb;dest[14]=-(far+near)/fn;dest[15]=1;return dest});mat4.lookAt=(function(eye,center,up,dest){if(!dest){dest=mat4.create()}var x0,x1,x2,y0,y1,y2,z0,z1,z2,len,eyex=eye[0],eyey=eye[1],eyez=eye[2],upx=up[0],upy=up[1],upz=up[2],centerx=center[0],centery=center[1],centerz=center[2];if(eyex===centerx&&eyey===centery&&eyez===centerz){return mat4.identity(dest)}z0=eyex-centerx;z1=eyey-centery;z2=eyez-centerz;len=1/Math.sqrt(z0*z0+z1*z1+z2*z2);z0*=len;z1*=len;z2*=len;x0=upy*z2-upz*z1;x1=upz*z0-upx*z2;x2=upx*z1-upy*z0;len=Math.sqrt(x0*x0+x1*x1+x2*x2);if(!len){x0=0;x1=0;x2=0}else{len=1/len;x0*=len;x1*=len;x2*=len}y0=z1*x2-z2*x1;y1=z2*x0-z0*x2;y2=z0*x1-z1*x0;len=Math.sqrt(y0*y0+y1*y1+y2*y2);if(!len){y0=0;y1=0;y2=0}else{len=1/len;y0*=len;y1*=len;y2*=len}dest[0]=x0;dest[1]=y0;dest[2]=z0;dest[3]=0;dest[4]=x1;dest[5]=y1;dest[6]=z1;dest[7]=0;dest[8]=x2;dest[9]=y2;dest[10]=z2;dest[11]=0;dest[12]=-(x0*eyex+x1*eyey+x2*eyez);dest[13]=-(y0*eyex+y1*eyey+y2*eyez);dest[14]=-(z0*eyex+z1*eyey+z2*eyez);dest[15]=1;return dest});mat4.fromRotationTranslation=(function(quat,vec,dest){if(!dest){dest=mat4.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=0;dest[4]=xy-wz;dest[5]=1-(xx+zz);dest[6]=yz+wx;dest[7]=0;dest[8]=xz+wy;dest[9]=yz-wx;dest[10]=1-(xx+yy);dest[11]=0;dest[12]=vec[0];dest[13]=vec[1];dest[14]=vec[2];dest[15]=1;return dest});mat4.str=(function(mat){return"["+mat[0]+", "+mat[1]+", "+mat[2]+", "+mat[3]+", "+mat[4]+", "+mat[5]+", "+mat[6]+", "+mat[7]+", "+mat[8]+", "+mat[9]+", "+mat[10]+", "+mat[11]+", "+mat[12]+", "+mat[13]+", "+mat[14]+", "+mat[15]+"]"});quat4.create=(function(quat){var dest=new MatrixArray(4);if(quat){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3]}return dest});quat4.set=(function(quat,dest){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3];return dest});quat4.calculateW=(function(quat,dest){var x=quat[0],y=quat[1],z=quat[2];if(!dest||quat===dest){quat[3]=-Math.sqrt(Math.abs(1-x*x-y*y-z*z));return quat}dest[0]=x;dest[1]=y;dest[2]=z;dest[3]=-Math.sqrt(Math.abs(1-x*x-y*y-z*z));return dest});quat4.dot=(function(quat,quat2){return quat[0]*quat2[0]+quat[1]*quat2[1]+quat[2]*quat2[2]+quat[3]*quat2[3]});quat4.inverse=(function(quat,dest){var q0=quat[0],q1=quat[1],q2=quat[2],q3=quat[3],dot=q0*q0+q1*q1+q2*q2+q3*q3,invDot=dot?1/dot:0;if(!dest||quat===dest){quat[0]*=-invDot;quat[1]*=-invDot;quat[2]*=-invDot;quat[3]*=invDot;return quat}dest[0]=-quat[0]*invDot;dest[1]=-quat[1]*invDot;dest[2]=-quat[2]*invDot;dest[3]=quat[3]*invDot;return dest});quat4.conjugate=(function(quat,dest){if(!dest||quat===dest){quat[0]*=-1;quat[1]*=-1;quat[2]*=-1;return quat}dest[0]=-quat[0];dest[1]=-quat[1];dest[2]=-quat[2];dest[3]=quat[3];return dest});quat4.length=(function(quat){var x=quat[0],y=quat[1],z=quat[2],w=quat[3];return Math.sqrt(x*x+y*y+z*z+w*w)});quat4.normalize=(function(quat,dest){if(!dest){dest=quat}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],len=Math.sqrt(x*x+y*y+z*z+w*w);if(len===0){dest[0]=0;dest[1]=0;dest[2]=0;dest[3]=0;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;dest[3]=w*len;return dest});quat4.add=(function(quat,quat2,dest){if(!dest||quat===dest){quat[0]+=quat2[0];quat[1]+=quat2[1];quat[2]+=quat2[2];quat[3]+=quat2[3];return quat}dest[0]=quat[0]+quat2[0];dest[1]=quat[1]+quat2[1];dest[2]=quat[2]+quat2[2];dest[3]=quat[3]+quat2[3];return dest});quat4.multiply=(function(quat,quat2,dest){if(!dest){dest=quat}var qax=quat[0],qay=quat[1],qaz=quat[2],qaw=quat[3],qbx=quat2[0],qby=quat2[1],qbz=quat2[2],qbw=quat2[3];dest[0]=qax*qbw+qaw*qbx+qay*qbz-qaz*qby;dest[1]=qay*qbw+qaw*qby+qaz*qbx-qax*qbz;dest[2]=qaz*qbw+qaw*qbz+qax*qby-qay*qbx;dest[3]=qaw*qbw-qax*qbx-qay*qby-qaz*qbz;return dest});quat4.multiplyVec3=(function(quat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],qx=quat[0],qy=quat[1],qz=quat[2],qw=quat[3],ix=qw*x+qy*z-qz*y,iy=qw*y+qz*x-qx*z,iz=qw*z+qx*y-qy*x,iw=-qx*x-qy*y-qz*z;dest[0]=ix*qw+iw*-qx+iy*-qz-iz*-qy;dest[1]=iy*qw+iw*-qy+iz*-qx-ix*-qz;dest[2]=iz*qw+iw*-qz+ix*-qy-iy*-qx;return dest});quat4.scale=(function(quat,val,dest){if(!dest||quat===dest){quat[0]*=val;quat[1]*=val;quat[2]*=val;quat[3]*=val;return quat}dest[0]=quat[0]*val;dest[1]=quat[1]*val;dest[2]=quat[2]*val;dest[3]=quat[3]*val;return dest});quat4.toMat3=(function(quat,dest){if(!dest){dest=mat3.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=xy-wz;dest[4]=1-(xx+zz);dest[5]=yz+wx;dest[6]=xz+wy;dest[7]=yz-wx;dest[8]=1-(xx+yy);return dest});quat4.toMat4=(function(quat,dest){if(!dest){dest=mat4.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=0;dest[4]=xy-wz;dest[5]=1-(xx+zz);dest[6]=yz+wx;dest[7]=0;dest[8]=xz+wy;dest[9]=yz-wx;dest[10]=1-(xx+yy);dest[11]=0;dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest});quat4.slerp=(function(quat,quat2,slerp,dest){if(!dest){dest=quat}var cosHalfTheta=quat[0]*quat2[0]+quat[1]*quat2[1]+quat[2]*quat2[2]+quat[3]*quat2[3],halfTheta,sinHalfTheta,ratioA,ratioB;if(Math.abs(cosHalfTheta)>=1){if(dest!==quat){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3]}return dest}halfTheta=Math.acos(cosHalfTheta);sinHalfTheta=Math.sqrt(1-cosHalfTheta*cosHalfTheta);if(Math.abs(sinHalfTheta)<.001){dest[0]=quat[0]*.5+quat2[0]*.5;dest[1]=quat[1]*.5+quat2[1]*.5;dest[2]=quat[2]*.5+quat2[2]*.5;dest[3]=quat[3]*.5+quat2[3]*.5;return dest}ratioA=Math.sin((1-slerp)*halfTheta)/sinHalfTheta;ratioB=Math.sin(slerp*halfTheta)/sinHalfTheta;dest[0]=quat[0]*ratioA+quat2[0]*ratioB;dest[1]=quat[1]*ratioA+quat2[1]*ratioB;dest[2]=quat[2]*ratioA+quat2[2]*ratioB;dest[3]=quat[3]*ratioA+quat2[3]*ratioB;return dest});quat4.str=(function(quat){return"["+quat[0]+", "+quat[1]+", "+quat[2]+", "+quat[3]+"]"});return{vec3:vec3,mat3:mat3,mat4:mat4,quat4:quat4}})();var GLImmediateSetup={};function _glEnable(x0){GLctx.enable(x0)}function _glDisable(x0){GLctx.disable(x0)}function _glIsEnabled(x0){return GLctx.isEnabled(x0)}function emscriptenWebGLGet(name_,p,type){if(!p){GL.recordError(1281);return}var ret=undefined;switch(name_){case 36346:ret=1;break;case 36344:if(type!=="Integer"&&type!=="Integer64"){GL.recordError(1280)}return;case 36345:ret=0;break;case 34466:var formats=GLctx.getParameter(34467);ret=formats.length;break;case 35738:ret=5121;break;case 35739:ret=6408;break}if(ret===undefined){var result=GLctx.getParameter(name_);switch(typeof result){case"number":ret=result;break;case"boolean":ret=result?1:0;break;case"string":GL.recordError(1280);return;case"object":if(result===null){switch(name_){case 34964:case 35725:case 34965:case 36006:case 36007:case 32873:case 34068:{ret=0;break};default:{GL.recordError(1280);return}}}else if(result instanceof Float32Array||result instanceof Uint32Array||result instanceof Int32Array||result instanceof Array){for(var i=0;i<result.length;++i){switch(type){case"Integer":HEAP32[p+i*4>>2]=result[i];break;case"Float":HEAPF32[p+i*4>>2]=result[i];break;case"Boolean":HEAP8[p+i>>0]=result[i]?1:0;break;default:throw"internal glGet error, bad type: "+type}}return}else if(result instanceof WebGLBuffer||result instanceof WebGLProgram||result instanceof WebGLFramebuffer||result instanceof WebGLRenderbuffer||result instanceof WebGLTexture){ret=result.name|0}else{GL.recordError(1280);return}break;default:GL.recordError(1280);return}}switch(type){case"Integer64":tempI64=[ret>>>0,(tempDouble=ret,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[p>>2]=tempI64[0],HEAP32[p+4>>2]=tempI64[1];break;case"Integer":HEAP32[p>>2]=ret;break;case"Float":HEAPF32[p>>2]=ret;break;case"Boolean":HEAP8[p>>0]=ret?1:0;break;default:throw"internal glGet error, bad type: "+type}}function _glGetBooleanv(name_,p){emscriptenWebGLGet(name_,p,"Boolean")}function _glGetIntegerv(name_,p){emscriptenWebGLGet(name_,p,"Integer")}function _glGetString(name_){if(GL.stringCache[name_])return GL.stringCache[name_];var ret;switch(name_){case 7936:case 7937:case 7938:ret=allocate(intArrayFromString(GLctx.getParameter(name_)),"i8",ALLOC_NORMAL);break;case 7939:var exts=GLctx.getSupportedExtensions();var gl_exts=[];for(var i in exts){gl_exts.push(exts[i]);gl_exts.push("GL_"+exts[i])}ret=allocate(intArrayFromString(gl_exts.join(" ")),"i8",ALLOC_NORMAL);break;case 35724:ret=allocate(intArrayFromString("OpenGL ES GLSL 1.00 (WebGL)"),"i8",ALLOC_NORMAL);break;default:GL.recordError(1280);return 0}GL.stringCache[name_]=ret;return ret}function _glCreateShader(shaderType){var id=GL.getNewId(GL.shaders);GL.shaders[id]=GLctx.createShader(shaderType);return id}function _glShaderSource(shader,count,string,length){var source=GL.getSource(shader,count,string,length);GLctx.shaderSource(GL.shaders[shader],source)}function _glCompileShader(shader){GLctx.compileShader(GL.shaders[shader])}function _glAttachShader(program,shader){GLctx.attachShader(GL.programs[program],GL.shaders[shader])}function _glDetachShader(program,shader){GLctx.detachShader(GL.programs[program],GL.shaders[shader])}function _glUseProgram(program){GLctx.useProgram(program?GL.programs[program]:null)}function _glDeleteProgram(id){if(!id)return;var program=GL.programs[id];if(!program){GL.recordError(1281);return}GLctx.deleteProgram(program);program.name=0;GL.programs[id]=null;GL.programInfos[id]=null}function _glBindAttribLocation(program,index,name){name=Pointer_stringify(name);GLctx.bindAttribLocation(GL.programs[program],index,name)}function _glLinkProgram(program){GLctx.linkProgram(GL.programs[program]);GL.programInfos[program]=null;GL.populateUniformTable(program)}function _glBindBuffer(target,buffer){var bufferObj=buffer?GL.buffers[buffer]:null;if(target==GLctx.ARRAY_BUFFER){GL.currArrayBuffer=buffer;GLImmediate.lastArrayBuffer=buffer}else if(target==GLctx.ELEMENT_ARRAY_BUFFER){GL.currElementArrayBuffer=buffer}GLctx.bindBuffer(target,bufferObj)}function _glGetFloatv(name_,p){emscriptenWebGLGet(name_,p,"Float")}function _glHint(x0,x1){GLctx.hint(x0,x1)}function _glEnableVertexAttribArray(index){GLctx.enableVertexAttribArray(index)}function _glDisableVertexAttribArray(index){GLctx.disableVertexAttribArray(index)}function _glVertexAttribPointer(index,size,type,normalized,stride,ptr){GLctx.vertexAttribPointer(index,size,type,normalized,stride,ptr)}function _glActiveTexture(x0){GLctx.activeTexture(x0)}var GLEmulation={fogStart:0,fogEnd:1,fogDensity:1,fogColor:null,fogMode:2048,fogEnabled:false,vaos:[],currentVao:null,enabledVertexAttribArrays:{},hasRunInit:false,init:(function(){if(GLEmulation.hasRunInit){return}GLEmulation.hasRunInit=true;GLEmulation.fogColor=new Float32Array(4);Module.printErr("WARNING: using emscripten GL emulation. This is a collection of limited workarounds, do not expect it to work.");Module.printErr("WARNING: using emscripten GL emulation unsafe opts. If weirdness happens, try -s GL_UNSAFE_OPTS=0");var validCapabilities={2884:1,3042:1,3024:1,2960:1,2929:1,3089:1,32823:1,32926:1,32928:1};var glEnable=_glEnable;_glEnable=_emscripten_glEnable=function _glEnable(cap){if(GLImmediate.lastRenderer)GLImmediate.lastRenderer.cleanup();if(cap==2912){if(GLEmulation.fogEnabled!=true){GLImmediate.currentRenderer=null;GLEmulation.fogEnabled=true}return}else if(cap==3553){return}else if(!(cap in validCapabilities)){return}glEnable(cap)};var glDisable=_glDisable;_glDisable=_emscripten_glDisable=function _glDisable(cap){if(GLImmediate.lastRenderer)GLImmediate.lastRenderer.cleanup();if(cap==2912){if(GLEmulation.fogEnabled!=false){GLImmediate.currentRenderer=null;GLEmulation.fogEnabled=false}return}else if(cap==3553){return}else if(!(cap in validCapabilities)){return}glDisable(cap)};_glIsEnabled=_emscripten_glIsEnabled=function _glIsEnabled(cap){if(cap==2912){return GLEmulation.fogEnabled?1:0}else if(!(cap in validCapabilities)){return 0}return GLctx.isEnabled(cap)};var glGetBooleanv=_glGetBooleanv;_glGetBooleanv=_emscripten_glGetBooleanv=function _glGetBooleanv(pname,p){var attrib=GLEmulation.getAttributeFromCapability(pname);if(attrib!==null){var result=GLImmediate.enabledClientAttributes[attrib];HEAP8[p>>0]=result===true?1:0;return}glGetBooleanv(pname,p)};var glGetIntegerv=_glGetIntegerv;_glGetIntegerv=_emscripten_glGetIntegerv=function _glGetIntegerv(pname,params){switch(pname){case 34018:pname=GLctx.MAX_TEXTURE_IMAGE_UNITS;break;case 35658:{var result=GLctx.getParameter(GLctx.MAX_VERTEX_UNIFORM_VECTORS);HEAP32[params>>2]=result*4;return};case 35657:{var result=GLctx.getParameter(GLctx.MAX_FRAGMENT_UNIFORM_VECTORS);HEAP32[params>>2]=result*4;return};case 35659:{var result=GLctx.getParameter(GLctx.MAX_VARYING_VECTORS);HEAP32[params>>2]=result*4;return};case 34929:pname=GLctx.MAX_COMBINED_TEXTURE_IMAGE_UNITS;break;case 32890:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.size:0;return};case 32891:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.type:0;return};case 32892:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.stride:0;return};case 32897:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.size:0;return};case 32898:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.type:0;return};case 32899:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.stride:0;return};case 32904:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.size:0;return};case 32905:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.type:0;return};case 32906:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.stride:0;return}}glGetIntegerv(pname,params)};var glGetString=_glGetString;_glGetString=_emscripten_glGetString=function _glGetString(name_){if(GL.stringCache[name_])return GL.stringCache[name_];switch(name_){case 7939:var ret=allocate(intArrayFromString(GLctx.getSupportedExtensions().join(" ")+" GL_EXT_texture_env_combine GL_ARB_texture_env_crossbar GL_ATI_texture_env_combine3 GL_NV_texture_env_combine4 GL_EXT_texture_env_dot3 GL_ARB_multitexture GL_ARB_vertex_buffer_object GL_EXT_framebuffer_object GL_ARB_vertex_program GL_ARB_fragment_program GL_ARB_shading_language_100 GL_ARB_shader_objects GL_ARB_vertex_shader GL_ARB_fragment_shader GL_ARB_texture_cube_map GL_EXT_draw_range_elements"+(GL.currentContext.compressionExt?" GL_ARB_texture_compression GL_EXT_texture_compression_s3tc":"")+(GL.currentContext.anisotropicExt?" GL_EXT_texture_filter_anisotropic":"")),"i8",ALLOC_NORMAL);GL.stringCache[name_]=ret;return ret}return glGetString(name_)};GL.shaderInfos={};var glCreateShader=_glCreateShader;_glCreateShader=_emscripten_glCreateShader=function _glCreateShader(shaderType){var id=glCreateShader(shaderType);GL.shaderInfos[id]={type:shaderType,ftransform:false};return id};function ensurePrecision(source){if(!/precision +(low|medium|high)p +float *;/.test(source)){source="precision mediump float;\n"+source}return source}var glShaderSource=_glShaderSource;_glShaderSource=_emscripten_glShaderSource=function _glShaderSource(shader,count,string,length){var source=GL.getSource(shader,count,string,length);if(GL.shaderInfos[shader].type==GLctx.VERTEX_SHADER){var has_pm=source.search(/u_projection/)>=0;var has_mm=source.search(/u_modelView/)>=0;var has_pv=source.search(/a_position/)>=0;var need_pm=0,need_mm=0,need_pv=0;var old=source;source=source.replace(/ftransform\(\)/g,"(u_projection * u_modelView * a_position)");if(old!=source)need_pm=need_mm=need_pv=1;old=source;source=source.replace(/gl_ProjectionMatrix/g,"u_projection");if(old!=source)need_pm=1;old=source;source=source.replace(/gl_ModelViewMatrixTranspose\[2\]/g,"vec4(u_modelView[0][2], u_modelView[1][2], u_modelView[2][2], u_modelView[3][2])");if(old!=source)need_mm=1;old=source;source=source.replace(/gl_ModelViewMatrix/g,"u_modelView");if(old!=source)need_mm=1;old=source;source=source.replace(/gl_Vertex/g,"a_position");if(old!=source)need_pv=1;old=source;source=source.replace(/gl_ModelViewProjectionMatrix/g,"(u_projection * u_modelView)");if(old!=source)need_pm=need_mm=1;if(need_pv&&!has_pv)source="attribute vec4 a_position; \n"+source;if(need_mm&&!has_mm)source="uniform mat4 u_modelView; \n"+source;if(need_pm&&!has_pm)source="uniform mat4 u_projection; \n"+source;GL.shaderInfos[shader].ftransform=need_pm||need_mm||need_pv;for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var old=source;var need_vtc=source.search("v_texCoord"+i)==-1;source=source.replace(new RegExp("gl_TexCoord\\["+i+"\\]","g"),"v_texCoord"+i).replace(new RegExp("gl_MultiTexCoord"+i,"g"),"a_texCoord"+i);if(source!=old){source="attribute vec4 a_texCoord"+i+"; \n"+source;if(need_vtc){source="varying vec4 v_texCoord"+i+";   \n"+source}}old=source;source=source.replace(new RegExp("gl_TextureMatrix\\["+i+"\\]","g"),"u_textureMatrix"+i);if(source!=old){source="uniform mat4 u_textureMatrix"+i+"; \n"+source}}if(source.indexOf("gl_FrontColor")>=0){source="varying vec4 v_color; \n"+source.replace(/gl_FrontColor/g,"v_color")}if(source.indexOf("gl_Color")>=0){source="attribute vec4 a_color; \n"+source.replace(/gl_Color/g,"a_color")}if(source.indexOf("gl_Normal")>=0){source="attribute vec3 a_normal; \n"+source.replace(/gl_Normal/g,"a_normal")}if(source.indexOf("gl_FogFragCoord")>=0){source="varying float v_fogFragCoord;   \n"+source.replace(/gl_FogFragCoord/g,"v_fogFragCoord")}source=ensurePrecision(source)}else{for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var old=source;source=source.replace(new RegExp("gl_TexCoord\\["+i+"\\]","g"),"v_texCoord"+i);if(source!=old){source="varying vec4 v_texCoord"+i+";   \n"+source}}if(source.indexOf("gl_Color")>=0){source="varying vec4 v_color; \n"+source.replace(/gl_Color/g,"v_color")}if(source.indexOf("gl_Fog.color")>=0){source="uniform vec4 u_fogColor;   \n"+source.replace(/gl_Fog.color/g,"u_fogColor")}if(source.indexOf("gl_Fog.end")>=0){source="uniform float u_fogEnd;   \n"+source.replace(/gl_Fog.end/g,"u_fogEnd")}if(source.indexOf("gl_Fog.scale")>=0){source="uniform float u_fogScale;   \n"+source.replace(/gl_Fog.scale/g,"u_fogScale")}if(source.indexOf("gl_Fog.density")>=0){source="uniform float u_fogDensity;   \n"+source.replace(/gl_Fog.density/g,"u_fogDensity")}if(source.indexOf("gl_FogFragCoord")>=0){source="varying float v_fogFragCoord;   \n"+source.replace(/gl_FogFragCoord/g,"v_fogFragCoord")}source=ensurePrecision(source)}GLctx.shaderSource(GL.shaders[shader],source)};var glCompileShader=_glCompileShader;_glCompileShader=_emscripten_glCompileShader=function _glCompileShader(shader){GLctx.compileShader(GL.shaders[shader])};GL.programShaders={};var glAttachShader=_glAttachShader;_glAttachShader=_emscripten_glAttachShader=function _glAttachShader(program,shader){if(!GL.programShaders[program])GL.programShaders[program]=[];GL.programShaders[program].push(shader);glAttachShader(program,shader)};var glDetachShader=_glDetachShader;_glDetachShader=_emscripten_glDetachShader=function _glDetachShader(program,shader){var programShader=GL.programShaders[program];if(!programShader){Module.printErr("WARNING: _glDetachShader received invalid program: "+program);return}var index=programShader.indexOf(shader);programShader.splice(index,1);glDetachShader(program,shader)};var glUseProgram=_glUseProgram;_glUseProgram=_emscripten_glUseProgram=function _glUseProgram(program){if(GL.currProgram!=program){GLImmediate.currentRenderer=null;GL.currProgram=program;GLImmediate.fixedFunctionProgram=0;glUseProgram(program)}};var glDeleteProgram=_glDeleteProgram;_glDeleteProgram=_emscripten_glDeleteProgram=function _glDeleteProgram(program){glDeleteProgram(program);if(program==GL.currProgram){GLImmediate.currentRenderer=null;GL.currProgram=0}};var zeroUsedPrograms={};var glBindAttribLocation=_glBindAttribLocation;_glBindAttribLocation=_emscripten_glBindAttribLocation=function _glBindAttribLocation(program,index,name){if(index==0)zeroUsedPrograms[program]=true;glBindAttribLocation(program,index,name)};var glLinkProgram=_glLinkProgram;_glLinkProgram=_emscripten_glLinkProgram=function _glLinkProgram(program){if(!(program in zeroUsedPrograms)){GLctx.bindAttribLocation(GL.programs[program],0,"a_position")}glLinkProgram(program)};var glBindBuffer=_glBindBuffer;_glBindBuffer=_emscripten_glBindBuffer=function _glBindBuffer(target,buffer){glBindBuffer(target,buffer);if(target==GLctx.ARRAY_BUFFER){if(GLEmulation.currentVao){GLEmulation.currentVao.arrayBuffer=buffer}}else if(target==GLctx.ELEMENT_ARRAY_BUFFER){if(GLEmulation.currentVao)GLEmulation.currentVao.elementArrayBuffer=buffer}};var glGetFloatv=_glGetFloatv;_glGetFloatv=_emscripten_glGetFloatv=function _glGetFloatv(pname,params){if(pname==2982){HEAPF32.set(GLImmediate.matrix[0],params>>2)}else if(pname==2983){HEAPF32.set(GLImmediate.matrix[1],params>>2)}else if(pname==2984){HEAPF32.set(GLImmediate.matrix[2+GLImmediate.clientActiveTexture],params>>2)}else if(pname==2918){HEAPF32.set(GLEmulation.fogColor,params>>2)}else if(pname==2915){HEAPF32[params>>2]=GLEmulation.fogStart}else if(pname==2916){HEAPF32[params>>2]=GLEmulation.fogEnd}else if(pname==2914){HEAPF32[params>>2]=GLEmulation.fogDensity}else if(pname==2917){HEAPF32[params>>2]=GLEmulation.fogMode}else{glGetFloatv(pname,params)}};var glHint=_glHint;_glHint=_emscripten_glHint=function _glHint(target,mode){if(target==34031){return}glHint(target,mode)};var glEnableVertexAttribArray=_glEnableVertexAttribArray;_glEnableVertexAttribArray=_emscripten_glEnableVertexAttribArray=function _glEnableVertexAttribArray(index){glEnableVertexAttribArray(index);GLEmulation.enabledVertexAttribArrays[index]=1;if(GLEmulation.currentVao)GLEmulation.currentVao.enabledVertexAttribArrays[index]=1};var glDisableVertexAttribArray=_glDisableVertexAttribArray;_glDisableVertexAttribArray=_emscripten_glDisableVertexAttribArray=function _glDisableVertexAttribArray(index){glDisableVertexAttribArray(index);delete GLEmulation.enabledVertexAttribArrays[index];if(GLEmulation.currentVao)delete GLEmulation.currentVao.enabledVertexAttribArrays[index]};var glVertexAttribPointer=_glVertexAttribPointer;_glVertexAttribPointer=_emscripten_glVertexAttribPointer=function _glVertexAttribPointer(index,size,type,normalized,stride,pointer){glVertexAttribPointer(index,size,type,normalized,stride,pointer);if(GLEmulation.currentVao){GLEmulation.currentVao.vertexAttribPointers[index]=[index,size,type,normalized,stride,pointer]}}}),getAttributeFromCapability:(function(cap){var attrib=null;switch(cap){case 3553:case 32888:attrib=GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture;break;case 32884:attrib=GLImmediate.VERTEX;break;case 32885:attrib=GLImmediate.NORMAL;break;case 32886:attrib=GLImmediate.COLOR;break}return attrib})};function _glVertexPointer(size,type,stride,pointer){GLImmediate.setClientAttribute(GLImmediate.VERTEX,size,type,stride,pointer)}function _SDL_SetVideoMode(width,height,depth,flags){["touchstart","touchend","touchmove","mousedown","mouseup","mousemove","DOMMouseScroll","mousewheel","wheel","mouseout"].forEach((function(event){Module["canvas"].addEventListener(event,SDL.receiveEvent,true)}));var canvas=Module["canvas"];if(width==0&&height==0){width=canvas.width;height=canvas.height}if(!SDL.addedResizeListener){SDL.addedResizeListener=true;Browser.resizeListeners.push((function(w,h){if(!SDL.settingVideoMode){SDL.receiveEvent({type:"resize",w:w,h:h})}}))}if(width!==canvas.width||height!==canvas.height){SDL.settingVideoMode=true;Browser.setCanvasSize(width,height);SDL.settingVideoMode=false}if(SDL.screen){SDL.freeSurface(SDL.screen);assert(!SDL.screen)}if(SDL.GL)flags=flags|67108864;SDL.screen=SDL.makeSurface(width,height,flags,true,"screen");return SDL.screen}function _glDrawArrays(mode,first,count){GLctx.drawArrays(mode,first,count)}function _Mix_PlayChannelTimed(){return _Mix_PlayChannel.apply(null,arguments)}var _emscripten_postinvoke=true;var PTHREAD_SPECIFIC={};var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}function _glClear(x0){GLctx.clear(x0)}function __exit(status){Module["exit"](status)}function _exit(status){__exit(status)}function _SDL_GetError(){if(!SDL.errorMessage){SDL.errorMessage=allocate(intArrayFromString("unknown SDL-emscripten error"),"i8",ALLOC_NORMAL)}return SDL.errorMessage}function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21506:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _Mix_Init(flags){if(!flags)return 0;return 8}function _glDeleteTextures(n,textures){for(var i=0;i<n;i++){var id=HEAP32[textures+i*4>>2];var texture=GL.textures[id];if(!texture)continue;GLctx.deleteTexture(texture);texture.name=0;GL.textures[id]=null}}function ___syscall39(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),mode=SYSCALLS.get();return SYSCALLS.doMkdir(path,mode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function __Z13hspd_geterror8HSPERROR(){Module["printErr"]("missing function: _Z13hspd_geterror8HSPERROR");abort(-1)}var _BDtoIHigh=true;function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}function _SDL_GL_SetAttribute(attr,value){if(!(attr in SDL.glAttributes)){abort("Unknown SDL GL attribute ("+attr+"). Please check if your SDL version is supported.")}SDL.glAttributes[attr]=value}function _Mix_HaltChannel(channel){function halt(channel){var info=SDL.channels[channel];if(info.audio){info.audio.pause();info.audio=null}if(SDL.channelFinished){Runtime.getFuncWrapper(SDL.channelFinished,"vi")(channel)}}if(channel!=-1){halt(channel)}else{for(var i=0;i<SDL.channels.length;++i)halt(i)}return 0}var _emscripten_resume=true;function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _Mix_Quit(){}var _llvm_pow_f64=Math_pow;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_memmove"]=_memmove;function _glGenTextures(n,textures){for(var i=0;i<n;i++){var texture=GLctx.createTexture();if(!texture){GL.recordError(1282);while(i<n)HEAP32[textures+i++*4>>2]=0;return}var id=GL.getNewId(GL.textures);texture.name=id;GL.textures[id]=texture;HEAP32[textures+i*4>>2]=id}}var ___tm_current=allocate(44,"i8",ALLOC_STATIC);var ___tm_timezone=allocate(intArrayFromString("GMT"),"i8",ALLOC_STATIC);var _tzname=allocate(8,"i32*",ALLOC_STATIC);var _daylight=allocate(1,"i32*",ALLOC_STATIC);var _timezone=allocate(1,"i32*",ALLOC_STATIC);function _tzset(){if(_tzset.called)return;_tzset.called=true;HEAP32[_timezone>>2]=-(new Date).getTimezoneOffset()*60;var winter=new Date(2e3,0,1);var summer=new Date(2e3,6,1);HEAP32[_daylight>>2]=Number(winter.getTimezoneOffset()!=summer.getTimezoneOffset());function extractZone(date){var match=date.toTimeString().match(/\(([A-Za-z ]+)\)$/);return match?match[1]:"GMT"}var winterName=extractZone(winter);var summerName=extractZone(summer);var winterNamePtr=allocate(intArrayFromString(winterName),"i8",ALLOC_NORMAL);var summerNamePtr=allocate(intArrayFromString(summerName),"i8",ALLOC_NORMAL);if(summer.getTimezoneOffset()<winter.getTimezoneOffset()){HEAP32[_tzname>>2]=winterNamePtr;HEAP32[_tzname+4>>2]=summerNamePtr}else{HEAP32[_tzname>>2]=summerNamePtr;HEAP32[_tzname+4>>2]=winterNamePtr}}function _localtime_r(time,tmPtr){_tzset();var date=new Date(HEAP32[time>>2]*1e3);HEAP32[tmPtr>>2]=date.getSeconds();HEAP32[tmPtr+4>>2]=date.getMinutes();HEAP32[tmPtr+8>>2]=date.getHours();HEAP32[tmPtr+12>>2]=date.getDate();HEAP32[tmPtr+16>>2]=date.getMonth();HEAP32[tmPtr+20>>2]=date.getFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getDay();var start=new Date(date.getFullYear(),0,1);var yday=(date.getTime()-start.getTime())/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+36>>2]=-(date.getTimezoneOffset()*60);var summerOffset=(new Date(2e3,6,1)).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dst=date.getTimezoneOffset()==Math.min(winterOffset,summerOffset)|0;HEAP32[tmPtr+32>>2]=dst;var zonePtr=HEAP32[_tzname+(dst?Runtime.QUANTUM_SIZE:0)>>2];HEAP32[tmPtr+40>>2]=zonePtr;return tmPtr}function _localtime(time){return _localtime_r(time,___tm_current)}function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}function _Mix_ReserveChannels(num){SDL.channelMinimumNumber=num}function ___gxx_personality_v0(){}function _emscripten_cancel_main_loop(){Browser.mainLoop.pause();Browser.mainLoop.func=null}function ___syscall183(which,varargs){SYSCALLS.varargs=varargs;try{var buf=SYSCALLS.get(),size=SYSCALLS.get();if(size===0)return-ERRNO_CODES.EINVAL;var cwd=FS.cwd();if(size<cwd.length+1)return-ERRNO_CODES.ERANGE;writeAsciiToMemory(cwd,buf);return buf}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _glTexCoordPointer(size,type,stride,pointer){GLImmediate.setClientAttribute(GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture,size,type,stride,pointer)}function _emscripten_get_now(){if(!_emscripten_get_now.actual){if(ENVIRONMENT_IS_NODE){_emscripten_get_now.actual=function _emscripten_get_now_actual(){var t=process["hrtime"]();return t[0]*1e3+t[1]/1e6}}else if(typeof dateNow!=="undefined"){_emscripten_get_now.actual=dateNow}else if(typeof self==="object"&&self["performance"]&&typeof self["performance"]["now"]==="function"){_emscripten_get_now.actual=function _emscripten_get_now_actual(){return self["performance"]["now"]()}}else if(typeof performance==="object"&&typeof performance["now"]==="function"){_emscripten_get_now.actual=function _emscripten_get_now_actual(){return performance["now"]()}}else{_emscripten_get_now.actual=Date.now}}return _emscripten_get_now.actual()}function _emscripten_get_now_is_monotonic(){return ENVIRONMENT_IS_NODE||typeof dateNow!=="undefined"||(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&self["performance"]&&self["performance"]["now"]}function _clock_gettime(clk_id,tp){var now;if(clk_id===0){now=Date.now()}else if(clk_id===1&&_emscripten_get_now_is_monotonic()){now=_emscripten_get_now()}else{___setErrNo(ERRNO_CODES.EINVAL);return-1}HEAP32[tp>>2]=now/1e3|0;HEAP32[tp+4>>2]=now%1e3*1e3*1e3|0;return 0}function emscriptenWebGLComputeImageSize(width,height,sizePerPixel,alignment){function roundedToNextMultipleOf(x,y){return Math.floor((x+y-1)/y)*y}var plainRowSize=width*sizePerPixel;var alignedRowSize=roundedToNextMultipleOf(plainRowSize,alignment);return height<=0?0:(height-1)*alignedRowSize+plainRowSize}function emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,internalFormat){var sizePerPixel;var numChannels;switch(format){case 6406:case 6409:case 6402:case 6403:numChannels=1;break;case 6410:case 33319:numChannels=2;break;case 6407:case 35904:numChannels=3;break;case 6408:case 35906:numChannels=4;break;default:GL.recordError(1280);return{pixels:null,internalFormat:0}}switch(type){case 5121:sizePerPixel=numChannels*1;break;case 5123:case 36193:sizePerPixel=numChannels*2;break;case 5125:case 5126:sizePerPixel=numChannels*4;break;case 34042:sizePerPixel=4;break;case 33635:case 32819:case 32820:sizePerPixel=2;break;default:GL.recordError(1280);return{pixels:null,internalFormat:0}}var bytes=emscriptenWebGLComputeImageSize(width,height,sizePerPixel,GL.unpackAlignment);if(type==5121){pixels=HEAPU8.subarray(pixels,pixels+bytes)}else if(type==5126){pixels=HEAPF32.subarray(pixels>>2,pixels+bytes>>2)}else if(type==5125||type==34042){pixels=HEAPU32.subarray(pixels>>2,pixels+bytes>>2)}else{pixels=HEAPU16.subarray(pixels>>1,pixels+bytes>>1)}return{pixels:pixels,internalFormat:internalFormat}}function _glTexImage2D(target,level,internalFormat,width,height,border,format,type,pixels){var pixelData;if(pixels){var data=emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,internalFormat);pixelData=data.pixels;internalFormat=data.internalFormat}else{pixelData=null}GLctx.texImage2D(target,level,internalFormat,width,height,border,format,type,pixelData)}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}var _emscripten_preinvoke=true;Module["_memset"]=_memset;var _BDtoILow=true;Module["_bitshift64Lshr"]=_bitshift64Lshr;var _BItoD=true;Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}var _tan=Math_tan;function ___lock(){}function ___unlock(){}function _Mix_LoadWAV(filename){var rwops=_SDL_RWFromFile(filename);var result=_Mix_LoadWAV_RW(rwops);_SDL_FreeRW(rwops);return result}var _fabs=Math_abs;function _Mix_CloseAudio(){return _SDL_CloseAudio.apply(null,arguments)}function _glDisableClientState(cap){var attrib=GLEmulation.getAttributeFromCapability(cap);if(attrib===null){return}if(GLImmediate.enabledClientAttributes[attrib]){GLImmediate.enabledClientAttributes[attrib]=false;GLImmediate.totalEnabledClientAttributes--;GLImmediate.currentRenderer=null;if(GLEmulation.currentVao)delete GLEmulation.currentVao.enabledClientStates[cap];GLImmediate.modifiedClientAttributes=true}}var _sqrt=Math_sqrt;var _emscripten_asm_const_int=true;function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _emscripten_async_wget2_data(url,request,param,arg,free,onload,onerror,onprogress){var _url=Pointer_stringify(url);var _request=Pointer_stringify(request);var _param=Pointer_stringify(param);var http=new XMLHttpRequest;http.open(_request,_url,true);http.responseType="arraybuffer";var handle=Browser.getNextWgetRequestHandle();http.onload=function http_onload(e){if(http.status==200||_url.substr(0,4).toLowerCase()!="http"){var byteArray=new Uint8Array(http.response);var buffer=_malloc(byteArray.length);HEAPU8.set(byteArray,buffer);if(onload)Runtime.dynCall("viiii",onload,[handle,arg,buffer,byteArray.length]);if(free)_free(buffer)}else{if(onerror)Runtime.dynCall("viiii",onerror,[handle,arg,http.status,http.statusText])}delete Browser.wgetRequests[handle]};http.onerror=function http_onerror(e){if(onerror){Runtime.dynCall("viiii",onerror,[handle,arg,http.status,http.statusText])}delete Browser.wgetRequests[handle]};http.onprogress=function http_onprogress(e){if(onprogress)Runtime.dynCall("viiii",onprogress,[handle,arg,e.loaded,e.lengthComputable||e.lengthComputable===undefined?e.total:0])};http.onabort=function http_onabort(e){delete Browser.wgetRequests[handle]};try{if(http.channel instanceof Ci.nsIHttpChannel)http.channel.redirectionLimit=0}catch(ex){}if(_request=="POST"){http.setRequestHeader("Content-type","application/x-www-form-urlencoded");http.setRequestHeader("Content-length",_param.length);http.setRequestHeader("Connection","close");http.send(_param)}else{http.send(null)}Browser.wgetRequests[handle]=http;return handle}function _glLoadIdentity(){GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.identity(GLImmediate.matrix[GLImmediate.currentMatrix])}function ___cxa_allocate_exception(size){return _malloc(size)}var _sin=Math_sin;function _glBlendFunc(x0,x1){GLctx.blendFunc(x0,x1)}function _glPixelStorei(pname,param){if(pname==3333){GL.packAlignment=param}else if(pname==3317){GL.unpackAlignment=param}GLctx.pixelStorei(pname,param)}var _llvm_ctlz_i32=true;function _glViewport(x0,x1,x2,x3){GLctx.viewport(x0,x1,x2,x3)}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function ___syscall10(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.unlink(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _glEnableClientState(cap){var attrib=GLEmulation.getAttributeFromCapability(cap);if(attrib===null){return}if(!GLImmediate.enabledClientAttributes[attrib]){GLImmediate.enabledClientAttributes[attrib]=true;GLImmediate.totalEnabledClientAttributes++;GLImmediate.currentRenderer=null;if(GLEmulation.currentVao)GLEmulation.currentVao.enabledClientStates[cap]=1;GLImmediate.modifiedClientAttributes=true}}var _log=Math_log;function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function _llvm_eh_typeid_for(type){return type}function ___syscall12(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.chdir(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall5(which,varargs){SYSCALLS.varargs=varargs;try{var pathname=SYSCALLS.getStr(),flags=SYSCALLS.get(),mode=SYSCALLS.get();var stream=FS.open(pathname,flags,mode);return stream.fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _SDL_GL_SwapBuffers(){if(Browser.doSwapBuffers)Browser.doSwapBuffers()}function _SDL_PollEvent(ptr){return SDL.pollEvent(ptr)}function _glColorPointer(size,type,stride,pointer){GLImmediate.setClientAttribute(GLImmediate.COLOR,size,type,stride,pointer)}function _SDL_Init(initFlags){SDL.startTime=Date.now();SDL.initFlags=initFlags;if(!Module["doNotCaptureKeyboard"]){var keyboardListeningElement=Module["keyboardListeningElement"]||document;keyboardListeningElement.addEventListener("keydown",SDL.receiveEvent);keyboardListeningElement.addEventListener("keyup",SDL.receiveEvent);keyboardListeningElement.addEventListener("keypress",SDL.receiveEvent);window.addEventListener("focus",SDL.receiveEvent);window.addEventListener("blur",SDL.receiveEvent);document.addEventListener("visibilitychange",SDL.receiveEvent)}if(initFlags&512){addEventListener("gamepadconnected",(function(){}))}window.addEventListener("unload",SDL.receiveEvent);SDL.keyboardState=_malloc(65536);_memset(SDL.keyboardState,0,65536);SDL.DOMEventToSDLEvent["keydown"]=768;SDL.DOMEventToSDLEvent["keyup"]=769;SDL.DOMEventToSDLEvent["keypress"]=771;SDL.DOMEventToSDLEvent["mousedown"]=1025;SDL.DOMEventToSDLEvent["mouseup"]=1026;SDL.DOMEventToSDLEvent["mousemove"]=1024;SDL.DOMEventToSDLEvent["wheel"]=1027;SDL.DOMEventToSDLEvent["touchstart"]=1792;SDL.DOMEventToSDLEvent["touchend"]=1793;SDL.DOMEventToSDLEvent["touchmove"]=1794;SDL.DOMEventToSDLEvent["unload"]=256;SDL.DOMEventToSDLEvent["resize"]=28673;SDL.DOMEventToSDLEvent["visibilitychange"]=512;SDL.DOMEventToSDLEvent["focus"]=512;SDL.DOMEventToSDLEvent["blur"]=512;SDL.DOMEventToSDLEvent["joystick_axis_motion"]=1536;SDL.DOMEventToSDLEvent["joystick_button_down"]=1539;SDL.DOMEventToSDLEvent["joystick_button_up"]=1540;return 0}function _glTexParameteri(x0,x1,x2){GLctx.texParameteri(x0,x1,x2)}function _glMatrixMode(mode){if(mode==5888){GLImmediate.currentMatrix=0}else if(mode==5889){GLImmediate.currentMatrix=1}else if(mode==5890){GLImmediate.useTextureMatrix=true;GLImmediate.currentMatrix=2+GLImmediate.clientActiveTexture}else{throw"Wrong mode "+mode+" passed to glMatrixMode"}}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function _glOrtho(left,right,bottom,top_,nearVal,farVal){GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.multiply(GLImmediate.matrix[GLImmediate.currentMatrix],GLImmediate.matrixLib.mat4.ortho(left,right,bottom,top_,nearVal,farVal))}var _atan2=Math_atan2;var _exp=Math_exp;var _cos=Math_cos;function _pthread_self(){return 0}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall220(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),dirp=SYSCALLS.get(),count=SYSCALLS.get();if(!stream.getdents){stream.getdents=FS.readdir(stream.path)}var pos=0;while(stream.getdents.length>0&&pos+268<count){var id;var type;var name=stream.getdents.pop();assert(name.length<256);if(name[0]==="."){id=1;type=4}else{var child=FS.lookupNode(stream.node,name);id=child.id;type=FS.isChrdev(child.mode)?2:FS.isDir(child.mode)?4:FS.isLink(child.mode)?10:8}HEAP32[dirp+pos>>2]=id;HEAP32[dirp+pos+4>>2]=stream.position;HEAP16[dirp+pos+8>>1]=268;HEAP8[dirp+pos+10>>0]=type;for(var i=0;i<name.length;i++){HEAP8[dirp+pos+(11+i)>>0]=name.charCodeAt(i)}HEAP8[dirp+pos+(11+i)>>0]=0;pos+=268}return pos}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall221(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),cmd=SYSCALLS.get();switch(cmd){case 0:{var arg=SYSCALLS.get();if(arg<0){return-ERRNO_CODES.EINVAL}var newStream;newStream=FS.open(stream.path,stream.flags,0,arg);return newStream.fd};case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=SYSCALLS.get();stream.flags|=arg;return 0};case 12:case 12:{var arg=SYSCALLS.get();var offset=0;HEAP16[arg+offset>>1]=2;return 0};case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-ERRNO_CODES.EINVAL;case 9:___setErrNo(ERRNO_CODES.EINVAL);return-1;default:{return-ERRNO_CODES.EINVAL}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall145(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var ___dso_handle=allocate(1,"i32*",ALLOC_STATIC);var GLctx;GL.init();FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=require("fs");var NODEJS_PATH=require("path");NODEFS.staticInit()}Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas,vrDevice){Browser.requestFullScreen(lockPointer,resizeCanvas,vrDevice)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};Module["createContext"]=function Module_createContext(canvas,useWebGL,setInModule,webGLContextAttributes){return Browser.createContext(canvas,useWebGL,setInModule,webGLContextAttributes)};___buildEnvironment(ENV);GLEmulation.init();GLImmediate.setupFuncs();Browser.moduleContextCreatedCallbacks.push((function(){GLImmediate.init()}));STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_d(index){try{return Module["dynCall_d"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_i(index){try{return Module["dynCall_i"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_dd(index,a1){try{return Module["dynCall_dd"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_iiii":invoke_iiii,"invoke_d":invoke_d,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiii":invoke_viiiii,"invoke_i":invoke_i,"invoke_vi":invoke_vi,"invoke_dd":invoke_dd,"invoke_vii":invoke_vii,"invoke_ii":invoke_ii,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_iiiii":invoke_iiiii,"invoke_viiiiii":invoke_viiiiii,"invoke_iii":invoke_iii,"invoke_iiiiii":invoke_iiiiii,"invoke_viiii":invoke_viiii,"_glUseProgram":_glUseProgram,"_fabs":_fabs,"_exp":_exp,"___syscall220":___syscall220,"_Mix_Playing":_Mix_Playing,"_pthread_key_create":_pthread_key_create,"_SDL_RWFromFile":_SDL_RWFromFile,"___assert_fail":___assert_fail,"_glDeleteProgram":_glDeleteProgram,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_glBindBuffer":_glBindBuffer,"_clock_gettime":_clock_gettime,"_SDL_GetError":_SDL_GetError,"_emscripten_set_main_loop_timing":_emscripten_set_main_loop_timing,"_sbrk":_sbrk,"_glBlendFunc":_glBlendFunc,"_glDisableVertexAttribArray":_glDisableVertexAttribArray,"_Mix_PlayChannel":_Mix_PlayChannel,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_sysconf":_sysconf,"_Mix_PlayMusic":_Mix_PlayMusic,"___syscall221":___syscall221,"___lock":___lock,"_cos":_cos,"_glLoadIdentity":_glLoadIdentity,"_Mix_FreeChunk":_Mix_FreeChunk,"_glShaderSource":_glShaderSource,"___cxa_atexit":___cxa_atexit,"_glOrtho":_glOrtho,"_pthread_cleanup_push":_pthread_cleanup_push,"_glVertexPointer":_glVertexPointer,"_Mix_HaltMusic":_Mix_HaltMusic,"___syscall140":___syscall140,"___syscall145":___syscall145,"___syscall146":___syscall146,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_glVertexAttribPointer":_glVertexAttribPointer,"_glHint":_glHint,"_SDL_GL_SetAttribute":_SDL_GL_SetAttribute,"_atan2":_atan2,"_SDL_GetTicks":_SDL_GetTicks,"_Mix_CloseAudio":_Mix_CloseAudio,"_Mix_PlayChannelTimed":_Mix_PlayChannelTimed,"___cxa_free_exception":___cxa_free_exception,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_SDL_LockSurface":_SDL_LockSurface,"_glViewport":_glViewport,"_glGetBooleanv":_glGetBooleanv,"___setErrNo":___setErrNo,"_glDeleteTextures":_glDeleteTextures,"___resumeException":___resumeException,"_glEnable":_glEnable,"_glGenTextures":_glGenTextures,"_glGetIntegerv":_glGetIntegerv,"_glGetString":_glGetString,"emscriptenWebGLGet":emscriptenWebGLGet,"___syscall12":___syscall12,"_emscripten_get_now":_emscripten_get_now,"___syscall10":___syscall10,"_glAttachShader":_glAttachShader,"_Mix_Volume":_Mix_Volume,"_SDL_SetVideoMode":_SDL_SetVideoMode,"___syscall6":___syscall6,"___syscall5":___syscall5,"_time":_time,"_glDetachShader":_glDetachShader,"_gettimeofday":_gettimeofday,"_SDL_UpperBlitScaled":_SDL_UpperBlitScaled,"_exit":_exit,"_emscripten_asm_const_4":_emscripten_asm_const_4,"_emscripten_asm_const_2":_emscripten_asm_const_2,"_emscripten_asm_const_1":_emscripten_asm_const_1,"_emscripten_asm_const_0":_emscripten_asm_const_0,"_putenv":_putenv,"_llvm_pow_f64":_llvm_pow_f64,"_IMG_Load":_IMG_Load,"_TTF_FontHeight":_TTF_FontHeight,"___cxa_allocate_exception":___cxa_allocate_exception,"_emscripten_get_now_is_monotonic":_emscripten_get_now_is_monotonic,"___buildEnvironment":___buildEnvironment,"_glEnableClientState":_glEnableClientState,"_Mix_LoadWAV":_Mix_LoadWAV,"_emscripten_async_wget2_data":_emscripten_async_wget2_data,"_localtime_r":_localtime_r,"_tzset":_tzset,"_glClearColor":_glClearColor,"_pthread_once":_pthread_once,"_glIsEnabled":_glIsEnabled,"_SDL_Init":_SDL_Init,"___syscall195":___syscall195,"___cxa_end_catch":___cxa_end_catch,"_glGetFloatv":_glGetFloatv,"___cxa_begin_catch":___cxa_begin_catch,"_pthread_getspecific":_pthread_getspecific,"_Mix_Init":_Mix_Init,"_glDrawArrays":_glDrawArrays,"_TTF_RenderText_Solid":_TTF_RenderText_Solid,"_getenv":_getenv,"_SDL_UpperBlit":_SDL_UpperBlit,"_log":_log,"_glActiveTexture":_glActiveTexture,"___syscall39":___syscall39,"_glTexCoordPointer":_glTexCoordPointer,"_tan":_tan,"_glCompileShader":_glCompileShader,"_glEnableVertexAttribArray":_glEnableVertexAttribArray,"_abort":_abort,"___syscall183":___syscall183,"_glTexImage2D":_glTexImage2D,"_localtime":_localtime,"_Mix_ReserveChannels":_Mix_ReserveChannels,"_glDisableClientState":_glDisableClientState,"_glMatrixMode":_glMatrixMode,"_sin":_sin,"emscriptenWebGLGetTexPixelData":emscriptenWebGLGetTexPixelData,"emscriptenWebGLComputeImageSize":emscriptenWebGLComputeImageSize,"_SDL_CloseAudio":_SDL_CloseAudio,"___gxx_personality_v0":___gxx_personality_v0,"_glLinkProgram":_glLinkProgram,"_SDL_FreeRW":_SDL_FreeRW,"_glColorPointer":_glColorPointer,"_SDL_PauseAudio":_SDL_PauseAudio,"_llvm_eh_typeid_for":_llvm_eh_typeid_for,"_SDL_PollEvent":_SDL_PollEvent,"_Mix_OpenAudio":_Mix_OpenAudio,"_emscripten_cancel_main_loop":_emscripten_cancel_main_loop,"_glClear":_glClear,"_Mix_LoadWAV_RW":_Mix_LoadWAV_RW,"__Z13hspd_geterror8HSPERROR":__Z13hspd_geterror8HSPERROR,"_glBindTexture":_glBindTexture,"__exit":__exit,"_IMG_Load_RW":_IMG_Load_RW,"_glBindAttribLocation":_glBindAttribLocation,"_glPixelStorei":_glPixelStorei,"_pthread_self":_pthread_self,"_Mix_HaltChannel":_Mix_HaltChannel,"_TTF_SizeText":_TTF_SizeText,"___syscall54":___syscall54,"___unlock":___unlock,"_emscripten_set_main_loop":_emscripten_set_main_loop,"_SDL_RWFromConstMem":_SDL_RWFromConstMem,"_pthread_setspecific":_pthread_setspecific,"___cxa_throw":___cxa_throw,"_Mix_Quit":_Mix_Quit,"_SDL_GL_SwapBuffers":_SDL_GL_SwapBuffers,"_glDisable":_glDisable,"_glTexParameteri":_glTexParameteri,"_atexit":_atexit,"_sqrt":_sqrt,"_glCreateShader":_glCreateShader,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"___dso_handle":___dso_handle};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.___dso_handle|0;var o=0;var p=0;var q=0;var r=0;var s=global.NaN,t=global.Infinity;var u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=global.Math.floor;var O=global.Math.abs;var P=global.Math.sqrt;var Q=global.Math.pow;var R=global.Math.cos;var S=global.Math.sin;var T=global.Math.tan;var U=global.Math.acos;var V=global.Math.asin;var W=global.Math.atan;var X=global.Math.atan2;var Y=global.Math.exp;var Z=global.Math.log;var _=global.Math.ceil;var $=global.Math.imul;var aa=global.Math.min;var ba=global.Math.clz32;var ca=env.abort;var da=env.assert;var ea=env.invoke_iiii;var fa=env.invoke_d;var ga=env.invoke_viiiiiii;var ha=env.invoke_viiiii;var ia=env.invoke_i;var ja=env.invoke_vi;var ka=env.invoke_dd;var la=env.invoke_vii;var ma=env.invoke_ii;var na=env.invoke_viii;var oa=env.invoke_v;var pa=env.invoke_iiiii;var qa=env.invoke_viiiiii;var ra=env.invoke_iii;var sa=env.invoke_iiiiii;var ta=env.invoke_viiii;var ua=env._glUseProgram;var va=env._fabs;var wa=env._exp;var xa=env.___syscall220;var ya=env._Mix_Playing;var za=env._pthread_key_create;var Aa=env._SDL_RWFromFile;var Ba=env.___assert_fail;var Ca=env._glDeleteProgram;var Da=env.__ZSt18uncaught_exceptionv;var Ea=env._glBindBuffer;var Fa=env._clock_gettime;var Ga=env._SDL_GetError;var Ha=env._emscripten_set_main_loop_timing;var Ia=env._sbrk;var Ja=env._glBlendFunc;var Ka=env._glDisableVertexAttribArray;var La=env._Mix_PlayChannel;var Ma=env._emscripten_memcpy_big;var Na=env._sysconf;var Oa=env._Mix_PlayMusic;var Pa=env.___syscall221;var Qa=env.___lock;var Ra=env._cos;var Sa=env._glLoadIdentity;var Ta=env._Mix_FreeChunk;var Ua=env._glShaderSource;var Va=env.___cxa_atexit;var Wa=env._glOrtho;var Xa=env._pthread_cleanup_push;var Ya=env._glVertexPointer;var Za=env._Mix_HaltMusic;var _a=env.___syscall140;var $a=env.___syscall145;var ab=env.___syscall146;var bb=env._pthread_cleanup_pop;var cb=env._glVertexAttribPointer;var db=env._glHint;var eb=env._SDL_GL_SetAttribute;var fb=env._atan2;var gb=env._SDL_GetTicks;var hb=env._Mix_CloseAudio;var ib=env._Mix_PlayChannelTimed;var jb=env.___cxa_free_exception;var kb=env.___cxa_find_matching_catch;var lb=env._SDL_LockSurface;var mb=env._glViewport;var nb=env._glGetBooleanv;var ob=env.___setErrNo;var pb=env._glDeleteTextures;var qb=env.___resumeException;var rb=env._glEnable;var sb=env._glGenTextures;var tb=env._glGetIntegerv;var ub=env._glGetString;var vb=env.emscriptenWebGLGet;var wb=env.___syscall12;var xb=env._emscripten_get_now;var yb=env.___syscall10;var zb=env._glAttachShader;var Ab=env._Mix_Volume;var Bb=env._SDL_SetVideoMode;var Cb=env.___syscall6;var Db=env.___syscall5;var Eb=env._time;var Fb=env._glDetachShader;var Gb=env._gettimeofday;var Hb=env._SDL_UpperBlitScaled;var Ib=env._exit;var Jb=env._emscripten_asm_const_4;var Kb=env._emscripten_asm_const_2;var Lb=env._emscripten_asm_const_1;var Mb=env._emscripten_asm_const_0;var Nb=env._putenv;var Ob=env._llvm_pow_f64;var Pb=env._IMG_Load;var Qb=env._TTF_FontHeight;var Rb=env.___cxa_allocate_exception;var Sb=env._emscripten_get_now_is_monotonic;var Tb=env.___buildEnvironment;var Ub=env._glEnableClientState;var Vb=env._Mix_LoadWAV;var Wb=env._emscripten_async_wget2_data;var Xb=env._localtime_r;var Yb=env._tzset;var Zb=env._glClearColor;var _b=env._pthread_once;var $b=env._glIsEnabled;var ac=env._SDL_Init;var bc=env.___syscall195;var cc=env.___cxa_end_catch;var dc=env._glGetFloatv;var ec=env.___cxa_begin_catch;var fc=env._pthread_getspecific;var gc=env._Mix_Init;var hc=env._glDrawArrays;var ic=env._TTF_RenderText_Solid;var jc=env._getenv;var kc=env._SDL_UpperBlit;var lc=env._log;var mc=env._glActiveTexture;var nc=env.___syscall39;var oc=env._glTexCoordPointer;var pc=env._tan;var qc=env._glCompileShader;var rc=env._glEnableVertexAttribArray;var sc=env._abort;var tc=env.___syscall183;var uc=env._glTexImage2D;var vc=env._localtime;var wc=env._Mix_ReserveChannels;var xc=env._glDisableClientState;var yc=env._glMatrixMode;var zc=env._sin;var Ac=env.emscriptenWebGLGetTexPixelData;var Bc=env.emscriptenWebGLComputeImageSize;var Cc=env._SDL_CloseAudio;var Dc=env.___gxx_personality_v0;var Ec=env._glLinkProgram;var Fc=env._SDL_FreeRW;var Gc=env._glColorPointer;var Hc=env._SDL_PauseAudio;var Ic=env._llvm_eh_typeid_for;var Jc=env._SDL_PollEvent;var Kc=env._Mix_OpenAudio;var Lc=env._emscripten_cancel_main_loop;var Mc=env._glClear;var Nc=env._Mix_LoadWAV_RW;var Oc=env.__Z13hspd_geterror8HSPERROR;var Pc=env._glBindTexture;var Qc=env.__exit;var Rc=env._IMG_Load_RW;var Sc=env._glBindAttribLocation;var Tc=env._glPixelStorei;var Uc=env._pthread_self;var Vc=env._Mix_HaltChannel;var Wc=env._TTF_SizeText;var Xc=env.___syscall54;var Yc=env.___unlock;var Zc=env._emscripten_set_main_loop;var _c=env._SDL_RWFromConstMem;var $c=env._pthread_setspecific;var ad=env.___cxa_throw;var bd=env._Mix_Quit;var cd=env._SDL_GL_SwapBuffers;var dd=env._glDisable;var ed=env._glTexParameteri;var fd=env._atexit;var gd=env._sqrt;var hd=env._glCreateShader;var id=0.0;
// EMSCRIPTEN_START_FUNCS
function zd(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function Ad(){return i|0}function Bd(a){a=a|0;i=a}function Cd(a,b){a=a|0;b=b|0;i=a;j=b}function Dd(a,b){a=a|0;b=b|0;if(!o){o=a;p=b}}function Ed(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function Fd(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function Gd(a){a=a|0;D=a}function Hd(){return D|0}function Id(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+256|0;g=h;c[84]=0;d=c[b>>2]|0;a:do if((d|0)<980247917)if((d|0)<978145348)switch(d|0){case 978142541:{e=6;break a}default:break a}else switch(d|0){case 978145348:{e=2;break a}default:break a}else if((d|0)<980250724)switch(d|0){case 980247917:{e=6;break a}default:break a}else switch(d|0){case 980250724:{e=2;break a}default:break a}while(0);if((e|0)==2){d=b+4|0;e=il(d,58)|0;f=c[92]|0;if(f)go(f);c[88]=0;if(e){a[e>>0]=0;Kn(g,e+1|0)|0;Kd(d,0,-1,-1)|0;Kn(b,g)|0}}else if((e|0)==6)c[84]=1;if(c[84]|0){c[86]=0;g=(c[87]|0)<0?0:340;i=h;return g|0}if((c[88]|0)!=0?(Jd(b)|0)==0:0){g=c[89]|0;i=h;return g|0}g=Qm(b,24692)|0;c[89]=g;i=h;return g|0}function Jd(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+256|0;f=h;d=0;while(1){e=a[b+d>>0]|0;a[f+d>>0]=nm(e<<24>>24)|0;if(!(e<<24>>24))break;else d=d+1|0}d=c[92]|0;if(!d){g=-1;i=h;return g|0}b=c[93]|0;if((b|0)<=0){g=-1;i=h;return g|0}e=0;d=d+16|0;while(1){if(!(Jn(d,f)|0)){f=e;break}e=e+1|0;if((e|0)>=(b|0)){d=-1;g=11;break}else d=d+32|0}if((g|0)==11){i=h;return d|0}e=24695;b=e+32|0;do{a[e>>0]=a[d>>0]|0;e=e+1|0;d=d+1|0}while((e|0)<(b|0));if((f|0)==-1){g=-1;i=h;return g|0}c[94]=c[6180];c[95]=c[6179];d=Qm(24828,24692)|0;c[89]=d;if(!d){g=-1;i=h;return g|0}Xm(d,(c[90]|0)+(c[95]|0)|0,0)|0;g=0;i=h;return g|0}function Kd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;k=i;i=i+256|0;j=k;c[90]=0;c[88]=0;c[84]=0;c[91]=d;c[92]=0;Kn(j,b)|0;b=Qm(j,24692)|0;c[89]=b;if(!b){j=-1;i=k;return j|0}h=(d|0)>0;if(h){Xm(b,d,0)|0;b=c[89]|0}Um(24695,16,1,b)|0;c[90]=(c[6174]|0)+d;c[93]=c[6175];Nm(c[89]|0)|0;a[24699]=0;if(Jn(24695,24823)|0){j=-1;i=k;return j|0}g=(c[6176]|0)+16+(c[93]<<5)|0;b=fo(g)|0;c[92]=b;if(!b){j=-1;i=k;return j|0}b=Qm(j,24692)|0;c[89]=b;if(h){Xm(b,d,0)|0;b=c[89]|0}Um(c[92]|0,g,1,b)|0;Nm(c[89]|0)|0;f=(f>>>0)/117440512|0;if((e|0)!=-1){b=Qm(j,24692)|0;c[89]=b;if(h){Xm(b,d,0)|0;b=c[89]|0}b=Pm(b)|0;if((b|0)<0)b=0;else{g=b;b=0;do{b=b+f+g|0;g=Pm(c[89]|0)|0}while((g|0)>=0);b=b&65535}Nm(c[89]|0)|0;if((b|0)!=(e|0)){j=-2;i=k;return j|0}}c[88]=1;Kn(24828,j)|0;j=0;i=k;return j|0}function Ld(){var a=0;a=c[92]|0;if(a)go(a);c[88]=0;return}function Md(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+256|0;k=l;c[84]=0;g=c[b>>2]|0;a:do if((g|0)<980247917)if((g|0)<978145348)switch(g|0){case 978142541:{h=6;break a}default:break a}else switch(g|0){case 978145348:{h=2;break a}default:break a}else if((g|0)<980250724)switch(g|0){case 980247917:{h=6;break a}default:break a}else switch(g|0){case 980250724:{h=2;break a}default:break a}while(0);if((h|0)==2){g=b+4|0;h=il(g,58)|0;j=c[92]|0;if(j)go(j);c[88]=0;if(h){a[h>>0]=0;Kn(k,h+1|0)|0;Kd(g,0,-1,-1)|0;Kn(b,k)|0}}else if((h|0)==6)c[84]=1;h=(f|0)<0?0:f;if(c[84]|0){Id(b)|0;c[86]=h;if(c[84]|0){g=c[87]|0;g=(h+e|0)<(g|0)?e:g-h|0;if((g|0)>0){so(d|0,(c[85]|0)+h|0,g|0)|0;c[86]=(c[86]|0)+g}}else g=Um(d,1,e,0)|0;if(c[84]|0){d=g;i=l;return d|0}Nm(c[89]|0)|0;d=g;i=l;return d|0}if((c[88]|0)!=0?(Jd(b)|0)==0:0){g=c[94]|0;Nm(c[89]|0)|0;j=Qm(24828,24692)|0;if(!j){d=-1;i=l;return d|0}Xm(j,(c[90]|0)+h+(c[95]|0)|0,0)|0;g=(g|0)>(e|0)?e:g;if(c[84]|0){h=c[86]|0;e=c[87]|0;g=(h+g|0)<(e|0)?g:e-h|0;if((g|0)>0){so(d|0,(c[85]|0)+h|0,g|0)|0;c[86]=(c[86]|0)+g}}else g=Um(d,1,g,j)|0;Nm(j)|0;d=g;i=l;return d|0}g=Qm(b,24692)|0;if(!g){d=-1;i=l;return d|0}if((f|0)>-1)Xm(g,h,0)|0;d=Um(d,1,e,g)|0;Nm(g)|0;i=l;return d|0}function Nd(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+256|0;g=h;c[84]=0;d=c[b>>2]|0;a:do if((d|0)<980247917)if((d|0)<978145348)switch(d|0){case 978142541:{e=6;break a}default:break a}else switch(d|0){case 978145348:{e=2;break a}default:break a}else if((d|0)<980250724)switch(d|0){case 980247917:{e=6;break a}default:break a}else switch(d|0){case 980250724:{e=2;break a}default:break a}while(0);if((e|0)==2){d=b+4|0;e=il(d,58)|0;f=c[92]|0;if(f)go(f);c[88]=0;if(e){a[e>>0]=0;Kn(g,e+1|0)|0;Kd(d,0,-1,-1)|0;Kn(b,g)|0}}else if((e|0)==6)c[84]=1;if(c[84]|0){g=c[87]|0;i=h;return g|0}if((c[88]|0)!=0?(Jd(b)|0)==0:0){if(!(c[84]|0))Nm(c[89]|0)|0;g=c[94]|0;i=h;return g|0}d=Qm(b,24692)|0;if(!d){g=-1;i=h;return g|0}Xm(d,0,2)|0;g=_m(d)|0;Nm(d)|0;i=h;return g|0}function Od(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+256|0;g=h;c[84]=0;d=c[b>>2]|0;a:do if((d|0)<980247917)if((d|0)<978145348)switch(d|0){case 978142541:{e=6;break a}default:break a}else switch(d|0){case 978145348:{e=2;break a}default:break a}else if((d|0)<980250724)switch(d|0){case 980247917:{e=6;break a}default:break a}else switch(d|0){case 980250724:{e=2;break a}default:break a}while(0);if((e|0)==2){d=b+4|0;e=il(d,58)|0;f=c[92]|0;if(f)go(f);c[88]=0;if(e){a[e>>0]=0;Kn(g,e+1|0)|0;Kd(d,0,-1,-1)|0;Kn(b,g)|0}}else if((e|0)==6)c[84]=1;if(c[84]|0){g=2;i=h;return g|0}if((c[88]|0)!=0?(Jd(b)|0)==0:0){if(c[84]|0){g=1;i=h;return g|0}Nm(c[89]|0)|0;g=1;i=h;return g|0}d=Qm(b,24692)|0;if(!d){g=-1;i=h;return g|0}Nm(d)|0;g=0;i=h;return g|0}function Pd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+256|0;h=k;c[84]=0;e=c[b>>2]|0;a:do if((e|0)<980247917)if((e|0)<978145348)switch(e|0){case 978142541:{f=6;break a}default:break a}else switch(e|0){case 978145348:{f=2;break a}default:break a}else if((e|0)<980250724)switch(e|0){case 980247917:{f=6;break a}default:break a}else switch(e|0){case 980250724:{f=2;break a}default:break a}while(0);if((f|0)==2){e=b+4|0;f=il(e,58)|0;g=c[92]|0;if(g)go(g);c[88]=0;if(f){a[f>>0]=0;Kn(h,f+1|0)|0;Kd(e,0,-1,-1)|0;Kn(b,h)|0}}else if((f|0)==6)c[84]=1;e=Nd(b)|0;if((e|0)<0){j=1;i=k;return j|0}j=Qm(d,32283)|0;if(!j){j=1;i=k;return j|0}d=Id(b)|0;b=fo(32768)|0;b:do if(!e)e=0;else while(1){g=(e|0)<32768?e:32768;if(c[84]|0){f=c[86]|0;h=c[87]|0;h=(f+g|0)<(h|0)?g:h-f|0;if((h|0)>0){so(b|0,(c[85]|0)+f|0,h|0)|0;c[86]=f+h}}else Um(b,1,g,d)|0;if((an(b,1,g,j)|0)<(g|0)){e=1;break b}if((e|0)==(g|0)){e=0;break}else e=e-g|0}while(0);if(!(c[84]|0))Nm(c[89]|0)|0;Nm(j)|0;go(b);j=e;i=k;return j|0}function Qd(a,b){a=a|0;b=b|0;c[85]=a;c[86]=0;c[87]=b;return}function Rd(b){b=b|0;var c=0,d=0;c=Nd(b)|0;if((c|0)<0){b=0;return b|0}d=el(c+1|0)|0;Md(b,d,c,0)|0;a[d+c>>0]=0;b=d;return b|0}function Sd(a){a=a|0;uo(a|0,0,888)|0;ue(a);Je();c[a+8>>2]=0;c[a+892>>2]=0;c[a+888>>2]=0;return}function Td(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0;Te();g=a+8|0;if(!(c[g>>2]|0)){Ue();return}h=a+44|0;d=c[h>>2]|0;if(d){f=a+896|0;if((c[f>>2]|0)>0){e=0;do{d=d+(e*48|0)|0;od[c[(c[3356>>2]|0)+((b[d>>1]<<16>>16)*140|0)+52>>2]&63](d);e=e+1|0;d=c[h>>2]|0}while((e|0)<(c[f>>2]|0));if(d)i=6}else i=6;if((i|0)==6)Hl(d);c[h>>2]=0}c[g>>2]=0;d=a+892|0;e=c[d>>2]|0;if(!e){Ue();return}fl(e);c[d>>2]=0;Ue();return}function Ud(b,d){b=b|0;d=d|0;c[b+888>>2]=(a[d>>0]|0)==0?0:d;return}function Vd(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;r=i;i=i+512|0;m=r;q=e+8|0;if(c[q>>2]|0){k=e+44|0;g=c[k>>2]|0;if(g){j=e+896|0;if((c[j>>2]|0)>0){h=0;do{g=g+(h*48|0)|0;od[c[(c[3356>>2]|0)+((b[g>>1]<<16>>16)*140|0)+52>>2]&63](g);h=h+1|0;g=c[k>>2]|0}while((h|0)<(c[j>>2]|0));if(g)l=6}else l=6;if((l|0)==6)Hl(g);c[k>>2]=0}c[q>>2]=0;g=e+892|0;h=c[g>>2]|0;if(h){fl(h);c[g>>2]=0}}c[e+908>>2]=0;h=(f|0)!=0;if(h)Kd(30178,f,c[e+900>>2]|0,c[e+904>>2]|0)|0;else Kd(25084,0,-1,-1)|0;g=c[e+888>>2]|0;if(!g){a[m>>0]=83;a[m+1>>0]=84;a[m+2>>0]=65;a[m+3>>0]=82;a[m+4>>0]=84;a[m+5>>0]=46;a[m+6>>0]=65;a[m+7>>0]=88;a[m+8>>0]=0;if(h?(Od(m)|0)!=1:0){q=-1;i=r;return q|0}}else Kn(m,g)|0;n=Rd(m)|0;if(!n){q=-1;i=r;return q|0}c[e+892>>2]=n;if((((a[n>>0]|0)==72?(a[n+1>>0]|0)==83:0)?(a[n+2>>0]|0)==80:0)?(a[n+3>>0]|0)==51:0){o=e+896|0;c[o>>2]=c[n+8>>2];c[e>>2]=n;g=n+(c[n+16>>2]|0)|0;h=c[n+20>>2]|0;if(h){m=fo(h)|0;so(m|0,g|0,h|0)|0;g=m}c[q>>2]=g;c[e+12>>2]=n+(c[n+24>>2]|0);g=n+(c[n+32>>2]|0)|0;h=c[n+36>>2]|0;if(h){m=fo(h)|0;so(m|0,g|0,h|0)|0;g=m}c[e+20>>2]=g;g=n+(c[n+40>>2]|0)|0;h=c[n+44>>2]|0;if(h){m=fo(h)|0;so(m|0,g|0,h|0)|0;g=m}c[e+16>>2]=g;g=n+(c[n+48>>2]|0)|0;k=n+52|0;l=(c[k>>2]|0)>>>4;if(l){f=l<<4;m=fo(f)|0;h=m;j=0;while(1){t=g+4|0;t=d[t>>0]|d[t+1>>0]<<8|d[t+2>>0]<<16|d[t+3>>0]<<24;s=g+12|0;s=d[s>>0]|d[s+1>>0]<<8|d[s+2>>0]<<16|d[s+3>>0]<<24;c[h>>2]=d[g>>0]|d[g+1>>0]<<8|d[g+2>>0]<<16|d[g+3>>0]<<24;c[h+4>>2]=t;c[h+12>>2]=s;c[h+8>>2]=0;j=j+1|0;if((j|0)==(l|0))break;else{g=g+16|0;h=h+16|0}}c[k>>2]=f;g=m}c[e+832>>2]=g;g=n+(c[n+64>>2]|0)|0;h=c[n+68>>2]|0;if(h){t=fo(h)|0;so(t|0,g|0,h|0)|0;g=t}c[e+836>>2]=g;g=n+(c[n+56>>2]|0)|0;k=n+60|0;t=c[k>>2]|0;l=(t>>>0)/28|0;if(t>>>0>=28){f=l*28|0;m=fo(f)|0;h=m;j=0;while(1){y=g+2|0;y=d[y>>0]|d[y+1>>0]<<8;x=g+4|0;x=d[x>>0]|d[x+1>>0]<<8|d[x+2>>0]<<16|d[x+3>>0]<<24;w=g+8|0;w=d[w>>0]|d[w+1>>0]<<8|d[w+2>>0]<<16|d[w+3>>0]<<24;v=g+12|0;v=d[v>>0]|d[v+1>>0]<<8|d[v+2>>0]<<16|d[v+3>>0]<<24;u=g+16|0;u=d[u>>0]|d[u+1>>0]<<8|d[u+2>>0]<<16|d[u+3>>0]<<24;s=g+20|0;s=d[s>>0]|d[s+1>>0]<<8|d[s+2>>0]<<16|d[s+3>>0]<<24;t=g+24|0;t=d[t>>0]|d[t+1>>0]<<8|d[t+2>>0]<<16|d[t+3>>0]<<24;b[h>>1]=d[g>>0]|d[g+1>>0]<<8;b[h+2>>1]=y;c[h+4>>2]=x;c[h+8>>2]=w;c[h+12>>2]=v;c[h+16>>2]=u;c[h+20>>2]=s;c[h+24>>2]=t;j=j+1|0;if((j|0)>=(l|0))break;else{g=g+28|0;h=h+28|0}}c[k>>2]=f;g=m}c[e+840>>2]=g;Sf(b[n+86>>1]|0);we(e);h=e+44|0;c[h>>2]=0;g=c[o>>2]|0;if(((g|0)!=0?(p=Fl(g>>>0>89478485?-1:g*48|0)|0,c[h>>2]=p,(g|0)>0):0)?(b[p+2>>1]=-1,b[p>>1]=4,Zf(p,4),(c[o>>2]|0)>1):0){g=1;do{x=c[h>>2]|0;y=x+(g*48|0)|0;b[x+(g*48|0)+2>>1]=-1;b[y>>1]=4;Zf(y,4);g=g+1|0}while((g|0)<(c[o>>2]|0))}ye(c[q>>2]|0);De()|0;y=0;i=r;return y|0}fl(n);y=-1;i=r;return y|0}function Wd(a,b,d){a=a|0;b=b|0;d=d|0;c[a+900>>2]=b;c[a+904>>2]=d;return}function Xd(){var a=0,d=0,f=0,g=0;a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;f=b[a>>1]|0;b[12328]=f;g=f&65535;c[100]=g&24576;c[101]=g&4095;if(f<<16>>16<0){c[102]=(e[a+4>>1]|0)<<16|(e[d>>1]|0);c[98]=a+6;return}else{c[98]=a+4;c[102]=e[d>>1];return}}function Yd(a){a=a|0;var b=0;if(!a){c[(c[103]|0)+236>>2]=4;return}else{b=Rb(4)|0;c[b>>2]=a;ad(b|0,8,0)}}function Zd(a,d){a=a|0;d=d|0;var f=0,g=0,h=0,i=0;a:do switch(c[d>>2]|0){case -3:{f=c[a>>2]|0;c[f+40>>2]=c[a+4>>2];if((c[101]|0)==0&(c[102]|0)==40){d=Rb(4)|0;c[d>>2]=34;ad(d|0,8,0)}break}case -6:{c[d>>2]=2;d=c[a>>2]|0;return d|0}case 7:{c[d>>2]=1;d=a;return d|0}case -2:{f=c[a>>2]|0;if(!(b[f+36>>1]&16)){Ze(f);break a}g=b[f>>1]|0;c[d>>2]=g;c[f+40>>2]=0;b[f+38>>1]=0;if(!((c[101]|0)==0&(c[102]|0)==40)){d=rd[c[(c[3356>>2]|0)+(g*140|0)+28>>2]&63](f)|0;return d|0}g=c[98]|0;c[99]=g;a=g+2|0;c[98]=a;h=b[g>>1]|0;b[12328]=h;i=h&65535;c[100]=i&24576;c[101]=i&4095;if(h<<16>>16<0){c[102]=e[g+4>>1]<<16|e[a>>1];c[98]=g+6}else{c[98]=g+4;c[102]=e[a>>1]}g=wd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+32>>2]&31](f,d)|0;f=c[98]|0;c[99]=f;a=f+2|0;c[98]=a;i=b[f>>1]|0;b[12328]=i;h=i&65535;c[100]=h&24576;c[101]=h&4095;if(i<<16>>16<0){c[102]=e[f+4>>1]<<16|e[a>>1];c[98]=f+6;i=g;return i|0}else{c[98]=f+4;c[102]=e[a>>1];i=g;return i|0}}case -1:{if(!(b[a+36>>1]&16)){Ze(a);f=a;break a}f=b[a>>1]|0;c[d>>2]=f;c[a+40>>2]=0;b[a+38>>1]=0;if(!((c[101]|0)==0&(c[102]|0)==40)){i=rd[c[(c[3356>>2]|0)+(f*140|0)+28>>2]&63](a)|0;return i|0}f=c[98]|0;c[99]=f;g=f+2|0;c[98]=g;i=b[f>>1]|0;b[12328]=i;h=i&65535;c[100]=h&24576;c[101]=h&4095;if(i<<16>>16<0){c[102]=e[f+4>>1]<<16|e[g>>1];c[98]=f+6}else{c[98]=f+4;c[102]=e[g>>1]}g=wd[c[(c[3356>>2]|0)+((b[a>>1]<<16>>16)*140|0)+32>>2]&31](a,d)|0;f=c[98]|0;c[99]=f;a=f+2|0;c[98]=a;i=b[f>>1]|0;b[12328]=i;h=i&65535;c[100]=h&24576;c[101]=h&4095;if(i<<16>>16<0){c[102]=e[f+4>>1]<<16|e[a>>1];c[98]=f+6;i=g;return i|0}else{c[98]=f+4;c[102]=e[a>>1];i=g;return i|0}}default:{i=a;return i|0}}while(0);i=b[f>>1]|0;c[d>>2]=i;i=rd[c[(c[3356>>2]|0)+(i*140|0)+28>>2]&63](f)|0;return i|0}function _d(){var a=0,d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+16|0;p=r+4|0;o=r;a=c[100]|0;if(a&8192){q=-2;i=r;return q|0}if(a&16384){c[100]=a^16384;q=-3;i=r;return q|0}f=c[101]|0;a:do if(!f){switch(c[102]|0){case 63:break;case 41:{c[100]=a&-16385;q=-4;i=r;return q|0}default:break a}a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;q=b[a>>1]|0;b[12328]=q;f=q&65535;c[100]=f&24576;c[101]=f&4095;if(q<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6}else{c[98]=a+4;c[102]=e[d>>1]}c[100]=f&8192;q=-3;i=r;return q|0}while(0);if(b[12328]&4096){switch(f|0){case 4:{q=c[104]|0;c[97]=q;c[c[q+28>>2]>>2]=c[102];break}case 2:case 3:{d=c[839]|0;q=c[838]|0;a=q+(f*48|0)|0;c[97]=a;do if((b[q+(f*48|0)+2>>1]|0)==-1)if(!(b[d+(f*140|0)>>1]|0)){r=Rb(4)|0;c[r>>2]=27;ad(r|0,8,0)}else{_f(a,f);a=c[97]|0;break}while(0);sd[c[d+(f*140|0)+72>>2]&15](a,c[a+28>>2]|0,(c[(c[103]|0)+12>>2]|0)+(c[102]|0)|0);break}default:{r=Rb(4)|0;c[r>>2]=1;ad(r|0,8,0)}}a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;q=b[a>>1]|0;b[12328]=q;f=q&65535;c[100]=f&24576;c[101]=f&4095;if(q<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6}else{c[98]=a+4;c[102]=e[d>>1]}c[100]=f&8192;q=0;i=r;return q|0}q=((c[849]|0)-(c[848]|0)|0)/80|0;a=a|16384;d=f;b:while(1){c:do switch(d|0){case 0:{l=c[102]|0;d=c[849]|0;if((l|0)==41){f=27;break b}g=d+-80|0;j=b[d+-160>>1]|0;m=j<<16>>16;if(j<<16>>16==4?(b[g>>1]|0)==4:0){f=d+-144|0;d=d+-64|0;a=c[d>>2]|0;do switch(l|0){case 40:{f=53;break b}case 0:{a=(c[f>>2]|0)+a|0;c[f>>2]=a;break}case 1:{a=(c[f>>2]|0)-a|0;c[f>>2]=a;break}case 2:{a=$(c[f>>2]|0,a)|0;c[f>>2]=a;break}case 3:{if(!a){f=37;break b}a=(c[f>>2]|0)/(a|0)|0;c[f>>2]=a;break}case 4:{if(!a){f=40;break b}a=(c[f>>2]|0)%(a|0)|0;c[f>>2]=a;break}case 5:{a=c[f>>2]&a;c[f>>2]=a;break}case 6:{a=c[f>>2]|a;c[f>>2]=a;break}case 7:{a=c[f>>2]^a;c[f>>2]=a;break}case 8:{a=(c[f>>2]|0)==(a|0)&1;c[f>>2]=a;break}case 9:{a=(c[f>>2]|0)!=(a|0)&1;c[f>>2]=a;break}case 10:{a=(c[f>>2]|0)>(a|0)&1;c[f>>2]=a;break}case 11:{a=(c[f>>2]|0)<(a|0)&1;c[f>>2]=a;break}case 12:{a=(c[f>>2]|0)>=(a|0)&1;c[f>>2]=a;break}case 13:{a=(c[f>>2]|0)<=(a|0)&1;c[f>>2]=a;break}case 14:{a=c[f>>2]>>a;c[f>>2]=a;break}case 15:{a=c[f>>2]<<a;c[f>>2]=a;break}default:{f=54;break b}}while(0);c[849]=g;c[d>>2]=a}else{n=c[838]|0;a=n+(m*48|0)|0;c[97]=a;h=c[839]|0;k=h+(m*140|0)|0;if((b[n+(m*48|0)+2>>1]|0)==-1){if(!(b[k>>1]|0)){f=58;break b}_f(a,m);a=c[97]|0}sd[c[h+(m*140|0)+72>>2]&15](a,c[a+28>>2]|0,c[d+-156>>2]|0);a=c[d+-76>>2]|0;d=b[g>>1]|0;f=d<<16>>16;do if(j<<16>>16!=d<<16>>16)if(d<<16>>16>7){a=wd[c[(c[3356>>2]|0)+(f*140|0)+24>>2]&31](a,m)|0;break}else{a=wd[c[h+(m*140|0)+20>>2]&31](a,f)|0;break}while(0);_e(k,c[(c[97]|0)+28>>2]|0,l,a);n=c[849]|0;a=n+-80|0;c[849]=a;if(b[n+-78>>1]|0){Bi();a=c[849]|0}c[849]=a+-80;if(b[a+-78>>1]|0)Bi();f=b[h+(m*140|0)+2>>1]|0;g=f<<16>>16;f=f<<16>>16==j<<16>>16;d=f?k:(c[839]|0)+(g*140|0)|0;a=b[d+8>>1]|0;if(a<<16>>16<0)a=rd[c[d+56>>2]&63](c[(c[97]|0)+28>>2]|0)|0;else a=a<<16>>16;yi(f?m:g,c[(c[97]|0)+28>>2]|0,a)}a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;n=b[a>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6;break c}else{c[98]=a+4;c[102]=e[d>>1];break c}}case 1:{h=c[102]|0;j=c[(c[103]|0)+44>>2]|0;n=j+(h*48|0)|0;m=c[98]|0;c[99]=m;a=m+2|0;c[98]=a;l=b[m>>1]|0;b[12328]=l;k=l&65535;c[100]=k&24576;c[101]=k&4095;if(l<<16>>16<0){c[102]=e[m+4>>1]<<16|e[a>>1];g=m+6|0;c[98]=g;f=4;k=5;l=6}else{g=m+4|0;c[98]=g;c[102]=e[a>>1];f=3;k=4;l=5}a=g;d=b[n>>1]|0;c[p>>2]=d;do if(b[j+(h*48|0)+36>>1]&16){c[p>>2]=d;c[j+(h*48|0)+40>>2]=0;b[j+(h*48|0)+38>>1]=0;if(!((c[101]|0)==0&(c[102]|0)==40)){d=rd[c[(c[3356>>2]|0)+(d*140|0)+28>>2]&63](n)|0;break}c[99]=a;a=m+(f<<1)|0;c[98]=a;j=b[g>>1]|0;b[12328]=j;h=j&65535;c[100]=h&24576;c[101]=h&4095;if(j<<16>>16<0){c[102]=e[m+(k<<1)>>1]<<16|e[a>>1];c[98]=m+(l<<1)}else{c[98]=m+(k<<1);c[102]=e[a>>1]}d=wd[c[(c[3356>>2]|0)+((b[n>>1]<<16>>16)*140|0)+32>>2]&31](n,p)|0;a=c[98]|0;c[99]=a;f=a+2|0;c[98]=f;n=b[a>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=e[a+4>>1]<<16|e[f>>1];c[98]=a+6;break}else{c[98]=a+4;c[102]=e[f>>1];break}}else{Ze(n);d=rd[c[(c[3356>>2]|0)+((b[n>>1]<<16>>16)*140|0)+28>>2]&63](n)|0}while(0);a=c[p>>2]|0;f=c[839]|0;g=b[f+(a*140|0)+8>>1]|0;if(g<<16>>16<0){a=rd[c[f+(a*140|0)+56>>2]&63](d)|0;f=c[p>>2]|0}else{f=a;a=g<<16>>16}yi(f,d,a);break}case 4:{d=c[102]|0;a=c[849]|0;b[a>>1]=4;c[a+16>>2]=d;c[849]=a+80;a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;n=b[a>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6;break c}else{c[98]=a+4;c[102]=e[d>>1];break c}}case 2:{zi(2,(c[(c[103]|0)+12>>2]|0)+(c[102]|0)|0);a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;n=b[a>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6;break c}else{c[98]=a+4;c[102]=e[d>>1];break c}}case 3:{yi(3,(c[(c[103]|0)+12>>2]|0)+(c[102]|0)|0,8);a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;n=b[a>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6;break c}else{c[98]=a+4;c[102]=e[d>>1];break c}}case 5:{g=c[102]|0;d=c[103]|0;h=c[d+836>>2]|0;a=c[98]|0;c[99]=a;f=a+2|0;c[98]=f;n=b[a>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=e[a+4>>1]<<16|e[f>>1];c[98]=a+6}else{c[98]=a+4;c[102]=e[f>>1]}a=c[d+828>>2]|0;if(!a){f=103;break b}d=b[h+(g<<3)+2>>1]|0;if(d<<16>>16!=-1){if((b[a+2>>1]|0)!=21930){f=108;break b}if((b[a>>1]|0)!=d<<16>>16){f=108;break b}d=c[a+4>>2]|0;if((b[d>>1]|0)!=5){f=108;break b}c[d+40>>2]=c[a+8>>2];a=rd[c[(c[3356>>2]|0)+728>>2]&63](d)|0;if(!(b[a>>1]|0)){f=110;break b}a=c[a+12>>2]|0}a=a+(c[h+(g<<3)+4>>2]|0)|0;c[p>>2]=b[h+(g<<3)>>1];g=Zd(a,p)|0;a=c[p>>2]|0;d=c[839]|0;f=b[d+(a*140|0)+8>>1]|0;if(f<<16>>16<0){a=rd[c[d+(a*140|0)+56>>2]&63](g)|0;d=c[p>>2]|0}else{d=a;a=f<<16>>16}yi(d,g,a);break}case 7:{a=c[103]|0;c[o>>2]=(c[a+8>>2]|0)+(c[(c[a+20>>2]|0)+(c[102]<<2)>>2]<<1);yi(1,o,4);a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;n=b[a>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6;break c}else{c[98]=a+4;c[102]=e[d>>1];break c}}default:{d=(c[105]|0)+(d<<5)+16|0;if(!(c[d>>2]|0)){f=119;break b}f=c[102]|0;a=c[98]|0;c[99]=a;g=a+2|0;c[98]=g;n=b[a>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=e[a+4>>1]<<16|e[g>>1];c[98]=a+6}else{c[98]=a+4;c[102]=e[g>>1]}m=wd[c[d>>2]&31](p,f)|0;n=rd[c[(c[3356>>2]|0)+((c[p>>2]|0)*140|0)+56>>2]&63](m)|0;yi(c[p>>2]|0,m,n)}}while(0);a=c[100]|0;if(a){f=126;break}a=16384;d=c[101]|0}switch(f|0){case 27:if((q|0)==((d-(c[848]|0)|0)/80|0|0)){r=Rb(4)|0;c[r>>2]=4;ad(r|0,8,0)}else{c[100]=a;h=-1;break}case 37:{r=Rb(4)|0;c[r>>2]=19;ad(r|0,8,0)}case 40:{r=Rb(4)|0;c[r>>2]=19;ad(r|0,8,0)}case 53:{r=Rb(4)|0;c[r>>2]=34;ad(r|0,8,0)}case 54:{r=Rb(4)|0;c[r>>2]=4;ad(r|0,8,0)}case 58:{r=Rb(4)|0;c[r>>2]=27;ad(r|0,8,0)}case 103:{r=Rb(4)|0;c[r>>2]=30;ad(r|0,8,0)}case 108:{r=Rb(4)|0;c[r>>2]=36;ad(r|0,8,0)}case 110:{r=Rb(4)|0;c[r>>2]=36;ad(r|0,8,0)}case 119:{r=Rb(4)|0;c[r>>2]=30;ad(r|0,8,0)}case 126:{d=c[849]|0;h=0;break}}c[100]=a&-16385;o=b[d+-80>>1]|0;g=o<<16>>16;c[p>>2]=g;if(o<<16>>16==4){p=c[104]|0;c[97]=p;c[c[p+28>>2]>>2]=c[d+-64>>2]}else{f=c[839]|0;p=c[838]|0;a=p+(g*48|0)|0;c[97]=a;do if((b[p+(g*48|0)+2>>1]|0)==-1)if(!(b[f+(g*140|0)>>1]|0)){r=Rb(4)|0;c[r>>2]=27;ad(r|0,8,0)}else{_f(a,g);a=c[97]|0;break}while(0);sd[c[f+(g*140|0)+72>>2]&15](a,c[a+28>>2]|0,c[d+-76>>2]|0);d=c[849]|0}a=d+-80|0;c[849]=a;if(b[d+-78>>1]|0){Bi();a=c[849]|0}if((q|0)==((a-(c[848]|0)|0)/80|0|0)){q=h;i=r;return q|0}else{r=Rb(4)|0;c[r>>2]=29;ad(r|0,8,0)}return 0}function $d(){var a=0;if((_d()|0)<-1){a=Rb(4)|0;c[a>>2]=5;ad(a|0,8,0)}a=c[97]|0;if((b[a>>1]|0)==2)return c[a+28>>2]|0;else{a=Rb(4)|0;c[a>>2]=6;ad(a|0,8,0)}return 0}function ae(a){a=a|0;if((_d()|0)<-1)return a|0;a=c[97]|0;if((b[a>>1]|0)!=2){a=Rb(4)|0;c[a>>2]=6;ad(a|0,8,0)}a=c[a+28>>2]|0;return a|0}function be(a){a=a|0;if((_d()|0)<-1)return a|0;a=c[97]|0;if((b[a>>1]|0)==2){a=c[a+28>>2]|0;return a|0}a=$f(a,2)|0;return a|0}function ce(){var a=0;if((_d()|0)<-1){a=Rb(4)|0;c[a>>2]=5;ad(a|0,8,0)}a=c[97]|0;switch(b[a>>1]|0){case 4:{a=c[c[a+28>>2]>>2]|0;return a|0}case 3:{a=~~+h[c[a+28>>2]>>3];return a|0}default:{a=Rb(4)|0;c[a>>2]=6;ad(a|0,8,0)}}return 0}function de(a){a=a|0;if((_d()|0)<-1)return a|0;a=c[97]|0;switch(b[a>>1]|0){case 4:{a=c[c[a+28>>2]>>2]|0;return a|0}case 3:{a=~~+h[c[a+28>>2]>>3];return a|0}default:{a=Rb(4)|0;c[a>>2]=6;ad(a|0,8,0)}}return 0}function ee(){var a=0,d=0.0;if((_d()|0)<-1){a=Rb(4)|0;c[a>>2]=5;ad(a|0,8,0)}a=c[97]|0;switch(b[a>>1]|0){case 3:{d=+h[c[a+28>>2]>>3];return +d}case 4:{d=+(c[c[a+28>>2]>>2]|0);return +d}default:{a=Rb(4)|0;c[a>>2]=6;ad(a|0,8,0)}}return 0.0}function fe(a){a=+a;var d=0;if((_d()|0)<-1)return +a;d=c[97]|0;switch(b[d>>1]|0){case 3:{a=+h[c[d+28>>2]>>3];return +a}case 4:{a=+(c[c[d+28>>2]>>2]|0);return +a}default:{d=Rb(4)|0;c[d>>2]=6;ad(d|0,8,0)}}return 0.0}function ge(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;switch(d|0){case 1:{a=c[(c[a>>2]|0)+40>>2]|0;return a|0}case -3:{e=c[b>>2]|0;d=c[b+4>>2]|0;if((c[101]|0)==0&(c[102]|0)==40){a=Rb(4)|0;c[a>>2]=34;ad(a|0,8,0)}break}case -2:{d=c[b>>2]|0;e=d;d=$e(d)|0;break}case -1:{e=b;d=$e(b)|0;break}default:{a=Rb(4)|0;c[a>>2]=23;ad(a|0,8,0)}}c[a>>2]=e;a=d;return a|0}function he(a){a=a|0;var d=0,f=0,g=0,h=0,i=0;if(c[100]|0){a=Rb(4)|0;c[a>>2]=23;ad(a|0,8,0)}switch(c[101]|0){case 5:{h=c[102]|0;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;i=b[d>>1]|0;b[12328]=i;g=i&65535;c[100]=g&24576;c[101]=g&4095;if(i<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}f=c[103]|0;d=c[f+828>>2]|0;if(!d){i=Rb(4)|0;c[i>>2]=30;ad(i|0,8,0)}if((h|0)==-1){if((b[d+2>>1]|0)!=21930){i=Rb(4)|0;c[i>>2]=36;ad(i|0,8,0)}c[a>>2]=c[d+4>>2];c[100]=g&8192;i=c[d+8>>2]|0;return i|0}g=c[f+836>>2]|0;f=b[g+(h<<3)+2>>1]|0;do if(f<<16>>16!=-1){if((b[d+2>>1]|0)!=21930){i=Rb(4)|0;c[i>>2]=36;ad(i|0,8,0)}if((b[d>>1]|0)!=f<<16>>16){i=Rb(4)|0;c[i>>2]=36;ad(i|0,8,0)}f=c[d+4>>2]|0;if((b[f>>1]|0)!=5){i=Rb(4)|0;c[i>>2]=36;ad(i|0,8,0)}c[f+40>>2]=c[d+8>>2];d=rd[c[(c[3356>>2]|0)+728>>2]&63](f)|0;if(!(b[d>>1]|0)){i=Rb(4)|0;c[i>>2]=36;ad(i|0,8,0)}else{d=c[d+12>>2]|0;break}}while(0);i=ge(a,d+(c[g+(h<<3)+4>>2]|0)|0,b[g+(h<<3)>>1]|0)|0;c[100]=c[100]&8192;return i|0}case 1:{f=(c[(c[103]|0)+44>>2]|0)+((c[102]|0)*48|0)|0;d=c[98]|0;c[99]=d;g=d+2|0;c[98]=g;i=b[d>>1]|0;b[12328]=i;h=i&65535;c[100]=h&24576;c[101]=h&4095;if(i<<16>>16<0){c[102]=e[d+4>>1]<<16|e[g>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[g>>1]}i=$e(f)|0;c[100]=c[100]&8192;c[a>>2]=f;return i|0}default:{i=Rb(4)|0;c[i>>2]=23;ad(i|0,8,0)}}return 0}function ie(){var a=0,b=0;b=i;i=i+16|0;a=b;if(!(he(a)|0)){i=b;return c[a>>2]|0}else{b=Rb(4)|0;c[b>>2]=25;ad(b|0,8,0)}return 0}function je(){var a=0;if((c[101]|0)==7){a=c[103]|0;a=(c[a+8>>2]|0)+(c[(c[a+20>>2]|0)+(c[102]<<2)>>2]<<1)|0;return a|0}if((_d()|0)<-1){a=Rb(4)|0;c[a>>2]=8;ad(a|0,8,0)}a=c[97]|0;if((b[a>>1]|0)!=1){a=Rb(4)|0;c[a>>2]=8;ad(a|0,8,0)}a=c[c[a+28>>2]>>2]|0;if(!a){a=Rb(4)|0;c[a>>2]=8;ad(a|0,8,0)}c[98]=c[99];return a|0}function ke(){var a=0,d=0,f=0,g=0,h=0;d=je()|0;a=c[98]|0;c[99]=a;f=a+2|0;c[98]=f;h=b[a>>1]|0;b[12328]=h;g=h&65535;c[100]=g&24576;c[101]=g&4095;if(h<<16>>16<0){c[102]=(e[a+4>>1]|0)<<16|(e[f>>1]|0);c[98]=a+6;h=g&8192;c[100]=h;return d|0}else{c[98]=a+4;c[102]=e[f>>1];h=g&8192;c[100]=h;return d|0}return 0}function le(){var a=0,d=0,f=0,g=0,h=0,i=0,j=0;if((c[101]|0)!=5){i=Rb(4)|0;c[i>>2]=35;ad(i|0,8,0)}f=c[102]|0;g=c[103]|0;h=c[g+836>>2]|0;a=c[98]|0;c[99]=a;i=a+2|0;c[98]=i;j=b[a>>1]|0;b[12328]=j;d=j&65535;c[100]=d&24576;c[101]=d&4095;if(j<<16>>16<0){c[102]=e[a+4>>1]<<16|e[i>>1];c[98]=a+6}else{c[98]=a+4;c[102]=e[i>>1]}c[100]=d&8192;if((b[h+(f<<3)>>1]|0)==-5)return (c[g+840>>2]|0)+((b[h+(f<<3)+2>>1]|0)*28|0)|0;else{j=Rb(4)|0;c[j>>2]=35;ad(j|0,8,0)}return 0}function me(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0;c[a+40>>2]=d;g=c[839]|0;do if((b[a>>1]|0)!=(e|0))if(!d){Zf(a,e);break}else{e=Rb(4)|0;c[e>>2]=31;ad(e|0,8,0)}while(0);d=c[g+(e*140|0)+72>>2]|0;e=rd[c[g+(e*140|0)+28>>2]&63](a)|0;sd[d&15](a,e,f);return}function ne(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;h=he(a)|0;e=c[a>>2]|0;a=b[e>>1]|0;g=c[839]|0;f=c[g+(a*140|0)+64>>2]|0;c[e+40>>2]=h;a=rd[c[g+(a*140|0)+28>>2]&63](e)|0;return jd[f&15](e,a,d)|0}function oe(d,f,g){d=d|0;f=f|0;g=g|0;var j=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;u=i;i=i+16|0;s=u+4|0;t=u;r=f+8|0;if((c[r>>2]|0)<=0){i=u;return}p=(g&1|0)==0;q=0;o=(c[(c[103]|0)+836>>2]|0)+(c[f+4>>2]<<3)|0;a:while(1){g=c[o+4>>2]|0;n=d+g|0;b:do switch(b[o>>1]|0){case 4:{c:do if((_d()|0)<-1)g=0;else{g=c[97]|0;switch(b[g>>1]|0){case 4:{g=c[c[g+28>>2]>>2]|0;break c}case 3:{g=~~+h[c[g+28>>2]>>3];break c}default:{g=6;break a}}}while(0);c[n>>2]=g;break}case -7:{m=he(s)|0;b[d+(g+2)>>1]=21930;b[n>>1]=b[o+2>>1]|0;c[d+(g+4)>>2]=c[s>>2];c[d+(g+8)>>2]=m;break}case -20:case -11:{c[n>>2]=c[106];c[n+4>>2]=c[107];c[n+8>>2]=c[108];break}case -2:case -3:{m=he(t)|0;c[n>>2]=c[t>>2];c[d+(g+4)>>2]=m;break}case 7:{f=je()|0;g=c[98]|0;c[99]=g;l=g+2|0;c[98]=l;v=b[g>>1]|0;b[12328]=v;m=v&65535;c[100]=m&24576;c[101]=m&4095;if(v<<16>>16<0){c[102]=e[g+4>>1]<<16|e[l>>1];c[98]=g+6}else{c[98]=g+4;c[102]=e[l>>1]}c[100]=m&8192;c[n>>2]=f;break}case 3:{if((_d()|0)<-1){g=18;break a}g=c[97]|0;switch(b[g>>1]|0){case 3:{j=+h[c[g+28>>2]>>3];break}case 4:{j=+(c[c[g+28>>2]>>2]|0);break}default:{g=20;break a}}h[k>>3]=j;a[n>>0]=a[k>>0];a[n+1>>0]=a[k+1>>0];a[n+2>>0]=a[k+2>>0];a[n+3>>0]=a[k+3>>0];a[n+4>>0]=a[k+4>>0];a[n+5>>0]=a[k+5>>0];a[n+6>>0]=a[k+6>>0];a[n+7>>0]=a[k+7>>0];break}case -6:{if((_d()|0)<-1){g=25;break a}g=c[97]|0;if((b[g>>1]|0)!=2){g=27;break a}m=c[g+28>>2]|0;v=Fi((Mn(m)|0)+1|0)|0;Kn(v,m)|0;c[n>>2]=v;break}case -1:{b[d+(g+2)>>1]=-1;if(!p?(_d()|0)==0:0){m=c[97]|0;b[n>>1]=b[m>>1]|0;Zf(n,b[m>>1]|0);m=b[n>>1]|0;l=c[839]|0;v=rd[c[l+(m*140|0)+28>>2]&63](n)|0;sd[c[l+(m*140|0)+72>>2]&15](n,v,c[(c[97]|0)+28>>2]|0);break b}b[n>>1]=4;Zf(n,4);break}case -5:break;default:{g=33;break a}}while(0);q=q+1|0;if((q|0)>=(c[r>>2]|0)){g=35;break}else o=o+8|0}if((g|0)==6){v=Rb(4)|0;c[v>>2]=6;ad(v|0,8,0)}else if((g|0)==18){v=Rb(4)|0;c[v>>2]=5;ad(v|0,8,0)}else if((g|0)==20){v=Rb(4)|0;c[v>>2]=6;ad(v|0,8,0)}else if((g|0)==25){v=Rb(4)|0;c[v>>2]=5;ad(v|0,8,0)}else if((g|0)==27){v=Rb(4)|0;c[v>>2]=6;ad(v|0,8,0)}else if((g|0)==33){v=Rb(4)|0;c[v>>2]=36;ad(v|0,8,0)}else if((g|0)==35){i=u;return}}function pe(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c[a+40>>2]=d;l=rd[c[(c[3356>>2]|0)+((b[a>>1]<<16>>16)*140|0)+28>>2]&63](a)|0;if((b[l>>1]|0)!=1)return;f=b[l+4>>1]|0;i=c[103]|0;h=c[i+836>>2]|0;g=h+(f<<3)|0;f=b[h+(f<<3)+2>>1]|0;h=f<<16>>16;i=c[i+840>>2]|0;k=l+12|0;e=c[k>>2]|0;if(!(b[l+6>>1]|0)){j=c[i+(h*28|0)+20>>2]|0;if(j){b[213]=21930;b[212]=f;c[107]=a;c[108]=d;af(j)}i=i+(h*28|0)+8|0;f=c[i>>2]|0;if((f|0)>0){h=0;while(1){if((b[g>>1]|0)==-1){f=e+(c[g+4>>2]|0)|0;od[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+52>>2]&63](f);f=c[i>>2]|0}h=h+1|0;if((h|0)>=(f|0))break;else g=g+8|0}}e=c[k>>2]|0}Hi(e);b[l>>1]=0;return}function qe(a){a=a|0;var d=0,e=0;if((b[a+2>>1]|0)!=1)return;d=a+8|0;if((c[d>>2]|0)>0)e=0;else return;do{pe(a,e);e=e+1|0}while((e|0)<(c[d>>2]|0));return}function re(a){a=a|0;if((a|0)>1024){a=Ii(c[(c[103]|0)+824>>2]|0,a)|0;c[(c[103]|0)+824>>2]=a}return c[(c[103]|0)+824>>2]|0}function se(a){a=a|0;var b=0;b=Mn(a)|0;if((b|0)>1023){b=Ii(c[(c[103]|0)+824>>2]|0,b+1|0)|0;c[(c[103]|0)+824>>2]=b}b=c[(c[103]|0)+824>>2]|0;Kn(b,a)|0;return b|0}function te(a){a=a|0;var d=0;if((a|0)>=0){d=c[105]|0;a=d+(a<<5)|0;return a|0}d=c[109]|0;a=d+1|0;c[109]=a;a=Ii(c[105]|0,a<<5)|0;c[105]=a;b[a+(d<<5)>>1]=d;b[a+(d<<5)+2>>1]=0;c[a+(d<<5)+4>>2]=c[103];c[a+(d<<5)+8>>2]=c[(c[103]|0)+876>>2];c[a+(d<<5)+12>>2]=3;c[a+(d<<5)+16>>2]=0;c[a+(d<<5)+20>>2]=0;c[a+(d<<5)+28>>2]=0;a=c[105]|0;d=a+(d<<5)|0;return d|0}function ue(a){a=a|0;c[103]=a;return}function ve(a){a=a|0;c[a+236>>2]=4;return}function we(a){a=a|0;var b=0;b=(c[838]|0)+192|0;c[104]=b;_f(b,4);c[a+776>>2]=0;c[a+780>>2]=1;c[a+244>>2]=5;c[a+252>>2]=0;c[a+772>>2]=0;c[a+256>>2]=0;c[a+784>>2]=0;c[a+788>>2]=0;c[a+236>>2]=0;c[a+828>>2]=0;c[a+808>>2]=0;c[a+816>>2]=0;c[a+852>>2]=9;return}function xe(){return c[(c[103]|0)+776>>2]|0}function ye(a){a=a|0;var d=0,f=0,g=0,h=0;d=(c[103]|0)+236|0;if((c[d>>2]|0)==4)return;c[99]=a;f=a+2|0;c[98]=f;g=b[a>>1]|0;b[12328]=g;h=g&65535;c[100]=h&24576;c[101]=h&4095;if(g<<16>>16<0){c[102]=(e[a+4>>1]|0)<<16|(e[f>>1]|0);c[98]=a+6}else{c[98]=a+4;c[102]=e[f>>1]}c[d>>2]=0;return}function ze(a){a=a|0;var d=0,f=0,g=0,h=0;d=(c[103]|0)+236|0;if((c[d>>2]|0)==4){c[d>>2]=7;return}c[99]=a;f=a+2|0;c[98]=f;g=b[a>>1]|0;b[12328]=g;h=g&65535;c[100]=h&24576;c[101]=h&4095;if(g<<16>>16<0){c[102]=(e[a+4>>1]|0)<<16|(e[f>>1]|0);c[98]=a+6}else{c[98]=a+4;c[102]=e[f>>1]}c[d>>2]=0;c[d>>2]=7;return}function Ae(a){a=a|0;var d=0,f=0,g=0,h=0,j=0;g=i;i=i+32|0;d=g;f=c[99]|0;c[98]=f;c[d+4>>2]=f;f=c[103]|0;j=f+256|0;h=c[j>>2]|0;c[j>>2]=h+1;c[d>>2]=h;c[d+12>>2]=c[f+828>>2];c[d+8>>2]=0;yi(256,d,20);d=(c[103]|0)+236|0;if((c[d>>2]|0)!=4){c[99]=a;f=a+2|0;c[98]=f;j=b[a>>1]|0;b[12328]=j;h=j&65535;c[100]=h&24576;c[101]=h&4095;if(j<<16>>16<0){c[102]=(e[a+4>>1]|0)<<16|(e[f>>1]|0);c[98]=a+6}else{c[98]=a+4;c[102]=e[f>>1]}c[d>>2]=0}if((c[d>>2]|0)==4){i=g;return}c[d>>2]=0;i=g;return}function Be(){return Ce(c[99]|0)|0}function Ce(b){b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0;i=c[103]|0;j=c[i+16>>2]|0;i=b-(c[i+8>>2]|0)>>1;if((a[j>>0]|0)==-1){j=-1;return j|0}else{f=0;b=0;h=0}a:while(1){b:while(1){c:while(1){e=d[j+f>>0]|0;switch(e|0){case 255:{b=-1;g=14;break a}case 252:{g=5;break b}case 254:{e=f;break c}case 253:break;default:{g=12;break b}}f=f+6|0}b=d[j+(e+2)>>0]<<8|d[j+(e+3)>>0]<<16|d[j+(e+1)>>0];if(b)c[111]=b;f=e+6|0;b=d[j+(e+5)>>0]<<8|d[j+(e+4)>>0]}if((g|0)==5){e=(d[j+(f+2)>>0]<<8|d[j+(f+1)>>0])+h|0;if((i|0)<=(e|0)){g=14;break}f=f+3|0}else if((g|0)==12){e=e+h|0;if((i|0)<=(e|0)){g=14;break}f=f+1|0}b=b+1|0;h=e}if((g|0)==14)return b|0;return 0}function De(){var b=0,e=0,f=0,g=0;c[112]=0;e=c[(c[103]|0)+16>>2]|0;if((a[e>>0]|0)==-1){g=-1;return g|0}else f=0;a:while(1){b=e+f|0;switch(d[b>>0]|0){case 253:break a;case 255:{b=-1;g=7;break a}case 252:{f=f+3|0;continue a}case 254:{f=f+6|0;continue a}default:{f=f+1|0;continue a}}}if((g|0)==7)return b|0;c[112]=b;g=0;return g|0}function Ee(a){a=a|0;var b=0;b=c[112]|0;if(!b){a=30178;return a|0}a=a*6|0;a=(c[(c[103]|0)+12>>2]|0)+((d[b+(a+2)>>0]|0)<<8|(d[b+(a+3)>>0]|0)<<16|(d[b+(a|1)>>0]|0))|0;return a|0}function Fe(a){a=a|0;var b=0,e=0,f=0,g=0;e=c[112]|0;if(!e){a=-1;return a|0}b=c[103]|0;g=c[(c[b>>2]|0)+8>>2]|0;if((g|0)<=0){a=-1;return a|0}f=c[b+12>>2]|0;b=0;while(1){if(!(Jn(f+((d[e+2>>0]|0)<<8|(d[e+3>>0]|0)<<16|(d[e+1>>0]|0))|0,a)|0)){e=6;break}b=b+1|0;if((b|0)>=(g|0)){b=-1;e=6;break}else e=e+6|0}if((e|0)==6)return b|0;return 0}function Ge(){return (c[(c[103]|0)+12>>2]|0)+(c[111]|0)|0}function He(a){a=a|0;var b=0,d=0;b=c[103]|0;d=c[b+240>>2]|0;if((d|0)<1){c[b+236>>2]=0;a=0;return a|0}else{c[b+248>>2]=(d*10|0)+a;a=2;return a|0}return 0}function Ie(a){a=a|0;var b=0,d=0,e=0,f=0;f=c[103]|0;e=f+248|0;b=c[e>>2]|0;if((b|0)<0){d=f+252|0;b=c[d>>2]|0;if(!b){c[d>>2]=a;b=a}b=(c[f+240>>2]|0)+b|0;c[e>>2]=b}if((b|0)>(a|0)){a=2;return a|0}c[f+252>>2]=a;c[f+236>>2]=0;a=0;return a|0}function Je(){var a=0,d=0,e=0,f=0,g=0;Ci();vi();Qf();c[97]=c[838];c[110]=0;b[226]=13571;b[227]=3;c[114]=648;a=c[103]|0;c[115]=c[a+824>>2];d=c[a+792>>2]|0;c[116]=d;c[121]=a+788;c[122]=d;c[123]=1;c[128]=8;c[129]=1;c[130]=4;c[119]=404;c[120]=408;c[117]=388;c[124]=2;c[125]=5;c[126]=3;c[127]=6;c[131]=0;c[136]=0;c[135]=a;c[134]=400;c[133]=0;c[137]=10;c[138]=7;c[139]=8;c[140]=2;c[141]=4;c[144]=5;c[145]=6;c[146]=9;c[147]=3;c[142]=1;c[143]=1;c[148]=10;c[149]=11;c[150]=1;c[151]=7;c[152]=2;c[153]=1;c[154]=12;c[155]=13;c[157]=1;c[158]=1;c[159]=2;c[160]=11;c[161]=12;so(a+48|0,452,188)|0;c[a+876>>2]=452;a=Fi(576)|0;c[105]=a;c[109]=18;d=0;do{b[a+(d<<5)>>1]=d;b[a+(d<<5)+2>>1]=0;c[a+(d<<5)+4>>2]=c[103];c[a+(d<<5)+8>>2]=c[(c[103]|0)+876>>2];c[a+(d<<5)+12>>2]=3;c[a+(d<<5)+16>>2]=0;c[a+(d<<5)+20>>2]=0;c[a+(d<<5)+28>>2]=0;d=d+1|0;a=c[105]|0}while((d|0)<18);c[a+44>>2]=13;c[(c[105]|0)+172>>2]=13;c[(c[105]|0)+492>>2]=14;c[(c[105]|0)+364>>2]=15;c[(c[105]|0)+464>>2]=2;xf((c[105]|0)+256|0);yf((c[105]|0)+416|0);yf((c[105]|0)+416|0);f=c[105]|0;c[f+396>>2]=16;c[f+400>>2]=3;c[(c[103]|0)+24>>2]=0;f=c[103]|0;c[f+28>>2]=0;g=0;d=0;while(1){e=g+1|0;c[f+28>>2]=e;a=c[f+24>>2]|0;if(!a){f=Fi(24)|0;c[(c[103]|0)+24>>2]=f}else{f=Ii(a,e*24|0)|0;c[(c[103]|0)+24>>2]=f}a=c[(c[103]|0)+24>>2]|0;b[a+(g*24|0)>>1]=1;b[a+(g*24|0)+2>>1]=0;c[a+(g*24|0)+4>>2]=-1;c[a+(g*24|0)+12>>2]=0;c[a+(g*24|0)+16>>2]=0;c[a+(g*24|0)+20>>2]=0;d=d+1|0;a=c[103]|0;if((d|0)==5)break;f=a;g=c[a+28>>2]|0}b[(c[a+24>>2]|0)+96>>1]=2;c[109]=18;g=Fi(4096)|0;c[(c[103]|0)+792>>2]=g;g=Fi(256)|0;c[(c[103]|0)+796>>2]=g;g=Fi(4096)|0;c[(c[103]|0)+824>>2]=g;g=Fi(1024)|0;c[(c[103]|0)+872>>2]=g;c[112]=0;c[163]=0;c[169]=c[103];c[165]=0;c[166]=0;c[170]=17;c[171]=4;c[172]=14;c[173]=3;c[174]=18;c[175]=8;return}function Ke(){var a=0,d=0,e=0,f=0;e=c[103]|0;f=e+28|0;a=c[f>>2]|0;d=a+1|0;c[f>>2]=d;e=c[e+24>>2]|0;if(!e){f=Fi(24)|0;c[(c[103]|0)+24>>2]=f}else{f=Ii(e,d*24|0)|0;c[(c[103]|0)+24>>2]=f}e=c[(c[103]|0)+24>>2]|0;f=e+(a*24|0)|0;b[f>>1]=1;b[e+(a*24|0)+2>>1]=0;c[e+(a*24|0)+4>>2]=-1;c[e+(a*24|0)+12>>2]=0;c[e+(a*24|0)+16>>2]=0;c[e+(a*24|0)+20>>2]=0;return f|0}function Le(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;j=b[24658+(a<<1)>>1]|0;g=c[109]|0;a:do if((g|0)>18){i=18;while(1){h=c[105]|0;if((b[h+(i<<5)+2>>1]&j)<<16>>16!=0?(k=c[h+(i<<5)+28>>2]|0,(k|0)!=0):0){g=ud[k&3](a,d,e,f)|0;if(g)break;g=c[109]|0}i=i+1|0;if((i|0)>=(g|0))break a}return g|0}while(0);do switch(a|0){case 14:{Hi(c[176]|0);f=0;return f|0}case 2:{We(f,d,e);f=0;return f|0}case 13:{c[176]=Fi(4096)|0;e=nl(c[(c[103]|0)+796>>2]|0,704,d)|0;c[(c[103]|0)+784>>2]=e;c[f>>2]=c[176];f=0;return f|0}case 12:if(!(Pd(c[(c[103]|0)+796>>2]|0,f)|0)){f=0;return f|0}else{f=Rb(4)|0;c[f>>2]=12;ad(f|0,8,0)}case 5:{Pn(c[(c[103]|0)+796>>2]|0,f,255)|0;f=0;return f|0}case 6:{g=Md(c[(c[103]|0)+796>>2]|0,f,e,d)|0;if((g|0)<0){f=Rb(4)|0;c[f>>2]=12;ad(f|0,8,0)}c[(c[103]|0)+788>>2]=g;f=0;return f|0}case 7:{g=gl(c[(c[103]|0)+796>>2]|0,f,e,d)|0;if((g|0)<0){f=Rb(4)|0;c[f>>2]=12;ad(f|0,8,0)}c[(c[103]|0)+788>>2]=g;f=0;return f|0}case 8:{f=Nd(c[(c[103]|0)+796>>2]|0)|0;c[(c[103]|0)+788>>2]=f;f=0;return f|0}case 9:if(!(ml(c[(c[103]|0)+796>>2]|0)|0)){f=Rb(4)|0;c[f>>2]=12;ad(f|0,8,0)}else{f=0;return f|0}case 10:if(!(kl(c[(c[103]|0)+796>>2]|0)|0)){f=0;return f|0}else{f=Rb(4)|0;c[f>>2]=12;ad(f|0,8,0)}case 11:if(!(ll(c[(c[103]|0)+796>>2]|0)|0)){f=0;return f|0}else{f=Rb(4)|0;c[f>>2]=12;ad(f|0,8,0)}default:{f=0;return f|0}}while(0);return 0}function Me(a,d){a=a|0;d=d|0;b[(c[(c[103]|0)+24>>2]|0)+(a*24|0)>>1]=(d|0)==0?1:2;return}function Ne(a){a=a|0;a=Fi(16384)|0;c[177]=a;return a|0}function Oe(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;H=i;i=i+4e3|0;F=H+1688|0;E=H+1680|0;B=H+1672|0;A=H+1664|0;z=H+1656|0;y=H+1632|0;x=H+1624|0;s=H+1616|0;t=H+1592|0;r=H+1584|0;v=H+1576|0;D=H+552|0;G=H+40|0;n=H+32|0;q=H;w=H+1952|0;u=H+1696|0;C=H+1692|0;c[177]=Fi(16384)|0;m=c[103]|0;p=c[(c[m>>2]|0)+8>>2]|0;g=(p|0)>0;if(!e){if(!g){G=c[177]|0;i=H;return G|0}if(!(f&2)){h=0;do{g=c[112]|0;if(!g)g=30178;else{G=h*6|0;g=(c[(c[103]|0)+12>>2]|0)+(d[g+(G+2)>>0]<<8|d[g+(G+3)>>0]<<16|d[g+(G|1)>>0])|0}if(!((g|0)==0|(hl(g,25093)|0)!=0)){Ki(708,g);Ki(708,25095)}h=h+1|0}while((h|0)!=(p|0));G=c[177]|0;i=H;return G|0}else{h=0;do{g=c[112]|0;if(g){G=h*6|0;g=(c[(c[103]|0)+12>>2]|0)+(d[g+(G+2)>>0]<<8|d[g+(G+3)>>0]<<16|d[g+(G|1)>>0])|0;if(g)j=18}else{g=30178;j=18}if((j|0)==18){j=0;Ki(708,g);Ki(708,25095)}h=h+1|0}while((h|0)!=(p|0));G=c[177]|0;i=H;return G|0}}a:do if(g){l=c[112]|0;if(!l){h=(a[e>>0]|0)==0;g=0;while(1){if(h){h=30178;break a}g=g+1|0;if((g|0)>=(p|0)){h=30178;break}}}else{j=c[m+12>>2]|0;g=0;do{h=g*6|0;h=j+(d[l+(h+2)>>0]<<8|d[l+(h+3)>>0]<<16|d[l+(h|1)>>0])|0;if(!(Jn(h,e)|0))break a;g=g+1|0}while((g|0)<(p|0))}}else{g=0;h=0}while(0);j=c[m+44>>2]|0;m=j+(g*48|0)|0;p=b[m>>1]|0;I=c[839]|0;Pn(w,25098,64)|0;l=w+(Mn(w)|0)|0;a[l>>0]=58;a[l+1>>0]=0;Nn(w,h,1973)|0;l=w+(Mn(w)|0)|0;a[l>>0]=a[25095]|0;a[l+1>>0]=a[25096]|0;a[l+2>>0]=a[25097]|0;Ki(708,w);l=c[I+(p*140|0)+12>>2]|0;Pn(w,25105,64)|0;J=w+(Mn(w)|0)|0;a[J>>0]=58;a[J+1>>0]=0;Nn(w,l,1973)|0;l=w+(Mn(w)|0)|0;a[l>>0]=a[25095]|0;a[l+1>>0]=a[25096]|0;a[l+2>>0]=a[25097]|0;Ki(708,w);l=j+(g*48|0)+8|0;J=c[j+(g*48|0)+12>>2]|0;h=c[j+(g*48|0)+16>>2]|0;e=c[j+(g*48|0)+20>>2]|0;c[q>>2]=c[l>>2];c[q+4>>2]=J;c[q+8>>2]=h;c[q+12>>2]=e;fn(u,25108,q)|0;Pn(w,25122,64)|0;e=w+(Mn(w)|0)|0;a[e>>0]=58;a[e+1>>0]=0;Nn(w,u,1973)|0;e=w+(Mn(w)|0)|0;a[e>>0]=a[25095]|0;a[e+1>>0]=a[25096]|0;a[e+2>>0]=a[25097]|0;Ki(708,w);c[n>>2]=b[j+(g*48|0)+2>>1];fn(q,25779,n)|0;Pn(w,25127,64)|0;e=w+(Mn(w)|0)|0;a[e>>0]=58;a[e+1>>0]=0;Nn(w,q,1973)|0;e=w+(Mn(w)|0)|0;a[e>>0]=a[25095]|0;a[e+1>>0]=a[25096]|0;a[e+2>>0]=a[25097]|0;Ki(708,w);c[G>>2]=c[j+(g*48|0)+24>>2];fn(q,25779,G)|0;Pn(w,25134,64)|0;e=w+(Mn(w)|0)|0;a[e>>0]=58;a[e+1>>0]=0;Nn(w,q,1973)|0;e=w+(Mn(w)|0)|0;a[e>>0]=a[25095]|0;a[e+1>>0]=a[25096]|0;a[e+2>>0]=a[25097]|0;Ki(708,w);e=j+(g*48|0)+40|0;c[e>>2]=0;b[j+(g*48|0)+38>>1]=0;j=rd[c[I+(p*140|0)+28>>2]&63](m)|0;n=jd[c[I+(p*140|0)+64>>2]&15](m,j,C)|0;c[D>>2]=c[C>>2];fn(q,25779,D)|0;Pn(w,25145,64)|0;g=w+(Mn(w)|0)|0;a[g>>0]=58;a[g+1>>0]=0;Nn(w,q,1973)|0;g=w+(Mn(w)|0)|0;a[g>>0]=a[25095]|0;a[g+1>>0]=a[25096]|0;a[g+2>>0]=a[25097]|0;Ki(708,w);g=b[m>>1]|0;h=g<<16>>16;if((h+-2|0)>>>0<3){if(g<<16>>16==2)g=n;else g=wd[c[(c[3356>>2]|0)+300>>2]&31](j,h)|0;h=Mn(g)|0;if((h|0)>1023){Pn(c[(c[103]|0)+824>>2]|0,g,1023)|0;g=c[(c[103]|0)+824>>2]|0;a[g+1023>>0]=0;c[v>>2]=h;fn(u,25160,v)|0;Ki(708,u)}Pn(w,25197,64)|0;J=w+(Mn(w)|0)|0;a[J>>0]=a[25095]|0;a[J+1>>0]=a[25096]|0;a[J+2>>0]=a[25097]|0;Nn(w,g,1973)|0;J=w+(Mn(w)|0)|0;a[J>>0]=a[25095]|0;a[J+1>>0]=a[25096]|0;a[J+2>>0]=a[25097]|0;Ki(708,w)}else{b:do switch(h|0){case 1:{c[r>>2]=c[j>>2];fn(D,25203,r)|0;break}case 5:{g=b[j>>1]|0;if(!(g<<16>>16)){g=D;h=25215;j=g+15|0;do{a[g>>0]=a[h>>0]|0;g=g+1|0;h=h+1|0}while((g|0)<(j|0));break b}else{v=b[j+4>>1]|0;I=c[j+12>>2]|0;J=c[j+8>>2]|0;c[t>>2]=b[j+2>>1];c[t+4>>2]=v;c[t+8>>2]=I;c[t+12>>2]=J;c[t+16>>2]=g<<16>>16;fn(D,25230,t)|0;break b}}case 6:{c[s>>2]=c[j>>2];fn(D,25265,s)|0;break}default:{J=D;c[J>>2]=1852534357;c[J+4>>2]=7239535}}while(0);Pn(w,25197,64)|0;J=w+(Mn(w)|0)|0;a[J>>0]=a[25095]|0;a[J+1>>0]=a[25096]|0;a[J+2>>0]=a[25097]|0;Nn(w,D,1973)|0;J=w+(Mn(w)|0)|0;a[J>>0]=a[25095]|0;a[J+1>>0]=a[25096]|0;a[J+2>>0]=a[25097]|0;Ki(708,w)}if((f&4|0)!=0?(k=c[l>>2]|0,(k|0)>=2):0){if((k|0)>16){Ki(708,25278);k=16}l=0;do{c[e>>2]=l;h=rd[c[(c[3356>>2]|0)+((b[m>>1]<<16>>16)*140|0)+28>>2]&63](m)|0;o=0;g=ra(c[(c[839]|0)+300>>2]|0,h|0,b[m>>1]|0)|0;J=o;o=0;if(J&1){J=kb(0)|0;ec(J|0)|0;c:do switch(b[m>>1]|0){case 1:{c[x>>2]=c[h>>2];fn(D,25203,x)|0;break}case 5:{g=b[h>>1]|0;if(!(g<<16>>16)){g=D;h=25215;j=g+15|0;do{a[g>>0]=a[h>>0]|0;g=g+1|0;h=h+1|0}while((g|0)<(j|0));break c}else{w=b[h+4>>1]|0;I=c[h+12>>2]|0;J=c[h+8>>2]|0;c[y>>2]=b[h+2>>1];c[y+4>>2]=w;c[y+8>>2]=I;c[y+12>>2]=J;c[y+16>>2]=g<<16>>16;fn(D,25230,y)|0;break c}}case 6:{c[z>>2]=c[h>>2];fn(D,25265,z)|0;break}default:{J=D;c[J>>2]=1852534357;c[J+4>>2]=7239535}}while(0);c[A>>2]=l;c[A+4>>2]=D;fn(G,25302,A)|0;cc()}else{if((Mn(g)|0)>>>0>63){Pn(c[(c[103]|0)+824>>2]|0,g,63)|0;a[(c[(c[103]|0)+824>>2]|0)+64>>0]=0;g=c[(c[103]|0)+824>>2]|0}c[B>>2]=l;c[B+4>>2]=g;fn(G,25302,B)|0}Ki(708,G);l=l+1|0}while((l|0)!=(k|0))}if(!(f&8)){J=c[177]|0;i=H;return J|0}g=c[C>>2]|0;if((g|0)>4096){c[C>>2]=4096;g=4096}if((g|0)>0){h=0;do{c[E>>2]=h;fn(D,25312,E)|0;if((h|0)<(g|0)){e=h-g|0;e=e>>>0>4294967288?e:-8;j=0-e|0;k=h;l=0;while(1){c[F>>2]=d[n+k>>0];fn(G,25317,F)|0;Gn(D,G)|0;l=l+1|0;if((l|0)==(j|0))break;else k=k+1|0}h=h-e|0}J=D+(Mn(D)|0)|0;a[J>>0]=a[25095]|0;a[J+1>>0]=a[25096]|0;a[J+2>>0]=a[25097]|0;Ki(708,D)}while((h|0)<(g|0))}J=c[177]|0;i=H;return J|0}function Pe(a){a=a|0;Hi(c[177]|0);return}function Qe(){var a=0,b=0;a=c[99]|0;b=c[98]|0;c[99]=b;c[165]=Ce(b)|0;c[166]=(c[(c[103]|0)+12>>2]|0)+(c[111]|0);c[99]=a;return}function Re(a){a=a|0;var b=0;b=(c[103]|0)+236|0;switch(c[b>>2]|0){case 3:{if((a|0)==2)b=-1;else{c[b>>2]=0;c[163]=(a|0)==1?0:a;b=0}break}case 2:case 1:{if((a|0)==2){c[b>>2]=3;c[163]=0;b=0}else b=-1;break}default:b=-1}return b|0}function Se(){var a=0,d=0,e=0,f=0,g=0,h=0;h=i;i=i+272|0;g=h;f=h+8|0;d=Fi(16384)|0;c[177]=d;e=c[848]|0;a=c[849]|0;if((e|0)==(a|0)){g=d;i=h;return g|0}else d=e;do{if((b[d>>1]&-2)<<16>>16==256){a=Ce(c[(c[d+4>>2]|0)+4>>2]|0)|0;c[g>>2]=(c[(c[103]|0)+12>>2]|0)+(c[111]|0);c[g+4>>2]=a;fn(f,25323,g)|0;Ki(708,f);a=c[849]|0}d=d+80|0}while((d|0)!=(a|0));g=c[177]|0;i=h;return g|0}function Te(){var a=0,d=0,e=0,f=0,g=0,h=0;a=c[103]|0;f=c[(c[a>>2]|0)+8>>2]|0;a:do if((f|0)>0){g=0;d=c[a+44>>2]|0;b:while(1){if(((b[d>>1]|0)==5?(b[d+2>>1]|0)==1:0)?(e=d+8|0,(c[e>>2]|0)>0):0){a=0;do{o=0;la(3,d|0,a|0);h=o;o=0;if(h&1)break b;a=a+1|0}while((a|0)<(c[e>>2]|0))}g=g+1|0;if((g|0)>=(f|0))break a;else d=d+48|0}h=kb(0)|0;ec(h|0)|0;cc()}while(0);d=c[103]|0;a=c[(c[d>>2]|0)+60>>2]|0;c:do if(a>>>0>=28){e=(a>>>0)/28|0;while(1){a=e+-1|0;h=c[d+840>>2]|0;if(((b[h+(a*28|0)>>1]|0)==-1?(c[h+(a*28|0)+24>>2]&65536|0)!=0:0)?(o=0,ja(15,a|0),h=o,o=0,h&1):0)break;if((e|0)<2)break c;e=a;d=c[103]|0}h=kb(0)|0;ec(h|0)|0;cc()}while(0);a=c[109]|0;if((a|0)<=0)return;do{e=a;a=a+-1|0;d=c[(c[105]|0)+(a<<5)+20>>2]|0;if(d)rd[d&63](0)|0}while((e|0)>1);return}function Ue(){var a=0,b=0;Rf();a=c[103]|0;b=c[a+24>>2]|0;if(b){Hi(b);a=c[103]|0}Hi(c[a+872>>2]|0);Hi(c[(c[103]|0)+824>>2]|0);Hi(c[(c[103]|0)+796>>2]|0);Hi(c[(c[103]|0)+792>>2]|0);Hi(c[105]|0);wi();Di();return}function Ve(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c[(c[103]|0)+848>>2]=0;a:while(1){if(!(c[a>>2]|0)){i=c[103]|0;c[i+772>>2]=0;c[i+256>>2]=0;xi();c[a>>2]=1}if(!(((c[163]|0)!=0?(h=c[165]|0,g=c[99]|0,i=c[98]|0,c[99]=i,i=Ce(i)|0,c[165]=i,e=c[103]|0,c[166]=(c[e+12>>2]|0)+(c[111]|0),c[99]=g,(h|0)!=(i|0)):0)?(c[e+236>>2]=3,o=0,ja(c[e+852>>2]|0,e|0),i=o,o=0,i&1):0))k=10;do if((k|0)==10?(k=0,o=0,f=ma(c[(c[105]|0)+(c[101]<<5)+12>>2]|0,c[102]|0)|0,i=o,o=0,!(i&1)):0){if(!f){k=16;break a}d=c[103]|0;if((c[d+236>>2]|0)==6){o=0;oa(4);i=o;o=0;if(i&1)break;else{k=15;break a}}else{o=0;ja(c[d+852>>2]|0,d|0);i=o;o=0;if(i&1)break;else{k=15;break a}}}while(0);d=kb(8,0)|0;i=D;i=(i|0)==(Ic(8)|0);d=ec(d|0)|0;if(!i){k=9;break}d=c[d>>2]|0;switch(d|0){case 0:{d=4;k=34;break a}case 43:{k=33;break a}case 42:break;default:{k=17;break a}}cc()}if((k|0)==9){c[(c[103]|0)+776>>2]=1;cc();k=5;return k|0}else if((k|0)==15)if((c[(c[103]|0)+236>>2]|0)==4){k=4;return k|0}else k=16;else if((k|0)==17){i=c[103]|0;c[i+776>>2]=d;c[i+236>>2]=5;if((b[(c[i+24>>2]|0)+24>>1]|0)==2){h=Ce(c[99]|0)|0;e=c[(c[103]|0)+24>>2]|0;i=e+24|0;c[e+36>>2]=0;e=c[109]|0;b:do if((e|0)>18){g=18;while(1){f=c[105]|0;if((b[f+(g<<5)+2>>1]&2)!=0?(j=c[f+(g<<5)+28>>2]|0,(j|0)!=0):0){o=0;e=pa(j|0,2,d|0,h|0,i|0)|0;f=o;o=0;if(f&1)break;if(e)break b;e=c[109]|0}g=g+1|0;if((g|0)>=(e|0)){k=25;break b}}k=kb()|0;cc();qb(k|0)}else k=25;while(0);if((k|0)==25?(o=0,na(2,i|0,d|0,h|0),k=o,o=0,k&1):0){k=kb()|0;cc();qb(k|0)}if((c[(c[103]|0)+236>>2]|0)==5)d=5;else{c[a>>2]=0;d=0}cc();k=d;return k|0}else{d=5;k=34}}else if((k|0)==33){d=10;k=34}if((k|0)==16){k=0;return k|0}else if((k|0)==34){cc();c[(c[103]|0)+236>>2]=d;k=d;return k|0}return 0}function We(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;l=i;i=i+32|0;k=l;j=c[103]|0;c[j+32>>2]=c[a+12>>2];c[j+36>>2]=d;c[j+40>>2]=f;h=a+2|0;f=b[h>>1]|0;if(!(f<<16>>16)){f=c[a+16>>2]|0;g=j+236|0;if((c[g>>2]|0)==4)f=0;else{c[99]=f;d=f+2|0;c[98]=d;m=b[f>>1]|0;b[12328]=m;n=m&65535;c[100]=n&24576;c[101]=n&4095;if(m<<16>>16<0){c[102]=(e[f+4>>1]|0)<<16|(e[d>>1]|0);c[98]=f+6}else{c[98]=f+4;c[102]=e[d>>1]}c[g>>2]=0;f=b[h>>1]|0}c[g>>2]=7}if(f<<16>>16!=1){i=l;return}n=c[99]|0;c[98]=n;g=c[a+16>>2]|0;c[98]=n;c[k+4>>2]=n;n=j+256|0;f=c[n>>2]|0;c[n>>2]=f+1;c[k>>2]=f;c[k+12>>2]=c[j+828>>2];c[k+8>>2]=0;yi(256,k,20);f=(c[103]|0)+236|0;if((c[f>>2]|0)!=4){c[99]=g;d=g+2|0;c[98]=d;n=b[g>>1]|0;b[12328]=n;m=n&65535;c[100]=m&24576;c[101]=m&4095;if(n<<16>>16<0){c[102]=(e[g+4>>1]|0)<<16|(e[d>>1]|0);c[98]=g+6}else{c[98]=g+4;c[102]=e[d>>1]}c[f>>2]=0}if((c[f>>2]|0)==4){i=l;return}c[f>>2]=0;i=l;return}function Xe(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[(c[103]|0)+24>>2]|0;b[g+(a*24|0)>>1]=2;b[g+(a*24|0)+2>>1]=d;c[g+(a*24|0)+16>>2]=f;c[g+(a*24|0)+4>>2]=e;return}function Ye(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[103]|0;h=c[e+28>>2]|0;if((h|0)<=0){d=0;return d|0}f=c[e+24>>2]|0;g=0;while(1){e=f+(g*24|0)|0;if((((b[e>>1]|0)!=0?(c[f+(g*24|0)+4>>2]|0)==(d|0):0)?(c[f+(g*24|0)+8>>2]|0)==(a|0):0)?(b[f+(g*24|0)+2>>1]|0)!=2:0){f=8;break}g=g+1|0;if((g|0)>=(h|0)){e=0;f=8;break}}if((f|0)==8)return e|0;return 0}function Ze(a){a=a|0;var d=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+40|0;c[k>>2]=0;l=a+38|0;b[l>>1]=0;if(!((c[101]|0)==0&(c[102]|0)==40))return;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;j=b[d>>1]|0;b[12328]=j;i=j&65535;c[100]=i&24576;c[101]=i&4095;if(j<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}d=a+44|0;while(1){f=b[l>>1]|0;g=c[k>>2]|0;h=c[d>>2]|0;i=_d()|0;if((i|0)<-1){d=7;break}j=c[97]|0;if((b[j>>1]|0)!=4){d=9;break}b[l>>1]=f;c[k>>2]=g;c[d>>2]=h;bg(a,c[c[j+28>>2]>>2]|0);if((i|0)==-1){d=11;break}}if((d|0)==7){a=Rb(4)|0;c[a>>2]=25;ad(a|0,8,0)}else if((d|0)==9){a=Rb(4)|0;c[a>>2]=6;ad(a|0,8,0)}else if((d|0)==11){d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;a=b[d>>1]|0;b[12328]=a;l=a&65535;c[100]=l&24576;c[101]=l&4095;if(a<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6;return}else{c[98]=d+4;c[102]=e[f>>1];return}}}function _e(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;do switch(d|0){case 0:{qd[c[a+76>>2]&63](b,e);return}case 1:{qd[c[a+80>>2]&63](b,e);return}case 2:{qd[c[a+84>>2]&63](b,e);return}case 3:{qd[c[a+88>>2]&63](b,e);return}case 4:{qd[c[a+92>>2]&63](b,e);return}case 5:{qd[c[a+96>>2]&63](b,e);return}case 6:{qd[c[a+100>>2]&63](b,e);return}case 7:{qd[c[a+104>>2]&63](b,e);return}case 8:{qd[c[a+108>>2]&63](b,e);return}case 9:{qd[c[a+112>>2]&63](b,e);return}case 10:{qd[c[a+116>>2]&63](b,e);return}case 11:{qd[c[a+120>>2]&63](b,e);return}case 12:{qd[c[a+124>>2]&63](b,e);return}case 13:{qd[c[a+128>>2]&63](b,e);return}case 14:{qd[c[a+132>>2]&63](b,e);return}case 15:{qd[c[a+136>>2]&63](b,e);return}case 40:{b=Rb(4)|0;c[b>>2]=34;ad(b|0,8,0)}default:{b=Rb(4)|0;c[b>>2]=4;ad(b|0,8,0)}}while(0)}function $e(a){a=a|0;var d=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;j=(b[a+36>>1]&16)==0;l=a+40|0;c[l>>2]=0;k=a+38|0;b[k>>1]=0;if(!j){c[184]=0;if(!((c[101]|0)==0&(c[102]|0)==40)){l=c[l>>2]|0;return l|0}d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;k=b[d>>1]|0;b[12328]=k;j=k&65535;c[100]=j&24576;c[101]=j&4095;if(k<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}od[c[(c[3356>>2]|0)+((b[a>>1]<<16>>16)*140|0)+36>>2]&63](a);c[184]=1;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;a=b[d>>1]|0;b[12328]=a;k=a&65535;c[100]=k&24576;c[101]=k&4095;if(a<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6;l=c[l>>2]|0;return l|0}else{c[98]=d+4;c[102]=e[f>>1];l=c[l>>2]|0;return l|0}}if(!((c[101]|0)==0&(c[102]|0)==40)){l=c[l>>2]|0;return l|0}d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;j=b[d>>1]|0;b[12328]=j;i=j&65535;c[100]=i&24576;c[101]=i&4095;if(j<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}d=a+44|0;while(1){f=b[k>>1]|0;g=c[l>>2]|0;h=c[d>>2]|0;i=_d()|0;if((i|0)<-1){d=15;break}j=c[97]|0;if((b[j>>1]|0)!=4){d=17;break}b[k>>1]=f;c[l>>2]=g;c[d>>2]=h;of(a,c[c[j+28>>2]>>2]|0);if((i|0)==-1){d=19;break}}if((d|0)==15){l=Rb(4)|0;c[l>>2]=25;ad(l|0,8,0)}else if((d|0)==17){l=Rb(4)|0;c[l>>2]=6;ad(l|0,8,0)}else if((d|0)==19){d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;a=b[d>>1]|0;b[12328]=a;k=a&65535;c[100]=k&24576;c[101]=k&4095;if(a<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6;l=c[l>>2]|0;return l|0}else{c[98]=d+4;c[102]=e[f>>1];l=c[l>>2]|0;return l|0}}return 0}function af(a){a=a|0;var d=0,f=0,g=0,h=0,i=0,j=0;h=c[(c[103]|0)+840>>2]|0;f=h+(a*28|0)|0;d=Ai(257,(c[h+(a*28|0)+16>>2]|0)+20|0)|0;j=d+20|0;oe(j,f,0);c[d+12>>2]=c[(c[103]|0)+828>>2];c[(c[103]|0)+828>>2]=j;c[d+4>>2]=c[99];j=(c[103]|0)+256|0;i=c[j>>2]|0;c[j>>2]=i+1;c[d>>2]=i;c[d+8>>2]=f;d=c[103]|0;f=c[d+8>>2]|0;a=c[(c[d+20>>2]|0)+(c[h+(a*28|0)+20>>2]<<2)>>2]|0;h=f+(a<<1)|0;c[99]=h;d=f+(a+1<<1)|0;c[98]=d;h=b[h>>1]|0;b[12328]=h;i=h&65535;c[100]=i&24576;c[101]=i&4095;if(h<<16>>16<0){c[102]=(e[f+(a+2<<1)>>1]|0)<<16|(e[d>>1]|0);c[98]=f+(a+3<<1)}else{c[98]=f+(a+2<<1);c[102]=e[d>>1]}a:while(1){if((c[163]|0)!=0?(i=c[165]|0,h=c[99]|0,j=c[98]|0,c[99]=j,j=Ce(j)|0,c[165]=j,g=c[103]|0,c[166]=(c[g+12>>2]|0)+(c[111]|0),c[99]=h,(i|0)!=(j|0)):0){c[g+236>>2]=3;od[c[g+852>>2]&63](g)}if(!(rd[c[(c[420>>2]|0)+(c[404>>2]<<5)+12>>2]&63](c[102]|0)|0))continue;a=c[103]|0;switch(c[a+236>>2]|0){case 4:{a=9;break a}case 6:{a=10;break a}default:{}}od[c[a+852>>2]&63](a)}if((a|0)==9){j=Rb(4)|0;c[j>>2]=0;ad(j|0,8,0)}else if((a|0)==10){nf();return}}function bf(a){a=a|0;var d=0,f=0,g=0,h=0;if(!(c[100]&8192)){f=Rb(4)|0;c[f>>2]=16;ad(f|0,8,0)}f=c[101]|0;a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;g=b[a>>1]|0;b[12328]=g;h=g&65535;c[100]=h&24576;c[101]=h&4095;if(g<<16>>16<0){c[102]=(e[a+4>>1]|0)<<16|(e[d>>1]|0);c[98]=a+6}else{c[98]=a+4;c[102]=e[d>>1]}a=Rb(4)|0;switch(f|0){case 10:case 13:{c[a>>2]=41;ad(a|0,8,0)}default:{c[a>>2]=18;ad(a|0,8,0)}}return 0}function cf(){var a=0,d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;h=he(384)|0;e=c[96]|0;a=b[e>>1]|0;g=c[839]|0;f=c[g+(a*140|0)+64>>2]|0;c[e+40>>2]=h;a=rd[c[g+(a*140|0)+28>>2]&63](e)|0;a=jd[f&15](e,a,d)|0;c[(c[103]|0)+64>>2]=384;i=d;return a|0}function df(a,d,e){a=a|0;d=d|0;e=e|0;c[a+40>>2]=0;e=rd[c[(c[3356>>2]|0)+((b[a>>1]<<16>>16)*140|0)+28>>2]&63](a)|0;sd[c[(c[3356>>2]|0)+((b[a>>1]<<16>>16)*140|0)+68>>2]&15](a,e,d);return 0}function ef(a){a=a|0;return (c[839]|0)+(a*140|0)|0}function ff(){c[(c[103]|0)+64>>2]=388;return _d()|0}function gf(a){a=a|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;g=p+4|0;k=p;if(!(c[100]&8192)){p=Rb(4)|0;c[p>>2]=16;ad(p|0,8,0)}c[100]=0;o=he(g)|0;if(c[101]|0){c[98]=c[99];p=Rb(4)|0;c[p>>2]=2;ad(p|0,8,0)}n=c[102]|0;a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;m=b[a>>1]|0;b[12328]=m;l=m&65535;f=l&24576;c[100]=f;c[101]=l&4095;if(m<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6}else{c[98]=a+4;c[102]=e[d>>1]}if(f){a=c[g>>2]|0;m=b[a>>1]|0;h=m<<16>>16;j=c[839]|0;c[k>>2]=1;if(m<<16>>16==4){d=4;f=j;g=k}else{g=wd[c[j+(h*140|0)+20>>2]&31](k,4)|0;d=b[a>>1]|0;f=c[839]|0}c[a+40>>2]=o;a=rd[c[f+((d<<16>>16)*140|0)+28>>2]&63](a)|0;switch(n|0){case 0:{qd[c[j+(h*140|0)+76>>2]&63](a,g);i=p;return 0}case 1:{qd[c[j+(h*140|0)+80>>2]&63](a,g);i=p;return 0}default:{p=Rb(4)|0;c[p>>2]=2;ad(p|0,8,0)}}}if(_d()|0){p=Rb(4)|0;c[p>>2]=2;ad(p|0,8,0)}m=c[g>>2]|0;g=b[m>>1]|0;h=c[839]|0;a=h+(g*140|0)|0;l=m+40|0;c[l>>2]=o;j=rd[c[h+(g*140|0)+28>>2]&63](m)|0;f=c[97]|0;k=c[f+28>>2]|0;if((n|0)!=8){d=b[m>>1]|0;if(d<<16>>16==(b[f>>1]|0))d=k;else d=$f(f,d<<16>>16)|0;_e(a,j,n,d);if((b[h+(g*140|0)+2>>1]|0)==(b[m>>1]|0)){i=p;return 0}else{p=Rb(4)|0;c[p>>2]=6;ad(p|0,8,0)}}if((c[184]|0)!=0?(b[m+36>>1]&64)!=0:0){sd[c[h+(g*140|0)+40>>2]&15](m,k,b[f>>1]|0);i=p;return 0}n=b[f>>1]|0;d=n<<16>>16;do if((b[m>>1]|0)!=n<<16>>16)if(!o){Zf(m,d);a=b[m>>1]|0;n=c[839]|0;d=rd[c[n+(a*140|0)+28>>2]&63](m)|0;a=n+(a*140|0)|0;break}else{p=Rb(4)|0;c[p>>2]=31;ad(p|0,8,0)}else d=j;while(0);h=a+72|0;sd[c[h>>2]&15](m,d,k);if(c[100]|0){i=p;return 0}a=c[m+8>>2]|0;if(!a)a=o;else a=(o|0)%(a|0)|0;f=o-a|0;g=m+38|0;d=a;while(1){if(_d()|0){a=30;break}a=c[97]|0;if((b[m>>1]|0)!=(b[a>>1]|0)){a=32;break}o=c[a+28>>2]|0;d=d+1|0;b[g>>1]=0;c[l>>2]=f;of(m,d);n=rd[c[(c[3356>>2]|0)+((b[m>>1]<<16>>16)*140|0)+28>>2]&63](m)|0;sd[c[h>>2]&15](m,n,o);if(c[100]|0){a=38;break}}if((a|0)==30){p=Rb(4)|0;c[p>>2]=2;ad(p|0,8,0)}else if((a|0)==32){p=Rb(4)|0;c[p>>2]=31;ad(p|0,8,0)}else if((a|0)==38){i=p;return 0}return 0}function hf(a){a=a|0;var d=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;q=i;i=i+48|0;p=q+24|0;g=q+20|0;j=q+16|0;k=q+12|0;l=q+8|0;m=q+4|0;n=q;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;r=b[d>>1]|0;b[12328]=r;s=r&65535;c[100]=s&24576;c[101]=s&4095;if(r<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}a:do switch(a|0){case 0:{d=je()|0;c[99]=d;f=d+2|0;c[98]=f;s=b[d>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6;s=0;i=q;return s|0}else{c[98]=d+4;c[102]=e[f>>1];s=0;i=q;return s|0}}case 1:{g=je()|0;c[p+4>>2]=c[98];d=c[103]|0;r=d+256|0;s=c[r>>2]|0;c[r>>2]=s+1;c[p>>2]=s;c[p+12>>2]=c[d+828>>2];c[p+8>>2]=0;yi(256,p,20);d=(c[103]|0)+236|0;if((c[d>>2]|0)!=4){c[99]=g;f=g+2|0;c[98]=f;s=b[g>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[g+4>>1]<<16|e[f>>1];c[98]=g+6}else{c[98]=g+4;c[102]=e[f>>1]}c[d>>2]=0}s=0;i=q;return s|0}case 2:{b:do if((c[(c[103]|0)+828>>2]|0)!=0?(_d()|0)>=-1:0){d=c[103]|0;c[d+844>>2]=c[d+256>>2];f=c[97]|0;s=b[f>>1]|0;c[178]=s;switch(s|0){case 4:{c[d+784>>2]=c[c[f+28>>2]>>2];break b}case 2:{Ji(d+792|0,c[f+28>>2]|0);break b}case 3:{h[d+864>>3]=+h[c[f+28>>2]>>3];break b}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[(c[103]|0)+236>>2]=6;s=6;i=q;return s|0}case 3:{d=(c[103]|0)+772|0;f=c[d>>2]|0;if(!f){s=Rb(4)|0;c[s>>2]=11;ad(s|0,8,0)}c[d>>2]=f+-1;d=je()|0;c[99]=d;f=d+2|0;c[98]=f;s=b[d>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6;s=0;i=q;return s|0}else{c[98]=d+4;c[102]=e[f>>1];s=0;i=q;return s|0}}case 4:{if((c[(c[103]|0)+772>>2]|0)>30){s=Rb(4)|0;c[s>>2]=9;ad(s|0,8,0)}g=je()|0;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;s=b[d>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}c:do if((_d()|0)<-1)d=-2147483648;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break c}case 3:{d=~~+h[c[d+28>>2]>>3];break c}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[180]=d;d:do if((_d()|0)<-1)d=0;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break d}case 3:{d=~~+h[c[d+28>>2]>>3];break d}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[181]=d;f=c[180]|0;if(f){c[180]=(f|0)<0?-2147483648:f+d|0;r=c[103]|0;p=r+772|0;s=(c[p>>2]|0)+1|0;c[p>>2]=s;c[r+260+(s<<4)+4>>2]=c[181];c[r+260+(s<<4)>>2]=c[180];c[r+260+(s<<4)+12>>2]=c[99];s=0;i=q;return s|0}c[99]=g;d=g+2|0;c[98]=d;s=b[g>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[g+4>>1]<<16|e[d>>1];c[98]=g+6;s=0;i=q;return s|0}else{c[98]=g+4;c[102]=e[d>>1];s=0;i=q;return s|0}}case 5:{d=c[103]|0;f=d+772|0;g=c[f>>2]|0;if(!g){s=Rb(4)|0;c[s>>2]=11;ad(s|0,8,0)}s=d+260+(g<<4)+4|0;r=(c[s>>2]|0)+1|0;c[s>>2]=r;s=c[d+260+(g<<4)>>2]|0;if(!((s|0)==-2147483648|(r|0)<(s|0))){c[f>>2]=g+-1;s=0;i=q;return s|0}d=c[d+260+(g<<4)+12>>2]|0;c[99]=d;f=d+2|0;c[98]=f;s=b[d>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6;s=0;i=q;return s|0}else{c[98]=d+4;c[102]=e[f>>1];s=0;i=q;return s|0}}case 6:{k=je()|0;f=c[103]|0;g=c[f+772>>2]|0;d=c[98]|0;c[99]=d;j=d+2|0;c[98]=j;s=b[d>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[j>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[j>>1]}f=f+260+(g<<4)+4|0;d=(c[f>>2]|0)+1|0;c[181]=d;e:do if((_d()|0)>=-1){d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break e}case 3:{d=~~+h[c[d+28>>2]>>3];break e}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[180]=d;c[f>>2]=d+-1;c[98]=k;c[102]=5;c[101]=15;c[100]=0;s=0;i=q;return s|0}case 7:{f:do if((_d()|0)<-1)d=100;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break f}case 3:{d=~~+h[c[d+28>>2]>>3];break f}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);s=c[103]|0;c[s+240>>2]=d;c[s+236>>2]=1;s=1;i=q;return s|0}case 8:{g:do if((_d()|0)<-1)d=0;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break g}case 3:{d=~~+h[c[d+28>>2]>>3];break g}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[180]=d;s=c[103]|0;c[s+240>>2]=d;c[s+248>>2]=-1;c[s+236>>2]=2;s=2;i=q;return s|0}case 13:case 10:case 9:{if(he(p)|0){s=Rb(4)|0;c[s>>2]=25;ad(s|0,8,0)}g=c[p>>2]|0;if((a|0)==13){if((_d()|0)<-1){s=Rb(4)|0;c[s>>2]=5;ad(s|0,8,0)}d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}if(!(b[(c[839]|0)+(d*140|0)>>1]|0)){s=Rb(4)|0;c[s>>2]=3;ad(s|0,8,0)}}else d=4;h:do if((_d()|0)<-1)f=0;else{f=c[97]|0;switch(b[f>>1]|0){case 4:{f=c[c[f+28>>2]>>2]|0;break h}case 3:{f=~~+h[c[f+28>>2]>>3];break h}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[180]=f;i:do if((_d()|0)<-1)f=0;else{f=c[97]|0;switch(b[f>>1]|0){case 4:{f=c[c[f+28>>2]>>2]|0;break i}case 3:{f=~~+h[c[f+28>>2]>>3];break i}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[181]=f;j:do if((_d()|0)<-1)f=0;else{f=c[97]|0;switch(b[f>>1]|0){case 4:{f=c[c[f+28>>2]>>2]|0;break j}case 3:{f=~~+h[c[f+28>>2]>>3];break j}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[182]=f;k:do if((_d()|0)<-1)f=0;else{f=c[97]|0;switch(b[f>>1]|0){case 4:{f=c[c[f+28>>2]>>2]|0;break k}case 3:{f=~~+h[c[f+28>>2]>>3];break k}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[183]=f;if((a|0)!=10){Wf(g,d,c[180]|0,c[181]|0,c[182]|0,f);s=0;i=q;return s|0}l:do if((_d()|0)<-1)d=0;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break l}case 3:{d=~~+h[c[d+28>>2]>>3];break l}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);Xf(g,2,c[180]|0,c[181]|0,c[182]|0,c[183]|0,d);s=0;i=q;return s|0}case 11:{if((c[(c[103]|0)+772>>2]|0)>30){s=Rb(4)|0;c[s>>2]=9;ad(s|0,8,0)}je()|0;f=c[98]|0;c[99]=f;d=f;g=d+2|0;c[98]=g;s=b[d>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[g>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[g>>1]}r=c[103]|0;p=r+772|0;s=(c[p>>2]|0)+1|0;c[p>>2]=s;c[r+260+(s<<4)+4>>2]=0;c[r+260+(s<<4)>>2]=-2147483648;c[r+260+(s<<4)+12>>2]=f;s=0;i=q;return s|0}case 12:{if(!(c[(c[103]|0)+772>>2]|0)){s=Rb(4)|0;c[s>>2]=11;ad(s|0,8,0)}j=je()|0;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;s=b[d>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}d=c[103]|0;f=c[d+772>>2]|0;if(he(p)|0){s=Rb(4)|0;c[s>>2]=25;ad(s|0,8,0)}g=c[p>>2]|0;d=c[d+260+(f<<4)+4>>2]|0;if((d|0)>=(c[g+8>>2]|0)){d=(c[103]|0)+772|0;c[d>>2]=(c[d>>2]|0)+-1;c[99]=j;d=j+2|0;c[98]=d;s=b[j>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[j+4>>1]<<16|e[d>>1];c[98]=j+6;s=0;i=q;return s|0}else{c[98]=j+4;c[102]=e[d>>1];s=0;i=q;return s|0}}if(!(b[g+36>>1]&128)){s=0;i=q;return s|0}s=b[g>>1]|0;p=c[839]|0;r=c[p+(s*140|0)+60>>2]|0;c[g+40>>2]=d;s=rd[c[p+(s*140|0)+28>>2]&63](g)|0;if(rd[r&63](s)|0){s=0;i=q;return s|0}c[98]=j;c[102]=5;c[101]=15;c[100]=0;s=0;i=q;return s|0}case 14:{if(he(p)|0){s=Rb(4)|0;c[s>>2]=25;ad(s|0,8,0)}r=c[p>>2]|0;s=he(g)|0;Vf(r,c[g>>2]|0,s);s=0;i=q;return s|0}case 15:{if(he(p)|0){s=Rb(4)|0;c[s>>2]=25;ad(s|0,8,0)}g=c[p>>2]|0;if((_d()|0)<-1){s=Rb(4)|0;c[s>>2]=5;ad(s|0,8,0)}d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}c[180]=d;if((_d()|0)<-1){s=Rb(4)|0;c[s>>2]=5;ad(s|0,8,0)}d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}c[181]=d;m:do if((_d()|0)<-1)d=4;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break m}case 3:{d=~~+h[c[d+28>>2]>>3];break m}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[182]=d;f=c[181]|0;if((f|0)<1){s=Rb(4)|0;c[s>>2]=3;ad(s|0,8,0)}if(!(b[(c[839]|0)+(d*140|0)>>1]|0)){s=Rb(4)|0;c[s>>2]=3;ad(s|0,8,0)}Uf(g,d,c[180]|0,f);s=0;i=q;return s|0}case 16:{n:do if((_d()|0)<-1)d=0;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break n}case 3:{d=~~+h[c[d+28>>2]>>3];break n}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);s=c[103]|0;c[s+848>>2]=d;c[s+236>>2]=4;s=4;i=q;return s|0}case 27:{if((_d()|0)>=-1){d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}c[180]=d;if(d){s=0;i=q;return s|0}}else c[180]=0;c[(c[103]|0)+236>>2]=8;s=8;i=q;return s|0}case 17:{c[(c[103]|0)+236>>2]=3;s=3;i=q;return s|0}case 20:{f=he(k)|0;d=c[k>>2]|0;if((b[d>>1]|0)!=5){s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}pe(d,f);s=0;i=q;return s|0}case 22:{if(he(p)|0){s=Rb(4)|0;c[s>>2]=25;ad(s|0,8,0)}g=c[p>>2]|0;if((_d()|0)<-1){s=Rb(4)|0;c[s>>2]=5;ad(s|0,8,0)}d=c[97]|0;switch(b[d>>1]|0){case 4:{f=c[c[d+28>>2]>>2]|0;break}case 3:{f=~~+h[c[d+28>>2]>>3];break}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}c[180]=f;if(f&1024){s=Rb(4)|0;c[s>>2]=21;ad(s|0,8,0)}if((f|0)>63){d=c[(c[(c[103]|0)+876>>2]|0)+172>>2]|0;if(!d){s=0;i=q;return s|0}qd[d&63](g,f);s=0;i=q;return s|0}if((f|0)>7|(f&48|0)!=0){s=Rb(4)|0;c[s>>2]=21;ad(s|0,8,0)}d=c[(c[103]|0)+828>>2]|0;if(!d){s=Rb(4)|0;c[s>>2]=3;ad(s|0,8,0)}Uf(g,4,d+(f<<2)|0,4);s=0;i=q;return s|0}case 23:{d=(c[103]|0)+792|0;if((_d()|0)<-1){s=Rb(4)|0;c[s>>2]=5;ad(s|0,8,0)}f=c[97]|0;if((b[f>>1]|0)!=2){s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}Ji(d,c[f+28>>2]|0);do if((_d()|0)>=-1){d=c[97]|0;if((b[d>>1]|0)==2){d=c[d+28>>2]|0;break}else{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}else d=30178;while(0);f=Mn(d)|0;if((f|0)<=1023){s=c[103]|0;s=s+824|0;s=c[s>>2]|0;Kn(s,d)|0;s=Rb(4)|0;c[s>>2]=43;ad(s|0,8,0)}s=Ii(c[(c[103]|0)+824>>2]|0,f+1|0)|0;c[(c[103]|0)+824>>2]=s;s=c[103]|0;s=s+824|0;s=c[s>>2]|0;Kn(s,d)|0;s=Rb(4)|0;c[s>>2]=43;ad(s|0,8,0)}case 24:{f=he(l)|0;d=c[l>>2]|0;if((b[d>>1]|0)!=4){s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}c[d+40>>2]=f;k=rd[c[(c[3356>>2]|0)+588>>2]&63](d)|0;o:do if((_d()|0)<-1)d=0;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break o}case 3:{d=~~+h[c[d+28>>2]>>3];break o}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[180]=d;p:do if((_d()|0)<-1)d=0;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break p}case 3:{d=~~+h[c[d+28>>2]>>3];break p}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[181]=d;j=je()|0;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;s=b[d>>1]|0;b[12328]=s;g=s&65535;c[100]=g&24576;c[101]=g&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}c[100]=g&8192;r=c[k>>2]|0;s=c[181]|0;if((c[180]|0)>-1?(r|0)<(s|0):(r|0)>(s|0)){s=0;i=q;return s|0}d=(c[103]|0)+236|0;if((c[d>>2]|0)==4){s=0;i=q;return s|0}c[99]=j;f=j+2|0;c[98]=f;s=b[j>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[j+4>>1]<<16|e[f>>1];c[98]=j+6}else{c[98]=j+4;c[102]=e[f>>1]}c[d>>2]=0;s=0;i=q;return s|0}case 25:{q:do if((_d()|0)<-1)d=0;else{d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break q}case 3:{d=~~+h[c[d+28>>2]>>3];break q}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}}while(0);c[180]=d;if((c[101]|0)!=15){s=Rb(4)|0;c[s>>2]=2;ad(s|0,8,0)}d=c[102]|0;if((d|0)>1){s=Rb(4)|0;c[s>>2]=2;ad(s|0,8,0)}c[181]=0;c[182]=d;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;s=b[d>>1]|0;b[12328]=s;g=s&65535;c[100]=g&24576;c[101]=g&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}if(!(g&8192))g=0;else{s=0;i=q;return s|0}do{l=je()|0;d=c[98]|0;c[99]=d;f=d;j=f+2|0;c[98]=j;s=b[f>>1]|0;b[12328]=s;k=s&65535;c[100]=k&24576;c[101]=k&4095;if(s<<16>>16<0){c[102]=e[f+4>>1]<<16|e[j>>1];c[98]=f+6}else{c[98]=f+4;c[102]=e[j>>1]}f=k&8192;c[100]=f;j=c[181]|0;if((c[180]|0)==(j|0))if(!(c[182]|0)){k=l;o=263;break}else g=l;c[181]=j+1}while((f|0)==0);if((o|0)==263){j=(c[103]|0)+236|0;if((c[j>>2]|0)!=4){d=k;c[99]=d;f=k+2|0;c[98]=f;s=b[k>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[k+4>>1]<<16|e[f>>1];c[98]=k+6}else{c[98]=k+4;c[102]=e[f>>1]}c[j>>2]=0}}if(!g){s=0;i=q;return s|0}c[98]=d;c[p+4>>2]=d;d=c[103]|0;r=d+256|0;s=c[r>>2]|0;c[r>>2]=s+1;c[p>>2]=s;c[p+12>>2]=c[d+828>>2];c[p+8>>2]=0;yi(256,p,20);d=(c[103]|0)+236|0;if((c[d>>2]|0)!=4){c[99]=g;f=g+2|0;c[98]=f;s=b[g>>1]|0;b[12328]=s;r=s&65535;c[100]=r&24576;c[101]=r&4095;if(s<<16>>16<0){c[102]=e[g+4>>1]<<16|e[f>>1];c[98]=g+6}else{c[98]=g+4;c[102]=e[f>>1]}c[d>>2]=0}if((c[d>>2]|0)==4){s=4;i=q;return s|0}c[d>>2]=0;s=0;i=q;return s|0}case 26:{if(he(p)|0){s=Rb(4)|0;c[s>>2]=25;ad(s|0,8,0)}s=c[p>>2]|0;od[c[(c[3356>>2]|0)+((b[s>>1]<<16>>16)*140|0)+44>>2]&63](s);s=0;i=q;return s|0}case 28:{if((_d()|0)<-1){s=Rb(4)|0;c[s>>2]=5;ad(s|0,8,0)}d=c[97]|0;if((b[d>>1]|0)!=2){s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}d=c[d+28>>2]|0;f=Mn(d)|0;if((f|0)>1023){s=Ii(c[(c[103]|0)+824>>2]|0,f+1|0)|0;c[(c[103]|0)+824>>2]=s}Kn(c[(c[103]|0)+824>>2]|0,d)|0;c[(c[103]|0)+236>>2]=9;s=9;i=q;return s|0}case 29:{k=he(m)|0;c[n>>2]=0;r:do switch(c[101]|0){case 4:{if((_d()|0)<-1){s=Rb(4)|0;c[s>>2]=5;ad(s|0,8,0)}d=c[97]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}switch(d|0){case 0:{c[n>>2]=c[99];break r}case 1:{c[n>>2]=c[98];break r}default:break r}}case 7:{f=je()|0;d=c[98]|0;c[99]=d;g=d+2|0;c[98]=g;s=b[d>>1]|0;b[12328]=s;j=s&65535;c[100]=j&24576;c[101]=j&4095;if(s<<16>>16<0){c[102]=e[d+4>>1]<<16|e[g>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[g>>1]}c[100]=j&8192;c[n>>2]=f;break}default:{s=Rb(4)|0;c[s>>2]=6;ad(s|0,8,0)}}while(0);d=c[m>>2]|0;c[d+40>>2]=k;f=c[839]|0;do if((b[d>>1]|0)!=1)if(!k){Zf(d,1);break}else{s=Rb(4)|0;c[s>>2]=31;ad(s|0,8,0)}while(0);r=c[f+212>>2]|0;s=rd[c[f+168>>2]&63](d)|0;sd[r&15](d,s,n);s=0;i=q;return s|0}case 18:{if(he(p)|0){s=Rb(4)|0;c[s>>2]=25;ad(s|0,8,0)}f=c[p>>2]|0;c[j>>2]=f;g=f;if((b[f>>1]|0)==5){d=c[f+28>>2]|0;j=c[f+8>>2]|0;if((j|0)>0){k=0;do{if(!(b[d+(k<<4)>>1]|0))break a;k=k+1|0}while((k|0)<(j|0))}Yf(f,1,j+1|0);k=j}else k=0;break}case 19:{k=he(j)|0;g=c[j>>2]|0;f=g;break}case 30:case 31:{s=0;i=q;return s|0}default:{s=Rb(4)|0;c[s>>2]=21;ad(s|0,8,0)}}while(0);m=le()|0;d=c[m+16>>2]|0;l=m+4|0;b[p+4>>1]=c[l>>2];b[p+6>>1]=0;c[p+8>>2]=d;c[p+12>>2]=0;d=f+40|0;c[d>>2]=k;j=c[839]|0;do if((b[f>>1]|0)!=5)if(!k){Zf(f,5);break}else{s=Rb(4)|0;c[s>>2]=31;ad(s|0,8,0)}while(0);s=c[j+772>>2]|0;j=rd[c[j+728>>2]&63](f)|0;sd[s&15](f,j,p);c[d>>2]=k;f=rd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0;b[f>>1]=1;d=Fi(c[f+8>>2]|0)|0;c[f+12>>2]=d;f=c[l>>2]|0;j=c[(c[103]|0)+836>>2]|0;if((b[j+(f<<3)>>1]|0)!=-5){s=Rb(4)|0;c[s>>2]=35;ad(s|0,8,0)}oe(d,m,0);d=c[j+(f<<3)+4>>2]|0;if((d|0)==-1){s=0;i=q;return s|0}b[213]=21930;b[212]=b[j+(f<<3)+2>>1]|0;c[107]=g;c[108]=k;af(d);s=0;i=q;return s|0}function jf(a){a=a|0;var d=0,f=0,g=0,i=0,j=0;f=c[98]|0;g=e[f>>1]|0;a=f+2|0;c[98]=a;i=f+(g+1<<1)|0;if(!(c[102]|0)){c[99]=a;d=f+4|0;c[98]=d;a=b[a>>1]|0;b[12328]=a;j=a&65535;c[100]=j&24576;c[101]=j&4095;if(a<<16>>16<0){c[102]=e[f+6>>1]<<16|e[d>>1];c[98]=f+8}else{c[98]=f+6;c[102]=e[d>>1]}if((_d()|0)<-1){j=Rb(4)|0;c[j>>2]=5;ad(j|0,8,0)}a=c[97]|0;switch(b[a>>1]|0){case 4:{a=c[c[a+28>>2]>>2]|0;break}case 3:{a=~~+h[c[a+28>>2]>>3];break}default:{j=Rb(4)|0;c[j>>2]=6;ad(j|0,8,0)}}if(a)return 0}c[99]=i;a=f+(g+2<<1)|0;c[98]=a;j=b[i>>1]|0;b[12328]=j;i=j&65535;c[100]=i&24576;c[101]=i&4095;if(j<<16>>16<0){c[102]=e[f+(g+3<<1)>>1]<<16|e[a>>1];c[98]=f+(g+4<<1);return 0}else{c[98]=f+(g+3<<1);c[102]=e[a>>1];return 0}return 0}function kf(a,b){a=a|0;b=b|0;c[a>>2]=4;do switch(b|0){case 0:{c[179]=0;a=716;return a|0}case 1:{c[179]=c[(c[103]|0)+780>>2];a=716;return a|0}case 2:{c[179]=13571;a=716;return a|0}case 3:{c[179]=c[(c[103]|0)+784>>2];a=716;return a|0}case 4:{a=c[103]|0;c[179]=c[a+260+(c[a+772>>2]<<4)+4>>2];a=716;return a|0}case 5:{c[179]=c[(c[103]|0)+776>>2];a=716;return a|0}case 6:{c[179]=c[(c[103]|0)+788>>2];a=716;return a|0}case 7:{c[179]=c[(c[103]|0)+772>>2];a=716;return a|0}case 8:{c[179]=c[(c[103]|0)+256>>2];a=716;return a|0}case 9:{c[179]=c[(c[103]|0)+32>>2];a=716;return a|0}case 10:{c[179]=c[(c[103]|0)+36>>2];a=716;return a|0}case 11:{c[179]=c[(c[103]|0)+40>>2];a=716;return a|0}case 12:{c[a>>2]=2;a=c[(c[103]|0)+792>>2]|0;return a|0}case 13:{c[a>>2]=3;a=(c[103]|0)+864|0;return a|0}default:{a=Rb(4)|0;c[a>>2]=21;ad(a|0,8,0)}}while(0);return 0}function lf(a){a=a|0;var d=0,f=0,g=0,h=0;d=c[98]|0;c[99]=d;f=d+2|0;c[98]=f;g=b[d>>1]|0;b[12328]=g;h=g&65535;c[100]=h&24576;c[101]=h&4095;if(g<<16>>16<0){c[102]=e[d+4>>1]<<16|e[f>>1];c[98]=d+6}else{c[98]=d+4;c[102]=e[f>>1]}if((b[(c[(c[103]|0)+840>>2]|0)+(a*28|0)>>1]|0)==-1){af(a);return 0}else{h=Rb(4)|0;c[h>>2]=2;ad(h|0,8,0)}return 0}function mf(a,d){a=a|0;d=d|0;var f=0,g=0,h=0,i=0,j=0;if((b[(c[(c[103]|0)+840>>2]|0)+(d*28|0)>>1]|0)!=-2){h=Rb(4)|0;c[h>>2]=2;ad(h|0,8,0)}h=c[178]|0;c[178]=-1;if(c[101]|0){h=Rb(4)|0;c[h>>2]=32;ad(h|0,8,0)}if((c[102]|0)!=40){h=Rb(4)|0;c[h>>2]=32;ad(h|0,8,0)}f=c[98]|0;c[99]=f;g=f+2|0;c[98]=g;i=b[f>>1]|0;b[12328]=i;j=i&65535;c[100]=j&24576;c[101]=j&4095;if(i<<16>>16<0){c[102]=e[f+4>>1]<<16|e[g>>1];c[98]=f+6}else{c[98]=f+4;c[102]=e[g>>1]}af(d);c[a>>2]=c[178];switch(c[178]|0){case 2:{d=c[(c[103]|0)+792>>2]|0;break}case 3:{d=(c[103]|0)+864|0;break}case 4:{d=(c[103]|0)+784|0;break}default:{j=(c[(c[103]|0)+236>>2]|0)==4;f=Rb(4)|0;if(j){c[f>>2]=0;ad(f|0,8,0)}else{c[f>>2]=40;ad(f|0,8,0)}}}if(c[101]|0){j=Rb(4)|0;c[j>>2]=32;ad(j|0,8,0)}if((c[102]|0)!=41){j=Rb(4)|0;c[j>>2]=32;ad(j|0,8,0)}f=c[98]|0;c[99]=f;g=f+2|0;c[98]=g;j=b[f>>1]|0;b[12328]=j;i=j&65535;c[100]=i&24576;c[101]=i&4095;if(j<<16>>16<0){c[102]=e[f+4>>1]<<16|e[g>>1];c[98]=f+6;c[178]=h;return d|0}else{c[98]=f+4;c[102]=e[g>>1];c[178]=h;return d|0}return 0}function nf(){var a=0,d=0,f=0,g=0,h=0,i=0;a=c[849]|0;if((a|0)==(c[848]|0)){i=Rb(4)|0;c[i>>2]=10;ad(i|0,8,0)}i=c[a+-76>>2]|0;a:do if((b[a+-80>>1]|0)==257?(d=c[i+8>>2]|0,g=i+20|0,h=d+8|0,(c[h>>2]|0)>0):0){f=0;a=(c[(c[103]|0)+836>>2]|0)+(c[d+4>>2]<<3)|0;while(1){switch(b[a>>1]|0){case -6:{Hi(c[g+(c[a+4>>2]|0)>>2]|0);break}case -1:{d=g+(c[a+4>>2]|0)|0;od[c[(c[3356>>2]|0)+((b[d>>1]<<16>>16)*140|0)+52>>2]&63](d);break}default:{}}f=f+1|0;if((f|0)>=(c[h>>2]|0))break a;else a=a+8|0}}while(0);c[98]=c[i+4>>2];c[(c[103]|0)+828>>2]=c[i+12>>2];a=(c[103]|0)+256|0;c[a>>2]=(c[a>>2]|0)+-1;a=c[98]|0;c[99]=a;d=a+2|0;c[98]=d;i=b[a>>1]|0;b[12328]=i;h=i&65535;c[100]=h&24576;c[101]=h&4095;if(i<<16>>16<0){c[102]=e[a+4>>1]<<16|e[d>>1];c[98]=a+6}else{c[98]=a+4;c[102]=e[d>>1]}i=c[849]|0;c[849]=i+-80;if(!(b[i+-78>>1]|0))return;Bi();return}function of(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;f=a+38|0;e=b[f>>1]|0;if(e<<16>>16>4){a=Rb(4)|0;c[a>>2]=7;ad(a|0,8,0)}if(!(e<<16>>16)){c[a+44>>2]=1;h=1}else{g=a+44|0;h=$(c[g>>2]|0,c[a+4+(e<<16>>16<<2)>>2]|0)|0;c[g>>2]=h}g=e+1<<16>>16;b[f>>1]=g;if((d|0)<0){a=Rb(4)|0;c[a>>2]=7;ad(a|0,8,0)}e=g<<16>>16;if((c[a+4+(e<<2)>>2]|0)>(d|0)){d=$(h,d)|0;a=a+40|0;c[a>>2]=(c[a>>2]|0)+d;return}if(g<<16>>16<=3?(c[a+4+(e+1<<2)>>2]|0)!=0:0){a=Rb(4)|0;c[a>>2]=7;ad(a|0,8,0)}if(!(b[a+36>>1]&8)){a=Rb(4)|0;c[a>>2]=7;ad(a|0,8,0)}Yf(a,e,d+1|0);d=$(c[a+44>>2]|0,d)|0;a=a+40|0;c[a>>2]=(c[a>>2]|0)+d;return}function pf(a){a=a|0;return c[(c[(c[185]|0)+32>>2]|0)+(a<<2)>>2]|0}function qf(a,b){a=a|0;b=b|0;var d=0,e=0;if((b|0)>95){a=Rb(4)|0;c[a>>2]=21;ad(a|0,8,0)}switch(b|0){case 64:{b=(c[186]|0)+784|0;d=4;e=4;break}case 65:{b=c[(c[186]|0)+792>>2]|0;d=1024;e=2;break}case 68:{b=c[186]|0;d=888;e=4;break}default:{a=Rb(4)|0;c[a>>2]=21;ad(a|0,8,0)}}Uf(a,e,b,d);return}function rf(a){a=a|0;var b=0,d=0,e=0;c[186]=c[a+4>>2];d=c[a+8>>2]|0;c[187]=c[d+24>>2];c[188]=c[d+28>>2];b=El(68)|0;o=0;ja(16,b|0);e=o;o=0;if(e&1){e=kb()|0;Gl(b);qb(e|0)}c[185]=b;c[189]=c[c[b+32>>2]>>2];ji((c[186]|0)+784|0);b=El(12)|0;o=0;ja(17,b|0);e=o;o=0;if(e&1){e=kb()|0;Gl(b);qb(e|0)}c[190]=b;pk(b,c[(c[186]|0)+856>>2]|0);b=El(544)|0;o=0;ja(18,b|0);e=o;o=0;if(!(e&1)){c[191]=b;c[a+12>>2]=19;c[a+20>>2]=20;c[d+20>>2]=768;c[d+72>>2]=21;c[d+172>>2]=4;return}e=kb()|0;Gl(b);qb(e|0)}function sf(a){a=a|0;c[a+16>>2]=5;return}function tf(){return (c[185]|0)+44|0}function uf(d){d=d|0;var e=0,f=0,g=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+16448|0;s=w+56|0;n=w+48|0;r=w+44|0;u=w+40|0;v=w+36|0;g=w+32|0;t=w+28|0;l=w+24|0;m=w+20|0;e=w+16|0;f=w+12|0;o=w+8|0;p=w+4|0;q=w;Xd();do switch(d|0){case 0:{do if((c[c[187]>>2]|0)==15){e=c[c[188]>>2]|0;if((e|0)>1){w=Rb(4)|0;c[w>>2]=2;ad(w|0,8,0)}else{Xd();break}}else e=0;while(0);Pn(s,$d()|0,255)|0;v=je()|0;Xd();e=pi(c[189]|0,s,e,v)|0;c[(c[186]|0)+784>>2]=e;e=c[(c[189]|0)+188>>2]|0;if((e|0)>-1){Eh(c[185]|0,e)|0;v=c[189]|0;qi(v,c[(c[186]|0)+784>>2]|0,e,b[v+192>>1]|0,b[v+194>>1]|0,b[v+196>>1]|0,b[v+198>>1]|0,b[v+200>>1]|0,b[v+202>>1]|0)}v=0;i=w;return v|0}case 2:{se($d()|0)|0;de(0)|0;ae(30178)|0;v=c[186]|0;c[v+240>>2]=0;c[v+236>>2]=1;v=1;i=w;return v|0}case 3:{u=c[186]|0;c[u+240>>2]=0;c[u+236>>2]=1;Pn(s,be(30178)|0,16383)|0;u=Sj(de(0)|0,s,ae(30178)|0)|0;v=c[186]|0;c[v+784>>2]=u;v=c[v+236>>2]|0;i=w;return v|0}case 8:{Pn(s,$d()|0,255)|0;t=de(0)|0;v=de(0)|0;c[u>>2]=v;if(qk(c[190]|0,s,t,v)|0){w=Rb(4)|0;c[w>>2]=12;ad(w|0,8,0)}v=0;i=w;return v|0}case 9:{v=de(0)|0;rk(c[190]|0,v)|0;v=0;i=w;return v|0}case 10:{v=de(-1)|0;vk(c[190]|0,v);v=0;i=w;return v|0}case 12:{t=de(c[(c[189]|0)+68>>2]|0)|0;v=de(c[(c[189]|0)+72>>2]|0)|0;c[u>>2]=v;Th(c[189]|0,t,v);v=0;i=w;return v|0}case 15:{if((_d()|0)<-1){v=0;i=w;return v|0}e=c[97]|0;e=rd[c[(c[3356>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&63](e)|0;f=b[c[97]>>1]|0;if(f<<16>>16!=2)e=wd[c[(c[3356>>2]|0)+300>>2]&31](e,f<<16>>16)|0;Rh(c[189]|0,e);v=0;i=w;return v|0}case 16:{v=$d()|0;Lh(c[189]|0,v);v=0;i=w;return v|0}case 17:{u=de(c[(c[189]|0)+68>>2]|0)|0;v=c[189]|0;c[v+68>>2]=u;v=de(c[v+72>>2]|0)|0;c[(c[189]|0)+72>>2]=v;v=0;i=w;return v|0}case 18:{r=de(0)|0;s=de(0)|0;c[u>>2]=s;t=de(c[(c[189]|0)+4>>2]|0)|0;c[v>>2]=t;u=de(c[(c[189]|0)+8>>2]|0)|0;v=de(1)|0;Vh(c[189]|0,r,s,t,u,v);v=0;i=w;return v|0}case 19:{v=de(0)|0;Gh(c[189]|0,v);v=0;i=w;return v|0}case 20:{Pn(s,$d()|0,255)|0;t=de(12)|0;v=de(0)|0;c[u>>2]=v;Hh(c[189]|0,s,t,v);v=0;i=w;return v|0}case 22:{s=de(64)|0;c[u>>2]=de(24)|0;c[v>>2]=de(0)|0;t=c[189]|0;c[t+76>>2]=s;c[t+80>>2]=c[u>>2];c[t+84>>2]=c[v>>2];v=0;i=w;return v|0}case 23:{Pn(s,$d()|0,63)|0;v=de(0)|0;Dh(c[185]|0,c[(c[189]|0)+32>>2]|0,s,v)|0;v=0;i=w;return v|0}case 24:{s=de(0)|0;t=de(0)|0;c[u>>2]=t;u=de(0)|0;c[v>>2]=u;Ih(c[189]|0,s,t,u);v=0;i=w;return v|0}case 27:{f=de(1)|0;c[u>>2]=de(0)|0;c[v>>2]=de(0)|0;de(0)|0;de(0)|0;e=(f&16|0)==0;if(!(f&1)){if(!e){ri(c[189]|0)|0;Ph(c[189]|0);v=0;i=w;return v|0}}else if(e){ri(c[189]|0)|0;Ph(c[189]|0)}e=Yi(33)|0;if((e|0)>-1)e=Eh(c[185]|0,e)|0;else e=0;pj(e);v=Xj(c[189]|0,f)|0;c[(c[186]|0)+784>>2]=v;v=0;i=w;return v|0}case 28:{de(-1)|0;c[u>>2]=de(-1)|0;c[v>>2]=de(-1)|0;de(-1)|0;v=0;i=w;return v|0}case 29:{v=de(0)|0;c[u>>2]=de(0)|0;c[189]=Eh(c[185]|0,v)|0;c[192]=v;v=0;i=w;return v|0}case 30:{r=de(0)|0;s=de(0)|0;c[u>>2]=s;t=de(0)|0;c[v>>2]=t;u=de(c[(c[189]|0)+92>>2]|0)|0;v=de(c[(c[189]|0)+96>>2]|0)|0;r=Eh(c[185]|0,r)|0;if(!(Wh(c[189]|0,r,s,t,u,v)|0)){v=0;i=w;return v|0}else{w=Rb(4)|0;c[w>>2]=21;ad(w|0,8,0)}}case 31:{d=de(c[(c[189]|0)+4>>2]|0)|0;p=de(c[(c[189]|0)+8>>2]|0)|0;c[u>>2]=p;q=de(0)|0;c[v>>2]=q;r=de(0)|0;s=de(0)|0;t=de(c[(c[189]|0)+92>>2]|0)|0;u=de(c[(c[189]|0)+96>>2]|0)|0;v=de(0)|0;q=Eh(c[185]|0,q)|0;if(!(Xh(c[189]|0,d,p,q,r,s,t,u,v)|0)){v=0;i=w;return v|0}else{w=Rb(4)|0;c[w>>2]=21;ad(w|0,8,0)}}case 32:{r=de(0)|0;c[u>>2]=de(32)|0;c[v>>2]=de(32)|0;s=de(0)|0;t=c[189]|0;c[t+100>>2]=r;c[t+92>>2]=c[u>>2];c[t+96>>2]=c[v>>2];c[t+144>>2]=s;v=0;i=w;return v|0}case 33:if(!(Yh(c[189]|0,$d()|0)|0)){v=0;i=w;return v|0}else{w=Rb(4)|0;c[w>>2]=12;ad(w|0,8,0)}case 34:{s=de(0)|0;t=de(0)|0;c[u>>2]=t;u=de(0)|0;c[v>>2]=u;Zh(c[189]|0,s,t,u);v=0;i=w;return v|0}case 35:{v=he(g)|0;de(1)|0;c[u>>2]=0;me(c[g>>2]|0,v,4,u);v=0;i=w;return v|0}case 39:{m=he(t)|0;c[u>>2]=de(16384)|0;c[v>>2]=de(0)|0;e=c[u>>2]|0;if((e|0)<64){c[u>>2]=64;e=64}e=re(e+1|0)|0;a:do switch(c[v>>2]&15|0){case 0:{if((c[u>>2]|0)<1)g=0;else{g=0;while(1){f=bn()|0;if((f|0)==-1)break a;l=e+1|0;a[e>>0]=f;s=c[u>>2]|0;c[u>>2]=s+-1;g=g+1|0;if((s|0)<2){e=l;break}else e=l}}break}case 1:{if((c[u>>2]|0)<1)g=0;else{l=e;g=0;while(1){f=bn()|0;switch(f|0){case 10:case -1:{e=l;break a}default:{}}e=l+1|0;a[l>>0]=f;s=c[u>>2]|0;c[u>>2]=s+-1;g=g+1|0;if((s|0)<2)break a;else l=e}}break}case 2:{if((c[u>>2]|0)>=1){l=e;g=0;b:while(1){f=bn()|0;switch(f|0){case 10:case -1:{e=l;break a}case 13:{e=l;break b}default:{}}e=l+1|0;a[l>>0]=f;s=c[u>>2]|0;c[u>>2]=s+-1;g=g+1|0;if((s|0)<2)break a;else l=e}f=bn()|0;if((f|0)!=10)gn(f,c[5916]|0)|0}else g=0;break}default:g=0}while(0);a[e>>0]=0;f=c[186]|0;c[f+788>>2]=g+1;e=c[t>>2]|0;if(!(c[v>>2]&16)){me(e,m,2,c[f+824>>2]|0);v=0;i=w;return v|0}if(!(b[e+36>>1]&2)){w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}c[e+40>>2]=m;v=rd[c[(c[3356>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&63](e)|0;so(v|0,c[(c[186]|0)+824>>2]|0,g|0)|0;v=0;i=w;return v|0}case 43:case 42:case 41:{l=de(0)|0;m=de(640)|0;c[u>>2]=m;g=de(480)|0;c[v>>2]=g;de(0)|0;e=de(-1)|0;f=de(-1)|0;de(m)|0;de(g)|0;do if((d|0)==41)if(!l){w=Rb(4)|0;c[w>>2]=3;ad(w|0,8,0)}else{Bh(c[185]|0,l,1,e,f,m,g);break}while(0);c[189]=c[(c[(c[185]|0)+32>>2]|0)+(l<<2)>>2];c[192]=l;v=0;i=w;return v|0}case 47:{v=de(0)|0;c[u>>2]=de(0)|0;t=de(c[(c[189]|0)+68>>2]|0)|0;s=c[189]|0;c[s+68>>2]=t;s=de(c[s+72>>2]|0)|0;t=c[189]|0;c[t+72>>2]=s;Uh(t,v,c[u>>2]|0);v=0;i=w;return v|0}case 48:{l=de(0)|0;e=de(-1)|0;c[u>>2]=e;g=c[189]|0;t=c[g+168>>2]|0;f=t+-1|0;if((t|0)<1){v=0;i=w;return v|0}if((e|0)>(f|0)|l>>>31|(l|0)>(f|0)){w=Rb(4)|0;c[w>>2]=3;ad(w|0,8,0)}if((e|0)<0)c[u>>2]=f;else f=e;c[v>>2]=l;if((l|0)>(f|0)){v=0;i=w;return v|0}li(g,l);e=l+1|0;c[v>>2]=e;if((l|0)>=(f|0)){v=0;i=w;return v|0}do{li(c[189]|0,e);u=e;e=e+1|0;c[v>>2]=e}while((u|0)<(f|0));e=0;i=w;return e|0}case 49:{s=de(0)|0;t=de(0)|0;c[u>>2]=t;u=de(c[(c[189]|0)+4>>2]|0)|0;c[v>>2]=u;v=de(c[(c[189]|0)+8>>2]|0)|0;Sh(c[189]|0,s,t,u,v);v=0;i=w;return v|0}case 52:{v=he(l)|0;t=de(0)|0;s=de(1)|0;c[u>>2]=s;u=yj(s)|0;c[194]=u;s=u&~c[195];c[196]=s;c[195]=u;c[m>>2]=s|u&t;me(c[l>>2]|0,v,4,m);v=0;i=w;return v|0}case 53:{s=de(0)|0;t=de(0)|0;c[u>>2]=t;k=+fe(0.0);u=de(c[(c[189]|0)+92>>2]|0)|0;c[v>>2]=u;v=de(c[(c[189]|0)+96>>2]|0)|0;ai(c[189]|0,s,t,u,v,k);v=0;i=w;return v|0}case 54:{s=de(0)|0;t=de(0)|0;c[u>>2]=t;u=de(0)|0;c[v>>2]=u;k=+fe(0.0);q=de(c[(c[189]|0)+92>>2]|0)|0;r=de(c[(c[189]|0)+96>>2]|0)|0;s=Eh(c[185]|0,s)|0;v=c[189]|0;bi(v,q,r,k,s,t,u,c[v+92>>2]|0,c[v+96>>2]|0);v=0;i=w;return v|0}case 55:{o=de(0)|0;e=ie()|0;if((b[e>>1]|0)!=4){w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}c[e+40>>2]=0;n=rd[c[(c[3356>>2]|0)+588>>2]&63](e)|0;e=ie()|0;if((b[e>>1]|0)!=4){w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}c[e+40>>2]=0;m=rd[c[(c[3356>>2]|0)+588>>2]&63](e)|0;do if((o|0)>-1){f=Eh(c[185]|0,o)|0;e=ie()|0;if((b[e>>1]|0)!=4){w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}c[e+40>>2]=0;e=rd[c[(c[3356>>2]|0)+588>>2]&63](e)|0;l=ie()|0;if((b[l>>1]|0)==4){c[l+40>>2]=0;g=e;e=rd[c[(c[3356>>2]|0)+588>>2]&63](l)|0;break}else{w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}}else if((o|0)==-257){e=ie()|0;if((b[e>>1]|0)==4){c[e+40>>2]=0;f=0;g=rd[c[(c[3356>>2]|0)+588>>2]&63](e)|0;e=0;break}else{w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}}else{f=0;g=0;e=0}while(0);$h(c[189]|0,n,m,f,g,e,o);v=0;i=w;return v|0}case 56:{p=de(0)|0;q=de(0)|0;c[u>>2]=q;r=de(c[(c[189]|0)+4>>2]|0)|0;c[v>>2]=r;s=de(c[(c[189]|0)+8>>2]|0)|0;t=de(0)|0;u=de(0)|0;v=de(0)|0;_h(c[189]|0,p,q,r,s,t,u,v);v=0;i=w;return v|0}case 57:{v=de(-1)|0;c[(c[189]|0)+188>>2]=v;v=(de(0)|0)&65535;b[(c[189]|0)+192>>1]=v;v=(de(0)|0)&65535;b[(c[189]|0)+194>>1]=v;v=(de(0)|0)&65535;b[(c[189]|0)+196>>1]=v;v=(de(0)|0)&65535;u=c[189]|0;b[u+198>>1]=v;u=(de(b[u+192>>1]|0)|0)&65535;v=c[189]|0;b[v+200>>1]=u;v=(de(b[v+194>>1]|0)|0)&65535;b[(c[189]|0)+202>>1]=v;v=0;i=w;return v|0}case 58:{t=de(0)|0;v=de(2)|0;c[u>>2]=v;ni(c[189]|0,t,v);v=0;i=w;return v|0}case 59:{t=de(0)|0;v=de(1)|0;c[u>>2]=v;mi(c[189]|0,t,v);v=0;i=w;return v|0}case 60:{Pn(s,$d()|0,63)|0;e=de(-1)|0;c[u>>2]=de(0)|0;if((e|0)<0)e=Fh(c[185]|0)|0;Ch(c[185]|0,e,s);c[(c[186]|0)+784>>2]=e;v=0;i=w;return v|0}case 61:{r=de(1)|0;s=de(0)|0;c[u>>2]=s;t=de(0)|0;c[v>>2]=t;u=de(0)|0;v=de(0)|0;Kh(Eh(c[185]|0,r)|0,s,t,u,v);v=0;i=w;return v|0}case 62:{e=de(1)|0;g=de(0)|0;c[u>>2]=g;h=+fe(1.0);j=+fe(1.0);k=+fe(0.0);e=Eh(c[185]|0,e)|0;f=c[189]|0;if(j==1.0&(h==1.0&k==0.0)){di(f,e,g)|0;v=0;i=w;return v|0}else{ci(f,e,g,h,j,k)|0;v=0;i=w;return v|0}}case 63:{v=de(0)|0;ei(c[189]|0,v);v=0;i=w;return v|0}case 64:{t=de(0)|0;v=de(0)|0;c[u>>2]=v;Xi(t,v);v=0;i=w;return v|0}case 65:{v=he(e)|0;c[u>>2]=Yi(de(0)|0)|0;me(c[e>>2]|0,v,4,u);v=0;i=w;return v|0}case 66:{t=de(0)|0;v=de(0)|0;c[u>>2]=v;sk(c[190]|0,t,v);v=0;i=w;return v|0}case 67:{de(0)|0;c[u>>2]=de(0)|0;v=0;i=w;return v|0}case 68:{t=he(f)|0;r=de(0)|0;s=de(0)|0;c[u>>2]=s;c[v>>2]=uk(c[190]|0,r,s)|0;me(c[f>>2]|0,t,4,v);v=0;i=w;return v|0}case 69:{e=ne(s,n)|0;f=c[s>>2]|0;if((b[f>>1]|0)!=4){c[r>>2]=0;me(f,0,4,r);e=c[s>>2]|0;c[e+40>>2]=0;e=rd[c[(c[3356>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&63](e)|0;f=c[s>>2]|0}v=ii(c[189]|0,e)|0;u=f;t=(v|0)<1?1:v;c[u+8>>2]=t;c[u+24>>2]=t<<2;c[(c[186]|0)+784>>2]=v;v=0;i=w;return v|0}case 70:{f=ne(s,n)|0;e=c[s>>2]|0;if((b[e>>1]|0)==4)g=e;else{c[r>>2]=0;me(e,0,4,r);f=c[s>>2]|0;c[f+40>>2]=0;f=rd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0;g=c[s>>2]|0}e=de(0)|0;e=hi(c[189]|0,e)|0;v=g;c[v+8>>2]=4;c[v+24>>2]=16;if(!e){c[f>>2]=-1;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[(c[186]|0)+784>>2]=-1;v=0;i=w;return v|0}else{c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];c[(c[186]|0)+784>>2]=c[e>>2];v=0;i=w;return v|0}}case 71:{e=he(o)|0;f=$d()|0;f=rd[c[(c[740>>2]|0)+64>>2]&63](f)|0;if(!f)e=-1;else{me(c[o>>2]|0,e,2,f);e=0}c[(c[186]|0)+784>>2]=e;v=0;i=w;return v|0}case 72:{f=ne(s,n)|0;e=c[s>>2]|0;if((b[e>>1]|0)==4)g=e;else{c[r>>2]=0;me(e,0,4,r);f=c[s>>2]|0;c[f+40>>2]=0;f=rd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0;g=c[s>>2]|0}e=$d()|0;e=wd[c[(c[740>>2]|0)+60>>2]&31](e,p)|0;if(!e){c[p>>2]=-1;e=-1}else{v=g;u=c[p>>2]|0;u=(u|0)<1?1:u;c[v+8>>2]=u;c[v+24>>2]=u<<2;so(f|0,e|0,c[p>>2]<<2|0)|0;e=c[p>>2]|0}c[(c[186]|0)+784>>2]=e;v=0;i=w;return v|0}case 73:{Pn(s,$d()|0,255)|0;v=$d()|0;v=wd[c[(c[740>>2]|0)+52>>2]&31](s,v)|0;c[(c[186]|0)+784>>2]=v;v=0;i=w;return v|0}case 74:{r=se($d()|0)|0;s=de(0)|0;t=de(0)|0;c[u>>2]=t;u=de(0)|0;c[v>>2]=u;v=ud[c[(c[740>>2]|0)+56>>2]&3](r,s,t,u)|0;c[(c[186]|0)+784>>2]=v;v=0;i=w;return v|0}case 75:{u=se($d()|0)|0;v=ae(30178)|0;v=yk(c[191]|0,u,(a[v>>0]|0)==0?0:v)|0;c[(c[186]|0)+784>>2]=v;v=0;i=w;return v|0}case 76:{g=he(q)|0;l=de(0)|0;e=c[191]|0;if(!(l&16)){c[u>>2]=zk(e,l)|0;me(c[q>>2]|0,g,4,u);v=0;i=w;return v|0}e=Ak(e,l)|0;f=c[q>>2]|0;if((l|0)!=16){me(f,g,2,e);v=0;i=w;return v|0}if((b[f>>1]|0)!=2)me(f,g,2,30178);v=zk(c[191]|0,1)|0;u=c[q>>2]|0;c[u+40>>2]=g;u=rd[c[(c[3356>>2]|0)+((b[u>>1]<<16>>16)*140|0)+28>>2]&63](u)|0;t=c[q>>2]|0;sd[c[(c[3356>>2]|0)+((b[t>>1]<<16>>16)*140|0)+68>>2]&15](t,u,v+1|0);u=c[q>>2]|0;c[u+40>>2]=g;u=rd[c[(c[3356>>2]|0)+((b[u>>1]<<16>>16)*140|0)+28>>2]&63](u)|0;so(u|0,e|0,v|0)|0;a[u+v>>0]=0;Bk(c[191]|0,16,30178);v=0;i=w;return v|0}case 93:{s=de(255)|0;t=de(255)|0;c[u>>2]=t;u=de(255)|0;c[v>>2]=u;Jh(c[189]|0,s,t,u);v=0;i=w;return v|0}case 94:{s=de(0)|0;t=de(0)|0;c[u>>2]=t;u=de(-1)|0;c[v>>2]=u;tj(s,t,u);v=0;i=w;return v|0}case 95:{e=ie()|0;if((b[e>>1]|0)!=4){w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}c[e+40>>2]=0;g=rd[c[(c[3356>>2]|0)+588>>2]&63](e)|0;e=ie()|0;if((b[e>>1]|0)!=4){w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}c[e+40>>2]=0;e=rd[c[(c[3356>>2]|0)+588>>2]&63](e)|0;f=ie()|0;if((b[f>>1]|0)!=4){w=Rb(4)|0;c[w>>2]=6;ad(w|0,8,0)}c[f+40>>2]=0;s=rd[c[(c[3356>>2]|0)+588>>2]&63](f)|0;v=de(0)|0;t=de(1)|0;c[u>>2]=t;v=Eh(c[185]|0,v)|0;v=Pj(c[189]|0,g,e,s,t,v)|0;c[(c[186]|0)+784>>2]=v;v=0;i=w;return v|0}default:{w=Rb(4)|0;c[w>>2]=21;ad(w|0,8,0)}}while(0);return 0}function vf(a){a=a|0;var b=0;a=c[190]|0;do if(a){o=0;ja(19,a|0);b=o;o=0;if(!(b&1)){Gl(a);break}b=kb()|0;Gl(a);qb(b|0)}while(0);a=c[191]|0;do if(a){o=0;ja(20,a|0);b=o;o=0;if(!(b&1)){Gl(a);break}b=kb()|0;Gl(a);qb(b|0)}while(0);a=c[185]|0;if(!a)return 0;o=0;ja(21,a|0);b=o;o=0;if(b&1){b=kb()|0;Gl(a);qb(b|0)}else{Gl(a);return 0}return 0}function wf(d,e){d=d|0;e=e|0;var f=0,g=0;g=i;i=i+16|0;f=g;c[d>>2]=4;if(!(e&256))switch(e|0){case 0:{c[193]=b[(c[189]|0)+176>>1];d=772;i=g;return d|0}case 1:{c[193]=b[(c[189]|0)+178>>1];d=772;i=g;return d|0}case 2:{d=(c[189]|0)+182|0;c[193]=b[d>>1];b[d>>1]=0;d=772;i=g;return d|0}case 3:{c[193]=0;d=772;i=g;return d|0}case 4:{c[193]=0;d=772;i=g;return d|0}case 5:{c[193]=0;d=772;i=g;return d|0}default:{g=Rb(4)|0;c[g>>2]=21;ad(g|0,8,0)}}if(c[c[187]>>2]|0){g=Rb(4)|0;c[g>>2]=32;ad(g|0,8,0)}if((c[c[188]>>2]|0)!=40){g=Rb(4)|0;c[g>>2]=32;ad(g|0,8,0)}Xd();a:do switch(e&255|0){case 0:{e=ce()|0;if((e|0)>=256){h[2]=+Vj(e);c[d>>2]=3;e=16;break a}do switch(e|0){case 31:case 30:case 29:case 28:case 24:case 19:case 11:case 10:case 9:case 8:case 7:case 6:case 5:case 4:case 1:case 0:{e=0;break}case 2:{e=Ah(c[185]|0)|0;break}case 3:{e=c[192]|0;break}case 26:case 12:{e=c[(c[189]|0)+4>>2]|0;break}case 27:case 13:{e=c[(c[189]|0)+8>>2]|0;break}case 14:{e=b[(c[189]|0)+156>>1]|0;break}case 15:{e=b[(c[189]|0)+158>>1]|0;break}case 16:{e=(c[(c[189]|0)+104>>2]|0)>>>16&255;break}case 17:{e=(c[(c[189]|0)+104>>2]|0)>>>8&255;break}case 18:{e=c[(c[189]|0)+104>>2]&255;break}case 20:{e=uj()|0;break}case 21:{e=vj()|0;break}case 22:{e=c[(c[189]|0)+68>>2]|0;break}case 23:{e=c[(c[189]|0)+72>>2]|0;break}case 25:{e=Fh(c[185]|0)|0;break}default:{g=Rb(4)|0;c[g>>2]=21;ad(g|0,8,0)}}while(0);c[193]=e;e=772;break}case 2:{f=ce()|0;e=c[(c[186]|0)+824>>2]|0;a[e>>0]=0;if(f>>>0<6){c[d>>2]=2;break a}else{g=Rb(4)|0;c[g>>2]=3;ad(g|0,8,0)}}case 3:{if(!(Tj(ce()|0,f,c[(c[186]|0)+824>>2]|0)|0)){a[c[(c[186]|0)+824>>2]>>0]=0;e=4}else e=c[f>>2]|0;c[d>>2]=e;e=c[(c[186]|0)+824>>2]|0;break}default:{g=Rb(4)|0;c[g>>2]=21;ad(g|0,8,0)}}while(0);if(c[c[187]>>2]|0){g=Rb(4)|0;c[g>>2]=32;ad(g|0,8,0)}if((c[c[188]>>2]|0)!=41){g=Rb(4)|0;c[g>>2]=32;ad(g|0,8,0)}Xd();d=e;i=g;return d|0}function xf(a){a=a|0;var b=0;c[197]=c[a+4>>2];b=c[a+8>>2]|0;c[198]=b;c[199]=c[b+24>>2];c[200]=c[b+28>>2];h[3]=.000244140625;c[a+12>>2]=22;c[a+20>>2]=23;return}function yf(a){a=a|0;c[a+16>>2]=6;return}function zf(d){d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0.0;J=i;i=i+112|0;H=J+108|0;E=J+104|0;f=J+100|0;e=J+96|0;g=J+92|0;r=J+88|0;k=J+84|0;s=J+80|0;l=J+76|0;B=J+72|0;p=J+68|0;z=J+64|0;A=J+60|0;n=J+56|0;o=J+52|0;y=J+48|0;x=J+44|0;j=J+40|0;w=J+36|0;q=J+32|0;F=J+28|0;m=J+24|0;u=J+20|0;C=J+16|0;D=J+12|0;G=J+8|0;t=J+4|0;v=J;Xd();do switch(d|0){case 4:case 3:case 2:case 1:case 0:{e=c[c[199]>>2]|0;if((e|0)==1)e=(b[(c[(c[197]|0)+44>>2]|0)+((c[c[200]>>2]|0)*48|0)>>1]|0)==1?7:1;switch(e|0){case 15:{I=6;break}case 7:{e=0;break}default:{Me(d,ce()|0);i=J;return 0}}do if((I|0)==6){e=c[c[200]>>2]|0;if((e|0)>1){J=Rb(4)|0;c[J>>2]=2;ad(J|0,8,0)}else{Xd();break}}while(0);k=ke()|0;if((d|0)!=4){Xe(d,e,-1,k);i=J;return 0}g=ce()|0;j=c[c[(c[198]|0)+20>>2]>>2]|0;f=Ye(j,g)|0;if(!f)f=Ke()|0;b[f>>1]=2;b[f+2>>1]=e;c[f+16>>2]=k;c[f+4>>2]=g;c[f+8>>2]=j;i=J;return 0}case 20:case 19:case 18:case 17:{Le(5,0,0,$d()|0)|0;Le(d+-9|0,0,0,0)|0;i=J;return 0}case 21:{I=he(f)|0;Le(5,0,0,$d()|0)|0;Le(13,de(0)|0,0,e)|0;me(c[f>>2]|0,I,2,c[e>>2]|0);Le(14,0,0,0)|0;i=J;return 0}case 23:case 22:{Le(5,0,0,$d()|0)|0;f=ne(g,r)|0;e=de(-1)|0;g=de(-1)|0;c[E>>2]=g;I=c[r>>2]|0;e=(e|0)<0|(e|0)>(I|0)?I:e;if((d|0)==22){Le(6,(g|0)<0?0:g,e,f)|0;i=J;return 0}else{Le(7,g,e,f)|0;i=J;return 0}}case 24:{Le(5,0,0,$d()|0)|0;Le(12,0,0,$d()|0)|0;i=J;return 0}case 25:{f=ne(k,s)|0;g=de(0)|0;e=de(0)|0;c[E>>2]=e;if(!e){e=(c[s>>2]|0)-g|0;c[E>>2]=e}Qd(f+g|0,e);i=J;return 0}case 28:case 27:case 26:{e=ne(l,B)|0;j=de(0)|0;if((j|0)<0){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}g=e+j|0;if((_d()|0)<-1){c[E>>2]=0;e=E;f=4}else{f=c[97]|0;e=c[f+28>>2]|0;f=b[f>>1]|0}if((d|0)==26)switch(f|0){case 4:{if((j|0)>=(c[B>>2]|0)){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}a[g>>0]=a[e>>0]|0;i=J;return 0}case 2:{I=Mn(e)|0;c[(c[197]|0)+788>>2]=I;if((j+1+I|0)>(c[B>>2]|0)){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}Kn(g,e)|0;i=J;return 0}default:{J=Rb(4)|0;c[J>>2]=6;ad(J|0,8,0)}}if((f|0)!=4){J=Rb(4)|0;c[J>>2]=6;ad(J|0,8,0)}if((d|0)==27){if((j+2|0)>(c[B>>2]|0)){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}b[g>>1]=b[e>>1]|0;i=J;return 0}else{if((j+4|0)>(c[B>>2]|0)){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}c[g>>2]=c[e>>2];i=J;return 0}}case 29:{k=he(z)|0;g=ne(p,A)|0;j=de(0)|0;f=de(0)|0;c[E>>2]=f;e=de(1024)|0;if((j|0)>=(c[A>>2]|0)){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}I=re(e+1|0)|0;pl();H=rl(g+j|0,I,f&255,e)|0;c[(c[197]|0)+784>>2]=H;H=ql()|0;c[(c[197]|0)+788>>2]=H;me(c[z>>2]|0,k,2,I);i=J;return 0}case 30:{Le(5,0,0,$d()|0)|0;I=de(-1)|0;Ld();I=Kd(c[(c[197]|0)+796>>2]|0,0,-1,I)|0;c[E>>2]=I;if(!I){i=J;return 0}else{J=Rb(4)|0;c[J>>2]=12;ad(J|0,8,0)}}case 31:{I=he(n)|0;e=c[n>>2]|0;c[e+40>>2]=I;e=rd[c[(c[3356>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&63](e)|0;if(!(b[(c[n>>2]|0)+36>>1]&2)){J=Rb(4)|0;c[J>>2]=6;ad(J|0,8,0)}I=de(0)|0;H=c[n>>2]|0;sd[c[(c[3356>>2]|0)+((b[H>>1]<<16>>16)*140|0)+68>>2]&15](H,e,(I|0)<64?64:I);i=J;return 0}case 32:{k=ne(o,y)|0;f=ne(o,x)|0;g=de(0)|0;j=de(0)|0;c[E>>2]=j;e=de(0)|0;if((j|e|0)<0){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}if((j+g|0)>(c[y>>2]|0)){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}if((e+g|0)>(c[x>>2]|0)){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}if((g|0)<=0){i=J;return 0}to(k+j|0,f+e|0,g|0)|0;i=J;return 0}case 33:{f=ne(j,w)|0;g=de(0)|0;j=de(0)|0;c[E>>2]=j;e=de(0)|0;if((e|0)<0){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}if((j+e|0)>(c[w>>2]|0)){J=Rb(4)|0;c[J>>2]=20;ad(J|0,8,0)}if((j|0)<=0){i=J;return 0}uo(f+e|0,g&255|0,j|0)|0;i=J;return 0}case 34:{e=c[197]|0;c[e+820>>2]=c[e+812>>2];c[e+816>>2]=c[e+808>>2];e=he((c[197]|0)+808|0)|0;f=c[197]|0;c[f+812>>2]=e;f=c[f+808>>2]|0;if((b[f>>1]|0)==2){i=J;return 0}me(f,e,2,30178);i=J;return 0}case 35:{e=c[197]|0;f=c[e+808>>2]|0;if(!f){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}c[f+40>>2]=c[e+812>>2];k=rd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0;Qi(804,k);g=$d()|0;j=(Mn(g)|0)+8|0;e=c[(c[197]|0)+808>>2]|0;f=c[(c[839]|0)+((b[e>>1]|0)*140|0)+68>>2]|0;j=j+(Mn(k)|0)|0;sd[f&15](e,k,j);g=se(g)|0;j=de(-1)|0;k=de(0)|0;c[E>>2]=k;e=c[197]|0;f=c[e+808>>2]|0;if(!f){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}c[f+40>>2]=c[e+812>>2];Qi(804,rd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0);Vi(804,g,j,k)|0;i=J;return 0}case 36:{e=de(0)|0;f=c[197]|0;g=c[f+808>>2]|0;if(!g){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}c[g+40>>2]=c[f+812>>2];Qi(804,rd[c[(c[3356>>2]|0)+((b[g>>1]<<16>>16)*140|0)+28>>2]&63](g)|0);Vi(804,0,e,1)|0;i=J;return 0}case 37:{Le(5,0,0,$d()|0)|0;e=de(-1)|0;Le(8,0,0,0)|0;j=c[197]|0;f=j+788|0;g=c[f>>2]|0;if((g|0)<0){J=Rb(4)|0;c[J>>2]=12;ad(J|0,8,0)}if(!((e|0)<0|(g|0)<(e|0))){c[f>>2]=e;g=e}e=c[j+808>>2]|0;if(!e){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}c[e+40>>2]=c[j+812>>2];e=rd[c[(c[3356>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&63](e)|0;Qi(804,e);f=c[(c[197]|0)+808>>2]|0;sd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+68>>2]&15](f,e,g+1|0);e=c[197]|0;f=c[e+808>>2]|0;if(!f){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}c[f+40>>2]=c[e+812>>2];I=rd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0;Qi(804,I);Le(6,0,g,I)|0;a[I+g>>0]=0;i=J;return 0}case 38:{Le(5,0,0,$d()|0)|0;e=c[197]|0;f=c[e+808>>2]|0;if(!f){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}c[f+40>>2]=c[e+812>>2];I=rd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0;Qi(804,I);Le(7,-1,Mn(I)|0,I)|0;i=J;return 0}case 39:{e=Eb(0)|0;c[E>>2]=e;e=de(e)|0;c[208]=e;f=1;do{e=($(e>>>30^e,1812433253)|0)+f|0;c[832+(f<<2)>>2]=e;f=f+1|0}while((f|0)!=624);c[832]=0;i=J;return 0}case 40:{I=c[197]|0;c[I+812>>2]=c[I+820>>2];c[I+808>>2]=c[I+816>>2];i=J;return 0}case 41:{e=c[197]|0;f=c[e+808>>2]|0;if(!f){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}c[f+40>>2]=c[e+812>>2];Qi(804,rd[c[(c[3356>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0);H=he(q)|0;I=Si(804,de(0)|0)|0;me(c[q>>2]|0,H,2,I);Ti(804);i=J;return 0}case 42:{c[F>>2]=0;f=ne(F,m)|0;if((b[c[F>>2]>>1]|0)!=2){J=Rb(4)|0;c[J>>2]=6;ad(J|0,8,0)}q=$d()|0;r=Mn(q)|0;g=0;j=0;e=0;while(1){p=hl(f,q)|0;do if(!j){if(!(c[c[(c[198]|0)+84>>2]>>2]&8192)){g=he(F)|0;l=0;I=110;break}if(!g){k=0;l=1;I=104}else{c[F>>2]=0;g=1;f=1;I=118}}else{k=g;l=j;I=104}while(0);if((I|0)==104){j=c[F>>2]|0;g=k+1|0;if(j)if((g|0)<(c[j+8>>2]|0))I=110;else{if(c[j+12>>2]|0){I=107;break}Yf(j,1,k+2|0);I=110}else{f=l;I=118}}if((I|0)==110){I=0;j=c[F>>2]|0;if(!j){f=l;I=118}else{if(!p){I=112;break}k=p-f|0;m=c[839]|0;if((b[j>>1]|0)==2){n=2;o=m}else{if(g){I=115;break}Zf(j,2);n=b[j>>1]|0;o=c[839]|0}c[j+40>>2]=g;E=c[o+((n<<16>>16)*140|0)+68>>2]|0;H=m+308|0;G=rd[c[H>>2]&63](j)|0;sd[E&15](j,G,k+1|0);H=rd[c[H>>2]&63](j)|0;so(H|0,f|0,k|0)|0;a[H+k>>0]=0;e=e+1|0;f=l}}if((I|0)==118){I=0;e=e+1|0;if(!p)break}j=f;f=p+r|0}if((I|0)==107){J=Rb(4)|0;c[J>>2]=7;ad(J|0,8,0)}else if((I|0)==112){me(j,g,2,f);e=e+1|0}else if((I|0)==115){J=Rb(4)|0;c[J>>2]=31;ad(J|0,8,0)}if(!(c[c[(c[198]|0)+84>>2]>>2]&8192))do{I=he(F)|0;me(c[F>>2]|0,I,2,30178)}while((c[c[(c[198]|0)+84>>2]>>2]&8192|0)==0);c[(c[197]|0)+784>>2]=e;i=J;return 0}case 43:{g=he(u)|0;e=c[u>>2]|0;if((b[e>>1]|0)!=2){J=Rb(4)|0;c[J>>2]=6;ad(J|0,8,0)}c[e+40>>2]=g;e=rd[c[(c[3356>>2]|0)+308>>2]&63](e)|0;f=$d()|0;if(!(a[f>>0]|0)){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}xl(e,f);I=yl($d()|0)|0;me(c[u>>2]|0,g,2,I);I=zl()|0;c[(c[197]|0)+784>>2]=I;i=J;return 0}case 44:{K=+ee();L=+ee();c[834]=de(c[834]|0)|0;c[835]=0;h[7]=K;h[5]=K;K=L-K;h[8]=K;h[6]=K;i=J;return 0}case 45:{he(C)|0;j=de(0)|0;e=c[C>>2]|0;k=c[e+8>>2]|0;if((k|0)<1){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}switch(b[e>>1]|0){case 3:{f=c[e+28>>2]|0;e=c[836]|0;if(e)fl(e);g=el(k<<4)|0;c[836]=g;c[837]=k;e=0;do{h[g+(e<<4)>>3]=+h[f+(e<<3)>>3];c[g+(e<<4)+8>>2]=e;e=e+1|0}while((e|0)!=(k|0));e=g+(k<<4)|0;if(!j){c[H>>2]=7;Hf(g,e,H);e=0}else{c[H>>2]=8;Hf(g,e,H);e=0}do{me(c[C>>2]|0,e,3,(c[836]|0)+(e<<4)|0);e=e+1|0}while((e|0)!=(k|0));i=J;return 0}case 4:{g=c[e+28>>2]|0;e=c[836]|0;if(e)fl(e);f=el(k<<4)|0;c[836]=f;c[837]=k;e=0;do{c[f+(e<<4)>>2]=c[g+(e<<2)>>2];c[f+(e<<4)+8>>2]=e;e=e+1|0}while((e|0)!=(k|0));e=f+(k<<4)|0;if(!j){c[H>>2]=9;Hf(f,e,H)}else{c[H>>2]=10;Hf(f,e,H)}e=c[836]|0;f=0;do{c[g+(f<<2)>>2]=c[e+(f<<4)>>2];f=f+1|0}while((f|0)!=(k|0));i=J;return 0}default:{J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}}}case 46:{e=he(D)|0;g=de(0)|0;f=c[D>>2]|0;if((b[f>>1]|0)!=2){J=Rb(4)|0;c[J>>2]=6;ad(J|0,8,0)}if(c[f+12>>2]|e){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}k=c[f+8>>2]|0;e=c[836]|0;if(e)fl(e);e=el(k<<4)|0;c[836]=e;c[837]=k;j=(k|0)>0;if(j){f=0;do{e=c[D>>2]|0;c[e+40>>2]=f;e=rd[c[(c[3356>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&63](e)|0;c[(c[836]|0)+(f<<4)>>2]=e;e=c[836]|0;c[e+(f<<4)+8>>2]=f;f=f+1|0}while((f|0)!=(k|0));f=k}else f=0;f=e+(f<<4)|0;if(!g){c[H>>2]=11;Hf(e,f,H)}else{c[H>>2]=12;Hf(e,f,H)}g=c[(c[D>>2]|0)+32>>2]|0;if(j)f=0;else{i=J;return 0}do{e=c[(c[836]|0)+(f<<4)>>2]|0;if(!f){c[(c[D>>2]|0)+28>>2]=e;I=(c[D>>2]|0)+28|0;Mi(c[I>>2]|0,I)}else{I=g+(f<<2)|0;c[I>>2]=e;Mi(e,I)}f=f+1|0}while((f|0)!=(k|0));i=J;return 0}case 47:{p=he(G)|0;o=de(0)|0;m=c[G>>2]|0;c[m+40>>2]=p;m=rd[c[(c[3356>>2]|0)+((b[m>>1]<<16>>16)*140|0)+28>>2]&63](m)|0;e=a[m>>0]|0;if(!(e<<24>>24)){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}else{j=0;f=m}while(1){a:do if(e<<24>>24){g=f;b:while(1){f=g+1|0;switch(e<<24>>24){case 10:break a;case 13:{e=g;break b}default:{}}e=a[f>>0]|0;if(!(e<<24>>24))break a;else g=f}f=(a[f>>0]|0)==10?e+2|0:f}while(0);g=j+1|0;e=a[f>>0]|0;if(!(e<<24>>24)){n=g;l=j;break}else j=g}if((l|0)<0){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}e=c[836]|0;if(e)fl(e);f=el(n<<4)|0;c[836]=f;c[837]=n;if(a[m>>0]|0){k=0;e=m;while(1){c[f+(k<<4)>>2]=e;c[f+(k<<4)+8>>2]=k;c:while(1){j=a[e>>0]|0;switch(j<<24>>24){case 0:break c;case 10:case 13:{a[e>>0]=0;break}default:{}}g=e+1|0;switch(j<<24>>24){case 10:{e=g;break c}case 13:{I=181;break c}default:e=g}}if((I|0)==181){I=0;e=(a[g>>0]|0)==10?e+2|0:g}if(!(a[e>>0]|0))break;else k=k+1|0}f=c[836]|0}e=f+(n<<4)|0;if(!o){c[H>>2]=11;Hf(f,e,H)}else{c[H>>2]=12;Hf(f,e,H)}g=c[836]|0;if((l|0)>-1){f=0;e=0;do{e=e+2+(Mn(c[g+(f<<4)>>2]|0)|0)|0;f=f+1|0}while((f|0)!=(n|0));f=re(e+1|0)|0;g=c[836]|0;j=0;k=f;while(1){I=c[g+(j<<4)>>2]|0;Kn(k,I)|0;I=Mn(I)|0;a[k+I>>0]=13;e=k+(I+2)|0;a[k+(I+1)>>0]=10;j=j+1|0;if((j|0)==(n|0))break;else k=e}}else{e=re(1)|0;f=e}a[e>>0]=0;me(c[G>>2]|0,p,2,f);i=J;return 0}case 48:{g=he(t)|0;e=de(0)|0;f=c[836]|0;if(!f){J=Rb(4)|0;c[J>>2]=3;ad(J|0,8,0)}if((e|0)>-1&(e|0)<(c[837]|0))e=c[f+(e<<4)+8>>2]|0;else e=0;c[v>>2]=e;me(c[t>>2]|0,g,4,v);i=J;return 0}default:{J=Rb(4)|0;c[J>>2]=21;ad(J|0,8,0)}}while(0);return 0}function Af(a){a=a|0;return 0}function Bf(f,g){f=f|0;g=g|0;var j=0.0,k=0,l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0.0;H=i;i=i+1136|0;G=H+16|0;F=H+8|0;E=H;A=H+112|0;D=H+80|0;r=H+72|0;k=H+64|0;m=H+60|0;B=H+56|0;n=H+52|0;v=H+48|0;u=H+44|0;x=H+40|0;s=H+36|0;p=H+32|0;t=H+28|0;w=H+24|0;if(c[c[199]>>2]|0){H=Rb(4)|0;c[H>>2]=32;ad(H|0,8,0)}if((c[c[200]>>2]|0)!=40){H=Rb(4)|0;c[H>>2]=32;ad(H|0,8,0)}Xd();switch(g>>7|0){case 2:{c[f>>2]=2;C=0;break}case 3:{c[f>>2]=3;C=32;break}default:{c[f>>2]=4;C=3332}}a:do switch(g|0){case 0:if((_d()|0)<-1){H=Rb(4)|0;c[H>>2]=32;ad(H|0,8,0)}else{c[833]=c[($f(c[97]|0,4)|0)>>2];q=C;break a}case 1:{f=ce()|0;if(!f){H=Rb(4)|0;c[H>>2]=19;ad(H|0,8,0)}else{c[r>>2]=0;c[r+4>>2]=f+-1;c[833]=Df(r,832,r)|0;q=C;break a}}case 2:{c[833]=Mn($d()|0)|0;q=C;break}case 6:case 5:case 4:case 3:{c[833]=c[(ie()|0)+4+(g+-2<<2)>>2];q=C;break}case 7:{if((c[c[199]>>2]|0)!=2){he(k)|0;c[833]=b[c[k>>2]>>1];q=C;break a}f=ag($d()|0)|0;if(!f){H=Rb(4)|0;c[H>>2]=3;ad(H|0,8,0)}else{c[833]=b[f>>1];q=C;break a}}case 8:{c[833]=ol(ce()|0)|0;q=C;break}case 11:case 10:case 9:{f=ne(m,B)|0;k=de(0)|0;if((k|0)<0){H=Rb(4)|0;c[H>>2]=3;ad(H|0,8,0)}f=f+k|0;switch(g|0){case 9:if((k|0)<(c[B>>2]|0)){c[833]=d[f>>0];q=C;break a}else{H=Rb(4)|0;c[H>>2]=3;ad(H|0,8,0)}case 10:if((k+2|0)>(c[B>>2]|0)){H=Rb(4)|0;c[H>>2]=3;ad(H|0,8,0)}else{c[833]=e[f>>1];q=C;break a}default:if((k+4|0)>(c[B>>2]|0)){H=Rb(4)|0;c[H>>2]=3;ad(H|0,8,0)}else{c[833]=c[f>>2];q=C;break a}}}case 12:if((c[c[199]>>2]|0)==16){c[833]=c[(c[(c[197]|0)+840>>2]|0)+((c[c[200]>>2]|0)*28|0)+24>>2];Xd();q=C;break a}else{G=he(n)|0;q=c[n>>2]|0;c[q+40>>2]=G;c[833]=rd[c[(c[3356>>2]|0)+((b[q>>1]<<16>>16)*140|0)+28>>2]&63](q)|0;q=C;break a}case 13:{f=he(v)|0;k=c[v>>2]|0;if(!(b[k+36>>1]&128)){H=Rb(4)|0;c[H>>2]=6;ad(H|0,8,0)}else{c[k+40>>2]=f;q=rd[c[(c[3356>>2]|0)+((b[k>>1]<<16>>16)*140|0)+28>>2]&63](k)|0;c[833]=rd[c[(c[3356>>2]|0)+((b[c[v>>2]>>1]<<16>>16)*140|0)+60>>2]&63](q)|0;q=C;break a}}case 14:{f=de(0)|0;k=c[197]|0;m=c[k+808>>2]|0;if(!m){H=Rb(4)|0;c[H>>2]=3;ad(H|0,8,0)}c[m+40>>2]=c[k+812>>2];Qi(804,rd[c[(c[3356>>2]|0)+((b[m>>1]<<16>>16)*140|0)+28>>2]&63](m)|0);switch(f|0){case 0:{c[833]=Ui(804)|0;q=C;break a}case 1:{c[833]=Ri(804)|0;q=C;break a}default:{H=Rb(4)|0;c[H>>2]=3;ad(H|0,8,0)}}}case 15:{m=ne(u,x)|0;if((b[c[u>>2]>>1]|0)!=2){H=Rb(4)|0;c[H>>2]=6;ad(H|0,8,0)}k=de(0)|0;if((k|0)>=(c[x>>2]|0)){H=Rb(4)|0;c[H>>2]=20;ad(H|0,8,0)}f=$d()|0;if((k|0)>-1?(y=m+k|0,z=hl(y,f)|0,(z|0)!=0):0){c[833]=z-y;q=C;break a}c[833]=-1;q=C;break}case 16:{f=ce()|0;c[833]=f;if((f|0)<0){c[833]=0-f;q=C}else q=C;break}case 17:{c[833]=sl(ce()|0,ce()|0,ce()|0)|0;q=C;break}case 18:{f=ce()|0;k=de(-1)|0;if((k|0)>0)j=+(f|0)/+(k|0);else j=+(f|0)*+h[3];c[833]=~~+Ef(j);q=C;break}case 19:{f=se($d()|0)|0;k=de(0)|0;m=c[197]|0;n=c[m+808>>2]|0;if(!n){H=Rb(4)|0;c[H>>2]=3;ad(H|0,8,0)}else{c[n+40>>2]=c[m+812>>2];Qi(804,rd[c[(c[3356>>2]|0)+((b[n>>1]<<16>>16)*140|0)+28>>2]&63](n)|0);c[833]=Wi(804,f,k)|0;q=C;break a}}case 256:if((_d()|0)<-1){H=Rb(4)|0;c[H>>2]=32;ad(H|0,8,0)}else{q=$f(c[97]|0,2)|0;break a}case 257:{r=ne(s,p)|0;if((b[c[s>>2]>>1]|0)!=2){H=Rb(4)|0;c[H>>2]=6;ad(H|0,8,0)}f=ce()|0;k=ce()|0;m=Mn(r)|0;if((f|0)<0){f=m-k|0;f=(f|0)<0?0:f}p=(f|0)<(m|0)?k:0;p=(p|0)>(m|0)?m:p;q=re(p+1|0)|0;b:do if((p|0)>0){m=0;n=q;k=r+f|0;while(1){G=a[k>>0]|0;f=n+1|0;a[n>>0]=G;if(!(G<<24>>24))break b;m=m+1|0;if((m|0)>=(p|0))break;else{n=f;k=k+1|0}}}else f=q;while(0);a[f>>0]=0;break}case 259:{Pn(A,$d()|0,1024)|0;a[A+1023>>0]=0;x=D+31|0;m=1024;f=Fi(1024)|0;t=A;r=0;c:while(1){n=0;d:while(1){k=t+n|0;switch(a[k>>0]|0){case 37:case 0:{s=k;break d}default:{}}n=n+1|0}k=n+r|0;if((k|0)>=(m|0)){while(1)if((k|0)<(m|0))break;else m=m<<1;o=0;p=ra(1,f|0,m|0)|0;C=o;o=0;if(C&1){m=87;break}else{f=p;u=m}}else u=m;so(f+r|0,t|0,n|0)|0;if(!(a[s>>0]|0)){m=117;break}n=n+1|0;p=Qn(t+n|0,25342)|0;Pn(D,s,32)|0;a[x>>0]=0;m=p+2|0;if((m|0)<32)a[D+m>>0]=0;w=p+n|0;C=a[t+w>>0]|0;w=t+(w+1)|0;m=C<<24>>24;switch(C<<24>>24){case 0:{m=117;break c}case 37:{p=k+1|0;if((p|0)>=(u|0)){m=u;while(1)if((p|0)<(m|0))break;else m=m<<1;o=0;n=ra(1,f|0,m|0)|0;C=o;o=0;if(C&1){m=87;break c}else f=n}else m=u;a[f+k>>0]=37;t=w;r=p;continue c}default:{}}o=0;n=ia(9)|0;C=o;o=0;if(C&1){m=87;break}if((n|0)<-1){m=99;break}switch(m|0){case 112:case 117:case 88:case 120:case 111:case 99:case 105:case 100:{o=0;m=ra(13,c[97]|0,4)|0;C=o;o=0;if(C&1){m=87;break c}else v=4;break}case 71:case 103:case 69:case 101:case 102:{o=0;m=ra(13,c[97]|0,3)|0;C=o;o=0;if(C&1){m=87;break c}else v=3;break}case 115:{o=0;m=ra(13,c[97]|0,2)|0;C=o;o=0;if(C&1){m=87;break c}else v=2;break}default:{m=105;break c}}n=u;e:while(1){u=n-k+-1|0;t=f+k|0;s=u<<1;s=(s|0)<32?32:s;switch(v|0){case 4:{do{c[F>>2]=c[m>>2];r=en(t,u,D,F)|0;p=(r|0)>-1;if(p&(r|0)<(u|0)){m=n;n=r;break e}p=(p?r+1|0:s)+k|0}while((p|0)<(n|0));break}case 3:{do{h[G>>3]=+h[m>>3];r=en(t,u,D,G)|0;p=(r|0)>-1;if(p&(r|0)<(u|0)){m=n;n=r;break e}p=(p?r+1|0:s)+k|0}while((p|0)<(n|0));break}default:do{c[E>>2]=m;r=en(t,u,D,E)|0;p=(r|0)>-1;if(p&(r|0)<(u|0)){m=n;n=r;break e}p=(p?r+1|0:s)+k|0}while((p|0)<(n|0))}while(1)if((p|0)<(n|0)){p=n;break}else n=n<<1;o=0;n=ra(1,f|0,p|0)|0;C=o;o=0;if(C&1){m=86;break c}else{f=n;n=p}}t=w;r=n+k|0}if((m|0)==86)k=kb()|0;else if((m|0)==87)k=kb()|0;else if((m|0)==99){G=Rb(4)|0;c[G>>2]=32;o=0;na(3,G|0,8,0);o=0;m=88}else if((m|0)==105){G=Rb(4)|0;c[G>>2]=32;o=0;na(3,G|0,8,0);o=0;m=88}else if((m|0)==117){a[f+k>>0]=0;o=0;k=ma(24,k+1|0)|0;G=o;o=0;if(G&1)m=88;else{Kn(k,f)|0;Hi(f);q=k;break a}}if((m|0)==88)k=kb()|0;o=0;ja(11,f|0);G=o;o=0;if(G&1){G=kb(0)|0;Ff(G)}else qb(k|0);break}case 260:{q=c[(c[197]|0)+824>>2]|0;Pn(A,$d()|0,255)|0;jl(A,q,ce()|0);break}case 261:{m=ne(t,w)|0;if((b[c[t>>2]>>1]|0)!=2){H=Rb(4)|0;c[H>>2]=6;ad(H|0,8,0)}G=de(0)|0;k=de(32)|0;f=re((c[w>>2]|0)+1|0)|0;Kn(f,m)|0;switch(G|0){case 0:{wl(f,k);ul(f,k);q=f;break a}case 1:{wl(f,k);q=f;break a}case 2:{ul(f,k);q=f;break a}case 3:{vl(f,k);q=f;break a}default:{q=f;break a}}}case 384:{h[4]=+S(+(+ee()));q=C;break}case 385:{h[4]=+R(+(+ee()));q=C;break}case 386:{h[4]=+T(+(+ee()));q=C;break}case 387:{l=+ee();h[4]=+X(+l,+(+fe(1.0)));q=C;break}case 388:{h[4]=+P(+(+ee()));q=C;break}case 389:if((_d()|0)<-1){H=Rb(4)|0;c[H>>2]=32;ad(H|0,8,0)}else{h[4]=+h[($f(c[97]|0,3)|0)>>3];q=C;break a}case 390:{j=+ee();h[4]=j;if(j<0.0){h[4]=-j;q=C}else q=C;break}case 391:{h[4]=+Y(+(+ee()));q=C;break}case 392:{h[4]=+Z(+(+ee()));q=C;break}case 393:{l=+ee();I=+ee();j=+ee();l=l<I?I:l;h[4]=l>j?j:l;q=C;break}case 394:{I=+ee();h[4]=+Q(+I,+(+ee()));q=C;break}case 395:{j=+ee();l=+fe(1.0);if(l==1.0){h[4]=+Ef(j);q=C;break a}if(l==0.0)j=0.0;else j=+Ef(j/l);h[4]=j;q=C;break}default:{H=Rb(4)|0;c[H>>2]=21;ad(H|0,8,0)}}while(0);if(c[c[199]>>2]|0){H=Rb(4)|0;c[H>>2]=32;ad(H|0,8,0)}if((c[c[200]>>2]|0)==41){Xd();i=H;return q|0}else{H=Rb(4)|0;c[H>>2]=32;ad(H|0,8,0)}return 0}function Cf(){var a=0,b=0;Oi(804);Va(22,804,n|0)|0;c[208]=5489;a=5489;b=1;do{a=($(a>>>30^a,1812433253)|0)+b|0;c[832+(b<<2)>>2]=a;b=b+1|0}while((b|0)!=624);c[832]=0;return}function Df(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;a=c[d+4>>2]|0;g=c[d>>2]|0;h=a-g+1|0;if((a|0)==(g|0)){d=a;return d|0}if(!h){h=b+2496|0;e=c[h>>2]|0;g=((e+1|0)>>>0)%624|0;d=b+(e<<2)|0;f=c[b+(g<<2)>>2]|0;c[d>>2]=0-(f&1)&-1727483681^c[b+((((e+397|0)>>>0)%624|0)<<2)>>2]^(f&2147483646|c[d>>2]&-2147483648)>>>1;d=c[b+(c[h>>2]<<2)>>2]|0;d=d>>>11^d;c[h>>2]=g;d=d<<7&-1658038656^d;d=d<<15&-272236544^d;d=d>>>18^d;return d|0}e=32-(ba(h|0)|0)|0;e=(((-1>>>(33-e|0)&h|0)==0)<<31>>31)+e|0;e=(e>>>0)/((((e&31|0)!=0&1)+(e>>>5)|0)>>>0)|0;e=(e|0)==0?0:-1>>>(32-e|0);f=b+2496|0;g=c[f>>2]|0;do{j=g;g=((g+1|0)>>>0)%624|0;a=b+(j<<2)|0;i=c[b+(g<<2)>>2]|0;c[a>>2]=0-(i&1)&-1727483681^c[b+((((j+397|0)>>>0)%624|0)<<2)>>2]^(i&2147483646|c[a>>2]&-2147483648)>>>1;a=c[b+(c[f>>2]<<2)>>2]|0;a=a>>>11^a;c[f>>2]=g;a=a<<7&-1658038656^a;a=a<<15&-272236544^a;a=(a>>>18^a)&e}while(a>>>0>=h>>>0);j=(c[d>>2]|0)+a|0;return j|0}function Ef(a){a=+a;var b=0.0,d=0.0,e=0,f=0,g=0,j=0;g=i;i=i+16|0;e=g;j=c[834]|0;f=j&4095;if(!(j&4096)){a=a<0.0?0.0:a;if(a>1.0){e=0;b=1.0}else{e=0;b=a}}else{b=+Gm(a,e);e=~~+h[e>>3]&1}do if((c[835]|0)!=(e|0)){c[835]=e;a=+h[5];if(!e){h[7]=a;h[8]=+h[6];break}else{d=+h[6];h[7]=a+d;h[8]=-d;break}}while(0);do switch(f|0){case 1:{d=+h[7]+b*(b*+h[8]);i=g;return +d}case 2:{d=+h[7]-(b+-2.0)*(b*+h[8]);i=g;return +d}case 3:{a=b*2.0;if(a<1.0){d=+h[7]+a*(a*(+h[8]*.5));i=g;return +d}else{d=a+-1.0;d=+h[7]+(d*(d+-2.0)+-1.0)*(+h[8]*-.5);i=g;return +d}}case 4:{d=+h[7]+b*(b*(b*+h[8]));i=g;return +d}case 5:{d=b+-1.0;d=(d*(d*d)+1.0)*+h[8]+ +h[7];i=g;return +d}case 6:{a=b*2.0;if(a<1.0){d=+h[7]+a*(a*(a*(+h[8]*.5)));i=g;return +d}else{d=a+-2.0;d=+h[7]+(d*(d*d)+2.0)*(+h[8]*.5);i=g;return +d}}case 7:{d=+h[7]+b*(b*(b*(b*+h[8])));i=g;return +d}case 8:{d=b+-1.0;d=+h[7]-(d*(d*(d*d))+-1.0)*+h[8];i=g;return +d}case 9:{a=b*2.0;if(a<1.0){d=+h[7]+a*(a*(a*(a*(+h[8]*.5))));i=g;return +d}else{d=a+-2.0;d=+h[7]+(d*(d*(d*d))+-2.0)*(+h[8]*-.5);i=g;return +d}}case 10:{a=1.0-b;b=+h[8];do if(!(a<.36363636363636365)){if(a<.7272727272727273){a=a+-.5454545454545454;a=a*(a*7.5625)+.75;break}if(a<.9090909090909091){a=a+-.8181818181818182;a=a*(a*7.5625)+.9375;break}else{a=a+-.9545454545454546;a=a*(a*7.5625)+.984375;break}}else a=a*(a*7.5625);while(0);d=+h[7]+(b-b*a);i=g;return +d}case 11:{do if(!(b<.36363636363636365)){if(b<.7272727272727273){a=b+-.5454545454545454;a=(a*(a*7.5625)+.75)*+h[8];break}a=+h[8];if(b<.9090909090909091){d=b+-.8181818181818182;a=(d*(d*7.5625)+.9375)*a;break}else{d=b+-.9545454545454546;a=(d*(d*7.5625)+.984375)*a;break}}else a=b*(b*7.5625)*+h[8];while(0);d=a+ +h[7];i=g;return +d}case 12:{a=b*2.0;if(b<.5){a=1.0-a;b=+h[8];do if(!(a<.36363636363636365)){if(a<.7272727272727273){a=a+-.5454545454545454;a=a*(a*7.5625)+.75;break}if(a<.9090909090909091){a=a+-.8181818181818182;a=a*(a*7.5625)+.9375;break}else{a=a+-.9545454545454546;a=a*(a*7.5625)+.984375;break}}else a=a*(a*7.5625);while(0);d=+h[7]+(b-b*a)*.5;i=g;return +d}else{a=a+-1.0;do if(!(a<.36363636363636365)){if(a<.7272727272727273){d=+h[8];b=a+-.5454545454545454;b=(b*(b*7.5625)+.75)*d;a=d;break}d=+h[8];if(a<.9090909090909091){b=a+-.8181818181818182;b=(b*(b*7.5625)+.9375)*d;a=d;break}else{b=a+-.9545454545454546;b=(b*(b*7.5625)+.984375)*d;a=d;break}}else{d=+h[8];b=a*(a*7.5625)*d;a=d}while(0);d=+h[7]+(a*.5+b*.5);i=g;return +d}}case 13:{b=1.0-b;d=+h[8];a=b*b*8.0;j=~~a;a=a-+(j|0);d=+h[7]+(b*(((j&1|0)==0?a:1.0-a)*d)-b*(d*.5));i=g;return +d}case 14:{d=+h[8];a=b*b*8.0;j=~~a;a=a-+(j|0);d=+h[7]+(b*(((j&1|0)==0?a:1.0-a)*d)-b*(d*.5));i=g;return +d}case 15:{a=b*2.0;if(a<1.0){b=1.0-a;d=+h[8];a=b*b*8.0;j=~~a;a=a-+(j|0);d=+h[7]+(b*(((j&1|0)==0?a:1.0-a)*d)-b*(d*.5));i=g;return +d}else{b=a+-1.0;d=+h[8];a=b*b*8.0;j=~~a;a=a-+(j|0);d=+h[7]+(b*(((j&1|0)==0?a:1.0-a)*d)-b*(d*.5));i=g;return +d}}default:{d=b*+h[8]+ +h[7];i=g;return +d}}while(0);return 0.0}function Ff(a){a=a|0;ec(a|0)|0;Ml()}function Gf(a,b){a=a|0;b=b|0;var d=0.0,e=0.0;d=+h[a>>3];e=+h[b>>3];if(d<e){b=1;return b|0}if(!(d!=d|e!=e|d==e)){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Hf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+16|0;p=q;a:while(1){m=b;n=b+-16|0;b:while(1){l=a;e=m-l|0;f=e>>4;switch(f|0){case 2:{e=n;b=n;o=4;break a}case 3:{g=n;f=n;o=6;break a}case 4:{b=n;o=14;break a}case 5:{h=n;g=n;o=15;break a}case 1:case 0:{o=69;break a}default:{}}if((e|0)<496){o=21;break a}g=(f|0)/2|0;k=a+(g<<4)|0;do if((e|0)>15984){e=(f|0)/4|0;h=a+(e<<4)|0;e=a+(e+g<<4)|0;f=Nf(a,h,k,e,d)|0;if(wd[c[d>>2]&31](n,e)|0){c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[n>>2];c[e+4>>2]=c[n+4>>2];c[e+8>>2]=c[n+8>>2];c[e+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];g=f+1|0;if(wd[c[d>>2]&31](e,k)|0){c[p>>2]=c[k>>2];c[p+4>>2]=c[k+4>>2];c[p+8>>2]=c[k+8>>2];c[p+12>>2]=c[k+12>>2];c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];c[k+8>>2]=c[e+8>>2];c[k+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];e=f+2|0;if(wd[c[d>>2]&31](k,h)|0){c[p>>2]=c[h>>2];c[p+4>>2]=c[h+4>>2];c[p+8>>2]=c[h+8>>2];c[p+12>>2]=c[h+12>>2];c[h>>2]=c[k>>2];c[h+4>>2]=c[k+4>>2];c[h+8>>2]=c[k+8>>2];c[h+12>>2]=c[k+12>>2];c[k>>2]=c[p>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[k+12>>2]=c[p+12>>2];if(wd[c[d>>2]&31](h,a)|0){c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[h>>2];c[a+4>>2]=c[h+4>>2];c[a+8>>2]=c[h+8>>2];c[a+12>>2]=c[h+12>>2];c[h>>2]=c[p>>2];c[h+4>>2]=c[p+4>>2];c[h+8>>2]=c[p+8>>2];c[h+12>>2]=c[p+12>>2];f=f+4|0}else f=f+3|0}else f=e}else f=g}}else{j=wd[c[d>>2]&31](k,a)|0;e=wd[c[d>>2]&31](n,k)|0;if(!j){if(!e){f=0;break};c[p>>2]=c[k>>2];c[p+4>>2]=c[k+4>>2];c[p+8>>2]=c[k+8>>2];c[p+12>>2]=c[k+12>>2];c[k>>2]=c[n>>2];c[k+4>>2]=c[n+4>>2];c[k+8>>2]=c[n+8>>2];c[k+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];if(!(wd[c[d>>2]&31](k,a)|0)){f=1;break};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[k>>2];c[a+4>>2]=c[k+4>>2];c[a+8>>2]=c[k+8>>2];c[a+12>>2]=c[k+12>>2];c[k>>2]=c[p>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[k+12>>2]=c[p+12>>2];f=2;break}if(e){c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[n>>2];c[a+4>>2]=c[n+4>>2];c[a+8>>2]=c[n+8>>2];c[a+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];f=1;break};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[k>>2];c[a+4>>2]=c[k+4>>2];c[a+8>>2]=c[k+8>>2];c[a+12>>2]=c[k+12>>2];c[k>>2]=c[p>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[k+12>>2]=c[p+12>>2];if(wd[c[d>>2]&31](n,k)|0){c[p>>2]=c[k>>2];c[p+4>>2]=c[k+4>>2];c[p+8>>2]=c[k+8>>2];c[p+12>>2]=c[k+12>>2];c[k>>2]=c[n>>2];c[k+4>>2]=c[n+4>>2];c[k+8>>2]=c[n+8>>2];c[k+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];f=2}else f=1}while(0);do if(wd[c[d>>2]&31](a,k)|0)g=n;else{e=n;while(1){e=e+-16|0;if((a|0)==(e|0))break;if(wd[c[d>>2]&31](e,k)|0){o=51;break}}if((o|0)==51){o=0;c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];g=e;f=f+1|0;break}e=a+16|0;if(!(wd[c[d>>2]&31](a,n)|0)){if((e|0)==(n|0)){o=69;break a}else f=a;while(1){if(wd[c[d>>2]&31](a,e)|0)break;f=e+16|0;if((f|0)==(n|0)){o=69;break a}else{l=e;e=f;f=l}}c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[n>>2];c[e+4>>2]=c[n+4>>2];c[e+8>>2]=c[n+8>>2];c[e+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];e=f+32|0}if((e|0)==(n|0)){o=69;break a}else f=n;while(1){g=e;while(1){e=g+16|0;if(wd[c[d>>2]&31](a,g)|0)break;else g=e}do f=f+-16|0;while(wd[c[d>>2]&31](a,f)|0);if(g>>>0>=f>>>0){a=g;continue b};c[p>>2]=c[g>>2];c[p+4>>2]=c[g+4>>2];c[p+8>>2]=c[g+8>>2];c[p+12>>2]=c[g+12>>2];c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2]}}while(0);e=a+16|0;c:do if(e>>>0<g>>>0){j=g;while(1){g=e;while(1){e=g+16|0;if(wd[c[d>>2]&31](g,k)|0)g=e;else{h=g;break}}g=j;do g=g+-16|0;while(!(wd[c[d>>2]&31](g,k)|0));if(h>>>0>g>>>0){e=h;g=k;break c};c[p>>2]=c[h>>2];c[p+4>>2]=c[h+4>>2];c[p+8>>2]=c[h+8>>2];c[p+12>>2]=c[h+12>>2];c[h>>2]=c[g>>2];c[h+4>>2]=c[g+4>>2];c[h+8>>2]=c[g+8>>2];c[h+12>>2]=c[g+12>>2];c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[g+12>>2]=c[p+12>>2];j=g;k=(k|0)==(h|0)?g:k;f=f+1|0}}else g=k;while(0);if((e|0)!=(g|0)?wd[c[d>>2]&31](g,e)|0:0){c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[g>>2];c[e+4>>2]=c[g+4>>2];c[e+8>>2]=c[g+8>>2];c[e+12>>2]=c[g+12>>2];c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[g+12>>2]=c[p+12>>2];f=f+1|0}if(!f){f=Pf(a,e,d)|0;g=e+16|0;if(Pf(g,b,d)|0){o=64;break}if(f){a=g;continue}}k=e;if((k-l|0)>=(m-k|0)){o=68;break}Hf(a,e,d);a=e+16|0}if((o|0)==64){o=0;if(f){o=69;break}else{b=e;continue}}else if((o|0)==68){o=0;Hf(e+16|0,b,d);b=e;continue}}if((o|0)==4){if(!(wd[c[d>>2]&31](e,a)|0)){i=q;return};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[p>>2];c[b+4>>2]=c[p+4>>2];c[b+8>>2]=c[p+8>>2];c[b+12>>2]=c[p+12>>2];i=q;return}else if((o|0)==6){e=a+16|0;o=wd[c[d>>2]&31](e,a)|0;b=wd[c[d>>2]&31](g,e)|0;if(!o){if(!b){i=q;return};c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2];if(!(wd[c[d>>2]&31](e,a)|0)){i=q;return};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];i=q;return}if(b){c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2];i=q;return};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];if(!(wd[c[d>>2]&31](g,e)|0)){i=q;return};c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2];i=q;return}else if((o|0)==14){Nf(a,a+16|0,a+32|0,b,d)|0;i=q;return}else if((o|0)==15){b=a+16|0;e=a+32|0;f=a+48|0;Nf(a,b,e,f,d)|0;if(!(wd[c[d>>2]&31](h,f)|0)){i=q;return};c[p>>2]=c[f>>2];c[p+4>>2]=c[f+4>>2];c[p+8>>2]=c[f+8>>2];c[p+12>>2]=c[f+12>>2];c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[g+12>>2]=c[p+12>>2];if(!(wd[c[d>>2]&31](f,e)|0)){i=q;return};c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2];if(!(wd[c[d>>2]&31](e,b)|0)){i=q;return};c[p>>2]=c[b>>2];c[p+4>>2]=c[b+4>>2];c[p+8>>2]=c[b+8>>2];c[p+12>>2]=c[b+12>>2];c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];if(!(wd[c[d>>2]&31](b,a)|0)){i=q;return};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[p>>2];c[b+4>>2]=c[p+4>>2];c[b+8>>2]=c[p+8>>2];c[b+12>>2]=c[p+12>>2];i=q;return}else if((o|0)==21){Of(a,b,d);i=q;return}else if((o|0)==69){i=q;return}}function If(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0;f=+h[a>>3];e=+h[b>>3];d=f<e?-1:f>e&1;if((d|0)>0){b=1;return b|0}if(d){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Jf(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a>>2]|0;e=c[b>>2]|0;if((d|0)<(e|0)){b=1;return b|0}if((d|0)!=(e|0)){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Kf(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a>>2]|0;e=c[b>>2]|0;if((d|0)>(e|0)){b=1;return b|0}if((d|0)!=(e|0)){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Lf(a,b){a=a|0;b=b|0;var d=0;d=Jn(c[a>>2]|0,c[b>>2]|0)|0;if((d|0)<0){b=1;return b|0}if(d){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Mf(a,b){a=a|0;b=b|0;var d=0;d=Jn(c[a>>2]|0,c[b>>2]|0)|0;if((d|0)>0){b=1;return b|0}if(d){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Nf(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;j=i;i=i+16|0;h=j;k=wd[c[f>>2]&31](b,a)|0;g=wd[c[f>>2]&31](d,b)|0;do if(k){if(g){c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];g=1;break};c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];if(wd[c[f>>2]&31](d,b)|0){c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[h+12>>2]=c[b+12>>2];c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];g=2}else g=1}else if(g){c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[h+12>>2]=c[b+12>>2];c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];if(wd[c[f>>2]&31](b,a)|0){c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];g=2}else g=1}else g=0;while(0);if(!(wd[c[f>>2]&31](e,d)|0)){k=g;i=j;return k|0};c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];if(!(wd[c[f>>2]&31](d,b)|0)){k=g+1|0;i=j;return k|0};c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[h+12>>2]=c[b+12>>2];c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];if(!(wd[c[f>>2]&31](b,a)|0)){k=g+2|0;i=j;return k|0};c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];k=g+3|0;i=j;return k|0}function Of(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;k=i;i=i+32|0;h=k+16|0;j=k;e=a+32|0;f=a+16|0;l=wd[c[d>>2]&31](f,a)|0;g=wd[c[d>>2]&31](e,f)|0;do if(l){if(g){c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];break};c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];if(wd[c[d>>2]&31](e,f)|0){c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2]}}else if(g?(c[h>>2]=c[f>>2],c[h+4>>2]=c[f+4>>2],c[h+8>>2]=c[f+8>>2],c[h+12>>2]=c[f+12>>2],c[f>>2]=c[e>>2],c[f+4>>2]=c[e+4>>2],c[f+8>>2]=c[e+8>>2],c[f+12>>2]=c[e+12>>2],c[e>>2]=c[h>>2],c[e+4>>2]=c[h+4>>2],c[e+8>>2]=c[h+8>>2],c[e+12>>2]=c[h+12>>2],wd[c[d>>2]&31](f,a)|0):0){c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2]}while(0);f=a+48|0;if((f|0)==(b|0)){i=k;return}while(1){if(wd[c[d>>2]&31](f,e)|0){c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];g=f;while(1){c[g>>2]=c[e>>2];c[g+4>>2]=c[e+4>>2];c[g+8>>2]=c[e+8>>2];c[g+12>>2]=c[e+12>>2];if((e|0)==(a|0))break;g=e+-16|0;if(wd[c[d>>2]&31](j,g)|0){l=e;e=g;g=l}else break}c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2]}e=f+16|0;if((e|0)==(b|0))break;else{l=f;f=e;e=l}}i=k;return}function Pf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;j=m+16|0;k=m;switch(b-a>>4|0){case 2:{e=b+-16|0;if(!(wd[c[d>>2]&31](e,a)|0)){a=1;i=m;return a|0};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];a=1;i=m;return a|0}case 3:{g=a+16|0;f=b+-16|0;b=wd[c[d>>2]&31](g,a)|0;e=wd[c[d>>2]&31](f,g)|0;if(!b){if(!e){a=1;i=m;return a|0};c[j>>2]=c[g>>2];c[j+4>>2]=c[g+4>>2];c[j+8>>2]=c[g+8>>2];c[j+12>>2]=c[g+12>>2];c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];if(!(wd[c[d>>2]&31](g,a)|0)){a=1;i=m;return a|0};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];c[a+8>>2]=c[g+8>>2];c[a+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];a=1;i=m;return a|0}if(e){c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];a=1;i=m;return a|0};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];c[a+8>>2]=c[g+8>>2];c[a+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];if(!(wd[c[d>>2]&31](f,g)|0)){a=1;i=m;return a|0};c[j>>2]=c[g>>2];c[j+4>>2]=c[g+4>>2];c[j+8>>2]=c[g+8>>2];c[j+12>>2]=c[g+12>>2];c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];a=1;i=m;return a|0}case 4:{Nf(a,a+16|0,a+32|0,b+-16|0,d)|0;a=1;i=m;return a|0}case 5:{f=a+16|0;g=a+32|0;h=a+48|0;e=b+-16|0;Nf(a,f,g,h,d)|0;if(!(wd[c[d>>2]&31](e,h)|0)){a=1;i=m;return a|0};c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];c[j+12>>2]=c[h+12>>2];c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];if(!(wd[c[d>>2]&31](h,g)|0)){a=1;i=m;return a|0};c[j>>2]=c[g>>2];c[j+4>>2]=c[g+4>>2];c[j+8>>2]=c[g+8>>2];c[j+12>>2]=c[g+12>>2];c[g>>2]=c[h>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];c[g+12>>2]=c[h+12>>2];c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];if(!(wd[c[d>>2]&31](g,f)|0)){a=1;i=m;return a|0};c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];if(!(wd[c[d>>2]&31](f,a)|0)){a=1;i=m;return a|0};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];a=1;i=m;return a|0}case 1:case 0:{a=1;i=m;return a|0}default:{g=a+32|0;e=a+16|0;h=wd[c[d>>2]&31](e,a)|0;f=wd[c[d>>2]&31](g,e)|0;do if(h){if(f){c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];c[a+8>>2]=c[g+8>>2];c[a+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];break};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];if(wd[c[d>>2]&31](g,e)|0){c[j>>2]=c[e>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2];c[j+12>>2]=c[e+12>>2];c[e>>2]=c[g>>2];c[e+4>>2]=c[g+4>>2];c[e+8>>2]=c[g+8>>2];c[e+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2]}}else if(f?(c[j>>2]=c[e>>2],c[j+4>>2]=c[e+4>>2],c[j+8>>2]=c[e+8>>2],c[j+12>>2]=c[e+12>>2],c[e>>2]=c[g>>2],c[e+4>>2]=c[g+4>>2],c[e+8>>2]=c[g+8>>2],c[e+12>>2]=c[g+12>>2],c[g>>2]=c[j>>2],c[g+4>>2]=c[j+4>>2],c[g+8>>2]=c[j+8>>2],c[g+12>>2]=c[j+12>>2],wd[c[d>>2]&31](e,a)|0):0){c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2]}while(0);e=a+48|0;if((e|0)==(b|0)){a=1;i=m;return a|0}f=0;while(1){if(wd[c[d>>2]&31](e,g)|0){c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];c[k+8>>2]=c[e+8>>2];c[k+12>>2]=c[e+12>>2];h=e;while(1){c[h>>2]=c[g>>2];c[h+4>>2]=c[g+4>>2];c[h+8>>2]=c[g+8>>2];c[h+12>>2]=c[g+12>>2];if((g|0)==(a|0))break;h=g+-16|0;if(wd[c[d>>2]&31](k,h)|0){j=g;g=h;h=j}else break}c[g>>2]=c[k>>2];c[g+4>>2]=c[k+4>>2];c[g+8>>2]=c[k+8>>2];c[g+12>>2]=c[k+12>>2];f=f+1|0;if((f|0)==8)break}g=e+16|0;if((g|0)==(b|0)){e=1;l=35;break}else{j=e;e=g;g=j}}if((l|0)==35){i=m;return e|0}a=(e+16|0)==(b|0);i=m;return a|0}}return 0}function Qf(){var a=0;a=Fi(1120)|0;c[839]=a;c[840]=8;b[a>>1]=0;b[a+140>>1]=0;b[a+280>>1]=0;b[a+420>>1]=0;b[a+560>>1]=0;b[a+700>>1]=0;b[a+840>>1]=0;b[a+980>>1]=0;a=Fi(384)|0;c[838]=a;b[a+2>>1]=-1;b[a>>1]=4;b[a+50>>1]=-1;b[a+48>>1]=4;b[a+98>>1]=-1;b[a+96>>1]=4;b[a+146>>1]=-1;b[a+144>>1]=4;b[a+194>>1]=-1;b[a+192>>1]=4;b[a+242>>1]=-1;b[a+240>>1]=4;b[a+290>>1]=-1;b[a+288>>1]=4;b[a+338>>1]=-1;b[a+336>>1]=4;return}function Rf(){var a=0,d=0,e=0,f=0;a=c[840]|0;if((a|0)>0)e=0;else{e=c[838]|0;Hi(e);e=c[839]|0;Hi(e);return}do{f=c[838]|0;d=f+(e*48|0)|0;if((b[f+(e*48|0)+2>>1]|0)==1){od[c[(c[3356>>2]|0)+((b[d>>1]<<16>>16)*140|0)+52>>2]&63](d);a=c[840]|0}e=e+1|0}while((e|0)<(a|0));f=c[838]|0;Hi(f);f=c[839]|0;Hi(f);return}
function Gk(e,f,h,j,k){e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0.0;la=i;i=i+32528|0;ca=la+14008|0;W=la+13992|0;V=la;c[ca>>2]=e;ia=Jk(ca,1)|0;x=e+176|0;l=c[x>>2]|0;ja=e+168|0;c[ja>>2]=l;if(ia){c[V>>2]=e;a:do if(k>>>0<=4){c[e+8>>2]=0;R=V+13984|0;c[R>>2]=0;b:do if(Jk(V,0)|0){P=V+13956|0;l=a[P>>0]|0;c:do if(l<<24>>24==-1){o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0)){l=-1;break c}l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0;break}else{c[q>>2]=l;c[p>>2]=o+40+n;break}}while(0);c[q>>2]=l+1;if((a[l>>0]|0)==-1)do{o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0))l=0;else{l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0}else{c[q>>2]=l;c[p>>2]=o+40+n}c[q>>2]=l+1;l=d[l>>0]|0}}else{c[q>>2]=l+1;l=d[l>>0]|0}l=l&255}while(l<<24>>24==-1);else l=-1}else a[P>>0]=-1;while(0);E=V+13964|0;F=V+13952|0;G=V+13948|0;H=V+13960|0;I=V+13860|0;J=V+13804|0;K=V+13748|0;L=V+13988|0;M=V+13968|0;N=V+13712|0;O=V+13708|0;d:while(1){l=l&255;e:do switch(l|0){case 217:{ka=197;break d}case 218:{p=c[V>>2]|0;r=p+168|0;m=c[r>>2]|0;q=p+172|0;l=c[q>>2]|0;if(m>>>0>=l>>>0){n=p+32|0;if(!(c[n>>2]|0))o=0;else{l=p+40|0;m=jd[c[p+16>>2]&15](c[p+28>>2]|0,l,c[p+36>>2]|0)|0;if(!m){c[n>>2]=0;n=(c[q>>2]|0)+-1|0;c[r>>2]=n;a[n>>0]=0;n=c[q>>2]|0;l=c[r>>2]|0}else{c[r>>2]=l;n=p+40+m|0;c[q>>2]=n}m=l+1|0;c[r>>2]=m;o=d[l>>0]|0;l=n}}else{e=m+1|0;c[r>>2]=e;o=d[m>>0]|0;m=e}o=o<<8;if(m>>>0>=l>>>0){m=p+32|0;if(!(c[m>>2]|0))l=0;else{l=p+40|0;n=jd[c[p+16>>2]&15](c[p+28>>2]|0,l,c[p+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[q>>2]|0)+-1|0;c[r>>2]=l;a[l>>0]=0;l=c[r>>2]|0}else{c[r>>2]=l;c[q>>2]=p+40+n}c[r>>2]=l+1;l=d[l>>0]|0}}else{c[r>>2]=m+1;l=d[m>>0]|0}r=l|o;o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0)){ka=39;break d}l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0;break}else{c[q>>2]=l;c[p>>2]=o+40+n;break}}while(0);c[q>>2]=l+1;e=a[l>>0]|0;l=e&255;c[E>>2]=l;if((e+-1&255)>3)break d;m=c[V>>2]|0;if((l|0)>(c[m+8>>2]|0))break d;if((r|0)==((l<<1)+6|0))s=0;else{ka=47;break d}while(1){r=(s|0)<(l|0);q=m+168|0;l=c[q>>2]|0;p=m+172|0;if(l>>>0>=(c[p>>2]|0)>>>0){n=m+32|0;if(!(c[n>>2]|0))l=0;else{l=m+40|0;o=jd[c[m+16>>2]&15](c[m+28>>2]|0,l,c[m+36>>2]|0)|0;if(!o){c[n>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0}else{c[q>>2]=l;c[p>>2]=m+40+o}c[q>>2]=l+1;l=d[l>>0]|0}}else{c[q>>2]=l+1;l=d[l>>0]|0}if(!r)break;q=c[V>>2]|0;r=q+168|0;m=c[r>>2]|0;p=q+172|0;do if(m>>>0<(c[p>>2]|0)>>>0){c[r>>2]=m+1;o=d[m>>0]|0;m=q}else{n=q+32|0;if(!(c[n>>2]|0)){o=0;m=q;break}m=q+40|0;o=jd[c[q+16>>2]&15](c[q+28>>2]|0,m,c[q+36>>2]|0)|0;if(!o){c[n>>2]=0;m=(c[p>>2]|0)+-1|0;c[r>>2]=m;a[m>>0]=0;m=c[r>>2]|0}else{c[r>>2]=m;c[p>>2]=q+40+o}c[r>>2]=m+1;o=d[m>>0]|0;m=c[V>>2]|0}while(0);n=c[m+8>>2]|0;f:do if((n|0)>0){m=0;while(1){if((c[V+13724+(m*56|0)>>2]|0)==(l|0)){l=m;break f}m=m+1|0;if((m|0)>=(n|0)){l=m;break}}}else l=0;while(0);if((l|0)==(n|0))break b;c[V+13724+(l*56|0)+16>>2]=o>>>4;if(o>>>0>63){ka=68;break d}e=o&15;c[V+13724+(l*56|0)+20>>2]=e;if(e>>>0>3){ka=70;break d}c[V+13968+(s<<2)>>2]=l;l=c[E>>2]|0;m=c[V>>2]|0;s=s+1|0}if(l){ka=73;break d}n=c[V>>2]|0;q=n+168|0;m=c[q>>2]|0;o=n+172|0;l=c[o>>2]|0;if(m>>>0>=l>>>0){p=n+32|0;if(!(c[p>>2]|0))q=n;else{l=n+40|0;m=jd[c[n+16>>2]&15](c[n+28>>2]|0,l,c[n+36>>2]|0)|0;if(!m){c[p>>2]=0;l=(c[o>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0}else{c[q>>2]=l;c[o>>2]=n+40+m}c[q>>2]=l+1;l=c[V>>2]|0;q=l;m=c[l+168>>2]|0;l=c[l+172>>2]|0}}else{m=m+1|0;c[q>>2]=m;q=n}o=q+168|0;p=q+172|0;do if(m>>>0>=l>>>0){n=q+32|0;if(c[n>>2]|0){l=q+40|0;m=jd[c[q+16>>2]&15](c[q+28>>2]|0,l,c[q+36>>2]|0)|0;if(!m){c[n>>2]=0;T=(c[p>>2]|0)+-1|0;c[o>>2]=T;a[T>>0]=0;T=c[o>>2]|0;ka=86;break}else{c[o>>2]=l;c[p>>2]=q+40+m;T=l;ka=86;break}}}else{T=m;ka=86}while(0);if((ka|0)==86?(ka=0,c[o>>2]=T+1,(a[T>>0]|0)!=0):0){ka=87;break d}c[F>>2]=0;c[G>>2]=0;c[H>>2]=0;c[I>>2]=0;c[J>>2]=0;c[K>>2]=0;a[P>>0]=-1;m=c[R>>2]|0;m=(m|0)==0?2147483647:m;c[L>>2]=m;g:do if((c[E>>2]|0)==1){r=c[M>>2]|0;s=(c[V+13724+(r*56|0)+28>>2]|0)+7>>3;v=(c[V+13724+(r*56|0)+32>>2]|0)+7>>3;h:do if((v|0)>0){w=(s|0)>0;x=V+13724+(r*56|0)+16|0;y=V+13724+(r*56|0)+20|0;z=V+13724+(r*56|0)+44|0;A=V+13724+(r*56|0)+36|0;B=V+13724+(r*56|0)+12|0;D=0;i:while(1){if(w){C=0;do{if(!(Uk(V,ca,V+4+((c[x>>2]|0)*1680|0)|0,V+6724+((c[y>>2]|0)*1680|0)|0,r)|0)){l=0;break i}e=c[A>>2]|0;ja=(c[z>>2]|0)+(($(e,D)|0)+C<<3)|0;Vk(ja,e,ca,V+13444+(c[B>>2]<<6)|0);e=c[L>>2]|0;c[L>>2]=e+-1;if((e|0)<2){j:do if((c[F>>2]|0)<24){k:while(1){l:do if(!(c[H>>2]|0)){o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0)){l=0;break l}l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0;break}else{c[q>>2]=l;c[p>>2]=o+40+n;break}}while(0);c[q>>2]=l+1;l=a[l>>0]|0;if(l<<24>>24!=-1){l=l&255;break}o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0)){l=255;break l}l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0;break}else{c[q>>2]=l;c[p>>2]=o+40+n;break}}while(0);c[q>>2]=l+1;l=a[l>>0]|0;if(!(l<<24>>24))l=255;else break k}else l=0;while(0);e=c[F>>2]|0;c[G>>2]=l<<24-e|c[G>>2];e=e+8|0;c[F>>2]=e;if((e|0)>=25)break j}a[P>>0]=l;c[H>>2]=1}while(0);if((a[P>>0]&-8)<<24>>24!=-48){l=1;break i}c[F>>2]=0;c[G>>2]=0;c[H>>2]=0;c[I>>2]=0;c[J>>2]=0;c[K>>2]=0;a[P>>0]=-1;e=c[R>>2]|0;c[L>>2]=(e|0)==0?2147483647:e}C=C+1|0}while((C|0)<(s|0))}D=D+1|0;if((D|0)>=(v|0))break h}S=l;ka=153;break g}while(0)}else{l=c[N>>2]|0;m:do if((l|0)>0){n=c[O>>2]|0;B=0;n:while(1){if((n|0)>0){A=0;do{l=c[E>>2]|0;if((l|0)>0){z=0;do{x=c[V+13968+(z<<2)>>2]|0;y=V+13724+(x*56|0)+8|0;m=c[y>>2]|0;if((m|0)>0){p=V+13724+(x*56|0)+4|0;q=V+13724+(x*56|0)+16|0;r=V+13724+(x*56|0)+20|0;s=V+13724+(x*56|0)+44|0;v=V+13724+(x*56|0)+36|0;w=V+13724+(x*56|0)+12|0;l=c[p>>2]|0;o=0;do{if((l|0)>0){n=0;do{if(!(Uk(V,ca,V+4+((c[q>>2]|0)*1680|0)|0,V+6724+((c[r>>2]|0)*1680|0)|0,x)|0)){l=0;break n}m=($(m,B)|0)+o|0;e=($(l,A)|0)+n|0;l=c[v>>2]|0;m=(c[s>>2]|0)+(e+($(l,m)|0)<<3)|0;Vk(m,l,ca,V+13444+(c[w>>2]<<6)|0);n=n+1|0;l=c[p>>2]|0;m=c[y>>2]|0}while((n|0)<(l|0))}o=o+1|0}while((o|0)<(m|0));l=c[E>>2]|0}z=z+1|0}while((z|0)<(l|0));m=c[L>>2]|0}l=m+-1|0;c[L>>2]=l;if((m|0)<2){o:do if((c[F>>2]|0)<24){p:while(1){q:do if(!(c[H>>2]|0)){o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0)){l=0;break q}l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0;break}else{c[q>>2]=l;c[p>>2]=o+40+n;break}}while(0);c[q>>2]=l+1;l=a[l>>0]|0;if(l<<24>>24!=-1){l=l&255;break}o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0)){l=255;break q}l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0;break}else{c[q>>2]=l;c[p>>2]=o+40+n;break}}while(0);c[q>>2]=l+1;l=a[l>>0]|0;if(!(l<<24>>24))l=255;else break p}else l=0;while(0);e=c[F>>2]|0;c[G>>2]=l<<24-e|c[G>>2];e=e+8|0;c[F>>2]=e;if((e|0)>=25)break o}a[P>>0]=l;c[H>>2]=1}while(0);if((a[P>>0]&-8)<<24>>24!=-48){l=1;break n}c[F>>2]=0;c[G>>2]=0;c[H>>2]=0;c[I>>2]=0;c[J>>2]=0;c[K>>2]=0;a[P>>0]=-1;m=c[R>>2]|0;m=(m|0)==0?2147483647:m;c[L>>2]=m}else m=l;A=A+1|0;n=c[O>>2]|0}while((A|0)<(n|0));l=c[N>>2]|0}B=B+1|0;if((B|0)>=(l|0))break m}S=l;ka=153;break g}while(0)}while(0);if((ka|0)==153?(ka=0,(S|0)==0):0)break b;l=a[P>>0]|0;if(l<<24>>24==-1){r:while(1){l=c[V>>2]|0;do if(c[l+16>>2]|0){if(!(rd[c[l+24>>2]&63](c[l+28>>2]|0)|0))break;if(!(c[l+32>>2]|0)){ka=174;break e}else ka=158}else ka=158;while(0);if((ka|0)==158?(ka=0,(c[l+168>>2]|0)>>>0>=(c[l+172>>2]|0)>>>0):0){ka=174;break e}o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0))continue r;l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0;break}else{c[q>>2]=l;c[p>>2]=o+40+n;break}}while(0);c[q>>2]=l+1;switch(d[l>>0]|0){case 0:break;case 255:break r;default:break b}}o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0<(c[p>>2]|0)>>>0){c[q>>2]=l+1;l=d[l>>0]|0}else{m=o+32|0;if(!(c[m>>2]|0)){l=0;break}l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0}else{c[q>>2]=l;c[p>>2]=o+40+n}c[q>>2]=l+1;l=d[l>>0]|0}while(0);l=l&255;a[P>>0]=l;ka=175}break}default:if(!(Qk(V,l)|0))break b;else ka=174}while(0);if((ka|0)==174){l=a[P>>0]|0;ka=175}if((ka|0)==175){ka=0;if(l<<24>>24==-1){o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;do if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0)){l=-1;continue d}l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0;break}else{c[q>>2]=l;c[p>>2]=o+40+n;break}}while(0);c[q>>2]=l+1;if((a[l>>0]|0)!=-1){l=-1;continue}while(1){o=c[V>>2]|0;q=o+168|0;l=c[q>>2]|0;p=o+172|0;if(l>>>0>=(c[p>>2]|0)>>>0){m=o+32|0;if(!(c[m>>2]|0))l=0;else{l=o+40|0;n=jd[c[o+16>>2]&15](c[o+28>>2]|0,l,c[o+36>>2]|0)|0;if(!n){c[m>>2]=0;l=(c[p>>2]|0)+-1|0;c[q>>2]=l;a[l>>0]=0;l=c[q>>2]|0}else{c[q>>2]=l;c[p>>2]=o+40+n}c[q>>2]=l+1;l=d[l>>0]|0}}else{c[q>>2]=l+1;l=d[l>>0]|0}l=l&255;if(l<<24>>24!=-1)continue d}}}a[P>>0]=-1}if((ka|0)==39)c[E>>2]=0;else if((ka|0)==47){c[5682]=31784;break}else if((ka|0)==68){c[5682]=31796;break}else if((ka|0)==70){c[5682]=31808;break}else if((ka|0)==73){c[5682]=31820;break}else if((ka|0)==87){c[5682]=31820;break}else if((ka|0)==197){m=c[V>>2]|0;y=c[m+8>>2]|0;z=(k|0)==0?y:k;y=(y|0)==3&(z|0)<3?1:y;A=(y|0)>0;s:do if(A){q=V+13700|0;r=V+13704|0;l=c[m>>2]|0;p=0;while(1){o=ca+(p<<5)|0;e=fo(l+3|0)|0;c[V+13724+(p*56|0)+52>>2]=e;if(!e)break;e=(c[q>>2]|0)/(c[V+13724+(p*56|0)+4>>2]|0)|0;c[ca+(p<<5)+12>>2]=e;n=(c[r>>2]|0)/(c[V+13724+(p*56|0)+8>>2]|0)|0;c[ca+(p<<5)+16>>2]=n;c[ca+(p<<5)+24>>2]=n>>1;m=c[V>>2]|0;l=c[m>>2]|0;c[ca+(p<<5)+20>>2]=((e+-1+l|0)>>>0)/(e>>>0)|0;c[ca+(p<<5)+28>>2]=0;ja=c[V+13724+(p*56|0)+44>>2]|0;c[ca+(p<<5)+8>>2]=ja;c[ca+(p<<5)+4>>2]=ja;t:do switch(e|0){case 1:switch(n|0){case 1:{c[o>>2]=1;break t}case 2:{c[o>>2]=2;break t}default:{ka=215;break t}}case 2:switch(n|0){case 1:{c[o>>2]=3;break t}case 2:{c[o>>2]=4;break t}default:{ka=215;break t}}default:ka=215}while(0);if((ka|0)==215){ka=0;c[o>>2]=5}p=p+1|0;if((p|0)>=(y|0)){ka=217;break s}}if((c[(c[V>>2]|0)+8>>2]|0)>0){n=0;do{l=V+13724+(n*56|0)+44|0;if(c[l>>2]|0){go(c[V+13724+(n*56|0)+48>>2]|0);c[l>>2]=0}l=V+13724+(n*56|0)+52|0;m=c[l>>2]|0;if(m){go(m);c[l>>2]=0}n=n+1|0}while((n|0)<(c[(c[V>>2]|0)+8>>2]|0))}c[5682]=30100;l=0}else{l=c[m>>2]|0;ka=217}while(0);do if((ka|0)==217){l=$(l,z)|0;n=c[m+4>>2]|0;l=fo(($(l,n)|0)+1|0)|0;if(!l){if((c[m+8>>2]|0)>0){n=0;do{l=V+13724+(n*56|0)+44|0;if(c[l>>2]|0){go(c[V+13724+(n*56|0)+48>>2]|0);c[l>>2]=0}l=V+13724+(n*56|0)+52|0;m=c[l>>2]|0;if(m){go(m);c[l>>2]=0}n=n+1|0}while((n|0)<(c[(c[V>>2]|0)+8>>2]|0))}c[5682]=30100;l=0;break}if(n){s=(z|0)>2;v=W+4|0;w=W+8|0;x=(z|0)==1;k=0;do{n=$(k,z)|0;n=l+($(n,c[m>>2]|0)|0)|0;if(A){q=0;do{m=ca+(q<<5)+24|0;e=c[m>>2]|0;ka=c[ca+(q<<5)+16>>2]|0;ja=(e|0)>=(ka>>1|0);o=ca+(q<<5)+8|0;p=ca+(q<<5)+4|0;c[W+(q<<2)>>2]=xd[c[ca+(q<<5)>>2]&7](c[V+13724+(q*56|0)+52>>2]|0,c[(ja?o:p)>>2]|0,c[(ja?p:o)>>2]|0,c[ca+(q<<5)+20>>2]|0,c[ca+(q<<5)+12>>2]|0)|0;e=e+1|0;c[m>>2]=e;if((e|0)>=(ka|0)?(c[m>>2]=0,U=c[o>>2]|0,c[p>>2]=U,e=ca+(q<<5)+28|0,ka=(c[e>>2]|0)+1|0,c[e>>2]=ka,(ka|0)<(c[V+13724+(q*56|0)+32>>2]|0)):0)c[o>>2]=U+(c[V+13724+(q*56|0)+36>>2]|0);q=q+1|0}while((q|0)!=(y|0));m=c[V>>2]|0}r=c[W>>2]|0;u:do if(s){if((c[m+8>>2]|0)!=3){if(!(c[m>>2]|0))break;else o=0;while(1){m=a[r+o>>0]|0;a[n+2>>0]=m;a[n+1>>0]=m;a[n>>0]=m;a[n+3>>0]=-1;o=o+1|0;m=c[V>>2]|0;if(o>>>0>=(c[m>>2]|0)>>>0)break u;else n=n+z|0}}o=c[v>>2]|0;p=c[w>>2]|0;q=c[m>>2]|0;if((q|0)>0){m=0;while(1){e=d[r+m>>0]<<16|32768;ia=(d[p+m>>0]|0)+-128|0;ha=(d[o+m>>0]|0)+-128|0;ga=(ia*91881|0)+e|0;ia=e+($(ia,-46802)|0)+($(ha,-22554)|0)|0;e=(ha*116130|0)+e|0;ha=ga>>16;ja=ia>>16;ka=e>>16;a[n>>0]=ha>>>0>255?(ga>>>31)+255|0:ha;a[n+1>>0]=ja>>>0>255?(ia>>>31)+255|0:ja;a[n+2>>0]=ka>>>0>255?(e>>>31)+255|0:ka;a[n+3>>0]=-1;m=m+1|0;if((m|0)==(q|0))break;else n=n+z|0}m=c[V>>2]|0}}else{o=c[m>>2]|0;p=(o|0)==0;if(x){if(p)break;so(n|0,r|0,(o>>>0>1?o:1)|0)|0;break}else{if(p)break;else o=0;while(1){a[n>>0]=a[r+o>>0]|0;a[n+1>>0]=-1;o=o+1|0;m=c[V>>2]|0;if(o>>>0>=(c[m>>2]|0)>>>0)break;else n=n+2|0}}}while(0);k=k+1|0}while(k>>>0<(c[m+4>>2]|0)>>>0)}if((c[m+8>>2]|0)>0){o=0;do{m=V+13724+(o*56|0)+44|0;if(c[m>>2]|0){go(c[V+13724+(o*56|0)+48>>2]|0);c[m>>2]=0}m=V+13724+(o*56|0)+52|0;n=c[m>>2]|0;if(n){go(n);c[m>>2]=0}o=o+1|0;m=c[V>>2]|0}while((o|0)<(c[m+8>>2]|0))}c[f>>2]=c[m>>2];c[h>>2]=c[m+4>>2];if(j)c[j>>2]=c[m+8>>2]}while(0);break a}c[5682]=31760}while(0);if((c[(c[V>>2]|0)+8>>2]|0)>0){n=0;do{l=V+13724+(n*56|0)+44|0;if(c[l>>2]|0){go(c[V+13724+(n*56|0)+48>>2]|0);c[l>>2]=0}l=V+13724+(n*56|0)+52|0;m=c[l>>2]|0;if(m){go(m);c[l>>2]=0}n=n+1|0}while((n|0)<(c[(c[V>>2]|0)+8>>2]|0));l=0}else l=0}else{c[5682]=31747;l=0}while(0);h=l;i=la;return h|0}da=e+172|0;ea=e+32|0;fa=e+16|0;ga=e+28|0;ha=e+40|0;ia=e+36|0;n=0;while(1){if(l>>>0>=(c[da>>2]|0)>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}else{ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}if((m&255)<<24>>24!=(a[30179+n>>0]|0))break;n=n+1|0;if((n|0)>=8){ka=266;break}}if((ka|0)==266){c[ja>>2]=c[x>>2];c[ca>>2]=e;do if(k>>>0>4){c[5682]=31747;l=0}else{ka=(Kk(ca,0,k)|0)==0;n=ca+12|0;l=c[n>>2]|0;if(!ka){c[n>>2]=0;m=c[ca>>2]|0;if((k|0)!=0?(r=m+12|0,q=c[r>>2]|0,(q|0)!=(k|0)):0){l=$k(l,q,k,c[m>>2]|0,c[m+4>>2]|0)|0;c[r>>2]=k;if(!l){l=0;break}}c[f>>2]=c[m>>2];c[h>>2]=c[m+4>>2];if(!j)m=0;else{c[j>>2]=c[m+8>>2];m=0}}else{m=l;l=0}go(m);c[n>>2]=0;h=ca+8|0;go(c[h>>2]|0);c[h>>2]=0;h=ca+4|0;go(c[h>>2]|0);c[h>>2]=0}while(0);h=l;i=la;return h|0}c[5682]=30187;l=c[x>>2]|0;c[ja>>2]=l;do if(l>>>0>=(c[da>>2]|0)>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;o=(c[da>>2]|0)+-1|0;c[ja>>2]=o;a[o>>0]=0;o=c[ja>>2]|0;ka=281;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;o=ha;ka=281;break}}}else{o=l;ka=281}while(0);v:do if((ka|0)==281?(p=o+1|0,c[ja>>2]=p,(a[o>>0]|0)==66):0){do if(p>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0))break v;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;break}}else l=p;while(0);n=l+1|0;c[ja>>2]=n;if((a[l>>0]|0)==77){m=c[da>>2]|0;if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=l+2|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}if(n>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n}}else{n=n+1|0;c[ja>>2]=n}do if(n>>>0<m>>>0){ka=n+1|0;c[ja>>2]=ka;o=d[n>>0]|0;n=ka}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n;o=d[l>>0]|0}while(0);do if(n>>>0<m>>>0){ka=n+1|0;c[ja>>2]=ka;l=d[n>>0]|0;n=ka}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n;l=d[l>>0]|0}while(0);p=l<<8|o;do if(n>>>0<m>>>0){ka=n+1|0;c[ja>>2]=ka;o=d[n>>0]|0;n=ka}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}n=l+1|0;c[ja>>2]=n;o=d[l>>0]|0}while(0);do if(n>>>0<m>>>0){c[ja>>2]=n+1;l=d[n>>0]|0}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}c[ja>>2]=l+1;l=d[l>>0]|0}while(0);switch(p|(l<<8|o)<<16|0){case 12:case 40:case 56:case 108:break;default:break v}l=c[x>>2]|0;c[ja>>2]=l;do if(l>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){ka=413;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;ka=406;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;ka=406;break}}else ka=406;while(0);w:do if((ka|0)==406){m=l+1|0;c[ja>>2]=m;if((a[l>>0]|0)!=66){ka=413;break}do if(m>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){ka=413;break w}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;m=ha;break}}while(0);l=m+1|0;c[ja>>2]=l;if((a[m>>0]|0)!=77){ka=413;break}n=c[da>>2]|0;do if(l>>>0<n>>>0){l=m+2|0;c[ja>>2]=l;m=n}else{if(!(c[ea>>2]|0)){m=n;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);p=n<<8|o;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);x=p|(n<<8|o)<<16;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);o=n<<8|o;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}while(0);v=o|(m<<8|n)<<16;w=(v|0)==12;switch(v|0){case 12:case 40:case 56:case 108:break;default:{c[5682]=31836;l=0;break w}}n=c[da>>2]|0;m=l>>>0<n>>>0;if(w){do if(m){m=l+1|0;c[ja>>2]=m;o=d[l>>0]|0;l=m;m=n}else{if(!(c[ea>>2]|0)){o=0;m=n;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);c[e>>2]=n<<8|o;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}while(0);c[e+4>>2]=m<<8|n}else{do if(m){m=l+1|0;c[ja>>2]=m;o=d[l>>0]|0;l=m;m=n}else{if(!(c[ea>>2]|0)){o=0;m=n;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);p=n<<8|o;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);c[e>>2]=p|(n<<8|o)<<16;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);o=n<<8|o;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}while(0);c[e+4>>2]=o|(m<<8|n)<<16}m=c[da>>2]|0;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}while(0);if((m<<8|n|0)!=1){c[5682]=31848;l=0;break}m=c[da>>2]|0;do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);do if(l>>>0<m>>>0){ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}while(0);A=m<<8|n;if((A|0)==1){c[5682]=31856;l=0;break}ba=e+4|0;_=c[ba>>2]|0;aa=(_|0)>0;c[ba>>2]=(_|0)>-1?_:0-_|0;x:do if(w){if(A>>>0>=24){X=0;W=0;n=0;o=0;q=0;break}X=0;W=0;n=0;o=0;q=(x+-38|0)/3|0}else{m=c[da>>2]|0;do if(l>>>0<m>>>0){_=l+1|0;c[ja>>2]=_;o=d[l>>0]|0;l=_}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}_=l+1|0;c[ja>>2]=_;o=d[l>>0]|0;l=_}while(0);do if(l>>>0<m>>>0){_=l+1|0;c[ja>>2]=_;n=d[l>>0]|0;l=_}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}_=l+1|0;c[ja>>2]=_;n=d[l>>0]|0;l=_}while(0);o=n<<8|o;do if(l>>>0<m>>>0){_=l+1|0;c[ja>>2]=_;n=d[l>>0]|0;l=_}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}_=l+1|0;c[ja>>2]=_;n=d[l>>0]|0;l=_}while(0);do if(l>>>0<m>>>0){_=l+1|0;c[ja>>2]=_;m=d[l>>0]|0;l=_}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}_=l+1|0;c[ja>>2]=_;m=d[l>>0]|0;l=_}while(0);o=o|(m<<8|n)<<16;if((o+-1|0)>>>0<2){c[5682]=31867;l=0;break w}m=c[da>>2]|0;do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){c[ja>>2]=l+1;l=m}else{if(!(c[ea>>2]|0)){l=m;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[da>>2]|0;m=c[ja>>2]|0}else{c[ja>>2]=ha;l=e+40+l|0;c[da>>2]=l;m=ha}c[ja>>2]=m+1}while(0);m=c[ja>>2]|0;do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[da>>2]|0;m=c[ja>>2]|0}else{c[ja>>2]=ha;l=e+40+l|0;c[da>>2]=l;m=ha}m=m+1|0;c[ja>>2]=m}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[da>>2]|0;m=c[ja>>2]|0}else{c[ja>>2]=ha;l=e+40+l|0;c[da>>2]=l;m=ha}m=m+1|0;c[ja>>2]=m}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[da>>2]|0;m=c[ja>>2]|0}else{c[ja>>2]=ha;l=e+40+l|0;c[da>>2]=l;m=ha}m=m+1|0;c[ja>>2]=m}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[da>>2]|0;m=c[ja>>2]|0}else{c[ja>>2]=ha;l=e+40+l|0;c[da>>2]=l;m=ha}m=m+1|0;c[ja>>2]=m}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[da>>2]|0;m=c[ja>>2]|0}else{c[ja>>2]=ha;l=e+40+l|0;c[da>>2]=l;m=ha}m=m+1|0;c[ja>>2]=m}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}m=l+1|0;c[ja>>2]=m}while(0);y:do if((v&-17|0)==40){do if((v|0)==56){l=c[da>>2]|0;do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m;break}if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}m=l+1|0;c[ja>>2]=m}while(0);l=(A|0)==32;switch(A|0){case 16:case 32:break;default:{l=0;m=0;n=0;o=0;break y}}switch(o|0){case 0:{X=l?-16777216:0;W=l?255:31;n=l?65280:992;o=l?16711680:31744;q=0;break x}case 3:{n=c[da>>2]|0;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;o=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;o=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);p=l<<8|o;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;o=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;o=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);o=p|(l<<8|o)<<16;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);q=l<<8|p;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);r=q|(l<<8|p)<<16;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);q=l<<8|p;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){c[ja>>2]=m+1;l=d[m>>0]|0}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}c[ja>>2]=l+1;l=d[l>>0]|0}while(0);l=q|(l<<8|p)<<16;if(!((o|0)==(r|0)&(r|0)==(l|0))){X=0;W=l;n=r;q=0;break x}c[5682]=31848;l=0;break w}default:{c[5682]=31848;l=0;break w}}}else{if((v|0)!=108)Ba(31875,30466,2691,31886);n=c[da>>2]|0;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;o=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;o=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);p=l<<8|o;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;o=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;o=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);o=p|(l<<8|o)<<16;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);q=l<<8|p;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);s=q|(l<<8|p)<<16;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);q=l<<8|p;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);r=q|(l<<8|p)<<16;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);q=l<<8|p;do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;p=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;p=d[l>>0]|0}while(0);do if(m>>>0<n>>>0){_=m+1|0;c[ja>>2]=_;l=d[m>>0]|0;m=_}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}while(0);q=q|(l<<8|p)<<16;do if(m>>>0<n>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m}while(0);do if(m>>>0<n>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m}while(0);do if(m>>>0<n>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m}while(0);do if(m>>>0<n>>>0){m=m+1|0;c[ja>>2]=m;p=0}else{if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}m=l+1|0;c[ja>>2]=m;p=0}while(0);do{l=c[da>>2]|0;do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}m=l+1|0;c[ja>>2]=m;l=n}while(0);do if(m>>>0<l>>>0){m=m+1|0;c[ja>>2]=m}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}m=l+1|0;c[ja>>2]=m}while(0);p=p+1|0}while((p|0)!=12);l=q;m=r;n=s}while(0);if(A>>>0>=16){X=l;W=m;q=0;break}X=l;W=m;q=x+-14-v>>2}while(0);V=(X|0)!=0;Z=V?4:3;_=e+8|0;c[_>>2]=Z;Y=(k|0)==0;Z=(k|0)>2?k:Z;l=$(c[e>>2]|0,Z)|0;l=fo($(l,c[ba>>2]|0)|0)|0;if(!l){c[5682]=30100;l=0;break}z:do if(A>>>0<16){if((q|0)==0|(q|0)>256){go(l);c[5682]=31895;l=0;break w}if((q|0)>0){m=c[ja>>2]|0;p=0;do{n=c[da>>2]|0;do if(m>>>0<n>>>0){X=m+1|0;c[ja>>2]=X;o=d[m>>0]|0;m=X}else{if(!(c[ea>>2]|0)){o=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;m=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+m|0;c[da>>2]=n;m=ha}X=m+1|0;c[ja>>2]=X;o=d[m>>0]|0;m=X}while(0);a[ca+(p<<2)+2>>0]=o;do if(m>>>0<n>>>0){X=m+1|0;c[ja>>2]=X;o=d[m>>0]|0;m=X}else{if(!(c[ea>>2]|0)){o=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;m=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+m|0;c[da>>2]=n;m=ha}X=m+1|0;c[ja>>2]=X;o=d[m>>0]|0;m=X}while(0);a[ca+(p<<2)+1>>0]=o;do if(m>>>0<n>>>0){X=m+1|0;c[ja>>2]=X;n=d[m>>0]|0;m=X}else{if(!(c[ea>>2]|0)){n=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+m;m=ha}X=m+1|0;c[ja>>2]=X;n=d[m>>0]|0;m=X}while(0);a[ca+(p<<2)>>0]=n;do if(!w){if(m>>>0<(c[da>>2]|0)>>>0){m=m+1|0;c[ja>>2]=m;break}if(!(c[ea>>2]|0))break;m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+m;m=ha}m=m+1|0;c[ja>>2]=m}while(0);a[ca+(p<<2)+3>>0]=-1;p=p+1|0}while((p|0)!=(q|0))}p=x+-14-v-($(q,w?3:4)|0)|0;do if(!(c[fa>>2]|0)){m=c[ja>>2]|0;ka=1238}else{n=c[da>>2]|0;m=c[ja>>2]|0;o=n-m|0;if((p|0)<=(o|0)){ka=1238;break}c[ja>>2]=n;qd[c[e+20>>2]&63](c[ga>>2]|0,p-o|0)}while(0);if((ka|0)==1238)c[ja>>2]=m+p;z=(A|0)==4;do if(!z)if((A|0)==8){m=c[e>>2]|0;n=m;break}else{go(l);c[5682]=31903;l=0;break w}else{m=c[e>>2]|0;n=m;m=(m+1|0)>>>1}while(0);y=0-m&3;v=c[ba>>2]|0;if((v|0)<=0)break;w=e+20|0;x=(Z|0)==4;s=(A|0)==8;r=0;m=0;while(1){A:do if((n|0)>0){n=c[ja>>2]|0;q=0;p=m;while(1){do if(n>>>0<(c[da>>2]|0)>>>0){X=n+1|0;c[ja>>2]=X;m=d[n>>0]|0;n=X}else{if(!(c[ea>>2]|0)){m=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+m;m=ha}n=m+1|0;c[ja>>2]=n;m=d[m>>0]|0}while(0);X=z?m>>>4:m;o=z?m&15:0;a[l+p>>0]=a[ca+(X<<2)>>0]|0;a[l+(p+1)>>0]=a[ca+(X<<2)+1>>0]|0;m=p+3|0;a[l+(p+2)>>0]=a[ca+(X<<2)+2>>0]|0;if(x){a[l+m>>0]=-1;p=p+4|0}else p=m;if((q|1|0)==(c[e>>2]|0))break A;do if(s){if(n>>>0<(c[da>>2]|0)>>>0){X=n+1|0;c[ja>>2]=X;o=d[n>>0]|0;n=X;break}if(!(c[ea>>2]|0)){o=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+m;m=ha}n=m+1|0;c[ja>>2]=n;o=d[m>>0]|0}while(0);a[l+p>>0]=a[ca+(o<<2)>>0]|0;a[l+(p+1)>>0]=a[ca+(o<<2)+1>>0]|0;m=p+3|0;a[l+(p+2)>>0]=a[ca+(o<<2)+2>>0]|0;if(x){a[l+m>>0]=-1;m=p+4|0}q=q+2|0;if((q|0)>=(c[e>>2]|0)){p=m;break}else p=m}}else p=m;while(0);do if(!(c[fa>>2]|0)){m=c[ja>>2]|0;ka=1273}else{n=c[da>>2]|0;m=c[ja>>2]|0;o=n-m|0;if((y|0)<=(o|0)){ka=1273;break}c[ja>>2]=n;qd[c[w>>2]&63](c[ga>>2]|0,y-o|0)}while(0);if((ka|0)==1273){ka=0;c[ja>>2]=m+y}m=r+1|0;v=c[ba>>2]|0;if((m|0)>=(v|0))break z;n=c[e>>2]|0;r=m;m=p}}else{r=x+-14-v|0;do if(!(c[fa>>2]|0)){m=c[ja>>2]|0;ka=1280}else{p=c[da>>2]|0;m=c[ja>>2]|0;q=p-m|0;if((r|0)<=(q|0)){ka=1280;break}c[ja>>2]=p;qd[c[e+20>>2]&63](c[ga>>2]|0,r-q|0)}while(0);if((ka|0)==1280)c[ja>>2]=m+r;switch(A|0){case 24:{m=($(c[e>>2]|0,-3)|0)&3;T=1;U=0;p=0;s=1;q=0;r=0;S=0;break}case 16:{m=0-(c[e>>2]<<1)&2;ka=1285;break}case 32:{if((X|0)==-16777216&((W|0)==255&(n|0)==65280&(o|0)==16711680)){m=0;T=1;U=0;p=0;s=2;q=0;r=0;S=0}else{m=0;ka=1285}break}default:{m=0;ka=1285}}do if((ka|0)==1285){if(!((W|0)!=0&((n|0)!=0&(o|0)!=0))){go(l);c[5682]=31911;l=0;break w}p=o>>>0>65535;v=p?o>>>16:o;p=p?16:0;r=v>>>0>255;v=r?v>>>8:v;p=r?p|8:p;r=v>>>0>15;v=r?v>>>4:v;p=r?p|4:p;r=v>>>0>3;v=(r?p|2:p)+-7+((r?v>>>2:v)>>>0>1&1)|0;r=(o>>>1&1431655765)+(o&1431655765)|0;r=(r>>>2&858993459)+(r&858993459)|0;r=(r>>>4)+r&252645135;r=(r>>>8)+r|0;r=(r>>>16)+r&255;p=n>>>0>65535;q=p?n>>>16:n;p=p?16:0;U=q>>>0>255;q=U?q>>>8:q;p=U?p|8:p;U=q>>>0>15;q=U?q>>>4:q;p=U?p|4:p;U=q>>>0>3;q=(U?p|2:p)+-7+((U?q>>>2:q)>>>0>1&1)|0;U=W>>>0>65535;p=U?W>>>16:W;U=U?16:0;ca=p>>>0>255;p=ca?p>>>8:p;U=ca?U|8:U;ca=p>>>0>15;p=ca?p>>>4:p;U=ca?U|4:U;ca=p>>>0>3;p=(ca?U|2:U)+-7+((ca?p>>>2:p)>>>0>1&1)|0;if(!X){T=0;U=-8;s=0;S=v;break}S=X>>>0>65535;U=S?X>>>16:X;S=S?16:0;s=U>>>0>255;U=s?U>>>8:U;S=s?S|8:S;s=U>>>0>15;U=s?U>>>4:U;S=s?S|4:S;s=U>>>0>3;T=0;U=(s?S|2:S)+-7+((s?U>>>2:U)>>>0>1&1)|0;s=0;S=v}while(0);v=c[ba>>2]|0;if((v|0)<=0)break;P=(s|0)==2;R=(Z|0)==4;D=(A|0)==16;E=(S|0)<0;F=0-S|0;G=r>>>0<8;H=(q|0)<0;I=0-q|0;J=(p|0)<0;K=0-p|0;L=(U|0)<0;M=0-U|0;N=e+20|0;O=0;w=0;while(1){s=(c[e>>2]|0)>0;do if(T){if(!s){x=w;break}v=c[ja>>2]|0;z=0;while(1){s=c[da>>2]|0;do if(v>>>0<s>>>0){y=v+1|0;c[ja>>2]=y;x=d[v>>0]|0}else{if(!(c[ea>>2]|0)){x=0;y=v;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;v=(c[da>>2]|0)+-1|0;c[ja>>2]=v;a[v>>0]=0;v=c[da>>2]|0;s=c[ja>>2]|0}else{c[ja>>2]=ha;v=e+40+s|0;c[da>>2]=v;s=ha}y=s+1|0;c[ja>>2]=y;x=d[s>>0]|0;s=v}while(0);a[l+(w+2)>>0]=x;do if(y>>>0<s>>>0){ca=y+1|0;c[ja>>2]=ca;x=d[y>>0]|0;y=ca}else{if(!(c[ea>>2]|0)){x=0;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;v=(c[da>>2]|0)+-1|0;c[ja>>2]=v;a[v>>0]=0;v=c[da>>2]|0;s=c[ja>>2]|0}else{c[ja>>2]=ha;v=e+40+s|0;c[da>>2]=v;s=ha}y=s+1|0;c[ja>>2]=y;x=d[s>>0]|0;s=v}while(0);a[l+(w+1)>>0]=x;do if(y>>>0<s>>>0){v=y+1|0;c[ja>>2]=v;s=d[y>>0]|0}else{if(!(c[ea>>2]|0)){s=0;v=y;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;s=(c[da>>2]|0)+-1|0;c[ja>>2]=s;a[s>>0]=0;s=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+s;s=ha}v=s+1|0;c[ja>>2]=v;s=d[s>>0]|0}while(0);a[l+w>>0]=s;x=w+3|0;do if(P){if(v>>>0<(c[da>>2]|0)>>>0){ca=v+1|0;c[ja>>2]=ca;s=d[v>>0]|0;v=ca;break}if(!(c[ea>>2]|0)){s=0;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;s=(c[da>>2]|0)+-1|0;c[ja>>2]=s;a[s>>0]=0;s=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+s;s=ha}v=s+1|0;c[ja>>2]=v;s=d[s>>0]|0}else s=255;while(0);if(R){a[l+x>>0]=s;s=w+4|0}else s=x;z=z+1|0;if((z|0)>=(c[e>>2]|0)){x=s;break}else w=s}}else{if(!s){x=w;break}x=c[ja>>2]|0;C=0;while(1){v=c[da>>2]|0;s=x>>>0<v>>>0;if(D){do if(s){s=x+1|0;c[ja>>2]=s;y=d[x>>0]|0;x=s;s=v}else{if(!(c[ea>>2]|0)){y=0;s=v;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;v=(c[da>>2]|0)+-1|0;c[ja>>2]=v;a[v>>0]=0;v=c[da>>2]|0;s=c[ja>>2]|0}else{c[ja>>2]=ha;v=e+40+s|0;c[da>>2]=v;s=ha}x=s+1|0;c[ja>>2]=x;y=d[s>>0]|0;s=v}while(0);do if(x>>>0<s>>>0){v=x+1|0;c[ja>>2]=v;s=d[x>>0]|0}else{if(!(c[ea>>2]|0)){s=0;v=x;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;s=(c[da>>2]|0)+-1|0;c[ja>>2]=s;a[s>>0]=0;s=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+s;s=ha}v=s+1|0;c[ja>>2]=v;s=d[s>>0]|0}while(0);A=s<<8|y;B=v}else{do if(s){ca=x+1|0;c[ja>>2]=ca;y=d[x>>0]|0;x=ca}else{if(!(c[ea>>2]|0)){y=0;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;v=(c[da>>2]|0)+-1|0;c[ja>>2]=v;a[v>>0]=0;v=c[da>>2]|0;s=c[ja>>2]|0}else{c[ja>>2]=ha;v=e+40+s|0;c[da>>2]=v;s=ha}x=s+1|0;c[ja>>2]=x;y=d[s>>0]|0}while(0);do if(x>>>0<v>>>0){ca=x+1|0;c[ja>>2]=ca;s=d[x>>0]|0;x=ca}else{if(!(c[ea>>2]|0)){s=0;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;v=(c[da>>2]|0)+-1|0;c[ja>>2]=v;a[v>>0]=0;v=c[da>>2]|0;s=c[ja>>2]|0}else{c[ja>>2]=ha;v=e+40+s|0;c[da>>2]=v;s=ha}x=s+1|0;c[ja>>2]=x;s=d[s>>0]|0}while(0);z=s<<8|y;do if(x>>>0<v>>>0){ca=x+1|0;c[ja>>2]=ca;y=d[x>>0]|0;x=ca}else{if(!(c[ea>>2]|0)){y=0;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;v=(c[da>>2]|0)+-1|0;c[ja>>2]=v;a[v>>0]=0;v=c[da>>2]|0;s=c[ja>>2]|0}else{c[ja>>2]=ha;v=e+40+s|0;c[da>>2]=v;s=ha}x=s+1|0;c[ja>>2]=x;y=d[s>>0]|0}while(0);do if(x>>>0<v>>>0){v=x+1|0;c[ja>>2]=v;s=d[x>>0]|0}else{if(!(c[ea>>2]|0)){s=0;v=x;break}s=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!s){c[ea>>2]=0;s=(c[da>>2]|0)+-1|0;c[ja>>2]=s;a[s>>0]=0;s=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+s;s=ha}v=s+1|0;c[ja>>2]=v;s=d[s>>0]|0}while(0);A=z|(s<<8|y)<<16;B=v}s=A&o;s=E?s<<F:s>>S;if(G){v=s;x=r;do{v=(s>>x)+v|0;x=x+r|0}while((x|0)<8);s=v}y=w+1|0;a[l+w>>0]=s;s=A&n;s=H?s<<I:s>>q;if(G){v=s;x=r;do{v=(s>>x)+v|0;x=x+r|0}while((x|0)<8);s=v}z=w+2|0;a[l+y>>0]=s;v=A&W;v=J?v<<K:v>>p;if(G){s=v;x=r;do{s=(v>>x)+s|0;x=x+r|0}while((x|0)<8);v=s}s=w+3|0;a[l+z>>0]=v;do if(V){v=A&X;v=L?v<<M:v>>U;if(G){x=v;y=r}else break;do{x=(v>>y)+x|0;y=y+r|0}while((y|0)<8);v=x}else v=255;while(0);if(R){a[l+s>>0]=v;s=w+4|0}C=C+1|0;if((C|0)>=(c[e>>2]|0)){x=s;break}else{x=B;w=s}}}while(0);do if(!(c[fa>>2]|0)){s=c[ja>>2]|0;ka=1389}else{v=c[da>>2]|0;s=c[ja>>2]|0;w=v-s|0;if((m|0)<=(w|0)){ka=1389;break}c[ja>>2]=v;qd[c[N>>2]&63](c[ga>>2]|0,m-w|0)}while(0);if((ka|0)==1389){ka=0;c[ja>>2]=s+m}O=O+1|0;v=c[ba>>2]|0;if((O|0)>=(v|0))break;else w=x}}while(0);do if(aa){m=v>>1;if((m|0)<=0)break;n=$(c[e>>2]|0,Z)|0;o=(n|0)>0;s=0;do{p=$(s,n)|0;q=$(v+~s|0,n)|0;if(o){r=0;do{ha=l+(r+p)|0;ia=a[ha>>0]|0;ja=l+(r+q)|0;a[ha>>0]=a[ja>>0]|0;a[ja>>0]=ia;r=r+1|0}while((r|0)!=(n|0))}s=s+1|0}while((s|0)!=(m|0))}while(0);if(!(Y|(Z|0)==(k|0))){l=$k(l,Z,k,c[e>>2]|0,v)|0;if(!l){l=0;break}}c[f>>2]=c[e>>2];c[h>>2]=c[ba>>2];if(!j)break;c[j>>2]=c[_>>2]}while(0);if((ka|0)==413){c[5682]=31828;l=0}h=l;i=la;return h|0}}while(0);l=c[x>>2]|0;c[ja>>2]=l;do if(l>>>0>=(c[da>>2]|0)>>>0)if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;ka=1407;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;ka=1407;break}}else ka=1440;else ka=1407;while(0);B:do if((ka|0)==1407){m=l+1|0;c[ja>>2]=m;if((a[l>>0]|0)==71){do if(m>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){ka=1440;break B}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;break}}else l=m;while(0);m=l+1|0;c[ja>>2]=m;if((a[l>>0]|0)==73){do if(m>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){ka=1440;break B}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;break}}else l=m;while(0);m=l+1|0;c[ja>>2]=m;if((a[l>>0]|0)==70){do if(m>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){ka=1440;break B}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;break}}else l=m;while(0);m=l+1|0;c[ja>>2]=m;if((a[l>>0]|0)==56){do if(m>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){ka=1440;break B}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;m=ha;break}}while(0);l=m+1|0;c[ja>>2]=l;switch(d[m>>0]|0){case 55:case 57:break;default:{ka=1440;break B}}if(l>>>0<(c[da>>2]|0)>>>0){n=l;l=m+2|0}else{if(!(c[ea>>2]|0)){l=c[x>>2]|0;c[ja>>2]=l;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}n=l;l=l+1|0}c[ja>>2]=l;ba=(a[n>>0]|0)==97;l=c[x>>2]|0;c[ja>>2]=l;if(ba){uo(ca|0,0,18508)|0;D=ca+8|0;C:do if(!(Lk(e,ca,j,0)|0))l=0;else{E=ca+4|0;l=$(c[ca>>2]<<2,c[E>>2]|0)|0;n=fo(l)|0;c[D>>2]=n;if(!n){c[5682]=30100;l=0;break}m=c[ca+16>>2]|0;q=ca+32+(m<<2)|0;D:do if((l|0)>0){o=ca+32+(m<<2)+2|0;p=ca+32+(m<<2)+1|0;m=ca+32+(m<<2)+3|0;l=0;while(1){a[n+l>>0]=a[o>>0]|0;a[n+(l|1)>>0]=a[p>>0]|0;a[n+(l|2)>>0]=a[q>>0]|0;a[n+(l|3)>>0]=a[m>>0]|0;l=l+4|0;if((l|0)>=($(c[ca>>2]<<2,c[E>>2]|0)|0))break D;n=c[D>>2]|0}}while(0);v=ca+28|0;s=ca+24|0;C=e+20|0;E:while(1){l=c[ja>>2]|0;do if(l>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){ka=1673;break E}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;m=ha;break}}else m=l;while(0);l=m+1|0;c[ja>>2]=l;switch(d[m>>0]|0){case 59:{l=1;break C}case 44:break E;case 33:break;default:{ka=1673;break E}}do if(l>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;ka=1623;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;ka=1623;break}}else ka=1623;while(0);F:do if((ka|0)==1623){ka=0;m=l+1|0;c[ja>>2]=m;if((a[l>>0]|0)!=-7){l=m;break}do if(m>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){p=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;ka=1629;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;ka=1629;break}}else{l=m;ka=1629}while(0);do if((ka|0)==1629){ka=0;o=l+1|0;c[ja>>2]=o;m=a[l>>0]|0;if(m<<24>>24!=4){p=m&255;m=o;break}m=c[da>>2]|0;do if(o>>>0<m>>>0){l=l+2|0;c[ja>>2]=l;n=d[o>>0]|0}else{if(!(c[ea>>2]|0)){n=0;l=o;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}j=l+1|0;c[ja>>2]=j;n=d[l>>0]|0;l=j}while(0);c[v>>2]=n;do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){j=l+1|0;c[ja>>2]=j;m=d[l>>0]|0;l=j}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}j=l+1|0;c[ja>>2]=j;m=d[l>>0]|0;l=j}while(0);c[s>>2]=m;break F}while(0);do if(c[fa>>2]|0){n=c[da>>2]|0;m=n-m|0;if((p|0)<=(m|0))break;c[ja>>2]=n;qd[c[C>>2]&63](c[ga>>2]|0,p-m|0);continue E}while(0);c[ja>>2]=l+(p+1);continue E}while(0);G:while(1){do if(l>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0))continue E;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;break}}while(0);m=l+1|0;c[ja>>2]=m;j=a[l>>0]|0;n=j&255;if(!(j<<24>>24))continue E;do if(c[fa>>2]|0){o=c[da>>2]|0;m=o-m|0;if((n|0)<=(m|0))break;c[ja>>2]=o;qd[c[C>>2]&63](c[ga>>2]|0,n-m|0);l=c[ja>>2]|0;continue G}while(0);l=l+(n+1)|0;c[ja>>2]=l}}if((ka|0)==1673){c[5682]=32014;l=0;break}n=c[da>>2]|0;do if(l>>>0<n>>>0){m=m+2|0;c[ja>>2]=m;o=d[l>>0]|0;l=m;m=n}else{if(!(c[ea>>2]|0)){o=0;m=n;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;o=d[l>>0]|0;l=ka}while(0);do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}while(0);r=n<<8|o;do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;o=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;o=d[l>>0]|0;l=ka}while(0);do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}while(0);q=n<<8|o;do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;o=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;o=d[l>>0]|0;l=ka}while(0);do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}while(0);p=n<<8|o;do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}while(0);do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;m=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ka=l+1|0;c[ja>>2]=ka;m=d[l>>0]|0;l=ka}while(0);o=m<<8|n;m=c[ca>>2]|0;do if((p+r|0)<=(m|0)){if((o+q|0)>(c[E>>2]|0))break;n=m<<2;m=ca+18504|0;c[m>>2]=n;j=r<<2;c[ca+18480>>2]=j;ka=$(n,q)|0;c[ca+18484>>2]=ka;c[ca+18488>>2]=(p<<2)+j;c[ca+18492>>2]=($(n,o)|0)+ka;c[ca+18496>>2]=j;c[ca+18500>>2]=ka;do if(l>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){m=ca+18476|0;c[m>>2]=0;ka=1523;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;n=c[m>>2]|0;ka=1521;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;ka=1521;break}}else ka=1521;while(0);do if((ka|0)==1521){o=l+1|0;c[ja>>2]=o;l=d[l>>0]|0;m=ca+18476|0;c[m>>2]=l;if(!(l&64)){l=o;ka=1523;break}c[ca+18472>>2]=n<<3;c[ca+18468>>2]=3;m=l;l=o}while(0);if((ka|0)==1523){c[ca+18472>>2]=n;c[ca+18468>>2]=0;m=c[m>>2]|0}if(!(m&128)){if(!(c[ca+12>>2]&128)){c[5682]=31942;l=0;break C}else m=0;do{a[ca+32+(m<<2)+3>>0]=-1;m=m+1|0}while((m|0)!=256);m=c[s>>2]|0;do if((m|0)>-1){if(!(c[v>>2]&1))break;a[ca+32+(m<<2)+3>>0]=0}while(0);c[ca+18464>>2]=ca+32}else{q=2<<(m&7);if((q|0)>0){p=((c[s>>2]|0)==0&(c[v>>2]&1|0)!=0)<<31>>31;o=0;do{m=c[da>>2]|0;do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}while(0);a[ca+1056+(o<<2)+2>>0]=n;do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ka=l+1|0;c[ja>>2]=ka;n=d[l>>0]|0;l=ka}while(0);a[ca+1056+(o<<2)+1>>0]=n;do if(l>>>0<m>>>0){ka=l+1|0;c[ja>>2]=ka;m=d[l>>0]|0;l=ka}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ka=l+1|0;c[ja>>2]=ka;m=d[l>>0]|0;l=ka}while(0);a[ca+1056+(o<<2)>>0]=m;a[ca+1056+(o<<2)+3>>0]=p;o=o+1|0}while((o|0)!=(q|0))}c[ca+18464>>2]=ca+1056}do if(l>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){l=0;n=1;ka=1563;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;ka=1562;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;ka=1562;break}}else ka=1562;while(0);if((ka|0)==1562){c[ja>>2]=l+1;j=a[l>>0]|0;l=j&255;m=1<<l;if(j<<24>>24==31)l=31;else{n=m;ka=1563}}if((ka|0)==1563){m=0;do{b[ca+2080+(m<<2)>>1]=-1;j=m&255;a[ca+2080+(m<<2)+2>>0]=j;a[ca+2080+(m<<2)+3>>0]=j;m=m+1|0}while((m|0)<(n|0));m=n}z=m+2|0;A=m+1|0;n=0;B=0;o=0;q=0;H:while(1){p=z;r=l;s=-1;I:while(1){y=r+1|0;x=(1<<y)+-1|0;w=p;v=s;while(1){if((q|0)<(y|0)){p=c[ja>>2]|0;do{if(!o){do if(p>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0))break H;o=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!o){c[ea>>2]=0;o=(c[da>>2]|0)+-1|0;c[ja>>2]=o;a[o>>0]=0;o=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+o;o=ha;break}}else o=p;while(0);p=o+1|0;c[ja>>2]=p;o=a[o>>0]|0;if(!(o<<24>>24))break H;else o=o&255}o=o+-1|0;do if(p>>>0<(c[da>>2]|0)>>>0){j=p+1|0;c[ja>>2]=j;r=d[p>>0]|0;p=j}else{if(!(c[ea>>2]|0)){r=0;break}p=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!p){c[ea>>2]=0;p=(c[da>>2]|0)+-1|0;c[ja>>2]=p;a[p>>0]=0;p=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+p;p=ha}j=p+1|0;c[ja>>2]=j;r=d[p>>0]|0;p=j}while(0);n=r<<q|n;q=q+8|0}while((q|0)<(y|0))}s=n&x;n=n>>y;q=q-y|0;if((s|0)==(m|0)){B=1;continue H}if((s|0)==(A|0)){ka=1587;break H}if((s|0)>(w|0)){ka=1614;break H}if(!B){ka=1604;break H}if((v|0)<=-1)if((s|0)==(w|0)){ka=1612;break H}else p=w;else{p=w+1|0;if((w|0)>4095){ka=1607;break H}b[ca+2080+(w<<2)>>1]=v;r=a[ca+2080+(v<<2)+2>>0]|0;a[ca+2080+(w<<2)+2>>0]=r;if((s|0)!=(p|0))r=a[ca+2080+(s<<2)+2>>0]|0;a[ca+2080+(w<<2)+3>>0]=r}al(ca,s&65535);if((p|0)<4096&(p&x|0)==0){r=y;continue I}else{w=p;v=s}}}}J:do if((ka|0)==1587){do if(!(c[fa>>2]|0)){l=c[ja>>2]|0;ka=1591}else{m=c[da>>2]|0;l=c[ja>>2]|0;n=m-l|0;if((o|0)<=(n|0)){ka=1591;break}c[ja>>2]=m;qd[c[C>>2]&63](c[ga>>2]|0,o-n|0)}while(0);if((ka|0)==1591)c[ja>>2]=l+o;K:while(1){l=c[ja>>2]|0;do if(l>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0))break J;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;break}}while(0);m=l+1|0;c[ja>>2]=m;ka=a[l>>0]|0;n=ka&255;if(!(ka<<24>>24))break J;do if(c[fa>>2]|0){o=c[da>>2]|0;m=o-m|0;if((n|0)<=(m|0))break;c[ja>>2]=o;qd[c[C>>2]&63](c[ga>>2]|0,n-m|0);continue K}while(0);c[ja>>2]=l+(n+1)}}else if((ka|0)==1604){c[5682]=31962;l=0;break C}else if((ka|0)==1607){c[5682]=31976;l=0;break C}else if((ka|0)==1612){c[5682]=31991;l=0;break C}else if((ka|0)==1614){c[5682]=31991;l=0;break C}while(0);l=c[D>>2]|0;if(!l){l=0;break C}switch(k|0){case 0:case 4:break C;default:{}}l=$k(l,4,k,c[ca>>2]|0,c[E>>2]|0)|0;break C}while(0);c[5682]=31921;l=0}while(0);l=(l|0)==1?0:l;if(l){c[f>>2]=c[ca>>2];c[h>>2]=c[ca+4>>2]}h=l;i=la;return h|0}}else ka=1440}else ka=1440}else ka=1440}else ka=1440}while(0);if((ka|0)==1440){l=c[x>>2]|0;c[ja>>2]=l}m=c[da>>2]|0;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}o=n<<8;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}o=(n|o)<<16;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}n=n<<8;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}c[ja>>2]=l+1;m=d[l>>0]|0}else{c[ja>>2]=l+1;m=d[l>>0]|0}l=c[x>>2]|0;c[ja>>2]=l;if((n|o|m|0)==943870035){m=c[da>>2]|0;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}o=n<<8;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}o=(n|o)<<16;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}n=n<<8;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}if((n|o|m|0)!=943870035){c[5682]=32027;h=0;i=la;return h|0}m=c[da>>2]|0;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}n=n<<8;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}if((m|n|0)!=1){c[5682]=32035;h=0;i=la;return h|0}if((c[fa>>2]|0)!=0?(s=c[da>>2]|0,v=s-l|0,(v|0)<6):0){c[ja>>2]=s;qd[c[e+20>>2]&63](c[ga>>2]|0,6-v|0);l=c[ja>>2]|0}else{l=l+6|0;c[ja>>2]=l}m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}while(0);B=m|n;if(B>>>0>16){c[5682]=32049;h=0;i=la;return h|0}m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);p=(n|o)<<16;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);A=o|p|n;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);p=(n|o)<<16;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);z=o|p|n;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}while(0);if((m|n|0)!=8){c[5682]=32069;h=0;i=la;return h|0}m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}while(0);if((m|n|0)!=3){c[5682]=32091;h=0;i=la;return h|0}m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=(n|o)<<16;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}while(0);m=n|o|m;do if(!(c[fa>>2]|0))ka=1891;else{n=c[da>>2]|0;o=n-l|0;if((m|0)<=(o|0)){ka=1891;break}c[ja>>2]=n;qd[c[e+20>>2]&63](c[ga>>2]|0,m-o|0);l=c[ja>>2]|0}while(0);if((ka|0)==1891){l=l+m|0;c[ja>>2]=l}m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=(n|o)<<16;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}while(0);m=n|o|m;do if(!(c[fa>>2]|0))ka=1923;else{n=c[da>>2]|0;o=n-l|0;if((m|0)<=(o|0)){ka=1923;break}c[ja>>2]=n;qd[c[e+20>>2]&63](c[ga>>2]|0,m-o|0);l=c[ja>>2]|0}while(0);if((ka|0)==1923){l=l+m|0;c[ja>>2]=l}m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);o=(n|o)<<16;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}while(0);m=n|o|m;do if(!(c[fa>>2]|0))ka=1955;else{n=c[da>>2]|0;o=n-l|0;if((m|0)<=(o|0)){ka=1955;break}c[ja>>2]=n;qd[c[e+20>>2]&63](c[ga>>2]|0,m-o|0);l=c[ja>>2]|0}while(0);if((ka|0)==1955){l=l+m|0;c[ja>>2]=l}m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){p=l+1|0;c[ja>>2]=p;m=d[l>>0]|0}else{if(!(c[ea>>2]|0)){m=0;p=l;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}p=l+1|0;c[ja>>2]=p;m=d[l>>0]|0}while(0);m=m|n;if(m>>>0>1){c[5682]=31013;h=0;i=la;return h|0}l=fo($(A<<2,z)|0)|0;if(!l){c[5682]=30100;h=0;i=la;return h|0}y=$(z,A)|0;if(!m){p=(y|0)>0;q=0;do{m=l+q|0;do if((q|0)>(B|0)){if(!p)break;n=((q|0)==3)<<31>>31;o=0;while(1){a[m>>0]=n;o=o+1|0;if((o|0)==(y|0))break;else m=m+4|0}}else{if(p){o=0;n=m}else break;while(1){m=c[ja>>2]|0;do if(m>>>0<(c[da>>2]|0)>>>0){c[ja>>2]=m+1;m=d[m>>0]|0}else{if(!(c[ea>>2]|0)){m=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+m;m=ha}c[ja>>2]=m+1;m=d[m>>0]|0}while(0);a[n>>0]=m;o=o+1|0;if((o|0)==(y|0))break;else n=n+4|0}}while(0);q=q+1|0}while((q|0)!=4)}else{m=$(A,B<<1)|0;do if(!(c[fa>>2]|0))ka=1979;else{n=c[da>>2]|0;o=n-p|0;if((m|0)<=(o|0)){ka=1979;break}c[ja>>2]=n;qd[c[e+20>>2]&63](c[ga>>2]|0,m-o|0)}while(0);if((ka|0)==1979)c[ja>>2]=p+m;w=(y|0)>0;x=0;do{m=l+x|0;L:do if((x|0)<(B|0)){v=0;while(1){p=(v|0)<(y|0);M:while(1){if(!p)break L;n=c[ja>>2]|0;do if(n>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0)){s=0;ka=1997;break M}n=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!n){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+n;n=ha;break}}while(0);q=n+1|0;c[ja>>2]=q;o=a[n>>0]|0;if(o<<24>>24!=-128){ka=1996;break}}do if((ka|0)==1996){ka=0;s=o&255;if(o<<24>>24>-1){n=q;ka=1997;break}r=257-s|0;do if(q>>>0<(c[da>>2]|0)>>>0){c[ja>>2]=n+2;n=d[q>>0]|0}else{if(!(c[ea>>2]|0)){n=0;break}n=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!n){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+n;n=ha}c[ja>>2]=n+1;n=d[n>>0]|0}while(0);n=n&255;if(!r){n=0;break}else{o=r;p=m}while(1){a[p>>0]=n;o=o+-1|0;if(!o)break;else p=p+4|0}n=r;m=m+(1028-(s<<2))|0}while(0);if((ka|0)==1997){q=s+1|0;o=q;p=m;while(1){do if(n>>>0<(c[da>>2]|0)>>>0){c[ja>>2]=n+1;n=d[n>>0]|0}else{if(!(c[ea>>2]|0)){n=0;break}n=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!n){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+n;n=ha}c[ja>>2]=n+1;n=d[n>>0]|0}while(0);a[p>>0]=n;o=o+-1|0;if(!o)break;n=c[ja>>2]|0;p=p+4|0}n=q;m=m+((s<<2)+4)|0}v=n+v|0}}else{if(!w)break;n=((x|0)==3)<<31>>31;o=0;while(1){a[m>>0]=n;o=o+1|0;if((o|0)==(y|0))break;else m=m+4|0}}while(0);x=x+1|0}while((x|0)!=4)}N:do switch(k|0){case 0:case 4:break;default:{l=$k(l,4,k,z,A)|0;if(!l)l=0;else break N;i=la;return l|0}}while(0);if(j)c[j>>2]=B;c[h>>2]=A;c[f>>2]=z;h=l;i=la;return h|0}else n=0;while(1){if(l>>>0>=(c[da>>2]|0)>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}else{ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}if((m|0)!=(d[32110+n>>0]|0))break;n=n+1|0;if((n|0)>=4){m=0;ka=2045;break}}O:do if((ka|0)==2045){while(1){ka=0;if(l>>>0>=(c[da>>2]|0)>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}m=m+1|0;if((m|0)==84){n=0;break}else ka=2045}do{if(l>>>0>=(c[da>>2]|0)>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}else{ba=l+1|0;c[ja>>2]=ba;m=d[l>>0]|0;l=ba}if((m|0)!=(d[32115+n>>0]|0))break O;n=n+1|0}while((n|0)<4);o=c[x>>2]|0;c[ja>>2]=o;n=c[da>>2]|0;l=o;m=n;n=o>>>0<n>>>0;o=0;do{if(!n){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}o=o+1|0;n=l>>>0<m>>>0}while((o|0)!=92);if(!n)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}o=n<<8;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))n=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}L=n|o;if(l>>>0>=m>>>0)if(!(c[ea>>2]|0)){n=0;o=l}else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}o=l+1|0;c[ja>>2]=o;n=d[l>>0]|0}else{o=l+1|0;c[ja>>2]=o;n=d[l>>0]|0}n=n<<8;if(o>>>0>=m>>>0)if(!(c[ea>>2]|0)){l=0;m=o}else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}m=l+1|0;c[ja>>2]=m;l=d[l>>0]|0}else{m=o+1|0;c[ja>>2]=m;l=d[o>>0]|0}K=l|n;if(c[fa>>2]|0){if(rd[c[e+24>>2]&63](c[ga>>2]|0)|0)if(!(c[ea>>2]|0))ka=2104;else{w=c[ja>>2]|0;ka=2103}}else{w=m;ka=2103}if((ka|0)==2103?w>>>0>=(c[da>>2]|0)>>>0:0)ka=2104;if((ka|0)==2104){c[5682]=32120;h=0;i=la;return h|0}if((268435456/(L>>>0)|0)>>>0<K>>>0){c[5682]=30226;h=0;i=la;return h|0}l=c[ja>>2]|0;m=c[da>>2]|0;if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0)c[ja>>2]=l+1;else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}c[ja>>2]=l+1}while(0);I=L<<2;J=$(K,I)|0;m=fo(J)|0;uo(m|0,-1,J|0)|0;J=e+24|0;n=0;l=0;P:while(1){if((l|0)==10){ka=2165;break}v=l+1|0;o=c[ja>>2]|0;p=c[da>>2]|0;do if(o>>>0<p>>>0){ba=o+1|0;c[ja>>2]=ba;s=d[o>>0]|0;o=ba}else{if(!(c[ea>>2]|0)){s=0;break}o=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!o){c[ea>>2]=0;p=(c[da>>2]|0)+-1|0;c[ja>>2]=p;a[p>>0]=0;p=c[da>>2]|0;o=c[ja>>2]|0}else{c[ja>>2]=ha;p=e+40+o|0;c[da>>2]=p;o=ha}ba=o+1|0;c[ja>>2]=ba;s=d[o>>0]|0;o=ba}while(0);do if(o>>>0<p>>>0){ba=o+1|0;c[ja>>2]=ba;q=d[o>>0]|0;o=ba}else{if(!(c[ea>>2]|0)){q=0;break}o=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!o){c[ea>>2]=0;p=(c[da>>2]|0)+-1|0;c[ja>>2]=p;a[p>>0]=0;p=c[da>>2]|0;o=c[ja>>2]|0}else{c[ja>>2]=ha;p=e+40+o|0;c[da>>2]=p;o=ha}ba=o+1|0;c[ja>>2]=ba;q=d[o>>0]|0;o=ba}while(0);r=q&255;a[ca+(l*3|0)>>0]=r;do if(o>>>0<p>>>0){ba=o+1|0;c[ja>>2]=ba;q=d[o>>0]|0;o=ba}else{if(!(c[ea>>2]|0)){q=0;break}o=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!o){c[ea>>2]=0;p=(c[da>>2]|0)+-1|0;c[ja>>2]=p;a[p>>0]=0;p=c[da>>2]|0;o=c[ja>>2]|0}else{c[ja>>2]=ha;p=e+40+o|0;c[da>>2]=p;o=ha}ba=o+1|0;c[ja>>2]=ba;q=d[o>>0]|0;o=ba}while(0);a[ca+(l*3|0)+1>>0]=q;do if(o>>>0<p>>>0){ba=o+1|0;c[ja>>2]=ba;p=d[o>>0]|0;o=ba}else{if(!(c[ea>>2]|0)){p=0;break}o=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!o){c[ea>>2]=0;o=(c[da>>2]|0)+-1|0;c[ja>>2]=o;a[o>>0]=0;o=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+o;o=ha}ba=o+1|0;c[ja>>2]=ba;p=d[o>>0]|0;o=ba}while(0);a[ca+(l*3|0)+2>>0]=p;n=p|n;do if(!(c[fa>>2]|0)){y=o;ka=2198}else{if(!(rd[c[J>>2]&63](c[ga>>2]|0)|0))break;if(!(c[ea>>2]|0)){ka=2199;break P}y=c[ja>>2]|0;ka=2198}while(0);if((ka|0)==2198?(ka=0,y>>>0>=(c[da>>2]|0)>>>0):0){ka=2199;break}if(r<<24>>24!=8){ka=2201;break}if(!s){H=v;ka=2203;break}else l=v}Q:do if((ka|0)==2165){c[5682]=32129;l=0}else if((ka|0)==2199){c[5682]=32120;l=0}else if((ka|0)==2201){c[5682]=32129;l=0}else if((ka|0)==2203){c[j>>2]=(n>>>4&1)+3;if(!K){l=m;break}w=(l|0)>-1;x=(L|0)!=0;y=W+3|0;z=W+2|0;A=W+1|0;B=V+3|0;C=V+2|0;D=V+1|0;G=0;R:while(1){S:do if(w){E=m+($(G,I)|0)|0;F=0;while(1){T:do switch(d[ca+(F*3|0)+1>>0]|0){case 0:{if(!x)break T;l=d[ca+(F*3|0)+2>>0]|0;n=E;o=0;while(1){if(!(bl(e,l,n)|0)){l=0;break Q}o=o+1|0;if((o|0)>=(L|0))break;else n=n+4|0}break}case 1:{if(!x)break T;s=ca+(F*3|0)+2|0;r=E;v=L;while(1){l=c[ja>>2]|0;do if(l>>>0<(c[da>>2]|0)>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);do if(!(c[fa>>2]|0)){M=l;ka=2228}else{if(!(rd[c[J>>2]&63](c[ga>>2]|0)|0))break;if(!(c[ea>>2]|0)){ka=2229;break R}M=c[ja>>2]|0;ka=2228}while(0);if((ka|0)==2228?(ka=0,M>>>0>=(c[da>>2]|0)>>>0):0){ka=2229;break R}l=a[s>>0]|0;if(!(bl(e,l&255,W)|0)){l=0;break Q}q=((n|0)>(v|0)?v:n)&255;if(!q)l=r;else{p=((v|0)>(n|0)?n:v)&255;o=r;n=0;while(1){l=l&255;if(l&128)a[o>>0]=a[W>>0]|0;if(l&64)a[o+1>>0]=a[A>>0]|0;if(l&32)a[o+2>>0]=a[z>>0]|0;if(l&16)a[o+3>>0]=a[y>>0]|0;n=n+1|0;if((n|0)==(p|0))break;l=a[s>>0]|0;o=o+4|0}l=r+(p<<2)|0}v=v-q|0;if((v|0)<=0)break;else r=l}break}case 2:{if(!x)break T;r=ca+(F*3|0)+2|0;q=E;s=L;while(1){l=c[ja>>2]|0;do if(l>>>0<(c[da>>2]|0)>>>0){ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ba=l+1|0;c[ja>>2]=ba;n=d[l>>0]|0;l=ba}while(0);do if(!(c[fa>>2]|0)){N=l;ka=2256}else{if(!(rd[c[J>>2]&63](c[ga>>2]|0)|0))break;if(!(c[ea>>2]|0)){ka=2257;break R}N=c[ja>>2]|0;ka=2256}while(0);if((ka|0)==2256?(ka=0,N>>>0>=(c[da>>2]|0)>>>0):0){ka=2257;break R}do if(n>>>0>127){if((n|0)==128){l=c[ja>>2]|0;n=c[da>>2]|0;do if(l>>>0<n>>>0){ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;n=(c[da>>2]|0)+-1|0;c[ja>>2]=n;a[n>>0]=0;n=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;n=e+40+l|0;c[da>>2]=n;l=ha}ba=l+1|0;c[ja>>2]=ba;o=d[l>>0]|0;l=ba}while(0);o=o<<8;do if(l>>>0<n>>>0){c[ja>>2]=l+1;l=d[l>>0]|0}else{if(!(c[ea>>2]|0)){l=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}c[ja>>2]=l+1;l=d[l>>0]|0}while(0);p=l|o}else p=n+-127|0;if((p|0)>(s|0)){ka=2277;break R}l=a[r>>0]|0;if(!(bl(e,l&255,V)|0)){l=0;break Q}if((p|0)>0){o=q;n=0}else{n=p;l=q;break}while(1){l=l&255;if(l&128)a[o>>0]=a[V>>0]|0;if(l&64)a[o+1>>0]=a[D>>0]|0;if(l&32)a[o+2>>0]=a[C>>0]|0;if(l&16)a[o+3>>0]=a[B>>0]|0;n=n+1|0;if((n|0)==(p|0))break;l=a[r>>0]|0;o=o+4|0}n=p;l=q+(p<<2)|0}else{p=n+1|0;if((n|0)>=(s|0)){ka=2292;break R}o=d[r>>0]|0;l=q;n=0;while(1){if(!(bl(e,o,l)|0)){l=0;break Q}n=n+1|0;l=l+4|0;if((n|0)>=(p|0)){n=p;break}}}while(0);s=s-n|0;if((s|0)<=0)break;else q=l}break}default:{ka=2214;break R}}while(0);F=F+1|0;if((F|0)>=(H|0))break S}}while(0);G=G+1|0;if((G|0)>=(K|0)){l=m;break Q}}if((ka|0)==2214){c[5682]=32129;l=0;break}else if((ka|0)==2229){c[5682]=32120;l=0;break}else if((ka|0)==2257){c[5682]=32120;l=0;break}else if((ka|0)==2277){c[5682]=32120;l=0;break}else if((ka|0)==2292){c[5682]=32120;l=0;break}}while(0);if(!l){go(m);m=0}c[f>>2]=L;c[h>>2]=K;if(!k)l=c[j>>2]|0;else l=k;h=$k(m,4,l,L,K)|0;i=la;return h|0}while(0);l=c[x>>2]|0;c[ja>>2]=l;o=0;while(1){n=30088+o|0;if(l>>>0>=(c[da>>2]|0)>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}o=o+1|0;if((m|0)!=(a[n>>0]|0))break;if((o|0)==11){ka=2314;break}}if((ka|0)==2314){c[ja>>2]=c[x>>2];s=Hk(e,f,h,j,k)|0;if(!k)k=c[j>>2]|0;n=$(c[h>>2]|0,c[f>>2]|0)|0;o=fo($(k,n)|0)|0;if(!o){go(s);c[5682]=30100;h=0;i=la;return h|0}if((n|0)>0){r=k+-1+(k&1)|0;p=(r|0)>0;t=+g[5684];u=+g[5683];q=0;do{if(p){l=$(q,k)|0;m=0;do{h=m+l|0;ma=+Q(+(t*+g[s+(h<<2)>>2]),+u)*255.0+.5;ma=ma<0.0?0.0:ma;a[o+h>>0]=ma>255.0?-1:~~ma&255;m=m+1|0}while((m|0)!=(r|0));l=r}else l=0;if((l|0)<(k|0)){h=l+($(q,k)|0)|0;ma=+g[s+(h<<2)>>2]*255.0+.5;ma=ma<0.0?0.0:ma;a[o+h>>0]=ma>255.0?-1:~~ma&255}q=q+1|0}while((q|0)!=(n|0))}go(s);h=o;i=la;return h|0}l=c[x>>2]|0;c[ja>>2]=l;m=c[da>>2]|0;if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}if(l>>>0>=m>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}U:do if((m&255)<=1){if(l>>>0>=(c[da>>2]|0)>>>0)if(!(c[ea>>2]|0))m=0;else{l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}switch((m&255)<<24>>24){case 1:case 2:case 3:case 9:case 10:case 11:break;default:break U}m=c[da>>2]|0;if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}if(l>>>0>=m>>>0){if(c[ea>>2]|0){l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}}else{l=l+1|0;c[ja>>2]=l}do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}while(0);if(!(m|n))break;m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);n=n<<8;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){m=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}ca=l+1|0;c[ja>>2]=ca;m=d[l>>0]|0;l=ca}while(0);if(!(m|n))break;do if(l>>>0>=(c[da>>2]|0)>>>0){if(!(c[ea>>2]|0))break U;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0;break}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha;break}}while(0);c[ja>>2]=l+1;switch(d[l>>0]|0){case 8:case 16:case 24:case 32:break;default:break U}l=c[x>>2]|0;c[ja>>2]=l;m=c[da>>2]|0;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;x=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){x=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;x=d[l>>0]|0;l=ca}while(0);do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;w=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){w=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;w=d[l>>0]|0;l=ca}while(0);do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;v=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){v=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;v=d[l>>0]|0;l=ca}while(0);r=v&255;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}while(0);do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);s=n<<8|o;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}while(0);do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);M=n<<8|o;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;q=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){q=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;q=d[l>>0]|0;l=ca}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){l=l+1|0;c[ja>>2]=l}else{if(!(c[ea>>2]|0))break;l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}l=l+1|0;c[ja>>2]=l}while(0);do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}while(0);do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);L=n<<8|o;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}while(0);do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){n=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;n=d[l>>0]|0;l=ca}while(0);K=n<<8|o;do if(l>>>0<m>>>0){ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}else{if(!(c[ea>>2]|0)){o=0;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[da>>2]|0;l=c[ja>>2]|0}else{c[ja>>2]=ha;m=e+40+l|0;c[da>>2]=m;l=ha}ca=l+1|0;c[ja>>2]=ca;o=d[l>>0]|0;l=ca}while(0);n=o&255;do if(l>>>0<m>>>0){p=l+1|0;c[ja>>2]=p;J=d[l>>0]|0}else{if(!(c[ea>>2]|0)){J=0;p=l;break}l=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!l){c[ea>>2]=0;l=(c[da>>2]|0)+-1|0;c[ja>>2]=l;a[l>>0]=0;l=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+l;l=ha}p=l+1|0;c[ja>>2]=p;J=d[l>>0]|0}while(0);I=(r&255)>7;V:do if(((I?v+-8|0:v)+-1|0)>>>0>2|((L|0)==0|(K|0)==0))l=0;else{switch(n<<24>>24){case 8:case 16:case 24:case 32:break;default:{l=0;break V}}H=(w|0)!=0;G=H?q:o;c[f>>2]=L;c[h>>2]=K;F=G>>>3;E=(k+-1|0)>>>0>3?F:k;c[j>>2]=F;D=$(K,L)|0;l=fo($(E,D)|0)|0;if(!l){c[5682]=30100;l=0;break}do if(!(c[fa>>2]|0))ka=2582;else{m=c[da>>2]|0;n=m-p|0;if((x|0)<=(n|0)){ka=2582;break}c[ja>>2]=m;qd[c[e+20>>2]&63](c[ga>>2]|0,x-n|0)}while(0);if((ka|0)==2582)c[ja>>2]=p+x;W:do if(H){do if(!(c[fa>>2]|0)){m=c[ja>>2]|0;ka=2588}else{n=c[da>>2]|0;m=c[ja>>2]|0;o=n-m|0;if((s|0)<=(o|0)){ka=2588;break}c[ja>>2]=n;qd[c[e+20>>2]&63](c[ga>>2]|0,s-o|0)}while(0);if((ka|0)==2588)c[ja>>2]=m+s;q=($(q,M)|0)>>>3;r=fo(q)|0;if(!r){c[5682]=30100;l=0;break V}m=c[fa>>2]|0;do if(m){n=c[da>>2]|0;o=c[ja>>2]|0;p=n-o|0;if((q|0)<=(p|0)){ka=2594;break}so(r|0,o|0,p|0)|0;h=q-p|0;h=(jd[m&15](c[ga>>2]|0,r+p|0,h)|0)==(h|0);c[ja>>2]=c[da>>2];if(h){C=r;break W}}else{o=c[ja>>2]|0;n=c[da>>2]|0;ka=2594}while(0);do if((ka|0)==2594){m=o+q|0;if(m>>>0>n>>>0)break;so(r|0,o|0,q|0)|0;c[ja>>2]=m;C=r;break W}while(0);go(l);go(r);c[5682]=32140;l=0;break V}else C=0;while(0);X:do if(D){w=(G|0)==0;x=W+1|0;y=W+2|0;z=W+3|0;A=G>>>0>8?((G+-1|0)>>>3)+1|0:1;o=0;m=0;B=0;n=1;v=0;q=0;r=0;k=0;while(1){do if(I){if(o){if(!m){s=0;ka=2612;break}if(!n){p=v;break}else{s=m;ka=2612;break}}m=c[ja>>2]|0;do if(m>>>0<(c[da>>2]|0)>>>0){c[ja>>2]=m+1;m=d[m>>0]|0}else{if(!(c[ea>>2]|0)){m=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+m;m=ha}c[ja>>2]=m+1;m=d[m>>0]|0}while(0);o=(m&127)+1|0;s=m>>>7;ka=2612}else{s=m;ka=2612}while(0);Y:do if((ka|0)==2612){ka=0;if(H){m=c[ja>>2]|0;do if(m>>>0<(c[da>>2]|0)>>>0){c[ja>>2]=m+1;m=d[m>>0]|0}else{if(!(c[ea>>2]|0)){m=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+m;m=ha}c[ja>>2]=m+1;m=d[m>>0]|0}while(0);if(w){m=s;p=v;break}so(W|0,C+($(m>>>0>=M>>>0?0:m,F)|0)|0,A|0)|0}else{if(w){m=s;p=v;break}m=c[ja>>2]|0;p=0;do{do if(m>>>0<(c[da>>2]|0)>>>0){h=m+1|0;c[ja>>2]=h;n=d[m>>0]|0;m=h}else{if(!(c[ea>>2]|0)){n=0;break}m=jd[c[fa>>2]&15](c[ga>>2]|0,ha,c[ia>>2]|0)|0;if(!m){c[ea>>2]=0;m=(c[da>>2]|0)+-1|0;c[ja>>2]=m;a[m>>0]=0;m=c[ja>>2]|0}else{c[ja>>2]=ha;c[da>>2]=e+40+m;m=ha}h=m+1|0;c[ja>>2]=h;n=d[m>>0]|0;m=h}while(0);a[W+p>>0]=n;p=p+1|0}while((p|0)!=(A|0))}switch(G|0){case 8:{k=a[W>>0]|0;m=s;p=k;q=k;r=-1;break Y}case 16:{k=a[W>>0]|0;m=s;p=k;q=k;r=a[x>>0]|0;break Y}case 24:{m=s;p=a[y>>0]|0;q=a[W>>0]|0;r=-1;k=a[x>>0]|0;break Y}case 32:{m=s;p=a[y>>0]|0;q=a[W>>0]|0;r=a[z>>0]|0;k=a[x>>0]|0;break Y}default:{m=s;p=v;break Y}}}while(0);switch(E|0){case 1:{a[l+B>>0]=(((k&255)*150|0)+((q&255)*29|0)+((p&255)*77|0)|0)>>>8;break}case 2:{h=B<<1;a[l+h>>0]=(((k&255)*150|0)+((q&255)*29|0)+((p&255)*77|0)|0)>>>8;a[l+(h|1)>>0]=r;break}case 3:{h=B*3|0;a[l+h>>0]=p;a[l+(h+1)>>0]=k;a[l+(h+2)>>0]=q;break}case 4:{h=B<<2;a[l+h>>0]=p;a[l+(h|1)>>0]=k;a[l+(h|2)>>0]=q;a[l+(h|3)>>0]=r;break}default:{}}B=B+1|0;if((B|0)>=(D|0))break X;else{o=o+-1|0;n=0;v=p}}}while(0);if(!(J&32)){r=$(E,L)|0;k=K+-1|0;s=(r|0)>0;m=K>>>0>2?(k>>>1)+1|0:1;q=0;do{if(s){n=r;o=$(q,r)|0;p=$(k-q|0,r)|0;while(1){ka=l+o|0;f=a[ka>>0]|0;h=l+p|0;a[ka>>0]=a[h>>0]|0;a[h>>0]=f;if((n|0)>1){n=n+-1|0;o=o+1|0;p=p+1|0}else break}}q=q+1|0}while((q|0)!=(m|0))}if(!C)break;go(C)}while(0);h=l;i=la;return h|0}while(0);c[ja>>2]=c[x>>2];c[5682]=30109;h=0;i=la;return h|0}
function Hk(b,e,f,h,j){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;K=i;i=i+1040|0;m=K+8|0;n=K+4|0;J=K;if(Jn(Mk(b,m)|0,30128)|0){c[5682]=31664;b=0;i=K;return b|0}k=Mk(b,m)|0;c[n>>2]=k;if(a[k>>0]|0){l=0;do{k=(Jn(k,30139)|0)==0;l=k?1:l;k=Mk(b,m)|0}while((a[k>>0]|0)!=0);c[n>>2]=k;if(l){k=Mk(b,m)|0;c[n>>2]=k;if(On(k,30162,3)|0){c[5682]=31691;b=0;i=K;return b|0}D=k+3|0;c[n>>2]=D;D=Bn(D,n,10)|0;k=c[n>>2]|0;if((a[k>>0]|0)==32){do k=k+1|0;while((a[k>>0]|0)==32);c[n>>2]=k}if(On(k,30166,3)|0){c[5682]=31691;b=0;i=K;return b|0}C=k+3|0;c[n>>2]=C;C=Bn(C,0,10)|0;c[e>>2]=C;c[f>>2]=D;c[h>>2]=3;B=(j|0)==0?3:j;k=fo($($(B<<2,D)|0,C)|0)|0;a:do if((C+-8|0)>>>0>32759){l=0;E=17}else{b:do if((D|0)>0){z=b+168|0;w=b+172|0;r=C<<2;s=(C|0)>0;x=b+32|0;m=b+16|0;u=b+28|0;y=b+40|0;v=b+36|0;A=(B|0)<3;t=0;l=0;while(1){n=c[z>>2]|0;h=c[w>>2]|0;if(n>>>0>=h>>>0)if(!(c[x>>2]|0))e=0;else{n=jd[c[m>>2]&15](c[u>>2]|0,y,c[v>>2]|0)|0;if(!n){c[x>>2]=0;h=(c[w>>2]|0)+-1|0;c[z>>2]=h;a[h>>0]=0;h=c[w>>2]|0;n=c[z>>2]|0}else{c[z>>2]=y;h=b+40+n|0;c[w>>2]=h;n=y}q=n+1|0;c[z>>2]=q;e=d[n>>0]|0;n=q}else{q=n+1|0;c[z>>2]=q;e=d[n>>0]|0;n=q}if(n>>>0>=h>>>0)if(!(c[x>>2]|0))j=0;else{n=jd[c[m>>2]&15](c[u>>2]|0,y,c[v>>2]|0)|0;if(!n){c[x>>2]=0;h=(c[w>>2]|0)+-1|0;c[z>>2]=h;a[h>>0]=0;h=c[w>>2]|0;n=c[z>>2]|0}else{c[z>>2]=y;h=b+40+n|0;c[w>>2]=h;n=y}q=n+1|0;c[z>>2]=q;j=d[n>>0]|0;n=q}else{q=n+1|0;c[z>>2]=q;j=d[n>>0]|0;n=q}if(n>>>0>=h>>>0)if(!(c[x>>2]|0))h=0;else{n=jd[c[m>>2]&15](c[u>>2]|0,y,c[v>>2]|0)|0;if(!n){c[x>>2]=0;n=(c[w>>2]|0)+-1|0;c[z>>2]=n;a[n>>0]=0;n=c[z>>2]|0}else{c[z>>2]=y;c[w>>2]=b+40+n;n=y}q=n+1|0;c[z>>2]=q;h=d[n>>0]|0;n=q}else{q=n+1|0;c[z>>2]=q;h=d[n>>0]|0;n=q}if(!((e|0)==2&(j|0)==2&(h&128|0)==0))break;h=h<<8;if(n>>>0>=(c[w>>2]|0)>>>0)if(!(c[x>>2]|0))n=0;else{n=jd[c[m>>2]&15](c[u>>2]|0,y,c[v>>2]|0)|0;if(!n){c[x>>2]=0;n=(c[w>>2]|0)+-1|0;c[z>>2]=n;a[n>>0]=0;n=c[z>>2]|0}else{c[z>>2]=y;c[w>>2]=b+40+n;n=y}c[z>>2]=n+1;n=d[n>>0]|0}else{c[z>>2]=n+1;n=d[n>>0]|0}if((n|h|0)!=(C|0)){E=88;break}if(!l)l=fo(r)|0;q=0;do{if(s){n=0;do{h=c[z>>2]|0;do if(h>>>0<(c[w>>2]|0)>>>0){f=h+1|0;c[z>>2]=f;p=d[h>>0]|0;h=f}else{if(!(c[x>>2]|0)){p=0;break}h=jd[c[m>>2]&15](c[u>>2]|0,y,c[v>>2]|0)|0;if(!h){c[x>>2]=0;h=(c[w>>2]|0)+-1|0;c[z>>2]=h;a[h>>0]=0;h=c[z>>2]|0}else{c[z>>2]=y;c[w>>2]=b+40+h;h=y}f=h+1|0;c[z>>2]=f;p=d[h>>0]|0;h=f}while(0);do if((p&255)>128){do if(h>>>0<(c[w>>2]|0)>>>0){c[z>>2]=h+1;h=d[h>>0]|0}else{if(!(c[x>>2]|0)){h=0;break}h=jd[c[m>>2]&15](c[u>>2]|0,y,c[v>>2]|0)|0;if(!h){c[x>>2]=0;h=(c[w>>2]|0)+-1|0;c[z>>2]=h;a[h>>0]=0;h=c[z>>2]|0}else{c[z>>2]=y;c[w>>2]=b+40+h;h=y}c[z>>2]=h+1;h=d[h>>0]|0}while(0);f=h&255;h=p+128&255;if(!h)break;else{j=n;e=0}while(1){a[l+((j<<2)+q)>>0]=f;e=e+1|0;if((e|0)==(h|0))break;else j=j+1|0}n=h+n|0}else{if(!p)break;f=p>>>0>1;e=n;j=0;while(1){do if(h>>>0<(c[w>>2]|0)>>>0){c[z>>2]=h+1;h=d[h>>0]|0}else{if(!(c[x>>2]|0)){h=0;break}h=jd[c[m>>2]&15](c[u>>2]|0,y,c[v>>2]|0)|0;if(!h){c[x>>2]=0;h=(c[w>>2]|0)+-1|0;c[z>>2]=h;a[h>>0]=0;h=c[z>>2]|0}else{c[z>>2]=y;c[w>>2]=b+40+h;h=y}c[z>>2]=h+1;h=d[h>>0]|0}while(0);a[l+((e<<2)+q)>>0]=h;j=j+1|0;if((j|0)>=(p|0))break;h=c[z>>2]|0;e=e+1|0}n=(f?p:1)+n|0}while(0)}while((n|0)<(C|0))}q=q+1|0}while((q|0)!=4);if(s){h=$(t,C)|0;p=0;do{j=$(p+h|0,B)|0;e=k+(j<<2)|0;f=p<<2;n=a[l+(f|3)>>0]|0;c:do if(!(n<<24>>24)){switch(B|0){case 4:{g[k+(j+3<<2)>>2]=1.0;E=136;break}case 3:{E=136;break}case 2:{g[k+(j+1<<2)>>2]=1.0;E=138;break}case 1:{E=138;break}default:break c}if((E|0)==136){E=0;g[k+(j+2<<2)>>2]=0.0;g[k+(j+1<<2)>>2]=0.0;g[e>>2]=0.0;break}else if((E|0)==138){E=0;g[e>>2]=0.0;break}}else{o=+Fm(1.0,(n&255)+-136|0);n=d[l+f>>0]|0;if(A)g[e>>2]=o*+((d[l+(f|1)>>0]|0)+n+(d[l+(f|2)>>0]|0)|0)/3.0;else{g[e>>2]=o*+(n|0);g[k+(j+1<<2)>>2]=o*+(d[l+(f|1)>>0]|0);g[k+(j+2<<2)>>2]=o*+(d[l+(f|2)>>0]|0)}switch(B|0){case 2:{g[k+(j+1<<2)>>2]=1.0;break c}case 4:{g[k+(j+3<<2)>>2]=1.0;break c}default:break c}}while(0);p=p+1|0}while((p|0)!=(C|0))}t=t+1|0;if((t|0)>=(D|0))break b}if((E|0)==88){go(k);go(l);c[5682]=31715;b=0;i=K;return b|0}do if(n>>>0>=(c[w>>2]|0)>>>0)if(c[x>>2]|0){n=jd[c[m>>2]&15](c[u>>2]|0,y,c[v>>2]|0)|0;if(!n){c[x>>2]=0;n=(c[w>>2]|0)+-1|0;c[z>>2]=n;a[n>>0]=0;n=c[z>>2]|0;E=67;break}else{c[z>>2]=y;c[w>>2]=b+40+n;n=y;E=67;break}}else E=74;else E=67;while(0);d:do if((E|0)==67){c[z>>2]=n+1;n=a[n>>0]|0;if(!(n<<24>>24))E=74;else{o=+Fm(1.0,(n&255)+-136|0);if(A)g[k>>2]=+(j+e+h|0)*o/3.0;else{g[k>>2]=+(e|0)*o;g[k+4>>2]=+(j|0)*o;g[k+8>>2]=+(h|0)*o}switch(B|0){case 2:{g[k+4>>2]=1.0;break d}case 4:{g[k+12>>2]=1.0;break d}default:break d}}}while(0);e:do if((E|0)==74){switch(B|0){case 4:{g[k+12>>2]=1.0;E=76;break}case 3:{E=76;break}case 2:{g[k+4>>2]=1.0;E=78;break}case 1:{E=78;break}default:break e}if((E|0)==76){g[k+8>>2]=0.0;g[k+4>>2]=0.0;g[k>>2]=0.0;break}else if((E|0)==78){g[k>>2]=0.0;break}}while(0);go(l);n=1;l=0;E=20;break a}else l=0;while(0);go(l);b=k;i=K;return b|0}while(0);while(1){if((E|0)==17)if((l|0)<(D|0))n=0;else break;else if((E|0)==20){E=0;m=c[m>>2]|0;if(m){h=b+172|0;j=c[h>>2]|0;e=b+168|0;f=c[e>>2]|0;p=j-f|0;if((p|0)<4){so(J|0,f|0,p|0)|0;jd[m&15](c[b+28>>2]|0,J+p|0,4-p|0)|0;c[e>>2]=c[h>>2]}else{F=e;H=f;I=j;E=24}}else{H=b+168|0;F=H;H=c[H>>2]|0;I=c[b+172>>2]|0;E=24}if((E|0)==24?(0,G=H+4|0,G>>>0<=I>>>0):0){c[J>>2]=d[H>>0]|d[H+1>>0]<<8|d[H+2>>0]<<16|d[H+3>>0]<<24;c[F>>2]=G}e=$(($(l,C)|0)+n|0,B)|0;f=k+(e<<2)|0;m=a[J+3>>0]|0;f:do if(!(m<<24>>24)){switch(B|0){case 4:{g[k+(e+3<<2)>>2]=1.0;E=35;break}case 3:{E=35;break}case 2:{g[k+(e+1<<2)>>2]=1.0;E=37;break}case 1:{E=37;break}default:break f}if((E|0)==35){g[k+(e+2<<2)>>2]=0.0;g[k+(e+1<<2)>>2]=0.0;g[f>>2]=0.0;break}else if((E|0)==37){g[f>>2]=0.0;break}}else{o=+Fm(1.0,(m&255)+-136|0);j=c[J>>2]|0;m=j&255;h=(j&65535)>>>8;j=j>>>16;if((B|0)<3)g[f>>2]=o*+((j&255)+m+(h&65535)|0)/3.0;else{g[f>>2]=o*+(m|0);g[k+(e+1<<2)>>2]=o*+(h&65535|0);g[k+(e+2<<2)>>2]=o*+(j&255|0)}switch(B|0){case 2:{g[k+(e+1<<2)>>2]=1.0;break f}case 4:{g[k+(e+3<<2)>>2]=1.0;break f}default:break f}}while(0);n=n+1|0}if((n|0)<(C|0)){m=b+16|0;E=20;continue}else{l=l+1|0;E=17;continue}}i=K;return k|0}}c[5682]=31672;b=0;i=K;return b|0}function Ik(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;D=i;i=i+2496|0;C=D;B=D+2039|0;A=D+2020|0;x=b+20|0;c[x>>2]=e;y=b+16|0;c[y>>2]=e;z=b+24|0;c[z>>2]=e+f;w=b+28|0;c[w>>2]=g;if(h){e=c[b>>2]|0;h=b+4|0;f=c[h>>2]|0;if(e>>>0<f>>>0){v=e+1|0;c[b>>2]=v;g=d[e>>0]|0;e=v}else g=0;if(e>>>0<f>>>0){c[b>>2]=e+1;e=d[e>>0]|0}else e=0;if(((e|g<<8)>>>0)%31|0){c[5682]=30982;C=0;i=D;return C|0}if(e&32){c[5682]=30998;C=0;i=D;return C|0}if((g&15|0)!=8){c[5682]=31013;C=0;i=D;return C|0}}else h=b+4|0;p=b+8|0;c[p>>2]=0;q=b+12|0;c[q>>2]=0;r=b+32|0;s=b+2052|0;t=C+1|0;u=C+3|0;v=C+2|0;e=0;g=0;a:while(1){if((g|0)>=1){j=e&1;e=e>>>1;c[q>>2]=e;f=g+-1|0;c[p>>2]=f;if((g|0)<3){g=e;while(1){if(g>>>0>=1<<f>>>0){m=23;break a}e=c[b>>2]|0;if(e>>>0<(c[h>>2]|0)>>>0){c[b>>2]=e+1;e=d[e>>0]|0}else e=0;g=e<<f|g;c[q>>2]=g;f=f+8|0;c[p>>2]=f;if((f|0)>=25){o=j;break}}}else{o=j;g=e}}else{while(1){if(e>>>0>=1<<g>>>0){m=16;break a}f=c[b>>2]|0;if(f>>>0<(c[h>>2]|0)>>>0){c[b>>2]=f+1;f=d[f>>0]|0}else f=0;e=f<<g|e;c[q>>2]=e;f=g+8|0;c[p>>2]=f;if((f|0)<25)g=f;else{f=g;break}}g=e>>>1;c[q>>2]=g;f=f+7|0;c[p>>2]=f;o=e&1}e=g>>>2;c[q>>2]=e;f=f+-2|0;c[p>>2]=f;switch(g&3|0){case 3:{e=0;m=174;break a}case 0:{j=f&7;if(j){if((f|0)<(j|0))do{if(e>>>0>=1<<f>>>0){m=31;break a}g=c[b>>2]|0;if(g>>>0<(c[h>>2]|0)>>>0){c[b>>2]=g+1;g=d[g>>0]|0}else g=0;e=g<<f|e;c[q>>2]=e;f=f+8|0;c[p>>2]=f}while((f|0)<25);e=e>>>j;c[q>>2]=e;f=f-j|0;c[p>>2]=f}if((f|0)>0){k=(f+8+((f|0)<8?~f:-9)|0)>>>3;g=k+1|0;j=0;do{a[C+j>>0]=e;j=j+1|0;e=e>>>8}while((j|0)!=(g|0));f=f+-8-(k<<3)|0;c[q>>2]=e;c[p>>2]=f}else g=0;if(f){m=43;break a}if((g|0)<4){j=c[h>>2]|0;e=c[b>>2]|0;do{if(e>>>0<j>>>0){n=e+1|0;c[b>>2]=n;f=d[e>>0]|0;e=n}else f=0;a[C+g>>0]=f;g=g+1|0}while((g|0)!=4)}l=d[t>>0]<<8|d[C>>0];if((d[u>>0]<<8|d[v>>0]|0)!=(l^65535|0)){m=48;break a}e=c[b>>2]|0;if((e+l|0)>>>0>(c[h>>2]|0)>>>0){m=50;break a}f=c[y>>2]|0;g=c[z>>2]|0;if((f+l|0)>>>0>g>>>0){if(!(c[w>>2]|0)){m=53;break a}j=c[x>>2]|0;e=j;k=f-e|0;f=k+l|0;e=g-e|0;while(1)if((f|0)>(e|0))e=e<<1;else{f=e;break}e=io(j,f)|0;if(!e){m=57;break a}c[x>>2]=e;n=e+k|0;c[y>>2]=n;c[z>>2]=e+f;f=n;e=c[b>>2]|0}so(f|0,e|0,l|0)|0;c[b>>2]=(c[b>>2]|0)+l;c[y>>2]=(c[y>>2]|0)+l;break}case 1:{if(!(a[31199]|0)){uo(31200,8,144)|0;f=31344;g=f+112|0;do{a[f>>0]=9;f=f+1|0}while((f|0)<(g|0));f=31456;g=f+24|0;do{a[f>>0]=7;f=f+1|0}while((f|0)<(g|0));f=31480;g=f;a[g>>0]=8;a[g+1>>0]=8;a[g+2>>0]=8;a[g+3>>0]=8;f=f+4|0;a[f>>0]=8;a[f+1>>0]=8;a[f+2>>0]=8;a[f+3>>0]=8;f=31168;g=f+32|0;do{a[f>>0]=5;f=f+1|0}while((f|0)<(g|0))}if(!(Sk(r,31200,288)|0)){e=0;m=174;break a}if(!(Sk(s,31168,32)|0)){e=0;m=174;break a}else m=126;break}default:{if((f|0)<5){g=e;while(1){if(g>>>0>=1<<f>>>0){m=67;break a}e=c[b>>2]|0;if(e>>>0<(c[h>>2]|0)>>>0){c[b>>2]=e+1;e=d[e>>0]|0}else e=0;e=e<<f|g;c[q>>2]=e;f=f+8|0;c[p>>2]=f;if((f|0)<25)g=e;else break}}g=e>>>5;c[q>>2]=g;f=f+-5|0;c[p>>2]=f;n=(e&31)+257|0;if((f|0)<5)while(1){if(g>>>0>=1<<f>>>0){m=73;break a}e=c[b>>2]|0;if(e>>>0<(c[h>>2]|0)>>>0){c[b>>2]=e+1;e=d[e>>0]|0}else e=0;e=e<<f|g;c[q>>2]=e;f=f+8|0;c[p>>2]=f;if((f|0)<25)g=e;else break}else e=g;g=e>>>5;c[q>>2]=g;f=f+-5|0;c[p>>2]=f;m=(e&31)+1|0;if((f|0)<4)while(1){if(g>>>0>=1<<f>>>0){m=79;break a}e=c[b>>2]|0;if(e>>>0<(c[h>>2]|0)>>>0){c[b>>2]=e+1;e=d[e>>0]|0}else e=0;e=e<<f|g;c[q>>2]=e;f=f+8|0;c[p>>2]=f;if((f|0)<25)g=e;else break}else e=g;j=e&15;k=e>>>4;c[q>>2]=k;e=f+-4|0;c[p>>2]=e;f=A;g=f+19|0;do{a[f>>0]=0;f=f+1|0}while((f|0)<(g|0));l=j+3|0;f=k;j=0;while(1){if((e|0)<3){g=e;while(1){if(f>>>0>=1<<g>>>0){m=86;break a}e=c[b>>2]|0;if(e>>>0<(c[h>>2]|0)>>>0){c[b>>2]=e+1;e=d[e>>0]|0}else e=0;f=e<<g|f;c[q>>2]=f;e=g+8|0;c[p>>2]=e;if((e|0)<25)g=e;else{g=f;break}}}else g=f;f=g>>>3;c[q>>2]=f;e=e+-3|0;c[p>>2]=e;a[A+(d[31488+j>>0]|0)>>0]=g&7;if((j|0)>=(l|0))break;else j=j+1|0}do if(Sk(C,A,19)|0){k=m+n|0;e=0;do{f=Tk(b,C)|0;if(f>>>0>=19){m=94;break a}b:do if((f|0)<16){a[B+e>>0]=f;e=e+1|0}else switch(f|0){case 16:{f=c[p>>2]|0;g=c[q>>2]|0;if((f|0)<2){j=g;while(1){if(j>>>0>=1<<f>>>0){m=100;break a}g=c[b>>2]|0;if(g>>>0<(c[h>>2]|0)>>>0){c[b>>2]=g+1;g=d[g>>0]|0}else g=0;g=g<<f|j;c[q>>2]=g;f=f+8|0;c[p>>2]=f;if((f|0)<25)j=g;else break}}c[q>>2]=g>>>2;c[p>>2]=f+-2;l=(g&3)+3|0;uo(B+e|0,a[B+(e+-1)>>0]|0,l|0)|0;e=l+e|0;break b}case 17:{f=c[p>>2]|0;g=c[q>>2]|0;if((f|0)<3){j=g;while(1){if(j>>>0>=1<<f>>>0){m=108;break a}g=c[b>>2]|0;if(g>>>0<(c[h>>2]|0)>>>0){c[b>>2]=g+1;g=d[g>>0]|0}else g=0;g=g<<f|j;c[q>>2]=g;f=f+8|0;c[p>>2]=f;if((f|0)<25)j=g;else break}}c[q>>2]=g>>>3;c[p>>2]=f+-3;l=(g&7)+3|0;uo(B+e|0,0,l|0)|0;e=l+e|0;break b}case 18:{f=c[p>>2]|0;g=c[q>>2]|0;if((f|0)<7){j=g;while(1){if(j>>>0>=1<<f>>>0){m=116;break a}g=c[b>>2]|0;if(g>>>0<(c[h>>2]|0)>>>0){c[b>>2]=g+1;g=d[g>>0]|0}else g=0;g=g<<f|j;c[q>>2]=g;f=f+8|0;c[p>>2]=f;if((f|0)<25)j=g;else break}}c[q>>2]=g>>>7;c[p>>2]=f+-7;l=(g&127)+11|0;uo(B+e|0,0,l|0)|0;e=l+e|0;break b}default:{m=113;break a}}while(0)}while((e|0)<(k|0));if((e|0)!=(k|0)){c[5682]=31554;e=0;break}if(Sk(r,B,n)|0)e=(Sk(s,B+n|0,m)|0)!=0&1;else e=0}else e=0;while(0);if(!e){e=0;m=174;break a}else m=126}}c:do if((m|0)==126)d:while(1){m=0;k=Tk(b,r)|0;if((k|0)<256){if((k|0)<0){m=128;break a}e=c[y>>2]|0;f=c[z>>2]|0;if(e>>>0>=f>>>0){if(!(c[w>>2]|0)){m=131;break a}g=c[x>>2]|0;n=g;j=e-n|0;e=f-n|0;while(1)if((j|0)<(e|0)){f=e;break}else e=e<<1;e=io(g,f)|0;if(!e){m=135;break a}c[x>>2]=e;n=e+j|0;c[y>>2]=n;c[z>>2]=e+f;e=n}c[y>>2]=e+1;a[e>>0]=k;m=126;continue}if((k|0)==256)break c;e=k+-257|0;l=c[22860+(e<<2)>>2]|0;if((k+-265|0)>>>0<20){j=c[22984+(e<<2)>>2]|0;e=c[p>>2]|0;f=c[q>>2]|0;if((e|0)<(j|0)){g=f;while(1){if(g>>>0>=1<<e>>>0){m=142;break a}f=c[b>>2]|0;if(f>>>0<(c[h>>2]|0)>>>0){c[b>>2]=f+1;f=d[f>>0]|0}else f=0;f=f<<e|g;c[q>>2]=f;e=e+8|0;c[p>>2]=e;if((e|0)<25)g=f;else break}}c[q>>2]=f>>>j;c[p>>2]=e-j;m=(f&(1<<j)+-1)+l|0}else m=l;e=Tk(b,s)|0;if((e|0)<0){m=148;break a}l=c[23108+(e<<2)>>2]|0;if((e+-4|0)>>>0<26){j=c[23236+(e<<2)>>2]|0;e=c[p>>2]|0;f=c[q>>2]|0;if((e|0)<(j|0)){g=f;while(1){if(g>>>0>=1<<e>>>0){m=152;break a}f=c[b>>2]|0;if(f>>>0<(c[h>>2]|0)>>>0){c[b>>2]=f+1;f=d[f>>0]|0}else f=0;f=f<<e|g;c[q>>2]=f;e=e+8|0;c[p>>2]=e;if((e|0)<25)g=f;else break}}c[q>>2]=f>>>j;c[p>>2]=e-j;l=(f&(1<<j)+-1)+l|0}g=c[y>>2]|0;j=c[x>>2]|0;e=j;k=g-e|0;if((k|0)<(l|0)){m=158;break a}f=c[z>>2]|0;if((g+m|0)>>>0>f>>>0){if(!(c[w>>2]|0)){m=161;break a}g=k+m|0;e=f-e|0;while(1)if((g|0)>(e|0))e=e<<1;else{f=e;break}e=io(j,f)|0;if(!e){m=165;break a}c[x>>2]=e;g=e+k|0;c[y>>2]=g;c[z>>2]=e+f}if(!m){m=126;continue}f=g+(0-l)|0;e=m+-1|0;n=a[f>>0]|0;c[y>>2]=g+1;a[g>>0]=n;if(!e){m=126;continue}while(1){f=f+1|0;n=c[y>>2]|0;e=e+-1|0;m=a[f>>0]|0;c[y>>2]=n+1;a[n>>0]=m;if(!e){m=126;continue d}}}while(0);if(!(c[5681]|0)){if(o){e=1;m=174;break}}else if(!((o|0)==0?((c[y>>2]|0)-(c[x>>2]|0)|0)<65537:0)){e=1;m=174;break}e=c[q>>2]|0;g=c[p>>2]|0}switch(m|0){case 16:{Ba(31029,30466,1727,31066);break}case 23:{Ba(31029,30466,1727,31066);break}case 31:{Ba(31029,30466,1727,31066);break}case 43:{Ba(31076,30466,1888,31093);break}case 48:{c[5682]=31118;break}case 50:{c[5682]=31131;break}case 53:{c[5682]=31148;break}case 57:{c[5682]=30100;break}case 67:{Ba(31029,30466,1727,31066);break}case 73:{Ba(31029,30466,1727,31066);break}case 79:{Ba(31029,30466,1727,31066);break}case 86:{Ba(31029,30466,1727,31066);break}case 94:{Ba(31507,30466,1851,31524);break}case 100:{Ba(31029,30466,1727,31066);break}case 108:{Ba(31029,30466,1727,31066);break}case 113:{Ba(31546,30466,1863,31524);break}case 116:{Ba(31029,30466,1727,31066);break}case 128:{c[5682]=31570;C=0;i=D;return C|0}case 131:{c[5682]=31148;C=0;i=D;return C|0}case 135:{c[5682]=30100;C=0;i=D;return C|0}case 142:{Ba(31029,30466,1727,31066);break}case 148:{c[5682]=31570;C=0;i=D;return C|0}case 152:{Ba(31029,30466,1727,31066);break}case 158:{c[5682]=31587;C=0;i=D;return C|0}case 161:{c[5682]=31148;C=0;i=D;return C|0}case 165:{c[5682]=30100;C=0;i=D;return C|0}case 174:{i=D;return e|0}}C=0;i=D;return C|0}function Jk(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;o=b+13956|0;a[o>>0]=-1;j=c[b>>2]|0;k=j+168|0;h=c[k>>2]|0;l=j+172|0;do if(h>>>0>=(c[l>>2]|0)>>>0){i=j+32|0;if(c[i>>2]|0){g=j+40|0;h=jd[c[j+16>>2]&15](c[j+28>>2]|0,g,c[j+36>>2]|0)|0;if(!h){c[i>>2]=0;g=(c[l>>2]|0)+-1|0;c[k>>2]=g;a[g>>0]=0;g=c[k>>2]|0;z=6;break}else{c[k>>2]=g;c[l>>2]=j+40+h;z=6;break}}}else{g=h;z=6}while(0);a:do if((z|0)==6?(c[k>>2]=g+1,(a[g>>0]|0)==-1):0){b:while(1){j=c[b>>2]|0;l=j+168|0;g=c[l>>2]|0;k=j+172|0;if(g>>>0>=(c[k>>2]|0)>>>0){h=j+32|0;if(!(c[h>>2]|0))g=0;else{g=j+40|0;i=jd[c[j+16>>2]&15](c[j+28>>2]|0,g,c[j+36>>2]|0)|0;if(!i){c[h>>2]=0;g=(c[k>>2]|0)+-1|0;c[l>>2]=g;a[g>>0]=0;g=c[l>>2]|0}else{c[l>>2]=g;c[k>>2]=j+40+i}c[l>>2]=g+1;g=d[g>>0]|0}}else{c[l>>2]=g+1;g=d[g>>0]|0}switch((g&255)<<24>>24){case -1:break;case -40:break b;default:break a}}if((e|0)==1){b=1;return b|0}g=a[o>>0]|0;c:do if(g<<24>>24==-1){j=c[b>>2]|0;l=j+168|0;g=c[l>>2]|0;k=j+172|0;do if(g>>>0>=(c[k>>2]|0)>>>0){h=j+32|0;if(!(c[h>>2]|0)){g=-1;break c}g=j+40|0;i=jd[c[j+16>>2]&15](c[j+28>>2]|0,g,c[j+36>>2]|0)|0;if(!i){c[h>>2]=0;g=(c[k>>2]|0)+-1|0;c[l>>2]=g;a[g>>0]=0;g=c[l>>2]|0;break}else{c[l>>2]=g;c[k>>2]=j+40+i;break}}while(0);c[l>>2]=g+1;if((a[g>>0]|0)==-1)do{j=c[b>>2]|0;l=j+168|0;g=c[l>>2]|0;k=j+172|0;if(g>>>0>=(c[k>>2]|0)>>>0){h=j+32|0;if(!(c[h>>2]|0))g=0;else{g=j+40|0;i=jd[c[j+16>>2]&15](c[j+28>>2]|0,g,c[j+36>>2]|0)|0;if(!i){c[h>>2]=0;g=(c[k>>2]|0)+-1|0;c[l>>2]=g;a[g>>0]=0;g=c[l>>2]|0}else{c[l>>2]=g;c[k>>2]=j+40+i}c[l>>2]=g+1;g=d[g>>0]|0}}else{c[l>>2]=g+1;g=d[g>>0]|0}g=g&255}while(g<<24>>24==-1);else g=-1}else a[o>>0]=-1;while(0);g=g&255;d:do if((g&254|0)!=192){e:while(1){if(!(Qk(b,g)|0)){A=0;z=182;break}g=a[o>>0]|0;f:do if(g<<24>>24==-1){j=c[b>>2]|0;k=j+168|0;g=c[k>>2]|0;l=j+172|0;do if(g>>>0>=(c[l>>2]|0)>>>0){i=j+32|0;if(c[i>>2]|0){g=j+40|0;h=jd[c[j+16>>2]&15](c[j+28>>2]|0,g,c[j+36>>2]|0)|0;if(!h){c[i>>2]=0;m=(c[l>>2]|0)+-1|0;c[k>>2]=m;a[m>>0]=0;m=c[k>>2]|0;z=43;break}else{c[k>>2]=g;c[l>>2]=j+40+h;m=g;z=43;break}}}else{m=g;z=43}while(0);if((z|0)==43?(z=0,c[k>>2]=m+1,(a[m>>0]|0)==-1):0)while(1){j=c[b>>2]|0;l=j+168|0;g=c[l>>2]|0;k=j+172|0;if(g>>>0>=(c[k>>2]|0)>>>0){h=j+32|0;if(!(c[h>>2]|0))g=0;else{g=j+40|0;i=jd[c[j+16>>2]&15](c[j+28>>2]|0,g,c[j+36>>2]|0)|0;if(!i){c[h>>2]=0;g=(c[k>>2]|0)+-1|0;c[l>>2]=g;a[g>>0]=0;g=c[l>>2]|0}else{c[l>>2]=g;c[k>>2]=j+40+i}c[l>>2]=g+1;g=d[g>>0]|0}}else{c[l>>2]=g+1;g=d[g>>0]|0}g=g&255;if(g<<24>>24!=-1)break f}g:while(1){g=c[b>>2]|0;if(c[g+16>>2]|0){if(rd[c[g+24>>2]&63](c[g+28>>2]|0)|0)if(!(c[g+32>>2]|0))break e;else z=55}else z=55;if((z|0)==55?(z=0,(c[g+168>>2]|0)>>>0>=(c[g+172>>2]|0)>>>0):0)break e;g=a[o>>0]|0;if(g<<24>>24!=-1){n=g;z=58;break}j=c[b>>2]|0;l=j+168|0;g=c[l>>2]|0;k=j+172|0;do if(g>>>0>=(c[k>>2]|0)>>>0){h=j+32|0;if(!(c[h>>2]|0))continue g;g=j+40|0;i=jd[c[j+16>>2]&15](c[j+28>>2]|0,g,c[j+36>>2]|0)|0;if(!i){c[h>>2]=0;g=(c[k>>2]|0)+-1|0;c[l>>2]=g;a[g>>0]=0;g=c[l>>2]|0;break}else{c[l>>2]=g;c[k>>2]=j+40+i;break}}while(0);c[l>>2]=g+1;if((a[g>>0]|0)==-1)break}if((z|0)==58){z=0;a[o>>0]=-1;g=n;break}do{j=c[b>>2]|0;l=j+168|0;g=c[l>>2]|0;k=j+172|0;if(g>>>0>=(c[k>>2]|0)>>>0){h=j+32|0;if(!(c[h>>2]|0))g=0;else{g=j+40|0;i=jd[c[j+16>>2]&15](c[j+28>>2]|0,g,c[j+36>>2]|0)|0;if(!i){c[h>>2]=0;g=(c[k>>2]|0)+-1|0;c[l>>2]=g;a[g>>0]=0;g=c[l>>2]|0}else{c[l>>2]=g;c[k>>2]=j+40+i}c[l>>2]=g+1;g=d[g>>0]|0}}else{c[l>>2]=g+1;g=d[g>>0]|0}g=g&255}while(g<<24>>24==-1)}else a[o>>0]=-1;while(0);g=g&255;if((g&254|0)==192)break d}if((z|0)==182)return A|0;c[5682]=30688;b=0;return b|0}while(0);u=c[b>>2]|0;q=u+168|0;g=c[q>>2]|0;t=u+172|0;i=c[t>>2]|0;if(g>>>0>=i>>>0){j=u+32|0;if(!(c[j>>2]|0)){j=0;h=g;g=i}else{g=u+40|0;h=jd[c[u+16>>2]&15](c[u+28>>2]|0,g,c[u+36>>2]|0)|0;if(!h){c[j>>2]=0;i=(c[t>>2]|0)+-1|0;c[q>>2]=i;a[i>>0]=0;i=c[t>>2]|0;g=c[q>>2]|0}else{c[q>>2]=g;i=u+40+h|0;c[t>>2]=i}h=g+1|0;c[q>>2]=h;j=d[g>>0]|0;g=i}}else{h=g+1|0;c[q>>2]=h;j=d[g>>0]|0;g=i}j=j<<8;if(h>>>0>=g>>>0){i=u+32|0;if(!(c[i>>2]|0))g=0;else{g=u+40|0;h=jd[c[u+16>>2]&15](c[u+28>>2]|0,g,c[u+36>>2]|0)|0;if(!h){c[i>>2]=0;g=(c[t>>2]|0)+-1|0;c[q>>2]=g;a[g>>0]=0;g=c[q>>2]|0}else{c[q>>2]=g;c[t>>2]=u+40+h}h=g+1|0;c[q>>2]=h;g=d[g>>0]|0}}else{s=h+1|0;c[q>>2]=s;g=d[h>>0]|0;h=s}l=g|j;if(l>>>0<11){c[5682]=30695;b=0;return b|0}do if(h>>>0>=(c[t>>2]|0)>>>0){i=u+32|0;if(c[i>>2]|0){g=u+40|0;h=jd[c[u+16>>2]&15](c[u+28>>2]|0,g,c[u+36>>2]|0)|0;if(!h){c[i>>2]=0;p=(c[t>>2]|0)+-1|0;c[q>>2]=p;a[p>>0]=0;p=c[q>>2]|0;z=94;break}else{c[q>>2]=g;c[t>>2]=u+40+h;p=g;z=94;break}}}else{p=h;z=94}while(0);if((z|0)==94?(r=p+1|0,c[q>>2]=r,(a[p>>0]|0)==8):0){g=c[t>>2]|0;if(r>>>0>=g>>>0){i=u+32|0;if(!(c[i>>2]|0)){i=0;j=r}else{g=u+40|0;h=jd[c[u+16>>2]&15](c[u+28>>2]|0,g,c[u+36>>2]|0)|0;if(!h){c[i>>2]=0;h=(c[t>>2]|0)+-1|0;c[q>>2]=h;a[h>>0]=0;h=c[t>>2]|0;g=c[q>>2]|0}else{c[q>>2]=g;h=u+40+h|0;c[t>>2]=h}j=g+1|0;c[q>>2]=j;i=d[g>>0]|0;g=h}}else{j=p+2|0;c[q>>2]=j;i=d[r>>0]|0}k=i<<8;if(j>>>0>=g>>>0){i=u+32|0;if(!(c[i>>2]|0))g=0;else{g=u+40|0;h=jd[c[u+16>>2]&15](c[u+28>>2]|0,g,c[u+36>>2]|0)|0;if(!h){c[i>>2]=0;g=(c[t>>2]|0)+-1|0;c[q>>2]=g;a[g>>0]=0;g=c[q>>2]|0}else{c[q>>2]=g;c[t>>2]=u+40+h}j=g+1|0;c[q>>2]=j;g=d[g>>0]|0}}else{s=j+1|0;c[q>>2]=s;g=d[j>>0]|0;j=s}r=g|k;s=u+4|0;c[s>>2]=r;if(!r){c[5682]=30718;b=0;return b|0}h=c[t>>2]|0;if(j>>>0>=h>>>0){i=u+32|0;if(!(c[i>>2]|0)){i=0;g=j}else{g=u+40|0;h=jd[c[u+16>>2]&15](c[u+28>>2]|0,g,c[u+36>>2]|0)|0;if(!h){c[i>>2]=0;h=(c[t>>2]|0)+-1|0;c[q>>2]=h;a[h>>0]=0;h=c[t>>2]|0;g=c[q>>2]|0}else{c[q>>2]=g;h=u+40+h|0;c[t>>2]=h}r=g+1|0;c[q>>2]=r;i=d[g>>0]|0;g=r}}else{g=j+1|0;c[q>>2]=g;i=d[j>>0]|0}j=i<<8;if(g>>>0>=h>>>0){i=u+32|0;if(!(c[i>>2]|0))h=0;else{g=u+40|0;h=jd[c[u+16>>2]&15](c[u+28>>2]|0,g,c[u+36>>2]|0)|0;if(!h){c[i>>2]=0;g=(c[t>>2]|0)+-1|0;c[q>>2]=g;a[g>>0]=0;g=c[q>>2]|0}else{c[q>>2]=g;c[t>>2]=u+40+h}r=g+1|0;c[q>>2]=r;h=d[g>>0]|0;g=r}}else{r=g+1|0;c[q>>2]=r;h=d[g>>0]|0;g=r}r=h|j;c[u>>2]=r;if(!r){c[5682]=30735;b=0;return b|0}do if(g>>>0>=(c[t>>2]|0)>>>0){i=u+32|0;if(!(c[i>>2]|0))break;g=u+40|0;h=jd[c[u+16>>2]&15](c[u+28>>2]|0,g,c[u+36>>2]|0)|0;if(!h){c[i>>2]=0;v=(c[t>>2]|0)+-1|0;c[q>>2]=v;a[v>>0]=0;v=c[q>>2]|0;z=133;break}else{c[q>>2]=g;c[t>>2]=u+40+h;v=g;z=133;break}}else{v=g;z=133}while(0);h:do if((z|0)==133){i=v+1|0;c[q>>2]=i;g=a[v>>0]|0;j=g&255;switch(j|0){case 1:case 3:break;default:break h}r=u+8|0;c[r>>2]=j;g=g<<24>>24==0;if(!g){h=0;do{c[b+13724+(h*56|0)+44>>2]=0;c[b+13724+(h*56|0)+52>>2]=0;h=h+1|0}while((h|0)!=(j|0))}if((l|0)!=((j*3|0)+8|0)){c[5682]=30695;b=0;return b|0}i:do if(!g){l=u+32|0;m=u+16|0;n=u+28|0;o=u+40|0;p=u+36|0;g=i;k=0;j:while(1){do if(g>>>0<(c[t>>2]|0)>>>0){v=g+1|0;c[q>>2]=v;h=d[g>>0]|0;g=v}else{if(!(c[l>>2]|0)){h=0;break}g=jd[c[m>>2]&15](c[n>>2]|0,o,c[p>>2]|0)|0;if(!g){c[l>>2]=0;g=(c[t>>2]|0)+-1|0;c[q>>2]=g;a[g>>0]=0;g=c[q>>2]|0}else{c[q>>2]=o;c[t>>2]=u+40+g;g=o}v=g+1|0;c[q>>2]=v;h=d[g>>0]|0;g=v}while(0);c[b+13724+(k*56|0)>>2]=h;i=k;k=k+1|0;if(!((h|0)==(k|0)|(h|0)==(i|0))){z=149;break}do if(g>>>0>=(c[t>>2]|0)>>>0){if(!(c[l>>2]|0)){y=i;z=152;break j}g=jd[c[m>>2]&15](c[n>>2]|0,o,c[p>>2]|0)|0;if(!g){c[l>>2]=0;g=(c[t>>2]|0)+-1|0;c[q>>2]=g;a[g>>0]=0;g=c[q>>2]|0;break}else{c[q>>2]=o;c[t>>2]=u+40+g;g=o;break}}while(0);h=g+1|0;c[q>>2]=h;j=a[g>>0]|0;g=j&255;v=g>>>4;c[b+13724+(i*56|0)+4>>2]=v;if((j&255)>79|(v|0)==0)break;v=g&15;c[b+13724+(i*56|0)+8>>2]=v;if((v+-1|0)>>>0>3){z=159;break}do if(h>>>0>=(c[t>>2]|0)>>>0){if(!(c[l>>2]|0)){c[b+13724+(i*56|0)+12>>2]=0;x=h;break}g=jd[c[m>>2]&15](c[n>>2]|0,o,c[p>>2]|0)|0;if(!g){c[l>>2]=0;w=(c[t>>2]|0)+-1|0;c[q>>2]=w;a[w>>0]=0;w=c[q>>2]|0;z=166;break}else{c[q>>2]=o;c[t>>2]=u+40+g;w=o;z=166;break}}else{w=h;z=166}while(0);if((z|0)==166){z=0;g=w+1|0;c[q>>2]=g;x=a[w>>0]|0;c[b+13724+(i*56|0)+12>>2]=x&255;if((x&255)>3){z=168;break}else x=g}j=c[r>>2]|0;if((k|0)>=(j|0))break i;else g=x}if((z|0)==149){c[5682]=30763;b=0;return b|0}else if((z|0)==152)c[b+13724+(y*56|0)+4>>2]=0;else if((z|0)==159){c[5682]=30786;b=0;return b|0}else if((z|0)==168){c[5682]=30792;b=0;return b|0}c[5682]=30780;b=0;return b|0}while(0);if(e){b=1;return b|0}k=c[u>>2]|0;q=c[s>>2]|0;if((((1073741824/(k>>>0)|0)>>>0)/(j>>>0)|0)>>>0<q>>>0){c[5682]=30226;b=0;return b|0}l=(j|0)>0;if(l){g=1;i=0;h=1;do{e=c[b+13724+(i*56|0)+4>>2]|0;g=(e|0)>(g|0)?e:g;e=c[b+13724+(i*56|0)+8>>2]|0;h=(e|0)>(h|0)?e:h;i=i+1|0}while((i|0)!=(j|0));p=h}else{g=1;p=1}c[b+13700>>2]=g;c[b+13704>>2]=p;o=g<<3;c[b+13716>>2]=o;e=p<<3;c[b+13720>>2]=e;n=b+13708|0;c[n>>2]=((k+-1+o|0)>>>0)/(o>>>0)|0;o=b+13712|0;c[o>>2]=((q+-1+e|0)>>>0)/(e>>>0)|0;if(!l){b=1;return b|0}l=g+-1|0;m=p+-1|0;i=q;j=0;while(1){h=c[b+13724+(j*56|0)+4>>2]|0;c[b+13724+(j*56|0)+28>>2]=((l+($(h,k)|0)|0)>>>0)/(g>>>0)|0;e=c[b+13724+(j*56|0)+8>>2]|0;c[b+13724+(j*56|0)+32>>2]=((m+($(e,i)|0)|0)>>>0)/(p>>>0)|0;h=$(c[n>>2]<<3,h)|0;c[b+13724+(j*56|0)+36>>2]=h;e=$(c[o>>2]<<3,e)|0;c[b+13724+(j*56|0)+40>>2]=e;h=fo($(e,h)|0|15)|0;c[b+13724+(j*56|0)+48>>2]=h;if(!h){f=j;break}c[b+13724+(j*56|0)+44>>2]=h+15&-16;c[b+13724+(j*56|0)+52>>2]=0;h=j+1|0;if((h|0)>=(c[r>>2]|0)){A=1;z=182;break}k=c[u>>2]|0;i=c[s>>2]|0;j=h}if((z|0)==182)return A|0;if((f|0)>0)do{A=f;f=f+-1|0;go(c[b+13724+(f*56|0)+48>>2]|0);c[b+13724+(f*56|0)+44>>2]=0}while((A|0)>1);c[5682]=30100;b=0;return b|0}while(0);c[5682]=30743;b=0;return b|0}c[5682]=30707;b=0;return b|0}while(0);c[5682]=30681;b=0;return b|0}function Kk(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;V=i;i=i+5104|0;M=V;U=V+4080|0;Q=V+4072|0;O=c[b>>2]|0;S=b+8|0;c[S>>2]=0;N=b+4|0;c[N>>2]=0;T=b+12|0;c[T>>2]=0;E=O+168|0;F=O+172|0;G=O+32|0;H=O+16|0;I=O+28|0;J=O+40|0;B=O+36|0;g=c[E>>2]|0;j=0;do{if(g>>>0>=(c[F>>2]|0)>>>0)if(!(c[G>>2]|0))h=0;else{g=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!g){c[G>>2]=0;g=(c[F>>2]|0)+-1|0;c[E>>2]=g;a[g>>0]=0;g=c[E>>2]|0}else{c[E>>2]=J;c[F>>2]=O+40+g;g=J}R=g+1|0;c[E>>2]=R;h=d[g>>0]|0;g=R}else{R=g+1|0;c[E>>2]=R;h=d[g>>0]|0;g=R}if((h&255)<<24>>24!=(a[30179+j>>0]|0)){P=11;break}j=j+1|0}while((j|0)<8);if((P|0)==11){c[5682]=30187;U=0;i=V;return U|0}if((e|0)==1){U=1;i=V;return U|0}y=O+20|0;z=O+4|0;R=O+8|0;A=(e|0)==2;h=g;t=1;l=0;v=0;m=0;w=0;x=0;g=0;u=0;a:while(1){j=c[F>>2]|0;if(h>>>0>=j>>>0)if(!(c[G>>2]|0))k=0;else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}s=h+1|0;c[E>>2]=s;k=d[h>>0]|0;h=s}else{s=h+1|0;c[E>>2]=s;k=d[h>>0]|0;h=s}n=k<<8;if(h>>>0>=j>>>0)if(!(c[G>>2]|0))k=0;else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}s=h+1|0;c[E>>2]=s;k=d[h>>0]|0;h=s}else{s=h+1|0;c[E>>2]=s;k=d[h>>0]|0;h=s}o=(k|n)<<16;if(h>>>0>=j>>>0)if(!(c[G>>2]|0))k=0;else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}s=h+1|0;c[E>>2]=s;k=d[h>>0]|0;h=s}else{s=h+1|0;c[E>>2]=s;k=d[h>>0]|0;h=s}n=k<<8;if(h>>>0>=j>>>0)if(!(c[G>>2]|0))k=0;else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}s=h+1|0;c[E>>2]=s;k=d[h>>0]|0;h=s}else{s=h+1|0;c[E>>2]=s;k=d[h>>0]|0;h=s}s=n|o|k;if(h>>>0>=j>>>0)if(!(c[G>>2]|0)){k=0;n=h}else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}n=h+1|0;c[E>>2]=n;k=d[h>>0]|0}else{n=h+1|0;c[E>>2]=n;k=d[h>>0]|0}p=k<<8;if(n>>>0>=j>>>0)if(!(c[G>>2]|0)){h=0;o=n;n=j}else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}o=h+1|0;c[E>>2]=o;h=d[h>>0]|0;n=j}else{o=n+1|0;c[E>>2]=o;h=d[n>>0]|0;n=j}r=(h|p)<<16;if(o>>>0>=n>>>0)if(!(c[G>>2]|0))j=0;else{j=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!j){c[G>>2]=0;n=(c[F>>2]|0)+-1|0;c[E>>2]=n;a[n>>0]=0;n=c[F>>2]|0;j=c[E>>2]|0}else{c[E>>2]=J;n=O+40+j|0;c[F>>2]=n;j=J}o=j+1|0;c[E>>2]=o;j=d[j>>0]|0}else{q=o+1|0;c[E>>2]=q;j=d[o>>0]|0;o=q}p=j<<8;if(o>>>0>=n>>>0)if(!(c[G>>2]|0))q=0;else{n=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!n){c[G>>2]=0;n=(c[F>>2]|0)+-1|0;c[E>>2]=n;a[n>>0]=0;n=c[E>>2]|0}else{c[E>>2]=J;c[F>>2]=O+40+n;n=J}o=n+1|0;c[E>>2]=o;q=d[n>>0]|0}else{n=o+1|0;c[E>>2]=n;q=d[o>>0]|0;o=n}n=p|r|q;b:do if((n|0)>=1229472850){if((n|0)>=1347179589){if((n|0)<1951551059){switch(n|0){case 1347179589:break;default:{P=339;break b}}if(t){P=189;break a}if(s>>>0>768){P=191;break a}p=(s>>>0)/3|0;if((p*3|0)!=(s|0)){P=194;break a}if(s>>>0>2){h=o;o=0}else{r=0;o=v;q=w;n=x;k=p;break}while(1){j=c[F>>2]|0;do if(h>>>0<j>>>0){u=h+1|0;c[E>>2]=u;k=d[h>>0]|0;h=u}else{if(!(c[G>>2]|0)){k=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}u=h+1|0;c[E>>2]=u;k=d[h>>0]|0;h=u}while(0);n=o<<2;a[U+n>>0]=k;do if(h>>>0<j>>>0){u=h+1|0;c[E>>2]=u;k=d[h>>0]|0;h=u}else{if(!(c[G>>2]|0)){k=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}u=h+1|0;c[E>>2]=u;k=d[h>>0]|0;h=u}while(0);a[U+(n|1)>>0]=k;do if(h>>>0<j>>>0){u=h+1|0;c[E>>2]=u;j=d[h>>0]|0;h=u}else{if(!(c[G>>2]|0)){j=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J}u=h+1|0;c[E>>2]=u;j=d[h>>0]|0;h=u}while(0);a[U+(n|2)>>0]=j;a[U+(n|3)>>0]=-1;o=o+1|0;if(o>>>0>=p>>>0){r=0;o=v;q=w;n=x;k=p;break b}}}switch(n|0){case 1951551059:break;default:{P=339;break b}}if(t){P=218;break a}if(c[N>>2]|0){P=220;break a}if(g<<24>>24){if(A){P=223;break a}if(!u){P=225;break a}if(s>>>0>u>>>0){P=228;break a}if(!s){r=0;o=v;q=w;n=x;g=4;k=u;break}else{g=o;j=0}while(1){do if(g>>>0<(c[F>>2]|0)>>>0){t=g+1|0;c[E>>2]=t;h=d[g>>0]|0;g=t}else{if(!(c[G>>2]|0)){h=0;break}g=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!g){c[G>>2]=0;g=(c[F>>2]|0)+-1|0;c[E>>2]=g;a[g>>0]=0;g=c[E>>2]|0}else{c[E>>2]=J;c[F>>2]=O+40+g;g=J}t=g+1|0;c[E>>2]=t;h=d[g>>0]|0;g=t}while(0);a[U+(j<<2|3)>>0]=h;j=j+1|0;if((j|0)==(s|0)){r=0;o=v;q=w;n=x;g=4;k=u;break b}}}g=c[R>>2]|0;if(!(g&1)){P=238;break a}if((s|0)!=(g<<1|0)){P=241;break a}if((g|0)>0){g=o;j=0}else{r=0;l=1;o=v;q=w;n=x;g=0;k=u;break}while(1){h=c[F>>2]|0;do if(g>>>0<h>>>0){g=g+1|0;c[E>>2]=g}else{if(!(c[G>>2]|0))break;g=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!g){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[F>>2]|0;g=c[E>>2]|0}else{c[E>>2]=J;h=O+40+g|0;c[F>>2]=h;g=J}g=g+1|0;c[E>>2]=g}while(0);do if(g>>>0<h>>>0){t=g+1|0;c[E>>2]=t;h=d[g>>0]|0;g=t}else{if(!(c[G>>2]|0)){h=0;break}g=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!g){c[G>>2]=0;g=(c[F>>2]|0)+-1|0;c[E>>2]=g;a[g>>0]=0;g=c[E>>2]|0}else{c[E>>2]=J;c[F>>2]=O+40+g;g=J}t=g+1|0;c[E>>2]=t;h=d[g>>0]|0;g=t}while(0);a[Q+j>>0]=h;j=j+1|0;if((j|0)>=(c[R>>2]|0)){r=0;l=1;o=v;q=w;n=x;g=0;k=u;break b}}}switch(n|0){case 1229472850:break;default:{P=339;break b}}if(!t){P=76;break a}if((s|0)!=13){P=78;break a}j=c[F>>2]|0;if(o>>>0>=j>>>0)if(!(c[G>>2]|0)){k=0;h=o}else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}else{h=o+1|0;c[E>>2]=h;k=d[o>>0]|0}m=k<<8;if(h>>>0>=j>>>0)if(!(c[G>>2]|0))k=0;else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}else{t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}m=(k|m)<<16;if(h>>>0>=j>>>0)if(!(c[G>>2]|0))k=0;else{h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}else{t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}k=k<<8;do if(h>>>0<j>>>0){t=h+1|0;c[E>>2]=t;j=d[h>>0]|0;h=t}else{if(!(c[G>>2]|0)){j=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J}t=h+1|0;c[E>>2]=t;j=d[h>>0]|0;h=t}while(0);t=k|m|j;c[O>>2]=t;if(t>>>0>16777216){P=108;break a}j=c[F>>2]|0;do if(h>>>0<j>>>0){t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}else{if(!(c[G>>2]|0)){k=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}while(0);m=k<<8;do if(h>>>0<j>>>0){t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}else{if(!(c[G>>2]|0)){k=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}while(0);m=(k|m)<<16;do if(h>>>0<j>>>0){t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}else{if(!(c[G>>2]|0)){k=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}t=h+1|0;c[E>>2]=t;k=d[h>>0]|0;h=t}while(0);k=k<<8;do if(h>>>0<j>>>0){t=h+1|0;c[E>>2]=t;j=d[h>>0]|0;h=t}else{if(!(c[G>>2]|0)){j=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J}t=h+1|0;c[E>>2]=t;j=d[h>>0]|0;h=t}while(0);t=k|m|j;c[z>>2]=t;if(t>>>0>16777216){P=138;break a}do if(h>>>0>=(c[F>>2]|0)>>>0){if(!(c[G>>2]|0)){P=145;break a}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0;break}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J;break}}while(0);k=h+1|0;c[E>>2]=k;if((a[h>>0]|0)!=8){P=145;break a}do if(k>>>0>=(c[F>>2]|0)>>>0){if(!(c[G>>2]|0)){j=0;h=k;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0;P=151;break}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J;P=151;break}}else{h=k;P=151}while(0);do if((P|0)==151){P=0;k=h+1|0;c[E>>2]=k;h=a[h>>0]|0;j=h&255;if((h&255)>6){P=152;break a}if(h<<24>>24==3){j=3;h=k;g=3;break}if(!(j&1))h=k;else{P=155;break a}}while(0);k=c[F>>2]|0;do if(h>>>0>=k>>>0){if(!(c[G>>2]|0))break;h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0;P=161;break}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J;P=161;break}}else P=161;while(0);if((P|0)==161){P=0;k=h+1|0;c[E>>2]=k;if(a[h>>0]|0){P=163;break a}h=k;k=c[F>>2]|0}do if(h>>>0>=k>>>0){if(!(c[G>>2]|0))break;h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0;P=169;break}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J;P=169;break}}else P=169;while(0);if((P|0)==169){P=0;k=h+1|0;c[E>>2]=k;if(a[h>>0]|0){P=171;break a}h=k;k=c[F>>2]|0}do if(h>>>0>=k>>>0){if(!(c[G>>2]|0)){m=0;break}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0;P=177;break}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J;P=177;break}}else P=177;while(0);if((P|0)==177){P=0;c[E>>2]=h+1;h=a[h>>0]|0;if((h&255)>1){P=178;break a}else m=h&255}h=c[O>>2]|0;if(!h){P=181;break a}k=c[z>>2]|0;if(!k){P=181;break a}if(g<<24>>24){c[R>>2]=1;if((1073741824/(h>>>0)|0)>>>2>>>0<k>>>0){P=187;break a}else{r=0;o=v;q=w;n=x;k=u;break}}t=(j&2|1)+(j>>>2&1)|0;c[R>>2]=t;if((((1073741824/(h>>>0)|0)>>>0)/(t>>>0)|0)>>>0<k>>>0){P=184;break a}if(A){g=1;P=375;break a}else{r=0;o=v;q=w;n=x;g=0;k=u}}else{if((n|0)<1229209940){switch(n|0){case 1130840649:break;default:{P=339;break b}}h=c[5686]|0;if((c[H>>2]|0)!=0?(C=c[F>>2]|0,D=C-o|0,(s|0)>(D|0)):0){c[E>>2]=C;qd[c[y>>2]&63](c[I>>2]|0,s-D|0);r=t;o=v;q=w;n=h;k=u;break}c[E>>2]=o+s;r=t;o=v;q=w;n=h;k=u;break}if((n|0)>=1229278788)switch(n|0){case 1229278788:{j=t;k=w;h=x;P=277;break a}default:{P=339;break b}}switch(n|0){case 1229209940:break;default:{P=339;break b}}if(t){P=258;break a}if(!((u|0)!=0|g<<24>>24==0)){P=260;break a}if(A){P=262;break a}q=s+w|0;if(q>>>0>v>>>0){h=(v|0)==0?(s>>>0>4096?s:4096):v;while(1)if(q>>>0>h>>>0)h=h<<1;else break;j=io(c[N>>2]|0,h)|0;if(!j){P=268;break a}c[N>>2]=j}else{j=c[N>>2]|0;h=v}p=j+w|0;do if(c[H>>2]|0){o=c[F>>2]|0;k=c[E>>2]|0;n=o-k|0;if((s|0)<=(n|0)){j=o;break}so(p|0,k|0,n|0)|0;v=s-n|0;w=(jd[c[H>>2]&15](c[I>>2]|0,j+(n+w)|0,v)|0)==(v|0);c[E>>2]=c[F>>2];if(w){r=0;o=h;n=x;k=u;break b}else{P=276;break a}}else{k=c[E>>2]|0;j=c[F>>2]|0}while(0);if((k+s|0)>>>0>j>>>0){P=276;break a}so(p|0,k|0,s|0)|0;c[E>>2]=(c[E>>2]|0)+s;r=0;o=h;n=x;k=u}while(0);do if((P|0)==339){P=0;if(t){P=340;break a}if(!(r&536870912)){g=q;P=342;break a}if((c[H>>2]|0)!=0?(K=c[F>>2]|0,L=K-o|0,(s|0)>(L|0)):0){c[E>>2]=K;qd[c[y>>2]&63](c[I>>2]|0,s-L|0);r=0;o=v;q=w;n=x;k=u;break}c[E>>2]=o+s;r=0;o=v;q=w;n=x;k=u}while(0);h=c[E>>2]|0;j=c[F>>2]|0;if(h>>>0>=j>>>0){if(c[G>>2]|0){h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}h=h+1|0;c[E>>2]=h}}else{h=h+1|0;c[E>>2]=h}if(h>>>0>=j>>>0){if(c[G>>2]|0){h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}h=h+1|0;c[E>>2]=h}}else{h=h+1|0;c[E>>2]=h}if(h>>>0>=j>>>0){if(c[G>>2]|0){h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;j=(c[F>>2]|0)+-1|0;c[E>>2]=j;a[j>>0]=0;j=c[F>>2]|0;h=c[E>>2]|0}else{c[E>>2]=J;j=O+40+h|0;c[F>>2]=j;h=J}h=h+1|0;c[E>>2]=h}}else{h=h+1|0;c[E>>2]=h}if(h>>>0<j>>>0){h=h+1|0;c[E>>2]=h;t=r;v=o;w=q;x=n;u=k;continue}if(!(c[G>>2]|0)){t=r;v=o;w=q;x=n;u=k;continue}h=jd[c[H>>2]&15](c[I>>2]|0,J,c[B>>2]|0)|0;if(!h){c[G>>2]=0;h=(c[F>>2]|0)+-1|0;c[E>>2]=h;a[h>>0]=0;h=c[E>>2]|0}else{c[E>>2]=J;c[F>>2]=O+40+h;h=J}h=h+1|0;c[E>>2]=h;t=r;v=o;w=q;x=n;u=k}switch(P|0){case 76:{c[5682]=30199;U=0;i=V;return U|0}case 78:{c[5682]=30213;U=0;i=V;return U|0}case 108:{c[5682]=30226;U=0;i=V;return U|0}case 138:{c[5682]=30226;U=0;i=V;return U|0}case 145:{c[5682]=30236;U=0;i=V;return U|0}case 152:{c[5682]=30246;U=0;i=V;return U|0}case 155:{c[5682]=30246;U=0;i=V;return U|0}case 163:{c[5682]=30256;U=0;i=V;return U|0}case 171:{c[5682]=30272;U=0;i=V;return U|0}case 178:{c[5682]=30290;U=0;i=V;return U|0}case 181:{c[5682]=30311;U=0;i=V;return U|0}case 184:{c[5682]=30226;U=0;i=V;return U|0}case 187:{c[5682]=30226;U=0;i=V;return U|0}case 189:{c[5682]=30325;U=0;i=V;return U|0}case 191:{c[5682]=30340;U=0;i=V;return U|0}case 194:{c[5682]=30340;U=0;i=V;return U|0}case 218:{c[5682]=30325;U=0;i=V;return U|0}case 220:{c[5682]=30353;U=0;i=V;return U|0}case 223:{c[R>>2]=4;U=1;i=V;return U|0}case 225:{c[5682]=30369;U=0;i=V;return U|0}case 228:{c[5682]=30386;U=0;i=V;return U|0}case 238:{c[5682]=30399;U=0;i=V;return U|0}case 241:{c[5682]=30386;U=0;i=V;return U|0}case 258:{c[5682]=30325;U=0;i=V;return U|0}case 260:{c[5682]=30415;U=0;i=V;return U|0}case 262:{c[R>>2]=g&255;U=1;i=V;return U|0}case 268:{c[5682]=30100;U=0;i=V;return U|0}case 276:{c[5682]=30423;U=0;i=V;return U|0}case 277:{if(j){c[5682]=30325;U=0;i=V;return U|0}if(e){U=1;i=V;return U|0}j=c[N>>2]|0;if(!j){c[5682]=30433;U=0;i=V;return U|0}C=(h|0)!=0;h=fo(16384)|0;do if(h){c[M>>2]=j;c[M+4>>2]=j+k;if(!(Ik(M,h,16384,1,C&1^1)|0)){go(c[M+20>>2]|0);break}e=c[M+20>>2]|0;j=(c[M+16>>2]|0)-e|0;c[S>>2]=e;if(!e){U=0;i=V;return U|0}go(c[N>>2]|0);c[N>>2]=0;h=c[R>>2]|0;A=h+1|0;E=g<<24>>24!=0;B=l<<24>>24==0;D=O+12|0;A=B&(E|((f|0)==3|(A|0)!=(f|0)))?h:A;c[D>>2]=A;h=c[S>>2]|0;do if(!m){P=c[b>>2]|0;if(!(Pk(b,h,j,A,c[P>>2]|0,c[P+4>>2]|0)|0)){U=0;i=V;return U|0}}else{y=c[5681]|0;c[5681]=0;l=c[b>>2]|0;z=fo($($(c[l>>2]|0,A)|0,c[l+4>>2]|0)|0)|0;k=0;while(1){t=c[22748+(k<<2)>>2]|0;u=c[22776+(k<<2)>>2]|0;v=(((c[l>>2]|0)+-1-t+u|0)>>>0)/(u>>>0)|0;w=c[22804+(k<<2)>>2]|0;x=c[22832+(k<<2)>>2]|0;n=(((c[l+4>>2]|0)+-1-w+x|0)>>>0)/(x>>>0)|0;if((v|0)!=0&(n|0)!=0){if(!(Pk(b,h,j,A,v,n)|0))break;if((n|0)>0){o=(v|0)>0;s=0;do{if(o){p=($(s,x)|0)+w|0;q=$(s,v)|0;l=c[b>>2]|0;m=c[T>>2]|0;r=0;do{so(z+($(($(r,u)|0)+t+($(c[l>>2]|0,p)|0)|0,A)|0)|0,m+($(r+q|0,A)|0)|0,A|0)|0;r=r+1|0}while((r|0)<(v|0))}s=s+1|0}while((s|0)<(n|0))}go(c[T>>2]|0);O=$(n,($(v,A)|0)+1|0)|0;h=h+O|0;j=j-O|0}k=k+1|0;if((k|0)>=7){P=301;break}l=c[b>>2]|0}if((P|0)==301){c[T>>2]=z;c[5681]=y;break}go(z);U=0;i=V;return U|0}while(0);c:do if(!B){m=c[b>>2]|0;h=c[T>>2]|0;m=$(c[m+4>>2]|0,c[m>>2]|0)|0;switch(c[D>>2]|0){case 2:{if(!m)break c;else j=0;while(1){a[h+1>>0]=((a[h>>0]|0)!=(a[Q>>0]|0))<<31>>31;j=j+1|0;if((j|0)==(m|0))break;else h=h+2|0}break}case 4:{if(!m)break c;j=Q+1|0;k=Q+2|0;l=0;while(1){if(((a[h>>0]|0)==(a[Q>>0]|0)?(a[h+1>>0]|0)==(a[j>>0]|0):0)?(a[h+2>>0]|0)==(a[k>>0]|0):0)a[h+3>>0]=0;l=l+1|0;if((l|0)==(m|0))break;else h=h+4|0}break}default:Ba(30441,30466,2238,30489)}}while(0);d:do if(C?(c[D>>2]|0)>2:0){Q=c[b>>2]|0;k=c[T>>2]|0;o=$(c[Q+4>>2]|0,c[Q>>2]|0)|0;switch(c[Q+12>>2]|0){case 3:{if(!o)break d;else{j=0;h=k}while(1){P=a[h>>0]|0;Q=h+2|0;a[h>>0]=a[Q>>0]|0;a[Q>>0]=P;j=j+1|0;if((j|0)==(o|0))break;else h=h+3|0}break}case 4:{h=(o|0)==0;if(!(c[5685]|0)){if(h)break d;else{j=0;h=k}while(1){P=a[h>>0]|0;Q=h+2|0;a[h>>0]=a[Q>>0]|0;a[Q>>0]=P;j=j+1|0;if((j|0)==(o|0))break d;else h=h+4|0}}if(h)break d;else n=0;while(1){j=a[k+3>>0]|0;h=a[k>>0]|0;m=k+2|0;l=a[m>>0]|0;if(!(j<<24>>24))a[k>>0]=l;else{Q=j&255;a[k>>0]=(((l&255)*255|0)>>>0)/(Q>>>0)|0;P=k+1|0;a[P>>0]=(((d[P>>0]|0)*255|0)>>>0)/(Q>>>0)|0;h=((((h&255)*255|0)>>>0)/(Q>>>0)|0)&255}a[m>>0]=h;n=n+1|0;if((n|0)==(o|0))break;else k=k+4|0}break}default:Ba(30510,30466,2318,30528)}}while(0);if(E){h=g&255;c[R>>2]=h;h=(f|0)>2?f:h;c[D>>2]=h;j=c[b>>2]|0;j=$(c[j+4>>2]|0,c[j>>2]|0)|0;k=c[T>>2]|0;l=fo($(j,h)|0)|0;if(!l){c[5682]=30100;U=0;i=V;return U|0}g=(j|0)==0;if((h|0)==3){if(!g){g=0;h=l;while(1){b=d[k+g>>0]<<2;a[h>>0]=a[U+b>>0]|0;a[h+1>>0]=a[U+(b|1)>>0]|0;a[h+2>>0]=a[U+(b|2)>>0]|0;g=g+1|0;if((g|0)==(j|0))break;else h=h+3|0}}}else if(!g){g=0;h=l;while(1){b=d[k+g>>0]<<2;a[h>>0]=a[U+b>>0]|0;a[h+1>>0]=a[U+(b|1)>>0]|0;a[h+2>>0]=a[U+(b|2)>>0]|0;a[h+3>>0]=a[U+(b|3)>>0]|0;g=g+1|0;if((g|0)==(j|0))break;else h=h+4|0}}go(c[T>>2]|0);c[T>>2]=l}go(c[S>>2]|0);c[S>>2]=0;U=1;i=V;return U|0}while(0);c[S>>2]=0;U=0;i=V;return U|0}case 340:{c[5682]=30325;U=0;i=V;return U|0}case 342:{a[30543]=k;a[30544]=h;a[30545]=j;a[30546]=g;c[5682]=30543;U=0;i=V;return U|0}case 375:{i=V;return g|0}}return 0}function Lk(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=b+168|0;j=c[o>>2]|0;p=b+172|0;do if(j>>>0>=(c[p>>2]|0)>>>0){l=b+32|0;if(c[l>>2]|0){j=b+40|0;k=jd[c[b+16>>2]&15](c[b+28>>2]|0,j,c[b+36>>2]|0)|0;if(!k){c[l>>2]=0;k=(c[p>>2]|0)+-1|0;c[o>>2]=k;a[k>>0]=0;k=c[o>>2]|0;m=6;break}else{c[o>>2]=j;c[p>>2]=b+40+k;k=j;m=6;break}}}else{k=j;m=6}while(0);a:do if((m|0)==6?(i=k+1|0,c[o>>2]=i,(a[k>>0]|0)==71):0){do if(i>>>0>=(c[p>>2]|0)>>>0){j=b+32|0;if(!(c[j>>2]|0))break a;i=b+40|0;k=jd[c[b+16>>2]&15](c[b+28>>2]|0,i,c[b+36>>2]|0)|0;if(!k){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[o>>2]|0;break}else{c[o>>2]=i;c[p>>2]=b+40+k;break}}while(0);j=i+1|0;c[o>>2]=j;if((a[i>>0]|0)==73){do if(j>>>0>=(c[p>>2]|0)>>>0){j=b+32|0;if(!(c[j>>2]|0))break a;i=b+40|0;k=jd[c[b+16>>2]&15](c[b+28>>2]|0,i,c[b+36>>2]|0)|0;if(!k){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[o>>2]|0;break}else{c[o>>2]=i;c[p>>2]=b+40+k;break}}else i=j;while(0);j=i+1|0;c[o>>2]=j;if((a[i>>0]|0)==70){do if(j>>>0>=(c[p>>2]|0)>>>0){j=b+32|0;if(!(c[j>>2]|0))break a;i=b+40|0;k=jd[c[b+16>>2]&15](c[b+28>>2]|0,i,c[b+36>>2]|0)|0;if(!k){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[o>>2]|0;break}else{c[o>>2]=i;c[p>>2]=b+40+k;break}}else i=j;while(0);l=i+1|0;c[o>>2]=l;if((a[i>>0]|0)==56){if(l>>>0>=(c[p>>2]|0)>>>0){k=b+32|0;if(!(c[k>>2]|0)){j=0;i=l}else{i=b+40|0;j=jd[c[b+16>>2]&15](c[b+28>>2]|0,i,c[b+36>>2]|0)|0;if(!j){c[k>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[o>>2]|0}else{c[o>>2]=i;c[p>>2]=b+40+j}n=i+1|0;c[o>>2]=n;j=d[i>>0]|0;i=n}}else{i=i+2|0;c[o>>2]=i;j=d[l>>0]|0}switch((j&255)<<24>>24){case 57:case 55:break;default:{c[5682]=30170;b=0;return b|0}}do if(i>>>0>=(c[p>>2]|0)>>>0){j=b+32|0;if(c[j>>2]|0){h=b+40|0;i=jd[c[b+16>>2]&15](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if(!i){c[j>>2]=0;h=(c[p>>2]|0)+-1|0;c[o>>2]=h;a[h>>0]=0;h=c[o>>2]|0;m=40;break}else{c[o>>2]=h;c[p>>2]=b+40+i;m=40;break}}}else{h=i;m=40}while(0);if((m|0)==40?(c[o>>2]=h+1,(a[h>>0]|0)==97):0){c[5682]=30178;h=c[o>>2]|0;i=c[p>>2]|0;if(h>>>0>=i>>>0){j=b+32|0;if(!(c[j>>2]|0))k=0;else{h=b+40|0;i=jd[c[b+16>>2]&15](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if(!i){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[p>>2]|0;h=c[o>>2]|0}else{c[o>>2]=h;i=b+40+i|0;c[p>>2]=i}n=h+1|0;c[o>>2]=n;k=d[h>>0]|0;h=n}}else{n=h+1|0;c[o>>2]=n;k=d[h>>0]|0;h=n}if(h>>>0>=i>>>0){j=b+32|0;if(!(c[j>>2]|0))j=0;else{h=b+40|0;i=jd[c[b+16>>2]&15](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if(!i){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[p>>2]|0;h=c[o>>2]|0}else{c[o>>2]=h;i=b+40+i|0;c[p>>2]=i}n=h+1|0;c[o>>2]=n;j=d[h>>0]|0;h=n}}else{n=h+1|0;c[o>>2]=n;j=d[h>>0]|0;h=n}c[e>>2]=j<<8|k;if(h>>>0>=i>>>0){j=b+32|0;if(!(c[j>>2]|0))k=0;else{h=b+40|0;i=jd[c[b+16>>2]&15](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if(!i){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[p>>2]|0;h=c[o>>2]|0}else{c[o>>2]=h;i=b+40+i|0;c[p>>2]=i}n=h+1|0;c[o>>2]=n;k=d[h>>0]|0;h=n}}else{n=h+1|0;c[o>>2]=n;k=d[h>>0]|0;h=n}if(h>>>0>=i>>>0){j=b+32|0;if(!(c[j>>2]|0))j=0;else{h=b+40|0;i=jd[c[b+16>>2]&15](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if(!i){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[p>>2]|0;h=c[o>>2]|0}else{c[o>>2]=h;i=b+40+i|0;c[p>>2]=i}n=h+1|0;c[o>>2]=n;j=d[h>>0]|0;h=n}}else{n=h+1|0;c[o>>2]=n;j=d[h>>0]|0;h=n}c[e+4>>2]=j<<8|k;if(h>>>0>=i>>>0){j=b+32|0;if(!(c[j>>2]|0))j=0;else{h=b+40|0;i=jd[c[b+16>>2]&15](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if(!i){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[p>>2]|0;h=c[o>>2]|0}else{c[o>>2]=h;i=b+40+i|0;c[p>>2]=i}n=h+1|0;c[o>>2]=n;j=d[h>>0]|0;h=n}}else{n=h+1|0;c[o>>2]=n;j=d[h>>0]|0;h=n}l=e+12|0;c[l>>2]=j;do if(h>>>0<i>>>0){k=h+1|0;c[o>>2]=k;j=d[h>>0]|0;h=i}else{j=b+32|0;if(!(c[j>>2]|0)){j=0;k=h;h=i;break}h=b+40|0;i=jd[c[b+16>>2]&15](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if(!i){c[j>>2]=0;i=(c[p>>2]|0)+-1|0;c[o>>2]=i;a[i>>0]=0;i=c[p>>2]|0;h=c[o>>2]|0}else{c[o>>2]=h;i=b+40+i|0;c[p>>2]=i}k=h+1|0;c[o>>2]=k;j=d[h>>0]|0;h=i}while(0);c[e+16>>2]=j;do if(k>>>0<h>>>0){i=k+1|0;c[o>>2]=i;h=d[k>>0]|0}else{j=b+32|0;if(!(c[j>>2]|0)){h=0;i=k;break}h=b+40|0;i=jd[c[b+16>>2]&15](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if(!i){c[j>>2]=0;h=(c[p>>2]|0)+-1|0;c[o>>2]=h;a[h>>0]=0;h=c[o>>2]|0}else{c[o>>2]=h;c[p>>2]=b+40+i}i=h+1|0;c[o>>2]=i;h=d[h>>0]|0}while(0);c[e+20>>2]=h;c[e+24>>2]=-1;if(f)c[f>>2]=4;if(g){b=1;return b|0}h=c[l>>2]|0;if(!(h&128)){b=1;return b|0}k=2<<(h&7);if((k|0)<=0){b=1;return b|0}l=b+32|0;m=b+16|0;f=b+28|0;g=b+40|0;n=b+36|0;j=0;while(1){do if(i>>>0<(c[p>>2]|0)>>>0){c[o>>2]=i+1;h=d[i>>0]|0}else{if(!(c[l>>2]|0)){h=0;break}h=jd[c[m>>2]&15](c[f>>2]|0,g,c[n>>2]|0)|0;if(!h){c[l>>2]=0;h=(c[p>>2]|0)+-1|0;c[o>>2]=h;a[h>>0]=0;h=c[o>>2]|0}else{c[o>>2]=g;c[p>>2]=b+40+h;h=g}c[o>>2]=h+1;h=d[h>>0]|0}while(0);a[e+32+(j<<2)+2>>0]=h;h=c[o>>2]|0;do if(h>>>0<(c[p>>2]|0)>>>0){c[o>>2]=h+1;h=d[h>>0]|0}else{if(!(c[l>>2]|0)){h=0;break}h=jd[c[m>>2]&15](c[f>>2]|0,g,c[n>>2]|0)|0;if(!h){c[l>>2]=0;h=(c[p>>2]|0)+-1|0;c[o>>2]=h;a[h>>0]=0;h=c[o>>2]|0}else{c[o>>2]=g;c[p>>2]=b+40+h;h=g}c[o>>2]=h+1;h=d[h>>0]|0}while(0);a[e+32+(j<<2)+1>>0]=h;h=c[o>>2]|0;do if(h>>>0<(c[p>>2]|0)>>>0){c[o>>2]=h+1;h=d[h>>0]|0}else{if(!(c[l>>2]|0)){h=0;break}h=jd[c[m>>2]&15](c[f>>2]|0,g,c[n>>2]|0)|0;if(!h){c[l>>2]=0;h=(c[p>>2]|0)+-1|0;c[o>>2]=h;a[h>>0]=0;h=c[o>>2]|0}else{c[o>>2]=g;c[p>>2]=b+40+h;h=g}c[o>>2]=h+1;h=d[h>>0]|0}while(0);a[e+32+(j<<2)>>0]=h;a[e+32+(j<<2)+3>>0]=0;h=j+1|0;if((h|0)==(k|0)){h=1;break}i=c[o>>2]|0;j=h}return h|0}c[5682]=30170;b=0;return b|0}}}}while(0);c[5682]=30170;b=0;return b|0}function Mk(b,c){b=b|0;c=c|0;var d=0,e=0,f=0;d=Nk(b)|0;a:do if((Ok(b)|0)!=0|(d&255|0)==10)d=0;else{e=d;f=0;while(1){d=f+1|0;a[c+f>>0]=e;if((d|0)==1023)break;e=Nk(b)|0;if((Ok(b)|0)!=0|(e&255|0)==10)break a;else f=d}while(1){if(Ok(b)|0){d=1023;break a}if((Nk(b)|0)==10){d=1023;break}}}while(0);a[c+d>>0]=0;return c|0}function Nk(b){b=b|0;var e=0,f=0,g=0,h=0,i=0;i=b+168|0;e=c[i>>2]|0;h=b+172|0;if(e>>>0<(c[h>>2]|0)>>>0){c[i>>2]=e+1;i=d[e>>0]|0;return i|0}g=b+32|0;if(!(c[g>>2]|0)){i=0;return i|0}e=b+40|0;f=jd[c[b+16>>2]&15](c[b+28>>2]|0,e,c[b+36>>2]|0)|0;if(!f){c[g>>2]=0;e=(c[h>>2]|0)+-1|0;c[i>>2]=e;a[e>>0]=0;e=c[i>>2]|0}else{c[i>>2]=e;c[h>>2]=b+40+f}c[i>>2]=e+1;i=d[e>>0]|0;return i|0}function Ok(a){a=a|0;if(c[a+16>>2]|0){if(!(rd[c[a+24>>2]&63](c[a+28>>2]|0)|0)){a=0;return a|0}if(!(c[a+32>>2]|0)){a=1;return a|0}}a=(c[a+168>>2]|0)>>>0>=(c[a+172>>2]|0)>>>0&1;return a|0}function Pk(b,e,f,g,h,i){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;j=c[b>>2]|0;s=$(h,g)|0;t=c[j+8>>2]|0;u=(t|0)==(g|0);v=t+1|0;w=(v|0)==(g|0);if(!(u|w))Ba(30564,30466,2118,30605);k=(c[5681]|0)==0;r=k?i:1;l=fo($(s,r)|0)|0;q=b+12|0;c[q>>2]=l;if(!l){c[5682]=30100;g=0;return g|0}do if(k){if((c[j>>2]|0)==(h|0)?(c[j+4>>2]|0)==(r|0):0){if(($(r,($(t,h)|0)+1|0)|0)==(f|0))break;c[5682]=30626;g=0;return g|0}if(($(r,($(t,h)|0)+1|0)|0)>>>0>f>>>0){c[5682]=30626;g=0;return g|0}}while(0);if(!r){g=1;return g|0}n=(t|0)>0;p=h+-1|0;o=(p|0)==0;m=($(t,h)|0)+1|0;b=a[e>>0]|0;a:do if((b&255)<=4){i=e;k=0;b=b&255;e=0;b:while(1){j=k-s|0;if(!e)h=d[30659+b>>0]|0;else h=b;c:do if(n)switch(h|0){case 0:{b=0;do{a[l+(b+k)>>0]=a[i+(b+1)>>0]|0;b=b+1|0}while((b|0)!=(t|0));break}case 1:{b=0;do{a[l+(b+k)>>0]=a[i+(b+1)>>0]|0;b=b+1|0}while((b|0)<(t|0));break}default:{b=0;while(1){switch(h|0){case 5:{a[l+(b+k)>>0]=a[i+(b+1)>>0]|0;break}case 6:{a[l+(b+k)>>0]=a[i+(b+1)>>0]|0;break}case 2:{a[l+(b+k)>>0]=(d[l+(b+j)>>0]|0)+(d[i+(b+1)>>0]|0);break}case 3:{a[l+(b+k)>>0]=((d[l+(b+j)>>0]|0)>>>1)+(d[i+(b+1)>>0]|0);break}case 4:{a[l+(b+k)>>0]=(d[l+(b+j)>>0]|0)+(d[i+(b+1)>>0]|0);break}default:{}}b=b+1|0;if((b|0)>=(t|0))break c}}}while(0);d:do if(u){f=i+v|0;b=l+(k+g)|0;k=l+(j+g)|0;switch(h|0){case 0:{if(o){i=f;break d}else j=p;while(1){if(n){k=0;do{a[b+k>>0]=a[f+k>>0]|0;k=k+1|0}while((k|0)!=(g|0))}j=j+-1|0;if(!j)break;else{f=f+g|0;b=b+g|0}}i=i+m|0;break d}case 1:{if(o){i=f;break d}else j=p;while(1){if(n){k=0;do{a[b+k>>0]=(d[b+(k-g)>>0]|0)+(d[f+k>>0]|0);k=k+1|0}while((k|0)!=(g|0))}j=j+-1|0;if(!j)break;else{f=f+g|0;b=b+g|0}}i=i+m|0;break d}case 2:{if(o){i=f;break d}else h=p;while(1){if(n){j=0;do{a[b+j>>0]=(d[k+j>>0]|0)+(d[f+j>>0]|0);j=j+1|0}while((j|0)!=(g|0))}h=h+-1|0;if(!h)break;else{f=f+g|0;b=b+g|0;k=k+g|0}}i=i+m|0;break d}case 3:{if(o){i=f;break d}else h=p;while(1){if(n){j=0;do{a[b+j>>0]=(((d[b+(j-g)>>0]|0)+(d[k+j>>0]|0)|0)>>>1)+(d[f+j>>0]|0);j=j+1|0}while((j|0)!=(g|0))}h=h+-1|0;if(!h)break;else{f=f+g|0;b=b+g|0;k=k+g|0}}i=i+m|0;break d}case 4:{if(o){i=f;break d}else h=p;while(1){if(n){j=0;do{y=j-g|0;l=d[b+y>>0]|0;x=d[k+j>>0]|0;y=d[k+y>>0]|0;z=x+l-y|0;B=z-l|0;B=(B|0)>-1?B:0-B|0;A=z-x|0;A=(A|0)>-1?A:0-A|0;z=z-y|0;z=(z|0)>-1?z:0-z|0;a[b+j>>0]=((B|0)>(A|0)|(B|0)>(z|0)?((A|0)>(z|0)?y:x):l)+(d[f+j>>0]|0);j=j+1|0}while((j|0)!=(g|0))}h=h+-1|0;if(!h)break;else{f=f+g|0;b=b+g|0;k=k+g|0}}i=i+m|0;break d}case 5:{if(o){i=f;break d}else j=p;while(1){if(n){k=0;do{a[b+k>>0]=((d[b+(k-g)>>0]|0)>>>1)+(d[f+k>>0]|0);k=k+1|0}while((k|0)!=(g|0))}j=j+-1|0;if(!j)break;else{f=f+g|0;b=b+g|0}}i=i+m|0;break d}case 6:{if(o){i=f;break d}else j=p;while(1){if(n){k=0;do{a[b+k>>0]=(d[b+(k-g)>>0]|0)+(d[f+k>>0]|0);k=k+1|0}while((k|0)!=(g|0))}j=j+-1|0;if(!j)break;else{f=f+g|0;b=b+g|0}}i=i+m|0;break d}default:{i=f;break d}}}else{a[l+(k+t)>>0]=-1;f=i+v|0;b=l+(k+g)|0;k=l+(j+g)|0;if(!w){b=60;break b}switch(h|0){case 0:{if(o){i=f;break d}else j=p;while(1){if(n){k=0;do{a[b+k>>0]=a[f+k>>0]|0;k=k+1|0}while((k|0)!=(t|0))}a[b+t>>0]=-1;j=j+-1|0;if(!j)break;else{f=f+t|0;b=b+g|0}}i=i+m|0;break d}case 1:{if(o){i=f;break d}else j=p;while(1){if(n){k=0;do{a[b+k>>0]=(d[b+(k-g)>>0]|0)+(d[f+k>>0]|0);k=k+1|0}while((k|0)!=(t|0))}a[b+t>>0]=-1;j=j+-1|0;if(!j)break;else{f=f+t|0;b=b+g|0}}i=i+m|0;break d}case 2:{if(o){i=f;break d}else h=p;while(1){if(n){j=0;do{a[b+j>>0]=(d[k+j>>0]|0)+(d[f+j>>0]|0);j=j+1|0}while((j|0)!=(t|0))}a[b+t>>0]=-1;h=h+-1|0;if(!h)break;else{f=f+t|0;b=b+g|0;k=k+g|0}}i=i+m|0;break d}case 3:{if(o){i=f;break d}else h=p;while(1){if(n){j=0;do{a[b+j>>0]=(((d[b+(j-g)>>0]|0)+(d[k+j>>0]|0)|0)>>>1)+(d[f+j>>0]|0);j=j+1|0}while((j|0)!=(t|0))}a[b+t>>0]=-1;h=h+-1|0;if(!h)break;else{f=f+t|0;b=b+g|0;k=k+g|0}}i=i+m|0;break d}case 4:{if(o){i=f;break d}else h=p;while(1){if(n){j=0;do{z=j-g|0;B=d[b+z>>0]|0;A=d[k+j>>0]|0;z=d[k+z>>0]|0;y=A+B-z|0;l=y-B|0;l=(l|0)>-1?l:0-l|0;x=y-A|0;x=(x|0)>-1?x:0-x|0;y=y-z|0;y=(y|0)>-1?y:0-y|0;a[b+j>>0]=((l|0)>(x|0)|(l|0)>(y|0)?((x|0)>(y|0)?z:A):B)+(d[f+j>>0]|0);j=j+1|0}while((j|0)!=(t|0))}a[b+t>>0]=-1;h=h+-1|0;if(!h)break;else{f=f+t|0;b=b+g|0;k=k+g|0}}i=i+m|0;break d}case 5:{if(o){i=f;break d}else j=p;while(1){if(n){k=0;do{a[b+k>>0]=((d[b+(k-g)>>0]|0)>>>1)+(d[f+k>>0]|0);k=k+1|0}while((k|0)!=(t|0))}a[b+t>>0]=-1;j=j+-1|0;if(!j)break;else{f=f+t|0;b=b+g|0}}i=i+m|0;break d}case 6:{if(o){i=f;break d}else j=p;while(1){if(n){k=0;do{a[b+k>>0]=(d[b+(k-g)>>0]|0)+(d[f+k>>0]|0);k=k+1|0}while((k|0)!=(t|0))}a[b+t>>0]=-1;j=j+-1|0;if(!j)break;else{f=f+t|0;b=b+g|0}}i=i+m|0;break d}default:{i=f;break d}}}while(0);e=e+1|0;if(e>>>0>=r>>>0){i=1;b=106;break}k=$(e,s)|0;b=a[i>>0]|0;if((b&255)>4)break a;else{b=b&255;l=c[q>>2]|0}}if((b|0)==60)Ba(30664,30466,2169,30605);else if((b|0)==106)return i|0}while(0);c[5682]=30644;B=0;return B|0}function Qk(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+64|0;r=t;switch(e|0){case 255:{c[5682]=30799;b=0;i=t;return b|0}case 194:{c[5682]=30815;b=0;i=t;return b|0}case 221:{j=c[b>>2]|0;l=j+168|0;e=c[l>>2]|0;k=j+172|0;f=c[k>>2]|0;if(e>>>0>=f>>>0){g=j+32|0;if(!(c[g>>2]|0))g=0;else{e=j+40|0;f=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!f){c[g>>2]=0;f=(c[k>>2]|0)+-1|0;c[l>>2]=f;a[f>>0]=0;f=c[k>>2]|0;e=c[l>>2]|0}else{c[l>>2]=e;f=j+40+f|0;c[k>>2]=f}s=e+1|0;c[l>>2]=s;g=d[e>>0]|0;e=s}}else{s=e+1|0;c[l>>2]=s;g=d[e>>0]|0;e=s}h=g<<8;if(e>>>0>=f>>>0){f=j+32|0;if(!(c[f>>2]|0))e=0;else{e=j+40|0;g=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!g){c[f>>2]=0;e=(c[k>>2]|0)+-1|0;c[l>>2]=e;a[e>>0]=0;e=c[l>>2]|0}else{c[l>>2]=e;c[k>>2]=j+40+g}c[l>>2]=e+1;e=d[e>>0]|0}}else{c[l>>2]=e+1;e=d[e>>0]|0}if((e|h|0)!=4){c[5682]=30832;b=0;i=t;return b|0}j=c[b>>2]|0;l=j+168|0;e=c[l>>2]|0;k=j+172|0;f=c[k>>2]|0;if(e>>>0>=f>>>0){g=j+32|0;if(!(c[g>>2]|0))g=0;else{e=j+40|0;f=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!f){c[g>>2]=0;f=(c[k>>2]|0)+-1|0;c[l>>2]=f;a[f>>0]=0;f=c[k>>2]|0;e=c[l>>2]|0}else{c[l>>2]=e;f=j+40+f|0;c[k>>2]=f}s=e+1|0;c[l>>2]=s;g=d[e>>0]|0;e=s}}else{s=e+1|0;c[l>>2]=s;g=d[e>>0]|0;e=s}h=g<<8;if(e>>>0>=f>>>0){g=j+32|0;if(!(c[g>>2]|0))e=0;else{e=j+40|0;f=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!f){c[g>>2]=0;e=(c[k>>2]|0)+-1|0;c[l>>2]=e;a[e>>0]=0;e=c[l>>2]|0}else{c[l>>2]=e;c[k>>2]=j+40+f}c[l>>2]=e+1;e=d[e>>0]|0}}else{c[l>>2]=e+1;e=d[e>>0]|0}c[b+13984>>2]=e|h;b=1;i=t;return b|0}case 219:{j=c[b>>2]|0;l=j+168|0;e=c[l>>2]|0;k=j+172|0;f=c[k>>2]|0;if(e>>>0>=f>>>0){g=j+32|0;if(!(c[g>>2]|0))g=0;else{e=j+40|0;f=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!f){c[g>>2]=0;f=(c[k>>2]|0)+-1|0;c[l>>2]=f;a[f>>0]=0;f=c[k>>2]|0;e=c[l>>2]|0}else{c[l>>2]=e;f=j+40+f|0;c[k>>2]=f}r=e+1|0;c[l>>2]=r;g=d[e>>0]|0;e=r}}else{r=e+1|0;c[l>>2]=r;g=d[e>>0]|0;e=r}h=g<<8;if(e>>>0>=f>>>0){f=j+32|0;if(!(c[f>>2]|0))e=0;else{e=j+40|0;g=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!g){c[f>>2]=0;e=(c[k>>2]|0)+-1|0;c[l>>2]=e;a[e>>0]=0;e=c[l>>2]|0}else{c[l>>2]=e;c[k>>2]=j+40+g}c[l>>2]=e+1;e=d[e>>0]|0}}else{c[l>>2]=e+1;e=d[e>>0]|0}r=e|h;e=r+-2|0;a:do if(r>>>0>2){while(1){j=c[b>>2]|0;l=j+168|0;f=c[l>>2]|0;k=j+172|0;do if(f>>>0>=(c[k>>2]|0)>>>0){h=j+32|0;if(c[h>>2]|0){f=j+40|0;g=jd[c[j+16>>2]&15](c[j+28>>2]|0,f,c[j+36>>2]|0)|0;if(!g){c[h>>2]=0;f=(c[k>>2]|0)+-1|0;c[l>>2]=f;a[f>>0]=0;f=c[l>>2]|0;s=56;break}else{c[l>>2]=f;c[k>>2]=j+40+g;s=56;break}}else f=0}else s=56;while(0);if((s|0)==56){s=0;c[l>>2]=f+1;r=a[f>>0]|0;f=r&15;if((r&255)>15){s=57;break}if(f>>>0>3){s=59;break}}n=0;do{k=c[b>>2]|0;m=k+168|0;g=c[m>>2]|0;l=k+172|0;if(g>>>0>=(c[l>>2]|0)>>>0){h=k+32|0;if(!(c[h>>2]|0))g=0;else{g=k+40|0;j=jd[c[k+16>>2]&15](c[k+28>>2]|0,g,c[k+36>>2]|0)|0;if(!j){c[h>>2]=0;g=(c[l>>2]|0)+-1|0;c[m>>2]=g;a[g>>0]=0;g=c[m>>2]|0}else{c[m>>2]=g;c[l>>2]=k+40+j}c[m>>2]=g+1;g=d[g>>0]|0}}else{c[m>>2]=g+1;g=d[g>>0]|0}a[(d[30871+n>>0]|0)+(b+13444+(f<<6))>>0]=g;n=n+1|0}while((n|0)!=64);f=e+-65|0;if((e|0)>65)e=f;else{e=f;break a}}if((s|0)==57){c[5682]=30844;b=0;i=t;return b|0}else if((s|0)==59){c[5682]=30857;b=0;i=t;return b|0}}while(0);b=(e|0)==0&1;i=t;return b|0}case 196:{j=c[b>>2]|0;l=j+168|0;e=c[l>>2]|0;k=j+172|0;f=c[k>>2]|0;if(e>>>0>=f>>>0){g=j+32|0;if(!(c[g>>2]|0))g=0;else{e=j+40|0;f=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!f){c[g>>2]=0;f=(c[k>>2]|0)+-1|0;c[l>>2]=f;a[f>>0]=0;f=c[k>>2]|0;e=c[l>>2]|0}else{c[l>>2]=e;f=j+40+f|0;c[k>>2]=f}q=e+1|0;c[l>>2]=q;g=d[e>>0]|0;e=q}}else{q=e+1|0;c[l>>2]=q;g=d[e>>0]|0;e=q}h=g<<8;if(e>>>0>=f>>>0){f=j+32|0;if(!(c[f>>2]|0))e=0;else{e=j+40|0;g=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!g){c[f>>2]=0;e=(c[k>>2]|0)+-1|0;c[l>>2]=e;a[e>>0]=0;e=c[l>>2]|0}else{c[l>>2]=e;c[k>>2]=j+40+g}c[l>>2]=e+1;e=d[e>>0]|0}}else{c[l>>2]=e+1;e=d[e>>0]|0}q=e|h;e=q+-2|0;b:do if(q>>>0>2){while(1){j=c[b>>2]|0;l=j+168|0;f=c[l>>2]|0;k=j+172|0;if(f>>>0>=(c[k>>2]|0)>>>0){g=j+32|0;if(!(c[g>>2]|0))p=0;else{f=j+40|0;h=jd[c[j+16>>2]&15](c[j+28>>2]|0,f,c[j+36>>2]|0)|0;if(!h){c[g>>2]=0;f=(c[k>>2]|0)+-1|0;c[l>>2]=f;a[f>>0]=0;f=c[l>>2]|0}else{c[l>>2]=f;c[k>>2]=j+40+h}c[l>>2]=f+1;p=d[f>>0]|0}}else{c[l>>2]=f+1;p=d[f>>0]|0}q=p&15;if(p>>>0>31|q>>>0>3){s=94;break}else{n=0;f=0}do{k=c[b>>2]|0;m=k+168|0;g=c[m>>2]|0;l=k+172|0;if(g>>>0>=(c[l>>2]|0)>>>0){h=k+32|0;if(!(c[h>>2]|0))g=0;else{g=k+40|0;j=jd[c[k+16>>2]&15](c[k+28>>2]|0,g,c[k+36>>2]|0)|0;if(!j){c[h>>2]=0;g=(c[l>>2]|0)+-1|0;c[m>>2]=g;a[g>>0]=0;g=c[m>>2]|0}else{c[m>>2]=g;c[l>>2]=k+40+j}c[m>>2]=g+1;g=d[g>>0]|0}}else{c[m>>2]=g+1;g=d[g>>0]|0}c[r+(n<<2)>>2]=g;f=g+f|0;n=n+1|0}while((n|0)!=16);o=e+-17|0;if(!(p&240)){if(!(Rk(b+4+(q*1680|0)|0,r)|0))break;n=b+4+(q*1680|0)+1024|0}else{if(!(Rk(b+6724+(q*1680|0)|0,r)|0))break;n=b+6724+(q*1680|0)+1024|0}if((f|0)>0){m=0;do{j=c[b>>2]|0;l=j+168|0;e=c[l>>2]|0;k=j+172|0;if(e>>>0>=(c[k>>2]|0)>>>0){g=j+32|0;if(!(c[g>>2]|0))e=0;else{e=j+40|0;h=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!h){c[g>>2]=0;e=(c[k>>2]|0)+-1|0;c[l>>2]=e;a[e>>0]=0;e=c[l>>2]|0}else{c[l>>2]=e;c[k>>2]=j+40+h}c[l>>2]=e+1;e=d[e>>0]|0}}else{c[l>>2]=e+1;e=d[e>>0]|0}a[n+m>>0]=e;m=m+1|0}while((m|0)!=(f|0))}e=o-f|0;if((e|0)<=0)break b}if((s|0)==94)c[5682]=30950;b=0;i=t;return b|0}while(0);b=(e|0)==0&1;i=t;return b|0}default:{if(!((e|0)==254|(e&-16|0)==224)){b=0;i=t;return b|0}j=c[b>>2]|0;k=j+168|0;f=c[k>>2]|0;l=j+172|0;e=c[l>>2]|0;if(f>>>0>=e>>>0){g=j+32|0;if(!(c[g>>2]|0))h=0;else{e=j+40|0;f=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!f){c[g>>2]=0;g=(c[l>>2]|0)+-1|0;c[k>>2]=g;a[g>>0]=0;g=c[l>>2]|0;e=c[k>>2]|0}else{c[k>>2]=e;g=j+40+f|0;c[l>>2]=g}f=e+1|0;c[k>>2]=f;h=d[e>>0]|0;e=g}}else{b=f+1|0;c[k>>2]=b;h=d[f>>0]|0;f=b}h=h<<8;if(f>>>0>=e>>>0){g=j+32|0;if(!(c[g>>2]|0))e=0;else{e=j+40|0;f=jd[c[j+16>>2]&15](c[j+28>>2]|0,e,c[j+36>>2]|0)|0;if(!f){c[g>>2]=0;e=(c[l>>2]|0)+-1|0;c[k>>2]=e;a[e>>0]=0;e=c[k>>2]|0}else{c[k>>2]=e;c[l>>2]=j+40+f}f=e+1|0;c[k>>2]=f;e=d[e>>0]|0}}else{b=f+1|0;c[k>>2]=b;e=d[f>>0]|0;f=b}e=(e|h)+-2|0;if((c[j+16>>2]|0)!=0?(m=c[l>>2]|0,n=m-f|0,(e|0)>(n|0)):0){c[k>>2]=m;qd[c[j+20>>2]&63](c[j+28>>2]|0,e-n|0);b=1;i=t;return b|0}c[k>>2]=f+e;b=1;i=t;return b|0}}return 0}function Rk(f,g){f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;m=0;h=0;do{j=g+(m<<2)|0;m=m+1|0;if((c[j>>2]|0)>0){k=m&255;l=0;i=h;while(1){h=i+1|0;a[f+1280+i>>0]=k;l=l+1|0;if((l|0)>=(c[j>>2]|0))break;else i=h}}}while((m|0)!=16);a[f+1280+h>>0]=0;i=0;h=1;j=0;while(1){c[f+1612+(h<<2)>>2]=j-i;if((d[f+1280+j>>0]|0|0)==(h|0)){l=j;while(1){k=i+1|0;j=l+1|0;b[f+512+(l<<1)>>1]=i;if((d[f+1280+j>>0]|0|0)==(h|0)){i=k;l=j}else break}if((i|0)<(1<<h|0))i=k;else{n=10;break}}c[f+1540+(h<<2)>>2]=i<<16-h;h=h+1|0;if((h|0)<17)i=i<<1;else break}if((n|0)==10){c[5682]=30965;f=0;return f|0}c[f+1540+(h<<2)>>2]=-1;uo(f|0,-1,512)|0;if((j|0)>0)i=0;else{f=1;return f|0}do{h=a[f+1280+i>>0]|0;if((h&255)<10?(o=9-(h&255)|0,p=1<<o,(o|0)!=31):0)uo(f+((e[f+512+(i<<1)>>1]|0)<<o)|0,i&255|0,((p|0)>1?p:1)|0)|0;i=i+1|0}while((i|0)!=(j|0));h=1;return h|0}function Sk(f,g,h){f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+144|0;q=r+72|0;p=r;j=p;k=j+68|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(k|0));uo(f|0,-1,1024)|0;o=(h|0)>0;if(o){j=0;do{m=p+((d[g+j>>0]|0)<<2)|0;c[m>>2]=(c[m>>2]|0)+1;j=j+1|0}while((j|0)!=(h|0));j=c[p+4>>2]|0;c[p>>2]=0;if((j|0)<=2){n=j;l=5}}else{c[p>>2]=0;n=0;l=5}if(((((((((((((((l|0)==5?(c[p+8>>2]|0)<=4:0)?(c[p+12>>2]|0)<=8:0)?(c[p+16>>2]|0)<=16:0)?(c[p+20>>2]|0)<=32:0)?(c[p+24>>2]|0)<=64:0)?(c[p+28>>2]|0)<=128:0)?(c[p+32>>2]|0)<=256:0)?(c[p+36>>2]|0)<=512:0)?(c[p+40>>2]|0)<=1024:0)?(c[p+44>>2]|0)<=2048:0)?(c[p+48>>2]|0)<=4096:0)?(c[p+52>>2]|0)<=8192:0)?(c[p+56>>2]|0)<=16384:0)?(c[p+60>>2]|0)<=32768:0){c[q+4>>2]=0;b[f+1026>>1]=0;b[f+1126>>1]=0;a:do if((n|0)<=2){m=n;j=n;k=1;l=0;while(1){c[f+1056+(k<<2)>>2]=m<<16-k;k=k+1|0;if((k|0)>=16)break;l=j+l|0;n=m<<1;j=c[p+(k<<2)>>2]|0;c[q+(k<<2)>>2]=n;b[f+1024+(k<<1)>>1]=n;b[f+1124+(k<<1)>>1]=l;m=j+n|0;if((j|0)!=0&(m|0)>(1<<k|0))break a}c[f+1120>>2]=65536;if(o)p=0;else{f=1;i=r;return f|0}do{j=a[g+p>>0]|0;l=j&255;if(j<<24>>24){n=q+(l<<2)|0;o=c[n>>2]|0;k=o-(e[f+1024+(l<<1)>>1]|0)+(e[f+1124+(l<<1)>>1]|0)|0;a[f+1156+k>>0]=j;b[f+1444+(k<<1)>>1]=p;do if((j&255)<10){j=o>>>1&21845|o<<1&43690;j=j>>>2&13107|j<<2&52428;j=j>>>4&3855|j<<4&61680;j=(j<<8&65280|j>>>8)>>>(16-l|0);if((j|0)>=512)break;m=k&65535;k=1<<l;do{b[f+(j<<1)>>1]=m;j=j+k|0}while((j|0)<512)}while(0);c[n>>2]=o+1}p=p+1|0}while((p|0)<(h|0));j=1;i=r;return j|0}while(0);c[5682]=31554;f=0;i=r;return f|0}Ba(31628,30466,1665,31649);return 0}function Tk(a,f){a=a|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=a+8|0;g=c[k>>2]|0;m=a+12|0;a:do if((g|0)<16){j=a+4|0;i=c[m>>2]|0;while(1){if(i>>>0>=1<<g>>>0)break;h=c[a>>2]|0;if(h>>>0<(c[j>>2]|0)>>>0){c[a>>2]=h+1;h=d[h>>0]|0}else h=0;h=h<<g|i;c[m>>2]=h;g=g+8|0;c[k>>2]=g;if((g|0)<25)i=h;else{l=h;n=g;break a}}Ba(31029,30466,1727,31066)}else{l=c[m>>2]|0;n=g}while(0);a=b[f+((l&511)<<1)>>1]|0;g=a&65535;if(a<<16>>16!=-1){a=d[f+1156+g>>0]|0;c[m>>2]=l>>>a;c[k>>2]=n-a;f=e[f+1444+(g<<1)>>1]|0;return f|0}h=l>>>1&21845|l<<1&43690;h=h>>>2&13107|h<<2&52428;h=h>>>4&3855|h<<4&61680;h=h<<8&65280|h>>>8;g=10;while(1)if((h|0)<(c[f+1056+(g<<2)>>2]|0)){i=g;break}else g=g+1|0;if((i|0)==16){f=-1;return f|0}g=(h>>>(16-i|0))-(e[f+1024+(i<<1)>>1]|0)+(e[f+1124+(i<<1)>>1]|0)|0;if((d[f+1156+g>>0]|0|0)!=(i|0))Ba(31596,30466,1764,31612);c[m>>2]=l>>>i;c[k>>2]=n-i;f=e[f+1444+(g<<1)>>1]|0;return f|0}function Uk(e,f,g,h,i){e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;s=dl(e,g)|0;if((s|0)<0){c[5682]=31570;e=0;return e|0}g=f;j=g+128|0;do{b[g>>1]=0;g=g+2|0}while((g|0)<(j|0));if(s){q=1<<s+-1;r=e+13952|0;g=c[r>>2]|0;a:do if((g|0)<(s|0)){p=e+13960|0;k=e+13948|0;b:while(1){c:do if(!(c[p>>2]|0)){m=c[e>>2]|0;o=m+168|0;g=c[o>>2]|0;n=m+172|0;do if(g>>>0>=(c[n>>2]|0)>>>0){j=m+32|0;if(!(c[j>>2]|0)){g=0;break c}g=m+40|0;l=jd[c[m+16>>2]&15](c[m+28>>2]|0,g,c[m+36>>2]|0)|0;if(!l){c[j>>2]=0;g=(c[n>>2]|0)+-1|0;c[o>>2]=g;a[g>>0]=0;g=c[o>>2]|0;break}else{c[o>>2]=g;c[n>>2]=m+40+l;break}}while(0);c[o>>2]=g+1;t=a[g>>0]|0;g=t&255;if(t<<24>>24==-1){m=c[e>>2]|0;o=m+168|0;g=c[o>>2]|0;n=m+172|0;do if(g>>>0>=(c[n>>2]|0)>>>0){j=m+32|0;if(!(c[j>>2]|0)){g=255;break c}g=m+40|0;l=jd[c[m+16>>2]&15](c[m+28>>2]|0,g,c[m+36>>2]|0)|0;if(!l){c[j>>2]=0;g=(c[n>>2]|0)+-1|0;c[o>>2]=g;a[g>>0]=0;g=c[o>>2]|0;break}else{c[o>>2]=g;c[n>>2]=m+40+l;break}}while(0);c[o>>2]=g+1;g=a[g>>0]|0;if(!(g<<24>>24))g=255;else break b}}else g=0;while(0);j=c[r>>2]|0;c[k>>2]=g<<24-j|c[k>>2];j=j+8|0;c[r>>2]=j;if((j|0)>=25)break a}a[e+13956>>0]=g;c[p>>2]=1;j=c[r>>2]|0}else{k=e+13948|0;j=g}while(0);t=c[k>>2]|0;t=t<<s|t>>>(32-s|0);g=c[23364+(s<<2)>>2]|0;c[k>>2]=t&~g;g=t&g;c[r>>2]=j-s;if(g>>>0<q>>>0)g=(-1<<s)+1+g|0}else{k=e+13948|0;r=e+13952|0;g=0}t=e+13724+(i*56|0)+24|0;i=(c[t>>2]|0)+g|0;c[t>>2]=i;b[f>>1]=i;i=e+13960|0;t=e+13956|0;g=1;while(1){j=dl(e,h)|0;if((j|0)<0){j=27;break}s=j&15;if(!s){if((j|0)!=240){g=1;j=51;break}g=g+16|0}else{q=(j>>4)+g|0;p=1<<s+-1;g=c[r>>2]|0;d:do if((g|0)<(s|0)){e:while(1){f:do if(!(c[i>>2]|0)){m=c[e>>2]|0;o=m+168|0;g=c[o>>2]|0;n=m+172|0;do if(g>>>0>=(c[n>>2]|0)>>>0){j=m+32|0;if(!(c[j>>2]|0)){g=0;break f}g=m+40|0;l=jd[c[m+16>>2]&15](c[m+28>>2]|0,g,c[m+36>>2]|0)|0;if(!l){c[j>>2]=0;g=(c[n>>2]|0)+-1|0;c[o>>2]=g;a[g>>0]=0;g=c[o>>2]|0;break}else{c[o>>2]=g;c[n>>2]=m+40+l;break}}while(0);c[o>>2]=g+1;o=a[g>>0]|0;g=o&255;if(o<<24>>24==-1){m=c[e>>2]|0;o=m+168|0;g=c[o>>2]|0;n=m+172|0;do if(g>>>0>=(c[n>>2]|0)>>>0){j=m+32|0;if(!(c[j>>2]|0)){g=255;break f}g=m+40|0;l=jd[c[m+16>>2]&15](c[m+28>>2]|0,g,c[m+36>>2]|0)|0;if(!l){c[j>>2]=0;g=(c[n>>2]|0)+-1|0;c[o>>2]=g;a[g>>0]=0;g=c[o>>2]|0;break}else{c[o>>2]=g;c[n>>2]=m+40+l;break}}while(0);c[o>>2]=g+1;g=a[g>>0]|0;if(!(g<<24>>24))g=255;else break e}}else g=0;while(0);o=c[r>>2]|0;c[k>>2]=g<<24-o|c[k>>2];g=o+8|0;c[r>>2]=g;if((g|0)>=25){j=g;break d}}a[t>>0]=g;c[i>>2]=1;j=c[r>>2]|0}else j=g;while(0);o=c[k>>2]|0;o=o<<s|o>>>(32-s|0);g=c[23364+(s<<2)>>2]|0;c[k>>2]=o&~g;g=o&g;c[r>>2]=j-s;if(g>>>0<p>>>0)g=(-1<<s)+1+g|0;b[f+((d[30871+q>>0]|0)<<1)>>1]=g;g=q+1|0}if((g|0)>=64){g=1;j=51;break}}if((j|0)==27){c[5682]=31570;e=0;return e|0}else if((j|0)==51)return g|0;return 0}function Vk(e,f,g,h){e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;t=i;i=i+256|0;o=t;l=0;m=o;while(1){k=b[g+16>>1]|0;j=b[g+32>>1]|0;if(!((k|j)<<16>>16))if(((((b[g+48>>1]|0)==0?(b[g+64>>1]|0)==0:0)?(b[g+80>>1]|0)==0:0)?(b[g+96>>1]|0)==0:0)?(b[g+112>>1]|0)==0:0){s=$(b[g>>1]<<2,d[h>>0]|0)|0;c[m+224>>2]=s;c[m+192>>2]=s;c[m+160>>2]=s;c[m+128>>2]=s;c[m+96>>2]=s;c[m+64>>2]=s;c[m+32>>2]=s;c[m>>2]=s}else{j=0;n=9}else n=9;if((n|0)==9){n=0;r=$(d[h+16>>0]|0,j<<16>>16)|0;p=$(d[h+48>>0]|0,b[g+96>>1]|0)|0;v=(p+r|0)*2217|0;p=v+($(p,-7567)|0)|0;r=v+(r*3135|0)|0;v=$(d[h>>0]|0,b[g>>1]|0)|0;x=$(d[h+32>>0]|0,b[g+64>>1]|0)|0;w=x+v<<12;x=v-x<<12;v=$(d[h+56>>0]|0,b[g+112>>1]|0)|0;y=$(d[h+40>>0]|0,b[g+80>>1]|0)|0;A=$(d[h+24>>0]|0,b[g+48>>1]|0)|0;u=$(d[h+8>>0]|0,k<<16>>16)|0;j=A+v|0;z=u+y|0;q=(z+j|0)*4816|0;s=q+($(u+v|0,-3685)|0)|0;q=q+($(A+y|0,-10497)|0)|0;j=$(j,-8034)|0;z=$(z,-1597)|0;u=z+(u*6149|0)+s|0;k=j+(A*12586|0)+q|0;q=z+(y*8410|0)+q|0;s=j+(v*1223|0)+s|0;v=r+512+w|0;j=p+512+x|0;p=x-p+512|0;r=w-r+512|0;c[m>>2]=u+v>>10;c[m+224>>2]=v-u>>10;c[m+32>>2]=k+j>>10;c[m+192>>2]=j-k>>10;c[m+64>>2]=q+p>>10;c[m+160>>2]=p-q>>10;c[m+96>>2]=s+r>>10;c[m+128>>2]=r-s>>10}l=l+1|0;if((l|0)==8){s=0;break}else{g=g+2|0;h=h+1|0;m=m+4|0}}while(1){r=c[o+8>>2]|0;p=c[o+24>>2]|0;k=(p+r|0)*2217|0;p=k+($(p,-7567)|0)|0;r=k+(r*3135|0)|0;k=c[o>>2]|0;h=c[o+16>>2]|0;g=h+k<<12;h=k-h<<12;k=c[o+28>>2]|0;A=c[o+20>>2]|0;l=c[o+12>>2]|0;j=c[o+4>>2]|0;m=l+k|0;z=j+A|0;n=(z+m|0)*4816|0;q=n+($(j+k|0,-3685)|0)|0;n=n+($(l+A|0,-10497)|0)|0;m=$(m,-8034)|0;z=$(z,-1597)|0;j=z+(j*6149|0)+q|0;l=m+(l*12586|0)+n|0;n=z+(A*8410|0)+n|0;q=m+(k*1223|0)+q|0;k=r+16842752+g|0;m=p+16842752+h|0;p=h-p+16842752|0;r=g-r+16842752|0;g=j+k|0;h=g>>17;if(h>>>0>255)g=~(g>>31&255);else g=h&255;a[e>>0]=g;g=k-j|0;h=g>>17;if(h>>>0>255)g=~(g>>31&255);else g=h&255;a[e+7>>0]=g;g=l+m|0;h=g>>17;if(h>>>0>255)g=~(g>>31&255);else g=h&255;a[e+1>>0]=g;g=m-l|0;h=g>>17;if(h>>>0>255)g=~(g>>31&255);else g=h&255;a[e+6>>0]=g;g=n+p|0;h=g>>17;if(h>>>0>255)g=~(g>>31&255);else g=h&255;a[e+2>>0]=g;g=p-n|0;h=g>>17;if(h>>>0>255)g=~(g>>31&255);else g=h&255;a[e+5>>0]=g;g=q+r|0;h=g>>17;if(h>>>0>255)g=~(g>>31&255);else g=h&255;a[e+3>>0]=g;g=r-q|0;h=g>>17;if(h>>>0>255)g=~(g>>31&255);else g=h&255;a[e+4>>0]=g;s=s+1|0;if((s|0)==8)break;else{e=e+f|0;o=o+32|0}}i=t;return}function Wk(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return b|0}function Xk(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;if((f|0)>0)g=0;else return b|0;do{a[b+g>>0]=((d[e+g>>0]|0)+2+((d[c+g>>0]|0)*3|0)|0)>>>2;g=g+1|0}while((g|0)!=(f|0));return b|0}function Yk(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;g=a[c>>0]|0;if((f|0)==1){a[b+1>>0]=g;a[b>>0]=g;return b|0}a[b>>0]=g;a[b+1>>0]=((d[c+1>>0]|0)+2+((d[c>>0]|0)*3|0)|0)>>>2;e=f+-1|0;if((e|0)>1){g=1;do{i=((d[c+g>>0]|0)*3|0)+2|0;h=g<<1;a[b+h>>0]=(i+(d[c+(g+-1)>>0]|0)|0)>>>2;g=g+1|0;a[b+(h|1)>>0]=(i+(d[c+g>>0]|0)|0)>>>2}while((g|0)!=(e|0));g=e<<1}else g=2;i=c+e|0;a[b+g>>0]=((d[i>>0]|0)+2+((d[c+(f+-2)>>0]|0)*3|0)|0)>>>2;a[b+(g|1)>>0]=a[i>>0]|0;return b|0}function Zk(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;g=((d[c>>0]|0)*3|0)+(d[e>>0]|0)|0;h=(g+2|0)>>>2&255;if((f|0)==1){a[b+1>>0]=h;a[b>>0]=h;return b|0}a[b>>0]=h;if((f|0)>1){i=1;h=g;while(1){g=((d[c+i>>0]|0)*3|0)+(d[e+i>>0]|0)|0;j=i<<1;a[b+(j+-1)>>0]=((h*3|0)+8+g|0)>>>4;a[b+j>>0]=(h+8+(g*3|0)|0)>>>4;i=i+1|0;if((i|0)==(f|0))break;else h=g}}a[b+((f<<1)+-1)>>0]=(g+2|0)>>>2;return b|0}function _k(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;if((e|0)<=0)return b|0;d=(f|0)>0;i=0;do{if(d){g=c+i|0;h=$(i,f)|0;j=0;do{a[b+(j+h)>>0]=a[g>>0]|0;j=j+1|0}while((j|0)!=(f|0))}i=i+1|0}while((i|0)!=(e|0));return b|0}function $k(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if((f|0)==(e|0)){h=b;return h|0}if((f+-1|0)>>>0>=4)Ba(32152,30466,509,32183);l=fo($($(g,f)|0,h)|0)|0;if(!l){go(b);c[5682]=30100;h=0;return h|0}a:do if((h|0)>0){m=(e<<3)+f|0;o=g+-1|0;n=(o|0)>-1;p=0;b:while(1){i=$(p,g)|0;j=b+($(i,e)|0)|0;i=l+($(i,f)|0)|0;do switch(m|0){case 10:{if(n){k=o;while(1){a[i>>0]=a[j>>0]|0;a[i+1>>0]=-1;k=k+-1|0;if((k|0)<=-1)break;else{i=i+2|0;j=j+1|0}}}break}case 11:{if(n){k=o;while(1){q=a[j>>0]|0;a[i+2>>0]=q;a[i+1>>0]=q;a[i>>0]=q;k=k+-1|0;if((k|0)<=-1)break;else{i=i+3|0;j=j+1|0}}}break}case 12:{if(n){k=o;while(1){q=a[j>>0]|0;a[i+2>>0]=q;a[i+1>>0]=q;a[i>>0]=q;a[i+3>>0]=-1;k=k+-1|0;if((k|0)<=-1)break;else{i=i+4|0;j=j+1|0}}}break}case 17:{if(n){k=o;while(1){a[i>>0]=a[j>>0]|0;k=k+-1|0;if((k|0)<=-1)break;else{i=i+1|0;j=j+2|0}}}break}case 19:{if(n){k=o;while(1){q=a[j>>0]|0;a[i+2>>0]=q;a[i+1>>0]=q;a[i>>0]=q;k=k+-1|0;if((k|0)<=-1)break;else{i=i+3|0;j=j+2|0}}}break}case 20:{if(n){k=o;while(1){q=a[j>>0]|0;a[i+2>>0]=q;a[i+1>>0]=q;a[i>>0]=q;a[i+3>>0]=a[j+1>>0]|0;k=k+-1|0;if((k|0)<=-1)break;else{i=i+4|0;j=j+2|0}}}break}case 28:{if(n){k=o;while(1){a[i>>0]=a[j>>0]|0;a[i+1>>0]=a[j+1>>0]|0;a[i+2>>0]=a[j+2>>0]|0;a[i+3>>0]=-1;k=k+-1|0;if((k|0)<=-1)break;else{i=i+4|0;j=j+3|0}}}break}case 25:{if(n){k=o;while(1){a[i>>0]=(((d[j+1>>0]|0)*150|0)+((d[j>>0]|0)*77|0)+((d[j+2>>0]|0)*29|0)|0)>>>8;k=k+-1|0;if((k|0)<=-1)break;else{i=i+1|0;j=j+3|0}}}break}case 26:{if(n){k=o;while(1){a[i>>0]=(((d[j+1>>0]|0)*150|0)+((d[j>>0]|0)*77|0)+((d[j+2>>0]|0)*29|0)|0)>>>8;a[i+1>>0]=-1;k=k+-1|0;if((k|0)<=-1)break;else{i=i+2|0;j=j+3|0}}}break}case 33:{if(n){k=o;while(1){a[i>>0]=(((d[j+1>>0]|0)*150|0)+((d[j>>0]|0)*77|0)+((d[j+2>>0]|0)*29|0)|0)>>>8;k=k+-1|0;if((k|0)<=-1)break;else{i=i+1|0;j=j+4|0}}}break}case 34:{if(n){k=o;while(1){a[i>>0]=(((d[j+1>>0]|0)*150|0)+((d[j>>0]|0)*77|0)+((d[j+2>>0]|0)*29|0)|0)>>>8;a[i+1>>0]=a[j+3>>0]|0;k=k+-1|0;if((k|0)<=-1)break;else{i=i+2|0;j=j+4|0}}}break}case 35:{if(n){k=o;while(1){a[i>>0]=a[j>>0]|0;a[i+1>>0]=a[j+1>>0]|0;a[i+2>>0]=a[j+2>>0]|0;k=k+-1|0;if((k|0)<=-1)break;else{i=i+3|0;j=j+4|0}}}break}default:break b}while(0);p=p+1|0;if((p|0)>=(h|0))break a}Ba(32198,30466,538,32183)}while(0);go(b);q=l;return q|0}function al(e,f){e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=f&65535;f=b[e+2080+(h<<2)>>1]|0;if(f<<16>>16>-1)al(e,f);n=e+18500|0;g=c[n>>2]|0;m=e+18492|0;if((g|0)>=(c[m>>2]|0))return;l=e+18496|0;f=c[l>>2]|0;j=f+g|0;k=c[e+8>>2]|0;g=d[e+2080+(h<<2)+3>>0]<<2;h=c[e+18464>>2]|0;i=h+(g|3)|0;if((a[i>>0]|0)<0){a[k+j>>0]=a[h+(g|2)>>0]|0;a[k+(j+1)>>0]=a[h+(g|1)>>0]|0;a[k+(j+2)>>0]=a[h+g>>0]|0;a[k+(j+3)>>0]=a[i>>0]|0;f=c[l>>2]|0}k=f+4|0;c[l>>2]=k;if((k|0)<(c[e+18488>>2]|0))return;c[l>>2]=c[e+18480>>2];j=e+18472|0;l=(c[n>>2]|0)+(c[j>>2]|0)|0;c[n>>2]=l;k=e+18468|0;h=c[m>>2]|0;if((l|0)<(h|0))return;i=e+18504|0;f=e+18484|0;g=c[k>>2]|0;while(1){if((g|0)<=0){f=11;break}e=c[i>>2]<<g;c[j>>2]=e;e=(e>>1)+(c[f>>2]|0)|0;c[n>>2]=e;g=g+-1|0;c[k>>2]=g;if((e|0)<(h|0)){f=11;break}}if((f|0)==11)return}function bl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=b+16|0;g=b+168|0;h=b+172|0;i=b+24|0;j=b+28|0;k=b+32|0;do if(!(d&128))l=8;else{if(c[f>>2]|0){if(rd[c[i>>2]&63](c[j>>2]|0)|0)if(!(c[k>>2]|0))break;else l=5}else l=5;if((l|0)==5?(c[g>>2]|0)>>>0>=(c[h>>2]|0)>>>0:0)break;a[e>>0]=cl(b)|0;l=8}while(0);do if((l|0)==8){if(d&64){if(c[f>>2]|0){if(rd[c[i>>2]&63](c[j>>2]|0)|0)if(!(c[k>>2]|0))break;else l=13}else l=13;if((l|0)==13?(c[g>>2]|0)>>>0>=(c[h>>2]|0)>>>0:0)break;a[e+1>>0]=cl(b)|0}if(d&32){if(c[f>>2]|0){if(rd[c[i>>2]&63](c[j>>2]|0)|0)if(!(c[k>>2]|0))break;else l=19}else l=19;if((l|0)==19?(c[g>>2]|0)>>>0>=(c[h>>2]|0)>>>0:0)break;a[e+2>>0]=cl(b)|0}if(!(d&16)){l=e;return l|0}if(c[f>>2]|0){if(rd[c[i>>2]&63](c[j>>2]|0)|0)if(!(c[k>>2]|0))break;else l=25}else l=25;if((l|0)==25?(c[g>>2]|0)>>>0>=(c[h>>2]|0)>>>0:0)break;a[e+3>>0]=cl(b)|0;l=e;return l|0}while(0);c[5682]=32120;l=0;return l|0}function cl(b){b=b|0;var e=0,f=0,g=0,h=0,i=0;i=b+168|0;e=c[i>>2]|0;h=b+172|0;if(e>>>0<(c[h>>2]|0)>>>0){c[i>>2]=e+1;i=d[e>>0]|0;i=i&255;return i|0}g=b+32|0;if(!(c[g>>2]|0)){i=0;i=i&255;return i|0}e=b+40|0;f=jd[c[b+16>>2]&15](c[b+28>>2]|0,e,c[b+36>>2]|0)|0;if(!f){c[g>>2]=0;e=(c[h>>2]|0)+-1|0;c[i>>2]=e;a[e>>0]=0;e=c[i>>2]|0}else{c[i>>2]=e;c[h>>2]=b+40+f}c[i>>2]=e+1;i=d[e>>0]|0;i=i&255;return i|0}function dl(b,f){b=b|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=b+13952|0;a:do if((c[o>>2]|0)<16){n=b+13960|0;j=b+13948|0;b:while(1){c:do if(!(c[n>>2]|0)){l=c[b>>2]|0;m=l+168|0;g=c[m>>2]|0;k=l+172|0;do if(g>>>0>=(c[k>>2]|0)>>>0){h=l+32|0;if(!(c[h>>2]|0)){g=0;break c}g=l+40|0;i=jd[c[l+16>>2]&15](c[l+28>>2]|0,g,c[l+36>>2]|0)|0;if(!i){c[h>>2]=0;g=(c[k>>2]|0)+-1|0;c[m>>2]=g;a[g>>0]=0;g=c[m>>2]|0;break}else{c[m>>2]=g;c[k>>2]=l+40+i;break}}while(0);c[m>>2]=g+1;m=a[g>>0]|0;g=m&255;if(m<<24>>24==-1){k=c[b>>2]|0;m=k+168|0;g=c[m>>2]|0;l=k+172|0;do if(g>>>0>=(c[l>>2]|0)>>>0){h=k+32|0;if(!(c[h>>2]|0)){g=255;break c}g=k+40|0;i=jd[c[k+16>>2]&15](c[k+28>>2]|0,g,c[k+36>>2]|0)|0;if(!i){c[h>>2]=0;g=(c[l>>2]|0)+-1|0;c[m>>2]=g;a[g>>0]=0;g=c[m>>2]|0;break}else{c[m>>2]=g;c[l>>2]=k+40+i;break}}while(0);c[m>>2]=g+1;g=a[g>>0]|0;if(!(g<<24>>24))g=255;else break b}}else g=0;while(0);m=c[o>>2]|0;c[j>>2]=g<<24-m|c[j>>2];m=m+8|0;c[o>>2]=m;if((m|0)>=25)break a}a[b+13956>>0]=g;c[n>>2]=1}else j=b+13948|0;while(0);k=c[j>>2]|0;b=a[f+(k>>>23)>>0]|0;g=b&255;if(b<<24>>24!=-1){h=d[f+1280+g>>0]|0;i=c[o>>2]|0;if((i|0)<(h|0)){f=-1;return f|0}c[j>>2]=k<<h;c[o>>2]=i-h;f=d[f+1024+g>>0]|0;return f|0}g=k>>>16;h=10;while(1)if(g>>>0<(c[f+1540+(h<<2)>>2]|0)>>>0)break;else h=h+1|0;g=c[o>>2]|0;if((h|0)==17){c[o>>2]=g+-16;f=-1;return f|0}if((g|0)<(h|0)){f=-1;return f|0}i=(k>>>(32-h|0)&c[23364+(h<<2)>>2])+(c[f+1612+(h<<2)>>2]|0)|0;b=d[f+1280+i>>0]|0;if((k>>>(32-b|0)&c[23364+(b<<2)>>2]|0)!=(e[f+512+(i<<1)>>1]|0|0))Ba(32200,30466,775,32276);c[o>>2]=g-h;c[j>>2]=k<<h;f=d[f+1024+i>>0]|0;return f|0}function el(a){a=a|0;return ho(a,1)|0}function fl(a){a=a|0;go(a);return}function gl(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;if((a[b>>0]|0)!=47)b=Yj(b)|0;if((e|0)<0)b=Qm(b,32283)|0;else b=Qm(b,32286)|0;if(!b){e=-1;return e|0}if((e|0)>-1)Xm(b,e,0)|0;e=an(c,1,d,b)|0;Nm(b)|0;return e|0}function hl(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if(!(a[c>>0]|0)){c=0;return c|0}d=a[b>>0]|0;if(!(d<<24>>24)){c=0;return c|0}a:while(1){g=b;h=c;while(1){e=a[h>>0]|0;if(!(e<<24>>24)){d=11;break a}f=a[g>>0]|0;if(!(f<<24>>24))break;if(e<<24>>24==f<<24>>24){g=g+1|0;h=h+1|0}else break}b=b+1|0;if(d<<24>>24<0)while(1){d=a[b>>0]|0;if(d<<24>>24!=0&(d&-64)<<24>>24==-128)b=b+1|0;else break}else d=a[b>>0]|0;if(!(d<<24>>24)){b=0;d=11;break}}if((d|0)==11)return b|0;return 0}function il(b,c){b=b|0;c=c|0;var d=0,e=0;d=a[b>>0]|0;if(!(d<<24>>24)){e=0;return e|0}e=c<<24>>24;d=d&255;c=0;while(1){c=(d|0)==(e|0)?b:c;b=b+1|0;if(!(d&128))d=a[b>>0]|0;else while(1){d=a[b>>0]|0;if(d<<24>>24!=0&(d&-64)<<24>>24==-128)b=b+1|0;else break}if(!(d<<24>>24))break;else d=d&255}return c|0}function jl(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+1536|0;n=q+1280|0;o=q+1024|0;k=q+768|0;j=q+512|0;m=q+256|0;l=q;if((d&16|0)!=0?(e=a[b>>0]|0,e<<24>>24!=0):0){g=b;while(1){a[g>>0]=nm(e&255)|0;f=g+1|0;if((e&255)>128)f=(e+96&255)>63?g+2|0:f;e=a[f>>0]|0;if(!(e<<24>>24))break;else g=f}}a[k>>0]=0;Kn(n,b)|0;e=a[n>>0]|0;if(e<<24>>24){g=e&255;h=n;f=0;while(1){f=(g|0)==46?h:f;h=h+1|0;if(!(g&128))g=a[h>>0]|0;else while(1){g=a[h>>0]|0;if(g<<24>>24!=0&(g&-64)<<24>>24==-128)h=h+1|0;else break}if(!(g<<24>>24))break;else g=g&255}if(f){Kn(l,f)|0;a[f>>0]=0;e=a[n>>0]|0}else p=13}else p=13;if((p|0)==13)a[l>>0]=0;if(e<<24>>24){f=e&255;g=n;e=0;while(1){e=(f|0)==47?g:e;g=g+1|0;if(!(f&128))f=a[g>>0]|0;else while(1){f=a[g>>0]|0;if(f<<24>>24!=0&(f&-64)<<24>>24==-128)g=g+1|0;else break}if(!(f<<24>>24))break;else f=f&255}if(e){h=e+1|0;Kn(m,h)|0;a[h>>0]=0;Kn(j,n)|0}else p=22}else p=22;if((p|0)==22){a[j>>0]=0;Kn(m,n)|0}Gn(k,j)|0;do if(!(d&8))if(!(d&32)){Kn(o,b)|0;break}else{Kn(o,k)|0;break}else{Kn(o,m)|0;Gn(o,l)|0}while(0);switch(d&7|0){case 1:{a[b+((Mn(o)|0)-(Mn(l)|0))>>0]=0;Kn(c,o)|0;i=q;return}case 2:{Kn(c,l)|0;i=q;return}default:{Kn(c,o)|0;i=q;return}}}function kl(a){a=a|0;return Lm(a,493)|0}function ll(a){a=a|0;return Rn(a)|0}function ml(a){a=a|0;return Un(a)|0}function nl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=i;i=i+336|0;m=p;o=p+76|0;Tn(o,256)|0;o=pm(o)|0;f=qm(o)|0;if(!f){n=0;om(o)|0;i=p;return n|0}k=(e&4|0)==0;l=m+12|0;if(!e){j=f;f=0;do{h=j+11|0;m=a[h>>0]|0;g=m<<24>>24!=0&1;if(m<<24>>24==46){m=a[j+12>>0]|0;g=m<<24>>24==0?0:g;if(!(m<<24>>24==46?(a[j+13>>0]|0)==0:0))n=21}else n=21;if((n|0)==21){n=0;if((g|0)!=0?(Bl(h,b)|0)!=0:0){Ki(d,h);Ki(d,32290);f=f+1|0}}j=qm(o)|0}while((j|0)!=0);om(o)|0;i=p;return f|0}else{h=f;f=0}do{j=h+11|0;q=a[j>>0]|0;g=q<<24>>24!=0&1;if(q<<24>>24==46){q=a[h+12>>0]|0;g=q<<24>>24==0?0:g;if(!(q<<24>>24==46?(a[h+13>>0]|0)==0:0))n=6}else n=6;do if((n|0)==6){n=0;if((g|0)==1){Mm(j,m)|0;if(!k)if((c[l>>2]&61440|0)==32768?(a[j>>0]|0)!=46:0)break;else g=3;else g=0;h=g^e;if(!(h&1))g=1;else g=(c[l>>2]&61440|0)!=16384&1;if((h&2|0)!=0?(a[j>>0]|0)==46:0)break}if((g|0)!=0?(Bl(j,b)|0)!=0:0){Ki(d,j);Ki(d,32290);f=f+1|0}}while(0);h=qm(o)|0}while((h|0)!=0);om(o)|0;i=p;return f|0}function ol(a){a=a|0;var b=0,d=0,e=0;e=i;i=i+16|0;d=e;Gb(d|0,0)|0;b=vc(d|0)|0;switch(a|0){case 0:{b=(c[b+20>>2]|0)+1900|0;break}case 1:{b=(c[b+16>>2]|0)+1|0;break}case 2:{b=c[b+24>>2]|0;break}case 3:{b=c[b+12>>2]|0;break}case 4:{b=c[b+8>>2]|0;break}case 5:{b=c[b+4>>2]|0;break}case 6:{b=c[b>>2]|0;break}case 7:{b=(c[d+4>>2]|0)/1e4|0;break}case 8:{b=(c[d+4>>2]|0)%1e4|0;break}default:b=0}i=e;return b|0}function pl(){c[5858]=0;return}function ql(){return c[5858]|0}function rl(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;k=e<<24>>24;g=0;a:do{i=c[5858]|0;e=a[b+i>>0]|0;j=e&255;if(!(e<<24>>24)){e=0;break}h=i+1|0;c[5858]=h;if((j|0)==(k|0))break;switch(e<<24>>24){case 10:{e=10;break a}case 13:{e=g;l=5;break a}default:{}}h=g+1|0;a[d+g>>0]=e;if(j&128){g=c[5858]|0;e=a[b+g>>0]|0;if(e<<24>>24!=0&(e&-64)<<24>>24==-128){i=g;while(1){c[5858]=i+1;g=h+1|0;a[d+h>>0]=e;i=c[5858]|0;e=a[b+i>>0]|0;if(!(e<<24>>24!=0&(e&-64)<<24>>24==-128))break;else h=g}}else g=h}else g=h}while((g|0)<(f|0));if((l|0)==5)if((a[b+h>>0]|0)==10){c[5858]=i+2;g=e;e=13}else{g=e;e=13}a[d+g>>0]=0;return e&255|0}function sl(a,b,c){a=a|0;b=b|0;c=c|0;return ((a|0)>(c|0)?c:(a|0)<(b|0)?b:a)|0}function tl(b){b=b|0;var c=0,d=0,e=0,f=0;c=a[b>>0]|0;if(!(c<<24>>24)){b=0;return b|0}else{d=c;c=0;f=0}do{f=f+1|0;e=(nm(d<<24>>24)|0)<<24;d=e>>24;if((e+-788529153|0)>>>0<184549375)d=d+-48|0;else d=(e+-1610612737|0)>>>0<117440511?d+-87|0:0;c=d+(c<<4)|0;d=a[b+f>>0]|0}while(d<<24>>24!=0);return c|0}function ul(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;d=a[b>>0]|0;if(!(d<<24>>24))return;k=c&255;j=Mn(b)|0;while(1){i=0;g=d&255;h=b;c=0;while(1){d=h+1|0;if(!(g&128)){f=a[d>>0]|0;e=d}else{e=d;while(1){d=a[e>>0]|0;if(d<<24>>24!=0&(d&-64)<<24>>24==-128)e=e+1|0;else{f=d;break}}}g=(g|0)!=(k|0)|(h|0)==0;d=g?i:h;c=g?c:e;if(!(f<<24>>24))break;else{i=d;g=f&255;h=e}}if(!((d|0)!=0&(c|0)==(b+j|0))){c=10;break}a[d>>0]=0;j=Mn(b)|0;d=a[b>>0]|0;if(!(d<<24>>24)){c=10;break}}if((c|0)==10)return}function vl(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=a[b>>0]|0;if(!(d<<24>>24))return;g=c&255;a:while(1){e=d&255;c=b;while(1){d=c+1|0;if(!(e&128))f=d;else while(1){f=a[d>>0]|0;if(f<<24>>24!=0&(f&-64)<<24>>24==-128)d=d+1|0;else{f=d;break}}if(!((e|0)!=(g|0)|(c|0)==0)){d=f;break}d=a[f>>0]|0;if(!(d<<24>>24)){d=9;break a}else{e=d&255;c=f}}Kn(c,d)|0;d=a[b>>0]|0;if(!(d<<24>>24)){d=9;break}}if((d|0)==9)return}function wl(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=a[b>>0]|0;if(!(d<<24>>24))return;e=c&255;f=b+1|0;c=d;while(1){c=c&255;d=(c|0)==(e|0)?b:0;if(!(c&128))c=f;else{c=f;while(1){g=a[c>>0]|0;if(g<<24>>24!=0&(g&-64)<<24>>24==-128)c=c+1|0;else break}}if(!d){c=7;break}Kn(d,c)|0;c=a[b>>0]|0;if(!(c<<24>>24)){c=7;break}}if((c|0)==7)return}function xl(b,d){b=b|0;d=d|0;c[5859]=b;b=(Mn(b)|0)+16384|0;b=(b|0)<32768?32768:b;c[5860]=b;b=Fi(b)|0;c[5861]=b;a[b>>0]=0;b=Mn(d)|0;c[5862]=b;b=Fi(b+1|0)|0;c[5863]=b;so(b|0,d|0,(c[5862]|0)+1|0)|0;return}function yl(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c[5864]=b;c[5865]=Mn(b)|0;c[5866]=0;d=c[5859]|0;j=a[c[5863]>>0]|0;b=a[d>>0]|0;if(!(b<<24>>24)){k=0;j=c[5861]|0;k=j+k|0;a[k>>0]=0;k=c[5861]|0;return k|0}else{i=b;h=0}while(1){if(i<<24>>24==j<<24>>24){g=c[5862]|0;e=(Dn(d,c[5863]|0,g)|0)==0;f=e?c[5865]|0:1;g=e?g:0}else{f=1;g=0}b=f+h|0;e=c[5860]|0;if((b|0)>=(e|0)){e=e+32768|0;c[5860]=e;c[5861]=Ii(c[5861]|0,e)|0}if(!g){b=h+1|0;a[(c[5861]|0)+h>>0]=i;d=d+1|0;if(i<<24>>24<0?(k=a[d>>0]|0,k<<24>>24!=0&(k&-64)<<24>>24==-128):0){f=k;while(1){d=d+1|0;e=b+1|0;a[(c[5861]|0)+b>>0]=f;f=a[d>>0]|0;if(!(f<<24>>24!=0&(f&-64)<<24>>24==-128)){b=e;break}else b=e}}}else{so((c[5861]|0)+h|0,c[5864]|0,f|0)|0;c[5866]=(c[5866]|0)+1;d=d+g|0}i=a[d>>0]|0;if(!(i<<24>>24))break;else h=b}k=c[5861]|0;k=k+b|0;a[k>>0]=0;k=c[5861]|0;return k|0}function zl(){Hi(c[5863]|0);Hi(c[5861]|0);return c[5866]|0}function Al(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+4112|0;e=d+16|0;f=d;c[f>>2]=b;kn(e,a,f)|0;Lb(6,e|0)|0;i=d;return}function Bl(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=b;a:while(1){i=a[c>>0]|0;c=c+1|0;if(!(i<<24>>24)){b=a[d>>0]|0;if(!(b<<24>>24)){b=1;c=13;break}}else{g=i<<24>>24==42;f=a[d>>0]|0;e=f<<24>>24==0;if(g){b=a[c>>0]|0;h=b<<24>>24==42&1;while(1){if(e){c=7;break a}if((b<<24>>24==f<<24>>24|h|0)!=0?(Bl(d,c)|0)!=0:0){b=1;c=13;break a}d=d+1|0;f=a[d>>0]|0;e=f<<24>>24==0;if(!g){b=f;break}}}else b=f;if(e){b=0;c=13;break}}if(i<<24>>24!=b<<24>>24){b=0;c=13;break}else d=d+1|0}if((c|0)==7)return b<<24>>24==0|0;else if((c|0)==13)return b|0;return 0}function Cl(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+16|0;c[d>>2]=b;b=c[5915]|0;hn(b,a,d)|0;Sm(10,b)|0;sc()}function Dl(){var a=0,b=0;a=i;i=i+16|0;if(!(_b(23608,8)|0)){b=fc(c[5901]|0)|0;i=a;return b|0}else Cl(32578,a);return 0}function El(a){a=a|0;var b=0;b=(a|0)==0?1:a;a=fo(b)|0;a:do if(!a){while(1){a=Nl()|0;if(!a)break;td[a&15]();a=fo(b)|0;if(a)break a}b=Rb(4)|0;c[b>>2]=23480;ad(b|0,208,1)}while(0);return a|0}function Fl(a){a=a|0;return El(a)|0}function Gl(a){a=a|0;go(a);return}function Hl(a){a=a|0;Gl(a);return}function Il(a){a=a|0;return}function Jl(a){a=a|0;Gl(a);return}function Kl(a){a=a|0;return 32627}function Ll(a){a=a|0;var b=0;b=i;i=i+16|0;o=0;oa(a|0);a=o;o=0;if(!(a&1)){o=0;la(41,32642,b|0);o=0}a=kb(0)|0;ec(a|0)|0;o=0;la(41,32682,b+8|0);o=0;a=kb(0)|0;o=0;oa(9);b=o;o=0;if(b&1){b=kb(0)|0;Ff(b)}else Ff(a)}function Ml(){var a=0,b=0,d=0;o=0;a=ia(10)|0;d=o;o=0;if(d&1){d=kb(0)|0;Ff(d)}if(((a|0)!=0?(b=c[a>>2]|0,(b|0)!=0):0)?(d=b+48|0,(c[d>>2]&-256|0)==1126902528?(c[d+4>>2]|0)==1129074247:0):0)Ll(c[b+12>>2]|0);d=c[5867]|0;c[5867]=d+0;Ll(d)}function Nl(){var a=0;a=c[5873]|0;c[5873]=a+0;return a|0}function Ol(a){a=a|0;return}function Pl(a){a=a|0;return}function Ql(a){a=a|0;return}function Rl(a){a=a|0;return}function Sl(a){a=a|0;return}function Tl(a){a=a|0;Gl(a);return}function Ul(a){a=a|0;Gl(a);return}function Vl(a){a=a|0;Gl(a);return}function Wl(a,b,c){a=a|0;b=b|0;c=c|0;return (a|0)==(b|0)|0}function Xl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;i=i+64|0;g=h;if((a|0)!=(b|0))if((b|0)!=0?(f=$l(b,240,256,0)|0,(f|0)!=0):0){b=g;e=b+56|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(e|0));c[g>>2]=f;c[g+8>>2]=a;c[g+12>>2]=-1;c[g+48>>2]=1;yd[c[(c[f>>2]|0)+28>>2]&7](f,g,c[d>>2]|0,1);if((c[g+24>>2]|0)==1){c[d>>2]=c[g+16>>2];b=1}else b=0}else b=0;else b=1;i=h;return b|0}function Yl(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;b=d+16|0;g=c[b>>2]|0;do if(g){if((g|0)!=(e|0)){f=d+36|0;c[f>>2]=(c[f>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;break}b=d+24|0;if((c[b>>2]|0)==2)c[b>>2]=f}else{c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1}while(0);return}function Zl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((a|0)==(c[b+8>>2]|0))Yl(0,b,d,e);return}function _l(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((a|0)==(c[b+8>>2]|0))Yl(0,b,d,e);else{a=c[a+8>>2]|0;yd[c[(c[a>>2]|0)+28>>2]&7](a,b,d,e)}return}function $l(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+64|0;q=r;p=c[d>>2]|0;o=d+(c[p+-8>>2]|0)|0;p=c[p+-4>>2]|0;c[q>>2]=f;c[q+4>>2]=d;c[q+8>>2]=e;c[q+12>>2]=g;g=q+16|0;d=q+20|0;e=q+24|0;h=q+28|0;j=q+32|0;k=q+40|0;l=(p|0)==(f|0);m=g;n=m+36|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(n|0));b[g+36>>1]=0;a[g+38>>0]=0;a:do if(l){c[q+48>>2]=1;vd[c[(c[f>>2]|0)+20>>2]&3](f,q,o,o,1,0);g=(c[e>>2]|0)==1?o:0}else{md[c[(c[p>>2]|0)+24>>2]&3](p,q,o,1,0);switch(c[q+36>>2]|0){case 0:{g=(c[k>>2]|0)==1&(c[h>>2]|0)==1&(c[j>>2]|0)==1?c[d>>2]|0:0;break a}case 1:break;default:{g=0;break a}}if((c[e>>2]|0)!=1?!((c[k>>2]|0)==0&(c[h>>2]|0)==1&(c[j>>2]|0)==1):0){g=0;break}g=c[g>>2]|0}while(0);i=r;return g|0}function am(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;a[d+53>>0]=1;do if((c[d+4>>2]|0)==(f|0)){a[d+52>>0]=1;f=d+16|0;b=c[f>>2]|0;if(!b){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((g|0)==1?(c[d+48>>2]|0)==1:0))break;a[d+54>>0]=1;break}if((b|0)!=(e|0)){g=d+36|0;c[g>>2]=(c[g>>2]|0)+1;a[d+54>>0]=1;break}b=d+24|0;f=c[b>>2]|0;if((f|0)==2){c[b>>2]=g;f=g}if((f|0)==1?(c[d+48>>2]|0)==1:0)a[d+54>>0]=1}while(0);return}function bm(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;a:do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(h=d+28|0,(c[h>>2]|0)!=1):0)c[h>>2]=f}else{if((b|0)!=(c[d>>2]|0)){j=c[b+8>>2]|0;md[c[(c[j>>2]|0)+24>>2]&3](j,d,e,f,g);break}if((c[d+16>>2]|0)!=(e|0)?(i=d+20|0,(c[i>>2]|0)!=(e|0)):0){c[d+32>>2]=f;f=d+44|0;if((c[f>>2]|0)==4)break;h=d+52|0;a[h>>0]=0;k=d+53|0;a[k>>0]=0;b=c[b+8>>2]|0;vd[c[(c[b>>2]|0)+20>>2]&3](b,d,e,e,1,g);if(a[k>>0]|0){if(!(a[h>>0]|0)){h=1;j=13}}else{h=0;j=13}do if((j|0)==13){c[i>>2]=e;k=d+40|0;c[k>>2]=(c[k>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(h)break}else j=16;if((j|0)==16?h:0)break;c[f>>2]=4;break a}while(0);c[f>>2]=3;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function cm(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(i=d+28|0,(c[i>>2]|0)!=1):0)c[i>>2]=f}else if((b|0)==(c[d>>2]|0)){if((c[d+16>>2]|0)!=(e|0)?(h=d+20|0,(c[h>>2]|0)!=(e|0)):0){c[d+32>>2]=f;c[h>>2]=e;g=d+40|0;c[g>>2]=(c[g>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0)a[d+54>>0]=1;c[d+44>>2]=4;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function dm(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((a|0)==(c[b+8>>2]|0))am(0,b,d,e,f);else{a=c[a+8>>2]|0;vd[c[(c[a>>2]|0)+20>>2]&3](a,b,d,e,f,g)}return}function em(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((a|0)==(c[b+8>>2]|0))am(0,b,d,e,f);return}function fm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;i=i+16|0;e=f;c[e>>2]=c[d>>2];a=jd[c[(c[a>>2]|0)+16>>2]&15](a,b,e)|0;if(a)c[d>>2]=c[e>>2];i=f;return a&1|0}function gm(a){a=a|0;if(!a)a=0;else a=($l(a,240,288,0)|0)!=0;return a&1|0}function hm(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0;f=i;i=i+48|0;h=f+32|0;d=f+24|0;j=f+16|0;g=f;f=f+36|0;a=Dl()|0;if((a|0)!=0?(e=c[a>>2]|0,(e|0)!=0):0){a=e+48|0;b=c[a>>2]|0;a=c[a+4>>2]|0;if(!((b&-256|0)==1126902528&(a|0)==1129074247)){c[d>>2]=c[5903];Cl(33032,d)}if((b|0)==1126902529&(a|0)==1129074247)a=c[e+44>>2]|0;else a=e+80|0;c[f>>2]=a;e=c[e>>2]|0;a=c[e+4>>2]|0;if(jd[c[(c[224>>2]|0)+16>>2]&15](224,e,f)|0){j=c[f>>2]|0;f=c[5903]|0;j=rd[c[(c[j>>2]|0)+8>>2]&63](j)|0;c[g>>2]=f;c[g+4>>2]=a;c[g+8>>2]=j;Cl(32946,g)}else{c[j>>2]=c[5903];c[j+4>>2]=a;Cl(32991,j)}}Cl(33070,h)}function im(){var a=0;a=i;i=i+16|0;if(!(za(23604,35)|0)){i=a;return}else Cl(32732,a)}function jm(a){a=a|0;var b=0;b=i;i=i+16|0;go(a);if(!($c(c[5901]|0,0)|0)){i=b;return}else Cl(32782,b)}function km(a){a=a|0;Ba(32835,32864,1164,32925)}function lm(a){a=a|0;return ((a|0)==32|(a+-9|0)>>>0<5)&1|0}function mm(a){a=a|0;return (a+-65|0)>>>0<26|0}function nm(a){a=a|0;var b=0;b=(mm(a)|0)==0;return (b?a:a|32)|0}function om(a){a=a|0;var b=0;b=Sn(c[a>>2]|0)|0;go(a);return b|0}function pm(a){a=a|0;var b=0,d=0,e=0;e=i;i=i+16|0;d=e+8|0;b=tm(a,589824,e)|0;do if((b|0)>=0){a=ho(1,2072)|0;if(!a){c[d>>2]=b;Cb(6,d|0)|0;a=0;break}else{c[a>>2]=b;break}}else a=0;while(0);i=e;return a|0}function qm(a){a=a|0;var b=0,d=0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;d=j;g=a+8|0;b=c[g>>2]|0;f=a+12|0;do if((b|0)>=(c[f>>2]|0)){c[d>>2]=c[a>>2];c[d+4>>2]=a+24;c[d+8>>2]=2048;b=xa(220,d|0)|0;if((b|0)>=1){c[f>>2]=b;c[g>>2]=0;b=0;h=6;break}if((b|0)<0&(b|0)!=-2){c[(sm()|0)>>2]=0-b;b=0}else b=0}else h=6;while(0);if((h|0)==6){c[g>>2]=(e[b+8+(a+24)>>1]|0)+b;c[a+4>>2]=c[b+4+(a+24)>>2];b=a+24+b|0}i=j;return b|0}function rm(b){b=b|0;var c=0,e=0;c=0;while(1){if((d[33091+c>>0]|0)==(b|0)){e=2;break}c=c+1|0;if((c|0)==87){c=87;b=33179;e=5;break}}if((e|0)==2)if(!c)b=33179;else{b=33179;e=5}if((e|0)==5)while(1){e=b;while(1){b=e+1|0;if(!(a[e>>0]|0))break;else e=b}c=c+-1|0;if(!c)break;else e=5}return b|0}function sm(){var a=0;if(!(c[5904]|0))a=23676;else a=c[(Uc()|0)+60>>2]|0;return a|0}function tm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+32|0;f=e;g=e+16|0;c[g>>2]=d;h=(c[g>>2]|0)+(4-1)&~(4-1);d=c[h>>2]|0;c[g>>2]=h+4;c[f>>2]=a;c[f+4>>2]=b|32768;c[f+8>>2]=d;d=ym(Db(5,f|0)|0)|0;i=e;return d|0}function um(b,e,f){b=b|0;e=e|0;f=f|0;var g=0.0,h=0,j=0.0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0.0,r=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0;L=i;i=i+512|0;H=L;switch(e|0){case 0:{K=24;J=-149;A=4;break}case 1:{K=53;J=-1074;A=4;break}case 2:{K=53;J=-1074;A=4;break}default:g=0.0}a:do if((A|0)==4){E=b+4|0;C=b+100|0;do{e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=xm(b)|0}while((lm(e)|0)!=0);b:do switch(e|0){case 43:case 45:{h=1-(((e|0)==45&1)<<1)|0;e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0;I=h;break b}else{e=xm(b)|0;I=h;break b}}default:I=1}while(0);h=e;e=0;do{if((h|32|0)!=(a[34983+e>>0]|0))break;do if(e>>>0<7){h=c[E>>2]|0;if(h>>>0<(c[C>>2]|0)>>>0){c[E>>2]=h+1;h=d[h>>0]|0;break}else{h=xm(b)|0;break}}while(0);e=e+1|0}while(e>>>0<8);c:do switch(e|0){case 8:break;case 3:{A=23;break}default:{k=(f|0)!=0;if(k&e>>>0>3)if((e|0)==8)break c;else{A=23;break c}d:do if(!e){e=0;do{if((h|32|0)!=(a[37858+e>>0]|0))break d;do if(e>>>0<2){h=c[E>>2]|0;if(h>>>0<(c[C>>2]|0)>>>0){c[E>>2]=h+1;h=d[h>>0]|0;break}else{h=xm(b)|0;break}}while(0);e=e+1|0}while(e>>>0<3)}while(0);switch(e|0){case 3:{e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=xm(b)|0;if((e|0)==40)e=1;else{if(!(c[C>>2]|0)){g=s;break a}c[E>>2]=(c[E>>2]|0)+-1;g=s;break a}while(1){h=c[E>>2]|0;if(h>>>0<(c[C>>2]|0)>>>0){c[E>>2]=h+1;h=d[h>>0]|0}else h=xm(b)|0;if(!((h+-48|0)>>>0<10|(h+-65|0)>>>0<26)?!((h|0)==95|(h+-97|0)>>>0<26):0)break;e=e+1|0}if((h|0)==41){g=s;break a}h=(c[C>>2]|0)==0;if(!h)c[E>>2]=(c[E>>2]|0)+-1;if(!k){c[(sm()|0)>>2]=22;wm(b,0);g=0.0;break a}if(!e){g=s;break a}while(1){e=e+-1|0;if(!h)c[E>>2]=(c[E>>2]|0)+-1;if(!e){g=s;break a}}}case 0:{do if((h|0)==48){e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=xm(b)|0;if((e|32|0)!=120){if(!(c[C>>2]|0)){e=48;break}c[E>>2]=(c[E>>2]|0)+-1;e=48;break}e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0;k=0}else{e=xm(b)|0;k=0}e:while(1){switch(e|0){case 46:{A=74;break e}case 48:break;default:{y=0;l=0;x=0;h=0;n=k;o=0;w=0;m=1.0;k=0;g=0.0;break e}}e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0;k=1;continue}else{e=xm(b)|0;k=1;continue}}if((A|0)==74){e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=xm(b)|0;if((e|0)==48){k=0;h=0;do{e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=xm(b)|0;k=ro(k|0,h|0,-1,-1)|0;h=D}while((e|0)==48);y=0;l=0;x=k;n=1;o=1;w=0;m=1.0;k=0;g=0.0}else{y=0;l=0;x=0;h=0;n=k;o=1;w=0;m=1.0;k=0;g=0.0}}while(1){u=e+-48|0;p=e|32;if(u>>>0>=10){v=(e|0)==46;if(!(v|(p+-97|0)>>>0<6)){p=x;u=y;break}if(v)if(!o){v=l;h=y;u=y;o=1;p=w;j=m}else{p=x;u=y;e=46;break}else A=86}else A=86;if((A|0)==86){A=0;e=(e|0)>57?p+-87|0:u;do if(!((y|0)<0|(y|0)==0&l>>>0<8)){if((y|0)<0|(y|0)==0&l>>>0<14){r=m*.0625;p=w;j=r;g=g+r*+(e|0);break}if((w|0)!=0|(e|0)==0){p=w;j=m}else{p=1;j=m;g=g+m*.5}}else{p=w;j=m;k=e+(k<<4)|0}while(0);l=ro(l|0,y|0,1,0)|0;v=x;u=D;n=1}e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;y=u;x=v;e=d[e>>0]|0;w=p;m=j;continue}else{y=u;x=v;e=xm(b)|0;w=p;m=j;continue}}if(!n){e=(c[C>>2]|0)==0;if(!e)c[E>>2]=(c[E>>2]|0)+-1;if(f){if(!e?(z=c[E>>2]|0,c[E>>2]=z+-1,(o|0)!=0):0)c[E>>2]=z+-2}else wm(b,0);g=+(I|0)*0.0;break a}n=(o|0)==0;o=n?l:p;n=n?u:h;if((u|0)<0|(u|0)==0&l>>>0<8){h=u;do{k=k<<4;l=ro(l|0,h|0,1,0)|0;h=D}while((h|0)<0|(h|0)==0&l>>>0<8)}if((e|32|0)==112){h=Vn(b,f)|0;e=D;if((h|0)==0&(e|0)==-2147483648){if(!f){wm(b,0);g=0.0;break a}if(!(c[C>>2]|0)){h=0;e=0}else{c[E>>2]=(c[E>>2]|0)+-1;h=0;e=0}}}else if(!(c[C>>2]|0)){h=0;e=0}else{c[E>>2]=(c[E>>2]|0)+-1;h=0;e=0}H=wo(o|0,n|0,2)|0;H=ro(H|0,D|0,-32,-1)|0;e=ro(H|0,D|0,h|0,e|0)|0;h=D;if(!k){g=+(I|0)*0.0;break a}if((h|0)>0|(h|0)==0&e>>>0>(0-J|0)>>>0){c[(sm()|0)>>2]=34;g=+(I|0)*17976931348623157.0e292*17976931348623157.0e292;break a}H=J+-106|0;G=((H|0)<0)<<31>>31;if((h|0)<(G|0)|(h|0)==(G|0)&e>>>0<H>>>0){c[(sm()|0)>>2]=34;g=+(I|0)*2.2250738585072014e-308*2.2250738585072014e-308;break a}if((k|0)>-1){do{G=!(g>=.5);H=G&1|k<<1;k=H^1;g=g+(G?g:g+-1.0);e=ro(e|0,h|0,-1,-1)|0;h=D}while((H|0)>-1);l=e;m=g}else{l=e;m=g}e=qo(32,0,J|0,((J|0)<0)<<31>>31|0)|0;e=ro(l|0,h|0,e|0,D|0)|0;J=D;if(0>(J|0)|0==(J|0)&K>>>0>e>>>0)if((e|0)<0){e=0;A=127}else A=125;else{e=K;A=125}if((A|0)==125)if((e|0)<53)A=127;else{h=e;j=+(I|0);g=0.0}if((A|0)==127){g=+(I|0);h=e;j=g;g=+Am(+Hm(1.0,84-e|0),g)}K=(k&1|0)==0&(m!=0.0&(h|0)<32);g=j*(K?0.0:m)+(g+j*+(((K&1)+k|0)>>>0))-g;if(!(g!=0.0))c[(sm()|0)>>2]=34;g=+Im(g,l);break a}else e=h;while(0);F=J+K|0;G=0-F|0;k=0;f:while(1){switch(e|0){case 46:{A=138;break f}case 48:break;default:{h=0;p=0;o=0;break f}}e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0;k=1;continue}else{e=xm(b)|0;k=1;continue}}if((A|0)==138){e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=xm(b)|0;if((e|0)==48){h=0;e=0;while(1){h=ro(h|0,e|0,-1,-1)|0;k=D;e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=xm(b)|0;if((e|0)==48)e=k;else{p=k;k=1;o=1;break}}}else{h=0;p=0;o=1}}c[H>>2]=0;n=e+-48|0;l=(e|0)==46;g:do if(l|n>>>0<10){B=H+496|0;y=0;v=0;w=l;A=p;u=k;z=o;k=0;l=0;o=0;h:while(1){do if(w)if(!z){h=y;p=v;z=1}else{p=A;e=y;n=v;break h}else{w=ro(y|0,v|0,1,0)|0;v=D;x=(e|0)!=48;if((l|0)>=125){if(!x){p=A;y=w;break}c[B>>2]=c[B>>2]|1;p=A;y=w;break}p=H+(l<<2)|0;if(k)n=e+-48+((c[p>>2]|0)*10|0)|0;c[p>>2]=n;k=k+1|0;n=(k|0)==9;p=A;y=w;u=1;k=n?0:k;l=(n&1)+l|0;o=x?w:o}while(0);e=c[E>>2]|0;if(e>>>0<(c[C>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=xm(b)|0;n=e+-48|0;w=(e|0)==46;if(!(w|n>>>0<10)){n=z;A=161;break g}else A=p}u=(u|0)!=0;A=169}else{y=0;v=0;u=k;n=o;k=0;l=0;o=0;A=161}while(0);do if((A|0)==161){B=(n|0)==0;h=B?y:h;p=B?v:p;u=(u|0)!=0;if(!((e|32|0)==101&u))if((e|0)>-1){e=y;n=v;A=169;break}else{e=y;n=v;A=171;break}n=Vn(b,f)|0;e=D;if((n|0)==0&(e|0)==-2147483648){if(!f){wm(b,0);g=0.0;break}if(!(c[C>>2]|0)){n=0;e=0}else{c[E>>2]=(c[E>>2]|0)+-1;n=0;e=0}}h=ro(n|0,e|0,h|0,p|0)|0;u=y;p=D;n=v;A=173}while(0);if((A|0)==169)if(c[C>>2]|0){c[E>>2]=(c[E>>2]|0)+-1;if(u){u=e;A=173}else A=172}else A=171;if((A|0)==171)if(u){u=e;A=173}else A=172;do if((A|0)==172){c[(sm()|0)>>2]=22;wm(b,0);g=0.0}else if((A|0)==173){e=c[H>>2]|0;if(!e){g=+(I|0)*0.0;break}if(((n|0)<0|(n|0)==0&u>>>0<10)&((h|0)==(u|0)&(p|0)==(n|0))?K>>>0>30|(e>>>K|0)==0:0){g=+(I|0)*+(e>>>0);break}b=(J|0)/-2|0;E=((b|0)<0)<<31>>31;if((p|0)>(E|0)|(p|0)==(E|0)&h>>>0>b>>>0){c[(sm()|0)>>2]=34;g=+(I|0)*17976931348623157.0e292*17976931348623157.0e292;break}b=J+-106|0;E=((b|0)<0)<<31>>31;if((p|0)<(E|0)|(p|0)==(E|0)&h>>>0<b>>>0){c[(sm()|0)>>2]=34;g=+(I|0)*2.2250738585072014e-308*2.2250738585072014e-308;break}if(k){if((k|0)<9){n=H+(l<<2)|0;e=c[n>>2]|0;do{e=e*10|0;k=k+1|0}while((k|0)!=9);c[n>>2]=e}l=l+1|0}if((o|0)<9?(o|0)<=(h|0)&(h|0)<18:0){if((h|0)==9){g=+(I|0)*+((c[H>>2]|0)>>>0);break}if((h|0)<9){g=+(I|0)*+((c[H>>2]|0)>>>0)/+(c[23680+(8-h<<2)>>2]|0);break}b=K+27+($(h,-3)|0)|0;e=c[H>>2]|0;if((b|0)>30|(e>>>b|0)==0){g=+(I|0)*+(e>>>0)*+(c[23680+(h+-10<<2)>>2]|0);break}}e=(h|0)%9|0;if(!e){k=0;e=0}else{u=(h|0)>-1?e:e+9|0;n=c[23680+(8-u<<2)>>2]|0;if(l){o=1e9/(n|0)|0;k=0;e=0;p=0;do{C=H+(p<<2)|0;E=c[C>>2]|0;b=((E>>>0)/(n>>>0)|0)+e|0;c[C>>2]=b;e=$((E>>>0)%(n>>>0)|0,o)|0;b=(p|0)==(k|0)&(b|0)==0;p=p+1|0;h=b?h+-9|0:h;k=b?p&127:k}while((p|0)!=(l|0));if(e){c[H+(l<<2)>>2]=e;l=l+1|0}}else{k=0;l=0}e=0;h=9-u+h|0}i:while(1){v=(h|0)<18;w=(h|0)==18;x=H+(k<<2)|0;do{if(!v){if(!w)break i;if((c[x>>2]|0)>>>0>=9007199){h=18;break i}}n=0;o=l+127|0;while(1){u=o&127;p=H+(u<<2)|0;o=wo(c[p>>2]|0,0,29)|0;o=ro(o|0,D|0,n|0,0)|0;n=D;if(n>>>0>0|(n|0)==0&o>>>0>1e9){b=Do(o|0,n|0,1e9,0)|0;o=Eo(o|0,n|0,1e9,0)|0;n=b}else n=0;c[p>>2]=o;b=(u|0)==(k|0);l=(u|0)!=(l+127&127|0)|b?l:(o|0)==0?u:l;if(b)break;else o=u+-1|0}e=e+-29|0}while((n|0)==0);k=k+127&127;if((k|0)==(l|0)){b=l+127&127;l=H+((l+126&127)<<2)|0;c[l>>2]=c[l>>2]|c[H+(b<<2)>>2];l=b}c[H+(k<<2)>>2]=n;h=h+9|0}j:while(1){y=l+1&127;x=H+((l+127&127)<<2)|0;while(1){v=(h|0)==18;w=(h|0)>27?9:1;u=v^1;while(1){o=k&127;p=(o|0)==(l|0);do if(!p){n=c[H+(o<<2)>>2]|0;if(n>>>0<9007199){A=219;break}if(n>>>0>9007199)break;n=k+1&127;if((n|0)==(l|0)){A=219;break}n=c[H+(n<<2)>>2]|0;if(n>>>0<254740991){A=219;break}if(!(n>>>0>254740991|u)){h=o;break j}}else A=219;while(0);if((A|0)==219?(A=0,v):0){A=220;break j}e=e+w|0;if((k|0)==(l|0))k=l;else break}u=(1<<w)+-1|0;v=1e9>>>w;o=k;n=0;p=k;while(1){E=H+(p<<2)|0;b=c[E>>2]|0;k=(b>>>w)+n|0;c[E>>2]=k;n=$(b&u,v)|0;k=(p|0)==(o|0)&(k|0)==0;p=p+1&127;h=k?h+-9|0:h;k=k?p:o;if((p|0)==(l|0))break;else o=k}if(!n)continue;if((y|0)!=(k|0))break;c[x>>2]=c[x>>2]|1}c[H+(l<<2)>>2]=n;l=y}if((A|0)==220)if(p){c[H+(y+-1<<2)>>2]=0;h=l;l=y}else h=o;g=+((c[H+(h<<2)>>2]|0)>>>0);h=k+1&127;if((h|0)==(l|0)){l=k+2&127;c[H+(l+-1<<2)>>2]=0}r=+(I|0);j=r*(g*1.0e9+ +((c[H+(h<<2)>>2]|0)>>>0));v=e+53|0;p=v-J|0;u=(p|0)<(K|0);h=u&1;o=u?((p|0)<0?0:p):K;if((o|0)<53){M=+Am(+Hm(1.0,105-o|0),j);m=+Cm(j,+Hm(1.0,53-o|0));q=M;g=m;m=M+(j-m)}else{q=0.0;g=0.0;m=j}n=k+2&127;do if((n|0)==(l|0))j=g;else{n=c[H+(n<<2)>>2]|0;do if(n>>>0>=5e8){if(n>>>0>5e8){g=r*.75+g;break}if((k+3&127|0)==(l|0)){g=r*.5+g;break}else{g=r*.75+g;break}}else{if((n|0)==0?(k+3&127|0)==(l|0):0)break;g=r*.25+g}while(0);if((53-o|0)<=1){j=g;break}if(+Cm(g,1.0)!=0.0){j=g;break}j=g+1.0}while(0);g=m+j-q;do if((v&2147483647|0)>(-2-F|0)){if(+O(+g)>=9007199254740992.0){h=u&(o|0)==(p|0)?0:h;e=e+1|0;g=g*.5}if((e+50|0)<=(G|0)?!(j!=0.0&(h|0)!=0):0)break;c[(sm()|0)>>2]=34}while(0);g=+Im(g,e)}while(0);break a}default:{if(c[C>>2]|0)c[E>>2]=(c[E>>2]|0)+-1;c[(sm()|0)>>2]=22;wm(b,0);g=0.0;break a}}}}while(0);if((A|0)==23){h=(c[C>>2]|0)==0;if(!h)c[E>>2]=(c[E>>2]|0)+-1;if((f|0)!=0&e>>>0>3)do{if(!h)c[E>>2]=(c[E>>2]|0)+-1;e=e+-1|0}while(e>>>0>3)}g=+(I|0)*t}while(0);i=L;return +g}function vm(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;a:do if(e>>>0>36){c[(sm()|0)>>2]=22;h=0;g=0}else{r=b+4|0;q=b+100|0;do{i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=xm(b)|0}while((lm(i)|0)!=0);b:do switch(i|0){case 43:case 45:{j=((i|0)==45)<<31>>31;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0;p=j;break b}else{i=xm(b)|0;p=j;break b}}default:p=0}while(0);j=(e|0)==0;do if((e&-17|0)==0&(i|0)==48){i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=xm(b)|0;if((i|32|0)!=120)if(j){e=8;n=46;break}else{n=32;break}e=c[r>>2]|0;if(e>>>0<(c[q>>2]|0)>>>0){c[r>>2]=e+1;i=d[e>>0]|0}else i=xm(b)|0;if((d[34992+(i+1)>>0]|0)>15){g=(c[q>>2]|0)==0;if(!g)c[r>>2]=(c[r>>2]|0)+-1;if(!f){wm(b,0);h=0;g=0;break a}if(g){h=0;g=0;break a}c[r>>2]=(c[r>>2]|0)+-1;h=0;g=0;break a}else{e=16;n=46}}else{e=j?10:e;if((d[34992+(i+1)>>0]|0)>>>0<e>>>0)n=32;else{if(c[q>>2]|0)c[r>>2]=(c[r>>2]|0)+-1;wm(b,0);c[(sm()|0)>>2]=22;h=0;g=0;break a}}while(0);if((n|0)==32)if((e|0)==10){e=i+-48|0;if(e>>>0<10){i=0;while(1){j=(i*10|0)+e|0;e=c[r>>2]|0;if(e>>>0<(c[q>>2]|0)>>>0){c[r>>2]=e+1;i=d[e>>0]|0}else i=xm(b)|0;e=i+-48|0;if(!(e>>>0<10&j>>>0<429496729)){e=j;break}else i=j}j=0}else{e=0;j=0}f=i+-48|0;if(f>>>0<10){while(1){k=Co(e|0,j|0,10,0)|0;l=D;m=((f|0)<0)<<31>>31;o=~m;if(l>>>0>o>>>0|(l|0)==(o|0)&k>>>0>~f>>>0){k=e;break}e=ro(k|0,l|0,f|0,m|0)|0;j=D;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=xm(b)|0;f=i+-48|0;if(!(f>>>0<10&(j>>>0<429496729|(j|0)==429496729&e>>>0<2576980378))){k=e;break}}if(f>>>0>9){i=k;e=p}else{e=10;n=72}}else{i=e;e=p}}else n=46;c:do if((n|0)==46){if(!(e+-1&e)){n=a[35249+((e*23|0)>>>5&7)>>0]|0;j=a[34992+(i+1)>>0]|0;f=j&255;if(f>>>0<e>>>0){i=0;while(1){k=f|i<<n;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=xm(b)|0;j=a[34992+(i+1)>>0]|0;f=j&255;if(!(k>>>0<134217728&f>>>0<e>>>0))break;else i=k}f=0}else{f=0;k=0}l=vo(-1,-1,n|0)|0;m=D;if((j&255)>>>0>=e>>>0|(f>>>0>m>>>0|(f|0)==(m|0)&k>>>0>l>>>0)){j=f;n=72;break}else i=f;while(1){k=wo(k|0,i|0,n|0)|0;f=D;k=j&255|k;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=xm(b)|0;j=a[34992+(i+1)>>0]|0;if((j&255)>>>0>=e>>>0|(f>>>0>m>>>0|(f|0)==(m|0)&k>>>0>l>>>0)){j=f;n=72;break c}else i=f}}j=a[34992+(i+1)>>0]|0;f=j&255;if(f>>>0<e>>>0){i=0;while(1){k=f+($(i,e)|0)|0;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=xm(b)|0;j=a[34992+(i+1)>>0]|0;f=j&255;if(!(k>>>0<119304647&f>>>0<e>>>0))break;else i=k}f=0}else{k=0;f=0}if((j&255)>>>0<e>>>0){n=Do(-1,-1,e|0,0)|0;o=D;m=f;while(1){if(m>>>0>o>>>0|(m|0)==(o|0)&k>>>0>n>>>0){j=m;n=72;break c}f=Co(k|0,m|0,e|0,0)|0;l=D;j=j&255;if(l>>>0>4294967295|(l|0)==-1&f>>>0>~j>>>0){j=m;n=72;break c}k=ro(j|0,0,f|0,l|0)|0;f=D;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=xm(b)|0;j=a[34992+(i+1)>>0]|0;if((j&255)>>>0>=e>>>0){j=f;n=72;break}else m=f}}else{j=f;n=72}}while(0);if((n|0)==72)if((d[34992+(i+1)>>0]|0)>>>0<e>>>0){do{i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=xm(b)|0}while((d[34992+(i+1)>>0]|0)>>>0<e>>>0);c[(sm()|0)>>2]=34;j=h;i=g;e=(g&1|0)==0&0==0?p:0}else{i=k;e=p}if(c[q>>2]|0)c[r>>2]=(c[r>>2]|0)+-1;if(!(j>>>0<h>>>0|(j|0)==(h|0)&i>>>0<g>>>0)){if(!((g&1|0)!=0|0!=0|(e|0)!=0)){c[(sm()|0)>>2]=34;g=ro(g|0,h|0,-1,-1)|0;h=D;break}if(j>>>0>h>>>0|(j|0)==(h|0)&i>>>0>g>>>0){c[(sm()|0)>>2]=34;break}}g=((e|0)<0)<<31>>31;g=qo(i^e|0,j^g|0,e|0,g|0)|0;h=D}while(0);D=h;return g|0}function wm(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a+104>>2]=b;d=c[a+4>>2]|0;e=c[a+8>>2]|0;f=e-d|0;c[a+108>>2]=f;if((b|0)!=0&(f|0)>(b|0))c[a+100>>2]=d+b;else c[a+100>>2]=e;return}function xm(b){b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0;f=b+104|0;i=c[f>>2]|0;if((i|0)!=0?(c[b+108>>2]|0)>=(i|0):0)j=4;else{e=xn(b)|0;if((e|0)>=0){h=c[f>>2]|0;f=b+8|0;if(h){g=c[f>>2]|0;i=c[b+4>>2]|0;f=g;h=h-(c[b+108>>2]|0)+-1|0;if((f-i|0)>(h|0))c[b+100>>2]=i+h;else j=9}else{g=c[f>>2]|0;f=g;j=9}if((j|0)==9)c[b+100>>2]=f;f=c[b+4>>2]|0;if(g){b=b+108|0;c[b>>2]=g+1-f+(c[b>>2]|0)}f=f+-1|0;if((d[f>>0]|0|0)!=(e|0))a[f>>0]=e}else j=4}if((j|0)==4){c[b+100>>2]=0;e=-1}return e|0}function ym(a){a=a|0;if(a>>>0>4294963200){c[(sm()|0)>>2]=0-a;a=-1}return a|0}function zm(a,b){a=+a;b=+b;var d=0,e=0;h[k>>3]=a;e=c[k>>2]|0;d=c[k+4>>2]|0;h[k>>3]=b;d=c[k+4>>2]&-2147483648|d&2147483647;c[k>>2]=e;c[k+4>>2]=d;return +(+h[k>>3])}function Am(a,b){a=+a;b=+b;return +(+zm(a,b))}
function Sf(a){a=a|0;var d=0;d=(c[840]|0)+a|0;c[841]=d;if((a|0)>-1){c[839]=Ii(c[839]|0,d*140|0)|0;c[838]=Ii(c[838]|0,(c[841]|0)*48|0)|0}d=c[839]|0;a=d+560|0;b[d+562>>1]=4;b[a>>1]=4;d=d+580|0;c[d>>2]=5;c[d+4>>2]=5;c[d+8>>2]=5;c[d+12>>2]=5;c[d+16>>2]=5;c[d+20>>2]=5;c[d+24>>2]=5;c[d+28>>2]=5;c[d+32>>2]=5;c[d+36>>2]=5;c[d+40>>2]=5;c[d+44>>2]=5;c[d+48>>2]=5;c[d+52>>2]=5;c[d+56>>2]=5;c[d+60>>2]=5;c[d+64>>2]=5;c[d+68>>2]=5;c[d+72>>2]=5;c[d+76>>2]=5;c[d+80>>2]=5;c[d+84>>2]=5;c[d+88>>2]=5;c[d+92>>2]=5;c[d+96>>2]=5;c[d+100>>2]=5;c[d+104>>2]=5;c[d+108>>2]=5;c[d+112>>2]=5;c[d+116>>2]=5;xg(a);a=c[839]|0;d=a+280|0;b[a+282>>1]=2;b[d>>1]=2;a=a+300|0;c[a>>2]=5;c[a+4>>2]=5;c[a+8>>2]=5;c[a+12>>2]=5;c[a+16>>2]=5;c[a+20>>2]=5;c[a+24>>2]=5;c[a+28>>2]=5;c[a+32>>2]=5;c[a+36>>2]=5;c[a+40>>2]=5;c[a+44>>2]=5;c[a+48>>2]=5;c[a+52>>2]=5;c[a+56>>2]=5;c[a+60>>2]=5;c[a+64>>2]=5;c[a+68>>2]=5;c[a+72>>2]=5;c[a+76>>2]=5;c[a+80>>2]=5;c[a+84>>2]=5;c[a+88>>2]=5;c[a+92>>2]=5;c[a+96>>2]=5;c[a+100>>2]=5;c[a+104>>2]=5;c[a+108>>2]=5;c[a+112>>2]=5;c[a+116>>2]=5;dh(d);d=c[839]|0;a=d+420|0;b[d+422>>1]=3;b[a>>1]=3;d=d+440|0;c[d>>2]=5;c[d+4>>2]=5;c[d+8>>2]=5;c[d+12>>2]=5;c[d+16>>2]=5;c[d+20>>2]=5;c[d+24>>2]=5;c[d+28>>2]=5;c[d+32>>2]=5;c[d+36>>2]=5;c[d+40>>2]=5;c[d+44>>2]=5;c[d+48>>2]=5;c[d+52>>2]=5;c[d+56>>2]=5;c[d+60>>2]=5;c[d+64>>2]=5;c[d+68>>2]=5;c[d+72>>2]=5;c[d+76>>2]=5;c[d+80>>2]=5;c[d+84>>2]=5;c[d+88>>2]=5;c[d+92>>2]=5;c[d+96>>2]=5;c[d+100>>2]=5;c[d+104>>2]=5;c[d+108>>2]=5;c[d+112>>2]=5;c[d+116>>2]=5;dg(a);a=c[839]|0;d=a+700|0;b[a+702>>1]=5;b[d>>1]=5;a=a+720|0;c[a>>2]=5;c[a+4>>2]=5;c[a+8>>2]=5;c[a+12>>2]=5;c[a+16>>2]=5;c[a+20>>2]=5;c[a+24>>2]=5;c[a+28>>2]=5;c[a+32>>2]=5;c[a+36>>2]=5;c[a+40>>2]=5;c[a+44>>2]=5;c[a+48>>2]=5;c[a+52>>2]=5;c[a+56>>2]=5;c[a+60>>2]=5;c[a+64>>2]=5;c[a+68>>2]=5;c[a+72>>2]=5;c[a+76>>2]=5;c[a+80>>2]=5;c[a+84>>2]=5;c[a+88>>2]=5;c[a+92>>2]=5;c[a+96>>2]=5;c[a+100>>2]=5;c[a+104>>2]=5;c[a+108>>2]=5;c[a+112>>2]=5;c[a+116>>2]=5;ph(d);d=c[839]|0;a=d+140|0;b[d+142>>1]=1;b[a>>1]=1;d=d+160|0;c[d>>2]=5;c[d+4>>2]=5;c[d+8>>2]=5;c[d+12>>2]=5;c[d+16>>2]=5;c[d+20>>2]=5;c[d+24>>2]=5;c[d+28>>2]=5;c[d+32>>2]=5;c[d+36>>2]=5;c[d+40>>2]=5;c[d+44>>2]=5;c[d+48>>2]=5;c[d+52>>2]=5;c[d+56>>2]=5;c[d+60>>2]=5;c[d+64>>2]=5;c[d+68>>2]=5;c[d+72>>2]=5;c[d+76>>2]=5;c[d+80>>2]=5;c[d+84>>2]=5;c[d+88>>2]=5;c[d+92>>2]=5;c[d+96>>2]=5;c[d+100>>2]=5;c[d+104>>2]=5;c[d+108>>2]=5;c[d+112>>2]=5;c[d+116>>2]=5;Wg(a);return}function Tf(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;if((a|0)<0){a=c[840]|0;if((a|0)>=(c[841]|0))return;c[840]=a+1;e=c[839]|0;b[e+(a*140|0)>>1]=0;f=c[838]|0;b[f+(a*48|0)+2>>1]=-1;b[f+(a*48|0)>>1]=4;if((a|0)<0)return}else e=c[839]|0;f=e+(a*140|0)|0;g=a&65535;b[e+(a*140|0)+2>>1]=g;b[f>>1]=g;a=e+(a*140|0)+20|0;c[a>>2]=5;c[a+4>>2]=5;c[a+8>>2]=5;c[a+12>>2]=5;c[a+16>>2]=5;c[a+20>>2]=5;c[a+24>>2]=5;c[a+28>>2]=5;c[a+32>>2]=5;c[a+36>>2]=5;c[a+40>>2]=5;c[a+44>>2]=5;c[a+48>>2]=5;c[a+52>>2]=5;c[a+56>>2]=5;c[a+60>>2]=5;c[a+64>>2]=5;c[a+68>>2]=5;c[a+72>>2]=5;c[a+76>>2]=5;c[a+80>>2]=5;c[a+84>>2]=5;c[a+88>>2]=5;c[a+92>>2]=5;c[a+96>>2]=5;c[a+100>>2]=5;c[a+104>>2]=5;c[a+108>>2]=5;c[a+112>>2]=5;c[a+116>>2]=5;od[d&63](f);return}function Uf(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[839]|0;od[c[g+((b[a>>1]<<16>>16)*140|0)+52>>2]&63](a);c[a+28>>2]=e;b[a>>1]=d;c[a+24>>2]=f;b[a+2>>1]=2;c[a+4>>2]=1;d=b[g+(d*140|0)+8>>1]|0;if(d<<16>>16<0)d=1;else d=(f|0)/(d<<16>>16|0)|0;c[a+8>>2]=d;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=1;return}function Vf(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f;c[d+40>>2]=e;h=rd[c[(c[3356>>2]|0)+((b[d>>1]<<16>>16)*140|0)+28>>2]&63](d)|0;jd[c[(c[3356>>2]|0)+((b[d>>1]<<16>>16)*140|0)+64>>2]&15](d,h,g)|0;d=b[d>>1]|0;e=c[g>>2]|0;g=c[839]|0;od[c[g+((b[a>>1]<<16>>16)*140|0)+52>>2]&63](a);c[a+28>>2]=h;b[a>>1]=d;c[a+24>>2]=e;b[a+2>>1]=2;c[a+4>>2]=1;d=b[g+((d<<16>>16)*140|0)+8>>1]|0;if(d<<16>>16<0)e=1;else e=(e|0)/(d<<16>>16|0)|0;c[a+8>>2]=e;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=1;i=f;return}function Wf(a,d,e,f,g,h){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;i=c[839]|0;if((f|e|g|h|0)<0){a=Rb(4)|0;c[a>>2]=3;ad(a|0,8,0)}else{od[c[i+((b[a>>1]<<16>>16)*140|0)+52>>2]&63](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[i+(d*140|0)+6>>1]|0;c[a+8>>2]=e;c[a+12>>2]=f;c[a+16>>2]=g;c[a+20>>2]=h;qd[c[i+(d*140|0)+48>>2]&63](a,0);return}}function Xf(a,d,e,f,g,h,i){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0;j=c[839]|0;if((g|f|h|i|0)<0){a=Rb(4)|0;c[a>>2]=3;ad(a|0,8,0)}else{od[c[j+((b[a>>1]<<16>>16)*140|0)+52>>2]&63](a);b[a>>1]=d;k=a+4|0;c[k>>2]=e;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[j+(d*140|0)+6>>1]|0;c[a+8>>2]=f;c[a+12>>2]=g;c[a+16>>2]=h;c[a+20>>2]=i;qd[c[j+(d*140|0)+48>>2]&63](a,0);c[k>>2]=1;return}}function Yf(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0;f=b[a>>1]|0;g=c[839]|0;c[a+4+(d<<2)>>2]=e;qd[c[g+(f*140|0)+48>>2]&63](a,a);return}function Zf(a,d){a=a|0;d=d|0;var e=0;e=c[839]|0;od[c[e+((b[a>>1]<<16>>16)*140|0)+52>>2]&63](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[e+(d*140|0)+6>>1]|0;c[a+8>>2]=1;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;qd[c[e+(d*140|0)+48>>2]&63](a,0);return}function _f(a,d){a=a|0;d=d|0;var f=0,g=0;g=c[839]|0;od[c[g+((b[a>>1]<<16>>16)*140|0)+52>>2]&63](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;f=a+36|0;b[f>>1]=b[g+(d*140|0)+6>>1]|0;c[a+8>>2]=1;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;qd[c[g+(d*140|0)+48>>2]&63](a,0);b[f>>1]=e[f>>1]|0|256;return}function $f(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;e=b[a>>1]|0;f=c[839]|0;if((e|0)==(d|0)){d=rd[c[f+(d*140|0)+28>>2]&63](a)|0;return d|0}g=rd[c[f+(e*140|0)+28>>2]&63](a)|0;a=b[a>>1]|0;e=a<<16>>16;f=c[839]|0;if(a<<16>>16>7){d=wd[c[f+(e*140|0)+24>>2]&31](g,d)|0;return d|0}else{d=wd[c[f+(d*140|0)+20>>2]&31](g,e)|0;return d|0}return 0}function ag(a){a=a|0;var d=0,e=0,f=0,g=0;e=c[840]|0;if((e|0)<=0){a=0;return a|0}f=c[839]|0;g=0;while(1){d=f+(g*140|0)|0;if((b[d>>1]|0)!=0?(Jn(c[f+(g*140|0)+12>>2]|0,a)|0)==0:0){e=6;break}g=g+1|0;if((g|0)>=(e|0)){d=0;e=6;break}}if((e|0)==6)return d|0;return 0}function bg(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;f=a+38|0;e=b[f>>1]|0;if(e<<16>>16>4){a=Rb(4)|0;c[a>>2]=7;ad(a|0,8,0)}if(!(e<<16>>16)){c[a+44>>2]=1;g=1}else{h=a+44|0;g=$(c[h>>2]|0,c[a+4+(e<<16>>16<<2)>>2]|0)|0;c[h>>2]=g}e=e+1<<16>>16;b[f>>1]=e;if((d|0)<0){h=Rb(4)|0;c[h>>2]=7;ad(h|0,8,0)}if((c[a+4+(e<<16>>16<<2)>>2]|0)>(d|0)){d=$(g,d)|0;h=a+40|0;c[h>>2]=(c[h>>2]|0)+d;return}else{h=Rb(4)|0;c[h>>2]=7;ad(h|0,8,0)}}function cg(){var a=0;a=Rb(4)|0;c[a>>2]=21;ad(a|0,8,0)}function dg(a){a=a|0;c[842]=a+2;c[a+72>>2]=4;c[a+20>>2]=14;c[a+28>>2]=25;c[a+56>>2]=26;c[a+64>>2]=9;c[a+68>>2]=5;c[a+48>>2]=5;c[a+52>>2]=23;c[a+76>>2]=6;c[a+80>>2]=7;c[a+84>>2]=8;c[a+88>>2]=9;c[a+92>>2]=10;c[a+108>>2]=11;c[a+112>>2]=12;c[a+116>>2]=13;c[a+120>>2]=14;c[a+124>>2]=15;c[a+128>>2]=16;c[a+12>>2]=25358;b[a+4>>1]=1;b[a+6>>1]=9;b[a+8>>1]=8;return}function eg(b,c,e){b=b|0;c=c|0;e=e|0;var f=0;f=e;f=d[f>>0]|d[f+1>>0]<<8|d[f+2>>0]<<16|d[f+3>>0]<<24;e=e+4|0;e=d[e>>0]|d[e+1>>0]<<8|d[e+2>>0]<<16|d[e+3>>0]<<24;b=c;c=b;a[c>>0]=f;a[c+1>>0]=f>>8;a[c+2>>0]=f>>16;a[c+3>>0]=f>>24;b=b+4|0;a[b>>0]=e;a[b+1>>0]=e>>8;a[b+2>>0]=e>>16;a[b+3>>0]=e>>24;return}function fg(a,b){a=a|0;b=b|0;switch(b|0){case 2:{h[9]=+yn(a);b=72;return b|0}case 4:{h[9]=+(c[a>>2]|0);b=72;return b|0}case 3:{b=a;return b|0}default:{b=Rb(4)|0;c[b>>2]=6;ad(b|0,8,0)}}return 0}function gg(a){a=a|0;return (c[a+28>>2]|0)+(c[a+40>>2]<<3)|0}function hg(a){a=a|0;return 8}function ig(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function jg(a,b,c){a=a|0;b=b|0;c=c|0;return}function kg(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=a+8|0;f=c[e>>2]|0;if((f|0)<1){c[e>>2]=1;f=1}g=c[a+12>>2]|0;h=c[a+16>>2]|0;e=c[a+20>>2]|0;i=$($($(f<<3,(g|0)==0?1:g)|0,(h|0)==0?1:h)|0,(e|0)==0?1:e)|0;b[a+2>>1]=1;j=Fi(i)|0;if(i){g=$(f,g>>>0>1?g:1)|0;h=$(g,h>>>0>1?h:1)|0;uo(j|0,0,($(h,e>>>0>1?e:1)|0)<<3|0)|0}e=a+28|0;if(!d){d=a+24|0;c[e>>2]=j;c[d>>2]=i;return}else{d=a+24|0;so(j|0,c[e>>2]|0,c[d>>2]|0)|0;Hi(c[e>>2]|0);c[e>>2]=j;c[d>>2]=i;return}}function lg(a){a=a|0;var d=0;d=a+2|0;a=a+28|0;if((b[d>>1]|0)==1)Hi(c[a>>2]|0);c[a>>2]=0;b[d>>1]=-1;return}function mg(a,d){a=a|0;d=d|0;h[a>>3]=+h[d>>3]+ +h[a>>3];b[c[842]>>1]=3;return}function ng(a,d){a=a|0;d=d|0;h[a>>3]=+h[a>>3]-+h[d>>3];b[c[842]>>1]=3;return}function og(a,d){a=a|0;d=d|0;h[a>>3]=+h[d>>3]*+h[a>>3];b[c[842]>>1]=3;return}function pg(a,d){a=a|0;d=d|0;var e=0.0;e=+h[d>>3];if(e==0.0){a=Rb(4)|0;c[a>>2]=19;ad(a|0,8,0)}else{h[a>>3]=+h[a>>3]/e;b[c[842]>>1]=3;return}}function qg(a,d){a=a|0;d=d|0;var e=0.0;e=+h[d>>3];if(e==0.0){a=Rb(4)|0;c[a>>2]=19;ad(a|0,8,0)}else{h[a>>3]=+Bm(+h[a>>3],e);b[c[842]>>1]=3;return}}function rg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]==+h[d>>3]&1;b[c[842]>>1]=4;return}function sg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]!=+h[d>>3]&1;b[c[842]>>1]=4;return}function tg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]>+h[d>>3]&1;b[c[842]>>1]=4;return}function ug(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]<+h[d>>3]&1;b[c[842]>>1]=4;return}function vg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]>=+h[d>>3]&1;b[c[842]>>1]=4;return}function wg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]<=+h[d>>3]&1;b[c[842]>>1]=4;return}function xg(a){a=a|0;c[a+72>>2]=6;c[a+20>>2]=15;c[a+28>>2]=27;c[a+56>>2]=28;c[a+64>>2]=10;c[a+68>>2]=7;c[a+48>>2]=17;c[a+52>>2]=24;c[a+76>>2]=18;c[a+80>>2]=19;c[a+84>>2]=20;c[a+88>>2]=21;c[a+92>>2]=22;c[a+96>>2]=23;c[a+100>>2]=24;c[a+104>>2]=25;c[a+108>>2]=26;c[a+112>>2]=27;c[a+116>>2]=28;c[a+120>>2]=29;c[a+124>>2]=30;c[a+128>>2]=31;c[a+132>>2]=32;c[a+136>>2]=33;c[a+12>>2]=25365;b[a+4>>1]=1;b[a+6>>1]=9;b[a+8>>1]=4;return}function yg(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[d>>2];return}function zg(b,d){b=b|0;d=d|0;switch(d|0){case 2:{if((a[b>>0]|0)==36)b=tl(b)|0;else b=zn(b)|0;c[843]=b;d=3372;return d|0}case 3:{c[843]=~~+h[b>>3];d=3372;return d|0}case 4:{d=b;return d|0}default:{d=Rb(4)|0;c[d>>2]=6;ad(d|0,8,0)}}return 0}function Ag(a){a=a|0;return (c[a+28>>2]|0)+(c[a+40>>2]<<2)|0}function Bg(a){a=a|0;return 4}function Cg(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function Dg(a,b,c){a=a|0;b=b|0;c=c|0;return}function Eg(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=a+8|0;f=c[e>>2]|0;if((f|0)<1){c[e>>2]=1;f=1}g=c[a+12>>2]|0;h=c[a+16>>2]|0;e=c[a+20>>2]|0;i=$($($(f<<2,(g|0)==0?1:g)|0,(h|0)==0?1:h)|0,(e|0)==0?1:e)|0;b[a+2>>1]=1;j=Fi(i)|0;if(i){g=$(f,g>>>0>1?g:1)|0;h=$(g,h>>>0>1?h:1)|0;uo(j|0,0,($(h,e>>>0>1?e:1)|0)<<2|0)|0}e=a+28|0;if(!d){d=a+24|0;c[e>>2]=j;c[d>>2]=i;return}else{d=a+24|0;so(j|0,c[e>>2]|0,c[d>>2]|0)|0;Hi(c[e>>2]|0);c[e>>2]=j;c[d>>2]=i;return}}function Fg(a){a=a|0;var d=0;d=a+2|0;a=a+28|0;if((b[d>>1]|0)==1)Hi(c[a>>2]|0);c[a>>2]=0;b[d>>1]=-1;return}function Gg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)+(c[b>>2]|0);return}function Hg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)-(c[b>>2]|0);return}function Ig(a,b){a=a|0;b=b|0;c[a>>2]=$(c[a>>2]|0,c[b>>2]|0)|0;return}function Jg(a,b){a=a|0;b=b|0;b=c[b>>2]|0;if(!b){a=Rb(4)|0;c[a>>2]=19;ad(a|0,8,0)}else{c[a>>2]=(c[a>>2]|0)/(b|0)|0;return}}function Kg(a,b){a=a|0;b=b|0;b=c[b>>2]|0;if(!b){a=Rb(4)|0;c[a>>2]=19;ad(a|0,8,0)}else{c[a>>2]=(c[a>>2]|0)%(b|0)|0;return}}function Lg(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]&c[b>>2];return}function Mg(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]|c[b>>2];return}function Ng(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]^c[b>>2];return}function Og(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)==(c[b>>2]|0)&1;return}function Pg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)!=(c[b>>2]|0)&1;return}function Qg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)>(c[b>>2]|0)&1;return}function Rg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)<(c[b>>2]|0)&1;return}function Sg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)>=(c[b>>2]|0)&1;return}function Tg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)<=(c[b>>2]|0)&1;return}function Ug(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]>>c[b>>2];return}function Vg(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]<<c[b>>2];return}function Wg(a){a=a|0;c[a+72>>2]=8;c[a+28>>2]=29;c[a+56>>2]=30;c[a+60>>2]=31;c[a+64>>2]=11;c[a+68>>2]=9;c[a+48>>2]=34;c[a+52>>2]=25;c[a+12>>2]=25369;b[a+4>>1]=1;b[a+6>>1]=137;b[a+8>>1]=4;return}function Xg(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[d>>2];return}function Yg(a){a=a|0;return (c[a+28>>2]|0)+(c[a+40>>2]<<2)|0}function Zg(a){a=a|0;return 4}function _g(a){a=a|0;return (c[a>>2]|0)!=0|0}function $g(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function ah(a,b,c){a=a|0;b=b|0;c=c|0;return}function bh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=a+8|0;f=c[e>>2]|0;if((f|0)<1){c[e>>2]=1;f=1}g=c[a+12>>2]|0;h=c[a+16>>2]|0;e=c[a+20>>2]|0;i=$($($(f<<2,(g|0)==0?1:g)|0,(h|0)==0?1:h)|0,(e|0)==0?1:e)|0;b[a+2>>1]=1;j=Fi(i)|0;if(i){g=$(f,g>>>0>1?g:1)|0;h=$(g,h>>>0>1?h:1)|0;uo(j|0,0,($(h,e>>>0>1?e:1)|0)<<2|0)|0}e=a+28|0;if(!d){d=a+24|0;c[e>>2]=j;c[d>>2]=i;return}else{d=a+24|0;so(j|0,c[e>>2]|0,c[d>>2]|0)|0;Hi(c[e>>2]|0);c[e>>2]=j;c[d>>2]=i;return}}function ch(a){a=a|0;var d=0;d=a+2|0;a=a+28|0;if((b[d>>1]|0)==1)Hi(c[a>>2]|0);c[a>>2]=0;b[d>>1]=-1;return}function dh(a){a=a|0;c[844]=a;c[a+72>>2]=10;c[a+20>>2]=16;c[a+28>>2]=32;c[a+56>>2]=33;c[a+64>>2]=12;c[a+68>>2]=11;c[a+48>>2]=35;c[a+52>>2]=26;c[a+76>>2]=36;c[a+108>>2]=37;c[a+112>>2]=38;c[a+12>>2]=25375;b[a+4>>1]=1;b[a+6>>1]=10;b[a+8>>1]=-1;return}function eh(a,d,e){a=a|0;d=d|0;e=e|0;if((b[a+2>>1]|0)==2){Pn(d,e,c[a+24>>2]|0)|0;return}else{Ji(Li(d)|0,e);return}}function fh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=i;i=i+16|0;e=f+8|0;d=f;switch(b|0){case 4:{c[d>>2]=c[a>>2];fn(25379,25779,d)|0;e=25379;i=f;return e|0}case 3:{h[e>>3]=+h[a>>3];fn(25379,25782,e)|0;e=25379;i=f;return e|0}case 2:{e=a;i=f;return e|0}default:{f=Rb(4)|0;c[f>>2]=6;ad(f|0,8,0)}}return 0}function gh(a){a=a|0;var b=0;b=c[a+40>>2]|0;if(!b){a=a+28|0;a=c[a>>2]|0;return a|0}else{a=(c[a+32>>2]|0)+(b<<2)|0;a=c[a>>2]|0;return a|0}return 0}function hh(a){a=a|0;return (Mn(a)|0)+1|0}function ih(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;if((b[a+2>>1]|0)==2){f=d;d=a+24|0}else{f=d;d=(Ei(d)|0)+8|0}c[e>>2]=c[d>>2];return f|0}function jh(a,d,e){a=a|0;d=d|0;e=e|0;if((b[a+2>>1]|0)==2)return;a=Li(d)|0;c[a>>2]=Ii(c[a>>2]|0,e)|0;return}function kh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;n=p;e=a+8|0;f=c[e>>2]|0;if((f|0)<1){c[e>>2]=1;f=1}g=(d|0)==0;if(g){m=0;l=0}else{m=c[d+24>>2]|0;c[n>>2]=c[d+28>>2];m=m>>>2;l=c[d+32>>2]|0}d=c[a+12>>2]|0;j=c[a+16>>2]|0;k=c[a+20>>2]|0;e=$($($(f<<2,(d|0)==0?1:d)|0,(j|0)==0?1:j)|0,(k|0)==0?1:k)|0;c[a+24>>2]=e;b[a+2>>1]=1;h=ho(e,1)|0;o=a+32|0;c[o>>2]=h;if(!h){p=Rb(4)|0;c[p>>2]=26;ad(p|0,8,0)}if(g){h=c[a+4>>2]|0;h=(h|0)<64?64:h;if(!e){i=p;return}g=a+28|0;f=$(f,d>>>0>1?d:1)|0;f=$(f,j>>>0>1?j:1)|0;f=($(f,k>>>0>1?k:1)|0)&1073741823;d=0;do{if(!d)e=g;else e=(c[o>>2]|0)+(d<<2)|0;n=Gi(h)|0;c[e>>2]=n;Mi(n,e);d=d+1|0}while((d|0)!=(f|0));i=p;return}if(e){h=a+28|0;d=$(f,d>>>0>1?d:1)|0;d=$(d,j>>>0>1?j:1)|0;d=($(d,k>>>0>1?k:1)|0)&1073741823;g=0;do{e=(g|0)==0;if(e)f=h;else f=(c[o>>2]|0)+(g<<2)|0;if((g|0)<(m|0)){e=c[(e?n:l+(g<<2)|0)>>2]|0;c[f>>2]=e}else{e=Gi(64)|0;c[f>>2]=e}Mi(e,f);g=g+1|0}while((g|0)!=(d|0))}go(l);i=p;return}function lh(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0;i=a+2|0;if((b[i>>1]|0)!=1){b[i>>1]=-1;return}f=c[a+8>>2]|0;g=c[a+12>>2]|0;d=c[a+16>>2]|0;e=c[a+20>>2]|0;h=$($($(f<<2,(g|0)==0?1:g)|0,(d|0)==0?1:d)|0,(e|0)==0?1:e)|0;c[a+24>>2]=h;if(!h)a=a+32|0;else{h=a+28|0;a=a+32|0;f=$(f,g>>>0>1?g:1)|0;f=$(f,d>>>0>1?d:1)|0;e=($(f,e>>>0>1?e:1)|0)&1073741823;f=0;do{if(!f)d=h;else d=(c[a>>2]|0)+(f<<2)|0;Hi(c[d>>2]|0);f=f+1|0}while((f|0)!=(e|0))}go(c[a>>2]|0);b[i>>1]=-1;return}function mh(a,d){a=a|0;d=d|0;Ki(Li(a)|0,d);b[(c[844]|0)+2>>1]=2;return}function nh(a,d){a=a|0;d=d|0;c[a>>2]=(Jn(a,d)|0)==0&1;b[(c[844]|0)+2>>1]=4;return}function oh(a,d){a=a|0;d=d|0;c[a>>2]=Jn(a,d)|0;b[(c[844]|0)+2>>1]=4;return}function ph(a){a=a|0;c[a+72>>2]=12;c[a+28>>2]=34;c[a+56>>2]=35;c[a+60>>2]=36;c[a+64>>2]=13;c[a+68>>2]=13;c[a+48>>2]=39;c[a+52>>2]=27;c[a+12>>2]=25785;b[a+4>>1]=1;b[a+6>>1]=137;b[a+8>>1]=16;return}function qh(a,d,e){a=a|0;d=d|0;e=e|0;b[e>>1]=2;if((b[d>>1]|0)==1)Hi(c[d+12>>2]|0);c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];return}function rh(a){a=a|0;return (c[a+28>>2]|0)+(c[a+40>>2]<<4)|0}function sh(a){a=a|0;return 16}function th(a){a=a|0;return b[a>>1]|0}function uh(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b+8>>2];return c[b+12>>2]|0}function vh(a,b,c){a=a|0;b=b|0;c=c|0;return}function wh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;i=a+8|0;e=c[i>>2]|0;if((e|0)<1){c[i>>2]=1;e=1}b[a+2>>1]=1;g=e<<4;h=Fi(g)|0;if((c[i>>2]|0)>0){e=h;f=0;while(1){f=f+1|0;b[e>>1]=0;b[e+2>>1]=0;b[e+4>>1]=0;b[e+6>>1]=0;b[e+8>>1]=0;b[e+10>>1]=0;b[e+12>>1]=0;b[e+14>>1]=0;if((f|0)>=(c[i>>2]|0))break;else e=e+16|0}}e=a+28|0;if(!d){d=a+24|0;c[e>>2]=h;c[d>>2]=g;return}else{d=a+24|0;so(h|0,c[e>>2]|0,c[d>>2]|0)|0;Hi(c[e>>2]|0);c[e>>2]=h;c[d>>2]=g;return}}function xh(a){a=a|0;var d=0,e=0,f=0,g=0,h=0;g=a+2|0;if((b[g>>1]|0)!=1){b[g>>1]=-1;return}qe(a);h=a+28|0;f=a+8|0;a=c[f>>2]|0;if((a|0)>0){d=c[h>>2]|0;e=0;while(1){if((b[d>>1]|0)==1){Hi(c[d+12>>2]|0);a=c[f>>2]|0}e=e+1|0;if((e|0)>=(a|0))break;else d=d+16|0}}Hi(c[h>>2]|0);b[g>>1]=-1;return}function yh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=a+36|0;d=a+32|0;e=fo(68)|0;f=e;g=f+68|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[b>>2]=17;c[d>>2]=e;g=uj()|0;Bh(a,0,2,0,0,g,vj()|0);c[845]=a;g=a+44|0;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;return}function zh(a){a=a|0;var b=0,d=0,e=0,f=0;e=a+36|0;b=c[e>>2]|0;f=a+32|0;if((b|0)>0)d=0;else{f=c[f>>2]|0;go(f);return}while(1){a=c[(c[f>>2]|0)+(d<<2)>>2]|0;if(a){if((c[a>>2]|0)==1){o=0;ja(28,a|0);b=o;o=0;if(b&1){b=7;break}o=0;ja(29,a|0);b=o;o=0;if(b&1){b=7;break}}Gl(a);b=c[e>>2]|0}d=d+1|0;if((d|0)>=(b|0)){b=9;break}}if((b|0)==7){f=kb()|0;Gl(a);qb(f|0)}else if((b|0)==9){f=c[f>>2]|0;go(f);return}}function Ah(a){a=a|0;return 0}function Bh(d,e,f,g,h,i,j){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0;l=e+1|0;m=d+36|0;h=c[m>>2]|0;if((h|0)<=(e|0)){n=fo(l<<2)|0;do if((e|0)>-1){g=d+32|0;if(!h){uo(n|0,0,((l|0)>1?l<<2:4)|0)|0;break}else k=0;do{if((k|0)<(h|0))c[n+(k<<2)>>2]=c[(c[g>>2]|0)+(k<<2)>>2];else c[n+(k<<2)>>2]=0;k=k+1|0}while((k|0)<(l|0))}else g=d+32|0;while(0);h=c[g>>2]|0;if(h)go(h);c[m>>2]=l;c[g>>2]=n}h=d+32|0;g=c[h>>2]|0;k=c[g+(e<<2)>>2]|0;if(k){if((c[k>>2]|0)==1){o=0;ja(28,k|0);n=o;o=0;if(n&1){f=kb()|0;Gl(k);qb(f|0)}o=0;ja(29,k|0);n=o;o=0;if(n&1){f=kb()|0;Gl(k);qb(f|0)}}Gl(k);g=c[h>>2]|0}n=El(660)|0;c[g+(e<<2)>>2]=n;c[n+32>>2]=e;c[n+28>>2]=f;c[n+280>>2]=-1;c[n>>2]=1;c[n+168>>2]=0;c[n+164>>2]=0;c[n+4>>2]=i;c[n+8>>2]=j;c[n+152>>2]=i;Gh(n,0);c[n+188>>2]=-1;c[n+136>>2]=1;b[n+36>>1]=1;b[n+38>>1]=1;a[n+216>>0]=0;c[n+184>>2]=d;return}function Ch(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;j=e+1|0;k=d+36|0;h=c[k>>2]|0;if((h|0)<=(e|0)){l=fo(j<<2)|0;do if((e|0)>-1){g=d+32|0;if(!h){uo(l|0,0,((j|0)>1?j<<2:4)|0)|0;break}else i=0;do{if((i|0)<(h|0))c[l+(i<<2)>>2]=c[(c[g>>2]|0)+(i<<2)>>2];else c[l+(i<<2)>>2]=0;i=i+1|0}while((i|0)<(j|0))}else g=d+32|0;while(0);h=c[g>>2]|0;if(h)go(h);c[k>>2]=j;c[g>>2]=l}g=d+32|0;h=c[g>>2]|0;i=c[h+(e<<2)>>2]|0;if(i){if((c[i>>2]|0)==1){o=0;ja(28,i|0);l=o;o=0;if(l&1){d=kb()|0;Gl(i);qb(d|0)}o=0;ja(29,i|0);l=o;o=0;if(l&1){d=kb()|0;Gl(i);qb(d|0)}}Gl(i);h=c[g>>2]|0}g=El(660)|0;c[g>>2]=0;c[h+(e<<2)>>2]=g;c[g+32>>2]=e;c[g+28>>2]=1;c[g+280>>2]=-1;if((Bj(g,f)|0)<0){d=Rb(4)|0;c[d>>2]=13;ad(d|0,8,0)}else{e=c[g+4>>2]|0;c[g>>2]=1;c[g+168>>2]=0;c[g+164>>2]=0;c[g+152>>2]=e;Gh(g,0);c[g+188>>2]=-1;c[g+136>>2]=1;b[g+36>>1]=1;b[g+38>>1]=1;e=g+216|0;a[e>>0]=0;Pn(e,f,63)|0;c[g+184>>2]=d;return}}function Dh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=c[(c[a+32>>2]|0)+(b<<2)>>2]|0;if(!e){a=1;return a|0}if(!(c[e>>2]|0)){a=1;return a|0}switch(c[e+28>>2]|0){case 1:{Ch(a,b,d);a=0;return a|0}case 2:{a=0;return a|0}default:{a=Rb(4)|0;c[a>>2]=21;ad(a|0,8,0)}}return 0}function Eh(a,b){a=a|0;b=b|0;if((b|0)<0){a=Rb(4)|0;c[a>>2]=3;ad(a|0,8,0)}if((c[a+36>>2]|0)<=(b|0)){a=Rb(4)|0;c[a>>2]=3;ad(a|0,8,0)}b=c[(c[a+32>>2]|0)+(b<<2)>>2]|0;if(!b){a=Rb(4)|0;c[a>>2]=3;ad(a|0,8,0)}if(!(c[b>>2]|0)){a=Rb(4)|0;c[a>>2]=3;ad(a|0,8,0)}else return b|0;return 0}function Fh(a){a=a|0;var b=0,d=0,e=0;b=c[a+36>>2]|0;if((b|0)<=0){e=b;return e|0}a=c[a+32>>2]|0;e=0;while(1){d=c[a+(e<<2)>>2]|0;if(!d){b=e;a=6;break}if(!(c[d>>2]|0)){b=e;a=6;break}e=e+1|0;if((e|0)>=(b|0)){a=6;break}}if((a|0)==6)return b|0;return 0}function Gh(d,e){d=d|0;e=e|0;var f=0;e=d+568|0;f=e+63|0;do{a[e>>0]=0;e=e+1|0}while((e|0)<(f|0));c[d+632>>2]=18;c[d+636>>2]=0;zj(30178,18,0)|0;ki(d);b[d+284>>1]=0;b[d+286>>1]=0;c[d+288>>2]=0;c[d+68>>2]=0;c[d+72>>2]=0;c[d+104>>2]=-16777216;c[d+640>>2]=16777215;c[d+108>>2]=0;c[d+76>>2]=64;c[d+80>>2]=32;c[d+84>>2]=0;c[d+92>>2]=32;c[d+96>>2]=32;c[d+100>>2]=0;c[d+160>>2]=0;e=d+176|0;f=e;b[f>>1]=0;b[f+2>>1]=0>>>16;e=e+4|0;b[e>>1]=0;b[e+2>>1]=0>>>16;e=c[d+4>>2]|0;b[d+208>>1]=e;f=c[d+8>>2]|0;b[d+210>>1]=f;b[d+204>>1]=(e|0)/(e<<16>>16|0)|0;b[d+206>>1]=(f|0)/(f<<16>>16|0)|0;b[d+212>>1]=0;b[d+214>>1]=0;b[d+38>>1]=b[d+36>>1]|0;if(!(c[d+32>>2]|0))Wj(d);f=d+292|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[d+308>>2]=-2;c[d+312>>2]=0;c[d+316>>2]=0;c[d+320>>2]=0;c[d+324>>2]=-2;c[d+328>>2]=0;c[d+332>>2]=0;c[d+336>>2]=0;c[d+340>>2]=-2;c[d+344>>2]=0;c[d+348>>2]=0;c[d+352>>2]=0;c[d+356>>2]=-2;c[d+360>>2]=0;c[d+364>>2]=0;c[d+368>>2]=0;c[d+372>>2]=-2;c[d+376>>2]=0;c[d+380>>2]=0;c[d+384>>2]=0;c[d+388>>2]=-2;c[d+392>>2]=0;c[d+396>>2]=0;c[d+400>>2]=0;c[d+404>>2]=-2;c[d+408>>2]=0;c[d+412>>2]=0;c[d+416>>2]=0;c[d+420>>2]=-2;c[d+424>>2]=0;c[d+428>>2]=0;c[d+432>>2]=0;c[d+436>>2]=-2;c[d+440>>2]=0;c[d+444>>2]=0;c[d+448>>2]=0;c[d+452>>2]=-2;c[d+456>>2]=0;c[d+460>>2]=0;c[d+464>>2]=0;c[d+468>>2]=-2;c[d+472>>2]=0;c[d+476>>2]=0;c[d+480>>2]=0;c[d+484>>2]=-2;c[d+488>>2]=0;c[d+492>>2]=0;c[d+496>>2]=0;c[d+500>>2]=-2;c[d+504>>2]=0;c[d+508>>2]=0;c[d+512>>2]=0;c[d+516>>2]=-2;c[d+520>>2]=0;c[d+524>>2]=0;c[d+528>>2]=0;c[d+532>>2]=-2;c[d+536>>2]=0;c[d+540>>2]=0;c[d+544>>2]=0;c[d+548>>2]=-2;return}function Hh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;Pn(a+568|0,b,63)|0;c[a+632>>2]=d;c[a+636>>2]=e;zj(b,d,e)|0;return}function Ih(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+104>>2]=b<<16|d<<8&65280|e&255|-16777216;return}function Jh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+640>>2]=d<<8&65280|b<<16&16711680|e&255;return}function Kh(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;if((d|0)<=0)d=c[a+4>>2]|0;b[a+208>>1]=d;h=c[a+8>>2]|0;e=(e|0)>0?e:h;b[a+210>>1]=e;b[a+204>>1]=(c[a+4>>2]|0)/(d<<16>>16|0)|0;b[a+206>>1]=(h|0)/(e<<16>>16|0)|0;b[a+212>>1]=f;b[a+214>>1]=g;return}function Lh(a,b){a=a|0;b=b|0;return}function Mh(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return}function Nh(a,b){a=a|0;b=b|0;var d=0;d=c[a+84>>2]|0;a=a+72|0;c[a>>2]=((d|0)>(b|0)?d:b)+(c[a>>2]|0);return}function Oh(a,b){a=a|0;b=b|0;c[a+104>>2]=b;return}function Ph(a){a=a|0;var b=0,d=0,e=0,f=0;d=a+568|0;f=a+632|0;b=c[f>>2]|0;e=a+636|0;a=c[e>>2]|0;Pn(d,d,63)|0;c[f>>2]=b;c[e>>2]=a;zj(d,b,a)|0;return}function Qh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;zj(b,c,d)|0;return}function Rh(a,d){a=a|0;d=d|0;var e=0;Aj(a,d)|0;d=b[a+158>>1]|0;e=c[a+84>>2]|0;a=a+72|0;c[a>>2]=((e|0)>(d|0)?e:d)+(c[a>>2]|0);return}function Sh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;Hj(a,+(b|0),+(c|0),+(d|0),+(e|0));return}function Th(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0;e=+(b|0);d=+(c|0);Fj(a,e,d);Gj(e,d);Fj(0,0.0,0.0);return}function Uh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=a+68|0;e=a+72|0;Fj(a,+(c[f>>2]|0),+(c[e>>2]|0));Gj(+(b|0),+(d|0));Fj(0,0.0,0.0);c[f>>2]=b;c[e>>2]=d;return}function Vh(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;Ij(a,+(b|0),+(c|0),+(d|0),+(e|0),f);return}function Wh(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;h=f+d|0;j=g+e|0;if((h|0)<0){e=-1;return e|0}i=c[b+4>>2]|0;do if((h|0)>=(i|0))if((i|0)>(d|0)){i=i-d|0;break}else{e=-1;return e|0}else i=f;while(0);if((j|0)<0){e=-1;return e|0}h=c[b+8>>2]|0;do if((j|0)>=(h|0))if((h|0)>(e|0)){g=h-e|0;break}else{e=-1;return e|0}while(0);Lj(a,d&65535,e&65535,i&65535,g&65535,b,+(i|0),+(g|0));e=0;return e|0}function Xh(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0;j=h+f|0;l=i+g|0;if((j|0)<0){g=-1;return g|0}k=c[e+4>>2]|0;do if((j|0)>=(k|0))if((k|0)>(f|0)){k=k-f|0;break}else{g=-1;return g|0}else k=h;while(0);if((l|0)<0){g=-1;return g|0}j=c[e+8>>2]|0;do if((l|0)>=(j|0))if((j|0)>(g|0)){i=j-g|0;break}else{g=-1;return g|0}while(0);Lj(a,f&65535,g&65535,k&65535,i&65535,e,+(b|0),+(d|0));g=0;return g|0}function Yh(a,b){a=a|0;b=b|0;return 0}function Zh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;e=e&255;d=d&255;h=(b|0)%192|0;g=(h|0)%32|0;f=((($(8160-(d<<5)|0,e)|0)+4080|0)>>>0)/8160|0;b=(($(8160-($(g,d)|0)|0,e)|0)+4080|0)/8160|0;d=(($(8160-($(32-g|0,d)|0)|0,e)|0)+4080|0)/8160|0;switch((h|0)/32|0|0){case 5:{g=b;h=f;break}case 4:{g=e;h=f;e=d;break}case 1:{g=f;h=e;e=b;break}case 2:{g=d;h=e;e=f;break}case 3:{g=e;h=b;e=f;break}default:{g=f;h=d}}c[a+104>>2]=g&255|h<<8&65280|e<<16|-16777216;return}function _h(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0;k=i;i=i+48|0;n=k+32|0;m=k+16|0;l=k;c[n>>2]=b;c[m>>2]=d;e=e+b|0;c[n+4>>2]=e;c[m+4>>2]=d;c[n+8>>2]=e;d=f+d|0;c[m+8>>2]=d;c[n+12>>2]=b;c[m+12>>2]=d;g=(g|0)==0;c[l+12>>2]=g?h:j;c[l>>2]=h;c[l+8>>2]=j;c[l+4>>2]=g?j:h;Oj(a,n,m,l);i=k;return}function $h(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;k=i;i=i+16|0;j=k;if((h|0)>=0){Nj(a,b,d,e,f,g);i=k;return}if((h|0)==-257){Oj(a,b,d,f);i=k;return}else{g=c[a+104>>2]|0;c[j+12>>2]=g;c[j+8>>2]=g;c[j+4>>2]=g;c[j>>2]=g;Oj(a,b,d,j);i=k;return}}function ai(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;Jj(a,+(b|0),+(c|0),+(d|0),+(e|0),f);return}function bi(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;Mj(a,f&65535,g&65535,h&65535,i&65535,+(b>>1|0),+(c>>1|0),e,+(b|0),+(c|0),d);return}function ci(a,d,e,f,g,h){a=a|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0;j=b[d+208>>1]|0;m=b[d+210>>1]|0;l=b[d+204>>1]|0;n=$((e|0)%(l|0)|0,j)|0;l=$((e|0)/(l|0)|0,m)|0;e=n+j|0;k=l+m|0;if((e|0)<0){a=-1;return a|0}i=c[d+4>>2]|0;do if((e|0)>=(i|0))if((i|0)>(n|0)){i=i-n|0;break}else{a=-1;return a|0}else i=j;while(0);if((k|0)<0){a=-1;return a|0}e=c[d+8>>2]|0;do if((k|0)>=(e|0))if((e|0)>(l|0)){e=e-l|0;break}else{a=-1;return a|0}else e=m;while(0);p=+(i|0)*f;j=a+68|0;o=(c[j>>2]|0)+~~p|0;m=a+72|0;k=c[m>>2]|0;Mj(a,n&65535,l&65535,i&65535,e&65535,+(b[d+212>>1]|0)*f,+(b[d+214>>1]|0)*g,d,p,+(e|0)*g,h);c[j>>2]=o;c[m>>2]=k;a=0;return a|0}function di(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;g=b[d+208>>1]|0;j=b[d+210>>1]|0;i=b[d+204>>1]|0;k=$((e|0)%(i|0)|0,g)|0;i=$((e|0)/(i|0)|0,j)|0;e=k+g|0;h=i+j|0;if((e|0)<0){a=-1;return a|0}f=c[d+4>>2]|0;do if((e|0)>=(f|0))if((f|0)>(k|0)){f=f-k|0;break}else{a=-1;return a|0}else f=g;while(0);if((h|0)<0){a=-1;return a|0}e=c[d+8>>2]|0;do if((h|0)>=(e|0))if((e|0)>(i|0)){e=e-i|0;break}else{a=-1;return a|0}else e=j;while(0);g=a+68|0;l=c[g>>2]|0;j=a+72|0;h=c[j>>2]|0;c[g>>2]=l-(b[d+212>>1]|0);c[j>>2]=h-(b[d+214>>1]|0);Lj(a,k&65535,i&65535,f&65535,e&65535,d,+(f|0),+(e|0));c[g>>2]=l+f;c[j>>2]=h;a=0;return a|0}function ei(a,b){a=a|0;b=b|0;wj(b,0);return}function fi(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=gi(a,b)|0;if(!g){g=a+296|0;if(c[g>>2]|0){g=a+312|0;if(c[g>>2]|0){g=a+328|0;if(c[g>>2]|0){g=a+344|0;if(c[g>>2]|0){g=a+360|0;if(c[g>>2]|0){g=a+376|0;if(c[g>>2]|0){g=a+392|0;if(c[g>>2]|0){g=a+408|0;if(c[g>>2]|0){g=a+424|0;if(c[g>>2]|0){g=a+440|0;if(c[g>>2]|0){g=a+456|0;if(c[g>>2]|0){g=a+472|0;if(c[g>>2]|0){g=a+488|0;if(c[g>>2]|0){g=a+504|0;if(c[g>>2]|0){g=a+520|0;if(c[g>>2]|0){g=a+536|0;if(c[g>>2]|0)return}}}}}}}}}}}}}}}c[g+12>>2]=b}if(f){c[g>>2]=1;c[g+4>>2]=d;c[g+8>>2]=e;return}else{c[g>>2]=0;return}}function gi(a,b){a=a|0;b=b|0;var d=0;d=a+296|0;if((c[d>>2]|0)!=0?(c[a+308>>2]|0)==(b|0):0){a=d;return a|0}d=a+312|0;if((c[d>>2]|0)!=0?(c[a+324>>2]|0)==(b|0):0){a=d;return a|0}d=a+328|0;if((c[d>>2]|0)!=0?(c[a+340>>2]|0)==(b|0):0){a=d;return a|0}d=a+344|0;if((c[d>>2]|0)!=0?(c[a+356>>2]|0)==(b|0):0){a=d;return a|0}d=a+360|0;if((c[d>>2]|0)!=0?(c[a+372>>2]|0)==(b|0):0){a=d;return a|0}d=a+376|0;if((c[d>>2]|0)!=0?(c[a+388>>2]|0)==(b|0):0){a=d;return a|0}d=a+392|0;if((c[d>>2]|0)!=0?(c[a+404>>2]|0)==(b|0):0){a=d;return a|0}d=a+408|0;if((c[d>>2]|0)!=0?(c[a+420>>2]|0)==(b|0):0){a=d;return a|0}d=a+424|0;if((c[d>>2]|0)!=0?(c[a+436>>2]|0)==(b|0):0){a=d;return a|0}d=a+440|0;if((c[d>>2]|0)!=0?(c[a+452>>2]|0)==(b|0):0){a=d;return a|0}d=a+456|0;if((c[d>>2]|0)!=0?(c[a+468>>2]|0)==(b|0):0){a=d;return a|0}d=a+472|0;if((c[d>>2]|0)!=0?(c[a+484>>2]|0)==(b|0):0){a=d;return a|0}d=a+488|0;if((c[d>>2]|0)!=0?(c[a+500>>2]|0)==(b|0):0){a=d;return a|0}d=a+504|0;if((c[d>>2]|0)!=0?(c[a+516>>2]|0)==(b|0):0){a=d;return a|0}d=a+520|0;if((c[d>>2]|0)!=0?(c[a+532>>2]|0)==(b|0):0){a=d;return a|0}d=a+536|0;if((c[d>>2]|0)!=0?(c[a+548>>2]|0)==(b|0):0){a=d;return a|0}a=0;return a|0}function hi(a,b){a=a|0;b=b|0;return (b>>>0>15?0:a+296+(b<<4)|0)|0}function ii(a,b){a=a|0;b=b|0;var d=0,e=0;e=a+292|0;c[e>>2]=0;if(!(c[a+296>>2]|0))d=0;else{c[b>>2]=0;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+312>>2]|0){c[b>>2]=1;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+328>>2]|0){c[b>>2]=2;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+344>>2]|0){c[b>>2]=3;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+360>>2]|0){c[b>>2]=4;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+376>>2]|0){c[b>>2]=5;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+392>>2]|0){c[b>>2]=6;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+408>>2]|0){c[b>>2]=7;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+424>>2]|0){c[b>>2]=8;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+440>>2]|0){c[b>>2]=9;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+456>>2]|0){c[b>>2]=10;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+472>>2]|0){c[b>>2]=11;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+488>>2]|0){c[b>>2]=12;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+504>>2]|0){c[b>>2]=13;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+520>>2]|0){c[b>>2]=14;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(!(c[a+536>>2]|0)){a=d;return a|0}c[b>>2]=15;a=(c[e>>2]|0)+1|0;c[e>>2]=a;return a|0}function ji(a){a=a|0;c[846]=a;return}function ki(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0;i=a+164|0;d=c[i>>2]|0;h=a+168|0;if(!d){c[i>>2]=0;c[h>>2]=0;a=a+172|0;c[a>>2]=128;return}e=c[h>>2]|0;if((e|0)>0){d=e;g=0;do{e=c[i>>2]|0;f=e+(g*52|0)|0;if(b[f>>1]|0){d=c[e+(g*52|0)+48>>2]|0;if(d)od[d&63](f);d=e+(g*52|0)+32|0;e=c[d>>2]|0;if(e){Hi(e);c[d>>2]=0}b[f>>1]=0;d=c[h>>2]|0}g=g+1|0}while((g|0)<(d|0));d=c[i>>2]|0}Hi(d);c[i>>2]=0;c[h>>2]=0;a=a+172|0;c[a>>2]=128;return}function li(a,d){a=a|0;d=d|0;var e=0,f=0;if((d|0)<0){f=Rb(4)|0;c[f>>2]=3;ad(f|0,8,0)}if((c[a+168>>2]|0)<=(d|0)){f=Rb(4)|0;c[f>>2]=3;ad(f|0,8,0)}e=c[a+164>>2]|0;f=e+(d*52|0)|0;if(!(b[f>>1]|0))return;a=c[e+(d*52|0)+48>>2]|0;if(a)od[a&63](f);a=e+(d*52|0)+32|0;e=c[a>>2]|0;if(e){Hi(e);c[a>>2]=0}b[f>>1]=0;return}function mi(a,d,e){a=a|0;d=d|0;e=e|0;if((d|0)>=0?(c[a+168>>2]|0)>(d|0):0){a=c[a+164>>2]|0;if(!(b[a+(d*52|0)>>1]|0)){e=Rb(4)|0;c[e>>2]=3;ad(e|0,8,0)}else{b[a+(d*52|0)+2>>1]=e;return}}e=Rb(4)|0;c[e>>2]=3;ad(e|0,8,0)}function ni(a,d,e){a=a|0;d=d|0;e=e|0;if((d|0)<0){e=Rb(4)|0;c[e>>2]=3;ad(e|0,8,0)}if((c[a+168>>2]|0)<=(d|0)){e=Rb(4)|0;c[e>>2]=3;ad(e|0,8,0)}d=(c[a+164>>2]|0)+(d*52|0)|0;if(!(b[d>>1]|0)){e=Rb(4)|0;c[e>>2]=3;ad(e|0,8,0)}if((e|0)<1){e=Rb(4)|0;c[e>>2]=3;ad(e|0,8,0)}else{b[d>>1]=e;return}}function oi(a){a=a|0;var d=0,e=0,f=0,g=0,h=0;e=a+164|0;f=c[e>>2]|0;if(!f){c[e>>2]=Fi(52)|0;a=a+168|0;c[a>>2]=(c[a>>2]|0)+1;a=0;return a|0}g=a+168|0;h=c[g>>2]|0;a:do if((h|0)>0){d=0;while(1){if(!(b[f+(d*52|0)>>1]|0))break;d=d+1|0;if((d|0)>=(h|0))break a}return d|0}while(0);if((h|0)>=(c[a+172>>2]|0)){a=Rb(4)|0;c[a>>2]=33;ad(a|0,8,0)}a=h+1|0;c[g>>2]=a;c[e>>2]=Ii(f,a*52|0)|0;a=h;return a|0}function pi(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=oi(a)|0;i=c[a+164>>2]|0;c[i+(g*52|0)+8>>2]=0;b[i+(g*52|0)>>1]=1;b[i+(g*52|0)+2>>1]=1;c[i+(g*52|0)+4>>2]=a;k=i+(g*52|0)+32|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;b[i+(g*52|0)+20>>1]=c[a+68>>2];b[i+(g*52|0)+22>>1]=c[a+72>>2];b[i+(g*52|0)+24>>1]=c[a+76>>2];h=a+80|0;b[i+(g*52|0)+26>>1]=c[h>>2];b[i+(g*52|0)+28>>1]=0;b[i+(g*52|0)+30>>1]=-1;c[i+(g*52|0)+12>>2]=-1;c[i+(g*52|0)+16>>2]=g;j=Fi(88)|0;c[k>>2]=j;Pn(j,d,63)|0;b[j+80>>1]=e;c[j+84>>2]=f;b[j+64>>1]=-1;b[j+66>>1]=-1;c[i+(g*52|0)+36>>2]=30;c[i+(g*52|0)+40>>2]=40;Nh(a,c[h>>2]|0);return g|0}function qi(a,d,e,f,g,h,i,j,k){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;if((d|0)<0){k=Rb(4)|0;c[k>>2]=3;ad(k|0,8,0)}if((c[a+168>>2]|0)<=(d|0)){k=Rb(4)|0;c[k>>2]=3;ad(k|0,8,0)}a=c[a+164>>2]|0;if((c[a+(d*52|0)+40>>2]|0)!=40){k=Rb(4)|0;c[k>>2]=21;ad(k|0,8,0)}b[a+(d*52|0)+30>>1]=e;a=c[a+(d*52|0)+32>>2]|0;if(!a)return;b[a+68>>1]=f;b[a+70>>1]=g;b[a+72>>1]=h;b[a+74>>1]=i;b[a+76>>1]=j;b[a+78>>1]=k;return}function ri(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0;e=c[a+164>>2]|0;if(!e)return -1;h=c[a+640>>2]|0;Jh(a,255,255,255);i=a+168|0;d=c[i>>2]|0;if((d|0)>0){f=0;while(1){if((b[e>>1]|0)!=0?(g=c[e+36>>2]|0,(g|0)!=0):0){od[g&63](e);d=c[i>>2]|0}f=f+1|0;if((f|0)>=(d|0))break;else e=e+52|0}}Jh(a,h>>>16&255,h>>>8&255,h&255);return -1}function si(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;f=c[a+164>>2]|0;if(!f)return -1;j=b[a+176>>1]|0;m=b[a+178>>1]|0;n=a+286|0;if(b[n>>1]|0){if(b[a+284>>1]|0)return -1;b[n>>1]=0;return -1}o=a+288|0;e=c[o>>2]|0;if(e){n=m-(b[e+22>>1]|0)|0;if((((n|0)>-1?(n|0)<(b[e+26>>1]|0):0)?(d=j-(b[e+20>>1]|0)|0,(d|0)>-1):0)?(d|0)<(b[e+24>>1]|0):0)d=b[a+284>>1]|0;else d=-1;b[e+28>>1]=d;if(b[a+284>>1]|0)return -1;c[o>>2]=0;if((d|0)<=-1)return -1;qd[c[e+40>>2]&63](e,d);return -1}h=c[a+168>>2]|0;i=a+284|0;if((h|0)>0){e=0;d=0;g=0;a=f;while(1){if((((((b[a>>1]|0)!=0?(c[a+40>>2]|0)!=0:0)?(k=m-(b[a+22>>1]|0)|0,(k|0)>-1):0)?(k|0)<(b[a+26>>1]|0):0)?(l=j-(b[a+20>>1]|0)|0,(l|0)>-1):0)?(l|0)<(b[a+24>>1]|0):0){e=a;d=b[i>>1]|0}g=g+1|0;if((g|0)>=(h|0))break;else a=a+52|0}}else{e=0;d=0}if((b[i>>1]|0)!=1)return -1;if(!e){b[n>>1]=1;return -1}else{b[n>>1]=0;c[o>>2]=e;b[e+28>>1]=d;return -1}return 0}function ti(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;r=c[a+4>>2]|0;Qh(r,30178,18,0);l=a+20|0;j=b[l>>1]|0;q=a+22|0;k=b[q>>1]|0;n=a+24|0;g=j+-1+(b[n>>1]|0)|0;o=a+26|0;h=k+-1+(b[o>>1]|0)|0;s=a+32|0;p=c[s>>2]|0;m=p+64|0;if((b[m>>1]|0)<0){c[r+100>>2]=3;c[r+144>>2]=0;c[r+68>>2]=j;c[r+72>>2]=k;Oh(r,0);Rh(r,c[s>>2]|0);b[m>>1]=b[r+156>>1]|0;b[p+66>>1]=b[r+158>>1]|0}f=a+30|0;if((b[f>>1]|0)<0){if(!(b[a+2>>1]|0)){e=-8355712;f=-10461088;d=-12566464}else{e=(b[a+28>>1]|0)==1?-7303024:-986896;f=-4144960;d=-16777216}i=r+100|0;c[i>>2]=0;u=r+144|0;c[u>>2]=255;_h(r,j+1|0,k+1|0,(b[n>>1]|0)+-2|0,(b[o>>1]|0)+-2|0,1,e,f);Oh(r,-8355712);t=r+68|0;c[t>>2]=j;f=r+72|0;c[f>>2]=k;Uh(r,g,k);Uh(r,g,h);Uh(r,j,h);Uh(r,j,k);e=u;g=t;h=f;f=i}else{d=b[p+68>>1]|0;e=b[p+70>>1]|0;if(b[a+2>>1]|0)if((b[a+28>>1]|0)==1){d=b[p+72>>1]|0;e=b[p+74>>1]|0;i=-16777216}else i=-16777216;else i=-8355712;u=r+100|0;c[u>>2]=3;t=r+144|0;c[t>>2]=255;Oh(r,i);g=r+68|0;c[g>>2]=j;h=r+72|0;c[h>>2]=k;f=Eh(c[r+184>>2]|0,b[f>>1]|0)|0;Wh(r,f,d,e,b[n>>1]|0,b[o>>1]|0)|0;e=t;f=u;d=i}c[f>>2]=3;c[e>>2]=255;Oh(r,d);e=(((b[n>>1]|0)-(b[m>>1]|0)|0)/2|0)+(b[l>>1]|0)|0;c[g>>2]=e;d=(((b[o>>1]|0)-(b[p+66>>1]|0)|0)/2|0)+(b[q>>1]|0)|0;c[h>>2]=d;if((b[a+28>>1]|0)!=1){u=c[s>>2]|0;Rh(r,u);return}c[g>>2]=e+1;c[h>>2]=d+1;u=c[s>>2]|0;Rh(r,u);return}function ui(a,d){a=a|0;d=d|0;if(!(b[a+2>>1]|0))return;c[c[846]>>2]=c[a+16>>2];d=c[a+32>>2]|0;a=c[d+84>>2]|0;if(!(b[d+80>>1]&1)){ze(a);return}else{Ae(a);return}}function vi(){var a=0,d=0;c[847]=512;d=fo(40960)|0;c[848]=d;c[850]=d+40960;c[849]=d;a=0;while(1){b[d>>1]=4;b[d+2>>1]=0;c[d+4>>2]=d+16;a=a+1|0;if((a|0)>=512)break;else d=d+80|0}return}function wi(){var a=0,d=0,e=0,f=0;e=c[849]|0;d=c[848]|0;if((e|0)==(d|0)){f=d;go(f);return}else a=d;do{f=e+-80|0;c[849]=f;if(!(b[e+-78>>1]|0))e=f;else{go(c[e+-76>>2]|0);a=c[849]|0;b[a+2>>1]=0;c[a+4>>2]=a+16;a=c[848]|0;d=a;e=c[849]|0}}while((e|0)!=(d|0));go(a);return}function xi(){var a=0,d=0,e=0;d=c[849]|0;a=c[848]|0;if((d|0)==(a|0))return;do{e=d+-80|0;c[849]=e;if(!(b[d+-78>>1]|0))d=e;else{go(c[d+-76>>2]|0);a=c[849]|0;b[a+2>>1]=0;c[a+4>>2]=a+16;a=c[848]|0;d=c[849]|0}}while((d|0)!=(a|0));return}function yi(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0;h=c[849]|0;if(h>>>0>=(c[850]|0)>>>0){g=Rb(4)|0;c[g>>2]=29;ad(g|0,8,0)}b[h>>1]=e;switch(e|0){case 4:case 1:{c[h+16>>2]=c[f>>2];c[849]=h+80;return}case 3:{i=f;i=d[i>>0]|d[i+1>>0]<<8|d[i+2>>0]<<16|d[i+3>>0]<<24;f=f+4|0;f=d[f>>0]|d[f+1>>0]<<8|d[f+2>>0]<<16|d[f+3>>0]<<24;g=h+16|0;e=g;a[e>>0]=i;a[e+1>>0]=i>>8;a[e+2>>0]=i>>16;a[e+3>>0]=i>>24;g=g+4|0;a[g>>0]=f;a[g+1>>0]=f>>8;a[g+2>>0]=f>>16;a[g+3>>0]=f>>24;c[849]=h+80;return}default:{if((g|0)<65)h=c[h+4>>2]|0;else{b[h+2>>1]=1;i=fo(g)|0;c[h+4>>2]=i;h=i}so(h|0,f|0,g|0)|0;c[849]=(c[849]|0)+80;return}}}function zi(e,f){e=e|0;f=f|0;var g=0,h=0,i=0;h=(Mn(f)|0)+1|0;g=c[849]|0;if(g>>>0>=(c[850]|0)>>>0){f=Rb(4)|0;c[f>>2]=29;ad(f|0,8,0)}b[g>>1]=e;switch(e|0){case 4:case 1:{c[g+16>>2]=c[f>>2];c[849]=g+80;return}case 3:{h=f;i=h;i=d[i>>0]|d[i+1>>0]<<8|d[i+2>>0]<<16|d[i+3>>0]<<24;h=h+4|0;h=d[h>>0]|d[h+1>>0]<<8|d[h+2>>0]<<16|d[h+3>>0]<<24;f=g+16|0;e=f;a[e>>0]=i;a[e+1>>0]=i>>8;a[e+2>>0]=i>>16;a[e+3>>0]=i>>24;f=f+4|0;a[f>>0]=h;a[f+1>>0]=h>>8;a[f+2>>0]=h>>16;a[f+3>>0]=h>>24;c[849]=g+80;return}default:{if((h|0)<65)g=c[g+4>>2]|0;else{b[g+2>>1]=1;i=fo(h)|0;c[g+4>>2]=i;g=i}so(g|0,f|0,h|0)|0;c[849]=(c[849]|0)+80;return}}}function Ai(a,d){a=a|0;d=d|0;var e=0;e=c[849]|0;if(e>>>0>=(c[850]|0)>>>0){a=Rb(4)|0;c[a>>2]=29;ad(a|0,8,0)}b[e>>1]=a;if((d|0)<65){a=e+4|0;d=e;d=d+80|0;c[849]=d;a=c[a>>2]|0;return a|0}else{b[e+2>>1]=1;a=e+4|0;c[a>>2]=fo(d)|0;d=c[849]|0;d=d+80|0;c[849]=d;a=c[a>>2]|0;return a|0}return 0}function Bi(){var a=0;go(c[(c[849]|0)+4>>2]|0);a=c[849]|0;b[a+2>>1]=0;c[a+4>>2]=a+16;return}function Ci(){c[851]=0;c[852]=0;c[853]=1024;Ni();return}function Di(){var a=0,d=0,e=0,f=0;if((c[851]|0)>0)e=0;else{f=c[854]|0;go(f);return}do{f=c[854]|0;a=c[f+(e<<3)>>2]|0;f=c[f+(e<<3)+4>>2]|0;d=a+(f*88|0)|0;if((f|0)>0){f=a;do{if((b[f>>1]|0)==2)go(c[f+16>>2]|0);f=f+88|0}while(f>>>0<d>>>0)}go(a);e=e+1|0}while((e|0)<(c[851]|0));f=c[854]|0;go(f);return}function Ei(a){a=a|0;return a+-24|0}function Fi(a){a=a|0;var d=0,e=0,f=0;e=(a|0)<64?64:a;a=c[852]|0;if(!a){Ni();a=c[852]|0}d=a+16|0;c[852]=c[d>>2];if((e|0)<65){b[a>>1]=1;c[a+8>>2]=64;e=a+24|0;c[a+12>>2]=e;c[e>>2]=0;return e|0}else{b[a>>1]=2;c[a+8>>2]=e;f=fo(e+24|0)|0;e=f+24|0;c[d>>2]=f;c[a+12>>2]=e;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];c[f+16>>2]=c[a+16>>2];c[f+20>>2]=c[a+20>>2];c[e>>2]=0;return e|0}return 0}function Gi(a){a=a|0;var d=0,e=0,f=0,g=0;f=(a|0)<64?64:a;d=c[852]|0;if(!d){Ni();d=c[852]|0}e=d+16|0;c[852]=c[e>>2];if((f|0)<65){b[d>>1]=1;c[d+8>>2]=64;f=d+24|0;c[d+12>>2]=f;c[f>>2]=0;uo(f|0,0,a|0)|0;return f|0}else{b[d>>1]=2;c[d+8>>2]=f;g=fo(f+24|0)|0;f=g+24|0;c[e>>2]=g;c[d+12>>2]=f;c[g>>2]=c[d>>2];c[g+4>>2]=c[d+4>>2];c[g+8>>2]=c[d+8>>2];c[g+12>>2]=c[d+12>>2];c[g+16>>2]=c[d+16>>2];c[g+20>>2]=c[d+20>>2];c[f>>2]=0;uo(f|0,0,a|0)|0;return f|0}return 0}function Hi(a){a=a|0;var d=0;d=c[a+-20>>2]|0;if((c[d+12>>2]|0)!=(a|0))return;a=d+16|0;if((b[d>>1]|0)==2)go(c[a>>2]|0);c[a>>2]=c[852];c[852]=d;b[d>>1]=0;return}function Ii(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=c[a+-20>>2]|0;f=e+8|0;a=c[f>>2]|0;if((a|0)>=(d|0)){d=c[e+12>>2]|0;return d|0}g=fo(d+24|0)|0;h=g+24|0;i=e+12|0;so(h|0,c[i>>2]|0,a|0)|0;a=e+16|0;if((b[e>>1]|0)==2)go(c[a>>2]|0);c[f>>2]=d;b[e>>1]=2;c[i>>2]=h;c[a>>2]=g;c[g>>2]=c[e>>2];c[g+4>>2]=c[e+4>>2];c[g+8>>2]=c[e+8>>2];c[g+12>>2]=c[e+12>>2];c[g+16>>2]=c[e+16>>2];c[g+20>>2]=c[e+20>>2];d=h;return d|0}function Ji(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=Mn(d)|0;l=f+1|0;e=c[a>>2]|0;if((c[e+-16>>2]|0)>=(l|0)){a=c[e+-12>>2]|0;so(a|0,d|0,l|0)|0;return}j=c[e+-20>>2]|0;k=j+8|0;i=c[k>>2]|0;if((i|0)<(l|0)){g=fo(f+25|0)|0;e=g+24|0;h=j+12|0;so(e|0,c[h>>2]|0,i|0)|0;f=j+16|0;if((b[j>>1]|0)==2)go(c[f>>2]|0);c[k>>2]=l;b[j>>1]=2;c[h>>2]=e;c[f>>2]=g;c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];c[g+16>>2]=c[j+16>>2];c[g+20>>2]=c[j+20>>2]}else e=c[j+12>>2]|0;c[a>>2]=e;a=e;so(a|0,d|0,l|0)|0;return}function Ki(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=(Mn(d)|0)+1|0;g=c[a>>2]|0;e=c[g+-12>>2]|0;m=Mn(e)|0;f=m+l|0;if((f|0)<=(c[g+-16>>2]|0)){a=e;a=a+m|0;so(a|0,d|0,l|0)|0;return}k=f+4095&-4096;g=c[g+-20>>2]|0;h=g+8|0;f=c[h>>2]|0;if((f|0)<(k|0)){i=fo(k|24)|0;e=i+24|0;j=g+12|0;so(e|0,c[j>>2]|0,f|0)|0;f=g+16|0;if((b[g>>1]|0)==2)go(c[f>>2]|0);c[h>>2]=k;b[g>>1]=2;c[j>>2]=e;c[f>>2]=i;c[i>>2]=c[g>>2];c[i+4>>2]=c[g+4>>2];c[i+8>>2]=c[g+8>>2];c[i+12>>2]=c[g+12>>2];c[i+16>>2]=c[g+16>>2];c[i+20>>2]=c[g+20>>2]}else e=c[g+12>>2]|0;c[a>>2]=e;a=e;a=a+m|0;so(a|0,d|0,l|0)|0;return}function Li(a){a=a|0;return c[a+-4>>2]|0}function Mi(a,b){a=a|0;b=b|0;c[a+-4>>2]=b;c[(c[a+-20>>2]|0)+20>>2]=b;return}function Ni(){var a=0,d=0,e=0,f=0,g=0;a=c[851]|0;if(!a)e=fo(8)|0;else e=io(c[854]|0,(a<<3)+8|0)|0;c[854]=e;d=c[853]|0;a=fo(d*88|0)|0;if(!a){f=Rb(4)|0;c[f>>2]=26;ad(f|0,8,0)}f=a+(d*88|0)|0;g=c[851]|0;c[e+(g<<3)>>2]=a;c[(c[854]|0)+(g<<3)+4>>2]=d;c[851]=(c[851]|0)+1;c[853]=~~(+(c[853]|0)*1.8);if(a>>>0>=f>>>0)return;do{c[a+4>>2]=a;b[a>>1]=0;c[a+16>>2]=c[852];c[852]=a;a=a+88|0}while(a>>>0<f>>>0);return}function Oi(b){b=b|0;c[b>>2]=0;a[b+24>>0]=0;return}function Pi(a){a=a|0;return}function Qi(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Ri(a){a=a|0;return Mn(c[a>>2]|0)|0}function Si(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;g=c[b>>2]|0;j=b+4|0;c[j>>2]=0;k=b+8|0;c[k>>2]=g;e=g;a:do if((d|0)<0){f=Mn(g)|0;if(f){e=g+f|0;c[k>>2]=e;switch(a[g+(f+-1)>>0]|0){case 13:case 10:break;default:break a}c[j>>2]=1}}else{do if(d){e=g;f=0;b:while(1){g=e;c:while(1){h=a[g>>0]|0;if(!(h<<24>>24)){i=15;break b}e=g+1|0;c[k>>2]=e;switch(h<<24>>24){case 10:{i=9;break c}case 13:break c;default:g=e}}if((i|0)==9){i=0;f=f+1|0;if((f|0)==(d|0)){i=13;break}else continue}if((a[e>>0]|0)==10){e=g+2|0;c[k>>2]=e}f=f+1|0;if((f|0)==(d|0)){i=13;break}}if((i|0)==13)break;else if((i|0)==15){e=b+24|0;c[k>>2]=e;break a}}while(0);c[j>>2]=1}while(0);g=b+12|0;c[g>>2]=e;f=e;d:while(1){e=a[f>>0]|0;switch(e<<24>>24){case 10:case 13:case 0:break d;default:{}}j=f+1|0;c[g>>2]=j;f=j}a[b+16>>0]=e;a[f>>0]=0;return c[k>>2]|0}function Ti(b){b=b|0;a[c[b+12>>2]>>0]=a[b+16>>0]|0;return}function Ui(b){b=b|0;var d=0,e=0,f=0,g=0;d=c[b>>2]|0;g=b+8|0;c[g>>2]=d;b=d;d=1;a:while(1){e=b;b=0;b:while(1){f=e+1|0;c[g>>2]=f;switch(a[e>>0]|0){case 0:break a;case 10:case 13:{b=f;break b}default:{}}e=f;b=b+1|0}if((a[b>>0]|0)==10){b=e+2|0;c[g>>2]=b}d=d+1|0}return (((b|0)==0)<<31>>31)+d|0}function Vi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=c[b>>2]|0;k=b+4|0;c[k>>2]=0;o=b+8|0;c[o>>2]=g;a:do if((e|0)<0){h=Mn(g)|0;if(h){i=g+h|0;c[o>>2]=i;switch(a[g+(h+-1)>>0]|0){case 13:case 10:{c[k>>2]=1;g=i;break a}default:{}}if(h){g=g+(Mn(g)|0)|0;a[g>>0]=10;a[g+1>>0]=0;g=(c[o>>2]|0)+2|0;c[o>>2]=g}}}else{b:do if(e){h=0;c:while(1){i=g;d:while(1){j=a[i>>0]|0;if(!(j<<24>>24)){g=1;break c}g=i+1|0;c[o>>2]=g;switch(j<<24>>24){case 10:{n=9;break d}case 13:break d;default:i=g}}if((n|0)==9){n=0;h=h+1|0;if((h|0)==(e|0))break b;else continue}if((a[g>>0]|0)==10){g=i+2|0;c[o>>2]=g}h=h+1|0;if((h|0)==(e|0))break b}return g|0}while(0);c[k>>2]=1}while(0);m=(d|0)==0;h=m?30178:d;if(!m){g=h+(Mn(h)|0)|0;a[g>>0]=10;a[g+1>>0]=0;g=c[o>>2]|0}l=Mn(h)|0;b=c[b>>2]|0;m=Mn(b)|0;d=b+1+m-g|0;if(!f){k=0;e=l}else{i=0;j=g;e:while(1){k=j+1|0;j=a[j>>0]|0;if(!(j<<24>>24))break;e=i+1|0;switch(j<<24>>24){case 10:case 13:{j=k;n=21;break e}default:{i=e;j=k}}}if((n|0)==21)i=(a[j>>0]|0)==10?i+2|0:e;d=d-i|0;k=i;e=l-i|0;d=(d|0)<1?1:d}i=(d|0)>0;if((e|0)>-1){if(i){j=0;i=b+(e+m)|0;g=b+m|0;while(1){a[i>>0]=a[g>>0]|0;j=j+1|0;if((j|0)==(d|0))break;else{i=i+-1|0;g=g+-1|0}}}}else if(i){j=0;i=g+(e+k)|0;g=g+k|0;while(1){a[i>>0]=a[g>>0]|0;j=j+1|0;if((j|0)==(d|0))break;else{i=i+1|0;g=g+1|0}}}g=a[h>>0]|0;if(!(g<<24>>24)){o=0;return o|0}do{h=h+1|0;n=c[o>>2]|0;c[o>>2]=n+1;a[n>>0]=g;g=a[h>>0]|0}while(g<<24>>24!=0);g=0;return g|0}function Wi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=c[b>>2]|0;j=b+8|0;c[j>>2]=h;k=b+20|0;c[k>>2]=h;i=b+16|0;b=h;a:do if(!e){f=b;b=0;while(1){g=f;h=0;b:while(1){switch(a[g>>0]|0){case 0:{g=b;b=h;h=38;break a}case 10:{f=g;g=h;h=9;break b}case 13:{f=h;h=3;break b}default:{}}l=g+1|0;c[j>>2]=l;g=l;h=h+1|0}if((h|0)==3){if(f){a[i>>0]=13;a[g>>0]=0;if(!(Jn(c[k>>2]|0,d)|0)){h=32;break a}a[c[j>>2]>>0]=a[i>>0]|0;g=c[j>>2]|0}f=g+1|0;c[j>>2]=f;if((a[f>>0]|0)==10){f=g+2|0;c[j>>2]=f}c[k>>2]=f}else if((h|0)==9){if(g){a[i>>0]=10;a[f>>0]=0;if(!(Jn(c[k>>2]|0,d)|0)){h=23;break a}a[c[j>>2]>>0]=a[i>>0]|0;f=c[j>>2]|0}f=f+1|0;c[j>>2]=f;c[k>>2]=f}b=b+1|0}}else{f=b;b=0;while(1){g=f;h=0;c:while(1){switch(a[g>>0]|0){case 0:{g=b;b=h;h=38;break a}case 10:{f=g;g=h;h=18;break c}case 13:{f=h;h=27;break c}default:{}}l=g+1|0;c[j>>2]=l;g=l;h=h+1|0}if((h|0)==18){if(g){a[i>>0]=10;a[f>>0]=0;switch(e|0){case 2:{if(hl(c[k>>2]|0,d)|0){h=23;break a}break}case 1:{l=hl(c[k>>2]|0,d)|0;if((l|0)!=0?(l|0)==(c[k>>2]|0):0){h=23;break a}break}default:{}}a[c[j>>2]>>0]=a[i>>0]|0;f=c[j>>2]|0}f=f+1|0;c[j>>2]=f;c[k>>2]=f}else if((h|0)==27){if(f){a[i>>0]=13;a[g>>0]=0;switch(e|0){case 2:{if(hl(c[k>>2]|0,d)|0){h=32;break a}break}case 1:{l=hl(c[k>>2]|0,d)|0;if((l|0)!=0?(l|0)==(c[k>>2]|0):0){h=32;break a}break}default:{}}a[c[j>>2]>>0]=a[i>>0]|0;g=c[j>>2]|0}f=g+1|0;c[j>>2]=f;if((a[f>>0]|0)==10){f=g+2|0;c[j>>2]=f}c[k>>2]=f}b=b+1|0}}while(0);if((h|0)==23){a[c[j>>2]>>0]=a[i>>0]|0;l=b;return l|0}else if((h|0)==32){a[c[j>>2]>>0]=a[i>>0]|0;l=b;return l|0}else if((h|0)==38){if(!b){l=-1;return l|0}switch(e|0){case 0:{if(Jn(f,d)|0){l=-1;return l|0}break}case 1:{b=hl(f,d)|0;if(!b){l=-1;return l|0}if((b|0)!=(c[k>>2]|0)){l=-1;return l|0}break}case 2:{if(!(hl(f,d)|0)){l=-1;return l|0}break}default:{l=-1;return l|0}}l=g;return l|0}return 0}function Xi(a,b){a=a|0;b=b|0;if(a>>>0>46)return;c[3420+(a<<2)>>2]=b;g[3608+(a<<2)>>2]=+(b|0);return}function Yi(a){a=a|0;if((a|0)==34){a=Qj()|0;return a|0}else{a=c[3420+(a<<2)>>2]|0;return a|0}return 0}function Zi(){uo(3420,0,184)|0;uo(3608,0,184)|0;c[856]=128;c[857]=1024;c[858]=128;c[859]=4096;c[867]=1048576;c[868]=256;c[871]=16;c[881]=16;c[883]=1024;c[873]=1;c[884]=1;c[874]=2;c[893]=128;c[901]=64;g[948]=64.0;c[890]=3;a[25792]=0;return}function _i(a){a=a|0;return 3796+(a*72|0)|0}function $i(a){a=a|0;var d=0,e=0;e=3796+(a*72|0)|0;if(!(b[e>>1]|0))return;pb(1,3796+(a*72|0)+12|0);a=3796+(a*72|0)+28|0;d=c[a>>2]|0;if(d){go(d);c[a>>2]=0}b[e>>1]=0;return}function aj(){return}function bj(){var a=0;a=0;do{b[3796+(a*72|0)>>1]=0;a=a+1|0}while((a|0)!=256);c[5557]=0;return}function cj(a){a=a|0;if((a|0)<0){Pc(3553,0);dd(3553);return}else{Pc(3553,a|0);rb(3553);return}}function dj(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+48|0;r=t;q=t+40|0;o=t+36|0;p=t+32|0;a=Fk(a,d,o,p,t+28|0,4)|0;c[q>>2]=-1;if(!a){Al(26328,t+24|0);s=-1;i=t;return s|0}h=c[o>>2]|0;d=1;while(1)if((d|0)<(h|0))d=d<<1;else break;f=c[p>>2]|0;e=1;while(1)if((e|0)<(f|0))e=e<<1;else break;if(!((d|0)==(h|0)&(e|0)==(f|0))){f=d<<2;h=el($(f,e)|0)|0;if((c[p>>2]|0)>0){j=c[o>>2]|0;l=a;m=h;n=0;while(1){so(m|0,l|0,j<<2|0)|0;k=c[o>>2]|0;n=n+1|0;if((n|0)>=(c[p>>2]|0))break;else{j=k;l=l+(k<<2)|0;m=m+f|0}}}fl(a);a=h}sb(1,q|0);Pc(3553,c[q>>2]|0);uc(3553,0,6408,d|0,e|0,0,6408,5121,a|0);fl(a);m=d&65535;n=e&65535;o=c[o>>2]|0;k=o&65535;l=c[p>>2]|0;j=l&65535;h=c[q>>2]|0;a=0;while(1){f=3796+(a*72|0)|0;if(!(b[f>>1]|0)){s=14;break}a=a+1|0;if((a|0)>=256){a=-1;break}}if((s|0)==14)if((a|0)>=0){b[f>>1]=1;b[3796+(a*72|0)+2>>1]=0;b[3796+(a*72|0)+4>>1]=m;b[3796+(a*72|0)+6>>1]=n;b[3796+(a*72|0)+8>>1]=k;b[3796+(a*72|0)+10>>1]=j;g[3796+(a*72|0)+16>>2]=1.0/+(m<<16>>16);g[3796+(a*72|0)+20>>2]=1.0/+(n<<16>>16);c[3796+(a*72|0)+12>>2]=h;b[3796+(a*72|0)+24>>1]=0;b[3796+(a*72|0)+26>>1]=8;c[3796+(a*72|0)+28>>2]=0}c[r>>2]=a;c[r+4>>2]=d;c[r+8>>2]=e;c[r+12>>2]=o;c[r+16>>2]=l;Al(26304,r);s=a;i=t;return s|0}function ej(a){a=a|0;var b=0,c=0;b=Nd(a)|0;if((b|0)<0){a=-1;return a|0}c=el(b)|0;Md(a,c,b,0)|0;a=dj(c,b)|0;fl(c);return a|0}function fj(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+16|0;o=q;f=q+12|0;e=1;while(1)if((e|0)<(a|0))e=e<<1;else{n=e;break}e=1;while(1)if((e|0)<(d|0))e=e<<1;else{m=e;break}sb(1,f|0);Pc(3553,c[f>>2]|0);uc(3553,0,6406,n|0,m|0,0,6406,5121,0);k=n&65535;l=m&65535;j=a&65535;h=d&65535;d=c[f>>2]|0;e=0;while(1){a=3796+(e*72|0)|0;if(!(b[a>>1]|0)){p=8;break}e=e+1|0;if((e|0)>=256){e=-1;break}}if((p|0)==8)if((e|0)>=0){b[a>>1]=2;b[3796+(e*72|0)+2>>1]=0;b[3796+(e*72|0)+4>>1]=k;b[3796+(e*72|0)+6>>1]=l;b[3796+(e*72|0)+8>>1]=j;b[3796+(e*72|0)+10>>1]=h;g[3796+(e*72|0)+16>>2]=1.0/+(k<<16>>16);g[3796+(e*72|0)+20>>2]=1.0/+(l<<16>>16);c[3796+(e*72|0)+12>>2]=d;b[3796+(e*72|0)+24>>1]=0;b[3796+(e*72|0)+26>>1]=8;c[3796+(e*72|0)+28>>2]=0}c[o>>2]=e;c[o+4>>2]=n;c[o+8>>2]=m;Al(26339,o);i=q;return e|0}function gj(){var a=0,d=0,e=0,f=0;c[5557]=0;e=0;f=3796;while(1){do if((b[f>>1]|0)==2){a=f+26|0;d=b[a>>1]|0;if(d<<16>>16>0){b[a>>1]=d+-1<<16>>16;c[5557]=(c[5557]|0)+1;break}pb(1,f+12|0);d=f+28|0;a=c[d>>2]|0;if(a){go(a);c[d>>2]=0}b[f>>1]=0}while(0);e=e+1|0;if((e|0)==256)break;else f=f+72|0}return}function hj(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=a[e>>0]|0;j=(m&255)<<8;if(!(m<<24>>24)){e=-1;return e|0}else{i=0;h=e}while(1){h=h+1|0;if(!(a[h>>0]|0)){m=i;break}else i=i+1|0}if((m|0)<=-2){e=-1;return e|0}k=(d[h>>0]|j)&65535;i=0;h=3796;a:while(1){do if((((b[h>>1]|0)==2?(b[h+24>>1]|0)==k<<16>>16:0)?(c[h+32>>2]|0)==(f|0):0)?(c[h+36>>2]|0)==(g|0):0){j=c[h+28>>2]|0;if(!j)if(!(Jn(e,h+40|0)|0)){n=13;break a}else break;else if(!(Jn(e,j)|0)){n=11;break a}else break}while(0);i=i+1|0;if((i|0)>=256)break;else h=h+72|0}if((n|0)==11){b[h+26>>1]=8;l=i;n=15}else if((n|0)==13){b[h+26>>1]=8;l=i;n=15}if((n|0)==15?(l|0)>-1:0){e=l;return e|0}Kb(0,e|0,f|0)|0;h=Mb(1)|0;h=fj(h,Mb(2)|0)|0;if((h|0)<0){e=-1;return e|0}b[3796+(h*72|0)+24>>1]=k;c[3796+(h*72|0)+32>>2]=f;c[3796+(h*72|0)+36>>2]=g;g=c[5557]|0;do if((g|0)<(Yi(46)|0))if((m|0)>28){g=fo(m+3|0)|0;c[3796+(h*72|0)+28>>2]=g;Kn(g,e)|0;break}else{Kn(3796+(h*72|0)+40|0,e)|0;break}else{b[3796+(h*72|0)+26>>1]=0;a[3796+(h*72|0)+40>>0]=0}while(0);Pc(3553,c[3796+(h*72|0)+12>>2]|0);ed(3553,10240,9729);ed(3553,10241,9729);Tc(3317,1);Jb(3,e|0,f|0,b[3796+(h*72|0)+4>>1]|0,b[3796+(h*72|0)+6>>1]|0)|0;Pc(3553,0);e=h;return e|0}function ij(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;h=i;i=i+16|0;b=h;bj();c[5558]=d;c[5559]=e;c[5560]=d;c[5561]=e;g[5562]=1.0;g[5563]=1.0;g[5564]=1.0;g[5565]=1.0;c[5566]=0;a[27677]=0;a[27678]=0;a[27679]=0;a[27680]=-1;c[5567]=0;c[5568]=0;c[5569]=9728;c[5570]=0;c[5571]=0;c[5572]=f;c[5573]=0;c[5574]=0;c[5575]=0;Xi(10,0);Xi(11,0);Xi(31,1);Xi(32,0);c[b>>2]=d;c[b+4>>2]=e;Al(27681,b);b=80;f=b+128|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(f|0));i=h;return}function jj(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;f=~~(+g[5564]*+(a-(c[5567]|0)|0));c[5573]=f;a=~~(+g[5565]*+(d-(c[5568]|0)|0));c[5574]=a;c[5575]=e;d=c[5571]|0;if(!d)return;b[d+176>>1]=f;b[d+178>>1]=a;b[d+284>>1]=e;si(d)|0;fi(d,0,c[5573]|0,c[5574]|0,(e|0)!=0);return}function kj(a,b){a=a|0;b=b|0;c[5560]=a;c[5561]=b;return}function lj(a,b){a=a|0;b=b|0;c[5558]=a;c[5559]=b;return}function mj(a){a=a|0;var b=0.0,d=0.0,e=0.0,f=0.0,j=0.0,k=0.0,l=0,m=0,n=0;n=i;i=i+16|0;l=n;d=+(c[5560]|0);e=+(c[5558]|0);k=d/e;f=+(c[5561]|0);j=+(c[5559]|0);b=f/j;a:do switch(a|0){case 0:if(k>b)if(k*j>f){m=6;break a}else{m=5;break a}else if(e*b>d){m=5;break a}else{m=6;break a}case 1:{m=5;break}case 2:{m=6;break}default:{g[5562]=k;g[5563]=b;d=k}}while(0);if((m|0)==5){g[5562]=k;g[5563]=k;d=k;b=k}else if((m|0)==6){g[5562]=b;g[5563]=b;d=b}h[l>>3]=d;h[l+8>>3]=b;Al(27704,l);i=n;return}function nj(){var a=0.0,b=0.0,d=0,e=0;yc(5889);Sa();g[5564]=1.0/+g[5562];g[5565]=1.0/+g[5563];b=+(c[5558]|0);a=+(c[5559]|0);Wa(0.0,+b,+-a,0.0,-100.0,100.0);b=b*+g[5562];e=~~((+(c[5560]|0)-b)*.5);c[5567]=e;a=a*+g[5563];d=~~((+(c[5561]|0)-a)*.5);c[5568]=d;mb(~~+(e|0)|0,~~+(d|0)|0,~~b|0,~~a|0);yc(5888);Sa();dd(2896);dd(2884);dd(2929);dd(256);Ya(2,5126,0,22304);Ub(32884);oc(2,5126,0,22336);Ub(32888);dd(3553);rb(3042);Ja(1,771);rb(2832);ed(3553,10240,9728);ed(3553,10241,9728);gj();return}function oj(){if(!(c[5570]|0))return 0;cd();c[5570]=0;return 0}function pj(a){a=a|0;c[5592]=a;return}function qj(a,b){a=a|0;b=b|0;var d=0,e=0;switch(a|0){case 1:case 0:{dd(3042);d=6;break}case 5:{rb(3042);Ja(770,1);break}case 6:{rb(3042);Ja(770,1);break}default:{rb(3042);Ja(770,771);if((a|0)<2)d=6}}if((d|0)==6){xc(32886);e=c[5569]|0;ed(3553,10240,e|0);e=c[5569]|0;ed(3553,10241,e|0);return}a=(a|0)>2?b&255:-1;b=c[5571]|0;if(!b){b=(a&255)<<24;e=b|16777215;a=e;d=e&-256;e=e>>>16}else{e=c[b+640>>2]|0;b=(a&255)<<24;a=e>>>16&255;d=e&65280;e=e&255}e=e<<16&16711680|b|d&65280|a&255;c[5593]=e;c[5594]=e;c[5595]=e;c[5596]=e;Ub(32886);Gc(4,5121,0,22372);e=c[5569]|0;ed(3553,10240,e|0);e=c[5569]|0;ed(3553,10241,e|0);return}function rj(a){a=a|0;switch(a|0){case 0:{dd(3042);return}case 4:case 3:{rb(3042);Ja(770,771);return}case 5:{rb(3042);Ja(770,1);return}case 6:{rb(3042);Ja(770,1);return}default:{rb(3042);Ja(1,771);return}}}function sj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d>>2]=~~(+g[5564]*+(a-(c[5567]|0)|0));c[e>>2]=~~(+g[5565]*+(b-(c[5568]|0)|0));return}function tj(a,b,c){a=a|0;b=b|0;c=c|0;Xi(31,a);Xi(32,b);Xi(33,c);return}function uj(){return c[5558]|0}function vj(){return c[5559]|0}function wj(a,b){a=a|0;b=b|0;c[5569]=(a|0)==0?9728:9729;return}function xj(a){a=a|0;return 0}function yj(a){a=a|0;var b=0;a=(c[5575]|0)==0?0:256;a=a|(_j(1104)|0)&1;b=_j(1106)|0;a=b?a|2:a;b=_j(1103)|0;a=b?a|4:a;b=_j(1105)|0;a=b?a|8:a;b=_j(32)|0;a=b?a|16:a;b=_j(13)|0;a=b?a|32:a;b=_j(1248)|0;a=b?a|64:a;b=_j(27)|0;a=b?a|128:a;b=_j(9)|0;return (b?a|1024:a)|0}function zj(a,b,d){a=a|0;b=b|0;d=d|0;c[5597]=b;c[5598]=d;return 0}function Aj(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;n=d+72|0;o=c[n>>2]|0;p=d+156|0;b[p>>1]=0;q=d+158|0;b[q>>1]=0;k=d+8|0;l=d+68|0;m=d+104|0;d=f;j=f;a:while(1){f=0;b:while(1){switch(a[d>>0]|0){case 0:{d=j;break a}case 13:{i=d;f=4;break b}case 10:{i=d;f=11;break b}default:{}}d=d+1|0;f=f+1|0}if((f|0)==4){a[i>>0]=0;h=c[n>>2]|0;if((h|0)<(c[k>>2]|0)){f=c[l>>2]|0;g=c[m>>2]|0;d=hj(j,c[5597]|0,c[5598]|0)|0;if((d|0)>-1){j=_i(d)|0;r=b[j+8>>1]|0;c[5599]=r<<16>>16;j=b[j+10>>1]|0;c[5600]=j<<16>>16;Kj(+(f|0),+(h|0),0,0,r,j,d,g)}d=c[5599]|0;if((d|0)>(b[p>>1]|0))b[p>>1]=d;r=c[5600]|0;b[q>>1]=(e[q>>1]|0)+r;c[n>>2]=(c[n>>2]|0)+r}a[i>>0]=13;j=i+1|0;d=(a[j>>0]|0)==10?i+2|0:j;continue}else if((f|0)==11){a[i>>0]=0;f=c[n>>2]|0;if((f|0)<(c[k>>2]|0)){g=c[l>>2]|0;h=c[m>>2]|0;d=hj(j,c[5597]|0,c[5598]|0)|0;if((d|0)>-1){r=_i(d)|0;j=b[r+8>>1]|0;c[5599]=j<<16>>16;r=b[r+10>>1]|0;c[5600]=r<<16>>16;Kj(+(g|0),+(f|0),0,0,j,r,d,h)}d=c[5599]|0;if((d|0)>(b[p>>1]|0))b[p>>1]=d;r=c[5600]|0;b[q>>1]=(e[q>>1]|0)+r;c[n>>2]=(c[n>>2]|0)+r}a[i>>0]=10;j=i+1|0;d=j;continue}}if((f|0)<=0){c[n>>2]=o;return 0}h=c[n>>2]|0;if((h|0)>=(c[k>>2]|0)){c[n>>2]=o;return 0}g=c[l>>2]|0;f=c[m>>2]|0;d=hj(d,c[5597]|0,c[5598]|0)|0;if((d|0)>-1){r=_i(d)|0;m=b[r+8>>1]|0;c[5599]=m<<16>>16;r=b[r+10>>1]|0;c[5600]=r<<16>>16;Kj(+(g|0),+(h|0),0,0,m,r,d,f)}d=c[5599]|0;if((d|0)>(b[p>>1]|0))b[p>>1]=d;r=c[5600]|0;b[q>>1]=(e[q>>1]|0)+r;c[n>>2]=(c[n>>2]|0)+r;c[n>>2]=o;return 0}function Bj(a,d){a=a|0;d=d|0;var e=0,f=0;if((c[a>>2]|0)!=0?(e=a+280|0,f=c[e>>2]|0,(f|0)!=-1):0){$i(f);c[e>>2]=-1}e=ej(d)|0;if((e|0)<0){a=-1;return a|0}f=_i(e)|0;if(!(b[f>>1]|0)){a=-1;return a|0}c[a+4>>2]=b[f+8>>1];c[a+8>>2]=b[f+10>>1];c[a+280>>2]=e;a=e;return a|0}function Cj(a){a=a|0;var b=0;if(!(c[a>>2]|0))return;a=a+280|0;b=c[a>>2]|0;if((b|0)==-1)return;$i(b);c[a>>2]=-1;return}function Dj(b,c,d,e){b=+b;c=+c;d=+d;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0;o=i;i=i+4096|0;n=o;m=o+3072|0;c=-c;f=0;do{p=+(f|0)*6.283185307179586/20.0;l=f*3|0;g[n+(l<<2)>>2]=b+d*+R(+p);g[n+(l+1<<2)>>2]=c+e*+S(+p);g[n+(l+2<<2)>>2]=0.0;f=f+1|0}while((f|0)!=20);f=a[27677]|0;h=a[27678]|0;j=a[27679]|0;k=a[27680]|0;l=0;do{q=l<<2;a[m+q>>0]=f;a[m+(q|1)>>0]=h;a[m+(q|2)>>0]=j;a[m+(q|3)>>0]=k;l=l+1|0}while((l|0)!=20);dd(3042);Ub(32886);Ya(3,5126,0,n|0);Gc(4,5121,0,m|0);hc(2,0,20);hc(0,0,20);i=o;return}function Ej(b,c,d,e){b=+b;c=+c;d=+d;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0;p=i;i=i+4096|0;o=p;n=p+3072|0;g[o>>2]=b;m=-c;g[o+4>>2]=m;g[o+8>>2]=0.0;c=e;f=1;do{e=+(f|0)*6.283185307179586/20.0;l=f*3|0;g[o+(l<<2)>>2]=b+d*+R(+e);g[o+(l+1<<2)>>2]=m+c*+S(+e);g[o+(l+2<<2)>>2]=0.0;f=f+1|0}while((f|0)!=22);h=a[27677]|0;j=a[27678]|0;k=a[27679]|0;f=a[27680]|0;l=0;do{q=l<<2;a[n+q>>0]=h;a[n+(q|1)>>0]=j;a[n+(q|2)>>0]=k;a[n+(q|3)>>0]=f;l=l+1|0}while((l|0)!=22);dd(3042);Ub(32886);Ya(3,5126,0,o|0);Gc(4,5121,0,n|0);hc(6,0,22);i=p;return}function Fj(b,d,e){b=b|0;d=+d;e=+e;var f=0,h=0;if(!b)return;if((c[b+28>>2]|0)!=2){b=Rb(4)|0;c[b>>2]=21;ad(b|0,8,0)}b=c[b+104>>2]|0;h=b>>>16&255;a[27677]=h;f=b>>>8&255;a[27678]=f;b=b&255;a[27679]=b;a[27680]=-1;a[27733]=h;a[27734]=f;a[27735]=b;a[27736]=-1;a[27737]=h;a[27738]=f;a[27739]=b;a[27740]=-1;g[5601]=d+.375;g[5602]=e+.375;dd(3042);cj(-1);return}function Gj(a,b){a=+a;b=+b;c[5603]=c[5601];g[5604]=-+g[5602];g[5605]=0.0;a=a+.375;g[5601]=a;b=b+.375;g[5602]=b;g[5606]=a;g[5607]=-b;g[5608]=0.0;Ub(32886);Ya(3,5126,0,22412);Gc(4,5121,0,27733);hc(3,0,2);return}function Hj(b,d,e,f,h){b=b|0;d=+d;e=+e;f=+f;h=+h;var j=0,k=0,l=0,m=0,n=0,o=0.0;l=i;i=i+256|0;k=l;j=l+192|0;if(!b){i=l;return}if((c[b+28>>2]|0)!=2){l=Rb(4)|0;c[l>>2]=21;ad(l|0,8,0)}cj(-1);b=c[b+104>>2]|0;n=b>>>16&255;a[27677]=n;m=b>>>8&255;a[27678]=m;b=b&255;a[27679]=b;a[27680]=-1;g[k>>2]=d;o=-e;g[k+4>>2]=o;g[k+8>>2]=0.0;g[k+12>>2]=d;h=o-(h-e);g[k+16>>2]=h;g[k+20>>2]=0.0;e=f-d+d;g[k+24>>2]=e;g[k+28>>2]=o;g[k+32>>2]=0.0;g[k+36>>2]=e;g[k+40>>2]=h;g[k+44>>2]=0.0;a[j>>0]=n;a[j+1>>0]=m;a[j+2>>0]=b;a[j+3>>0]=-1;a[j+4>>0]=n;a[j+5>>0]=m;a[j+6>>0]=b;a[j+7>>0]=-1;a[j+8>>0]=n;a[j+9>>0]=m;a[j+10>>0]=b;a[j+11>>0]=-1;a[j+12>>0]=n;a[j+13>>0]=m;a[j+14>>0]=b;a[j+15>>0]=-1;dd(3042);Ub(32886);Ya(3,5126,0,k|0);Gc(4,5121,0,j|0);hc(5,0,4);i=l;return}function Ij(b,d,e,f,g,h){b=b|0;d=+d;e=+e;f=+f;g=+g;h=h|0;var i=0.0,j=0.0,k=0;if(!b)return;if((c[b+28>>2]|0)!=2){h=Rb(4)|0;c[h>>2]=21;ad(h|0,8,0)}k=~~(f-d);j=+(((k|0)>-1?k:0-k|0)|0)*.5;k=~~(g-e);i=+(((k|0)>-1?k:0-k|0)|0)*.5;g=j+d;f=i+e;cj(-1);b=c[b+104>>2]|0;a[27677]=b>>>16;a[27678]=b>>>8;a[27679]=b;a[27680]=-1;if(!h){Dj(g,f,j,i);return}else{Ej(g,f,j,i);return}}function Jj(b,d,e,f,h,i){b=b|0;d=+d;e=+e;f=+f;h=+h;i=+i;var j=0,k=0,l=0,m=0,n=0.0,o=0.0;if(!b)return;if((c[b+28>>2]|0)!=2){b=Rb(4)|0;c[b>>2]=21;ad(b|0,8,0)}o=-+S(+i);i=+R(+i);f=f*-.5;h=h*-.5;n=h*o;h=h*i;i=f*i;f=f*o;g[5651]=i-n+d;g[5652]=-(-h-f+e);g[5653]=-i-n+d;g[5654]=-(f-h+e);g[5655]=n+i+d;g[5656]=-(h-f+e);g[5657]=n-i+d;g[5658]=-(f+h+e);cj(-1);Ya(2,5126,0,22604);k=c[b+104>>2]|0;m=k>>>16&255;l=k>>>8&255;k=k&255;j=c[b+144>>2]&255;a[27717]=m;a[27718]=l;a[27719]=k;a[27720]=j;a[27721]=m;a[27722]=l;a[27723]=k;a[27724]=j;a[27725]=m;a[27726]=l;a[27727]=k;a[27728]=j;a[27729]=m;a[27730]=l;a[27731]=k;a[27732]=j;Ub(32886);Gc(4,5121,0,27717);rj(c[b+100>>2]|0);hc(5,0,4);return}function Kj(d,e,f,h,i,j,k,l){d=+d;e=+e;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=_i(k)|0;if(!(b[q>>1]|0))return;e=-e;k=i<<16>>16;p=+(i<<16>>16)+d;i=j<<16>>16;o=e-+(j<<16>>16);g[5651]=d;g[5652]=e;g[5653]=d;g[5654]=o;g[5655]=p;g[5656]=e;g[5657]=p;g[5658]=o;o=+g[q+16>>2];p=+g[q+20>>2];e=+(f<<16>>16);if(!(c[5566]|0)){n=+(h<<16>>16);m=+(k+(f<<16>>16)|0);d=+(i+(h<<16>>16)|0)}else{n=+(h<<16>>16)+.5;m=+(k+(f<<16>>16)|0)+-.5;d=+(i+(h<<16>>16)|0)+-.5;e=e+.5}e=o*e;d=p*d;o=o*m;p=p*n;g[5659]=e;g[5660]=p;g[5661]=e;g[5662]=d;g[5663]=o;g[5664]=p;g[5665]=o;g[5666]=d;rb(3553);cj(c[q+12>>2]|0);Ya(2,5126,0,22604);oc(2,5126,0,22636);qj(3,255);h=l>>>16&255;q=l>>>8&255;l=l&255;a[27717]=h;a[27718]=q;a[27719]=l;a[27720]=-1;a[27721]=h;a[27722]=q;a[27723]=l;a[27724]=-1;a[27725]=h;a[27726]=q;a[27727]=l;a[27728]=-1;a[27729]=h;a[27730]=q;a[27731]=l;a[27732]=-1;Ub(32886);Gc(4,5121,0,27717);hc(5,0,4);dd(3553);return}function Lj(a,d,e,f,h,i,j,k){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=+j;k=+k;var l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){a=Rb(4)|0;c[a>>2]=21;ad(a|0,8,0)}i=_i(c[i+280>>2]|0)|0;if(!(b[i>>1]|0))return;if(j<0.0){o=-j;n=+((f<<16>>16)+(d<<16>>16)|0);m=+(d<<16>>16)}else{o=j;n=+(d<<16>>16);m=+((f<<16>>16)+(d<<16>>16)|0)}if(k<0.0){k=-k;l=+((h<<16>>16)+(e<<16>>16)|0);j=+(e<<16>>16)}else{l=+(e<<16>>16);j=+((h<<16>>16)+(e<<16>>16)|0)}r=+(c[a+68>>2]|0);q=+(0-(c[a+72>>2]|0)|0);p=o+r;o=q-k;g[5651]=r;g[5652]=q;g[5653]=r;g[5654]=o;g[5655]=p;g[5656]=q;g[5657]=p;g[5658]=o;if(c[5566]|0){n=n+.5;m=m+-.5;l=l+.5;j=j+-.5}q=+g[i+16>>2];r=+g[i+20>>2];o=n*q;p=l*r;q=m*q;r=j*r;g[5659]=o;g[5660]=p;g[5661]=o;g[5662]=r;g[5663]=q;g[5664]=p;g[5665]=q;g[5666]=r;cj(c[i+12>>2]|0);Ya(2,5126,0,22604);oc(2,5126,0,22636);qj(c[a+100>>2]|0,c[a+144>>2]|0);hc(5,0,4);return}function Mj(a,d,e,f,h,i,j,k,l,m,n){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;i=+i;j=+j;k=k|0;l=+l;m=+m;n=+n;var o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){e=Rb(4)|0;c[e>>2]=21;ad(e|0,8,0)}k=_i(c[k+280>>2]|0)|0;if(!(b[k>>1]|0))return;p=n;q=+S(+p);p=+R(+p);n=+(c[a+68>>2]|0)-(p*i-q*j);j=+(c[a+72>>2]|0)-(q*i+p*j);o=q*m;i=p*m;p=p*l;m=q*l;q=+g[k+16>>2];l=+g[k+20>>2];s=+(d<<16>>16)*q;r=+(e<<16>>16)*l;q=+((f<<16>>16)+(d<<16>>16)|0)*q;l=+((h<<16>>16)+(e<<16>>16)|0)*l;g[5659]=s;g[5660]=r;g[5661]=s;g[5662]=l;g[5663]=q;g[5664]=r;g[5665]=q;g[5666]=l;g[5651]=n;g[5652]=-j;g[5653]=n-o;g[5654]=-(i+j);g[5655]=p+n;g[5656]=-(m+j);g[5657]=p-o+n;g[5658]=-(m+i+j);cj(c[k+12>>2]|0);Ya(2,5126,0,22604);oc(2,5126,0,22636);qj(c[a+100>>2]|0,c[a+144>>2]|0);hc(5,0,4);return}function Nj(a,d,e,f,h,i){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0.0,k=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){i=Rb(4)|0;c[i>>2]=21;ad(i|0,8,0)}f=_i(c[f+280>>2]|0)|0;if(!(b[f>>1]|0))return;k=+g[f+16>>2];j=+g[f+20>>2];g[5659]=k*+(c[h>>2]|0);g[5660]=j*+(c[i>>2]|0);g[5661]=k*+(c[h+12>>2]|0);g[5662]=j*+(c[i+12>>2]|0);g[5663]=k*+(c[h+4>>2]|0);g[5664]=j*+(c[i+4>>2]|0);g[5665]=k*+(c[h+8>>2]|0);g[5666]=j*+(c[i+8>>2]|0);g[5651]=+(c[d>>2]|0);g[5652]=+(0-(c[e>>2]|0)|0);g[5653]=+(c[d+12>>2]|0);g[5654]=+(0-(c[e+12>>2]|0)|0);g[5655]=+(c[d+4>>2]|0);g[5656]=+(0-(c[e+4>>2]|0)|0);g[5657]=+(c[d+8>>2]|0);g[5658]=+(0-(c[e+8>>2]|0)|0);cj(c[f+12>>2]|0);Ya(2,5126,0,22604);oc(2,5126,0,22636);qj(c[a+100>>2]|0,c[a+144>>2]|0);hc(5,0,4);return}function Oj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;if(!b)return;if((c[b+28>>2]|0)!=2){e=Rb(4)|0;c[e>>2]=21;ad(e|0,8,0)}g[5651]=+(c[d>>2]|0);g[5652]=+(0-(c[e>>2]|0)|0);g[5653]=+(c[d+12>>2]|0);g[5654]=+(0-(c[e+12>>2]|0)|0);g[5655]=+(c[d+4>>2]|0);g[5656]=+(0-(c[e+4>>2]|0)|0);g[5657]=+(c[d+8>>2]|0);g[5658]=+(0-(c[e+8>>2]|0)|0);cj(-1);Ya(2,5126,0,22604);d=c[b+144>>2]|0;e=b+100|0;b=(c[e>>2]|0)<3;h=c[f>>2]|0;a[27717]=h>>>16;a[27718]=h>>>8;a[27719]=h;d=b?-1:d&255;a[27720]=d;b=c[f+12>>2]|0;a[27721]=b>>>16;a[27722]=b>>>8;a[27723]=b;a[27724]=d;b=c[f+4>>2]|0;a[27725]=b>>>16;a[27726]=b>>>8;a[27727]=b;a[27728]=d;f=c[f+8>>2]|0;a[27729]=f>>>16;a[27730]=f>>>8;a[27731]=f;a[27732]=d;Ub(32886);Gc(4,5121,0,27717);rj(c[e>>2]|0);hc(5,0,4);return}function Pj(a,d,e,f,g,h){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;if(!a){t=0;return t|0}if((c[a+28>>2]|0)!=2){t=Rb(4)|0;c[t>>2]=21;ad(t|0,8,0)}q=b[h+208>>1]|0;r=q<<16>>16;s=b[h+210>>1]|0;k=s<<16>>16;l=+(q<<16>>16);m=+(s<<16>>16);if((g|0)<=0){t=0;return t|0}n=h+204|0;o=a+68|0;p=a+72|0;t=0;j=f;i=e;f=0;while(1){e=c[j>>2]|0;if((e|0)>-1){v=b[n>>1]|0;u=$((e|0)%(v|0)|0,r)|0;e=$((e|0)/(v|0)|0,k)|0;c[o>>2]=c[d>>2];c[p>>2]=c[i>>2];Lj(a,u&65535,e&65535,q,s,h,l,m);f=f+1|0}t=t+1|0;if((t|0)==(g|0))break;else{j=j+4|0;d=d+4|0;i=i+4|0}}return f|0}function Qj(){var b=0,d=0,e=0;d=i;i=i+16|0;b=d;Fa(0,b|0)|0;b=~~(+(c[b+4>>2]|0)*.001*.001)+((c[b>>2]|0)*1e3|0)|0;if(!(a[27797]|0)){a[27797]=1;c[5667]=b;e=b;b=b-e|0;i=d;return b|0}else{e=c[5667]|0;e=b-e|0;i=d;return e|0}return 0}function Rj(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function Sj(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function Tj(b,d,e){b=b|0;d=d|0;e=e|0;a[e>>0]=0;if(b>>>0>=3){d=0;return d|0}c[d>>2]=2;d=e;return d|0}function Uj(){var a=0;if(c[5570]|0){cd();c[5570]=0}if((Yi(31)|0)!=1){nj();Yi(31)|0;c[5570]=1;return 0}a=Yi(32)|0;Zb(+(+(a>>>16&255|0)*.00390625),+(+(a>>>8&255|0)*.00390625),+(+(a&255|0)*.00390625),1.0);Mc(16384);nj();Yi(31)|0;c[5570]=1;return 0}function Vj(a){a=a|0;var b=0.0;a=a+-256|0;if(a>>>0>=16){b=0.0;return +b}b=+h[80+(a<<3)>>3];return +b}function Wj(a){a=a|0;c[5571]=a;return}function Xj(a,b){a=a|0;b=b|0;if(!a){b=-1;return b|0}if((c[a+28>>2]|0)!=2){b=Rb(4)|0;c[b>>2]=21;ad(b|0,8,0)}if(!(b&1)){Uj()|0;b=0;return b|0}if(!(c[5570]|0)){b=0;return b|0}cd();c[5570]=0;b=0;return b|0}function Yj(a){a=a|0;return a|0}function Zj(){var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+64|0;j=m;k=m+52|0;l=m+48|0;if(!(Jc(j|0)|0)){i=m;return}e=j+20|0;f=j+24|0;g=j+20|0;h=j+16|0;do switch(c[j>>2]|0){case 1024:{if(c[5668]|0){sj(c[e>>2]|0,c[f>>2]|0,k,l);d=rd[c[(c[22672>>2]|0)+72>>2]&63](0)|0;b[d+176>>1]=c[k>>2];b[d+178>>1]=c[l>>2];si(d)|0;fi(d,-1,c[k>>2]|0,c[l>>2]|0,1)}break}case 1025:{jj(c[g>>2]|0,c[f>>2]|0,1);break}case 1026:{jj(c[g>>2]|0,c[f>>2]|0,0);break}case 768:{d=27798+(c[h>>2]|0)|0;if(!(a[d>>0]|0))a[d>>0]=1;break}case 769:{d=27798+(c[h>>2]|0)|0;if(a[d>>0]|0)a[d>>0]=0;break}default:{}}while((Jc(j|0)|0)!=0);i=m;return}function _j(b){b=b|0;return (a[27798+b>>0]|0)!=0|0}function $j(a){a=a|0;var b=0,d=0;a=a+236|0;b=c[a>>2]|0;a:while(1){switch(b|0){case 9:{d=3;break a}case 1:{d=4;break a}case 2:break a;case 6:{d=7;break a}case 7:{d=8;break a}case 8:break;default:{d=10;break a}}c[a>>2]=3;b=3}if((d|0)==3){c[a>>2]=0;return}else if((d|0)==4)c[a>>2]=He(Qj()|0)|0;else if((d|0)==7){d=Rb(4)|0;c[d>>2]=10;ad(d|0,8,0)}else if((d|0)==8){d=Rb(4)|0;c[d>>2]=42;ad(d|0,8,0)}else if((d|0)==10)return;if(Ie(Qj()|0)|0)return;c[(c[5670]|0)+236>>2]=2;return}function ak(d){d=d|0;var f=0,g=0.0,j=0,k=0,l=0,m=0.0,n=0,p=0,q=0,r=0,s=0;s=i;i=i+48|0;p=s+40|0;r=s+32|0;q=s+16|0;n=s;Zi();f=El(912)|0;o=0;ja(31,f|0);l=o;o=0;if(l&1){s=kb()|0;Gl(f);qb(s|0)}c[5671]=f;if(d)Ud(f,d);c[5672]=960;c[5673]=640;if(((a[29341]|0)==126|0)==(0-(((a[29340]|0)==126&1)+(((a[29339]|0)==68&1)+(((a[29338]|0)==69&1)+(((a[29337]|0)==72&1)+(((a[29336]|0)==80&1)+(((a[29335]|0)==83&1)+((a[29334]|0)==72&1)))))))|0)){d=(zn(29343)|0)+65536|0;c[5672]=b[14677];c[5673]=b[14678];Wd(c[5671]|0,e[14681]|0,c[7341]|0)}else d=0;f=jc(29372)|0;if((f|0)!=0?(j=zn(f)|0,(j|0)>0):0)c[5672]=j;f=jc(29379)|0;if((f|0)!=0?(k=zn(f)|0,(k|0)>0):0)c[5673]=k;f=jc(29386)|0;if(!f)g=0.0;else g=+yn(f);f=jc(29393)|0;if(!((f|0)!=0?(m=+yn(f),g>0.0&m>0.0):0)){g=+(c[5672]|0);m=+(c[5673]|0)}f=jc(29400)|0;if(!f)l=0;else l=zn(f)|0;f=jc(29414)|0;c[5674]=0;if(f)c[5674]=zn(f)|0;f=jc(29422)|0;c[5675]=5e3;if(f)c[5675]=zn(f)|0;h[n>>3]=g;h[n+8>>3]=m;cn(29437,n)|0;f=jc(29451)|0;if(f)mo(22704,f)|0;if(Vd(c[5671]|0,d)|0){dn(29499)|0;r=1;i=s;return r|0}uo(27798,0,1536)|0;j=c[5671]|0;c[5670]=j;c[5669]=0;c[j+852>>2]=32;j=~~g;k=~~m;c[q>>2]=j;c[q+4>>2]=k;c[q+8>>2]=29479;cn(29464,q)|0;do if(!(ac(32)|0)){eb(5,1)|0;if(!(Bb(j|0,k|0,16,67108864)|0)){c[p>>2]=Ga()|0;cn(29545,p)|0;break}else{ij(0,j,k,0);tj(1,16777215,0);break}}else{c[r>>2]=Ga()|0;cn(29515,r)|0}while(0);d=c[5672]|0;f=c[5673]|0;if(g!=+(d|0)|m!=+(f|0)){lj(d,f);kj(j,k);mj(l)}rf(te(9)|0);sf(te(10)|0);c[5668]=c[(c[5670]|0)+876>>2];r=tf()|0;c[5679]=r;c[r>>2]=29575;c[r+4>>2]=30178;c[r+8>>2]=17;c[r+12>>2]=3;c[r+20>>2]=37;c[r+16>>2]=18;r=0;i=s;return r|0}function bk(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+1056|0;h=j+8|0;g=j;f=j+24|0;a=xe()|0;b=Be()|0;d=Oc(a|0)|0;e=Ge()|0;if((b|0)<0){c[g>>2]=a;c[g+4>>2]=d;fn(f,29586,g)|0;dn(f)|0;i=j;return}else{c[h>>2]=a;c[h+4>>2]=b;c[h+8>>2]=e;c[h+12>>2]=d;fn(f,29603,h)|0;dn(f)|0;i=j;return}}function ck(){var b=0,d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;g=h;if(!(a[29636]|0)){dn(29637)|0;i=h;return}switch(c[(c[5670]|0)+236>>2]|0){case 1:{f=He(Qj()|0)|0;c[(c[5670]|0)+236>>2]=f;f=5;break}case 2:{f=5;break}default:{}}if((f|0)==5?(Ie(Qj()|0)|0)!=0:0){i=h;return}Zj();b=c[5675]|0;a:do if((b|0)>0){b=0;b:while(1){e=Ve(22720)|0;switch(c[(c[5670]|0)+236>>2]|0){case 4:case 5:{d=b;f=8;break b}case 2:case 1:{f=23;break b}default:{}}d=b+1|0;b=c[5675]|0;if((d|0)<(b|0))b=d;else break a}if((f|0)==8){b=c[5675]|0;d=d+1|0;break}else if((f|0)==23){i=h;return}}else{d=0;e=0}while(0);if((d|0)==(b|0)){f=c[5915]|0;c[g>>2]=b;Rm(f,29642,g)|0}switch(e|0){case 5:{o=0;oa(6);h=o;o=0;if(!(h&1)){Lc();Ib(-1)}ec(kb(0)|0)|0;cc();Lc();Ib(-1);break}case 0:{i=h;return}default:{if(c[5669]|0){oj()|0;c[5669]=0}Lc();b=c[5671]|0;if(!b)Ib(0);o=0;ja(33,b|0);h=o;o=0;if(h&1){h=kb()|0;Gl(b);qb(h|0)}Gl(b);c[5671]=0;Ib(0)}}}function dk(){a[29636]=1;return}function ek(){var b=0,d=0;d=a[22704]|0;b=(d&1)==0;if(!((b?(d&255)>>>1:c[5677]|0)|0))a[29636]=1;else{a[29636]=0;Lb(4,(b?22705:c[5678]|0)|0)|0}$j(c[5670]|0);Zc(7,c[5674]|0,1);return 0}function fk(){c[5676]=0;c[5677]=0;c[5678]=0;Va(34,22704,n|0)|0;return}function gk(a,b){a=a|0;b=b|0;return -1}function hk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;if(Jn(b,29852)|0){f=-1;return f|0}f=a[22704]|0;b=(f&1)==0;if(!((b?(f&255)>>>1:c[5677]|0)|0)){f=-1;return f|0}Lb(5,(b?22705:c[5678]|0)|0)|0;f=0;return f|0}function ik(a){a=a|0;if(!(Jn(a,29841)|0)){a=c[c[5679]>>2]|0;return a|0}if(Jn(a,29846)|0){a=0;return a|0}a=c[(c[5679]|0)+4>>2]|0;return a|0}function jk(a,b){a=a|0;b=b|0;c[b>>2]=-1;return 0}function kk(a,b){a=a|0;b=b|0;if((a|0)>1)a=c[b+4>>2]|0;else a=30178;a=ak(a)|0;if(a){b=a;return b|0}b=ek()|0;return b|0}function lk(b){b=b|0;c[b>>2]=0;c[b+4>>2]=0;b=b+8|0;a[b>>0]=0;gc(8)|0;wc(16)|0;if(!(Kc(0,0,0,0)|0)){a[b>>0]=1;return}else Ba(29955,29964,59,29985)}function mk(a){a=a|0;nk(a);if(!(gc(0)|0)){hb();return}do bd();while((gc(0)|0)!=0);hb();return}function nk(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;g=a+4|0;d=c[g>>2]|0;if(!d)return;b=c[a>>2]|0;if((b|0)>0){e=0;while(1){if(d){Vc(c[d+36>>2]|0)|0;c[d+40>>2]=0;b=c[a>>2]|0}e=e+1|0;if((e|0)>=(b|0))break;else d=d+44|0}if((b|0)>0){b=c[g>>2]|0;e=b;f=0;while(1){d=e+(f*44|0)|0;if((c[d>>2]|0)==1){if(d){Vc(c[e+(f*44|0)+36>>2]|0)|0;c[e+(f*44|0)+40>>2]=0}Ta(c[e+(f*44|0)+32>>2]|0);b=c[g>>2]|0;e=b}d=c[e+(f*44|0)+16>>2]|0;if(!d)d=e;else{go(d);b=c[g>>2]|0;d=b}c[d+(f*44|0)+16>>2]=0;f=f+1|0;if((f|0)>=(c[a>>2]|0))break;else e=d}}else h=7}else h=7;if((h|0)==7)b=c[g>>2]|0;Hi(b);c[g>>2]=0;c[a>>2]=0;return}function ok(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0;i=c[b>>2]|0;a:do if((i|0)>0){k=b+4|0;h=c[k>>2]|0;j=0;while(1){if((c[h+(j*44|0)+8>>2]|0)==(d|0))break;j=j+1|0;if((j|0)>=(i|0)){l=6;break a}}if((j|0)>=0){i=h+(j*44|0)|0;if((c[i>>2]|0)==1){if(i){Vc(c[h+(j*44|0)+36>>2]|0)|0;c[h+(j*44|0)+40>>2]=0}Ta(c[h+(j*44|0)+32>>2]|0);h=c[k>>2]|0}i=c[h+(j*44|0)+16>>2]|0;if(i){go(i);h=c[k>>2]|0}c[h+(j*44|0)+16>>2]=0;i=j}else l=6}else l=6;while(0);if((l|0)==6){if(!(a[b+8>>0]|0)){f=0;return f|0}k=i+1|0;c[b>>2]=k;k=k*44|0;h=b+4|0;j=c[h>>2]|0;if(!j){l=Fi(k)|0;c[h>>2]=l;h=l}else{l=Ii(j,k)|0;c[h>>2]=l;h=l}c[h+(i*44|0)>>2]=0;c[h+(i*44|0)+8>>2]=-1;c[h+(i*44|0)+36>>2]=-1}if((i|0)<0){f=0;return f|0}l=h+(i*44|0)|0;c[l>>2]=e;c[h+(i*44|0)+4>>2]=f;c[h+(i*44|0)+8>>2]=d;c[h+(i*44|0)+16>>2]=g;c[h+(i*44|0)+20>>2]=0;c[h+(i*44|0)+40>>2]=0;c[h+(i*44|0)+24>>2]=0;c[h+(i*44|0)+28>>2]=0;f=l;return f|0}function pk(a,b){a=a|0;b=b|0;nk(a);return}function qk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+16|0;f=g;e=ok(a,d,1,e,0,0)|0;if(e){c[e+32>>2]=Vb(b|0)|0;c[e+36>>2]=-1}c[f>>2]=b;c[f+4>>2]=d;Al(29991,f);i=g;return 0}function rk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=c[a>>2]|0;if((d|0)<=0){g=1;return g|0}g=c[a+4>>2]|0;a=0;while(1){if((c[g+(a*44|0)+8>>2]|0)==(b|0)){e=a;break}a=a+1|0;if((a|0)>=(d|0)){a=1;f=10;break}}if((f|0)==10)return a|0;if((e|0)<0){g=1;return g|0}f=g+(e*44|0)|0;if((c[f>>2]|0)!=1|(f|0)==0){g=0;return g|0}a=c[g+(e*44|0)+4>>2]|0;d=g+(e*44|0)+36|0;b=c[d>>2]|0;if((b|0)>-1)Vc(b|0)|0;c[d>>2]=ib(-1,c[g+(e*44|0)+32>>2]|0,a<<31>>31|0,-1)|0;c[g+(e*44|0)+40>>2]=0;g=0;return g|0}function sk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=c[a>>2]|0;if((f|0)<=0)return;g=c[a+4>>2]|0;e=0;while(1){if((c[g+(e*44|0)+8>>2]|0)==(b|0))break;e=e+1|0;if((e|0)>=(f|0)){h=8;break}}if((h|0)==8)return;if((e|0)<0)return;a=(d|0)>0?0:d;a=(a|0)<-1e3?-1e3:a;c[g+(e*44|0)+24>>2]=a;if((c[g+(e*44|0)>>2]|0)!=1)return;Ab(c[g+(e*44|0)+36>>2]|0,~~(+(a+1e3|0)/1.0e3*128.0)|0)|0;return}function tk(a,b,c){a=a|0;b=b|0;c=c|0;return}function uk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=c[a>>2]|0;if((e|0)<=0){g=0;return g|0}f=c[a+4>>2]|0;a=0;while(1){if((c[f+(a*44|0)+8>>2]|0)==(b|0))break;a=a+1|0;if((a|0)>=(e|0)){a=0;g=12;break}}if((g|0)==12)return a|0;if((a|0)<0){g=0;return g|0}if((c[f+(a*44|0)>>2]|0)!=1){g=0;return g|0}switch(d|0){case 0:{g=c[f+(a*44|0)+4>>2]|0;return g|0}case 1:{g=c[f+(a*44|0)+24>>2]|0;return g|0}case 2:{g=c[f+(a*44|0)+28>>2]|0;return g|0}case 16:return (ya(c[f+(a*44|0)+36>>2]|0)|0)!=0|0;default:{g=0;return g|0}}return 0}function vk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=c[a>>2]|0;d=(f|0)>0;if((b|0)<0){if(!d)return;d=f;e=0;f=c[a+4>>2]|0;while(1){if(f){Vc(c[f+36>>2]|0)|0;c[f+40>>2]=0;d=c[a>>2]|0}e=e+1|0;if((e|0)>=(d|0))break;else f=f+44|0}return}if(!d)return;e=c[a+4>>2]|0;d=0;while(1){if((c[e+(d*44|0)+8>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){g=13;break}}if((g|0)==13)return;if((d|0)<0|(e+(d*44|0)|0)==0)return;Vc(c[e+(d*44|0)+36>>2]|0)|0;c[e+(d*44|0)+40>>2]=0;return}function wk(a){a=a|0;var b=0;b=a+264|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[a+536>>2]=0;c[a+532>>2]=0;c[a>>2]=1;return}function xk(a){a=a|0;lo(a+264|0);return}function yk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if((c[b>>2]|0)!=1){d=-1;return d|0}if(!e){mo(b+264|0,d)|0;d=b+276|0;a[d>>0]=71;a[d+1>>0]=69;a[d+2>>0]=84;a[d+3>>0]=0;c[b+532>>2]=0;c[b>>2]=2;d=0;return d|0}f=b+532|0;g=c[f>>2]|0;if(g){go(g);c[f>>2]=0}g=fo((Mn(e)|0)+1|0)|0;c[f>>2]=g;Kn(g,e)|0;e=c[f>>2]|0;mo(b+264|0,d)|0;d=b+276|0;a[d>>0]=a[30021]|0;a[d+1>>0]=a[30022]|0;a[d+2>>0]=a[30023]|0;a[d+3>>0]=a[30024]|0;a[d+4>>0]=a[30025]|0;c[f>>2]=e;c[b>>2]=2;d=0;return d|0}function zk(b,d){b=b|0;d=d|0;switch(d|0){case 0:{d=c[b>>2]|0;switch(d|0){case 3:case 2:{d=b+264|0;if(!(a[d>>0]&1))d=d+1|0;else d=c[b+272>>2]|0;Wb(d|0,b+276|0,c[b+532>>2]|0,b|0,1,4,5,6)|0;c[b>>2]=4;b=4;return b|0}case 5:{c[b>>2]=1;b=1;return b|0}default:{b=d;return b|0}}}case 1:{b=c[b+4>>2]|0;return b|0}default:{b=0;return b|0}}return 0}function Ak(a,b){a=a|0;b=b|0;var d=0;switch(b|0){case 16:{b=c[a+536>>2]|0;if(!b)d=4;break}case 17:{b=a+8|0;break}default:d=4}if((d|0)==4)b=30178;return b|0}function Bk(a,b,d){a=a|0;b=b|0;d=d|0;switch(b|0){case 16:{b=a+536|0;d=c[b>>2]|0;if(!d)return;go(d);c[b>>2]=0;return}case 17:{c[a>>2]=-1;Kn(a+8|0,d)|0;return}default:return}}function Ck(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;c[d>>2]=5;b=fo(f+1|0)|0;c[d+536>>2]=b;so(b|0,e|0,f|0)|0;a[b+f>>0]=0;c[d+4>>2]=f;return}function Dk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;a=i;i=i+272|0;g=a;f=a+8|0;c[g>>2]=d;c[g+4>>2]=e;fn(f,30026,g)|0;c[b>>2]=-1;Kn(b+8|0,f)|0;i=a;return}function Ek(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function Fk(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+192|0;j=h;c[j+16>>2]=0;c[j+32>>2]=0;c[j+176>>2]=a;c[j+168>>2]=a;c[j+172>>2]=a+b;e=Gk(j,d,e,f,g)|0;i=h;return e|0}
function Bm(a,b){a=+a;b=+b;var d=0,e=0,f=0,g=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0;h[k>>3]=a;d=c[k>>2]|0;m=c[k+4>>2]|0;h[k>>3]=b;n=c[k>>2]|0;o=c[k+4>>2]|0;e=vo(d|0,m|0,52)|0;e=e&2047;j=vo(n|0,o|0,52)|0;j=j&2047;p=m&-2147483648;i=wo(n|0,o|0,1)|0;l=D;a:do if(!((i|0)==0&(l|0)==0)?(g=o&2147483647,!(g>>>0>2146435072|(g|0)==2146435072&n>>>0>0|(e|0)==2047)):0){f=wo(d|0,m|0,1)|0;g=D;if(!(g>>>0>l>>>0|(g|0)==(l|0)&f>>>0>i>>>0))return +((f|0)==(i|0)&(g|0)==(l|0)?a*0.0:a);if(!e){e=wo(d|0,m|0,12)|0;f=D;if((f|0)>-1|(f|0)==-1&e>>>0>4294967295){g=e;e=0;do{e=e+-1|0;g=wo(g|0,f|0,1)|0;f=D}while((f|0)>-1|(f|0)==-1&g>>>0>4294967295)}else e=0;d=wo(d|0,m|0,1-e|0)|0;f=D}else f=m&1048575|1048576;if(!j){g=wo(n|0,o|0,12)|0;i=D;if((i|0)>-1|(i|0)==-1&g>>>0>4294967295){j=0;do{j=j+-1|0;g=wo(g|0,i|0,1)|0;i=D}while((i|0)>-1|(i|0)==-1&g>>>0>4294967295)}else j=0;n=wo(n|0,o|0,1-j|0)|0;m=D}else m=o&1048575|1048576;l=qo(d|0,f|0,n|0,m|0)|0;i=D;g=(i|0)>-1|(i|0)==-1&l>>>0>4294967295;b:do if((e|0)>(j|0)){while(1){if(g)if((d|0)==(n|0)&(f|0)==(m|0))break;else{d=l;f=i}d=wo(d|0,f|0,1)|0;f=D;e=e+-1|0;l=qo(d|0,f|0,n|0,m|0)|0;i=D;g=(i|0)>-1|(i|0)==-1&l>>>0>4294967295;if((e|0)<=(j|0))break b}b=a*0.0;break a}while(0);if(g)if((d|0)==(n|0)&(f|0)==(m|0)){b=a*0.0;break}else{f=i;d=l}if(f>>>0<1048576|(f|0)==1048576&d>>>0<0)do{d=wo(d|0,f|0,1)|0;f=D;e=e+-1|0}while(f>>>0<1048576|(f|0)==1048576&d>>>0<0);if((e|0)>0){o=ro(d|0,f|0,0,-1048576)|0;d=D;e=wo(e|0,0,52)|0;d=d|D;e=o|e}else{e=vo(d|0,f|0,1-e|0)|0;d=D}c[k>>2]=e;c[k+4>>2]=d|p;b=+h[k>>3]}else q=3;while(0);if((q|0)==3){b=a*b;b=b/b}return +b}function Cm(a,b){a=+a;b=+b;return +(+Bm(a,b))}function Dm(a,b){a=+a;b=b|0;var d=0,e=0,f=0;h[k>>3]=a;d=c[k>>2]|0;e=c[k+4>>2]|0;f=vo(d|0,e|0,52)|0;f=f&2047;switch(f|0){case 0:{if(a!=0.0){a=+Dm(a*18446744073709552.0e3,b);d=(c[b>>2]|0)+-64|0}else d=0;c[b>>2]=d;break}case 2047:break;default:{c[b>>2]=f+-1022;c[k>>2]=d;c[k+4>>2]=e&-2146435073|1071644672;a=+h[k>>3]}}return +a}function Em(a,b){a=+a;b=b|0;return +(+Dm(a,b))}function Fm(a,b){a=+a;b=b|0;return +(+Hm(a,b))}function Gm(a,b){a=+a;b=b|0;var d=0,e=0,f=0,g=0,i=0.0;h[k>>3]=a;f=c[k>>2]|0;g=c[k+4>>2]|0;d=vo(f|0,g|0,52)|0;d=d&2047;e=d+-1023|0;do if((e|0)>51){h[b>>3]=a;if((f|0)==0&(g&1048575|0)==0|(e|0)!=1024){c[k>>2]=0;c[k+4>>2]=g&-2147483648;a=+h[k>>3]}}else{if(d>>>0<1023){c[b>>2]=0;c[b+4>>2]=g&-2147483648;break}d=vo(-1,1048575,e|0)|0;e=D;if((d&f|0)==0&(e&g|0)==0){h[b>>3]=a;c[k>>2]=0;c[k+4>>2]=g&-2147483648;a=+h[k>>3];break}else{f=f&~d;g=g&~e;c[k>>2]=f;c[k+4>>2]=g;i=+h[k>>3];c[b>>2]=f;c[b+4>>2]=g;a=a-i;break}}while(0);return +a}function Hm(a,b){a=+a;b=b|0;var d=0;if((b|0)>1023){a=a*89884656743115795.0e291;d=b+-1023|0;if((d|0)>1023){d=b+-2046|0;d=(d|0)>1023?1023:d;a=a*89884656743115795.0e291}}else if((b|0)<-1022){a=a*2.2250738585072014e-308;d=b+1022|0;if((d|0)<-1022){d=b+2044|0;d=(d|0)<-1022?-1022:d;a=a*2.2250738585072014e-308}}else d=b;d=wo(d+1023|0,0,52)|0;b=D;c[k>>2]=d;c[k+4>>2]=b;return +(a*+h[k>>3])}function Im(a,b){a=+a;b=b|0;return +(+Hm(a,b))}function Jm(b,d,e){b=b|0;d=d|0;e=e|0;do if(b){if(d>>>0<128){a[b>>0]=d;b=1;break}if(d>>>0<2048){a[b>>0]=d>>>6|192;a[b+1>>0]=d&63|128;b=2;break}if(d>>>0<55296|(d&-8192|0)==57344){a[b>>0]=d>>>12|224;a[b+1>>0]=d>>>6&63|128;a[b+2>>0]=d&63|128;b=3;break}if((d+-65536|0)>>>0<1048576){a[b>>0]=d>>>18|240;a[b+1>>0]=d>>>12&63|128;a[b+2>>0]=d>>>6&63|128;a[b+3>>0]=d&63|128;b=4;break}else{c[(sm()|0)>>2]=84;b=-1;break}}else b=1;while(0);return b|0}function Km(a,b){a=a|0;b=b|0;if(!a)a=0;else a=Jm(a,b,0)|0;return a|0}function Lm(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[e>>2]=a;c[e+4>>2]=b;a=ym(nc(39,e|0)|0)|0;i=d;return a|0}function Mm(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[e>>2]=a;c[e+4>>2]=b;a=ym(bc(195,e|0)|0)|0;i=d;return a|0}function Nm(a){a=a|0;var b=0,d=0,e=0;if((c[a+76>>2]|0)>-1)nn(a)|0;e=(c[a>>2]&1|0)!=0;if(!e){Qa(23644);d=c[a+52>>2]|0;b=a+56|0;if(d)c[d+56>>2]=c[b>>2];b=c[b>>2]|0;if(b)c[b+52>>2]=d;if((c[5910]|0)==(a|0))c[5910]=b;Yc(23644)}b=Om(a)|0;b=rd[c[a+12>>2]&63](a)|0|b;d=c[a+92>>2]|0;if(d)go(d);if(!e)go(a);return b|0}function Om(a){a=a|0;var b=0,d=0;do if(a){if((c[a+76>>2]|0)<=-1){b=Wn(a)|0;break}d=(nn(a)|0)==0;b=Wn(a)|0;if(!d)on(a)}else{if(!(c[5918]|0))b=0;else b=Om(c[5918]|0)|0;Qa(23644);a=c[5910]|0;if(a)do{if((c[a+76>>2]|0)>-1)d=nn(a)|0;else d=0;if((c[a+20>>2]|0)>>>0>(c[a+28>>2]|0)>>>0)b=Wn(a)|0|b;if(d)on(a);a=c[a+56>>2]|0}while((a|0)!=0);Yc(23644)}while(0);return b|0}function Pm(a){a=a|0;var b=0,e=0,f=0;if((c[a+76>>2]|0)>=0?(nn(a)|0)!=0:0){b=a+4|0;e=c[b>>2]|0;if(e>>>0<(c[a+8>>2]|0)>>>0){c[b>>2]=e+1;b=d[e>>0]|0}else b=xn(a)|0;on(a)}else f=3;do if((f|0)==3){b=a+4|0;e=c[b>>2]|0;if(e>>>0<(c[a+8>>2]|0)>>>0){c[b>>2]=e+1;b=d[e>>0]|0;break}else{b=xn(a)|0;break}}while(0);return b|0}function Qm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=i;i=i+32|0;f=g+16|0;e=g;if(Cn(35258,a[d>>0]|0,4)|0){h=mn(d)|0|32768;c[e>>2]=b;c[e+4>>2]=h;c[e+8>>2]=438;e=ym(Db(5,e|0)|0)|0;if((e|0)>=0){b=ln(e,d)|0;if(!b){c[f>>2]=e;Cb(6,f|0)|0;b=0}}else b=0}else{c[(sm()|0)>>2]=22;b=0}i=g;return b|0}function Rm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=d;d=hn(a,b,f)|0;i=e;return d|0}function Sm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if((c[d+76>>2]|0)>=0?(nn(d)|0)!=0:0){if((a[d+75>>0]|0)!=(b|0)?(f=d+20|0,g=c[f>>2]|0,g>>>0<(c[d+16>>2]|0)>>>0):0){c[f>>2]=g+1;a[g>>0]=b;e=b&255}else e=pn(d,b)|0;on(d)}else i=3;do if((i|0)==3){if((a[d+75>>0]|0)!=(b|0)?(h=d+20|0,e=c[h>>2]|0,e>>>0<(c[d+16>>2]|0)>>>0):0){c[h>>2]=e+1;a[e>>0]=b;e=b&255;break}e=pn(d,b)|0}while(0);return e|0}function Tm(a,b){a=a|0;b=b|0;return (an(a,Mn(a)|0,1,b)|0)+-1|0}function Um(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;j=$(e,d)|0;if((c[f+76>>2]|0)>-1)k=nn(f)|0;else k=0;g=f+74|0;h=a[g>>0]|0;a[g>>0]=h+255|h;g=f+4|0;h=c[g>>2]|0;i=(c[f+8>>2]|0)-h|0;if((i|0)>0){i=i>>>0<j>>>0?i:j;so(b|0,h|0,i|0)|0;c[g>>2]=h+i;b=b+i|0;g=j-i|0}else g=j;a:do if(!g)l=13;else{i=f+32|0;h=g;while(1){if(vn(f)|0){e=h;break}g=jd[c[i>>2]&15](f,b,h)|0;if((g+1|0)>>>0<2){e=h;break}if((h|0)==(g|0)){l=13;break a}else{b=b+g|0;h=h-g|0}}if(k)on(f);e=((j-e|0)>>>0)/(d>>>0)|0}while(0);if((l|0)==13)if(k)on(f);return e|0}function Vm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;if((d|0)==1)b=b-(c[a+8>>2]|0)+(c[a+4>>2]|0)|0;f=a+20|0;e=a+28|0;if((c[f>>2]|0)>>>0>(c[e>>2]|0)>>>0?(jd[c[a+36>>2]&15](a,0,0)|0,(c[f>>2]|0)==0):0)b=-1;else{c[a+16>>2]=0;c[e>>2]=0;c[f>>2]=0;if((jd[c[a+40>>2]&15](a,b,d)|0)<0)b=-1;else{c[a+8>>2]=0;c[a+4>>2]=0;c[a>>2]=c[a>>2]&-17;b=0}}return b|0}function Wm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((c[a+76>>2]|0)>-1){e=(nn(a)|0)==0;b=Vm(a,b,d)|0;if(!e)on(a)}else b=Vm(a,b,d)|0;return b|0}function Xm(a,b,c){a=a|0;b=b|0;c=c|0;return Wm(a,b,c)|0}function Ym(a){a=a|0;var b=0;if(!(c[a>>2]&128))b=1;else b=(c[a+20>>2]|0)>>>0>(c[a+28>>2]|0)>>>0?2:1;b=jd[c[a+40>>2]&15](a,0,b)|0;if((b|0)>=0)b=b-(c[a+8>>2]|0)+(c[a+4>>2]|0)+(c[a+20>>2]|0)-(c[a+28>>2]|0)|0;return b|0}function Zm(a){a=a|0;var b=0,d=0;if((c[a+76>>2]|0)>-1){d=(nn(a)|0)==0;b=Ym(a)|0;if(!d)on(a)}else b=Ym(a)|0;return b|0}function _m(a){a=a|0;return Zm(a)|0}function $m(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=e+16|0;g=c[f>>2]|0;if(!g)if(!(wn(e)|0)){g=c[f>>2]|0;h=4}else f=0;else h=4;a:do if((h|0)==4){i=e+20|0;h=c[i>>2]|0;if((g-h|0)>>>0<d>>>0){f=jd[c[e+36>>2]&15](e,b,d)|0;break}b:do if((a[e+75>>0]|0)>-1){f=d;while(1){if(!f){g=h;f=0;break b}g=f+-1|0;if((a[b+g>>0]|0)==10)break;else f=g}if((jd[c[e+36>>2]&15](e,b,f)|0)>>>0<f>>>0)break a;d=d-f|0;b=b+f|0;g=c[i>>2]|0}else{g=h;f=0}while(0);so(g|0,b|0,d|0)|0;c[i>>2]=(c[i>>2]|0)+d;f=f+d|0}while(0);return f|0}function an(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=$(d,b)|0;if((c[e+76>>2]|0)>-1){g=(nn(e)|0)==0;a=$m(a,f,e)|0;if(!g)on(e)}else a=$m(a,f,e)|0;if((a|0)!=(f|0))d=(a>>>0)/(b>>>0)|0;return d|0}function bn(){return Pm(c[5916]|0)|0}function cn(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[e>>2]=b;b=hn(c[5917]|0,a,e)|0;i=d;return b|0}function dn(b){b=b|0;var d=0,e=0,f=0,g=0;f=c[5917]|0;if((c[f+76>>2]|0)>-1)g=nn(f)|0;else g=0;do if((Tm(b,f)|0)<0)d=1;else{if((a[f+75>>0]|0)!=10?(d=f+20|0,e=c[d>>2]|0,e>>>0<(c[f+16>>2]|0)>>>0):0){c[d>>2]=e+1;a[e>>0]=10;d=0;break}d=(pn(f,10)|0)<0}while(0);if(g)on(f);return d<<31>>31|0}function en(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;e=jn(a,b,d,g)|0;i=f;return e|0}function fn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=d;d=kn(a,b,f)|0;i=e;return d|0}function gn(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;do if((b|0)!=-1){if((c[d+76>>2]|0)>-1)g=nn(d)|0;else g=0;if(!((c[d+8>>2]|0)==0?(vn(d)|0)!=0:0))h=6;if((h|0)==6?(e=d+4|0,f=c[e>>2]|0,f>>>0>((c[d+44>>2]|0)+-8|0)>>>0):0){h=f+-1|0;c[e>>2]=h;a[h>>0]=b;c[d>>2]=c[d>>2]&-17;if(!g)break;on(d);break}if(g){on(d);b=-1}else b=-1}else b=-1;while(0);return b|0}function hn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+224|0;o=s+120|0;r=s+80|0;q=s;p=s+136|0;f=r;g=f+40|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[o>>2]=c[e>>2];if((Xn(0,d,o,q,r)|0)<0)e=-1;else{if((c[b+76>>2]|0)>-1)m=nn(b)|0;else m=0;e=c[b>>2]|0;n=e&32;if((a[b+74>>0]|0)<1)c[b>>2]=e&-33;e=b+48|0;if(!(c[e>>2]|0)){g=b+44|0;h=c[g>>2]|0;c[g>>2]=p;j=b+28|0;c[j>>2]=p;k=b+20|0;c[k>>2]=p;c[e>>2]=80;l=b+16|0;c[l>>2]=p+80;f=Xn(b,d,o,q,r)|0;if(h){jd[c[b+36>>2]&15](b,0,0)|0;f=(c[k>>2]|0)==0?-1:f;c[g>>2]=h;c[e>>2]=0;c[l>>2]=0;c[j>>2]=0;c[k>>2]=0}}else f=Xn(b,d,o,q,r)|0;e=c[b>>2]|0;c[b>>2]=e|n;if(m)on(b);e=(e&32|0)==0?f:-1}i=s;return e|0}function jn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+128|0;g=n+112|0;m=n;h=m;j=23712;k=h+112|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));if((d+-1|0)>>>0>2147483646)if(!d){d=1;l=4}else{c[(sm()|0)>>2]=75;d=-1}else{g=b;l=4}if((l|0)==4){l=-2-g|0;l=d>>>0>l>>>0?l:d;c[m+48>>2]=l;b=m+20|0;c[b>>2]=g;c[m+44>>2]=g;d=g+l|0;g=m+16|0;c[g>>2]=d;c[m+28>>2]=d;d=hn(m,e,f)|0;if(l){e=c[b>>2]|0;a[e+(((e|0)==(c[g>>2]|0))<<31>>31)>>0]=0}}i=n;return d|0}function kn(a,b,c){a=a|0;b=b|0;c=c|0;return jn(a,2147483647,b,c)|0}function ln(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+112|0;n=o+40|0;l=o+24|0;k=o+16|0;g=o;m=o+52|0;f=a[d>>0]|0;if(Cn(35258,f<<24>>24,4)|0){e=fo(1144)|0;if(!e)e=0;else{h=e;j=h+112|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0));if(!(Hn(d,43)|0))c[e>>2]=f<<24>>24==114?8:4;if(Hn(d,101)|0){c[g>>2]=b;c[g+4>>2]=2;c[g+8>>2]=1;Pa(221,g|0)|0;f=a[d>>0]|0}if(f<<24>>24==97){c[k>>2]=b;c[k+4>>2]=3;f=Pa(221,k|0)|0;if(!(f&1024)){c[l>>2]=b;c[l+4>>2]=4;c[l+8>>2]=f|1024;Pa(221,l|0)|0}d=c[e>>2]|128;c[e>>2]=d}else d=c[e>>2]|0;c[e+60>>2]=b;c[e+44>>2]=e+120;c[e+48>>2]=1024;f=e+75|0;a[f>>0]=-1;if((d&8|0)==0?(c[n>>2]=b,c[n+4>>2]=21505,c[n+8>>2]=m,(Xc(54,n|0)|0)==0):0)a[f>>0]=10;c[e+32>>2]=6;c[e+36>>2]=4;c[e+40>>2]=5;c[e+12>>2]=2;if(!(c[5905]|0))c[e+76>>2]=-1;Qa(23644);f=c[5910]|0;c[e+56>>2]=f;if(f)c[f+52>>2]=e;c[5910]=e;Yc(23644)}}else{c[(sm()|0)>>2]=22;e=0}i=o;return e|0}function mn(b){b=b|0;var c=0,d=0,e=0;d=(Hn(b,43)|0)==0;c=a[b>>0]|0;d=d?c<<24>>24!=114&1:2;e=(Hn(b,120)|0)==0;d=e?d:d|128;b=(Hn(b,101)|0)==0;b=b?d:d|524288;b=c<<24>>24==114?b:b|64;b=c<<24>>24==119?b|512:b;return (c<<24>>24==97?b|1024:b)|0}function nn(a){a=a|0;return 0}function on(a){a=a|0;return}function pn(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;l=m;k=e&255;a[l>>0]=k;g=b+16|0;h=c[g>>2]|0;if(!h)if(!(wn(b)|0)){h=c[g>>2]|0;j=4}else f=-1;else j=4;do if((j|0)==4){g=b+20|0;j=c[g>>2]|0;if(j>>>0<h>>>0?(f=e&255,(f|0)!=(a[b+75>>0]|0)):0){c[g>>2]=j+1;a[j>>0]=k;break}if((jd[c[b+36>>2]&15](b,l,1)|0)==1)f=d[l>>0]|0;else f=-1}while(0);i=m;return f|0}function qn(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=c[a+60>>2];a=ym(Cb(6,d|0)|0)|0;i=b;return a|0}function rn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+48|0;h=m+16|0;g=m;f=m+32|0;c[f>>2]=d;j=f+4|0;l=b+48|0;n=c[l>>2]|0;c[j>>2]=e-((n|0)!=0&1);k=b+44|0;c[f+8>>2]=c[k>>2];c[f+12>>2]=n;if(!(c[5904]|0)){c[h>>2]=c[b+60>>2];c[h+4>>2]=f;c[h+8>>2]=2;f=ym($a(145,h|0)|0)|0}else{Xa(36,b|0);c[g>>2]=c[b+60>>2];c[g+4>>2]=f;c[g+8>>2]=2;f=ym($a(145,g|0)|0)|0;bb(0)}if((f|0)>=1){j=c[j>>2]|0;if(f>>>0>j>>>0){h=c[k>>2]|0;g=b+4|0;c[g>>2]=h;c[b+8>>2]=h+(f-j);if(!(c[l>>2]|0))f=e;else{c[g>>2]=h+1;a[d+(e+-1)>>0]=a[h>>0]|0;f=e}}}else{c[b>>2]=c[b>>2]|f&48^16;c[b+8>>2]=0;c[b+4>>2]=0}i=m;return f|0}function sn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+32|0;g=f;e=f+20|0;c[g>>2]=c[a+60>>2];c[g+4>>2]=0;c[g+8>>2]=b;c[g+12>>2]=e;c[g+16>>2]=d;if((ym(_a(140,g|0)|0)|0)<0){c[e>>2]=-1;a=-1}else a=c[e>>2]|0;i=f;return a|0}function tn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+48|0;n=q+16|0;m=q;e=q+32|0;o=a+28|0;f=c[o>>2]|0;c[e>>2]=f;p=a+20|0;f=(c[p>>2]|0)-f|0;c[e+4>>2]=f;c[e+8>>2]=b;c[e+12>>2]=d;k=a+60|0;l=a+44|0;b=2;f=f+d|0;while(1){if(!(c[5904]|0)){c[n>>2]=c[k>>2];c[n+4>>2]=e;c[n+8>>2]=b;h=ym(ab(146,n|0)|0)|0}else{Xa(37,a|0);c[m>>2]=c[k>>2];c[m+4>>2]=e;c[m+8>>2]=b;h=ym(ab(146,m|0)|0)|0;bb(0)}if((f|0)==(h|0)){f=6;break}if((h|0)<0){f=8;break}f=f-h|0;g=c[e+4>>2]|0;if(h>>>0<=g>>>0)if((b|0)==2){c[o>>2]=(c[o>>2]|0)+h;j=g;b=2}else j=g;else{j=c[l>>2]|0;c[o>>2]=j;c[p>>2]=j;j=c[e+12>>2]|0;h=h-g|0;e=e+8|0;b=b+-1|0}c[e>>2]=(c[e>>2]|0)+h;c[e+4>>2]=j-h}if((f|0)==6){n=c[l>>2]|0;c[a+16>>2]=n+(c[a+48>>2]|0);a=n;c[o>>2]=a;c[p>>2]=a}else if((f|0)==8){c[a+16>>2]=0;c[o>>2]=0;c[p>>2]=0;c[a>>2]=c[a>>2]|32;if((b|0)==2)d=0;else d=d-(c[e+4>>2]|0)|0}i=q;return d|0}function un(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+80|0;f=g;c[b+36>>2]=4;if((c[b>>2]&64|0)==0?(c[f>>2]=c[b+60>>2],c[f+4>>2]=21505,c[f+8>>2]=g+12,(Xc(54,f|0)|0)!=0):0)a[b+75>>0]=-1;f=tn(b,d,e)|0;i=g;return f|0}function vn(b){b=b|0;var d=0,e=0;d=b+74|0;e=a[d>>0]|0;a[d>>0]=e+255|e;d=b+20|0;e=b+44|0;if((c[d>>2]|0)>>>0>(c[e>>2]|0)>>>0)jd[c[b+36>>2]&15](b,0,0)|0;c[b+16>>2]=0;c[b+28>>2]=0;c[d>>2]=0;d=c[b>>2]|0;if(d&20)if(!(d&4))d=-1;else{c[b>>2]=d|32;d=-1}else{d=c[e>>2]|0;c[b+8>>2]=d;c[b+4>>2]=d;d=0}return d|0}function wn(b){b=b|0;var d=0,e=0;d=b+74|0;e=a[d>>0]|0;a[d>>0]=e+255|e;d=c[b>>2]|0;if(!(d&8)){c[b+8>>2]=0;c[b+4>>2]=0;d=c[b+44>>2]|0;c[b+28>>2]=d;c[b+20>>2]=d;c[b+16>>2]=d+(c[b+48>>2]|0);d=0}else{c[b>>2]=d|32;d=-1}return d|0}function xn(a){a=a|0;var b=0,e=0;e=i;i=i+16|0;b=e;if((c[a+8>>2]|0)==0?(vn(a)|0)!=0:0)b=-1;else if((jd[c[a+32>>2]&15](a,b,1)|0)==1)b=d[b>>0]|0;else b=-1;i=e;return b|0}function yn(a){a=a|0;return +(+An(a,0))}function zn(b){b=b|0;var c=0,d=0,e=0,f=0;while(1){c=b+1|0;if(!(lm(a[b>>0]|0)|0))break;else b=c}d=a[b>>0]|0;switch(d<<24>>24|0){case 45:{e=1;f=5;break}case 43:{e=0;f=5;break}default:e=0}if((f|0)==5){b=c;d=a[c>>0]|0}c=(d<<24>>24)+-48|0;if(c>>>0<10){d=b;b=0;do{d=d+1|0;b=(b*10|0)-c|0;c=(a[d>>0]|0)+-48|0}while(c>>>0<10)}else b=0;return ((e|0)!=0?b:0-b|0)|0}function An(a,b){a=a|0;b=b|0;return +(+_n(a,b,1))}function Bn(a,b,c){a=a|0;b=b|0;c=c|0;a=$n(a,b,c,-2147483648,0)|0;return a|0}function Cn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=d&255;f=(e|0)!=0;a:do if(f&(b&3|0)!=0){g=d&255;while(1){if((a[b>>0]|0)==g<<24>>24){i=6;break a}b=b+1|0;e=e+-1|0;f=(e|0)!=0;if(!(f&(b&3|0)!=0)){i=5;break}}}else i=5;while(0);if((i|0)==5)if(f)i=6;else e=0;b:do if((i|0)==6){g=d&255;if((a[b>>0]|0)!=g<<24>>24){f=$(h,16843009)|0;c:do if(e>>>0>3)while(1){h=c[b>>2]^f;if((h&-2139062144^-2139062144)&h+-16843009)break;b=b+4|0;e=e+-4|0;if(e>>>0<=3){i=11;break c}}else i=11;while(0);if((i|0)==11)if(!e){e=0;break}while(1){if((a[b>>0]|0)==g<<24>>24)break b;b=b+1|0;e=e+-1|0;if(!e){e=0;break}}}}while(0);return ((e|0)!=0?b:0)|0}function Dn(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0;a:do if(!d)d=0;else{f=d;e=b;while(1){b=a[e>>0]|0;d=a[c>>0]|0;if(b<<24>>24!=d<<24>>24)break;f=f+-1|0;if(!f){d=0;break a}else{e=e+1|0;c=c+1|0}}d=(b&255)-(d&255)|0}while(0);return d|0}function En(b,d){b=b|0;d=d|0;var e=0,f=0;e=d;a:do if(!((e^b)&3)){if(e&3)do{e=a[d>>0]|0;a[b>>0]=e;if(!(e<<24>>24))break a;d=d+1|0;b=b+1|0}while((d&3|0)!=0);e=c[d>>2]|0;if(!((e&-2139062144^-2139062144)&e+-16843009)){f=b;while(1){d=d+4|0;b=f+4|0;c[f>>2]=e;e=c[d>>2]|0;if((e&-2139062144^-2139062144)&e+-16843009)break;else f=b}}f=8}else f=8;while(0);if((f|0)==8){f=a[d>>0]|0;a[b>>0]=f;if(f<<24>>24)do{d=d+1|0;b=b+1|0;f=a[d>>0]|0;a[b>>0]=f}while(f<<24>>24!=0)}return b|0}function Fn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=d;do if(!((g^b)&3)){f=(e|0)!=0;a:do if(f&(g&3|0)!=0)while(1){g=a[d>>0]|0;a[b>>0]=g;if(!(g<<24>>24))break a;e=e+-1|0;d=d+1|0;b=b+1|0;f=(e|0)!=0;if(!(f&(d&3|0)!=0)){h=5;break}}else h=5;while(0);if((h|0)==5)if(!f){e=0;break}if(a[d>>0]|0){b:do if(e>>>0>3)do{f=c[d>>2]|0;if((f&-2139062144^-2139062144)&f+-16843009)break b;c[b>>2]=f;e=e+-4|0;d=d+4|0;b=b+4|0}while(e>>>0>3);while(0);h=11}}else h=11;while(0);c:do if((h|0)==11)if(!e)e=0;else while(1){h=a[d>>0]|0;a[b>>0]=h;if(!(h<<24>>24))break c;e=e+-1|0;b=b+1|0;if(!e){e=0;break}else d=d+1|0}while(0);uo(b|0,0,e|0)|0;return b|0}function Gn(a,b){a=a|0;b=b|0;Kn(a+(Mn(a)|0)|0,b)|0;return a|0}function Hn(b,c){b=b|0;c=c|0;b=In(b,c)|0;return ((a[b>>0]|0)==(c&255)<<24>>24?b:0)|0}function In(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=d&255;a:do if(!f)b=b+(Mn(b)|0)|0;else{if(b&3){e=d&255;do{g=a[b>>0]|0;if(g<<24>>24==0?1:g<<24>>24==e<<24>>24)break a;b=b+1|0}while((b&3|0)!=0)}f=$(f,16843009)|0;e=c[b>>2]|0;b:do if(!((e&-2139062144^-2139062144)&e+-16843009))do{g=e^f;if((g&-2139062144^-2139062144)&g+-16843009)break b;b=b+4|0;e=c[b>>2]|0}while(((e&-2139062144^-2139062144)&e+-16843009|0)==0);while(0);e=d&255;while(1){g=a[b>>0]|0;if(g<<24>>24==0?1:g<<24>>24==e<<24>>24)break;else b=b+1|0}}while(0);return b|0}function Jn(b,c){b=b|0;c=c|0;var d=0,e=0;e=a[b>>0]|0;d=a[c>>0]|0;if(e<<24>>24==0?1:e<<24>>24!=d<<24>>24)c=e;else{do{b=b+1|0;c=c+1|0;e=a[b>>0]|0;d=a[c>>0]|0}while(!(e<<24>>24==0?1:e<<24>>24!=d<<24>>24));c=e}return (c&255)-(d&255)|0}function Kn(a,b){a=a|0;b=b|0;En(a,b)|0;return a|0}function Ln(a){a=a|0;var b=0,c=0;c=(Mn(a)|0)+1|0;b=fo(c)|0;if(!b)b=0;else so(b|0,a|0,c|0)|0;return b|0}function Mn(b){b=b|0;var d=0,e=0,f=0;f=b;a:do if(!(f&3))e=4;else{d=b;b=f;while(1){if(!(a[d>>0]|0))break a;d=d+1|0;b=d;if(!(b&3)){b=d;e=4;break}}}while(0);if((e|0)==4){while(1){d=c[b>>2]|0;if(!((d&-2139062144^-2139062144)&d+-16843009))b=b+4|0;else break}if((d&255)<<24>>24)do b=b+1|0;while((a[b>>0]|0)!=0)}return b-f|0}function Nn(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;e=b+(Mn(b)|0)|0;a:do if(d)while(1){f=a[c>>0]|0;if(!(f<<24>>24))break a;d=d+-1|0;g=e+1|0;a[e>>0]=f;if(!d){e=g;break}else{c=c+1|0;e=g}}while(0);a[e>>0]=0;return b|0}function On(b,c,e){b=b|0;c=c|0;e=e|0;var f=0,g=0;if(!e)c=0;else{f=a[b>>0]|0;a:do if(!(f<<24>>24))f=0;else while(1){e=e+-1|0;g=a[c>>0]|0;if(!(f<<24>>24==g<<24>>24&((e|0)!=0&g<<24>>24!=0)))break a;b=b+1|0;c=c+1|0;f=a[b>>0]|0;if(!(f<<24>>24)){f=0;break}}while(0);c=(f&255)-(d[c>>0]|0)|0}return c|0}function Pn(a,b,c){a=a|0;b=b|0;c=c|0;Fn(a,b,c)|0;return a|0}function Qn(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;i=i+32|0;g=h;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;c[g+24>>2]=0;c[g+28>>2]=0;f=a[d>>0]|0;do if(!(f<<24>>24))d=0;else{if(!(a[d+1>>0]|0)){d=b;while(1)if((a[d>>0]|0)==f<<24>>24)d=d+1|0;else break;d=d-b|0;break}else{e=d;d=f}do{f=g+(((d&255)>>>5&255)<<2)|0;c[f>>2]=c[f>>2]|1<<(d&31);e=e+1|0;d=a[e>>0]|0}while(d<<24>>24!=0);e=a[b>>0]|0;a:do if(!(e<<24>>24))d=b;else{d=b;do{if(!(c[g+(((e&255)>>>5&255)<<2)>>2]&1<<(e&31)))break a;d=d+1|0;e=a[d>>0]|0}while(e<<24>>24!=0)}while(0);d=d-b|0}while(0);i=h;return d|0}function Rn(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=ym(wb(12,d|0)|0)|0;i=b;return a|0}function Sn(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=Cb(6,d|0)|0;a=ym((a|0)==-4?-115:a)|0;i=b;return a|0}function Tn(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;i=i+4112|0;e=g;d=g+8|0;if(a)if(!b){c[(sm()|0)>>2]=22;a=0}else f=4;else{b=4096;a=d;f=4}if((f|0)==4){c[e>>2]=a;c[e+4>>2]=b;if((ym(tc(183,e|0)|0)|0)>=0){if((a|0)==(d|0))a=Ln(d)|0}else a=0}i=g;return a|0}function Un(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=ym(yb(10,d|0)|0)|0;i=b;return a|0}function Vn(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0;i=a+4|0;e=c[i>>2]|0;j=a+100|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=xm(a)|0;switch(e|0){case 43:case 45:{f=(e|0)==45&1;e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=xm(a)|0;if((b|0)!=0&(e+-48|0)>>>0>9?(c[j>>2]|0)!=0:0){c[i>>2]=(c[i>>2]|0)+-1;h=f}else h=f;break}default:h=0}if((e+-48|0)>>>0>9)if(!(c[j>>2]|0)){f=-2147483648;e=0}else{c[i>>2]=(c[i>>2]|0)+-1;f=-2147483648;e=0}else{f=0;do{f=e+-48+(f*10|0)|0;e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=xm(a)|0}while((e+-48|0)>>>0<10&(f|0)<214748364);b=((f|0)<0)<<31>>31;if((e+-48|0)>>>0<10){do{b=Co(f|0,b|0,10,0)|0;f=D;e=ro(e|0,((e|0)<0)<<31>>31|0,-48,-1)|0;f=ro(e|0,D|0,b|0,f|0)|0;b=D;e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=xm(a)|0}while((e+-48|0)>>>0<10&((b|0)<21474836|(b|0)==21474836&f>>>0<2061584302));g=f}else g=f;if((e+-48|0)>>>0<10)do{e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=xm(a)|0}while((e+-48|0)>>>0<10);if(c[j>>2]|0)c[i>>2]=(c[i>>2]|0)+-1;a=(h|0)!=0;e=qo(0,0,g|0,b|0)|0;f=a?D:b;e=a?e:g}D=f;return e|0}function Wn(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=a+20|0;g=a+28|0;if((c[b>>2]|0)>>>0>(c[g>>2]|0)>>>0?(jd[c[a+36>>2]&15](a,0,0)|0,(c[b>>2]|0)==0):0)b=-1;else{h=a+4|0;d=c[h>>2]|0;e=a+8|0;f=c[e>>2]|0;if(d>>>0<f>>>0)jd[c[a+40>>2]&15](a,d-f|0,1)|0;c[a+16>>2]=0;c[g>>2]=0;c[b>>2]=0;c[e>>2]=0;c[h>>2]=0;b=0}return b|0}function Xn(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0;ha=i;i=i+624|0;ca=ha+24|0;ea=ha+16|0;da=ha+588|0;Y=ha+576|0;ba=ha;V=ha+536|0;ga=ha+8|0;fa=ha+528|0;M=(e|0)!=0;N=V+40|0;U=N;V=V+39|0;W=ga+4|0;X=Y+12|0;Y=Y+11|0;Z=da;_=X;aa=_-Z|0;O=-2-Z|0;P=_+2|0;Q=ca+288|0;R=da+9|0;S=R;T=da+8|0;m=0;w=f;n=0;f=0;a:while(1){do if((m|0)>-1)if((n|0)>(2147483647-m|0)){c[(sm()|0)>>2]=75;m=-1;break}else{m=n+m|0;break}while(0);n=a[w>>0]|0;if(!(n<<24>>24)){L=245;break}else o=w;b:while(1){switch(n<<24>>24){case 37:{n=o;L=9;break b}case 0:{n=o;break b}default:{}}K=o+1|0;n=a[K>>0]|0;o=K}c:do if((L|0)==9)while(1){L=0;if((a[n+1>>0]|0)!=37)break c;o=o+1|0;n=n+2|0;if((a[n>>0]|0)==37)L=9;else break}while(0);y=o-w|0;if(M?(c[e>>2]&32|0)==0:0)$m(w,y,e)|0;if((o|0)!=(w|0)){w=n;n=y;continue}r=n+1|0;o=a[r>>0]|0;p=(o<<24>>24)+-48|0;if(p>>>0<10){K=(a[n+2>>0]|0)==36;r=K?n+3|0:r;o=a[r>>0]|0;u=K?p:-1;f=K?1:f}else u=-1;n=o<<24>>24;d:do if((n&-32|0)==32){p=0;while(1){if(!(1<<n+-32&75913)){s=p;n=r;break d}p=1<<(o<<24>>24)+-32|p;r=r+1|0;o=a[r>>0]|0;n=o<<24>>24;if((n&-32|0)!=32){s=p;n=r;break}}}else{s=0;n=r}while(0);do if(o<<24>>24==42){p=n+1|0;o=(a[p>>0]|0)+-48|0;if(o>>>0<10?(a[n+2>>0]|0)==36:0){c[l+(o<<2)>>2]=10;f=1;n=n+3|0;o=c[j+((a[p>>0]|0)+-48<<3)>>2]|0}else{if(f){m=-1;break a}if(!M){x=s;n=p;f=0;K=0;break}f=(c[g>>2]|0)+(4-1)&~(4-1);o=c[f>>2]|0;c[g>>2]=f+4;f=0;n=p}if((o|0)<0){x=s|8192;K=0-o|0}else{x=s;K=o}}else{p=(o<<24>>24)+-48|0;if(p>>>0<10){o=0;do{o=(o*10|0)+p|0;n=n+1|0;p=(a[n>>0]|0)+-48|0}while(p>>>0<10);if((o|0)<0){m=-1;break a}else{x=s;K=o}}else{x=s;K=0}}while(0);e:do if((a[n>>0]|0)==46){p=n+1|0;o=a[p>>0]|0;if(o<<24>>24!=42){r=(o<<24>>24)+-48|0;if(r>>>0<10){n=p;o=0}else{n=p;r=0;break}while(1){o=(o*10|0)+r|0;n=n+1|0;r=(a[n>>0]|0)+-48|0;if(r>>>0>=10){r=o;break e}}}p=n+2|0;o=(a[p>>0]|0)+-48|0;if(o>>>0<10?(a[n+3>>0]|0)==36:0){c[l+(o<<2)>>2]=10;n=n+4|0;r=c[j+((a[p>>0]|0)+-48<<3)>>2]|0;break}if(f){m=-1;break a}if(M){n=(c[g>>2]|0)+(4-1)&~(4-1);r=c[n>>2]|0;c[g>>2]=n+4;n=p}else{n=p;r=0}}else r=-1;while(0);t=0;while(1){o=(a[n>>0]|0)+-65|0;if(o>>>0>57){m=-1;break a}p=n+1|0;o=a[37334+(t*58|0)+o>>0]|0;s=o&255;if((s+-1|0)>>>0<8){n=p;t=s}else{J=p;break}}if(!(o<<24>>24)){m=-1;break}p=(u|0)>-1;do if(o<<24>>24==19)if(p){m=-1;break a}else L=52;else{if(p){c[l+(u<<2)>>2]=s;H=j+(u<<3)|0;I=c[H+4>>2]|0;L=ba;c[L>>2]=c[H>>2];c[L+4>>2]=I;L=52;break}if(!M){m=0;break a}bo(ba,s,g)}while(0);if((L|0)==52?(L=0,!M):0){w=J;n=y;continue}u=a[n>>0]|0;u=(t|0)!=0&(u&15|0)==3?u&-33:u;p=x&-65537;I=(x&8192|0)==0?x:p;f:do switch(u|0){case 110:switch(t|0){case 0:{c[c[ba>>2]>>2]=m;w=J;n=y;continue a}case 1:{c[c[ba>>2]>>2]=m;w=J;n=y;continue a}case 2:{w=c[ba>>2]|0;c[w>>2]=m;c[w+4>>2]=((m|0)<0)<<31>>31;w=J;n=y;continue a}case 3:{b[c[ba>>2]>>1]=m;w=J;n=y;continue a}case 4:{a[c[ba>>2]>>0]=m;w=J;n=y;continue a}case 6:{c[c[ba>>2]>>2]=m;w=J;n=y;continue a}case 7:{w=c[ba>>2]|0;c[w>>2]=m;c[w+4>>2]=((m|0)<0)<<31>>31;w=J;n=y;continue a}default:{w=J;n=y;continue a}}case 112:{t=I|8;r=r>>>0>8?r:8;u=120;L=64;break}case 88:case 120:{t=I;L=64;break}case 111:{p=ba;o=c[p>>2]|0;p=c[p+4>>2]|0;if((o|0)==0&(p|0)==0)n=N;else{n=N;do{n=n+-1|0;a[n>>0]=o&7|48;o=vo(o|0,p|0,3)|0;p=D}while(!((o|0)==0&(p|0)==0))}if(!(I&8)){o=I;t=0;s=37814;L=77}else{t=U-n+1|0;o=I;r=(r|0)<(t|0)?t:r;t=0;s=37814;L=77}break}case 105:case 100:{o=ba;n=c[o>>2]|0;o=c[o+4>>2]|0;if((o|0)<0){n=qo(0,0,n|0,o|0)|0;o=D;p=ba;c[p>>2]=n;c[p+4>>2]=o;p=1;s=37814;L=76;break f}if(!(I&2048)){s=I&1;p=s;s=(s|0)==0?37814:37816;L=76}else{p=1;s=37815;L=76}break}case 117:{o=ba;n=c[o>>2]|0;o=c[o+4>>2]|0;p=0;s=37814;L=76;break}case 99:{a[V>>0]=c[ba>>2];w=V;o=1;t=0;u=37814;n=N;break}case 109:{n=rm(c[(sm()|0)>>2]|0)|0;L=82;break}case 115:{n=c[ba>>2]|0;n=(n|0)!=0?n:37824;L=82;break}case 67:{c[ga>>2]=c[ba>>2];c[W>>2]=0;c[ba>>2]=ga;r=-1;L=86;break}case 83:{if(!r){eo(e,32,K,0,I);n=0;L=98}else L=86;break}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{q=+h[ba>>3];c[ea>>2]=0;h[k>>3]=q;if((c[k+4>>2]|0)>=0)if(!(I&2048)){H=I&1;G=H;H=(H|0)==0?37832:37837}else{G=1;H=37834}else{q=-q;G=1;H=37831}h[k>>3]=q;F=c[k+4>>2]&2146435072;do if(F>>>0<2146435072|(F|0)==2146435072&0<0){v=+Em(q,ea)*2.0;o=v!=0.0;if(o)c[ea>>2]=(c[ea>>2]|0)+-1;C=u|32;if((C|0)==97){w=u&32;y=(w|0)==0?H:H+9|0;x=G|2;n=12-r|0;do if(!(r>>>0>11|(n|0)==0)){q=8.0;do{n=n+-1|0;q=q*16.0}while((n|0)!=0);if((a[y>>0]|0)==45){q=-(q+(-v-q));break}else{q=v+q-q;break}}else q=v;while(0);o=c[ea>>2]|0;n=(o|0)<0?0-o|0:o;n=co(n,((n|0)<0)<<31>>31,X)|0;if((n|0)==(X|0)){a[Y>>0]=48;n=Y}a[n+-1>>0]=(o>>31&2)+43;t=n+-2|0;a[t>>0]=u+15;s=(r|0)<1;p=(I&8|0)==0;o=da;while(1){H=~~q;n=o+1|0;a[o>>0]=d[37798+H>>0]|w;q=(q-+(H|0))*16.0;do if((n-Z|0)==1){if(p&(s&q==0.0))break;a[n>>0]=46;n=o+2|0}while(0);if(!(q!=0.0))break;else o=n}r=(r|0)!=0&(O+n|0)<(r|0)?P+r-t|0:aa-t+n|0;p=r+x|0;eo(e,32,K,p,I);if(!(c[e>>2]&32))$m(y,x,e)|0;eo(e,48,K,p,I^65536);n=n-Z|0;if(!(c[e>>2]&32))$m(da,n,e)|0;o=_-t|0;eo(e,48,r-(n+o)|0,0,0);if(!(c[e>>2]&32))$m(t,o,e)|0;eo(e,32,K,p,I^8192);n=(p|0)<(K|0)?K:p;break}n=(r|0)<0?6:r;if(o){o=(c[ea>>2]|0)+-28|0;c[ea>>2]=o;q=v*268435456.0}else{q=v;o=c[ea>>2]|0}F=(o|0)<0?ca:Q;E=F;o=F;do{B=~~q>>>0;c[o>>2]=B;o=o+4|0;q=(q-+(B>>>0))*1.0e9}while(q!=0.0);p=o;o=c[ea>>2]|0;if((o|0)>0){s=F;while(1){t=(o|0)>29?29:o;r=p+-4|0;do if(r>>>0<s>>>0)r=s;else{o=0;do{B=wo(c[r>>2]|0,0,t|0)|0;B=ro(B|0,D|0,o|0,0)|0;o=D;A=Eo(B|0,o|0,1e9,0)|0;c[r>>2]=A;o=Do(B|0,o|0,1e9,0)|0;r=r+-4|0}while(r>>>0>=s>>>0);if(!o){r=s;break}r=s+-4|0;c[r>>2]=o}while(0);while(1){if(p>>>0<=r>>>0)break;o=p+-4|0;if(!(c[o>>2]|0))p=o;else break}o=(c[ea>>2]|0)-t|0;c[ea>>2]=o;if((o|0)>0)s=r;else break}}else r=F;if((o|0)<0){y=((n+25|0)/9|0)+1|0;z=(C|0)==102;w=r;while(1){x=0-o|0;x=(x|0)>9?9:x;do if(w>>>0<p>>>0){o=(1<<x)+-1|0;s=1e9>>>x;r=0;t=w;do{B=c[t>>2]|0;c[t>>2]=(B>>>x)+r;r=$(B&o,s)|0;t=t+4|0}while(t>>>0<p>>>0);o=(c[w>>2]|0)==0?w+4|0:w;if(!r){r=o;break}c[p>>2]=r;r=o;p=p+4|0}else r=(c[w>>2]|0)==0?w+4|0:w;while(0);o=z?F:r;p=(p-o>>2|0)>(y|0)?o+(y<<2)|0:p;o=(c[ea>>2]|0)+x|0;c[ea>>2]=o;if((o|0)>=0){w=r;break}else w=r}}else w=r;do if(w>>>0<p>>>0){o=(E-w>>2)*9|0;s=c[w>>2]|0;if(s>>>0<10)break;else r=10;do{r=r*10|0;o=o+1|0}while(s>>>0>=r>>>0)}else o=0;while(0);A=(C|0)==103;B=(n|0)!=0;r=n-((C|0)!=102?o:0)+((B&A)<<31>>31)|0;if((r|0)<(((p-E>>2)*9|0)+-9|0)){t=r+9216|0;z=(t|0)/9|0;r=F+(z+-1023<<2)|0;t=((t|0)%9|0)+1|0;if((t|0)<9){s=10;do{s=s*10|0;t=t+1|0}while((t|0)!=9)}else s=10;x=c[r>>2]|0;y=(x>>>0)%(s>>>0)|0;if((y|0)==0?(F+(z+-1022<<2)|0)==(p|0):0)s=w;else L=163;do if((L|0)==163){L=0;v=(((x>>>0)/(s>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;t=(s|0)/2|0;do if(y>>>0<t>>>0)q=.5;else{if((y|0)==(t|0)?(F+(z+-1022<<2)|0)==(p|0):0){q=1.0;break}q=1.5}while(0);do if(G){if((a[H>>0]|0)!=45)break;v=-v;q=-q}while(0);t=x-y|0;c[r>>2]=t;if(!(v+q!=v)){s=w;break}C=t+s|0;c[r>>2]=C;if(C>>>0>999999999){o=w;while(1){s=r+-4|0;c[r>>2]=0;if(s>>>0<o>>>0){o=o+-4|0;c[o>>2]=0}C=(c[s>>2]|0)+1|0;c[s>>2]=C;if(C>>>0>999999999)r=s;else{w=o;r=s;break}}}o=(E-w>>2)*9|0;t=c[w>>2]|0;if(t>>>0<10){s=w;break}else s=10;do{s=s*10|0;o=o+1|0}while(t>>>0>=s>>>0);s=w}while(0);C=r+4|0;w=s;p=p>>>0>C>>>0?C:p}y=0-o|0;while(1){if(p>>>0<=w>>>0){z=0;C=p;break}r=p+-4|0;if(!(c[r>>2]|0))p=r;else{z=1;C=p;break}}do if(A){n=(B&1^1)+n|0;if((n|0)>(o|0)&(o|0)>-5){u=u+-1|0;n=n+-1-o|0}else{u=u+-2|0;n=n+-1|0}p=I&8;if(p)break;do if(z){p=c[C+-4>>2]|0;if(!p){r=9;break}if(!((p>>>0)%10|0)){s=10;r=0}else{r=0;break}do{s=s*10|0;r=r+1|0}while(((p>>>0)%(s>>>0)|0|0)==0)}else r=9;while(0);p=((C-E>>2)*9|0)+-9|0;if((u|32|0)==102){p=p-r|0;p=(p|0)<0?0:p;n=(n|0)<(p|0)?n:p;p=0;break}else{p=p+o-r|0;p=(p|0)<0?0:p;n=(n|0)<(p|0)?n:p;p=0;break}}else p=I&8;while(0);x=n|p;s=(x|0)!=0&1;t=(u|32|0)==102;if(t){o=(o|0)>0?o:0;u=0}else{r=(o|0)<0?y:o;r=co(r,((r|0)<0)<<31>>31,X)|0;if((_-r|0)<2)do{r=r+-1|0;a[r>>0]=48}while((_-r|0)<2);a[r+-1>>0]=(o>>31&2)+43;E=r+-2|0;a[E>>0]=u;o=_-E|0;u=E}y=G+1+n+s+o|0;eo(e,32,K,y,I);if(!(c[e>>2]&32))$m(H,G,e)|0;eo(e,48,K,y,I^65536);do if(t){r=w>>>0>F>>>0?F:w;o=r;do{p=co(c[o>>2]|0,0,R)|0;do if((o|0)==(r|0)){if((p|0)!=(R|0))break;a[T>>0]=48;p=T}else{if(p>>>0<=da>>>0)break;do{p=p+-1|0;a[p>>0]=48}while(p>>>0>da>>>0)}while(0);if(!(c[e>>2]&32))$m(p,S-p|0,e)|0;o=o+4|0}while(o>>>0<=F>>>0);do if(x){if(c[e>>2]&32)break;$m(37866,1,e)|0}while(0);if((n|0)>0&o>>>0<C>>>0){p=o;while(1){o=co(c[p>>2]|0,0,R)|0;if(o>>>0>da>>>0)do{o=o+-1|0;a[o>>0]=48}while(o>>>0>da>>>0);if(!(c[e>>2]&32))$m(o,(n|0)>9?9:n,e)|0;p=p+4|0;o=n+-9|0;if(!((n|0)>9&p>>>0<C>>>0)){n=o;break}else n=o}}eo(e,48,n+9|0,9,0)}else{t=z?C:w+4|0;if((n|0)>-1){s=(p|0)==0;r=w;do{o=co(c[r>>2]|0,0,R)|0;if((o|0)==(R|0)){a[T>>0]=48;o=T}do if((r|0)==(w|0)){p=o+1|0;if(!(c[e>>2]&32))$m(o,1,e)|0;if(s&(n|0)<1){o=p;break}if(c[e>>2]&32){o=p;break}$m(37866,1,e)|0;o=p}else{if(o>>>0<=da>>>0)break;do{o=o+-1|0;a[o>>0]=48}while(o>>>0>da>>>0)}while(0);p=S-o|0;if(!(c[e>>2]&32))$m(o,(n|0)>(p|0)?p:n,e)|0;n=n-p|0;r=r+4|0}while(r>>>0<t>>>0&(n|0)>-1)}eo(e,48,n+18|0,18,0);if(c[e>>2]&32)break;$m(u,_-u|0,e)|0}while(0);eo(e,32,K,y,I^8192);n=(y|0)<(K|0)?K:y}else{t=(u&32|0)!=0;s=q!=q|0.0!=0.0;o=s?0:G;r=o+3|0;eo(e,32,K,r,p);n=c[e>>2]|0;if(!(n&32)){$m(H,o,e)|0;n=c[e>>2]|0}if(!(n&32))$m(s?(t?37858:37862):t?37850:37854,3,e)|0;eo(e,32,K,r,I^8192);n=(r|0)<(K|0)?K:r}while(0);w=J;continue a}default:{p=I;o=r;t=0;u=37814;n=N}}while(0);g:do if((L|0)==64){p=ba;o=c[p>>2]|0;p=c[p+4>>2]|0;s=u&32;if(!((o|0)==0&(p|0)==0)){n=N;do{n=n+-1|0;a[n>>0]=d[37798+(o&15)>>0]|s;o=vo(o|0,p|0,4)|0;p=D}while(!((o|0)==0&(p|0)==0));L=ba;if((t&8|0)==0|(c[L>>2]|0)==0&(c[L+4>>2]|0)==0){o=t;t=0;s=37814;L=77}else{o=t;t=2;s=37814+(u>>4)|0;L=77}}else{n=N;o=t;t=0;s=37814;L=77}}else if((L|0)==76){n=co(n,o,N)|0;o=I;t=p;L=77}else if((L|0)==82){L=0;I=Cn(n,0,r)|0;H=(I|0)==0;w=n;o=H?r:I-n|0;t=0;u=37814;n=H?n+r|0:I}else if((L|0)==86){L=0;o=0;n=0;s=c[ba>>2]|0;while(1){p=c[s>>2]|0;if(!p)break;n=Km(fa,p)|0;if((n|0)<0|n>>>0>(r-o|0)>>>0)break;o=n+o|0;if(r>>>0>o>>>0)s=s+4|0;else break}if((n|0)<0){m=-1;break a}eo(e,32,K,o,I);if(!o){n=0;L=98}else{p=0;r=c[ba>>2]|0;while(1){n=c[r>>2]|0;if(!n){n=o;L=98;break g}n=Km(fa,n)|0;p=n+p|0;if((p|0)>(o|0)){n=o;L=98;break g}if(!(c[e>>2]&32))$m(fa,n,e)|0;if(p>>>0>=o>>>0){n=o;L=98;break}else r=r+4|0}}}while(0);if((L|0)==98){L=0;eo(e,32,K,n,I^8192);w=J;n=(K|0)>(n|0)?K:n;continue}if((L|0)==77){L=0;p=(r|0)>-1?o&-65537:o;o=ba;o=(c[o>>2]|0)!=0|(c[o+4>>2]|0)!=0;if((r|0)!=0|o){o=(o&1^1)+(U-n)|0;w=n;o=(r|0)>(o|0)?r:o;u=s;n=N}else{w=N;o=0;u=s;n=N}}s=n-w|0;o=(o|0)<(s|0)?s:o;r=t+o|0;n=(K|0)<(r|0)?r:K;eo(e,32,n,r,p);if(!(c[e>>2]&32))$m(u,t,e)|0;eo(e,48,n,r,p^65536);eo(e,48,o,s,0);if(!(c[e>>2]&32))$m(w,s,e)|0;eo(e,32,n,r,p^8192);w=J}h:do if((L|0)==245)if(!e)if(f){m=1;while(1){f=c[l+(m<<2)>>2]|0;if(!f)break;bo(j+(m<<3)|0,f,g);m=m+1|0;if((m|0)>=10){m=1;break h}}if((m|0)<10)while(1){if(c[l+(m<<2)>>2]|0){m=-1;break h}m=m+1|0;if((m|0)>=10){m=1;break}}else m=1}else m=0;while(0);i=ha;return m|0}function Yn(a){a=a|0;if(!(c[a+68>>2]|0))on(a);return}function Zn(a){a=a|0;if(!(c[a+68>>2]|0))on(a);return}function _n(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,g=0,h=0,j=0;j=i;i=i+112|0;h=j;f=h;g=f+112|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));f=h+4|0;c[f>>2]=a;g=h+8|0;c[g>>2]=-1;c[h+44>>2]=a;c[h+76>>2]=-1;wm(h,0);e=+um(h,d,1);d=(c[f>>2]|0)-(c[g>>2]|0)+(c[h+108>>2]|0)|0;if(b)c[b>>2]=(d|0)!=0?a+d|0:a;i=j;return +e}function $n(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;k=i;i=i+112|0;j=k;c[j>>2]=0;g=j+4|0;c[g>>2]=a;c[j+44>>2]=a;h=j+8|0;c[h>>2]=(a|0)<0?-1:a+2147483647|0;c[j+76>>2]=-1;wm(j,0);e=vm(j,d,1,e,f)|0;if(b)c[b>>2]=a+((c[g>>2]|0)+(c[j+108>>2]|0)-(c[h>>2]|0));i=k;return e|0}function ao(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=a+20|0;f=c[e>>2]|0;a=(c[a+16>>2]|0)-f|0;a=a>>>0>d>>>0?d:a;so(f|0,b|0,a|0)|0;c[e>>2]=(c[e>>2]|0)+a;return d|0}function bo(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0.0;a:do if(b>>>0<=20)do switch(b|0){case 9:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;break a}case 10:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;e=a;c[e>>2]=b;c[e+4>>2]=((b|0)<0)<<31>>31;break a}case 11:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;e=a;c[e>>2]=b;c[e+4>>2]=0;break a}case 12:{e=(c[d>>2]|0)+(8-1)&~(8-1);b=e;f=c[b>>2]|0;b=c[b+4>>2]|0;c[d>>2]=e+8;e=a;c[e>>2]=f;c[e+4>>2]=b;break a}case 13:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;e=(e&65535)<<16>>16;f=a;c[f>>2]=e;c[f+4>>2]=((e|0)<0)<<31>>31;break a}case 14:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;f=a;c[f>>2]=e&65535;c[f+4>>2]=0;break a}case 15:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;e=(e&255)<<24>>24;f=a;c[f>>2]=e;c[f+4>>2]=((e|0)<0)<<31>>31;break a}case 16:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;f=a;c[f>>2]=e&255;c[f+4>>2]=0;break a}case 17:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}case 18:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}default:break a}while(0);while(0);return}function co(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if(c>>>0>0|(c|0)==0&b>>>0>4294967295)while(1){e=Eo(b|0,c|0,10,0)|0;d=d+-1|0;a[d>>0]=e|48;e=Do(b|0,c|0,10,0)|0;if(c>>>0>9|(c|0)==9&b>>>0>4294967295){b=e;c=D}else{b=e;break}}if(b)while(1){d=d+-1|0;a[d>>0]=(b>>>0)%10|0|48;if(b>>>0<10)break;else b=(b>>>0)/10|0}return d|0}function eo(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;j=i;i=i+256|0;h=j;do if((d|0)>(e|0)&(f&73728|0)==0){f=d-e|0;uo(h|0,b|0,(f>>>0>256?256:f)|0)|0;b=c[a>>2]|0;g=(b&32|0)==0;if(f>>>0>255){e=d-e|0;do{if(g){$m(h,256,a)|0;b=c[a>>2]|0}f=f+-256|0;g=(b&32|0)==0}while(f>>>0>255);if(g)f=e&255;else break}else if(!g)break;$m(h,f,a)|0}while(0);i=j;return}function fo(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;do if(a>>>0<245){o=a>>>0<11?16:a+11&-8;a=o>>>3;i=c[6040]|0;d=i>>>a;if(d&3){a=(d&1^1)+a|0;e=a<<1;d=24200+(e<<2)|0;e=24200+(e+2<<2)|0;f=c[e>>2]|0;g=f+8|0;h=c[g>>2]|0;do if((d|0)!=(h|0)){if(h>>>0<(c[6044]|0)>>>0)sc();b=h+12|0;if((c[b>>2]|0)==(f|0)){c[b>>2]=d;c[e>>2]=h;break}else sc()}else c[6040]=i&~(1<<a);while(0);M=a<<3;c[f+4>>2]=M|3;M=f+(M|4)|0;c[M>>2]=c[M>>2]|1;M=g;return M|0}h=c[6042]|0;if(o>>>0>h>>>0){if(d){e=2<<a;e=d<<a&(e|0-e);e=(e&0-e)+-1|0;j=e>>>12&16;e=e>>>j;f=e>>>5&8;e=e>>>f;g=e>>>2&4;e=e>>>g;d=e>>>1&2;e=e>>>d;a=e>>>1&1;a=(f|j|g|d|a)+(e>>>a)|0;e=a<<1;d=24200+(e<<2)|0;e=24200+(e+2<<2)|0;g=c[e>>2]|0;j=g+8|0;f=c[j>>2]|0;do if((d|0)!=(f|0)){if(f>>>0<(c[6044]|0)>>>0)sc();b=f+12|0;if((c[b>>2]|0)==(g|0)){c[b>>2]=d;c[e>>2]=f;k=c[6042]|0;break}else sc()}else{c[6040]=i&~(1<<a);k=h}while(0);M=a<<3;h=M-o|0;c[g+4>>2]=o|3;i=g+o|0;c[g+(o|4)>>2]=h|1;c[g+M>>2]=h;if(k){f=c[6045]|0;d=k>>>3;b=d<<1;e=24200+(b<<2)|0;a=c[6040]|0;d=1<<d;if(a&d){a=24200+(b+2<<2)|0;b=c[a>>2]|0;if(b>>>0<(c[6044]|0)>>>0)sc();else{l=a;m=b}}else{c[6040]=a|d;l=24200+(b+2<<2)|0;m=e}c[l>>2]=f;c[m+12>>2]=f;c[f+8>>2]=m;c[f+12>>2]=e}c[6042]=h;c[6045]=i;M=j;return M|0}a=c[6041]|0;if(a){d=(a&0-a)+-1|0;L=d>>>12&16;d=d>>>L;K=d>>>5&8;d=d>>>K;M=d>>>2&4;d=d>>>M;a=d>>>1&2;d=d>>>a;e=d>>>1&1;e=c[24464+((K|L|M|a|e)+(d>>>e)<<2)>>2]|0;d=(c[e+4>>2]&-8)-o|0;a=e;while(1){b=c[a+16>>2]|0;if(!b){b=c[a+20>>2]|0;if(!b){j=d;break}}a=(c[b+4>>2]&-8)-o|0;M=a>>>0<d>>>0;d=M?a:d;a=b;e=M?b:e}g=c[6044]|0;if(e>>>0<g>>>0)sc();i=e+o|0;if(e>>>0>=i>>>0)sc();h=c[e+24>>2]|0;d=c[e+12>>2]|0;do if((d|0)==(e|0)){a=e+20|0;b=c[a>>2]|0;if(!b){a=e+16|0;b=c[a>>2]|0;if(!b){n=0;break}}while(1){d=b+20|0;f=c[d>>2]|0;if(f){b=f;a=d;continue}d=b+16|0;f=c[d>>2]|0;if(!f)break;else{b=f;a=d}}if(a>>>0<g>>>0)sc();else{c[a>>2]=0;n=b;break}}else{f=c[e+8>>2]|0;if(f>>>0<g>>>0)sc();b=f+12|0;if((c[b>>2]|0)!=(e|0))sc();a=d+8|0;if((c[a>>2]|0)==(e|0)){c[b>>2]=d;c[a>>2]=f;n=d;break}else sc()}while(0);do if(h){b=c[e+28>>2]|0;a=24464+(b<<2)|0;if((e|0)==(c[a>>2]|0)){c[a>>2]=n;if(!n){c[6041]=c[6041]&~(1<<b);break}}else{if(h>>>0<(c[6044]|0)>>>0)sc();b=h+16|0;if((c[b>>2]|0)==(e|0))c[b>>2]=n;else c[h+20>>2]=n;if(!n)break}a=c[6044]|0;if(n>>>0<a>>>0)sc();c[n+24>>2]=h;b=c[e+16>>2]|0;do if(b)if(b>>>0<a>>>0)sc();else{c[n+16>>2]=b;c[b+24>>2]=n;break}while(0);b=c[e+20>>2]|0;if(b)if(b>>>0<(c[6044]|0)>>>0)sc();else{c[n+20>>2]=b;c[b+24>>2]=n;break}}while(0);if(j>>>0<16){M=j+o|0;c[e+4>>2]=M|3;M=e+(M+4)|0;c[M>>2]=c[M>>2]|1}else{c[e+4>>2]=o|3;c[e+(o|4)>>2]=j|1;c[e+(j+o)>>2]=j;b=c[6042]|0;if(b){g=c[6045]|0;d=b>>>3;b=d<<1;f=24200+(b<<2)|0;a=c[6040]|0;d=1<<d;if(a&d){b=24200+(b+2<<2)|0;a=c[b>>2]|0;if(a>>>0<(c[6044]|0)>>>0)sc();else{p=b;q=a}}else{c[6040]=a|d;p=24200+(b+2<<2)|0;q=f}c[p>>2]=g;c[q+12>>2]=g;c[g+8>>2]=q;c[g+12>>2]=f}c[6042]=j;c[6045]=i}M=e+8|0;return M|0}else q=o}else q=o}else if(a>>>0<=4294967231){a=a+11|0;m=a&-8;l=c[6041]|0;if(l){d=0-m|0;a=a>>>8;if(a)if(m>>>0>16777215)k=31;else{q=(a+1048320|0)>>>16&8;v=a<<q;p=(v+520192|0)>>>16&4;v=v<<p;k=(v+245760|0)>>>16&2;k=14-(p|q|k)+(v<<k>>>15)|0;k=m>>>(k+7|0)&1|k<<1}else k=0;a=c[24464+(k<<2)>>2]|0;a:do if(!a){f=0;a=0;v=86}else{h=d;f=0;i=m<<((k|0)==31?0:25-(k>>>1)|0);j=a;a=0;while(1){g=c[j+4>>2]&-8;d=g-m|0;if(d>>>0<h>>>0)if((g|0)==(m|0)){g=j;a=j;v=90;break a}else a=j;else d=h;v=c[j+20>>2]|0;j=c[j+16+(i>>>31<<2)>>2]|0;f=(v|0)==0|(v|0)==(j|0)?f:v;if(!j){v=86;break}else{h=d;i=i<<1}}}while(0);if((v|0)==86){if((f|0)==0&(a|0)==0){a=2<<k;a=l&(a|0-a);if(!a){q=m;break}a=(a&0-a)+-1|0;n=a>>>12&16;a=a>>>n;l=a>>>5&8;a=a>>>l;p=a>>>2&4;a=a>>>p;q=a>>>1&2;a=a>>>q;f=a>>>1&1;f=c[24464+((l|n|p|q|f)+(a>>>f)<<2)>>2]|0;a=0}if(!f){i=d;j=a}else{g=f;v=90}}if((v|0)==90)while(1){v=0;q=(c[g+4>>2]&-8)-m|0;f=q>>>0<d>>>0;d=f?q:d;a=f?g:a;f=c[g+16>>2]|0;if(f){g=f;v=90;continue}g=c[g+20>>2]|0;if(!g){i=d;j=a;break}else v=90}if((j|0)!=0?i>>>0<((c[6042]|0)-m|0)>>>0:0){f=c[6044]|0;if(j>>>0<f>>>0)sc();h=j+m|0;if(j>>>0>=h>>>0)sc();g=c[j+24>>2]|0;d=c[j+12>>2]|0;do if((d|0)==(j|0)){a=j+20|0;b=c[a>>2]|0;if(!b){a=j+16|0;b=c[a>>2]|0;if(!b){o=0;break}}while(1){d=b+20|0;e=c[d>>2]|0;if(e){b=e;a=d;continue}d=b+16|0;e=c[d>>2]|0;if(!e)break;else{b=e;a=d}}if(a>>>0<f>>>0)sc();else{c[a>>2]=0;o=b;break}}else{e=c[j+8>>2]|0;if(e>>>0<f>>>0)sc();b=e+12|0;if((c[b>>2]|0)!=(j|0))sc();a=d+8|0;if((c[a>>2]|0)==(j|0)){c[b>>2]=d;c[a>>2]=e;o=d;break}else sc()}while(0);do if(g){b=c[j+28>>2]|0;a=24464+(b<<2)|0;if((j|0)==(c[a>>2]|0)){c[a>>2]=o;if(!o){c[6041]=c[6041]&~(1<<b);break}}else{if(g>>>0<(c[6044]|0)>>>0)sc();b=g+16|0;if((c[b>>2]|0)==(j|0))c[b>>2]=o;else c[g+20>>2]=o;if(!o)break}a=c[6044]|0;if(o>>>0<a>>>0)sc();c[o+24>>2]=g;b=c[j+16>>2]|0;do if(b)if(b>>>0<a>>>0)sc();else{c[o+16>>2]=b;c[b+24>>2]=o;break}while(0);b=c[j+20>>2]|0;if(b)if(b>>>0<(c[6044]|0)>>>0)sc();else{c[o+20>>2]=b;c[b+24>>2]=o;break}}while(0);b:do if(i>>>0>=16){c[j+4>>2]=m|3;c[j+(m|4)>>2]=i|1;c[j+(i+m)>>2]=i;b=i>>>3;if(i>>>0<256){a=b<<1;e=24200+(a<<2)|0;d=c[6040]|0;b=1<<b;if(d&b){b=24200+(a+2<<2)|0;a=c[b>>2]|0;if(a>>>0<(c[6044]|0)>>>0)sc();else{s=b;t=a}}else{c[6040]=d|b;s=24200+(a+2<<2)|0;t=e}c[s>>2]=h;c[t+12>>2]=h;c[j+(m+8)>>2]=t;c[j+(m+12)>>2]=e;break}b=i>>>8;if(b)if(i>>>0>16777215)e=31;else{L=(b+1048320|0)>>>16&8;M=b<<L;K=(M+520192|0)>>>16&4;M=M<<K;e=(M+245760|0)>>>16&2;e=14-(K|L|e)+(M<<e>>>15)|0;e=i>>>(e+7|0)&1|e<<1}else e=0;b=24464+(e<<2)|0;c[j+(m+28)>>2]=e;c[j+(m+20)>>2]=0;c[j+(m+16)>>2]=0;a=c[6041]|0;d=1<<e;if(!(a&d)){c[6041]=a|d;c[b>>2]=h;c[j+(m+24)>>2]=b;c[j+(m+12)>>2]=h;c[j+(m+8)>>2]=h;break}b=c[b>>2]|0;c:do if((c[b+4>>2]&-8|0)!=(i|0)){e=i<<((e|0)==31?0:25-(e>>>1)|0);while(1){a=b+16+(e>>>31<<2)|0;d=c[a>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(i|0)){y=d;break c}else{e=e<<1;b=d}}if(a>>>0<(c[6044]|0)>>>0)sc();else{c[a>>2]=h;c[j+(m+24)>>2]=b;c[j+(m+12)>>2]=h;c[j+(m+8)>>2]=h;break b}}else y=b;while(0);b=y+8|0;a=c[b>>2]|0;M=c[6044]|0;if(a>>>0>=M>>>0&y>>>0>=M>>>0){c[a+12>>2]=h;c[b>>2]=h;c[j+(m+8)>>2]=a;c[j+(m+12)>>2]=y;c[j+(m+24)>>2]=0;break}else sc()}else{M=i+m|0;c[j+4>>2]=M|3;M=j+(M+4)|0;c[M>>2]=c[M>>2]|1}while(0);M=j+8|0;return M|0}else q=m}else q=m}else q=-1;while(0);d=c[6042]|0;if(d>>>0>=q>>>0){b=d-q|0;a=c[6045]|0;if(b>>>0>15){c[6045]=a+q;c[6042]=b;c[a+(q+4)>>2]=b|1;c[a+d>>2]=b;c[a+4>>2]=q|3}else{c[6042]=0;c[6045]=0;c[a+4>>2]=d|3;M=a+(d+4)|0;c[M>>2]=c[M>>2]|1}M=a+8|0;return M|0}a=c[6043]|0;if(a>>>0>q>>>0){L=a-q|0;c[6043]=L;M=c[6046]|0;c[6046]=M+q;c[M+(q+4)>>2]=L|1;c[M+4>>2]=q|3;M=M+8|0;return M|0}do if(!(c[6158]|0)){a=Na(30)|0;if(!(a+-1&a)){c[6160]=a;c[6159]=a;c[6161]=-1;c[6162]=-1;c[6163]=0;c[6151]=0;c[6158]=(Eb(0)|0)&-16^1431655768;break}else sc()}while(0);j=q+48|0;i=c[6160]|0;k=q+47|0;h=i+k|0;i=0-i|0;l=h&i;if(l>>>0<=q>>>0){M=0;return M|0}a=c[6150]|0;if((a|0)!=0?(t=c[6148]|0,y=t+l|0,y>>>0<=t>>>0|y>>>0>a>>>0):0){M=0;return M|0}d:do if(!(c[6151]&4)){a=c[6046]|0;e:do if(a){f=24608;while(1){d=c[f>>2]|0;if(d>>>0<=a>>>0?(r=f+4|0,(d+(c[r>>2]|0)|0)>>>0>a>>>0):0){g=f;a=r;break}f=c[f+8>>2]|0;if(!f){v=174;break e}}d=h-(c[6043]|0)&i;if(d>>>0<2147483647){f=Ia(d|0)|0;y=(f|0)==((c[g>>2]|0)+(c[a>>2]|0)|0);a=y?d:0;if(y){if((f|0)!=(-1|0)){w=f;p=a;v=194;break d}}else v=184}else a=0}else v=174;while(0);do if((v|0)==174){g=Ia(0)|0;if((g|0)!=(-1|0)){a=g;d=c[6159]|0;f=d+-1|0;if(!(f&a))d=l;else d=l-a+(f+a&0-d)|0;a=c[6148]|0;f=a+d|0;if(d>>>0>q>>>0&d>>>0<2147483647){y=c[6150]|0;if((y|0)!=0?f>>>0<=a>>>0|f>>>0>y>>>0:0){a=0;break}f=Ia(d|0)|0;y=(f|0)==(g|0);a=y?d:0;if(y){w=g;p=a;v=194;break d}else v=184}else a=0}else a=0}while(0);f:do if((v|0)==184){g=0-d|0;do if(j>>>0>d>>>0&(d>>>0<2147483647&(f|0)!=(-1|0))?(u=c[6160]|0,u=k-d+u&0-u,u>>>0<2147483647):0)if((Ia(u|0)|0)==(-1|0)){Ia(g|0)|0;break f}else{d=u+d|0;break}while(0);if((f|0)!=(-1|0)){w=f;p=d;v=194;break d}}while(0);c[6151]=c[6151]|4;v=191}else{a=0;v=191}while(0);if((((v|0)==191?l>>>0<2147483647:0)?(w=Ia(l|0)|0,x=Ia(0)|0,w>>>0<x>>>0&((w|0)!=(-1|0)&(x|0)!=(-1|0))):0)?(z=x-w|0,A=z>>>0>(q+40|0)>>>0,A):0){p=A?z:a;v=194}if((v|0)==194){a=(c[6148]|0)+p|0;c[6148]=a;if(a>>>0>(c[6149]|0)>>>0)c[6149]=a;h=c[6046]|0;g:do if(h){g=24608;do{a=c[g>>2]|0;d=g+4|0;f=c[d>>2]|0;if((w|0)==(a+f|0)){B=a;C=d;D=f;E=g;v=204;break}g=c[g+8>>2]|0}while((g|0)!=0);if(((v|0)==204?(c[E+12>>2]&8|0)==0:0)?h>>>0<w>>>0&h>>>0>=B>>>0:0){c[C>>2]=D+p;M=(c[6043]|0)+p|0;L=h+8|0;L=(L&7|0)==0?0:0-L&7;K=M-L|0;c[6046]=h+L;c[6043]=K;c[h+(L+4)>>2]=K|1;c[h+(M+4)>>2]=40;c[6047]=c[6162];break}a=c[6044]|0;if(w>>>0<a>>>0){c[6044]=w;a=w}d=w+p|0;g=24608;while(1){if((c[g>>2]|0)==(d|0)){f=g;d=g;v=212;break}g=c[g+8>>2]|0;if(!g){d=24608;break}}if((v|0)==212)if(!(c[d+12>>2]&8)){c[f>>2]=w;n=d+4|0;c[n>>2]=(c[n>>2]|0)+p;n=w+8|0;n=(n&7|0)==0?0:0-n&7;k=w+(p+8)|0;k=(k&7|0)==0?0:0-k&7;b=w+(k+p)|0;m=n+q|0;o=w+m|0;l=b-(w+n)-q|0;c[w+(n+4)>>2]=q|3;h:do if((b|0)!=(h|0)){if((b|0)==(c[6045]|0)){M=(c[6042]|0)+l|0;c[6042]=M;c[6045]=o;c[w+(m+4)>>2]=M|1;c[w+(M+m)>>2]=M;break}i=p+4|0;d=c[w+(i+k)>>2]|0;if((d&3|0)==1){j=d&-8;g=d>>>3;i:do if(d>>>0>=256){h=c[w+((k|24)+p)>>2]|0;e=c[w+(p+12+k)>>2]|0;do if((e|0)==(b|0)){f=k|16;e=w+(i+f)|0;d=c[e>>2]|0;if(!d){e=w+(f+p)|0;d=c[e>>2]|0;if(!d){J=0;break}}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<a>>>0)sc();else{c[e>>2]=0;J=d;break}}else{f=c[w+((k|8)+p)>>2]|0;if(f>>>0<a>>>0)sc();a=f+12|0;if((c[a>>2]|0)!=(b|0))sc();d=e+8|0;if((c[d>>2]|0)==(b|0)){c[a>>2]=e;c[d>>2]=f;J=e;break}else sc()}while(0);if(!h)break;a=c[w+(p+28+k)>>2]|0;d=24464+(a<<2)|0;do if((b|0)!=(c[d>>2]|0)){if(h>>>0<(c[6044]|0)>>>0)sc();a=h+16|0;if((c[a>>2]|0)==(b|0))c[a>>2]=J;else c[h+20>>2]=J;if(!J)break i}else{c[d>>2]=J;if(J)break;c[6041]=c[6041]&~(1<<a);break i}while(0);d=c[6044]|0;if(J>>>0<d>>>0)sc();c[J+24>>2]=h;b=k|16;a=c[w+(b+p)>>2]|0;do if(a)if(a>>>0<d>>>0)sc();else{c[J+16>>2]=a;c[a+24>>2]=J;break}while(0);b=c[w+(i+b)>>2]|0;if(!b)break;if(b>>>0<(c[6044]|0)>>>0)sc();else{c[J+20>>2]=b;c[b+24>>2]=J;break}}else{e=c[w+((k|8)+p)>>2]|0;f=c[w+(p+12+k)>>2]|0;d=24200+(g<<1<<2)|0;do if((e|0)!=(d|0)){if(e>>>0<a>>>0)sc();if((c[e+12>>2]|0)==(b|0))break;sc()}while(0);if((f|0)==(e|0)){c[6040]=c[6040]&~(1<<g);break}do if((f|0)==(d|0))F=f+8|0;else{if(f>>>0<a>>>0)sc();a=f+8|0;if((c[a>>2]|0)==(b|0)){F=a;break}sc()}while(0);c[e+12>>2]=f;c[F>>2]=e}while(0);b=w+((j|k)+p)|0;f=j+l|0}else f=l;b=b+4|0;c[b>>2]=c[b>>2]&-2;c[w+(m+4)>>2]=f|1;c[w+(f+m)>>2]=f;b=f>>>3;if(f>>>0<256){a=b<<1;e=24200+(a<<2)|0;d=c[6040]|0;b=1<<b;do if(!(d&b)){c[6040]=d|b;K=24200+(a+2<<2)|0;L=e}else{b=24200+(a+2<<2)|0;a=c[b>>2]|0;if(a>>>0>=(c[6044]|0)>>>0){K=b;L=a;break}sc()}while(0);c[K>>2]=o;c[L+12>>2]=o;c[w+(m+8)>>2]=L;c[w+(m+12)>>2]=e;break}b=f>>>8;do if(!b)e=0;else{if(f>>>0>16777215){e=31;break}K=(b+1048320|0)>>>16&8;L=b<<K;J=(L+520192|0)>>>16&4;L=L<<J;e=(L+245760|0)>>>16&2;e=14-(J|K|e)+(L<<e>>>15)|0;e=f>>>(e+7|0)&1|e<<1}while(0);b=24464+(e<<2)|0;c[w+(m+28)>>2]=e;c[w+(m+20)>>2]=0;c[w+(m+16)>>2]=0;a=c[6041]|0;d=1<<e;if(!(a&d)){c[6041]=a|d;c[b>>2]=o;c[w+(m+24)>>2]=b;c[w+(m+12)>>2]=o;c[w+(m+8)>>2]=o;break}b=c[b>>2]|0;j:do if((c[b+4>>2]&-8|0)!=(f|0)){e=f<<((e|0)==31?0:25-(e>>>1)|0);while(1){a=b+16+(e>>>31<<2)|0;d=c[a>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(f|0)){M=d;break j}else{e=e<<1;b=d}}if(a>>>0<(c[6044]|0)>>>0)sc();else{c[a>>2]=o;c[w+(m+24)>>2]=b;c[w+(m+12)>>2]=o;c[w+(m+8)>>2]=o;break h}}else M=b;while(0);b=M+8|0;a=c[b>>2]|0;L=c[6044]|0;if(a>>>0>=L>>>0&M>>>0>=L>>>0){c[a+12>>2]=o;c[b>>2]=o;c[w+(m+8)>>2]=a;c[w+(m+12)>>2]=M;c[w+(m+24)>>2]=0;break}else sc()}else{M=(c[6043]|0)+l|0;c[6043]=M;c[6046]=o;c[w+(m+4)>>2]=M|1}while(0);M=w+(n|8)|0;return M|0}else d=24608;while(1){a=c[d>>2]|0;if(a>>>0<=h>>>0?(b=c[d+4>>2]|0,e=a+b|0,e>>>0>h>>>0):0)break;d=c[d+8>>2]|0}f=a+(b+-39)|0;a=a+(b+-47+((f&7|0)==0?0:0-f&7))|0;f=h+16|0;a=a>>>0<f>>>0?h:a;b=a+8|0;d=w+8|0;d=(d&7|0)==0?0:0-d&7;M=p+-40-d|0;c[6046]=w+d;c[6043]=M;c[w+(d+4)>>2]=M|1;c[w+(p+-36)>>2]=40;c[6047]=c[6162];d=a+4|0;c[d>>2]=27;c[b>>2]=c[6152];c[b+4>>2]=c[6153];c[b+8>>2]=c[6154];c[b+12>>2]=c[6155];c[6152]=w;c[6153]=p;c[6155]=0;c[6154]=b;b=a+28|0;c[b>>2]=7;if((a+32|0)>>>0<e>>>0)do{M=b;b=b+4|0;c[b>>2]=7}while((M+8|0)>>>0<e>>>0);if((a|0)!=(h|0)){g=a-h|0;c[d>>2]=c[d>>2]&-2;c[h+4>>2]=g|1;c[a>>2]=g;b=g>>>3;if(g>>>0<256){a=b<<1;e=24200+(a<<2)|0;d=c[6040]|0;b=1<<b;if(d&b){b=24200+(a+2<<2)|0;a=c[b>>2]|0;if(a>>>0<(c[6044]|0)>>>0)sc();else{G=b;H=a}}else{c[6040]=d|b;G=24200+(a+2<<2)|0;H=e}c[G>>2]=h;c[H+12>>2]=h;c[h+8>>2]=H;c[h+12>>2]=e;break}b=g>>>8;if(b)if(g>>>0>16777215)e=31;else{L=(b+1048320|0)>>>16&8;M=b<<L;K=(M+520192|0)>>>16&4;M=M<<K;e=(M+245760|0)>>>16&2;e=14-(K|L|e)+(M<<e>>>15)|0;e=g>>>(e+7|0)&1|e<<1}else e=0;d=24464+(e<<2)|0;c[h+28>>2]=e;c[h+20>>2]=0;c[f>>2]=0;b=c[6041]|0;a=1<<e;if(!(b&a)){c[6041]=b|a;c[d>>2]=h;c[h+24>>2]=d;c[h+12>>2]=h;c[h+8>>2]=h;break}b=c[d>>2]|0;k:do if((c[b+4>>2]&-8|0)!=(g|0)){e=g<<((e|0)==31?0:25-(e>>>1)|0);while(1){a=b+16+(e>>>31<<2)|0;d=c[a>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(g|0)){I=d;break k}else{e=e<<1;b=d}}if(a>>>0<(c[6044]|0)>>>0)sc();else{c[a>>2]=h;c[h+24>>2]=b;c[h+12>>2]=h;c[h+8>>2]=h;break g}}else I=b;while(0);b=I+8|0;a=c[b>>2]|0;M=c[6044]|0;if(a>>>0>=M>>>0&I>>>0>=M>>>0){c[a+12>>2]=h;c[b>>2]=h;c[h+8>>2]=a;c[h+12>>2]=I;c[h+24>>2]=0;break}else sc()}}else{M=c[6044]|0;if((M|0)==0|w>>>0<M>>>0)c[6044]=w;c[6152]=w;c[6153]=p;c[6155]=0;c[6049]=c[6158];c[6048]=-1;b=0;do{M=b<<1;L=24200+(M<<2)|0;c[24200+(M+3<<2)>>2]=L;c[24200+(M+2<<2)>>2]=L;b=b+1|0}while((b|0)!=32);M=w+8|0;M=(M&7|0)==0?0:0-M&7;L=p+-40-M|0;c[6046]=w+M;c[6043]=L;c[w+(M+4)>>2]=L|1;c[w+(p+-36)>>2]=40;c[6047]=c[6162]}while(0);b=c[6043]|0;if(b>>>0>q>>>0){L=b-q|0;c[6043]=L;M=c[6046]|0;c[6046]=M+q;c[M+(q+4)>>2]=L|1;c[M+4>>2]=q|3;M=M+8|0;return M|0}}c[(sm()|0)>>2]=12;M=0;return M|0}function go(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;if(!a)return;b=a+-8|0;i=c[6044]|0;if(b>>>0<i>>>0)sc();d=c[a+-4>>2]|0;e=d&3;if((e|0)==1)sc();o=d&-8;q=a+(o+-8)|0;do if(!(d&1)){b=c[b>>2]|0;if(!e)return;j=-8-b|0;l=a+j|0;m=b+o|0;if(l>>>0<i>>>0)sc();if((l|0)==(c[6045]|0)){b=a+(o+-4)|0;d=c[b>>2]|0;if((d&3|0)!=3){u=l;g=m;break}c[6042]=m;c[b>>2]=d&-2;c[a+(j+4)>>2]=m|1;c[q>>2]=m;return}f=b>>>3;if(b>>>0<256){e=c[a+(j+8)>>2]|0;d=c[a+(j+12)>>2]|0;b=24200+(f<<1<<2)|0;if((e|0)!=(b|0)){if(e>>>0<i>>>0)sc();if((c[e+12>>2]|0)!=(l|0))sc()}if((d|0)==(e|0)){c[6040]=c[6040]&~(1<<f);u=l;g=m;break}if((d|0)!=(b|0)){if(d>>>0<i>>>0)sc();b=d+8|0;if((c[b>>2]|0)==(l|0))h=b;else sc()}else h=d+8|0;c[e+12>>2]=d;c[h>>2]=e;u=l;g=m;break}h=c[a+(j+24)>>2]|0;e=c[a+(j+12)>>2]|0;do if((e|0)==(l|0)){d=a+(j+20)|0;b=c[d>>2]|0;if(!b){d=a+(j+16)|0;b=c[d>>2]|0;if(!b){k=0;break}}while(1){e=b+20|0;f=c[e>>2]|0;if(f){b=f;d=e;continue}e=b+16|0;f=c[e>>2]|0;if(!f)break;else{b=f;d=e}}if(d>>>0<i>>>0)sc();else{c[d>>2]=0;k=b;break}}else{f=c[a+(j+8)>>2]|0;if(f>>>0<i>>>0)sc();b=f+12|0;if((c[b>>2]|0)!=(l|0))sc();d=e+8|0;if((c[d>>2]|0)==(l|0)){c[b>>2]=e;c[d>>2]=f;k=e;break}else sc()}while(0);if(h){b=c[a+(j+28)>>2]|0;d=24464+(b<<2)|0;if((l|0)==(c[d>>2]|0)){c[d>>2]=k;if(!k){c[6041]=c[6041]&~(1<<b);u=l;g=m;break}}else{if(h>>>0<(c[6044]|0)>>>0)sc();b=h+16|0;if((c[b>>2]|0)==(l|0))c[b>>2]=k;else c[h+20>>2]=k;if(!k){u=l;g=m;break}}d=c[6044]|0;if(k>>>0<d>>>0)sc();c[k+24>>2]=h;b=c[a+(j+16)>>2]|0;do if(b)if(b>>>0<d>>>0)sc();else{c[k+16>>2]=b;c[b+24>>2]=k;break}while(0);b=c[a+(j+20)>>2]|0;if(b)if(b>>>0<(c[6044]|0)>>>0)sc();else{c[k+20>>2]=b;c[b+24>>2]=k;u=l;g=m;break}else{u=l;g=m}}else{u=l;g=m}}else{u=b;g=o}while(0);if(u>>>0>=q>>>0)sc();b=a+(o+-4)|0;d=c[b>>2]|0;if(!(d&1))sc();if(!(d&2)){if((q|0)==(c[6046]|0)){t=(c[6043]|0)+g|0;c[6043]=t;c[6046]=u;c[u+4>>2]=t|1;if((u|0)!=(c[6045]|0))return;c[6045]=0;c[6042]=0;return}if((q|0)==(c[6045]|0)){t=(c[6042]|0)+g|0;c[6042]=t;c[6045]=u;c[u+4>>2]=t|1;c[u+t>>2]=t;return}g=(d&-8)+g|0;f=d>>>3;do if(d>>>0>=256){h=c[a+(o+16)>>2]|0;b=c[a+(o|4)>>2]|0;do if((b|0)==(q|0)){d=a+(o+12)|0;b=c[d>>2]|0;if(!b){d=a+(o+8)|0;b=c[d>>2]|0;if(!b){p=0;break}}while(1){e=b+20|0;f=c[e>>2]|0;if(f){b=f;d=e;continue}e=b+16|0;f=c[e>>2]|0;if(!f)break;else{b=f;d=e}}if(d>>>0<(c[6044]|0)>>>0)sc();else{c[d>>2]=0;p=b;break}}else{d=c[a+o>>2]|0;if(d>>>0<(c[6044]|0)>>>0)sc();e=d+12|0;if((c[e>>2]|0)!=(q|0))sc();f=b+8|0;if((c[f>>2]|0)==(q|0)){c[e>>2]=b;c[f>>2]=d;p=b;break}else sc()}while(0);if(h){b=c[a+(o+20)>>2]|0;d=24464+(b<<2)|0;if((q|0)==(c[d>>2]|0)){c[d>>2]=p;if(!p){c[6041]=c[6041]&~(1<<b);break}}else{if(h>>>0<(c[6044]|0)>>>0)sc();b=h+16|0;if((c[b>>2]|0)==(q|0))c[b>>2]=p;else c[h+20>>2]=p;if(!p)break}d=c[6044]|0;if(p>>>0<d>>>0)sc();c[p+24>>2]=h;b=c[a+(o+8)>>2]|0;do if(b)if(b>>>0<d>>>0)sc();else{c[p+16>>2]=b;c[b+24>>2]=p;break}while(0);b=c[a+(o+12)>>2]|0;if(b)if(b>>>0<(c[6044]|0)>>>0)sc();else{c[p+20>>2]=b;c[b+24>>2]=p;break}}}else{e=c[a+o>>2]|0;d=c[a+(o|4)>>2]|0;b=24200+(f<<1<<2)|0;if((e|0)!=(b|0)){if(e>>>0<(c[6044]|0)>>>0)sc();if((c[e+12>>2]|0)!=(q|0))sc()}if((d|0)==(e|0)){c[6040]=c[6040]&~(1<<f);break}if((d|0)!=(b|0)){if(d>>>0<(c[6044]|0)>>>0)sc();b=d+8|0;if((c[b>>2]|0)==(q|0))n=b;else sc()}else n=d+8|0;c[e+12>>2]=d;c[n>>2]=e}while(0);c[u+4>>2]=g|1;c[u+g>>2]=g;if((u|0)==(c[6045]|0)){c[6042]=g;return}}else{c[b>>2]=d&-2;c[u+4>>2]=g|1;c[u+g>>2]=g}b=g>>>3;if(g>>>0<256){d=b<<1;f=24200+(d<<2)|0;e=c[6040]|0;b=1<<b;if(e&b){b=24200+(d+2<<2)|0;d=c[b>>2]|0;if(d>>>0<(c[6044]|0)>>>0)sc();else{r=b;s=d}}else{c[6040]=e|b;r=24200+(d+2<<2)|0;s=f}c[r>>2]=u;c[s+12>>2]=u;c[u+8>>2]=s;c[u+12>>2]=f;return}b=g>>>8;if(b)if(g>>>0>16777215)f=31;else{r=(b+1048320|0)>>>16&8;s=b<<r;q=(s+520192|0)>>>16&4;s=s<<q;f=(s+245760|0)>>>16&2;f=14-(q|r|f)+(s<<f>>>15)|0;f=g>>>(f+7|0)&1|f<<1}else f=0;b=24464+(f<<2)|0;c[u+28>>2]=f;c[u+20>>2]=0;c[u+16>>2]=0;d=c[6041]|0;e=1<<f;a:do if(d&e){b=c[b>>2]|0;b:do if((c[b+4>>2]&-8|0)!=(g|0)){f=g<<((f|0)==31?0:25-(f>>>1)|0);while(1){d=b+16+(f>>>31<<2)|0;e=c[d>>2]|0;if(!e)break;if((c[e+4>>2]&-8|0)==(g|0)){t=e;break b}else{f=f<<1;b=e}}if(d>>>0<(c[6044]|0)>>>0)sc();else{c[d>>2]=u;c[u+24>>2]=b;c[u+12>>2]=u;c[u+8>>2]=u;break a}}else t=b;while(0);b=t+8|0;d=c[b>>2]|0;s=c[6044]|0;if(d>>>0>=s>>>0&t>>>0>=s>>>0){c[d+12>>2]=u;c[b>>2]=u;c[u+8>>2]=d;c[u+12>>2]=t;c[u+24>>2]=0;break}else sc()}else{c[6041]=d|e;c[b>>2]=u;c[u+24>>2]=b;c[u+12>>2]=u;c[u+8>>2]=u}while(0);u=(c[6048]|0)+-1|0;c[6048]=u;if(!u)b=24616;else return;while(1){b=c[b>>2]|0;if(!b)break;else b=b+8|0}c[6048]=-1;return}function ho(a,b){a=a|0;b=b|0;var d=0;if(a){d=$(b,a)|0;if((b|a)>>>0>65535)d=((d>>>0)/(a>>>0)|0|0)==(b|0)?d:-1}else d=0;b=fo(d)|0;if(!b)return b|0;if(!(c[b+-4>>2]&3))return b|0;uo(b|0,0,d|0)|0;return b|0}function io(a,b){a=a|0;b=b|0;var d=0,e=0;if(!a){a=fo(b)|0;return a|0}if(b>>>0>4294967231){c[(sm()|0)>>2]=12;a=0;return a|0}d=jo(a+-8|0,b>>>0<11?16:b+11&-8)|0;if(d){a=d+8|0;return a|0}d=fo(b)|0;if(!d){a=0;return a|0}e=c[a+-4>>2]|0;e=(e&-8)-((e&3|0)==0?8:4)|0;so(d|0,a|0,(e>>>0<b>>>0?e:b)|0)|0;go(a);a=d;return a|0}function jo(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=a+4|0;p=c[o>>2]|0;j=p&-8;l=a+j|0;i=c[6044]|0;d=p&3;if(!((d|0)!=1&a>>>0>=i>>>0&a>>>0<l>>>0))sc();e=a+(j|4)|0;f=c[e>>2]|0;if(!(f&1))sc();if(!d){if(b>>>0<256){a=0;return a|0}if(j>>>0>=(b+4|0)>>>0?(j-b|0)>>>0<=c[6160]<<1>>>0:0)return a|0;a=0;return a|0}if(j>>>0>=b>>>0){d=j-b|0;if(d>>>0<=15)return a|0;c[o>>2]=p&1|b|2;c[a+(b+4)>>2]=d|3;c[e>>2]=c[e>>2]|1;ko(a+b|0,d);return a|0}if((l|0)==(c[6046]|0)){d=(c[6043]|0)+j|0;if(d>>>0<=b>>>0){a=0;return a|0}n=d-b|0;c[o>>2]=p&1|b|2;c[a+(b+4)>>2]=n|1;c[6046]=a+b;c[6043]=n;return a|0}if((l|0)==(c[6045]|0)){e=(c[6042]|0)+j|0;if(e>>>0<b>>>0){a=0;return a|0}d=e-b|0;if(d>>>0>15){c[o>>2]=p&1|b|2;c[a+(b+4)>>2]=d|1;c[a+e>>2]=d;e=a+(e+4)|0;c[e>>2]=c[e>>2]&-2;e=a+b|0}else{c[o>>2]=p&1|e|2;e=a+(e+4)|0;c[e>>2]=c[e>>2]|1;e=0;d=0}c[6042]=d;c[6045]=e;return a|0}if(f&2){a=0;return a|0}m=(f&-8)+j|0;if(m>>>0<b>>>0){a=0;return a|0}n=m-b|0;g=f>>>3;do if(f>>>0>=256){h=c[a+(j+24)>>2]|0;g=c[a+(j+12)>>2]|0;do if((g|0)==(l|0)){e=a+(j+20)|0;d=c[e>>2]|0;if(!d){e=a+(j+16)|0;d=c[e>>2]|0;if(!d){k=0;break}}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<i>>>0)sc();else{c[e>>2]=0;k=d;break}}else{f=c[a+(j+8)>>2]|0;if(f>>>0<i>>>0)sc();d=f+12|0;if((c[d>>2]|0)!=(l|0))sc();e=g+8|0;if((c[e>>2]|0)==(l|0)){c[d>>2]=g;c[e>>2]=f;k=g;break}else sc()}while(0);if(h){d=c[a+(j+28)>>2]|0;e=24464+(d<<2)|0;if((l|0)==(c[e>>2]|0)){c[e>>2]=k;if(!k){c[6041]=c[6041]&~(1<<d);break}}else{if(h>>>0<(c[6044]|0)>>>0)sc();d=h+16|0;if((c[d>>2]|0)==(l|0))c[d>>2]=k;else c[h+20>>2]=k;if(!k)break}e=c[6044]|0;if(k>>>0<e>>>0)sc();c[k+24>>2]=h;d=c[a+(j+16)>>2]|0;do if(d)if(d>>>0<e>>>0)sc();else{c[k+16>>2]=d;c[d+24>>2]=k;break}while(0);d=c[a+(j+20)>>2]|0;if(d)if(d>>>0<(c[6044]|0)>>>0)sc();else{c[k+20>>2]=d;c[d+24>>2]=k;break}}}else{f=c[a+(j+8)>>2]|0;e=c[a+(j+12)>>2]|0;d=24200+(g<<1<<2)|0;if((f|0)!=(d|0)){if(f>>>0<i>>>0)sc();if((c[f+12>>2]|0)!=(l|0))sc()}if((e|0)==(f|0)){c[6040]=c[6040]&~(1<<g);break}if((e|0)!=(d|0)){if(e>>>0<i>>>0)sc();d=e+8|0;if((c[d>>2]|0)==(l|0))h=d;else sc()}else h=e+8|0;c[f+12>>2]=e;c[h>>2]=f}while(0);if(n>>>0<16){c[o>>2]=m|p&1|2;b=a+(m|4)|0;c[b>>2]=c[b>>2]|1;return a|0}else{c[o>>2]=p&1|b|2;c[a+(b+4)>>2]=n|3;p=a+(m|4)|0;c[p>>2]=c[p>>2]|1;ko(a+b|0,n);return a|0}return 0}function ko(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;q=a+b|0;d=c[a+4>>2]|0;do if(!(d&1)){k=c[a>>2]|0;if(!(d&3))return;n=a+(0-k)|0;m=k+b|0;j=c[6044]|0;if(n>>>0<j>>>0)sc();if((n|0)==(c[6045]|0)){e=a+(b+4)|0;d=c[e>>2]|0;if((d&3|0)!=3){t=n;h=m;break}c[6042]=m;c[e>>2]=d&-2;c[a+(4-k)>>2]=m|1;c[q>>2]=m;return}g=k>>>3;if(k>>>0<256){f=c[a+(8-k)>>2]|0;e=c[a+(12-k)>>2]|0;d=24200+(g<<1<<2)|0;if((f|0)!=(d|0)){if(f>>>0<j>>>0)sc();if((c[f+12>>2]|0)!=(n|0))sc()}if((e|0)==(f|0)){c[6040]=c[6040]&~(1<<g);t=n;h=m;break}if((e|0)!=(d|0)){if(e>>>0<j>>>0)sc();d=e+8|0;if((c[d>>2]|0)==(n|0))i=d;else sc()}else i=e+8|0;c[f+12>>2]=e;c[i>>2]=f;t=n;h=m;break}i=c[a+(24-k)>>2]|0;f=c[a+(12-k)>>2]|0;do if((f|0)==(n|0)){f=16-k|0;e=a+(f+4)|0;d=c[e>>2]|0;if(!d){e=a+f|0;d=c[e>>2]|0;if(!d){l=0;break}}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<j>>>0)sc();else{c[e>>2]=0;l=d;break}}else{g=c[a+(8-k)>>2]|0;if(g>>>0<j>>>0)sc();d=g+12|0;if((c[d>>2]|0)!=(n|0))sc();e=f+8|0;if((c[e>>2]|0)==(n|0)){c[d>>2]=f;c[e>>2]=g;l=f;break}else sc()}while(0);if(i){d=c[a+(28-k)>>2]|0;e=24464+(d<<2)|0;if((n|0)==(c[e>>2]|0)){c[e>>2]=l;if(!l){c[6041]=c[6041]&~(1<<d);t=n;h=m;break}}else{if(i>>>0<(c[6044]|0)>>>0)sc();d=i+16|0;if((c[d>>2]|0)==(n|0))c[d>>2]=l;else c[i+20>>2]=l;if(!l){t=n;h=m;break}}f=c[6044]|0;if(l>>>0<f>>>0)sc();c[l+24>>2]=i;d=16-k|0;e=c[a+d>>2]|0;do if(e)if(e>>>0<f>>>0)sc();else{c[l+16>>2]=e;c[e+24>>2]=l;break}while(0);d=c[a+(d+4)>>2]|0;if(d)if(d>>>0<(c[6044]|0)>>>0)sc();else{c[l+20>>2]=d;c[d+24>>2]=l;t=n;h=m;break}else{t=n;h=m}}else{t=n;h=m}}else{t=a;h=b}while(0);j=c[6044]|0;if(q>>>0<j>>>0)sc();d=a+(b+4)|0;e=c[d>>2]|0;if(!(e&2)){if((q|0)==(c[6046]|0)){s=(c[6043]|0)+h|0;c[6043]=s;c[6046]=t;c[t+4>>2]=s|1;if((t|0)!=(c[6045]|0))return;c[6045]=0;c[6042]=0;return}if((q|0)==(c[6045]|0)){s=(c[6042]|0)+h|0;c[6042]=s;c[6045]=t;c[t+4>>2]=s|1;c[t+s>>2]=s;return}h=(e&-8)+h|0;g=e>>>3;do if(e>>>0>=256){i=c[a+(b+24)>>2]|0;f=c[a+(b+12)>>2]|0;do if((f|0)==(q|0)){e=a+(b+20)|0;d=c[e>>2]|0;if(!d){e=a+(b+16)|0;d=c[e>>2]|0;if(!d){p=0;break}}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<j>>>0)sc();else{c[e>>2]=0;p=d;break}}else{g=c[a+(b+8)>>2]|0;if(g>>>0<j>>>0)sc();d=g+12|0;if((c[d>>2]|0)!=(q|0))sc();e=f+8|0;if((c[e>>2]|0)==(q|0)){c[d>>2]=f;c[e>>2]=g;p=f;break}else sc()}while(0);if(i){d=c[a+(b+28)>>2]|0;e=24464+(d<<2)|0;if((q|0)==(c[e>>2]|0)){c[e>>2]=p;if(!p){c[6041]=c[6041]&~(1<<d);break}}else{if(i>>>0<(c[6044]|0)>>>0)sc();d=i+16|0;if((c[d>>2]|0)==(q|0))c[d>>2]=p;else c[i+20>>2]=p;if(!p)break}e=c[6044]|0;if(p>>>0<e>>>0)sc();c[p+24>>2]=i;d=c[a+(b+16)>>2]|0;do if(d)if(d>>>0<e>>>0)sc();else{c[p+16>>2]=d;c[d+24>>2]=p;break}while(0);d=c[a+(b+20)>>2]|0;if(d)if(d>>>0<(c[6044]|0)>>>0)sc();else{c[p+20>>2]=d;c[d+24>>2]=p;break}}}else{f=c[a+(b+8)>>2]|0;e=c[a+(b+12)>>2]|0;d=24200+(g<<1<<2)|0;if((f|0)!=(d|0)){if(f>>>0<j>>>0)sc();if((c[f+12>>2]|0)!=(q|0))sc()}if((e|0)==(f|0)){c[6040]=c[6040]&~(1<<g);break}if((e|0)!=(d|0)){if(e>>>0<j>>>0)sc();d=e+8|0;if((c[d>>2]|0)==(q|0))o=d;else sc()}else o=e+8|0;c[f+12>>2]=e;c[o>>2]=f}while(0);c[t+4>>2]=h|1;c[t+h>>2]=h;if((t|0)==(c[6045]|0)){c[6042]=h;return}}else{c[d>>2]=e&-2;c[t+4>>2]=h|1;c[t+h>>2]=h}d=h>>>3;if(h>>>0<256){e=d<<1;g=24200+(e<<2)|0;f=c[6040]|0;d=1<<d;if(f&d){d=24200+(e+2<<2)|0;e=c[d>>2]|0;if(e>>>0<(c[6044]|0)>>>0)sc();else{r=d;s=e}}else{c[6040]=f|d;r=24200+(e+2<<2)|0;s=g}c[r>>2]=t;c[s+12>>2]=t;c[t+8>>2]=s;c[t+12>>2]=g;return}d=h>>>8;if(d)if(h>>>0>16777215)g=31;else{r=(d+1048320|0)>>>16&8;s=d<<r;q=(s+520192|0)>>>16&4;s=s<<q;g=(s+245760|0)>>>16&2;g=14-(q|r|g)+(s<<g>>>15)|0;g=h>>>(g+7|0)&1|g<<1}else g=0;d=24464+(g<<2)|0;c[t+28>>2]=g;c[t+20>>2]=0;c[t+16>>2]=0;e=c[6041]|0;f=1<<g;if(!(e&f)){c[6041]=e|f;c[d>>2]=t;c[t+24>>2]=d;c[t+12>>2]=t;c[t+8>>2]=t;return}d=c[d>>2]|0;a:do if((c[d+4>>2]&-8|0)!=(h|0)){g=h<<((g|0)==31?0:25-(g>>>1)|0);while(1){e=d+16+(g>>>31<<2)|0;f=c[e>>2]|0;if(!f)break;if((c[f+4>>2]&-8|0)==(h|0)){d=f;break a}else{g=g<<1;d=f}}if(e>>>0<(c[6044]|0)>>>0)sc();c[e>>2]=t;c[t+24>>2]=d;c[t+12>>2]=t;c[t+8>>2]=t;return}while(0);e=d+8|0;f=c[e>>2]|0;s=c[6044]|0;if(!(f>>>0>=s>>>0&d>>>0>=s>>>0))sc();c[f+12>>2]=t;c[e>>2]=t;c[t+8>>2]=f;c[t+12>>2]=d;c[t+24>>2]=0;return}function lo(b){b=b|0;if(a[b>>0]&1)Gl(c[b+8>>2]|0);return}function mo(a,b){a=a|0;b=b|0;return no(a,b,Mn(b)|0)|0}function no(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))h=10;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}g=(f&1)==0;do if(h>>>0>=e>>>0){if(g)f=b+1|0;else f=c[b+8>>2]|0;to(f|0,d|0,e|0)|0;a[f+e>>0]=0;if(!(a[b>>0]&1)){a[b>>0]=e<<1;break}else{c[b+4>>2]=e;break}}else{if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;oo(b,h,e-h|0,f,0,f,e,d)}while(0);return b|0}function oo(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;if((-18-d|0)>>>0<e>>>0)km(b);if(!(a[b>>0]&1))m=b+1|0;else m=c[b+8>>2]|0;if(d>>>0<2147483623){k=e+d|0;l=d<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<11?11:k+16&-16}else k=-17;l=El(k)|0;if(g)so(l|0,m|0,g|0)|0;if(i)so(l+g|0,j|0,i|0)|0;e=f-h|0;if((e|0)!=(g|0))so(l+(i+g)|0,m+(h+g)|0,e-g|0)|0;if((d|0)!=10)Gl(m);c[b+8>>2]=l;c[b>>2]=k|1;d=e+i|0;c[b+4>>2]=d;a[l+d>>0]=0;return}function po(){}function qo(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=b-d-(c>>>0>a>>>0|0)>>>0;return (D=d,a-c>>>0|0)|0}function ro(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;c=a+c>>>0;return (D=b+d+(c>>>0<a>>>0|0)>>>0,c|0)|0}function so(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)>=4096)return Ma(b|0,d|0,e|0)|0;f=b|0;if((b&3)==(d&3)){while(b&3){if(!e)return f|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function to(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else so(b,c,d)|0;return b|0}function uo(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=b+e|0;if((e|0)>=20){d=d&255;h=b&3;i=d|d<<8|d<<16|d<<24;g=f&~3;if(h){h=b+4-h|0;while((b|0)<(h|0)){a[b>>0]=d;b=b+1|0}}while((b|0)<(g|0)){c[b>>2]=i;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return b-e|0}function vo(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){D=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}D=0;return b>>>c-32|0}function wo(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){D=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}D=a<<c-32;return 0}function xo(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){D=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}D=(b|0)<0?-1:0;return b>>c-32|0}function yo(b){b=b|0;var c=0;c=a[m+(b&255)>>0]|0;if((c|0)<8)return c|0;c=a[m+(b>>8&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[m+(b>>16&255)>>0]|0;if((c|0)<8)return c+16|0;return (a[m+(b>>>24)>>0]|0)+24|0}function zo(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;f=a&65535;e=b&65535;c=$(e,f)|0;d=a>>>16;a=(c>>>16)+($(e,d)|0)|0;e=b>>>16;b=$(e,f)|0;return (D=(a>>>16)+($(e,d)|0)+(((a&65535)+b|0)>>>16)|0,a+b<<16|c&65535|0)|0}function Ao(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;j=b>>31|((b|0)<0?-1:0)<<1;i=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;f=d>>31|((d|0)<0?-1:0)<<1;e=((d|0)<0?-1:0)>>31|((d|0)<0?-1:0)<<1;h=qo(j^a,i^b,j,i)|0;g=D;a=f^j;b=e^i;return qo((Fo(h,g,qo(f^c,e^d,f,e)|0,D,0)|0)^a,D^b,a,b)|0}function Bo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;j=f|0;h=b>>31|((b|0)<0?-1:0)<<1;g=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;l=e>>31|((e|0)<0?-1:0)<<1;k=((e|0)<0?-1:0)>>31|((e|0)<0?-1:0)<<1;a=qo(h^a,g^b,h,g)|0;b=D;Fo(a,b,qo(l^d,k^e,l,k)|0,D,j)|0;e=qo(c[j>>2]^h,c[j+4>>2]^g,h,g)|0;d=D;i=f;return (D=d,e)|0}function Co(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=a;f=c;c=zo(e,f)|0;a=D;return (D=($(b,f)|0)+($(d,e)|0)+a|a&0,c|0|0)|0}function Do(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Fo(a,b,c,d,0)|0}function Eo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+16|0;f=g|0;Fo(a,b,d,e,f)|0;i=g;return (D=c[f+4>>2]|0,c[f>>2]|0)|0}function Fo(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=a;j=b;k=j;h=d;n=e;i=n;if(!k){g=(f|0)!=0;if(!i){if(g){c[f>>2]=(l>>>0)%(h>>>0);c[f+4>>2]=0}n=0;f=(l>>>0)/(h>>>0)>>>0;return (D=n,f)|0}else{if(!g){n=0;f=0;return (D=n,f)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;n=0;f=0;return (D=n,f)|0}}g=(i|0)==0;do if(h){if(!g){g=(ba(i|0)|0)-(ba(k|0)|0)|0;if(g>>>0<=31){m=g+1|0;i=31-g|0;b=g-31>>31;h=m;a=l>>>(m>>>0)&b|k<<i;b=k>>>(m>>>0)&b;g=0;i=l<<i;break}if(!f){n=0;f=0;return (D=n,f)|0}c[f>>2]=a|0;c[f+4>>2]=j|b&0;n=0;f=0;return (D=n,f)|0}g=h-1|0;if(g&h){i=(ba(h|0)|0)+33-(ba(k|0)|0)|0;p=64-i|0;m=32-i|0;j=m>>31;o=i-32|0;b=o>>31;h=i;a=m-1>>31&k>>>(o>>>0)|(k<<m|l>>>(i>>>0))&b;b=b&k>>>(i>>>0);g=l<<p&j;i=(k<<p|l>>>(o>>>0))&j|l<<m&i-33>>31;break}if(f){c[f>>2]=g&l;c[f+4>>2]=0}if((h|0)==1){o=j|b&0;p=a|0|0;return (D=o,p)|0}else{p=yo(h|0)|0;o=k>>>(p>>>0)|0;p=k<<32-p|l>>>(p>>>0)|0;return (D=o,p)|0}}else{if(g){if(f){c[f>>2]=(k>>>0)%(h>>>0);c[f+4>>2]=0}o=0;p=(k>>>0)/(h>>>0)>>>0;return (D=o,p)|0}if(!l){if(f){c[f>>2]=0;c[f+4>>2]=(k>>>0)%(i>>>0)}o=0;p=(k>>>0)/(i>>>0)>>>0;return (D=o,p)|0}g=i-1|0;if(!(g&i)){if(f){c[f>>2]=a|0;c[f+4>>2]=g&k|b&0}o=0;p=k>>>((yo(i|0)|0)>>>0);return (D=o,p)|0}g=(ba(i|0)|0)-(ba(k|0)|0)|0;if(g>>>0<=30){b=g+1|0;i=31-g|0;h=b;a=k<<i|l>>>(b>>>0);b=k>>>(b>>>0);g=0;i=l<<i;break}if(!f){o=0;p=0;return (D=o,p)|0}c[f>>2]=a|0;c[f+4>>2]=j|b&0;o=0;p=0;return (D=o,p)|0}while(0);if(!h){k=i;j=0;i=0}else{m=d|0|0;l=n|e&0;k=ro(m|0,l|0,-1,-1)|0;d=D;j=i;i=0;do{e=j;j=g>>>31|j<<1;g=i|g<<1;e=a<<1|e>>>31|0;n=a>>>31|b<<1|0;qo(k,d,e,n)|0;p=D;o=p>>31|((p|0)<0?-1:0)<<1;i=o&1;a=qo(e,n,o&m,(((p|0)<0?-1:0)>>31|((p|0)<0?-1:0)<<1)&l)|0;b=D;h=h-1|0}while((h|0)!=0);k=j;j=0}h=0;if(f){c[f>>2]=a;c[f+4>>2]=b}o=(g|0)>>>31|(k|h)<<1|(h<<1|g>>>31)&0|j;p=(g<<1|0>>>31)&-2|i;return (D=o,p)|0}function Go(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return jd[a&15](b|0,c|0,d|0)|0}function Ho(a){a=a|0;return +kd[a&1]()}function Io(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;ld[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0)}function Jo(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;md[a&3](b|0,c|0,d|0,e|0,f|0)}function Ko(a){a=a|0;return nd[a&15]()|0}function Lo(a,b){a=a|0;b=b|0;od[a&63](b|0)}function Mo(a,b){a=a|0;b=+b;return +pd[a&1](+b)}function No(a,b,c){a=a|0;b=b|0;c=c|0;qd[a&63](b|0,c|0)}function Oo(a,b){a=a|0;b=b|0;return rd[a&63](b|0)|0}function Po(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;sd[a&15](b|0,c|0,d|0)}function Qo(a){a=a|0;td[a&15]()}function Ro(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return ud[a&3](b|0,c|0,d|0,e|0)|0}function So(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;vd[a&3](b|0,c|0,d|0,e|0,f|0,g|0)}function To(a,b,c){a=a|0;b=b|0;c=c|0;return wd[a&31](b|0,c|0)|0}function Uo(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return xd[a&7](b|0,c|0,d|0,e|0,f|0)|0}function Vo(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;yd[a&7](b|0,c|0,d|0,e|0)}function Wo(a,b,c){a=a|0;b=b|0;c=c|0;ca(0);return 0}function Xo(){ca(1);return 0.0}function Yo(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;ca(2)}function Zo(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ca(3)}function _o(){ca(4);return 0}function $o(a){a=a|0;ca(5)}function ap(a){a=+a;ca(6);return 0.0}function bp(a,b){a=a|0;b=b|0;ca(7)}function cp(a){a=a|0;ca(8);return 0}function dp(a,b,c){a=a|0;b=b|0;c=c|0;ca(9)}function ep(a,b,c){a=a|0;b=b|0;c=c|0;ad(a|0,b|0,c|0)}function fp(){ca(10)}function gp(){cc()}function hp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ca(11);return 0}function ip(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ca(12)}function jp(a,b){a=a|0;b=b|0;ca(13);return 0}function kp(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ca(14);return 0}function lp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ca(15)}

// EMSCRIPTEN_END_FUNCS
var jd=[Wo,Wl,Xl,ao,tn,sn,rn,un,df,ig,Cg,$g,ih,uh,Wo,Wo];var kd=[Xo,ee];var ld=[Yo,Xf];var md=[Zo,cm,bm,Zo];var nd=[_o,cf,ce,$d,ff,ke,ie,Ke,Se,_d,Dl,_o,_o,_o,_o,_o];var od=[$o,Il,Jl,Ql,Tl,Rl,Sl,Ul,Vl,ve,Yd,Hi,ye,Ae,Pe,af,yh,lk,wk,mk,xk,zh,Pi,lg,Fg,ch,lh,xh,ki,Cj,ti,Sd,$j,Td,lo,jm,Yn,Zn,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o,$o];var pd=[ap,fe];var qd=[bp,Tf,bg,pe,qf,kg,mg,ng,og,pg,qg,rg,sg,tg,ug,vg,wg,Eg,Gg,Hg,Ig,Jg,Kg,Lg,Mg,Ng,Og,Pg,Qg,Rg,Sg,Tg,Ug,Vg,bh,kh,mh,nh,oh,wh,ui,Cl,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp,bp];var rd=[cp,Kl,qn,bf,Nd,de,ae,ef,ag,he,Fi,Ee,Fe,gf,hf,jf,lf,Ne,Re,uf,vf,pf,zf,Af,re,gg,hg,Ag,Bg,Yg,Zg,_g,gh,hh,rh,sh,th,ik,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp,cp];var sd=[dp,Yf,We,ep,eg,jg,yg,Dg,Xg,ah,eh,jh,qh,vh,dp,dp];var td=[fp,hm,Xd,Qe,nf,cg,bk,ck,im,gp,fp,fp,fp,fp,fp,fp];var ud=[hp,Md,Le,hk];var vd=[ip,em,dm,ip];var wd=[jp,Ii,kf,mf,Oe,wf,Bf,Gf,If,Jf,Kf,Lf,Mf,$f,fg,zg,fh,gk,jk,jp,jp,jp,jp,jp,jp,jp,jp,jp,jp,jp,jp,jp];var xd=[kp,Wk,Xk,Yk,Zk,_k,kp,kp];var yd=[lp,Zl,_l,me,Ck,Dk,Ek,lp];return{___cxa_can_catch:fm,_fflush:Om,_main:kk,___cxa_is_pointer_type:gm,_i64Add:ro,_hsp3dish_sync_done:dk,_i64Subtract:qo,_memset:uo,_malloc:fo,_memcpy:so,_memmove:to,_bitshift64Lshr:vo,_free:go,___errno_location:sm,_bitshift64Shl:wo,__GLOBAL__sub_I_hsp3int_cpp:Cf,__GLOBAL__sub_I_hsp3dish_cpp:fk,runPostSets:po,stackAlloc:zd,stackSave:Ad,stackRestore:Bd,establishStackSpace:Cd,setThrew:Dd,setTempRet0:Gd,getTempRet0:Hd,dynCall_iiii:Go,dynCall_d:Ho,dynCall_viiiiiii:Io,dynCall_viiiii:Jo,dynCall_i:Ko,dynCall_vi:Lo,dynCall_dd:Mo,dynCall_vii:No,dynCall_ii:Oo,dynCall_viii:Po,dynCall_v:Qo,dynCall_iiiii:Ro,dynCall_viiiiii:So,dynCall_iii:To,dynCall_iiiiii:Uo,dynCall_viiii:Vo}})


// EMSCRIPTEN_END_ASM
(Module.asmGlobalArg,Module.asmLibraryArg,buffer);var runPostSets=Module["runPostSets"]=asm["runPostSets"];var ___cxa_can_catch=Module["___cxa_can_catch"]=asm["___cxa_can_catch"];var _fflush=Module["_fflush"]=asm["_fflush"];var _main=Module["_main"]=asm["_main"];var __GLOBAL__sub_I_hsp3dish_cpp=Module["__GLOBAL__sub_I_hsp3dish_cpp"]=asm["__GLOBAL__sub_I_hsp3dish_cpp"];var ___cxa_is_pointer_type=Module["___cxa_is_pointer_type"]=asm["___cxa_is_pointer_type"];var _i64Add=Module["_i64Add"]=asm["_i64Add"];var _hsp3dish_sync_done=Module["_hsp3dish_sync_done"]=asm["_hsp3dish_sync_done"];var __GLOBAL__sub_I_hsp3int_cpp=Module["__GLOBAL__sub_I_hsp3int_cpp"]=asm["__GLOBAL__sub_I_hsp3int_cpp"];var _i64Subtract=Module["_i64Subtract"]=asm["_i64Subtract"];var _memset=Module["_memset"]=asm["_memset"];var _malloc=Module["_malloc"]=asm["_malloc"];var _memcpy=Module["_memcpy"]=asm["_memcpy"];var _memmove=Module["_memmove"]=asm["_memmove"];var _bitshift64Lshr=Module["_bitshift64Lshr"]=asm["_bitshift64Lshr"];var _free=Module["_free"]=asm["_free"];var ___errno_location=Module["___errno_location"]=asm["___errno_location"];var _bitshift64Shl=Module["_bitshift64Shl"]=asm["_bitshift64Shl"];var dynCall_iiii=Module["dynCall_iiii"]=asm["dynCall_iiii"];var dynCall_d=Module["dynCall_d"]=asm["dynCall_d"];var dynCall_viiiiiii=Module["dynCall_viiiiiii"]=asm["dynCall_viiiiiii"];var dynCall_viiiii=Module["dynCall_viiiii"]=asm["dynCall_viiiii"];var dynCall_i=Module["dynCall_i"]=asm["dynCall_i"];var dynCall_vi=Module["dynCall_vi"]=asm["dynCall_vi"];var dynCall_dd=Module["dynCall_dd"]=asm["dynCall_dd"];var dynCall_vii=Module["dynCall_vii"]=asm["dynCall_vii"];var dynCall_ii=Module["dynCall_ii"]=asm["dynCall_ii"];var dynCall_viii=Module["dynCall_viii"]=asm["dynCall_viii"];var dynCall_v=Module["dynCall_v"]=asm["dynCall_v"];var dynCall_iiiii=Module["dynCall_iiiii"]=asm["dynCall_iiiii"];var dynCall_viiiiii=Module["dynCall_viiiiii"]=asm["dynCall_viiiiii"];var dynCall_iii=Module["dynCall_iii"]=asm["dynCall_iii"];var dynCall_iiiiii=Module["dynCall_iiiiii"]=asm["dynCall_iiiiii"];var dynCall_viiii=Module["dynCall_viiii"]=asm["dynCall_viiii"];Runtime.stackAlloc=asm["stackAlloc"];Runtime.stackSave=asm["stackSave"];Runtime.stackRestore=asm["stackRestore"];Runtime.establishStackSpace=asm["establishStackSpace"];Runtime.setTempRet0=asm["setTempRet0"];Runtime.getTempRet0=asm["getTempRet0"];function ExitStatus(status){this.name="ExitStatus";this.message="Program terminated with exit("+status+")";this.status=status}ExitStatus.prototype=new Error;ExitStatus.prototype.constructor=ExitStatus;var initialStackTop;var preloadStartTime=null;var calledMain=false;dependenciesFulfilled=function runCaller(){if(!Module["calledRun"])run();if(!Module["calledRun"])dependenciesFulfilled=runCaller};Module["callMain"]=Module.callMain=function callMain(args){assert(runDependencies==0,"cannot call main when async dependencies remain! (listen on __ATMAIN__)");assert(__ATPRERUN__.length==0,"cannot call main when preRun functions remain to be called");args=args||[];ensureInitRuntime();var argc=args.length+1;function pad(){for(var i=0;i<4-1;i++){argv.push(0)}}var argv=[allocate(intArrayFromString(Module["thisProgram"]),"i8",ALLOC_NORMAL)];pad();for(var i=0;i<argc-1;i=i+1){argv.push(allocate(intArrayFromString(args[i]),"i8",ALLOC_NORMAL));pad()}argv.push(0);argv=allocate(argv,"i32",ALLOC_NORMAL);try{var ret=Module["_main"](argc,argv,0);exit(ret,true)}catch(e){if(e instanceof ExitStatus){return}else if(e=="SimulateInfiniteLoop"){Module["noExitRuntime"]=true;return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}finally{calledMain=true}};function run(args){args=args||Module["arguments"];if(preloadStartTime===null)preloadStartTime=Date.now();if(runDependencies>0){return}preRun();if(runDependencies>0)return;if(Module["calledRun"])return;function doRun(){if(Module["calledRun"])return;Module["calledRun"]=true;if(ABORT)return;ensureInitRuntime();preMain();if(Module["onRuntimeInitialized"])Module["onRuntimeInitialized"]();if(Module["_main"]&&shouldRunNow)Module["callMain"](args);postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout((function(){setTimeout((function(){Module["setStatus"]("")}),1);doRun()}),1)}else{doRun()}}Module["run"]=Module.run=run;function exit(status,implicit){if(implicit&&Module["noExitRuntime"]){return}if(Module["noExitRuntime"]){}else{ABORT=true;EXITSTATUS=status;STACKTOP=initialStackTop;exitRuntime();if(Module["onExit"])Module["onExit"](status)}if(ENVIRONMENT_IS_NODE){process["stdout"]["once"]("drain",(function(){process["exit"](status)}));console.log(" ");setTimeout((function(){process["exit"](status)}),500)}else if(ENVIRONMENT_IS_SHELL&&typeof quit==="function"){quit(status)}throw new ExitStatus(status)}Module["exit"]=Module.exit=exit;var abortDecorators=[];function abort(what){if(what!==undefined){Module.print(what);Module.printErr(what);what=JSON.stringify(what)}else{what=""}ABORT=true;EXITSTATUS=1;var extra="\nIf this abort() is unexpected, build with -s ASSERTIONS=1 which can give more information.";var output="abort("+what+") at "+stackTrace()+extra;if(abortDecorators){abortDecorators.forEach((function(decorator){output=decorator(output,what)}))}throw output}Module["abort"]=Module.abort=abort;if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}var shouldRunNow=true;if(Module["noInitialRun"]){shouldRunNow=false}run()




