/**
 * @license
 * Copyright (C) 1997-2014, Onion Software/onitama.
 * Copyright (C) 2014, zakki.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.  Redistributions in binary
 * form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided
 * with the distribution.  Neither the name of the Onion Software nor the names
 * of its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 **/
var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer;buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[(function($0){{var dir=Pointer_stringify($0);FS.mkdir(dir);FS.mount(IDBFS,{},dir);FS.syncfs(true,(function(err){console.log(err);ccall("hsp3dish_sync_done","v","",[])}))}}),(function($0){{var dir=Pointer_stringify($0);FS.syncfs((function(err){console.log("syncfs",err)}))}}),(function($0){{console.log(Pointer_stringify($0))}})];function _emscripten_asm_const_1(code,a0){return ASM_CONSTS[code](a0)}STATIC_BASE=8;STATICTOP=STATIC_BASE+76320;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_hsp3gr_dish_cpp()})},{func:(function(){__GLOBAL__sub_I_hsp3int_cpp()})},{func:(function(){__GLOBAL__sub_I_hsp3dish_cpp()})},{func:(function(){__GLOBAL__sub_I_Bundle_cpp()})},{func:(function(){__GLOBAL__sub_I_Effect_cpp()})},{func:(function(){__GLOBAL__sub_I_FileSystem_cpp()})},{func:(function(){__GLOBAL__sub_I_Font_cpp()})},{func:(function(){__GLOBAL__sub_I_Gamepad_cpp()})},{func:(function(){__GLOBAL__sub_I_Logger_cpp()})},{func:(function(){__GLOBAL__sub_I_RenderState_cpp()})},{func:(function(){__GLOBAL__sub_I_Scene_cpp()})},{func:(function(){__GLOBAL__sub_I_Texture_cpp()})},{func:(function(){__GLOBAL__sub_I_Transform_cpp()})},{func:(function(){__GLOBAL__sub_I_VertexAttributeBinding_cpp()})},{func:(function(){__GLOBAL__sub_I_Form_cpp()})},{func:(function(){__GLOBAL__sub_I_FrameBuffer_cpp()})},{func:(function(){__GLOBAL__sub_I_RadioButton_cpp()})},{func:(function(){__GLOBAL__sub_I_RenderTarget_cpp()})},{func:(function(){__GLOBAL__sub_I_Theme_cpp()})},{func:(function(){__GLOBAL__sub_I_DepthStencilTarget_cpp()})},{func:(function(){__GLOBAL__sub_I_btQuickprof_cpp()})});allocate([148,105,0,0,200,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,136,127,0,0,200,1,0,0,0,0,0,0,216,105,0,0,191,128,0,0,136,0,0,0,0,0,0,0,216,105,0,0,9,129,0,0,104,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,51,145,0,0,104,4,0,0,0,0,0,0,216,105,0,0,86,145,0,0,104,4,0,0,0,0,0,0,176,105,0,0,113,145,0,0,216,105,0,0,142,145,0,0,104,4,0,0,0,0,0,0,0,106,0,0,45,166,0,0,0,0,0,0,2,0,0,0,104,4,0,0,2,0,0,0,112,1,0,0,2,8,0,0,176,105,0,0,64,166,0,0,216,105,0,0,95,166,0,0,104,4,0,0,0,0,0,0,216,105,0,0,214,167,0,0,104,4,0,0,0,0,0,0,216,105,0,0,0,170,0,0,168,1,0,0,0,0,0,0,176,105,0,0,202,170,0,0,216,105,0,0,221,170,0,0,104,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,105,0,0,78,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,105,0,0,132,172,0,0,176,105,0,0,158,172,0,0,216,105,0,0,22,174,0,0,128,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,40,174,0,0,104,4,0,0,0,0,0,0,216,105,0,0,177,174,0,0,112,4,0,0,0,0,0,0,0,106,0,0,5,178,0,0,0,0,0,0,2,0,0,0,56,1,0,0,2,0,0,0,104,4,0,0,2,12,0,0,0,0,0,0,0,0,0,0,216,105,0,0,192,179,0,0,104,4,0,0,0,0,0,0,216,105,0,0,234,180,0,0,112,1,0,0,0,0,0,0,216,105,0,0,255,180,0,0,104,4,0,0,0,0,0,0,0,106,0,0,119,181,0,0,0,0,0,0,2,0,0,0,56,5,0,0,2,0,0,0,104,4,0,0,2,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,136,181,0,0,112,4,0,0,0,0,0,0,216,105,0,0,209,181,0,0,208,3,0,0,0,0,0,0,216,105,0,0,239,181,0,0,240,2,0,0,0,0,0,0,176,105,0,0,30,182,0,0,216,105,0,0,50,182,0,0,8,3,0,0,0,0,0,0,216,105,0,0,96,182,0,0,24,3,0,0,0,0,0,0,176,105,0,0,146,182,0,0,176,105,0,0,189,182,0,0,216,105,0,0,225,182,0,0,72,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,105,0,0,25,183,0,0,176,105,0,0,41,183,0,0,216,105,0,0,85,183,0,0,104,4,0,0,0,0,0,0,216,105,0,0,120,183,0,0,80,3,0,0,0,0,0,0,216,105,0,0,170,183,0,0,232,4,0,0,0,0,0,0,216,105,0,0,201,183,0,0,152,3,0,0,0,0,0,0,176,105,0,0,140,187,0,0,216,105,0,0,155,187,0,0,176,3,0,0,0,0,0,0,176,105,0,0,177,187,0,0,216,105,0,0,205,187,0,0,200,3,0,0,0,0,0,0,176,105,0,0,252,187,0,0,0,106,0,0,36,188,0,0,0,0,0,0,2,0,0,0,32,3,0,0,2,0,0,0,112,1,0,0,2,24,0,0,0,106,0,0,68,188,0,0,0,0,0,0,2,0,0,0,32,3,0,0,2,0,0,0,112,1,0,0,2,24,0,0,216,105,0,0,98,188,0,0,32,3,0,0,0,0,0,0,216,105,0,0,169,188,0,0,64,4,0,0,0,0,0,0,216,105,0,0,126,188,0,0,184,3,0,0,0,0,0,0,176,105,0,0,204,188,0,0,216,105,0,0,225,188,0,0,32,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,105,0,0,212,194,0,0,216,105,0,0,228,194,0,0,104,4,0,0,0,0,0,0,216,105,0,0,253,194,0,0,104,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,133,199,0,0,136,0,0,0,0,0,0,0,216,105,0,0,217,199,0,0,136,0,0,0,0,0,0,0,216,105,0,0,45,200,0,0,136,0,0,0,0,0,0,0,216,105,0,0,127,200,0,0,136,0,0,0,0,0,0,0,216,105,0,0,210,200,0,0,104,4,0,0,0,0,0,0,176,105,0,0,73,201,0,0,176,105,0,0,43,202,0,0,216,105,0,0,251,202,0,0,136,0,0,0,0,0,0,0,216,105,0,0,78,203,0,0,112,4,0,0,0,0,0,0,216,105,0,0,100,203,0,0,104,4,0,0,0,0,0,0,216,105,0,0,120,203,0,0,104,4,0,0,0,0,0,0,0,106,0,0,176,208,0,0,0,0,0,0,2,0,0,0,56,1,0,0,2,0,0,0,232,4,0,0,2,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,227,208,0,0,104,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,40,210,0,0,112,1,0,0,0,0,0,0,216,105,0,0,67,210,0,0,120,6,0,0,0,0,0,0,0,106,0,0,101,210,0,0,0,0,0,0,2,0,0,0,240,5,0,0,2,0,0,0,224,1,0,0,0,232,0,0,0,106,0,0,238,211,0,0,0,0,0,0,3,0,0,0,104,4,0,0,2,0,0,0,56,1,0,0,2,8,0,0,232,4,0,0,2,20,0,0,216,105,0,0,68,214,0,0,136,6,0,0,0,0,0,0,216,105,0,0,92,214,0,0,208,5,0,0,0,0,0,0,216,105,0,0,170,215,0,0,104,4,0,0,0,0,0,0,216,105,0,0,104,216,0,0,104,4,0,0,0,0,0,0,216,105,0,0,208,217,0,0,192,5,0,0,0,0,0,0,216,105,0,0,3,218,0,0,240,5,0,0,0,0,0,0,216,105,0,0,193,218,0,0,240,5,0,0,0,0,0,0,216,105,0,0,98,219,0,0,104,4,0,0,0,0,0,0,216,105,0,0,155,219,0,0,192,5,0,0,0,0,0,0,216,105,0,0,44,220,0,0,104,4,0,0,0,0,0,0,216,105,0,0,144,220,0,0,120,6,0,0,0,0,0,0,216,105,0,0,92,221,0,0,120,6,0,0,0,0,0,0,216,105,0,0,205,221,0,0,104,4,0,0,0,0,0,0,216,105,0,0,223,221,0,0,104,4,0,0,0,0,0,0,216,105,0,0,253,221,0,0,104,4,0,0,0,0,0,0,216,105,0,0,25,222,0,0,104,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,116,223,0,0,0,0,0,0,2,0,0,0,104,4,0,0,2,0,0,0,56,1,0,0,2,8,0,0,216,105,0,0,148,223,0,0,136,6,0,0,0,0,0,0,216,105,0,0,164,248,0,0,136,6,0,0,0,0,0,0,216,105,0,0,201,248,0,0,192,5,0,0,0,0,0,0,216,105,0,0,200,249,0,0,136,7,0,0,0,0,0,0,176,105,0,0,56,250,0,0,216,105,0,0,77,250,0,0,160,7,0,0,0,0,0,0,216,105,0,0,228,251,0,0,192,8,0,0,0,0,0,0,216,105,0,0,246,251,0,0,8,3,0,0,0,0,0,0,216,105,0,0,27,252,0,0,208,7,0,0,0,0,0,0,176,105,0,0,57,252,0,0,216,105,0,0,104,252,0,0,184,8,0,0,0,0,0,0,216,105,0,0,139,252,0,0,240,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,158,252,0,0,16,8,0,0,0,0,0,0,176,105,0,0,177,252,0,0,216,105,0,0,201,252,0,0,40,8,0,0,0,0,0,0,176,105,0,0,224,252,0,0,216,105,0,0,243,252,0,0,40,8,0,0,0,0,0,0,216,105,0,0,9,253,0,0,40,8,0,0,0,0,0,0,216,105,0,0,30,253,0,0,96,8,0,0,0,0,0,0,216,105,0,0,61,253,0,0,176,3,0,0,0,0,0,0,176,105,0,0,86,253,0,0,216,105,0,0,106,253,0,0,112,8,0,0,0,0,0,0,216,105,0,0,235,253,0,0,112,8,0,0,0,0,0,0,216,105,0,0,89,254,0,0,16,13,0,0,0,0,0,0,216,105,0,0,113,254,0,0,112,8,0,0,0,0,0,0,176,105,0,0,139,254,0,0,176,105,0,0,186,254,0,0,0,106,0,0,19,0,1,0,0,0,0,0,2,0,0,0,248,11,0,0,2,0,0,0,0,12,0,0,2,4,0,0,216,105,0,0,39,0,1,0,176,10,0,0,0,0,0,0,216,105,0,0,65,0,1,0,8,9,0,0,0,0,0,0,176,105,0,0,91,0,1,0,216,105,0,0,118,0,1,0,32,9,0,0,0,0,0,0,216,105,0,0,142,0,1,0,8,9,0,0,0,0,0,0,216,105,0,0,168,0,1,0,32,9,0,0,0,0,0,0,216,105,0,0,190,0,1,0,24,3,0,0,0,0,0,0,216,105,0,0,91,1,1,0,224,12,0,0,0,0,0,0,216,105,0,0,12,2,1,0,224,12,0,0,0,0,0,0,216,105,0,0,187,2,1,0,200,3,0,0,0,0,0,0,216,105,0,0,64,3,1,0,40,8,0,0,0,0,0,0,216,105,0,0,190,3,1,0,208,12,0,0,0,0,0,0,216,105,0,0,83,4,1,0,208,12,0,0,0,0,0,0,176,105,0,0,230,4,1,0,216,105,0,0,3,5,1,0,200,9,0,0,0,0,0,0,176,105,0,0,37,5,1,0,216,105,0,0,64,5,1,0,224,9,0,0,0,0,0,0,176,105,0,0,112,5,1,0,216,105,0,0,145,5,1,0,224,9,0,0,0,0,0,0,216,105,0,0,188,5,1,0,224,9,0,0,0,0,0,0,216,105,0,0,239,5,1,0,224,9,0,0,0,0,0,0,216,105,0,0,32,6,1,0,224,9,0,0,0,0,0,0,216,105,0,0,65,6,1,0,224,9,0,0,0,0,0,0,216,105,0,0,117,6,1,0,224,9,0,0,0,0,0,0,216,105,0,0,170,6,1,0,224,9,0,0,0,0,0,0,216,105,0,0,215,6,1,0,224,9,0,0,0,0,0,0,216,105,0,0,16,7,1,0,224,9,0,0,0,0,0,0,216,105,0,0,66,7,1,0,136,10,0,0,0,0,0,0,176,105,0,0,85,7,1,0,216,105,0,0,108,7,1,0,184,8,0,0,0,0,0,0,216,105,0,0,124,7,1,0,144,10,0,0,0,0,0,0,216,105,0,0,151,7,1,0,192,10,0,0,0,0,0,0,176,105,0,0,170,7,1,0,176,105,0,0,218,7,1,0,216,105,0,0,33,8,1,0,32,13,0,0,0,0,0,0,216,105,0,0,68,8,1,0,32,13,0,0,0,0,0,0,216,105,0,0,105,8,1,0,0,11,0,0,0,0,0,0,176,105,0,0,130,8,1,0,216,105,0,0,169,8,1,0,216,11,0,0,0,0,0,0,216,105,0,0,212,8,1,0,24,12,0,0,0,0,0,0,216,105,0,0,21,9,1,0,56,11,0,0,0,0,0,0,176,105,0,0,131,9,1,0,216,105,0,0,155,9,1,0,56,11,0,0,0,0,0,0,216,105,0,0,12,10,1,0,56,11,0,0,0,0,0,0,216,105,0,0,116,10,1,0,120,11,0,0,0,0,0,0,176,105,0,0,165,10,1,0,216,105,0,0,205,10,1,0,136,11,0,0,0,0,0,0,216,105,0,0,229,10,1,0,112,11,0,0,0,0,0,0,216,105,0,0,245,10,1,0,40,14,0,0,0,0,0,0,216,105,0,0,29,11,1,0,24,13,0,0,0,0,0,0,216,105,0,0,46,11,1,0,0,12,0,0,0,0,0,0,216,105,0,0,137,11,1,0,0,12,0,0,0,0,0,0,216,105,0,0,237,11,1,0,120,11,0,0,0,0,0,0,216,105,0,0,7,12,1,0,120,11,0,0,0,0,0,0,176,105,0,0,30,12,1,0,176,105,0,0,51,12,1,0,216,105,0,0,85,12,1,0,64,14,0,0,0,0,0,0,216,105,0,0,114,12,1,0,40,14,0,0,0,0,0,0,216,105,0,0,149,12,1,0,248,11,0,0,0,0,0,0,216,105,0,0,173,12,1,0,0,12,0,0,0,0,0,0,216,105,0,0,19,13,1,0,104,12,0,0,0,0,0,0,216,105,0,0,49,13,1,0,192,10,0,0,0,0,0,0,176,105,0,0,68,13,1,0,216,105,0,0,83,13,1,0,104,12,0,0,0,0,0,0,216,105,0,0,101,13,1,0,144,12,0,0,0,0,0,0,176,105,0,0,134,13,1,0,216,105,0,0,167,13,1,0,0,11,0,0,0,0,0,0,216,105,0,0,187,13,1,0,144,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,105,0,0,223,13,1,0,192,10,0,0,0,0,0,0,216,105,0,0,139,14,1,0,248,11,0,0,0,0,0,0,216,105,0,0,167,14,1,0,248,11,0,0,0,0,0,0,216,105,0,0,207,14,1,0,216,11,0,0,0,0,0,0,216,105,0,0,225,14,1,0,104,12,0,0,0,0,0,0,176,105,0,0,250,14,1,0,176,105,0,0,9,15,1,0,216,105,0,0,117,15,1,0,136,10,0,0,0,0,0,0,216,105,0,0,150,15,1,0,32,13,0,0,0,0,0,0,216,105,0,0,179,15,1,0,0,11,0,0,0,0,0,0,216,105,0,0,198,15,1,0,32,13,0,0,0,0,0,0,216,105,0,0,229,15,1,0,40,8,0,0,0,0,0,0,216,105,0,0,254,15,1,0,32,13,0,0,0,0,0,0,216,105,0,0,37,16,1,0,40,8,0,0,0,0,0,0,216,105,0,0,70,16,1,0,32,13,0,0,0,0,0,0,216,105,0,0,106,16,1,0,248,11,0,0,0,0,0,0,216,105,0,0,133,16,1,0,248,11,0,0,0,0,0,0,216,105,0,0,36,17,1,0,224,9,0,0,0,0,0,0,216,105,0,0,76,17,1,0,32,13,0,0,0,0,0,0,216,105,0,0,102,17,1,0,176,10,0,0,0,0,0,0,216,105,0,0,129,17,1,0,192,10,0,0,0,0,0,0,216,105,0,0,14,18,1,0,192,10,0,0,0,0,0,0,216,105,0,0,147,18,1,0,136,10,0,0,0,0,0,0,176,105,0,0,181,18,1,0,216,105,0,0,207,18,1,0,112,11,0,0,0,0,0,0,176,105,0,0,224,18,1,0,176,105,0,0,245,18,1,0,216,105,0,0,168,19,1,0,88,14,0,0,0,0,0,0,176,105,0,0,181,19,1,0,216,105,0,0,194,19,1,0,88,14,0,0,0,0,0,0,216,105,0,0,210,19,1,0,96,14,0,0,0,0,0,0,176,105,0,0,227,19,1,0,216,105,0,0,240,19,1,0,128,14,0,0,0,0,0,0,216,105,0,0,17,20,1,0,136,14,0,0,0,0,0,0,216,105,0,0,87,20,1,0,136,14,0,0,0,0,0,0,216,105,0,0,51,20,1,0,168,14,0,0,0,0,0,0,216,105,0,0,121,20,1,0,136,14,0,0,0,0,0,0,216,105,0,0,154,20,1,0,152,14,0,0,0,0,0,0,216,105,0,0,191,20,1,0,152,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([104,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,120,0,0,0,6,0,0,0,7,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,1,0,0,8,0,0,0,9,0,0,0,0,0,0,0,40,1,0,0,10,0,0,0,11,0,0,0,0,0,0,0,56,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,12,0,0,0,13,0,0,0,0,0,0,0,64,1,0,0,14,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,1,0,0,16,0,0,0,17,0,0,0,5,0,0,0,248,255,255,255,80,1,0,0,18,0,0,0,19,0,0,0,6,0,0,0,0,0,0,0,120,1,0,0,20,0,0,0,21,0,0,0,0,0,0,0,136,1,0,0,22,0,0,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,1,0,0,24,0,0,0,25,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,26,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,1,0,0,27,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,1,0,0,29,0,0,0,30,0,0,0,3,0,0,0,7,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,232,1,0,0,31,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,1,0,0,1,0,0,0,8,0,0,0,2,0,0,0,33,0,0,0,34,0,0,0,8,0,0,0,35,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,36,0,0,0,10,0,0,0,11,0,0,0,2,0,0,0,244,255,255,255,240,1,0,0,9,0,0,0,10,0,0,0,37,0,0,0,38,0,0,0,104,255,255,255,240,1,0,0,39,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,41,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,2,0,0,43,0,0,0,44,0,0,0,0,0,0,0,40,2,0,0,3,0,0,0,11,0,0,0,3,0,0,0,45,0,0,0,46,0,0,0,244,255,255,255,40,2,0,0,47,0,0,0,48,0,0,0,0,0,0,0,136,0,0,0,6,0,0,0,49,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,80,2,0,0,50,0,0,0,51,0,0,0,0,0,0,0,96,2,0,0,52,0,0,0,53,0,0,0,12,0,0,0,0,0,0,0,112,2,0,0,54,0,0,0,55,0,0,0,0,0,0,0,128,2,0,0,1,0,0,0,8,0,0,0,2,0,0,0,56,0,0,0,57,0,0,0,8,0,0,0,58,0,0,0,12,0,0,0,2,0,0,0,3,0,0,0,36,0,0,0,13,0,0,0,11,0,0,0,4,0,0,0,244,255,255,255,128,2,0,0,9,0,0,0,10,0,0,0,59,0,0,0,60,0,0,0,104,255,255,255,128,2,0,0,61,0,0,0,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,2,0,0,63,0,0,0,64,0,0,0,0,0,0,0,208,2,0,0,65,0,0,0,66,0,0,0,14,0,0,0,15,0,0,0,13,0,0,0,232,255,255,255,208,2,0,0,67,0,0,0,68,0,0,0,14,0,0,0,0,0,0,0,224,2,0,0,69,0,0,0,70,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,248,2,0,0,71,0,0,0,72,0,0,0,5,0,0,0,1,0,0,0,0,0,0,0,32,3,0,0,73,0,0,0,74,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,40,3,0,0,75,0,0,0,76,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,3,0,0,77,0,0,0,78,0,0,0,0,0,0,0,120,3,0,0,9,0,0,0,10,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,136,3,0,0,81,0,0,0,82,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,0,0,15,0,0,0,8,0,0,0,16,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,0,0,0,0,104,3,0,0,83,0,0,0,84,0,0,0,6,0,0,0,1,0,0,0,0,0,0,0,160,3,0,0,85,0,0,0,86,0,0,0,3,0,0,0,3,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,3,0,0,87,0,0,0,88,0,0,0,17,0,0,0,18,0,0,0,13,0,0,0,232,255,255,255,208,3,0,0,89,0,0,0,90,0,0,0,14,0,0,0,0,0,0,0,240,3,0,0,91,0,0,0,92,0,0,0,19,0,0,0,20,0,0,0,17,0,0,0,232,255,255,255,240,3,0,0,93,0,0,0,94,0,0,0,18,0,0,0,0,0,0,0,16,4,0,0,95,0,0,0,96,0,0,0,21,0,0,0,22,0,0,0,0,0,0,0,32,4,0,0,97,0,0,0,98,0,0,0,4,0,0,0,0,0,0,0,48,4,0,0,99,0,0,0,100,0,0,0,7,0,0,0,2,0,0,0,0,0,0,0,72,4,0,0,101,0,0,0,102,0,0,0,23,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,4,0,0,6,0,0,0,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,4,0,0,104,0,0,0,105,0,0,0,0,0,0,0,128,4,0,0,106,0,0,0,107,0,0,0,0,0,0,0,200,4,0,0,6,0,0,0,108,0,0,0,9,0,0,0,0,0,0,0,184,4,0,0,6,0,0,0,109,0,0,0,10,0,0,0,0,0,0,0,168,4,0,0,6,0,0,0,110,0,0,0,11,0,0,0,0,0,0,0,152,4,0,0,6,0,0,0,111,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,4,0,0,112,0,0,0,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,4,0,0,9,0,0,0,10,0,0,0,114,0,0,0,115,0,0,0,0,0,0,0,240,4,0,0,116,0,0,0,117,0,0,0,0,0,0,0,0,0,0,0,248,4,0,0,6,0,0,0,118,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,5,0,0,119,0,0,0,120,0,0,0,0,0,0,0,24,5,0,0,121,0,0,0,122,0,0,0,0,0,0,0,40,5,0,0,123,0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,5,0,0,1,0,0,0,8,0,0,0,2,0,0,0,125,0,0,0,126,0,0,0,25,0,0,0,127,0,0,0,244,255,255,255,56,5,0,0,9,0,0,0,10,0,0,0,128,0,0,0,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,5,0,0,130,0,0,0,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,5,0,0,132,0,0,0,133,0,0,0,19,0,0,0,0,0,0,0,192,5,0,0,134,0,0,0,135,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,27,0,0,0,20,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,3,0,0,0,5,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,2,0,0,0,25,0,0,0,28,0,0,0,248,255,255,255,192,5,0,0,9,0,0,0,26,0,0,0,5,0,0,0,136,0,0,0,137,0,0,0,236,255,255,255,192,5,0,0,9,0,0,0,10,0,0,0,138,0,0,0,139,0,0,0,0,0,0,0,208,5,0,0,140,0,0,0,141,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,29,0,0,0,30,0,0,0,27,0,0,0,18,0,0,0,10,0,0,0,28,0,0,0,6,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,29,0,0,0,23,0,0,0,24,0,0,0,20,0,0,0,3,0,0,0,30,0,0,0,31,0,0,0,31,0,0,0,248,255,255,255,208,5,0,0,11,0,0,0,32,0,0,0,7,0,0,0,142,0,0,0,143,0,0,0,236,255,255,255,208,5,0,0,9,0,0,0,10,0,0,0,144,0,0,0,145,0,0,0,24,255,255,255,208,5,0,0,33,0,0,0,0,0,0,0,240,5,0,0,146,0,0,0,147,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,32,0,0,0,27,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,6,0,0,0,6,0,0,0,3,0,0,0,7,0,0,0,34,0,0,0,23,0,0,0,24,0,0,0,20,0,0,0,2,0,0,0,30,0,0,0,28,0,0,0,248,255,255,255,240,5,0,0,9,0,0,0,26,0,0,0,5,0,0,0,148,0,0,0,149,0,0,0,236,255,255,255,240,5,0,0,9,0,0,0,10,0,0,0,150,0,0,0,151,0,0,0,0,0,0,0,24,6,0,0,152,0,0,0,153,0,0,0,33,0,0,0,35,0,0,0,36,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,40,6,0,0,154,0,0,0,155,0,0,0,2,0,0,0,5,0,0,0,6,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,17,0,0,0,29,0,0,0,34,0,0,0,27,0,0,0,18,0,0,0,10,0,0,0,28,0,0,0,6,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,29,0,0,0,23,0,0,0,24,0,0,0,20,0,0,0,3,0,0,0,30,0,0,0,31,0,0,0,31,0,0,0,248,255,255,255,40,6,0,0,11,0,0,0,32,0,0,0,7,0,0,0,156,0,0,0,157,0,0,0,236,255,255,255,40,6,0,0,9,0,0,0,10,0,0,0,158,0,0,0,159,0,0,0,24,255,255,255,40,6,0,0,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,6,0,0,160,0,0,0,161,0,0,0,0,0,0,0,72,6,0,0,162,0,0,0,163,0,0,0,0,0,0,0,88,6,0,0,164,0,0,0,165,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,35,0,0,0,20,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,3,0,0,0,5,0,0,0,22,0,0,0,23,0,0,0,37,0,0,0,19,0,0,0,2,0,0,0,38,0,0,0,28,0,0,0,248,255,255,255,88,6,0,0,9,0,0,0,26,0,0,0,5,0,0,0,166,0,0,0,167,0,0,0,236,255,255,255,88,6,0,0,9,0,0,0,10,0,0,0,168,0,0,0,169,0,0,0,0,0,0,0,104,6,0,0,170,0,0,0,171,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,36,0,0,0,39,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,8,0,0,0,6,0,0,0,3,0,0,0,7,0,0,0,34,0,0,0,23,0,0,0,40,0,0,0,20,0,0,0,2,0,0,0,41,0,0,0,28,0,0,0,248,255,255,255,104,6,0,0,9,0,0,0,26,0,0,0,5,0,0,0,172,0,0,0,173,0,0,0,236,255,255,255,104,6,0,0,9,0,0,0,10,0,0,0,174,0,0,0,175,0,0,0,0,0,0,0,120,6,0,0,176,0,0,0,177,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,37,0,0,0,20,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,6,0,0,0,6,0,0,0,3,0,0,0,7,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,2,0,0,0,25,0,0,0,28,0,0,0,248,255,255,255,120,6,0,0,9,0,0,0,26,0,0,0,5,0,0,0,178,0,0,0,179,0,0,0,236,255,255,255,120,6,0,0,9,0,0,0,10,0,0,0,180,0,0,0,181,0,0,0,0,0,0,0,152,6,0,0,182,0,0,0,183,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,38,0,0,0,42,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,9,0,0,0,7,0,0,0,3,0,0,0,8,0,0,0,43,0,0,0,23,0,0,0,44,0,0,0,19,0,0,0,2,0,0,0,25,0,0,0,28,0,0,0,248,255,255,255,152,6,0,0,9,0,0,0,26,0,0,0,5,0,0,0,184,0,0,0,185,0,0,0,236,255,255,255,152,6,0,0,9,0,0,0,10,0,0,0,186,0,0,0,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,6,0,0,188,0,0,0,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,6,0,0,190,0,0,0,191,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,39,0,0,0,45,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,10,0,0,0,8,0,0,0,11,0,0,0,9,0,0,0,46,0,0,0,23,0,0,0,47,0,0,0,24,0,0,0,4,0,0,0,25,0,0,0,28,0,0,0,248,255,255,255,184,6,0,0,9,0,0,0,26,0,0,0,5,0,0,0,192,0,0,0,193,0,0,0,236,255,255,255,184,6,0,0,9,0,0,0,10,0,0,0,194,0,0,0,195,0,0,0,0,0,0,0,200,6,0,0,196,0,0,0,197,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,40,0,0,0,48,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,12,0,0,0,9,0,0,0,3,0,0,0,7,0,0,0,49,0,0,0,23,0,0,0,50,0,0,0,19,0,0,0,2,0,0,0,25,0,0,0,28,0,0,0,248,255,255,255,200,6,0,0,9,0,0,0,26,0,0,0,5,0,0,0,198,0,0,0,199,0,0,0,236,255,255,255,200,6,0,0,9,0,0,0,10,0,0,0,200,0,0,0,201,0,0,0,0,0,0,0,216,6,0,0,202,0,0,0,203,0,0,0,0,0,0,0,232,6,0,0,204,0,0,0,205,0,0,0,0,0,0,0,248,6,0,0,206,0,0,0,207,0,0,0,0,0,0,0,8,7,0,0,208,0,0,0,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,7,0,0,210,0,0,0,211,0,0,0,12,0,0,0,51,0,0,0,8,0,0,0,248,255,255,255,40,7,0,0,13,0,0,0,52,0,0,0,9,0,0,0,212,0,0,0,213,0,0,0,0,0,0,0,72,7,0,0,214,0,0,0,215,0,0,0,41,0,0,0,53,0,0,0,36,0,0,0,7,0,0,0,0,250,0,0,232,128,0,0,48,117,0,0,96,234,0,0,152,58,0,0,112,23,0,0,38,122,0,0,132,128,0,0,23,161,0,0,16,83,0,0,141,7,0,0,174,139,0,0,93,23,1,0,143,46,0,0,128,70,0,0,51,28,0,0,77,115,1,0,246,217,63,10,185,114,135,59,232,11,0,0,222,61,248,41,174,85,242,175,228,250,66,120,13,57,131,202,1,0,0,0,225,229,9,73,33,187,126,66,236,11,0,0,55,214,91,201,59,138,93,233,153,143,243,13,137,3,50,193,1,0,1,0,161,68,33,253,174,216,111,48,60,238,0,0,120,51,102,252,107,136,226,55,131,233,114,253,184,241,40,130,1,0,0,0,210,53,156,32,18,120,239,187,32,238,0,0,191,42,86,52,6,205,76,153,33,87,44,109,93,140,214,208,1,0,0,0,98,215,84,160,206,41,81,93,208,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,251,243,132,247,82,165,46,24,72,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,252,243,152,3,109,82,158,242,72,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,240,240,240,240,204,204,204,204,170,170,170,170,0,255,0,255,240,240,240,240,204,204,204,204,0,0,255,255,0,255,0,255,240,240,240,240,15,15,15,15,51,51,51,51,85,85,85,85,0,255,0,255,15,15,15,15,51,51,51,51,0,0,255,255,0,255,0,255,15,15,15,15,1,1,1,1,16,16,16,16,17,17,17,17,68,68,68,68,85,85,85,85,170,170,170,170,3,0,3,0,0,3,0,3,3,3,3,3,48,48,48,48,51,51,51,51,204,204,204,204,15,0,0,0,0,0,15,0,15,0,15,0,0,15,0,15,15,15,15,15,240,240,240,240,128,128,128,128,8,8,8,8,136,136,136,136,34,34,34,34,170,170,170,170,85,85,85,85,192,0,192,0,0,192,0,192,192,192,192,192,12,12,12,12,204,204,204,204,51,51,51,51,240,0,0,0,0,0,240,0,240,0,240,0,0,240,0,240,240,240,240,240,15,15,15,15,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,150,48,7,119,44,97,14,238,186,81,9,153,25,196,109,7,143,244,106,112,53,165,99,233,163,149,100,158,50,136,219,14,164,184,220,121,30,233,213,224,136,217,210,151,43,76,182,9,189,124,177,126,7,45,184,231,145,29,191,144,100,16,183,29,242,32,176,106,72,113,185,243,222,65,190,132,125,212,218,26,235,228,221,109,81,181,212,244,199,133,211,131,86,152,108,19,192,168,107,100,122,249,98,253,236,201,101,138,79,92,1,20,217,108,6,99,99,61,15,250,245,13,8,141,200,32,110,59,94,16,105,76,228,65,96,213,114,113,103,162,209,228,3,60,71,212,4,75,253,133,13,210,107,181,10,165,250,168,181,53,108,152,178,66,214,201,187,219,64,249,188,172,227,108,216,50,117,92,223,69,207,13,214,220,89,61,209,171,172,48,217,38,58,0,222,81,128,81,215,200,22,97,208,191,181,244,180,33,35,196,179,86,153,149,186,207,15,165,189,184,158,184,2,40,8,136,5,95,178,217,12,198,36,233,11,177,135,124,111,47,17,76,104,88,171,29,97,193,61,45,102,182,144,65,220,118,6,113,219,1,188,32,210,152,42,16,213,239,137,133,177,113,31,181,182,6,165,228,191,159,51,212,184,232,162,201,7,120,52,249,0,15,142,168,9,150,24,152,14,225,187,13,106,127,45,61,109,8,151,108,100,145,1,92,99,230,244,81,107,107,98,97,108,28,216,48,101,133,78,0,98,242,237,149,6,108,123,165,1,27,193,244,8,130,87,196,15,245,198,217,176,101,80,233,183,18,234,184,190,139,124,136,185,252,223,29,221,98,73,45,218,21,243,124,211,140,101,76,212,251,88,97,178,77,206,81,181,58,116,0,188,163,226,48,187,212,65,165,223,74,215,149,216,61,109,196,209,164,251,244,214,211,106,233,105,67,252,217,110,52,70,136,103,173,208,184,96,218,115,45,4,68,229,29,3,51,95,76,10,170,201,124,13,221,60,113,5,80,170,65,2,39,16,16,11,190,134,32,12,201,37,181,104,87,179,133,111,32,9,212,102,185,159,228,97,206,14,249,222,94,152,201,217,41,34,152,208,176,180,168,215,199,23,61,179,89,129,13,180,46,59,92,189,183,173,108,186,192,32,131,184,237,182,179,191,154,12,226,182,3,154,210,177,116,57,71,213,234,175,119,210,157,21,38,219,4,131,22,220,115,18,11,99,227,132,59,100,148,62,106,109,13,168,90,106,122,11,207,14,228,157,255,9,147,39,174,0,10,177,158,7,125,68,147,15,240,210,163,8,135,104,242,1,30,254,194,6,105,93,87,98,247,203,103,101,128,113,54,108,25,231,6,107,110,118,27,212,254,224,43,211,137,90,122,218,16,204,74,221,103,111,223,185,249,249,239,190,142,67,190,183,23,213,142,176,96,232,163,214,214,126,147,209,161,196,194,216,56,82,242,223,79,241,103,187,209,103,87,188,166,221,6,181,63,75,54,178,72,218,43,13,216,76,27,10,175,246,74,3,54,96,122,4,65,195,239,96,223,85,223,103,168,239,142,110,49,121,190,105,70,140,179,97,203,26,131,102,188,160,210,111,37,54,226,104,82,149,119,12,204,3,71,11,187,185,22,2,34,47,38,5,85,190,59,186,197,40,11,189,178,146,90,180,43,4,106,179,92,167,255,215,194,49,207,208,181,139,158,217,44,29,174,222,91,176,194,100,155,38,242,99,236,156,163,106,117,10,147,109,2,169,6,9,156,63,54,14,235,133,103,7,114,19,87,0,5,130,74,191,149,20,122,184,226,174,43,177,123,56,27,182,12,155,142,210,146,13,190,213,229,183,239,220,124,33,223,219,11,212,210,211,134,66,226,212,241,248,179,221,104,110,131,218,31,205,22,190,129,91,38,185,246,225,119,176,111,119,71,183,24,230,90,8,136,112,106,15,255,202,59,6,102,92,11,1,17,255,158,101,143,105,174,98,248,211,255,107,97,69,207,108,22,120,226,10,160,238,210,13,215,84,131,4,78,194,179,3,57,97,38,103,167,247,22,96,208,77,71,105,73,219,119,110,62,74,106,209,174,220,90,214,217,102,11,223,64,240,59,216,55,83,174,188,169,197,158,187,222,127,207,178,71,233,255,181,48,28,242,189,189,138,194,186,202,48,147,179,83,166,163,180,36,5,54,208,186,147,6,215,205,41,87,222,84,191,103,217,35,46,122,102,179,184,74,97,196,2,27,104,93,148,43,111,42,55,190,11,180,161,142,12,195,27,223,5,90,141,239,2,45,0,0,0,0,65,49,27,25,130,98,54,50,195,83,45,43,4,197,108,100,69,244,119,125,134,167,90,86,199,150,65,79,8,138,217,200,73,187,194,209,138,232,239,250,203,217,244,227,12,79,181,172,77,126,174,181,142,45,131,158,207,28,152,135,81,18,194,74,16,35,217,83,211,112,244,120,146,65,239,97,85,215,174,46,20,230,181,55,215,181,152,28,150,132,131,5,89,152,27,130,24,169,0,155,219,250,45,176,154,203,54,169,93,93,119,230,28,108,108,255,223,63,65,212,158,14,90,205,162,36,132,149,227,21,159,140,32,70,178,167,97,119,169,190,166,225,232,241,231,208,243,232,36,131,222,195,101,178,197,218,170,174,93,93,235,159,70,68,40,204,107,111,105,253,112,118,174,107,49,57,239,90,42,32,44,9,7,11,109,56,28,18,243,54,70,223,178,7,93,198,113,84,112,237,48,101,107,244,247,243,42,187,182,194,49,162,117,145,28,137,52,160,7,144,251,188,159,23,186,141,132,14,121,222,169,37,56,239,178,60,255,121,243,115,190,72,232,106,125,27,197,65,60,42,222,88,5,79,121,240,68,126,98,233,135,45,79,194,198,28,84,219,1,138,21,148,64,187,14,141,131,232,35,166,194,217,56,191,13,197,160,56,76,244,187,33,143,167,150,10,206,150,141,19,9,0,204,92,72,49,215,69,139,98,250,110,202,83,225,119,84,93,187,186,21,108,160,163,214,63,141,136,151,14,150,145,80,152,215,222,17,169,204,199,210,250,225,236,147,203,250,245,92,215,98,114,29,230,121,107,222,181,84,64,159,132,79,89,88,18,14,22,25,35,21,15,218,112,56,36,155,65,35,61,167,107,253,101,230,90,230,124,37,9,203,87,100,56,208,78,163,174,145,1,226,159,138,24,33,204,167,51,96,253,188,42,175,225,36,173,238,208,63,180,45,131,18,159,108,178,9,134,171,36,72,201,234,21,83,208,41,70,126,251,104,119,101,226,246,121,63,47,183,72,36,54,116,27,9,29,53,42,18,4,242,188,83,75,179,141,72,82,112,222,101,121,49,239,126,96,254,243,230,231,191,194,253,254,124,145,208,213,61,160,203,204,250,54,138,131,187,7,145,154,120,84,188,177,57,101,167,168,75,152,131,59,10,169,152,34,201,250,181,9,136,203,174,16,79,93,239,95,14,108,244,70,205,63,217,109,140,14,194,116,67,18,90,243,2,35,65,234,193,112,108,193,128,65,119,216,71,215,54,151,6,230,45,142,197,181,0,165,132,132,27,188,26,138,65,113,91,187,90,104,152,232,119,67,217,217,108,90,30,79,45,21,95,126,54,12,156,45,27,39,221,28,0,62,18,0,152,185,83,49,131,160,144,98,174,139,209,83,181,146,22,197,244,221,87,244,239,196,148,167,194,239,213,150,217,246,233,188,7,174,168,141,28,183,107,222,49,156,42,239,42,133,237,121,107,202,172,72,112,211,111,27,93,248,46,42,70,225,225,54,222,102,160,7,197,127,99,84,232,84,34,101,243,77,229,243,178,2,164,194,169,27,103,145,132,48,38,160,159,41,184,174,197,228,249,159,222,253,58,204,243,214,123,253,232,207,188,107,169,128,253,90,178,153,62,9,159,178,127,56,132,171,176,36,28,44,241,21,7,53,50,70,42,30,115,119,49,7,180,225,112,72,245,208,107,81,54,131,70,122,119,178,93,99,78,215,250,203,15,230,225,210,204,181,204,249,141,132,215,224,74,18,150,175,11,35,141,182,200,112,160,157,137,65,187,132,70,93,35,3,7,108,56,26,196,63,21,49,133,14,14,40,66,152,79,103,3,169,84,126,192,250,121,85,129,203,98,76,31,197,56,129,94,244,35,152,157,167,14,179,220,150,21,170,27,0,84,229,90,49,79,252,153,98,98,215,216,83,121,206,23,79,225,73,86,126,250,80,149,45,215,123,212,28,204,98,19,138,141,45,82,187,150,52,145,232,187,31,208,217,160,6,236,243,126,94,173,194,101,71,110,145,72,108,47,160,83,117,232,54,18,58,169,7,9,35,106,84,36,8,43,101,63,17,228,121,167,150,165,72,188,143,102,27,145,164,39,42,138,189,224,188,203,242,161,141,208,235,98,222,253,192,35,239,230,217,189,225,188,20,252,208,167,13,63,131,138,38,126,178,145,63,185,36,208,112,248,21,203,105,59,70,230,66,122,119,253,91,181,107,101,220,244,90,126,197,55,9,83,238,118,56,72,247,177,174,9,184,240,159,18,161,51,204,63,138,114,253,36,147,0,0,0,0,55,106,194,1,110,212,132,3,89,190,70,2,220,168,9,7,235,194,203,6,178,124,141,4,133,22,79,5,184,81,19,14,143,59,209,15,214,133,151,13,225,239,85,12,100,249,26,9,83,147,216,8,10,45,158,10,61,71,92,11,112,163,38,28,71,201,228,29,30,119,162,31,41,29,96,30,172,11,47,27,155,97,237,26,194,223,171,24,245,181,105,25,200,242,53,18,255,152,247,19,166,38,177,17,145,76,115,16,20,90,60,21,35,48,254,20,122,142,184,22,77,228,122,23,224,70,77,56,215,44,143,57,142,146,201,59,185,248,11,58,60,238,68,63,11,132,134,62,82,58,192,60,101,80,2,61,88,23,94,54,111,125,156,55,54,195,218,53,1,169,24,52,132,191,87,49,179,213,149,48,234,107,211,50,221,1,17,51,144,229,107,36,167,143,169,37,254,49,239,39,201,91,45,38,76,77,98,35,123,39,160,34,34,153,230,32,21,243,36,33,40,180,120,42,31,222,186,43,70,96,252,41,113,10,62,40,244,28,113,45,195,118,179,44,154,200,245,46,173,162,55,47,192,141,154,112,247,231,88,113,174,89,30,115,153,51,220,114,28,37,147,119,43,79,81,118,114,241,23,116,69,155,213,117,120,220,137,126,79,182,75,127,22,8,13,125,33,98,207,124,164,116,128,121,147,30,66,120,202,160,4,122,253,202,198,123,176,46,188,108,135,68,126,109,222,250,56,111,233,144,250,110,108,134,181,107,91,236,119,106,2,82,49,104,53,56,243,105,8,127,175,98,63,21,109,99,102,171,43,97,81,193,233,96,212,215,166,101,227,189,100,100,186,3,34,102,141,105,224,103,32,203,215,72,23,161,21,73,78,31,83,75,121,117,145,74,252,99,222,79,203,9,28,78,146,183,90,76,165,221,152,77,152,154,196,70,175,240,6,71,246,78,64,69,193,36,130,68,68,50,205,65,115,88,15,64,42,230,73,66,29,140,139,67,80,104,241,84,103,2,51,85,62,188,117,87,9,214,183,86,140,192,248,83,187,170,58,82,226,20,124,80,213,126,190,81,232,57,226,90,223,83,32,91,134,237,102,89,177,135,164,88,52,145,235,93,3,251,41,92,90,69,111,94,109,47,173,95,128,27,53,225,183,113,247,224,238,207,177,226,217,165,115,227,92,179,60,230,107,217,254,231,50,103,184,229,5,13,122,228,56,74,38,239,15,32,228,238,86,158,162,236,97,244,96,237,228,226,47,232,211,136,237,233,138,54,171,235,189,92,105,234,240,184,19,253,199,210,209,252,158,108,151,254,169,6,85,255,44,16,26,250,27,122,216,251,66,196,158,249,117,174,92,248,72,233,0,243,127,131,194,242,38,61,132,240,17,87,70,241,148,65,9,244,163,43,203,245,250,149,141,247,205,255,79,246,96,93,120,217,87,55,186,216,14,137,252,218,57,227,62,219,188,245,113,222,139,159,179,223,210,33,245,221,229,75,55,220,216,12,107,215,239,102,169,214,182,216,239,212,129,178,45,213,4,164,98,208,51,206,160,209,106,112,230,211,93,26,36,210,16,254,94,197,39,148,156,196,126,42,218,198,73,64,24,199,204,86,87,194,251,60,149,195,162,130,211,193,149,232,17,192,168,175,77,203,159,197,143,202,198,123,201,200,241,17,11,201,116,7,68,204,67,109,134,205,26,211,192,207,45,185,2,206,64,150,175,145,119,252,109,144,46,66,43,146,25,40,233,147,156,62,166,150,171,84,100,151,242,234,34,149,197,128,224,148,248,199,188,159,207,173,126,158,150,19,56,156,161,121,250,157,36,111,181,152,19,5,119,153,74,187,49,155,125,209,243,154,48,53,137,141,7,95,75,140,94,225,13,142,105,139,207,143,236,157,128,138,219,247,66,139,130,73,4,137,181,35,198,136,136,100,154,131,191,14,88,130,230,176,30,128,209,218,220,129,84,204,147,132,99,166,81,133,58,24,23,135,13,114,213,134,160,208,226,169,151,186,32,168,206,4,102,170,249,110,164,171,124,120,235,174,75,18,41,175,18,172,111,173,37,198,173,172,24,129,241,167,47,235,51,166,118,85,117,164,65,63,183,165,196,41,248,160,243,67,58,161,170,253,124,163,157,151,190,162,208,115,196,181,231,25,6,180,190,167,64,182,137,205,130,183,12,219,205,178,59,177,15,179,98,15,73,177,85,101,139,176,104,34,215,187,95,72,21,186,6,246,83,184,49,156,145,185,180,138,222,188,131,224,28,189,218,94,90,191,237,52,152,190,0,0,0,0,101,103,188,184,139,200,9,170,238,175,181,18,87,151,98,143,50,240,222,55,220,95,107,37,185,56,215,157,239,40,180,197,138,79,8,125,100,224,189,111,1,135,1,215,184,191,214,74,221,216,106,242,51,119,223,224,86,16,99,88,159,87,25,80,250,48,165,232,20,159,16,250,113,248,172,66,200,192,123,223,173,167,199,103,67,8,114,117,38,111,206,205,112,127,173,149,21,24,17,45,251,183,164,63,158,208,24,135,39,232,207,26,66,143,115,162,172,32,198,176,201,71,122,8,62,175,50,160,91,200,142,24,181,103,59,10,208,0,135,178,105,56,80,47,12,95,236,151,226,240,89,133,135,151,229,61,209,135,134,101,180,224,58,221,90,79,143,207,63,40,51,119,134,16,228,234,227,119,88,82,13,216,237,64,104,191,81,248,161,248,43,240,196,159,151,72,42,48,34,90,79,87,158,226,246,111,73,127,147,8,245,199,125,167,64,213,24,192,252,109,78,208,159,53,43,183,35,141,197,24,150,159,160,127,42,39,25,71,253,186,124,32,65,2,146,143,244,16,247,232,72,168,61,88,20,155,88,63,168,35,182,144,29,49,211,247,161,137,106,207,118,20,15,168,202,172,225,7,127,190,132,96,195,6,210,112,160,94,183,23,28,230,89,184,169,244,60,223,21,76,133,231,194,209,224,128,126,105,14,47,203,123,107,72,119,195,162,15,13,203,199,104,177,115,41,199,4,97,76,160,184,217,245,152,111,68,144,255,211,252,126,80,102,238,27,55,218,86,77,39,185,14,40,64,5,182,198,239,176,164,163,136,12,28,26,176,219,129,127,215,103,57,145,120,210,43,244,31,110,147,3,247,38,59,102,144,154,131,136,63,47,145,237,88,147,41,84,96,68,180,49,7,248,12,223,168,77,30,186,207,241,166,236,223,146,254,137,184,46,70,103,23,155,84,2,112,39,236,187,72,240,113,222,47,76,201,48,128,249,219,85,231,69,99,156,160,63,107,249,199,131,211,23,104,54,193,114,15,138,121,203,55,93,228,174,80,225,92,64,255,84,78,37,152,232,246,115,136,139,174,22,239,55,22,248,64,130,4,157,39,62,188,36,31,233,33,65,120,85,153,175,215,224,139,202,176,92,51,59,182,89,237,94,209,229,85,176,126,80,71,213,25,236,255,108,33,59,98,9,70,135,218,231,233,50,200,130,142,142,112,212,158,237,40,177,249,81,144,95,86,228,130,58,49,88,58,131,9,143,167,230,110,51,31,8,193,134,13,109,166,58,181,164,225,64,189,193,134,252,5,47,41,73,23,74,78,245,175,243,118,34,50,150,17,158,138,120,190,43,152,29,217,151,32,75,201,244,120,46,174,72,192,192,1,253,210,165,102,65,106,28,94,150,247,121,57,42,79,151,150,159,93,242,241,35,229,5,25,107,77,96,126,215,245,142,209,98,231,235,182,222,95,82,142,9,194,55,233,181,122,217,70,0,104,188,33,188,208,234,49,223,136,143,86,99,48,97,249,214,34,4,158,106,154,189,166,189,7,216,193,1,191,54,110,180,173,83,9,8,21,154,78,114,29,255,41,206,165,17,134,123,183,116,225,199,15,205,217,16,146,168,190,172,42,70,17,25,56,35,118,165,128,117,102,198,216,16,1,122,96,254,174,207,114,155,201,115,202,34,241,164,87,71,150,24,239,169,57,173,253,204,94,17,69,6,238,77,118,99,137,241,206,141,38,68,220,232,65,248,100,81,121,47,249,52,30,147,65,218,177,38,83,191,214,154,235,233,198,249,179,140,161,69,11,98,14,240,25,7,105,76,161,190,81,155,60,219,54,39,132,53,153,146,150,80,254,46,46,153,185,84,38,252,222,232,158,18,113,93,140,119,22,225,52,206,46,54,169,171,73,138,17,69,230,63,3,32,129,131,187,118,145,224,227,19,246,92,91,253,89,233,73,152,62,85,241,33,6,130,108,68,97,62,212,170,206,139,198,207,169,55,126,56,65,127,214,93,38,195,110,179,137,118,124,214,238,202,196,111,214,29,89,10,177,161,225,228,30,20,243,129,121,168,75,215,105,203,19,178,14,119,171,92,161,194,185,57,198,126,1,128,254,169,156,229,153,21,36,11,54,160,54,110,81,28,142,167,22,102,134,194,113,218,62,44,222,111,44,73,185,211,148,240,129,4,9,149,230,184,177,123,73,13,163,30,46,177,27,72,62,210,67,45,89,110,251,195,246,219,233,166,145,103,81,31,169,176,204,122,206,12,116,148,97,185,102,241,6,5,222,0,0,0,0,119,7,48,150,238,14,97,44,153,9,81,186,7,109,196,25,112,106,244,143,233,99,165,53,158,100,149,163,14,219,136,50,121,220,184,164,224,213,233,30,151,210,217,136,9,182,76,43,126,177,124,189,231,184,45,7,144,191,29,145,29,183,16,100,106,176,32,242,243,185,113,72,132,190,65,222,26,218,212,125,109,221,228,235,244,212,181,81,131,211,133,199,19,108,152,86,100,107,168,192,253,98,249,122,138,101,201,236,20,1,92,79,99,6,108,217,250,15,61,99,141,8,13,245,59,110,32,200,76,105,16,94,213,96,65,228,162,103,113,114,60,3,228,209,75,4,212,71,210,13,133,253,165,10,181,107,53,181,168,250,66,178,152,108,219,187,201,214,172,188,249,64,50,216,108,227,69,223,92,117,220,214,13,207,171,209,61,89,38,217,48,172,81,222,0,58,200,215,81,128,191,208,97,22,33,180,244,181,86,179,196,35,207,186,149,153,184,189,165,15,40,2,184,158,95,5,136,8,198,12,217,178,177,11,233,36,47,111,124,135,88,104,76,17,193,97,29,171,182,102,45,61,118,220,65,144,1,219,113,6,152,210,32,188,239,213,16,42,113,177,133,137,6,182,181,31,159,191,228,165,232,184,212,51,120,7,201,162,15,0,249,52,150,9,168,142,225,14,152,24,127,106,13,187,8,109,61,45,145,100,108,151,230,99,92,1,107,107,81,244,28,108,97,98,133,101,48,216,242,98,0,78,108,6,149,237,27,1,165,123,130,8,244,193,245,15,196,87,101,176,217,198,18,183,233,80,139,190,184,234,252,185,136,124,98,221,29,223,21,218,45,73,140,211,124,243,251,212,76,101,77,178,97,88,58,181,81,206,163,188,0,116,212,187,48,226,74,223,165,65,61,216,149,215,164,209,196,109,211,214,244,251,67,105,233,106,52,110,217,252,173,103,136,70,218,96,184,208,68,4,45,115,51,3,29,229,170,10,76,95,221,13,124,201,80,5,113,60,39,2,65,170,190,11,16,16,201,12,32,134,87,104,181,37,32,111,133,179,185,102,212,9,206,97,228,159,94,222,249,14,41,217,201,152,176,208,152,34,199,215,168,180,89,179,61,23,46,180,13,129,183,189,92,59,192,186,108,173,237,184,131,32,154,191,179,182,3,182,226,12,116,177,210,154,234,213,71,57,157,210,119,175,4,219,38,21,115,220,22,131,227,99,11,18,148,100,59,132,13,109,106,62,122,106,90,168,228,14,207,11,147,9,255,157,10,0,174,39,125,7,158,177,240,15,147,68,135,8,163,210,30,1,242,104,105,6,194,254,247,98,87,93,128,101,103,203,25,108,54,113,110,107,6,231,254,212,27,118],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+7344);allocate([137,211,43,224,16,218,122,90,103,221,74,204,249,185,223,111,142,190,239,249,23,183,190,67,96,176,142,213,214,214,163,232,161,209,147,126,56,216,194,196,79,223,242,82,209,187,103,241,166,188,87,103,63,181,6,221,72,178,54,75,216,13,43,218,175,10,27,76,54,3,74,246,65,4,122,96,223,96,239,195,168,103,223,85,49,110,142,239,70,105,190,121,203,97,179,140,188,102,131,26,37,111,210,160,82,104,226,54,204,12,119,149,187,11,71,3,34,2,22,185,85,5,38,47,197,186,59,190,178,189,11,40,43,180,90,146,92,179,106,4,194,215,255,167,181,208,207,49,44,217,158,139,91,222,174,29,155,100,194,176,236,99,242,38,117,106,163,156,2,109,147,10,156,9,6,169,235,14,54,63,114,7,103,133,5,0,87,19,149,191,74,130,226,184,122,20,123,177,43,174,12,182,27,56,146,210,142,155,229,213,190,13,124,220,239,183,11,219,223,33,134,211,210,212,241,212,226,66,104,221,179,248,31,218,131,110,129,190,22,205,246,185,38,91,111,176,119,225,24,183,71,119,136,8,90,230,255,15,106,112,102,6,59,202,17,1,11,92,143,101,158,255,248,98,174,105,97,107,255,211,22,108,207,69,160,10,226,120,215,13,210,238,78,4,131,84,57,3,179,194,167,103,38,97,208,96,22,247,73,105,71,77,62,110,119,219,174,209,106,74,217,214,90,220,64,223,11,102,55,216,59,240,169,188,174,83,222,187,158,197,71,178,207,127,48,181,255,233,189,189,242,28,202,186,194,138,83,179,147,48,36,180,163,166,186,208,54,5,205,215,6,147,84,222,87,41,35,217,103,191,179,102,122,46,196,97,74,184,93,104,27,2,42,111,43,148,180,11,190,55,195,12,142,161,90,5,223,27,45,2,239,141,0,0,0,0,25,27,49,65,50,54,98,130,43,45,83,195,100,108,197,4,125,119,244,69,86,90,167,134,79,65,150,199,200,217,138,8,209,194,187,73,250,239,232,138,227,244,217,203,172,181,79,12,181,174,126,77,158,131,45,142,135,152,28,207,74,194,18,81,83,217,35,16,120,244,112,211,97,239,65,146,46,174,215,85,55,181,230,20,28,152,181,215,5,131,132,150,130,27,152,89,155,0,169,24,176,45,250,219,169,54,203,154,230,119,93,93,255,108,108,28,212,65,63,223,205,90,14,158,149,132,36,162,140,159,21,227,167,178,70,32,190,169,119,97,241,232,225,166,232,243,208,231,195,222,131,36,218,197,178,101,93,93,174,170,68,70,159,235,111,107,204,40,118,112,253,105,57,49,107,174,32,42,90,239,11,7,9,44,18,28,56,109,223,70,54,243,198,93,7,178,237,112,84,113,244,107,101,48,187,42,243,247,162,49,194,182,137,28,145,117,144,7,160,52,23,159,188,251,14,132,141,186,37,169,222,121,60,178,239,56,115,243,121,255,106,232,72,190,65,197,27,125,88,222,42,60,240,121,79,5,233,98,126,68,194,79,45,135,219,84,28,198,148,21,138,1,141,14,187,64,166,35,232,131,191,56,217,194,56,160,197,13,33,187,244,76,10,150,167,143,19,141,150,206,92,204,0,9,69,215,49,72,110,250,98,139,119,225,83,202,186,187,93,84,163,160,108,21,136,141,63,214,145,150,14,151,222,215,152,80,199,204,169,17,236,225,250,210,245,250,203,147,114,98,215,92,107,121,230,29,64,84,181,222,89,79,132,159,22,14,18,88,15,21,35,25,36,56,112,218,61,35,65,155,101,253,107,167,124,230,90,230,87,203,9,37,78,208,56,100,1,145,174,163,24,138,159,226,51,167,204,33,42,188,253,96,173,36,225,175,180,63,208,238,159,18,131,45,134,9,178,108,201,72,36,171,208,83,21,234,251,126,70,41,226,101,119,104,47,63,121,246,54,36,72,183,29,9,27,116,4,18,42,53,75,83,188,242,82,72,141,179,121,101,222,112,96,126,239,49,231,230,243,254,254,253,194,191,213,208,145,124,204,203,160,61,131,138,54,250,154,145,7,187,177,188,84,120,168,167,101,57,59,131,152,75,34,152,169,10,9,181,250,201,16,174,203,136,95,239,93,79,70,244,108,14,109,217,63,205,116,194,14,140,243,90,18,67,234,65,35,2,193,108,112,193,216,119,65,128,151,54,215,71,142,45,230,6,165,0,181,197,188,27,132,132,113,65,138,26,104,90,187,91,67,119,232,152,90,108,217,217,21,45,79,30,12,54,126,95,39,27,45,156,62,0,28,221,185,152,0,18,160,131,49,83,139,174,98,144,146,181,83,209,221,244,197,22,196,239,244,87,239,194,167,148,246,217,150,213,174,7,188,233,183,28,141,168,156,49,222,107,133,42,239,42,202,107,121,237,211,112,72,172,248,93,27,111,225,70,42,46,102,222,54,225,127,197,7,160,84,232,84,99,77,243,101,34,2,178,243,229,27,169,194,164,48,132,145,103,41,159,160,38,228,197,174,184,253,222,159,249,214,243,204,58,207,232,253,123,128,169,107,188,153,178,90,253,178,159,9,62,171,132,56,127,44,28,36,176,53,7,21,241,30,42,70,50,7,49,119,115,72,112,225,180,81,107,208,245,122,70,131,54,99,93,178,119,203,250,215,78,210,225,230,15,249,204,181,204,224,215,132,141,175,150,18,74,182,141,35,11,157,160,112,200,132,187,65,137,3,35,93,70,26,56,108,7,49,21,63,196,40,14,14,133,103,79,152,66,126,84,169,3,85,121,250,192,76,98,203,129,129,56,197,31,152,35,244,94,179,14,167,157,170,21,150,220,229,84,0,27,252,79,49,90,215,98,98,153,206,121,83,216,73,225,79,23,80,250,126,86,123,215,45,149,98,204,28,212,45,141,138,19,52,150,187,82,31,187,232,145,6,160,217,208,94,126,243,236,71,101,194,173,108,72,145,110,117,83,160,47,58,18,54,232,35,9,7,169,8,36,84,106,17,63,101,43,150,167,121,228,143,188,72,165,164,145,27,102,189,138,42,39,242,203,188,224,235,208,141,161,192,253,222,98,217,230,239,35,20,188,225,189,13,167,208,252,38,138,131,63,63,145,178,126,112,208,36,185,105,203,21,248,66,230,70,59,91,253,119,122,220,101,107,181,197,126,90,244,238,83,9,55,247,72,56,118,184,9,174,177,161,18,159,240,138,63,204,51,147,36,253,114,0,0,0,0,1,194,106,55,3,132,212,110,2,70,190,89,7,9,168,220,6,203,194,235,4,141,124,178,5,79,22,133,14,19,81,184,15,209,59,143,13,151,133,214,12,85,239,225,9,26,249,100,8,216,147,83,10,158,45,10,11,92,71,61,28,38,163,112,29,228,201,71,31,162,119,30,30,96,29,41,27,47,11,172,26,237,97,155,24,171,223,194,25,105,181,245,18,53,242,200,19,247,152,255,17,177,38,166,16,115,76,145,21,60,90,20,20,254,48,35,22,184,142,122,23,122,228,77,56,77,70,224,57,143,44,215,59,201,146,142,58,11,248,185,63,68,238,60,62,134,132,11,60,192,58,82,61,2,80,101,54,94,23,88,55,156,125,111,53,218,195,54,52,24,169,1,49,87,191,132,48,149,213,179,50,211,107,234,51,17,1,221,36,107,229,144,37,169,143,167,39,239,49,254,38,45,91,201,35,98,77,76,34,160,39,123,32,230,153,34,33,36,243,21,42,120,180,40,43,186,222,31,41,252,96,70,40,62,10,113,45,113,28,244,44,179,118,195,46,245,200,154,47,55,162,173,112,154,141,192,113,88,231,247,115,30,89,174,114,220,51,153,119,147,37,28,118,81,79,43,116,23,241,114,117,213,155,69,126,137,220,120,127,75,182,79,125,13,8,22,124,207,98,33,121,128,116,164,120,66,30,147,122,4,160,202,123,198,202,253,108,188,46,176,109,126,68,135,111,56,250,222,110,250,144,233,107,181,134,108,106,119,236,91,104,49,82,2,105,243,56,53,98,175,127,8,99,109,21,63,97,43,171,102,96,233,193,81,101,166,215,212,100,100,189,227,102,34,3,186,103,224,105,141,72,215,203,32,73,21,161,23,75,83,31,78,74,145,117,121,79,222,99,252,78,28,9,203,76,90,183,146,77,152,221,165,70,196,154,152,71,6,240,175,69,64,78,246,68,130,36,193,65,205,50,68,64,15,88,115,66,73,230,42,67,139,140,29,84,241,104,80,85,51,2,103,87,117,188,62,86,183,214,9,83,248,192,140,82,58,170,187,80,124,20,226,81,190,126,213,90,226,57,232,91,32,83,223,89,102,237,134,88,164,135,177,93,235,145,52,92,41,251,3,94,111,69,90,95,173,47,109,225,53,27,128,224,247,113,183,226,177,207,238,227,115,165,217,230,60,179,92,231,254,217,107,229,184,103,50,228,122,13,5,239,38,74,56,238,228,32,15,236,162,158,86,237,96,244,97,232,47,226,228,233,237,136,211,235,171,54,138,234,105,92,189,253,19,184,240,252,209,210,199,254,151,108,158,255,85,6,169,250,26,16,44,251,216,122,27,249,158,196,66,248,92,174,117,243,0,233,72,242,194,131,127,240,132,61,38,241,70,87,17,244,9,65,148,245,203,43,163,247,141,149,250,246,79,255,205,217,120,93,96,216,186,55,87,218,252,137,14,219,62,227,57,222,113,245,188,223,179,159,139,221,245,33,210,220,55,75,229,215,107,12,216,214,169,102,239,212,239,216,182,213,45,178,129,208,98,164,4,209,160,206,51,211,230,112,106,210,36,26,93,197,94,254,16,196,156,148,39,198,218,42,126,199,24,64,73,194,87,86,204,195,149,60,251,193,211,130,162,192,17,232,149,203,77,175,168,202,143,197,159,200,201,123,198,201,11,17,241,204,68,7,116,205,134,109,67,207,192,211,26,206,2,185,45,145,175,150,64,144,109,252,119,146,43,66,46,147,233,40,25,150,166,62,156,151,100,84,171,149,34,234,242,148,224,128,197,159,188,199,248,158,126,173,207,156,56,19,150,157,250,121,161,152,181,111,36,153,119,5,19,155,49,187,74,154,243,209,125,141,137,53,48,140,75,95,7,142,13,225,94,143,207,139,105,138,128,157,236,139,66,247,219,137,4,73,130,136,198,35,181,131,154,100,136,130,88,14,191,128,30,176,230,129,220,218,209,132,147,204,84,133,81,166,99,135,23,24,58,134,213,114,13,169,226,208,160,168,32,186,151,170,102,4,206,171,164,110,249,174,235,120,124,175,41,18,75,173,111,172,18,172,173,198,37,167,241,129,24,166,51,235,47,164,117,85,118,165,183,63,65,160,248,41,196,161,58,67,243,163,124,253,170,162,190,151,157,181,196,115,208,180,6,25,231,182,64,167,190,183,130,205,137,178,205,219,12,179,15,177,59,177,73,15,98,176,139,101,85,187,215,34,104,186,21,72,95,184,83,246,6,185,145,156,49,188,222,138,180,189,28,224,131,191,90,94,218,190,152,52,237,0,0,0,0,184,188,103,101,170,9,200,139,18,181,175,238,143,98,151,87,55,222,240,50,37,107,95,220,157,215,56,185,197,180,40,239,125,8,79,138,111,189,224,100,215,1,135,1,74,214,191,184,242,106,216,221,224,223,119,51,88,99,16,86,80,25,87,159,232,165,48,250,250,16,159,20,66,172,248,113,223,123,192,200,103,199,167,173,117,114,8,67,205,206,111,38,149,173,127,112,45,17,24,21,63,164,183,251,135,24,208,158,26,207,232,39,162,115,143,66,176,198,32,172,8,122,71,201,160,50,175,62,24,142,200,91,10,59,103,181,178,135,0,208,47,80,56,105,151,236,95,12,133,89,240,226,61,229,151,135,101,134,135,209,221,58,224,180,207,143,79,90,119,51,40,63,234,228,16,134,82,88,119,227,64,237,216,13,248,81,191,104,240,43,248,161,72,151,159,196,90,34,48,42,226,158,87,79,127,73,111,246,199,245,8,147,213,64,167,125,109,252,192,24,53,159,208,78,141,35,183,43,159,150,24,197,39,42,127,160,186,253,71,25,2,65,32,124,16,244,143,146,168,72,232,247,155,20,88,61,35,168,63,88,49,29,144,182,137,161,247,211,20,118,207,106,172,202,168,15,190,127,7,225,6,195,96,132,94,160,112,210,230,28,23,183,244,169,184,89,76,21,223,60,209,194,231,133,105,126,128,224,123,203,47,14,195,119,72,107,203,13,15,162,115,177,104,199,97,4,199,41,217,184,160,76,68,111,152,245,252,211,255,144,238,102,80,126,86,218,55,27,14,185,39,77,182,5,64,40,164,176,239,198,28,12,136,163,129,219,176,26,57,103,215,127,43,210,120,145,147,110,31,244,59,38,247,3,131,154,144,102,145,47,63,136,41,147,88,237,180,68,96,84,12,248,7,49,30,77,168,223,166,241,207,186,254,146,223,236,70,46,184,137,84,155,23,103,236,39,112,2,113,240,72,187,201,76,47,222,219,249,128,48,99,69,231,85,107,63,160,156,211,131,199,249,193,54,104,23,121,138,15,114,228,93,55,203,92,225,80,174,78,84,255,64,246,232,152,37,174,139,136,115,22,55,239,22,4,130,64,248,188,62,39,157,33,233,31,36,153,85,120,65,139,224,215,175,51,92,176,202,237,89,182,59,85,229,209,94,71,80,126,176,255,236,25,213,98,59,33,108,218,135,70,9,200,50,233,231,112,142,142,130,40,237,158,212,144,81,249,177,130,228,86,95,58,88,49,58,167,143,9,131,31,51,110,230,13,134,193,8,181,58,166,109,189,64,225,164,5,252,134,193,23,73,41,47,175,245,78,74,50,34,118,243,138,158,17,150,152,43,190,120,32,151,217,29,120,244,201,75,192,72,174,46,210,253,1,192,106,65,102,165,247,150,94,28,79,42,57,121,93,159,150,151,229,35,241,242,77,107,25,5,245,215,126,96,231,98,209,142,95,222,182,235,194,9,142,82,122,181,233,55,104,0,70,217,208,188,33,188,136,223,49,234,48,99,86,143,34,214,249,97,154,106,158,4,7,189,166,189,191,1,193,216,173,180,110,54,21,8,9,83,29,114,78,154,165,206,41,255,183,123,134,17,15,199,225,116,146,16,217,205,42,172,190,168,56,25,17,70,128,165,118,35,216,198,102,117,96,122,1,16,114,207,174,254,202,115,201,155,87,164,241,34,239,24,150,71,253,173,57,169,69,17,94,204,118,77,238,6,206,241,137,99,220,68,38,141,100,248,65,232,249,47,121,81,65,147,30,52,83,38,177,218,235,154,214,191,179,249,198,233,11,69,161,140,25,240,14,98,161,76,105,7,60,155,81,190,132,39,54,219,150,146,153,53,46,46,254,80,38,84,185,153,158,232,222,252,140,93,113,18,52,225,22,119,169,54,46,206,17,138,73,171,3,63,230,69,187,131,129,32,227,224,145,118,91,92,246,19,73,233,89,253,241,85,62,152,108,130,6,33,212,62,97,68,198,139,206,170,126,55,169,207,214,127,65,56,110,195,38,93,124,118,137,179,196,202,238,214,89,29,214,111,225,161,177,10,243,20,30,228,75,168,121,129,19,203,105,215,171,119,14,178,185,194,161,92,1,126,198,57,156,169,254,128,36,21,153,229,54,160,54,11,142,28,81,110,134,102,22,167,62,218,113,194,44,111,222,44,148,211,185,73,9,4,129,240,177,184,230,149,163,13,73,123,27,177,46,30,67,210,62,72,251,110,89,45,233,219,246,195,81,103,145,166,204,176,169,31,116,12,206,122,102,185,97,148,222,5,6,241,0,0,0,0,88,7,0,0,216,0,0,0,217,0,0,0,42,0,0,0,54,0,0,0,36,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,104,7,0,0,218,0,0,0,219,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,26,0,0,0,43,0,0,0,55,0,0,0,18,0,0,0,8,0,0,0,21,0,0,0,4,0,0,0,13,0,0,0,10,0,0,0,3,0,0,0,10,0,0,0,56,0,0,0,23,0,0,0,57,0,0,0,19,0,0,0,2,0,0,0,25,0,0,0,28,0,0,0,248,255,255,255,104,7,0,0,9,0,0,0,26,0,0,0,5,0,0,0,220,0,0,0,221,0,0,0,236,255,255,255,104,7,0,0,9,0,0,0,10,0,0,0,222,0,0,0,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,7,0,0,224,0,0,0,225,0,0,0,58,0,0,0,1,0,0,0,59,0,0,0,226,0,0,0,44,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,144,7,0,0,227,0,0,0,228,0,0,0,229,0,0,0,230,0,0,0,25,0,0,0,45,0,0,0,231,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,26,0,0,0,232,0,0,0,27,0,0,0,1,0,0,0,60,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,233,0,0,0,33,0,0,0,9,0,0,0,34,0,0,0,35,0,0,0,46,0,0,0,47,0,0,0,14,0,0,0,15,0,0,0,48,0,0,0,234,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,7,0,0,0,8,0,0,0,235,0,0,0,40,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,236,0,0,0,41,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,192,7,0,0,237,0,0,0,238,0,0,0,1,0,0,0,0,0,0,0,8,3,0,0,71,0,0,0,239,0,0,0,5,0,0,0,3,0,0,0,0,0,0,0,176,7,0,0,71,0,0,0,240,0,0,0,16,0,0,0,4,0,0,0,0,0,0,64,0,0,0,0,216,7,0,0,17,0,0,0,241,0,0,0,242,0,0,0,42,0,0,0,49,0,0,0,11,0,0,0,43,0,0,0,0,0,0,0,0,0,0,0,232,7,0,0,243,0,0,0,244,0,0,0,3,0,0,0,44,0,0,0,13,0,0,0,14,0,0,0,10,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,245,0,0,0,246,0,0,0,1,0,0,0,61,0,0,0,5,0,0,0,11,0,0,0,2,0,0,0,12,0,0,0,45,0,0,0,50,0,0,0,51,0,0,0,62,0,0,0,46,0,0,0,247,0,0,0,0,0,0,0,64,8,0,0,248,0,0,0,249,0,0,0,63,0,0,0,47,0,0,0,4,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,48,8,0,0,248,0,0,0,250,0,0,0,64,0,0,0,48,0,0,0,4,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,24,8,0,0,248,0,0,0,251,0,0,0,64,0,0,0,49,0,0,0,4,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,8,0,0,252,0,0,0,253,0,0,0,12,0,0,0,11,0,0,0,65,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,66,0,0,0,55,0,0,0,67,0,0,0,50,0,0,0,68,0,0,0,13,0,0,0,56,0,0,0,51,0,0,0,52,0,0,0,0,0,0,0,136,8,0,0,254,0,0,0,255,0,0,0,20,0,0,0,0,0,0,0,120,8,0,0,254,0,0,0,0,1,0,0,21,0,0,0,0,0,0,0,0,0,0,0,152,8,0,0,1,1,0,0,2,1,0,0,12,0,0,0,14,0,0,0,53,0,0,0,54,0,0,0,15,0,0,0,16,0,0,0,13,0,0,0,57,0,0,0,22,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,23,0,0,0,55,0,0,0,0,0,0,0,168,8,0,0,254,0,0,0,3,1,0,0,24,0,0,0,0,0,0,0,184,8,0,0,25,0,0,0,4,1,0,0,5,1,0,0,42,0,0,0,61,0,0,0,17,0,0,0,56,0,0,0,0,0,0,0,192,8,0,0,6,1,0,0,7,1,0,0,229,0,0,0,230,0,0,0,25,0,0,0,45,0,0,0,8,1,0,0,6,0,0,0,7,0,0,0,14,0,0,0,57,0,0,0,232,0,0,0,58,0,0,0,0,0,0,0,176,9,0,0,15,0,0,0,59,0,0,0,69,0,0,0,9,1,0,0,10,1,0,0,0,0,0,0,160,9,0,0,11,1,0,0,12,1,0,0,15,0,0,0,1,0,0,0,0,0,0,0,144,9,0,0,11,1,0,0,13,1,0,0,15,0,0,0,2,0,0,0,0,0,0,0,128,9,0,0,248,0,0,0,14,1,0,0,64,0,0,0,60,0,0,0,4,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,96,9,0,0,11,1,0,0,15,1,0,0,16,0,0,0,1,0,0,0,0,0,0,0,80,9,0,0,11,1,0,0,16,1,0,0,16,0,0,0,2,0,0,0,0,0,0,0,64,9,0,0,71,0,0,0,17,1,0,0,26,0,0,0,5,0,0,0,0,0,0,0,48,9,0,0,18,1,0,0,19,1,0,0,27,0,0,0,0,0,0,0,16,9,0,0,18,1,0,0,20,1,0,0,28,0,0,0,0,0,0,0,248,8,0,0,18,1,0,0,21,1,0,0,29,0,0,0,0,0,0,0,232,8,0,0,22,1,0,0,23,1,0,0,70,0,0,0,71,0,0,0,10,0,0,0,0,0,0,0,200,8,0,0,24,1,0,0,25,1,0,0,17,0,0,0,18,0,0,0,252,255,255,255,200,8,0,0,26,1,0,0,27,1,0,0,19,0,0,0,0,0,0,0,112,9,0,0,99,0,0,0,28,1,0,0,30,0,0,0,6,0,0,0,0,0,0,0,184,9,0,0,29,1,0,0,30,1,0,0,62,0,0,0,63,0,0,0,18,0,0,0,64,0,0,0,0,0,0,0,104,10,0,0,31,1,0,0,32,1,0,0,13,0,0,0,0,0,0,0,88,10,0,0,31,1,0,0,33,1,0,0,14,0,0,0,0,0,0,0,72,10,0,0,31,1,0,0,34,1,0,0,15,0,0,0,0,0,0,0,56,10,0,0,31,1,0,0,35,1,0,0,16,0,0,0,0,0,0,0,40,10,0,0,31,1,0,0,36,1,0,0,17,0,0,0,0,0,0,0,24,10,0,0,31,1,0,0,37,1,0,0,18,0,0,0,0,0,0,0,8,10,0,0,31,1,0,0,38,1,0,0,19,0,0,0,0,0,0,0,248,9,0,0,31,1,0,0,39,1,0,0,20,0,0,0,0,0,0,0,232,9,0,0,31,1,0,0,40,1,0,0,21,0,0,0,0,0,0,0,208,9,0,0,31,1,0,0,41,1,0,0,22,0,0,0,0,0,0,0,120,10,0,0,42,1,0,0,43,1,0,0,6,0,0,0,1,0,0,0,61,0,0,0,0,0,0,0,144,10,0,0,25,0,0,0,44,1,0,0,45,1,0,0,42,0,0,0,61,0,0,0,17,0,0,0,56,0,0,0,72,0,0,0,20,0,0,0,0,0,0,0,160,10,0,0,25,0,0,0,46,1,0,0,47,1,0,0,42,0,0,0,61,0,0,0,17,0,0,0,56,0,0,0,73,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,176,10,0,0,22,1,0,0,48,1,0,0,70,0,0,0,71,0,0,0,11,0,0,0,0,0,0,0,200,10,0,0,49,1,0,0,50,1,0,0,74,0,0,0,62,0,0,0,0,0,0,0,208,10,0,0,51,1,0,0,52,1,0,0,7,0,0,0,2,0,0,0,63,0,0,0,0,0,0,0,224,10,0,0,53,1,0,0,54,1,0,0,8,0,0,0,3,0,0,0,64,0,0,0,0,0,0,0,240,10,0,0,55,1,0,0,56,1,0,0,9,0,0,0,0,0,0,0,8,11,0,0,57,1,0,0,58,1,0,0,22,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,65,0,0,0,65,0,0,0,1,0,0,0,66,0,0,0,66,0,0,0,16,0,0,0,2,0,0,0,67,0,0,0,19,0,0,0,67,0,0,0,76,0,0,0,77,0,0,0,10,0,0,0,23,0,0,0,24,0,0,0,68,0,0,0,78,0,0,0,31,0,0,0,69,0,0,0,70,0,0,0,25,0,0,0,79,0,0,0,71,0,0,0,26,0,0,0,1,0,0,0,80,0,0,0,0,0,0,0,24,11,0,0,59,1,0,0,60,1,0,0,27,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,68,0,0,0,72,0,0,0,2,0,0,0,73,0,0,0,66,0,0,0,17,0,0,0,3,0,0,0,74,0,0,0,20,0,0,0,67,0,0,0,28,0,0,0,81,0,0,0,82,0,0,0,69,0,0,0,70,0,0,0,0,0,0,0,80,11,0,0,61,1,0,0,62,1,0,0,83,0,0,0,0,0,0,0,64,11,0,0,61,1,0,0,63,1,0,0,84,0,0,0,0,0,0,0,40,11,0,0,61,1,0,0,64,1,0,0,85,0,0,0,0,0,0,0,96,11,0,0,65,1,0,0,66,1,0,0,29,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,71,0,0,0,65,0,0,0,3,0,0,0,75,0,0,0,72,0,0,0,18,0,0,0,2,0,0,0,76,0,0,0,21,0,0,0,67,0,0,0,86,0,0,0,87,0,0,0,10,0,0,0,30,0,0,0,24,0,0,0,77,0,0,0,88,0,0,0,0,0,0,0,120,11,0,0,65,1,0,0,67,1,0,0,31,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,65,0,0,0,1,0,0,0,1,0,0,0,66,0,0,0,19,0,0,0,2,0,0,0,67,0,0,0,19,0,0,0,67,0,0,0,86,0,0,0,1,0,0,0,10,0,0,0,1,0,0,0,24,0,0,0,77,0,0,0,88,0,0,0,0,0,0,0,136,11,0,0,65,1,0,0,68,1,0,0,1,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,66,0,0,0,1,0,0,0,1,0,0,0,78,0,0,0,22,0,0,0,67,0,0,0,1,0,0,0,1,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,152,11,0,0,69,1,0,0,70,1,0,0,32,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,74,0,0,0,79,0,0,0,4,0,0,0,80,0,0,0,66,0,0,0,17,0,0,0,3,0,0,0,78,0,0,0,22,0,0,0,67,0,0,0,33,0,0,0,7,0,0,0,0,0,0,0,168,11,0,0,71,1,0,0,72,1,0,0,23,0,0,0,81,0,0,0,23,0,0,0,75,0,0,0,76,0,0,0,24,0,0,0,0,0,0,0,200,11,0,0,73,1,0,0,74,1,0,0,34,0,0,0,0,0,0,0,184,11,0,0,73,1,0,0,75,1,0,0,35,0,0,0,0,0,0,0,216,11,0,0,57,1,0,0,76,1,0,0,31,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,65,0,0,0,5,0,0,0,1,0,0,0,66,0,0,0,19,0,0,0,2,0,0,0,67,0,0,0,19,0,0,0,67,0,0,0,86,0,0,0,89,0,0,0,10,0,0,0,36,0,0,0,24,0,0,0,77,0,0,0,88,0,0,0,31,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,232,11,0,0,65,1,0,0,77,1,0,0,37,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,65,0,0,0,6,0,0,0,82,0,0,0,66,0,0,0,20,0,0,0,4,0,0,0,67,0,0,0,19,0,0,0,67,0,0,0,90,0,0,0,91,0,0,0,10,0,0,0,38,0,0,0,24,0,0,0,77,0,0,0,88,0,0,0,0,0,0,0,8,12,0,0,78,1,0,0,79,1,0,0,39,0,0,0,1,0,0,0,2,0,0,0,77,0,0,0,78,0,0,0,83,0,0,0,79,0,0,0,80,0,0,0,84,0,0,0,92,0,0,0,93,0,0,0,85,0,0,0,24,0,0,0,0,0,0,0,24,12,0,0,80,1,0,0,81,1,0,0,27,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,81,0,0,0,72,0,0,0,2,0,0,0,86,0,0,0,66,0,0,0,17,0,0,0,3,0,0,0,78,0,0,0,22,0,0,0,67,0,0,0,40,0,0,0,81,0,0,0,82,0,0,0,0,0,0,0,56,12,0,0,73,1,0,0,82,1,0,0,41,0,0,0,0,0,0,0,40,12,0,0,11,1,0,0,83,1,0,0,42,0,0,0,0,0,0,0,72,12,0,0,84,1,0,0,85,1,0,0,1,0,0,0,0,0,0,0,88,12,0,0,22,1,0,0,86,1,0,0,94,0,0,0,95,0,0,0,12,0,0,0,0,0,0,0,112,12,0,0,84,1,0,0,87,1,0,0,2,0,0,0,0,0,0,0,128,12,0,0,88,1,0,0,89,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,12,0,0,55,1,0,0,90,1,0,0,11,0,0,0,0,0,0,0,168,12,0,0,88,1,0,0,91,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,12,0,0,22,1,0,0,92,1,0,0,96,0,0,0,97,0,0,0,13,0,0,0,10,215,163,60,0,0,0,0,0,0,0,0,0,0,0,0,208,12,0,0,11,1,0,0,93,1,0,0,15,0,0,0,1,0,0,0,0,0,0,0,224,12,0,0,11,1,0,0,94,1,0,0,16,0,0,0,1,0,0,0,0,0,0,0,240,12,0,0,57,1,0,0,95,1,0,0,43,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,65,0,0,0,7,0,0,0,87,0,0,0,66,0,0,0,19,0,0,0,2,0,0,0,67,0,0,0,19,0,0,0,67,0,0,0,86,0,0,0,98,0,0,0,10,0,0,0,44,0,0,0,24,0,0,0,88,0,0,0,99,0,0,0,31,0,0,0,89,0,0,0,90,0,0,0,45,0,0,0,100,0,0,0,91,0,0,0,46,0,0,0,2,0,0,0,47,0,0,0,0,0,0,0,0,13,0,0,84,1,0,0,96,1,0,0,3,0,0,0,0,0,0,0,136,10,0,0,42,1,0,0,97,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,24,13,0,0,98,1,0,0,99,1,0,0,23,0,0,0,81,0,0,0,23,0,0,0,75,0,0,0,76,0,0,0,0,0,0,0,0,0,0,0,32,13,0,0,100,1,0,0,101,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,48,13,0,0,102,1,0,0,103,1,0,0,12,0,0,0,4,0,0,0,82,0,0,0,0,0,0,0,64,13,0,0,55,1,0,0,104,1,0,0,13,0,0,0,0,0,0,0,0,0,0,0,80,13,0,0,105,1,0,0,106,1,0,0,14,0,0,0,5,0,0,0,83,0,0,0,0,0,0,0,96,13,0,0,248,0,0,0,107,1,0,0,64,0,0,0,84,0,0,0,4,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,112,13,0,0,108,1,0,0,109,1,0,0,15,0,0,0,6,0,0,0,85,0,0,0,0,0,0,0,128,13,0,0,248,0,0,0,110,1,0,0,101,0,0,0,86,0,0,0,4,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,144,13,0,0,111,1,0,0,112,1,0,0,16,0,0,0,7,0,0,0,87,0,0,0,0,0,0,0,160,13,0,0,113,1,0,0,114,1,0,0,48,0,0,0,0,0,0,0,176,13,0,0,11,1,0,0,115,1,0,0,49,0,0,0,0,0,0,0,192,13,0,0,116,1,0,0,117,1,0,0,25,0,0,0,0,0,0,0,208,13,0,0,118,1,0,0,119,1,0,0,17,0,0,0,8,0,0,0,88,0,0,0,0,0,0,0,0,14,0,0,22,1,0,0,120,1,0,0,102,0,0,0,103,0,0,0,14,0,0,0,0,0,0,0,240,13,0,0,22,1,0,0,121,1,0,0,104,0,0,0,105,0,0,0,15,0,0,0,0,0,0,0,224,13,0,0,22,1,0,0,122,1,0,0,70,0,0,0,71,0,0,0,16,0,0,0,0,0,0,0,16,14,0,0,123,1,0,0,124,1,0,0,18,0,0,0,9,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,14,0,0,125,1,0,0,126,1,0,0,25,0,0,0,26,0,0,0,92,0,0,0,0,0,0,0,40,14,0,0,127,1,0,0,128,1,0,0,1,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,66,0,0,0,17,0,0,0,3,0,0,0,78,0,0,0,22,0,0,0,67,0,0,0,1,0,0,0,0,0,0,0,56,14,0,0,129,1,0,0,130,1,0,0,1,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,131,1,0,0,93,0,0,0,132,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,72,14,0,0,133,1,0,0,134,1,0,0,94,0,0,0,0,0,0,0,0,0,0,0,96,14,0,0,135,1,0,0,136,1,0,0,95,0,0,0,0,0,0,0,112,14,0,0,135,1,0,0,137,1,0,0,95,0,0,0,0,0,0,0,200,14,0,0,138,1,0,0,139,1,0,0,140,1,0,0,141,1,0,0,27,0,0,0,0,0,0,0,152,14,0,0,138,1,0,0,142,1,0,0,140,1,0,0,141,1,0,0,28,0,0,0,3,0,0,0,19,0,0,0,50,0,0,0,0,0,0,0,216,14,0,0,138,1,0,0,143,1,0,0,140,1,0,0,141,1,0,0,28,0,0,0,4,0,0,0,20,0,0,0,51,0,0,0,0,0,0,0,232,14,0,0,138,1,0,0,144,1,0,0,140,1,0,0,141,1,0,0,28,0,0,0,5,0,0,0,21,0,0,0,52,0,0,0,0,0,0,0,0,0,0,0,99,23,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,208,107,0,0,64,108,0,0,176,108,0,0,176,108,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,31,0,0,0,1,40,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,31,0,0,0,249,35,1,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+17584);allocate([96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,31,0,0,0,241,31,1,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,4,0,4,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,32,0,32,0,0,0,1,0,2,0,2,0,1,0,3,0,4,0,5,0,6,0,6,0,5,0,7,0,8,0,9,0,10,0,10,0,9,0,11,0,12,0,13,0,14,0,14,0,13,0,15,0,16,0,17,0,18,0,18,0,17,0,19,0,20,0,21,0,22,0,22,0,21,0,23,0,0,0,1,0,2,0,3,0,0,0,1,0,2,0,3,0,0,0,1,0,2,0,3,0,0,0,1,0,2,0,3,0,0,0,1,0,2,0,3,0,0,0,1,0,2,0,3,0,96,7,0,0,0,8,80,0,0,8,16,0,20,8,115,0,18,7,31,0,0,8,112,0,0,8,48,0,0,9,192,0,16,7,10,0,0,8,96,0,0,8,32,0,0,9,160,0,0,8,0,0,0,8,128,0,0,8,64,0,0,9,224,0,16,7,6,0,0,8,88,0,0,8,24,0,0,9,144,0,19,7,59,0,0,8,120,0,0,8,56,0,0,9,208,0,17,7,17,0,0,8,104,0,0,8,40,0,0,9,176,0,0,8,8,0,0,8,136,0,0,8,72,0,0,9,240,0,16,7,4,0,0,8,84,0,0,8,20,0,21,8,227,0,19,7,43,0,0,8,116,0,0,8,52,0,0,9,200,0,17,7,13,0,0,8,100,0,0,8,36,0,0,9,168,0,0,8,4,0,0,8,132,0,0,8,68,0,0,9,232,0,16,7,8,0,0,8,92,0,0,8,28,0,0,9,152,0,20,7,83,0,0,8,124,0,0,8,60,0,0,9,216,0,18,7,23,0,0,8,108,0,0,8,44,0,0,9,184,0,0,8,12,0,0,8,140,0,0,8,76,0,0,9,248,0,16,7,3,0,0,8,82,0,0,8,18,0,21,8,163,0,19,7,35,0,0,8,114,0,0,8,50,0,0,9,196,0,17,7,11,0,0,8,98,0,0,8,34,0,0,9,164,0,0,8,2,0,0,8,130,0,0,8,66,0,0,9,228,0,16,7,7,0,0,8,90,0,0,8,26,0,0,9,148,0,20,7,67,0,0,8,122,0,0,8,58,0,0,9,212,0,18,7,19,0,0,8,106,0,0,8,42,0,0,9,180,0,0,8,10,0,0,8,138,0,0,8,74,0,0,9,244,0,16,7,5,0,0,8,86,0,0,8,22,0,64,8,0,0,19,7,51,0,0,8,118,0,0,8,54,0,0,9,204,0,17,7,15,0,0,8,102,0,0,8,38,0,0,9,172,0,0,8,6,0,0,8,134,0,0,8,70,0,0,9,236,0,16,7,9,0,0,8,94,0,0,8,30,0,0,9,156,0,20,7,99,0,0,8,126,0,0,8,62,0,0,9,220,0,18,7,27,0,0,8,110,0,0,8,46,0,0,9,188,0,0,8,14,0,0,8,142,0,0,8,78,0,0,9,252,0,96,7,0,0,0,8,81,0,0,8,17,0,21,8,131,0,18,7,31,0,0,8,113,0,0,8,49,0,0,9,194,0,16,7,10,0,0,8,97,0,0,8,33,0,0,9,162,0,0,8,1,0,0,8,129,0,0,8,65,0,0,9,226,0,16,7,6,0,0,8,89,0,0,8,25,0,0,9,146,0,19,7,59,0,0,8,121,0,0,8,57,0,0,9,210,0,17,7,17,0,0,8,105,0,0,8,41,0,0,9,178,0,0,8,9,0,0,8,137,0,0,8,73,0,0,9,242,0,16,7,4,0,0,8,85,0,0,8,21,0,16,8,2,1,19,7,43,0,0,8,117,0,0,8,53,0,0,9,202,0,17,7,13,0,0,8,101,0,0,8,37,0,0,9,170,0,0,8,5,0,0,8,133,0,0,8,69,0,0,9,234,0,16,7,8,0,0,8,93,0,0,8,29,0,0,9,154,0,20,7,83,0,0,8,125,0,0,8,61,0,0,9,218,0,18,7,23,0,0,8,109,0,0,8,45,0,0,9,186,0,0,8,13,0,0,8,141,0,0,8,77,0,0,9,250,0,16,7,3,0,0,8,83,0,0,8,19,0,21,8,195,0,19,7,35,0,0,8,115,0,0,8,51,0,0,9,198,0,17,7,11,0,0,8,99,0,0,8,35,0,0,9,166,0,0,8,3,0,0,8,131,0,0,8,67,0,0,9,230,0,16,7,7,0,0,8,91,0,0,8,27,0,0,9,150,0,20,7,67,0,0,8,123,0,0,8,59,0,0,9,214,0,18,7,19,0,0,8,107,0,0,8,43,0,0,9,182,0,0,8,11,0,0,8,139,0,0,8,75,0,0,9,246,0,16,7,5,0,0,8,87,0,0,8,23,0,64,8,0,0,19,7,51,0,0,8,119,0,0,8,55,0,0,9,206,0,17,7,15,0,0,8,103,0,0,8,39,0,0,9,174,0,0,8,7,0,0,8,135,0,0,8,71,0,0,9,238,0,16,7,9,0,0,8,95,0,0,8,31,0,0,9,158,0,20,7,99,0,0,8,127,0,0,8,63,0,0,9,222,0,18,7,27,0,0,8,111,0,0,8,47,0,0,9,190,0,0,8,15,0,0,8,143,0,0,8,79,0,0,9,254,0,96,7,0,0,0,8,80,0,0,8,16,0,20,8,115,0,18,7,31,0,0,8,112,0,0,8,48,0,0,9,193,0,16,7,10,0,0,8,96,0,0,8,32,0,0,9,161,0,0,8,0,0,0,8,128,0,0,8,64,0,0,9,225,0,16,7,6,0,0,8,88,0,0,8,24,0,0,9,145,0,19,7,59,0,0,8,120,0,0,8,56,0,0,9,209,0,17,7,17,0,0,8,104,0,0,8,40,0,0,9,177,0,0,8,8,0,0,8,136,0,0,8,72,0,0,9,241,0,16,7,4,0,0,8,84,0,0,8,20,0,21,8,227,0,19,7,43,0,0,8,116,0,0,8,52,0,0,9,201,0,17,7,13,0,0,8,100,0,0,8,36,0,0,9,169,0,0,8,4,0,0,8,132,0,0,8,68,0,0,9,233,0,16,7,8,0,0,8,92,0,0,8,28,0,0,9,153,0,20,7,83,0,0,8,124,0,0,8,60,0,0,9,217,0,18,7,23,0,0,8,108,0,0,8,44,0,0,9,185,0,0,8,12,0,0,8,140,0,0,8,76,0,0,9,249,0,16,7,3,0,0,8,82,0,0,8,18,0,21,8,163,0,19,7,35,0,0,8,114,0,0,8,50,0,0,9,197,0,17,7,11,0,0,8,98,0,0,8,34,0,0,9,165,0,0,8,2,0,0,8,130,0,0,8,66,0,0,9,229,0,16,7,7,0,0,8,90,0,0,8,26,0,0,9,149,0,20,7,67,0,0,8,122,0,0,8,58,0,0,9,213,0,18,7,19,0,0,8,106,0,0,8,42,0,0,9,181,0,0,8,10,0,0,8,138,0,0,8,74,0,0,9,245,0,16,7,5,0,0,8,86,0,0,8,22,0,64,8,0,0,19,7,51,0,0,8,118,0,0,8,54,0,0,9,205,0,17,7,15,0,0,8,102,0,0,8,38,0,0,9,173,0,0,8,6,0,0,8,134,0,0,8,70,0,0,9,237,0,16,7,9,0,0,8,94,0,0,8,30,0,0,9,157,0,20,7,99,0,0,8,126,0,0,8,62,0,0,9,221,0,18,7,27,0,0,8,110,0,0,8,46,0,0,9,189,0,0,8,14,0,0,8,142,0,0,8,78,0,0,9,253,0,96,7,0,0,0,8,81,0,0,8,17,0,21,8,131,0,18,7,31,0,0,8,113,0,0,8,49,0,0,9,195,0,16,7,10,0,0,8,97,0,0,8,33,0,0,9,163,0,0,8,1,0,0,8,129,0,0,8,65,0,0,9,227,0,16,7,6,0,0,8,89,0,0,8,25,0,0,9,147,0,19,7,59,0,0,8,121,0,0,8,57,0,0,9,211,0,17,7,17,0,0,8,105,0,0,8,41,0,0,9,179,0,0,8,9,0,0,8,137,0,0,8,73,0,0,9,243,0,16,7,4,0,0,8,85,0,0,8,21,0,16,8,2,1,19,7,43,0,0,8,117,0,0,8,53,0,0,9,203,0,17,7,13,0,0,8,101,0,0,8,37,0,0,9,171,0,0,8,5,0,0,8,133,0,0,8,69,0,0,9,235,0,16,7,8,0,0,8,93,0,0,8,29,0,0,9,155,0,20,7,83,0,0,8,125,0,0,8,61,0,0,9,219,0,18,7,23,0,0,8,109,0,0,8,45,0,0,9,187,0,0,8,13,0,0,8,141,0,0,8,77,0,0,9,251,0,16,7,3,0,0,8,83,0,0,8,19,0,21,8,195,0,19,7,35,0,0,8,115,0,0,8,51,0,0,9,199,0,17,7,11,0,0,8,99,0,0,8,35,0,0,9,167,0,0,8,3,0,0,8,131,0,0,8,67,0,0,9,231,0,16,7,7,0,0,8,91,0,0,8,27,0,0,9,151,0,20,7,67,0,0,8,123,0,0,8,59,0,0,9,215,0,18,7,19,0,0,8,107,0,0,8,43,0,0,9,183,0,0,8,11,0,0,8,139,0,0,8,75,0,0,9,247,0,16,7,5,0,0,8,87,0,0,8,23,0,64,8,0,0,19,7,51,0,0,8,119,0,0,8,55,0,0,9,207,0,17,7,15,0,0,8,103,0,0,8,39,0,0,9,175,0,0,8,7,0,0,8,135,0,0,8,71,0,0,9,239,0,16,7,9,0,0,8,95,0,0,8,31,0,0,9,159,0,20,7,99,0,0,8,127,0,0,8,63,0,0,9,223,0,18,7,27,0,0,8,111,0,0,8,47,0,0,9,191,0,0,8,15,0,0,8,143,0,0,8,79,0,0,9,255,0,16,5,1,0,23,5,1,1,19,5,17,0,27,5,1,16,17,5,5,0,25,5,1,4,21,5,65,0,29,5,1,64,16,5,3,0,24,5,1,2,20,5,33,0,28,5,1,32,18,5,9,0,26,5,1,8,22,5,129,0,64,5,0,0,16,5,2,0,23,5,129,1,19,5,25,0,27,5,1,24,17,5,7,0,25,5,1,6,21,5,97,0,29,5,1,96,16,5,4,0,24,5,1,3,20,5,49,0,28,5,1,48,18,5,13,0,26,5,1,12,22,5,193,0,64,5,0,0,16,0,17,0,18,0,0,0,8,0,7,0,9,0,6,0,10,0,5,0,11,0,4,0,12,0,3,0,13,0,2,0,14,0,1,0,15,0,1,0,2,0,3,0,4,0,5,0,7,0,9,0,13,0,17,0,25,0,33,0,49,0,65,0,97,0,129,0,193,0,1,1,129,1,1,2,1,3,1,4,1,6,1,8,1,12,1,16,1,24,1,32,1,48,1,64,1,96,0,0,0,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,13,0,15,0,17,0,19,0,23,0,27,0,31,0,35,0,43,0,51,0,59,0,67,0,83,0,99,0,115,0,131,0,163,0,195,0,227,0,2,1,0,0,0,0,16,0,16,0,16,0,16,0,17,0,17,0,18,0,18,0,19,0,19,0,20,0,20,0,21,0,21,0,22,0,22,0,23,0,23,0,24,0,24,0,25,0,25,0,26,0,26,0,27,0,27,0,28,0,28,0,29,0,29,0,64,0,64,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,17,0,17,0,17,0,17,0,18,0,18,0,18,0,18,0,19,0,19,0,19,0,19,0,20,0,20,0,20,0,20,0,21,0,21,0,21,0,21,0,16,0,72,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,80,77,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,97,116,97,46,100,112,109,0,64,0,149,207,144,148,150,188,0,140,94,0,40,37,100,44,37,100,44,37,100,44,37,100,41,0,148,122,151,241,0,131,130,129,91,131,104,0,142,103,151,112,131,84,131,67,131,89,0,131,111,131,98,131,116,131,64,131,84,131,67,131,89,0,40,147,224,151,101,37,100,98,121,116,101,115,130,204,136,234,149,148,130,240,149,142,166,130,181,130,196,130,162,130,220,130,183,41,13,10,0,147,224,151,101,58,0,76,65,66,69,76,32,36,37,48,56,120,0,83,84,82,85,67,84,32,40,69,109,112,116,121,41,0,83,84,82,85,67,84,32,73,68,37,100,45,37,100,32,80,84,82,36,37,48,56,120,32,83,73,90,69,37,100,40,37,100,41,0,67,79,77,80,84,82,32,36,37,48,56,120,0,40,148,122,151,241,130,204,136,234,149,148,130,190,130,175,130,240,149,142,166,41,13,10,0,40,37,100,41,61,37,115,13,10,0,37,48,52,88,0,32,37,48,50,88,0,37,115,58,37,52,100,13,10,0,56,72,83,80,69,82,82,79,82,0,32,35,43,45,46,48,49,50,51,52,53,54,55,56,57,0,100,111,117,98,108,101,0,105,110,116,0,115,116,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,116,114,117,99,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,103,97,109,101,104,115,112,0,114,101,115,47,102,111,110,116,46,103,112,98,0,105,110,105,116,50,68,82,101,110,100,101,114,0,50,68,32,115,104,97,100,101,114,32,105,110,105,116,97,108,105,122,101,32,102,97,105,108,101,100,46,0,119,105,110,51,50,103,112,47,103,97,109,101,104,115,112,46,99,112,112,0,114,101,115,47,115,104,97,100,101,114,115,47,115,112,114,105,116,101,99,111,108,46,118,101,114,116,0,114,101,115,47,115,104,97,100,101,114,115,47,115,112,114,105,116,101,99,111,108,46,102,114,97,103,0,109,97,107,101,50,68,77,97,116,101,114,105,97,108,70,111,114,77,101,115,104,0,50,68,32,105,110,105,116,97,108,105,122,101,32,102,97,105,108,101,100,46,0,99,114,101,97,116,101,67,117,98,101,77,101,115,104,0,46,103,112,98,0,78,111,100,101,32,110,111,116,32,102,111,117,110,100,46,40,37,115,35,37,115,41,0,97,110,105,109,97,116,105,111,110,115,0,105,100,108,101,0,115,116,97,114,116,80,111,108,121,84,101,120,50,68,0,66,97,100,32,77,97,116,101,114,105,97,108,46,0,100,114,97,119,80,111,108,121,84,101,120,50,68,0,97,100,100,80,111,108,121,84,101,120,50,68,0,102,105,110,105,115,104,80,111,108,121,84,101,120,50,68,0,78,56,103,97,109,101,112,108,97,121,49,55,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,49,56,77,101,116,104,111,100,86,97,108,117,101,66,105,110,100,105,110,103,73,78,83,95,52,78,111,100,101,69,78,83,95,55,86,101,99,116,111,114,51,69,69,69,0,78,56,103,97,109,101,112,108,97,121,49,55,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,49,51,77,101,116,104,111,100,66,105,110,100,105,110,103,69,0,117,95,99,97,109,101,114,97,80,111,115,105,116,105,111,110,0,117,95,105,110,118,101,114,115,101,84,114,97,110,115,112,111,115,101,87,111,114,108,100,86,105,101,119,77,97,116,114,105,120,0,117,95,97,109,98,105,101,110,116,67,111,108,111,114,0,117,95,108,105,103,104,116,68,105,114,101,99,116,105,111,110,0,117,95,108,105,103,104,116,67,111,108,111,114,0,117,95,100,105,102,102,117,115,101,67,111,108,111,114,0,117,95,109,111,100,117,108,97,116,101,65,108,112,104,97,0,84,101,120,116,117,114,101,32,110,111,116,32,102,111,117,110,100,46,40,37,115,41,0,109,97,107,101,77,97,116,101,114,105,97,108,84,101,120,50,68,0,119,105,110,51,50,103,112,47,103,112,109,97,116,46,99,112,112,0,114,101,115,47,115,104,97,100,101,114,115,47,99,111,108,111,114,101,100,45,117,110,108,105,116,46,118,101,114,116,0,114,101,115,47,115,104,97,100,101,114,115,47,99,111,108,111,114,101,100,45,117,110,108,105,116,46,102,114,97,103,0,77,79,68,85,76,65,84,69,95,65,76,80,72,65,0,114,101,115,47,115,104,97,100,101,114,115,47,99,111,108,111,114,101,100,46,118,101,114,116,0,114,101,115,47,115,104,97,100,101,114,115,47,99,111,108,111,114,101,100,46,102,114,97,103,0,114,101,115,47,115,104,97,100,101,114,115,47,116,101,120,116,117,114,101,100,45,117,110,108,105,116,46,118,101,114,116,0,114,101,115,47,115,104,97,100,101,114,115,47,116,101,120,116,117,114,101,100,45,117,110,108,105,116,46,102,114,97,103,0,114,101,115,47,115,104,97,100,101,114,115,47,116,101,120,116,117,114,101,100,46,118,101,114,116,0,114,101,115,47,115,104,97,100,101,114,115,47,116,101,120,116,117,114,101,100,46,102,114,97,103,0,117,95,100,105,102,102,117,115,101,84,101,120,116,117,114,101],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+27828);allocate([72,83,80,72,69,68,126,126,0,95,49,95,95,95,95,95,95,95,95,95,50,95,95,95,95,95,95,95,95,95,51,95,95,95,95,95,95,0,72,83,80,95,87,88,0,72,83,80,95,87,89,0,72,83,80,95,83,88,0,72,83,80,95,83,89,0,72,83,80,95,70,80,83,0,72,83,80,95,76,73,77,73,84,95,83,84,69,80,0,83,99,114,101,101,110,32,37,102,32,37,102,10,0,72,83,80,95,83,89,78,67,95,68,73,82,0,73,78,73,84,32,37,100,120,37,100,32,37,115,10,0,72,83,80,68,105,115,104,32,118,101,114,51,46,53,98,101,116,97,51,0,83,116,97,114,116,117,112,32,102,97,105,108,101,100,46,0,85,110,97,98,108,101,32,116,111,32,105,110,105,116,105,97,108,105,122,101,32,83,68,76,58,32,37,115,10,0,85,110,97,98,108,101,32,116,111,32,115,101,116,32,118,105,100,101,111,32,109,111,100,101,58,32,37,115,10],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+35310);allocate([79,112,101,110,71,76,32,105,110,105,116,97,108,105,122,101,32,102,97,105,108,101,100,46,0,101,109,115,99,114,105,112,116,101,110,0,35,69,114,114,111,114,32,37,100,10,45,45,62,37,115,10,0,35,69,114,114,111,114,32,37,100,32,105,110,32,108,105,110,101,32,37,100,32,40,37,115,41,10,45,45,62,37,115,10,0,0,83,121,110,99,0,79,86,69,82,32,72,83,80,95,76,73,77,73,84,95,83,84,69,80,32,37,100,10,0,123,32,118,97,114,32,100,105,114,32,61,32,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,59,32,70,83,46,109,107,100,105,114,40,100,105,114,41,59,32,70,83,46,109,111,117,110,116,40,73,68,66,70,83,44,32,123,125,44,32,100,105,114,41,59,32,70,83,46,115,121,110,99,102,115,40,116,114,117,101,44,32,102,117,110,99,116,105,111,110,32,40,101,114,114,41,32,123,32,99,111,110,115,111,108,101,46,108,111,103,40,101,114,114,41,59,32,99,99,97,108,108,40,39,104,115,112,51,100,105,115,104,95,115,121,110,99,95,100,111,110,101,39,44,32,39,118,39,44,32,39,39,44,32,91,93,41,59,32,125,41,59,32,125,0,110,97,109,101,0,101,114,114,111,114,0,115,121,110,99,102,115,0,123,32,118,97,114,32,100,105,114,32,61,32,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,59,32,70,83,46,115,121,110,99,102,115,40,102,117,110,99,116,105,111,110,32,40,101,114,114,41,32,123,32,99,111,110,115,111,108,101,46,108,111,103,40,34,115,121,110,99,102,115,34,44,32,101,114,114,41,59,32,125,41,59,32,125,0,91,71,97,109,101,80,108,97,121,51,68,93,32,37,115,10,0,114,101,116,32,61,61,32,48,0,101,109,115,99,114,105,112,116,101,110,47,109,109,109,97,110,46,99,112,112,0,77,77,77,97,110,0,91,77,77,77,97,110,93,32,76,111,97,100,101,100,32,37,115,32,111,110,32,98,97,110,107,32,35,37,100,0,80,79,83,84,0,227,131,128,227,130,166,227,131,179,227,131,173,227,131,188,227,131,137,228,184,173,227,129,171,227,130,168,227,131,169,227,131,188,227,129,140,231,153,186,231,148,159,227,129,151,227,129,190,227,129,151,227,129,159,40,37,100,58,37,115,41,0,119,98,0,114,43,98,0,123,32,99,111,110,115,111,108,101,46,108,111,103,40,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,41,59,32,125,0,78,56,103,97,109,101,112,108,97,121,57,65,110,105,109,97,116,105,111,110,69,0,100,101,102,97,117,108,116,95,99,108,105,112,0,78,56,103,97,109,101,112,108,97,121,49,51,65,110,105,109,97,116,105,111,110,67,108,105,112,69,0,78,56,103,97,109,101,112,108,97,121,49,53,65,110,105,109,97,116,105,111,110,84,97,114,103,101,116,69,0,78,56,103,97,109,101,112,108,97,121,54,66,117,110,100,108,101,69,0,103,97,109,101,112,108,97,121,47,115,114,99,47,66,117,110,100,108,101,46,99,112,112,0,171,71,80,66,187,13,10,26,10,0,73,110,118,97,108,105,100,32,71,80,66,32,104,101,97,100,101,114,32,102,111,114,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,71,80,66,32,118,101,114,115,105,111,110,32,102,111,114,32,98,117,110,100,108,101,32,39,37,115,39,46,0,85,110,115,117,112,112,111,114,116,101,100,32,118,101,114,115,105,111,110,32,40,37,100,46,37,100,41,32,102,111,114,32,98,117,110,100,108,101,32,39,37,115,39,32,40,101,120,112,101,99,116,101,100,32,37,100,46,37,100,41,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,114,101,102,32,116,97,98,108,101,32,102,111,114,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,114,101,102,32,110,117,109,98,101,114,32,37,100,32,102,111,114,32,98,117,110,100,108,101,32,39,37,115,39,46,0,46,109,97,116,101,114,105,97,108,0,115,101,101,107,84,111,0,78,111,32,111,98,106,101,99,116,32,119,105,116,104,32,110,97,109,101,32,39,37,115,39,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,79,98,106,101,99,116,32,39,37,115,39,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,32,104,97,115,32,116,121,112,101,32,37,100,32,40,101,120,112,101,99,116,101,100,32,116,121,112,101,32,37,100,41,46,0,70,97,105,108,101,100,32,116,111,32,115,101,101,107,32,116,111,32,111,98,106,101,99,116,32,39,37,115,39,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,115,101,101,107,84,111,70,105,114,115,116,84,121,112,101,0,108,111,97,100,83,99,101,110,101,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,115,99,101,110,101,32,119,105,116,104,32,105,100,32,39,37,115,39,32,102,114,111,109,32,98,117,110,100,108,101,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,115,99,101,110,101,32,102,114,111,109,32,98,117,110,100,108,101,59,32,98,117,110,100,108,101,32,99,111,110,116,97,105,110,115,32,110,111,32,115,99,101,110,101,32,111,98,106,101,99,116,115,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,104,101,32,115,99,101,110,101,39,115,32,110,117,109,98,101,114,32,111,102,32,99,104,105,108,100,114,101,110,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,114,101,100,32,99,111,109,112,111,110,101,110,116,32,111,102,32,116,104,101,32,115,99,101,110,101,39,115,32,97,109,98,105,101,110,116,32,99,111,108,111,114,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,103,114,101,101,110,32,99,111,109,112,111,110,101,110,116,32,111,102,32,116,104,101,32,115,99,101,110,101,39,115,32,97,109,98,105,101,110,116,32,99,111,108,111,114,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,98,108,117,101,32,99,111,109,112,111,110,101,110,116,32,111,102,32,116,104,101,32,115,99,101,110,101,39,115,32,97,109,98,105,101,110,116,32,99,111,108,111,114,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,114,101,97,100,78,111,100,101,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,110,111,100,101,32,116,121,112,101,32,102,111,114,32,110,111,100,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,114,97,110,115,102,111,114,109,32,102,111,114,32,110,111,100,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,99,104,105,108,100,114,101,110,32,99,111,117,110,116,32,102,111,114,32,110,111,100,101,32,39,37,115,39,46,0,114,101,97,100,65,110,105,109,97,116,105,111,110,115,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,104,101,32,110,117,109,98,101,114,32,111,102,32,97,110,105,109,97,116,105,111,110,115,32,105,110,32,116,104,101,32,115,99,101,110,101,46,0,114,101,115,111,108,118,101,74,111,105,110,116,82,101,102,101,114,101,110,99,101,115,0,70,97,105,108,101,100,32,116,111,32,115,107,105,112,32,111,118,101,114,32,110,111,100,101,32,116,121,112,101,32,97,110,100,32,116,114,97,110,115,102,111,114,109,32,102,111,114,32,110,111,100,101,32,39,37,115,39,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,108,111,97,100,78,111,100,101,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,104,101,32,110,117,109,98,101,114,32,111,102,32,97,110,105,109,97,116,105,111,110,115,32,102,111,114,32,111,98,106,101,99,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,104,101,32,110,117,109,98,101,114,32,111,102,32,97,110,105,109,97,116,105,111,110,32,99,104,97,110,110,101,108,115,32,102,111,114,32,97,110,105,109,97,116,105,111,110,32,39,37,115,39,46,0,97,110,105,109,97,116,105,111,110,67,104,97,110,110,101,108,67,111,117,110,116,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,97,114,103,101,116,32,105,100,32,102,111,114,32,97,110,105,109,97,116,105,111,110,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,97,114,103,101,116,32,97,116,116,114,105,98,117,116,101,32,102,111,114,32,97,110,105,109,97,116,105,111,110,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,37,115,32,102,111,114,32,37,115,58,32,37,115,0,97,110,105,109,97,116,105,111,110,32,116,97,114,103,101,116,0,70,97,105,108,101,100,32,116,111,32,115,107,105,112,32,111,118,101,114,32,116,97,114,103,101,116,32,97,116,116,114,105,98,117,116,101,32,102,111,114,32,97,110,105,109,97,116,105,111,110,32,39,37,115,39,46,0,115,107,105,112,78,111,100,101,0,70,97,105,108,101,100,32,116,111,32,115,107,105,112,32,110,111,100,101,32,116,121,112,101,32,102,111,114,32,110,111,100,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,115,107,105,112,32,111,118,101,114,32,110,111,100,101,32,116,114,97,110,115,102,111,114,109,32,102,111,114,32,110,111,100,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,115,107,105,112,32,111,118,101,114,32,110,111,100,101,39,115,32,99,104,105,108,100,114,101,110,32,99,111,117,110,116,32,102,111,114,32,110,111,100,101,32,39,37,115,39,46,0,114,101,97,100,67,97,109,101,114,97,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,99,97,109,101,114,97,32,116,121,112,101,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,99,97,109,101,114,97,32,97,115,112,101,99,116,32,114,97,116,105,111,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,99,97,109,101,114,97,32,110,101,97,114,32,112,108,97,110,101,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,99,97,109,101,114,97,32,102,97,114,32,112,108,97,110,101,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,99,97,109,101,114,97,32,102,105,101,108,100,32,111,102,32,118,105,101,119,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,99,97,109,101,114,97,32,122,111,111,109,88,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,99,97,109,101,114,97,32,122,111,111,109,89,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,85,110,115,117,112,112,111,114,116,101,100,32,99,97,109,101,114,97,32,116,121,112,101,32,40,37,100,41,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,114,101,97,100,76,105,103,104,116,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,108,105,103,104,116,32,116,121,112,101,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,108,105,103,104,116,32,99,111,108,111,114,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,112,111,105,110,116,32,108,105,103,104,116,32,114,97,110,103,101,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,115,112,111,116,32,108,105,103,104,116,32,114,97,110,103,101,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,115,112,111,116,32,108,105,103,104,116,32,105,110,110,101,114,32,97,110,103,108,101,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,115,112,111,116,32,108,105,103,104,116,32,111,117,116,101,114,32,97,110,103,108,101,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,85,110,115,117,112,112,111,114,116,101,100,32,108,105,103,104,116,32,116,121,112,101,32,40,37,100,41,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,114,101,97,100,77,111,100,101,108,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,119,104,101,116,104,101,114,32,109,111,100,101,108,32,119,105,116,104,32,109,101,115,104,32,39,37,115,39,32,104,97,115,32,97,32,109,101,115,104,32,115,107,105,110,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,109,97,116,101,114,105,97,108,32,99,111,117,110,116,32,102,111,114,32,109,111,100,101,108,32,119,105,116,104,32,109,101,115,104,32,39,37,115,39,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,35,0,108,111,97,100,77,101,115,104,0,70,97,105,108,101,100,32,116,111,32,115,97,118,101,32,116,104,101,32,99,117,114,114,101,110,116,32,102,105,108,101,32,112,111,115,105,116,105,111,110,32,98,101,102,111,114,101,32,108,111,97,100,105,110,103,32,109,101,115,104,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,99,97,116,101,32,114,101,102,32,102,111,114,32,109,101,115,104,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,109,101,115,104,32,100,97,116,97,32,102,111,114,32,109,101,115,104,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,109,101,115,104,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,109,101,115,104,32,112,97,114,116,32,40,119,105,116,104,32,105,110,100,101,120,32,37,100,41,32,102,111,114,32,109,101,115,104,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,115,116,111,114,101,32,102,105,108,101,32,112,111,105,110,116,101,114,32,97,102,116,101,114,32,108,111,97,100,105,110,103,32,109,101,115,104,32,39,37,115,39,46,0,114,101,97,100,77,101,115,104,83,107,105,110,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,98,105,110,100,32,115,104,97,112,101,32,102,111,114,32,109,101,115,104,32,115,107,105,110,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,106,111,105,110,116,32,99,111,117,110,116,32,102,111,114,32,109,101,115,104,32,115,107,105,110,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,73,110,118,97,108,105,100,32,106,111,105,110,116,32,99,111,117,110,116,32,40,109,117,115,116,32,98,101,32,103,114,101,97,116,101,114,32,116,104,97,110,32,48,41,32,102,111,114,32,109,101,115,104,32,115,107,105,110,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,110,117,109,98,101,114,32,111,102,32,106,111,105,110,116,32,98,105,110,100,32,112,111,115,101,115,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,106,111,105,110,116,32,98,105,110,100,32,112,111,115,101,32,109,97,116,114,105,120,32,40,102,111,114,32,106,111,105,110,116,32,119,105,116,104,32,105,110,100,101,120,32,37,100,41,32,105,110,32,98,117,110,100,108,101,32,39,37,115,39,46,0,114,101,97,100,65,110,105,109,97,116,105,111,110,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,97,110,105,109,97,116,105,111,110,32,99,104,97,110,110,101,108,32,99,111,117,110,116,32,102,111,114,32,97,110,105,109,97,116,105,111,110,32,39,37,115,39,46,0,114,101,97,100,65,110,105,109,97,116,105,111,110,67,104,97,110,110,101,108,0,70,97,105,108,101,100,32,116,111,32,102,105,110,100,32,116,104,101,32,97,110,105,109,97,116,105,111,110,32,116,97,114,103,101,116,32,40,119,105,116,104,32,105,100,32,39,37,115,39,41,32,102,111,114,32,97,110,105,109,97,116,105,111,110,32,39,37,115,39,46,0,114,101,97,100,77,101,115,104,68,97,116,97,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,118,101,114,116,101,120,32,101,108,101,109,101,110,116,32,99,111,117,110,116,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,109,101,115,104,32,100,97,116,97,59,32,105,110,118,97,108,105,100,32,118,101,114,116,101,120,32,101,108,101,109,101,110,116,32,99,111,117,110,116,32,40,109,117,115,116,32,98,101,32,103,114,101,97,116,101,114,32,116,104,97,110,32,48,41,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,118,101,114,116,101,120,32,117,115,97,103,101,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,118,101,114,116,101,120,32,115,105,122,101,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,118,101,114,116,101,120,32,98,121,116,101,32,99,111,117,110,116,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,109,101,115,104,32,100,97,116,97,59,32,105,110,118,97,108,105,100,32,118,101,114,116,101,120,32,98,121,116,101,32,99,111,117,110,116,32,111,102,32,48,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,118,101,114,116,101,120,32,100,97,116,97,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,109,101,115,104,32,98,111,117,110,100,105,110,103,32,98,111,120,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,109,101,115,104,32,98,111,117,110,100,105,110,103,32,115,112,104,101,114,101,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,109,101,115,104,32,112,97,114,116,32,99,111,117,110,116,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,112,114,105,109,105,116,105,118,101,32,116,121,112,101,32,102,111,114,32,109,101,115,104,32,112,97,114,116,32,119,105,116,104,32,105,110,100,101,120,32,37,100,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,105,110,100,101,120,32,102,111,114,109,97,116,32,102,111,114,32,109,101,115,104,32,112,97,114,116,32,119,105,116,104,32,105,110,100,101,120,32,37,100,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,105,110,100,101,120,32,98,121,116,101,32,99,111,117,110,116,32,102,111,114,32,109,101,115,104,32,112,97,114,116,32,119,105,116,104,32,105,110,100,101,120,32,37,100,46,0,85,110,115,117,112,112,111,114,116,101,100,32,105,110,100,101,120,32,102,111,114,109,97,116,32,102,111,114,32,109,101,115,104,32,112,97,114,116,32,119,105,116,104,32,105,110,100,101,120,32,37,100,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,105,110,100,101,120,32,100,97,116,97,32,102,111,114,32,109,101,115,104,32,112,97,114,116,32,119,105,116,104,32,105,110,100,101,120,32,37,100,46,0,77,101,115,104,32,100,97,116,97,32,85,82,76,32,109,117,115,116,32,98,101,32,110,111,110,45,101,109,112,116,121,46,0,73,110,118,97,108,105,100,32,109,101,115,104,32,100,97,116,97,32,85,82,76,32,39,37,115,39,32,40,109,117,115,116,32,98,101,32,111,102,32,116,104,101,32,102,111,114,109,32,39,98,117,110,100,108,101,35,105,100,39,41,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,98,117,110,100,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,114,101,102,32,102,114,111,109,32,98,117,110,100,108,101,32,39,37,115,39,32,102,111,114,32,109,101,115,104,32,119,105,116,104,32,105,100,32,39,37,115,39,46,0,108,111,97,100,70,111,110,116,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,114,101,102,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,102,111,110,116,32,102,97,109,105,108,121,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,115,116,121,108,101,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,115,105,122,101,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,103,108,121,112,104,32,99,111,117,110,116,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,73,110,118,97,108,105,100,32,103,108,121,112,104,32,99,111,117,110,116,32,40,109,117,115,116,32,98,101,32,103,114,101,97,116,101,114,32,116,104,97,110,32,48,41,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,103,108,121,112,104,115,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,101,120,116,117,114,101,32,119,105,100,116,104,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,101,120,116,117,114,101,32,104,101,105,103,104,116,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,101,120,116,117,114,101,32,98,121,116,101,32,99,111,117,110,116,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,73,110,118,97,108,105,100,32,116,101,120,116,117,114,101,32,98,121,116,101,32,99,111,117,110,116,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,101,120,116,117,114,101,32,100,97,116,97,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,116,101,120,116,117,114,101,32,102,111,114,32,102,111,110,116,32,39,37,115,39,46,0,114,101,97,100,65,114,114,97,121,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,104,101,32,108,101,110,103,116,104,32,111,102,32,97,110,32,97,114,114,97,121,32,111,102,32,100,97,116,97,32,40,116,111,32,98,101,32,114,101,97,100,32,105,110,116,111,32,97,32,115,116,100,58,58,118,101,99,116,111,114,41,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,97,110,32,97,114,114,97,121,32,111,102,32,100,97,116,97,32,102,114,111,109,32,98,117,110,100,108,101,32,40,105,110,116,111,32,97,32,115,116,100,58,58,118,101,99,116,111,114,41,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,104,101,32,108,101,110,103,116,104,32,111,102,32,97,110,32,97,114,114,97,121,32,111,102,32,100,97,116,97,32,40,116,111,32,98,101,32,114,101,97,100,32,105,110,116,111,32,97,32,115,116,100,58,58,118,101,99,116,111,114,32,119,105,116,104,32,97,32,115,112,101,99,105,102,105,101,100,32,115,105,110,103,108,101,32,101,108,101,109,101,110,116,32,114,101,97,100,32,115,105,122,101,41,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,97,110,32,97,114,114,97,121,32,111,102,32,100,97,116,97,32,102,114,111,109,32,98,117,110,100,108,101,32,40,105,110,116,111,32,97,32,115,116,100,58,58,118,101,99,116,111,114,32,119,105,116,104,32,97,32,115,112,101,99,105,102,105,101,100,32,115,105,110,103,108,101,32,101,108,101,109,101,110,116,32,114,101,97,100,32,115,105,122,101,41,46,0,114,101,97,100,83,116,114,105,110,103,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,104,101,32,108,101,110,103,116,104,32,111,102,32,97,32,115,116,114,105,110,103,32,102,114,111,109,32,97,32,98,117,110,100,108,101,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,115,116,114,105,110,103,32,102,114,111,109,32,98,117,110,100,108,101,46,0,78,56,103,97,109,101,112,108,97,121,54,67,97,109,101,114,97,69,0,78,56,103,97,109,101,112,108,97,121,57,84,114,97,110,115,102,111,114,109,56,76,105,115,116,101,110,101,114,69,0,78,56,103,97,109,101,112,108,97,121,53,67,117,114,118,101,69,0,105,110,100,101,120,32,60,32,95,112,111,105,110,116,67,111,117,110,116,32,38,38,32,116,105,109,101,32,62,61,32,48,46,48,102,32,38,38,32,116,105,109,101,32,60,61,32,49,46,48,102,32,38,38,32,33,40,95,112,111,105,110,116,67,111,117,110,116,32,62,32,49,32,38,38,32,105,110,100,101,120,32,61,61,32,48,32,38,38,32,116,105,109,101,32,33,61,32,48,46,48,102,41,32,38,38,32,33,40,95,112,111,105,110,116,67,111,117,110,116,32,33,61,32,49,32,38,38,32,105,110,100,101,120,32,61,61,32,95,112,111,105,110,116,67,111,117,110,116,32,45,32,49,32,38,38,32,116,105,109,101,32,33,61,32,49,46,48,102,41,0,103,97,109,101,112,108,97,121,47,115,114,99,47,67,117,114,118,101,46,99,112,112,0,115,101,116,80,111,105,110,116,0,101,118,97,108,117,97,116,101,0,100,115,116,32,38,38,32,115,116,97,114,116,84,105,109,101,32,62,61,32,48,46,48,102,32,38,38,32,115,116,97,114,116,84,105,109,101,32,60,61,32,101,110,100,84,105,109,101,32,38,38,32,101,110,100,84,105,109,101,32,60,61,32,49,46,48,102,32,38,38,32,108,111,111,112,66,108,101,110,100,84,105,109,101,32,62,61,32,48,46,48,102,0,111,102,102,115,101,116,32,60,61,32,40,95,99,111,109,112,111,110,101,110,116,67,111,117,110,116,32,45,32,52,41,0,115,101,116,81,117,97,116,101,114,110,105,111,110,79,102,102,115,101,116,0,78,56,103,97,109,101,112,108,97,121,54,69,102,102,101,99,116,69,0,99,114,101,97,116,101,70,114,111,109,70,105,108,101,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,118,101,114,116,101,120,32,115,104,97,100,101,114,32,102,114,111,109,32,102,105,108,101,32,39,37,115,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,69,102,102,101,99,116,46,99,112,112,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,102,114,97,103,109,101,110,116,32,115,104,97,100,101,114,32,102,114,111,109,32,102,105,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,101,102,102,101,99,116,32,102,114,111,109,32,115,104,97,100,101,114,115,32,39,37,115,39,44,32,39,37,115,39,46,0,35,100,101,102,105,110,101,32,0,10,35,100,101,102,105,110,101,32,0,99,114,101,97,116,101,70,114,111,109,83,111,117,114,99,101,0,67,111,109,112,105,108,101,32,102,97,105,108,101,100,32,102,111,114,32,118,101,114,116,101,120,32,115,104,97,100,101,114,32,39,37,115,39,32,119,105,116,104,32,101,114,114,111,114,32,39,37,115,39,46,0,67,111,109,112,105,108,101,32,102,97,105,108,101,100,32,102,111,114,32,102,114,97,103,109,101,110,116,32,115,104,97,100,101,114,32,40,37,115,41,58,32,37,115,0,78,85,76,76,0,76,105,110,107,105,110,103,32,112,114,111,103,114,97,109,32,102,97,105,108,101,100,32,40,37,115,44,37,115,41,58,32,37,115,0,46,101,114,114,0,35,105,110,99,108,117,100,101,0,114,101,112,108,97,99,101,73,110,99,108,117,100,101,115,0,67,111,109,112,105,108,101,32,102,97,105,108,101,100,32,102,111,114,32,115,104,97,100,101,114,32,39,37,115,39,32,109,105,115,115,105,110,103,32,108,101,97,100,105,110,103,32,34,46,0,67,111,109,112,105,108,101,32,102,97,105,108,101,100,32,102,111,114,32,115,104,97,100,101,114,32,39,37,115,39,32,109,105,115,115,105,110,103,32,116,114,97,105,108,105,110,103,32,34,46,0,67,111,109,112,105,108,101,32,102,97,105,108,101,100,32,102,111,114,32,115,104,97,100,101,114,32,39,37,115,39,32,105,110,118,97,108,105,100,32,102,105,108,101,112,97,116,104,46,0,78,56,103,97,109,101,112,108,97,121,49,48,70,105,108,101,83,116,114,101,97,109,69,0,112,114,111,112,101,114,116,105,101,115,0,103,97,109,101,112,108,97,121,47,115,114,99,47,70,105,108,101,83,121,115,116,101,109,46,99,112,112,0,108,111,97,100,82,101,115,111,117,114,99,101,65,108,105,97,115,101,115,0,114,98,0,114,101,97,100,65,108,108,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,102,105,108,101,58,32,37,115,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,99,111,109,112,108,101,116,101,32,99,111,110,116,101,110,116,115,32,111,102,32,102,105,108,101,32,39,37,115,39,32,40,97,109,111,117,110,116,32,114,101,97,100,32,118,115,46,32,102,105,108,101,32,115,105,122,101,58,32,37,117,32,60,32,37,117,41,46,0,78,56,103,97,109,101,112,108,97,121,54,83,116,114,101,97,109,69,0,78,56,103,97,109,101,112,108,97,121,52,70,111,110,116,69,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,102,111,110,116,32,98,117,110,100,108,101,32,39,37,115,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,70,111,110,116,46,99,112,112,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,102,111,110,116,32,119,105,116,104,111,117,116,32,101,120,112,108,105,99,105,116,32,105,100,59,32,116,104,101,32,102,105,114,115,116,32,111,98,106,101,99,116,32,105,110,32,116,104,101,32,102,111,110,116,32,98,117,110,100,108,101,32,104,97,115,32,97,32,110,117,108,108,32,105,100,46,0,114,101,115,47,115,104,97,100,101,114,115,47,102,111,110,116,46,118,101,114,116,0,114,101,115,47,115,104,97,100,101,114,115,47,102,111,110,116,46,102,114,97,103,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,101,102,102,101,99,116,32,102,111,114,32,102,111,110,116,46,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,98,97,116,99,104,32,102,111,114,32,102,111,110,116,46,0,32,13,10,9,0,13,10,0,103,101,116,74,117,115,116,105,102,121,0,70,97,105,108,101,100,32,116,111,32,103,101,116,32,99,111,114,114,101,115,112,111,110,100,105,110,103,32,102,111,110,116,32,106,117,115,116,105,102,105,99,97,116,105,111,110,32,102,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,118,97,108,117,101,32,39,37,115,39,46,0,78,56,103,97,109,101,112,108,97,121,52,71,97,109,101,69,0,103,97,109,101,46,99,111,110,102,105,103,0,97,108,105,97,115,101,115,0,103,97,109,101,112,97,100,115,0,103,97,109,101,112,97,100,0,78,56,103,97,109,101,112,108,97,121,49,50,84,105,109,101,76,105,115,116,101,110,101,114,69,0,78,56,103,97,109,101,112,108,97,121,55,71,97,109,101,112,97,100,69,0,78,111,110,101,0,86,105,114,116,117,97,108,0,65,0,66,85,84,84,79,78,95,65,0,66,0,66,85,84,84,79,78,95,66,0,67,0,66,85,84,84,79,78,95,67,0,88,0,66,85,84,84,79,78,95,88,0,89,0,66,85,84,84,79,78,95,89,0,90,0,66,85,84,84,79,78,95,90,0,77,69,78,85,49,0,66,85,84,84,79,78,95,77,69,78,85,49,0,77,69,78,85,50,0,66,85,84,84,79,78,95,77,69,78,85,50,0,77,69,78,85,51,0,66,85,84,84,79,78,95,77,69,78,85,51,0,77,69,78,85,52,0,66,85,84,84,79,78,95,77,69,78,85,52,0,76,49,0,66,85,84,84,79,78,95,76,49,0,76,50,0,66,85,84,84,79,78,95,76,50,0,76,51,0,66,85,84,84,79,78,95,76,51,0,82,49,0,66,85,84,84,79,78,95,82,49,0,82,50,0,66,85,84,84,79,78,95,82,50,0,82,51,0,66,85,84,84,79,78,95,82,51,0,85,80,0,66,85,84,84,79,78,95,85,80,0,68,79,87,78,0,66,85,84,84,79,78,95,68,79,87,78,0,76,69,70,84,0,66,85,84,84,79,78,95,76,69,70,84,0,82,73,71,72,84,0,66,85,84,84,79,78,95,82,73,71,72,84,0,103,101,116,66,117,116,116,111,110,77,97,112,112,105,110,103,70,114,111,109,83,116,114,105,110,103,0,85,110,107,110,111,119,110,32,71,97,109,101,112,97,100,66,117,116,116,111,110,32,115,116,114,105,110,103,46,0,78,56,103,97,109,101,112,108,97,121,53,74,111,105,110,116,69,0,78,56,103,97,109,101,112,108,97,121,53,76,105,103,104,116,69,0,126,76,105,103,104,116,0,73,110,118,97,108,105,100,32,108,105,103,104,116,32,116,121,112,101,32,40,37,100,41,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,76,105,103,104,116,46,99,112,112,0,85,110,115,117,112,112,111,114,116,101,100,32,108,105,103,104,116,32,116,121,112,101,32,40,37,100,41,46,0,115,101,116,67,111,108,111,114,0,103,101,116,82,97,110,103,101,0,91,76,111,103,103,101,114,58,58,76,101,118,101,108,93,115,0,78,56,103,97,109,101,112,108,97,121,56,77,97,116,101,114,105,97,108,69,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,109,97,116,101,114,105,97,108,32,102,114,111,109,32,102,105,108,101,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,77,97,116,101,114,105,97,108,46,99,112,112,0,109,97,116,101,114,105,97,108,0,80,114,111,112,101,114,116,105,101,115,32,111,98,106,101,99,116,32,109,117,115,116,32,98,101,32,110,111,110,45,110,117,108,108,32,97,110,100,32,104,97,118,101,32,110,97,109,101,115,112,97,99,101,32,101,113,117,97,108,32,116,111,32,39,109,97,116,101,114,105,97,108,39,46,0,116,101,99,104,110,105,113,117,101,0,112,97,115,115,0,118,101,114,116,101,120,83,104,97,100,101,114,0,102,114,97,103,109,101,110,116,83,104,97,100,101,114,0,100,101,102,105,110,101,115,0,115,97,109,112,108,101,114,0,108,111,97,100,82,101,110,100,101,114,83,116,97,116,101,0,84,101,120,116,117,114,101,32,115,97,109,112,108,101,114,32,105,115,32,109,105,115,115,105,110,103,32,114,101,113,117,105,114,101,100,32,117,110,105,102,111,114,109,32,110,97,109,101,46,0,84,101,120,116,117,114,101,32,115,97,109,112,108,101,114,32,39,37,115,39,32,105,115,32,109,105,115,115,105,110,103,32,114,101,113,117,105,114,101,100,32,105,109,97,103,101,32,102,105,108,101,32,112,97,116,104,46,0,109,105,112,109,97,112,0,119,114,97,112,83,0,119,114,97,112,84,0,109,105,110,70,105,108,116,101,114,0,109,97,103,70,105,108,116,101,114,0,114,101,110,100,101,114,83,116,97,116,101,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,112,97,115,115,32,102,111,114,32,109,97,116,101,114,105,97,108,46,0,108,111,97,100,80,97,115,115,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,112,97,115,115,32,102,111,114,32,116,101,99,104,110,105,113,117,101,46,0,112,97,114,115,101,84,101,120,116,117,114,101,70,105,108,116,101,114,77,111,100,101,0,84,101,120,116,117,114,101,32,102,105,108,116,101,114,32,109,111,100,101,32,115,116,114,105,110,103,32,109,117,115,116,32,98,101,32,110,111,110,45,110,117,108,108,32,97,110,100,32,110,111,110,45,101,109,112,116,121,46,0,78,69,65,82,69,83,84,0,76,73,78,69,65,82,0,78,69,65,82,69,83,84,95,77,73,80,77,65,80,95,78,69,65,82,69,83,84,0,76,73,78,69,65,82,95,77,73,80,77,65,80,95,78,69,65,82,69,83,84,0,78,69,65,82,69,83,84,95,77,73,80,77,65,80,95,76,73,78,69,65,82,0,76,73,78,69,65,82,95,77,73,80,77,65,80,95,76,73,78,69,65,82,0,85,110,115,117,112,112,111,114,116,101,100,32,116,101,120,116,117,114,101,32,102,105,108,116,101,114,32,109,111,100,101,32,115,116,114,105,110,103,32,40,39,37,115,39,41,46,0,112,97,114,115,101,84,101,120,116,117,114,101,87,114,97,112,77,111,100,101,0,84,101,120,116,117,114,101,32,119,114,97,112,32,109,111,100,101,32,115,116,114,105,110,103,32,109,117,115,116,32,98,101,32,110,111,110,45,110,117,108,108,32,97,110,100,32,110,111,110,45,101,109,112,116,121,46,0,82,69,80,69,65,84,0,67,76,65,77,80,0,85,110,115,117,112,112,111,114,116,101,100,32,116,101,120,116,117,114,101,32,119,114,97,112,32,109,111,100,101,32,115,116,114,105,110,103,32,40,39,37,115,39,41,46,0,78,56,103,97,109,101,112,108,97,121,49,55,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,69,0,98,105,110,100,0,87,97,114,110,105,110,103,58,32,77,97,116,101,114,105,97,108,32,112,97,114,97,109,101,116,101,114,32,39,37,115,39,32,110,111,116,32,102,111,117,110,100,32,105,110,32,101,102,102,101,99,116,32,39,37,115,39,46,0,85,110,115,117,112,112,111,114,116,101,100,32,109,97,116,101,114,105,97,108,32,112,97,114,97,109,101,116,101,114,32,116,121,112,101,32,40,37,100,41,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,46,99,112,112,0,103,101,116,65,110,105,109,97,116,105,111,110,80,114,111,112,101,114,116,121,67,111,109,112,111,110,101,110,116,67,111,117,110,116,0,103,101,116,65,110,105,109,97,116,105,111,110,80,114,111,112,101,114,116,121,86,97,108,117,101,0,115,101,116,65,110,105,109,97,116,105,111,110,80,114,111,112,101,114,116,121,86,97,108,117,101,0,99,108,111,110,101,73,110,116,111,0,85,110,115,117,112,112,111,114,116,101,100,32,109,97,116,101,114,105,97,108,32,112,97,114,97,109,101,116,101,114,32,116,121,112,101,40,37,100,41,46,0,99,114,101,97,116,101,80,101,114,115,112,101,99,116,105,118,101,0,73,110,118,97,108,105,100,32,102,105,101,108,100,32,111,102,32,118,105,101,119,32,118,97,108,117,101,32,40,37,100,41,32,99,97,117,115,101,115,32,97,116,116,101,109,112,116,101,100,32,99,97,108,99,117,108,97,116,105,111,110,32,116,97,110,40,37,100,41,44,32,119,104,105,99,104,32,105,115,32,117,110,100,101,102,105,110,101,100,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,77,97,116,114,105,120,46,99,112,112,0,78,56,103,97,109,101,112,108,97,121,52,77,101,115,104,69,0,99,114,101,97,116,101,81,117,97,100,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,109,101,115,104,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,77,101,115,104,46,99,112,112,0,114,101,115,105,122,101,0,73,110,118,97,108,105,100,32,114,101,115,105,122,101,32,99,97,112,97,99,105,116,121,32,40,48,41,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,77,101,115,104,66,97,116,99,104,46,99,112,112,0,85,110,115,117,112,112,111,114,116,101,100,32,112,114,105,109,105,116,105,118,101,32,116,121,112,101,32,102,111,114,32,109,101,115,104,32,98,97,116,99,104,32,40,37,100,41,46,0,73,110,100,101,120,32,99,97,112,97,99,105,116,121,32,105,115,32,103,114,101,97,116,101,114,32,116,104,97,110,32,116,104,101,32,109,97,120,105,109,117,109,32,117,110,115,105,103,110,101,100,32,115,104,111,114,116,32,118,97,108,117,101,32,40,37,100,32,62,32,37,100,41,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,77,101,115,104,80,97,114,116,46,99,112,112,0,115,101,116,73,110,100,101,120,68,97,116,97,0,78,56,103,97,109,101,112,108,97,121,56,77,101,115,104,83,107,105,110,69,0,78,56,103,97,109,101,112,108,97,121,53,77,111,100,101,108,69,0,103,97,109,101,112,108,97,121,47,115,114,99,47,77,111,100,101,108,46,99,112,112,0,100,114,97,119,87,105,114,101,102,114,97,109,101,0,99,108,111,110,101,0,70,97,105,108,101,100,32,116,111,32,99,108,111,110,101,32,109,111,100,101,108,46,0,70,97,105,108,101,100,32,116,111,32,99,108,111,110,101,32,109,97,116,101,114,105,97,108,32,102,111,114,32,109,111,100,101,108,46,0,78,56,103,97,109,101,112,108,97,121,52,78,111,100,101,69,0,78,56,103,97,109,101,112,108,97,121,52,80,97,115,115,69,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,101,102,102,101,99,116,32,102,111,114,32,112,97,115,115,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,80,97,115,115,46,99,112,112,0,78,56,103,97,109,101,112,108,97,121,49,54,80,104,121,115,105,99,115,67,104,97,114,97,99,116,101,114,69,0,78,56,103,97,109,101,112,108,97,121,49,54,80,104,121,115,105,99,115,67,104,97,114,97,99,116,101,114,49,53,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,69,0,49,55,98,116,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,0,78,56,103,97,109,101,112,108,97,121,51,50,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,56,103,97,109,101,112,108,97,121,50,50,80,104,121,115,105,99,115,67,111,108,108,105,115,105,111,110],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+36561);allocate([79,98,106,101,99,116,69,0,78,56,103,97,109,101,112,108,97,121,50,50,80,104,121,115,105,99,115,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,49,56,80,104,121,115,105,99,115,77,111,116,105,111,110,83,116,97,116,101,69,0,49,51,98,116,77,111,116,105,111,110,83,116,97,116,101,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,56,103,97,109,101,112,108,97,121,50,49,80,104,121,115,105,99,115,67,111,108,108,105,115,105,111,110,83,104,97,112,101,69,0,78,56,103,97,109,101,112,108,97,121,49,55,80,104,121,115,105,99,115,67,111,110,116,114,111,108,108,101,114,49,55,67,111,108,108,105,115,105,111,110,67,97,108,108,98,97,99,107,69,0,78,56,103,97,109,101,112,108,97,121,49,55,80,104,121,115,105,99,115,67,111,110,116,114,111,108,108,101,114,69,0,78,56,103,97,109,101,112,108,97,121,49,55,80,104,121,115,105,99,115,67,111,110,116,114,111,108,108,101,114,49,49,68,101,98,117,103,68,114,97,119,101,114,69,0,115,116,97,116,117,115,69,118,101,110,116,0,91,80,104,121,115,105,99,115,67,111,110,116,114,111,108,108,101,114,58,58,76,105,115,116,101,110,101,114,58,58,69,118,101,110,116,84,121,112,101,93,0,103,97,109,101,112,108,97,121,47,115,114,99,47,80,104,121,115,105,99,115,67,111,110,116,114,111,108,108,101,114,46,99,112,112,0,97,100,100,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,108,108,105,115,105,111,110,32,111,98,106,101,99,116,32,116,121,112,101,32,40,37,100,41,46,0,114,101,109,111,118,101,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,99,114,101,97,116,101,83,104,97,112,101,0,69,109,112,116,121,32,104,101,105,103,104,116,102,105,101,108,100,32,99,111,108,108,105,115,105,111,110,32,115,104,97,112,101,115,32,99,97,110,32,111,110,108,121,32,98,101,32,117,115,101,100,32,111,110,32,110,111,100,101,115,32,116,104,97,116,32,104,97,118,101,32,97,110,32,97,116,116,97,99,104,101,100,32,84,101,114,114,97,105,110,46,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,108,108,105,115,105,111,110,32,115,104,97,112,101,32,116,121,112,101,32,40,37,100,41,46,0,99,114,101,97,116,101,77,101,115,104,0,77,101,115,104,32,114,105,103,105,100,32,98,111,100,105,101,115,32,97,114,101,32,99,117,114,114,101,110,116,108,121,32,111,110,108,121,32,115,117,112,112,111,114,116,101,100,32,111,110,32,109,101,115,104,101,115,32,119,105,116,104,32,84,82,73,65,78,71,76,69,83,32,112,114,105,109,105,116,105,118,101,32,116,121,112,101,46,0,67,97,110,110,111,116,32,99,114,101,97,116,101,32,109,101,115,104,32,114,105,103,105,100,32,98,111,100,121,32,102,111,114,32,109,101,115,104,32,119,105,116,104,111,117,116,32,118,97,108,105,100,32,85,82,76,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,109,101,115,104,32,100,97,116,97,32,102,114,111,109,32,117,114,108,32,39,37,115,39,46,0,85,110,115,117,112,112,111,114,116,101,100,32,105,110,100,101,120,32,102,111,114,109,97,116,32,40,37,100,41,46,0,117,110,105,102,111,114,109,32,109,97,116,52,32,117,95,118,105,101,119,80,114,111,106,101,99,116,105,111,110,77,97,116,114,105,120,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,97,95,112,111,115,105,116,105,111,110,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,97,95,99,111,108,111,114,59,10,118,97,114,121,105,110,103,32,118,101,99,52,32,118,95,99,111,108,111,114,59,10,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,10,32,32,32,32,118,95,99,111,108,111,114,32,61,32,97,95,99,111,108,111,114,59,10,32,32,32,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,117,95,118,105,101,119,80,114,111,106,101,99,116,105,111,110,77,97,116,114,105,120,32,42,32,97,95,112,111,115,105,116,105,111,110,59,10,125,0,112,114,101,99,105,115,105,111,110,32,104,105,103,104,112,32,102,108,111,97,116,59,10,118,97,114,121,105,110,103,32,118,101,99,52,32,118,95,99,111,108,111,114,59,10,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,10,32,32,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,118,95,99,111,108,111,114,59,10,125,0,114,101,112,111,114,116,69,114,114,111,114,87,97,114,110,105,110,103,0,100,114,97,119,51,100,84,101,120,116,0,80,104,121,115,105,99,115,32,100,101,98,117,103,32,100,114,97,119,105,110,103,58,32,51,68,32,116,101,120,116,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,46,0,49,50,98,116,73,68,101,98,117,103,68,114,97,119,0,49,57,98,116,71,104,111,115,116,80,97,105,114,67,97,108,108,98,97,99,107,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,67,108,111,115,101,115,116,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,56,103,97,109,101,112,108,97,121,49,56,80,104,121,115,105,99,115,71,104,111,115,116,79,98,106,101,99,116,69,0,78,56,103,97,109,101,112,108,97,121,49,54,80,104,121,115,105,99,115,82,105,103,105,100,66,111,100,121,69,0,78,56,103,97,109,101,112,108,97,121,49,52,80,104,121,115,105,99,115,86,101,104,105,99,108,101,69,0,78,56,103,97,109,101,112,108,97,121,50,57,67,108,111,115,101,115,116,78,111,116,77,101,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,56,103,97,109,101,112,108,97,121,50,49,86,101,104,105,99,108,101,78,111,116,77,101,82,97,121,99,97,115,116,101,114,69,0,49,56,98,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,78,56,103,97,109,101,112,108,97,121,49,57,80,104,121,115,105,99,115,86,101,104,105,99,108,101,87,104,101,101,108,69,0,46,47,0,103,108,101,119,73,110,105,116,0,71,76,32,118,101,114,115,105,111,110,58,32,37,100,46,37,100,10,0,1,114,101,97,100,80,114,111,112,101,114,116,105,101,115,0,69,114,114,111,114,32,114,101,97,100,105,110,103,32,108,105,110,101,32,102,114,111,109,32,102,105,108,101,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,80,114,111,112,101,114,116,105,101,115,46,99,112,112,0,47,47,0,61,0,69,114,114,111,114,32,112,97,114,115,105,110,103,32,112,114,111,112,101,114,116,105,101,115,32,102,105,108,101,58,32,97,116,116,114,105,98,117,116,101,32,119,105,116,104,111,117,116,32,110,97,109,101,46,0,69,114,114,111,114,32,112,97,114,115,105,110,103,32,112,114,111,112,101,114,116,105,101,115,32,102,105,108,101,58,32,97,116,116,114,105,98,117,116,101,32,119,105,116,104,32,110,97,109,101,32,40,39,37,115,39,41,32,98,117,116,32,110,111,32,118,97,108,117,101,46,0,32,9,10,123,0,69,114,114,111,114,32,112,97,114,115,105,110,103,32,112,114,111,112,101,114,116,105,101,115,32,102,105,108,101,58,32,102,97,105,108,101,100,32,116,111,32,100,101,116,101,114,109,105,110,101,32,97,32,118,97,108,105,100,32,116,111,107,101,110,32,102,111,114,32,108,105,110,101,32,39,37,115,39,46,0,58,123,0,123,0,70,97,105,108,101,100,32,116,111,32,115,101,101,107,32,98,97,99,107,32,116,111,32,98,101,102,111,114,101,32,97,32,39,125,39,32,99,104,97,114,97,99,116,101,114,32,105,110,32,112,114,111,112,101,114,116,105,101,115,32,102,105,108,101,46,0,70,97,105,108,101,100,32,116,111,32,115,101,101,107,32,116,111,32,105,109,109,101,100,105,97,116,101,108,121,32,97,102,116,101,114,32,97,32,39,125,39,32,99,104,97,114,97,99,116,101,114,32,105,110,32,112,114,111,112,101,114,116,105,101,115,32,102,105,108,101,46,0,70,97,105,108,101,100,32,116,111,32,115,101,101,107,32,98,97,99,107,119,97,114,100,115,32,97,32,115,105,110,103,108,101,32,99,104,97,114,97,99,116,101,114,32,97,102,116,101,114,32,116,101,115,116,105,110,103,32,105,102,32,116,104,101,32,110,101,120,116,32,108,105,110,101,32,115,116,97,114,116,115,32,119,105,116,104,32,39,123,39,46,0,65,116,116,101,109,112,116,105,110,103,32,116,111,32,99,114,101,97,116,101,32,97,32,80,114,111,112,101,114,116,105,101,115,32,111,98,106,101,99,116,32,102,114,111,109,32,97,110,32,101,109,112,116,121,32,85,82,76,33,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,112,114,111,112,101,114,116,105,101,115,32,102,114,111,109,32,117,114,108,32,39,37,115,39,46,0,103,101,116,80,114,111,112,101,114,116,105,101,115,70,114,111,109,78,97,109,101,115,112,97,99,101,80,97,116,104,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,112,114,111,112,101,114,116,105,101,115,32,111,98,106,101,99,116,32,102,114,111,109,32,117,114,108,46,0,115,107,105,112,87,104,105,116,101,83,112,97,99,101,0,70,97,105,108,101,100,32,116,111,32,115,101,101,107,32,98,97,99,107,119,97,114,100,115,32,111,110,101,32,99,104,97,114,97,99,116,101,114,32,97,102,116,101,114,32,115,107,105,112,112,105,110,103,32,119,104,105,116,101,115,112,97,99,101,46,0,116,114,117,101,0,37,100,0,103,101,116,73,110,116,0,69,114,114,111,114,32,97,116,116,101,109,112,116,105,110,103,32,116,111,32,112,97,114,115,101,32,112,114,111,112,101,114,116,121,32,39,37,115,39,32,97,115,32,97,110,32,105,110,116,101,103,101,114,46,0,37,102,0,103,101,116,70,108,111,97,116,0,69,114,114,111,114,32,97,116,116,101,109,112,116,105,110,103,32,116,111,32,112,97,114,115,101,32,112,114,111,112,101,114,116,121,32,39,37,115,39,32,97,115,32,97,32,102,108,111,97,116,46,0,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,44,37,102,0,103,101,116,77,97,116,114,105,120,0,69,114,114,111,114,32,97,116,116,101,109,112,116,105,110,103,32,116,111,32,112,97,114,115,101,32,112,114,111,112,101,114,116,121,32,39,37,115,39,32,97,115,32,97,32,109,97,116,114,105,120,46,0,37,102,44,37,102,0,103,101,116,86,101,99,116,111,114,50,0,69,114,114,111,114,32,97,116,116,101,109,112,116,105,110,103,32,116,111,32,112,97,114,115,101,32,112,114,111,112,101,114,116,121,32,39,37,115,39,32,97,115,32,97,32,116,119,111,45,100,105,109,101,110,115,105,111,110,97,108,32,118,101,99,116,111,114,46,0,37,102,44,37,102,44,37,102,0,103,101,116,86,101,99,116,111,114,51,0,69,114,114,111,114,32,97,116,116,101,109,112,116,105,110,103,32,116,111,32,112,97,114,115,101,32,112,114,111,112,101,114,116,121,32,39,37,115,39,32,97,115,32,97,32,116,104,114,101,101,45,100,105,109,101,110,115,105,111,110,97,108,32,118,101,99,116,111,114,46,0,37,102,44,37,102,44,37,102,44,37,102,0,103,101,116,86,101,99,116,111,114,52,0,69,114,114,111,114,32,97,116,116,101,109,112,116,105,110,103,32,116,111,32,112,97,114,115,101,32,112,114,111,112,101,114,116,121,32,39,37,115,39,32,97,115,32,97,32,102,111,117,114,45,100,105,109,101,110,115,105,111,110,97,108,32,118,101,99,116,111,114,46,0,103,101,116,67,111,108,111,114,0,37,120,0,69,114,114,111,114,32,97,116,116,101,109,112,116,105,110,103,32,116,111,32,112,97,114,115,101,32,112,114,111,112,101,114,116,121,32,39,37,115,39,32,97,115,32,97,110,32,82,71,66,65,32,99,111,108,111,114,32,40,110,111,116,32,115,112,101,99,105,102,105,101,100,32,97,115,32,97,32,99,111,108,111,114,32,115,116,114,105,110,103,41,46,0,69,114,114,111,114,32,97,116,116,101,109,112,116,105,110,103,32,116,111,32,112,97,114,115,101,32,112,114,111,112,101,114,116,121,32,39,37,115,39,32,97,115,32,97,110,32,82,71,66,65,32,99,111,108,111,114,46,0,78,56,103,97,109,101,112,108,97,121,51,82,101,102,69,0,78,56,103,97,109,101,112,108,97,121,49,49,82,101,110,100,101,114,83,116,97,116,101,69,0,78,56,103,97,109,101,112,108,97,121,49,49,82,101,110,100,101,114,83,116,97,116,101,49,48,83,116,97,116,101,66,108,111,99,107,69,0,83,67,69,78,69,95,76,73,71,72,84,95,68,73,82,69,67,84,73,79,78,0,83,67,69,78,69,95,76,73,71,72,84,95,67,79,76,79,82,0,83,67,69,78,69,95,65,77,66,73,69,78,84,95,67,79,76,79,82,0,77,65,84,82,73,88,95,80,65,76,69,84,84,69,0,67,65,77,69,82,65,95,86,73,69,87,95,80,79,83,73,84,73,79,78,0,67,65,77,69,82,65,95,87,79,82,76,68,95,80,79,83,73,84,73,79,78,0,73,78,86,69,82,83,69,95,84,82,65,78,83,80,79,83,69,95,87,79,82,76,68,95,86,73,69,87,95,77,65,84,82,73,88,0,73,78,86,69,82,83,69,95,84,82,65,78,83,80,79,83,69,95,87,79,82,76,68,95,77,65,84,82,73,88,0,87,79,82,76,68,95,86,73,69,87,95,80,82,79,74,69,67,84,73,79,78,95,77,65,84,82,73,88,0,86,73,69,87,95,80,82,79,74,69,67,84,73,79,78,95,77,65,84,82,73,88,0,87,79,82,76,68,95,86,73,69,87,95,77,65,84,82,73,88,0,80,82,79,74,69,67,84,73,79,78,95,77,65,84,82,73,88,0,86,73,69,87,95,77,65,84,82,73,88,0,87,79,82,76,68,95,77,65,84,82,73,88,0,97,112,112,108,121,65,117,116,111,66,105,110,100,105,110,103,0,85,110,115,117,112,112,111,114,116,101,100,32,97,117,116,111,32,98,105,110,100,105,110,103,32,116,121,112,101,32,40,37,100,41,46,0,98,108,101,110,100,0,98,108,101,110,100,83,114,99,0,115,114,99,66,108,101,110,100,0,98,108,101,110,100,68,115,116,0,100,115,116,66,108,101,110,100,0,99,117,108,108,70,97,99,101,0,99,117,108,108,70,97,99,101,83,105,100,101,0,66,65,67,75,0,70,82,79,78,84,0,70,82,79,78,84,95,65,78,68,95,66,65,67,75,0,112,97,114,115,101,67,117,108,108,70,97,99,101,83,105,100,101,0,85,110,115,117,112,112,111,114,116,101,100,32,99,117,108,108,32,102,97,99,101,32,115,105,100,101,32,118,97,108,117,101,32,40,37,115,41,46,32,87,105,108,108,32,100,101,102,97,117,108,116,32,116,111,32,66,65,67,75,32,105,102,32,101,114,114,111,114,115,32,97,114,101,32,116,114,101,97,116,101,100,32,97,115,32,119,97,114,110,105,110,103,115,41,0,103,97,109,101,112,108,97,121,47,115,114,99,47,82,101,110,100,101,114,83,116,97,116,101,46,99,112,112,0,100,101,112,116,104,84,101,115,116,0,100,101,112,116,104,87,114,105,116,101,0,100,101,112,116,104,70,117,110,99,0,78,69,86,69,82,0,76,69,83,83,0,69,81,85,65,76,0,76,69,81,85,65,76,0,71,82,69,65,84,69,82,0,78,79,84,69,81,85,65,76,0,71,69,81,85,65,76,0,65,76,87,65,89,83,0,112,97,114,115,101,68,101,112,116,104,70,117,110,99,0,85,110,115,117,112,112,111,114,116,101,100,32,100,101,112,116,104,32,102,117,110,99,116,105,111,110,32,118,97,108,117,101,32,40,37,115,41,46,32,87,105,108,108,32,100,101,102,97,117,108,116,32,116,111,32,68,69,80,84,72,95,76,69,83,83,32,105,102,32,101,114,114,111,114,115,32,97,114,101,32,116,114,101,97,116,101,100,32,97,115,32,119,97,114,110,105,110,103,115,41,0,115,101,116,83,116,97,116,101,0,85,110,115,117,112,112,111,114,116,101,100,32,114,101,110,100,101,114,32,115,116,97,116,101,32,115,116,114,105,110,103,32,39,37,115,39,46,0,90,69,82,79,0,79,78,69,0,83,82,67,95,67,79,76,79,82,0,79,78,69,95,77,73,78,85,83,95,83,82,67,95,67,79,76,79,82,0,68,83,84,95,67,79,76,79,82,0,79,78,69,95,77,73,78,85,83,95,68,83,84,95,67,79,76,79,82,0,83,82,67,95,65,76,80,72,65,0,79,78,69,95,77,73,78,85,83,95,83,82,67,95,65,76,80,72,65,0,68,83,84,95,65,76,80,72,65,0,79,78,69,95,77,73,78,85,83,95,68,83,84,95,65,76,80,72,65,0,67,79,78,83,84,65,78,84,95,65,76,80,72,65,0,79,78,69,95,77,73,78,85,83,95,67,79,78,83,84,65,78,84,95,65,76,80,72,65,0,83,82,67,95,65,76,80,72,65,95,83,65,84,85,82,65,84,69,0,112,97,114,115,101,66,108,101,110,100,0,85,110,115,117,112,112,111,114,116,101,100,32,98,108,101,110,100,32,118,97,108,117,101,32,40,37,115,41,46,32,40,87,105,108,108,32,100,101,102,97,117,108,116,32,116,111,32,66,76,69,78,68,95,79,78,69,32,105,102,32,101,114,114,111,114,115,32,97,114,101,32,116,114,101,97,116,101,100,32,97,115,32,119,97,114,110,105,110,103,115,41,0,78,56,103,97,109,101,112,108,97,121,49,55,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,49,56,77,101,116,104,111,100,86,97,108,117,101,66,105,110,100,105,110,103,73,78,83,95,49,49,82,101,110,100,101,114,83,116,97,116,101,69,82,75,78,83,95,55,86,101,99,116,111,114,51,69,69,69,0,78,56,103,97,109,101,112,108,97,121,49,55,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,49,56,77,101,116,104,111,100,65,114,114,97,121,66,105,110,100,105,110,103,73,78,83,95,49,49,82,101,110,100,101,114,83,116,97,116,101,69,80,75,78,83,95,55,86,101,99,116,111,114,52,69,69,69,0,78,56,103,97,109,101,112,108,97,121,49,55,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,49,56,77,101,116,104,111,100,86,97,108,117,101,66,105,110,100,105,110,103,73,78,83,95,49,49,82,101,110,100,101,114,83,116,97,116,101,69,78,83,95,55,86,101,99,116,111,114,51,69,69,69,0,78,56,103,97,109,101,112,108,97,121,49,55,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,49,56,77,101,116,104,111,100,86,97,108,117,101,66,105,110,100,105,110,103,73,78,83,95,49,49,82,101,110,100,101,114,83,116,97,116,101,69,82,75,78,83,95,54,77,97,116,114,105,120,69,69,69,0,78,56,103,97,109,101,112,108,97,121,53,83,99,101,110,101,69,0,108,111,97,100,85,114,108,0,71,111,116,32,97,110,32,101,109,112,116,121,32,102,117,110,99,116,105,111,110,32,110,97,109,101,32,119,104,101,110,32,112,97,114,115,105,110,103,32,102,117,110,99,116,105,111,110,32,117,114,108,32,39,37,115,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,83,99,114,105,112,116,67,111,110,116,114,111,108,108,101,114,46,99,112,112,0,78,56,103,97,109,101,112,108,97,121,49,50,83,99,114,105,112,116,84,97,114,103,101,116,69,0,97,100,100,83,99,114,105,112,116,67,97,108,108,98,97,99,107,0,65,116,116,101,109,112,116,105,110,103,32,116,111,32,97,100,100,32,97,32,115,99,114,105,112,116,32,99,97,108,108,98,97,99,107,32,102,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,101,118,101,110,116,32,39,37,115,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,83,99,114,105,112,116,84,97,114,103,101,116,46,99,112,112,0,114,101,109,111,118,101,83,99,114,105,112,116,67,97,108,108,98,97,99,107,0,65,116,116,101,109,112,116,105,110,103,32,116,111,32,114,101,109,111,118,101,32,97,32,115,99,114,105,112,116,32,99,97,108,108,98,97,99,107,32,102,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,101,118,101,110,116,32,39,37,115,39,46,0,78,56,103,97,109,101,112,108,97,121,49,49,83,112,114,105,116,101,66,97,116,99,104,69,0,114,101,115,47,115,104,97,100,101,114,115,47,115,112,114,105,116,101,46,118,101,114,116,0,114,101,115,47,115,104,97,100,101,114,115,47,115,112,114,105,116,101,46,102,114,97,103,0,85,110,97,98,108,101,32,116,111,32,108,111,97,100,32,115,112,114,105,116,101,32,101,102,102,101,99,116,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,83,112,114,105,116,101,66,97,116,99,104,46,99,112,112,0,78,111,32,117,110,105,102,111,114,109,32,111,102,32,116,121,112,101,32,71,76,95,83,65,77,80,76,69,82,95,50,68,32,102,111,117,110,100,32,105,110,32,115,112,114,105,116,101,32,101,102,102,101,99,116,46,0,117,95,112,114,111,106,101,99,116,105,111,110,77,97,116,114,105,120,0,78,56,103,97,109,101,112,108,97,121,49,55,77,97,116,101,114,105,97,108,80,97,114,97,109,101,116,101,114,49,56,77,101,116,104,111,100,86,97,108,117,101,66,105,110,100,105,110,103,73,78,83,95,49,49,83,112,114,105,116,101,66,97,116,99,104,69,82,75,78,83,95,54,77,97,116,114,105,120,69,69,69,0,78,56,103,97,109,101,112,108,97,121,57,84,101,99,104,110,105,113,117,101,69,0,78,56,103,97,109,101,112,108,97,121,55,84,101,120,116,117,114,101,69,0,78,56,103,97,109,101,112,108,97,121,55,84,101,120,116,117,114,101,55,83,97,109,112,108,101,114,69,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,116,101,120,116,117,114,101,32,102,114,111,109,32,102,105,108,101,32,39,37,115,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,84,101,120,116,117,114,101,46,99,112,112,0,85,110,115,117,112,112,111,114,116,101,100,32,105,109,97,103,101,32,102,111,114,109,97,116,32,40,37,100,41,46,0,99,114,101,97,116,101,67,111,109,112,114,101,115,115,101,100,80,86,82,84,67,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,102,105,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,80,86,82,32,118,101,114,115,105,111,110,46,0,70,97,105,108,101,100,32,116,111,32,115,101,101,107,32,98,97,99,107,119,97,114,100,115,32,116,111,32,98,101,103,105,110,110,105,110,103,32,111,102,32,102,105,108,101,32,97,102,116,101,114,32,114,101,97,100,105,110,103,32,80,86,82,32,118,101,114,115,105,111,110,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,116,101,120,116,117,114,101,32,100,97,116,97,32,102,114,111,109,32,80,86,82,32,102,105,108,101,32,39,37,115,39,46,0,99,114,101,97,116,101,67,111,109,112,114,101,115,115,101,100,68,68,83,0,70,97,105,108,101,100,32,116,111,32,111,112,101,110,32,102,105,108,101,32,39,37,115,39,46,0,68,68,83,32,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,68,68,83,32,102,105,108,101,32,39,37,115,39,58,32,105,110,118,97,108,105,100,32,68,68,83,32,109,97,103,105,99,32,110,117,109,98,101,114,46,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,104,101,97,100,101,114,32,102,111,114,32,68,68,83,32,102,105,108,101,32,39,37,115,39,46,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,109,112,114,101,115,115,101,100,32,116,101,120,116,117,114,101,32,102,111,114,109,97,116,32,40,37,100,41,32,102,111,114,32,68,68,83,32,102,105,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,100,100,115,32,99,111,109,112,114,101,115,115,101,100,32,116,101,120,116,117,114,101,32,98,121,116,101,115,32,102,111,114,32,116,101,120,116,117,114,101,58,32,37,115,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,116,101,120,116,117,114,101,32,102,114,111,109,32,117,110,99,111,109,112,114,101,115,115,101,100,32,68,68,83,32,102,105,108,101,32,39,37,115,39,58,32,85,110,115,117,112,112,111,114,116,101,100,32,99,111,108,111,114,32,102,111,114,109,97,116,32,40,109,117,115,116,32,98,101,32,111,110,101,32,111,102,32,82,56,71,56,66,56,44,32,65,56,82,56,71,56,66,56,44,32,65,56,66,56,71,56,82,56,44,32,88,56,82,56,71,56,66,56,44,32,88,56,66,56,71,56,82,56,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,98,121,116,101,115,32,102,111,114,32,82,71,66,32,100,100,115,32,116,101,120,116,117,114,101,58,32,37,115,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,116,101,120,116,117,114,101,32,102,114,111,109,32,68,68,83,32,102,105,108,101,32,39,37,115,39,58,32,117,110,115,117,112,112,111,114,116,101,100,32,102,108,97,103,115,32,40,37,100,41,46,0,114,101,97,100,67,111,109,112,114,101,115,115,101,100,80,86,82,84,67,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,80,86,82,32,104,101,97,100,101,114,32,100,97,116,97,32,102,111,114,32,102,105,108,101,32,39,37,115,39,46,0,85,110,115,117,112,112,111,114,116,101,100,32,112,105,120,101,108,32,102,111,114,109,97,116,32,105,110,32,80,86,82,32,102,105,108,101,32,39,37,115,39,46,32,40,77,83,66,32,61,61,32,37,100,32,33,61,32,48,41,0,85,110,115,117,112,112,111,114,116,101,100,32,112,105,120,101,108,32,102,111,114,109,97,116,32,118,97,108,117,101,32,40,37,100,41,32,105,110,32,80,86,82,32,102,105,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,115,101,101,107,32,112,97,115,116,32,104,101,97,100,101,114,32,109,101,116,97,32,100,97,116,97,32,105,110,32,80,86,82,32,102,105,108,101,32,39,37,115,39,46,0,114,101,97,100,67,111,109,112,114,101,115,115,101,100,80,86,82,84,67,76,101,103,97,99,121,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,102,105,108,101,32,104,101,97,100,101,114,32,102,111,114,32,112,118,114,116,99,32,102,105,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,112,118,114,116,99,32,102,105,108,101,32,39,37,115,39,58,32,105,110,118,97,108,105,100,32,104,101,97,100,101,114,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,112,118,114,116,99,32,102,105,108,101,32,39,37,115,39,58,32,105,110,118,97,108,105,100,32,112,118,114,116,99,32,99,111,109,112,114,101,115,115,101,100,32,116,101,120,116,117,114,101,32,102,111,114,109,97,116,32,102,108,97,103,115,46,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,116,101,120,116,117,114,101,32,100,97,116,97,32,102,111,114,32,112,118,114,116,99,32,102,105,108,101,32,39,37,115,39,46,0,78,56,103,97,109,101,112,108,97,121,57,84,114,97,110,115,102,111,114,109,69,0,116,114,97,110,115,102,111,114,109,67,104,97,110,103,101,100,0,60,84,114,97,110,115,102,111,114,109,62,0,78,56,103,97,109,101,112,108,97,121,50,50,86,101,114,116,101,120,65,116,116,114,105,98,117,116,101,66,105,110,100,105,110,103,69,0,84,104,101,32,109,97,120,105,109,117,109,32,110,117,109,98,101,114,32,111,102,32,118,101,114,116,101,120,32,97,116,116,114,105,98,117,116,101,115,32,115,117,112,112,111,114,116,101,100,32,98,121,32,79,112,101,110,71,76,32,111,110,32,116,104,101,32,99,117,114,114,101,110,116,32,100,101,118,105,99,101,32,105,115,32,48,32,111,114,32,108,101,115,115,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,86,101,114,116,101,120,65,116,116,114,105,98,117,116,101,66,105,110,100,105,110,103,46,99,112,112,0,97,95,116,101,120,67,111,111,114,100,0,97,95,98,108,101,110,100,73,110,100,105,99,101,115,0,97,95,98,108,101,110,100,87,101,105,103,104,116,115,0,97,95,98,105,110,111,114,109,97,108,0,97,95,116,97,110,103,101,110,116,0,97,95,99,111,108,111,114,0,97,95,110,111,114,109,97,108,0,97,95,112,111,115,105,116,105,111,110,0,115,101,110,100,77,101,115,115,97,103,101,0,70,97,105,108,101,100,32,116,111,32,108,111,99,97,116,101,32,65,73,65,103,101,110,116,32,102,111,114,32,109,101,115,115,97,103,101,32,114,101,99,105,112,105,101,110,116,58,32,37,115,0,78,56,103,97,109,101,112,108,97,121,49,51,65,117,100,105,111,76,105,115,116,101,110,101,114,69,0,78,56,103,97,109,101,112,108,97,121,54,66,117,116,116,111,110,69,0,109,97,112,112,105,110,103,0,98,117,116,116,111,110,0,78,56,103,97,109,101,112,108,97,121,57,67,111,110,116,97,105,110,101,114,69,0,115,99,114,111,108,108,87,104,101,101,108,82,101,113,117,105,114,101,115,70,111,99,117,115,0,115,99,114,111,108,108,105,110,103,70,114,105,99,116,105,111,110,0,115,99,114,111,108,108,87,104,101,101,108,83,112,101,101,100,0,76,65,89,79,85,84,95,65,66,83,79,76,85,84,69,0,76,65,89,79,85,84,95,86,69,82,84,73,67,65,76,0,76,65,89,79,85,84,95,70,76,79,87,0,83,67,82,79,76,76,95,78,79,78,69,0,83,67,82,79,76,76,95,72,79,82,73,90,79,78,84,65,76,0,83,67,82,79,76,76,95,86,69,82,84,73,67,65,76,0,83,67,82,79,76,76,95,66,79,84,72,0,103,101,116,83,99,114,111,108,108,0,70,97,105,108,101,100,32,116,111,32,103,101,116,32,99,111,114,114,101,115,112,111,110,100,105,110,103,32,115,99,114,111,108,108,32,115,116,97,116,101,32,102,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,118,97,108,117,101,32,39,37,115,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,67,111,110,116,97,105,110,101,114,46,99,112,112,0,76,65,66,69,76,0,66,85,84,84,79,78,0,67,72,69,67,75,66,79,88,0,82,65,68,73,79,66,85,84,84,79,78,0,67,79,78,84,65,73,78,69,82,0,83,76,73,68,69,82,0,84,69,88,84,66,79,88,0,74,79,89,83,84,73,67,75,0,73,77,65,71,69,0,99,111,110,116,97,105,110,101,114,0,115,99,114,111,108,108,98,97,114,45,102,97,100,101,45,111,117,116,0,78,56,103,97,109,101,112,108,97,121,55,67,111,110,116,114,111,108,69,0,99,111,110,116,114,111,108,69,118,101,110,116,0,60,67,111,110,116,114,111,108,62,91,67,111,110,116,114,111,108,58,58,76,105,115,116,101,110,101,114,58,58,69,118,101,110,116,84,121,112,101,93,0,97,108,105,103,110,109,101,110,116,0,97,117,116,111,87,105,100,116,104,0,97,117,116,111,72,101,105,103,104,116,0,118,105,115,105,98,108,101,0,122,73,110,100,101,120,0,102,111,99,117,115,73,110,100,101,120,0,112,111,115,105,116,105,111,110,0,120,0,121,0,115,105,122,101,0,119,105,100,116,104,0,104,101,105,103,104,116,0,83,84,65,84,69,78,79,82,77,65,76,0,83,84,65,84,69,70,79,67,85,83,0,83,84,65,84,69,65,67,84,73,86,69,0,83,84,65,84,69,68,73,83,65,66,76,69,68,0,83,84,65,84,69,72,79,86,69,82,0,77,65,82,71,73,78,0,80,65,68,68,73,78,71,0,65,76,73,71,78,95,76,69,70,84,0,65,76,73,71,78,95,72,67,69,78,84,69,82,0,65,76,73,71,78,95,82,73,71,72,84,0,65,76,73,71,78,95,84,79,80,0,65,76,73,71,78,95,86,67,69,78,84,69,82,0,65,76,73,71,78,95,66,79,84,84,79,77,0,65,76,73,71,78,95,84,79,80,95,76,69,70,84,0,65,76,73,71,78,95,86,67,69,78,84,69,82,95,76,69,70,84,0,65,76,73,71,78,95,66,79,84,84,79,77,95,76,69,70,84,0,65,76,73,71,78,95,84,79,80,95,72,67,69,78,84,69,82,0,65,76,73,71,78,95,86,67,69,78,84,69,82,95,72,67,69,78,84,69,82,0,65,76,73,71,78,95,66,79,84,84,79,77,95,72,67,69,78,84,69,82,0,65,76,73,71,78,95,84,79,80,95,82,73,71,72,84,0,65,76,73,71,78,95,86,67,69,78,84,69,82,95,82,73,71,72,84,0,65,76,73,71,78,95,66,79,84,84,79,77,95,82,73,71,72,84,0,103,101,116,65,108,105,103,110,109,101,110,116,0,70,97,105,108,101,100,32,116,111,32,103,101,116,32,99,111,114,114,101,115,112,111,110,100,105,110,103,32,99,111,110,116,114,111,108,32,97,108,105,103,110,109,101,110,116,32,102,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,118,97,108,117,101,32,39,37,115,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,67,111,110,116,114,111,108,46,99,112,112,0,99,111,110,116,114,111,108,0,78,56,103,97,109,101,112,108,97,121,49,48,70,108,111,119,76,97,121,111,117,116,69,0,78,56,103,97,109,101,112,108,97,121,52,70,111,114,109,69,0,85,110,115,117,112,112,111,114,116,101,100,32,108,97,121,111,117,116,32,116,121,112,101,32,39,37,100,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,70,111,114,109,46,99,112,112,0,115,99,114,111,108,108,66,97,114,76,101,102,116,67,97,112,0,115,99,114,111,108,108,66,97,114,82,105,103,104,116,67,97,112,0,115,99,114,111,108,108,66,97,114,84,111,112,67,97,112,0,115,99,114,111,108,108,66,97,114,66,111,116,116,111,109,67,97,112,0,102,111,114,109,80,114,111,112,101,114,116,105,101,115,0,102,111,114,109,0,108,97,121,111,117,116,0,99,111,110,115,117,109,101,73,110,112,117,116,69,118,101,110,116,115,0,115,99,114,111,108,108,0,115,99,114,111,108,108,66,97,114,115,65,117,116,111,72,105,100,101,0,114,101,115,47,115,104,97,100,101,114,115,47,102,111,114,109,46,118,101,114,116,0,114,101,115,47,115,104,97,100,101,114,115,47,102,111,114,109,46,102,114,97,103,0,99,114,101,97,116,101,69,102,102,101,99,116,0,85,110,97,98,108,101,32,116,111,32,108,111,97,100,32,102,111,114,109,32,101,102,102,101,99,116,46,0,117,95,119,111,114,108,100,86,105,101,119,80,114,111,106,101,99,116,105,111,110,77,97,116,114,105,120,0,117,95,116,101,120,116,117,114,101,0,78,56,103,97,109,101,112,108,97,121,49,49,70,114,97,109,101,66,117,102,102,101,114,69,0,111,114,103,46,103,97,109,101,112,108,97,121,51,100,46,102,114,97,109,101,98,117,102,102,101,114,46,100,101,102,97,117,108,116,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,114,101,110,100,101,114,32,116,97,114,103,101,116,32,102,111,114,32,102,114,97,109,101,32,98,117,102,102,101,114,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,70,114,97,109,101,66,117,102,102,101,114,46,99,112,112,0,115,101,116,82,101,110,100,101,114,84,97,114,103,101,116,0,70,114,97,109,101,98,117,102,102,101,114,32,115,116,97,116,117,115,32,105,110,99,111,109,112,108,101,116,101,58,32,48,120,37,120,0,78,56,103,97,109,101,112,108,97,121,53,73,109,97,103,101,69,0,70,97,105,108,101,100,32,116,111,32,111,112,101,110,32,105,109,97,103,101,32,102,105,108,101,32,39,37,115,39,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,73,109,97,103,101,46,99,112,112,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,102,105,108,101,32,39,37,115,39,59,32,110,111,116,32,97,32,118,97,108,105,100,32,80,78,71,46,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,80,78,71,32,115,116,114,117,99,116,117,114,101,32,102,111,114,32,114,101,97,100,105,110,103,32,80,78,71,32,102,105,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,80,78,71,32,105,110,102,111,32,115,116,114,117,99,116,117,114,101,32,102,111,114,32,80,78,71,32,102,105,108,101,32,39,37,115,39,46,0,70,97,105,108,101,100,32,116,111,32,115,101,116,32,117,112,32,101,114,114,111,114,32,104,97,110,100,108,105,110,103,32,102,111,114,32,114,101,97,100,105,110,103,32,80,78,71,32,102,105,108,101,32,39,37,115,39,46,0,85,110,115,117,112,112,111,114,116,101,100,32,80,78,71,32,99,111,108,111,114,32,116,121,112,101,32,40,37,100,41,32,102,111,114,32,105,109,97,103,101,32,102,105,108,101,32,39,37,115,39,46,0,69,114,114,111,114,32,114,101,97,100,105,110,103,32,80,78,71,46,0,78,56,103,97,109,101,112,108,97,121,49,50,73,109,97,103,101,67,111,110,116,114,111,108,69,0,112,97,116,104,0,115,114,99,82,101,103,105,111,110,0,100,115,116,82,101,103,105,111,110,0,78,56,103,97,109,101,112,108,97,121,56,74,111,121,115,116,105,99,107,69,0,105,110,100,101,120,0,114,97,100,105,117,115,0,105,110,105,116,105,97,108,105,122,101,0,70,97,105,108,101,100,32,116,111,32,108,111,97,100,32,106,111,121,115,116,105,99,107,59,32,114,101,113,117,105,114,101,100,32,97,116,116,114,105,98,117,116,101,32,39,114,97,100,105,117,115,39,32,105,115,32,109,105,115,115,105,110,103,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,74,111,121,115,116,105,99,107,46,99,112,112,0,114,101,108,97,116,105,118,101,0,105,110,110,101,114,0,105,110,110,101,114,82,101,103,105,111,110,0,111,117,116,101,114,0,111,117,116,101,114,82,101,103,105,111,110,0,106,111,121,115,116,105,99,107,0,78,56,103,97,109,101,112,108,97,121,53,76,97,98,101,108,69,0,116,101,120,116,0,84,69,88,84,95,67,72,65,78,71,69,68,32,101,118,101,110,116,32,105,115,32,110,111,116,32,97,112,112,108,105,99,97,98,108,101,32,116,111,32,116,104,105,115,32,99,111,110,116,114,111,108,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,76,97,98,101,108,46,99,112,112,0,86,65,76,85,69,95,67,72,65,78,71,69,68,32,101,118,101,110,116,32,105,115,32,110,111,116,32,97,112,112,108,105,99,97,98,108,101,32,116,111,32,116,104,105,115,32,99,111,110,116,114,111,108,46,0,108,97,98,101,108,0,78,56,103,97,109,101,112,108,97,121,54,76,97,121,111,117,116,69,0,118,101,114,116,105,99,97,108,83,99,114,111,108,108,66,97,114,0,104,111,114,105,122,111,110,116,97,108,83,99,114,111,108,108,66,97,114,0,78,56,103,97,109,101,112,108,97,121,49,49,82,97,100,105,111,66,117,116,116,111,110,69,0,115,101,108,101,99,116,101,100,0,103,114,111,117,112,0,84,69,88,84,95,67,72,65,78,71,69,68,32,101,118,101,110,116,32,105,115,32,110,111,116,32,97,112,112,108,105,99,97,98,108,101,32,116,111,32,82,97,100,105,111,66,117,116,116,111,110,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,82,97,100,105,111,66,117,116,116,111,110,46,99,112,112,0,117,110,115,101,108,101,99,116,101,100,0,114,97,100,105,111,66,117,116,116,111,110,0,78,56,103,97,109,101,112,108,97,121,49,50,82,101,110,100,101,114,84,97,114,103,101,116,69,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,116,101,120,116,117,114,101,32,102,111,114,32,114,101,110,100,101,114,32,116,97,114,103,101,116,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,82,101,110,100,101,114,84,97,114,103,101,116,46,99,112,112,0,78,56,103,97,109,101,112,108,97,121,54,83,108,105,100,101,114,69,0,109,105,110,0,109,97,120,0,118,97,108,117,101,0,115,116,101,112,0,118,97,108,117,101,84,101,120,116,86,105,115,105,98,108,101,0,118,97,108,117,101,84,101,120,116,80,114,101,99,105,115,105,111,110,0,118,97,108,117,101,84,101,120,116,65,108,105,103,110,109,101,110,116,0,84,69,88,84,95,67,72,65,78,71,69,68,32,101,118,101,110,116,32,105,115,32,110,111,116,32,97,112,112,108,105,99,97,98,108,101,32,116,111,32,83,108,105,100,101,114,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,83,108,105,100,101,114,46,99,112,112,0,109,105,110,67,97,112,0,109,97,120,67,97,112,0,109,97,114,107,101,114,0,116,114,97,99,107,0,37,46,42,102,0,115,108,105,100,101,114,0,78,56,103,97,109,101,112,108,97,121,55,84,101,120,116,66,111,120,69,0,86,65,76,85,69,95,67,72,65,78,71,69,68,32,101,118,101,110,116,32,105,115,32,110,111,116,32,97,112,112,108,105,99,97,98,108,101,32,116,111,32,84,101,120,116,66,111,120,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,84,101,120,116,66,111,120,46,99,112,112,0,116,101,120,116,67,97,114,101,116,0,116,101,120,116,66,111,120,0,78,56,103,97,109,101,112,108,97,121,53,84,104,101,109,101,69,0,78,56,103,97,109,101,112,108,97,121,53,84,104,101,109,101,49,48,84,104,101,109,101,73,109,97,103,101,69,0,78,56,103,97,109,101,112,108,97,121,53,84,104,101,109,101,57,73,109,97,103,101,76,105,115,116,69,0,78,56,103,97,109,101,112,108,97,121,53,84,104,101,109,101,52,83,107,105,110,69,0,116,104,101,109,101,0,116,101,120,116,117,114,101,0,105,109,97,103,101,0,105,109,97,103,101,76,105,115,116,0,115,107,105,110,0,98,111,114,100,101,114,0,116,111,112,0,98,111,116,116,111,109,0,108,101,102,116,0,114,105,103,104,116,0,114,101,103,105,111,110,0,99,111,108,111,114,0,115,116,121,108,101,0,115,116,97,116,101,78,111,114,109,97,108,0,116,101,120,116,67,111,108,111,114,0,102,111,110,116,0,102,111,110,116,83,105,122,101,0,116,101,120,116,65,108,105,103,110,109,101,110,116,0,114,105,103,104,116,84,111,76,101,102,116,0,111,112,97,99,105,116,121,0,99,114,101,97,116,101,0,65,108,108,32,116,104,101,109,101],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+46801);allocate([115,32,114,101,113,117,105,114,101,32,116,104,101,32,110,111,114,109,97,108,32,115,116,97,116,101,32,111,118,101,114,108,97,121,32,116,111,32,98,101,32,100,101,102,105,110,101,100,46,0,103,97,109,101,112,108,97,121,47,115,114,99,47,84,104,101,109,101,46,99,112,112,0,109,97,114,103,105,110,0,112,97,100,100,105,110,103,0,115,116,97,116,101,70,111,99,117,115,0,115,116,97,116,101,65,99,116,105,118,101,0,115,116,97,116,101,68,105,115,97,98,108,101,100,0,115,116,97,116,101,72,111,118,101,114,0,99,117,114,115,111,114,0,69,77,80,84,89,95,83,84,89,76,69,0,78,56,103,97,109,101,112,108,97,121,53,84,104,101,109,101,53,83,116,121,108,101,55,79,118,101,114,108,97,121,69,0,78,56,103,97,109,101,112,108,97,121,49,52,86,101,114,116,105,99,97,108,76,97,121,111,117,116,69,0,84,111,111,32,109,97,110,121,32,98,121,116,101,115,32,102,111,114,32,80,78,71,32,115,105,103,110,97,116,117,114,101,0,80,111,116,101,110,116,105,97,108,32,111,118,101,114,102,108,111,119,32,105,110,32,112,110,103,95,122,97,108,108,111,99,40,41,0,49,46,54,46,49,54,0,65,112,112,108,105,99,97,116,105,111,110,32,98,117,105,108,116,32,119,105,116,104,32,108,105,98,112,110,103,45,0,32,98,117,116,32,114,117,110,110,105,110,103,32,119,105,116,104,32,0,117,110,101,120,112,101,99,116,101,100,32,122,108,105,98,32,114,101,116,117,114,110,32,99,111,100,101,0,117,110,101,120,112,101,99,116,101,100,32,101,110,100,32,111,102,32,76,90,32,115,116,114,101,97,109,0,109,105,115,115,105,110,103,32,76,90,32,100,105,99,116,105,111,110,97,114,121,0,122,108,105,98,32,73,79,32,101,114,114,111,114,0,98,97,100,32,112,97,114,97,109,101,116,101,114,115,32,116,111,32,122,108,105,98,0,100,97,109,97,103,101,100,32,76,90,32,115,116,114,101,97,109,0,117,110,115,117,112,112,111,114,116,101,100,32,122,108,105,98,32,118,101,114,115,105,111,110,0,117,110,101,120,112,101,99,116,101,100,32,122,108,105,98,32,114,101,116,117,114,110,0,103,97,109,109,97,32,118,97,108,117,101,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,108,105,98,112,110,103,32,101,115,116,105,109,97,116,101,0,103,97,109,109,97,32,118,97,108,117,101,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,115,82,71,66,0,103,97,109,109,97,32,118,97,108,117,101,32,111,117,116,32,111,102,32,114,97,110,103,101,0,105,110,99,111,110,115,105,115,116,101,110,116,32,99,104,114,111,109,97,116,105,99,105,116,105,101,115,0,105,110,118,97,108,105,100,32,99,104,114,111,109,97,116,105,99,105,116,105,101,115,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,99,104,101,99,107,105,110,103,32,99,104,114,111,109,97,116,105,99,105,116,105,101,115,0,115,82,71,66,0,105,110,118,97,108,105,100,32,115,82,71,66,32,114,101,110,100,101,114,105,110,103,32,105,110,116,101,110,116,0,105,110,99,111,110,115,105,115,116,101,110,116,32,114,101,110,100,101,114,105,110,103,32,105,110,116,101,110,116,115,0,100,117,112,108,105,99,97,116,101,32,115,82,71,66,32,105,110,102,111,114,109,97,116,105,111,110,32,105,103,110,111,114,101,100,0,99,72,82,77,32,99,104,117,110,107,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,115,82,71,66,0,108,101,110,103,116,104,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,112,114,111,102,105,108,101,0,105,110,118,97,108,105,100,32,108,101,110,103,116,104,0,116,97,103,32,99,111,117,110,116,32,116,111,111,32,108,97,114,103,101,0,105,110,118,97,108,105,100,32,114,101,110,100,101,114,105,110,103,32,105,110,116,101,110,116,0,105,110,116,101,110,116,32,111,117,116,115,105,100,101,32,100,101,102,105,110,101,100,32,114,97,110,103,101,0,105,110,118,97,108,105,100,32,115,105,103,110,97,116,117,114,101,0,0,0,246,214,0,1,0,0,0,0,211,45,112,114,111,102,105,108,101,32,39,0,39,58,32,0,104,58,32,0,80,67,83,32,105,108,108,117,109,105,110,97,110,116,32,105,115,32,110,111,116,32,68,53,48,0,82,71,66,32,99,111,108,111,114,32,115,112,97,99,101,32,110,111,116,32,112,101,114,109,105,116,116,101,100,32,111,110,32,103,114,97,121,115,99,97,108,101,32,80,78,71,0,71,114,97,121,32,99,111,108,111,114,32,115,112,97,99,101,32,110,111,116,32,112,101,114,109,105,116,116,101,100,32,111,110,32,82,71,66,32,80,78,71,0,105,110,118,97,108,105,100,32,73,67,67,32,112,114,111,102,105,108,101,32,99,111,108,111,114,32,115,112,97,99,101,0,105,110,118,97,108,105,100,32,101,109,98,101,100,100,101,100,32,65,98,115,116,114,97,99,116,32,73,67,67,32,112,114,111,102,105,108,101,0,117,110,101,120,112,101,99,116,101,100,32,68,101,118,105,99,101,76,105,110,107,32,73,67,67,32,112,114,111,102,105,108,101,32,99,108,97,115,115,0,117,110,101,120,112,101,99,116,101,100,32,78,97,109,101,100,67,111,108,111,114,32,73,67,67,32,112,114,111,102,105,108,101,32,99,108,97,115,115,0,117,110,114,101,99,111,103,110,105,122,101,100,32,73,67,67,32,112,114,111,102,105,108,101,32,99,108,97,115,115,0,117,110,101,120,112,101,99,116,101,100,32,73,67,67,32,80,67,83,32,101,110,99,111,100,105,110,103,0,73,67,67,32,112,114,111,102,105,108,101,32,116,97,103,32,115,116,97,114,116,32,110,111,116,32,97,32,109,117,108,116,105,112,108,101,32,111,102,32,52,0,73,67,67,32,112,114,111,102,105,108,101,32,116,97,103,32,111,117,116,115,105,100,101,32,112,114,111,102,105,108,101,0,107,110,111,119,110,32,105,110,99,111,114,114,101,99,116,32,115,82,71,66,32,112,114,111,102,105,108,101,0,111,117,116,45,111,102,45,100,97,116,101,32,115,82,71,66,32,112,114,111,102,105,108,101,32,119,105,116,104,32,110,111,32,115,105,103,110,97,116,117,114,101,0,78,111,116,32,114,101,99,111,103,110,105,122,105,110,103,32,107,110,111,119,110,32,115,82,71,66,32,112,114,111,102,105,108,101,32,116,104,97,116,32,104,97,115,32,98,101,101,110,32,101,100,105,116,101,100,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,104,97,110,100,108,105,110,103,32,99,72,82,77,32,99,111,101,102,102,105,99,105,101,110,116,115,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,104,97,110,100,108,105,110,103,32,99,72,82,77,45,62,88,89,90,0,73,109,97,103,101,32,119,105,100,116,104,32,105,115,32,122,101,114,111,32,105,110,32,73,72,68,82,0,73,110,118,97,108,105,100,32,105,109,97,103,101,32,119,105,100,116,104,32,105,110,32,73,72,68,82,0,73,109,97,103,101,32,119,105,100,116,104,32,105,115,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,116,104,105,115,32,97,114,99,104,105,116,101,99,116,117,114,101,0,73,109,97,103,101,32,119,105,100,116,104,32,101,120,99,101,101,100,115,32,117,115,101,114,32,108,105,109,105,116,32,105,110,32,73,72,68,82,0,73,109,97,103,101,32,104,101,105,103,104,116,32,105,115,32,122,101,114,111,32,105,110,32,73,72,68,82,0,73,110,118,97,108,105,100,32,105,109,97,103,101,32,104,101,105,103,104,116,32,105,110,32,73,72,68,82,0,73,109,97,103,101,32,104,101,105,103,104,116,32,101,120,99,101,101,100,115,32,117,115,101,114,32,108,105,109,105,116,32,105,110,32,73,72,68,82,0,73,110,118,97,108,105,100,32,98,105,116,32,100,101,112,116,104,32,105,110,32,73,72,68,82,0,73,110,118,97,108,105,100,32,99,111,108,111,114,32,116,121,112,101,32,105,110,32,73,72,68,82,0,73,110,118,97,108,105,100,32,99,111,108,111,114,32,116,121,112,101,47,98,105,116,32,100,101,112,116,104,32,99,111,109,98,105,110,97,116,105,111,110,32,105,110,32,73,72,68,82,0,85,110,107,110,111,119,110,32,105,110,116,101,114,108,97,99,101,32,109,101,116,104,111,100,32,105,110,32,73,72,68,82,0,85,110,107,110,111,119,110,32,99,111,109,112,114,101,115,115,105,111,110,32,109,101,116,104,111,100,32,105,110,32,73,72,68,82,0,77,78,71,32,102,101,97,116,117,114,101,115,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,32,105,110,32,97,32,80,78,71,32,100,97,116,97,115,116,114,101,97,109,0,85,110,107,110,111,119,110,32,102,105,108,116,101,114,32,109,101,116,104,111,100,32,105,110,32,73,72,68,82,0,73,110,118,97,108,105,100,32,102,105,108,116,101,114,32,109,101,116,104,111,100,32,105,110,32,73,72,68,82,0,73,110,118,97,108,105,100,32,73,72,68,82,32,100,97,116,97,0,103,97,109,109,97,32,116,97,98,108,101,32,98,101,105,110,103,32,114,101,98,117,105,108,116,0,117,110,100,101,102,105,110,101,100,0,108,105,98,112,110,103,32,101,114,114,111,114,58,32,37,115,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,0,108,105,98,112,110,103,32,119,97,114,110,105,110,103,58,32,37,115,0,76,105,98,112,110,103,32,106,109,112,95,98,117,102,32,115,116,105,108,108,32,97,108,108,111,99,97,116,101,100,0,65,112,112,108,105,99,97,116,105,111,110,32,106,109,112,95,98,117,102,32,115,105,122,101,32,99,104,97,110,103,101,100,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,97,114,114,97,121,32,97,108,108,111,99,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,97,114,114,97,121,32,114,101,97,108,108,111,99,0,77,105,115,115,105,110,103,32,73,72,68,82,32,98,101,102,111,114,101,32,73,68,65,84,0,77,105,115,115,105,110,103,32,80,76,84,69,32,98,101,102,111,114,101,32,73,68,65,84,0,84,111,111,32,109,97,110,121,32,73,68,65,84,115,32,102,111,117,110,100,0,112,110,103,95,114,101,97,100,95,117,112,100,97,116,101,95,105,110,102,111,47,112,110,103,95,115,116,97,114,116,95,114,101,97,100,95,105,109,97,103,101,58,32,100,117,112,108,105,99,97,116,101,32,99,97,108,108,0,112,110,103,95,115,116,97,114,116,95,114,101,97,100,95,105,109,97,103,101,47,112,110,103,95,114,101,97,100,95,117,112,100,97,116,101,95,105,110,102,111,58,32,100,117,112,108,105,99,97,116,101,32,99,97,108,108,0,73,110,118,97,108,105,100,32,97,116,116,101,109,112,116,32,116,111,32,114,101,97,100,32,114,111,119,32,100,97,116,97,0,98,97,100,32,97,100,97,112,116,105,118,101,32,102,105,108,116,101,114,32,118,97,108,117,101,0,115,101,113,117,101,110,116,105,97,108,32,114,111,119,32,111,118,101,114,102,108,111,119,0,105,110,116,101,114,110,97,108,32,115,101,113,117,101,110,116,105,97,108,32,114,111,119,32,115,105,122,101,32,99,97,108,99,117,108,97,116,105,111,110,32,101,114,114,111,114,0,73,110,116,101,114,108,97,99,101,32,104,97,110,100,108,105,110,103,32,115,104,111,117,108,100,32,98,101,32,116,117,114,110,101,100,32,111,110,32,119,104,101,110,32,117,115,105,110,103,32,112,110,103,95,114,101,97,100,95,105,109,97,103,101,0,82,101,97,100,32,112,97,108,101,116,116,101,32,105,110,100,101,120,32,101,120,99,101,101,100,105,110,103,32,110,117,109,95,112,97,108,101,116,116,101,0,73,109,97,103,101,32,105,115,32,116,111,111,32,104,105,103,104,32,116,111,32,112,114,111,99,101,115,115,32,119,105,116,104,32,112,110,103,95,114,101,97,100,95,112,110,103,40,41,0,67,97,108,108,32,116,111,32,78,85,76,76,32,114,101,97,100,32,102,117,110,99,116,105,111,110,0,82,101,97,100,32,69,114,114,111,114,0,67,97,110,39,116,32,115,101,116,32,98,111,116,104,32,114,101,97,100,95,100,97,116,97,95,102,110,32,97,110,100,32,119,114,105,116,101,95,100,97,116,97,95,102,110,32,105,110,32,116,104,101,32,115,97,109,101,32,115,116,114,117,99,116,117,114,101,0,105,110,118,97,108,105,100,32,97,102,116,101,114,32,112,110,103,95,115,116,97,114,116,95,114,101,97,100,95,105,109,97,103,101,32,111,114,32,112,110,103,95,114,101,97,100,95,117,112,100,97,116,101,95,105,110,102,111,0,108,105,98,112,110,103,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,103,97,109,109,97,43,98,97,99,107,103,114,111,117,110,100,43,114,103,98,95,116,111,95,103,114,97,121,0,105,110,118,97,108,105,100,32,98,97,99,107,103,114,111,117,110,100,32,103,97,109,109,97,32,116,121,112,101,0,80,97,108,101,116,116,101,32,105,115,32,78,85,76,76,32,105,110,32,105,110,100,101,120,101,100,32,105,109,97,103,101,0,78,85,76,76,32,114,111,119,32,98,117,102,102,101,114,0,85,110,105,110,105,116,105,97,108,105,122,101,100,32,114,111,119,0,112,110,103,95,100,111,95,114,103,98,95,116,111,95,103,114,97,121,32,102,111,117,110,100,32,110,111,110,103,114,97,121,32,112,105,120,101,108,0,112,110,103,95,100,111,95,101,110,99,111,100,101,95,97,108,112,104,97,58,32,117,110,101,120,112,101,99,116,101,100,32,99,97,108,108,0,112,110,103,95,100,111,95,113,117,97,110,116,105,122,101,32,114,101,116,117,114,110,101,100,32,114,111,119,98,121,116,101,115,61,48,0,80,78,71,32,117,110,115,105,103,110,101,100,32,105,110,116,101,103,101,114,32,111,117,116,32,111,102,32,114,97,110,103,101,0,78,111,116,32,97,32,80,78,71,32,102,105,108,101,0,80,78,71,32,102,105,108,101,32,99,111,114,114,117,112,116,101,100,32,98,121,32,65,83,67,73,73,32,99,111,110,118,101,114,115,105,111,110,0,105,110,118,97,108,105,100,32,99,104,117,110,107,32,116,121,112,101,0,67,82,67,32,101,114,114,111,114,0,111,117,116,32,111,102,32,112,108,97,99,101,0,105,110,118,97,108,105,100,0,109,105,115,115,105,110,103,32,73,72,68,82,0,100,117,112,108,105,99,97,116,101,0,105,103,110,111,114,101,100,32,105,110,32,103,114,97,121,115,99,97,108,101,32,80,78,71,0,116,82,78,83,32,109,117,115,116,32,98,101,32,97,102,116,101,114,0,104,73,83,84,32,109,117,115,116,32,98,101,32,97,102,116,101,114,0,98,75,71,68,32,109,117,115,116,32,98,101,32,97,102,116,101,114,0,105,110,118,97,108,105,100,32,118,97,108,117,101,115,0,116,111,111,32,109,97,110,121,32,112,114,111,102,105,108,101,115,0,116,111,111,32,115,104,111,114,116,0,101,120,116,114,97,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,0,98,97,100,32,99,111,109,112,114,101,115,115,105,111,110,32,109,101,116,104,111,100,0,98,97,100,32,107,101,121,119,111,114,100,0,111,117,116,32,111,102,32,109,101,109,111,114,121,0,116,114,117,110,99,97,116,101,100,0,78,111,32,115,112,97,99,101,32,105,110,32,99,104,117,110,107,32,99,97,99,104,101,32,102,111,114,32,115,80,76,84,0,109,97,108,102,111,114,109,101,100,32,115,80,76,84,32,99,104,117,110,107,0,115,80,76,84,32,99,104,117,110,107,32,104,97,115,32,98,97,100,32,108,101,110,103,116,104,0,115,80,76,84,32,99,104,117,110,107,32,116,111,111,32,108,111,110,103,0,115,80,76,84,32,99,104,117,110,107,32,114,101,113,117,105,114,101,115,32,116,111,111,32,109,117,99,104,32,109,101,109,111,114,121,0,105,110,118,97,108,105,100,32,119,105,116,104,32,97,108,112,104,97,32,99,104,97,110,110,101,108,0,105,110,118,97,108,105,100,32,105,110,100,101,120,0,105,110,118,97,108,105,100,32,112,97,114,97,109,101,116,101,114,32,99,111,117,110,116,0,117,110,114,101,99,111,103,110,105,122,101,100,32,101,113,117,97,116,105,111,110,32,116,121,112,101,0,105,110,118,97,108,105,100,32,100,97,116,97,0,105,110,118,97,108,105,100,32,117,110,105,116,0,98,97,100,32,119,105,100,116,104,32,102,111,114,109,97,116,0,110,111,110,45,112,111,115,105,116,105,118,101,32,119,105,100,116,104,0,98,97,100,32,104,101,105,103,104,116,32,102,111,114,109,97,116,0,110,111,110,45,112,111,115,105,116,105,118,101,32,104,101,105,103,104,116,0,110,111,32,115,112,97,99,101,32,105,110,32,99,104,117,110,107,32,99,97,99,104,101,0,105,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,116,111,32,114,101,97,100,32,99,104,117,110,107,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,116,111,32,112,114,111,99,101,115,115,32,116,101,120,116,32,99,104,117,110,107,0,105,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,0,117,110,107,110,111,119,110,32,99,111,109,112,114,101,115,115,105,111,110,32,116,121,112,101,0,98,97,100,32,99,111,109,112,114,101,115,115,105,111,110,32,105,110,102,111,0,101,114,114,111,114,32,105,110,32,117,115,101,114,32,99,104,117,110,107,0,83,97,118,105,110,103,32,117,110,107,110,111,119,110,32,99,104,117,110,107,58,0,102,111,114,99,105,110,103,32,115,97,118,101,32,111,102,32,97,110,32,117,110,104,97,110,100,108,101,100,32,99,104,117,110,107,59,32,112,108,101,97,115,101,32,99,97,108,108,32,112,110,103,95,115,101,116,95,107,101,101,112,95,117,110,107,110,111,119,110,95,99,104,117,110,107,115,0,117,110,104,97,110,100,108,101,100,32,99,114,105,116,105,99,97,108,32,99,104,117,110,107,0,105,110,116,101,114,110,97,108,32,114,111,119,32,108,111,103,105,99,32,101,114,114,111,114,0,105,110,116,101,114,110,97,108,32,114,111,119,32,115,105,122,101,32,99,97,108,99,117,108,97,116,105,111,110,32,101,114,114,111,114,0,105,110,116,101,114,110,97,108,32,114,111,119,32,119,105,100,116,104,32,101,114,114,111,114,0,105,110,118,97,108,105,100,32,117,115,101,114,32,116,114,97,110,115,102,111,114,109,32,112,105,120,101,108,32,100,101,112,116,104,0,78,111,116,32,101,110,111,117,103,104,32,105,109,97,103,101,32,100,97,116,97,0,69,120,116,114,97,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,0,84,111,111,32,109,117,99,104,32,105,109,97,103,101,32,100,97,116,97,0,8,8,4,4,2,2,1,0,4,0,2,0,1,0,8,8,8,4,4,2,2,0,0,4,0,2,0,1,82,111,119,32,104,97,115,32,116,111,111,32,109,97,110,121,32,98,121,116,101,115,32,116,111,32,97,108,108,111,99,97,116,101,32,105,110,32,109,101,109,111,114,121,0,117,110,107,110,111,119,110,32,99,104,117,110,107,32,101,120,99,101,101,100,115,32,109,101,109,111,114,121,32,108,105,109,105,116,115,0,122,115,116,114,101,97,109,32,117,110,99,108,97,105,109,101,100,0,32,117,115,105,110,103,32,122,115,116,114,101,97,109,0,49,46,50,46,56,0,73,110,118,97,108,105,100,32,112,97,108,101,116,116,101,32,115,105,122,101,44,32,104,73,83,84,32,97,108,108,111,99,97,116,105,111,110,32,115,107,105,112,112,101,100,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,102,111,114,32,104,73,83,84,32,99,104,117,110,107,32,100,97,116,97,0,73,110,118,97,108,105,100,32,112,67,65,76,32,101,113,117,97,116,105,111,110,32,116,121,112,101,0,73,110,118,97,108,105,100,32,112,67,65,76,32,112,97,114,97,109,101,116,101,114,32,99,111,117,110,116,0,73,110,118,97,108,105,100,32,102,111,114,109,97,116,32,102,111,114,32,112,67,65,76,32,112,97,114,97,109,101,116,101,114,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,102,111,114,32,112,67,65,76,32,112,117,114,112,111,115,101,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,102,111,114,32,112,67,65,76,32,117,110,105,116,115,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,102,111,114,32,112,67,65,76,32,112,97,114,97,109,115,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,102,111,114,32,112,67,65,76,32,112,97,114,97,109,101,116,101,114,0,73,110,118,97,108,105,100,32,115,67,65,76,32,117,110,105,116,0,73,110,118,97,108,105,100,32,115,67,65,76,32,119,105,100,116,104,0,73,110,118,97,108,105,100,32,115,67,65,76,32,104,101,105,103,104,116,0,77,101,109,111,114,121,32,97,108,108,111,99,97,116,105,111,110,32,102,97,105,108,101,100,32,119,104,105,108,101,32,112,114,111,99,101,115,115,105,110,103,32,115,67,65,76,0,73,110,118,97,108,105,100,32,112,97,108,101,116,116,101,32,108,101,110,103,116,104,0,73,110,118,97,108,105,100,32,112,97,108,101,116,116,101,0,116,111,111,32,109,97,110,121,32,116,101,120,116,32,99,104,117,110,107,115,0,116,101,120,116,32,99,111,109,112,114,101,115,115,105,111,110,32,109,111,100,101,32,105,115,32,111,117,116,32,111,102,32,114,97,110,103,101,0,116,101,120,116,32,99,104,117,110,107,58,32,111,117,116,32,111,102,32,109,101,109,111,114,121,0,73,103,110,111,114,105,110,103,32,105,110,118,97,108,105,100,32,116,105,109,101,32,118,97,108,117,101,0,116,82,78,83,32,99,104,117,110,107,32,104,97,115,32,111,117,116,45,111,102,45,114,97,110,103,101,32,115,97,109,112,108,101,115,32,102,111,114,32,98,105,116,95,100,101,112,116,104,0,116,111,111,32,109,97,110,121,32,115,80,76,84,32,99,104,117,110,107,115,0,112,110,103,95,115,101,116,95,115,80,76,84,58,32,105,110,118,97,108,105,100,32,115,80,76,84,0,115,80,76,84,32,111,117,116,32,111,102,32,109,101,109,111,114,121,0,116,111,111,32,109,97,110,121,32,117,110,107,110,111,119,110,32,99,104,117,110,107,115,0,112,110,103,95,115,101,116,95,117,110,107,110,111,119,110,95,99,104,117,110,107,115,32,110,111,119,32,101,120,112,101,99,116,115,32,97,32,118,97,108,105,100,32,108,111,99,97,116,105,111,110,0,105,110,118,97,108,105,100,32,108,111,99,97,116,105,111,110,32,105,110,32,112,110,103,95,115,101,116,95,117,110,107,110,111,119,110,95,99,104,117,110,107,115,0,117,110,107,110,111,119,110,32,99,104,117,110,107,58,32,111,117,116,32,111,102,32,109,101,109,111,114,121,0,0,64,128,192,16,80,144,208,32,96,160,224,48,112,176,240,4,68,132,196,20,84,148,212,36,100,164,228,52,116,180,244,8,72,136,200,24,88,152,216,40,104,168,232,56,120,184,248,12,76,140,204,28,92,156,220,44,108,172,236,60,124,188,252,1,65,129,193,17,81,145,209,33,97,161,225,49,113,177,241,5,69,133,197,21,85,149,213,37,101,165,229,53,117,181,245,9,73,137,201,25,89,153,217,41,105,169,233,57,121,185,249,13,77,141,205,29,93,157,221,45,109,173,237,61,125,189,253,2,66,130,194,18,82,146,210,34,98,162,226,50,114,178,242,6,70,134,198,22,86,150,214,38,102,166,230,54,118,182,246,10,74,138,202,26,90,154,218,42,106,170,234,58,122,186,250,14,78,142,206,30,94,158,222,46,110,174,238,62,126,190,254,3,67,131,195,19,83,147,211,35,99,163,227,51,115,179,243,7,71,135,199,23,87,151,215,39,103,167,231,55,119,183,247,11,75,139,203,27,91,155,219,43,107,171,235,59,123,187,251,15,79,143,207,31,95,159,223,47,111,175,239,63,127,191,255,0,16,32,48,64,80,96,112,128,144,160,176,192,208,224,240,1,17,33,49,65,81,97,113,129,145,161,177,193,209,225,241,2,18,34,50,66,82,98,114,130,146,162,178,194,210,226,242,3,19,35,51,67,83,99,115,131,147,163,179,195,211,227,243,4,20,36,52,68,84,100,116,132,148,164,180,196,212,228,244,5,21,37,53,69,85,101,117,133,149,165,181,197,213,229,245,6,22,38,54,70,86,102,118,134,150,166,182,198,214,230,246,7,23,39,55,71,87,103,119,135,151,167,183,199,215,231,247,8,24,40,56,72,88,104,120,136,152,168,184,200,216,232,248,9,25,41,57,73,89,105,121,137,153,169,185,201,217,233,249,10,26,42,58,74,90,106,122,138,154,170,186,202,218,234,250,11,27,43,59,75,91,107,123,139,155,171,187,203,219,235,251,12,28,44,60,76,92,108,124,140,156,172,188,204,220,236,252,13,29,45,61,77,93,109,125,141,157,173,189,205,221,237,253,14,30,46,62,78,94,110,126,142,158,174,190,206,222,238,254,15,31,47,63,79,95,111,127,143,159,175,191,207,223,239,255,0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255,105,110,99,111,114,114,101,99,116,32,104,101,97,100,101,114,32,99,104,101,99,107,0,117,110,107,110,111,119,110,32,99,111,109,112,114,101,115,115,105,111,110,32,109,101,116,104,111,100,0,105,110,118,97,108,105,100,32,119,105,110,100,111,119,32,115,105,122,101,0,117,110,107,110,111,119,110,32,104,101,97,100,101,114,32,102,108,97,103,115,32,115,101,116,0,104,101,97,100,101,114,32,99,114,99,32,109,105,115,109,97,116,99,104,0,105,110,118,97,108,105,100,32,98,108,111,99,107,32,116,121,112,101,0,105,110,118,97,108,105,100,32,115,116,111,114,101,100,32,98,108,111,99,107,32,108,101,110,103,116,104,115,0,116,111,111,32,109,97,110,121,32,108,101,110,103,116,104,32,111,114,32,100,105,115,116,97,110,99,101,32,115,121,109,98,111,108,115,0,105,110,118,97,108,105,100,32,99,111,100,101,32,108,101,110,103,116,104,115,32,115,101,116,0,105,110,118,97,108,105,100,32,98,105,116,32,108,101,110,103,116,104,32,114,101,112,101,97,116,0,105,110,118,97,108,105,100,32,99,111,100,101,32,45,45,32,109,105,115,115,105,110,103,32,101,110,100,45,111,102,45,98,108,111,99,107,0,105,110,118,97,108,105,100,32,108,105,116,101,114,97,108,47,108,101,110,103,116,104,115,32,115,101,116,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,115,32,115,101,116,0,105,110,99,111,114,114,101,99,116,32,100,97,116,97,32,99,104,101,99,107,0,105,110,99,111,114,114,101,99,116,32,108,101,110,103,116,104,32,99,104,101,99,107,0,78,56,103,97,109,101,112,108,97,121,49,52,65,98,115,111,108,117,116,101,76,97,121,111,117,116,69,0,109,101,115,115,97,103,101,0,0,78,56,103,97,109,101,112,108,97,121,56,67,104,101,99,107,66,111,120,69,0,105,109,97,103,101,83,105,122,101,0,99,104,101,99,107,101,100,0,37,115,32,45,45,32,0,97,100,100,76,105,115,116,101,110,101,114,0,84,69,88,84,95,67,72,65,78,71,69,68,32,101,118,101,110,116,32,105,115,32,110,111,116,32,97,112,112,108,105,99,97,98,108,101,32,116,111,32,67,104,101,99,107,66,111,120,46,0,10,0,48,0,103,97,109,101,112,108,97,121,47,115,114,99,47,67,104,101,99,107,66,111,120,46,99,112,112,0,117,110,99,104,101,99,107,101,100,0,99,104,101,99,107,66,111,120,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,32,116,111,111,32,102,97,114,32,98,97,99,107,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,32,99,111,100,101,0,105,110,118,97,108,105,100,32,108,105,116,101,114,97,108,47,108,101,110,103,116,104,32,99,111,100,101,0,101,110,116,101,114,0,101,120,105,116,0,117,112,100,97,116,101,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,115,111,108,118,101,71,114,111,117,112,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,99,114,101,97,116,101,80,114,101,100,105,99,116,105,118,101,67,111,110,116,97,99,116,115,0,114,101,108,101,97,115,101,32,112,114,101,100,105,99,116,105,118,101,32,99,111,110,116,97,99,116,32,109,97,110,105,102,111,108,100,115,0,112,114,101,100,105,99,116,105,118,101,32,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,97,112,112,108,121,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,32,114,101,115,116,105,116,117,116,105,111,110,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,70,108,111,97,116,68,97,116,97,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,49,54,98,116,82,97,121,99,97,115,116,86,101,104,105,99,108,101,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,1,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,84,104,97,110,107,115,46,10,0,117,112,100,97,116,101,65,97,98,98,115,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,112,101,114,102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,50,51,98,116,66,114,105,100,103,101,100,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,50,51,98,116,83,105,110,103,108,101,67,111,110,116,97,99,116,67,97,108,108,98,97,99,107,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,78,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+57041);allocate([51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,51,98,116,71,104,111,115,116,79,98,106,101,99,116,0,50,52,98,116,80,97,105,114,67,97,99,104,105,110,103,71,104,111,115,116,79,98,106,101,99,116,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,49,48,98,116,66,111,120,83,104,97,112,101,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,66,111,120,0,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,90,78,75,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,49,52,98,116,67,97,112,115,117,108,101,83,104,97,112,101,0,98,116,67,97,112,115,117,108,101,83,104,97,112,101,68,97,116,97,0,67,97,112,115,117,108,101,83,104,97,112,101,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,50,53,98,116,72,101,105,103,104,116,102,105,101,108,100,84,101,114,114,97,105,110,83,104,97,112,101,0,72,69,73,71,72,84,70,73,69,76,68,0,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,48,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,57,81,117,97,110,116,105,122,101,100,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,83,80,72,69,82,69,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,50,54,98,116,84,114,105,97,110,103,108,101,73,110,100,101,120,86,101,114,116,101,120,65,114,114,97,121,0,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,84,82,73,65,78,71,76,69,77,69,83,72,0,50,49,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,90,78,75,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,49,54,70,105,108,116,101,114,101,100,67,97,108,108,98,97,99,107,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,1,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,84,114,105,97,110,103,108,101,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,49,52,98,116,81,117,97,110,116,105,122,101,100,66,118,104,0,98,116,79,112,116,105,109,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,98,116,66,118,104,83,117,98,116,114,101,101,73,110,102,111,68,97,116,97,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,70,108,111,97,116,68,97,116,97,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,48,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,50,49,98,116,87,105,116,104,111,117,116,77,97,114,103,105,110,82,101,115,117,108,116,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,51,98,116,72,97,115,104,101,100,83,105,109,112,108,101,80,97,105,114,67,97,99,104,101,0,49,52,98,116,67,111,110,99,97,118,101,83,104,97,112,101,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,0,98,116,73,110,116,73,110,100,101,120,68,97,116,97,0,98,116,83,104,111,114,116,73,110,116,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,98,116,67,104,97,114,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,98,116,86,101,99,116,111,114,51,70,108,111,97,116,68,97,116,97,0,98,116,86,101,99,116,111,114,51,68,111,117,98,108,101,68,97,116,97,0,98,116,77,101,115,104,80,97,114,116,68,97,116,97,0,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,68,97,116,97,0,1,82,111,111,116,0,83,116,57,98,97,100,95,97,108,108,111,99,0,83,116,57,101,120,99,101,112,116,105,111,110,0,83,116,49,49,108,111,103,105,99,95,101,114,114,111,114,0,83,116,49,50,111,117,116,95,111,102,95,114,97,110,103,101,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,101,110,117,109,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,67,58,92,69,109,115,99,114,105,112,116,101,110,92,101,109,115,99,114,105,112,116,101,110,92,49,46,51,53,46,48,92,115,121,115,116,101,109,92,105,110,99,108,117,100,101,92,108,105,98,99,120,120,92,115,116,114,105,110,103,0,95,95,116,104,114,111,119,95,108,101,110,103,116,104,95,101,114,114,111,114,0,33,34,118,101,99,116,111,114,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,67,58,92,69,109,115,99,114,105,112,116,101,110,92,101,109,115,99,114,105,112,116,101,110,92,49,46,51,53,46,48,92,115,121,115,116,101,109,92,105,110,99,108,117,100,101,92,108,105,98,99,120,120,92,118,101,99,116,111,114,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,116,104,114,101,119,32,97,110,32,101,120,99,101,112,116,105,111,110,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,111,117,116,95,111,102,95,114,97,110,103,101,34,0,95,95,116,104,114,111,119,95,111,117,116,95,111,102,95,114,97,110,103,101,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,117,110,99,97,117,103,104,116,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,105,110,102,105,110,105,116,121,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5,0,47,0,114,119,97],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+67281);allocate([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0,118,101,99,116,111,114,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+75769);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}var GL={counter:1,lastError:0,buffers:[],mappedBuffers:{},programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],vaos:[],contexts:[],currentContext:null,currArrayBuffer:0,currElementArrayBuffer:0,byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],programInfos:{},stringCache:{},packAlignment:4,unpackAlignment:4,init:(function(){GL.createLog2ceilLookup(GL.MAX_TEMP_BUFFER_SIZE);GL.miniTempBuffer=new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);for(var i=0;i<GL.MINI_TEMP_BUFFER_SIZE;i++){GL.miniTempBufferViews[i]=GL.miniTempBuffer.subarray(0,i+1)}}),recordError:function recordError(errorCode){if(!GL.lastError){GL.lastError=errorCode}},getNewId:(function(table){var ret=GL.counter++;for(var i=table.length;i<ret;i++){table[i]=null}return ret}),MINI_TEMP_BUFFER_SIZE:16,miniTempBuffer:null,miniTempBufferViews:[0],MAX_TEMP_BUFFER_SIZE:2097152,numTempVertexBuffersPerSize:64,log2ceilLookup:null,createLog2ceilLookup:(function(maxValue){GL.log2ceilLookup=new Uint8Array(maxValue+1);var log2=0;var pow2=1;GL.log2ceilLookup[0]=0;for(var i=1;i<=maxValue;++i){if(i>pow2){pow2<<=1;++log2}GL.log2ceilLookup[i]=log2}}),generateTempBuffers:(function(quads,context){var largestIndex=GL.log2ceilLookup[GL.MAX_TEMP_BUFFER_SIZE];context.tempVertexBufferCounters1=[];context.tempVertexBufferCounters2=[];context.tempVertexBufferCounters1.length=context.tempVertexBufferCounters2.length=largestIndex+1;context.tempVertexBuffers1=[];context.tempVertexBuffers2=[];context.tempVertexBuffers1.length=context.tempVertexBuffers2.length=largestIndex+1;context.tempIndexBuffers=[];context.tempIndexBuffers.length=largestIndex+1;for(var i=0;i<=largestIndex;++i){context.tempIndexBuffers[i]=null;context.tempVertexBufferCounters1[i]=context.tempVertexBufferCounters2[i]=0;var ringbufferLength=GL.numTempVertexBuffersPerSize;context.tempVertexBuffers1[i]=[];context.tempVertexBuffers2[i]=[];var ringbuffer1=context.tempVertexBuffers1[i];var ringbuffer2=context.tempVertexBuffers2[i];ringbuffer1.length=ringbuffer2.length=ringbufferLength;for(var j=0;j<ringbufferLength;++j){ringbuffer1[j]=ringbuffer2[j]=null}}if(quads){context.tempQuadIndexBuffer=GLctx.createBuffer();context.GLctx.bindBuffer(context.GLctx.ELEMENT_ARRAY_BUFFER,context.tempQuadIndexBuffer);var numIndexes=GL.MAX_TEMP_BUFFER_SIZE>>1;var quadIndexes=new Uint16Array(numIndexes);var i=0,v=0;while(1){quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+1;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v+3;if(i>=numIndexes)break;v+=4}context.GLctx.bufferData(context.GLctx.ELEMENT_ARRAY_BUFFER,quadIndexes,context.GLctx.STATIC_DRAW);context.GLctx.bindBuffer(context.GLctx.ELEMENT_ARRAY_BUFFER,null)}}),getTempVertexBuffer:function getTempVertexBuffer(sizeBytes){var idx=GL.log2ceilLookup[sizeBytes];var ringbuffer=GL.currentContext.tempVertexBuffers1[idx];var nextFreeBufferIndex=GL.currentContext.tempVertexBufferCounters1[idx];GL.currentContext.tempVertexBufferCounters1[idx]=GL.currentContext.tempVertexBufferCounters1[idx]+1&GL.numTempVertexBuffersPerSize-1;var vbo=ringbuffer[nextFreeBufferIndex];if(vbo){return vbo}var prevVBO=GLctx.getParameter(GLctx.ARRAY_BUFFER_BINDING);ringbuffer[nextFreeBufferIndex]=GLctx.createBuffer();GLctx.bindBuffer(GLctx.ARRAY_BUFFER,ringbuffer[nextFreeBufferIndex]);GLctx.bufferData(GLctx.ARRAY_BUFFER,1<<idx,GLctx.DYNAMIC_DRAW);GLctx.bindBuffer(GLctx.ARRAY_BUFFER,prevVBO);return ringbuffer[nextFreeBufferIndex]},getTempIndexBuffer:function getTempIndexBuffer(sizeBytes){var idx=GL.log2ceilLookup[sizeBytes];var ibo=GL.currentContext.tempIndexBuffers[idx];if(ibo){return ibo}var prevIBO=GLctx.getParameter(GLctx.ELEMENT_ARRAY_BUFFER_BINDING);GL.currentContext.tempIndexBuffers[idx]=GLctx.createBuffer();GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.currentContext.tempIndexBuffers[idx]);GLctx.bufferData(GLctx.ELEMENT_ARRAY_BUFFER,1<<idx,GLctx.DYNAMIC_DRAW);GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,prevIBO);return GL.currentContext.tempIndexBuffers[idx]},newRenderingFrameStarted:function newRenderingFrameStarted(){if(!GL.currentContext){return}var vb=GL.currentContext.tempVertexBuffers1;GL.currentContext.tempVertexBuffers1=GL.currentContext.tempVertexBuffers2;GL.currentContext.tempVertexBuffers2=vb;vb=GL.currentContext.tempVertexBufferCounters1;GL.currentContext.tempVertexBufferCounters1=GL.currentContext.tempVertexBufferCounters2;GL.currentContext.tempVertexBufferCounters2=vb;var largestIndex=GL.log2ceilLookup[GL.MAX_TEMP_BUFFER_SIZE];for(var i=0;i<=largestIndex;++i){GL.currentContext.tempVertexBufferCounters1[i]=0}},getSource:(function(shader,count,string,length){var source="";for(var i=0;i<count;++i){var frag;if(length){var len=HEAP32[length+i*4>>2];if(len<0){frag=Pointer_stringify(HEAP32[string+i*4>>2])}else{frag=Pointer_stringify(HEAP32[string+i*4>>2],len)}}else{frag=Pointer_stringify(HEAP32[string+i*4>>2])}source+=frag}return source}),calcBufLength:function calcBufLength(size,type,stride,count){if(stride>0){return count*stride}var typeSize=GL.byteSizeByType[type-GL.byteSizeByTypeRoot];return size*typeSize*count},usedTempBuffers:[],preDrawHandleClientVertexAttribBindings:function preDrawHandleClientVertexAttribBindings(count){GL.resetBufferBinding=false;for(var i=0;i<GL.currentContext.maxVertexAttribs;++i){var cb=GL.currentContext.clientBuffers[i];if(!cb.clientside||!cb.enabled)continue;GL.resetBufferBinding=true;var size=GL.calcBufLength(cb.size,cb.type,cb.stride,count);var buf=GL.getTempVertexBuffer(size);GLctx.bindBuffer(GLctx.ARRAY_BUFFER,buf);GLctx.bufferSubData(GLctx.ARRAY_BUFFER,0,HEAPU8.subarray(cb.ptr,cb.ptr+size));GLctx.vertexAttribPointer(i,cb.size,cb.type,cb.normalized,cb.stride,0)}},postDrawHandleClientVertexAttribBindings:function postDrawHandleClientVertexAttribBindings(){if(GL.resetBufferBinding){GLctx.bindBuffer(GLctx.ARRAY_BUFFER,GL.buffers[GL.currArrayBuffer])}},createContext:(function(canvas,webGLContextAttributes){if(typeof webGLContextAttributes.majorVersion==="undefined"&&typeof webGLContextAttributes.minorVersion==="undefined"){webGLContextAttributes.majorVersion=1;webGLContextAttributes.minorVersion=0}var ctx;var errorInfo="?";function onContextCreationError(event){errorInfo=event.statusMessage||errorInfo}try{canvas.addEventListener("webglcontextcreationerror",onContextCreationError,false);try{if(webGLContextAttributes.majorVersion==1&&webGLContextAttributes.minorVersion==0){ctx=canvas.getContext("webgl",webGLContextAttributes)||canvas.getContext("experimental-webgl",webGLContextAttributes)}else if(webGLContextAttributes.majorVersion==2&&webGLContextAttributes.minorVersion==0){ctx=canvas.getContext("webgl2",webGLContextAttributes)||canvas.getContext("experimental-webgl2",webGLContextAttributes)}else{throw"Unsupported WebGL context version "+majorVersion+"."+minorVersion+"!"}}finally{canvas.removeEventListener("webglcontextcreationerror",onContextCreationError,false)}if(!ctx)throw":("}catch(e){Module.print("Could not create canvas: "+[errorInfo,e,JSON.stringify(webGLContextAttributes)]);return 0}if(!ctx)return 0;return GL.registerContext(ctx,webGLContextAttributes)}),registerContext:(function(ctx,webGLContextAttributes){var handle=GL.getNewId(GL.contexts);var context={handle:handle,version:webGLContextAttributes.majorVersion,GLctx:ctx};if(ctx.canvas)ctx.canvas.GLctxObject=context;GL.contexts[handle]=context;if(typeof webGLContextAttributes["enableExtensionsByDefault"]==="undefined"||webGLContextAttributes.enableExtensionsByDefault){GL.initExtensions(context)}return handle}),makeContextCurrent:(function(contextHandle){var context=GL.contexts[contextHandle];if(!context)return false;GLctx=Module.ctx=context.GLctx;GL.currentContext=context;return true}),getContext:(function(contextHandle){return GL.contexts[contextHandle]}),deleteContext:(function(contextHandle){if(GL.currentContext===GL.contexts[contextHandle])GL.currentContext=null;if(typeof JSEvents==="object")JSEvents.removeAllHandlersOnTarget(GL.contexts[contextHandle].GLctx.canvas);if(GL.contexts[contextHandle]&&GL.contexts[contextHandle].GLctx.canvas)GL.contexts[contextHandle].GLctx.canvas.GLctxObject=undefined;GL.contexts[contextHandle]=null}),initExtensions:(function(context){if(!context)context=GL.currentContext;if(context.initExtensionsDone)return;context.initExtensionsDone=true;var GLctx=context.GLctx;context.maxVertexAttribs=GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);context.clientBuffers=[];for(var i=0;i<context.maxVertexAttribs;i++){context.clientBuffers[i]={enabled:false,clientside:false,size:0,type:0,normalized:0,stride:0,ptr:0}}GL.generateTempBuffers(false,context);if(context.version<2){var instancedArraysExt=GLctx.getExtension("ANGLE_instanced_arrays");if(instancedArraysExt){GLctx["vertexAttribDivisor"]=(function(index,divisor){instancedArraysExt["vertexAttribDivisorANGLE"](index,divisor)});GLctx["drawArraysInstanced"]=(function(mode,first,count,primcount){instancedArraysExt["drawArraysInstancedANGLE"](mode,first,count,primcount)});GLctx["drawElementsInstanced"]=(function(mode,count,type,indices,primcount){instancedArraysExt["drawElementsInstancedANGLE"](mode,count,type,indices,primcount)})}var vaoExt=GLctx.getExtension("OES_vertex_array_object");if(vaoExt){GLctx["createVertexArray"]=(function(){return vaoExt["createVertexArrayOES"]()});GLctx["deleteVertexArray"]=(function(vao){vaoExt["deleteVertexArrayOES"](vao)});GLctx["bindVertexArray"]=(function(vao){vaoExt["bindVertexArrayOES"](vao)});GLctx["isVertexArray"]=(function(vao){return vaoExt["isVertexArrayOES"](vao)})}var drawBuffersExt=GLctx.getExtension("WEBGL_draw_buffers");if(drawBuffersExt){GLctx["drawBuffers"]=(function(n,bufs){drawBuffersExt["drawBuffersWEBGL"](n,bufs)})}}var automaticallyEnabledExtensions=["OES_texture_float","OES_texture_half_float","OES_standard_derivatives","OES_vertex_array_object","WEBGL_compressed_texture_s3tc","WEBGL_depth_texture","OES_element_index_uint","EXT_texture_filter_anisotropic","ANGLE_instanced_arrays","OES_texture_float_linear","OES_texture_half_float_linear","WEBGL_compressed_texture_atc","WEBGL_compressed_texture_pvrtc","EXT_color_buffer_half_float","WEBGL_color_buffer_float","EXT_frag_depth","EXT_sRGB","WEBGL_draw_buffers","WEBGL_shared_resources","EXT_shader_texture_lod"];function shouldEnableAutomatically(extension){var ret=false;automaticallyEnabledExtensions.forEach((function(include){if(ext.indexOf(include)!=-1){ret=true}}));return ret}var exts=GLctx.getSupportedExtensions();if(exts&&exts.length>0){GLctx.getSupportedExtensions().forEach((function(ext){if(automaticallyEnabledExtensions.indexOf(ext)!=-1){GLctx.getExtension(ext)}}))}}),populateUniformTable:(function(program){var p=GL.programs[program];GL.programInfos[program]={uniforms:{},maxUniformLength:0,maxAttributeLength:-1};var ptable=GL.programInfos[program];var utable=ptable.uniforms;var numUniforms=GLctx.getProgramParameter(p,GLctx.ACTIVE_UNIFORMS);for(var i=0;i<numUniforms;++i){var u=GLctx.getActiveUniform(p,i);var name=u.name;ptable.maxUniformLength=Math.max(ptable.maxUniformLength,name.length+1);if(name.indexOf("]",name.length-1)!==-1){var ls=name.lastIndexOf("[");name=name.slice(0,ls)}var loc=GLctx.getUniformLocation(p,name);var id=GL.getNewId(GL.uniforms);utable[name]=[u.size,id];GL.uniforms[id]=loc;for(var j=1;j<u.size;++j){var n=name+"["+j+"]";loc=GLctx.getUniformLocation(p,n);id=GL.getNewId(GL.uniforms);GL.uniforms[id]=loc}}})};function _glGetString(name_){if(GL.stringCache[name_])return GL.stringCache[name_];var ret;switch(name_){case 7936:case 7937:case 7938:ret=allocate(intArrayFromString(GLctx.getParameter(name_)),"i8",ALLOC_NORMAL);break;case 7939:var exts=GLctx.getSupportedExtensions();var gl_exts=[];for(var i in exts){gl_exts.push(exts[i]);gl_exts.push("GL_"+exts[i])}ret=allocate(intArrayFromString(gl_exts.join(" ")),"i8",ALLOC_NORMAL);break;case 35724:ret=allocate(intArrayFromString("OpenGL ES GLSL 1.00 (WebGL)"),"i8",ALLOC_NORMAL);break;default:GL.recordError(1280);return 0}GL.stringCache[name_]=ret;return ret}var GLEW={isLinaroFork:1,extensions:null,error:{0:null,1:null,2:null,3:null,4:null,5:null,6:null,7:null,8:null},version:{1:null,2:null,3:null,4:null},errorStringConstantFromCode:(function(error){if(GLEW.isLinaroFork){switch(error){case 4:return"OpenGL ES lib expected, found OpenGL lib";case 5:return"OpenGL lib expected, found OpenGL ES lib";case 6:return"Missing EGL version";case 7:return"EGL 1.1 and up are supported";default:break}}switch(error){case 0:return"No error";case 1:return"Missing GL version";case 2:return"GL 1.1 and up are supported";case 3:return"GLX 1.2 and up are supported";default:return null}}),errorString:(function(error){if(!GLEW.error[error]){var string=GLEW.errorStringConstantFromCode(error);if(!string){string="Unknown error";error=8}GLEW.error[error]=allocate(intArrayFromString(string),"i8",ALLOC_NORMAL)}return GLEW.error[error]}),versionStringConstantFromCode:(function(name){switch(name){case 1:return"1.10.0";case 2:return"1";case 3:return"10";case 4:return"0";default:return null}}),versionString:(function(name){if(!GLEW.version[name]){var string=GLEW.versionStringConstantFromCode(name);if(!string)return 0;GLEW.version[name]=allocate(intArrayFromString(string),"i8",ALLOC_NORMAL)}return GLEW.version[name]}),extensionIsSupported:(function(name){if(!GLEW.extensions){GLEW.extensions=Pointer_stringify(_glGetString(7939)).split(" ")}if(GLEW.extensions.indexOf(name)!=-1)return 1;return GLEW.extensions.indexOf("GL_"+name)!=-1})};function _glewInit(){return 0}var _UItoF=true;function _glClearColor(x0,x1,x2,x3){GLctx.clearColor(x0,x1,x2,x3)}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var fd=process.stdin.fd;var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null);if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.buffer.byteLength:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var errored=false;var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){flags&=~32768;if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,curr,WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var _stdin=allocate(1,"i32*",ALLOC_STATIC);var _stdout=allocate(1,"i32*",ALLOC_STATIC);var _stderr=allocate(1,"i32*",ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if((flags&2097155)!==0||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}var mounts=FS.getMounts(FS.root.mount);var completed=0;function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=mounts.length){callback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){if(err===ERRNO_CODES.EISDIR)err=ERRNO_CODES.EPERM;throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto").randomBytes(1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno]};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperty(lazyArray,"length",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})});Object.defineProperty(lazyArray,"chunkSize",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperty(node,"usedBytes",{get:(function(){return this.contents.length})});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};function _emscripten_set_main_loop_timing(mode,value){Browser.mainLoop.timingMode=mode;Browser.mainLoop.timingValue=value;if(!Browser.mainLoop.func){return 1}if(mode==0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setTimeout(){setTimeout(Browser.mainLoop.runner,value)};Browser.mainLoop.method="timeout"}else if(mode==1){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_rAF(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}else if(mode==2){if(!window["setImmediate"]){var setImmediates=[];var emscriptenMainLoopMessageId="__emcc";function Browser_setImmediate_messageHandler(event){if(event.source===window&&event.data===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}}window.addEventListener("message",Browser_setImmediate_messageHandler,true);window["setImmediate"]=function Browser_emulated_setImmediate(func){setImmediates.push(func);window.postMessage(emscriptenMainLoopMessageId,"*")}}Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setImmediate(){window["setImmediate"](Browser.mainLoop.runner)};Browser.mainLoop.method="immediate"}return 0}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg,noSetTiming){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");Browser.mainLoop.func=func;Browser.mainLoop.arg=arg;var thisMainLoopId=Browser.mainLoop.currentlyRunningMainloop;Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();setTimeout(Browser.mainLoop.runner,0);return}if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;Browser.mainLoop.currentFrameNumber=Browser.mainLoop.currentFrameNumber+1|0;if(Browser.mainLoop.timingMode==1&&Browser.mainLoop.timingValue>1&&Browser.mainLoop.currentFrameNumber%Browser.mainLoop.timingValue!=0){Browser.mainLoop.scheduler();return}GL.newRenderingFrameStarted();if(Browser.mainLoop.method==="timeout"&&Module.ctx){Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter((function(){if(typeof arg!=="undefined"){Runtime.dynCall("vi",func,[arg])}else{Runtime.dynCall("v",func)}}));if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;if(typeof SDL==="object"&&SDL.audio&&SDL.audio.queueNewAudioData)SDL.audio.queueNewAudioData();Browser.mainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0)_emscripten_set_main_loop_timing(0,1e3/fps);else _emscripten_set_main_loop_timing(1,1);Browser.mainLoop.scheduler()}if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:(function(){Browser.mainLoop.scheduler=null;Browser.mainLoop.currentlyRunningMainloop++}),resume:(function(){Browser.mainLoop.currentlyRunningMainloop++;var timingMode=Browser.mainLoop.timingMode;var timingValue=Browser.mainLoop.timingValue;var func=Browser.mainLoop.func;Browser.mainLoop.func=null;_emscripten_set_main_loop(func,0,false,Browser.mainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);Browser.mainLoop.scheduler()}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx&&canvas==Module.canvas)return Module.ctx;var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}canvas.style.backgroundColor="black"}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas,vrDevice){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;Browser.vrDevice=vrDevice;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;if(typeof Browser.vrDevice==="undefined")Browser.vrDevice=null;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);if(vrDevice){canvasContainer.requestFullScreen({vrDisplay:vrDevice})}else{canvasContainer.requestFullScreen()}}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=false}),resumeAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=true;if(Browser.queuedAsyncCallbacks.length>0){var callbacks=Browser.queuedAsyncCallbacks;Browser.queuedAsyncCallbacks=[];callbacks.forEach((function(func){func()}))}}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=event.wheelDelta;break;case"wheel":delta=event["deltaY"];break;default:throw"unrecognized mouse wheel event: "+event.type}return delta}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];if(!last)last=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),xhrLoad:(function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)}),asyncLoad:(function(url,onload,onerror,noRunDep){Browser.xhrLoad(url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}),wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:(function(){var handle=Browser.nextWgetRequestHandle;Browser.nextWgetRequestHandle++;return handle})};function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function _free(){}Module["_free"]=_free;var _environ=allocate(1,"i32*",ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]=ENV["LOGNAME"]="web_user";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/web_user";ENV["LANG"]="C";ENV["_"]=Module["thisProgram"];poolPtr=allocate(TOTAL_ENV_SIZE,"i8",ALLOC_STATIC);envPtr=allocate(MAX_ENV_VALUES*4,"i8*",ALLOC_STATIC);HEAP32[envPtr>>2]=poolPtr;HEAP32[_environ>>2]=envPtr}else{envPtr=HEAP32[_environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in env){if(typeof env[key]==="string"){var line=key+"="+env[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}var ENV={};function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocate(intArrayFromString(ENV[name]),"i8",ALLOC_NORMAL);return _getenv.ret}function _putenv(string){if(string===0){___setErrNo(ERRNO_CODES.EINVAL);return-1}string=Pointer_stringify(string);var splitPoint=string.indexOf("=");if(string===""||string.indexOf("=")===-1){___setErrNo(ERRNO_CODES.EINVAL);return-1}var name=string.slice(0,splitPoint);var value=string.slice(splitPoint+1);if(!(name in ENV)||ENV[name]!==value){ENV[name]=value;___buildEnvironment(ENV)}return 0}function _SDL_RWFromConstMem(mem,size){var id=SDL.rwops.length;SDL.rwops.push({bytes:mem,count:size});return id}function _TTF_FontHeight(font){var fontData=SDL.fonts[font];return fontData.size}function _TTF_SizeText(font,text,w,h){var fontData=SDL.fonts[font];if(w){HEAP32[w>>2]=SDL.estimateTextWidth(fontData,Pointer_stringify(text))}if(h){HEAP32[h>>2]=fontData.size}return 0}function _TTF_RenderText_Solid(font,text,color){text=Pointer_stringify(text)||" ";var fontData=SDL.fonts[font];var w=SDL.estimateTextWidth(fontData,text);var h=fontData.size;var color=SDL.loadColorToCSSRGB(color);var fontString=h+"px "+fontData.name;var surf=SDL.makeSurface(w,h,0,false,"text:"+text);var surfData=SDL.surfaces[surf];surfData.ctx.save();surfData.ctx.fillStyle=color;surfData.ctx.font=fontString;surfData.ctx.textBaseline="top";surfData.ctx.fillText(text,0,0);surfData.ctx.restore();return surf}function _Mix_HaltMusic(){var audio=SDL.music.audio;if(audio){audio.src=audio.src;audio.currentPosition=0;audio.pause()}SDL.music.audio=null;if(SDL.hookMusicFinished){Runtime.dynCall("v",SDL.hookMusicFinished)}return 0}function _Mix_PlayMusic(id,loops){if(SDL.music.audio){if(!SDL.music.audio.paused)Module.printErr("Music is already playing. "+SDL.music.source);SDL.music.audio.pause()}var info=SDL.audios[id];var audio;if(info.webAudio){audio={};audio.resource=info;audio.paused=false;audio.currentPosition=0;audio.play=(function(){SDL.playWebAudio(this)});audio.pause=(function(){SDL.pauseWebAudio(this)})}else if(info.audio){audio=info.audio}audio["onended"]=(function(){if(SDL.music.audio==this)_Mix_HaltMusic()});audio.loop=loops!=0;audio.volume=SDL.music.volume;SDL.music.audio=audio;audio.play();return 0}function _Mix_FreeChunk(id){SDL.audios[id]=null}function _Mix_LoadWAV_RW(rwopsID,freesrc){var rwops=SDL.rwops[rwopsID];if(rwops===undefined)return 0;var filename="";var audio;var webAudio;var bytes;if(rwops.filename!==undefined){filename=PATH.resolve(rwops.filename);var raw=Module["preloadedAudios"][filename];if(!raw){if(raw===null)Module.printErr("Trying to reuse preloaded audio, but freePreloadedMediaOnUse is set!");if(!Module.noAudioDecoding)Runtime.warnOnce("Cannot find preloaded audio "+filename);try{bytes=FS.readFile(filename)}catch(e){Module.printErr("Couldn't find file for: "+filename);return 0}}if(Module["freePreloadedMediaOnUse"]){Module["preloadedAudios"][filename]=null}audio=raw}else if(rwops.bytes!==undefined){if(SDL.webAudioAvailable())bytes=HEAPU8.buffer.slice(rwops.bytes,rwops.bytes+rwops.count);else bytes=HEAPU8.subarray(rwops.bytes,rwops.bytes+rwops.count)}else{return 0}var arrayBuffer=bytes?bytes.buffer||bytes:bytes;var canPlayWithWebAudio=Module["SDL_canPlayWithWebAudio"]===undefined||Module["SDL_canPlayWithWebAudio"](filename,arrayBuffer);if(bytes!==undefined&&SDL.webAudioAvailable()&&canPlayWithWebAudio){audio=undefined;webAudio={};webAudio.onDecodeComplete=[];function onDecodeComplete(data){webAudio.decodedBuffer=data;webAudio.onDecodeComplete.forEach((function(e){e()}));webAudio.onDecodeComplete=undefined}SDL.audioContext["decodeAudioData"](arrayBuffer,onDecodeComplete)}else if(audio===undefined&&bytes){var blob=new Blob([bytes],{type:rwops.mimetype});var url=URL.createObjectURL(blob);audio=new Audio;audio.src=url;audio.mozAudioChannelType="content"}var id=SDL.audios.length;SDL.audios.push({source:filename,audio:audio,webAudio:webAudio});return id}function _Mix_PlayChannel(channel,id,loops){var info=SDL.audios[id];if(!info)return-1;if(!info.audio&&!info.webAudio)return-1;if(channel==-1){for(var i=SDL.channelMinimumNumber;i<SDL.numChannels;i++){if(!SDL.channels[i].audio){channel=i;break}}if(channel==-1){Module.printErr("All "+SDL.numChannels+" channels in use!");return-1}}var channelInfo=SDL.channels[channel];var audio;if(info.webAudio){audio={};audio.resource=info;audio.paused=false;audio.currentPosition=0;audio.play=(function(){SDL.playWebAudio(this)});audio.pause=(function(){SDL.pauseWebAudio(this)})}else{audio=info.audio.cloneNode(true);audio.numChannels=info.audio.numChannels;audio.frequency=info.audio.frequency}audio["onended"]=function SDL_audio_onended(){if(channelInfo.audio==this){channelInfo.audio.paused=true;channelInfo.audio=null}if(SDL.channelFinished)Runtime.getFuncWrapper(SDL.channelFinished,"vi")(channel)};channelInfo.audio=audio;audio.loop=loops!=0;audio.volume=channelInfo.volume;audio.play();return channel}function _SDL_PauseAudio(pauseOn){if(!SDL.audio){return}if(pauseOn){if(SDL.audio.timer!==undefined){clearTimeout(SDL.audio.timer);SDL.audio.numAudioTimersPending=0;SDL.audio.timer=undefined}}else if(!SDL.audio.timer){SDL.audio.numAudioTimersPending=1;SDL.audio.timer=Browser.safeSetTimeout(SDL.audio.caller,1)}SDL.audio.paused=pauseOn}function _SDL_CloseAudio(){if(SDL.audio){_SDL_PauseAudio(1);_free(SDL.audio.buffer);SDL.audio=null;SDL.allocateChannels(0)}}function _SDL_LockSurface(surf){var surfData=SDL.surfaces[surf];surfData.locked++;if(surfData.locked>1)return 0;if(!surfData.buffer){surfData.buffer=_malloc(surfData.width*surfData.height*4);HEAP32[surf+20>>2]=surfData.buffer}HEAP32[surf+20>>2]=surfData.buffer;if(surf==SDL.screen&&Module.screenIsReadOnly&&surfData.image)return 0;if(SDL.defaults.discardOnLock){if(!surfData.image){surfData.image=surfData.ctx.createImageData(surfData.width,surfData.height)}if(!SDL.defaults.opaqueFrontBuffer)return}else{surfData.image=surfData.ctx.getImageData(0,0,surfData.width,surfData.height)}if(surf==SDL.screen&&SDL.defaults.opaqueFrontBuffer){var data=surfData.image.data;var num=data.length;for(var i=0;i<num/4;i++){data[i*4+3]=255}}if(SDL.defaults.copyOnLock&&!SDL.defaults.discardOnLock){if(surfData.isFlagSet(2097152)){throw"CopyOnLock is not supported for SDL_LockSurface with SDL_HWPALETTE flag set"+(new Error).stack}else{HEAPU8.set(surfData.image.data,surfData.buffer)}}return 0}function _SDL_FreeRW(rwopsID){SDL.rwops[rwopsID]=null;while(SDL.rwops.length>0&&SDL.rwops[SDL.rwops.length-1]===null){SDL.rwops.pop()}}function _IMG_Load_RW(rwopsID,freeSrc){try{function cleanup(){if(rwops&&freeSrc)_SDL_FreeRW(rwopsID)}function addCleanup(func){var old=cleanup;cleanup=function added_cleanup(){old();func()}}function callStbImage(func,params){var x=Module["_malloc"](4);var y=Module["_malloc"](4);var comp=Module["_malloc"](4);addCleanup((function(){Module["_free"](x);Module["_free"](y);Module["_free"](comp);if(data)Module["_stbi_image_free"](data)}));var data=Module["_"+func].apply(null,params.concat([x,y,comp,0]));if(!data)return null;return{rawData:true,data:data,width:HEAP32[x>>2],height:HEAP32[y>>2],size:HEAP32[x>>2]*HEAP32[y>>2]*HEAP32[comp>>2],bpp:HEAP32[comp>>2]}}var rwops=SDL.rwops[rwopsID];if(rwops===undefined){return 0}var filename=rwops.filename;if(filename===undefined){Runtime.warnOnce("Only file names that have been preloaded are supported for IMG_Load_RW. Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js), or package files with --use-preload-plugins");return 0}if(!raw){filename=PATH.resolve(filename);var raw=Module["preloadedImages"][filename];if(!raw){if(raw===null)Module.printErr("Trying to reuse preloaded image, but freePreloadedMediaOnUse is set!");Runtime.warnOnce("Cannot find preloaded image "+filename);Runtime.warnOnce("Cannot find preloaded image "+filename+". Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js), or package files with --use-preload-plugins");return 0}else if(Module["freePreloadedMediaOnUse"]){Module["preloadedImages"][filename]=null}}var surf=SDL.makeSurface(raw.width,raw.height,0,false,"load:"+filename);var surfData=SDL.surfaces[surf];surfData.ctx.globalCompositeOperation="copy";if(!raw.rawData){surfData.ctx.drawImage(raw,0,0,raw.width,raw.height,0,0,raw.width,raw.height)}else{var imageData=surfData.ctx.getImageData(0,0,surfData.width,surfData.height);if(raw.bpp==4){imageData.data.set(HEAPU8.subarray(raw.data,raw.data+raw.size))}else if(raw.bpp==3){var pixels=raw.size/3;var data=imageData.data;var sourcePtr=raw.data;var destPtr=0;for(var i=0;i<pixels;i++){data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=255}}else if(raw.bpp==1){var pixels=raw.size;var data=imageData.data;var sourcePtr=raw.data;var destPtr=0;for(var i=0;i<pixels;i++){var value=HEAPU8[sourcePtr++>>0];data[destPtr++]=value;data[destPtr++]=value;data[destPtr++]=value;data[destPtr++]=255}}else{Module.printErr("cannot handle bpp "+raw.bpp);return 0}surfData.ctx.putImageData(imageData,0,0)}surfData.ctx.globalCompositeOperation="source-over";_SDL_LockSurface(surf);surfData.locked--;if(SDL.GL){surfData.canvas=surfData.ctx=null}return surf}finally{cleanup()}}function _SDL_RWFromFile(_name,mode){var id=SDL.rwops.length;var name=Pointer_stringify(_name);SDL.rwops.push({filename:name,mimetype:Browser.getMimetype(name)});return id}function _IMG_Load(filename){var rwops=_SDL_RWFromFile(filename);var result=_IMG_Load_RW(rwops,1);return result}function _SDL_UpperBlitScaled(src,srcrect,dst,dstrect){return SDL.blitSurface(src,srcrect,dst,dstrect,true)}function _SDL_UpperBlit(src,srcrect,dst,dstrect){return SDL.blitSurface(src,srcrect,dst,dstrect,false)}function _SDL_GetTicks(){return Date.now()-SDL.startTime|0}var SDL={defaults:{width:320,height:200,copyOnLock:true,discardOnLock:false,opaqueFrontBuffer:true},version:null,surfaces:{},canvasPool:[],events:[],fonts:[null],audios:[null],rwops:[null],music:{audio:null,volume:1},mixerFrequency:22050,mixerFormat:32784,mixerNumChannels:2,mixerChunkSize:1024,channelMinimumNumber:0,GL:false,glAttributes:{0:3,1:3,2:2,3:0,4:0,5:1,6:16,7:0,8:0,9:0,10:0,11:0,12:0,13:0,14:0,15:1,16:0,17:0,18:0},keyboardState:null,keyboardMap:{},canRequestFullscreen:false,isRequestingFullscreen:false,textInput:false,startTime:null,initFlags:0,buttonState:0,modState:0,DOMButtons:[0,0,0],DOMEventToSDLEvent:{},TOUCH_DEFAULT_ID:0,eventHandler:null,eventHandlerContext:null,eventHandlerTemp:0,keyCodes:{16:1249,17:1248,18:1250,20:1081,33:1099,34:1102,35:1101,36:1098,37:1104,38:1106,39:1103,40:1105,44:316,45:1097,46:127,91:1251,93:1125,96:1122,97:1113,98:1114,99:1115,100:1116,101:1117,102:1118,103:1119,104:1120,105:1121,106:1109,107:1111,109:1110,110:1123,111:1108,112:1082,113:1083,114:1084,115:1085,116:1086,117:1087,118:1088,119:1089,120:1090,121:1091,122:1092,123:1093,124:1128,125:1129,126:1130,127:1131,128:1132,129:1133,130:1134,131:1135,132:1136,133:1137,134:1138,135:1139,144:1107,160:94,161:33,162:34,163:35,164:36,165:37,166:38,167:95,168:40,169:41,170:42,171:43,172:124,173:45,174:123,175:125,176:126,181:127,182:129,183:128,188:44,190:46,191:47,192:96,219:91,220:92,221:93,222:39,224:1251},scanCodes:{8:42,9:43,13:40,27:41,32:44,35:204,39:53,44:54,46:55,47:56,48:39,49:30,50:31,51:32,52:33,53:34,54:35,55:36,56:37,57:38,58:203,59:51,61:46,91:47,92:49,93:48,96:52,97:4,98:5,99:6,100:7,101:8,102:9,103:10,104:11,105:12,106:13,107:14,108:15,109:16,110:17,111:18,112:19,113:20,114:21,115:22,116:23,117:24,118:25,119:26,120:27,121:28,122:29,127:76,305:224,308:226,316:70},loadRect:(function(rect){return{x:HEAP32[rect+0>>2],y:HEAP32[rect+4>>2],w:HEAP32[rect+8>>2],h:HEAP32[rect+12>>2]}}),updateRect:(function(rect,r){HEAP32[rect>>2]=r.x;HEAP32[rect+4>>2]=r.y;HEAP32[rect+8>>2]=r.w;HEAP32[rect+12>>2]=r.h}),intersectionOfRects:(function(first,second){var leftX=Math.max(first.x,second.x);var leftY=Math.max(first.y,second.y);var rightX=Math.min(first.x+first.w,second.x+second.w);var rightY=Math.min(first.y+first.h,second.y+second.h);return{x:leftX,y:leftY,w:Math.max(leftX,rightX)-leftX,h:Math.max(leftY,rightY)-leftY}}),checkPixelFormat:(function(fmt){}),loadColorToCSSRGB:(function(color){var rgba=HEAP32[color>>2];return"rgb("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+")"}),loadColorToCSSRGBA:(function(color){var rgba=HEAP32[color>>2];return"rgba("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+","+(rgba>>24&255)/255+")"}),translateColorToCSSRGBA:(function(rgba){return"rgba("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+","+(rgba>>>24)/255+")"}),translateRGBAToCSSRGBA:(function(r,g,b,a){return"rgba("+(r&255)+","+(g&255)+","+(b&255)+","+(a&255)/255+")"}),translateRGBAToColor:(function(r,g,b,a){return r|g<<8|b<<16|a<<24}),makeSurface:(function(width,height,flags,usePageCanvas,source,rmask,gmask,bmask,amask){flags=flags||0;var is_SDL_HWSURFACE=flags&1;var is_SDL_HWPALETTE=flags&2097152;var is_SDL_OPENGL=flags&67108864;var surf=_malloc(60);var pixelFormat=_malloc(44);var bpp=is_SDL_HWPALETTE?1:4;var buffer=0;if(!is_SDL_HWSURFACE&&!is_SDL_OPENGL){buffer=_malloc(width*height*4)}HEAP32[surf>>2]=flags;HEAP32[surf+4>>2]=pixelFormat;HEAP32[surf+8>>2]=width;HEAP32[surf+12>>2]=height;HEAP32[surf+16>>2]=width*bpp;HEAP32[surf+20>>2]=buffer;HEAP32[surf+36>>2]=0;HEAP32[surf+40>>2]=0;HEAP32[surf+44>>2]=Module["canvas"].width;HEAP32[surf+48>>2]=Module["canvas"].height;HEAP32[surf+56>>2]=1;HEAP32[pixelFormat>>2]=-2042224636;HEAP32[pixelFormat+4>>2]=0;HEAP8[pixelFormat+8>>0]=bpp*8;HEAP8[pixelFormat+9>>0]=bpp;HEAP32[pixelFormat+12>>2]=rmask||255;HEAP32[pixelFormat+16>>2]=gmask||65280;HEAP32[pixelFormat+20>>2]=bmask||16711680;HEAP32[pixelFormat+24>>2]=amask||4278190080;SDL.GL=SDL.GL||is_SDL_OPENGL;var canvas;if(!usePageCanvas){if(SDL.canvasPool.length>0){canvas=SDL.canvasPool.pop()}else{canvas=document.createElement("canvas")}canvas.width=width;canvas.height=height}else{canvas=Module["canvas"]}var webGLContextAttributes={antialias:SDL.glAttributes[13]!=0&&SDL.glAttributes[14]>1,depth:SDL.glAttributes[6]>0,stencil:SDL.glAttributes[7]>0};var ctx=Browser.createContext(canvas,is_SDL_OPENGL,usePageCanvas,webGLContextAttributes);SDL.surfaces[surf]={width:width,height:height,canvas:canvas,ctx:ctx,surf:surf,buffer:buffer,pixelFormat:pixelFormat,alpha:255,flags:flags,locked:0,usePageCanvas:usePageCanvas,source:source,isFlagSet:(function(flag){return flags&flag})};return surf}),copyIndexedColorData:(function(surfData,rX,rY,rW,rH){if(!surfData.colors){return}var fullWidth=Module["canvas"].width;var fullHeight=Module["canvas"].height;var startX=rX||0;var startY=rY||0;var endX=(rW||fullWidth-startX)+startX;var endY=(rH||fullHeight-startY)+startY;var buffer=surfData.buffer;if(!surfData.image.data32){surfData.image.data32=new Uint32Array(surfData.image.data.buffer)}var data32=surfData.image.data32;var colors32=surfData.colors32;for(var y=startY;y<endY;++y){var base=y*fullWidth;for(var x=startX;x<endX;++x){data32[base+x]=colors32[HEAPU8[buffer+base+x>>0]]}}}),freeSurface:(function(surf){var refcountPointer=surf+56;var refcount=HEAP32[refcountPointer>>2];if(refcount>1){HEAP32[refcountPointer>>2]=refcount-1;return}var info=SDL.surfaces[surf];if(!info.usePageCanvas&&info.canvas)SDL.canvasPool.push(info.canvas);if(info.buffer)_free(info.buffer);_free(info.pixelFormat);_free(surf);SDL.surfaces[surf]=null;if(surf===SDL.screen){SDL.screen=null}}),blitSurface__deps:["SDL_LockSurface"],blitSurface:(function(src,srcrect,dst,dstrect,scale){var srcData=SDL.surfaces[src];var dstData=SDL.surfaces[dst];var sr,dr;if(srcrect){sr=SDL.loadRect(srcrect)}else{sr={x:0,y:0,w:srcData.width,h:srcData.height}}if(dstrect){dr=SDL.loadRect(dstrect)}else{dr={x:0,y:0,w:srcData.width,h:srcData.height}}if(dstData.clipRect){var widthScale=!scale||sr.w===0?1:sr.w/dr.w;var heightScale=!scale||sr.h===0?1:sr.h/dr.h;dr=SDL.intersectionOfRects(dstData.clipRect,dr);sr.w=dr.w*widthScale;sr.h=dr.h*heightScale;if(dstrect){SDL.updateRect(dstrect,dr)}}var blitw,blith;if(scale){blitw=dr.w;blith=dr.h}else{blitw=sr.w;blith=sr.h}if(sr.w===0||sr.h===0||blitw===0||blith===0){return 0}var oldAlpha=dstData.ctx.globalAlpha;dstData.ctx.globalAlpha=srcData.alpha/255;dstData.ctx.drawImage(srcData.canvas,sr.x,sr.y,sr.w,sr.h,dr.x,dr.y,blitw,blith);dstData.ctx.globalAlpha=oldAlpha;if(dst!=SDL.screen){Runtime.warnOnce("WARNING: copying canvas data to memory for compatibility");_SDL_LockSurface(dst);dstData.locked--}return 0}),downFingers:{},savedKeydown:null,receiveEvent:(function(event){function unpressAllPressedKeys(){for(var code in SDL.keyboardMap){SDL.events.push({type:"keyup",keyCode:SDL.keyboardMap[code]})}}switch(event.type){case"touchstart":case"touchmove":{event.preventDefault();var touches=[];if(event.type==="touchstart"){for(var i=0;i<event.touches.length;i++){var touch=event.touches[i];if(SDL.downFingers[touch.identifier]!=true){SDL.downFingers[touch.identifier]=true;touches.push(touch)}}}else{touches=event.touches}var firstTouch=touches[0];if(event.type=="touchstart"){SDL.DOMButtons[0]=1}var mouseEventType;switch(event.type){case"touchstart":mouseEventType="mousedown";break;case"touchmove":mouseEventType="mousemove";break}var mouseEvent={type:mouseEventType,button:0,pageX:firstTouch.clientX,pageY:firstTouch.clientY};SDL.events.push(mouseEvent);for(var i=0;i<touches.length;i++){var touch=touches[i];SDL.events.push({type:event.type,touch:touch})}break};case"touchend":{event.preventDefault();for(var i=0;i<event.changedTouches.length;i++){var touch=event.changedTouches[i];if(SDL.downFingers[touch.identifier]===true){delete SDL.downFingers[touch.identifier]}}var mouseEvent={type:"mouseup",button:0,pageX:event.changedTouches[0].clientX,pageY:event.changedTouches[0].clientY};SDL.DOMButtons[0]=0;SDL.events.push(mouseEvent);for(var i=0;i<event.changedTouches.length;i++){var touch=event.changedTouches[i];SDL.events.push({type:"touchend",touch:touch})}break};case"DOMMouseScroll":case"mousewheel":case"wheel":var delta=-Browser.getMouseWheelDelta(event);delta=delta==0?0:delta>0?Math.max(delta,1):Math.min(delta,-1);var button=delta>0?3:4;SDL.events.push({type:"mousedown",button:button,pageX:event.pageX,pageY:event.pageY});SDL.events.push({type:"mouseup",button:button,pageX:event.pageX,pageY:event.pageY});SDL.events.push({type:"wheel",deltaX:0,deltaY:delta});event.preventDefault();break;case"mousemove":if(SDL.DOMButtons[0]===1){SDL.events.push({type:"touchmove",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}})}if(Browser.pointerLock){if("mozMovementX"in event){event["movementX"]=event["mozMovementX"];event["movementY"]=event["mozMovementY"]}if(event["movementX"]==0&&event["movementY"]==0){event.preventDefault();return}};case"keydown":case"keyup":case"keypress":case"mousedown":case"mouseup":if(event.type!=="keydown"||!SDL.unicode&&!SDL.textInput||event.keyCode===8||event.keyCode===9){event.preventDefault()}if(event.type=="mousedown"){SDL.DOMButtons[event.button]=1;SDL.events.push({type:"touchstart",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}})}else if(event.type=="mouseup"){if(!SDL.DOMButtons[event.button]){return}SDL.events.push({type:"touchend",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}});SDL.DOMButtons[event.button]=0}if(event.type==="keydown"||event.type==="mousedown"){SDL.canRequestFullscreen=true}else if(event.type==="keyup"||event.type==="mouseup"){if(SDL.isRequestingFullscreen){Module["requestFullScreen"](true,true);SDL.isRequestingFullscreen=false}SDL.canRequestFullscreen=false}if(event.type==="keypress"&&SDL.savedKeydown){SDL.savedKeydown.keypressCharCode=event.charCode;SDL.savedKeydown=null}else if(event.type==="keydown"){SDL.savedKeydown=event}if(event.type!=="keypress"||SDL.textInput){SDL.events.push(event)}break;case"mouseout":for(var i=0;i<3;i++){if(SDL.DOMButtons[i]){SDL.events.push({type:"mouseup",button:i,pageX:event.pageX,pageY:event.pageY});SDL.DOMButtons[i]=0}}event.preventDefault();break;case"focus":SDL.events.push(event);event.preventDefault();break;case"blur":SDL.events.push(event);unpressAllPressedKeys();event.preventDefault();break;case"visibilitychange":SDL.events.push({type:"visibilitychange",visible:!document.hidden});unpressAllPressedKeys();event.preventDefault();break;case"unload":if(Browser.mainLoop.runner){SDL.events.push(event);Browser.mainLoop.runner()}return;case"resize":SDL.events.push(event);if(event.preventDefault){event.preventDefault()}break}if(SDL.events.length>=1e4){Module.printErr("SDL event queue full, dropping events");SDL.events=SDL.events.slice(0,1e4)}SDL.flushEventsToHandler();return}),lookupKeyCodeForEvent:(function(event){var code=event.keyCode;if(code>=65&&code<=90){code+=32}else{code=SDL.keyCodes[event.keyCode]||event.keyCode;if(event.location===KeyboardEvent.DOM_KEY_LOCATION_RIGHT&&code>=(224|1<<10)&&code<=(227|1<<10)){code+=4}}return code}),handleEvent:(function(event){if(event.handled)return;event.handled=true;switch(event.type){case"touchstart":case"touchend":case"touchmove":{Browser.calculateMouseEvent(event);break};case"keydown":case"keyup":{var down=event.type==="keydown";var code=SDL.lookupKeyCodeForEvent(event);HEAP8[SDL.keyboardState+code>>0]=down;SDL.modState=(HEAP8[SDL.keyboardState+1248>>0]?64:0)|(HEAP8[SDL.keyboardState+1249>>0]?1:0)|(HEAP8[SDL.keyboardState+1250>>0]?256:0)|(HEAP8[SDL.keyboardState+1252>>0]?128:0)|(HEAP8[SDL.keyboardState+1253>>0]?2:0)|(HEAP8[SDL.keyboardState+1254>>0]?512:0);if(down){SDL.keyboardMap[code]=event.keyCode}else{delete SDL.keyboardMap[code]}break};case"mousedown":case"mouseup":if(event.type=="mousedown"){SDL.buttonState|=1<<event.button}else if(event.type=="mouseup"){SDL.buttonState&=~(1<<event.button)};case"mousemove":{Browser.calculateMouseEvent(event);break}}}),flushEventsToHandler:(function(){if(!SDL.eventHandler)return;while(SDL.pollEvent(SDL.eventHandlerTemp)){Runtime.dynCall("iii",SDL.eventHandler,[SDL.eventHandlerContext,SDL.eventHandlerTemp])}}),pollEvent:(function(ptr){if(SDL.initFlags&512&&SDL.joystickEventState){SDL.queryJoysticks()}if(ptr){while(SDL.events.length>0){if(SDL.makeCEvent(SDL.events.shift(),ptr)!==false)return 1}return 0}else{return SDL.events.length>0}}),makeCEvent:(function(event,ptr){if(typeof event==="number"){_memcpy(ptr,event,28);_free(event);return}SDL.handleEvent(event);switch(event.type){case"keydown":case"keyup":{var down=event.type==="keydown";var key=SDL.lookupKeyCodeForEvent(event);var scan;if(key>=1024){scan=key-1024}else{scan=SDL.scanCodes[key]||key}HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+8>>0]=down?1:0;HEAP8[ptr+9>>0]=0;HEAP32[ptr+12>>2]=scan;HEAP32[ptr+16>>2]=key;HEAP16[ptr+20>>1]=SDL.modState;HEAP32[ptr+24>>2]=event.keypressCharCode||key;break};case"keypress":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];var cStr=intArrayFromString(String.fromCharCode(event.charCode));for(var i=0;i<cStr.length;++i){HEAP8[ptr+(8+i)>>0]=cStr[i]}break};case"mousedown":case"mouseup":case"mousemove":{if(event.type!="mousemove"){var down=event.type==="mousedown";HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP32[ptr+8>>2]=0;HEAP32[ptr+12>>2]=0;HEAP8[ptr+16>>0]=event.button+1;HEAP8[ptr+17>>0]=down?1:0;HEAP32[ptr+20>>2]=Browser.mouseX;HEAP32[ptr+24>>2]=Browser.mouseY}else{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP32[ptr+8>>2]=0;HEAP32[ptr+12>>2]=0;HEAP32[ptr+16>>2]=SDL.buttonState;HEAP32[ptr+20>>2]=Browser.mouseX;HEAP32[ptr+24>>2]=Browser.mouseY;HEAP32[ptr+28>>2]=Browser.mouseMovementX;HEAP32[ptr+32>>2]=Browser.mouseMovementY}break};case"wheel":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+16>>2]=event.deltaX;HEAP32[ptr+20>>2]=event.deltaY;break};case"touchstart":case"touchend":case"touchmove":{var touch=event.touch;if(!Browser.touches[touch.identifier])break;var w=Module["canvas"].width;var h=Module["canvas"].height;var x=Browser.touches[touch.identifier].x/w;var y=Browser.touches[touch.identifier].y/h;var lx=Browser.lastTouches[touch.identifier].x/w;var ly=Browser.lastTouches[touch.identifier].y/h;var dx=x-lx;var dy=y-ly;if(touch["deviceID"]===undefined)touch.deviceID=SDL.TOUCH_DEFAULT_ID;if(dx===0&&dy===0&&event.type==="touchmove")return false;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=_SDL_GetTicks();tempI64=[touch.deviceID>>>0,(tempDouble=touch.deviceID,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr+8>>2]=tempI64[0],HEAP32[ptr+12>>2]=tempI64[1];tempI64=[touch.identifier>>>0,(tempDouble=touch.identifier,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr+16>>2]=tempI64[0],HEAP32[ptr+20>>2]=tempI64[1];HEAPF32[ptr+24>>2]=x;HEAPF32[ptr+28>>2]=y;HEAPF32[ptr+32>>2]=dx;HEAPF32[ptr+36>>2]=dy;if(touch.force!==undefined){HEAPF32[ptr+40>>2]=touch.force}else{HEAPF32[ptr+40>>2]=event.type=="touchend"?0:1}break};case"unload":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];break};case"resize":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=event.w;HEAP32[ptr+8>>2]=event.h;break};case"joystick_button_up":case"joystick_button_down":{var state=event.type==="joystick_button_up"?0:1;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+4>>0]=event.index;HEAP8[ptr+5>>0]=event.button;HEAP8[ptr+6>>0]=state;break};case"joystick_axis_motion":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+4>>0]=event.index;HEAP8[ptr+5>>0]=event.axis;HEAP32[ptr+8>>2]=SDL.joystickAxisValueConversion(event.value);break};case"focus":{var SDL_WINDOWEVENT_FOCUS_GAINED=12;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=SDL_WINDOWEVENT_FOCUS_GAINED;break};case"blur":{var SDL_WINDOWEVENT_FOCUS_LOST=13;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=SDL_WINDOWEVENT_FOCUS_LOST;break};case"visibilitychange":{var SDL_WINDOWEVENT_SHOWN=1;var SDL_WINDOWEVENT_HIDDEN=2;var visibilityEventID=event.visible?SDL_WINDOWEVENT_SHOWN:SDL_WINDOWEVENT_HIDDEN;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=visibilityEventID;break};default:throw"Unhandled SDL event: "+event.type}}),estimateTextWidth:(function(fontData,text){var h=fontData.size;var fontString=h+"px "+fontData.name;var tempCtx=SDL.ttfContext;tempCtx.save();tempCtx.font=fontString;var ret=tempCtx.measureText(text).width|0;tempCtx.restore();return ret}),allocateChannels:(function(num){if(SDL.numChannels&&SDL.numChannels>=num&&num!=0)return;SDL.numChannels=num;SDL.channels=[];for(var i=0;i<num;i++){SDL.channels[i]={audio:null,volume:1}}}),setGetVolume:(function(info,volume){if(!info)return 0;var ret=info.volume*128;if(volume!=-1){info.volume=Math.min(Math.max(volume,0),128)/128;if(info.audio){try{info.audio.volume=info.volume;if(info.audio.webAudioGainNode)info.audio.webAudioGainNode["gain"]["value"]=info.volume}catch(e){Module.printErr("setGetVolume failed to set audio volume: "+e)}}}return ret}),setPannerPosition:(function(info,x,y,z){if(!info)return;if(info.audio){if(info.audio.webAudioPannerNode){info.audio.webAudioPannerNode["setPosition"](x,y,z)}}}),playWebAudio:(function(audio){if(!audio)return;if(audio.webAudioNode)return;if(!SDL.webAudioAvailable())return;try{var webAudio=audio.resource.webAudio;audio.paused=false;if(!webAudio.decodedBuffer){if(webAudio.onDecodeComplete===undefined)abort("Cannot play back audio object that was not loaded");webAudio.onDecodeComplete.push((function(){if(!audio.paused)SDL.playWebAudio(audio)}));return}audio.webAudioNode=SDL.audioContext["createBufferSource"]();audio.webAudioNode["buffer"]=webAudio.decodedBuffer;audio.webAudioNode["loop"]=audio.loop;audio.webAudioNode["onended"]=(function(){audio["onended"]()});audio.webAudioPannerNode=SDL.audioContext["createPanner"]();audio.webAudioPannerNode["panningModel"]="equalpower";audio.webAudioGainNode=SDL.audioContext["createGain"]();audio.webAudioGainNode["gain"]["value"]=audio.volume;audio.webAudioNode["connect"](audio.webAudioPannerNode);audio.webAudioPannerNode["connect"](audio.webAudioGainNode);audio.webAudioGainNode["connect"](SDL.audioContext["destination"]);audio.webAudioNode["start"](0,audio.currentPosition);audio.startTime=SDL.audioContext["currentTime"]-audio.currentPosition}catch(e){Module.printErr("playWebAudio failed: "+e)}}),pauseWebAudio:(function(audio){if(!audio)return;if(audio.webAudioNode){try{audio.currentPosition=(SDL.audioContext["currentTime"]-audio.startTime)%audio.resource.webAudio.decodedBuffer.duration;audio.webAudioNode["onended"]=undefined;audio.webAudioNode.stop();audio.webAudioNode=undefined}catch(e){Module.printErr("pauseWebAudio failed: "+e)}}audio.paused=true}),openAudioContext:(function(){if(!SDL.audioContext){if(typeof AudioContext!=="undefined")SDL.audioContext=new AudioContext;else if(typeof webkitAudioContext!=="undefined")SDL.audioContext=new webkitAudioContext}}),webAudioAvailable:(function(){return!!SDL.audioContext}),fillWebAudioBufferFromHeap:(function(heapPtr,sizeSamplesPerChannel,dstAudioBuffer){var numChannels=SDL.audio.channels;for(var c=0;c<numChannels;++c){var channelData=dstAudioBuffer["getChannelData"](c);if(channelData.length!=sizeSamplesPerChannel){throw"Web Audio output buffer length mismatch! Destination size: "+channelData.length+" samples vs expected "+sizeSamplesPerChannel+" samples!"}if(SDL.audio.format==32784){for(var j=0;j<sizeSamplesPerChannel;++j){channelData[j]=HEAP16[heapPtr+(j*numChannels+c)*2>>1]/32768}}else if(SDL.audio.format==8){for(var j=0;j<sizeSamplesPerChannel;++j){var v=HEAP8[heapPtr+(j*numChannels+c)>>0];channelData[j]=(v>=0?v-128:v+128)/128}}}}),debugSurface:(function(surfData){console.log("dumping surface "+[surfData.surf,surfData.source,surfData.width,surfData.height]);var image=surfData.ctx.getImageData(0,0,surfData.width,surfData.height);var data=image.data;var num=Math.min(surfData.width,surfData.height);for(var i=0;i<num;i++){console.log("   diagonal "+i+":"+[data[i*surfData.width*4+i*4+0],data[i*surfData.width*4+i*4+1],data[i*surfData.width*4+i*4+2],data[i*surfData.width*4+i*4+3]])}}),joystickEventState:1,lastJoystickState:{},joystickNamePool:{},recordJoystickState:(function(joystick,state){var buttons=new Array(state.buttons.length);for(var i=0;i<state.buttons.length;i++){buttons[i]=SDL.getJoystickButtonState(state.buttons[i])}SDL.lastJoystickState[joystick]={buttons:buttons,axes:state.axes.slice(0),timestamp:state.timestamp,index:state.index,id:state.id}}),getJoystickButtonState:(function(button){if(typeof button==="object"){return button.pressed}else{return button>0}}),queryJoysticks:(function(){for(var joystick in SDL.lastJoystickState){var state=SDL.getGamepad(joystick-1);var prevState=SDL.lastJoystickState[joystick];if(typeof state.timestamp!=="number"||state.timestamp!==prevState.timestamp){var i;for(i=0;i<state.buttons.length;i++){var buttonState=SDL.getJoystickButtonState(state.buttons[i]);if(buttonState!==prevState.buttons[i]){SDL.events.push({type:buttonState?"joystick_button_down":"joystick_button_up",joystick:joystick,index:joystick-1,button:i})}}for(i=0;i<state.axes.length;i++){if(state.axes[i]!==prevState.axes[i]){SDL.events.push({type:"joystick_axis_motion",joystick:joystick,index:joystick-1,axis:i,value:state.axes[i]})}}SDL.recordJoystickState(joystick,state)}}}),joystickAxisValueConversion:(function(value){return Math.ceil((value+1)*32767.5-32768)}),getGamepads:(function(){var fcn=navigator.getGamepads||navigator.webkitGamepads||navigator.mozGamepads||navigator.gamepads||navigator.webkitGetGamepads;if(fcn!==undefined){return fcn.apply(navigator)}else{return[]}}),getGamepad:(function(deviceIndex){var gamepads=SDL.getGamepads();if(gamepads.length>deviceIndex&&deviceIndex>=0){return gamepads[deviceIndex]}return null})};function _Mix_OpenAudio(frequency,format,channels,chunksize){SDL.openAudioContext();SDL.allocateChannels(32);SDL.mixerFrequency=frequency;SDL.mixerFormat=format;SDL.mixerNumChannels=channels;SDL.mixerChunkSize=chunksize;return 0}function _Mix_Volume(channel,volume){if(channel==-1){for(var i=0;i<SDL.numChannels-1;i++){_Mix_Volume(i,volume)}return _Mix_Volume(SDL.numChannels-1,volume)}return SDL.setGetVolume(SDL.channels[channel],volume)}function _Mix_Playing(channel){if(channel===-1){var count=0;for(var i=0;i<SDL.channels.length;i++){count+=_Mix_Playing(i)}return count}var info=SDL.channels[channel];if(info&&info.audio&&!info.audio.paused){return 1}return 0}var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);ret=ret.slice(0,Math.max(0,bufsize));writeStringToMemory(ret,buf,true);return ret.length}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall195(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___cxa_free_exception(ptr){try{return _free(ptr)}catch(e){}}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___cxa_end_catch(){if(___cxa_end_catch.rethrown){___cxa_end_catch.rethrown=false;return}asm["setThrew"](0);var ptr=EXCEPTIONS.caught.pop();if(ptr){EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr));EXCEPTIONS.last=0}}function _glLinkProgram(program){GLctx.linkProgram(GL.programs[program]);GL.programInfos[program]=null;GL.populateUniformTable(program)}function _glBindTexture(target,texture){GLctx.bindTexture(target,texture?GL.textures[texture]:null)}var _acosf=Math_acos;var _emscripten_check_longjmp=true;var _floorf=Math_floor;function _realloc(){throw"bad"}Module["_realloc"]=_realloc;Module["_saveSetjmp"]=_saveSetjmp;function _glUniform2fv(location,count,value){location=GL.uniforms[location];var view;if(count===1){view=GL.miniTempBufferViews[1];view[0]=HEAPF32[value>>2];view[1]=HEAPF32[value+4>>2]}else{view=HEAPF32.subarray(value>>2,value+count*8>>2)}GLctx.uniform2fv(location,view)}function _glCompileShader(shader){GLctx.compileShader(GL.shaders[shader])}function _emscripten_cancel_main_loop(){Browser.mainLoop.pause();Browser.mainLoop.func=null}function _Mix_Init(flags){if(!flags)return 0;return 8}function _glDeleteTextures(n,textures){for(var i=0;i<n;i++){var id=HEAP32[textures+i*4>>2];var texture=GL.textures[id];if(!texture)continue;GLctx.deleteTexture(texture);texture.name=0;GL.textures[id]=null}}Module["_bitshift64Ashr"]=_bitshift64Ashr;function ___syscall39(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),mode=SYSCALLS.get();return SYSCALLS.doMkdir(path,mode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function __Z13hspd_geterror8HSPERROR(){Module["printErr"]("missing function: _Z13hspd_geterror8HSPERROR");abort(-1)}var PTHREAD_SPECIFIC={};function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}function _SDL_GL_SetAttribute(attr,value){if(!(attr in SDL.glAttributes)){abort("Unknown SDL GL attribute ("+attr+"). Please check if your SDL version is supported.")}SDL.glAttributes[attr]=value}function _Mix_HaltChannel(channel){function halt(channel){var info=SDL.channels[channel];if(info.audio){info.audio.pause();info.audio=null}if(SDL.channelFinished){Runtime.getFuncWrapper(SDL.channelFinished,"vi")(channel)}}if(channel!=-1){halt(channel)}else{for(var i=0;i<SDL.channels.length;++i)halt(i)}return 0}var _emscripten_resume=true;function _glClearStencil(x0){GLctx.clearStencil(x0)}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _Mix_Quit(){}Module["_memmove"]=_memmove;function ___cxa_guard_abort(){}function _Mix_ReserveChannels(num){SDL.channelMinimumNumber=num}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___gxx_personality_v0(){}var _sin=Math_sin;function _glGenTextures(n,textures){for(var i=0;i<n;i++){var texture=GLctx.createTexture();if(!texture){GL.recordError(1282);while(i<n)HEAP32[textures+i++*4>>2]=0;return}var id=GL.getNewId(GL.textures);texture.name=id;GL.textures[id]=texture;HEAP32[textures+i*4>>2]=id}}function ___syscall183(which,varargs){SYSCALLS.varargs=varargs;try{var buf=SYSCALLS.get(),size=SYSCALLS.get();if(size===0)return-ERRNO_CODES.EINVAL;var cwd=FS.cwd();if(size<cwd.length+1)return-ERRNO_CODES.ERANGE;writeAsciiToMemory(cwd,buf);return buf}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _glCreateShader(shaderType){var id=GL.getNewId(GL.shaders);GL.shaders[id]=GLctx.createShader(shaderType);return id}function _glUniform1i(location,v0){location=GL.uniforms[location];GLctx.uniform1i(location,v0)}function _glGetActiveAttrib(program,index,bufSize,length,size,type,name){program=GL.programs[program];var info=GLctx.getActiveAttrib(program,index);if(!info)return;var infoname=info.name.slice(0,Math.max(0,bufSize-1));if(bufSize>0&&name){writeStringToMemory(infoname,name);if(length)HEAP32[length>>2]=infoname.length}else{if(length)HEAP32[length>>2]=0}if(size)HEAP32[size>>2]=info.size;if(type)HEAP32[type>>2]=info.type}function _emscripten_get_now(){if(!_emscripten_get_now.actual){if(ENVIRONMENT_IS_NODE){_emscripten_get_now.actual=function _emscripten_get_now_actual(){var t=process["hrtime"]();return t[0]*1e3+t[1]/1e6}}else if(typeof dateNow!=="undefined"){_emscripten_get_now.actual=dateNow}else if(typeof self==="object"&&self["performance"]&&typeof self["performance"]["now"]==="function"){_emscripten_get_now.actual=function _emscripten_get_now_actual(){return self["performance"]["now"]()}}else if(typeof performance==="object"&&typeof performance["now"]==="function"){_emscripten_get_now.actual=function _emscripten_get_now_actual(){return performance["now"]()}}else{_emscripten_get_now.actual=Date.now}}return _emscripten_get_now.actual()}function _emscripten_get_now_is_monotonic(){return ENVIRONMENT_IS_NODE||typeof dateNow!=="undefined"||(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&self["performance"]&&self["performance"]["now"]}function _clock_gettime(clk_id,tp){var now;if(clk_id===0){now=Date.now()}else if(clk_id===1&&_emscripten_get_now_is_monotonic()){now=_emscripten_get_now()}else{___setErrNo(ERRNO_CODES.EINVAL);return-1}HEAP32[tp>>2]=now/1e3|0;HEAP32[tp+4>>2]=now%1e3*1e3*1e3|0;return 0}function _glCompressedTexImage2D(target,level,internalFormat,width,height,border,imageSize,data){var heapView;if(data){heapView=HEAPU8.subarray(data,data+imageSize)}else{heapView=null}GLctx["compressedTexImage2D"](target,level,internalFormat,width,height,border,heapView)}function _glDisable(x0){GLctx.disable(x0)}var _emscripten_preinvoke=true;Module["_memset"]=_memset;var _BDtoILow=true;function _glGetProgramiv(program,pname,p){if(!p){GL.recordError(1281);return}if(pname==35716){var log=GLctx.getProgramInfoLog(GL.programs[program]);if(log===null)log="(unknown error)";HEAP32[p>>2]=log.length+1}else if(pname==35719){var ptable=GL.programInfos[program];if(ptable){HEAP32[p>>2]=ptable.maxUniformLength;return}else if(program<GL.counter){GL.recordError(1282)}else{GL.recordError(1281)}}else if(pname==35722){var ptable=GL.programInfos[program];if(ptable){if(ptable.maxAttributeLength==-1){var program=GL.programs[program];var numAttribs=GLctx.getProgramParameter(program,GLctx.ACTIVE_ATTRIBUTES);ptable.maxAttributeLength=0;for(var i=0;i<numAttribs;++i){var activeAttrib=GLctx.getActiveAttrib(program,i);ptable.maxAttributeLength=Math.max(ptable.maxAttributeLength,activeAttrib.name.length+1)}}HEAP32[p>>2]=ptable.maxAttributeLength;return}else if(program<GL.counter){GL.recordError(1282)}else{GL.recordError(1281)}}else{HEAP32[p>>2]=GLctx.getProgramParameter(GL.programs[program],pname)}}function _glDepthFunc(x0){GLctx.depthFunc(x0)}function _glHint(x0,x1){GLctx.hint(x0,x1)}function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function _glGetUniformLocation(program,name){name=Pointer_stringify(name);var arrayOffset=0;if(name.indexOf("]",name.length-1)!==-1){var ls=name.lastIndexOf("[");var arrayIndex=name.slice(ls+1,-1);if(arrayIndex.length>0){arrayOffset=parseInt(arrayIndex);if(arrayOffset<0){return-1}}name=name.slice(0,ls)}var ptable=GL.programInfos[program];if(!ptable){return-1}var utable=ptable.uniforms;var uniformInfo=utable[name];if(uniformInfo&&arrayOffset<uniformInfo[0]){return uniformInfo[1]+arrayOffset}else{return-1}}function _glBindFramebuffer(target,framebuffer){GLctx.bindFramebuffer(target,framebuffer?GL.framebuffers[framebuffer]:null)}function ___lock(){}function _glCullFace(x0){GLctx.cullFace(x0)}function _Mix_LoadWAV(filename){var rwops=_SDL_RWFromFile(filename);var result=_Mix_LoadWAV_RW(rwops);_SDL_FreeRW(rwops);return result}function _glUniform4fv(location,count,value){location=GL.uniforms[location];var view;if(count===1){view=GL.miniTempBufferViews[3];view[0]=HEAPF32[value>>2];view[1]=HEAPF32[value+4>>2];view[2]=HEAPF32[value+8>>2];view[3]=HEAPF32[value+12>>2]}else{view=HEAPF32.subarray(value>>2,value+count*16>>2)}GLctx.uniform4fv(location,view)}function _glUniform1f(location,v0){location=GL.uniforms[location];GLctx.uniform1f(location,v0)}function _Mix_CloseAudio(){return _SDL_CloseAudio.apply(null,arguments)}var _llvm_ctlz_i32=true;var _sqrtf=Math_sqrt;function _glDeleteProgram(id){if(!id)return;var program=GL.programs[id];if(!program){GL.recordError(1281);return}GLctx.deleteProgram(program);program.name=0;GL.programs[id]=null;GL.programInfos[id]=null}function __exit(status){Module["exit"](status)}function _exit(status){__exit(status)}var _emscripten_get_longjmp_result=true;function _glAttachShader(program,shader){GLctx.attachShader(GL.programs[program],GL.shaders[shader])}var _atan2f=Math_atan2;function _glCheckFramebufferStatus(x0){return GLctx.checkFramebufferStatus(x0)}function _Mix_PlayChannelTimed(){return _Mix_PlayChannel.apply(null,arguments)}function ___syscall10(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.unlink(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _glUniform3f(location,v0,v1,v2){location=GL.uniforms[location];GLctx.uniform3f(location,v0,v1,v2)}function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function _glDrawElements(mode,count,type,indices){var buf;if(!GL.currElementArrayBuffer){var size=GL.calcBufLength(1,type,0,count);buf=GL.getTempIndexBuffer(size);GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,buf);GLctx.bufferSubData(GLctx.ELEMENT_ARRAY_BUFFER,0,HEAPU8.subarray(indices,indices+size));indices=0}GL.preDrawHandleClientVertexAttribBindings(count);GLctx.drawElements(mode,count,type,indices);GL.postDrawHandleClientVertexAttribBindings(count);if(!GL.currElementArrayBuffer){GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,null)}}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}var _sinf=Math_sin;function ___syscall12(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.chdir(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall5(which,varargs){SYSCALLS.varargs=varargs;try{var pathname=SYSCALLS.getStr(),flags=SYSCALLS.get(),mode=SYSCALLS.get();var stream=FS.open(pathname,flags,mode);return stream.fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _cos=Math_cos;function _glGetActiveUniform(program,index,bufSize,length,size,type,name){program=GL.programs[program];var info=GLctx.getActiveUniform(program,index);if(!info)return;var infoname=info.name.slice(0,Math.max(0,bufSize-1));if(bufSize>0&&name){writeStringToMemory(infoname,name);if(length)HEAP32[length>>2]=infoname.length}else{if(length)HEAP32[length>>2]=0}if(size)HEAP32[size>>2]=info.size;if(type)HEAP32[type>>2]=info.type}function _glBufferSubData(target,offset,size,data){GLctx.bufferSubData(target,offset,HEAPU8.subarray(data,data+size))}function _glUniform1iv(location,count,value){location=GL.uniforms[location];value=HEAP32.subarray(value>>2,value+count*4>>2);GLctx.uniform1iv(location,value)}function ___cxa_call_unexpected(exception){Module.printErr("Unexpected exception thrown, this is not properly supported - aborting");ABORT=true;throw exception}function _SDL_Init(initFlags){SDL.startTime=Date.now();SDL.initFlags=initFlags;if(!Module["doNotCaptureKeyboard"]){var keyboardListeningElement=Module["keyboardListeningElement"]||document;keyboardListeningElement.addEventListener("keydown",SDL.receiveEvent);keyboardListeningElement.addEventListener("keyup",SDL.receiveEvent);keyboardListeningElement.addEventListener("keypress",SDL.receiveEvent);window.addEventListener("focus",SDL.receiveEvent);window.addEventListener("blur",SDL.receiveEvent);document.addEventListener("visibilitychange",SDL.receiveEvent)}if(initFlags&512){addEventListener("gamepadconnected",(function(){}))}window.addEventListener("unload",SDL.receiveEvent);SDL.keyboardState=_malloc(65536);_memset(SDL.keyboardState,0,65536);SDL.DOMEventToSDLEvent["keydown"]=768;SDL.DOMEventToSDLEvent["keyup"]=769;SDL.DOMEventToSDLEvent["keypress"]=771;SDL.DOMEventToSDLEvent["mousedown"]=1025;SDL.DOMEventToSDLEvent["mouseup"]=1026;SDL.DOMEventToSDLEvent["mousemove"]=1024;SDL.DOMEventToSDLEvent["wheel"]=1027;SDL.DOMEventToSDLEvent["touchstart"]=1792;SDL.DOMEventToSDLEvent["touchend"]=1793;SDL.DOMEventToSDLEvent["touchmove"]=1794;SDL.DOMEventToSDLEvent["unload"]=256;SDL.DOMEventToSDLEvent["resize"]=28673;SDL.DOMEventToSDLEvent["visibilitychange"]=512;SDL.DOMEventToSDLEvent["focus"]=512;SDL.DOMEventToSDLEvent["blur"]=512;SDL.DOMEventToSDLEvent["joystick_axis_motion"]=1536;SDL.DOMEventToSDLEvent["joystick_button_down"]=1539;SDL.DOMEventToSDLEvent["joystick_button_up"]=1540;return 0}function _glGenerateMipmap(x0){GLctx.generateMipmap(x0)}function _glGetShaderiv(shader,pname,p){if(!p){GL.recordError(1281);return}if(pname==35716){var log=GLctx.getShaderInfoLog(GL.shaders[shader]);if(log===null)log="(unknown error)";HEAP32[p>>2]=log.length+1}else{HEAP32[p>>2]=GLctx.getShaderParameter(GL.shaders[shader],pname)}}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall145(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _atexit(func,arg){__ATEXIT__.unshift({func:func,arg:arg})}function ___cxa_atexit(){return _atexit.apply(null,arguments)}Module["_i64Subtract"]=_i64Subtract;var _fabsf=Math_abs;Module["_i64Add"]=_i64Add;var _cosf=Math_cos;function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr}function _glDisableVertexAttribArray(index){var cb=GL.currentContext.clientBuffers[index];cb.enabled=false;GLctx.disableVertexAttribArray(index)}var _emscripten_landingpad=true;function _glShaderSource(shader,count,string,length){var source=GL.getSource(shader,count,string,length);GLctx.shaderSource(GL.shaders[shader],source)}function _SDL_SetVideoMode(width,height,depth,flags){["touchstart","touchend","touchmove","mousedown","mouseup","mousemove","DOMMouseScroll","mousewheel","wheel","mouseout"].forEach((function(event){Module["canvas"].addEventListener(event,SDL.receiveEvent,true)}));var canvas=Module["canvas"];if(width==0&&height==0){width=canvas.width;height=canvas.height}if(!SDL.addedResizeListener){SDL.addedResizeListener=true;Browser.resizeListeners.push((function(w,h){if(!SDL.settingVideoMode){SDL.receiveEvent({type:"resize",w:w,h:h})}}))}if(width!==canvas.width||height!==canvas.height){SDL.settingVideoMode=true;Browser.setCanvasSize(width,height);SDL.settingVideoMode=false}if(SDL.screen){SDL.freeSurface(SDL.screen);assert(!SDL.screen)}if(SDL.GL)flags=flags|67108864;SDL.screen=SDL.makeSurface(width,height,flags,true,"screen");return SDL.screen}function _glDeleteFramebuffers(n,framebuffers){for(var i=0;i<n;++i){var id=HEAP32[framebuffers+i*4>>2];var framebuffer=GL.framebuffers[id];if(!framebuffer)continue;GLctx.deleteFramebuffer(framebuffer);framebuffer.name=0;GL.framebuffers[id]=null}}function _glDrawArrays(mode,first,count){GL.preDrawHandleClientVertexAttribBindings(first+count);GLctx.drawArrays(mode,first,count);GL.postDrawHandleClientVertexAttribBindings()}var _llvm_pow_f32=Math_pow;function _glGetProgramInfoLog(program,maxLength,length,infoLog){var log=GLctx.getProgramInfoLog(GL.programs[program]);if(log===null)log="(unknown error)";log=log.substr(0,maxLength-1);if(maxLength>0&&infoLog){writeStringToMemory(log,infoLog);if(length)HEAP32[length>>2]=log.length}else{if(length)HEAP32[length>>2]=0}}var _emscripten_postinvoke=true;var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}function _glClear(x0){GLctx.clear(x0)}var _emscripten_cleanup_setjmp=true;function _glActiveTexture(x0){GLctx.activeTexture(x0)}function _glEnableVertexAttribArray(index){var cb=GL.currentContext.clientBuffers[index];cb.enabled=true;GLctx.enableVertexAttribArray(index)}function _glUniform3fv(location,count,value){location=GL.uniforms[location];var view;if(count===1){view=GL.miniTempBufferViews[2];view[0]=HEAPF32[value>>2];view[1]=HEAPF32[value+4>>2];view[2]=HEAPF32[value+8>>2]}else{view=HEAPF32.subarray(value>>2,value+count*12>>2)}GLctx.uniform3fv(location,view)}function _SDL_GetError(){if(!SDL.errorMessage){SDL.errorMessage=allocate(intArrayFromString("unknown SDL-emscripten error"),"i8",ALLOC_NORMAL)}return SDL.errorMessage}function _glFramebufferTexture2D(target,attachment,textarget,texture,level){GLctx.framebufferTexture2D(target,attachment,textarget,GL.textures[texture],level)}Module["_bitshift64Lshr"]=_bitshift64Lshr;var _emscripten_prep_setjmp=true;function _glBindBuffer(target,buffer){var bufferObj=buffer?GL.buffers[buffer]:null;if(target==GLctx.ARRAY_BUFFER){GL.currArrayBuffer=buffer}else if(target==GLctx.ELEMENT_ARRAY_BUFFER){GL.currElementArrayBuffer=buffer}GLctx.bindBuffer(target,bufferObj)}function _glBufferData(target,size,data,usage){switch(usage){case 35041:case 35042:usage=35040;break;case 35045:case 35046:usage=35044;break;case 35049:case 35050:usage=35048;break}if(!data){GLctx.bufferData(target,size,usage)}else{GLctx.bufferData(target,HEAPU8.subarray(data,data+size),usage)}}var _BDtoIHigh=true;function _SDL_GL_SwapBuffers(){if(Browser.doSwapBuffers)Browser.doSwapBuffers()}Module["_testSetjmp"]=_testSetjmp;function _longjmp(env,value){asm["setThrew"](env,value||1);throw"longjmp"}function _emscripten_longjmp(env,value){_longjmp(env,value)}function _glGetError(){if(GL.lastError){var error=GL.lastError;GL.lastError=0;return error}else{return GLctx.getError()}}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}function _glVertexAttribPointer(index,size,type,normalized,stride,ptr){var cb=GL.currentContext.clientBuffers[index];if(!GL.currArrayBuffer){cb.size=size;cb.type=type;cb.normalized=normalized;cb.stride=stride;cb.ptr=ptr;cb.clientside=true;return}cb.clientside=false;GLctx.vertexAttribPointer(index,size,type,normalized,stride,ptr)}function _glGetShaderInfoLog(shader,maxLength,length,infoLog){var log=GLctx.getShaderInfoLog(GL.shaders[shader]);if(log===null)log="(unknown error)";log=log.substr(0,maxLength-1);if(maxLength>0&&infoLog){writeStringToMemory(log,infoLog);if(length)HEAP32[length>>2]=log.length}else{if(length)HEAP32[length>>2]=0}}function _glGenFramebuffers(n,ids){for(var i=0;i<n;++i){var framebuffer=GLctx.createFramebuffer();if(!framebuffer){GL.recordError(1282);while(i<n)HEAP32[ids+i++*4>>2]=0;return}var id=GL.getNewId(GL.framebuffers);framebuffer.name=id;GL.framebuffers[id]=framebuffer;HEAP32[ids+i*4>>2]=id}}var _llvm_pow_f64=Math_pow;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_bitshift64Shl"]=_bitshift64Shl;var _tanf=Math_tan;var _BItoD=true;function emscriptenWebGLGet(name_,p,type){if(!p){GL.recordError(1281);return}var ret=undefined;switch(name_){case 36346:ret=1;break;case 36344:if(type!=="Integer"&&type!=="Integer64"){GL.recordError(1280)}return;case 36345:ret=0;break;case 34466:var formats=GLctx.getParameter(34467);ret=formats.length;break;case 35738:ret=5121;break;case 35739:ret=6408;break}if(ret===undefined){var result=GLctx.getParameter(name_);switch(typeof result){case"number":ret=result;break;case"boolean":ret=result?1:0;break;case"string":GL.recordError(1280);return;case"object":if(result===null){switch(name_){case 34964:case 35725:case 34965:case 36006:case 36007:case 32873:case 34068:{ret=0;break};default:{GL.recordError(1280);return}}}else if(result instanceof Float32Array||result instanceof Uint32Array||result instanceof Int32Array||result instanceof Array){for(var i=0;i<result.length;++i){switch(type){case"Integer":HEAP32[p+i*4>>2]=result[i];break;case"Float":HEAPF32[p+i*4>>2]=result[i];break;case"Boolean":HEAP8[p+i>>0]=result[i]?1:0;break;default:throw"internal glGet error, bad type: "+type}}return}else if(result instanceof WebGLBuffer||result instanceof WebGLProgram||result instanceof WebGLFramebuffer||result instanceof WebGLRenderbuffer||result instanceof WebGLTexture){ret=result.name|0}else{GL.recordError(1280);return}break;default:GL.recordError(1280);return}}switch(type){case"Integer64":tempI64=[ret>>>0,(tempDouble=ret,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[p>>2]=tempI64[0],HEAP32[p+4>>2]=tempI64[1];break;case"Integer":HEAP32[p>>2]=ret;break;case"Float":HEAPF32[p>>2]=ret;break;case"Boolean":HEAP8[p>>0]=ret?1:0;break;default:throw"internal glGet error, bad type: "+type}}function _glGetIntegerv(name_,p){emscriptenWebGLGet(name_,p,"Integer")}function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21506:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}Module["_llvm_bswap_i32"]=_llvm_bswap_i32;function ___cxa_guard_release(){}function _glDeleteVertexArrays(n,vaos){for(var i=0;i<n;i++){var id=HEAP32[vaos+i*4>>2];GLctx["deleteVertexArray"](GL.vaos[id]);GL.vaos[id]=null}}var ___tm_current=allocate(44,"i8",ALLOC_STATIC);var ___tm_timezone=allocate(intArrayFromString("GMT"),"i8",ALLOC_STATIC);var _tzname=allocate(8,"i32*",ALLOC_STATIC);var _daylight=allocate(1,"i32*",ALLOC_STATIC);var _timezone=allocate(1,"i32*",ALLOC_STATIC);function _tzset(){if(_tzset.called)return;_tzset.called=true;HEAP32[_timezone>>2]=-(new Date).getTimezoneOffset()*60;var winter=new Date(2e3,0,1);var summer=new Date(2e3,6,1);HEAP32[_daylight>>2]=Number(winter.getTimezoneOffset()!=summer.getTimezoneOffset());function extractZone(date){var match=date.toTimeString().match(/\(([A-Za-z ]+)\)$/);return match?match[1]:"GMT"}var winterName=extractZone(winter);var summerName=extractZone(summer);var winterNamePtr=allocate(intArrayFromString(winterName),"i8",ALLOC_NORMAL);var summerNamePtr=allocate(intArrayFromString(summerName),"i8",ALLOC_NORMAL);if(summer.getTimezoneOffset()<winter.getTimezoneOffset()){HEAP32[_tzname>>2]=winterNamePtr;HEAP32[_tzname+4>>2]=summerNamePtr}else{HEAP32[_tzname>>2]=summerNamePtr;HEAP32[_tzname+4>>2]=winterNamePtr}}function _localtime_r(time,tmPtr){_tzset();var date=new Date(HEAP32[time>>2]*1e3);HEAP32[tmPtr>>2]=date.getSeconds();HEAP32[tmPtr+4>>2]=date.getMinutes();HEAP32[tmPtr+8>>2]=date.getHours();HEAP32[tmPtr+12>>2]=date.getDate();HEAP32[tmPtr+16>>2]=date.getMonth();HEAP32[tmPtr+20>>2]=date.getFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getDay();var start=new Date(date.getFullYear(),0,1);var yday=(date.getTime()-start.getTime())/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+36>>2]=-(date.getTimezoneOffset()*60);var summerOffset=(new Date(2e3,6,1)).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dst=date.getTimezoneOffset()==Math.min(winterOffset,summerOffset)|0;HEAP32[tmPtr+32>>2]=dst;var zonePtr=HEAP32[_tzname+(dst?Runtime.QUANTUM_SIZE:0)>>2];HEAP32[tmPtr+40>>2]=zonePtr;return tmPtr}function _localtime(time){return _localtime_r(time,___tm_current)}var _expf=Math_exp;function _glUseProgram(program){GLctx.useProgram(program?GL.programs[program]:null)}function emscriptenWebGLComputeImageSize(width,height,sizePerPixel,alignment){function roundedToNextMultipleOf(x,y){return Math.floor((x+y-1)/y)*y}var plainRowSize=width*sizePerPixel;var alignedRowSize=roundedToNextMultipleOf(plainRowSize,alignment);return height<=0?0:(height-1)*alignedRowSize+plainRowSize}function emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,internalFormat){var sizePerPixel;var numChannels;switch(format){case 6406:case 6409:case 6402:case 6403:numChannels=1;break;case 6410:case 33319:numChannels=2;break;case 6407:case 35904:numChannels=3;break;case 6408:case 35906:numChannels=4;break;default:GL.recordError(1280);return{pixels:null,internalFormat:0}}switch(type){case 5121:sizePerPixel=numChannels*1;break;case 5123:case 36193:sizePerPixel=numChannels*2;break;case 5125:case 5126:sizePerPixel=numChannels*4;break;case 34042:sizePerPixel=4;break;case 33635:case 32819:case 32820:sizePerPixel=2;break;default:GL.recordError(1280);return{pixels:null,internalFormat:0}}var bytes=emscriptenWebGLComputeImageSize(width,height,sizePerPixel,GL.unpackAlignment);if(type==5121){pixels=HEAPU8.subarray(pixels,pixels+bytes)}else if(type==5126){pixels=HEAPF32.subarray(pixels>>2,pixels+bytes>>2)}else if(type==5125||type==34042){pixels=HEAPU32.subarray(pixels>>2,pixels+bytes>>2)}else{pixels=HEAPU16.subarray(pixels>>1,pixels+bytes>>1)}return{pixels:pixels,internalFormat:internalFormat}}function _glTexImage2D(target,level,internalFormat,width,height,border,format,type,pixels){var pixelData;if(pixels){var data=emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,internalFormat);pixelData=data.pixels;internalFormat=data.internalFormat}else{pixelData=null}GLctx.texImage2D(target,level,internalFormat,width,height,border,format,type,pixelData)}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function _emscripten_async_wget2_data(url,request,param,arg,free,onload,onerror,onprogress){var _url=Pointer_stringify(url);var _request=Pointer_stringify(request);var _param=Pointer_stringify(param);var http=new XMLHttpRequest;http.open(_request,_url,true);http.responseType="arraybuffer";var handle=Browser.getNextWgetRequestHandle();http.onload=function http_onload(e){if(http.status==200||_url.substr(0,4).toLowerCase()!="http"){var byteArray=new Uint8Array(http.response);var buffer=_malloc(byteArray.length);HEAPU8.set(byteArray,buffer);if(onload)Runtime.dynCall("viiii",onload,[handle,arg,buffer,byteArray.length]);if(free)_free(buffer)}else{if(onerror)Runtime.dynCall("viiii",onerror,[handle,arg,http.status,http.statusText])}delete Browser.wgetRequests[handle]};http.onerror=function http_onerror(e){if(onerror){Runtime.dynCall("viiii",onerror,[handle,arg,http.status,http.statusText])}delete Browser.wgetRequests[handle]};http.onprogress=function http_onprogress(e){if(onprogress)Runtime.dynCall("viiii",onprogress,[handle,arg,e.loaded,e.lengthComputable||e.lengthComputable===undefined?e.total:0])};http.onabort=function http_onabort(e){delete Browser.wgetRequests[handle]};try{if(http.channel instanceof Ci.nsIHttpChannel)http.channel.redirectionLimit=0}catch(ex){}if(_request=="POST"){http.setRequestHeader("Content-type","application/x-www-form-urlencoded");http.setRequestHeader("Content-length",_param.length);http.setRequestHeader("Connection","close");http.send(_param)}else{http.send(null)}Browser.wgetRequests[handle]=http;return handle}function _glBindVertexArray(vao){GLctx["bindVertexArray"](GL.vaos[vao])}function _abort(){Module["abort"]()}function _glUniform1fv(location,count,value){location=GL.uniforms[location];var view;if(count===1){view=GL.miniTempBufferViews[0];view[0]=HEAPF32[value>>2]}else{view=HEAPF32.subarray(value>>2,value+count*4>>2)}GLctx.uniform1fv(location,view)}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}var _tan=Math_tan;function ___unlock(){}function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}function _glEnable(x0){GLctx.enable(x0)}var _fabs=Math_abs;var _floor=Math_floor;var _sqrt=Math_sqrt;var _emscripten_asm_const_int=true;function _glGenBuffers(n,buffers){for(var i=0;i<n;i++){var buffer=GLctx.createBuffer();if(!buffer){GL.recordError(1282);while(i<n)HEAP32[buffers+i++*4>>2]=0;return}var id=GL.getNewId(GL.buffers);buffer.name=id;GL.buffers[id]=buffer;HEAP32[buffers+i*4>>2]=id}}function _SDL_PollEvent(ptr){return SDL.pollEvent(ptr)}function _glGetAttribLocation(program,name){program=GL.programs[program];name=Pointer_stringify(name);return GLctx.getAttribLocation(program,name)}function ___cxa_allocate_exception(size){return _malloc(size)}function _glDeleteShader(id){if(!id)return;var shader=GL.shaders[id];if(!shader){GL.recordError(1281);return}GLctx.deleteShader(shader);GL.shaders[id]=null}function _glBlendFunc(x0,x1){GLctx.blendFunc(x0,x1)}function _glCreateProgram(){var id=GL.getNewId(GL.programs);var program=GLctx.createProgram();program.name=id;GL.programs[id]=program;return id}var _ceilf=Math_ceil;function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function _glPixelStorei(pname,param){if(pname==3333){GL.packAlignment=param}else if(pname==3317){GL.unpackAlignment=param}GLctx.pixelStorei(pname,param)}function _glViewport(x0,x1,x2,x3){GLctx.viewport(x0,x1,x2,x3)}var _log=Math_log;function _glDepthMask(x0){GLctx.depthMask(x0)}function _llvm_eh_typeid_for(type){return type}function _glUniformMatrix4fv(location,count,transpose,value){location=GL.uniforms[location];var view;if(count===1){view=GL.miniTempBufferViews[15];for(var i=0;i<16;i++){view[i]=HEAPF32[value+i*4>>2]}}else{view=HEAPF32.subarray(value>>2,value+count*64>>2)}GLctx.uniformMatrix4fv(location,transpose,view)}function _glClearDepth(x0){GLctx.clearDepth(x0)}var _emscripten_setjmp=true;function _glTexParameteri(x0,x1,x2){GLctx.texParameteri(x0,x1,x2)}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function _glDeleteBuffers(n,buffers){for(var i=0;i<n;i++){var id=HEAP32[buffers+i*4>>2];var buffer=GL.buffers[id];if(!buffer)continue;GLctx.deleteBuffer(buffer);buffer.name=0;GL.buffers[id]=null;if(id==GL.currArrayBuffer)GL.currArrayBuffer=0;if(id==GL.currElementArrayBuffer)GL.currElementArrayBuffer=0}}function _glScissor(x0,x1,x2,x3){GLctx.scissor(x0,x1,x2,x3)}var _atan2=Math_atan2;var _exp=Math_exp;function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _pthread_self(){return 0}function ___syscall221(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),cmd=SYSCALLS.get();switch(cmd){case 0:{var arg=SYSCALLS.get();if(arg<0){return-ERRNO_CODES.EINVAL}var newStream;newStream=FS.open(stream.path,stream.flags,0,arg);return newStream.fd};case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=SYSCALLS.get();stream.flags|=arg;return 0};case 12:case 12:{var arg=SYSCALLS.get();var offset=0;HEAP16[arg+offset>>1]=2;return 0};case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-ERRNO_CODES.EINVAL;case 9:___setErrNo(ERRNO_CODES.EINVAL);return-1;default:{return-ERRNO_CODES.EINVAL}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall220(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),dirp=SYSCALLS.get(),count=SYSCALLS.get();if(!stream.getdents){stream.getdents=FS.readdir(stream.path)}var pos=0;while(stream.getdents.length>0&&pos+268<count){var id;var type;var name=stream.getdents.pop();assert(name.length<256);if(name[0]==="."){id=1;type=4}else{var child=FS.lookupNode(stream.node,name);id=child.id;type=FS.isChrdev(child.mode)?2:FS.isDir(child.mode)?4:FS.isLink(child.mode)?10:8}HEAP32[dirp+pos>>2]=id;HEAP32[dirp+pos+4>>2]=stream.position;HEAP16[dirp+pos+8>>1]=268;HEAP8[dirp+pos+10>>0]=type;for(var i=0;i<name.length;i++){HEAP8[dirp+pos+(11+i)>>0]=name.charCodeAt(i)}HEAP8[dirp+pos+(11+i)>>0]=0;pos+=268}return pos}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var ___dso_handle=allocate(1,"i32*",ALLOC_STATIC);var GLctx;GL.init();FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=require("fs");var NODEJS_PATH=require("path");NODEFS.staticInit()}Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas,vrDevice){Browser.requestFullScreen(lockPointer,resizeCanvas,vrDevice)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};Module["createContext"]=function Module_createContext(canvas,useWebGL,setInModule,webGLContextAttributes){return Browser.createContext(canvas,useWebGL,setInModule,webGLContextAttributes)};___buildEnvironment(ENV);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vddddddi(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_vddddddi"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiddi(index,a1,a2,a3,a4,a5,a6,a7,a8){try{Module["dynCall_viiiiiddi"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vid(index,a1,a2){try{Module["dynCall_vid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiidi(index,a1,a2,a3,a4){try{return Module["dynCall_iiidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiidii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiddi(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiddi"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddddddddi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viddddddddi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viddii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidi(index,a1,a2,a3,a4){try{Module["dynCall_viidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiidd(index,a1,a2,a3,a4,a5,a6,a7){try{return Module["dynCall_diiiiidd"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iidi(index,a1,a2,a3){try{return Module["dynCall_iidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidii(index,a1,a2,a3,a4){try{Module["dynCall_vidii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_dii(index,a1,a2){try{return Module["dynCall_dii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddd(index,a1,a2,a3,a4){try{Module["dynCall_viddd"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_diiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiddddiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viiiiddddiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iddii(index,a1,a2,a3,a4){try{return Module["dynCall_iddii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidd(index,a1,a2,a3){try{Module["dynCall_vidd"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiid(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddddd(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddddd"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiidii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiidi(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiidi"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_dd(index,a1){try{return Module["dynCall_dd"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{Module["dynCall_viiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiidii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_diiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidddd(index,a1,a2,a3,a4,a5){try{Module["dynCall_vidddd"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiddiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiddiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iid(index,a1,a2){try{return Module["dynCall_iid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiddd(index,a1,a2,a3,a4){try{return Module["dynCall_iiddd"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidddiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiidddiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiddi(index,a1,a2,a3,a4){try{return Module["dynCall_iiddi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_diiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiddd(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiddd"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_didd(index,a1,a2,a3){try{return Module["dynCall_didd"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidddddd(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_vidddddd"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_d(index){try{return Module["dynCall_d"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_did(index,a1,a2){try{return Module["dynCall_did"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiddd(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiddd"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidddddidi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiidddddidi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diidii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_i(index){try{return Module["dynCall_i"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iidid(index,a1,a2,a3,a4){try{return Module["dynCall_iidid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddddddddii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viddddddddii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_vidiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_iiiiiiii":invoke_iiiiiiii,"invoke_viiiii":invoke_viiiii,"invoke_vddddddi":invoke_vddddddi,"invoke_viiiiiddi":invoke_viiiiiddi,"invoke_vid":invoke_vid,"invoke_iiidi":invoke_iiidi,"invoke_viiidii":invoke_viiidii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_viidii":invoke_viidii,"invoke_vii":invoke_vii,"invoke_iiiiiii":invoke_iiiiiii,"invoke_viiiiddi":invoke_viiiiddi,"invoke_ii":invoke_ii,"invoke_viddddddddi":invoke_viddddddddi,"invoke_viddii":invoke_viddii,"invoke_viidi":invoke_viidi,"invoke_diiiiidd":invoke_diiiiidd,"invoke_iidi":invoke_iidi,"invoke_viddiii":invoke_viddiii,"invoke_vidii":invoke_vidii,"invoke_dii":invoke_dii,"invoke_viddd":invoke_viddd,"invoke_iiiiii":invoke_iiiiii,"invoke_vidi":invoke_vidi,"invoke_diiiiiiii":invoke_diiiiiiii,"invoke_viiiiddddiid":invoke_viiiiddddiid,"invoke_iddii":invoke_iddii,"invoke_diiiii":invoke_diiiii,"invoke_vidd":invoke_vidd,"invoke_iiii":invoke_iiii,"invoke_viiiiid":invoke_viiiiid,"invoke_vi":invoke_vi,"invoke_diii":invoke_diii,"invoke_diiii":invoke_diiii,"invoke_viddddd":invoke_viddddd,"invoke_viiiidii":invoke_viiiidii,"invoke_di":invoke_di,"invoke_viiidi":invoke_viiidi,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_dd":invoke_dd,"invoke_viiiiiiii":invoke_viiiiiiii,"invoke_diiidii":invoke_diiidii,"invoke_vidddd":invoke_vidddd,"invoke_viiiddiiiiiii":invoke_viiiddiiiiiii,"invoke_iid":invoke_iid,"invoke_viiiiiiiid":invoke_viiiiiiiid,"invoke_viiiiii":invoke_viiiiii,"invoke_iiddd":invoke_iiddd,"invoke_viiiidddiii":invoke_viiiidddiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_iiddi":invoke_iiddi,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_iii":invoke_iii,"invoke_diiiiiiiiii":invoke_diiiiiiiiii,"invoke_viiiddd":invoke_viiiddd,"invoke_didd":invoke_didd,"invoke_vidddddd":invoke_vidddddd,"invoke_d":invoke_d,"invoke_viiiiiii":invoke_viiiiiii,"invoke_diiiiiiiii":invoke_diiiiiiiii,"invoke_did":invoke_did,"invoke_iiiiddd":invoke_iiiiddd,"invoke_viiiidddddidi":invoke_viiiidddddidi,"invoke_diidii":invoke_diidii,"invoke_iiid":invoke_iiid,"invoke_iiiii":invoke_iiiii,"invoke_i":invoke_i,"invoke_viiid":invoke_viiid,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_viid":invoke_viid,"invoke_iidid":invoke_iidid,"invoke_viddddddddii":invoke_viddddddddii,"invoke_vidiii":invoke_vidiii,"invoke_viiii":invoke_viiii,"_glClearStencil":_glClearStencil,"_glUseProgram":_glUseProgram,"_exp":_exp,"___syscall220":___syscall220,"_Mix_Playing":_Mix_Playing,"_sqrtf":_sqrtf,"_glUniformMatrix4fv":_glUniformMatrix4fv,"___cxa_guard_acquire":___cxa_guard_acquire,"_SDL_RWFromFile":_SDL_RWFromFile,"_glUniform2fv":_glUniform2fv,"___assert_fail":___assert_fail,"_glDeleteProgram":_glDeleteProgram,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_longjmp":_longjmp,"_glBindBuffer":_glBindBuffer,"_glCullFace":_glCullFace,"_glGetShaderInfoLog":_glGetShaderInfoLog,"_Mix_Volume":_Mix_Volume,"_SDL_GetError":_SDL_GetError,"_glGetUniformLocation":_glGetUniformLocation,"_emscripten_set_main_loop_timing":_emscripten_set_main_loop_timing,"_sbrk":_sbrk,"_glBlendFunc":_glBlendFunc,"_glGetAttribLocation":_glGetAttribLocation,"_glDisableVertexAttribArray":_glDisableVertexAttribArray,"_Mix_PlayChannel":_Mix_PlayChannel,"_TTF_RenderText_Solid":_TTF_RenderText_Solid,"_sysconf":_sysconf,"_Mix_PlayMusic":_Mix_PlayMusic,"_acosf":_acosf,"_fabs":_fabs,"_cos":_cos,"_glUniform3f":_glUniform3f,"_glGenBuffers":_glGenBuffers,"_glShaderSource":_glShaderSource,"_expf":_expf,"___cxa_atexit":___cxa_atexit,"_pthread_cleanup_push":_pthread_cleanup_push,"_Mix_HaltMusic":_Mix_HaltMusic,"___syscall140":___syscall140,"___syscall145":___syscall145,"___syscall146":___syscall146,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_glGenerateMipmap":_glGenerateMipmap,"_emscripten_get_now_is_monotonic":_emscripten_get_now_is_monotonic,"_glHint":_glHint,"_SDL_GL_SetAttribute":_SDL_GL_SetAttribute,"_atan2":_atan2,"_glGetProgramInfoLog":_glGetProgramInfoLog,"_SDL_GetTicks":_SDL_GetTicks,"_Mix_CloseAudio":_Mix_CloseAudio,"___syscall183":___syscall183,"___cxa_free_exception":___cxa_free_exception,"_atan2f":_atan2f,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_glDrawElements":_glDrawElements,"___cxa_guard_release":___cxa_guard_release,"_glBufferSubData":_glBufferSubData,"_SDL_LockSurface":_SDL_LockSurface,"_glViewport":_glViewport,"_sin":_sin,"___setErrNo":___setErrNo,"_glDeleteTextures":_glDeleteTextures,"_glDepthFunc":_glDepthFunc,"_putenv":_putenv,"___resumeException":___resumeException,"___cxa_call_unexpected":___cxa_call_unexpected,"___buildEnvironment":___buildEnvironment,"_pthread_once":_pthread_once,"_glGenTextures":_glGenTextures,"_glGetIntegerv":_glGetIntegerv,"_glGetString":_glGetString,"_glewInit":_glewInit,"emscriptenWebGLGet":emscriptenWebGLGet,"___syscall12":___syscall12,"_emscripten_get_now":_emscripten_get_now,"___syscall10":___syscall10,"_glAttachShader":_glAttachShader,"_glCreateProgram":_glCreateProgram,"___lock":___lock,"_SDL_SetVideoMode":_SDL_SetVideoMode,"___syscall6":___syscall6,"___syscall5":___syscall5,"_time":_time,"_glBindFramebuffer":_glBindFramebuffer,"_gettimeofday":_gettimeofday,"_pthread_key_create":_pthread_key_create,"_glGenFramebuffers":_glGenFramebuffers,"_SDL_UpperBlitScaled":_SDL_UpperBlitScaled,"_exit":_exit,"___cxa_guard_abort":___cxa_guard_abort,"___syscall221":___syscall221,"_glUniform1fv":_glUniform1fv,"_llvm_pow_f64":_llvm_pow_f64,"_glDeleteFramebuffers":_glDeleteFramebuffers,"_IMG_Load":_IMG_Load,"_TTF_FontHeight":_TTF_FontHeight,"_glCheckFramebufferStatus":_glCheckFramebufferStatus,"_ceilf":_ceilf,"_glClearColor":_glClearColor,"___cxa_allocate_exception":___cxa_allocate_exception,"_glVertexAttribPointer":_glVertexAttribPointer,"_floor":_floor,"_glCompressedTexImage2D":_glCompressedTexImage2D,"_sinf":_sinf,"_glUniform3fv":_glUniform3fv,"_Mix_LoadWAV":_Mix_LoadWAV,"_emscripten_async_wget2_data":_emscripten_async_wget2_data,"_localtime_r":_localtime_r,"_tzset":_tzset,"_fabsf":_fabsf,"_SDL_Init":_SDL_Init,"_glUniform1f":_glUniform1f,"___syscall195":___syscall195,"___cxa_end_catch":___cxa_end_catch,"_clock_gettime":_clock_gettime,"_glUniform1i":_glUniform1i,"___cxa_begin_catch":___cxa_begin_catch,"_pthread_getspecific":_pthread_getspecific,"_Mix_Init":_Mix_Init,"_glDrawArrays":_glDrawArrays,"_glCreateShader":_glCreateShader,"_glGetError":_glGetError,"_glGetActiveAttrib":_glGetActiveAttrib,"_getenv":_getenv,"_floorf":_floorf,"_SDL_UpperBlit":_SDL_UpperBlit,"_log":_log,"_glActiveTexture":_glActiveTexture,"___syscall39":___syscall39,"_tan":_tan,"_glCompileShader":_glCompileShader,"_glEnableVertexAttribArray":_glEnableVertexAttribArray,"_abort":_abort,"_glBindVertexArray":_glBindVertexArray,"_Mix_PlayChannelTimed":_Mix_PlayChannelTimed,"_glDeleteBuffers":_glDeleteBuffers,"_glBufferData":_glBufferData,"_glTexImage2D":_glTexImage2D,"_localtime":_localtime,"___cxa_pure_virtual":___cxa_pure_virtual,"_Mix_ReserveChannels":_Mix_ReserveChannels,"_tanf":_tanf,"_Mix_LoadWAV_RW":_Mix_LoadWAV_RW,"_glDeleteShader":_glDeleteShader,"_cosf":_cosf,"_glGetProgramiv":_glGetProgramiv,"emscriptenWebGLGetTexPixelData":emscriptenWebGLGetTexPixelData,"_glScissor":_glScissor,"_glGetActiveUniform":_glGetActiveUniform,"emscriptenWebGLComputeImageSize":emscriptenWebGLComputeImageSize,"_SDL_CloseAudio":_SDL_CloseAudio,"___gxx_personality_v0":___gxx_personality_v0,"_glLinkProgram":_glLinkProgram,"_SDL_FreeRW":_SDL_FreeRW,"_SDL_PauseAudio":_SDL_PauseAudio,"_llvm_eh_typeid_for":_llvm_eh_typeid_for,"_SDL_PollEvent":_SDL_PollEvent,"_Mix_OpenAudio":_Mix_OpenAudio,"_emscripten_cancel_main_loop":_emscripten_cancel_main_loop,"_glClear":_glClear,"_glUniform4fv":_glUniform4fv,"_Mix_FreeChunk":_Mix_FreeChunk,"__Z13hspd_geterror8HSPERROR":__Z13hspd_geterror8HSPERROR,"_glBindTexture":_glBindTexture,"__exit":__exit,"_IMG_Load_RW":_IMG_Load_RW,"_glPixelStorei":_glPixelStorei,"_glGetShaderiv":_glGetShaderiv,"_glDeleteVertexArrays":_glDeleteVertexArrays,"_pthread_self":_pthread_self,"_Mix_HaltChannel":_Mix_HaltChannel,"_glClearDepth":_glClearDepth,"_glEnable":_glEnable,"_TTF_SizeText":_TTF_SizeText,"___syscall54":___syscall54,"___unlock":___unlock,"_glFramebufferTexture2D":_glFramebufferTexture2D,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_emscripten_set_main_loop":_emscripten_set_main_loop,"_glDepthMask":_glDepthMask,"_pthread_setspecific":_pthread_setspecific,"___cxa_throw":___cxa_throw,"_Mix_Quit":_Mix_Quit,"_glUniform1iv":_glUniform1iv,"_SDL_GL_SwapBuffers":_SDL_GL_SwapBuffers,"_llvm_pow_f32":_llvm_pow_f32,"_glDisable":_glDisable,"_glTexParameteri":_glTexParameteri,"_emscripten_longjmp":_emscripten_longjmp,"_emscripten_asm_const_1":_emscripten_asm_const_1,"_atexit":_atexit,"_sqrt":_sqrt,"_SDL_RWFromConstMem":_SDL_RWFromConstMem,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"___dso_handle":___dso_handle};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.___dso_handle|0;var o=0;var p=0;var q=0;var r=0;var s=global.NaN,t=global.Infinity;var u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=global.Math.floor;var O=global.Math.abs;var P=global.Math.sqrt;var Q=global.Math.pow;var R=global.Math.cos;var S=global.Math.sin;var T=global.Math.tan;var U=global.Math.acos;var V=global.Math.asin;var W=global.Math.atan;var X=global.Math.atan2;var Y=global.Math.exp;var Z=global.Math.log;var _=global.Math.ceil;var $=global.Math.imul;var aa=global.Math.min;var ba=global.Math.clz32;var ca=env.abort;var da=env.assert;var ea=env.invoke_iiiiiiii;var fa=env.invoke_viiiii;var ga=env.invoke_vddddddi;var ha=env.invoke_viiiiiddi;var ia=env.invoke_vid;var ja=env.invoke_iiidi;var ka=env.invoke_viiidii;var la=env.invoke_iiiiiiiiii;var ma=env.invoke_viidii;var na=env.invoke_vii;var oa=env.invoke_iiiiiii;var pa=env.invoke_viiiiddi;var qa=env.invoke_ii;var ra=env.invoke_viddddddddi;var sa=env.invoke_viddii;var ta=env.invoke_viidi;var ua=env.invoke_diiiiidd;var va=env.invoke_iidi;var wa=env.invoke_viddiii;var xa=env.invoke_vidii;var ya=env.invoke_dii;var za=env.invoke_viddd;var Aa=env.invoke_iiiiii;var Ba=env.invoke_vidi;var Ca=env.invoke_diiiiiiii;var Da=env.invoke_viiiiddddiid;var Ea=env.invoke_iddii;var Fa=env.invoke_diiiii;var Ga=env.invoke_vidd;var Ha=env.invoke_iiii;var Ia=env.invoke_viiiiid;var Ja=env.invoke_vi;var Ka=env.invoke_diii;var La=env.invoke_diiii;var Ma=env.invoke_viddddd;var Na=env.invoke_viiiidii;var Oa=env.invoke_di;var Pa=env.invoke_viiidi;var Qa=env.invoke_iiiiiiiiiii;var Ra=env.invoke_dd;var Sa=env.invoke_viiiiiiii;var Ta=env.invoke_diiidii;var Ua=env.invoke_vidddd;var Va=env.invoke_viiiddiiiiiii;var Wa=env.invoke_iid;var Xa=env.invoke_viiiiiiiid;var Ya=env.invoke_viiiiii;var Za=env.invoke_iiddd;var _a=env.invoke_viiiidddiii;var $a=env.invoke_viiiiiiiii;var ab=env.invoke_iiddi;var bb=env.invoke_viiiiiiiiii;var cb=env.invoke_iii;var db=env.invoke_diiiiiiiiii;var eb=env.invoke_viiiddd;var fb=env.invoke_didd;var gb=env.invoke_vidddddd;var hb=env.invoke_d;var ib=env.invoke_viiiiiii;var jb=env.invoke_diiiiiiiii;var kb=env.invoke_did;var lb=env.invoke_iiiiddd;var mb=env.invoke_viiiidddddidi;var nb=env.invoke_diidii;var ob=env.invoke_iiid;var pb=env.invoke_iiiii;var qb=env.invoke_i;var rb=env.invoke_viiid;var sb=env.invoke_viii;var tb=env.invoke_v;var ub=env.invoke_viid;var vb=env.invoke_iidid;var wb=env.invoke_viddddddddii;var xb=env.invoke_vidiii;var yb=env.invoke_viiii;var zb=env._glClearStencil;var Ab=env._glUseProgram;var Bb=env._exp;var Cb=env.___syscall220;var Db=env._Mix_Playing;var Eb=env._sqrtf;var Fb=env._glUniformMatrix4fv;var Gb=env.___cxa_guard_acquire;var Hb=env._SDL_RWFromFile;var Ib=env._glUniform2fv;var Jb=env.___assert_fail;var Kb=env._glDeleteProgram;var Lb=env.__ZSt18uncaught_exceptionv;var Mb=env._longjmp;var Nb=env._glBindBuffer;var Ob=env._glCullFace;var Pb=env._glGetShaderInfoLog;var Qb=env._Mix_Volume;var Rb=env._SDL_GetError;var Sb=env._glGetUniformLocation;var Tb=env._emscripten_set_main_loop_timing;var Ub=env._sbrk;var Vb=env._glBlendFunc;var Wb=env._glGetAttribLocation;var Xb=env._glDisableVertexAttribArray;var Yb=env._Mix_PlayChannel;var Zb=env._TTF_RenderText_Solid;var _b=env._sysconf;var $b=env._Mix_PlayMusic;var ac=env._acosf;var bc=env._fabs;var cc=env._cos;var dc=env._glUniform3f;var ec=env._glGenBuffers;var fc=env._glShaderSource;var gc=env._expf;var hc=env.___cxa_atexit;var ic=env._pthread_cleanup_push;var jc=env._Mix_HaltMusic;var kc=env.___syscall140;var lc=env.___syscall145;var mc=env.___syscall146;var nc=env._pthread_cleanup_pop;var oc=env._glGenerateMipmap;var pc=env._emscripten_get_now_is_monotonic;var qc=env._glHint;var rc=env._SDL_GL_SetAttribute;var sc=env._atan2;var tc=env._glGetProgramInfoLog;var uc=env._SDL_GetTicks;var vc=env._Mix_CloseAudio;var wc=env.___syscall183;var xc=env.___cxa_free_exception;var yc=env._atan2f;var zc=env.___cxa_find_matching_catch;var Ac=env._glDrawElements;var Bc=env.___cxa_guard_release;var Cc=env._glBufferSubData;var Dc=env._SDL_LockSurface;var Ec=env._glViewport;var Fc=env._sin;var Gc=env.___setErrNo;var Hc=env._glDeleteTextures;var Ic=env._glDepthFunc;var Jc=env._putenv;var Kc=env.___resumeException;var Lc=env.___cxa_call_unexpected;var Mc=env.___buildEnvironment;var Nc=env._pthread_once;var Oc=env._glGenTextures;var Pc=env._glGetIntegerv;var Qc=env._glGetString;var Rc=env._glewInit;var Sc=env.emscriptenWebGLGet;var Tc=env.___syscall12;var Uc=env._emscripten_get_now;var Vc=env.___syscall10;var Wc=env._glAttachShader;var Xc=env._glCreateProgram;var Yc=env.___lock;var Zc=env._SDL_SetVideoMode;var _c=env.___syscall6;var $c=env.___syscall5;var ad=env._time;var bd=env._glBindFramebuffer;var cd=env._gettimeofday;var dd=env._pthread_key_create;var ed=env._glGenFramebuffers;var fd=env._SDL_UpperBlitScaled;var gd=env._exit;var hd=env.___cxa_guard_abort;var id=env.___syscall221;var jd=env._glUniform1fv;var kd=env._llvm_pow_f64;var ld=env._glDeleteFramebuffers;var md=env._IMG_Load;var nd=env._TTF_FontHeight;var od=env._glCheckFramebufferStatus;var pd=env._ceilf;var qd=env._glClearColor;var rd=env.___cxa_allocate_exception;var sd=env._glVertexAttribPointer;var td=env._floor;var ud=env._glCompressedTexImage2D;var vd=env._sinf;var wd=env._glUniform3fv;var xd=env._Mix_LoadWAV;var yd=env._emscripten_async_wget2_data;var zd=env._localtime_r;var Ad=env._tzset;var Bd=env._fabsf;var Cd=env._SDL_Init;var Dd=env._glUniform1f;var Ed=env.___syscall195;var Fd=env.___cxa_end_catch;var Gd=env._clock_gettime;var Hd=env._glUniform1i;var Id=env.___cxa_begin_catch;var Jd=env._pthread_getspecific;var Kd=env._Mix_Init;var Ld=env._glDrawArrays;var Md=env._glCreateShader;var Nd=env._glGetError;var Od=env._glGetActiveAttrib;var Pd=env._getenv;var Qd=env._floorf;var Rd=env._SDL_UpperBlit;var Sd=env._log;var Td=env._glActiveTexture;var Ud=env.___syscall39;var Vd=env._tan;var Wd=env._glCompileShader;var Xd=env._glEnableVertexAttribArray;var Yd=env._abort;var Zd=env._glBindVertexArray;var _d=env._Mix_PlayChannelTimed;var $d=env._glDeleteBuffers;var ae=env._glBufferData;var be=env._glTexImage2D;var ce=env._localtime;var de=env.___cxa_pure_virtual;var ee=env._Mix_ReserveChannels;var fe=env._tanf;var ge=env._Mix_LoadWAV_RW;var he=env._glDeleteShader;var ie=env._cosf;var je=env._glGetProgramiv;var ke=env.emscriptenWebGLGetTexPixelData;var le=env._glScissor;var me=env._glGetActiveUniform;var ne=env.emscriptenWebGLComputeImageSize;var oe=env._SDL_CloseAudio;var pe=env.___gxx_personality_v0;var qe=env._glLinkProgram;var re=env._SDL_FreeRW;var se=env._SDL_PauseAudio;var te=env._llvm_eh_typeid_for;var ue=env._SDL_PollEvent;var ve=env._Mix_OpenAudio;var we=env._emscripten_cancel_main_loop;var xe=env._glClear;var ye=env._glUniform4fv;var ze=env._Mix_FreeChunk;var Ae=env.__Z13hspd_geterror8HSPERROR;var Be=env._glBindTexture;var Ce=env.__exit;var De=env._IMG_Load_RW;var Ee=env._glPixelStorei;var Fe=env._glGetShaderiv;var Ge=env._glDeleteVertexArrays;var He=env._pthread_self;var Ie=env._Mix_HaltChannel;var Je=env._glClearDepth;var Ke=env._glEnable;var Le=env._TTF_SizeText;var Me=env.___syscall54;var Ne=env.___unlock;var Oe=env._glFramebufferTexture2D;var Pe=env._emscripten_memcpy_big;var Qe=env._emscripten_set_main_loop;var Re=env._glDepthMask;var Se=env._pthread_setspecific;var Te=env.___cxa_throw;var Ue=env._Mix_Quit;var Ve=env._glUniform1iv;var We=env._SDL_GL_SwapBuffers;var Xe=env._llvm_pow_f32;var Ye=env._glDisable;var Ze=env._glTexParameteri;var _e=env._emscripten_longjmp;var $e=env._emscripten_asm_const_1;var af=env._atexit;var bf=env._sqrt;var cf=env._SDL_RWFromConstMem;var df=0.0;
// EMSCRIPTEN_START_FUNCS
function Ji(f,g){f=f|0;g=g|0;var j=0.0,k=0,l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0.0;H=i;i=i+1136|0;G=H+16|0;F=H+8|0;E=H;A=H+112|0;D=H+80|0;r=H+72|0;k=H+64|0;m=H+60|0;B=H+56|0;n=H+52|0;v=H+48|0;u=H+44|0;x=H+40|0;s=H+36|0;p=H+32|0;t=H+28|0;w=H+24|0;if(c[c[1087]>>2]|0){H=rd(4)|0;c[H>>2]=32;Te(H|0,8,0)}if((c[c[1088]>>2]|0)!=40){H=rd(4)|0;c[H>>2]=32;Te(H|0,8,0)}ah();switch(g>>7|0){case 2:{c[f>>2]=2;C=0;break}case 3:{c[f>>2]=3;C=56;break}default:{c[f>>2]=4;C=4356}}a:do switch(g|0){case 0:if((dh()|0)<-1){H=rd(4)|0;c[H>>2]=32;Te(H|0,8,0)}else{c[1089]=c[(fj(c[971]|0,4)|0)>>2];q=C;break a}case 1:{f=hh()|0;if(!f){H=rd(4)|0;c[H>>2]=19;Te(H|0,8,0)}else{c[r>>2]=0;c[r+4>>2]=f+-1;c[1089]=Ki(r,4360,r)|0;q=C;break a}}case 2:{c[1089]=F8(eh()|0)|0;q=C;break}case 6:case 5:case 4:case 3:{c[1089]=c[(nh()|0)+4+(g+-2<<2)>>2];q=C;break}case 7:{if((c[c[1087]>>2]|0)!=2){mh(k)|0;c[1089]=b[c[k>>2]>>1];q=C;break a}f=gj(eh()|0)|0;if(!f){H=rd(4)|0;c[H>>2]=3;Te(H|0,8,0)}else{c[1089]=b[f>>1];q=C;break a}}case 8:{c[1089]=Dp(hh()|0)|0;q=C;break}case 11:case 10:case 9:{f=sh(m,B)|0;k=ih(0)|0;if((k|0)<0){H=rd(4)|0;c[H>>2]=3;Te(H|0,8,0)}f=f+k|0;switch(g|0){case 9:if((k|0)<(c[B>>2]|0)){c[1089]=d[f>>0];q=C;break a}else{H=rd(4)|0;c[H>>2]=3;Te(H|0,8,0)}case 10:if((k+2|0)>(c[B>>2]|0)){H=rd(4)|0;c[H>>2]=3;Te(H|0,8,0)}else{c[1089]=e[f>>1];q=C;break a}default:if((k+4|0)>(c[B>>2]|0)){H=rd(4)|0;c[H>>2]=3;Te(H|0,8,0)}else{c[1089]=c[f>>2];q=C;break a}}}case 12:if((c[c[1087]>>2]|0)==16){c[1089]=c[(c[(c[1085]|0)+840>>2]|0)+((c[c[1088]>>2]|0)*28|0)+24>>2];ah();q=C;break a}else{G=mh(n)|0;q=c[n>>2]|0;c[q+40>>2]=G;c[1089]=rf[c[(c[6908>>2]|0)+((b[q>>1]<<16>>16)*140|0)+28>>2]&255](q)|0;q=C;break a}case 13:{f=mh(v)|0;k=c[v>>2]|0;if(!(b[k+36>>1]&128)){H=rd(4)|0;c[H>>2]=6;Te(H|0,8,0)}else{c[k+40>>2]=f;q=rf[c[(c[6908>>2]|0)+((b[k>>1]<<16>>16)*140|0)+28>>2]&255](k)|0;c[1089]=rf[c[(c[6908>>2]|0)+((b[c[v>>2]>>1]<<16>>16)*140|0)+60>>2]&255](q)|0;q=C;break a}}case 14:{f=ih(0)|0;k=c[1085]|0;m=c[k+808>>2]|0;if(!m){H=rd(4)|0;c[H>>2]=3;Te(H|0,8,0)}c[m+40>>2]=c[k+812>>2];Wl(6860,rf[c[(c[6908>>2]|0)+((b[m>>1]<<16>>16)*140|0)+28>>2]&255](m)|0);switch(f|0){case 0:{c[1089]=_l(6860)|0;q=C;break a}case 1:{c[1089]=Xl(6860)|0;q=C;break a}default:{H=rd(4)|0;c[H>>2]=3;Te(H|0,8,0)}}}case 15:{m=sh(u,x)|0;if((b[c[u>>2]>>1]|0)!=2){H=rd(4)|0;c[H>>2]=6;Te(H|0,8,0)}k=ih(0)|0;if((k|0)>=(c[x>>2]|0)){H=rd(4)|0;c[H>>2]=20;Te(H|0,8,0)}f=eh()|0;if((k|0)>-1?(y=m+k|0,z=wp(y,f)|0,(z|0)!=0):0){c[1089]=z-y;q=C;break a}c[1089]=-1;q=C;break}case 16:{f=hh()|0;c[1089]=f;if((f|0)<0){c[1089]=0-f;q=C}else q=C;break}case 17:{c[1089]=Hp(hh()|0,hh()|0,hh()|0)|0;q=C;break}case 18:{f=hh()|0;k=ih(-1)|0;if((k|0)>0)j=+(f|0)/+(k|0);else j=+(f|0)*+h[6];c[1089]=~~+Li(j);q=C;break}case 19:{f=xh(eh()|0)|0;k=ih(0)|0;m=c[1085]|0;n=c[m+808>>2]|0;if(!n){H=rd(4)|0;c[H>>2]=3;Te(H|0,8,0)}else{c[n+40>>2]=c[m+812>>2];Wl(6860,rf[c[(c[6908>>2]|0)+((b[n>>1]<<16>>16)*140|0)+28>>2]&255](n)|0);c[1089]=am(6860,f,k)|0;q=C;break a}}case 256:if((dh()|0)<-1){H=rd(4)|0;c[H>>2]=32;Te(H|0,8,0)}else{q=fj(c[971]|0,2)|0;break a}case 257:{r=sh(s,p)|0;if((b[c[s>>2]>>1]|0)!=2){H=rd(4)|0;c[H>>2]=6;Te(H|0,8,0)}f=hh()|0;k=hh()|0;m=F8(r)|0;if((f|0)<0){f=m-k|0;f=(f|0)<0?0:f}p=(f|0)<(m|0)?k:0;p=(p|0)>(m|0)?m:p;q=wh(p+1|0)|0;b:do if((p|0)>0){m=0;n=q;k=r+f|0;while(1){G=a[k>>0]|0;f=n+1|0;a[n>>0]=G;if(!(G<<24>>24))break b;m=m+1|0;if((m|0)>=(p|0))break;else{n=f;k=k+1|0}}}else f=q;while(0);a[f>>0]=0;break}case 259:{I8(A,eh()|0,1024)|0;a[A+1023>>0]=0;x=D+31|0;m=1024;f=Ll(1024)|0;t=A;r=0;c:while(1){n=0;d:while(1){k=t+n|0;switch(a[k>>0]|0){case 37:case 0:{s=k;break d}default:{}}n=n+1|0}k=n+r|0;if((k|0)>=(m|0)){while(1)if((k|0)<(m|0))break;else m=m<<1;o=0;p=cb(33,f|0,m|0)|0;C=o;o=0;if(C&1){m=87;break}else{f=p;u=m}}else u=m;K9(f+r|0,t|0,n|0)|0;if(!(a[s>>0]|0)){m=117;break}n=n+1|0;p=K8(t+n|0,31698)|0;I8(D,s,32)|0;a[x>>0]=0;m=p+2|0;if((m|0)<32)a[D+m>>0]=0;w=p+n|0;C=a[t+w>>0]|0;w=t+(w+1)|0;m=C<<24>>24;switch(C<<24>>24){case 0:{m=117;break c}case 37:{p=k+1|0;if((p|0)>=(u|0)){m=u;while(1)if((p|0)<(m|0))break;else m=m<<1;o=0;n=cb(33,f|0,m|0)|0;C=o;o=0;if(C&1){m=87;break c}else f=n}else m=u;a[f+k>>0]=37;t=w;r=p;continue c}default:{}}o=0;n=qb(10)|0;C=o;o=0;if(C&1){m=87;break}if((n|0)<-1){m=99;break}switch(m|0){case 112:case 117:case 88:case 120:case 111:case 99:case 105:case 100:{o=0;m=cb(45,c[971]|0,4)|0;C=o;o=0;if(C&1){m=87;break c}else v=4;break}case 71:case 103:case 69:case 101:case 102:{o=0;m=cb(45,c[971]|0,3)|0;C=o;o=0;if(C&1){m=87;break c}else v=3;break}case 115:{o=0;m=cb(45,c[971]|0,2)|0;C=o;o=0;if(C&1){m=87;break c}else v=2;break}default:{m=105;break c}}n=u;e:while(1){u=n-k+-1|0;t=f+k|0;s=u<<1;s=(s|0)<32?32:s;switch(v|0){case 4:{do{c[F>>2]=c[m>>2];r=V7(t,u,D,F)|0;p=(r|0)>-1;if(p&(r|0)<(u|0)){m=n;n=r;break e}p=(p?r+1|0:s)+k|0}while((p|0)<(n|0));break}case 3:{do{h[G>>3]=+h[m>>3];r=V7(t,u,D,G)|0;p=(r|0)>-1;if(p&(r|0)<(u|0)){m=n;n=r;break e}p=(p?r+1|0:s)+k|0}while((p|0)<(n|0));break}default:do{c[E>>2]=m;r=V7(t,u,D,E)|0;p=(r|0)>-1;if(p&(r|0)<(u|0)){m=n;n=r;break e}p=(p?r+1|0:s)+k|0}while((p|0)<(n|0))}while(1)if((p|0)<(n|0)){p=n;break}else n=n<<1;o=0;n=cb(33,f|0,p|0)|0;C=o;o=0;if(C&1){m=86;break c}else{f=n;n=p}}t=w;r=n+k|0}if((m|0)==86)k=zc()|0;else if((m|0)==87)k=zc()|0;else if((m|0)==99){G=rd(4)|0;c[G>>2]=32;o=0;sb(109,G|0,8,0);o=0;m=88}else if((m|0)==105){G=rd(4)|0;c[G>>2]=32;o=0;sb(109,G|0,8,0);o=0;m=88}else if((m|0)==117){a[f+k>>0]=0;o=0;k=qa(118,k+1|0)|0;G=o;o=0;if(G&1)m=88;else{C8(k,f)|0;Nl(f);q=k;break a}}if((m|0)==88)k=zc()|0;o=0;Ja(403,f|0);G=o;o=0;if(G&1){G=zc(0)|0;Di(G)}else Kc(k|0);break}case 260:{q=c[(c[1085]|0)+824>>2]|0;I8(A,eh()|0,255)|0;yp(A,q,hh()|0);break}case 261:{m=sh(t,w)|0;if((b[c[t>>2]>>1]|0)!=2){H=rd(4)|0;c[H>>2]=6;Te(H|0,8,0)}G=ih(0)|0;k=ih(32)|0;f=wh((c[w>>2]|0)+1|0)|0;C8(f,m)|0;switch(G|0){case 0:{Lp(f,k);Jp(f,k);q=f;break a}case 1:{Lp(f,k);q=f;break a}case 2:{Jp(f,k);q=f;break a}case 3:{Kp(f,k);q=f;break a}default:{q=f;break a}}}case 384:{h[7]=+S(+(+jh()));q=C;break}case 385:{h[7]=+R(+(+jh()));q=C;break}case 386:{h[7]=+T(+(+jh()));q=C;break}case 387:{l=+jh();h[7]=+X(+l,+(+kh(1.0)));q=C;break}case 388:{h[7]=+P(+(+jh()));q=C;break}case 389:if((dh()|0)<-1){H=rd(4)|0;c[H>>2]=32;Te(H|0,8,0)}else{h[7]=+h[(fj(c[971]|0,3)|0)>>3];q=C;break a}case 390:{j=+jh();h[7]=j;if(j<0.0){h[7]=-j;q=C}else q=C;break}case 391:{h[7]=+Y(+(+jh()));q=C;break}case 392:{h[7]=+Z(+(+jh()));q=C;break}case 393:{l=+jh();I=+jh();j=+jh();l=l<I?I:l;h[7]=l>j?j:l;q=C;break}case 394:{I=+jh();h[7]=+Q(+I,+(+jh()));q=C;break}case 395:{j=+jh();l=+kh(1.0);if(l==1.0){h[7]=+Li(j);q=C;break a}if(l==0.0)j=0.0;else j=+Li(j/l);h[7]=j;q=C;break}default:{H=rd(4)|0;c[H>>2]=21;Te(H|0,8,0)}}while(0);if(c[c[1087]>>2]|0){H=rd(4)|0;c[H>>2]=32;Te(H|0,8,0)}if((c[c[1088]>>2]|0)==41){ah();i=H;return q|0}else{H=rd(4)|0;c[H>>2]=32;Te(H|0,8,0)}return 0}function Ki(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;a=c[d+4>>2]|0;g=c[d>>2]|0;h=a-g+1|0;if((a|0)==(g|0)){d=a;return d|0}if(!h){h=b+2496|0;e=c[h>>2]|0;g=((e+1|0)>>>0)%624|0;d=b+(e<<2)|0;f=c[b+(g<<2)>>2]|0;c[d>>2]=0-(f&1)&-1727483681^c[b+((((e+397|0)>>>0)%624|0)<<2)>>2]^(f&2147483646|c[d>>2]&-2147483648)>>>1;d=c[b+(c[h>>2]<<2)>>2]|0;d=d>>>11^d;c[h>>2]=g;d=d<<7&-1658038656^d;d=d<<15&-272236544^d;d=d>>>18^d;return d|0}e=32-(ba(h|0)|0)|0;e=(((-1>>>(33-e|0)&h|0)==0)<<31>>31)+e|0;e=(e>>>0)/((((e&31|0)!=0&1)+(e>>>5)|0)>>>0)|0;e=(e|0)==0?0:-1>>>(32-e|0);f=b+2496|0;g=c[f>>2]|0;do{j=g;g=((g+1|0)>>>0)%624|0;a=b+(j<<2)|0;i=c[b+(g<<2)>>2]|0;c[a>>2]=0-(i&1)&-1727483681^c[b+((((j+397|0)>>>0)%624|0)<<2)>>2]^(i&2147483646|c[a>>2]&-2147483648)>>>1;a=c[b+(c[f>>2]<<2)>>2]|0;a=a>>>11^a;c[f>>2]=g;a=a<<7&-1658038656^a;a=a<<15&-272236544^a;a=(a>>>18^a)&e}while(a>>>0>=h>>>0);j=(c[d>>2]|0)+a|0;return j|0}function Li(a){a=+a;var b=0.0,d=0.0,e=0,f=0,g=0,j=0;g=i;i=i+16|0;e=g;j=c[1722]|0;f=j&4095;if(!(j&4096)){a=a<0.0?0.0:a;if(a>1.0){e=0;b=1.0}else{e=0;b=a}}else{b=+n7(a,e);e=~~+h[e>>3]&1}do if((c[1723]|0)!=(e|0)){c[1723]=e;a=+h[8];if(!e){h[10]=a;h[11]=+h[9];break}else{d=+h[9];h[10]=a+d;h[11]=-d;break}}while(0);do switch(f|0){case 1:{d=+h[10]+b*(b*+h[11]);i=g;return +d}case 2:{d=+h[10]-(b+-2.0)*(b*+h[11]);i=g;return +d}case 3:{a=b*2.0;if(a<1.0){d=+h[10]+a*(a*(+h[11]*.5));i=g;return +d}else{d=a+-1.0;d=+h[10]+(d*(d+-2.0)+-1.0)*(+h[11]*-.5);i=g;return +d}}case 4:{d=+h[10]+b*(b*(b*+h[11]));i=g;return +d}case 5:{d=b+-1.0;d=(d*(d*d)+1.0)*+h[11]+ +h[10];i=g;return +d}case 6:{a=b*2.0;if(a<1.0){d=+h[10]+a*(a*(a*(+h[11]*.5)));i=g;return +d}else{d=a+-2.0;d=+h[10]+(d*(d*d)+2.0)*(+h[11]*.5);i=g;return +d}}case 7:{d=+h[10]+b*(b*(b*(b*+h[11])));i=g;return +d}case 8:{d=b+-1.0;d=+h[10]-(d*(d*(d*d))+-1.0)*+h[11];i=g;return +d}case 9:{a=b*2.0;if(a<1.0){d=+h[10]+a*(a*(a*(a*(+h[11]*.5))));i=g;return +d}else{d=a+-2.0;d=+h[10]+(d*(d*(d*d))+-2.0)*(+h[11]*-.5);i=g;return +d}}case 10:{a=1.0-b;b=+h[11];do if(!(a<.36363636363636365)){if(a<.7272727272727273){a=a+-.5454545454545454;a=a*(a*7.5625)+.75;break}if(a<.9090909090909091){a=a+-.8181818181818182;a=a*(a*7.5625)+.9375;break}else{a=a+-.9545454545454546;a=a*(a*7.5625)+.984375;break}}else a=a*(a*7.5625);while(0);d=+h[10]+(b-b*a);i=g;return +d}case 11:{do if(!(b<.36363636363636365)){if(b<.7272727272727273){a=b+-.5454545454545454;a=(a*(a*7.5625)+.75)*+h[11];break}a=+h[11];if(b<.9090909090909091){d=b+-.8181818181818182;a=(d*(d*7.5625)+.9375)*a;break}else{d=b+-.9545454545454546;a=(d*(d*7.5625)+.984375)*a;break}}else a=b*(b*7.5625)*+h[11];while(0);d=a+ +h[10];i=g;return +d}case 12:{a=b*2.0;if(b<.5){a=1.0-a;b=+h[11];do if(!(a<.36363636363636365)){if(a<.7272727272727273){a=a+-.5454545454545454;a=a*(a*7.5625)+.75;break}if(a<.9090909090909091){a=a+-.8181818181818182;a=a*(a*7.5625)+.9375;break}else{a=a+-.9545454545454546;a=a*(a*7.5625)+.984375;break}}else a=a*(a*7.5625);while(0);d=+h[10]+(b-b*a)*.5;i=g;return +d}else{a=a+-1.0;do if(!(a<.36363636363636365)){if(a<.7272727272727273){d=+h[11];b=a+-.5454545454545454;b=(b*(b*7.5625)+.75)*d;a=d;break}d=+h[11];if(a<.9090909090909091){b=a+-.8181818181818182;b=(b*(b*7.5625)+.9375)*d;a=d;break}else{b=a+-.9545454545454546;b=(b*(b*7.5625)+.984375)*d;a=d;break}}else{d=+h[11];b=a*(a*7.5625)*d;a=d}while(0);d=+h[10]+(a*.5+b*.5);i=g;return +d}}case 13:{b=1.0-b;d=+h[11];a=b*b*8.0;j=~~a;a=a-+(j|0);d=+h[10]+(b*(((j&1|0)==0?a:1.0-a)*d)-b*(d*.5));i=g;return +d}case 14:{d=+h[11];a=b*b*8.0;j=~~a;a=a-+(j|0);d=+h[10]+(b*(((j&1|0)==0?a:1.0-a)*d)-b*(d*.5));i=g;return +d}case 15:{a=b*2.0;if(a<1.0){b=1.0-a;d=+h[11];a=b*b*8.0;j=~~a;a=a-+(j|0);d=+h[10]+(b*(((j&1|0)==0?a:1.0-a)*d)-b*(d*.5));i=g;return +d}else{b=a+-1.0;d=+h[11];a=b*b*8.0;j=~~a;a=a-+(j|0);d=+h[10]+(b*(((j&1|0)==0?a:1.0-a)*d)-b*(d*.5));i=g;return +d}}default:{d=b*+h[11]+ +h[10];i=g;return +d}}while(0);return 0.0}function Mi(a,b){a=a|0;b=b|0;var d=0.0,e=0.0;d=+h[a>>3];e=+h[b>>3];if(d<e){b=1;return b|0}if(!(d!=d|e!=e|d==e)){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Ni(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+16|0;p=q;a:while(1){m=b;n=b+-16|0;b:while(1){l=a;e=m-l|0;f=e>>4;switch(f|0){case 2:{e=n;b=n;o=4;break a}case 3:{g=n;f=n;o=6;break a}case 4:{b=n;o=14;break a}case 5:{h=n;g=n;o=15;break a}case 1:case 0:{o=69;break a}default:{}}if((e|0)<496){o=21;break a}g=(f|0)/2|0;k=a+(g<<4)|0;do if((e|0)>15984){e=(f|0)/4|0;h=a+(e<<4)|0;e=a+(e+g<<4)|0;f=Ti(a,h,k,e,d)|0;if(dg[c[d>>2]&127](n,e)|0){c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[n>>2];c[e+4>>2]=c[n+4>>2];c[e+8>>2]=c[n+8>>2];c[e+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];g=f+1|0;if(dg[c[d>>2]&127](e,k)|0){c[p>>2]=c[k>>2];c[p+4>>2]=c[k+4>>2];c[p+8>>2]=c[k+8>>2];c[p+12>>2]=c[k+12>>2];c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];c[k+8>>2]=c[e+8>>2];c[k+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];e=f+2|0;if(dg[c[d>>2]&127](k,h)|0){c[p>>2]=c[h>>2];c[p+4>>2]=c[h+4>>2];c[p+8>>2]=c[h+8>>2];c[p+12>>2]=c[h+12>>2];c[h>>2]=c[k>>2];c[h+4>>2]=c[k+4>>2];c[h+8>>2]=c[k+8>>2];c[h+12>>2]=c[k+12>>2];c[k>>2]=c[p>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[k+12>>2]=c[p+12>>2];if(dg[c[d>>2]&127](h,a)|0){c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[h>>2];c[a+4>>2]=c[h+4>>2];c[a+8>>2]=c[h+8>>2];c[a+12>>2]=c[h+12>>2];c[h>>2]=c[p>>2];c[h+4>>2]=c[p+4>>2];c[h+8>>2]=c[p+8>>2];c[h+12>>2]=c[p+12>>2];f=f+4|0}else f=f+3|0}else f=e}else f=g}}else{j=dg[c[d>>2]&127](k,a)|0;e=dg[c[d>>2]&127](n,k)|0;if(!j){if(!e){f=0;break};c[p>>2]=c[k>>2];c[p+4>>2]=c[k+4>>2];c[p+8>>2]=c[k+8>>2];c[p+12>>2]=c[k+12>>2];c[k>>2]=c[n>>2];c[k+4>>2]=c[n+4>>2];c[k+8>>2]=c[n+8>>2];c[k+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];if(!(dg[c[d>>2]&127](k,a)|0)){f=1;break};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[k>>2];c[a+4>>2]=c[k+4>>2];c[a+8>>2]=c[k+8>>2];c[a+12>>2]=c[k+12>>2];c[k>>2]=c[p>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[k+12>>2]=c[p+12>>2];f=2;break}if(e){c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[n>>2];c[a+4>>2]=c[n+4>>2];c[a+8>>2]=c[n+8>>2];c[a+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];f=1;break};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[k>>2];c[a+4>>2]=c[k+4>>2];c[a+8>>2]=c[k+8>>2];c[a+12>>2]=c[k+12>>2];c[k>>2]=c[p>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[k+12>>2]=c[p+12>>2];if(dg[c[d>>2]&127](n,k)|0){c[p>>2]=c[k>>2];c[p+4>>2]=c[k+4>>2];c[p+8>>2]=c[k+8>>2];c[p+12>>2]=c[k+12>>2];c[k>>2]=c[n>>2];c[k+4>>2]=c[n+4>>2];c[k+8>>2]=c[n+8>>2];c[k+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];f=2}else f=1}while(0);do if(dg[c[d>>2]&127](a,k)|0)g=n;else{e=n;while(1){e=e+-16|0;if((a|0)==(e|0))break;if(dg[c[d>>2]&127](e,k)|0){o=51;break}}if((o|0)==51){o=0;c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];g=e;f=f+1|0;break}e=a+16|0;if(!(dg[c[d>>2]&127](a,n)|0)){if((e|0)==(n|0)){o=69;break a}else f=a;while(1){if(dg[c[d>>2]&127](a,e)|0)break;f=e+16|0;if((f|0)==(n|0)){o=69;break a}else{l=e;e=f;f=l}}c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[n>>2];c[e+4>>2]=c[n+4>>2];c[e+8>>2]=c[n+8>>2];c[e+12>>2]=c[n+12>>2];c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];e=f+32|0}if((e|0)==(n|0)){o=69;break a}else f=n;while(1){g=e;while(1){e=g+16|0;if(dg[c[d>>2]&127](a,g)|0)break;else g=e}do f=f+-16|0;while(dg[c[d>>2]&127](a,f)|0);if(g>>>0>=f>>>0){a=g;continue b};c[p>>2]=c[g>>2];c[p+4>>2]=c[g+4>>2];c[p+8>>2]=c[g+8>>2];c[p+12>>2]=c[g+12>>2];c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2]}}while(0);e=a+16|0;c:do if(e>>>0<g>>>0){j=g;while(1){g=e;while(1){e=g+16|0;if(dg[c[d>>2]&127](g,k)|0)g=e;else{h=g;break}}g=j;do g=g+-16|0;while(!(dg[c[d>>2]&127](g,k)|0));if(h>>>0>g>>>0){e=h;g=k;break c};c[p>>2]=c[h>>2];c[p+4>>2]=c[h+4>>2];c[p+8>>2]=c[h+8>>2];c[p+12>>2]=c[h+12>>2];c[h>>2]=c[g>>2];c[h+4>>2]=c[g+4>>2];c[h+8>>2]=c[g+8>>2];c[h+12>>2]=c[g+12>>2];c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[g+12>>2]=c[p+12>>2];j=g;k=(k|0)==(h|0)?g:k;f=f+1|0}}else g=k;while(0);if((e|0)!=(g|0)?dg[c[d>>2]&127](g,e)|0:0){c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[g>>2];c[e+4>>2]=c[g+4>>2];c[e+8>>2]=c[g+8>>2];c[e+12>>2]=c[g+12>>2];c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[g+12>>2]=c[p+12>>2];f=f+1|0}if(!f){f=Vi(a,e,d)|0;g=e+16|0;if(Vi(g,b,d)|0){o=64;break}if(f){a=g;continue}}k=e;if((k-l|0)>=(m-k|0)){o=68;break}Ni(a,e,d);a=e+16|0}if((o|0)==64){o=0;if(f){o=69;break}else{b=e;continue}}else if((o|0)==68){o=0;Ni(e+16|0,b,d);b=e;continue}}if((o|0)==4){if(!(dg[c[d>>2]&127](e,a)|0)){i=q;return};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[p>>2];c[b+4>>2]=c[p+4>>2];c[b+8>>2]=c[p+8>>2];c[b+12>>2]=c[p+12>>2];i=q;return}else if((o|0)==6){e=a+16|0;o=dg[c[d>>2]&127](e,a)|0;b=dg[c[d>>2]&127](g,e)|0;if(!o){if(!b){i=q;return};c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2];if(!(dg[c[d>>2]&127](e,a)|0)){i=q;return};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];i=q;return}if(b){c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2];i=q;return};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];if(!(dg[c[d>>2]&127](g,e)|0)){i=q;return};c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2];i=q;return}else if((o|0)==14){Ti(a,a+16|0,a+32|0,b,d)|0;i=q;return}else if((o|0)==15){b=a+16|0;e=a+32|0;f=a+48|0;Ti(a,b,e,f,d)|0;if(!(dg[c[d>>2]&127](h,f)|0)){i=q;return};c[p>>2]=c[f>>2];c[p+4>>2]=c[f+4>>2];c[p+8>>2]=c[f+8>>2];c[p+12>>2]=c[f+12>>2];c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[g+12>>2]=c[p+12>>2];if(!(dg[c[d>>2]&127](f,e)|0)){i=q;return};c[p>>2]=c[e>>2];c[p+4>>2]=c[e+4>>2];c[p+8>>2]=c[e+8>>2];c[p+12>>2]=c[e+12>>2];c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[f>>2]=c[p>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2];c[f+12>>2]=c[p+12>>2];if(!(dg[c[d>>2]&127](e,b)|0)){i=q;return};c[p>>2]=c[b>>2];c[p+4>>2]=c[b+4>>2];c[p+8>>2]=c[b+8>>2];c[p+12>>2]=c[b+12>>2];c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];if(!(dg[c[d>>2]&127](b,a)|0)){i=q;return};c[p>>2]=c[a>>2];c[p+4>>2]=c[a+4>>2];c[p+8>>2]=c[a+8>>2];c[p+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[p>>2];c[b+4>>2]=c[p+4>>2];c[b+8>>2]=c[p+8>>2];c[b+12>>2]=c[p+12>>2];i=q;return}else if((o|0)==21){Ui(a,b,d);i=q;return}else if((o|0)==69){i=q;return}}function Oi(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0;f=+h[a>>3];e=+h[b>>3];d=f<e?-1:f>e&1;if((d|0)>0){b=1;return b|0}if(d){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Pi(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a>>2]|0;e=c[b>>2]|0;if((d|0)<(e|0)){b=1;return b|0}if((d|0)!=(e|0)){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Qi(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a>>2]|0;e=c[b>>2]|0;if((d|0)>(e|0)){b=1;return b|0}if((d|0)!=(e|0)){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Ri(a,b){a=a|0;b=b|0;var d=0;d=B8(c[a>>2]|0,c[b>>2]|0)|0;if((d|0)<0){b=1;return b|0}if(d){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Si(a,b){a=a|0;b=b|0;var d=0;d=B8(c[a>>2]|0,c[b>>2]|0)|0;if((d|0)>0){b=1;return b|0}if(d){b=0;return b|0}b=(c[a+8>>2]|0)<(c[b+8>>2]|0);return b|0}function Ti(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;j=i;i=i+16|0;h=j;k=dg[c[f>>2]&127](b,a)|0;g=dg[c[f>>2]&127](d,b)|0;do if(k){if(g){c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];g=1;break};c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];if(dg[c[f>>2]&127](d,b)|0){c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[h+12>>2]=c[b+12>>2];c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];g=2}else g=1}else if(g){c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[h+12>>2]=c[b+12>>2];c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];if(dg[c[f>>2]&127](b,a)|0){c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];g=2}else g=1}else g=0;while(0);if(!(dg[c[f>>2]&127](e,d)|0)){k=g;i=j;return k|0};c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];if(!(dg[c[f>>2]&127](d,b)|0)){k=g+1|0;i=j;return k|0};c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[h+12>>2]=c[b+12>>2];c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];if(!(dg[c[f>>2]&127](b,a)|0)){k=g+2|0;i=j;return k|0};c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];k=g+3|0;i=j;return k|0}function Ui(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;k=i;i=i+32|0;h=k+16|0;j=k;e=a+32|0;f=a+16|0;l=dg[c[d>>2]&127](f,a)|0;g=dg[c[d>>2]&127](e,f)|0;do if(l){if(g){c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];break};c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];if(dg[c[d>>2]&127](e,f)|0){c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2]}}else if(g?(c[h>>2]=c[f>>2],c[h+4>>2]=c[f+4>>2],c[h+8>>2]=c[f+8>>2],c[h+12>>2]=c[f+12>>2],c[f>>2]=c[e>>2],c[f+4>>2]=c[e+4>>2],c[f+8>>2]=c[e+8>>2],c[f+12>>2]=c[e+12>>2],c[e>>2]=c[h>>2],c[e+4>>2]=c[h+4>>2],c[e+8>>2]=c[h+8>>2],c[e+12>>2]=c[h+12>>2],dg[c[d>>2]&127](f,a)|0):0){c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2]}while(0);f=a+48|0;if((f|0)==(b|0)){i=k;return}while(1){if(dg[c[d>>2]&127](f,e)|0){c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];g=f;while(1){c[g>>2]=c[e>>2];c[g+4>>2]=c[e+4>>2];c[g+8>>2]=c[e+8>>2];c[g+12>>2]=c[e+12>>2];if((e|0)==(a|0))break;g=e+-16|0;if(dg[c[d>>2]&127](j,g)|0){l=e;e=g;g=l}else break}c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2]}e=f+16|0;if((e|0)==(b|0))break;else{l=f;f=e;e=l}}i=k;return}function Vi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;j=m+16|0;k=m;switch(b-a>>4|0){case 2:{e=b+-16|0;if(!(dg[c[d>>2]&127](e,a)|0)){a=1;i=m;return a|0};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];a=1;i=m;return a|0}case 3:{g=a+16|0;f=b+-16|0;b=dg[c[d>>2]&127](g,a)|0;e=dg[c[d>>2]&127](f,g)|0;if(!b){if(!e){a=1;i=m;return a|0};c[j>>2]=c[g>>2];c[j+4>>2]=c[g+4>>2];c[j+8>>2]=c[g+8>>2];c[j+12>>2]=c[g+12>>2];c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];if(!(dg[c[d>>2]&127](g,a)|0)){a=1;i=m;return a|0};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];c[a+8>>2]=c[g+8>>2];c[a+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];a=1;i=m;return a|0}if(e){c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];a=1;i=m;return a|0};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];c[a+8>>2]=c[g+8>>2];c[a+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];if(!(dg[c[d>>2]&127](f,g)|0)){a=1;i=m;return a|0};c[j>>2]=c[g>>2];c[j+4>>2]=c[g+4>>2];c[j+8>>2]=c[g+8>>2];c[j+12>>2]=c[g+12>>2];c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];a=1;i=m;return a|0}case 4:{Ti(a,a+16|0,a+32|0,b+-16|0,d)|0;a=1;i=m;return a|0}case 5:{f=a+16|0;g=a+32|0;h=a+48|0;e=b+-16|0;Ti(a,f,g,h,d)|0;if(!(dg[c[d>>2]&127](e,h)|0)){a=1;i=m;return a|0};c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];c[j+12>>2]=c[h+12>>2];c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];if(!(dg[c[d>>2]&127](h,g)|0)){a=1;i=m;return a|0};c[j>>2]=c[g>>2];c[j+4>>2]=c[g+4>>2];c[j+8>>2]=c[g+8>>2];c[j+12>>2]=c[g+12>>2];c[g>>2]=c[h>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];c[g+12>>2]=c[h+12>>2];c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];if(!(dg[c[d>>2]&127](g,f)|0)){a=1;i=m;return a|0};c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];if(!(dg[c[d>>2]&127](f,a)|0)){a=1;i=m;return a|0};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];a=1;i=m;return a|0}case 1:case 0:{a=1;i=m;return a|0}default:{g=a+32|0;e=a+16|0;h=dg[c[d>>2]&127](e,a)|0;f=dg[c[d>>2]&127](g,e)|0;do if(h){if(f){c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];c[a+8>>2]=c[g+8>>2];c[a+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];break};c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];if(dg[c[d>>2]&127](g,e)|0){c[j>>2]=c[e>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2];c[j+12>>2]=c[e+12>>2];c[e>>2]=c[g>>2];c[e+4>>2]=c[g+4>>2];c[e+8>>2]=c[g+8>>2];c[e+12>>2]=c[g+12>>2];c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2]}}else if(f?(c[j>>2]=c[e>>2],c[j+4>>2]=c[e+4>>2],c[j+8>>2]=c[e+8>>2],c[j+12>>2]=c[e+12>>2],c[e>>2]=c[g>>2],c[e+4>>2]=c[g+4>>2],c[e+8>>2]=c[g+8>>2],c[e+12>>2]=c[g+12>>2],c[g>>2]=c[j>>2],c[g+4>>2]=c[j+4>>2],c[g+8>>2]=c[j+8>>2],c[g+12>>2]=c[j+12>>2],dg[c[d>>2]&127](e,a)|0):0){c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2]}while(0);e=a+48|0;if((e|0)==(b|0)){a=1;i=m;return a|0}f=0;while(1){if(dg[c[d>>2]&127](e,g)|0){c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];c[k+8>>2]=c[e+8>>2];c[k+12>>2]=c[e+12>>2];h=e;while(1){c[h>>2]=c[g>>2];c[h+4>>2]=c[g+4>>2];c[h+8>>2]=c[g+8>>2];c[h+12>>2]=c[g+12>>2];if((g|0)==(a|0))break;h=g+-16|0;if(dg[c[d>>2]&127](k,h)|0){j=g;g=h;h=j}else break}c[g>>2]=c[k>>2];c[g+4>>2]=c[k+4>>2];c[g+8>>2]=c[k+8>>2];c[g+12>>2]=c[k+12>>2];f=f+1|0;if((f|0)==8)break}g=e+16|0;if((g|0)==(b|0)){e=1;l=35;break}else{j=e;e=g;g=j}}if((l|0)==35){i=m;return e|0}a=(e+16|0)==(b|0);i=m;return a|0}}return 0}function Wi(){var a=0;a=Ll(1120)|0;c[1727]=a;c[1728]=8;b[a>>1]=0;b[a+140>>1]=0;b[a+280>>1]=0;b[a+420>>1]=0;b[a+560>>1]=0;b[a+700>>1]=0;b[a+840>>1]=0;b[a+980>>1]=0;a=Ll(384)|0;c[1726]=a;b[a+2>>1]=-1;b[a>>1]=4;b[a+50>>1]=-1;b[a+48>>1]=4;b[a+98>>1]=-1;b[a+96>>1]=4;b[a+146>>1]=-1;b[a+144>>1]=4;b[a+194>>1]=-1;b[a+192>>1]=4;b[a+242>>1]=-1;b[a+240>>1]=4;b[a+290>>1]=-1;b[a+288>>1]=4;b[a+338>>1]=-1;b[a+336>>1]=4;return}function Xi(){var a=0,d=0,e=0,f=0;a=c[1728]|0;if((a|0)>0)e=0;else{e=c[1726]|0;Nl(e);e=c[1727]|0;Nl(e);return}do{f=c[1726]|0;d=f+(e*48|0)|0;if((b[f+(e*48|0)+2>>1]|0)==1){Kf[c[(c[6908>>2]|0)+((b[d>>1]<<16>>16)*140|0)+52>>2]&1023](d);a=c[1728]|0}e=e+1|0}while((e|0)<(a|0));f=c[1726]|0;Nl(f);f=c[1727]|0;Nl(f);return}function Yi(a){a=a|0;var d=0;d=(c[1728]|0)+a|0;c[1729]=d;if((a|0)>-1){c[1727]=Ol(c[1727]|0,d*140|0)|0;c[1726]=Ol(c[1726]|0,(c[1729]|0)*48|0)|0}d=c[1727]|0;a=d+560|0;b[d+562>>1]=4;b[a>>1]=4;d=d+580|0;c[d>>2]=6;c[d+4>>2]=6;c[d+8>>2]=6;c[d+12>>2]=6;c[d+16>>2]=6;c[d+20>>2]=6;c[d+24>>2]=6;c[d+28>>2]=6;c[d+32>>2]=6;c[d+36>>2]=6;c[d+40>>2]=6;c[d+44>>2]=6;c[d+48>>2]=6;c[d+52>>2]=6;c[d+56>>2]=6;c[d+60>>2]=6;c[d+64>>2]=6;c[d+68>>2]=6;c[d+72>>2]=6;c[d+76>>2]=6;c[d+80>>2]=6;c[d+84>>2]=6;c[d+88>>2]=6;c[d+92>>2]=6;c[d+96>>2]=6;c[d+100>>2]=6;c[d+104>>2]=6;c[d+108>>2]=6;c[d+112>>2]=6;c[d+116>>2]=6;Dj(a);a=c[1727]|0;d=a+280|0;b[a+282>>1]=2;b[d>>1]=2;a=a+300|0;c[a>>2]=6;c[a+4>>2]=6;c[a+8>>2]=6;c[a+12>>2]=6;c[a+16>>2]=6;c[a+20>>2]=6;c[a+24>>2]=6;c[a+28>>2]=6;c[a+32>>2]=6;c[a+36>>2]=6;c[a+40>>2]=6;c[a+44>>2]=6;c[a+48>>2]=6;c[a+52>>2]=6;c[a+56>>2]=6;c[a+60>>2]=6;c[a+64>>2]=6;c[a+68>>2]=6;c[a+72>>2]=6;c[a+76>>2]=6;c[a+80>>2]=6;c[a+84>>2]=6;c[a+88>>2]=6;c[a+92>>2]=6;c[a+96>>2]=6;c[a+100>>2]=6;c[a+104>>2]=6;c[a+108>>2]=6;c[a+112>>2]=6;c[a+116>>2]=6;jk(d);d=c[1727]|0;a=d+420|0;b[d+422>>1]=3;b[a>>1]=3;d=d+440|0;c[d>>2]=6;c[d+4>>2]=6;c[d+8>>2]=6;c[d+12>>2]=6;c[d+16>>2]=6;c[d+20>>2]=6;c[d+24>>2]=6;c[d+28>>2]=6;c[d+32>>2]=6;c[d+36>>2]=6;c[d+40>>2]=6;c[d+44>>2]=6;c[d+48>>2]=6;c[d+52>>2]=6;c[d+56>>2]=6;c[d+60>>2]=6;c[d+64>>2]=6;c[d+68>>2]=6;c[d+72>>2]=6;c[d+76>>2]=6;c[d+80>>2]=6;c[d+84>>2]=6;c[d+88>>2]=6;c[d+92>>2]=6;c[d+96>>2]=6;c[d+100>>2]=6;c[d+104>>2]=6;c[d+108>>2]=6;c[d+112>>2]=6;c[d+116>>2]=6;jj(a);a=c[1727]|0;d=a+700|0;b[a+702>>1]=5;b[d>>1]=5;a=a+720|0;c[a>>2]=6;c[a+4>>2]=6;c[a+8>>2]=6;c[a+12>>2]=6;c[a+16>>2]=6;c[a+20>>2]=6;c[a+24>>2]=6;c[a+28>>2]=6;c[a+32>>2]=6;c[a+36>>2]=6;c[a+40>>2]=6;c[a+44>>2]=6;c[a+48>>2]=6;c[a+52>>2]=6;c[a+56>>2]=6;c[a+60>>2]=6;c[a+64>>2]=6;c[a+68>>2]=6;c[a+72>>2]=6;c[a+76>>2]=6;c[a+80>>2]=6;c[a+84>>2]=6;c[a+88>>2]=6;c[a+92>>2]=6;c[a+96>>2]=6;c[a+100>>2]=6;c[a+104>>2]=6;c[a+108>>2]=6;c[a+112>>2]=6;c[a+116>>2]=6;vk(d);d=c[1727]|0;a=d+140|0;b[d+142>>1]=1;b[a>>1]=1;d=d+160|0;c[d>>2]=6;c[d+4>>2]=6;c[d+8>>2]=6;c[d+12>>2]=6;c[d+16>>2]=6;c[d+20>>2]=6;c[d+24>>2]=6;c[d+28>>2]=6;c[d+32>>2]=6;c[d+36>>2]=6;c[d+40>>2]=6;c[d+44>>2]=6;c[d+48>>2]=6;c[d+52>>2]=6;c[d+56>>2]=6;c[d+60>>2]=6;c[d+64>>2]=6;c[d+68>>2]=6;c[d+72>>2]=6;c[d+76>>2]=6;c[d+80>>2]=6;c[d+84>>2]=6;c[d+88>>2]=6;c[d+92>>2]=6;c[d+96>>2]=6;c[d+100>>2]=6;c[d+104>>2]=6;c[d+108>>2]=6;c[d+112>>2]=6;c[d+116>>2]=6;ak(a);return}function Zi(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;if((a|0)<0){a=c[1728]|0;if((a|0)>=(c[1729]|0))return;c[1728]=a+1;e=c[1727]|0;b[e+(a*140|0)>>1]=0;f=c[1726]|0;b[f+(a*48|0)+2>>1]=-1;b[f+(a*48|0)>>1]=4;if((a|0)<0)return}else e=c[1727]|0;f=e+(a*140|0)|0;g=a&65535;b[e+(a*140|0)+2>>1]=g;b[f>>1]=g;a=e+(a*140|0)+20|0;c[a>>2]=6;c[a+4>>2]=6;c[a+8>>2]=6;c[a+12>>2]=6;c[a+16>>2]=6;c[a+20>>2]=6;c[a+24>>2]=6;c[a+28>>2]=6;c[a+32>>2]=6;c[a+36>>2]=6;c[a+40>>2]=6;c[a+44>>2]=6;c[a+48>>2]=6;c[a+52>>2]=6;c[a+56>>2]=6;c[a+60>>2]=6;c[a+64>>2]=6;c[a+68>>2]=6;c[a+72>>2]=6;c[a+76>>2]=6;c[a+80>>2]=6;c[a+84>>2]=6;c[a+88>>2]=6;c[a+92>>2]=6;c[a+96>>2]=6;c[a+100>>2]=6;c[a+104>>2]=6;c[a+108>>2]=6;c[a+112>>2]=6;c[a+116>>2]=6;Kf[d&1023](f);return}function _i(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[1727]|0;Kf[c[g+((b[a>>1]<<16>>16)*140|0)+52>>2]&1023](a);c[a+28>>2]=e;b[a>>1]=d;c[a+24>>2]=f;b[a+2>>1]=2;c[a+4>>2]=1;d=b[g+(d*140|0)+8>>1]|0;if(d<<16>>16<0)d=1;else d=(f|0)/(d<<16>>16|0)|0;c[a+8>>2]=d;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=1;return}function $i(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f;c[d+40>>2]=e;h=rf[c[(c[6908>>2]|0)+((b[d>>1]<<16>>16)*140|0)+28>>2]&255](d)|0;If[c[(c[6908>>2]|0)+((b[d>>1]<<16>>16)*140|0)+64>>2]&127](d,h,g)|0;d=b[d>>1]|0;e=c[g>>2]|0;g=c[1727]|0;Kf[c[g+((b[a>>1]<<16>>16)*140|0)+52>>2]&1023](a);c[a+28>>2]=h;b[a>>1]=d;c[a+24>>2]=e;b[a+2>>1]=2;c[a+4>>2]=1;d=b[g+((d<<16>>16)*140|0)+8>>1]|0;if(d<<16>>16<0)e=1;else e=(e|0)/(d<<16>>16|0)|0;c[a+8>>2]=e;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=1;i=f;return}function aj(a,d,e,f,g,h){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;i=c[1727]|0;if((f|e|g|h|0)<0){a=rd(4)|0;c[a>>2]=3;Te(a|0,8,0)}else{Kf[c[i+((b[a>>1]<<16>>16)*140|0)+52>>2]&1023](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[i+(d*140|0)+6>>1]|0;c[a+8>>2]=e;c[a+12>>2]=f;c[a+16>>2]=g;c[a+20>>2]=h;of[c[i+(d*140|0)+48>>2]&511](a,0);return}}function bj(a,d,e,f,g,h,i){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0;j=c[1727]|0;if((g|f|h|i|0)<0){a=rd(4)|0;c[a>>2]=3;Te(a|0,8,0)}else{Kf[c[j+((b[a>>1]<<16>>16)*140|0)+52>>2]&1023](a);b[a>>1]=d;k=a+4|0;c[k>>2]=e;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[j+(d*140|0)+6>>1]|0;c[a+8>>2]=f;c[a+12>>2]=g;c[a+16>>2]=h;c[a+20>>2]=i;of[c[j+(d*140|0)+48>>2]&511](a,0);c[k>>2]=1;return}}function cj(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0;f=b[a>>1]|0;g=c[1727]|0;c[a+4+(d<<2)>>2]=e;of[c[g+(f*140|0)+48>>2]&511](a,a);return}function dj(a,d){a=a|0;d=d|0;var e=0;e=c[1727]|0;Kf[c[e+((b[a>>1]<<16>>16)*140|0)+52>>2]&1023](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[e+(d*140|0)+6>>1]|0;c[a+8>>2]=1;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;of[c[e+(d*140|0)+48>>2]&511](a,0);return}function ej(a,d){a=a|0;d=d|0;var f=0,g=0;g=c[1727]|0;Kf[c[g+((b[a>>1]<<16>>16)*140|0)+52>>2]&1023](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;f=a+36|0;b[f>>1]=b[g+(d*140|0)+6>>1]|0;c[a+8>>2]=1;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;of[c[g+(d*140|0)+48>>2]&511](a,0);b[f>>1]=e[f>>1]|0|256;return}function fj(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;e=b[a>>1]|0;f=c[1727]|0;if((e|0)==(d|0)){d=rf[c[f+(d*140|0)+28>>2]&255](a)|0;return d|0}g=rf[c[f+(e*140|0)+28>>2]&255](a)|0;a=b[a>>1]|0;e=a<<16>>16;f=c[1727]|0;if(a<<16>>16>7){d=dg[c[f+(e*140|0)+24>>2]&127](g,d)|0;return d|0}else{d=dg[c[f+(d*140|0)+20>>2]&127](g,e)|0;return d|0}return 0}function gj(a){a=a|0;var d=0,e=0,f=0,g=0;e=c[1728]|0;if((e|0)<=0){a=0;return a|0}f=c[1727]|0;g=0;while(1){d=f+(g*140|0)|0;if((b[d>>1]|0)!=0?(B8(c[f+(g*140|0)+12>>2]|0,a)|0)==0:0){e=6;break}g=g+1|0;if((g|0)>=(e|0)){d=0;e=6;break}}if((e|0)==6)return d|0;return 0}function hj(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;f=a+38|0;e=b[f>>1]|0;if(e<<16>>16>4){a=rd(4)|0;c[a>>2]=7;Te(a|0,8,0)}if(!(e<<16>>16)){c[a+44>>2]=1;g=1}else{h=a+44|0;g=$(c[h>>2]|0,c[a+4+(e<<16>>16<<2)>>2]|0)|0;c[h>>2]=g}e=e+1<<16>>16;b[f>>1]=e;if((d|0)<0){h=rd(4)|0;c[h>>2]=7;Te(h|0,8,0)}if((c[a+4+(e<<16>>16<<2)>>2]|0)>(d|0)){d=$(g,d)|0;h=a+40|0;c[h>>2]=(c[h>>2]|0)+d;return}else{h=rd(4)|0;c[h>>2]=7;Te(h|0,8,0)}}function ij(){var a=0;a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}function jj(a){a=a|0;c[1730]=a+2;c[a+72>>2]=112;c[a+20>>2]=46;c[a+28>>2]=119;c[a+56>>2]=120;c[a+64>>2]=35;c[a+68>>2]=113;c[a+48>>2]=94;c[a+52>>2]=418;c[a+76>>2]=95;c[a+80>>2]=96;c[a+84>>2]=97;c[a+88>>2]=98;c[a+92>>2]=99;c[a+108>>2]=100;c[a+112>>2]=101;c[a+116>>2]=102;c[a+120>>2]=103;c[a+124>>2]=104;c[a+128>>2]=105;c[a+12>>2]=31714;b[a+4>>1]=1;b[a+6>>1]=9;b[a+8>>1]=8;return}function kj(b,c,e){b=b|0;c=c|0;e=e|0;var f=0;f=e;f=d[f>>0]|d[f+1>>0]<<8|d[f+2>>0]<<16|d[f+3>>0]<<24;e=e+4|0;e=d[e>>0]|d[e+1>>0]<<8|d[e+2>>0]<<16|d[e+3>>0]<<24;b=c;c=b;a[c>>0]=f;a[c+1>>0]=f>>8;a[c+2>>0]=f>>16;a[c+3>>0]=f>>24;b=b+4|0;a[b>>0]=e;a[b+1>>0]=e>>8;a[b+2>>0]=e>>16;a[b+3>>0]=e>>24;return}function lj(a,b){a=a|0;b=b|0;switch(b|0){case 2:{h[12]=+q8(a);b=96;return b|0}case 4:{h[12]=+(c[a>>2]|0);b=96;return b|0}case 3:{b=a;return b|0}default:{b=rd(4)|0;c[b>>2]=6;Te(b|0,8,0)}}return 0}function mj(a){a=a|0;return (c[a+28>>2]|0)+(c[a+40>>2]<<3)|0}function nj(a){a=a|0;return 8}function oj(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function pj(a,b,c){a=a|0;b=b|0;c=c|0;return}function qj(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=a+8|0;f=c[e>>2]|0;if((f|0)<1){c[e>>2]=1;f=1}g=c[a+12>>2]|0;h=c[a+16>>2]|0;e=c[a+20>>2]|0;i=$($($(f<<3,(g|0)==0?1:g)|0,(h|0)==0?1:h)|0,(e|0)==0?1:e)|0;b[a+2>>1]=1;j=Ll(i)|0;if(i){g=$(f,g>>>0>1?g:1)|0;h=$(g,h>>>0>1?h:1)|0;M9(j|0,0,($(h,e>>>0>1?e:1)|0)<<3|0)|0}e=a+28|0;if(!d){d=a+24|0;c[e>>2]=j;c[d>>2]=i;return}else{d=a+24|0;K9(j|0,c[e>>2]|0,c[d>>2]|0)|0;Nl(c[e>>2]|0);c[e>>2]=j;c[d>>2]=i;return}}function rj(a){a=a|0;var d=0;d=a+2|0;a=a+28|0;if((b[d>>1]|0)==1)Nl(c[a>>2]|0);c[a>>2]=0;b[d>>1]=-1;return}function sj(a,d){a=a|0;d=d|0;h[a>>3]=+h[d>>3]+ +h[a>>3];b[c[1730]>>1]=3;return}function tj(a,d){a=a|0;d=d|0;h[a>>3]=+h[a>>3]-+h[d>>3];b[c[1730]>>1]=3;return}function uj(a,d){a=a|0;d=d|0;h[a>>3]=+h[d>>3]*+h[a>>3];b[c[1730]>>1]=3;return}function vj(a,d){a=a|0;d=d|0;var e=0.0;e=+h[d>>3];if(e==0.0){a=rd(4)|0;c[a>>2]=19;Te(a|0,8,0)}else{h[a>>3]=+h[a>>3]/e;b[c[1730]>>1]=3;return}}function wj(a,d){a=a|0;d=d|0;var e=0.0;e=+h[d>>3];if(e==0.0){a=rd(4)|0;c[a>>2]=19;Te(a|0,8,0)}else{h[a>>3]=+i7(+h[a>>3],e);b[c[1730]>>1]=3;return}}function xj(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]==+h[d>>3]&1;b[c[1730]>>1]=4;return}function yj(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]!=+h[d>>3]&1;b[c[1730]>>1]=4;return}function zj(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]>+h[d>>3]&1;b[c[1730]>>1]=4;return}function Aj(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]<+h[d>>3]&1;b[c[1730]>>1]=4;return}function Bj(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]>=+h[d>>3]&1;b[c[1730]>>1]=4;return}function Cj(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]<=+h[d>>3]&1;b[c[1730]>>1]=4;return}function Dj(a){a=a|0;c[a+72>>2]=114;c[a+20>>2]=47;c[a+28>>2]=121;c[a+56>>2]=122;c[a+64>>2]=36;c[a+68>>2]=115;c[a+48>>2]=106;c[a+52>>2]=419;c[a+76>>2]=107;c[a+80>>2]=108;c[a+84>>2]=109;c[a+88>>2]=110;c[a+92>>2]=111;c[a+96>>2]=112;c[a+100>>2]=113;c[a+104>>2]=114;c[a+108>>2]=115;c[a+112>>2]=116;c[a+116>>2]=117;c[a+120>>2]=118;c[a+124>>2]=119;c[a+128>>2]=120;c[a+132>>2]=121;c[a+136>>2]=122;c[a+12>>2]=31721;b[a+4>>1]=1;b[a+6>>1]=9;b[a+8>>1]=4;return}function Ej(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[d>>2];return}function Fj(b,d){b=b|0;d=d|0;switch(d|0){case 2:{if((a[b>>0]|0)==36)b=Ip(b)|0;else b=r8(b)|0;c[1731]=b;d=6924;return d|0}case 3:{c[1731]=~~+h[b>>3];d=6924;return d|0}case 4:{d=b;return d|0}default:{d=rd(4)|0;c[d>>2]=6;Te(d|0,8,0)}}return 0}function Gj(a){a=a|0;return (c[a+28>>2]|0)+(c[a+40>>2]<<2)|0}function Hj(a){a=a|0;return 4}function Ij(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function Jj(a,b,c){a=a|0;b=b|0;c=c|0;return}function Kj(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=a+8|0;f=c[e>>2]|0;if((f|0)<1){c[e>>2]=1;f=1}g=c[a+12>>2]|0;h=c[a+16>>2]|0;e=c[a+20>>2]|0;i=$($($(f<<2,(g|0)==0?1:g)|0,(h|0)==0?1:h)|0,(e|0)==0?1:e)|0;b[a+2>>1]=1;j=Ll(i)|0;if(i){g=$(f,g>>>0>1?g:1)|0;h=$(g,h>>>0>1?h:1)|0;M9(j|0,0,($(h,e>>>0>1?e:1)|0)<<2|0)|0}e=a+28|0;if(!d){d=a+24|0;c[e>>2]=j;c[d>>2]=i;return}else{d=a+24|0;K9(j|0,c[e>>2]|0,c[d>>2]|0)|0;Nl(c[e>>2]|0);c[e>>2]=j;c[d>>2]=i;return}}function Lj(a){a=a|0;var d=0;d=a+2|0;a=a+28|0;if((b[d>>1]|0)==1)Nl(c[a>>2]|0);c[a>>2]=0;b[d>>1]=-1;return}function Mj(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)+(c[b>>2]|0);return}function Nj(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)-(c[b>>2]|0);return}function Oj(a,b){a=a|0;b=b|0;c[a>>2]=$(c[a>>2]|0,c[b>>2]|0)|0;return}function Pj(a,b){a=a|0;b=b|0;b=c[b>>2]|0;if(!b){a=rd(4)|0;c[a>>2]=19;Te(a|0,8,0)}else{c[a>>2]=(c[a>>2]|0)/(b|0)|0;return}}function Qj(a,b){a=a|0;b=b|0;b=c[b>>2]|0;if(!b){a=rd(4)|0;c[a>>2]=19;Te(a|0,8,0)}else{c[a>>2]=(c[a>>2]|0)%(b|0)|0;return}}function Rj(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]&c[b>>2];return}function Sj(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]|c[b>>2];return}function Tj(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]^c[b>>2];return}function Uj(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)==(c[b>>2]|0)&1;return}function Vj(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)!=(c[b>>2]|0)&1;return}function Wj(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)>(c[b>>2]|0)&1;return}function Xj(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)<(c[b>>2]|0)&1;return}function Yj(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)>=(c[b>>2]|0)&1;return}function Zj(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)<=(c[b>>2]|0)&1;return}function _j(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]>>c[b>>2];return}function $j(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]<<c[b>>2];return}function ak(a){a=a|0;c[a+72>>2]=116;c[a+28>>2]=123;c[a+56>>2]=124;c[a+60>>2]=125;c[a+64>>2]=37;c[a+68>>2]=117;c[a+48>>2]=123;c[a+52>>2]=420;c[a+12>>2]=56156;b[a+4>>1]=1;b[a+6>>1]=137;b[a+8>>1]=4;return}function bk(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[d>>2];return}function ck(a){a=a|0;return (c[a+28>>2]|0)+(c[a+40>>2]<<2)|0}function dk(a){a=a|0;return 4}function ek(a){a=a|0;return (c[a>>2]|0)!=0|0}function fk(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function gk(a,b,c){a=a|0;b=b|0;c=c|0;return}function hk(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=a+8|0;f=c[e>>2]|0;if((f|0)<1){c[e>>2]=1;f=1}g=c[a+12>>2]|0;h=c[a+16>>2]|0;e=c[a+20>>2]|0;i=$($($(f<<2,(g|0)==0?1:g)|0,(h|0)==0?1:h)|0,(e|0)==0?1:e)|0;b[a+2>>1]=1;j=Ll(i)|0;if(i){g=$(f,g>>>0>1?g:1)|0;h=$(g,h>>>0>1?h:1)|0;M9(j|0,0,($(h,e>>>0>1?e:1)|0)<<2|0)|0}e=a+28|0;if(!d){d=a+24|0;c[e>>2]=j;c[d>>2]=i;return}else{d=a+24|0;K9(j|0,c[e>>2]|0,c[d>>2]|0)|0;Nl(c[e>>2]|0);c[e>>2]=j;c[d>>2]=i;return}}function ik(a){a=a|0;var d=0;d=a+2|0;a=a+28|0;if((b[d>>1]|0)==1)Nl(c[a>>2]|0);c[a>>2]=0;b[d>>1]=-1;return}function jk(a){a=a|0;c[1732]=a;c[a+72>>2]=118;c[a+20>>2]=48;c[a+28>>2]=126;c[a+56>>2]=127;c[a+64>>2]=38;c[a+68>>2]=119;c[a+48>>2]=124;c[a+52>>2]=421;c[a+76>>2]=125;c[a+108>>2]=126;c[a+112>>2]=127;c[a+12>>2]=31725;b[a+4>>1]=1;b[a+6>>1]=10;b[a+8>>1]=-1;return}function kk(a,d,e){a=a|0;d=d|0;e=e|0;if((b[a+2>>1]|0)==2){I8(d,e,c[a+24>>2]|0)|0;return}else{Pl(Rl(d)|0,e);return}}function lk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=i;i=i+16|0;e=f+8|0;d=f;switch(b|0){case 4:{c[d>>2]=c[a>>2];W7(31729,49204,d)|0;e=31729;i=f;return e|0}case 3:{h[e>>3]=+h[a>>3];W7(31729,49269,e)|0;e=31729;i=f;return e|0}case 2:{e=a;i=f;return e|0}default:{f=rd(4)|0;c[f>>2]=6;Te(f|0,8,0)}}return 0}function mk(a){a=a|0;var b=0;b=c[a+40>>2]|0;if(!b){a=a+28|0;a=c[a>>2]|0;return a|0}else{a=(c[a+32>>2]|0)+(b<<2)|0;a=c[a>>2]|0;return a|0}return 0}function nk(a){a=a|0;return (F8(a)|0)+1|0}function ok(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;if((b[a+2>>1]|0)==2){f=d;d=a+24|0}else{f=d;d=(Kl(d)|0)+8|0}c[e>>2]=c[d>>2];return f|0}function pk(a,d,e){a=a|0;d=d|0;e=e|0;if((b[a+2>>1]|0)==2)return;a=Rl(d)|0;c[a>>2]=Ol(c[a>>2]|0,e)|0;return}function qk(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;n=p;e=a+8|0;f=c[e>>2]|0;if((f|0)<1){c[e>>2]=1;f=1}g=(d|0)==0;if(g){m=0;l=0}else{m=c[d+24>>2]|0;c[n>>2]=c[d+28>>2];m=m>>>2;l=c[d+32>>2]|0}d=c[a+12>>2]|0;j=c[a+16>>2]|0;k=c[a+20>>2]|0;e=$($($(f<<2,(d|0)==0?1:d)|0,(j|0)==0?1:j)|0,(k|0)==0?1:k)|0;c[a+24>>2]=e;b[a+2>>1]=1;h=b9(e,1)|0;o=a+32|0;c[o>>2]=h;if(!h){p=rd(4)|0;c[p>>2]=26;Te(p|0,8,0)}if(g){h=c[a+4>>2]|0;h=(h|0)<64?64:h;if(!e){i=p;return}g=a+28|0;f=$(f,d>>>0>1?d:1)|0;f=$(f,j>>>0>1?j:1)|0;f=($(f,k>>>0>1?k:1)|0)&1073741823;d=0;do{if(!d)e=g;else e=(c[o>>2]|0)+(d<<2)|0;n=Ml(h)|0;c[e>>2]=n;Sl(n,e);d=d+1|0}while((d|0)!=(f|0));i=p;return}if(e){h=a+28|0;d=$(f,d>>>0>1?d:1)|0;d=$(d,j>>>0>1?j:1)|0;d=($(d,k>>>0>1?k:1)|0)&1073741823;g=0;do{e=(g|0)==0;if(e)f=h;else f=(c[o>>2]|0)+(g<<2)|0;if((g|0)<(m|0)){e=c[(e?n:l+(g<<2)|0)>>2]|0;c[f>>2]=e}else{e=Ml(64)|0;c[f>>2]=e}Sl(e,f);g=g+1|0}while((g|0)!=(d|0))}a9(l);i=p;return}function rk(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0;i=a+2|0;if((b[i>>1]|0)!=1){b[i>>1]=-1;return}f=c[a+8>>2]|0;g=c[a+12>>2]|0;d=c[a+16>>2]|0;e=c[a+20>>2]|0;h=$($($(f<<2,(g|0)==0?1:g)|0,(d|0)==0?1:d)|0,(e|0)==0?1:e)|0;c[a+24>>2]=h;if(!h)a=a+32|0;else{h=a+28|0;a=a+32|0;f=$(f,g>>>0>1?g:1)|0;f=$(f,d>>>0>1?d:1)|0;e=($(f,e>>>0>1?e:1)|0)&1073741823;f=0;do{if(!f)d=h;else d=(c[a>>2]|0)+(f<<2)|0;Nl(c[d>>2]|0);f=f+1|0}while((f|0)!=(e|0))}a9(c[a>>2]|0);b[i>>1]=-1;return}function sk(a,d){a=a|0;d=d|0;Ql(Rl(a)|0,d);b[(c[1732]|0)+2>>1]=2;return}function tk(a,d){a=a|0;d=d|0;c[a>>2]=(B8(a,d)|0)==0&1;b[(c[1732]|0)+2>>1]=4;return}function uk(a,d){a=a|0;d=d|0;c[a>>2]=B8(a,d)|0;b[(c[1732]|0)+2>>1]=4;return}function vk(a){a=a|0;c[a+72>>2]=120;c[a+28>>2]=128;c[a+56>>2]=129;c[a+60>>2]=130;c[a+64>>2]=39;c[a+68>>2]=121;c[a+48>>2]=128;c[a+52>>2]=422;c[a+12>>2]=32129;b[a+4>>1]=1;b[a+6>>1]=137;b[a+8>>1]=16;return}function wk(a,d,e){a=a|0;d=d|0;e=e|0;b[e>>1]=2;if((b[d>>1]|0)==1)Nl(c[d+12>>2]|0);c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];return}function xk(a){a=a|0;return (c[a+28>>2]|0)+(c[a+40>>2]<<4)|0}function yk(a){a=a|0;return 16}function zk(a){a=a|0;return b[a>>1]|0}function Ak(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b+8>>2];return c[b+12>>2]|0}function Bk(a,b,c){a=a|0;b=b|0;c=c|0;return}function Ck(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;i=a+8|0;e=c[i>>2]|0;if((e|0)<1){c[i>>2]=1;e=1}b[a+2>>1]=1;g=e<<4;h=Ll(g)|0;if((c[i>>2]|0)>0){e=h;f=0;while(1){f=f+1|0;b[e>>1]=0;b[e+2>>1]=0;b[e+4>>1]=0;b[e+6>>1]=0;b[e+8>>1]=0;b[e+10>>1]=0;b[e+12>>1]=0;b[e+14>>1]=0;if((f|0)>=(c[i>>2]|0))break;else e=e+16|0}}e=a+28|0;if(!d){d=a+24|0;c[e>>2]=h;c[d>>2]=g;return}else{d=a+24|0;K9(h|0,c[e>>2]|0,c[d>>2]|0)|0;Nl(c[e>>2]|0);c[e>>2]=h;c[d>>2]=g;return}}function Dk(a){a=a|0;var d=0,e=0,f=0,g=0,h=0;g=a+2|0;if((b[g>>1]|0)!=1){b[g>>1]=-1;return}vh(a);h=a+28|0;f=a+8|0;a=c[f>>2]|0;if((a|0)>0){d=c[h>>2]|0;e=0;while(1){if((b[d>>1]|0)==1){Nl(c[d+12>>2]|0);a=c[f>>2]|0}e=e+1|0;if((e|0)>=(a|0))break;else d=d+16|0}}Nl(c[h>>2]|0);b[g>>1]=-1;return}function Ek(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=a+36|0;d=a+32|0;e=$8(68)|0;f=e;g=f+68|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[b>>2]=17;c[d>>2]=e;g=mo()|0;Hk(a,0,2,0,0,g,no()|0);c[1733]=a;g=a+44|0;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;return}function Fk(a){a=a|0;var b=0,d=0,e=0,f=0;e=a+36|0;b=c[e>>2]|0;f=a+32|0;if((b|0)>0)d=0;else{f=c[f>>2]|0;a9(f);return}while(1){a=c[(c[f>>2]|0)+(d<<2)>>2]|0;if(a){if((c[a>>2]|0)==1){o=0;Ja(423,a|0);b=o;o=0;if(b&1){b=7;break}o=0;Ja(424,a|0);b=o;o=0;if(b&1){b=7;break}}$5(a);b=c[e>>2]|0}d=d+1|0;if((d|0)>=(b|0)){b=9;break}}if((b|0)==7){f=zc()|0;$5(a);Kc(f|0)}else if((b|0)==9){f=c[f>>2]|0;a9(f);return}}function Gk(a){a=a|0;return 0}function Hk(d,e,f,g,h,i,j){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0;l=e+1|0;m=d+36|0;h=c[m>>2]|0;if((h|0)<=(e|0)){n=$8(l<<2)|0;do if((e|0)>-1){g=d+32|0;if(!h){M9(n|0,0,((l|0)>1?l<<2:4)|0)|0;break}else k=0;do{if((k|0)<(h|0))c[n+(k<<2)>>2]=c[(c[g>>2]|0)+(k<<2)>>2];else c[n+(k<<2)>>2]=0;k=k+1|0}while((k|0)<(l|0))}else g=d+32|0;while(0);h=c[g>>2]|0;if(h)a9(h);c[m>>2]=l;c[g>>2]=n}h=d+32|0;g=c[h>>2]|0;k=c[g+(e<<2)>>2]|0;if(k){if((c[k>>2]|0)==1){o=0;Ja(423,k|0);n=o;o=0;if(n&1){f=zc()|0;$5(k);Kc(f|0)}o=0;Ja(424,k|0);n=o;o=0;if(n&1){f=zc()|0;$5(k);Kc(f|0)}}$5(k);g=c[h>>2]|0}n=Z5(660)|0;c[g+(e<<2)>>2]=n;c[n+32>>2]=e;c[n+28>>2]=f;c[n+280>>2]=-1;c[n>>2]=1;c[n+168>>2]=0;c[n+164>>2]=0;c[n+4>>2]=i;c[n+8>>2]=j;c[n+152>>2]=i;Mk(n,0);c[n+188>>2]=-1;c[n+136>>2]=1;b[n+36>>1]=1;b[n+38>>1]=1;a[n+216>>0]=0;c[n+184>>2]=d;return}function Ik(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;j=e+1|0;k=d+36|0;h=c[k>>2]|0;if((h|0)<=(e|0)){l=$8(j<<2)|0;do if((e|0)>-1){g=d+32|0;if(!h){M9(l|0,0,((j|0)>1?j<<2:4)|0)|0;break}else i=0;do{if((i|0)<(h|0))c[l+(i<<2)>>2]=c[(c[g>>2]|0)+(i<<2)>>2];else c[l+(i<<2)>>2]=0;i=i+1|0}while((i|0)<(j|0))}else g=d+32|0;while(0);h=c[g>>2]|0;if(h)a9(h);c[k>>2]=j;c[g>>2]=l}g=d+32|0;h=c[g>>2]|0;i=c[h+(e<<2)>>2]|0;if(i){if((c[i>>2]|0)==1){o=0;Ja(423,i|0);l=o;o=0;if(l&1){d=zc()|0;$5(i);Kc(d|0)}o=0;Ja(424,i|0);l=o;o=0;if(l&1){d=zc()|0;$5(i);Kc(d|0)}}$5(i);h=c[g>>2]|0}g=Z5(660)|0;c[g>>2]=0;c[h+(e<<2)>>2]=g;c[g+32>>2]=e;c[g+28>>2]=1;c[g+280>>2]=-1;if((so(g,f)|0)<0){d=rd(4)|0;c[d>>2]=13;Te(d|0,8,0)}else{e=c[g+4>>2]|0;c[g>>2]=1;c[g+168>>2]=0;c[g+164>>2]=0;c[g+152>>2]=e;Mk(g,0);c[g+188>>2]=-1;c[g+136>>2]=1;b[g+36>>1]=1;b[g+38>>1]=1;e=g+216|0;a[e>>0]=0;I8(e,f,63)|0;c[g+184>>2]=d;return}}function Jk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=c[(c[a+32>>2]|0)+(b<<2)>>2]|0;if(!e){a=1;return a|0}if(!(c[e>>2]|0)){a=1;return a|0}switch(c[e+28>>2]|0){case 1:{Ik(a,b,d);a=0;return a|0}case 2:{a=0;return a|0}default:{a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}}return 0}function Kk(a,b){a=a|0;b=b|0;if((b|0)<0){a=rd(4)|0;c[a>>2]=3;Te(a|0,8,0)}if((c[a+36>>2]|0)<=(b|0)){a=rd(4)|0;c[a>>2]=3;Te(a|0,8,0)}b=c[(c[a+32>>2]|0)+(b<<2)>>2]|0;if(!b){a=rd(4)|0;c[a>>2]=3;Te(a|0,8,0)}if(!(c[b>>2]|0)){a=rd(4)|0;c[a>>2]=3;Te(a|0,8,0)}else return b|0;return 0}function Lk(a){a=a|0;var b=0,d=0,e=0;b=c[a+36>>2]|0;if((b|0)<=0){e=b;return e|0}a=c[a+32>>2]|0;e=0;while(1){d=c[a+(e<<2)>>2]|0;if(!d){b=e;a=6;break}if(!(c[d>>2]|0)){b=e;a=6;break}e=e+1|0;if((e|0)>=(b|0)){a=6;break}}if((a|0)==6)return b|0;return 0}function Mk(d,e){d=d|0;e=e|0;var f=0;e=d+568|0;f=e+63|0;do{a[e>>0]=0;e=e+1|0}while((e|0)<(f|0));c[d+632>>2]=18;c[d+636>>2]=0;jo(63688,18,0)|0;ql(d);b[d+284>>1]=0;b[d+286>>1]=0;c[d+288>>2]=0;c[d+68>>2]=0;c[d+72>>2]=0;c[d+104>>2]=-16777216;g[d+552>>2]=0.0;g[d+556>>2]=0.0;g[d+560>>2]=0.0;g[d+564>>2]=1.0;c[d+640>>2]=16777215;g[d+644>>2]=1.0;g[d+648>>2]=1.0;g[d+652>>2]=1.0;g[d+656>>2]=1.0;c[d+108>>2]=0;c[d+76>>2]=64;c[d+80>>2]=32;c[d+84>>2]=0;c[d+92>>2]=32;c[d+96>>2]=32;c[d+100>>2]=0;c[d+160>>2]=0;e=d+176|0;f=e;b[f>>1]=0;b[f+2>>1]=0>>>16;e=e+4|0;b[e>>1]=0;b[e+2>>1]=0>>>16;e=c[d+4>>2]|0;b[d+208>>1]=e;f=c[d+8>>2]|0;b[d+210>>1]=f;b[d+204>>1]=(e|0)/(e<<16>>16|0)|0;b[d+206>>1]=(f|0)/(f<<16>>16|0)|0;b[d+212>>1]=0;b[d+214>>1]=0;b[d+38>>1]=b[d+36>>1]|0;if(!(c[d+32>>2]|0))io(d);f=d+292|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[d+308>>2]=-2;c[d+312>>2]=0;c[d+316>>2]=0;c[d+320>>2]=0;c[d+324>>2]=-2;c[d+328>>2]=0;c[d+332>>2]=0;c[d+336>>2]=0;c[d+340>>2]=-2;c[d+344>>2]=0;c[d+348>>2]=0;c[d+352>>2]=0;c[d+356>>2]=-2;c[d+360>>2]=0;c[d+364>>2]=0;c[d+368>>2]=0;c[d+372>>2]=-2;c[d+376>>2]=0;c[d+380>>2]=0;c[d+384>>2]=0;c[d+388>>2]=-2;c[d+392>>2]=0;c[d+396>>2]=0;c[d+400>>2]=0;c[d+404>>2]=-2;c[d+408>>2]=0;c[d+412>>2]=0;c[d+416>>2]=0;c[d+420>>2]=-2;c[d+424>>2]=0;c[d+428>>2]=0;c[d+432>>2]=0;c[d+436>>2]=-2;c[d+440>>2]=0;c[d+444>>2]=0;c[d+448>>2]=0;c[d+452>>2]=-2;c[d+456>>2]=0;c[d+460>>2]=0;c[d+464>>2]=0;c[d+468>>2]=-2;c[d+472>>2]=0;c[d+476>>2]=0;c[d+480>>2]=0;c[d+484>>2]=-2;c[d+488>>2]=0;c[d+492>>2]=0;c[d+496>>2]=0;c[d+500>>2]=-2;c[d+504>>2]=0;c[d+508>>2]=0;c[d+512>>2]=0;c[d+516>>2]=-2;c[d+520>>2]=0;c[d+524>>2]=0;c[d+528>>2]=0;c[d+532>>2]=-2;c[d+536>>2]=0;c[d+540>>2]=0;c[d+544>>2]=0;c[d+548>>2]=-2;return}function Nk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;I8(a+568|0,b,63)|0;c[a+632>>2]=d;c[a+636>>2]=e;jo(b,d,e)|0;return}function Ok(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+104>>2]=b<<16|d<<8&65280|e&255|-16777216;g[a+552>>2]=+(b|0)*.003921568859368563;g[a+556>>2]=+(d|0)*.003921568859368563;g[a+560>>2]=+(e|0)*.003921568859368563;g[a+564>>2]=1.0;return}function Pk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+640>>2]=d<<8&65280|b<<16&16711680|e&255;g[a+644>>2]=+(b|0)*.003921568859368563;g[a+648>>2]=+(d|0)*.003921568859368563;g[a+652>>2]=+(e|0)*.003921568859368563;g[a+656>>2]=1.0;return}function Qk(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;if((d|0)<=0)d=c[a+4>>2]|0;b[a+208>>1]=d;h=c[a+8>>2]|0;e=(e|0)>0?e:h;b[a+210>>1]=e;b[a+204>>1]=(c[a+4>>2]|0)/(d<<16>>16|0)|0;b[a+206>>1]=(h|0)/(e<<16>>16|0)|0;b[a+212>>1]=f;b[a+214>>1]=g;return}function Rk(a,b){a=a|0;b=b|0;return}function Sk(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return}function Tk(a,b){a=a|0;b=b|0;var d=0;d=c[a+84>>2]|0;a=a+72|0;c[a>>2]=((d|0)>(b|0)?d:b)+(c[a>>2]|0);return}function Uk(a,b){a=a|0;b=b|0;c[a+104>>2]=b;g[a+552>>2]=+(b>>>16&255|0)*.003921568859368563;g[a+556>>2]=+(b>>>8&255|0)*.003921568859368563;g[a+560>>2]=+(b&255|0)*.003921568859368563;g[a+564>>2]=1.0;return}function Vk(a){a=a|0;var b=0,d=0,e=0,f=0;d=a+568|0;f=a+632|0;b=c[f>>2]|0;e=a+636|0;a=c[e>>2]|0;I8(d,d,63)|0;c[f>>2]=b;c[e>>2]=a;jo(d,b,a)|0;return}function Wk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;jo(b,c,d)|0;return}function Xk(a,d){a=a|0;d=d|0;var e=0;to(a,d)|0;d=b[a+158>>1]|0;e=c[a+84>>2]|0;a=a+72|0;c[a>>2]=((e|0)>(d|0)?e:d)+(c[a>>2]|0);return}function Yk(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;wo(a,+(b|0),+(c|0),+(d|0),+(e|0));return}function Zk(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0;e=+(b|0);d=+(c|0);uo(a,e,d);vo(e,d);uo(0,0.0,0.0);return}function _k(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=a+68|0;e=a+72|0;uo(a,+(c[f>>2]|0),+(c[e>>2]|0));vo(+(b|0),+(d|0));uo(0,0.0,0.0);c[f>>2]=b;c[e>>2]=d;return}function $k(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;xo(a,+(b|0),+(c|0),+(d|0),+(e|0),f);return}function al(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;h=f+d|0;j=g+e|0;if((h|0)<0){e=-1;return e|0}i=c[b+4>>2]|0;do if((h|0)>=(i|0))if((i|0)>(d|0)){i=i-d|0;break}else{e=-1;return e|0}else i=f;while(0);if((j|0)<0){e=-1;return e|0}h=c[b+8>>2]|0;do if((j|0)>=(h|0))if((h|0)>(e|0)){g=h-e|0;break}else{e=-1;return e|0}while(0);zo(a,d&65535,e&65535,i&65535,g&65535,b,+(i|0),+(g|0));e=0;return e|0}function bl(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0;j=h+f|0;l=i+g|0;if((j|0)<0){g=-1;return g|0}k=c[e+4>>2]|0;do if((j|0)>=(k|0))if((k|0)>(f|0)){k=k-f|0;break}else{g=-1;return g|0}else k=h;while(0);if((l|0)<0){g=-1;return g|0}j=c[e+8>>2]|0;do if((l|0)>=(j|0))if((j|0)>(g|0)){i=j-g|0;break}else{g=-1;return g|0}while(0);zo(a,f&65535,g&65535,k&65535,i&65535,e,+(b|0),+(d|0));g=0;return g|0}function cl(a,b){a=a|0;b=b|0;return 0}function dl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0;e=e&255;d=d&255;i=(b|0)%192|0;h=(i|0)%32|0;f=((($(8160-(d<<5)|0,e)|0)+4080|0)>>>0)/8160|0;b=(($(8160-($(h,d)|0)|0,e)|0)+4080|0)/8160|0;d=(($(8160-($(32-h|0,d)|0)|0,e)|0)+4080|0)/8160|0;switch((i|0)/32|0|0){case 5:{h=b;i=f;break}case 4:{h=e;i=f;e=d;break}case 1:{h=f;i=e;e=b;break}case 2:{h=d;i=e;e=f;break}case 3:{h=e;i=b;e=f;break}default:{h=f;i=d}}c[a+104>>2]=h&255|i<<8&65280|e<<16|-16777216;g[a+552>>2]=+(e|0)*.003921568859368563;g[a+556>>2]=+(i|0)*.003921568859368563;g[a+560>>2]=+(h|0)*.003921568859368563;g[a+564>>2]=1.0;return}function el(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0;k=i;i=i+48|0;n=k+32|0;m=k+16|0;l=k;c[n>>2]=b;c[m>>2]=d;e=e+b|0;c[n+4>>2]=e;c[m+4>>2]=d;c[n+8>>2]=e;d=f+d|0;c[m+8>>2]=d;c[n+12>>2]=b;c[m+12>>2]=d;g=(g|0)==0;c[l+12>>2]=g?h:j;c[l>>2]=h;c[l+8>>2]=j;c[l+4>>2]=g?j:h;Eo(a,n,m,l);i=k;return}function fl(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;k=i;i=i+16|0;j=k;if((h|0)>=0){Do(a,b,d,e,f,g);i=k;return}if((h|0)==-257){Eo(a,b,d,f);i=k;return}else{g=c[a+104>>2]|0;c[j+12>>2]=g;c[j+8>>2]=g;c[j+4>>2]=g;c[j>>2]=g;Eo(a,b,d,j);i=k;return}}function gl(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;yo(a,+(b|0),+(c|0),+(d|0),+(e|0),f);return}function hl(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;Bo(a,f&65535,g&65535,h&65535,i&65535,+(b>>1|0),+(c>>1|0),e,+(b|0),+(c|0),d);return}function il(a,d,e,f,g,h){a=a|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0;j=b[d+208>>1]|0;m=b[d+210>>1]|0;l=b[d+204>>1]|0;n=$((e|0)%(l|0)|0,j)|0;l=$((e|0)/(l|0)|0,m)|0;e=n+j|0;k=l+m|0;if((e|0)<0){a=-1;return a|0}i=c[d+4>>2]|0;do if((e|0)>=(i|0))if((i|0)>(n|0)){i=i-n|0;break}else{a=-1;return a|0}else i=j;while(0);if((k|0)<0){a=-1;return a|0}e=c[d+8>>2]|0;do if((k|0)>=(e|0))if((e|0)>(l|0)){e=e-l|0;break}else{a=-1;return a|0}else e=m;while(0);p=+(i|0)*f;j=a+68|0;o=(c[j>>2]|0)+~~p|0;m=a+72|0;k=c[m>>2]|0;Bo(a,n&65535,l&65535,i&65535,e&65535,+(b[d+212>>1]|0)*f,+(b[d+214>>1]|0)*g,d,p,+(e|0)*g,h);c[j>>2]=o;c[m>>2]=k;a=0;return a|0}function jl(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;g=b[d+208>>1]|0;j=b[d+210>>1]|0;i=b[d+204>>1]|0;k=$((e|0)%(i|0)|0,g)|0;i=$((e|0)/(i|0)|0,j)|0;e=k+g|0;h=i+j|0;if((e|0)<0){a=-1;return a|0}f=c[d+4>>2]|0;do if((e|0)>=(f|0))if((f|0)>(k|0)){f=f-k|0;break}else{a=-1;return a|0}else f=g;while(0);if((h|0)<0){a=-1;return a|0}e=c[d+8>>2]|0;do if((h|0)>=(e|0))if((e|0)>(i|0)){e=e-i|0;break}else{a=-1;return a|0}else e=j;while(0);g=a+68|0;l=c[g>>2]|0;j=a+72|0;h=c[j>>2]|0;c[g>>2]=l-(b[d+212>>1]|0);c[j>>2]=h-(b[d+214>>1]|0);zo(a,k&65535,i&65535,f&65535,e&65535,d,+(f|0),+(e|0));c[g>>2]=l+f;c[j>>2]=h;a=0;return a|0}function kl(a,b){a=a|0;b=b|0;return}function ll(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=ml(a,b)|0;if(!g){g=a+296|0;if(c[g>>2]|0){g=a+312|0;if(c[g>>2]|0){g=a+328|0;if(c[g>>2]|0){g=a+344|0;if(c[g>>2]|0){g=a+360|0;if(c[g>>2]|0){g=a+376|0;if(c[g>>2]|0){g=a+392|0;if(c[g>>2]|0){g=a+408|0;if(c[g>>2]|0){g=a+424|0;if(c[g>>2]|0){g=a+440|0;if(c[g>>2]|0){g=a+456|0;if(c[g>>2]|0){g=a+472|0;if(c[g>>2]|0){g=a+488|0;if(c[g>>2]|0){g=a+504|0;if(c[g>>2]|0){g=a+520|0;if(c[g>>2]|0){g=a+536|0;if(c[g>>2]|0)return}}}}}}}}}}}}}}}c[g+12>>2]=b}if(f){c[g>>2]=1;c[g+4>>2]=d;c[g+8>>2]=e;return}else{c[g>>2]=0;return}}function ml(a,b){a=a|0;b=b|0;var d=0;d=a+296|0;if((c[d>>2]|0)!=0?(c[a+308>>2]|0)==(b|0):0){a=d;return a|0}d=a+312|0;if((c[d>>2]|0)!=0?(c[a+324>>2]|0)==(b|0):0){a=d;return a|0}d=a+328|0;if((c[d>>2]|0)!=0?(c[a+340>>2]|0)==(b|0):0){a=d;return a|0}d=a+344|0;if((c[d>>2]|0)!=0?(c[a+356>>2]|0)==(b|0):0){a=d;return a|0}d=a+360|0;if((c[d>>2]|0)!=0?(c[a+372>>2]|0)==(b|0):0){a=d;return a|0}d=a+376|0;if((c[d>>2]|0)!=0?(c[a+388>>2]|0)==(b|0):0){a=d;return a|0}d=a+392|0;if((c[d>>2]|0)!=0?(c[a+404>>2]|0)==(b|0):0){a=d;return a|0}d=a+408|0;if((c[d>>2]|0)!=0?(c[a+420>>2]|0)==(b|0):0){a=d;return a|0}d=a+424|0;if((c[d>>2]|0)!=0?(c[a+436>>2]|0)==(b|0):0){a=d;return a|0}d=a+440|0;if((c[d>>2]|0)!=0?(c[a+452>>2]|0)==(b|0):0){a=d;return a|0}d=a+456|0;if((c[d>>2]|0)!=0?(c[a+468>>2]|0)==(b|0):0){a=d;return a|0}d=a+472|0;if((c[d>>2]|0)!=0?(c[a+484>>2]|0)==(b|0):0){a=d;return a|0}d=a+488|0;if((c[d>>2]|0)!=0?(c[a+500>>2]|0)==(b|0):0){a=d;return a|0}d=a+504|0;if((c[d>>2]|0)!=0?(c[a+516>>2]|0)==(b|0):0){a=d;return a|0}d=a+520|0;if((c[d>>2]|0)!=0?(c[a+532>>2]|0)==(b|0):0){a=d;return a|0}d=a+536|0;if((c[d>>2]|0)!=0?(c[a+548>>2]|0)==(b|0):0){a=d;return a|0}a=0;return a|0}function nl(a,b){a=a|0;b=b|0;return (b>>>0>15?0:a+296+(b<<4)|0)|0}function ol(a,b){a=a|0;b=b|0;var d=0,e=0;e=a+292|0;c[e>>2]=0;if(!(c[a+296>>2]|0))d=0;else{c[b>>2]=0;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+312>>2]|0){c[b>>2]=1;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+328>>2]|0){c[b>>2]=2;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+344>>2]|0){c[b>>2]=3;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+360>>2]|0){c[b>>2]=4;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+376>>2]|0){c[b>>2]=5;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+392>>2]|0){c[b>>2]=6;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+408>>2]|0){c[b>>2]=7;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+424>>2]|0){c[b>>2]=8;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+440>>2]|0){c[b>>2]=9;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+456>>2]|0){c[b>>2]=10;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+472>>2]|0){c[b>>2]=11;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+488>>2]|0){c[b>>2]=12;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+504>>2]|0){c[b>>2]=13;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(c[a+520>>2]|0){c[b>>2]=14;d=(c[e>>2]|0)+1|0;c[e>>2]=d;b=b+4|0}if(!(c[a+536>>2]|0)){a=d;return a|0}c[b>>2]=15;a=(c[e>>2]|0)+1|0;c[e>>2]=a;return a|0}function pl(a){a=a|0;c[1734]=a;return}function ql(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0;i=a+164|0;d=c[i>>2]|0;h=a+168|0;if(!d){c[i>>2]=0;c[h>>2]=0;a=a+172|0;c[a>>2]=128;return}e=c[h>>2]|0;if((e|0)>0){d=e;g=0;do{e=c[i>>2]|0;f=e+(g*52|0)|0;if(b[f>>1]|0){d=c[e+(g*52|0)+48>>2]|0;if(d)Kf[d&1023](f);d=e+(g*52|0)+32|0;e=c[d>>2]|0;if(e){Nl(e);c[d>>2]=0}b[f>>1]=0;d=c[h>>2]|0}g=g+1|0}while((g|0)<(d|0));d=c[i>>2]|0}Nl(d);c[i>>2]=0;c[h>>2]=0;a=a+172|0;c[a>>2]=128;return}function rl(a,d){a=a|0;d=d|0;var e=0,f=0;if((d|0)<0){f=rd(4)|0;c[f>>2]=3;Te(f|0,8,0)}if((c[a+168>>2]|0)<=(d|0)){f=rd(4)|0;c[f>>2]=3;Te(f|0,8,0)}e=c[a+164>>2]|0;f=e+(d*52|0)|0;if(!(b[f>>1]|0))return;a=c[e+(d*52|0)+48>>2]|0;if(a)Kf[a&1023](f);a=e+(d*52|0)+32|0;e=c[a>>2]|0;if(e){Nl(e);c[a>>2]=0}b[f>>1]=0;return}function sl(a,d,e){a=a|0;d=d|0;e=e|0;if((d|0)>=0?(c[a+168>>2]|0)>(d|0):0){a=c[a+164>>2]|0;if(!(b[a+(d*52|0)>>1]|0)){e=rd(4)|0;c[e>>2]=3;Te(e|0,8,0)}else{b[a+(d*52|0)+2>>1]=e;return}}e=rd(4)|0;c[e>>2]=3;Te(e|0,8,0)}function tl(a,d,e){a=a|0;d=d|0;e=e|0;if((d|0)<0){e=rd(4)|0;c[e>>2]=3;Te(e|0,8,0)}if((c[a+168>>2]|0)<=(d|0)){e=rd(4)|0;c[e>>2]=3;Te(e|0,8,0)}d=(c[a+164>>2]|0)+(d*52|0)|0;if(!(b[d>>1]|0)){e=rd(4)|0;c[e>>2]=3;Te(e|0,8,0)}if((e|0)<1){e=rd(4)|0;c[e>>2]=3;Te(e|0,8,0)}else{b[d>>1]=e;return}}function ul(a){a=a|0;var d=0,e=0,f=0,g=0,h=0;e=a+164|0;f=c[e>>2]|0;if(!f){c[e>>2]=Ll(52)|0;a=a+168|0;c[a>>2]=(c[a>>2]|0)+1;a=0;return a|0}g=a+168|0;h=c[g>>2]|0;a:do if((h|0)>0){d=0;while(1){if(!(b[f+(d*52|0)>>1]|0))break;d=d+1|0;if((d|0)>=(h|0))break a}return d|0}while(0);if((h|0)>=(c[a+172>>2]|0)){a=rd(4)|0;c[a>>2]=33;Te(a|0,8,0)}a=h+1|0;c[g>>2]=a;c[e>>2]=Ol(f,a*52|0)|0;a=h;return a|0}function vl(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=ul(a)|0;i=c[a+164>>2]|0;c[i+(g*52|0)+8>>2]=0;b[i+(g*52|0)>>1]=1;b[i+(g*52|0)+2>>1]=1;c[i+(g*52|0)+4>>2]=a;k=i+(g*52|0)+32|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;b[i+(g*52|0)+20>>1]=c[a+68>>2];b[i+(g*52|0)+22>>1]=c[a+72>>2];b[i+(g*52|0)+24>>1]=c[a+76>>2];h=a+80|0;b[i+(g*52|0)+26>>1]=c[h>>2];b[i+(g*52|0)+28>>1]=0;b[i+(g*52|0)+30>>1]=-1;c[i+(g*52|0)+12>>2]=-1;c[i+(g*52|0)+16>>2]=g;j=Ll(88)|0;c[k>>2]=j;I8(j,d,63)|0;b[j+80>>1]=e;c[j+84>>2]=f;b[j+64>>1]=-1;b[j+66>>1]=-1;c[i+(g*52|0)+36>>2]=425;c[i+(g*52|0)+40>>2]=129;Tk(a,c[h>>2]|0);return g|0}function wl(a,d,e,f,g,h,i,j,k){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;if((d|0)<0){k=rd(4)|0;c[k>>2]=3;Te(k|0,8,0)}if((c[a+168>>2]|0)<=(d|0)){k=rd(4)|0;c[k>>2]=3;Te(k|0,8,0)}a=c[a+164>>2]|0;if((c[a+(d*52|0)+40>>2]|0)!=129){k=rd(4)|0;c[k>>2]=21;Te(k|0,8,0)}b[a+(d*52|0)+30>>1]=e;a=c[a+(d*52|0)+32>>2]|0;if(!a)return;b[a+68>>1]=f;b[a+70>>1]=g;b[a+72>>1]=h;b[a+74>>1]=i;b[a+76>>1]=j;b[a+78>>1]=k;return}function xl(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0;e=c[a+164>>2]|0;if(!e)return -1;h=c[a+640>>2]|0;Pk(a,255,255,255);i=a+168|0;d=c[i>>2]|0;if((d|0)>0){f=0;while(1){if((b[e>>1]|0)!=0?(g=c[e+36>>2]|0,(g|0)!=0):0){Kf[g&1023](e);d=c[i>>2]|0}f=f+1|0;if((f|0)>=(d|0))break;else e=e+52|0}}Pk(a,h>>>16&255,h>>>8&255,h&255);return -1}function yl(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;f=c[a+164>>2]|0;if(!f)return -1;j=b[a+176>>1]|0;m=b[a+178>>1]|0;n=a+286|0;if(b[n>>1]|0){if(b[a+284>>1]|0)return -1;b[n>>1]=0;return -1}o=a+288|0;e=c[o>>2]|0;if(e){n=m-(b[e+22>>1]|0)|0;if((((n|0)>-1?(n|0)<(b[e+26>>1]|0):0)?(d=j-(b[e+20>>1]|0)|0,(d|0)>-1):0)?(d|0)<(b[e+24>>1]|0):0)d=b[a+284>>1]|0;else d=-1;b[e+28>>1]=d;if(b[a+284>>1]|0)return -1;c[o>>2]=0;if((d|0)<=-1)return -1;of[c[e+40>>2]&511](e,d);return -1}h=c[a+168>>2]|0;i=a+284|0;if((h|0)>0){e=0;d=0;g=0;a=f;while(1){if((((((b[a>>1]|0)!=0?(c[a+40>>2]|0)!=0:0)?(k=m-(b[a+22>>1]|0)|0,(k|0)>-1):0)?(k|0)<(b[a+26>>1]|0):0)?(l=j-(b[a+20>>1]|0)|0,(l|0)>-1):0)?(l|0)<(b[a+24>>1]|0):0){e=a;d=b[i>>1]|0}g=g+1|0;if((g|0)>=(h|0))break;else a=a+52|0}}else{e=0;d=0}if((b[i>>1]|0)!=1)return -1;if(!e){b[n>>1]=1;return -1}else{b[n>>1]=0;c[o>>2]=e;b[e+28>>1]=d;return -1}return 0}function zl(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;r=c[a+4>>2]|0;Wk(r,63688,18,0);l=a+20|0;j=b[l>>1]|0;q=a+22|0;k=b[q>>1]|0;n=a+24|0;g=j+-1+(b[n>>1]|0)|0;o=a+26|0;h=k+-1+(b[o>>1]|0)|0;s=a+32|0;p=c[s>>2]|0;m=p+64|0;if((b[m>>1]|0)<0){c[r+100>>2]=3;c[r+144>>2]=0;c[r+68>>2]=j;c[r+72>>2]=k;Uk(r,0);Xk(r,c[s>>2]|0);b[m>>1]=b[r+156>>1]|0;b[p+66>>1]=b[r+158>>1]|0}f=a+30|0;if((b[f>>1]|0)<0){if(!(b[a+2>>1]|0)){e=-8355712;f=-10461088;d=-12566464}else{e=(b[a+28>>1]|0)==1?-7303024:-986896;f=-4144960;d=-16777216}i=r+100|0;c[i>>2]=0;u=r+144|0;c[u>>2]=255;el(r,j+1|0,k+1|0,(b[n>>1]|0)+-2|0,(b[o>>1]|0)+-2|0,1,e,f);Uk(r,-8355712);t=r+68|0;c[t>>2]=j;f=r+72|0;c[f>>2]=k;_k(r,g,k);_k(r,g,h);_k(r,j,h);_k(r,j,k);e=u;g=t;h=f;f=i}else{d=b[p+68>>1]|0;e=b[p+70>>1]|0;if(b[a+2>>1]|0)if((b[a+28>>1]|0)==1){d=b[p+72>>1]|0;e=b[p+74>>1]|0;i=-16777216}else i=-16777216;else i=-8355712;u=r+100|0;c[u>>2]=3;t=r+144|0;c[t>>2]=255;Uk(r,i);g=r+68|0;c[g>>2]=j;h=r+72|0;c[h>>2]=k;f=Kk(c[r+184>>2]|0,b[f>>1]|0)|0;al(r,f,d,e,b[n>>1]|0,b[o>>1]|0)|0;e=t;f=u;d=i}c[f>>2]=3;c[e>>2]=255;Uk(r,d);e=(((b[n>>1]|0)-(b[m>>1]|0)|0)/2|0)+(b[l>>1]|0)|0;c[g>>2]=e;d=(((b[o>>1]|0)-(b[p+66>>1]|0)|0)/2|0)+(b[q>>1]|0)|0;c[h>>2]=d;if((b[a+28>>1]|0)!=1){u=c[s>>2]|0;Xk(r,u);return}c[g>>2]=e+1;c[h>>2]=d+1;u=c[s>>2]|0;Xk(r,u);return}function Al(a,d){a=a|0;d=d|0;if(!(b[a+2>>1]|0))return;c[c[1734]>>2]=c[a+16>>2];d=c[a+32>>2]|0;a=c[d+84>>2]|0;if(!(b[d+80>>1]&1)){Eh(a);return}else{Fh(a);return}}function Bl(){var a=0,d=0;c[1735]=512;d=$8(40960)|0;c[1736]=d;c[1738]=d+40960;c[1737]=d;a=0;while(1){b[d>>1]=4;b[d+2>>1]=0;c[d+4>>2]=d+16;a=a+1|0;if((a|0)>=512)break;else d=d+80|0}return}function Cl(){var a=0,d=0,e=0,f=0;e=c[1737]|0;d=c[1736]|0;if((e|0)==(d|0)){f=d;a9(f);return}else a=d;do{f=e+-80|0;c[1737]=f;if(!(b[e+-78>>1]|0))e=f;else{a9(c[e+-76>>2]|0);a=c[1737]|0;b[a+2>>1]=0;c[a+4>>2]=a+16;a=c[1736]|0;d=a;e=c[1737]|0}}while((e|0)!=(d|0));a9(a);return}function Dl(){var a=0,d=0,e=0;d=c[1737]|0;a=c[1736]|0;if((d|0)==(a|0))return;do{e=d+-80|0;c[1737]=e;if(!(b[d+-78>>1]|0))d=e;else{a9(c[d+-76>>2]|0);a=c[1737]|0;b[a+2>>1]=0;c[a+4>>2]=a+16;a=c[1736]|0;d=c[1737]|0}}while((d|0)!=(a|0));return}function El(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0;h=c[1737]|0;if(h>>>0>=(c[1738]|0)>>>0){g=rd(4)|0;c[g>>2]=29;Te(g|0,8,0)}b[h>>1]=e;switch(e|0){case 4:case 1:{c[h+16>>2]=c[f>>2];c[1737]=h+80;return}case 3:{i=f;i=d[i>>0]|d[i+1>>0]<<8|d[i+2>>0]<<16|d[i+3>>0]<<24;f=f+4|0;f=d[f>>0]|d[f+1>>0]<<8|d[f+2>>0]<<16|d[f+3>>0]<<24;g=h+16|0;e=g;a[e>>0]=i;a[e+1>>0]=i>>8;a[e+2>>0]=i>>16;a[e+3>>0]=i>>24;g=g+4|0;a[g>>0]=f;a[g+1>>0]=f>>8;a[g+2>>0]=f>>16;a[g+3>>0]=f>>24;c[1737]=h+80;return}default:{if((g|0)<65)h=c[h+4>>2]|0;else{b[h+2>>1]=1;i=$8(g)|0;c[h+4>>2]=i;h=i}K9(h|0,f|0,g|0)|0;c[1737]=(c[1737]|0)+80;return}}}function Fl(e,f){e=e|0;f=f|0;var g=0,h=0,i=0;h=(F8(f)|0)+1|0;g=c[1737]|0;if(g>>>0>=(c[1738]|0)>>>0){f=rd(4)|0;c[f>>2]=29;Te(f|0,8,0)}b[g>>1]=e;switch(e|0){case 4:case 1:{c[g+16>>2]=c[f>>2];c[1737]=g+80;return}case 3:{h=f;i=h;i=d[i>>0]|d[i+1>>0]<<8|d[i+2>>0]<<16|d[i+3>>0]<<24;h=h+4|0;h=d[h>>0]|d[h+1>>0]<<8|d[h+2>>0]<<16|d[h+3>>0]<<24;f=g+16|0;e=f;a[e>>0]=i;a[e+1>>0]=i>>8;a[e+2>>0]=i>>16;a[e+3>>0]=i>>24;f=f+4|0;a[f>>0]=h;a[f+1>>0]=h>>8;a[f+2>>0]=h>>16;a[f+3>>0]=h>>24;c[1737]=g+80;return}default:{if((h|0)<65)g=c[g+4>>2]|0;else{b[g+2>>1]=1;i=$8(h)|0;c[g+4>>2]=i;g=i}K9(g|0,f|0,h|0)|0;c[1737]=(c[1737]|0)+80;return}}}function Gl(a,d){a=a|0;d=d|0;var e=0;e=c[1737]|0;if(e>>>0>=(c[1738]|0)>>>0){a=rd(4)|0;c[a>>2]=29;Te(a|0,8,0)}b[e>>1]=a;if((d|0)<65){a=e+4|0;d=e;d=d+80|0;c[1737]=d;a=c[a>>2]|0;return a|0}else{b[e+2>>1]=1;a=e+4|0;c[a>>2]=$8(d)|0;d=c[1737]|0;d=d+80|0;c[1737]=d;a=c[a>>2]|0;return a|0}return 0}function Hl(){var a=0;a9(c[(c[1737]|0)+4>>2]|0);a=c[1737]|0;b[a+2>>1]=0;c[a+4>>2]=a+16;return}function Il(){c[1739]=0;c[1740]=0;c[1741]=1024;Tl();return}function Jl(){var a=0,d=0,e=0,f=0;if((c[1739]|0)>0)e=0;else{f=c[1742]|0;a9(f);return}do{f=c[1742]|0;a=c[f+(e<<3)>>2]|0;f=c[f+(e<<3)+4>>2]|0;d=a+(f*88|0)|0;if((f|0)>0){f=a;do{if((b[f>>1]|0)==2)a9(c[f+16>>2]|0);f=f+88|0}while(f>>>0<d>>>0)}a9(a);e=e+1|0}while((e|0)<(c[1739]|0));f=c[1742]|0;a9(f);return}function Kl(a){a=a|0;return a+-24|0}function Ll(a){a=a|0;var d=0,e=0,f=0;e=(a|0)<64?64:a;a=c[1740]|0;if(!a){Tl();a=c[1740]|0}d=a+16|0;c[1740]=c[d>>2];if((e|0)<65){b[a>>1]=1;c[a+8>>2]=64;e=a+24|0;c[a+12>>2]=e;c[e>>2]=0;return e|0}else{b[a>>1]=2;c[a+8>>2]=e;f=$8(e+24|0)|0;e=f+24|0;c[d>>2]=f;c[a+12>>2]=e;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];c[f+16>>2]=c[a+16>>2];c[f+20>>2]=c[a+20>>2];c[e>>2]=0;return e|0}return 0}function Ml(a){a=a|0;var d=0,e=0,f=0,g=0;f=(a|0)<64?64:a;d=c[1740]|0;if(!d){Tl();d=c[1740]|0}e=d+16|0;c[1740]=c[e>>2];if((f|0)<65){b[d>>1]=1;c[d+8>>2]=64;f=d+24|0;c[d+12>>2]=f;c[f>>2]=0;M9(f|0,0,a|0)|0;return f|0}else{b[d>>1]=2;c[d+8>>2]=f;g=$8(f+24|0)|0;f=g+24|0;c[e>>2]=g;c[d+12>>2]=f;c[g>>2]=c[d>>2];c[g+4>>2]=c[d+4>>2];c[g+8>>2]=c[d+8>>2];c[g+12>>2]=c[d+12>>2];c[g+16>>2]=c[d+16>>2];c[g+20>>2]=c[d+20>>2];c[f>>2]=0;M9(f|0,0,a|0)|0;return f|0}return 0}function Nl(a){a=a|0;var d=0;d=c[a+-20>>2]|0;if((c[d+12>>2]|0)!=(a|0))return;a=d+16|0;if((b[d>>1]|0)==2)a9(c[a>>2]|0);c[a>>2]=c[1740];c[1740]=d;b[d>>1]=0;return}function Ol(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=c[a+-20>>2]|0;f=e+8|0;a=c[f>>2]|0;if((a|0)>=(d|0)){d=c[e+12>>2]|0;return d|0}g=$8(d+24|0)|0;h=g+24|0;i=e+12|0;K9(h|0,c[i>>2]|0,a|0)|0;a=e+16|0;if((b[e>>1]|0)==2)a9(c[a>>2]|0);c[f>>2]=d;b[e>>1]=2;c[i>>2]=h;c[a>>2]=g;c[g>>2]=c[e>>2];c[g+4>>2]=c[e+4>>2];c[g+8>>2]=c[e+8>>2];c[g+12>>2]=c[e+12>>2];c[g+16>>2]=c[e+16>>2];c[g+20>>2]=c[e+20>>2];d=h;return d|0}function Pl(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=F8(d)|0;l=f+1|0;e=c[a>>2]|0;if((c[e+-16>>2]|0)>=(l|0)){a=c[e+-12>>2]|0;K9(a|0,d|0,l|0)|0;return}j=c[e+-20>>2]|0;k=j+8|0;i=c[k>>2]|0;if((i|0)<(l|0)){g=$8(f+25|0)|0;e=g+24|0;h=j+12|0;K9(e|0,c[h>>2]|0,i|0)|0;f=j+16|0;if((b[j>>1]|0)==2)a9(c[f>>2]|0);c[k>>2]=l;b[j>>1]=2;c[h>>2]=e;c[f>>2]=g;c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];c[g+16>>2]=c[j+16>>2];c[g+20>>2]=c[j+20>>2]}else e=c[j+12>>2]|0;c[a>>2]=e;a=e;K9(a|0,d|0,l|0)|0;return}function Ql(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=(F8(d)|0)+1|0;g=c[a>>2]|0;e=c[g+-12>>2]|0;m=F8(e)|0;f=m+l|0;if((f|0)<=(c[g+-16>>2]|0)){a=e;a=a+m|0;K9(a|0,d|0,l|0)|0;return}k=f+4095&-4096;g=c[g+-20>>2]|0;h=g+8|0;f=c[h>>2]|0;if((f|0)<(k|0)){i=$8(k|24)|0;e=i+24|0;j=g+12|0;K9(e|0,c[j>>2]|0,f|0)|0;f=g+16|0;if((b[g>>1]|0)==2)a9(c[f>>2]|0);c[h>>2]=k;b[g>>1]=2;c[j>>2]=e;c[f>>2]=i;c[i>>2]=c[g>>2];c[i+4>>2]=c[g+4>>2];c[i+8>>2]=c[g+8>>2];c[i+12>>2]=c[g+12>>2];c[i+16>>2]=c[g+16>>2];c[i+20>>2]=c[g+20>>2]}else e=c[g+12>>2]|0;c[a>>2]=e;a=e;a=a+m|0;K9(a|0,d|0,l|0)|0;return}function Rl(a){a=a|0;return c[a+-4>>2]|0}function Sl(a,b){a=a|0;b=b|0;c[a+-4>>2]=b;c[(c[a+-20>>2]|0)+20>>2]=b;return}function Tl(){var a=0,d=0,e=0,f=0,g=0;a=c[1739]|0;if(!a)e=$8(8)|0;else e=c9(c[1742]|0,(a<<3)+8|0)|0;c[1742]=e;d=c[1741]|0;a=$8(d*88|0)|0;if(!a){f=rd(4)|0;c[f>>2]=26;Te(f|0,8,0)}f=a+(d*88|0)|0;g=c[1739]|0;c[e+(g<<3)>>2]=a;c[(c[1742]|0)+(g<<3)+4>>2]=d;c[1739]=(c[1739]|0)+1;c[1741]=~~(+(c[1741]|0)*1.8);if(a>>>0>=f>>>0)return;do{c[a+4>>2]=a;b[a>>1]=0;c[a+16>>2]=c[1740];c[1740]=a;a=a+88|0}while(a>>>0<f>>>0);return}function Ul(b){b=b|0;c[b>>2]=0;a[b+24>>0]=0;return}function Vl(a){a=a|0;return}function Wl(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Xl(a){a=a|0;return F8(c[a>>2]|0)|0}function Yl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;g=c[b>>2]|0;j=b+4|0;c[j>>2]=0;k=b+8|0;c[k>>2]=g;e=g;a:do if((d|0)<0){f=F8(g)|0;if(f){e=g+f|0;c[k>>2]=e;switch(a[g+(f+-1)>>0]|0){case 13:case 10:break;default:break a}c[j>>2]=1}}else{do if(d){e=g;f=0;b:while(1){g=e;c:while(1){h=a[g>>0]|0;if(!(h<<24>>24)){i=15;break b}e=g+1|0;c[k>>2]=e;switch(h<<24>>24){case 10:{i=9;break c}case 13:break c;default:g=e}}if((i|0)==9){i=0;f=f+1|0;if((f|0)==(d|0)){i=13;break}else continue}if((a[e>>0]|0)==10){e=g+2|0;c[k>>2]=e}f=f+1|0;if((f|0)==(d|0)){i=13;break}}if((i|0)==13)break;else if((i|0)==15){e=b+24|0;c[k>>2]=e;break a}}while(0);c[j>>2]=1}while(0);g=b+12|0;c[g>>2]=e;f=e;d:while(1){e=a[f>>0]|0;switch(e<<24>>24){case 10:case 13:case 0:break d;default:{}}j=f+1|0;c[g>>2]=j;f=j}a[b+16>>0]=e;a[f>>0]=0;return c[k>>2]|0}function Zl(b){b=b|0;a[c[b+12>>2]>>0]=a[b+16>>0]|0;return}function _l(b){b=b|0;var d=0,e=0,f=0,g=0;d=c[b>>2]|0;g=b+8|0;c[g>>2]=d;b=d;d=1;a:while(1){e=b;b=0;b:while(1){f=e+1|0;c[g>>2]=f;switch(a[e>>0]|0){case 0:break a;case 10:case 13:{b=f;break b}default:{}}e=f;b=b+1|0}if((a[b>>0]|0)==10){b=e+2|0;c[g>>2]=b}d=d+1|0}return (((b|0)==0)<<31>>31)+d|0}function $l(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=c[b>>2]|0;k=b+4|0;c[k>>2]=0;o=b+8|0;c[o>>2]=g;a:do if((e|0)<0){h=F8(g)|0;if(h){i=g+h|0;c[o>>2]=i;switch(a[g+(h+-1)>>0]|0){case 13:case 10:{c[k>>2]=1;g=i;break a}default:{}}if(h){g=g+(F8(g)|0)|0;a[g>>0]=10;a[g+1>>0]=0;g=(c[o>>2]|0)+2|0;c[o>>2]=g}}}else{b:do if(e){h=0;c:while(1){i=g;d:while(1){j=a[i>>0]|0;if(!(j<<24>>24)){g=1;break c}g=i+1|0;c[o>>2]=g;switch(j<<24>>24){case 10:{n=9;break d}case 13:break d;default:i=g}}if((n|0)==9){n=0;h=h+1|0;if((h|0)==(e|0))break b;else continue}if((a[g>>0]|0)==10){g=i+2|0;c[o>>2]=g}h=h+1|0;if((h|0)==(e|0))break b}return g|0}while(0);c[k>>2]=1}while(0);m=(d|0)==0;h=m?63688:d;if(!m){g=h+(F8(h)|0)|0;a[g>>0]=10;a[g+1>>0]=0;g=c[o>>2]|0}l=F8(h)|0;b=c[b>>2]|0;m=F8(b)|0;d=b+1+m-g|0;if(!f){k=0;e=l}else{i=0;j=g;e:while(1){k=j+1|0;j=a[j>>0]|0;if(!(j<<24>>24))break;e=i+1|0;switch(j<<24>>24){case 10:case 13:{j=k;n=21;break e}default:{i=e;j=k}}}if((n|0)==21)i=(a[j>>0]|0)==10?i+2|0:e;d=d-i|0;k=i;e=l-i|0;d=(d|0)<1?1:d}i=(d|0)>0;if((e|0)>-1){if(i){j=0;i=b+(e+m)|0;g=b+m|0;while(1){a[i>>0]=a[g>>0]|0;j=j+1|0;if((j|0)==(d|0))break;else{i=i+-1|0;g=g+-1|0}}}}else if(i){j=0;i=g+(e+k)|0;g=g+k|0;while(1){a[i>>0]=a[g>>0]|0;j=j+1|0;if((j|0)==(d|0))break;else{i=i+1|0;g=g+1|0}}}g=a[h>>0]|0;if(!(g<<24>>24)){o=0;return o|0}do{h=h+1|0;n=c[o>>2]|0;c[o>>2]=n+1;a[n>>0]=g;g=a[h>>0]|0}while(g<<24>>24!=0);g=0;return g|0}function am(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=c[b>>2]|0;j=b+8|0;c[j>>2]=h;k=b+20|0;c[k>>2]=h;i=b+16|0;b=h;a:do if(!e){f=b;b=0;while(1){g=f;h=0;b:while(1){switch(a[g>>0]|0){case 0:{g=b;b=h;h=38;break a}case 10:{f=g;g=h;h=9;break b}case 13:{f=h;h=3;break b}default:{}}l=g+1|0;c[j>>2]=l;g=l;h=h+1|0}if((h|0)==3){if(f){a[i>>0]=13;a[g>>0]=0;if(!(B8(c[k>>2]|0,d)|0)){h=32;break a}a[c[j>>2]>>0]=a[i>>0]|0;g=c[j>>2]|0}f=g+1|0;c[j>>2]=f;if((a[f>>0]|0)==10){f=g+2|0;c[j>>2]=f}c[k>>2]=f}else if((h|0)==9){if(g){a[i>>0]=10;a[f>>0]=0;if(!(B8(c[k>>2]|0,d)|0)){h=23;break a}a[c[j>>2]>>0]=a[i>>0]|0;f=c[j>>2]|0}f=f+1|0;c[j>>2]=f;c[k>>2]=f}b=b+1|0}}else{f=b;b=0;while(1){g=f;h=0;c:while(1){switch(a[g>>0]|0){case 0:{g=b;b=h;h=38;break a}case 10:{f=g;g=h;h=18;break c}case 13:{f=h;h=27;break c}default:{}}l=g+1|0;c[j>>2]=l;g=l;h=h+1|0}if((h|0)==18){if(g){a[i>>0]=10;a[f>>0]=0;switch(e|0){case 2:{if(wp(c[k>>2]|0,d)|0){h=23;break a}break}case 1:{l=wp(c[k>>2]|0,d)|0;if((l|0)!=0?(l|0)==(c[k>>2]|0):0){h=23;break a}break}default:{}}a[c[j>>2]>>0]=a[i>>0]|0;f=c[j>>2]|0}f=f+1|0;c[j>>2]=f;c[k>>2]=f}else if((h|0)==27){if(f){a[i>>0]=13;a[g>>0]=0;switch(e|0){case 2:{if(wp(c[k>>2]|0,d)|0){h=32;break a}break}case 1:{l=wp(c[k>>2]|0,d)|0;if((l|0)!=0?(l|0)==(c[k>>2]|0):0){h=32;break a}break}default:{}}a[c[j>>2]>>0]=a[i>>0]|0;g=c[j>>2]|0}f=g+1|0;c[j>>2]=f;if((a[f>>0]|0)==10){f=g+2|0;c[j>>2]=f}c[k>>2]=f}b=b+1|0}}while(0);if((h|0)==23){a[c[j>>2]>>0]=a[i>>0]|0;l=b;return l|0}else if((h|0)==32){a[c[j>>2]>>0]=a[i>>0]|0;l=b;return l|0}else if((h|0)==38){if(!b){l=-1;return l|0}switch(e|0){case 0:{if(B8(f,d)|0){l=-1;return l|0}break}case 1:{b=wp(f,d)|0;if(!b){l=-1;return l|0}if((b|0)!=(c[k>>2]|0)){l=-1;return l|0}break}case 2:{if(!(wp(f,d)|0)){l=-1;return l|0}break}default:{l=-1;return l|0}}l=g;return l|0}return 0}function bm(a,b){a=a|0;b=b|0;if(a>>>0>46)return;c[6972+(a<<2)>>2]=b;g[7160+(a<<2)>>2]=+(b|0);return}function cm(a){a=a|0;if((a|0)==34){a=Fo()|0;return a|0}else{a=c[6972+(a<<2)>>2]|0;return a|0}return 0}function dm(){M9(6972,0,184)|0;M9(7160,0,184)|0;c[1744]=128;c[1745]=1024;c[1746]=128;c[1747]=4096;c[1755]=1048576;c[1756]=256;c[1759]=16;c[1769]=16;c[1771]=1024;c[1761]=1;c[1772]=1;c[1762]=2;c[1781]=128;c[1789]=64;g[1836]=64.0;c[1778]=3;a[32136]=0;return}function em(a){a=a|0;var c=0,d=0,e=0,f=0;d=a+64|0;QH(d);e=a+76|0;o=0;Ja(426,e|0);c=o;o=0;if(!(c&1)){c=a+92|0;o=0;Ja(426,c|0);f=o;o=0;if(!(f&1)){c=a+108|0;o=0;Ja(426,c|0);f=o;o=0;if(!(f&1)){c=a+124|0;o=0;Ja(426,c|0);f=o;o=0;if(!(f&1)){b[a>>1]=0;return}}}}else c=e;a=zc()|0;a:do if((e|0)!=(c|0)){while(1){c=c+-16|0;o=0;Ja(413,c|0);f=o;o=0;if(f&1)break;if((c|0)==(e|0))break a}f=zc(0)|0;Di(f)}while(0);o=0;Ja(412,d|0);f=o;o=0;if(!(f&1))Kc(a|0);f=zc(0)|0;Di(f)}function fm(a){a=a|0;var b=0,c=0,d=0,e=0;d=a+76|0;b=a+124|0;o=0;Ja(413,b|0);c=o;o=0;if(!(c&1)){b=a+108|0;o=0;Ja(413,b|0);c=o;o=0;if(!(c&1)){b=a+92|0;o=0;Ja(413,b|0);c=o;o=0;if(!(c&1)){b=a+76|0;o=0;Ja(413,b|0);c=o;o=0;if(!(c&1)){WH(a+64|0);return}}}}c=zc()|0;a:do if((d|0)!=(b|0)){while(1){b=b+-16|0;o=0;Ja(413,b|0);e=o;o=0;if(e&1)break;if((b|0)==(d|0))break a}e=zc(0)|0;Di(e)}while(0);o=0;Ja(412,a+64|0);e=o;o=0;if(!(e&1))Kc(c|0);e=zc(0)|0;Di(e)}function gm(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,i=0,j=0;yu(a);c[a>>2]=7356;f=a+196|0;o=0;Ja(427,f|0);j=o;o=0;if(!(j&1)){i=a+212|0;o=0;Ja(411,i|0);j=o;o=0;if(!(j&1)){j=a+224|0;o=0;Ja(411,j|0);h=o;o=0;if(!(h&1)){o=0;Ja(428,a+236|0);h=o;o=0;if(!(h&1)){c[a+104>>2]=0;c[a+120>>2]=0;c[a+132>>2]=0;c[a+160>>2]=0;g[a+108>>2]=.003921568859368563;c[a+188>>2]=0;c[a+300>>2]=0;c[a+304>>2]=0;c[a+308>>2]=0;return}h=zc()|0;o=0;Ja(412,j|0);j=o;o=0;if(j&1){j=zc(0)|0;Di(j)}else b=h}else b=zc()|0;o=0;Ja(412,i|0);j=o;o=0;if(j&1){j=zc(0)|0;Di(j)}else d=b}else d=zc()|0;o=0;Ja(429,f|0);j=o;o=0;if(j&1){j=zc(0)|0;Di(j)}else e=d}else e=zc()|0;o=0;Ja(29,a|0);a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else Kc(e|0)}function hm(a){a=a|0;c[a+104>>2]=Tt(32657,0)|0;im(a,0);return}function im(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;m=i;i=i+32|0;q=m+16|0;p=m;if((b|0)==1){wF(c[a+188>>2]|0);i=m;return}km(a);Eu((cm(37)|0)!=0);b=cm(2)|0;e=a+120|0;c[e>>2]=b;f=b*144|0;f=_5(b>>>0>29826161|f>>>0>4294967291?-1:f+4|0)|0;c[f>>2]=b;g=f+4|0;do if(!b)c[a+132>>2]=g;else{d=g+(b*144|0)|0;b=g;while(1){o=0;Ja(430,b|0);s=o;o=0;if(s&1)break;b=b+144|0;if((b|0)==(d|0)){r=8;break}}if((r|0)==8){b=c[e>>2]|0;c[a+132>>2]=g;if((b|0)<1)break;c[a+124>>2]=0;c[a+128>>2]=b;break}d=zc()|0;e=D;a:do if((g|0)!=(b|0)){while(1){b=b+-144|0;o=0;Ja(434,b|0);s=o;o=0;if(s&1)break;if((b|0)==(g|0))break a}s=zc(0)|0;Di(s)}while(0);a6(f);s=d;Kc(s|0)}while(0);b=cm(38)|0;c[a+156>>2]=b;f=b*36|0;f=_5(b>>>0>119304647|f>>>0>4294967291?-1:f+4|0)|0;c[f>>2]=b;g=f+4|0;b:do if(b){d=g+(b*36|0)|0;b=g;while(1){o=0;Ja(431,b|0);s=o;o=0;if(s&1)break;b=b+36|0;if((b|0)==(d|0))break b}d=zc()|0;e=D;c:do if((g|0)!=(b|0)){while(1){b=b+-36|0;o=0;Ja(435,b|0);s=o;o=0;if(s&1)break;if((b|0)==(g|0))break c}s=zc(0)|0;Di(s)}while(0);a6(f);s=d;Kc(s|0)}while(0);c[a+160>>2]=g;b=a+188|0;c[b>>2]=yF(0)|0;c[a+164>>2]=0;d=a+32|0;e=a+36|0;s=Bn(a,-1,45.0,+((c[d>>2]|0)>>>0)/+((c[e>>2]|0)>>>0),.5,768.0)|0;c[a+180>>2]=s;Cn(a,s);IF(c[b>>2]|0,1.0,1.0,1.0);QH(p);o=0;za(1,p|0,-.5,0.0,-.30000001192092896);s=o;o=0;do if((((((((!(s&1)?(o=0,na(130,c[b>>2]|0,p|0),s=o,o=0,!(s&1)):0)?(o=0,za(2,c[b>>2]|0,.25,.25,.25),s=o,o=0,!(s&1)):0)?(o=0,j=lb(1,a|0,-1,0,1.0,.5,1.0)|0,s=o,o=0,!(s&1)):0)?(c[a+172>>2]=j,o=0,na(131,a|0,j|0),s=o,o=0,!(s&1)):0)?(o=0,za(1,a+212|0,-50.0,0.0,-50.0),s=o,o=0,!(s&1)):0)?(o=0,za(1,a+224|0,50.0,100.0,50.0),s=o,o=0,!(s&1)):0)?(o=0,qa(131,a|0)|0,s=o,o=0,!(s&1)):0)?(k=c[d>>2]|0,l=c[e>>2]|0,o=0,Ja(432,q|0),s=o,o=0,!(s&1)):0){o=0;Ua(1,q|0,0.0,0.0,+(+(k|0)),+(+(l|0)));s=o;o=0;if(!(s&1)?(o=0,na(132,a|0,q|0),s=o,o=0,!(s&1)):0){o=0;Ja(433,q|0);s=o;o=0;if(s&1){r=38;break}WH(p);i=m;return}b=zc()|0;o=0;Ja(433,q|0);s=o;o=0;if(s&1){s=zc(0)|0;Di(s)}else n=b}else r=38;while(0);if((r|0)==38)n=zc()|0;o=0;Ja(412,p|0);s=o;o=0;if(!(s&1)){s=n;Kc(s|0)}s=zc(0)|0;Di(s)}function jm(a){a=a|0;var b=0;km(a);a=a+104|0;b=c[a>>2]|0;if(!b)return;tE(b);c[a>>2]=0;return}function km(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0;i=a+188|0;b=c[i>>2]|0;if(b){wF(b);DF(c[i>>2]|0,0)}e=a+132|0;b=c[e>>2]|0;if(b){d=a+120|0;if((c[d>>2]|0)>0){b=0;do{lm(a,b)|0;b=b+1|0}while((b|0)<(c[d>>2]|0));b=c[e>>2]|0;if(b){g=b;h=7}}else{g=b;h=7}if((h|0)==7){f=g+-4|0;b=c[f>>2]|0;a:do if(b){b=g+(b*144|0)|0;while(1){b=b+-144|0;o=0;Ja(434,b|0);d=o;o=0;if(d&1)break;if((b|0)==(g|0))break a}d=zc()|0;e=D;b:do if((g|0)!=(b|0)){while(1){b=b+-144|0;o=0;Ja(434,b|0);i=o;o=0;if(i&1)break;if((b|0)==(g|0))break b}i=zc(0)|0;Di(i)}while(0);a6(f);i=d;Kc(i|0)}while(0);a6(f)}c[e>>2]=0}e=a+160|0;b=c[e>>2]|0;if(b){d=a+156|0;if((c[d>>2]|0)>0){b=0;do{Nn(a,b)|0;b=b+1|0}while((b|0)<(c[d>>2]|0));b=c[e>>2]|0;if(b){g=b;h=21}}else{g=b;h=21}if((h|0)==21){f=g+-4|0;b=c[f>>2]|0;c:do if(b){b=g+(b*36|0)|0;while(1){b=b+-36|0;o=0;Ja(435,b|0);h=o;o=0;if(h&1)break;if((b|0)==(g|0))break c}d=zc()|0;e=D;d:do if((g|0)!=(b|0)){while(1){b=b+-36|0;o=0;Ja(435,b|0);i=o;o=0;if(i&1)break;if((b|0)==(g|0))break d}i=zc(0)|0;Di(i)}while(0);a6(f);i=d;Kc(i|0)}while(0);a6(f)}c[e>>2]=0}b=a+300|0;d=c[b>>2]|0;do if(d){o=0;Ja(436,d|0);h=o;o=0;if(!(h&1)){$5(d);c[b>>2]=0;break}i=zc()|0;$5(d);Kc(i|0)}while(0);b=a+304|0;d=c[b>>2]|0;do if(d){o=0;Ja(436,d|0);h=o;o=0;if(!(h&1)){$5(d);c[b>>2]=0;break}i=zc()|0;$5(d);Kc(i|0)}while(0);b=a+308|0;d=c[b>>2]|0;if(d){tE(d);c[b>>2]=0}b=c[i>>2]|0;if(!b)return;tE(b);c[i>>2]=0;return}function lm(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if((d|0)<0){d=-1;return d|0}if((c[a+120>>2]|0)<=(d|0)){d=-1;return d|0}h=c[a+132>>2]|0;a=h+(d*144|0)|0;if((b[a>>1]|0)==0|(a|0)==0){d=-1;return d|0}b[a>>1]=0;a=h+(d*144|0)+40|0;e=c[a>>2]|0;a:do if(e){o=0;Ja(413,e+48|0);i=o;o=0;do if(i&1){a=zc()|0;o=0;Ja(413,e+32|0);i=o;o=0;if(i&1){i=zc(0)|0;Di(i)}else g=10}else{o=0;Ja(413,e+32|0);i=o;o=0;if(i&1){a=zc()|0;g=10;break}o=0;Ja(413,e+16|0);i=o;o=0;if(i&1){f=zc()|0;break}else{$5(e);c[a>>2]=0;break a}}while(0);do if((g|0)==10){o=0;Ja(413,e+16|0);i=o;o=0;if(i&1){i=zc(0)|0;Di(i)}else{f=a;break}}while(0);$5(e);i=f;Kc(i|0)}while(0);a=h+(d*144|0)+44|0;e=c[a>>2]|0;do if(e){o=0;Ja(437,e|0);i=o;o=0;if(!(i&1)){$5(e);c[a>>2]=0;break}i=zc()|0;$5(e);Kc(i|0)}while(0);a=c[h+(d*144|0)+52>>2]|0;if((a|0)!=0?(c[h+(d*144|0)+32>>2]|0)<0:0)tE(sy(a,-1)|0);a=h+(d*144|0)+48|0;e=c[a>>2]|0;if(e){tE(e+152|0);c[a>>2]=0}a=h+(d*144|0)+56|0;e=c[a>>2]|0;if(e){tE(e);c[a>>2]=0}a=h+(d*144|0)+60|0;e=c[a>>2]|0;if(!e){i=0;return i|0}tE(e);c[a>>2]=0;i=0;return i|0}function mm(a,b){a=a|0;b=+b;return}function nm(a,b){a=a|0;b=+b;var c=0,d=0,e=0,f=0,h=0;e=i;i=i+16|0;f=e;pI(f);o=0;c=qa(132,32)|0;h=o;o=0;do if(!(h&1)?(o=0,d=qa(132,31)|0,h=o,o=0,!(h&1)):0)if(!d){o=0;c=qb(11)|0;h=o;o=0;if(h&1)break;o=0;Pa(1,a|0,256,c|0,1.0,0);h=o;o=0;if(h&1)break;uI(f);i=e;return}else{b=+g[a+108>>2];o=0;Ua(2,f|0,+(+(c>>>16&255|0)*b),+(+(c>>>8&255|0)*b),+(+(c&255|0)*b),1.0);h=o;o=0;if(h&1)break;o=0;Pa(1,a|0,16640,f|0,1.0,0);h=o;o=0;if(h&1)break;uI(f);i=e;return}while(0);c=zc()|0;o=0;Ja(413,f|0);h=o;o=0;if(h&1){h=zc(0)|0;Di(h)}else Kc(c|0)}function om(a,b,c){a=a|0;b=b|0;c=c|0;return}function pm(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return}function qm(a,b,c){a=a|0;b=b|0;c=c|0;if((b|0)!=37)return;Eu((c|0)!=0);return}function rm(a,b){a=a|0;b=b|0;if((b|0)!=36)return;bm(36,c[a+28>>2]|0);return}function sm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((d|0)<0)d=(c[a+120>>2]|0)-b|0;if((b|0)<0){a=-1;return a|0}e=c[a+120>>2]|0;if((e|0)<=(b|0)|(d+b|0)>(e|0)){e=-1;return e|0}c[a+124>>2]=b;c[a+128>>2]=d;e=0;return e|0}function tm(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0;j=i;i=i+80|0;b=j;g=j+56|0;f=j+40|0;h=j+24|0;e=a+236|0;Uw(0.0,+((c[a+32>>2]|0)>>>0),+((c[a+36>>2]|0)>>>0),0.0,-1.0,1.0,e);rx(e,.5,0.0,0.0);e=Ds(51780,51804,0)|0;c[a+308>>2]=e;if(!e){c[b>>2]=32670;Uv(2,63728,b);Uv(2,32683,j+8|0);Uv(2,63797,j+16|0);Jb(63799,32711,399,32670)}b=ym(a)|0;QI(g,1,3);QI(g+8|0,3,4);KI(f,g,2);o=0;d=oa(4,f|0,5,b|0,1,16,16)|0;e=o;o=0;if(e&1){e=zc()|0;o=0;Ja(438,f|0);k=o;o=0;if(k&1){k=zc(0)|0;Di(k)}else{k=e;Kc(k|0)}}c[a+300>>2]=d;LI(f);if(b)tE(b);e=ym(a)|0;KI(h,g,2);o=0;b=oa(4,h|0,1,e|0,1,4,4)|0;k=o;o=0;if(k&1){d=zc()|0;o=0;Ja(438,h|0);k=o;o=0;if(k&1){k=zc(0)|0;Di(k)}else{k=d;Kc(k|0)}}c[a+304>>2]=b;LI(h);if(!e){k=a+312|0;M9(k|0,0,384)|0;i=j;return 1}tE(e);k=a+312|0;M9(k|0,0,384)|0;i=j;return 1}function um(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;aE(g);o=0;Ua(1,g|0,+(+(b|0)),+(+(c|0)),+(+(d|0)),+(+(e|0)));c=o;o=0;if(!(c&1)?(o=0,na(132,a|0,g|0),c=o,o=0,!(c&1)):0){eE(g);i=f;return}e=zc()|0;o=0;Ja(433,g|0);g=o;o=0;if(g&1){g=zc(0)|0;Di(g)}else Kc(e|0)}function vm(a,b,c,d,e,f,g){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;g=+g;mI(a+212|0,b,d,f);mI(a+224|0,c,e,g);return}function wm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=a+212|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];b=a+224|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];return}function xm(a,b){a=a|0;b=b|0;if((b&267386880|0)==2097152){Nn(a,b)|0;return}else{lm(a,b&1048575)|0;return}}function ym(a){a=a|0;var b=0,d=0,e=0;e=i;i=i+32|0;d=e;b=fw(32731,32758,0)|0;if(!b){c[d>>2]=32785;Uv(2,63728,d);Uv(2,32807,e+8|0);Uv(2,63797,e+16|0);Jb(63799,32711,2152,32785)}else{Aw(AE(b,51944)|0,a+236|0);d=EE(b)|0;eF(d,0);fF(d,0);gF(d,0);bF(d,1);cF(d,770);dF(d,771);i=e;return b|0}return 0}function zm(a,b){a=a|0;b=b|0;c[a+164>>2]=b;return}function Am(a,d){a=a|0;d=d|0;var e=0;e=d&267386880;if((e|0)<1048576){switch(e|0){case 0:break;default:{a=0;return a|0}}if((d|0)<0){a=0;return a|0}if((c[a+120>>2]|0)<=(d|0)){a=0;return a|0}e=c[a+132>>2]|0;a=e+(d*144|0)|0;if((b[a>>1]|0)==0|(a|0)==0){a=0;return a|0}a=c[e+(d*144|0)+48>>2]|0;return a|0}switch(e|0){case 1048576:break;default:{a=0;return a|0}}switch(d|0){case 1048578:{a=ds(c[a+192>>2]|0)|0;return a|0}case 1048579:{d=c[a+172>>2]|0;if((d|0)<0){a=0;return a|0}if((c[a+120>>2]|0)<=(d|0)){a=0;return a|0}e=c[a+132>>2]|0;a=e+(d*144|0)|0;if((b[a>>1]|0)==0|(a|0)==0){a=0;return a|0}a=c[e+(d*144|0)+48>>2]|0;return a|0}default:{a=0;return a|0}}return 0}function Bm(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;do switch(e|0){case 0:{if(!d)return;pH(d,+g[f>>2],+g[f+4>>2],+g[f+8>>2]);return}case 1:{if(!d)return;dH(d,+g[f>>2],+g[f+4>>2],+g[f+8>>2],+g[f+12>>2]);return}case 2:{if(!d)return;hH(d,+g[f>>2],+g[f+4>>2],+g[f+8>>2]);return}case 3:{if(!b)return;xI(b+76|0,f);return}case 11:{if(!d)return;gH(d,+g[f+8>>2]);fH(d,+g[f+4>>2]);eH(d,+g[f>>2]);return}case 5:{if(!b)return;xI(b+92|0,f);if(!(c[b+60>>2]|0))return;Fn(a,b,5);return}case 6:{if(!b)return;xI(b+108|0,f);return}case 7:{if(!b)return;xI(b+124|0,f);return}case 10:{if(!d)return;fH(d,+g[f+4>>2]);gH(d,+g[f+8>>2]);eH(d,+g[f>>2]);return}case 9:{if(!d)return;eH(d,+g[f>>2]);fH(d,+g[f+4>>2]);gH(d,+g[f+8>>2]);return}default:return}while(0)}function Cm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=c[b+40>>2]|0;if(!a)return;switch(d|0){case 0:{xI(a+16|0,e);return}case 2:{xI(a+48|0,e);return}case 3:{xI(b+76|0,e);return}case 11:case 10:case 9:{xI(a+32|0,e);return}case 5:{xI(b+92|0,e);return}case 6:{xI(b+108|0,e);return}case 7:{xI(b+124|0,e);return}default:return}}function Dm(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=d&267386880;if((g|0)<1048576){switch(g|0){case 0:break;default:{a=-1;return a|0}}if((d|0)<0){a=-1;return a|0}if((c[a+120>>2]|0)<=(d|0)){a=-1;return a|0}g=c[a+132>>2]|0;h=g+(d*144|0)|0;if((b[h>>1]|0)==0|(h|0)==0){a=-1;return a|0}if(!(c[g+(d*144|0)+40>>2]|0)){Bm(a,h,c[g+(d*144|0)+48>>2]|0,e,f);a=0;return a|0}else{Cm(0,h,e,f);a=0;return a|0}}switch(g|0){case 1048576:break;default:{a=-1;return a|0}}switch(d|0){case 1048577:{a=0;return a|0}case 1048578:{g=c[a+180>>2]|0;if((g|0)<0){a=-1;return a|0}if((c[a+120>>2]|0)<=(g|0)){a=-1;return a|0}g=(c[a+132>>2]|0)+(g*144|0)|0;if(!(b[g>>1]|0)){a=-1;return a|0}break}case 1048579:{g=c[a+172>>2]|0;if((g|0)<0){a=-1;return a|0}if((c[a+120>>2]|0)<=(g|0)){a=-1;return a|0}g=(c[a+132>>2]|0)+(g*144|0)|0;if(!(b[g>>1]|0)){a=-1;return a|0}break}default:{a=-1;return a|0}}if(!g){a=-1;return a|0}Bm(a,g,c[g+48>>2]|0,e,f);a=0;return a|0}function Em(a,d){a=a|0;d=d|0;if((d|0)<0){a=0;return a|0}if((c[a+120>>2]|0)<=(d|0)){a=0;return a|0}a=(c[a+132>>2]|0)+(d*144|0)|0;a=(b[a>>1]|0)==0?0:a;return a|0}function Fm(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+96|0;g=d+80|0;e=d+16|0;f=d;QH(g);o=0;za(1,g|0,0.0,1.0,0.0);a=o;o=0;a:do if(!(a&1)?(o=0,Ja(428,e|0),a=o,o=0,!(a&1)):0){o=0;a=qa(133,b|0)|0;l=o;o=0;do if(((!(l&1)?(o=0,yb(54,a|0,c|0,g|0,e|0),l=o,o=0,!(l&1)):0)?(o=0,Ja(439,e|0),l=o,o=0,!(l&1)):0)?(o=0,Ja(427,f|0),l=o,o=0,!(l&1)):0){o=0;cb(49,e|0,f|0)|0;l=o;o=0;if(!(l&1)?(o=0,na(133,b|0,f|0),l=o,o=0,!(l&1)):0){o=0;Ja(429,f|0);l=o;o=0;if(l&1){k=13;break}o=0;Ja(440,e|0);l=o;o=0;if(l&1){k=12;break a}WH(g);i=d;return}a=zc()|0;o=0;Ja(429,f|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else h=a}else k=13;while(0);if((k|0)==13)h=zc()|0;o=0;Ja(440,e|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else j=h}else k=12;while(0);if((k|0)==12)j=zc()|0;o=0;Ja(412,g|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else Kc(j|0)}function Gm(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0;k=i;i=i+16|0;l=k;QH(l);o=0;za(1,l|0,+(+g[e>>2]),+(+g[e+4>>2]),+(+g[e+8>>2]));e=o;o=0;a:do if(!(e&1)){e=d&267386880;b:do if((e|0)<1048576){switch(e|0){case 0:break;default:{e=-1;break b}}if(((d|0)>=0?(c[a+120>>2]|0)>(d|0):0)?(f=c[a+132>>2]|0,a=f+(d*144|0)|0,!((b[a>>1]|0)==0|(a|0)==0)):0){e=c[f+(d*144|0)+48>>2]|0;j=13}else e=-1}else{switch(e|0){case 1048576:break;default:{e=-1;break b}}switch(d|0){case 1048578:{o=0;e=qa(134,c[a+192>>2]|0)|0;j=o;o=0;if(j&1)break a;else{j=13;break b}}case 1048579:break;default:{e=-1;break b}}e=c[a+172>>2]|0;if(((e|0)>=0?(c[a+120>>2]|0)>(e|0):0)?(h=c[a+132>>2]|0,a=h+(e*144|0)|0,!((b[a>>1]|0)==0|(a|0)==0)):0){e=c[h+(e*144|0)+48>>2]|0;j=13}else e=-1}while(0);if((j|0)==13)if(e){o=0;sb(122,0,e|0,l|0);j=o;o=0;if(j&1)break;else e=0}else e=-1;WH(l);i=k;return e|0}while(0);e=zc()|0;o=0;Ja(412,l|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else Kc(e|0);return 0}function Hm(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0;h=i;i=i+192|0;j=h+128|0;k=h+64|0;l=h;do switch(e|0){case 0:{if(!d){i=h;return}oH(d,+g[f>>2],+g[f+4>>2],+g[f+8>>2]);i=h;return}case 1:{if(!d){i=h;return}lH(d,+g[f>>2],+g[f+4>>2],+g[f+8>>2],+g[f+12>>2]);i=h;return}case 2:{if(!d){i=h;return}iH(d,+g[f>>2],+g[f+4>>2],+g[f+8>>2]);i=h;return}case 3:{if(!b){i=h;return}l=b+76|0;c[l>>2]=c[f>>2];c[l+4>>2]=c[f+4>>2];c[l+8>>2]=c[f+8>>2];c[l+12>>2]=c[f+12>>2];i=h;return}case 7:{if(!b){i=h;return}l=b+124|0;c[l>>2]=c[f>>2];c[l+4>>2]=c[f+4>>2];c[l+8>>2]=c[f+8>>2];c[l+12>>2]=c[f+12>>2];i=h;return}case 9:{if(!d){i=h;return}Kw(j);o=0;qb(12)|0;l=o;o=0;if((((!(l&1)?(o=0,ia(21,j|0,+(+g[f>>2])),l=o,o=0,!(l&1)):0)?(o=0,ia(22,j|0,+(+g[f+4>>2])),l=o,o=0,!(l&1)):0)?(o=0,ia(23,j|0,+(+g[f+8>>2])),l=o,o=0,!(l&1)):0)?(o=0,na(134,d|0,j|0),l=o,o=0,!(l&1)):0){Pw(j);i=h;return}e=zc()|0;o=0;Ja(440,j|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else{l=e;Kc(l|0)}break}case 10:{if(!d){i=h;return}Kw(k);o=0;qb(12)|0;l=o;o=0;if((((!(l&1)?(o=0,ia(22,k|0,+(+g[f+4>>2])),l=o,o=0,!(l&1)):0)?(o=0,ia(21,k|0,+(+g[f>>2])),l=o,o=0,!(l&1)):0)?(o=0,ia(23,k|0,+(+g[f+8>>2])),l=o,o=0,!(l&1)):0)?(o=0,na(134,d|0,k|0),l=o,o=0,!(l&1)):0){Pw(k);i=h;return}e=zc()|0;o=0;Ja(440,k|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else{l=e;Kc(l|0)}break}case 11:{if(!d){i=h;return}Kw(l);o=0;qb(12)|0;k=o;o=0;if((((!(k&1)?(o=0,ia(23,l|0,+(+g[f+8>>2])),k=o,o=0,!(k&1)):0)?(o=0,ia(22,l|0,+(+g[f+4>>2])),k=o,o=0,!(k&1)):0)?(o=0,ia(21,l|0,+(+g[f>>2])),k=o,o=0,!(k&1)):0)?(o=0,na(134,d|0,l|0),k=o,o=0,!(k&1)):0){Pw(l);i=h;return}e=zc()|0;o=0;Ja(440,l|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else{l=e;Kc(l|0)}break}case 5:{if(!b){i=h;return}l=b+92|0;c[l>>2]=c[f>>2];c[l+4>>2]=c[f+4>>2];c[l+8>>2]=c[f+8>>2];c[l+12>>2]=c[f+12>>2];if(!(c[b+60>>2]|0)){i=h;return}Fn(a,b,5);i=h;return}case 6:{if(!b){i=h;return}l=b+108|0;c[l>>2]=c[f>>2];c[l+4>>2]=c[f+4>>2];c[l+8>>2]=c[f+8>>2];c[l+12>>2]=c[f+12>>2];i=h;return}default:{i=h;return}}while(0)}function Im(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=d&267386880;if((g|0)>=1048576){switch(g|0){case 1048576:break;default:{a=-1;return a|0}}switch(d|0){case 1048577:{a=0;return a|0}case 1048578:{g=c[a+180>>2]|0;if((g|0)<0){a=-1;return a|0}if((c[a+120>>2]|0)<=(g|0)){a=-1;return a|0}g=(c[a+132>>2]|0)+(g*144|0)|0;if(!(b[g>>1]|0)){a=-1;return a|0}break}case 1048579:{g=c[a+172>>2]|0;if((g|0)<0){a=-1;return a|0}if((c[a+120>>2]|0)<=(g|0)){a=-1;return a|0}g=(c[a+132>>2]|0)+(g*144|0)|0;if(!(b[g>>1]|0)){a=-1;return a|0}break}default:{a=-1;return a|0}}if(!g){a=-1;return a|0}Hm(a,g,c[g+48>>2]|0,e,f);a=0;return a|0}switch(g|0){case 0:break;default:{a=-1;return a|0}}if((d|0)<0){a=-1;return a|0}if((c[a+120>>2]|0)<=(d|0)){a=-1;return a|0}h=c[a+132>>2]|0;i=h+(d*144|0)|0;if((b[i>>1]|0)==0|(i|0)==0){a=-1;return a|0}g=c[h+(d*144|0)+40>>2]|0;if(!g){Hm(a,i,c[h+(d*144|0)+48>>2]|0,e,f);a=0;return a|0}switch(e|0){case 0:{sI(g+16|0,f);a=0;return a|0}case 2:{sI(g+48|0,f);a=0;return a|0}case 3:{a=h+(d*144|0)+76|0;c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];a=0;return a|0}case 11:case 10:case 9:{sI(g+32|0,f);a=0;return a|0}case 5:{a=h+(d*144|0)+92|0;c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];a=0;return a|0}case 6:{a=h+(d*144|0)+108|0;c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];a=0;return a|0}case 7:{a=h+(d*144|0)+124|0;c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];a=0;return a|0}default:{a=0;return a|0}}return 0}function Jm(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;h=i;i=i+16|0;j=h;switch(e|0){case 0:{if(!d){i=h;return}j=cH(d)|0;c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];g[f+12>>2]=0.0;i=h;return}case 1:{if(!d){i=h;return}SD(j);o=0;a=qa(135,d|0)|0;b=o;o=0;if(!(b&1)){c[j>>2]=c[a>>2];c[j+4>>2]=c[a+4>>2];c[j+8>>2]=c[a+8>>2];c[j+12>>2]=c[a+12>>2];c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];VD(j);i=h;return}a=zc()|0;o=0;Ja(429,j|0);j=o;o=0;if(j&1){j=zc(0)|0;Di(j)}else Kc(a|0);break}case 2:{if(!d){i=h;return}j=aH(d)|0;c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];g[f+12>>2]=1.0;i=h;return}case 3:{if(!b){i=h;return}j=b+76|0;c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];i=h;return}case 7:{if(!b){i=h;return}j=b+124|0;c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];i=h;return}case 5:{if(!b){i=h;return}j=b+92|0;c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];i=h;return}case 6:{if(!b){i=h;return}j=b+108|0;c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];i=h;return}default:{i=h;return}}}function Km(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=d&267386880;a:do if((g|0)>=1048576){switch(g|0){case 1048576:break;default:{g=0;break a}}switch(d|0){case 1048578:{g=ds(c[a+192>>2]|0)|0;break a}case 1048579:break;default:{g=0;break a}}g=c[a+172>>2]|0;if(((g|0)>=0?(c[a+120>>2]|0)>(g|0):0)?(h=c[a+132>>2]|0,d=h+(g*144|0)|0,!((b[d>>1]|0)==0|(d|0)==0)):0)g=c[h+(g*144|0)+48>>2]|0;else g=0}else{switch(g|0){case 0:break;default:{g=0;break a}}if((d|0)<0){f=-1;return f|0}if((c[a+120>>2]|0)<=(d|0)){f=-1;return f|0}h=c[a+132>>2]|0;a=h+(d*144|0)|0;if((b[a>>1]|0)==0|(a|0)==0){f=-1;return f|0}g=c[h+(d*144|0)+40>>2]|0;if(!g){Jm(0,a,c[h+(d*144|0)+48>>2]|0,e,f);f=0;return f|0}switch(e|0){case 0:{sI(f,g+16|0);f=0;return f|0}case 2:{sI(f,g+48|0);f=0;return f|0}case 11:case 10:case 9:{sI(f,g+32|0);f=0;return f|0}case 3:{e=h+(d*144|0)+76|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];f=0;return f|0}case 5:{e=h+(d*144|0)+92|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];f=0;return f|0}case 6:{e=h+(d*144|0)+108|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];f=0;return f|0}case 7:{e=h+(d*144|0)+124|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];f=0;return f|0}default:{f=0;return f|0}}}while(0);Jm(0,0,g,e,f);f=0;return f|0}function Lm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0;n=i;i=i+96|0;l=n+80|0;m=n+72|0;j=n+64|0;p=n;Kw(p);k=b+188|0;o=0;e=qa(136,c[k>>2]|0)|0;h=o;o=0;a:do if((!(h&1)?(o=0,f=qa(134,e|0)|0,h=o,o=0,!(h&1)):0)?(o=0,g=qa(137,f|0)|0,h=o,o=0,!(h&1)):0){h=p;e=g;f=h+64|0;do{c[h>>2]=c[e>>2];h=h+4|0;e=e+4|0}while((h|0)<(f|0));o=0;cb(49,p|0,b+196|0)|0;h=o;o=0;if(!(h&1)){if(d&2){a[b+184>>0]=0;f=c[k>>2]|0;o=0;e=qa(138,f|0)|0;h=o;o=0;if(h&1){q=15;break}b:do if(e){g=j+4|0;while(1){c[j>>2]=50;c[g>>2]=0;o=0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];yb(55,f|0,e|0,b|0,l|0);h=o;o=0;if(h&1)break;o=0;e=qa(139,e|0)|0;h=o;o=0;if(h&1)break;if(!e)break b}e=zc()|0;break a}while(0)}if(!(d&8)){Pw(p);i=n;return}a[b+184>>0]=1;f=c[k>>2]|0;o=0;e=qa(138,f|0)|0;d=o;o=0;if(!(d&1)){c:do if(e){g=m+4|0;while(1){c[m>>2]=50;c[g>>2]=0;o=0;c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];yb(55,f|0,e|0,b|0,l|0);d=o;o=0;if(d&1)break;o=0;e=qa(139,e|0)|0;d=o;o=0;if(d&1)break;if(!e)break c}e=zc()|0;break a}while(0);Pw(p);i=n;return}else q=15}else q=15}else q=15;while(0);if((q|0)==15)e=zc()|0;o=0;Ja(440,p|0);q=o;o=0;if(q&1){q=zc(0)|0;Di(q)}else Kc(e|0)}function Mm(a,e){a=a|0;e=e|0;var f=0.0,g=0,h=0,i=0,j=0,k=0;g=Uy(e)|0;j=nz(e)|0;if(g){if(!(b[g>>1]|0)){k=0;return k|0}k=c[g+4>>2]|0;if(k&1){k=0;return k|0}i=g+16|0;h=c[i>>2]|0;if((h|0)<1){k=0;return k|0}if((((k&16384|0)==0?(h|0)<255&1:1)|0)!=(d[a+184>>0]|0)){k=0;return k|0}if(k&4)kH(e,a+196|0);if((k&2|0)!=0?(e=uz(e)|0,!(Xq(e,is(c[a+192>>2]|0)|0)|0)):0){k=0;return k|0}h=c[g+140>>2]|0;if(h){g=c[i>>2]|0;if((g|0)<=254)if((g|0)<1)f=0.0;else f=+(g|0)*.003921568859368563;else f=1.0;uw(h,f)}if(!((j|0)==0|(k&8|0)==0)){zy(j,1);k=1;return k|0}}if(!j){k=1;return k|0}zy(j,0);k=1;return k|0}function Nm(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=Ry(b)|0;if(d)Nm(a,d,c)|0;d=Sy(b)|0;if(d)Nm(a,d,c)|0;d=nz(b)|0;if(!d)return 1;ty(d,c,-1);return 1}function Om(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;if((d|0)<0){f=-1;return f|0}if((c[a+120>>2]|0)<=(d|0)){f=-1;return f|0}d=(c[a+132>>2]|0)+(d*144|0)|0;d=(b[d>>1]|0)==0?0:d;if((e|0)<0|(d|0)==0){f=-1;return f|0}do if(!(e&256))if(e>>>0>35){f=-1;return f|0}else{d=d+(e<<2)|0;break}else{a=c[d+40>>2]|0;if(!a){f=-1;return f|0}d=e&255;if(d>>>0>15){f=-1;return f|0}else{d=a+(d<<2)|0;break}}while(0);if(!d){f=-1;return f|0}c[f>>2]=c[d>>2];f=0;return f|0}function Pm(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;if((d|0)<0){f=-1;return f|0}if((c[a+120>>2]|0)<=(d|0)){f=-1;return f|0}d=(c[a+132>>2]|0)+(d*144|0)|0;d=(b[d>>1]|0)==0?0:d;if((e|0)<0|(d|0)==0){f=-1;return f|0}do if(!(e&256))if(e>>>0>35){f=-1;return f|0}else{d=d+(e<<2)|0;break}else{a=c[d+40>>2]|0;if(!a){f=-1;return f|0}d=e&255;if(d>>>0>15){f=-1;return f|0}else{d=a+(d<<2)|0;break}}while(0);if(!d){f=-1;return f|0}c[d>>2]=f;f=0;return f|0}function Qm(a){a=a|0;var b=0,d=0,e=0;b=Rm(a)|0;if(!b){a=-1;return a|0}e=Iy(0)|0;d=b+48|0;c[d>>2]=e;Vy(e,b,0);if((c[a+164>>2]|0)>-1)BF(c[a+188>>2]|0,c[d>>2]|0);e=c[b+8>>2]|0;return e|0}function Rm(a){a=a|0;var d=0,e=0,f=0,g=0;d=c[a+124>>2]|0;f=c[a+128>>2]|0;if((d|0)>=(f|0)){g=0;return g|0}e=d;d=(c[a+132>>2]|0)+(d*144|0)|0;while(1){if(!(b[d>>1]|0)){a=d;break}e=e+1|0;if((e|0)>=(f|0)){d=0;g=6;break}else d=d+144|0}if((g|0)==6)return d|0;c[d+4>>2]=0;b[d+2>>1]=0;c[d+28>>2]=-1;g=d+40|0;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;b[a>>1]=1;c[d+8>>2]=e;c[d+20>>2]=0;c[d+24>>2]=0;c[d+16>>2]=255;c[d+32>>2]=-1;c[d+36>>2]=-1;c[d+140>>2]=0;sI(d+76|0,vI()|0);sI(d+92|0,vI()|0);sI(d+108|0,vI()|0);sI(d+124|0,vI()|0);g=d;return g|0}function Sm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;a=Rm(a)|0;if(!a){j=-1;return j|0}g=Z5(64)|0;h=g+16|0;o=0;Ja(426,h|0);i=o;o=0;if(i&1){j=zc()|0;$5(g);Kc(j|0)}i=g+32|0;o=0;Ja(426,i|0);f=o;o=0;do if(!(f&1)){f=g+48|0;o=0;Ja(426,f|0);k=o;o=0;if(k&1){a=zc()|0;o=0;Ja(413,i|0);k=o;o=0;if(!(k&1)){j=a;break}k=zc(0)|0;Di(k)}else{c[a+40>>2]=g;k=a+8|0;c[g>>2]=c[k>>2];c[g+4>>2]=b;c[g+8>>2]=d;c[g+12>>2]=e;sI(h,vI()|0);sI(i,vI()|0);yI(f,1.0,1.0,1.0,1.0);j=a+4|0;c[j>>2]=c[j>>2]|256;k=c[k>>2]|0;return k|0}}else j=zc()|0;while(0);o=0;Ja(413,h|0);k=o;o=0;if(k&1){k=zc(0)|0;Di(k)}k=j;$5(g);Kc(k|0);return 0}function Tm(a,b,d,e,f){a=a|0;b=+b;d=+d;e=e|0;f=f|0;var g=0,h=0.0,j=0,k=0.0,l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;v=i;i=i+48|0;q=v+36|0;r=v+24|0;s=v+12|0;m=v;t=Rm(a)|0;if(!t){u=-1;i=v;return u|0}h=b*-.5;k=d*-.5;RH(q,h,0.0,k);l=d*.5;o=0;za(3,r|0,+h,0.0,+l);j=o;o=0;a:do if(!(j&1)){h=b*.5;o=0;za(3,s|0,+h,0.0,+k);j=o;o=0;b:do if(!(j&1)){o=0;za(3,m|0,+h,0.0,+l);j=o;o=0;do if(!(j&1)){o=0;j=pb(29,q|0,r|0,s|0,m|0)|0;g=o;o=0;if(g&1){g=zc()|0;o=0;Ja(412,m|0);w=o;o=0;if(!(w&1))break;w=zc(0)|0;Di(w)}o=0;Ja(412,m|0);w=o;o=0;if(!(w&1)){o=0;Ja(412,s|0);w=o;o=0;if(w&1){u=12;break b}o=0;Ja(412,r|0);w=o;o=0;if(w&1){u=11;break a}WH(q);if((f|0)<0)g=Wn(a,e,(c[a+168>>2]|0)>>>31)|0;else g=On(a,f)|0;Um(0,t,j,g);if(j)tE(j);c[t+28>>2]=2;mI(t+64|0,b,0.0,d);if((c[a+164>>2]|0)>-1)BF(c[a+188>>2]|0,c[t+48>>2]|0);w=c[t+8>>2]|0;i=v;return w|0}else u=13}else u=13;while(0);if((u|0)==13)g=zc()|0;o=0;Ja(412,s|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}else n=g}else u=12;while(0);if((u|0)==12)n=zc()|0;o=0;Ja(412,r|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}else p=n}else u=11;while(0);if((u|0)==11)p=zc()|0;o=0;Ja(412,q|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}else Kc(p|0);return 0}function Um(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0;g=qy(e)|0;ty(g,f,-1);a=d+48|0;e=c[a>>2]|0;if(!e){e=Iy(0)|0;c[a>>2]=e}sz(e,g);Vy(e,d,0);c[d+52>>2]=g;e=d+140|0;c[e>>2]=0;if((f|0)!=0&(b[d>>1]|0)!=0?Qn(f,33190)|0:0)c[e>>2]=AE(f,33190)|0;if(!g)return;tE(g);return}function Vm(a,b,d,e,f){a=a|0;b=+b;d=+d;e=e|0;f=f|0;var g=0,h=0.0,j=0,k=0.0,l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;v=i;i=i+48|0;q=v+36|0;r=v+24|0;s=v+12|0;m=v;t=Rm(a)|0;if(!t){u=-1;i=v;return u|0}h=b*-.5;k=d*.5;RH(q,h,k,0.0);l=d*-.5;o=0;za(3,r|0,+h,+l,0.0);j=o;o=0;a:do if(!(j&1)){h=b*.5;o=0;za(3,s|0,+h,+k,0.0);j=o;o=0;b:do if(!(j&1)){o=0;za(3,m|0,+h,+l,0.0);j=o;o=0;do if(!(j&1)){o=0;j=pb(29,q|0,r|0,s|0,m|0)|0;g=o;o=0;if(g&1){g=zc()|0;o=0;Ja(412,m|0);w=o;o=0;if(!(w&1))break;w=zc(0)|0;Di(w)}o=0;Ja(412,m|0);w=o;o=0;if(!(w&1)){o=0;Ja(412,s|0);w=o;o=0;if(w&1){u=12;break b}o=0;Ja(412,r|0);w=o;o=0;if(w&1){u=11;break a}WH(q);if((f|0)<0)g=Wn(a,e,(c[a+168>>2]|0)>>>31)|0;else g=On(a,f)|0;Um(0,t,j,g);if(j)tE(j);c[t+28>>2]=3;mI(t+64|0,b,d,0.0);if((c[a+164>>2]|0)>-1)BF(c[a+188>>2]|0,c[t+48>>2]|0);w=c[t+8>>2]|0;i=v;return w|0}else u=13}else u=13;while(0);if((u|0)==13)g=zc()|0;o=0;Ja(412,s|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}else n=g}else u=12;while(0);if((u|0)==12)n=zc()|0;o=0;Ja(412,r|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}else p=n}else u=11;while(0);if((u|0)==11)p=zc()|0;o=0;Ja(412,q|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}else Kc(p|0);return 0}function Wm(a,b,d,e){a=a|0;b=+b;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;j=i;i=i+16|0;h=j;g=Rm(a)|0;if(!g){h=-1;i=j;return h|0}f=Xm(0,b)|0;if((e|0)<0)d=Wn(a,d,(c[a+168>>2]|0)>>>31)|0;else d=On(a,e)|0;Um(0,g,f,d);c[g+28>>2]=1;mI(g+64|0,b,b,b);if(f)tE(f);if((c[a+164>>2]|0)>-1){d=g+48|0;BF(c[a+188>>2]|0,c[d>>2]|0)}else d=g+48|0;Tq(h,uz(c[d>>2]|0)|0);g=c[g+8>>2]|0;Vq(h);h=g;i=j;return h|0}function Xm(a,d){a=a|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0.0;p=i;i=i+912|0;m=p+16|0;l=p+8|0;k=p;n=p+64|0;j=p+832|0;h=p+40|0;q=p+24|0;d=d*.5;r=-d;g[n>>2]=r;g[n+4>>2]=r;g[n+8>>2]=d;g[n+12>>2]=0.0;g[n+16>>2]=0.0;g[n+20>>2]=1.0;g[n+24>>2]=0.0;g[n+28>>2]=0.0;g[n+32>>2]=d;g[n+36>>2]=r;g[n+40>>2]=d;g[n+44>>2]=0.0;g[n+48>>2]=0.0;g[n+52>>2]=1.0;g[n+56>>2]=1.0;g[n+60>>2]=0.0;g[n+64>>2]=r;g[n+68>>2]=d;g[n+72>>2]=d;g[n+76>>2]=0.0;g[n+80>>2]=0.0;g[n+84>>2]=1.0;g[n+88>>2]=0.0;g[n+92>>2]=1.0;g[n+96>>2]=d;g[n+100>>2]=d;g[n+104>>2]=d;g[n+108>>2]=0.0;g[n+112>>2]=0.0;g[n+116>>2]=1.0;g[n+120>>2]=1.0;g[n+124>>2]=1.0;g[n+128>>2]=r;g[n+132>>2]=d;g[n+136>>2]=d;g[n+140>>2]=0.0;g[n+144>>2]=1.0;g[n+148>>2]=0.0;g[n+152>>2]=0.0;g[n+156>>2]=0.0;g[n+160>>2]=d;g[n+164>>2]=d;g[n+168>>2]=d;g[n+172>>2]=0.0;g[n+176>>2]=1.0;g[n+180>>2]=0.0;g[n+184>>2]=1.0;g[n+188>>2]=0.0;g[n+192>>2]=r;g[n+196>>2]=d;g[n+200>>2]=r;g[n+204>>2]=0.0;g[n+208>>2]=1.0;g[n+212>>2]=0.0;g[n+216>>2]=0.0;g[n+220>>2]=1.0;g[n+224>>2]=d;g[n+228>>2]=d;g[n+232>>2]=r;g[n+236>>2]=0.0;g[n+240>>2]=1.0;g[n+244>>2]=0.0;g[n+248>>2]=1.0;g[n+252>>2]=1.0;g[n+256>>2]=r;g[n+260>>2]=d;g[n+264>>2]=r;g[n+268>>2]=0.0;g[n+272>>2]=0.0;g[n+276>>2]=-1.0;g[n+280>>2]=0.0;g[n+284>>2]=0.0;g[n+288>>2]=d;g[n+292>>2]=d;g[n+296>>2]=r;g[n+300>>2]=0.0;g[n+304>>2]=0.0;g[n+308>>2]=-1.0;g[n+312>>2]=1.0;g[n+316>>2]=0.0;g[n+320>>2]=r;g[n+324>>2]=r;g[n+328>>2]=r;g[n+332>>2]=0.0;g[n+336>>2]=0.0;g[n+340>>2]=-1.0;g[n+344>>2]=0.0;g[n+348>>2]=1.0;g[n+352>>2]=d;g[n+356>>2]=r;g[n+360>>2]=r;g[n+364>>2]=0.0;g[n+368>>2]=0.0;g[n+372>>2]=-1.0;g[n+376>>2]=1.0;g[n+380>>2]=1.0;g[n+384>>2]=r;g[n+388>>2]=r;g[n+392>>2]=r;g[n+396>>2]=0.0;g[n+400>>2]=-1.0;g[n+404>>2]=0.0;g[n+408>>2]=0.0;g[n+412>>2]=0.0;g[n+416>>2]=d;g[n+420>>2]=r;g[n+424>>2]=r;g[n+428>>2]=0.0;g[n+432>>2]=-1.0;g[n+436>>2]=0.0;g[n+440>>2]=1.0;g[n+444>>2]=0.0;g[n+448>>2]=r;g[n+452>>2]=r;g[n+456>>2]=d;g[n+460>>2]=0.0;g[n+464>>2]=-1.0;g[n+468>>2]=0.0;g[n+472>>2]=0.0;g[n+476>>2]=1.0;g[n+480>>2]=d;g[n+484>>2]=r;g[n+488>>2]=d;g[n+492>>2]=0.0;g[n+496>>2]=-1.0;g[n+500>>2]=0.0;g[n+504>>2]=1.0;g[n+508>>2]=1.0;g[n+512>>2]=d;g[n+516>>2]=r;g[n+520>>2]=d;g[n+524>>2]=1.0;a=n+528|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[n+544>>2]=d;g[n+548>>2]=r;g[n+552>>2]=r;g[n+556>>2]=1.0;g[n+560>>2]=0.0;g[n+564>>2]=0.0;g[n+568>>2]=1.0;g[n+572>>2]=0.0;g[n+576>>2]=d;g[n+580>>2]=d;g[n+584>>2]=d;g[n+588>>2]=1.0;g[n+592>>2]=0.0;g[n+596>>2]=0.0;g[n+600>>2]=0.0;g[n+604>>2]=1.0;g[n+608>>2]=d;g[n+612>>2]=d;g[n+616>>2]=r;g[n+620>>2]=1.0;g[n+624>>2]=0.0;g[n+628>>2]=0.0;g[n+632>>2]=1.0;g[n+636>>2]=1.0;g[n+640>>2]=r;g[n+644>>2]=r;g[n+648>>2]=r;g[n+652>>2]=-1.0;a=n+656|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[n+672>>2]=r;g[n+676>>2]=r;g[n+680>>2]=d;g[n+684>>2]=-1.0;g[n+688>>2]=0.0;g[n+692>>2]=0.0;g[n+696>>2]=1.0;g[n+700>>2]=0.0;g[n+704>>2]=r;g[n+708>>2]=d;g[n+712>>2]=r;g[n+716>>2]=-1.0;g[n+720>>2]=0.0;g[n+724>>2]=0.0;g[n+728>>2]=0.0;g[n+732>>2]=1.0;g[n+736>>2]=r;g[n+740>>2]=d;g[n+744>>2]=d;g[n+748>>2]=-1.0;g[n+752>>2]=0.0;g[n+756>>2]=0.0;g[n+760>>2]=1.0;g[n+764>>2]=1.0;a=j;e=28468;f=a+72|0;do{b[a>>1]=b[e>>1]|0;a=a+2|0;e=e+2|0}while((a|0)<(f|0));QI(h,1,3);QI(h+8|0,2,3);QI(h+16|0,8,2);KI(q,h,3);o=0;a=Ha(40,q|0,24,0)|0;h=o;o=0;if(h&1){a=zc()|0;o=0;Ja(438,q|0);q=o;o=0;if(q&1){q=zc(0)|0;Di(q)}else Kc(a|0)}else{LI(q);if(!a){c[k>>2]=32828;Uv(2,63728,k);Uv(2,46044,l);Uv(2,63797,m);Jb(63799,32711,1938,32828)}else{yx(a,n,0,24);Zx(Gx(a,4,5123,36,0)|0,j,0,36);i=p;return a|0}}return 0}function Ym(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+1040|0;n=t;g=t+520|0;l=t+8|0;s=Rm(d)|0;if(!s){d=-1;i=t;return d|0}yp(e,g,1);C8(l,g)|0;h=g+(F8(g)|0)|0;a[h>>0]=a[32843]|0;a[h+1>>0]=a[32844]|0;a[h+2>>0]=a[32845]|0;a[h+3>>0]=a[32846]|0;a[h+4>>0]=a[32847]|0;h=l+(F8(l)|0)|0;j=37545;k=h+10|0;do{a[h>>0]=a[j>>0]|0;h=h+1|0;j=j+1|0}while((h|0)<(k|0));r=dr(g)|0;q=_v(l)|0;if(Qn(q,33130)|0)l=AE(q,33130)|0;else l=0;if(Qn(q,33145)|0)k=AE(q,33145)|0;else k=0;if(Qn(q,33162)|0)m=AE(q,33162)|0;else m=0;g=c[d+168>>2]|0;if((g|0)>-1){g=(c[d+132>>2]|0)+(g*144|0)|0;g=(b[g>>1]|0)==0?0:g;h=c[g+48>>2]|0;do if(k){ow(k);j=Z5(28)|0;o=0;na(135,j|0,k|0);u=o;o=0;if(u&1){u=zc()|0;$5(j);Kc(u|0)}else{c[j>>2]=7424;c[j+16>>2]=h;u=j+20|0;c[u>>2]=136;c[u+4>>2]=0;c[k+20>>2]=j;a[k+32>>0]=1;c[k+24>>2]=11;break}}while(0);if(l)xw(l,g+108|0,1);if(m)ww(m,Qv(qz(h)|0)|0)}do if(!f){h=Iy(0)|0;m=hr(r,0)|0;e=(m|0)!=0;if(e?(p=AF(m)|0,(mz(p,32871)|0)!=0):0)l=Jy(p)|0;else l=0;if(Br(r)|0){k=0;do{j=lr(r,Cr(r,k)|0)|0;if(j){g=nz(j)|0;if(g)ty(g,q,-1);g=mz(j,32871)|0;if(g){if(!(B8(Jy(j)|0,l)|0)){iq(Zp(g,32882,0,Yp(g)|0)|0,0.0);$p(g,32882);of[c[(c[h>>2]|0)+32>>2]&511](h,j)}}else of[c[(c[h>>2]|0)+32>>2]&511](h,j);tE(j+152|0)}k=k+1|0}while(k>>>0<(Br(r)|0)>>>0)}if(e)tE(m)}else{h=lr(r,f)|0;if(h){Nm(d,h,q)|0;break}c[n>>2]=e;c[n+4>>2]=f;Pp(32848,n);u=-1;i=t;return u|0}while(0);g=s+140|0;c[g>>2]=0;if((q|0)!=0&(b[s>>1]|0)!=0?Qn(q,33190)|0:0)c[g>>2]=AE(q,33190)|0;if((c[d+164>>2]|0)>-1)BF(c[d+188>>2]|0,h);if(r)tE(r);if(q)tE(q);Vy(h,s,0);c[s+48>>2]=h;c[s+28>>2]=0;u=c[s+8>>2]|0;i=t;return u|0}function Zm(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if((d|0)<0){a=-1;return a|0}if((c[a+120>>2]|0)<=(d|0)){a=-1;return a|0}h=c[a+132>>2]|0;i=h+(d*144|0)|0;if((b[i>>1]|0)==0|(i|0)==0){a=-1;return a|0}e=c[h+(d*144|0)+40>>2]|0;if(e){a=Sm(a,c[e+4>>2]|0,c[e+8>>2]|0,c[e+12>>2]|0)|0;return a|0}f=Rm(a)|0;if(!f){a=-1;return a|0}g=c[h+(d*144|0)+48>>2]|0;if(!g){a=c[f+8>>2]|0;return a|0}c[f+4>>2]=c[h+(d*144|0)+4>>2];c[f+32>>2]=c[h+(d*144|0)+32>>2];c[f+28>>2]=c[h+(d*144|0)+28>>2];e=f+64|0;d=h+(d*144|0)+64|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];Vy(g,0,0);d=vz(g)|0;e=f+48|0;c[e>>2]=d;Vy(d,f,0);if((c[a+164>>2]|0)>-1)BF(c[a+188>>2]|0,c[e>>2]|0);Vy(g,i,0);a=c[f+8>>2]|0;return a|0}function _m(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0,i=0,j=0,k=0,l=0.0;k=cm(27)|0;if(k&1){f=+g[c>>2];i=a+212|0;e=+g[i>>2];h=a+224|0;if(f<e){f=+g[h>>2]-(e-f);g[c>>2]=f}e=+g[h>>2];if(f>e)g[c>>2]=f-e+ +g[i>>2]}if(k&2){i=c+4|0;e=+g[i>>2];j=a+216|0;f=+g[j>>2];h=a+228|0;if(e<f){f=+g[h>>2]-(f-e);g[i>>2]=f}else f=e;e=+g[h>>2];if(f>e)g[i>>2]=f-e+ +g[j>>2]}if(k&4){i=c+8|0;e=+g[i>>2];j=a+220|0;f=+g[j>>2];h=a+232|0;if(e<f){f=+g[h>>2]-(f-e);g[i>>2]=f}else f=e;e=+g[h>>2];if(f>e)g[i>>2]=f-e+ +g[j>>2]}f=+g[c>>2];e=+g[a+212>>2];h=f<e;if(!(b&64)){l=+g[c+4>>2];e=+g[c+8>>2];if(((l<+g[a+216>>2]&1)+(f>+g[a+224>>2]?(h?2:1):h&1)+(l>+g[a+228>>2]&1)+(e<+g[a+220>>2]&1)|0)!=((e>+g[a+232>>2])<<31>>31|0)){d=-1;return d|0}}else{if(h){g[c>>2]=e;g[d>>2]=-+g[d>>2];f=e}e=+g[a+224>>2];if(f>e){g[c>>2]=e;g[d>>2]=-+g[d>>2]}h=c+4|0;e=+g[h>>2];f=+g[a+216>>2];if(e<f){g[h>>2]=f;b=d+4|0;g[b>>2]=-+g[b>>2];e=f}f=+g[a+228>>2];if(e>f){g[h>>2]=f;b=d+4|0;g[b>>2]=-+g[b>>2]}h=c+8|0;e=+g[h>>2];f=+g[a+220>>2];if(e<f){g[h>>2]=f;c=d+8|0;g[c>>2]=-+g[c>>2]}else f=e;e=+g[a+232>>2];if(f>e){g[h>>2]=e;d=d+8|0;g[d>>2]=-+g[d>>2]}}d=0;return d|0}function $m(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0;j=i;i=i+16|0;k=j;f=c[b+4>>2]|0;if(!(f&160)){i=j;return}QH(k);h=b+40|0;d=c[h>>2]|0;if(!d){o=0;d=qa(133,c[b+48>>2]|0)|0;l=o;o=0;if(!(l&1)){c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];e=7}}else{e=d+16|0;c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];c[k+8>>2]=c[e+8>>2];e=7}do if((e|0)==7){d=b+76|0;if((f&32|0)!=0?(o=0,na(137,k|0,d|0),l=o,o=0,l&1):0)break;if(f&128){o=0;d=pb(30,a|0,f|0,k|0,d|0)|0;l=o;o=0;if(l&1)break;if(d){o=0;cb(51,a|0,c[b+8>>2]|0)|0;l=o;o=0;if(l&1)break;WH(k);i=j;return}}d=c[h>>2]|0;if(!d){o=0;na(138,c[b+48>>2]|0,k|0);l=o;o=0;if(l&1)break;WH(k);i=j;return}else{o=0;Ua(2,d+16|0,+(+g[k>>2]),+(+g[k+4>>2]),+(+g[k+8>>2]),1.0);l=o;o=0;if(l&1)break;WH(k);i=j;return}}while(0);d=zc()|0;o=0;Ja(412,k|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else Kc(d|0)}function an(a){a=a|0;var d=0,e=0,f=0,g=0;if((c[a+8>>2]|0)==2)return;g=a+120|0;d=c[g>>2]|0;if((d|0)<=0)return;e=0;f=c[a+132>>2]|0;while(1){if(b[f>>1]|0){$m(a,f);d=c[g>>2]|0}e=e+1|0;if((e|0)>=(d|0))break;else f=f+144|0}return}function bn(a,d,e,f){a=a|0;d=d|0;e=+e;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;i=i+32|0;t=v+16|0;r=v;if((d|0)<0){d=-1;i=v;return d|0}n=a+120|0;k=c[n>>2]|0;if((k|0)<=(d|0)){d=-1;i=v;return d|0}m=a+132|0;h=c[m>>2]|0;s=h+(d*144|0)|0;if((b[s>>1]|0)==0|(s|0)==0){d=-1;i=v;return d|0}if(!f)s=c[h+(d*144|0)+24>>2]|0;else s=f;a=c[h+(d*144|0)+40>>2]|0;if(a){if((k|0)<=0){d=-1;i=v;return d|0}j=a+16|0;f=a+20|0;a=0;while(1){if((((((b[h>>1]|0)!=0?(c[h+4>>2]&1|0)==0:0)?!((a|0)==(d|0)?1:(c[h+20>>2]&s|0)==0):0)?(l=c[h+40>>2]|0,(l|0)!=0):0)?+O(+(+g[l+16>>2]-+g[j>>2]))<e:0)?+O(+(+g[l+20>>2]-+g[f>>2]))<e:0){u=38;break}a=a+1|0;if((a|0)>=(k|0)){a=-1;u=38;break}else h=h+144|0}if((u|0)==38){i=v;return a|0}}QH(t);o=0;Ja(441,r|0);l=o;o=0;a:do if(!(l&1)){h=h+(d*144|0)+48|0;a=c[h>>2]|0;b:do if(!a)q=-1;else{o=0;a=qa(133,a|0)|0;l=o;o=0;if(!(l&1)?(c[t>>2]=c[a>>2],c[t+4>>2]=c[a+4>>2],c[t+8>>2]=c[a+8>>2],o=0,j=qa(140,c[h>>2]|0)|0,l=o,o=0,!(l&1)):0){c[r>>2]=c[j>>2];c[r+4>>2]=c[j+4>>2];c[r+8>>2]=c[j+8>>2];c[r+12>>2]=c[j+12>>2];a=r+12|0;g[a>>2]=+g[a>>2]*e;a=c[n>>2]|0;if((a|0)<=0){q=-1;break}h=c[m>>2]|0;f=0;while(1){if((((b[h>>1]|0)!=0?(c[h+4>>2]&1|0)==0:0)?!((f|0)==(d|0)?1:(c[h+20>>2]&s|0)==0):0)?(p=c[h+48>>2]|0,(p|0)!=0):0){o=0;a=qa(140,p|0)|0;m=o;o=0;if(m&1)break;o=0;a=cb(52,r|0,a|0)|0;m=o;o=0;if(m&1)break;if(a){q=f;break b}a=c[n>>2]|0}f=f+1|0;if((f|0)>=(a|0)){q=-1;break b}else h=h+144|0}a=zc()|0}else a=zc()|0;o=0;Ja(442,r|0);d=o;o=0;if(!(d&1))break a;d=zc(0)|0;Di(d)}while(0);o=0;Ja(442,r|0);d=o;o=0;if(!(d&1)){WH(t);d=q;i=v;return d|0}else u=18}else u=18;while(0);if((u|0)==18)a=zc()|0;o=0;Ja(412,t|0);v=o;o=0;if(v&1){v=zc(0)|0;Di(v)}else Kc(a|0);return 0}function cn(b,d){b=b|0;d=d|0;c[b+136>>2]=0;c[b+152>>2]=c[b+132>>2];a[b+148>>0]=d&1;return}function dn(d){d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=d+136|0;e=c[k>>2]|0;j=c[d+120>>2]|0;if((e|0)>=(j|0)){m=0;return m|0}l=d+152|0;f=d+148|0;d=c[l>>2]|0;while(1){if(((((b[d>>1]|0)!=0?(c[d+40>>2]|0)!=0:0)?(g=a[f>>0]|0,h=c[d+4>>2]|0,(h&1|0)==0):0)?(i=c[d+16>>2]|0,(i|0)>=1):0)?(((h&16384|0)==0?(i|0)<255&1:1)|0)==(g&255|0):0)break;e=e+1|0;c[k>>2]=e;d=d+144|0;c[l>>2]=d;if((e|0)>=(j|0)){d=0;m=10;break}}if((m|0)==10)return d|0;c[k>>2]=e+1;c[l>>2]=d+144;m=d;return m|0}function en(a,b,d){a=a|0;b=b|0;d=d|0;c[a+136>>2]=0;c[a+152>>2]=c[a+132>>2];c[a+140>>2]=b;c[a+144>>2]=d;return}function fn(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;h=a+136|0;d=c[h>>2]|0;f=c[a+120>>2]|0;if((d|0)>=(f|0)){j=0;return j|0}i=a+152|0;g=a+144|0;e=a+140|0;a=c[i>>2]|0;while(1){if(((b[a>>1]|0)!=0?(c[g>>2]&c[a+24>>2]|0)!=0:0)?(c[e>>2]&c[a+4>>2]|0)==0:0)break;d=d+1|0;c[h>>2]=d;a=a+144|0;c[i>>2]=a;if((d|0)>=(f|0)){d=0;j=8;break}}if((j|0)==8)return d|0;c[h>>2]=d+1;c[i>>2]=a+144;j=a;return j|0}function gn(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;d=+g[a+108>>2];yI(c,+(b>>>16&255|0)*d,+(b>>>8&255|0)*d,+(b&255|0)*d,1.0);return}function hn(a){a=a|0;Rx(c[a+300>>2]|0);return a+312|0}function jn(a){a=a|0;var b=0;b=a+300|0;Qx(c[b>>2]|0,a+312|0,4,28540,4);Tx(c[b>>2]|0);return}function kn(a,b){a=a|0;b=b|0;Qx(c[a+300>>2]|0,a+312|0,b,28548,b);return}function ln(a){a=a|0;Tx(c[a+300>>2]|0);return}function mn(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a+324>>2]=b;g[a+328>>2]=c;g[a+332>>2]=d;g[a+336>>2]=e;g[a+352>>2]=b;g[a+356>>2]=c;g[a+360>>2]=d;g[a+364>>2]=e;g[a+380>>2]=b;g[a+384>>2]=c;g[a+388>>2]=d;g[a+392>>2]=e;g[a+408>>2]=b;g[a+412>>2]=c;g[a+416>>2]=d;g[a+420>>2]=e;return}function nn(a){a=a|0;Rx(c[a+304>>2]|0);return a+312|0}function on(a){a=a|0;var b=0;b=a+304|0;Qx(c[b>>2]|0,a+312|0,2,28556,2);Tx(c[b>>2]|0);return}function pn(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;i=i+32|0;d=e;b=c[b+16>>2]|0;if(!b){c[d>>2]=32887;Uv(2,63728,d);Uv(2,32902,e+8|0);Uv(2,63797,e+16|0);Jb(63799,32711,2028,32887)}else{Rx(b);i=e;return a+440|0}return 0}function qn(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;i=i+32|0;d=e;b=c[b+16>>2]|0;if(!b){c[d>>2]=32916;Uv(2,63728,d);Uv(2,32902,e+8|0);Uv(2,63797,e+16|0);Jb(63799,32711,2043,32916)}else{Qx(b,a+440|0,4,28564,4);Tx(b);i=e;return}}function rn(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;i=i+32|0;d=e;b=c[b+16>>2]|0;if(!b){c[d>>2]=32930;Uv(2,63728,d);Uv(2,32902,e+8|0);Uv(2,63797,e+16|0);Jb(63799,32711,2059,32930)}else{Qx(b,a+440|0,4,28572,4);i=e;return}}function sn(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;i=i+32|0;d=e;a=c[b+16>>2]|0;if(!a){c[d>>2]=32943;Uv(2,63728,d);Uv(2,32902,e+8|0);Uv(2,63797,e+16|0);Jb(63799,32711,2070,32943)}else{Tx(a);i=e;return}}function tn(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a+460>>2]=b;g[a+464>>2]=c;g[a+468>>2]=d;g[a+472>>2]=e;g[a+496>>2]=b;g[a+500>>2]=c;g[a+504>>2]=d;g[a+508>>2]=e;g[a+532>>2]=b;g[a+536>>2]=c;g[a+540>>2]=d;g[a+544>>2]=e;g[a+568>>2]=b;g[a+572>>2]=c;g[a+576>>2]=d;g[a+580>>2]=e;return}function un(a,b,d){a=a|0;b=b|0;d=d|0;return +(+Rn(a,c[(c[a+300>>2]|0)+20>>2]|0,b,d))}function vn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;a=a+104|0;h=c[a>>2]|0;if(!h){d=0;return d|0}Vt(h);d=Xt(c[a>>2]|0,e,b,d,f,g,0)|0;Zt(c[a>>2]|0);return d|0}function wn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+32|0;l=o+16|0;g=o+8|0;m=o;n=c[e>>2]|0;k=c[e+4>>2]|0;f=d+(k>>1)|0;if(!(k&1))e=n;else e=c[(c[f>>2]|0)+n>>2]|0;if(!(dg[e&127](f,b)|0)){i=o;return}e=c[b+208>>2]|0;if(((e|0)!=0?(h=c[e+28>>2]|0,(h|0)!=0):0)?(j=c[h+84>>2]|0,(j|0)!=0):0){c[g>>2]=n;c[g+4>>2]=k;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];wn(a,j,d,l)}e=Ry(b)|0;if(!e){i=o;return}f=m+4|0;do{c[m>>2]=n;c[f>>2]=k;c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];wn(a,e,d,l);e=Sy(e)|0}while((e|0)!=0);i=o;return}function xn(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;c[a>>2]=7356;o=0;Ja(440,a+236|0);f=o;o=0;do if(f&1){f=zc()|0;o=0;Ja(412,a+224|0);h=o;o=0;if(!(h&1)){b=f;g=9}}else{o=0;Ja(412,a+224|0);h=o;o=0;if(h&1){b=zc()|0;g=9;break}o=0;Ja(412,a+212|0);h=o;o=0;if(h&1){d=zc()|0;g=11;break}o=0;Ja(429,a+196|0);h=o;o=0;if(h&1){e=zc()|0;g=12;break}else{zu(a);return}}while(0);if((g|0)==9?(o=0,Ja(412,a+212|0),h=o,o=0,!(h&1)):0){d=b;g=11}if((g|0)==11?(o=0,Ja(429,a+196|0),h=o,o=0,!(h&1)):0){e=d;g=12}if((g|0)==12?(o=0,Ja(29,a|0),h=o,o=0,!(h&1)):0)Kc(e|0);h=zc(0)|0;Di(h)}function yn(a){a=a|0;var b=0;o=0;Ja(1,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function zn(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function An(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=i;i=i+16|0;g=f;e=c[(c[a+8>>2]|0)+48>>2]|0;h=a+20|0;d=c[h>>2]|0;h=c[h+4>>2]|0;a=(c[a+16>>2]|0)+(h>>1)|0;if(h&1)d=c[(c[a>>2]|0)+d>>2]|0;of[d&511](g,a);o=0;sb(123,b|0,e|0,g|0);h=o;o=0;if(!(h&1)){WH(g);i=f;return}d=zc()|0;o=0;Ja(412,g|0);h=o;o=0;if(h&1){h=zc(0)|0;Di(h)}else Kc(d|0)}function Bn(a,b,d,e,f,g){a=a|0;b=b|0;d=+d;e=+e;f=+f;g=+g;var h=0,i=0;if((b|0)<0)h=Em(a,Qm(a)|0)|0;else h=Em(a,b)|0;if(!h){i=-1;return i|0}b=c[h+48>>2]|0;if(!b){i=-1;return i|0}a=h+56|0;if((c[a>>2]|0)!=0?(pz(b,0),i=c[a>>2]|0,(i|0)!=0):0){tE(i);c[a>>2]=0}i=bs(d,e,f,g)|0;pz(b,i);oH(b,0.0,0.0,100.0);c[a>>2]=i;i=c[h+8>>2]|0;return i|0}function Cn(a,b){a=a|0;b=b|0;var d=0;d=Em(a,b)|0;if(!d)return;d=c[d+56>>2]|0;if(!d)return;c[a+176>>2]=b;c[a+192>>2]=d;DF(c[a+188>>2]|0,d);return}function Dn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=+e;f=+f;g=+g;var h=0,i=0,j=0,k=0;k=(b|0)<0;if(k)i=Em(a,Qm(a)|0)|0;else i=Em(a,b)|0;if(!i){k=-1;return k|0}a=c[i+48>>2]|0;if(!a){k=-1;return k|0}h=i+60|0;if((c[h>>2]|0)!=0?(rz(a,0),j=c[h>>2]|0,(j|0)!=0):0){tE(j);c[h>>2]=0}switch(d|0){case 1:{b=Lv(1.0,1.0,1.0,e)|0;break}case 2:{b=Nv(1.0,1.0,1.0,e,f,g)|0;break}default:b=Jv(1.0,1.0,1.0)|0}if(b){rz(a,b);if(k)eH(a,-.7853981852531433);c[h>>2]=b}yI(i+92|0,1.0,1.0,1.0,1.0);yI(i+108|0,.25,.25,.25,1.0);k=c[i+8>>2]|0;return k|0}function En(a,b){a=a|0;b=b|0;var d=0;if((b|0)>-1){d=Em(a,b)|0;if(!d)return;if(!(c[d+60>>2]|0))return}c[a+168>>2]=b;return}function Fn(a,b,d){a=a|0;b=b|0;d=d|0;a=c[b+60>>2]|0;if(!((d|0)==5&(a|0)!=0))return;Rv(a,+g[b+92>>2],+g[b+96>>2],+g[b+100>>2]);return}function Gn(a){a=a|0;b[a>>1]=0;return}function Hn(a){a=a|0;return}function In(a,b,d){a=a|0;b=b|0;d=d|0;a=c[a+12>>2]|0;if(!a){d=-1;return d|0}zw(AE(a,b)|0,d,1);d=0;return d|0}function Jn(a,b,d){a=a|0;b=b|0;d=d|0;a=c[a+12>>2]|0;if(!a){d=-1;return d|0}xw(AE(a,b)|0,d,1);d=0;return d|0}function Kn(a,b,d){a=a|0;b=b|0;d=+d;a=c[a+12>>2]|0;if(!a){b=-1;return b|0}uw(AE(a,b)|0,d);b=0;return b|0}function Ln(a,b,d){a=a|0;b=b|0;d=d|0;a=c[a+12>>2]|0;if(!a){d=-1;return d|0}aF(EE(a)|0,b,d);d=0;return d|0}function Mn(a,d){a=a|0;d=d|0;if((d&267386880|0)!=2097152){a=0;return a|0}d=d&1048575;if((d|0)>=(c[a+156>>2]|0)){a=0;return a|0}a=(c[a+160>>2]|0)+(d*36|0)|0;a=(b[a>>1]|0)==0?0:a;return a|0}function Nn(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;if((d&267386880|0)!=2097152){f=-1;return f|0}f=d&1048575;if((f|0)>=(c[a+156>>2]|0)){f=-1;return f|0}e=c[a+160>>2]|0;d=e+(f*36|0)|0;if((b[d>>1]|0)==0|(d|0)==0){f=-1;return f|0}b[d>>1]=0;d=e+(f*36|0)+16|0;a=c[d>>2]|0;do if(a){o=0;Ja(436,a|0);g=o;o=0;if(g&1){g=zc()|0;$5(a);Kc(g|0)}else{$5(a);c[d>>2]=0;break}}while(0);d=e+(f*36|0)+12|0;a=c[d>>2]|0;if(!a){g=0;return g|0}tE(a);c[d>>2]=0;g=0;return g|0}function On(a,d){a=a|0;d=d|0;var e=0;if((d&267386880|0)!=2097152){a=0;return a|0}e=d&1048575;if((e|0)>=(c[a+156>>2]|0)){a=0;return a|0}d=c[a+160>>2]|0;a=d+(e*36|0)|0;if((b[a>>1]|0)==0|(a|0)==0){a=0;return a|0}a=c[d+(e*36|0)+12>>2]|0;return a|0}function Pn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0;n=i;i=i+16|0;p=n;if(Qn(d,33079)|0)CE(d,33079,50050);if(Qn(d,55172)|0)CE(d,55172,50139);if(Qn(d,33096)|0)CE(d,33096,50072);pI(p);g=c[b+168>>2]|0;o=0;a:do if((g|0)<0){g=Qn(d,33130)|0;l=o;o=0;if(!(l&1)){if(g?(o=0,sb(124,d|0,33130,49994),l=o,o=0,l&1):0){l=11;break}o=0;g=cb(53,d|0,33145)|0;l=o;o=0;if(!(l&1)){if(g?(o=0,sb(124,d|0,33145,49954),l=o,o=0,l&1):0){l=11;break}o=0;g=cb(53,d|0,33162)|0;l=o;o=0;if(!(l&1))if(g?(o=0,sb(124,d|0,33162,49976),l=o,o=0,l&1):0)l=11;else l=38;else l=11}else l=11}else l=11}else{j=Em(b,g)|0;g=o;o=0;if(!(g&1)?(k=c[j+48>>2]|0,o=0,h=cb(53,d|0,33145)|0,g=o,o=0,!(g&1)):0){do if(h){o=0;g=cb(54,d|0,33145)|0;h=o;o=0;if(h&1){l=11;break a}o=0;Ja(443,g|0);h=o;o=0;if(h&1){l=11;break a}o=0;h=qa(141,28)|0;q=o;o=0;if(q&1){l=11;break a}o=0;na(135,h|0,g|0);q=o;o=0;if(q&1){d=zc()|0;$5(h);break a}else{c[h>>2]=7424;c[h+16>>2]=k;q=h+20|0;c[q>>2]=136;c[q+4>>2]=0;c[g+20>>2]=h;a[g+32>>0]=1;c[g+24>>2]=11;break}}while(0);j=j+108|0;o=0;g=cb(53,d|0,33162)|0;q=o;o=0;if(!(q&1)){if(g){o=0;h=cb(54,d|0,33162)|0;q=o;o=0;if(q&1){l=11;break}o=0;g=qa(142,k|0)|0;q=o;o=0;if(q&1){l=11;break}o=0;g=qa(143,g|0)|0;q=o;o=0;if(q&1){l=11;break}o=0;na(139,h|0,g|0);q=o;o=0;if(q&1){l=11;break}}o=0;g=cb(53,d|0,33130)|0;q=o;o=0;if(!(q&1))if(g){o=0;g=cb(54,d|0,33130)|0;q=o;o=0;if(!(q&1)?(o=0,sb(125,g|0,j|0,1),q=o,o=0,!(q&1)):0)l=38;else l=11}else l=38;else l=11}else l=11}else l=11}while(0);do if((l|0)==38){o=0;sb(126,b|0,e|0,p|0);q=o;o=0;if(!(q&1)?(o=0,m=cb(53,d|0,33175)|0,q=o,o=0,!(q&1)):0){if(m){o=0;g=cb(54,d|0,33175)|0;q=o;o=0;if(q&1){l=11;break}o=0;na(140,g|0,p|0);q=o;o=0;if(q&1){l=11;break}}o=0;g=cb(53,d|0,33190)|0;q=o;o=0;if(!(q&1)){if(g){o=0;g=cb(54,d|0,33190)|0;q=o;o=0;if(q&1){l=11;break}if(g)l=47}else{g=0;l=47}if((l|0)==47){o=0;ia(24,g|0,1.0);q=o;o=0;if(q&1){l=11;break}}o=0;g=qa(144,d|0)|0;q=o;o=0;if((((!(q&1)?(o=0,na(141,g|0,(f&4|0)==0|0),q=o,o=0,!(q&1)):0)?(o=0,na(142,g|0,(f&8|0)==0|0),q=o,o=0,!(q&1)):0)?(o=0,na(143,g|0,(f&16|0)==0|0),q=o,o=0,!(q&1)):0)?(o=0,na(144,g|0,1),q=o,o=0,!(q&1)):0){o=0;na(145,g|0,770);d=o;o=0;d=d&1;if(!(f&32)){if(d){l=11;break}o=0;na(146,g|0,771);q=o;o=0;if(q&1){l=11;break}uI(p);i=n;return}else{if(d){l=11;break}o=0;na(146,g|0,1);q=o;o=0;if(q&1){l=11;break}uI(p);i=n;return}}else l=11}else l=11}else l=11}while(0);if((l|0)==11)d=zc()|0;o=0;Ja(413,p|0);q=o;o=0;if(q&1){q=zc(0)|0;Di(q)}else Kc(d|0)}function Qn(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=cw(a)|0;if(!c){b=0;return b|0}else f=0;a:while(1){d=dw(a,f)|0;e=tG(d)|0;if(e){g=0;do{if(Is(Vz(uG(d,g)|0)|0,b)|0){c=1;d=6;break a}g=g+1|0}while(g>>>0<e>>>0)}f=f+1|0;if(f>>>0>=c>>>0){c=0;d=6;break}}if((d|0)==6)return c|0;return 0}function Rn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0;b=EE(b)|0;switch(c|0){case 0:{cF(b,1);dF(b,0);e=1.0;return +e}case 2:case 1:{cF(b,770);dF(b,771);e=1.0;return +e}case 5:{cF(b,770);dF(b,1);e=+(d|0)*+g[a+108>>2];return +e}case 6:{cF(b,775);dF(b,0);e=+(d|0)*+g[a+108>>2];return +e}default:{cF(b,770);dF(b,771);e=+(d|0)*+g[a+108>>2];return +e}}return 0.0}function Sn(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;f=c[a+156>>2]|0;if((f|0)<=0){e=-1;return e|0}g=0;h=c[a+160>>2]|0;while(1){if(!(b[h>>1]|0)){i=h;a=g;break}g=g+1|0;if((g|0)>=(f|0)){a=-1;j=7;break}else h=h+36|0}if((j|0)==7)return a|0;a=a|2097152;f=h+4|0;c[f>>2]=0;b[h+2>>1]=0;g=h+12|0;c[g>>2]=0;c[h+16>>2]=0;b[i>>1]=1;c[h+8>>2]=a;j=h+20|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;if(!h){e=-1;return e|0}c[g>>2]=d;c[f>>2]=e;e=a;return e|0}function Tn(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;s=i;i=i+48|0;q=s+16|0;r=s;f=c[a+156>>2]|0;if((f|0)<=0){r=-1;i=s;return r|0}h=0;j=c[a+160>>2]|0;while(1){if(!(b[j>>1]|0)){f=j;p=j;break}h=h+1|0;if((h|0)>=(f|0)){f=-1;k=10;break}else j=j+36|0}if((k|0)==10){i=s;return f|0}l=p+4|0;c[l>>2]=0;b[p+2>>1]=0;m=p+12|0;c[m>>2]=0;n=p+16|0;c[n>>2]=0;b[f>>1]=1;k=p+8|0;c[k>>2]=h|2097152;j=p+20|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;if(!p){r=-1;i=s;return r|0}h=Un(a,d,e)|0;if(!h){r=-1;i=s;return r|0}QI(q,1,3);QI(q+8|0,8,2);QI(q+16|0,3,4);KI(r,q,3);o=0;f=oa(4,r|0,5,h|0,1,16,256)|0;q=o;o=0;if(!(q&1)){LI(r);c[n>>2]=f;c[m>>2]=h;c[l>>2]=1;q=c[a+112>>2]|0;c[j>>2]=q;r=c[a+116>>2]|0;c[p+24>>2]=r;g[p+28>>2]=1.0/+(q|0);g[p+32>>2]=1.0/+(r|0);r=c[k>>2]|0;i=s;return r|0}f=zc()|0;o=0;Ja(438,r|0);s=o;o=0;if(s&1){s=zc(0)|0;Di(s)}else Kc(f|0);return 0}function Un(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;k=i;i=i+32|0;j=k+24|0;h=k+16|0;g=k+8|0;d=k;f=zG(b,0)|0;if(!f){c[d>>2]=b;Pp(33206,d);n=0;i=k;return n|0}c[a+112>>2]=GG(f)|0;c[a+116>>2]=HG(f)|0;b=a+308|0;e=Ks(c[b>>2]|0)|0;if(!e){c[g>>2]=33229;Uv(2,63728,g);Uv(2,51887,h);Uv(2,63797,j);Jb(63799,33247,379,33229)}else m=0;while(1){d=Js(c[b>>2]|0,m)|0;if((d|0)!=0?(_s(d)|0)==35678:0){l=d;break}m=m+1|0;if(m>>>0>=e>>>0){n=7;break}}if((n|0)==7){c[g>>2]=33229;Uv(2,63728,g);Uv(2,51887,h);Uv(2,63797,j);Jb(63799,33247,379,33229)}n=ew(c[b>>2]|0)|0;m=LG(f)|0;Bw(AE(n,Zs(l)|0)|0,m);Aw(AE(n,51944)|0,a+236|0);a=EE(n)|0;eF(a,0);fF(a,0);gF(a,0);bF(a,1);cF(a,770);dF(a,771);tE(f);i=k;return n|0}function Vn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return fw(b,c,d)|0}function Wn(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if(!(c&1))d=fw(33342,33367,33327)|0;else d=fw(33265,33296,33327)|0;if(!d){a=0;return a|0}Pn(a,d,b,c);a=d;return a|0}function Xn(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if(!(c&1))d=fw(33456,33482,33327)|0;else d=fw(33392,33424,33327)|0;if(!d){a=0;return a|0}Pn(a,d,-1,c);Cw(AE(d,33508)|0,b,(c&2|0)==0)|0;a=d;return a|0}function Yn(a){a=a|0;return}function Zn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,l=0.0,m=0.0;f=i;i=i+16|0;e=f;a=c[a+12>>2]|0;if(!a){d=-1;i=f;return d|0}do switch(b|0){case 0:{sC(a,+g[d>>2]!=0.0);d=0;i=f;return d|0}case 1:{b=c[a+28>>2]|0;e=b+260|0;a=c[e>>2]|0;c[b+224>>2]=c[d>>2];d=c[d+4>>2]|0;c[e>>2]=a+2;c[b+228>>2]=d;d=0;i=f;return d|0}case 2:{vV(c[a+28>>2]|0,+g[d>>2],+g[d+4>>2]);d=0;i=f;return d|0}case 3:{hC(a,+g[d>>2]!=0.0);d=0;i=f;return d|0}case 4:{e=c[a+28>>2]|0;h=c[d>>2]|0;b=c[d+4>>2]|0;a=c[d+8>>2]|0;c[e+164>>2]=h;c[e+168>>2]=b;c[e+172>>2]=a;g[e+176>>2]=0.0;c[e+180>>2]=(c[k>>2]=h,+g[k>>2])!=1.0|(c[k>>2]=b,+g[k>>2])!=1.0?1:(c[k>>2]=a,+g[k>>2])!=1.0&1;h=0;i=f;return h|0}case 5:{h=c[a+28>>2]|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];g[e+12>>2]=0.0;zV(h,e);h=0;i=f;return h|0}case 6:{h=c[a+28>>2]|0;e=c[d>>2]|0;b=c[d+4>>2]|0;d=c[d+8>>2]|0;c[h+348>>2]=e;c[h+352>>2]=b;c[h+356>>2]=d;g[h+360>>2]=0.0;j=+g[h+344>>2];m=(c[k>>2]=e,+g[k>>2])*j;l=(c[k>>2]=b,+g[k>>2])*j;j=j*(c[k>>2]=d,+g[k>>2]);g[h+560>>2]=m;g[h+564>>2]=l;g[h+568>>2]=j;g[h+572>>2]=0.0;h=0;i=f;return h|0}case 7:{h=c[a+28>>2]|0;e=c[d>>2]|0;b=c[d+4>>2]|0;d=c[d+8>>2]|0;a=h+260|0;c[a>>2]=(c[a>>2]|0)+1;c[h+544>>2]=e;c[h+548>>2]=b;c[h+552>>2]=d;g[h+556>>2]=0.0;h=0;i=f;return h|0}case 8:{h=c[a+28>>2]|0;e=c[d>>2]|0;b=c[d+4>>2]|0;d=c[d+8>>2]|0;a=h+260|0;c[a>>2]=(c[a>>2]|0)+1;c[h+328>>2]=e;c[h+332>>2]=b;c[h+336>>2]=d;g[h+340>>2]=0.0;h=0;i=f;return h|0}case 9:{h=c[a+28>>2]|0;e=c[d>>2]|0;b=c[d+4>>2]|0;d=c[d+8>>2]|0;a=h+260|0;c[a>>2]=(c[a>>2]|0)+1;c[h+312>>2]=e;c[h+316>>2]=b;c[h+320>>2]=d;g[h+324>>2]=0.0;h=0;i=f;return h|0}default:{h=-1;i=f;return h|0}}while(0);return 0}function _n(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+32|0;g=f;UA(g,d,XH()|0,0);o=0;b=pb(31,b|0,0,g|0,e|0)|0;d=o;o=0;if(!(d&1)){TA(g);c[a+12>>2]=DA(b)|0;i=f;return}b=zc()|0;o=0;Ja(444,g|0);g=o;o=0;if(g&1){g=zc(0)|0;Di(g)}else Kc(b|0)}function $n(a,b){a=a|0;b=b|0;b=Em(a,b)|0;if(!b){a=0;return a|0}a=c[b+44>>2]|0;return a|0}function ao(a,d,e,f){a=a|0;d=d|0;e=+e;f=+f;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;s=i;i=i+112|0;n=s+80|0;v=s+16|0;r=s;l=c[d+48>>2]|0;if(!l){w=0;i=s;return w|0}k=d+28|0;if((c[k>>2]|0)<0){w=0;i=s;return w|0}p=d+44|0;a=c[p>>2]|0;if(a){$5(a);c[p>>2]=0}m=Z5(16)|0;b[m>>1]=0;eo(v);g[v>>2]=e;g[v+4>>2]=f;a=v+8|0;g[a>>2]=.5;h=v+12|0;g[h>>2]=.10000000149011612;j=v+16|0;g[j>>2]=.5;a:do switch(c[k>>2]|0){case 1:{o=0;yb(56,m|0,l|0,d+64|0,v|0);w=o;o=0;if(w&1)w=7;else w=20;break}case 3:case 2:{g[a>>2]=.75;g[h>>2]=.02500000037252903;g[j>>2]=.1599999964237213;o=0;yb(56,m|0,l|0,d+64|0,v|0);w=o;o=0;if(w&1)w=7;else w=20;break}case 0:{o=0;Ja(441,r|0);d=o;o=0;if(!(d&1)){o=0;a=qa(140,l|0)|0;d=o;o=0;do if(!(d&1)?(c[r>>2]=c[a>>2],c[r+4>>2]=c[a+4>>2],c[r+8>>2]=c[a+8>>2],c[r+12>>2]=c[a+12>>2],o=0,xa(2,n|0,+(+g[r+12>>2]),r|0,0),d=o,o=0,!(d&1)):0){o=0;h=pb(31,l|0,0,n|0,v|0)|0;d=o;o=0;if(d&1){a=zc()|0;o=0;Ja(444,n|0);d=o;o=0;if(!(d&1))break;w=zc(0)|0;Di(w)}o=0;Ja(444,n|0);w=o;o=0;if(!(w&1)?(o=0,q=qa(145,h|0)|0,w=o,o=0,!(w&1)):0){c[m+12>>2]=q;o=0;Ja(442,r|0);w=o;o=0;if(w&1){w=7;break a}else{w=20;break a}}else w=18}else w=18;while(0);if((w|0)==18)a=zc()|0;o=0;Ja(442,r|0);t=o;o=0;if(!(t&1))w=29}else w=7;break}default:{a=0;w=21}}while(0);if((w|0)==7){a=zc()|0;w=29}else if((w|0)==20){c[p>>2]=m;a=m;w=21}if((w|0)==21){o=0;Ja(412,v+48|0);u=o;o=0;do if(u&1){a=zc()|0;o=0;Ja(412,v+36|0);u=o;o=0;if(u&1){u=zc(0)|0;Di(u)}else t=a}else{o=0;Ja(412,v+36|0);u=o;o=0;if(u&1){t=zc()|0;break}WH(v+24|0);w=a;i=s;return w|0}while(0);o=0;Ja(412,v+24|0);v=o;o=0;if(v&1){v=zc(0)|0;Di(v)}else Kc(t|0)}b:do if((w|0)==29){o=0;Ja(412,v+48|0);w=o;o=0;do if(w&1){a=zc(0)|0;o=0;Ja(412,v+36|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}else u=a}else{o=0;Ja(412,v+36|0);w=o;o=0;if(w&1){u=zc(0)|0;break}o=0;Ja(412,v+24|0);w=o;o=0;if(w&1)break b;Kc(a|0)}while(0);o=0;Ja(412,v+24|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}w=u;Di(w)}while(0);w=zc(0)|0;Di(w);return 0}function bo(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;b=Em(a,b)|0;if(!b){a=-1;return a|0}a=((ao(0,b,c,d)|0)==0)<<31>>31;return a|0}function co(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;b=Em(a,b)|0;a:do if(((b|0)!=0?(f=c[b+44>>2]|0,(f|0)!=0):0)?(g=c[f+12>>2]|0,(g|0)!=0):0)switch(d|0){case 0:{oC(g,e,0);b=0;break a}case 1:{pC(g,e,0);b=0;break a}case 2:{qC(g,e);b=0;break a}case 3:{rC(g,e);b=0;break a}default:{b=-1;break a}}else b=-1;while(0);return b|0}function eo(b){b=b|0;var d=0,e=0,f=0,h=0,i=0;g[b>>2]=0.0;g[b+4>>2]=.5;h=b+8|0;f=b+24|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;a[h+12>>0]=0;UH(f,YH()|0);h=b+36|0;o=0;d=qb(13)|0;i=o;o=0;if(!(i&1)?(o=0,na(147,h|0,d|0),i=o,o=0,!(i&1)):0){o=0;d=qb(13)|0;i=o;o=0;if(!(i&1)?(o=0,na(147,b+48|0,d|0),i=o,o=0,!(i&1)):0)return;d=zc()|0;o=0;Ja(412,h|0);i=o;o=0;if(i&1){i=zc(0)|0;Di(i)}else e=d}else e=zc()|0;o=0;Ja(412,f|0);i=o;o=0;if(i&1){i=zc(0)|0;Di(i)}else Kc(e|0)}function fo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[1859]=0;c[1860]=0;bm(10,0);bm(11,0);c[1868]=0;c[1869]=0;c[1870]=b;c[1871]=d;g[1872]=1.0;g[1873]=1.0;e=152;a=e+128|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(a|0));return}function go(a,b,c){a=a|0;b=b|0;c=c|0;bm(31,a);bm(32,b);bm(33,c);return}function ho(){if(!(c[1869]|0))return 0;if(c[1883]|0)fD();c[1869]=0;return 0}function io(a){a=a|0;c[1868]=a;M9(33525,0,254)|0;c[1874]=18;return}function jo(a,b,d){a=a|0;b=b|0;d=d|0;I8(33525,a,254)|0;c[1874]=b;return 0}function ko(a){a=a|0;c[1875]=a;return}function lo(a){a=a|0;var b=0;if(!(c[a>>2]|0))return;a=a+280|0;b=c[a>>2]|0;if((b|0)==-1)return;Nn(c[1882]|0,b)|0;c[a>>2]=-1;return}function mo(){return c[1870]|0}function no(){return c[1871]|0}function oo(a){a=a|0;var b=0;a=(c[1876]|0)==0?0:256;a=a|(No(1104)|0)&1;b=No(1106)|0;a=b?a|2:a;b=No(1103)|0;a=b?a|4:a;b=No(1105)|0;a=b?a|8:a;b=No(32)|0;a=b?a|16:a;b=No(13)|0;a=b?a|32:a;b=No(1248)|0;a=b?a|64:a;b=No(27)|0;a=b?a|128:a;b=No(9)|0;return (b?a|1024:a)|0}function po(a,b){a=a|0;b=b|0;if(!a){b=-1;return b|0}if((c[a+28>>2]|0)!=2){b=rd(4)|0;c[b>>2]=21;Te(b|0,8,0)}a=(c[1869]|0)==0;if(b&1){if(a){b=0;return b|0}if(c[1883]|0)fD();c[1869]=0;b=0;return b|0}if(!a){if(c[1883]|0)fD();c[1869]=0}a=c[1882]|0;if(a)Lu(a);c[1869]=1;b=0;return b|0}function qo(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function ro(a){a=a|0;return 0}function so(a,b){a=a|0;b=b|0;b=Tn(c[1882]|0,b,0)|0;c[a+280>>2]=b;if((b|0)<0){a=b;return a|0}b=Mn(c[1882]|0,b)|0;c[a+4>>2]=c[b+20>>2];c[a+8>>2]=c[b+24>>2];a=0;return a|0}
function Ag(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function Bg(){return i|0}function Cg(a){a=a|0;i=a}function Dg(a,b){a=a|0;b=b|0;i=a;j=b}function Eg(a,b){a=a|0;b=b|0;if(!o){o=a;p=b}}function Fg(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function Gg(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function Hg(a){a=a|0;D=a}function Ig(){return D|0}function Jg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+256|0;g=h;c[958]=0;d=c[b>>2]|0;a:do if((d|0)<980247917)if((d|0)<978145348)switch(d|0){case 978142541:{e=6;break a}default:break a}else switch(d|0){case 978145348:{e=2;break a}default:break a}else if((d|0)<980250724)switch(d|0){case 980247917:{e=6;break a}default:break a}else switch(d|0){case 980250724:{e=2;break a}default:break a}while(0);if((e|0)==2){d=b+4|0;e=xp(d,58)|0;f=c[966]|0;if(f)a9(f);c[962]=0;if(e){a[e>>0]=0;C8(g,e+1|0)|0;Lg(d,0,-1,-1)|0;C8(b,g)|0}}else if((e|0)==6)c[958]=1;if(c[958]|0){c[960]=0;g=(c[961]|0)<0?0:3836;i=h;return g|0}if((c[962]|0)!=0?(Kg(b)|0)==0:0){g=c[963]|0;i=h;return g|0}g=D7(b,43603)|0;c[963]=g;i=h;return g|0}function Kg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+256|0;f=h;d=0;while(1){e=a[b+d>>0]|0;a[f+d>>0]=V6(e<<24>>24)|0;if(!(e<<24>>24))break;else d=d+1|0}d=c[966]|0;if(!d){g=-1;i=h;return g|0}b=c[967]|0;if((b|0)<=0){g=-1;i=h;return g|0}e=0;d=d+16|0;while(1){if(!(B8(d,f)|0)){f=e;break}e=e+1|0;if((e|0)>=(b|0)){d=-1;g=11;break}else d=d+32|0}if((g|0)==11){i=h;return d|0}e=31054;b=e+32|0;do{a[e>>0]=a[d>>0]|0;e=e+1|0;d=d+1|0}while((e|0)<(b|0));if((f|0)==-1){g=-1;i=h;return g|0}c[968]=c[7770];c[969]=c[7769];d=D7(31187,43603)|0;c[963]=d;if(!d){g=-1;i=h;return g|0}K7(d,(c[964]|0)+(c[969]|0)|0,0)|0;g=0;i=h;return g|0}function Lg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;k=i;i=i+256|0;j=k;c[964]=0;c[962]=0;c[958]=0;c[965]=d;c[966]=0;C8(j,b)|0;b=D7(j,43603)|0;c[963]=b;if(!b){j=-1;i=k;return j|0}h=(d|0)>0;if(h){K7(b,d,0)|0;b=c[963]|0}H7(31054,16,1,b)|0;c[964]=(c[7764]|0)+d;c[967]=c[7765];y7(c[963]|0)|0;a[31058]=0;if(B8(31054,31182)|0){j=-1;i=k;return j|0}g=(c[7766]|0)+16+(c[967]<<5)|0;b=$8(g)|0;c[966]=b;if(!b){j=-1;i=k;return j|0}b=D7(j,43603)|0;c[963]=b;if(h){K7(b,d,0)|0;b=c[963]|0}H7(c[966]|0,g,1,b)|0;y7(c[963]|0)|0;f=(f>>>0)/117440512|0;if((e|0)!=-1){b=D7(j,43603)|0;c[963]=b;if(h){K7(b,d,0)|0;b=c[963]|0}b=B7(b)|0;if((b|0)<0)b=0;else{g=b;b=0;do{b=b+f+g|0;g=B7(c[963]|0)|0}while((g|0)>=0);b=b&65535}y7(c[963]|0)|0;if((b|0)!=(e|0)){j=-2;i=k;return j|0}}c[962]=1;C8(31187,j)|0;j=0;i=k;return j|0}function Mg(){var a=0;a=c[966]|0;if(a)a9(a);c[962]=0;return}function Ng(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+256|0;k=l;c[958]=0;g=c[b>>2]|0;a:do if((g|0)<980247917)if((g|0)<978145348)switch(g|0){case 978142541:{h=6;break a}default:break a}else switch(g|0){case 978145348:{h=2;break a}default:break a}else if((g|0)<980250724)switch(g|0){case 980247917:{h=6;break a}default:break a}else switch(g|0){case 980250724:{h=2;break a}default:break a}while(0);if((h|0)==2){g=b+4|0;h=xp(g,58)|0;j=c[966]|0;if(j)a9(j);c[962]=0;if(h){a[h>>0]=0;C8(k,h+1|0)|0;Lg(g,0,-1,-1)|0;C8(b,k)|0}}else if((h|0)==6)c[958]=1;h=(f|0)<0?0:f;if(c[958]|0){Jg(b)|0;c[960]=h;if(c[958]|0){g=c[961]|0;g=(h+e|0)<(g|0)?e:g-h|0;if((g|0)>0){K9(d|0,(c[959]|0)+h|0,g|0)|0;c[960]=(c[960]|0)+g}}else g=H7(d,1,e,0)|0;if(c[958]|0){d=g;i=l;return d|0}y7(c[963]|0)|0;d=g;i=l;return d|0}if((c[962]|0)!=0?(Kg(b)|0)==0:0){g=c[968]|0;y7(c[963]|0)|0;j=D7(31187,43603)|0;if(!j){d=-1;i=l;return d|0}K7(j,(c[964]|0)+h+(c[969]|0)|0,0)|0;g=(g|0)>(e|0)?e:g;if(c[958]|0){h=c[960]|0;e=c[961]|0;g=(h+g|0)<(e|0)?g:e-h|0;if((g|0)>0){K9(d|0,(c[959]|0)+h|0,g|0)|0;c[960]=(c[960]|0)+g}}else g=H7(d,1,g,j)|0;y7(j)|0;d=g;i=l;return d|0}g=D7(b,43603)|0;if(!g){d=-1;i=l;return d|0}if((f|0)>-1)K7(g,h,0)|0;d=H7(d,1,e,g)|0;y7(g)|0;i=l;return d|0}function Og(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+256|0;g=h;c[958]=0;d=c[b>>2]|0;a:do if((d|0)<980247917)if((d|0)<978145348)switch(d|0){case 978142541:{e=6;break a}default:break a}else switch(d|0){case 978145348:{e=2;break a}default:break a}else if((d|0)<980250724)switch(d|0){case 980247917:{e=6;break a}default:break a}else switch(d|0){case 980250724:{e=2;break a}default:break a}while(0);if((e|0)==2){d=b+4|0;e=xp(d,58)|0;f=c[966]|0;if(f)a9(f);c[962]=0;if(e){a[e>>0]=0;C8(g,e+1|0)|0;Lg(d,0,-1,-1)|0;C8(b,g)|0}}else if((e|0)==6)c[958]=1;if(c[958]|0){g=c[961]|0;i=h;return g|0}if((c[962]|0)!=0?(Kg(b)|0)==0:0){if(!(c[958]|0))y7(c[963]|0)|0;g=c[968]|0;i=h;return g|0}d=D7(b,43603)|0;if(!d){g=-1;i=h;return g|0}K7(d,0,2)|0;g=N7(d)|0;y7(d)|0;i=h;return g|0}function Pg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+256|0;g=h;c[958]=0;d=c[b>>2]|0;a:do if((d|0)<980247917)if((d|0)<978145348)switch(d|0){case 978142541:{e=6;break a}default:break a}else switch(d|0){case 978145348:{e=2;break a}default:break a}else if((d|0)<980250724)switch(d|0){case 980247917:{e=6;break a}default:break a}else switch(d|0){case 980250724:{e=2;break a}default:break a}while(0);if((e|0)==2){d=b+4|0;e=xp(d,58)|0;f=c[966]|0;if(f)a9(f);c[962]=0;if(e){a[e>>0]=0;C8(g,e+1|0)|0;Lg(d,0,-1,-1)|0;C8(b,g)|0}}else if((e|0)==6)c[958]=1;if(c[958]|0){g=2;i=h;return g|0}if((c[962]|0)!=0?(Kg(b)|0)==0:0){if(c[958]|0){g=1;i=h;return g|0}y7(c[963]|0)|0;g=1;i=h;return g|0}d=D7(b,43603)|0;if(!d){g=-1;i=h;return g|0}y7(d)|0;g=0;i=h;return g|0}function Qg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+256|0;h=k;c[958]=0;e=c[b>>2]|0;a:do if((e|0)<980247917)if((e|0)<978145348)switch(e|0){case 978142541:{f=6;break a}default:break a}else switch(e|0){case 978145348:{f=2;break a}default:break a}else if((e|0)<980250724)switch(e|0){case 980247917:{f=6;break a}default:break a}else switch(e|0){case 980250724:{f=2;break a}default:break a}while(0);if((f|0)==2){e=b+4|0;f=xp(e,58)|0;g=c[966]|0;if(g)a9(g);c[962]=0;if(f){a[f>>0]=0;C8(h,f+1|0)|0;Lg(e,0,-1,-1)|0;C8(b,h)|0}}else if((f|0)==6)c[958]=1;e=Og(b)|0;if((e|0)<0){j=1;i=k;return j|0}j=D7(d,37124)|0;if(!j){j=1;i=k;return j|0}d=Jg(b)|0;b=$8(32768)|0;b:do if(!e)e=0;else while(1){g=(e|0)<32768?e:32768;if(c[958]|0){f=c[960]|0;h=c[961]|0;h=(f+g|0)<(h|0)?g:h-f|0;if((h|0)>0){K9(b|0,(c[959]|0)+f|0,h|0)|0;c[960]=f+h}}else H7(b,1,g,d)|0;if((P7(b,1,g,j)|0)<(g|0)){e=1;break b}if((e|0)==(g|0)){e=0;break}else e=e-g|0}while(0);if(!(c[958]|0))y7(c[963]|0)|0;y7(j)|0;a9(b);j=e;i=k;return j|0}function Rg(a,b){a=a|0;b=b|0;c[959]=a;c[960]=0;c[961]=b;return}function Sg(b){b=b|0;var c=0,d=0;c=Og(b)|0;if((c|0)<0){b=0;return b|0}d=tp(c+1|0)|0;Ng(b,d,c,0)|0;a[d+c>>0]=0;b=d;return b|0}function Tg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0,f=0,h=0.0,i=0.0,j=0.0;e=b+4|0;i=+g[c+8>>2];j=+g[b+8>>2];f=c+4|0;g[a>>2]=+g[e>>2]*i-j*+g[f>>2];d=+g[c>>2];h=+g[b>>2];g[a+4>>2]=j*d-h*i;g[a+8>>2]=h*+g[f>>2]-+g[e>>2]*d;return}function Ug(a,b){a=a|0;b=b|0;return +(+g[a>>2]*+g[b>>2]+ +g[a+4>>2]*+g[b+4>>2]+ +g[a+8>>2]*+g[b+8>>2])}function Vg(a){a=a|0;var b=0.0,c=0,d=0.0,e=0,f=0.0,h=0.0;b=+g[a>>2];c=a+4|0;d=+g[c>>2];e=a+8|0;f=+g[e>>2];h=+P(+(b*b+d*d+f*f));if(h<9.999999747378752e-006){g[a>>2]=1.0;g[c>>2]=0.0;h=0.0;g[e>>2]=h;return}else{h=1.0/h;g[a>>2]=b*h;g[c>>2]=h*d;h=h*f;g[e>>2]=h;return}}function Wg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0;e=+g[b>>2]-+g[c>>2];f=+g[b+4>>2]-+g[c+4>>2];d=+g[b+8>>2]-+g[c+8>>2];g[a+4>>2]=-+X(+e,+d);g[a>>2]=-+X(+f,+(+P(+(e*e+d*d))));g[a+8>>2]=0.0;g[a+12>>2]=0.0;return}function Xg(a){a=a|0;M9(a|0,0,888)|0;zh(a);Oh();c[a+8>>2]=0;c[a+892>>2]=0;c[a+888>>2]=0;return}function Yg(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0;Yh();g=a+8|0;if(!(c[g>>2]|0)){Zh();return}h=a+44|0;d=c[h>>2]|0;if(d){f=a+896|0;if((c[f>>2]|0)>0){e=0;do{d=d+(e*48|0)|0;Kf[c[(c[6908>>2]|0)+((b[d>>1]<<16>>16)*140|0)+52>>2]&1023](d);e=e+1|0;d=c[h>>2]|0}while((e|0)<(c[f>>2]|0));if(d)i=6}else i=6;if((i|0)==6)a6(d);c[h>>2]=0}c[g>>2]=0;d=a+892|0;e=c[d>>2]|0;if(!e){Zh();return}up(e);c[d>>2]=0;Zh();return}function Zg(b,d){b=b|0;d=d|0;c[b+888>>2]=(a[d>>0]|0)==0?0:d;return}function _g(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;r=i;i=i+512|0;m=r;q=e+8|0;if(c[q>>2]|0){k=e+44|0;g=c[k>>2]|0;if(g){j=e+896|0;if((c[j>>2]|0)>0){h=0;do{g=g+(h*48|0)|0;Kf[c[(c[6908>>2]|0)+((b[g>>1]<<16>>16)*140|0)+52>>2]&1023](g);h=h+1|0;g=c[k>>2]|0}while((h|0)<(c[j>>2]|0));if(g)l=6}else l=6;if((l|0)==6)a6(g);c[k>>2]=0}c[q>>2]=0;g=e+892|0;h=c[g>>2]|0;if(h){up(h);c[g>>2]=0}}c[e+908>>2]=0;h=(f|0)!=0;if(h)Lg(63688,f,c[e+900>>2]|0,c[e+904>>2]|0)|0;else Lg(31443,0,-1,-1)|0;g=c[e+888>>2]|0;if(!g){a[m>>0]=83;a[m+1>>0]=84;a[m+2>>0]=65;a[m+3>>0]=82;a[m+4>>0]=84;a[m+5>>0]=46;a[m+6>>0]=65;a[m+7>>0]=88;a[m+8>>0]=0;if(h?(Pg(m)|0)!=1:0){q=-1;i=r;return q|0}}else C8(m,g)|0;n=Sg(m)|0;if(!n){q=-1;i=r;return q|0}c[e+892>>2]=n;if((((a[n>>0]|0)==72?(a[n+1>>0]|0)==83:0)?(a[n+2>>0]|0)==80:0)?(a[n+3>>0]|0)==51:0){o=e+896|0;c[o>>2]=c[n+8>>2];c[e>>2]=n;g=n+(c[n+16>>2]|0)|0;h=c[n+20>>2]|0;if(h){m=$8(h)|0;K9(m|0,g|0,h|0)|0;g=m}c[q>>2]=g;c[e+12>>2]=n+(c[n+24>>2]|0);g=n+(c[n+32>>2]|0)|0;h=c[n+36>>2]|0;if(h){m=$8(h)|0;K9(m|0,g|0,h|0)|0;g=m}c[e+20>>2]=g;g=n+(c[n+40>>2]|0)|0;h=c[n+44>>2]|0;if(h){m=$8(h)|0;K9(m|0,g|0,h|0)|0;g=m}c[e+16>>2]=g;g=n+(c[n+48>>2]|0)|0;k=n+52|0;l=(c[k>>2]|0)>>>4;if(l){f=l<<4;m=$8(f)|0;h=m;j=0;while(1){t=g+4|0;t=d[t>>0]|d[t+1>>0]<<8|d[t+2>>0]<<16|d[t+3>>0]<<24;s=g+12|0;s=d[s>>0]|d[s+1>>0]<<8|d[s+2>>0]<<16|d[s+3>>0]<<24;c[h>>2]=d[g>>0]|d[g+1>>0]<<8|d[g+2>>0]<<16|d[g+3>>0]<<24;c[h+4>>2]=t;c[h+12>>2]=s;c[h+8>>2]=0;j=j+1|0;if((j|0)==(l|0))break;else{g=g+16|0;h=h+16|0}}c[k>>2]=f;g=m}c[e+832>>2]=g;g=n+(c[n+64>>2]|0)|0;h=c[n+68>>2]|0;if(h){t=$8(h)|0;K9(t|0,g|0,h|0)|0;g=t}c[e+836>>2]=g;g=n+(c[n+56>>2]|0)|0;k=n+60|0;t=c[k>>2]|0;l=(t>>>0)/28|0;if(t>>>0>=28){f=l*28|0;m=$8(f)|0;h=m;j=0;while(1){y=g+2|0;y=d[y>>0]|d[y+1>>0]<<8;x=g+4|0;x=d[x>>0]|d[x+1>>0]<<8|d[x+2>>0]<<16|d[x+3>>0]<<24;w=g+8|0;w=d[w>>0]|d[w+1>>0]<<8|d[w+2>>0]<<16|d[w+3>>0]<<24;v=g+12|0;v=d[v>>0]|d[v+1>>0]<<8|d[v+2>>0]<<16|d[v+3>>0]<<24;u=g+16|0;u=d[u>>0]|d[u+1>>0]<<8|d[u+2>>0]<<16|d[u+3>>0]<<24;s=g+20|0;s=d[s>>0]|d[s+1>>0]<<8|d[s+2>>0]<<16|d[s+3>>0]<<24;t=g+24|0;t=d[t>>0]|d[t+1>>0]<<8|d[t+2>>0]<<16|d[t+3>>0]<<24;b[h>>1]=d[g>>0]|d[g+1>>0]<<8;b[h+2>>1]=y;c[h+4>>2]=x;c[h+8>>2]=w;c[h+12>>2]=v;c[h+16>>2]=u;c[h+20>>2]=s;c[h+24>>2]=t;j=j+1|0;if((j|0)>=(l|0))break;else{g=g+28|0;h=h+28|0}}c[k>>2]=f;g=m}c[e+840>>2]=g;Yi(b[n+86>>1]|0);Bh(e);h=e+44|0;c[h>>2]=0;g=c[o>>2]|0;if(((g|0)!=0?(p=_5(g>>>0>89478485?-1:g*48|0)|0,c[h>>2]=p,(g|0)>0):0)?(b[p+2>>1]=-1,b[p>>1]=4,dj(p,4),(c[o>>2]|0)>1):0){g=1;do{x=c[h>>2]|0;y=x+(g*48|0)|0;b[x+(g*48|0)+2>>1]=-1;b[y>>1]=4;dj(y,4);g=g+1|0}while((g|0)<(c[o>>2]|0))}Dh(c[q>>2]|0);Ih()|0;y=0;i=r;return y|0}up(n);y=-1;i=r;return y|0}function $g(a,b,d){a=a|0;b=b|0;d=d|0;c[a+900>>2]=b;c[a+904>>2]=d;return}function ah(){var a=0,d=0,f=0,g=0;a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;f=b[a>>1]|0;b[14216]=f;g=f&65535;c[974]=g&24576;c[975]=g&4095;if(f<<16>>16<0){c[976]=(e[a+4>>1]|0)<<16|(e[d>>1]|0);c[972]=a+6;return}else{c[972]=a+4;c[976]=e[d>>1];return}}function bh(a){a=a|0;var b=0;if(!a){c[(c[977]|0)+236>>2]=4;return}else{b=rd(4)|0;c[b>>2]=a;Te(b|0,8,0)}}function ch(a,d){a=a|0;d=d|0;var f=0,g=0,h=0,i=0;a:do switch(c[d>>2]|0){case -3:{f=c[a>>2]|0;c[f+40>>2]=c[a+4>>2];if((c[975]|0)==0&(c[976]|0)==40){d=rd(4)|0;c[d>>2]=34;Te(d|0,8,0)}break}case -6:{c[d>>2]=2;d=c[a>>2]|0;return d|0}case 7:{c[d>>2]=1;d=a;return d|0}case -2:{f=c[a>>2]|0;if(!(b[f+36>>1]&16)){ci(f);break a}g=b[f>>1]|0;c[d>>2]=g;c[f+40>>2]=0;b[f+38>>1]=0;if(!((c[975]|0)==0&(c[976]|0)==40)){d=rf[c[(c[6908>>2]|0)+(g*140|0)+28>>2]&255](f)|0;return d|0}g=c[972]|0;c[973]=g;a=g+2|0;c[972]=a;h=b[g>>1]|0;b[14216]=h;i=h&65535;c[974]=i&24576;c[975]=i&4095;if(h<<16>>16<0){c[976]=e[g+4>>1]<<16|e[a>>1];c[972]=g+6}else{c[972]=g+4;c[976]=e[a>>1]}g=dg[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+32>>2]&127](f,d)|0;f=c[972]|0;c[973]=f;a=f+2|0;c[972]=a;i=b[f>>1]|0;b[14216]=i;h=i&65535;c[974]=h&24576;c[975]=h&4095;if(i<<16>>16<0){c[976]=e[f+4>>1]<<16|e[a>>1];c[972]=f+6;i=g;return i|0}else{c[972]=f+4;c[976]=e[a>>1];i=g;return i|0}}case -1:{if(!(b[a+36>>1]&16)){ci(a);f=a;break a}f=b[a>>1]|0;c[d>>2]=f;c[a+40>>2]=0;b[a+38>>1]=0;if(!((c[975]|0)==0&(c[976]|0)==40)){i=rf[c[(c[6908>>2]|0)+(f*140|0)+28>>2]&255](a)|0;return i|0}f=c[972]|0;c[973]=f;g=f+2|0;c[972]=g;i=b[f>>1]|0;b[14216]=i;h=i&65535;c[974]=h&24576;c[975]=h&4095;if(i<<16>>16<0){c[976]=e[f+4>>1]<<16|e[g>>1];c[972]=f+6}else{c[972]=f+4;c[976]=e[g>>1]}g=dg[c[(c[6908>>2]|0)+((b[a>>1]<<16>>16)*140|0)+32>>2]&127](a,d)|0;f=c[972]|0;c[973]=f;a=f+2|0;c[972]=a;i=b[f>>1]|0;b[14216]=i;h=i&65535;c[974]=h&24576;c[975]=h&4095;if(i<<16>>16<0){c[976]=e[f+4>>1]<<16|e[a>>1];c[972]=f+6;i=g;return i|0}else{c[972]=f+4;c[976]=e[a>>1];i=g;return i|0}}default:{i=a;return i|0}}while(0);i=b[f>>1]|0;c[d>>2]=i;i=rf[c[(c[6908>>2]|0)+(i*140|0)+28>>2]&255](f)|0;return i|0}function dh(){var a=0,d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+16|0;p=r+4|0;o=r;a=c[974]|0;if(a&8192){q=-2;i=r;return q|0}if(a&16384){c[974]=a^16384;q=-3;i=r;return q|0}f=c[975]|0;a:do if(!f){switch(c[976]|0){case 63:break;case 41:{c[974]=a&-16385;q=-4;i=r;return q|0}default:break a}a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;q=b[a>>1]|0;b[14216]=q;f=q&65535;c[974]=f&24576;c[975]=f&4095;if(q<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6}else{c[972]=a+4;c[976]=e[d>>1]}c[974]=f&8192;q=-3;i=r;return q|0}while(0);if(b[14216]&4096){switch(f|0){case 4:{q=c[978]|0;c[971]=q;c[c[q+28>>2]>>2]=c[976];break}case 2:case 3:{d=c[1727]|0;q=c[1726]|0;a=q+(f*48|0)|0;c[971]=a;do if((b[q+(f*48|0)+2>>1]|0)==-1)if(!(b[d+(f*140|0)>>1]|0)){r=rd(4)|0;c[r>>2]=27;Te(r|0,8,0)}else{ej(a,f);a=c[971]|0;break}while(0);tg[c[d+(f*140|0)+72>>2]&255](a,c[a+28>>2]|0,(c[(c[977]|0)+12>>2]|0)+(c[976]|0)|0);break}default:{r=rd(4)|0;c[r>>2]=1;Te(r|0,8,0)}}a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;q=b[a>>1]|0;b[14216]=q;f=q&65535;c[974]=f&24576;c[975]=f&4095;if(q<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6}else{c[972]=a+4;c[976]=e[d>>1]}c[974]=f&8192;q=0;i=r;return q|0}q=((c[1737]|0)-(c[1736]|0)|0)/80|0;a=a|16384;d=f;b:while(1){c:do switch(d|0){case 0:{l=c[976]|0;d=c[1737]|0;if((l|0)==41){f=27;break b}g=d+-80|0;j=b[d+-160>>1]|0;m=j<<16>>16;if(j<<16>>16==4?(b[g>>1]|0)==4:0){f=d+-144|0;d=d+-64|0;a=c[d>>2]|0;do switch(l|0){case 40:{f=53;break b}case 0:{a=(c[f>>2]|0)+a|0;c[f>>2]=a;break}case 1:{a=(c[f>>2]|0)-a|0;c[f>>2]=a;break}case 2:{a=$(c[f>>2]|0,a)|0;c[f>>2]=a;break}case 3:{if(!a){f=37;break b}a=(c[f>>2]|0)/(a|0)|0;c[f>>2]=a;break}case 4:{if(!a){f=40;break b}a=(c[f>>2]|0)%(a|0)|0;c[f>>2]=a;break}case 5:{a=c[f>>2]&a;c[f>>2]=a;break}case 6:{a=c[f>>2]|a;c[f>>2]=a;break}case 7:{a=c[f>>2]^a;c[f>>2]=a;break}case 8:{a=(c[f>>2]|0)==(a|0)&1;c[f>>2]=a;break}case 9:{a=(c[f>>2]|0)!=(a|0)&1;c[f>>2]=a;break}case 10:{a=(c[f>>2]|0)>(a|0)&1;c[f>>2]=a;break}case 11:{a=(c[f>>2]|0)<(a|0)&1;c[f>>2]=a;break}case 12:{a=(c[f>>2]|0)>=(a|0)&1;c[f>>2]=a;break}case 13:{a=(c[f>>2]|0)<=(a|0)&1;c[f>>2]=a;break}case 14:{a=c[f>>2]>>a;c[f>>2]=a;break}case 15:{a=c[f>>2]<<a;c[f>>2]=a;break}default:{f=54;break b}}while(0);c[1737]=g;c[d>>2]=a}else{n=c[1726]|0;a=n+(m*48|0)|0;c[971]=a;h=c[1727]|0;k=h+(m*140|0)|0;if((b[n+(m*48|0)+2>>1]|0)==-1){if(!(b[k>>1]|0)){f=58;break b}ej(a,m);a=c[971]|0}tg[c[h+(m*140|0)+72>>2]&255](a,c[a+28>>2]|0,c[d+-156>>2]|0);a=c[d+-76>>2]|0;d=b[g>>1]|0;f=d<<16>>16;do if(j<<16>>16!=d<<16>>16)if(d<<16>>16>7){a=dg[c[(c[6908>>2]|0)+(f*140|0)+24>>2]&127](a,m)|0;break}else{a=dg[c[h+(m*140|0)+20>>2]&127](a,f)|0;break}while(0);di(k,c[(c[971]|0)+28>>2]|0,l,a);n=c[1737]|0;a=n+-80|0;c[1737]=a;if(b[n+-78>>1]|0){Hl();a=c[1737]|0}c[1737]=a+-80;if(b[a+-78>>1]|0)Hl();f=b[h+(m*140|0)+2>>1]|0;g=f<<16>>16;f=f<<16>>16==j<<16>>16;d=f?k:(c[1727]|0)+(g*140|0)|0;a=b[d+8>>1]|0;if(a<<16>>16<0)a=rf[c[d+56>>2]&255](c[(c[971]|0)+28>>2]|0)|0;else a=a<<16>>16;El(f?m:g,c[(c[971]|0)+28>>2]|0,a)}a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;n=b[a>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6;break c}else{c[972]=a+4;c[976]=e[d>>1];break c}}case 1:{h=c[976]|0;j=c[(c[977]|0)+44>>2]|0;n=j+(h*48|0)|0;m=c[972]|0;c[973]=m;a=m+2|0;c[972]=a;l=b[m>>1]|0;b[14216]=l;k=l&65535;c[974]=k&24576;c[975]=k&4095;if(l<<16>>16<0){c[976]=e[m+4>>1]<<16|e[a>>1];g=m+6|0;c[972]=g;f=4;k=5;l=6}else{g=m+4|0;c[972]=g;c[976]=e[a>>1];f=3;k=4;l=5}a=g;d=b[n>>1]|0;c[p>>2]=d;do if(b[j+(h*48|0)+36>>1]&16){c[p>>2]=d;c[j+(h*48|0)+40>>2]=0;b[j+(h*48|0)+38>>1]=0;if(!((c[975]|0)==0&(c[976]|0)==40)){d=rf[c[(c[6908>>2]|0)+(d*140|0)+28>>2]&255](n)|0;break}c[973]=a;a=m+(f<<1)|0;c[972]=a;j=b[g>>1]|0;b[14216]=j;h=j&65535;c[974]=h&24576;c[975]=h&4095;if(j<<16>>16<0){c[976]=e[m+(k<<1)>>1]<<16|e[a>>1];c[972]=m+(l<<1)}else{c[972]=m+(k<<1);c[976]=e[a>>1]}d=dg[c[(c[6908>>2]|0)+((b[n>>1]<<16>>16)*140|0)+32>>2]&127](n,p)|0;a=c[972]|0;c[973]=a;f=a+2|0;c[972]=f;n=b[a>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=e[a+4>>1]<<16|e[f>>1];c[972]=a+6;break}else{c[972]=a+4;c[976]=e[f>>1];break}}else{ci(n);d=rf[c[(c[6908>>2]|0)+((b[n>>1]<<16>>16)*140|0)+28>>2]&255](n)|0}while(0);a=c[p>>2]|0;f=c[1727]|0;g=b[f+(a*140|0)+8>>1]|0;if(g<<16>>16<0){a=rf[c[f+(a*140|0)+56>>2]&255](d)|0;f=c[p>>2]|0}else{f=a;a=g<<16>>16}El(f,d,a);break}case 4:{d=c[976]|0;a=c[1737]|0;b[a>>1]=4;c[a+16>>2]=d;c[1737]=a+80;a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;n=b[a>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6;break c}else{c[972]=a+4;c[976]=e[d>>1];break c}}case 2:{Fl(2,(c[(c[977]|0)+12>>2]|0)+(c[976]|0)|0);a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;n=b[a>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6;break c}else{c[972]=a+4;c[976]=e[d>>1];break c}}case 3:{El(3,(c[(c[977]|0)+12>>2]|0)+(c[976]|0)|0,8);a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;n=b[a>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6;break c}else{c[972]=a+4;c[976]=e[d>>1];break c}}case 5:{g=c[976]|0;d=c[977]|0;h=c[d+836>>2]|0;a=c[972]|0;c[973]=a;f=a+2|0;c[972]=f;n=b[a>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=e[a+4>>1]<<16|e[f>>1];c[972]=a+6}else{c[972]=a+4;c[976]=e[f>>1]}a=c[d+828>>2]|0;if(!a){f=103;break b}d=b[h+(g<<3)+2>>1]|0;if(d<<16>>16!=-1){if((b[a+2>>1]|0)!=21930){f=108;break b}if((b[a>>1]|0)!=d<<16>>16){f=108;break b}d=c[a+4>>2]|0;if((b[d>>1]|0)!=5){f=108;break b}c[d+40>>2]=c[a+8>>2];a=rf[c[(c[6908>>2]|0)+728>>2]&255](d)|0;if(!(b[a>>1]|0)){f=110;break b}a=c[a+12>>2]|0}a=a+(c[h+(g<<3)+4>>2]|0)|0;c[p>>2]=b[h+(g<<3)>>1];g=ch(a,p)|0;a=c[p>>2]|0;d=c[1727]|0;f=b[d+(a*140|0)+8>>1]|0;if(f<<16>>16<0){a=rf[c[d+(a*140|0)+56>>2]&255](g)|0;d=c[p>>2]|0}else{d=a;a=f<<16>>16}El(d,g,a);break}case 7:{a=c[977]|0;c[o>>2]=(c[a+8>>2]|0)+(c[(c[a+20>>2]|0)+(c[976]<<2)>>2]<<1);El(1,o,4);a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;n=b[a>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6;break c}else{c[972]=a+4;c[976]=e[d>>1];break c}}default:{d=(c[979]|0)+(d<<5)+16|0;if(!(c[d>>2]|0)){f=119;break b}f=c[976]|0;a=c[972]|0;c[973]=a;g=a+2|0;c[972]=g;n=b[a>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=e[a+4>>1]<<16|e[g>>1];c[972]=a+6}else{c[972]=a+4;c[976]=e[g>>1]}m=dg[c[d>>2]&127](p,f)|0;n=rf[c[(c[6908>>2]|0)+((c[p>>2]|0)*140|0)+56>>2]&255](m)|0;El(c[p>>2]|0,m,n)}}while(0);a=c[974]|0;if(a){f=126;break}a=16384;d=c[975]|0}switch(f|0){case 27:if((q|0)==((d-(c[1736]|0)|0)/80|0|0)){r=rd(4)|0;c[r>>2]=4;Te(r|0,8,0)}else{c[974]=a;h=-1;break}case 37:{r=rd(4)|0;c[r>>2]=19;Te(r|0,8,0)}case 40:{r=rd(4)|0;c[r>>2]=19;Te(r|0,8,0)}case 53:{r=rd(4)|0;c[r>>2]=34;Te(r|0,8,0)}case 54:{r=rd(4)|0;c[r>>2]=4;Te(r|0,8,0)}case 58:{r=rd(4)|0;c[r>>2]=27;Te(r|0,8,0)}case 103:{r=rd(4)|0;c[r>>2]=30;Te(r|0,8,0)}case 108:{r=rd(4)|0;c[r>>2]=36;Te(r|0,8,0)}case 110:{r=rd(4)|0;c[r>>2]=36;Te(r|0,8,0)}case 119:{r=rd(4)|0;c[r>>2]=30;Te(r|0,8,0)}case 126:{d=c[1737]|0;h=0;break}}c[974]=a&-16385;o=b[d+-80>>1]|0;g=o<<16>>16;c[p>>2]=g;if(o<<16>>16==4){p=c[978]|0;c[971]=p;c[c[p+28>>2]>>2]=c[d+-64>>2]}else{f=c[1727]|0;p=c[1726]|0;a=p+(g*48|0)|0;c[971]=a;do if((b[p+(g*48|0)+2>>1]|0)==-1)if(!(b[f+(g*140|0)>>1]|0)){r=rd(4)|0;c[r>>2]=27;Te(r|0,8,0)}else{ej(a,g);a=c[971]|0;break}while(0);tg[c[f+(g*140|0)+72>>2]&255](a,c[a+28>>2]|0,c[d+-76>>2]|0);d=c[1737]|0}a=d+-80|0;c[1737]=a;if(b[d+-78>>1]|0){Hl();a=c[1737]|0}if((q|0)==((a-(c[1736]|0)|0)/80|0|0)){q=h;i=r;return q|0}else{r=rd(4)|0;c[r>>2]=29;Te(r|0,8,0)}return 0}function eh(){var a=0;if((dh()|0)<-1){a=rd(4)|0;c[a>>2]=5;Te(a|0,8,0)}a=c[971]|0;if((b[a>>1]|0)==2)return c[a+28>>2]|0;else{a=rd(4)|0;c[a>>2]=6;Te(a|0,8,0)}return 0}function fh(a){a=a|0;if((dh()|0)<-1)return a|0;a=c[971]|0;if((b[a>>1]|0)!=2){a=rd(4)|0;c[a>>2]=6;Te(a|0,8,0)}a=c[a+28>>2]|0;return a|0}function gh(a){a=a|0;if((dh()|0)<-1)return a|0;a=c[971]|0;if((b[a>>1]|0)==2){a=c[a+28>>2]|0;return a|0}a=fj(a,2)|0;return a|0}function hh(){var a=0;if((dh()|0)<-1){a=rd(4)|0;c[a>>2]=5;Te(a|0,8,0)}a=c[971]|0;switch(b[a>>1]|0){case 4:{a=c[c[a+28>>2]>>2]|0;return a|0}case 3:{a=~~+h[c[a+28>>2]>>3];return a|0}default:{a=rd(4)|0;c[a>>2]=6;Te(a|0,8,0)}}return 0}function ih(a){a=a|0;if((dh()|0)<-1)return a|0;a=c[971]|0;switch(b[a>>1]|0){case 4:{a=c[c[a+28>>2]>>2]|0;return a|0}case 3:{a=~~+h[c[a+28>>2]>>3];return a|0}default:{a=rd(4)|0;c[a>>2]=6;Te(a|0,8,0)}}return 0}function jh(){var a=0,d=0.0;if((dh()|0)<-1){a=rd(4)|0;c[a>>2]=5;Te(a|0,8,0)}a=c[971]|0;switch(b[a>>1]|0){case 3:{d=+h[c[a+28>>2]>>3];return +d}case 4:{d=+(c[c[a+28>>2]>>2]|0);return +d}default:{a=rd(4)|0;c[a>>2]=6;Te(a|0,8,0)}}return 0.0}function kh(a){a=+a;var d=0;if((dh()|0)<-1)return +a;d=c[971]|0;switch(b[d>>1]|0){case 3:{a=+h[c[d+28>>2]>>3];return +a}case 4:{a=+(c[c[d+28>>2]>>2]|0);return +a}default:{d=rd(4)|0;c[d>>2]=6;Te(d|0,8,0)}}return 0.0}function lh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;switch(d|0){case 1:{a=c[(c[a>>2]|0)+40>>2]|0;return a|0}case -3:{e=c[b>>2]|0;d=c[b+4>>2]|0;if((c[975]|0)==0&(c[976]|0)==40){a=rd(4)|0;c[a>>2]=34;Te(a|0,8,0)}break}case -2:{d=c[b>>2]|0;e=d;d=ei(d)|0;break}case -1:{e=b;d=ei(b)|0;break}default:{a=rd(4)|0;c[a>>2]=23;Te(a|0,8,0)}}c[a>>2]=e;a=d;return a|0}function mh(a){a=a|0;var d=0,f=0,g=0,h=0,i=0;if(c[974]|0){a=rd(4)|0;c[a>>2]=23;Te(a|0,8,0)}switch(c[975]|0){case 5:{h=c[976]|0;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;i=b[d>>1]|0;b[14216]=i;g=i&65535;c[974]=g&24576;c[975]=g&4095;if(i<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}f=c[977]|0;d=c[f+828>>2]|0;if(!d){i=rd(4)|0;c[i>>2]=30;Te(i|0,8,0)}if((h|0)==-1){if((b[d+2>>1]|0)!=21930){i=rd(4)|0;c[i>>2]=36;Te(i|0,8,0)}c[a>>2]=c[d+4>>2];c[974]=g&8192;i=c[d+8>>2]|0;return i|0}g=c[f+836>>2]|0;f=b[g+(h<<3)+2>>1]|0;do if(f<<16>>16!=-1){if((b[d+2>>1]|0)!=21930){i=rd(4)|0;c[i>>2]=36;Te(i|0,8,0)}if((b[d>>1]|0)!=f<<16>>16){i=rd(4)|0;c[i>>2]=36;Te(i|0,8,0)}f=c[d+4>>2]|0;if((b[f>>1]|0)!=5){i=rd(4)|0;c[i>>2]=36;Te(i|0,8,0)}c[f+40>>2]=c[d+8>>2];d=rf[c[(c[6908>>2]|0)+728>>2]&255](f)|0;if(!(b[d>>1]|0)){i=rd(4)|0;c[i>>2]=36;Te(i|0,8,0)}else{d=c[d+12>>2]|0;break}}while(0);i=lh(a,d+(c[g+(h<<3)+4>>2]|0)|0,b[g+(h<<3)>>1]|0)|0;c[974]=c[974]&8192;return i|0}case 1:{f=(c[(c[977]|0)+44>>2]|0)+((c[976]|0)*48|0)|0;d=c[972]|0;c[973]=d;g=d+2|0;c[972]=g;i=b[d>>1]|0;b[14216]=i;h=i&65535;c[974]=h&24576;c[975]=h&4095;if(i<<16>>16<0){c[976]=e[d+4>>1]<<16|e[g>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[g>>1]}i=ei(f)|0;c[974]=c[974]&8192;c[a>>2]=f;return i|0}default:{i=rd(4)|0;c[i>>2]=23;Te(i|0,8,0)}}return 0}function nh(){var a=0,b=0;b=i;i=i+16|0;a=b;if(!(mh(a)|0)){i=b;return c[a>>2]|0}else{b=rd(4)|0;c[b>>2]=25;Te(b|0,8,0)}return 0}function oh(){var a=0;if((c[975]|0)==7){a=c[977]|0;a=(c[a+8>>2]|0)+(c[(c[a+20>>2]|0)+(c[976]<<2)>>2]<<1)|0;return a|0}if((dh()|0)<-1){a=rd(4)|0;c[a>>2]=8;Te(a|0,8,0)}a=c[971]|0;if((b[a>>1]|0)!=1){a=rd(4)|0;c[a>>2]=8;Te(a|0,8,0)}a=c[c[a+28>>2]>>2]|0;if(!a){a=rd(4)|0;c[a>>2]=8;Te(a|0,8,0)}c[972]=c[973];return a|0}function ph(){var a=0,d=0,f=0,g=0,h=0;d=oh()|0;a=c[972]|0;c[973]=a;f=a+2|0;c[972]=f;h=b[a>>1]|0;b[14216]=h;g=h&65535;c[974]=g&24576;c[975]=g&4095;if(h<<16>>16<0){c[976]=(e[a+4>>1]|0)<<16|(e[f>>1]|0);c[972]=a+6;h=g&8192;c[974]=h;return d|0}else{c[972]=a+4;c[976]=e[f>>1];h=g&8192;c[974]=h;return d|0}return 0}function qh(){var a=0,d=0,f=0,g=0,h=0,i=0,j=0;if((c[975]|0)!=5){i=rd(4)|0;c[i>>2]=35;Te(i|0,8,0)}f=c[976]|0;g=c[977]|0;h=c[g+836>>2]|0;a=c[972]|0;c[973]=a;i=a+2|0;c[972]=i;j=b[a>>1]|0;b[14216]=j;d=j&65535;c[974]=d&24576;c[975]=d&4095;if(j<<16>>16<0){c[976]=e[a+4>>1]<<16|e[i>>1];c[972]=a+6}else{c[972]=a+4;c[976]=e[i>>1]}c[974]=d&8192;if((b[h+(f<<3)>>1]|0)==-5)return (c[g+840>>2]|0)+((b[h+(f<<3)+2>>1]|0)*28|0)|0;else{j=rd(4)|0;c[j>>2]=35;Te(j|0,8,0)}return 0}function rh(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0;c[a+40>>2]=d;g=c[1727]|0;do if((b[a>>1]|0)!=(e|0))if(!d){dj(a,e);break}else{e=rd(4)|0;c[e>>2]=31;Te(e|0,8,0)}while(0);d=c[g+(e*140|0)+72>>2]|0;e=rf[c[g+(e*140|0)+28>>2]&255](a)|0;tg[d&255](a,e,f);return}function sh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;h=mh(a)|0;e=c[a>>2]|0;a=b[e>>1]|0;g=c[1727]|0;f=c[g+(a*140|0)+64>>2]|0;c[e+40>>2]=h;a=rf[c[g+(a*140|0)+28>>2]&255](e)|0;return If[f&127](e,a,d)|0}function th(d,f,g){d=d|0;f=f|0;g=g|0;var j=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;u=i;i=i+16|0;s=u+4|0;t=u;r=f+8|0;if((c[r>>2]|0)<=0){i=u;return}p=(g&1|0)==0;q=0;o=(c[(c[977]|0)+836>>2]|0)+(c[f+4>>2]<<3)|0;a:while(1){g=c[o+4>>2]|0;n=d+g|0;b:do switch(b[o>>1]|0){case 4:{c:do if((dh()|0)<-1)g=0;else{g=c[971]|0;switch(b[g>>1]|0){case 4:{g=c[c[g+28>>2]>>2]|0;break c}case 3:{g=~~+h[c[g+28>>2]>>3];break c}default:{g=6;break a}}}while(0);c[n>>2]=g;break}case -7:{m=mh(s)|0;b[d+(g+2)>>1]=21930;b[n>>1]=b[o+2>>1]|0;c[d+(g+4)>>2]=c[s>>2];c[d+(g+8)>>2]=m;break}case -20:case -11:{c[n>>2]=c[980];c[n+4>>2]=c[981];c[n+8>>2]=c[982];break}case -2:case -3:{m=mh(t)|0;c[n>>2]=c[t>>2];c[d+(g+4)>>2]=m;break}case 7:{f=oh()|0;g=c[972]|0;c[973]=g;l=g+2|0;c[972]=l;v=b[g>>1]|0;b[14216]=v;m=v&65535;c[974]=m&24576;c[975]=m&4095;if(v<<16>>16<0){c[976]=e[g+4>>1]<<16|e[l>>1];c[972]=g+6}else{c[972]=g+4;c[976]=e[l>>1]}c[974]=m&8192;c[n>>2]=f;break}case 3:{if((dh()|0)<-1){g=18;break a}g=c[971]|0;switch(b[g>>1]|0){case 3:{j=+h[c[g+28>>2]>>3];break}case 4:{j=+(c[c[g+28>>2]>>2]|0);break}default:{g=20;break a}}h[k>>3]=j;a[n>>0]=a[k>>0];a[n+1>>0]=a[k+1>>0];a[n+2>>0]=a[k+2>>0];a[n+3>>0]=a[k+3>>0];a[n+4>>0]=a[k+4>>0];a[n+5>>0]=a[k+5>>0];a[n+6>>0]=a[k+6>>0];a[n+7>>0]=a[k+7>>0];break}case -6:{if((dh()|0)<-1){g=25;break a}g=c[971]|0;if((b[g>>1]|0)!=2){g=27;break a}m=c[g+28>>2]|0;v=Ll((F8(m)|0)+1|0)|0;C8(v,m)|0;c[n>>2]=v;break}case -1:{b[d+(g+2)>>1]=-1;if(!p?(dh()|0)==0:0){m=c[971]|0;b[n>>1]=b[m>>1]|0;dj(n,b[m>>1]|0);m=b[n>>1]|0;l=c[1727]|0;v=rf[c[l+(m*140|0)+28>>2]&255](n)|0;tg[c[l+(m*140|0)+72>>2]&255](n,v,c[(c[971]|0)+28>>2]|0);break b}b[n>>1]=4;dj(n,4);break}case -5:break;default:{g=33;break a}}while(0);q=q+1|0;if((q|0)>=(c[r>>2]|0)){g=35;break}else o=o+8|0}if((g|0)==6){v=rd(4)|0;c[v>>2]=6;Te(v|0,8,0)}else if((g|0)==18){v=rd(4)|0;c[v>>2]=5;Te(v|0,8,0)}else if((g|0)==20){v=rd(4)|0;c[v>>2]=6;Te(v|0,8,0)}else if((g|0)==25){v=rd(4)|0;c[v>>2]=5;Te(v|0,8,0)}else if((g|0)==27){v=rd(4)|0;c[v>>2]=6;Te(v|0,8,0)}else if((g|0)==33){v=rd(4)|0;c[v>>2]=36;Te(v|0,8,0)}else if((g|0)==35){i=u;return}}function uh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c[a+40>>2]=d;l=rf[c[(c[6908>>2]|0)+((b[a>>1]<<16>>16)*140|0)+28>>2]&255](a)|0;if((b[l>>1]|0)!=1)return;f=b[l+4>>1]|0;i=c[977]|0;h=c[i+836>>2]|0;g=h+(f<<3)|0;f=b[h+(f<<3)+2>>1]|0;h=f<<16>>16;i=c[i+840>>2]|0;k=l+12|0;e=c[k>>2]|0;if(!(b[l+6>>1]|0)){j=c[i+(h*28|0)+20>>2]|0;if(j){b[1961]=21930;b[1960]=f;c[981]=a;c[982]=d;fi(j)}i=i+(h*28|0)+8|0;f=c[i>>2]|0;if((f|0)>0){h=0;while(1){if((b[g>>1]|0)==-1){f=e+(c[g+4>>2]|0)|0;Kf[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+52>>2]&1023](f);f=c[i>>2]|0}h=h+1|0;if((h|0)>=(f|0))break;else g=g+8|0}}e=c[k>>2]|0}Nl(e);b[l>>1]=0;return}function vh(a){a=a|0;var d=0,e=0;if((b[a+2>>1]|0)!=1)return;d=a+8|0;if((c[d>>2]|0)>0)e=0;else return;do{uh(a,e);e=e+1|0}while((e|0)<(c[d>>2]|0));return}function wh(a){a=a|0;if((a|0)>1024){a=Ol(c[(c[977]|0)+824>>2]|0,a)|0;c[(c[977]|0)+824>>2]=a}return c[(c[977]|0)+824>>2]|0}function xh(a){a=a|0;var b=0;b=F8(a)|0;if((b|0)>1023){b=Ol(c[(c[977]|0)+824>>2]|0,b+1|0)|0;c[(c[977]|0)+824>>2]=b}b=c[(c[977]|0)+824>>2]|0;C8(b,a)|0;return b|0}function yh(a){a=a|0;var d=0;if((a|0)>=0){d=c[979]|0;a=d+(a<<5)|0;return a|0}d=c[983]|0;a=d+1|0;c[983]=a;a=Ol(c[979]|0,a<<5)|0;c[979]=a;b[a+(d<<5)>>1]=d;b[a+(d<<5)+2>>1]=0;c[a+(d<<5)+4>>2]=c[977];c[a+(d<<5)+8>>2]=c[(c[977]|0)+876>>2];c[a+(d<<5)+12>>2]=97;c[a+(d<<5)+16>>2]=0;c[a+(d<<5)+20>>2]=0;c[a+(d<<5)+28>>2]=0;a=c[979]|0;d=a+(d<<5)|0;return d|0}function zh(a){a=a|0;c[977]=a;return}function Ah(a){a=a|0;c[a+236>>2]=4;return}function Bh(a){a=a|0;var b=0;b=(c[1726]|0)+192|0;c[978]=b;ej(b,4);c[a+776>>2]=0;c[a+780>>2]=1;c[a+244>>2]=5;c[a+252>>2]=0;c[a+772>>2]=0;c[a+256>>2]=0;c[a+784>>2]=0;c[a+788>>2]=0;c[a+236>>2]=0;c[a+828>>2]=0;c[a+808>>2]=0;c[a+816>>2]=0;c[a+852>>2]=401;return}function Ch(){return c[(c[977]|0)+776>>2]|0}function Dh(a){a=a|0;var d=0,f=0,g=0,h=0;d=(c[977]|0)+236|0;if((c[d>>2]|0)==4)return;c[973]=a;f=a+2|0;c[972]=f;g=b[a>>1]|0;b[14216]=g;h=g&65535;c[974]=h&24576;c[975]=h&4095;if(g<<16>>16<0){c[976]=(e[a+4>>1]|0)<<16|(e[f>>1]|0);c[972]=a+6}else{c[972]=a+4;c[976]=e[f>>1]}c[d>>2]=0;return}function Eh(a){a=a|0;var d=0,f=0,g=0,h=0;d=(c[977]|0)+236|0;if((c[d>>2]|0)==4){c[d>>2]=7;return}c[973]=a;f=a+2|0;c[972]=f;g=b[a>>1]|0;b[14216]=g;h=g&65535;c[974]=h&24576;c[975]=h&4095;if(g<<16>>16<0){c[976]=(e[a+4>>1]|0)<<16|(e[f>>1]|0);c[972]=a+6}else{c[972]=a+4;c[976]=e[f>>1]}c[d>>2]=0;c[d>>2]=7;return}function Fh(a){a=a|0;var d=0,f=0,g=0,h=0,j=0;g=i;i=i+32|0;d=g;f=c[973]|0;c[972]=f;c[d+4>>2]=f;f=c[977]|0;j=f+256|0;h=c[j>>2]|0;c[j>>2]=h+1;c[d>>2]=h;c[d+12>>2]=c[f+828>>2];c[d+8>>2]=0;El(256,d,20);d=(c[977]|0)+236|0;if((c[d>>2]|0)!=4){c[973]=a;f=a+2|0;c[972]=f;j=b[a>>1]|0;b[14216]=j;h=j&65535;c[974]=h&24576;c[975]=h&4095;if(j<<16>>16<0){c[976]=(e[a+4>>1]|0)<<16|(e[f>>1]|0);c[972]=a+6}else{c[972]=a+4;c[976]=e[f>>1]}c[d>>2]=0}if((c[d>>2]|0)==4){i=g;return}c[d>>2]=0;i=g;return}function Gh(){return Hh(c[973]|0)|0}function Hh(b){b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0;i=c[977]|0;j=c[i+16>>2]|0;i=b-(c[i+8>>2]|0)>>1;if((a[j>>0]|0)==-1){j=-1;return j|0}else{f=0;b=0;h=0}a:while(1){b:while(1){c:while(1){e=d[j+f>>0]|0;switch(e|0){case 255:{b=-1;g=14;break a}case 252:{g=5;break b}case 254:{e=f;break c}case 253:break;default:{g=12;break b}}f=f+6|0}b=d[j+(e+2)>>0]<<8|d[j+(e+3)>>0]<<16|d[j+(e+1)>>0];if(b)c[985]=b;f=e+6|0;b=d[j+(e+5)>>0]<<8|d[j+(e+4)>>0]}if((g|0)==5){e=(d[j+(f+2)>>0]<<8|d[j+(f+1)>>0])+h|0;if((i|0)<=(e|0)){g=14;break}f=f+3|0}else if((g|0)==12){e=e+h|0;if((i|0)<=(e|0)){g=14;break}f=f+1|0}b=b+1|0;h=e}if((g|0)==14)return b|0;return 0}function Ih(){var b=0,e=0,f=0,g=0;c[986]=0;e=c[(c[977]|0)+16>>2]|0;if((a[e>>0]|0)==-1){g=-1;return g|0}else f=0;a:while(1){b=e+f|0;switch(d[b>>0]|0){case 253:break a;case 255:{b=-1;g=7;break a}case 252:{f=f+3|0;continue a}case 254:{f=f+6|0;continue a}default:{f=f+1|0;continue a}}}if((g|0)==7)return b|0;c[986]=b;g=0;return g|0}function Jh(a){a=a|0;var b=0;b=c[986]|0;if(!b){a=63688;return a|0}a=a*6|0;a=(c[(c[977]|0)+12>>2]|0)+((d[b+(a+2)>>0]|0)<<8|(d[b+(a+3)>>0]|0)<<16|(d[b+(a|1)>>0]|0))|0;return a|0}function Kh(a){a=a|0;var b=0,e=0,f=0,g=0;e=c[986]|0;if(!e){a=-1;return a|0}b=c[977]|0;g=c[(c[b>>2]|0)+8>>2]|0;if((g|0)<=0){a=-1;return a|0}f=c[b+12>>2]|0;b=0;while(1){if(!(B8(f+((d[e+2>>0]|0)<<8|(d[e+3>>0]|0)<<16|(d[e+1>>0]|0))|0,a)|0)){e=6;break}b=b+1|0;if((b|0)>=(g|0)){b=-1;e=6;break}else e=e+6|0}if((e|0)==6)return b|0;return 0}function Lh(){return (c[(c[977]|0)+12>>2]|0)+(c[985]|0)|0}function Mh(a){a=a|0;var b=0,d=0;b=c[977]|0;d=c[b+240>>2]|0;if((d|0)<1){c[b+236>>2]=0;a=0;return a|0}else{c[b+248>>2]=(d*10|0)+a;a=2;return a|0}return 0}function Nh(a){a=a|0;var b=0,d=0,e=0,f=0;f=c[977]|0;e=f+248|0;b=c[e>>2]|0;if((b|0)<0){d=f+252|0;b=c[d>>2]|0;if(!b){c[d>>2]=a;b=a}b=(c[f+240>>2]|0)+b|0;c[e>>2]=b}if((b|0)>(a|0)){a=2;return a|0}c[f+252>>2]=a;c[f+236>>2]=0;a=0;return a|0}function Oh(){var a=0,d=0,e=0,f=0,g=0;Il();Bl();Wi();c[971]=c[1726];c[984]=0;b[1974]=13571;b[1975]=3;c[988]=4144;a=c[977]|0;c[989]=c[a+824>>2];d=c[a+792>>2]|0;c[990]=d;c[995]=a+788;c[996]=d;c[997]=1;c[1002]=34;c[1003]=26;c[1004]=98;c[993]=3900;c[994]=3904;c[991]=3884;c[998]=2;c[999]=99;c[1e3]=3;c[1001]=100;c[1005]=0;c[1010]=0;c[1009]=a;c[1008]=3896;c[1007]=0;c[1011]=402;c[1012]=101;c[1013]=102;c[1014]=3;c[1015]=4;c[1018]=5;c[1019]=6;c[1020]=103;c[1021]=53;c[1016]=1;c[1017]=1;c[1022]=104;c[1023]=403;c[1024]=33;c[1025]=7;c[1026]=27;c[1027]=90;c[1028]=404;c[1029]=405;c[1031]=1;c[1032]=106;c[1033]=91;c[1034]=105;c[1035]=106;K9(a+48|0,3948,188)|0;c[a+876>>2]=3948;a=Ll(576)|0;c[979]=a;c[983]=18;d=0;do{b[a+(d<<5)>>1]=d;b[a+(d<<5)+2>>1]=0;c[a+(d<<5)+4>>2]=c[977];c[a+(d<<5)+8>>2]=c[(c[977]|0)+876>>2];c[a+(d<<5)+12>>2]=97;c[a+(d<<5)+16>>2]=0;c[a+(d<<5)+20>>2]=0;c[a+(d<<5)+28>>2]=0;d=d+1|0;a=c[979]|0}while((d|0)<18);c[a+44>>2]=107;c[(c[979]|0)+172>>2]=107;c[(c[979]|0)+492>>2]=108;c[(c[979]|0)+364>>2]=109;c[(c[979]|0)+464>>2]=34;Ei((c[979]|0)+256|0);Fi((c[979]|0)+416|0);Fi((c[979]|0)+416|0);f=c[979]|0;c[f+396>>2]=110;c[f+400>>2]=35;c[(c[977]|0)+24>>2]=0;f=c[977]|0;c[f+28>>2]=0;g=0;d=0;while(1){e=g+1|0;c[f+28>>2]=e;a=c[f+24>>2]|0;if(!a){f=Ll(24)|0;c[(c[977]|0)+24>>2]=f}else{f=Ol(a,e*24|0)|0;c[(c[977]|0)+24>>2]=f}a=c[(c[977]|0)+24>>2]|0;b[a+(g*24|0)>>1]=1;b[a+(g*24|0)+2>>1]=0;c[a+(g*24|0)+4>>2]=-1;c[a+(g*24|0)+12>>2]=0;c[a+(g*24|0)+16>>2]=0;c[a+(g*24|0)+20>>2]=0;d=d+1|0;a=c[977]|0;if((d|0)==5)break;f=a;g=c[a+28>>2]|0}b[(c[a+24>>2]|0)+96>>1]=2;c[983]=18;g=Ll(4096)|0;c[(c[977]|0)+792>>2]=g;g=Ll(256)|0;c[(c[977]|0)+796>>2]=g;g=Ll(4096)|0;c[(c[977]|0)+824>>2]=g;g=Ll(1024)|0;c[(c[977]|0)+872>>2]=g;c[986]=0;c[1037]=0;c[1043]=c[977];c[1039]=0;c[1040]=0;c[1044]=111;c[1045]=36;c[1046]=406;c[1047]=4;c[1048]=112;c[1049]=8;return}function Ph(){var a=0,d=0,e=0,f=0;e=c[977]|0;f=e+28|0;a=c[f>>2]|0;d=a+1|0;c[f>>2]=d;e=c[e+24>>2]|0;if(!e){f=Ll(24)|0;c[(c[977]|0)+24>>2]=f}else{f=Ol(e,d*24|0)|0;c[(c[977]|0)+24>>2]=f}e=c[(c[977]|0)+24>>2]|0;f=e+(a*24|0)|0;b[f>>1]=1;b[e+(a*24|0)+2>>1]=0;c[e+(a*24|0)+4>>2]=-1;c[e+(a*24|0)+12>>2]=0;c[e+(a*24|0)+16>>2]=0;c[e+(a*24|0)+20>>2]=0;return f|0}function Qh(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;j=b[28434+(a<<1)>>1]|0;g=c[983]|0;a:do if((g|0)>18){i=18;while(1){h=c[979]|0;if((b[h+(i<<5)+2>>1]&j)<<16>>16!=0?(k=c[h+(i<<5)+28>>2]|0,(k|0)!=0):0){g=qg[k&63](a,d,e,f)|0;if(g)break;g=c[983]|0}i=i+1|0;if((i|0)>=(g|0))break a}return g|0}while(0);do switch(a|0){case 14:{Nl(c[1050]|0);f=0;return f|0}case 2:{$h(f,d,e);f=0;return f|0}case 13:{c[1050]=Ll(4096)|0;e=Cp(c[(c[977]|0)+796>>2]|0,4200,d)|0;c[(c[977]|0)+784>>2]=e;c[f>>2]=c[1050];f=0;return f|0}case 12:if(!(Qg(c[(c[977]|0)+796>>2]|0,f)|0)){f=0;return f|0}else{f=rd(4)|0;c[f>>2]=12;Te(f|0,8,0)}case 5:{I8(c[(c[977]|0)+796>>2]|0,f,255)|0;f=0;return f|0}case 6:{g=Ng(c[(c[977]|0)+796>>2]|0,f,e,d)|0;if((g|0)<0){f=rd(4)|0;c[f>>2]=12;Te(f|0,8,0)}c[(c[977]|0)+788>>2]=g;f=0;return f|0}case 7:{g=vp(c[(c[977]|0)+796>>2]|0,f,e,d)|0;if((g|0)<0){f=rd(4)|0;c[f>>2]=12;Te(f|0,8,0)}c[(c[977]|0)+788>>2]=g;f=0;return f|0}case 8:{f=Og(c[(c[977]|0)+796>>2]|0)|0;c[(c[977]|0)+788>>2]=f;f=0;return f|0}case 9:if(!(Bp(c[(c[977]|0)+796>>2]|0)|0)){f=rd(4)|0;c[f>>2]=12;Te(f|0,8,0)}else{f=0;return f|0}case 10:if(!(zp(c[(c[977]|0)+796>>2]|0)|0)){f=0;return f|0}else{f=rd(4)|0;c[f>>2]=12;Te(f|0,8,0)}case 11:if(!(Ap(c[(c[977]|0)+796>>2]|0)|0)){f=0;return f|0}else{f=rd(4)|0;c[f>>2]=12;Te(f|0,8,0)}default:{f=0;return f|0}}while(0);return 0}function Rh(a,d){a=a|0;d=d|0;b[(c[(c[977]|0)+24>>2]|0)+(a*24|0)>>1]=(d|0)==0?1:2;return}function Sh(a){a=a|0;a=Ll(16384)|0;c[1051]=a;return a|0}function Th(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;H=i;i=i+4e3|0;F=H+1688|0;E=H+1680|0;B=H+1672|0;A=H+1664|0;z=H+1656|0;y=H+1632|0;x=H+1624|0;s=H+1616|0;t=H+1592|0;r=H+1584|0;v=H+1576|0;D=H+552|0;G=H+40|0;n=H+32|0;q=H;w=H+1952|0;u=H+1696|0;C=H+1692|0;c[1051]=Ll(16384)|0;m=c[977]|0;p=c[(c[m>>2]|0)+8>>2]|0;g=(p|0)>0;if(!e){if(!g){G=c[1051]|0;i=H;return G|0}if(!(f&2)){h=0;do{g=c[986]|0;if(!g)g=63688;else{G=h*6|0;g=(c[(c[977]|0)+12>>2]|0)+(d[g+(G+2)>>0]<<8|d[g+(G+3)>>0]<<16|d[g+(G|1)>>0])|0}if(!((g|0)==0|(wp(g,31452)|0)!=0)){Ql(4204,g);Ql(4204,44021)}h=h+1|0}while((h|0)!=(p|0));G=c[1051]|0;i=H;return G|0}else{h=0;do{g=c[986]|0;if(g){G=h*6|0;g=(c[(c[977]|0)+12>>2]|0)+(d[g+(G+2)>>0]<<8|d[g+(G+3)>>0]<<16|d[g+(G|1)>>0])|0;if(g)j=18}else{g=63688;j=18}if((j|0)==18){j=0;Ql(4204,g);Ql(4204,44021)}h=h+1|0}while((h|0)!=(p|0));G=c[1051]|0;i=H;return G|0}}a:do if(g){l=c[986]|0;if(!l){h=(a[e>>0]|0)==0;g=0;while(1){if(h){h=63688;break a}g=g+1|0;if((g|0)>=(p|0)){h=63688;break}}}else{j=c[m+12>>2]|0;g=0;do{h=g*6|0;h=j+(d[l+(h+2)>>0]<<8|d[l+(h+3)>>0]<<16|d[l+(h|1)>>0])|0;if(!(B8(h,e)|0))break a;g=g+1|0}while((g|0)<(p|0))}}else{g=0;h=0}while(0);j=c[m+44>>2]|0;m=j+(g*48|0)|0;p=b[m>>1]|0;I=c[1727]|0;I8(w,31454,64)|0;l=w+(F8(w)|0)|0;a[l>>0]=58;a[l+1>>0]=0;G8(w,h,1973)|0;l=w+(F8(w)|0)|0;a[l>>0]=a[44021]|0;a[l+1>>0]=a[44022]|0;a[l+2>>0]=a[44023]|0;Ql(4204,w);l=c[I+(p*140|0)+12>>2]|0;I8(w,31461,64)|0;J=w+(F8(w)|0)|0;a[J>>0]=58;a[J+1>>0]=0;G8(w,l,1973)|0;l=w+(F8(w)|0)|0;a[l>>0]=a[44021]|0;a[l+1>>0]=a[44022]|0;a[l+2>>0]=a[44023]|0;Ql(4204,w);l=j+(g*48|0)+8|0;J=c[j+(g*48|0)+12>>2]|0;h=c[j+(g*48|0)+16>>2]|0;e=c[j+(g*48|0)+20>>2]|0;c[q>>2]=c[l>>2];c[q+4>>2]=J;c[q+8>>2]=h;c[q+12>>2]=e;W7(u,31464,q)|0;I8(w,31478,64)|0;e=w+(F8(w)|0)|0;a[e>>0]=58;a[e+1>>0]=0;G8(w,u,1973)|0;e=w+(F8(w)|0)|0;a[e>>0]=a[44021]|0;a[e+1>>0]=a[44022]|0;a[e+2>>0]=a[44023]|0;Ql(4204,w);c[n>>2]=b[j+(g*48|0)+2>>1];W7(q,49204,n)|0;I8(w,31483,64)|0;e=w+(F8(w)|0)|0;a[e>>0]=58;a[e+1>>0]=0;G8(w,q,1973)|0;e=w+(F8(w)|0)|0;a[e>>0]=a[44021]|0;a[e+1>>0]=a[44022]|0;a[e+2>>0]=a[44023]|0;Ql(4204,w);c[G>>2]=c[j+(g*48|0)+24>>2];W7(q,49204,G)|0;I8(w,31490,64)|0;e=w+(F8(w)|0)|0;a[e>>0]=58;a[e+1>>0]=0;G8(w,q,1973)|0;e=w+(F8(w)|0)|0;a[e>>0]=a[44021]|0;a[e+1>>0]=a[44022]|0;a[e+2>>0]=a[44023]|0;Ql(4204,w);e=j+(g*48|0)+40|0;c[e>>2]=0;b[j+(g*48|0)+38>>1]=0;j=rf[c[I+(p*140|0)+28>>2]&255](m)|0;n=If[c[I+(p*140|0)+64>>2]&127](m,j,C)|0;c[D>>2]=c[C>>2];W7(q,49204,D)|0;I8(w,31501,64)|0;g=w+(F8(w)|0)|0;a[g>>0]=58;a[g+1>>0]=0;G8(w,q,1973)|0;g=w+(F8(w)|0)|0;a[g>>0]=a[44021]|0;a[g+1>>0]=a[44022]|0;a[g+2>>0]=a[44023]|0;Ql(4204,w);g=b[m>>1]|0;h=g<<16>>16;if((h+-2|0)>>>0<3){if(g<<16>>16==2)g=n;else g=dg[c[(c[6908>>2]|0)+300>>2]&127](j,h)|0;h=F8(g)|0;if((h|0)>1023){I8(c[(c[977]|0)+824>>2]|0,g,1023)|0;g=c[(c[977]|0)+824>>2]|0;a[g+1023>>0]=0;c[v>>2]=h;W7(u,31516,v)|0;Ql(4204,u)}I8(w,31553,64)|0;J=w+(F8(w)|0)|0;a[J>>0]=a[44021]|0;a[J+1>>0]=a[44022]|0;a[J+2>>0]=a[44023]|0;G8(w,g,1973)|0;J=w+(F8(w)|0)|0;a[J>>0]=a[44021]|0;a[J+1>>0]=a[44022]|0;a[J+2>>0]=a[44023]|0;Ql(4204,w)}else{b:do switch(h|0){case 1:{c[r>>2]=c[j>>2];W7(D,31559,r)|0;break}case 5:{g=b[j>>1]|0;if(!(g<<16>>16)){g=D;h=31571;j=g+15|0;do{a[g>>0]=a[h>>0]|0;g=g+1|0;h=h+1|0}while((g|0)<(j|0));break b}else{v=b[j+4>>1]|0;I=c[j+12>>2]|0;J=c[j+8>>2]|0;c[t>>2]=b[j+2>>1];c[t+4>>2]=v;c[t+8>>2]=I;c[t+12>>2]=J;c[t+16>>2]=g<<16>>16;W7(D,31586,t)|0;break b}}case 6:{c[s>>2]=c[j>>2];W7(D,31621,s)|0;break}default:{J=D;c[J>>2]=1852534357;c[J+4>>2]=7239535}}while(0);I8(w,31553,64)|0;J=w+(F8(w)|0)|0;a[J>>0]=a[44021]|0;a[J+1>>0]=a[44022]|0;a[J+2>>0]=a[44023]|0;G8(w,D,1973)|0;J=w+(F8(w)|0)|0;a[J>>0]=a[44021]|0;a[J+1>>0]=a[44022]|0;a[J+2>>0]=a[44023]|0;Ql(4204,w)}if((f&4|0)!=0?(k=c[l>>2]|0,(k|0)>=2):0){if((k|0)>16){Ql(4204,31634);k=16}l=0;do{c[e>>2]=l;h=rf[c[(c[6908>>2]|0)+((b[m>>1]<<16>>16)*140|0)+28>>2]&255](m)|0;o=0;g=cb(c[(c[1727]|0)+300>>2]|0,h|0,b[m>>1]|0)|0;J=o;o=0;if(J&1){J=zc(0)|0;Id(J|0)|0;c:do switch(b[m>>1]|0){case 1:{c[x>>2]=c[h>>2];W7(D,31559,x)|0;break}case 5:{g=b[h>>1]|0;if(!(g<<16>>16)){g=D;h=31571;j=g+15|0;do{a[g>>0]=a[h>>0]|0;g=g+1|0;h=h+1|0}while((g|0)<(j|0));break c}else{w=b[h+4>>1]|0;I=c[h+12>>2]|0;J=c[h+8>>2]|0;c[y>>2]=b[h+2>>1];c[y+4>>2]=w;c[y+8>>2]=I;c[y+12>>2]=J;c[y+16>>2]=g<<16>>16;W7(D,31586,y)|0;break c}}case 6:{c[z>>2]=c[h>>2];W7(D,31621,z)|0;break}default:{J=D;c[J>>2]=1852534357;c[J+4>>2]=7239535}}while(0);c[A>>2]=l;c[A+4>>2]=D;W7(G,31658,A)|0;Fd()}else{if((F8(g)|0)>>>0>63){I8(c[(c[977]|0)+824>>2]|0,g,63)|0;a[(c[(c[977]|0)+824>>2]|0)+64>>0]=0;g=c[(c[977]|0)+824>>2]|0}c[B>>2]=l;c[B+4>>2]=g;W7(G,31658,B)|0}Ql(4204,G);l=l+1|0}while((l|0)!=(k|0))}if(!(f&8)){J=c[1051]|0;i=H;return J|0}g=c[C>>2]|0;if((g|0)>4096){c[C>>2]=4096;g=4096}if((g|0)>0){h=0;do{c[E>>2]=h;W7(D,31668,E)|0;if((h|0)<(g|0)){e=h-g|0;e=e>>>0>4294967288?e:-8;j=0-e|0;k=h;l=0;while(1){c[F>>2]=d[n+k>>0];W7(G,31673,F)|0;y8(D,G)|0;l=l+1|0;if((l|0)==(j|0))break;else k=k+1|0}h=h-e|0}J=D+(F8(D)|0)|0;a[J>>0]=a[44021]|0;a[J+1>>0]=a[44022]|0;a[J+2>>0]=a[44023]|0;Ql(4204,D)}while((h|0)<(g|0))}J=c[1051]|0;i=H;return J|0}function Uh(a){a=a|0;Nl(c[1051]|0);return}function Vh(){var a=0,b=0;a=c[973]|0;b=c[972]|0;c[973]=b;c[1039]=Hh(b)|0;c[1040]=(c[(c[977]|0)+12>>2]|0)+(c[985]|0);c[973]=a;return}function Wh(a){a=a|0;var b=0;b=(c[977]|0)+236|0;switch(c[b>>2]|0){case 3:{if((a|0)==2)b=-1;else{c[b>>2]=0;c[1037]=(a|0)==1?0:a;b=0}break}case 2:case 1:{if((a|0)==2){c[b>>2]=3;c[1037]=0;b=0}else b=-1;break}default:b=-1}return b|0}function Xh(){var a=0,d=0,e=0,f=0,g=0,h=0;h=i;i=i+272|0;g=h;f=h+8|0;d=Ll(16384)|0;c[1051]=d;e=c[1736]|0;a=c[1737]|0;if((e|0)==(a|0)){g=d;i=h;return g|0}else d=e;do{if((b[d>>1]&-2)<<16>>16==256){a=Hh(c[(c[d+4>>2]|0)+4>>2]|0)|0;c[g>>2]=(c[(c[977]|0)+12>>2]|0)+(c[985]|0);c[g+4>>2]=a;W7(f,31679,g)|0;Ql(4204,f);a=c[1737]|0}d=d+80|0}while((d|0)!=(a|0));g=c[1051]|0;i=h;return g|0}function Yh(){var a=0,d=0,e=0,f=0,g=0,h=0;a=c[977]|0;f=c[(c[a>>2]|0)+8>>2]|0;a:do if((f|0)>0){g=0;d=c[a+44>>2]|0;b:while(1){if(((b[d>>1]|0)==5?(b[d+2>>1]|0)==1:0)?(e=d+8|0,(c[e>>2]|0)>0):0){a=0;do{o=0;na(92,d|0,a|0);h=o;o=0;if(h&1)break b;a=a+1|0}while((a|0)<(c[e>>2]|0))}g=g+1|0;if((g|0)>=(f|0))break a;else d=d+48|0}h=zc(0)|0;Id(h|0)|0;Fd()}while(0);d=c[977]|0;a=c[(c[d>>2]|0)+60>>2]|0;c:do if(a>>>0>=28){e=(a>>>0)/28|0;while(1){a=e+-1|0;h=c[d+840>>2]|0;if(((b[h+(a*28|0)>>1]|0)==-1?(c[h+(a*28|0)+24>>2]&65536|0)!=0:0)?(o=0,Ja(407,a|0),h=o,o=0,h&1):0)break;if((e|0)<2)break c;e=a;d=c[977]|0}h=zc(0)|0;Id(h|0)|0;Fd()}while(0);a=c[983]|0;if((a|0)<=0)return;do{e=a;a=a+-1|0;d=c[(c[979]|0)+(a<<5)+20>>2]|0;if(d)rf[d&255](0)|0}while((e|0)>1);return}function Zh(){var a=0,b=0;Xi();a=c[977]|0;b=c[a+24>>2]|0;if(b){Nl(b);a=c[977]|0}Nl(c[a+872>>2]|0);Nl(c[(c[977]|0)+824>>2]|0);Nl(c[(c[977]|0)+796>>2]|0);Nl(c[(c[977]|0)+792>>2]|0);Nl(c[979]|0);Cl();Jl();return}function _h(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c[(c[977]|0)+848>>2]=0;a:while(1){if(!(c[a>>2]|0)){i=c[977]|0;c[i+772>>2]=0;c[i+256>>2]=0;Dl();c[a>>2]=1}if(!(((c[1037]|0)!=0?(h=c[1039]|0,g=c[973]|0,i=c[972]|0,c[973]=i,i=Hh(i)|0,c[1039]=i,e=c[977]|0,c[1040]=(c[e+12>>2]|0)+(c[985]|0),c[973]=g,(h|0)!=(i|0)):0)?(c[e+236>>2]=3,o=0,Ja(c[e+852>>2]|0,e|0),i=o,o=0,i&1):0))k=10;do if((k|0)==10?(k=0,o=0,f=qa(c[(c[979]|0)+(c[975]<<5)+12>>2]|0,c[976]|0)|0,i=o,o=0,!(i&1)):0){if(!f){k=16;break a}d=c[977]|0;if((c[d+236>>2]|0)==6){o=0;tb(5);i=o;o=0;if(i&1)break;else{k=15;break a}}else{o=0;Ja(c[d+852>>2]|0,d|0);i=o;o=0;if(i&1)break;else{k=15;break a}}}while(0);d=zc(8,0)|0;i=D;i=(i|0)==(te(8)|0);d=Id(d|0)|0;if(!i){k=9;break}d=c[d>>2]|0;switch(d|0){case 0:{d=4;k=34;break a}case 43:{k=33;break a}case 42:break;default:{k=17;break a}}Fd()}if((k|0)==9){c[(c[977]|0)+776>>2]=1;Fd();k=5;return k|0}else if((k|0)==15)if((c[(c[977]|0)+236>>2]|0)==4){k=4;return k|0}else k=16;else if((k|0)==17){i=c[977]|0;c[i+776>>2]=d;c[i+236>>2]=5;if((b[(c[i+24>>2]|0)+24>>1]|0)==2){h=Hh(c[973]|0)|0;e=c[(c[977]|0)+24>>2]|0;i=e+24|0;c[e+36>>2]=0;e=c[983]|0;b:do if((e|0)>18){g=18;while(1){f=c[979]|0;if((b[f+(g<<5)+2>>1]&2)!=0?(j=c[f+(g<<5)+28>>2]|0,(j|0)!=0):0){o=0;e=pb(j|0,2,d|0,h|0,i|0)|0;f=o;o=0;if(f&1)break;if(e)break b;e=c[983]|0}g=g+1|0;if((g|0)>=(e|0)){k=25;break b}}k=zc()|0;Fd();Kc(k|0)}else k=25;while(0);if((k|0)==25?(o=0,sb(107,i|0,d|0,h|0),k=o,o=0,k&1):0){k=zc()|0;Fd();Kc(k|0)}if((c[(c[977]|0)+236>>2]|0)==5)d=5;else{c[a>>2]=0;d=0}Fd();k=d;return k|0}else{d=5;k=34}}else if((k|0)==33){d=10;k=34}if((k|0)==16){k=0;return k|0}else if((k|0)==34){Fd();c[(c[977]|0)+236>>2]=d;k=d;return k|0}return 0}function $h(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;l=i;i=i+32|0;k=l;j=c[977]|0;c[j+32>>2]=c[a+12>>2];c[j+36>>2]=d;c[j+40>>2]=f;h=a+2|0;f=b[h>>1]|0;if(!(f<<16>>16)){f=c[a+16>>2]|0;g=j+236|0;if((c[g>>2]|0)==4)f=0;else{c[973]=f;d=f+2|0;c[972]=d;m=b[f>>1]|0;b[14216]=m;n=m&65535;c[974]=n&24576;c[975]=n&4095;if(m<<16>>16<0){c[976]=(e[f+4>>1]|0)<<16|(e[d>>1]|0);c[972]=f+6}else{c[972]=f+4;c[976]=e[d>>1]}c[g>>2]=0;f=b[h>>1]|0}c[g>>2]=7}if(f<<16>>16!=1){i=l;return}n=c[973]|0;c[972]=n;g=c[a+16>>2]|0;c[972]=n;c[k+4>>2]=n;n=j+256|0;f=c[n>>2]|0;c[n>>2]=f+1;c[k>>2]=f;c[k+12>>2]=c[j+828>>2];c[k+8>>2]=0;El(256,k,20);f=(c[977]|0)+236|0;if((c[f>>2]|0)!=4){c[973]=g;d=g+2|0;c[972]=d;n=b[g>>1]|0;b[14216]=n;m=n&65535;c[974]=m&24576;c[975]=m&4095;if(n<<16>>16<0){c[976]=(e[g+4>>1]|0)<<16|(e[d>>1]|0);c[972]=g+6}else{c[972]=g+4;c[976]=e[d>>1]}c[f>>2]=0}if((c[f>>2]|0)==4){i=l;return}c[f>>2]=0;i=l;return}function ai(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[(c[977]|0)+24>>2]|0;b[g+(a*24|0)>>1]=2;b[g+(a*24|0)+2>>1]=d;c[g+(a*24|0)+16>>2]=f;c[g+(a*24|0)+4>>2]=e;return}function bi(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[977]|0;h=c[e+28>>2]|0;if((h|0)<=0){d=0;return d|0}f=c[e+24>>2]|0;g=0;while(1){e=f+(g*24|0)|0;if((((b[e>>1]|0)!=0?(c[f+(g*24|0)+4>>2]|0)==(d|0):0)?(c[f+(g*24|0)+8>>2]|0)==(a|0):0)?(b[f+(g*24|0)+2>>1]|0)!=2:0){f=8;break}g=g+1|0;if((g|0)>=(h|0)){e=0;f=8;break}}if((f|0)==8)return e|0;return 0}function ci(a){a=a|0;var d=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+40|0;c[k>>2]=0;l=a+38|0;b[l>>1]=0;if(!((c[975]|0)==0&(c[976]|0)==40))return;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;j=b[d>>1]|0;b[14216]=j;i=j&65535;c[974]=i&24576;c[975]=i&4095;if(j<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}d=a+44|0;while(1){f=b[l>>1]|0;g=c[k>>2]|0;h=c[d>>2]|0;i=dh()|0;if((i|0)<-1){d=7;break}j=c[971]|0;if((b[j>>1]|0)!=4){d=9;break}b[l>>1]=f;c[k>>2]=g;c[d>>2]=h;hj(a,c[c[j+28>>2]>>2]|0);if((i|0)==-1){d=11;break}}if((d|0)==7){a=rd(4)|0;c[a>>2]=25;Te(a|0,8,0)}else if((d|0)==9){a=rd(4)|0;c[a>>2]=6;Te(a|0,8,0)}else if((d|0)==11){d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;a=b[d>>1]|0;b[14216]=a;l=a&65535;c[974]=l&24576;c[975]=l&4095;if(a<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6;return}else{c[972]=d+4;c[976]=e[f>>1];return}}}function di(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;do switch(d|0){case 0:{of[c[a+76>>2]&511](b,e);return}case 1:{of[c[a+80>>2]&511](b,e);return}case 2:{of[c[a+84>>2]&511](b,e);return}case 3:{of[c[a+88>>2]&511](b,e);return}case 4:{of[c[a+92>>2]&511](b,e);return}case 5:{of[c[a+96>>2]&511](b,e);return}case 6:{of[c[a+100>>2]&511](b,e);return}case 7:{of[c[a+104>>2]&511](b,e);return}case 8:{of[c[a+108>>2]&511](b,e);return}case 9:{of[c[a+112>>2]&511](b,e);return}case 10:{of[c[a+116>>2]&511](b,e);return}case 11:{of[c[a+120>>2]&511](b,e);return}case 12:{of[c[a+124>>2]&511](b,e);return}case 13:{of[c[a+128>>2]&511](b,e);return}case 14:{of[c[a+132>>2]&511](b,e);return}case 15:{of[c[a+136>>2]&511](b,e);return}case 40:{b=rd(4)|0;c[b>>2]=34;Te(b|0,8,0)}default:{b=rd(4)|0;c[b>>2]=4;Te(b|0,8,0)}}while(0)}function ei(a){a=a|0;var d=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;j=(b[a+36>>1]&16)==0;l=a+40|0;c[l>>2]=0;k=a+38|0;b[k>>1]=0;if(!j){c[1058]=0;if(!((c[975]|0)==0&(c[976]|0)==40)){l=c[l>>2]|0;return l|0}d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;k=b[d>>1]|0;b[14216]=k;j=k&65535;c[974]=j&24576;c[975]=j&4095;if(k<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}Kf[c[(c[6908>>2]|0)+((b[a>>1]<<16>>16)*140|0)+36>>2]&1023](a);c[1058]=1;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;a=b[d>>1]|0;b[14216]=a;k=a&65535;c[974]=k&24576;c[975]=k&4095;if(a<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6;l=c[l>>2]|0;return l|0}else{c[972]=d+4;c[976]=e[f>>1];l=c[l>>2]|0;return l|0}}if(!((c[975]|0)==0&(c[976]|0)==40)){l=c[l>>2]|0;return l|0}d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;j=b[d>>1]|0;b[14216]=j;i=j&65535;c[974]=i&24576;c[975]=i&4095;if(j<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}d=a+44|0;while(1){f=b[k>>1]|0;g=c[l>>2]|0;h=c[d>>2]|0;i=dh()|0;if((i|0)<-1){d=15;break}j=c[971]|0;if((b[j>>1]|0)!=4){d=17;break}b[k>>1]=f;c[l>>2]=g;c[d>>2]=h;si(a,c[c[j+28>>2]>>2]|0);if((i|0)==-1){d=19;break}}if((d|0)==15){l=rd(4)|0;c[l>>2]=25;Te(l|0,8,0)}else if((d|0)==17){l=rd(4)|0;c[l>>2]=6;Te(l|0,8,0)}else if((d|0)==19){d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;a=b[d>>1]|0;b[14216]=a;k=a&65535;c[974]=k&24576;c[975]=k&4095;if(a<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6;l=c[l>>2]|0;return l|0}else{c[972]=d+4;c[976]=e[f>>1];l=c[l>>2]|0;return l|0}}return 0}function fi(a){a=a|0;var d=0,f=0,g=0,h=0,i=0,j=0;h=c[(c[977]|0)+840>>2]|0;f=h+(a*28|0)|0;d=Gl(257,(c[h+(a*28|0)+16>>2]|0)+20|0)|0;j=d+20|0;th(j,f,0);c[d+12>>2]=c[(c[977]|0)+828>>2];c[(c[977]|0)+828>>2]=j;c[d+4>>2]=c[973];j=(c[977]|0)+256|0;i=c[j>>2]|0;c[j>>2]=i+1;c[d>>2]=i;c[d+8>>2]=f;d=c[977]|0;f=c[d+8>>2]|0;a=c[(c[d+20>>2]|0)+(c[h+(a*28|0)+20>>2]<<2)>>2]|0;h=f+(a<<1)|0;c[973]=h;d=f+(a+1<<1)|0;c[972]=d;h=b[h>>1]|0;b[14216]=h;i=h&65535;c[974]=i&24576;c[975]=i&4095;if(h<<16>>16<0){c[976]=(e[f+(a+2<<1)>>1]|0)<<16|(e[d>>1]|0);c[972]=f+(a+3<<1)}else{c[972]=f+(a+2<<1);c[976]=e[d>>1]}a:while(1){if((c[1037]|0)!=0?(i=c[1039]|0,h=c[973]|0,j=c[972]|0,c[973]=j,j=Hh(j)|0,c[1039]=j,g=c[977]|0,c[1040]=(c[g+12>>2]|0)+(c[985]|0),c[973]=h,(i|0)!=(j|0)):0){c[g+236>>2]=3;Kf[c[g+852>>2]&1023](g)}if(!(rf[c[(c[3916>>2]|0)+(c[3900>>2]<<5)+12>>2]&255](c[976]|0)|0))continue;a=c[977]|0;switch(c[a+236>>2]|0){case 4:{a=9;break a}case 6:{a=10;break a}default:{}}Kf[c[a+852>>2]&1023](a)}if((a|0)==9){j=rd(4)|0;c[j>>2]=0;Te(j|0,8,0)}else if((a|0)==10){ri();return}}function gi(a){a=a|0;var d=0,f=0,g=0,h=0;if(!(c[974]&8192)){f=rd(4)|0;c[f>>2]=16;Te(f|0,8,0)}f=c[975]|0;a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;g=b[a>>1]|0;b[14216]=g;h=g&65535;c[974]=h&24576;c[975]=h&4095;if(g<<16>>16<0){c[976]=(e[a+4>>1]|0)<<16|(e[d>>1]|0);c[972]=a+6}else{c[972]=a+4;c[976]=e[d>>1]}a=rd(4)|0;switch(f|0){case 10:case 13:{c[a>>2]=41;Te(a|0,8,0)}default:{c[a>>2]=18;Te(a|0,8,0)}}return 0}function hi(){var a=0,d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;h=mh(3880)|0;e=c[970]|0;a=b[e>>1]|0;g=c[1727]|0;f=c[g+(a*140|0)+64>>2]|0;c[e+40>>2]=h;a=rf[c[g+(a*140|0)+28>>2]&255](e)|0;a=If[f&127](e,a,d)|0;c[(c[977]|0)+64>>2]=3880;i=d;return a|0}function ii(a,d,e){a=a|0;d=d|0;e=e|0;c[a+40>>2]=0;e=rf[c[(c[6908>>2]|0)+((b[a>>1]<<16>>16)*140|0)+28>>2]&255](a)|0;tg[c[(c[6908>>2]|0)+((b[a>>1]<<16>>16)*140|0)+68>>2]&255](a,e,d);return 0}function ji(a){a=a|0;return (c[1727]|0)+(a*140|0)|0}function ki(){c[(c[977]|0)+64>>2]=3884;return dh()|0}function li(a){a=a|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;g=p+4|0;k=p;if(!(c[974]&8192)){p=rd(4)|0;c[p>>2]=16;Te(p|0,8,0)}c[974]=0;o=mh(g)|0;if(c[975]|0){c[972]=c[973];p=rd(4)|0;c[p>>2]=2;Te(p|0,8,0)}n=c[976]|0;a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;m=b[a>>1]|0;b[14216]=m;l=m&65535;f=l&24576;c[974]=f;c[975]=l&4095;if(m<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6}else{c[972]=a+4;c[976]=e[d>>1]}if(f){a=c[g>>2]|0;m=b[a>>1]|0;h=m<<16>>16;j=c[1727]|0;c[k>>2]=1;if(m<<16>>16==4){d=4;f=j;g=k}else{g=dg[c[j+(h*140|0)+20>>2]&127](k,4)|0;d=b[a>>1]|0;f=c[1727]|0}c[a+40>>2]=o;a=rf[c[f+((d<<16>>16)*140|0)+28>>2]&255](a)|0;switch(n|0){case 0:{of[c[j+(h*140|0)+76>>2]&511](a,g);i=p;return 0}case 1:{of[c[j+(h*140|0)+80>>2]&511](a,g);i=p;return 0}default:{p=rd(4)|0;c[p>>2]=2;Te(p|0,8,0)}}}if(dh()|0){p=rd(4)|0;c[p>>2]=2;Te(p|0,8,0)}m=c[g>>2]|0;g=b[m>>1]|0;h=c[1727]|0;a=h+(g*140|0)|0;l=m+40|0;c[l>>2]=o;j=rf[c[h+(g*140|0)+28>>2]&255](m)|0;f=c[971]|0;k=c[f+28>>2]|0;if((n|0)!=8){d=b[m>>1]|0;if(d<<16>>16==(b[f>>1]|0))d=k;else d=fj(f,d<<16>>16)|0;di(a,j,n,d);if((b[h+(g*140|0)+2>>1]|0)==(b[m>>1]|0)){i=p;return 0}else{p=rd(4)|0;c[p>>2]=6;Te(p|0,8,0)}}if((c[1058]|0)!=0?(b[m+36>>1]&64)!=0:0){tg[c[h+(g*140|0)+40>>2]&255](m,k,b[f>>1]|0);i=p;return 0}n=b[f>>1]|0;d=n<<16>>16;do if((b[m>>1]|0)!=n<<16>>16)if(!o){dj(m,d);a=b[m>>1]|0;n=c[1727]|0;d=rf[c[n+(a*140|0)+28>>2]&255](m)|0;a=n+(a*140|0)|0;break}else{p=rd(4)|0;c[p>>2]=31;Te(p|0,8,0)}else d=j;while(0);h=a+72|0;tg[c[h>>2]&255](m,d,k);if(c[974]|0){i=p;return 0}a=c[m+8>>2]|0;if(!a)a=o;else a=(o|0)%(a|0)|0;f=o-a|0;g=m+38|0;d=a;while(1){if(dh()|0){a=30;break}a=c[971]|0;if((b[m>>1]|0)!=(b[a>>1]|0)){a=32;break}o=c[a+28>>2]|0;d=d+1|0;b[g>>1]=0;c[l>>2]=f;si(m,d);n=rf[c[(c[6908>>2]|0)+((b[m>>1]<<16>>16)*140|0)+28>>2]&255](m)|0;tg[c[h>>2]&255](m,n,o);if(c[974]|0){a=38;break}}if((a|0)==30){p=rd(4)|0;c[p>>2]=2;Te(p|0,8,0)}else if((a|0)==32){p=rd(4)|0;c[p>>2]=31;Te(p|0,8,0)}else if((a|0)==38){i=p;return 0}return 0}function mi(a){a=a|0;var d=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;q=i;i=i+48|0;p=q+24|0;g=q+20|0;j=q+16|0;k=q+12|0;l=q+8|0;m=q+4|0;n=q;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;r=b[d>>1]|0;b[14216]=r;s=r&65535;c[974]=s&24576;c[975]=s&4095;if(r<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}a:do switch(a|0){case 0:{d=oh()|0;c[973]=d;f=d+2|0;c[972]=f;s=b[d>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6;s=0;i=q;return s|0}else{c[972]=d+4;c[976]=e[f>>1];s=0;i=q;return s|0}}case 1:{g=oh()|0;c[p+4>>2]=c[972];d=c[977]|0;r=d+256|0;s=c[r>>2]|0;c[r>>2]=s+1;c[p>>2]=s;c[p+12>>2]=c[d+828>>2];c[p+8>>2]=0;El(256,p,20);d=(c[977]|0)+236|0;if((c[d>>2]|0)!=4){c[973]=g;f=g+2|0;c[972]=f;s=b[g>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[g+4>>1]<<16|e[f>>1];c[972]=g+6}else{c[972]=g+4;c[976]=e[f>>1]}c[d>>2]=0}s=0;i=q;return s|0}case 2:{b:do if((c[(c[977]|0)+828>>2]|0)!=0?(dh()|0)>=-1:0){d=c[977]|0;c[d+844>>2]=c[d+256>>2];f=c[971]|0;s=b[f>>1]|0;c[1052]=s;switch(s|0){case 4:{c[d+784>>2]=c[c[f+28>>2]>>2];break b}case 2:{Pl(d+792|0,c[f+28>>2]|0);break b}case 3:{h[d+864>>3]=+h[c[f+28>>2]>>3];break b}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[(c[977]|0)+236>>2]=6;s=6;i=q;return s|0}case 3:{d=(c[977]|0)+772|0;f=c[d>>2]|0;if(!f){s=rd(4)|0;c[s>>2]=11;Te(s|0,8,0)}c[d>>2]=f+-1;d=oh()|0;c[973]=d;f=d+2|0;c[972]=f;s=b[d>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6;s=0;i=q;return s|0}else{c[972]=d+4;c[976]=e[f>>1];s=0;i=q;return s|0}}case 4:{if((c[(c[977]|0)+772>>2]|0)>30){s=rd(4)|0;c[s>>2]=9;Te(s|0,8,0)}g=oh()|0;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;s=b[d>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}c:do if((dh()|0)<-1)d=-2147483648;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break c}case 3:{d=~~+h[c[d+28>>2]>>3];break c}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1054]=d;d:do if((dh()|0)<-1)d=0;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break d}case 3:{d=~~+h[c[d+28>>2]>>3];break d}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1055]=d;f=c[1054]|0;if(f){c[1054]=(f|0)<0?-2147483648:f+d|0;r=c[977]|0;p=r+772|0;s=(c[p>>2]|0)+1|0;c[p>>2]=s;c[r+260+(s<<4)+4>>2]=c[1055];c[r+260+(s<<4)>>2]=c[1054];c[r+260+(s<<4)+12>>2]=c[973];s=0;i=q;return s|0}c[973]=g;d=g+2|0;c[972]=d;s=b[g>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[g+4>>1]<<16|e[d>>1];c[972]=g+6;s=0;i=q;return s|0}else{c[972]=g+4;c[976]=e[d>>1];s=0;i=q;return s|0}}case 5:{d=c[977]|0;f=d+772|0;g=c[f>>2]|0;if(!g){s=rd(4)|0;c[s>>2]=11;Te(s|0,8,0)}s=d+260+(g<<4)+4|0;r=(c[s>>2]|0)+1|0;c[s>>2]=r;s=c[d+260+(g<<4)>>2]|0;if(!((s|0)==-2147483648|(r|0)<(s|0))){c[f>>2]=g+-1;s=0;i=q;return s|0}d=c[d+260+(g<<4)+12>>2]|0;c[973]=d;f=d+2|0;c[972]=f;s=b[d>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6;s=0;i=q;return s|0}else{c[972]=d+4;c[976]=e[f>>1];s=0;i=q;return s|0}}case 6:{k=oh()|0;f=c[977]|0;g=c[f+772>>2]|0;d=c[972]|0;c[973]=d;j=d+2|0;c[972]=j;s=b[d>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[j>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[j>>1]}f=f+260+(g<<4)+4|0;d=(c[f>>2]|0)+1|0;c[1055]=d;e:do if((dh()|0)>=-1){d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break e}case 3:{d=~~+h[c[d+28>>2]>>3];break e}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1054]=d;c[f>>2]=d+-1;c[972]=k;c[976]=5;c[975]=15;c[974]=0;s=0;i=q;return s|0}case 7:{f:do if((dh()|0)<-1)d=100;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break f}case 3:{d=~~+h[c[d+28>>2]>>3];break f}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);s=c[977]|0;c[s+240>>2]=d;c[s+236>>2]=1;s=1;i=q;return s|0}case 8:{g:do if((dh()|0)<-1)d=0;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break g}case 3:{d=~~+h[c[d+28>>2]>>3];break g}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1054]=d;s=c[977]|0;c[s+240>>2]=d;c[s+248>>2]=-1;c[s+236>>2]=2;s=2;i=q;return s|0}case 13:case 10:case 9:{if(mh(p)|0){s=rd(4)|0;c[s>>2]=25;Te(s|0,8,0)}g=c[p>>2]|0;if((a|0)==13){if((dh()|0)<-1){s=rd(4)|0;c[s>>2]=5;Te(s|0,8,0)}d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}if(!(b[(c[1727]|0)+(d*140|0)>>1]|0)){s=rd(4)|0;c[s>>2]=3;Te(s|0,8,0)}}else d=4;h:do if((dh()|0)<-1)f=0;else{f=c[971]|0;switch(b[f>>1]|0){case 4:{f=c[c[f+28>>2]>>2]|0;break h}case 3:{f=~~+h[c[f+28>>2]>>3];break h}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1054]=f;i:do if((dh()|0)<-1)f=0;else{f=c[971]|0;switch(b[f>>1]|0){case 4:{f=c[c[f+28>>2]>>2]|0;break i}case 3:{f=~~+h[c[f+28>>2]>>3];break i}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1055]=f;j:do if((dh()|0)<-1)f=0;else{f=c[971]|0;switch(b[f>>1]|0){case 4:{f=c[c[f+28>>2]>>2]|0;break j}case 3:{f=~~+h[c[f+28>>2]>>3];break j}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1056]=f;k:do if((dh()|0)<-1)f=0;else{f=c[971]|0;switch(b[f>>1]|0){case 4:{f=c[c[f+28>>2]>>2]|0;break k}case 3:{f=~~+h[c[f+28>>2]>>3];break k}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1057]=f;if((a|0)!=10){aj(g,d,c[1054]|0,c[1055]|0,c[1056]|0,f);s=0;i=q;return s|0}l:do if((dh()|0)<-1)d=0;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break l}case 3:{d=~~+h[c[d+28>>2]>>3];break l}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);bj(g,2,c[1054]|0,c[1055]|0,c[1056]|0,c[1057]|0,d);s=0;i=q;return s|0}case 11:{if((c[(c[977]|0)+772>>2]|0)>30){s=rd(4)|0;c[s>>2]=9;Te(s|0,8,0)}oh()|0;f=c[972]|0;c[973]=f;d=f;g=d+2|0;c[972]=g;s=b[d>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[g>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[g>>1]}r=c[977]|0;p=r+772|0;s=(c[p>>2]|0)+1|0;c[p>>2]=s;c[r+260+(s<<4)+4>>2]=0;c[r+260+(s<<4)>>2]=-2147483648;c[r+260+(s<<4)+12>>2]=f;s=0;i=q;return s|0}case 12:{if(!(c[(c[977]|0)+772>>2]|0)){s=rd(4)|0;c[s>>2]=11;Te(s|0,8,0)}j=oh()|0;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;s=b[d>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}d=c[977]|0;f=c[d+772>>2]|0;if(mh(p)|0){s=rd(4)|0;c[s>>2]=25;Te(s|0,8,0)}g=c[p>>2]|0;d=c[d+260+(f<<4)+4>>2]|0;if((d|0)>=(c[g+8>>2]|0)){d=(c[977]|0)+772|0;c[d>>2]=(c[d>>2]|0)+-1;c[973]=j;d=j+2|0;c[972]=d;s=b[j>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[j+4>>1]<<16|e[d>>1];c[972]=j+6;s=0;i=q;return s|0}else{c[972]=j+4;c[976]=e[d>>1];s=0;i=q;return s|0}}if(!(b[g+36>>1]&128)){s=0;i=q;return s|0}s=b[g>>1]|0;p=c[1727]|0;r=c[p+(s*140|0)+60>>2]|0;c[g+40>>2]=d;s=rf[c[p+(s*140|0)+28>>2]&255](g)|0;if(rf[r&255](s)|0){s=0;i=q;return s|0}c[972]=j;c[976]=5;c[975]=15;c[974]=0;s=0;i=q;return s|0}case 14:{if(mh(p)|0){s=rd(4)|0;c[s>>2]=25;Te(s|0,8,0)}r=c[p>>2]|0;s=mh(g)|0;$i(r,c[g>>2]|0,s);s=0;i=q;return s|0}case 15:{if(mh(p)|0){s=rd(4)|0;c[s>>2]=25;Te(s|0,8,0)}g=c[p>>2]|0;if((dh()|0)<-1){s=rd(4)|0;c[s>>2]=5;Te(s|0,8,0)}d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}c[1054]=d;if((dh()|0)<-1){s=rd(4)|0;c[s>>2]=5;Te(s|0,8,0)}d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}c[1055]=d;m:do if((dh()|0)<-1)d=4;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break m}case 3:{d=~~+h[c[d+28>>2]>>3];break m}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1056]=d;f=c[1055]|0;if((f|0)<1){s=rd(4)|0;c[s>>2]=3;Te(s|0,8,0)}if(!(b[(c[1727]|0)+(d*140|0)>>1]|0)){s=rd(4)|0;c[s>>2]=3;Te(s|0,8,0)}_i(g,d,c[1054]|0,f);s=0;i=q;return s|0}case 16:{n:do if((dh()|0)<-1)d=0;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break n}case 3:{d=~~+h[c[d+28>>2]>>3];break n}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);s=c[977]|0;c[s+848>>2]=d;c[s+236>>2]=4;s=4;i=q;return s|0}case 27:{if((dh()|0)>=-1){d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}c[1054]=d;if(d){s=0;i=q;return s|0}}else c[1054]=0;c[(c[977]|0)+236>>2]=8;s=8;i=q;return s|0}case 17:{c[(c[977]|0)+236>>2]=3;s=3;i=q;return s|0}case 20:{f=mh(k)|0;d=c[k>>2]|0;if((b[d>>1]|0)!=5){s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}uh(d,f);s=0;i=q;return s|0}case 22:{if(mh(p)|0){s=rd(4)|0;c[s>>2]=25;Te(s|0,8,0)}g=c[p>>2]|0;if((dh()|0)<-1){s=rd(4)|0;c[s>>2]=5;Te(s|0,8,0)}d=c[971]|0;switch(b[d>>1]|0){case 4:{f=c[c[d+28>>2]>>2]|0;break}case 3:{f=~~+h[c[d+28>>2]>>3];break}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}c[1054]=f;if(f&1024){s=rd(4)|0;c[s>>2]=21;Te(s|0,8,0)}if((f|0)>63){d=c[(c[(c[977]|0)+876>>2]|0)+172>>2]|0;if(!d){s=0;i=q;return s|0}of[d&511](g,f);s=0;i=q;return s|0}if((f|0)>7|(f&48|0)!=0){s=rd(4)|0;c[s>>2]=21;Te(s|0,8,0)}d=c[(c[977]|0)+828>>2]|0;if(!d){s=rd(4)|0;c[s>>2]=3;Te(s|0,8,0)}_i(g,4,d+(f<<2)|0,4);s=0;i=q;return s|0}case 23:{d=(c[977]|0)+792|0;if((dh()|0)<-1){s=rd(4)|0;c[s>>2]=5;Te(s|0,8,0)}f=c[971]|0;if((b[f>>1]|0)!=2){s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}Pl(d,c[f+28>>2]|0);do if((dh()|0)>=-1){d=c[971]|0;if((b[d>>1]|0)==2){d=c[d+28>>2]|0;break}else{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}else d=63688;while(0);f=F8(d)|0;if((f|0)<=1023){s=c[977]|0;s=s+824|0;s=c[s>>2]|0;C8(s,d)|0;s=rd(4)|0;c[s>>2]=43;Te(s|0,8,0)}s=Ol(c[(c[977]|0)+824>>2]|0,f+1|0)|0;c[(c[977]|0)+824>>2]=s;s=c[977]|0;s=s+824|0;s=c[s>>2]|0;C8(s,d)|0;s=rd(4)|0;c[s>>2]=43;Te(s|0,8,0)}case 24:{f=mh(l)|0;d=c[l>>2]|0;if((b[d>>1]|0)!=4){s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}c[d+40>>2]=f;k=rf[c[(c[6908>>2]|0)+588>>2]&255](d)|0;o:do if((dh()|0)<-1)d=0;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break o}case 3:{d=~~+h[c[d+28>>2]>>3];break o}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1054]=d;p:do if((dh()|0)<-1)d=0;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break p}case 3:{d=~~+h[c[d+28>>2]>>3];break p}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1055]=d;j=oh()|0;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;s=b[d>>1]|0;b[14216]=s;g=s&65535;c[974]=g&24576;c[975]=g&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}c[974]=g&8192;r=c[k>>2]|0;s=c[1055]|0;if((c[1054]|0)>-1?(r|0)<(s|0):(r|0)>(s|0)){s=0;i=q;return s|0}d=(c[977]|0)+236|0;if((c[d>>2]|0)==4){s=0;i=q;return s|0}c[973]=j;f=j+2|0;c[972]=f;s=b[j>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[j+4>>1]<<16|e[f>>1];c[972]=j+6}else{c[972]=j+4;c[976]=e[f>>1]}c[d>>2]=0;s=0;i=q;return s|0}case 25:{q:do if((dh()|0)<-1)d=0;else{d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break q}case 3:{d=~~+h[c[d+28>>2]>>3];break q}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}}while(0);c[1054]=d;if((c[975]|0)!=15){s=rd(4)|0;c[s>>2]=2;Te(s|0,8,0)}d=c[976]|0;if((d|0)>1){s=rd(4)|0;c[s>>2]=2;Te(s|0,8,0)}c[1055]=0;c[1056]=d;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;s=b[d>>1]|0;b[14216]=s;g=s&65535;c[974]=g&24576;c[975]=g&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}if(!(g&8192))g=0;else{s=0;i=q;return s|0}do{l=oh()|0;d=c[972]|0;c[973]=d;f=d;j=f+2|0;c[972]=j;s=b[f>>1]|0;b[14216]=s;k=s&65535;c[974]=k&24576;c[975]=k&4095;if(s<<16>>16<0){c[976]=e[f+4>>1]<<16|e[j>>1];c[972]=f+6}else{c[972]=f+4;c[976]=e[j>>1]}f=k&8192;c[974]=f;j=c[1055]|0;if((c[1054]|0)==(j|0))if(!(c[1056]|0)){k=l;o=263;break}else g=l;c[1055]=j+1}while((f|0)==0);if((o|0)==263){j=(c[977]|0)+236|0;if((c[j>>2]|0)!=4){d=k;c[973]=d;f=k+2|0;c[972]=f;s=b[k>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[k+4>>1]<<16|e[f>>1];c[972]=k+6}else{c[972]=k+4;c[976]=e[f>>1]}c[j>>2]=0}}if(!g){s=0;i=q;return s|0}c[972]=d;c[p+4>>2]=d;d=c[977]|0;r=d+256|0;s=c[r>>2]|0;c[r>>2]=s+1;c[p>>2]=s;c[p+12>>2]=c[d+828>>2];c[p+8>>2]=0;El(256,p,20);d=(c[977]|0)+236|0;if((c[d>>2]|0)!=4){c[973]=g;f=g+2|0;c[972]=f;s=b[g>>1]|0;b[14216]=s;r=s&65535;c[974]=r&24576;c[975]=r&4095;if(s<<16>>16<0){c[976]=e[g+4>>1]<<16|e[f>>1];c[972]=g+6}else{c[972]=g+4;c[976]=e[f>>1]}c[d>>2]=0}if((c[d>>2]|0)==4){s=4;i=q;return s|0}c[d>>2]=0;s=0;i=q;return s|0}case 26:{if(mh(p)|0){s=rd(4)|0;c[s>>2]=25;Te(s|0,8,0)}s=c[p>>2]|0;Kf[c[(c[6908>>2]|0)+((b[s>>1]<<16>>16)*140|0)+44>>2]&1023](s);s=0;i=q;return s|0}case 28:{if((dh()|0)<-1){s=rd(4)|0;c[s>>2]=5;Te(s|0,8,0)}d=c[971]|0;if((b[d>>1]|0)!=2){s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}d=c[d+28>>2]|0;f=F8(d)|0;if((f|0)>1023){s=Ol(c[(c[977]|0)+824>>2]|0,f+1|0)|0;c[(c[977]|0)+824>>2]=s}C8(c[(c[977]|0)+824>>2]|0,d)|0;c[(c[977]|0)+236>>2]=9;s=9;i=q;return s|0}case 29:{k=mh(m)|0;c[n>>2]=0;r:do switch(c[975]|0){case 4:{if((dh()|0)<-1){s=rd(4)|0;c[s>>2]=5;Te(s|0,8,0)}d=c[971]|0;switch(b[d>>1]|0){case 4:{d=c[c[d+28>>2]>>2]|0;break}case 3:{d=~~+h[c[d+28>>2]>>3];break}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}switch(d|0){case 0:{c[n>>2]=c[973];break r}case 1:{c[n>>2]=c[972];break r}default:break r}}case 7:{f=oh()|0;d=c[972]|0;c[973]=d;g=d+2|0;c[972]=g;s=b[d>>1]|0;b[14216]=s;j=s&65535;c[974]=j&24576;c[975]=j&4095;if(s<<16>>16<0){c[976]=e[d+4>>1]<<16|e[g>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[g>>1]}c[974]=j&8192;c[n>>2]=f;break}default:{s=rd(4)|0;c[s>>2]=6;Te(s|0,8,0)}}while(0);d=c[m>>2]|0;c[d+40>>2]=k;f=c[1727]|0;do if((b[d>>1]|0)!=1)if(!k){dj(d,1);break}else{s=rd(4)|0;c[s>>2]=31;Te(s|0,8,0)}while(0);r=c[f+212>>2]|0;s=rf[c[f+168>>2]&255](d)|0;tg[r&255](d,s,n);s=0;i=q;return s|0}case 18:{if(mh(p)|0){s=rd(4)|0;c[s>>2]=25;Te(s|0,8,0)}f=c[p>>2]|0;c[j>>2]=f;g=f;if((b[f>>1]|0)==5){d=c[f+28>>2]|0;j=c[f+8>>2]|0;if((j|0)>0){k=0;do{if(!(b[d+(k<<4)>>1]|0))break a;k=k+1|0}while((k|0)<(j|0))}cj(f,1,j+1|0);k=j}else k=0;break}case 19:{k=mh(j)|0;g=c[j>>2]|0;f=g;break}case 30:case 31:{s=0;i=q;return s|0}default:{s=rd(4)|0;c[s>>2]=21;Te(s|0,8,0)}}while(0);m=qh()|0;d=c[m+16>>2]|0;l=m+4|0;b[p+4>>1]=c[l>>2];b[p+6>>1]=0;c[p+8>>2]=d;c[p+12>>2]=0;d=f+40|0;c[d>>2]=k;j=c[1727]|0;do if((b[f>>1]|0)!=5)if(!k){dj(f,5);break}else{s=rd(4)|0;c[s>>2]=31;Te(s|0,8,0)}while(0);s=c[j+772>>2]|0;j=rf[c[j+728>>2]&255](f)|0;tg[s&255](f,j,p);c[d>>2]=k;f=rf[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&255](f)|0;b[f>>1]=1;d=Ll(c[f+8>>2]|0)|0;c[f+12>>2]=d;f=c[l>>2]|0;j=c[(c[977]|0)+836>>2]|0;if((b[j+(f<<3)>>1]|0)!=-5){s=rd(4)|0;c[s>>2]=35;Te(s|0,8,0)}th(d,m,0);d=c[j+(f<<3)+4>>2]|0;if((d|0)==-1){s=0;i=q;return s|0}b[1961]=21930;b[1960]=b[j+(f<<3)+2>>1]|0;c[981]=g;c[982]=k;fi(d);s=0;i=q;return s|0}function ni(a){a=a|0;var d=0,f=0,g=0,i=0,j=0;f=c[972]|0;g=e[f>>1]|0;a=f+2|0;c[972]=a;i=f+(g+1<<1)|0;if(!(c[976]|0)){c[973]=a;d=f+4|0;c[972]=d;a=b[a>>1]|0;b[14216]=a;j=a&65535;c[974]=j&24576;c[975]=j&4095;if(a<<16>>16<0){c[976]=e[f+6>>1]<<16|e[d>>1];c[972]=f+8}else{c[972]=f+6;c[976]=e[d>>1]}if((dh()|0)<-1){j=rd(4)|0;c[j>>2]=5;Te(j|0,8,0)}a=c[971]|0;switch(b[a>>1]|0){case 4:{a=c[c[a+28>>2]>>2]|0;break}case 3:{a=~~+h[c[a+28>>2]>>3];break}default:{j=rd(4)|0;c[j>>2]=6;Te(j|0,8,0)}}if(a)return 0}c[973]=i;a=f+(g+2<<1)|0;c[972]=a;j=b[i>>1]|0;b[14216]=j;i=j&65535;c[974]=i&24576;c[975]=i&4095;if(j<<16>>16<0){c[976]=e[f+(g+3<<1)>>1]<<16|e[a>>1];c[972]=f+(g+4<<1);return 0}else{c[972]=f+(g+3<<1);c[976]=e[a>>1];return 0}return 0}function oi(a,b){a=a|0;b=b|0;c[a>>2]=4;do switch(b|0){case 0:{c[1053]=0;a=4212;return a|0}case 1:{c[1053]=c[(c[977]|0)+780>>2];a=4212;return a|0}case 2:{c[1053]=13571;a=4212;return a|0}case 3:{c[1053]=c[(c[977]|0)+784>>2];a=4212;return a|0}case 4:{a=c[977]|0;c[1053]=c[a+260+(c[a+772>>2]<<4)+4>>2];a=4212;return a|0}case 5:{c[1053]=c[(c[977]|0)+776>>2];a=4212;return a|0}case 6:{c[1053]=c[(c[977]|0)+788>>2];a=4212;return a|0}case 7:{c[1053]=c[(c[977]|0)+772>>2];a=4212;return a|0}case 8:{c[1053]=c[(c[977]|0)+256>>2];a=4212;return a|0}case 9:{c[1053]=c[(c[977]|0)+32>>2];a=4212;return a|0}case 10:{c[1053]=c[(c[977]|0)+36>>2];a=4212;return a|0}case 11:{c[1053]=c[(c[977]|0)+40>>2];a=4212;return a|0}case 12:{c[a>>2]=2;a=c[(c[977]|0)+792>>2]|0;return a|0}case 13:{c[a>>2]=3;a=(c[977]|0)+864|0;return a|0}default:{a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}}while(0);return 0}function pi(a){a=a|0;var d=0,f=0,g=0,h=0;d=c[972]|0;c[973]=d;f=d+2|0;c[972]=f;g=b[d>>1]|0;b[14216]=g;h=g&65535;c[974]=h&24576;c[975]=h&4095;if(g<<16>>16<0){c[976]=e[d+4>>1]<<16|e[f>>1];c[972]=d+6}else{c[972]=d+4;c[976]=e[f>>1]}if((b[(c[(c[977]|0)+840>>2]|0)+(a*28|0)>>1]|0)==-1){fi(a);return 0}else{h=rd(4)|0;c[h>>2]=2;Te(h|0,8,0)}return 0}function qi(a,d){a=a|0;d=d|0;var f=0,g=0,h=0,i=0,j=0;if((b[(c[(c[977]|0)+840>>2]|0)+(d*28|0)>>1]|0)!=-2){h=rd(4)|0;c[h>>2]=2;Te(h|0,8,0)}h=c[1052]|0;c[1052]=-1;if(c[975]|0){h=rd(4)|0;c[h>>2]=32;Te(h|0,8,0)}if((c[976]|0)!=40){h=rd(4)|0;c[h>>2]=32;Te(h|0,8,0)}f=c[972]|0;c[973]=f;g=f+2|0;c[972]=g;i=b[f>>1]|0;b[14216]=i;j=i&65535;c[974]=j&24576;c[975]=j&4095;if(i<<16>>16<0){c[976]=e[f+4>>1]<<16|e[g>>1];c[972]=f+6}else{c[972]=f+4;c[976]=e[g>>1]}fi(d);c[a>>2]=c[1052];switch(c[1052]|0){case 2:{d=c[(c[977]|0)+792>>2]|0;break}case 3:{d=(c[977]|0)+864|0;break}case 4:{d=(c[977]|0)+784|0;break}default:{j=(c[(c[977]|0)+236>>2]|0)==4;f=rd(4)|0;if(j){c[f>>2]=0;Te(f|0,8,0)}else{c[f>>2]=40;Te(f|0,8,0)}}}if(c[975]|0){j=rd(4)|0;c[j>>2]=32;Te(j|0,8,0)}if((c[976]|0)!=41){j=rd(4)|0;c[j>>2]=32;Te(j|0,8,0)}f=c[972]|0;c[973]=f;g=f+2|0;c[972]=g;j=b[f>>1]|0;b[14216]=j;i=j&65535;c[974]=i&24576;c[975]=i&4095;if(j<<16>>16<0){c[976]=e[f+4>>1]<<16|e[g>>1];c[972]=f+6;c[1052]=h;return d|0}else{c[972]=f+4;c[976]=e[g>>1];c[1052]=h;return d|0}return 0}function ri(){var a=0,d=0,f=0,g=0,h=0,i=0;a=c[1737]|0;if((a|0)==(c[1736]|0)){i=rd(4)|0;c[i>>2]=10;Te(i|0,8,0)}i=c[a+-76>>2]|0;a:do if((b[a+-80>>1]|0)==257?(d=c[i+8>>2]|0,g=i+20|0,h=d+8|0,(c[h>>2]|0)>0):0){f=0;a=(c[(c[977]|0)+836>>2]|0)+(c[d+4>>2]<<3)|0;while(1){switch(b[a>>1]|0){case -6:{Nl(c[g+(c[a+4>>2]|0)>>2]|0);break}case -1:{d=g+(c[a+4>>2]|0)|0;Kf[c[(c[6908>>2]|0)+((b[d>>1]<<16>>16)*140|0)+52>>2]&1023](d);break}default:{}}f=f+1|0;if((f|0)>=(c[h>>2]|0))break a;else a=a+8|0}}while(0);c[972]=c[i+4>>2];c[(c[977]|0)+828>>2]=c[i+12>>2];a=(c[977]|0)+256|0;c[a>>2]=(c[a>>2]|0)+-1;a=c[972]|0;c[973]=a;d=a+2|0;c[972]=d;i=b[a>>1]|0;b[14216]=i;h=i&65535;c[974]=h&24576;c[975]=h&4095;if(i<<16>>16<0){c[976]=e[a+4>>1]<<16|e[d>>1];c[972]=a+6}else{c[972]=a+4;c[976]=e[d>>1]}i=c[1737]|0;c[1737]=i+-80;if(!(b[i+-78>>1]|0))return;Hl();return}function si(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;f=a+38|0;e=b[f>>1]|0;if(e<<16>>16>4){a=rd(4)|0;c[a>>2]=7;Te(a|0,8,0)}if(!(e<<16>>16)){c[a+44>>2]=1;h=1}else{g=a+44|0;h=$(c[g>>2]|0,c[a+4+(e<<16>>16<<2)>>2]|0)|0;c[g>>2]=h}g=e+1<<16>>16;b[f>>1]=g;if((d|0)<0){a=rd(4)|0;c[a>>2]=7;Te(a|0,8,0)}e=g<<16>>16;if((c[a+4+(e<<2)>>2]|0)>(d|0)){d=$(h,d)|0;a=a+40|0;c[a>>2]=(c[a>>2]|0)+d;return}if(g<<16>>16<=3?(c[a+4+(e+1<<2)>>2]|0)!=0:0){a=rd(4)|0;c[a>>2]=7;Te(a|0,8,0)}if(!(b[a+36>>1]&8)){a=rd(4)|0;c[a>>2]=7;Te(a|0,8,0)}cj(a,e,d+1|0);d=$(c[a+44>>2]|0,d)|0;a=a+40|0;c[a>>2]=(c[a>>2]|0)+d;return}function ti(a){a=a|0;return c[(c[(c[1059]|0)+32>>2]|0)+(a<<2)>>2]|0}function ui(a,b){a=a|0;b=b|0;var d=0,e=0;if((b|0)>95){a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}switch(b|0){case 64:{b=(c[1060]|0)+784|0;d=4;e=4;break}case 65:{b=c[(c[1060]|0)+792>>2]|0;d=1024;e=2;break}case 68:{b=c[1060]|0;d=888;e=4;break}default:{a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}}_i(a,e,b,d);return}function vi(a){a=a|0;var b=0,d=0,e=0;c[1060]=c[a+4>>2];d=c[a+8>>2]|0;c[1061]=c[d+24>>2];c[1062]=c[d+28>>2];b=Z5(68)|0;o=0;Ja(408,b|0);e=o;o=0;if(e&1){e=zc()|0;$5(b);Kc(e|0)}c[1059]=b;c[1063]=c[c[b+32>>2]>>2];pl((c[1060]|0)+784|0);b=Z5(12)|0;o=0;Ja(409,b|0);e=o;o=0;if(e&1){e=zc()|0;$5(b);Kc(e|0)}c[1064]=b;dp(b,c[(c[1060]|0)+856>>2]|0);b=Z5(544)|0;o=0;Ja(410,b|0);e=o;o=0;if(!(e&1)){c[1065]=b;c[a+12>>2]=113;c[a+20>>2]=114;c[d+20>>2]=4264;c[d+72>>2]=115;c[d+172>>2]=93;return}e=zc()|0;$5(b);Kc(e|0)}function wi(a){a=a|0;c[a+16>>2]=37;return}function xi(){return (c[1059]|0)+44|0}function yi(d){d=d|0;var e=0,f=0.0,j=0,k=0,l=0.0,m=0.0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0,_=0,$=0,aa=0.0,ba=0.0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0;Za=i;i=i+17632|0;D=Za+72|0;F=Za+56|0;E=Za+48|0;C=Za+24|0;Ta=Za+1240|0;na=Za+984|0;Sa=Za+472|0;Wa=Za+468|0;Ya=Za+464|0;Xa=Za+460|0;Ua=Za+456|0;x=Za+452|0;Va=Za+448|0;y=Za+444|0;z=Za+440|0;j=Za+436|0;p=Za+432|0;ua=Za+428|0;Oa=Za+424|0;Pa=Za+420|0;ga=Za+416|0;va=Za+412|0;Ca=Za+408|0;Ea=Za+396|0;Fa=Za+384|0;Na=Za+380|0;wa=Za+376|0;xa=Za+372|0;za=Za+368|0;q=Za+364|0;r=Za+360|0;s=Za+356|0;t=Za+352|0;u=Za+348|0;Aa=Za+344|0;v=Za+340|0;ha=Za+336|0;ja=Za+332|0;la=Za+328|0;Da=Za+312|0;da=Za+16|0;ea=Za+8|0;fa=Za;ia=Za+304|0;ka=Za+300|0;ma=Za+296|0;Ka=Za+280|0;La=Za+264|0;Qa=Za+248|0;w=Za+244|0;Ba=Za+240|0;B=Za+224|0;pa=Za+208|0;oa=Za+192|0;Ha=Za+176|0;ra=Za+160|0;Ia=Za+144|0;sa=Za+128|0;Ga=Za+112|0;k=Za+104|0;A=Za+88|0;e=Za+80|0;n=Za+76|0;ah();do switch(d|0){case 0:{do if((c[c[1061]>>2]|0)==15){e=c[c[1062]>>2]|0;if((e|0)>1){Za=rd(4)|0;c[Za>>2]=2;Te(Za|0,8,0)}else{ah();break}}else e=0;while(0);I8(Ta,eh()|0,255)|0;Ya=oh()|0;ah();e=vl(c[1063]|0,Ta,e,Ya)|0;c[(c[1060]|0)+784>>2]=e;e=c[(c[1063]|0)+188>>2]|0;c[Wa>>2]=e;if((e|0)>-1){Kk(c[1059]|0,e)|0;Ya=c[1063]|0;wl(Ya,c[(c[1060]|0)+784>>2]|0,c[Wa>>2]|0,b[Ya+192>>1]|0,b[Ya+194>>1]|0,b[Ya+196>>1]|0,b[Ya+198>>1]|0,b[Ya+200>>1]|0,b[Ya+202>>1]|0)}Ya=0;i=Za;return Ya|0}case 2:{xh(eh()|0)|0;c[Wa>>2]=ih(0)|0;fh(63688)|0;Ya=c[1060]|0;c[Ya+240>>2]=0;c[Ya+236>>2]=1;Ya=1;i=Za;return Ya|0}case 3:{Xa=c[1060]|0;c[Xa+240>>2]=0;c[Xa+236>>2]=1;I8(Ta,gh(63688)|0,16383)|0;Xa=qo(ih(0)|0,Ta,fh(63688)|0)|0;Ya=c[1060]|0;c[Ya+784>>2]=Xa;Ya=c[Ya+236>>2]|0;i=Za;return Ya|0}case 8:{I8(Ta,eh()|0,255)|0;c[Wa>>2]=ih(0)|0;Xa=ih(0)|0;c[Ya>>2]=Xa;if(ep(c[1064]|0,Ta,c[Wa>>2]|0,Xa)|0){Za=rd(4)|0;c[Za>>2]=12;Te(Za|0,8,0)}Ya=0;i=Za;return Ya|0}case 9:{Ya=ih(0)|0;c[Wa>>2]=Ya;fp(c[1064]|0,Ya)|0;Ya=0;i=Za;return Ya|0}case 10:{Ya=ih(-1)|0;c[Wa>>2]=Ya;jp(c[1064]|0,Ya);Ya=0;i=Za;return Ya|0}case 12:{Va=ih(c[(c[1063]|0)+68>>2]|0)|0;c[Wa>>2]=Va;Xa=ih(c[(c[1063]|0)+72>>2]|0)|0;c[Ya>>2]=Xa;Zk(c[1063]|0,Va,Xa);Ya=0;i=Za;return Ya|0}case 15:{if((dh()|0)<-1){Ya=0;i=Za;return Ya|0}e=c[971]|0;e=rf[c[(c[6908>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&255](e)|0;j=b[c[971]>>1]|0;if(j<<16>>16!=2)e=dg[c[(c[6908>>2]|0)+300>>2]&127](e,j<<16>>16)|0;Xk(c[1063]|0,e);Ya=0;i=Za;return Ya|0}case 16:{Ya=eh()|0;Rk(c[1063]|0,Ya);Ya=0;i=Za;return Ya|0}case 17:{Xa=ih(c[(c[1063]|0)+68>>2]|0)|0;Ya=c[1063]|0;c[Ya+68>>2]=Xa;Ya=ih(c[Ya+72>>2]|0)|0;c[(c[1063]|0)+72>>2]=Ya;Ya=0;i=Za;return Ya|0}case 18:{Ua=ih(0)|0;c[Wa>>2]=Ua;Va=ih(0)|0;c[Ya>>2]=Va;Wa=ih(c[(c[1063]|0)+4>>2]|0)|0;c[Xa>>2]=Wa;Xa=ih(c[(c[1063]|0)+8>>2]|0)|0;Ya=ih(1)|0;$k(c[1063]|0,Ua,Va,Wa,Xa,Ya);Ya=0;i=Za;return Ya|0}case 19:{Ya=ih(0)|0;c[Wa>>2]=Ya;Mk(c[1063]|0,Ya);Ya=0;i=Za;return Ya|0}case 20:{I8(Ta,eh()|0,255)|0;c[Wa>>2]=ih(12)|0;Xa=ih(0)|0;c[Ya>>2]=Xa;Nk(c[1063]|0,Ta,c[Wa>>2]|0,Xa);Ya=0;i=Za;return Ya|0}case 22:{Va=ih(64)|0;c[Wa>>2]=Va;c[Ya>>2]=ih(24)|0;c[Xa>>2]=ih(0)|0;Wa=c[1063]|0;c[Wa+76>>2]=Va;c[Wa+80>>2]=c[Ya>>2];c[Wa+84>>2]=c[Xa>>2];Ya=0;i=Za;return Ya|0}case 23:{I8(Ta,eh()|0,63)|0;Ya=ih(0)|0;c[Wa>>2]=Ya;Jk(c[1059]|0,c[(c[1063]|0)+32>>2]|0,Ta,Ya)|0;Ya=0;i=Za;return Ya|0}case 24:{Va=ih(0)|0;c[Wa>>2]=Va;Wa=ih(0)|0;c[Ya>>2]=Wa;Ya=ih(0)|0;c[Xa>>2]=Ya;Ok(c[1063]|0,Va,Wa,Ya);Ya=0;i=Za;return Ya|0}case 27:{j=ih(1)|0;c[Wa>>2]=j;c[Ya>>2]=ih(0)|0;c[Xa>>2]=ih(0)|0;ih(0)|0;ih(0)|0;e=(j&16|0)==0;if(!(j&1)){if(!e){xl(c[1063]|0)|0;Vk(c[1063]|0);Ya=0;i=Za;return Ya|0}}else if(e){xl(c[1063]|0)|0;Vk(c[1063]|0)}e=cm(33)|0;if((e|0)>-1)e=Kk(c[1059]|0,e)|0;else e=0;ko(e);Ya=po(c[1063]|0,j)|0;c[(c[1060]|0)+784>>2]=Ya;Ya=0;i=Za;return Ya|0}case 28:{c[Wa>>2]=ih(-1)|0;c[Ya>>2]=ih(-1)|0;c[Xa>>2]=ih(-1)|0;ih(-1)|0;Ya=0;i=Za;return Ya|0}case 29:{Xa=ih(0)|0;c[Wa>>2]=Xa;c[Ya>>2]=ih(0)|0;c[1063]=Kk(c[1059]|0,Xa)|0;c[1066]=Xa;Ya=0;i=Za;return Ya|0}case 30:{Ua=ih(0)|0;c[Wa>>2]=Ua;Va=ih(0)|0;c[Ya>>2]=Va;Wa=ih(0)|0;c[Xa>>2]=Wa;Xa=ih(c[(c[1063]|0)+92>>2]|0)|0;Ya=ih(c[(c[1063]|0)+96>>2]|0)|0;Ua=Kk(c[1059]|0,Ua)|0;if(!(al(c[1063]|0,Ua,Va,Wa,Xa,Ya)|0)){Ya=0;i=Za;return Ya|0}else{Za=rd(4)|0;c[Za>>2]=21;Te(Za|0,8,0)}}case 31:{Sa=ih(c[(c[1063]|0)+4>>2]|0)|0;c[Wa>>2]=Sa;d=ih(c[(c[1063]|0)+8>>2]|0)|0;c[Ya>>2]=d;Qa=ih(0)|0;c[Xa>>2]=Qa;Ta=ih(0)|0;Va=ih(0)|0;Wa=ih(c[(c[1063]|0)+92>>2]|0)|0;c[Ua>>2]=Wa;Xa=ih(c[(c[1063]|0)+96>>2]|0)|0;Ya=ih(0)|0;Ua=Kk(c[1059]|0,Qa)|0;if(!(bl(c[1063]|0,Sa,d,Ua,Ta,Va,Wa,Xa,Ya)|0)){Ya=0;i=Za;return Ya|0}else{Za=rd(4)|0;c[Za>>2]=21;Te(Za|0,8,0)}}case 32:{Ua=ih(0)|0;c[Wa>>2]=Ua;c[Ya>>2]=ih(32)|0;c[Xa>>2]=ih(32)|0;Va=ih(0)|0;Wa=c[1063]|0;c[Wa+100>>2]=Ua;c[Wa+92>>2]=c[Ya>>2];c[Wa+96>>2]=c[Xa>>2];c[Wa+144>>2]=Va;Ya=0;i=Za;return Ya|0}case 33:if(!(cl(c[1063]|0,eh()|0)|0)){Ya=0;i=Za;return Ya|0}else{Za=rd(4)|0;c[Za>>2]=12;Te(Za|0,8,0)}case 34:{Va=ih(0)|0;c[Wa>>2]=Va;Wa=ih(0)|0;c[Ya>>2]=Wa;Ya=ih(0)|0;c[Xa>>2]=Ya;dl(c[1063]|0,Va,Wa,Ya);Ya=0;i=Za;return Ya|0}case 35:{Xa=mh(x)|0;c[Wa>>2]=ih(1)|0;c[Ya>>2]=0;rh(c[x>>2]|0,Xa,4,Ya);Ya=0;i=Za;return Ya|0}case 39:{p=mh(Va)|0;c[Ya>>2]=ih(16384)|0;c[Xa>>2]=ih(0)|0;e=c[Ya>>2]|0;if((e|0)<64){c[Ya>>2]=64;e=64}e=wh(e+1|0)|0;a:do switch(c[Xa>>2]&15|0){case 0:{if((c[Ya>>2]|0)<1)k=0;else{k=0;while(1){j=Q7()|0;if((j|0)==-1)break a;n=e+1|0;a[e>>0]=j;Wa=c[Ya>>2]|0;c[Ya>>2]=Wa+-1;k=k+1|0;if((Wa|0)<2){e=n;break}else e=n}}break}case 1:{if((c[Ya>>2]|0)<1)k=0;else{n=e;k=0;while(1){j=Q7()|0;switch(j|0){case 10:case -1:{e=n;break a}default:{}}e=n+1|0;a[n>>0]=j;Wa=c[Ya>>2]|0;c[Ya>>2]=Wa+-1;k=k+1|0;if((Wa|0)<2)break a;else n=e}}break}case 2:{if((c[Ya>>2]|0)>=1){n=e;k=0;b:while(1){j=Q7()|0;switch(j|0){case 10:case -1:{e=n;break a}case 13:{e=n;break b}default:{}}e=n+1|0;a[n>>0]=j;Wa=c[Ya>>2]|0;c[Ya>>2]=Wa+-1;k=k+1|0;if((Wa|0)<2)break a;else n=e}j=Q7()|0;if((j|0)!=10)Y7(j,c[6858]|0)|0}else k=0;break}default:k=0}while(0);a[e>>0]=0;j=c[1060]|0;c[j+788>>2]=k+1;e=c[Va>>2]|0;if(!(c[Xa>>2]&16)){rh(e,p,2,c[j+824>>2]|0);Ya=0;i=Za;return Ya|0}if(!(b[e+36>>1]&2)){Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}c[e+40>>2]=p;Ya=rf[c[(c[6908>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&255](e)|0;K9(Ya|0,c[(c[1060]|0)+824>>2]|0,k|0)|0;Ya=0;i=Za;return Ya|0}case 43:case 42:case 41:{p=ih(0)|0;c[Wa>>2]=p;n=ih(640)|0;c[Ya>>2]=n;k=ih(480)|0;c[Xa>>2]=k;ih(0)|0;e=ih(-1)|0;j=ih(-1)|0;c[Ua>>2]=j;ih(n)|0;ih(k)|0;do if((d|0)==41)if(!p){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Hk(c[1059]|0,p,1,e,j,n,k);break}while(0);c[1063]=c[(c[(c[1059]|0)+32>>2]|0)+(p<<2)>>2];c[1066]=p;Ya=0;i=Za;return Ya|0}case 47:{c[Wa>>2]=ih(0)|0;c[Ya>>2]=ih(0)|0;Xa=ih(c[(c[1063]|0)+68>>2]|0)|0;Va=c[1063]|0;c[Va+68>>2]=Xa;Va=ih(c[Va+72>>2]|0)|0;Xa=c[1063]|0;c[Xa+72>>2]=Va;_k(Xa,c[Wa>>2]|0,c[Ya>>2]|0);Ya=0;i=Za;return Ya|0}case 48:{n=ih(0)|0;c[Wa>>2]=n;e=ih(-1)|0;c[Ya>>2]=e;k=c[1063]|0;Wa=c[k+168>>2]|0;j=Wa+-1|0;if((Wa|0)<1){Ya=0;i=Za;return Ya|0}if(n>>>31|(e|0)>(j|0)|(n|0)>(j|0)){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}if((e|0)<0)c[Ya>>2]=j;else j=e;c[Xa>>2]=n;if((n|0)>(j|0)){Ya=0;i=Za;return Ya|0}rl(k,n);e=n+1|0;c[Xa>>2]=e;if((n|0)>=(j|0)){Ya=0;i=Za;return Ya|0}do{rl(c[1063]|0,e);Ya=e;e=e+1|0;c[Xa>>2]=e}while((Ya|0)<(j|0));e=0;i=Za;return e|0}case 49:{Ua=ih(0)|0;c[Wa>>2]=Ua;Va=ih(0)|0;c[Ya>>2]=Va;Wa=ih(c[(c[1063]|0)+4>>2]|0)|0;c[Xa>>2]=Wa;Ya=ih(c[(c[1063]|0)+8>>2]|0)|0;Yk(c[1063]|0,Ua,Va,Wa,Ya);Ya=0;i=Za;return Ya|0}case 52:{Xa=mh(y)|0;c[Wa>>2]=ih(0)|0;Va=ih(1)|0;c[Ya>>2]=Va;Va=oo(Va)|0;c[1076]=Va;Ya=Va&~c[1077];c[1078]=Ya;c[1077]=Va;c[z>>2]=c[Wa>>2]&Va|Ya;rh(c[y>>2]|0,Xa,4,z);Ya=0;i=Za;return Ya|0}case 53:{Ua=ih(0)|0;c[Wa>>2]=Ua;Va=ih(0)|0;c[Ya>>2]=Va;ba=+kh(0.0);Wa=ih(c[(c[1063]|0)+92>>2]|0)|0;c[Xa>>2]=Wa;Ya=ih(c[(c[1063]|0)+96>>2]|0)|0;gl(c[1063]|0,Ua,Va,Wa,Ya,ba);Ya=0;i=Za;return Ya|0}case 54:{d=ih(0)|0;c[Wa>>2]=d;Va=ih(0)|0;c[Ya>>2]=Va;Wa=ih(0)|0;c[Xa>>2]=Wa;ba=+kh(0.0);Ta=ih(c[(c[1063]|0)+92>>2]|0)|0;Ua=ih(c[(c[1063]|0)+96>>2]|0)|0;Xa=Kk(c[1059]|0,d)|0;Ya=c[1063]|0;hl(Ya,Ta,Ua,ba,Xa,Va,Wa,c[Ya+92>>2]|0,c[Ya+96>>2]|0);Ya=0;i=Za;return Ya|0}case 55:{r=ih(0)|0;e=nh()|0;if((b[e>>1]|0)!=4){Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}c[e+40>>2]=0;q=rf[c[(c[6908>>2]|0)+588>>2]&255](e)|0;e=nh()|0;if((b[e>>1]|0)!=4){Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}c[e+40>>2]=0;p=rf[c[(c[6908>>2]|0)+588>>2]&255](e)|0;do if((r|0)>-1){j=Kk(c[1059]|0,r)|0;e=nh()|0;if((b[e>>1]|0)!=4){Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}c[e+40>>2]=0;e=rf[c[(c[6908>>2]|0)+588>>2]&255](e)|0;n=nh()|0;if((b[n>>1]|0)==4){c[n+40>>2]=0;k=e;e=rf[c[(c[6908>>2]|0)+588>>2]&255](n)|0;break}else{Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}}else if((r|0)==-257){e=nh()|0;if((b[e>>1]|0)==4){c[e+40>>2]=0;j=0;k=rf[c[(c[6908>>2]|0)+588>>2]&255](e)|0;e=0;break}else{Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}}else{j=0;k=0;e=0}while(0);fl(c[1063]|0,q,p,j,k,e,r);Ya=0;i=Za;return Ya|0}case 56:{Sa=ih(0)|0;c[Wa>>2]=Sa;d=ih(0)|0;c[Ya>>2]=d;Ta=ih(c[(c[1063]|0)+4>>2]|0)|0;c[Xa>>2]=Ta;Va=ih(c[(c[1063]|0)+8>>2]|0)|0;Wa=ih(0)|0;Xa=ih(0)|0;Ya=ih(0)|0;c[Ua>>2]=Ya;el(c[1063]|0,Sa,d,Ta,Va,Wa,Xa,Ya);Ya=0;i=Za;return Ya|0}case 57:{Ya=ih(-1)|0;c[Wa>>2]=Ya;c[(c[1063]|0)+188>>2]=Ya;Ya=(ih(0)|0)&65535;b[(c[1063]|0)+192>>1]=Ya;Ya=(ih(0)|0)&65535;b[(c[1063]|0)+194>>1]=Ya;Ya=(ih(0)|0)&65535;b[(c[1063]|0)+196>>1]=Ya;Ya=(ih(0)|0)&65535;Xa=c[1063]|0;b[Xa+198>>1]=Ya;Xa=(ih(b[Xa+192>>1]|0)|0)&65535;Ya=c[1063]|0;b[Ya+200>>1]=Xa;Ya=(ih(b[Ya+194>>1]|0)|0)&65535;b[(c[1063]|0)+202>>1]=Ya;Ya=0;i=Za;return Ya|0}case 58:{Va=ih(0)|0;c[Wa>>2]=Va;Xa=ih(2)|0;c[Ya>>2]=Xa;tl(c[1063]|0,Va,Xa);Ya=0;i=Za;return Ya|0}case 59:{Va=ih(0)|0;c[Wa>>2]=Va;Xa=ih(1)|0;c[Ya>>2]=Xa;sl(c[1063]|0,Va,Xa);Ya=0;i=Za;return Ya|0}case 60:{I8(Ta,eh()|0,63)|0;c[Wa>>2]=ih(-1)|0;c[Ya>>2]=ih(0)|0;e=c[Wa>>2]|0;if((e|0)<0){e=Lk(c[1059]|0)|0;c[Wa>>2]=e}Ik(c[1059]|0,e,Ta);c[(c[1060]|0)+784>>2]=c[Wa>>2];Ya=0;i=Za;return Ya|0}case 61:{Ua=ih(1)|0;c[Wa>>2]=Ua;Va=ih(0)|0;c[Ya>>2]=Va;Wa=ih(0)|0;c[Xa>>2]=Wa;Xa=ih(0)|0;Ya=ih(0)|0;Qk(Kk(c[1059]|0,Ua)|0,Va,Wa,Xa,Ya);Ya=0;i=Za;return Ya|0}case 62:{e=ih(1)|0;c[Wa>>2]=e;k=ih(0)|0;c[Ya>>2]=k;f=+kh(1.0);l=+kh(1.0);m=+kh(0.0);e=Kk(c[1059]|0,e)|0;j=c[1063]|0;if(l==1.0&(f==1.0&m==0.0)){jl(j,e,k)|0;Ya=0;i=Za;return Ya|0}else{il(j,e,k,f,l,m)|0;Ya=0;i=Za;return Ya|0}}case 63:{Ya=ih(0)|0;c[Wa>>2]=Ya;kl(c[1063]|0,Ya);Ya=0;i=Za;return Ya|0}case 64:{Va=ih(0)|0;c[Wa>>2]=Va;Xa=ih(0)|0;c[Ya>>2]=Xa;qm(c[1882]|0,Va,Xa);bm(Va,Xa);Ya=0;i=Za;return Ya|0}case 65:{Xa=mh(j)|0;Va=ih(0)|0;c[Wa>>2]=Va;rm(c[1882]|0,Va);c[Ya>>2]=cm(c[Wa>>2]|0)|0;rh(c[j>>2]|0,Xa,4,Ya);Ya=0;i=Za;return Ya|0}case 66:{Va=ih(0)|0;c[Wa>>2]=Va;Xa=ih(0)|0;c[Ya>>2]=Xa;gp(c[1064]|0,Va,Xa);Ya=0;i=Za;return Ya|0}case 67:{c[Wa>>2]=ih(0)|0;c[Ya>>2]=ih(0)|0;Ya=0;i=Za;return Ya|0}case 68:{Va=mh(p)|0;c[Wa>>2]=ih(0)|0;Ua=ih(0)|0;c[Ya>>2]=Ua;c[Xa>>2]=ip(c[1064]|0,c[Wa>>2]|0,Ua)|0;rh(c[p>>2]|0,Va,4,Xa);Ya=0;i=Za;return Ya|0}case 69:{e=sh(Ta,na)|0;j=c[Ta>>2]|0;if((b[j>>1]|0)!=4){c[Sa>>2]=0;rh(j,0,4,Sa);e=c[Ta>>2]|0;c[e+40>>2]=0;e=rf[c[(c[6908>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&255](e)|0;j=c[Ta>>2]|0}Ya=ol(c[1063]|0,e)|0;Xa=j;Wa=(Ya|0)<1?1:Ya;c[Xa+8>>2]=Wa;c[Xa+24>>2]=Wa<<2;c[(c[1060]|0)+784>>2]=Ya;Ya=0;i=Za;return Ya|0}case 70:{j=sh(Ta,na)|0;e=c[Ta>>2]|0;if((b[e>>1]|0)==4)k=e;else{c[Sa>>2]=0;rh(e,0,4,Sa);j=c[Ta>>2]|0;c[j+40>>2]=0;j=rf[c[(c[6908>>2]|0)+((b[j>>1]<<16>>16)*140|0)+28>>2]&255](j)|0;k=c[Ta>>2]|0}e=ih(0)|0;c[Wa>>2]=e;e=nl(c[1063]|0,e)|0;Ya=k;c[Ya+8>>2]=4;c[Ya+24>>2]=16;if(!e){c[j>>2]=-1;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[(c[1060]|0)+784>>2]=-1;Ya=0;i=Za;return Ya|0}else{c[j>>2]=c[e>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2];c[j+12>>2]=c[e+12>>2];c[(c[1060]|0)+784>>2]=c[e>>2];Ya=0;i=Za;return Ya|0}}case 71:{e=mh(ua)|0;j=eh()|0;j=rf[c[(c[4236>>2]|0)+64>>2]&255](j)|0;if(!j)e=-1;else{rh(c[ua>>2]|0,e,2,j);e=0}c[(c[1060]|0)+784>>2]=e;Ya=0;i=Za;return Ya|0}case 72:{j=sh(Ta,na)|0;e=c[Ta>>2]|0;if((b[e>>1]|0)==4)k=e;else{c[Sa>>2]=0;rh(e,0,4,Sa);j=c[Ta>>2]|0;c[j+40>>2]=0;j=rf[c[(c[6908>>2]|0)+((b[j>>1]<<16>>16)*140|0)+28>>2]&255](j)|0;k=c[Ta>>2]|0}e=eh()|0;e=dg[c[(c[4236>>2]|0)+60>>2]&127](e,Oa)|0;if(!e){c[Oa>>2]=-1;e=-1}else{Ya=k;Xa=c[Oa>>2]|0;Xa=(Xa|0)<1?1:Xa;c[Ya+8>>2]=Xa;c[Ya+24>>2]=Xa<<2;K9(j|0,e|0,c[Oa>>2]<<2|0)|0;e=c[Oa>>2]|0}c[(c[1060]|0)+784>>2]=e;Ya=0;i=Za;return Ya|0}case 73:{I8(Ta,eh()|0,255)|0;Ya=eh()|0;Ya=dg[c[(c[4236>>2]|0)+52>>2]&127](Ta,Ya)|0;c[(c[1060]|0)+784>>2]=Ya;Ya=0;i=Za;return Ya|0}case 74:{Ua=xh(eh()|0)|0;Va=ih(0)|0;c[Wa>>2]=Va;Wa=ih(0)|0;c[Ya>>2]=Wa;Ya=ih(0)|0;c[Xa>>2]=Ya;Ya=qg[c[(c[4236>>2]|0)+56>>2]&63](Ua,Va,Wa,Ya)|0;c[(c[1060]|0)+784>>2]=Ya;Ya=0;i=Za;return Ya|0}case 75:{Xa=xh(eh()|0)|0;Ya=fh(63688)|0;Ya=mp(c[1065]|0,Xa,(a[Ya>>0]|0)==0?0:Ya)|0;c[(c[1060]|0)+784>>2]=Ya;Ya=0;i=Za;return Ya|0}case 76:{k=mh(Pa)|0;e=ih(0)|0;c[Wa>>2]=e;j=c[1065]|0;if(!(e&16)){c[Ya>>2]=np(j,e)|0;rh(c[Pa>>2]|0,k,4,Ya);Ya=0;i=Za;return Ya|0}e=op(j,e)|0;j=c[Pa>>2]|0;if((c[Wa>>2]|0)!=16){rh(j,k,2,e);Ya=0;i=Za;return Ya|0}if((b[j>>1]|0)!=2)rh(j,k,2,63688);Ya=np(c[1065]|0,1)|0;Xa=c[Pa>>2]|0;c[Xa+40>>2]=k;Xa=rf[c[(c[6908>>2]|0)+((b[Xa>>1]<<16>>16)*140|0)+28>>2]&255](Xa)|0;Wa=c[Pa>>2]|0;tg[c[(c[6908>>2]|0)+((b[Wa>>1]<<16>>16)*140|0)+68>>2]&255](Wa,Xa,Ya+1|0);Xa=c[Pa>>2]|0;c[Xa+40>>2]=k;Xa=rf[c[(c[6908>>2]|0)+((b[Xa>>1]<<16>>16)*140|0)+28>>2]&255](Xa)|0;K9(Xa|0,e|0,Ya|0)|0;a[Xa+Ya>>0]=0;pp(c[1065]|0,16,63688);Ya=0;i=Za;return Ya|0}case 93:{Va=ih(255)|0;c[Wa>>2]=Va;Wa=ih(255)|0;c[Ya>>2]=Wa;Ya=ih(255)|0;c[Xa>>2]=Ya;Pk(c[1063]|0,Va,Wa,Ya);Ya=0;i=Za;return Ya|0}case 94:{Va=ih(0)|0;c[Wa>>2]=Va;Wa=ih(0)|0;c[Ya>>2]=Wa;Ya=ih(-1)|0;c[Xa>>2]=Ya;go(Va,Wa,Ya);Ya=0;i=Za;return Ya|0}case 95:{e=nh()|0;if((b[e>>1]|0)!=4){Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}c[e+40>>2]=0;k=rf[c[(c[6908>>2]|0)+588>>2]&255](e)|0;e=nh()|0;if((b[e>>1]|0)!=4){Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}c[e+40>>2]=0;e=rf[c[(c[6908>>2]|0)+588>>2]&255](e)|0;j=nh()|0;if((b[j>>1]|0)!=4){Za=rd(4)|0;c[Za>>2]=6;Te(Za|0,8,0)}c[j+40>>2]=0;Va=rf[c[(c[6908>>2]|0)+588>>2]&255](j)|0;Ua=ih(0)|0;c[Wa>>2]=Ua;Xa=ih(1)|0;c[Ya>>2]=Xa;Ya=Kk(c[1059]|0,Ua)|0;Ya=Ao(c[1063]|0,k,e,Va,Xa,Ya)|0;c[(c[1060]|0)+784>>2]=Ya;Ya=0;i=Za;return Ya|0}case 96:{Ya=ih(0)|0;c[Wa>>2]=Ya;im(c[1882]|0,Ya);Ya=0;i=Za;return Ya|0}case 97:{e=ih(-1)|0;c[Wa>>2]=e;if(e&1)an(c[1882]|0);Lm(c[1882]|0,e);if(e&4)Jo(c[1063]|0,0);if(!(e&16)){Ya=0;i=Za;return Ya|0}Jo(c[1063]|0,1);Ya=0;i=Za;return Ya|0}case 98:{Ya=ih(0)|0;c[Wa>>2]=Ya;zm(c[1882]|0,Ya);Ya=0;i=Za;return Ya|0}case 99:{Va=ih(0)|0;c[Wa>>2]=Va;Wa=ih(0)|0;c[Ya>>2]=Wa;Ya=ih(0)|0;c[Xa>>2]=Ya;if((Pm(c[1882]|0,Va,Wa,Ya)|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 100:{e=mh(ga)|0;c[Wa>>2]=ih(0)|0;Xa=ih(0)|0;c[Ya>>2]=Xa;if((Om(c[1882]|0,c[Wa>>2]|0,Xa,Ua)|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}rh(c[ga>>2]|0,e,4,Ua);Ya=0;i=Za;return Ya|0}case 102:{Ya=ih(0)|0;c[Wa>>2]=Ya;En(c[1882]|0,Ya);Ya=0;i=Za;return Ya|0}case 103:{Ya=ih(0)|0;c[Wa>>2]=Ya;Cn(c[1882]|0,Ya);Ya=0;i=Za;return Ya|0}case 104:{c[Wa>>2]=ih(0)|0;I8(Ta,eh()|0,256)|0;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;e=Mn(c[1882]|0,c[Wa>>2]|0)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}Jn(e,Ta,4268)|0;Ya=0;i=Za;return Ya|0}case 105:{c[Wa>>2]=ih(0)|0;I8(Ta,eh()|0,256)|0;j=eh()|0;e=Mn(c[1882]|0,c[Wa>>2]|0)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}Ln(e,Ta,j)|0;Ya=0;i=Za;return Ya|0}case 106:{Ua=ih(0)|0;c[Wa>>2]=Ua;Va=ih(0)|0;c[Ya>>2]=Va;Wa=ih(c[(c[1063]|0)+4>>2]|0)|0;c[Xa>>2]=Wa;Ya=ih(c[(c[1063]|0)+8>>2]|0)|0;um(c[1882]|0,Ua,Va,Wa,Ya);Ya=0;i=Za;return Ya|0}case 107:{j=ih(0)|0;c[Wa>>2]=j;e=eh()|0;j=Am(c[1882]|0,j)|0;if(!j){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}Ky(j,e);Ya=0;i=Za;return Ya|0}case 108:{j=mh(va)|0;e=ih(0)|0;c[Wa>>2]=e;e=Am(c[1882]|0,e)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}c[Ca>>2]=Jy(e)|0;rh(c[va>>2]|0,j,2,Ca);Ya=0;i=Za;return Ya|0}case 109:{QH(Ea);o=0;Ja(411,Fa|0);Ya=o;o=0;c:do if(!(Ya&1)){o=0;f=+Ra(1,0.0);Ya=o;o=0;d:do if(((!(Ya&1)?(g[1067]=f,o=0,aa=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[1068]=aa,o=0,ba=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[1069]=ba,g[1070]=1.0,o=0,ca=qa(99,0)|0,Ya=o,o=0,!(Ya&1)):0){c[Wa>>2]=ca;switch(ca|0){case 0:{Y=+g[1067]*.5;aa=+g[1068]*.5;ba=+g[1069]*.5;o=0;gb(1,c[1882]|0,+-Y,+Y,+-aa,+aa,+-ba,+ba);Ya=o;o=0;if(Ya&1)break d;break}case 1:{o=0;sb(108,c[1882]|0,Ea|0,Fa|0);Ya=o;o=0;if(Ya&1)break d;o=0;gb(1,c[1882]|0,+(+g[1067]),+(+g[Fa>>2]),+(+g[1068]),+(+g[Fa+4>>2]),+(+g[1069]),+(+g[Fa+8>>2]));Ya=o;o=0;if(Ya&1)break d;break}case 2:{o=0;sb(108,c[1882]|0,Ea|0,Fa|0);Ya=o;o=0;if(Ya&1)break d;o=0;gb(1,c[1882]|0,+(+g[Ea>>2]),+(+g[1067]),+(+g[Ea+4>>2]),+(+g[1068]),+(+g[Ea+8>>2]),+(+g[1069]));Ya=o;o=0;if(Ya&1)break d;break}default:{}}o=0;Ja(412,Fa|0);Ya=o;o=0;if(Ya&1){Ma=190;break c}WH(Ea);Ya=0;i=Za;return Ya|0}while(0);e=zc()|0;o=0;Ja(412,Fa|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else ta=e}else Ma=190;while(0);if((Ma|0)==190)ta=zc()|0;o=0;Ja(412,Ea|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else{Za=ta;Kc(Za|0)}break}case 110:{Va=ih(0)|0;c[Wa>>2]=Va;Xa=ih(0)|0;c[Ya>>2]=Xa;en(c[1882]|0,Va,Xa);Ya=0;i=Za;return Ya|0}case 111:{j=mh(Na)|0;e=fn(c[1882]|0)|0;if(!e)e=-1;else e=c[e+8>>2]|0;c[Wa>>2]=e;rh(c[Na>>2]|0,j,4,Wa);Ya=0;i=Za;return Ya|0}case 112:{Ya=ih(0)|0;c[Wa>>2]=Ya;xm(c[1882]|0,Ya);Ya=0;i=Za;return Ya|0}case 113:{j=mh(wa)|0;c[Wa>>2]=ih(-1)|0;e=ih(0)|0;c[Ya>>2]=e;e=Wn(c[1882]|0,c[Wa>>2]|0,e)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}c[Ua>>2]=Sn(c[1882]|0,e,2)|0;rh(c[wa>>2]|0,j,4,Ua);Ya=0;i=Za;return Ya|0}case 114:{j=mh(xa)|0;I8(Ta,eh()|0,256)|0;e=ih(0)|0;c[Wa>>2]=e;e=Xn(c[1882]|0,Ta,e)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}c[Ua>>2]=Sn(c[1882]|0,e,2)|0;rh(c[xa>>2]|0,j,4,Ua);Ya=0;i=Za;return Ya|0}case 115:{j=mh(za)|0;I8(Ta,eh()|0,256)|0;I8(na,eh()|0,256)|0;I8(Sa,eh()|0,512)|0;c[Wa>>2]=ih(-1)|0;c[Ya>>2]=ih(0)|0;e=Vn(c[1882]|0,Ta,na,Sa)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}Pn(c[1882]|0,e,c[Wa>>2]|0,c[Ya>>2]|0);c[Ua>>2]=Sn(c[1882]|0,e,2)|0;rh(c[za>>2]|0,j,4,Ua);Ya=0;i=Za;return Ya|0}case 116:{Ya=mh(q)|0;Xa=ih(0)|0;c[Wa>>2]=Xa;c[Ua>>2]=Zm(c[1882]|0,Xa)|0;rh(c[q>>2]|0,Ya,4,Ua);Ya=0;i=Za;return Ya|0}case 117:{Ya=mh(r)|0;I8(Ta,eh()|0,256)|0;Xa=fh(63688)|0;c[Ua>>2]=Ym(c[1882]|0,Ta,(a[Xa>>0]|0)==0?0:Xa)|0;rh(c[r>>2]|0,Ya,4,Ua);Ya=0;i=Za;return Ya|0}case 118:{Xa=mh(s)|0;g[1079]=+kh(1.0);g[1080]=+kh(1.0);c[Wa>>2]=ih(-1)|0;Va=ih(-1)|0;c[Ya>>2]=Va;c[Ua>>2]=Vm(c[1882]|0,+g[1079],+g[1080],c[Wa>>2]|0,Va)|0;rh(c[s>>2]|0,Xa,4,Ua);Ya=0;i=Za;return Ya|0}case 119:{Xa=mh(t)|0;g[1079]=+kh(1.0);g[1080]=+kh(1.0);c[Wa>>2]=ih(-1)|0;Va=ih(-1)|0;c[Ya>>2]=Va;c[Ua>>2]=Tm(c[1882]|0,+g[1079],+g[1080],c[Wa>>2]|0,Va)|0;rh(c[t>>2]|0,Xa,4,Ua);Ya=0;i=Za;return Ya|0}case 120:{Xa=mh(u)|0;g[1079]=+kh(1.0);c[Wa>>2]=ih(-1)|0;Va=ih(-1)|0;c[Ya>>2]=Va;c[Ua>>2]=Wm(c[1882]|0,+g[1079],c[Wa>>2]|0,Va)|0;rh(c[u>>2]|0,Xa,4,Ua);Ya=0;i=Za;return Ya|0}case 121:{j=mh(Aa)|0;c[Wa>>2]=ih(0)|0;c[Ya>>2]=ih(0)|0;c[Xa>>2]=ih(3)|0;e=Kk(c[1059]|0,c[Wa>>2]|0)|0;if(!e)bh(3);c[Ua>>2]=Sm(c[1882]|0,c[Ya>>2]|0,c[Xa>>2]|0,e)|0;rh(c[Aa>>2]|0,j,4,Ua);Ya=0;i=Za;return Ya|0}case 122:{Va=ih(0)|0;c[Wa>>2]=Va;Xa=ih(0)|0;c[Ya>>2]=Xa;g[1079]=+kh(1.0);g[1080]=+kh(.5);ba=+kh(1.0);g[1081]=ba;Ya=Dn(c[1882]|0,Va,Xa,+g[1079],+g[1080],ba)|0;c[Ua>>2]=Ya;if((Ya|0)>=0){Ya=0;i=Za;return Ya|0}bh(3);Ya=0;i=Za;return Ya|0}case 123:{e=ih(0)|0;c[Wa>>2]=e;c[Ya>>2]=ih(0)|0;c[Xa>>2]=ih(0)|0;e=Em(c[1882]|0,e)|0;if(!e)bh(3);e=e+4|0;j=c[e>>2]|0;c[(c[1060]|0)+784>>2]=j;switch(c[Xa>>2]|0){case 0:{c[e>>2]=j|c[Ya>>2];Ya=0;i=Za;return Ya|0}case 1:{c[e>>2]=j&~c[Ya>>2];Ya=0;i=Za;return Ya|0}default:{c[e>>2]=c[Ya>>2];Ya=0;i=Za;return Ya|0}}}case 124:{Ya=ih(0)|0;c[Wa>>2]=Ya;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;Ya=Gm(c[1882]|0,Ya,4268)|0;c[Ua>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 125:{Ya=ih(0)|0;c[Wa>>2]=Ya;g[1079]=+kh(1.0);ba=+kh(.5);g[1080]=ba;Ya=bo(c[1882]|0,Ya,+g[1079],ba)|0;c[(c[1060]|0)+784>>2]=Ya;Ya=0;i=Za;return Ya|0}case 126:{Ya=ih(0)|0;c[Wa>>2]=Ya;g[1079]=+kh(45.0);g[1080]=+kh(1.5);g[1081]=+kh(.5);ba=+kh(768.0);Ya=Bn(c[1882]|0,Ya,+g[1079],+g[1080],+g[1081],ba)|0;c[Ua>>2]=Ya;if((Ya|0)>=0){Ya=0;i=Za;return Ya|0}bh(3);Ya=0;i=Za;return Ya|0}case 127:{Ya=mh(v)|0;c[Ua>>2]=Qm(c[1882]|0)|0;rh(c[v>>2]|0,Ya,4,Ua);Ya=0;i=Za;return Ya|0}case 135:case 134:case 133:case 132:case 131:case 130:case 129:case 128:{pI(Da);o=0;e=qa(99,0)|0;Ya=o;o=0;do if((((!(Ya&1)?(c[Wa>>2]=e,o=0,G=qa(103,ha|0)|0,Ya=o,o=0,!(Ya&1)):0)?(o=0,H=qa(103,ja|0)|0,Ya=o,o=0,!(Ya&1)):0)?(o=0,I=qa(103,la|0)|0,Ya=o,o=0,!(Ya&1)):0)?(o=0,J=pb(28,c[1882]|0,c[Wa>>2]|0,d+-128|0,Da|0)|0,Ya=o,o=0,!(Ya&1)):0){c[Ua>>2]=J;if((J|0)<0?(o=0,Ja(402,3),Ya=o,o=0,Ya&1):0)break;h[da>>3]=+g[Da>>2];h[ea>>3]=+g[Da+4>>2];h[fa>>3]=+g[Da+8>>2];o=0;yb(53,c[ha>>2]|0,G|0,3,da|0);Ya=o;o=0;if((!(Ya&1)?(o=0,yb(53,c[ja>>2]|0,H|0,3,ea|0),Ya=o,o=0,!(Ya&1)):0)?(o=0,yb(53,c[la>>2]|0,I|0,3,fa|0),Ya=o,o=0,!(Ya&1)):0){uI(Da);Ya=0;i=Za;return Ya|0}}while(0);e=zc()|0;o=0;Ja(413,Da|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else{Za=e;Kc(Za|0)}break}case 151:case 150:case 149:case 148:case 147:case 146:case 145:case 144:{pI(Ka);o=0;e=qa(99,0)|0;Va=o;o=0;do if((((!(Va&1)?(c[Wa>>2]=e,o=0,K=qa(103,ia|0)|0,Va=o,o=0,!(Va&1)):0)?(o=0,L=qa(103,ka|0)|0,Va=o,o=0,!(Va&1)):0)?(o=0,M=qa(103,ma|0)|0,Va=o,o=0,!(Va&1)):0)?(o=0,N=pb(28,c[1882]|0,c[Wa>>2]|0,d+-144|0,Ka|0)|0,Va=o,o=0,!(Va&1)):0){c[Ua>>2]=N;if((N|0)<0?(o=0,Ja(402,3),Va=o,o=0,Va&1):0)break;c[Wa>>2]=~~+g[Ka>>2];c[Ya>>2]=~~+g[Ka+4>>2];c[Xa>>2]=~~+g[Ka+8>>2];o=0;yb(53,c[ia>>2]|0,K|0,4,Wa|0);Wa=o;o=0;if((!(Wa&1)?(o=0,yb(53,c[ka>>2]|0,L|0,4,Ya|0),Ya=o,o=0,!(Ya&1)):0)?(o=0,yb(53,c[ma>>2]|0,M|0,4,Xa|0),Ya=o,o=0,!(Ya&1)):0){uI(Ka);Ya=0;i=Za;return Ya|0}}while(0);e=zc()|0;o=0;Ja(413,Ka|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else{Za=e;Kc(Za|0)}break}case 167:case 166:case 165:case 164:case 163:case 162:case 161:case 160:{Ya=ih(0)|0;c[Wa>>2]=Ya;c[1082]=Ya;c[1083]=d+-160;Ya=0;i=Za;return Ya|0}case 187:case 186:case 185:case 184:case 183:case 182:case 181:case 180:case 179:case 178:case 177:case 176:{Ya=ih(0)|0;c[Wa>>2]=Ya;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;Ya=Im(c[1882]|0,Ya,d+-176|0,4268)|0;c[Ua>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 204:case 202:case 201:case 200:case 199:case 198:case 197:case 196:case 195:case 194:case 193:case 192:{Ya=ih(0)|0;c[Wa>>2]=Ya;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;Ya=Dm(c[1882]|0,Ya,d+-192|0,4268)|0;c[Ua>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 208:{g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;Ya=Im(c[1882]|0,c[1082]|0,c[1083]|0,4268)|0;c[Ua>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 209:{g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;Ya=Dm(c[1882]|0,c[1082]|0,c[1083]|0,4268)|0;c[Ua>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 210:{Ya=Ci()|0;c[1084]=Ya;yI(4284,+h[Ya>>3],+h[Ya+8>>3],+h[Ya+16>>3],1.0);Ya=Im(c[1882]|0,c[1082]|0,c[1083]|0,4284)|0;c[Ua>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 211:{Ya=Ci()|0;c[1084]=Ya;yI(4284,+h[Ya>>3],+h[Ya+8>>3],+h[Ya+16>>3],1.0);Ya=Dm(c[1882]|0,c[1082]|0,c[1083]|0,4284)|0;c[Ua>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 212:{pI(La);o=0;e=qb(9)|0;Ya=o;o=0;do if(!(Ya&1)?(c[1084]=e,o=0,O=pb(28,c[1882]|0,c[1082]|0,c[1083]|0,La|0)|0,Ya=o,o=0,!(Ya&1)):0){c[Ua>>2]=O;if((O|0)<0?(o=0,Ja(402,3),Ya=o,o=0,Ya&1):0)break;Ya=c[1084]|0;h[Ya>>3]=+g[La>>2];h[Ya+8>>3]=+g[La+4>>2];h[Ya+16>>3]=+g[La+8>>2];h[Ya+24>>3]=+g[La+12>>2];uI(La);Ya=0;i=Za;return Ya|0}while(0);e=zc()|0;o=0;Ja(413,La|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else{Za=e;Kc(Za|0)}break}case 214:case 213:{pI(Qa);o=0;e=qa(99,0)|0;Ya=o;o=0;do if(((!(Ya&1)?(c[Wa>>2]=e,o=0,P=qa(99,0)|0,Ya=o,o=0,!(Ya&1)):0)?(g[Qa>>2]=+(P|0)*.02454369328916073,o=0,Q=qa(99,0)|0,Ya=o,o=0,!(Ya&1)):0)?(g[Qa+4>>2]=+(Q|0)*.02454369328916073,o=0,R=qa(99,0)|0,Ya=o,o=0,!(Ya&1)):0){g[Qa+8>>2]=+(R|0)*.02454369328916073;g[Qa+12>>2]=1.0;j=c[1882]|0;e=c[Wa>>2]|0;o=0;if((d|0)==213){e=Im(j,e,9,Qa)|0;Ya=o;o=0;if(Ya&1)break;c[Ua>>2]=e;if((e|0)<0){Za=rd(4)|0;c[Za>>2]=3;o=0;sb(109,Za|0,8,0);o=0;break}}else{e=Dm(j,e,9,Qa)|0;Ya=o;o=0;if(Ya&1)break;c[Ua>>2]=e;if((e|0)<0){Za=rd(4)|0;c[Za>>2]=3;o=0;sb(109,Za|0,8,0);o=0;break}}uI(Qa);Ya=0;i=Za;return Ya|0}while(0);e=zc()|0;o=0;Ja(413,Qa|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else{Za=e;Kc(Za|0)}break}case 215:{Va=ih(0)|0;c[Wa>>2]=Va;Xa=ih(0)|0;c[Ya>>2]=Xa;c[1082]=Va;c[1083]=Xa;Ya=0;i=Za;return Ya|0}case 217:{Xa=mh(w)|0;c[Wa>>2]=ih(0)|0;g[1079]=+kh(1.0);Va=ih(0)|0;c[Ya>>2]=Va;c[Ua>>2]=bn(c[1882]|0,c[Wa>>2]|0,+g[1079],Va)|0;rh(c[w>>2]|0,Xa,4,Ua);Ya=0;i=Za;return Ya|0}case 218:{e=ih(0)|0;c[Wa>>2]=e;j=ih(0)|0;c[Ya>>2]=j;c[Xa>>2]=ih(0)|0;e=Em(c[1882]|0,e)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}c[e+20>>2]=j;c[e+24>>2]=c[Xa>>2];Ya=0;i=Za;return Ya|0}case 219:{e=mh(Ba)|0;j=ih(0)|0;c[Wa>>2]=j;j=Em(c[1882]|0,j)|0;if(!j)bh(3);c[Wa>>2]=c[j+20>>2];rh(c[Ba>>2]|0,e,4,Wa);Ya=0;i=Za;return Ya|0}case 220:{Xa=ih(0)|0;c[Wa>>2]=Xa;c[Ya>>2]=0;Xa=(Em(c[1882]|0,Xa)|0)==0;c[Ya>>2]=Xa?-1:0;c[(c[1060]|0)+784>>2]=Xa?-1:0;Ya=0;i=Za;return Ya|0}case 224:{c[1084]=Ci()|0;g[1067]=+kh(0.0);g[1068]=+kh(0.0);ba=+kh(0.0);g[1069]=ba;g[1070]=1.0;Ya=c[1084]|0;h[Ya>>3]=+g[1067];h[Ya+8>>3]=+g[1068];h[Ya+16>>3]=ba;h[Ya+24>>3]=1.0;Ya=0;i=Za;return Ya|0}case 225:{c[1084]=Ci()|0;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;Ya=c[1084]|0;yI(4284,+h[Ya>>3],+h[Ya+8>>3],+h[Ya+16>>3],1.0);xI(4284,4268);Ya=c[1084]|0;h[Ya>>3]=+g[1071];h[Ya+8>>3]=+g[1072];h[Ya+16>>3]=+g[1073];h[Ya+24>>3]=+g[1074];Ya=0;i=Za;return Ya|0}case 226:{c[1084]=Ci()|0;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;Ya=c[1084]|0;yI(4284,+h[Ya>>3],+h[Ya+8>>3],+h[Ya+16>>3],1.0);zI(4284,4268);Ya=c[1084]|0;h[Ya>>3]=+g[1071];h[Ya+8>>3]=+g[1072];h[Ya+16>>3]=+g[1073];h[Ya+24>>3]=+g[1074];Ya=0;i=Za;return Ya|0}case 227:{c[1084]=Ci()|0;g[1067]=+kh(0.0);g[1068]=+kh(0.0);ba=+kh(0.0);g[1069]=ba;g[1070]=1.0;Ya=c[1084]|0;yI(4284,+h[Ya>>3]*+g[1067],+h[Ya+8>>3]*+g[1068],+h[Ya+16>>3]*ba,1.0);Ya=c[1084]|0;h[Ya>>3]=+g[1071];h[Ya+8>>3]=+g[1072];h[Ya+16>>3]=+g[1073];h[Ya+24>>3]=+g[1074];Ya=0;i=Za;return Ya|0}case 228:{c[1084]=Ci()|0;g[1067]=+kh(0.0);g[1068]=+kh(0.0);ba=+kh(0.0);g[1069]=ba;g[1070]=1.0;Ya=c[1084]|0;yI(4284,+h[Ya>>3]/+g[1067],+h[Ya+8>>3]/+g[1068],+h[Ya+16>>3]/ba,1.0);Ya=c[1084]|0;h[Ya>>3]=+g[1071];h[Ya+8>>3]=+g[1072];h[Ya+16>>3]=+g[1073];h[Ya+24>>3]=+g[1074];Ya=0;i=Za;return Ya|0}case 230:{c[1084]=Ci()|0;h[3]=+kh(0.0);h[4]=+kh(0.0);h[5]=+kh(0.0);j=c[1084]|0;f=+h[3];if(+h[j>>3]<f)h[j>>3]=f;e=j+8|0;f=+h[4];if(+h[e>>3]<f)h[e>>3]=f;e=j+16|0;f=+h[5];if(!(+h[e>>3]<f)){Ya=0;i=Za;return Ya|0}h[e>>3]=f;Ya=0;i=Za;return Ya|0}case 231:{c[1084]=Ci()|0;h[3]=+kh(0.0);h[4]=+kh(0.0);h[5]=+kh(0.0);j=c[1084]|0;f=+h[3];if(+h[j>>3]>f)h[j>>3]=f;e=j+8|0;f=+h[4];if(+h[e>>3]>f)h[e>>3]=f;e=j+16|0;f=+h[5];if(!(+h[e>>3]>f)){Ya=0;i=Za;return Ya|0}h[e>>3]=f;Ya=0;i=Za;return Ya|0}case 232:{Xa=Ci()|0;c[1084]=Xa;g[B>>2]=+h[Xa>>3];Va=B+4|0;g[Va>>2]=+h[Xa+8>>3];Wa=B+8|0;g[Wa>>2]=+h[Xa+16>>3];Xa=B+12|0;g[Xa>>2]=1.0;Vg(B);Ya=c[1084]|0;h[Ya>>3]=+g[B>>2];h[Ya+8>>3]=+g[Va>>2];h[Ya+16>>3]=+g[Wa>>2];h[Ya+24>>3]=+g[Xa>>2];Ya=0;i=Za;return Ya|0}case 233:{pI(Ha);o=0;e=qb(9)|0;Ya=o;o=0;if((((!(Ya&1)?(c[1084]=e,o=0,f=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ha>>2]=f,o=0,l=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ha+4>>2]=l,o=0,m=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ha+8>>2]=m,g[Ha+12>>2]=1.0,Ya=c[1084]|0,g[oa>>2]=+h[Ya>>3],g[oa+4>>2]=+h[Ya+8>>3],g[oa+8>>2]=+h[Ya+16>>3],g[oa+12>>2]=1.0,o=0,sb(110,pa|0,oa|0,Ha|0),Ya=o,o=0,!(Ya&1)):0){Ya=c[1084]|0;h[Ya>>3]=+g[pa>>2];h[Ya+8>>3]=+g[pa+4>>2];h[Ya+16>>3]=+g[pa+8>>2];h[Ya+24>>3]=+g[pa+12>>2];uI(Ha);Ya=0;i=Za;return Ya|0}e=zc()|0;o=0;Ja(413,Ha|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else{Za=e;Kc(Za|0)}break}case 234:{pI(Ia);o=0;e=qb(9)|0;Ya=o;o=0;if((((!(Ya&1)?(c[1084]=e,o=0,S=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ia>>2]=S,o=0,T=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ia+4>>2]=T,o=0,U=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ia+8>>2]=U,g[Ia+12>>2]=1.0,Ya=c[1084]|0,g[ra>>2]=+h[Ya>>3],g[ra+4>>2]=+h[Ya+8>>3],g[ra+8>>2]=+h[Ya+16>>3],g[ra+12>>2]=1.0,o=0,V=+ya(1,ra|0,Ia|0),Ya=o,o=0,!(Ya&1)):0){h[c[1084]>>3]=V;uI(Ia);Ya=0;i=Za;return Ya|0}e=zc()|0;o=0;Ja(413,Ia|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else{Za=e;Kc(Za|0)}break}case 235:{pI(Ga);o=0;e=qb(9)|0;Ya=o;o=0;if((((!(Ya&1)?(c[1084]=e,o=0,W=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ga>>2]=W,o=0,X=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ga+4>>2]=X,o=0,Y=+Ra(1,0.0),Ya=o,o=0,!(Ya&1)):0)?(g[Ga+8>>2]=Y,g[Ga+12>>2]=1.0,$=c[1084]|0,g[sa>>2]=+h[$>>3],Z=sa+4|0,g[Z>>2]=+h[$+8>>3],_=sa+8|0,g[_>>2]=+h[$+16>>3],$=sa+12|0,g[$>>2]=1.0,o=0,sb(111,sa|0,sa|0,Ga|0),Ya=o,o=0,!(Ya&1)):0){Ya=c[1084]|0;h[Ya>>3]=+g[sa>>2];h[Ya+8>>3]=+g[Z>>2];h[Ya+16>>3]=+g[_>>2];h[Ya+24>>3]=+g[$>>2];uI(Ga);Ya=0;i=Za;return Ya|0}e=zc()|0;o=0;Ja(413,Ga|0);Za=o;o=0;if(Za&1){Za=zc(0)|0;Di(Za)}else{Za=e;Kc(Za|0)}break}case 236:{Xa=Ci()|0;c[1084]=Xa;Ya=c[(c[1060]|0)+792>>2]|0;aa=+h[Xa+8>>3];ba=+h[Xa+16>>3];h[C>>3]=+h[Xa>>3];h[C+8>>3]=aa;h[C+16>>3]=ba;W7(Ya,49530,C)|0;Ya=0;i=Za;return Ya|0}case 237:{Ya=mh(k)|0;ba=+kh(0.0);h[3]=ba;h[E>>3]=ba;W7(Ta,49269,E)|0;rh(c[k>>2]|0,Ya,2,Ta);Ya=0;i=Za;return Ya|0}case 238:{c[1084]=Ci()|0;Ya=eh()|0;Wa=A+4|0;Xa=A+8|0;c[F>>2]=A;c[F+4>>2]=Wa;c[F+8>>2]=Xa;X7(Ya,49530,F)|0;Ya=c[1084]|0;h[Ya>>3]=+g[A>>2];h[Ya+8>>3]=+g[Wa>>2];h[Ya+16>>3]=+g[Xa>>2];h[Ya+24>>3]=+g[A+12>>2];Ya=0;i=Za;return Ya|0}case 239:{Ya=mh(n)|0;Xa=eh()|0;c[D>>2]=e;X7(Xa,49269,D)|0;h[3]=+g[e>>2];rh(c[n>>2]|0,Ya,3,24);Ya=0;i=Za;return Ya|0}case 240:{e=ih(0)|0;c[Wa>>2]=e;j=ih(0)|0;c[Ya>>2]=j;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;e=$n(c[1882]|0,e)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}Ya=Zn(e,j,4268)|0;c[(c[1060]|0)+784>>2]=Ya;Ya=0;i=Za;return Ya|0}case 241:{Va=ih(0)|0;c[Wa>>2]=Va;Wa=ih(-1)|0;c[Ya>>2]=Wa;Ya=sm(c[1882]|0,Va,Wa)|0;c[Xa>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 242:{Va=ih(0)|0;c[Wa>>2]=Va;Wa=ih(0)|0;c[Ya>>2]=Wa;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;Ya=co(c[1882]|0,Va,Wa,4268)|0;c[Xa>>2]=Ya;if((Ya|0)<0){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}else{Ya=0;i=Za;return Ya|0}}case 243:{j=ih(0)|0;c[Wa>>2]=j;e=ih(255)|0;c[Ya>>2]=e;j=Em(c[1882]|0,j)|0;if(!j){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}if((e|0)>=0){if((e|0)>255){c[Ya>>2]=255;e=255}}else{c[Ya>>2]=0;e=0}c[j+16>>2]=e;Ya=0;i=Za;return Ya|0}case 244:{c[Wa>>2]=ih(0)|0;I8(Ta,eh()|0,256)|0;h[3]=+kh(0.0);e=Mn(c[1882]|0,c[Wa>>2]|0)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}Kn(e,Ta,+h[3])|0;Ya=0;i=Za;return Ya|0}case 245:{c[Wa>>2]=ih(0)|0;I8(Ta,eh()|0,256)|0;g[1067]=+kh(0.0);g[1068]=+kh(0.0);g[1069]=+kh(0.0);g[1070]=1.0;h[3]=+kh(0.0);e=Mn(c[1882]|0,c[Wa>>2]|0)|0;if(!e){Za=rd(4)|0;c[Za>>2]=3;Te(Za|0,8,0)}g[1070]=+h[3];In(e,Ta,4268)|0;Ya=0;i=Za;return Ya|0}case 229:case 216:case 101:{Ya=0;i=Za;return Ya|0}default:{Za=rd(4)|0;c[Za>>2]=21;Te(Za|0,8,0)}}while(0);return 0}function zi(a){a=a|0;var b=0;a=c[1064]|0;do if(a){o=0;Ja(414,a|0);b=o;o=0;if(!(b&1)){$5(a);break}b=zc()|0;$5(a);Kc(b|0)}while(0);a=c[1065]|0;do if(a){o=0;Ja(415,a|0);b=o;o=0;if(!(b&1)){$5(a);break}b=zc()|0;$5(a);Kc(b|0)}while(0);a=c[1059]|0;if(!a)return 0;o=0;Ja(416,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return 0}return 0}function Ai(d,e){d=d|0;e=e|0;var f=0,g=0;g=i;i=i+16|0;f=g;c[d>>2]=4;if(!(e&256))switch(e|0){case 0:{c[1075]=b[(c[1063]|0)+176>>1];d=4300;i=g;return d|0}case 1:{c[1075]=b[(c[1063]|0)+178>>1];d=4300;i=g;return d|0}case 2:{d=(c[1063]|0)+182|0;c[1075]=b[d>>1];b[d>>1]=0;d=4300;i=g;return d|0}case 3:{c[1075]=0;d=4300;i=g;return d|0}case 4:{c[1075]=0;d=4300;i=g;return d|0}case 5:{c[1075]=0;d=4300;i=g;return d|0}default:{g=rd(4)|0;c[g>>2]=21;Te(g|0,8,0)}}if(c[c[1061]>>2]|0){g=rd(4)|0;c[g>>2]=32;Te(g|0,8,0)}if((c[c[1062]>>2]|0)!=40){g=rd(4)|0;c[g>>2]=32;Te(g|0,8,0)}ah();a:do switch(e&255|0){case 0:{e=hh()|0;if((e|0)>=256){h[2]=+Ho(e);c[d>>2]=3;e=16;break a}do switch(e|0){case 31:case 30:case 29:case 28:case 24:case 19:case 11:case 10:case 9:case 8:case 7:case 6:case 5:case 4:case 1:case 0:{e=0;break}case 2:{e=Gk(c[1059]|0)|0;break}case 3:{e=c[1066]|0;break}case 26:case 12:{e=c[(c[1063]|0)+4>>2]|0;break}case 27:case 13:{e=c[(c[1063]|0)+8>>2]|0;break}case 14:{e=b[(c[1063]|0)+156>>1]|0;break}case 15:{e=b[(c[1063]|0)+158>>1]|0;break}case 16:{e=(c[(c[1063]|0)+104>>2]|0)>>>16&255;break}case 17:{e=(c[(c[1063]|0)+104>>2]|0)>>>8&255;break}case 18:{e=c[(c[1063]|0)+104>>2]&255;break}case 20:{e=mo()|0;break}case 21:{e=no()|0;break}case 22:{e=c[(c[1063]|0)+68>>2]|0;break}case 23:{e=c[(c[1063]|0)+72>>2]|0;break}case 25:{e=Lk(c[1059]|0)|0;break}default:{g=rd(4)|0;c[g>>2]=21;Te(g|0,8,0)}}while(0);c[1075]=e;e=4300;break}case 2:{f=hh()|0;e=c[(c[1060]|0)+824>>2]|0;a[e>>0]=0;if(f>>>0<6){c[d>>2]=2;break a}else{g=rd(4)|0;c[g>>2]=3;Te(g|0,8,0)}}case 3:{if(!(Io(hh()|0,f,c[(c[1060]|0)+824>>2]|0)|0)){a[c[(c[1060]|0)+824>>2]>>0]=0;e=4}else e=c[f>>2]|0;c[d>>2]=e;e=c[(c[1060]|0)+824>>2]|0;break}default:{g=rd(4)|0;c[g>>2]=21;Te(g|0,8,0)}}while(0);if(c[c[1061]>>2]|0){g=rd(4)|0;c[g>>2]=32;Te(g|0,8,0)}if((c[c[1062]>>2]|0)!=41){g=rd(4)|0;c[g>>2]=32;Te(g|0,8,0)}ah();d=e;i=g;return d|0}function Bi(){pI(4268);hc(413,4268,n|0)|0;pI(4284);hc(413,4284,n|0)|0;return}function Ci(){var a=0,d=0,e=0,f=0,g=0,j=0;j=i;i=i+16|0;g=j+12|0;f=j;sh(g,j+8|0)|0;h[f>>3]=0.0;a=c[g>>2]|0;if((b[a>>1]|0)!=3){rh(a,0,3,f);a=c[g>>2]|0}d=a+8|0;e=c[d>>2]|0;if(((e|0)<4?(c[d>>2]=4,c[a+24>>2]=32,rh(a,3,3,f),(e|0)<3):0)?(rh(c[g>>2]|0,2,3,f),(e|0)<2):0)rh(c[g>>2]|0,1,3,f);g=c[g>>2]|0;c[g+40>>2]=0;g=rf[c[(c[6908>>2]|0)+((b[g>>1]<<16>>16)*140|0)+28>>2]&255](g)|0;i=j;return g|0}function Di(a){a=a|0;Id(a|0)|0;f6()}function Ei(a){a=a|0;var b=0;c[1085]=c[a+4>>2];b=c[a+8>>2]|0;c[1086]=b;c[1087]=c[b+24>>2];c[1088]=c[b+28>>2];h[6]=.000244140625;c[a+12>>2]=116;c[a+20>>2]=117;return}function Fi(a){a=a|0;c[a+16>>2]=38;return}function Gi(){var a=0,b=0;Ul(6860);hc(417,6860,n|0)|0;c[1090]=5489;a=5489;b=1;do{a=($(a>>>30^a,1812433253)|0)+b|0;c[4360+(b<<2)>>2]=a;b=b+1|0}while((b|0)!=624);c[1714]=0;return}function Hi(d){d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0.0;J=i;i=i+112|0;H=J+108|0;E=J+104|0;f=J+100|0;e=J+96|0;g=J+92|0;r=J+88|0;k=J+84|0;s=J+80|0;l=J+76|0;B=J+72|0;p=J+68|0;z=J+64|0;A=J+60|0;n=J+56|0;o=J+52|0;y=J+48|0;x=J+44|0;j=J+40|0;w=J+36|0;q=J+32|0;F=J+28|0;m=J+24|0;u=J+20|0;C=J+16|0;D=J+12|0;G=J+8|0;t=J+4|0;v=J;ah();do switch(d|0){case 4:case 3:case 2:case 1:case 0:{e=c[c[1087]>>2]|0;if((e|0)==1)e=(b[(c[(c[1085]|0)+44>>2]|0)+((c[c[1088]>>2]|0)*48|0)>>1]|0)==1?7:1;switch(e|0){case 15:{I=6;break}case 7:{e=0;break}default:{Rh(d,hh()|0);i=J;return 0}}do if((I|0)==6){e=c[c[1088]>>2]|0;if((e|0)>1){J=rd(4)|0;c[J>>2]=2;Te(J|0,8,0)}else{ah();break}}while(0);k=ph()|0;if((d|0)!=4){ai(d,e,-1,k);i=J;return 0}g=hh()|0;j=c[c[(c[1086]|0)+20>>2]>>2]|0;f=bi(j,g)|0;if(!f)f=Ph()|0;b[f>>1]=2;b[f+2>>1]=e;c[f+16>>2]=k;c[f+4>>2]=g;c[f+8>>2]=j;i=J;return 0}case 20:case 19:case 18:case 17:{Qh(5,0,0,eh()|0)|0;Qh(d+-9|0,0,0,0)|0;i=J;return 0}case 21:{I=mh(f)|0;Qh(5,0,0,eh()|0)|0;Qh(13,ih(0)|0,0,e)|0;rh(c[f>>2]|0,I,2,c[e>>2]|0);Qh(14,0,0,0)|0;i=J;return 0}case 23:case 22:{Qh(5,0,0,eh()|0)|0;f=sh(g,r)|0;e=ih(-1)|0;g=ih(-1)|0;c[E>>2]=g;I=c[r>>2]|0;e=(e|0)<0|(e|0)>(I|0)?I:e;if((d|0)==22){Qh(6,(g|0)<0?0:g,e,f)|0;i=J;return 0}else{Qh(7,g,e,f)|0;i=J;return 0}}case 24:{Qh(5,0,0,eh()|0)|0;Qh(12,0,0,eh()|0)|0;i=J;return 0}case 25:{f=sh(k,s)|0;g=ih(0)|0;e=ih(0)|0;c[E>>2]=e;if(!e){e=(c[s>>2]|0)-g|0;c[E>>2]=e}Rg(f+g|0,e);i=J;return 0}case 28:case 27:case 26:{e=sh(l,B)|0;j=ih(0)|0;if((j|0)<0){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}g=e+j|0;if((dh()|0)<-1){c[E>>2]=0;e=E;f=4}else{f=c[971]|0;e=c[f+28>>2]|0;f=b[f>>1]|0}if((d|0)==26)switch(f|0){case 4:{if((j|0)>=(c[B>>2]|0)){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}a[g>>0]=a[e>>0]|0;i=J;return 0}case 2:{I=F8(e)|0;c[(c[1085]|0)+788>>2]=I;if((j+1+I|0)>(c[B>>2]|0)){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}C8(g,e)|0;i=J;return 0}default:{J=rd(4)|0;c[J>>2]=6;Te(J|0,8,0)}}if((f|0)!=4){J=rd(4)|0;c[J>>2]=6;Te(J|0,8,0)}if((d|0)==27){if((j+2|0)>(c[B>>2]|0)){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}b[g>>1]=b[e>>1]|0;i=J;return 0}else{if((j+4|0)>(c[B>>2]|0)){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}c[g>>2]=c[e>>2];i=J;return 0}}case 29:{k=mh(z)|0;g=sh(p,A)|0;j=ih(0)|0;f=ih(0)|0;c[E>>2]=f;e=ih(1024)|0;if((j|0)>=(c[A>>2]|0)){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}I=wh(e+1|0)|0;Ep();H=Gp(g+j|0,I,f&255,e)|0;c[(c[1085]|0)+784>>2]=H;H=Fp()|0;c[(c[1085]|0)+788>>2]=H;rh(c[z>>2]|0,k,2,I);i=J;return 0}case 30:{Qh(5,0,0,eh()|0)|0;I=ih(-1)|0;Mg();I=Lg(c[(c[1085]|0)+796>>2]|0,0,-1,I)|0;c[E>>2]=I;if(!I){i=J;return 0}else{J=rd(4)|0;c[J>>2]=12;Te(J|0,8,0)}}case 31:{I=mh(n)|0;e=c[n>>2]|0;c[e+40>>2]=I;e=rf[c[(c[6908>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&255](e)|0;if(!(b[(c[n>>2]|0)+36>>1]&2)){J=rd(4)|0;c[J>>2]=6;Te(J|0,8,0)}I=ih(0)|0;H=c[n>>2]|0;tg[c[(c[6908>>2]|0)+((b[H>>1]<<16>>16)*140|0)+68>>2]&255](H,e,(I|0)<64?64:I);i=J;return 0}case 32:{k=sh(o,y)|0;f=sh(o,x)|0;g=ih(0)|0;j=ih(0)|0;c[E>>2]=j;e=ih(0)|0;if((j|e|0)<0){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}if((j+g|0)>(c[y>>2]|0)){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}if((e+g|0)>(c[x>>2]|0)){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}if((g|0)<=0){i=J;return 0}L9(k+j|0,f+e|0,g|0)|0;i=J;return 0}case 33:{f=sh(j,w)|0;g=ih(0)|0;j=ih(0)|0;c[E>>2]=j;e=ih(0)|0;if((e|0)<0){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}if((j+e|0)>(c[w>>2]|0)){J=rd(4)|0;c[J>>2]=20;Te(J|0,8,0)}if((j|0)<=0){i=J;return 0}M9(f+e|0,g&255|0,j|0)|0;i=J;return 0}case 34:{e=c[1085]|0;c[e+820>>2]=c[e+812>>2];c[e+816>>2]=c[e+808>>2];e=mh((c[1085]|0)+808|0)|0;f=c[1085]|0;c[f+812>>2]=e;f=c[f+808>>2]|0;if((b[f>>1]|0)==2){i=J;return 0}rh(f,e,2,63688);i=J;return 0}case 35:{e=c[1085]|0;f=c[e+808>>2]|0;if(!f){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}c[f+40>>2]=c[e+812>>2];k=rf[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&255](f)|0;Wl(6860,k);g=eh()|0;j=(F8(g)|0)+8|0;e=c[(c[1085]|0)+808>>2]|0;f=c[(c[1727]|0)+((b[e>>1]|0)*140|0)+68>>2]|0;j=j+(F8(k)|0)|0;tg[f&255](e,k,j);g=xh(g)|0;j=ih(-1)|0;k=ih(0)|0;c[E>>2]=k;e=c[1085]|0;f=c[e+808>>2]|0;if(!f){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}c[f+40>>2]=c[e+812>>2];Wl(6860,rf[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&255](f)|0);$l(6860,g,j,k)|0;i=J;return 0}case 36:{e=ih(0)|0;f=c[1085]|0;g=c[f+808>>2]|0;if(!g){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}c[g+40>>2]=c[f+812>>2];Wl(6860,rf[c[(c[6908>>2]|0)+((b[g>>1]<<16>>16)*140|0)+28>>2]&255](g)|0);$l(6860,0,e,1)|0;i=J;return 0}case 37:{Qh(5,0,0,eh()|0)|0;e=ih(-1)|0;Qh(8,0,0,0)|0;j=c[1085]|0;f=j+788|0;g=c[f>>2]|0;if((g|0)<0){J=rd(4)|0;c[J>>2]=12;Te(J|0,8,0)}if(!((e|0)<0|(g|0)<(e|0))){c[f>>2]=e;g=e}e=c[j+808>>2]|0;if(!e){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}c[e+40>>2]=c[j+812>>2];e=rf[c[(c[6908>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&255](e)|0;Wl(6860,e);f=c[(c[1085]|0)+808>>2]|0;tg[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+68>>2]&255](f,e,g+1|0);e=c[1085]|0;f=c[e+808>>2]|0;if(!f){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}c[f+40>>2]=c[e+812>>2];I=rf[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&255](f)|0;Wl(6860,I);Qh(6,0,g,I)|0;a[I+g>>0]=0;i=J;return 0}case 38:{Qh(5,0,0,eh()|0)|0;e=c[1085]|0;f=c[e+808>>2]|0;if(!f){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}c[f+40>>2]=c[e+812>>2];I=rf[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&255](f)|0;Wl(6860,I);Qh(7,-1,F8(I)|0,I)|0;i=J;return 0}case 39:{e=ad(0)|0;c[E>>2]=e;e=ih(e)|0;c[1090]=e;f=1;do{e=($(e>>>30^e,1812433253)|0)+f|0;c[4360+(f<<2)>>2]=e;f=f+1|0}while((f|0)!=624);c[1714]=0;i=J;return 0}case 40:{I=c[1085]|0;c[I+812>>2]=c[I+820>>2];c[I+808>>2]=c[I+816>>2];i=J;return 0}case 41:{e=c[1085]|0;f=c[e+808>>2]|0;if(!f){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}c[f+40>>2]=c[e+812>>2];Wl(6860,rf[c[(c[6908>>2]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&255](f)|0);H=mh(q)|0;I=Yl(6860,ih(0)|0)|0;rh(c[q>>2]|0,H,2,I);Zl(6860);i=J;return 0}case 42:{c[F>>2]=0;f=sh(F,m)|0;if((b[c[F>>2]>>1]|0)!=2){J=rd(4)|0;c[J>>2]=6;Te(J|0,8,0)}q=eh()|0;r=F8(q)|0;g=0;j=0;e=0;while(1){p=wp(f,q)|0;do if(!j){if(!(c[c[(c[1086]|0)+84>>2]>>2]&8192)){g=mh(F)|0;l=0;I=110;break}if(!g){k=0;l=1;I=104}else{c[F>>2]=0;g=1;f=1;I=118}}else{k=g;l=j;I=104}while(0);if((I|0)==104){j=c[F>>2]|0;g=k+1|0;if(j)if((g|0)<(c[j+8>>2]|0))I=110;else{if(c[j+12>>2]|0){I=107;break}cj(j,1,k+2|0);I=110}else{f=l;I=118}}if((I|0)==110){I=0;j=c[F>>2]|0;if(!j){f=l;I=118}else{if(!p){I=112;break}k=p-f|0;m=c[1727]|0;if((b[j>>1]|0)==2){n=2;o=m}else{if(g){I=115;break}dj(j,2);n=b[j>>1]|0;o=c[1727]|0}c[j+40>>2]=g;E=c[o+((n<<16>>16)*140|0)+68>>2]|0;H=m+308|0;G=rf[c[H>>2]&255](j)|0;tg[E&255](j,G,k+1|0);H=rf[c[H>>2]&255](j)|0;K9(H|0,f|0,k|0)|0;a[H+k>>0]=0;e=e+1|0;f=l}}if((I|0)==118){I=0;e=e+1|0;if(!p)break}j=f;f=p+r|0}if((I|0)==107){J=rd(4)|0;c[J>>2]=7;Te(J|0,8,0)}else if((I|0)==112){rh(j,g,2,f);e=e+1|0}else if((I|0)==115){J=rd(4)|0;c[J>>2]=31;Te(J|0,8,0)}if(!(c[c[(c[1086]|0)+84>>2]>>2]&8192))do{I=mh(F)|0;rh(c[F>>2]|0,I,2,63688)}while((c[c[(c[1086]|0)+84>>2]>>2]&8192|0)==0);c[(c[1085]|0)+784>>2]=e;i=J;return 0}case 43:{g=mh(u)|0;e=c[u>>2]|0;if((b[e>>1]|0)!=2){J=rd(4)|0;c[J>>2]=6;Te(J|0,8,0)}c[e+40>>2]=g;e=rf[c[(c[6908>>2]|0)+308>>2]&255](e)|0;f=eh()|0;if(!(a[f>>0]|0)){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}Mp(e,f);I=Np(eh()|0)|0;rh(c[u>>2]|0,g,2,I);I=Op()|0;c[(c[1085]|0)+784>>2]=I;i=J;return 0}case 44:{K=+jh();L=+jh();c[1722]=ih(c[1722]|0)|0;c[1723]=0;h[10]=K;h[8]=K;K=L-K;h[11]=K;h[9]=K;i=J;return 0}case 45:{mh(C)|0;j=ih(0)|0;e=c[C>>2]|0;k=c[e+8>>2]|0;if((k|0)<1){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}switch(b[e>>1]|0){case 3:{f=c[e+28>>2]|0;e=c[1724]|0;if(e)up(e);g=tp(k<<4)|0;c[1724]=g;c[1725]=k;e=0;do{h[g+(e<<4)>>3]=+h[f+(e<<3)>>3];c[g+(e<<4)+8>>2]=e;e=e+1|0}while((e|0)!=(k|0));e=g+(k<<4)|0;if(!j){c[H>>2]=39;Ni(g,e,H);e=0}else{c[H>>2]=40;Ni(g,e,H);e=0}do{rh(c[C>>2]|0,e,3,(c[1724]|0)+(e<<4)|0);e=e+1|0}while((e|0)!=(k|0));i=J;return 0}case 4:{g=c[e+28>>2]|0;e=c[1724]|0;if(e)up(e);f=tp(k<<4)|0;c[1724]=f;c[1725]=k;e=0;do{c[f+(e<<4)>>2]=c[g+(e<<2)>>2];c[f+(e<<4)+8>>2]=e;e=e+1|0}while((e|0)!=(k|0));e=f+(k<<4)|0;if(!j){c[H>>2]=41;Ni(f,e,H)}else{c[H>>2]=42;Ni(f,e,H)}e=c[1724]|0;f=0;do{c[g+(f<<2)>>2]=c[e+(f<<4)>>2];f=f+1|0}while((f|0)!=(k|0));i=J;return 0}default:{J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}}}case 46:{e=mh(D)|0;g=ih(0)|0;f=c[D>>2]|0;if((b[f>>1]|0)!=2){J=rd(4)|0;c[J>>2]=6;Te(J|0,8,0)}if(c[f+12>>2]|e){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}k=c[f+8>>2]|0;e=c[1724]|0;if(e)up(e);e=tp(k<<4)|0;c[1724]=e;c[1725]=k;j=(k|0)>0;if(j){f=0;do{e=c[D>>2]|0;c[e+40>>2]=f;e=rf[c[(c[6908>>2]|0)+((b[e>>1]<<16>>16)*140|0)+28>>2]&255](e)|0;c[(c[1724]|0)+(f<<4)>>2]=e;e=c[1724]|0;c[e+(f<<4)+8>>2]=f;f=f+1|0}while((f|0)!=(k|0));f=k}else f=0;f=e+(f<<4)|0;if(!g){c[H>>2]=43;Ni(e,f,H)}else{c[H>>2]=44;Ni(e,f,H)}g=c[(c[D>>2]|0)+32>>2]|0;if(j)f=0;else{i=J;return 0}do{e=c[(c[1724]|0)+(f<<4)>>2]|0;if(!f){c[(c[D>>2]|0)+28>>2]=e;I=(c[D>>2]|0)+28|0;Sl(c[I>>2]|0,I)}else{I=g+(f<<2)|0;c[I>>2]=e;Sl(e,I)}f=f+1|0}while((f|0)!=(k|0));i=J;return 0}case 47:{p=mh(G)|0;o=ih(0)|0;m=c[G>>2]|0;c[m+40>>2]=p;m=rf[c[(c[6908>>2]|0)+((b[m>>1]<<16>>16)*140|0)+28>>2]&255](m)|0;e=a[m>>0]|0;if(!(e<<24>>24)){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}else{j=0;f=m}while(1){a:do if(e<<24>>24){g=f;b:while(1){f=g+1|0;switch(e<<24>>24){case 10:break a;case 13:{e=g;break b}default:{}}e=a[f>>0]|0;if(!(e<<24>>24))break a;else g=f}f=(a[f>>0]|0)==10?e+2|0:f}while(0);g=j+1|0;e=a[f>>0]|0;if(!(e<<24>>24)){n=g;l=j;break}else j=g}if((l|0)<0){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}e=c[1724]|0;if(e)up(e);f=tp(n<<4)|0;c[1724]=f;c[1725]=n;if(a[m>>0]|0){k=0;e=m;while(1){c[f+(k<<4)>>2]=e;c[f+(k<<4)+8>>2]=k;c:while(1){j=a[e>>0]|0;switch(j<<24>>24){case 0:break c;case 10:case 13:{a[e>>0]=0;break}default:{}}g=e+1|0;switch(j<<24>>24){case 10:{e=g;break c}case 13:{I=181;break c}default:e=g}}if((I|0)==181){I=0;e=(a[g>>0]|0)==10?e+2|0:g}if(!(a[e>>0]|0))break;else k=k+1|0}f=c[1724]|0}e=f+(n<<4)|0;if(!o){c[H>>2]=43;Ni(f,e,H)}else{c[H>>2]=44;Ni(f,e,H)}g=c[1724]|0;if((l|0)>-1){f=0;e=0;do{e=e+2+(F8(c[g+(f<<4)>>2]|0)|0)|0;f=f+1|0}while((f|0)!=(n|0));f=wh(e+1|0)|0;g=c[1724]|0;j=0;k=f;while(1){I=c[g+(j<<4)>>2]|0;C8(k,I)|0;I=F8(I)|0;a[k+I>>0]=13;e=k+(I+2)|0;a[k+(I+1)>>0]=10;j=j+1|0;if((j|0)==(n|0))break;else k=e}}else{e=wh(1)|0;f=e}a[e>>0]=0;rh(c[G>>2]|0,p,2,f);i=J;return 0}case 48:{g=mh(t)|0;e=ih(0)|0;f=c[1724]|0;if(!f){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}if((e|0)>-1&(e|0)<(c[1725]|0))e=c[f+(e<<4)+8>>2]|0;else e=0;c[v>>2]=e;rh(c[t>>2]|0,g,4,v);i=J;return 0}default:{J=rd(4)|0;c[J>>2]=21;Te(J|0,8,0)}}while(0);return 0}function Ii(a){a=a|0;return 0}
function to(a,d){a=a|0;d=d|0;var e=0;if((c[a+28>>2]|0)!=2){d=rd(4)|0;c[d>>2]=21;Te(d|0,8,0)}e=c[1882]|0;if(!e){e=c[1874]|0;e=e&65535;d=a+158|0;b[d>>1]=e;return 0}b[a+156>>1]=vn(e,c[a+68>>2]|0,c[a+72>>2]|0,d,a+552|0,c[1874]|0)|0;e=c[1874]|0;e=e&65535;d=a+158|0;b[d>>1]=e;return 0}function uo(a,b,d){a=a|0;b=+b;d=+d;if(!a)return;if((c[a+28>>2]|0)!=2){a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}mn(c[1882]|0,+g[a+552>>2],+g[a+556>>2],+g[a+560>>2],1.0);g[1877]=b;g[1878]=d;return}function vo(a,b){a=+a;b=+b;var d=0;d=nn(c[1882]|0)|0;c[d>>2]=c[1877];c[d+4>>2]=c[1878];g[1877]=a;g[1878]=b;g[d+28>>2]=a;c[d+32>>2]=c[1878];on(c[1882]|0);return}function wo(a,b,d,e,f){a=a|0;b=+b;d=+d;e=+e;f=+f;var h=0,i=0.0,j=0.0,k=0.0,l=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}h=hn(c[1882]|0)|0;l=+g[a+552>>2];k=+g[a+556>>2];j=+g[a+560>>2];i=+un(c[1882]|0,0,0);mn(c[1882]|0,l,k,j,i);g[h>>2]=b;g[h+4>>2]=f;g[h+28>>2]=b;g[h+32>>2]=d;g[h+56>>2]=e;g[h+60>>2]=f;g[h+84>>2]=e;g[h+88>>2]=d;jn(c[1882]|0);return}function xo(a,b,d,e,f,h){a=a|0;b=+b;d=+d;e=+e;f=+f;h=h|0;var i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0.0,q=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){o=rd(4)|0;c[o>>2]=21;Te(o|0,8,0)}o=hn(c[1882]|0)|0;q=+g[a+552>>2];p=+g[a+556>>2];n=+g[a+560>>2];m=+un(c[1882]|0,0,0);mn(c[1882]|0,q,p,n,m);a=~~(e-b);h=~~(f-d);m=+(((a|0)>-1?a:0-a|0)|0)*.5;n=+(((h|0)>-1?h:0-h|0)|0)*.5;f=m+b;e=n+d;h=o+4|0;a=o+28|0;i=o+32|0;j=o+56|0;k=o+60|0;l=1;do{g[o>>2]=f;g[h>>2]=e;q=+(l|0)*.39269909262657166;g[a>>2]=f+m*+R(+q);g[i>>2]=e+n*+S(+q);l=l+1|0;q=+(l|0)*.39269909262657166;g[j>>2]=f+m*+R(+q);g[k>>2]=e+n*+S(+q);kn(c[1882]|0,3)}while((l|0)!=17);ln(c[1882]|0);return}function yo(a,b,d,e,f,h){a=a|0;b=+b;d=+d;e=+e;f=+f;h=+h;var i=0,j=0.0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}i=hn(c[1882]|0)|0;m=c[a+552>>2]|0;l=c[a+556>>2]|0;k=c[a+560>>2]|0;j=+un(c[1882]|0,c[a+100>>2]|0,c[a+144>>2]|0);o=-+S(+h);h=+R(+h);p=e*-.5;e=f*-.5;n=e*o;e=e*h;h=p*h;f=p*o;g[i>>2]=-h-n+b;g[i+4>>2]=f-e+d;c[i+12>>2]=m;c[i+16>>2]=l;c[i+20>>2]=k;g[i+24>>2]=j;g[i+28>>2]=h-n+b;g[i+32>>2]=-e-f+d;c[i+40>>2]=m;c[i+44>>2]=l;c[i+48>>2]=k;g[i+52>>2]=j;g[i+56>>2]=n-h+b;g[i+60>>2]=f+e+d;c[i+68>>2]=m;c[i+72>>2]=l;c[i+76>>2]=k;g[i+80>>2]=j;g[i+84>>2]=n+h+b;g[i+88>>2]=e-f+d;c[i+96>>2]=m;c[i+100>>2]=l;c[i+104>>2]=k;g[i+108>>2]=j;jn(c[1882]|0);return}function zo(a,b,d,e,f,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=+i;j=+j;var k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){a=rd(4)|0;c[a>>2]=21;Te(a|0,8,0)}o=Mn(c[1882]|0,c[h+280>>2]|0)|0;if(!o){a=rd(4)|0;c[a>>2]=3;Te(a|0,8,0)}h=pn(c[1882]|0,o)|0;if(!h){a=rd(4)|0;c[a>>2]=3;Te(a|0,8,0)}n=+Rn(c[1882]|0,c[o+12>>2]|0,c[a+100>>2]|0,c[a+144>>2]|0);tn(c[1882]|0,+g[a+644>>2],+g[a+648>>2],+g[a+652>>2],n);if(i<0.0){m=-i;n=+((e<<16>>16)+(b<<16>>16)|0);l=+(b<<16>>16)}else{m=i;n=+(b<<16>>16);l=+((e<<16>>16)+(b<<16>>16)|0)}if(j<0.0){j=-j;k=+((f<<16>>16)+(d<<16>>16)|0);i=+(d<<16>>16)}else{k=+(d<<16>>16);i=+((f<<16>>16)+(d<<16>>16)|0)}s=+(c[a+68>>2]|0);p=+(c[a+72>>2]|0);q=m+s;j=j+p;m=+g[o+28>>2];t=+g[o+32>>2];r=n*m;m=l*m;n=1.0-k*t;l=1.0-i*t;g[h>>2]=s;g[h+4>>2]=j;g[h+12>>2]=r;g[h+16>>2]=l;g[h+36>>2]=s;g[h+40>>2]=p;g[h+48>>2]=r;g[h+52>>2]=n;g[h+72>>2]=q;g[h+76>>2]=j;g[h+84>>2]=m;g[h+88>>2]=l;g[h+108>>2]=q;g[h+112>>2]=p;g[h+120>>2]=m;g[h+124>>2]=n;qn(c[1882]|0,o);return}function Ao(a,d,e,f,h,i){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0,H=0,I=0,J=0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0;if(!a){J=0;return J|0}if((c[a+28>>2]|0)!=2){J=rd(4)|0;c[J>>2]=21;Te(J|0,8,0)}J=Mn(c[1882]|0,c[i+280>>2]|0)|0;if(!J){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}I=pn(c[1882]|0,J)|0;if(!I){J=rd(4)|0;c[J>>2]=3;Te(J|0,8,0)}A=+Rn(c[1882]|0,c[J+12>>2]|0,c[a+100>>2]|0,c[a+144>>2]|0);tn(c[1882]|0,+g[a+644>>2],+g[a+648>>2],+g[a+652>>2],A);A=+g[J+28>>2];B=+g[J+32>>2];G=b[i+208>>1]|0;C=G<<16>>16;H=b[i+210>>1]|0;D=H<<16>>16;E=+(G<<16>>16);F=+(H<<16>>16);if((h|0)>0){G=i+204|0;H=i+212|0;j=i+214|0;k=I+4|0;l=I+12|0;m=I+16|0;n=I+36|0;o=I+40|0;p=I+48|0;q=I+52|0;r=I+72|0;s=I+76|0;t=I+84|0;u=I+88|0;v=I+108|0;w=I+112|0;x=I+120|0;y=I+124|0;z=0;a=0;while(1){i=c[f>>2]|0;if((i|0)>-1){S=b[G>>1]|0;L=+($((i|0)%(S|0)|0,C)|0);O=+($((i|0)/(S|0)|0,D)|0);R=+((c[d>>2]|0)-(b[H>>1]|0)|0);M=+((c[e>>2]|0)-(b[j>>1]|0)|0);N=E+R;P=F+M;Q=A*L;L=A*(E+L);K=1.0-B*O;O=1.0-B*(F+O);g[I>>2]=R;g[k>>2]=P;g[l>>2]=Q;g[m>>2]=O;g[n>>2]=R;g[o>>2]=M;g[p>>2]=Q;g[q>>2]=K;g[r>>2]=N;g[s>>2]=P;g[t>>2]=L;g[u>>2]=O;g[v>>2]=N;g[w>>2]=M;g[x>>2]=L;g[y>>2]=K;rn(c[1882]|0,J);a=a+1|0}z=z+1|0;if((z|0)==(h|0))break;else{f=f+4|0;d=d+4|0;e=e+4|0}}}else a=0;sn(c[1882]|0,J);S=a;return S|0}function Bo(a,b,d,e,f,h,i,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;i=+i;j=j|0;k=+k;l=+l;m=+m;var n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){d=rd(4)|0;c[d>>2]=21;Te(d|0,8,0)}n=Mn(c[1882]|0,c[j+280>>2]|0)|0;if(!n){d=rd(4)|0;c[d>>2]=3;Te(d|0,8,0)}j=pn(c[1882]|0,n)|0;if(!j){d=rd(4)|0;c[d>>2]=3;Te(d|0,8,0)}q=+Rn(c[1882]|0,c[n+12>>2]|0,c[a+100>>2]|0,c[a+144>>2]|0);tn(c[1882]|0,+g[a+644>>2],+g[a+648>>2],+g[a+652>>2],q);q=+S(+m);p=+R(+m);o=+(c[a+68>>2]|0)-(p*h-q*i);m=+(c[a+72>>2]|0)-(q*h+p*i);s=q*l;r=p*l;p=p*k;l=q*k;h=+g[n+28>>2];q=+g[n+32>>2];k=+(b<<16>>16)*h;h=+((e<<16>>16)+(b<<16>>16)|0)*h;i=1.0-+(d<<16>>16)*q;q=1.0-+((f<<16>>16)+(d<<16>>16)|0)*q;g[j>>2]=o-s;g[j+4>>2]=r+m;g[j+12>>2]=k;g[j+16>>2]=q;g[j+36>>2]=p-s+o;g[j+40>>2]=l+r+m;g[j+48>>2]=h;g[j+52>>2]=q;g[j+72>>2]=o;g[j+76>>2]=m;g[j+84>>2]=k;g[j+88>>2]=i;g[j+108>>2]=p+o;g[j+112>>2]=l+m;g[j+120>>2]=h;g[j+124>>2]=i;qn(c[1882]|0,n);return}function Co(a,b){a=a|0;b=b|0;return}function Do(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0.0,k=0.0;if(!a)return;if((c[a+28>>2]|0)!=2){h=rd(4)|0;c[h>>2]=21;Te(h|0,8,0)}i=Mn(c[1882]|0,c[e+280>>2]|0)|0;if(!i){h=rd(4)|0;c[h>>2]=3;Te(h|0,8,0)}e=pn(c[1882]|0,i)|0;if(!e){h=rd(4)|0;c[h>>2]=3;Te(h|0,8,0)}k=+Rn(c[1882]|0,c[i+12>>2]|0,c[a+100>>2]|0,c[a+144>>2]|0);tn(c[1882]|0,1.0,1.0,1.0,k);k=+g[i+28>>2];j=+g[i+32>>2];g[e>>2]=+(c[b+12>>2]|0);g[e+4>>2]=+(c[d+12>>2]|0);g[e+12>>2]=k*+(c[f+12>>2]|0);g[e+16>>2]=j*+(c[h+12>>2]|0);g[e+36>>2]=+(c[b>>2]|0);g[e+40>>2]=+(c[d>>2]|0);g[e+48>>2]=k*+(c[f>>2]|0);g[e+52>>2]=j*+(c[h>>2]|0);g[e+72>>2]=+(c[b+8>>2]|0);g[e+76>>2]=+(c[d+8>>2]|0);g[e+84>>2]=k*+(c[f+8>>2]|0);g[e+88>>2]=j*+(c[h+8>>2]|0);g[e+108>>2]=+(c[b+4>>2]|0);g[e+112>>2]=+(c[d+4>>2]|0);g[e+120>>2]=k*+(c[f+4>>2]|0);g[e+124>>2]=j*+(c[h+4>>2]|0);qn(c[1882]|0,i);return}function Eo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0,k=0,l=0,m=0,n=0;l=i;i=i+16|0;m=l;if(!a){i=l;return}if((c[a+28>>2]|0)!=2){m=rd(4)|0;c[m>>2]=21;Te(m|0,8,0)}pI(m);o=0;k=qa(146,c[1882]|0)|0;n=o;o=0;if((((((!(n&1)?(o=0,h=+Ka(8,c[1882]|0,c[a+100>>2]|0,c[a+144>>2]|0),n=o,o=0,!(n&1)):0)?(o=0,sb(126,c[1882]|0,c[e+12>>2]|0,m|0),n=o,o=0,!(n&1)):0)?(g[k>>2]=+(c[b+12>>2]|0),g[k+4>>2]=+(c[d+12>>2]|0),c[k+12>>2]=c[m>>2],f=m+4|0,c[k+16>>2]=c[f>>2],j=m+8|0,c[k+20>>2]=c[j>>2],g[k+24>>2]=h,o=0,sb(126,c[1882]|0,c[e>>2]|0,m|0),n=o,o=0,!(n&1)):0)?(g[k+28>>2]=+(c[b>>2]|0),g[k+32>>2]=+(c[d>>2]|0),c[k+40>>2]=c[m>>2],c[k+44>>2]=c[f>>2],c[k+48>>2]=c[j>>2],g[k+52>>2]=h,o=0,sb(126,c[1882]|0,c[e+8>>2]|0,m|0),n=o,o=0,!(n&1)):0)?(g[k+56>>2]=+(c[b+8>>2]|0),g[k+60>>2]=+(c[d+8>>2]|0),c[k+68>>2]=c[m>>2],c[k+72>>2]=c[f>>2],c[k+76>>2]=c[j>>2],g[k+80>>2]=h,o=0,sb(126,c[1882]|0,c[e+4>>2]|0,m|0),n=o,o=0,!(n&1)):0)?(g[k+84>>2]=+(c[b+4>>2]|0),g[k+88>>2]=+(c[d+4>>2]|0),c[k+96>>2]=c[m>>2],c[k+100>>2]=c[f>>2],c[k+104>>2]=c[j>>2],g[k+108>>2]=h,o=0,Ja(445,c[1882]|0),n=o,o=0,!(n&1)):0){uI(m);i=l;return}f=zc()|0;o=0;Ja(413,m|0);n=o;o=0;if(n&1){n=zc(0)|0;Di(n)}else Kc(f|0)}function Fo(){var b=0,d=0,e=0;d=i;i=i+16|0;b=d;Gd(0,b|0)|0;b=~~(+(c[b+4>>2]|0)*.001*.001)+((c[b>>2]|0)*1e3|0)|0;if(!(a[33781]|0)){a[33781]=1;c[1879]=b;e=b;b=b-e|0;i=d;return b|0}else{e=c[1879]|0;e=b-e|0;i=d;return e|0}return 0}function Go(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function Ho(a){a=a|0;var b=0.0;a=a+-256|0;if(a>>>0>=16){b=0.0;return +b}b=+h[152+(a<<3)>>3];return +b}function Io(b,d,e){b=b|0;d=d|0;e=e|0;a[e>>0]=0;if(b>>>0>=3){d=0;return d|0}c[d>>2]=2;d=e;return d|0}function Jo(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0.0,i=0.0,j=0,k=0,l=0,m=0;cn(c[1882]|0,b);b=dn(c[1882]|0)|0;if(!b)return;j=a+68|0;k=a+72|0;l=a+100|0;m=a+144|0;do{d=c[b+40>>2]|0;do if(d){f=+g[d+48>>2];h=+g[d+52>>2];i=+g[d+40>>2];c[j>>2]=~~+g[d+16>>2];c[k>>2]=~~+g[d+20>>2];c[l>>2]=c[d+8>>2];c[m>>2]=c[b+16>>2];e=c[d+12>>2]|0;b=c[d+4>>2]|0;if(h==1.0&(f==1.0&i==0.0)){jl(a,e,b)|0;break}else{il(a,e,b,f,h,i)|0;break}}while(0);b=dn(c[1882]|0)|0}while((b|0)!=0);return}function Ko(a){a=a|0;return a|0}function Lo(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;f=~~(+(a|0)*+g[1872]);c[1880]=f;a=~~(+(d|0)*+g[1873]);c[1881]=a;c[1876]=e;d=c[1868]|0;if(!d)return;b[d+176>>1]=f;b[d+178>>1]=a;b[d+284>>1]=e;yl(d)|0;ll(d,0,c[1880]|0,c[1881]|0,(e|0)!=0);return}function Mo(){var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+48|0;j=k;if(!(ue(j|0)|0)){i=k;return}e=j+20|0;f=j+24|0;g=j+20|0;h=j+16|0;do switch(c[j>>2]|0){case 1024:{d=c[1884]|0;if(d){m=c[e>>2]|0;l=c[f>>2]|0;d=rf[c[d+72>>2]&255](0)|0;b[d+176>>1]=m;b[d+178>>1]=l;yl(d)|0;ll(d,-1,m,l,1)}break}case 1025:{Lo(c[g>>2]|0,c[f>>2]|0,1);break}case 1026:{Lo(c[g>>2]|0,c[f>>2]|0,0);break}case 768:{d=33782+(c[h>>2]|0)|0;if(!(a[d>>0]|0))a[d>>0]=1;break}case 769:{d=33782+(c[h>>2]|0)|0;if(a[d>>0]|0)a[d>>0]=0;break}default:{}}while((ue(j|0)|0)!=0);i=k;return}function No(b){b=b|0;return (a[33782+b>>0]|0)!=0|0}function Oo(a){a=a|0;var b=0,d=0;a=a+236|0;b=c[a>>2]|0;a:while(1){switch(b|0){case 9:{d=3;break a}case 1:{d=4;break a}case 2:break a;case 6:{d=7;break a}case 7:{d=8;break a}case 8:break;default:{d=10;break a}}c[a>>2]=3;b=3}if((d|0)==3){c[a>>2]=0;return}else if((d|0)==4)c[a>>2]=Mh(Fo()|0)|0;else if((d|0)==7){d=rd(4)|0;c[d>>2]=10;Te(d|0,8,0)}else if((d|0)==8){d=rd(4)|0;c[d>>2]=42;Te(d|0,8,0)}else if((d|0)==10)return;if(Nh(Fo()|0)|0)return;c[(c[1886]|0)+236>>2]=2;return}function Po(d){d=d|0;var f=0,g=0.0,j=0,k=0.0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;r=i;i=i+48|0;n=r+40|0;q=r+32|0;p=r+16|0;m=r;dm();bm(38,64);c[1882]=0;c[1883]=0;f=Z5(912)|0;o=0;Ja(446,f|0);s=o;o=0;if(s&1){s=zc()|0;$5(f);Kc(s|0)}c[1887]=f;if(d)Zg(f,d);c[1888]=960;c[1889]=640;if(((a[35325]|0)==126|0)==(0-(((a[35324]|0)==126&1)+(((a[35323]|0)==68&1)+(((a[35322]|0)==69&1)+(((a[35321]|0)==72&1)+(((a[35320]|0)==80&1)+(((a[35319]|0)==83&1)+((a[35318]|0)==72&1)))))))|0)){d=(r8(35327)|0)+65536|0;c[1888]=b[17669];c[1889]=b[17670];$g(c[1887]|0,e[17673]|0,c[8837]|0)}else d=0;f=Pd(35356)|0;if((f|0)!=0?(j=r8(f)|0,(j|0)>0):0)c[1888]=j;f=Pd(35363)|0;if((f|0)!=0?(l=r8(f)|0,(l|0)>0):0)c[1889]=l;f=Pd(35370)|0;if(!f)g=0.0;else g=+q8(f);f=Pd(35377)|0;if(!((f|0)!=0?(k=+q8(f),g>0.0&k>0.0):0)){g=+(c[1888]|0);k=+(c[1889]|0)}f=Pd(35384)|0;c[1890]=0;if(f)c[1890]=r8(f)|0;f=Pd(35392)|0;c[1891]=5e3;if(f)c[1891]=r8(f)|0;h[m>>3]=g;h[m+8>>3]=k;S7(35407,m)|0;f=Pd(35421)|0;if(f)k9(7568,f)|0;if(_g(c[1887]|0,d)|0){T7(35469)|0;s=1;i=r;return s|0}M9(33782,0,1536)|0;d=c[1887]|0;c[1886]=d;c[1885]=0;c[d+852>>2]=447;d=~~g;f=~~k;c[p>>2]=d;c[p+4>>2]=f;c[p+8>>2]=35449;S7(35434,p)|0;do if(!(Cd(32)|0)){rc(5,1)|0;if(!(Zc(d|0,f|0,16,67108864)|0)){c[n>>2]=Rb()|0;S7(35515,n)|0;break}else{fo(0,d,f,0);go(1,16777215,0);break}}else{c[q>>2]=Rb()|0;S7(35485,q)|0}while(0);f=Z5(696)|0;o=0;Ja(448,f|0);s=o;o=0;if(s&1){s=zc()|0;$5(f);Kc(s|0)}c[1882]=f;a[35545]=0;Vv(2,148);f=_C(c[1882]|0,0,c[1888]|0,c[1889]|0,0)|0;c[1883]=f;if(!f){T7(35545)|0;T7(36569)|0;s=1;i=r;return s|0}else{$C(f)|0;Lu(c[1882]|0);vi(yh(9)|0);wi(yh(10)|0);c[1884]=c[(c[1886]|0)+876>>2];s=xi()|0;c[1895]=s;c[s>>2]=36594;c[s+4>>2]=63688;c[s+8>>2]=55;c[s+12>>2]=32;c[s+20>>2]=147;c[s+16>>2]=56;s=0;i=r;return s|0}return 0}function Qo(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+1056|0;h=j+8|0;g=j;f=j+24|0;a=Ch()|0;b=Gh()|0;d=Ae(a|0)|0;e=Lh()|0;if((b|0)<0){c[g>>2]=a;c[g+4>>2]=d;W7(f,36605,g)|0;T7(f)|0;i=j;return}else{c[h>>2]=a;c[h+4>>2]=b;c[h+8>>2]=e;c[h+12>>2]=d;W7(f,36622,h)|0;T7(f)|0;i=j;return}}function Ro(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;h=j;if(!(a[36655]|0)){T7(36656)|0;i=j;return}switch(c[(c[1886]|0)+236>>2]|0){case 1:{f=Mh(Fo()|0)|0;c[(c[1886]|0)+236>>2]=f;f=5;break}case 2:{f=5;break}default:{}}if((f|0)==5?(Nh(Fo()|0)|0)!=0:0){i=j;return}Mo();b=c[1891]|0;a:do if((b|0)>0){b=0;b:while(1){e=_h(7584)|0;switch(c[(c[1886]|0)+236>>2]|0){case 4:case 5:{d=b;f=8;break b}case 2:case 1:{f=31;break b}default:{}}d=b+1|0;b=c[1891]|0;if((d|0)<(b|0))b=d;else break a}if((f|0)==8){b=c[1891]|0;d=d+1|0;break}else if((f|0)==31){i=j;return}}else{d=0;e=0}while(0);if((d|0)==(b|0)){f=c[6857]|0;c[h>>2]=b;E7(f,36661,h)|0}switch(e|0){case 5:{o=0;tb(7);j=o;o=0;if(!(j&1)){we();gd(-1)}Id(zc(0)|0)|0;Fd();we();gd(-1);break}case 0:{i=j;return}default:{if(c[1885]|0){ho()|0;c[1885]=0}we();do if((c[1883]|0)!=0?(hD(),g=c[1883]|0,(g|0)!=0):0){o=0;Ja(449,g|0);j=o;o=0;if(!(j&1)){$5(g);break}j=zc()|0;$5(g);Kc(j|0)}while(0);b=c[1882]|0;if(b)Kf[c[(c[b>>2]|0)+4>>2]&1023](b);b=c[1887]|0;if(!b)gd(0);o=0;Ja(450,b|0);j=o;o=0;if(j&1){j=zc()|0;$5(b);Kc(j|0)}else{$5(b);c[1887]=0;gd(0)}}}}function So(){a[36655]=1;return}function To(){var b=0,d=0;d=a[7568]|0;b=(d&1)==0;if(!((b?(d&255)>>>1:c[1893]|0)|0))a[36655]=1;else{a[36655]=0;$e(0,(b?7569:c[1894]|0)|0)|0}Oo(c[1886]|0);Qe(8,c[1890]|0,1);return 0}function Uo(){c[1892]=0;c[1893]=0;c[1894]=0;hc(451,7568,n|0)|0;return}function Vo(b,d){b=b|0;d=d|0;var e=0;b=i;i=i+16|0;e=b;c[e>>2]=d;S7(36974,e)|0;e=F8(35545)|0;if((e+1+(F8(d)|0)|0)>>>0<=1024){y8(35545,d)|0;i=b;return}a[35545]=0;y8(35545,d)|0;i=b;return}function Wo(a,b){a=a|0;b=b|0;return -1}function Xo(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;if(B8(b,36871)|0){f=-1;return f|0}f=a[7568]|0;b=(f&1)==0;if(!((b?(f&255)>>>1:c[1893]|0)|0)){f=-1;return f|0}$e(1,(b?7569:c[1894]|0)|0)|0;f=0;return f|0}function Yo(a){a=a|0;if(!(B8(a,36860)|0)){a=c[c[1895]>>2]|0;return a|0}if(B8(a,36865)|0){a=0;return a|0}a=c[(c[1895]|0)+4>>2]|0;return a|0}function Zo(a,b){a=a|0;b=b|0;c[b>>2]=-1;return 0}function _o(a,b){a=a|0;b=b|0;if((a|0)>1)a=c[b+4>>2]|0;else a=63688;a=Po(a)|0;if(a){b=a;return b|0}b=To()|0;return b|0}function $o(b){b=b|0;c[b>>2]=0;c[b+4>>2]=0;b=b+8|0;a[b>>0]=0;Kd(8)|0;ee(16)|0;if(!(ve(0,0,0,0)|0)){a[b>>0]=1;return}else Jb(36991,37e3,59,37021)}function ap(a){a=a|0;bp(a);if(!(Kd(0)|0)){vc();return}do Ue();while((Kd(0)|0)!=0);vc();return}function bp(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;g=a+4|0;d=c[g>>2]|0;if(!d)return;b=c[a>>2]|0;if((b|0)>0){e=0;while(1){if(d){Ie(c[d+36>>2]|0)|0;c[d+40>>2]=0;b=c[a>>2]|0}e=e+1|0;if((e|0)>=(b|0))break;else d=d+44|0}if((b|0)>0){b=c[g>>2]|0;e=b;f=0;while(1){d=e+(f*44|0)|0;if((c[d>>2]|0)==1){if(d){Ie(c[e+(f*44|0)+36>>2]|0)|0;c[e+(f*44|0)+40>>2]=0}ze(c[e+(f*44|0)+32>>2]|0);b=c[g>>2]|0;e=b}d=c[e+(f*44|0)+16>>2]|0;if(!d)d=e;else{a9(d);b=c[g>>2]|0;d=b}c[d+(f*44|0)+16>>2]=0;f=f+1|0;if((f|0)>=(c[a>>2]|0))break;else e=d}}else h=7}else h=7;if((h|0)==7)b=c[g>>2]|0;Nl(b);c[g>>2]=0;c[a>>2]=0;return}function cp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0;i=c[b>>2]|0;a:do if((i|0)>0){k=b+4|0;h=c[k>>2]|0;j=0;while(1){if((c[h+(j*44|0)+8>>2]|0)==(d|0))break;j=j+1|0;if((j|0)>=(i|0)){l=6;break a}}if((j|0)>=0){i=h+(j*44|0)|0;if((c[i>>2]|0)==1){if(i){Ie(c[h+(j*44|0)+36>>2]|0)|0;c[h+(j*44|0)+40>>2]=0}ze(c[h+(j*44|0)+32>>2]|0);h=c[k>>2]|0}i=c[h+(j*44|0)+16>>2]|0;if(i){a9(i);h=c[k>>2]|0}c[h+(j*44|0)+16>>2]=0;i=j}else l=6}else l=6;while(0);if((l|0)==6){if(!(a[b+8>>0]|0)){f=0;return f|0}k=i+1|0;c[b>>2]=k;k=k*44|0;h=b+4|0;j=c[h>>2]|0;if(!j){l=Ll(k)|0;c[h>>2]=l;h=l}else{l=Ol(j,k)|0;c[h>>2]=l;h=l}c[h+(i*44|0)>>2]=0;c[h+(i*44|0)+8>>2]=-1;c[h+(i*44|0)+36>>2]=-1}if((i|0)<0){f=0;return f|0}l=h+(i*44|0)|0;c[l>>2]=e;c[h+(i*44|0)+4>>2]=f;c[h+(i*44|0)+8>>2]=d;c[h+(i*44|0)+16>>2]=g;c[h+(i*44|0)+20>>2]=0;c[h+(i*44|0)+40>>2]=0;c[h+(i*44|0)+24>>2]=0;c[h+(i*44|0)+28>>2]=0;f=l;return f|0}function dp(a,b){a=a|0;b=b|0;bp(a);return}function ep(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+16|0;f=g;e=cp(a,d,1,e,0,0)|0;if(e){c[e+32>>2]=xd(b|0)|0;c[e+36>>2]=-1}c[f>>2]=b;c[f+4>>2]=d;Pp(37027,f);i=g;return 0}function fp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=c[a>>2]|0;if((d|0)<=0){g=1;return g|0}g=c[a+4>>2]|0;a=0;while(1){if((c[g+(a*44|0)+8>>2]|0)==(b|0)){e=a;break}a=a+1|0;if((a|0)>=(d|0)){a=1;f=10;break}}if((f|0)==10)return a|0;if((e|0)<0){g=1;return g|0}f=g+(e*44|0)|0;if((c[f>>2]|0)!=1|(f|0)==0){g=0;return g|0}a=c[g+(e*44|0)+4>>2]|0;d=g+(e*44|0)+36|0;b=c[d>>2]|0;if((b|0)>-1)Ie(b|0)|0;c[d>>2]=_d(-1,c[g+(e*44|0)+32>>2]|0,a<<31>>31|0,-1)|0;c[g+(e*44|0)+40>>2]=0;g=0;return g|0}function gp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=c[a>>2]|0;if((f|0)<=0)return;g=c[a+4>>2]|0;e=0;while(1){if((c[g+(e*44|0)+8>>2]|0)==(b|0))break;e=e+1|0;if((e|0)>=(f|0)){h=8;break}}if((h|0)==8)return;if((e|0)<0)return;a=(d|0)>0?0:d;a=(a|0)<-1e3?-1e3:a;c[g+(e*44|0)+24>>2]=a;if((c[g+(e*44|0)>>2]|0)!=1)return;Qb(c[g+(e*44|0)+36>>2]|0,~~(+(a+1e3|0)/1.0e3*128.0)|0)|0;return}function hp(a,b,c){a=a|0;b=b|0;c=c|0;return}function ip(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=c[a>>2]|0;if((e|0)<=0){g=0;return g|0}f=c[a+4>>2]|0;a=0;while(1){if((c[f+(a*44|0)+8>>2]|0)==(b|0))break;a=a+1|0;if((a|0)>=(e|0)){a=0;g=12;break}}if((g|0)==12)return a|0;if((a|0)<0){g=0;return g|0}if((c[f+(a*44|0)>>2]|0)!=1){g=0;return g|0}switch(d|0){case 0:{g=c[f+(a*44|0)+4>>2]|0;return g|0}case 1:{g=c[f+(a*44|0)+24>>2]|0;return g|0}case 2:{g=c[f+(a*44|0)+28>>2]|0;return g|0}case 16:return (Db(c[f+(a*44|0)+36>>2]|0)|0)!=0|0;default:{g=0;return g|0}}return 0}function jp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=c[a>>2]|0;d=(f|0)>0;if((b|0)<0){if(!d)return;d=f;e=0;f=c[a+4>>2]|0;while(1){if(f){Ie(c[f+36>>2]|0)|0;c[f+40>>2]=0;d=c[a>>2]|0}e=e+1|0;if((e|0)>=(d|0))break;else f=f+44|0}return}if(!d)return;e=c[a+4>>2]|0;d=0;while(1){if((c[e+(d*44|0)+8>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){g=13;break}}if((g|0)==13)return;if((d|0)<0|(e+(d*44|0)|0)==0)return;Ie(c[e+(d*44|0)+36>>2]|0)|0;c[e+(d*44|0)+40>>2]=0;return}function kp(a){a=a|0;var b=0;b=a+264|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[a+536>>2]=0;c[a+532>>2]=0;c[a>>2]=1;return}function lp(a){a=a|0;i9(a+264|0);return}function mp(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if((c[b>>2]|0)!=1){d=-1;return d|0}if(!e){k9(b+264|0,d)|0;d=b+276|0;a[d>>0]=71;a[d+1>>0]=69;a[d+2>>0]=84;a[d+3>>0]=0;c[b+532>>2]=0;c[b>>2]=2;d=0;return d|0}f=b+532|0;g=c[f>>2]|0;if(g){a9(g);c[f>>2]=0}g=$8((F8(e)|0)+1|0)|0;c[f>>2]=g;C8(g,e)|0;e=c[f>>2]|0;k9(b+264|0,d)|0;d=b+276|0;a[d>>0]=a[37057]|0;a[d+1>>0]=a[37058]|0;a[d+2>>0]=a[37059]|0;a[d+3>>0]=a[37060]|0;a[d+4>>0]=a[37061]|0;c[f>>2]=e;c[b>>2]=2;d=0;return d|0}function np(b,d){b=b|0;d=d|0;switch(d|0){case 0:{d=c[b>>2]|0;switch(d|0){case 3:case 2:{d=b+264|0;if(!(a[d>>0]&1))d=d+1|0;else d=c[b+272>>2]|0;yd(d|0,b+276|0,c[b+532>>2]|0,b|0,1,57,58,59)|0;c[b>>2]=4;b=4;return b|0}case 5:{c[b>>2]=1;b=1;return b|0}default:{b=d;return b|0}}}case 1:{b=c[b+4>>2]|0;return b|0}default:{b=0;return b|0}}return 0}function op(a,b){a=a|0;b=b|0;var d=0;switch(b|0){case 16:{b=c[a+536>>2]|0;if(!b)d=4;break}case 17:{b=a+8|0;break}default:d=4}if((d|0)==4)b=63688;return b|0}function pp(a,b,d){a=a|0;b=b|0;d=d|0;switch(b|0){case 16:{b=a+536|0;d=c[b>>2]|0;if(!d)return;a9(d);c[b>>2]=0;return}case 17:{c[a>>2]=-1;C8(a+8|0,d)|0;return}default:return}}function qp(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;c[d>>2]=5;b=$8(f+1|0)|0;c[d+536>>2]=b;K9(b|0,e|0,f|0)|0;a[b+f>>0]=0;c[d+4>>2]=f;return}function rp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;a=i;i=i+272|0;g=a;f=a+8|0;c[g>>2]=d;c[g+4>>2]=e;W7(f,37062,g)|0;c[b>>2]=-1;C8(b+8|0,f)|0;i=a;return}function sp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function tp(a){a=a|0;return b9(a,1)|0}function up(a){a=a|0;a9(a);return}function vp(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;if((a[b>>0]|0)!=47)b=Ko(b)|0;if((e|0)<0)b=D7(b,37124)|0;else b=D7(b,37127)|0;if(!b){e=-1;return e|0}if((e|0)>-1)K7(b,e,0)|0;e=P7(c,1,d,b)|0;y7(b)|0;return e|0}function wp(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if(!(a[c>>0]|0)){c=0;return c|0}d=a[b>>0]|0;if(!(d<<24>>24)){c=0;return c|0}a:while(1){g=b;h=c;while(1){e=a[h>>0]|0;if(!(e<<24>>24)){d=11;break a}f=a[g>>0]|0;if(!(f<<24>>24))break;if(e<<24>>24==f<<24>>24){g=g+1|0;h=h+1|0}else break}b=b+1|0;if(d<<24>>24<0)while(1){d=a[b>>0]|0;if(d<<24>>24!=0&(d&-64)<<24>>24==-128)b=b+1|0;else break}else d=a[b>>0]|0;if(!(d<<24>>24)){b=0;d=11;break}}if((d|0)==11)return b|0;return 0}function xp(b,c){b=b|0;c=c|0;var d=0,e=0;d=a[b>>0]|0;if(!(d<<24>>24)){e=0;return e|0}e=c<<24>>24;d=d&255;c=0;while(1){c=(d|0)==(e|0)?b:c;b=b+1|0;if(!(d&128))d=a[b>>0]|0;else while(1){d=a[b>>0]|0;if(d<<24>>24!=0&(d&-64)<<24>>24==-128)b=b+1|0;else break}if(!(d<<24>>24))break;else d=d&255}return c|0}function yp(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+1536|0;n=q+1280|0;o=q+1024|0;k=q+768|0;j=q+512|0;m=q+256|0;l=q;if((d&16|0)!=0?(e=a[b>>0]|0,e<<24>>24!=0):0){g=b;while(1){a[g>>0]=V6(e&255)|0;f=g+1|0;if((e&255)>128)f=(e+96&255)>63?g+2|0:f;e=a[f>>0]|0;if(!(e<<24>>24))break;else g=f}}a[k>>0]=0;C8(n,b)|0;e=a[n>>0]|0;if(e<<24>>24){g=e&255;h=n;f=0;while(1){f=(g|0)==46?h:f;h=h+1|0;if(!(g&128))g=a[h>>0]|0;else while(1){g=a[h>>0]|0;if(g<<24>>24!=0&(g&-64)<<24>>24==-128)h=h+1|0;else break}if(!(g<<24>>24))break;else g=g&255}if(f){C8(l,f)|0;a[f>>0]=0;e=a[n>>0]|0}else p=13}else p=13;if((p|0)==13)a[l>>0]=0;if(e<<24>>24){f=e&255;g=n;e=0;while(1){e=(f|0)==47?g:e;g=g+1|0;if(!(f&128))f=a[g>>0]|0;else while(1){f=a[g>>0]|0;if(f<<24>>24!=0&(f&-64)<<24>>24==-128)g=g+1|0;else break}if(!(f<<24>>24))break;else f=f&255}if(e){h=e+1|0;C8(m,h)|0;a[h>>0]=0;C8(j,n)|0}else p=22}else p=22;if((p|0)==22){a[j>>0]=0;C8(m,n)|0}y8(k,j)|0;do if(!(d&8))if(!(d&32)){C8(o,b)|0;break}else{C8(o,k)|0;break}else{C8(o,m)|0;y8(o,l)|0}while(0);switch(d&7|0){case 1:{a[b+((F8(o)|0)-(F8(l)|0))>>0]=0;C8(c,o)|0;i=q;return}case 2:{C8(c,l)|0;i=q;return}default:{C8(c,o)|0;i=q;return}}}function zp(a){a=a|0;return w7(a,493)|0}function Ap(a){a=a|0;return M8(a)|0}function Bp(a){a=a|0;return P8(a)|0}function Cp(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=i;i=i+336|0;m=p;o=p+76|0;O8(o,256)|0;o=Y6(o)|0;f=Z6(o)|0;if(!f){n=0;X6(o)|0;i=p;return n|0}k=(e&4|0)==0;l=m+12|0;if(!e){j=f;f=0;do{h=j+11|0;m=a[h>>0]|0;g=m<<24>>24!=0&1;if(m<<24>>24==46){m=a[j+12>>0]|0;g=m<<24>>24==0?0:g;if(!(m<<24>>24==46?(a[j+13>>0]|0)==0:0))n=21}else n=21;if((n|0)==21){n=0;if((g|0)!=0?(Qp(h,b)|0)!=0:0){Ql(d,h);Ql(d,63797);f=f+1|0}}j=Z6(o)|0}while((j|0)!=0);X6(o)|0;i=p;return f|0}else{h=f;f=0}do{j=h+11|0;q=a[j>>0]|0;g=q<<24>>24!=0&1;if(q<<24>>24==46){q=a[h+12>>0]|0;g=q<<24>>24==0?0:g;if(!(q<<24>>24==46?(a[h+13>>0]|0)==0:0))n=6}else n=6;do if((n|0)==6){n=0;if((g|0)==1){x7(j,m)|0;if(!k)if((c[l>>2]&61440|0)==32768?(a[j>>0]|0)!=46:0)break;else g=3;else g=0;h=g^e;if(!(h&1))g=1;else g=(c[l>>2]&61440|0)!=16384&1;if((h&2|0)!=0?(a[j>>0]|0)==46:0)break}if((g|0)!=0?(Qp(j,b)|0)!=0:0){Ql(d,j);Ql(d,63797);f=f+1|0}}while(0);h=Z6(o)|0}while((h|0)!=0);X6(o)|0;i=p;return f|0}function Dp(a){a=a|0;var b=0,d=0,e=0;e=i;i=i+16|0;d=e;cd(d|0,0)|0;b=ce(d|0)|0;switch(a|0){case 0:{b=(c[b+20>>2]|0)+1900|0;break}case 1:{b=(c[b+16>>2]|0)+1|0;break}case 2:{b=c[b+24>>2]|0;break}case 3:{b=c[b+12>>2]|0;break}case 4:{b=c[b+8>>2]|0;break}case 5:{b=c[b+4>>2]|0;break}case 6:{b=c[b>>2]|0;break}case 7:{b=(c[d+4>>2]|0)/1e4|0;break}case 8:{b=(c[d+4>>2]|0)%1e4|0;break}default:b=0}i=e;return b|0}function Ep(){c[1897]=0;return}function Fp(){return c[1897]|0}function Gp(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;k=e<<24>>24;g=0;a:do{i=c[1897]|0;e=a[b+i>>0]|0;j=e&255;if(!(e<<24>>24)){e=0;break}h=i+1|0;c[1897]=h;if((j|0)==(k|0))break;switch(e<<24>>24){case 10:{e=10;break a}case 13:{e=g;l=5;break a}default:{}}h=g+1|0;a[d+g>>0]=e;if(j&128){g=c[1897]|0;e=a[b+g>>0]|0;if(e<<24>>24!=0&(e&-64)<<24>>24==-128){i=g;while(1){c[1897]=i+1;g=h+1|0;a[d+h>>0]=e;i=c[1897]|0;e=a[b+i>>0]|0;if(!(e<<24>>24!=0&(e&-64)<<24>>24==-128))break;else h=g}}else g=h}else g=h}while((g|0)<(f|0));if((l|0)==5)if((a[b+h>>0]|0)==10){c[1897]=i+2;g=e;e=13}else{g=e;e=13}a[d+g>>0]=0;return e&255|0}function Hp(a,b,c){a=a|0;b=b|0;c=c|0;return ((a|0)>(c|0)?c:(a|0)<(b|0)?b:a)|0}function Ip(b){b=b|0;var c=0,d=0,e=0,f=0;c=a[b>>0]|0;if(!(c<<24>>24)){b=0;return b|0}else{d=c;c=0;f=0}do{f=f+1|0;e=(V6(d<<24>>24)|0)<<24;d=e>>24;if((e+-788529153|0)>>>0<184549375)d=d+-48|0;else d=(e+-1610612737|0)>>>0<117440511?d+-87|0:0;c=d+(c<<4)|0;d=a[b+f>>0]|0}while(d<<24>>24!=0);return c|0}function Jp(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;d=a[b>>0]|0;if(!(d<<24>>24))return;k=c&255;j=F8(b)|0;while(1){i=0;g=d&255;h=b;c=0;while(1){d=h+1|0;if(!(g&128)){f=a[d>>0]|0;e=d}else{e=d;while(1){d=a[e>>0]|0;if(d<<24>>24!=0&(d&-64)<<24>>24==-128)e=e+1|0;else{f=d;break}}}g=(g|0)!=(k|0)|(h|0)==0;d=g?i:h;c=g?c:e;if(!(f<<24>>24))break;else{i=d;g=f&255;h=e}}if(!((d|0)!=0&(c|0)==(b+j|0))){c=10;break}a[d>>0]=0;j=F8(b)|0;d=a[b>>0]|0;if(!(d<<24>>24)){c=10;break}}if((c|0)==10)return}function Kp(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=a[b>>0]|0;if(!(d<<24>>24))return;g=c&255;a:while(1){e=d&255;c=b;while(1){d=c+1|0;if(!(e&128))f=d;else while(1){f=a[d>>0]|0;if(f<<24>>24!=0&(f&-64)<<24>>24==-128)d=d+1|0;else{f=d;break}}if(!((e|0)!=(g|0)|(c|0)==0)){d=f;break}d=a[f>>0]|0;if(!(d<<24>>24)){d=9;break a}else{e=d&255;c=f}}C8(c,d)|0;d=a[b>>0]|0;if(!(d<<24>>24)){d=9;break}}if((d|0)==9)return}function Lp(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=a[b>>0]|0;if(!(d<<24>>24))return;e=c&255;f=b+1|0;c=d;while(1){c=c&255;d=(c|0)==(e|0)?b:0;if(!(c&128))c=f;else{c=f;while(1){g=a[c>>0]|0;if(g<<24>>24!=0&(g&-64)<<24>>24==-128)c=c+1|0;else break}}if(!d){c=7;break}C8(d,c)|0;c=a[b>>0]|0;if(!(c<<24>>24)){c=7;break}}if((c|0)==7)return}function Mp(b,d){b=b|0;d=d|0;c[1898]=b;b=(F8(b)|0)+16384|0;b=(b|0)<32768?32768:b;c[1899]=b;b=Ll(b)|0;c[1900]=b;a[b>>0]=0;b=F8(d)|0;c[1901]=b;b=Ll(b+1|0)|0;c[1902]=b;K9(b|0,d|0,(c[1901]|0)+1|0)|0;return}function Np(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c[1903]=b;c[1904]=F8(b)|0;c[1905]=0;d=c[1898]|0;j=a[c[1902]>>0]|0;b=a[d>>0]|0;if(!(b<<24>>24)){k=0;j=c[1900]|0;k=j+k|0;a[k>>0]=0;k=c[1900]|0;return k|0}else{i=b;h=0}while(1){if(i<<24>>24==j<<24>>24){g=c[1901]|0;e=(u8(d,c[1902]|0,g)|0)==0;f=e?c[1904]|0:1;g=e?g:0}else{f=1;g=0}b=f+h|0;e=c[1899]|0;if((b|0)>=(e|0)){e=e+32768|0;c[1899]=e;c[1900]=Ol(c[1900]|0,e)|0}if(!g){b=h+1|0;a[(c[1900]|0)+h>>0]=i;d=d+1|0;if(i<<24>>24<0?(k=a[d>>0]|0,k<<24>>24!=0&(k&-64)<<24>>24==-128):0){f=k;while(1){d=d+1|0;e=b+1|0;a[(c[1900]|0)+b>>0]=f;f=a[d>>0]|0;if(!(f<<24>>24!=0&(f&-64)<<24>>24==-128)){b=e;break}else b=e}}}else{K9((c[1900]|0)+h|0,c[1903]|0,f|0)|0;c[1905]=(c[1905]|0)+1;d=d+g|0}i=a[d>>0]|0;if(!(i<<24>>24))break;else h=b}k=c[1900]|0;k=k+b|0;a[k>>0]=0;k=c[1900]|0;return k|0}function Op(){Nl(c[1902]|0);Nl(c[1900]|0);return c[1905]|0}function Pp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+4112|0;e=d+16|0;f=d;c[f>>2]=b;a8(e,a,f)|0;$e(2,e|0)|0;i=d;return}function Qp(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=b;a:while(1){i=a[c>>0]|0;c=c+1|0;if(!(i<<24>>24)){b=a[d>>0]|0;if(!(b<<24>>24)){b=1;c=13;break}}else{g=i<<24>>24==42;f=a[d>>0]|0;e=f<<24>>24==0;if(g){b=a[c>>0]|0;h=b<<24>>24==42&1;while(1){if(e){c=7;break a}if((b<<24>>24==f<<24>>24|h|0)!=0?(Qp(d,c)|0)!=0:0){b=1;c=13;break a}d=d+1|0;f=a[d>>0]|0;e=f<<24>>24==0;if(!g){b=f;break}}}else b=f;if(e){b=0;c=13;break}}if(i<<24>>24!=b<<24>>24){b=0;c=13;break}else d=d+1|0}if((c|0)==7)return b<<24>>24==0|0;else if((c|0)==13)return b|0;return 0}function Rp(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0;oE(a);c[a>>2]=7632;o=0;j=qb(14)|0;k=o;o=0;if(!(k&1)?(c[a+8>>2]=c[j+84>>2],m=a+12|0,k=F8(b)|0,o=0,sb(127,m|0,b|0,k|0),k=o,o=0,!(k&1)):0){b=a+24|0;j=a+28|0;k=a+32|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;o=0;ea(1,a|0,d|0,e|0,f|0,g|0,h|0,i|0)|0;i=o;o=0;if(!(i&1)?(o=0,Ja(452,a|0),i=o,o=0,!(i&1)):0)return;g=zc()|0;j=c[j>>2]|0;b=j;if(j){f=c[k>>2]|0;if((f|0)!=(j|0))c[k>>2]=f+(~((f+-4-b|0)>>>2)<<2);$5(j)}o=0;Ja(451,m|0);m=o;o=0;if(m&1){m=zc(0)|0;Di(m)}else l=g}else l=zc()|0;o=0;m=o;o=0;if(m&1){m=zc(0)|0;Di(m)}else Kc(l|0)}function Sp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+16|0;s=t;j=dg[c[c[b>>2]>>2]&127](b,d)|0;r=ms(e,j)|0;a:do if((c[b+4>>2]|0)==1)switch(d|0){case 16:case 8:{As(r,0);break a}case 17:{As(r,3);break a}default:break a}while(0);k=c[f>>2]|0;p=e+-1|0;q=(c[f+(p<<2)>>2]|0)-k|0;rs(r,0,0.0,g,h);if(p>>>0>1){m=+(q>>>0);l=1;n=j;while(1){rs(r,l,+(((c[f+(l<<2)>>2]|0)-k|0)>>>0)/m,g+(n<<2)|0,h);l=l+1|0;if((l|0)==(p|0))break;else n=n+j|0}j=$(j,p)|0}if(e>>>0>1)rs(r,p,1.0,g+(j<<2)|0,h);f=Z5(20)|0;c[f>>2]=a;j=f+4|0;c[j>>2]=b;c[f+8>>2]=d;c[f+12>>2]=r;l=f+16|0;c[l>>2]=q;o=0;Ja(453,r|0);q=o;o=0;if(q&1){t=zc()|0;$5(f);Kc(t|0)}o=0;na(149,c[j>>2]|0,f|0);q=o;o=0;if(q&1){t=zc()|0;$5(f);Kc(t|0)}o=0;Ja(453,c[f>>2]|0);q=o;o=0;if(q&1){t=zc()|0;$5(f);Kc(t|0)}tE(r);c[s>>2]=f;j=a+32|0;k=c[j>>2]|0;if((k|0)==(c[a+36>>2]|0))dq(a+28|0,s);else{c[k>>2]=f;c[j>>2]=(c[j>>2]|0)+4}k=c[l>>2]|0;j=a+24|0;if(k>>>0<=(c[j>>2]|0)>>>0){i=t;return f|0}c[j>>2]=k;i=t;return f|0}function Tp(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c[a>>2]=7632;k=a+28|0;b=c[k>>2]|0;l=a+32|0;d=c[l>>2]|0;if((d|0)!=(b|0))c[l>>2]=d+(~((d+-4-b|0)>>>2)<<2);d=a+40|0;b=c[d>>2]|0;a:do if(!b)j=10;else{o=0;b=cb(57,b|0,1)|0;j=o;o=0;do if(!(j&1)){if(b?(o=0,na(150,c[a+8>>2]|0,c[d>>2]|0),j=o,o=0,j&1):0)break;b=c[d>>2]|0;if(!b){j=10;break a}o=0;Ja(452,b|0);j=o;o=0;if(!(j&1)){c[d>>2]=0;j=10;break a}}while(0);f=zc()|0;j=34}while(0);do if((j|0)==10){i=a+44|0;b=c[i>>2]|0;if(b){d=c[b>>2]|0;if((d|0)!=(c[b+4>>2]|0)){g=a+8|0;while(1){b=c[d>>2]|0;o=0;e=cb(57,b|0,1)|0;f=o;o=0;if(f&1){j=32;break}if(e?(o=0,na(150,c[g>>2]|0,b|0),f=o,o=0,f&1):0){j=32;break}if((b|0)!=0?(o=0,Ja(452,b|0),f=o,o=0,f&1):0){j=32;break}f=d+4|0;b=c[i>>2]|0;e=b+4|0;if((f|0)==(c[e>>2]|0)){g=d;break}else d=f}if((j|0)==32){f=zc()|0;j=34;break}d=c[b>>2]|0;if((f|0)!=(d|0))c[e>>2]=g+(0-((g-d|0)>>>2)<<2)}e=d;if(d){f=b+4|0;g=c[f>>2]|0;if((g|0)!=(d|0))c[f>>2]=g+(~((g+-4-e|0)>>>2)<<2);$5(d)}$5(b)}c[i>>2]=0;b=c[k>>2]|0;d=b;if(b){e=c[l>>2]|0;if((e|0)!=(b|0))c[l>>2]=e+(~((e+-4-d|0)>>>2)<<2);$5(b)}o=0;Ja(451,a+12|0);a=o;o=0;if(a&1){h=zc()|0;break}else return}while(0);if((j|0)==34){b=c[k>>2]|0;d=b;if(b){e=c[l>>2]|0;if((e|0)!=(b|0))c[l>>2]=e+(~((e+-4-d|0)>>>2)<<2);$5(b)}o=0;Ja(451,a+12|0);a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else h=f}o=0;a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else Kc(h|0)}function Up(a){a=a|0;var b=0;o=0;Ja(8,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function Vp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a>>2]=d;d=a+4|0;c[d>>2]=e;c[a+8>>2]=c[b+8>>2];e=c[b+12>>2]|0;c[a+12>>2]=e;c[a+16>>2]=c[b+16>>2];sE(e);Hq(c[d>>2]|0,a);sE(c[a>>2]|0);return}function Wp(a){a=a|0;var b=0,d=0;b=a+12|0;d=c[b>>2]|0;if(d){tE(d);c[b>>2]=0}b=c[a>>2]|0;if(!b)return;tE(b);c[a>>2]=0;return}function Xp(a){a=a|0;return c[a+12>>2]|0}function Yp(a){a=a|0;return c[a+24>>2]|0}function Zp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;h=i;i=i+16|0;f=h;g=Z5(120)|0;o=0;fa(22,g|0,b|0,a|0,d|0,e|0);d=o;o=0;if(d&1){h=zc()|0;$5(g);Kc(h|0)}c[f>>2]=g;e=a+44|0;b=c[e>>2]|0;if(!b){b=Z5(12)|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[e>>2]=b}e=b+4|0;d=c[e>>2]|0;if((d|0)==(c[b+8>>2]|0)){eq(b,f);i=h;return g|0}else{c[d>>2]=g;c[e>>2]=(c[e>>2]|0)+4;i=h;return g|0}return 0}function _p(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;if(!b){e=a+40|0;d=c[e>>2]|0;if(d){b=d;return b|0}d=Z5(120)|0;o=0;fa(22,d|0,37193,a|0,0,c[a+24>>2]|0);b=o;o=0;if(b&1){b=zc()|0;$5(d);Kc(b|0)}c[e>>2]=d;b=d;return b|0}g=a+44|0;a=c[g>>2]|0;if(!a){b=0;return b|0}e=c[a+4>>2]|0;d=c[a>>2]|0;h=e-d>>2;if(!h){b=0;return b|0}else f=0;while(1){if(e-d>>2>>>0<=f>>>0){E9(a);d=c[a>>2]|0}d=c[d+(f<<2)>>2]|0;f=f+1|0;if(!(D9(d+8|0,b)|0)){e=13;break}if(f>>>0>=h>>>0){d=0;e=13;break}a=c[g>>2]|0;e=c[a+4>>2]|0;d=c[a>>2]|0}if((e|0)==13)return d|0;return 0}function $p(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;if(!b){e=a+40|0;d=c[e>>2]|0;do if(!d){d=Z5(120)|0;o=0;fa(22,d|0,37193,a|0,0,c[a+24>>2]|0);i=o;o=0;if(i&1){i=zc()|0;$5(d);Kc(i|0)}else{c[e>>2]=d;break}}while(0);lq(d);return}g=a+44|0;a=c[g>>2]|0;if(!a)return;e=c[a+4>>2]|0;d=c[a>>2]|0;h=e-d>>2;if(!h)return;else f=0;while(1){if(e-d>>2>>>0<=f>>>0){E9(a);d=c[a>>2]|0}d=c[d+(f<<2)>>2]|0;f=f+1|0;if(!(D9(d+8|0,b)|0))break;if(f>>>0>=h>>>0){i=16;break}a=c[g>>2]|0;e=c[a+4>>2]|0;d=c[a>>2]|0}if((i|0)==16)return;if(!d)return;lq(d);return}function aq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;i=i+16|0;d=g;c[d>>2]=b;e=a+32|0;f=c[e>>2]|0;if((f|0)==(c[a+36>>2]|0))dq(a+28|0,d);else{c[f>>2]=b;c[e>>2]=(c[e>>2]|0)+4}e=c[b+16>>2]|0;d=a+24|0;if(e>>>0<=(c[d>>2]|0)>>>0){i=g;return}c[d>>2]=e;i=g;return}function bq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a+28>>2]|0;g=a+32|0;d=c[g>>2]|0;if((e|0)==(d|0))return;else a=e;while(1){if((c[a>>2]|0)==(b|0))break;a=a+4|0;if((a|0)==(d|0)){f=6;break}}if((f|0)==6)return;f=e+((a-e>>2)+1<<2)|0;d=d-f|0;L9(a|0,f|0,d|0)|0;a=a+(d>>2<<2)|0;d=c[g>>2]|0;if((d|0)==(a|0))return;c[g>>2]=d+(~((d+-4-a|0)>>>2)<<2);return}function cq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+16|0;l=m;n=Z5(48)|0;f=b+12|0;if(!(a[f>>0]&1))g=f+1|0;else g=c[b+20>>2]|0;o=0;Ja(454,n|0);k=o;o=0;if(!(k&1)){c[n>>2]=7632;o=0;f=qb(14)|0;k=o;o=0;if(!(k&1)?(c[n+8>>2]=c[f+84>>2],k=F8(g)|0,o=0,sb(127,n+12|0,g|0,k|0),k=o,o=0,!(k&1)):0){k=n+24|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;j=Z5(20)|0;c[j>>2]=n;f=j+4|0;c[f>>2]=e;c[j+8>>2]=c[d+8>>2];e=c[d+12>>2]|0;c[j+12>>2]=e;h=j+16|0;c[h>>2]=c[d+16>>2];o=0;Ja(453,e|0);d=o;o=0;if((!(d&1)?(o=0,na(149,c[f>>2]|0,j|0),d=o,o=0,!(d&1)):0)?(o=0,Ja(453,c[j>>2]|0),d=o,o=0,!(d&1)):0){c[l>>2]=j;f=n+32|0;g=c[f>>2]|0;if((g|0)==(c[n+36>>2]|0))dq(n+28|0,l);else{c[g>>2]=j;c[f>>2]=(c[f>>2]|0)+4}f=c[h>>2]|0;if(f>>>0>(c[k>>2]|0)>>>0)c[k>>2]=f;tE(n);f=c[b+40>>2]|0;if(f)c[n+40>>2]=rq(f,n)|0;d=b+44|0;f=c[d>>2]|0;if(!f){i=m;return n|0}g=c[f>>2]|0;if((g|0)==(c[f+4>>2]|0)){i=m;return n|0}e=n+44|0;do{k=rq(c[g>>2]|0,n)|0;c[l>>2]=k;f=c[e>>2]|0;if(!f){f=Z5(12)|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[e>>2]=f}h=f+4|0;j=c[h>>2]|0;if((j|0)==(c[f+8>>2]|0))eq(f,l);else{c[j>>2]=k;c[h>>2]=(c[h>>2]|0)+4}g=g+4|0}while((g|0)!=(c[(c[d>>2]|0)+4>>2]|0));i=m;return n|0}n=zc()|0;$5(j);Kc(n|0)}f=zc()|0;o=0;m=o;o=0;if(m&1){m=zc(0)|0;Di(m)}else h=f}else h=zc()|0;$5(n);n=h;Kc(n|0);return 0}function dq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=a+4|0;d=c[a>>2]|0;e=d;h=((c[l>>2]|0)-e>>2)+1|0;if(h>>>0>1073741823){X5(a);e=c[a>>2]|0;d=e}k=a+8|0;g=d;f=(c[k>>2]|0)-g|0;if(f>>2>>>0<536870911){f=f>>1;f=f>>>0<h>>>0?h:f;h=(c[l>>2]|0)-g|0;g=h>>2;if(!f){j=0;i=0;f=h}else m=6}else{h=(c[l>>2]|0)-g|0;f=1073741823;g=h>>2;m=6}if((m|0)==6){j=f;i=Z5(f<<2)|0;f=h}c[i+(g<<2)>>2]=c[b>>2];K9(i|0,d|0,f|0)|0;c[a>>2]=i;c[l>>2]=i+(g+1<<2);c[k>>2]=i+(j<<2);if(!e)return;$5(e);return}function eq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=a+4|0;d=c[a>>2]|0;e=d;h=((c[l>>2]|0)-e>>2)+1|0;if(h>>>0>1073741823){X5(a);e=c[a>>2]|0;d=e}k=a+8|0;g=d;f=(c[k>>2]|0)-g|0;if(f>>2>>>0<536870911){f=f>>1;f=f>>>0<h>>>0?h:f;h=(c[l>>2]|0)-g|0;g=h>>2;if(!f){j=0;i=0;f=h}else m=6}else{h=(c[l>>2]|0)-g|0;f=1073741823;g=h>>2;m=6}if((m|0)==6){j=f;i=Z5(f<<2)|0;f=h}c[i+(g<<2)>>2]=c[b>>2];K9(i|0,d|0,f|0)|0;c[a>>2]=i;c[l>>2]=i+(g+1<<2);c[k>>2]=i+(j<<2);if(!e)return;$5(e);return}function fq(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+16|0;l=n;oE(b);c[b>>2]=7648;r=b+8|0;p=F8(d)|0;o=0;sb(127,r|0,d|0,p|0);p=o;o=0;if(!(p&1)){k=b+20|0;c[k>>2]=e;c[b+24>>2]=f;c[b+28>>2]=h;m=h-f|0;c[b+32>>2]=m;a[b+36>>0]=0;g[b+40>>2]=1.0;c[b+44>>2]=0;c[b+48>>2]=~~+(m>>>0)>>>0;g[b+52>>2]=1.0;m=b+56|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;c[m+20>>2]=0;g[b+80>>2]=1.0;m=b+84|0;p=b+88|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;c[m+20>>2]=0;c[m+24>>2]=0;c[m+28>>2]=0;j=(c[e+32>>2]|0)-(c[e+28>>2]|0)>>2;if(!j){i=n;return}f=b+92|0;e=0;while(1){o=0;d=qa(141,12)|0;b=o;o=0;if(b&1){h=13;break}o=0;h=qa(148,c[(c[(c[k>>2]|0)+28>>2]|0)+(e<<2)>>2]|0)|0;b=o;o=0;if(b&1){h=14;break}o=0;h=qa(149,h|0)|0;b=o;o=0;if(b&1){h=14;break}o=0;na(151,d|0,h|0);b=o;o=0;if(b&1){h=14;break}c[l>>2]=d;h=c[p>>2]|0;if((h|0)==(c[f>>2]|0)){o=0;na(152,m|0,l|0);b=o;o=0;if(b&1){h=13;break}}else{c[h>>2]=d;c[p>>2]=(c[p>>2]|0)+4}e=e+1|0;if(e>>>0>=j>>>0){h=15;break}}if((h|0)==13)e=zc()|0;else if((h|0)==14){e=zc()|0;$5(d)}else if((h|0)==15){i=n;return}d=c[m>>2]|0;h=d;if(d){f=c[p>>2]|0;if((f|0)!=(d|0))c[p>>2]=f+(~((f+-4-h|0)>>>2)<<2);$5(d)}o=0;Ja(451,r|0);r=o;o=0;if(r&1){r=zc(0)|0;Di(r)}else q=e}else q=zc()|0;o=0;r=o;o=0;if(r&1){r=zc(0)|0;Di(r)}else Kc(q|0)}function gq(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;c[a>>2]=7648;l=a+84|0;b=c[l>>2]|0;m=a+88|0;do if((b|0)!=(c[m>>2]|0)){e=b;while(1){b=c[e>>2]|0;if(b){o=0;Ja(455,b|0);h=o;o=0;if(h&1){j=6;break}$5(b)}c[e>>2]=0;d=e+4|0;if((d|0)==(c[m>>2]|0))break;else e=d}if((j|0)==6){k=zc()|0;$5(b);b=k;j=59;break}b=c[l>>2]|0;if((d|0)!=(b|0)){c[m>>2]=e+(0-((e-b|0)>>>2)<<2);j=9}else j=9}else j=9;while(0);a:do if((j|0)==9){b=a+68|0;d=c[b>>2]|0;do if(d){o=0;Ja(452,d|0);h=o;o=0;if(h&1){b=zc()|0;break}else{c[b>>2]=0;j=15;break}}else j=15;while(0);b:do if((j|0)==15){b=a+96|0;d=c[b>>2]|0;if(d){e=c[d>>2]|0;f=e;if(e){g=d+4|0;h=c[g>>2]|0;if((h|0)!=(e|0))c[g>>2]=h+(~((h+-4-f|0)>>>2)<<2);$5(e)}$5(d)}c[b>>2]=0;b=a+100|0;d=c[b>>2]|0;if(d){e=c[d>>2]|0;f=e;if(e){g=d+4|0;h=c[g>>2]|0;if((h|0)!=(e|0))c[g>>2]=h+(~((h+-4-f|0)>>>2)<<2);$5(e)}$5(d)}c[b>>2]=0;g=a+112|0;b=c[g>>2]|0;if(b){e=c[b+4>>2]|0;d=c[b>>2]|0;do if((e|0)!=(d|0)){f=0;while(1){d=c[d+(f<<2)>>2]|0;if(d){o=0;Ja(c[(c[d>>2]|0)+4>>2]|0,d|0);j=o;o=0;if(j&1){j=12;break}b=c[g>>2]|0}c[(c[b>>2]|0)+(f<<2)>>2]=0;f=f+1|0;b=c[g>>2]|0;e=c[b+4>>2]|0;d=c[b>>2]|0;if(f>>>0>=e-d>>2>>>0){j=33;break}}if((j|0)==12){b=zc()|0;break b}else if((j|0)==33)if(!b)break;else{j=34;break}}else{d=e;j=34}while(0);if((j|0)==34){f=d;if(d){if((e|0)!=(d|0))c[b+4>>2]=e+(~((e+-4-f|0)>>>2)<<2);$5(d)}$5(b)}c[g>>2]=0}f=a+104|0;b=c[f>>2]|0;g=a+108|0;if(b){c[c[g>>2]>>2]=c[b+4>>2];e=c[g>>2]|0;d=c[f>>2]|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{b=c[b+8>>2]|0;if(b){$5(b);e=c[g>>2]|0;d=c[f>>2]|0}b=c[(c[e>>2]|0)+4>>2]|0;c[e>>2]=b}while((b|0)!=(d|0));if(d){b=d+8|0;if((c[b>>2]|0)!=0?(k=c[d+4>>2]|0,i=(c[d>>2]|0)+4|0,h=c[k>>2]|0,c[h+4>>2]=c[i>>2],c[c[i>>2]>>2]=h,c[b>>2]=0,(k|0)!=(d|0)):0){b=k;do{k=b;b=c[b+4>>2]|0;$5(k)}while((b|0)!=(d|0))}$5(d)}c[f>>2]=0}b=c[g>>2]|0;if(b)$5(b);c[g>>2]=0;b=c[l>>2]|0;d=b;if(b){e=c[m>>2]|0;if((e|0)!=(b|0))c[m>>2]=e+(~((e+-4-d|0)>>>2)<<2);$5(b)}o=0;Ja(451,a+8|0);a=o;o=0;if(a&1){i=zc()|0;break a}else return}while(0);j=59}while(0);if((j|0)==59){d=c[l>>2]|0;e=d;if(d){f=c[m>>2]|0;if((f|0)!=(d|0))c[m>>2]=f+(~((f+-4-e|0)>>>2)<<2);$5(d)}o=0;Ja(451,a+8|0);a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else i=b}o=0;a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else Kc(i|0)}function hq(a){a=a|0;var b=0;o=0;Ja(10,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function iq(a,b){a=a|0;b=+b;var d=0,e=0,f=0;g[a+40>>2]=b;d=c[a+32>>2]|0;if(b==0.0){c[a+48>>2]=(c[a+44>>2]|0)+d;return}e=~~(+(d>>>0)*b)>>>0;f=a+48|0;c[f>>2]=e;if(!(b>1.0))return;d=c[a+44>>2]|0;if(!d)return;c[f>>2]=~~(+(e>>>0)+ +(d>>>0)*+_(+(b+-1.0)))>>>0;return}function jq(b){b=b|0;return (a[b+36>>0]&-127)<<24>>24==1|0}function kq(b,c){b=b|0;c=c|0;return (a[b+36>>0]&c)<<24>>24==c<<24>>24|0}function lq(b){b=b|0;var d=0,e=0;e=b+36|0;d=a[e>>0]|0;if(!(d&1)){a[e>>0]=d|1;yq(c[(c[b+20>>2]|0)+8>>2]|0,b)}else{if(d<<24>>24<0){a[e>>0]=d&127;return}if(d&32){d=d&223;a[e>>0]=d}a[e>>0]=d|64}h[b+56>>3]=+Du();return}function mq(b,c){b=b|0;c=c|0;b=b+36|0;a[b>>0]=a[b>>0]|c;return}function nq(b){b=b|0;var c=0;b=b+36|0;c=a[b>>0]|0;if(!(c&1))return;a[b>>0]=c&31|32;return}function oq(b,e){b=b|0;e=+e;var f=0,i=0,j=0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0;q=b+36|0;i=a[q>>0]|0;if(i<<24>>24<0){b=0;return b|0}if(i&32){sE(b);g[b+80>>2]=1.0;a[q>>0]=0;j=b+100|0;i=c[j>>2]|0;if((i|0)!=0?(f=c[i>>2]|0,(f|0)!=(c[i+4>>2]|0)):0)do{r=c[f>>2]|0;tg[c[(c[r>>2]|0)+8>>2]&255](r,b,1);f=f+4|0}while((f|0)!=(c[(c[j>>2]|0)+4>>2]|0));tE(b);b=1;return b|0}if(i&2){f=b+64|0;l=+g[f>>2]+ +g[b+52>>2]*e;g[f>>2]=l;k=+g[b+40>>2];if(!(k!=0.0|!(l<=0.0)))g[f>>2]=l+ +((c[b+48>>2]|0)>>>0)}else{qq(b);k=+g[b+40>>2]}do if(k!=0.0){k=+g[b+52>>2];if(!(k>=0.0?+g[b+64>>2]>=+((c[b+48>>2]|0)>>>0):0)){if(!(k<=0.0)){j=18;break}if(!(+g[b+64>>2]<=0.0)){j=18;break}}a[q>>0]=(d[q>>0]|0)&253;if(k<0.0)k=0.0;else k=+((c[b+32>>2]|0)>>>0)}else j=18;while(0);if((j|0)==18){f=c[b+32>>2]|0;if(!f)k=0.0;else k=+j7(+g[b+64>>2],+(((c[b+44>>2]|0)+f|0)>>>0))}j=b+104|0;i=c[j>>2]|0;a:do if(i){m=b+64|0;n=b+108|0;f=c[n>>2]|0;if(!(+g[b+52>>2]>=0.0)){f=c[f>>2]|0;if((f|0)==(c[i+4>>2]|0))break;do{f=c[f+8>>2]|0;if(!(+g[m>>2]<=+(c[f+4>>2]|0)))break a;o=c[f>>2]|0;tg[c[(c[o>>2]|0)+8>>2]&255](o,b,2);o=c[n>>2]|0;f=c[c[o>>2]>>2]|0;c[o>>2]=f}while((f|0)!=(c[(c[j>>2]|0)+4>>2]|0))}else{f=c[f>>2]|0;if((f|0)==(i|0))break;do{f=c[f+8>>2]|0;if(!(+g[m>>2]>=+(c[f+4>>2]|0)))break a;o=c[f>>2]|0;tg[c[(c[o>>2]|0)+8>>2]&255](o,b,2);o=c[n>>2]|0;f=c[(c[o>>2]|0)+4>>2]|0;c[o>>2]=f}while((f|0)!=(c[j>>2]|0))}}while(0);m=c[b+32>>2]|0;k=(m|0)==0?1.0:k/+(m>>>0);m=b+44|0;if(!(c[m>>2]|0))k=k<0.0?0.0:k>1.0?1.0:k;f=a[q>>0]|0;do if(f&8){if(!(f&4)){e=+O(+(+g[b+52>>2]))*e;o=b+72|0;e=+g[o>>2]+e;g[o>>2]=e}else{e=+Du();e=(e-+h[(c[b+68>>2]|0)+56>>3])*+O(+(+g[b+52>>2]));g[b+72>>2]=e;f=(d[q>>0]|0)&251;a[q>>0]=f}l=+((c[b+76>>2]|0)>>>0);if(!(e<l)){i=b+68|0;j=c[i>>2]|0;g[j+80>>2]=1.0;g[b+80>>2]=0.0;a[q>>0]=f&245;o=j+36|0;a[o>>0]=(d[o>>0]|0)&239;if(!j)break;tE(j);c[i>>2]=0;break}l=(l-e)/l;e=1.0-l;if(!(f&16)){g[(c[b+68>>2]|0)+80>>2]=e;g[b+80>>2]=l;break}else{o=b+80|0;p=e*+g[o>>2];g[(c[b+68>>2]|0)+80>>2]=p;g[o>>2]=+g[o>>2]-p;break}}while(0);n=b+20|0;j=c[n>>2]|0;f=c[j+28>>2]|0;o=(c[j+32>>2]|0)-f>>2;l=+((c[j+24>>2]|0)>>>0);e=+((c[b+24>>2]|0)>>>0)/l;p=+((c[b+28>>2]|0)>>>0)/l;l=+((c[m>>2]|0)>>>0)/l;b:do if(o){j=b+84|0;m=b+80|0;i=0;while(1){s=c[f+(i<<2)>>2]|0;t=c[s+4>>2]|0;f=c[(c[j>>2]|0)+(i<<2)>>2]|0;u=Xp(s)|0;ss(u,k,e,p,l,c[f+8>>2]|0);sg[c[(c[t>>2]|0)+8>>2]&31](t,c[s+8>>2]|0,f,+g[m>>2]);i=i+1|0;if((i|0)==(o|0))break b;f=c[(c[n>>2]|0)+28>>2]|0}}while(0);if((a[q>>0]&34)==2){u=0;return u|0}sE(b);g[b+80>>2]=1.0;a[q>>0]=0;i=b+100|0;f=c[i>>2]|0;if((f|0)!=0?(r=c[f>>2]|0,(r|0)!=(c[f+4>>2]|0)):0){f=r;do{u=c[f>>2]|0;tg[c[(c[u>>2]|0)+8>>2]&255](u,b,1);f=f+4|0}while((f|0)!=(c[(c[i>>2]|0)+4>>2]|0))}tE(b);u=1;return u|0}function pq(b){b=b|0;var d=0,e=0,f=0;sE(b);g[b+80>>2]=1.0;a[b+36>>0]=0;f=b+100|0;e=c[f>>2]|0;if(!e){tE(b);return}d=c[e>>2]|0;if((d|0)==(c[e+4>>2]|0)){tE(b);return}do{e=c[d>>2]|0;tg[c[(c[e>>2]|0)+8>>2]&255](e,b,1);d=d+4|0}while((d|0)!=(c[(c[f>>2]|0)+4>>2]|0));tE(b);return}function qq(b){b=b|0;var d=0,e=0,f=0,i=0.0,j=0.0;sE(b);d=b+36|0;a[d>>0]=a[d>>0]|2;d=b+52|0;if(!(+g[d>>2]>=0.0)){j=+((c[b+48>>2]|0)>>>0);i=+Du();g[b+64>>2]=j+(i-+h[b+56>>3])*+g[d>>2];d=c[b+104>>2]|0;if(d)c[c[b+108>>2]>>2]=d}else{j=+Du();g[b+64>>2]=(j-+h[b+56>>3])*+g[d>>2];d=c[b+104>>2]|0;if(d)c[c[b+108>>2]>>2]=c[d+4>>2]}f=b+96|0;e=c[f>>2]|0;if(!e){tE(b);return}d=c[e>>2]|0;if((d|0)==(c[e+4>>2]|0)){tE(b);return}do{e=c[d>>2]|0;tg[c[(c[e>>2]|0)+8>>2]&255](e,b,0);d=d+4|0}while((d|0)!=(c[(c[f>>2]|0)+4>>2]|0));tE(b);return}function rq(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+16|0;m=q;p=Z5(120)|0;e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;o=0;fa(22,p|0,e|0,d|0,c[b+24>>2]|0,c[b+28>>2]|0);l=o;o=0;if(l&1){r=zc()|0;$5(p);Kc(r|0)}c[p+52>>2]=c[b+52>>2];f=+g[b+40>>2];g[p+40>>2]=f;e=c[p+32>>2]|0;if(!(f==0.0)){e=~~(f*+(e>>>0))>>>0;d=p+48|0;c[d>>2]=e;if(f>1.0?(h=c[p+44>>2]|0,(h|0)!=0):0)c[d>>2]=~~(+(e>>>0)+ +(h>>>0)*+_(+(f+-1.0)))>>>0}else c[p+48>>2]=(c[p+44>>2]|0)+e;c[p+80>>2]=c[b+80>>2];l=b+84|0;j=(c[b+88>>2]|0)-(c[l>>2]|0)>>2;k=p+84|0;c[m>>2]=0;e=p+88|0;d=c[e>>2]|0;h=c[k>>2]|0;b=d-h>>2;if(j>>>0<=b>>>0){if(j>>>0<b>>>0?(n=h+(j<<2)|0,(d|0)!=(n|0)):0)c[e>>2]=d+(~((d+-4-n|0)>>>2)<<2)}else tq(k,j-b|0,m);if(!j){i=q;return p|0}else d=0;while(1){e=c[(c[k>>2]|0)+(d<<2)>>2]|0;if(!e){e=Z5(12)|0;o=0;na(153,e|0,c[(c[l>>2]|0)+(d<<2)>>2]|0);n=o;o=0;if(n&1)break;c[(c[k>>2]|0)+(d<<2)>>2]=e}else Mq(e,c[(c[l>>2]|0)+(d<<2)>>2]|0)|0;d=d+1|0;if(d>>>0>=j>>>0){r=23;break}}if((r|0)==23){i=q;return p|0}r=zc()|0;$5(e);Kc(r|0);return 0}function sq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=a+4|0;d=c[a>>2]|0;e=d;h=((c[l>>2]|0)-e>>2)+1|0;if(h>>>0>1073741823){X5(a);e=c[a>>2]|0;d=e}k=a+8|0;g=d;f=(c[k>>2]|0)-g|0;if(f>>2>>>0<536870911){f=f>>1;f=f>>>0<h>>>0?h:f;h=(c[l>>2]|0)-g|0;g=h>>2;if(!f){j=0;i=0;f=h}else m=6}else{h=(c[l>>2]|0)-g|0;f=1073741823;g=h>>2;m=6}if((m|0)==6){j=f;i=Z5(f<<2)|0;f=h}c[i+(g<<2)>>2]=c[b>>2];K9(i|0,d|0,f|0)|0;c[a>>2]=i;c[l>>2]=i+(g+1<<2);c[k>>2]=i+(j<<2);if(!e)return;$5(e);return}function tq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+8|0;g=c[k>>2]|0;l=a+4|0;e=c[l>>2]|0;f=e;if(g-f>>2>>>0>=b>>>0){do{c[e>>2]=c[d>>2];e=(c[l>>2]|0)+4|0;c[l>>2]=e;b=b+-1|0}while((b|0)!=0);return}e=c[a>>2]|0;h=(f-e>>2)+b|0;if(h>>>0>1073741823){X5(a);g=c[k>>2]|0;e=c[a>>2]|0}f=g-e|0;if(f>>2>>>0<536870911){f=f>>1;f=f>>>0<h>>>0?h:f;e=(c[l>>2]|0)-e>>2;if(!f){g=0;i=0;h=e}else j=9}else{f=1073741823;e=(c[l>>2]|0)-e>>2;j=9}if((j|0)==9){g=f;i=Z5(f<<2)|0;h=e}e=i+(h<<2)|0;g=i+(g<<2)|0;f=e;do{c[f>>2]=c[d>>2];f=e+4|0;e=f;b=b+-1|0}while((b|0)!=0);b=c[a>>2]|0;j=(c[l>>2]|0)-b|0;d=i+(h-(j>>2)<<2)|0;K9(d|0,b|0,j|0)|0;c[a>>2]=d;c[l>>2]=e;c[k>>2]=g;if(!b)return;$5(b);return}function uq(a){a=a|0;var b=0;c[a>>2]=3;b=a+4|0;c[b>>2]=b;c[a+8>>2]=b;c[a+12>>2]=0;return}function vq(a){a=a|0;var b=0,d=0,e=0,f=0;d=a+4|0;b=a+12|0;if(!(c[b>>2]|0))return;a=c[a+8>>2]|0;e=(c[d>>2]|0)+4|0;f=c[a>>2]|0;c[f+4>>2]=c[e>>2];c[c[e>>2]>>2]=f;c[b>>2]=0;if((a|0)==(d|0))return;do{f=a;a=c[a+4>>2]|0;$5(f)}while((a|0)!=(d|0));return}function wq(a){a=a|0;c[a>>2]=1;return}function xq(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;f=a+4|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(f|0))do{d=c[b+8>>2]|0;if(d)tE(d);b=c[b+4>>2]|0}while((b|0)!=(f|0));d=a+12|0;if(!(c[d>>2]|0)){c[a>>2]=3;return}b=c[e>>2]|0;e=(c[f>>2]|0)+4|0;g=c[b>>2]|0;c[g+4>>2]=c[e>>2];c[c[e>>2]>>2]=g;c[d>>2]=0;if((b|0)==(f|0)){c[a>>2]=3;return}do{g=b;b=c[b+4>>2]|0;$5(g)}while((b|0)!=(f|0));c[a>>2]=3;return}function yq(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+4|0;e=a+12|0;if(!(c[e>>2]|0))c[a>>2]=0;sE(b);a=Z5(12)|0;c[a+8>>2]=b;c[a+4>>2]=d;b=c[d>>2]|0;c[a>>2]=b;c[b+4>>2]=a;c[d>>2]=a;c[e>>2]=(c[e>>2]|0)+1;return}function zq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;g=a+4|0;d=c[a+8>>2]|0;a:do if((d|0)!=(g|0)){e=d;f=d;while(1){d=f+4|0;if((c[f+8>>2]|0)==(b|0))break;e=c[d>>2]|0;f=e;if((f|0)==(g|0)){h=7;break a}}g=c[e>>2]|0;c[g+4>>2]=c[d>>2];c[c[d>>2]>>2]=g;d=a+12|0;c[d>>2]=(c[d>>2]|0)+-1;$5(e);if(b)tE(b)}else h=7;while(0);if((h|0)==7)d=a+12|0;if(c[d>>2]|0)return;c[a>>2]=1;return}function Aq(a,b){a=a|0;b=+b;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;if(c[a>>2]|0)return;YG();i=a+4|0;e=c[a+8>>2]|0;if((e|0)==(i|0))d=a+12|0;else{d=a+12|0;g=e;h=e;while(1){f=c[h+8>>2]|0;sE(f);do if(!(kq(f,64)|0))if(oq(f,b)|0){tE(f);h=h+4|0;e=c[h>>2]|0;j=c[g>>2]|0;c[j+4>>2]=e;c[c[h>>2]>>2]=j;c[d>>2]=(c[d>>2]|0)+-1;$5(g);break}else{e=c[h+4>>2]|0;break}else{pq(f);mq(f,1);j=Z5(12)|0;c[j+8>>2]=f;c[j+4>>2]=i;e=c[i>>2]|0;c[j>>2]=e;c[e+4>>2]=j;c[i>>2]=j;j=h+4|0;e=c[j>>2]|0;h=c[g>>2]|0;c[h+4>>2]=e;c[c[j>>2]>>2]=h;$5(g)}while(0);tE(f);h=e;if((h|0)==(i|0))break;else g=e}}ZG();if(c[d>>2]|0)return;c[a>>2]=1;return}function Bq(a){a=a|0;c[a>>2]=7664;c[a+4>>2]=0;c[a+8>>2]=0;return}function Cq(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;c[a>>2]=7664;h=a+8|0;a=c[h>>2]|0;if(!a)return;b=c[a>>2]|0;if((b|0)!=(c[a+4>>2]|0)){while(1){a=c[b>>2]|0;bq(c[a>>2]|0,a);if(a){o=0;Ja(456,a|0);f=o;o=0;if(f&1){g=15;break}$5(a)}e=b+4|0;a=c[h>>2]|0;d=a+4|0;if((e|0)==(c[d>>2]|0)){f=b;break}else b=e}if((g|0)==15){h=zc()|0;$5(a);Kc(h|0)}b=c[a>>2]|0;if((e|0)!=(b|0))c[d>>2]=f+(0-((f-b|0)>>>2)<<2)}d=b;if(b){e=a+4|0;f=c[e>>2]|0;if((f|0)!=(b|0))c[e>>2]=f+(~((f+-4-d|0)>>>2)<<2);$5(b)}$5(a);c[h>>2]=0;return}function Dq(a){a=a|0;var b=0;o=0;Ja(12,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function Eq(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;h=Z5(48)|0;o=0;Sa(1,h|0,b|0,a|0,c|0,d|0,e|0,f|0,g|0);g=o;o=0;if(g&1){g=zc()|0;$5(h);Kc(g|0)}else return h|0;return 0}function Fq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0;k=dg[c[c[a>>2]>>2]&127](a,d)|0;i=k<<1;i=_5(i>>>0>1073741823?-1:i<<2)|0;j=k<<2;K9(i|0,e|0,j|0)|0;K9(i+(k<<2)|0,f|0,j|0)|0;f=_5(8)|0;c[f>>2]=0;c[f+4>>2]=h;e=Z5(48)|0;o=0;Sa(1,e|0,b|0,a|0,d|0,2,f|0,i|0,g|0);g=o;o=0;if(g&1){k=zc()|0;$5(e);Kc(k|0)}else{a6(i);a6(f);return e|0}return 0}function Gq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=a+8|0;a=c[e>>2]|0;if(!a){f=0;return f|0}d=c[a>>2]|0;if(!b){f=c[c[d>>2]>>2]|0;return f|0}if((d|0)==(c[a+4>>2]|0)){f=0;return f|0}while(1){a=c[d>>2]|0;d=d+4|0;if(!(D9((c[a>>2]|0)+12|0,b)|0))break;if((d|0)==(c[(c[e>>2]|0)+4>>2]|0)){a=0;f=8;break}}if((f|0)==8)return a|0;f=c[a>>2]|0;return f|0}function Hq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;i=i+16|0;f=g;c[f>>2]=b;a=a+8|0;d=c[a>>2]|0;if(!d){d=Z5(12)|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[a>>2]=d}e=d+4|0;a=c[e>>2]|0;if((a|0)==(c[d+8>>2]|0)){dq(d,f);i=g;return}else{c[a>>2]=b;c[e>>2]=(c[e>>2]|0)+4;i=g;return}}function Iq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=a+8|0;a=c[h>>2]|0;if(!a)return;e=c[a>>2]|0;if((e|0)==(c[a+4>>2]|0))return;while(1){f=c[e>>2]|0;g=Hz(d,c[f>>2]|0)|0;if(!g){g=cq(c[f>>2]|0,f,b)|0;Iz(d,c[f>>2]|0,g)}else{a=Z5(20)|0;o=0;yb(60,a|0,f|0,g|0,b|0);f=o;o=0;if(f&1){e=6;break}aq(g,a)}e=e+4|0;if((e|0)==(c[(c[h>>2]|0)+4>>2]|0)){e=9;break}}if((e|0)==6){b=zc()|0;$5(a);Kc(b|0)}else if((e|0)==9)return}function Jq(a,b){a=a|0;b=b|0;c[a>>2]=b;c[a+4>>2]=b<<2;c[a+8>>2]=_5(b>>>0>1073741823?-1:b<<2)|0;return}function Kq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=c[b>>2]|0;e=_5(f>>>0>1073741823?-1:f<<2)|0;c[a+8>>2]=e;d=c[b+4>>2]|0;c[a+4>>2]=d;c[a>>2]=f;K9(e|0,c[b+8>>2]|0,d|0)|0;return}function Lq(a){a=a|0;var b=0;a=a+8|0;b=c[a>>2]|0;if(b)a6(b);c[a>>2]=0;return}function Mq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;if((a|0)==(b|0))return a|0;h=a+8|0;e=c[h>>2]|0;do if(!e){d=c[b+4>>2]|0;c[a+4>>2]=d;c[a>>2]=c[b>>2];e=b;i=7}else{g=a+4|0;d=c[g>>2]|0;f=c[b+4>>2]|0;if((d|0)==(f|0)){if((c[a>>2]|0)==(c[b>>2]|0))break}else d=f;c[g>>2]=d;c[a>>2]=c[b>>2];a6(e);d=c[g>>2]|0;e=b;i=7}while(0);if((i|0)==7){e=c[e>>2]|0;e=_5(e>>>0>1073741823?-1:e<<2)|0;c[h>>2]=e}K9(e|0,c[b+8>>2]|0,d|0)|0;return a|0}function Nq(a,b){a=a|0;b=b|0;return +(+g[(c[a+8>>2]|0)+(b<<2)>>2])}function Oq(a,b,d){a=a|0;b=b|0;d=+d;g[(c[a+8>>2]|0)+(b<<2)>>2]=d;return}function Pq(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;K9((c[a+8>>2]|0)+(b<<2)|0,d|0,e<<2|0)|0;return}function Qq(a){a=a|0;QH(a);g[a+12>>2]=0.0;return}function Rq(a,b,d){a=a|0;b=b|0;d=+d;QH(a);c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];g[a+12>>2]=d;return}function Sq(a,b,d){a=a|0;b=b|0;d=+d;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];g[a+12>>2]=d;return}function Tq(a,b){a=a|0;b=b|0;QH(a);c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function Uq(a,b){a=a|0;b=b|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function Vq(a){a=a|0;WH(a);return}function Wq(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+g[b>>2]-+g[a>>2];d=+g[b+4>>2]-+g[a+4>>2];c=+g[b+8>>2]-+g[a+8>>2];c=+P(+(e*e+d*d+c*c));return c<=+g[a+12>>2]+ +g[b+12>>2]|0}function Xq(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;d=+WC(ru(b)|0,a);e=+O(+d);c=a+12|0;if(!((!(e<=+g[c>>2])?(d>0.0?1.0:-1.0):0.0)!=-1.0)){a=0;return a|0}e=+WC(su(b)|0,a);d=+O(+e);if(!((!(d<=+g[c>>2])?(e>0.0?1.0:-1.0):0.0)!=-1.0)){a=0;return a|0}e=+WC(tu(b)|0,a);d=+O(+e);if(!((!(d<=+g[c>>2])?(e>0.0?1.0:-1.0):0.0)!=-1.0)){a=0;return a|0}e=+WC(uu(b)|0,a);d=+O(+e);if(!((!(d<=+g[c>>2])?(e>0.0?1.0:-1.0):0.0)!=-1.0)){a=0;return a|0}e=+WC(vu(b)|0,a);d=+O(+e);if(!((!(d<=+g[c>>2])?(e>0.0?1.0:-1.0):0.0)!=-1.0)){a=0;return a|0}e=+WC(wu(b)|0,a);d=+O(+e);a=(!(d<=+g[c>>2])?(e>0.0?1.0:-1.0):0.0)!=-1.0;return a|0}function Yq(a){a=a|0;return +g[a+12>>2]==0.0|0}function Zq(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0;d=b+12|0;e=+g[d>>2];if(e==0.0)return;n=+g[b>>2];o=+g[a>>2]-n;p=a+4|0;q=+g[b+4>>2];f=+g[p>>2]-q;h=a+8|0;i=+g[b+8>>2];j=+g[h>>2]-i;k=+P(+(o*o+f*f+j*j));l=a+12|0;m=+g[l>>2];if(k<=e-m){c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[l>>2]=c[d>>2];return}if(k<=m-e)return;r=1.0/k;m=(k+(e+m))*.5;k=m-e;g[a>>2]=n+k*(o*r);g[p>>2]=q+k*(f*r);g[h>>2]=i+k*(j*r);g[l>>2]=m;return}function _q(a,b){a=a|0;b=b|0;var c=0;c=b+12|0;g[a>>2]=(+g[b>>2]+ +g[c>>2])*.5;g[a+4>>2]=(+g[b+4>>2]+ +g[b+16>>2])*.5;g[a+8>>2]=(+g[b+8>>2]+ +g[b+20>>2])*.5;g[a+12>>2]=+fI(a,c);return}function $q(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,l=0.0,m=0.0,n=0.0;h=i;i=i+32|0;j=h+12|0;f=h+8|0;d=h+4|0;e=h;px(b,a,a);QH(j);o=0;pb(33,b|0,j|0,0,0)|0;b=o;o=0;if(!(b&1)){b=a+12|0;l=+g[b>>2];n=l*+g[j>>2];g[f>>2]=n;m=l*+g[j+4>>2];g[d>>2]=m;d=c[(n<m?d:f)>>2]|0;c[f>>2]=d;l=l*+g[j+8>>2];g[e>>2]=l;c[b>>2]=c[((c[k>>2]=d,+g[k>>2])<l?e:f)>>2];WH(j);i=h;return}b=zc()|0;o=0;Ja(412,j|0);j=o;o=0;if(j&1){j=zc(0)|0;Di(j)}else Kc(b|0)}function ar(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c[a>>2]=7692;o=0;Ja(457,a|0);h=o;o=0;a:do if(!(h&1)){d=c[1925]|0;g=c[1926]|0;b:do if((d|0)==(g|0)){b=d;i=5}else{h=d;do{if((c[h>>2]|0)==(a|0)){b=h;i=5;break b}h=h+4|0}while((h|0)!=(g|0))}while(0);if(((i|0)==5?(b|0)!=(g|0):0)?(f=d+((b-d>>2)+1<<2)|0,e=g-f|0,L9(b|0,f|0,e|0)|0,e=b+(e>>2<<2)|0,f=c[1926]|0,(f|0)!=(e|0)):0)c[1926]=f+(~((f+-4-e|0)>>>2)<<2);d=a+36|0;f=c[d>>2]|0;if(f){g=f+-4|0;b=c[g>>2]|0;c:do if(b){b=f+(b*20|0)|0;while(1){b=b+-20|0;o=0;Ja(451,b|0);i=o;o=0;if(i&1)break;if((b|0)==(f|0))break c}d=zc()|0;e=D;d:do if((f|0)!=(b|0)){while(1){b=b+-20|0;o=0;Ja(451,b|0);i=o;o=0;if(i&1)break;if((b|0)==(f|0))break d}j=zc(0)|0;Di(j)}while(0);a6(g);b=d;i=29;break a}while(0);a6(g)}c[d>>2]=0;b=a+40|0;d=c[b>>2]|0;if(d){o=0;Ja(c[(c[d>>2]|0)+4>>2]|0,d|0);j=o;o=0;if(j&1){i=8;break}c[b>>2]=0}b=c[a+44>>2]|0;d=b;if(b){e=a+48|0;f=c[e>>2]|0;if((f|0)!=(b|0))c[e>>2]=f+(~((f+-4-d|0)>>>2)<<2);$5(b)}o=0;Ja(451,a+20|0);j=o;o=0;if(j&1){k=zc()|0;i=36;break}o=0;Ja(451,a+8|0);l=o;o=0;if(l&1){l=zc()|0;i=37;break}else return}else i=8;while(0);if((i|0)==8){b=zc()|0;i=29}if((i|0)==29){d=c[a+44>>2]|0;e=d;if(d){f=a+48|0;g=c[f>>2]|0;if((g|0)!=(d|0))c[f>>2]=g+(~((g+-4-e|0)>>>2)<<2);$5(d)}o=0;Ja(451,a+20|0);j=o;o=0;if(!(j&1)){k=b;i=36}}if((i|0)==36?(o=0,Ja(451,a+8|0),a=o,o=0,!(a&1)):0){l=k;i=37}if((i|0)==37?(o=0,a=o,o=0,!(a&1)):0)Kc(l|0);a=zc(0)|0;Di(a)}function br(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;l=a+48|0;d=c[l>>2]|0;i=a+44|0;a=c[i>>2]|0;j=d-a>>2;do if(j){h=0;a:while(1){g=c[a+(h<<2)>>2]|0;if(g){a=g+16|0;d=c[a>>2]|0;if(d){e=g+20|0;while(1){f=c[e>>2]|0;if((f|0)==(d|0))break;f=f+-64|0;c[e>>2]=f;o=0;Ja(440,f|0);f=o;o=0;if(f&1){a=7;break a}}$5(c[a>>2]|0)}a=g+4|0;d=c[a>>2]|0;if(d){e=g+8|0;while(1){f=c[e>>2]|0;if((f|0)==(d|0))break;f=f+-12|0;c[e>>2]=f;o=0;Ja(451,f|0);f=o;o=0;if(f&1){a=13;break a}}$5(c[a>>2]|0)}$5(g);a=c[i>>2]|0}c[a+(h<<2)>>2]=0;h=h+1|0;a=c[i>>2]|0;if(h>>>0>=j>>>0){b=a;a=17;break}}if((a|0)==7){j=zc()|0;Lc(j|0)}else if((a|0)==13){j=zc()|0;Lc(j|0)}else if((a|0)==17){k=c[l>>2]|0;break}}else{b=a;k=d}while(0);if((k|0)==(b|0))return;c[l>>2]=k+(~((k+-4-b|0)>>>2)<<2);return}function cr(a){a=a|0;var b=0;o=0;Ja(14,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function dr(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;I=i;i=i+192|0;F=I+152|0;E=I+144|0;D=I+136|0;y=I+128|0;x=I+120|0;w=I+112|0;v=I+104|0;u=I+80|0;t=I+72|0;p=I+64|0;n=I+56|0;m=I+48|0;l=I+40|0;s=I+32|0;r=I+24|0;q=I+16|0;k=I+8|0;j=I;h=I+174|0;z=I+172|0;H=I+168|0;C=I+156|0;e=c[1925]|0;g=(c[1926]|0)-e>>2;a:do if(g){e=c[e>>2]|0;if(D9(e+8|0,b)|0){f=1;while(1){if(f>>>0>=g>>>0)break a;e=c[(c[1925]|0)+(f<<2)>>2]|0;if(!(D9(e+8|0,b)|0))break;else f=f+1|0}}sE(e);H=e;i=I;return H|0}while(0);B=ut(b,1)|0;if(!B){c[j>>2]=57033;Uv(2,63728,j);c[k>>2]=b;Uv(2,52428,k);Uv(2,63797,q);Jb(63799,37281,178,57033)}if((qg[c[(c[B>>2]|0)+24>>2]&63](B,h,1,9)|0)!=9){q=c[B>>2]|0;q=q+4|0;q=c[q>>2]|0;Kf[q&1023](B);c[r>>2]=57033;Uv(2,63728,r);c[s>>2]=b;Uv(2,37315,s);Uv(2,63797,l);Jb(63799,37281,187,57033)}if(u8(h,37305,9)|0){q=c[B>>2]|0;q=q+4|0;q=c[q>>2]|0;Kf[q&1023](B);c[r>>2]=57033;Uv(2,63728,r);c[s>>2]=b;Uv(2,37315,s);Uv(2,63797,l);Jb(63799,37281,187,57033)}if((qg[c[(c[B>>2]|0)+24>>2]&63](B,z,1,2)|0)!=2){Kf[c[(c[B>>2]|0)+4>>2]&1023](B);c[m>>2]=57033;Uv(2,63728,m);c[n>>2]=b;Uv(2,37351,n);Uv(2,63797,p);Jb(63799,37281,196,57033)}e=z+1|0;if(!((a[z>>0]|0)==1&(a[e>>0]|0)==2)){Kf[c[(c[B>>2]|0)+4>>2]&1023](B);c[t>>2]=57033;Uv(2,63728,t);t=d[e>>0]|0;c[u>>2]=d[z>>0];c[u+4>>2]=t;c[u+8>>2]=b;c[u+12>>2]=1;c[u+16>>2]=2;Uv(2,37395,u);Uv(2,63797,v);Jb(63799,37281,202,57033)}if((qg[c[(c[B>>2]|0)+24>>2]&63](B,H,4,1)|0)!=1){Kf[c[(c[B>>2]|0)+4>>2]&1023](B);c[w>>2]=57033;Uv(2,63728,w);c[x>>2]=b;Uv(2,37457,x);Uv(2,63797,y);Jb(63799,37281,211,57033)}e=c[H>>2]|0;h=e*20|0;h=_5(e>>>0>214748364|h>>>0>4294967291?-1:h+4|0)|0;c[h>>2]=e;h=h+4|0;g=(e|0)==0;b:do if(!g){e=h+(e*20|0)|0;f=h;do{c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;f=f+20|0}while((f|0)!=(e|0));if(!g){e=0;while(1){Gr(C,B);o=0;f=cb(58,h+(e*20|0)|0,C|0)|0;z=o;o=0;if(z&1){f=30;break}z=a[f>>0]|0;if(!(((z&1)==0?(z&255)>>>1:c[f+4>>2]|0)|0)){f=28;break}o=0;f=pb(c[(c[B>>2]|0)+24>>2]|0,B|0,h+(e*20|0)+12|0,4,1)|0;z=o;o=0;if(z&1){f=30;break}if((f|0)!=1){f=27;break}o=0;f=pb(c[(c[B>>2]|0)+24>>2]|0,B|0,h+(e*20|0)+16|0,4,1)|0;z=o;o=0;if(z&1){f=30;break}i9(C);if((f|0)!=1){f=29;break}e=e+1|0;if(e>>>0>=(c[H>>2]|0)>>>0)break b}if((f|0)==27){i9(C);C=e;A=c[B>>2]|0;A=A+4|0;A=c[A>>2]|0;Kf[A&1023](B);c[D>>2]=57033;Uv(2,63728,D);c[E>>2]=C;D=E+4|0;c[D>>2]=b;Uv(2,37499,E);Uv(2,63797,F);Jb(63799,37281,224,57033)}else if((f|0)==28){i9(C);C=e;A=c[B>>2]|0;A=A+4|0;A=c[A>>2]|0;Kf[A&1023](B);c[D>>2]=57033;Uv(2,63728,D);c[E>>2]=C;D=E+4|0;c[D>>2]=b;Uv(2,37499,E);Uv(2,63797,F);Jb(63799,37281,224,57033)}else if((f|0)==29){C=c[B>>2]|0;C=C+4|0;C=c[C>>2]|0;Kf[C&1023](B);c[D>>2]=57033;Uv(2,63728,D);c[E>>2]=e;D=E+4|0;c[D>>2]=b;Uv(2,37499,E);Uv(2,63797,F);Jb(63799,37281,224,57033)}else if((f|0)==30){e=zc()|0;o=0;Ja(451,C|0);F=o;o=0;if(F&1){F=zc(0)|0;Di(F)}else{I=e;Kc(I|0)}}}}while(0);g=Z5(60)|0;o=0;Ja(454,g|0);F=o;o=0;do if(!(F&1)){c[g>>2]=7692;F=F8(b)|0;o=0;sb(127,g+8|0,b|0,F|0);b=o;o=0;if(b&1){e=zc()|0;o=0;I=o;o=0;if(!(I&1)){G=e;break}I=zc(0)|0;Di(I)}else{e=g+20|0;f=e+40|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(f|0));c[g+32>>2]=c[H>>2];c[g+36>>2]=h;c[g+40>>2]=B;H=g;i=I;return H|0}}else G=zc()|0;while(0);$5(g);I=G;Kc(I|0);return 0}function er(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;f=h;g=b+20|0;d=a[g>>0]|0;if(!(d&1))d=(d&255)>>>1;else d=c[b+24>>2]|0;if(d){i=h;return g|0}d=b+8|0;e=B9(d,46,-1)|0;if((e|0)<=2){i=h;return g|0}h9(f,d,0,e,d);o=0;cb(58,g|0,f|0)|0;e=o;o=0;if(e&1){d=zc()|0;o=0;Ja(451,f|0);e=o;o=0;if(e&1){e=zc(0)|0;Di(e)}else Kc(d|0)}i9(f);o9(g,37545)|0;if(!(a[g>>0]&1))d=g+1|0;else d=c[b+28>>2]|0;if(tt(d)|0){i=h;return g|0}if(!(a[g>>0]&1)){a[g+1>>0]=0;a[g>>0]=0;i=h;return g|0}else{a[c[b+28>>2]>>0]=0;c[b+24>>2]=0;i=h;return g|0}return 0}function fr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+80|0;o=t+72|0;n=t+64|0;k=t+56|0;r=t+48|0;q=t+32|0;l=t+24|0;s=t+16|0;p=t+8|0;m=t;f=b+32|0;a:do if(c[f>>2]|0){h=b+36|0;g=0;while(1){if(!(D9((c[h>>2]|0)+(g*20|0)|0,d)|0))break;g=g+1|0;if(g>>>0>=(c[f>>2]|0)>>>0)break a}f=c[h>>2]|0;h=f+(g*20|0)|0;if(h){j=f+(g*20|0)+12|0;if((c[j>>2]|0)!=(e|0)){c[l>>2]=37555;Uv(1,63728,l);f=b+8|0;if(!(a[f>>0]&1))f=f+1|0;else f=c[b+16>>2]|0;b=c[j>>2]|0;c[q>>2]=d;c[q+4>>2]=f;c[q+8>>2]=b;c[q+12>>2]=e;Uv(1,37603,q);Uv(1,63797,r);d=0;i=t;return d|0}r=c[b+40>>2]|0;if(If[c[(c[r>>2]|0)+48>>2]&127](r,c[f+(g*20|0)+16>>2]|0,0)|0){d=h;i=t;return d|0}c[k>>2]=37555;Uv(2,63728,k);f=b+8|0;if(!(a[f>>0]&1)){r=f+1|0;c[n>>2]=d;t=n+4|0;c[t>>2]=r;Uv(2,37662,n);Uv(2,63797,o);Jb(63799,37281,326,37555)}else{r=c[b+16>>2]|0;c[n>>2]=d;t=n+4|0;c[t>>2]=r;Uv(2,37662,n);Uv(2,63797,o);Jb(63799,37281,326,37555)}}}while(0);c[m>>2]=37555;Uv(2,63728,m);f=b+8|0;if(!(a[f>>0]&1)){b=f+1|0;c[p>>2]=d;d=p+4|0;c[d>>2]=b;Uv(2,37562,p);Uv(2,63797,s);Jb(63799,37281,312,37555)}else{b=c[b+16>>2]|0;c[p>>2]=d;d=p+4|0;c[d>>2]=b;Uv(2,37562,p);Uv(2,63797,s);Jb(63799,37281,312,37555)}return 0}function gr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+32|0;m=k+16|0;l=k+8|0;h=k;e=c[b+32>>2]|0;if(!e){m=0;i=k;return m|0}g=c[b+36>>2]|0;f=0;while(1){if((c[g+(f*20|0)+12>>2]|0)==(d|0))break;f=f+1|0;if(f>>>0>=e>>>0){e=0;j=13;break}}if((j|0)==13){i=k;return e|0}e=g+(f*20|0)|0;j=c[b+40>>2]|0;if(If[c[(c[j>>2]|0)+48>>2]&127](j,c[g+(f*20|0)+16>>2]|0,0)|0){m=e;i=k;return m|0}c[h>>2]=37708;Uv(2,63728,h);if(!(a[e>>0]&1))f=e+1|0;else f=c[g+(f*20|0)+8>>2]|0;e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;c[l>>2]=f;c[l+4>>2]=e;Uv(2,37662,l);Uv(2,63797,m);Jb(63799,37281,346,37708);return 0}function hr(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;H=i;i=i+192|0;K=H+160|0;J=H+152|0;I=H+144|0;G=H+136|0;F=H+128|0;B=H+120|0;E=H+112|0;D=H+104|0;v=H+96|0;A=H+88|0;z=H+80|0;u=H+72|0;q=H+64|0;p=H+56|0;n=H+48|0;h=H+40|0;l=H+32|0;k=H+24|0;j=H+16|0;f=H+8|0;e=H;r=H+188|0;L=H+176|0;y=H+172|0;w=H+168|0;x=H+164|0;br(b);if(!d){if(!(gr(b,1)|0)){c[k>>2]=37724;Uv(2,63728,k);Uv(2,37781,l);Uv(2,63797,h);Jb(63799,37281,394,37724)}}else if(!(fr(b,d,1)|0)){c[e>>2]=37724;Uv(2,63728,e);c[f>>2]=d;Uv(2,37734,f);Uv(2,63797,j);Jb(63799,37281,385,37724)}C=b+40|0;j=c[C>>2]|0;j=rf[c[(c[j>>2]|0)+44>>2]&255](j)|0;a:do if((j|0)!=0?(m=c[b+32>>2]|0,(m|0)!=0):0){k=c[b+36>>2]|0;d=0;while(1){if((c[k+(d*20|0)+16>>2]|0)==(j|0)){f=k+(d*20|0)|0;e=a[f>>0]|0;h=(e&1)==0;if(h)e=(e&255)>>>1;else e=c[k+(d*20|0)+4>>2]|0;if(e)break}d=d+1|0;if(d>>>0>=m>>>0){d=0;break a}}if(h){d=f+1|0;break}else{d=c[k+(d*20|0)+8>>2]|0;break}}else d=0;while(0);l=yF(d)|0;m=c[C>>2]|0;if((qg[c[(c[m>>2]|0)+24>>2]&63](m,r,4,1)|0)!=1){c[n>>2]=37724;Uv(2,63728,n);Uv(2,37849,p);Uv(2,63797,q);Jb(63799,37281,405,37724)}if(c[r>>2]|0){e=0;do{d=ir(b,l,0)|0;if(d){BF(l,d);tE(d+152|0)}e=e+1|0}while(e>>>0<(c[r>>2]|0)>>>0)}Gr(L,c[C>>2]|0);r=a[L>>0]|0;d=(r&1)==0;if((d?(r&255)>>>1:c[L+4>>2]|0)>>>0>1?(s=d?L+1|0:c[L+8>>2]|0,(a[s>>0]|0)==35):0){o=0;d=pb(34,l|0,s+1|0,1,1)|0;s=o;o=0;if((!(s&1)?(o=0,t=qa(150,d|0)|0,s=o,o=0,!(s&1)):0)?(o=0,na(154,l|0,t|0),t=o,o=0,!(t&1)):0)k=32;else k=30}else k=32;b:do if((k|0)==32){d=c[C>>2]|0;o=0;d=pb(c[(c[d>>2]|0)+24>>2]|0,d|0,y|0,4,1)|0;t=o;o=0;if(!(t&1)){if((d|0)!=1){o=0;c[u>>2]=37724;sb(128,2,63728,u|0);K=o;o=0;if(K&1){k=30;break}d=b+8|0;if(!(a[d>>0]&1))d=d+1|0;else d=c[b+16>>2]|0;o=0;c[z>>2]=d;sb(128,2,37896,z|0);b=o;o=0;if(b&1){k=30;break}o=0;sb(128,2,63797,A|0);b=o;o=0;if(b&1){k=30;break}o=0;yb(61,63799,37281,437,37724);o=0;k=30;break}d=c[C>>2]|0;o=0;d=pb(c[(c[d>>2]|0)+24>>2]|0,d|0,x|0,4,1)|0;A=o;o=0;if(!(A&1)){if((d|0)!=1){o=0;c[v>>2]=37724;sb(128,2,63728,v|0);K=o;o=0;if(K&1){k=30;break}d=b+8|0;if(!(a[d>>0]&1))d=d+1|0;else d=c[b+16>>2]|0;o=0;c[D>>2]=d;sb(128,2,37970,D|0);b=o;o=0;if(b&1){k=30;break}o=0;sb(128,2,63797,E|0);b=o;o=0;if(b&1){k=30;break}o=0;yb(61,63799,37281,443,37724);o=0;k=30;break}d=c[C>>2]|0;o=0;d=pb(c[(c[d>>2]|0)+24>>2]|0,d|0,w|0,4,1)|0;E=o;o=0;if(!(E&1)){if((d|0)!=1){o=0;c[B>>2]=37724;sb(128,2,63728,B|0);K=o;o=0;if(K&1){k=30;break}d=b+8|0;if(!(a[d>>0]&1))d=d+1|0;else d=c[b+16>>2]|0;o=0;c[F>>2]=d;sb(128,2,38046,F|0);b=o;o=0;if(b&1){k=30;break}o=0;sb(128,2,63797,G|0);b=o;o=0;if(b&1){k=30;break}o=0;yb(61,63799,37281,449,37724);o=0;k=30;break}o=0;za(2,l|0,+(+g[y>>2]),+(+g[x>>2]),+(+g[w>>2]));G=o;o=0;if(!(G&1)){h=b+32|0;d=c[h>>2]|0;c:do if(d){j=b+36|0;e=0;while(1){f=c[j>>2]|0;if((c[f+(e*20|0)+12>>2]|0)==3){d=c[C>>2]|0;o=0;d=Ha(c[(c[d>>2]|0)+48>>2]|0,d|0,c[f+(e*20|0)+16>>2]|0,0)|0;G=o;o=0;if(G&1){k=29;break}if(!d)break;o=0;na(155,b|0,l|0);G=o;o=0;if(G&1){k=29;break}d=c[h>>2]|0}e=e+1|0;if(e>>>0>=d>>>0)break c}if((k|0)==29){d=zc()|0;break b}o=0;c[I>>2]=37724;sb(128,2,63728,I|0);I=o;o=0;if(I&1){k=30;break b}d=f+(e*20|0)|0;if(!(a[d>>0]&1))e=d+1|0;else e=c[f+(e*20|0)+8>>2]|0;d=b+8|0;if(!(a[d>>0]&1))d=d+1|0;else d=c[b+16>>2]|0;o=0;c[J>>2]=e;c[J+4>>2]=d;sb(128,2,37662,J|0);b=o;o=0;if(b&1){k=30;break b}o=0;sb(128,2,63797,K|0);b=o;o=0;if(b&1){k=30;break b}o=0;yb(61,63799,37281,466,37724);o=0;k=30;break b}while(0);o=0;sb(129,b|0,l|0,0);b=o;o=0;if(!(b&1)){i9(L);i=H;return l|0}else k=30}else k=30}else k=30}else k=30}else k=30}while(0);if((k|0)==30)d=zc()|0;o=0;Ja(451,L|0);L=o;o=0;if(L&1){L=zc(0)|0;Di(L)}else Kc(d|0);return 0}function ir(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;M=i;i=i+208|0;C=M+64|0;B=M+56|0;A=M+48|0;z=M+40|0;E=M+32|0;D=M+24|0;t=M+16|0;s=M+8|0;r=M;x=M+136|0;u=M+120|0;n=M+108|0;q=M+104|0;v=M+88|0;y=M+72|0;L=M+68|0;K=b+40|0;k=c[K>>2]|0;k=rf[c[(c[k>>2]|0)+44>>2]&255](k)|0;a:do if((k|0)!=0?(l=c[b+32>>2]|0,(l|0)!=0):0){m=c[b+36>>2]|0;f=0;while(1){if((c[m+(f*20|0)+16>>2]|0)==(k|0)){h=m+(f*20|0)|0;g=a[h>>0]|0;j=(g&1)==0;if(j)g=(g&255)>>>1;else g=c[m+(f*20|0)+4>>2]|0;if(g)break}f=f+1|0;if(f>>>0>=l>>>0){h=0;break a}}if(j){h=h+1|0;break}else{h=c[m+(f*20|0)+8>>2]|0;break}}else h=0;while(0);g=b+56|0;f=c[g>>2]|0;if((f|0)!=0?(g9(n,h,F8(h)|0),p=Hr(f,n)|0,i9(n),(p|0)!=((c[g>>2]|0)+4|0)):0){pr(b)|0;b=p+28|0;sE((c[b>>2]|0)+152|0);b=c[b>>2]|0;i=M;return b|0}p=c[K>>2]|0;if((qg[c[(c[p>>2]|0)+24>>2]&63](p,q,4,1)|0)!=1){c[r>>2]=38121;Uv(2,63728,r);c[s>>2]=h;Uv(2,38130,s);Uv(2,63797,t);Jb(63799,37281,698,38121)}switch(c[q>>2]|0){case 1:{s=Iy(h)|0;break}case 2:{s=tv(h)|0;break}default:{b=0;i=M;return b|0}}f=c[g>>2]|0;b:do if(f){g9(v,h,F8(h)|0);g=v+12|0;c[g>>2]=s;o=0;na(156,u|0,v|0);t=o;o=0;do if(!(t&1)){c[u+12>>2]=c[g>>2];o=0;sb(130,x|0,f|0,u|0);t=o;o=0;if(t&1){f=zc()|0;o=0;Ja(451,u|0);u=o;o=0;if(!(u&1)){w=f;break}u=zc(0)|0;Di(u)}else{o=0;Ja(451,u|0);w=o;o=0;if(w&1){J=28;break}i9(v);break b}}else J=28;while(0);if((J|0)==28)w=zc()|0;o=0;Ja(451,v|0);v=o;o=0;if(v&1){w=zc(0)|0;Di(w)}else Kc(w|0)}while(0);f=(d|0)==0;r=f&(e|0)==0?s:e;e=c[K>>2]|0;if((qg[c[(c[e>>2]|0)+24>>2]&63](e,x,4,16)|0)!=16){c[D>>2]=38121;Uv(2,63728,D);c[E>>2]=h;Uv(2,38170,E);Uv(2,63797,z);Jb(63799,37281,731,38121)}tr(0,x,s);Gr(y,c[K>>2]|0);i9(y);E=c[K>>2]|0;if((qg[c[(c[E>>2]|0)+24>>2]&63](E,L,4,1)|0)!=1){c[A>>2]=38121;Uv(2,63728,A);c[B>>2]=h;Uv(2,38210,B);Uv(2,63797,C);Jb(63799,37281,744,38121)}c:do if(c[L>>2]|0){n=(r|0)!=0;p=b+32|0;q=b+36|0;if(f){m=0;while(1){k=c[K>>2]|0;k=rf[c[(c[k>>2]|0)+44>>2]&255](k)|0;d:do if((k|0)!=0?(F=c[p>>2]|0,(F|0)!=0):0){l=c[q>>2]|0;f=0;while(1){if((c[l+(f*20|0)+16>>2]|0)==(k|0)){h=l+(f*20|0)|0;g=a[h>>0]|0;j=(g&1)==0;if(j)g=(g&255)>>>1;else g=c[l+(f*20|0)+4>>2]|0;if(g)break}f=f+1|0;if(f>>>0>=F>>>0){f=0;break d}}if(j){f=h+1|0;break}else{f=c[l+(f*20|0)+8>>2]|0;break}}else f=0;while(0);if(n?(G=Wy(r,f,1,1)|0,(G|0)!=0):0){pr(b)|0;f=G;J=52}else J=51;if((J|0)==51?(J=0,H=ir(b,0,r)|0,(H|0)!=0):0){f=H;J=52}if((J|0)==52){of[c[(c[s>>2]|0)+32>>2]&511](s,f);tE(f+152|0)}m=m+1|0;if(m>>>0>=(c[L>>2]|0)>>>0)break c}}else m=0;do{k=c[K>>2]|0;k=rf[c[(c[k>>2]|0)+44>>2]&255](k)|0;e:do if((k|0)!=0?(I=c[p>>2]|0,(I|0)!=0):0){l=c[q>>2]|0;f=0;while(1){if((c[l+(f*20|0)+16>>2]|0)==(k|0)){h=l+(f*20|0)|0;g=a[h>>0]|0;j=(g&1)==0;if(j)g=(g&255)>>>1;else g=c[l+(f*20|0)+4>>2]|0;if(g)break}f=f+1|0;if(f>>>0>=I>>>0){g=0;break e}}if(j){g=h+1|0;break}else{g=c[l+(f*20|0)+8>>2]|0;break}}else g=0;while(0);f=zF(d,g,1,1)|0;if(n&(f|0)==0)f=Wy(r,g,1,1)|0;if(!f){f=ir(b,d,r)|0;if(f)J=71}else{pr(b)|0;J=71}if((J|0)==71){J=0;of[c[(c[s>>2]|0)+32>>2]&511](s,f);tE(f+152|0)}m=m+1|0}while(m>>>0<(c[L>>2]|0)>>>0)}while(0);f=qr(b)|0;if(f){pz(s,f);tE(f)}f=rr(b)|0;if(f){rz(s,f);tE(f)}f=sr(b,Jy(s)|0)|0;if(f){sz(s,f);tE(f)}b=s;i=M;return b|0}function jr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+32|0;d=f;e=f+20|0;g=c[a+40>>2]|0;if((qg[c[(c[g>>2]|0)+24>>2]&63](g,e,4,1)|0)!=1){c[d>>2]=38255;Uv(2,63728,d);Uv(2,38270,f+8|0);Uv(2,63797,f+16|0);Jb(63799,37281,1222,38255)}if(!(c[e>>2]|0)){i=f;return}else d=0;do{wr(a,b);d=d+1|0}while(d>>>0<(c[e>>2]|0)>>>0);i=f;return}function kr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;Q=i;i=i+112|0;L=Q+40|0;K=Q+32|0;F=Q+24|0;M=Q+16|0;J=Q+8|0;E=Q;I=Q+96|0;G=Q+84|0;S=Q+72|0;R=Q+60|0;H=Q+48|0;B=Q+44|0;P=b+48|0;g=c[P>>2]|0;C=b+44|0;f=c[C>>2]|0;D=g-f>>2;a:do if(D){q=(d|0)==0;U=S+4|0;r=S+8|0;N=R+8|0;O=R+1|0;s=b+32|0;t=b+36|0;u=b+40|0;v=H+4|0;w=S+8|0;x=I+4|0;y=I+8|0;z=I+1|0;p=0;b:while(1){n=c[f+(p<<2)>>2]|0;l=c[n+8>>2]|0;j=n+4|0;f=c[j>>2]|0;k=(l-f|0)/12|0;l=(l|0)==(f|0);if(!l){m=n+16|0;g=0;while(1){f9(I,f+(g*12|0)|0);f=a[I>>0]|0;h=(f&1)==0;f=h?(f&255)>>>1:c[x>>2]|0;if(f>>>0>1?(a[(h?z:c[y>>2]|0)>>0]|0)==35:0){o=0;fa(23,G|0,I|0,1,f+-1|0,I|0);h=o;o=0;if(h&1){g=17;break b}o=0;cb(58,I|0,G|0)|0;h=o;o=0;if(h&1){g=18;break b}o=0;Ja(451,G|0);h=o;o=0;if(h&1){g=17;break b}o=0;f=pb(35,b|0,((a[I>>0]&1)==0?z:c[y>>2]|0)|0,d|0,e|0)|0;h=o;o=0;if(h&1){g=17;break b}if(f){o=0;h=qa(c[(c[f>>2]|0)+28>>2]|0,f|0)|0;V=o;o=0;if(V&1){g=17;break b}if((h|0)==2){o=0;na(157,f|0,(c[m>>2]|0)+(g<<6)|0);V=o;o=0;if(V&1){g=17;break b}o=0;sb(131,c[n>>2]|0,f|0,g|0);V=o;o=0;if(V&1){g=17;break b}o=0;Ja(452,f+152|0);V=o;o=0;if(V&1){g=17;break b}}}}i9(I);g=g+1|0;if(g>>>0>=k>>>0)break;f=c[j>>2]|0}if(!l){h=cy(c[n>>2]|0,0)|0;g=Ty(h)|0;c[S>>2]=0;c[U>>2]=0;c[r>>2]=0;f=h;while(1){if(!g)break;o=0;f=cb(59,c[n>>2]|0,g|0)|0;V=o;o=0;if(V&1){g=28;break b}h=(f|0)==-1?h:g;o=0;f=qa(151,g|0)|0;V=o;o=0;if(V&1){g=28;break b}else{V=g;g=f;f=V}}o=0;f=qa(152,f|0)|0;V=o;o=0;if(V&1){g=29;break}V=F8(f)|0;o=0;sb(127,R|0,f|0,V|0);V=o;o=0;if(V&1){g=29;break}do{f=(a[R>>0]&1)==0?O:c[N>>2]|0;if(!(c[s>>2]|0)){g=37;break b}else g=0;while(1){if(!(D9((c[t>>2]|0)+(g*20|0)|0,f)|0))break;g=g+1|0;if(g>>>0>=(c[s>>2]|0)>>>0){g=37;break b}}f=c[t>>2]|0;if(!(f+(g*20|0)|0)){g=37;break b}o=0;Ha(41,b|0,((a[R>>0]&1)==0?O:c[N>>2]|0)|0,c[f+(g*20|0)+12>>2]|0)|0;V=o;o=0;if(V&1){g=44;break b}f=c[u>>2]|0;o=0;f=Ha(c[(c[f>>2]|0)+48>>2]|0,f|0,68,1)|0;V=o;o=0;if(V&1){g=44;break b}if(!f){g=51;break b}o=0;na(158,H|0,c[u>>2]|0);V=o;o=0;if(V&1){g=44;break b}V=a[H>>0]|0;if(((V&1)==0?(V&255)>>>1:c[v>>2]|0)|0){o=0;cb(58,R|0,H|0)|0;V=o;o=0;if(V&1){g=61;break b}else f=0}else f=11;o=0;Ja(451,H|0);V=o;o=0;if(V&1){g=44;break b}}while((f|0)==0);o=0;f=qa(152,h|0)|0;V=o;o=0;if(V&1){g=45;break}do if(D9(R,f)|0){o=0;f=pb(35,b|0,((a[R>>0]&1)==0?O:c[N>>2]|0)|0,d|0,e|0)|0;V=o;o=0;if(V&1){g=45;break b}c[B>>2]=f;g=c[U>>2]|0;if((g|0)==(c[w>>2]|0)){o=0;na(159,S|0,B|0);V=o;o=0;if(V&1){g=45;break b}else break}else{c[g>>2]=f;c[U>>2]=(c[U>>2]|0)+4;break}}while(0);o=0;Ja(451,R|0);V=o;o=0;if(V&1){g=29;break}o=0;na(160,c[n>>2]|0,h|0);V=o;o=0;if(V&1){g=29;break}h=c[U>>2]|0;f=c[S>>2]|0;if((h|0)==(f|0))f=h;else{j=0;do{g=c[f+(j<<2)>>2]|0;if(g){o=0;Ja(452,g+152|0);V=o;o=0;if(V&1){g=27;break b}c[(c[S>>2]|0)+(j<<2)>>2]=0;h=c[U>>2]|0;f=c[S>>2]|0}j=j+1|0}while(j>>>0<h-f>>2>>>0)}g=f;if(f){if((h|0)!=(f|0))c[U>>2]=h+(~((h+-4-g|0)>>>2)<<2);$5(f)}}}if(!q)CF(d,c[(c[n>>2]|0)+84>>2]|0);f=c[C>>2]|0;k=c[f+(p<<2)>>2]|0;if(k){f=k+16|0;g=c[f>>2]|0;if(g){h=k+20|0;while(1){j=c[h>>2]|0;if((j|0)==(g|0))break;V=j+-64|0;c[h>>2]=V;o=0;Ja(440,V|0);V=o;o=0;if(V&1){g=93;break b}}$5(c[f>>2]|0)}f=k+4|0;g=c[f>>2]|0;if(g){h=k+8|0;while(1){j=c[h>>2]|0;if((j|0)==(g|0))break;V=j+-12|0;c[h>>2]=V;o=0;Ja(451,V|0);V=o;o=0;if(V&1){g=99;break b}}$5(c[f>>2]|0)}$5(k);f=c[C>>2]|0}c[f+(p<<2)>>2]=0;p=p+1|0;f=c[C>>2]|0;if(p>>>0>=D>>>0){g=103;break}}switch(g|0){case 17:{f=zc()|0;g=21;break}case 18:{f=zc()|0;o=0;Ja(451,G|0);V=o;o=0;if(V&1){V=zc(0)|0;Di(V)}else g=21;break}case 27:{f=zc()|0;g=30;break}case 28:{f=zc()|0;g=30;break}case 29:{f=zc()|0;g=30;break}case 37:{o=0;c[E>>2]=38324;sb(128,2,63728,E|0);V=o;o=0;if(!(V&1)){f=b+8|0;if(!(a[f>>0]&1))f=f+1|0;else f=c[b+16>>2]|0;o=0;c[J>>2]=(a[R>>0]&1)==0?O:c[N>>2]|0;c[J+4>>2]=f;sb(128,2,37562,J|0);V=o;o=0;if(!(V&1)?(o=0,sb(128,2,63797,M|0),V=o,o=0,!(V&1)):0){o=0;yb(61,63799,37281,1150,38324);o=0;g=46}else g=46}else g=46;break}case 44:{f=zc()|0;g=47;break}case 45:{f=zc()|0;g=47;break}case 51:{o=0;c[F>>2]=38324;sb(128,2,63728,F|0);V=o;o=0;if(!(V&1)){f=b+8|0;if(!(a[f>>0]&1))f=f+1|0;else f=c[b+16>>2]|0;o=0;c[K>>2]=(a[R>>0]&1)==0?O:c[N>>2]|0;c[K+4>>2]=f;sb(128,2,38347,K|0);V=o;o=0;if(!(V&1)?(o=0,sb(128,2,63797,L|0),V=o,o=0,!(V&1)):0){o=0;yb(61,63799,37281,1160,38324);o=0;g=46}else g=46}else g=46;break}case 61:{f=zc()|0;o=0;Ja(451,H|0);V=o;o=0;if(V&1){V=zc(0)|0;Di(V)}else g=71;break}case 93:{Lc(zc()|0);break}case 99:{Lc(zc()|0);break}case 103:{g=c[P>>2]|0;break a}}if((g|0)==21){o=0;Ja(451,I|0);V=o;o=0;if(V&1){V=zc(0)|0;Di(V)}else{V=f;Kc(V|0)}}else if((g|0)==30)T=f;else if((g|0)==46){f=zc()|0;g=47}if((g|0)==47)g=71;if((g|0)==71){o=0;Ja(451,R|0);V=o;o=0;if(V&1){V=zc(0)|0;Di(V)}else T=f}f=c[S>>2]|0;if(!f){V=T;Kc(V|0)}g=c[U>>2]|0;if((g|0)!=(f|0))c[U>>2]=g+(~((g+-4-f|0)>>>2)<<2);$5(f);V=T;Kc(V|0)}while(0);if((g|0)==(f|0)){i=Q;return}c[P>>2]=g+(~((g+-4-f|0)>>>2)<<2);i=Q;return}function lr(a,b){a=a|0;b=b|0;return mr(a,b,0)|0}function mr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;W=i;i=i+224|0;L=W+168|0;K=W+160|0;J=W+152|0;I=W+144|0;H=W+128|0;G=W+120|0;F=W+112|0;E=W+104|0;D=W+96|0;C=W+88|0;B=W+80|0;A=W+72|0;z=W+64|0;y=W+56|0;x=W+48|0;P=W+40|0;O=W+32|0;Q=W+24|0;S=W+16|0;R=W+8|0;N=W;u=W+208|0;U=W+196|0;t=W+192|0;M=W+180|0;w=W+176|0;v=W+172|0;br(b);T=Z5(12)|0;V=T+4|0;c[V>>2]=0;c[T+8>>2]=0;c[T>>2]=V;V=b+56|0;c[V>>2]=T;if((e|0)!=0?(h=zF(e,d,1,1)|0,(h|0)!=0):0){sE(h+152|0);g=h;j=6}else if((fr(b,d,2)|0)!=0?(g=ir(b,e,0)|0,(g|0)!=0):0)j=6;else T=0;if((j|0)==6){kr(b,e,g);T=g}m=b+32|0;g=c[m>>2]|0;a:do if(g){n=b+36|0;p=b+40|0;q=M+4|0;r=U+8|0;s=U+1|0;h=0;b:while(1){d=c[n>>2]|0;if((c[d+(h*20|0)+12>>2]|0)==3){l=c[p>>2]|0;if(!(If[c[(c[l>>2]|0)+48>>2]&127](l,c[d+(h*20|0)+16>>2]|0,0)|0)){j=11;break}l=c[p>>2]|0;if((qg[c[(c[l>>2]|0)+24>>2]&63](l,u,4,1)|0)!=1){j=20;break}if(c[u>>2]|0){l=0;do{Gr(U,c[p>>2]|0);g=c[p>>2]|0;o=0;g=pb(c[(c[g>>2]|0)+24>>2]|0,g|0,t|0,4,1)|0;k=o;o=0;if(k&1){j=32;break b}if((g|0)!=1){j=27;break b}if(c[t>>2]|0){g=0;k=0;do{o=0;na(158,M|0,c[p>>2]|0);j=o;o=0;if(j&1){j=31;break b}j=a[M>>0]|0;if(!(((j&1)==0?(j&255)>>>1:c[q>>2]|0)|0)){j=37;break b}X=c[V>>2]|0;j=Hr(X,M)|0;d=c[p>>2]|0;e=c[(c[d>>2]|0)+24>>2]|0;o=0;if((j|0)==(X+4|0)){d=qg[e&63](d,v,4,1)|0;X=o;o=0;if(X&1){j=41;break b}if((d|0)!=1){j=59;break b}o=0;Aa(14,b|0,0,((a[U>>0]&1)==0?s:c[r>>2]|0)|0,0,0)|0;X=o;o=0;if(X&1){j=41;break b}}else{d=qg[e&63](d,w,4,1)|0;X=o;o=0;if(X&1){j=41;break b}if((d|0)!=1){j=47;break b}d=c[j+28>>2]|0;if(!d){j=52;break b}o=0;g=Aa(14,b|0,g|0,((a[U>>0]&1)==0?s:c[r>>2]|0)|0,d|0,c[w>>2]|0)|0;X=o;o=0;if(X&1){j=41;break b}}o=0;Ja(451,M|0);X=o;o=0;if(X&1){j=31;break b}k=k+1|0}while(k>>>0<(c[t>>2]|0)>>>0)}i9(U);l=l+1|0}while(l>>>0<(c[u>>2]|0)>>>0)}g=c[m>>2]|0}h=h+1|0;if(h>>>0>=g>>>0)break a}switch(j|0){case 11:{g=d+(h*20|0)|0;c[N>>2]=38421;Uv(2,63728,N);if(!(a[g>>0]&1))h=g+1|0;else h=c[d+(h*20|0)+8>>2]|0;g=b+8|0;if(!(a[g>>0]&1)){b=g+1|0;c[R>>2]=h;X=R+4|0;c[X>>2]=b;Uv(2,37662,R);Uv(2,63797,S);Jb(63799,37281,505,38421)}else{b=c[b+16>>2]|0;c[R>>2]=h;X=R+4|0;c[X>>2]=b;Uv(2,37662,R);Uv(2,63797,S);Jb(63799,37281,505,38421)}break}case 20:{g=d+(h*20|0)|0;c[Q>>2]=38421;Uv(2,63728,Q);if(!(a[g>>0]&1)){X=g+1|0;c[O>>2]=X;Uv(2,38430,O);Uv(2,63797,P);Jb(63799,37281,514,38421)}else{X=c[d+(h*20|0)+8>>2]|0;c[O>>2]=X;Uv(2,38430,O);Uv(2,63797,P);Jb(63799,37281,514,38421)}break}case 27:{o=0;c[x>>2]=38421;sb(128,2,63728,x|0);X=o;o=0;if((!(X&1)?(X=(a[U>>0]&1)==0?s:c[r>>2]|0,o=0,c[y>>2]=38555,c[y+4>>2]=X,sb(128,2,38487,y|0),X=o,o=0,!(X&1)):0)?(o=0,sb(128,2,63797,z|0),X=o,o=0,!(X&1)):0){o=0;yb(61,63799,37281,527,38421);o=0}f=zc()|0;j=34;break}case 31:{f=zc()|0;j=34;break}case 32:{f=zc()|0;j=34;break}case 37:{o=0;c[A>>2]=38421;sb(128,2,63728,A|0);X=o;o=0;if((!(X&1)?(o=0,c[B>>2]=(a[U>>0]&1)==0?s:c[r>>2]|0,sb(128,2,38577,B|0),X=o,o=0,!(X&1)):0)?(o=0,sb(128,2,63797,C|0),X=o,o=0,!(X&1)):0){o=0;yb(61,63799,37281,539,38421);o=0;j=42}else j=42;break}case 41:{g=zc()|0;j=43;break}case 47:{o=0;c[D>>2]=38421;sb(128,2,63728,D|0);X=o;o=0;if((!(X&1)?(o=0,c[E>>2]=(a[U>>0]&1)==0?s:c[r>>2]|0,sb(128,2,38622,E|0),X=o,o=0,!(X&1)):0)?(o=0,sb(128,2,63797,F|0),X=o,o=0,!(X&1)):0){o=0;yb(61,63799,37281,552,38421);o=0;j=42}else j=42;break}case 52:{o=0;c[G>>2]=38421;sb(128,2,63728,G|0);X=o;o=0;if((!(X&1)?(S=(a[M>>0]&1)==0?M+1|0:c[M+8>>2]|0,X=(a[U>>0]&1)==0?s:c[r>>2]|0,o=0,c[H>>2]=38703,c[H+4>>2]=S,c[H+8>>2]=X,sb(128,2,38674,H|0),X=o,o=0,!(X&1)):0)?(o=0,sb(128,2,63797,I|0),X=o,o=0,!(X&1)):0){o=0;yb(61,63799,37281,560,38421);o=0;j=42}else j=42;break}case 59:{o=0;c[J>>2]=38421;sb(128,2,63728,J|0);X=o;o=0;if((!(X&1)?(o=0,c[K>>2]=(a[U>>0]&1)==0?s:c[r>>2]|0,sb(128,2,38720,K|0),X=o,o=0,!(X&1)):0)?(o=0,sb(128,2,63797,L|0),X=o,o=0,!(X&1)):0){o=0;yb(61,63799,37281,573,38421);o=0;j=42}else j=42;break}}if((j|0)!=34)if((j|0)==42){g=zc()|0;j=43}if((j|0)==43){o=0;Ja(451,M|0);X=o;o=0;if(X&1){X=zc(0)|0;Di(X)}else f=g}o=0;Ja(451,U|0);X=o;o=0;if(X&1){X=zc(0)|0;Di(X)}else Kc(f|0)}while(0);f=c[V>>2]|0;if(!f){c[V>>2]=0;i=W;return T|0}Kr(f,c[f+4>>2]|0);$5(f);c[V>>2]=0;i=W;return T|0}function nr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;if((c|0)!=0?(e=zF(c,b,1,1)|0,(e|0)!=0):0){sE(e+152|0);a=e;return a|0}if((d|0)!=0?(f=Wy(d,b,1,1)|0,(f|0)!=0):0){sE(f+152|0);a=f;return a|0}if(!(fr(a,b,2)|0)){a=0;return a|0}a=ir(a,c,d)|0;return a|0}function or(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;r=i;i=i+80|0;v=r+68|0;t=r+56|0;q=r+44|0;n=r+32|0;l=r+20|0;h=r+16|0;j=r+8|0;k=r+4|0;g=r;c[v>>2]=0;w=v+4|0;c[w>>2]=0;c[v+8>>2]=0;c[t>>2]=0;u=t+4|0;c[u>>2]=0;c[t+8>>2]=0;c[q>>2]=0;s=q+4|0;c[s>>2]=0;c[q+8>>2]=0;c[n>>2]=0;p=n+4|0;c[p>>2]=0;c[n+8>>2]=0;c[l>>2]=0;m=l+4|0;c[m>>2]=0;c[l+8>>2]=0;o=0;pb(36,a|0,h|0,v|0,4)|0;x=o;o=0;a:do if((((!(x&1)?(o=0,Ha(42,a|0,r+12|0,t|0)|0,x=o,o=0,!(x&1)):0)?(o=0,Ha(42,a|0,j|0,q|0)|0,x=o,o=0,!(x&1)):0)?(o=0,Ha(42,a|0,k|0,n|0)|0,x=o,o=0,!(x&1)):0)?(o=0,pb(36,a|0,g|0,l|0,4)|0,x=o,o=0,!(x&1)):0){do if(f){g=c[h>>2]|0;h=c[v>>2]|0;j=c[t>>2]|0;o=0;if(!b){g=Eq(e,d,f,g,h,j,4)|0;x=o;o=0;if(x&1)break a;else{b=g;break}}else{Sp(b,e,f,g,h,j,4)|0;x=o;o=0;if(x&1)break a;else break}}while(0);g=c[l>>2]|0;h=g;if(g){j=c[m>>2]|0;if((j|0)!=(g|0))c[m>>2]=j+(~((j+-4-h|0)>>>2)<<2);$5(g)}g=c[n>>2]|0;h=g;if(g){j=c[p>>2]|0;if((j|0)!=(g|0))c[p>>2]=j+(~((j+-4-h|0)>>>2)<<2);$5(g)}g=c[q>>2]|0;h=g;if(g){j=c[s>>2]|0;if((j|0)!=(g|0))c[s>>2]=j+(~((j+-4-h|0)>>>2)<<2);$5(g)}g=c[t>>2]|0;h=g;if(g){j=c[u>>2]|0;if((j|0)!=(g|0))c[u>>2]=j+(~((j+-4-h|0)>>>2)<<2);$5(g)}g=c[v>>2]|0;if(!g){i=r;return b|0}h=c[w>>2]|0;if((h|0)!=(g|0))c[w>>2]=h+(~((h+-4-g|0)>>>2)<<2);$5(g);i=r;return b|0}while(0);k=zc()|0;g=c[l>>2]|0;h=g;if(g){j=c[m>>2]|0;if((j|0)!=(g|0))c[m>>2]=j+(~((j+-4-h|0)>>>2)<<2);$5(g)}g=c[n>>2]|0;h=g;if(g){j=c[p>>2]|0;if((j|0)!=(g|0))c[p>>2]=j+(~((j+-4-h|0)>>>2)<<2);$5(g)}g=c[q>>2]|0;h=g;if(g){j=c[s>>2]|0;if((j|0)!=(g|0))c[s>>2]=j+(~((j+-4-h|0)>>>2)<<2);$5(g)}g=c[t>>2]|0;h=g;if(g){j=c[u>>2]|0;if((j|0)!=(g|0))c[u>>2]=j+(~((j+-4-h|0)>>>2)<<2);$5(g)}g=c[v>>2]|0;if(!g)Kc(k|0);h=c[w>>2]|0;if((h|0)!=(g|0))c[w>>2]=h+(~((h+-4-g|0)>>>2)<<2);$5(g);Kc(k|0);return 0}function pr(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;y=i;i=i+96|0;t=y+64|0;s=y+56|0;r=y+48|0;q=y+40|0;w=y+32|0;v=y+24|0;u=y+16|0;p=y+8|0;o=y;n=y+84|0;l=y+72|0;x=y+68|0;m=b+40|0;j=c[m>>2]|0;j=rf[c[(c[j>>2]|0)+44>>2]&255](j)|0;a:do if((j|0)!=0?(k=c[b+32>>2]|0,(k|0)!=0):0){h=c[b+36>>2]|0;d=0;while(1){if((c[h+(d*20|0)+16>>2]|0)==(j|0)){f=h+(d*20|0)|0;e=a[f>>0]|0;g=(e&1)==0;if(g)e=(e&255)>>>1;else e=c[h+(d*20|0)+4>>2]|0;if(e)break}d=d+1|0;if(d>>>0>=k>>>0){e=0;break a}}if(g){e=f+1|0;break}else{e=c[h+(d*20|0)+8>>2]|0;break}}else e=0;while(0);k=c[m>>2]|0;if((qg[c[(c[k>>2]|0)+24>>2]&63](k,n,4,1)|0)!=1){c[o>>2]=38777;Uv(2,63728,o);c[p>>2]=e;Uv(2,38786,p);Uv(2,63797,u);Jb(63799,37281,637,38777)}u=c[m>>2]|0;if(!(If[c[(c[u>>2]|0)+48>>2]&127](u,64,1)|0)){c[v>>2]=38777;Uv(2,63728,v);c[w>>2]=e;Uv(2,38826,w);Uv(2,63797,q);Jb(63799,37281,644,38777)}Gr(l,c[m>>2]|0);i9(l);w=c[m>>2]|0;if((qg[c[(c[w>>2]|0)+24>>2]&63](w,x,4,1)|0)!=1){c[r>>2]=38777;Uv(2,63728,r);c[s>>2]=e;Uv(2,38876,s);Uv(2,63797,t);Jb(63799,37281,653,38777)}if(c[x>>2]|0){d=0;do{pr(b)|0;d=d+1|0}while(d>>>0<(c[x>>2]|0)>>>0)}d=qr(b)|0;if(d)tE(d);d=rr(b)|0;if(d)tE(d);d=sr(b,e)|0;if(!d){i=y;return 1}tE(d);i=y;return 1}function qr(b){b=b|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;I=i;i=i+224|0;M=I+184|0;L=I+176|0;w=I+168|0;K=I+160|0;J=I+152|0;F=I+144|0;E=I+136|0;D=I+128|0;v=I+120|0;C=I+112|0;B=I+104|0;u=I+96|0;t=I+88|0;s=I+80|0;p=I+72|0;o=I+64|0;n=I+56|0;l=I+48|0;k=I+40|0;m=I+32|0;j=I+24|0;h=I+16|0;f=I+8|0;e=I;q=I+212|0;y=I+208|0;A=I+204|0;z=I+200|0;r=I+196|0;G=I+192|0;H=I+188|0;x=b+40|0;N=c[x>>2]|0;if((qg[c[(c[N>>2]|0)+24>>2]&63](N,q,1,1)|0)!=1){c[e>>2]=38933;Uv(2,63728,e);e=b+8|0;if(!(a[e>>0]&1)){N=e+1|0;c[f>>2]=N;Uv(2,38944,f);Uv(2,63797,h);Jb(63799,37281,818,38933)}else{N=c[b+16>>2]|0;c[f>>2]=N;Uv(2,38944,f);Uv(2,63797,h);Jb(63799,37281,818,38933)}}if(!(a[q>>0]|0)){N=0;i=I;return N|0}N=c[x>>2]|0;if((qg[c[(c[N>>2]|0)+24>>2]&63](N,y,4,1)|0)!=1){c[j>>2]=38933;Uv(2,63728,j);e=b+8|0;if(!(a[e>>0]&1)){N=e+1|0;c[m>>2]=N;Uv(2,38987,m);Uv(2,63797,k);Jb(63799,37281,831,38933)}else{N=c[b+16>>2]|0;c[m>>2]=N;Uv(2,38987,m);Uv(2,63797,k);Jb(63799,37281,831,38933)}}N=c[x>>2]|0;if((qg[c[(c[N>>2]|0)+24>>2]&63](N,A,4,1)|0)!=1){c[l>>2]=38933;Uv(2,63728,l);e=b+8|0;if(!(a[e>>0]&1)){N=e+1|0;c[n>>2]=N;Uv(2,39038,n);Uv(2,63797,o);Jb(63799,37281,838,38933)}else{N=c[b+16>>2]|0;c[n>>2]=N;Uv(2,39038,n);Uv(2,63797,o);Jb(63799,37281,838,38933)}}N=c[x>>2]|0;if((qg[c[(c[N>>2]|0)+24>>2]&63](N,z,4,1)|0)!=1){c[p>>2]=38933;Uv(2,63728,p);e=b+8|0;if(!(a[e>>0]&1)){N=e+1|0;c[s>>2]=N;Uv(2,39087,s);Uv(2,63797,t);Jb(63799,37281,845,38933)}else{N=c[b+16>>2]|0;c[s>>2]=N;Uv(2,39087,s);Uv(2,63797,t);Jb(63799,37281,845,38933)}}switch(a[q>>0]|0){case 1:{N=c[x>>2]|0;if((qg[c[(c[N>>2]|0)+24>>2]&63](N,r,4,1)|0)==1){N=bs(+g[r>>2],+g[y>>2],+g[A>>2],+g[z>>2])|0;i=I;return N|0}c[u>>2]=38933;Uv(2,63728,u);e=b+8|0;if(!(a[e>>0]&1)){N=e+1|0;c[B>>2]=N;Uv(2,39135,B);Uv(2,63797,C);Jb(63799,37281,855,38933)}else{N=c[b+16>>2]|0;c[B>>2]=N;Uv(2,39135,B);Uv(2,63797,C);Jb(63799,37281,855,38933)}break}case 2:{N=c[x>>2]|0;if((qg[c[(c[N>>2]|0)+24>>2]&63](N,G,4,1)|0)!=1){c[v>>2]=38933;Uv(2,63728,v);e=b+8|0;if(!(a[e>>0]&1)){N=e+1|0;c[D>>2]=N;Uv(2,39187,D);Uv(2,63797,E);Jb(63799,37281,866,38933)}else{N=c[b+16>>2]|0;c[D>>2]=N;Uv(2,39187,D);Uv(2,63797,E);Jb(63799,37281,866,38933)}}N=c[x>>2]|0;if((qg[c[(c[N>>2]|0)+24>>2]&63](N,H,4,1)|0)==1){N=cs(+g[G>>2],+g[H>>2],+g[y>>2],+g[A>>2],+g[z>>2])|0;i=I;return N|0}c[F>>2]=38933;Uv(2,63728,F);e=b+8|0;if(!(a[e>>0]&1)){N=e+1|0;c[J>>2]=N;Uv(2,39231,J);Uv(2,63797,K);Jb(63799,37281,873,38933)}else{N=c[b+16>>2]|0;c[J>>2]=N;Uv(2,39231,J);Uv(2,63797,K);Jb(63799,37281,873,38933)}break}default:{c[w>>2]=38933;Uv(2,63728,w);e=d[q>>0]|0;f=b+8|0;if(!(a[f>>0]&1)){b=f+1|0;c[L>>2]=e;N=L+4|0;c[N>>2]=b;Uv(2,39275,L);Uv(2,63797,M);Jb(63799,37281,881,38933)}else{b=c[b+16>>2]|0;c[L>>2]=e;N=L+4|0;c[N>>2]=b;Uv(2,39275,L);Uv(2,63797,M);Jb(63799,37281,881,38933)}}}return 0}function rr(b){b=b|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;I=i;i=i+208|0;v=I+160|0;u=I+152|0;m=I+144|0;H=I+136|0;G=I+128|0;D=I+120|0;F=I+112|0;E=I+104|0;t=I+96|0;C=I+88|0;B=I+80|0;q=I+72|0;A=I+64|0;z=I+56|0;p=I+48|0;M=I+40|0;N=I+32|0;J=I+24|0;l=I+16|0;k=I+8|0;e=I;s=I+204|0;j=I+200|0;f=I+196|0;h=I+192|0;L=I+180|0;n=I+176|0;y=I+172|0;w=I+168|0;x=I+164|0;r=b+40|0;O=c[r>>2]|0;if((qg[c[(c[O>>2]|0)+24>>2]&63](O,s,1,1)|0)!=1){c[e>>2]=39320;Uv(2,63728,e);e=b+8|0;if(!(a[e>>0]&1)){O=e+1|0;c[k>>2]=O;Uv(2,39330,k);Uv(2,63797,l);Jb(63799,37281,892,39320)}else{O=c[b+16>>2]|0;c[k>>2]=O;Uv(2,39330,k);Uv(2,63797,l);Jb(63799,37281,892,39320)}}if(!(a[s>>0]|0)){O=0;i=I;return O|0}O=c[r>>2]|0;if(((qg[c[(c[O>>2]|0)+24>>2]&63](O,j,4,1)|0)==1?(O=c[r>>2]|0,(qg[c[(c[O>>2]|0)+24>>2]&63](O,f,4,1)|0)==1):0)?(O=c[r>>2]|0,(qg[c[(c[O>>2]|0)+24>>2]&63](O,h,4,1)|0)==1):0){RH(L,+g[j>>2],+g[f>>2],+g[h>>2]);a:do switch(a[s>>0]|0){case 1:{o=0;e=qa(153,L|0)|0;O=o;o=0;if(!(O&1))K=62;break}case 2:{e=c[r>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,n|0,4,1)|0;O=o;o=0;if(!(O&1)){if((e|0)==1){o=0;e=Wa(1,L|0,+(+g[n>>2]))|0;O=o;o=0;if(O&1)break a;else{K=62;break a}}o=0;c[p>>2]=39320;sb(128,2,63728,p|0);O=o;o=0;if(!(O&1)){e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;o=0;c[z>>2]=e;sb(128,2,39415,z|0);O=o;o=0;if(!(O&1)?(o=0,sb(128,2,63797,A|0),O=o,o=0,!(O&1)):0){o=0;yb(61,63799,37281,921,39320);o=0}}}break}case 3:{e=c[r>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,y|0,4,1)|0;O=o;o=0;if(!(O&1)){if((e|0)!=1){o=0;c[q>>2]=39320;sb(128,2,63728,q|0);O=o;o=0;if(O&1)break a;e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;o=0;c[B>>2]=e;sb(128,2,39464,B|0);O=o;o=0;if(O&1)break a;o=0;sb(128,2,63797,C|0);O=o;o=0;if(O&1)break a;o=0;yb(61,63799,37281,931,39320);o=0;break a}e=c[r>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,w|0,4,1)|0;O=o;o=0;if(!(O&1)){if((e|0)!=1){o=0;c[t>>2]=39320;sb(128,2,63728,t|0);O=o;o=0;if(O&1)break a;e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;o=0;c[E>>2]=e;sb(128,2,39512,E|0);O=o;o=0;if(O&1)break a;o=0;sb(128,2,63797,F|0);O=o;o=0;if(O&1)break a;o=0;yb(61,63799,37281,936,39320);o=0;break a}e=c[r>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,x|0,4,1)|0;O=o;o=0;if(!(O&1)){if((e|0)==1){o=0;e=Za(1,L|0,+(+g[y>>2]),+(+g[w>>2]),+(+g[x>>2]))|0;O=o;o=0;if(O&1)break a;else{K=62;break a}}o=0;c[D>>2]=39320;sb(128,2,63728,D|0);O=o;o=0;if(!(O&1)){e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;o=0;c[G>>2]=e;sb(128,2,39566,G|0);O=o;o=0;if(!(O&1)?(o=0,sb(128,2,63797,H|0),O=o,o=0,!(O&1)):0){o=0;yb(61,63799,37281,941,39320);o=0}}}}}break}default:{o=0;c[m>>2]=39320;sb(128,2,63728,m|0);O=o;o=0;if(!(O&1)){e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;o=0;c[u>>2]=d[s>>0];c[u+4>>2]=e;sb(128,2,39620,u|0);O=o;o=0;if(!(O&1)?(o=0,sb(128,2,63797,v|0),O=o,o=0,!(O&1)):0){o=0;yb(61,63799,37281,948,39320);o=0}}}}while(0);if((K|0)==62){WH(L);O=e;i=I;return O|0}e=zc()|0;o=0;Ja(412,L|0);O=o;o=0;if(O&1){O=zc(0)|0;Di(O)}else Kc(e|0)}c[J>>2]=39320;Uv(2,63728,J);e=b+8|0;if(!(a[e>>0]&1)){O=e+1|0;c[N>>2]=O;Uv(2,39372,N);Uv(2,63797,M);Jb(63799,37281,906,39320)}else{O=c[b+16>>2]|0;c[N>>2]=O;Uv(2,39372,N);Uv(2,63797,M);Jb(63799,37281,906,39320)}return 0}function sr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;x=i;i=i+96|0;n=x+40|0;m=x+32|0;l=x+24|0;k=x+16|0;j=x+8|0;g=x;z=x+72|0;f=x+84|0;t=x+68|0;v=x+56|0;w=x+44|0;s=b+40|0;Gr(z,c[s>>2]|0);r=a[z>>0]|0;d=(r&1)==0;if((d?(r&255)>>>1:c[z+4>>2]|0)>>>0<=1){b=0;i9(z);i=x;return b|0}p=z+8|0;q=z+1|0;d=d?q:c[p>>2]|0;if((a[d>>0]|0)!=35){b=0;i9(z);i=x;return b|0}o=0;d=Ha(43,b|0,d+1|0,0)|0;r=o;o=0;do if(!(r&1)){if(!d){b=0;i9(z);i=x;return b|0}o=0;r=qa(154,d|0)|0;A=o;o=0;if((!(A&1)?(o=0,Ja(452,d|0),A=o,o=0,!(A&1)):0)?(h=c[s>>2]|0,o=0,h=pb(c[(c[h>>2]|0)+24>>2]|0,h|0,f|0,1,1)|0,A=o,o=0,!(A&1)):0){if((h|0)!=1){o=0;c[g>>2]=39664;sb(128,2,63728,g|0);A=o;o=0;if(A&1){f=8;break}e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;o=0;c[j>>2]=((a[z>>0]&1)==0?q:c[p>>2]|0)+1;c[j+4>>2]=e;sb(128,2,39674,j|0);A=o;o=0;if(A&1){f=8;break}o=0;sb(128,2,63797,k|0);A=o;o=0;if(A&1){f=8;break}o=0;yb(61,63799,37281,969,39664);o=0;f=8;break}if(a[f>>0]|0){o=0;d=qa(155,b|0)|0;A=o;o=0;if(A&1){f=8;break}if((d|0)!=0?(o=0,na(161,r|0,d|0),A=o,o=0,A&1):0){f=8;break}}d=c[s>>2]|0;o=0;d=pb(c[(c[d>>2]|0)+24>>2]|0,d|0,t|0,4,1)|0;A=o;o=0;if(!(A&1)){if((d|0)!=1){o=0;c[l>>2]=39664;sb(128,2,63728,l|0);A=o;o=0;if(A&1){f=8;break}e=b+8|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+16>>2]|0;o=0;c[m>>2]=((a[z>>0]&1)==0?q:c[p>>2]|0)+1;c[m+4>>2]=e;sb(128,2,39750,m|0);A=o;o=0;if(A&1){f=8;break}o=0;sb(128,2,63797,n|0);A=o;o=0;if(A&1){f=8;break}o=0;yb(61,63799,37281,984,39664);o=0;f=8;break}if(!(c[t>>2]|0)){A=r;i9(z);i=x;return A|0}l=v+8|0;g=v+1|0;h=v+4|0;j=w+8|0;k=w+1|0;m=0;while(1){o=0;na(158,v|0,c[s>>2]|0);A=o;o=0;if(A&1){f=7;break}o=0;d=qa(156,b|0)|0;A=o;o=0;if(A&1){f=45;break}o=0;na(156,w|0,d|0);A=o;o=0;if(A&1){f=45;break}o=0;cb(60,w|0,39821)|0;A=o;o=0;if(A&1){f=46;break}A=a[v>>0]|0;q=(A&1)==0;o=0;Ha(44,w|0,(q?g:c[l>>2]|0)|0,(q?(A&255)>>>1:c[h>>2]|0)|0)|0;A=o;o=0;if(A&1){f=46;break}o=0;f=qa(157,((a[w>>0]&1)==0?k:c[j>>2]|0)|0)|0;A=o;o=0;if(A&1){f=46;break}if(f){o=0;d=qa(158,r|0)|0;A=o;o=0;if(A&1){f=46;break}o=0;d=qa(159,d|0)|0;A=o;o=0;if(A&1){f=46;break}o=0;sb(132,r|0,f|0,((d|0)!=0?m:-1)|0);A=o;o=0;if(A&1){f=46;break}o=0;Ja(452,f|0);A=o;o=0;if(A&1){f=46;break}}o=0;Ja(451,w|0);A=o;o=0;if(A&1){f=45;break}o=0;Ja(451,v|0);A=o;o=0;if(A&1){f=7;break}m=m+1|0;if(m>>>0>=(c[t>>2]|0)>>>0){e=r;f=51;break}}if((f|0)==7){e=zc()|0;f=9;break}else if((f|0)==45)y=zc()|0;else if((f|0)==46){d=zc()|0;o=0;Ja(451,w|0);A=o;o=0;if(A&1){A=zc(0)|0;Di(A)}else y=d}else if((f|0)==51){i9(z);i=x;return e|0}o=0;Ja(451,v|0);A=o;o=0;if(A&1){A=zc(0)|0;Di(A)}else e=y}else f=8}else f=8}else f=8;while(0);if((f|0)==8){e=zc()|0;f=9}o=0;Ja(451,z|0);A=o;o=0;if(A&1){A=zc(0)|0;Di(A)}else Kc(e|0);return 0}function tr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+112|0;d=a+40|0;f=a+28|0;g=a+16|0;e=a;Mw(d,b);o=0;Ja(411,f|0);b=o;o=0;a:do if(!(b&1)){o=0;Ja(411,g|0);b=o;o=0;b:do if(!(b&1)){o=0;Ja(427,e|0);b=o;o=0;do if(!(b&1)){o=0;pb(33,d|0,f|0,e|0,g|0)|0;b=o;o=0;if(((!(b&1)?(o=0,na(162,c|0,f|0),b=o,o=0,!(b&1)):0)?(o=0,na(138,c|0,g|0),b=o,o=0,!(b&1)):0)?(o=0,na(133,c|0,e|0),b=o,o=0,!(b&1)):0){o=0;Ja(429,e|0);l=o;o=0;if(l&1){l=14;break}o=0;Ja(412,g|0);l=o;o=0;if(l&1){l=13;break b}o=0;Ja(412,f|0);l=o;o=0;if(l&1){l=12;break a}Pw(d);i=a;return}a=zc()|0;o=0;Ja(429,e|0);b=o;o=0;if(b&1){b=zc(0)|0;Di(b)}else h=a}else l=14;while(0);if((l|0)==14)h=zc()|0;o=0;Ja(412,g|0);b=o;o=0;if(b&1){h=zc(0)|0;Di(h)}else j=h}else l=13;while(0);if((l|0)==13)j=zc()|0;o=0;Ja(412,f|0);h=o;o=0;if(h&1){j=zc(0)|0;Di(j)}else k=j}else l=12;while(0);if((l|0)==12)k=zc()|0;o=0;Ja(440,d|0);l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else Kc(k|0)}function ur(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+144|0;w=x+136|0;v=x+128|0;u=x+120|0;t=x+112|0;s=x+104|0;r=x+96|0;l=x+80|0;k=x+72|0;j=x+56|0;h=x+48|0;g=x+32|0;f=x+24|0;e=x+8|0;d=x;p=a+40|0;q=c[p>>2]|0;q=rf[c[(c[q>>2]|0)+44>>2]&255](q)|0;if((q|0)==-1){c[d>>2]=39823;Uv(2,63728,d);c[e>>2]=b;Uv(2,39832,e);Uv(2,63797,x+16|0);Jb(63799,37281,1352,39823)}if(!(fr(a,b,34)|0)){c[f>>2]=39823;Uv(2,63728,f);c[g>>2]=b;Uv(2,39899,g);Uv(2,63797,x+40|0);Jb(63799,37281,1360,39823)}n=yr(a)|0;if(!n){c[h>>2]=39823;Uv(2,63728,h);c[j>>2]=b;Uv(2,39935,j);Uv(2,63797,x+64|0);Jb(63799,37281,1368,39823)}d=n+16|0;m=xx(n,c[d>>2]|0,0)|0;if(!m){c[k>>2]=39823;Uv(2,63728,k);c[l>>2]=b;Uv(2,39975,l);Uv(2,63797,x+88|0);Jb(63799,37281,1376,39823)}h=m+8|0;j9(h,a+8|0)|0;o9(h,39821)|0;o9(h,b)|0;yx(m,c[n+20>>2]|0,0,c[d>>2]|0);kJ(m+60|0,n+24|0);Uq(m+84|0,n+48|0);h=n+72|0;j=n+68|0;d=c[j>>2]|0;a:do if((c[h>>2]|0)!=(d|0)){e=d;d=0;while(1){e=c[e+(d<<2)>>2]|0;f=e+8|0;g=Gx(m,c[e>>2]|0,c[e+4>>2]|0,c[f>>2]|0,0)|0;if(!g)break;Zx(g,c[e+12>>2]|0,0,c[f>>2]|0);d=d+1|0;e=c[j>>2]|0;if(d>>>0>=(c[h>>2]|0)-e>>2>>>0)break a}c[r>>2]=39823;Uv(2,63728,r);c[s>>2]=d;c[s+4>>2]=b;Uv(2,40003,s);Uv(2,63797,t);Jb(63799,37281,1399,39823)}while(0);o=0;Ja(458,n|0);t=o;o=0;if(t&1){b=zc()|0;$5(n);Kc(b|0)}$5(n);t=c[p>>2]|0;if(If[c[(c[t>>2]|0)+48>>2]&127](t,q,0)|0){i=x;return m|0}else{c[u>>2]=39823;Uv(2,63728,u);c[v>>2]=b;Uv(2,40061,v);Uv(2,63797,w);Jb(63799,37281,1411,39823)}return 0}function vr(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;F=i;i=i+352|0;C=F+112|0;B=F+104|0;z=F+96|0;t=F+88|0;s=F+80|0;q=F+72|0;n=F+64|0;m=F+56|0;l=F+48|0;j=F+40|0;k=F+32|0;h=F+24|0;g=F+16|0;f=F+8|0;d=F;e=F+280|0;E=F+272|0;v=F+200|0;p=F+188|0;r=F+184|0;w=F+208|0;y=F+120|0;D=Z5(96)|0;o=0;Ja(459,D|0);u=o;o=0;if(u&1){F=zc()|0;$5(D);Kc(F|0)}u=b+40|0;G=c[u>>2]|0;if((qg[c[(c[G>>2]|0)+24>>2]&63](G,e,4,16)|0)!=16){c[d>>2]=40117;Uv(2,63728,d);d=b+8|0;if(!(a[d>>0]&1)){G=d+1|0;c[f>>2]=G;Uv(2,40130,f);Uv(2,63797,g);Jb(63799,37281,1019,40117)}else{G=c[b+16>>2]|0;c[f>>2]=G;Uv(2,40130,f);Uv(2,63797,g);Jb(63799,37281,1019,40117)}}by(D,e);f=Z5(28)|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[E>>2]=f;c[f>>2]=D;G=c[u>>2]|0;if((qg[c[(c[G>>2]|0)+24>>2]&63](G,v,4,1)|0)!=1){c[h>>2]=40117;Uv(2,63728,h);d=b+8|0;if(!(a[d>>0]&1)){G=d+1|0;c[k>>2]=G;Uv(2,40186,k);Uv(2,63797,j);Jb(63799,37281,1032,40117)}else{G=c[b+16>>2]|0;c[k>>2]=G;Uv(2,40186,k);Uv(2,63797,j);Jb(63799,37281,1032,40117)}}e=c[v>>2]|0;if(!e){c[l>>2]=40117;Uv(2,63728,l);d=b+8|0;if(!(a[d>>0]&1)){G=d+1|0;c[m>>2]=G;Uv(2,40243,m);Uv(2,63797,n);Jb(63799,37281,1039,40117)}else{G=c[b+16>>2]|0;c[m>>2]=G;Uv(2,40243,m);Uv(2,63797,n);Jb(63799,37281,1039,40117)}}ey(D,e);a:do if(c[v>>2]|0){g=f+8|0;h=f+12|0;d=f+4|0;f=0;while(1){Gr(p,c[u>>2]|0);e=c[g>>2]|0;o=0;if((e|0)==(c[h>>2]|0)){Nr(d,p);G=o;o=0;if(G&1)break}else{f9(e,p);G=o;o=0;if(G&1)break;c[g>>2]=(c[g>>2]|0)+12}i9(p);f=f+1|0;if(f>>>0>=(c[v>>2]|0)>>>0)break a}d=zc()|0;o=0;Ja(451,p|0);G=o;o=0;if(G&1){G=zc(0)|0;Di(G)}else{G=d;Kc(G|0)}}while(0);G=c[u>>2]|0;if((qg[c[(c[G>>2]|0)+24>>2]&63](G,r,4,1)|0)!=1){c[q>>2]=40117;Uv(2,63728,q);d=b+8|0;if(!(a[d>>0]&1)){G=d+1|0;c[s>>2]=G;Uv(2,40318,s);Uv(2,63797,t);Jb(63799,37281,1056,40117)}else{G=c[b+16>>2]|0;c[s>>2]=G;Uv(2,40318,s);Uv(2,63797,t);Jb(63799,37281,1056,40117)}}if(c[r>>2]|0)b:do if(c[v>>2]|0){g=c[E>>2]|0;e=g+20|0;f=g+24|0;g=g+16|0;h=0;while(1){G=c[u>>2]|0;if((qg[c[(c[G>>2]|0)+24>>2]&63](G,w,4,16)|0)!=16){A=h;break}Mw(y,w);d=c[e>>2]|0;o=0;if((d|0)==(c[f>>2]|0)){Or(g,y);G=o;o=0;if(G&1){x=44;break}}else{Ow(d,y);G=o;o=0;if(G&1){x=44;break}c[e>>2]=(c[e>>2]|0)+64}Pw(y);h=h+1|0;if(h>>>0>=(c[v>>2]|0)>>>0)break b}if((x|0)==44){d=zc()|0;o=0;Ja(440,y|0);G=o;o=0;if(G&1){G=zc(0)|0;Di(G)}else{G=d;Kc(G|0)}}c[z>>2]=40117;Uv(2,63728,z);d=b+8|0;if(!(a[d>>0]&1)){z=d+1|0;c[B>>2]=A;G=B+4|0;c[G>>2]=z;Uv(2,40376,B);Uv(2,63797,C);Jb(63799,37281,1069,40117)}else{z=c[b+16>>2]|0;c[B>>2]=A;G=B+4|0;c[G>>2]=z;Uv(2,40376,B);Uv(2,63797,C);Jb(63799,37281,1069,40117)}}while(0);d=b+48|0;e=c[d>>2]|0;if((e|0)==(c[b+52>>2]|0)){Pr(b+44|0,E);i=F;return D|0}else{c[e>>2]=c[E>>2];c[d>>2]=(c[d>>2]|0)+4;i=F;return D|0}return 0}function wr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+48|0;h=k+16|0;g=k+8|0;f=k;l=k+24|0;j=k+20|0;e=b+40|0;Gr(l,c[e>>2]|0);e=c[e>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,j|0,4,1)|0;m=o;o=0;do if(!(m&1)){if((e|0)!=1){o=0;c[f>>2]=40456;sb(128,2,63728,f|0);m=o;o=0;if(m&1){f=10;break}o=0;c[g>>2]=(a[l>>0]&1)==0?l+1|0:c[l+8>>2]|0;sb(128,2,40470,g|0);m=o;o=0;if(m&1){f=10;break}o=0;sb(128,2,63797,h|0);m=o;o=0;if(m&1){f=10;break}o=0;yb(61,63799,37281,1205,40456);o=0;f=10;break}if(!(c[j>>2]|0)){i9(l);i=k;return}e=l+8|0;f=l+1|0;g=0;h=0;while(1){o=0;g=pb(37,b|0,d|0,g|0,((a[l>>0]&1)==0?f:c[e>>2]|0)|0)|0;m=o;o=0;if(m&1){f=9;break}h=h+1|0;if(h>>>0>=(c[j>>2]|0)>>>0){f=14;break}}if((f|0)==9){e=zc()|0;break}else if((f|0)==14){i9(l);i=k;return}}else f=10;while(0);if((f|0)==10)e=zc()|0;o=0;Ja(451,l|0);m=o;o=0;if(m&1){m=zc(0)|0;Di(m)}else Kc(e|0)}function xr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;t=i;i=i+96|0;s=t+64|0;r=t+56|0;q=t+48|0;l=t+40|0;n=t+32|0;m=t+24|0;k=t+16|0;j=t+8|0;h=t;u=t+72|0;p=t+68|0;g=b+40|0;Gr(u,c[g>>2]|0);v=a[u>>0]|0;do if(!(((v&1)==0?(v&255)>>>1:c[u+4>>2]|0)|0)){o=0;c[h>>2]=40529;sb(128,2,63728,h|0);v=o;o=0;if((!(v&1)?(o=0,c[j>>2]=f,sb(128,2,38577,j|0),v=o,o=0,!(v&1)):0)?(o=0,sb(128,2,63797,k|0),v=o,o=0,!(v&1)):0){o=0;yb(61,63799,37281,1240,40529);o=0}}else{g=c[g>>2]|0;o=0;g=pb(c[(c[g>>2]|0)+24>>2]|0,g|0,p|0,4,1)|0;v=o;o=0;if(!(v&1)){if((g|0)!=1){o=0;c[m>>2]=40529;sb(128,2,63728,m|0);v=o;o=0;if(v&1)break;o=0;c[n>>2]=f;sb(128,2,38622,n|0);v=o;o=0;if(v&1)break;o=0;sb(128,2,63797,l|0);v=o;o=0;if(v&1)break;o=0;yb(61,63799,37281,1248,40529);o=0;break}h=u+8|0;j=u+1|0;o=0;g=pb(34,d|0,((a[u>>0]&1)==0?j:c[h>>2]|0)|0,1,1)|0;v=o;o=0;if(!(v&1)){if(g){o=0;g=Aa(14,b|0,e|0,f|0,g|0,c[p>>2]|0)|0;v=o;o=0;if(v&1)break;i9(u);i=t;return g|0}o=0;c[q>>2]=40529;sb(128,2,63728,q|0);v=o;o=0;if((!(v&1)?(o=0,c[r>>2]=(a[u>>0]&1)==0?j:c[h>>2]|0,c[r+4>>2]=f,sb(128,2,40550,r|0),v=o,o=0,!(v&1)):0)?(o=0,sb(128,2,63797,s|0),v=o,o=0,!(v&1)):0){o=0;yb(61,63799,37281,1260,40529);o=0}}}}while(0);g=zc()|0;o=0;Ja(451,u|0);v=o;o=0;if(v&1){v=zc(0)|0;Di(v)}else Kc(g|0);return 0}function yr(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0;S=i;i=i+416|0;V=S+352|0;U=S+344|0;T=S+336|0;fa=S+328|0;ea=S+320|0;da=S+312|0;ca=S+304|0;ba=S+296|0;aa=S+288|0;$=S+280|0;_=S+272|0;Z=S+264|0;Y=S+256|0;X=S+248|0;W=S+240|0;I=S+232|0;H=S+224|0;G=S+216|0;F=S+208|0;E=S+200|0;D=S+192|0;C=S+184|0;B=S+176|0;A=S+168|0;z=S+160|0;y=S+152|0;x=S+144|0;w=S+136|0;v=S+128|0;u=S+120|0;t=S+112|0;s=S+104|0;r=S+96|0;m=S+88|0;l=S+80|0;k=S+72|0;j=S+64|0;h=S+56|0;g=S+48|0;d=S+24|0;b=S;n=S+408|0;f=S+404|0;e=S+400|0;q=S+384|0;J=S+376|0;P=S+372|0;Q=S+368|0;O=S+364|0;N=S+360|0;R=S+356|0;L=a+40|0;a=c[L>>2]|0;if((qg[c[(c[a>>2]|0)+24>>2]&63](a,n,4,1)|0)!=1){c[b>>2]=40621;Uv(2,63728,b);Uv(2,40634,S+8|0);Uv(2,63797,S+16|0);Jb(63799,37281,1424,40621)}a=c[n>>2]|0;if(!a){c[d>>2]=40621;Uv(2,63728,d);Uv(2,40671,S+32|0);Uv(2,63797,S+40|0);Jb(63799,37281,1429,40621)}d=_5(a>>>0>536870911?-1:a<<3)|0;a=d+(a<<3)|0;b=d;do{o=0;Ja(460,b|0);ha=o;o=0;if(ha&1){K=12;break}b=b+8|0}while((b|0)!=(a|0));if((K|0)==12){ha=zc()|0;a6(d);Kc(ha|0)}a:do if(c[n>>2]|0){b=0;while(1){ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,f,4,1)|0)!=1){K=11;break}ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,e,4,1)|0)!=1){K=14;break}c[d+(b<<3)>>2]=c[f>>2];c[d+(b<<3)+4>>2]=c[e>>2];b=b+1|0;a=c[n>>2]|0;if(b>>>0>=a>>>0){p=a;break a}}if((K|0)==11){c[g>>2]=40621;Uv(2,63728,g);Uv(2,40752,h);Uv(2,63797,j);Jb(63799,37281,1439,40621)}else if((K|0)==14){c[k>>2]=40621;Uv(2,63728,k);Uv(2,40781,l);Uv(2,63797,m);Jb(63799,37281,1445,40621)}}else p=0;while(0);h=Z5(80)|0;o=0;sb(133,q|0,d|0,p|0);ha=o;o=0;do if(!(ha&1)){o=0;na(163,h|0,q|0);ha=o;o=0;if(ha&1){a=zc()|0;o=0;Ja(438,q|0);ha=o;o=0;if(!(ha&1)){ga=a;break}ha=zc(0)|0;Di(ha)}o=0;Ja(438,q|0);ha=o;o=0;if(ha&1){ha=zc()|0;Kc(ha|0)}a6(d);ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,J,4,1)|0)!=1){c[r>>2]=40621;Uv(2,63728,r);Uv(2,40809,s);Uv(2,63797,t);Jb(63799,37281,1461,40621)}a=c[J>>2]|0;if(!a){c[u>>2]=40621;Uv(2,63728,u);Uv(2,40843,v);Uv(2,63797,w);Jb(63799,37281,1467,40621)}c[h+16>>2]=(a>>>0)/((OI(h)|0)>>>0)|0;ha=c[J>>2]|0;K=_5(ha)|0;c[h+20>>2]=K;w=c[L>>2]|0;ha=qg[c[(c[w>>2]|0)+24>>2]&63](w,K,1,ha)|0;if((ha|0)!=(c[J>>2]|0)){c[x>>2]=40621;Uv(2,63728,x);Uv(2,40901,y);Uv(2,63797,z);Jb(63799,37281,1477,40621)}ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,h+24|0,4,3)|0)!=3){c[A>>2]=40621;Uv(2,63728,A);Uv(2,40929,B);Uv(2,63797,C);Jb(63799,37281,1485,40621)}ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,h+36|0,4,3)|0)!=3){c[A>>2]=40621;Uv(2,63728,A);Uv(2,40929,B);Uv(2,63797,C);Jb(63799,37281,1485,40621)}ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,h+48|0,4,3)|0)!=3){c[D>>2]=40621;Uv(2,63728,D);Uv(2,40963,E);Uv(2,63797,F);Jb(63799,37281,1491,40621)}ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,h+60|0,4,1)|0)!=1){c[D>>2]=40621;Uv(2,63728,D);Uv(2,40963,E);Uv(2,63797,F);Jb(63799,37281,1491,40621)}ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,P,4,1)|0)!=1){c[G>>2]=40621;Uv(2,63728,G);Uv(2,41e3,H);Uv(2,63797,I);Jb(63799,37281,1500,40621)}if(!(c[P>>2]|0)){i=S;return h|0}d=h+72|0;e=h+76|0;f=h+68|0;a=0;b:while(1){ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,Q,4,1)|0)!=1){K=40;break}ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,O,4,1)|0)!=1){K=42;break}ha=c[L>>2]|0;if((qg[c[(c[ha>>2]|0)+24>>2]&63](ha,N,4,1)|0)!=1){K=44;break}g=Z5(16)|0;c[g+8>>2]=0;c[g+12>>2]=0;c[R>>2]=g;b=c[d>>2]|0;if((b|0)==(c[e>>2]|0))Qr(f,R);else{c[b>>2]=g;c[d>>2]=(c[d>>2]|0)+4}c[g>>2]=c[Q>>2];ha=c[O>>2]|0;c[g+4>>2]=ha;switch(ha|0){case 5121:{b=1;break}case 5123:{b=2;break}case 5125:{b=4;break}default:{K=51;break b}}c[g+8>>2]=((c[N>>2]|0)>>>0)/(b>>>0)|0;ha=c[N>>2]|0;c[g+12>>2]=_5(ha)|0;K=c[L>>2]|0;ha=qg[c[(c[K>>2]|0)+24>>2]&63](K,c[(c[R>>2]|0)+12>>2]|0,1,ha)|0;if((ha|0)!=(c[N>>2]|0)){K=53;break}a=a+1|0;if(a>>>0>=(c[P>>2]|0)>>>0){K=55;break}}if((K|0)==40){c[W>>2]=40621;Uv(2,63728,W);c[X>>2]=a;Uv(2,41032,X);Uv(2,63797,Y);Jb(63799,37281,1510,40621)}else if((K|0)==42){c[Z>>2]=40621;Uv(2,63728,Z);c[_>>2]=a;Uv(2,41091,_);Uv(2,63797,$);Jb(63799,37281,1516,40621)}else if((K|0)==44){c[aa>>2]=40621;Uv(2,63728,aa);c[ba>>2]=a;Uv(2,41148,ba);Uv(2,63797,ca);Jb(63799,37281,1522,40621)}else if((K|0)==51){c[da>>2]=40621;Uv(2,63728,da);c[ea>>2]=a;Uv(2,41209,ea);Uv(2,63797,fa);Jb(63799,37281,1546,40621)}else if((K|0)==53){c[T>>2]=40621;Uv(2,63728,T);c[U>>2]=a;Uv(2,41263,U);Uv(2,63797,V);Jb(63799,37281,1556,40621)}else if((K|0)==55){i=S;return h|0}}else ga=zc()|0;while(0);$5(h);ha=ga;Kc(ha|0);return 0}function zr(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;q=i;i=i+128|0;p=q+88|0;n=q+80|0;m=q+72|0;l=q+64|0;k=q+56|0;j=q+48|0;e=q+40|0;g=q+32|0;f=q+24|0;d=q;v=q+116|0;t=q+104|0;u=q+92|0;if(!(a[b>>0]|0)){c[d>>2]=40621;Uv(2,63728,d);Uv(2,41318,q+8|0);Uv(2,63797,q+16|0);Jb(63799,37281,1572,40621)}g9(v,b,F8(b)|0);d=A9(v,35,0)|0;a:do if((d|0)==-1){o=0;c[f>>2]=40621;sb(128,2,63728,f|0);w=o;o=0;if((!(w&1)?(o=0,c[g>>2]=b,sb(128,2,41351,g|0),w=o,o=0,!(w&1)):0)?(o=0,sb(128,2,63797,e|0),w=o,o=0,!(w&1)):0){o=0;yb(61,63799,37281,1581,40621);o=0;w=8}else w=8}else{o=0;fa(23,t|0,v|0,0,d|0,v|0);h=o;o=0;if(!(h&1)){o=0;fa(23,u|0,v|0,d+1|0,-1,v|0);h=o;o=0;b:do if(!(h&1)){f=t+8|0;g=t+1|0;o=0;h=qa(160,((a[t>>0]&1)==0?g:c[f>>2]|0)|0)|0;e=o;o=0;do if(!(e&1)){if(!h){o=0;c[j>>2]=40621;sb(128,2,63728,j|0);q=o;o=0;if(q&1)break;o=0;c[k>>2]=(a[t>>0]&1)==0?g:c[f>>2]|0;sb(128,2,41413,k|0);q=o;o=0;if(q&1)break;o=0;sb(128,2,63797,l|0);q=o;o=0;if(q&1)break;o=0;yb(61,63799,37281,1592,40621);o=0;break}d=u+8|0;b=u+1|0;o=0;e=Ha(41,h|0,((a[u>>0]&1)==0?b:c[d>>2]|0)|0,34)|0;l=o;o=0;if(!(l&1)){o=0;if(!e){c[m>>2]=40621;Uv(2,63728,m);q=o;o=0;if(q&1)break;q=(a[u>>0]&1)==0?b:c[d>>2]|0;o=0;c[n>>2]=(a[t>>0]&1)==0?g:c[f>>2]|0;c[n+4>>2]=q;sb(128,2,41441,n|0);q=o;o=0;if(q&1)break;o=0;sb(128,2,63797,p|0);q=o;o=0;if(q&1)break;o=0;yb(61,63799,37281,1600,40621);o=0;break}d=yr(h)|0;p=o;o=0;if(!(p&1)?(o=0,Ja(452,h|0),p=o,o=0,!(p&1)):0){o=0;Ja(451,u|0);w=o;o=0;if(w&1){w=17;break b}o=0;Ja(451,t|0);w=o;o=0;if(w&1){w=8;break a}i9(v);i=q;return d|0}}}while(0);d=zc()|0;o=0;Ja(451,u|0);u=o;o=0;if(u&1){u=zc(0)|0;Di(u)}else r=d}else w=17;while(0);if((w|0)==17)r=zc()|0;o=0;Ja(451,t|0);u=o;o=0;if(u&1){u=zc(0)|0;Di(u)}else s=r}else w=8}while(0);if((w|0)==8)s=zc()|0;o=0;Ja(451,v|0);w=o;o=0;if(w&1){w=zc(0)|0;Di(w)}else Kc(s|0);return 0}function Ar(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ba=0,ca=0;Z=i;i=i+368|0;W=Z+304|0;Y=Z+296|0;X=Z+288|0;S=Z+280|0;R=Z+272|0;Q=Z+264|0;N=Z+256|0;M=Z+248|0;L=Z+240|0;K=Z+232|0;J=Z+224|0;I=Z+216|0;H=Z+208|0;G=Z+200|0;F=Z+192|0;E=Z+184|0;D=Z+176|0;C=Z+168|0;B=Z+160|0;A=Z+152|0;z=Z+144|0;x=Z+136|0;w=Z+128|0;v=Z+120|0;u=Z+112|0;t=Z+104|0;s=Z+96|0;r=Z+88|0;q=Z+80|0;p=Z+72|0;n=Z+64|0;m=Z+56|0;l=Z+48|0;h=Z+40|0;k=Z+32|0;j=Z+24|0;f=Z+8|0;e=Z;ba=Z+344|0;g=Z+340|0;V=Z+336|0;aa=Z+324|0;U=Z+320|0;T=Z+316|0;O=Z+312|0;P=Z+308|0;if(!(fr(b,d,128)|0)){c[e>>2]=41500;Uv(2,63728,e);c[f>>2]=d;Uv(2,41509,f);Uv(2,63797,Z+16|0);Jb(63799,37281,1621,41500)}f=b+40|0;Gr(ba,c[f>>2]|0);e=a[ba>>0]|0;a:do if(!(((e&1)==0?(e&255)>>>1:c[ba+4>>2]|0)|0)){o=0;c[j>>2]=41500;sb(128,2,63728,j|0);ca=o;o=0;if((!(ca&1)?(o=0,c[k>>2]=d,sb(128,2,41543,k|0),ca=o,o=0,!(ca&1)):0)?(o=0,sb(128,2,63797,h|0),ca=o,o=0,!(ca&1)):0){o=0;yb(61,63799,37281,1629,41500);o=0;ca=8}else ca=8}else{e=c[f>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,g|0,4,1)|0;k=o;o=0;if(!(k&1)){if((e|0)!=1){o=0;c[l>>2]=41500;sb(128,2,63728,l|0);ca=o;o=0;if(ca&1){ca=8;break}o=0;c[m>>2]=d;sb(128,2,41585,m|0);ca=o;o=0;if(ca&1){ca=8;break}o=0;sb(128,2,63797,n|0);ca=o;o=0;if(ca&1){ca=8;break}o=0;yb(61,63799,37281,1637,41500);o=0;ca=8;break}e=c[f>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,V|0,4,1)|0;n=o;o=0;if(!(n&1)){if((e|0)!=1){o=0;c[p>>2]=41500;sb(128,2,63728,p|0);ca=o;o=0;if(ca&1){ca=8;break}o=0;c[q>>2]=d;sb(128,2,41621,q|0);ca=o;o=0;if(ca&1){ca=8;break}o=0;sb(128,2,63797,r|0);ca=o;o=0;if(ca&1){ca=8;break}o=0;yb(61,63799,37281,1642,41500);o=0;ca=8;break}o=0;na(158,aa|0,c[f>>2]|0);r=o;o=0;if(!(r&1)){e=c[f>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,U|0,4,1)|0;r=o;o=0;do if(!(r&1)){if((e|0)!=1){o=0;c[s>>2]=41500;sb(128,2,63728,s|0);Z=o;o=0;if(Z&1)break;o=0;c[t>>2]=d;sb(128,2,41656,t|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,u|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1653,41500);o=0;break}e=c[U>>2]|0;if(!e){o=0;c[v>>2]=41500;sb(128,2,63728,v|0);Z=o;o=0;if(Z&1)break;o=0;c[w>>2]=d;sb(128,2,41698,w|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,x|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1658,41500);o=0;break}o=0;h=qa(161,(e>>>0>178956970?-1:e*24|0)|0)|0;x=o;o=0;if(!(x&1)?(y=c[f>>2]|0,o=0,y=pb(c[(c[y>>2]|0)+24>>2]|0,y|0,h|0,24,e|0)|0,x=o,o=0,!(x&1)):0){if((y|0)!=(c[U>>2]|0)){o=0;c[z>>2]=41500;sb(128,2,63728,z|0);Z=o;o=0;if(Z&1)break;o=0;c[A>>2]=d;sb(128,2,41758,A|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,B|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1665,41500);o=0;break}e=c[f>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,T|0,4,1)|0;B=o;o=0;if(!(B&1)){if((e|0)!=1){o=0;c[C>>2]=41500;sb(128,2,63728,C|0);Z=o;o=0;if(Z&1)break;o=0;c[D>>2]=d;sb(128,2,41795,D|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,E|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1674,41500);o=0;break}e=c[f>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,O|0,4,1)|0;E=o;o=0;if(!(E&1)){if((e|0)!=1){o=0;c[F>>2]=41500;sb(128,2,63728,F|0);Z=o;o=0;if(Z&1)break;o=0;c[G>>2]=d;sb(128,2,41839,G|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,H|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1680,41500);o=0;break}e=c[f>>2]|0;o=0;e=pb(c[(c[e>>2]|0)+24>>2]|0,e|0,P|0,4,1)|0;H=o;o=0;if(!(H&1)){if((e|0)!=1){o=0;c[I>>2]=41500;sb(128,2,63728,I|0);Z=o;o=0;if(Z&1)break;o=0;c[J>>2]=d;sb(128,2,41884,J|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,K|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1686,41500);o=0;break}e=c[P>>2]|0;K=(e|0)==($(c[O>>2]|0,c[T>>2]|0)|0);o=0;if(!K){c[L>>2]=41500;Uv(2,63728,L);Z=o;o=0;if(Z&1)break;o=0;c[M>>2]=d;sb(128,2,41933,M|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,N|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1692,41500);o=0;break}g=_5(e)|0;N=o;o=0;if(N&1)break;N=c[f>>2]|0;o=0;e=pb(c[(c[N>>2]|0)+24>>2]|0,N|0,g|0,1,e|0)|0;N=o;o=0;if(N&1)break;if((e|0)!=(c[P>>2]|0)){o=0;c[Q>>2]=41500;sb(128,2,63728,Q|0);Z=o;o=0;if(Z&1)break;o=0;c[R>>2]=d;sb(128,2,41975,R|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,S|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1701,41500);o=0;break}o=0;f=Aa(15,6406,c[T>>2]|0,c[O>>2]|0,g|0,1)|0;T=o;o=0;if(T&1)break;a6(g);if(!f){o=0;c[X>>2]=41500;sb(128,2,63728,X|0);Z=o;o=0;if(Z&1)break;o=0;c[Y>>2]=d;sb(128,2,42018,Y|0);Z=o;o=0;if(Z&1)break;o=0;sb(128,2,63797,W|0);Z=o;o=0;if(Z&1)break;o=0;yb(61,63799,37281,1715,41500);o=0;break}o=0;e=oa(5,((a[ba>>0]&1)==0?ba+1|0:c[ba+8>>2]|0)|0,0,c[V>>2]|0,h|0,c[U>>2]|0,f|0)|0;Y=o;o=0;if(Y&1)break;a6(h);o=0;Ja(452,f|0);Y=o;o=0;if(Y&1)break;if(e){o=0;cb(58,e+8|0,b+8|0)|0;b=o;o=0;if(b&1)break;o=0;cb(61,e+20|0,d|0)|0;b=o;o=0;if(b&1)break}o=0;Ja(451,aa|0);ca=o;o=0;if(ca&1){ca=8;break a}i9(ba);i=Z;return e|0}}}}}while(0);e=zc()|0;o=0;Ja(451,aa|0);aa=o;o=0;if(aa&1){aa=zc(0)|0;Di(aa)}else _=e}else ca=8}else ca=8}else ca=8}while(0);if((ca|0)==8)_=zc()|0;o=0;Ja(451,ba|0);ca=o;o=0;if(ca&1){ca=zc(0)|0;Di(ca)}else Kc(_|0);return 0}function Br(a){a=a|0;return c[a+32>>2]|0}function Cr(b,d){b=b|0;d=d|0;var e=0;if((c[b+32>>2]|0)>>>0<=d>>>0){d=0;return d|0}b=c[b+36>>2]|0;e=b+(d*20|0)|0;if(!(a[e>>0]&1)){d=e+1|0;return d|0}else{d=c[b+(d*20|0)+8>>2]|0;return d|0}return 0}function Dr(a,b){a=a|0;b=b|0;var d=0,e=0;Rr(a,b);c[a+12>>2]=c[b+12>>2];c[a+16>>2]=0;c[a+20>>2]=0;d=a+24|0;o=0;Ja(461,d|0);b=o;o=0;if(!(b&1)){o=0;Ja(441,a+48|0);b=o;o=0;if(!(b&1)){c[a+68>>2]=0;c[a+72>>2]=0;c[a+76>>2]=0;return}b=zc()|0;o=0;Ja(462,d|0);d=o;o=0;if(d&1){d=zc(0)|0;Di(d)}else e=b}else e=zc()|0;o=0;Ja(438,a|0);a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else Kc(e|0)}function Er(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0;b=a+20|0;d=c[b>>2]|0;if(d)a6(d);c[b>>2]=0;h=a+72|0;d=c[h>>2]|0;g=a+68|0;b=c[g>>2]|0;if((d|0)==(b|0)){b=d;e=d}else{f=0;do{d=c[b+(f<<2)>>2]|0;if(d){b=c[d+12>>2]|0;if(b)a6(b);$5(d);b=c[g>>2]|0}c[b+(f<<2)>>2]=0;f=f+1|0;e=c[h>>2]|0;b=c[g>>2]|0}while(f>>>0<e-b>>2>>>0)}d=b;if(b){if((e|0)!=(b|0))c[h>>2]=e+(~((e+-4-d|0)>>>2)<<2);$5(b)}o=0;Ja(442,a+48|0);h=o;o=0;do if(h&1){b=zc()|0;o=0;Ja(462,a+24|0);h=o;o=0;if(h&1){h=zc(0)|0;Di(h)}else i=b}else{o=0;Ja(462,a+24|0);i=o;o=0;if(i&1){i=zc()|0;break}else{LI(a);return}}while(0);o=0;Ja(438,a|0);a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else Kc(i|0)}function Fr(){c[1925]=0;c[1926]=0;c[1927]=0;hc(463,7700,n|0)|0;return}function Gr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+64|0;h=m+40|0;k=m+32|0;j=m+24|0;e=m;g=m+56|0;n=m+44|0;if((qg[c[(c[d>>2]|0)+24>>2]&63](d,g,4,1)|0)!=1){c[e>>2]=42442;Uv(2,63728,e);Uv(2,42453,m+8|0);Uv(2,63797,m+16|0);Jb(63799,37281,137,42442)};c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;e=c[g>>2]|0;if(e){o=0;sb(134,n|0,e|0,0);e=o;o=0;if(!(e&1)?(o=0,f=pb(c[(c[d>>2]|0)+24>>2]|0,d|0,((a[n>>0]&1)==0?n+1|0:c[n+8>>2]|0)|0,1,c[g>>2]|0)|0,d=o,o=0,!(d&1)):0)if((f|0)!=(c[g>>2]|0)){o=0;c[j>>2]=42442;sb(128,2,63728,j|0);j=o;o=0;if((!(j&1)?(o=0,sb(128,2,42506,k|0),k=o,o=0,!(k&1)):0)?(o=0,sb(128,2,63797,h|0),k=o,o=0,!(k&1)):0){o=0;yb(61,63799,37281,150,42442);o=0}}else l=12}else l=12;if((l|0)==12?(o=0,na(156,b|0,n|0),l=o,o=0,!(l&1)):0){i9(n);i=m;return}e=zc()|0;o=0;Ja(451,n|0);n=o;o=0;if(n&1){n=zc(0)|0;Di(n)}else Kc(e|0)}function Hr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;f=b+4|0;e=c[f>>2]|0;if(e){g=a[d>>0]|0;b=(g&1)==0;g=b?(g&255)>>>1:c[d+4>>2]|0;d=b?d+1|0:c[d+8>>2]|0;b=f;a:do{while(1){h=e+16|0;i=a[h>>0]|0;j=(i&1)==0;i=j?(i&255)>>>1:c[e+20>>2]|0;h=u8(j?h+1|0:c[e+24>>2]|0,d,g>>>0<i>>>0?g:i)|0;if((((h|0)==0?(i>>>0<g>>>0?-2147483648:0):h)|0)>=0){b=e;break}e=c[e+4>>2]|0;if(!e)break a}e=c[b>>2]|0}while((e|0)!=0);if((b|0)!=(f|0)?(j=b+16|0,i=a[j>>0]|0,h=(i&1)==0,i=h?(i&255)>>>1:c[b+20>>2]|0,j=u8(d,h?j+1|0:c[b+24>>2]|0,i>>>0<g>>>0?i:g)|0,(((j|0)==0?(g>>>0<i>>>0?-2147483648:0):j)|0)>=0):0){j=b;return j|0}}j=f;return j|0}function Ir(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;i=i+16|0;g=k;h=Ur(d,g,e)|0;f=c[h>>2]|0;if(f){j=0;d=f;c[b>>2]=d;d=b+4|0;a[d>>0]=j;i=k;return}j=Z5(32)|0;o=0;na(156,j+16|0,e|0);f=o;o=0;if(f&1){k=zc()|0;$5(j);Kc(k|0)}c[j+28>>2]=c[e+12>>2];f=c[g>>2]|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=f;c[h>>2]=j;f=c[c[d>>2]>>2]|0;if(!f)f=j;else{c[d>>2]=f;f=c[h>>2]|0}Vr(c[d+4>>2]|0,f);h=d+8|0;c[h>>2]=(c[h>>2]|0)+1;h=1;d=j;c[b>>2]=d;d=b+4|0;a[d>>0]=h;i=k;return}function Jr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=a+4|0;d=c[a>>2]|0;e=d;h=((c[l>>2]|0)-e>>2)+1|0;if(h>>>0>1073741823){X5(a);e=c[a>>2]|0;d=e}k=a+8|0;g=d;f=(c[k>>2]|0)-g|0;if(f>>2>>>0<536870911){f=f>>1;f=f>>>0<h>>>0?h:f;h=(c[l>>2]|0)-g|0;g=h>>2;if(!f){j=0;i=0;f=h}else m=6}else{h=(c[l>>2]|0)-g|0;f=1073741823;g=h>>2;m=6}if((m|0)==6){j=f;i=Z5(f<<2)|0;f=h}c[i+(g<<2)>>2]=c[b>>2];K9(i|0,d|0,f|0)|0;c[a>>2]=i;c[l>>2]=i+(g+1<<2);c[k>>2]=i+(j<<2);if(!e)return;$5(e);return}function Kr(a,b){a=a|0;b=b|0;if(!b)return;Kr(a,c[b>>2]|0);Kr(a,c[b+4>>2]|0);o=0;Ja(451,b+16|0);a=o;o=0;if(a&1){a=zc()|0;Lc(a|0)}$5(b);return}function Lr(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+48|0;m=p+40|0;o=p+32|0;n=p+24|0;f=p;l=a+40|0;j=c[l>>2]|0;if((qg[c[(c[j>>2]|0)+24>>2]&63](j,b,4,1)|0)!=1){c[f>>2]=42058;Uv(2,63728,f);Uv(2,42213,p+8|0);Uv(2,63797,p+16|0);Jb(63799,37281,115,42058)}a=c[b>>2]|0;if(!((d|0)!=0&(a|0)!=0)){i=p;return 1}g=d+4|0;h=c[g>>2]|0;f=c[d>>2]|0;j=h-f>>2;if(a>>>0<=j>>>0){if(a>>>0<j>>>0?(k=f+(a<<2)|0,(h|0)!=(k|0)):0)c[g>>2]=h+(~((h+-4-k|0)>>>2)<<2)}else{Tr(d,a-j|0);f=c[d>>2]|0;a=c[b>>2]|0}l=c[l>>2]|0;e=qg[c[(c[l>>2]|0)+24>>2]&63](l,f,e,a)|0;if((e|0)==(c[b>>2]|0)){i=p;return 1}else{c[n>>2]=42058;Uv(2,63728,n);Uv(2,42334,o);Uv(2,63797,m);Jb(63799,37281,123,42058)}return 0}function Mr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+48|0;l=o+40|0;n=o+32|0;m=o+24|0;e=o;k=a+40|0;h=c[k>>2]|0;if((qg[c[(c[h>>2]|0)+24>>2]&63](h,b,4,1)|0)!=1){c[e>>2]=42058;Uv(2,63728,e);Uv(2,42068,o+8|0);Uv(2,63797,o+16|0);Jb(63799,37281,91,42058)}a=c[b>>2]|0;if(!((d|0)!=0&(a|0)!=0)){i=o;return 1}f=d+4|0;g=c[f>>2]|0;e=c[d>>2]|0;h=g-e>>2;if(a>>>0<=h>>>0){if(a>>>0<h>>>0?(j=e+(a<<2)|0,(g|0)!=(j|0)):0)c[f>>2]=g+(~((g+-4-j|0)>>>2)<<2)}else{Sr(d,a-h|0);e=c[d>>2]|0;a=c[b>>2]|0}k=c[k>>2]|0;k=qg[c[(c[k>>2]|0)+24>>2]&63](k,e,4,a)|0;if((k|0)==(c[b>>2]|0)){i=o;return 1}else{c[m>>2]=42058;Uv(2,63728,m);Uv(2,42147,n);Uv(2,63797,l);Jb(63799,37281,99,42058)}return 0}function Nr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=a+4|0;d=c[a>>2]|0;f=(((c[k>>2]|0)-d|0)/12|0)+1|0;if(f>>>0>357913941){X5(a);d=c[a>>2]|0}l=a+8|0;e=((c[l>>2]|0)-d|0)/12|0;if(e>>>0<178956970){e=e<<1;e=e>>>0<f>>>0?f:e;d=((c[k>>2]|0)-d|0)/12|0;if(!e){f=0;j=0;e=d}else m=6}else{e=357913941;d=((c[k>>2]|0)-d|0)/12|0;m=6}if((m|0)==6){f=e;j=Z5(e*12|0)|0;e=d}g=j+(e*12|0)|0;d=g;h=j+(f*12|0)|0;o=0;na(156,g|0,b|0);i=o;o=0;a:do if(i&1){f=zc()|0;e=d}else{i=j+((e+1|0)*12|0)|0;b=c[a>>2]|0;f=c[k>>2]|0;do if((f|0)!=(b|0)){e=g;while(1){f=f+-12|0;o=0;na(156,e+-12|0,f|0);m=o;o=0;if(m&1){m=20;break}e=d+-12|0;d=e;if((f|0)==(b|0)){m=12;break}}if((m|0)==12){e=a;g=k;b=c[a>>2]|0;f=c[k>>2]|0;break}else if((m|0)==20){f=zc()|0;e=d;d=i;break a}}else{e=a;g=k}while(0);c[e>>2]=d;c[g>>2]=i;c[l>>2]=h;e=b;d=f;while(1){if((d|0)==(e|0))break;d=d+-12|0;o=0;Ja(451,d|0);l=o;o=0;if(l&1){m=16;break}}if((m|0)==16){m=zc()|0;Lc(m|0)}if(!b)return;$5(b);return}while(0);while(1){if((d|0)==(e|0))break;d=d+-12|0;o=0;Ja(451,d|0);l=o;o=0;if(l&1){m=25;break}}if((m|0)==25){m=zc()|0;Lc(m|0)}if(!j)Kc(f|0);$5(j);Kc(f|0)}function Or(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=a+4|0;d=c[a>>2]|0;f=((c[k>>2]|0)-d>>6)+1|0;if(f>>>0>67108863){X5(a);d=c[a>>2]|0}l=a+8|0;e=(c[l>>2]|0)-d|0;if(e>>6>>>0<33554431){e=e>>5;e=e>>>0<f>>>0?f:e;d=(c[k>>2]|0)-d>>6;if(!e){f=0;j=0;e=d}else m=6}else{e=67108863;d=(c[k>>2]|0)-d>>6;m=6}if((m|0)==6){f=e;j=Z5(e<<6)|0;e=d}g=j+(e<<6)|0;d=g;h=j+(f<<6)|0;o=0;na(164,g|0,b|0);i=o;o=0;a:do if(i&1){f=zc()|0;e=d}else{i=j+(e+1<<6)|0;b=c[a>>2]|0;f=c[k>>2]|0;do if((f|0)!=(b|0)){e=g;while(1){f=f+-64|0;o=0;na(164,e+-64|0,f|0);m=o;o=0;if(m&1){m=20;break}e=d+-64|0;d=e;if((f|0)==(b|0)){m=12;break}}if((m|0)==12){e=a;g=k;b=c[a>>2]|0;f=c[k>>2]|0;break}else if((m|0)==20){f=zc()|0;e=d;d=i;break a}}else{e=a;g=k}while(0);c[e>>2]=d;c[g>>2]=i;c[l>>2]=h;e=b;d=f;while(1){if((d|0)==(e|0))break;d=d+-64|0;o=0;Ja(440,d|0);l=o;o=0;if(l&1){m=16;break}}if((m|0)==16){m=zc()|0;Lc(m|0)}if(!b)return;$5(b);return}while(0);while(1){if((d|0)==(e|0))break;d=d+-64|0;o=0;Ja(440,d|0);l=o;o=0;if(l&1){m=25;break}}if((m|0)==25){m=zc()|0;Lc(m|0)}if(!j)Kc(f|0);$5(j);Kc(f|0)}function Pr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=a+4|0;d=c[a>>2]|0;e=d;h=((c[l>>2]|0)-e>>2)+1|0;if(h>>>0>1073741823){X5(a);e=c[a>>2]|0;d=e}k=a+8|0;g=d;f=(c[k>>2]|0)-g|0;if(f>>2>>>0<536870911){f=f>>1;f=f>>>0<h>>>0?h:f;h=(c[l>>2]|0)-g|0;g=h>>2;if(!f){j=0;i=0;f=h}else m=6}else{h=(c[l>>2]|0)-g|0;f=1073741823;g=h>>2;m=6}if((m|0)==6){j=f;i=Z5(f<<2)|0;f=h}c[i+(g<<2)>>2]=c[b>>2];K9(i|0,d|0,f|0)|0;c[a>>2]=i;c[l>>2]=i+(g+1<<2);c[k>>2]=i+(j<<2);if(!e)return;$5(e);return}
function SV(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;G=i;i=i+288|0;r=G+208|0;z=G+48|0;A=G+192|0;B=G+176|0;C=G+160|0;D=G+144|0;F=G;E=G+256|0;c[r>>2]=c[d>>2];c[r+4>>2]=c[d+4>>2];c[r+8>>2]=c[d+8>>2];c[r+12>>2]=c[d+12>>2];m=r+16|0;c[m>>2]=c[e>>2];c[m+4>>2]=c[e+4>>2];c[m+8>>2]=c[e+8>>2];c[m+12>>2]=c[e+12>>2];d=r+32|0;c[d>>2]=c[f>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];v=c[k>>2]|0;w=c[k+4>>2]|0;x=c[k+8>>2]|0;y=c[k+16>>2]|0;u=l&1;s=c[k+12>>2]|0;q=c[k+20>>2]|0;c[F>>2]=c[r>>2];c[F+4>>2]=c[r+4>>2];c[F+8>>2]=c[r+8>>2];c[F+12>>2]=c[r+12>>2];r=F+16|0;c[r>>2]=c[m>>2];c[r+4>>2]=c[m+4>>2];c[r+8>>2]=c[m+8>>2];c[r+12>>2]=c[m+12>>2];r=F+32|0;c[r>>2]=c[d>>2];c[r+4>>2]=c[d+4>>2];c[r+8>>2]=c[d+8>>2];c[r+12>>2]=c[d+12>>2];r=b+136|0;d=c[r>>2]|0;m=b+140|0;if((d|0)==(c[m>>2]|0)?(t=(d|0)!=0?d<<1:1,(d|0)<(t|0)):0){if(!t)k=0;else{k=l5(t*284|0,16)|0;d=c[r>>2]|0}l=b+144|0;if((d|0)>0){e=0;do{f=c[l>>2]|0;n=k+(e*284|0)|0;o=f+(e*284|0)|0;p=n+92|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));n=k+(e*284|0)+92|0;o=f+(e*284|0)+92|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=k+(e*284|0)+108|0;o=f+(e*284|0)+108|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=k+(e*284|0)+124|0;o=f+(e*284|0)+124|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=k+(e*284|0)+140|0;o=f+(e*284|0)+140|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=k+(e*284|0)+156|0;o=f+(e*284|0)+156|0;p=n+128|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));e=e+1|0}while((e|0)!=(d|0))}f=c[l>>2]|0;d=b+148|0;if(f){if(a[d>>0]|0)m5(f);c[l>>2]=0}a[d>>0]=1;c[l>>2]=k;c[m>>2]=t;d=c[r>>2]|0}e=b+144|0;f=c[e>>2]|0;n=f+(d*284|0)|0;o=z;p=n+92|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));n=f+(d*284|0)+92|0;c[n>>2]=c[A>>2];c[n+4>>2]=c[A+4>>2];c[n+8>>2]=c[A+8>>2];c[n+12>>2]=c[A+12>>2];n=f+(d*284|0)+108|0;c[n>>2]=c[B>>2];c[n+4>>2]=c[B+4>>2];c[n+8>>2]=c[B+8>>2];c[n+12>>2]=c[B+12>>2];n=f+(d*284|0)+124|0;c[n>>2]=c[C>>2];c[n+4>>2]=c[C+4>>2];c[n+8>>2]=c[C+8>>2];c[n+12>>2]=c[C+12>>2];n=f+(d*284|0)+140|0;c[n>>2]=c[D>>2];c[n+4>>2]=c[D+4>>2];c[n+8>>2]=c[D+8>>2];c[n+12>>2]=c[D+12>>2];d=f+(d*284|0)+156|0;n=d;o=F;p=n+48|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));g[d+48>>2]=h;c[d+52>>2]=s;g[d+56>>2]=j;c[d+60>>2]=v;c[d+64>>2]=w;c[d+68>>2]=x;c[d+72>>2]=y;g[d+76>>2]=0.0;g[d+80>>2]=0.0;g[d+84>>2]=0.0;g[d+88>>2]=.10000000149011612;c[d+92>>2]=q;g[d+96>>2]=0.0;g[d+100>>2]=0.0;a[d+104>>0]=u;n=d+105|0;o=E;p=n+23|0;do{a[n>>0]=a[o>>0]|0;n=n+1|0;o=o+1|0}while((n|0)<(p|0));F=c[r>>2]|0;c[r>>2]=F+1;F=(c[e>>2]|0)+(F*284|0)|0;TV(b,F,0);UV(b,(c[r>>2]|0)+-1|0,0);i=G;return F|0}function TV(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;j=i;i=i+64|0;h=j;a[d+84>>0]=0;b=c[b+116>>2]|0;k=b+4|0;c[h>>2]=c[k>>2];c[h+4>>2]=c[k+4>>2];c[h+8>>2]=c[k+8>>2];c[h+12>>2]=c[k+12>>2];k=h+16|0;l=b+20|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=h+32|0;l=b+36|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=h+48|0;l=b+52|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];if(e?(f=c[b+480>>2]|0,(f|0)!=0):0)of[c[(c[f>>2]|0)+8>>2]&511](f,h);z=+g[d+156>>2];x=+g[h>>2];y=+g[d+160>>2];w=+g[h+4>>2];r=+g[d+164>>2];v=+g[h+8>>2];u=+g[h+16>>2];t=+g[h+20>>2];s=+g[h+24>>2];q=+g[h+32>>2];o=+g[h+36>>2];m=+g[h+40>>2];p=z*u+y*t+r*s+ +g[h+52>>2];n=z*q+y*o+r*m+ +g[h+56>>2];g[d+36>>2]=z*x+y*w+r*v+ +g[h+48>>2];g[d+40>>2]=p;g[d+44>>2]=n;g[d+48>>2]=0.0;n=+g[d+172>>2];p=+g[d+176>>2];r=+g[d+180>>2];g[d+52>>2]=x*n+w*p+v*r;g[d+56>>2]=n*u+p*t+r*s;g[d+60>>2]=n*q+p*o+r*m;g[d+64>>2]=0.0;r=+g[d+188>>2];p=+g[d+192>>2];n=+g[d+196>>2];g[d+68>>2]=x*r+w*p+v*n;g[d+72>>2]=r*u+p*t+n*s;g[d+76>>2]=r*q+p*o+n*m;g[d+80>>2]=0.0;i=j;return}function UV(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0;e=c[a+144>>2]|0;TV(a,e+(b*284|0)|0,d);a=e+(b*284|0)+52|0;k=+g[a>>2];f=-k;j=e+(b*284|0)+56|0;r=+g[j>>2];i=-r;d=e+(b*284|0)+60|0;t=+g[d>>2];l=-t;K=e+(b*284|0)+76|0;h=+g[K>>2];L=e+(b*284|0)+72|0;q=+g[L>>2];o=h*i-q*l;M=e+(b*284|0)+68|0;s=+g[M>>2];n=s*l-h*f;p=q*f-s*i;J=1.0/+P(+(p*p+(o*o+n*n)));o=o*J;n=J*n;p=J*p;J=+g[e+(b*284|0)+232>>2]*.5;t=+S(+J)/+P(+(k*k+r*r+t*t));r=t*f;k=t*i;t=t*l;J=+R(+J);I=2.0/(J*J+(t*t+(r*r+k*k)));G=r*I;z=k*I;I=t*I;B=J*G;D=J*z;J=J*I;G=r*G;v=r*z;r=r*I;z=k*z;k=k*I;I=t*I;t=1.0-(z+I);u=v-J;y=r+D;J=v+J;I=1.0-(G+I);v=k-B;D=r-D;B=k+B;z=1.0-(G+z);G=+g[e+(b*284|0)+236>>2]*-.5;k=+S(+G)/+P(+(h*h+(q*q+s*s)));s=s*k;q=q*k;k=h*k;G=+R(+G);h=2.0/(G*G+(k*k+(s*s+q*q)));r=s*h;m=q*h;h=k*h;F=G*r;H=G*m;G=G*h;r=s*r;A=s*m;s=s*h;m=q*m;q=q*h;h=k*h;k=1.0-(m+h);E=A-G;C=s+H;G=A+G;h=1.0-(r+h);A=q-F;H=s-H;F=q+F;m=1.0-(r+m);r=+g[M>>2];q=+g[L>>2];s=+g[K>>2];x=y*H+(u*G+t*k);w=y*F+(t*E+u*h);y=t*C+u*A+y*m;u=v*H+(I*G+J*k);t=v*F+(J*E+I*h);v=J*C+I*A+v*m;k=z*H+(B*G+D*k);h=z*F+(D*E+B*h);m=D*C+B*A+z*m;g[e+(b*284|0)+92>>2]=s*y+(r*x+q*w);g[e+(b*284|0)+96>>2]=p*y+(o*x+n*w);g[e+(b*284|0)+100>>2]=y*l+(x*f+w*i);g[e+(b*284|0)+104>>2]=0.0;g[e+(b*284|0)+108>>2]=s*v+(r*u+q*t);g[e+(b*284|0)+112>>2]=p*v+(o*u+n*t);g[e+(b*284|0)+116>>2]=v*l+(u*f+t*i);g[e+(b*284|0)+120>>2]=0.0;g[e+(b*284|0)+124>>2]=s*m+(r*k+q*h);g[e+(b*284|0)+128>>2]=p*m+(o*k+n*h);g[e+(b*284|0)+132>>2]=m*l+(k*f+h*i);g[e+(b*284|0)+136>>2]=0.0;i=+g[e+(b*284|0)+32>>2];h=i*+g[j>>2]+ +g[e+(b*284|0)+40>>2];f=i*+g[d>>2]+ +g[e+(b*284|0)+44>>2];g[e+(b*284|0)+140>>2]=+g[a>>2]*i+ +g[e+(b*284|0)+36>>2];g[e+(b*284|0)+144>>2]=h;g[e+(b*284|0)+148>>2]=f;g[e+(b*284|0)+152>>2]=0.0;return}function VV(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0,C=0;B=i;i=i+48|0;q=B;TV(b,d,0);f=+aW(d);n=d+212|0;f=f+ +g[n>>2];v=d+52|0;w=d+56|0;u=d+60|0;C=d+36|0;x=d+16|0;t=f*+g[w>>2]+ +g[d+40>>2];A=f*+g[u>>2]+ +g[d+44>>2];g[d+16>>2]=+g[v>>2]*f+ +g[C>>2];y=d+20|0;g[y>>2]=t;z=d+24|0;g[z>>2]=A;g[d+28>>2]=0.0;e=q+32|0;g[e>>2]=-1.0;l=c[b+100>>2]|0;C=qg[c[(c[l>>2]|0)+8>>2]&63](l,C,x,q)|0;l=d+88|0;c[l>>2]=0;if(!C){g[d+32>>2]=+aW(d);g[d+272>>2]=0.0;t=-+g[w>>2];A=-+g[u>>2];g[d>>2]=-+g[v>>2];g[d+4>>2]=t;g[d+8>>2]=A;g[d+12>>2]=0.0;g[d+268>>2]=1.0;A=-1.0;i=B;return +A}A=f*+g[e>>2];e=q+16|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];a[d+84>>0]=1;OV()|0;c[l>>2]=21700;e=d+32|0;g[e>>2]=A-+g[n>>2];f=+aW(d);C=d+208|0;f=f-+g[C>>2]*.009999999776482582;j=+aW(d);j=j+ +g[C>>2]*.009999999776482582;h=+g[e>>2];if(h<f)g[e>>2]=f;else f=h;if(f>j)g[e>>2]=j;c[x>>2]=c[q>>2];c[x+4>>2]=c[q+4>>2];c[x+8>>2]=c[q+8>>2];c[x+12>>2]=c[q+12>>2];r=+g[d>>2];s=+g[d+4>>2];t=+g[d+8>>2];p=r*+g[v>>2]+s*+g[w>>2]+t*+g[u>>2];e=c[b+116>>2]|0;o=+g[x>>2]-+g[e+52>>2];m=+g[y>>2]-+g[e+56>>2];f=+g[z>>2]-+g[e+60>>2];h=+g[e+332>>2];j=+g[e+336>>2];k=+g[e+328>>2];if(!(p>=-.10000000149011612)){p=-1.0/p;g[d+272>>2]=p*(r*(h*f-m*j+ +g[e+312>>2])+s*(o*j-f*k+ +g[e+316>>2])+t*(m*k-o*h+ +g[e+320>>2]));g[d+268>>2]=p;i=B;return +A}else{g[d+272>>2]=0.0;g[d+268>>2]=10.0;i=B;return +A}return 0.0}function WV(b,d){b=b|0;d=+d;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;A=i;i=i+32|0;w=A+16|0;x=A;v=b+136|0;e=c[v>>2]|0;if((e|0)>0){f=0;do{UV(b,f,0);f=f+1|0;e=c[v>>2]|0}while((f|0)<(e|0))}u=b+116|0;n=c[u>>2]|0;l=n+312|0;s=+g[l>>2];m=n+316|0;t=+g[m>>2];y=n+320|0;h=+g[y>>2];h=+P(+(s*s+t*t+h*h))*3.5999999046325684;f=b+112|0;g[f>>2]=h;z=b+128|0;o=c[z>>2]|0;if(+g[n+4+(o<<2)>>2]*+g[l>>2]+ +g[n+20+(o<<2)>>2]*+g[m>>2]+ +g[n+36+(o<<2)>>2]*+g[y>>2]<0.0)g[f>>2]=-h;if((e|0)>0){f=b+144|0;j=0;do{+VV(b,(c[f>>2]|0)+(j*284|0)|0);j=j+1|0;e=c[v>>2]|0}while((j|0)<(e|0));h=1.0/+g[(c[u>>2]|0)+344>>2];if((e|0)>0){f=b+144|0;j=0;do{e=c[f>>2]|0;if(a[e+(j*284|0)+84>>0]|0){s=+aW(e+(j*284|0)|0);t=+g[e+(j*284|0)+272>>2];t=h*(+g[e+(j*284|0)+216>>2]*(s-+g[e+(j*284|0)+32>>2])*+g[e+(j*284|0)+268>>2]-t*+g[(t<0.0?e+(j*284|0)+220|0:e+(j*284|0)+224|0)>>2]);e=e+(j*284|0)+276|0;g[e>>2]=t;if(t<0.0)g[e>>2]=0.0}else g[e+(j*284|0)+276>>2]=0.0;j=j+1|0;e=c[v>>2]|0}while((j|0)<(e|0));if((e|0)>0){e=b+144|0;f=w+4|0;j=w+8|0;k=w+12|0;l=x+4|0;m=x+8|0;n=x+12|0;o=0;do{B=c[e>>2]|0;r=+g[B+(o*284|0)+276>>2];t=+g[B+(o*284|0)+248>>2];r=r>t?t:r;t=r*+g[B+(o*284|0)+4>>2]*d;s=r*+g[B+(o*284|0)+8>>2]*d;g[w>>2]=+g[B+(o*284|0)>>2]*r*d;g[f>>2]=t;g[j>>2]=s;g[k>>2]=0.0;y=c[u>>2]|0;s=+g[B+(o*284|0)+20>>2]-+g[y+56>>2];t=+g[B+(o*284|0)+24>>2]-+g[y+60>>2];g[x>>2]=+g[B+(o*284|0)+16>>2]-+g[y+52>>2];g[l>>2]=s;g[m>>2]=t;g[n>>2]=0.0;vC(y,w,x);o=o+1|0}while((o|0)<(c[v>>2]|0))}}}jf[c[(c[b>>2]|0)+20>>2]&31](b,d);y=c[v>>2]|0;if((y|0)<=0){i=A;return}b=c[b+144>>2]|0;f=c[u>>2]|0;j=f+52|0;k=f+56|0;l=f+60|0;m=f+332|0;n=f+336|0;o=f+328|0;u=f+320|0;v=f+316|0;w=f+312|0;x=0;do{h=+g[b+(x*284|0)+36>>2]-+g[j>>2];p=+g[b+(x*284|0)+40>>2]-+g[k>>2];q=+g[b+(x*284|0)+44>>2]-+g[l>>2];r=+g[m>>2];s=+g[n>>2];t=+g[o>>2];if(!(a[b+(x*284|0)+84>>0]|0)){e=b+(x*284|0)+240|0;h=+g[e>>2];B=b+(x*284|0)+236|0;g[B>>2]=h+ +g[B>>2]}else{e=c[z>>2]|0;G=+g[f+4+(e<<2)>>2];E=+g[f+20+(e<<2)>>2];I=+g[f+36+(e<<2)>>2];F=+g[b+(x*284|0)>>2];D=+g[b+(x*284|0)+4>>2];H=+g[b+(x*284|0)+8>>2];C=G*F+E*D+I*H;h=((p*t-h*r+ +g[u>>2])*(I-H*C)+((r*q-p*s+ +g[w>>2])*(G-F*C)+(h*s-q*t+ +g[v>>2])*(E-D*C)))*d/+g[b+(x*284|0)+212>>2];e=b+(x*284|0)+240|0;g[e>>2]=h;B=b+(x*284|0)+236|0;g[B>>2]=h+ +g[B>>2]}g[e>>2]=h*.9900000095367432;x=x+1|0}while((x|0)<(y|0));i=A;return}function XV(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0,R=0,S=0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0;S=i;i=i+160|0;m=S+144|0;o=S+80|0;D=S+96|0;O=S+64|0;L=S+48|0;Q=S+32|0;R=S+16|0;M=S;N=b+136|0;p=c[N>>2]|0;if(!p){i=S;return}n=b+8|0;e=c[n>>2]|0;if((e|0)<(p|0)){l=b+12|0;if((c[l>>2]|0)<(p|0)){k=l5(p<<4,16)|0;h=c[n>>2]|0;f=b+16|0;if((h|0)>0){j=0;do{K=k+(j<<4)|0;J=(c[f>>2]|0)+(j<<4)|0;c[K>>2]=c[J>>2];c[K+4>>2]=c[J+4>>2];c[K+8>>2]=c[J+8>>2];c[K+12>>2]=c[J+12>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[f>>2]|0;h=b+20|0;if(j){if(a[h>>0]|0)m5(j);c[f>>2]=0}a[h>>0]=1;c[f>>2]=k;c[l>>2]=p}else f=b+16|0;do{K=(c[f>>2]|0)+(e<<4)|0;c[K>>2]=c[m>>2];c[K+4>>2]=c[m+4>>2];c[K+8>>2]=c[m+8>>2];c[K+12>>2]=c[m+12>>2];e=e+1|0}while((e|0)!=(p|0))}c[n>>2]=p;m=b+28|0;e=c[m>>2]|0;if((e|0)<(p|0)){k=b+32|0;if((c[k>>2]|0)<(p|0)){l=l5(p<<4,16)|0;h=c[m>>2]|0;f=b+36|0;if((h|0)>0){j=0;do{K=l+(j<<4)|0;J=(c[f>>2]|0)+(j<<4)|0;c[K>>2]=c[J>>2];c[K+4>>2]=c[J+4>>2];c[K+8>>2]=c[J+8>>2];c[K+12>>2]=c[J+12>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[f>>2]|0;h=b+40|0;if(j){if(a[h>>0]|0)m5(j);c[f>>2]=0}a[h>>0]=1;c[f>>2]=l;c[k>>2]=p}else f=b+36|0;do{K=(c[f>>2]|0)+(e<<4)|0;c[K>>2]=c[o>>2];c[K+4>>2]=c[o+4>>2];c[K+8>>2]=c[o+8>>2];c[K+12>>2]=c[o+12>>2];e=e+1|0}while((e|0)!=(p|0))}c[m>>2]=p;m=b+48|0;n=c[m>>2]|0;if((p|0)>(n|0)){j=b+52|0;do if((c[j>>2]|0)<(p|0)){e=l5(p<<2,16)|0;f=c[m>>2]|0;k=b+56|0;l=c[k>>2]|0;if((f|0)<=0){if(!l){a[b+60>>0]=1;c[k>>2]=e;c[j>>2]=p;break}}else{h=0;do{c[e+(h<<2)>>2]=c[l+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}f=b+60|0;if(a[f>>0]|0)m5(l);a[f>>0]=1;c[k>>2]=e;c[j>>2]=p}else e=c[b+56>>2]|0;while(0);M9(e+(n<<2)|0,0,p-n<<2|0)|0}c[m>>2]=p;m=b+68|0;n=c[m>>2]|0;if((p|0)>(n|0)){j=b+72|0;do if((c[j>>2]|0)<(p|0)){e=l5(p<<2,16)|0;f=c[m>>2]|0;k=b+76|0;l=c[k>>2]|0;if((f|0)<=0){if(!l){a[b+80>>0]=1;c[k>>2]=e;c[j>>2]=p;break}}else{h=0;do{c[e+(h<<2)>>2]=c[l+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}f=b+80|0;if(a[f>>0]|0)m5(l);a[f>>0]=1;c[k>>2]=e;c[j>>2]=p}else e=c[b+76>>2]|0;while(0);M9(e+(n<<2)|0,0,p-n<<2|0)|0}c[m>>2]=p;e=c[N>>2]|0;f=(e|0)>0;if(!f){i=S;return}h=c[b+76>>2]|0;j=c[b+56>>2]|0;k=0;do{g[h+(k<<2)>>2]=0.0;g[j+(k<<2)>>2]=0.0;k=k+1|0}while((k|0)<(e|0));if(!f){i=S;return}p=b+144|0;q=D+16|0;r=D+32|0;k=b+36|0;l=b+120|0;m=b+16|0;n=b+116|0;o=b+76|0;j=0;do{f=c[p>>2]|0;h=c[f+(j*284|0)+88>>2]|0;if(h){e=f+(j*284|0)+92|0;c[D>>2]=c[e>>2];c[D+4>>2]=c[e+4>>2];c[D+8>>2]=c[e+8>>2];c[D+12>>2]=c[e+12>>2];e=f+(j*284|0)+108|0;c[q>>2]=c[e>>2];c[q+4>>2]=c[e+4>>2];c[q+8>>2]=c[e+8>>2];c[q+12>>2]=c[e+12>>2];e=f+(j*284|0)+124|0;c[r>>2]=c[e>>2];c[r+4>>2]=c[e+4>>2];c[r+8>>2]=c[e+8>>2];c[r+12>>2]=c[e+12>>2];e=c[k>>2]|0;H=c[l>>2]|0;J=c[D+16+(H<<2)>>2]|0;G=c[D+32+(H<<2)>>2]|0;c[e+(j<<4)>>2]=c[D+(H<<2)>>2];c[e+(j<<4)+4>>2]=J;c[e+(j<<4)+8>>2]=G;g[e+(j<<4)+12>>2]=0.0;e=c[k>>2]|0;G=e+(j<<4)|0;X=+g[G>>2];J=f+(j*284|0)|0;U=+g[J>>2];H=e+(j<<4)+4|0;s=+g[H>>2];I=f+(j*284|0)+4|0;t=+g[I>>2];e=e+(j<<4)+8|0;W=+g[e>>2];K=f+(j*284|0)+8|0;V=+g[K>>2];T=X*U+s*t+W*V;U=X-U*T;t=s-t*T;T=W-V*T;V=1.0/+P(+(U*U+t*t+T*T));U=U*V;g[G>>2]=U;t=t*V;g[H>>2]=t;V=T*V;g[e>>2]=V;e=c[m>>2]|0;T=+g[I>>2];W=+g[K>>2];s=+g[J>>2];g[e+(j<<4)>>2]=T*V-W*t;g[e+(j<<4)+4>>2]=W*U-V*s;g[e+(j<<4)+8>>2]=t*s-T*U;g[e+(j<<4)+12>>2]=0.0;e=c[m>>2]|0;J=e+(j<<4)|0;U=+g[J>>2];K=e+(j<<4)+4|0;T=+g[K>>2];e=e+(j<<4)+8|0;s=+g[e>>2];t=1.0/+P(+(U*U+T*T+s*s));g[J>>2]=U*t;g[K>>2]=T*t;g[e>>2]=s*t;e=f+(j*284|0)+16|0;cW(c[n>>2]|0,e,h,e,0.0,(c[k>>2]|0)+(j<<4)|0,(c[o>>2]|0)+(j<<2)|0,d);e=(c[o>>2]|0)+(j<<2)|0;g[e>>2]=+g[5424]*+g[e>>2];e=c[N>>2]|0}j=j+1|0}while((j|0)<(e|0));if((e|0)<=0){i=S;return}k=b+144|0;m=b+116|0;n=b+16|0;o=D+8|0;p=D+12|0;q=D+16|0;r=D+4|0;u=D+44|0;v=D+24|0;w=D+28|0;x=D+32|0;y=D+40|0;z=b+56|0;A=b+76|0;j=c[k>>2]|0;f=0;B=0;while(1){e=c[j+(B*284|0)+88>>2]|0;if(e){s=+g[j+(B*284|0)+252>>2];if(s!=0.0){e=j;s=s*d}else{W=+g[j+(B*284|0)+256>>2];ZV(D,c[m>>2]|0,e,j+(B*284|0)+16|0,(c[n>>2]|0)+(B<<4)|0,W==0.0?0.0:W);K=c[D>>2]|0;W=+g[o>>2];t=W-+g[K+52>>2];U=+g[p>>2];Z=U-+g[K+56>>2];_=+g[q>>2];aa=_-+g[K+60>>2];e=c[r>>2]|0;W=W-+g[e+52>>2];U=U-+g[e+56>>2];_=_-+g[e+60>>2];X=+g[u>>2];T=+g[K+332>>2];ba=+g[K+336>>2];Y=+g[K+328>>2];s=+g[e+332>>2];$=+g[e+336>>2];V=+g[e+328>>2];s=-(+g[y>>2]*((aa*T-Z*ba+ +g[K+312>>2]-(_*s-U*$+ +g[e+312>>2]))*+g[v>>2]+(+g[K+316>>2]+(t*ba-aa*Y)-(+g[e+316>>2]+(W*$-_*V)))*+g[w>>2]+(Z*Y-t*T+ +g[K+320>>2]-(U*V-W*s+ +g[e+320>>2]))*+g[x>>2]));s=X<s?X:s;X=-X;e=c[k>>2]|0;s=s<X?X:s}K=(c[z>>2]|0)+(B<<2)|0;g[K>>2]=0.0;h=e+(B*284|0)+280|0;g[h>>2]=1.0;t=+g[j+(B*284|0)+276>>2]*d*+g[j+(B*284|0)+228>>2];g[K>>2]=s;ba=s*.5;s=+g[(c[A>>2]|0)+(B<<2)>>2];s=ba*ba+s*s;if(s>t*t){ba=t/+P(+s);g[h>>2]=ba*+g[h>>2];f=1}}else{g[(c[z>>2]|0)+(B<<2)>>2]=0.0;g[j+(B*284|0)+280>>2]=1.0;e=j}B=B+1|0;l=c[N>>2]|0;if((B|0)>=(l|0))break;else j=e}if(f){if((l|0)<=0){i=S;return}e=c[b+76>>2]|0;f=b+144|0;h=b+56|0;k=0;do{j=e+(k<<2)|0;if(+g[j>>2]!=0.0?(E=(c[f>>2]|0)+(k*284|0)+280|0,C=+g[E>>2],C<1.0):0){K=(c[h>>2]|0)+(k<<2)|0;g[K>>2]=C*+g[K>>2];g[j>>2]=+g[E>>2]*+g[j>>2]}k=k+1|0}while((k|0)<(l|0))}if((l|0)<=0){i=S;return}q=b+144|0;r=b+116|0;u=O+4|0;v=O+8|0;w=O+12|0;x=b+56|0;y=b+16|0;z=L+4|0;A=L+8|0;B=L+12|0;D=b+76|0;E=Q+4|0;F=Q+8|0;G=Q+12|0;H=b+36|0;I=R+4|0;J=R+8|0;K=R+12|0;f=b+124|0;h=M+4|0;j=M+8|0;k=M+12|0;p=0;do{l=c[q>>2]|0;e=c[r>>2]|0;m=l+(p*284|0)+16|0;t=+g[m>>2]-+g[e+52>>2];n=l+(p*284|0)+20|0;d=+g[n>>2]-+g[e+56>>2];o=l+(p*284|0)+24|0;C=+g[o>>2]-+g[e+60>>2];g[O>>2]=t;g[u>>2]=d;g[v>>2]=C;g[w>>2]=0.0;s=+g[(c[x>>2]|0)+(p<<2)>>2];if(s!=0.0){b=c[y>>2]|0;aa=s*+g[b+(p<<4)+4>>2];ba=s*+g[b+(p<<4)+8>>2];g[L>>2]=s*+g[b+(p<<4)>>2];g[z>>2]=aa;g[A>>2]=ba;g[B>>2]=0.0;vC(e,L,O)}s=+g[(c[D>>2]|0)+(p<<2)>>2];if(s!=0.0){b=c[(c[q>>2]|0)+(p*284|0)+88>>2]|0;aa=+g[n>>2]-+g[b+56>>2];$=+g[o>>2]-+g[b+60>>2];g[Q>>2]=+g[m>>2]-+g[b+52>>2];g[E>>2]=aa;g[F>>2]=$;g[G>>2]=0.0;o=c[H>>2]|0;$=+g[o+(p<<4)>>2]*s;aa=s*+g[o+(p<<4)+4>>2];ba=s*+g[o+(p<<4)+8>>2];g[R>>2]=$;g[I>>2]=aa;g[J>>2]=ba;g[K>>2]=0.0;o=c[r>>2]|0;n=c[f>>2]|0;X=+g[o+4+(n<<2)>>2];Y=+g[o+20+(n<<2)>>2];Z=+g[o+36+(n<<2)>>2];_=(X*t+Y*d+Z*C)*(1.0-+g[l+(p*284|0)+244>>2]);g[O>>2]=t-X*_;g[u>>2]=d-Y*_;g[v>>2]=C-Z*_;vC(o,R,O);g[M>>2]=-$;g[h>>2]=-aa;g[j>>2]=-ba;g[k>>2]=0.0;vC(b,M,Q)}p=p+1|0}while((p|0)<(c[N>>2]|0));i=S;return}function YV(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0,z=0;u=i;i=i+48|0;s=u+32|0;t=u+16|0;m=u;n=b+136|0;if((c[n>>2]|0)<=0){i=u;return}o=s+4|0;p=s+8|0;q=s+12|0;r=b+144|0;j=b+120|0;k=t+4|0;b=t+8|0;e=m+4|0;f=m+8|0;h=m+12|0;l=0;do{z=c[r>>2]|0;c[s>>2]=(a[z+(l*284|0)+84>>0]|0)==0?1065353216:0;c[o>>2]=0;c[p>>2]=1065353216;g[q>>2]=0.0;y=z+(l*284|0)+140|0;c[t>>2]=c[y>>2];c[t+4>>2]=c[y+4>>2];c[t+8>>2]=c[y+8>>2];c[t+12>>2]=c[y+12>>2];y=c[j>>2]|0;v=c[(c[d>>2]|0)+8>>2]|0;x=+g[z+(l*284|0)+108+(y<<2)>>2]+ +g[k>>2];w=+g[z+(l*284|0)+124+(y<<2)>>2]+ +g[b>>2];g[m>>2]=+g[z+(l*284|0)+92+(y<<2)>>2]+ +g[t>>2];g[e>>2]=x;g[f>>2]=w;g[h>>2]=0.0;zg[v&127](d,t,m,s);zg[c[(c[d>>2]|0)+8>>2]&127](d,t,(c[r>>2]|0)+(l*284|0)+16|0,s);l=l+1|0}while((l|0)<(c[n>>2]|0));i=u;return}function ZV(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0;c[a>>2]=b;c[a+4>>2]=d;y=a+8|0;c[y>>2]=c[e>>2];c[y+4>>2]=c[e+4>>2];c[y+8>>2]=c[e+8>>2];c[y+12>>2]=c[e+12>>2];y=a+24|0;c[y>>2]=c[f>>2];c[y+4>>2]=c[f+4>>2];c[y+8>>2]=c[f+8>>2];c[y+12>>2]=c[f+12>>2];g[a+44>>2]=h;k=+g[e>>2];t=k-+g[b+52>>2];m=+g[e+4>>2];u=m-+g[b+56>>2];i=+g[e+8>>2];r=i-+g[b+60>>2];p=+g[f+8>>2];l=+g[f+4>>2];w=u*p-r*l;o=+g[f>>2];x=r*o-t*p;s=t*l-u*o;q=+g[b+264>>2]*w+ +g[b+280>>2]*x+s*+g[b+296>>2];v=w*+g[b+268>>2]+x*+g[b+284>>2]+s*+g[b+300>>2];s=w*+g[b+272>>2]+x*+g[b+288>>2]+s*+g[b+304>>2];k=k-+g[d+52>>2];m=m-+g[d+56>>2];i=i-+g[d+60>>2];x=p*m-l*i;w=o*i-p*k;j=l*k-o*m;h=j*+g[d+296>>2]+(+g[d+264>>2]*x+ +g[d+280>>2]*w);n=x*+g[d+268>>2]+w*+g[d+284>>2]+j*+g[d+300>>2];j=x*+g[d+272>>2]+w*+g[d+288>>2]+j*+g[d+304>>2];g[a+40>>2]=1.0/(+g[b+344>>2]+(p*(u*q-t*v)+(o*(r*v-u*s)+l*(t*s-r*q)))+(+g[d+344>>2]+(p*(m*h-k*n)+(o*(i*n-m*j)+l*(k*j-i*h)))));return}function _V(a,b,d){a=a|0;b=b|0;d=+d;jf[c[(c[a>>2]|0)+16>>2]&31](a,d);return}function $V(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+120>>2]=b;c[a+124>>2]=d;c[a+128>>2]=e;return}function aW(a){a=a|0;return +(+g[a+204>>2])}function bW(a,b,d,e){a=a|0;b=b|0;d=+d;e=+e;var f=0,h=0.0,i=0.0,j=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;j=+R(+d);i=+S(+d);f=c[b+444>>2]|0;l=+O(+j)>1.1920928955078125e-007;d=(c[k>>2]=f,+g[k>>2]);if(l){n=i*i;h=j*j;m=n/h;o=+g[b+448>>2];m=+P(+((m+1.0)/(1.0/(o*o)+m/(d*d))));d=n;f=(g[k>>2]=m,c[k>>2]|0)}else{d=i*i;h=j*j}p=+P(+(h+0.0+d));q=(c[k>>2]=f,+g[k>>2])*.5;p=+S(+q)/p;o=p*0.0;h=j*p;i=i*p;j=+R(+q);q=h*0.0;p=i*-0.0;d=j*e+q-p;r=j*0.0;m=o*0.0;n=r-i*e-m;m=r+m-h*e;e=-(o*e)-q-p;o=-o;h=-h;g[a>>2]=i*n+(j*d+e*o)-m*h;g[a+4>>2]=m*o+(j*n+e*h)-i*d;g[a+8>>2]=d*h+(i*e+j*m)-n*o;g[a+12>>2]=0.0;return}function cW(a,b,c,d,e,f,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;h=h|0;i=+i;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;i=+g[f>>2];j=+g[f+4>>2];e=+g[f+8>>2];if(i*i+j*j+e*e>1.100000023841858){j=0.0;g[h>>2]=j;return}v=+g[b>>2]-+g[a+52>>2];x=+g[b+4>>2]-+g[a+56>>2];A=+g[b+8>>2]-+g[a+60>>2];r=+g[d>>2]-+g[c+52>>2];t=+g[d+4>>2]-+g[c+56>>2];y=+g[d+8>>2]-+g[c+60>>2];u=+g[a+332>>2];B=+g[a+336>>2];w=+g[a+328>>2];q=+g[c+332>>2];z=+g[c+336>>2];s=+g[c+328>>2];m=e*x-j*A;k=i*A-e*v;n=j*v-i*x;p=m*+g[a+4>>2]+k*+g[a+20>>2]+n*+g[a+36>>2];o=m*+g[a+8>>2]+k*+g[a+24>>2]+n*+g[a+40>>2];n=m*+g[a+12>>2]+k*+g[a+28>>2]+n*+g[a+44>>2];k=-i;m=-j;C=-e;D=t*C-y*m;C=y*k-r*C;k=r*m-t*k;m=D*+g[c+4>>2]+C*+g[c+20>>2]+k*+g[c+36>>2];l=D*+g[c+8>>2]+C*+g[c+24>>2]+k*+g[c+40>>2];k=D*+g[c+12>>2]+C*+g[c+28>>2]+k*+g[c+44>>2];j=(i*(A*u-x*B+ +g[a+312>>2]-(y*q-t*z+ +g[c+312>>2]))+j*(+g[a+316>>2]+(v*B-A*w)-(+g[c+316>>2]+(r*z-y*s)))+e*(x*w-v*u+ +g[a+320>>2]-(t*s-r*q+ +g[c+320>>2])))*-.20000000298023224*(1.0/(+g[c+344>>2]+(+g[a+344>>2]+(p*(p*+g[a+396>>2])+o*(o*+g[a+400>>2])+n*(n*+g[a+404>>2])))+(m*(m*+g[c+396>>2])+l*(l*+g[c+400>>2])+k*(k*+g[c+404>>2]))));g[h>>2]=j;return}function dW(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0;c[b>>2]=22324;h=b+4|0;o=0;Ja(538,h|0);e=o;o=0;if(!(e&1)){e=b+64|0;o=0;Ja(538,e|0);j=o;o=0;if(j&1)f=e;else{a[b+193>>0]=0;a[b+194>>0]=1;j=(d|0)!=0;a[b+192>>0]=j&1^1;g[b+140>>2]=0.0;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+168>>2]=0;c[b+172>>2]=0;g[b+176>>2]=0.0;if(j){i=d;j=b+136|0;c[j>>2]=i;j=b+188|0;c[j>>2]=0;j=b+180|0;c[j>>2]=0;j=b+184|0;c[j>>2]=0;j=b+124|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;return}o=0;e=cb(77,76,16)|0;j=o;o=0;if(!(j&1)?(o=0,Ja(539,e|0),j=o,o=0,!(j&1)):0){i=e;j=b+136|0;c[j>>2]=i;j=b+188|0;c[j>>2]=0;j=b+180|0;c[j>>2]=0;j=b+184|0;c[j>>2]=0;j=b+124|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;return}e=zc()|0;o=0;Ja(540,b+64|0);j=o;o=0;if(!(j&1)?(o=0,Ja(540,b+4|0),j=o,o=0,!(j&1)):0){j=e;Kc(j|0)}j=zc(0)|0;Di(j)}}else f=h;e=zc()|0;d=D;if((h|0)==(f|0)){j=e;Kc(j|0)}while(1){f=f+-60|0;o=0;Ja(540,f|0);j=o;o=0;if(j&1)break;if((f|0)==(h|0)){i=12;break}}if((i|0)==12)Kc(e|0);j=zc(0)|0;Di(j)}function eW(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=22324;do if(a[b+192>>0]|0){d=b+136|0;f=c[d>>2]|0;o=0;Ja(c[c[f>>2]>>2]|0,f|0);f=o;o=0;if(!(f&1)?(o=0,Ja(494,c[d>>2]|0),f=o,o=0,!(f&1)):0)break;d=zc()|0;o=0;Ja(540,b+64|0);f=o;o=0;if(!(f&1)?(o=0,Ja(540,b+4|0),f=o,o=0,!(f&1)):0){g=d;Kc(g|0)}f=zc(0)|0;Di(f)}while(0);f=b+4|0;d=b+64|0;o=0;Ja(540,d|0);e=o;o=0;if(!(e&1)){d=b+4|0;o=0;Ja(540,d|0);e=o;o=0;if(e&1)b=d;else return}else b=d;d=zc()|0;e=D;if((f|0)==(b|0)){g=d;Kc(g|0)}while(1){b=b+-60|0;o=0;Ja(540,b|0);h=o;o=0;if(h&1)break;if((b|0)==(f|0)){g=11;break}}if((g|0)==11)Kc(d|0);h=zc(0)|0;Di(h)}function fW(a){a=a|0;var b=0;o=0;Ja(245,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function gW(d,e,f,g,h,j,k,l,m){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;q=i;i=i+48|0;o=q+16|0;p=q;n=l5(64,16)|0;c[n>>2]=h;b[n+4>>1]=j;b[n+6>>1]=k;m=n+16|0;c[m>>2]=c[e>>2];c[m+4>>2]=c[e+4>>2];c[m+8>>2]=c[e+8>>2];c[m+12>>2]=c[e+12>>2];m=n+32|0;c[m>>2]=c[f>>2];c[m+4>>2]=c[f+4>>2];c[m+8>>2]=c[f+8>>2];c[m+12>>2]=c[f+12>>2];c[n+8>>2]=0;m=n+56|0;c[m>>2]=0;h=n+52|0;c[h>>2]=0;c[o>>2]=c[e>>2];c[o+4>>2]=c[e+4>>2];c[o+8>>2]=c[e+8>>2];c[o+12>>2]=c[e+12>>2];l=o+16|0;c[l>>2]=c[f>>2];c[l+4>>2]=c[f+4>>2];c[l+8>>2]=c[f+8>>2];c[l+12>>2]=c[f+12>>2];l=d+144|0;c[n+60>>2]=c[l>>2];k=d+188|0;g=(c[k>>2]|0)+1|0;c[k>>2]=g;c[n+12>>2]=g;g=d+4|0;c[n+48>>2]=G2(g,o,n)|0;l=d+124+(c[l>>2]<<2)|0;c[h>>2]=0;c[m>>2]=c[l>>2];m=c[l>>2]|0;if(m)c[m+52>>2]=n;c[l>>2]=n;if(a[d+193>>0]|0){i=q;return n|0}c[p>>2]=22388;c[p+4>>2]=d;c[p+8>>2]=n;uW(g,c[g>>2]|0,o,p);d=d+64|0;uW(d,c[d>>2]|0,o,p);i=q;return n|0}function hW(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;f=d+60|0;if((c[f>>2]|0)==2)J2(b+64|0,c[d+48>>2]|0);else J2(b+4|0,c[d+48>>2]|0);j=d+52|0;g=c[j>>2]|0;h=d+56|0;i=c[h>>2]|0;if(!g)c[b+124+(c[f>>2]<<2)>>2]=i;else c[g+56>>2]=i;f=c[h>>2]|0;if(f)c[f+52>>2]=c[j>>2];j=c[b+136>>2]|0;tg[c[(c[j>>2]|0)+16>>2]&255](j,d,e);m5(d);a[b+194>>0]=1;return}function iW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=b+16|0;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];a=b+32|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function jW(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;j=i;i=i+16|0;k=j;c[k>>2]=22424;c[k+4>>2]=e;n=a+4|0;m=e+4|0;l=e+20|0;e=e+32|0;vW(n,c[n>>2]|0,b,d,m,l,+g[e>>2],f,h,k);a=a+64|0;vW(a,c[a>>2]|0,b,d,m,l,+g[e>>2],f,h,k);i=j;return}function kW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+48|0;g=f+32|0;h=f;c[g>>2]=22460;c[g+4>>2]=e;c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[h+12>>2]=c[b+12>>2];b=h+16|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];b=a+4|0;uW(b,c[b>>2]|0,h,g);a=a+64|0;uW(a,c[a>>2]|0,h,g);i=f;return}function lW(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0.0,w=0.0;u=i;i=i+64|0;l=u+32|0;m=u+16|0;t=u;c[l>>2]=c[e>>2];c[l+4>>2]=c[e+4>>2];c[l+8>>2]=c[e+8>>2];c[l+12>>2]=c[e+12>>2];s=l+16|0;c[s>>2]=c[f>>2];c[s+4>>2]=c[f+4>>2];c[s+8>>2]=c[f+8>>2];c[s+12>>2]=c[f+12>>2];s=d+60|0;do if((c[s>>2]|0)==2){m=d+48|0;J2(b+64|0,c[m>>2]|0);c[m>>2]=G2(b+4|0,l,d)|0;m=1}else{h=b+168|0;c[h>>2]=(c[h>>2]|0)+1;h=c[d+48>>2]|0;if(((((+g[h>>2]<=+g[l+16>>2]?+g[h+16>>2]>=+g[l>>2]:0)?+g[h+4>>2]<=+g[l+20>>2]:0)?+g[h+20>>2]>=+g[l+4>>2]:0)?+g[h+8>>2]<=+g[l+24>>2]:0)?+g[h+24>>2]>=+g[l+8>>2]:0){p=+g[d+16>>2];v=+g[e>>2]-p;q=+g[d+20>>2];n=+g[e+4>>2]-q;r=+g[d+24>>2];o=+g[e+8>>2]-r;w=+g[b+140>>2];p=(+g[d+32>>2]-p)*.5*w;q=w*((+g[d+36>>2]-q)*.5);r=w*((+g[d+40>>2]-r)*.5);g[m>>2]=p;j=m+4|0;g[j>>2]=q;k=m+8|0;g[k>>2]=r;g[m+12>>2]=0.0;if(v<0.0)g[m>>2]=-p;if(n<0.0)g[j>>2]=-q;if(o<0.0)g[k>>2]=-r;if(!(I2(b+4|0,h,l,m,.05000000074505806)|0)){m=0;break}m=b+172|0;c[m>>2]=(c[m>>2]|0)+1;m=1;break}H2(b+4|0,h,l);m=b+172|0;c[m>>2]=(c[m>>2]|0)+1;m=1}while(0);k=d+52|0;h=c[k>>2]|0;l=d+56|0;j=c[l>>2]|0;if(!h)c[b+124+(c[s>>2]<<2)>>2]=j;else c[h+56>>2]=j;h=c[l>>2]|0;if(h)c[h+52>>2]=c[k>>2];j=d+16|0;c[j>>2]=c[e>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2];c[j+12>>2]=c[e+12>>2];j=d+32|0;c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];j=c[b+144>>2]|0;c[s>>2]=j;j=b+124+(j<<2)|0;c[k>>2]=0;c[l>>2]=c[j>>2];h=c[j>>2]|0;if(h)c[h+52>>2]=d;c[j>>2]=d;if(!m){i=u;return}a[b+194>>0]=1;if(a[b+193>>0]|0){i=u;return}c[t>>2]=22388;c[t+4>>2]=b;e=b+64|0;d=d+48|0;wW(e,c[e>>2]|0,c[d>>2]|0,t);b=b+4|0;wW(b,c[b>>2]|0,c[d>>2]|0,t);i=u;return}function mW(a,b){a=a|0;b=b|0;nW(a,b);oW(a,b);return}function nW(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0;A=i;i=i+48|0;t=A+16|0;w=A;v=b+4|0;F2(v,(($(c[b+152>>2]|0,c[b+16>>2]|0)|0)/100|0)+1|0);s=b+164|0;if(c[s>>2]|0){r=(($(c[b+148>>2]|0,c[b+76>>2]|0)|0)/100|0)+1|0;F2(b+64|0,r);r=(c[s>>2]|0)-r|0;c[s>>2]=(r|0)<0?0:r}r=b+144|0;e=((c[r>>2]|0)+1|0)%2|0;c[r>>2]=e;e=c[b+124+(e<<2)>>2]|0;do if(e){p=b+132|0;q=t+16|0;r=b+64|0;while(1){k=e+56|0;m=e;e=c[k>>2]|0;n=m+60|0;l=m+52|0;j=c[l>>2]|0;h=e;if(!j)c[b+124+(c[n>>2]<<2)>>2]=h;else c[j+56>>2]=h;h=c[k>>2]|0;if(h)c[h+52>>2]=c[l>>2];c[l>>2]=0;c[k>>2]=c[p>>2];h=c[p>>2]|0;if(h)c[h+52>>2]=m;c[p>>2]=m;j=m+48|0;o=0;na(270,v|0,c[j>>2]|0);l=o;o=0;if(l&1)break;l=m+16|0;h=m+32|0;c[t>>2]=c[l>>2];c[t+4>>2]=c[l+4>>2];c[t+8>>2]=c[l+8>>2];c[t+12>>2]=c[l+12>>2];c[q>>2]=c[h>>2];c[q+4>>2]=c[h+4>>2];c[q+8>>2]=c[h+8>>2];c[q+12>>2]=c[h+12>>2];o=0;h=Ha(69,r|0,t|0,m|0)|0;m=o;o=0;if(m&1)break;c[j>>2]=h;c[n>>2]=2;if(!e){u=15;break}}if((u|0)==15){c[s>>2]=c[b+76>>2];a[b+194>>0]=1;break}A=zc()|0;Kc(A|0)}while(0);c[w>>2]=22388;c[w+4>>2]=b;e=b+193|0;do if(a[e>>0]|0){o=0;yb(80,v|0,c[v>>2]|0,c[b+64>>2]|0,w|0);u=o;o=0;if(!(u&1)){if(!(a[e>>0]|0))break;u=c[v>>2]|0;o=0;yb(80,v|0,u|0,u|0,w|0);w=o;o=0;if(!(w&1))break}A=zc()|0;Kc(A|0)}while(0);m=b+194|0;do if((a[m>>0]|0)!=0?(y=b+136|0,x=c[y>>2]|0,x=rf[c[(c[x>>2]|0)+28>>2]&255](x)|0,z=x+4|0,f=c[z>>2]|0,(f|0)>0):0){e=($(c[b+156>>2]|0,f)|0)/100|0;l=c[b+160>>2]|0;e=(l|0)>(e|0)?l:e;e=(f|0)<(e|0)?f:e;l=b+184|0;if((e|0)>0){k=x+12|0;j=0;do{h=((c[l>>2]|0)+j|0)%(f|0)|0;w=c[k>>2]|0;f=c[w+(h<<4)>>2]|0;h=c[w+(h<<4)+4>>2]|0;w=c[f+48>>2]|0;x=c[h+48>>2]|0;if(((((+g[w>>2]<=+g[x+16>>2]?+g[w+16>>2]>=+g[x>>2]:0)?+g[w+4>>2]<=+g[x+20>>2]:0)?+g[w+20>>2]>=+g[x+4>>2]:0)?+g[w+8>>2]<=+g[x+24>>2]:0)?+g[w+24>>2]>=+g[x+8>>2]:0)f=j;else{x=c[y>>2]|0;qg[c[(c[x>>2]|0)+12>>2]&63](x,f,h,d)|0;f=j+-1|0;e=e+-1|0}j=f+1|0;f=c[z>>2]|0}while((j|0)<(e|0));if((f|0)<=0){c[l>>2]=0;break}}c[l>>2]=((c[l>>2]|0)+e|0)%(f|0)|0}while(0);h=b+180|0;c[h>>2]=(c[h>>2]|0)+1;c[b+160>>2]=1;a[m>>0]=0;h=b+168|0;j=c[h>>2]|0;e=b+172|0;f=c[e>>2]|0;if(!j){B=0.0;b=b+176|0;g[b>>2]=B;b=f>>>1;c[e>>2]=b;b=j>>>1;c[h>>2]=b;i=A;return}B=+(f>>>0)/+(j>>>0);b=b+176|0;g[b>>2]=B;b=f>>>1;c[e>>2]=b;b=j>>>1;c[h>>2]=b;i=A;return}function oW(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+16|0;o=s;n=b+136|0;r=c[n>>2]|0;if(!(rf[c[(c[r>>2]|0)+56>>2]&255](r)|0)){i=s;return}q=c[n>>2]|0;q=rf[c[(c[q>>2]|0)+28>>2]&255](q)|0;r=q+4|0;b=c[r>>2]|0;if((b|0)>1){xW(q,s+1|0,0,b+-1|0);j=0;e=0;h=0;f=0;p=4}else{m=0;j=0;h=0;f=0}while(1){if((p|0)==4){p=0;b=c[r>>2]|0;m=e}if((h|0)>=(b|0))break;l=c[q+12>>2]|0;k=l+(h<<4)|0;e=c[k>>2]|0;l=l+(h<<4)+4|0;b=c[l>>2]|0;if(!((e|0)==(m|0)&(b|0)==(j|0))){j=c[e+48>>2]|0;m=c[(c[l>>2]|0)+48>>2]|0;if(!(((((+g[j>>2]<=+g[m+16>>2]?+g[j+16>>2]>=+g[m>>2]:0)?+g[j+4>>2]<=+g[m+20>>2]:0)?+g[j+20>>2]>=+g[m+4>>2]:0)?+g[j+8>>2]<=+g[m+24>>2]:0)?+g[j+24>>2]>=+g[m+8>>2]:0))p=13}else{b=j;p=13}if((p|0)==13){p=c[n>>2]|0;tg[c[(c[p>>2]|0)+32>>2]&255](p,k,d);c[k>>2]=0;c[l>>2]=0;f=f+1|0}j=b;h=h+1|0;p=4}if((b|0)>1){xW(q,o,0,b+-1|0);b=c[r>>2]|0}l=b-f|0;if((f|0)<0){k=q+8|0;if((c[k>>2]|0)<(l|0)){if((b|0)!=(f|0)){h=l5(l<<4,16)|0;f=c[r>>2]|0;e=q+12|0;if((f|0)>0){j=0;do{p=c[e>>2]|0;c[h+(j<<4)>>2]=c[p+(j<<4)>>2];c[h+(j<<4)+4>>2]=c[p+(j<<4)+4>>2];c[h+(j<<4)+8>>2]=c[p+(j<<4)+8>>2];c[h+(j<<4)+12>>2]=c[p+(j<<4)+12>>2];j=j+1|0}while((j|0)!=(f|0))}}else{h=0;e=q+12|0}j=c[e>>2]|0;f=q+16|0;if(j){if(a[f>>0]|0)m5(j);c[e>>2]=0}a[f>>0]=1;c[e>>2]=h;c[k>>2]=l}else e=q+12|0;do{q=(c[e>>2]|0)+(b<<4)|0;b=b+1|0;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0}while((b|0)!=(l|0))}c[r>>2]=l;i=s;return}function pW(a){a=a|0;return c[a+136>>2]|0}function qW(a){a=a|0;return c[a+136>>2]|0}function rW(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0;m=c[a+4>>2]|0;o=c[a+64>>2]|0;a=(o|0)==0;do if(!m)if(a){f=0.0;h=0.0;n=0.0;k=0.0;l=0.0;j=0.0;i=0.0;e=0.0}else{f=+g[o+4>>2];h=+g[o+8>>2];n=+g[o+12>>2];k=+g[o+16>>2];l=+g[o+20>>2];j=+g[o+24>>2];i=+g[o+28>>2];e=+g[o>>2]}else{e=+g[m>>2];if(a){f=+g[m+4>>2];h=+g[m+8>>2];n=+g[m+12>>2];k=+g[m+16>>2];l=+g[m+20>>2];j=+g[m+24>>2];i=+g[m+28>>2];break}j=+g[o>>2];e=e<j?e:j;j=+g[m+16>>2];k=+g[o+16>>2];k=j>k?j:k;j=+g[m+4>>2];f=+g[o+4>>2];f=j<f?j:f;j=+g[m+20>>2];l=+g[o+20>>2];l=j>l?j:l;j=+g[m+8>>2];h=+g[o+8>>2];h=j<h?j:h;j=+g[m+24>>2];i=+g[o+24>>2];if(j>i){n=0.0;i=0.0}else{n=0.0;j=i;i=0.0}}while(0);g[b>>2]=e;g[b+4>>2]=f;g[b+8>>2]=h;g[b+12>>2]=n;g[d>>2]=k;g[d+4>>2]=l;g[d+8>>2]=j;g[d+12>>2]=i;return}function sW(b,d){b=b|0;d=d|0;if((c[b+16>>2]|0)!=(0-(c[b+76>>2]|0)|0))return;E2(b+4|0);E2(b+64|0);a[b+193>>0]=0;a[b+194>>0]=1;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;d=b+168|0;b=b+124|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;return}function tW(a){a=a|0;return}function uW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,p=0.0,q=0.0,r=0.0,s=0;if(!b)return;n=+g[d>>2];p=+g[d+4>>2];q=+g[d+8>>2];r=+g[d+16>>2];m=+g[d+20>>2];l=+g[d+24>>2];o=0;a=cb(77,256,16)|0;k=o;o=0;if(k&1){e=zc()|0;Kc(e|0)}c[a>>2]=b;k=1;d=64;a:while(1){i=k+-1|0;b=c[a+(i<<2)>>2]|0;do if(((((+g[b>>2]<=r?+g[b+16>>2]>=n:0)?+g[b+4>>2]<=m:0)?+g[b+20>>2]>=p:0)?+g[b+8>>2]<=l:0)?+g[b+24>>2]>=q:0){j=b+40|0;if(!(c[j>>2]|0)){o=0;na(c[(c[e>>2]|0)+12>>2]|0,e|0,b|0);k=o;o=0;if(k&1){b=30;break a}else{b=i;break}}h=c[b+36>>2]|0;do if((i|0)==(d|0)?(s=(d|0)!=0?d<<1:1,(k|0)<=(s|0)):0){if(s){o=0;b=cb(77,s<<2|0,16)|0;f=o;o=0;if(f&1){b=30;break a}}else b=0;if((k|0)<=1){if(!a){a=b;d=s;break}}else{f=0;do{c[b+(f<<2)>>2]=c[a+(f<<2)>>2];f=f+1|0}while((f|0)!=(d|0))}o=0;Ja(494,a|0);f=o;o=0;if(f&1){b=29;break a}else{a=b;d=s}}while(0);c[a+(i<<2)>>2]=h;h=c[j>>2]|0;do if((k|0)==(d|0)){d=(k|0)!=0?k<<1:1;if((k|0)<(d|0)){if(d){o=0;b=cb(77,d<<2|0,16)|0;j=o;o=0;if(j&1){b=30;break a}}else b=0;if((k|0)<=0){if(!a){a=b;break}}else{f=0;do{c[b+(f<<2)>>2]=c[a+(f<<2)>>2];f=f+1|0}while((f|0)!=(k|0))}o=0;Ja(494,a|0);j=o;o=0;if(j&1){b=29;break a}else a=b}else d=k}while(0);c[a+(k<<2)>>2]=h;b=k+1|0}else b=i;while(0);if((b|0)>0)k=b;else{b=34;break}}if((b|0)==29)d=zc()|0;else if((b|0)==30){d=zc()|0;if(!a){e=d;Kc(e|0)}}else if((b|0)==34){if(!a)return;m5(a);return}o=0;Ja(494,a|0);e=o;o=0;if(e&1){e=zc(0)|0;Di(e)}else{e=d;Kc(e|0)}}function vW(b,d,e,f,h,j,k,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0;U=i;i=i+32|0;T=U;if(!d){i=U;return}S=b+44|0;f=c[S>>2]|0;if((f|0)<128){r=b+48|0;if((c[r>>2]|0)<128){s=l5(512,16)|0;p=c[S>>2]|0;o=b+52|0;if((p|0)>0){q=0;do{c[s+(q<<2)>>2]=c[(c[o>>2]|0)+(q<<2)>>2];q=q+1|0}while((q|0)!=(p|0))}q=c[o>>2]|0;p=b+56|0;if(q){if(a[p>>0]|0)m5(q);c[o>>2]=0}a[p>>0]=1;c[o>>2]=s;c[r>>2]=128}else o=b+52|0;do{c[(c[o>>2]|0)+(f<<2)>>2]=0;f=f+1|0}while((f|0)!=128)}c[S>>2]=128;R=b+52|0;c[c[R>>2]>>2]=d;z=m+4|0;A=m+8|0;B=T+4|0;C=T+8|0;D=T+12|0;E=l+4|0;F=l+8|0;G=T+16|0;H=T+20|0;I=T+24|0;J=T+28|0;K=j+4|0;L=e+4|0;M=h+4|0;N=j+8|0;O=e+8|0;P=h+8|0;Q=b+48|0;y=b+56|0;x=1;f=126;while(1){o=x+-1|0;p=c[R>>2]|0;b=c[p+(o<<2)>>2]|0;u=+g[b+4>>2]-+g[z>>2];w=+g[b+8>>2]-+g[A>>2];g[T>>2]=+g[b>>2]-+g[m>>2];g[B>>2]=u;g[C>>2]=w;g[D>>2]=0.0;w=+g[b+20>>2]-+g[E>>2];u=+g[b+24>>2]-+g[F>>2];g[G>>2]=+g[b+16>>2]-+g[l>>2];g[H>>2]=w;g[I>>2]=u;g[J>>2]=0.0;d=c[j>>2]|0;u=+g[e>>2];w=+g[h>>2];t=(+g[T+(d<<4)>>2]-u)*w;u=w*(+g[T+(1-d<<4)>>2]-u);d=c[K>>2]|0;w=+g[L>>2];Z=+g[M>>2];v=(+g[T+(d<<4)+4>>2]-w)*Z;w=Z*(+g[T+(1-d<<4)+4>>2]-w);do if((!(v>u|t>w)?(X=v>t?v:t,Y=w<u?w:u,d=c[N>>2]|0,W=+g[O>>2],Z=+g[P>>2],V=(+g[T+(d<<4)+8>>2]-W)*Z,W=Z*(+g[T+(1-d<<4)+8>>2]-W),!(V>Y|X>W)):0)?((W<Y?W:Y)>0.0?(V>X?V:X)<k:0):0){d=b+40|0;if(!(c[d>>2]|0)){of[c[(c[n>>2]|0)+12>>2]&511](n,b);break}if((o|0)>(f|0)){r=c[S>>2]|0;s=r<<1;if((r|0)<(s|0)){if((c[Q>>2]|0)<(s|0)){if(r){f=l5(r<<3,16)|0;p=c[S>>2]|0;if((p|0)>0){q=0;do{c[f+(q<<2)>>2]=c[(c[R>>2]|0)+(q<<2)>>2];q=q+1|0}while((q|0)!=(p|0))}}else f=0;p=c[R>>2]|0;if(p){if(a[y>>0]|0)m5(p);c[R>>2]=0}a[y>>0]=1;c[R>>2]=f;c[Q>>2]=s;p=r}else{f=p;p=r}do{c[f+(p<<2)>>2]=0;p=p+1|0;f=c[R>>2]|0}while((p|0)!=(s|0))}else f=p;c[S>>2]=s;p=f;f=s+-2|0}c[p+(o<<2)>>2]=c[b+36>>2];c[(c[R>>2]|0)+(x<<2)>>2]=c[d>>2];o=x+1|0}while(0);if(!o)break;else x=o}i=U;return}function wW(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;if(!((d|0)!=0&(e|0)!=0))return;t=b+24|0;if((c[t>>2]|0)<128?(k=b+28|0,(c[k>>2]|0)<128):0){l=l5(1024,16)|0;h=c[t>>2]|0;j=b+32|0;if((h|0)>0){i=0;do{q=(c[j>>2]|0)+(i<<3)|0;r=c[q+4>>2]|0;s=l+(i<<3)|0;c[s>>2]=c[q>>2];c[s+4>>2]=r;i=i+1|0}while((i|0)!=(h|0))}i=c[j>>2]|0;h=b+36|0;if(i){if(a[h>>0]|0)m5(i);c[j>>2]=0}a[h>>0]=1;c[j>>2]=l;c[k>>2]=128}c[t>>2]=128;s=b+32|0;r=c[s>>2]|0;c[r>>2]=d;c[r+4>>2]=e;r=b+28|0;q=b+36|0;p=1;j=124;while(1){h=p+-1|0;i=c[s>>2]|0;n=c[i+(h<<3)>>2]|0;o=c[i+(h<<3)+4>>2]|0;if((h|0)>(j|0)){j=c[t>>2]|0;l=j<<1;if((j|0)<(l|0)?(c[r>>2]|0)<(l|0):0){if(j){i=l5(j<<4,16)|0;j=c[t>>2]|0;if((j|0)>0){k=0;do{e=(c[s>>2]|0)+(k<<3)|0;b=c[e+4>>2]|0;m=i+(k<<3)|0;c[m>>2]=c[e>>2];c[m+4>>2]=b;k=k+1|0}while((k|0)!=(j|0))}}else i=0;j=c[s>>2]|0;if(j){if(a[q>>0]|0)m5(j);c[s>>2]=0}a[q>>0]=1;c[s>>2]=i;c[r>>2]=l}c[t>>2]=l;m=l+-4|0}else m=j;do if((n|0)==(o|0)){j=n+40|0;if(c[j>>2]|0){b=n+36|0;o=c[b>>2]|0;c[i+(h<<3)>>2]=o;c[i+(h<<3)+4>>2]=o;h=p+1|0;o=c[s>>2]|0;n=c[j>>2]|0;c[o+(p<<3)>>2]=n;c[o+(p<<3)+4>>2]=n;o=c[s>>2]|0;n=c[j>>2]|0;c[o+(h<<3)>>2]=c[b>>2];c[o+(h<<3)+4>>2]=n;h=p+2|0}}else if(((((+g[n>>2]<=+g[o+16>>2]?+g[n+16>>2]>=+g[o>>2]:0)?+g[n+4>>2]<=+g[o+20>>2]:0)?+g[n+20>>2]>=+g[o+4>>2]:0)?+g[n+8>>2]<=+g[o+24>>2]:0)?+g[n+24>>2]>=+g[o+8>>2]:0){l=n+40|0;d=o+40|0;e=(c[d>>2]|0)!=0;if(!(c[l>>2]|0))if(e){o=c[o+36>>2]|0;c[i+(h<<3)>>2]=n;c[i+(h<<3)+4>>2]=o;h=c[s>>2]|0;o=c[d>>2]|0;c[h+(p<<3)>>2]=n;c[h+(p<<3)+4>>2]=o;h=p+1|0;break}else{tg[c[(c[f>>2]|0)+8>>2]&255](f,n,o);break}else{b=i+(h<<3)|0;j=n+36|0;k=c[j>>2]|0;if(e){n=o+36|0;o=c[n>>2]|0;c[b>>2]=k;c[i+(h<<3)+4>>2]=o;o=p+1|0;h=c[s>>2]|0;n=c[n>>2]|0;c[h+(p<<3)>>2]=c[l>>2];c[h+(p<<3)+4>>2]=n;h=p+2|0;n=c[s>>2]|0;b=c[d>>2]|0;c[n+(o<<3)>>2]=c[j>>2];c[n+(o<<3)+4>>2]=b;o=c[s>>2]|0;n=c[d>>2]|0;c[o+(h<<3)>>2]=c[l>>2];c[o+(h<<3)+4>>2]=n;h=p+3|0;break}else{c[b>>2]=k;c[i+(h<<3)+4>>2]=o;h=c[s>>2]|0;c[h+(p<<3)>>2]=c[l>>2];c[h+(p<<3)+4>>2]=o;h=p+1|0;break}}}while(0);if(!h)break;else{p=h;j=m}}return}function xW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=a+12|0;while(1){r=(d+e|0)/2|0;u=c[v>>2]|0;o=c[u+(r<<4)>>2]|0;q=c[u+(r<<4)+4>>2]|0;n=o;o=(o|0)==0;p=q;q=(q|0)==0;r=c[u+(r<<4)+8>>2]|0;s=p+12|0;t=n+12|0;g=d;f=e;while(1){a:do if(o)while(1){h=c[u+(g<<4)>>2]|0;if(!h)i=-1;else i=c[h+12>>2]|0;l=c[u+(g<<4)+4>>2]|0;if(!l)j=-1;else j=c[l+12>>2]|0;if(q)k=-1;else k=c[s>>2]|0;do if((i|0)<=-1){i=(h|0)==(n|0);h=(j|0)>(k|0);if(h|i^1)if(i&h)break;else break a;if((l|0)!=(p|0))break a;if((c[u+(g<<4)+8>>2]|0)>>>0<=r>>>0)break a}while(0);g=g+1|0}else{m=c[t>>2]|0;if(q)while(1){h=c[u+(g<<4)>>2]|0;if(!h)i=-1;else i=c[h+12>>2]|0;k=c[u+(g<<4)+4>>2]|0;if(!k)j=-1;else j=c[k+12>>2]|0;do if((i|0)<=(m|0)){i=(h|0)==(n|0);h=(j|0)>-1;if(h|i^1)if(i&h)break;else break a;if((k|0)!=(p|0))break a;if((c[u+(g<<4)+8>>2]|0)>>>0<=r>>>0)break a}while(0);g=g+1|0}l=c[s>>2]|0;while(1){h=c[u+(g<<4)>>2]|0;if(!h)i=-1;else i=c[h+12>>2]|0;k=c[u+(g<<4)+4>>2]|0;if(!k)j=-1;else j=c[k+12>>2]|0;do if((i|0)<=(m|0)){i=(h|0)==(n|0);h=(j|0)>(l|0);if(h|i^1)if(i&h)break;else break a;if((k|0)!=(p|0))break a;if((c[u+(g<<4)+8>>2]|0)>>>0<=r>>>0)break a}while(0);g=g+1|0}}while(0);b:while(1){if(o)i=-1;else i=c[t>>2]|0;h=c[u+(f<<4)>>2]|0;if(!h)j=-1;else j=c[h+12>>2]|0;if(q)k=-1;else k=c[s>>2]|0;m=c[u+(f<<4)+4>>2]|0;if(!m)l=-1;else l=c[m+12>>2]|0;do if((i|0)<=(j|0)){i=(n|0)==(h|0);h=(k|0)>(l|0);if(h|i^1)if(i&h)break;else break b;if((p|0)!=(m|0))break b;if(r>>>0<=(c[u+(f<<4)+8>>2]|0)>>>0)break b}while(0);f=f+-1|0}if((g|0)<=(f|0)){i=u+(g<<4)|0;j=c[i>>2]|0;k=c[u+(g<<4)+4>>2]|0;l=c[u+(g<<4)+8>>2]|0;m=c[u+(g<<4)+12>>2]|0;u=u+(f<<4)|0;c[i>>2]=c[u>>2];c[i+4>>2]=c[u+4>>2];c[i+8>>2]=c[u+8>>2];c[i+12>>2]=c[u+12>>2];u=c[v>>2]|0;c[u+(f<<4)>>2]=j;c[u+(f<<4)+4>>2]=k;c[u+(f<<4)+8>>2]=l;c[u+(f<<4)+12>>2]=m;g=g+1|0;f=f+-1|0}if((g|0)>(f|0))break;u=c[v>>2]|0}if((f|0)>(d|0))xW(a,b,d,f);if((g|0)<(e|0))d=g;else break}return}function yW(a){a=a|0;return}function zW(a){a=a|0;$5(a);return}function AW(a,b,c){a=a|0;b=b|0;c=c|0;return}function BW(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;dg[c[(c[a>>2]|0)+8>>2]&127](a,c[b+36>>2]|0)|0;return}function CW(a,b,d){a=a|0;b=b|0;d=+d;of[c[(c[a>>2]|0)+12>>2]&511](a,b);return}function DW(a,b){a=a|0;b=b|0;return 1}function EW(a,b){a=a|0;b=b|0;return 1}function FW(a){a=a|0;$5(a);return}function GW(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;dg[c[(c[a>>2]|0)+8>>2]&127](a,c[b+36>>2]|0)|0;return}function HW(a){a=a|0;$5(a);return}function IW(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((b|0)==(d|0))return;a=a+4|0;e=c[(c[a>>2]|0)+136>>2]|0;If[c[(c[e>>2]|0)+8>>2]&127](e,c[b+36>>2]|0,c[d+36>>2]|0)|0;a=(c[a>>2]|0)+160|0;c[a>>2]=(c[a>>2]|0)+1;return}function JW(a,b){a=a|0;b=b|0;tg[c[(c[a>>2]|0)+8>>2]&255](a,b,c[(c[a+8>>2]|0)+48>>2]|0);return}function KW(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0;c[b>>2]=22512;p=b+20|0;a[p>>0]=1;q=b+16|0;c[q>>2]=0;r=b+8|0;c[r>>2]=0;s=b+12|0;c[s>>2]=0;c[b+24>>2]=0;a[b+28>>0]=0;k=b+48|0;a[k>>0]=1;l=b+44|0;c[l>>2]=0;m=b+36|0;c[m>>2]=0;n=b+40|0;c[n>>2]=0;g=b+68|0;a[g>>0]=1;h=b+64|0;c[h>>2]=0;i=b+56|0;c[i>>2]=0;j=b+60|0;c[j>>2]=0;c[b+72>>2]=0;o=0;f=cb(77,32,16)|0;e=o;o=0;do if(!(e&1)){d=c[r>>2]|0;if((d|0)>0){e=0;do{t=c[q>>2]|0;c[f+(e<<4)>>2]=c[t+(e<<4)>>2];c[f+(e<<4)+4>>2]=c[t+(e<<4)+4>>2];c[f+(e<<4)+8>>2]=c[t+(e<<4)+8>>2];c[f+(e<<4)+12>>2]=c[t+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[q>>2]|0;if(d){if((a[p>>0]|0)!=0?(o=0,Ja(494,d|0),t=o,o=0,t&1):0)break;c[q>>2]=0}a[p>>0]=1;c[q>>2]=f;c[s>>2]=2;o=0;Ja(541,b|0);t=o;o=0;if(!(t&1))return}while(0);e=zc()|0;d=c[h>>2]|0;if(d){if((a[g>>0]|0)!=0?(o=0,Ja(494,d|0),t=o,o=0,t&1):0){t=zc(0)|0;Di(t)}c[h>>2]=0}a[g>>0]=1;c[h>>2]=0;c[i>>2]=0;c[j>>2]=0;d=c[l>>2]|0;if(d){if((a[k>>0]|0)!=0?(o=0,Ja(494,d|0),t=o,o=0,t&1):0){t=zc(0)|0;Di(t)}c[l>>2]=0}a[k>>0]=1;c[l>>2]=0;c[m>>2]=0;c[n>>2]=0;d=c[q>>2]|0;if(!d){a[p>>0]=1;c[q>>2]=0;c[r>>2]=0;c[s>>2]=0;Kc(e|0)}if((a[p>>0]|0)!=0?(o=0,Ja(494,d|0),t=o,o=0,t&1):0){t=zc(0)|0;Di(t)}c[q>>2]=0;a[p>>0]=1;c[q>>2]=0;c[r>>2]=0;c[s>>2]=0;Kc(e|0)}function LW(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=b+12|0;l=c[m>>2]|0;j=b+36|0;n=c[j>>2]|0;if((l|0)<=(n|0))return;if((l|0)>=(n|0)){i=b+40|0;do if((c[i>>2]|0)<(l|0)){if(!l){d=0;e=n}else{d=l5(l<<2,16)|0;e=c[j>>2]|0}g=b+44|0;h=c[g>>2]|0;if((e|0)<=0){if(!h){a[b+48>>0]=1;c[g>>2]=d;c[i>>2]=l;break}}else{f=0;do{c[d+(f<<2)>>2]=c[h+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}e=b+48|0;if(a[e>>0]|0)m5(h);a[e>>0]=1;c[g>>2]=d;c[i>>2]=l}else d=c[b+44>>2]|0;while(0);M9(d+(n<<2)|0,0,l-n<<2|0)|0}c[j>>2]=l;j=b+56|0;k=c[j>>2]|0;if((l|0)>(k|0)){g=b+60|0;do if((c[g>>2]|0)<(l|0)){if(!l){d=0;e=k}else{d=l5(l<<2,16)|0;e=c[j>>2]|0}h=b+64|0;i=c[h>>2]|0;if((e|0)<=0){if(!i){a[b+68>>0]=1;c[h>>2]=d;c[g>>2]=l;break}}else{f=0;do{c[d+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}e=b+68|0;if(a[e>>0]|0)m5(i);a[e>>0]=1;c[h>>2]=d;c[g>>2]=l}else d=c[b+64>>2]|0;while(0);M9(d+(k<<2)|0,0,l-k<<2|0)|0}c[j>>2]=l;if((l|0)>0){M9(c[b+44>>2]|0,-1,l<<2|0)|0;M9(c[b+64>>2]|0,-1,l<<2|0)|0}if((n|0)<=0)return;f=c[b+16>>2]|0;g=c[b+44>>2]|0;d=c[b+64>>2]|0;e=0;do{b=c[(c[f+(e<<4)+4>>2]|0)+12>>2]<<16|c[(c[f+(e<<4)>>2]|0)+12>>2];b=b+~(b<<15)|0;b=(b>>10^b)*9|0;b=b>>6^b;b=b+~(b<<11)|0;b=g+(((b>>16^b)&(c[m>>2]|0)+-1)<<2)|0;c[d+(e<<2)>>2]=c[b>>2];c[b>>2]=e;e=e+1|0}while((e|0)!=(n|0));return}function MW(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;c[b>>2]=22512;e=b+56|0;f=b+64|0;g=c[f>>2]|0;d=b+68|0;do if(!g)i=5;else{if((a[d>>0]|0)!=0?(o=0,Ja(494,g|0),h=o,o=0,h&1):0){h=zc()|0;e=b+36|0;f=b+44|0;g=c[f>>2]|0;d=b+48|0;if(g){if((a[d>>0]|0)!=0?(o=0,Ja(494,g|0),g=o,o=0,g&1):0){g=zc(0)|0;Di(g)}c[f>>2]=0}a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;c[b+40>>2]=0;break}c[f>>2]=0;i=5}while(0);do if((i|0)==5){a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;c[b+60>>2]=0;g=b+36|0;e=b+44|0;f=c[e>>2]|0;d=b+48|0;if(f){if((a[d>>0]|0)!=0?(o=0,Ja(494,f|0),i=o,o=0,i&1):0){h=zc()|0;break}c[e>>2]=0}a[d>>0]=1;c[e>>2]=0;c[g>>2]=0;c[b+40>>2]=0;e=b+8|0;f=b+16|0;g=c[f>>2]|0;d=b+20|0;if(!g){a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;b=b+12|0;c[b>>2]=0;return}if((a[d>>0]|0)!=0?(o=0,Ja(494,g|0),i=o,o=0,i&1):0){b=zc()|0;Kc(b|0)}c[f>>2]=0;a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;b=b+12|0;c[b>>2]=0;return}while(0);e=b+8|0;f=b+16|0;g=c[f>>2]|0;d=b+20|0;if(g){if((a[d>>0]|0)!=0?(o=0,Ja(494,g|0),i=o,o=0,i&1):0){i=zc(0)|0;Di(i)}c[f>>2]=0}a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;c[b+12>>2]=0;b=h;Kc(b|0)}function NW(a){a=a|0;var b=0;o=0;Ja(252,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function OW(a,b,d){a=a|0;b=b|0;d=d|0;b=b+8|0;a=c[b>>2]|0;if(!((d|0)!=0&(a|0)!=0))return;Kf[c[c[a>>2]>>2]&1023](a);of[c[(c[d>>2]|0)+60>>2]&511](d,c[b>>2]|0);c[b>>2]=0;return}function PW(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=22588;c[f+4>>2]=b;c[f+8>>2]=a;c[f+12>>2]=d;tg[c[(c[a>>2]|0)+48>>2]&255](a,f,d);i=e;return}function QW(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=22608;c[f+4>>2]=b;tg[c[(c[a>>2]|0)+48>>2]&255](a,f,d);i=e;return}function RW(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=b;f=d;c[5625]=(c[5625]|0)+1;b=(c[b+12>>2]|0)>(c[d+12>>2]|0);e=c[(b?f:g)+12>>2]|0;f=c[(b?g:f)+12>>2]|0;b=f<<16|e;b=b+~(b<<15)|0;b=(b>>10^b)*9|0;b=b>>6^b;b=b+~(b<<11)|0;b=(b>>16^b)&(c[a+12>>2]|0)+-1;if((b|0)>=(c[a+36>>2]|0)){h=0;return h|0}b=c[(c[a+44>>2]|0)+(b<<2)>>2]|0;if((b|0)==-1){h=0;return h|0}g=c[a+16>>2]|0;d=a+64|0;while(1){if((c[(c[g+(b<<4)>>2]|0)+12>>2]|0)==(e|0)?(c[(c[g+(b<<4)+4>>2]|0)+12>>2]|0)==(f|0):0)break;b=c[(c[d>>2]|0)+(b<<2)>>2]|0;if((b|0)==-1){b=0;h=8;break}}if((h|0)==8)return b|0;h=g+(b<<4)|0;return h|0}function SW(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;q=d;p=e;f=(c[d+12>>2]|0)>(c[e+12>>2]|0);s=f?p:q;t=s+12|0;h=c[t>>2]|0;p=f?q:p;q=p+12|0;f=c[q>>2]|0;m=f<<16|h;m=m+~(m<<15)|0;m=(m>>10^m)*9|0;m=m>>6^m;m=m+~(m<<11)|0;m=m>>16^m;n=b+12|0;o=c[n>>2]|0;d=m&o+-1;r=b+44|0;e=c[(c[r>>2]|0)+(d<<2)>>2]|0;a:do if((e|0)!=-1){i=c[b+16>>2]|0;g=b+64|0;while(1){if((c[(c[i+(e<<4)>>2]|0)+12>>2]|0)==(h|0)?(c[(c[i+(e<<4)+4>>2]|0)+12>>2]|0)==(f|0):0)break;e=c[(c[g>>2]|0)+(e<<2)>>2]|0;if((e|0)==-1)break a}e=i+(e<<4)|0;if(e){b=e;return b|0}}while(0);k=b+8|0;l=c[k>>2]|0;if((l|0)==(o|0)){h=(o|0)!=0?o<<1:1;if((o|0)<(h|0)){if(!h){i=0;e=o}else{i=l5(h<<4,16)|0;e=c[k>>2]|0}j=b+16|0;if((e|0)>0){f=0;do{g=c[j>>2]|0;c[i+(f<<4)>>2]=c[g+(f<<4)>>2];c[i+(f<<4)+4>>2]=c[g+(f<<4)+4>>2];c[i+(f<<4)+8>>2]=c[g+(f<<4)+8>>2];c[i+(f<<4)+12>>2]=c[g+(f<<4)+12>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[j>>2]|0;g=b+20|0;if(f){if(a[g>>0]|0){m5(f);e=c[k>>2]|0}c[j>>2]=0}a[g>>0]=1;c[j>>2]=i;c[n>>2]=h}else{h=o;e=o}}else{h=o;e=l}c[k>>2]=e+1;f=c[b+16>>2]|0;g=f+(l<<4)|0;e=c[b+72>>2]|0;if(!e)e=h;else{If[c[(c[e>>2]|0)+8>>2]&127](e,s,p)|0;e=c[n>>2]|0}if((o|0)<(e|0)){LW(b);d=(c[n>>2]|0)+-1&m}t=(c[t>>2]|0)<(c[q>>2]|0);c[g>>2]=t?s:p;c[f+(l<<4)+4>>2]=t?p:s;t=f+(l<<4)+8|0;c[t>>2]=0;c[t+4>>2]=0;t=(c[r>>2]|0)+(d<<2)|0;c[(c[b+64>>2]|0)+(l<<2)>>2]=c[t>>2];c[t>>2]=l;b=g;return b|0}function TW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;f=b;i=d;c[5623]=(c[5623]|0)+1;h=(c[b+12>>2]|0)>(c[d+12>>2]|0);m=h?i:f;d=c[m+12>>2]|0;i=h?f:i;f=c[i+12>>2]|0;h=f<<16|d;h=h+~(h<<15)|0;h=(h>>10^h)*9|0;h=h>>6^h;h=h+~(h<<11)|0;n=a+12|0;h=(h>>16^h)&(c[n>>2]|0)+-1;q=a+44|0;b=c[(c[q>>2]|0)+(h<<2)>>2]|0;if((b|0)==-1){s=0;return s|0}l=a+16|0;g=c[l>>2]|0;r=a+64|0;while(1){if((c[(c[g+(b<<4)>>2]|0)+12>>2]|0)==(d|0)?(c[(c[g+(b<<4)+4>>2]|0)+12>>2]|0)==(f|0):0)break;b=c[(c[r>>2]|0)+(b<<2)>>2]|0;if((b|0)==-1){b=0;s=24;break}}if((s|0)==24)return b|0;d=g+(b<<4)|0;if(!d){s=0;return s|0}tg[c[(c[a>>2]|0)+32>>2]&255](a,d,e);p=c[g+(b<<4)+12>>2]|0;o=d-(c[l>>2]|0)>>4;g=(c[q>>2]|0)+(h<<2)|0;b=c[g>>2]|0;f=c[r>>2]|0;if((b|0)!=(o|0)){while(1){d=c[f+(b<<2)>>2]|0;if((d|0)==(o|0)){d=b;break}else b=d}b=c[f+(o<<2)>>2]|0;if((d|0)==-1)s=12;else c[f+(d<<2)>>2]=b}else{b=c[f+(o<<2)>>2]|0;s=12}if((s|0)==12)c[g>>2]=b;j=a+8|0;k=(c[j>>2]|0)+-1|0;b=c[a+72>>2]|0;if(b)qg[c[(c[b>>2]|0)+12>>2]&63](b,m,i,e)|0;if((k|0)==(o|0)){c[j>>2]=(c[j>>2]|0)+-1;s=p;return s|0}i=c[l>>2]|0;g=c[(c[i+(k<<4)+4>>2]|0)+12>>2]<<16|c[(c[i+(k<<4)>>2]|0)+12>>2];g=g+~(g<<15)|0;g=(g>>10^g)*9|0;g=g>>6^g;g=g+~(g<<11)|0;g=(g>>16^g)&(c[n>>2]|0)+-1;h=(c[q>>2]|0)+(g<<2)|0;b=c[h>>2]|0;f=c[r>>2]|0;if((b|0)!=(k|0)){while(1){d=c[f+(b<<2)>>2]|0;if((d|0)==(k|0)){d=b;break}else b=d}b=c[f+(k<<2)>>2]|0;if((d|0)==-1)s=22;else c[f+(d<<2)>>2]=b}else{b=c[f+(k<<2)>>2]|0;s=22}if((s|0)==22)c[h>>2]=b;s=i+(o<<4)|0;e=i+(k<<4)|0;c[s>>2]=c[e>>2];c[s+4>>2]=c[e+4>>2];c[s+8>>2]=c[e+8>>2];c[s+12>>2]=c[e+12>>2];s=(c[q>>2]|0)+(g<<2)|0;c[(c[r>>2]|0)+(o<<2)>>2]=c[s>>2];c[s>>2]=o;c[j>>2]=(c[j>>2]|0)+-1;s=p;return s|0}function UW(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=a+8|0;if((c[e>>2]|0)<=0)return;f=a+16|0;i=0;a:while(1){while(1){g=c[f>>2]|0;h=g+(i<<4)|0;if(!(dg[c[(c[b>>2]|0)+8>>2]&127](b,h)|0))break;qg[c[(c[a>>2]|0)+12>>2]&63](a,c[h>>2]|0,c[g+(i<<4)+4>>2]|0,d)|0;c[5622]=(c[5622]|0)+-1;if((i|0)>=(c[e>>2]|0)){e=7;break a}}i=i+1|0;if((i|0)>=(c[e>>2]|0)){e=7;break}}if((e|0)==7)return}function VW(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;u=i;i=i+32|0;s=u;r=u+20|0;v=s+16|0;a[v>>0]=1;w=s+12|0;c[w>>2]=0;t=s+4|0;c[t>>2]=0;m=s+8|0;c[m>>2]=0;n=b+8|0;f=c[n>>2]|0;a:do if((f|0)>0){p=b+16|0;e=0;g=f;f=0;l=0;while(1){j=c[p>>2]|0;k=j+(l<<4)|0;if((e|0)==(f|0)){h=(f|0)!=0?f<<1:1;if((f|0)<(h|0)){if(!h)e=0;else{o=0;e=cb(77,h<<4|0,16)|0;g=o;o=0;if(g&1){q=21;break}f=c[t>>2]|0}if((f|0)>0){g=0;do{x=c[w>>2]|0;c[e+(g<<4)>>2]=c[x+(g<<4)>>2];c[e+(g<<4)+4>>2]=c[x+(g<<4)+4>>2];c[e+(g<<4)+8>>2]=c[x+(g<<4)+8>>2];c[e+(g<<4)+12>>2]=c[x+(g<<4)+12>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[w>>2]|0;if(g){if(a[v>>0]|0){o=0;Ja(494,g|0);x=o;o=0;if(x&1){q=21;break}f=c[t>>2]|0}c[w>>2]=0}a[v>>0]=1;c[w>>2]=e;c[m>>2]=h;g=c[n>>2]|0}else h=f}else{h=f;f=e}e=c[w>>2]|0;c[e+(f<<4)>>2]=c[k>>2];c[e+(f<<4)+4>>2]=c[j+(l<<4)+4>>2];c[e+(f<<4)+8>>2]=c[j+(l<<4)+8>>2];c[e+(f<<4)+12>>2]=c[j+(l<<4)+12>>2];e=f+1|0;c[t>>2]=e;l=l+1|0;if((l|0)>=(g|0))break;else f=h}if((q|0)==21){f=zc()|0;break}if((f|0)>-1){f=0;while(1){x=c[w>>2]|0;o=0;pb(c[(c[b>>2]|0)+12>>2]|0,b|0,c[x+(f<<4)>>2]|0,c[x+(f<<4)+4>>2]|0,d|0)|0;x=o;o=0;if(x&1)break;f=f+1|0;e=c[t>>2]|0;if((f|0)>=(e|0)){q=26;break a}}f=zc()|0}else q=26}else{e=0;q=26}while(0);b:do if((q|0)==26){g=b+56|0;if((c[g>>2]|0)>0){e=c[b+64>>2]|0;f=0;do{c[e+(f<<2)>>2]=-1;f=f+1|0}while((f|0)<(c[g>>2]|0));e=c[t>>2]|0}if((e|0)>1){xW(s,r,0,e+-1|0);e=c[t>>2]|0}c:do if((e|0)>0){e=0;while(1){x=c[w>>2]|0;o=0;Ha(c[(c[b>>2]|0)+8>>2]|0,b|0,c[x+(e<<4)>>2]|0,c[x+(e<<4)+4>>2]|0)|0;x=o;o=0;if(x&1)break;e=e+1|0;if((e|0)>=(c[t>>2]|0))break c}f=zc()|0;break b}while(0);e=c[w>>2]|0;if(!e){i=u;return}if(a[v>>0]|0)m5(e);c[w>>2]=0;i=u;return}while(0);e=c[w>>2]|0;if(!e)Kc(f|0);if((a[v>>0]|0)!=0?(o=0,Ja(494,e|0),x=o,o=0,x&1):0){x=zc(0)|0;Di(x)}c[w>>2]=0;Kc(f|0)}function WW(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;c[5624]=(c[5624]|0)+1;f=c[a+24>>2]|0;if(!f){if(!((b[e+6>>1]&b[d+4>>1])<<16>>16)){a=0;return a|0}if(!((b[d+6>>1]&b[e+4>>1])<<16>>16)){a=0;return a|0}}else if(!(If[c[(c[f>>2]|0)+8>>2]&127](f,d,e)|0)){a=0;return a|0}a=SW(a,d,e)|0;return a|0}function XW(a){a=a|0;return c[a+16>>2]|0}function YW(a){a=a|0;return c[a+16>>2]|0}function ZW(a){a=a|0;return a+4|0}function _W(a){a=a|0;return c[a+8>>2]|0}function $W(a,b){a=a|0;b=b|0;c[a+24>>2]=b;return}function aX(a){a=a|0;return 0}function bX(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function cX(a){a=a|0;return}function dX(a){a=a|0;$5(a);return}function eX(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;return ((c[b>>2]|0)==(a|0)?1:(c[b+4>>2]|0)==(a|0))|0}function fX(a){a=a|0;$5(a);return}function gX(a,b){a=a|0;b=b|0;var d=0;d=c[a+4>>2]|0;if((c[b>>2]|0)!=(d|0)?(c[b+4>>2]|0)!=(d|0):0)return 0;d=c[a+8>>2]|0;tg[c[(c[d>>2]|0)+32>>2]&255](d,b,c[a+12>>2]|0);return 0}function hX(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c[b>>2]=22632;c[b+4>>2]=2;h=b+24|0;a[h>>0]=1;i=b+20|0;c[i>>2]=0;j=b+12|0;c[j>>2]=0;k=b+16|0;c[k>>2]=0;c[b+28>>2]=23512;g=b+5256|0;c[g>>2]=d;c[b+60>>2]=173;o=0;e=qa(c[(c[d>>2]|0)+12>>2]|0,d|0)|0;l=o;o=0;do if(!(l&1)?(c[b+64>>2]=e,o=0,f=qa(c[(c[d>>2]|0)+8>>2]|0,d|0)|0,l=o,o=0,!(l&1)):0){c[b+68>>2]=f;f=0;a:while(1){d=0;do{e=c[g>>2]|0;o=0;e=Ha(c[(c[e>>2]|0)+16>>2]|0,e|0,f|0,d|0)|0;l=o;o=0;if(l&1){e=7;break a}c[b+72+(f*144|0)+(d<<2)>>2]=e;d=d+1|0}while((d|0)<36);f=f+1|0;if((f|0)>=36){e=14;break}}if((e|0)==7){f=zc()|0;break}else if((e|0)==14)return}else e=8;while(0);if((e|0)==8)f=zc()|0;e=c[i>>2]|0;if(e){if((a[h>>0]|0)!=0?(o=0,Ja(494,e|0),l=o,o=0,l&1):0){l=zc(0)|0;Di(l)}c[i>>2]=0}a[h>>0]=1;c[i>>2]=0;c[j>>2]=0;c[k>>2]=0;o=0;l=o;o=0;if(l&1){l=zc(0)|0;Di(l)}else Kc(f|0)}function iX(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+80|0;k=m+56|0;l=m+32|0;j=m;f=c[c[a>>2]>>2]|0;h=c[c[a+4>>2]>>2]|0;if(!(If[c[(c[b>>2]|0)+24>>2]&127](b,f,h)|0)){i=m;return}n=c[f+192>>2]|0;c[k>>2]=0;c[k+4>>2]=n;c[k+8>>2]=f;c[k+12>>2]=f+4;c[k+16>>2]=-1;c[k+20>>2]=-1;n=c[h+192>>2]|0;c[l>>2]=0;c[l+4>>2]=n;c[l+8>>2]=h;c[l+12>>2]=h+4;c[l+16>>2]=-1;c[l+20>>2]=-1;a=a+8|0;if((c[a>>2]|0)==0?(n=qg[c[(c[b>>2]|0)+8>>2]&63](b,k,l,0)|0,c[a>>2]=n,(n|0)==0):0){i=m;return}OZ(j,k,l);a=c[a>>2]|0;if((c[d+8>>2]|0)==1){ff[c[(c[a>>2]|0)+8>>2]&31](a,k,l,d,j);i=m;return}e=+Gf[c[(c[a>>2]|0)+12>>2]&15](a,f,h,d,j);a=d+12|0;if(!(+g[a>>2]>e)){i=m;return}g[a>>2]=e;i=m;return}function jX(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=22632;f=b+12|0;g=b+20|0;d=c[g>>2]|0;e=b+24|0;if(!d){a[e>>0]=1;c[g>>2]=0;c[f>>2]=0;b=b+16|0;c[b>>2]=0;return}if((a[e>>0]|0)!=0?(o=0,Ja(494,d|0),d=o,o=0,d&1):0){d=zc()|0;o=0;h=o;o=0;if(h&1){h=zc(0)|0;Di(h)}else Kc(d|0)}c[g>>2]=0;a[e>>0]=1;c[g>>2]=0;c[f>>2]=0;h=b+16|0;c[h>>2]=0;return}function kX(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=22632;f=b+12|0;g=b+20|0;d=c[g>>2]|0;e=b+24|0;if(d){if((a[e>>0]|0)!=0?(o=0,Ja(494,d|0),d=o,o=0,d&1):0){d=zc()|0;o=0;h=o;o=0;if(h&1){h=zc(0)|0;Di(h)}else{h=d;$5(b);Kc(h|0)}}c[g>>2]=0}a[e>>0]=1;c[g>>2]=0;c[f>>2]=0;c[b+16>>2]=0;o=0;h=o;o=0;if(!(h&1)){$5(b);return}h=zc()|0;$5(b);Kc(h|0)}function lX(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0.0;q=i;i=i+16|0;f=q+4|0;h=q;c[5655]=(c[5655]|0)+1;m=b+4|0;if(!(c[m>>2]&2))f=25960;else{o=c[d+192>>2]|0;r=+lg[c[(c[o>>2]|0)+20>>2]&1](o,+g[6490]);g[f>>2]=r;o=c[e+192>>2]|0;l=+lg[c[(c[o>>2]|0)+20>>2]&1](o,+g[6490]);g[h>>2]=l;f=r<l?f:h}k=c[f>>2]|0;r=+g[d+184>>2];l=+g[e+184>>2];l=r<l?r:l;f=c[b+68>>2]|0;h=f+8|0;j=c[h>>2]|0;do if(!j)if(!(c[m>>2]&4)){o=l5(772,16)|0;break}else{b=0;i=q;return b|0}else{n=f+12|0;o=c[n>>2]|0;c[n>>2]=c[o>>2];c[h>>2]=j+-1}while(0);c[o>>2]=1025;c[o+116>>2]=0;a[o+120>>0]=0;n=o+124|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[o+300>>2]=0;a[o+304>>0]=0;n=o+308|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[o+484>>2]=0;a[o+488>>0]=0;n=o+492|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[o+668>>2]=0;a[o+672>>0]=0;n=o+676|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[o+740>>2]=d;c[o+744>>2]=e;c[o+748>>2]=0;c[o+752>>2]=k;g[o+756>>2]=l;e=o;n=b+12|0;f=c[n>>2]|0;c[o+768>>2]=f;d=b+16|0;if((f|0)==(c[d>>2]|0)?(p=(f|0)!=0?f<<1:1,(f|0)<(p|0)):0){if(!p)m=0;else{m=l5(p<<2,16)|0;f=c[n>>2]|0}k=b+20|0;if((f|0)>0){h=0;do{c[m+(h<<2)>>2]=c[(c[k>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}h=c[k>>2]|0;j=b+24|0;if(h){if(a[j>>0]|0){m5(h);f=c[n>>2]|0}c[k>>2]=0}a[j>>0]=1;c[k>>2]=m;c[d>>2]=p}c[(c[b+20>>2]|0)+(f<<2)>>2]=e;c[n>>2]=f+1;b=o;i=q;return b|0}function mX(a,b){a=a|0;b=b|0;var d=0;a=b+748|0;if((c[a>>2]|0)>0)d=0;else{c[a>>2]=0;return}do{O1(b,b+4+(d*184|0)|0);d=d+1|0}while((d|0)<(c[a>>2]|0));c[a>>2]=0;return}function nX(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c[5655]=(c[5655]|0)+-1;of[c[(c[a>>2]|0)+20>>2]&511](a,b);g=c[b+768>>2]|0;e=a+12|0;f=(c[e>>2]|0)+-1|0;h=a+20|0;k=c[h>>2]|0;j=k+(g<<2)|0;i=c[j>>2]|0;c[j>>2]=c[k+(f<<2)>>2];c[(c[h>>2]|0)+(f<<2)>>2]=i;c[(c[(c[h>>2]|0)+(g<<2)>>2]|0)+768>>2]=g;c[e>>2]=f;a=c[a+68>>2]|0;if(((b|0)!=0?(d=c[a+16>>2]|0,d>>>0<=b>>>0):0)?(d+($(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){k=a+12|0;c[b>>2]=c[k>>2];c[k>>2]=b;k=a+8|0;c[k>>2]=(c[k>>2]|0)+1;return}m5(b);return}function oX(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=a;c[g+4>>2]=e;a=c[a+72+((c[(c[b+4>>2]|0)+4>>2]|0)*144|0)+(c[(c[d+4>>2]|0)+4>>2]<<2)>>2]|0;a=qg[c[(c[a>>2]|0)+8>>2]&63](a,g,b,d)|0;i=f;return a|0}function pX(a,b,d){a=a|0;b=b|0;d=d|0;a=c[b+204>>2]|0;if(a&4){d=0;return d|0}b=c[d+204>>2]|0;if(b&4){d=0;return d|0}if(!(a&3)){d=1;return d|0}d=(b&3|0)==0;return d|0}function qX(a,b,d){a=a|0;b=b|0;d=d|0;a:do switch(c[b+216>>2]|0){case 2:case 5:{switch(c[d+216>>2]|0){case 2:case 5:{b=0;break}default:break a}return b|0}default:{}}while(0);if(!(c[b+256>>2]|0)){a=1;return a|0}a=dg[c[c[b>>2]>>2]&127](b,d)|0;return a|0}function rX(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=22704;c[g+4>>2]=d;c[g+8>>2]=a;tg[c[(c[b>>2]|0)+48>>2]&255](b,g,e);i=f;return}function sX(a,b){a=a|0;b=b|0;var d=0,e=0;a=c[a+64>>2]|0;d=a+8|0;e=c[d>>2]|0;if(!e){b=l5(b,16)|0;return b|0}else{a=a+12|0;b=c[a>>2]|0;c[a>>2]=c[b>>2];c[d>>2]=e+-1;return b|0}return 0}function tX(a,b){a=a|0;b=b|0;var d=0;a=c[a+64>>2]|0;if(((b|0)!=0?(d=c[a+16>>2]|0,d>>>0<=b>>>0):0)?(d+($(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){d=a+12|0;c[b>>2]=c[d>>2];c[d>>2]=b;b=a+8|0;c[b>>2]=(c[b>>2]|0)+1;return}m5(b);return}function uX(a){a=a|0;return c[a+12>>2]|0}function vX(a,b){a=a|0;b=b|0;return c[(c[a+20>>2]|0)+(b<<2)>>2]|0}function wX(a){a=a|0;if(!(c[a+12>>2]|0)){a=0;return a|0}a=c[a+20>>2]|0;return a|0}function xX(a){a=a|0;return c[a+68>>2]|0}function yX(a){a=a|0;return c[a+68>>2]|0}function zX(a){a=a|0;$5(a);return}function AX(a,b){a=a|0;b=b|0;var d=0;d=c[a+8>>2]|0;tg[c[d+60>>2]&255](b,d,c[a+4>>2]|0);return 0}function BX(a){a=a|0;var b=0;c[a>>2]=22724;c[a+164>>2]=1065353216;c[a+168>>2]=1065353216;c[a+172>>2]=1065353216;g[a+176>>2]=0.0;c[a+180>>2]=0;g[a+184>>2]=999999984306749440.0;b=a+188|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[a+204>>2]=1;c[a+208>>2]=-1;c[a+212>>2]=-1;c[a+216>>2]=1;g[a+220>>2]=0.0;g[a+224>>2]=.5;g[a+228>>2]=0.0;g[a+232>>2]=0.0;c[a+236>>2]=1;c[a+240>>2]=0;g[a+244>>2]=1.0;b=a+248|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[a+4>>2]=1065353216;b=a+8|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[a+24>>2]=1065353216;b=a+28|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[a+44>>2]=1065353216;a=a+48|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;return}function CX(a){a=a|0;return}function DX(a){a=a|0;m5(a);return}function EX(a,b){a=a|0;b=b|0;a=a+216|0;if((c[a>>2]&-2|0)==4)return;c[a>>2]=b;return}function FX(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;b=a+216|0;if((c[b>>2]&-2|0)!=4)c[b>>2]=1;g[a+220>>2]=0.0;return}function GX(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[b+16>>2]=c[a+4>>2];c[b+20>>2]=c[a+8>>2];c[b+24>>2]=c[a+12>>2];c[b+28>>2]=c[a+16>>2];c[b+32>>2]=c[a+20>>2];c[b+36>>2]=c[a+24>>2];c[b+40>>2]=c[a+28>>2];c[b+44>>2]=c[a+32>>2];c[b+48>>2]=c[a+36>>2];c[b+52>>2]=c[a+40>>2];c[b+56>>2]=c[a+44>>2];c[b+60>>2]=c[a+48>>2];c[b+64>>2]=c[a+52>>2];c[b+68>>2]=c[a+56>>2];c[b+72>>2]=c[a+60>>2];c[b+76>>2]=c[a+64>>2];c[b+80>>2]=c[a+68>>2];c[b+84>>2]=c[a+72>>2];c[b+88>>2]=c[a+76>>2];c[b+92>>2]=c[a+80>>2];c[b+96>>2]=c[a+84>>2];c[b+100>>2]=c[a+88>>2];c[b+104>>2]=c[a+92>>2];c[b+108>>2]=c[a+96>>2];c[b+112>>2]=c[a+100>>2];c[b+116>>2]=c[a+104>>2];c[b+120>>2]=c[a+108>>2];c[b+124>>2]=c[a+112>>2];c[b+128>>2]=c[a+116>>2];c[b+132>>2]=c[a+120>>2];c[b+136>>2]=c[a+124>>2];c[b+140>>2]=c[a+128>>2];c[b+144>>2]=c[a+132>>2];c[b+148>>2]=c[a+136>>2];c[b+152>>2]=c[a+140>>2];c[b+156>>2]=c[a+144>>2];c[b+160>>2]=c[a+148>>2];c[b+164>>2]=c[a+152>>2];c[b+168>>2]=c[a+156>>2];c[b+172>>2]=c[a+160>>2];c[b+176>>2]=c[a+164>>2];c[b+180>>2]=c[a+168>>2];c[b+184>>2]=c[a+172>>2];c[b+188>>2]=c[a+176>>2];c[b+224>>2]=c[a+180>>2];c[b+192>>2]=c[a+184>>2];c[b>>2]=0;c[b+4>>2]=dg[c[(c[d>>2]|0)+28>>2]&127](d,c[a+192>>2]|0)|0;c[b+8>>2]=0;c[b+228>>2]=c[a+204>>2];c[b+232>>2]=c[a+208>>2];c[b+236>>2]=c[a+212>>2];c[b+240>>2]=c[a+216>>2];c[b+196>>2]=c[a+220>>2];c[b+200>>2]=c[a+224>>2];c[b+204>>2]=c[a+232>>2];c[b+208>>2]=c[a+228>>2];c[b+244>>2]=c[a+236>>2];e=dg[c[(c[d>>2]|0)+40>>2]&127](d,a)|0;f=dg[c[(c[d>>2]|0)+28>>2]&127](d,e)|0;c[b+12>>2]=f;if(!f){d=a+244|0;d=c[d>>2]|0;f=b+212|0;c[f>>2]=d;f=a+248|0;f=c[f>>2]|0;d=b+216|0;c[d>>2]=f;d=a+252|0;d=c[d>>2]|0;f=b+220|0;c[f>>2]=d;a=a+256|0;a=c[a>>2]|0;f=b+248|0;c[f>>2]=a;return 65183}of[c[(c[d>>2]|0)+48>>2]&511](d,e);d=a+244|0;d=c[d>>2]|0;f=b+212|0;c[f>>2]=d;f=a+248|0;f=c[f>>2]|0;d=b+216|0;c[d>>2]=f;d=a+252|0;d=c[d>>2]|0;f=b+220|0;c[f>>2]=d;a=a+256|0;a=c[a>>2]|0;f=b+248|0;c[f>>2]=a;return 65183}function HX(a,b){a=a|0;b=b|0;var d=0,e=0;e=rf[c[(c[a>>2]|0)+16>>2]&255](a)|0;e=If[c[(c[b>>2]|0)+16>>2]&127](b,e,1)|0;d=If[c[(c[a>>2]|0)+20>>2]&127](a,c[e+8>>2]|0,b)|0;ff[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1245859651,a);return}function IX(a,b){a=a|0;b=b|0;return 1}function JX(a){a=a|0;return 256}function KX(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;c[b>>2]=22760;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+24>>2]=d;g[b+28>>2]=0.0;c[b+32>>2]=0;c[b+36>>2]=1;g[b+40>>2]=1.0;a[b+44>>0]=1;c[b+48>>2]=0;a[b+52>>0]=0;a[b+53>>0]=1;a[b+54>>0]=1;g[b+56>>2]=.03999999910593033;a[b+60>>0]=0;g[b+64>>2]=0.0;c[b+68>>2]=e;c[b+72>>2]=0;a[b+76>>0]=1;return}function LX(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c[b>>2]=22760;k=b+8|0;e=c[k>>2]|0;l=b+16|0;d=c[l>>2]|0;a:do if((e|0)>0){i=b+68|0;j=b+24|0;h=0;while(1){f=(c[d+(h<<2)>>2]|0)+188|0;g=c[f>>2]|0;if(g){d=c[i>>2]|0;o=0;d=qa(c[(c[d>>2]|0)+36>>2]|0,d|0)|0;e=o;o=0;if(e&1)break;o=0;sb(c[(c[d>>2]|0)+40>>2]|0,d|0,g|0,c[j>>2]|0);e=o;o=0;if(e&1)break;e=c[i>>2]|0;o=0;sb(c[(c[e>>2]|0)+12>>2]|0,e|0,g|0,c[j>>2]|0);g=o;o=0;if(g&1)break;c[f>>2]=0;e=c[k>>2]|0;d=c[l>>2]|0}h=h+1|0;if((h|0)>=(e|0))break a}e=zc()|0;f=c[l>>2]|0;d=b+20|0;if(!f){a[d>>0]=1;c[l>>2]=0;c[k>>2]=0;b=b+12|0;c[b>>2]=0;Kc(e|0)}if((a[d>>0]|0)!=0?(o=0,Ja(494,f|0),j=o,o=0,j&1):0){j=zc(0)|0;Di(j)}c[l>>2]=0;a[d>>0]=1;c[l>>2]=0;c[k>>2]=0;b=b+12|0;c[b>>2]=0;Kc(e|0)}while(0);e=b+20|0;if(!d){a[e>>0]=1;c[l>>2]=0;c[k>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[e>>0]|0)m5(d);c[l>>2]=0;a[e>>0]=1;c[l>>2]=0;c[k>>2]=0;b=b+12|0;c[b>>2]=0;return}function MX(a){a=a|0;var b=0;o=0;Ja(262,a|0);b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function NX(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+96|0;s=t+32|0;r=t+16|0;q=t;o=d;p=b+8|0;g=c[p>>2]|0;m=b+12|0;if((g|0)==(c[m>>2]|0)?(n=(g|0)!=0?g<<1:1,(g|0)<(n|0)):0){if(!n)l=0;else{l=l5(n<<2,16)|0;g=c[p>>2]|0}k=b+16|0;if((g|0)>0){h=0;do{c[l+(h<<2)>>2]=c[(c[k>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[k>>2]|0;j=b+20|0;if(h){if(a[j>>0]|0){m5(h);g=c[p>>2]|0}c[k>>2]=0}a[j>>0]=1;c[k>>2]=l;c[m>>2]=n}c[(c[b+16>>2]|0)+(g<<2)>>2]=o;c[p>>2]=g+1;p=d+4|0;c[s>>2]=c[p>>2];c[s+4>>2]=c[p+4>>2];c[s+8>>2]=c[p+8>>2];c[s+12>>2]=c[p+12>>2];p=s+16|0;o=d+20|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];p=s+32|0;o=d+36|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];p=s+48|0;o=d+52|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];p=d+192|0;o=c[p>>2]|0;zg[c[(c[o>>2]|0)+8>>2]&127](o,s,r,q);s=c[b+68>>2]|0;c[d+188>>2]=mf[c[(c[s>>2]|0)+8>>2]&3](s,r,q,c[(c[p>>2]|0)+4>>2]|0,d,e,f,c[b+24>>2]|0,0)|0;i=t;return}function OX(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+64|0;w=x+48|0;v=x+32|0;r=x+16|0;u=x;e=d+192|0;f=c[e>>2]|0;zg[c[(c[f>>2]|0)+8>>2]&127](f,d+4|0,w,v);p=+g[6490];m=+g[w>>2]-p;g[w>>2]=m;f=w+4|0;l=+g[f>>2]-p;g[f>>2]=l;q=w+8|0;j=+g[q>>2]-p;g[q>>2]=j;n=p+ +g[v>>2];g[v>>2]=n;s=v+4|0;k=p+ +g[s>>2];g[s>>2]=k;t=v+8|0;h=p+ +g[t>>2];g[t>>2]=h;if(((a[b+44>>0]|0)!=0?(c[d+236>>2]|0)==2:0)?(c[d+204>>2]&3|0)==0:0){e=c[e>>2]|0;zg[c[(c[e>>2]|0)+8>>2]&127](e,d+68|0,r,u);m=+g[r>>2]-p;g[r>>2]=m;e=r+4|0;l=+g[e>>2]-p;g[e>>2]=l;e=r+8|0;o=+g[e>>2]-p;g[e>>2]=o;n=p+ +g[u>>2];g[u>>2]=n;e=u+4|0;k=p+ +g[e>>2];g[e>>2]=k;e=u+8|0;h=p+ +g[e>>2];g[e>>2]=h;j=+g[w>>2];if(m<j)g[w>>2]=m;else m=j;j=+g[f>>2];if(l<j)g[f>>2]=l;else l=j;j=+g[q>>2];if(o<j)g[q>>2]=o;else o=j;e=w+12|0;j=+g[r+12>>2];if(j<+g[e>>2])g[e>>2]=j;j=+g[v>>2];if(j<n)g[v>>2]=n;else n=j;j=+g[s>>2];if(j<k)g[s>>2]=k;else k=j;j=+g[t>>2];if(j<h)g[t>>2]=h;else h=j;e=v+12|0;j=+g[u+12>>2];if(+g[e>>2]<j){g[e>>2]=j;j=o}else j=o}e=c[b+68>>2]|0;if((c[d+204>>2]&1|0)==0?(n=n-m,o=k-l,p=h-j,!(n*n+o*o+p*p<999999995904.0)):0){EX(d,5);if(!(a[65229]|0)){i=x;return}e=b+72|0;f=c[e>>2]|0;if(!f){i=x;return}a[65229]=0;of[c[(c[f>>2]|0)+36>>2]&511](f,65230);b=c[e>>2]|0;of[c[(c[b>>2]|0)+36>>2]&511](b,65279);b=c[e>>2]|0;of[c[(c[b>>2]|0)+36>>2]&511](b,65347);b=c[e>>2]|0;of[c[(c[b>>2]|0)+36>>2]&511](b,65412);i=x;return}ff[c[(c[e>>2]|0)+16>>2]&31](e,c[d+188>>2]|0,w,v,c[b+24>>2]|0);i=x;return}function PX(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;Q5(65421);g=b+8|0;d=c[g>>2]|0;if((d|0)<=0){R5();return}h=b+16|0;i=b+76|0;f=0;while(1){e=c[(c[h>>2]|0)+(f<<2)>>2]|0;if(!(a[i>>0]|0))switch(c[e+216>>2]|0){case 2:case 5:break;default:j=5}else j=5;if((j|0)==5){j=0;o=0;na(271,b|0,e|0);e=o;o=0;if(e&1)break;d=c[g>>2]|0}f=f+1|0;if((f|0)>=(d|0)){j=9;break}}if((j|0)==9){R5();return}d=zc()|0;o=0;tb(9);j=o;o=0;if(j&1){j=zc(0)|0;Di(j)}else Kc(d|0)}function QX(a){a=a|0;var b=0;Q5(65433);b=c[a+68>>2]|0;o=0;na(c[(c[b>>2]|0)+32>>2]|0,b|0,c[a+24>>2]|0);a=o;o=0;if(!(a&1)){R5();return}a=zc()|0;o=0;tb(9);b=o;o=0;if(b&1){b=zc(0)|0;Di(b)}else Kc(a|0)}function RX(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;Q5(65459);b=a+28|0;o=0;Ja(c[(c[a>>2]|0)+8>>2]|0,a|0);f=o;o=0;a:do if((!(f&1)?(o=0,Ja(c[(c[a>>2]|0)+12>>2]|0,a|0),f=o,o=0,!(f&1)):0)?(d=a+24|0,e=c[d>>2]|0,o=0,Ja(536,65493),f=o,o=0,!(f&1)):0){do if(e){f=c[(c[e>>2]|0)+32>>2]|0;a=c[a+68>>2]|0;o=0;a=qa(c[(c[a>>2]|0)+36>>2]|0,a|0)|0;h=o;o=0;if(!(h&1)?(o=0,yb(f|0,e|0,a|0,b|0,c[d>>2]|0),h=o,o=0,!(h&1)):0)break;a=zc()|0;o=0;tb(9);h=o;o=0;if(!(h&1))break a;h=zc(0)|0;Di(h)}while(0);o=0;tb(9);h=o;o=0;if(!(h&1)){R5();return}else g=7}else g=7;while(0);if((g|0)==7)a=zc()|0;o=0;tb(9);h=o;o=0;if(h&1){h=zc(0)|0;Di(h)}else Kc(a|0)}function SX(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=b+188|0;e=c[d>>2]|0;if(e){h=a+68|0;g=c[h>>2]|0;g=rf[c[(c[g>>2]|0)+36>>2]&255](g)|0;i=a+24|0;tg[c[(c[g>>2]|0)+40>>2]&255](g,e,c[i>>2]|0);h=c[h>>2]|0;tg[c[(c[h>>2]|0)+12>>2]&255](h,e,c[i>>2]|0);c[d>>2]=0}h=a+8|0;i=c[h>>2]|0;if((i|0)<=0)return;f=a+16|0;g=c[f>>2]|0;d=0;while(1){a=g+(d<<2)|0;e=c[a>>2]|0;if((e|0)==(b|0))break;d=d+1|0;if((d|0)>=(i|0)){j=9;break}}if((j|0)==9)return;if((d|0)>=(i|0))return;j=i+-1|0;c[a>>2]=c[g+(j<<2)>>2];c[(c[f>>2]|0)+(j<<2)>>2]=e;c[h>>2]=j;return}function TX(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0,R=0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0;R=i;i=i+1184|0;s=R+1120|0;A=R+944|0;t=R+584|0;u=R+448|0;r=R+312|0;B=R+160|0;H=R+144|0;I=R+128|0;F=R+464|0;G=R+328|0;L=R+112|0;J=R+96|0;O=R+192|0;N=R+80|0;M=R+64|0;C=R+32|0;p=R+16|0;q=R;J$(s);c[s>>2]=24520;c[s+4>>2]=8;g[s+28>>2]=0.0;g[s+44>>2]=0.0;Q=c[e+4>>2]|0;K=c[e+12>>2]|0;E=Q+4|0;j=c[E>>2]|0;a:do if((j|0)<20){c[A>>2]=22820;p=A+164|0;c[A+168>>2]=0;g[A+172>>2]=0.0;q=f+4|0;c[p>>2]=c[q>>2];g[t+308>>2]=9.999999747378752e-005;a[t+332>>0]=0;o=0;yb(81,u|0,s|0,Q|0,t|0);O=o;o=0;b:do if(!(O&1)){o=0;yb(82,r|0,s|0,Q|0,t|0);Q=o;o=0;c:do if(!(Q&1)){j=(c[f+16>>2]&4|0)==0?r:u;o=0;j=oa(c[(c[j>>2]|0)+8>>2]|0,j|0,b|0,d|0,K|0,K|0,A|0)|0;Q=o;o=0;do if(!(Q&1)){if(((j?(v=A+132|0,k=+g[v>>2],y=A+136|0,l=+g[y>>2],z=A+140|0,m=+g[z>>2],n=k*k+l*l+m*m,n>9.999999747378752e-005):0)?(w=+g[p>>2],w<+g[q>>2]):0)?(x=1.0/+P(+n),g[v>>2]=k*x,g[y>>2]=l*x,g[z>>2]=m*x,c[B>>2]=c[e+8>>2],c[B+4>>2]=0,Q=B+8|0,c[Q>>2]=c[v>>2],c[Q+4>>2]=c[v+4>>2],c[Q+8>>2]=c[v+8>>2],c[Q+12>>2]=c[v+12>>2],g[B+24>>2]=w,o=0,+Ka(c[(c[f>>2]|0)+12>>2]|0,f|0,B|0,1),Q=o,o=0,Q&1):0)break;o=0;Q=o;o=0;if(Q&1){D=7;break c}o=0;Q=o;o=0;if(Q&1)break b;i=R;return}while(0);j=zc()|0;o=0;R=o;o=0;if(R&1){R=zc(0)|0;Di(R)}else h=j}else D=7;while(0);if((D|0)==7)h=zc()|0;o=0;R=o;o=0;if(!(R&1))break a;R=zc(0)|0;Di(R)}while(0);h=zc()|0}else{if((j+-21|0)>>>0>=9){if((j|0)!=31){i=R;return}h=c[Q+64>>2]|0;O=c[e+8>>2]|0;c[C>>2]=22896;c[C+4>>2]=O;c[C+8>>2]=Q;c[C+12>>2]=K;c[C+16>>2]=b;c[C+20>>2]=d;c[C+24>>2]=f;do if(!h){h=c[Q+16>>2]|0;if((h|0)>0)j=0;else{i=R;return}while(1){o=0;na(272,C|0,j|0);Q=o;o=0;if(Q&1){D=53;break}j=j+1|0;if((j|0)>=(h|0)){D=59;break}}if((D|0)==53){h=zc()|0;break}else if((D|0)==59){i=R;return}}else{k=+g[K+48>>2];_=+g[b+48>>2]-k;m=+g[K+52>>2];Z=+g[b+52>>2]-m;w=+g[K+56>>2];Y=+g[b+56>>2]-w;X=+g[K>>2];W=+g[K+16>>2];V=+g[K+32>>2];U=+g[K+4>>2];T=+g[K+20>>2];S=+g[K+36>>2];l=+g[K+8>>2];n=+g[K+24>>2];x=+g[K+40>>2];g[p>>2]=_*X+Z*W+Y*V;g[p+4>>2]=_*U+Z*T+Y*S;g[p+8>>2]=_*l+Z*n+Y*x;g[p+12>>2]=0.0;k=+g[d+48>>2]-k;m=+g[d+52>>2]-m;w=+g[d+56>>2]-w;g[q>>2]=k*X+m*W+w*V;g[q+4>>2]=k*U+m*T+w*S;g[q+8>>2]=k*l+m*n+w*x;g[q+12>>2]=0.0;o=0;yb(85,c[h>>2]|0,p|0,q|0,C|0);Q=o;o=0;if(Q&1){h=zc()|0;break}else{i=R;return}}while(0);break}y=K+16|0;z=K+32|0;j=K+4|0;p=K+20|0;q=K+36|0;r=K+8|0;s=K+24|0;t=K+40|0;aa=+g[K>>2];$=+g[y>>2];S=+g[z>>2];U=+g[j>>2];V=+g[p>>2];W=+g[q>>2];Y=+g[r>>2];Z=+g[s>>2];_=+g[t>>2];u=K+48|0;m=-+g[u>>2];v=K+52|0;l=-+g[v>>2];h=K+56|0;X=-+g[h>>2];ba=aa*m+$*l+S*X;T=U*m+V*l+W*X;X=Y*m+Z*l+_*X;l=+g[b+48>>2];m=+g[b+52>>2];k=+g[b+56>>2];g[H>>2]=ba+(aa*l+$*m+S*k);g[H+4>>2]=T+(U*l+V*m+W*k);g[H+8>>2]=X+(Y*l+Z*m+_*k);g[H+12>>2]=0.0;w=+g[d+48>>2];x=+g[d+52>>2];n=+g[d+56>>2];g[I>>2]=ba+(aa*w+$*x+S*n);g[I+4>>2]=T+(U*w+V*x+W*n);g[I+8>>2]=X+(Y*w+Z*x+_*n);g[I+12>>2]=0.0;switch(c[E>>2]|0){case 21:{h=c[e+8>>2]|0;o=0;yb(83,F|0,H|0,I|0,c[f+16>>2]|0);O=o;o=0;if(!(O&1)){c[F>>2]=22848;c[F+44>>2]=f;c[F+48>>2]=h;c[F+52>>2]=Q;O=F+56|0;c[O>>2]=c[K>>2];c[O+4>>2]=c[K+4>>2];c[O+8>>2]=c[K+8>>2];c[O+12>>2]=c[K+12>>2];O=F+72|0;c[O>>2]=c[y>>2];c[O+4>>2]=c[y+4>>2];c[O+8>>2]=c[y+8>>2];c[O+12>>2]=c[y+12>>2];O=F+88|0;c[O>>2]=c[z>>2];c[O+4>>2]=c[z+4>>2];c[O+8>>2]=c[z+8>>2];c[O+12>>2]=c[z+12>>2];O=F+104|0;N=K+48|0;c[O>>2]=c[N>>2];c[O+4>>2]=c[N+4>>2];c[O+8>>2]=c[N+8>>2];c[O+12>>2]=c[N+12>>2];c[F+40>>2]=c[f+4>>2];o=0;yb(84,Q|0,F|0,H|0,I|0);Q=o;o=0;if(Q&1){h=zc()|0;o=0;Q=o;o=0;if(!(Q&1))break a;Q=zc(0)|0;Di(Q)}o=0;Q=o;o=0;if(!(Q&1)){i=R;return}}break}case 25:{h=c[e+8>>2]|0;o=0;yb(83,G|0,H|0,I|0,c[f+16>>2]|0);O=o;o=0;if(!(O&1)){c[G>>2]=22848;c[G+44>>2]=f;c[G+48>>2]=h;c[G+52>>2]=Q;O=G+56|0;c[O>>2]=c[K>>2];c[O+4>>2]=c[K+4>>2];c[O+8>>2]=c[K+8>>2];c[O+12>>2]=c[K+12>>2];O=G+72|0;c[O>>2]=c[y>>2];c[O+4>>2]=c[y+4>>2];c[O+8>>2]=c[y+8>>2];c[O+12>>2]=c[y+12>>2];O=G+88|0;c[O>>2]=c[z>>2];c[O+4>>2]=c[z+4>>2];c[O+8>>2]=c[z+8>>2];c[O+12>>2]=c[z+12>>2];O=G+104|0;N=K+48|0;c[O>>2]=c[N>>2];c[O+4>>2]=c[N+4>>2];c[O+8>>2]=c[N+8>>2];c[O+12>>2]=c[N+12>>2];c[G+40>>2]=c[f+4>>2];o=0;yb(c[(c[Q>>2]|0)+144>>2]|0,Q|0,G|0,H|0,I|0);Q=o;o=0;if(Q&1){h=zc()|0;o=0;Q=o;o=0;if(!(Q&1))break a;Q=zc(0)|0;Di(Q)}o=0;Q=o;o=0;if(!(Q&1)){i=R;return}}break}default:{T=+g[K>>2];U=+g[y>>2];V=+g[z>>2];X=+g[j>>2];Y=+g[p>>2];Z=+g[q>>2];$=+g[r>>2];aa=+g[s>>2];ba=+g[t>>2];da=-+g[u>>2];ca=-+g[v>>2];_=-+g[h>>2];S=T*da+U*ca+V*_;W=X*da+Y*ca+Z*_;_=$*da+aa*ca+ba*_;g[L>>2]=S+(T*l+U*m+V*k);g[L+4>>2]=W+(X*l+Y*m+Z*k);g[L+8>>2]=_+($*l+aa*m+ba*k);g[L+12>>2]=0.0;g[J>>2]=S+(T*w+U*x+V*n);j=J+4|0;g[j>>2]=W+(X*w+Y*x+Z*n);q=J+8|0;g[q>>2]=_+($*w+aa*x+ba*n);p=J+12|0;g[p>>2]=0.0;h=c[e+8>>2]|0;o=0;yb(83,O|0,L|0,J|0,c[f+16>>2]|0);e=o;o=0;if(!(e&1)){c[O>>2]=22872;c[O+44>>2]=f;c[O+48>>2]=h;c[O+52>>2]=Q;e=O+56|0;c[e>>2]=c[K>>2];c[e+4>>2]=c[K+4>>2];c[e+8>>2]=c[K+8>>2];c[e+12>>2]=c[K+12>>2];e=O+72|0;c[e>>2]=c[y>>2];c[e+4>>2]=c[y+4>>2];c[e+8>>2]=c[y+8>>2];c[e+12>>2]=c[y+12>>2];e=O+88|0;c[e>>2]=c[z>>2];c[e+4>>2]=c[z+4>>2];c[e+8>>2]=c[z+8>>2];c[e+12>>2]=c[z+12>>2];e=O+104|0;K=K+48|0;c[e>>2]=c[K>>2];c[e+4>>2]=c[K+4>>2];c[e+8>>2]=c[K+8>>2];c[e+12>>2]=c[K+12>>2];c[O+40>>2]=c[f+4>>2];c[N>>2]=c[L>>2];c[N+4>>2]=c[L+4>>2];c[N+8>>2]=c[L+8>>2];c[N+12>>2]=c[L+12>>2];m=+g[J>>2];if(m<+g[N>>2])g[N>>2]=m;h=N+4|0;n=+g[j>>2];if(n<+g[h>>2])g[h>>2]=n;h=N+8|0;l=+g[q>>2];if(l<+g[h>>2])g[h>>2]=l;h=N+12|0;k=+g[p>>2];if(k<+g[h>>2])g[h>>2]=k;c[M>>2]=c[L>>2];c[M+4>>2]=c[L+4>>2];c[M+8>>2]=c[L+8>>2];c[M+12>>2]=c[L+12>>2];if(+g[M>>2]<m)g[M>>2]=m;h=M+4|0;if(+g[h>>2]<n)g[h>>2]=n;h=M+8|0;if(+g[h>>2]<l)g[h>>2]=l;h=M+12|0;if(+g[h>>2]<k)g[h>>2]=k;o=0;yb(c[(c[Q>>2]|0)+64>>2]|0,Q|0,O|0,N|0,M|0);Q=o;o=0;if(Q&1){h=zc()|0;o=0;Q=o;o=0;if(!(Q&1))break a;Q=zc(0)|0;Di(Q)}o=0;Q=o;o=0;if(!(Q&1)){i=R;return}}}}h=zc()|0}while(0);o=0;R=o;o=0;if(R&1){R=zc(0)|0;Di(R)}else Kc(h|0)}function UX(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=+j;var k=0,l=0;k=i;i=i+32|0;l=k;c[l>>2]=0;c[l+4>>2]=f;c[l+8>>2]=e;c[l+12>>2]=g;c[l+16>>2]=-1;c[l+20>>2]=-1;VX(a,b,d,l,h,j);i=k;return}function VX(d,e,f,h,j,k){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;var l=0,m=0.0,n=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0,O=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,pa=0,qa=0,ra=0,sa=0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0.0,Ba=0.0,Ca=0.0,Da=0.0,Ea=0.0,Fa=0.0,Ga=0.0;qa=i;i=i+1680|0;N=qa+1496|0;F=qa+1136|0;E=qa+1088|0;C=qa+1e3|0;Q=qa+1092|0;s=qa+760|0;z=qa+520|0;A=qa+1024|0;B=qa+776|0;r=qa+152|0;q=qa+136|0;O=qa+584|0;D=qa+112|0;R=qa+536|0;S=qa+456|0;X=qa+232|0;U=qa+96|0;T=qa+80|0;W=qa+64|0;V=qa+48|0;la=qa+168|0;ma=qa+24|0;na=qa;Y=c[h+4>>2]|0;pa=c[h+12>>2]|0;l=c[Y+4>>2]|0;if((l|0)<20){c[N>>2]=22820;r=N+164|0;c[N+168>>2]=0;g[N+172>>2]=k;q=j+4|0;c[r>>2]=c[q>>2];g[F+308>>2]=9.999999747378752e-005;a[F+332>>0]=0;c[E>>2]=24880;o=0;fa(27,C|0,d|0,Y|0,F|0,E|0);d=o;o=0;a:do if(!(d&1)){o=0;l=oa(c[(c[C>>2]|0)+8>>2]|0,C|0,e|0,f|0,pa|0,pa|0,N|0)|0;f=o;o=0;do if(!(f&1)){if(((l?(G=N+132|0,m=+g[G>>2],H=N+136|0,n=+g[H>>2],L=N+140|0,x=+g[L>>2],y=m*m+n*n+x*x,y>9.999999747378752e-005):0)?(M=+g[r>>2],M<+g[q>>2]):0)?(k=1.0/+P(+y),g[G>>2]=m*k,g[H>>2]=n*k,g[L>>2]=x*k,f=N+148|0,c[Q>>2]=c[h+8>>2],c[Q+4>>2]=0,h=Q+8|0,c[h>>2]=c[G>>2],c[h+4>>2]=c[G+4>>2],c[h+8>>2]=c[G+8>>2],c[h+12>>2]=c[G+12>>2],h=Q+24|0,c[h>>2]=c[f>>2],c[h+4>>2]=c[f+4>>2],c[h+8>>2]=c[f+8>>2],c[h+12>>2]=c[f+12>>2],g[Q+40>>2]=M,o=0,+Ka(c[(c[j>>2]|0)+12>>2]|0,j|0,Q|0,1),j=o,o=0,j&1):0)break;o=0;j=o;o=0;if(j&1)break a;i=qa;return}while(0);l=zc()|0;o=0;qa=o;o=0;if(qa&1){qa=zc(0)|0;Di(qa)}else{qa=l;Kc(qa|0)}}while(0);qa=zc()|0;Kc(qa|0)}if((l+-21|0)>>>0>=9){if((l|0)!=31){i=qa;return}Q5(65519);ka=Y+16|0;b:do if((c[ka>>2]|0)>0){l=Y+24|0;q=pa+4|0;r=pa+8|0;s=pa+16|0;z=pa+20|0;A=pa+24|0;B=pa+32|0;C=pa+36|0;D=pa+40|0;E=pa+48|0;F=pa+52|0;G=pa+56|0;H=la+4|0;I=la+8|0;J=la+12|0;K=la+16|0;L=la+20|0;N=la+24|0;O=la+28|0;Q=la+32|0;R=la+36|0;S=la+40|0;T=la+44|0;U=la+48|0;V=la+52|0;W=la+56|0;X=la+60|0;Y=ma+4|0;Z=ma+8|0;_=ma+10|0;$=ma+12|0;aa=ma+16|0;ba=j+4|0;ca=h+8|0;da=na+4|0;ea=na+8|0;ga=na+12|0;ha=na+16|0;ia=na+20|0;ja=0;while(1){sa=c[l>>2]|0;xa=+g[sa+(ja*80|0)>>2];ua=+g[sa+(ja*80|0)+4>>2];n=+g[sa+(ja*80|0)+8>>2];wa=+g[sa+(ja*80|0)+16>>2];ta=+g[sa+(ja*80|0)+20>>2];t=+g[sa+(ja*80|0)+24>>2];va=+g[sa+(ja*80|0)+32>>2];m=+g[sa+(ja*80|0)+36>>2];v=+g[sa+(ja*80|0)+40>>2];Fa=+g[sa+(ja*80|0)+48>>2];Ea=+g[sa+(ja*80|0)+52>>2];M=+g[sa+(ja*80|0)+56>>2];sa=c[sa+(ja*80|0)+64>>2]|0;Da=+g[pa>>2];Ca=+g[q>>2];Ba=+g[r>>2];Aa=+g[s>>2];za=+g[z>>2];ya=+g[A>>2];p=+g[B>>2];u=+g[C>>2];w=+g[D>>2];x=Fa*Da+Ea*Ca+M*Ba+ +g[E>>2];y=Fa*Aa+Ea*za+M*ya+ +g[F>>2];M=Fa*p+Ea*u+M*w+ +g[G>>2];g[la>>2]=xa*Da+wa*Ca+va*Ba;g[H>>2]=ua*Da+ta*Ca+m*Ba;g[I>>2]=n*Da+t*Ca+v*Ba;g[J>>2]=0.0;g[K>>2]=xa*Aa+wa*za+va*ya;g[L>>2]=ua*Aa+ta*za+m*ya;g[N>>2]=n*Aa+t*za+v*ya;g[O>>2]=0.0;g[Q>>2]=xa*p+wa*u+va*w;g[R>>2]=ua*p+ta*u+m*w;g[S>>2]=n*p+t*u+v*w;g[T>>2]=0.0;g[U>>2]=x;g[V>>2]=y;g[W>>2]=M;g[X>>2]=0.0;b[Z>>1]=1;b[_>>1]=-1;c[ma>>2]=22980;c[$>>2]=j;c[aa>>2]=ja;c[Y>>2]=c[ba>>2];ra=c[ca>>2]|0;c[na>>2]=h;c[da>>2]=sa;c[ea>>2]=ra;c[ga>>2]=la;c[ha>>2]=-1;c[ia>>2]=ja;o=0;Ia(7,d|0,e|0,f|0,na|0,ma|0,+k);ra=o;o=0;if(ra&1)break;ja=ja+1|0;if((ja|0)>=(c[ka>>2]|0))break b}l=zc()|0;o=0;tb(9);sa=o;o=0;if(sa&1){sa=zc(0)|0;Di(sa)}else{sa=l;Kc(sa|0)}}while(0);R5();i=qa;return}switch(l|0){case 21:{v=+g[pa>>2];w=+g[pa+16>>2];x=+g[pa+32>>2];y=+g[pa+4>>2];M=+g[pa+20>>2];ta=+g[pa+36>>2];Aa=+g[pa+8>>2];Ca=+g[pa+24>>2];Ea=+g[pa+40>>2];va=-+g[pa+48>>2];ua=-+g[pa+52>>2];xa=-+g[pa+56>>2];za=v*va+w*ua+x*xa;ya=y*va+M*ua+ta*xa;xa=Aa*va+Ca*ua+Ea*xa;ua=+g[e+48>>2];va=+g[e+52>>2];wa=+g[e+56>>2];g[s>>2]=za+(v*ua+w*va+x*wa);g[s+4>>2]=ya+(y*ua+M*va+ta*wa);g[s+8>>2]=xa+(Aa*ua+Ca*va+Ea*wa);g[s+12>>2]=0.0;wa=+g[f+48>>2];va=+g[f+52>>2];ua=+g[f+56>>2];g[z>>2]=za+(v*wa+w*va+x*ua);g[z+4>>2]=ya+(y*wa+M*va+ta*ua);g[z+8>>2]=xa+(Aa*wa+Ca*va+Ea*ua);g[z+12>>2]=0.0;ua=+g[f>>2];va=+g[f+16>>2];wa=+g[f+32>>2];xa=+g[f+4>>2];ya=+g[f+20>>2];za=+g[f+36>>2];Ba=+g[f+8>>2];Da=+g[f+24>>2];Fa=+g[f+40>>2];g[A>>2]=v*ua+w*va+x*wa;g[A+4>>2]=v*xa+w*ya+x*za;g[A+8>>2]=v*Ba+w*Da+x*Fa;g[A+12>>2]=0.0;g[A+16>>2]=y*ua+M*va+ta*wa;g[A+20>>2]=y*xa+M*ya+ta*za;g[A+24>>2]=y*Ba+M*Da+ta*Fa;g[A+28>>2]=0.0;g[A+32>>2]=Aa*ua+Ca*va+Ea*wa;g[A+36>>2]=Aa*xa+Ca*ya+Ea*za;g[A+40>>2]=Aa*Ba+Ca*Da+Ea*Fa;sa=A+44|0;c[sa>>2]=0;c[sa+4>>2]=0;c[sa+8>>2]=0;c[sa+12>>2]=0;c[sa+16>>2]=0;sa=c[h+8>>2]|0;W1(B,d,e,f,pa,+Pf[c[(c[Y>>2]|0)+48>>2]&15](Y));c[B>>2]=22932;c[B+212>>2]=j;c[B+216>>2]=sa;c[B+220>>2]=Y;c[B+200>>2]=c[j+4>>2];g[B+208>>2]=k;o=0;yb(c[(c[d>>2]|0)+8>>2]|0,d|0,A|0,r|0,q|0);sa=o;o=0;if(!(sa&1)?(o=0,Ya(8,Y|0,B|0,s|0,z|0,r|0,q|0),sa=o,o=0,!(sa&1)):0){i=qa;return}l=zc()|0;o=0;sa=o;o=0;if(sa&1){sa=zc(0)|0;Di(sa)}else{sa=l;Kc(sa|0)}break}case 28:{c[O>>2]=22820;r=O+164|0;c[O+168>>2]=0;g[O+172>>2]=k;q=j+4|0;c[r>>2]=c[q>>2];o=0;sb(174,D|0,d|0,Y|0);sa=o;o=0;c:do if(!(sa&1)){o=0;l=oa(c[(c[D>>2]|0)+8>>2]|0,D|0,e|0,f|0,pa|0,pa|0,O|0)|0;sa=o;o=0;do if(!(sa&1)){if(((l?(I=O+132|0,p=+g[I>>2],J=O+136|0,t=+g[J>>2],K=O+140|0,u=+g[K>>2],v=p*p+t*t+u*u,v>9.999999747378752e-005):0)?(w=+g[r>>2],w<+g[q>>2]):0)?(Fa=1.0/+P(+v),g[I>>2]=p*Fa,g[J>>2]=t*Fa,g[K>>2]=u*Fa,ra=O+148|0,c[R>>2]=c[h+8>>2],c[R+4>>2]=0,sa=R+8|0,c[sa>>2]=c[I>>2],c[sa+4>>2]=c[I+4>>2],c[sa+8>>2]=c[I+8>>2],c[sa+12>>2]=c[I+12>>2],sa=R+24|0,c[sa>>2]=c[ra>>2],c[sa+4>>2]=c[ra+4>>2],c[sa+8>>2]=c[ra+8>>2],c[sa+12>>2]=c[ra+12>>2],g[R+40>>2]=w,o=0,+Ka(c[(c[j>>2]|0)+12>>2]|0,j|0,R|0,1),sa=o,o=0,sa&1):0)break;o=0;sa=o;o=0;if(sa&1)break c;i=qa;return}while(0);l=zc()|0;o=0;sa=o;o=0;if(sa&1){sa=zc(0)|0;Di(sa)}else{sa=l;Kc(sa|0)}}while(0);sa=zc()|0;Kc(sa|0)}default:{Ga=+g[pa>>2];t=+g[pa+16>>2];u=+g[pa+32>>2];v=+g[pa+4>>2];M=+g[pa+20>>2];ta=+g[pa+36>>2];Aa=+g[pa+8>>2];Ca=+g[pa+24>>2];Ea=+g[pa+40>>2];va=-+g[pa+48>>2];ua=-+g[pa+52>>2];wa=-+g[pa+56>>2];w=Ga*va+t*ua+u*wa;x=v*va+M*ua+ta*wa;wa=Aa*va+Ca*ua+Ea*wa;ua=+g[e+48>>2];va=+g[e+52>>2];m=+g[e+56>>2];p=w+(Ga*ua+t*va+u*m);n=x+(v*ua+M*va+ta*m);m=wa+(Aa*ua+Ca*va+Ea*m);va=+g[f+48>>2];ua=+g[f+52>>2];y=+g[f+56>>2];w=w+(Ga*va+t*ua+u*y);x=x+(v*va+M*ua+ta*y);y=wa+(Aa*va+Ca*ua+Ea*y);ua=+g[f>>2];va=+g[f+16>>2];wa=+g[f+32>>2];xa=+g[f+4>>2];ya=+g[f+20>>2];za=+g[f+36>>2];Ba=+g[f+8>>2];Da=+g[f+24>>2];Fa=+g[f+40>>2];g[S>>2]=Ga*ua+t*va+u*wa;g[S+4>>2]=Ga*xa+t*ya+u*za;g[S+8>>2]=Ga*Ba+t*Da+u*Fa;g[S+12>>2]=0.0;g[S+16>>2]=v*ua+M*va+ta*wa;g[S+20>>2]=v*xa+M*ya+ta*za;g[S+24>>2]=v*Ba+M*Da+ta*Fa;g[S+28>>2]=0.0;g[S+32>>2]=Aa*ua+Ca*va+Ea*wa;g[S+36>>2]=Aa*xa+Ca*ya+Ea*za;g[S+40>>2]=Aa*Ba+Ca*Da+Ea*Fa;sa=S+44|0;c[sa>>2]=0;c[sa+4>>2]=0;c[sa+8>>2]=0;c[sa+12>>2]=0;c[sa+16>>2]=0;sa=c[h+8>>2]|0;W1(X,d,e,f,pa,+Pf[c[(c[Y>>2]|0)+48>>2]&15](Y));c[X>>2]=22956;c[X+212>>2]=j;c[X+216>>2]=sa;c[X+220>>2]=Y;c[X+200>>2]=c[j+4>>2];g[X+208>>2]=k;o=0;yb(c[(c[d>>2]|0)+8>>2]|0,d|0,S|0,U|0,T|0);sa=o;o=0;if(!(sa&1)){g[W>>2]=p;l=W+4|0;g[l>>2]=n;q=W+8|0;g[q>>2]=m;g[W+12>>2]=0.0;if(w<p){g[W>>2]=w;t=w}else t=p;if(x<n){g[l>>2]=x;u=x}else u=n;if(y<m){g[q>>2]=y;v=y}else v=m;g[V>>2]=p;r=V+4|0;g[r>>2]=n;s=V+8|0;g[s>>2]=m;g[V+12>>2]=0.0;if(p<w){g[V>>2]=w;p=w}if(n<x){g[r>>2]=x;n=x}if(m<y){g[s>>2]=y;m=y}g[W>>2]=+g[U>>2]+t;g[l>>2]=+g[U+4>>2]+u;g[q>>2]=+g[U+8>>2]+v;g[V>>2]=+g[T>>2]+p;g[r>>2]=+g[T+4>>2]+n;g[s>>2]=+g[T+8>>2]+m;o=0;yb(c[(c[Y>>2]|0)+64>>2]|0,Y|0,X|0,W|0,V|0);sa=o;o=0;if(!(sa&1)){i=qa;return}}l=zc()|0;o=0;sa=o;o=0;if(sa&1){sa=zc(0)|0;Di(sa)}else{sa=l;Kc(sa|0)}}}}function WX(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0;f=i;i=i+256|0;k=f+32|0;j=f+16|0;h=f;c[k>>2]=23004;n=k+36|0;c[n>>2]=c[b>>2];c[n+4>>2]=c[b+4>>2];c[n+8>>2]=c[b+8>>2];c[n+12>>2]=c[b+12>>2];o=k+52|0;c[o>>2]=c[d>>2];c[o+4>>2]=c[d+4>>2];c[o+8>>2]=c[d+8>>2];c[o+12>>2]=c[d+12>>2];c[k+212>>2]=a;c[k+216>>2]=e;c[k+68>>2]=1065353216;e=k+72|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[k+88>>2]=1065353216;e=k+92|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[k+108>>2]=1065353216;c[k+112>>2]=0;e=k+116|0;c[e>>2]=c[n>>2];c[e+4>>2]=c[n+4>>2];c[e+8>>2]=c[n+8>>2];c[e+12>>2]=c[n+12>>2];c[k+132>>2]=1065353216;e=k+136|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[k+152>>2]=1065353216;e=k+156|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[k+172>>2]=1065353216;c[k+176>>2]=0;e=k+180|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];p=+g[d>>2]-+g[b>>2];m=+g[d+4>>2]-+g[b+4>>2];s=+g[d+8>>2]-+g[b+8>>2];l=1.0/+P(+(p*p+m*m+s*s));p=p*l;m=m*l;l=s*l;s=p==0.0?999999984306749440.0:1.0/p;g[k+4>>2]=s;r=m==0.0?999999984306749440.0:1.0/m;g[k+8>>2]=r;q=l==0.0?999999984306749440.0:1.0/l;g[k+12>>2]=q;c[k+20>>2]=s<0.0&1;c[k+24>>2]=r<0.0&1;c[k+28>>2]=q<0.0&1;g[k+32>>2]=p*(+g[o>>2]-+g[n>>2])+m*(+g[k+56>>2]-+g[k+40>>2])+l*(+g[k+60>>2]-+g[k+44>>2]);a=c[a+68>>2]|0;e=c[(c[a>>2]|0)+24>>2]|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;Zf[e&15](a,b,d,k,j,h);i=f;return}function XX(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0.0,I=0.0,J=0.0,K=0,L=0.0,M=0,N=0;v=i;i=i+480|0;y=v+408|0;s=v+208|0;N=v+144|0;K=v+80|0;u=v+64|0;t=v+48|0;w=v+32|0;x=v+16|0;M=v;Q5(65539);c[N>>2]=c[d>>2];c[N+4>>2]=c[d+4>>2];c[N+8>>2]=c[d+8>>2];c[N+12>>2]=c[d+12>>2];p=N+16|0;m=d+16|0;c[p>>2]=c[m>>2];c[p+4>>2]=c[m+4>>2];c[p+8>>2]=c[m+8>>2];c[p+12>>2]=c[m+12>>2];p=N+32|0;n=d+32|0;c[p>>2]=c[n>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];p=N+48|0;q=d+48|0;c[p>>2]=c[q>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];c[K>>2]=c[e>>2];c[K+4>>2]=c[e+4>>2];c[K+8>>2]=c[e+8>>2];c[K+12>>2]=c[e+12>>2];k=K+16|0;r=e+16|0;c[k>>2]=c[r>>2];c[k+4>>2]=c[r+4>>2];c[k+8>>2]=c[r+8>>2];c[k+12>>2]=c[r+12>>2];k=K+32|0;j=e+32|0;c[k>>2]=c[j>>2];c[k+4>>2]=c[j+4>>2];c[k+8>>2]=c[j+8>>2];c[k+12>>2]=c[j+12>>2];k=K+48|0;l=e+48|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];LV(N,K,y,s);L=+g[s>>2];D=L*+g[y+4>>2];F=L*+g[y+8>>2];g[w>>2]=+g[y>>2]*L;g[w+4>>2]=D;g[w+8>>2]=F;g[w+12>>2]=0.0;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;K=y+4|0;c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;G=y+24|0;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;z=y+44|0;c[z>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;c[z+12>>2]=0;c[z+16>>2]=0;MA(N,M);F=+g[M>>2];D=+g[M+4>>2];L=+g[M+8>>2];I=+g[M+12>>2];H=2.0/(F*F+D*D+L*L+I*I);B=F*H;A=D*H;H=L*H;C=I*B;E=I*A;I=I*H;B=F*B;J=F*A;F=F*H;A=D*A;D=D*H;H=L*H;g[y>>2]=1.0-(A+H);g[K>>2]=J-I;g[y+8>>2]=F+E;g[y+12>>2]=0.0;g[y+16>>2]=J+I;g[y+20>>2]=1.0-(B+H);g[G>>2]=D-C;g[y+28>>2]=0.0;g[y+32>>2]=F-E;g[y+36>>2]=D+C;g[y+40>>2]=1.0-(B+A);g[z>>2]=0.0;o=0;Na(1,b|0,y|0,x|0,w|0,1.0,u|0,t|0);w=o;o=0;do if(!(w&1)){c[s>>2]=23024;N=s+36|0;c[N>>2]=c[d>>2];c[N+4>>2]=c[d+4>>2];c[N+8>>2]=c[d+8>>2];c[N+12>>2]=c[d+12>>2];N=s+52|0;c[N>>2]=c[m>>2];c[N+4>>2]=c[m+4>>2];c[N+8>>2]=c[m+8>>2];c[N+12>>2]=c[m+12>>2];N=s+68|0;c[N>>2]=c[n>>2];c[N+4>>2]=c[n+4>>2];c[N+8>>2]=c[n+8>>2];c[N+12>>2]=c[n+12>>2];N=s+84|0;c[N>>2]=c[q>>2];c[N+4>>2]=c[q+4>>2];c[N+8>>2]=c[q+8>>2];c[N+12>>2]=c[q+12>>2];M=s+100|0;c[M>>2]=c[e>>2];c[M+4>>2]=c[e+4>>2];c[M+8>>2]=c[e+8>>2];c[M+12>>2]=c[e+12>>2];M=s+116|0;c[M>>2]=c[r>>2];c[M+4>>2]=c[r+4>>2];c[M+8>>2]=c[r+8>>2];c[M+12>>2]=c[r+12>>2];M=s+132|0;c[M>>2]=c[j>>2];c[M+4>>2]=c[j+4>>2];c[M+8>>2]=c[j+8>>2];c[M+12>>2]=c[j+12>>2];M=s+148|0;c[M>>2]=c[l>>2];c[M+4>>2]=c[l+4>>2];c[M+8>>2]=c[l+8>>2];c[M+12>>2]=c[l+12>>2];c[s+180>>2]=a;c[s+184>>2]=f;g[s+188>>2]=h;c[s+192>>2]=b;H=+g[M>>2]-+g[N>>2];J=+g[s+152>>2]-+g[s+88>>2];E=+g[s+156>>2]-+g[s+92>>2];F=1.0/+P(+(H*H+J*J+E*E));I=H*F;L=J*F;F=E*F;B=I==0.0?999999984306749440.0:1.0/I;g[s+4>>2]=B;C=L==0.0?999999984306749440.0:1.0/L;g[s+8>>2]=C;D=F==0.0?999999984306749440.0:1.0/F;g[s+12>>2]=D;c[s+20>>2]=B<0.0&1;c[s+24>>2]=C<0.0&1;c[s+28>>2]=D<0.0&1;g[s+32>>2]=E*F+(H*I+J*L);N=c[a+68>>2]|0;o=0;Ya(c[(c[N>>2]|0)+24>>2]|0,N|0,p|0,k|0,s|0,u|0,t|0);N=o;o=0;if(N&1){j=zc()|0;break}else{R5();i=v;return}}else j=zc()|0;while(0);o=0;tb(9);N=o;o=0;if(N&1){N=zc(0)|0;Di(N)}else Kc(j|0)}function YX(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+48|0;h=e+32|0;g=e+16|0;f=e;j=c[b+192>>2]|0;zg[c[(c[j>>2]|0)+8>>2]&127](j,b+4|0,h,g);c[f>>2]=23044;c[f+4>>2]=b;c[f+8>>2]=a;c[f+12>>2]=d;a=c[a+68>>2]|0;zg[c[(c[a>>2]|0)+28>>2]&127](a,h,g,f);i=e;return}function ZX(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;j=i;i=i+96|0;g=j+64|0;h=j;f=j+24|0;k=c[b+192>>2]|0;c[g>>2]=0;c[g+4>>2]=k;c[g+8>>2]=b;c[g+12>>2]=b+4;c[g+16>>2]=-1;c[g+20>>2]=-1;b=c[d+192>>2]|0;c[h>>2]=0;c[h+4>>2]=b;c[h+8>>2]=d;c[h+12>>2]=d+4;c[h+16>>2]=-1;c[h+20>>2]=-1;b=a+24|0;d=c[b>>2]|0;d=qg[c[(c[d>>2]|0)+8>>2]&63](d,g,h,0)|0;if(!d){i=j;return}OZ(f,g,h);c[f>>2]=23064;c[f+32>>2]=e;ff[c[(c[d>>2]|0)+8>>2]&31](d,g,h,a+28|0,f);Kf[c[c[d>>2]>>2]&1023](d);k=c[b>>2]|0;of[c[(c[k>>2]|0)+60>>2]&511](k,d);i=j;return}function _X(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0.0,Ba=0.0,Ca=0.0,Da=0.0,Ea=0.0,Fa=0.0,Ga=0;ia=i;i=i+576|0;L=ia+416|0;l=ia+304|0;f=ia+288|0;N=ia+224|0;j=ia+208|0;X=ia+192|0;Y=ia+176|0;$=ia+160|0;Z=ia+144|0;_=ia+128|0;F=ia+112|0;G=ia+96|0;H=ia+80|0;I=ia+64|0;ba=ia+48|0;ca=ia+32|0;da=ia+480|0;ea=ia+16|0;fa=ia;ga=ia+320|0;aa=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;vg[c[(c[aa>>2]|0)+56>>2]&7](aa,b,1.0);aa=d+4|0;h=c[aa>>2]|0;switch(h|0){case 31:{f=c[d+16>>2]|0;if((f|0)<=0){i=ia;return}h=d+24|0;j=b+4|0;l=b+8|0;m=b+16|0;n=b+20|0;p=b+24|0;q=b+32|0;r=b+36|0;s=b+40|0;t=b+48|0;u=b+52|0;v=b+56|0;w=L+4|0;x=L+8|0;y=L+12|0;z=L+16|0;A=L+20|0;B=L+24|0;C=L+28|0;D=L+32|0;E=L+36|0;F=L+40|0;G=L+44|0;H=L+48|0;I=L+52|0;J=L+56|0;K=L+60|0;do{ha=f;f=f+-1|0;d=c[h>>2]|0;wa=+g[d+(f*80|0)>>2];ta=+g[d+(f*80|0)+4>>2];qa=+g[d+(f*80|0)+8>>2];va=+g[d+(f*80|0)+16>>2];sa=+g[d+(f*80|0)+20>>2];oa=+g[d+(f*80|0)+24>>2];ua=+g[d+(f*80|0)+32>>2];ra=+g[d+(f*80|0)+36>>2];ma=+g[d+(f*80|0)+40>>2];Ea=+g[d+(f*80|0)+48>>2];Da=+g[d+(f*80|0)+52>>2];M=+g[d+(f*80|0)+56>>2];d=c[d+(f*80|0)+64>>2]|0;ga=c[(c[a>>2]|0)+28>>2]|0;Ca=+g[b>>2];Ba=+g[j>>2];Aa=+g[l>>2];za=+g[m>>2];ya=+g[n>>2];xa=+g[p>>2];pa=+g[q>>2];na=+g[r>>2];la=+g[s>>2];ka=Ea*Ca+Da*Ba+M*Aa+ +g[t>>2];ja=Ea*za+Da*ya+M*xa+ +g[u>>2];M=Ea*pa+Da*na+M*la+ +g[v>>2];g[L>>2]=wa*Ca+va*Ba+ua*Aa;g[w>>2]=ta*Ca+sa*Ba+ra*Aa;g[x>>2]=qa*Ca+oa*Ba+ma*Aa;g[y>>2]=0.0;g[z>>2]=wa*za+va*ya+ua*xa;g[A>>2]=ta*za+sa*ya+ra*xa;g[B>>2]=qa*za+oa*ya+ma*xa;g[C>>2]=0.0;g[D>>2]=wa*pa+va*na+ua*la;g[E>>2]=ta*pa+sa*na+ra*la;g[F>>2]=qa*pa+oa*na+ma*la;g[G>>2]=0.0;g[H>>2]=ka;g[I>>2]=ja;g[J>>2]=M;g[K>>2]=0.0;zg[ga&127](a,L,d,e)}while((ha|0)>1);i=ia;return}case 0:{ha=d+28|0;c[l>>2]=c[ha>>2];c[l+4>>2]=c[ha+4>>2];c[l+8>>2]=c[ha+8>>2];c[l+12>>2]=c[ha+12>>2];Ca=+Pf[c[(c[d>>2]|0)+48>>2]&15](d);Da=+Pf[c[(c[d>>2]|0)+48>>2]&15](d);Ea=+Pf[c[(c[d>>2]|0)+48>>2]&15](d);Ca=Ca+ +g[l>>2];g[l>>2]=Ca;ha=l+4|0;Da=Da+ +g[ha>>2];g[ha>>2]=Da;ha=l+8|0;Ea=Ea+ +g[ha>>2];g[ha>>2]=Ea;a=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;ha=c[(c[a>>2]|0)+72>>2]|0;g[f>>2]=-Ca;g[f+4>>2]=-Da;g[f+8>>2]=-Ea;g[f+12>>2]=0.0;ff[ha&31](a,f,l,b,e);i=ia;return}case 8:{Ea=+Pf[c[(c[d>>2]|0)+48>>2]&15](d);a=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;yf[c[(c[a>>2]|0)+16>>2]&3](a,Ea,b,e);i=ia;return}case 9:{f=c[d+92>>2]|0;if((f|0)<=0){i=ia;return}L=d+100|0;h=d+120|0;j=b+4|0;l=b+8|0;m=b+16|0;n=b+20|0;p=b+24|0;q=b+32|0;r=b+36|0;s=b+40|0;t=b+48|0;u=b+52|0;v=b+56|0;w=N+4|0;x=N+8|0;y=N+12|0;z=N+16|0;A=N+20|0;B=N+24|0;C=N+28|0;D=N+32|0;E=N+36|0;F=N+40|0;G=N+44|0;H=N+48|0;I=N+52|0;J=N+56|0;K=N+60|0;do{ha=f;f=f+-1|0;d=c[L>>2]|0;Fa=+g[d+(f<<4)>>2];M=+g[d+(f<<4)+4>>2];Da=+g[d+(f<<4)+8>>2];d=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;ga=c[(c[d>>2]|0)+16>>2]|0;Ea=+g[(c[h>>2]|0)+(f<<2)>>2];ja=+g[b>>2];ka=+g[j>>2];oa=ka*0.0;ma=+g[l>>2];la=ma*0.0;na=ja*0.0;pa=+g[m>>2];qa=+g[n>>2];ua=qa*0.0;sa=+g[p>>2];ra=sa*0.0;ta=pa*0.0;va=+g[q>>2];wa=+g[r>>2];Aa=wa*0.0;ya=+g[s>>2];xa=ya*0.0;za=va*0.0;Ba=Fa*ja+M*ka+Da*ma+ +g[t>>2];Ca=Fa*pa+M*qa+Da*sa+ +g[u>>2];Da=Fa*va+M*wa+Da*ya+ +g[v>>2];g[N>>2]=ja+oa+la;g[w>>2]=na+ka+la;g[x>>2]=ma+(na+oa);g[y>>2]=0.0;g[z>>2]=pa+ua+ra;g[A>>2]=ta+qa+ra;g[B>>2]=sa+(ta+ua);g[C>>2]=0.0;g[D>>2]=va+Aa+xa;g[E>>2]=za+wa+xa;g[F>>2]=ya+(za+Aa);g[G>>2]=0.0;g[H>>2]=Ba;g[I>>2]=Ca;g[J>>2]=Da;g[K>>2]=0.0;yf[ga&3](d,Ea,N,e)}while((ha|0)>1);i=ia;return}case 10:{ha=c[d+52>>2]|0;Ea=+g[d+28+(((ha+2|0)%3|0)<<2)>>2];Fa=+g[d+28+(ha<<2)>>2];a=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;xf[c[(c[a>>2]|0)+76>>2]&7](a,Ea,Fa,ha,b,e);i=ia;return}case 11:{Ea=+g[d+56>>2];Fa=+g[d+60>>2];ha=c[d+68>>2]|0;a=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;xf[c[(c[a>>2]|0)+84>>2]&7](a,Ea,Fa,ha,b,e);i=ia;return}case 13:{ha=c[d+52>>2]|0;Ea=+Pf[c[(c[d>>2]|0)+92>>2]&15](d);ga=d+28|0;c[j>>2]=c[ga>>2];c[j+4>>2]=c[ga+4>>2];c[j+8>>2]=c[ga+8>>2];c[j+12>>2]=c[ga+12>>2];Ca=+Pf[c[(c[d>>2]|0)+48>>2]&15](d);Da=+Pf[c[(c[d>>2]|0)+48>>2]&15](d);Fa=+Pf[c[(c[d>>2]|0)+48>>2]&15](d);g[j>>2]=Ca+ +g[j>>2];d=j+4|0;g[d>>2]=Da+ +g[d>>2];d=j+8|0;g[d>>2]=Fa+ +g[d>>2];Fa=+g[j+(ha<<2)>>2];a=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;xf[c[(c[a>>2]|0)+80>>2]&7](a,Ea,Fa,ha,b,e);i=ia;return}case 28:{Fa=+g[d+64>>2];a=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;nf[c[(c[a>>2]|0)+88>>2]&1](a,d+48|0,Fa,b,e);i=ia;return}default:{a:do if((h|0)<7){f=c[d+52>>2]|0;if(!f){if((rf[c[(c[d>>2]|0)+100>>2]&255](d)|0)<=0)break;f=F+4|0;h=b+4|0;j=F+8|0;l=b+8|0;m=b+16|0;n=b+20|0;p=b+24|0;q=b+32|0;r=b+36|0;s=b+40|0;t=b+48|0;u=b+52|0;v=b+56|0;w=H+4|0;x=H+8|0;y=H+12|0;z=G+4|0;A=G+8|0;B=I+4|0;C=I+8|0;D=I+12|0;E=0;while(1){zg[c[(c[d>>2]|0)+104>>2]&127](d,E,F,G);Da=+g[F>>2];ra=+g[b>>2];Ba=+g[f>>2];sa=+g[h>>2];za=+g[j>>2];ta=+g[l>>2];va=+g[m>>2];wa=+g[n>>2];xa=+g[p>>2];Aa=+g[q>>2];Ca=+g[r>>2];Ea=+g[s>>2];ua=+g[t>>2];ya=+g[u>>2];Fa=+g[v>>2];g[H>>2]=Da*ra+Ba*sa+za*ta+ua;g[w>>2]=Da*va+Ba*wa+za*xa+ya;g[x>>2]=Da*Aa+Ba*Ca+za*Ea+Fa;g[y>>2]=0.0;za=+g[G>>2];Ba=+g[z>>2];Da=+g[A>>2];g[I>>2]=za*ra+Ba*sa+Da*ta+ua;g[B>>2]=za*va+Ba*wa+Da*xa+ya;g[C>>2]=za*Aa+Ba*Ca+Da*Ea+Fa;g[D>>2]=0.0;$=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;zg[c[(c[$>>2]|0)+8>>2]&127]($,H,I,e);E=E+1|0;if((E|0)>=(rf[c[(c[d>>2]|0)+100>>2]&255](d)|0))break a}}A=f+28|0;if((c[A>>2]|0)>0){B=f+36|0;C=$+4|0;D=$+8|0;E=$+12|0;F=b+4|0;G=b+8|0;H=b+16|0;I=b+20|0;J=b+24|0;K=b+32|0;L=b+36|0;N=b+40|0;O=b+48|0;P=b+52|0;Q=b+56|0;R=Z+4|0;S=Z+8|0;T=Z+12|0;U=_+4|0;V=_+8|0;W=_+12|0;s=f+16|0;t=X+4|0;u=X+8|0;v=X+12|0;w=Y+4|0;x=Y+8|0;y=Y+12|0;z=0;do{f=c[B>>2]|0;r=c[f+(z*36|0)+4>>2]|0;b:do if((r|0)>0){p=c[f+(z*36|0)+12>>2]|0;m=p;f=0;h=0;j=0;p=c[p+(r+-1<<2)>>2]|0;l=0;while(1){q=c[m+(l<<2)>>2]|0;n=c[s>>2]|0;f=(g[k>>2]=(c[k>>2]=f,+g[k>>2])+ +g[n+(q<<4)>>2],c[k>>2]|0);h=(g[k>>2]=(c[k>>2]=h,+g[k>>2])+ +g[n+(q<<4)+4>>2],c[k>>2]|0);n=(g[k>>2]=(c[k>>2]=j,+g[k>>2])+ +g[n+(q<<4)+8>>2],c[k>>2]|0);j=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;m=c[(c[j>>2]|0)+8>>2]|0;Ga=c[s>>2]|0;Da=+g[Ga+(p<<4)>>2];ra=+g[b>>2];Ba=+g[Ga+(p<<4)+4>>2];sa=+g[F>>2];za=+g[Ga+(p<<4)+8>>2];ta=+g[G>>2];va=+g[H>>2];wa=+g[I>>2];xa=+g[J>>2];Aa=+g[K>>2];Ca=+g[L>>2];Ea=+g[N>>2];ua=+g[O>>2];ya=+g[P>>2];Fa=+g[Q>>2];g[X>>2]=Da*ra+Ba*sa+za*ta+ua;g[t>>2]=Da*va+Ba*wa+za*xa+ya;g[u>>2]=Da*Aa+Ba*Ca+za*Ea+Fa;g[v>>2]=0.0;za=+g[Ga+(q<<4)>>2];Ba=+g[Ga+(q<<4)+4>>2];Da=+g[Ga+(q<<4)+8>>2];g[Y>>2]=za*ra+Ba*sa+Da*ta+ua;g[w>>2]=za*va+Ba*wa+Da*xa+ya;g[x>>2]=za*Aa+Ba*Ca+Da*Ea+Fa;g[y>>2]=0.0;zg[m&127](j,X,Y,e);l=l+1|0;j=c[B>>2]|0;if((l|0)>=(c[j+(z*36|0)+4>>2]|0)){j=n;break b}m=c[j+(z*36|0)+12>>2]|0;j=n;p=q}}else{j=0;h=0;f=0}while(0);M=1.0/+(r|0);Ga=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;if((rf[c[(c[Ga>>2]|0)+48>>2]&255](Ga)|0)&16384){qa=(c[k>>2]=j,+g[k>>2])*M;pa=(c[k>>2]=h,+g[k>>2])*M;oa=M*(c[k>>2]=f,+g[k>>2]);c[$>>2]=1065353216;c[C>>2]=1065353216;c[D>>2]=0;g[E>>2]=0.0;Ga=c[B>>2]|0;za=+g[Ga+(z*36|0)+20>>2];Ba=+g[Ga+(z*36|0)+24>>2];Da=+g[Ga+(z*36|0)+28>>2];Ga=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;r=c[(c[Ga>>2]|0)+8>>2]|0;ra=+g[b>>2];sa=+g[F>>2];ta=+g[G>>2];va=+g[H>>2];wa=+g[I>>2];xa=+g[J>>2];Aa=+g[K>>2];Ca=+g[L>>2];Ea=+g[N>>2];ua=+g[O>>2];ya=+g[P>>2];Fa=+g[Q>>2];g[Z>>2]=oa*ra+pa*sa+qa*ta+ua;g[R>>2]=oa*va+pa*wa+qa*xa+ya;g[S>>2]=oa*Aa+pa*Ca+qa*Ea+Fa;g[T>>2]=0.0;za=oa+za;Ba=pa+Ba;Da=qa+Da;g[_>>2]=za*ra+Ba*sa+Da*ta+ua;g[U>>2]=za*va+Ba*wa+Da*xa+ya;g[V>>2]=za*Aa+Ba*Ca+Da*Ea+Fa;g[W>>2]=0.0;zg[r&127](Ga,Z,_,$)}z=z+1|0}while((z|0)<(c[A>>2]|0))}}while(0);f=c[aa>>2]|0;do if((f+-21|0)>>>0<9){c[ba>>2]=1566444395;c[ba+4>>2]=1566444395;c[ba+8>>2]=1566444395;g[ba+12>>2]=0.0;c[ca>>2]=-581039253;c[ca+4>>2]=-581039253;c[ca+8>>2]=-581039253;g[ca+12>>2]=0.0;Ga=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;c[da>>2]=23092;c[da+4>>2]=23116;c[da+8>>2]=Ga;Ga=da+12|0;c[Ga>>2]=c[e>>2];c[Ga+4>>2]=c[e+4>>2];c[Ga+8>>2]=c[e+8>>2];c[Ga+12>>2]=c[e+12>>2];Ga=da+28|0;c[Ga>>2]=c[b>>2];c[Ga+4>>2]=c[b+4>>2];c[Ga+8>>2]=c[b+8>>2];c[Ga+12>>2]=c[b+12>>2];Ga=da+44|0;$=b+16|0;c[Ga>>2]=c[$>>2];c[Ga+4>>2]=c[$+4>>2];c[Ga+8>>2]=c[$+8>>2];c[Ga+12>>2]=c[$+12>>2];Ga=da+60|0;$=b+32|0;c[Ga>>2]=c[$>>2];c[Ga+4>>2]=c[$+4>>2];c[Ga+8>>2]=c[$+8>>2];c[Ga+12>>2]=c[$+12>>2];Ga=da+76|0;$=b+48|0;c[Ga>>2]=c[$>>2];c[Ga+4>>2]=c[$+4>>2];c[Ga+8>>2]=c[$+8>>2];c[Ga+12>>2]=c[$+12>>2];o=0;yb(c[(c[d>>2]|0)+64>>2]|0,d|0,da|0,ca|0,ba|0);Ga=o;o=0;if(!(Ga&1)){o=0;Ga=o;o=0;if(!(Ga&1)){f=c[aa>>2]|0;ha=39;break}f=zc()|0;o=0;Ga=o;o=0;if(Ga&1){Ga=zc(0)|0;Di(Ga)}else Kc(f|0)}f=zc()|0;o=0;Ga=o;o=0;if(!(Ga&1)){o=0;Ga=o;o=0;if(Ga&1)break;Kc(f|0)}f=zc(0)|0;o=0;Ga=o;o=0;if(Ga&1){Ga=zc(0)|0;Di(Ga)}else{Ga=f;Di(Ga)}}else ha=39;while(0);do if((ha|0)==39){if((f|0)!=3){i=ia;return}c[ea>>2]=1566444395;c[ea+4>>2]=1566444395;c[ea+8>>2]=1566444395;g[ea+12>>2]=0.0;c[fa>>2]=-581039253;c[fa+4>>2]=-581039253;c[fa+8>>2]=-581039253;g[fa+12>>2]=0.0;Ga=rf[c[(c[a>>2]|0)+20>>2]&255](a)|0;c[ga>>2]=23092;c[ga+4>>2]=23116;c[ga+8>>2]=Ga;Ga=ga+12|0;c[Ga>>2]=c[e>>2];c[Ga+4>>2]=c[e+4>>2];c[Ga+8>>2]=c[e+8>>2];c[Ga+12>>2]=c[e+12>>2];Ga=ga+28|0;c[Ga>>2]=c[b>>2];c[Ga+4>>2]=c[b+4>>2];c[Ga+8>>2]=c[b+8>>2];c[Ga+12>>2]=c[b+12>>2];Ga=ga+44|0;a=b+16|0;c[Ga>>2]=c[a>>2];c[Ga+4>>2]=c[a+4>>2];c[Ga+8>>2]=c[a+8>>2];c[Ga+12>>2]=c[a+12>>2];Ga=ga+60|0;a=b+32|0;c[Ga>>2]=c[a>>2];c[Ga+4>>2]=c[a+4>>2];c[Ga+8>>2]=c[a+8>>2];c[Ga+12>>2]=c[a+12>>2];Ga=ga+76|0;b=b+48|0;c[Ga>>2]=c[b>>2];c[Ga+4>>2]=c[b+4>>2];c[Ga+8>>2]=c[b+8>>2];c[Ga+12>>2]=c[b+12>>2];Ga=c[d+92>>2]|0;o=0;yb(c[(c[Ga>>2]|0)+8>>2]|0,Ga|0,ga+4|0,fa|0,ea|0);Ga=o;o=0;if(Ga&1){f=zc()|0;o=0;Ga=o;o=0;if(!(Ga&1)){o=0;Ga=o;o=0;if(Ga&1)break;Kc(f|0)}f=zc(0)|0;o=0;Ga=o;o=0;if(Ga&1){Ga=zc(0)|0;Di(Ga)}else{Ga=f;Di(Ga)}}else{o=0;Ga=o;o=0;if(!(Ga&1)){i=ia;return}f=zc()|0;o=0;Ga=o;o=0;if(Ga&1){Ga=zc(0)|0;Di(Ga)}else Kc(f|0)}}while(0);Ga=zc(0)|0;Di(Ga)}}}function $X(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0;R=i;i=i+112|0;j=R+96|0;L=R+80|0;P=R+64|0;N=R+48|0;M=R+32|0;Q=R+16|0;O=R;if(((rf[c[(c[b>>2]|0)+20>>2]&255](b)|0)!=0?(K=rf[c[(c[b>>2]|0)+20>>2]&255](b)|0,((rf[c[(c[K>>2]|0)+48>>2]&255](K)|0)&8|0)!=0):0)?(d=b+24|0,e=c[d>>2]|0,e=rf[c[(c[e>>2]|0)+36>>2]&255](e)|0,c[j>>2]=1065353216,c[j+4>>2]=1065353216,c[j+8>>2]=0,g[j+12>>2]=0.0,(e|0)>0):0){k=0;do{f=c[d>>2]|0;f=dg[c[(c[f>>2]|0)+40>>2]&127](f,k)|0;h=c[f+748>>2]|0;if((h|0)>0){l=0;do{K=rf[c[(c[b>>2]|0)+20>>2]&255](b)|0;lf[c[(c[K>>2]|0)+32>>2]&1](K,f+4+(l*184|0)+32|0,f+4+(l*184|0)+64|0,+g[f+4+(l*184|0)+80>>2],c[f+4+(l*184|0)+148>>2]|0,j);l=l+1|0}while((l|0)!=(h|0))}k=k+1|0}while((k|0)!=(e|0))}if(!(rf[c[(c[b>>2]|0)+20>>2]&255](b)|0)){i=R;return}K=rf[c[(c[b>>2]|0)+20>>2]&255](b)|0;if(!((rf[c[(c[K>>2]|0)+48>>2]&255](K)|0)&3)){i=R;return}h=b+8|0;if((c[h>>2]|0)<=0){i=R;return}j=b+16|0;k=b+72|0;l=M+4|0;s=M+8|0;t=M+12|0;u=P+4|0;v=P+8|0;w=N+4|0;x=N+8|0;y=b+44|0;z=Q+4|0;A=Q+8|0;B=O+4|0;C=O+8|0;D=P+12|0;E=Q+12|0;F=N+12|0;G=O+12|0;H=L+4|0;I=L+8|0;J=L+12|0;K=0;do{e=c[(c[j>>2]|0)+(K<<2)>>2]|0;f=e+204|0;if(!(c[f>>2]&32)){if((rf[c[(c[b>>2]|0)+20>>2]&255](b)|0)!=0?(d=rf[c[(c[b>>2]|0)+20>>2]&255](b)|0,((rf[c[(c[d>>2]|0)+48>>2]&255](d)|0)&1|0)!=0):0){c[L>>2]=1065353216;c[H>>2]=1065353216;c[I>>2]=1065353216;g[J>>2]=0.0;switch(c[e+216>>2]|0){case 1:{c[L>>2]=1065353216;c[H>>2]=1065353216;c[I>>2]=1065353216;g[J>>2]=0.0;break}case 2:{c[L>>2]=0;c[H>>2]=1065353216;c[I>>2]=0;g[J>>2]=0.0;break}case 3:{c[L>>2]=0;c[H>>2]=1065353216;c[I>>2]=1065353216;g[J>>2]=0.0;break}case 4:{c[L>>2]=1065353216;c[H>>2]=0;c[I>>2]=0;g[J>>2]=0.0;break}case 5:{c[L>>2]=1065353216;c[H>>2]=1065353216;c[I>>2]=0;g[J>>2]=0.0;break}default:{c[L>>2]=1065353216;c[H>>2]=0;c[I>>2]=0;g[J>>2]=0.0}}zg[c[(c[b>>2]|0)+28>>2]&127](b,e+4|0,c[e+192>>2]|0,L)}d=c[k>>2]|0;if((d|0)!=0?((rf[c[(c[d>>2]|0)+48>>2]&255](d)|0)&2|0)!=0:0){c[M>>2]=1065353216;c[l>>2]=0;c[s>>2]=0;g[t>>2]=0.0;d=e+192|0;S=c[d>>2]|0;zg[c[(c[S>>2]|0)+8>>2]&127](S,e+4|0,P,N);p=+g[6490];g[P>>2]=+g[P>>2]-p;g[u>>2]=+g[u>>2]-p;g[v>>2]=+g[v>>2]-p;g[N>>2]=p+ +g[N>>2];g[w>>2]=p+ +g[w>>2];g[x>>2]=p+ +g[x>>2];do if(((a[y>>0]|0)!=0?(c[e+236>>2]|0)==2:0)?(c[f>>2]&3|0)==0:0){S=c[d>>2]|0;zg[c[(c[S>>2]|0)+8>>2]&127](S,e+68|0,Q,O);m=+g[Q>>2]-p;g[Q>>2]=m;n=+g[z>>2]-p;g[z>>2]=n;o=+g[A>>2]-p;g[A>>2]=o;q=p+ +g[O>>2];g[O>>2]=q;r=p+ +g[B>>2];g[B>>2]=r;p=p+ +g[C>>2];g[C>>2]=p;if(m<+g[P>>2])g[P>>2]=m;if(n<+g[u>>2])g[u>>2]=n;if(o<+g[v>>2])g[v>>2]=o;m=+g[E>>2];if(m<+g[D>>2])g[D>>2]=m;if(+g[N>>2]<q)g[N>>2]=q;if(+g[w>>2]<r)g[w>>2]=r;if(+g[x>>2]<p)g[x>>2]=p;m=+g[G>>2];if(!(+g[F>>2]<m))break;g[F>>2]=m}while(0);S=c[k>>2]|0;zg[c[(c[S>>2]|0)+52>>2]&127](S,P,N,M)}}K=K+1|0}while((K|0)<(c[h>>2]|0));i=R;return}function aY(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;y=i;i=i+96|0;z=y+16|0;w=y+8|0;t=y;u=b+8|0;e=c[u>>2]|0;if((e|0)>0){h=b+16|0;g=0;do{f=c[(c[h>>2]|0)+(g<<2)>>2]|0;if((c[f+236>>2]|0)==1){of[c[(c[f>>2]|0)+24>>2]&511](f,d);e=c[u>>2]|0}g=g+1|0}while((g|0)<(e|0))}a[z+16>>0]=1;m=z+12|0;c[m>>2]=0;n=z+4|0;c[n>>2]=0;c[z+8>>2]=0;a[z+36>>0]=1;p=z+32|0;c[p>>2]=0;c[z+24>>2]=0;c[z+28>>2]=0;a[z+56>>0]=1;q=z+52|0;c[q>>2]=0;c[z+44>>2]=0;r=z+48|0;c[r>>2]=0;a[z+76>>0]=1;s=z+72|0;c[s>>2]=0;c[z+64>>2]=0;c[z+68>>2]=0;if((e|0)<=0){fY(z);i=y;return}l=b+16|0;g=0;h=0;f=0;while(1){j=c[(c[(c[l>>2]|0)+(f<<2)>>2]|0)+192>>2]|0;c[w>>2]=j;k=j;b=k+~(k<<15)|0;b=(b>>10^b)*9|0;b=b>>6^b;b=b+~(b<<11)|0;g=(b>>16^b)&g+-1;a:do if(g>>>0<h>>>0?(v=c[(c[m>>2]|0)+(g<<2)>>2]|0,(v|0)!=-1):0){h=c[s>>2]|0;b=c[p>>2]|0;g=v;while(1){if((j|0)==(c[h+(g<<3)>>2]|0))break;g=c[b+(g<<2)>>2]|0;if((g|0)==-1){x=14;break a}}if(!((c[q>>2]|0)+(g<<2)|0))x=14}else x=14;while(0);if((x|0)==14){x=0;c[t>>2]=k;o=0;sb(175,z|0,t|0,w|0);k=o;o=0;if(k&1)break;o=0;na(c[(c[j>>2]|0)+60>>2]|0,j|0,d|0);k=o;o=0;if(k&1)break;e=c[u>>2]|0}f=f+1|0;if((f|0)>=(e|0)){x=20;break}g=c[r>>2]|0;h=c[n>>2]|0}if((x|0)==20){fY(z);i=y;return}e=zc()|0;o=0;Ja(542,z|0);z=o;o=0;if(z&1){z=zc(0)|0;Di(z)}else Kc(e|0)}function bY(a,b){a=a|0;b=b|0;Kf[c[(c[b>>2]|0)+32>>2]&1023](b);aY(a,b);Kf[c[(c[b>>2]|0)+36>>2]&1023](b);return}function cY(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0,K=0.0,L=0,M=0,N=0.0;L=i;i=i+32|0;J=L;if(!a){i=L;return}k=+g[d>>2]-+g[b>>2];F=b+4|0;m=+g[d+4>>2]-+g[F>>2];E=b+8|0;D=+g[d+8>>2]-+g[E>>2];n=1.0/+P(+(k*k+m*m+D*D));N=k*n;l=m*n;n=D*n;A=N==0.0?999999984306749440.0:1.0/N;B=l==0.0?999999984306749440.0:1.0/l;C=n==0.0?999999984306749440.0:1.0/n;d=A<0.0&1;h=B<0.0&1;j=C<0.0&1;D=N*k+l*m+n*D;o=0;f=cb(77,512,16)|0;z=o;o=0;if(z&1){M=zc()|0;Kc(M|0)}M9(f|0,0,512)|0;c[f>>2]=a;y=J+16|0;z=J+(d<<4)|0;w=J+((d^1)<<4)|0;x=J+(h<<4)+4|0;u=J+((h^1)<<4)+4|0;v=J+(j<<4)+8|0;t=J+((j^1)<<4)+8|0;a=128;d=128;s=1;h=126;a:while(1){j=s+-1|0;r=c[f+(j<<2)>>2]|0;c[J>>2]=c[r>>2];c[J+4>>2]=c[r+4>>2];c[J+8>>2]=c[r+8>>2];c[J+12>>2]=c[r+12>>2];q=r+16|0;c[y>>2]=c[q>>2];c[y+4>>2]=c[q+4>>2];c[y+8>>2]=c[q+8>>2];c[y+12>>2]=c[q+12>>2];l=+g[b>>2];k=A*(+g[z>>2]-l);l=A*(+g[w>>2]-l);n=+g[F>>2];m=B*(+g[x>>2]-n);n=B*(+g[u>>2]-n);do if((!(m>l|k>n)?(G=m>k?m:k,K=n<l?n:l,I=+g[E>>2],H=C*(+g[v>>2]-I),I=C*(+g[t>>2]-I),!(H>K|G>I)):0)?((I<K?I:K)>0.0?(H>G?H:G)<D:0):0){q=r+40|0;if(!(c[q>>2]|0)){o=0;na(c[(c[e>>2]|0)+12>>2]|0,e|0,r|0);s=o;o=0;if(s&1){M=21;break a}else break}if((j|0)>(h|0)){p=a<<1;if((a|0)<(p|0)){do if((d|0)<(p|0)){if(a){o=0;d=cb(77,a<<3|0,16)|0;h=o;o=0;if(h&1){M=21;break a}if((a|0)>0){h=0;do{c[d+(h<<2)>>2]=c[f+(h<<2)>>2];h=h+1|0}while((h|0)!=(a|0))}else M=16}else{d=0;M=16}if((M|0)==16){M=0;if(!f){f=d;d=p;break}}o=0;Ja(494,f|0);h=o;o=0;if(h&1){M=18;break a}else{f=d;d=p}}while(0);M9(f+(a<<2)|0,0,a<<2|0)|0}a=p;h=p+-2|0}c[f+(j<<2)>>2]=c[r+36>>2];c[f+(s<<2)>>2]=c[q>>2];j=s+1|0}while(0);if(!j){M=27;break}else s=j}do if((M|0)==18)d=zc()|0;else if((M|0)==21){d=zc()|0;if(!f){M=d;Kc(M|0)}else break}else if((M|0)==27){if(!f){i=L;return}m5(f);i=L;return}while(0);o=0;Ja(494,f|0);M=o;o=0;if(M&1){M=zc(0)|0;Di(M)}else{M=d;Kc(M|0)}}function dY(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0;e=i;i=i+128|0;k=e+56|0;h=e+32|0;f=e;J=c[(c[a+8>>2]|0)+24>>2]|0;j=c[J+(d*80|0)+64>>2]|0;l=c[a+12>>2]|0;A=+g[J+(d*80|0)>>2];G=+g[l>>2];z=+g[J+(d*80|0)+16>>2];F=+g[l+4>>2];y=+g[J+(d*80|0)+32>>2];E=+g[l+8>>2];x=+g[J+(d*80|0)+4>>2];w=+g[J+(d*80|0)+20>>2];v=+g[J+(d*80|0)+36>>2];u=+g[J+(d*80|0)+8>>2];s=+g[J+(d*80|0)+24>>2];q=+g[J+(d*80|0)+40>>2];D=+g[l+16>>2];C=+g[l+20>>2];B=+g[l+24>>2];t=+g[l+32>>2];r=+g[l+36>>2];p=+g[l+40>>2];I=+g[J+(d*80|0)+48>>2];H=+g[J+(d*80|0)+52>>2];m=+g[J+(d*80|0)+56>>2];o=+g[l+48>>2]+(G*I+F*H+E*m);n=D*I+C*H+B*m+ +g[l+52>>2];m=t*I+r*H+p*m+ +g[l+56>>2];g[k>>2]=A*G+z*F+y*E;g[k+4>>2]=G*x+F*w+E*v;g[k+8>>2]=G*u+F*s+E*q;g[k+12>>2]=0.0;g[k+16>>2]=A*D+z*C+y*B;g[k+20>>2]=x*D+w*C+v*B;g[k+24>>2]=u*D+s*C+q*B;g[k+28>>2]=0.0;g[k+32>>2]=A*t+z*r+y*p;g[k+36>>2]=x*t+w*r+v*p;g[k+40>>2]=u*t+s*r+q*p;g[k+44>>2]=0.0;g[k+48>>2]=o;g[k+52>>2]=n;g[k+56>>2]=m;g[k+60>>2]=0.0;l=c[a+4>>2]|0;c[h>>2]=0;c[h+4>>2]=j;c[h+8>>2]=l;c[h+12>>2]=k;c[h+16>>2]=-1;c[h+20>>2]=d;k=c[a+24>>2]|0;l=f+4|0;g[l>>2]=1.0;c[f+8>>2]=0;b[f+12>>1]=1;b[f+14>>1]=-1;j=f+16|0;c[j>>2]=0;c[f>>2]=23136;c[f+20>>2]=k;c[f+24>>2]=d;c[l>>2]=c[k+4>>2];c[j>>2]=c[k+16>>2];TX(c[a+16>>2]|0,c[a+20>>2]|0,h,f);i=e;return}function eY(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=c[d>>2]|0;f=h+~(h<<15)|0;f=(f>>10^f)*9|0;f=f>>6^f;f=f+~(f<<11)|0;p=b+48|0;q=c[p>>2]|0;f=(f>>16^f)&q+-1;a:do if(f>>>0<(c[b+4>>2]|0)>>>0?(g=c[(c[b+12>>2]|0)+(f<<2)>>2]|0,(g|0)!=-1):0){i=c[b+72>>2]|0;j=b+32|0;while(1){if((h|0)==(c[i+(g<<3)>>2]|0)){f=g;break}g=c[(c[j>>2]|0)+(g<<2)>>2]|0;if((g|0)==-1)break a}c[(c[b+52>>2]|0)+(f<<2)>>2]=c[e>>2];return}while(0);m=b+44|0;n=c[m>>2]|0;if((n|0)==(q|0)){k=(q|0)!=0?q<<1:1;if((q|0)<(k|0)){if(!k){j=0;g=q}else{j=l5(k<<2,16)|0;g=c[m>>2]|0}l=b+52|0;if((g|0)>0){h=0;do{c[j+(h<<2)>>2]=c[(c[l>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[l>>2]|0;i=b+56|0;if(h){if(a[i>>0]|0){m5(h);g=c[m>>2]|0}c[l>>2]=0}a[i>>0]=1;c[l>>2]=j;c[p>>2]=k}else g=q}else g=n;c[(c[b+52>>2]|0)+(g<<2)>>2]=c[e>>2];c[m>>2]=g+1;l=b+64|0;g=c[l>>2]|0;k=b+68|0;if((g|0)==(c[k>>2]|0)?(o=(g|0)!=0?g<<1:1,(g|0)<(o|0)):0){if(!o)j=0;else{j=l5(o<<3,16)|0;g=c[l>>2]|0}i=b+72|0;if((g|0)>0){h=0;do{r=(c[i>>2]|0)+(h<<3)|0;m=c[r+4>>2]|0;e=j+(h<<3)|0;c[e>>2]=c[r>>2];c[e+4>>2]=m;h=h+1|0}while((h|0)!=(g|0))}h=c[i>>2]|0;g=b+76|0;if(h){if(a[g>>0]|0)m5(h);c[i>>2]=0}a[g>>0]=1;c[i>>2]=j;c[k>>2]=o;g=c[l>>2]|0}e=d;o=c[e+4>>2]|0;r=(c[b+72>>2]|0)+(g<<3)|0;c[r>>2]=c[e>>2];c[r+4>>2]=o;c[l>>2]=(c[l>>2]|0)+1;if((q|0)<(c[p>>2]|0)){gY(b,d);f=c[d>>2]|0;f=f+~(f<<15)|0;f=(f>>10^f)*9|0;f=f>>6^f;f=f+~(f<<11)|0;f=(f>>16^f)&(c[p>>2]|0)+-1}r=(c[b+12>>2]|0)+(f<<2)|0;c[(c[b+32>>2]|0)+(n<<2)>>2]=c[r>>2];c[r>>2]=n;return}function fY(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;f=b+64|0;g=b+72|0;d=c[g>>2]|0;e=b+76|0;do if(!d)h=5;else{if((a[e>>0]|0)!=0?(o=0,Ja(494,d|0),h=o,o=0,h&1):0){e=zc()|0;f=b+44|0;g=b+52|0;h=c[g>>2]|0;d=b+56|0;if(h){if((a[d>>0]|0)!=0?(o=0,Ja(494,h|0),h=o,o=0,h&1):0){h=zc(0)|0;Di(h)}c[g>>2]=0}a[d>>0]=1;c[g>>2]=0;c[f>>2]=0;c[b+48>>2]=0;h=25;break}c[g>>2]=0;h=5}while(0);do if((h|0)==5){a[e>>0]=1;c[g>>2]=0;c[f>>2]=0;c[b+68>>2]=0;g=b+44|0;e=b+52|0;f=c[e>>2]|0;d=b+56|0;if(f){if((a[d>>0]|0)!=0?(o=0,Ja(494,f|0),f=o,o=0,f&1):0){e=zc()|0;h=25;break}c[e>>2]=0}a[d>>0]=1;c[e>>2]=0;c[g>>2]=0;c[b+48>>2]=0;e=b+24|0;f=b+32|0;g=c[f>>2]|0;d=b+36|0;if(g){if((a[d>>0]|0)!=0?(o=0,Ja(494,g|0),g=o,o=0,g&1):0){e=zc()|0;break}c[f>>2]=0}a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;c[b+28>>2]=0;e=b+4|0;f=b+12|0;g=c[f>>2]|0;d=b+16|0;if(!g){a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;b=b+8|0;c[b>>2]=0;return}if(a[d>>0]|0)m5(g);c[f>>2]=0;a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;b=b+8|0;c[b>>2]=0;return}while(0);if((h|0)==25){f=b+24|0;g=b+32|0;h=c[g>>2]|0;d=b+36|0;if(h){if((a[d>>0]|0)!=0?(o=0,Ja(494,h|0),h=o,o=0,h&1):0){h=zc(0)|0;Di(h)}c[g>>2]=0}a[d>>0]=1;c[g>>2]=0;c[f>>2]=0;c[b+28>>2]=0}f=b+4|0;g=b+12|0;h=c[g>>2]|0;d=b+16|0;if(!h){a[d>>0]=1;c[g>>2]=0;c[f>>2]=0;b=b+8|0;c[b>>2]=0;Kc(e|0)}if((a[d>>0]|0)!=0?(o=0,Ja(494,h|0),h=o,o=0,h&1):0){h=zc(0)|0;Di(h)}c[g>>2]=0;a[d>>0]=1;c[g>>2]=0;c[f>>2]=0;b=b+8|0;c[b>>2]=0;Kc(e|0)}function gY(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=b+48|0;l=c[m>>2]|0;j=b+4|0;n=c[j>>2]|0;if((l|0)<=(n|0))return;if((l|0)>=(n|0)){i=b+8|0;do if((c[i>>2]|0)<(l|0)){if(!l){d=0;e=n}else{d=l5(l<<2,16)|0;e=c[j>>2]|0}g=b+12|0;h=c[g>>2]|0;if((e|0)<=0){if(!h){a[b+16>>0]=1;c[g>>2]=d;c[i>>2]=l;break}}else{f=0;do{c[d+(f<<2)>>2]=c[h+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}e=b+16|0;if(a[e>>0]|0)m5(h);a[e>>0]=1;c[g>>2]=d;c[i>>2]=l}else d=c[b+12>>2]|0;while(0);M9(d+(n<<2)|0,0,l-n<<2|0)|0}c[j>>2]=l;j=b+24|0;k=c[j>>2]|0;if((l|0)>(k|0)){g=b+28|0;do if((c[g>>2]|0)<(l|0)){if(!l){d=0;e=k}else{d=l5(l<<2,16)|0;e=c[j>>2]|0}h=b+32|0;i=c[h>>2]|0;if((e|0)<=0){if(!i){a[b+36>>0]=1;c[h>>2]=d;c[g>>2]=l;break}}else{f=0;do{c[d+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}e=b+36|0;if(a[e>>0]|0)m5(i);a[e>>0]=1;c[h>>2]=d;c[g>>2]=l}else d=c[b+32>>2]|0;while(0);M9(d+(k<<2)|0,0,l-k<<2|0)|0}c[j>>2]=l;if((l|0)>0){M9(c[b+12>>2]|0,-1,l<<2|0)|0;M9(c[b+32>>2]|0,-1,l<<2|0)|0}if((n|0)<=0)return;f=c[b+72>>2]|0;g=c[b+12>>2]|0;d=c[b+32>>2]|0;e=0;do{b=c[f+(e<<3)>>2]|0;b=b+~(b<<15)|0;b=(b>>10^b)*9|0;b=b>>6^b;b=b+~(b<<11)|0;b=g+(((b>>16^b)&(c[m>>2]|0)+-1)<<2)|0;c[d+(e<<2)>>2]=c[b>>2];c[b>>2]=e;e=e+1|0}while((e|0)!=(n|0));return}function hY(a){a=a|0;var b=0;o=0;a=o;o=0;if(!(a&1))return;a=zc()|0;o=0;b=o;o=0;if(b&1){b=zc(0)|0;Di(b)}else Kc(a|0)}function iY(a){a=a|0;var b=0,c=0;o=0;b=o;o=0;if(b&1){b=zc()|0;o=0;c=o;o=0;if(c&1){c=zc(0)|0;Di(c)}else{c=b;$5(a);Kc(c|0)}}o=0;c=o;o=0;if(!(c&1)){$5(a);return}c=zc()|0;$5(a);Kc(c|0)}function jY(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0;y=i;i=i+96|0;v=y+80|0;w=y+64|0;x=y+48|0;t=y+32|0;u=y+16|0;e=y;B=+g[b>>2];H=+g[a+28>>2];z=+g[b+4>>2];G=+g[a+32>>2];p=+g[b+8>>2];F=+g[a+36>>2];E=+g[a+44>>2];D=+g[a+48>>2];C=+g[a+52>>2];A=+g[a+60>>2];l=+g[a+64>>2];j=+g[a+68>>2];m=+g[a+76>>2];n=B*H+z*G+p*F+m;f=+g[a+80>>2];o=B*E+z*D+p*C+f;h=+g[a+84>>2];p=B*A+z*l+p*j+h;g[v>>2]=n;g[v+4>>2]=o;g[v+8>>2]=p;g[v+12>>2]=0.0;z=+g[b+16>>2];B=+g[b+20>>2];s=+g[b+24>>2];q=z*H+B*G+s*F+m;r=z*E+B*D+s*C+f;s=z*A+B*l+s*j+h;g[w>>2]=q;g[w+4>>2]=r;g[w+8>>2]=s;g[w+12>>2]=0.0;B=+g[b+32>>2];z=+g[b+36>>2];k=+g[b+40>>2];m=B*H+z*G+k*F+m;f=B*E+z*D+k*C+f;h=B*A+z*l+k*j+h;g[x>>2]=m;g[x+4>>2]=f;g[x+8>>2]=h;g[x+12>>2]=0.0;j=(n+q+m)*.3333333432674408;k=(o+r+f)*.3333333432674408;l=(p+s+h)*.3333333432674408;g[t>>2]=j;g[t+4>>2]=k;g[t+8>>2]=l;g[t+12>>2]=0.0;d=a+8|0;b=c[d>>2]|0;if(!((rf[c[(c[b>>2]|0)+48>>2]&255](b)|0)&16384)){u=c[d>>2]|0;t=c[u>>2]|0;t=t+8|0;t=c[t>>2]|0;a=a+12|0;zg[t&127](u,v,w,a);u=c[d>>2]|0;t=c[u>>2]|0;t=t+8|0;t=c[t>>2]|0;zg[t&127](u,w,x,a);w=c[d>>2]|0;u=c[w>>2]|0;u=u+8|0;u=c[u>>2]|0;zg[u&127](w,x,v,a);i=y;return}C=q-n;G=r-o;B=s-p;H=m-n;D=f-o;F=h-p;E=G*F-B*D;F=B*H-C*F;H=C*D-G*H;G=1.0/+P(+(H*H+(E*E+F*F)));c[u>>2]=1065353216;c[u+4>>2]=1065353216;c[u+8>>2]=0;g[u+12>>2]=0.0;b=c[d>>2]|0;I=c[(c[b>>2]|0)+8>>2]|0;g[e>>2]=G*E+j;g[e+4>>2]=G*F+k;g[e+8>>2]=G*H+l;g[e+12>>2]=0.0;zg[I&127](b,t,e,u);u=c[d>>2]|0;t=c[u>>2]|0;t=t+8|0;t=c[t>>2]|0;a=a+12|0;zg[t&127](u,v,w,a);u=c[d>>2]|0;t=c[u>>2]|0;t=t+8|0;t=c[t>>2]|0;zg[t&127](u,w,x,a);w=c[d>>2]|0;u=c[w>>2]|0;u=u+8|0;u=c[u>>2]|0;zg[u&127](w,x,v,a);i=y;return}function kY(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;zg[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);return}function lY(a){a=a|0;var b=0;o=0;a=o;o=0;if(!(a&1))return;a=zc()|0;o=0;b=o;o=0;if(b&1){b=zc(0)|0;Di(b)}else Kc(a|0)}function mY(a){a=a|0;var b=0,c=0;a=a+-4|0;o=0;b=o;o=0;if(b&1){b=zc()|0;o=0;c=o;o=0;if(c&1){c=zc(0)|0;Di(c)}else{c=b;$5(a);Kc(c|0)}}o=0;c=o;o=0;if(!(c&1)){$5(a);return}c=zc()|0;$5(a);Kc(c|0)}function nY(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=a+-4|0;zg[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);return}function oY(a){a=a|0;return}function pY(a){a=a|0;$5(a);return}function qY(a,b,d){a=a|0;b=b|0;d=d|0;c[a+16>>2]=b;c[a+24>>2]=d;return}function rY(a,b,d){a=a|0;b=b|0;d=d|0;c[a+20>>2]=b;c[a+28>>2]=d;return}function sY(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0;y=i;i=i+192|0;x=y;m=c[(c[b+4>>2]|0)+740>>2]|0;v=b+8|0;q=c[(c[v>>2]|0)+8>>2]|0;w=(m|0)!=(q|0);h=+g[e>>2];r=+g[d>>2]*f+h;j=+g[e+4>>2];s=+g[d+4>>2]*f+j;k=+g[e+8>>2];t=+g[d+8>>2]*f+k;u=b+12|0;p=c[(c[u>>2]|0)+8>>2]|0;if(w){C=r-+g[p+52>>2];B=s-+g[p+56>>2];l=t-+g[p+60>>2];A=h-+g[q+52>>2];z=j-+g[q+56>>2];h=k-+g[q+60>>2];n=C*+g[p+4>>2]+B*+g[p+20>>2]+l*+g[p+36>>2];o=C*+g[p+8>>2]+B*+g[p+24>>2]+l*+g[p+40>>2];j=C*+g[p+12>>2]+B*+g[p+28>>2]+l*+g[p+44>>2];k=A*+g[q+4>>2]+z*+g[q+20>>2]+h*+g[q+36>>2];l=A*+g[q+8>>2]+z*+g[q+24>>2]+h*+g[q+40>>2];h=A*+g[q+12>>2]+z*+g[q+28>>2]+h*+g[q+44>>2]}else{z=r-+g[m+52>>2];A=s-+g[m+56>>2];l=t-+g[m+60>>2];B=h-+g[p+52>>2];C=j-+g[p+56>>2];h=k-+g[p+60>>2];n=z*+g[m+4>>2]+A*+g[m+20>>2]+l*+g[m+36>>2];o=z*+g[m+8>>2]+A*+g[m+24>>2]+l*+g[m+40>>2];j=z*+g[m+12>>2]+A*+g[m+28>>2]+l*+g[m+44>>2];k=B*+g[p+4>>2]+C*+g[p+20>>2]+h*+g[p+36>>2];l=B*+g[p+8>>2]+C*+g[p+24>>2]+h*+g[p+40>>2];h=B*+g[p+12>>2]+C*+g[p+28>>2]+h*+g[p+44>>2]}g[x>>2]=n;g[x+4>>2]=o;g[x+8>>2]=j;g[x+12>>2]=0.0;g[x+16>>2]=k;g[x+20>>2]=l;g[x+24>>2]=h;g[x+28>>2]=0.0;q=x+64|0;c[q>>2]=c[d>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];c[q+12>>2]=c[d+12>>2];g[x+80>>2]=f;g[x+84>>2]=0.0;g[x+88>>2]=0.0;g[x+92>>2]=0.0;c[x+112>>2]=0;a[x+116>>0]=0;d=x+120|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;g[x+48>>2]=r;g[x+52>>2]=s;g[x+56>>2]=t;g[x+60>>2]=0.0;d=x+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=c[b+20>>2]|0;q=c[b+16>>2]|0;e=c[b+28>>2]|0;m=c[b+24>>2]|0;p=w?d:q;d=w?q:d;q=w?e:m;e=w?m:e;c[x+96>>2]=p;c[x+100>>2]=d;c[x+104>>2]=q;c[x+108>>2]=e;b=c[b+32>>2]|0;+Df[c[(c[b>>2]|0)+12>>2]&1](b,x,c[(w?u:v)>>2]|0,p,q,c[(w?v:u)>>2]|0,d,e);i=y;return}function tY(a){a=a|0;return}function uY(a){a=a|0;$5(a);return}function vY(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;j=i;i=i+96|0;g=j+64|0;h=j;f=j+24|0;b=c[b>>2]|0;d=a+4|0;if((b|0)==(c[d>>2]|0)){i=j;return 1}e=a+12|0;k=c[e>>2]|0;if(!(dg[c[(c[k>>2]|0)+8>>2]&127](k,c[b+188>>2]|0)|0)){i=j;return 1}d=c[d>>2]|0;k=c[d+192>>2]|0;c[g>>2]=0;c[g+4>>2]=k;c[g+8>>2]=d;c[g+12>>2]=d+4;c[g+16>>2]=-1;c[g+20>>2]=-1;d=c[b+192>>2]|0;c[h>>2]=0;c[h+4>>2]=d;c[h+8>>2]=b;c[h+12>>2]=b+4;c[h+16>>2]=-1;c[h+20>>2]=-1;b=a+8|0;d=c[(c[b>>2]|0)+24>>2]|0;d=qg[c[(c[d>>2]|0)+8>>2]&63](d,g,h,0)|0;if(!d){i=j;return 1}k=c[e>>2]|0;OZ(f,g,h);c[f>>2]=23064;c[f+32>>2]=k;ff[c[(c[d>>2]|0)+8>>2]&31](d,g,h,(c[b>>2]|0)+28|0,f);Kf[c[c[d>>2]>>2]&1023](d);k=c[(c[b>>2]|0)+24>>2]|0;of[c[(c[k>>2]|0)+60>>2]&511](k,d);i=j;return 1}function wY(a){a=a|0;$5(a);return}function xY(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0,l=0;h=i;i=i+32|0;f=h;d=a+184|0;e=c[d>>2]|0;if(+g[e+4>>2]==0.0){f=0;i=h;return f|0}b=c[b>>2]|0;if(!(dg[c[(c[e>>2]|0)+8>>2]&127](e,c[b+188>>2]|0)|0)){f=1;i=h;return f|0}k=c[a+192>>2]|0;l=c[b+192>>2]|0;e=c[d>>2]|0;j=+g[a+188>>2];c[f>>2]=0;c[f+4>>2]=l;c[f+8>>2]=b;c[f+12>>2]=b+4;c[f+16>>2]=-1;c[f+20>>2]=-1;VX(k,a+36|0,a+100|0,f,e,j);f=1;i=h;return f|0}function yY(a){a=a|0;$5(a);return}function zY(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0;h=i;i=i+32|0;f=h;d=a+216|0;e=c[d>>2]|0;if(+g[e+4>>2]==0.0){a=0;i=h;return a|0}b=c[b>>2]|0;if(!(dg[c[(c[e>>2]|0)+8>>2]&127](e,c[b+188>>2]|0)|0)){a=1;i=h;return a|0}j=c[b+192>>2]|0;e=c[d>>2]|0;c[f>>2]=0;c[f+4>>2]=j;c[f+8>>2]=b;c[f+12>>2]=b+4;c[f+16>>2]=-1;c[f+20>>2]=-1;TX(a+68|0,a+132|0,f,e);a=1;i=h;return a|0}function AY(a){a=a|0;$5(a);return}function BY(a,b){a=a|0;b=b|0;a=c[a+12>>2]|0;return dg[c[(c[a>>2]|0)+8>>2]&127](a,b)|0}function CY(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0.0;g=i;i=i+16|0;f=g;c[f>>2]=-1;c[f+4>>2]=c[a+16>>2];e=b+4|0;if(!(c[e>>2]|0))c[e>>2]=f;f=a+12|0;e=c[f>>2]|0;h=+Lf[c[(c[e>>2]|0)+12>>2]&15](e,b,d);c[a+4>>2]=c[(c[f>>2]|0)+4>>2];i=g;return +h}function DY(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function EY(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0,k=0,l=0;l=i;i=i+64|0;k=l+48|0;j=l;c[k>>2]=f;c[k+4>>2]=h;f=c[a+212>>2]|0;if(!(+g[f+4>>2]>=e)){i=l;return +e}c[j>>2]=c[a+216>>2];c[j+4>>2]=k;a=j+8|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];a=j+24|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];g[j+40>>2]=e;e=+Lf[c[(c[f>>2]|0)+12>>2]&15](f,j,0);i=l;return +e}function FY(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function GY(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0,k=0,l=0;l=i;i=i+64|0;k=l+48|0;j=l;c[k>>2]=f;c[k+4>>2]=h;f=c[a+212>>2]|0;if(!(+g[f+4>>2]>=e)){i=l;return +e}c[j>>2]=c[a+216>>2];c[j+4>>2]=k;a=j+8|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];a=j+24|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];g[j+40>>2]=e;e=+Lf[c[(c[f>>2]|0)+12>>2]&15](f,j,1);i=l;return +e}function HY(a){a=a|0;$5(a);return}function IY(a,b){a=a|0;b=b|0;a=c[a+20>>2]|0;return dg[c[(c[a>>2]|0)+8>>2]&127](a,b)|0}function JY(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0.0;g=i;i=i+16|0;f=g;c[f>>2]=-1;c[f+4>>2]=c[a+24>>2];e=b+4|0;if(!(c[e>>2]|0))c[e>>2]=f;f=a+20|0;e=c[f>>2]|0;h=+Lf[c[(c[e>>2]|0)+12>>2]&15](e,b,d);c[a+4>>2]=c[(c[f>>2]|0)+4>>2];i=g;return +h}function KY(a){a=a|0;$5(a);return}function LY(a,b){a=a|0;b=b|0;dY(a,c[b+36>>2]|0);return}function MY(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function NY(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0;h=i;i=i+48|0;n=h+32|0;j=h;c[n>>2]=e;c[n+4>>2]=f;p=+g[b>>2];o=+g[b+4>>2];k=+g[b+8>>2];m=+g[a+56>>2]*p+ +g[a+60>>2]*o+ +g[a+64>>2]*k;l=p*+g[a+72>>2]+o*+g[a+76>>2]+k*+g[a+80>>2];k=p*+g[a+88>>2]+o*+g[a+92>>2]+k*+g[a+96>>2];c[j>>2]=c[a+48>>2];c[j+4>>2]=n;g[j+8>>2]=m;g[j+12>>2]=l;g[j+16>>2]=k;g[j+20>>2]=0.0;g[j+24>>2]=d;f=c[a+44>>2]|0;d=+Lf[c[(c[f>>2]|0)+12>>2]&15](f,j,1);i=h;return +d}function OY(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function PY(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0;h=i;i=i+48|0;n=h+32|0;j=h;c[n>>2]=e;c[n+4>>2]=f;p=+g[b>>2];o=+g[b+4>>2];k=+g[b+8>>2];m=+g[a+56>>2]*p+ +g[a+60>>2]*o+ +g[a+64>>2]*k;l=p*+g[a+72>>2]+o*+g[a+76>>2]+k*+g[a+80>>2];k=p*+g[a+88>>2]+o*+g[a+92>>2]+k*+g[a+96>>2];c[j>>2]=c[a+48>>2];c[j+4>>2]=n;g[j+8>>2]=m;g[j+12>>2]=l;g[j+16>>2]=k;g[j+20>>2]=0.0;g[j+24>>2]=d;f=c[a+44>>2]|0;d=+Lf[c[(c[f>>2]|0)+12>>2]&15](f,j,1);i=h;return +d}function QY(a,b){a=a|0;b=+b;return}function RY(a,b){a=a|0;b=b|0;return}
function t0(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0,l=0,m=0,n=0.0,o=0.0,p=0,q=0,r=0,s=0;r=i;i=i+2048|0;p=r;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;f=+g[d>>2];h=+g[d+4>>2];j=+g[d+8>>2];e=f*f+h*h+j*j;if(e<9.999999747378752e-005){o=1.0;n=0.0;h=0.0}else{e=1.0/+P(+e);o=f*e;n=h*e;h=j*e}if((rf[c[(c[b>>2]|0)+96>>2]&255](b)|0)<=0){i=r;return}m=0;f=-999999984306749440.0;while(1){if(((rf[c[(c[b>>2]|0)+96>>2]&255](b)|0)-m|0)<128){d=(rf[c[(c[b>>2]|0)+96>>2]&255](b)|0)-m|0;if((d|0)>0)q=7;else{e=-34028234663852886.0e22;d=-1}}else{d=128;q=7}if((q|0)==7){q=0;k=0;do{tg[c[(c[b>>2]|0)+108>>2]&255](b,k,p+(k<<4)|0);k=k+1|0}while((k|0)!=(d|0));l=0;e=-34028234663852886.0e22;k=-1;do{j=o*+g[p+(l<<4)>>2]+n*+g[p+(l<<4)+4>>2]+h*+g[p+(l<<4)+8>>2];s=j>e;k=s?l:k;e=s?j:e;l=l+1|0}while((l|0)!=(d|0));d=k}if(e>f){s=p+(d<<4)|0;c[a>>2]=c[s>>2];c[a+4>>2]=c[s+4>>2];c[a+8>>2]=c[s+8>>2];c[a+12>>2]=c[s+12>>2]}else e=f;m=m+128|0;if((m|0)>=(rf[c[(c[b>>2]|0)+96>>2]&255](b)|0))break;else f=e}i=r;return}function u0(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0;x=i;i=i+2048|0;v=x;f=(e|0)>0;if(f)h=0;else{i=x;return}do{g[d+(h<<4)+12>>2]=-999999984306749440.0;h=h+1|0}while((h|0)!=(e|0));if(!f){i=x;return}t=0;do{if((rf[c[(c[a>>2]|0)+96>>2]&255](a)|0)>0){r=b+(t<<4)|0;s=b+(t<<4)+4|0;o=b+(t<<4)+8|0;p=d+(t<<4)+12|0;q=d+(t<<4)|0;u=0;do{if(((rf[c[(c[a>>2]|0)+96>>2]&255](a)|0)-u|0)<128){f=(rf[c[(c[a>>2]|0)+96>>2]&255](a)|0)-u|0;if((f|0)>0)w=9;else{j=-34028234663852886.0e22;f=-1}}else{f=128;w=9}if((w|0)==9){w=0;h=0;do{tg[c[(c[a>>2]|0)+108>>2]&255](a,h,v+(h<<4)|0);h=h+1|0}while((h|0)!=(f|0));k=+g[r>>2];l=+g[s>>2];m=+g[o>>2];n=0;j=-34028234663852886.0e22;h=-1;do{y=k*+g[v+(n<<4)>>2]+l*+g[v+(n<<4)+4>>2]+m*+g[v+(n<<4)+8>>2];z=y>j;h=z?n:h;j=z?y:j;n=n+1|0}while((n|0)!=(f|0));f=h}if(j>+g[p>>2]){z=v+(f<<4)|0;c[q>>2]=c[z>>2];c[q+4>>2]=c[z+4>>2];c[q+8>>2]=c[z+8>>2];c[q+12>>2]=c[z+12>>2];g[p>>2]=j}u=u+128|0}while((u|0)<(rf[c[(c[a>>2]|0)+96>>2]&255](a)|0))}t=t+1|0}while((t|0)!=(e|0));i=x;return}function v0(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0,m=0,n=0;e=i;i=i+96|0;m=e+32|0;k=e+16|0;l=e;j=+Pf[c[(c[a>>2]|0)+48>>2]&15](a);c[m>>2]=1065353216;n=m+4|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[m+20>>2]=1065353216;n=m+24|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[m+40>>2]=1065353216;n=m+44|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;zg[c[(c[a>>2]|0)+8>>2]&127](a,m,k,l);h=(j+(+g[l>>2]-+g[k>>2])*.5)*2.0;f=(j+(+g[l+4>>2]-+g[k+4>>2])*.5)*2.0;j=(j+(+g[l+8>>2]-+g[k+8>>2])*.5)*2.0;h=h*h;f=f*f;j=j*j;b=b*.0833333283662796;g[d>>2]=b*(f+j);g[d+4>>2]=b*(h+j);g[d+8>>2]=b*(h+f);g[d+12>>2]=0.0;i=e;return}function w0(a){a=a|0;var b=0;c[a>>2]=24388;a=a+52|0;b=c[a>>2]|0;if(!b)return;o=0;Ja(c[c[b>>2]>>2]|0,b|0);b=o;o=0;if(!(b&1)?(o=0,Ja(494,c[a>>2]|0),b=o,o=0,!(b&1)):0)return;a=zc()|0;o=0;b=o;o=0;if(b&1){b=zc(0)|0;Di(b)}else Kc(a|0)}function x0(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=b+8|0;if((c[w>>2]|0)>=(d|0))return;if(!d)v=0;else v=l5(d*36|0,16)|0;q=b+4|0;r=c[q>>2]|0;if((r|0)>0){s=b+12|0;t=0;do{n=v+(t*36|0)|0;o=c[s>>2]|0;h=n+16|0;a[h>>0]=1;i=n+12|0;c[i>>2]=0;m=n+4|0;c[m>>2]=0;j=n+8|0;c[j>>2]=0;p=c[o+(t*36|0)+4>>2]|0;if((p|0)>0){k=p<<2;l=l5(k,16)|0;g=c[m>>2]|0;f=c[i>>2]|0;if((g|0)<=0)if(!f){a[h>>0]=1;c[i>>2]=l;c[j>>2]=p;M9(l|0,0,k|0)|0}else u=11;else{e=0;do{c[l+(e<<2)>>2]=c[f+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0));u=11}if((u|0)==11){u=0;if(a[h>>0]|0)m5(f);a[h>>0]=1;c[i>>2]=l;c[j>>2]=p;M9(l|0,0,k|0)|0}g=c[i>>2]|0;c[m>>2]=p;e=c[o+(t*36|0)+12>>2]|0;f=0;do{c[g+(f<<2)>>2]=c[e+(f<<2)>>2];f=f+1|0}while((f|0)!=(p|0))}else c[m>>2]=p;p=n+20|0;o=o+(t*36|0)+20|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];t=t+1|0}while((t|0)!=(r|0));e=c[q>>2]|0;if((e|0)>0){g=b+12|0;l=0;do{h=c[g>>2]|0;i=h+(l*36|0)+4|0;j=h+(l*36|0)+12|0;k=c[j>>2]|0;f=h+(l*36|0)+16|0;if(k){if(a[f>>0]|0)m5(k);c[j>>2]=0}a[f>>0]=1;c[j>>2]=0;c[i>>2]=0;c[h+(l*36|0)+8>>2]=0;l=l+1|0}while((l|0)!=(e|0))}else u=19}else u=19;if((u|0)==19)g=b+12|0;f=c[g>>2]|0;e=b+16|0;if(f){if(a[e>>0]|0)m5(f);c[g>>2]=0}a[e>>0]=1;c[g>>2]=v;c[w>>2]=d;return}function y0(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;C=i;i=i+48|0;l=C+16|0;m=C;y=e+8|0;k=+g[y>>2];B=+O(+k)>.7071067690849304;A=e+4|0;n=+g[A>>2];if(B){v=1.0/+P(+(k*k+n*n));t=0.0;s=-(k*v);n=n*v}else{v=+g[e>>2];s=1.0/+P(+(v*v+n*n));t=-(n*s);s=v*s;n=0.0}B=b+4|0;f=c[B>>2]|0;if((f|0)<2){if((f|0)<=0){i=C;return}o=b+12|0;p=d+4|0;q=d+8|0;r=d+12|0;l=d+16|0;f=c[p>>2]|0;b=0;do{m=c[o>>2]|0;if((f|0)==(c[q>>2]|0)?(w=(f|0)!=0?f<<1:1,(f|0)<(w|0)):0){if(!w)j=0;else{j=l5(w*24|0,16)|0;f=c[p>>2]|0}if((f|0)>0){h=0;do{e=j+(h*24|0)|0;A=(c[r>>2]|0)+(h*24|0)|0;c[e>>2]=c[A>>2];c[e+4>>2]=c[A+4>>2];c[e+8>>2]=c[A+8>>2];c[e+12>>2]=c[A+12>>2];c[e+16>>2]=c[A+16>>2];c[e+20>>2]=c[A+20>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[r>>2]|0;if(f){if(a[l>>0]|0)m5(f);c[r>>2]=0}a[l>>0]=1;c[r>>2]=j;c[q>>2]=w;f=c[p>>2]|0}f=(c[r>>2]|0)+(f*24|0)|0;c[f>>2]=c[m>>2];c[f+4>>2]=c[m+4>>2];c[f+8>>2]=c[m+8>>2];c[f+12>>2]=c[m+12>>2];c[f+16>>2]=c[m+16>>2];c[f+20>>2]=c[m+20>>2];f=(c[p>>2]|0)+1|0;c[p>>2]=f;b=b+1|0}while((b|0)<(c[B>>2]|0));i=C;return}x=b+12|0;h=c[x>>2]|0;j=0;do{if(t*+g[h+(j*24|0)>>2]+s*+g[h+(j*24|0)+4>>2]+n*+g[h+(j*24|0)+8>>2]<t*+g[h>>2]+s*+g[h+4>>2]+n*+g[h+8>>2]){c[l>>2]=c[h>>2];c[l+4>>2]=c[h+4>>2];c[l+8>>2]=c[h+8>>2];c[l+12>>2]=c[h+12>>2];c[l+16>>2]=c[h+16>>2];c[l+20>>2]=c[h+20>>2];f=h+(j*24|0)|0;c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[h+16>>2]=c[f+16>>2];c[h+20>>2]=c[f+20>>2];h=(c[x>>2]|0)+(j*24|0)|0;c[h>>2]=c[l>>2];c[h+4>>2]=c[l+4>>2];c[h+8>>2]=c[l+8>>2];c[h+12>>2]=c[l+12>>2];c[h+16>>2]=c[l+16>>2];c[h+20>>2]=c[l+20>>2];h=c[x>>2]|0;f=c[B>>2]|0}j=j+1|0}while((j|0)<(f|0));g[h+16>>2]=-10000000150474662.0e14;if((f|0)>1){k=+g[h+4>>2];j=h+8|0;l=1;do{D=+g[h+(l*24|0)>>2]-+g[h>>2];u=+g[h+(l*24|0)+4>>2]-k;v=+g[h+(l*24|0)+8>>2]-+g[j>>2];g[h+(l*24|0)+16>>2]=((t*u-s*D)*+g[y>>2]+(+g[e>>2]*(s*v-n*u)+ +g[A>>2]*(n*D-t*v)))/+P(+(D*D+u*u+v*v));l=l+1|0}while((l|0)<(f|0))};c[m>>2]=c[h>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2];c[m+12>>2]=c[h+12>>2];B0(b,m,1,f+-1|0);q=d+4|0;r=d+8|0;w=d+12|0;b=d+16|0;l=c[x>>2]|0;f=c[q>>2]|0;if((f|0)==(c[r>>2]|0)?(o=(f|0)!=0?f<<1:1,(f|0)<(o|0)):0){if(!o)j=0;else{j=l5(o*24|0,16)|0;f=c[q>>2]|0}if((f|0)>0){h=0;do{d=j+(h*24|0)|0;m=(c[w>>2]|0)+(h*24|0)|0;c[d>>2]=c[m>>2];c[d+4>>2]=c[m+4>>2];c[d+8>>2]=c[m+8>>2];c[d+12>>2]=c[m+12>>2];c[d+16>>2]=c[m+16>>2];c[d+20>>2]=c[m+20>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[w>>2]|0;if(f){if(a[b>>0]|0)m5(f);c[w>>2]=0}a[b>>0]=1;c[w>>2]=j;c[r>>2]=o;f=c[q>>2]|0}f=(c[w>>2]|0)+(f*24|0)|0;c[f>>2]=c[l>>2];c[f+4>>2]=c[l+4>>2];c[f+8>>2]=c[l+8>>2];c[f+12>>2]=c[l+12>>2];c[f+16>>2]=c[l+16>>2];c[f+20>>2]=c[l+20>>2];f=(c[q>>2]|0)+1|0;c[q>>2]=f;l=(c[x>>2]|0)+24|0;if((f|0)==(c[r>>2]|0)?(p=(f|0)!=0?f<<1:1,(f|0)<(p|0)):0){if(!p)j=0;else{j=l5(p*24|0,16)|0;f=c[q>>2]|0}if((f|0)>0){h=0;do{d=j+(h*24|0)|0;o=(c[w>>2]|0)+(h*24|0)|0;c[d>>2]=c[o>>2];c[d+4>>2]=c[o+4>>2];c[d+8>>2]=c[o+8>>2];c[d+12>>2]=c[o+12>>2];c[d+16>>2]=c[o+16>>2];c[d+20>>2]=c[o+20>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[w>>2]|0;if(f){if(a[b>>0]|0)m5(f);c[w>>2]=0}a[b>>0]=1;c[w>>2]=j;c[r>>2]=p;f=c[q>>2]|0}f=(c[w>>2]|0)+(f*24|0)|0;c[f>>2]=c[l>>2];c[f+4>>2]=c[l+4>>2];c[f+8>>2]=c[l+8>>2];c[f+12>>2]=c[l+12>>2];c[f+16>>2]=c[l+16>>2];c[f+20>>2]=c[l+20>>2];f=(c[q>>2]|0)+1|0;c[q>>2]=f;if((c[B>>2]|0)==2){i=C;return}else m=2;do{a:do if((f|0)>1){h=c[w>>2]|0;d=c[x>>2]|0;l=d+(m*24|0)|0;k=+g[l>>2];n=+g[d+(m*24|0)+4>>2];s=+g[d+(m*24|0)+8>>2];t=+g[e>>2];u=+g[A>>2];v=+g[y>>2];while(1){d=f+-2|0;j=f+-1|0;F=+g[h+(d*24|0)>>2];E=F-+g[h+(j*24|0)>>2];H=+g[h+(d*24|0)+4>>2];I=H-+g[h+(j*24|0)+4>>2];D=+g[h+(d*24|0)+8>>2];G=D-+g[h+(j*24|0)+8>>2];F=F-k;H=H-n;D=D-s;if((E*H-I*F)*v+(t*(I*D-G*H)+u*(G*F-E*D))>0.0)break;c[q>>2]=j;if((j|0)>1)f=j;else{f=j;break a}}if((f|0)==(c[r>>2]|0)?(z=f<<1,(f|0)<(z|0)):0){h=l5(f*48|0,16)|0;f=c[q>>2]|0;if((f|0)>0){j=0;do{d=h+(j*24|0)|0;p=(c[w>>2]|0)+(j*24|0)|0;c[d>>2]=c[p>>2];c[d+4>>2]=c[p+4>>2];c[d+8>>2]=c[p+8>>2];c[d+12>>2]=c[p+12>>2];c[d+16>>2]=c[p+16>>2];c[d+20>>2]=c[p+20>>2];j=j+1|0}while((j|0)!=(f|0))}f=c[w>>2]|0;if(f){if(a[b>>0]|0)m5(f);c[w>>2]=0}a[b>>0]=1;c[w>>2]=h;c[r>>2]=z;f=c[q>>2]|0}f=h+(f*24|0)|0;c[f>>2]=c[l>>2];c[f+4>>2]=c[l+4>>2];c[f+8>>2]=c[l+8>>2];c[f+12>>2]=c[l+12>>2];c[f+16>>2]=c[l+16>>2];c[f+20>>2]=c[l+20>>2];f=(c[q>>2]|0)+1|0;c[q>>2]=f}while(0);m=m+1|0}while((m|0)!=(c[B>>2]|0));i=C;return}function z0(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=b+4|0;e=c[p>>2]|0;if((e|0)==(c[b+8>>2]|0)){x0(b,(e|0)!=0?e<<1:1);e=c[p>>2]|0}n=(c[b+12>>2]|0)+(e*36|0)|0;g=n+16|0;a[g>>0]=1;h=n+12|0;c[h>>2]=0;l=n+4|0;c[l>>2]=0;i=n+8|0;c[i>>2]=0;o=c[d+4>>2]|0;if((o|0)<=0){c[l>>2]=o;o=n+20|0;d=d+20|0;c[o>>2]=c[d>>2];c[o+4>>2]=c[d+4>>2];c[o+8>>2]=c[d+8>>2];c[o+12>>2]=c[d+12>>2];d=c[p>>2]|0;d=d+1|0;c[p>>2]=d;return}j=o<<2;k=l5(j,16)|0;f=c[l>>2]|0;b=c[h>>2]|0;if((f|0)<=0)if(!b){a[g>>0]=1;c[h>>2]=k;c[i>>2]=o;M9(k|0,0,j|0)|0}else m=8;else{e=0;do{c[k+(e<<2)>>2]=c[b+(e<<2)>>2];e=e+1|0}while((e|0)!=(f|0));m=8}if((m|0)==8){if(a[g>>0]|0)m5(b);a[g>>0]=1;c[h>>2]=k;c[i>>2]=o;M9(k|0,0,j|0)|0}f=c[h>>2]|0;c[l>>2]=o;e=c[d+12>>2]|0;b=0;do{c[f+(b<<2)>>2]=c[e+(b<<2)>>2];b=b+1|0}while((b|0)!=(o|0));o=n+20|0;d=d+20|0;c[o>>2]=c[d>>2];c[o+4>>2]=c[d+4>>2];c[o+8>>2]=c[d+8>>2];c[o+12>>2]=c[d+12>>2];d=c[p>>2]|0;d=d+1|0;c[p>>2]=d;return}function A0(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;e=b+44|0;f=b+52|0;g=c[f>>2]|0;d=b+56|0;do if(!g)i=5;else{if((a[d>>0]|0)!=0?(o=0,Ja(494,g|0),h=o,o=0,h&1):0){h=zc()|0;e=b+24|0;f=b+32|0;g=c[f>>2]|0;d=b+36|0;if(g){if((a[d>>0]|0)!=0?(o=0,Ja(494,g|0),g=o,o=0,g&1):0){g=zc(0)|0;Di(g)}c[f>>2]=0}a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;c[b+28>>2]=0;break}c[f>>2]=0;i=5}while(0);do if((i|0)==5){a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;c[b+48>>2]=0;g=b+24|0;e=b+32|0;f=c[e>>2]|0;d=b+36|0;if(f){if((a[d>>0]|0)!=0?(o=0,Ja(494,f|0),i=o,o=0,i&1):0){h=zc()|0;break}c[e>>2]=0}a[d>>0]=1;c[e>>2]=0;c[g>>2]=0;c[b+28>>2]=0;e=b+4|0;f=b+12|0;g=c[f>>2]|0;d=b+16|0;if(!g){a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;b=b+8|0;c[b>>2]=0;return}if(a[d>>0]|0)m5(g);c[f>>2]=0;a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;b=b+8|0;c[b>>2]=0;return}while(0);e=b+4|0;f=b+12|0;g=c[f>>2]|0;d=b+16|0;if(!g){a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;b=b+8|0;c[b>>2]=0;Kc(h|0)}if((a[d>>0]|0)!=0?(o=0,Ja(494,g|0),i=o,o=0,i&1):0){i=zc(0)|0;Di(i)}c[f>>2]=0;a[d>>0]=1;c[f>>2]=0;c[e>>2]=0;b=b+8|0;c[b>>2]=0;Kc(h|0)}function B0(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0;y=i;i=i+32|0;x=y;p=(e+d|0)/2|0;s=a+12|0;t=c[s>>2]|0;u=+g[t+(p*24|0)>>2];v=+g[t+(p*24|0)+4>>2];w=+g[t+(p*24|0)+8>>2];o=+g[t+(p*24|0)+16>>2];p=c[t+(p*24|0)+20>>2]|0;q=b+4|0;r=b+8|0;h=d;f=e;while(1){k=+g[b>>2];l=+g[q>>2];m=+g[r>>2];z=u-k;j=v-l;n=w-m;n=z*z+j*j+n*n;a:while(1){j=+g[t+(h*24|0)+16>>2];do if(j!=o){if(!(j<o))break a}else{A=+g[t+(h*24|0)>>2]-k;z=+g[t+(h*24|0)+4>>2]-l;j=+g[t+(h*24|0)+8>>2]-m;j=A*A+z*z+j*j;if(j!=n)if(j<n)break;else break a;else if((c[t+(h*24|0)+20>>2]|0)<(p|0))break;else break a}while(0);h=h+1|0}b:while(1){j=+g[t+(f*24|0)+16>>2];do if(o!=j){if(!(o<j))break b}else{z=+g[t+(f*24|0)>>2]-k;A=+g[t+(f*24|0)+4>>2]-l;j=+g[t+(f*24|0)+8>>2]-m;j=z*z+A*A+j*j;if(n!=j)if(n<j)break;else break b;else if((p|0)<(c[t+(f*24|0)+20>>2]|0))break;else break b}while(0);f=f+-1|0}if((h|0)<=(f|0)){B=t+(h*24|0)|0;c[x>>2]=c[B>>2];c[x+4>>2]=c[B+4>>2];c[x+8>>2]=c[B+8>>2];c[x+12>>2]=c[B+12>>2];c[x+16>>2]=c[B+16>>2];c[x+20>>2]=c[B+20>>2];t=t+(f*24|0)|0;c[B>>2]=c[t>>2];c[B+4>>2]=c[t+4>>2];c[B+8>>2]=c[t+8>>2];c[B+12>>2]=c[t+12>>2];c[B+16>>2]=c[t+16>>2];c[B+20>>2]=c[t+20>>2];t=(c[s>>2]|0)+(f*24|0)|0;c[t>>2]=c[x>>2];c[t+4>>2]=c[x+4>>2];c[t+8>>2]=c[x+8>>2];c[t+12>>2]=c[x+12>>2];c[t+16>>2]=c[x+16>>2];c[t+20>>2]=c[x+20>>2];h=h+1|0;f=f+-1|0}if((h|0)>(f|0))break;t=c[s>>2]|0}if((f|0)>(d|0))B0(a,b,d,f);if((h|0)>=(e|0)){i=y;return}B0(a,b,h,e);i=y;return}function C0(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;return}function D0(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((e|0)>0)a=0;else return;do{b=d+(a<<4)|0;a=a+1|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0}while((a|0)!=(e|0));return}function E0(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0;e=i;i=i+16|0;m=e;tg[c[(c[b>>2]|0)+68>>2]&255](m,b,d);c[a>>2]=c[m>>2];c[a+4>>2]=c[m+4>>2];c[a+8>>2]=c[m+8>>2];c[a+12>>2]=c[m+12>>2];l=+g[d>>2];k=+g[d+4>>2];f=+g[d+8>>2];d=l*l+k*k+f*f<1.4210854715202004e-014;l=d?-1.0:l;k=d?-1.0:k;f=d?-1.0:f;h=1.0/+P(+(f*f+(l*l+k*k)));j=+Pf[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+j*(h*l);d=a+4|0;g[d>>2]=j*(h*k)+ +g[d>>2];d=a+8|0;g[d>>2]=j*(h*f)+ +g[d>>2];i=e;return}function F0(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0,k=0.0,l=0.0;i=+Pf[c[(c[a>>2]|0)+48>>2]&15](a);h=+Pf[c[(c[a>>2]|0)+48>>2]&15](a);f=+Pf[c[(c[a>>2]|0)+48>>2]&15](a);a=b+48|0;j=b+52|0;l=+g[j>>2]-h;b=b+56|0;k=+g[b>>2]-f;g[d>>2]=+g[a>>2]-i;g[d+4>>2]=l;g[d+8>>2]=k;g[d+12>>2]=0.0;h=h+ +g[j>>2];f=f+ +g[b>>2];g[e>>2]=i+ +g[a>>2];g[e+4>>2]=h;g[e+8>>2]=f;g[e+12>>2]=0.0;return}function G0(a,b,d){a=a|0;b=+b;d=d|0;b=b*.4000000059604645*+Pf[c[(c[a>>2]|0)+48>>2]&15](a);b=b*+Pf[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b;g[d+4>>2]=b;g[d+8>>2]=b;g[d+12>>2]=0.0;return}function H0(a){a=a|0;var b=0;o=0;b=o;o=0;if(!(b&1)){m5(a);return}b=zc()|0;o=0;Ja(494,a|0);a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else Kc(b|0)}function I0(a){a=a|0;return 68631}function J0(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function K0(a){a=a|0;return +(+g[a+28>>2]*+g[a+12>>2])}function L0(a){a=a|0;return}function M0(a){a=a|0;return}function N0(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=24620;f=b+24|0;g=b+32|0;d=c[g>>2]|0;e=b+36|0;if(!d){a[e>>0]=1;c[g>>2]=0;c[f>>2]=0;b=b+28|0;c[b>>2]=0;return}if((a[e>>0]|0)!=0?(o=0,Ja(494,d|0),d=o,o=0,d&1):0){d=zc()|0;o=0;h=o;o=0;if(h&1){h=zc(0)|0;Di(h)}else Kc(d|0)}c[g>>2]=0;a[e>>0]=1;c[g>>2]=0;c[f>>2]=0;h=b+28|0;c[h>>2]=0;return}function O0(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;c[b>>2]=24620;f=b+24|0;g=b+32|0;d=c[g>>2]|0;e=b+36|0;do if(!d)h=5;else{if((a[e>>0]|0)!=0?(o=0,Ja(494,d|0),d=o,o=0,d&1):0){d=zc()|0;o=0;i=o;o=0;if(!(i&1))break;i=zc(0)|0;Di(i)}c[g>>2]=0;h=5}while(0);do if((h|0)==5){a[e>>0]=1;c[g>>2]=0;c[f>>2]=0;c[b+28>>2]=0;o=0;i=o;o=0;if(i&1){d=zc()|0;break}else{m5(b);return}}while(0);o=0;Ja(494,b|0);i=o;o=0;if(i&1){i=zc(0)|0;Di(i)}else Kc(d|0)}function P0(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function Q0(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function R0(a){a=a|0;return (c[a+48>>2]|0)==1|0}function S0(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=a+52|0;c[e>>2]=c[b>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];b=a+68|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[a+48>>2]=1;return}function T0(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=a+52|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];a=a+68|0;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function U0(a,b){a=a|0;b=b|0;return}function V0(a,b){a=a|0;b=b|0;return}function W0(a){a=a|0;return c[a+24>>2]|0}function X0(a,b){a=a|0;b=b|0;return}function Y0(a,b){a=a|0;b=b|0;return}function Z0(a){a=a|0;return 28}function _0(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0;n=i;i=i+48|0;m=n+32|0;l=n+16|0;h=n;H4(a);c[a>>2]=24688;d=a+16|0;e=a+32|0;c[a+48>>2]=b;c[a+4>>2]=21;o=0;f=qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;p=o;o=0;do if(!(p&1)){if(f){o=0;sb(c[(c[b>>2]|0)+48>>2]|0,b|0,d|0,e|0);p=o;o=0;if(p&1)break;i=n;return}d=m+4|0;e=m+8|0;f=a+12|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;g[m>>2]=1.0;o=0;sb(c[(c[a>>2]|0)+68>>2]|0,l|0,a|0,m|0);p=o;o=0;if(((((!(p&1)?(g[a+32>>2]=+g[l>>2]+ +g[f>>2],g[m>>2]=-1.0,o=0,sb(c[(c[a>>2]|0)+68>>2]|0,h|0,a|0,m|0),p=o,o=0,!(p&1)):0)?(c[l>>2]=c[h>>2],c[l+4>>2]=c[h+4>>2],c[l+8>>2]=c[h+8>>2],c[l+12>>2]=c[h+12>>2],g[a+16>>2]=+g[l>>2]-+g[f>>2],c[m>>2]=0,c[m+4>>2]=0,c[m+8>>2]=0,c[m+12>>2]=0,g[d>>2]=1.0,o=0,sb(c[(c[a>>2]|0)+68>>2]|0,l|0,a|0,m|0),p=o,o=0,!(p&1)):0)?(j=l+4|0,g[a+36>>2]=+g[j>>2]+ +g[f>>2],g[d>>2]=-1.0,o=0,sb(c[(c[a>>2]|0)+68>>2]|0,h|0,a|0,m|0),p=o,o=0,!(p&1)):0)?(c[l>>2]=c[h>>2],c[l+4>>2]=c[h+4>>2],c[l+8>>2]=c[h+8>>2],c[l+12>>2]=c[h+12>>2],g[a+20>>2]=+g[j>>2]-+g[f>>2],c[m>>2]=0,c[m+4>>2]=0,c[m+8>>2]=0,c[m+12>>2]=0,g[e>>2]=1.0,o=0,sb(c[(c[a>>2]|0)+68>>2]|0,l|0,a|0,m|0),p=o,o=0,!(p&1)):0)?(k=l+8|0,g[a+40>>2]=+g[k>>2]+ +g[f>>2],g[e>>2]=-1.0,o=0,sb(c[(c[a>>2]|0)+68>>2]|0,h|0,a|0,m|0),p=o,o=0,!(p&1)):0){c[l>>2]=c[h>>2];c[l+4>>2]=c[h+4>>2];c[l+8>>2]=c[h+8>>2];c[l+12>>2]=c[h+12>>2];g[a+24>>2]=+g[k>>2]-+g[f>>2];i=n;return}}while(0);d=zc()|0;o=0;p=o;o=0;if(p&1){p=zc(0)|0;Di(p)}else Kc(d|0)}function $0(a){a=a|0;return}function a1(a){a=a|0;var b=0;o=0;b=o;o=0;if(!(b&1)){m5(a);return}b=zc()|0;o=0;Ja(494,a|0);a=o;o=0;if(a&1){a=zc(0)|0;Di(a)}else Kc(b|0)}function b1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0;J=a+32|0;I=a+16|0;H=a+36|0;G=a+20|0;F=a+40|0;E=a+24|0;x=(+g[J>>2]-+g[I>>2])*.5;z=(+g[H>>2]-+g[G>>2])*.5;m=(+g[F>>2]-+g[E>>2])*.5;q=+Pf[c[(c[a>>2]|0)+48>>2]&15](a);o=+Pf[c[(c[a>>2]|0)+48>>2]&15](a);q=x+q;o=z+o;m=m+ +Pf[c[(c[a>>2]|0)+48>>2]&15](a);z=(+g[J>>2]+ +g[I>>2])*.5;x=(+g[H>>2]+ +g[G>>2])*.5;v=(+g[F>>2]+ +g[E>>2])*.5;D=+g[b>>2];u=+O(+D);C=+g[b+4>>2];t=+O(+C);k=+g[b+8>>2];l=+O(+k);B=+g[b+16>>2];s=+O(+B);A=+g[b+20>>2];r=+O(+A);i=+g[b+24>>2];j=+O(+i);y=+g[b+32>>2];p=+O(+y);w=+g[b+36>>2];n=+O(+w);f=+g[b+40>>2];h=+O(+f);k=z*D+x*C+v*k+ +g[b+48>>2];i=z*B+x*A+v*i+ +g[b+52>>2];f=z*y+x*w+v*f+ +g[b+56>>2];l=q*u+o*t+m*l;j=q*s+o*r+m*j;h=q*p+o*n+m*h;g[d>>2]=k-l;g[d+4>>2]=i-j;g[d+8>>2]=f-h;g[d+12>>2]=0.0;g[e>>2]=l+k;g[e+4>>2]=j+i;g[e+8>>2]=h+f;g[e+12>>2]=0.0;return}function c1(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0;d=i;i=i+48|0;j=d+32|0;f=d+16|0;h=d;l=(c[a+48>>2]|0)+4|0;c[l>>2]=c[b>>2];c[l+4>>2]=c[b+4>>2];c[l+8>>2]=c[b+8>>2];c[l+12>>2]=c[b+12>>2];l=j+4|0;k=j+8|0;b=a+12|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;g[j>>2]=1.0;tg[c[(c[a>>2]|0)+68>>2]&255](f,a,j);g[a+32>>2]=+g[f>>2]+ +g[b>>2];g[j>>2]=-1.0;tg[c[(c[a>>2]|0)+68>>2]&255](h,a,j);c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];g[a+16>>2]=+g[f>>2]-+g[b>>2];c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;g[l>>2]=1.0;tg[c[(c[a>>2]|0)+68>>2]&255](f,a,j);e=f+4|0;g[a+36>>2]=+g[e>>2]+ +g[b>>2];g[l>>2]=-1.0;tg[c[(c[a>>2]|0)+68>>2]&255](h,a,j);c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];g[a+20>>2]=+g[e>>2]-+g[b>>2];c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;g[k>>2]=1.0;tg[c[(c[a>>2]|0)+68>>2]&255](f,a,j);e=f+8|0;g[a+40>>2]=+g[e>>2]+ +g[b>>2];g[k>>2]=-1.0;tg[c[(c[a>>2]|0)+68>>2]&255](h,a,j);c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];g[a+24>>2]=+g[e>>2]-+g[b>>2];i=d;return}function d1(a){a=a|0;return (c[a+48>>2]|0)+4|0}function e1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+48|0;g=f;c[g>>2]=24772;c[g+4>>2]=b;b=g+8|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];b=g+24|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];a=c[a+48>>2]|0;o=0;yb(c[(c[a>>2]|0)+8>>2]|0,a|0,g|0,d|0,e|0);a=o;o=0;if(!(a&1)){i=f;return}e=zc()|0;o=0;g=o;o=0;if(g&1){g=zc(0)|0;Di(g)}else Kc(e|0)}function f1(a,b,d){a=a|0;b=+b;d=d|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function g1(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,p=0.0,q=0.0,r=0,s=0,t=0;f=i;i=i+176|0;s=f+160|0;t=f+136|0;k=f+32|0;h=f+16|0;j=f;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[t+12>>2]=0;c[t+16>>2]=0;c[k>>2]=24792;e=k+4|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[k+20>>2]=1065353216;r=k+24|0;c[r>>2]=c[s>>2];c[r+4>>2]=c[s+4>>2];c[r+8>>2]=c[s+8>>2];c[k+36>>2]=0;c[k+40>>2]=1065353216;s=k+44|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[k+60>>2]=1065353216;c[k+64>>2]=0;s=k+68|0;t=t+4|0;c[s>>2]=c[t>>2];c[s+4>>2]=c[t+4>>2];c[s+8>>2]=c[t+8>>2];c[s+12>>2]=c[t+12>>2];g[k+84>>2]=-999999984306749440.0;q=+g[d>>2];m=+g[d+4>>2];p=m*0.0;l=+g[d+8>>2];n=l*0.0;m=q*+g[r>>2]+m+n;l=q*+g[k+28>>2]+p+l;g[k+88>>2]=q+p+n;g[k+92>>2]=m;g[k+96>>2]=l;g[k+100>>2]=0.0;c[h>>2]=1566444395;c[h+4>>2]=1566444395;c[h+8>>2]=1566444395;g[h+12>>2]=0.0;d=c[(c[b>>2]|0)+64>>2]|0;g[j>>2]=-999999984306749440.0;g[j+4>>2]=-999999984306749440.0;g[j+8>>2]=-999999984306749440.0;g[j+12>>2]=0.0;o=0;yb(d|0,b|0,k|0,j|0,h|0);d=o;o=0;if(!(d&1)){c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];i=f;return}e=zc()|0;o=0;t=o;o=0;if(t&1){t=zc(0)|0;Di(t)}else Kc(e|0)}function h1(a){a=a|0;return 68744}function i1(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function j1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0;e=a+84|0;l=a+4|0;j=+g[a+88>>2];k=+g[a+92>>2];i=+g[a+96>>2];f=j*+g[b>>2]+k*+g[b+4>>2]+i*+g[b+8>>2];h=+g[e>>2];if(f>h){g[e>>2]=f;c[l>>2]=c[b>>2];c[l+4>>2]=c[b+4>>2];c[l+8>>2]=c[b+8>>2];c[l+12>>2]=c[b+12>>2]}else f=h;d=b+16|0;h=j*+g[d>>2]+k*+g[b+20>>2]+i*+g[b+24>>2];if(h>f){g[e>>2]=h;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2]}else h=f;d=b+32|0;f=j*+g[d>>2]+k*+g[b+36>>2]+i*+g[b+40>>2];if(!(f>h))return;g[e>>2]=f;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];return}function k1(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function l1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0,k=0.0,l=0,m=0.0;f=b+16|0;h=+g[b>>2];i=+g[f>>2];j=b+32|0;m=h<i?h:i;k=+g[j>>2];if((m<k?m:k)>+g[a+24>>2])return;l=h>i?b:f;if(+g[(+g[l>>2]>k?l:j)>>2]<+g[a+8>>2])return;f=b+8|0;j=b+24|0;h=+g[f>>2];i=+g[j>>2];l=b+40|0;m=h<i?h:i;k=+g[l>>2];if((m<k?m:k)>+g[a+32>>2])return;j=h>i?f:j;if(+g[(+g[j>>2]>k?j:l)>>2]<+g[a+16>>2])return;f=b+4|0;j=b+20|0;h=+g[f>>2];i=+g[j>>2];l=b+36|0;m=h<i?h:i;k=+g[l>>2];if((m<k?m:k)>+g[a+28>>2])return;j=h>i?f:j;if(+g[(+g[j>>2]>k?j:l)>>2]<+g[a+12>>2])return;a=c[a+4>>2]|0;zg[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);return}function m1(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[a>>2]=24812;c[a+4>>2]=e;c[a+8>>2]=f;c[a+12>>2]=b;c[a+16>>2]=d;c[a+20>>2]=0;return}function n1(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=24812;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=b;c[a+16>>2]=0;c[a+20>>2]=d;return}function o1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0,$=0,aa=0.0,ba=0.0,ca=0.0;o=i;i=i+288|0;j=o+200|0;k=o+64|0;m=o+48|0;f=o+32|0;n=o+16|0;l=o;h=a+16|0;if(!(c[h>>2]|0)){_=c[a+12>>2]|0;N=c[a+20>>2]|0;ca=+g[b>>2];aa=+g[b+4>>2];r=+g[b+8>>2];ba=+g[b+16>>2];p=+g[b+20>>2];B=+g[b+24>>2];y=+g[b+32>>2];D=+g[b+36>>2];C=+g[b+40>>2];P=+g[b+48>>2];O=+g[b+52>>2];v=+g[b+56>>2];M=d+4|0;J=d+20|0;G=d+36|0;L=d+8|0;I=d+24|0;F=d+40|0;Z=+g[d>>2];K=d+16|0;Y=+g[K>>2];H=d+32|0;X=+g[H>>2];U=+g[M>>2];T=+g[J>>2];S=+g[G>>2];t=+g[L>>2];s=+g[I>>2];w=+g[F>>2];j=d+48|0;q=-+g[j>>2];E=d+52|0;u=-+g[E>>2];h=d+56|0;x=-+g[h>>2];W=ca*Z+ba*Y+y*X;V=aa*Z+p*Y+D*X;z=r*Z+B*Y+C*X;R=ca*U+ba*T+y*S;Q=aa*U+p*T+D*S;A=r*U+B*T+C*S;y=ca*t+ba*s+y*w;D=aa*t+p*s+D*w;C=r*t+B*s+C*w;$=c[(c[_>>2]|0)+64>>2]|0;k=N+48|0;B=-+g[k>>2];a=N+52|0;r=-+g[a>>2];b=N+56|0;p=-+g[b>>2];g[f>>2]=W*B+R*r+y*p;g[f+4>>2]=V*B+Q*r+D*p;g[f+8>>2]=z*B+A*r+C*p;g[f+12>>2]=0.0;tg[$&255](m,_,f);p=+g[m>>2];r=+g[m+4>>2];B=+g[m+8>>2];z=P*Z+O*Y+v*X+(Z*q+Y*u+X*x)+(W*p+V*r+z*B);A=P*U+O*T+v*S+(U*q+T*u+S*x)+(R*p+Q*r+A*B);B=P*t+O*s+v*w+(t*q+s*u+w*x)+(y*p+D*r+C*B);C=+g[k>>2];r=+g[a>>2];D=+g[b>>2];p=D*B+(C*z+r*A)-+g[N+64>>2];C=z-C*p;r=A-r*p;D=B-D*p;B=+g[d>>2];A=+g[M>>2];z=+g[L>>2];y=+g[K>>2];x=+g[J>>2];w=+g[I>>2];u=+g[H>>2];s=+g[G>>2];q=+g[F>>2];t=y*C+r*x+D*w+ +g[E>>2];v=C*u+r*s+D*q+ +g[h>>2];g[n>>2]=z*D+(B*C+A*r)+ +g[j>>2];g[n+4>>2]=t;g[n+8>>2]=v;g[n+12>>2]=0.0;v=+g[k>>2];t=+g[a>>2];r=+g[b>>2];g[l>>2]=B*v+A*t+z*r;g[l+4>>2]=v*y+t*x+r*w;g[l+8>>2]=v*u+t*s+r*q;g[l+12>>2]=0.0;sg[c[(c[e>>2]|0)+16>>2]&31](e,l,n,p);i=o;return}else{$=a+4|0;s2(c[$>>2]|0);L=c[a+12>>2]|0;M=c[h>>2]|0;N=c[L+4>>2]|0;_=c[M+4>>2]|0;ba=+Pf[c[(c[L>>2]|0)+48>>2]&15](L);K=c[h>>2]|0;ca=+Pf[c[(c[K>>2]|0)+48>>2]&15](K);D1(j,L,M,N,_,ba,ca,c[$>>2]|0,c[a+8>>2]|0);g[k+128>>2]=999999984306749440.0;c[k>>2]=c[b>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];c[k+12>>2]=c[b+12>>2];$=k+16|0;_=b+16|0;c[$>>2]=c[_>>2];c[$+4>>2]=c[_+4>>2];c[$+8>>2]=c[_+8>>2];c[$+12>>2]=c[_+12>>2];$=k+32|0;_=b+32|0;c[$>>2]=c[_>>2];c[$+4>>2]=c[_+4>>2];c[$+8>>2]=c[_+8>>2];c[$+12>>2]=c[_+12>>2];$=k+48|0;_=b+48|0;c[$>>2]=c[_>>2];c[$+4>>2]=c[_+4>>2];c[$+8>>2]=c[_+8>>2];c[$+12>>2]=c[_+12>>2];$=k+64|0;c[$>>2]=c[d>>2];c[$+4>>2]=c[d+4>>2];c[$+8>>2]=c[d+8>>2];c[$+12>>2]=c[d+12>>2];$=k+80|0;_=d+16|0;c[$>>2]=c[_>>2];c[$+4>>2]=c[_+4>>2];c[$+8>>2]=c[_+8>>2];c[$+12>>2]=c[_+12>>2];$=k+96|0;_=d+32|0;c[$>>2]=c[_>>2];c[$+4>>2]=c[_+4>>2];c[$+8>>2]=c[_+8>>2];c[$+12>>2]=c[_+12>>2];$=k+112|0;_=d+48|0;c[$>>2]=c[_>>2];c[$+4>>2]=c[_+4>>2];c[$+8>>2]=c[_+8>>2];c[$+12>>2]=c[_+12>>2];E1(j,k,e,0,0);i=o;return}}function p1(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0,n=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;ca=i;i=i+336|0;D=ca+288|0;Y=ca+224|0;_=ca+208|0;W=ca+192|0;$=ca+176|0;X=ca+160|0;ba=ca+80|0;T=ca+16|0;Z=ca+96|0;U=ca;aa=ca+32|0;z=+g[e+48>>2]-+g[d+48>>2];A=+g[e+52>>2]-+g[d+52>>2];C=+g[e+56>>2]-+g[d+56>>2];g[_>>2]=z;g[_+4>>2]=A;g[_+8>>2]=C;g[_+12>>2]=0.0;LV(d,e,D,Y);w=+g[Y>>2];u=+g[D>>2]*w;v=w*+g[D+4>>2];w=w*+g[D+8>>2];g[W>>2]=u;g[W+4>>2]=v;g[W+8>>2]=w;g[W+12>>2]=0.0;x=+g[h+48>>2]-+g[f+48>>2];y=+g[h+52>>2]-+g[f+52>>2];B=+g[h+56>>2]-+g[f+56>>2];g[$>>2]=x;g[$+4>>2]=y;g[$+8>>2]=B;g[$+12>>2]=0.0;LV(f,h,D,Y);s=+g[Y>>2];q=+g[D>>2]*s;r=s*+g[D+4>>2];s=s*+g[D+8>>2];g[X>>2]=q;g[X+4>>2]=r;g[X+8>>2]=s;g[X+12>>2]=0.0;e=c[b+12>>2]|0;t=+Pf[c[(c[e>>2]|0)+16>>2]&15](e);e=c[b+16>>2]|0;if(!e)n=0.0;else n=+Pf[c[(c[e>>2]|0)+16>>2]&15](e);v=t*+P(+(u*u+v*v+w*w))+n*+P(+(q*q+r*r+s*s));u=x-z;t=y-A;s=B-C;if(v+ +P(+(u*u+t*t+s*s))==0.0){j=0;i=ca;return j|0}c[D>>2]=24832;h=D+36|0;g[h>>2]=999999984306749440.0;e=D+40|0;a[e>>0]=0;o=0;yb(86,b|0,d|0,f|0,D|0);S=o;o=0;if(S&1){ca=zc()|0;Kc(ca|0)}S=(a[e>>0]|0)==0;R=D+20|0;c[ba>>2]=c[R>>2];c[ba+4>>2]=c[R+4>>2];c[ba+8>>2]=c[R+8>>2];c[ba+12>>2]=c[R+12>>2];a:do if(!S?(V=j+172|0,l=c[D+4>>2]|0,m=c[D+8>>2]|0,p=c[D+12>>2]|0,C=u*(c[k>>2]=l,+g[k>>2]),C=C+t*(c[k>>2]=m,+g[k>>2]),!(v+(C+s*(c[k>>2]=p,+g[k>>2]))<=1.1920928955078125e-007)):0){q=+g[D+16>>2];n=+g[h>>2]+ +g[V>>2];D=j+168|0;E=aa+36|0;F=aa+40|0;G=aa+20|0;H=aa+4|0;I=aa+8|0;J=aa+12|0;K=aa+16|0;L=Y+48|0;M=U+4|0;N=U+8|0;O=U+12|0;Q=T+4|0;R=T+8|0;S=T+12|0;b:do if(n>1.0000000474974513e-003){h=l;r=n;q=0.0;l=0;while(1){e=c[D>>2]|0;if((e|0)!=0?(da=c[(c[e>>2]|0)+20>>2]|0,c[T>>2]=1065353216,c[Q>>2]=1065353216,c[R>>2]=1065353216,g[S>>2]=0.0,o=0,ta(da|0,e|0,ba|0,.20000000298023224,T|0),e=o,o=0,e&1):0){m=8;break}n=u*(c[k>>2]=h,+g[k>>2]);n=t*(c[k>>2]=m,+g[k>>2])+n;n=v+(s*(c[k>>2]=p,+g[k>>2])+n);if(n<=1.1920928955078125e-007){l=0;break a}n=q+r/n;if(!(!(n<=q)&(!(n<0.0)&!(n>1.0)))){l=0;break a}nU(d,_,W,n,Y);nU(f,$,X,n,Z);m=c[D>>2]|0;if((m|0)!=0?(da=c[(c[m>>2]|0)+20>>2]|0,c[U>>2]=1065353216,c[M>>2]=0,c[N>>2]=0,g[O>>2]=0.0,o=0,ta(da|0,m|0,L|0,.20000000298023224,U|0),da=o,o=0,da&1):0){m=8;break}o=0;ia(c[c[j>>2]>>2]|0,j|0,+n);da=o;o=0;if(da&1){m=8;break}c[aa>>2]=24832;g[E>>2]=999999984306749440.0;a[F>>0]=0;o=0;yb(86,b|0,Y|0,Z|0,aa|0);da=o;o=0;if(da&1){m=20;break}if(!(a[F>>0]|0)){m=22;break}q=+g[E>>2];r=+g[V>>2];c[ba>>2]=c[G>>2];c[ba+4>>2]=c[G+4>>2];c[ba+8>>2]=c[G+8>>2];c[ba+12>>2]=c[G+12>>2];da=l;l=l+1|0;if((da|0)>63){m=23;break}p=c[J>>2]|0;m=c[I>>2]|0;e=c[H>>2]|0;r=q+r;if(!(r>1.0000000474974513e-003)){q=+g[K>>2];l=e;break b}else{h=e;q=n}}if((m|0)==8){da=zc()|0;Kc(da|0)}else if((m|0)==20){da=zc()|0;Kc(da|0)}else if((m|0)==22){o=0;sb(c[(c[j>>2]|0)+8>>2]|0,j|0,-1,l|0);da=o;o=0;if(!(da&1))m=24}else if((m|0)==23?(o=0,sb(c[(c[j>>2]|0)+8>>2]|0,j|0,-2,l|0),da=o,o=0,!(da&1)):0)m=24;if((m|0)==24){l=0;break a}da=zc()|0;Kc(da|0)}else n=0.0;while(0);g[j+164>>2]=n;c[j+132>>2]=l;c[j+136>>2]=m;c[j+140>>2]=p;g[j+144>>2]=q;l=j+148|0;c[l>>2]=c[ba>>2];c[l+4>>2]=c[ba+4>>2];c[l+8>>2]=c[ba+8>>2];c[l+12>>2]=c[ba+12>>2];l=1}else l=0;while(0);da=l;i=ca;return da|0}function q1(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function r1(a){a=a|0;$5(a);return}function s1(a,b,c){a=a|0;b=b|0;c=c|0;return}function t1(a,b,c){a=a|0;b=b|0;c=c|0;return}function u1(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,i=0;h=b+36|0;if(!(+g[h>>2]>f))return;a[b+40>>0]=1;i=b+4|0;c[i>>2]=c[d>>2];c[i+4>>2]=c[d+4>>2];c[i+8>>2]=c[d+8>>2];c[i+12>>2]=c[d+12>>2];b=b+20|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];g[h>>2]=f;return}function v1(a){a=a|0;return}function w1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a>>2]=24860;c[a+4>>2]=e;c[a+8>>2]=b;c[a+12>>2]=d;return}function x1(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0.0,n=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0.0,R=0.0,S=0.0,T=0,U=0;U=i;i=i+288|0;T=U+264|0;O=U+216|0;M=U+136|0;N=U;P=b+4|0;s2(c[P>>2]|0);I=d+48|0;J=e+48|0;K=e+52|0;L=d+52|0;C=e+56|0;D=d+56|0;E=f+48|0;F=h+48|0;G=h+52|0;H=f+52|0;y=h+56|0;z=f+56|0;Q=+g[J>>2]-+g[I>>2]-(+g[F>>2]-+g[E>>2]);R=+g[K>>2]-+g[L>>2]-(+g[G>>2]-+g[H>>2]);S=+g[C>>2]-+g[D>>2]-(+g[y>>2]-+g[z>>2]);c[O>>2]=24832;A=O+36|0;g[A>>2]=999999984306749440.0;B=O+40|0;a[B>>0]=0;o=0;fa(29,M|0,c[b+8>>2]|0,c[b+12>>2]|0,c[P>>2]|0,0);P=o;o=0;if(P&1){U=zc()|0;Kc(U|0)}g[N+128>>2]=999999984306749440.0;c[N>>2]=c[d>>2];c[N+4>>2]=c[d+4>>2];c[N+8>>2]=c[d+8>>2];c[N+12>>2]=c[d+12>>2];t=N+16|0;s=d+16|0;c[t>>2]=c[s>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[t+12>>2]=c[s+12>>2];t=N+32|0;s=d+32|0;c[t>>2]=c[s>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[t+12>>2]=c[s+12>>2];t=N+48|0;c[t>>2]=c[I>>2];c[t+4>>2]=c[I+4>>2];c[t+8>>2]=c[I+8>>2];c[t+12>>2]=c[I+12>>2];s=N+64|0;c[s>>2]=c[f>>2];c[s+4>>2]=c[f+4>>2];c[s+8>>2]=c[f+8>>2];c[s+12>>2]=c[f+12>>2];s=N+80|0;P=f+16|0;c[s>>2]=c[P>>2];c[s+4>>2]=c[P+4>>2];c[s+8>>2]=c[P+8>>2];c[s+12>>2]=c[P+12>>2];s=N+96|0;P=f+32|0;c[s>>2]=c[P>>2];c[s+4>>2]=c[P+4>>2];c[s+8>>2]=c[P+8>>2];c[s+12>>2]=c[P+12>>2];s=N+112|0;c[s>>2]=c[E>>2];c[s+4>>2]=c[E+4>>2];c[s+8>>2]=c[E+8>>2];c[s+12>>2]=c[E+12>>2];o=0;fa(11,M|0,N|0,O|0,0,0);P=o;o=0;if(P&1){U=zc()|0;Kc(U|0)}P=(a[B>>0]|0)==0;u=O+20|0;c[T>>2]=c[u>>2];c[T+4>>2]=c[u+4>>2];c[T+8>>2]=c[u+8>>2];c[T+12>>2]=c[u+12>>2];if(P){j=0;i=U;return j|0}l=+g[A>>2];v=O+4|0;w=O+8|0;x=O+12|0;P=O+16|0;m=+g[P>>2];d=c[v>>2]|0;h=c[w>>2]|0;e=c[x>>2]|0;do if(l>1.0000000474974513e-003){f=N+52|0;p=N+56|0;q=N+116|0;r=N+120|0;n=l;m=0.0;b=0;while(1){if((b|0)>31){e=0;b=20;break}l=Q*(c[k>>2]=d,+g[k>>2]);l=l+R*(c[k>>2]=h,+g[k>>2]);l=m-n/(l+S*(c[k>>2]=e,+g[k>>2]));if(!(!(l<=m)&(!(l<0.0)&!(l>1.0)))){e=0;b=20;break}o=0;ia(c[c[j>>2]>>2]|0,j|0,+l);d=o;o=0;if(d&1){b=8;break}n=1.0-l;g[t>>2]=n*+g[I>>2]+l*+g[J>>2];g[f>>2]=n*+g[L>>2]+l*+g[K>>2];g[p>>2]=n*+g[D>>2]+l*+g[C>>2];g[s>>2]=n*+g[E>>2]+l*+g[F>>2];g[q>>2]=n*+g[H>>2]+l*+g[G>>2];g[r>>2]=n*+g[z>>2]+l*+g[y>>2];o=0;fa(11,M|0,N|0,O|0,0,0);d=o;o=0;if(d&1){b=8;break}if(!(a[B>>0]|0)){e=0;b=20;break}n=+g[A>>2];if(n<0.0){b=15;break};c[T>>2]=c[u>>2];c[T+4>>2]=c[u+4>>2];c[T+8>>2]=c[u+8>>2];c[T+12>>2]=c[u+12>>2];d=c[v>>2]|0;h=c[w>>2]|0;e=c[x>>2]|0;if(!(n>1.0000000474974513e-003)){b=17;break}else{m=l;b=b+1|0}}if((b|0)==8){U=zc()|0;Kc(U|0)}else if((b|0)==15){g[j+164>>2]=l;N=c[w>>2]|0;O=c[x>>2]|0;T=c[P>>2]|0;c[j+132>>2]=c[v>>2];c[j+136>>2]=N;c[j+140>>2]=O;c[j+144>>2]=T;j=j+148|0;c[j>>2]=c[u>>2];c[j+4>>2]=c[u+4>>2];c[j+8>>2]=c[u+8>>2];c[j+12>>2]=c[u+12>>2];j=1;i=U;return j|0}else if((b|0)==17){m=+g[P>>2];break}else if((b|0)==20){i=U;return e|0}}else l=0.0;while(0);Q=Q*(c[k>>2]=d,+g[k>>2]);R=Q+R*(c[k>>2]=h,+g[k>>2]);if(R+S*(c[k>>2]=e,+g[k>>2])>=-+g[j+172>>2]){j=0;i=U;return j|0}g[j+164>>2]=l;c[j+132>>2]=d;c[j+136>>2]=h;c[j+140>>2]=e;g[j+144>>2]=m;j=j+148|0;c[j>>2]=c[T>>2];c[j+4>>2]=c[T+4>>2];c[j+8>>2]=c[T+8>>2];c[j+12>>2]=c[T+12>>2];j=1;i=U;return j|0}function y1(a){a=a|0;var b=0;o=0;b=o;o=0;if(b&1){b=zc()|0;$5(a);Kc(b|0)}else{$5(a);return}}function z1(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0.0,o=0.0;a=i;i=i+80|0;m=a+56|0;b=a;o=+g[h+52>>2]-+g[f+52>>2];n=+g[h+56>>2]-+g[f+56>>2];g[m>>2]=+g[h+48>>2]-+g[f+48>>2];g[m+4>>2]=o;g[m+8>>2]=n;g[m+12>>2]=0.0;if(X4(d,f,e,h,m,b,1)|0){h=b+4|0;c[k>>2]=c[h>>2];c[k+4>>2]=c[h+4>>2];c[k+8>>2]=c[h+8>>2];c[k+12>>2]=c[h+12>>2];k=b+20|0;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];c[l+8>>2]=c[k+8>>2];c[l+12>>2]=c[k+12>>2];l=b+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=1;i=a;return l|0}if(!(W4(d,f,e,h,m,b)|0)){l=0;i=a;return l|0}h=b+4|0;c[k>>2]=c[h>>2];c[k+4>>2]=c[h+4>>2];c[k+8>>2]=c[h+8>>2];c[k+12>>2]=c[h+12>>2];k=b+20|0;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];c[l+8>>2]=c[k+8>>2];c[l+12>>2]=c[k+12>>2];l=b+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=0;i=a;return l|0}function A1(a){a=a|0;return}function B1(a){a=a|0;$5(a);return}function C1(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;c[b>>2]=24908;c[b+4>>2]=0;c[b+8>>2]=1065353216;c[b+12>>2]=0;g[b+16>>2]=0.0;c[b+20>>2]=h;c[b+24>>2]=f;c[b+28>>2]=d;c[b+32>>2]=e;c[b+36>>2]=c[d+4>>2];c[b+40>>2]=c[e+4>>2];g[b+44>>2]=+Pf[c[(c[d>>2]|0)+48>>2]&15](d);g[b+48>>2]=+Pf[c[(c[e>>2]|0)+48>>2]&15](e);a[b+52>>0]=0;c[b+60>>2]=-1;c[b+72>>2]=1;c[b+76>>2]=1;return}function D1(b,d,e,f,h,i,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=+i;j=+j;k=k|0;l=l|0;c[b>>2]=24908;c[b+4>>2]=0;c[b+8>>2]=1065353216;c[b+12>>2]=0;g[b+16>>2]=0.0;c[b+20>>2]=l;c[b+24>>2]=k;c[b+28>>2]=d;c[b+32>>2]=e;c[b+36>>2]=f;c[b+40>>2]=h;g[b+44>>2]=i;g[b+48>>2]=j;a[b+52>>0]=0;c[b+60>>2]=-1;c[b+72>>2]=1;c[b+76>>2]=1;return}function E1(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;F1(a,b,c,d);return}function F1(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0.0,bb=0.0,cb=0.0,db=0,eb=0,fb=0,gb=0.0,hb=0.0,ib=0.0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0.0;qb=i;i=i+384|0;nb=qb+304|0;Ua=qb+224|0;ob=qb+208|0;lb=qb+320|0;mb=qb+240|0;Ia=qb+192|0;Ja=qb+176|0;Ea=qb+160|0;Ga=qb+144|0;Fa=qb+128|0;Ha=qb+112|0;Ka=qb+96|0;La=qb+80|0;Va=qb+64|0;Wa=qb+48|0;kb=qb+32|0;jb=qb+16|0;Xa=qb;Ya=b+56|0;g[Ya>>2]=0.0;_a=nb+4|0;$a=nb+8|0;Sa=nb+12|0;c[nb>>2]=0;c[nb+4>>2]=0;c[nb+8>>2]=0;c[nb+12>>2]=0;c[lb>>2]=c[d>>2];c[lb+4>>2]=c[d+4>>2];c[lb+8>>2]=c[d+8>>2];c[lb+12>>2]=c[d+12>>2];eb=lb+16|0;L=d+16|0;c[eb>>2]=c[L>>2];c[eb+4>>2]=c[L+4>>2];c[eb+8>>2]=c[L+8>>2];c[eb+12>>2]=c[L+12>>2];eb=lb+32|0;L=d+32|0;c[eb>>2]=c[L>>2];c[eb+4>>2]=c[L+4>>2];c[eb+8>>2]=c[L+8>>2];c[eb+12>>2]=c[L+12>>2];eb=lb+48|0;L=d+48|0;c[eb>>2]=c[L>>2];c[eb+4>>2]=c[L+4>>2];c[eb+8>>2]=c[L+8>>2];c[eb+12>>2]=c[L+12>>2];L=d+64|0;c[mb>>2]=c[L>>2];c[mb+4>>2]=c[L+4>>2];c[mb+8>>2]=c[L+8>>2];c[mb+12>>2]=c[L+12>>2];db=mb+16|0;_=d+80|0;c[db>>2]=c[_>>2];c[db+4>>2]=c[_+4>>2];c[db+8>>2]=c[_+8>>2];c[db+12>>2]=c[_+12>>2];db=mb+32|0;_=d+96|0;c[db>>2]=c[_>>2];c[db+4>>2]=c[_+4>>2];c[db+8>>2]=c[_+8>>2];c[db+12>>2]=c[_+12>>2];db=mb+48|0;_=d+112|0;c[db>>2]=c[_>>2];c[db+4>>2]=c[_+4>>2];c[db+8>>2]=c[_+8>>2];c[db+12>>2]=c[_+12>>2];q=+g[eb>>2];t=+g[db>>2];_=lb+52|0;r=+g[_>>2];$=mb+52|0;u=+g[$>>2];C=lb+56|0;s=+g[C>>2];D=mb+56|0;w=+g[D>>2];ab=(q+t)*.5;bb=(r+u)*.5;cb=(s+w)*.5;g[eb>>2]=q-ab;g[_>>2]=r-bb;g[C>>2]=s-cb;g[db>>2]=t-ab;g[$>>2]=u-bb;g[D>>2]=w-cb;db=b+28|0;eb=b+32|0;if(((c[(c[db>>2]|0)+4>>2]|0)+-17|0)>>>0<2)m=((c[(c[eb>>2]|0)+4>>2]|0)+-17|0)>>>0<2;else m=0;p=+g[b+44>>2];q=+g[b+48>>2];c[6224]=(c[6224]|0)+1;Oa=(a[b+52>>0]|0)==0;aa=b+64|0;c[aa>>2]=0;fb=b+4|0;c[fb>>2]=0;Pa=b+8|0;c[Pa>>2]=1065353216;Qa=b+12|0;c[Qa>>2]=0;Ra=b+16|0;g[Ra>>2]=0.0;Ma=b+68|0;c[Ma>>2]=0;Ta=b+60|0;c[Ta>>2]=-1;p=Oa?p:0.0;q=Oa?q:0.0;o=p+q;Oa=b+24|0;s2(c[Oa>>2]|0);ba=d+16|0;ca=d+32|0;da=d+4|0;ea=d+20|0;fa=d+36|0;ga=d+8|0;ha=d+24|0;ia=d+40|0;ja=Ia+4|0;ka=Ia+8|0;la=Ia+12|0;ma=d+80|0;na=d+96|0;oa=d+68|0;pa=d+84|0;qa=d+100|0;ra=d+72|0;sa=d+88|0;ta=d+104|0;ua=Ja+4|0;va=Ja+8|0;wa=Ja+12|0;xa=Ea+4|0;ya=lb+4|0;za=Ea+8|0;Aa=lb+8|0;Ba=lb+16|0;Ca=lb+20|0;Da=lb+24|0;v=lb+32|0;x=lb+36|0;y=lb+40|0;E=lb+48|0;F=Fa+4|0;G=Fa+8|0;H=Fa+12|0;I=Ga+4|0;J=mb+4|0;K=Ga+8|0;M=mb+8|0;N=mb+16|0;O=mb+20|0;Q=mb+24|0;z=mb+32|0;A=mb+36|0;B=mb+40|0;R=mb+48|0;S=Ha+4|0;T=Ha+8|0;U=Ha+12|0;V=Ka+4|0;W=Ka+8|0;X=Ka+12|0;Za=d+128|0;Y=La+4|0;Z=La+8|0;a:do if(m){h=999999984306749440.0;while(1){j=+g[fb>>2];l=-j;t=+g[Pa>>2];n=-t;u=+g[Qa>>2];w=-u;s=+g[da>>2]*l+ +g[ea>>2]*n+ +g[fa>>2]*w;r=+g[ga>>2]*l+ +g[ha>>2]*n+ +g[ia>>2]*w;g[Ia>>2]=+g[d>>2]*l+ +g[ba>>2]*n+ +g[ca>>2]*w;g[ja>>2]=s;g[ka>>2]=r;g[la>>2]=0.0;r=j*+g[oa>>2]+t*+g[pa>>2]+u*+g[qa>>2];s=j*+g[ra>>2]+t*+g[sa>>2]+u*+g[ta>>2];g[Ja>>2]=+g[L>>2]*j+ +g[ma>>2]*t+ +g[na>>2]*u;g[ua>>2]=r;g[va>>2]=s;g[wa>>2]=0.0;U$(Ea,c[db>>2]|0,Ia);U$(Ga,c[eb>>2]|0,Ja);s=+g[Ea>>2];r=+g[xa>>2];u=+g[za>>2];t=s*+g[lb>>2]+r*+g[ya>>2]+u*+g[Aa>>2]+ +g[E>>2];u=s*+g[Ba>>2]+r*+g[Ca>>2]+u*+g[Da>>2]+ +g[_>>2];g[Fa>>2]=t;g[F>>2]=u;g[H>>2]=0.0;r=+g[Ga>>2];s=+g[I>>2];j=+g[K>>2];w=r*+g[mb>>2]+s*+g[J>>2]+j*+g[M>>2]+ +g[R>>2];j=r*+g[N>>2]+s*+g[O>>2]+j*+g[Q>>2]+ +g[$>>2];g[Ha>>2]=w;g[S>>2]=j;g[U>>2]=0.0;g[G>>2]=0.0;g[T>>2]=0.0;w=t-w;j=u-j;g[Ka>>2]=w;g[V>>2]=j;g[W>>2]=0.0;g[X>>2]=0.0;j=+g[fb>>2]*w+ +g[Pa>>2]*j+ +g[Qa>>2]*0.0;if(j>0.0?j*j>h*+g[Za>>2]:0){pb=15;break a}if(y2(c[Oa>>2]|0,Ka)|0){pb=17;break a}j=h-j;if(j<=h*9.999999974752427e-007){pb=19;break a}t2(c[Oa>>2]|0,Ka,Fa,Ha);if(!(x2(c[Oa>>2]|0,La)|0)){pb=21;break a}t=+g[La>>2];u=+g[Y>>2];w=+g[Z>>2];j=h;h=t*t+u*u+w*w;if(h<9.999999974752427e-007){h=j;pb=23;break a}if(j-h<=j*1.1920928955078125e-007){pb=25;break a};c[fb>>2]=c[La>>2];c[fb+4>>2]=c[La+4>>2];c[fb+8>>2]=c[La+8>>2];c[fb+12>>2]=c[La+12>>2];D=c[aa>>2]|0;c[aa>>2]=D+1;if((D|0)>1e3){w=0.0;x=0;break a}if((c[c[Oa>>2]>>2]|0)==4){pb=28;break}}}else{h=999999984306749440.0;while(1){s=+g[fb>>2];w=-s;r=+g[Pa>>2];u=-r;t=+g[Qa>>2];j=-t;n=+g[da>>2]*w+ +g[ea>>2]*u+ +g[fa>>2]*j;l=+g[ga>>2]*w+ +g[ha>>2]*u+ +g[ia>>2]*j;g[Ia>>2]=+g[d>>2]*w+ +g[ba>>2]*u+ +g[ca>>2]*j;g[ja>>2]=n;g[ka>>2]=l;g[la>>2]=0.0;l=s*+g[oa>>2]+r*+g[pa>>2]+t*+g[qa>>2];n=s*+g[ra>>2]+r*+g[sa>>2]+t*+g[ta>>2];g[Ja>>2]=+g[L>>2]*s+ +g[ma>>2]*r+ +g[na>>2]*t;g[ua>>2]=l;g[va>>2]=n;g[wa>>2]=0.0;U$(Ea,c[db>>2]|0,Ia);U$(Ga,c[eb>>2]|0,Ja);n=+g[Ea>>2];l=+g[xa>>2];t=+g[za>>2];r=n*+g[lb>>2]+l*+g[ya>>2]+t*+g[Aa>>2]+ +g[E>>2];s=n*+g[Ba>>2]+l*+g[Ca>>2]+t*+g[Da>>2]+ +g[_>>2];t=n*+g[v>>2]+l*+g[x>>2]+t*+g[y>>2]+ +g[C>>2];g[Fa>>2]=r;g[F>>2]=s;g[G>>2]=t;g[H>>2]=0.0;l=+g[Ga>>2];n=+g[I>>2];j=+g[K>>2];u=l*+g[mb>>2]+n*+g[J>>2]+j*+g[M>>2]+ +g[R>>2];w=l*+g[N>>2]+n*+g[O>>2]+j*+g[Q>>2]+ +g[$>>2];j=l*+g[z>>2]+n*+g[A>>2]+j*+g[B>>2]+ +g[D>>2];g[Ha>>2]=u;g[S>>2]=w;g[T>>2]=j;g[U>>2]=0.0;u=r-u;w=s-w;j=t-j;g[Ka>>2]=u;g[V>>2]=w;g[W>>2]=j;g[X>>2]=0.0;j=+g[fb>>2]*u+ +g[Pa>>2]*w+ +g[Qa>>2]*j;if(j>0.0?j*j>h*+g[Za>>2]:0){pb=15;break a}if(y2(c[Oa>>2]|0,Ka)|0){pb=17;break a}j=h-j;if(j<=h*9.999999974752427e-007){pb=19;break a}t2(c[Oa>>2]|0,Ka,Fa,Ha);if(!(x2(c[Oa>>2]|0,La)|0)){pb=21;break a}t=+g[La>>2];u=+g[Y>>2];w=+g[Z>>2];j=h;h=t*t+u*u+w*w;if(h<9.999999974752427e-007){h=j;pb=23;break a}if(j-h<=j*1.1920928955078125e-007){pb=25;break a};c[fb>>2]=c[La>>2];c[fb+4>>2]=c[La+4>>2];c[fb+8>>2]=c[La+8>>2];c[fb+12>>2]=c[La+12>>2];m=c[aa>>2]|0;c[aa>>2]=m+1;if((m|0)>1e3){w=0.0;x=0;break a}if((c[c[Oa>>2]>>2]|0)==4){pb=28;break}}}while(0);if((pb|0)==15){c[Ma>>2]=10;pb=29}else if((pb|0)==17){c[Ma>>2]=1;pb=29}else if((pb|0)==19){c[Ma>>2]=!(j<=0.0)?11:2;pb=29}else if((pb|0)==21){c[Ma>>2]=3;pb=29}else if((pb|0)==23){c[fb>>2]=c[La>>2];c[fb+4>>2]=c[La+4>>2];c[fb+8>>2]=c[La+8>>2];c[fb+12>>2]=c[La+12>>2];c[Ma>>2]=6;pb=29}else if((pb|0)==25){c[Ma>>2]=12;pb=29}else if((pb|0)==28){c[Ma>>2]=13;w=0.0;x=0}do if((pb|0)==29){z2(c[Oa>>2]|0,Ua,ob);c[nb>>2]=c[fb>>2];c[nb+4>>2]=c[fb+4>>2];c[nb+8>>2]=c[fb+8>>2];c[nb+12>>2]=c[fb+12>>2];j=+g[fb>>2];k=+g[Pa>>2];l=+g[Qa>>2];n=j*j+k*k+l*l;if(n<.0001)c[Ma>>2]=5;if(n>1.4210854715202004e-014){w=1.0/+P(+n);g[nb>>2]=w*+g[nb>>2];g[_a>>2]=w*+g[_a>>2];g[$a>>2]=w*+g[$a>>2];u=+P(+h);t=p/u;g[Ua>>2]=+g[Ua>>2]-t*j;x=Ua+4|0;g[x>>2]=+g[x>>2]-t*k;x=Ua+8|0;g[x>>2]=+g[x>>2]-t*l;u=q/u;g[ob>>2]=u*j+ +g[ob>>2];x=ob+4|0;g[x>>2]=u*k+ +g[x>>2];x=ob+8|0;g[x>>2]=u*l+ +g[x>>2];c[Ta>>2]=1;w=1.0/w-o;x=1;break}else{c[Ta>>2]=2;w=0.0;x=0;break}}while(0);if(((c[b+72>>2]|0)!=0?(c[b+20>>2]|0)!=0:0)?(c[Ma>>2]|0)!=0:0)m=o+w<.01;else m=0;v=x^1;do if(m|v?(Na=c[b+20>>2]|0,(Na|0)!=0):0){c[6223]=(c[6223]|0)+1;c[fb>>2]=0;c[fb+4>>2]=0;c[fb+8>>2]=0;c[fb+12>>2]=0;if(!(Rf[c[(c[Na>>2]|0)+8>>2]&3](Na,c[Oa>>2]|0,c[db>>2]|0,c[eb>>2]|0,lb,mb,fb,Va,Wa,f)|0)){l=+g[fb>>2];k=+g[Pa>>2];j=+g[Qa>>2];if(!(l*l+k*k+j*j>0.0)){pb=52;break}t=+g[Va>>2]-+g[Wa>>2];u=+g[Va+4>>2]-+g[Wa+4>>2];h=+g[Va+8>>2]-+g[Wa+8>>2];h=+P(+(t*t+u*u+h*h))-o;if(h<w|v){c[Ua>>2]=c[Va>>2];c[Ua+4>>2]=c[Va+4>>2];c[Ua+8>>2]=c[Va+8>>2];c[Ua+12>>2]=c[Va+12>>2];c[ob>>2]=c[Wa>>2];c[ob+4>>2]=c[Wa+4>>2];c[ob+8>>2]=c[Wa+8>>2];c[ob+12>>2]=c[Wa+12>>2];g[Ua>>2]=+g[Ua>>2]-p*l;Wa=Ua+4|0;g[Wa>>2]=+g[Wa>>2]-p*k;Wa=Ua+8|0;g[Wa>>2]=+g[Wa>>2]-p*j;g[ob>>2]=q*l+ +g[ob>>2];Wa=ob+4|0;g[Wa>>2]=q*k+ +g[Wa>>2];Wa=ob+8|0;g[Wa>>2]=q*j+ +g[Wa>>2];c[nb>>2]=c[fb>>2];c[nb+4>>2]=c[fb+4>>2];c[nb+8>>2]=c[fb+8>>2];c[nb+12>>2]=c[fb+12>>2];s=+g[nb>>2];t=+g[_a>>2];u=+g[$a>>2];w=1.0/+P(+(s*s+t*t+u*u));g[nb>>2]=s*w;g[_a>>2]=t*w;g[$a>>2]=u*w;c[Ta>>2]=6;break}c[Ta>>2]=5;if(x){h=w;break}i=qb;return}p=+g[Wa>>2];q=+g[Va>>2];l=p-q;r=+g[Wa+4>>2];s=+g[Va+4>>2];k=r-s;t=+g[Wa+8>>2];u=+g[Va+8>>2];j=t-u;h=l*l+k*k+j*j;if(!(h<=1.4210854715202004e-014)){o=j;n=l;l=0.0}else{rb=+g[b+4>>2];j=+g[Pa>>2];h=+g[Qa>>2];o=h;k=j;n=rb;l=+g[Ra>>2];h=rb*rb+j*j+h*h}if(!(h>1.4210854715202004e-014)){c[Ta>>2]=9;if(x){h=w;break}i=qb;return}j=1.0/+P(+h);q=q-p;rb=s-r;h=u-t;h=-+P(+(q*q+rb*rb+h*h));if(w>h|v){c[Ua>>2]=c[Va>>2];c[Ua+4>>2]=c[Va+4>>2];c[Ua+8>>2]=c[Va+8>>2];c[Ua+12>>2]=c[Va+12>>2];c[ob>>2]=c[Wa>>2];c[ob+4>>2]=c[Wa+4>>2];c[ob+8>>2]=c[Wa+8>>2];c[ob+12>>2]=c[Wa+12>>2];g[nb>>2]=n*j;g[_a>>2]=k*j;g[$a>>2]=o*j;g[Sa>>2]=l;c[Ta>>2]=3;break}c[Ta>>2]=8;if(x)h=w;else{i=qb;return}}else pb=52;while(0);if((pb|0)==52)if(x)h=w;else{i=qb;return}if(!(h<0.0)?!(h*h<+g[Za>>2]):0){i=qb;return}if((c[b+76>>2]|0)!=0?(db=c[db>>2]|0,zg[c[(c[db>>2]|0)+8>>2]&127](db,lb,kb,jb),lb=jb+4|0,db=kb+4|0,pb=jb+8|0,b=kb+8|0,u=(+g[jb>>2]+ +g[kb>>2])*.5,w=(+g[lb>>2]+ +g[db>>2])*.5,rb=(+g[pb>>2]+ +g[b>>2])*.5,eb=c[eb>>2]|0,zg[c[(c[eb>>2]|0)+8>>2]&127](eb,mb,kb,jb),gb=+g[nb>>2],hb=+g[_a>>2],ib=+g[$a>>2],(u-(+g[kb>>2]+ +g[jb>>2])*.5)*gb+(w-(+g[db>>2]+ +g[lb>>2])*.5)*hb+(rb-(+g[b>>2]+ +g[pb>>2])*.5)*ib<0.0):0){g[nb>>2]=-gb;g[_a>>2]=-hb;g[$a>>2]=-ib};c[fb>>2]=c[nb>>2];c[fb+4>>2]=c[nb+4>>2];c[fb+8>>2]=c[nb+8>>2];c[fb+12>>2]=c[nb+12>>2];g[Ya>>2]=h;pb=c[(c[e>>2]|0)+16>>2]|0;ib=bb+ +g[ob+4>>2];rb=cb+ +g[ob+8>>2];g[Xa>>2]=ab+ +g[ob>>2];g[Xa+4>>2]=ib;g[Xa+8>>2]=rb;g[Xa+12>>2]=0.0;sg[pb&31](e,nb,Xa,h);i=qb;return}function G1(a){a=a|0;$5(a);return}function H1(b,d,e,f,h,j,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0.0,x=0,y=0,z=0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0;aa=i;i=i+4272|0;X=aa+3272|0;Y=aa+2280|0;C=aa+1288|0;D=aa+296|0;z=aa+280|0;B=aa+48|0;Z=aa+200|0;_=aa+64|0;$=aa;if(((c[e+4>>2]|0)+-17|0)>>>0<2)E=((c[f+4>>2]|0)+-17|0)>>>0<2;else E=0;U=h+16|0;L=h+32|0;V=h+4|0;W=h+20|0;G=h+36|0;N=h+8|0;O=h+24|0;H=h+40|0;P=j+16|0;I=j+32|0;Q=j+4|0;R=j+20|0;J=j+36|0;S=j+8|0;T=j+24|0;K=j+40|0;b=0;do{I1()|0;p=+g[24940+(b<<4)>>2];q=+g[24940+(b<<4)+4>>2];r=+g[24940+(b<<4)+8>>2];da=-p;ca=-q;ba=-r;w=+g[V>>2]*da+ +g[W>>2]*ca+ +g[G>>2]*ba;s=+g[N>>2]*da+ +g[O>>2]*ca+ +g[H>>2]*ba;g[C+(b<<4)>>2]=+g[h>>2]*da+ +g[U>>2]*ca+ +g[L>>2]*ba;g[C+(b<<4)+4>>2]=w;g[C+(b<<4)+8>>2]=s;g[C+(b<<4)+12>>2]=0.0;s=p*+g[Q>>2]+q*+g[R>>2]+r*+g[J>>2];w=p*+g[S>>2]+q*+g[T>>2]+r*+g[K>>2];g[D+(b<<4)>>2]=p*+g[j>>2]+q*+g[P>>2]+r*+g[I>>2];g[D+(b<<4)+4>>2]=s;g[D+(b<<4)+8>>2]=w;g[D+(b<<4)+12>>2]=0.0;b=b+1|0}while((b|0)!=42);b=rf[c[(c[e>>2]|0)+84>>2]&255](e)|0;if((b|0)>0){t=z+4|0;u=z+8|0;v=z+12|0;x=0;y=42;while(1){tg[c[(c[e>>2]|0)+88>>2]&255](e,x,z);ba=+g[z>>2];q=+g[t>>2];w=+g[u>>2];p=ba*+g[U>>2]+q*+g[W>>2]+w*+g[O>>2];s=ba*+g[L>>2]+q*+g[G>>2]+w*+g[H>>2];g[z>>2]=+g[h>>2]*ba+ +g[V>>2]*q+ +g[N>>2]*w;g[t>>2]=p;g[u>>2]=s;g[v>>2]=0.0;I1()|0;F=24940+(y<<4)|0;c[F>>2]=c[z>>2];c[F+4>>2]=c[z+4>>2];c[F+8>>2]=c[z+8>>2];c[F+12>>2]=c[z+12>>2];s=+g[z>>2];p=-s;w=+g[t>>2];q=-w;ba=+g[u>>2];r=-ba;da=+g[V>>2]*p+ +g[W>>2]*q+ +g[G>>2]*r;ca=+g[N>>2]*p+ +g[O>>2]*q+ +g[H>>2]*r;g[C+(y<<4)>>2]=+g[h>>2]*p+ +g[U>>2]*q+ +g[L>>2]*r;g[C+(y<<4)+4>>2]=da;g[C+(y<<4)+8>>2]=ca;g[C+(y<<4)+12>>2]=0.0;ca=s*+g[Q>>2]+w*+g[R>>2]+ba*+g[J>>2];da=s*+g[S>>2]+w*+g[T>>2]+ba*+g[K>>2];g[D+(y<<4)>>2]=+g[j>>2]*s+ +g[P>>2]*w+ +g[I>>2]*ba;g[D+(y<<4)+4>>2]=ca;g[D+(y<<4)+8>>2]=da;g[D+(y<<4)+12>>2]=0.0;x=x+1|0;if((x|0)==(b|0))break;else y=y+1|0}y=b+42|0}else y=42;b=rf[c[(c[f>>2]|0)+84>>2]&255](f)|0;if((b|0)>0){t=B+4|0;u=B+8|0;v=B+12|0;x=0;z=y;while(1){tg[c[(c[f>>2]|0)+88>>2]&255](f,x,B);ba=+g[B>>2];q=+g[t>>2];w=+g[u>>2];p=ba*+g[P>>2]+q*+g[R>>2]+w*+g[T>>2];s=ba*+g[I>>2]+q*+g[J>>2]+w*+g[K>>2];g[B>>2]=+g[j>>2]*ba+ +g[Q>>2]*q+ +g[S>>2]*w;g[t>>2]=p;g[u>>2]=s;g[v>>2]=0.0;I1()|0;F=24940+(z<<4)|0;c[F>>2]=c[B>>2];c[F+4>>2]=c[B+4>>2];c[F+8>>2]=c[B+8>>2];c[F+12>>2]=c[B+12>>2];s=+g[B>>2];p=-s;w=+g[t>>2];q=-w;ba=+g[u>>2];r=-ba;da=+g[V>>2]*p+ +g[W>>2]*q+ +g[G>>2]*r;ca=+g[N>>2]*p+ +g[O>>2]*q+ +g[H>>2]*r;g[C+(z<<4)>>2]=+g[h>>2]*p+ +g[U>>2]*q+ +g[L>>2]*r;g[C+(z<<4)+4>>2]=da;g[C+(z<<4)+8>>2]=ca;g[C+(z<<4)+12>>2]=0.0;ca=s*+g[Q>>2]+w*+g[R>>2]+ba*+g[J>>2];da=s*+g[S>>2]+w*+g[T>>2]+ba*+g[K>>2];g[D+(z<<4)>>2]=+g[j>>2]*s+ +g[P>>2]*w+ +g[I>>2]*ba;g[D+(z<<4)+4>>2]=ca;g[D+(z<<4)+8>>2]=da;g[D+(z<<4)+12>>2]=0.0;x=x+1|0;if((x|0)==(b|0))break;else z=z+1|0}y=b+y|0}zg[c[(c[e>>2]|0)+76>>2]&127](e,C,X,y);zg[c[(c[f>>2]|0)+76>>2]&127](f,D,Y,y);if((y|0)>0){B=h+48|0;C=h+52|0;x=h+56|0;D=j+48|0;F=j+52|0;z=j+56|0;if(E){t=0;u=0;s=0.0;b=0;p=999999984306749440.0;while(1){I1()|0;q=+g[24940+(b<<4)>>2];r=+g[24940+(b<<4)+4>>2];w=+g[24940+(b<<4)+12>>2];if(q*q+r*r+0.0>.01?(ca=+g[X+(b<<4)>>2],da=+g[X+(b<<4)+4>>2],A=+g[X+(b<<4)+8>>2],ea=+g[Y+(b<<4)>>2],M=+g[Y+(b<<4)+4>>2],ba=+g[Y+(b<<4)+8>>2],A=q*(ea*+g[j>>2]+M*+g[Q>>2]+ba*+g[S>>2]+ +g[D>>2]-(ca*+g[h>>2]+da*+g[V>>2]+A*+g[N>>2]+ +g[B>>2]))+r*(ea*+g[P>>2]+M*+g[R>>2]+ba*+g[T>>2]+ +g[F>>2]-(ca*+g[U>>2]+da*+g[W>>2]+A*+g[O>>2]+ +g[C>>2]))+0.0,A<p):0){t=(g[k>>2]=q,c[k>>2]|0);u=(g[k>>2]=r,c[k>>2]|0);p=A}else w=s;b=b+1|0;if((b|0)==(y|0)){v=0;break}else s=w}}else{t=0;u=0;v=0;A=0.0;b=0;p=999999984306749440.0;while(1){I1()|0;q=+g[24940+(b<<4)>>2];r=+g[24940+(b<<4)+4>>2];s=+g[24940+(b<<4)+8>>2];w=+g[24940+(b<<4)+12>>2];if(q*q+r*r+s*s>.01?(da=+g[X+(b<<4)>>2],ea=+g[X+(b<<4)+4>>2],M=+g[X+(b<<4)+8>>2],fa=+g[Y+(b<<4)>>2],ba=+g[Y+(b<<4)+4>>2],ca=+g[Y+(b<<4)+8>>2],M=q*(fa*+g[j>>2]+ba*+g[Q>>2]+ca*+g[S>>2]+ +g[D>>2]-(da*+g[h>>2]+ea*+g[V>>2]+M*+g[N>>2]+ +g[B>>2]))+r*(fa*+g[P>>2]+ba*+g[R>>2]+ca*+g[T>>2]+ +g[F>>2]-(da*+g[U>>2]+ea*+g[W>>2]+M*+g[O>>2]+ +g[C>>2]))+s*(fa*+g[I>>2]+ba*+g[J>>2]+ca*+g[K>>2]+ +g[z>>2]-(da*+g[L>>2]+ea*+g[G>>2]+M*+g[H>>2]+ +g[x>>2])),M<p):0){t=(g[k>>2]=q,c[k>>2]|0);u=(g[k>>2]=r,c[k>>2]|0);v=(g[k>>2]=s,c[k>>2]|0);p=M}else w=A;b=b+1|0;if((b|0)==(y|0))break;else A=w}}}else{w=0.0;v=0;u=0;t=0;p=999999984306749440.0}+W$(e);q=(c[k>>2]=t,+g[k>>2]);r=(c[k>>2]=u,+g[k>>2]);s=(c[k>>2]=v,+g[k>>2]);+W$(f);if(p<0.0){l=0;i=aa;return l|0}da=+W$(e);p=p+(da+ +W$(f)+.5);C1(Z,e,f,d,0);da=+g[h+48>>2]+q*p;ea=r*p+ +g[h+52>>2];fa=s*p+ +g[h+56>>2];f=h+16|0;d=h+32|0;c[_>>2]=c[h>>2];c[_+4>>2]=c[h+4>>2];c[_+8>>2]=c[h+8>>2];c[_+12>>2]=c[h+12>>2];b=_+16|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];b=_+32|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];g[_+48>>2]=da;g[_+52>>2]=ea;g[_+56>>2]=fa;g[_+60>>2]=0.0;b=_+64|0;c[b>>2]=c[j>>2];c[b+4>>2]=c[j+4>>2];c[b+8>>2]=c[j+8>>2];c[b+12>>2]=c[j+12>>2];b=_+80|0;h=j+16|0;c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];b=_+96|0;h=j+32|0;c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];b=_+112|0;j=j+48|0;c[b>>2]=c[j>>2];c[b+4>>2]=c[j+4>>2];c[b+8>>2]=c[j+8>>2];c[b+12>>2]=c[j+12>>2];g[_+128>>2]=999999984306749440.0;c[$>>2]=25940;b=$+40|0;a[b>>0]=0;g[Z+4>>2]=-q;g[Z+8>>2]=-r;g[Z+12>>2]=-s;g[Z+16>>2]=0.0;E1(Z,_,$,o,0);p=p-+g[$+36>>2];b=a[b>>0]|0;if(b<<24>>24){j=$+20|0;ea=+g[$+24>>2]-r*p;fa=+g[$+28>>2]-s*p;g[m>>2]=+g[j>>2]-q*p;g[m+4>>2]=ea;g[m+8>>2]=fa;g[m+12>>2]=0.0;c[n>>2]=c[j>>2];c[n+4>>2]=c[j+4>>2];c[n+8>>2]=c[j+8>>2];c[n+12>>2]=c[j+12>>2];c[l>>2]=t;c[l+4>>2]=u;c[l+8>>2]=v;g[l+12>>2]=w}l=b<<24>>24!=0;i=aa;return l|0}function I1(){if(a[3256]|0)return 24940;if(!(Gb(3256)|0))return 24940;c[6235]=0;c[6236]=-2147483648;c[6237]=-1082130432;g[6238]=0.0;c[6239]=1060716128;c[6240]=-1090087446;c[6241]=-1092290076;g[6242]=0.0;c[6243]=-1098022214;c[6244]=-1084636126;c[6245]=-1092290076;g[6246]=0.0;c[6247]=-1083901670;c[6248]=-2147483648;c[6249]=-1092290177;g[6250]=0.0;c[6251]=-1098022214;c[6252]=1062847522;c[6253]=-1092290043;g[6254]=0.0;c[6255]=1060716128;c[6256]=1057396202;c[6257]=-1092290076;g[6258]=0.0;c[6259]=1049461434;c[6260]=-1084636126;c[6261]=1055193605;g[6262]=0.0;c[6263]=-1086767520;c[6264]=-1090087446;c[6265]=1055193572;g[6266]=0.0;c[6267]=-1086767520;c[6268]=1057396202;c[6269]=1055193572;g[6270]=0.0;c[6271]=1049461434;c[6272]=1062847522;c[6273]=1055193572;g[6274]=0.0;c[6275]=1063581978;c[6276]=0;c[6277]=1055193471;g[6278]=0.0;c[6279]=-2147483648;c[6280]=0;c[6281]=1065353216;g[6282]=0.0;c[6283]=1054458864;c[6284]=-1096927567;c[6285]=-1084636042;g[6286]=0.0;c[6287]=-1104782626;c[6288]=-1090519208;c[6289]=-1084636042;g[6290]=0.0;c[6291]=1049007812;c[6292]=-1085334679;c[6293]=-1090087228;g[6294]=0.0;c[6295]=1054458864;c[6296]=1050556081;c[6297]=-1084636042;g[6298]=0.0;c[6299]=1062847505;c[6300]=-2147483648;c[6301]=-1090087262;g[6302]=0.0;c[6303]=-1090087362;c[6304]=-2147483648;c[6305]=-1084636076;g[6306]=0.0;c[6307]=-1087361736;c[6308]=-1090519141;c[6309]=-1090087262;g[6310]=0.0;c[6311]=-1104782626;c[6312]=1056964440;c[6313]=-1084636042;g[6314]=0.0;c[6315]=-1087361736;c[6316]=1056964507;c[6317]=-1090087262;g[6318]=0.0;c[6319]=1049007812;c[6320]=1062148969;c[6321]=-1090087228;g[6322]=0.0;c[6323]=1064532105;c[6324]=1050556148;c[6325]=0;g[6326]=0.0;c[6327]=1064532105;c[6328]=-1096927500;c[6329]=0;g[6330]=0.0;c[6331]=1058437413;c[6332]=-1085334595;c[6333]=0;g[6334]=0.0;c[6335]=0;c[6336]=-1082130432;c[6337]=0;g[6338]=0.0;c[6339]=-1089046235;c[6340]=-1085334595;c[6341]=0;g[6342]=0.0;c[6343]=-1082951543;c[6344]=-1096927500;c[6345]=-2147483648;g[6346]=0.0;c[6347]=-1082951543;c[6348]=1050556148;c[6349]=-2147483648;g[6350]=0.0;c[6351]=-1089046235;c[6352]=1062149053;c[6353]=-2147483648;g[6354]=0.0;c[6355]=-2147483648;c[6356]=1065353216;c[6357]=-2147483648;g[6358]=0.0;c[6359]=1058437413;c[6360]=1062149053;c[6361]=-2147483648;g[6362]=0.0;c[6363]=1060121912;c[6364]=-1090519141;c[6365]=1057396386;g[6366]=0.0;c[6367]=-1098475836;c[6368]=-1085334679;c[6369]=1057396420;g[6370]=0.0;c[6371]=-1084636143;c[6372]=0;c[6373]=1057396386;g[6374]=0.0;c[6375]=-1098475836;c[6376]=1062148969;c[6377]=1057396420;g[6378]=0.0;c[6379]=1060121912;c[6380]=1056964507;c[6381]=1057396386;g[6382]=0.0;c[6383]=1057396286;c[6384]=0;c[6385]=1062847572;g[6386]=0.0;c[6387]=1042701022;c[6388]=-1090519208;c[6389]=1062847606;g[6390]=0.0;c[6391]=-1093024784;c[6392]=-1096927567;c[6393]=1062847606;g[6394]=0.0;c[6395]=-1093024784;c[6396]=1050556081;c[6397]=1062847606;g[6398]=0.0;c[6399]=1042701022;c[6400]=1056964440;c[6401]=1062847606;g[6402]=0.0;Bc(3256);return 24940}function J1(a){a=a|0;$5(a);return}function K1(a){a=a|0;$5(a);return}function L1(a,b,c){a=a|0;b=b|0;c=c|0;return}function M1(a,b,c){a=a|0;b=b|0;c=c|0;return}function N1(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0;h=b+4|0;c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];d=b+20|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];g[b+36>>2]=f;a[b+40>>0]=1;return}function O1(a,b){a=a|0;b=b|0;var d=0;b=b+112|0;a=c[b>>2]|0;if(!a)return;d=c[6491]|0;if(!d)return;rf[d&255](a)|0;c[b>>2]=0;return}function P1(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0;z=+g[d+80>>2];w=+g[b+84>>2];x=w<z;z=x?w:z;w=+g[b+268>>2];e=w<z;z=e?w:z;w=+g[b+452>>2];h=w<z;y=+g[b+636>>2]<(h?w:z);x=y?3:h?2:e?1:(x^1)<<31>>31;e=(x|0)!=0;z=+g[d>>2];do if(!(a[69258]|0)){w=+g[d+4>>2];v=+g[d+8>>2];if(e){i=+g[b+188>>2];P=z-i;j=+g[b+192>>2];C=w-j;l=+g[b+196>>2];Q=v-l;s=+g[b+372>>2];L=z-s;p=+g[b+376>>2];A=w-p;n=+g[b+380>>2];M=v-n;q=+g[b+556>>2];H=z-q;t=+g[b+560>>2];B=w-t;u=+g[b+564>>2];J=v-u;F=s-q;N=p-t;m=n-u;D=i-q;K=j-t;o=l-u;G=i-s;I=j-p;r=l-n;E=C*m-Q*N;m=Q*F-P*m;F=P*N-C*F;C=A*o-M*K;o=M*D-L*o;D=L*K-A*D;A=r*B-I*J;r=G*J-r*H;B=I*H-G*B;m=F*F+(E*E+m*m);o=D*D+(C*C+o*o);r=B*B+(A*A+r*r);o=m>o?m:o;h=(g[k>>2]=o>r?o:r,c[k>>2]|0);if((x|0)==1){m=+g[b+4>>2];o=+g[b+8>>2];r=+g[b+12>>2];f=0;d=14}else d=13}else{s=+g[b+372>>2];p=+g[b+376>>2];n=+g[b+380>>2];q=+g[b+556>>2];t=+g[b+560>>2];u=+g[b+564>>2];h=0;d=13}if((d|0)==13){m=+g[b+4>>2];B=z-m;o=+g[b+8>>2];N=w-o;r=+g[b+12>>2];A=v-r;E=z-s;Q=w-p;D=v-n;I=z-q;P=w-t;G=v-u;K=s-q;C=p-t;l=n-u;M=m-q;F=o-t;j=r-u;J=m-s;H=o-p;i=r-n;L=N*l-A*C;l=A*K-B*l;K=B*C-N*K;N=Q*j-D*F;j=D*M-E*j;M=E*F-Q*M;Q=i*P-H*G;i=J*G-i*I;P=H*I-J*P;l=K*K+(L*L+l*l);j=M*M+(N*N+j*j);i=P*P+(Q*Q+i*i);j=l>j?l:j;f=(g[k>>2]=j>i?j:i,c[k>>2]|0);i=+g[b+188>>2];j=+g[b+192>>2];l=+g[b+196>>2];if((x|0)==2){q=s;e=0}else d=14}if((d|0)==14){S=z-m;K=w-o;T=v-r;B=z-i;M=w-j;A=v-l;F=z-q;L=w-t;D=v-u;H=i-q;R=j-t;N=l-u;J=m-q;C=o-t;P=r-u;G=m-i;E=o-j;Q=r-l;I=K*N-T*R;N=T*H-S*N;H=S*R-K*H;K=M*P-A*C;P=A*J-B*P;J=B*C-M*J;M=Q*L-E*D;Q=G*D-Q*F;L=E*F-G*L;N=H*H+(I*I+N*N);P=J*J+(K*K+P*P);Q=L*L+(M*M+Q*Q);P=N>P?N:P;e=(g[k>>2]=P>Q?P:Q,c[k>>2]|0);if(y){d=0;break}else q=s}B=z-m;N=w-o;A=v-r;E=z-i;Q=w-j;D=v-l;I=z-q;P=w-p;G=v-n;K=i-q;C=j-p;R=l-n;M=m-q;F=o-p;S=r-n;J=m-i;H=o-j;T=r-l;L=N*R-A*C;R=A*K-B*R;K=B*C-N*K;N=Q*S-D*F;S=D*M-E*S;M=E*F-Q*M;Q=T*P-H*G;T=J*G-T*I;P=H*I-J*P;R=K*K+(L*L+R*R);S=M*M+(N*N+S*S);T=P*P+(Q*Q+T*T);S=R>S?R:S;d=(g[k>>2]=S>T?S:T,c[k>>2]|0)}else{if(e){i=+g[b+188>>2];N=z-i;o=+g[d+4>>2];m=+g[b+192>>2];Q=o-m;j=+g[d+8>>2];n=+g[b+196>>2];M=j-n;p=+g[b+556>>2];s=+g[b+372>>2];R=p-s;q=+g[b+560>>2];v=+g[b+376>>2];P=q-v;u=+g[b+564>>2];l=+g[b+380>>2];T=u-l;S=Q*T-M*P;T=M*R-N*T;R=N*P-Q*R;h=(g[k>>2]=R*R+(S*S+T*T),c[k>>2]|0);if((x|0)==1){r=+g[b+12>>2];t=q;w=s;f=0;s=+g[b+4>>2];q=+g[b+8>>2];d=7}else{w=s;t=q;d=6}}else{h=0;o=+g[d+4>>2];j=+g[d+8>>2];w=+g[b+372>>2];p=+g[b+556>>2];v=+g[b+376>>2];t=+g[b+560>>2];l=+g[b+380>>2];u=+g[b+564>>2];d=6}if((d|0)==6){s=+g[b+4>>2];R=z-s;q=+g[b+8>>2];T=o-q;r=+g[b+12>>2];Q=j-r;n=p-w;S=t-v;i=u-l;m=T*i-Q*S;i=Q*n-R*i;n=R*S-T*n;f=(g[k>>2]=n*n+(m*m+i*i),c[k>>2]|0);i=+g[b+188>>2];m=+g[b+192>>2];n=+g[b+196>>2];if((x|0)==2){t=w;p=v;e=0}else d=7}if((d|0)==7){N=z-s;Q=o-q;M=j-r;R=p-i;P=t-m;T=u-n;S=Q*T-M*P;T=M*R-N*T;R=N*P-Q*R;e=(g[k>>2]=R*R+(S*S+T*T),c[k>>2]|0);if(y){d=0;break}else{t=w;p=v}}N=z-s;Q=o-q;M=j-r;R=t-i;P=p-m;T=l-n;S=Q*T-M*P;T=M*R-N*T;R=N*P-Q*R;d=(g[k>>2]=R*R+(S*S+T*T),c[k>>2]|0)}while(0);T=+O(+(c[k>>2]=h,+g[k>>2]));Q=+O(+(c[k>>2]=f,+g[k>>2]));S=+O(+(c[k>>2]=e,+g[k>>2]));R=+O(+(c[k>>2]=d,+g[k>>2]));y=T>-999999984306749440.0;T=y?T:-999999984306749440.0;b=Q>T;T=b?Q:T;x=S>T;return (R>(x?S:T)?3:x?2:b?1:(y^1)<<31>>31)|0}function Q1(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0;d=+g[a+752>>2];j=c[a+748>>2]|0;if((j|0)<=0){a=-1;return a|0}k=+g[b>>2];l=+g[b+4>>2];h=+g[b+8>>2];i=0;b=-1;f=d*d;while(1){n=+g[a+4+(i*184|0)>>2]-k;m=+g[a+4+(i*184|0)+4>>2]-l;d=+g[a+4+(i*184|0)+8>>2]-h;d=n*n+m*m+d*d;e=d<f;b=e?i:b;i=i+1|0;if((i|0)==(j|0))break;else f=e?d:f}return b|0}function R1(a){a=a|0;return +(+g[a+752>>2])}function S1(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=a+748|0;d=c[e>>2]|0;if((d|0)==4){d=P1(a,b)|0;e=a+4+(d*184|0)+112|0;f=c[e>>2]|0;if((f|0)!=0?(g=c[6491]|0,(g|0)!=0):0){rf[g&255](f)|0;c[e>>2]=0}}else c[e>>2]=d+1;g=(d|0)<0?0:d;K9(a+4+(g*184|0)|0,b|0,184)|0;return g|0}function T1(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0.0,j=0.0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;F=b+748|0;f=c[F>>2]|0;if((f|0)<=0)return;y=d+4|0;z=d+8|0;A=d+16|0;B=d+20|0;C=d+24|0;D=d+32|0;E=d+36|0;h=d+40|0;k=d+48|0;l=d+52|0;m=d+56|0;n=e+4|0;o=e+8|0;p=e+16|0;q=e+20|0;r=e+24|0;s=e+32|0;t=e+36|0;u=e+40|0;v=e+48|0;w=e+52|0;x=e+56|0;do{I=f;f=f+-1|0;O=+g[b+4+(f*184|0)>>2];P=+g[b+4+(f*184|0)+4>>2];i=+g[b+4+(f*184|0)+8>>2];N=O*+g[d>>2]+P*+g[y>>2]+i*+g[z>>2]+ +g[k>>2];L=O*+g[A>>2]+P*+g[B>>2]+i*+g[C>>2]+ +g[l>>2];i=O*+g[D>>2]+P*+g[E>>2]+i*+g[h>>2]+ +g[m>>2];g[b+4+(f*184|0)+48>>2]=N;g[b+4+(f*184|0)+52>>2]=L;g[b+4+(f*184|0)+56>>2]=i;g[b+4+(f*184|0)+60>>2]=0.0;P=+g[b+4+(f*184|0)+16>>2];O=+g[b+4+(f*184|0)+20>>2];j=+g[b+4+(f*184|0)+24>>2];M=P*+g[e>>2]+O*+g[n>>2]+j*+g[o>>2]+ +g[v>>2];K=P*+g[p>>2]+O*+g[q>>2]+j*+g[r>>2]+ +g[w>>2];j=P*+g[s>>2]+O*+g[t>>2]+j*+g[u>>2]+ +g[x>>2];g[b+4+(f*184|0)+32>>2]=M;g[b+4+(f*184|0)+36>>2]=K;g[b+4+(f*184|0)+40>>2]=j;g[b+4+(f*184|0)+44>>2]=0.0;g[b+4+(f*184|0)+80>>2]=(N-M)*+g[b+4+(f*184|0)+64>>2]+(L-K)*+g[b+4+(f*184|0)+68>>2]+(i-j)*+g[b+4+(f*184|0)+72>>2];J=b+4+(f*184|0)+148|0;c[J>>2]=(c[J>>2]|0)+1}while((I|0)>1);f=c[F>>2]|0;if((f|0)<=0)return;n=b+752|0;o=b+740|0;p=b+744|0;do{m=f;f=f+-1|0;l=b+4+(f*184|0)|0;i=+g[b+4+(f*184|0)+80>>2];j=+g[n>>2];do if(!(i<=j)){h=b+4+(f*184|0)+112|0;k=c[h>>2]|0;if((k|0)!=0?(G=c[6491]|0,(G|0)!=0):0){rf[G&255](k)|0;c[h>>2]=0}h=c[F>>2]|0;k=h+-1|0;if((k|0)!=(f|0)){K9(l|0,b+4+(k*184|0)|0,184)|0;c[b+4+(k*184|0)+112>>2]=0;g[b+4+(k*184|0)+120>>2]=0.0;a[b+4+(k*184|0)+116>>0]=0;g[b+4+(k*184|0)+124>>2]=0.0;g[b+4+(k*184|0)+128>>2]=0.0;c[b+4+(k*184|0)+148>>2]=0;h=c[F>>2]|0}c[F>>2]=h+-1}else{N=+g[b+4+(f*184|0)+32>>2]-(+g[b+4+(f*184|0)+48>>2]-+g[b+4+(f*184|0)+64>>2]*i);O=+g[b+4+(f*184|0)+36>>2]-(+g[b+4+(f*184|0)+52>>2]-i*+g[b+4+(f*184|0)+68>>2]);P=+g[b+4+(f*184|0)+40>>2]-(+g[b+4+(f*184|0)+56>>2]-i*+g[b+4+(f*184|0)+72>>2]);if(!(N*N+O*O+P*P>j*j)){h=c[6492]|0;if(!h)break;If[h&127](l,c[o>>2]|0,c[p>>2]|0)|0;break}h=b+4+(f*184|0)+112|0;k=c[h>>2]|0;if((k|0)!=0?(H=c[6491]|0,(H|0)!=0):0){rf[H&255](k)|0;c[h>>2]=0}h=c[F>>2]|0;k=h+-1|0;if((k|0)!=(f|0)){K9(l|0,b+4+(k*184|0)|0,184)|0;c[b+4+(k*184|0)+112>>2]=0;g[b+4+(k*184|0)+120>>2]=0.0;a[b+4+(k*184|0)+116>>0]=0;g[b+4+(k*184|0)+124>>2]=0.0;g[b+4+(k*184|0)+128>>2]=0.0;c[b+4+(k*184|0)+148>>2]=0;h=c[F>>2]|0}c[F>>2]=h+-1}while(0)}while((m|0)>1);return}function U1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;c[a>>2]=25980;f=a+4|0;c[f>>2]=c[b>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];b=a+20|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[a+36>>2]=e;g[a+40>>2]=1.0;return}function V1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;K=i;i=i+32|0;J=K+16|0;I=K;s=+g[b+16>>2];p=+g[b>>2];l=s-p;t=+g[b+20>>2];q=+g[b+4>>2];h=t-q;u=+g[b+24>>2];r=+g[b+8>>2];n=u-r;v=+g[b+32>>2];C=v-p;y=+g[b+36>>2];j=y-q;z=+g[b+40>>2];B=z-r;A=h*B-n*j;B=n*C-l*B;C=l*j-h*C;g[J>>2]=A;b=J+4|0;g[b>>2]=B;F=J+8|0;g[F>>2]=C;g[J+12>>2]=0.0;h=p*A+q*B+r*C;j=+g[a+4>>2];l=+g[a+8>>2];n=+g[a+12>>2];f=A*j+B*l+C*n-h;k=+g[a+20>>2];m=+g[a+24>>2];o=+g[a+28>>2];h=A*k+B*m+C*o-h;if(f*h>=0.0){i=K;return}G=c[a+36>>2]|0;H=f<=0.0;if(H&(G&1|0)!=0){i=K;return}D=f/(f-h);E=a+40|0;if(!(D<+g[E>>2])){i=K;return}w=A*A+B*B+C*C;x=w*-9.999999747378752e-005;f=1.0-D;j=k*D+j*f;h=m*D+l*f;f=o*D+n*f;p=p-j;o=q-h;n=r-f;m=s-j;l=t-h;k=u-f;if(!(C*(p*l-o*m)+(A*(o*k-n*l)+B*(n*m-p*k))>=x)){i=K;return}j=v-j;h=y-h;f=z-f;if(!(C*(m*h-l*j)+(A*(l*f-k*h)+B*(k*j-m*f))>=x)){i=K;return}if(!(C*(o*j-p*h)+(A*(n*h-o*f)+B*(p*f-n*j))>=x)){i=K;return}f=1.0/+P(+w);j=A*f;g[J>>2]=j;h=B*f;g[b>>2]=h;f=C*f;g[F>>2]=f;b=c[(c[a>>2]|0)+12>>2]|0;if(H&(G&2|0)==0){g[I>>2]=-j;g[I+4>>2]=-h;g[I+8>>2]=-f;g[I+12>>2]=0.0;g[E>>2]=+og[b&3](a,I,D,d,e);i=K;return}else{g[E>>2]=+og[b&3](a,J,D,d,e);i=K;return}}function W1(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var i=0,j=0,k=0;c[a>>2]=26004;k=a+8|0;j=a+72|0;i=a+136|0;c[a+4>>2]=b;c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];b=a+24|0;k=d+16|0;c[b>>2]=c[k>>2];c[b+4>>2]=c[k+4>>2];c[b+8>>2]=c[k+8>>2];c[b+12>>2]=c[k+12>>2];b=a+40|0;k=d+32|0;c[b>>2]=c[k>>2];c[b+4>>2]=c[k+4>>2];c[b+8>>2]=c[k+8>>2];c[b+12>>2]=c[k+12>>2];b=a+56|0;d=d+48|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[j>>2]=c[e>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2];c[j+12>>2]=c[e+12>>2];d=a+88|0;b=e+16|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];d=a+104|0;b=e+32|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];d=a+120|0;e=e+48|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];c[i>>2]=c[f>>2];c[i+4>>2]=c[f+4>>2];c[i+8>>2]=c[f+8>>2];c[i+12>>2]=c[f+12>>2];e=a+152|0;d=f+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];e=a+168|0;d=f+32|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];e=a+184|0;f=f+48|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];g[a+200>>2]=1.0;g[a+204>>2]=h;g[a+208>>2]=0.0;return}function X1(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0.0,m=0,n=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;u=i;i=i+672|0;w=u+568|0;y=u+208|0;h=u+24|0;j=u;t=u+32|0;A=d+16|0;z=d+32|0;q0(w);c[w>>2]=26028;B=w+56|0;c[w+4>>2]=1;c[B>>2]=c[d>>2];c[B+4>>2]=c[d+4>>2];c[B+8>>2]=c[d+8>>2];c[B+12>>2]=c[d+12>>2];d=w+72|0;c[d>>2]=c[A>>2];c[d+4>>2]=c[A+4>>2];c[d+8>>2]=c[A+8>>2];c[d+12>>2]=c[A+12>>2];d=w+88|0;c[d>>2]=c[z>>2];c[d+4>>2]=c[z+4>>2];c[d+8>>2]=c[z+8>>2];c[d+12>>2]=c[z+12>>2];c[w+44>>2]=c[b+204>>2];g[y+308>>2]=9.999999747378752e-