/*
 * $Id: Listbox.java,v 1.5 2006/02/27 15:52:04 Yuki Exp $
 */
package hsplet.gui;

import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import hsplet.variable.VolatileValue;
import hsplet.variable.VolatileValueUpdater;

import java.awt.Component;

import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * listbox Rg[B
 * <p>
 * IꂽϐXVB
 * </p>
 * 
 * @author Yuki
 * @version $Revision: 1.5 $, $Date: 2006/02/27 15:52:04 $
 */
public class Listbox extends JScrollPane implements VolatileValueUpdater, HSPControl, ListSelectionListener {

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: Listbox.java,v 1.5 2006/02/27 15:52:04 Yuki Exp $";

	/** 񉻕ɁAf[^̌݊mF邽߂̃o[WԍB */
	private static final long serialVersionUID = 8135061756805120960L;

	/** ϐ */
	private VolatileValue v;

	/** ϐCfbNX */
	private int vi;

	private final JList list;

	/**
	 * IuWFNg\zB
	 * @param v IێϐB
	 * @param vi Iێϐ̃CfbNXB
	 * @param items I̔zB
	 */
	public Listbox(final Variable v, final int vi, final String[] items) {
		super(VERTICAL_SCROLLBAR_AS_NEEDED, HORIZONTAL_SCROLLBAR_NEVER);

		list = new JList(items);

		list.setSelectedIndex(v.toInt(vi));

		this.v = v.makeVolatile();
		this.vi = vi;

		list.addListSelectionListener(this);

		setViewportView(list);
	}

	public void update(final Operand value) {

		value.assign(vi, Scalar.fromValue(list.getSelectedIndex()), 0);
	}

	public Component asComponent() {
		return this;
	}

	public void setValue(Operand v, int vi) {

		switch (v.getType()) {
		case Operand.Type.INTEGER:
			list.setSelectedIndex(v.toInt(vi));
			break;
		default:
			final int selection = list.getSelectedIndex();

			removeAll();

			list.setListData(v.toString(vi).split("\\r?\\n"));

			list.setSelectedIndex(selection < list.getModel().getSize() ? selection : -1);
		}

		this.v.updaters.add(this);
	}

	public void valueChanged(ListSelectionEvent e) {
		this.v.updaters.add(this);

	}
	
	public int sendMessage(int message, Operand wparam, Operand lparam) {
		
		throw new UnsupportedOperationException();
	}
}
