/*
 * Decompiled with CFR 0.152.
 */
package hsplet.function;

import hsplet.Context;
import hsplet.function.FunctionBase;
import hsplet.function.JumpStatement;
import hsplet.variable.ByteString;
import hsplet.variable.Operand;
import hsplet.variable.OperandInputStream;
import hsplet.variable.Scalar;
import hsplet.variable.StringArray;
import hsplet.variable.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class BasicCommand
extends FunctionBase {
    private static final String fileVersionID = "$Id: BasicCommand.java,v 1.8 2006/03/26 14:35:37 Yuki Exp $";

    public static void onexit(Context context, JumpStatement jump, Operand v, int vi) {
        if (v != null && v.getType() == 1) {
            context.onexit.label = FunctionBase.toInt(v, vi, 0);
            context.onexit.jump = jump == null ? JumpStatement.Goto : jump;
            context.onexit.enabled = true;
        } else {
            context.onexit.enabled = FunctionBase.toInt(v, vi, 0) != 0;
        }
    }

    public static void onerror(Context context, JumpStatement jump, Operand v, int vi) {
        if (v != null && v.getType() == 1) {
            context.onerror.label = FunctionBase.toInt(v, vi, 0);
            context.onerror.jump = jump == null ? JumpStatement.Goto : jump;
            context.onerror.enabled = true;
        } else {
            context.onerror.enabled = FunctionBase.toInt(v, vi, 0) != 0;
        }
    }

    public static void onkey(Context context, JumpStatement jump, Operand v, int vi) {
        if (v != null && v.getType() == 1) {
            context.onkey.label = FunctionBase.toInt(v, vi, 0);
            context.onkey.jump = jump == null ? JumpStatement.Goto : jump;
            context.onkey.enabled = true;
        } else {
            context.onkey.enabled = FunctionBase.toInt(v, vi, 0) != 0;
        }
    }

    public static void onclick(Context context, JumpStatement jump, Operand v, int vi) {
        if (v != null && v.getType() == 1) {
            context.onclick.label = FunctionBase.toInt(v, vi, 0);
            context.onclick.jump = jump == null ? JumpStatement.Goto : jump;
            context.onclick.enabled = true;
        } else {
            context.onclick.enabled = FunctionBase.toInt(v, vi, 0) != 0;
        }
    }

    public static void oncmd(Context context, JumpStatement jump, Operand v, int vi, int message) {
        if (v != null && v.getType() == 1) {
            context.oncmd((int)context.targetWindow, (int)message).label = FunctionBase.toInt(v, vi, 0);
            context.oncmd((int)context.targetWindow, (int)message).jump = jump == null ? JumpStatement.Goto : jump;
            context.oncmd((int)context.targetWindow, (int)message).enabled = true;
        } else {
            context.oncmd((int)context.targetWindow, (int)message).enabled = FunctionBase.toInt(v, vi, 0) != 0;
        }
    }

    public static void exist(Context context, String fileName) {
        block13: {
            if (fileName == null) {
                context.error(5, "exist", "fileName");
                return;
            }
            try {
                if (fileName.startsWith("MEM:")) {
                    context.strsize.value = context.memfile.getSize();
                    break block13;
                }
                URL url = context.getResourceURL(fileName);
                URLConnection con = url.openConnection();
                try {
                    InputStream in = con.getInputStream();
                    try {
                        int length;
                        if (in == null) {
                            context.strsize.value = -1;
                            break block13;
                        }
                        if (con.getContentLength() >= 0) {
                            context.strsize.value = con.getContentLength();
                            break block13;
                        }
                        byte[] buf = new byte[1024];
                        context.strsize.value = 0;
                        while ((length = in.read(buf)) >= 0) {
                            context.strsize.value += length;
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    context.strsize.value = -1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                context.strsize.value = -1;
            }
        }
    }

    public static void delete(Context context, String fileName) {
        context.error(21, "delete");
    }

    public static void mkdir(Context context, String fileName) {
        context.error(21, "mkdir");
    }

    public static void chdir(Context context, String dirName) {
        if (dirName == null) {
            context.error(5, "chdir", "dirName");
            return;
        }
        try {
            String rel = dirName.replace('\\', '/');
            context.curdir = new URL(context.curdir, String.valueOf(rel) + (rel.endsWith("/") ? "" : "/"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void dirlist(Context context, Operand v, int vi) {
        context.stat.value = 0;
        context.error(21, "dirlist");
    }

    public static void bload(Context context, String fileName, Operand v, int vi, Operand sizev, int sizevi, int offset) {
        if (fileName == null) {
            context.error(5, "bload", "fileName");
            return;
        }
        if (v == null) {
            context.error(5, "bload", "v");
            return;
        }
        int size = FunctionBase.toInt(sizev, sizevi, -1);
        try {
            InputStream in = context.getResource(fileName);
            if (in == null) {
                context.error(12, "bload", fileName);
                return;
            }
            try {
                byte[] tmp = new byte[256];
                int index = 0;
                while (index < offset) {
                    int l = in.read(tmp, 0, Math.min(256, offset - index));
                    if (l < 0) {
                        index = offset;
                        break;
                    }
                    index += l;
                }
                int readedDataSize = 0;
                try {
                    while (size < 0 || index < offset + size) {
                        int l = in.read(tmp, 0, Math.min(256, size < 0 ? 256 : offset + size - index));
                        if (l >= 0) {
                            int i = 0;
                            while (i < l) {
                                v.poke(vi, readedDataSize, tmp[i]);
                                ++readedDataSize;
                                ++i;
                            }
                            index += l;
                            continue;
                        }
                        break;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                context.strsize.value = readedDataSize;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            context.error(12, "bload", fileName);
        }
    }

    public static void bsave(Context context, String fileName, Operand v, int vi, Operand sizev, int sizevi, int offset) {
        context.error(21, "bsave");
    }

    public static void bcopy(Context context, Operand v, int vi) {
        context.error(21, "bcopy");
    }

    public static void memfile(Context context, Operand v, int vi, int base, int size) {
        if (v == null) {
            context.error(5, "memfile", "v");
            return;
        }
        context.memfile = new OperandInputStream(v, vi, base, size);
    }

    public static void poke(Context context, Operand v, int vi, int index, Operand sv, int svi) {
        if (v == null) {
            context.error(5, "poke", "v");
            return;
        }
        if (sv != null && sv.getType() == 2) {
            ByteString s = sv.toByteString(svi);
            int length = s.length();
            int i = 0;
            while (i < length) {
                v.poke(vi, index + i, s.get(i));
                ++i;
            }
            context.strsize.value = length;
        } else {
            v.poke(vi, index, (byte)FunctionBase.toInt(sv, svi, 0));
        }
    }

    public static void wpoke(Context context, Operand v, int vi, int index, int word) {
        if (v == null) {
            context.error(5, "wpoke", "v");
            return;
        }
        v.poke(vi, index, (byte)(word & 0xFF));
        v.poke(vi, index + 1, (byte)(word >> 8 & 0xFF));
    }

    public static void lpoke(Context context, Operand v, int vi, int index, int dword) {
        if (v == null) {
            context.error(5, "lpoke", "v");
            return;
        }
        v.poke(vi, index, (byte)(dword & 0xFF));
        v.poke(vi, index + 1, (byte)(dword >> 8 & 0xFF));
        v.poke(vi, index + 2, (byte)(dword >> 16 & 0xFF));
        v.poke(vi, index + 3, (byte)(dword >> 24 & 0xFF));
    }

    public static void getstr(Context context, Operand v, int vi, ByteString str, int offset, int separator) {
        if (v == null) {
            context.error(5, "getstr", "v");
            return;
        }
        if (str == null) {
            context.error(5, "getstr", "str");
            return;
        }
        int length = 0;
        while (offset + length < str.length()) {
            int ch = str.get(offset + length) & 0xFF;
            if (ch == 0 || ch == 13 || ch == separator) {
                if (ch == 0) {
                    context.strsize.value = length;
                    break;
                }
                if (ch == 13 && (str.get(offset + length + 1) & 0xFF) == 10) {
                    context.strsize.value = length + 2;
                    break;
                }
                context.strsize.value = length + 1;
                break;
            }
            ++length;
        }
        v.assign(vi, Scalar.fromValue(str.substring(offset, length)), 0);
    }

    public static void chdpm(Context context, Operand v, int vi) {
        context.error(21, "chdpm");
    }

    public static void memexpand(Context context, Operand v, int vi) {
        context.error(21, "memexpand");
    }

    public static void memcpy(Context context, Operand dv, int dvi, Operand sv, int svi, int size, int doff, int soff) {
        if (dv == null) {
            context.error(5, "memcpy", "dv");
            return;
        }
        if (sv == null) {
            context.error(5, "memcpy", "sv");
            return;
        }
        if (dv == sv && doff > soff) {
            int i = size - 1;
            while (i >= 0) {
                dv.poke(dvi, doff + i, sv.peek(svi, soff + i));
                --i;
            }
        } else {
            int i = 0;
            while (i < size) {
                dv.poke(dvi, doff + i, sv.peek(svi, soff + i));
                ++i;
            }
        }
    }

    public static void memset(Context context, Operand v, int vi, int s, int size, int offset) {
        if (v == null) {
            context.error(5, "memset", "v");
            return;
        }
        if (offset < 0) {
            context.error(3, "memset", "offset==" + offset);
            return;
        }
        int i = 0;
        while (i < size) {
            v.poke(vi, offset + i, (byte)s);
            ++i;
        }
    }

    public static void notesel(Context context, Operand v, int vi) {
        if (v == null) {
            context.error(5, "notesel", "v");
            return;
        }
        if (v.getType() != 2) {
            if (v instanceof Variable) {
                ((Variable)v).value = new StringArray();
            } else {
                context.error(6, "notesel", "vartype( v )==" + v.getType());
            }
        }
        if (context.oldNotes.size() > 512) {
            context.oldNotes.remove(0);
        }
        context.oldNotes.add(context.note);
        context.note = v.ref(vi);
    }

    public static void noteadd(Context context, ByteString str, Operand linev, int linei, int overwrite) {
        if (str == null) {
            context.error(5, "noteadd", "str");
            return;
        }
        int line = FunctionBase.toInt(linev, linei, -1);
        ByteString note = context.note.toByteString(0);
        int lineIndex = note.lineIndex(line);
        int lineLength = note.nextLineIndex(lineIndex) - lineIndex;
        if (lineIndex == note.length() && note.length() >= 1 && note.get(note.length() - 1) != 10) {
            note.append(new ByteString("\r\n"));
            lineIndex += 2;
        }
        if (overwrite == 0) {
            lineLength = 0;
        }
        ByteString lineStr = new ByteString(str, true);
        lineStr.append(new ByteString("\r\n"));
        note.replace(lineIndex, lineLength, lineStr);
    }

    public static void notedel(Context context, int line) {
        ByteString note = context.note.toByteString(0);
        int lineIndex = note.lineIndex(line);
        int lineLength = note.nextLineIndex(lineIndex) - lineIndex;
        note.replace(lineIndex, lineLength, new ByteString(""));
    }

    public static void noteload(Context context, String fileName, Operand sizev, int sizevi) {
        if (fileName == null) {
            context.error(5, "noteload", "fileName");
            return;
        }
        int size = FunctionBase.toInt(sizev, sizevi, -1);
        boolean offset = false;
        ByteString note = context.note.toByteString(0);
        note.set(0, (byte)0);
        try {
            InputStream in = context.getResource(fileName);
            if (in == null) {
                context.error(12, "noteload", fileName);
                return;
            }
            try {
                int l;
                byte[] tmp = new byte[256];
                int index = 0;
                while (index < 0) {
                    l = in.read(tmp, 0, Math.min(256, 0 - index));
                    if (l < 0) {
                        index = 0;
                        break;
                    }
                    index += l;
                }
                while (size < 0 || index < 0 + size) {
                    l = in.read(tmp, 0, Math.min(256, size < 0 ? 256 : 0 + size - index));
                    if (l < 0) {
                        break;
                    }
                    note.append(new ByteString(tmp, 0, l, false));
                    index += l;
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.error(12, "noteload", fileName);
        }
    }

    public static void notesave(Context context, Operand v, int vi) {
        context.error(21, "notesave");
    }

    public static void randomize(Context context, Operand v, int vi) {
        context.random.srand(FunctionBase.toInt(v, vi, (int)System.currentTimeMillis()));
    }

    public static void noteunsel(Context context) {
        if (context.oldNotes.size() != 0) {
            context.note = (Operand)context.oldNotes.pop();
        }
    }

    public static void noteget(Context context, Operand v, int vi, int line) {
        int lineLength;
        int lineIndex;
        if (v == null) {
            context.error(5, "noteget", "v");
            return;
        }
        ByteString note = context.note.toByteString(0);
        ByteString string = note.substring(lineIndex = note.lineIndex(line), lineLength = note.nextLineIndex(lineIndex) - lineIndex);
        if (string.length() >= 1 && string.get(string.length() - 1) == 10) {
            string.set(string.length() - 1, (byte)0);
            if (string.length() >= 1 && string.get(string.length() - 1) == 13) {
                string.set(string.length() - 1, (byte)0);
            }
        }
        v.assign(vi, Scalar.fromValue(string), 0);
    }
}

