/**
 * @license
 * Copyright (C) 1997-2014, Onion Software/onitama.
 * Copyright (C) 2014, zakki.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.  Redistributions in binary
 * form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided
 * with the distribution.  Neither the name of the Onion Software nor the names
 * of its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 **/
var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function";var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){return Module["read"](filename,true)};Module["load"]=function load(f){globalEval(read(f))};Module["thisProgram"]=process["argv"][1];Module["arguments"]=process["argv"].slice(2);module["exports"]=Module}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){return read(f,"binary")};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}this["Module"]=Module}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WEB){window["Module"]=Module}else{Module["load"]=importScripts}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]=="undefined"&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),forceAlign:(function(target,quantum){quantum=quantum||4;if(quantum==1)return target;if(isNumber(target)&&isNumber(quantum)){return Math.ceil(target/quantum)*quantum}else if(isNumber(quantum)&&isPowerOfTwo(quantum)){return"((("+target+")+"+(quantum-1)+")&"+ -quantum+")"}return"Math.ceil(("+target+")/"+quantum+")*"+quantum}),isNumberType:(function(type){return type in Runtime.INT_TYPES||type in Runtime.FLOAT_TYPES}),isPointerType:function isPointerType(type){return type[type.length-1]=="*"},isStructType:function isStructType(type){if(isPointerType(type))return false;if(isArrayType(type))return true;if(/<?\{ ?[^}]* ?\}>?/.test(type))return true;return type[0]=="%"},INT_TYPES:{"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},FLOAT_TYPES:{"float":0,"double":0},or64:(function(x,y){var l=x|0|(y|0);var h=(Math.round(x/4294967296)|Math.round(y/4294967296))*4294967296;return l+h}),and64:(function(x,y){var l=(x|0)&(y|0);var h=(Math.round(x/4294967296)&Math.round(y/4294967296))*4294967296;return l+h}),xor64:(function(x,y){var l=(x|0)^(y|0);var h=(Math.round(x/4294967296)^Math.round(y/4294967296))*4294967296;return l+h}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),dedup:function dedup(items,ident){var seen={};if(ident){return items.filter((function(item){if(seen[item[ident]])return false;seen[item[ident]]=true;return true}))}else{return items.filter((function(item){if(seen[item])return false;seen[item]=true;return true}))}},set:function set(){var args=typeof arguments[0]==="object"?arguments[0]:arguments;var ret={};for(var i=0;i<args.length;i++){ret[args[i]]=0}return ret},STACK_ALIGN:8,getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),calculateStructAlignment:function calculateStructAlignment(type){type.flatSize=0;type.alignSize=0;var diffs=[];var prev=-1;var index=0;type.flatIndexes=type.fields.map((function(field){index++;var size,alignSize;if(Runtime.isNumberType(field)||Runtime.isPointerType(field)){size=Runtime.getNativeTypeSize(field);alignSize=Runtime.getAlignSize(field,size)}else if(Runtime.isStructType(field)){if(field[1]==="0"){size=0;if(Types.types[field]){alignSize=Runtime.getAlignSize(null,Types.types[field].alignSize)}else{alignSize=type.alignSize||QUANTUM_SIZE}}else{size=Types.types[field].flatSize;alignSize=Runtime.getAlignSize(null,Types.types[field].alignSize)}}else if(field[0]=="b"){size=field.substr(1)|0;alignSize=1}else if(field[0]==="<"){size=alignSize=Types.types[field].flatSize}else if(field[0]==="i"){size=alignSize=parseInt(field.substr(1))/8;assert(size%1===0,"cannot handle non-byte-size field "+field)}else{assert(false,"invalid type for calculateStructAlignment")}if(type.packed)alignSize=1;type.alignSize=Math.max(type.alignSize,alignSize);var curr=Runtime.alignMemory(type.flatSize,alignSize);type.flatSize=curr+size;if(prev>=0){diffs.push(curr-prev)}prev=curr;return curr}));if(type.name_&&type.name_[0]==="["){type.flatSize=parseInt(type.name_.substr(1))*type.flatSize/2}type.flatSize=Runtime.alignMemory(type.flatSize,type.alignSize);if(diffs.length==0){type.flatFactor=type.flatSize}else if(Runtime.dedup(diffs).length==1){type.flatFactor=diffs[0]}type.needsFlattening=type.flatFactor!=1;return type.flatIndexes},generateStructInfo:(function(struct,typeName,offset){var type,alignment;if(typeName){offset=offset||0;type=(typeof Types==="undefined"?Runtime.typeInfo:Types.types)[typeName];if(!type)return null;if(type.fields.length!=struct.length){printErr("Number of named fields must match the type for "+typeName+": possibly duplicate struct names. Cannot return structInfo");return null}alignment=type.flatIndexes}else{var type={fields:struct.map((function(item){return item[0]}))};alignment=Runtime.calculateStructAlignment(type)}var ret={__size__:type.flatSize};if(typeName){struct.forEach((function(item,i){if(typeof item==="string"){ret[item]=alignment[i]+offset}else{var key;for(var k in item)key=k;ret[key]=Runtime.generateStructInfo(item[key],type.fields[i],alignment[i])}}))}else{struct.forEach((function(item,i){ret[item[1]]=alignment[i]}))}return ret}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),getAsmConst:(function(code,numArgs){if(!Runtime.asmConstCache)Runtime.asmConstCache={};var func=Runtime.asmConstCache[code];if(func)return func;var args=[];for(var i=0;i<numArgs;i++){args.push(String.fromCharCode(36)+i)}var source=Pointer_stringify(code);if(source[0]==='"'){if(source.indexOf('"',1)===source.length-1){source=source.substr(1,source.length-2)}else{abort("invalid EM_ASM input |"+source+"|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)")}}try{var evalled=eval("(function("+args.join(",")+"){ "+source+" })")}catch(e){Module.printErr("error in executing inline EM_ASM code: "+e+" on: \n\n"+source+"\n\nwith args |"+args+"| (make sure to use the right one out of EM_ASM, EM_ASM_ARGS, etc.)");throw e}return Runtime.asmConstCache[code]=evalled}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[func]){Runtime.funcWrappers[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return Runtime.funcWrappers[func]}),UTF8Processor:(function(){var buffer=[];var needed=0;this.processCChar=(function(code){code=code&255;if(buffer.length==0){if((code&128)==0){return String.fromCharCode(code)}buffer.push(code);if((code&224)==192){needed=1}else if((code&240)==224){needed=2}else{needed=3}return""}if(needed){buffer.push(code);needed--;if(needed>0)return""}var c1=buffer[0];var c2=buffer[1];var c3=buffer[2];var c4=buffer[3];var ret;if(buffer.length==2){ret=String.fromCharCode((c1&31)<<6|c2&63)}else if(buffer.length==3){ret=String.fromCharCode((c1&15)<<12|(c2&63)<<6|c3&63)}else{var codePoint=(c1&7)<<18|(c2&63)<<12|(c3&63)<<6|c4&63;ret=String.fromCharCode(Math.floor((codePoint-65536)/1024)+55296,(codePoint-65536)%1024+56320)}buffer.length=0;return ret});this.processJSString=function processJSString(string){string=unescape(encodeURIComponent(string));var ret=[];for(var i=0;i<string.length;i++){ret.push(string.charCodeAt(i))}return ret}}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+7&-8;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+7&-8;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+7&-8;if(DYNAMICTOP>=TOTAL_MEMORY)enlargeMemory();return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:8))*(quantum?quantum:8);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var stack=0;var JSfuncs={"stackSave":(function(){stack=Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore(stack)}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc(str.length+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args){var func=getCFunc(ident);var cArgs=[];if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0)JSfuncs["stackRestore"]();return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+=JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["cwrap"]=cwrap;Module["ccall"]=ccall;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function Pointer_stringify(ptr,length){var hasUtf=false;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];if(t>=128)hasUtf=true;else if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(!hasUtf){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}var utf8=new Runtime.UTF8Processor;for(i=0;i<length;i++){t=HEAPU8[ptr+i>>0];ret+=utf8.processCChar(t)}return ret}Module["Pointer_stringify"]=Pointer_stringify;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr){for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr+i*2>>1]=codeUnit}HEAP16[outPtr+str.length*2>>1]=0}Module["stringToUTF16"]=stringToUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr){var iChar=0;for(var iCodeUnit=0;iCodeUnit<str.length;++iCodeUnit){var codeUnit=str.charCodeAt(iCodeUnit);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++iCodeUnit);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr+iChar*4>>2]=codeUnit;++iChar}HEAP32[outPtr+iChar*4>>2]=0}Module["stringToUTF32"]=stringToUTF32;function demangle(func){var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}return parse()}catch(e){return func}}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function stackTrace(){var stack=(new Error).stack;return stack?demangleAll(stack):"(no stack trace available)"}var PAGE_SIZE=4096;function alignMemoryPage(x){return x+4095&-4096}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function enlargeMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value "+TOTAL_MEMORY+", (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.")}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;var FAST_MEMORY=Module["FAST_MEMORY"]||2097152;var totalMemory=4096;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){Module.printErr("increasing TOTAL_MEMORY to "+totalMemory+" to be more reasonable");TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeInitialized=false}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=Module.addOnPreRun=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=Module.addOnInit=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=Module.addOnPreMain=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=Module.addOnExit=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=Module.addOnPostRun=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var ret=(new Runtime.UTF8Processor).processJSString(stringy);if(length){ret.length=length}if(!dontAddNull){ret.push(0)}return ret}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer+i>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;i++){HEAP8[buffer+i>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer+str.length>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var __ZTVN10__cxxabiv117__class_type_infoE=29648;var __ZTVN10__cxxabiv120__si_class_type_infoE=29776;STATIC_BASE=8;STATICTOP=STATIC_BASE+Runtime.alignMemory(31467);__ATINIT__.push({func:(function(){__GLOBAL__I_a()})});allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,80,77,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,97,116,97,46,100,112,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,72,83,80,69,82,82,79,82,0,0,0,0,0,0,0,0,116,0,0,40,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,4,0,4,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,32,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,10,0,0,0,0,0,0,37,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,149,207,144,148,150,188,0,0,140,94,0,0,0,0,0,0,40,37,100,44,37,100,44,37,100,44,37,100,41,0,0,0,148,122,151,241,0,0,0,0,131,130,129,91,131,104,0,0,142,103,151,112,131,84,131,67,131,89,0,0,0,0,0,0,131,111,131,98,131,116,131,64,131,84,131,67,131,89,0,0,40,147,224,151,101,37,100,98,121,116,101,115,130,204,136,234,149,148,130,240,149,142,166,130,181,130,196,130,162,130,220,130,183,41,13,10,0,0,0,0,147,224,151,101,58,0,0,0,37,48,52,88,0,0,0,0,32,37,48,50,88,0,0,0,40,148,122,151,241,130,204,136,234,149,148,130,190,130,175,130,240,149,142,166,41,13,10,0,40,37,100,41,61,37,115,13,10,0,0,0,0,0,0,0,76,65,66,69,76,32,36,37,48,56,120,0,0,0,0,0,83,84,82,85,67,84,32,40,69,109,112,116,121,41,0,0,83,84,82,85,67,84,32,73,68,37,100,45,37,100,32,80,84,82,36,37,48,56,120,32,83,73,90,69,37,100,40,37,100,41,0,0,0,0,0,0,67,79,77,80,84,82,32,36,37,48,56,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,6,0,0,16,6,0,0,48,6,0,0,72,6,0,0,104,6,0,0,136,6,0,0,168,6,0,0,200,6,0,0,224,6,0,0,8,7,0,0,56,7,0,0,96,7,0,0,128,7,0,0,168,7,0,0,200,7,0,0,240,7,0,0,16,8,0,0,48,8,0,0,88,8,0,0,128,8,0,0,144,8,0,0,184,8,0,0,224,8,0,0,0,9,0,0,32,9,0,0,64,9,0,0,96,9,0,0,128,9,0,0,160,9,0,0,192,9,0,0,232,9,0,0,24,10,0,0,64,10,0,0,104,10,0,0,136,10,0,0,176,10,0,0,216,10,0,0,248,10,0,0,24,11,0,0,56,11,0,0,104,11,0,0,144,11,0,0,240,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,86,131,88,131,101,131,128,131,71,131,137,129,91,130,170,148,173,144,182,130,181,130,220,130,181,130,189,0,0,0,0,149,182,150,64,130,170,138,212,136,225,130,193,130,196,130,162,130,220,130,183,0,0,0,0,131,112,131,137,131,129,129,91,131,94,130,204,146,108,130,170,136,217,143,237,130,197,130,183,0,0,0,0,0,0,0,0,140,118,142,90,142,174,130,197,131,71,131,137,129,91,130,170,148,173,144,182,130,181,130,220,130,181,130,189,0,0,0,0,131,112,131,137,131,129,129,91,131,94,130,204,143,200,151,170,130,205,130,197,130,171,130,220,130,185,130,241,0,0,0,0,131,112,131,137,131,129,129,91,131,94,130,204,140,94,130,170,136,225,130,162,130,220,130,183,0,0,0,0,0,0,0,0,148,122,151,241,130,204,151,118,145,102,130,170,150,179,140,248,130,197,130,183,0,0,0,0,151,76,140,248,130,200,131,137,131,120,131,139,130,170,142,119,146,232,130,179,130,234,130,196,130,162,130,220,130,185,130,241,0,0,0,0,0,0,0,0,131,84,131,117,131,139,129,91,131,96,131,147,130,226,131,139,129,91,131,118,130,204,131,108,131,88,131,103,130,170,144,91,130,183,130,172,130,220,130,183,0,0,0,0,0,0,0,0,131,84,131,117,131,139,129,91,131,96,131,147,138,79,130,204,114,101,116,117,114,110,130,205,150,179,140,248,130,197,130,183,0,0,0,0,0,0,0,0,114,101,112,101,97,116,138,79,130,197,130,204,108,111,111,112,130,205,150,179,140,248,130,197,130,183,0,0,0,0,0,0,131,116,131,64,131,67,131,139,130,170,140,169,130,194,130,169,130,231,130,200,130,162,130,169,150,179,140,248,130,200,150,188,145,79,130,197,130,183,0,0,137,230,145,156,131,116,131,64,131,67,131,139,130,170,130,160,130,232,130,220,130,185,130,241,0,0,0,0,0,0,0,0,138,79,149,148,131,116,131,64,131,67,131,139,140,196,130,209,143,111,130,181,146,134,130,204,131,71,131,137,129,91,130,197,130,183,0,0,0,0,0,0,140,118,142,90,142,174,130,197,131,74,131,98,131,82,130,204,139,76,143,113,130,170,136,225,130,162,130,220,130,183,0,0,131,112,131,137,131,129,129,91,131,94,130,204,144,148,130,170,145,189,130,183,130,172,130,220,130,183,0,0,0,0,0,0,149,182,142,154,151,241,142,174,130,197,136,181,130,166,130,233,149,182,142,154,144,148,130,240,137,122,130,166,130,220,130,181,130,189,0,0,0,0,0,0,145,227,147,252,130,197,130,171,130,200,130,162,149,207,144,148,150,188,130,240,142,119,146,232,130,181,130,196,130,162,130,220,130,183,0,0,0,0,0,0,48,130,197,143,156,142,90,130,181,130,220,130,181,130,189,0,131,111,131,98,131,116,131,64,131,73,129,91,131,111,129,91,131,116,131,141,129,91,130,170,148,173,144,182,130,181,130,220,130,181,130,189,0,0,0,0,131,84,131,124,129,91,131,103,130,179,130,234,130,200,130,162,139,64,148,130,240,145,73,145,240,130,181,130,220,130,181,130,189,0,0,0,0,0,0,0,140,118,142,90,142,174,130,204,131,74,131,98,131,82,130,170,144,91,130,183,130,172,130,220,130,183,0,0,0,0,0,0,149,207,144,148,150,188,130,170,142,119,146,232,130,179,130,234,130,196,130,162,130,220,130,185,130,241,0,0,0,0,0,0,144,174,144,148,136,200,138,79,130,170,142,119,146,232,130,179,130,234,130,196,130,162,130,220,130,183,0,0,0,0,0,0,148,122,151,241,130,204,151,118,145,102,143,145,142,174,130,170,138,212,136,225,130,193,130,196,130,162,130,220,130,183,0,0,131,129,131,130,131,138,130,204,138,109,149,219,130,170,130,197,130,171,130,220,130,185,130,241,130,197,130,181,130,189,0,0,131,94,131,67,131,118,130,204,143,137,138,250,137,187,130,201,142,184,148,115,130,181,130,220,130,181,130,189,0,0,0,0,138,214,144,148,130,201,136,248,144,148,130,170,144,221,146,232,130,179,130,234,130,196,130,162,130,220,130,185,130,241,0,0,131,88,131,94,131,98,131,78,151,204,136,230,130,204,131,73,129,91,131,111,129,91,131,116,131,141,129,91,130,197,130,183,0,0,0,0,0,0,0,0,150,179,140,248,130,200,150,188,145,79,130,170,131,112,131,137,131,129,129,91,131,94,129,91,130,201,142,119,146,232,130,179,130,234,130,196,130,162,130,220,130,183,0,0,0,0,0,0,136,217,130,200,130,233,140,94,130,240,142,157,130,194,148,122,151,241,149,207,144,148,130,201,145,227,147,252,130,181,130,220,130,181,130,189,0,0,0,0,138,214,144,148,130,204,131,112,131,137,131,129,129,91,131,94,129,91,139,76,143,113,130,170,149,115,144,179,130,197,130,183,0,0,0,0,0,0,0,0,131,73,131,117,131,87,131,70,131,78,131,103,144,148,130,170,145,189,130,183,130,172,130,220,130,183,0,0,0,0,0,0,148,122,151,241,129,69,138,214,144,148,130,198,130,181,130,196,142,103,151,112,130,197,130,171,130,200,130,162,140,94,130,197,130,183,0,0,0,0,0,0,131,130,131,87,131,133,129,91,131,139,149,207,144,148,130,170,142,119,146,232,130,179,130,234,130,196,130,162,130,220,130,185,130,241,0,0,0,0,0,0,131,130,131,87,131,133,129,91,131,139,149,207,144,148,130,204,142,119,146,232,130,170,150,179,140,248,130,197,130,183,0,0,149,207,144,148,140,94,130,204,149,207,138,183,130,201,142,184,148,115,130,181,130,220,130,181,130,189,0,0,0,0,0,0,138,79,149,148,68,76,76,130,204,140,196,130,209,143,111,130,181,130,201,142,184,148,115,130,181,130,220,130,181,130,189,0,138,79,149,148,131,73,131,117,131,87,131,70,131,78,131,103,130,204,140,196,130,209,143,111,130,181,130,201,142,184,148,115,130,181,130,220,130,181,130,189,0,0,0,0,0,0,0,0,138,214,144,148,130,204,150,223,130,232,146,108,130,170,144,221,146,232,130,179,130,234,130,196,130,162,130,220,130,185,130,241,129,66,0,0,0,0,0,0,138,214,144,148,130,240,150,189,151,223,130,198,130,181,130,196,139,76,143,113,130,181,130,196,130,162,130,220,130,183,129,66,10,40,72,83,80,50,130,169,130,231,138,214,144,148,137,187,130,179,130,234,130,189,150,188,145,79,130,240,142,103,151,112,130,181,130,196,130,162,130,233,137,194,148,144,171,130,170,130,160,130,232,130,220,130,183,41,0,0,0,0,0,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,35,43,45,46,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,111,117,98,108,101,0,0,0,0,0,0,0,0,0,0,105,110,116,0,0,0,0,0,0,0,0,0,0,0,0,0,108,97,98,101,108,0,0,0,0,0,0,0,0,0,0,0,115,116,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,0,0,0,0,0,0,37,102,0,0,0,0,0,0,115,116,114,117,99,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,10],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([84,101,120,58,73,68,37,100,32,40,37,100,44,37,100,41,40,37,100,120,37,100,41,0,84,101,120,58,102,97,105,108,101,100,0,0,0,0,0,0,84,101,120,58,73,68,37,100,32,40,37,100,44,37,100,41,32,67,108,101,97,114,0,0,123,32,118,97,114,32,100,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,39,104,115,112,51,100,105,115,104,70,111,110,116,68,105,118,39,41,59,32,105,102,32,40,33,100,41,32,123,32,100,32,61,32,100,111,99,117,109,101,110,116,46,99,114,101,97,116,101,69,108,101,109,101,110,116,40,34,100,105,118,34,41,59,32,100,46,105,100,32,61,32,39,104,115,112,51,100,105,115,104,70,111,110,116,68,105,118,39,59,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,119,105,100,116,104,34,44,32,34,97,117,116,111,34,41,59,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,104,101,105,103,104,116,34,44,32,34,97,117,116,111,34,41,59,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,112,111,115,105,116,105,111,110,34,44,32,34,97,98,115,111,108,117,116,101,34,41,59,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,118,105,115,105,98,105,108,105,116,121,34,44,32,34,104,105,100,100,101,110,34,41,59,32,125,32,100,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,102,111,110,116,34,44,32,36,49,32,43,32,34,112,120,32,39,115,97,110,115,45,115,101,114,105,102,39,34,41,59,32,100,111,99,117,109,101,110,116,46,98,111,100,121,46,97,112,112,101,110,100,67,104,105,108,100,40,100,41,59,32,118,97,114,32,116,32,61,32,100,111,99,117,109,101,110,116,46,99,114,101,97,116,101,84,101,120,116,78,111,100,101,40,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,41,59,32,105,102,32,40,100,46,104,97,115,67,104,105,108,100,78,111,100,101,115,40,41,41,32,100,46,114,101,109,111,118,101,67,104,105,108,100,40,100,46,102,105,114,115,116,67,104,105,108,100,41,59,32,100,46,97,112,112,101,110,100,67,104,105,108,100,40,116,41,59,32,125,0,0,0,0,0,0,0,0,123,32,118,97,114,32,100,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,39,104,115,112,51,100,105,115,104,70,111,110,116,68,105,118,39,41,59,32,114,101,116,117,114,110,32,100,46,99,108,105,101,110,116,87,105,100,116,104,59,32,125,0,0,0,123,32,118,97,114,32,100,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,39,104,115,112,51,100,105,115,104,70,111,110,116,68,105,118,39,41,59,32,114,101,116,117,114,110,32,100,46,99,108,105,101,110,116,72,101,105,103,104,116,59,32,125,0,0,123,32,118,97,114,32,99,97,110,118,97,115,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,39,104,115,112,51,100,105,115,104,70,111,110,116,67,97,110,118,97,115,39,41,59,32,105,102,32,40,99,97,110,118,97,115,41,32,123,32,100,111,99,117,109,101,110,116,46,98,111,100,121,46,114,101,109,111,118,101,67,104,105,108,100,40,99,97,110,118,97,115,41,59,32,125,32,99,97,110,118,97,115,32,61,32,100,111,99,117,109,101,110,116,46,99,114,101,97,116,101,69,108,101,109,101,110,116,40,34,99,97,110,118,97,115,34,41,59,32,99,97,110,118,97,115,46,105,100,32,61,32,39,104,115,112,51,100,105,115,104,70,111,110,116,67,97,110,118,97,115,39,59,32,99,97,110,118,97,115,46,115,116,121,108,101,46,115,101,116,80,114,111,112,101,114,116,121,40,34,118,105,115,105,98,105,108,105,116,121,34,44,32,34,104,105,100,100,101,110,34,41,59,32,99,97,110,118,97,115,46,119,105,100,116,104,32,61,32,36,50,59,32,99,97,110,118,97,115,46,104,101,105,103,104,116,32,61,32,36,51,59,32,100,111,99,117,109,101,110,116,46,98,111,100,121,46,97,112,112,101,110,100,67,104,105,108,100,40,99,97,110,118,97,115,41,59,32,118,97,114,32,99,111,110,116,101,120,116,32,61,32,99,97,110,118,97,115,46,103,101,116,67,111,110,116,101,120,116,40,34,50,100,34,41,59,32,99,111,110,116,101,120,116,46,102,111,110,116,32,61,32,36,49,32,43,32,34,112,120,32,39,115,97,110,115,45,115,101,114,105,102,39,34,59,32,118,97,114,32,109,115,103,32,61,32,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,59,32,99,111,110,116,101,120,116,46,99,108,101,97,114,82,101,99,116,32,40,32,48,32,44,32,48,32,44,32,36,50,32,44,32,36,51,41,59,32,99,111,110,116,101,120,116,46,102,105,108,108,83,116,121,108,101,32,61,32,39,114,103,98,97,40,50,53,53,44,32,50,53,53,44,32,50,53,53,44,32,50,53,53,41,39,59,32,99,111,110,116,101,120,116,46,102,105,108,108,84,101,120,116,40,109,115,103,44,32,48,44,32,36,49,41,59,32,99,111,110,115,111,108,101,46,108,111,103,40,109,115,103,41,59,32,71,76,99,116,120,46,116,101,120,73,109,97,103,101,50,68,40,71,76,99,116,120,46,84,69,88,84,85,82,69,95,50,68,44,32,48,44,32,71,76,99,116,120,46,82,71,66,65,44,32,71,76,99,116,120,46,82,71,66,65,44,32,71,76,99,116,120,46,85,78,83,73,71,78,69,68,95,66,89,84,69,44,32,99,97,110,118,97,115,41,59,32,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,110,105,116,58,72,71,73,79,83,99,114,101,101,110,40,37,100,44,37,100,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,99,97,108,101,40,37,102,44,37,102,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,63,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,83,80,72,69,68,126,126,0,95,49,95,95,95,95,95,95,95,95,95,50,95,95,95,95,95,95,95,95,95,51,95,95,95,95,95,95,0,0,0,72,83,80,95,87,88,0,0,72,83,80,95,87,89,0,0,72,83,80,95,83,88,0,0,72,83,80,95,83,89,0,0,72,83,80,95,65,85,84,79,83,67,65,76,69,0,0,0,83,99,114,101,101,110,32,37,102,32,37,102,10,0,0,0,83,116,97,114,116,117,112,32,102,97,105,108,101,100,46,0,72,83,80,68,105,115,104,32,118,101,114,51,46,52,0,0,35,69,114,114,111,114,32,37,100,10,45,45,62,37,115,10,0,0,0,0,0,0,0,0,35,69,114,114,111,114,32,37,100,32,105,110,32,108,105,110,101,32,37,100,32,40,37,115,41,10,45,45,62,37,115,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,109,115,99,114,105,112,116,101,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,97,109,101,0,0,0,0,101,114,114,111,114,0,0,0,73,78,73,84,32,37,100,120,37,100,32,37,115,10,0,0,85,110,97,98,108,101,32,116,111,32,105,110,105,116,105,97,108,105,122,101,32,83,68,76,58,32,37,115,10,0,0,0,85,110,97,98,108,101,32,116,111,32,115,101,116,32,118,105,100,101,111,32,109,111,100,101,58,32,37,115,10,0,0,0,0,0,0,0,0,0,0,0,114,101,116,32,61,61,32,48,0,0,0,0,0,0,0,0,101,109,115,99,114,105,112,116,101,110,47,109,109,109,97,110,46,99,112,112,0,0,0,0,77,77,77,97,110,0,0,0,114,98,0,0,0,0,0,0,91,77,77,77,97,110,93,32,76,111,97,100,101,100,32,37,115,32,111,110,32,98,97,110,107,32,35,37,100,0,0,0,0,0,0,0,0,0,0,0,117,110,107,110,111,119,110,32,105,109,97,103,101,32,116,121,112,101,0,0,0,0,0,0,46,186,232,62,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,63,82,65,68,73,65,78,67,69,0,0,0,0,0,0,70,79,82,77,65,84,61,51,50,45,98,105,116,95,114,108,101,95,114,103,98,101,0,0,45,89,32,0,0,0,0,0,43,88,32,0,0,0,0,0,110,111,116,32,71,73,70,0,0,0,0,0,0,0,0,0,109,117,108,116,105,112,108,101,32,73,72,68,82,0,0,0,98,97,100,32,73,72,68,82,32,108,101,110,0,0,0,0,116,111,111,32,108,97,114,103,101,0,0,0,0,0,0,0,56,98,105,116,32,111,110,108,121,0,0,0,0,0,0,0,98,97,100,32,99,116,121,112,101,0,0,0,0,0,0,0,98,97,100,32,99,111,109,112,32,109,101,116,104,111,100,0,98,97,100,32,102,105,108,116,101,114,32,109,101,116,104,111,100,0,0,0,0,0,0,0,98,97,100,32,105,110,116,101,114,108,97,99,101,32,109,101,116,104,111,100,0,0,0,0,48,45,112,105,120,101,108,32,105,109,97,103,101,0,0,0,102,105,114,115,116,32,110,111,116,32,73,72,68,82,0,0,105,110,118,97,108,105,100,32,80,76,84,69,0,0,0,0,116,82,78,83,32,97,102,116,101,114,32,73,68,65,84,0,116,82,78,83,32,98,101,102,111,114,101,32,80,76,84,69,0,0,0,0,0,0,0,0,98,97,100,32,116,82,78,83,32,108,101,110,0,0,0,0,116,82,78,83,32,119,105,116,104,32,97,108,112,104,97,0,110,111,32,80,76,84,69,0,111,117,116,111,102,109,101,109,0,0,0,0,0,0,0,0,111,117,116,111,102,100,97,116,97,0,0,0,0,0,0,0,110,111,32,73,68,65,84,0,88,88,88,88,32,99,104,117,110,107,32,110,111,116,32,107,110,111,119,110,0,0,0,0,115,45,62,105,109,103,95,111,117,116,95,110,32,61,61,32,52,0,0,0,0,0,0,0,101,109,115,99,114,105,112,116,101,110,47,115,116,98,95,105,109,97,103,101,46,99,0,0,115,116,98,105,95,100,101,95,105,112,104,111,110,101,0,0,111,117,116,95,110,32,61,61,32,50,32,124,124,32,111,117,116,95,110,32,61,61,32,52,0,0,0,0,0,0,0,0,99,111,109,112,117,116,101,95,116,114,97,110,115,112,97,114,101,110,99,121,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,111,117,116,95,110,32,61,61,32,115,45,62,105,109,103,95,110,32,124,124,32,111,117,116,95,110,32,61,61,32,115,45,62,105,109,103,95,110,43,49,0,0,0,0,0,0,0,0,99,114,101,97,116,101,95,112,110,103,95,105,109,97,103,101,95,114,97,119,0,0,0,0,110,111,116,32,101,110,111,117,103,104,32,112,105,120,101,108,115,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,102,105,108,116,101,114,0,0,0,1,0,5,6,0,0,0,105,109,103,95,110,43,49,32,61,61,32,111,117,116,95,110,0,0,0,0,0,0,0,0,137,80,78,71,13,10,26,10,98,97,100,32,112,110,103,32,115,105,103,0,0,0,0,0,110,111,32,83,79,73,0,0,110,111,32,83,79,70,0,0,98,97,100,32,83,79,70,32,108,101,110,0,0,0,0,0,111,110,108,121,32,56,45,98,105,116,0,0,0,0,0,0,110,111,32,104,101,97,100,101,114,32,104,101,105,103,104,116,0,0,0,0,0,0,0,0,48,32,119,105,100,116,104,0,98,97,100,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,0,0,0,0,98,97,100,32,99,111,109,112,111,110,101,110,116,32,73,68,0,0,0,0,0,0,0,0,98,97,100,32,72,0,0,0,98,97,100,32,86,0,0,0,98,97,100,32,84,81,0,0,101,120,112,101,99,116,101,100,32,109,97,114,107,101,114,0,112,114,111,103,114,101,115,115,105,118,101,32,106,112,101,103,0,0,0,0,0,0,0,0,98,97,100,32,68,82,73,32,108,101,110,0,0,0,0,0,98,97,100,32,68,81,84,32,116,121,112,101,0,0,0,0,98,97,100,32,68,81,84,32,116,97,98,108,101,0,0,0,0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,0,98,97,100,32,68,72,84,32,104,101,97,100,101,114,0,0,98,97,100,32,99,111,100,101,32,108,101,110,103,116,104,115,0,0,0,0,0,0,0,0,110,111,116,32,72,68,82,0,117,110,115,117,112,112,111,114,116,101,100,32,102,111,114,109,97,116,0,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,100,97,116,97,32,108,97,121,111,117,116,0,105,110,118,97,108,105,100,32,100,101,99,111,100,101,100,32,115,99,97,110,108,105,110,101,32,108,101,110,103,116,104,0,35,63,82,65,68,73,65,78,67,69,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,97,100,32,104,117,102,102,109,97,110,32,99,111,100,101,0,0,0,0,0,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,13,0,0,0,15,0,0,0,17,0,0,0,19,0,0,0,23,0,0,0,27,0,0,0,31,0,0,0,35,0,0,0,43,0,0,0,51,0,0,0,59,0,0,0,67,0,0,0,83,0,0,0,99,0,0,0,115,0,0,0,131,0,0,0,163,0,0,0,195,0,0,0,227,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,7,0,0,0,9,0,0,0,13,0,0,0,17,0,0,0,25,0,0,0,33,0,0,0,49,0,0,0,65,0,0,0,97,0,0,0,129,0,0,0,193,0,0,0,1,1,0,0,129,1,0,0,1,2,0,0,1,3,0,0,1,4,0,0,1,6,0,0,1,8,0,0,1,12,0,0,1,16,0,0,1,24,0,0,1,32,0,0,1,48,0,0,1,64,0,0,1,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,9,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,11,0,0,0,11,0,0,0,12,0,0,0,12,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,98,97,100,32,100,105,115,116,0,0,0,0,0,0,0,0,111,117,116,112,117,116,32,98,117,102,102,101,114,32,108,105,109,105,116,0,0,0,0,0,122,45,62,115,105,122,101,91,98,93,32,61,61,32,115,0,122,104,117,102,102,109,97,110,95,100,101,99,111,100,101,0,122,45,62,99,111,100,101,95,98,117,102,102,101,114,32,60,32,40,49,85,32,60,60,32,122,45,62,110,117,109,95,98,105,116,115,41,0,0,0,0,102,105,108,108,95,98,105,116,115,0,0,0,0,0,0,0,16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15,0,0,0,0,0,99,32,62,61,32,48,32,38,38,32,99,32,60,32,49,57,0,0,0,0,0,0,0,0,99,111,109,112,117,116,101,95,104,117,102,102,109,97,110,95,99,111,100,101,115,0,0,0,99,32,61,61,32,49,56,0,98,97,100,32,99,111,100,101,108,101,110,103,116,104,115,0,115,105,122,101,115,91,105,93,32,60,61,32,40,49,32,60,60,32,105,41,0,0,0,0,122,98,117,105,108,100,95,104,117,102,102,109,97,110,0,0,97,45,62,110,117,109,95,98,105,116,115,32,61,61,32,48,0,0,0,0,0,0,0,0,112,97,114,115,101,95,117,110,99,111,109,112,114,101,115,115,101,100,95,98,108,111,99,107,0,0,0,0,0,0,0,0,122,108,105,98,32,99,111,114,114,117,112,116,0,0,0,0,114,101,97,100,32,112,97,115,116,32,98,117,102,102,101,114,0,0,0,0,0,0,0,0,98,97,100,32,122,108,105,98,32,104,101,97,100,101,114,0,110,111,32,112,114,101,115,101,116,32,100,105,99,116,0,0,98,97,100,32,99,111,109,112,114,101,115,115,105,111,110,0,98,97,100,32,112,97,108,101,116,116,101,0,0,0,0,0,98,97,100,32,102,105,108,101,0,0,0,0,0,0,0,0,114,101,113,95,99,111,109,112,32,62,61,32,49,32,38,38,32,114,101,113,95,99,111,109,112,32,60,61,32,52,0,0,99,111,110,118,101,114,116,95,102,111,114,109,97,116,0,0,48,0,0,0,0,0,0,0,98,97,100,32,102,111,114,109,97,116,0,0,0,0,0,0,83,128,246,52,0,0,0,0,80,73,67,84,0,0,0,0,110,111,116,32,80,83,68,0,119,114,111,110,103,32,118,101,114,115,105,111,110,0,0,0,119,114,111,110,103,32,99,104,97,110,110,101,108,32,99,111,117,110,116,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,98,105,116,32,100,101,112,116,104,0,0,0,119,114,111,110,103,32,99,111,108,111,114,32,102,111,114,109,97,116,0,0,0,0,0,0,98,97,100,32,73,109,97,103,101,32,68,101,115,99,114,105,112,116,111,114,0,0,0,0,109,105,115,115,105,110,103,32,99,111,108,111,114,32,116,97,98,108,101,0,0,0,0,0,117,110,107,110,111,119,110,32,99,111,100,101,0,0,0,0,110,111,32,99,108,101,97,114,32,99,111,100,101,0,0,0,116,111,111,32,109,97,110,121,32,99,111,100,101,115,0,0,105,108,108,101,103,97,108,32,99,111,100,101,32,105,110,32,114,97,115,116,101,114,0,0,110,111,116,32,66,77,80,0,117,110,107,110,111,119,110,32,66,77,80,0,0,0,0,0,98,97,100,32,66,77,80,0,109,111,110,111,99,104,114,111,109,101,0,0,0,0,0,0,66,77,80,32,82,76,69,0,104,115,122,32,61,61,32,49,48,56,0,0,0,0,0,0,98,109,112,95,108,111,97,100,0,0,0,0,0,0,0,0,105,110,118,97,108,105,100,0,98,97,100,32,98,112,112,0,98,97,100,32,109,97,115,107,115,0,0,0,0,0,0,0,98,97,100,32,114,101,113,95,99,111,109,112,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,15,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,255,0,0,0,255,1,0,0,255,3,0,0,255,7,0,0,255,15,0,0,255,31,0,0,255,63,0,0,255,127,0,0,255,255,0,0,0,0,0,0,40,40,40,106,45,62,99,111,100,101,95,98,117,102,102,101,114,41,32,62,62,32,40,51,50,32,45,32,104,45,62,115,105,122,101,91,99,93,41,41,32,38,32,98,109,97,115,107,91,104,45,62,115,105,122,101,91,99,93,93,41,32,61,61,32,104,45,62,99,111,100,101,91,99,93,0,0,0,0,0,100,101,99,111,100,101,0,0,98,97,100,32,83,79,83,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,98,97,100,32,83,79,83,32,108,101,110,0,0,0,0,0,98,97,100,32,68,67,32,104,117,102,102,0,0,0,0,0,98,97,100,32,65,67,32,104,117,102,102,0,0,0,0,0,98,97,100,32,83,79,83,0,119,98,0,0,0,0,0,0,114,43,98,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,32,99,111,110,115,111,108,101,46,108,111,103,40,80,111,105,110,116,101,114,95,115,116,114,105,110,103,105,102,121,40,36,48,41,41,59,32,125,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,216,115,0,0,72,115,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,88,116,0,0,96,115,0,0,88,115,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,88,116,0,0,152,115,0,0,136,115,0,0,0,0,0,0,0,0,0,0,192,115,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,64,116,0,0,1,0,0,0,5,0,0,0,3,0,0,0,4,0,0,0,2,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,101,110,117,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,88,116,0,0,24,116,0,0,136,115,0,0,0,0,0,0,0,0,0,0,160,116,0,0,1,0,0,0,6,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,88,116,0,0,120,116,0,0,192,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,118,0,0,7,0,0,0,8,0,0,0,1,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,88,116,0,0,208,118,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,1,2,4,7,3,6,5,0,0,0,0,0,0,0,0,105,110,102,105,110,105,116,121,0,0,0,0,0,0,0,0,110,97,110,0,0,0,0,0,95,112,137,0,255,9,47,15,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,45,43,32,32,32,48,88,48,120,0,0,0,0,0,0,0,40,110,117,108,108,41,0,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,0,0,0,0,0,105,110,102,0,0,0,0,0,73,78,70,0,0,0,0,0,110,97,110,0,0,0,0,0,78,65,78,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+23328);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}function _atexit(func,arg){__ATEXIT__.unshift({func:func,arg:arg})}function ___cxa_atexit(){return _atexit.apply(null,arguments)}Module["_rand_r"]=_rand_r;var ___rand_seed=allocate([41108891,0,0,0],"i32",ALLOC_STATIC);Module["_rand"]=_rand;var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};var ___errno_state=0;function ___setErrNo(value){HEAP32[___errno_state>>2]=value;return value}function _strerror_r(errnum,strerrbuf,buflen){if(errnum in ERRNO_MESSAGES){if(ERRNO_MESSAGES[errnum].length>buflen-1){return ___setErrNo(ERRNO_CODES.ERANGE)}else{var msg=ERRNO_MESSAGES[errnum];writeAsciiToMemory(msg,strerrbuf);return 0}}else{return ___setErrNo(ERRNO_CODES.EINVAL)}}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function _strerror(errnum){if(!_strerror.buffer)_strerror.buffer=_malloc(256);_strerror_r(errnum,_strerror.buffer,256);return _strerror.buffer}Module["_i64Subtract"]=_i64Subtract;var GL={counter:1,lastError:0,buffers:[],programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],vaos:[],currArrayBuffer:0,currElementArrayBuffer:0,byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],programInfos:{},stringCache:{},packAlignment:4,unpackAlignment:4,init:(function(){GL.createLog2ceilLookup(GL.MAX_TEMP_BUFFER_SIZE);Browser.moduleContextCreatedCallbacks.push(GL.initExtensions)}),recordError:function recordError(errorCode){if(!GL.lastError){GL.lastError=errorCode}},getNewId:(function(table){var ret=GL.counter++;for(var i=table.length;i<ret;i++){table[i]=null}return ret}),MINI_TEMP_BUFFER_SIZE:16,miniTempBuffer:null,miniTempBufferViews:[0],MAX_TEMP_BUFFER_SIZE:2097152,tempVertexBuffers1:[],tempVertexBufferCounters1:[],tempVertexBuffers2:[],tempVertexBufferCounters2:[],numTempVertexBuffersPerSize:64,tempIndexBuffers:[],tempQuadIndexBuffer:null,log2ceilLookup:null,createLog2ceilLookup:(function(maxValue){GL.log2ceilLookup=new Uint8Array(maxValue+1);var log2=0;var pow2=1;GL.log2ceilLookup[0]=0;for(var i=1;i<=maxValue;++i){if(i>pow2){pow2<<=1;++log2}GL.log2ceilLookup[i]=log2}}),generateTempBuffers:(function(quads){var largestIndex=GL.log2ceilLookup[GL.MAX_TEMP_BUFFER_SIZE];GL.tempVertexBufferCounters1.length=GL.tempVertexBufferCounters2.length=largestIndex+1;GL.tempVertexBuffers1.length=GL.tempVertexBuffers2.length=largestIndex+1;GL.tempIndexBuffers.length=largestIndex+1;for(var i=0;i<=largestIndex;++i){GL.tempIndexBuffers[i]=null;GL.tempVertexBufferCounters1[i]=GL.tempVertexBufferCounters2[i]=0;var ringbufferLength=GL.numTempVertexBuffersPerSize;GL.tempVertexBuffers1[i]=[];GL.tempVertexBuffers2[i]=[];var ringbuffer1=GL.tempVertexBuffers1[i];var ringbuffer2=GL.tempVertexBuffers2[i];ringbuffer1.length=ringbuffer2.length=ringbufferLength;for(var j=0;j<ringbufferLength;++j){ringbuffer1[j]=ringbuffer2[j]=null}}if(quads){GL.tempQuadIndexBuffer=GLctx.createBuffer();GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.tempQuadIndexBuffer);var numIndexes=GL.MAX_TEMP_BUFFER_SIZE>>1;var quadIndexes=new Uint16Array(numIndexes);var i=0,v=0;while(1){quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+1;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v+3;if(i>=numIndexes)break;v+=4}GLctx.bufferData(GLctx.ELEMENT_ARRAY_BUFFER,quadIndexes,GLctx.STATIC_DRAW);GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,null)}}),getTempVertexBuffer:function getTempVertexBuffer(sizeBytes){var idx=GL.log2ceilLookup[sizeBytes];var ringbuffer=GL.tempVertexBuffers1[idx];var nextFreeBufferIndex=GL.tempVertexBufferCounters1[idx];GL.tempVertexBufferCounters1[idx]=GL.tempVertexBufferCounters1[idx]+1&GL.numTempVertexBuffersPerSize-1;var vbo=ringbuffer[nextFreeBufferIndex];if(vbo){return vbo}var prevVBO=GLctx.getParameter(GLctx.ARRAY_BUFFER_BINDING);ringbuffer[nextFreeBufferIndex]=GLctx.createBuffer();GLctx.bindBuffer(GLctx.ARRAY_BUFFER,ringbuffer[nextFreeBufferIndex]);GLctx.bufferData(GLctx.ARRAY_BUFFER,1<<idx,GLctx.DYNAMIC_DRAW);GLctx.bindBuffer(GLctx.ARRAY_BUFFER,prevVBO);return ringbuffer[nextFreeBufferIndex]},getTempIndexBuffer:function getTempIndexBuffer(sizeBytes){var idx=GL.log2ceilLookup[sizeBytes];var ibo=GL.tempIndexBuffers[idx];if(ibo){return ibo}var prevIBO=GLctx.getParameter(GLctx.ELEMENT_ARRAY_BUFFER_BINDING);GL.tempIndexBuffers[idx]=GLctx.createBuffer();GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.tempIndexBuffers[idx]);GLctx.bufferData(GLctx.ELEMENT_ARRAY_BUFFER,1<<idx,GLctx.DYNAMIC_DRAW);GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,prevIBO);return GL.tempIndexBuffers[idx]},newRenderingFrameStarted:function newRenderingFrameStarted(){var vb=GL.tempVertexBuffers1;GL.tempVertexBuffers1=GL.tempVertexBuffers2;GL.tempVertexBuffers2=vb;vb=GL.tempVertexBufferCounters1;GL.tempVertexBufferCounters1=GL.tempVertexBufferCounters2;GL.tempVertexBufferCounters2=vb;var largestIndex=GL.log2ceilLookup[GL.MAX_TEMP_BUFFER_SIZE];for(var i=0;i<=largestIndex;++i){GL.tempVertexBufferCounters1[i]=0}},findToken:(function(source,token){function isIdentChar(ch){if(ch>=48&&ch<=57)return true;if(ch>=65&&ch<=90)return true;if(ch>=97&&ch<=122)return true;return false}var i=-1;do{i=source.indexOf(token,i+1);if(i<0){break}if(i>0&&isIdentChar(source[i-1])){continue}i+=token.length;if(i<source.length-1&&isIdentChar(source[i+1])){continue}return true}while(true);return false}),getSource:(function(shader,count,string,length){var source="";for(var i=0;i<count;++i){var frag;if(length){var len=HEAP32[length+i*4>>2];if(len<0){frag=Pointer_stringify(HEAP32[string+i*4>>2])}else{frag=Pointer_stringify(HEAP32[string+i*4>>2],len)}}else{frag=Pointer_stringify(HEAP32[string+i*4>>2])}source+=frag}type=GLctx.getShaderParameter(GL.shaders[shader],35663);if(type==35632){if(GL.findToken(source,"dFdx")||GL.findToken(source,"dFdy")||GL.findToken(source,"fwidth")){source="#extension GL_OES_standard_derivatives : enable\n"+source;var extension=GLctx.getExtension("OES_standard_derivatives")}}return source}),computeImageSize:(function(width,height,sizePerPixel,alignment){function roundedToNextMultipleOf(x,y){return Math.floor((x+y-1)/y)*y}var plainRowSize=width*sizePerPixel;var alignedRowSize=roundedToNextMultipleOf(plainRowSize,alignment);return height<=0?0:(height-1)*alignedRowSize+plainRowSize}),get:(function(name_,p,type){if(!p){GL.recordError(1281);return}var ret=undefined;switch(name_){case 36346:ret=1;break;case 36344:if(type!=="Integer"){GL.recordError(1280)}return;case 36345:ret=0;break;case 34466:var formats=GLctx.getParameter(34467);ret=formats.length;break;case 35738:ret=5121;break;case 35739:ret=6408;break}if(ret===undefined){var result=GLctx.getParameter(name_);switch(typeof result){case"number":ret=result;break;case"boolean":ret=result?1:0;break;case"string":GL.recordError(1280);return;case"object":if(result===null){switch(name_){case 34964:case 35725:case 34965:case 36006:case 36007:case 32873:case 34068:{ret=0;break};default:{GL.recordError(1280);return}}}else if(result instanceof Float32Array||result instanceof Uint32Array||result instanceof Int32Array||result instanceof Array){for(var i=0;i<result.length;++i){switch(type){case"Integer":HEAP32[p+i*4>>2]=result[i];break;case"Float":HEAPF32[p+i*4>>2]=result[i];break;case"Boolean":HEAP8[p+i>>0]=result[i]?1:0;break;default:throw"internal glGet error, bad type: "+type}}return}else if(result instanceof WebGLBuffer||result instanceof WebGLProgram||result instanceof WebGLFramebuffer||result instanceof WebGLRenderbuffer||result instanceof WebGLTexture){ret=result.name|0}else{GL.recordError(1280);return}break;default:GL.recordError(1280);return}}switch(type){case"Integer":HEAP32[p>>2]=ret;break;case"Float":HEAPF32[p>>2]=ret;break;case"Boolean":HEAP8[p>>0]=ret?1:0;break;default:throw"internal glGet error, bad type: "+type}}),getTexPixelData:(function(type,format,width,height,pixels,internalFormat){var sizePerPixel;switch(type){case 5121:switch(format){case 6406:case 6409:sizePerPixel=1;break;case 6407:sizePerPixel=3;break;case 6408:sizePerPixel=4;break;case 6410:sizePerPixel=2;break;default:GL.recordError(1280);return{pixels:null,internalFormat:0}}break;case 5123:if(format==6402){sizePerPixel=2}else{GL.recordError(1280);return{pixels:null,internalFormat:0}}break;case 5125:if(format==6402){sizePerPixel=4}else{GL.recordError(1280);return{pixels:null,internalFormat:0}}break;case 34042:sizePerPixel=4;break;case 33635:case 32819:case 32820:sizePerPixel=2;break;case 5126:switch(format){case 6407:sizePerPixel=3*4;break;case 6408:sizePerPixel=4*4;break;default:GL.recordError(1280);return{pixels:null,internalFormat:0}}internalFormat=GLctx.RGBA;break;default:GL.recordError(1280);return{pixels:null,internalFormat:0}}var bytes=GL.computeImageSize(width,height,sizePerPixel,GL.unpackAlignment);if(type==5121){pixels=HEAPU8.subarray(pixels,pixels+bytes)}else if(type==5126){pixels=HEAPF32.subarray(pixels>>2,pixels+bytes>>2)}else if(type==5125||type==34042){pixels=HEAPU32.subarray(pixels>>2,pixels+bytes>>2)}else{pixels=HEAPU16.subarray(pixels>>1,pixels+bytes>>1)}return{pixels:pixels,internalFormat:internalFormat}}),initExtensions:(function(){if(GL.initExtensions.done)return;GL.initExtensions.done=true;if(!Module.useWebGL)return;GL.miniTempBuffer=new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);for(var i=0;i<GL.MINI_TEMP_BUFFER_SIZE;i++){GL.miniTempBufferViews[i]=GL.miniTempBuffer.subarray(0,i+1)}GL.maxVertexAttribs=GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);GL.compressionExt=GLctx.getExtension("WEBGL_compressed_texture_s3tc")||GLctx.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||GLctx.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");GL.anisotropicExt=GLctx.getExtension("EXT_texture_filter_anisotropic")||GLctx.getExtension("MOZ_EXT_texture_filter_anisotropic")||GLctx.getExtension("WEBKIT_EXT_texture_filter_anisotropic");GL.floatExt=GLctx.getExtension("OES_texture_float");GL.instancedArraysExt=GLctx.getExtension("ANGLE_instanced_arrays");GL.vaoExt=Module.ctx.getExtension("OES_vertex_array_object");var automaticallyEnabledExtensions=["OES_texture_float","OES_texture_half_float","OES_standard_derivatives","OES_vertex_array_object","WEBGL_compressed_texture_s3tc","WEBGL_depth_texture","OES_element_index_uint","EXT_texture_filter_anisotropic","ANGLE_instanced_arrays","OES_texture_float_linear","OES_texture_half_float_linear","WEBGL_compressed_texture_atc","WEBGL_compressed_texture_pvrtc","EXT_color_buffer_half_float","WEBGL_color_buffer_float","EXT_frag_depth","EXT_sRGB","WEBGL_draw_buffers","WEBGL_shared_resources","EXT_shader_texture_lod"];function shouldEnableAutomatically(extension){for(var i in automaticallyEnabledExtensions){var include=automaticallyEnabledExtensions[i];if(ext.indexOf(include)!=-1){return true}}return false}var extensions=GLctx.getSupportedExtensions();for(var e in extensions){var ext=extensions[e].replace("MOZ_","").replace("WEBKIT_","");if(automaticallyEnabledExtensions.indexOf(ext)!=-1){GLctx.getExtension(ext)}}}),populateUniformTable:(function(program){var p=GL.programs[program];GL.programInfos[program]={uniforms:{},maxUniformLength:0,maxAttributeLength:-1};var ptable=GL.programInfos[program];var utable=ptable.uniforms;var numUniforms=GLctx.getProgramParameter(p,GLctx.ACTIVE_UNIFORMS);for(var i=0;i<numUniforms;++i){var u=GLctx.getActiveUniform(p,i);var name=u.name;ptable.maxUniformLength=Math.max(ptable.maxUniformLength,name.length+1);if(name.indexOf("]",name.length-1)!==-1){var ls=name.lastIndexOf("[");name=name.slice(0,ls)}var loc=GLctx.getUniformLocation(p,name);var id=GL.getNewId(GL.uniforms);utable[name]=[u.size,id];GL.uniforms[id]=loc;for(var j=1;j<u.size;++j){var n=name+"["+j+"]";loc=GLctx.getUniformLocation(p,n);id=GL.getNewId(GL.uniforms);GL.uniforms[id]=loc}}})};function _glClearColor(x0,x1,x2,x3){GLctx.clearColor(x0,x1,x2,x3)}Module["_i64Add"]=_i64Add;function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}function ___cxa_is_number_type(type){var isNumber=false;try{if(type==__ZTIi)isNumber=true}catch(e){}try{if(type==__ZTIj)isNumber=true}catch(e){}try{if(type==__ZTIl)isNumber=true}catch(e){}try{if(type==__ZTIm)isNumber=true}catch(e){}try{if(type==__ZTIx)isNumber=true}catch(e){}try{if(type==__ZTIy)isNumber=true}catch(e){}try{if(type==__ZTIf)isNumber=true}catch(e){}try{if(type==__ZTId)isNumber=true}catch(e){}try{if(type==__ZTIe)isNumber=true}catch(e){}try{if(type==__ZTIc)isNumber=true}catch(e){}try{if(type==__ZTIa)isNumber=true}catch(e){}try{if(type==__ZTIh)isNumber=true}catch(e){}try{if(type==__ZTIs)isNumber=true}catch(e){}try{if(type==__ZTIt)isNumber=true}catch(e){}return isNumber}function ___cxa_does_inherit(definiteType,possibilityType,possibility){if(possibility==0)return false;if(possibilityType==0||possibilityType==definiteType)return true;var possibility_type_info;if(___cxa_is_number_type(possibilityType)){possibility_type_info=possibilityType}else{var possibility_type_infoAddr=HEAP32[possibilityType>>2]-8;possibility_type_info=HEAP32[possibility_type_infoAddr>>2]}switch(possibility_type_info){case 0:var definite_type_infoAddr=HEAP32[definiteType>>2]-8;var definite_type_info=HEAP32[definite_type_infoAddr>>2];if(definite_type_info==0){var defPointerBaseAddr=definiteType+8;var defPointerBaseType=HEAP32[defPointerBaseAddr>>2];var possPointerBaseAddr=possibilityType+8;var possPointerBaseType=HEAP32[possPointerBaseAddr>>2];return ___cxa_does_inherit(defPointerBaseType,possPointerBaseType,possibility)}else return false;case 1:return false;case 2:var parentTypeAddr=possibilityType+8;var parentType=HEAP32[parentTypeAddr>>2];return ___cxa_does_inherit(definiteType,parentType,possibility);default:return false}}var ___cxa_last_thrown_exception=0;function ___resumeException(ptr){if(!___cxa_last_thrown_exception){___cxa_last_thrown_exception=ptr}throw ptr}var ___cxa_exception_header_size=8;function ___cxa_find_matching_catch(thrown,throwntype){if(thrown==-1)thrown=___cxa_last_thrown_exception;header=thrown-___cxa_exception_header_size;if(throwntype==-1)throwntype=HEAP32[header>>2];var typeArray=Array.prototype.slice.call(arguments,2);if(throwntype!=0&&!___cxa_is_number_type(throwntype)){var throwntypeInfoAddr=HEAP32[throwntype>>2]-8;var throwntypeInfo=HEAP32[throwntypeInfoAddr>>2];if(throwntypeInfo==0)thrown=HEAP32[thrown>>2]}for(var i=0;i<typeArray.length;i++){if(___cxa_does_inherit(typeArray[i],throwntype,thrown))return(asm["setTempRet0"](typeArray[i]),thrown)|0}return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){if(!___cxa_throw.initialized){try{HEAP32[__ZTVN10__cxxabiv119__pointer_type_infoE>>2]=0}catch(e){}try{HEAP32[__ZTVN10__cxxabiv117__class_type_infoE>>2]=1}catch(e){}try{HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE>>2]=2}catch(e){}___cxa_throw.initialized=true}var header=ptr-___cxa_exception_header_size;HEAP32[header>>2]=type;HEAP32[header+4>>2]=destructor;___cxa_last_thrown_exception=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr}var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){continue}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){if(stream.tty.output.length){stream.tty.ops.put_char(stream.tty,10)}}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){result=process["stdin"]["read"]();if(!result){if(process["stdin"]["_readableState"]&&process["stdin"]["_readableState"]["ended"]){return null}return undefined}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](tty.output.join(""));tty.output=[]}else{tty.output.push(TTY.utf8.processCChar(val))}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](tty.output.join(""));tty.output=[]}else{tty.output.push(TTY.utf8.processCChar(val))}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(node.contents&&node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.buffer.byteLength:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)));node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}stream.ungotten=[];stream.position=position;return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}})}};var IDBFS={dbs:{},indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}fileStore.createIndex("timestamp","timestamp",{unique:false})});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(){callback(this.error)})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(){callback(this.error)});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(){callback(this.error)})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(){callback(this.error)})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(){callback(this.error)})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var errored=false;var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(){done(this.error)});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{return flags}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{return fs.readlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}stream.position=position;return position})}};var _stdin=allocate(1,"i32*",ALLOC_STATIC);var _stdout=allocate(1,"i32*",ALLOC_STATIC);var _stderr=allocate(1,"i32*",ALLOC_STATIC);function _fflush(stream){}var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var accmode=flag&2097155;var perms=["r","w","rw"][accmode];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){return FS.nodePermissions(dir,"x")}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if((flags&2097155)!==0||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),getStreamFromPtr:(function(ptr){return FS.streams[ptr-1]}),getPtrForStream:(function(stream){return stream?stream.fd+1:0}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}var mounts=FS.getMounts(FS.root.mount);var completed=0;function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=mounts.length){callback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){if(err===ERRNO_CODES.EISDIR)err=ERRNO_CODES.EPERM;throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return link.node_ops.readlink(link)}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0)}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}return stream.stream_ops.llseek(stream,offset,whence)}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret="";var utf8=new Runtime.UTF8Processor;for(var i=0;i<length;i++){ret+=utf8.processCChar(buf[i])}}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var utf8=new Runtime.UTF8Processor;var buf=new Uint8Array(utf8.processJSString(data));FS.write(stream,buf,0,buf.length,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(){return 0})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto").randomBytes(1)[0]})}else{random_device=(function(){return Math.floor(Math.random()*256)})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");HEAP32[_stdin>>2]=FS.getPtrForStream(stdin);assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");HEAP32[_stdout>>2]=FS.getPtrForStream(stdout);assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");HEAP32[_stderr>>2]=FS.getPtrForStream(stderr);assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}this.message=ERRNO_MESSAGES[errno]};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices()}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=Math.floor(idx/this.chunkSize);return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperty(lazyArray,"length",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})});Object.defineProperty(lazyArray,"chunkSize",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperty(node,"usedBytes",{get:(function(){return this.contents.length})});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;function processData(byteArray){function finish(byteArray){if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency("cp "+fullname)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency("cp "+fullname)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency("cp "+fullname);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};function _close(fildes){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{FS.close(stream);return 0}catch(e){FS.handleFSError(e);return-1}}function _fsync(fildes){var stream=FS.getStream(fildes);if(stream){return 0}else{___setErrNo(ERRNO_CODES.EBADF);return-1}}function _fileno(stream){stream=FS.getStreamFromPtr(stream);if(!stream)return-1;return stream.fd}function _fclose(stream){var fd=_fileno(stream);_fsync(fd);return _close(fd)}var Browser={mainLoop:{scheduler:null,method:"",shouldPause:false,paused:false,queue:[],pause:(function(){Browser.mainLoop.shouldPause=true}),resume:(function(){if(Browser.mainLoop.paused){Browser.mainLoop.paused=false;Browser.mainLoop.scheduler()}Browser.mainLoop.shouldPause=false}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx)return Module.ctx;var ctx;var errorInfo="?";function onContextCreationError(event){errorInfo=event.statusMessage||errorInfo}try{if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}canvas.addEventListener("webglcontextcreationerror",onContextCreationError,false);try{["experimental-webgl","webgl"].some((function(webglId){return ctx=canvas.getContext(webglId,contextAttributes)}))}finally{canvas.removeEventListener("webglcontextcreationerror",onContextCreationError,false)}}else{ctx=canvas.getContext("2d")}if(!ctx)throw":("}catch(e){Module.print("Could not create canvas: "+[errorInfo,e]);return null}if(useWebGL){canvas.style.backgroundColor="black"}if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GLctx=ctx;Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);canvasContainer.requestFullScreen()}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(!ABORT)func()}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(!ABORT)func()}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(!ABORT)func()}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=-event.wheelDelta;break;case"wheel":delta=event.deltaY;break;default:throw"unrecognized mouse wheel event: "+event.type}return Math.max(-1,Math.min(1,delta))}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){Browser.lastTouches[touch.identifier]=Browser.touches[touch.identifier];Browser.touches[touch.identifier]={x:adjustedX,y:adjustedY}}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),xhrLoad:(function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)}),asyncLoad:(function(url,onload,onerror,noRunDep){Browser.xhrLoad(url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}})};function _free(){}Module["_free"]=_free;var _environ=allocate(1,"i32*",ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]="root";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/emscripten";ENV["LANG"]="en_US.UTF-8";ENV["_"]="./this.program";poolPtr=allocate(TOTAL_ENV_SIZE,"i8",ALLOC_STATIC);envPtr=allocate(MAX_ENV_VALUES*4,"i8*",ALLOC_STATIC);HEAP32[envPtr>>2]=poolPtr;HEAP32[_environ>>2]=envPtr}else{envPtr=HEAP32[_environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in env){if(typeof env[key]==="string"){var line=key+"="+env[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}var ENV={};function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocate(intArrayFromString(ENV[name]),"i8",ALLOC_NORMAL);return _getenv.ret}function _putenv(string){if(string===0){___setErrNo(ERRNO_CODES.EINVAL);return-1}string=Pointer_stringify(string);var splitPoint=string.indexOf("=");if(string===""||string.indexOf("=")===-1){___setErrNo(ERRNO_CODES.EINVAL);return-1}var name=string.slice(0,splitPoint);var value=string.slice(splitPoint+1);if(!(name in ENV)||ENV[name]!==value){ENV[name]=value;___buildEnvironment(ENV)}return 0}function _SDL_RWFromConstMem(mem,size){var id=SDL.rwops.length;SDL.rwops.push({bytes:mem,count:size});return id}function _TTF_RenderText_Solid(font,text,color){text=Pointer_stringify(text)||" ";var fontData=SDL.fonts[font];var w=SDL.estimateTextWidth(fontData,text);var h=fontData.size;var color=SDL.loadColorToCSSRGB(color);var fontString=h+"px "+fontData.name;var surf=SDL.makeSurface(w,h,0,false,"text:"+text);var surfData=SDL.surfaces[surf];surfData.ctx.save();surfData.ctx.fillStyle=color;surfData.ctx.font=fontString;surfData.ctx.textBaseline="top";surfData.ctx.fillText(text,0,0);surfData.ctx.restore();return surf}function _Mix_HaltMusic(){var audio=SDL.music.audio;if(audio){audio.src=audio.src;audio.currentPosition=0;audio.pause()}SDL.music.audio=null;if(SDL.hookMusicFinished){Runtime.dynCall("v",SDL.hookMusicFinished)}return 0}function _Mix_PlayMusic(id,loops){if(SDL.music.audio){if(!SDL.music.audio.paused)Module.printErr("Music is already playing. "+SDL.music.source);SDL.music.audio.pause()}var info=SDL.audios[id];var audio;if(info.webAudio){audio={};audio.resource=info;audio.paused=false;audio.currentPosition=0;audio.play=(function(){SDL.playWebAudio(this)});audio.pause=(function(){SDL.pauseWebAudio(this)})}else if(info.audio){audio=info.audio}audio["onended"]=(function(){if(SDL.music.audio==this)_Mix_HaltMusic()});audio.loop=loops!=0;audio.volume=SDL.music.volume;SDL.music.audio=audio;audio.play();return 0}function _Mix_FreeChunk(id){SDL.audios[id]=null}function _Mix_LoadWAV_RW(rwopsID,freesrc){var rwops=SDL.rwops[rwopsID];if(rwops===undefined)return 0;var filename="";var audio;var webAudio;var bytes;if(rwops.filename!==undefined){filename=PATH.resolve(rwops.filename);var raw=Module["preloadedAudios"][filename];if(!raw){if(raw===null)Module.printErr("Trying to reuse preloaded audio, but freePreloadedMediaOnUse is set!");if(!Module.noAudioDecoding)Runtime.warnOnce("Cannot find preloaded audio "+filename);try{bytes=FS.readFile(filename)}catch(e){Module.printErr("Couldn't find file for: "+filename);return 0}}if(Module["freePreloadedMediaOnUse"]){Module["preloadedAudios"][filename]=null}audio=raw}else if(rwops.bytes!==undefined){if(SDL.webAudioAvailable())bytes=HEAPU8.buffer.slice(rwops.bytes,rwops.bytes+rwops.count);else bytes=HEAPU8.subarray(rwops.bytes,rwops.bytes+rwops.count)}else{return 0}var arrayBuffer=bytes?bytes.buffer||bytes:bytes;var canPlayWithWebAudio=Module["SDL_canPlayWithWebAudio"]===undefined||Module["SDL_canPlayWithWebAudio"](filename,arrayBuffer);if(bytes!==undefined&&SDL.webAudioAvailable()&&canPlayWithWebAudio){audio=undefined;webAudio={};webAudio.onDecodeComplete=[];function onDecodeComplete(data){webAudio.decodedBuffer=data;webAudio.onDecodeComplete.forEach((function(e){e()}));webAudio.onDecodeComplete=undefined}SDL.audioContext["decodeAudioData"](arrayBuffer,onDecodeComplete)}else if(audio===undefined&&bytes){var blob=new Blob([bytes],{type:rwops.mimetype});var url=URL.createObjectURL(blob);audio=new Audio;audio.src=url;audio.mozAudioChannelType="content"}var id=SDL.audios.length;SDL.audios.push({source:filename,audio:audio,webAudio:webAudio});return id}function _Mix_PlayChannel(channel,id,loops){var info=SDL.audios[id];if(!info)return-1;if(!info.audio&&!info.webAudio)return-1;if(channel==-1){for(var i=SDL.channelMinimumNumber;i<SDL.numChannels;i++){if(!SDL.channels[i].audio){channel=i;break}}if(channel==-1){Module.printErr("All "+SDL.numChannels+" channels in use!");return-1}}var channelInfo=SDL.channels[channel];var audio;if(info.webAudio){audio={};audio.resource=info;audio.paused=false;audio.currentPosition=0;audio.play=(function(){SDL.playWebAudio(this)});audio.pause=(function(){SDL.pauseWebAudio(this)})}else{audio=info.audio.cloneNode(true);audio.numChannels=info.audio.numChannels;audio.frequency=info.audio.frequency}audio["onended"]=function SDL_audio_onended(){if(channelInfo.audio==this){channelInfo.audio.paused=true;channelInfo.audio=null}if(SDL.channelFinished)Runtime.getFuncWrapper(SDL.channelFinished,"vi")(channel)};channelInfo.audio=audio;audio.loop=loops!=0;audio.volume=channelInfo.volume;audio.play();return channel}function _SDL_PauseAudio(pauseOn){if(!SDL.audio){return}if(pauseOn){if(SDL.audio.timer!==undefined){clearTimeout(SDL.audio.timer);SDL.audio.numAudioTimersPending=0;SDL.audio.timer=undefined}if(SDL.audio.scriptProcessorNode!==undefined){SDL.audio.scriptProcessorNode["disconnect"]();SDL.audio.scriptProcessorNode=undefined}}else if(!SDL.audio.timer&&!SDL.audio.scriptProcessorNode){if(SDL.audioContext!==undefined&&SDL.audio.freq==SDL.audioContext["sampleRate"]&&typeof SDL.audioContext["createScriptProcessor"]!=="undefined"){var sizeSamplesPerChannel=SDL.audio.bufferSize/SDL.audio.bytesPerSample/SDL.audio.channels;SDL.audio.scriptProcessorNode=SDL.audioContext["createScriptProcessor"](sizeSamplesPerChannel,0,SDL.audio.channels);SDL.audio.scriptProcessorNode["onaudioprocess"]=(function(e){Runtime.dynCall("viii",SDL.audio.callback,[SDL.audio.userdata,SDL.audio.buffer,SDL.audio.bufferSize]);SDL.fillWebAudioBufferFromHeap(SDL.audio.buffer,sizeSamplesPerChannel,e["outputBuffer"])});SDL.audio.scriptProcessorNode["connect"](SDL.audioContext["destination"])}else{SDL.audio.numAudioTimersPending=1;SDL.audio.timer=Browser.safeSetTimeout(SDL.audio.caller,1);SDL.audio.startTime=Date.now()/1e3}}SDL.audio.paused=pauseOn}function _SDL_CloseAudio(){if(SDL.audio){try{for(var i=0;i<SDL.audio.soundSource.length;++i){if(!typeof (SDL.audio.soundSource[i]==="undefined")){SDL.audio.soundSource[i].stop(0)}}}catch(e){}SDL.audio.soundSource=null;_SDL_PauseAudio(1);_free(SDL.audio.buffer);SDL.audio=null;SDL.allocateChannels(0)}}function _SDL_FreeRW(rwopsID){SDL.rwops[rwopsID]=null;while(SDL.rwops.length>0&&SDL.rwops[SDL.rwops.length-1]===null){SDL.rwops.pop()}}function _IMG_Load_RW(rwopsID,freeSrc){try{function cleanup(){if(rwops&&freeSrc)_SDL_FreeRW(rwopsID)}function addCleanup(func){var old=cleanup;cleanup=function added_cleanup(){old();func()}}function callStbImage(func,params){var x=Module["_malloc"](4);var y=Module["_malloc"](4);var comp=Module["_malloc"](4);addCleanup((function(){Module["_free"](x);Module["_free"](y);Module["_free"](comp);if(data)Module["_stbi_image_free"](data)}));var data=Module["_"+func].apply(null,params.concat([x,y,comp,0]));if(!data)return null;return{rawData:true,data:data,width:HEAP32[x>>2],height:HEAP32[y>>2],size:HEAP32[x>>2]*HEAP32[y>>2]*HEAP32[comp>>2],bpp:HEAP32[comp>>2]}}var rwops=SDL.rwops[rwopsID];if(rwops===undefined){return 0}var filename=rwops.filename;if(filename===undefined){Runtime.warnOnce("Only file names that have been preloaded are supported for IMG_Load_RW. Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js)");return 0}if(!raw){filename=PATH.resolve(filename);var raw=Module["preloadedImages"][filename];if(!raw){if(raw===null)Module.printErr("Trying to reuse preloaded image, but freePreloadedMediaOnUse is set!");Runtime.warnOnce("Cannot find preloaded image "+filename);Runtime.warnOnce("Cannot find preloaded image "+filename+". Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js)");return 0}else if(Module["freePreloadedMediaOnUse"]){Module["preloadedImages"][filename]=null}}var surf=SDL.makeSurface(raw.width,raw.height,0,false,"load:"+filename);var surfData=SDL.surfaces[surf];surfData.ctx.globalCompositeOperation="copy";if(!raw.rawData){surfData.ctx.drawImage(raw,0,0,raw.width,raw.height,0,0,raw.width,raw.height)}else{var imageData=surfData.ctx.getImageData(0,0,surfData.width,surfData.height);if(raw.bpp==4){imageData.data.set(HEAPU8.subarray(raw.data,raw.data+raw.size))}else if(raw.bpp==3){var pixels=raw.size/3;var data=imageData.data;var sourcePtr=raw.data;var destPtr=0;for(var i=0;i<pixels;i++){data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=HEAPU8[sourcePtr++>>0];data[destPtr++]=255}}else if(raw.bpp==1){var pixels=raw.size;var data=imageData.data;var sourcePtr=raw.data;var destPtr=0;for(var i=0;i<pixels;i++){var value=HEAPU8[sourcePtr++>>0];data[destPtr++]=value;data[destPtr++]=value;data[destPtr++]=value;data[destPtr++]=255}}else{Module.printErr("cannot handle bpp "+raw.bpp);return 0}surfData.ctx.putImageData(imageData,0,0)}surfData.ctx.globalCompositeOperation="source-over";_SDL_LockSurface(surf);surfData.locked--;if(SDL.GL){surfData.canvas=surfData.ctx=null}return surf}finally{cleanup()}}function _SDL_RWFromFile(_name,mode){var id=SDL.rwops.length;var name=Pointer_stringify(_name);SDL.rwops.push({filename:name,mimetype:Browser.getMimetype(name)});return id}function _IMG_Load(filename){var rwops=_SDL_RWFromFile(filename);var result=_IMG_Load_RW(rwops,1);return result}function _SDL_LockSurface(surf){var surfData=SDL.surfaces[surf];surfData.locked++;if(surfData.locked>1)return 0;if(!surfData.buffer){surfData.buffer=_malloc(surfData.width*surfData.height*4);HEAP32[surf+20>>2]=surfData.buffer}HEAP32[surf+20>>2]=surfData.buffer;if(surf==SDL.screen&&Module.screenIsReadOnly&&surfData.image)return 0;surfData.image=surfData.ctx.getImageData(0,0,surfData.width,surfData.height);if(surf==SDL.screen){var data=surfData.image.data;var num=data.length;for(var i=0;i<num/4;i++){data[i*4+3]=255}}if(SDL.defaults.copyOnLock){if(surfData.isFlagSet(2097152)){throw"CopyOnLock is not supported for SDL_LockSurface with SDL_HWPALETTE flag set"+(new Error).stack}else{HEAPU8.set(surfData.image.data,surfData.buffer)}}return 0}function _SDL_UpperBlit(src,srcrect,dst,dstrect){var srcData=SDL.surfaces[src];var dstData=SDL.surfaces[dst];var sr,dr;if(srcrect){sr=SDL.loadRect(srcrect)}else{sr={x:0,y:0,w:srcData.width,h:srcData.height}}if(dstrect){dr=SDL.loadRect(dstrect)}else{dr={x:0,y:0,w:-1,h:-1}}var oldAlpha=dstData.ctx.globalAlpha;dstData.ctx.globalAlpha=srcData.alpha/255;dstData.ctx.drawImage(srcData.canvas,sr.x,sr.y,sr.w,sr.h,dr.x,dr.y,sr.w,sr.h);dstData.ctx.globalAlpha=oldAlpha;if(dst!=SDL.screen){Runtime.warnOnce("WARNING: copying canvas data to memory for compatibility");_SDL_LockSurface(dst);dstData.locked--}return 0}function _SDL_GetTicks(){return Math.floor(Date.now()-SDL.startTime)}var SDL={defaults:{width:320,height:200,copyOnLock:true},version:null,surfaces:{},canvasPool:[],events:[],fonts:[null],audios:[null],rwops:[null],music:{audio:null,volume:1},mixerFrequency:22050,mixerFormat:32784,mixerNumChannels:2,mixerChunkSize:1024,channelMinimumNumber:0,GL:false,glAttributes:{0:3,1:3,2:2,3:0,4:0,5:1,6:16,7:0,8:0,9:0,10:0,11:0,12:0,13:0,14:0,15:1,16:0,17:0,18:0},keyboardState:null,keyboardMap:{},canRequestFullscreen:false,isRequestingFullscreen:false,textInput:false,startTime:null,initFlags:0,buttonState:0,modState:0,DOMButtons:[0,0,0],DOMEventToSDLEvent:{},TOUCH_DEFAULT_ID:0,eventHandler:null,eventHandlerContext:null,keyCodes:{16:1249,17:1248,18:1250,20:1081,33:1099,34:1102,35:1101,36:1098,37:1104,38:1106,39:1103,40:1105,44:316,45:1097,46:127,91:1251,93:1125,96:1122,97:1113,98:1114,99:1115,100:1116,101:1117,102:1118,103:1119,104:1120,105:1121,106:1109,107:1111,109:1110,110:1123,111:1108,112:1082,113:1083,114:1084,115:1085,116:1086,117:1087,118:1088,119:1089,120:1090,121:1091,122:1092,123:1093,124:1128,125:1129,126:1130,127:1131,128:1132,129:1133,130:1134,131:1135,132:1136,133:1137,134:1138,135:1139,144:1107,160:94,161:33,162:34,163:35,164:36,165:37,166:38,167:95,168:40,169:41,170:42,171:43,172:124,173:45,174:123,175:125,176:126,181:127,182:129,183:128,188:44,190:46,191:47,192:96,219:91,220:92,221:93,222:39},scanCodes:{8:42,9:43,13:40,27:41,32:44,35:204,39:53,44:54,46:55,47:56,48:39,49:30,50:31,51:32,52:33,53:34,54:35,55:36,56:37,57:38,58:203,59:51,61:46,91:47,92:49,93:48,96:52,97:4,98:5,99:6,100:7,101:8,102:9,103:10,104:11,105:12,106:13,107:14,108:15,109:16,110:17,111:18,112:19,113:20,114:21,115:22,116:23,117:24,118:25,119:26,120:27,121:28,122:29,127:76,305:224,308:226,316:70},loadRect:(function(rect){return{x:HEAP32[rect+0>>2],y:HEAP32[rect+4>>2],w:HEAP32[rect+8>>2],h:HEAP32[rect+12>>2]}}),loadColorToCSSRGB:(function(color){var rgba=HEAP32[color>>2];return"rgb("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+")"}),loadColorToCSSRGBA:(function(color){var rgba=HEAP32[color>>2];return"rgba("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+","+(rgba>>24&255)/255+")"}),translateColorToCSSRGBA:(function(rgba){return"rgba("+(rgba&255)+","+(rgba>>8&255)+","+(rgba>>16&255)+","+(rgba>>>24)/255+")"}),translateRGBAToCSSRGBA:(function(r,g,b,a){return"rgba("+(r&255)+","+(g&255)+","+(b&255)+","+(a&255)/255+")"}),translateRGBAToColor:(function(r,g,b,a){return r|g<<8|b<<16|a<<24}),makeSurface:(function(width,height,flags,usePageCanvas,source,rmask,gmask,bmask,amask){flags=flags||0;var is_SDL_HWSURFACE=flags&1;var is_SDL_HWPALETTE=flags&2097152;var is_SDL_OPENGL=flags&67108864;var surf=_malloc(60);var pixelFormat=_malloc(44);var bpp=is_SDL_HWPALETTE?1:4;var buffer=0;if(!is_SDL_HWSURFACE&&!is_SDL_OPENGL){buffer=_malloc(width*height*4)}HEAP32[surf>>2]=flags;HEAP32[surf+4>>2]=pixelFormat;HEAP32[surf+8>>2]=width;HEAP32[surf+12>>2]=height;HEAP32[surf+16>>2]=width*bpp;HEAP32[surf+20>>2]=buffer;HEAP32[surf+36>>2]=0;HEAP32[surf+40>>2]=0;HEAP32[surf+44>>2]=Module["canvas"].width;HEAP32[surf+48>>2]=Module["canvas"].height;HEAP32[surf+56>>2]=1;HEAP32[pixelFormat>>2]=0;HEAP32[pixelFormat+4>>2]=0;HEAP8[pixelFormat+8>>0]=bpp*8;HEAP8[pixelFormat+9>>0]=bpp;HEAP32[pixelFormat+12>>2]=rmask||255;HEAP32[pixelFormat+16>>2]=gmask||65280;HEAP32[pixelFormat+20>>2]=bmask||16711680;HEAP32[pixelFormat+24>>2]=amask||4278190080;SDL.GL=SDL.GL||is_SDL_OPENGL;var canvas;if(!usePageCanvas){if(SDL.canvasPool.length>0){canvas=SDL.canvasPool.pop()}else{canvas=document.createElement("canvas")}canvas.width=width;canvas.height=height}else{canvas=Module["canvas"]}var webGLContextAttributes={antialias:SDL.glAttributes[13]!=0&&SDL.glAttributes[14]>1,depth:SDL.glAttributes[6]>0,stencil:SDL.glAttributes[7]>0};var ctx=Browser.createContext(canvas,is_SDL_OPENGL,usePageCanvas,webGLContextAttributes);SDL.surfaces[surf]={width:width,height:height,canvas:canvas,ctx:ctx,surf:surf,buffer:buffer,pixelFormat:pixelFormat,alpha:255,flags:flags,locked:0,usePageCanvas:usePageCanvas,source:source,isFlagSet:(function(flag){return flags&flag})};return surf}),copyIndexedColorData:(function(surfData,rX,rY,rW,rH){if(!surfData.colors){return}var fullWidth=Module["canvas"].width;var fullHeight=Module["canvas"].height;var startX=rX||0;var startY=rY||0;var endX=(rW||fullWidth-startX)+startX;var endY=(rH||fullHeight-startY)+startY;var buffer=surfData.buffer;var data=surfData.image.data;var colors=surfData.colors;for(var y=startY;y<endY;++y){var indexBase=y*fullWidth;var colorBase=indexBase*4;for(var x=startX;x<endX;++x){var index=HEAPU8[buffer+indexBase+x>>0]*3;var colorOffset=colorBase+x*4;data[colorOffset]=colors[index];data[colorOffset+1]=colors[index+1];data[colorOffset+2]=colors[index+2]}}}),freeSurface:(function(surf){var refcountPointer=surf+56;var refcount=HEAP32[refcountPointer>>2];if(refcount>1){HEAP32[refcountPointer>>2]=refcount-1;return}var info=SDL.surfaces[surf];if(!info.usePageCanvas&&info.canvas)SDL.canvasPool.push(info.canvas);if(info.buffer)_free(info.buffer);_free(info.pixelFormat);_free(surf);SDL.surfaces[surf]=null;if(surf===SDL.screen){SDL.screen=null}}),downFingers:{},savedKeydown:null,receiveEvent:(function(event){function unpressAllPressedKeys(){for(var code in SDL.keyboardMap){SDL.events.push({type:"keyup",keyCode:SDL.keyboardMap[code]})}}switch(event.type){case"touchstart":case"touchmove":{event.preventDefault();var touches=[];if(event.type==="touchstart"){for(var i=0;i<event.touches.length;i++){var touch=event.touches[i];if(SDL.downFingers[touch.identifier]!=true){SDL.downFingers[touch.identifier]=true;touches.push(touch)}}}else{touches=event.touches}var firstTouch=touches[0];if(event.type=="touchstart"){SDL.DOMButtons[0]=1}var mouseEventType;switch(event.type){case"touchstart":mouseEventType="mousedown";break;case"touchmove":mouseEventType="mousemove";break}var mouseEvent={type:mouseEventType,button:0,pageX:firstTouch.clientX,pageY:firstTouch.clientY};SDL.events.push(mouseEvent);for(var i=0;i<touches.length;i++){var touch=touches[i];SDL.events.push({type:event.type,touch:touch})}break};case"touchend":{event.preventDefault();for(var i=0;i<event.changedTouches.length;i++){var touch=event.changedTouches[i];if(SDL.downFingers[touch.identifier]===true){delete SDL.downFingers[touch.identifier]}}var mouseEvent={type:"mouseup",button:0,pageX:event.changedTouches[0].clientX,pageY:event.changedTouches[0].clientY};SDL.DOMButtons[0]=0;SDL.events.push(mouseEvent);for(var i=0;i<event.changedTouches.length;i++){var touch=event.changedTouches[i];SDL.events.push({type:"touchend",touch:touch})}break};case"mousemove":if(SDL.DOMButtons[0]===1){SDL.events.push({type:"touchmove",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}})}if(Browser.pointerLock){if("mozMovementX"in event){event["movementX"]=event["mozMovementX"];event["movementY"]=event["mozMovementY"]}if(event["movementX"]==0&&event["movementY"]==0){event.preventDefault();return}};case"keydown":case"keyup":case"keypress":case"mousedown":case"mouseup":case"DOMMouseScroll":case"mousewheel":case"wheel":if(event.type!=="keydown"||!SDL.unicode&&!SDL.textInput||event.keyCode===8||event.keyCode===9){event.preventDefault()}if(event.type=="DOMMouseScroll"||event.type=="mousewheel"||event.type=="wheel"){var button=Browser.getMouseWheelDelta(event)>0?4:3;var event1={type:"mousedown",button:button,pageX:event.pageX,pageY:event.pageY};SDL.events.push(event1);var event2={type:"mouseup",button:button,pageX:event.pageX,pageY:event.pageY};SDL.events.push(event2);if(event.type=="DOMMouseScroll"){SDL.events.push({type:"wheel",deltaX:0,deltaY:-event.detail});break}else if(event.type=="mousewheel"){SDL.events.push({type:"wheel",deltaX:0,deltaY:event.wheelDelta});break}}else if(event.type=="mousedown"){SDL.DOMButtons[event.button]=1;SDL.events.push({type:"touchstart",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}})}else if(event.type=="mouseup"){if(!SDL.DOMButtons[event.button]){return}SDL.events.push({type:"touchend",touch:{identifier:0,deviceID:-1,pageX:event.pageX,pageY:event.pageY}});SDL.DOMButtons[event.button]=0}if(event.type==="keydown"||event.type==="mousedown"){SDL.canRequestFullscreen=true}else if(event.type==="keyup"||event.type==="mouseup"){if(SDL.isRequestingFullscreen){Module["requestFullScreen"](true,true);SDL.isRequestingFullscreen=false}SDL.canRequestFullscreen=false}if(event.type==="keypress"&&SDL.savedKeydown){SDL.savedKeydown.keypressCharCode=event.charCode;SDL.savedKeydown=null}else if(event.type==="keydown"){SDL.savedKeydown=event}if(event.type!=="keypress"||SDL.textInput){SDL.events.push(event)}break;case"mouseout":for(var i=0;i<3;i++){if(SDL.DOMButtons[i]){SDL.events.push({type:"mouseup",button:i,pageX:event.pageX,pageY:event.pageY});SDL.DOMButtons[i]=0}}event.preventDefault();break;case"focus":SDL.events.push(event);event.preventDefault();break;case"blur":SDL.events.push(event);unpressAllPressedKeys();event.preventDefault();break;case"visibilitychange":SDL.events.push({type:"visibilitychange",visible:!document.hidden});unpressAllPressedKeys();event.preventDefault();break;case"unload":if(Browser.mainLoop.runner){SDL.events.push(event);Browser.mainLoop.runner()}return;case"resize":SDL.events.push(event);if(event.preventDefault){event.preventDefault()}break}if(SDL.events.length>=1e4){Module.printErr("SDL event queue full, dropping events");SDL.events=SDL.events.slice(0,1e4)}SDL.flushEventsToHandler();return}),handleEvent:(function(event){if(event.handled)return;event.handled=true;switch(event.type){case"touchstart":case"touchend":case"touchmove":{Browser.calculateMouseEvent(event);break};case"keydown":case"keyup":{var down=event.type==="keydown";var code=event.keyCode;if(code>=65&&code<=90){code+=32}else{code=SDL.keyCodes[event.keyCode]||event.keyCode}HEAP8[SDL.keyboardState+code>>0]=down;SDL.modState=(HEAP8[SDL.keyboardState+1248>>0]?64|128:0)|(HEAP8[SDL.keyboardState+1249>>0]?1|2:0)|(HEAP8[SDL.keyboardState+1250>>0]?256|512:0);if(down){SDL.keyboardMap[code]=event.keyCode}else{delete SDL.keyboardMap[code]}break};case"mousedown":case"mouseup":if(event.type=="mousedown"){SDL.buttonState|=1<<event.button}else if(event.type=="mouseup"){SDL.buttonState&=~(1<<event.button)};case"mousemove":{Browser.calculateMouseEvent(event);break}}}),flushEventsToHandler:(function(){if(!SDL.eventHandler)return;var sdlEventPtr=allocate(28,"i8",ALLOC_STACK);while(SDL.pollEvent(sdlEventPtr)){Runtime.dynCall("iii",SDL.eventHandler,[SDL.eventHandlerContext,sdlEventPtr])}}),pollEvent:(function(ptr){if(SDL.initFlags&512&&SDL.joystickEventState){SDL.queryJoysticks()}if(ptr){while(SDL.events.length>0){if(SDL.makeCEvent(SDL.events.shift(),ptr)!==false)return 1}return 0}else{return SDL.events.length>0}}),makeCEvent:(function(event,ptr){if(typeof event==="number"){_memcpy(ptr,event,28);return}SDL.handleEvent(event);switch(event.type){case"keydown":case"keyup":{var down=event.type==="keydown";var key=event.keyCode;if(key>=65&&key<=90){key+=32}else{key=SDL.keyCodes[event.keyCode]||event.keyCode}var scan;if(key>=1024){scan=key-1024}else{scan=SDL.scanCodes[key]||key}HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+8>>0]=down?1:0;HEAP8[ptr+9>>0]=0;HEAP32[ptr+12>>2]=scan;HEAP32[ptr+16>>2]=key;HEAP16[ptr+20>>1]=SDL.modState;HEAP32[ptr+24>>2]=event.keypressCharCode||key;break};case"keypress":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];var cStr=intArrayFromString(String.fromCharCode(event.charCode));for(var i=0;i<cStr.length;++i){HEAP8[ptr+(8+i)>>0]=cStr[i]}break};case"mousedown":case"mouseup":case"mousemove":{if(event.type!="mousemove"){var down=event.type==="mousedown";HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP32[ptr+8>>2]=0;HEAP32[ptr+12>>2]=0;HEAP8[ptr+16>>0]=event.button+1;HEAP8[ptr+17>>0]=down?1:0;HEAP32[ptr+20>>2]=Browser.mouseX;HEAP32[ptr+24>>2]=Browser.mouseY}else{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP32[ptr+8>>2]=0;HEAP32[ptr+12>>2]=0;HEAP32[ptr+16>>2]=SDL.buttonState;HEAP32[ptr+20>>2]=Browser.mouseX;HEAP32[ptr+24>>2]=Browser.mouseY;HEAP32[ptr+28>>2]=Browser.mouseMovementX;HEAP32[ptr+32>>2]=Browser.mouseMovementY}break};case"wheel":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+16>>2]=event.deltaX;HEAP32[ptr+20>>2]=event.deltaY;break};case"touchstart":case"touchend":case"touchmove":{var touch=event.touch;if(!Browser.touches[touch.identifier])break;var w=Module["canvas"].width;var h=Module["canvas"].height;var x=Browser.touches[touch.identifier].x/w;var y=Browser.touches[touch.identifier].y/h;var lx=Browser.lastTouches[touch.identifier].x/w;var ly=Browser.lastTouches[touch.identifier].y/h;var dx=x-lx;var dy=y-ly;if(touch["deviceID"]===undefined)touch.deviceID=SDL.TOUCH_DEFAULT_ID;if(dx===0&&dy===0&&event.type==="touchmove")return false;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=_SDL_GetTicks();tempI64=[touch.deviceID>>>0,(tempDouble=touch.deviceID,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr+8>>2]=tempI64[0],HEAP32[ptr+12>>2]=tempI64[1];tempI64=[touch.identifier>>>0,(tempDouble=touch.identifier,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr+16>>2]=tempI64[0],HEAP32[ptr+20>>2]=tempI64[1];HEAPF32[ptr+24>>2]=x;HEAPF32[ptr+28>>2]=y;HEAPF32[ptr+32>>2]=dx;HEAPF32[ptr+36>>2]=dy;if(touch.force!==undefined){HEAPF32[ptr+40>>2]=touch.force}else{HEAPF32[ptr+40>>2]=event.type=="touchend"?0:1}break};case"unload":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];break};case"resize":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=event.w;HEAP32[ptr+8>>2]=event.h;break};case"joystick_button_up":case"joystick_button_down":{var state=event.type==="joystick_button_up"?0:1;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+4>>0]=event.index;HEAP8[ptr+5>>0]=event.button;HEAP8[ptr+6>>0]=state;break};case"joystick_axis_motion":{HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP8[ptr+4>>0]=event.index;HEAP8[ptr+5>>0]=event.axis;HEAP32[ptr+8>>2]=SDL.joystickAxisValueConversion(event.value);break};case"focus":{var SDL_WINDOWEVENT_FOCUS_GAINED=12;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=SDL_WINDOWEVENT_FOCUS_GAINED;break};case"blur":{var SDL_WINDOWEVENT_FOCUS_LOST=13;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=SDL_WINDOWEVENT_FOCUS_LOST;break};case"visibilitychange":{var SDL_WINDOWEVENT_SHOWN=1;var SDL_WINDOWEVENT_HIDDEN=2;var visibilityEventID=event.visible?SDL_WINDOWEVENT_SHOWN:SDL_WINDOWEVENT_HIDDEN;HEAP32[ptr>>2]=SDL.DOMEventToSDLEvent[event.type];HEAP32[ptr+4>>2]=0;HEAP8[ptr+8>>0]=visibilityEventID;break};default:throw"Unhandled SDL event: "+event.type}}),estimateTextWidth:(function(fontData,text){var h=fontData.size;var fontString=h+"px "+fontData.name;var tempCtx=SDL.ttfContext;tempCtx.save();tempCtx.font=fontString;var ret=tempCtx.measureText(text).width|0;tempCtx.restore();return ret}),allocateChannels:(function(num){if(SDL.numChannels&&SDL.numChannels>=num&&num!=0)return;SDL.numChannels=num;SDL.channels=[];for(var i=0;i<num;i++){SDL.channels[i]={audio:null,volume:1}}}),setGetVolume:(function(info,volume){if(!info)return 0;var ret=info.volume*128;if(volume!=-1){info.volume=Math.min(Math.max(volume,0),128)/128;if(info.audio){try{info.audio.volume=info.volume;if(info.audio.webAudioGainNode)info.audio.webAudioGainNode["gain"]["value"]=info.volume}catch(e){Module.printErr("setGetVolume failed to set audio volume: "+e)}}}return ret}),playWebAudio:(function(audio){if(!audio)return;if(audio.webAudioNode)return;if(!SDL.webAudioAvailable())return;try{var webAudio=audio.resource.webAudio;audio.paused=false;if(!webAudio.decodedBuffer){if(webAudio.onDecodeComplete===undefined)abort("Cannot play back audio object that was not loaded");webAudio.onDecodeComplete.push((function(){if(!audio.paused)SDL.playWebAudio(audio)}));return}audio.webAudioNode=SDL.audioContext["createBufferSource"]();audio.webAudioNode["buffer"]=webAudio.decodedBuffer;audio.webAudioNode["loop"]=audio.loop;audio.webAudioNode["onended"]=(function(){audio.onended()});audio.webAudioGainNode=SDL.audioContext["createGain"]();audio.webAudioGainNode["gain"]["value"]=audio.volume;audio.webAudioNode["connect"](audio.webAudioGainNode);audio.webAudioGainNode["connect"](SDL.audioContext["destination"]);audio.webAudioNode["start"](0,audio.currentPosition);audio.startTime=SDL.audioContext["currentTime"]-audio.currentPosition}catch(e){Module.printErr("playWebAudio failed: "+e)}}),pauseWebAudio:(function(audio){if(!audio)return;if(audio.webAudioNode){try{audio.currentPosition=(SDL.audioContext["currentTime"]-audio.startTime)%audio.resource.webAudio.decodedBuffer.duration;audio.webAudioNode["onended"]=undefined;audio.webAudioNode.stop();audio.webAudioNode=undefined}catch(e){Module.printErr("pauseWebAudio failed: "+e)}}audio.paused=true}),openAudioContext:(function(){if(!SDL.audioContext){if(typeof AudioContext!=="undefined")SDL.audioContext=new AudioContext;else if(typeof webkitAudioContext!=="undefined")SDL.audioContext=new webkitAudioContext}}),webAudioAvailable:(function(){return!!SDL.audioContext}),fillWebAudioBufferFromHeap:(function(heapPtr,sizeSamplesPerChannel,dstAudioBuffer){var numChannels=SDL.audio.channels;for(var c=0;c<numChannels;++c){var channelData=dstAudioBuffer["getChannelData"](c);if(channelData.length!=sizeSamplesPerChannel){throw"Web Audio output buffer length mismatch! Destination size: "+channelData.length+" samples vs expected "+sizeSamplesPerChannel+" samples!"}if(SDL.audio.format==32784){for(var j=0;j<sizeSamplesPerChannel;++j){channelData[j]=HEAP16[heapPtr+(j*numChannels+c)*2>>1]/32768}}else if(SDL.audio.format==8){for(var j=0;j<sizeSamplesPerChannel;++j){var v=HEAP8[heapPtr+(j*numChannels+c)>>0];channelData[j]=(v>=0?v-128:v+128)/128}}}}),debugSurface:(function(surfData){console.log("dumping surface "+[surfData.surf,surfData.source,surfData.width,surfData.height]);var image=surfData.ctx.getImageData(0,0,surfData.width,surfData.height);var data=image.data;var num=Math.min(surfData.width,surfData.height);for(var i=0;i<num;i++){console.log("   diagonal "+i+":"+[data[i*surfData.width*4+i*4+0],data[i*surfData.width*4+i*4+1],data[i*surfData.width*4+i*4+2],data[i*surfData.width*4+i*4+3]])}}),joystickEventState:1,lastJoystickState:{},joystickNamePool:{},recordJoystickState:(function(joystick,state){var buttons=new Array(state.buttons.length);for(var i=0;i<state.buttons.length;i++){buttons[i]=SDL.getJoystickButtonState(state.buttons[i])}SDL.lastJoystickState[joystick]={buttons:buttons,axes:state.axes.slice(0),timestamp:state.timestamp,index:state.index,id:state.id}}),getJoystickButtonState:(function(button){if(typeof button==="object"){return button.pressed}else{return button>0}}),queryJoysticks:(function(){for(var joystick in SDL.lastJoystickState){var state=SDL.getGamepad(joystick-1);var prevState=SDL.lastJoystickState[joystick];if(typeof state.timestamp!=="number"||state.timestamp!==prevState.timestamp){var i;for(i=0;i<state.buttons.length;i++){var buttonState=SDL.getJoystickButtonState(state.buttons[i]);if(buttonState!==prevState.buttons[i]){SDL.events.push({type:buttonState?"joystick_button_down":"joystick_button_up",joystick:joystick,index:joystick-1,button:i})}}for(i=0;i<state.axes.length;i++){if(state.axes[i]!==prevState.axes[i]){SDL.events.push({type:"joystick_axis_motion",joystick:joystick,index:joystick-1,axis:i,value:state.axes[i]})}}SDL.recordJoystickState(joystick,state)}}}),joystickAxisValueConversion:(function(value){return Math.ceil((value+1)*32767.5-32768)}),getGamepads:(function(){var fcn=navigator.getGamepads||navigator.webkitGamepads||navigator.mozGamepads||navigator.gamepads||navigator.webkitGetGamepads;if(fcn!==undefined){return fcn.apply(navigator)}else{return[]}}),getGamepad:(function(deviceIndex){var gamepads=SDL.getGamepads();if(gamepads.length>deviceIndex&&deviceIndex>=0){return gamepads[deviceIndex]}return null})};function _Mix_Volume(channel,volume){if(channel==-1){for(var i=0;i<SDL.numChannels-1;i++){_Mix_Volume(i,volume)}return _Mix_Volume(SDL.numChannels-1,volume)}return SDL.setGetVolume(SDL.channels[channel],volume)}function _Mix_Playing(channel){if(channel===-1){var count=0;for(var i=0;i<SDL.channels.length;i++){count+=_Mix_Playing(i)}return count}var info=SDL.channels[channel];if(info&&info.audio&&!info.audio.paused){return 1}return 0}var _emscripten_landingpad=true;function ___cxa_free_exception(ptr){try{return _free(ptr-___cxa_exception_header_size)}catch(e){}}var ___cxa_caught_exceptions=[];function ___cxa_end_catch(){if(___cxa_end_catch.rethrown){___cxa_end_catch.rethrown=false;return}asm["setThrew"](0);var ptr=___cxa_caught_exceptions.pop();if(ptr){header=ptr-___cxa_exception_header_size;var destructor=HEAP32[header+4>>2];if(destructor){Runtime.dynCall("vi",destructor,[ptr]);HEAP32[header+4>>2]=0}___cxa_free_exception(ptr);___cxa_last_thrown_exception=0}}function _mkport(){throw"TODO"}var SOCKFS={mount:(function(mount){return FS.createNode(null,"/",16384|511,0)}),createSocket:(function(family,type,protocol){var streaming=type==1;if(protocol){assert(streaming==(protocol==6))}var sock={family:family,type:type,protocol:protocol,server:null,peers:{},pending:[],recv_queue:[],sock_ops:SOCKFS.websocket_sock_ops};var name=SOCKFS.nextname();var node=FS.createNode(SOCKFS.root,name,49152,0);node.sock=sock;var stream=FS.createStream({path:name,node:node,flags:FS.modeStringToFlags("r+"),seekable:false,stream_ops:SOCKFS.stream_ops});sock.stream=stream;return sock}),getSocket:(function(fd){var stream=FS.getStream(fd);if(!stream||!FS.isSocket(stream.node.mode)){return null}return stream.node.sock}),stream_ops:{poll:(function(stream){var sock=stream.node.sock;return sock.sock_ops.poll(sock)}),ioctl:(function(stream,request,varargs){var sock=stream.node.sock;return sock.sock_ops.ioctl(sock,request,varargs)}),read:(function(stream,buffer,offset,length,position){var sock=stream.node.sock;var msg=sock.sock_ops.recvmsg(sock,length);if(!msg){return 0}buffer.set(msg.buffer,offset);return msg.buffer.length}),write:(function(stream,buffer,offset,length,position){var sock=stream.node.sock;return sock.sock_ops.sendmsg(sock,buffer,offset,length)}),close:(function(stream){var sock=stream.node.sock;sock.sock_ops.close(sock)})},nextname:(function(){if(!SOCKFS.nextname.current){SOCKFS.nextname.current=0}return"socket["+SOCKFS.nextname.current++ +"]"}),websocket_sock_ops:{createPeer:(function(sock,addr,port){var ws;if(typeof addr==="object"){ws=addr;addr=null;port=null}if(ws){if(ws._socket){addr=ws._socket.remoteAddress;port=ws._socket.remotePort}else{var result=/ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);if(!result){throw new Error("WebSocket URL must be in the format ws(s)://address:port")}addr=result[1];port=parseInt(result[2],10)}}else{try{var runtimeConfig=Module["websocket"]&&"object"===typeof Module["websocket"];var url="ws:#".replace("#","//");if(runtimeConfig){if("string"===typeof Module["websocket"]["url"]){url=Module["websocket"]["url"]}}if(url==="ws://"||url==="wss://"){url=url+addr+":"+port}var subProtocols="binary";if(runtimeConfig){if("string"===typeof Module["websocket"]["subprotocol"]){subProtocols=Module["websocket"]["subprotocol"]}}subProtocols=subProtocols.replace(/^ +| +$/g,"").split(/ *, */);var opts=ENVIRONMENT_IS_NODE?{"protocol":subProtocols.toString()}:subProtocols;var WebSocket=ENVIRONMENT_IS_NODE?require("ws"):window["WebSocket"];ws=new WebSocket(url,opts);ws.binaryType="arraybuffer"}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH)}}var peer={addr:addr,port:port,socket:ws,dgram_send_queue:[]};SOCKFS.websocket_sock_ops.addPeer(sock,peer);SOCKFS.websocket_sock_ops.handlePeerEvents(sock,peer);if(sock.type===2&&typeof sock.sport!=="undefined"){peer.dgram_send_queue.push(new Uint8Array([255,255,255,255,"p".charCodeAt(0),"o".charCodeAt(0),"r".charCodeAt(0),"t".charCodeAt(0),(sock.sport&65280)>>8,sock.sport&255]))}return peer}),getPeer:(function(sock,addr,port){return sock.peers[addr+":"+port]}),addPeer:(function(sock,peer){sock.peers[peer.addr+":"+peer.port]=peer}),removePeer:(function(sock,peer){delete sock.peers[peer.addr+":"+peer.port]}),handlePeerEvents:(function(sock,peer){var first=true;var handleOpen=(function(){try{var queued=peer.dgram_send_queue.shift();while(queued){peer.socket.send(queued);queued=peer.dgram_send_queue.shift()}}catch(e){peer.socket.close()}});function handleMessage(data){assert(typeof data!=="string"&&data.byteLength!==undefined);data=new Uint8Array(data);var wasfirst=first;first=false;if(wasfirst&&data.length===10&&data[0]===255&&data[1]===255&&data[2]===255&&data[3]===255&&data[4]==="p".charCodeAt(0)&&data[5]==="o".charCodeAt(0)&&data[6]==="r".charCodeAt(0)&&data[7]==="t".charCodeAt(0)){var newport=data[8]<<8|data[9];SOCKFS.websocket_sock_ops.removePeer(sock,peer);peer.port=newport;SOCKFS.websocket_sock_ops.addPeer(sock,peer);return}sock.recv_queue.push({addr:peer.addr,port:peer.port,data:data})}if(ENVIRONMENT_IS_NODE){peer.socket.on("open",handleOpen);peer.socket.on("message",(function(data,flags){if(!flags.binary){return}handleMessage((new Uint8Array(data)).buffer)}));peer.socket.on("error",(function(){}))}else{peer.socket.onopen=handleOpen;peer.socket.onmessage=function peer_socket_onmessage(event){handleMessage(event.data)}}}),poll:(function(sock){if(sock.type===1&&sock.server){return sock.pending.length?64|1:0}var mask=0;var dest=sock.type===1?SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport):null;if(sock.recv_queue.length||!dest||dest&&dest.socket.readyState===dest.socket.CLOSING||dest&&dest.socket.readyState===dest.socket.CLOSED){mask|=64|1}if(!dest||dest&&dest.socket.readyState===dest.socket.OPEN){mask|=4}if(dest&&dest.socket.readyState===dest.socket.CLOSING||dest&&dest.socket.readyState===dest.socket.CLOSED){mask|=16}return mask}),ioctl:(function(sock,request,arg){switch(request){case 21531:var bytes=0;if(sock.recv_queue.length){bytes=sock.recv_queue[0].data.length}HEAP32[arg>>2]=bytes;return 0;default:return ERRNO_CODES.EINVAL}}),close:(function(sock){if(sock.server){try{sock.server.close()}catch(e){}sock.server=null}var peers=Object.keys(sock.peers);for(var i=0;i<peers.length;i++){var peer=sock.peers[peers[i]];try{peer.socket.close()}catch(e){}SOCKFS.websocket_sock_ops.removePeer(sock,peer)}return 0}),bind:(function(sock,addr,port){if(typeof sock.saddr!=="undefined"||typeof sock.sport!=="undefined"){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}sock.saddr=addr;sock.sport=port||_mkport();if(sock.type===2){if(sock.server){sock.server.close();sock.server=null}try{sock.sock_ops.listen(sock,0)}catch(e){if(!(e instanceof FS.ErrnoError))throw e;if(e.errno!==ERRNO_CODES.EOPNOTSUPP)throw e}}}),connect:(function(sock,addr,port){if(sock.server){throw new FS.ErrnoError(ERRNO_CODS.EOPNOTSUPP)}if(typeof sock.daddr!=="undefined"&&typeof sock.dport!=="undefined"){var dest=SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport);if(dest){if(dest.socket.readyState===dest.socket.CONNECTING){throw new FS.ErrnoError(ERRNO_CODES.EALREADY)}else{throw new FS.ErrnoError(ERRNO_CODES.EISCONN)}}}var peer=SOCKFS.websocket_sock_ops.createPeer(sock,addr,port);sock.daddr=peer.addr;sock.dport=peer.port;throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS)}),listen:(function(sock,backlog){if(!ENVIRONMENT_IS_NODE){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}if(sock.server){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var WebSocketServer=require("ws").Server;var host=sock.saddr;sock.server=new WebSocketServer({host:host,port:sock.sport});sock.server.on("connection",(function(ws){if(sock.type===1){var newsock=SOCKFS.createSocket(sock.family,sock.type,sock.protocol);var peer=SOCKFS.websocket_sock_ops.createPeer(newsock,ws);newsock.daddr=peer.addr;newsock.dport=peer.port;sock.pending.push(newsock)}else{SOCKFS.websocket_sock_ops.createPeer(sock,ws)}}));sock.server.on("closed",(function(){sock.server=null}));sock.server.on("error",(function(){}))}),accept:(function(listensock){if(!listensock.server){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var newsock=listensock.pending.shift();newsock.stream.flags=listensock.stream.flags;return newsock}),getname:(function(sock,peer){var addr,port;if(peer){if(sock.daddr===undefined||sock.dport===undefined){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}addr=sock.daddr;port=sock.dport}else{addr=sock.saddr||0;port=sock.sport||0}return{addr:addr,port:port}}),sendmsg:(function(sock,buffer,offset,length,addr,port){if(sock.type===2){if(addr===undefined||port===undefined){addr=sock.daddr;port=sock.dport}if(addr===undefined||port===undefined){throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ)}}else{addr=sock.daddr;port=sock.dport}var dest=SOCKFS.websocket_sock_ops.getPeer(sock,addr,port);if(sock.type===1){if(!dest||dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}else if(dest.socket.readyState===dest.socket.CONNECTING){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}var data;if(buffer instanceof Array||buffer instanceof ArrayBuffer){data=buffer.slice(offset,offset+length)}else{data=buffer.buffer.slice(buffer.byteOffset+offset,buffer.byteOffset+offset+length)}if(sock.type===2){if(!dest||dest.socket.readyState!==dest.socket.OPEN){if(!dest||dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){dest=SOCKFS.websocket_sock_ops.createPeer(sock,addr,port)}dest.dgram_send_queue.push(data);return length}}try{dest.socket.send(data);return length}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),recvmsg:(function(sock,length){if(sock.type===1&&sock.server){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}var queued=sock.recv_queue.shift();if(!queued){if(sock.type===1){var dest=SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport);if(!dest){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}else if(dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){return null}else{throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}else{throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}var queuedLength=queued.data.byteLength||queued.data.length;var queuedOffset=queued.data.byteOffset||0;var queuedBuffer=queued.data.buffer||queued.data;var bytesRead=Math.min(length,queuedLength);var res={buffer:new Uint8Array(queuedBuffer,queuedOffset,bytesRead),addr:queued.addr,port:queued.port};if(sock.type===1&&bytesRead<queuedLength){var bytesRemaining=queuedLength-bytesRead;queued.data=new Uint8Array(queuedBuffer,queuedOffset+bytesRead,bytesRemaining);sock.recv_queue.unshift(queued)}return res})}};function _send(fd,buf,len,flags){var sock=SOCKFS.getSocket(fd);if(!sock){___setErrNo(ERRNO_CODES.EBADF);return-1}return _write(fd,buf,len)}function _pwrite(fildes,buf,nbyte,offset){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte,offset)}catch(e){FS.handleFSError(e);return-1}}function _write(fildes,buf,nbyte){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte)}catch(e){FS.handleFSError(e);return-1}}function _fwrite(ptr,size,nitems,stream){var bytesToWrite=nitems*size;if(bytesToWrite==0)return 0;var fd=_fileno(stream);var bytesWritten=_write(fd,ptr,bytesToWrite);if(bytesWritten==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return 0}else{return Math.floor(bytesWritten/size)}}Module["_strlen"]=_strlen;function __reallyNegative(x){return x<0||x===0&&1/x===-Infinity}function __formatString(format,varargs){var textIndex=format;var argIndex=0;function getNextArg(type){var ret;if(type==="double"){ret=(HEAP32[tempDoublePtr>>2]=HEAP32[varargs+argIndex>>2],HEAP32[tempDoublePtr+4>>2]=HEAP32[varargs+(argIndex+4)>>2],+HEAPF64[tempDoublePtr>>3])}else if(type=="i64"){ret=[HEAP32[varargs+argIndex>>2],HEAP32[varargs+(argIndex+4)>>2]]}else{type="i32";ret=HEAP32[varargs+argIndex>>2]}argIndex+=Runtime.getNativeFieldSize(type);return ret}var ret=[];var curr,next,currArg;while(1){var startTextIndex=textIndex;curr=HEAP8[textIndex>>0];if(curr===0)break;next=HEAP8[textIndex+1>>0];if(curr==37){var flagAlwaysSigned=false;var flagLeftAlign=false;var flagAlternative=false;var flagZeroPad=false;var flagPadSign=false;flagsLoop:while(1){switch(next){case 43:flagAlwaysSigned=true;break;case 45:flagLeftAlign=true;break;case 35:flagAlternative=true;break;case 48:if(flagZeroPad){break flagsLoop}else{flagZeroPad=true;break};case 32:flagPadSign=true;break;default:break flagsLoop}textIndex++;next=HEAP8[textIndex+1>>0]}var width=0;if(next==42){width=getNextArg("i32");textIndex++;next=HEAP8[textIndex+1>>0]}else{while(next>=48&&next<=57){width=width*10+(next-48);textIndex++;next=HEAP8[textIndex+1>>0]}}var precisionSet=false,precision=-1;if(next==46){precision=0;precisionSet=true;textIndex++;next=HEAP8[textIndex+1>>0];if(next==42){precision=getNextArg("i32");textIndex++}else{while(1){var precisionChr=HEAP8[textIndex+1>>0];if(precisionChr<48||precisionChr>57)break;precision=precision*10+(precisionChr-48);textIndex++}}next=HEAP8[textIndex+1>>0]}if(precision<0){precision=6;precisionSet=false}var argSize;switch(String.fromCharCode(next)){case"h":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==104){textIndex++;argSize=1}else{argSize=2}break;case"l":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==108){textIndex++;argSize=8}else{argSize=4}break;case"L":case"q":case"j":argSize=8;break;case"z":case"t":case"I":argSize=4;break;default:argSize=null}if(argSize)textIndex++;next=HEAP8[textIndex+1>>0];switch(String.fromCharCode(next)){case"d":case"i":case"u":case"o":case"x":case"X":case"p":{var signed=next==100||next==105;argSize=argSize||4;var currArg=getNextArg("i"+argSize*8);var origArg=currArg;var argText;if(argSize==8){currArg=Runtime.makeBigInt(currArg[0],currArg[1],next==117)}if(argSize<=4){var limit=Math.pow(256,argSize)-1;currArg=(signed?reSign:unSign)(currArg&limit,argSize*8)}var currAbsArg=Math.abs(currArg);var prefix="";if(next==100||next==105){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],null);else argText=reSign(currArg,8*argSize,1).toString(10)}else if(next==117){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],true);else argText=unSign(currArg,8*argSize,1).toString(10);currArg=Math.abs(currArg)}else if(next==111){argText=(flagAlternative?"0":"")+currAbsArg.toString(8)}else if(next==120||next==88){prefix=flagAlternative&&currArg!=0?"0x":"";if(argSize==8&&i64Math){if(origArg[1]){argText=(origArg[1]>>>0).toString(16);var lower=(origArg[0]>>>0).toString(16);while(lower.length<8)lower="0"+lower;argText+=lower}else{argText=(origArg[0]>>>0).toString(16)}}else if(currArg<0){currArg=-currArg;argText=(currAbsArg-1).toString(16);var buffer=[];for(var i=0;i<argText.length;i++){buffer.push((15-parseInt(argText[i],16)).toString(16))}argText=buffer.join("");while(argText.length<argSize*2)argText="f"+argText}else{argText=currAbsArg.toString(16)}if(next==88){prefix=prefix.toUpperCase();argText=argText.toUpperCase()}}else if(next==112){if(currAbsArg===0){argText="(nil)"}else{prefix="0x";argText=currAbsArg.toString(16)}}if(precisionSet){while(argText.length<precision){argText="0"+argText}}if(currArg>=0){if(flagAlwaysSigned){prefix="+"+prefix}else if(flagPadSign){prefix=" "+prefix}}if(argText.charAt(0)=="-"){prefix="-"+prefix;argText=argText.substr(1)}while(prefix.length+argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad){argText="0"+argText}else{prefix=" "+prefix}}}argText=prefix+argText;argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"f":case"F":case"e":case"E":case"g":case"G":{var currArg=getNextArg("double");var argText;if(isNaN(currArg)){argText="nan";flagZeroPad=false}else if(!isFinite(currArg)){argText=(currArg<0?"-":"")+"inf";flagZeroPad=false}else{var isGeneral=false;var effectivePrecision=Math.min(precision,20);if(next==103||next==71){isGeneral=true;precision=precision||1;var exponent=parseInt(currArg.toExponential(effectivePrecision).split("e")[1],10);if(precision>exponent&&exponent>=-4){next=(next==103?"f":"F").charCodeAt(0);precision-=exponent+1}else{next=(next==103?"e":"E").charCodeAt(0);precision--}effectivePrecision=Math.min(precision,20)}if(next==101||next==69){argText=currArg.toExponential(effectivePrecision);if(/[eE][-+]\d$/.test(argText)){argText=argText.slice(0,-1)+"0"+argText.slice(-1)}}else if(next==102||next==70){argText=currArg.toFixed(effectivePrecision);if(currArg===0&&__reallyNegative(currArg)){argText="-"+argText}}var parts=argText.split("e");if(isGeneral&&!flagAlternative){while(parts[0].length>1&&parts[0].indexOf(".")!=-1&&(parts[0].slice(-1)=="0"||parts[0].slice(-1)==".")){parts[0]=parts[0].slice(0,-1)}}else{if(flagAlternative&&argText.indexOf(".")==-1)parts[0]+=".";while(precision>effectivePrecision++)parts[0]+="0"}argText=parts[0]+(parts.length>1?"e"+parts[1]:"");if(next==69)argText=argText.toUpperCase();if(currArg>=0){if(flagAlwaysSigned){argText="+"+argText}else if(flagPadSign){argText=" "+argText}}}while(argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad&&(argText[0]=="-"||argText[0]=="+")){argText=argText[0]+"0"+argText.slice(1)}else{argText=(flagZeroPad?"0":" ")+argText}}}if(next<97)argText=argText.toUpperCase();argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"s":{var arg=getNextArg("i8*");var argLength=arg?_strlen(arg):"(null)".length;if(precisionSet)argLength=Math.min(argLength,precision);if(!flagLeftAlign){while(argLength<width--){ret.push(32)}}if(arg){for(var i=0;i<argLength;i++){ret.push(HEAPU8[arg++>>0])}}else{ret=ret.concat(intArrayFromString("(null)".substr(0,argLength),true))}if(flagLeftAlign){while(argLength<width--){ret.push(32)}}break};case"c":{if(flagLeftAlign)ret.push(getNextArg("i8"));while(--width>0){ret.push(32)}if(!flagLeftAlign)ret.push(getNextArg("i8"));break};case"n":{var ptr=getNextArg("i32*");HEAP32[ptr>>2]=ret.length;break};case"%":{ret.push(curr);break};default:{for(var i=startTextIndex;i<textIndex+2;i++){ret.push(HEAP8[i>>0])}}}textIndex+=2}else{ret.push(curr);textIndex+=1}}return ret}function _fprintf(stream,format,varargs){var result=__formatString(format,varargs);var stack=Runtime.stackSave();var ret=_fwrite(allocate(result,"i8",ALLOC_STACK),1,result.length,stream);Runtime.stackRestore(stack);return ret}function _printf(format,varargs){var stdout=HEAP32[_stdout>>2];return _fprintf(stdout,format,varargs)}function _glBindTexture(target,texture){GLctx.bindTexture(target,texture?GL.textures[texture]:null)}var GLImmediate={MapTreeLib:null,spawnMapTreeLib:(function(){function CNaiveListMap(){var list=[];this.insert=function CNaiveListMap_insert(key,val){if(this.contains(key|0))return false;list.push([key,val]);return true};var __contains_i;this.contains=function CNaiveListMap_contains(key){for(__contains_i=0;__contains_i<list.length;++__contains_i){if(list[__contains_i][0]===key)return true}return false};var __get_i;this.get=function CNaiveListMap_get(key){for(__get_i=0;__get_i<list.length;++__get_i){if(list[__get_i][0]===key)return list[__get_i][1]}return undefined}}function CMapTree(){function CNLNode(){var map=new CNaiveListMap;this.child=function CNLNode_child(keyFrag){if(!map.contains(keyFrag|0)){map.insert(keyFrag|0,new CNLNode)}return map.get(keyFrag|0)};this.value=undefined;this.get=function CNLNode_get(){return this.value};this.set=function CNLNode_set(val){this.value=val}}function CKeyView(root){var cur;this.reset=function CKeyView_reset(){cur=root;return this};this.reset();this.next=function CKeyView_next(keyFrag){cur=cur.child(keyFrag);return this};this.get=function CKeyView_get(){return cur.get()};this.set=function CKeyView_set(val){cur.set(val)}}var root;var staticKeyView;this.createKeyView=function CNLNode_createKeyView(){return new CKeyView(root)};this.clear=function CNLNode_clear(){root=new CNLNode;staticKeyView=this.createKeyView()};this.clear();this.getStaticKeyView=function CNLNode_getStaticKeyView(){staticKeyView.reset();return staticKeyView}}return{create:(function(){return new CMapTree})}}),TexEnvJIT:null,spawnTexEnvJIT:(function(){var GL_TEXTURE0=33984;var GL_TEXTURE_1D=3552;var GL_TEXTURE_2D=3553;var GL_TEXTURE_3D=32879;var GL_TEXTURE_CUBE_MAP=34067;var GL_TEXTURE_ENV=8960;var GL_TEXTURE_ENV_MODE=8704;var GL_TEXTURE_ENV_COLOR=8705;var GL_TEXTURE_CUBE_MAP_POSITIVE_X=34069;var GL_TEXTURE_CUBE_MAP_NEGATIVE_X=34070;var GL_TEXTURE_CUBE_MAP_POSITIVE_Y=34071;var GL_TEXTURE_CUBE_MAP_NEGATIVE_Y=34072;var GL_TEXTURE_CUBE_MAP_POSITIVE_Z=34073;var GL_TEXTURE_CUBE_MAP_NEGATIVE_Z=34074;var GL_SRC0_RGB=34176;var GL_SRC1_RGB=34177;var GL_SRC2_RGB=34178;var GL_SRC0_ALPHA=34184;var GL_SRC1_ALPHA=34185;var GL_SRC2_ALPHA=34186;var GL_OPERAND0_RGB=34192;var GL_OPERAND1_RGB=34193;var GL_OPERAND2_RGB=34194;var GL_OPERAND0_ALPHA=34200;var GL_OPERAND1_ALPHA=34201;var GL_OPERAND2_ALPHA=34202;var GL_COMBINE_RGB=34161;var GL_COMBINE_ALPHA=34162;var GL_RGB_SCALE=34163;var GL_ALPHA_SCALE=3356;var GL_ADD=260;var GL_BLEND=3042;var GL_REPLACE=7681;var GL_MODULATE=8448;var GL_DECAL=8449;var GL_COMBINE=34160;var GL_SUBTRACT=34023;var GL_INTERPOLATE=34165;var GL_TEXTURE=5890;var GL_CONSTANT=34166;var GL_PRIMARY_COLOR=34167;var GL_PREVIOUS=34168;var GL_SRC_COLOR=768;var GL_ONE_MINUS_SRC_COLOR=769;var GL_SRC_ALPHA=770;var GL_ONE_MINUS_SRC_ALPHA=771;var GL_RGB=6407;var GL_RGBA=6408;var TEXENVJIT_NAMESPACE_PREFIX="tej_";var TEX_UNIT_UNIFORM_PREFIX="uTexUnit";var TEX_COORD_VARYING_PREFIX="vTexCoord";var PRIM_COLOR_VARYING="vPrimColor";var TEX_MATRIX_UNIFORM_PREFIX="uTexMatrix";var s_texUnits=null;var s_activeTexture=0;var s_requiredTexUnitsForPass=[];function abort(info){assert(false,"[TexEnvJIT] ABORT: "+info)}function abort_noSupport(info){abort("No support: "+info)}function abort_sanity(info){abort("Sanity failure: "+info)}function genTexUnitSampleExpr(texUnitID){var texUnit=s_texUnits[texUnitID];var texType=texUnit.getTexType();var func=null;switch(texType){case GL_TEXTURE_1D:func="texture2D";break;case GL_TEXTURE_2D:func="texture2D";break;case GL_TEXTURE_3D:return abort_noSupport("No support for 3D textures.");case GL_TEXTURE_CUBE_MAP:func="textureCube";break;default:return abort_sanity("Unknown texType: 0x"+texType.toString(16))}var texCoordExpr=TEX_COORD_VARYING_PREFIX+texUnitID;if(TEX_MATRIX_UNIFORM_PREFIX!=null){texCoordExpr="("+TEX_MATRIX_UNIFORM_PREFIX+texUnitID+" * "+texCoordExpr+")"}return func+"("+TEX_UNIT_UNIFORM_PREFIX+texUnitID+", "+texCoordExpr+".xy)"}function getTypeFromCombineOp(op){switch(op){case GL_SRC_COLOR:case GL_ONE_MINUS_SRC_COLOR:return"vec3";case GL_SRC_ALPHA:case GL_ONE_MINUS_SRC_ALPHA:return"float"}return abort_noSupport("Unsupported combiner op: 0x"+op.toString(16))}function getCurTexUnit(){return s_texUnits[s_activeTexture]}function genCombinerSourceExpr(texUnitID,constantExpr,previousVar,src,op){var srcExpr=null;switch(src){case GL_TEXTURE:srcExpr=genTexUnitSampleExpr(texUnitID);break;case GL_CONSTANT:srcExpr=constantExpr;break;case GL_PRIMARY_COLOR:srcExpr=PRIM_COLOR_VARYING;break;case GL_PREVIOUS:srcExpr=previousVar;break;default:return abort_noSupport("Unsupported combiner src: 0x"+src.toString(16))}var expr=null;switch(op){case GL_SRC_COLOR:expr=srcExpr+".rgb";break;case GL_ONE_MINUS_SRC_COLOR:expr="(vec3(1.0) - "+srcExpr+".rgb)";break;case GL_SRC_ALPHA:expr=srcExpr+".a";break;case GL_ONE_MINUS_SRC_ALPHA:expr="(1.0 - "+srcExpr+".a)";break;default:return abort_noSupport("Unsupported combiner op: 0x"+op.toString(16))}return expr}function valToFloatLiteral(val){if(val==Math.round(val))return val+".0";return val}function CTexEnv(){this.mode=GL_MODULATE;this.colorCombiner=GL_MODULATE;this.alphaCombiner=GL_MODULATE;this.colorScale=1;this.alphaScale=1;this.envColor=[0,0,0,0];this.colorSrc=[GL_TEXTURE,GL_PREVIOUS,GL_CONSTANT];this.alphaSrc=[GL_TEXTURE,GL_PREVIOUS,GL_CONSTANT];this.colorOp=[GL_SRC_COLOR,GL_SRC_COLOR,GL_SRC_ALPHA];this.alphaOp=[GL_SRC_ALPHA,GL_SRC_ALPHA,GL_SRC_ALPHA];this.traverseKey={7681:0,8448:1,260:2,3042:3,8449:4,34160:5,34023:3,34165:4,5890:0,34166:1,34167:2,34168:3,768:0,769:1,770:2,768:3};this.key0=-1;this.key1=0;this.key2=0;this.computeKey0=(function(){var k=this.traverseKey;var key=k[this.mode]*1638400;key+=k[this.colorCombiner]*327680;key+=k[this.alphaCombiner]*65536;key+=(this.colorScale-1)*16384;key+=(this.alphaScale-1)*4096;key+=k[this.colorSrc[0]]*1024;key+=k[this.colorSrc[1]]*256;key+=k[this.colorSrc[2]]*64;key+=k[this.alphaSrc[0]]*16;key+=k[this.alphaSrc[1]]*4;key+=k[this.alphaSrc[2]];return key});this.computeKey1=(function(){var k=this.traverseKey;key=k[this.colorOp[0]]*4096;key+=k[this.colorOp[1]]*1024;key+=k[this.colorOp[2]]*256;key+=k[this.alphaOp[0]]*16;key+=k[this.alphaOp[1]]*4;key+=k[this.alphaOp[2]];return key});this.computeKey2=(function(){return this.envColor[0]*16777216+this.envColor[1]*65536+this.envColor[2]*256+1+this.envColor[3]});this.recomputeKey=(function(){this.key0=this.computeKey0();this.key1=this.computeKey1();this.key2=this.computeKey2()});this.invalidateKey=(function(){this.key0=-1;GLImmediate.currentRenderer=null})}function CTexUnit(){this.env=new CTexEnv;this.enabled_tex1D=false;this.enabled_tex2D=false;this.enabled_tex3D=false;this.enabled_texCube=false;this.texTypesEnabled=0;this.traverseState=function CTexUnit_traverseState(keyView){if(this.texTypesEnabled){if(this.env.key0==-1){this.env.recomputeKey()}keyView.next(this.texTypesEnabled|this.env.key0<<4);keyView.next(this.env.key1);keyView.next(this.env.key2)}else{keyView.next(0)}}}CTexUnit.prototype.enabled=function CTexUnit_enabled(){return this.texTypesEnabled};CTexUnit.prototype.genPassLines=function CTexUnit_genPassLines(passOutputVar,passInputVar,texUnitID){if(!this.enabled()){return["vec4 "+passOutputVar+" = "+passInputVar+";"]}var lines=this.env.genPassLines(passOutputVar,passInputVar,texUnitID).join("\n");var texLoadLines="";var texLoadRegex=/(texture.*?\(.*?\))/g;var loadCounter=0;var load;while(load=texLoadRegex.exec(lines)){var texLoadExpr=load[1];var secondOccurrence=lines.slice(load.index+1).indexOf(texLoadExpr);if(secondOccurrence!=-1){var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texLoadVar=prefix+"texload"+loadCounter++;var texLoadLine="vec4 "+texLoadVar+" = "+texLoadExpr+";\n";texLoadLines+=texLoadLine+"\n";lines=lines.split(texLoadExpr).join(texLoadVar);texLoadRegex=/(texture.*\(.*\))/g}}return[texLoadLines+lines]};CTexUnit.prototype.getTexType=function CTexUnit_getTexType(){if(this.enabled_texCube){return GL_TEXTURE_CUBE_MAP}else if(this.enabled_tex3D){return GL_TEXTURE_3D}else if(this.enabled_tex2D){return GL_TEXTURE_2D}else if(this.enabled_tex1D){return GL_TEXTURE_1D}return 0};CTexEnv.prototype.genPassLines=function CTexEnv_genPassLines(passOutputVar,passInputVar,texUnitID){switch(this.mode){case GL_REPLACE:{return["vec4 "+passOutputVar+" = "+genTexUnitSampleExpr(texUnitID)+";"]};case GL_ADD:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";","vec3 "+colorVar+" = "+passInputVar+".rgb + "+texVar+".rgb;","float "+alphaVar+" = "+passInputVar+".a * "+texVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]};case GL_MODULATE:{var line=["vec4 "+passOutputVar," = ",passInputVar," * ",genTexUnitSampleExpr(texUnitID),";"];return[line.join("")]};case GL_DECAL:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";",["vec3 "+colorVar+" = ",passInputVar+".rgb * (1.0 - "+texVar+".a)"," + ",texVar+".rgb * "+texVar+".a",";"].join(""),"float "+alphaVar+" = "+passInputVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]};case GL_BLEND:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";",["vec3 "+colorVar+" = ",passInputVar+".rgb * (1.0 - "+texVar+".rgb)"," + ",PRIM_COLOR_VARYING+".rgb * "+texVar+".rgb",";"].join(""),"float "+alphaVar+" = "+texVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]};case GL_COMBINE:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";var colorLines=this.genCombinerLines(true,colorVar,passInputVar,texUnitID,this.colorCombiner,this.colorSrc,this.colorOp);var alphaLines=this.genCombinerLines(false,alphaVar,passInputVar,texUnitID,this.alphaCombiner,this.alphaSrc,this.alphaOp);var scaledColor=this.colorScale==1?colorVar:colorVar+" * "+valToFloatLiteral(this.colorScale);var scaledAlpha=this.alphaScale==1?alphaVar:alphaVar+" * "+valToFloatLiteral(this.alphaScale);var line=["vec4 "+passOutputVar," = ","vec4(",scaledColor,", ",scaledAlpha,")",";"].join("");return[].concat(colorLines,alphaLines,[line])}}return abort_noSupport("Unsupported TexEnv mode: 0x"+this.mode.toString(16))};CTexEnv.prototype.genCombinerLines=function CTexEnv_getCombinerLines(isColor,outputVar,passInputVar,texUnitID,combiner,srcArr,opArr){var argsNeeded=null;switch(combiner){case GL_REPLACE:argsNeeded=1;break;case GL_MODULATE:case GL_ADD:case GL_SUBTRACT:argsNeeded=2;break;case GL_INTERPOLATE:argsNeeded=3;break;default:return abort_noSupport("Unsupported combiner: 0x"+combiner.toString(16))}var constantExpr=["vec4(",valToFloatLiteral(this.envColor[0]),", ",valToFloatLiteral(this.envColor[1]),", ",valToFloatLiteral(this.envColor[2]),", ",valToFloatLiteral(this.envColor[3]),")"].join("");var src0Expr=argsNeeded>=1?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[0],opArr[0]):null;var src1Expr=argsNeeded>=2?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[1],opArr[1]):null;var src2Expr=argsNeeded>=3?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[2],opArr[2]):null;var outputType=isColor?"vec3":"float";var lines=null;switch(combiner){case GL_REPLACE:{var line=[outputType+" "+outputVar," = ",src0Expr,";"];lines=[line.join("")];break};case GL_MODULATE:{var line=[outputType+" "+outputVar+" = ",src0Expr+" * "+src1Expr,";"];lines=[line.join("")];break};case GL_ADD:{var line=[outputType+" "+outputVar+" = ",src0Expr+" + "+src1Expr,";"];lines=[line.join("")];break};case GL_SUBTRACT:{var line=[outputType+" "+outputVar+" = ",src0Expr+" - "+src1Expr,";"];lines=[line.join("")];break};case GL_INTERPOLATE:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var arg2Var=prefix+"colorSrc2";var arg2Line=getTypeFromCombineOp(this.colorOp[2])+" "+arg2Var+" = "+src2Expr+";";var line=[outputType+" "+outputVar," = ",src0Expr+" * "+arg2Var," + ",src1Expr+" * (1.0 - "+arg2Var+")",";"];lines=[arg2Line,line.join("")];break};default:return abort_sanity("Unmatched TexEnv.colorCombiner?")}return lines};return{init:(function(gl,specifiedMaxTextureImageUnits){var maxTexUnits=0;if(specifiedMaxTextureImageUnits){maxTexUnits=specifiedMaxTextureImageUnits}else if(gl){maxTexUnits=gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS)}s_texUnits=[];for(var i=0;i<maxTexUnits;i++){s_texUnits.push(new CTexUnit)}}),setGLSLVars:(function(uTexUnitPrefix,vTexCoordPrefix,vPrimColor,uTexMatrixPrefix){TEX_UNIT_UNIFORM_PREFIX=uTexUnitPrefix;TEX_COORD_VARYING_PREFIX=vTexCoordPrefix;PRIM_COLOR_VARYING=vPrimColor;TEX_MATRIX_UNIFORM_PREFIX=uTexMatrixPrefix}),genAllPassLines:(function(resultDest,indentSize){indentSize=indentSize||0;s_requiredTexUnitsForPass.length=0;var lines=[];var lastPassVar=PRIM_COLOR_VARYING;for(var i=0;i<s_texUnits.length;i++){if(!s_texUnits[i].enabled())continue;s_requiredTexUnitsForPass.push(i);var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+i+"_";var passOutputVar=prefix+"result";var newLines=s_texUnits[i].genPassLines(passOutputVar,lastPassVar,i);lines=lines.concat(newLines,[""]);lastPassVar=passOutputVar}lines.push(resultDest+" = "+lastPassVar+";");var indent="";for(var i=0;i<indentSize;i++)indent+=" ";var output=indent+lines.join("\n"+indent);return output}),getUsedTexUnitList:(function(){return s_requiredTexUnitsForPass}),traverseState:(function(keyView){for(var i=0;i<s_texUnits.length;i++){s_texUnits[i].traverseState(keyView)}}),getTexUnitType:(function(texUnitID){return s_texUnits[texUnitID].getTexType()}),hook_activeTexture:(function(texture){s_activeTexture=texture-GL_TEXTURE0}),hook_enable:(function(cap){var cur=getCurTexUnit();switch(cap){case GL_TEXTURE_1D:if(!cur.enabled_tex1D){GLImmediate.currentRenderer=null;cur.enabled_tex1D=true;cur.texTypesEnabled|=1}break;case GL_TEXTURE_2D:if(!cur.enabled_tex2D){GLImmediate.currentRenderer=null;cur.enabled_tex2D=true;cur.texTypesEnabled|=2}break;case GL_TEXTURE_3D:if(!cur.enabled_tex3D){GLImmediate.currentRenderer=null;cur.enabled_tex3D=true;cur.texTypesEnabled|=4}break;case GL_TEXTURE_CUBE_MAP:if(!cur.enabled_texCube){GLImmediate.currentRenderer=null;cur.enabled_texCube=true;cur.texTypesEnabled|=8}break}}),hook_disable:(function(cap){var cur=getCurTexUnit();switch(cap){case GL_TEXTURE_1D:if(cur.enabled_tex1D){GLImmediate.currentRenderer=null;cur.enabled_tex1D=false;cur.texTypesEnabled&=~1}break;case GL_TEXTURE_2D:if(cur.enabled_tex2D){GLImmediate.currentRenderer=null;cur.enabled_tex2D=false;cur.texTypesEnabled&=~2}break;case GL_TEXTURE_3D:if(cur.enabled_tex3D){GLImmediate.currentRenderer=null;cur.enabled_tex3D=false;cur.texTypesEnabled&=~4}break;case GL_TEXTURE_CUBE_MAP:if(cur.enabled_texCube){GLImmediate.currentRenderer=null;cur.enabled_texCube=false;cur.texTypesEnabled&=~8}break}}),hook_texEnvf:(function(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_RGB_SCALE:if(env.colorScale!=param){env.invalidateKey();env.colorScale=param}break;case GL_ALPHA_SCALE:if(env.alphaScale!=param){env.invalidateKey();env.alphaScale=param}break;default:Module.printErr("WARNING: Unhandled `pname` in call to `glTexEnvf`.")}}),hook_texEnvi:(function(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_MODE:if(env.mode!=param){env.invalidateKey();env.mode=param}break;case GL_COMBINE_RGB:if(env.colorCombiner!=param){env.invalidateKey();env.colorCombiner=param}break;case GL_COMBINE_ALPHA:if(env.alphaCombiner!=param){env.invalidateKey();env.alphaCombiner=param}break;case GL_SRC0_RGB:if(env.colorSrc[0]!=param){env.invalidateKey();env.colorSrc[0]=param}break;case GL_SRC1_RGB:if(env.colorSrc[1]!=param){env.invalidateKey();env.colorSrc[1]=param}break;case GL_SRC2_RGB:if(env.colorSrc[2]!=param){env.invalidateKey();env.colorSrc[2]=param}break;case GL_SRC0_ALPHA:if(env.alphaSrc[0]!=param){env.invalidateKey();env.alphaSrc[0]=param}break;case GL_SRC1_ALPHA:if(env.alphaSrc[1]!=param){env.invalidateKey();env.alphaSrc[1]=param}break;case GL_SRC2_ALPHA:if(env.alphaSrc[2]!=param){env.invalidateKey();env.alphaSrc[2]=param}break;case GL_OPERAND0_RGB:if(env.colorOp[0]!=param){env.invalidateKey();env.colorOp[0]=param}break;case GL_OPERAND1_RGB:if(env.colorOp[1]!=param){env.invalidateKey();env.colorOp[1]=param}break;case GL_OPERAND2_RGB:if(env.colorOp[2]!=param){env.invalidateKey();env.colorOp[2]=param}break;case GL_OPERAND0_ALPHA:if(env.alphaOp[0]!=param){env.invalidateKey();env.alphaOp[0]=param}break;case GL_OPERAND1_ALPHA:if(env.alphaOp[1]!=param){env.invalidateKey();env.alphaOp[1]=param}break;case GL_OPERAND2_ALPHA:if(env.alphaOp[2]!=param){env.invalidateKey();env.alphaOp[2]=param}break;case GL_RGB_SCALE:if(env.colorScale!=param){env.invalidateKey();env.colorScale=param}break;case GL_ALPHA_SCALE:if(env.alphaScale!=param){env.invalidateKey();env.alphaScale=param}break;default:Module.printErr("WARNING: Unhandled `pname` in call to `glTexEnvi`.")}}),hook_texEnvfv:(function(target,pname,params){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_COLOR:{for(var i=0;i<4;i++){var param=HEAPF32[params+i*4>>2];if(env.envColor[i]!=param){env.invalidateKey();env.envColor[i]=param}}break};default:Module.printErr("WARNING: Unhandled `pname` in call to `glTexEnvfv`.")}}),hook_getTexEnviv:(function(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_MODE:HEAP32[param>>2]=env.mode;return;case GL_TEXTURE_ENV_COLOR:HEAP32[param>>2]=Math.max(Math.min(env.envColor[0]*255,255,-255));HEAP32[param+1>>2]=Math.max(Math.min(env.envColor[1]*255,255,-255));HEAP32[param+2>>2]=Math.max(Math.min(env.envColor[2]*255,255,-255));HEAP32[param+3>>2]=Math.max(Math.min(env.envColor[3]*255,255,-255));return;case GL_COMBINE_RGB:HEAP32[param>>2]=env.colorCombiner;return;case GL_COMBINE_ALPHA:HEAP32[param>>2]=env.alphaCombiner;return;case GL_SRC0_RGB:HEAP32[param>>2]=env.colorSrc[0];return;case GL_SRC1_RGB:HEAP32[param>>2]=env.colorSrc[1];return;case GL_SRC2_RGB:HEAP32[param>>2]=env.colorSrc[2];return;case GL_SRC0_ALPHA:HEAP32[param>>2]=env.alphaSrc[0];return;case GL_SRC1_ALPHA:HEAP32[param>>2]=env.alphaSrc[1];return;case GL_SRC2_ALPHA:HEAP32[param>>2]=env.alphaSrc[2];return;case GL_OPERAND0_RGB:HEAP32[param>>2]=env.colorOp[0];return;case GL_OPERAND1_RGB:HEAP32[param>>2]=env.colorOp[1];return;case GL_OPERAND2_RGB:HEAP32[param>>2]=env.colorOp[2];return;case GL_OPERAND0_ALPHA:HEAP32[param>>2]=env.alphaOp[0];return;case GL_OPERAND1_ALPHA:HEAP32[param>>2]=env.alphaOp[1];return;case GL_OPERAND2_ALPHA:HEAP32[param>>2]=env.alphaOp[2];return;case GL_RGB_SCALE:HEAP32[param>>2]=env.colorScale;return;case GL_ALPHA_SCALE:HEAP32[param>>2]=env.alphaScale;return;default:Module.printErr("WARNING: Unhandled `pname` in call to `glGetTexEnvi`.")}}),hook_getTexEnvfv:(function(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_COLOR:HEAPF32[param>>2]=env.envColor[0];HEAPF32[param+4>>2]=env.envColor[1];HEAPF32[param+8>>2]=env.envColor[2];HEAPF32[param+12>>2]=env.envColor[3];return}})}}),vertexData:null,vertexDataU8:null,tempData:null,indexData:null,vertexCounter:0,mode:-1,rendererCache:null,rendererComponents:[],rendererComponentPointer:0,lastRenderer:null,lastArrayBuffer:null,lastProgram:null,lastStride:-1,matrix:[],matrixStack:[],currentMatrix:0,tempMatrix:null,matricesModified:false,useTextureMatrix:false,VERTEX:0,NORMAL:1,COLOR:2,TEXTURE0:3,NUM_ATTRIBUTES:-1,MAX_TEXTURES:-1,totalEnabledClientAttributes:0,enabledClientAttributes:[0,0],clientAttributes:[],liveClientAttributes:[],currentRenderer:null,modifiedClientAttributes:false,clientActiveTexture:0,clientColor:null,usedTexUnitList:[],fixedFunctionProgram:null,setClientAttribute:function setClientAttribute(name,size,type,stride,pointer){var attrib=GLImmediate.clientAttributes[name];if(!attrib){for(var i=0;i<=name;i++){if(!GLImmediate.clientAttributes[i]){GLImmediate.clientAttributes[i]={name:name,size:size,type:type,stride:stride,pointer:pointer,offset:0}}}}else{attrib.name=name;attrib.size=size;attrib.type=type;attrib.stride=stride;attrib.pointer=pointer;attrib.offset=0}GLImmediate.modifiedClientAttributes=true},addRendererComponent:function addRendererComponent(name,size,type){if(!GLImmediate.rendererComponents[name]){GLImmediate.rendererComponents[name]=1;GLImmediate.enabledClientAttributes[name]=true;GLImmediate.setClientAttribute(name,size,type,0,GLImmediate.rendererComponentPointer);GLImmediate.rendererComponentPointer+=size*GL.byteSizeByType[type-GL.byteSizeByTypeRoot]}else{GLImmediate.rendererComponents[name]++}},disableBeginEndClientAttributes:function disableBeginEndClientAttributes(){for(var i=0;i<GLImmediate.NUM_ATTRIBUTES;i++){if(GLImmediate.rendererComponents[i])GLImmediate.enabledClientAttributes[i]=false}},getRenderer:function getRenderer(){if(GLImmediate.currentRenderer){return GLImmediate.currentRenderer}var attributes=GLImmediate.liveClientAttributes;var cacheMap=GLImmediate.rendererCache;var keyView=cacheMap.getStaticKeyView().reset();var enabledAttributesKey=0;for(var i=0;i<attributes.length;i++){enabledAttributesKey|=1<<attributes[i].name}var fogParam=0;if(GLEmulation.fogEnabled){switch(GLEmulation.fogMode){case 2049:fogParam=1;break;case 9729:fogParam=2;break;default:fogParam=3;break}}keyView.next(enabledAttributesKey<<2|fogParam);keyView.next(GL.currProgram);if(!GL.currProgram){GLImmediate.TexEnvJIT.traverseState(keyView)}var renderer=keyView.get();if(!renderer){renderer=GLImmediate.createRenderer();GLImmediate.currentRenderer=renderer;keyView.set(renderer);return renderer}GLImmediate.currentRenderer=renderer;return renderer},createRenderer:function createRenderer(renderer){var useCurrProgram=!!GL.currProgram;var hasTextures=false;for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var texAttribName=GLImmediate.TEXTURE0+i;if(!GLImmediate.enabledClientAttributes[texAttribName])continue;hasTextures=true}var ret={init:function init(){var uTexUnitPrefix="u_texUnit";var aTexCoordPrefix="a_texCoord";var vTexCoordPrefix="v_texCoord";var vPrimColor="v_color";var uTexMatrixPrefix=GLImmediate.useTextureMatrix?"u_textureMatrix":null;if(useCurrProgram){if(GL.shaderInfos[GL.programShaders[GL.currProgram][0]].type==GLctx.VERTEX_SHADER){this.vertexShader=GL.shaders[GL.programShaders[GL.currProgram][0]];this.fragmentShader=GL.shaders[GL.programShaders[GL.currProgram][1]]}else{this.vertexShader=GL.shaders[GL.programShaders[GL.currProgram][1]];this.fragmentShader=GL.shaders[GL.programShaders[GL.currProgram][0]]}this.program=GL.programs[GL.currProgram];this.usedTexUnitList=[]}else{if(GLEmulation.fogEnabled){switch(GLEmulation.fogMode){case 2049:var fogFormula="  float fog = exp(-u_fogDensity * u_fogDensity * ecDistance * ecDistance); \n";break;case 9729:var fogFormula="  float fog = (u_fogEnd - ecDistance) * u_fogScale; \n";break;default:var fogFormula="  float fog = exp(-u_fogDensity * ecDistance); \n";break}}GLImmediate.TexEnvJIT.setGLSLVars(uTexUnitPrefix,vTexCoordPrefix,vPrimColor,uTexMatrixPrefix);var fsTexEnvPass=GLImmediate.TexEnvJIT.genAllPassLines("gl_FragColor",2);var texUnitAttribList="";var texUnitVaryingList="";var texUnitUniformList="";var vsTexCoordInits="";this.usedTexUnitList=GLImmediate.TexEnvJIT.getUsedTexUnitList();for(var i=0;i<this.usedTexUnitList.length;i++){var texUnit=this.usedTexUnitList[i];texUnitAttribList+="attribute vec4 "+aTexCoordPrefix+texUnit+";\n";texUnitVaryingList+="varying vec4 "+vTexCoordPrefix+texUnit+";\n";texUnitUniformList+="uniform sampler2D "+uTexUnitPrefix+texUnit+";\n";vsTexCoordInits+="  "+vTexCoordPrefix+texUnit+" = "+aTexCoordPrefix+texUnit+";\n";if(GLImmediate.useTextureMatrix){texUnitUniformList+="uniform mat4 "+uTexMatrixPrefix+texUnit+";\n"}}var vsFogVaryingInit=null;if(GLEmulation.fogEnabled){vsFogVaryingInit="  v_fogFragCoord = abs(ecPosition.z);\n"}var vsSource=["attribute vec4 a_position;","attribute vec4 a_color;","varying vec4 v_color;",texUnitAttribList,texUnitVaryingList,GLEmulation.fogEnabled?"varying float v_fogFragCoord;":null,"uniform mat4 u_modelView;","uniform mat4 u_projection;","void main()","{","  vec4 ecPosition = u_modelView * a_position;","  gl_Position = u_projection * ecPosition;","  v_color = a_color;",vsTexCoordInits,vsFogVaryingInit,"}",""].join("\n").replace(/\n\n+/g,"\n");this.vertexShader=GLctx.createShader(GLctx.VERTEX_SHADER);GLctx.shaderSource(this.vertexShader,vsSource);GLctx.compileShader(this.vertexShader);var fogHeaderIfNeeded=null;if(GLEmulation.fogEnabled){fogHeaderIfNeeded=["","varying float v_fogFragCoord; ","uniform vec4 u_fogColor;      ","uniform float u_fogEnd;       ","uniform float u_fogScale;     ","uniform float u_fogDensity;   ","float ffog(in float ecDistance) { ",fogFormula,"  fog = clamp(fog, 0.0, 1.0); ","  return fog;                 ","}",""].join("\n")}var fogPass=null;if(GLEmulation.fogEnabled){fogPass="gl_FragColor = vec4(mix(u_fogColor.rgb, gl_FragColor.rgb, ffog(v_fogFragCoord)), gl_FragColor.a);\n"}var fsSource=["precision mediump float;",texUnitVaryingList,texUnitUniformList,"varying vec4 v_color;",fogHeaderIfNeeded,"void main()","{",fsTexEnvPass,fogPass,"}",""].join("\n").replace(/\n\n+/g,"\n");this.fragmentShader=GLctx.createShader(GLctx.FRAGMENT_SHADER);GLctx.shaderSource(this.fragmentShader,fsSource);GLctx.compileShader(this.fragmentShader);this.program=GLctx.createProgram();GLctx.attachShader(this.program,this.vertexShader);GLctx.attachShader(this.program,this.fragmentShader);GLctx.bindAttribLocation(this.program,GLImmediate.VERTEX,"a_position");GLctx.bindAttribLocation(this.program,GLImmediate.COLOR,"a_color");GLctx.bindAttribLocation(this.program,GLImmediate.NORMAL,"a_normal");var maxVertexAttribs=GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);for(var i=0;i<GLImmediate.MAX_TEXTURES&&GLImmediate.TEXTURE0+i<maxVertexAttribs;i++){GLctx.bindAttribLocation(this.program,GLImmediate.TEXTURE0+i,"a_texCoord"+i);GLctx.bindAttribLocation(this.program,GLImmediate.TEXTURE0+i,aTexCoordPrefix+i)}GLctx.linkProgram(this.program)}this.textureMatrixVersion=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];this.positionLocation=GLctx.getAttribLocation(this.program,"a_position");this.texCoordLocations=[];for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){if(!GLImmediate.enabledClientAttributes[GLImmediate.TEXTURE0+i]){this.texCoordLocations[i]=-1;continue}if(useCurrProgram){this.texCoordLocations[i]=GLctx.getAttribLocation(this.program,"a_texCoord"+i)}else{this.texCoordLocations[i]=GLctx.getAttribLocation(this.program,aTexCoordPrefix+i)}}this.colorLocation=GLctx.getAttribLocation(this.program,"a_color");if(!useCurrProgram){var prevBoundProg=GLctx.getParameter(GLctx.CURRENT_PROGRAM);GLctx.useProgram(this.program);{for(var i=0;i<this.usedTexUnitList.length;i++){var texUnitID=this.usedTexUnitList[i];var texSamplerLoc=GLctx.getUniformLocation(this.program,uTexUnitPrefix+texUnitID);GLctx.uniform1i(texSamplerLoc,texUnitID)}}GLctx.vertexAttrib4fv(this.colorLocation,[1,1,1,1]);GLctx.useProgram(prevBoundProg)}this.textureMatrixLocations=[];for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){this.textureMatrixLocations[i]=GLctx.getUniformLocation(this.program,"u_textureMatrix"+i)}this.normalLocation=GLctx.getAttribLocation(this.program,"a_normal");this.modelViewLocation=GLctx.getUniformLocation(this.program,"u_modelView");this.projectionLocation=GLctx.getUniformLocation(this.program,"u_projection");this.hasTextures=hasTextures;this.hasNormal=GLImmediate.enabledClientAttributes[GLImmediate.NORMAL]&&GLImmediate.clientAttributes[GLImmediate.NORMAL].size>0&&this.normalLocation>=0;this.hasColor=this.colorLocation===0||this.colorLocation>0;this.floatType=GLctx.FLOAT;this.fogColorLocation=GLctx.getUniformLocation(this.program,"u_fogColor");this.fogEndLocation=GLctx.getUniformLocation(this.program,"u_fogEnd");this.fogScaleLocation=GLctx.getUniformLocation(this.program,"u_fogScale");this.fogDensityLocation=GLctx.getUniformLocation(this.program,"u_fogDensity");this.hasFog=!!(this.fogColorLocation||this.fogEndLocation||this.fogScaleLocation||this.fogDensityLocation)},prepare:function prepare(){var arrayBuffer;if(!GL.currArrayBuffer){var start=GLImmediate.firstVertex*GLImmediate.stride;var end=GLImmediate.lastVertex*GLImmediate.stride;arrayBuffer=GL.getTempVertexBuffer(end)}else{arrayBuffer=GL.currArrayBuffer}var lastRenderer=GLImmediate.lastRenderer;var canSkip=this==lastRenderer&&arrayBuffer==GLImmediate.lastArrayBuffer&&(GL.currProgram||this.program)==GLImmediate.lastProgram&&GLImmediate.stride==GLImmediate.lastStride&&!GLImmediate.matricesModified;if(!canSkip&&lastRenderer)lastRenderer.cleanup();if(!GL.currArrayBuffer){if(arrayBuffer!=GLImmediate.lastArrayBuffer){GLctx.bindBuffer(GLctx.ARRAY_BUFFER,arrayBuffer);GLImmediate.lastArrayBuffer=arrayBuffer}GLctx.bufferSubData(GLctx.ARRAY_BUFFER,start,GLImmediate.vertexData.subarray(start>>2,end>>2))}if(canSkip)return;GLImmediate.lastRenderer=this;GLImmediate.lastProgram=GL.currProgram||this.program;GLImmediate.lastStride==GLImmediate.stride;GLImmediate.matricesModified=false;if(!GL.currProgram){if(GLImmediate.fixedFunctionProgram!=this.program){GLctx.useProgram(this.program);GLImmediate.fixedFunctionProgram=this.program}}if(this.modelViewLocation&&this.modelViewMatrixVersion!=GLImmediate.matrixVersion[0]){this.modelViewMatrixVersion=GLImmediate.matrixVersion[0];GLctx.uniformMatrix4fv(this.modelViewLocation,false,GLImmediate.matrix[0])}if(this.projectionLocation&&this.projectionMatrixVersion!=GLImmediate.matrixVersion[1]){this.projectionMatrixVersion=GLImmediate.matrixVersion[1];GLctx.uniformMatrix4fv(this.projectionLocation,false,GLImmediate.matrix[1])}var clientAttributes=GLImmediate.clientAttributes;var posAttr=clientAttributes[GLImmediate.VERTEX];GLctx.vertexAttribPointer(this.positionLocation,posAttr.size,posAttr.type,false,GLImmediate.stride,posAttr.offset);GLctx.enableVertexAttribArray(this.positionLocation);if(this.hasNormal){var normalAttr=clientAttributes[GLImmediate.NORMAL];GLctx.vertexAttribPointer(this.normalLocation,normalAttr.size,normalAttr.type,true,GLImmediate.stride,normalAttr.offset);GLctx.enableVertexAttribArray(this.normalLocation)}if(this.hasTextures){for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var attribLoc=this.texCoordLocations[i];if(attribLoc===undefined||attribLoc<0)continue;var texAttr=clientAttributes[GLImmediate.TEXTURE0+i];if(texAttr.size){GLctx.vertexAttribPointer(attribLoc,texAttr.size,texAttr.type,false,GLImmediate.stride,texAttr.offset);GLctx.enableVertexAttribArray(attribLoc)}else{GLctx.vertexAttrib4f(attribLoc,0,0,0,1);GLctx.disableVertexAttribArray(attribLoc)}var t=2+i;if(this.textureMatrixLocations[i]&&this.textureMatrixVersion[t]!=GLImmediate.matrixVersion[t]){this.textureMatrixVersion[t]=GLImmediate.matrixVersion[t];GLctx.uniformMatrix4fv(this.textureMatrixLocations[i],false,GLImmediate.matrix[t])}}}if(GLImmediate.enabledClientAttributes[GLImmediate.COLOR]){var colorAttr=clientAttributes[GLImmediate.COLOR];GLctx.vertexAttribPointer(this.colorLocation,colorAttr.size,colorAttr.type,true,GLImmediate.stride,colorAttr.offset);GLctx.enableVertexAttribArray(this.colorLocation)}else if(this.hasColor){GLctx.disableVertexAttribArray(this.colorLocation);GLctx.vertexAttrib4fv(this.colorLocation,GLImmediate.clientColor)}if(this.hasFog){if(this.fogColorLocation)GLctx.uniform4fv(this.fogColorLocation,GLEmulation.fogColor);if(this.fogEndLocation)GLctx.uniform1f(this.fogEndLocation,GLEmulation.fogEnd);if(this.fogScaleLocation)GLctx.uniform1f(this.fogScaleLocation,1/(GLEmulation.fogEnd-GLEmulation.fogStart));if(this.fogDensityLocation)GLctx.uniform1f(this.fogDensityLocation,GLEmulation.fogDensity)}},cleanup:function cleanup(){GLctx.disableVertexAttribArray(this.positionLocation);if(this.hasTextures){for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){if(GLImmediate.enabledClientAttributes[GLImmediate.TEXTURE0+i]&&this.texCoordLocations[i]>=0){GLctx.disableVertexAttribArray(this.texCoordLocations[i])}}}if(this.hasColor){GLctx.disableVertexAttribArray(this.colorLocation)}if(this.hasNormal){GLctx.disableVertexAttribArray(this.normalLocation)}if(!GL.currProgram){GLctx.useProgram(null);GLImmediate.fixedFunctionProgram=0}if(!GL.currArrayBuffer){GLctx.bindBuffer(GLctx.ARRAY_BUFFER,null);GLImmediate.lastArrayBuffer=null}GLImmediate.lastRenderer=null;GLImmediate.lastProgram=null;GLImmediate.matricesModified=true}};ret.init();return ret},setupFuncs:(function(){_glDrawArrays=_emscripten_glDrawArrays=function _glDrawArrays(mode,first,count){if(GLImmediate.totalEnabledClientAttributes==0&&mode<=6){GLctx.drawArrays(mode,first,count);return}GLImmediate.prepareClientAttributes(count,false);GLImmediate.mode=mode;if(!GL.currArrayBuffer){GLImmediate.vertexData=HEAPF32.subarray(GLImmediate.vertexPointer>>2,GLImmediate.vertexPointer+(first+count)*GLImmediate.stride>>2);GLImmediate.firstVertex=first;GLImmediate.lastVertex=first+count}GLImmediate.flush(null,first);GLImmediate.mode=-1};_glDrawElements=_emscripten_glDrawElements=function _glDrawElements(mode,count,type,indices,start,end){if(GLImmediate.totalEnabledClientAttributes==0&&mode<=6&&GL.currElementArrayBuffer){GLctx.drawElements(mode,count,type,indices);return}GLImmediate.prepareClientAttributes(count,false);GLImmediate.mode=mode;if(!GL.currArrayBuffer){GLImmediate.firstVertex=end?start:TOTAL_MEMORY;GLImmediate.lastVertex=end?end+1:0;GLImmediate.vertexData=HEAPF32.subarray(GLImmediate.vertexPointer>>2,(end?GLImmediate.vertexPointer+(end+1)*GLImmediate.stride:TOTAL_MEMORY)>>2)}GLImmediate.flush(count,0,indices);GLImmediate.mode=-1};GLImmediate.MapTreeLib=GLImmediate.spawnMapTreeLib();GLImmediate.spawnMapTreeLib=null;GLImmediate.TexEnvJIT=GLImmediate.spawnTexEnvJIT();GLImmediate.spawnTexEnvJIT=null;GLImmediate.setupHooks()}),setupHooks:(function(){if(!GLEmulation.hasRunInit){GLEmulation.init()}var glActiveTexture=_glActiveTexture;_glActiveTexture=_emscripten_glActiveTexture=function _glActiveTexture(texture){GLImmediate.TexEnvJIT.hook_activeTexture(texture);glActiveTexture(texture)};var glEnable=_glEnable;_glEnable=_emscripten_glEnable=function _glEnable(cap){GLImmediate.TexEnvJIT.hook_enable(cap);glEnable(cap)};var glDisable=_glDisable;_glDisable=_emscripten_glDisable=function _glDisable(cap){GLImmediate.TexEnvJIT.hook_disable(cap);glDisable(cap)};var glTexEnvf=typeof _glTexEnvf!="undefined"?_glTexEnvf:(function(){});_glTexEnvf=_emscripten_glTexEnvf=function _glTexEnvf(target,pname,param){GLImmediate.TexEnvJIT.hook_texEnvf(target,pname,param)};var glTexEnvi=typeof _glTexEnvi!="undefined"?_glTexEnvi:(function(){});_glTexEnvi=_emscripten_glTexEnvi=function _glTexEnvi(target,pname,param){GLImmediate.TexEnvJIT.hook_texEnvi(target,pname,param)};var glTexEnvfv=typeof _glTexEnvfv!="undefined"?_glTexEnvfv:(function(){});_glTexEnvfv=_emscripten_glTexEnvfv=function _glTexEnvfv(target,pname,param){GLImmediate.TexEnvJIT.hook_texEnvfv(target,pname,param)};_glGetTexEnviv=function _glGetTexEnviv(target,pname,param){GLImmediate.TexEnvJIT.hook_getTexEnviv(target,pname,param)};_glGetTexEnvfv=function _glGetTexEnvfv(target,pname,param){GLImmediate.TexEnvJIT.hook_getTexEnvfv(target,pname,param)};var glGetIntegerv=_glGetIntegerv;_glGetIntegerv=_emscripten_glGetIntegerv=function _glGetIntegerv(pname,params){switch(pname){case 35725:{var cur=GLctx.getParameter(GLctx.CURRENT_PROGRAM);if(cur==GLImmediate.fixedFunctionProgram){HEAP32[params>>2]=0;return}break}}glGetIntegerv(pname,params)}}),initted:false,init:(function(){Module.printErr("WARNING: using emscripten GL immediate mode emulation. This is very limited in what it supports");GLImmediate.initted=true;if(!Module.useWebGL)return;GLImmediate.MAX_TEXTURES=Module["GL_MAX_TEXTURE_IMAGE_UNITS"]||GLctx.getParameter(GLctx.MAX_TEXTURE_IMAGE_UNITS);GLImmediate.TexEnvJIT.init(GLctx,GLImmediate.MAX_TEXTURES);GLImmediate.NUM_ATTRIBUTES=3+GLImmediate.MAX_TEXTURES;GLImmediate.clientAttributes=[];GLEmulation.enabledClientAttribIndices=[];for(var i=0;i<GLImmediate.NUM_ATTRIBUTES;i++){GLImmediate.clientAttributes.push({});GLEmulation.enabledClientAttribIndices.push(false)}GLImmediate.matrix=[];GLImmediate.matrixStack=[];GLImmediate.matrixVersion=[];for(var i=0;i<2+GLImmediate.MAX_TEXTURES;i++){GLImmediate.matrixStack.push([]);GLImmediate.matrixVersion.push(0);GLImmediate.matrix.push(GLImmediate.matrixLib.mat4.create());GLImmediate.matrixLib.mat4.identity(GLImmediate.matrix[i])}GLImmediate.rendererCache=GLImmediate.MapTreeLib.create();GLImmediate.tempData=new Float32Array(GL.MAX_TEMP_BUFFER_SIZE>>2);GLImmediate.indexData=new Uint16Array(GL.MAX_TEMP_BUFFER_SIZE>>1);GLImmediate.vertexDataU8=new Uint8Array(GLImmediate.tempData.buffer);GL.generateTempBuffers(true);GLImmediate.clientColor=new Float32Array([1,1,1,1])}),prepareClientAttributes:function prepareClientAttributes(count,beginEnd){if(!GLImmediate.modifiedClientAttributes){GLImmediate.vertexCounter=GLImmediate.stride*count/4;return}GLImmediate.modifiedClientAttributes=false;var clientStartPointer=2147483647;var bytes=0;var minStride=2147483647;var maxStride=0;var attributes=GLImmediate.liveClientAttributes;attributes.length=0;for(var i=0;i<3+GLImmediate.MAX_TEXTURES;i++){if(GLImmediate.enabledClientAttributes[i]){var attr=GLImmediate.clientAttributes[i];attributes.push(attr);clientStartPointer=Math.min(clientStartPointer,attr.pointer);attr.sizeBytes=attr.size*GL.byteSizeByType[attr.type-GL.byteSizeByTypeRoot];bytes+=attr.sizeBytes;minStride=Math.min(minStride,attr.stride);maxStride=Math.max(maxStride,attr.stride)}}if((minStride!=maxStride||maxStride<bytes)&&!beginEnd){if(!GLImmediate.restrideBuffer)GLImmediate.restrideBuffer=_malloc(GL.MAX_TEMP_BUFFER_SIZE);var start=GLImmediate.restrideBuffer;bytes=0;for(var i=0;i<attributes.length;i++){var attr=attributes[i];var size=attr.sizeBytes;if(size%4!=0)size+=4-size%4;attr.offset=bytes;bytes+=size}for(var i=0;i<attributes.length;i++){var attr=attributes[i];var srcStride=Math.max(attr.sizeBytes,attr.stride);if((srcStride&3)==0&&(attr.sizeBytes&3)==0){var size4=attr.sizeBytes>>2;var srcStride4=Math.max(attr.sizeBytes,attr.stride)>>2;for(var j=0;j<count;j++){for(var k=0;k<size4;k++){HEAP32[(start+attr.offset+bytes*j>>2)+k]=HEAP32[(attr.pointer>>2)+j*srcStride4+k]}}}else{for(var j=0;j<count;j++){for(var k=0;k<attr.sizeBytes;k++){HEAP8[start+attr.offset+bytes*j+k]=HEAP8[attr.pointer+j*srcStride+k]}}}attr.pointer=start+attr.offset}GLImmediate.stride=bytes;GLImmediate.vertexPointer=start}else{if(GL.currArrayBuffer){GLImmediate.vertexPointer=0}else{GLImmediate.vertexPointer=clientStartPointer}for(var i=0;i<attributes.length;i++){var attr=attributes[i];attr.offset=attr.pointer-GLImmediate.vertexPointer}GLImmediate.stride=Math.max(maxStride,bytes)}if(!beginEnd){GLImmediate.vertexCounter=GLImmediate.stride*count/4}},flush:function flush(numProvidedIndexes,startIndex,ptr){startIndex=startIndex||0;ptr=ptr||0;var renderer=GLImmediate.getRenderer();var numVertexes=4*GLImmediate.vertexCounter/GLImmediate.stride;var emulatedElementArrayBuffer=false;var numIndexes=0;if(numProvidedIndexes){numIndexes=numProvidedIndexes;if(!GL.currArrayBuffer&&GLImmediate.firstVertex>GLImmediate.lastVertex){for(var i=0;i<numProvidedIndexes;i++){var currIndex=HEAPU16[ptr+i*2>>1];GLImmediate.firstVertex=Math.min(GLImmediate.firstVertex,currIndex);GLImmediate.lastVertex=Math.max(GLImmediate.lastVertex,currIndex+1)}}if(!GL.currElementArrayBuffer){var indexBuffer=GL.getTempIndexBuffer(numProvidedIndexes<<1);GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,indexBuffer);GLctx.bufferSubData(GLctx.ELEMENT_ARRAY_BUFFER,0,HEAPU16.subarray(ptr>>1,ptr+(numProvidedIndexes<<1)>>1));ptr=0;emulatedElementArrayBuffer=true}}else if(GLImmediate.mode>6){if(GLImmediate.mode!=7)throw"unsupported immediate mode "+GLImmediate.mode;ptr=GLImmediate.firstVertex*3;var numQuads=numVertexes/4;numIndexes=numQuads*6;GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.tempQuadIndexBuffer);emulatedElementArrayBuffer=true}renderer.prepare();if(numIndexes){GLctx.drawElements(GLctx.TRIANGLES,numIndexes,GLctx.UNSIGNED_SHORT,ptr)}else{GLctx.drawArrays(GLImmediate.mode,startIndex,numVertexes)}if(emulatedElementArrayBuffer){GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.buffers[GL.currElementArrayBuffer]||null)}}};GLImmediate.matrixLib=(function(){var vec3={};var mat3={};var mat4={};var quat4={};var MatrixArray=Float32Array;vec3.create=(function(vec){var dest=new MatrixArray(3);if(vec){dest[0]=vec[0];dest[1]=vec[1];dest[2]=vec[2]}else{dest[0]=dest[1]=dest[2]=0}return dest});vec3.set=(function(vec,dest){dest[0]=vec[0];dest[1]=vec[1];dest[2]=vec[2];return dest});vec3.add=(function(vec,vec2,dest){if(!dest||vec===dest){vec[0]+=vec2[0];vec[1]+=vec2[1];vec[2]+=vec2[2];return vec}dest[0]=vec[0]+vec2[0];dest[1]=vec[1]+vec2[1];dest[2]=vec[2]+vec2[2];return dest});vec3.subtract=(function(vec,vec2,dest){if(!dest||vec===dest){vec[0]-=vec2[0];vec[1]-=vec2[1];vec[2]-=vec2[2];return vec}dest[0]=vec[0]-vec2[0];dest[1]=vec[1]-vec2[1];dest[2]=vec[2]-vec2[2];return dest});vec3.multiply=(function(vec,vec2,dest){if(!dest||vec===dest){vec[0]*=vec2[0];vec[1]*=vec2[1];vec[2]*=vec2[2];return vec}dest[0]=vec[0]*vec2[0];dest[1]=vec[1]*vec2[1];dest[2]=vec[2]*vec2[2];return dest});vec3.negate=(function(vec,dest){if(!dest){dest=vec}dest[0]=-vec[0];dest[1]=-vec[1];dest[2]=-vec[2];return dest});vec3.scale=(function(vec,val,dest){if(!dest||vec===dest){vec[0]*=val;vec[1]*=val;vec[2]*=val;return vec}dest[0]=vec[0]*val;dest[1]=vec[1]*val;dest[2]=vec[2]*val;return dest});vec3.normalize=(function(vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],len=Math.sqrt(x*x+y*y+z*z);if(!len){dest[0]=0;dest[1]=0;dest[2]=0;return dest}else if(len===1){dest[0]=x;dest[1]=y;dest[2]=z;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;return dest});vec3.cross=(function(vec,vec2,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],x2=vec2[0],y2=vec2[1],z2=vec2[2];dest[0]=y*z2-z*y2;dest[1]=z*x2-x*z2;dest[2]=x*y2-y*x2;return dest});vec3.length=(function(vec){var x=vec[0],y=vec[1],z=vec[2];return Math.sqrt(x*x+y*y+z*z)});vec3.dot=(function(vec,vec2){return vec[0]*vec2[0]+vec[1]*vec2[1]+vec[2]*vec2[2]});vec3.direction=(function(vec,vec2,dest){if(!dest){dest=vec}var x=vec[0]-vec2[0],y=vec[1]-vec2[1],z=vec[2]-vec2[2],len=Math.sqrt(x*x+y*y+z*z);if(!len){dest[0]=0;dest[1]=0;dest[2]=0;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;return dest});vec3.lerp=(function(vec,vec2,lerp,dest){if(!dest){dest=vec}dest[0]=vec[0]+lerp*(vec2[0]-vec[0]);dest[1]=vec[1]+lerp*(vec2[1]-vec[1]);dest[2]=vec[2]+lerp*(vec2[2]-vec[2]);return dest});vec3.dist=(function(vec,vec2){var x=vec2[0]-vec[0],y=vec2[1]-vec[1],z=vec2[2]-vec[2];return Math.sqrt(x*x+y*y+z*z)});vec3.unproject=(function(vec,view,proj,viewport,dest){if(!dest){dest=vec}var m=mat4.create();var v=new MatrixArray(4);v[0]=(vec[0]-viewport[0])*2/viewport[2]-1;v[1]=(vec[1]-viewport[1])*2/viewport[3]-1;v[2]=2*vec[2]-1;v[3]=1;mat4.multiply(proj,view,m);if(!mat4.inverse(m)){return null}mat4.multiplyVec4(m,v);if(v[3]===0){return null}dest[0]=v[0]/v[3];dest[1]=v[1]/v[3];dest[2]=v[2]/v[3];return dest});vec3.str=(function(vec){return"["+vec[0]+", "+vec[1]+", "+vec[2]+"]"});mat3.create=(function(mat){var dest=new MatrixArray(9);if(mat){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8]}return dest});mat3.set=(function(mat,dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];return dest});mat3.identity=(function(dest){if(!dest){dest=mat3.create()}dest[0]=1;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=1;dest[5]=0;dest[6]=0;dest[7]=0;dest[8]=1;return dest});mat3.transpose=(function(mat,dest){if(!dest||mat===dest){var a01=mat[1],a02=mat[2],a12=mat[5];mat[1]=mat[3];mat[2]=mat[6];mat[3]=a01;mat[5]=mat[7];mat[6]=a02;mat[7]=a12;return mat}dest[0]=mat[0];dest[1]=mat[3];dest[2]=mat[6];dest[3]=mat[1];dest[4]=mat[4];dest[5]=mat[7];dest[6]=mat[2];dest[7]=mat[5];dest[8]=mat[8];return dest});mat3.toMat4=(function(mat,dest){if(!dest){dest=mat4.create()}dest[15]=1;dest[14]=0;dest[13]=0;dest[12]=0;dest[11]=0;dest[10]=mat[8];dest[9]=mat[7];dest[8]=mat[6];dest[7]=0;dest[6]=mat[5];dest[5]=mat[4];dest[4]=mat[3];dest[3]=0;dest[2]=mat[2];dest[1]=mat[1];dest[0]=mat[0];return dest});mat3.str=(function(mat){return"["+mat[0]+", "+mat[1]+", "+mat[2]+", "+mat[3]+", "+mat[4]+", "+mat[5]+", "+mat[6]+", "+mat[7]+", "+mat[8]+"]"});mat4.create=(function(mat){var dest=new MatrixArray(16);if(mat){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}return dest});mat4.set=(function(mat,dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15];return dest});mat4.identity=(function(dest){if(!dest){dest=mat4.create()}dest[0]=1;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=1;dest[6]=0;dest[7]=0;dest[8]=0;dest[9]=0;dest[10]=1;dest[11]=0;dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest});mat4.transpose=(function(mat,dest){if(!dest||mat===dest){var a01=mat[1],a02=mat[2],a03=mat[3],a12=mat[6],a13=mat[7],a23=mat[11];mat[1]=mat[4];mat[2]=mat[8];mat[3]=mat[12];mat[4]=a01;mat[6]=mat[9];mat[7]=mat[13];mat[8]=a02;mat[9]=a12;mat[11]=mat[14];mat[12]=a03;mat[13]=a13;mat[14]=a23;return mat}dest[0]=mat[0];dest[1]=mat[4];dest[2]=mat[8];dest[3]=mat[12];dest[4]=mat[1];dest[5]=mat[5];dest[6]=mat[9];dest[7]=mat[13];dest[8]=mat[2];dest[9]=mat[6];dest[10]=mat[10];dest[11]=mat[14];dest[12]=mat[3];dest[13]=mat[7];dest[14]=mat[11];dest[15]=mat[15];return dest});mat4.determinant=(function(mat){var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15];return a30*a21*a12*a03-a20*a31*a12*a03-a30*a11*a22*a03+a10*a31*a22*a03+a20*a11*a32*a03-a10*a21*a32*a03-a30*a21*a02*a13+a20*a31*a02*a13+a30*a01*a22*a13-a00*a31*a22*a13-a20*a01*a32*a13+a00*a21*a32*a13+a30*a11*a02*a23-a10*a31*a02*a23-a30*a01*a12*a23+a00*a31*a12*a23+a10*a01*a32*a23-a00*a11*a32*a23-a20*a11*a02*a33+a10*a21*a02*a33+a20*a01*a12*a33-a00*a21*a12*a33-a10*a01*a22*a33+a00*a11*a22*a33});mat4.inverse=(function(mat,dest){if(!dest){dest=mat}var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15],b00=a00*a11-a01*a10,b01=a00*a12-a02*a10,b02=a00*a13-a03*a10,b03=a01*a12-a02*a11,b04=a01*a13-a03*a11,b05=a02*a13-a03*a12,b06=a20*a31-a21*a30,b07=a20*a32-a22*a30,b08=a20*a33-a23*a30,b09=a21*a32-a22*a31,b10=a21*a33-a23*a31,b11=a22*a33-a23*a32,d=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06,invDet;if(!d){return null}invDet=1/d;dest[0]=(a11*b11-a12*b10+a13*b09)*invDet;dest[1]=(-a01*b11+a02*b10-a03*b09)*invDet;dest[2]=(a31*b05-a32*b04+a33*b03)*invDet;dest[3]=(-a21*b05+a22*b04-a23*b03)*invDet;dest[4]=(-a10*b11+a12*b08-a13*b07)*invDet;dest[5]=(a00*b11-a02*b08+a03*b07)*invDet;dest[6]=(-a30*b05+a32*b02-a33*b01)*invDet;dest[7]=(a20*b05-a22*b02+a23*b01)*invDet;dest[8]=(a10*b10-a11*b08+a13*b06)*invDet;dest[9]=(-a00*b10+a01*b08-a03*b06)*invDet;dest[10]=(a30*b04-a31*b02+a33*b00)*invDet;dest[11]=(-a20*b04+a21*b02-a23*b00)*invDet;dest[12]=(-a10*b09+a11*b07-a12*b06)*invDet;dest[13]=(a00*b09-a01*b07+a02*b06)*invDet;dest[14]=(-a30*b03+a31*b01-a32*b00)*invDet;dest[15]=(a20*b03-a21*b01+a22*b00)*invDet;return dest});mat4.toRotationMat=(function(mat,dest){if(!dest){dest=mat4.create()}dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest});mat4.toMat3=(function(mat,dest){if(!dest){dest=mat3.create()}dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[4];dest[4]=mat[5];dest[5]=mat[6];dest[6]=mat[8];dest[7]=mat[9];dest[8]=mat[10];return dest});mat4.toInverseMat3=(function(mat,dest){var a00=mat[0],a01=mat[1],a02=mat[2],a10=mat[4],a11=mat[5],a12=mat[6],a20=mat[8],a21=mat[9],a22=mat[10],b01=a22*a11-a12*a21,b11=-a22*a10+a12*a20,b21=a21*a10-a11*a20,d=a00*b01+a01*b11+a02*b21,id;if(!d){return null}id=1/d;if(!dest){dest=mat3.create()}dest[0]=b01*id;dest[1]=(-a22*a01+a02*a21)*id;dest[2]=(a12*a01-a02*a11)*id;dest[3]=b11*id;dest[4]=(a22*a00-a02*a20)*id;dest[5]=(-a12*a00+a02*a10)*id;dest[6]=b21*id;dest[7]=(-a21*a00+a01*a20)*id;dest[8]=(a11*a00-a01*a10)*id;return dest});mat4.multiply=(function(mat,mat2,dest){if(!dest){dest=mat}var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15],b00=mat2[0],b01=mat2[1],b02=mat2[2],b03=mat2[3],b10=mat2[4],b11=mat2[5],b12=mat2[6],b13=mat2[7],b20=mat2[8],b21=mat2[9],b22=mat2[10],b23=mat2[11],b30=mat2[12],b31=mat2[13],b32=mat2[14],b33=mat2[15];dest[0]=b00*a00+b01*a10+b02*a20+b03*a30;dest[1]=b00*a01+b01*a11+b02*a21+b03*a31;dest[2]=b00*a02+b01*a12+b02*a22+b03*a32;dest[3]=b00*a03+b01*a13+b02*a23+b03*a33;dest[4]=b10*a00+b11*a10+b12*a20+b13*a30;dest[5]=b10*a01+b11*a11+b12*a21+b13*a31;dest[6]=b10*a02+b11*a12+b12*a22+b13*a32;dest[7]=b10*a03+b11*a13+b12*a23+b13*a33;dest[8]=b20*a00+b21*a10+b22*a20+b23*a30;dest[9]=b20*a01+b21*a11+b22*a21+b23*a31;dest[10]=b20*a02+b21*a12+b22*a22+b23*a32;dest[11]=b20*a03+b21*a13+b22*a23+b23*a33;dest[12]=b30*a00+b31*a10+b32*a20+b33*a30;dest[13]=b30*a01+b31*a11+b32*a21+b33*a31;dest[14]=b30*a02+b31*a12+b32*a22+b33*a32;dest[15]=b30*a03+b31*a13+b32*a23+b33*a33;return dest});mat4.multiplyVec3=(function(mat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2];dest[0]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12];dest[1]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13];dest[2]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14];return dest});mat4.multiplyVec4=(function(mat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],w=vec[3];dest[0]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12]*w;dest[1]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13]*w;dest[2]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14]*w;dest[3]=mat[3]*x+mat[7]*y+mat[11]*z+mat[15]*w;return dest});mat4.translate=(function(mat,vec,dest){var x=vec[0],y=vec[1],z=vec[2],a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23;if(!dest||mat===dest){mat[12]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12];mat[13]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13];mat[14]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14];mat[15]=mat[3]*x+mat[7]*y+mat[11]*z+mat[15];return mat}a00=mat[0];a01=mat[1];a02=mat[2];a03=mat[3];a10=mat[4];a11=mat[5];a12=mat[6];a13=mat[7];a20=mat[8];a21=mat[9];a22=mat[10];a23=mat[11];dest[0]=a00;dest[1]=a01;dest[2]=a02;dest[3]=a03;dest[4]=a10;dest[5]=a11;dest[6]=a12;dest[7]=a13;dest[8]=a20;dest[9]=a21;dest[10]=a22;dest[11]=a23;dest[12]=a00*x+a10*y+a20*z+mat[12];dest[13]=a01*x+a11*y+a21*z+mat[13];dest[14]=a02*x+a12*y+a22*z+mat[14];dest[15]=a03*x+a13*y+a23*z+mat[15];return dest});mat4.scale=(function(mat,vec,dest){var x=vec[0],y=vec[1],z=vec[2];if(!dest||mat===dest){mat[0]*=x;mat[1]*=x;mat[2]*=x;mat[3]*=x;mat[4]*=y;mat[5]*=y;mat[6]*=y;mat[7]*=y;mat[8]*=z;mat[9]*=z;mat[10]*=z;mat[11]*=z;return mat}dest[0]=mat[0]*x;dest[1]=mat[1]*x;dest[2]=mat[2]*x;dest[3]=mat[3]*x;dest[4]=mat[4]*y;dest[5]=mat[5]*y;dest[6]=mat[6]*y;dest[7]=mat[7]*y;dest[8]=mat[8]*z;dest[9]=mat[9]*z;dest[10]=mat[10]*z;dest[11]=mat[11]*z;dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15];return dest});mat4.rotate=(function(mat,angle,axis,dest){var x=axis[0],y=axis[1],z=axis[2],len=Math.sqrt(x*x+y*y+z*z),s,c,t,a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23,b00,b01,b02,b10,b11,b12,b20,b21,b22;if(!len){return null}if(len!==1){len=1/len;x*=len;y*=len;z*=len}s=Math.sin(angle);c=Math.cos(angle);t=1-c;a00=mat[0];a01=mat[1];a02=mat[2];a03=mat[3];a10=mat[4];a11=mat[5];a12=mat[6];a13=mat[7];a20=mat[8];a21=mat[9];a22=mat[10];a23=mat[11];b00=x*x*t+c;b01=y*x*t+z*s;b02=z*x*t-y*s;b10=x*y*t-z*s;b11=y*y*t+c;b12=z*y*t+x*s;b20=x*z*t+y*s;b21=y*z*t-x*s;b22=z*z*t+c;if(!dest){dest=mat}else if(mat!==dest){dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*b00+a10*b01+a20*b02;dest[1]=a01*b00+a11*b01+a21*b02;dest[2]=a02*b00+a12*b01+a22*b02;dest[3]=a03*b00+a13*b01+a23*b02;dest[4]=a00*b10+a10*b11+a20*b12;dest[5]=a01*b10+a11*b11+a21*b12;dest[6]=a02*b10+a12*b11+a22*b12;dest[7]=a03*b10+a13*b11+a23*b12;dest[8]=a00*b20+a10*b21+a20*b22;dest[9]=a01*b20+a11*b21+a21*b22;dest[10]=a02*b20+a12*b21+a22*b22;dest[11]=a03*b20+a13*b21+a23*b22;return dest});mat4.rotateX=(function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11];if(!dest){dest=mat}else if(mat!==dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[4]=a10*c+a20*s;dest[5]=a11*c+a21*s;dest[6]=a12*c+a22*s;dest[7]=a13*c+a23*s;dest[8]=a10*-s+a20*c;dest[9]=a11*-s+a21*c;dest[10]=a12*-s+a22*c;dest[11]=a13*-s+a23*c;return dest});mat4.rotateY=(function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11];if(!dest){dest=mat}else if(mat!==dest){dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*c+a20*-s;dest[1]=a01*c+a21*-s;dest[2]=a02*c+a22*-s;dest[3]=a03*c+a23*-s;dest[8]=a00*s+a20*c;dest[9]=a01*s+a21*c;dest[10]=a02*s+a22*c;dest[11]=a03*s+a23*c;return dest});mat4.rotateZ=(function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7];if(!dest){dest=mat}else if(mat!==dest){dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*c+a10*s;dest[1]=a01*c+a11*s;dest[2]=a02*c+a12*s;dest[3]=a03*c+a13*s;dest[4]=a00*-s+a10*c;dest[5]=a01*-s+a11*c;dest[6]=a02*-s+a12*c;dest[7]=a03*-s+a13*c;return dest});mat4.frustum=(function(left,right,bottom,top,near,far,dest){if(!dest){dest=mat4.create()}var rl=right-left,tb=top-bottom,fn=far-near;dest[0]=near*2/rl;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=near*2/tb;dest[6]=0;dest[7]=0;dest[8]=(right+left)/rl;dest[9]=(top+bottom)/tb;dest[10]=-(far+near)/fn;dest[11]=-1;dest[12]=0;dest[13]=0;dest[14]=-(far*near*2)/fn;dest[15]=0;return dest});mat4.perspective=(function(fovy,aspect,near,far,dest){var top=near*Math.tan(fovy*Math.PI/360),right=top*aspect;return mat4.frustum(-right,right,-top,top,near,far,dest)});mat4.ortho=(function(left,right,bottom,top,near,far,dest){if(!dest){dest=mat4.create()}var rl=right-left,tb=top-bottom,fn=far-near;dest[0]=2/rl;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=2/tb;dest[6]=0;dest[7]=0;dest[8]=0;dest[9]=0;dest[10]=-2/fn;dest[11]=0;dest[12]=-(left+right)/rl;dest[13]=-(top+bottom)/tb;dest[14]=-(far+near)/fn;dest[15]=1;return dest});mat4.lookAt=(function(eye,center,up,dest){if(!dest){dest=mat4.create()}var x0,x1,x2,y0,y1,y2,z0,z1,z2,len,eyex=eye[0],eyey=eye[1],eyez=eye[2],upx=up[0],upy=up[1],upz=up[2],centerx=center[0],centery=center[1],centerz=center[2];if(eyex===centerx&&eyey===centery&&eyez===centerz){return mat4.identity(dest)}z0=eyex-centerx;z1=eyey-centery;z2=eyez-centerz;len=1/Math.sqrt(z0*z0+z1*z1+z2*z2);z0*=len;z1*=len;z2*=len;x0=upy*z2-upz*z1;x1=upz*z0-upx*z2;x2=upx*z1-upy*z0;len=Math.sqrt(x0*x0+x1*x1+x2*x2);if(!len){x0=0;x1=0;x2=0}else{len=1/len;x0*=len;x1*=len;x2*=len}y0=z1*x2-z2*x1;y1=z2*x0-z0*x2;y2=z0*x1-z1*x0;len=Math.sqrt(y0*y0+y1*y1+y2*y2);if(!len){y0=0;y1=0;y2=0}else{len=1/len;y0*=len;y1*=len;y2*=len}dest[0]=x0;dest[1]=y0;dest[2]=z0;dest[3]=0;dest[4]=x1;dest[5]=y1;dest[6]=z1;dest[7]=0;dest[8]=x2;dest[9]=y2;dest[10]=z2;dest[11]=0;dest[12]=-(x0*eyex+x1*eyey+x2*eyez);dest[13]=-(y0*eyex+y1*eyey+y2*eyez);dest[14]=-(z0*eyex+z1*eyey+z2*eyez);dest[15]=1;return dest});mat4.fromRotationTranslation=(function(quat,vec,dest){if(!dest){dest=mat4.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=0;dest[4]=xy-wz;dest[5]=1-(xx+zz);dest[6]=yz+wx;dest[7]=0;dest[8]=xz+wy;dest[9]=yz-wx;dest[10]=1-(xx+yy);dest[11]=0;dest[12]=vec[0];dest[13]=vec[1];dest[14]=vec[2];dest[15]=1;return dest});mat4.str=(function(mat){return"["+mat[0]+", "+mat[1]+", "+mat[2]+", "+mat[3]+", "+mat[4]+", "+mat[5]+", "+mat[6]+", "+mat[7]+", "+mat[8]+", "+mat[9]+", "+mat[10]+", "+mat[11]+", "+mat[12]+", "+mat[13]+", "+mat[14]+", "+mat[15]+"]"});quat4.create=(function(quat){var dest=new MatrixArray(4);if(quat){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3]}return dest});quat4.set=(function(quat,dest){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3];return dest});quat4.calculateW=(function(quat,dest){var x=quat[0],y=quat[1],z=quat[2];if(!dest||quat===dest){quat[3]=-Math.sqrt(Math.abs(1-x*x-y*y-z*z));return quat}dest[0]=x;dest[1]=y;dest[2]=z;dest[3]=-Math.sqrt(Math.abs(1-x*x-y*y-z*z));return dest});quat4.dot=(function(quat,quat2){return quat[0]*quat2[0]+quat[1]*quat2[1]+quat[2]*quat2[2]+quat[3]*quat2[3]});quat4.inverse=(function(quat,dest){var q0=quat[0],q1=quat[1],q2=quat[2],q3=quat[3],dot=q0*q0+q1*q1+q2*q2+q3*q3,invDot=dot?1/dot:0;if(!dest||quat===dest){quat[0]*=-invDot;quat[1]*=-invDot;quat[2]*=-invDot;quat[3]*=invDot;return quat}dest[0]=-quat[0]*invDot;dest[1]=-quat[1]*invDot;dest[2]=-quat[2]*invDot;dest[3]=quat[3]*invDot;return dest});quat4.conjugate=(function(quat,dest){if(!dest||quat===dest){quat[0]*=-1;quat[1]*=-1;quat[2]*=-1;return quat}dest[0]=-quat[0];dest[1]=-quat[1];dest[2]=-quat[2];dest[3]=quat[3];return dest});quat4.length=(function(quat){var x=quat[0],y=quat[1],z=quat[2],w=quat[3];return Math.sqrt(x*x+y*y+z*z+w*w)});quat4.normalize=(function(quat,dest){if(!dest){dest=quat}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],len=Math.sqrt(x*x+y*y+z*z+w*w);if(len===0){dest[0]=0;dest[1]=0;dest[2]=0;dest[3]=0;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;dest[3]=w*len;return dest});quat4.add=(function(quat,quat2,dest){if(!dest||quat===dest){quat[0]+=quat2[0];quat[1]+=quat2[1];quat[2]+=quat2[2];quat[3]+=quat2[3];return quat}dest[0]=quat[0]+quat2[0];dest[1]=quat[1]+quat2[1];dest[2]=quat[2]+quat2[2];dest[3]=quat[3]+quat2[3];return dest});quat4.multiply=(function(quat,quat2,dest){if(!dest){dest=quat}var qax=quat[0],qay=quat[1],qaz=quat[2],qaw=quat[3],qbx=quat2[0],qby=quat2[1],qbz=quat2[2],qbw=quat2[3];dest[0]=qax*qbw+qaw*qbx+qay*qbz-qaz*qby;dest[1]=qay*qbw+qaw*qby+qaz*qbx-qax*qbz;dest[2]=qaz*qbw+qaw*qbz+qax*qby-qay*qbx;dest[3]=qaw*qbw-qax*qbx-qay*qby-qaz*qbz;return dest});quat4.multiplyVec3=(function(quat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],qx=quat[0],qy=quat[1],qz=quat[2],qw=quat[3],ix=qw*x+qy*z-qz*y,iy=qw*y+qz*x-qx*z,iz=qw*z+qx*y-qy*x,iw=-qx*x-qy*y-qz*z;dest[0]=ix*qw+iw*-qx+iy*-qz-iz*-qy;dest[1]=iy*qw+iw*-qy+iz*-qx-ix*-qz;dest[2]=iz*qw+iw*-qz+ix*-qy-iy*-qx;return dest});quat4.scale=(function(quat,val,dest){if(!dest||quat===dest){quat[0]*=val;quat[1]*=val;quat[2]*=val;quat[3]*=val;return quat}dest[0]=quat[0]*val;dest[1]=quat[1]*val;dest[2]=quat[2]*val;dest[3]=quat[3]*val;return dest});quat4.toMat3=(function(quat,dest){if(!dest){dest=mat3.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=xy-wz;dest[4]=1-(xx+zz);dest[5]=yz+wx;dest[6]=xz+wy;dest[7]=yz-wx;dest[8]=1-(xx+yy);return dest});quat4.toMat4=(function(quat,dest){if(!dest){dest=mat4.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=0;dest[4]=xy-wz;dest[5]=1-(xx+zz);dest[6]=yz+wx;dest[7]=0;dest[8]=xz+wy;dest[9]=yz-wx;dest[10]=1-(xx+yy);dest[11]=0;dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest});quat4.slerp=(function(quat,quat2,slerp,dest){if(!dest){dest=quat}var cosHalfTheta=quat[0]*quat2[0]+quat[1]*quat2[1]+quat[2]*quat2[2]+quat[3]*quat2[3],halfTheta,sinHalfTheta,ratioA,ratioB;if(Math.abs(cosHalfTheta)>=1){if(dest!==quat){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3]}return dest}halfTheta=Math.acos(cosHalfTheta);sinHalfTheta=Math.sqrt(1-cosHalfTheta*cosHalfTheta);if(Math.abs(sinHalfTheta)<.001){dest[0]=quat[0]*.5+quat2[0]*.5;dest[1]=quat[1]*.5+quat2[1]*.5;dest[2]=quat[2]*.5+quat2[2]*.5;dest[3]=quat[3]*.5+quat2[3]*.5;return dest}ratioA=Math.sin((1-slerp)*halfTheta)/sinHalfTheta;ratioB=Math.sin(slerp*halfTheta)/sinHalfTheta;dest[0]=quat[0]*ratioA+quat2[0]*ratioB;dest[1]=quat[1]*ratioA+quat2[1]*ratioB;dest[2]=quat[2]*ratioA+quat2[2]*ratioB;dest[3]=quat[3]*ratioA+quat2[3]*ratioB;return dest});quat4.str=(function(quat){return"["+quat[0]+", "+quat[1]+", "+quat[2]+", "+quat[3]+"]"});return{vec3:vec3,mat3:mat3,mat4:mat4,quat4:quat4}})();var GLImmediateSetup={};function _glEnable(x0){GLctx.enable(x0)}function _glDisable(x0){GLctx.disable(x0)}function _glIsEnabled(x0){return GLctx.isEnabled(x0)}function _glGetBooleanv(name_,p){return GL.get(name_,p,"Boolean")}function _glGetIntegerv(name_,p){return GL.get(name_,p,"Integer")}function _glGetString(name_){if(GL.stringCache[name_])return GL.stringCache[name_];var ret;switch(name_){case 7936:case 7937:case 7938:ret=allocate(intArrayFromString(GLctx.getParameter(name_)),"i8",ALLOC_NORMAL);break;case 7939:var exts=GLctx.getSupportedExtensions();var gl_exts=[];for(i in exts){gl_exts.push(exts[i]);gl_exts.push("GL_"+exts[i])}ret=allocate(intArrayFromString(gl_exts.join(" ")),"i8",ALLOC_NORMAL);break;case 35724:ret=allocate(intArrayFromString("OpenGL ES GLSL 1.00 (WebGL)"),"i8",ALLOC_NORMAL);break;default:GL.recordError(1280);return 0}GL.stringCache[name_]=ret;return ret}function _glCreateShader(shaderType){var id=GL.getNewId(GL.shaders);GL.shaders[id]=GLctx.createShader(shaderType);return id}function _glShaderSource(shader,count,string,length){var source=GL.getSource(shader,count,string,length);GLctx.shaderSource(GL.shaders[shader],source)}function _glCompileShader(shader){GLctx.compileShader(GL.shaders[shader])}function _glAttachShader(program,shader){GLctx.attachShader(GL.programs[program],GL.shaders[shader])}function _glDetachShader(program,shader){GLctx.detachShader(GL.programs[program],GL.shaders[shader])}function _glUseProgram(program){GLctx.useProgram(program?GL.programs[program]:null)}function _glDeleteProgram(program){var program=GL.programs[program];GLctx.deleteProgram(program);program.name=0;GL.programs[program]=null;GL.programInfos[program]=null}function _glBindAttribLocation(program,index,name){name=Pointer_stringify(name);GLctx.bindAttribLocation(GL.programs[program],index,name)}function _glLinkProgram(program){GLctx.linkProgram(GL.programs[program]);GL.programInfos[program]=null;GL.populateUniformTable(program)}function _glBindBuffer(target,buffer){var bufferObj=buffer?GL.buffers[buffer]:null;if(target==GLctx.ARRAY_BUFFER){GLImmediate.lastArrayBuffer=GL.currArrayBuffer=buffer}else if(target==GLctx.ELEMENT_ARRAY_BUFFER){GL.currElementArrayBuffer=buffer}GLctx.bindBuffer(target,bufferObj)}function _glGetFloatv(name_,p){return GL.get(name_,p,"Float")}function _glHint(x0,x1){GLctx.hint(x0,x1)}function _glEnableVertexAttribArray(index){GLctx.enableVertexAttribArray(index)}function _glDisableVertexAttribArray(index){GLctx.disableVertexAttribArray(index)}function _glVertexAttribPointer(index,size,type,normalized,stride,ptr){GLctx.vertexAttribPointer(index,size,type,normalized,stride,ptr)}function _glActiveTexture(x0){GLctx.activeTexture(x0)}var GLEmulation={fogStart:0,fogEnd:1,fogDensity:1,fogColor:null,fogMode:2048,fogEnabled:false,vaos:[],currentVao:null,enabledVertexAttribArrays:{},hasRunInit:false,init:(function(){if(GLEmulation.hasRunInit){return}GLEmulation.hasRunInit=true;GLEmulation.fogColor=new Float32Array(4);Module.printErr("WARNING: using emscripten GL emulation. This is a collection of limited workarounds, do not expect it to work.");Module.printErr("WARNING: using emscripten GL emulation unsafe opts. If weirdness happens, try -s GL_UNSAFE_OPTS=0");var validCapabilities={2884:1,3042:1,3024:1,2960:1,2929:1,3089:1,32823:1,32926:1,32928:1};var glEnable=_glEnable;_glEnable=_emscripten_glEnable=function _glEnable(cap){if(GLImmediate.lastRenderer)GLImmediate.lastRenderer.cleanup();if(cap==2912){if(GLEmulation.fogEnabled!=true){GLImmediate.currentRenderer=null;GLEmulation.fogEnabled=true}return}else if(cap==3553){return}else if(!(cap in validCapabilities)){return}glEnable(cap)};var glDisable=_glDisable;_glDisable=_emscripten_glDisable=function _glDisable(cap){if(GLImmediate.lastRenderer)GLImmediate.lastRenderer.cleanup();if(cap==2912){if(GLEmulation.fogEnabled!=false){GLImmediate.currentRenderer=null;GLEmulation.fogEnabled=false}return}else if(cap==3553){return}else if(!(cap in validCapabilities)){return}glDisable(cap)};_glIsEnabled=_emscripten_glIsEnabled=function _glIsEnabled(cap){if(cap==2912){return GLEmulation.fogEnabled?1:0}else if(!(cap in validCapabilities)){return 0}return GLctx.isEnabled(cap)};var glGetBooleanv=_glGetBooleanv;_glGetBooleanv=_emscripten_glGetBooleanv=function _glGetBooleanv(pname,p){var attrib=GLEmulation.getAttributeFromCapability(pname);if(attrib!==null){var result=GLImmediate.enabledClientAttributes[attrib];HEAP8[p>>0]=result===true?1:0;return}glGetBooleanv(pname,p)};var glGetIntegerv=_glGetIntegerv;_glGetIntegerv=_emscripten_glGetIntegerv=function _glGetIntegerv(pname,params){switch(pname){case 34018:pname=GLctx.MAX_TEXTURE_IMAGE_UNITS;break;case 35658:{var result=GLctx.getParameter(GLctx.MAX_VERTEX_UNIFORM_VECTORS);HEAP32[params>>2]=result*4;return};case 35657:{var result=GLctx.getParameter(GLctx.MAX_FRAGMENT_UNIFORM_VECTORS);HEAP32[params>>2]=result*4;return};case 35659:{var result=GLctx.getParameter(GLctx.MAX_VARYING_VECTORS);HEAP32[params>>2]=result*4;return};case 34929:pname=GLctx.MAX_COMBINED_TEXTURE_IMAGE_UNITS;break;case 32890:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.size:0;return};case 32891:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.type:0;return};case 32892:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.stride:0;return};case 32897:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.size:0;return};case 32898:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.type:0;return};case 32899:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.stride:0;return};case 32904:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.size:0;return};case 32905:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.type:0;return};case 32906:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.stride:0;return}}glGetIntegerv(pname,params)};var glGetString=_glGetString;_glGetString=_emscripten_glGetString=function _glGetString(name_){if(GL.stringCache[name_])return GL.stringCache[name_];switch(name_){case 7939:var ret=allocate(intArrayFromString(GLctx.getSupportedExtensions().join(" ")+" GL_EXT_texture_env_combine GL_ARB_texture_env_crossbar GL_ATI_texture_env_combine3 GL_NV_texture_env_combine4 GL_EXT_texture_env_dot3 GL_ARB_multitexture GL_ARB_vertex_buffer_object GL_EXT_framebuffer_object GL_ARB_vertex_program GL_ARB_fragment_program GL_ARB_shading_language_100 GL_ARB_shader_objects GL_ARB_vertex_shader GL_ARB_fragment_shader GL_ARB_texture_cube_map GL_EXT_draw_range_elements"+(GL.compressionExt?" GL_ARB_texture_compression GL_EXT_texture_compression_s3tc":"")+(GL.anisotropicExt?" GL_EXT_texture_filter_anisotropic":"")),"i8",ALLOC_NORMAL);GL.stringCache[name_]=ret;return ret}return glGetString(name_)};GL.shaderInfos={};var glCreateShader=_glCreateShader;_glCreateShader=_emscripten_glCreateShader=function _glCreateShader(shaderType){var id=glCreateShader(shaderType);GL.shaderInfos[id]={type:shaderType,ftransform:false};return id};function ensurePrecision(source){if(!/precision +(low|medium|high)p +float *;/.test(source)){source="precision mediump float;\n"+source}return source}var glShaderSource=_glShaderSource;_glShaderSource=_emscripten_glShaderSource=function _glShaderSource(shader,count,string,length){var source=GL.getSource(shader,count,string,length);if(GL.shaderInfos[shader].type==GLctx.VERTEX_SHADER){var has_pm=source.search(/u_projection/)>=0;var has_mm=source.search(/u_modelView/)>=0;var has_pv=source.search(/a_position/)>=0;var need_pm=0,need_mm=0,need_pv=0;var old=source;source=source.replace(/ftransform\(\)/g,"(u_projection * u_modelView * a_position)");if(old!=source)need_pm=need_mm=need_pv=1;old=source;source=source.replace(/gl_ProjectionMatrix/g,"u_projection");if(old!=source)need_pm=1;old=source;source=source.replace(/gl_ModelViewMatrixTranspose\[2\]/g,"vec4(u_modelView[0][2], u_modelView[1][2], u_modelView[2][2], u_modelView[3][2])");if(old!=source)need_mm=1;old=source;source=source.replace(/gl_ModelViewMatrix/g,"u_modelView");if(old!=source)need_mm=1;old=source;source=source.replace(/gl_Vertex/g,"a_position");if(old!=source)need_pv=1;old=source;source=source.replace(/gl_ModelViewProjectionMatrix/g,"(u_projection * u_modelView)");if(old!=source)need_pm=need_mm=1;if(need_pv&&!has_pv)source="attribute vec4 a_position; \n"+source;if(need_mm&&!has_mm)source="uniform mat4 u_modelView; \n"+source;if(need_pm&&!has_pm)source="uniform mat4 u_projection; \n"+source;GL.shaderInfos[shader].ftransform=need_pm||need_mm||need_pv;for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var old=source;var need_vtc=source.search("v_texCoord"+i)==-1;source=source.replace(new RegExp("gl_TexCoord\\["+i+"\\]","g"),"v_texCoord"+i).replace(new RegExp("gl_MultiTexCoord"+i,"g"),"a_texCoord"+i);if(source!=old){source="attribute vec4 a_texCoord"+i+"; \n"+source;if(need_vtc){source="varying vec4 v_texCoord"+i+";   \n"+source}}old=source;source=source.replace(new RegExp("gl_TextureMatrix\\["+i+"\\]","g"),"u_textureMatrix"+i);if(source!=old){source="uniform mat4 u_textureMatrix"+i+"; \n"+source}}if(source.indexOf("gl_FrontColor")>=0){source="varying vec4 v_color; \n"+source.replace(/gl_FrontColor/g,"v_color")}if(source.indexOf("gl_Color")>=0){source="attribute vec4 a_color; \n"+source.replace(/gl_Color/g,"a_color")}if(source.indexOf("gl_Normal")>=0){source="attribute vec3 a_normal; \n"+source.replace(/gl_Normal/g,"a_normal")}if(source.indexOf("gl_FogFragCoord")>=0){source="varying float v_fogFragCoord;   \n"+source.replace(/gl_FogFragCoord/g,"v_fogFragCoord")}source=ensurePrecision(source)}else{for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var old=source;source=source.replace(new RegExp("gl_TexCoord\\["+i+"\\]","g"),"v_texCoord"+i);if(source!=old){source="varying vec4 v_texCoord"+i+";   \n"+source}}if(source.indexOf("gl_Color")>=0){source="varying vec4 v_color; \n"+source.replace(/gl_Color/g,"v_color")}if(source.indexOf("gl_Fog.color")>=0){source="uniform vec4 u_fogColor;   \n"+source.replace(/gl_Fog.color/g,"u_fogColor")}if(source.indexOf("gl_Fog.end")>=0){source="uniform float u_fogEnd;   \n"+source.replace(/gl_Fog.end/g,"u_fogEnd")}if(source.indexOf("gl_Fog.scale")>=0){source="uniform float u_fogScale;   \n"+source.replace(/gl_Fog.scale/g,"u_fogScale")}if(source.indexOf("gl_Fog.density")>=0){source="uniform float u_fogDensity;   \n"+source.replace(/gl_Fog.density/g,"u_fogDensity")}if(source.indexOf("gl_FogFragCoord")>=0){source="varying float v_fogFragCoord;   \n"+source.replace(/gl_FogFragCoord/g,"v_fogFragCoord")}source=ensurePrecision(source)}GLctx.shaderSource(GL.shaders[shader],source)};var glCompileShader=_glCompileShader;_glCompileShader=_emscripten_glCompileShader=function _glCompileShader(shader){GLctx.compileShader(GL.shaders[shader])};GL.programShaders={};var glAttachShader=_glAttachShader;_glAttachShader=_emscripten_glAttachShader=function _glAttachShader(program,shader){if(!GL.programShaders[program])GL.programShaders[program]=[];GL.programShaders[program].push(shader);glAttachShader(program,shader)};var glDetachShader=_glDetachShader;_glDetachShader=_emscripten_glDetachShader=function _glDetachShader(program,shader){var programShader=GL.programShaders[program];if(!programShader){Module.printErr("WARNING: _glDetachShader received invalid program: "+program);return}var index=programShader.indexOf(shader);programShader.splice(index,1);glDetachShader(program,shader)};var glUseProgram=_glUseProgram;_glUseProgram=_emscripten_glUseProgram=function _glUseProgram(program){if(GL.currProgram!=program){GLImmediate.currentRenderer=null;GL.currProgram=program;GLImmediate.fixedFunctionProgram=0;glUseProgram(program)}};var glDeleteProgram=_glDeleteProgram;_glDeleteProgram=_emscripten_glDeleteProgram=function _glDeleteProgram(program){glDeleteProgram(program);if(program==GL.currProgram){GLImmediate.currentRenderer=null;GL.currProgram=0}};var zeroUsedPrograms={};var glBindAttribLocation=_glBindAttribLocation;_glBindAttribLocation=_emscripten_glBindAttribLocation=function _glBindAttribLocation(program,index,name){if(index==0)zeroUsedPrograms[program]=true;glBindAttribLocation(program,index,name)};var glLinkProgram=_glLinkProgram;_glLinkProgram=_emscripten_glLinkProgram=function _glLinkProgram(program){if(!(program in zeroUsedPrograms)){GLctx.bindAttribLocation(GL.programs[program],0,"a_position")}glLinkProgram(program)};var glBindBuffer=_glBindBuffer;_glBindBuffer=_emscripten_glBindBuffer=function _glBindBuffer(target,buffer){glBindBuffer(target,buffer);if(target==GLctx.ARRAY_BUFFER){if(GLEmulation.currentVao){GLEmulation.currentVao.arrayBuffer=buffer}}else if(target==GLctx.ELEMENT_ARRAY_BUFFER){if(GLEmulation.currentVao)GLEmulation.currentVao.elementArrayBuffer=buffer}};var glGetFloatv=_glGetFloatv;_glGetFloatv=_emscripten_glGetFloatv=function _glGetFloatv(pname,params){if(pname==2982){HEAPF32.set(GLImmediate.matrix[0],params>>2)}else if(pname==2983){HEAPF32.set(GLImmediate.matrix[1],params>>2)}else if(pname==2984){HEAPF32.set(GLImmediate.matrix[2+GLImmediate.clientActiveTexture],params>>2)}else if(pname==2918){HEAPF32.set(GLEmulation.fogColor,params>>2)}else if(pname==2915){HEAPF32[params>>2]=GLEmulation.fogStart}else if(pname==2916){HEAPF32[params>>2]=GLEmulation.fogEnd}else if(pname==2914){HEAPF32[params>>2]=GLEmulation.fogDensity}else if(pname==2917){HEAPF32[params>>2]=GLEmulation.fogMode}else{glGetFloatv(pname,params)}};var glHint=_glHint;_glHint=_emscripten_glHint=function _glHint(target,mode){if(target==34031){return}glHint(target,mode)};var glEnableVertexAttribArray=_glEnableVertexAttribArray;_glEnableVertexAttribArray=_emscripten_glEnableVertexAttribArray=function _glEnableVertexAttribArray(index){glEnableVertexAttribArray(index);GLEmulation.enabledVertexAttribArrays[index]=1;if(GLEmulation.currentVao)GLEmulation.currentVao.enabledVertexAttribArrays[index]=1};var glDisableVertexAttribArray=_glDisableVertexAttribArray;_glDisableVertexAttribArray=_emscripten_glDisableVertexAttribArray=function _glDisableVertexAttribArray(index){glDisableVertexAttribArray(index);delete GLEmulation.enabledVertexAttribArrays[index];if(GLEmulation.currentVao)delete GLEmulation.currentVao.enabledVertexAttribArrays[index]};var glVertexAttribPointer=_glVertexAttribPointer;_glVertexAttribPointer=_emscripten_glVertexAttribPointer=function _glVertexAttribPointer(index,size,type,normalized,stride,pointer){glVertexAttribPointer(index,size,type,normalized,stride,pointer);if(GLEmulation.currentVao){GLEmulation.currentVao.vertexAttribPointers[index]=[index,size,type,normalized,stride,pointer]}}}),getAttributeFromCapability:(function(cap){var attrib=null;switch(cap){case 3553:case 32888:attrib=GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture;break;case 32884:attrib=GLImmediate.VERTEX;break;case 32885:attrib=GLImmediate.NORMAL;break;case 32886:attrib=GLImmediate.COLOR;break}return attrib})};function _glVertexPointer(size,type,stride,pointer){GLImmediate.setClientAttribute(GLImmediate.VERTEX,size,type,stride,pointer)}function _SDL_SetVideoMode(width,height,depth,flags){["touchstart","touchend","touchmove","mousedown","mouseup","mousemove","DOMMouseScroll","mousewheel","wheel","mouseout"].forEach((function(event){Module["canvas"].addEventListener(event,SDL.receiveEvent,true)}));var canvas=Module["canvas"];if(width==0&&height==0){width=canvas.width;height=canvas.height}if(!SDL.addedResizeListener){SDL.addedResizeListener=true;Browser.resizeListeners.push((function(w,h){if(!SDL.settingVideoMode){SDL.receiveEvent({type:"resize",w:w,h:h})}}))}if(width!==canvas.width||height!==canvas.height){SDL.settingVideoMode=true;Browser.setCanvasSize(width,height);SDL.settingVideoMode=false}if(SDL.screen){SDL.freeSurface(SDL.screen);assert(!SDL.screen)}if(SDL.GL)flags=flags|67108864;SDL.screen=SDL.makeSurface(width,height,flags,true,"screen");return SDL.screen}function _open(path,oflag,varargs){var mode=HEAP32[varargs>>2];path=Pointer_stringify(path);try{var stream=FS.open(path,oflag,mode);return stream.fd}catch(e){FS.handleFSError(e);return-1}}function _fopen(filename,mode){var flags;mode=Pointer_stringify(mode);if(mode[0]=="r"){if(mode.indexOf("+")!=-1){flags=2}else{flags=0}}else if(mode[0]=="w"){if(mode.indexOf("+")!=-1){flags=2}else{flags=1}flags|=64;flags|=512}else if(mode[0]=="a"){if(mode.indexOf("+")!=-1){flags=2}else{flags=1}flags|=64;flags|=1024}else{___setErrNo(ERRNO_CODES.EINVAL);return 0}var fd=_open(filename,flags,allocate([511,0,0,0],"i32",ALLOC_STACK));return fd===-1?0:FS.getPtrForStream(FS.getStream(fd))}function _glDrawArrays(mode,first,count){GLctx.drawArrays(mode,first,count)}Module["_strncpy"]=_strncpy;function _recv(fd,buf,len,flags){var sock=SOCKFS.getSocket(fd);if(!sock){___setErrNo(ERRNO_CODES.EBADF);return-1}return _read(fd,buf,len)}function _pread(fildes,buf,nbyte,offset){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.read(stream,slab,buf,nbyte,offset)}catch(e){FS.handleFSError(e);return-1}}function _read(fildes,buf,nbyte){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.read(stream,slab,buf,nbyte)}catch(e){FS.handleFSError(e);return-1}}function _fread(ptr,size,nitems,stream){var bytesToRead=nitems*size;if(bytesToRead==0){return 0}var bytesRead=0;var streamObj=FS.getStreamFromPtr(stream);if(!streamObj){___setErrNo(ERRNO_CODES.EBADF);return 0}while(streamObj.ungotten.length&&bytesToRead>0){HEAP8[ptr++>>0]=streamObj.ungotten.pop();bytesToRead--;bytesRead++}var err=_read(streamObj.fd,ptr,bytesToRead);if(err==-1){if(streamObj)streamObj.error=true;return 0}bytesRead+=err;if(bytesRead<bytesToRead)streamObj.eof=true;return Math.floor(bytesRead/size)}function _fgetc(stream){var streamObj=FS.getStreamFromPtr(stream);if(!streamObj)return-1;if(streamObj.eof||streamObj.error)return-1;var ret=_fread(_fgetc.ret,1,1,stream);if(ret==0){return-1}else if(ret==-1){streamObj.error=true;return-1}else{return HEAPU8[_fgetc.ret>>0]}}function _getchar(){return _fgetc(HEAP32[_stdin>>2])}function _Mix_PlayChannelTimed(){return _Mix_PlayChannel.apply(null,arguments)}function _unlink(path){path=Pointer_stringify(path);try{FS.unlink(path);return 0}catch(e){FS.handleFSError(e);return-1}}var _emscripten_postinvoke=true;function _glClear(x0){GLctx.clear(x0)}function _mknod(path,mode,dev){path=Pointer_stringify(path);switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:___setErrNo(ERRNO_CODES.EINVAL);return-1}try{FS.mknod(path,mode,dev);return 0}catch(e){FS.handleFSError(e);return-1}}function _mkdir(path,mode){path=Pointer_stringify(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);try{FS.mkdir(path,mode,0);return 0}catch(e){FS.handleFSError(e);return-1}}function __exit(status){Module["exit"](status)}function _exit(status){__exit(status)}function _SDL_GetError(){if(!SDL.errorMessage){SDL.errorMessage=allocate(intArrayFromString("unknown SDL-emscripten error"),"i8",ALLOC_NORMAL)}return SDL.errorMessage}function _emscripten_cancel_main_loop(){Browser.mainLoop.scheduler=null;Browser.mainLoop.shouldPause=true}function _Mix_Init(flags){if(!flags)return 0;return 8}function _glDeleteTextures(n,textures){for(var i=0;i<n;i++){var id=HEAP32[textures+i*4>>2];var texture=GL.textures[id];if(!texture)continue;GLctx.deleteTexture(texture);texture.name=0;GL.textures[id]=null}}function _fputs(s,stream){var fd=_fileno(stream);return _write(fd,s,_strlen(s))}function _fputc(c,stream){var chr=unSign(c&255);HEAP8[_fputc.ret>>0]=chr;var fd=_fileno(stream);var ret=_write(fd,_fputc.ret,1);if(ret==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return-1}else{return chr}}function _puts(s){var stdout=HEAP32[_stdout>>2];var ret=_fputs(s,stdout);if(ret<0){return ret}else{var newlineRet=_fputc(10,stdout);return newlineRet<0?-1:ret+1}}Module["_bitshift64Lshr"]=_bitshift64Lshr;function _Mix_OpenAudio(frequency,format,channels,chunksize){SDL.openAudioContext();SDL.allocateChannels(32);SDL.mixerFrequency=frequency;SDL.mixerFormat=format;SDL.mixerNumChannels=channels;SDL.mixerChunkSize=chunksize;return 0}var _BDtoIHigh=true;function _SDL_GL_SwapBuffers(){if(Browser.doSwapBuffers)Browser.doSwapBuffers()}function _Mix_HaltChannel(channel){function halt(channel){var info=SDL.channels[channel];if(info.audio){info.audio.pause();info.audio=null}if(SDL.channelFinished){Runtime.getFuncWrapper(SDL.channelFinished,"vi")(channel)}}if(channel!=-1){halt(channel)}else{for(var i=0;i<SDL.channels.length;++i)halt(i)}return 0}var _emscripten_resume=true;function __ZSt9terminatev(){_exit(-1234)}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=Math.floor(now/1e3);HEAP32[ptr+4>>2]=Math.floor((now-1e3*Math.floor(now/1e3))*1e3);return 0}function _glBlendFunc(x0,x1){GLctx.blendFunc(x0,x1)}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _llvm_pow_f64(){return Math_pow.apply(null,arguments)}function _chdir(path){if(typeof path!=="string")path=Pointer_stringify(path);try{FS.chdir(path);return 0}catch(e){FS.handleFSError(e);return-1}}function _Mix_Quit(){}function ___cxa_call_unexpected(exception){Module.printErr("Unexpected exception thrown, this is not properly supported - aborting");ABORT=true;throw exception}function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0)self.alloc(bytes);return ret}Module["_memmove"]=_memmove;function _glGenTextures(n,textures){for(var i=0;i<n;i++){var id=GL.getNewId(GL.textures);var texture=GLctx.createTexture();texture.name=id;GL.textures[id]=texture;HEAP32[textures+i*4>>2]=id}}function _Mix_ReserveChannels(num){SDL.channelMinimumNumber=num}function ___gxx_personality_v0(){}function _glPixelStorei(pname,param){if(pname==3333){GL.packAlignment=param}else if(pname==3317){GL.unpackAlignment=param}GLctx.pixelStorei(pname,param)}function _opendir(dirname){var path=Pointer_stringify(dirname);if(!path){___setErrNo(ERRNO_CODES.ENOENT);return 0}var node;try{var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}catch(e){FS.handleFSError(e);return 0}if(!FS.isDir(node.mode)){___setErrNo(ERRNO_CODES.ENOTDIR);return 0}var fd=_open(dirname,0,allocate([0,0,0,0],"i32",ALLOC_STACK));return fd===-1?0:FS.getPtrForStream(FS.getStream(fd))}function _modf(x,intpart){HEAPF64[intpart>>3]=Math.floor(x);return x-HEAPF64[intpart>>3]}function _ungetc(c,stream){stream=FS.getStreamFromPtr(stream);if(!stream){return-1}if(c===-1){return c}c=unSign(c&255);stream.ungotten.push(c);stream.eof=false;return c}function ___errno_location(){return ___errno_state}var ___tm_current=allocate(44,"i8",ALLOC_STATIC);var ___tm_timezone=allocate(intArrayFromString("GMT"),"i8",ALLOC_STATIC);var _tzname=allocate(8,"i32*",ALLOC_STATIC);var _daylight=allocate(1,"i32*",ALLOC_STATIC);var _timezone=allocate(1,"i32*",ALLOC_STATIC);function _tzset(){if(_tzset.called)return;_tzset.called=true;HEAP32[_timezone>>2]=-(new Date).getTimezoneOffset()*60;var winter=new Date(2e3,0,1);var summer=new Date(2e3,6,1);HEAP32[_daylight>>2]=Number(winter.getTimezoneOffset()!=summer.getTimezoneOffset());var winterName="GMT";var summerName="GMT";var winterNamePtr=allocate(intArrayFromString(winterName),"i8",ALLOC_NORMAL);var summerNamePtr=allocate(intArrayFromString(summerName),"i8",ALLOC_NORMAL);HEAP32[_tzname>>2]=winterNamePtr;HEAP32[_tzname+4>>2]=summerNamePtr}function _localtime_r(time,tmPtr){_tzset();var date=new Date(HEAP32[time>>2]*1e3);HEAP32[tmPtr>>2]=date.getSeconds();HEAP32[tmPtr+4>>2]=date.getMinutes();HEAP32[tmPtr+8>>2]=date.getHours();HEAP32[tmPtr+12>>2]=date.getDate();HEAP32[tmPtr+16>>2]=date.getMonth();HEAP32[tmPtr+20>>2]=date.getFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getDay();var start=new Date(date.getFullYear(),0,1);var yday=Math.floor((date.getTime()-start.getTime())/(1e3*60*60*24));HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+36>>2]=start.getTimezoneOffset()*60;var dst=Number(start.getTimezoneOffset()!=date.getTimezoneOffset());HEAP32[tmPtr+32>>2]=dst;HEAP32[tmPtr+40>>2]=___tm_timezone;return tmPtr}function _localtime(time){return _localtime_r(time,___tm_current)}function _emscripten_get_now(){if(!_emscripten_get_now.actual){if(ENVIRONMENT_IS_NODE){_emscripten_get_now.actual=function _emscripten_get_now_actual(){var t=process["hrtime"]();return t[0]*1e3+t[1]/1e6}}else if(typeof dateNow!=="undefined"){_emscripten_get_now.actual=dateNow}else if(ENVIRONMENT_IS_WEB&&window["performance"]&&window["performance"]["now"]){_emscripten_get_now.actual=function _emscripten_get_now_actual(){return window["performance"]["now"]()}}else{_emscripten_get_now.actual=Date.now}}return _emscripten_get_now.actual()}function _clock_gettime(clk_id,tp){var now;if(clk_id===0){now=Date.now()}else{now=_emscripten_get_now()}HEAP32[tp>>2]=Math.floor(now/1e3);HEAP32[tp+4>>2]=Math.floor(now%1e3*1e3*1e3);return 0}function _glTexImage2D(target,level,internalFormat,width,height,border,format,type,pixels){if(pixels){var data=GL.getTexPixelData(type,format,width,height,pixels,internalFormat);pixels=data.pixels;internalFormat=data.internalFormat}else{pixels=null}GLctx.texImage2D(target,level,internalFormat,width,height,border,format,type,pixels)}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 79:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}var _emscripten_preinvoke=true;Module["_memset"]=_memset;var _BDtoILow=true;Module["_strcat"]=_strcat;function _readdir_r(dirp,entry,result){var stream=FS.getStreamFromPtr(dirp);if(!stream){return ___setErrNo(ERRNO_CODES.EBADF)}var entries;try{entries=FS.readdir(stream.path)}catch(e){return FS.handleFSError(e)}if(stream.position<0||stream.position>=entries.length){HEAP32[result>>2]=0;return 0}var id;var type;var name=entries[stream.position];var offset=stream.position+1;if(!name.indexOf(".")){id=1;type=4}else{var child=FS.lookupNode(stream.node,name);id=child.id;type=FS.isChrdev(child.mode)?2:FS.isDir(child.mode)?4:FS.isLink(child.mode)?10:8}HEAP32[entry>>2]=id;HEAP32[entry+4>>2]=offset;HEAP32[entry+8>>2]=name.length+1;for(var i=0;i<name.length;i++){HEAP8[entry+11+i>>0]=name.charCodeAt(i)}HEAP8[entry+11+i>>0]=0;HEAP8[entry+10>>0]=type;HEAP32[result>>2]=entry;stream.position++;return 0}function _readdir(dirp){var stream=FS.getStreamFromPtr(dirp);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return 0}if(!_readdir.entry)_readdir.entry=_malloc(268);if(!_readdir.result)_readdir.result=_malloc(4);var err=_readdir_r(dirp,_readdir.entry,_readdir.result);if(err){___setErrNo(err);return 0}return HEAP32[_readdir.result>>2]}var _BItoD=true;Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function _tan(){return Math_tan.apply(null,arguments)}function _fabs(){return Math_abs.apply(null,arguments)}function _Mix_CloseAudio(){return _SDL_CloseAudio.apply(null,arguments)}function _srand(seed){HEAP32[___rand_seed>>2]=seed}function _sqrt(){return Math_sqrt.apply(null,arguments)}function _emscripten_asm_const_int(code){var args=Array.prototype.slice.call(arguments,1);return Runtime.getAsmConst(code,args.length).apply(null,args)|0}function _ftell(stream){stream=FS.getStreamFromPtr(stream);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}if(FS.isChrdev(stream.node.mode)){___setErrNo(ERRNO_CODES.ESPIPE);return-1}else{return stream.position}}function _glDisableClientState(cap){var attrib=GLEmulation.getAttributeFromCapability(cap);if(attrib===null){return}if(GLImmediate.enabledClientAttributes[attrib]){GLImmediate.enabledClientAttributes[attrib]=false;GLImmediate.totalEnabledClientAttributes--;GLImmediate.currentRenderer=null;if(GLEmulation.currentVao)delete GLEmulation.currentVao.enabledClientStates[cap];GLImmediate.modifiedClientAttributes=true}}function _glLoadIdentity(){GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.identity(GLImmediate.matrix[GLImmediate.currentMatrix])}function ___cxa_allocate_exception(size){var ptr=_malloc(size+___cxa_exception_header_size);return ptr+___cxa_exception_header_size}function _sin(){return Math_sin.apply(null,arguments)}function _fmod(x,y){return x%y}function _fmodl(){return _fmod.apply(null,arguments)}function _stat(path,buf,dontResolveLastLink){path=typeof path!=="string"?Pointer_stringify(path):path;try{var stat=dontResolveLastLink?FS.lstat(path):FS.stat(path);HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=Math.floor(stat.atime.getTime()/1e3);HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=Math.floor(stat.mtime.getTime()/1e3);HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=Math.floor(stat.ctime.getTime()/1e3);HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}catch(e){FS.handleFSError(e);return-1}}function _SDL_GL_SetAttribute(attr,value){if(!(attr in SDL.glAttributes)){abort("Unknown SDL GL attribute ("+attr+"). Please check if your SDL version is supported.")}SDL.glAttributes[attr]=value}function _glViewport(x0,x1,x2,x3){GLctx.viewport(x0,x1,x2,x3)}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.scheduler,"there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one, if you want to");Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();setTimeout(Browser.mainLoop.runner,0);return}if(Browser.mainLoop.shouldPause){Browser.mainLoop.paused=true;Browser.mainLoop.shouldPause=false;return}GL.newRenderingFrameStarted();if(Browser.mainLoop.method==="timeout"&&Module.ctx){Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter((function(){if(typeof arg!=="undefined"){Runtime.dynCall("vi",func,[arg])}else{Runtime.dynCall("v",func)}}));if(Browser.mainLoop.shouldPause){Browser.mainLoop.paused=true;Browser.mainLoop.shouldPause=false;return}Browser.mainLoop.scheduler()};if(fps&&fps>0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler(){setTimeout(Browser.mainLoop.runner,1e3/fps)};Browser.mainLoop.method="timeout"}else{Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}Browser.mainLoop.scheduler();if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}function _time(ptr){var ret=Math.floor(Date.now()/1e3);if(ptr){HEAP32[ptr>>2]=ret}return ret}function _getcwd(buf,size){if(size==0){___setErrNo(ERRNO_CODES.EINVAL);return 0}var cwd=FS.cwd();if(size<cwd.length+1){___setErrNo(ERRNO_CODES.ERANGE);return 0}else{writeAsciiToMemory(cwd,buf);return buf}}function _glEnableClientState(cap){var attrib=GLEmulation.getAttributeFromCapability(cap);if(attrib===null){return}if(!GLImmediate.enabledClientAttributes[attrib]){GLImmediate.enabledClientAttributes[attrib]=true;GLImmediate.totalEnabledClientAttributes++;GLImmediate.currentRenderer=null;if(GLEmulation.currentVao)GLEmulation.currentVao.enabledClientStates[cap]=1;GLImmediate.modifiedClientAttributes=true}}function _closedir(dirp){var fd=_fileno(dirp);return _close(fd)}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;___cxa_caught_exceptions.push(___cxa_last_thrown_exception);return ptr}function _llvm_eh_typeid_for(type){return type}function _log(){return Math_log.apply(null,arguments)}function _cos(){return Math_cos.apply(null,arguments)}function _glTexCoordPointer(size,type,stride,pointer){GLImmediate.setClientAttribute(GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture,size,type,stride,pointer)}function _SDL_PollEvent(ptr){return SDL.pollEvent(ptr)}function __ZNSt9exceptionD2Ev(){}function _glColorPointer(size,type,stride,pointer){GLImmediate.setClientAttribute(GLImmediate.COLOR,size,type,stride,pointer)}function _SDL_Init(initFlags){SDL.startTime=Date.now();SDL.initFlags=initFlags;if(!Module["doNotCaptureKeyboard"]){document.addEventListener("keydown",SDL.receiveEvent);document.addEventListener("keyup",SDL.receiveEvent);document.addEventListener("keypress",SDL.receiveEvent);window.addEventListener("focus",SDL.receiveEvent);window.addEventListener("blur",SDL.receiveEvent);document.addEventListener("visibilitychange",SDL.receiveEvent)}if(initFlags&512){addEventListener("gamepadconnected",(function(){}))}window.addEventListener("unload",SDL.receiveEvent);SDL.keyboardState=_malloc(65536);_memset(SDL.keyboardState,0,65536);SDL.DOMEventToSDLEvent["keydown"]=768;SDL.DOMEventToSDLEvent["keyup"]=769;SDL.DOMEventToSDLEvent["keypress"]=771;SDL.DOMEventToSDLEvent["mousedown"]=1025;SDL.DOMEventToSDLEvent["mouseup"]=1026;SDL.DOMEventToSDLEvent["mousemove"]=1024;SDL.DOMEventToSDLEvent["wheel"]=1027;SDL.DOMEventToSDLEvent["touchstart"]=1792;SDL.DOMEventToSDLEvent["touchend"]=1793;SDL.DOMEventToSDLEvent["touchmove"]=1794;SDL.DOMEventToSDLEvent["unload"]=256;SDL.DOMEventToSDLEvent["resize"]=28673;SDL.DOMEventToSDLEvent["visibilitychange"]=512;SDL.DOMEventToSDLEvent["focus"]=512;SDL.DOMEventToSDLEvent["blur"]=512;SDL.DOMEventToSDLEvent["joystick_axis_motion"]=1536;SDL.DOMEventToSDLEvent["joystick_button_down"]=1539;SDL.DOMEventToSDLEvent["joystick_button_up"]=1540;return 0}function _glTexParameteri(x0,x1,x2){GLctx.texParameteri(x0,x1,x2)}function _glMatrixMode(mode){if(mode==5888){GLImmediate.currentMatrix=0}else if(mode==5889){GLImmediate.currentMatrix=1}else if(mode==5890){GLImmediate.useTextureMatrix=true;GLImmediate.currentMatrix=2+GLImmediate.clientActiveTexture}else{throw"Wrong mode "+mode+" passed to glMatrixMode"}}function _lseek(fildes,offset,whence){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{return FS.llseek(stream,offset,whence)}catch(e){FS.handleFSError(e);return-1}}function _fseek(stream,offset,whence){var fd=_fileno(stream);var ret=_lseek(fd,offset,whence);if(ret==-1){return-1}stream=FS.getStreamFromPtr(stream);stream.eof=false;return 0}function _glOrtho(left,right,bottom,top_,nearVal,farVal){GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.multiply(GLImmediate.matrix[GLImmediate.currentMatrix],GLImmediate.matrixLib.mat4.ortho(left,right,bottom,top_,nearVal,farVal))}function _atan2(){return Math_atan2.apply(null,arguments)}Module["_strcpy"]=_strcpy;function _exp(){return Math_exp.apply(null,arguments)}function _copysign(a,b){return __reallyNegative(a)===__reallyNegative(b)?a:-a}function _copysignl(){return _copysign.apply(null,arguments)}var __ZTISt9exception=allocate([allocate([1,0,0,0,0,0,0],"i8",ALLOC_STATIC)+8,0],"i32",ALLOC_STATIC);var ___dso_handle=allocate(1,"i32*",ALLOC_STATIC);___errno_state=Runtime.staticAlloc(4);HEAP32[___errno_state>>2]=0;var GLctx;GL.init();FS.staticInit();__ATINIT__.unshift({func:(function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()})});__ATMAIN__.push({func:(function(){FS.ignorePermissions=false})});__ATEXIT__.push({func:(function(){FS.quit()})});Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;__ATINIT__.unshift({func:(function(){TTY.init()})});__ATEXIT__.push({func:(function(){TTY.shutdown()})});TTY.utf8=new Runtime.UTF8Processor;if(ENVIRONMENT_IS_NODE){var fs=require("fs");NODEFS.staticInit()}Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas){Browser.requestFullScreen(lockPointer,resizeCanvas)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};___buildEnvironment(ENV);__ATINIT__.push({func:(function(){SOCKFS.root=FS.mount(SOCKFS,{},null)})});GLEmulation.init();GLImmediate.setupFuncs();Browser.moduleContextCreatedCallbacks.push((function(){GLImmediate.init()}));_fgetc.ret=allocate([0],"i8",ALLOC_STATIC);_fputc.ret=allocate([0],"i8",ALLOC_STATIC);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+5242880;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var ctlz_i8=allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_DYNAMIC);var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);var Math_min=Math.min;function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_d(index){try{return Module["dynCall_d"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_i(index){try{return Module["dynCall_i"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_dd(index,a1){try{return Module["dynCall_dd"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function asmPrintInt(x,y){Module.print("int "+x+","+y)}function asmPrintFloat(x,y){Module.print("float "+x+","+y)}var asm=(function(global,env,buffer) {
// EMSCRIPTEN_START_ASM
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.ctlz_i8|0;var o=env.___rand_seed|0;var p=env.__ZTISt9exception|0;var q=env.___dso_handle|0;var r=env._stdin|0;var s=0;var t=0;var u=0;var v=0;var w=+env.NaN,x=+env.Infinity;var y=0,z=0,A=0,B=0,C=0.0,D=0,E=0,F=0,G=0.0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=0;var O=0;var P=0;var Q=0;var R=global.Math.floor;var S=global.Math.abs;var T=global.Math.sqrt;var U=global.Math.pow;var V=global.Math.cos;var W=global.Math.sin;var X=global.Math.tan;var Y=global.Math.acos;var Z=global.Math.asin;var _=global.Math.atan;var $=global.Math.atan2;var aa=global.Math.exp;var ba=global.Math.log;var ca=global.Math.ceil;var da=global.Math.imul;var ea=env.abort;var fa=env.assert;var ga=env.asmPrintInt;var ha=env.asmPrintFloat;var ia=env.min;var ja=env.invoke_iiii;var ka=env.invoke_d;var la=env.invoke_viiiiiii;var ma=env.invoke_viiiii;var na=env.invoke_i;var oa=env.invoke_vi;var pa=env.invoke_dd;var qa=env.invoke_vii;var ra=env.invoke_ii;var sa=env.invoke_viii;var ta=env.invoke_v;var ua=env.invoke_iiiii;var va=env.invoke_viiiiii;var wa=env.invoke_iii;var xa=env.invoke_iiiiii;var ya=env.invoke_viiii;var za=env._glUseProgram;var Aa=env._fabs;var Ba=env._exp;var Ca=env._Mix_Playing;var Da=env._fread;var Ea=env.__ZSt9terminatev;var Fa=env._fmodl;var Ga=env.___assert_fail;var Ha=env._glDeleteProgram;var Ia=env.__ZSt18uncaught_exceptionv;var Ja=env._glBindBuffer;var Ka=env._Mix_Volume;var La=env._fsync;var Ma=env._SDL_GetError;var Na=env._sbrk;var Oa=env._glBlendFunc;var Pa=env._glDisableVertexAttribArray;var Qa=env.___cxa_begin_catch;var Ra=env._glCreateShader;var Sa=env._sysconf;var Ta=env._close;var Ua=env._Mix_PlayMusic;var Va=env._cos;var Wa=env._readdir;var Xa=env._puts;var Ya=env._glLoadIdentity;var Za=env._glMatrixMode;var _a=env._write;var $a=env._ftell;var ab=env._glShaderSource;var bb=env.__ZNSt9exceptionD2Ev;var cb=env.___cxa_atexit;var db=env.___cxa_does_inherit;var eb=env._glVertexPointer;var fb=env._glOrtho;var gb=env._Mix_HaltMusic;var hb=env._mknod;var ib=env._mkdir;var jb=env._closedir;var kb=env._SDL_RWFromFile;var lb=env._glVertexAttribPointer;var mb=env._glHint;var nb=env.__reallyNegative;var ob=env._send;var pb=env._SDL_GL_SetAttribute;var qb=env._atan2;var rb=env.___cxa_is_number_type;var sb=env._Mix_CloseAudio;var tb=env.___cxa_free_exception;var ub=env.___cxa_find_matching_catch;var vb=env._opendir;var wb=env._SDL_LockSurface;var xb=env._strerror_r;var yb=env._glViewport;var zb=env._glGetBooleanv;var Ab=env.___setErrNo;var Bb=env._glDeleteTextures;var Cb=env.___resumeException;var Db=env._srand;var Eb=env.___cxa_call_unexpected;var Fb=env._glEnable;var Gb=env._printf;var Hb=env._glGenTextures;var Ib=env._glGetIntegerv;var Jb=env._glGetString;var Kb=env._localtime;var Lb=env._emscripten_get_now;var Mb=env._stat;var Nb=env._glAttachShader;var Ob=env._read;var Pb=env._clock_gettime;var Qb=env._SDL_SetVideoMode;var Rb=env._fwrite;var Sb=env._time;var Tb=env._fprintf;var Ub=env._glDetachShader;var Vb=env._gettimeofday;var Wb=env._pwrite;var Xb=env._exit;var Yb=env._readdir_r;var Zb=env._putenv;var _b=env._llvm_pow_f64;var $b=env._getcwd;var ac=env._IMG_Load;var bc=env._fmod;var cc=env._lseek;var dc=env.___cxa_allocate_exception;var ec=env._getchar;var fc=env.___buildEnvironment;var gc=env._glEnableClientState;var hc=env._chdir;var ic=env._localtime_r;var jc=env._tzset;var kc=env._open;var lc=env._glClearColor;var mc=env._glIsEnabled;var nc=env._SDL_Init;var oc=env.___cxa_end_catch;var pc=env._glGetFloatv;var qc=env._Mix_PlayChannel;var rc=env._Mix_Init;var sc=env._glDrawArrays;var tc=env._TTF_RenderText_Solid;var uc=env._fseek;var vc=env._getenv;var wc=env._fclose;var xc=env._SDL_UpperBlit;var yc=env._log;var zc=env._glActiveTexture;var Ac=env._glTexCoordPointer;var Bc=env._recv;var Cc=env._tan;var Dc=env._fgetc;var Ec=env._glCompileShader;var Fc=env._glEnableVertexAttribArray;var Gc=env._abort;var Hc=env._Mix_PlayChannelTimed;var Ic=env._glTexImage2D;var Jc=env._fopen;var Kc=env._Mix_ReserveChannels;var Lc=env._glDisableClientState;var Mc=env._Mix_LoadWAV_RW;var Nc=env._sin;var Oc=env._SDL_GetTicks;var Pc=env._SDL_CloseAudio;var Qc=env.___gxx_personality_v0;var Rc=env._emscripten_asm_const_int;var Sc=env._glTexParameteri;var Tc=env._ungetc;var Uc=env._glLinkProgram;var Vc=env._SDL_FreeRW;var Wc=env._glColorPointer;var Xc=env._SDL_PauseAudio;var Yc=env._llvm_eh_typeid_for;var Zc=env._SDL_PollEvent;var _c=env._Mix_OpenAudio;var $c=env._strerror;var ad=env._glClear;var bd=env._fileno;var cd=env._Mix_FreeChunk;var dd=env._glBindTexture;var ed=env.__exit;var fd=env._IMG_Load_RW;var gd=env._glBindAttribLocation;var hd=env._glPixelStorei;var id=env._unlink;var jd=env._fputs;var kd=env._Mix_HaltChannel;var ld=env._pread;var md=env._mkport;var nd=env._fflush;var od=env._emscripten_memcpy_big;var pd=env._emscripten_set_main_loop;var qd=env.___errno_location;var rd=env._copysign;var sd=env._fputc;var td=env.___cxa_throw;var ud=env._Mix_Quit;var vd=env._copysignl;var wd=env._SDL_GL_SwapBuffers;var xd=env._glDisable;var yd=env._modf;var zd=env._emscripten_cancel_main_loop;var Ad=env.__formatString;var Bd=env._atexit;var Cd=env._sqrt;var Dd=env._SDL_RWFromConstMem;var Ed=0.0;
// EMSCRIPTEN_START_FUNCS
function Vd(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+7&-8;return b|0}function Wd(){return i|0}function Xd(a){a=a|0;i=a}function Yd(a,b){a=a|0;b=b|0;if((s|0)==0){s=a;t=b}}function Zd(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function _d(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function $d(a){a=a|0;H=a}function ae(){return H|0}function be(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+256|0;e=d;c[2]=0;f=c[b>>2]|0;if((f|0)==978142541|(f|0)==980247917){c[2]=1}else if((f|0)==978145348|(f|0)==980250724){f=b+4|0;g=_k(f,58)|0;h=c[18]|0;if((h|0)!=0){Ml(h)}c[8]=0;if((g|0)!=0){a[g>>0]=0;Rm(e|0,g+1|0)|0;de(f,0,-1,-1)|0;Rm(b|0,e|0)|0}}if((c[2]|0)!=0){c[20>>2]=0;j=(c[24>>2]|0)<0?0:16;i=d;return j|0}if((c[8]|0)!=0?(ce(b)|0)==0:0){j=c[10]|0;i=d;return j|0}e=Jc(b|0,48)|0;c[10]=e;j=e;i=d;return j|0}function ce(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+256|0;e=d;f=0;while(1){g=a[b+f>>0]|0;a[e+f>>0]=$l(g<<24>>24)|0;if(g<<24>>24==0){break}else{f=f+1|0}}f=c[18]|0;if((f|0)==0){h=-1;i=d;return h|0}b=c[52]|0;if((b|0)<=0){h=-1;i=d;return h|0}g=0;j=f+16|0;while(1){if((Cm(j,e)|0)==0){break}f=g+1|0;if((f|0)<(b|0)){g=f;j=j+32|0}else{h=-1;k=11;break}}if((k|0)==11){i=d;return h|0}k=80|0;b=j+0|0;j=k+32|0;do{a[k>>0]=a[b>>0]|0;k=k+1|0;b=b+1|0}while((k|0)<(j|0));if((g|0)==-1){h=-1;i=d;return h|0}c[120]=c[108>>2];c[122]=c[104>>2];g=Jc(224,48)|0;c[10]=g;if((g|0)==0){h=-1;i=d;return h|0}uc(g|0,(c[14]|0)+(c[122]|0)|0,0)|0;h=0;i=d;return h|0}function de(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;g=i;i=i+256|0;h=g;c[14]=0;c[8]=0;c[2]=0;c[16]=d;c[18]=0;Rm(h|0,b|0)|0;b=Jc(h|0,48)|0;c[10]=b;if((b|0)==0){j=-1;i=g;return j|0}k=(d|0)>0;if(k){uc(b|0,d|0,0)|0;l=c[10]|0}else{l=b}Da(80,16,1,l|0)|0;c[14]=(c[84>>2]|0)+d;c[52]=c[88>>2];wc(c[10]|0)|0;a[84>>0]=0;if((Cm(80,216)|0)!=0){j=-1;i=g;return j|0}l=(c[92>>2]|0)+16+(c[52]<<5)|0;b=Ll(l)|0;c[18]=b;if((b|0)==0){j=-1;i=g;return j|0}b=Jc(h|0,48)|0;c[10]=b;if(k){uc(b|0,d|0,0)|0;m=c[10]|0}else{m=b}Da(c[18]|0,l|0,1,m|0)|0;wc(c[10]|0)|0;m=(f>>>0)/117440512|0;if(!((e|0)==-1)){f=Jc(h|0,48)|0;c[10]=f;if(k){uc(f|0,d|0,0)|0;n=c[10]|0}else{n=f}f=Dc(n|0)|0;if((f|0)<0){o=0}else{n=f;f=0;do{f=f+m+n|0;n=Dc(c[10]|0)|0}while((n|0)>=0);o=f&65535}wc(c[10]|0)|0;if((o|0)!=(e|0)){j=-2;i=g;return j|0}}c[8]=1;Rm(224,h|0)|0;j=0;i=g;return j|0}function ee(){var a=0,b=0;a=i;b=c[18]|0;if((b|0)!=0){Ml(b)}c[8]=0;i=a;return}function fe(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=i;i=i+256|0;h=g;c[2]=0;j=c[b>>2]|0;if((j|0)==978145348|(j|0)==980250724){k=b+4|0;l=_k(k,58)|0;m=c[18]|0;if((m|0)!=0){Ml(m)}c[8]=0;if((l|0)!=0){a[l>>0]=0;Rm(h|0,l+1|0)|0;de(k,0,-1,-1)|0;Rm(b|0,h|0)|0}}else if((j|0)==978142541|(j|0)==980247917){c[2]=1}j=(f|0)<0?0:f;if((c[2]|0)!=0){be(b)|0;c[20>>2]=j;if((c[2]|0)!=0){h=c[24>>2]|0;k=(j+e|0)<(h|0)?e:h-j|0;if((k|0)>0){Mm(d|0,(c[4]|0)+j|0,k|0)|0;c[20>>2]=(c[20>>2]|0)+k;n=k}else{n=k}}else{n=Da(d|0,1,e|0,0)|0}if((c[2]|0)!=0){o=n;i=g;return o|0}wc(c[10]|0)|0;o=n;i=g;return o|0}if((c[8]|0)!=0?(ce(b)|0)==0:0){n=c[120]|0;wc(c[10]|0)|0;k=Jc(224,48)|0;if((k|0)==0){o=-1;i=g;return o|0}uc(k|0,(c[14]|0)+j+(c[122]|0)|0,0)|0;h=(n|0)>(e|0)?e:n;if((c[2]|0)!=0){n=c[20>>2]|0;l=c[24>>2]|0;m=(n+h|0)<(l|0)?h:l-n|0;if((m|0)>0){Mm(d|0,(c[4]|0)+n|0,m|0)|0;c[20>>2]=(c[20>>2]|0)+m;p=m}else{p=m}}else{p=Da(d|0,1,h|0,k|0)|0}wc(k|0)|0;o=p;i=g;return o|0}p=Jc(b|0,48)|0;if((p|0)==0){o=-1;i=g;return o|0}if((f|0)>-1){uc(p|0,j|0,0)|0}j=Da(d|0,1,e|0,p|0)|0;wc(p|0)|0;o=j;i=g;return o|0}function ge(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+256|0;e=d;c[2]=0;f=c[b>>2]|0;if((f|0)==978142541|(f|0)==980247917){c[2]=1}else if((f|0)==978145348|(f|0)==980250724){f=b+4|0;g=_k(f,58)|0;h=c[18]|0;if((h|0)!=0){Ml(h)}c[8]=0;if((g|0)!=0){a[g>>0]=0;Rm(e|0,g+1|0)|0;de(f,0,-1,-1)|0;Rm(b|0,e|0)|0}}if((c[2]|0)!=0){j=c[24>>2]|0;i=d;return j|0}if((c[8]|0)!=0?(ce(b)|0)==0:0){if((c[2]|0)==0){wc(c[10]|0)|0}j=c[120]|0;i=d;return j|0}e=Jc(b|0,48)|0;if((e|0)==0){j=-1;i=d;return j|0}uc(e|0,0,2)|0;b=$a(e|0)|0;wc(e|0)|0;j=b;i=d;return j|0}function he(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+256|0;e=d;c[2]=0;f=c[b>>2]|0;if((f|0)==978145348|(f|0)==980250724){g=b+4|0;h=_k(g,58)|0;j=c[18]|0;if((j|0)!=0){Ml(j)}c[8]=0;if((h|0)!=0){a[h>>0]=0;Rm(e|0,h+1|0)|0;de(g,0,-1,-1)|0;Rm(b|0,e|0)|0}}else if((f|0)==978142541|(f|0)==980247917){c[2]=1}if((c[2]|0)!=0){k=2;i=d;return k|0}if((c[8]|0)!=0?(ce(b)|0)==0:0){if((c[2]|0)!=0){k=1;i=d;return k|0}wc(c[10]|0)|0;k=1;i=d;return k|0}f=Jc(b|0,48)|0;if((f|0)==0){k=-1;i=d;return k|0}wc(f|0)|0;k=0;i=d;return k|0}function ie(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;i=i+256|0;f=e;c[2]=0;g=c[b>>2]|0;if((g|0)==978145348|(g|0)==980250724){h=b+4|0;j=_k(h,58)|0;k=c[18]|0;if((k|0)!=0){Ml(k)}c[8]=0;if((j|0)!=0){a[j>>0]=0;Rm(f|0,j+1|0)|0;de(h,0,-1,-1)|0;Rm(b|0,f|0)|0}}else if((g|0)==978142541|(g|0)==980247917){c[2]=1}g=ge(b)|0;if((g|0)<0){l=1;i=e;return l|0}f=Jc(d|0,496)|0;if((f|0)==0){l=1;i=e;return l|0}d=be(b)|0;b=Ll(32768)|0;a:do{if((g|0)==0){m=0}else{h=g;while(1){j=(h|0)<32768?h:32768;if((c[2]|0)!=0){k=c[20>>2]|0;n=c[24>>2]|0;o=(k+j|0)<(n|0)?j:n-k|0;if((o|0)>0){Mm(b|0,(c[4]|0)+k|0,o|0)|0;c[20>>2]=k+o}}else{Da(b|0,1,j|0,d|0)|0}if((Rb(b|0,1,j|0,f|0)|0)<(j|0)){m=1;break a}if((h|0)==(j|0)){m=0;break}else{h=h-j|0}}}}while(0);if((c[2]|0)==0){wc(c[10]|0)|0}wc(f|0)|0;Ml(b);l=m;i=e;return l|0}function je(a,b){a=a|0;b=b|0;c[4]=a;c[20>>2]=0;c[24>>2]=b;return}function ke(b){b=b|0;var c=0,d=0,e=0,f=0;c=i;d=ge(b)|0;if((d|0)<0){e=0;i=c;return e|0}f=Wk(d+1|0)|0;fe(b,f,d,0)|0;a[f+d>>0]=0;e=f;i=c;return e|0}function le(a){a=a|0;var b=0;b=i;Om(a|0,0,888)|0;Se(a);ef();c[a+8>>2]=0;c[a+892>>2]=0;c[a+888>>2]=0;i=b;return}function me(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;sf();e=a+8|0;if((c[e>>2]|0)==0){tf();i=d;return}f=a+44|0;g=c[f>>2]|0;if((g|0)!=0){h=a+896|0;if((c[h>>2]|0)>0){j=g;k=0;do{l=j+(k*48|0)|0;Kd[c[(c[844]|0)+((b[l>>1]<<16>>16)*140|0)+52>>2]&31](l);k=k+1|0;j=c[f>>2]|0}while((k|0)<(c[h>>2]|0));if((j|0)!=0){m=j;n=6}}else{m=g;n=6}if((n|0)==6){Ul(m)}c[f>>2]=0}c[e>>2]=0;e=a+892|0;a=c[e>>2]|0;if((a|0)==0){tf();i=d;return}Xk(a);c[e>>2]=0;tf();i=d;return}function ne(b,d){b=b|0;d=d|0;c[b+888>>2]=(a[d>>0]|0)==0?0:d;return}function oe(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;i=i+512|0;g=f;h=d+8|0;if((c[h>>2]|0)!=0){j=d+44|0;k=c[j>>2]|0;if((k|0)!=0){l=d+896|0;if((c[l>>2]|0)>0){m=k;n=0;do{o=m+(n*48|0)|0;Kd[c[(c[844]|0)+((b[o>>1]<<16>>16)*140|0)+52>>2]&31](o);n=n+1|0;m=c[j>>2]|0}while((n|0)<(c[l>>2]|0));if((m|0)!=0){p=m;q=6}}else{p=k;q=6}if((q|0)==6){Ul(p)}c[j>>2]=0}c[h>>2]=0;j=d+892|0;p=c[j>>2]|0;if((p|0)!=0){Xk(p);c[j>>2]=0}}c[d+908>>2]=0;j=(e|0)!=0;if(j){de(504,e,c[d+900>>2]|0,c[d+904>>2]|0)|0}else{de(512,0,-1,-1)|0}e=c[d+888>>2]|0;if((e|0)==0){a[g>>0]=83;a[g+1>>0]=84;a[g+2>>0]=65;a[g+3>>0]=82;a[g+4>>0]=84;a[g+5>>0]=46;a[g+6>>0]=65;a[g+7>>0]=88;a[g+8>>0]=0;if(j?(he(g)|0)!=1:0){r=-1;i=f;return r|0}}else{Rm(g|0,e|0)|0}e=ke(g)|0;if((e|0)==0){r=-1;i=f;return r|0}c[d+892>>2]=e;if((((a[e>>0]|0)==72?(a[e+1>>0]|0)==83:0)?(a[e+2>>0]|0)==80:0)?(a[e+3>>0]|0)==51:0){g=d+896|0;c[g>>2]=c[e+8>>2];c[d>>2]=e;j=e+(c[e+16>>2]|0)|0;p=c[e+20>>2]|0;q=Ll(p)|0;Mm(q|0,j|0,p|0)|0;c[h>>2]=q;c[d+12>>2]=e+(c[e+24>>2]|0);q=e+(c[e+32>>2]|0)|0;p=c[e+36>>2]|0;j=Ll(p)|0;Mm(j|0,q|0,p|0)|0;c[d+20>>2]=j;j=e+(c[e+40>>2]|0)|0;p=c[e+44>>2]|0;q=Ll(p)|0;Mm(q|0,j|0,p|0)|0;c[d+16>>2]=q;q=e+(c[e+48>>2]|0)|0;p=c[e+52>>2]|0;j=Ll(p)|0;Mm(j|0,q|0,p|0)|0;c[d+832>>2]=j;j=e+(c[e+64>>2]|0)|0;p=c[e+68>>2]|0;q=Ll(p)|0;Mm(q|0,j|0,p|0)|0;c[d+836>>2]=q;q=e+(c[e+56>>2]|0)|0;p=c[e+60>>2]|0;j=Ll(p)|0;Mm(j|0,q|0,p|0)|0;c[d+840>>2]=j;_f(b[e+86>>1]|0);Ue(d);j=d+44|0;c[j>>2]=0;d=c[g>>2]|0;a:do{if((d|0)!=0?(p=Sl(d>>>0>89478485?-1:d*48|0)|0,c[j>>2]=p,(d|0)>0):0){q=p;p=0;while(1){k=q+(p*48|0)|0;b[q+(p*48|0)+2>>1]=-1;b[k>>1]=4;gg(k,4);k=p+1|0;if((k|0)>=(c[g>>2]|0)){break a}q=c[j>>2]|0;p=k}}}while(0);We(c[h>>2]|0);_e()|0;r=0;i=f;return r|0}Xk(e);r=-1;i=f;return r|0}function pe(a,b,d){a=a|0;b=b|0;d=d|0;c[a+900>>2]=b;c[a+904>>2]=d;return}function qe(){var a=0,d=0,f=0,g=0,h=0;a=i;d=c[158]|0;c[156]=d;f=d+2|0;c[158]=f;g=b[d>>1]|0;b[300]=g;h=g&65535;c[144]=h&24576;c[146]=h&4095;if(g<<16>>16<0){c[148]=(e[d+4>>1]|0)<<16|(e[f>>1]|0);c[158]=d+6;i=a;return}else{c[158]=d+4;c[148]=e[f>>1]|0;i=a;return}}function re(a){a=a|0;var b=0;if((a|0)==0){c[(c[136]|0)+236>>2]=4;return}else{b=dc(4)|0;c[b>>2]=a;td(b|0,568,0)}}function se(a,d){a=a|0;d=d|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;g=c[d>>2]|0;do{if((g|0)==-2){h=c[a>>2]|0;if((b[h+36>>1]&16)==0){te(h);j=h;break}c[h+40>>2]=0;b[h+38>>1]=0;if(!((c[146]|0)==0&(c[148]|0)==40)){k=Nd[c[(c[844]|0)+((b[h>>1]<<16>>16)*140|0)+28>>2]&63](h)|0;i=f;return k|0}l=c[158]|0;c[156]=l;m=l+2|0;c[158]=m;n=b[l>>1]|0;b[300]=n;o=n&65535;c[144]=o&24576;c[146]=o&4095;if(n<<16>>16<0){c[148]=e[l+4>>1]<<16|e[m>>1];c[158]=l+6}else{c[158]=l+4;c[148]=e[m>>1]|0}m=Sd[c[(c[844]|0)+((b[h>>1]<<16>>16)*140|0)+32>>2]&15](h,d)|0;h=c[158]|0;c[156]=h;l=h+2|0;c[158]=l;n=b[h>>1]|0;b[300]=n;o=n&65535;c[144]=o&24576;c[146]=o&4095;if(n<<16>>16<0){c[148]=e[h+4>>1]<<16|e[l>>1];c[158]=h+6;k=m;i=f;return k|0}else{c[158]=h+4;c[148]=e[l>>1]|0;k=m;i=f;return k|0}}else if((g|0)==-3){m=c[a>>2]|0;c[m+40>>2]=c[a+4>>2];if((c[146]|0)==0&(c[148]|0)==40){l=dc(4)|0;c[l>>2]=34;td(l|0,568,0)}else{j=m}}else if((g|0)==-1){if((b[a+36>>1]&16)==0){te(a);j=a;break}c[a+40>>2]=0;b[a+38>>1]=0;if(!((c[146]|0)==0&(c[148]|0)==40)){k=Nd[c[(c[844]|0)+((b[a>>1]<<16>>16)*140|0)+28>>2]&63](a)|0;i=f;return k|0}m=c[158]|0;c[156]=m;l=m+2|0;c[158]=l;h=b[m>>1]|0;b[300]=h;n=h&65535;c[144]=n&24576;c[146]=n&4095;if(h<<16>>16<0){c[148]=e[m+4>>1]<<16|e[l>>1];c[158]=m+6}else{c[158]=m+4;c[148]=e[l>>1]|0}l=Sd[c[(c[844]|0)+((b[a>>1]<<16>>16)*140|0)+32>>2]&15](a,d)|0;m=c[158]|0;c[156]=m;h=m+2|0;c[158]=h;n=b[m>>1]|0;b[300]=n;o=n&65535;c[144]=o&24576;c[146]=o&4095;if(n<<16>>16<0){c[148]=e[m+4>>1]<<16|e[h>>1];c[158]=m+6;k=l;i=f;return k|0}else{c[158]=m+4;c[148]=e[h>>1]|0;k=l;i=f;return k|0}}else if((g|0)==-6){c[d>>2]=2;k=c[a>>2]|0;i=f;return k|0}else{k=a;i=f;return k|0}}while(0);a=b[j>>1]|0;c[d>>2]=a;k=Nd[c[(c[844]|0)+(a*140|0)+28>>2]&63](j)|0;i=f;return k|0}function te(a){a=a|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;f=a+40|0;c[f>>2]=0;g=a+38|0;b[g>>1]=0;if(!((c[146]|0)==0&(c[148]|0)==40)){i=d;return}h=c[158]|0;c[156]=h;j=h+2|0;c[158]=j;k=b[h>>1]|0;b[300]=k;l=k&65535;c[144]=l&24576;c[146]=l&4095;if(k<<16>>16<0){c[148]=e[h+4>>1]<<16|e[j>>1];c[158]=h+6}else{c[158]=h+4;c[148]=e[j>>1]|0}j=a+44|0;while(1){h=b[g>>1]|0;k=c[f>>2]|0;l=c[j>>2]|0;m=ue()|0;if((m|0)<-1){n=7;break}o=c[134]|0;if((b[o>>1]|0)!=4){n=9;break}b[g>>1]=h;c[f>>2]=k;c[j>>2]=l;kg(a,c[c[o+28>>2]>>2]|0);if((m|0)==-1){n=11;break}}if((n|0)==7){a=dc(4)|0;c[a>>2]=25;td(a|0,568,0)}else if((n|0)==9){a=dc(4)|0;c[a>>2]=6;td(a|0,568,0)}else if((n|0)==11){n=c[158]|0;c[156]=n;a=n+2|0;c[158]=a;j=b[n>>1]|0;b[300]=j;f=j&65535;c[144]=f&24576;c[146]=f&4095;if(j<<16>>16<0){c[148]=e[n+4>>1]<<16|e[a>>1];c[158]=n+6;i=d;return}else{c[158]=n+4;c[148]=e[a>>1]|0;i=d;return}}}function ue(){var a=0,d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;a=i;i=i+16|0;d=a+4|0;f=a;g=c[144]|0;if((g&8192|0)!=0){h=-2;i=a;return h|0}if((g&16384|0)!=0){c[144]=g^16384;h=-3;i=a;return h|0}j=c[146]|0;do{if((j|0)==0){k=c[148]|0;if((k|0)==41){c[144]=g&-16385;h=-4;i=a;return h|0}else if((k|0)!=63){break}k=c[158]|0;c[156]=k;l=k+2|0;c[158]=l;m=b[k>>1]|0;b[300]=m;n=m&65535;c[144]=n&24576;c[146]=n&4095;if(m<<16>>16<0){c[148]=e[k+4>>1]<<16|e[l>>1];c[158]=k+6}else{c[158]=k+4;c[148]=e[l>>1]|0}c[144]=n&8192;h=-3;i=a;return h|0}}while(0);if(!((b[300]&4096)==0)){if((j|0)==4){n=c[152]|0;c[134]=n;c[c[n+28>>2]>>2]=c[148]}else if((j|0)==2|(j|0)==3){n=c[844]|0;l=c[842]|0;k=l+(j*48|0)|0;c[134]=k;do{if((b[l+(j*48|0)+2>>1]|0)==-1){if((b[n+(j*140|0)>>1]|0)==0){m=dc(4)|0;c[m>>2]=27;td(m|0,568,0)}else{hg(k,j);o=c[134]|0;break}}else{o=k}}while(0);Od[c[n+(j*140|0)+72>>2]&15](o,c[o+28>>2]|0,(c[(c[136]|0)+12>>2]|0)+(c[148]|0)|0)}else{o=dc(4)|0;c[o>>2]=1;td(o|0,568,0)}o=c[158]|0;c[156]=o;n=o+2|0;c[158]=n;k=b[o>>1]|0;b[300]=k;l=k&65535;c[144]=l&24576;c[146]=l&4095;if(k<<16>>16<0){c[148]=e[o+4>>1]<<16|e[n>>1];c[158]=o+6}else{c[158]=o+4;c[148]=e[n>>1]|0}c[144]=l&8192;h=0;i=a;return h|0}l=((c[984]|0)-(c[982]|0)|0)/72|0;n=j;j=g|16384;a:while(1){b:do{switch(n|0){case 0:{g=c[148]|0;p=c[984]|0;if((g|0)==41){q=27;break a}o=p+ -72|0;k=b[p+ -144>>1]|0;m=k<<16>>16;if(k<<16>>16==4?(b[o>>1]|0)==4:0){r=p+ -136|0;s=p+ -64|0;t=c[s>>2]|0;do{switch(g|0){case 0:{u=(c[r>>2]|0)+t|0;c[r>>2]=u;v=u;break};case 1:{u=(c[r>>2]|0)-t|0;c[r>>2]=u;v=u;break};case 2:{u=da(c[r>>2]|0,t)|0;c[r>>2]=u;v=u;break};case 6:{u=c[r>>2]|t;c[r>>2]=u;v=u;break};case 4:{if((t|0)==0){q=40;break a}u=(c[r>>2]|0)%(t|0)|0;c[r>>2]=u;v=u;break};case 10:{u=(c[r>>2]|0)>(t|0)&1;c[r>>2]=u;v=u;break};case 14:{u=c[r>>2]>>t;c[r>>2]=u;v=u;break};case 15:{u=c[r>>2]<<t;c[r>>2]=u;v=u;break};case 40:{q=53;break a;break};case 3:{if((t|0)==0){q=37;break a}u=(c[r>>2]|0)/(t|0)|0;c[r>>2]=u;v=u;break};case 7:{u=c[r>>2]^t;c[r>>2]=u;v=u;break};case 5:{u=c[r>>2]&t;c[r>>2]=u;v=u;break};case 8:{u=(c[r>>2]|0)==(t|0)&1;c[r>>2]=u;v=u;break};case 12:{u=(c[r>>2]|0)>=(t|0)&1;c[r>>2]=u;v=u;break};case 9:{u=(c[r>>2]|0)!=(t|0)&1;c[r>>2]=u;v=u;break};case 13:{u=(c[r>>2]|0)<=(t|0)&1;c[r>>2]=u;v=u;break};case 11:{u=(c[r>>2]|0)<(t|0)&1;c[r>>2]=u;v=u;break};default:{q=54;break a}}}while(0);c[984]=o;c[s>>2]=v}else{r=c[842]|0;t=r+(m*48|0)|0;c[134]=t;u=c[844]|0;w=u+(m*140|0)|0;if((b[r+(m*48|0)+2>>1]|0)==-1){if((b[w>>1]|0)==0){q=58;break a}hg(t,m);x=c[134]|0}else{x=t}Od[c[u+(m*140|0)+72>>2]&15](x,c[x+28>>2]|0,c[p+ -140>>2]|0);t=c[p+ -68>>2]|0;r=b[o>>1]|0;y=r<<16>>16;do{if(!(k<<16>>16==r<<16>>16)){if(r<<16>>16>7){z=Sd[c[(c[844]|0)+(y*140|0)+24>>2]&15](t,m)|0;break}else{z=Sd[c[u+(m*140|0)+20>>2]&15](t,y)|0;break}}else{z=t}}while(0);Ff(w,c[(c[134]|0)+28>>2]|0,g,z);t=c[984]|0;y=t+ -72|0;c[984]=y;if((b[t+ -70>>1]|0)==0){A=y}else{Hi();A=c[984]|0}c[984]=A+ -72;if((b[A+ -70>>1]|0)!=0){Hi()}y=b[u+(m*140|0)+2>>1]|0;t=y<<16>>16;if(y<<16>>16==k<<16>>16){B=m;C=w}else{B=t;C=(c[844]|0)+(t*140|0)|0}t=b[C+8>>1]|0;if(t<<16>>16<0){D=Nd[c[C+56>>2]&63](c[(c[134]|0)+28>>2]|0)|0}else{D=t<<16>>16}Ei(B,c[(c[134]|0)+28>>2]|0,D)}t=c[158]|0;c[156]=t;y=t+2|0;c[158]=y;r=b[t>>1]|0;b[300]=r;o=r&65535;c[144]=o&24576;c[146]=o&4095;if(r<<16>>16<0){c[148]=e[t+4>>1]<<16|e[y>>1];c[158]=t+6;break b}else{c[158]=t+4;c[148]=e[y>>1]|0;break b}break};case 1:{y=c[148]|0;t=c[(c[136]|0)+44>>2]|0;r=t+(y*48|0)|0;o=c[158]|0;c[156]=o;s=o+2|0;c[158]=s;E=b[o>>1]|0;b[300]=E;F=E&65535;c[144]=F&24576;c[146]=F&4095;if(E<<16>>16<0){c[148]=e[o+4>>1]<<16|e[s>>1];E=o+6|0;c[158]=E;G=E}else{E=o+4|0;c[158]=E;c[148]=e[s>>1]|0;G=E}E=b[r>>1]|0;c[d>>2]=E;do{if(!((b[t+(y*48|0)+36>>1]&16)==0)){c[t+(y*48|0)+40>>2]=0;b[t+(y*48|0)+38>>1]=0;if(!((c[146]|0)==0&(c[148]|0)==40)){H=Nd[c[(c[844]|0)+(E*140|0)+28>>2]&63](r)|0;break}c[156]=G;s=G+2|0;c[158]=s;o=b[G>>1]|0;b[300]=o;F=o&65535;c[144]=F&24576;c[146]=F&4095;if(o<<16>>16<0){c[148]=e[G+4>>1]<<16|e[s>>1];c[158]=G+6}else{c[158]=G+4;c[148]=e[s>>1]|0}s=Sd[c[(c[844]|0)+((b[r>>1]<<16>>16)*140|0)+32>>2]&15](r,d)|0;o=c[158]|0;c[156]=o;F=o+2|0;c[158]=F;I=b[o>>1]|0;b[300]=I;J=I&65535;c[144]=J&24576;c[146]=J&4095;if(I<<16>>16<0){c[148]=e[o+4>>1]<<16|e[F>>1];c[158]=o+6;H=s;break}else{c[158]=o+4;c[148]=e[F>>1]|0;H=s;break}}else{te(r);H=Nd[c[(c[844]|0)+((b[r>>1]<<16>>16)*140|0)+28>>2]&63](r)|0}}while(0);r=c[d>>2]|0;E=c[844]|0;y=b[E+(r*140|0)+8>>1]|0;if(y<<16>>16<0){t=Nd[c[E+(r*140|0)+56>>2]&63](H)|0;K=c[d>>2]|0;L=t}else{K=r;L=y<<16>>16}Ei(K,H,L);break};case 5:{y=c[148]|0;r=c[136]|0;t=c[r+836>>2]|0;E=c[158]|0;c[156]=E;w=E+2|0;c[158]=w;m=b[E>>1]|0;b[300]=m;k=m&65535;c[144]=k&24576;c[146]=k&4095;if(m<<16>>16<0){c[148]=e[E+4>>1]<<16|e[w>>1];c[158]=E+6}else{c[158]=E+4;c[148]=e[w>>1]|0}w=c[r+828>>2]|0;if((w|0)==0){q=105;break a}r=b[t+(y<<3)+2>>1]|0;if(r<<16>>16==-1){M=w}else{if((b[w+2>>1]|0)!=21930){q=110;break a}if(!((b[w>>1]|0)==r<<16>>16)){q=110;break a}r=c[w+4>>2]|0;if((b[r>>1]|0)!=5){q=110;break a}c[r+40>>2]=c[w+8>>2];w=Nd[c[(c[844]|0)+728>>2]&63](r)|0;if((b[w>>1]|0)==0){q=112;break a}M=c[w+12>>2]|0}w=M+(c[t+(y<<3)+4>>2]|0)|0;c[d>>2]=b[t+(y<<3)>>1]|0;y=se(w,d)|0;w=c[d>>2]|0;t=c[844]|0;r=b[t+(w*140|0)+8>>1]|0;if(r<<16>>16<0){E=Nd[c[t+(w*140|0)+56>>2]&63](y)|0;N=c[d>>2]|0;O=E}else{N=w;O=r<<16>>16}Ei(N,y,O);break};case 4:{y=c[148]|0;r=c[984]|0;b[r>>1]=4;c[r+8>>2]=y;c[984]=r+72;r=c[158]|0;c[156]=r;y=r+2|0;c[158]=y;w=b[r>>1]|0;b[300]=w;E=w&65535;c[144]=E&24576;c[146]=E&4095;if(w<<16>>16<0){c[148]=e[r+4>>1]<<16|e[y>>1];c[158]=r+6;break b}else{c[158]=r+4;c[148]=e[y>>1]|0;break b}break};case 3:{Ei(3,(c[(c[136]|0)+12>>2]|0)+(c[148]|0)|0,8);y=c[158]|0;c[156]=y;r=y+2|0;c[158]=r;w=b[y>>1]|0;b[300]=w;E=w&65535;c[144]=E&24576;c[146]=E&4095;if(w<<16>>16<0){c[148]=e[y+4>>1]<<16|e[r>>1];c[158]=y+6;break b}else{c[158]=y+4;c[148]=e[r>>1]|0;break b}break};case 2:{Fi(2,(c[(c[136]|0)+12>>2]|0)+(c[148]|0)|0);r=c[158]|0;c[156]=r;y=r+2|0;c[158]=y;w=b[r>>1]|0;b[300]=w;E=w&65535;c[144]=E&24576;c[146]=E&4095;if(w<<16>>16<0){c[148]=e[r+4>>1]<<16|e[y>>1];c[158]=r+6;break b}else{c[158]=r+4;c[148]=e[y>>1]|0;break b}break};case 7:{y=c[136]|0;c[f>>2]=(c[y+8>>2]|0)+(c[(c[y+20>>2]|0)+(c[148]<<2)>>2]<<1);Ei(1,f,4);y=c[158]|0;c[156]=y;r=y+2|0;c[158]=r;w=b[y>>1]|0;b[300]=w;E=w&65535;c[144]=E&24576;c[146]=E&4095;if(w<<16>>16<0){c[148]=e[y+4>>1]<<16|e[r>>1];c[158]=y+6;break b}else{c[158]=y+4;c[148]=e[r>>1]|0;break b}break};default:{r=(c[154]|0)+(n<<5)+16|0;if((c[r>>2]|0)==0){q=121;break a}y=c[148]|0;w=c[158]|0;c[156]=w;E=w+2|0;c[158]=E;t=b[w>>1]|0;b[300]=t;m=t&65535;c[144]=m&24576;c[146]=m&4095;if(t<<16>>16<0){c[148]=e[w+4>>1]<<16|e[E>>1];c[158]=w+6}else{c[158]=w+4;c[148]=e[E>>1]|0}E=Sd[c[r>>2]&15](d,y)|0;y=Nd[c[(c[844]|0)+((c[d>>2]|0)*140|0)+56>>2]&63](E)|0;Ei(c[d>>2]|0,E,y)}}}while(0);P=c[144]|0;if((P|0)!=0){q=128;break}n=c[146]|0;j=16384}switch(q|0){case 27:{if((l|0)==((p-(c[982]|0)|0)/72|0|0)){q=dc(4)|0;c[q>>2]=4;td(q|0,568,0)}else{c[144]=j;Q=j;R=p;S=-1;break}break};case 37:{p=dc(4)|0;c[p>>2]=19;td(p|0,568,0);break};case 40:{p=dc(4)|0;c[p>>2]=19;td(p|0,568,0);break};case 53:{p=dc(4)|0;c[p>>2]=34;td(p|0,568,0);break};case 54:{p=dc(4)|0;c[p>>2]=4;td(p|0,568,0);break};case 58:{p=dc(4)|0;c[p>>2]=27;td(p|0,568,0);break};case 105:{p=dc(4)|0;c[p>>2]=30;td(p|0,568,0);break};case 110:{p=dc(4)|0;c[p>>2]=36;td(p|0,568,0);break};case 112:{p=dc(4)|0;c[p>>2]=36;td(p|0,568,0);break};case 121:{p=dc(4)|0;c[p>>2]=30;td(p|0,568,0);break};case 128:{Q=P;R=c[984]|0;S=0;break}}c[144]=Q&-16385;Q=b[R+ -72>>1]|0;P=Q<<16>>16;c[d>>2]=P;if(Q<<16>>16==4){Q=c[152]|0;c[134]=Q;c[c[Q+28>>2]>>2]=c[R+ -64>>2];T=R}else{Q=c[844]|0;d=c[842]|0;p=d+(P*48|0)|0;c[134]=p;do{if((b[d+(P*48|0)+2>>1]|0)==-1){if((b[Q+(P*140|0)>>1]|0)==0){j=dc(4)|0;c[j>>2]=27;td(j|0,568,0)}else{hg(p,P);U=c[134]|0;break}}else{U=p}}while(0);Od[c[Q+(P*140|0)+72>>2]&15](U,c[U+28>>2]|0,c[R+ -68>>2]|0);T=c[984]|0}R=T+ -72|0;c[984]=R;if((b[T+ -70>>1]|0)==0){V=R}else{Hi();V=c[984]|0}if((l|0)==((V-(c[982]|0)|0)/72|0|0)){h=S;i=a;return h|0}else{h=dc(4)|0;c[h>>2]=29;td(h|0,568,0)}return 0}function ve(){var a=0,d=0;a=i;if((ue()|0)<-1){d=dc(4)|0;c[d>>2]=5;td(d|0,568,0)}d=c[134]|0;if((b[d>>1]|0)==2){i=a;return c[d+28>>2]|0}else{d=dc(4)|0;c[d>>2]=6;td(d|0,568,0)}return 0}function we(a){a=a|0;var d=0,e=0,f=0;d=i;if((ue()|0)<-1){e=a;i=d;return e|0}a=c[134]|0;if((b[a>>1]|0)!=2){f=dc(4)|0;c[f>>2]=6;td(f|0,568,0)}e=c[a+28>>2]|0;i=d;return e|0}function xe(a){a=a|0;var d=0,e=0,f=0;d=i;if(!((ue()|0)<-1)){e=c[134]|0;if((b[e>>1]|0)==2){f=c[e+28>>2]|0}else{f=ig(e,2)|0}}else{f=a}i=d;return f|0}function ye(){var a=0,d=0,e=0,f=0;a=i;if((ue()|0)<-1){d=dc(4)|0;c[d>>2]=5;td(d|0,568,0)}d=c[134]|0;e=b[d>>1]|0;if(e<<16>>16==3){f=~~+h[c[d+28>>2]>>3];i=a;return f|0}else if(e<<16>>16==4){f=c[c[d+28>>2]>>2]|0;i=a;return f|0}else{f=dc(4)|0;c[f>>2]=6;td(f|0,568,0)}return 0}function ze(a){a=a|0;var d=0,e=0,f=0;d=i;if((ue()|0)<-1){e=a;i=d;return e|0}a=c[134]|0;f=b[a>>1]|0;if(f<<16>>16==3){e=~~+h[c[a+28>>2]>>3];i=d;return e|0}else if(f<<16>>16==4){e=c[c[a+28>>2]>>2]|0;i=d;return e|0}else{e=dc(4)|0;c[e>>2]=6;td(e|0,568,0)}return 0}function Ae(){var a=0,d=0,e=0,f=0.0;a=i;if((ue()|0)<-1){d=dc(4)|0;c[d>>2]=5;td(d|0,568,0)}d=c[134]|0;e=b[d>>1]|0;if(e<<16>>16==3){f=+h[c[d+28>>2]>>3];i=a;return+f}else if(e<<16>>16==4){f=+(c[c[d+28>>2]>>2]|0);i=a;return+f}else{a=dc(4)|0;c[a>>2]=6;td(a|0,568,0)}return 0.0}function Be(a){a=+a;var d=0,e=0.0,f=0,g=0;d=i;if((ue()|0)<-1){e=a;i=d;return+e}f=c[134]|0;g=b[f>>1]|0;if(g<<16>>16==4){e=+(c[c[f+28>>2]>>2]|0);i=d;return+e}else if(g<<16>>16==3){e=+h[c[f+28>>2]>>3];i=d;return+e}else{d=dc(4)|0;c[d>>2]=6;td(d|0,568,0)}return 0.0}function Ce(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;if((d|0)==1){f=c[(c[a>>2]|0)+40>>2]|0;i=e;return f|0}else if((d|0)==-2){g=c[b>>2]|0;h=g;j=De(g)|0}else if((d|0)==-1){h=b;j=De(b)|0}else if((d|0)==-3){d=c[b>>2]|0;g=c[b+4>>2]|0;if((c[146]|0)==0&(c[148]|0)==40){b=dc(4)|0;c[b>>2]=34;td(b|0,568,0)}else{h=d;j=g}}else{g=dc(4)|0;c[g>>2]=23;td(g|0,568,0)}c[a>>2]=h;f=j;i=e;return f|0}function De(a){a=a|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;f=(b[a+36>>1]&16)==0;g=a+40|0;c[g>>2]=0;h=a+38|0;b[h>>1]=0;if(!f){c[340]=0;if(!((c[146]|0)==0&(c[148]|0)==40)){j=c[g>>2]|0;i=d;return j|0}f=c[158]|0;c[156]=f;k=f+2|0;c[158]=k;l=b[f>>1]|0;b[300]=l;m=l&65535;c[144]=m&24576;c[146]=m&4095;if(l<<16>>16<0){c[148]=e[f+4>>1]<<16|e[k>>1];c[158]=f+6}else{c[158]=f+4;c[148]=e[k>>1]|0}Kd[c[(c[844]|0)+((b[a>>1]<<16>>16)*140|0)+36>>2]&31](a);c[340]=1;k=c[158]|0;c[156]=k;f=k+2|0;c[158]=f;l=b[k>>1]|0;b[300]=l;m=l&65535;c[144]=m&24576;c[146]=m&4095;if(l<<16>>16<0){c[148]=e[k+4>>1]<<16|e[f>>1];c[158]=k+6;j=c[g>>2]|0;i=d;return j|0}else{c[158]=k+4;c[148]=e[f>>1]|0;j=c[g>>2]|0;i=d;return j|0}}if(!((c[146]|0)==0&(c[148]|0)==40)){j=c[g>>2]|0;i=d;return j|0}f=c[158]|0;c[156]=f;k=f+2|0;c[158]=k;l=b[f>>1]|0;b[300]=l;m=l&65535;c[144]=m&24576;c[146]=m&4095;if(l<<16>>16<0){c[148]=e[f+4>>1]<<16|e[k>>1];c[158]=f+6}else{c[158]=f+4;c[148]=e[k>>1]|0}k=a+44|0;while(1){f=b[h>>1]|0;l=c[g>>2]|0;m=c[k>>2]|0;n=ue()|0;if((n|0)<-1){o=15;break}p=c[134]|0;if((b[p>>1]|0)!=4){o=17;break}b[h>>1]=f;c[g>>2]=l;c[k>>2]=m;Ef(a,c[c[p+28>>2]>>2]|0);if((n|0)==-1){o=19;break}}if((o|0)==15){a=dc(4)|0;c[a>>2]=25;td(a|0,568,0)}else if((o|0)==17){a=dc(4)|0;c[a>>2]=6;td(a|0,568,0)}else if((o|0)==19){o=c[158]|0;c[156]=o;a=o+2|0;c[158]=a;k=b[o>>1]|0;b[300]=k;h=k&65535;c[144]=h&24576;c[146]=h&4095;if(k<<16>>16<0){c[148]=e[o+4>>1]<<16|e[a>>1];c[158]=o+6;j=c[g>>2]|0;i=d;return j|0}else{c[158]=o+4;c[148]=e[a>>1]|0;j=c[g>>2]|0;i=d;return j|0}}return 0}function Ee(a){a=a|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;if((c[144]|0)!=0){f=dc(4)|0;c[f>>2]=23;td(f|0,568,0)}f=c[146]|0;if((f|0)==1){g=(c[(c[136]|0)+44>>2]|0)+((c[148]|0)*48|0)|0;h=c[158]|0;c[156]=h;j=h+2|0;c[158]=j;k=b[h>>1]|0;b[300]=k;l=k&65535;c[144]=l&24576;c[146]=l&4095;if(k<<16>>16<0){c[148]=e[h+4>>1]<<16|e[j>>1];c[158]=h+6}else{c[158]=h+4;c[148]=e[j>>1]|0}j=De(g)|0;c[144]=c[144]&8192;c[a>>2]=g;m=j;i=d;return m|0}else if((f|0)==5){f=c[148]|0;j=c[158]|0;c[156]=j;g=j+2|0;c[158]=g;h=b[j>>1]|0;b[300]=h;k=h&65535;c[144]=k&24576;c[146]=k&4095;if(h<<16>>16<0){c[148]=e[j+4>>1]<<16|e[g>>1];c[158]=j+6}else{c[158]=j+4;c[148]=e[g>>1]|0}g=c[136]|0;j=c[g+828>>2]|0;if((j|0)==0){h=dc(4)|0;c[h>>2]=30;td(h|0,568,0)}if((f|0)==-1){if((b[j+2>>1]|0)!=21930){h=dc(4)|0;c[h>>2]=36;td(h|0,568,0)}c[a>>2]=c[j+4>>2];c[144]=k&8192;m=c[j+8>>2]|0;i=d;return m|0}k=c[g+836>>2]|0;g=b[k+(f<<3)+2>>1]|0;do{if(!(g<<16>>16==-1)){if((b[j+2>>1]|0)!=21930){n=dc(4)|0;c[n>>2]=36;td(n|0,568,0)}if(!((b[j>>1]|0)==g<<16>>16)){n=dc(4)|0;c[n>>2]=36;td(n|0,568,0)}h=c[j+4>>2]|0;if((b[h>>1]|0)!=5){n=dc(4)|0;c[n>>2]=36;td(n|0,568,0)}c[h+40>>2]=c[j+8>>2];l=Nd[c[(c[844]|0)+728>>2]&63](h)|0;if((b[l>>1]|0)==0){h=dc(4)|0;c[h>>2]=36;td(h|0,568,0)}else{o=c[l+12>>2]|0;break}}else{o=j}}while(0);j=Ce(a,o+(c[k+(f<<3)+4>>2]|0)|0,b[k+(f<<3)>>1]|0)|0;c[144]=c[144]&8192;m=j;i=d;return m|0}else{m=dc(4)|0;c[m>>2]=23;td(m|0,568,0)}return 0}function Fe(){var a=0,b=0;a=i;i=i+16|0;b=a;if((Ee(b)|0)==0){i=a;return c[b>>2]|0}else{b=dc(4)|0;c[b>>2]=25;td(b|0,568,0)}return 0}function Ge(){var a=0,d=0,e=0,f=0;a=i;if((c[146]|0)==7){d=c[136]|0;e=(c[d+8>>2]|0)+(c[(c[d+20>>2]|0)+(c[148]<<2)>>2]<<1)|0;i=a;return e|0}if((ue()|0)<-1){d=dc(4)|0;c[d>>2]=8;td(d|0,568,0)}d=c[134]|0;if((b[d>>1]|0)!=1){f=dc(4)|0;c[f>>2]=8;td(f|0,568,0)}f=c[c[d+28>>2]>>2]|0;if((f|0)==0){d=dc(4)|0;c[d>>2]=8;td(d|0,568,0)}c[158]=c[156];e=f;i=a;return e|0}function He(){var a=0,d=0,f=0,g=0,h=0,j=0,k=0;a=i;d=Ge()|0;f=c[158]|0;c[156]=f;g=f+2|0;c[158]=g;h=b[f>>1]|0;b[300]=h;j=h&65535;c[144]=j&24576;c[146]=j&4095;if(h<<16>>16<0){c[148]=(e[f+4>>1]|0)<<16|(e[g>>1]|0);c[158]=f+6;k=j&8192;c[144]=k;i=a;return d|0}else{c[158]=f+4;c[148]=e[g>>1]|0;k=j&8192;c[144]=k;i=a;return d|0}return 0}function Ie(){var a=0,d=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;if((c[146]|0)!=5){d=dc(4)|0;c[d>>2]=35;td(d|0,568,0)}d=c[148]|0;f=c[136]|0;g=c[f+836>>2]|0;h=c[158]|0;c[156]=h;j=h+2|0;c[158]=j;k=b[h>>1]|0;b[300]=k;l=k&65535;c[144]=l&24576;c[146]=l&4095;if(k<<16>>16<0){c[148]=e[h+4>>1]<<16|e[j>>1];c[158]=h+6}else{c[158]=h+4;c[148]=e[j>>1]|0}c[144]=l&8192;if((b[g+(d<<3)>>1]|0)==-5){i=a;return(c[f+840>>2]|0)+((b[g+(d<<3)+2>>1]|0)*28|0)|0}else{d=dc(4)|0;c[d>>2]=35;td(d|0,568,0)}return 0}function Je(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;c[a+40>>2]=d;h=c[844]|0;do{if((b[a>>1]|0)!=(e|0)){if((d|0)==0){gg(a,e);break}else{j=dc(4)|0;c[j>>2]=31;td(j|0,568,0)}}}while(0);d=c[h+(e*140|0)+72>>2]|0;j=Nd[c[h+(e*140|0)+28>>2]&63](a)|0;Od[d&15](a,j,f);i=g;return}function Ke(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;f=Ee(a)|0;g=c[a>>2]|0;a=b[g>>1]|0;h=c[844]|0;j=c[h+(a*140|0)+64>>2]|0;c[g+40>>2]=f;f=Nd[c[h+(a*140|0)+28>>2]&63](g)|0;a=Fd[j&15](g,f,d)|0;i=e;return a|0}function Le(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0,v=0;g=i;i=i+16|0;j=g+4|0;l=g;m=e+8|0;if((c[m>>2]|0)<=0){i=g;return}n=(f&1|0)==0;f=0;o=(c[(c[136]|0)+836>>2]|0)+(c[e+4>>2]<<3)|0;a:while(1){e=c[o+4>>2]|0;p=d+e|0;b:do{switch(b[o>>1]|0){case-7:{q=Ee(j)|0;b[d+(e+2)>>1]=21930;b[p>>1]=b[o+2>>1]|0;c[d+(e+4)>>2]=c[j>>2];c[d+(e+8)>>2]=q;break};case 3:{if((ue()|0)<-1){r=14;break a}q=c[134]|0;s=b[q>>1]|0;if(s<<16>>16==3){t=+h[c[q+28>>2]>>3]}else if(s<<16>>16==4){t=+(c[c[q+28>>2]>>2]|0)}else{r=16;break a}h[k>>3]=t;a[p>>0]=a[k>>0];a[p+1>>0]=a[k+1>>0];a[p+2>>0]=a[k+2>>0];a[p+3>>0]=a[k+3>>0];a[p+4>>0]=a[k+4>>0];a[p+5>>0]=a[k+5>>0];a[p+6>>0]=a[k+6>>0];a[p+7>>0]=a[k+7>>0];break};case-6:{if((ue()|0)<-1){r=21;break a}q=c[134]|0;if((b[q>>1]|0)!=2){r=23;break a}s=c[q+28>>2]|0;q=Mi((Jm(s|0)|0)+1|0)|0;Rm(q|0,s|0)|0;c[p>>2]=q;break};case-20:case-11:{c[p+0>>2]=c[640>>2];c[p+4>>2]=c[644>>2];c[p+8>>2]=c[648>>2];break};case 4:{do{if(!((ue()|0)<-1)){q=c[134]|0;s=b[q>>1]|0;if(s<<16>>16==4){u=c[c[q+28>>2]>>2]|0;break}else if(s<<16>>16==3){u=~~+h[c[q+28>>2]>>3];break}else{r=6;break a}}else{u=0}}while(0);c[p>>2]=u;break};case-2:case-3:{q=Ee(l)|0;c[p>>2]=c[l>>2];c[d+(e+4)>>2]=q;break};case-1:{b[d+(e+2)>>1]=-1;if(!n?(ue()|0)==0:0){q=c[134]|0;b[p>>1]=b[q>>1]|0;gg(p,b[q>>1]|0);q=b[p>>1]|0;s=c[844]|0;v=Nd[c[s+(q*140|0)+28>>2]&63](p)|0;Od[c[s+(q*140|0)+72>>2]&15](p,v,c[(c[134]|0)+28>>2]|0);break b}b[p>>1]=4;gg(p,4);break};case-5:{break};default:{r=29;break a}}}while(0);f=f+1|0;if((f|0)>=(c[m>>2]|0)){r=31;break}else{o=o+8|0}}if((r|0)==6){o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}else if((r|0)==14){o=dc(4)|0;c[o>>2]=5;td(o|0,568,0)}else if((r|0)==16){o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}else if((r|0)==21){o=dc(4)|0;c[o>>2]=5;td(o|0,568,0)}else if((r|0)==23){o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}else if((r|0)==29){o=dc(4)|0;c[o>>2]=36;td(o|0,568,0)}else if((r|0)==31){i=g;return}}function Me(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=i;c[a+40>>2]=d;f=Nd[c[(c[844]|0)+((b[a>>1]<<16>>16)*140|0)+28>>2]&63](a)|0;if((b[f>>1]|0)!=1){i=e;return}g=b[f+4>>1]|0;h=c[136]|0;j=c[h+836>>2]|0;k=j+(g<<3)|0;l=j+(g<<3)+2|0;g=b[l>>1]|0;j=c[h+840>>2]|0;h=f+12|0;m=c[h>>2]|0;if((b[f+6>>1]|0)==0){n=j+(g*28|0)+20|0;if((c[n>>2]|0)!=0){b[642>>1]=21930;b[320]=b[l>>1]|0;c[644>>2]=a;c[648>>2]=d;Ne(c[n>>2]|0)}n=j+(g*28|0)+8|0;g=c[n>>2]|0;if((g|0)>0){j=g;g=0;d=k;while(1){if((b[d>>1]|0)==-1){k=m+(c[d+4>>2]|0)|0;Kd[c[(c[844]|0)+((b[k>>1]<<16>>16)*140|0)+52>>2]&31](k);o=c[n>>2]|0}else{o=j}g=g+1|0;if((g|0)>=(o|0)){break}else{j=o;d=d+8|0}}}p=c[h>>2]|0}else{p=m}Oi(p);b[f>>1]=0;i=e;return}function Ne(a){a=a|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;f=c[(c[136]|0)+840>>2]|0;g=f+(a*28|0)|0;h=Gi(257,(c[f+(a*28|0)+16>>2]|0)+20|0)|0;j=h+20|0;Le(j,g,0);c[h+12>>2]=c[(c[136]|0)+828>>2];c[(c[136]|0)+828>>2]=j;c[h+4>>2]=c[156];j=(c[136]|0)+256|0;k=c[j>>2]|0;c[j>>2]=k+1;c[h>>2]=k;c[h+8>>2]=g;g=c[136]|0;h=c[g+8>>2]|0;k=c[(c[g+20>>2]|0)+(c[f+(a*28|0)+20>>2]<<2)>>2]|0;a=h+(k<<1)|0;c[156]=a;f=h+(k+1<<1)|0;c[158]=f;g=b[a>>1]|0;b[300]=g;a=g&65535;c[144]=a&24576;c[146]=a&4095;if(g<<16>>16<0){c[148]=(e[h+(k+2<<1)>>1]|0)<<16|(e[f>>1]|0);c[158]=h+(k+3<<1)}else{c[158]=h+(k+2<<1);c[148]=e[f>>1]|0}while(1){if((c[226]|0)!=0?(f=c[916>>2]|0,k=c[156]|0,c[156]=c[158],h=Ze()|0,c[916>>2]=h,g=c[136]|0,c[920>>2]=(c[g+12>>2]|0)+(c[168]|0),c[156]=k,(f|0)!=(h|0)):0){c[g+236>>2]=3;Kd[c[g+852>>2]&31](g)}if((Nd[c[(c[154]|0)+(c[146]<<5)+12>>2]&63](c[148]|0)|0)==0){continue}g=c[136]|0;h=c[g+236>>2]|0;if((h|0)==6){l=10;break}else if((h|0)==4){l=9;break}Kd[c[g+852>>2]&31](g)}if((l|0)==9){g=dc(4)|0;c[g>>2]=0;td(g|0,568,0)}else if((l|0)==10){uf();i=d;return}}function Oe(a){a=a|0;var d=0,e=0,f=0;d=i;if((b[a+2>>1]|0)!=1){i=d;return}e=a+8|0;if((c[e>>2]|0)>0){f=0}else{i=d;return}do{Me(a,f);f=f+1|0}while((f|0)<(c[e>>2]|0));i=d;return}function Pe(a){a=a|0;var b=0,d=0;b=i;if((a|0)>1024){d=Pi(c[(c[136]|0)+824>>2]|0,a)|0;c[(c[136]|0)+824>>2]=d}i=b;return c[(c[136]|0)+824>>2]|0}function Qe(a){a=a|0;var b=0,d=0,e=0;b=i;d=Jm(a|0)|0;if((d|0)>1023){e=Pi(c[(c[136]|0)+824>>2]|0,d+1|0)|0;c[(c[136]|0)+824>>2]=e}e=c[(c[136]|0)+824>>2]|0;Rm(e|0,a|0)|0;i=b;return e|0}function Re(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;if((a|0)>=0){e=a;f=c[154]|0;g=f+(e<<5)|0;i=d;return g|0}a=c[164]|0;h=a+1|0;c[164]=h;j=Pi(c[154]|0,h<<5)|0;c[154]=j;b[j+(a<<5)>>1]=a;b[j+(a<<5)+2>>1]=0;c[j+(a<<5)+4>>2]=c[136];c[j+(a<<5)+8>>2]=c[(c[136]|0)+876>>2];c[j+(a<<5)+12>>2]=2;c[j+(a<<5)+16>>2]=0;c[j+(a<<5)+20>>2]=0;c[j+(a<<5)+28>>2]=0;e=a;f=c[154]|0;g=f+(e<<5)|0;i=d;return g|0}function Se(a){a=a|0;c[136]=a;return}function Te(a){a=a|0;c[a+236>>2]=4;return}function Ue(a){a=a|0;var b=0,d=0;b=i;d=(c[842]|0)+192|0;c[152]=d;hg(d,4);c[a+776>>2]=0;c[a+780>>2]=1;c[a+244>>2]=5;c[a+252>>2]=0;c[a+772>>2]=0;c[a+256>>2]=0;c[a+784>>2]=0;c[a+788>>2]=0;c[a+236>>2]=0;c[a+828>>2]=0;c[a+808>>2]=0;c[a+816>>2]=0;c[a+852>>2]=9;i=b;return}function Ve(){return c[(c[136]|0)+776>>2]|0}function We(a){a=a|0;var d=0,f=0,g=0,h=0,j=0;d=i;f=(c[136]|0)+236|0;if((c[f>>2]|0)==4){i=d;return}c[156]=a;g=a+2|0;c[158]=g;h=b[a>>1]|0;b[300]=h;j=h&65535;c[144]=j&24576;c[146]=j&4095;if(h<<16>>16<0){c[148]=(e[a+4>>1]|0)<<16|(e[g>>1]|0);c[158]=a+6}else{c[158]=a+4;c[148]=e[g>>1]|0}c[f>>2]=0;i=d;return}function Xe(a){a=a|0;var d=0,f=0,g=0,h=0,j=0;d=i;f=(c[136]|0)+236|0;if((c[f>>2]|0)==4){c[f>>2]=7;i=d;return}c[156]=a;g=a+2|0;c[158]=g;h=b[a>>1]|0;b[300]=h;j=h&65535;c[144]=j&24576;c[146]=j&4095;if(h<<16>>16<0){c[148]=(e[a+4>>1]|0)<<16|(e[g>>1]|0);c[158]=a+6}else{c[158]=a+4;c[148]=e[g>>1]|0}c[f>>2]=0;c[f>>2]=7;i=d;return}function Ye(a){a=a|0;var d=0,f=0,g=0,h=0,j=0;d=i;i=i+32|0;f=d;g=c[156]|0;c[158]=g;c[f+4>>2]=g;g=c[136]|0;h=g+256|0;j=c[h>>2]|0;c[h>>2]=j+1;c[f>>2]=j;c[f+12>>2]=c[g+828>>2];c[f+8>>2]=0;Ei(256,f,20);f=(c[136]|0)+236|0;if((c[f>>2]|0)!=4){c[156]=a;g=a+2|0;c[158]=g;j=b[a>>1]|0;b[300]=j;h=j&65535;c[144]=h&24576;c[146]=h&4095;if(j<<16>>16<0){c[148]=(e[a+4>>1]|0)<<16|(e[g>>1]|0);c[158]=a+6}else{c[158]=a+4;c[148]=e[g>>1]|0}c[f>>2]=0}if((c[f>>2]|0)==4){i=d;return}c[f>>2]=0;i=d;return}function Ze(){var b=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;b=i;e=c[136]|0;f=c[e+16>>2]|0;g=(c[156]|0)-(c[e+8>>2]|0)>>1;if((a[f>>0]|0)==-1){h=-1;i=b;return h|0}else{j=0;k=0;l=0}a:while(1){e=j;m=k;b:while(1){n=e;while(1){o=n+1|0;p=d[f+n>>0]|0;if((p|0)==254){break}else if((p|0)==255){h=-1;q=13;break a}else if((p|0)==252){q=5;break b}else if((p|0)!=253){q=11;break b}n=n+6|0}r=d[f+(n+2)>>0]<<8|d[f+(n+3)>>0]<<16|d[f+o>>0];if((r|0)!=0){c[168]=r}e=n+6|0;m=d[f+(n+5)>>0]<<8|d[f+(n+4)>>0]}if((q|0)==5){q=0;e=(d[f+(n+2)>>0]<<8|d[f+o>>0])+l|0;if((g|0)<=(e|0)){h=m;q=13;break}s=n+3|0;t=e}else if((q|0)==11){q=0;e=p+l|0;if((g|0)>(e|0)){s=o;t=e}else{h=m;q=13;break}}j=s;k=m+1|0;l=t}if((q|0)==13){i=b;return h|0}return 0}function _e(){var b=0,e=0,f=0,g=0,h=0,j=0,k=0;b=i;c[170]=0;e=c[(c[136]|0)+16>>2]|0;if((a[e>>0]|0)==-1){f=-1;i=b;return f|0}else{g=0}while(1){h=e+g|0;j=d[h>>0]|0;if((j|0)==252){g=g+3|0;continue}else if((j|0)==254){g=g+6|0;continue}else if((j|0)==255){f=-1;k=7;break}else if((j|0)==253){break}else{g=g+1|0;continue}}if((k|0)==7){i=b;return f|0}c[170]=h;f=0;i=b;return f|0}function $e(a){a=a|0;var b=0,e=0,f=0,g=0;b=i;e=c[170]|0;if((e|0)==0){f=688;i=b;return f|0}g=a*6|0;f=(c[(c[136]|0)+12>>2]|0)+((d[e+(g+2)>>0]|0)<<8|(d[e+(g+3)>>0]|0)<<16|(d[e+(g|1)>>0]|0))|0;i=b;return f|0}function af(a){a=a|0;var b=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;e=c[170]|0;if((e|0)==0){f=-1;i=b;return f|0}g=c[136]|0;h=c[(c[g>>2]|0)+8>>2]|0;if((h|0)<=0){f=-1;i=b;return f|0}j=c[g+12>>2]|0;g=0;k=e;while(1){if((Cm(j+((d[k+2>>0]|0)<<8|(d[k+3>>0]|0)<<16|(d[k+1>>0]|0))|0,a)|0)==0){f=g;l=6;break}g=g+1|0;if((g|0)>=(h|0)){f=-1;l=6;break}else{k=k+6|0}}if((l|0)==6){i=b;return f|0}return 0}function bf(){return(c[(c[136]|0)+12>>2]|0)+(c[168]|0)|0}function cf(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;d=c[136]|0;e=c[d+240>>2]|0;if((e|0)<1){c[d+236>>2]=0;f=0;i=b;return f|0}else{c[d+248>>2]=(e*10|0)+a;f=2;i=b;return f|0}return 0}function df(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;d=c[136]|0;e=d+248|0;f=c[e>>2]|0;if((f|0)<0){g=d+252|0;h=c[g>>2]|0;if((h|0)==0){c[g>>2]=a;j=a}else{j=h}h=(c[d+240>>2]|0)+j|0;c[e>>2]=h;k=h}else{k=f}if((k|0)>(a|0)){l=2;i=b;return l|0}c[d+252>>2]=a;c[d+236>>2]=0;l=0;i=b;return l|0}function ef(){var a=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0;a=i;Ii();Bi();Yf();c[134]=c[842];c[166]=0;b[348]=13318;b[698>>1]=6;c[700>>2]=896;d=c[136]|0;c[704>>2]=c[d+824>>2];e=d+792|0;c[708>>2]=c[e>>2];c[728>>2]=d+788;c[732>>2]=c[e>>2];c[736>>2]=1;c[756>>2]=4;c[760>>2]=1;c[764>>2]=3;c[720>>2]=584;c[724>>2]=592;c[712>>2]=536;c[740>>2]=2;c[744>>2]=4;c[748>>2]=3;c[752>>2]=5;c[768>>2]=0;c[788>>2]=0;c[784>>2]=d;c[780>>2]=576;c[776>>2]=0;c[792>>2]=10;c[796>>2]=6;c[800>>2]=7;c[804>>2]=1;c[808>>2]=4;c[820>>2]=5;c[824>>2]=6;c[828>>2]=8;c[832>>2]=3;c[812>>2]=1;c[816>>2]=1;c[836>>2]=9;c[840>>2]=11;c[844>>2]=1;c[848>>2]=7;c[852>>2]=2;c[856>>2]=1;c[860>>2]=12;c[864>>2]=13;c[872>>2]=1;c[876>>2]=1;c[880>>2]=2;c[884>>2]=10;c[888>>2]=11;Mm(d+48|0,696,188)|0;c[d+876>>2]=696;d=Mi(576)|0;c[154]=d;c[164]=18;e=d;d=0;do{b[e+(d<<5)>>1]=d;b[e+(d<<5)+2>>1]=0;c[e+(d<<5)+4>>2]=c[136];c[e+(d<<5)+8>>2]=c[(c[136]|0)+876>>2];c[e+(d<<5)+12>>2]=2;c[e+(d<<5)+16>>2]=0;c[e+(d<<5)+20>>2]=0;c[e+(d<<5)+28>>2]=0;d=d+1|0;e=c[154]|0}while((d|0)<18);c[e+44>>2]=12;c[(c[154]|0)+172>>2]=12;c[(c[154]|0)+492>>2]=13;c[(c[154]|0)+364>>2]=14;c[(c[154]|0)+464>>2]=2;Qf((c[154]|0)+256|0);Tf((c[154]|0)+416|0);Tf((c[154]|0)+416|0);e=c[154]|0;c[e+396>>2]=15;c[e+400>>2]=3;c[(c[136]|0)+24>>2]=0;e=c[136]|0;c[e+28>>2]=0;d=e;e=0;f=1;while(1){g=e+1|0;c[d+28>>2]=g;h=c[d+24>>2]|0;if((h|0)==0){j=Mi(24)|0;c[(c[136]|0)+24>>2]=j}else{j=Pi(h,g*24|0)|0;c[(c[136]|0)+24>>2]=j}j=c[(c[136]|0)+24>>2]|0;b[j+(e*24|0)>>1]=1;b[j+(e*24|0)+2>>1]=0;c[j+(e*24|0)+4>>2]=-1;c[j+(e*24|0)+12>>2]=0;c[j+(e*24|0)+16>>2]=0;c[j+(e*24|0)+20>>2]=0;k=c[136]|0;if((f|0)==5){break}d=k;e=c[k+28>>2]|0;f=f+1|0}b[(c[k+24>>2]|0)+96>>1]=2;c[164]=18;k=Mi(4096)|0;c[(c[136]|0)+792>>2]=k;k=Mi(256)|0;c[(c[136]|0)+796>>2]=k;k=Mi(4096)|0;c[(c[136]|0)+824>>2]=k;k=Mi(1024)|0;c[(c[136]|0)+872>>2]=k;c[170]=0;c[226]=0;c[932>>2]=c[136];c[916>>2]=0;c[920>>2]=0;c[936>>2]=16;c[940>>2]=4;c[944>>2]=14;c[948>>2]=2;c[952>>2]=17;i=a;return}function ff(){var a=0,d=0,e=0,f=0,g=0,h=0;a=i;i=i+16|0;d=Ee(528)|0;e=c[132]|0;f=b[e>>1]|0;g=c[844]|0;h=c[g+(f*140|0)+64>>2]|0;c[e+40>>2]=d;d=Nd[c[g+(f*140|0)+28>>2]&63](e)|0;f=Fd[h&15](e,d,a)|0;c[(c[136]|0)+64>>2]=528;i=a;return f|0}function gf(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;e=i;c[a+40>>2]=0;f=Nd[c[(c[844]|0)+((b[a>>1]<<16>>16)*140|0)+28>>2]&63](a)|0;Od[c[(c[844]|0)+((b[a>>1]<<16>>16)*140|0)+68>>2]&15](a,f,d);i=e;return 0}function hf(a){a=a|0;return(c[844]|0)+(a*140|0)|0}function jf(){var a=0,b=0;a=i;c[(c[136]|0)+64>>2]=536;b=ue()|0;i=a;return b|0}function kf(){var a=0,d=0,e=0,f=0,g=0;a=i;d=c[136]|0;e=d+28|0;f=c[e>>2]|0;g=f+1|0;c[e>>2]=g;e=c[d+24>>2]|0;if((e|0)==0){d=Mi(24)|0;c[(c[136]|0)+24>>2]=d}else{d=Pi(e,g*24|0)|0;c[(c[136]|0)+24>>2]=d}d=c[(c[136]|0)+24>>2]|0;g=d+(f*24|0)|0;b[g>>1]=1;b[d+(f*24|0)+2>>1]=0;c[d+(f*24|0)+4>>2]=-1;c[d+(f*24|0)+12>>2]=0;c[d+(f*24|0)+16>>2]=0;c[d+(f*24|0)+20>>2]=0;i=a;return g|0}function lf(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=i;j=b[960+(a<<1)>>1]|0;k=c[164]|0;a:do{if((k|0)>18){l=k;m=18;while(1){n=c[154]|0;if(!((b[n+(m<<5)+2>>1]&j)<<16>>16==0)?(o=c[n+(m<<5)+28>>2]|0,(o|0)!=0):0){n=Qd[o&3](a,d,f,g)|0;if((n|0)!=0){p=n;break}q=c[164]|0}else{q=l}m=m+1|0;if((m|0)>=(q|0)){break a}else{l=q}}i=h;return p|0}}while(0);do{switch(a|0){case 8:{q=ge(c[(c[136]|0)+796>>2]|0)|0;c[(c[136]|0)+788>>2]=q;p=0;i=h;return p|0};case 5:{Km(c[(c[136]|0)+796>>2]|0,g|0,255)|0;p=0;i=h;return p|0};case 11:{if((bl(c[(c[136]|0)+796>>2]|0)|0)==0){p=0;i=h;return p|0}else{q=dc(4)|0;c[q>>2]=12;td(q|0,568,0)}break};case 2:{q=c[136]|0;c[q+32>>2]=c[g+12>>2];c[q+36>>2]=d;c[q+40>>2]=f;j=g+2|0;k=b[j>>1]|0;if(k<<16>>16==0){l=c[g+16>>2]|0;m=q+236|0;if((c[m>>2]|0)==4){r=0}else{c[156]=l;q=l+2|0;c[158]=q;n=b[l>>1]|0;b[300]=n;o=n&65535;c[144]=o&24576;c[146]=o&4095;if(n<<16>>16<0){c[148]=(e[l+4>>1]|0)<<16|(e[q>>1]|0);c[158]=l+6}else{c[158]=l+4;c[148]=e[q>>1]|0}c[m>>2]=0;r=b[j>>1]|0}c[m>>2]=7;s=r}else{s=k}if(!(s<<16>>16==1)){p=0;i=h;return p|0}c[158]=c[156];Ye(c[g+16>>2]|0);p=0;i=h;return p|0};case 7:{k=Yk(c[(c[136]|0)+796>>2]|0,g,f,d)|0;if((k|0)<0){m=dc(4)|0;c[m>>2]=12;td(m|0,568,0)}c[(c[136]|0)+788>>2]=k;p=0;i=h;return p|0};case 6:{k=fe(c[(c[136]|0)+796>>2]|0,g,f,d)|0;if((k|0)<0){m=dc(4)|0;c[m>>2]=12;td(m|0,568,0)}c[(c[136]|0)+788>>2]=k;p=0;i=h;return p|0};case 9:{if((cl(c[(c[136]|0)+796>>2]|0)|0)==0){k=dc(4)|0;c[k>>2]=12;td(k|0,568,0)}else{p=0;i=h;return p|0}break};case 10:{if((al(c[(c[136]|0)+796>>2]|0)|0)==0){p=0;i=h;return p|0}else{k=dc(4)|0;c[k>>2]=12;td(k|0,568,0)}break};case 12:{if((ie(c[(c[136]|0)+796>>2]|0,g)|0)==0){p=0;i=h;return p|0}else{k=dc(4)|0;c[k>>2]=12;td(k|0,568,0)}break};case 13:{c[250]=Mi(4096)|0;k=dl(c[(c[136]|0)+796>>2]|0,1e3,d)|0;c[(c[136]|0)+784>>2]=k;c[g>>2]=c[250];p=0;i=h;return p|0};case 14:{Oi(c[250]|0);p=0;i=h;return p|0};default:{p=0;i=h;return p|0}}}while(0);return 0}function mf(a,d){a=a|0;d=d|0;b[(c[(c[136]|0)+24>>2]|0)+(a*24|0)>>1]=(d|0)==0?1:2;return}function nf(a){a=a|0;var b=0;a=i;b=Mi(16384)|0;c[256]=b;i=a;return b|0}function of(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;g=i;i=i+3856|0;h=g+1024|0;j=g;k=g+3336|0;l=g+3080|0;m=g+3072|0;c[256]=Mi(16384)|0;n=c[136]|0;o=c[(c[n>>2]|0)+8>>2]|0;p=(o|0)>0;if((e|0)==0){if(!p){q=c[256]|0;i=g;return q|0}if((f&2|0)==0){r=0;do{t=c[170]|0;if((t|0)==0){u=688}else{v=r*6|0;u=(c[(c[136]|0)+12>>2]|0)+(d[t+(v+2)>>0]<<8|d[t+(v+3)>>0]<<16|d[t+(v|1)>>0])|0}if(!((Zk(u,1032)|0)!=0|(u|0)==0)){Ri(1024,u);Ri(1024,1008)}r=r+1|0}while((r|0)!=(o|0));q=c[256]|0;i=g;return q|0}else{r=0;do{u=c[170]|0;if((u|0)==0){w=688}else{v=r*6|0;w=(c[(c[136]|0)+12>>2]|0)+(d[u+(v+2)>>0]<<8|d[u+(v+3)>>0]<<16|d[u+(v|1)>>0])|0}if((w|0)!=0){Ri(1024,w);Ri(1024,1008)}r=r+1|0}while((r|0)!=(o|0));q=c[256]|0;i=g;return q|0}}a:do{if(p){r=c[170]|0;w=n+12|0;if((r|0)==0){v=0;while(1){u=v+1|0;if((a[e>>0]|0)==0){x=v;y=688;break a}if((u|0)<(o|0)){v=u}else{x=u;y=688;break}}}else{v=0;while(1){u=v*6|0;t=(c[w>>2]|0)+(d[r+(u+2)>>0]<<8|d[r+(u+3)>>0]<<16|d[r+(u|1)>>0])|0;u=v+1|0;if((Cm(t,e)|0)==0){x=v;y=t;break a}if((u|0)<(o|0)){v=u}else{x=u;y=t;break}}}}else{x=0;y=0}}while(0);o=c[n+44>>2]|0;n=o+(x*48|0)|0;e=b[n>>1]|0;p=c[844]|0;Km(h|0,1040,64)|0;v=h+(Jm(h|0)|0)|0;a[v>>0]=58;a[v+1>>0]=0;tl(h,y,1973)|0;y=h+(Jm(h|0)|0)|0;a[y+0>>0]=a[1008>>0]|0;a[y+1>>0]=a[1009>>0]|0;a[y+2>>0]=a[1010>>0]|0;Ri(1024,h);y=c[p+(e*140|0)+12>>2]|0;Km(h|0,1048,64)|0;v=h+(Jm(h|0)|0)|0;a[v>>0]=58;a[v+1>>0]=0;tl(h,y,1973)|0;y=h+(Jm(h|0)|0)|0;a[y+0>>0]=a[1008>>0]|0;a[y+1>>0]=a[1009>>0]|0;a[y+2>>0]=a[1010>>0]|0;Ri(1024,h);y=o+(x*48|0)+8|0;v=c[o+(x*48|0)+12>>2]|0;r=c[o+(x*48|0)+16>>2]|0;w=c[o+(x*48|0)+20>>2]|0;c[h>>2]=c[y>>2];c[h+4>>2]=v;c[h+8>>2]=r;c[h+12>>2]=w;qm(l,1056,h)|0;Km(h|0,1072,64)|0;w=h+(Jm(h|0)|0)|0;a[w>>0]=58;a[w+1>>0]=0;tl(h,l,1973)|0;w=h+(Jm(h|0)|0)|0;a[w+0>>0]=a[1008>>0]|0;a[w+1>>0]=a[1009>>0]|0;a[w+2>>0]=a[1010>>0]|0;Ri(1024,h);c[h>>2]=b[o+(x*48|0)+2>>1]|0;qm(j,1016,h)|0;Km(h|0,1080,64)|0;w=h+(Jm(h|0)|0)|0;a[w>>0]=58;a[w+1>>0]=0;tl(h,j,1973)|0;w=h+(Jm(h|0)|0)|0;a[w+0>>0]=a[1008>>0]|0;a[w+1>>0]=a[1009>>0]|0;a[w+2>>0]=a[1010>>0]|0;Ri(1024,h);c[h>>2]=c[o+(x*48|0)+24>>2];qm(j,1016,h)|0;Km(h|0,1088,64)|0;w=h+(Jm(h|0)|0)|0;a[w>>0]=58;a[w+1>>0]=0;tl(h,j,1973)|0;w=h+(Jm(h|0)|0)|0;a[w+0>>0]=a[1008>>0]|0;a[w+1>>0]=a[1009>>0]|0;a[w+2>>0]=a[1010>>0]|0;Ri(1024,h);w=o+(x*48|0)+40|0;c[w>>2]=0;b[o+(x*48|0)+38>>1]=0;x=Nd[c[p+(e*140|0)+28>>2]&63](n)|0;o=Fd[c[p+(e*140|0)+64>>2]&15](n,x,m)|0;c[h>>2]=c[m>>2];qm(j,1016,h)|0;Km(h|0,1104,64)|0;e=h+(Jm(h|0)|0)|0;a[e>>0]=58;a[e+1>>0]=0;tl(h,j,1973)|0;e=h+(Jm(h|0)|0)|0;a[e+0>>0]=a[1008>>0]|0;a[e+1>>0]=a[1009>>0]|0;a[e+2>>0]=a[1010>>0]|0;Ri(1024,h);e=b[n>>1]|0;p=e<<16>>16;if((p+ -2|0)>>>0<3){if(e<<16>>16==2){z=o}else{z=Sd[c[(c[844]|0)+300>>2]&15](x,p)|0}e=Jm(z|0)|0;if((e|0)>1023){Km(c[(c[136]|0)+824>>2]|0,z|0,1023)|0;r=c[(c[136]|0)+824>>2]|0;a[r+1023>>0]=0;c[h>>2]=e;qm(l,1120,h)|0;Ri(1024,l);A=r}else{A=z}Km(h|0,1160,64)|0;z=h+(Jm(h|0)|0)|0;a[z+0>>0]=a[1008>>0]|0;a[z+1>>0]=a[1009>>0]|0;a[z+2>>0]=a[1010>>0]|0;tl(h,A,1973)|0;A=h+(Jm(h|0)|0)|0;a[A+0>>0]=a[1008>>0]|0;a[A+1>>0]=a[1009>>0]|0;a[A+2>>0]=a[1010>>0]|0;Ri(1024,h)}else{do{if((p|0)==5){A=b[x>>1]|0;if(A<<16>>16==0){B=j+0|0;C=1240|0;D=B+15|0;do{a[B>>0]=a[C>>0]|0;B=B+1|0;C=C+1|0}while((B|0)<(D|0));break}else{z=b[x+4>>1]|0;r=c[x+12>>2]|0;l=c[x+8>>2]|0;c[h>>2]=b[x+2>>1]|0;c[h+4>>2]=z;c[h+8>>2]=r;c[h+12>>2]=l;c[h+16>>2]=A<<16>>16;qm(j,1256,h)|0;break}}else if((p|0)==1){c[h>>2]=c[x>>2];qm(j,1224,h)|0}else if((p|0)==6){c[h>>2]=c[x>>2];qm(j,1296,h)|0}else{l=j;c[l>>2]=1852534357;c[l+4>>2]=7239535}}while(0);Km(h|0,1160,64)|0;x=h+(Jm(h|0)|0)|0;a[x+0>>0]=a[1008>>0]|0;a[x+1>>0]=a[1009>>0]|0;a[x+2>>0]=a[1010>>0]|0;tl(h,j,1973)|0;x=h+(Jm(h|0)|0)|0;a[x+0>>0]=a[1008>>0]|0;a[x+1>>0]=a[1009>>0]|0;a[x+2>>0]=a[1010>>0]|0;Ri(1024,h)}if((f&4|0)!=0?(x=c[y>>2]|0,(x|0)>=2):0){if((x|0)>16){Ri(1024,1184);E=16}else{E=x}x=0;do{c[w>>2]=x;y=Nd[c[(c[844]|0)+((b[n>>1]<<16>>16)*140|0)+28>>2]&63](n)|0;s=0;p=wa(c[(c[844]|0)+300>>2]|0,y|0,b[n>>1]|0)|0;l=s;s=0;if(l&1){l=ub(-1,-1,0)|0;Qa(l|0)|0;l=b[n>>1]|0;do{if((l|0)==5){r=b[y>>1]|0;if(r<<16>>16==0){B=j+0|0;C=1240|0;D=B+15|0;do{a[B>>0]=a[C>>0]|0;B=B+1|0;C=C+1|0}while((B|0)<(D|0));break}else{z=b[y+4>>1]|0;e=c[y+12>>2]|0;v=c[y+8>>2]|0;c[h>>2]=b[y+2>>1]|0;c[h+4>>2]=z;c[h+8>>2]=e;c[h+12>>2]=v;c[h+16>>2]=r<<16>>16;qm(j,1256,h)|0;break}}else if((l|0)==1){c[h>>2]=c[y>>2];qm(j,1224,h)|0}else if((l|0)==6){c[h>>2]=c[y>>2];qm(j,1296,h)|0}else{v=j;c[v>>2]=1852534357;c[v+4>>2]=7239535}}while(0);c[h>>2]=x;c[h+4>>2]=j;qm(k,1208,h)|0;oc()}else{if((Jm(p|0)|0)>>>0>63){Km(c[(c[136]|0)+824>>2]|0,p|0,63)|0;a[(c[(c[136]|0)+824>>2]|0)+64>>0]=0;F=c[(c[136]|0)+824>>2]|0}else{F=p}c[h>>2]=x;c[h+4>>2]=F;qm(k,1208,h)|0}Ri(1024,k);x=x+1|0}while((x|0)!=(E|0))}if((f&8|0)==0){q=c[256]|0;i=g;return q|0}f=c[m>>2]|0;if((f|0)>4096){c[m>>2]=4096;G=4096}else{G=f}if((G|0)>0){H=0}else{q=c[256]|0;i=g;return q|0}while(1){c[h>>2]=H;qm(j,1168,h)|0;if((H|0)<(G|0)){f=H-G|0;m=f>>>0>4294967288?f:-8;f=0-m|0;E=H;x=0;while(1){c[h>>2]=d[o+E>>0]|0;qm(k,1176,h)|0;Pm(j|0,k|0)|0;x=x+1|0;if((x|0)==(f|0)){break}else{E=E+1|0}}I=H-m|0}else{I=H}E=j+(Jm(j|0)|0)|0;a[E+0>>0]=a[1008>>0]|0;a[E+1>>0]=a[1009>>0]|0;a[E+2>>0]=a[1010>>0]|0;Ri(1024,j);if((I|0)<(G|0)){H=I}else{break}}q=c[256]|0;i=g;return q|0}function pf(a){a=a|0;a=i;Oi(c[256]|0);i=a;return}function qf(){var a=0,b=0;a=i;b=c[156]|0;c[156]=c[158];c[916>>2]=Ze()|0;c[920>>2]=(c[(c[136]|0)+12>>2]|0)+(c[168]|0);c[156]=b;i=a;return}function rf(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;d=(c[136]|0)+236|0;e=c[d>>2]|0;if((e|0)==2|(e|0)==1){if((a|0)==2){c[d>>2]=3;c[226]=0;f=0}else{f=-1}}else if((e|0)==3?(a|0)!=2:0){c[d>>2]=0;c[226]=(a|0)==1?0:a;f=0}else{f=-1}i=b;return f|0}function sf(){var a=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;d=c[136]|0;e=c[(c[d>>2]|0)+8>>2]|0;a:do{if((e|0)>0){f=0;g=c[d+44>>2]|0;b:while(1){if(((b[g>>1]|0)==5?(b[g+2>>1]|0)==1:0)?(h=g+8|0,(c[h>>2]|0)>0):0){j=0;do{s=0;qa(3,g|0,j|0);k=s;s=0;if(k&1){break b}j=j+1|0}while((j|0)<(c[h>>2]|0))}f=f+1|0;if((f|0)>=(e|0)){break a}else{g=g+48|0}}g=ub(-1,-1,0)|0;Qa(g|0)|0;oc()}}while(0);e=c[136]|0;d=c[(c[e>>2]|0)+60>>2]|0;c:do{if(!(d>>>0<28)){g=(d>>>0)/28|0;f=e;while(1){h=g+ -1|0;j=c[f+840>>2]|0;if(((b[j+(h*28|0)>>1]|0)==-1?(c[j+(h*28|0)+24>>2]&65536|0)!=0:0)?(s=0,oa(15,h|0),j=s,s=0,j&1):0){break}if((g|0)<2){break c}g=h;f=c[136]|0}f=ub(-1,-1,0)|0;Qa(f|0)|0;oc()}}while(0);e=c[164]|0;if((e|0)>0){l=e}else{i=a;return}do{l=l+ -1|0;e=c[(c[154]|0)+(l<<5)+20>>2]|0;if((e|0)!=0){Nd[e&63](0)|0}}while((l|0)>0);i=a;return}function tf(){var a=0,b=0,d=0,e=0;a=i;Zf();b=c[136]|0;d=c[b+24>>2]|0;if((d|0)==0){e=b}else{Oi(d);e=c[136]|0}Oi(c[e+872>>2]|0);Oi(c[(c[136]|0)+824>>2]|0);Oi(c[(c[136]|0)+796>>2]|0);Oi(c[(c[136]|0)+792>>2]|0);Oi(c[154]|0);Ci();Ki();i=a;return}function uf(){var a=0,d=0,f=0,g=0,h=0,j=0,k=0;a=i;d=c[984]|0;if((d|0)==(c[982]|0)){f=dc(4)|0;c[f>>2]=10;td(f|0,568,0)}f=c[d+ -68>>2]|0;if((b[d+ -72>>1]|0)==257?(d=c[f+8>>2]|0,g=d+8|0,(c[g>>2]|0)>0):0){h=0;j=(c[(c[136]|0)+836>>2]|0)+(c[d+4>>2]<<3)|0;while(1){d=b[j>>1]|0;if(d<<16>>16==-1){k=f+((c[j+4>>2]|0)+20)|0;Kd[c[(c[844]|0)+((b[k>>1]<<16>>16)*140|0)+52>>2]&31](k)}else if(d<<16>>16==-6){Oi(c[f+((c[j+4>>2]|0)+20)>>2]|0)}h=h+1|0;if((h|0)>=(c[g>>2]|0)){break}else{j=j+8|0}}}c[158]=c[f+4>>2];c[(c[136]|0)+828>>2]=c[f+12>>2];f=(c[136]|0)+256|0;c[f>>2]=(c[f>>2]|0)+ -1;f=c[158]|0;c[156]=f;j=f+2|0;c[158]=j;g=b[f>>1]|0;b[300]=g;h=g&65535;c[144]=h&24576;c[146]=h&4095;if(g<<16>>16<0){c[148]=e[f+4>>1]<<16|e[j>>1];c[158]=f+6}else{c[158]=f+4;c[148]=e[j>>1]|0}j=c[984]|0;c[984]=j+ -72;if((b[j+ -70>>1]|0)==0){i=a;return}Hi();i=a;return}function vf(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;c[(c[136]|0)+848>>2]=0;a:while(1){if((c[a>>2]|0)==0){e=c[136]|0;c[e+772>>2]=0;c[e+256>>2]=0;Di();c[a>>2]=1}if(!(((c[226]|0)!=0?(e=c[916>>2]|0,f=c[156]|0,c[156]=c[158],g=Ze()|0,c[916>>2]=g,h=c[136]|0,c[920>>2]=(c[h+12>>2]|0)+(c[168]|0),c[156]=f,(e|0)!=(g|0)):0)?(c[h+236>>2]=3,s=0,oa(c[h+852>>2]|0,h|0),h=s,s=0,h&1):0)){j=10}do{if((j|0)==10?(j=0,s=0,h=ra(c[(c[154]|0)+(c[146]<<5)+12>>2]|0,c[148]|0)|0,g=s,s=0,!(g&1)):0){if((h|0)==0){j=16;break a}h=c[136]|0;if((c[h+236>>2]|0)==6){s=0;ta(3);g=s;s=0;if(g&1){break}else{j=15;break a}}else{s=0;oa(c[h+852>>2]|0,h|0);h=s;s=0;if(h&1){break}else{j=15;break a}}}}while(0);h=ub(-1,-1,568,0)|0;g=H;e=(g|0)==(Yc(568)|0);g=Qa(h|0)|0;if(!e){j=9;break}k=c[g>>2]|0;if((k|0)==43){l=10;j=25;break}else if((k|0)==0){j=24;break}else if((k|0)!=42){j=17;break}oc()}if((j|0)==9){c[(c[136]|0)+776>>2]=1;oc();m=5;i=d;return m|0}else if((j|0)==15){if((c[(c[136]|0)+236>>2]|0)==4){m=4;i=d;return m|0}else{j=16}}else if((j|0)==17){g=c[136]|0;c[g+776>>2]=k;c[g+236>>2]=5;if((b[(c[g+24>>2]|0)+24>>1]|0)==2){g=Ze()|0;e=c[(c[136]|0)+24>>2]|0;c[e+36>>2]=0;s=0;ua(2,2,k|0,g|0,e+24|0)|0;e=s;s=0;if(e&1){e=ub(-1,-1)|0;oc();Cb(e|0)}if((c[(c[136]|0)+236>>2]|0)==5){n=5}else{c[a>>2]=0;n=0}oc();m=n;i=d;return m|0}else{l=5;j=25}}else if((j|0)==24){l=4;j=25}if((j|0)==16){m=0;i=d;return m|0}else if((j|0)==25){oc();c[(c[136]|0)+236>>2]=l;m=l;i=d;return m|0}return 0}function wf(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[(c[136]|0)+24>>2]|0;b[g+(a*24|0)>>1]=2;b[g+(a*24|0)+2>>1]=d;c[g+(a*24|0)+16>>2]=f;c[g+(a*24|0)+4>>2]=e;return}function xf(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=c[136]|0;g=c[f+28>>2]|0;if((g|0)<=0){h=0;i=e;return h|0}j=c[f+24>>2]|0;f=0;while(1){k=j+(f*24|0)|0;if((((b[k>>1]|0)!=0?(c[j+(f*24|0)+4>>2]|0)==(d|0):0)?(c[j+(f*24|0)+8>>2]|0)==(a|0):0)?(b[j+(f*24|0)+2>>1]|0)!=2:0){h=k;l=8;break}f=f+1|0;if((f|0)>=(g|0)){h=0;l=8;break}}if((l|0)==8){i=e;return h|0}return 0}function yf(a){a=a|0;var d=0,f=0,g=0,h=0,j=0;d=i;f=c[158]|0;c[156]=f;g=f+2|0;c[158]=g;h=b[f>>1]|0;b[300]=h;j=h&65535;c[144]=j&24576;c[146]=j&4095;if(h<<16>>16<0){c[148]=e[f+4>>1]<<16|e[g>>1];c[158]=f+6}else{c[158]=f+4;c[148]=e[g>>1]|0}if((b[(c[(c[136]|0)+840>>2]|0)+(a*28|0)>>1]|0)==-1){Ne(a);i=d;return 0}else{d=dc(4)|0;c[d>>2]=2;td(d|0,568,0)}return 0}function zf(a,d){a=a|0;d=d|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;if(!((b[(c[(c[136]|0)+840>>2]|0)+(d*28|0)>>1]|0)==-2)){g=dc(4)|0;c[g>>2]=2;td(g|0,568,0)}g=c[328]|0;c[328]=-1;if((c[146]|0)!=0){h=dc(4)|0;c[h>>2]=32;td(h|0,568,0)}if((c[148]|0)!=40){h=dc(4)|0;c[h>>2]=32;td(h|0,568,0)}h=c[158]|0;c[156]=h;j=h+2|0;c[158]=j;k=b[h>>1]|0;b[300]=k;l=k&65535;c[144]=l&24576;c[146]=l&4095;if(k<<16>>16<0){c[148]=e[h+4>>1]<<16|e[j>>1];c[158]=h+6}else{c[158]=h+4;c[148]=e[j>>1]|0}Ne(d);c[a>>2]=c[328];a=c[328]|0;if((a|0)==4){m=(c[136]|0)+784|0}else if((a|0)==3){m=(c[136]|0)+864|0}else if((a|0)!=2){a=(c[(c[136]|0)+236>>2]|0)==4;d=dc(4)|0;if(a){c[d>>2]=0;td(d|0,568,0)}else{c[d>>2]=40;td(d|0,568,0)}}else{m=c[(c[136]|0)+792>>2]|0}if((c[146]|0)!=0){d=dc(4)|0;c[d>>2]=32;td(d|0,568,0)}if((c[148]|0)!=41){d=dc(4)|0;c[d>>2]=32;td(d|0,568,0)}d=c[158]|0;c[156]=d;a=d+2|0;c[158]=a;j=b[d>>1]|0;b[300]=j;h=j&65535;c[144]=h&24576;c[146]=h&4095;if(j<<16>>16<0){c[148]=e[d+4>>1]<<16|e[a>>1];c[158]=d+6;c[328]=g;i=f;return m|0}else{c[158]=d+4;c[148]=e[a>>1]|0;c[328]=g;i=f;return m|0}return 0}function Af(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;c[a>>2]=4;do{switch(b|0){case 2:{c[330]=13318;e=1320;break};case 6:{c[330]=c[(c[136]|0)+788>>2];e=1320;break};case 12:{c[a>>2]=2;e=c[(c[136]|0)+792>>2]|0;break};case 10:{c[330]=c[(c[136]|0)+36>>2];e=1320;break};case 7:{c[330]=c[(c[136]|0)+772>>2];e=1320;break};case 8:{c[330]=c[(c[136]|0)+256>>2];e=1320;break};case 0:{c[330]=0;e=1320;break};case 3:{c[330]=c[(c[136]|0)+784>>2];e=1320;break};case 13:{c[a>>2]=3;e=(c[136]|0)+864|0;break};case 1:{c[330]=c[(c[136]|0)+780>>2];e=1320;break};case 5:{c[330]=c[(c[136]|0)+776>>2];e=1320;break};case 9:{c[330]=c[(c[136]|0)+32>>2];e=1320;break};case 11:{c[330]=c[(c[136]|0)+40>>2];e=1320;break};case 4:{f=c[136]|0;c[330]=c[f+(c[f+772>>2]<<4)+264>>2];e=1320;break};default:{f=dc(4)|0;c[f>>2]=21;td(f|0,568,0)}}}while(0);i=d;return e|0}function Bf(a){a=a|0;var d=0,f=0,g=0,j=0,k=0,l=0,m=0;a=i;d=c[158]|0;f=e[d>>1]|0;g=d+2|0;c[158]=g;j=d+(f+1<<1)|0;if((c[148]|0)==0){c[156]=g;k=d+4|0;c[158]=k;l=b[g>>1]|0;b[300]=l;g=l&65535;c[144]=g&24576;c[146]=g&4095;if(l<<16>>16<0){c[148]=(e[d+6>>1]|0)<<16|(e[k>>1]|0);c[158]=d+8}else{c[158]=d+6;c[148]=e[k>>1]|0}if((ue()|0)<-1){k=dc(4)|0;c[k>>2]=5;td(k|0,568,0)}k=c[134]|0;l=b[k>>1]|0;if(l<<16>>16==3){m=~~+h[c[k+28>>2]>>3]}else if(l<<16>>16==4){m=c[c[k+28>>2]>>2]|0}else{k=dc(4)|0;c[k>>2]=6;td(k|0,568,0)}if((m|0)!=0){i=a;return 0}}c[156]=j;m=d+(f+2<<1)|0;c[158]=m;k=b[j>>1]|0;b[300]=k;j=k&65535;c[144]=j&24576;c[146]=j&4095;if(k<<16>>16<0){c[148]=(e[d+(f+3<<1)>>1]|0)<<16|(e[m>>1]|0);c[158]=d+(f+4<<1);i=a;return 0}else{c[158]=d+(f+3<<1);c[148]=e[m>>1]|0;i=a;return 0}return 0}function Cf(a){a=a|0;var d=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0;d=i;i=i+48|0;f=d+24|0;g=d;j=d+4|0;k=d+8|0;l=d+12|0;m=d+16|0;n=d+20|0;o=c[158]|0;c[156]=o;p=o+2|0;c[158]=p;q=b[o>>1]|0;b[300]=q;r=q&65535;c[144]=r&24576;c[146]=r&4095;if(q<<16>>16<0){c[148]=e[o+4>>1]<<16|e[p>>1];c[158]=o+6}else{c[158]=o+4;c[148]=e[p>>1]|0}a:do{switch(a|0){case 4:{if((c[(c[136]|0)+772>>2]|0)>30){p=dc(4)|0;c[p>>2]=9;td(p|0,568,0)}p=Ge()|0;o=c[158]|0;c[156]=o;q=o+2|0;c[158]=q;r=b[o>>1]|0;b[300]=r;s=r&65535;c[144]=s&24576;c[146]=s&4095;if(r<<16>>16<0){c[148]=e[o+4>>1]<<16|e[q>>1];c[158]=o+6}else{c[158]=o+4;c[148]=e[q>>1]|0}do{if(!((ue()|0)<-1)){q=c[134]|0;o=b[q>>1]|0;if(o<<16>>16==4){t=c[c[q+28>>2]>>2]|0;break}else if(o<<16>>16==3){t=~~+h[c[q+28>>2]>>3];break}else{q=dc(4)|0;c[q>>2]=6;td(q|0,568,0)}}else{t=-2147483648}}while(0);c[332]=t;do{if(!((ue()|0)<-1)){q=c[134]|0;o=b[q>>1]|0;if(o<<16>>16==3){u=~~+h[c[q+28>>2]>>3];break}else if(o<<16>>16==4){u=c[c[q+28>>2]>>2]|0;break}else{q=dc(4)|0;c[q>>2]=6;td(q|0,568,0)}}else{u=0}}while(0);c[334]=u;q=c[332]|0;if((q|0)!=0){c[332]=(q|0)<0?-2147483648:q+u|0;q=c[136]|0;o=q+772|0;r=(c[o>>2]|0)+1|0;c[o>>2]=r;c[q+(r<<4)+264>>2]=c[334];c[q+(r<<4)+260>>2]=c[332];c[q+(r<<4)+272>>2]=c[156];v=0;i=d;return v|0}c[156]=p;r=p+2|0;c[158]=r;q=b[p>>1]|0;b[300]=q;o=q&65535;c[144]=o&24576;c[146]=o&4095;if(q<<16>>16<0){c[148]=e[p+4>>1]<<16|e[r>>1];c[158]=p+6;v=0;i=d;return v|0}else{c[158]=p+4;c[148]=e[r>>1]|0;v=0;i=d;return v|0}break};case 1:{r=Ge()|0;c[f+4>>2]=c[158];q=c[136]|0;o=q+256|0;s=c[o>>2]|0;c[o>>2]=s+1;c[f>>2]=s;c[f+12>>2]=c[q+828>>2];c[f+8>>2]=0;Ei(256,f,20);q=(c[136]|0)+236|0;if((c[q>>2]|0)==4){v=0;i=d;return v|0}c[156]=r;s=r+2|0;c[158]=s;o=b[r>>1]|0;b[300]=o;w=o&65535;c[144]=w&24576;c[146]=w&4095;if(o<<16>>16<0){c[148]=e[r+4>>1]<<16|e[s>>1];c[158]=r+6}else{c[158]=r+4;c[148]=e[s>>1]|0}c[q>>2]=0;v=0;i=d;return v|0};case 2:{do{if((c[(c[136]|0)+828>>2]|0)!=0?!((ue()|0)<-1):0){q=c[136]|0;c[q+844>>2]=c[q+256>>2];s=c[134]|0;r=b[s>>1]|0;c[328]=r;if((r|0)==3){h[q+864>>3]=+h[c[s+28>>2]>>3];break}else if((r|0)==4){c[q+784>>2]=c[c[s+28>>2]>>2];break}else if((r|0)==2){Qi(q+792|0,c[s+28>>2]|0);break}else{s=dc(4)|0;c[s>>2]=6;td(s|0,568,0)}}}while(0);c[(c[136]|0)+236>>2]=6;v=6;i=d;return v|0};case 0:{p=Ge()|0;c[156]=p;s=p+2|0;c[158]=s;q=b[p>>1]|0;b[300]=q;r=q&65535;c[144]=r&24576;c[146]=r&4095;if(q<<16>>16<0){c[148]=e[p+4>>1]<<16|e[s>>1];c[158]=p+6;v=0;i=d;return v|0}else{c[158]=p+4;c[148]=e[s>>1]|0;v=0;i=d;return v|0}break};case 3:{s=(c[136]|0)+772|0;p=c[s>>2]|0;if((p|0)==0){q=dc(4)|0;c[q>>2]=11;td(q|0,568,0)}c[s>>2]=p+ -1;p=Ge()|0;c[156]=p;s=p+2|0;c[158]=s;q=b[p>>1]|0;b[300]=q;r=q&65535;c[144]=r&24576;c[146]=r&4095;if(q<<16>>16<0){c[148]=e[p+4>>1]<<16|e[s>>1];c[158]=p+6;v=0;i=d;return v|0}else{c[158]=p+4;c[148]=e[s>>1]|0;v=0;i=d;return v|0}break};case 5:{s=c[136]|0;p=s+772|0;q=c[p>>2]|0;if((q|0)==0){r=dc(4)|0;c[r>>2]=11;td(r|0,568,0)}r=s+(q<<4)+264|0;o=(c[r>>2]|0)+1|0;c[r>>2]=o;r=c[s+(q<<4)+260>>2]|0;if(!((r|0)==-2147483648|(o|0)<(r|0))){c[p>>2]=q+ -1;v=0;i=d;return v|0}p=c[s+(q<<4)+272>>2]|0;c[156]=p;q=p+2|0;c[158]=q;s=b[p>>1]|0;b[300]=s;r=s&65535;c[144]=r&24576;c[146]=r&4095;if(s<<16>>16<0){c[148]=e[p+4>>1]<<16|e[q>>1];c[158]=p+6;v=0;i=d;return v|0}else{c[158]=p+4;c[148]=e[q>>1]|0;v=0;i=d;return v|0}break};case 6:{q=Ge()|0;p=c[136]|0;s=c[p+772>>2]|0;r=c[158]|0;c[156]=r;o=r+2|0;c[158]=o;w=b[r>>1]|0;b[300]=w;x=w&65535;c[144]=x&24576;c[146]=x&4095;if(w<<16>>16<0){c[148]=e[r+4>>1]<<16|e[o>>1];c[158]=r+6}else{c[158]=r+4;c[148]=e[o>>1]|0}o=p+(s<<4)+264|0;s=(c[o>>2]|0)+1|0;c[334]=s;do{if(!((ue()|0)<-1)){p=c[134]|0;r=b[p>>1]|0;if(r<<16>>16==3){y=~~+h[c[p+28>>2]>>3];break}else if(r<<16>>16==4){y=c[c[p+28>>2]>>2]|0;break}else{p=dc(4)|0;c[p>>2]=6;td(p|0,568,0)}}else{y=s}}while(0);c[332]=y;c[o>>2]=y+ -1;c[158]=q;c[148]=5;c[146]=15;c[144]=0;v=0;i=d;return v|0};case 7:{do{if(!((ue()|0)<-1)){s=c[134]|0;p=b[s>>1]|0;if(p<<16>>16==3){z=~~+h[c[s+28>>2]>>3];break}else if(p<<16>>16==4){z=c[c[s+28>>2]>>2]|0;break}else{s=dc(4)|0;c[s>>2]=6;td(s|0,568,0)}}else{z=100}}while(0);q=c[136]|0;c[q+240>>2]=z;c[q+236>>2]=1;v=1;i=d;return v|0};case 13:case 10:case 9:{if((Ee(f)|0)!=0){q=dc(4)|0;c[q>>2]=25;td(q|0,568,0)}q=c[f>>2]|0;if((a|0)==13){if((ue()|0)<-1){o=dc(4)|0;c[o>>2]=5;td(o|0,568,0)}o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==3){A=~~+h[c[o+28>>2]>>3]}else if(s<<16>>16==4){A=c[c[o+28>>2]>>2]|0}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}if((b[(c[844]|0)+(A*140|0)>>1]|0)==0){o=dc(4)|0;c[o>>2]=3;td(o|0,568,0)}else{B=A}}else{B=4}do{if(!((ue()|0)<-1)){o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==4){C=c[c[o+28>>2]>>2]|0;break}else if(s<<16>>16==3){C=~~+h[c[o+28>>2]>>3];break}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}}else{C=0}}while(0);c[332]=C;do{if(!((ue()|0)<-1)){o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==3){D=~~+h[c[o+28>>2]>>3];break}else if(s<<16>>16==4){D=c[c[o+28>>2]>>2]|0;break}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}}else{D=0}}while(0);c[334]=D;do{if(!((ue()|0)<-1)){o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==4){E=c[c[o+28>>2]>>2]|0;break}else if(s<<16>>16==3){E=~~+h[c[o+28>>2]>>3];break}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}}else{E=0}}while(0);c[336]=E;do{if(!((ue()|0)<-1)){o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==4){F=c[c[o+28>>2]>>2]|0;break}else if(s<<16>>16==3){F=~~+h[c[o+28>>2]>>3];break}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}}else{F=0}}while(0);c[338]=F;if((a|0)!=10){dg(q,B,c[332]|0,c[334]|0,c[336]|0,F);v=0;i=d;return v|0}do{if(!((ue()|0)<-1)){o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==3){G=~~+h[c[o+28>>2]>>3];break}else if(s<<16>>16==4){G=c[c[o+28>>2]>>2]|0;break}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}}else{G=0}}while(0);eg(q,2,c[332]|0,c[334]|0,c[336]|0,c[338]|0,G);v=0;i=d;return v|0};case 8:{do{if(!((ue()|0)<-1)){o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==3){H=~~+h[c[o+28>>2]>>3];break}else if(s<<16>>16==4){H=c[c[o+28>>2]>>2]|0;break}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}}else{H=0}}while(0);c[332]=H;q=c[136]|0;c[q+240>>2]=H;c[q+248>>2]=-1;c[q+236>>2]=2;v=2;i=d;return v|0};case 15:{if((Ee(f)|0)!=0){q=dc(4)|0;c[q>>2]=25;td(q|0,568,0)}q=c[f>>2]|0;if((ue()|0)<-1){o=dc(4)|0;c[o>>2]=5;td(o|0,568,0)}o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==4){I=c[c[o+28>>2]>>2]|0}else if(s<<16>>16==3){I=~~+h[c[o+28>>2]>>3]}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}c[332]=I;if((ue()|0)<-1){o=dc(4)|0;c[o>>2]=5;td(o|0,568,0)}o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==3){J=~~+h[c[o+28>>2]>>3]}else if(s<<16>>16==4){J=c[c[o+28>>2]>>2]|0}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}c[334]=J;do{if(!((ue()|0)<-1)){o=c[134]|0;s=b[o>>1]|0;if(s<<16>>16==3){K=~~+h[c[o+28>>2]>>3];break}else if(s<<16>>16==4){K=c[c[o+28>>2]>>2]|0;break}else{o=dc(4)|0;c[o>>2]=6;td(o|0,568,0)}}else{K=4}}while(0);c[336]=K;o=c[334]|0;if((o|0)<1){s=dc(4)|0;c[s>>2]=3;td(s|0,568,0)}if((b[(c[844]|0)+(K*140|0)>>1]|0)==0){s=dc(4)|0;c[s>>2]=3;td(s|0,568,0)}bg(q,K,c[332]|0,o);v=0;i=d;return v|0};case 11:{if((c[(c[136]|0)+772>>2]|0)>30){o=dc(4)|0;c[o>>2]=9;td(o|0,568,0)}Ge()|0;o=c[158]|0;c[156]=o;s=o+2|0;c[158]=s;p=b[o>>1]|0;b[300]=p;r=p&65535;c[144]=r&24576;c[146]=r&4095;if(p<<16>>16<0){c[148]=e[o+4>>1]<<16|e[s>>1];c[158]=o+6}else{c[158]=o+4;c[148]=e[s>>1]|0}s=c[136]|0;p=s+772|0;r=(c[p>>2]|0)+1|0;c[p>>2]=r;c[s+(r<<4)+264>>2]=0;c[s+(r<<4)+260>>2]=-2147483648;c[s+(r<<4)+272>>2]=o;v=0;i=d;return v|0};case 14:{if((Ee(f)|0)!=0){o=dc(4)|0;c[o>>2]=25;td(o|0,568,0)}o=c[f>>2]|0;r=Ee(g)|0;cg(o,c[g>>2]|0,r);v=0;i=d;return v|0};case 12:{if((c[(c[136]|0)+772>>2]|0)==0){r=dc(4)|0;c[r>>2]=11;td(r|0,568,0)}r=Ge()|0;o=c[158]|0;c[156]=o;s=o+2|0;c[158]=s;p=b[o>>1]|0;b[300]=p;w=p&65535;c[144]=w&24576;c[146]=w&4095;if(p<<16>>16<0){c[148]=e[o+4>>1]<<16|e[s>>1];c[158]=o+6}else{c[158]=o+4;c[148]=e[s>>1]|0}s=c[136]|0;o=c[s+772>>2]|0;if((Ee(f)|0)!=0){p=dc(4)|0;c[p>>2]=25;td(p|0,568,0)}p=c[f>>2]|0;w=c[s+(o<<4)+264>>2]|0;if((w|0)>=(c[p+8>>2]|0)){o=(c[136]|0)+772|0;c[o>>2]=(c[o>>2]|0)+ -1;c[156]=r;o=r+2|0;c[158]=o;s=b[r>>1]|0;b[300]=s;x=s&65535;c[144]=x&24576;c[146]=x&4095;if(s<<16>>16<0){c[148]=e[r+4>>1]<<16|e[o>>1];c[158]=r+6;v=0;i=d;return v|0}else{c[158]=r+4;c[148]=e[o>>1]|0;v=0;i=d;return v|0}}if((b[p+36>>1]&128)==0){v=0;i=d;return v|0}o=b[p>>1]|0;s=c[844]|0;x=c[s+(o*140|0)+60>>2]|0;c[p+40>>2]=w;w=Nd[c[s+(o*140|0)+28>>2]&63](p)|0;if((Nd[x&63](w)|0)!=0){v=0;i=d;return v|0}c[158]=r;c[148]=5;c[146]=15;c[144]=0;v=0;i=d;return v|0};case 18:{if((Ee(f)|0)!=0){r=dc(4)|0;c[r>>2]=25;td(r|0,568,0)}r=c[f>>2]|0;c[j>>2]=r;if((b[r>>1]|0)==5){w=c[r+28>>2]|0;x=c[r+8>>2]|0;if((x|0)>0){p=0;do{if((b[w+(p<<4)>>1]|0)==0){L=r;M=p;break a}p=p+1|0}while((p|0)<(x|0))}fg(r,1,x+1|0);L=r;M=x}else{L=r;M=0}break};case 22:{if((Ee(f)|0)!=0){p=dc(4)|0;c[p>>2]=25;td(p|0,568,0)}p=c[f>>2]|0;if((ue()|0)<-1){w=dc(4)|0;c[w>>2]=5;td(w|0,568,0)}w=c[134]|0;q=b[w>>1]|0;if(q<<16>>16==3){N=~~+h[c[w+28>>2]>>3]}else if(q<<16>>16==4){N=c[c[w+28>>2]>>2]|0}else{w=dc(4)|0;c[w>>2]=6;td(w|0,568,0)}c[332]=N;if((N&1024|0)!=0){w=dc(4)|0;c[w>>2]=21;td(w|0,568,0)}if((N|0)>63){w=c[(c[(c[136]|0)+876>>2]|0)+172>>2]|0;if((w|0)==0){v=0;i=d;return v|0}Md[w&63](p,N);v=0;i=d;return v|0}if((N&48|0)!=0|(N|0)>7){w=dc(4)|0;c[w>>2]=21;td(w|0,568,0)}w=c[(c[136]|0)+828>>2]|0;if((w|0)==0){q=dc(4)|0;c[q>>2]=3;td(q|0,568,0)}bg(p,4,w+(N<<2)|0,4);v=0;i=d;return v|0};case 17:{c[(c[136]|0)+236>>2]=3;v=3;i=d;return v|0};case 19:{w=Ee(j)|0;L=c[j>>2]|0;M=w;break};case 23:{w=(c[136]|0)+792|0;if((ue()|0)<-1){p=dc(4)|0;c[p>>2]=5;td(p|0,568,0)}p=c[134]|0;if((b[p>>1]|0)!=2){q=dc(4)|0;c[q>>2]=6;td(q|0,568,0)}Qi(w,c[p+28>>2]|0);do{if(!((ue()|0)<-1)){p=c[134]|0;if((b[p>>1]|0)==2){O=c[p+28>>2]|0;break}else{p=dc(4)|0;c[p>>2]=6;td(p|0,568,0)}}else{O=688}}while(0);r=Jm(O|0)|0;if((r|0)<=1023){P=c[136]|0;Q=P+824|0;R=c[Q>>2]|0;Rm(R|0,O|0)|0;S=dc(4)|0;c[S>>2]=43;td(S|0,568,0)}x=Pi(c[(c[136]|0)+824>>2]|0,r+1|0)|0;c[(c[136]|0)+824>>2]=x;P=c[136]|0;Q=P+824|0;R=c[Q>>2]|0;Rm(R|0,O|0)|0;S=dc(4)|0;c[S>>2]=43;td(S|0,568,0);break};case 27:{if(!((ue()|0)<-1)){x=c[134]|0;r=b[x>>1]|0;if(r<<16>>16==4){T=c[c[x+28>>2]>>2]|0}else if(r<<16>>16==3){T=~~+h[c[x+28>>2]>>3]}else{x=dc(4)|0;c[x>>2]=6;td(x|0,568,0)}c[332]=T;if((T|0)!=0){v=0;i=d;return v|0}}else{c[332]=0}c[(c[136]|0)+236>>2]=8;v=8;i=d;return v|0};case 16:{do{if(!((ue()|0)<-1)){x=c[134]|0;r=b[x>>1]|0;if(r<<16>>16==4){U=c[c[x+28>>2]>>2]|0;break}else if(r<<16>>16==3){U=~~+h[c[x+28>>2]>>3];break}else{x=dc(4)|0;c[x>>2]=6;td(x|0,568,0)}}else{U=0}}while(0);x=c[136]|0;c[x+848>>2]=U;c[x+236>>2]=4;v=4;i=d;return v|0};case 20:{x=Ee(k)|0;r=c[k>>2]|0;if((b[r>>1]|0)!=5){p=dc(4)|0;c[p>>2]=6;td(p|0,568,0)}Me(r,x);v=0;i=d;return v|0};case 26:{if((Ee(f)|0)!=0){x=dc(4)|0;c[x>>2]=25;td(x|0,568,0)}x=c[f>>2]|0;Kd[c[(c[844]|0)+((b[x>>1]<<16>>16)*140|0)+44>>2]&31](x);v=0;i=d;return v|0};case 29:{x=Ee(m)|0;c[n>>2]=0;r=c[146]|0;do{if((r|0)==4){if((ue()|0)<-1){p=dc(4)|0;c[p>>2]=5;td(p|0,568,0)}p=c[134]|0;w=b[p>>1]|0;if(w<<16>>16==3){V=~~+h[c[p+28>>2]>>3]}else if(w<<16>>16==4){V=c[c[p+28>>2]>>2]|0}else{p=dc(4)|0;c[p>>2]=6;td(p|0,568,0)}if((V|0)==0){c[n>>2]=c[156];break}else if((V|0)==1){c[n>>2]=c[158];break}else{break}}else if((r|0)==7){p=Ge()|0;w=c[158]|0;c[156]=w;q=w+2|0;c[158]=q;o=b[w>>1]|0;b[300]=o;s=o&65535;c[144]=s&24576;c[146]=s&4095;if(o<<16>>16<0){c[148]=e[w+4>>1]<<16|e[q>>1];c[158]=w+6}else{c[158]=w+4;c[148]=e[q>>1]|0}c[144]=s&8192;c[n>>2]=p}else{p=dc(4)|0;c[p>>2]=6;td(p|0,568,0)}}while(0);r=c[m>>2]|0;c[r+40>>2]=x;p=c[844]|0;do{if((b[r>>1]|0)!=1){if((x|0)==0){gg(r,1);break}else{s=dc(4)|0;c[s>>2]=31;td(s|0,568,0)}}}while(0);x=c[p+212>>2]|0;s=Nd[c[p+168>>2]&63](r)|0;Od[x&15](r,s,n);v=0;i=d;return v|0};case 28:{if((ue()|0)<-1){s=dc(4)|0;c[s>>2]=5;td(s|0,568,0)}s=c[134]|0;if((b[s>>1]|0)!=2){x=dc(4)|0;c[x>>2]=6;td(x|0,568,0)}x=c[s+28>>2]|0;s=Jm(x|0)|0;if((s|0)>1023){q=Pi(c[(c[136]|0)+824>>2]|0,s+1|0)|0;c[(c[136]|0)+824>>2]=q}Rm(c[(c[136]|0)+824>>2]|0,x|0)|0;c[(c[136]|0)+236>>2]=9;v=9;i=d;return v|0};case 25:{do{if(!((ue()|0)<-1)){x=c[134]|0;q=b[x>>1]|0;if(q<<16>>16==3){W=~~+h[c[x+28>>2]>>3];break}else if(q<<16>>16==4){W=c[c[x+28>>2]>>2]|0;break}else{x=dc(4)|0;c[x>>2]=6;td(x|0,568,0)}}else{W=0}}while(0);c[332]=W;if((c[146]|0)!=15){r=dc(4)|0;c[r>>2]=2;td(r|0,568,0)}r=c[148]|0;if((r|0)>1){p=dc(4)|0;c[p>>2]=2;td(p|0,568,0)}c[334]=0;c[336]=r;r=c[158]|0;c[156]=r;p=r+2|0;c[158]=p;x=b[r>>1]|0;b[300]=x;q=x&65535;c[144]=q&24576;c[146]=q&4095;if(x<<16>>16<0){c[148]=e[r+4>>1]<<16|e[p>>1];c[158]=r+6}else{c[158]=r+4;c[148]=e[p>>1]|0}if((q&8192|0)==0){X=0}else{v=0;i=d;return v|0}while(1){Y=Ge()|0;q=c[158]|0;c[156]=q;p=q+2|0;c[158]=p;r=b[q>>1]|0;b[300]=r;x=r&65535;c[144]=x&24576;c[146]=x&4095;if(r<<16>>16<0){c[148]=e[q+4>>1]<<16|e[p>>1];c[158]=q+6}else{c[158]=q+4;c[148]=e[p>>1]|0}p=x&8192;c[144]=p;x=c[334]|0;if((c[332]|0)==(x|0)){if((c[336]|0)==0){Z=262;break}else{_=Y}}else{_=X}c[334]=x+1;if((p|0)==0){X=_}else{$=_;break}}if((Z|0)==262){p=(c[136]|0)+236|0;if((c[p>>2]|0)==4){$=X}else{c[156]=Y;x=Y+2|0;c[158]=x;q=b[Y>>1]|0;b[300]=q;r=q&65535;c[144]=r&24576;c[146]=r&4095;if(q<<16>>16<0){c[148]=e[Y+4>>1]<<16|e[x>>1];c[158]=Y+6}else{c[158]=Y+4;c[148]=e[x>>1]|0}c[p>>2]=0;$=X}}if(($|0)==0){v=0;i=d;return v|0}Ye($);v=c[(c[136]|0)+236>>2]|0;i=d;return v|0};case 24:{p=Ee(l)|0;x=c[l>>2]|0;if((b[x>>1]|0)!=4){q=dc(4)|0;c[q>>2]=6;td(q|0,568,0)}c[x+40>>2]=p;p=Nd[c[(c[844]|0)+588>>2]&63](x)|0;do{if(!((ue()|0)<-1)){x=c[134]|0;q=b[x>>1]|0;if(q<<16>>16==3){aa=~~+h[c[x+28>>2]>>3];break}else if(q<<16>>16==4){aa=c[c[x+28>>2]>>2]|0;break}else{x=dc(4)|0;c[x>>2]=6;td(x|0,568,0)}}else{aa=0}}while(0);c[332]=aa;do{if(!((ue()|0)<-1)){x=c[134]|0;q=b[x>>1]|0;if(q<<16>>16==3){ba=~~+h[c[x+28>>2]>>3];break}else if(q<<16>>16==4){ba=c[c[x+28>>2]>>2]|0;break}else{x=dc(4)|0;c[x>>2]=6;td(x|0,568,0)}}else{ba=0}}while(0);c[334]=ba;x=Ge()|0;q=c[158]|0;c[156]=q;r=q+2|0;c[158]=r;s=b[q>>1]|0;b[300]=s;w=s&65535;c[144]=w&24576;c[146]=w&4095;if(s<<16>>16<0){c[148]=e[q+4>>1]<<16|e[r>>1];c[158]=q+6}else{c[158]=q+4;c[148]=e[r>>1]|0}c[144]=w&8192;w=c[p>>2]|0;r=c[334]|0;if((c[332]|0)>-1?(w|0)<(r|0):(w|0)>(r|0)){v=0;i=d;return v|0}r=(c[136]|0)+236|0;if((c[r>>2]|0)==4){v=0;i=d;return v|0}c[156]=x;w=x+2|0;c[158]=w;q=b[x>>1]|0;b[300]=q;s=q&65535;c[144]=s&24576;c[146]=s&4095;if(q<<16>>16<0){c[148]=e[x+4>>1]<<16|e[w>>1];c[158]=x+6}else{c[158]=x+4;c[148]=e[w>>1]|0}c[r>>2]=0;v=0;i=d;return v|0};case 30:case 31:{v=0;i=d;return v|0};default:{r=dc(4)|0;c[r>>2]=21;td(r|0,568,0)}}}while(0);ba=Ie()|0;aa=c[ba+16>>2]|0;l=ba+4|0;b[f+4>>1]=c[l>>2];b[f+6>>1]=0;c[f+8>>2]=aa;c[f+12>>2]=0;aa=L+40|0;c[aa>>2]=M;$=c[844]|0;do{if((b[L>>1]|0)!=5){if((M|0)==0){gg(L,5);break}else{X=dc(4)|0;c[X>>2]=31;td(X|0,568,0)}}}while(0);X=c[$+772>>2]|0;Y=Nd[c[$+728>>2]&63](L)|0;Od[X&15](L,Y,f);c[aa>>2]=M;aa=Nd[c[(c[844]|0)+((b[L>>1]<<16>>16)*140|0)+28>>2]&63](L)|0;b[aa>>1]=1;f=Mi(c[aa+8>>2]|0)|0;c[aa+12>>2]=f;aa=c[l>>2]|0;l=c[(c[136]|0)+836>>2]|0;if(!((b[l+(aa<<3)>>1]|0)==-5)){Y=dc(4)|0;c[Y>>2]=35;td(Y|0,568,0)}Le(f,ba,0);ba=l+(aa<<3)+4|0;if((c[ba>>2]|0)==-1){v=0;i=d;return v|0}b[642>>1]=21930;b[320]=b[l+(aa<<3)+2>>1]|0;c[644>>2]=L;c[648>>2]=M;Ne(c[ba>>2]|0);v=0;i=d;return v|0}function Df(a){a=a|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;a=i;i=i+16|0;d=a+4|0;f=a;if((c[144]&8192|0)==0){g=dc(4)|0;c[g>>2]=16;td(g|0,568,0)}c[144]=0;g=Ee(d)|0;if((c[146]|0)!=0){c[158]=c[156];h=dc(4)|0;c[h>>2]=2;td(h|0,568,0)}h=c[148]|0;j=c[158]|0;c[156]=j;k=j+2|0;c[158]=k;l=b[j>>1]|0;b[300]=l;m=l&65535;n=m&24576;c[144]=n;c[146]=m&4095;if(l<<16>>16<0){c[148]=e[j+4>>1]<<16|e[k>>1];c[158]=j+6}else{c[158]=j+4;c[148]=e[k>>1]|0}if((n|0)!=0){n=c[d>>2]|0;k=b[n>>1]|0;j=k<<16>>16;l=c[844]|0;c[f>>2]=1;if(k<<16>>16==4){o=4;p=l;q=f}else{k=Sd[c[l+(j*140|0)+20>>2]&15](f,4)|0;o=b[n>>1]|0;p=c[844]|0;q=k}c[n+40>>2]=g;k=Nd[c[p+((o<<16>>16)*140|0)+28>>2]&63](n)|0;if((h|0)==0){Md[c[l+(j*140|0)+76>>2]&63](k,q);i=a;return 0}else if((h|0)==1){Md[c[l+(j*140|0)+80>>2]&63](k,q);i=a;return 0}else{q=dc(4)|0;c[q>>2]=2;td(q|0,568,0)}}if((ue()|0)!=0){q=dc(4)|0;c[q>>2]=2;td(q|0,568,0)}q=c[d>>2]|0;d=b[q>>1]|0;k=c[844]|0;j=k+(d*140|0)|0;l=q+40|0;c[l>>2]=g;n=Nd[c[k+(d*140|0)+28>>2]&63](q)|0;o=c[134]|0;p=c[o+28>>2]|0;if((h|0)!=8){f=b[q>>1]|0;if(f<<16>>16==(b[o>>1]|0)){r=p}else{r=ig(o,f<<16>>16)|0}Ff(j,n,h,r);if((b[k+(d*140|0)+2>>1]|0)==(b[q>>1]|0)){i=a;return 0}else{r=dc(4)|0;c[r>>2]=6;td(r|0,568,0)}}if((c[340]|0)!=0?(b[q+36>>1]&64)!=0:0){Od[c[k+(d*140|0)+40>>2]&15](q,p,b[o>>1]|0);i=a;return 0}d=b[o>>1]|0;o=d<<16>>16;do{if(!((b[q>>1]|0)==d<<16>>16)){if((g|0)==0){gg(q,o);k=b[q>>1]|0;r=c[844]|0;s=Nd[c[r+(k*140|0)+28>>2]&63](q)|0;t=r+(k*140|0)|0;break}else{k=dc(4)|0;c[k>>2]=31;td(k|0,568,0)}}else{s=n;t=j}}while(0);j=t+72|0;Od[c[j>>2]&15](q,s,p);if((c[144]|0)!=0){i=a;return 0}p=c[q+8>>2]|0;if((p|0)==0){u=g}else{u=(g|0)%(p|0)|0}p=g-u|0;g=q+38|0;s=u;while(1){if((ue()|0)!=0){v=30;break}u=c[134]|0;if((b[q>>1]|0)!=(b[u>>1]|0)){v=32;break}t=c[u+28>>2]|0;s=s+1|0;b[g>>1]=0;c[l>>2]=p;Ef(q,s);u=Nd[c[(c[844]|0)+((b[q>>1]<<16>>16)*140|0)+28>>2]&63](q)|0;Od[c[j>>2]&15](q,u,t);if((c[144]|0)!=0){v=38;break}}if((v|0)==30){q=dc(4)|0;c[q>>2]=2;td(q|0,568,0)}else if((v|0)==32){q=dc(4)|0;c[q>>2]=31;td(q|0,568,0)}else if((v|0)==38){i=a;return 0}return 0}function Ef(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=a+38|0;g=b[f>>1]|0;if(g<<16>>16>4){h=dc(4)|0;c[h>>2]=7;td(h|0,568,0)}if(g<<16>>16==0){c[a+44>>2]=1;j=1}else{h=a+44|0;k=da(c[h>>2]|0,c[a+(g<<16>>16<<2)+4>>2]|0)|0;c[h>>2]=k;j=k}k=g+1<<16>>16;b[f>>1]=k;if((d|0)<0){f=dc(4)|0;c[f>>2]=7;td(f|0,568,0)}f=k<<16>>16;if((c[a+(f<<2)+4>>2]|0)>(d|0)){g=da(j,d)|0;j=a+40|0;c[j>>2]=(c[j>>2]|0)+g;i=e;return}if(!(k<<16>>16>3)?(c[a+(f+1<<2)+4>>2]|0)!=0:0){l=dc(4)|0;c[l>>2]=7;td(l|0,568,0)}if((b[a+36>>1]&8)==0){l=dc(4)|0;c[l>>2]=7;td(l|0,568,0)}fg(a,f,d+1|0);f=da(c[a+44>>2]|0,d)|0;d=a+40|0;c[d>>2]=(c[d>>2]|0)+f;i=e;return}function Ff(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;do{switch(d|0){case 3:{Md[c[a+88>>2]&63](b,e);i=f;return};case 2:{Md[c[a+84>>2]&63](b,e);i=f;return};case 12:{Md[c[a+124>>2]&63](b,e);i=f;return};case 0:{Md[c[a+76>>2]&63](b,e);i=f;return};case 5:{Md[c[a+96>>2]&63](b,e);i=f;return};case 6:{Md[c[a+100>>2]&63](b,e);i=f;return};case 1:{Md[c[a+80>>2]&63](b,e);i=f;return};case 4:{Md[c[a+92>>2]&63](b,e);i=f;return};case 8:{Md[c[a+108>>2]&63](b,e);i=f;return};case 9:{Md[c[a+112>>2]&63](b,e);i=f;return};case 7:{Md[c[a+104>>2]&63](b,e);i=f;return};case 10:{Md[c[a+116>>2]&63](b,e);i=f;return};case 13:{Md[c[a+128>>2]&63](b,e);i=f;return};case 14:{Md[c[a+132>>2]&63](b,e);i=f;return};case 15:{Md[c[a+136>>2]&63](b,e);i=f;return};case 40:{g=dc(4)|0;c[g>>2]=34;td(g|0,568,0);break};case 11:{Md[c[a+120>>2]&63](b,e);i=f;return};default:{g=dc(4)|0;c[g>>2]=4;td(g|0,568,0)}}}while(0)}function Gf(a){a=a|0;var d=0,f=0,g=0,h=0;if((c[144]&8192|0)==0){a=dc(4)|0;c[a>>2]=16;td(a|0,568,0)}a=c[146]|0;d=c[158]|0;c[156]=d;f=d+2|0;c[158]=f;g=b[d>>1]|0;b[300]=g;h=g&65535;c[144]=h&24576;c[146]=h&4095;if(g<<16>>16<0){c[148]=(e[d+4>>1]|0)<<16|(e[f>>1]|0);c[158]=d+6}else{c[158]=d+4;c[148]=e[f>>1]|0}f=dc(4)|0;if((a|0)==10|(a|0)==13){c[f>>2]=41;td(f|0,568,0)}else{c[f>>2]=18;td(f|0,568,0)}return 0}function Hf(a){a=a|0;var b=0;if(a>>>0>43){b=1544}else{b=c[1368+(a<<2)>>2]|0}return b|0}function If(a){a=a|0;return c[(c[(c[766]|0)+32>>2]|0)+(a<<2)>>2]|0}function Jf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;if((b|0)>95){e=dc(4)|0;c[e>>2]=21;td(e|0,568,0)}if((b|0)==64){f=(c[768]|0)+784|0;g=4;h=4}else if((b|0)==65){f=c[(c[768]|0)+792>>2]|0;g=1024;h=2}else if((b|0)==68){f=c[768]|0;g=888;h=4}else{b=dc(4)|0;c[b>>2]=21;td(b|0,568,0)}bg(a,h,f,g);i=d;return}function Kf(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;b=i;c[768]=c[a+4>>2];d=c[a+8>>2]|0;c[770]=c[d+24>>2];c[772]=c[d+28>>2];e=Rl(68)|0;s=0;oa(16,e|0);f=s;s=0;if(f&1){f=ub(-1,-1)|0;g=H;Tl(e);h=g;j=f;Cb(j|0)}c[766]=e;c[774]=c[c[e+32>>2]>>2];pi((c[768]|0)+784|0);e=Rl(12)|0;s=0;oa(17,e|0);f=s;s=0;if(!(f&1)){c[776]=e;pk(e,c[(c[768]|0)+856>>2]|0);c[a+12>>2]=18;c[a+20>>2]=19;c[d+20>>2]=3112;c[d+72>>2]=20;c[d+172>>2]=4;i=b;return}b=ub(-1,-1)|0;d=H;Tl(e);h=d;j=b;Cb(j|0)}function Lf(d){d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0.0,Z=0.0,_=0;e=i;i=i+16688|0;f=e+296|0;g=e+40|0;h=e+32|0;j=e+28|0;k=e+24|0;l=e+20|0;m=e+12|0;n=e+8|0;o=e+4|0;p=e;q=e+16|0;qe();do{switch(d|0){case 18:{c[784]=ze(0)|0;c[788]=ze(0)|0;c[790]=ze(c[(c[774]|0)+4>>2]|0)|0;c[792]=ze(c[(c[774]|0)+8>>2]|0)|0;s=ze(1)|0;c[794]=s;ai(c[774]|0,c[784]|0,c[788]|0,c[790]|0,c[792]|0,s);t=0;i=e;return t|0};case 24:{c[784]=ze(0)|0;c[788]=ze(0)|0;s=ze(0)|0;c[790]=s;Qh(c[774]|0,c[784]|0,c[788]|0,s);t=0;i=e;return t|0};case 27:{c[784]=ze(1)|0;c[788]=ze(0)|0;c[790]=ze(0)|0;c[792]=ze(0)|0;c[794]=ze(0)|0;s=c[784]|0;u=(s&16|0)==0;if((s&1|0)==0){if(u){v=s}else{zi(c[774]|0)|0;Wh(c[774]|0);t=0;i=e;return t|0}}else{if(u){zi(c[774]|0)|0;Wh(c[774]|0);v=c[784]|0}else{v=s}}s=_j(c[774]|0,v)|0;c[(c[768]|0)+784>>2]=s;t=0;i=e;return t|0};case 15:{if((ue()|0)<-1){t=0;i=e;return t|0}s=c[134]|0;u=Nd[c[(c[844]|0)+((b[s>>1]<<16>>16)*140|0)+28>>2]&63](s)|0;s=b[c[134]>>1]|0;if(s<<16>>16==2){w=u}else{w=Sd[c[(c[844]|0)+300>>2]&15](u,s<<16>>16)|0}Yh(c[774]|0,w);t=0;i=e;return t|0};case 19:{s=ze(0)|0;c[784]=s;Oh(c[774]|0,s);t=0;i=e;return t|0};case 17:{s=ze(c[(c[774]|0)+68>>2]|0)|0;u=c[774]|0;c[u+68>>2]=s;s=ze(c[u+72>>2]|0)|0;c[(c[774]|0)+72>>2]=s;t=0;i=e;return t|0};case 23:{Km(f|0,ve()|0,63)|0;s=ze(0)|0;c[784]=s;Lh(c[766]|0,c[(c[774]|0)+32>>2]|0,f,s)|0;t=0;i=e;return t|0};case 3:{Km(f|0,xe(3144)|0,16383)|0;c[784]=ze(0)|0;s=we(3144)|0;u=Vj(c[784]|0,f,s)|0;s=c[768]|0;c[s+784>>2]=u;c[s+240>>2]=0;c[s+236>>2]=1;t=1;i=e;return t|0};case 0:{do{if((c[c[770]>>2]|0)==15){s=c[c[772]>>2]|0;if((s|0)>1){u=dc(4)|0;c[u>>2]=2;td(u|0,568,0)}else{qe();x=s;break}}else{x=0}}while(0);Km(f|0,ve()|0,255)|0;s=Ge()|0;qe();u=vi(c[774]|0,f,x,s)|0;c[(c[768]|0)+784>>2]=u;u=c[(c[774]|0)+188>>2]|0;c[784]=u;if(!((u|0)>-1)){t=0;i=e;return t|0}Mh(c[766]|0,u)|0;u=c[774]|0;yi(u,c[(c[768]|0)+784>>2]|0,c[784]|0,b[u+192>>1]|0,b[u+194>>1]|0,b[u+196>>1]|0,b[u+198>>1]|0,b[u+200>>1]|0,b[u+202>>1]|0);t=0;i=e;return t|0};case 9:{u=ze(0)|0;c[784]=u;rk(c[776]|0,u)|0;t=0;i=e;return t|0};case 8:{Km(g|0,ve()|0,255)|0;c[784]=ze(0)|0;u=ze(0)|0;c[788]=u;if((qk(c[776]|0,g,c[784]|0,u)|0)==0){t=0;i=e;return t|0}else{u=dc(4)|0;c[u>>2]=12;td(u|0,568,0)}break};case 12:{c[784]=ze(c[(c[774]|0)+68>>2]|0)|0;u=ze(c[(c[774]|0)+72>>2]|0)|0;c[788]=u;_h(c[774]|0,c[784]|0,u);t=0;i=e;return t|0};case 2:{Qe(ve()|0)|0;c[784]=ze(0)|0;we(3144)|0;u=c[768]|0;c[u+240>>2]=0;c[u+236>>2]=1;t=1;i=e;return t|0};case 16:{u=ve()|0;Sh(c[774]|0,u);t=0;i=e;return t|0};case 20:{Km(f|0,ve()|0,255)|0;c[784]=ze(12)|0;u=ze(0)|0;c[788]=u;Ph(c[774]|0,f,c[784]|0,u);t=0;i=e;return t|0};case 22:{c[784]=ze(64)|0;c[788]=ze(24)|0;c[790]=ze(0)|0;u=c[774]|0;c[u+76>>2]=c[784];c[u+80>>2]=c[788];c[u+84>>2]=c[790];t=0;i=e;return t|0};case 10:{u=ze(-1)|0;c[784]=u;vk(c[776]|0,u);t=0;i=e;return t|0};case 28:{c[784]=ze(-1)|0;c[788]=ze(-1)|0;c[790]=ze(-1)|0;c[792]=ze(-1)|0;t=0;i=e;return t|0};case 54:{c[784]=ze(0)|0;c[788]=ze(0)|0;c[790]=ze(0)|0;y=+Be(0.0);c[792]=ze(c[(c[774]|0)+92>>2]|0)|0;c[794]=ze(c[(c[774]|0)+96>>2]|0)|0;u=Mh(c[766]|0,c[784]|0)|0;s=c[774]|0;ii(s,c[792]|0,c[794]|0,y,u,c[788]|0,c[790]|0,c[s+92>>2]|0,c[s+96>>2]|0);t=0;i=e;return t|0};case 34:{c[784]=ze(0)|0;c[788]=ze(0)|0;s=ze(0)|0;c[790]=s;ei(c[774]|0,c[784]|0,c[788]|0,s);t=0;i=e;return t|0};case 56:{c[784]=ze(0)|0;c[788]=ze(0)|0;c[790]=ze(c[(c[774]|0)+4>>2]|0)|0;c[792]=ze(c[(c[774]|0)+8>>2]|0)|0;s=ze(0)|0;c[794]=ze(0)|0;u=ze(0)|0;c[796]=u;fi(c[774]|0,c[784]|0,c[788]|0,c[790]|0,c[792]|0,s,c[794]|0,u);t=0;i=e;return t|0};case 39:{u=Ee(k)|0;c[788]=ze(16384)|0;c[790]=ze(0)|0;s=c[788]|0;if((s|0)<64){c[788]=64;z=64}else{z=s}s=Pe(z+1|0)|0;A=c[790]&15;a:do{if((A|0)==2){if((c[788]|0)>=1){B=s;C=0;while(1){D=ec()|0;if((D|0)==13){break}else if((D|0)==10|(D|0)==-1){E=B;F=C;break a}G=B+1|0;a[B>>0]=D;D=c[788]|0;c[788]=D+ -1;H=C+1|0;if((D|0)<2){E=G;F=H;break a}else{B=G;C=H}}H=ec()|0;if((H|0)==10){E=B;F=C}else{Tc(H|0,c[r>>2]|0)|0;E=B;F=C}}else{E=s;F=0}}else if((A|0)==1){if((c[788]|0)<1){E=s;F=0}else{H=s;G=0;while(1){D=ec()|0;if((D|0)==10|(D|0)==-1){E=H;F=G;break a}I=H+1|0;a[H>>0]=D;D=c[788]|0;c[788]=D+ -1;J=G+1|0;if((D|0)<2){E=I;F=J;break}else{H=I;G=J}}}}else if((A|0)==0?(c[788]|0)>=1:0){G=s;H=0;while(1){C=ec()|0;if((C|0)==-1){E=G;F=H;break a}B=G+1|0;a[G>>0]=C;C=c[788]|0;c[788]=C+ -1;J=H+1|0;if((C|0)<2){E=B;F=J;break}else{G=B;H=J}}}else{E=s;F=0}}while(0);a[E>>0]=0;s=c[768]|0;c[s+788>>2]=F+1;A=c[k>>2]|0;if((c[790]&16|0)==0){Je(A,u,2,c[s+824>>2]|0);t=0;i=e;return t|0}if((b[A+36>>1]&2)==0){s=dc(4)|0;c[s>>2]=6;td(s|0,568,0)}c[A+40>>2]=u;Mm(Nd[c[(c[844]|0)+((b[A>>1]<<16>>16)*140|0)+28>>2]&63](A)|0,c[(c[768]|0)+824>>2]|0,F|0)|0;t=0;i=e;return t|0};case 53:{c[784]=ze(0)|0;c[788]=ze(0)|0;y=+Be(0.0);c[790]=ze(c[(c[774]|0)+92>>2]|0)|0;A=ze(c[(c[774]|0)+96>>2]|0)|0;c[792]=A;hi(c[774]|0,c[784]|0,c[788]|0,c[790]|0,A,y);t=0;i=e;return t|0};case 32:{c[784]=ze(0)|0;c[788]=ze(32)|0;c[790]=ze(32)|0;c[792]=ze(0)|0;A=c[774]|0;c[A+100>>2]=c[784];c[A+92>>2]=c[788];c[A+96>>2]=c[790];c[A+144>>2]=c[792];t=0;i=e;return t|0};case 43:case 42:case 41:{c[784]=ze(0)|0;c[788]=ze(640)|0;c[790]=ze(480)|0;c[792]=ze(0)|0;c[794]=ze(-1)|0;c[796]=ze(-1)|0;ze(c[788]|0)|0;ze(c[790]|0)|0;do{if((d|0)==41){A=c[784]|0;if((A|0)==0){s=dc(4)|0;c[s>>2]=3;td(s|0,568,0)}else{Jh(c[766]|0,A,1,c[794]|0,c[796]|0,c[788]|0,c[790]|0);break}}}while(0);u=c[784]|0;c[774]=c[(c[(c[766]|0)+32>>2]|0)+(u<<2)>>2];c[778]=u;t=0;i=e;return t|0};case 52:{u=Ee(l)|0;c[784]=ze(0)|0;A=ze(1)|0;c[788]=A;s=Cj(A)|0;c[798]=s;A=s&~c[800];c[802]=A;c[800]=s;c[m>>2]=c[784]&s|A;Je(c[l>>2]|0,u,4,m);t=0;i=e;return t|0};case 30:{c[784]=ze(0)|0;c[788]=ze(0)|0;c[790]=ze(0)|0;c[792]=ze(c[(c[774]|0)+92>>2]|0)|0;c[794]=ze(c[(c[774]|0)+96>>2]|0)|0;u=Mh(c[766]|0,c[784]|0)|0;if((bi(c[774]|0,u,c[788]|0,c[790]|0,c[792]|0,c[794]|0)|0)==0){t=0;i=e;return t|0}else{u=dc(4)|0;c[u>>2]=21;td(u|0,568,0)}break};case 33:{if((di(c[774]|0,ve()|0)|0)==0){t=0;i=e;return t|0}else{u=dc(4)|0;c[u>>2]=12;td(u|0,568,0)}break};case 47:{c[784]=ze(0)|0;c[788]=ze(0)|0;u=ze(c[(c[774]|0)+68>>2]|0)|0;A=c[774]|0;c[A+68>>2]=u;u=ze(c[A+72>>2]|0)|0;A=c[774]|0;c[A+72>>2]=u;$h(A,c[784]|0,c[788]|0);t=0;i=e;return t|0};case 31:{c[784]=ze(c[(c[774]|0)+4>>2]|0)|0;c[788]=ze(c[(c[774]|0)+8>>2]|0)|0;c[790]=ze(0)|0;c[792]=ze(0)|0;c[794]=ze(0)|0;c[796]=ze(c[(c[774]|0)+92>>2]|0)|0;A=ze(c[(c[774]|0)+96>>2]|0)|0;u=ze(0)|0;s=Mh(c[766]|0,c[790]|0)|0;if((ci(c[774]|0,c[784]|0,c[788]|0,s,c[792]|0,c[794]|0,c[796]|0,A,u)|0)==0){t=0;i=e;return t|0}else{u=dc(4)|0;c[u>>2]=21;td(u|0,568,0)}break};case 48:{c[784]=ze(0)|0;u=ze(-1)|0;c[788]=u;A=c[774]|0;s=c[A+168>>2]|0;H=s+ -1|0;c[792]=H;if((s|0)<1){t=0;i=e;return t|0}s=c[784]|0;if(((s|0)>(H|0)|s>>>31|(u|0)>(H|0)|0)!=0){G=dc(4)|0;c[G>>2]=3;td(G|0,568,0)}if((u|0)<0){c[788]=H;K=H}else{K=u}c[790]=s;if((s|0)>(K|0)){t=0;i=e;return t|0}else{L=A;M=s}while(1){ri(L,M);s=c[790]|0;A=s+1|0;c[790]=A;if((s|0)>=(c[788]|0)){t=0;break}L=c[774]|0;M=A}i=e;return t|0};case 49:{c[784]=ze(0)|0;c[788]=ze(0)|0;c[790]=ze(c[(c[774]|0)+4>>2]|0)|0;A=ze(c[(c[774]|0)+8>>2]|0)|0;c[792]=A;Zh(c[774]|0,c[784]|0,c[788]|0,c[790]|0,A);t=0;i=e;return t|0};case 55:{A=ze(0)|0;s=Fe()|0;if((b[s>>1]|0)!=4){u=dc(4)|0;c[u>>2]=6;td(u|0,568,0)}c[s+40>>2]=0;u=Nd[c[(c[844]|0)+588>>2]&63](s)|0;s=Fe()|0;if((b[s>>1]|0)!=4){H=dc(4)|0;c[H>>2]=6;td(H|0,568,0)}c[s+40>>2]=0;H=Nd[c[(c[844]|0)+588>>2]&63](s)|0;do{if((A|0)>-1){s=Mh(c[766]|0,A)|0;G=Fe()|0;if((b[G>>1]|0)!=4){J=dc(4)|0;c[J>>2]=6;td(J|0,568,0)}c[G+40>>2]=0;J=Nd[c[(c[844]|0)+588>>2]&63](G)|0;G=Fe()|0;if((b[G>>1]|0)==4){c[G+40>>2]=0;N=s;O=J;P=Nd[c[(c[844]|0)+588>>2]&63](G)|0;break}else{G=dc(4)|0;c[G>>2]=6;td(G|0,568,0)}}else{if((A|0)==-257){G=Fe()|0;if((b[G>>1]|0)==4){c[G+40>>2]=0;N=0;O=Nd[c[(c[844]|0)+588>>2]&63](G)|0;P=0;break}else{G=dc(4)|0;c[G>>2]=6;td(G|0,568,0)}}else{N=0;O=0;P=0}}}while(0);gi(c[774]|0,u,H,N,O,P,A);t=0;i=e;return t|0};case 29:{c[784]=ze(0)|0;c[788]=ze(0)|0;c[774]=Mh(c[766]|0,c[784]|0)|0;c[778]=c[784];t=0;i=e;return t|0};case 35:{G=Ee(j)|0;c[784]=ze(1)|0;c[788]=0;Je(c[j>>2]|0,G,4,3152);t=0;i=e;return t|0};case 70:{G=Ke(f,g)|0;J=c[f>>2]|0;if((b[J>>1]|0)==4){Q=J;R=G}else{c[h>>2]=0;Je(J,0,4,h);J=c[f>>2]|0;c[J+40>>2]=0;G=Nd[c[(c[844]|0)+((b[J>>1]<<16>>16)*140|0)+28>>2]&63](J)|0;Q=c[f>>2]|0;R=G}G=ze(0)|0;c[784]=G;J=ni(c[774]|0,G)|0;c[Q+8>>2]=4;c[Q+24>>2]=16;if((J|0)==0){c[R>>2]=-1;c[R+4>>2]=0;c[R+8>>2]=0;c[R+12>>2]=0;c[(c[768]|0)+784>>2]=-1;t=0;i=e;return t|0}else{c[R>>2]=c[J>>2];c[R+4>>2]=c[J+4>>2];c[R+8>>2]=c[J+8>>2];c[R+12>>2]=c[J+12>>2];c[(c[768]|0)+784>>2]=c[J>>2];t=0;i=e;return t|0}break};case 65:{J=Ee(n)|0;G=ze(0)|0;c[784]=G;c[788]=bj(G)|0;Je(c[n>>2]|0,J,4,3152);t=0;i=e;return t|0};case 59:{c[784]=ze(0)|0;J=ze(1)|0;c[788]=J;si(c[774]|0,c[784]|0,J);t=0;i=e;return t|0};case 72:{J=Ke(f,g)|0;G=c[f>>2]|0;if((b[G>>1]|0)==4){S=G;T=J}else{c[h>>2]=0;Je(G,0,4,h);G=c[f>>2]|0;c[G+40>>2]=0;J=Nd[c[(c[844]|0)+((b[G>>1]<<16>>16)*140|0)+28>>2]&63](G)|0;S=c[f>>2]|0;T=J}J=ve()|0;G=Sd[c[(c[766]|0)+60>>2]&15](J,q)|0;if((G|0)==0){c[q>>2]=-1;U=-1}else{J=c[q>>2]|0;s=(J|0)<1?1:J;c[S+8>>2]=s;c[S+24>>2]=s<<2;Mm(T|0,G|0,c[q>>2]<<2|0)|0;U=c[q>>2]|0}c[(c[768]|0)+784>>2]=U;t=0;i=e;return t|0};case 74:{G=Qe(ve()|0)|0;c[784]=ze(0)|0;c[788]=ze(0)|0;s=ze(0)|0;c[790]=s;J=Qd[c[(c[766]|0)+56>>2]&3](G,c[784]|0,c[788]|0,s)|0;c[(c[768]|0)+784>>2]=J;t=0;i=e;return t|0};case 57:{J=ze(-1)|0;c[784]=J;c[(c[774]|0)+188>>2]=J;J=(ze(0)|0)&65535;b[(c[774]|0)+192>>1]=J;J=(ze(0)|0)&65535;b[(c[774]|0)+194>>1]=J;J=(ze(0)|0)&65535;b[(c[774]|0)+196>>1]=J;J=(ze(0)|0)&65535;s=c[774]|0;b[s+198>>1]=J;J=(ze(b[s+192>>1]|0)|0)&65535;s=c[774]|0;b[s+200>>1]=J;J=(ze(b[s+194>>1]|0)|0)&65535;b[(c[774]|0)+202>>1]=J;t=0;i=e;return t|0};case 63:{J=ze(0)|0;c[784]=J;li(c[774]|0,J);t=0;i=e;return t|0};case 69:{J=Ke(f,g)|0;s=c[f>>2]|0;if((b[s>>1]|0)==4){V=s;W=J}else{c[h>>2]=0;Je(s,0,4,h);s=c[f>>2]|0;c[s+40>>2]=0;J=Nd[c[(c[844]|0)+((b[s>>1]<<16>>16)*140|0)+28>>2]&63](s)|0;V=c[f>>2]|0;W=J}J=oi(c[774]|0,W)|0;s=(J|0)<1?1:J;c[V+8>>2]=s;c[V+24>>2]=s<<2;c[(c[768]|0)+784>>2]=J;t=0;i=e;return t|0};case 71:{J=Ee(p)|0;s=ve()|0;G=Nd[c[(c[766]|0)+64>>2]&63](s)|0;if((G|0)==0){X=-1}else{Je(c[p>>2]|0,J,2,G);X=0}c[(c[768]|0)+784>>2]=X;t=0;i=e;return t|0};case 67:{c[784]=ze(0)|0;c[788]=ze(0)|0;t=0;i=e;return t|0};case 61:{c[784]=ze(1)|0;c[788]=ze(0)|0;c[790]=ze(0)|0;c[792]=ze(0)|0;c[794]=ze(0)|0;G=Mh(c[766]|0,c[784]|0)|0;Rh(G,c[788]|0,c[790]|0,c[792]|0,c[794]|0);t=0;i=e;return t|0};case 62:{c[784]=ze(1)|0;c[788]=ze(0)|0;y=+Be(1.0);Y=+Be(1.0);Z=+Be(0.0);G=Mh(c[766]|0,c[784]|0)|0;J=c[774]|0;s=c[788]|0;if(Z==0.0&y==1.0&Y==1.0){ki(J,G,s)|0;t=0;i=e;return t|0}else{ji(J,G,s,y,Y,Z)|0;t=0;i=e;return t|0}break};case 64:{c[784]=ze(0)|0;s=ze(0)|0;c[788]=s;aj(c[784]|0,s);t=0;i=e;return t|0};case 66:{c[784]=ze(0)|0;s=ze(0)|0;c[788]=s;sk(c[776]|0,c[784]|0,s);t=0;i=e;return t|0};case 60:{Km(f|0,ve()|0,63)|0;c[784]=ze(-1)|0;c[788]=ze(0)|0;s=c[784]|0;if((s|0)<0){G=Nh(c[766]|0)|0;c[784]=G;_=G}else{_=s}Kh(c[766]|0,_,f);c[(c[768]|0)+784>>2]=c[784];t=0;i=e;return t|0};case 68:{s=Ee(o)|0;c[784]=ze(0)|0;G=ze(0)|0;c[788]=G;c[790]=uk(c[776]|0,c[784]|0,G)|0;Je(c[o>>2]|0,s,4,3160);t=0;i=e;return t|0};case 58:{c[784]=ze(0)|0;s=ze(2)|0;c[788]=s;ti(c[774]|0,c[784]|0,s);t=0;i=e;return t|0};case 73:{Km(f|0,ve()|0,255)|0;s=ve()|0;G=Sd[c[(c[766]|0)+52>>2]&15](f,s)|0;c[(c[768]|0)+784>>2]=G;t=0;i=e;return t|0};default:{G=dc(4)|0;c[G>>2]=21;td(G|0,568,0)}}}while(0);return 0}function Mf(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;a=i;b=c[776]|0;do{if((b|0)!=0){s=0;oa(18,b|0);d=s;s=0;if(!(d&1)){Tl(b);break}d=ub(-1,-1)|0;e=H;Tl(b);f=e;g=d;Cb(g|0)}}while(0);b=c[766]|0;if((b|0)==0){i=a;return 0}s=0;oa(19,b|0);d=s;s=0;if(d&1){d=ub(-1,-1)|0;e=H;Tl(b);f=e;g=d;Cb(g|0)}else{Tl(b);i=a;return 0}return 0}function Nf(a){a=a|0;c[a+16>>2]=5;return}function Of(d,e){d=d|0;e=e|0;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+16|0;g=f;c[d>>2]=4;if((e&256|0)==0){switch(e|0){case 3:{c[780]=0;j=3120;i=f;return j|0};case 2:{k=(c[774]|0)+182|0;c[780]=b[k>>1]|0;b[k>>1]=0;j=3120;i=f;return j|0};case 1:{c[780]=b[(c[774]|0)+178>>1]|0;j=3120;i=f;return j|0};case 4:{c[780]=0;j=3120;i=f;return j|0};case 5:{c[780]=0;j=3120;i=f;return j|0};case 0:{c[780]=b[(c[774]|0)+176>>1]|0;j=3120;i=f;return j|0};default:{k=dc(4)|0;c[k>>2]=21;td(k|0,568,0)}}}if((c[c[770]>>2]|0)!=0){k=dc(4)|0;c[k>>2]=32;td(k|0,568,0)}if((c[c[772]>>2]|0)!=40){k=dc(4)|0;c[k>>2]=32;td(k|0,568,0)}qe();k=e&255;do{if((k|0)==2){e=ye()|0;c[784]=e;l=c[(c[768]|0)+824>>2]|0;a[l>>0]=0;if(e>>>0<6){c[d>>2]=2;m=l;break}else{l=dc(4)|0;c[l>>2]=3;td(l|0,568,0)}}else if((k|0)==3){l=ye()|0;c[784]=l;if((Wj(l,g,c[(c[768]|0)+824>>2]|0)|0)==0){a[c[(c[768]|0)+824>>2]>>0]=0;n=4}else{n=c[g>>2]|0}c[d>>2]=n;m=c[(c[768]|0)+824>>2]|0}else if((k|0)==0){l=ye()|0;if((l|0)>=256){h[391]=+Yj(l);c[d>>2]=3;m=3128;break}do{switch(l|0){case 15:{o=b[(c[774]|0)+158>>1]|0;break};case 21:{o=zj()|0;break};case 27:case 13:{o=c[(c[774]|0)+8>>2]|0;break};case 16:{o=(c[(c[774]|0)+104>>2]|0)>>>16&255;break};case 17:{o=(c[(c[774]|0)+104>>2]|0)>>>8&255;break};case 20:{o=yj()|0;break};case 26:case 12:{o=c[(c[774]|0)+4>>2]|0;break};case 18:{o=c[(c[774]|0)+104>>2]&255;break};case 22:{o=c[(c[774]|0)+68>>2]|0;break};case 2:{o=Ih(c[766]|0)|0;break};case 23:{o=c[(c[774]|0)+72>>2]|0;break};case 25:{o=Nh(c[766]|0)|0;break};case 14:{o=b[(c[774]|0)+156>>1]|0;break};case 31:case 30:case 29:case 28:case 24:case 19:case 11:case 10:case 9:case 8:case 7:case 6:case 5:case 4:case 1:case 0:{o=0;break};case 3:{o=c[778]|0;break};default:{e=dc(4)|0;c[e>>2]=21;td(e|0,568,0)}}}while(0);c[780]=o;m=3120}else{l=dc(4)|0;c[l>>2]=21;td(l|0,568,0)}}while(0);if((c[c[770]>>2]|0)!=0){o=dc(4)|0;c[o>>2]=32;td(o|0,568,0)}if((c[c[772]>>2]|0)!=41){o=dc(4)|0;c[o>>2]=32;td(o|0,568,0)}qe();j=m;i=f;return j|0}function Pf(){return(c[766]|0)+44|0}function Qf(a){a=a|0;var b=0;c[810]=c[a+4>>2];b=c[a+8>>2]|0;c[812]=b;c[814]=c[b+24>>2];c[816]=c[b+28>>2];h[419]=.000244140625;c[a+12>>2]=21;c[a+20>>2]=22;return}function Rf(d){d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0.0,da=0.0,ea=0.0;e=i;i=i+96|0;f=e+84|0;g=e+80|0;j=e+76|0;k=e+72|0;l=e+68|0;m=e+64|0;n=e+60|0;o=e+52|0;p=e+48|0;q=e+44|0;r=e+40|0;s=e+12|0;t=e;u=e+4|0;v=e+8|0;w=e+16|0;x=e+20|0;y=e+24|0;z=e+28|0;A=e+32|0;B=e+36|0;qe();do{switch(d|0){case 28:case 27:case 26:{C=Ke(e+56|0,o)|0;D=ze(0)|0;if((D|0)<0){E=dc(4)|0;c[E>>2]=20;td(E|0,568,0)}E=C+D|0;if((ue()|0)<-1){c[f>>2]=0;F=f;G=4}else{C=c[134]|0;F=c[C+28>>2]|0;G=b[C>>1]|0}if((d|0)==26){if((G|0)==2){C=Jm(F|0)|0;c[(c[810]|0)+788>>2]=C;if((D+1+C|0)>(c[o>>2]|0)){C=dc(4)|0;c[C>>2]=20;td(C|0,568,0)}Rm(E|0,F|0)|0;i=e;return 0}else if((G|0)==4){if((D|0)>=(c[o>>2]|0)){C=dc(4)|0;c[C>>2]=20;td(C|0,568,0)}a[E>>0]=a[F>>0]|0;i=e;return 0}else{C=dc(4)|0;c[C>>2]=6;td(C|0,568,0)}}if((G|0)!=4){C=dc(4)|0;c[C>>2]=6;td(C|0,568,0)}if((d|0)==27){if((D+2|0)>(c[o>>2]|0)){C=dc(4)|0;c[C>>2]=20;td(C|0,568,0)}b[E>>1]=b[F>>1]|0;i=e;return 0}else{if((D+4|0)>(c[o>>2]|0)){D=dc(4)|0;c[D>>2]=20;td(D|0,568,0)}c[E>>2]=c[F>>2];i=e;return 0}break};case 20:case 19:case 18:case 17:{lf(5,0,0,ve()|0)|0;lf(d+ -9|0,0,0,0)|0;i=e;return 0};case 23:case 22:{lf(5,0,0,ve()|0)|0;E=Ke(k,l)|0;D=ze(-1)|0;C=ze(-1)|0;c[f>>2]=C;H=c[l>>2]|0;I=(D|0)<0|(D|0)>(H|0)?H:D;if((d|0)==22){lf(6,(C|0)<0?0:C,I,E)|0;i=e;return 0}else{lf(7,C,I,E)|0;i=e;return 0}break};case 24:{lf(5,0,0,ve()|0)|0;lf(12,0,0,ve()|0)|0;i=e;return 0};case 21:{E=Ee(g)|0;lf(5,0,0,ve()|0)|0;lf(13,ze(0)|0,0,j)|0;Je(c[g>>2]|0,E,2,c[j>>2]|0);lf(14,0,0,0)|0;i=e;return 0};case 25:{E=Ke(m,n)|0;I=ze(0)|0;C=ze(0)|0;c[f>>2]=C;if((C|0)==0){D=(c[n>>2]|0)-I|0;c[f>>2]=D;J=D}else{J=C}je(E+I|0,J);i=e;return 0};case 4:case 3:case 2:case 1:case 0:{I=c[c[814]>>2]|0;if((I|0)==1){K=(b[(c[(c[810]|0)+44>>2]|0)+((c[c[816]>>2]|0)*48|0)>>1]|0)==1?7:1}else{K=I}if((K|0)==7){L=0}else if((K|0)==15){M=6}else{mf(d,ye()|0);i=e;return 0}do{if((M|0)==6){I=c[c[816]>>2]|0;if((I|0)>1){E=dc(4)|0;c[E>>2]=2;td(E|0,568,0)}else{qe();L=I;break}}}while(0);I=He()|0;if((d|0)!=4){wf(d,L,-1,I);i=e;return 0}E=ye()|0;C=c[c[(c[812]|0)+20>>2]>>2]|0;D=xf(C,E)|0;if((D|0)==0){N=kf()|0}else{N=D}b[N>>1]=2;b[N+2>>1]=L;c[N+16>>2]=I;c[N+4>>2]=E;c[N+8>>2]=C;i=e;return 0};case 42:{c[z>>2]=0;C=Ke(z,A)|0;if((b[c[z>>2]>>1]|0)!=2){E=dc(4)|0;c[E>>2]=6;td(E|0,568,0)}E=ve()|0;I=Jm(E|0)|0;D=0;H=0;O=1;P=C;while(1){C=Zk(P,E)|0;do{if((H|0)==0){if((c[c[(c[812]|0)+84>>2]>>2]&8192|0)==0){Q=Ee(z)|0;R=0;M=108;break}if((D|0)==0){S=0;T=1;M=102}else{c[z>>2]=0;U=1;V=1}}else{S=D;T=H;M=102}}while(0);if((M|0)==102){M=0;W=c[z>>2]|0;X=S+1|0;if((W|0)!=0){if((X|0)<(c[W+8>>2]|0)){Q=X;R=T;M=108}else{if((c[W+12>>2]|0)!=0){M=105;break}fg(W,1,S+2|0);Q=X;R=T;M=108}}else{U=X;V=T}}if((M|0)==108){M=0;Y=c[z>>2]|0;if((Y|0)==0){U=Q;V=R}else{if((C|0)==0){M=110;break}X=C-P|0;W=c[844]|0;if((b[Y>>1]|0)==2){Z=2;_=W}else{if((Q|0)!=0){M=113;break}gg(Y,2);Z=b[Y>>1]|0;_=c[844]|0}c[Y+40>>2]=Q;$=c[_+((Z<<16>>16)*140|0)+68>>2]|0;aa=W+308|0;W=Nd[c[aa>>2]&63](Y)|0;Od[$&15](Y,W,X+1|0);W=Nd[c[aa>>2]&63](Y)|0;Mm(W|0,P|0,X|0)|0;a[W+X>>0]=0;U=Q;V=R}}if((C|0)==0){break}D=U;H=V;O=O+1|0;P=C+I|0}if((M|0)==105){I=dc(4)|0;c[I>>2]=7;td(I|0,568,0)}else if((M|0)==110){Je(Y,Q,2,P)}else if((M|0)==113){I=dc(4)|0;c[I>>2]=31;td(I|0,568,0)}if((c[c[(c[812]|0)+84>>2]>>2]&8192|0)==0){do{I=Ee(z)|0;Je(c[z>>2]|0,I,2,3360)}while((c[c[(c[812]|0)+84>>2]>>2]&8192|0)==0)}c[(c[810]|0)+784>>2]=O;i=e;return 0};case 34:{P=c[810]|0;c[P+820>>2]=c[P+812>>2];c[P+816>>2]=c[P+808>>2];P=Ee((c[810]|0)+808|0)|0;I=c[810]|0;c[I+812>>2]=P;H=c[I+808>>2]|0;if((b[H>>1]|0)==2){i=e;return 0}Je(H,P,2,3360);i=e;return 0};case 40:{P=c[810]|0;c[P+812>>2]=c[P+820>>2];c[P+808>>2]=c[P+816>>2];i=e;return 0};case 38:{lf(5,0,0,ve()|0)|0;P=c[810]|0;H=c[P+808>>2]|0;if((H|0)==0){I=dc(4)|0;c[I>>2]=3;td(I|0,568,0)}c[H+40>>2]=c[P+812>>2];P=Nd[c[(c[844]|0)+((b[H>>1]<<16>>16)*140|0)+28>>2]&63](H)|0;Wi(3216,P);lf(7,-1,Jm(P|0)|0,P)|0;i=e;return 0};case 31:{P=Ee(s)|0;H=c[s>>2]|0;c[H+40>>2]=P;P=Nd[c[(c[844]|0)+((b[H>>1]<<16>>16)*140|0)+28>>2]&63](H)|0;if((b[(c[s>>2]|0)+36>>1]&2)==0){H=dc(4)|0;c[H>>2]=6;td(H|0,568,0)}H=ze(0)|0;I=c[s>>2]|0;Od[c[(c[844]|0)+((b[I>>1]<<16>>16)*140|0)+68>>2]&15](I,P,(H|0)<64?64:H);i=e;return 0};case 32:{H=Ke(t,u)|0;P=Ke(t,v)|0;I=ze(0)|0;D=ze(0)|0;c[f>>2]=D;E=ze(0)|0;if((D|E|0)<0){X=dc(4)|0;c[X>>2]=20;td(X|0,568,0)}if((D+I|0)>(c[u>>2]|0)){X=dc(4)|0;c[X>>2]=20;td(X|0,568,0)}if((E+I|0)>(c[v>>2]|0)){X=dc(4)|0;c[X>>2]=20;td(X|0,568,0)}if((I|0)<=0){i=e;return 0}Nm(H+D|0,P+E|0,I|0)|0;i=e;return 0};case 33:{I=Ke(w,x)|0;E=ze(0)|0;P=ze(0)|0;c[f>>2]=P;D=ze(0)|0;if((D|0)<0){H=dc(4)|0;c[H>>2]=20;td(H|0,568,0)}if((P+D|0)>(c[x>>2]|0)){H=dc(4)|0;c[H>>2]=20;td(H|0,568,0)}if((P|0)<=0){i=e;return 0}Om(I+D|0,E&255|0,P|0)|0;i=e;return 0};case 35:{P=c[810]|0;E=c[P+808>>2]|0;if((E|0)==0){D=dc(4)|0;c[D>>2]=3;td(D|0,568,0)}c[E+40>>2]=c[P+812>>2];P=Nd[c[(c[844]|0)+((b[E>>1]<<16>>16)*140|0)+28>>2]&63](E)|0;Wi(3216,P);E=ve()|0;D=(Jm(E|0)|0)+8|0;I=c[(c[810]|0)+808>>2]|0;H=c[(c[844]|0)+((b[I>>1]|0)*140|0)+68>>2]|0;X=(Jm(P|0)|0)+D|0;Od[H&15](I,P,X);X=Mi(D)|0;Rm(X|0,E|0)|0;E=ze(-1)|0;D=ze(0)|0;c[f>>2]=D;P=c[810]|0;I=c[P+808>>2]|0;if((I|0)==0){H=dc(4)|0;c[H>>2]=3;td(H|0,568,0)}c[I+40>>2]=c[P+812>>2];Wi(3216,Nd[c[(c[844]|0)+((b[I>>1]<<16>>16)*140|0)+28>>2]&63](I)|0);$i(3216,X,E,D)|0;Oi(X);i=e;return 0};case 30:{lf(5,0,0,ve()|0)|0;X=ze(-1)|0;ee();D=de(c[(c[810]|0)+796>>2]|0,0,-1,X)|0;c[f>>2]=D;if((D|0)==0){i=e;return 0}else{D=dc(4)|0;c[D>>2]=12;td(D|0,568,0)}break};case 36:{D=ze(0)|0;X=c[810]|0;E=c[X+808>>2]|0;if((E|0)==0){I=dc(4)|0;c[I>>2]=3;td(I|0,568,0)}c[E+40>>2]=c[X+812>>2];Wi(3216,Nd[c[(c[844]|0)+((b[E>>1]<<16>>16)*140|0)+28>>2]&63](E)|0);$i(3216,0,D,1)|0;i=e;return 0};case 41:{D=c[810]|0;E=c[D+808>>2]|0;if((E|0)==0){X=dc(4)|0;c[X>>2]=3;td(X|0,568,0)}c[E+40>>2]=c[D+812>>2];Wi(3216,Nd[c[(c[844]|0)+((b[E>>1]<<16>>16)*140|0)+28>>2]&63](E)|0);E=Ee(y)|0;D=Yi(3216,ze(0)|0)|0;Je(c[y>>2]|0,E,2,D);Zi(3216);i=e;return 0};case 37:{lf(5,0,0,ve()|0)|0;D=ze(-1)|0;lf(8,0,0,0)|0;E=c[810]|0;X=E+788|0;I=c[X>>2]|0;if((I|0)<0){P=dc(4)|0;c[P>>2]=12;td(P|0,568,0)}if((D|0)<0|(I|0)<(D|0)){ba=I}else{c[X>>2]=D;ba=D}D=c[E+808>>2]|0;if((D|0)==0){X=dc(4)|0;c[X>>2]=3;td(X|0,568,0)}c[D+40>>2]=c[E+812>>2];E=Nd[c[(c[844]|0)+((b[D>>1]<<16>>16)*140|0)+28>>2]&63](D)|0;Wi(3216,E);D=c[(c[810]|0)+808>>2]|0;Od[c[(c[844]|0)+((b[D>>1]<<16>>16)*140|0)+68>>2]&15](D,E,ba+1|0);E=c[810]|0;D=c[E+808>>2]|0;if((D|0)==0){X=dc(4)|0;c[X>>2]=3;td(X|0,568,0)}c[D+40>>2]=c[E+812>>2];E=Nd[c[(c[844]|0)+((b[D>>1]<<16>>16)*140|0)+28>>2]&63](D)|0;Wi(3216,E);lf(6,0,ba,E)|0;a[E+ba>>0]=0;i=e;return 0};case 29:{E=Ee(q)|0;D=Ke(p,r)|0;X=ze(0)|0;I=ze(0)|0;c[f>>2]=I;P=ze(1024)|0;if((X|0)>=(c[r>>2]|0)){H=dc(4)|0;c[H>>2]=20;td(H|0,568,0)}H=Pe(P+1|0)|0;gl();W=il(D+X|0,H,I&255,P)|0;c[(c[810]|0)+784>>2]=W;W=hl()|0;c[(c[810]|0)+788>>2]=W;Je(c[q>>2]|0,E,2,H);i=e;return 0};case 39:{H=Sb(0)|0;c[f>>2]=H;Db(ze(H)|0);i=e;return 0};case 44:{ca=+Ae();da=+Ae();c[822]=ze(c[822]|0)|0;c[824]=0;h[415]=ca;h[413]=ca;ea=da-ca;h[416]=ea;h[414]=ea;i=e;return 0};case 43:{H=Ee(B)|0;E=c[B>>2]|0;if((b[E>>1]|0)!=2){W=dc(4)|0;c[W>>2]=6;td(W|0,568,0)}c[E+40>>2]=H;W=Nd[c[(c[844]|0)+308>>2]&63](E)|0;E=ve()|0;if((a[E>>0]|0)==0){P=dc(4)|0;c[P>>2]=3;td(P|0,568,0)}ol(W,E);E=pl(ve()|0)|0;Je(c[B>>2]|0,H,2,E);E=ql()|0;c[(c[810]|0)+784>>2]=E;i=e;return 0};default:{E=dc(4)|0;c[E>>2]=21;td(E|0,568,0)}}}while(0);return 0}function Sf(a){a=a|0;return 0}function Tf(a){a=a|0;c[a+16>>2]=6;return}function Uf(f,g){f=f|0;g=g|0;var j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,I=0,J=0,K=0,L=0,M=0.0,N=0,O=0,P=0,Q=0,R=0,S=0,Y=0,Z=0,_=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,pa=0,qa=0,ta=0,ua=0,va=0,xa=0,ya=0.0,za=0.0,Aa=0.0,Ba=0.0,Ca=0.0;j=i;i=i+1360|0;l=j;m=j+304|0;n=j+1328|0;o=j+292|0;p=j+288|0;q=j+284|0;r=j+280|0;t=j+296|0;u=j+268|0;v=j+264|0;w=j+260|0;x=j+256|0;y=j+272|0;z=j+276|0;if((c[c[814]>>2]|0)!=0){A=dc(4)|0;c[A>>2]=32;td(A|0,568,0)}if((c[c[816]>>2]|0)!=40){A=dc(4)|0;c[A>>2]=32;td(A|0,568,0)}qe();A=g>>7;if((A|0)==2){c[f>>2]=2;B=0}else if((A|0)==3){c[f>>2]=3;B=3272}else{c[f>>2]=4;B=3280}a:do{switch(g|0){case 11:case 10:case 9:{f=Ke(p,q)|0;A=ze(0)|0;if((A|0)<0){C=dc(4)|0;c[C>>2]=3;td(C|0,568,0)}C=f+A|0;if((g|0)==9){if((A|0)<(c[q>>2]|0)){c[820]=d[C>>0]|0;D=B;break a}else{f=dc(4)|0;c[f>>2]=3;td(f|0,568,0)}}else if((g|0)==10){if((A+2|0)>(c[q>>2]|0)){f=dc(4)|0;c[f>>2]=3;td(f|0,568,0)}else{c[820]=e[C>>1]|0;D=B;break a}}else{if((A+4|0)>(c[q>>2]|0)){A=dc(4)|0;c[A>>2]=3;td(A|0,568,0)}else{c[820]=c[C>>2];D=B;break a}}break};case 0:{if((ue()|0)<-1){C=dc(4)|0;c[C>>2]=32;td(C|0,568,0)}else{c[820]=c[(ig(c[134]|0,4)|0)>>2];D=B;break a}break};case 2:{c[820]=Jm(ve()|0)|0;D=B;break};case 7:{if((c[c[814]>>2]|0)!=2){Ee(o)|0;c[820]=b[c[o>>2]>>1]|0;D=B;break a}C=jg(ve()|0)|0;if((C|0)==0){A=dc(4)|0;c[A>>2]=3;td(A|0,568,0)}else{c[820]=b[C>>1]|0;D=B;break a}break};case 1:{C=ye()|0;if((C|0)==0){A=dc(4)|0;c[A>>2]=19;td(A|0,568,0)}else{c[820]=(Gm()|0)%(C|0)|0;D=B;break a}break};case 6:case 5:case 4:case 3:{c[820]=c[(Fe()|0)+(g+ -2<<2)+4>>2];D=B;break};case 8:{c[820]=fl(ye()|0)|0;D=B;break};case 16:{C=ye()|0;c[820]=C;if((C|0)<0){c[820]=0-C;D=B}else{D=B}break};case 256:{if((ue()|0)<-1){C=dc(4)|0;c[C>>2]=32;td(C|0,568,0)}else{D=ig(c[134]|0,2)|0;break a}break};case 13:{C=Ee(t)|0;A=c[t>>2]|0;if((b[A+36>>1]&128)==0){f=dc(4)|0;c[f>>2]=6;td(f|0,568,0)}else{c[A+40>>2]=C;C=Nd[c[(c[844]|0)+((b[A>>1]<<16>>16)*140|0)+28>>2]&63](A)|0;c[820]=Nd[c[(c[844]|0)+((b[c[t>>2]>>1]<<16>>16)*140|0)+60>>2]&63](C)|0;D=B;break a}break};case 17:{c[820]=jl(ye()|0,ye()|0,ye()|0)|0;D=B;break};case 257:{C=Ke(w,x)|0;if((b[c[w>>2]>>1]|0)!=2){A=dc(4)|0;c[A>>2]=6;td(A|0,568,0)}A=ye()|0;f=ye()|0;E=Jm(C|0)|0;if((A|0)<0){F=E-f|0;G=(F|0)<0?0:F}else{G=A}A=(G|0)<(E|0)?f:0;f=(A|0)>(E|0)?E:A;A=Pe(f+1|0)|0;b:do{if((f|0)>0){E=0;F=A;I=C+G|0;while(1){J=a[I>>0]|0;K=F+1|0;a[F>>0]=J;if(J<<24>>24==0){L=K;break b}E=E+1|0;if((E|0)>=(f|0)){L=K;break}else{F=K;I=I+1|0}}}else{L=A}}while(0);a[L>>0]=0;D=A;break};case 18:{f=ye()|0;C=ze(-1)|0;if((C|0)>0){M=+(f|0)/+(C|0)}else{M=+(f|0)*+h[419]}c[820]=~~+Vf(M);D=B;break};case 15:{f=Ke(u,v)|0;if((b[c[u>>2]>>1]|0)!=2){C=dc(4)|0;c[C>>2]=6;td(C|0,568,0)}C=ze(0)|0;if((C|0)>=(c[v>>2]|0)){I=dc(4)|0;c[I>>2]=20;td(I|0,568,0)}I=ve()|0;if((C|0)>-1?(F=f+C|0,C=Zk(F,I)|0,(C|0)!=0):0){c[820]=C-F;D=B;break a}c[820]=-1;D=B;break};case 14:{F=ze(0)|0;C=c[810]|0;I=c[C+808>>2]|0;if((I|0)==0){f=dc(4)|0;c[f>>2]=3;td(f|0,568,0)}c[I+40>>2]=c[C+812>>2];Wi(3216,Nd[c[(c[844]|0)+((b[I>>1]<<16>>16)*140|0)+28>>2]&63](I)|0);if((F|0)==0){c[820]=_i(3216)|0;D=B;break a}else if((F|0)==1){c[820]=Xi(3216)|0;D=B;break a}else{F=dc(4)|0;c[F>>2]=3;td(F|0,568,0)}break};case 259:{Km(m|0,ve()|0,1024)|0;a[m+1023>>0]=0;F=n+31|0;I=Mi(1024)|0;C=1024;f=m;E=0;c:while(1){K=0;while(1){N=f+K|0;J=a[N>>0]|0;if(J<<24>>24==37|J<<24>>24==0){break}K=K+1|0}O=K+E|0;if((O|0)>=(C|0)){J=C;while(1){if((O|0)<(J|0)){break}else{J=J<<1}}s=0;P=wa(1,I|0,J|0)|0;Q=s;s=0;if(Q&1){R=I;S=84;break}else{Y=P;Z=J}}else{Y=I;Z=C}Mm(Y+E|0,f|0,K|0)|0;if((a[N>>0]|0)==0){S=117;break}P=K+1|0;Q=ul(f+P|0,3336)|0;Km(n|0,N|0,32)|0;a[F>>0]=0;_=Q+2|0;if((_|0)<32){a[n+_>>0]=0}_=Q+P|0;P=a[f+_>>0]|0;Q=f+(_+1)|0;_=P<<24>>24;if(P<<24>>24==37){ca=O+1|0;if((ca|0)>=(Z|0)){da=Z;while(1){if((ca|0)<(da|0)){break}else{da=da<<1}}s=0;K=wa(1,Y|0,da|0)|0;J=s;s=0;if(J&1){R=Y;S=84;break}else{ea=K;fa=da}}else{ea=Y;fa=Z}a[ea+O>>0]=37;I=ea;C=fa;f=Q;E=ca;continue}else if(P<<24>>24==0){S=117;break}s=0;K=na(8)|0;J=s;s=0;if(J&1){R=Y;S=84;break}if((K|0)<-1){S=96;break}switch(_|0){case 71:case 103:case 69:case 101:case 102:{s=0;K=wa(7,c[134]|0,3)|0;J=s;s=0;if(J&1){R=Y;S=84;break c}else{ga=K;ha=3}break};case 115:{s=0;K=wa(7,c[134]|0,2)|0;J=s;s=0;if(J&1){R=Y;S=84;break c}else{ga=K;ha=2}break};case 112:case 117:case 88:case 120:case 111:case 99:case 105:case 100:{s=0;K=wa(7,c[134]|0,4)|0;J=s;s=0;if(J&1){R=Y;S=84;break c}else{ga=K;ha=4}break};default:{S=102;break c}}ia=Y;K=Z;d:while(1){J=K-O+ -1|0;ja=J<<1;ka=(ja|0)<32?32:ja;if((ha|0)==3){ja=ia+O|0;while(1){h[k>>3]=+h[ga>>3];c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];la=pm(ja,J,n,l)|0;ma=(la|0)>-1;if(ma&(la|0)<(J|0)){pa=la;break d}qa=(ma?la+1|0:ka)+O|0;if((qa|0)>=(K|0)){ta=qa;break}}}else if((ha|0)==4){ja=ia+O|0;while(1){c[l>>2]=c[ga>>2];qa=pm(ja,J,n,l)|0;la=(qa|0)>-1;if(la&(qa|0)<(J|0)){pa=qa;break d}ma=(la?qa+1|0:ka)+O|0;if((ma|0)>=(K|0)){ta=ma;break}}}else{ja=ia+O|0;while(1){c[l>>2]=ga;ma=pm(ja,J,n,l)|0;qa=(ma|0)>-1;if(qa&(ma|0)<(J|0)){pa=ma;break d}la=(qa?ma+1|0:ka)+O|0;if((la|0)>=(K|0)){ta=la;break}}}ka=K;while(1){if((ta|0)<(ka|0)){break}else{ka=ka<<1}}s=0;J=wa(1,ia|0,ka|0)|0;ja=s;s=0;if(ja&1){S=83;break c}else{ia=J;K=ka}}I=ia;C=K;f=Q;E=pa+O|0}if((S|0)==83){E=ub(-1,-1)|0;ua=ia;va=E;xa=H}else if((S|0)==84){E=ub(-1,-1)|0;ua=R;va=E;xa=H}else if((S|0)==96){E=dc(4)|0;c[E>>2]=32;s=0;sa(2,E|0,568,0);E=s;s=0;if(E&1){S=85}}else if((S|0)==102){E=dc(4)|0;c[E>>2]=32;s=0;sa(2,E|0,568,0);E=s;s=0;if(E&1){S=85}}else if((S|0)==117){a[Y+O>>0]=0;s=0;E=ra(23,O+1|0)|0;f=s;s=0;if(f&1){S=85}else{Rm(E|0,Y|0)|0;Oi(Y);D=E;break a}}if((S|0)==85){E=ub(-1,-1)|0;ua=Y;va=E;xa=H}s=0;oa(11,ua|0);E=s;s=0;if(E&1){E=ub(-1,-1,0)|0;Wf(E)}else{Cb(va|0)}break};case 12:{if((c[c[814]>>2]|0)==16){c[820]=c[(c[(c[810]|0)+840>>2]|0)+((c[c[816]>>2]|0)*28|0)+24>>2];qe();D=B;break a}else{E=Ee(r)|0;f=c[r>>2]|0;c[f+40>>2]=E;c[820]=Nd[c[(c[844]|0)+((b[f>>1]<<16>>16)*140|0)+28>>2]&63](f)|0;D=B;break a}break};case 395:{ya=+Ae();za=+Be(1.0);if(za==1.0){h[409]=+Vf(ya);D=B;break a}if(za==0.0){Aa=0.0}else{Aa=+Vf(ya/za)}h[409]=Aa;D=B;break};case 391:{h[409]=+aa(+(+Ae()));D=B;break};case 389:{if((ue()|0)<-1){f=dc(4)|0;c[f>>2]=32;td(f|0,568,0)}else{h[409]=+h[(ig(c[134]|0,3)|0)>>3];D=B;break a}break};case 260:{f=c[(c[810]|0)+824>>2]|0;Km(l|0,ve()|0,255)|0;$k(l,f,ye()|0);D=f;break};case 386:{h[409]=+X(+(+Ae()));D=B;break};case 385:{h[409]=+V(+(+Ae()));D=B;break};case 388:{h[409]=+T(+(+Ae()));D=B;break};case 261:{f=Ke(y,z)|0;if((b[c[y>>2]>>1]|0)!=2){E=dc(4)|0;c[E>>2]=6;td(E|0,568,0)}E=ze(0)|0;C=ze(32)|0;I=Pe((c[z>>2]|0)+1|0)|0;Rm(I|0,f|0)|0;if((E|0)==0){nl(I,C);ll(I,C);D=I;break a}else if((E|0)==2){ll(I,C);D=I;break a}else if((E|0)==3){ml(I,C);D=I;break a}else if((E|0)==1){nl(I,C);D=I;break a}else{D=I;break a}break};case 384:{h[409]=+W(+(+Ae()));D=B;break};case 390:{za=+Ae();h[409]=za;if(za<0.0){h[409]=-za;D=B}else{D=B}break};case 393:{za=+Ae();ya=+Ae();Ba=+Ae();Ca=za<ya?ya:za;h[409]=Ca>Ba?Ba:Ca;D=B;break};case 392:{h[409]=+ba(+(+Ae()));D=B;break};case 394:{Ca=+Ae();h[409]=+U(+Ca,+(+Ae()));D=B;break};case 387:{Ca=+Ae();h[409]=+$(+Ca,+(+Be(1.0)));D=B;break};default:{I=dc(4)|0;c[I>>2]=21;td(I|0,568,0)}}}while(0);if((c[c[814]>>2]|0)!=0){B=dc(4)|0;c[B>>2]=32;td(B|0,568,0)}if((c[c[816]>>2]|0)==41){qe();i=j;return D|0}else{D=dc(4)|0;c[D>>2]=32;td(D|0,568,0)}return 0}function Vf(a){a=+a;var b=0,d=0,e=0,f=0,g=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;b=i;i=i+16|0;d=b;e=c[822]|0;f=e&4095;if((e&4096|0)==0){g=a<0.0?0.0:a;if(g>1.0){j=0;k=1.0}else{j=0;k=g}}else{g=+yd(+a,d|0);j=~~+h[d>>3]&1;k=g}do{if((c[824]|0)!=(j|0)){c[824]=j;g=+h[413];if((j|0)==0){h[415]=g;h[416]=+h[414];break}else{a=+h[414];h[415]=g+a;h[416]=-a;break}}}while(0);do{switch(f|0){case 6:{a=k*2.0;if(a<1.0){l=+h[415]+a*a*a*+h[416]*.5;i=b;return+l}else{g=a+-2.0;l=+h[415]+(g*g*g+2.0)*+h[416]*.5;i=b;return+l}break};case 7:{l=+h[415]+k*k*k*k*+h[416];i=b;return+l};case 10:{g=1.0-k;a=+h[416];do{if(!(g<.36363636363636365)){if(g<.7272727272727273){m=g+-.5454545454545454;n=m*m*7.5625+.75;break}if(g<.9090909090909091){m=g+-.8181818181818182;n=m*m*7.5625+.9375;break}else{m=g+-.9545454545454546;n=m*m*7.5625+.984375;break}}else{n=g*g*7.5625}}while(0);l=+h[415]+(a-a*n);i=b;return+l};case 2:{l=+h[415]-(k+-2.0)*k*+h[416];i=b;return+l};case 4:{l=+h[415]+k*k*k*+h[416];i=b;return+l};case 1:{l=+h[415]+k*k*+h[416];i=b;return+l};case 3:{g=k*2.0;if(g<1.0){l=+h[415]+g*g*+h[416]*.5;i=b;return+l}else{m=g+-1.0;l=+h[415]+(m*(m+-2.0)+-1.0)*+h[416]*-.5;i=b;return+l}break};case 8:{m=k+-1.0;l=+h[415]-(m*m*m*m+-1.0)*+h[416];i=b;return+l};case 9:{m=k*2.0;if(m<1.0){l=+h[415]+m*m*m*m*+h[416]*.5;i=b;return+l}else{g=m+-2.0;l=+h[415]+(g*g*g*g+-2.0)*+h[416]*-.5;i=b;return+l}break};case 5:{g=k+-1.0;l=(g*g*g+1.0)*+h[416]+ +h[415];i=b;return+l};case 11:{do{if(!(k<.36363636363636365)){if(k<.7272727272727273){g=k+-.5454545454545454;o=(g*g*7.5625+.75)*+h[416];break}g=+h[416];if(k<.9090909090909091){m=k+-.8181818181818182;o=(m*m*7.5625+.9375)*g;break}else{m=k+-.9545454545454546;o=(m*m*7.5625+.984375)*g;break}}else{o=k*k*7.5625*+h[416]}}while(0);l=o+ +h[415];i=b;return+l};case 13:{a=1.0-k;g=+h[416];m=a*a*8.0;j=~~m;p=m- +(j|0);if((j&1|0)==0){q=p}else{q=1.0-p}l=+h[415]+(a*g*q-a*g*.5);i=b;return+l};case 14:{g=+h[416];a=k*k*8.0;j=~~a;p=a- +(j|0);if((j&1|0)==0){r=p}else{r=1.0-p}l=+h[415]+(k*g*r-k*g*.5);i=b;return+l};case 15:{g=k*2.0;if(g<1.0){p=1.0-g;a=+h[416];m=p*p*8.0;j=~~m;s=m- +(j|0);if((j&1|0)==0){t=s}else{t=1.0-s}l=+h[415]+(p*a*t-p*a*.5);i=b;return+l}else{a=g+-1.0;g=+h[416];p=a*a*8.0;j=~~p;s=p- +(j|0);if((j&1|0)==0){u=s}else{u=1.0-s}l=+h[415]+(a*g*u-a*g*.5);i=b;return+l}break};case 12:{g=k*2.0;if(k<.5){a=1.0-g;s=+h[416];do{if(!(a<.36363636363636365)){if(a<.7272727272727273){p=a+-.5454545454545454;v=p*p*7.5625+.75;break}if(a<.9090909090909091){p=a+-.8181818181818182;v=p*p*7.5625+.9375;break}else{p=a+-.9545454545454546;v=p*p*7.5625+.984375;break}}else{v=a*a*7.5625}}while(0);l=+h[415]+(s-s*v)*.5;i=b;return+l}else{a=g+-1.0;do{if(!(a<.36363636363636365)){if(a<.7272727272727273){p=+h[416];m=a+-.5454545454545454;w=(m*m*7.5625+.75)*p;x=p;break}p=+h[416];if(a<.9090909090909091){m=a+-.8181818181818182;w=(m*m*7.5625+.9375)*p;x=p;break}else{m=a+-.9545454545454546;w=(m*m*7.5625+.984375)*p;x=p;break}}else{p=+h[416];w=a*a*7.5625*p;x=p}}while(0);l=+h[415]+(x*.5+w*.5);i=b;return+l}break};default:{l=k*+h[416]+ +h[415];i=b;return+l}}}while(0);return 0.0}function Wf(a){a=a|0;Qa(a|0)|0;Ea()}function Xf(){var a=0;a=i;Ui(3216);cb(20,3216,q|0)|0;i=a;return}function Yf(){var a=0,d=0;a=i;d=Mi(1120)|0;c[844]=d;c[846]=8;b[d>>1]=0;b[d+140>>1]=0;b[d+280>>1]=0;b[d+420>>1]=0;b[d+560>>1]=0;b[d+700>>1]=0;b[d+840>>1]=0;b[d+980>>1]=0;d=Mi(384)|0;c[842]=d;b[d+2>>1]=-1;b[d>>1]=4;b[d+50>>1]=-1;b[d+48>>1]=4;b[d+98>>1]=-1;b[d+96>>1]=4;b[d+146>>1]=-1;b[d+144>>1]=4;b[d+194>>1]=-1;b[d+192>>1]=4;b[d+242>>1]=-1;b[d+240>>1]=4;b[d+290>>1]=-1;b[d+288>>1]=4;b[d+338>>1]=-1;b[d+336>>1]=4;i=a;return}function Zf(){var a=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;a=i;d=c[846]|0;e=c[842]|0;if((d|0)>0){f=d;g=e;h=0}else{j=e;Oi(j);k=c[844]|0;Oi(k);i=a;return}while(1){e=g+(h*48|0)|0;if((b[g+(h*48|0)+2>>1]|0)==1){Kd[c[(c[844]|0)+((b[e>>1]<<16>>16)*140|0)+52>>2]&31](e);l=c[846]|0;m=c[842]|0}else{l=f;m=g}h=h+1|0;if((h|0)>=(l|0)){j=m;break}else{f=l;g=m}}Oi(j);k=c[844]|0;Oi(k);i=a;return}function _f(a){a=a|0;var d=0,e=0,f=0;d=i;e=(c[846]|0)+a|0;c[848]=e;if((a|0)>-1){c[844]=Pi(c[844]|0,e*140|0)|0;c[842]=Pi(c[842]|0,(c[848]|0)*48|0)|0}e=c[844]|0;a=e+560|0;b[e+562>>1]=4;b[a>>1]=4;f=e+580|0;c[f>>2]=4;c[f+4>>2]=4;c[f+8>>2]=4;c[f+12>>2]=4;c[f+16>>2]=4;c[f+20>>2]=4;c[f+24>>2]=4;c[f+28>>2]=4;c[f+32>>2]=4;c[f+36>>2]=4;c[f+40>>2]=4;c[f+44>>2]=4;c[f+48>>2]=4;c[f+52>>2]=4;c[f+56>>2]=4;c[f+60>>2]=4;c[f+64>>2]=4;c[f+68>>2]=4;c[f+72>>2]=4;c[f+76>>2]=4;c[f+80>>2]=4;c[f+84>>2]=4;c[f+88>>2]=4;c[f+92>>2]=4;c[f+96>>2]=4;c[f+100>>2]=4;c[f+104>>2]=4;c[f+108>>2]=4;c[f+112>>2]=4;c[f+116>>2]=4;Fg(a);a=c[844]|0;f=a+280|0;b[a+282>>1]=2;b[f>>1]=2;e=a+300|0;c[e>>2]=4;c[e+4>>2]=4;c[e+8>>2]=4;c[e+12>>2]=4;c[e+16>>2]=4;c[e+20>>2]=4;c[e+24>>2]=4;c[e+28>>2]=4;c[e+32>>2]=4;c[e+36>>2]=4;c[e+40>>2]=4;c[e+44>>2]=4;c[e+48>>2]=4;c[e+52>>2]=4;c[e+56>>2]=4;c[e+60>>2]=4;c[e+64>>2]=4;c[e+68>>2]=4;c[e+72>>2]=4;c[e+76>>2]=4;c[e+80>>2]=4;c[e+84>>2]=4;c[e+88>>2]=4;c[e+92>>2]=4;c[e+96>>2]=4;c[e+100>>2]=4;c[e+104>>2]=4;c[e+108>>2]=4;c[e+112>>2]=4;c[e+116>>2]=4;lh(f);f=c[844]|0;e=f+420|0;b[f+422>>1]=3;b[e>>1]=3;a=f+440|0;c[a>>2]=4;c[a+4>>2]=4;c[a+8>>2]=4;c[a+12>>2]=4;c[a+16>>2]=4;c[a+20>>2]=4;c[a+24>>2]=4;c[a+28>>2]=4;c[a+32>>2]=4;c[a+36>>2]=4;c[a+40>>2]=4;c[a+44>>2]=4;c[a+48>>2]=4;c[a+52>>2]=4;c[a+56>>2]=4;c[a+60>>2]=4;c[a+64>>2]=4;c[a+68>>2]=4;c[a+72>>2]=4;c[a+76>>2]=4;c[a+80>>2]=4;c[a+84>>2]=4;c[a+88>>2]=4;c[a+92>>2]=4;c[a+96>>2]=4;c[a+100>>2]=4;c[a+104>>2]=4;c[a+108>>2]=4;c[a+112>>2]=4;c[a+116>>2]=4;lg(e);e=c[844]|0;a=e+700|0;b[e+702>>1]=5;b[a>>1]=5;f=e+720|0;c[f>>2]=4;c[f+4>>2]=4;c[f+8>>2]=4;c[f+12>>2]=4;c[f+16>>2]=4;c[f+20>>2]=4;c[f+24>>2]=4;c[f+28>>2]=4;c[f+32>>2]=4;c[f+36>>2]=4;c[f+40>>2]=4;c[f+44>>2]=4;c[f+48>>2]=4;c[f+52>>2]=4;c[f+56>>2]=4;c[f+60>>2]=4;c[f+64>>2]=4;c[f+68>>2]=4;c[f+72>>2]=4;c[f+76>>2]=4;c[f+80>>2]=4;c[f+84>>2]=4;c[f+88>>2]=4;c[f+92>>2]=4;c[f+96>>2]=4;c[f+100>>2]=4;c[f+104>>2]=4;c[f+108>>2]=4;c[f+112>>2]=4;c[f+116>>2]=4;xh(a);a=c[844]|0;f=a+140|0;b[a+142>>1]=1;b[f>>1]=1;e=a+160|0;c[e>>2]=4;c[e+4>>2]=4;c[e+8>>2]=4;c[e+12>>2]=4;c[e+16>>2]=4;c[e+20>>2]=4;c[e+24>>2]=4;c[e+28>>2]=4;c[e+32>>2]=4;c[e+36>>2]=4;c[e+40>>2]=4;c[e+44>>2]=4;c[e+48>>2]=4;c[e+52>>2]=4;c[e+56>>2]=4;c[e+60>>2]=4;c[e+64>>2]=4;c[e+68>>2]=4;c[e+72>>2]=4;c[e+76>>2]=4;c[e+80>>2]=4;c[e+84>>2]=4;c[e+88>>2]=4;c[e+92>>2]=4;c[e+96>>2]=4;c[e+100>>2]=4;c[e+104>>2]=4;c[e+108>>2]=4;c[e+112>>2]=4;c[e+116>>2]=4;ch(f);i=d;return}function $f(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;if((a|0)<0){f=c[846]|0;if((f|0)>=(c[848]|0)){i=e;return}c[846]=f+1;g=c[844]|0;b[g+(f*140|0)>>1]=0;h=c[842]|0;b[h+(f*48|0)+2>>1]=-1;b[h+(f*48|0)>>1]=4;if((f|0)<0){i=e;return}else{j=g;k=f}}else{j=c[844]|0;k=a}a=j+(k*140|0)|0;f=k&65535;b[j+(k*140|0)+2>>1]=f;b[a>>1]=f;f=j+(k*140|0)+20|0;c[f>>2]=4;c[f+4>>2]=4;c[f+8>>2]=4;c[f+12>>2]=4;c[f+16>>2]=4;c[f+20>>2]=4;c[f+24>>2]=4;c[f+28>>2]=4;c[f+32>>2]=4;c[f+36>>2]=4;c[f+40>>2]=4;c[f+44>>2]=4;c[f+48>>2]=4;c[f+52>>2]=4;c[f+56>>2]=4;c[f+60>>2]=4;c[f+64>>2]=4;c[f+68>>2]=4;c[f+72>>2]=4;c[f+76>>2]=4;c[f+80>>2]=4;c[f+84>>2]=4;c[f+88>>2]=4;c[f+92>>2]=4;c[f+96>>2]=4;c[f+100>>2]=4;c[f+104>>2]=4;c[f+108>>2]=4;c[f+112>>2]=4;c[f+116>>2]=4;Kd[d&31](a);i=e;return}function ag(){var a=0;a=dc(4)|0;c[a>>2]=21;td(a|0,568,0)}function bg(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;h=c[844]|0;Kd[c[h+((b[a>>1]<<16>>16)*140|0)+52>>2]&31](a);c[a+28>>2]=e;b[a>>1]=d;c[a+24>>2]=f;b[a+2>>1]=2;c[a+4>>2]=1;e=b[h+(d*140|0)+8>>1]|0;if(e<<16>>16<0){c[a+8>>2]=1}else{c[a+8>>2]=(f|0)/(e<<16>>16|0)|0}c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=1;i=g;return}function cg(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f;c[d+40>>2]=e;e=Nd[c[(c[844]|0)+((b[d>>1]<<16>>16)*140|0)+28>>2]&63](d)|0;Fd[c[(c[844]|0)+((b[d>>1]<<16>>16)*140|0)+64>>2]&15](d,e,g)|0;h=b[d>>1]|0;d=c[g>>2]|0;g=c[844]|0;Kd[c[g+((b[a>>1]<<16>>16)*140|0)+52>>2]&31](a);c[a+28>>2]=e;b[a>>1]=h;c[a+24>>2]=d;b[a+2>>1]=2;c[a+4>>2]=1;e=b[g+((h<<16>>16)*140|0)+8>>1]|0;if(e<<16>>16<0){c[a+8>>2]=1}else{c[a+8>>2]=(d|0)/(e<<16>>16|0)|0}c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=1;i=f;return}function dg(a,d,e,f,g,h){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0;j=i;k=c[844]|0;if((f|e|g|h|0)<0){l=dc(4)|0;c[l>>2]=3;td(l|0,568,0)}else{Kd[c[k+((b[a>>1]<<16>>16)*140|0)+52>>2]&31](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[k+(d*140|0)+6>>1]|0;c[a+8>>2]=e;c[a+12>>2]=f;c[a+16>>2]=g;c[a+20>>2]=h;Md[c[k+(d*140|0)+48>>2]&63](a,0);i=j;return}}function eg(a,d,e,f,g,h,j){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0;k=i;l=c[844]|0;if((g|f|h|j|0)<0){m=dc(4)|0;c[m>>2]=3;td(m|0,568,0)}else{Kd[c[l+((b[a>>1]<<16>>16)*140|0)+52>>2]&31](a);b[a>>1]=d;m=a+4|0;c[m>>2]=e;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[l+(d*140|0)+6>>1]|0;c[a+8>>2]=f;c[a+12>>2]=g;c[a+16>>2]=h;c[a+20>>2]=j;Md[c[l+(d*140|0)+48>>2]&63](a,0);c[m>>2]=1;i=k;return}}function fg(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;g=b[a>>1]|0;h=c[844]|0;c[a+(d<<2)+4>>2]=e;Md[c[h+(g*140|0)+48>>2]&63](a,a);i=f;return}function gg(a,d){a=a|0;d=d|0;var e=0,f=0;e=i;f=c[844]|0;Kd[c[f+((b[a>>1]<<16>>16)*140|0)+52>>2]&31](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;b[a+36>>1]=b[f+(d*140|0)+6>>1]|0;c[a+8>>2]=1;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;Md[c[f+(d*140|0)+48>>2]&63](a,0);i=e;return}function hg(a,d){a=a|0;d=d|0;var f=0,g=0,h=0;f=i;g=c[844]|0;Kd[c[g+((b[a>>1]<<16>>16)*140|0)+52>>2]&31](a);b[a>>1]=d;c[a+4>>2]=1;c[a+40>>2]=0;b[a+38>>1]=0;h=a+36|0;b[h>>1]=b[g+(d*140|0)+6>>1]|0;c[a+8>>2]=1;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;Md[c[g+(d*140|0)+48>>2]&63](a,0);b[h>>1]=e[h>>1]|0|256;i=f;return}function ig(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;f=b[a>>1]|0;g=c[844]|0;if((f|0)==(d|0)){h=Nd[c[g+(d*140|0)+28>>2]&63](a)|0;i=e;return h|0}j=Nd[c[g+(f*140|0)+28>>2]&63](a)|0;f=b[a>>1]|0;a=f<<16>>16;g=c[844]|0;if(f<<16>>16>7){h=Sd[c[g+(a*140|0)+24>>2]&15](j,d)|0;i=e;return h|0}else{h=Sd[c[g+(d*140|0)+20>>2]&15](j,a)|0;i=e;return h|0}return 0}function jg(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;e=c[846]|0;if((e|0)<=0){f=0;i=d;return f|0}g=c[844]|0;h=0;while(1){j=g+(h*140|0)|0;if((b[j>>1]|0)!=0?(Cm(c[g+(h*140|0)+12>>2]|0,a)|0)==0:0){f=j;k=6;break}h=h+1|0;if((h|0)>=(e|0)){f=0;k=6;break}}if((k|0)==6){i=d;return f|0}return 0}function kg(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;f=a+38|0;g=b[f>>1]|0;if(g<<16>>16>4){h=dc(4)|0;c[h>>2]=7;td(h|0,568,0)}if(g<<16>>16==0){c[a+44>>2]=1;j=1}else{h=a+44|0;k=da(c[h>>2]|0,c[a+(g<<16>>16<<2)+4>>2]|0)|0;c[h>>2]=k;j=k}k=g+1<<16>>16;b[f>>1]=k;if((d|0)<0){f=dc(4)|0;c[f>>2]=7;td(f|0,568,0)}if((c[a+(k<<16>>16<<2)+4>>2]|0)>(d|0)){k=da(j,d)|0;d=a+40|0;c[d>>2]=(c[d>>2]|0)+k;i=e;return}else{e=dc(4)|0;c[e>>2]=7;td(e|0,568,0)}}function lg(a){a=a|0;c[850]=a+2;c[a+72>>2]=3;c[a+20>>2]=8;c[a+28>>2]=24;c[a+56>>2]=25;c[a+64>>2]=5;c[a+68>>2]=4;c[a+48>>2]=5;c[a+52>>2]=21;c[a+76>>2]=6;c[a+80>>2]=7;c[a+84>>2]=8;c[a+88>>2]=9;c[a+92>>2]=10;c[a+108>>2]=11;c[a+112>>2]=12;c[a+116>>2]=13;c[a+120>>2]=14;c[a+124>>2]=15;c[a+128>>2]=16;c[a+12>>2]=3408;b[a+4>>1]=1;b[a+6>>1]=9;b[a+8>>1]=8;return}function mg(b,c,e){b=b|0;c=c|0;e=e|0;var f=0;b=e;e=b;f=d[e>>0]|d[e+1>>0]<<8|d[e+2>>0]<<16|d[e+3>>0]<<24;e=b+4|0;b=d[e>>0]|d[e+1>>0]<<8|d[e+2>>0]<<16|d[e+3>>0]<<24;e=c;c=e;a[c>>0]=f;a[c+1>>0]=f>>8;a[c+2>>0]=f>>16;a[c+3>>0]=f>>24;f=e+4|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;return}function ng(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;if((b|0)==4){h[427]=+(c[a>>2]|0);e=3416}else if((b|0)==2){h[427]=+wm(a);e=3416}else if((b|0)==3){e=a}else{a=dc(4)|0;c[a>>2]=6;td(a|0,568,0)}i=d;return e|0}function og(a){a=a|0;return(c[a+28>>2]|0)+(c[a+40>>2]<<3)|0}function pg(a){a=a|0;return 8}function qg(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function rg(a,b,c){a=a|0;b=b|0;c=c|0;return}function sg(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;g=c[f>>2]|0;if((g|0)<1){c[f>>2]=1;h=1}else{h=g}g=c[a+12>>2]|0;if((g|0)==0){j=h}else{j=da(g,h)|0}h=c[a+16>>2]|0;if((h|0)==0){k=j}else{k=da(h,j)|0}j=c[a+20>>2]|0;if((j|0)==0){l=k}else{l=da(j,k)|0}k=l<<3;b[a+2>>1]=1;j=Mi(k)|0;if((l&536870911|0)!=0){Om(j|0,0,((l&536870910)>>>0>1?l<<3:8)|0)|0}l=a+28|0;if((d|0)==0){m=a+24|0;c[l>>2]=j;c[m>>2]=k;i=e;return}else{d=a+24|0;Mm(j|0,c[l>>2]|0,c[d>>2]|0)|0;Oi(c[l>>2]|0);m=d;c[l>>2]=j;c[m>>2]=k;i=e;return}}function tg(a){a=a|0;var d=0,e=0,f=0;d=i;e=a+2|0;f=a+28|0;if((b[e>>1]|0)==1){Oi(c[f>>2]|0)}c[f>>2]=0;b[e>>1]=-1;i=d;return}function ug(a,d){a=a|0;d=d|0;h[a>>3]=+h[d>>3]+ +h[a>>3];b[c[850]>>1]=3;return}function vg(a,d){a=a|0;d=d|0;h[a>>3]=+h[a>>3]- +h[d>>3];b[c[850]>>1]=3;return}function wg(a,d){a=a|0;d=d|0;h[a>>3]=+h[d>>3]*+h[a>>3];b[c[850]>>1]=3;return}function xg(a,d){a=a|0;d=d|0;var e=0,f=0.0;e=i;f=+h[d>>3];if(f==0.0){d=dc(4)|0;c[d>>2]=19;td(d|0,568,0)}else{h[a>>3]=+h[a>>3]/f;b[c[850]>>1]=3;i=e;return}}function yg(a,d){a=a|0;d=d|0;var e=0,f=0.0;e=i;f=+h[d>>3];if(f==0.0){d=dc(4)|0;c[d>>2]=19;td(d|0,568,0)}else{h[a>>3]=+bc(+(+h[a>>3]),+f);b[c[850]>>1]=3;i=e;return}}function zg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]==+h[d>>3]&1;b[c[850]>>1]=4;return}function Ag(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]!=+h[d>>3]&1;b[c[850]>>1]=4;return}function Bg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]>+h[d>>3]&1;b[c[850]>>1]=4;return}function Cg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]<+h[d>>3]&1;b[c[850]>>1]=4;return}function Dg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]>=+h[d>>3]&1;b[c[850]>>1]=4;return}function Eg(a,d){a=a|0;d=d|0;c[a>>2]=+h[a>>3]<=+h[d>>3]&1;b[c[850]>>1]=4;return}function Fg(a){a=a|0;c[a+72>>2]=5;c[a+20>>2]=9;c[a+28>>2]=26;c[a+56>>2]=27;c[a+64>>2]=6;c[a+68>>2]=6;c[a+48>>2]=17;c[a+52>>2]=22;c[a+76>>2]=18;c[a+80>>2]=19;c[a+84>>2]=20;c[a+88>>2]=21;c[a+92>>2]=22;c[a+96>>2]=23;c[a+100>>2]=24;c[a+104>>2]=25;c[a+108>>2]=26;c[a+112>>2]=27;c[a+116>>2]=28;c[a+120>>2]=29;c[a+124>>2]=30;c[a+128>>2]=31;c[a+132>>2]=32;c[a+136>>2]=33;c[a+12>>2]=3424;b[a+4>>1]=1;b[a+6>>1]=9;b[a+8>>1]=4;return}function Gg(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[d>>2];return}function Hg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;if((d|0)==4){f=b;i=e;return f|0}else if((d|0)==3){c[858]=~~+h[b>>3];f=3432;i=e;return f|0}else if((d|0)==2){if((a[b>>0]|0)==36){g=kl(b)|0}else{g=xm(b)|0}c[858]=g;f=3432;i=e;return f|0}else{f=dc(4)|0;c[f>>2]=6;td(f|0,568,0)}return 0}function Ig(a){a=a|0;return(c[a+28>>2]|0)+(c[a+40>>2]<<2)|0}function Jg(a){a=a|0;return 4}function Kg(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function Lg(a,b,c){a=a|0;b=b|0;c=c|0;return}function Mg(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;g=c[f>>2]|0;if((g|0)<1){c[f>>2]=1;h=1}else{h=g}g=c[a+12>>2]|0;if((g|0)==0){j=h}else{j=da(g,h)|0}h=c[a+16>>2]|0;if((h|0)==0){k=j}else{k=da(h,j)|0}j=c[a+20>>2]|0;if((j|0)==0){l=k}else{l=da(j,k)|0}k=l<<2;b[a+2>>1]=1;j=Mi(k)|0;if((l&1073741823|0)!=0){Om(j|0,0,((l&1073741822)>>>0>1?l<<2:4)|0)|0}l=a+28|0;if((d|0)==0){m=a+24|0;c[l>>2]=j;c[m>>2]=k;i=e;return}else{d=a+24|0;Mm(j|0,c[l>>2]|0,c[d>>2]|0)|0;Oi(c[l>>2]|0);m=d;c[l>>2]=j;c[m>>2]=k;i=e;return}}function Ng(a){a=a|0;var d=0,e=0,f=0;d=i;e=a+2|0;f=a+28|0;if((b[e>>1]|0)==1){Oi(c[f>>2]|0)}c[f>>2]=0;b[e>>1]=-1;i=d;return}function Og(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)+(c[b>>2]|0);return}function Pg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)-(c[b>>2]|0);return}function Qg(a,b){a=a|0;b=b|0;c[a>>2]=da(c[a>>2]|0,c[b>>2]|0)|0;return}function Rg(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[b>>2]|0;if((e|0)==0){b=dc(4)|0;c[b>>2]=19;td(b|0,568,0)}else{c[a>>2]=(c[a>>2]|0)/(e|0)|0;i=d;return}}function Sg(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[b>>2]|0;if((e|0)==0){b=dc(4)|0;c[b>>2]=19;td(b|0,568,0)}else{c[a>>2]=(c[a>>2]|0)%(e|0)|0;i=d;return}}function Tg(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]&c[b>>2];return}function Ug(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]|c[b>>2];return}function Vg(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]^c[b>>2];return}function Wg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)==(c[b>>2]|0)&1;return}function Xg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)!=(c[b>>2]|0)&1;return}function Yg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)>(c[b>>2]|0)&1;return}function Zg(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)<(c[b>>2]|0)&1;return}function _g(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)>=(c[b>>2]|0)&1;return}function $g(a,b){a=a|0;b=b|0;c[a>>2]=(c[a>>2]|0)<=(c[b>>2]|0)&1;return}function ah(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]>>c[b>>2];return}function bh(a,b){a=a|0;b=b|0;c[a>>2]=c[a>>2]<<c[b>>2];return}function ch(a){a=a|0;c[a+72>>2]=7;c[a+28>>2]=28;c[a+56>>2]=29;c[a+60>>2]=30;c[a+64>>2]=7;c[a+68>>2]=8;c[a+48>>2]=34;c[a+52>>2]=23;c[a+12>>2]=3440;b[a+4>>1]=1;b[a+6>>1]=137;b[a+8>>1]=4;return}function dh(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[d>>2];return}function eh(a){a=a|0;return(c[a+28>>2]|0)+(c[a+40>>2]<<2)|0}function fh(a){a=a|0;return 4}function gh(a){a=a|0;return(c[a>>2]|0)!=0|0}function hh(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=(c[a+24>>2]|0)-b+(c[a+28>>2]|0);return b|0}function ih(a,b,c){a=a|0;b=b|0;c=c|0;return}function jh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;g=c[f>>2]|0;if((g|0)<1){c[f>>2]=1;h=1}else{h=g}g=c[a+12>>2]|0;if((g|0)==0){j=h}else{j=da(g,h)|0}h=c[a+16>>2]|0;if((h|0)==0){k=j}else{k=da(h,j)|0}j=c[a+20>>2]|0;if((j|0)==0){l=k}else{l=da(j,k)|0}k=l<<2;b[a+2>>1]=1;j=Mi(k)|0;if((l&1073741823|0)!=0){Om(j|0,0,((l&1073741822)>>>0>1?l<<2:4)|0)|0}l=a+28|0;if((d|0)==0){m=a+24|0;c[l>>2]=j;c[m>>2]=k;i=e;return}else{d=a+24|0;Mm(j|0,c[l>>2]|0,c[d>>2]|0)|0;Oi(c[l>>2]|0);m=d;c[l>>2]=j;c[m>>2]=k;i=e;return}}function kh(a){a=a|0;var d=0,e=0,f=0;d=i;e=a+2|0;f=a+28|0;if((b[e>>1]|0)==1){Oi(c[f>>2]|0)}c[f>>2]=0;b[e>>1]=-1;i=d;return}function lh(a){a=a|0;c[862]=a;c[a+72>>2]=9;c[a+20>>2]=10;c[a+28>>2]=31;c[a+56>>2]=32;c[a+64>>2]=8;c[a+68>>2]=10;c[a+48>>2]=35;c[a+52>>2]=24;c[a+76>>2]=36;c[a+108>>2]=37;c[a+112>>2]=38;c[a+12>>2]=3456;b[a+4>>1]=1;b[a+6>>1]=10;b[a+8>>1]=-1;return}function mh(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;f=i;if((b[a+2>>1]|0)==2){Km(d|0,e|0,c[a+24>>2]|0)|0;i=f;return}else{Qi(Si(d)|0,e);i=f;return}}function nh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d;if((b|0)==3){h[k>>3]=+h[a>>3];c[e>>2]=c[k>>2];c[e+4>>2]=c[k+4>>2];qm(3464,3872,e)|0;f=3464;i=d;return f|0}else if((b|0)==4){c[e>>2]=c[a>>2];qm(3464,3864,e)|0;f=3464;i=d;return f|0}else if((b|0)==2){f=a;i=d;return f|0}else{f=dc(4)|0;c[f>>2]=6;td(f|0,568,0)}return 0}function oh(a){a=a|0;var b=0,d=0;b=c[a+40>>2]|0;if((b|0)==0){d=a+28|0}else{d=(c[a+32>>2]|0)+(b<<2)|0}return c[d>>2]|0}function ph(a){a=a|0;var b=0,c=0;b=i;c=(Jm(a|0)|0)+1|0;i=b;return c|0}function qh(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;if((b[a+2>>1]|0)==2){g=d;h=a+24|0}else{g=d;h=(Li(d)|0)+8|0}c[e>>2]=c[h>>2];i=f;return g|0}function rh(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;f=i;if((b[a+2>>1]|0)==2){i=f;return}a=Si(d)|0;c[a>>2]=Pi(c[a>>2]|0,e)|0;i=f;return}function sh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;f=a+8|0;g=c[f>>2]|0;if((g|0)<1){c[f>>2]=1;h=1}else{h=g}g=(d|0)==0;if(g){j=0;k=0;l=0}else{j=(c[d+24>>2]|0)>>>2;k=c[d+32>>2]|0;l=c[d+28>>2]|0}d=c[a+12>>2]|0;if((d|0)==0){m=h}else{m=da(d,h)|0}h=c[a+16>>2]|0;if((h|0)==0){n=m}else{n=da(h,m)|0}m=c[a+20>>2]|0;if((m|0)==0){o=n}else{o=da(m,n)|0}n=o<<2;c[a+24>>2]=n;b[a+2>>1]=1;m=Nl(n,1)|0;n=a+32|0;c[n>>2]=m;if((m|0)==0){m=dc(4)|0;c[m>>2]=26;td(m|0,568,0)}if(g){g=c[a+4>>2]|0;m=(g|0)<64?64:g;g=o&1073741823;if((g|0)==0){i=e;return}h=a+28|0;d=0;do{if((d|0)==0){p=h}else{p=(c[n>>2]|0)+(d<<2)|0}f=Ni(m)|0;c[p>>2]=f;Ti(f,p);d=d+1|0}while((d|0)<(g|0));i=e;return}g=o&1073741823;if((g|0)!=0){o=a+28|0;a=0;do{d=(a|0)==0;if(d){q=o}else{q=(c[n>>2]|0)+(a<<2)|0}if((a|0)<(j|0)){if(d){r=l}else{r=c[k+(a<<2)>>2]|0}}else{r=Ni(64)|0}c[q>>2]=r;Ti(r,q);a=a+1|0}while((a|0)<(g|0))}Ml(k);i=e;return}function th(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;e=a+2|0;if((b[e>>1]|0)!=1){b[e>>1]=-1;i=d;return}f=c[a+8>>2]|0;g=c[a+12>>2]|0;if((g|0)==0){h=f}else{h=da(g,f)|0}f=c[a+16>>2]|0;if((f|0)==0){j=h}else{j=da(f,h)|0}h=c[a+20>>2]|0;if((h|0)==0){k=j}else{k=da(h,j)|0}c[a+24>>2]=k<<2;j=k&1073741823;if((j|0)==0){l=a+32|0}else{k=a+28|0;h=a+32|0;a=0;do{if((a|0)==0){m=k}else{m=(c[h>>2]|0)+(a<<2)|0}Oi(c[m>>2]|0);a=a+1|0}while((a|0)<(j|0));l=h}Ml(c[l>>2]|0);b[e>>1]=-1;i=d;return}function uh(a,d){a=a|0;d=d|0;var e=0;e=i;Ri(Si(a)|0,d);b[(c[862]|0)+2>>1]=2;i=e;return}function vh(a,d){a=a|0;d=d|0;var e=0,f=0;e=i;f=(Cm(a,d)|0)==0;c[a>>2]=f?1:0;b[(c[862]|0)+2>>1]=4;i=e;return}function wh(a,d){a=a|0;d=d|0;var e=0;e=i;c[a>>2]=Cm(a,d)|0;b[(c[862]|0)+2>>1]=4;i=e;return}function xh(a){a=a|0;c[a+72>>2]=11;c[a+28>>2]=33;c[a+56>>2]=34;c[a+60>>2]=35;c[a+64>>2]=9;c[a+68>>2]=12;c[a+48>>2]=39;c[a+52>>2]=25;c[a+12>>2]=3880;b[a+4>>1]=1;b[a+6>>1]=137;b[a+8>>1]=16;return}function yh(a,d,e){a=a|0;d=d|0;e=e|0;a=i;b[e>>1]=2;if((b[d>>1]|0)==1){Oi(c[d+12>>2]|0)}c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];i=a;return}function zh(a){a=a|0;return(c[a+28>>2]|0)+(c[a+40>>2]<<4)|0}function Ah(a){a=a|0;return 16}function Bh(a){a=a|0;return b[a>>1]|0}function Ch(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b+8>>2];return c[b+12>>2]|0}function Dh(a,b,c){a=a|0;b=b|0;c=c|0;return}function Eh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=a+8|0;g=c[f>>2]|0;if((g|0)<1){c[f>>2]=1;h=1}else{h=g}b[a+2>>1]=1;g=h<<4;h=Mi(g)|0;if((c[f>>2]|0)>0){j=h;k=0;while(1){c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;b[j>>1]=0;k=k+1|0;if((k|0)>=(c[f>>2]|0)){break}else{j=j+16|0}}}j=a+28|0;if((d|0)==0){l=a+24|0;c[j>>2]=h;c[l>>2]=g;i=e;return}else{d=a+24|0;Mm(h|0,c[j>>2]|0,c[d>>2]|0)|0;Oi(c[j>>2]|0);l=d;c[j>>2]=h;c[l>>2]=g;i=e;return}}function Fh(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;e=a+2|0;if((b[e>>1]|0)!=1){b[e>>1]=-1;i=d;return}Oe(a);f=a+28|0;g=a+8|0;a=c[g>>2]|0;if((a|0)>0){h=a;a=c[f>>2]|0;j=0;while(1){if((b[a>>1]|0)==1){Oi(c[a+12>>2]|0);k=c[g>>2]|0}else{k=h}j=j+1|0;if((j|0)>=(k|0)){break}else{h=k;a=a+16|0}}}Oi(c[f>>2]|0);b[e>>1]=-1;i=d;return}function Gh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;d=a+36|0;e=a+32|0;f=Ll(68)|0;g=f+0|0;h=g+68|0;do{c[g>>2]=0;g=g+4|0}while((g|0)<(h|0));c[d>>2]=17;c[e>>2]=f;f=yj()|0;Jh(a,0,2,0,0,f,zj()|0);c[972]=a;f=a+44|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;i=b;return}function Hh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;b=i;d=a+36|0;e=c[d>>2]|0;f=a+32|0;a=c[f>>2]|0;if((e|0)>0){g=e;h=a;j=0}else{k=a;Ml(k);i=b;return}while(1){l=c[h+(j<<2)>>2]|0;if((l|0)==0){m=g;n=h}else{if((c[l>>2]|0)==1){s=0;oa(26,l|0);a=s;s=0;if(a&1){o=7;break}s=0;oa(27,l|0);a=s;s=0;if(a&1){o=7;break}}Tl(l);m=c[d>>2]|0;n=c[f>>2]|0}j=j+1|0;if((j|0)>=(m|0)){k=n;o=9;break}else{g=m;h=n}}if((o|0)==7){n=ub(-1,-1)|0;Tl(l);Cb(n|0)}else if((o|0)==9){Ml(k);i=b;return}}function Ih(a){a=a|0;return 0}function Jh(d,e,f,g,h,j,k){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,t=0,u=0;h=i;g=e+1|0;l=d+36|0;m=c[l>>2]|0;if((m|0)<=(e|0)){n=Ll(g<<2)|0;do{if((e|0)>-1){o=d+32|0;if((m|0)==0){Om(n|0,0,((g|0)>1?g<<2:4)|0)|0;p=o;break}else{q=0}do{if((q|0)<(m|0)){c[n+(q<<2)>>2]=c[(c[o>>2]|0)+(q<<2)>>2]}else{c[n+(q<<2)>>2]=0}q=q+1|0}while((q|0)<(g|0));p=o}else{p=d+32|0}}while(0);q=c[p>>2]|0;if((q|0)!=0){Ml(q)}c[l>>2]=g;c[p>>2]=n}n=d+32|0;p=c[n>>2]|0;g=c[p+(e<<2)>>2]|0;if((g|0)==0){r=p}else{if((c[g>>2]|0)==1){s=0;oa(26,g|0);p=s;s=0;if(p&1){t=ub(-1,-1)|0;u=H;Tl(g);Cb(t|0)}s=0;oa(27,g|0);p=s;s=0;if(p&1){t=ub(-1,-1)|0;u=H;Tl(g);Cb(t|0)}}Tl(g);r=c[n>>2]|0}n=Rl(640)|0;c[r+(e<<2)>>2]=n;c[n+32>>2]=e;c[n+28>>2]=f;c[n+280>>2]=-1;c[n>>2]=1;c[n+168>>2]=0;c[n+164>>2]=0;c[n+4>>2]=j;c[n+8>>2]=k;c[n+152>>2]=j;Oh(n,0);c[n+188>>2]=-1;c[n+136>>2]=1;b[n+36>>1]=1;b[n+38>>1]=1;a[n+216>>0]=0;c[n+184>>2]=d;i=h;return}function Kh(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;g=i;h=e+1|0;j=d+36|0;k=c[j>>2]|0;if((k|0)<=(e|0)){l=Ll(h<<2)|0;do{if((e|0)>-1){m=d+32|0;if((k|0)==0){Om(l|0,0,((h|0)>1?h<<2:4)|0)|0;n=m;break}else{o=0}do{if((o|0)<(k|0)){c[l+(o<<2)>>2]=c[(c[m>>2]|0)+(o<<2)>>2]}else{c[l+(o<<2)>>2]=0}o=o+1|0}while((o|0)<(h|0));n=m}else{n=d+32|0}}while(0);o=c[n>>2]|0;if((o|0)!=0){Ml(o)}c[j>>2]=h;c[n>>2]=l}l=d+32|0;n=c[l>>2]|0;h=c[n+(e<<2)>>2]|0;if((h|0)==0){p=n}else{if((c[h>>2]|0)==1){s=0;oa(26,h|0);n=s;s=0;if(n&1){q=ub(-1,-1)|0;r=H;Tl(h);Cb(q|0)}s=0;oa(27,h|0);n=s;s=0;if(n&1){q=ub(-1,-1)|0;r=H;Tl(h);Cb(q|0)}}Tl(h);p=c[l>>2]|0}l=Rl(640)|0;c[l>>2]=0;c[p+(e<<2)>>2]=l;c[l+32>>2]=e;c[l+28>>2]=1;c[l+280>>2]=-1;if((Fj(l,f)|0)<0){e=dc(4)|0;c[e>>2]=13;td(e|0,568,0)}else{e=c[l+4>>2]|0;c[l>>2]=1;c[l+168>>2]=0;c[l+164>>2]=0;c[l+152>>2]=e;Oh(l,0);c[l+188>>2]=-1;c[l+136>>2]=1;b[l+36>>1]=1;b[l+38>>1]=1;e=l+216|0;a[e>>0]=0;Km(e|0,f|0,63)|0;c[l+184>>2]=d;i=g;return}}function Lh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;e=i;f=c[(c[a+32>>2]|0)+(b<<2)>>2]|0;do{if((f|0)!=0?(c[f>>2]|0)!=0:0){g=c[f+28>>2]|0;if((g|0)==2){h=0;break}else if((g|0)==1){Kh(a,b,d);h=0;break}else{g=dc(4)|0;c[g>>2]=21;td(g|0,568,0)}}else{h=1}}while(0);i=e;return h|0}function Mh(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;if((b|0)<0){e=dc(4)|0;c[e>>2]=3;td(e|0,568,0)}if((c[a+36>>2]|0)<=(b|0)){e=dc(4)|0;c[e>>2]=3;td(e|0,568,0)}e=c[(c[a+32>>2]|0)+(b<<2)>>2]|0;if((e|0)==0){b=dc(4)|0;c[b>>2]=3;td(b|0,568,0)}if((c[e>>2]|0)==0){b=dc(4)|0;c[b>>2]=3;td(b|0,568,0)}else{i=d;return e|0}return 0}function Nh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;d=c[a+36>>2]|0;a:do{if((d|0)>0){e=c[a+32>>2]|0;f=0;while(1){g=c[e+(f<<2)>>2]|0;if((g|0)==0){h=f;break a}if((c[g>>2]|0)==0){h=f;break a}f=f+1|0;if((f|0)>=(d|0)){h=d;break}}}else{h=d}}while(0);i=b;return h|0}function Oh(d,e){d=d|0;e=e|0;var f=0,g=0;e=i;f=d+568|0;g=f+63|0;do{a[f>>0]=0;f=f+1|0}while((f|0)<(g|0));c[d+632>>2]=18;c[d+636>>2]=0;Dj(3896,18,0)|0;qi(d);c[d+68>>2]=0;c[d+72>>2]=0;f=d+284|0;g=f;b[g>>1]=0;b[g+2>>1]=0>>>16;g=f+4|0;b[g>>1]=0;b[g+2>>1]=0>>>16;c[d+104>>2]=-16777216;c[d+108>>2]=0;c[d+76>>2]=64;c[d+80>>2]=32;c[d+84>>2]=0;c[d+92>>2]=32;c[d+96>>2]=32;c[d+100>>2]=0;c[d+160>>2]=0;g=d+176|0;f=g;b[f>>1]=0;b[f+2>>1]=0>>>16;f=g+4|0;b[f>>1]=0;b[f+2>>1]=0>>>16;f=c[d+4>>2]|0;b[d+208>>1]=f;g=c[d+8>>2]|0;b[d+210>>1]=g;b[d+204>>1]=(f|0)/(f<<16>>16|0)|0;b[d+206>>1]=(g|0)/(g<<16>>16|0)|0;b[d+212>>1]=0;b[d+214>>1]=0;b[d+38>>1]=b[d+36>>1]|0;if((c[d+32>>2]|0)==0){Zj(d)}g=d+292|0;f=d+308|0;c[g+0>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[f>>2]=-2;c[d+312>>2]=0;c[d+316>>2]=0;c[d+320>>2]=0;c[d+324>>2]=-2;c[d+328>>2]=0;c[d+332>>2]=0;c[d+336>>2]=0;c[d+340>>2]=-2;c[d+344>>2]=0;c[d+348>>2]=0;c[d+352>>2]=0;c[d+356>>2]=-2;c[d+360>>2]=0;c[d+364>>2]=0;c[d+368>>2]=0;c[d+372>>2]=-2;c[d+376>>2]=0;c[d+380>>2]=0;c[d+384>>2]=0;c[d+388>>2]=-2;c[d+392>>2]=0;c[d+396>>2]=0;c[d+400>>2]=0;c[d+404>>2]=-2;c[d+408>>2]=0;c[d+412>>2]=0;c[d+416>>2]=0;c[d+420>>2]=-2;c[d+424>>2]=0;c[d+428>>2]=0;c[d+432>>2]=0;c[d+436>>2]=-2;c[d+440>>2]=0;c[d+444>>2]=0;c[d+448>>2]=0;c[d+452>>2]=-2;c[d+456>>2]=0;c[d+460>>2]=0;c[d+464>>2]=0;c[d+468>>2]=-2;c[d+472>>2]=0;c[d+476>>2]=0;c[d+480>>2]=0;c[d+484>>2]=-2;c[d+488>>2]=0;c[d+492>>2]=0;c[d+496>>2]=0;c[d+500>>2]=-2;c[d+504>>2]=0;c[d+508>>2]=0;c[d+512>>2]=0;c[d+516>>2]=-2;c[d+520>>2]=0;c[d+524>>2]=0;c[d+528>>2]=0;c[d+532>>2]=-2;c[d+536>>2]=0;c[d+540>>2]=0;c[d+544>>2]=0;c[d+548>>2]=-2;i=e;return}function Ph(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;Km(a+568|0,b|0,63)|0;c[a+632>>2]=d;c[a+636>>2]=e;Dj(b,d,e)|0;i=f;return}function Qh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+104>>2]=b<<16|d<<8&65280|e&255|-16777216;return}function Rh(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;if((d|0)>0){b[a+208>>1]=d;h=d}else{d=c[a+4>>2]|0;b[a+208>>1]=d;h=d}if((e|0)>0){b[a+210>>1]=e;i=e;j=c[a+8>>2]|0}else{e=c[a+8>>2]|0;b[a+210>>1]=e;i=e;j=e}b[a+204>>1]=(c[a+4>>2]|0)/(h<<16>>16|0)|0;b[a+206>>1]=(j|0)/(i<<16>>16|0)|0;b[a+212>>1]=f;b[a+214>>1]=g;return}function Sh(a,b){a=a|0;b=b|0;return}function Th(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return}function Uh(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a+84>>2]|0;e=a+72|0;c[e>>2]=((d|0)>(b|0)?d:b)+(c[e>>2]|0);return}function Vh(a,b){a=a|0;b=b|0;c[a+104>>2]=b;return}function Wh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;d=a+568|0;e=a+632|0;f=c[e>>2]|0;g=a+636|0;a=c[g>>2]|0;Km(d|0,d|0,63)|0;c[e>>2]=f;c[g>>2]=a;Dj(d,f,a)|0;i=b;return}function Xh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=i;Dj(b,c,d)|0;i=a;return}function Yh(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;e=i;Ej(a,d)|0;d=b[a+158>>1]|0;f=c[a+84>>2]|0;g=a+72|0;c[g>>2]=((f|0)>(d|0)?f:d)+(c[g>>2]|0);i=e;return}function Zh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0;f=i;Lj(a,+(b|0),+(c|0),+(d|0),+(e|0));i=f;return}function _h(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0.0;d=i;e=+(b|0);f=+(c|0);Jj(a,e,f);Kj(e,f);Jj(0,0.0,0.0);i=d;return}function $h(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;f=a+68|0;g=a+72|0;Jj(a,+(c[f>>2]|0),+(c[g>>2]|0));Kj(+(b|0),+(d|0));Jj(0,0.0,0.0);c[f>>2]=b;c[g>>2]=d;i=e;return}function ai(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;Mj(a,+(b|0),+(c|0),+(d|0),+(e|0),f);i=g;return}function bi(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;h=i;j=f+d|0;k=g+e|0;do{if((j|0)>=0){l=c[b+4>>2]|0;if((j|0)<(l|0)){m=f}else{if((l|0)<=(d|0)){n=-1;break}m=l-d|0}if((k|0)>=0){l=c[b+8>>2]|0;if((k|0)<(l|0)){o=g}else{if((l|0)<=(e|0)){n=-1;break}o=l-e|0}Pj(a,d&65535,e&65535,m&65535,o&65535,b,+(m|0),+(o|0));n=0}else{n=-1}}else{n=-1}}while(0);i=h;return n|0}function ci(a,b,d,e,f,g,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0;k=i;l=h+f|0;m=j+g|0;do{if((l|0)>=0){n=c[e+4>>2]|0;if((l|0)<(n|0)){o=h}else{if((n|0)<=(f|0)){p=-1;break}o=n-f|0}if((m|0)>=0){n=c[e+8>>2]|0;if((m|0)<(n|0)){q=j}else{if((n|0)<=(g|0)){p=-1;break}q=n-g|0}Pj(a,f&65535,g&65535,o&65535,q&65535,e,+(b|0),+(d|0));p=0}else{p=-1}}else{p=-1}}while(0);i=k;return p|0}function di(a,b){a=a|0;b=b|0;return 0}function ei(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=e&255;e=d&255;d=(b|0)%192|0;b=(d|0)%32|0;g=((da(8160-(e<<5)|0,f)|0)+4080|0)/8160|0;h=((da(8160-(da(b,e)|0)|0,f)|0)+4080|0)/8160|0;i=((da(8160-(da(32-b|0,e)|0)|0,f)|0)+4080|0)/8160|0;switch((d|0)/32|0|0){case 5:{j=h;k=g;l=f;break};case 2:{j=i;k=f;l=g;break};case 4:{j=f;k=g;l=i;break};case 1:{j=g;k=f;l=h;break};case 6:case 0:{j=g;k=i;l=f;break};case 3:{j=f;k=h;l=g;break};default:{j=0;k=0;l=0}}c[a+104>>2]=j&255|k<<8&65280|l<<16|-16777216;return}function fi(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0;k=i;i=i+48|0;l=k+32|0;m=k;n=k+16|0;c[l>>2]=b;c[m>>2]=d;o=e+b|0;c[l+4>>2]=o;c[m+4>>2]=d;c[l+8>>2]=o;o=f+d|0;c[m+8>>2]=o;c[l+12>>2]=b;c[m+12>>2]=o;if((g|0)==0){c[n+12>>2]=h;c[n>>2]=h;c[n+8>>2]=j;c[n+4>>2]=j;Sj(a,l,m,n);i=k;return}else{c[n+4>>2]=h;c[n>>2]=h;c[n+12>>2]=j;c[n+8>>2]=j;Sj(a,l,m,n);i=k;return}}function gi(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;j=i;i=i+16|0;k=j;if((h|0)>=0){Rj(a,b,d,e,f,g);i=j;return}if((h|0)==-257){Sj(a,b,d,f);i=j;return}else{f=c[a+104>>2]|0;c[k+12>>2]=f;c[k+8>>2]=f;c[k+4>>2]=f;c[k>>2]=f;Sj(a,b,d,k);i=j;return}}function hi(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;var g=0;g=i;Nj(a,+(b|0),+(c|0),+(d|0),+(e|0),f);i=g;return}function ii(a,b,c,d,e,f,g,h,j){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;k=i;Qj(a,f&65535,g&65535,h&65535,j&65535,+(b>>1|0),+(c>>1|0),e,+(b|0),+(c|0),d);i=k;return}function ji(a,d,e,f,g,h){a=a|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0;j=i;k=b[d+208>>1]|0;l=b[d+210>>1]|0;m=b[d+204>>1]|0;n=da((e|0)%(m|0)|0,k)|0;o=da((e|0)/(m|0)|0,l)|0;m=n+k|0;e=o+l|0;if((m|0)<0){p=-1;i=j;return p|0}q=c[d+4>>2]|0;do{if((m|0)>=(q|0)){if((n|0)<(q|0)){r=q-n|0;break}else{p=-1;i=j;return p|0}}else{r=k}}while(0);if((e|0)<0){p=-1;i=j;return p|0}k=c[d+8>>2]|0;do{if((e|0)>=(k|0)){if((o|0)<(k|0)){s=k-o|0;break}else{p=-1;i=j;return p|0}}else{s=l}}while(0);t=+(r|0)*f;l=a+68|0;k=(c[l>>2]|0)+~~t|0;e=a+72|0;q=c[e>>2]|0;Qj(a,n&65535,o&65535,r&65535,s&65535,+(b[d+212>>1]|0)*f,+(b[d+214>>1]|0)*g,d,t,+(s|0)*g,h);c[l>>2]=k;c[e>>2]=q;p=0;i=j;return p|0}function ki(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;g=b[d+208>>1]|0;h=b[d+210>>1]|0;j=b[d+204>>1]|0;k=da((e|0)%(j|0)|0,g)|0;l=da((e|0)/(j|0)|0,h)|0;j=k+g|0;e=l+h|0;if((j|0)<0){m=-1;i=f;return m|0}n=c[d+4>>2]|0;do{if((j|0)>=(n|0)){if((k|0)<(n|0)){o=n-k|0;break}else{m=-1;i=f;return m|0}}else{o=g}}while(0);if((e|0)<0){m=-1;i=f;return m|0}g=c[d+8>>2]|0;do{if((e|0)>=(g|0)){if((l|0)<(g|0)){p=g-l|0;break}else{m=-1;i=f;return m|0}}else{p=h}}while(0);h=a+68|0;g=c[h>>2]|0;e=a+72|0;n=c[e>>2]|0;c[h>>2]=g-(b[d+212>>1]|0);c[e>>2]=n-(b[d+214>>1]|0);Pj(a,k&65535,l&65535,o&65535,p&65535,d,+(o|0),+(p|0));c[h>>2]=g+o;c[e>>2]=n;m=0;i=f;return m|0}function li(a,b){a=a|0;b=b|0;a=i;Aj(b,0);i=a;return}



function Ek(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0;g=i;i=i+5104|0;h=g;j=g+4080|0;k=g+4072|0;l=c[b>>2]|0;m=b+8|0;c[m>>2]=0;n=b+4|0;c[n>>2]=0;o=b+12|0;c[o>>2]=0;p=l+168|0;q=l+172|0;r=l+32|0;s=l+16|0;t=l+28|0;u=l+40|0;v=l+36|0;w=c[p>>2]|0;x=0;while(1){if(!(w>>>0<(c[q>>2]|0)>>>0)){if((c[r>>2]|0)==0){y=0;z=w}else{A=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((A|0)==0){c[r>>2]=0;B=(c[q>>2]|0)+ -1|0;c[p>>2]=B;a[B>>0]=0;C=c[p>>2]|0}else{c[p>>2]=u;c[q>>2]=l+A+40;C=u}A=C+1|0;c[p>>2]=A;y=d[C>>0]|0;z=A}}else{A=w+1|0;c[p>>2]=A;y=d[w>>0]|0;z=A}if(!((y&255)<<24>>24==(a[26912+x>>0]|0))){D=11;break}x=x+1|0;if((x|0)>=8){break}else{w=z}}if((D|0)==11){c[6510]=26920;E=0;i=g;return E|0}if((e|0)==1){E=1;i=g;return E|0}w=l+20|0;x=l+4|0;y=l+8|0;C=(e|0)==2;A=z;z=1;B=0;F=0;G=0;H=0;I=0;J=0;K=0;a:while(1){L=c[q>>2]|0;if(!(A>>>0<L>>>0)){if((c[r>>2]|0)==0){M=0;N=A;O=L}else{P=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((P|0)==0){c[r>>2]=0;Q=(c[q>>2]|0)+ -1|0;c[p>>2]=Q;a[Q>>0]=0;R=c[q>>2]|0;S=c[p>>2]|0}else{c[p>>2]=u;Q=l+P+40|0;c[q>>2]=Q;R=Q;S=u}Q=S+1|0;c[p>>2]=Q;M=d[S>>0]|0;N=Q;O=R}}else{Q=A+1|0;c[p>>2]=Q;M=d[A>>0]|0;N=Q;O=L}L=M<<8;if(!(N>>>0<O>>>0)){if((c[r>>2]|0)==0){T=0;U=N;V=O}else{Q=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Q|0)==0){c[r>>2]=0;P=(c[q>>2]|0)+ -1|0;c[p>>2]=P;a[P>>0]=0;W=c[q>>2]|0;X=c[p>>2]|0}else{c[p>>2]=u;P=l+Q+40|0;c[q>>2]=P;W=P;X=u}P=X+1|0;c[p>>2]=P;T=d[X>>0]|0;U=P;V=W}}else{P=N+1|0;c[p>>2]=P;T=d[N>>0]|0;U=P;V=O}P=(T|L)<<16;if(!(U>>>0<V>>>0)){if((c[r>>2]|0)==0){Y=0;Z=U;_=V}else{L=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((L|0)==0){c[r>>2]=0;Q=(c[q>>2]|0)+ -1|0;c[p>>2]=Q;a[Q>>0]=0;$=c[q>>2]|0;aa=c[p>>2]|0}else{c[p>>2]=u;Q=l+L+40|0;c[q>>2]=Q;$=Q;aa=u}Q=aa+1|0;c[p>>2]=Q;Y=d[aa>>0]|0;Z=Q;_=$}}else{Q=U+1|0;c[p>>2]=Q;Y=d[U>>0]|0;Z=Q;_=V}Q=Y<<8;if(!(Z>>>0<_>>>0)){if((c[r>>2]|0)==0){ba=0;ca=Z;ea=_}else{L=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((L|0)==0){c[r>>2]=0;fa=(c[q>>2]|0)+ -1|0;c[p>>2]=fa;a[fa>>0]=0;ga=c[q>>2]|0;ha=c[p>>2]|0}else{c[p>>2]=u;fa=l+L+40|0;c[q>>2]=fa;ga=fa;ha=u}fa=ha+1|0;c[p>>2]=fa;ba=d[ha>>0]|0;ca=fa;ea=ga}}else{fa=Z+1|0;c[p>>2]=fa;ba=d[Z>>0]|0;ca=fa;ea=_}fa=Q|P|ba;if(!(ca>>>0<ea>>>0)){if((c[r>>2]|0)==0){ia=0;ja=ca;ka=ea}else{P=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((P|0)==0){c[r>>2]=0;Q=(c[q>>2]|0)+ -1|0;c[p>>2]=Q;a[Q>>0]=0;la=c[q>>2]|0;ma=c[p>>2]|0}else{c[p>>2]=u;Q=l+P+40|0;c[q>>2]=Q;la=Q;ma=u}Q=ma+1|0;c[p>>2]=Q;ia=d[ma>>0]|0;ja=Q;ka=la}}else{Q=ca+1|0;c[p>>2]=Q;ia=d[ca>>0]|0;ja=Q;ka=ea}Q=ia<<8;if(!(ja>>>0<ka>>>0)){if((c[r>>2]|0)==0){na=0;oa=ja;pa=ka}else{P=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((P|0)==0){c[r>>2]=0;L=(c[q>>2]|0)+ -1|0;c[p>>2]=L;a[L>>0]=0;qa=c[q>>2]|0;ra=c[p>>2]|0}else{c[p>>2]=u;L=l+P+40|0;c[q>>2]=L;qa=L;ra=u}L=ra+1|0;c[p>>2]=L;na=d[ra>>0]|0;oa=L;pa=qa}}else{L=ja+1|0;c[p>>2]=L;na=d[ja>>0]|0;oa=L;pa=ka}L=(na|Q)<<16;if(!(oa>>>0<pa>>>0)){if((c[r>>2]|0)==0){sa=0;ta=oa;ua=pa}else{Q=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Q|0)==0){c[r>>2]=0;P=(c[q>>2]|0)+ -1|0;c[p>>2]=P;a[P>>0]=0;va=c[q>>2]|0;wa=c[p>>2]|0}else{c[p>>2]=u;P=l+Q+40|0;c[q>>2]=P;va=P;wa=u}P=wa+1|0;c[p>>2]=P;sa=d[wa>>0]|0;ta=P;ua=va}}else{P=oa+1|0;c[p>>2]=P;sa=d[oa>>0]|0;ta=P;ua=pa}P=sa<<8;if(!(ta>>>0<ua>>>0)){if((c[r>>2]|0)==0){xa=0;ya=ta}else{Q=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Q|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;Aa=c[p>>2]|0}else{c[p>>2]=u;c[q>>2]=l+Q+40;Aa=u}Q=Aa+1|0;c[p>>2]=Q;xa=d[Aa>>0]|0;ya=Q}}else{Q=ta+1|0;c[p>>2]=Q;xa=d[ta>>0]|0;ya=Q}Q=P|L|xa;b:do{if((Q|0)==1130840649){P=c[6526]|0;if((c[s>>2]|0)!=0?(za=c[q>>2]|0,Ba=za-ya|0,(Ba|0)<(fa|0)):0){c[p>>2]=za;Md[c[w>>2]&63](c[t>>2]|0,fa-Ba|0);Ca=z;Da=B;Ea=F;Fa=G;Ha=H;Ia=P;Ja=J;Ka=K;break}c[p>>2]=ya+fa;Ca=z;Da=B;Ea=F;Fa=G;Ha=H;Ia=P;Ja=J;Ka=K}else if((Q|0)==1229472850){if((z|0)==0){D=76;break a}if((fa|0)!=13){D=78;break a}P=c[q>>2]|0;if(!(ya>>>0<P>>>0)){if((c[r>>2]|0)==0){La=0;Ma=ya;Na=P}else{Ba=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Ba|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;Oa=c[q>>2]|0;Pa=c[p>>2]|0}else{c[p>>2]=u;za=l+Ba+40|0;c[q>>2]=za;Oa=za;Pa=u}za=Pa+1|0;c[p>>2]=za;La=d[Pa>>0]|0;Ma=za;Na=Oa}}else{za=ya+1|0;c[p>>2]=za;La=d[ya>>0]|0;Ma=za;Na=P}P=La<<8;if(!(Ma>>>0<Na>>>0)){if((c[r>>2]|0)==0){Qa=0;Ra=Ma;Sa=Na}else{za=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((za|0)==0){c[r>>2]=0;Ba=(c[q>>2]|0)+ -1|0;c[p>>2]=Ba;a[Ba>>0]=0;Ta=c[q>>2]|0;Ua=c[p>>2]|0}else{c[p>>2]=u;Ba=l+za+40|0;c[q>>2]=Ba;Ta=Ba;Ua=u}Ba=Ua+1|0;c[p>>2]=Ba;Qa=d[Ua>>0]|0;Ra=Ba;Sa=Ta}}else{Ba=Ma+1|0;c[p>>2]=Ba;Qa=d[Ma>>0]|0;Ra=Ba;Sa=Na}Ba=(Qa|P)<<16;if(!(Ra>>>0<Sa>>>0)){if((c[r>>2]|0)==0){Va=0;Wa=Ra;Xa=Sa}else{P=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((P|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;Ya=c[q>>2]|0;Za=c[p>>2]|0}else{c[p>>2]=u;za=l+P+40|0;c[q>>2]=za;Ya=za;Za=u}za=Za+1|0;c[p>>2]=za;Va=d[Za>>0]|0;Wa=za;Xa=Ya}}else{za=Ra+1|0;c[p>>2]=za;Va=d[Ra>>0]|0;Wa=za;Xa=Sa}za=Va<<8;if(!(Wa>>>0<Xa>>>0)){if((c[r>>2]|0)==0){_a=0;$a=Wa}else{P=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((P|0)==0){c[r>>2]=0;ab=(c[q>>2]|0)+ -1|0;c[p>>2]=ab;a[ab>>0]=0;bb=c[p>>2]|0}else{c[p>>2]=u;c[q>>2]=l+P+40;bb=u}P=bb+1|0;c[p>>2]=P;_a=d[bb>>0]|0;$a=P}}else{P=Wa+1|0;c[p>>2]=P;_a=d[Wa>>0]|0;$a=P}P=za|Ba|_a;c[l>>2]=P;if(P>>>0>16777216){D=108;break a}P=c[q>>2]|0;do{if($a>>>0<P>>>0){Ba=$a+1|0;c[p>>2]=Ba;cb=d[$a>>0]|0;db=Ba;eb=P}else{if((c[r>>2]|0)==0){cb=0;db=$a;eb=P;break}Ba=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Ba|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;fb=c[q>>2]|0;gb=c[p>>2]|0}else{c[p>>2]=u;za=l+Ba+40|0;c[q>>2]=za;fb=za;gb=u}za=gb+1|0;c[p>>2]=za;cb=d[gb>>0]|0;db=za;eb=fb}}while(0);P=cb<<8;do{if(db>>>0<eb>>>0){za=db+1|0;c[p>>2]=za;hb=d[db>>0]|0;ib=za;jb=eb}else{if((c[r>>2]|0)==0){hb=0;ib=db;jb=eb;break}za=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((za|0)==0){c[r>>2]=0;Ba=(c[q>>2]|0)+ -1|0;c[p>>2]=Ba;a[Ba>>0]=0;kb=c[q>>2]|0;lb=c[p>>2]|0}else{c[p>>2]=u;Ba=l+za+40|0;c[q>>2]=Ba;kb=Ba;lb=u}Ba=lb+1|0;c[p>>2]=Ba;hb=d[lb>>0]|0;ib=Ba;jb=kb}}while(0);Ba=(hb|P)<<16;do{if(ib>>>0<jb>>>0){za=ib+1|0;c[p>>2]=za;mb=d[ib>>0]|0;nb=za;ob=jb}else{if((c[r>>2]|0)==0){mb=0;nb=ib;ob=jb;break}za=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((za|0)==0){c[r>>2]=0;ab=(c[q>>2]|0)+ -1|0;c[p>>2]=ab;a[ab>>0]=0;pb=c[q>>2]|0;qb=c[p>>2]|0}else{c[p>>2]=u;ab=l+za+40|0;c[q>>2]=ab;pb=ab;qb=u}ab=qb+1|0;c[p>>2]=ab;mb=d[qb>>0]|0;nb=ab;ob=pb}}while(0);P=mb<<8;do{if(nb>>>0<ob>>>0){ab=nb+1|0;c[p>>2]=ab;rb=d[nb>>0]|0;sb=ab}else{if((c[r>>2]|0)==0){rb=0;sb=nb;break}ab=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((ab|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;tb=c[p>>2]|0}else{c[p>>2]=u;c[q>>2]=l+ab+40;tb=u}ab=tb+1|0;c[p>>2]=ab;rb=d[tb>>0]|0;sb=ab}}while(0);ab=P|Ba|rb;c[x>>2]=ab;if(ab>>>0>16777216){D=138;break a}do{if(!(sb>>>0<(c[q>>2]|0)>>>0)){if((c[r>>2]|0)==0){D=145;break a}ab=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((ab|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;ub=c[p>>2]|0;break}else{c[p>>2]=u;c[q>>2]=l+ab+40;ub=u;break}}else{ub=sb}}while(0);Ba=ub+1|0;c[p>>2]=Ba;if((a[ub>>0]|0)!=8){D=145;break a}do{if(!(Ba>>>0<(c[q>>2]|0)>>>0)){if((c[r>>2]|0)==0){vb=0;wb=Ba;xb=J;break}P=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((P|0)==0){c[r>>2]=0;ab=(c[q>>2]|0)+ -1|0;c[p>>2]=ab;a[ab>>0]=0;yb=c[p>>2]|0;D=151;break}else{c[p>>2]=u;c[q>>2]=l+P+40;yb=u;D=151;break}}else{yb=Ba;D=151}}while(0);do{if((D|0)==151){D=0;Ba=yb+1|0;c[p>>2]=Ba;P=a[yb>>0]|0;ab=P&255;if((P&255)>6){D=152;break a}if(P<<24>>24==3){vb=3;wb=Ba;xb=3;break}if((ab&1|0)==0){vb=ab;wb=Ba;xb=J}else{D=155;break a}}}while(0);Ba=c[q>>2]|0;do{if(!(wb>>>0<Ba>>>0)){if((c[r>>2]|0)==0){zb=wb;Ab=Ba;break}ab=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((ab|0)==0){c[r>>2]=0;P=(c[q>>2]|0)+ -1|0;c[p>>2]=P;a[P>>0]=0;Bb=c[p>>2]|0;D=161;break}else{c[p>>2]=u;c[q>>2]=l+ab+40;Bb=u;D=161;break}}else{Bb=wb;D=161}}while(0);if((D|0)==161){D=0;Ba=Bb+1|0;c[p>>2]=Ba;if((a[Bb>>0]|0)!=0){D=163;break a}zb=Ba;Ab=c[q>>2]|0}do{if(!(zb>>>0<Ab>>>0)){if((c[r>>2]|0)==0){Cb=zb;Db=Ab;break}Ba=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Ba|0)==0){c[r>>2]=0;ab=(c[q>>2]|0)+ -1|0;c[p>>2]=ab;a[ab>>0]=0;Eb=c[p>>2]|0;D=169;break}else{c[p>>2]=u;c[q>>2]=l+Ba+40;Eb=u;D=169;break}}else{Eb=zb;D=169}}while(0);if((D|0)==169){D=0;Ba=Eb+1|0;c[p>>2]=Ba;if((a[Eb>>0]|0)!=0){D=171;break a}Cb=Ba;Db=c[q>>2]|0}do{if(!(Cb>>>0<Db>>>0)){if((c[r>>2]|0)==0){Fb=0;break}Ba=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Ba|0)==0){c[r>>2]=0;ab=(c[q>>2]|0)+ -1|0;c[p>>2]=ab;a[ab>>0]=0;Gb=c[p>>2]|0;D=177;break}else{c[p>>2]=u;c[q>>2]=l+Ba+40;Gb=u;D=177;break}}else{Gb=Cb;D=177}}while(0);if((D|0)==177){D=0;c[p>>2]=Gb+1;Ba=a[Gb>>0]|0;if((Ba&255)>1){D=179;break a}Fb=Ba&255}Ba=c[l>>2]|0;if((Ba|0)==0){D=182;break a}ab=c[x>>2]|0;if((ab|0)==0){D=182;break a}if(!(xb<<24>>24==0)){c[y>>2]=1;if((1073741824/(Ba>>>0)|0)>>>2>>>0<ab>>>0){D=188;break a}else{Ca=0;Da=B;Ea=F;Fa=Fb;Ha=H;Ia=I;Ja=xb;Ka=K;break}}P=(vb&2|1)+(vb>>>2&1)|0;c[y>>2]=P;if((((1073741824/(Ba>>>0)|0)>>>0)/(P>>>0)|0)>>>0<ab>>>0){D=185;break a}if(C){E=1;D=379;break a}else{Ca=0;Da=B;Ea=F;Fa=Fb;Ha=H;Ia=I;Ja=0;Ka=K}}else if((Q|0)==1347179589){if((z|0)!=0){D=190;break a}if(fa>>>0>768){D=192;break a}ab=(fa>>>0)/3|0;if((ab*3|0)!=(fa|0)){D=195;break a}if(fa>>>0>2){P=ya;Ba=0;while(1){za=c[q>>2]|0;if(!(P>>>0<za>>>0)){if((c[r>>2]|0)==0){Hb=0;Ib=P;Jb=za}else{Kb=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Kb|0)==0){c[r>>2]=0;Lb=(c[q>>2]|0)+ -1|0;c[p>>2]=Lb;a[Lb>>0]=0;Mb=c[q>>2]|0;Nb=c[p>>2]|0}else{c[p>>2]=u;Lb=l+Kb+40|0;c[q>>2]=Lb;Mb=Lb;Nb=u}Lb=Nb+1|0;c[p>>2]=Lb;Hb=d[Nb>>0]|0;Ib=Lb;Jb=Mb}}else{Lb=P+1|0;c[p>>2]=Lb;Hb=d[P>>0]|0;Ib=Lb;Jb=za}za=Ba<<2;a[j+za>>0]=Hb;if(!(Ib>>>0<Jb>>>0)){if((c[r>>2]|0)==0){Ob=0;Pb=Ib;Qb=Jb}else{Lb=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Lb|0)==0){c[r>>2]=0;Kb=(c[q>>2]|0)+ -1|0;c[p>>2]=Kb;a[Kb>>0]=0;Rb=c[q>>2]|0;Sb=c[p>>2]|0}else{c[p>>2]=u;Kb=l+Lb+40|0;c[q>>2]=Kb;Rb=Kb;Sb=u}Kb=Sb+1|0;c[p>>2]=Kb;Ob=d[Sb>>0]|0;Pb=Kb;Qb=Rb}}else{Kb=Ib+1|0;c[p>>2]=Kb;Ob=d[Ib>>0]|0;Pb=Kb;Qb=Jb}a[j+(za|1)>>0]=Ob;do{if(Pb>>>0<Qb>>>0){Kb=Pb+1|0;c[p>>2]=Kb;Tb=d[Pb>>0]|0;Ub=Kb}else{if((c[r>>2]|0)==0){Tb=0;Ub=Pb;break}Kb=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Kb|0)==0){c[r>>2]=0;Lb=(c[q>>2]|0)+ -1|0;c[p>>2]=Lb;a[Lb>>0]=0;Vb=c[p>>2]|0}else{c[p>>2]=u;c[q>>2]=l+Kb+40;Vb=u}Kb=Vb+1|0;c[p>>2]=Kb;Tb=d[Vb>>0]|0;Ub=Kb}}while(0);a[j+(za|2)>>0]=Tb;a[j+(za|3)>>0]=-1;Ba=Ba+1|0;if(!(Ba>>>0<ab>>>0)){Ca=0;Da=B;Ea=F;Fa=G;Ha=H;Ia=I;Ja=J;Ka=ab;break}else{P=Ub}}}else{Ca=0;Da=B;Ea=F;Fa=G;Ha=H;Ia=I;Ja=J;Ka=ab}}else if((Q|0)==1229209940){if((z|0)!=0){D=259;break a}if(J<<24>>24!=0&(K|0)==0){D=261;break a}if(C){D=263;break a}P=fa+H|0;if(P>>>0>F>>>0){if((F|0)==0){Wb=fa>>>0>4096?fa:4096}else{Wb=F}while(1){if(P>>>0>Wb>>>0){Wb=Wb<<1}else{break}}ab=Ol(c[n>>2]|0,Wb)|0;if((ab|0)==0){D=270;break a}c[n>>2]=ab;Xb=ab;Yb=Wb}else{Xb=c[n>>2]|0;Yb=F}ab=Xb+H|0;if((c[s>>2]|0)!=0){Ba=c[q>>2]|0;Kb=c[p>>2]|0;Lb=Ba-Kb|0;if((Lb|0)<(fa|0)){Mm(ab|0,Kb|0,Lb|0)|0;Zb=fa-Lb|0;_b=(Fd[c[s>>2]&15](c[t>>2]|0,Xb+(Lb+H)|0,Zb)|0)==(Zb|0);c[p>>2]=c[q>>2];if(_b){Ca=0;Da=B;Ea=Yb;Fa=G;Ha=P;Ia=I;Ja=J;Ka=K;break}else{D=278;break a}}else{$b=Kb;ac=Ba}}else{$b=c[p>>2]|0;ac=c[q>>2]|0}if(($b+fa|0)>>>0>ac>>>0){D=278;break a}Mm(ab|0,$b|0,fa|0)|0;c[p>>2]=(c[p>>2]|0)+fa;Ca=0;Da=B;Ea=Yb;Fa=G;Ha=P;Ia=I;Ja=J;Ka=K}else if((Q|0)==1951551059){if((z|0)!=0){D=219;break a}if((c[n>>2]|0)!=0){D=221;break a}if(!(J<<24>>24==0)){if(C){D=224;break a}if((K|0)==0){D=226;break a}if(fa>>>0>K>>>0){D=229;break a}if((fa|0)==0){Ca=0;Da=B;Ea=F;Fa=G;Ha=H;Ia=I;Ja=4;Ka=K;break}else{bc=ya;cc=0}while(1){do{if(bc>>>0<(c[q>>2]|0)>>>0){ab=bc+1|0;c[p>>2]=ab;dc=d[bc>>0]|0;ec=ab}else{if((c[r>>2]|0)==0){dc=0;ec=bc;break}ab=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((ab|0)==0){c[r>>2]=0;Ba=(c[q>>2]|0)+ -1|0;c[p>>2]=Ba;a[Ba>>0]=0;fc=c[p>>2]|0}else{c[p>>2]=u;c[q>>2]=l+ab+40;fc=u}ab=fc+1|0;c[p>>2]=ab;dc=d[fc>>0]|0;ec=ab}}while(0);a[j+(cc<<2|3)>>0]=dc;cc=cc+1|0;if((cc|0)==(fa|0)){Ca=0;Da=B;Ea=F;Fa=G;Ha=H;Ia=I;Ja=4;Ka=K;break b}else{bc=ec}}}P=c[y>>2]|0;if((P&1|0)==0){D=239;break a}if((fa|0)!=(P<<1|0)){D=242;break a}if((P|0)>0){P=ya;za=0;while(1){ab=c[q>>2]|0;do{if(P>>>0<ab>>>0){Ba=P+1|0;c[p>>2]=Ba;gc=Ba;hc=ab}else{if((c[r>>2]|0)==0){gc=P;hc=ab;break}Ba=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Ba|0)==0){c[r>>2]=0;Kb=(c[q>>2]|0)+ -1|0;c[p>>2]=Kb;a[Kb>>0]=0;ic=c[q>>2]|0;jc=c[p>>2]|0}else{c[p>>2]=u;Kb=l+Ba+40|0;c[q>>2]=Kb;ic=Kb;jc=u}Kb=jc+1|0;c[p>>2]=Kb;gc=Kb;hc=ic}}while(0);do{if(gc>>>0<hc>>>0){ab=gc+1|0;c[p>>2]=ab;kc=d[gc>>0]|0;lc=ab}else{if((c[r>>2]|0)==0){kc=0;lc=gc;break}ab=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((ab|0)==0){c[r>>2]=0;Kb=(c[q>>2]|0)+ -1|0;c[p>>2]=Kb;a[Kb>>0]=0;mc=c[p>>2]|0}else{c[p>>2]=u;c[q>>2]=l+ab+40;mc=u}ab=mc+1|0;c[p>>2]=ab;kc=d[mc>>0]|0;lc=ab}}while(0);a[k+za>>0]=kc;za=za+1|0;if((za|0)>=(c[y>>2]|0)){Ca=0;Da=1;Ea=F;Fa=G;Ha=H;Ia=I;Ja=0;Ka=K;break}else{P=lc}}}else{Ca=0;Da=1;Ea=F;Fa=G;Ha=H;Ia=I;Ja=0;Ka=K}}else if((Q|0)==1229278788){D=279;break a}else{if((z|0)!=0){D=344;break a}if((L&536870912|0)==0){D=346;break a}if((c[s>>2]|0)!=0?(P=c[q>>2]|0,za=P-ya|0,(za|0)<(fa|0)):0){c[p>>2]=P;Md[c[w>>2]&63](c[t>>2]|0,fa-za|0);Ca=0;Da=B;Ea=F;Fa=G;Ha=H;Ia=I;Ja=J;Ka=K;break}c[p>>2]=ya+fa;Ca=0;Da=B;Ea=F;Fa=G;Ha=H;Ia=I;Ja=J;Ka=K}}while(0);fa=c[p>>2]|0;L=c[q>>2]|0;if(!(fa>>>0<L>>>0)){if((c[r>>2]|0)==0){nc=fa;oc=L}else{Q=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((Q|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;pc=c[q>>2]|0;qc=c[p>>2]|0}else{c[p>>2]=u;za=l+Q+40|0;c[q>>2]=za;pc=za;qc=u}za=qc+1|0;c[p>>2]=za;nc=za;oc=pc}}else{za=fa+1|0;c[p>>2]=za;nc=za;oc=L}if(!(nc>>>0<oc>>>0)){if((c[r>>2]|0)==0){rc=nc;sc=oc}else{L=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((L|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;tc=c[q>>2]|0;uc=c[p>>2]|0}else{c[p>>2]=u;za=l+L+40|0;c[q>>2]=za;tc=za;uc=u}za=uc+1|0;c[p>>2]=za;rc=za;sc=tc}}else{za=nc+1|0;c[p>>2]=za;rc=za;sc=oc}if(!(rc>>>0<sc>>>0)){if((c[r>>2]|0)==0){vc=rc;wc=sc}else{za=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((za|0)==0){c[r>>2]=0;L=(c[q>>2]|0)+ -1|0;c[p>>2]=L;a[L>>0]=0;xc=c[q>>2]|0;yc=c[p>>2]|0}else{c[p>>2]=u;L=l+za+40|0;c[q>>2]=L;xc=L;yc=u}L=yc+1|0;c[p>>2]=L;vc=L;wc=xc}}else{L=rc+1|0;c[p>>2]=L;vc=L;wc=sc}if(vc>>>0<wc>>>0){L=vc+1|0;c[p>>2]=L;A=L;z=Ca;B=Da;F=Ea;G=Fa;H=Ha;I=Ia;J=Ja;K=Ka;continue}if((c[r>>2]|0)==0){A=vc;z=Ca;B=Da;F=Ea;G=Fa;H=Ha;I=Ia;J=Ja;K=Ka;continue}L=Fd[c[s>>2]&15](c[t>>2]|0,u,c[v>>2]|0)|0;if((L|0)==0){c[r>>2]=0;za=(c[q>>2]|0)+ -1|0;c[p>>2]=za;a[za>>0]=0;zc=c[p>>2]|0}else{c[p>>2]=u;c[q>>2]=l+L+40;zc=u}L=zc+1|0;c[p>>2]=L;A=L;z=Ca;B=Da;F=Ea;G=Fa;H=Ha;I=Ia;J=Ja;K=Ka}switch(D|0){case 76:{c[6510]=26184;E=0;i=g;return E|0};case 78:{c[6510]=26200;E=0;i=g;return E|0};case 108:{c[6510]=26216;E=0;i=g;return E|0};case 138:{c[6510]=26216;E=0;i=g;return E|0};case 145:{c[6510]=26232;E=0;i=g;return E|0};case 152:{c[6510]=26248;E=0;i=g;return E|0};case 155:{c[6510]=26248;E=0;i=g;return E|0};case 163:{c[6510]=26264;E=0;i=g;return E|0};case 171:{c[6510]=26280;E=0;i=g;return E|0};case 179:{c[6510]=26304;E=0;i=g;return E|0};case 182:{c[6510]=26328;E=0;i=g;return E|0};case 185:{c[6510]=26216;E=0;i=g;return E|0};case 188:{c[6510]=26216;E=0;i=g;return E|0};case 190:{c[6510]=26344;E=0;i=g;return E|0};case 192:{c[6510]=26360;E=0;i=g;return E|0};case 195:{c[6510]=26360;E=0;i=g;return E|0};case 219:{c[6510]=26344;E=0;i=g;return E|0};case 221:{c[6510]=26376;E=0;i=g;return E|0};case 224:{c[y>>2]=4;E=1;i=g;return E|0};case 226:{c[6510]=26392;E=0;i=g;return E|0};case 229:{c[6510]=26416;E=0;i=g;return E|0};case 239:{c[6510]=26432;E=0;i=g;return E|0};case 242:{c[6510]=26416;E=0;i=g;return E|0};case 259:{c[6510]=26344;E=0;i=g;return E|0};case 261:{c[6510]=26448;E=0;i=g;return E|0};case 263:{c[y>>2]=J&255;E=1;i=g;return E|0};case 270:{c[6510]=26456;E=0;i=g;return E|0};case 278:{c[6510]=26472;E=0;i=g;return E|0};case 279:{if((z|0)!=0){c[6510]=26344;E=0;i=g;return E|0}if((e|0)!=0){E=1;i=g;return E|0}e=c[n>>2]|0;if((e|0)==0){c[6510]=26488;E=0;i=g;return E|0}z=(I|0)!=0;I=Ll(16384)|0;do{if((I|0)!=0){c[h>>2]=e;c[h+4>>2]=e+H;if((zk(h,I,16384,1,z&1^1)|0)==0){Ml(c[h+20>>2]|0);break}Ka=c[h+20>>2]|0;K=(c[h+16>>2]|0)-Ka|0;c[m>>2]=Ka;if((Ka|0)==0){E=0;i=g;return E|0}Ml(c[n>>2]|0);c[n>>2]=0;Ka=c[y>>2]|0;Ja=Ka+1|0;Ia=J<<24>>24==0;Ha=B<<24>>24==0;Fa=l+12|0;Ea=Ha&((Ja|0)==(f|0)&(f|0)!=3&Ia^1)?Ka:Ja;c[Fa>>2]=Ea;Ja=c[m>>2]|0;do{if((G|0)==0){Ka=c[b>>2]|0;if((Fk(b,Ja,K,Ea,c[Ka>>2]|0,c[Ka+4>>2]|0)|0)==0){E=0;i=g;return E|0}}else{Ka=c[6522]|0;c[6522]=0;F=c[b>>2]|0;Da=Ll(da(da(c[F>>2]|0,Ea)|0,c[F+4>>2]|0)|0)|0;Ca=Ja;A=K;p=F;F=0;while(1){zc=c[26640+(F<<2)>>2]|0;u=c[26704+(F<<2)>>2]|0;q=(((c[p>>2]|0)+ -1-zc+u|0)>>>0)/(u>>>0)|0;r=c[26672+(F<<2)>>2]|0;v=c[26736+(F<<2)>>2]|0;t=(((c[p+4>>2]|0)+ -1-r+v|0)>>>0)/(v>>>0)|0;if((q|0)==0|(t|0)==0){Ac=Ca;Bc=A}else{if((Fk(b,Ca,A,Ea,q,t)|0)==0){break}if((t|0)>0){s=(q|0)>0;vc=0;do{if(s){wc=(da(vc,v)|0)+r|0;sc=da(vc,q)|0;rc=c[b>>2]|0;xc=c[o>>2]|0;yc=0;do{Mm(Da+(da((da(yc,u)|0)+zc+(da(c[rc>>2]|0,wc)|0)|0,Ea)|0)|0,xc+(da(yc+sc|0,Ea)|0)|0,Ea|0)|0;yc=yc+1|0}while((yc|0)<(q|0))}vc=vc+1|0}while((vc|0)<(t|0))}Ml(c[o>>2]|0);vc=da(t,(da(q,Ea)|0)+1|0)|0;Ac=Ca+vc|0;Bc=A-vc|0}vc=F+1|0;if((vc|0)>=7){D=303;break}Ca=Ac;A=Bc;p=c[b>>2]|0;F=vc}if((D|0)==303){c[o>>2]=Da;c[6522]=Ka;break}Ml(Da);E=0;i=g;return E|0}}while(0);c:do{if(!Ha){Ea=c[Fa>>2]|0;K=c[b>>2]|0;Ja=c[o>>2]|0;F=da(c[K+4>>2]|0,c[K>>2]|0)|0;if((Ea|0)==4){if((F|0)==0){break}K=k+1|0;p=k+2|0;A=1;Ca=Ja;while(1){if(((a[Ca>>0]|0)==(a[k>>0]|0)?(a[Ca+1>>0]|0)==(a[K>>0]|0):0)?(a[Ca+2>>0]|0)==(a[p>>0]|0):0){a[Ca+3>>0]=0}if((A|0)==(F|0)){break c}A=A+1|0;Ca=Ca+4|0}}else if((Ea|0)==2){if((F|0)==0){break}else{Cc=1;Dc=Ja}while(1){a[Dc+1>>0]=((a[Dc>>0]|0)!=(a[k>>0]|0))<<31>>31;if((Cc|0)==(F|0)){break c}Cc=Cc+1|0;Dc=Dc+2|0}}else{Ga(26584,26544,2238,26616)}}}while(0);d:do{if(z?(c[Fa>>2]|0)>2:0){Ha=c[b>>2]|0;F=c[o>>2]|0;Ja=c[Ha+12>>2]|0;Ea=da(c[Ha+4>>2]|0,c[Ha>>2]|0)|0;if((Ja|0)==4){Ha=(Ea|0)==0;if((c[6524]|0)==0){if(Ha){break}else{Ec=0;Fc=F}while(1){Ca=a[Fc>>0]|0;A=Fc+2|0;a[Fc>>0]=a[A>>0]|0;a[A>>0]=Ca;Ec=Ec+1|0;if((Ec|0)==(Ea|0)){break d}else{Fc=Fc+4|0}}}if(Ha){break}else{Gc=0;Hc=F}while(1){Ca=a[Hc+3>>0]|0;A=a[Hc>>0]|0;p=Hc+2|0;K=a[p>>0]|0;if(Ca<<24>>24==0){a[Hc>>0]=K;Ic=A}else{Da=Ca&255;a[Hc>>0]=(((K&255)*255|0)>>>0)/(Da>>>0)|0;K=Hc+1|0;a[K>>0]=(((d[K>>0]|0)*255|0)>>>0)/(Da>>>0)|0;Ic=((((A&255)*255|0)>>>0)/(Da>>>0)|0)&255}a[p>>0]=Ic;Gc=Gc+1|0;if((Gc|0)==(Ea|0)){break}else{Hc=Hc+4|0}}}else if((Ja|0)==3){if((Ea|0)==0){break}else{Jc=0;Kc=F}while(1){Ha=a[Kc>>0]|0;p=Kc+2|0;a[Kc>>0]=a[p>>0]|0;a[p>>0]=Ha;Jc=Jc+1|0;if((Jc|0)==(Ea|0)){break}else{Kc=Kc+3|0}}}else{Ga(26520,26544,2318,26568)}}}while(0);if(!Ia){Ea=J&255;c[y>>2]=Ea;F=(f|0)>2?f:Ea;c[Fa>>2]=F;Ea=c[b>>2]|0;Ja=da(c[Ea+4>>2]|0,c[Ea>>2]|0)|0;Ea=c[o>>2]|0;Ha=Ll(da(Ja,F)|0)|0;if((Ha|0)==0){c[6510]=26456;E=0;i=g;return E|0}p=(Ja|0)==0;if((F|0)==3){if(!p){F=0;Da=Ha;while(1){A=d[Ea+F>>0]<<2;a[Da>>0]=a[j+A>>0]|0;a[Da+1>>0]=a[j+(A|1)>>0]|0;a[Da+2>>0]=a[j+(A|2)>>0]|0;F=F+1|0;if((F|0)==(Ja|0)){break}else{Da=Da+3|0}}}}else{if(!p){Da=0;F=Ha;while(1){Fa=d[Ea+Da>>0]<<2;a[F>>0]=a[j+Fa>>0]|0;a[F+1>>0]=a[j+(Fa|1)>>0]|0;a[F+2>>0]=a[j+(Fa|2)>>0]|0;a[F+3>>0]=a[j+(Fa|3)>>0]|0;Da=Da+1|0;if((Da|0)==(Ja|0)){break}else{F=F+4|0}}}}Ml(c[o>>2]|0);c[o>>2]=Ha}Ml(c[m>>2]|0);c[m>>2]=0;E=1;i=g;return E|0}}while(0);c[m>>2]=0;E=0;i=g;return E|0};case 344:{c[6510]=26344;E=0;i=g;return E|0};case 346:{a[26496]=ia;a[26497>>0]=na;a[26498>>0]=sa;a[26499>>0]=xa;c[6510]=26496;E=0;i=g;return E|0};case 379:{i=g;return E|0}}return 0}function Fk(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ha=0,Ia=0;k=i;l=c[b>>2]|0;m=da(h,g)|0;n=c[l+8>>2]|0;o=(n|0)==(g|0);p=n+1|0;q=(p|0)==(g|0);if(!(o|q)){Ga(26768,26544,2118,26816)}r=(c[6522]|0)==0;s=r?j:1;j=Ll(da(m,s)|0)|0;t=b+12|0;c[t>>2]=j;if((j|0)==0){c[6510]=26456;u=0;i=k;return u|0}do{if(r){if((c[l>>2]|0)==(h|0)?(c[l+4>>2]|0)==(s|0):0){if((da(s,(da(n,h)|0)+1|0)|0)==(f|0)){break}c[6510]=26840;u=0;i=k;return u|0}if((da(s,(da(n,h)|0)+1|0)|0)>>>0>f>>>0){c[6510]=26840;u=0;i=k;return u|0}}}while(0);if((s|0)==0){u=1;i=k;return u|0}f=(n|0)>0;l=h+ -1|0;r=(l|0)==0;b=(da(n,h)|0)+1|0;h=e;e=j;j=0;a:while(1){v=da(j,m)|0;w=v-m|0;x=a[h>>0]|0;y=x&255;if((x&255)>4){z=15;break}if((j|0)==0){A=d[26880+y>>0]|0}else{A=y}b:do{if(f){if((A|0)==0){y=0;do{a[e+(y+v)>>0]=a[h+(y+1)>>0]|0;y=y+1|0}while((y|0)!=(n|0))}else if((A|0)==1){y=0;do{a[e+(y+v)>>0]=a[h+(y+1)>>0]|0;y=y+1|0}while((y|0)<(n|0))}else{y=0;while(1){switch(A|0){case 3:{a[e+(y+v)>>0]=((d[e+(y+w)>>0]|0)>>>1)+(d[h+(y+1)>>0]|0);break};case 5:{a[e+(y+v)>>0]=a[h+(y+1)>>0]|0;break};case 2:{a[e+(y+v)>>0]=(d[e+(y+w)>>0]|0)+(d[h+(y+1)>>0]|0);break};case 4:{a[e+(y+v)>>0]=(d[e+(y+w)>>0]|0)+(d[h+(y+1)>>0]|0);break};case 6:{a[e+(y+v)>>0]=a[h+(y+1)>>0]|0;break};default:{}}y=y+1|0;if((y|0)>=(n|0)){break b}}}}}while(0);c:do{if(o){y=h+p|0;x=e+(v+g)|0;B=e+(w+g)|0;switch(A|0){case 5:{if(r){C=y;break c}else{D=y;E=x;F=l}while(1){if(f){G=0;do{a[E+G>>0]=((d[E+(G-g)>>0]|0)>>>1)+(d[D+G>>0]|0);G=G+1|0}while((G|0)!=(g|0))}F=F+ -1|0;if((F|0)==0){break}else{D=D+g|0;E=E+g|0}}C=h+b|0;break c;break};case 6:{if(r){C=y;break c}else{H=y;I=x;J=l}while(1){if(f){G=0;do{a[I+G>>0]=(d[I+(G-g)>>0]|0)+(d[H+G>>0]|0);G=G+1|0}while((G|0)!=(g|0))}J=J+ -1|0;if((J|0)==0){break}else{H=H+g|0;I=I+g|0}}C=h+b|0;break c;break};case 3:{if(r){C=y;break c}else{K=y;L=x;M=l;N=B}while(1){if(f){G=0;do{a[L+G>>0]=(((d[L+(G-g)>>0]|0)+(d[N+G>>0]|0)|0)>>>1)+(d[K+G>>0]|0);G=G+1|0}while((G|0)!=(g|0))}M=M+ -1|0;if((M|0)==0){break}else{K=K+g|0;L=L+g|0;N=N+g|0}}C=h+b|0;break c;break};case 4:{if(r){C=y;break c}else{O=y;P=x;Q=l;R=B}while(1){if(f){G=0;do{S=G-g|0;T=d[P+S>>0]|0;U=d[R+G>>0]|0;V=d[R+S>>0]|0;S=U+T-V|0;W=S-T|0;X=(W|0)>-1?W:0-W|0;W=S-U|0;Y=(W|0)>-1?W:0-W|0;W=S-V|0;S=(W|0)>-1?W:0-W|0;if((X|0)>(Y|0)|(X|0)>(S|0)){Z=(Y|0)>(S|0)?V:U}else{Z=T}a[P+G>>0]=Z+(d[O+G>>0]|0);G=G+1|0}while((G|0)!=(g|0))}Q=Q+ -1|0;if((Q|0)==0){break}else{O=O+g|0;P=P+g|0;R=R+g|0}}C=h+b|0;break c;break};case 1:{if(r){C=y;break c}else{_=y;$=x;aa=l}while(1){if(f){G=0;do{a[$+G>>0]=(d[$+(G-g)>>0]|0)+(d[_+G>>0]|0);G=G+1|0}while((G|0)!=(g|0))}aa=aa+ -1|0;if((aa|0)==0){break}else{_=_+g|0;$=$+g|0}}C=h+b|0;break c;break};case 2:{if(r){C=y;break c}else{ba=y;ca=x;ea=l;fa=B}while(1){if(f){G=0;do{a[ca+G>>0]=(d[fa+G>>0]|0)+(d[ba+G>>0]|0);G=G+1|0}while((G|0)!=(g|0))}ea=ea+ -1|0;if((ea|0)==0){break}else{ba=ba+g|0;ca=ca+g|0;fa=fa+g|0}}C=h+b|0;break c;break};case 0:{if(r){C=y;break c}else{ga=y;ha=x;ia=l}while(1){if(f){B=0;do{a[ha+B>>0]=a[ga+B>>0]|0;B=B+1|0}while((B|0)!=(g|0))}ia=ia+ -1|0;if((ia|0)==0){break}else{ga=ga+g|0;ha=ha+g|0}}C=h+b|0;break c;break};default:{C=y;break c}}}else{a[e+(v+n)>>0]=-1;x=h+p|0;B=e+(v+g)|0;G=e+(w+g)|0;if(!q){z=62;break a}switch(A|0){case 1:{if(r){C=x;break c}else{ja=x;ka=B;la=l}while(1){if(f){T=0;do{a[ka+T>>0]=(d[ka+(T-g)>>0]|0)+(d[ja+T>>0]|0);T=T+1|0}while((T|0)!=(n|0))}a[ka+n>>0]=-1;la=la+ -1|0;if((la|0)==0){break}else{ja=ja+n|0;ka=ka+g|0}}C=h+b|0;break c;break};case 5:{if(r){C=x;break c}else{ma=x;na=B;oa=l}while(1){if(f){y=0;do{a[na+y>>0]=((d[na+(y-g)>>0]|0)>>>1)+(d[ma+y>>0]|0);y=y+1|0}while((y|0)!=(n|0))}a[na+n>>0]=-1;oa=oa+ -1|0;if((oa|0)==0){break}else{ma=ma+n|0;na=na+g|0}}C=h+b|0;break c;break};case 0:{if(r){C=x;break c}else{pa=x;qa=B;ra=l}while(1){if(f){y=0;do{a[qa+y>>0]=a[pa+y>>0]|0;y=y+1|0}while((y|0)!=(n|0))}a[qa+n>>0]=-1;ra=ra+ -1|0;if((ra|0)==0){break}else{pa=pa+n|0;qa=qa+g|0}}C=h+b|0;break c;break};case 3:{if(r){C=x;break c}else{sa=x;ta=B;ua=l;va=G}while(1){if(f){y=0;do{a[ta+y>>0]=(((d[ta+(y-g)>>0]|0)+(d[va+y>>0]|0)|0)>>>1)+(d[sa+y>>0]|0);y=y+1|0}while((y|0)!=(n|0))}a[ta+n>>0]=-1;ua=ua+ -1|0;if((ua|0)==0){break}else{sa=sa+n|0;ta=ta+g|0;va=va+g|0}}C=h+b|0;break c;break};case 6:{if(r){C=x;break c}else{wa=x;xa=B;ya=l}while(1){if(f){y=0;do{a[xa+y>>0]=(d[xa+(y-g)>>0]|0)+(d[wa+y>>0]|0);y=y+1|0}while((y|0)!=(n|0))}a[xa+n>>0]=-1;ya=ya+ -1|0;if((ya|0)==0){break}else{wa=wa+n|0;xa=xa+g|0}}C=h+b|0;break c;break};case 4:{if(r){C=x;break c}else{za=x;Aa=B;Ba=l;Ca=G}while(1){if(f){y=0;do{T=y-g|0;U=d[Aa+T>>0]|0;V=d[Ca+y>>0]|0;S=d[Ca+T>>0]|0;T=V+U-S|0;Y=T-U|0;X=(Y|0)>-1?Y:0-Y|0;Y=T-V|0;W=(Y|0)>-1?Y:0-Y|0;Y=T-S|0;T=(Y|0)>-1?Y:0-Y|0;if((X|0)>(W|0)|(X|0)>(T|0)){Da=(W|0)>(T|0)?S:V}else{Da=U}a[Aa+y>>0]=Da+(d[za+y>>0]|0);y=y+1|0}while((y|0)!=(n|0))}a[Aa+n>>0]=-1;Ba=Ba+ -1|0;if((Ba|0)==0){break}else{za=za+n|0;Aa=Aa+g|0;Ca=Ca+g|0}}C=h+b|0;break c;break};case 2:{if(r){C=x;break c}else{Ea=x;Fa=B;Ha=l;Ia=G}while(1){if(f){y=0;do{a[Fa+y>>0]=(d[Ia+y>>0]|0)+(d[Ea+y>>0]|0);y=y+1|0}while((y|0)!=(n|0))}a[Fa+n>>0]=-1;Ha=Ha+ -1|0;if((Ha|0)==0){break}else{Ea=Ea+n|0;Fa=Fa+g|0;Ia=Ia+g|0}}C=h+b|0;break c;break};default:{C=x;break c}}}}while(0);w=j+1|0;if(!(w>>>0<s>>>0)){u=1;z=110;break}h=C;e=c[t>>2]|0;j=w}if((z|0)==15){c[6510]=26864;u=0;i=k;return u|0}else if((z|0)==62){Ga(26888,26544,2169,26816)}else if((z|0)==110){i=k;return u|0}return 0}function Gk(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0;f=i;g=b+13956|0;a[g>>0]=-1;h=c[b>>2]|0;j=h+168|0;k=c[j>>2]|0;l=h+172|0;do{if(!(k>>>0<(c[l>>2]|0)>>>0)){m=h+32|0;if((c[m>>2]|0)!=0){n=h+40|0;o=Fd[c[h+16>>2]&15](c[h+28>>2]|0,n,c[h+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[l>>2]|0)+ -1|0;c[j>>2]=m;a[m>>0]=0;p=c[j>>2]|0;q=6;break}else{c[j>>2]=n;c[l>>2]=h+o+40;p=n;q=6;break}}}else{p=k;q=6}}while(0);a:do{if((q|0)==6?(c[j>>2]=p+1,(a[p>>0]|0)==-1):0){while(1){k=c[b>>2]|0;h=k+168|0;l=c[h>>2]|0;n=k+172|0;if(!(l>>>0<(c[n>>2]|0)>>>0)){o=k+32|0;if((c[o>>2]|0)==0){r=0}else{m=k+40|0;s=Fd[c[k+16>>2]&15](c[k+28>>2]|0,m,c[k+36>>2]|0)|0;if((s|0)==0){c[o>>2]=0;o=(c[n>>2]|0)+ -1|0;c[h>>2]=o;a[o>>0]=0;t=c[h>>2]|0}else{c[h>>2]=m;c[n>>2]=k+s+40;t=m}c[h>>2]=t+1;r=d[t>>0]|0}}else{c[h>>2]=l+1;r=d[l>>0]|0}l=r&255;if(l<<24>>24==-40){break}else if(!(l<<24>>24==-1)){break a}}if((e|0)==1){u=1;i=f;return u|0}l=a[g>>0]|0;b:do{if(l<<24>>24==-1){h=c[b>>2]|0;m=h+168|0;s=c[m>>2]|0;k=h+172|0;do{if(!(s>>>0<(c[k>>2]|0)>>>0)){n=h+32|0;if((c[n>>2]|0)==0){v=-1;break b}o=h+40|0;w=Fd[c[h+16>>2]&15](c[h+28>>2]|0,o,c[h+36>>2]|0)|0;if((w|0)==0){c[n>>2]=0;n=(c[k>>2]|0)+ -1|0;c[m>>2]=n;a[n>>0]=0;x=c[m>>2]|0;break}else{c[m>>2]=o;c[k>>2]=h+w+40;x=o;break}}else{x=s}}while(0);c[m>>2]=x+1;if((a[x>>0]|0)==-1){do{s=c[b>>2]|0;h=s+168|0;k=c[h>>2]|0;o=s+172|0;if(!(k>>>0<(c[o>>2]|0)>>>0)){w=s+32|0;if((c[w>>2]|0)==0){y=0}else{n=s+40|0;z=Fd[c[s+16>>2]&15](c[s+28>>2]|0,n,c[s+36>>2]|0)|0;if((z|0)==0){c[w>>2]=0;w=(c[o>>2]|0)+ -1|0;c[h>>2]=w;a[w>>0]=0;A=c[h>>2]|0}else{c[h>>2]=n;c[o>>2]=s+z+40;A=n}c[h>>2]=A+1;y=d[A>>0]|0}}else{c[h>>2]=k+1;y=d[k>>0]|0}k=y&255}while(k<<24>>24==-1);v=k}else{v=-1}}else{a[g>>0]=-1;v=l}}while(0);l=v&255;c:do{if((l+ -192|0)>>>0>1){m=l;d:while(1){if((Hk(b,m)|0)==0){u=0;q=183;break}k=a[g>>0]|0;do{if(k<<24>>24==-1){h=c[b>>2]|0;n=h+168|0;z=c[n>>2]|0;s=h+172|0;do{if(!(z>>>0<(c[s>>2]|0)>>>0)){o=h+32|0;if((c[o>>2]|0)!=0){w=h+40|0;B=Fd[c[h+16>>2]&15](c[h+28>>2]|0,w,c[h+36>>2]|0)|0;if((B|0)==0){c[o>>2]=0;o=(c[s>>2]|0)+ -1|0;c[n>>2]=o;a[o>>0]=0;C=c[n>>2]|0;q=43;break}else{c[n>>2]=w;c[s>>2]=h+B+40;C=w;q=43;break}}}else{C=z;q=43}}while(0);if((q|0)==43?(q=0,c[n>>2]=C+1,(a[C>>0]|0)==-1):0){do{z=c[b>>2]|0;h=z+168|0;s=c[h>>2]|0;w=z+172|0;if(!(s>>>0<(c[w>>2]|0)>>>0)){B=z+32|0;if((c[B>>2]|0)==0){D=0}else{o=z+40|0;E=Fd[c[z+16>>2]&15](c[z+28>>2]|0,o,c[z+36>>2]|0)|0;if((E|0)==0){c[B>>2]=0;B=(c[w>>2]|0)+ -1|0;c[h>>2]=B;a[B>>0]=0;F=c[h>>2]|0}else{c[h>>2]=o;c[w>>2]=z+E+40;F=o}c[h>>2]=F+1;D=d[F>>0]|0}}else{c[h>>2]=s+1;D=d[s>>0]|0}}while((D|0)==255);G=D;break}e:while(1){n=c[b>>2]|0;if((c[n+16>>2]|0)!=0){if((Nd[c[n+24>>2]&63](c[n+28>>2]|0)|0)!=0){if((c[n+32>>2]|0)==0){break d}else{q=57}}}else{q=57}if((q|0)==57?(q=0,!((c[n+168>>2]|0)>>>0<(c[n+172>>2]|0)>>>0)):0){break d}H=a[g>>0]|0;if(!(H<<24>>24==-1)){q=60;break}n=c[b>>2]|0;s=n+168|0;h=c[s>>2]|0;o=n+172|0;do{if(!(h>>>0<(c[o>>2]|0)>>>0)){E=n+32|0;if((c[E>>2]|0)==0){continue e}z=n+40|0;w=Fd[c[n+16>>2]&15](c[n+28>>2]|0,z,c[n+36>>2]|0)|0;if((w|0)==0){c[E>>2]=0;E=(c[o>>2]|0)+ -1|0;c[s>>2]=E;a[E>>0]=0;I=c[s>>2]|0;break}else{c[s>>2]=z;c[o>>2]=n+w+40;I=z;break}}else{I=h}}while(0);c[s>>2]=I+1;if((a[I>>0]|0)==-1){q=67;break}}if((q|0)==60){q=0;a[g>>0]=-1;J=H}else if((q|0)==67){while(1){q=0;h=c[b>>2]|0;n=h+168|0;o=c[n>>2]|0;z=h+172|0;if(!(o>>>0<(c[z>>2]|0)>>>0)){w=h+32|0;if((c[w>>2]|0)==0){K=0}else{E=h+40|0;B=Fd[c[h+16>>2]&15](c[h+28>>2]|0,E,c[h+36>>2]|0)|0;if((B|0)==0){c[w>>2]=0;w=(c[z>>2]|0)+ -1|0;c[n>>2]=w;a[w>>0]=0;L=c[n>>2]|0}else{c[n>>2]=E;c[z>>2]=h+B+40;L=E}c[n>>2]=L+1;K=d[L>>0]|0}}else{c[n>>2]=o+1;K=d[o>>0]|0}o=K&255;if(o<<24>>24==-1){q=67}else{J=o;break}}}G=J&255}else{a[g>>0]=-1;G=k&255}}while(0);if((G+ -192|0)>>>0>1){m=G}else{break c}}if((q|0)==183){i=f;return u|0}c[6510]=26944;u=0;i=f;return u|0}}while(0);l=c[b>>2]|0;m=l+168|0;k=c[m>>2]|0;o=l+172|0;n=c[o>>2]|0;if(!(k>>>0<n>>>0)){E=l+32|0;if((c[E>>2]|0)==0){M=0;N=k;O=n}else{B=l+40|0;h=Fd[c[l+16>>2]&15](c[l+28>>2]|0,B,c[l+36>>2]|0)|0;if((h|0)==0){c[E>>2]=0;E=(c[o>>2]|0)+ -1|0;c[m>>2]=E;a[E>>0]=0;P=c[o>>2]|0;Q=c[m>>2]|0}else{c[m>>2]=B;E=l+h+40|0;c[o>>2]=E;P=E;Q=B}B=Q+1|0;c[m>>2]=B;M=d[Q>>0]|0;N=B;O=P}}else{B=k+1|0;c[m>>2]=B;M=d[k>>0]|0;N=B;O=n}n=M<<8;if(!(N>>>0<O>>>0)){B=l+32|0;if((c[B>>2]|0)==0){R=0;S=N}else{k=l+40|0;E=Fd[c[l+16>>2]&15](c[l+28>>2]|0,k,c[l+36>>2]|0)|0;if((E|0)==0){c[B>>2]=0;B=(c[o>>2]|0)+ -1|0;c[m>>2]=B;a[B>>0]=0;T=c[m>>2]|0}else{c[m>>2]=k;c[o>>2]=l+E+40;T=k}k=T+1|0;c[m>>2]=k;R=d[T>>0]|0;S=k}}else{k=N+1|0;c[m>>2]=k;R=d[N>>0]|0;S=k}k=R|n;if(k>>>0<11){c[6510]=26952;u=0;i=f;return u|0}do{if(!(S>>>0<(c[o>>2]|0)>>>0)){n=l+32|0;if((c[n>>2]|0)!=0){E=l+40|0;B=Fd[c[l+16>>2]&15](c[l+28>>2]|0,E,c[l+36>>2]|0)|0;if((B|0)==0){c[n>>2]=0;n=(c[o>>2]|0)+ -1|0;c[m>>2]=n;a[n>>0]=0;U=c[m>>2]|0;q=96;break}else{c[m>>2]=E;c[o>>2]=l+B+40;U=E;q=96;break}}}else{U=S;q=96}}while(0);if((q|0)==96?(E=U+1|0,c[m>>2]=E,(a[U>>0]|0)==8):0){B=c[o>>2]|0;if(!(E>>>0<B>>>0)){n=l+32|0;if((c[n>>2]|0)==0){V=0;W=E;X=B}else{h=l+40|0;z=Fd[c[l+16>>2]&15](c[l+28>>2]|0,h,c[l+36>>2]|0)|0;if((z|0)==0){c[n>>2]=0;n=(c[o>>2]|0)+ -1|0;c[m>>2]=n;a[n>>0]=0;Y=c[o>>2]|0;Z=c[m>>2]|0}else{c[m>>2]=h;n=l+z+40|0;c[o>>2]=n;Y=n;Z=h}h=Z+1|0;c[m>>2]=h;V=d[Z>>0]|0;W=h;X=Y}}else{h=U+2|0;c[m>>2]=h;V=d[E>>0]|0;W=h;X=B}B=V<<8;if(!(W>>>0<X>>>0)){h=l+32|0;if((c[h>>2]|0)==0){_=0;$=W}else{E=l+40|0;n=Fd[c[l+16>>2]&15](c[l+28>>2]|0,E,c[l+36>>2]|0)|0;if((n|0)==0){c[h>>2]=0;h=(c[o>>2]|0)+ -1|0;c[m>>2]=h;a[h>>0]=0;aa=c[m>>2]|0}else{c[m>>2]=E;c[o>>2]=l+n+40;aa=E}E=aa+1|0;c[m>>2]=E;_=d[aa>>0]|0;$=E}}else{E=W+1|0;c[m>>2]=E;_=d[W>>0]|0;$=E}E=_|B;B=l+4|0;c[B>>2]=E;if((E|0)==0){c[6510]=26984;u=0;i=f;return u|0}E=c[o>>2]|0;if(!($>>>0<E>>>0)){n=l+32|0;if((c[n>>2]|0)==0){ba=0;ca=$;ea=E}else{h=l+40|0;z=Fd[c[l+16>>2]&15](c[l+28>>2]|0,h,c[l+36>>2]|0)|0;if((z|0)==0){c[n>>2]=0;n=(c[o>>2]|0)+ -1|0;c[m>>2]=n;a[n>>0]=0;fa=c[o>>2]|0;ga=c[m>>2]|0}else{c[m>>2]=h;n=l+z+40|0;c[o>>2]=n;fa=n;ga=h}h=ga+1|0;c[m>>2]=h;ba=d[ga>>0]|0;ca=h;ea=fa}}else{h=$+1|0;c[m>>2]=h;ba=d[$>>0]|0;ca=h;ea=E}E=ba<<8;if(!(ca>>>0<ea>>>0)){h=l+32|0;if((c[h>>2]|0)==0){ha=0;ia=ca}else{n=l+40|0;z=Fd[c[l+16>>2]&15](c[l+28>>2]|0,n,c[l+36>>2]|0)|0;if((z|0)==0){c[h>>2]=0;h=(c[o>>2]|0)+ -1|0;c[m>>2]=h;a[h>>0]=0;ja=c[m>>2]|0}else{c[m>>2]=n;c[o>>2]=l+z+40;ja=n}n=ja+1|0;c[m>>2]=n;ha=d[ja>>0]|0;ia=n}}else{n=ca+1|0;c[m>>2]=n;ha=d[ca>>0]|0;ia=n}n=ha|E;c[l>>2]=n;if((n|0)==0){c[6510]=27008;u=0;i=f;return u|0}do{if(!(ia>>>0<(c[o>>2]|0)>>>0)){n=l+32|0;if((c[n>>2]|0)==0){break}E=l+40|0;z=Fd[c[l+16>>2]&15](c[l+28>>2]|0,E,c[l+36>>2]|0)|0;if((z|0)==0){c[n>>2]=0;n=(c[o>>2]|0)+ -1|0;c[m>>2]=n;a[n>>0]=0;ka=c[m>>2]|0;q=135;break}else{c[m>>2]=E;c[o>>2]=l+z+40;ka=E;q=135;break}}else{ka=ia;q=135}}while(0);do{if((q|0)==135){c[m>>2]=ka+1;E=a[ka>>0]|0;z=E&255;if(!((z|0)==1|(z|0)==3)){break}n=l+8|0;c[n>>2]=z;h=E<<24>>24==0;if(!h){E=0;do{c[b+(E*56|0)+13768>>2]=0;c[b+(E*56|0)+13776>>2]=0;E=E+1|0}while((E|0)<(z|0))}if((k|0)!=((z*3|0)+8|0)){c[6510]=26952;u=0;i=f;return u|0}f:do{if(h){la=z}else{E=l+32|0;w=l+16|0;ma=l+28|0;na=l+40|0;oa=l+36|0;pa=c[m>>2]|0;qa=0;g:while(1){do{if(pa>>>0<(c[o>>2]|0)>>>0){ra=pa+1|0;c[m>>2]=ra;sa=d[pa>>0]|0;ta=ra}else{if((c[E>>2]|0)==0){sa=0;ta=pa;break}ra=Fd[c[w>>2]&15](c[ma>>2]|0,na,c[oa>>2]|0)|0;if((ra|0)==0){c[E>>2]=0;ua=(c[o>>2]|0)+ -1|0;c[m>>2]=ua;a[ua>>0]=0;va=c[m>>2]|0}else{c[m>>2]=na;c[o>>2]=l+ra+40;va=na}ra=va+1|0;c[m>>2]=ra;sa=d[va>>0]|0;ta=ra}}while(0);c[b+(qa*56|0)+13724>>2]=sa;ra=qa+1|0;if(!((sa|0)==(ra|0)|(sa|0)==(qa|0))){q=151;break}do{if(!(ta>>>0<(c[o>>2]|0)>>>0)){if((c[E>>2]|0)==0){q=154;break g}ua=Fd[c[w>>2]&15](c[ma>>2]|0,na,c[oa>>2]|0)|0;if((ua|0)==0){c[E>>2]=0;wa=(c[o>>2]|0)+ -1|0;c[m>>2]=wa;a[wa>>0]=0;xa=c[m>>2]|0;break}else{c[m>>2]=na;c[o>>2]=l+ua+40;xa=na;break}}else{xa=ta}}while(0);ua=xa+1|0;c[m>>2]=ua;wa=a[xa>>0]|0;ya=wa&255;za=ya>>>4;c[b+(qa*56|0)+13728>>2]=za;if((za|0)==0|(wa&255)>79){break}wa=ya&15;c[b+(qa*56|0)+13732>>2]=wa;if((wa|0)==0|wa>>>0>4){q=161;break}do{if(!(ua>>>0<(c[o>>2]|0)>>>0)){if((c[E>>2]|0)==0){c[b+(qa*56|0)+13736>>2]=0;Aa=ua;break}wa=Fd[c[w>>2]&15](c[ma>>2]|0,na,c[oa>>2]|0)|0;if((wa|0)==0){c[E>>2]=0;ya=(c[o>>2]|0)+ -1|0;c[m>>2]=ya;a[ya>>0]=0;Ba=c[m>>2]|0;q=168;break}else{c[m>>2]=na;c[o>>2]=l+wa+40;Ba=na;q=168;break}}else{Ba=ua;q=168}}while(0);if((q|0)==168){q=0;ua=Ba+1|0;c[m>>2]=ua;wa=a[Ba>>0]|0;c[b+(qa*56|0)+13736>>2]=wa&255;if((wa&255)>3){q=170;break}else{Aa=ua}}ua=c[n>>2]|0;if((ra|0)<(ua|0)){pa=Aa;qa=ra}else{la=ua;break f}}if((q|0)==151){c[6510]=27040;u=0;i=f;return u|0}else if((q|0)==154){c[b+(qa*56|0)+13728>>2]=0}else if((q|0)==161){c[6510]=27072;u=0;i=f;return u|0}else if((q|0)==170){c[6510]=27080;u=0;i=f;return u|0}c[6510]=27064;u=0;i=f;return u|0}}while(0);if((e|0)!=0){u=1;i=f;return u|0}if((((1073741824/((c[l>>2]|0)>>>0)|0)>>>0)/(la>>>0)|0)>>>0<(c[B>>2]|0)>>>0){c[6510]=26216;u=0;i=f;return u|0}if((la|0)>0){z=1;h=0;pa=1;while(1){na=c[b+(h*56|0)+13728>>2]|0;E=(na|0)>(z|0)?na:z;na=c[b+(h*56|0)+13732>>2]|0;oa=(na|0)>(pa|0)?na:pa;h=h+1|0;if((h|0)==(la|0)){Ca=E;Da=oa;break}else{z=E;pa=oa}}}else{Ca=1;Da=1}c[b+13700>>2]=Ca;c[b+13704>>2]=Da;pa=Ca<<3;c[b+13716>>2]=pa;z=Da<<3;c[b+13720>>2]=z;h=b+13708|0;c[h>>2]=(((c[l>>2]|0)+ -1+pa|0)>>>0)/(pa>>>0)|0;pa=b+13712|0;c[pa>>2]=((z+ -1+(c[B>>2]|0)|0)>>>0)/(z>>>0)|0;if((c[n>>2]|0)<=0){u=1;i=f;return u|0}z=Ca+ -1|0;oa=Da+ -1|0;E=0;while(1){na=c[b+(E*56|0)+13728>>2]|0;c[b+(E*56|0)+13752>>2]=((z+(da(na,c[l>>2]|0)|0)|0)>>>0)/(Ca>>>0)|0;ma=c[b+(E*56|0)+13732>>2]|0;c[b+(E*56|0)+13756>>2]=((oa+(da(ma,c[B>>2]|0)|0)|0)>>>0)/(Da>>>0)|0;w=da(c[h>>2]<<3,na)|0;c[b+(E*56|0)+13760>>2]=w;na=da(c[pa>>2]<<3,ma)|0;c[b+(E*56|0)+13764>>2]=na;ma=Ll(da(na,w)|0|15)|0;c[b+(E*56|0)+13772>>2]=ma;if((ma|0)==0){break}c[b+(E*56|0)+13768>>2]=ma+15&-16;c[b+(E*56|0)+13776>>2]=0;ma=E+1|0;if((ma|0)<(c[n>>2]|0)){E=ma}else{u=1;q=183;break}}if((q|0)==183){i=f;return u|0}if((E|0)>0){n=E;do{n=n+ -1|0;Ml(c[b+(n*56|0)+13772>>2]|0);c[b+(n*56|0)+13768>>2]=0}while((n|0)>0)}c[6510]=26456;u=0;i=f;return u|0}}while(0);c[6510]=27016;u=0;i=f;return u|0}c[6510]=26968;u=0;i=f;return u|0}}while(0);c[6510]=26936;u=0;i=f;return u|0}function Hk(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0;f=i;i=i+64|0;g=f;switch(e|0){case 255:{c[6510]=27088;h=0;i=f;return h|0};case 194:{c[6510]=27104;h=0;i=f;return h|0};case 221:{j=c[b>>2]|0;k=j+168|0;l=c[k>>2]|0;m=j+172|0;n=c[m>>2]|0;if(!(l>>>0<n>>>0)){o=j+32|0;if((c[o>>2]|0)==0){p=0;q=l;r=n}else{s=j+40|0;t=Fd[c[j+16>>2]&15](c[j+28>>2]|0,s,c[j+36>>2]|0)|0;if((t|0)==0){c[o>>2]=0;o=(c[m>>2]|0)+ -1|0;c[k>>2]=o;a[o>>0]=0;u=c[m>>2]|0;v=c[k>>2]|0}else{c[k>>2]=s;o=j+t+40|0;c[m>>2]=o;u=o;v=s}s=v+1|0;c[k>>2]=s;p=d[v>>0]|0;q=s;r=u}}else{u=l+1|0;c[k>>2]=u;p=d[l>>0]|0;q=u;r=n}n=p<<8;if(!(q>>>0<r>>>0)){r=j+32|0;if((c[r>>2]|0)==0){w=0}else{p=j+40|0;u=Fd[c[j+16>>2]&15](c[j+28>>2]|0,p,c[j+36>>2]|0)|0;if((u|0)==0){c[r>>2]=0;r=(c[m>>2]|0)+ -1|0;c[k>>2]=r;a[r>>0]=0;x=c[k>>2]|0}else{c[k>>2]=p;c[m>>2]=j+u+40;x=p}c[k>>2]=x+1;w=d[x>>0]|0}}else{c[k>>2]=q+1;w=d[q>>0]|0}if((w|n|0)!=4){c[6510]=27128;h=0;i=f;return h|0}n=c[b>>2]|0;w=n+168|0;q=c[w>>2]|0;k=n+172|0;x=c[k>>2]|0;if(!(q>>>0<x>>>0)){p=n+32|0;if((c[p>>2]|0)==0){y=0;z=q;A=x}else{u=n+40|0;j=Fd[c[n+16>>2]&15](c[n+28>>2]|0,u,c[n+36>>2]|0)|0;if((j|0)==0){c[p>>2]=0;p=(c[k>>2]|0)+ -1|0;c[w>>2]=p;a[p>>0]=0;B=c[k>>2]|0;C=c[w>>2]|0}else{c[w>>2]=u;p=n+j+40|0;c[k>>2]=p;B=p;C=u}u=C+1|0;c[w>>2]=u;y=d[C>>0]|0;z=u;A=B}}else{B=q+1|0;c[w>>2]=B;y=d[q>>0]|0;z=B;A=x}x=y<<8;if(!(z>>>0<A>>>0)){A=n+32|0;if((c[A>>2]|0)==0){D=0}else{y=n+40|0;B=Fd[c[n+16>>2]&15](c[n+28>>2]|0,y,c[n+36>>2]|0)|0;if((B|0)==0){c[A>>2]=0;A=(c[k>>2]|0)+ -1|0;c[w>>2]=A;a[A>>0]=0;E=c[w>>2]|0}else{c[w>>2]=y;c[k>>2]=n+B+40;E=y}c[w>>2]=E+1;D=d[E>>0]|0}}else{c[w>>2]=z+1;D=d[z>>0]|0}c[b+13984>>2]=D|x;h=1;i=f;return h|0};case 196:{x=c[b>>2]|0;D=x+168|0;z=c[D>>2]|0;w=x+172|0;E=c[w>>2]|0;if(!(z>>>0<E>>>0)){y=x+32|0;if((c[y>>2]|0)==0){F=0;G=z;H=E}else{B=x+40|0;n=Fd[c[x+16>>2]&15](c[x+28>>2]|0,B,c[x+36>>2]|0)|0;if((n|0)==0){c[y>>2]=0;y=(c[w>>2]|0)+ -1|0;c[D>>2]=y;a[y>>0]=0;I=c[w>>2]|0;J=c[D>>2]|0}else{c[D>>2]=B;y=x+n+40|0;c[w>>2]=y;I=y;J=B}B=J+1|0;c[D>>2]=B;F=d[J>>0]|0;G=B;H=I}}else{I=z+1|0;c[D>>2]=I;F=d[z>>0]|0;G=I;H=E}E=F<<8;if(!(G>>>0<H>>>0)){H=x+32|0;if((c[H>>2]|0)==0){K=0}else{F=x+40|0;I=Fd[c[x+16>>2]&15](c[x+28>>2]|0,F,c[x+36>>2]|0)|0;if((I|0)==0){c[H>>2]=0;H=(c[w>>2]|0)+ -1|0;c[D>>2]=H;a[H>>0]=0;L=c[D>>2]|0}else{c[D>>2]=F;c[w>>2]=x+I+40;L=F}c[D>>2]=L+1;K=d[L>>0]|0}}else{c[D>>2]=G+1;K=d[G>>0]|0}G=(K|E)+ -2|0;a:do{if((G|0)>0){E=G;while(1){K=c[b>>2]|0;D=K+168|0;L=c[D>>2]|0;F=K+172|0;if(!(L>>>0<(c[F>>2]|0)>>>0)){I=K+32|0;if((c[I>>2]|0)==0){M=0}else{x=K+40|0;w=Fd[c[K+16>>2]&15](c[K+28>>2]|0,x,c[K+36>>2]|0)|0;if((w|0)==0){c[I>>2]=0;I=(c[F>>2]|0)+ -1|0;c[D>>2]=I;a[I>>0]=0;N=c[D>>2]|0}else{c[D>>2]=x;c[F>>2]=K+w+40;N=x}c[D>>2]=N+1;M=d[N>>0]|0}}else{c[D>>2]=L+1;M=d[L>>0]|0}L=M&15;if(M>>>0>31|L>>>0>3){O=94;break}else{P=0;Q=0}do{D=c[b>>2]|0;x=D+168|0;w=c[x>>2]|0;K=D+172|0;if(!(w>>>0<(c[K>>2]|0)>>>0)){F=D+32|0;if((c[F>>2]|0)==0){R=0}else{I=D+40|0;H=Fd[c[D+16>>2]&15](c[D+28>>2]|0,I,c[D+36>>2]|0)|0;if((H|0)==0){c[F>>2]=0;F=(c[K>>2]|0)+ -1|0;c[x>>2]=F;a[F>>0]=0;S=c[x>>2]|0}else{c[x>>2]=I;c[K>>2]=D+H+40;S=I}c[x>>2]=S+1;R=d[S>>0]|0}}else{c[x>>2]=w+1;R=d[w>>0]|0}c[g+(P<<2)>>2]=R;Q=R+Q|0;P=P+1|0}while((P|0)!=16);w=E+ -17|0;if((M&240|0)==0){if((Ik(b+(L*1680|0)+4|0,g)|0)==0){h=0;O=138;break}T=b+(L*1680|0)+1028|0}else{if((Ik(b+(L*1680|0)+6724|0,g)|0)==0){h=0;O=138;break}T=b+(L*1680|0)+7748|0}if((Q|0)>0){x=0;do{I=c[b>>2]|0;H=I+168|0;D=c[H>>2]|0;K=I+172|0;if(!(D>>>0<(c[K>>2]|0)>>>0)){F=I+32|0;if((c[F>>2]|0)==0){U=0}else{z=I+40|0;B=Fd[c[I+16>>2]&15](c[I+28>>2]|0,z,c[I+36>>2]|0)|0;if((B|0)==0){c[F>>2]=0;F=(c[K>>2]|0)+ -1|0;c[H>>2]=F;a[F>>0]=0;V=c[H>>2]|0}else{c[H>>2]=z;c[K>>2]=I+B+40;V=z}c[H>>2]=V+1;U=d[V>>0]|0}}else{c[H>>2]=D+1;U=d[D>>0]|0}a[T+x>>0]=U;x=x+1|0}while((x|0)!=(Q|0))}x=w-Q|0;if((x|0)>0){E=x}else{W=x;break a}}if((O|0)==94){c[6510]=27256;h=0;i=f;return h|0}else if((O|0)==138){i=f;return h|0}}else{W=G}}while(0);h=(W|0)==0&1;i=f;return h|0};case 219:{W=c[b>>2]|0;G=W+168|0;Q=c[G>>2]|0;U=W+172|0;T=c[U>>2]|0;if(!(Q>>>0<T>>>0)){V=W+32|0;if((c[V>>2]|0)==0){X=0;Y=Q;Z=T}else{g=W+40|0;M=Fd[c[W+16>>2]&15](c[W+28>>2]|0,g,c[W+36>>2]|0)|0;if((M|0)==0){c[V>>2]=0;V=(c[U>>2]|0)+ -1|0;c[G>>2]=V;a[V>>0]=0;_=c[U>>2]|0;$=c[G>>2]|0}else{c[G>>2]=g;V=W+M+40|0;c[U>>2]=V;_=V;$=g}g=$+1|0;c[G>>2]=g;X=d[$>>0]|0;Y=g;Z=_}}else{_=Q+1|0;c[G>>2]=_;X=d[Q>>0]|0;Y=_;Z=T}T=X<<8;if(!(Y>>>0<Z>>>0)){Z=W+32|0;if((c[Z>>2]|0)==0){aa=0}else{X=W+40|0;_=Fd[c[W+16>>2]&15](c[W+28>>2]|0,X,c[W+36>>2]|0)|0;if((_|0)==0){c[Z>>2]=0;Z=(c[U>>2]|0)+ -1|0;c[G>>2]=Z;a[Z>>0]=0;ba=c[G>>2]|0}else{c[G>>2]=X;c[U>>2]=W+_+40;ba=X}c[G>>2]=ba+1;aa=d[ba>>0]|0}}else{c[G>>2]=Y+1;aa=d[Y>>0]|0}Y=(aa|T)+ -2|0;b:do{if((Y|0)>0){T=Y;while(1){aa=c[b>>2]|0;G=aa+168|0;ba=c[G>>2]|0;X=aa+172|0;do{if(!(ba>>>0<(c[X>>2]|0)>>>0)){_=aa+32|0;if((c[_>>2]|0)!=0){W=aa+40|0;U=Fd[c[aa+16>>2]&15](c[aa+28>>2]|0,W,c[aa+36>>2]|0)|0;if((U|0)==0){c[_>>2]=0;_=(c[X>>2]|0)+ -1|0;c[G>>2]=_;a[_>>0]=0;ca=c[G>>2]|0;O=56;break}else{c[G>>2]=W;c[X>>2]=aa+U+40;ca=W;O=56;break}}else{da=0}}else{ca=ba;O=56}}while(0);if((O|0)==56){O=0;c[G>>2]=ca+1;ba=a[ca>>0]|0;aa=ba&15;if((ba&255)>15){O=57;break}if(aa>>>0>3){O=59;break}else{da=aa}}aa=0;do{ba=c[b>>2]|0;X=ba+168|0;w=c[X>>2]|0;W=ba+172|0;if(!(w>>>0<(c[W>>2]|0)>>>0)){U=ba+32|0;if((c[U>>2]|0)==0){ea=0}else{_=ba+40|0;Z=Fd[c[ba+16>>2]&15](c[ba+28>>2]|0,_,c[ba+36>>2]|0)|0;if((Z|0)==0){c[U>>2]=0;U=(c[W>>2]|0)+ -1|0;c[X>>2]=U;a[U>>0]=0;fa=c[X>>2]|0}else{c[X>>2]=_;c[W>>2]=ba+Z+40;fa=_}c[X>>2]=fa+1;ea=d[fa>>0]|0}}else{c[X>>2]=w+1;ea=d[w>>0]|0}a[(d[27176+aa>>0]|0)+(b+(da<<6))+13444>>0]=ea;aa=aa+1|0}while((aa|0)!=64);aa=T+ -65|0;if((aa|0)>0){T=aa}else{ga=aa;break b}}if((O|0)==57){c[6510]=27144;h=0;i=f;return h|0}else if((O|0)==59){c[6510]=27160;h=0;i=f;return h|0}}else{ga=Y}}while(0);h=(ga|0)==0&1;i=f;return h|0};default:{if(!((e+ -224|0)>>>0<16|(e|0)==254)){h=0;i=f;return h|0}e=c[b>>2]|0;b=e+168|0;ga=c[b>>2]|0;Y=e+172|0;O=c[Y>>2]|0;if(!(ga>>>0<O>>>0)){ea=e+32|0;if((c[ea>>2]|0)==0){ha=0;ia=ga;ja=O}else{da=e+40|0;fa=Fd[c[e+16>>2]&15](c[e+28>>2]|0,da,c[e+36>>2]|0)|0;if((fa|0)==0){c[ea>>2]=0;ea=(c[Y>>2]|0)+ -1|0;c[b>>2]=ea;a[ea>>0]=0;ka=c[Y>>2]|0;la=c[b>>2]|0}else{c[b>>2]=da;ea=e+fa+40|0;c[Y>>2]=ea;ka=ea;la=da}da=la+1|0;c[b>>2]=da;ha=d[la>>0]|0;ia=da;ja=ka}}else{ka=ga+1|0;c[b>>2]=ka;ha=d[ga>>0]|0;ia=ka;ja=O}O=ha<<8;if(!(ia>>>0<ja>>>0)){ja=e+32|0;if((c[ja>>2]|0)==0){ma=0;na=ia}else{ha=e+40|0;ka=Fd[c[e+16>>2]&15](c[e+28>>2]|0,ha,c[e+36>>2]|0)|0;if((ka|0)==0){c[ja>>2]=0;ja=(c[Y>>2]|0)+ -1|0;c[b>>2]=ja;a[ja>>0]=0;oa=c[b>>2]|0}else{c[b>>2]=ha;c[Y>>2]=e+ka+40;oa=ha}ha=oa+1|0;c[b>>2]=ha;ma=d[oa>>0]|0;na=ha}}else{ha=ia+1|0;c[b>>2]=ha;ma=d[ia>>0]|0;na=ha}ha=(ma|O)+ -2|0;if((c[e+16>>2]|0)!=0?(O=c[Y>>2]|0,Y=O-na|0,(Y|0)<(ha|0)):0){c[b>>2]=O;Md[c[e+20>>2]&63](c[e+28>>2]|0,ha-Y|0);h=1;i=f;return h|0}c[b>>2]=na+ha;h=1;i=f;return h|0}}return 0}function Ik(f,g){f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;h=i;j=0;k=0;while(1){l=g+(j<<2)|0;j=j+1|0;if((c[l>>2]|0)>0){m=j&255;n=0;o=k;while(1){p=o+1|0;a[f+o+1280>>0]=m;n=n+1|0;if((n|0)>=(c[l>>2]|0)){q=p;break}else{o=p}}}else{q=k}if((j|0)==16){break}else{k=q}}a[f+q+1280>>0]=0;q=0;k=1;j=0;while(1){c[f+(k<<2)+1612>>2]=j-q;if((d[f+j+1280>>0]|0|0)==(k|0)){g=q;o=j;while(1){r=g+1|0;l=o;o=o+1|0;b[f+(l<<1)+512>>1]=g;if((d[f+o+1280>>0]|0|0)!=(k|0)){break}else{g=r}}if((g|0)<(1<<k|0)){s=r;t=o}else{u=10;break}}else{s=q;t=j}c[f+(k<<2)+1540>>2]=s<<16-k;k=k+1|0;if((k|0)>=17){break}else{q=s<<1;j=t}}if((u|0)==10){c[6510]=27272;v=0;i=h;return v|0}c[f+(k<<2)+1540>>2]=-1;Om(f|0,-1,512)|0;if((t|0)>0){w=0}else{v=1;i=h;return v|0}do{k=a[f+w+1280>>0]|0;if((k&255)<10?(u=9-(k&255)|0,k=1<<u,(k|0)>0):0){Om(f+((e[f+(w<<1)+512>>1]|0)<<u)|0,w&255|0,k|0)|0}w=w+1|0}while((w|0)!=(t|0));v=1;i=h;return v|0}function Jk(f,g,h){f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;j=i;i=i+144|0;k=j+72|0;l=j;m=l+0|0;n=m+68|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(n|0));Om(f|0,-1,1024)|0;m=(h|0)>0;if(m){n=0;do{o=l+((d[g+n>>0]|0)<<2)|0;c[o>>2]=(c[o>>2]|0)+1;n=n+1|0}while((n|0)!=(h|0))}c[l>>2]=0;n=1;while(1){if((c[l+(n<<2)>>2]|0)>(1<<n|0)){p=6;break}n=n+1|0;if((n|0)>=16){q=0;r=1;s=0;break}}if((p|0)==6){Ga(28480,26544,1665,28504)}while(1){c[k+(r<<2)>>2]=q;b[f+(r<<1)+1024>>1]=q;b[f+(r<<1)+1124>>1]=s;n=c[l+(r<<2)>>2]|0;o=n+q|0;if((n|0)!=0&(o|0)>(1<<r|0)){p=8;break}c[f+(r<<2)+1056>>2]=o<<16-r;r=r+1|0;if((r|0)>=16){break}else{q=o<<1;s=n+s|0}}if((p|0)==8){c[6510]=28464;t=0;i=j;return t|0}c[f+1120>>2]=65536;if(m){u=0}else{t=1;i=j;return t|0}do{m=a[g+u>>0]|0;p=m&255;if(!(m<<24>>24==0)){s=k+(p<<2)|0;q=c[s>>2]|0;r=q-(e[f+(p<<1)+1024>>1]|0)+(e[f+(p<<1)+1124>>1]|0)|0;a[f+r+1156>>0]=m;b[f+(r<<1)+1444>>1]=u;if((m&255)<10?(m=q>>>1&21845|q<<1&43690,l=m>>>2&13107|m<<2&52428,m=l>>>4&3855|l<<4&61680,l=(m<<8&65280|m>>>8)>>>(16-p|0),(l|0)<512):0){m=r&65535;r=1<<p;p=l;do{b[f+(p<<1)>>1]=m;p=p+r|0}while((p|0)<512)}c[s>>2]=q+1}u=u+1|0}while((u|0)<(h|0));t=1;i=j;return t|0}function Kk(a,f){a=a|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;g=i;h=a+8|0;j=c[h>>2]|0;k=a+12|0;a:do{if((j|0)<16){l=a+4|0;m=j;n=c[k>>2]|0;while(1){if(!(n>>>0<1<<m>>>0)){break}o=c[a>>2]|0;if(o>>>0<(c[l>>2]|0)>>>0){c[a>>2]=o+1;p=d[o>>0]|0}else{p=0}o=p<<m|n;c[k>>2]=o;q=m+8|0;c[h>>2]=q;if((q|0)<25){m=q;n=o}else{r=o;s=q;break a}}Ga(28328,26544,1727,28368)}else{r=c[k>>2]|0;s=j}}while(0);j=a+12|0;a=b[f+((r&511)<<1)>>1]|0;k=a&65535;if(!(a<<16>>16==-1)){a=d[f+k+1156>>0]|0;c[j>>2]=r>>>a;c[h>>2]=s-a;t=e[f+(k<<1)+1444>>1]|0;i=g;return t|0}k=r>>>1&21845|r<<1&43690;a=k>>>2&13107|k<<2&52428;k=a>>>4&3855|a<<4&61680;a=k<<8&65280|k>>>8;k=10;while(1){if((a|0)<(c[f+(k<<2)+1056>>2]|0)){break}else{k=k+1|0}}if((k|0)==16){t=-1;i=g;return t|0}p=(a>>>(16-k|0))-(e[f+(k<<1)+1024>>1]|0)+(e[f+(k<<1)+1124>>1]|0)|0;if((d[f+p+1156>>0]|0|0)!=(k|0)){Ga(28296,26544,1764,28312)}c[j>>2]=r>>>k;c[h>>2]=s-k;t=e[f+(p<<1)+1444>>1]|0;i=g;return t|0}function Lk(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;j=i;if((f|0)==(e|0)){k=b;i=j;return k|0}if(!((f+ -1|0)>>>0<4)){Ga(28696,26544,509,28728)}l=Ll(da(da(g,f)|0,h)|0)|0;if((l|0)==0){Ml(b);c[6510]=26456;k=0;i=j;return k|0}a:do{if((h|0)>0){m=(e<<3)+f|0;n=g+ -1|0;o=(n|0)>-1;p=0;b:while(1){q=da(p,g)|0;r=b+(da(q,e)|0)|0;s=l+(da(q,f)|0)|0;do{switch(m|0){case 17:{if(o){q=s;t=n;u=r;while(1){a[q>>0]=a[u>>0]|0;t=t+ -1|0;if(!((t|0)>-1)){break}else{q=q+1|0;u=u+2|0}}}break};case 19:{if(o){u=s;q=n;t=r;while(1){v=a[t>>0]|0;a[u+2>>0]=v;a[u+1>>0]=v;a[u>>0]=v;q=q+ -1|0;if(!((q|0)>-1)){break}else{u=u+3|0;t=t+2|0}}}break};case 10:{if(o){t=s;u=n;q=r;while(1){a[t>>0]=a[q>>0]|0;a[t+1>>0]=-1;u=u+ -1|0;if(!((u|0)>-1)){break}else{t=t+2|0;q=q+1|0}}}break};case 33:{if(o){q=s;t=n;u=r;while(1){a[q>>0]=(((d[u+1>>0]|0)*150|0)+((d[u>>0]|0)*77|0)+((d[u+2>>0]|0)*29|0)|0)>>>8;t=t+ -1|0;if(!((t|0)>-1)){break}else{q=q+1|0;u=u+4|0}}}break};case 35:{if(o){u=s;q=n;t=r;while(1){a[u>>0]=a[t>>0]|0;a[u+1>>0]=a[t+1>>0]|0;a[u+2>>0]=a[t+2>>0]|0;q=q+ -1|0;if(!((q|0)>-1)){break}else{u=u+3|0;t=t+4|0}}}break};case 28:{if(o){t=s;u=n;q=r;while(1){a[t>>0]=a[q>>0]|0;a[t+1>>0]=a[q+1>>0]|0;a[t+2>>0]=a[q+2>>0]|0;a[t+3>>0]=-1;u=u+ -1|0;if(!((u|0)>-1)){break}else{t=t+4|0;q=q+3|0}}}break};case 11:{if(o){q=s;t=n;u=r;while(1){v=a[u>>0]|0;a[q+2>>0]=v;a[q+1>>0]=v;a[q>>0]=v;t=t+ -1|0;if(!((t|0)>-1)){break}else{q=q+3|0;u=u+1|0}}}break};case 20:{if(o){u=s;q=n;t=r;while(1){v=a[t>>0]|0;a[u+2>>0]=v;a[u+1>>0]=v;a[u>>0]=v;a[u+3>>0]=a[t+1>>0]|0;q=q+ -1|0;if(!((q|0)>-1)){break}else{u=u+4|0;t=t+2|0}}}break};case 26:{if(o){t=s;u=n;q=r;while(1){a[t>>0]=(((d[q+1>>0]|0)*150|0)+((d[q>>0]|0)*77|0)+((d[q+2>>0]|0)*29|0)|0)>>>8;a[t+1>>0]=-1;u=u+ -1|0;if(!((u|0)>-1)){break}else{t=t+2|0;q=q+3|0}}}break};case 12:{if(o){q=s;t=n;u=r;while(1){v=a[u>>0]|0;a[q+2>>0]=v;a[q+1>>0]=v;a[q>>0]=v;a[q+3>>0]=-1;t=t+ -1|0;if(!((t|0)>-1)){break}else{q=q+4|0;u=u+1|0}}}break};case 25:{if(o){u=s;q=n;t=r;while(1){a[u>>0]=(((d[t+1>>0]|0)*150|0)+((d[t>>0]|0)*77|0)+((d[t+2>>0]|0)*29|0)|0)>>>8;q=q+ -1|0;if(!((q|0)>-1)){break}else{u=u+1|0;t=t+3|0}}}break};case 34:{if(o){t=s;u=n;q=r;while(1){a[t>>0]=(((d[q+1>>0]|0)*150|0)+((d[q>>0]|0)*77|0)+((d[q+2>>0]|0)*29|0)|0)>>>8;a[t+1>>0]=a[q+3>>0]|0;u=u+ -1|0;if(!((u|0)>-1)){break}else{t=t+2|0;q=q+4|0}}}break};default:{break b}}}while(0);p=p+1|0;if((p|0)>=(h|0)){break a}}Ga(28744,26544,538,28728)}}while(0);Ml(b);k=l;i=j;return k|0}function Mk(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;g=i;h=f&65535;f=b[e+(h<<2)+2080>>1]|0;if(f<<16>>16>-1){Mk(e,f)}f=e+18500|0;j=c[f>>2]|0;k=e+18492|0;if((j|0)>=(c[k>>2]|0)){i=g;return}l=e+18496|0;m=c[l>>2]|0;n=m+j|0;j=c[e+8>>2]|0;o=d[e+(h<<2)+2083>>0]<<2;h=c[e+18464>>2]|0;p=h+(o|3)|0;if((a[p>>0]|0)<0){a[j+n>>0]=a[h+(o|2)>>0]|0;a[j+(n+1)>>0]=a[h+(o|1)>>0]|0;a[j+(n+2)>>0]=a[h+o>>0]|0;a[j+(n+3)>>0]=a[p>>0]|0;q=c[l>>2]|0}else{q=m}m=q+4|0;c[l>>2]=m;if((m|0)<(c[e+18488>>2]|0)){i=g;return}c[l>>2]=c[e+18480>>2];l=e+18472|0;m=(c[f>>2]|0)+(c[l>>2]|0)|0;c[f>>2]=m;q=e+18468|0;p=c[k>>2]|0;if((m|0)<(p|0)){i=g;return}m=e+18504|0;k=e+18484|0;e=c[q>>2]|0;while(1){if((e|0)<=0){r=11;break}n=c[m>>2]<<e;c[l>>2]=n;j=(n>>1)+(c[k>>2]|0)|0;c[f>>2]=j;e=e+ -1|0;c[q>>2]=e;if((j|0)<(p|0)){r=11;break}}if((r|0)==11){i=g;return}}function Nk(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Yc=0,Zc=0,_c=0,$c=0,ad=0,bd=0,cd=0,dd=0,ed=0,fd=0,gd=0,hd=0,id=0,jd=0,kd=0,ld=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0,yd=0,zd=0,Ad=0,Bd=0,Cd=0,Dd=0,Ed=0,Gd=0,Hd=0,Id=0,Jd=0,Kd=0,Ld=0,Nd=0,Od=0,Pd=0,Qd=0,Rd=0,Sd=0,Td=0,Ud=0,Vd=0,Wd=0,Xd=0,Yd=0,Zd=0,_d=0,$d=0,ae=0,be=0,ce=0,de=0,ee=0,fe=0,ge=0,he=0,ie=0,je=0,ke=0,le=0,me=0,ne=0,oe=0,pe=0,qe=0,re=0,se=0,te=0,ue=0,ve=0,we=0,xe=0,ye=0,ze=0,Ae=0,Be=0,Ce=0,De=0,Ee=0,Fe=0,Ge=0,He=0,Ie=0,Je=0,Ke=0,Le=0,Me=0,Ne=0,Oe=0,Pe=0,Qe=0,Re=0,Se=0,Te=0,Ue=0,Ve=0,We=0,Xe=0,Ye=0,Ze=0,_e=0,$e=0,af=0,bf=0,cf=0,df=0,ef=0,ff=0,gf=0,hf=0,jf=0,kf=0,lf=0,mf=0,nf=0,of=0,pf=0,qf=0,rf=0,sf=0,tf=0,uf=0,vf=0,wf=0,xf=0,yf=0,zf=0,Af=0,Bf=0,Cf=0,Df=0,Ef=0,Ff=0,Gf=0,Hf=0,If=0,Jf=0,Kf=0,Lf=0,Mf=0,Nf=0,Of=0,Pf=0,Qf=0,Rf=0,Sf=0,Tf=0,Uf=0,Vf=0,Wf=0,Xf=0,Yf=0,Zf=0,_f=0,$f=0,ag=0,bg=0,cg=0,dg=0,eg=0,fg=0,gg=0,hg=0,ig=0,jg=0,kg=0,lg=0,mg=0,ng=0,og=0,pg=0,qg=0,rg=0,sg=0,tg=0,ug=0,vg=0,wg=0,xg=0,yg=0,zg=0,Ag=0,Bg=0,Cg=0,Dg=0,Eg=0,Fg=0,Gg=0,Hg=0,Ig=0,Jg=0,Kg=0,Lg=0,Mg=0,Ng=0,Og=0,Pg=0,Qg=0,Rg=0,Sg=0,Tg=0,Ug=0,Vg=0,Wg=0,Xg=0,Yg=0,Zg=0,_g=0,$g=0,ah=0,bh=0,ch=0,dh=0,eh=0,fh=0,gh=0,hh=0,ih=0,jh=0,kh=0,lh=0,mh=0,nh=0,oh=0,ph=0,qh=0,rh=0,sh=0,th=0,uh=0,vh=0,wh=0,xh=0,yh=0,zh=0,Ah=0,Bh=0,Ch=0,Dh=0,Eh=0,Fh=0,Gh=0,Hh=0,Ih=0,Jh=0,Kh=0,Lh=0,Mh=0,Nh=0,Oh=0,Ph=0,Qh=0,Rh=0,Sh=0,Th=0,Uh=0,Vh=0,Wh=0,Xh=0,Yh=0,Zh=0,_h=0,$h=0,ai=0,bi=0,ci=0,di=0,ei=0,fi=0,gi=0,hi=0,ii=0,ji=0,ki=0,li=0,mi=0,ni=0,oi=0,pi=0,qi=0,ri=0,si=0,ti=0,ui=0,vi=0,wi=0,xi=0,yi=0,zi=0,Ai=0,Bi=0,Ci=0,Di=0,Ei=0,Fi=0,Gi=0,Hi=0,Ii=0,Ji=0,Ki=0,Li=0,Mi=0,Ni=0,Oi=0,Pi=0,Qi=0,Ri=0,Si=0,Ti=0,Ui=0,Vi=0,Wi=0,Xi=0,Yi=0,Zi=0,_i=0,$i=0,aj=0,bj=0,cj=0,dj=0,ej=0,fj=0,gj=0,hj=0,ij=0,jj=0,kj=0,lj=0,mj=0,nj=0,oj=0,pj=0,qj=0,rj=0,sj=0,tj=0,uj=0,vj=0,wj=0,xj=0,yj=0,zj=0,Aj=0,Bj=0,Cj=0,Dj=0,Ej=0,Fj=0,Gj=0,Hj=0,Ij=0,Jj=0,Kj=0,Lj=0,Mj=0,Nj=0,Oj=0,Pj=0,Qj=0,Rj=0,Sj=0,Tj=0,Uj=0,Vj=0,Wj=0,Xj=0,Yj=0,Zj=0,_j=0,$j=0,ak=0,bk=0,ck=0,dk=0,ek=0,fk=0,gk=0,hk=0,ik=0,jk=0,kk=0,lk=0,mk=0,nk=0,ok=0,pk=0,qk=0,rk=0,sk=0,tk=0,uk=0,vk=0,wk=0,xk=0,yk=0,zk=0,Ak=0,Bk=0,Ck=0,Dk=0,Ek=0,Fk=0,Gk=0,Hk=0,Ik=0,Jk=0,Kk=0,Mk=0,Nk=0,Ok=0,Pk=0,Qk=0,Rk=0,Sk=0,Tk=0,Uk=0,Vk=0,Wk=0,Xk=0,Yk=0,Zk=0,_k=0,$k=0,al=0,bl=0,cl=0,dl=0,el=0,fl=0,gl=0,hl=0,il=0,jl=0,kl=0,ll=0,ml=0,nl=0,ol=0;j=i;i=i+1024|0;k=j;l=b+168|0;m=c[l>>2]|0;n=b+172|0;do{if(!(m>>>0<(c[n>>2]|0)>>>0)){o=b+32|0;if((c[o>>2]|0)!=0){p=b+40|0;q=Fd[c[b+16>>2]&15](c[b+28>>2]|0,p,c[b+36>>2]|0)|0;if((q|0)==0){c[o>>2]=0;o=(c[n>>2]|0)+ -1|0;c[l>>2]=o;a[o>>0]=0;r=c[l>>2]|0;s=6;break}else{c[l>>2]=p;c[n>>2]=b+q+40;r=p;s=6;break}}}else{r=m;s=6}}while(0);a:do{if((s|0)==6?(m=r+1|0,c[l>>2]=m,(a[r>>0]|0)==66):0){do{if(!(m>>>0<(c[n>>2]|0)>>>0)){p=b+32|0;if((c[p>>2]|0)==0){break a}q=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((o|0)==0){c[p>>2]=0;p=(c[n>>2]|0)+ -1|0;c[l>>2]=p;a[p>>0]=0;t=c[l>>2]|0;break}else{c[l>>2]=q;c[n>>2]=b+o+40;t=q;break}}else{t=m}}while(0);m=t+1|0;c[l>>2]=m;if((a[t>>0]|0)==77){q=c[n>>2]|0;if(!(m>>>0<q>>>0)){o=b+32|0;if((c[o>>2]|0)==0){u=m;v=q}else{m=b+40|0;p=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((p|0)==0){c[o>>2]=0;o=(c[n>>2]|0)+ -1|0;c[l>>2]=o;a[o>>0]=0;w=c[n>>2]|0;x=c[l>>2]|0}else{c[l>>2]=m;o=b+p+40|0;c[n>>2]=o;w=o;x=m}m=x+1|0;c[l>>2]=m;u=m;v=w}}else{m=t+2|0;c[l>>2]=m;u=m;v=q}if(!(u>>>0<v>>>0)){q=b+32|0;if((c[q>>2]|0)==0){y=u;z=v}else{m=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((o|0)==0){c[q>>2]=0;q=(c[n>>2]|0)+ -1|0;c[l>>2]=q;a[q>>0]=0;A=c[n>>2]|0;B=c[l>>2]|0}else{c[l>>2]=m;q=b+o+40|0;c[n>>2]=q;A=q;B=m}m=B+1|0;c[l>>2]=m;y=m;z=A}}else{m=u+1|0;c[l>>2]=m;y=m;z=v}if(!(y>>>0<z>>>0)){m=b+32|0;if((c[m>>2]|0)==0){C=y;D=z}else{q=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;E=c[n>>2]|0;F=c[l>>2]|0}else{c[l>>2]=q;m=b+o+40|0;c[n>>2]=m;E=m;F=q}q=F+1|0;c[l>>2]=q;C=q;D=E}}else{q=y+1|0;c[l>>2]=q;C=q;D=z}if(!(C>>>0<D>>>0)){q=b+32|0;if((c[q>>2]|0)==0){G=C;H=D}else{m=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((o|0)==0){c[q>>2]=0;q=(c[n>>2]|0)+ -1|0;c[l>>2]=q;a[q>>0]=0;I=c[n>>2]|0;J=c[l>>2]|0}else{c[l>>2]=m;q=b+o+40|0;c[n>>2]=q;I=q;J=m}m=J+1|0;c[l>>2]=m;G=m;H=I}}else{m=C+1|0;c[l>>2]=m;G=m;H=D}if(!(G>>>0<H>>>0)){m=b+32|0;if((c[m>>2]|0)==0){K=G;L=H}else{q=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;M=c[n>>2]|0;N=c[l>>2]|0}else{c[l>>2]=q;m=b+o+40|0;c[n>>2]=m;M=m;N=q}q=N+1|0;c[l>>2]=q;K=q;L=M}}else{q=G+1|0;c[l>>2]=q;K=q;L=H}if(!(K>>>0<L>>>0)){q=b+32|0;if((c[q>>2]|0)==0){O=K;P=L}else{m=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((o|0)==0){c[q>>2]=0;q=(c[n>>2]|0)+ -1|0;c[l>>2]=q;a[q>>0]=0;Q=c[n>>2]|0;R=c[l>>2]|0}else{c[l>>2]=m;q=b+o+40|0;c[n>>2]=q;Q=q;R=m}m=R+1|0;c[l>>2]=m;O=m;P=Q}}else{m=K+1|0;c[l>>2]=m;O=m;P=L}if(!(O>>>0<P>>>0)){m=b+32|0;if((c[m>>2]|0)==0){S=O;T=P}else{q=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;U=c[n>>2]|0;V=c[l>>2]|0}else{c[l>>2]=q;m=b+o+40|0;c[n>>2]=m;U=m;V=q}q=V+1|0;c[l>>2]=q;S=q;T=U}}else{q=O+1|0;c[l>>2]=q;S=q;T=P}if(!(S>>>0<T>>>0)){q=b+32|0;if((c[q>>2]|0)==0){W=S;X=T}else{m=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((o|0)==0){c[q>>2]=0;q=(c[n>>2]|0)+ -1|0;c[l>>2]=q;a[q>>0]=0;Y=c[n>>2]|0;Z=c[l>>2]|0}else{c[l>>2]=m;q=b+o+40|0;c[n>>2]=q;Y=q;Z=m}m=Z+1|0;c[l>>2]=m;W=m;X=Y}}else{m=S+1|0;c[l>>2]=m;W=m;X=T}if(!(W>>>0<X>>>0)){m=b+32|0;if((c[m>>2]|0)==0){_=0;$=W;aa=X}else{q=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;ba=c[n>>2]|0;ca=c[l>>2]|0}else{c[l>>2]=q;m=b+o+40|0;c[n>>2]=m;ba=m;ca=q}q=ca+1|0;c[l>>2]=q;_=d[ca>>0]|0;$=q;aa=ba}}else{q=W+1|0;c[l>>2]=q;_=d[W>>0]|0;$=q;aa=X}if(!($>>>0<aa>>>0)){q=b+32|0;if((c[q>>2]|0)==0){ea=0;fa=$;ga=aa}else{m=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((o|0)==0){c[q>>2]=0;q=(c[n>>2]|0)+ -1|0;c[l>>2]=q;a[q>>0]=0;ha=c[n>>2]|0;ia=c[l>>2]|0}else{c[l>>2]=m;q=b+o+40|0;c[n>>2]=q;ha=q;ia=m}m=ia+1|0;c[l>>2]=m;ea=d[ia>>0]|0;fa=m;ga=ha}}else{m=$+1|0;c[l>>2]=m;ea=d[$>>0]|0;fa=m;ga=aa}m=ea<<8|_;if(!(fa>>>0<ga>>>0)){q=b+32|0;if((c[q>>2]|0)==0){ja=0;ka=fa;la=ga}else{o=b+40|0;p=Fd[c[b+16>>2]&15](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((p|0)==0){c[q>>2]=0;q=(c[n>>2]|0)+ -1|0;c[l>>2]=q;a[q>>0]=0;ma=c[n>>2]|0;na=c[l>>2]|0}else{c[l>>2]=o;q=b+p+40|0;c[n>>2]=q;ma=q;na=o}o=na+1|0;c[l>>2]=o;ja=d[na>>0]|0;ka=o;la=ma}}else{o=fa+1|0;c[l>>2]=o;ja=d[fa>>0]|0;ka=o;la=ga}if(!(ka>>>0<la>>>0)){o=b+32|0;if((c[o>>2]|0)==0){oa=0;pa=ka;qa=la}else{q=b+40|0;p=Fd[c[b+16>>2]&15](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((p|0)==0){c[o>>2]=0;o=(c[n>>2]|0)+ -1|0;c[l>>2]=o;a[o>>0]=0;ra=c[n>>2]|0;sa=c[l>>2]|0}else{c[l>>2]=q;o=b+p+40|0;c[n>>2]=o;ra=o;sa=q}q=sa+1|0;c[l>>2]=q;oa=d[sa>>0]|0;pa=q;qa=ra}}else{q=ka+1|0;c[l>>2]=q;oa=d[ka>>0]|0;pa=q;qa=la}q=m|(oa<<8|ja)<<16;if(!(pa>>>0<qa>>>0)){m=b+32|0;if((c[m>>2]|0)==0){ta=0;ua=pa;va=qa}else{o=b+40|0;p=Fd[c[b+16>>2]&15](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((p|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;wa=c[n>>2]|0;xa=c[l>>2]|0}else{c[l>>2]=o;m=b+p+40|0;c[n>>2]=m;wa=m;xa=o}o=xa+1|0;c[l>>2]=o;ta=d[xa>>0]|0;ua=o;va=wa}}else{o=pa+1|0;c[l>>2]=o;ta=d[pa>>0]|0;ua=o;va=qa}do{if(ua>>>0<va>>>0){o=ua+1|0;c[l>>2]=o;ya=d[ua>>0]|0;za=o;Aa=va}else{o=b+32|0;if((c[o>>2]|0)==0){ya=0;za=ua;Aa=va;break}m=b+40|0;p=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((p|0)==0){c[o>>2]=0;o=(c[n>>2]|0)+ -1|0;c[l>>2]=o;a[o>>0]=0;Ba=c[n>>2]|0;Ca=c[l>>2]|0}else{c[l>>2]=m;o=b+p+40|0;c[n>>2]=o;Ba=o;Ca=m}m=Ca+1|0;c[l>>2]=m;ya=d[Ca>>0]|0;za=m;Aa=Ba}}while(0);m=ya<<8|ta;do{if(za>>>0<Aa>>>0){o=za+1|0;c[l>>2]=o;Da=d[za>>0]|0;Ea=o;Fa=Aa}else{o=b+32|0;if((c[o>>2]|0)==0){Da=0;Ea=za;Fa=Aa;break}p=b+40|0;Ha=Fd[c[b+16>>2]&15](c[b+28>>2]|0,p,c[b+36>>2]|0)|0;if((Ha|0)==0){c[o>>2]=0;o=(c[n>>2]|0)+ -1|0;c[l>>2]=o;a[o>>0]=0;Ia=c[n>>2]|0;Ja=c[l>>2]|0}else{c[l>>2]=p;o=b+Ha+40|0;c[n>>2]=o;Ia=o;Ja=p}p=Ja+1|0;c[l>>2]=p;Da=d[Ja>>0]|0;Ea=p;Fa=Ia}}while(0);do{if(Ea>>>0<Fa>>>0){p=Ea+1|0;c[l>>2]=p;Ka=d[Ea>>0]|0;La=p}else{p=b+32|0;if((c[p>>2]|0)==0){Ka=0;La=Ea;break}o=b+40|0;Ha=Fd[c[b+16>>2]&15](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((Ha|0)==0){c[p>>2]=0;p=(c[n>>2]|0)+ -1|0;c[l>>2]=p;a[p>>0]=0;Ma=c[l>>2]|0}else{c[l>>2]=o;c[n>>2]=b+Ha+40;Ma=o}o=Ma+1|0;c[l>>2]=o;Ka=d[Ma>>0]|0;La=o}}while(0);o=m|(Ka<<8|Da)<<16;Ha=(o|0)==12;if(!((o|0)==12|(o|0)==40|(o|0)==56|(o|0)==108)){c[6510]=29008;Na=0;i=j;return Na|0}p=c[n>>2]|0;Oa=La>>>0<p>>>0;if(Ha){do{if(Oa){Pa=La+1|0;c[l>>2]=Pa;Qa=d[La>>0]|0;Ra=Pa;Sa=p}else{Pa=b+32|0;if((c[Pa>>2]|0)==0){Qa=0;Ra=La;Sa=p;break}Ta=b+40|0;Ua=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ta,c[b+36>>2]|0)|0;if((Ua|0)==0){c[Pa>>2]=0;Pa=(c[n>>2]|0)+ -1|0;c[l>>2]=Pa;a[Pa>>0]=0;Va=c[n>>2]|0;Wa=c[l>>2]|0}else{c[l>>2]=Ta;Pa=b+Ua+40|0;c[n>>2]=Pa;Va=Pa;Wa=Ta}Ta=Wa+1|0;c[l>>2]=Ta;Qa=d[Wa>>0]|0;Ra=Ta;Sa=Va}}while(0);do{if(Ra>>>0<Sa>>>0){m=Ra+1|0;c[l>>2]=m;Xa=d[Ra>>0]|0;Ya=m;Za=Sa}else{m=b+32|0;if((c[m>>2]|0)==0){Xa=0;Ya=Ra;Za=Sa;break}Ta=b+40|0;Pa=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ta,c[b+36>>2]|0)|0;if((Pa|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;_a=c[n>>2]|0;$a=c[l>>2]|0}else{c[l>>2]=Ta;m=b+Pa+40|0;c[n>>2]=m;_a=m;$a=Ta}Ta=$a+1|0;c[l>>2]=Ta;Xa=d[$a>>0]|0;Ya=Ta;Za=_a}}while(0);c[b>>2]=Xa<<8|Qa;do{if(Ya>>>0<Za>>>0){Ta=Ya+1|0;c[l>>2]=Ta;ab=d[Ya>>0]|0;bb=Ta;cb=Za}else{Ta=b+32|0;if((c[Ta>>2]|0)==0){ab=0;bb=Ya;cb=Za;break}m=b+40|0;Pa=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((Pa|0)==0){c[Ta>>2]=0;Ta=(c[n>>2]|0)+ -1|0;c[l>>2]=Ta;a[Ta>>0]=0;db=c[n>>2]|0;eb=c[l>>2]|0}else{c[l>>2]=m;Ta=b+Pa+40|0;c[n>>2]=Ta;db=Ta;eb=m}m=eb+1|0;c[l>>2]=m;ab=d[eb>>0]|0;bb=m;cb=db}}while(0);do{if(bb>>>0<cb>>>0){m=bb+1|0;c[l>>2]=m;fb=d[bb>>0]|0;gb=m}else{m=b+32|0;if((c[m>>2]|0)==0){fb=0;gb=bb;break}Ta=b+40|0;Pa=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ta,c[b+36>>2]|0)|0;if((Pa|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;hb=c[l>>2]|0}else{c[l>>2]=Ta;c[n>>2]=b+Pa+40;hb=Ta}Ta=hb+1|0;c[l>>2]=Ta;fb=d[hb>>0]|0;gb=Ta}}while(0);c[b+4>>2]=fb<<8|ab;ib=gb}else{do{if(Oa){Ta=La+1|0;c[l>>2]=Ta;jb=d[La>>0]|0;kb=Ta;lb=p}else{Ta=b+32|0;if((c[Ta>>2]|0)==0){jb=0;kb=La;lb=p;break}Pa=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Pa,c[b+36>>2]|0)|0;if((m|0)==0){c[Ta>>2]=0;Ta=(c[n>>2]|0)+ -1|0;c[l>>2]=Ta;a[Ta>>0]=0;mb=c[n>>2]|0;nb=c[l>>2]|0}else{c[l>>2]=Pa;Ta=b+m+40|0;c[n>>2]=Ta;mb=Ta;nb=Pa}Pa=nb+1|0;c[l>>2]=Pa;jb=d[nb>>0]|0;kb=Pa;lb=mb}}while(0);do{if(kb>>>0<lb>>>0){p=kb+1|0;c[l>>2]=p;ob=d[kb>>0]|0;pb=p;qb=lb}else{p=b+32|0;if((c[p>>2]|0)==0){ob=0;pb=kb;qb=lb;break}Oa=b+40|0;Pa=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Oa,c[b+36>>2]|0)|0;if((Pa|0)==0){c[p>>2]=0;p=(c[n>>2]|0)+ -1|0;c[l>>2]=p;a[p>>0]=0;rb=c[n>>2]|0;sb=c[l>>2]|0}else{c[l>>2]=Oa;p=b+Pa+40|0;c[n>>2]=p;rb=p;sb=Oa}Oa=sb+1|0;c[l>>2]=Oa;ob=d[sb>>0]|0;pb=Oa;qb=rb}}while(0);Oa=ob<<8|jb;do{if(pb>>>0<qb>>>0){p=pb+1|0;c[l>>2]=p;tb=d[pb>>0]|0;ub=p;vb=qb}else{p=b+32|0;if((c[p>>2]|0)==0){tb=0;ub=pb;vb=qb;break}Pa=b+40|0;Ta=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Pa,c[b+36>>2]|0)|0;if((Ta|0)==0){c[p>>2]=0;p=(c[n>>2]|0)+ -1|0;c[l>>2]=p;a[p>>0]=0;wb=c[n>>2]|0;xb=c[l>>2]|0}else{c[l>>2]=Pa;p=b+Ta+40|0;c[n>>2]=p;wb=p;xb=Pa}Pa=xb+1|0;c[l>>2]=Pa;tb=d[xb>>0]|0;ub=Pa;vb=wb}}while(0);do{if(ub>>>0<vb>>>0){Pa=ub+1|0;c[l>>2]=Pa;yb=d[ub>>0]|0;zb=Pa;Ab=vb}else{Pa=b+32|0;if((c[Pa>>2]|0)==0){yb=0;zb=ub;Ab=vb;break}p=b+40|0;Ta=Fd[c[b+16>>2]&15](c[b+28>>2]|0,p,c[b+36>>2]|0)|0;if((Ta|0)==0){c[Pa>>2]=0;Pa=(c[n>>2]|0)+ -1|0;c[l>>2]=Pa;a[Pa>>0]=0;Bb=c[n>>2]|0;Cb=c[l>>2]|0}else{c[l>>2]=p;Pa=b+Ta+40|0;c[n>>2]=Pa;Bb=Pa;Cb=p}p=Cb+1|0;c[l>>2]=p;yb=d[Cb>>0]|0;zb=p;Ab=Bb}}while(0);c[b>>2]=Oa|(yb<<8|tb)<<16;do{if(zb>>>0<Ab>>>0){p=zb+1|0;c[l>>2]=p;Db=d[zb>>0]|0;Eb=p;Fb=Ab}else{p=b+32|0;if((c[p>>2]|0)==0){Db=0;Eb=zb;Fb=Ab;break}Pa=b+40|0;Ta=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Pa,c[b+36>>2]|0)|0;if((Ta|0)==0){c[p>>2]=0;p=(c[n>>2]|0)+ -1|0;c[l>>2]=p;a[p>>0]=0;Gb=c[n>>2]|0;Hb=c[l>>2]|0}else{c[l>>2]=Pa;p=b+Ta+40|0;c[n>>2]=p;Gb=p;Hb=Pa}Pa=Hb+1|0;c[l>>2]=Pa;Db=d[Hb>>0]|0;Eb=Pa;Fb=Gb}}while(0);do{if(Eb>>>0<Fb>>>0){Oa=Eb+1|0;c[l>>2]=Oa;Ib=d[Eb>>0]|0;Jb=Oa;Kb=Fb}else{Oa=b+32|0;if((c[Oa>>2]|0)==0){Ib=0;Jb=Eb;Kb=Fb;break}Pa=b+40|0;p=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Pa,c[b+36>>2]|0)|0;if((p|0)==0){c[Oa>>2]=0;Oa=(c[n>>2]|0)+ -1|0;c[l>>2]=Oa;a[Oa>>0]=0;Lb=c[n>>2]|0;Mb=c[l>>2]|0}else{c[l>>2]=Pa;Oa=b+p+40|0;c[n>>2]=Oa;Lb=Oa;Mb=Pa}Pa=Mb+1|0;c[l>>2]=Pa;Ib=d[Mb>>0]|0;Jb=Pa;Kb=Lb}}while(0);Pa=Ib<<8|Db;do{if(Jb>>>0<Kb>>>0){Oa=Jb+1|0;c[l>>2]=Oa;Nb=d[Jb>>0]|0;Ob=Oa;Pb=Kb}else{Oa=b+32|0;if((c[Oa>>2]|0)==0){Nb=0;Ob=Jb;Pb=Kb;break}p=b+40|0;Ta=Fd[c[b+16>>2]&15](c[b+28>>2]|0,p,c[b+36>>2]|0)|0;if((Ta|0)==0){c[Oa>>2]=0;Oa=(c[n>>2]|0)+ -1|0;c[l>>2]=Oa;a[Oa>>0]=0;Qb=c[n>>2]|0;Rb=c[l>>2]|0}else{c[l>>2]=p;Oa=b+Ta+40|0;c[n>>2]=Oa;Qb=Oa;Rb=p}p=Rb+1|0;c[l>>2]=p;Nb=d[Rb>>0]|0;Ob=p;Pb=Qb}}while(0);do{if(Ob>>>0<Pb>>>0){p=Ob+1|0;c[l>>2]=p;Sb=d[Ob>>0]|0;Tb=p}else{p=b+32|0;if((c[p>>2]|0)==0){Sb=0;Tb=Ob;break}Oa=b+40|0;Ta=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Oa,c[b+36>>2]|0)|0;if((Ta|0)==0){c[p>>2]=0;p=(c[n>>2]|0)+ -1|0;c[l>>2]=p;a[p>>0]=0;Ub=c[l>>2]|0}else{c[l>>2]=Oa;c[n>>2]=b+Ta+40;Ub=Oa}Oa=Ub+1|0;c[l>>2]=Oa;Sb=d[Ub>>0]|0;Tb=Oa}}while(0);c[b+4>>2]=Pa|(Sb<<8|Nb)<<16;ib=Tb}Oa=c[n>>2]|0;do{if(ib>>>0<Oa>>>0){Ta=ib+1|0;c[l>>2]=Ta;Vb=d[ib>>0]|0;Wb=Ta;Xb=Oa}else{Ta=b+32|0;if((c[Ta>>2]|0)==0){Vb=0;Wb=ib;Xb=Oa;break}p=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,p,c[b+36>>2]|0)|0;if((m|0)==0){c[Ta>>2]=0;Ta=(c[n>>2]|0)+ -1|0;c[l>>2]=Ta;a[Ta>>0]=0;Yb=c[n>>2]|0;Zb=c[l>>2]|0}else{c[l>>2]=p;Ta=b+m+40|0;c[n>>2]=Ta;Yb=Ta;Zb=p}p=Zb+1|0;c[l>>2]=p;Vb=d[Zb>>0]|0;Wb=p;Xb=Yb}}while(0);do{if(Wb>>>0<Xb>>>0){Oa=Wb+1|0;c[l>>2]=Oa;_b=d[Wb>>0]|0;$b=Oa}else{Oa=b+32|0;if((c[Oa>>2]|0)==0){_b=0;$b=Wb;break}Pa=b+40|0;p=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Pa,c[b+36>>2]|0)|0;if((p|0)==0){c[Oa>>2]=0;Oa=(c[n>>2]|0)+ -1|0;c[l>>2]=Oa;a[Oa>>0]=0;ac=c[l>>2]|0}else{c[l>>2]=Pa;c[n>>2]=b+p+40;ac=Pa}Pa=ac+1|0;c[l>>2]=Pa;_b=d[ac>>0]|0;$b=Pa}}while(0);if((_b<<8|Vb|0)!=1){c[6510]=29024;Na=0;i=j;return Na|0}Pa=c[n>>2]|0;do{if($b>>>0<Pa>>>0){p=$b+1|0;c[l>>2]=p;bc=d[$b>>0]|0;cc=p;dc=Pa}else{p=b+32|0;if((c[p>>2]|0)==0){bc=0;cc=$b;dc=Pa;break}Oa=b+40|0;Ta=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Oa,c[b+36>>2]|0)|0;if((Ta|0)==0){c[p>>2]=0;p=(c[n>>2]|0)+ -1|0;c[l>>2]=p;a[p>>0]=0;ec=c[n>>2]|0;fc=c[l>>2]|0}else{c[l>>2]=Oa;p=b+Ta+40|0;c[n>>2]=p;ec=p;fc=Oa}Oa=fc+1|0;c[l>>2]=Oa;bc=d[fc>>0]|0;cc=Oa;dc=ec}}while(0);do{if(cc>>>0<dc>>>0){Pa=cc+1|0;c[l>>2]=Pa;gc=d[cc>>0]|0;hc=Pa}else{Pa=b+32|0;if((c[Pa>>2]|0)==0){gc=0;hc=cc;break}Oa=b+40|0;p=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Oa,c[b+36>>2]|0)|0;if((p|0)==0){c[Pa>>2]=0;Pa=(c[n>>2]|0)+ -1|0;c[l>>2]=Pa;a[Pa>>0]=0;ic=c[l>>2]|0}else{c[l>>2]=Oa;c[n>>2]=b+p+40;ic=Oa}Oa=ic+1|0;c[l>>2]=Oa;gc=d[ic>>0]|0;hc=Oa}}while(0);Oa=gc<<8|bc;if((Oa|0)==1){c[6510]=29032;Na=0;i=j;return Na|0}p=b+4|0;Pa=c[p>>2]|0;Ta=(Pa|0)>0;c[p>>2]=(Pa|0)>-1?Pa:0-Pa|0;do{if(Ha){if(!(Oa>>>0<24)){jc=hc;kc=0;lc=0;mc=0;nc=0;oc=0;break}jc=hc;kc=0;lc=0;mc=0;nc=0;oc=(q+ -38|0)/3|0}else{Pa=c[n>>2]|0;do{if(hc>>>0<Pa>>>0){m=hc+1|0;c[l>>2]=m;pc=d[hc>>0]|0;qc=m;rc=Pa}else{m=b+32|0;if((c[m>>2]|0)==0){pc=0;qc=hc;rc=Pa;break}Ua=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((sc|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;tc=c[n>>2]|0;uc=c[l>>2]|0}else{c[l>>2]=Ua;m=b+sc+40|0;c[n>>2]=m;tc=m;uc=Ua}Ua=uc+1|0;c[l>>2]=Ua;pc=d[uc>>0]|0;qc=Ua;rc=tc}}while(0);do{if(qc>>>0<rc>>>0){Pa=qc+1|0;c[l>>2]=Pa;vc=d[qc>>0]|0;wc=Pa;xc=rc}else{Pa=b+32|0;if((c[Pa>>2]|0)==0){vc=0;wc=qc;xc=rc;break}Ua=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((m|0)==0){c[Pa>>2]=0;Pa=(c[n>>2]|0)+ -1|0;c[l>>2]=Pa;a[Pa>>0]=0;yc=c[n>>2]|0;zc=c[l>>2]|0}else{c[l>>2]=Ua;Pa=b+m+40|0;c[n>>2]=Pa;yc=Pa;zc=Ua}Ua=zc+1|0;c[l>>2]=Ua;vc=d[zc>>0]|0;wc=Ua;xc=yc}}while(0);Ua=vc<<8|pc;do{if(wc>>>0<xc>>>0){Pa=wc+1|0;c[l>>2]=Pa;Ac=d[wc>>0]|0;Bc=Pa;Cc=xc}else{Pa=b+32|0;if((c[Pa>>2]|0)==0){Ac=0;Bc=wc;Cc=xc;break}m=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((sc|0)==0){c[Pa>>2]=0;Pa=(c[n>>2]|0)+ -1|0;c[l>>2]=Pa;a[Pa>>0]=0;Dc=c[n>>2]|0;Ec=c[l>>2]|0}else{c[l>>2]=m;Pa=b+sc+40|0;c[n>>2]=Pa;Dc=Pa;Ec=m}m=Ec+1|0;c[l>>2]=m;Ac=d[Ec>>0]|0;Bc=m;Cc=Dc}}while(0);do{if(Bc>>>0<Cc>>>0){m=Bc+1|0;c[l>>2]=m;Fc=d[Bc>>0]|0;Gc=m}else{m=b+32|0;if((c[m>>2]|0)==0){Fc=0;Gc=Bc;break}Pa=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Pa,c[b+36>>2]|0)|0;if((sc|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;Hc=c[l>>2]|0}else{c[l>>2]=Pa;c[n>>2]=b+sc+40;Hc=Pa}Pa=Hc+1|0;c[l>>2]=Pa;Fc=d[Hc>>0]|0;Gc=Pa}}while(0);Pa=Ua|(Fc<<8|Ac)<<16;if((Pa+ -1|0)>>>0<2){c[6510]=29048;Na=0;i=j;return Na|0}sc=c[n>>2]|0;do{if(Gc>>>0<sc>>>0){m=Gc+1|0;c[l>>2]=m;Ic=m;Jc=sc}else{m=b+32|0;if((c[m>>2]|0)==0){Ic=Gc;Jc=sc;break}Kc=b+40|0;Lc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((Lc|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;Mc=c[n>>2]|0;Nc=c[l>>2]|0}else{c[l>>2]=Kc;m=b+Lc+40|0;c[n>>2]=m;Mc=m;Nc=Kc}Kc=Nc+1|0;c[l>>2]=Kc;Ic=Kc;Jc=Mc}}while(0);do{if(Ic>>>0<Jc>>>0){sc=Ic+1|0;c[l>>2]=sc;Oc=sc;Pc=Jc}else{sc=b+32|0;if((c[sc>>2]|0)==0){Oc=Ic;Pc=Jc;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Qc=c[n>>2]|0;Rc=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;Qc=sc;Rc=Ua}Ua=Rc+1|0;c[l>>2]=Ua;Oc=Ua;Pc=Qc}}while(0);do{if(Oc>>>0<Pc>>>0){Ua=Oc+1|0;c[l>>2]=Ua;Sc=Ua;Tc=Pc}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Sc=Oc;Tc=Pc;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;Uc=c[n>>2]|0;Vc=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;Uc=Ua;Vc=sc}sc=Vc+1|0;c[l>>2]=sc;Sc=sc;Tc=Uc}}while(0);do{if(Sc>>>0<Tc>>>0){sc=Sc+1|0;c[l>>2]=sc;Wc=sc;Xc=Tc}else{sc=b+32|0;if((c[sc>>2]|0)==0){Wc=Sc;Xc=Tc;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Yc=c[n>>2]|0;Zc=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;Yc=sc;Zc=Ua}Ua=Zc+1|0;c[l>>2]=Ua;Wc=Ua;Xc=Yc}}while(0);do{if(Wc>>>0<Xc>>>0){Ua=Wc+1|0;c[l>>2]=Ua;_c=Ua;$c=Xc}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){_c=Wc;$c=Xc;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;ad=c[n>>2]|0;bd=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;ad=Ua;bd=sc}sc=bd+1|0;c[l>>2]=sc;_c=sc;$c=ad}}while(0);do{if(_c>>>0<$c>>>0){sc=_c+1|0;c[l>>2]=sc;cd=sc;dd=$c}else{sc=b+32|0;if((c[sc>>2]|0)==0){cd=_c;dd=$c;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;ed=c[n>>2]|0;fd=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;ed=sc;fd=Ua}Ua=fd+1|0;c[l>>2]=Ua;cd=Ua;dd=ed}}while(0);do{if(cd>>>0<dd>>>0){Ua=cd+1|0;c[l>>2]=Ua;gd=Ua;hd=dd}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){gd=cd;hd=dd;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;id=c[n>>2]|0;jd=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;id=Ua;jd=sc}sc=jd+1|0;c[l>>2]=sc;gd=sc;hd=id}}while(0);do{if(gd>>>0<hd>>>0){sc=gd+1|0;c[l>>2]=sc;kd=sc;ld=hd}else{sc=b+32|0;if((c[sc>>2]|0)==0){kd=gd;ld=hd;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;md=c[n>>2]|0;nd=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;md=sc;nd=Ua}Ua=nd+1|0;c[l>>2]=Ua;kd=Ua;ld=md}}while(0);do{if(kd>>>0<ld>>>0){Ua=kd+1|0;c[l>>2]=Ua;od=Ua;pd=ld}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){od=kd;pd=ld;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;qd=c[n>>2]|0;rd=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;qd=Ua;rd=sc}sc=rd+1|0;c[l>>2]=sc;od=sc;pd=qd}}while(0);do{if(od>>>0<pd>>>0){sc=od+1|0;c[l>>2]=sc;sd=sc;td=pd}else{sc=b+32|0;if((c[sc>>2]|0)==0){sd=od;td=pd;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;ud=c[n>>2]|0;vd=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;ud=sc;vd=Ua}Ua=vd+1|0;c[l>>2]=Ua;sd=Ua;td=ud}}while(0);do{if(sd>>>0<td>>>0){Ua=sd+1|0;c[l>>2]=Ua;wd=Ua;xd=td}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){wd=sd;xd=td;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;yd=c[n>>2]|0;zd=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;yd=Ua;zd=sc}sc=zd+1|0;c[l>>2]=sc;wd=sc;xd=yd}}while(0);do{if(wd>>>0<xd>>>0){sc=wd+1|0;c[l>>2]=sc;Ad=sc;Bd=xd}else{sc=b+32|0;if((c[sc>>2]|0)==0){Ad=wd;Bd=xd;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Cd=c[n>>2]|0;Dd=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;Cd=sc;Dd=Ua}Ua=Dd+1|0;c[l>>2]=Ua;Ad=Ua;Bd=Cd}}while(0);do{if(Ad>>>0<Bd>>>0){Ua=Ad+1|0;c[l>>2]=Ua;Ed=Ua;Gd=Bd}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Ed=Ad;Gd=Bd;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;Hd=c[n>>2]|0;Id=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;Hd=Ua;Id=sc}sc=Id+1|0;c[l>>2]=sc;Ed=sc;Gd=Hd}}while(0);do{if(Ed>>>0<Gd>>>0){sc=Ed+1|0;c[l>>2]=sc;Jd=sc;Kd=Gd}else{sc=b+32|0;if((c[sc>>2]|0)==0){Jd=Ed;Kd=Gd;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Ld=c[n>>2]|0;Nd=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;Ld=sc;Nd=Ua}Ua=Nd+1|0;c[l>>2]=Ua;Jd=Ua;Kd=Ld}}while(0);do{if(Jd>>>0<Kd>>>0){Ua=Jd+1|0;c[l>>2]=Ua;Od=Ua;Pd=Kd}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Od=Jd;Pd=Kd;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;Qd=c[n>>2]|0;Rd=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;Qd=Ua;Rd=sc}sc=Rd+1|0;c[l>>2]=sc;Od=sc;Pd=Qd}}while(0);do{if(Od>>>0<Pd>>>0){sc=Od+1|0;c[l>>2]=sc;Sd=sc;Td=Pd}else{sc=b+32|0;if((c[sc>>2]|0)==0){Sd=Od;Td=Pd;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Ud=c[n>>2]|0;Vd=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;Ud=sc;Vd=Ua}Ua=Vd+1|0;c[l>>2]=Ua;Sd=Ua;Td=Ud}}while(0);do{if(Sd>>>0<Td>>>0){Ua=Sd+1|0;c[l>>2]=Ua;Wd=Ua;Xd=Td}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Wd=Sd;Xd=Td;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;Yd=c[n>>2]|0;Zd=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;Yd=Ua;Zd=sc}sc=Zd+1|0;c[l>>2]=sc;Wd=sc;Xd=Yd}}while(0);do{if(Wd>>>0<Xd>>>0){sc=Wd+1|0;c[l>>2]=sc;_d=sc;$d=Xd}else{sc=b+32|0;if((c[sc>>2]|0)==0){_d=Wd;$d=Xd;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;ae=c[n>>2]|0;be=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Kc+40|0;c[n>>2]=sc;ae=sc;be=Ua}Ua=be+1|0;c[l>>2]=Ua;_d=Ua;$d=ae}}while(0);do{if(_d>>>0<$d>>>0){Ua=_d+1|0;c[l>>2]=Ua;ce=Ua;de=$d}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){ce=_d;de=$d;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;ee=c[n>>2]|0;fe=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Kc+40|0;c[n>>2]=Ua;ee=Ua;fe=sc}sc=fe+1|0;c[l>>2]=sc;ce=sc;de=ee}}while(0);do{if(ce>>>0<de>>>0){sc=ce+1|0;c[l>>2]=sc;ge=sc}else{sc=b+32|0;if((c[sc>>2]|0)==0){ge=ce;break}Ua=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;he=c[l>>2]|0}else{c[l>>2]=Ua;c[n>>2]=b+Kc+40;he=Ua}Ua=he+1|0;c[l>>2]=Ua;ge=Ua}}while(0);b:do{if((o&-17|0)==40){do{if((o|0)==56){Ua=c[n>>2]|0;do{if(ge>>>0<Ua>>>0){c[l>>2]=ge+1;ie=Ua}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){ie=Ua;break}sc=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((m|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;je=c[n>>2]|0;ke=c[l>>2]|0}else{c[l>>2]=sc;Kc=b+m+40|0;c[n>>2]=Kc;je=Kc;ke=sc}c[l>>2]=ke+1;ie=je}}while(0);Ua=c[l>>2]|0;do{if(Ua>>>0<ie>>>0){sc=Ua+1|0;c[l>>2]=sc;le=sc;me=ie}else{sc=b+32|0;if((c[sc>>2]|0)==0){le=Ua;me=ie;break}Kc=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((m|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;ne=c[n>>2]|0;oe=c[l>>2]|0}else{c[l>>2]=Kc;sc=b+m+40|0;c[n>>2]=sc;ne=sc;oe=Kc}Kc=oe+1|0;c[l>>2]=Kc;le=Kc;me=ne}}while(0);do{if(le>>>0<me>>>0){Ua=le+1|0;c[l>>2]=Ua;pe=Ua;qe=me}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){pe=le;qe=me;break}Kc=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((sc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;re=c[n>>2]|0;se=c[l>>2]|0}else{c[l>>2]=Kc;Ua=b+sc+40|0;c[n>>2]=Ua;re=Ua;se=Kc}Kc=se+1|0;c[l>>2]=Kc;pe=Kc;qe=re}}while(0);do{if(pe>>>0<qe>>>0){Kc=pe+1|0;c[l>>2]=Kc;te=Kc;ue=qe}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){te=pe;ue=qe;break}Ua=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((sc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;ve=c[n>>2]|0;we=c[l>>2]|0}else{c[l>>2]=Ua;Kc=b+sc+40|0;c[n>>2]=Kc;ve=Kc;we=Ua}Ua=we+1|0;c[l>>2]=Ua;te=Ua;ue=ve}}while(0);do{if(te>>>0<ue>>>0){Ua=te+1|0;c[l>>2]=Ua;xe=Ua;ye=ue}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){xe=te;ye=ue;break}Kc=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((sc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;ze=c[n>>2]|0;Ae=c[l>>2]|0}else{c[l>>2]=Kc;Ua=b+sc+40|0;c[n>>2]=Ua;ze=Ua;Ae=Kc}Kc=Ae+1|0;c[l>>2]=Kc;xe=Kc;ye=ze}}while(0);do{if(xe>>>0<ye>>>0){Kc=xe+1|0;c[l>>2]=Kc;Be=Kc;Ce=ye}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){Be=xe;Ce=ye;break}Ua=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((sc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;De=c[n>>2]|0;Ee=c[l>>2]|0}else{c[l>>2]=Ua;Kc=b+sc+40|0;c[n>>2]=Kc;De=Kc;Ee=Ua}Ua=Ee+1|0;c[l>>2]=Ua;Be=Ua;Ce=De}}while(0);do{if(Be>>>0<Ce>>>0){Ua=Be+1|0;c[l>>2]=Ua;Fe=Ua;Ge=Ce}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Fe=Be;Ge=Ce;break}Kc=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((sc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;He=c[n>>2]|0;Ie=c[l>>2]|0}else{c[l>>2]=Kc;Ua=b+sc+40|0;c[n>>2]=Ua;He=Ua;Ie=Kc}Kc=Ie+1|0;c[l>>2]=Kc;Fe=Kc;Ge=He}}while(0);do{if(Fe>>>0<Ge>>>0){Kc=Fe+1|0;c[l>>2]=Kc;Je=Kc;Ke=Ge}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){Je=Fe;Ke=Ge;break}Ua=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((sc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;Le=c[n>>2]|0;Me=c[l>>2]|0}else{c[l>>2]=Ua;Kc=b+sc+40|0;c[n>>2]=Kc;Le=Kc;Me=Ua}Ua=Me+1|0;c[l>>2]=Ua;Je=Ua;Ke=Le}}while(0);do{if(Je>>>0<Ke>>>0){Ua=Je+1|0;c[l>>2]=Ua;Ne=Ua;Oe=Ke}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Ne=Je;Oe=Ke;break}Kc=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((sc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;Pe=c[n>>2]|0;Qe=c[l>>2]|0}else{c[l>>2]=Kc;Ua=b+sc+40|0;c[n>>2]=Ua;Pe=Ua;Qe=Kc}Kc=Qe+1|0;c[l>>2]=Kc;Ne=Kc;Oe=Pe}}while(0);do{if(Ne>>>0<Oe>>>0){Kc=Ne+1|0;c[l>>2]=Kc;Re=Kc;Se=Oe}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){Re=Ne;Se=Oe;break}Ua=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((sc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;Te=c[n>>2]|0;Ue=c[l>>2]|0}else{c[l>>2]=Ua;Kc=b+sc+40|0;c[n>>2]=Kc;Te=Kc;Ue=Ua}Ua=Ue+1|0;c[l>>2]=Ua;Re=Ua;Se=Te}}while(0);do{if(Re>>>0<Se>>>0){Ua=Re+1|0;c[l>>2]=Ua;Ve=Ua;We=Se}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Ve=Re;We=Se;break}Kc=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((sc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;Xe=c[n>>2]|0;Ye=c[l>>2]|0}else{c[l>>2]=Kc;Ua=b+sc+40|0;c[n>>2]=Ua;Xe=Ua;Ye=Kc}Kc=Ye+1|0;c[l>>2]=Kc;Ve=Kc;We=Xe}}while(0);do{if(Ve>>>0<We>>>0){Kc=Ve+1|0;c[l>>2]=Kc;Ze=Kc;_e=We}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){Ze=Ve;_e=We;break}Ua=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((sc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;$e=c[n>>2]|0;af=c[l>>2]|0}else{c[l>>2]=Ua;Kc=b+sc+40|0;c[n>>2]=Kc;$e=Kc;af=Ua}Ua=af+1|0;c[l>>2]=Ua;Ze=Ua;_e=$e}}while(0);do{if(Ze>>>0<_e>>>0){Ua=Ze+1|0;c[l>>2]=Ua;bf=Ua;cf=_e}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){bf=Ze;cf=_e;break}Kc=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((sc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;df=c[n>>2]|0;ef=c[l>>2]|0}else{c[l>>2]=Kc;Ua=b+sc+40|0;c[n>>2]=Ua;df=Ua;ef=Kc}Kc=ef+1|0;c[l>>2]=Kc;bf=Kc;cf=df}}while(0);do{if(bf>>>0<cf>>>0){Kc=bf+1|0;c[l>>2]=Kc;ff=Kc;gf=cf}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){ff=bf;gf=cf;break}Ua=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((sc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;hf=c[n>>2]|0;jf=c[l>>2]|0}else{c[l>>2]=Ua;Kc=b+sc+40|0;c[n>>2]=Kc;hf=Kc;jf=Ua}Ua=jf+1|0;c[l>>2]=Ua;ff=Ua;gf=hf}}while(0);do{if(ff>>>0<gf>>>0){Ua=ff+1|0;c[l>>2]=Ua;kf=Ua;lf=gf}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){kf=ff;lf=gf;break}Kc=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((sc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;mf=c[n>>2]|0;nf=c[l>>2]|0}else{c[l>>2]=Kc;Ua=b+sc+40|0;c[n>>2]=Ua;mf=Ua;nf=Kc}Kc=nf+1|0;c[l>>2]=Kc;kf=Kc;lf=mf}}while(0);if(kf>>>0<lf>>>0){Kc=kf+1|0;c[l>>2]=Kc;of=Kc;break}Kc=b+32|0;if((c[Kc>>2]|0)==0){of=kf;break}Ua=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((sc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;pf=c[l>>2]|0}else{c[l>>2]=Ua;c[n>>2]=b+sc+40;pf=Ua}Ua=pf+1|0;c[l>>2]=Ua;of=Ua}else{of=ge}}while(0);Ua=(Oa|0)==32;if(!((Oa|0)==16|(Oa|0)==32)){qf=of;rf=0;sf=0;tf=0;uf=0;break}if((Pa|0)==0){qf=of;rf=Ua?-16777216:0;sf=Ua?255:31;tf=Ua?65280:992;uf=Ua?16711680:31744;break}else if((Pa|0)==3){Ua=c[l>>2]|0;sc=c[n>>2]|0;do{if(Ua>>>0<sc>>>0){Kc=Ua+1|0;c[l>>2]=Kc;vf=d[Ua>>0]|0;wf=Kc;xf=sc}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){vf=0;wf=Ua;xf=sc;break}m=b+40|0;Lc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((Lc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;yf=c[n>>2]|0;zf=c[l>>2]|0}else{c[l>>2]=m;Kc=b+Lc+40|0;c[n>>2]=Kc;yf=Kc;zf=m}m=zf+1|0;c[l>>2]=m;vf=d[zf>>0]|0;wf=m;xf=yf}}while(0);do{if(wf>>>0<xf>>>0){sc=wf+1|0;c[l>>2]=sc;Af=d[wf>>0]|0;Bf=sc;Cf=xf}else{sc=b+32|0;if((c[sc>>2]|0)==0){Af=0;Bf=wf;Cf=xf;break}Ua=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((m|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Df=c[n>>2]|0;Ef=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+m+40|0;c[n>>2]=sc;Df=sc;Ef=Ua}Ua=Ef+1|0;c[l>>2]=Ua;Af=d[Ef>>0]|0;Bf=Ua;Cf=Df}}while(0);Ua=Af<<8|vf;do{if(Bf>>>0<Cf>>>0){sc=Bf+1|0;c[l>>2]=sc;Ff=d[Bf>>0]|0;Gf=sc;Hf=Cf}else{sc=b+32|0;if((c[sc>>2]|0)==0){Ff=0;Gf=Bf;Hf=Cf;break}m=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((Kc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;If=c[n>>2]|0;Jf=c[l>>2]|0}else{c[l>>2]=m;sc=b+Kc+40|0;c[n>>2]=sc;If=sc;Jf=m}m=Jf+1|0;c[l>>2]=m;Ff=d[Jf>>0]|0;Gf=m;Hf=If}}while(0);do{if(Gf>>>0<Hf>>>0){m=Gf+1|0;c[l>>2]=m;Kf=d[Gf>>0]|0;Lf=m;Mf=Hf}else{m=b+32|0;if((c[m>>2]|0)==0){Kf=0;Lf=Gf;Mf=Hf;break}sc=b+40|0;Kc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Kc|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;Nf=c[n>>2]|0;Of=c[l>>2]|0}else{c[l>>2]=sc;m=b+Kc+40|0;c[n>>2]=m;Nf=m;Of=sc}sc=Of+1|0;c[l>>2]=sc;Kf=d[Of>>0]|0;Lf=sc;Mf=Nf}}while(0);sc=Ua|(Kf<<8|Ff)<<16;do{if(Lf>>>0<Mf>>>0){m=Lf+1|0;c[l>>2]=m;Pf=d[Lf>>0]|0;Qf=m;Rf=Mf}else{m=b+32|0;if((c[m>>2]|0)==0){Pf=0;Qf=Lf;Rf=Mf;break}Kc=b+40|0;Lc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((Lc|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;Sf=c[n>>2]|0;Tf=c[l>>2]|0}else{c[l>>2]=Kc;m=b+Lc+40|0;c[n>>2]=m;Sf=m;Tf=Kc}Kc=Tf+1|0;c[l>>2]=Kc;Pf=d[Tf>>0]|0;Qf=Kc;Rf=Sf}}while(0);do{if(Qf>>>0<Rf>>>0){Ua=Qf+1|0;c[l>>2]=Ua;Uf=d[Qf>>0]|0;Vf=Ua;Wf=Rf}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Uf=0;Vf=Qf;Wf=Rf;break}Kc=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((m|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;Xf=c[n>>2]|0;Yf=c[l>>2]|0}else{c[l>>2]=Kc;Ua=b+m+40|0;c[n>>2]=Ua;Xf=Ua;Yf=Kc}Kc=Yf+1|0;c[l>>2]=Kc;Uf=d[Yf>>0]|0;Vf=Kc;Wf=Xf}}while(0);Kc=Uf<<8|Pf;do{if(Vf>>>0<Wf>>>0){Ua=Vf+1|0;c[l>>2]=Ua;Zf=d[Vf>>0]|0;_f=Ua;$f=Wf}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Zf=0;_f=Vf;$f=Wf;break}m=b+40|0;Lc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((Lc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;ag=c[n>>2]|0;bg=c[l>>2]|0}else{c[l>>2]=m;Ua=b+Lc+40|0;c[n>>2]=Ua;ag=Ua;bg=m}m=bg+1|0;c[l>>2]=m;Zf=d[bg>>0]|0;_f=m;$f=ag}}while(0);do{if(_f>>>0<$f>>>0){m=_f+1|0;c[l>>2]=m;cg=d[_f>>0]|0;dg=m;eg=$f}else{m=b+32|0;if((c[m>>2]|0)==0){cg=0;dg=_f;eg=$f;break}Ua=b+40|0;Lc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Lc|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;fg=c[n>>2]|0;gg=c[l>>2]|0}else{c[l>>2]=Ua;m=b+Lc+40|0;c[n>>2]=m;fg=m;gg=Ua}Ua=gg+1|0;c[l>>2]=Ua;cg=d[gg>>0]|0;dg=Ua;eg=fg}}while(0);Ua=Kc|(cg<<8|Zf)<<16;do{if(dg>>>0<eg>>>0){m=dg+1|0;c[l>>2]=m;hg=d[dg>>0]|0;ig=m;jg=eg}else{m=b+32|0;if((c[m>>2]|0)==0){hg=0;ig=dg;jg=eg;break}Lc=b+40|0;kg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Lc,c[b+36>>2]|0)|0;if((kg|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;lg=c[n>>2]|0;mg=c[l>>2]|0}else{c[l>>2]=Lc;m=b+kg+40|0;c[n>>2]=m;lg=m;mg=Lc}Lc=mg+1|0;c[l>>2]=Lc;hg=d[mg>>0]|0;ig=Lc;jg=lg}}while(0);do{if(ig>>>0<jg>>>0){Kc=ig+1|0;c[l>>2]=Kc;ng=d[ig>>0]|0;og=Kc;pg=jg}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){ng=0;og=ig;pg=jg;break}Lc=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Lc,c[b+36>>2]|0)|0;if((m|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;qg=c[n>>2]|0;rg=c[l>>2]|0}else{c[l>>2]=Lc;Kc=b+m+40|0;c[n>>2]=Kc;qg=Kc;rg=Lc}Lc=rg+1|0;c[l>>2]=Lc;ng=d[rg>>0]|0;og=Lc;pg=qg}}while(0);Lc=ng<<8|hg;do{if(og>>>0<pg>>>0){Kc=og+1|0;c[l>>2]=Kc;sg=d[og>>0]|0;tg=Kc;ug=pg}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){sg=0;tg=og;ug=pg;break}m=b+40|0;kg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((kg|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;vg=c[n>>2]|0;wg=c[l>>2]|0}else{c[l>>2]=m;Kc=b+kg+40|0;c[n>>2]=Kc;vg=Kc;wg=m}m=wg+1|0;c[l>>2]=m;sg=d[wg>>0]|0;tg=m;ug=vg}}while(0);do{if(tg>>>0<ug>>>0){m=tg+1|0;c[l>>2]=m;xg=d[tg>>0]|0;yg=m}else{m=b+32|0;if((c[m>>2]|0)==0){xg=0;yg=tg;break}Kc=b+40|0;kg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((kg|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;zg=c[l>>2]|0}else{c[l>>2]=Kc;c[n>>2]=b+kg+40;zg=Kc}Kc=zg+1|0;c[l>>2]=Kc;xg=d[zg>>0]|0;yg=Kc}}while(0);Kc=Lc|(xg<<8|sg)<<16;if(!((sc|0)==(Ua|0)&(Ua|0)==(Kc|0))){qf=yg;rf=0;sf=Kc;tf=Ua;uf=sc;break}c[6510]=29024;Na=0;i=j;return Na|0}else{c[6510]=29024;Na=0;i=j;return Na|0}}else{if((o|0)!=108){Ga(29056,26544,2691,29072)}Kc=c[n>>2]|0;do{if(ge>>>0<Kc>>>0){c[l>>2]=ge+1;Ag=d[ge>>0]|0;Bg=Kc}else{kg=b+32|0;if((c[kg>>2]|0)==0){Ag=0;Bg=Kc;break}m=b+40|0;Cg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((Cg|0)==0){c[kg>>2]=0;kg=(c[n>>2]|0)+ -1|0;c[l>>2]=kg;a[kg>>0]=0;Dg=c[n>>2]|0;Eg=c[l>>2]|0}else{c[l>>2]=m;kg=b+Cg+40|0;c[n>>2]=kg;Dg=kg;Eg=m}c[l>>2]=Eg+1;Ag=d[Eg>>0]|0;Bg=Dg}}while(0);Kc=c[l>>2]|0;do{if(Kc>>>0<Bg>>>0){sc=Kc+1|0;c[l>>2]=sc;Fg=d[Kc>>0]|0;Gg=sc;Hg=Bg}else{sc=b+32|0;if((c[sc>>2]|0)==0){Fg=0;Gg=Kc;Hg=Bg;break}Ua=b+40|0;Lc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Lc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Ig=c[n>>2]|0;Jg=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Lc+40|0;c[n>>2]=sc;Ig=sc;Jg=Ua}Ua=Jg+1|0;c[l>>2]=Ua;Fg=d[Jg>>0]|0;Gg=Ua;Hg=Ig}}while(0);Kc=Fg<<8|Ag;do{if(Gg>>>0<Hg>>>0){Ua=Gg+1|0;c[l>>2]=Ua;Kg=d[Gg>>0]|0;Lg=Ua;Mg=Hg}else{Ua=b+32|0;if((c[Ua>>2]|0)==0){Kg=0;Lg=Gg;Mg=Hg;break}sc=b+40|0;Lc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Lc|0)==0){c[Ua>>2]=0;Ua=(c[n>>2]|0)+ -1|0;c[l>>2]=Ua;a[Ua>>0]=0;Ng=c[n>>2]|0;Og=c[l>>2]|0}else{c[l>>2]=sc;Ua=b+Lc+40|0;c[n>>2]=Ua;Ng=Ua;Og=sc}sc=Og+1|0;c[l>>2]=sc;Kg=d[Og>>0]|0;Lg=sc;Mg=Ng}}while(0);do{if(Lg>>>0<Mg>>>0){sc=Lg+1|0;c[l>>2]=sc;Pg=d[Lg>>0]|0;Qg=sc;Rg=Mg}else{sc=b+32|0;if((c[sc>>2]|0)==0){Pg=0;Qg=Lg;Rg=Mg;break}Ua=b+40|0;Lc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Ua,c[b+36>>2]|0)|0;if((Lc|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Sg=c[n>>2]|0;Tg=c[l>>2]|0}else{c[l>>2]=Ua;sc=b+Lc+40|0;c[n>>2]=sc;Sg=sc;Tg=Ua}Ua=Tg+1|0;c[l>>2]=Ua;Pg=d[Tg>>0]|0;Qg=Ua;Rg=Sg}}while(0);Ua=Kc|(Pg<<8|Kg)<<16;do{if(Qg>>>0<Rg>>>0){sc=Qg+1|0;c[l>>2]=sc;Ug=d[Qg>>0]|0;Vg=sc;Wg=Rg}else{sc=b+32|0;if((c[sc>>2]|0)==0){Ug=0;Vg=Qg;Wg=Rg;break}Lc=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Lc,c[b+36>>2]|0)|0;if((m|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Xg=c[n>>2]|0;Yg=c[l>>2]|0}else{c[l>>2]=Lc;sc=b+m+40|0;c[n>>2]=sc;Xg=sc;Yg=Lc}Lc=Yg+1|0;c[l>>2]=Lc;Ug=d[Yg>>0]|0;Vg=Lc;Wg=Xg}}while(0);do{if(Vg>>>0<Wg>>>0){Kc=Vg+1|0;c[l>>2]=Kc;Zg=d[Vg>>0]|0;_g=Kc;$g=Wg}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){Zg=0;_g=Vg;$g=Wg;break}Lc=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Lc,c[b+36>>2]|0)|0;if((sc|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;ah=c[n>>2]|0;bh=c[l>>2]|0}else{c[l>>2]=Lc;Kc=b+sc+40|0;c[n>>2]=Kc;ah=Kc;bh=Lc}Lc=bh+1|0;c[l>>2]=Lc;Zg=d[bh>>0]|0;_g=Lc;$g=ah}}while(0);Lc=Zg<<8|Ug;do{if(_g>>>0<$g>>>0){Kc=_g+1|0;c[l>>2]=Kc;ch=d[_g>>0]|0;dh=Kc;eh=$g}else{Kc=b+32|0;if((c[Kc>>2]|0)==0){ch=0;dh=_g;eh=$g;break}sc=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((m|0)==0){c[Kc>>2]=0;Kc=(c[n>>2]|0)+ -1|0;c[l>>2]=Kc;a[Kc>>0]=0;fh=c[n>>2]|0;gh=c[l>>2]|0}else{c[l>>2]=sc;Kc=b+m+40|0;c[n>>2]=Kc;fh=Kc;gh=sc}sc=gh+1|0;c[l>>2]=sc;ch=d[gh>>0]|0;dh=sc;eh=fh}}while(0);do{if(dh>>>0<eh>>>0){sc=dh+1|0;c[l>>2]=sc;hh=d[dh>>0]|0;ih=sc;jh=eh}else{sc=b+32|0;if((c[sc>>2]|0)==0){hh=0;ih=dh;jh=eh;break}Kc=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Kc,c[b+36>>2]|0)|0;if((m|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;kh=c[n>>2]|0;lh=c[l>>2]|0}else{c[l>>2]=Kc;sc=b+m+40|0;c[n>>2]=sc;kh=sc;lh=Kc}Kc=lh+1|0;c[l>>2]=Kc;hh=d[lh>>0]|0;ih=Kc;jh=kh}}while(0);Kc=Lc|(hh<<8|ch)<<16;do{if(ih>>>0<jh>>>0){sc=ih+1|0;c[l>>2]=sc;mh=d[ih>>0]|0;nh=sc;oh=jh}else{sc=b+32|0;if((c[sc>>2]|0)==0){mh=0;nh=ih;oh=jh;break}m=b+40|0;kg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((kg|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;ph=c[n>>2]|0;qh=c[l>>2]|0}else{c[l>>2]=m;sc=b+kg+40|0;c[n>>2]=sc;ph=sc;qh=m}m=qh+1|0;c[l>>2]=m;mh=d[qh>>0]|0;nh=m;oh=ph}}while(0);do{if(nh>>>0<oh>>>0){Lc=nh+1|0;c[l>>2]=Lc;rh=d[nh>>0]|0;sh=Lc;th=oh}else{Lc=b+32|0;if((c[Lc>>2]|0)==0){rh=0;sh=nh;th=oh;break}m=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((sc|0)==0){c[Lc>>2]=0;Lc=(c[n>>2]|0)+ -1|0;c[l>>2]=Lc;a[Lc>>0]=0;uh=c[n>>2]|0;vh=c[l>>2]|0}else{c[l>>2]=m;Lc=b+sc+40|0;c[n>>2]=Lc;uh=Lc;vh=m}m=vh+1|0;c[l>>2]=m;rh=d[vh>>0]|0;sh=m;th=uh}}while(0);m=rh<<8|mh;do{if(sh>>>0<th>>>0){Lc=sh+1|0;c[l>>2]=Lc;wh=d[sh>>0]|0;xh=Lc;yh=th}else{Lc=b+32|0;if((c[Lc>>2]|0)==0){wh=0;xh=sh;yh=th;break}sc=b+40|0;kg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((kg|0)==0){c[Lc>>2]=0;Lc=(c[n>>2]|0)+ -1|0;c[l>>2]=Lc;a[Lc>>0]=0;zh=c[n>>2]|0;Ah=c[l>>2]|0}else{c[l>>2]=sc;Lc=b+kg+40|0;c[n>>2]=Lc;zh=Lc;Ah=sc}sc=Ah+1|0;c[l>>2]=sc;wh=d[Ah>>0]|0;xh=sc;yh=zh}}while(0);do{if(xh>>>0<yh>>>0){sc=xh+1|0;c[l>>2]=sc;Bh=d[xh>>0]|0;Ch=sc;Dh=yh}else{sc=b+32|0;if((c[sc>>2]|0)==0){Bh=0;Ch=xh;Dh=yh;break}Lc=b+40|0;kg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Lc,c[b+36>>2]|0)|0;if((kg|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Eh=c[n>>2]|0;Fh=c[l>>2]|0}else{c[l>>2]=Lc;sc=b+kg+40|0;c[n>>2]=sc;Eh=sc;Fh=Lc}Lc=Fh+1|0;c[l>>2]=Lc;Bh=d[Fh>>0]|0;Ch=Lc;Dh=Eh}}while(0);Lc=m|(Bh<<8|wh)<<16;do{if(Ch>>>0<Dh>>>0){sc=Ch+1|0;c[l>>2]=sc;Gh=d[Ch>>0]|0;Hh=sc;Ih=Dh}else{sc=b+32|0;if((c[sc>>2]|0)==0){Gh=0;Hh=Ch;Ih=Dh;break}kg=b+40|0;Cg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,kg,c[b+36>>2]|0)|0;if((Cg|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Jh=c[n>>2]|0;Kh=c[l>>2]|0}else{c[l>>2]=kg;sc=b+Cg+40|0;c[n>>2]=sc;Jh=sc;Kh=kg}kg=Kh+1|0;c[l>>2]=kg;Gh=d[Kh>>0]|0;Hh=kg;Ih=Jh}}while(0);do{if(Hh>>>0<Ih>>>0){m=Hh+1|0;c[l>>2]=m;Lh=d[Hh>>0]|0;Mh=m;Nh=Ih}else{m=b+32|0;if((c[m>>2]|0)==0){Lh=0;Mh=Hh;Nh=Ih;break}kg=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,kg,c[b+36>>2]|0)|0;if((sc|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;Oh=c[n>>2]|0;Ph=c[l>>2]|0}else{c[l>>2]=kg;m=b+sc+40|0;c[n>>2]=m;Oh=m;Ph=kg}kg=Ph+1|0;c[l>>2]=kg;Lh=d[Ph>>0]|0;Mh=kg;Nh=Oh}}while(0);kg=Lh<<8|Gh;do{if(Mh>>>0<Nh>>>0){m=Mh+1|0;c[l>>2]=m;Qh=d[Mh>>0]|0;Rh=m;Sh=Nh}else{m=b+32|0;if((c[m>>2]|0)==0){Qh=0;Rh=Mh;Sh=Nh;break}sc=b+40|0;Cg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,sc,c[b+36>>2]|0)|0;if((Cg|0)==0){c[m>>2]=0;m=(c[n>>2]|0)+ -1|0;c[l>>2]=m;a[m>>0]=0;Th=c[n>>2]|0;Uh=c[l>>2]|0}else{c[l>>2]=sc;m=b+Cg+40|0;c[n>>2]=m;Th=m;Uh=sc}sc=Uh+1|0;c[l>>2]=sc;Qh=d[Uh>>0]|0;Rh=sc;Sh=Th}}while(0);do{if(Rh>>>0<Sh>>>0){sc=Rh+1|0;c[l>>2]=sc;Vh=d[Rh>>0]|0;Wh=sc;Xh=Sh}else{sc=b+32|0;if((c[sc>>2]|0)==0){Vh=0;Wh=Rh;Xh=Sh;break}m=b+40|0;Cg=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((Cg|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;Yh=c[n>>2]|0;Zh=c[l>>2]|0}else{c[l>>2]=m;sc=b+Cg+40|0;c[n>>2]=sc;Yh=sc;Zh=m}m=Zh+1|0;c[l>>2]=m;Vh=d[Zh>>0]|0;Wh=m;Xh=Yh}}while(0);m=kg|(Vh<<8|Qh)<<16;do{if(Wh>>>0<Xh>>>0){sc=Wh+1|0;c[l>>2]=sc;_h=sc;$h=Xh}else{sc=b+32|0;if((c[sc>>2]|0)==0){_h=Wh;$h=Xh;break}Cg=b+40|0;ai=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Cg,c[b+36>>2]|0)|0;if((ai|0)==0){c[sc>>2]=0;sc=(c[n>>2]|0)+ -1|0;c[l>>2]=sc;a[sc>>0]=0;bi=c[n>>2]|0;ci=c[l>>2]|0}else{c[l>>2]=Cg;sc=b+ai+40|0;c[n>>2]=sc;bi=sc;ci=Cg}Cg=ci+1|0;c[l>>2]=Cg;_h=Cg;$h=bi}}while(0);do{if(_h>>>0<$h>>>0){kg=_h+1|0;c[l>>2]=kg;di=kg;ei=$h}else{kg=b+32|0;if((c[kg>>2]|0)==0){di=_h;ei=$h;break}Cg=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Cg,c[b+36>>2]|0)|0;if((sc|0)==0){c[kg>>2]=0;kg=(c[n>>2]|0)+ -1|0;c[l>>2]=kg;a[kg>>0]=0;fi=c[n>>2]|0;gi=c[l>>2]|0}else{c[l>>2]=Cg;kg=b+sc+40|0;c[n>>2]=kg;fi=kg;gi=Cg}Cg=gi+1|0;c[l>>2]=Cg;di=Cg;ei=fi}}while(0);do{if(di>>>0<ei>>>0){Cg=di+1|0;c[l>>2]=Cg;hi=Cg;ii=ei}else{Cg=b+32|0;if((c[Cg>>2]|0)==0){hi=di;ii=ei;break}kg=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,kg,c[b+36>>2]|0)|0;if((sc|0)==0){c[Cg>>2]=0;Cg=(c[n>>2]|0)+ -1|0;c[l>>2]=Cg;a[Cg>>0]=0;ji=c[n>>2]|0;ki=c[l>>2]|0}else{c[l>>2]=kg;Cg=b+sc+40|0;c[n>>2]=Cg;ji=Cg;ki=kg}kg=ki+1|0;c[l>>2]=kg;hi=kg;ii=ji}}while(0);do{if(hi>>>0<ii>>>0){kg=hi+1|0;c[l>>2]=kg;li=b+32|0;mi=kg}else{kg=b+32|0;if((c[kg>>2]|0)==0){li=kg;mi=hi;break}Cg=b+40|0;sc=Fd[c[b+16>>2]&15](c[b+28>>2]|0,Cg,c[b+36>>2]|0)|0;if((sc|0)==0){c[kg>>2]=0;ai=(c[n>>2]|0)+ -1|0;c[l>>2]=ai;a[ai>>0]=0;ni=c[l>>2]|0}else{c[l>>2]=Cg;c[n>>2]=b+sc+40;ni=Cg}Cg=ni+1|0;c[l>>2]=Cg;li=kg;mi=Cg}}while(0);Cg=b+16|0;kg=b+28|0;sc=b+40|0;ai=b+36|0;oi=mi;pi=1;while(1){qi=c[n>>2]|0;do{if(oi>>>0<qi>>>0){ri=oi+1|0;c[l>>2]=ri;si=ri;ti=qi}else{if((c[li>>2]|0)==0){si=oi;ti=qi;break}ri=Fd[c[Cg>>2]&15](c[kg>>2]|0,sc,c[ai>>2]|0)|0;if((ri|0)==0){c[li>>2]=0;ui=(c[n>>2]|0)+ -1|0;c[l>>2]=ui;a[ui>>0]=0;vi=c[n>>2]|0;wi=c[l>>2]|0}else{c[l>>2]=sc;ui=b+ri+40|0;c[n>>2]=ui;vi=ui;wi=sc}ui=wi+1|0;c[l>>2]=ui;si=ui;ti=vi}}while(0);do{if(si>>>0<ti>>>0){qi=si+1|0;c[l>>2]=qi;xi=qi;yi=ti}else{if((c[li>>2]|0)==0){xi=si;yi=ti;break}qi=Fd[c[Cg>>2]&15](c[kg>>2]|0,sc,c[ai>>2]|0)|0;if((qi|0)==0){c[li>>2]=0;ui=(c[n>>2]|0)+ -1|0;c[l>>2]=ui;a[ui>>0]=0;zi=c[n>>2]|0;Ai=c[l>>2]|0}else{c[l>>2]=sc;ui=b+qi+40|0;c[n>>2]=ui;zi=ui;Ai=sc}ui=Ai+1|0;c[l>>2]=ui;xi=ui;yi=zi}}while(0);do{if(xi>>>0<yi>>>0){ui=xi+1|0;c[l>>2]=ui;Bi=ui;Ci=yi}else{if((c[li>>2]|0)==0){Bi=xi;Ci=yi;break}ui=Fd[c[Cg>>2]&15](c[kg>>2]|0,sc,c[ai>>2]|0)|0;if((ui|0)==0){c[li>>2]=0;qi=(c[n>>2]|0)+ -1|0;c[l>>2]=qi;a[qi>>0]=0;Di=c[n>>2]|0;Ei=c[l>>2]|0}else{c[l>>2]=sc;qi=b+ui+40|0;c[n>>2]=qi;Di=qi;Ei=sc}qi=Ei+1|0;c[l>>2]=qi;Bi=qi;Ci=Di}}while(0);do{if(Bi>>>0<Ci>>>0){qi=Bi+1|0;c[l>>2]=qi;Fi=qi}else{if((c[li>>2]|0)==0){Fi=Bi;break}qi=Fd[c[Cg>>2]&15](c[kg>>2]|0,sc,c[ai>>2]|0)|0;if((qi|0)==0){c[li>>2]=0;ui=(c[n>>2]|0)+ -1|0;c[l>>2]=ui;a[ui>>0]=0;Gi=c[l>>2]|0}else{c[l>>2]=sc;c[n>>2]=b+qi+40;Gi=sc}qi=Gi+1|0;c[l>>2]=qi;Fi=qi}}while(0);if((pi|0)==12){qf=Fi;rf=m;sf=Lc;tf=Kc;uf=Ua;break b}oi=Fi;pi=pi+1|0}}}while(0);if(!(Oa>>>0<16)){jc=qf;kc=rf;lc=sf;mc=tf;nc=uf;oc=0;break}jc=qf;kc=rf;lc=sf;mc=tf;nc=uf;oc=q+ -14-o>>2}}while(0);Pa=(kc|0)!=0;pi=Pa?4:3;oi=b+8|0;c[oi>>2]=pi;Ua=(h|0)==0;Kc=(h|0)>2?h:pi;pi=da(c[b>>2]|0,Kc)|0;Lc=Ll(da(pi,c[p>>2]|0)|0)|0;if((Lc|0)==0){c[6510]=26456;Na=0;i=j;return Na|0}c:do{if(Oa>>>0<16){if((oc|0)==0|(oc|0)>256){Ml(Lc);c[6510]=29088;Na=0;i=j;return Na|0}if((oc|0)>0){pi=b+32|0;m=b+16|0;sc=b+28|0;ai=b+40|0;kg=b+36|0;Cg=jc;qi=0;while(1){ui=c[n>>2]|0;do{if(Cg>>>0<ui>>>0){ri=Cg+1|0;c[l>>2]=ri;Hi=d[Cg>>0]|0;Ii=ri;Ji=ui}else{if((c[pi>>2]|0)==0){Hi=0;Ii=Cg;Ji=ui;break}ri=Fd[c[m>>2]&15](c[sc>>2]|0,ai,c[kg>>2]|0)|0;if((ri|0)==0){c[pi>>2]=0;Ki=(c[n>>2]|0)+ -1|0;c[l>>2]=Ki;a[Ki>>0]=0;Li=c[n>>2]|0;Mi=c[l>>2]|0}else{c[l>>2]=ai;Ki=b+ri+40|0;c[n>>2]=Ki;Li=Ki;Mi=ai}Ki=Mi+1|0;c[l>>2]=Ki;Hi=d[Mi>>0]|0;Ii=Ki;Ji=Li}}while(0);a[k+(qi<<2)+2>>0]=Hi;do{if(Ii>>>0<Ji>>>0){ui=Ii+1|0;c[l>>2]=ui;Ni=d[Ii>>0]|0;Oi=ui;Pi=Ji}else{if((c[pi>>2]|0)==0){Ni=0;Oi=Ii;Pi=Ji;break}ui=Fd[c[m>>2]&15](c[sc>>2]|0,ai,c[kg>>2]|0)|0;if((ui|0)==0){c[pi>>2]=0;Ki=(c[n>>2]|0)+ -1|0;c[l>>2]=Ki;a[Ki>>0]=0;Qi=c[n>>2]|0;Ri=c[l>>2]|0}else{c[l>>2]=ai;Ki=b+ui+40|0;c[n>>2]=Ki;Qi=Ki;Ri=ai}Ki=Ri+1|0;c[l>>2]=Ki;Ni=d[Ri>>0]|0;Oi=Ki;Pi=Qi}}while(0);a[k+(qi<<2)+1>>0]=Ni;do{if(Oi>>>0<Pi>>>0){Ki=Oi+1|0;c[l>>2]=Ki;Si=d[Oi>>0]|0;Ti=Ki}else{if((c[pi>>2]|0)==0){Si=0;Ti=Oi;break}Ki=Fd[c[m>>2]&15](c[sc>>2]|0,ai,c[kg>>2]|0)|0;if((Ki|0)==0){c[pi>>2]=0;ui=(c[n>>2]|0)+ -1|0;c[l>>2]=ui;a[ui>>0]=0;Ui=c[l>>2]|0}else{c[l>>2]=ai;c[n>>2]=b+Ki+40;Ui=ai}Ki=Ui+1|0;c[l>>2]=Ki;Si=d[Ui>>0]|0;Ti=Ki}}while(0);a[k+(qi<<2)>>0]=Si;do{if(Ha){Vi=Ti}else{if(Ti>>>0<(c[n>>2]|0)>>>0){Ki=Ti+1|0;c[l>>2]=Ki;Vi=Ki;break}if((c[pi>>2]|0)==0){Vi=Ti;break}Ki=Fd[c[m>>2]&15](c[sc>>2]|0,ai,c[kg>>2]|0)|0;if((Ki|0)==0){c[pi>>2]=0;ui=(c[n>>2]|0)+ -1|0;c[l>>2]=ui;a[ui>>0]=0;Wi=c[l>>2]|0}else{c[l>>2]=ai;c[n>>2]=b+Ki+40;Wi=ai}Ki=Wi+1|0;c[l>>2]=Ki;Vi=Ki}}while(0);a[k+(qi<<2)+3>>0]=-1;qi=qi+1|0;if((qi|0)==(oc|0)){Xi=m;Yi=Vi;break}else{Cg=Vi}}}else{Xi=b+16|0;Yi=jc}Cg=q+ -14-o-(da(oc,Ha?3:4)|0)|0;do{if((c[Xi>>2]|0)==0){s=840}else{m=c[n>>2]|0;qi=m-Yi|0;if((qi|0)>=(Cg|0)){s=840;break}c[l>>2]=m;Md[c[b+20>>2]&63](c[b+28>>2]|0,Cg-qi|0)}}while(0);if((s|0)==840){c[l>>2]=Yi+Cg}qi=(Oa|0)==4;do{if(qi){m=c[b>>2]|0;Zi=m;_i=(m+1|0)>>>1}else{if((Oa|0)==8){m=c[b>>2]|0;Zi=m;_i=m;break}Ml(Lc);c[6510]=29096;Na=0;i=j;return Na|0}}while(0);Cg=0-_i&3;m=c[p>>2]|0;if((m|0)<=0){$i=m;break}m=b+20|0;ai=b+28|0;pi=(Kc|0)==4;kg=(Oa|0)==8;sc=b+32|0;Ki=b+40|0;ui=b+36|0;ri=Zi;aj=1;bj=0;while(1){d:do{if((ri|0)>0){cj=c[l>>2]|0;dj=0;ej=bj;while(1){do{if(cj>>>0<(c[n>>2]|0)>>>0){fj=cj+1|0;c[l>>2]=fj;gj=d[cj>>0]|0;hj=fj}else{if((c[sc>>2]|0)==0){gj=0;hj=cj;break}fj=Fd[c[Xi>>2]&15](c[ai>>2]|0,Ki,c[ui>>2]|0)|0;if((fj|0)==0){c[sc>>2]=0;ij=(c[n>>2]|0)+ -1|0;c[l>>2]=ij;a[ij>>0]=0;jj=c[l>>2]|0}else{c[l>>2]=Ki;c[n>>2]=b+fj+40;jj=Ki}fj=jj+1|0;c[l>>2]=fj;gj=d[jj>>0]|0;hj=fj}}while(0);if(qi){kj=gj>>>4;lj=gj&15}else{kj=gj;lj=0}a[Lc+ej>>0]=a[k+(kj<<2)>>0]|0;a[Lc+(ej+1)>>0]=a[k+(kj<<2)+1>>0]|0;fj=ej+3|0;a[Lc+(ej+2)>>0]=a[k+(kj<<2)+2>>0]|0;if(pi){a[Lc+fj>>0]=-1;mj=ej+4|0}else{mj=fj}if((dj|1|0)==(c[b>>2]|0)){nj=mj;break d}do{if(kg){if(hj>>>0<(c[n>>2]|0)>>>0){fj=hj+1|0;c[l>>2]=fj;oj=d[hj>>0]|0;pj=fj;break}if((c[sc>>2]|0)==0){oj=0;pj=hj;break}fj=Fd[c[Xi>>2]&15](c[ai>>2]|0,Ki,c[ui>>2]|0)|0;if((fj|0)==0){c[sc>>2]=0;ij=(c[n>>2]|0)+ -1|0;c[l>>2]=ij;a[ij>>0]=0;qj=c[l>>2]|0}else{c[l>>2]=Ki;c[n>>2]=b+fj+40;qj=Ki}fj=qj+1|0;c[l>>2]=fj;oj=d[qj>>0]|0;pj=fj}else{oj=lj;pj=hj}}while(0);a[Lc+mj>>0]=a[k+(oj<<2)>>0]|0;a[Lc+(mj+1)>>0]=a[k+(oj<<2)+1>>0]|0;fj=mj+3|0;a[Lc+(mj+2)>>0]=a[k+(oj<<2)+2>>0]|0;if(pi){a[Lc+fj>>0]=-1;rj=mj+4|0}else{rj=fj}dj=dj+2|0;if((dj|0)>=(c[b>>2]|0)){nj=rj;break}else{cj=pj;ej=rj}}}else{nj=bj}}while(0);do{if((c[Xi>>2]|0)==0){sj=c[l>>2]|0;s=877}else{ej=c[n>>2]|0;cj=c[l>>2]|0;dj=ej-cj|0;if((dj|0)>=(Cg|0)){sj=cj;s=877;break}c[l>>2]=ej;Md[c[m>>2]&63](c[ai>>2]|0,Cg-dj|0)}}while(0);if((s|0)==877){s=0;c[l>>2]=sj+Cg}dj=c[p>>2]|0;if((aj|0)>=(dj|0)){$i=dj;break c}ri=c[b>>2]|0;aj=aj+1|0;bj=nj}}else{bj=q+ -14-o|0;aj=b+16|0;do{if((c[aj>>2]|0)==0){s=883}else{ri=c[n>>2]|0;Cg=ri-jc|0;if((Cg|0)>=(bj|0)){s=883;break}c[l>>2]=ri;Md[c[b+20>>2]&63](c[b+28>>2]|0,bj-Cg|0)}}while(0);if((s|0)==883){c[l>>2]=jc+bj}if((Oa|0)==16){tj=c[b>>2]<<1;s=887}else if((Oa|0)==24){uj=(da(c[b>>2]|0,-3)|0)&3;vj=1;wj=0;xj=0;yj=1;zj=0;Aj=0;Bj=0}else{tj=0;s=887}do{if((s|0)==887){Cg=0-tj&2;ri=(Oa|0)==32&(lc|0)==255&(mc|0)==65280&(nc|0)==16711680&(kc|0)==-16777216;ai=ri?2:0;if(ri){uj=Cg;vj=1;wj=0;xj=0;yj=2;zj=0;Aj=0;Bj=0;break}if((nc|0)==0|(mc|0)==0|(lc|0)==0){Ml(Lc);c[6510]=29104;Na=0;i=j;return Na|0}ri=nc>>>0>65535;m=ri?nc>>>16:nc;pi=ri?16:0;if(m>>>0>255){Cj=m>>>8;Dj=pi|8}else{Cj=m;Dj=pi}if(Cj>>>0>15){Ej=Cj>>>4;Fj=Dj+4|0}else{Ej=Cj;Fj=Dj}if(Ej>>>0>3){Gj=Ej>>>2;Hj=Fj+2|0}else{Gj=Ej;Hj=Fj}pi=Hj+ -7+(Gj>>>0>1&1)|0;m=(nc>>>1&1431655765)+(nc&1431655765)|0;ri=(m>>>2&858993459)+(m&858993459)|0;m=(ri>>>4)+ri&252645135;ri=(m>>>8)+m|0;m=(ri>>>16)+ri&255;ri=mc>>>0>65535;Ki=ri?mc>>>16:mc;sc=ri?16:0;if(Ki>>>0>255){Ij=Ki>>>8;Jj=sc|8}else{Ij=Ki;Jj=sc}if(Ij>>>0>15){Kj=Ij>>>4;Lj=Jj+4|0}else{Kj=Ij;Lj=Jj}if(Kj>>>0>3){Mj=Kj>>>2;Nj=Lj+2|0}else{Mj=Kj;Nj=Lj}sc=Nj+ -7+(Mj>>>0>1&1)|0;Ki=lc>>>0>65535;ri=Ki?lc>>>16:lc;ui=Ki?16:0;if(ri>>>0>255){Oj=ri>>>8;Pj=ui|8}else{Oj=ri;Pj=ui}if(Oj>>>0>15){Qj=Oj>>>4;Rj=Pj+4|0}else{Qj=Oj;Rj=Pj}if(Qj>>>0>3){Sj=Qj>>>2;Tj=Rj+2|0}else{Sj=Qj;Tj=Rj}ui=Tj+ -7+(Sj>>>0>1&1)|0;if((kc|0)==0){uj=Cg;vj=0;wj=-8;xj=ui;yj=ai;zj=sc;Aj=m;Bj=pi;break}ri=kc>>>0>65535;Ki=ri?kc>>>16:kc;kg=ri?16:0;if(Ki>>>0>255){Uj=Ki>>>8;Vj=kg|8}else{Uj=Ki;Vj=kg}if(Uj>>>0>15){Wj=Uj>>>4;Xj=Vj+4|0}else{Wj=Uj;Xj=Vj}if(Wj>>>0>3){Yj=Wj>>>2;Zj=Xj+2|0}else{Yj=Wj;Zj=Xj}uj=Cg;vj=0;wj=Zj+ -7+(Yj>>>0>1&1)|0;xj=ui;yj=ai;zj=sc;Aj=m;Bj=pi}}while(0);bj=c[p>>2]|0;if((bj|0)<=0){$i=bj;break}bj=b+20|0;pi=b+28|0;m=(Oa|0)==16;sc=b+32|0;ai=b+40|0;ui=b+36|0;Cg=(Bj|0)<0;kg=0-Bj|0;Ki=Aj>>>0<8;ri=(zj|0)<0;qi=0-zj|0;dj=(xj|0)<0;ej=0-xj|0;cj=(wj|0)<0;fj=0-wj|0;ij=(Kc|0)==4;_j=(yj|0)==2;$j=0;ak=0;while(1){bk=(c[b>>2]|0)>0;e:do{if(vj){if(!bk){ck=ak;break}dk=c[l>>2]|0;ek=1;fk=ak;while(1){gk=c[n>>2]|0;do{if(dk>>>0<gk>>>0){hk=dk+1|0;c[l>>2]=hk;ik=d[dk>>0]|0;jk=hk;kk=gk}else{if((c[sc>>2]|0)==0){ik=0;jk=dk;kk=gk;break}hk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((hk|0)==0){c[sc>>2]=0;lk=(c[n>>2]|0)+ -1|0;c[l>>2]=lk;a[lk>>0]=0;mk=c[n>>2]|0;nk=c[l>>2]|0}else{c[l>>2]=ai;lk=b+hk+40|0;c[n>>2]=lk;mk=lk;nk=ai}lk=nk+1|0;c[l>>2]=lk;ik=d[nk>>0]|0;jk=lk;kk=mk}}while(0);a[Lc+(fk+2)>>0]=ik;do{if(jk>>>0<kk>>>0){gk=jk+1|0;c[l>>2]=gk;ok=d[jk>>0]|0;pk=gk;qk=kk}else{if((c[sc>>2]|0)==0){ok=0;pk=jk;qk=kk;break}gk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((gk|0)==0){c[sc>>2]=0;lk=(c[n>>2]|0)+ -1|0;c[l>>2]=lk;a[lk>>0]=0;rk=c[n>>2]|0;sk=c[l>>2]|0}else{c[l>>2]=ai;lk=b+gk+40|0;c[n>>2]=lk;rk=lk;sk=ai}lk=sk+1|0;c[l>>2]=lk;ok=d[sk>>0]|0;pk=lk;qk=rk}}while(0);a[Lc+(fk+1)>>0]=ok;do{if(pk>>>0<qk>>>0){lk=pk+1|0;c[l>>2]=lk;tk=d[pk>>0]|0;uk=lk}else{if((c[sc>>2]|0)==0){tk=0;uk=pk;break}lk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((lk|0)==0){c[sc>>2]=0;gk=(c[n>>2]|0)+ -1|0;c[l>>2]=gk;a[gk>>0]=0;vk=c[l>>2]|0}else{c[l>>2]=ai;c[n>>2]=b+lk+40;vk=ai}lk=vk+1|0;c[l>>2]=lk;tk=d[vk>>0]|0;uk=lk}}while(0);a[Lc+fk>>0]=tk;lk=fk+3|0;if(_j){do{if(uk>>>0<(c[n>>2]|0)>>>0){gk=uk+1|0;c[l>>2]=gk;wk=d[uk>>0]|0;xk=gk}else{if((c[sc>>2]|0)==0){wk=0;xk=uk;break}gk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((gk|0)==0){c[sc>>2]=0;hk=(c[n>>2]|0)+ -1|0;c[l>>2]=hk;a[hk>>0]=0;yk=c[l>>2]|0}else{c[l>>2]=ai;c[n>>2]=b+gk+40;yk=ai}gk=yk+1|0;c[l>>2]=gk;wk=d[yk>>0]|0;xk=gk}}while(0);zk=wk&255;Ak=xk}else{zk=-1;Ak=uk}if(ij){a[Lc+lk>>0]=zk;Bk=fk+4|0}else{Bk=lk}if((ek|0)>=(c[b>>2]|0)){ck=Bk;break e}dk=Ak;ek=ek+1|0;fk=Bk}}else{if(!bk){ck=ak;break}fk=c[l>>2]|0;ek=1;dk=ak;while(1){gk=c[n>>2]|0;hk=fk>>>0<gk>>>0;if(m){do{if(hk){Ck=fk+1|0;c[l>>2]=Ck;Dk=d[fk>>0]|0;Ek=Ck;Fk=gk}else{if((c[sc>>2]|0)==0){Dk=0;Ek=fk;Fk=gk;break}Ck=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((Ck|0)==0){c[sc>>2]=0;Gk=(c[n>>2]|0)+ -1|0;c[l>>2]=Gk;a[Gk>>0]=0;Hk=c[n>>2]|0;Ik=c[l>>2]|0}else{c[l>>2]=ai;Gk=b+Ck+40|0;c[n>>2]=Gk;Hk=Gk;Ik=ai}Gk=Ik+1|0;c[l>>2]=Gk;Dk=d[Ik>>0]|0;Ek=Gk;Fk=Hk}}while(0);do{if(Ek>>>0<Fk>>>0){lk=Ek+1|0;c[l>>2]=lk;Jk=d[Ek>>0]|0;Kk=lk}else{if((c[sc>>2]|0)==0){Jk=0;Kk=Ek;break}lk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((lk|0)==0){c[sc>>2]=0;Gk=(c[n>>2]|0)+ -1|0;c[l>>2]=Gk;a[Gk>>0]=0;Mk=c[l>>2]|0}else{c[l>>2]=ai;c[n>>2]=b+lk+40;Mk=ai}lk=Mk+1|0;c[l>>2]=lk;Jk=d[Mk>>0]|0;Kk=lk}}while(0);Nk=Jk<<8|Dk;Ok=Kk}else{do{if(hk){lk=fk+1|0;c[l>>2]=lk;Pk=d[fk>>0]|0;Qk=lk;Rk=gk}else{if((c[sc>>2]|0)==0){Pk=0;Qk=fk;Rk=gk;break}lk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((lk|0)==0){c[sc>>2]=0;Gk=(c[n>>2]|0)+ -1|0;c[l>>2]=Gk;a[Gk>>0]=0;Sk=c[n>>2]|0;Tk=c[l>>2]|0}else{c[l>>2]=ai;Gk=b+lk+40|0;c[n>>2]=Gk;Sk=Gk;Tk=ai}Gk=Tk+1|0;c[l>>2]=Gk;Pk=d[Tk>>0]|0;Qk=Gk;Rk=Sk}}while(0);do{if(Qk>>>0<Rk>>>0){gk=Qk+1|0;c[l>>2]=gk;Uk=d[Qk>>0]|0;Vk=gk;Wk=Rk}else{if((c[sc>>2]|0)==0){Uk=0;Vk=Qk;Wk=Rk;break}gk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((gk|0)==0){c[sc>>2]=0;hk=(c[n>>2]|0)+ -1|0;c[l>>2]=hk;a[hk>>0]=0;Xk=c[n>>2]|0;Yk=c[l>>2]|0}else{c[l>>2]=ai;hk=b+gk+40|0;c[n>>2]=hk;Xk=hk;Yk=ai}hk=Yk+1|0;c[l>>2]=hk;Uk=d[Yk>>0]|0;Vk=hk;Wk=Xk}}while(0);hk=Uk<<8|Pk;do{if(Vk>>>0<Wk>>>0){gk=Vk+1|0;c[l>>2]=gk;Zk=d[Vk>>0]|0;_k=gk;$k=Wk}else{if((c[sc>>2]|0)==0){Zk=0;_k=Vk;$k=Wk;break}gk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((gk|0)==0){c[sc>>2]=0;Gk=(c[n>>2]|0)+ -1|0;c[l>>2]=Gk;a[Gk>>0]=0;al=c[n>>2]|0;bl=c[l>>2]|0}else{c[l>>2]=ai;Gk=b+gk+40|0;c[n>>2]=Gk;al=Gk;bl=ai}Gk=bl+1|0;c[l>>2]=Gk;Zk=d[bl>>0]|0;_k=Gk;$k=al}}while(0);do{if(_k>>>0<$k>>>0){Gk=_k+1|0;c[l>>2]=Gk;cl=d[_k>>0]|0;dl=Gk}else{if((c[sc>>2]|0)==0){cl=0;dl=_k;break}Gk=Fd[c[aj>>2]&15](c[pi>>2]|0,ai,c[ui>>2]|0)|0;if((Gk|0)==0){c[sc>>2]=0;gk=(c[n>>2]|0)+ -1|0;c[l>>2]=gk;a[gk>>0]=0;el=c[l>>2]|0}else{c[l>>2]=ai;c[n>>2]=b+Gk+40;el=ai}Gk=el+1|0;c[l>>2]=Gk;cl=d[el>>0]|0;dl=Gk}}while(0);Nk=hk|(cl<<8|Zk)<<16;Ok=dl}Gk=Nk&nc;gk=Cg?Gk<<kg:Gk>>Bj;if(Ki){Gk=gk;lk=Aj;while(1){Ck=(gk>>lk)+Gk|0;lk=lk+Aj|0;if((lk|0)>=8){fl=Ck;break}else{Gk=Ck}}}else{fl=gk}Gk=dk+1|0;a[Lc+dk>>0]=fl;lk=Nk&mc;hk=ri?lk<<qi:lk>>zj;if(Ki){lk=hk;Ck=Aj;while(1){gl=(hk>>Ck)+lk|0;Ck=Ck+Aj|0;if((Ck|0)>=8){hl=gl;break}else{lk=gl}}}else{hl=hk}lk=dk+2|0;a[Lc+Gk>>0]=hl;Ck=Nk&lc;gk=dj?Ck<<ej:Ck>>xj;if(Ki){Ck=gk;gl=Aj;while(1){il=(gk>>gl)+Ck|0;gl=gl+Aj|0;if((gl|0)>=8){jl=il;break}else{Ck=il}}}else{jl=gk}Ck=dk+3|0;a[Lc+lk>>0]=jl;if(Pa){gl=Nk&kc;Gk=cj?gl<<fj:gl>>wj;if(Ki){gl=Gk;hk=Aj;while(1){il=(Gk>>hk)+gl|0;hk=hk+Aj|0;if((hk|0)>=8){kl=il;break}else{gl=il}}}else{kl=Gk}ll=kl&255}else{ll=-1}if(ij){a[Lc+Ck>>0]=ll;ml=dk+4|0}else{ml=Ck}if((ek|0)>=(c[b>>2]|0)){ck=ml;break e}fk=Ok;ek=ek+1|0;dk=ml}}}while(0);do{if((c[aj>>2]|0)==0){nl=c[l>>2]|0;s=1020}else{bk=c[n>>2]|0;dk=c[l>>2]|0;ek=bk-dk|0;if((ek|0)>=(uj|0)){nl=dk;s=1020;break}c[l>>2]=bk;Md[c[bj>>2]&63](c[pi>>2]|0,uj-ek|0)}}while(0);if((s|0)==1020){s=0;c[l>>2]=nl+uj}$j=$j+1|0;ek=c[p>>2]|0;if(($j|0)>=(ek|0)){$i=ek;break}else{ak=ck}}}}while(0);do{if(Ta){Pa=$i>>1;if((Pa|0)<=0){break}Oa=c[b>>2]|0;o=da(Oa,Kc)|0;q=(o|0)>0;Ha=0;do{ak=da(da(Ha,Kc)|0,Oa)|0;$j=da(da($i+~Ha|0,Kc)|0,Oa)|0;if(q){pi=0;do{bj=Lc+(pi+ak)|0;aj=a[bj>>0]|0;ij=Lc+(pi+$j)|0;a[bj>>0]=a[ij>>0]|0;a[ij>>0]=aj;pi=pi+1|0}while((pi|0)<(o|0))}Ha=Ha+1|0}while((Ha|0)<(Pa|0))}}while(0);do{if(Ua|(Kc|0)==(h|0)){ol=Lc}else{Ta=Lk(Lc,Kc,h,c[b>>2]|0,$i)|0;if((Ta|0)==0){Na=0}else{ol=Ta;break}i=j;return Na|0}}while(0);c[e>>2]=c[b>>2];c[f>>2]=c[p>>2];if((g|0)==0){Na=ol;i=j;return Na|0}c[g>>2]=c[oi>>2];Na=ol;i=j;return Na|0}}}while(0);c[6510]=29e3;Na=0;i=j;return Na|0}function Ok(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return b|0}function Pk(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0;g=i;if((f|0)>0){h=0}else{i=g;return b|0}do{a[b+h>>0]=((d[e+h>>0]|0)+2+((d[c+h>>0]|0)*3|0)|0)>>>2;h=h+1|0}while((h|0)!=(f|0));i=g;return b|0}function Qk(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0;g=i;e=a[c>>0]|0;if((f|0)==1){a[b+1>>0]=e;a[b>>0]=e;i=g;return b|0}a[b>>0]=e;a[b+1>>0]=((d[c+1>>0]|0)+2+((d[c>>0]|0)*3|0)|0)>>>2;e=f+ -1|0;if((e|0)>1){h=1;do{j=((d[c+h>>0]|0)*3|0)+2|0;k=h<<1;a[b+k>>0]=(j+(d[c+(h+ -1)>>0]|0)|0)>>>2;h=h+1|0;a[b+(k|1)>>0]=(j+(d[c+h>>0]|0)|0)>>>2}while((h|0)!=(e|0));l=e<<1}else{l=2}h=c+e|0;a[b+l>>0]=((d[h>>0]|0)+2+((d[c+(f+ -2)>>0]|0)*3|0)|0)>>>2;a[b+(l|1)>>0]=a[h>>0]|0;i=g;return b|0}function Rk(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0;g=i;h=((d[c>>0]|0)*3|0)+(d[e>>0]|0)|0;j=(h+2|0)>>>2&255;if((f|0)==1){a[b+1>>0]=j;a[b>>0]=j;i=g;return b|0}a[b>>0]=j;if((f|0)>1){j=1;k=h;while(1){l=((d[c+j>>0]|0)*3|0)+(d[e+j>>0]|0)|0;m=j<<1;a[b+(m+ -1)>>0]=((k*3|0)+8+l|0)>>>4;a[b+m>>0]=(k+8+(l*3|0)|0)>>>4;j=j+1|0;if((j|0)==(f|0)){n=l;break}else{k=l}}}else{n=h}a[b+((f<<1)+ -1)>>0]=(n+2|0)>>>2;i=g;return b|0}function Sk(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;d=i;if((e|0)<=0){i=d;return b|0}g=(f|0)>0;h=0;do{if(g){j=c+h|0;k=da(h,f)|0;l=0;do{a[b+(l+k)>>0]=a[j>>0]|0;l=l+1|0}while((l|0)!=(f|0))}h=h+1|0}while((h|0)!=(e|0));i=d;return b|0}function Tk(e,f,g,h,j){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;k=i;l=Vk(e,g)|0;if((l|0)<0){c[6510]=27720;m=0;i=k;return m|0}g=f+0|0;n=g+128|0;do{b[g>>1]=0;g=g+2|0}while((g|0)<(n|0));if((l|0)!=0){g=1<<l+ -1;n=e+13952|0;o=c[n>>2]|0;a:do{if((o|0)<(l|0)){p=e+13960|0;q=e+13948|0;b:while(1){c:do{if((c[p>>2]|0)==0){r=c[e>>2]|0;s=r+168|0;t=c[s>>2]|0;u=r+172|0;do{if(!(t>>>0<(c[u>>2]|0)>>>0)){v=r+32|0;if((c[v>>2]|0)==0){w=0;break c}x=r+40|0;y=Fd[c[r+16>>2]&15](c[r+28>>2]|0,x,c[r+36>>2]|0)|0;if((y|0)==0){c[v>>2]=0;v=(c[u>>2]|0)+ -1|0;c[s>>2]=v;a[v>>0]=0;z=c[s>>2]|0;break}else{c[s>>2]=x;c[u>>2]=r+y+40;z=x;break}}else{z=t}}while(0);c[s>>2]=z+1;t=a[z>>0]|0;if(!(t<<24>>24==-1)){w=t&255;break}t=c[e>>2]|0;r=t+168|0;u=c[r>>2]|0;x=t+172|0;do{if(!(u>>>0<(c[x>>2]|0)>>>0)){y=t+32|0;if((c[y>>2]|0)==0){w=255;break c}v=t+40|0;A=Fd[c[t+16>>2]&15](c[t+28>>2]|0,v,c[t+36>>2]|0)|0;if((A|0)==0){c[y>>2]=0;y=(c[x>>2]|0)+ -1|0;c[r>>2]=y;a[y>>0]=0;B=c[r>>2]|0;break}else{c[r>>2]=v;c[x>>2]=t+A+40;B=v;break}}else{B=u}}while(0);c[r>>2]=B+1;C=a[B>>0]|0;if(C<<24>>24==0){w=255}else{break b}}else{w=0}}while(0);u=c[n>>2]|0;c[q>>2]=w<<24-u|c[q>>2];t=u+8|0;c[n>>2]=t;if((t|0)>=25){D=q;E=t;break a}}a[e+13956>>0]=C;c[p>>2]=1;D=q;E=c[n>>2]|0}else{D=e+13948|0;E=o}}while(0);o=c[D>>2]|0;C=o<<l|o>>>(32-l|0);o=c[29136+(l<<2)>>2]|0;c[D>>2]=C&~o;D=C&o;c[n>>2]=E-l;if(D>>>0<g>>>0){F=n;G=(-1<<l)+1+D|0}else{F=n;G=D}}else{F=e+13952|0;G=0}D=e+(j*56|0)+13748|0;j=(c[D>>2]|0)+G|0;c[D>>2]=j;b[f>>1]=j;j=e+13960|0;D=e+13948|0;G=e+13956|0;n=1;while(1){l=Vk(e,h)|0;if((l|0)<0){H=28;break}g=l&15;if((g|0)==0){if((l|0)!=240){m=1;H=53;break}I=n+16|0}else{E=(l>>4)+n|0;l=1<<g+ -1;o=c[F>>2]|0;d:do{if((o|0)<(g|0)){e:while(1){f:do{if((c[j>>2]|0)==0){C=c[e>>2]|0;w=C+168|0;B=c[w>>2]|0;z=C+172|0;do{if(!(B>>>0<(c[z>>2]|0)>>>0)){t=C+32|0;if((c[t>>2]|0)==0){J=0;break f}u=C+40|0;x=Fd[c[C+16>>2]&15](c[C+28>>2]|0,u,c[C+36>>2]|0)|0;if((x|0)==0){c[t>>2]=0;t=(c[z>>2]|0)+ -1|0;c[w>>2]=t;a[t>>0]=0;K=c[w>>2]|0;break}else{c[w>>2]=u;c[z>>2]=C+x+40;K=u;break}}else{K=B}}while(0);c[w>>2]=K+1;B=a[K>>0]|0;if(!(B<<24>>24==-1)){J=B&255;break}B=c[e>>2]|0;C=B+168|0;z=c[C>>2]|0;u=B+172|0;do{if(!(z>>>0<(c[u>>2]|0)>>>0)){x=B+32|0;if((c[x>>2]|0)==0){J=255;break f}t=B+40|0;s=Fd[c[B+16>>2]&15](c[B+28>>2]|0,t,c[B+36>>2]|0)|0;if((s|0)==0){c[x>>2]=0;x=(c[u>>2]|0)+ -1|0;c[C>>2]=x;a[x>>0]=0;L=c[C>>2]|0;break}else{c[C>>2]=t;c[u>>2]=B+s+40;L=t;break}}else{L=z}}while(0);c[C>>2]=L+1;M=a[L>>0]|0;if(M<<24>>24==0){J=255}else{break e}}else{J=0}}while(0);r=c[F>>2]|0;c[D>>2]=J<<24-r|c[D>>2];z=r+8|0;c[F>>2]=z;if((z|0)>=25){N=z;break d}}a[G>>0]=M;c[j>>2]=1;N=c[F>>2]|0}else{N=o}}while(0);o=c[D>>2]|0;q=o<<g|o>>>(32-g|0);o=c[29136+(g<<2)>>2]|0;c[D>>2]=q&~o;p=q&o;c[F>>2]=N-g;if(p>>>0<l>>>0){O=(-1<<g)+1+p|0}else{O=p}b[f+((d[27176+E>>0]|0)<<1)>>1]=O;I=E+1|0}if((I|0)<64){n=I}else{m=1;H=53;break}}if((H|0)==28){c[6510]=27720;m=0;i=k;return m|0}else if((H|0)==53){i=k;return m|0}return 0}function Uk(e,f,g,h){e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;j=i;i=i+256|0;k=j;l=g;g=h;h=0;m=k;while(1){n=b[l+16>>1]|0;o=b[l+32>>1]|0;if((n|o)<<16>>16==0){if(((((b[l+48>>1]|0)==0?(b[l+64>>1]|0)==0:0)?(b[l+80>>1]|0)==0:0)?(b[l+96>>1]|0)==0:0)?(b[l+112>>1]|0)==0:0){p=da(b[l>>1]<<2,d[g>>0]|0)|0;c[m+224>>2]=p;c[m+192>>2]=p;c[m+160>>2]=p;c[m+128>>2]=p;c[m+96>>2]=p;c[m+64>>2]=p;c[m+32>>2]=p;c[m>>2]=p}else{q=0;r=9}}else{q=o;r=9}if((r|0)==9){r=0;o=da(d[g+16>>0]|0,q<<16>>16)|0;p=da(d[g+48>>0]|0,b[l+96>>1]|0)|0;s=(p+o|0)*2217|0;t=s+(da(p,-7567)|0)|0;p=s+(o*3135|0)|0;o=da(d[g>>0]|0,b[l>>1]|0)|0;s=da(d[g+32>>0]|0,b[l+64>>1]|0)|0;u=s+o<<12;v=o-s<<12;s=da(d[g+56>>0]|0,b[l+112>>1]|0)|0;o=da(d[g+40>>0]|0,b[l+80>>1]|0)|0;w=da(d[g+24>>0]|0,b[l+48>>1]|0)|0;x=da(d[g+8>>0]|0,n<<16>>16)|0;n=w+s|0;y=x+o|0;z=(y+n|0)*4816|0;A=z+(da(x+s|0,-3685)|0)|0;B=z+(da(w+o|0,-10497)|0)|0;z=da(n,-8034)|0;n=da(y,-1597)|0;y=n+(x*6149|0)+A|0;x=z+(w*12586|0)+B|0;w=n+(o*8410|0)+B|0;B=z+(s*1223|0)+A|0;A=p+512+u|0;s=t+512+v|0;z=v-t+512|0;t=u-p+512|0;c[m>>2]=y+A>>10;c[m+224>>2]=A-y>>10;c[m+32>>2]=x+s>>10;c[m+192>>2]=s-x>>10;c[m+64>>2]=w+z>>10;c[m+160>>2]=z-w>>10;c[m+96>>2]=B+t>>10;c[m+128>>2]=t-B>>10}h=h+1|0;if((h|0)==8){C=0;D=e;E=k;break}else{l=l+2|0;g=g+1|0;m=m+4|0}}while(1){m=c[E+8>>2]|0;g=c[E+24>>2]|0;l=(g+m|0)*2217|0;k=l+(da(g,-7567)|0)|0;g=l+(m*3135|0)|0;m=c[E>>2]|0;l=c[E+16>>2]|0;e=l+m<<12;h=m-l<<12;l=c[E+28>>2]|0;m=c[E+20>>2]|0;q=c[E+12>>2]|0;r=c[E+4>>2]|0;B=q+l|0;t=r+m|0;w=(t+B|0)*4816|0;z=w+(da(r+l|0,-3685)|0)|0;x=w+(da(q+m|0,-10497)|0)|0;w=da(B,-8034)|0;B=da(t,-1597)|0;t=B+(r*6149|0)+z|0;r=w+(q*12586|0)+x|0;q=B+(m*8410|0)+x|0;x=w+(l*1223|0)+z|0;z=g+16842752+e|0;l=k+16842752+h|0;w=h-k+16842752|0;k=e-g+16842752|0;g=t+z|0;e=g>>17;if(e>>>0>255){F=~(g>>31&255)}else{F=e&255}a[D>>0]=F;e=z-t|0;t=e>>17;if(t>>>0>255){G=~(e>>31&255)}else{G=t&255}a[D+7>>0]=G;t=r+l|0;e=t>>17;if(e>>>0>255){H=~(t>>31&255)}else{H=e&255}a[D+1>>0]=H;e=l-r|0;r=e>>17;if(r>>>0>255){I=~(e>>31&255)}else{I=r&255}a[D+6>>0]=I;r=q+w|0;e=r>>17;if(e>>>0>255){J=~(r>>31&255)}else{J=e&255}a[D+2>>0]=J;e=w-q|0;q=e>>17;if(q>>>0>255){K=~(e>>31&255)}else{K=q&255}a[D+5>>0]=K;q=x+k|0;e=q>>17;if(e>>>0>255){L=~(q>>31&255)}else{L=e&255}a[D+3>>0]=L;e=k-x|0;x=e>>17;if(x>>>0>255){M=~(e>>31&255)}else{M=x&255}a[D+4>>0]=M;C=C+1|0;if((C|0)==8){break}else{D=D+f|0;E=E+32|0}}i=j;return}function Vk(b,f){b=b|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;g=i;h=b+13952|0;a:do{if((c[h>>2]|0)<16){j=b+13960|0;k=b+13948|0;b:while(1){c:do{if((c[j>>2]|0)==0){l=c[b>>2]|0;m=l+168|0;n=c[m>>2]|0;o=l+172|0;do{if(!(n>>>0<(c[o>>2]|0)>>>0)){p=l+32|0;if((c[p>>2]|0)==0){q=0;break c}r=l+40|0;s=Fd[c[l+16>>2]&15](c[l+28>>2]|0,r,c[l+36>>2]|0)|0;if((s|0)==0){c[p>>2]=0;p=(c[o>>2]|0)+ -1|0;c[m>>2]=p;a[p>>0]=0;t=c[m>>2]|0;break}else{c[m>>2]=r;c[o>>2]=l+s+40;t=r;break}}else{t=n}}while(0);c[m>>2]=t+1;n=a[t>>0]|0;if(!(n<<24>>24==-1)){q=n&255;break}n=c[b>>2]|0;l=n+168|0;o=c[l>>2]|0;r=n+172|0;do{if(!(o>>>0<(c[r>>2]|0)>>>0)){s=n+32|0;if((c[s>>2]|0)==0){q=255;break c}p=n+40|0;u=Fd[c[n+16>>2]&15](c[n+28>>2]|0,p,c[n+36>>2]|0)|0;if((u|0)==0){c[s>>2]=0;s=(c[r>>2]|0)+ -1|0;c[l>>2]=s;a[s>>0]=0;v=c[l>>2]|0;break}else{c[l>>2]=p;c[r>>2]=n+u+40;v=p;break}}else{v=o}}while(0);c[l>>2]=v+1;w=a[v>>0]|0;if(w<<24>>24==0){q=255}else{break b}}else{q=0}}while(0);o=c[h>>2]|0;c[k>>2]=q<<24-o|c[k>>2];n=o+8|0;c[h>>2]=n;if((n|0)>=25){x=k;break a}}a[b+13956>>0]=w;c[j>>2]=1;x=k}else{x=b+13948|0}}while(0);b=c[x>>2]|0;w=a[f+(b>>>23)>>0]|0;q=w&255;if(!(w<<24>>24==-1)){w=d[f+q+1280>>0]|0;v=c[h>>2]|0;if((w|0)>(v|0)){y=-1;i=g;return y|0}c[x>>2]=b<<w;c[h>>2]=v-w;y=d[f+q+1024>>0]|0;i=g;return y|0}q=b>>>16;w=10;while(1){if(q>>>0<(c[f+(w<<2)+1540>>2]|0)>>>0){break}else{w=w+1|0}}q=c[h>>2]|0;if((w|0)==17){c[h>>2]=q+ -16;y=-1;i=g;return y|0}if((w|0)>(q|0)){y=-1;i=g;return y|0}v=(b>>>(32-w|0)&c[29136+(w<<2)>>2])+(c[f+(w<<2)+1612>>2]|0)|0;t=d[f+v+1280>>0]|0;if((b>>>(32-t|0)&c[29136+(t<<2)>>2]|0)!=(e[f+(v<<1)+512>>1]|0|0)){Ga(29208,26544,775,29288)}c[h>>2]=q-w;c[x>>2]=b<<w;y=d[f+v+1024>>0]|0;i=g;return y|0}function Wk(a){a=a|0;var b=0,c=0;b=i;c=Nl(a,1)|0;i=b;return c|0}function Xk(a){a=a|0;var b=0;b=i;Ml(a);i=b;return}function Yk(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;if((a[b>>0]|0)==47){g=b}else{g=$j(b)|0}if((e|0)<0){h=Jc(g|0,29376)|0}else{h=Jc(g|0,29384)|0}if((h|0)==0){j=-1;i=f;return j|0}if((e|0)>-1){uc(h|0,e|0,0)|0}e=Rb(c|0,1,d|0,h|0)|0;wc(h|0)|0;j=e;i=f;return j|0}function Zk(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;if((a[c>>0]|0)==0){e=0;i=d;return e|0}f=a[b>>0]|0;if(f<<24>>24==0){e=0;i=d;return e|0}else{g=f;h=b}a:while(1){b=h;f=c;while(1){j=a[f>>0]|0;if(j<<24>>24==0){e=h;k=11;break a}l=a[b>>0]|0;if(!(l<<24>>24!=0?j<<24>>24==l<<24>>24:0)){break}b=b+1|0;f=f+1|0}f=h+1|0;if(g<<24>>24<0){b=f;while(1){l=a[b>>0]|0;if(l<<24>>24!=0&(l&-64)<<24>>24==-128){b=b+1|0}else{m=l;n=b;break}}}else{m=a[f>>0]|0;n=f}if(m<<24>>24==0){e=0;k=11;break}else{g=m;h=n}}if((k|0)==11){i=d;return e|0}return 0}function _k(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;e=a[b>>0]|0;if(e<<24>>24==0){f=0;i=d;return f|0}g=c<<24>>24;c=e&255;e=b;b=0;while(1){h=(c|0)==(g|0)?e:b;j=e+1|0;if((c&128|0)==0){k=a[j>>0]|0;l=j}else{m=j;while(1){j=a[m>>0]|0;if(j<<24>>24!=0&(j&-64)<<24>>24==-128){m=m+1|0}else{k=j;l=m;break}}}if(k<<24>>24==0){f=h;break}else{c=k&255;e=l;b=h}}i=d;return f|0}



function wk(e,f,h,j,k){e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Yc=0,Zc=0,_c=0,$c=0,ad=0,bd=0,cd=0,dd=0,ed=0,fd=0,gd=0,hd=0,id=0,jd=0,kd=0,ld=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0,yd=0,zd=0,Ad=0,Bd=0,Cd=0,Dd=0,Ed=0,Gd=0,Hd=0,Id=0,Jd=0,Kd=0,Ld=0,Od=0,Pd=0,Qd=0,Rd=0,Sd=0,Ud=0,Vd=0,Wd=0,Xd=0,Yd=0,Zd=0,_d=0,$d=0,ae=0,be=0,ce=0,de=0,ee=0,fe=0,ge=0,he=0,ie=0,je=0,ke=0,le=0,me=0,ne=0,oe=0,pe=0,qe=0,re=0,se=0,te=0,ue=0,ve=0,we=0,xe=0,ye=0,ze=0,Ae=0,Be=0,Ce=0,De=0,Ee=0,Fe=0,Ge=0,He=0,Ie=0,Je=0,Ke=0,Le=0,Me=0,Ne=0,Oe=0,Pe=0,Qe=0,Re=0,Se=0,Te=0,Ue=0,Ve=0,We=0,Xe=0,Ye=0,Ze=0,_e=0,$e=0,af=0,bf=0,cf=0,df=0,ef=0,ff=0,gf=0,hf=0,jf=0,kf=0,lf=0,mf=0,nf=0,of=0,pf=0,qf=0,rf=0,sf=0,tf=0,uf=0,vf=0,wf=0,xf=0,yf=0,zf=0,Af=0,Bf=0,Cf=0,Df=0,Ef=0,Ff=0,Gf=0,Hf=0,If=0,Jf=0,Kf=0,Lf=0,Mf=0,Nf=0,Of=0,Pf=0,Qf=0,Rf=0,Sf=0,Tf=0,Uf=0,Vf=0,Wf=0,Xf=0,Yf=0,Zf=0,_f=0,$f=0,ag=0,bg=0,cg=0,dg=0,eg=0,fg=0,gg=0,hg=0,ig=0,jg=0,kg=0,lg=0,mg=0,ng=0,og=0,pg=0,qg=0,rg=0,sg=0,tg=0,ug=0,vg=0,wg=0,xg=0,yg=0,zg=0,Ag=0,Bg=0,Cg=0,Dg=0,Eg=0,Fg=0,Gg=0,Hg=0,Ig=0,Jg=0,Kg=0,Lg=0,Mg=0,Ng=0,Og=0,Pg=0,Qg=0,Rg=0,Sg=0,Tg=0,Ug=0,Vg=0,Wg=0,Xg=0,Yg=0,Zg=0,_g=0,$g=0,ah=0,bh=0,ch=0,dh=0,eh=0,fh=0,gh=0,hh=0,ih=0,jh=0,kh=0,lh=0,mh=0,nh=0,oh=0,ph=0,qh=0,rh=0,sh=0,th=0,uh=0,vh=0,wh=0,xh=0,yh=0,zh=0,Ah=0,Bh=0,Ch=0,Dh=0,Eh=0,Fh=0,Gh=0,Hh=0,Ih=0,Jh=0,Kh=0,Lh=0,Mh=0,Nh=0,Oh=0,Ph=0,Qh=0,Rh=0,Sh=0,Th=0,Uh=0,Vh=0,Wh=0,Xh=0,Yh=0,Zh=0,_h=0,$h=0,ai=0,bi=0,ci=0,di=0,ei=0,fi=0,gi=0,hi=0,ii=0,ji=0,ki=0,li=0,mi=0,ni=0,oi=0,pi=0,qi=0,ri=0,si=0,ti=0,ui=0,vi=0,wi=0,xi=0,yi=0,zi=0,Ai=0,Bi=0,Ci=0,Di=0,Ei=0,Fi=0,Gi=0,Hi=0,Ii=0,Ji=0,Ki=0,Li=0,Mi=0,Ni=0,Oi=0,Pi=0,Qi=0,Ri=0,Si=0,Ti=0,Ui=0,Vi=0,Wi=0,Xi=0,Yi=0,Zi=0,_i=0,$i=0,aj=0,bj=0,cj=0,dj=0,ej=0,fj=0,gj=0,hj=0,ij=0,jj=0,kj=0,lj=0,mj=0,nj=0,oj=0,pj=0,qj=0,rj=0,sj=0,tj=0,uj=0,vj=0,wj=0,xj=0,yj=0,zj=0,Aj=0,Bj=0,Cj=0,Dj=0,Ej=0,Fj=0,Gj=0,Hj=0,Ij=0,Jj=0,Kj=0,Lj=0,Mj=0,Nj=0,Oj=0,Pj=0,Qj=0,Rj=0,Sj=0,Tj=0,Uj=0,Vj=0,Wj=0,Xj=0,Yj=0,Zj=0,_j=0,$j=0,ak=0,bk=0,ck=0,dk=0,ek=0,fk=0,gk=0,hk=0,ik=0,jk=0,kk=0,lk=0,mk=0,nk=0,ok=0,pk=0,qk=0,rk=0,sk=0,tk=0,uk=0,vk=0,wk=0,xk=0,zk=0,Ak=0,Bk=0,Ck=0,Fk=0,Ik=0,Jk=0,Kk=0,Ok=0,Pk=0,Qk=0,Rk=0,Sk=0,Vk=0,Wk=0,Xk=0,Yk=0,Zk=0,_k=0,$k=0,al=0,bl=0,cl=0,dl=0,el=0,fl=0.0,gl=0.0,hl=0.0,il=0.0,jl=0,kl=0,ll=0,ml=0,nl=0,ol=0,pl=0,ql=0,rl=0,sl=0,tl=0,ul=0,vl=0,wl=0,xl=0,yl=0,zl=0,Al=0,Bl=0,Cl=0,Dl=0,El=0,Fl=0,Gl=0,Hl=0,Il=0,Jl=0,Kl=0,Nl=0,Ol=0,Pl=0,Ql=0,Rl=0,Sl=0,Tl=0,Ul=0,Vl=0,Wl=0,Xl=0,Yl=0,Zl=0,_l=0,$l=0,am=0,bm=0,cm=0,dm=0,em=0,fm=0,gm=0,hm=0,im=0,jm=0,km=0,lm=0,mm=0,nm=0,om=0,pm=0,qm=0,rm=0,sm=0,tm=0,um=0,vm=0,wm=0,xm=0,ym=0,zm=0,Am=0,Bm=0,Cm=0,Dm=0,Em=0,Fm=0,Gm=0,Hm=0,Im=0,Jm=0,Km=0,Lm=0,Nm=0,Pm=0,Qm=0,Rm=0,Sm=0,Tm=0,Um=0,Vm=0,Wm=0,Xm=0,Ym=0,Zm=0,_m=0,$m=0,an=0,bn=0,cn=0,dn=0,en=0,fn=0,gn=0,hn=0,jn=0,kn=0,ln=0,mn=0,nn=0,on=0,pn=0,qn=0,rn=0,sn=0,tn=0,un=0,vn=0,wn=0,xn=0,yn=0,zn=0,An=0,Bn=0,Cn=0,Dn=0,En=0,Fn=0,Gn=0,Hn=0,In=0,Jn=0,Kn=0,Ln=0,Mn=0,Nn=0,On=0,Pn=0,Qn=0,Rn=0,Sn=0,Tn=0,Un=0,Vn=0,Wn=0,Xn=0,Yn=0,Zn=0,_n=0,$n=0,ao=0,bo=0,co=0,eo=0,fo=0,go=0,ho=0,io=0,jo=0,ko=0,lo=0,mo=0,no=0,oo=0,po=0,qo=0,ro=0,so=0,to=0,uo=0;l=i;i=i+32928|0;m=l+14152|0;n=l+32920|0;o=l+13992|0;p=l+32792|0;q=l+32664|0;r=l+14136|0;s=l+14008|0;t=l;c[m>>2]=e;u=Gk(m,1)|0;v=e+176|0;w=c[v>>2]|0;x=e+168|0;c[x>>2]=w;if((u|0)!=0){c[t>>2]=e;if(k>>>0>4){c[6510]=29120;y=0;i=l;return y|0}c[e+8>>2]=0;u=t+13984|0;c[u>>2]=0;a:do{if((Gk(t,0)|0)!=0){z=t+13956|0;A=a[z>>0]|0;b:do{if(A<<24>>24==-1){B=c[t>>2]|0;C=B+168|0;D=c[C>>2]|0;E=B+172|0;do{if(!(D>>>0<(c[E>>2]|0)>>>0)){F=B+32|0;if((c[F>>2]|0)==0){G=-1;break b}H=B+40|0;I=Fd[c[B+16>>2]&15](c[B+28>>2]|0,H,c[B+36>>2]|0)|0;if((I|0)==0){c[F>>2]=0;F=(c[E>>2]|0)+ -1|0;c[C>>2]=F;a[F>>0]=0;J=c[C>>2]|0;break}else{c[C>>2]=H;c[E>>2]=B+I+40;J=H;break}}else{J=D}}while(0);c[C>>2]=J+1;if((a[J>>0]|0)==-1){do{D=c[t>>2]|0;B=D+168|0;E=c[B>>2]|0;H=D+172|0;if(!(E>>>0<(c[H>>2]|0)>>>0)){I=D+32|0;if((c[I>>2]|0)==0){K=0}else{F=D+40|0;L=Fd[c[D+16>>2]&15](c[D+28>>2]|0,F,c[D+36>>2]|0)|0;if((L|0)==0){c[I>>2]=0;I=(c[H>>2]|0)+ -1|0;c[B>>2]=I;a[I>>0]=0;M=c[B>>2]|0}else{c[B>>2]=F;c[H>>2]=D+L+40;M=F}c[B>>2]=M+1;K=d[M>>0]|0}}else{c[B>>2]=E+1;K=d[E>>0]|0}E=K&255}while(E<<24>>24==-1);G=E}else{G=-1}}else{a[z>>0]=-1;G=A}}while(0);A=t+13964|0;C=t+13952|0;E=t+13948|0;B=t+13960|0;F=t+13860|0;L=t+13804|0;D=t+13748|0;H=t+13988|0;I=t+13968|0;N=t+13712|0;O=t+13708|0;P=G;c:while(1){Q=P&255;d:do{if((Q|0)==218){R=c[t>>2]|0;S=R+168|0;T=c[S>>2]|0;V=R+172|0;W=c[V>>2]|0;if(!(T>>>0<W>>>0)){X=R+32|0;if((c[X>>2]|0)==0){Y=0;Z=T;_=W}else{$=R+40|0;aa=Fd[c[R+16>>2]&15](c[R+28>>2]|0,$,c[R+36>>2]|0)|0;if((aa|0)==0){c[X>>2]=0;X=(c[V>>2]|0)+ -1|0;c[S>>2]=X;a[X>>0]=0;ba=c[V>>2]|0;ca=c[S>>2]|0}else{c[S>>2]=$;X=R+aa+40|0;c[V>>2]=X;ba=X;ca=$}$=ca+1|0;c[S>>2]=$;Y=d[ca>>0]|0;Z=$;_=ba}}else{$=T+1|0;c[S>>2]=$;Y=d[T>>0]|0;Z=$;_=W}W=Y<<8;if(!(Z>>>0<_>>>0)){$=R+32|0;if((c[$>>2]|0)==0){ea=0}else{T=R+40|0;X=Fd[c[R+16>>2]&15](c[R+28>>2]|0,T,c[R+36>>2]|0)|0;if((X|0)==0){c[$>>2]=0;$=(c[V>>2]|0)+ -1|0;c[S>>2]=$;a[$>>0]=0;fa=c[S>>2]|0}else{c[S>>2]=T;c[V>>2]=R+X+40;fa=T}c[S>>2]=fa+1;ea=d[fa>>0]|0}}else{c[S>>2]=Z+1;ea=d[Z>>0]|0}S=ea|W;W=c[t>>2]|0;T=W+168|0;X=c[T>>2]|0;R=W+172|0;do{if(!(X>>>0<(c[R>>2]|0)>>>0)){V=W+32|0;if((c[V>>2]|0)==0){ga=39;break c}$=W+40|0;aa=Fd[c[W+16>>2]&15](c[W+28>>2]|0,$,c[W+36>>2]|0)|0;if((aa|0)==0){c[V>>2]=0;V=(c[R>>2]|0)+ -1|0;c[T>>2]=V;a[V>>0]=0;ha=c[T>>2]|0;break}else{c[T>>2]=$;c[R>>2]=W+aa+40;ha=$;break}}else{ha=X}}while(0);c[T>>2]=ha+1;X=a[ha>>0]|0;W=X&255;c[A>>2]=W;if(X<<24>>24==0|(X&255)>4){break c}X=c[t>>2]|0;if((W|0)>(c[X+8>>2]|0)){break c}if((S|0)==((W<<1)+6|0)){ia=W;ja=X;ka=0}else{ga=47;break c}while(1){X=(ka|0)<(ia|0);W=ja+168|0;R=c[W>>2]|0;$=ja+172|0;if(!(R>>>0<(c[$>>2]|0)>>>0)){aa=ja+32|0;if((c[aa>>2]|0)==0){la=0}else{V=ja+40|0;ma=Fd[c[ja+16>>2]&15](c[ja+28>>2]|0,V,c[ja+36>>2]|0)|0;if((ma|0)==0){c[aa>>2]=0;aa=(c[$>>2]|0)+ -1|0;c[W>>2]=aa;a[aa>>0]=0;na=c[W>>2]|0}else{c[W>>2]=V;c[$>>2]=ja+ma+40;na=V}c[W>>2]=na+1;la=d[na>>0]|0}}else{c[W>>2]=R+1;la=d[R>>0]|0}if(!X){break}X=c[t>>2]|0;R=X+168|0;W=c[R>>2]|0;V=X+172|0;if(!(W>>>0<(c[V>>2]|0)>>>0)){ma=X+32|0;if((c[ma>>2]|0)==0){oa=0}else{$=X+40|0;aa=Fd[c[X+16>>2]&15](c[X+28>>2]|0,$,c[X+36>>2]|0)|0;if((aa|0)==0){c[ma>>2]=0;ma=(c[V>>2]|0)+ -1|0;c[R>>2]=ma;a[ma>>0]=0;pa=c[R>>2]|0}else{c[R>>2]=$;c[V>>2]=X+aa+40;pa=$}c[R>>2]=pa+1;oa=d[pa>>0]|0}}else{c[R>>2]=W+1;oa=d[W>>0]|0}W=c[(c[t>>2]|0)+8>>2]|0;e:do{if((W|0)>0){R=0;while(1){$=R+1|0;if((c[t+(R*56|0)+13724>>2]|0)==(la|0)){qa=R;break e}if(($|0)<(W|0)){R=$}else{qa=$;break}}}else{qa=0}}while(0);if((qa|0)==(W|0)){break a}c[t+(qa*56|0)+13740>>2]=oa>>>4;if(oa>>>0>63){ga=68;break c}R=oa&15;c[t+(qa*56|0)+13744>>2]=R;if(R>>>0>3){ga=70;break c}c[t+(ka<<2)+13968>>2]=qa;ia=c[A>>2]|0;ja=c[t>>2]|0;ka=ka+1|0}if((la|0)!=0){ga=73;break c}S=c[t>>2]|0;T=S+168|0;R=c[T>>2]|0;$=S+172|0;if(!(R>>>0<(c[$>>2]|0)>>>0)){aa=S+32|0;if((c[aa>>2]|0)!=0){X=S+40|0;V=Fd[c[S+16>>2]&15](c[S+28>>2]|0,X,c[S+36>>2]|0)|0;if((V|0)==0){c[aa>>2]=0;aa=(c[$>>2]|0)+ -1|0;c[T>>2]=aa;a[aa>>0]=0;ra=c[T>>2]|0}else{c[T>>2]=X;c[$>>2]=S+V+40;ra=X}c[T>>2]=ra+1}}else{c[T>>2]=R+1}R=c[t>>2]|0;T=R+168|0;X=c[T>>2]|0;V=R+172|0;do{if(!(X>>>0<(c[V>>2]|0)>>>0)){S=R+32|0;if((c[S>>2]|0)!=0){$=R+40|0;aa=Fd[c[R+16>>2]&15](c[R+28>>2]|0,$,c[R+36>>2]|0)|0;if((aa|0)==0){c[S>>2]=0;S=(c[V>>2]|0)+ -1|0;c[T>>2]=S;a[S>>0]=0;sa=c[T>>2]|0;ga=86;break}else{c[T>>2]=$;c[V>>2]=R+aa+40;sa=$;ga=86;break}}}else{sa=X;ga=86}}while(0);if((ga|0)==86?(ga=0,c[T>>2]=sa+1,(a[sa>>0]|0)!=0):0){ga=87;break c}c[C>>2]=0;c[E>>2]=0;c[B>>2]=0;c[F>>2]=0;c[L>>2]=0;c[D>>2]=0;a[z>>0]=-1;X=c[u>>2]|0;R=(X|0)==0?2147483647:X;c[H>>2]=R;f:do{if((c[A>>2]|0)==1){X=c[I>>2]|0;V=(c[t+(X*56|0)+13752>>2]|0)+7>>3;$=(c[t+(X*56|0)+13756>>2]|0)+7>>3;if(($|0)>0){aa=(V|0)>0;S=t+(X*56|0)+13740|0;ma=t+(X*56|0)+13744|0;ta=t+(X*56|0)+13768|0;ua=t+(X*56|0)+13760|0;va=t+(X*56|0)+13736|0;wa=0;while(1){if(aa){xa=0;do{if((Tk(t,p,t+((c[S>>2]|0)*1680|0)+4|0,t+((c[ma>>2]|0)*1680|0)+6724|0,X)|0)==0){break a}ya=c[ua>>2]|0;za=(c[ta>>2]|0)+((da(ya,wa)|0)+xa<<3)|0;Uk(za,ya,p,t+(c[va>>2]<<6)+13444|0);ya=c[H>>2]|0;c[H>>2]=ya+ -1;if((ya|0)<2){g:do{if((c[C>>2]|0)<24){h:while(1){i:do{if((c[B>>2]|0)==0){ya=c[t>>2]|0;za=ya+168|0;Aa=c[za>>2]|0;Ba=ya+172|0;do{if(!(Aa>>>0<(c[Ba>>2]|0)>>>0)){Ca=ya+32|0;if((c[Ca>>2]|0)==0){Da=0;break i}Ea=ya+40|0;Fa=Fd[c[ya+16>>2]&15](c[ya+28>>2]|0,Ea,c[ya+36>>2]|0)|0;if((Fa|0)==0){c[Ca>>2]=0;Ca=(c[Ba>>2]|0)+ -1|0;c[za>>2]=Ca;a[Ca>>0]=0;Ga=c[za>>2]|0;break}else{c[za>>2]=Ea;c[Ba>>2]=ya+Fa+40;Ga=Ea;break}}else{Ga=Aa}}while(0);c[za>>2]=Ga+1;Aa=a[Ga>>0]|0;if(!(Aa<<24>>24==-1)){Da=Aa&255;break}Aa=c[t>>2]|0;ya=Aa+168|0;Ba=c[ya>>2]|0;Ea=Aa+172|0;do{if(!(Ba>>>0<(c[Ea>>2]|0)>>>0)){Fa=Aa+32|0;if((c[Fa>>2]|0)==0){Da=255;break i}Ca=Aa+40|0;Ha=Fd[c[Aa+16>>2]&15](c[Aa+28>>2]|0,Ca,c[Aa+36>>2]|0)|0;if((Ha|0)==0){c[Fa>>2]=0;Fa=(c[Ea>>2]|0)+ -1|0;c[ya>>2]=Fa;a[Fa>>0]=0;Ia=c[ya>>2]|0;break}else{c[ya>>2]=Ca;c[Ea>>2]=Aa+Ha+40;Ia=Ca;break}}else{Ia=Ba}}while(0);c[ya>>2]=Ia+1;Ja=a[Ia>>0]|0;if(Ja<<24>>24==0){Da=255}else{break h}}else{Da=0}}while(0);Ba=c[C>>2]|0;c[E>>2]=Da<<24-Ba|c[E>>2];Aa=Ba+8|0;c[C>>2]=Aa;if((Aa|0)>=25){break g}}a[z>>0]=Ja;c[B>>2]=1}}while(0);Aa=a[z>>0]|0;if(!((Aa+48<<24>>24&255)<8)){Ka=Aa;break f}c[C>>2]=0;c[E>>2]=0;c[B>>2]=0;c[F>>2]=0;c[L>>2]=0;c[D>>2]=0;a[z>>0]=-1;Aa=c[u>>2]|0;c[H>>2]=(Aa|0)==0?2147483647:Aa}xa=xa+1|0}while((xa|0)<(V|0))}wa=wa+1|0;if((wa|0)>=($|0)){ga=151;break}}}else{ga=151}}else{$=c[N>>2]|0;if(($|0)>0){wa=c[O>>2]|0;V=R;va=$;$=0;while(1){if((wa|0)>0){ta=V;ua=0;while(1){X=c[A>>2]|0;if((X|0)>0){ma=X;X=0;while(1){S=c[t+(X<<2)+13968>>2]|0;aa=t+(S*56|0)+13732|0;W=c[aa>>2]|0;if((W|0)>0){xa=t+(S*56|0)+13728|0;Aa=t+(S*56|0)+13740|0;Ba=t+(S*56|0)+13744|0;Ea=t+(S*56|0)+13768|0;za=t+(S*56|0)+13760|0;Ca=t+(S*56|0)+13736|0;Ha=c[xa>>2]|0;Fa=W;W=0;while(1){if((Ha|0)>0){La=Fa;Ma=Ha;Na=0;while(1){if((Tk(t,q,t+((c[Aa>>2]|0)*1680|0)+4|0,t+((c[Ba>>2]|0)*1680|0)+6724|0,S)|0)==0){break a}Oa=(da(La,$)|0)+W|0;Pa=(da(Ma,ua)|0)+Na|0;Qa=c[za>>2]|0;Ra=(c[Ea>>2]|0)+(Pa+(da(Qa,Oa)|0)<<3)|0;Uk(Ra,Qa,q,t+(c[Ca>>2]<<6)+13444|0);Na=Na+1|0;Qa=c[xa>>2]|0;Ra=c[aa>>2]|0;if((Na|0)>=(Qa|0)){Sa=Ra;Ta=Qa;break}else{La=Ra;Ma=Qa}}}else{Sa=Fa;Ta=Ha}W=W+1|0;if((W|0)>=(Sa|0)){break}else{Ha=Ta;Fa=Sa}}Ua=c[A>>2]|0}else{Ua=ma}X=X+1|0;if((X|0)>=(Ua|0)){break}else{ma=Ua}}Va=c[H>>2]|0}else{Va=ta}ma=Va+ -1|0;c[H>>2]=ma;if((Va|0)<2){j:do{if((c[C>>2]|0)<24){k:while(1){l:do{if((c[B>>2]|0)==0){X=c[t>>2]|0;Fa=X+168|0;Ha=c[Fa>>2]|0;W=X+172|0;do{if(!(Ha>>>0<(c[W>>2]|0)>>>0)){aa=X+32|0;if((c[aa>>2]|0)==0){Wa=0;break l}xa=X+40|0;Ca=Fd[c[X+16>>2]&15](c[X+28>>2]|0,xa,c[X+36>>2]|0)|0;if((Ca|0)==0){c[aa>>2]=0;aa=(c[W>>2]|0)+ -1|0;c[Fa>>2]=aa;a[aa>>0]=0;Xa=c[Fa>>2]|0;break}else{c[Fa>>2]=xa;c[W>>2]=X+Ca+40;Xa=xa;break}}else{Xa=Ha}}while(0);c[Fa>>2]=Xa+1;Ha=a[Xa>>0]|0;if(!(Ha<<24>>24==-1)){Wa=Ha&255;break}Ha=c[t>>2]|0;X=Ha+168|0;W=c[X>>2]|0;ya=Ha+172|0;do{if(!(W>>>0<(c[ya>>2]|0)>>>0)){xa=Ha+32|0;if((c[xa>>2]|0)==0){Wa=255;break l}Ca=Ha+40|0;aa=Fd[c[Ha+16>>2]&15](c[Ha+28>>2]|0,Ca,c[Ha+36>>2]|0)|0;if((aa|0)==0){c[xa>>2]=0;xa=(c[ya>>2]|0)+ -1|0;c[X>>2]=xa;a[xa>>0]=0;Ya=c[X>>2]|0;break}else{c[X>>2]=Ca;c[ya>>2]=Ha+aa+40;Ya=Ca;break}}else{Ya=W}}while(0);c[X>>2]=Ya+1;Za=a[Ya>>0]|0;if(Za<<24>>24==0){Wa=255}else{break k}}else{Wa=0}}while(0);W=c[C>>2]|0;c[E>>2]=Wa<<24-W|c[E>>2];Ha=W+8|0;c[C>>2]=Ha;if((Ha|0)>=25){break j}}a[z>>0]=Za;c[B>>2]=1}}while(0);Ha=a[z>>0]|0;if(!((Ha+48<<24>>24&255)<8)){Ka=Ha;break f}c[C>>2]=0;c[E>>2]=0;c[B>>2]=0;c[F>>2]=0;c[L>>2]=0;c[D>>2]=0;a[z>>0]=-1;Ha=c[u>>2]|0;W=(Ha|0)==0?2147483647:Ha;c[H>>2]=W;_a=W}else{_a=ma}ua=ua+1|0;$a=c[O>>2]|0;if((ua|0)>=($a|0)){break}else{ta=_a}}ab=_a;bb=$a;cb=c[N>>2]|0}else{ab=V;bb=wa;cb=va}$=$+1|0;if(($|0)>=(cb|0)){ga=151;break}else{wa=bb;V=ab;va=cb}}}else{ga=151}}}while(0);if((ga|0)==151){ga=0;Ka=a[z>>0]|0}if(Ka<<24>>24==-1){m:while(1){R=c[t>>2]|0;do{if((c[R+16>>2]|0)!=0){if((Nd[c[R+24>>2]&63](c[R+28>>2]|0)|0)==0){break}if((c[R+32>>2]|0)==0){ga=172;break d}else{ga=156}}else{ga=156}}while(0);if((ga|0)==156?(ga=0,!((c[R+168>>2]|0)>>>0<(c[R+172>>2]|0)>>>0)):0){ga=172;break d}T=c[t>>2]|0;va=T+168|0;V=c[va>>2]|0;wa=T+172|0;do{if(!(V>>>0<(c[wa>>2]|0)>>>0)){$=T+32|0;if((c[$>>2]|0)==0){continue m}ta=T+40|0;ua=Fd[c[T+16>>2]&15](c[T+28>>2]|0,ta,c[T+36>>2]|0)|0;if((ua|0)==0){c[$>>2]=0;$=(c[wa>>2]|0)+ -1|0;c[va>>2]=$;a[$>>0]=0;db=c[va>>2]|0;break}else{c[va>>2]=ta;c[wa>>2]=T+ua+40;db=ta;break}}else{db=V}}while(0);c[va>>2]=db+1;V=d[db>>0]|0;if((V|0)==255){break}else if((V|0)!=0){break a}}V=c[t>>2]|0;T=V+168|0;wa=c[T>>2]|0;R=V+172|0;do{if(wa>>>0<(c[R>>2]|0)>>>0){c[T>>2]=wa+1;eb=d[wa>>0]|0}else{ta=V+32|0;if((c[ta>>2]|0)==0){eb=0;break}ua=V+40|0;$=Fd[c[V+16>>2]&15](c[V+28>>2]|0,ua,c[V+36>>2]|0)|0;if(($|0)==0){c[ta>>2]=0;ta=(c[R>>2]|0)+ -1|0;c[T>>2]=ta;a[ta>>0]=0;fb=c[T>>2]|0}else{c[T>>2]=ua;c[R>>2]=V+$+40;fb=ua}c[T>>2]=fb+1;eb=d[fb>>0]|0}}while(0);T=eb&255;a[z>>0]=T;gb=T}else{ga=172}}else if((Q|0)!=217){if((Hk(t,Q)|0)==0){break a}else{ga=172}}else{ga=195;break c}}while(0);if((ga|0)==172){ga=0;gb=a[z>>0]|0}if(!(gb<<24>>24==-1)){a[z>>0]=-1;P=gb;continue}Q=c[t>>2]|0;T=Q+168|0;V=c[T>>2]|0;R=Q+172|0;do{if(!(V>>>0<(c[R>>2]|0)>>>0)){wa=Q+32|0;if((c[wa>>2]|0)==0){P=-1;continue c}ua=Q+40|0;$=Fd[c[Q+16>>2]&15](c[Q+28>>2]|0,ua,c[Q+36>>2]|0)|0;if(($|0)==0){c[wa>>2]=0;wa=(c[R>>2]|0)+ -1|0;c[T>>2]=wa;a[wa>>0]=0;hb=c[T>>2]|0;break}else{c[T>>2]=ua;c[R>>2]=Q+$+40;hb=ua;break}}else{hb=V}}while(0);c[T>>2]=hb+1;if(!((a[hb>>0]|0)==-1)){P=-1;continue}while(1){V=c[t>>2]|0;Q=V+168|0;R=c[Q>>2]|0;ua=V+172|0;if(!(R>>>0<(c[ua>>2]|0)>>>0)){$=V+32|0;if((c[$>>2]|0)==0){ib=0}else{wa=V+40|0;ta=Fd[c[V+16>>2]&15](c[V+28>>2]|0,wa,c[V+36>>2]|0)|0;if((ta|0)==0){c[$>>2]=0;$=(c[ua>>2]|0)+ -1|0;c[Q>>2]=$;a[$>>0]=0;jb=c[Q>>2]|0}else{c[Q>>2]=wa;c[ua>>2]=V+ta+40;jb=wa}c[Q>>2]=jb+1;ib=d[jb>>0]|0}}else{c[Q>>2]=R+1;ib=d[R>>0]|0}R=ib&255;if(!(R<<24>>24==-1)){P=R;continue c}}}if((ga|0)==39){c[A>>2]=0}else if((ga|0)==47){c[6510]=29320;break}else if((ga|0)==68){c[6510]=29336;break}else if((ga|0)==70){c[6510]=29352;break}else if((ga|0)==73){c[6510]=29368;break}else if((ga|0)==87){c[6510]=29368;break}else if((ga|0)==195){P=c[t>>2]|0;z=c[P+8>>2]|0;N=(k|0)==0?z:k;O=(z|0)==3&(N|0)<3?1:z;z=(O|0)>0;n:do{if(z){H=t+13700|0;D=t+13704|0;L=P;F=0;while(1){B=s+(F<<5)|0;E=Ll((c[L>>2]|0)+3|0)|0;c[t+(F*56|0)+13776>>2]=E;if((E|0)==0){break}E=(c[H>>2]|0)/(c[t+(F*56|0)+13728>>2]|0)|0;c[s+(F<<5)+12>>2]=E;C=(c[D>>2]|0)/(c[t+(F*56|0)+13732>>2]|0)|0;c[s+(F<<5)+16>>2]=C;c[s+(F<<5)+24>>2]=C>>1;I=c[t>>2]|0;c[s+(F<<5)+20>>2]=((E+ -1+(c[I>>2]|0)|0)>>>0)/(E>>>0)|0;c[s+(F<<5)+28>>2]=0;T=c[t+(F*56|0)+13768>>2]|0;c[s+(F<<5)+8>>2]=T;c[s+(F<<5)+4>>2]=T;do{if((E|0)==1){if((C|0)==1){c[B>>2]=1;break}else if((C|0)==2){c[B>>2]=2;break}else{ga=212;break}}else if((E|0)==2){if((C|0)==1){c[B>>2]=3;break}else if((C|0)==2){c[B>>2]=4;break}else{ga=212;break}}else{ga=212}}while(0);if((ga|0)==212){ga=0;c[B>>2]=5}F=F+1|0;if((F|0)>=(O|0)){kb=I;break n}else{L=I}}if((c[(c[t>>2]|0)+8>>2]|0)>0){L=0;do{F=t+(L*56|0)+13768|0;if((c[F>>2]|0)!=0){Ml(c[t+(L*56|0)+13772>>2]|0);c[F>>2]=0}F=t+(L*56|0)+13776|0;D=c[F>>2]|0;if((D|0)!=0){Ml(D);c[F>>2]=0}L=L+1|0}while((L|0)<(c[(c[t>>2]|0)+8>>2]|0))}c[6510]=26456;y=0;i=l;return y|0}else{kb=P}}while(0);P=c[kb>>2]|0;A=da(P,N)|0;L=c[kb+4>>2]|0;F=Ll((da(A,L)|0)+1|0)|0;if((F|0)==0){if((c[kb+8>>2]|0)>0){A=0;do{D=t+(A*56|0)+13768|0;if((c[D>>2]|0)!=0){Ml(c[t+(A*56|0)+13772>>2]|0);c[D>>2]=0}D=t+(A*56|0)+13776|0;H=c[D>>2]|0;if((H|0)!=0){Ml(H);c[D>>2]=0}A=A+1|0}while((A|0)<(c[(c[t>>2]|0)+8>>2]|0))}c[6510]=26456;y=0;i=l;return y|0}o:do{if((L|0)==0){lb=kb}else{A=(N|0)>2;D=r+4|0;H=r+8|0;C=(N|0)==1;E=kb;T=P;R=0;while(1){Q=F+(da(da(T,N)|0,R)|0)|0;if(z){wa=0;do{ta=s+(wa<<5)+24|0;V=s+(wa<<5)+16|0;if((c[ta>>2]|0)<(c[V>>2]>>1|0)){mb=s+(wa<<5)+4|0;nb=s+(wa<<5)+8|0}else{mb=s+(wa<<5)+8|0;nb=s+(wa<<5)+4|0}c[r+(wa<<2)>>2]=Td[c[s+(wa<<5)>>2]&7](c[t+(wa*56|0)+13776>>2]|0,c[mb>>2]|0,c[nb>>2]|0,c[s+(wa<<5)+20>>2]|0,c[s+(wa<<5)+12>>2]|0)|0;ua=(c[ta>>2]|0)+1|0;c[ta>>2]=ua;if((ua|0)>=(c[V>>2]|0)?(c[ta>>2]=0,ta=s+(wa<<5)+8|0,V=c[ta>>2]|0,c[s+(wa<<5)+4>>2]=V,ua=s+(wa<<5)+28|0,$=(c[ua>>2]|0)+1|0,c[ua>>2]=$,($|0)<(c[t+(wa*56|0)+13756>>2]|0)):0){c[ta>>2]=V+(c[t+(wa*56|0)+13760>>2]|0)}wa=wa+1|0}while((wa|0)!=(O|0));ob=c[t>>2]|0}else{ob=E}wa=c[r>>2]|0;p:do{if(A){if((c[ob+8>>2]|0)!=3){if((c[ob>>2]|0)==0){pb=ob;break}else{qb=0;rb=Q}while(1){I=a[wa+qb>>0]|0;a[rb+2>>0]=I;a[rb+1>>0]=I;a[rb>>0]=I;a[rb+3>>0]=-1;qb=qb+1|0;I=c[t>>2]|0;if(!(qb>>>0<(c[I>>2]|0)>>>0)){pb=I;break p}else{rb=rb+N|0}}}va=c[D>>2]|0;I=c[H>>2]|0;B=c[ob>>2]|0;if((B|0)>0){V=Q;ta=0;while(1){$=d[wa+ta>>0]<<16|32768;ua=(d[I+ta>>0]|0)+ -128|0;W=(d[va+ta>>0]|0)+ -128|0;Ha=(ua*91881|0)+$|0;ya=(da(ua,-46802)|0)+$+(da(W,-22554)|0)|0;ua=(W*116130|0)+$|0;$=Ha>>16;W=ya>>16;Fa=ua>>16;if($>>>0>255){sb=(Ha>>31&-255)+255|0}else{sb=$}if(W>>>0>255){tb=(ya>>31&-255)+255|0}else{tb=W}if(Fa>>>0>255){ub=(ua>>31&-255)+255|0}else{ub=Fa}a[V>>0]=sb;a[V+1>>0]=tb;a[V+2>>0]=ub;a[V+3>>0]=-1;ta=ta+1|0;if((ta|0)==(B|0)){break}else{V=V+N|0}}pb=c[t>>2]|0}else{pb=ob}}else{V=c[ob>>2]|0;B=(V|0)==0;if(C){if(B){pb=ob;break}Mm(Q|0,wa|0,(V>>>0>1?V:1)|0)|0;pb=ob;break}else{if(B){pb=ob;break}else{vb=0;wb=Q}while(1){a[wb>>0]=a[wa+vb>>0]|0;a[wb+1>>0]=-1;vb=vb+1|0;B=c[t>>2]|0;if(!(vb>>>0<(c[B>>2]|0)>>>0)){pb=B;break}else{wb=wb+2|0}}}}}while(0);wa=R+1|0;if(!(wa>>>0<(c[pb+4>>2]|0)>>>0)){lb=pb;break o}E=pb;T=c[pb>>2]|0;R=wa}}}while(0);if((c[lb+8>>2]|0)>0){N=0;do{O=t+(N*56|0)+13768|0;if((c[O>>2]|0)!=0){Ml(c[t+(N*56|0)+13772>>2]|0);c[O>>2]=0}O=t+(N*56|0)+13776|0;z=c[O>>2]|0;if((z|0)!=0){Ml(z);c[O>>2]=0}N=N+1|0;O=c[t>>2]|0}while((N|0)<(c[O+8>>2]|0));xb=O}else{xb=lb}c[f>>2]=c[xb>>2];c[h>>2]=c[xb+4>>2];if((j|0)==0){y=F;i=l;return y|0}c[j>>2]=c[xb+8>>2];y=F;i=l;return y|0}c[6510]=29296}}while(0);if((c[(c[t>>2]|0)+8>>2]|0)>0){yb=0}else{y=0;i=l;return y|0}do{xb=t+(yb*56|0)+13768|0;if((c[xb>>2]|0)!=0){Ml(c[t+(yb*56|0)+13772>>2]|0);c[xb>>2]=0}xb=t+(yb*56|0)+13776|0;lb=c[xb>>2]|0;if((lb|0)!=0){Ml(lb);c[xb>>2]=0}yb=yb+1|0}while((yb|0)<(c[(c[t>>2]|0)+8>>2]|0));y=0;i=l;return y|0}t=e+172|0;yb=e+32|0;xb=e+16|0;lb=e+28|0;pb=e+40|0;wb=e+36|0;vb=w;w=0;while(1){if(!(vb>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){zb=0;Ab=vb}else{ob=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ob|0)==0){c[yb>>2]=0;ub=(c[t>>2]|0)+ -1|0;c[x>>2]=ub;a[ub>>0]=0;Bb=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ob+40;Bb=pb}ob=Bb+1|0;c[x>>2]=ob;zb=d[Bb>>0]|0;Ab=ob}}else{ob=vb+1|0;c[x>>2]=ob;zb=d[vb>>0]|0;Ab=ob}if(!((zb&255)<<24>>24==(a[26912+w>>0]|0))){break}w=w+1|0;if((w|0)>=8){ga=271;break}else{vb=Ab}}if((ga|0)==271){c[x>>2]=c[v>>2];c[o>>2]=e;if(k>>>0>4){c[6510]=29120;y=0;i=l;return y|0}Ab=(Ek(o,0,k)|0)==0;vb=o+12|0;w=c[vb>>2]|0;if(!Ab){c[vb>>2]=0;Ab=c[o>>2]|0;if((k|0)!=0?(zb=Ab+12|0,Bb=c[zb>>2]|0,(Bb|0)!=(k|0)):0){ob=Lk(w,Bb,k,c[Ab>>2]|0,c[Ab+4>>2]|0)|0;c[zb>>2]=k;if((ob|0)==0){y=0;i=l;return y|0}else{Cb=ob}}else{Cb=w}c[f>>2]=c[Ab>>2];c[h>>2]=c[Ab+4>>2];if((j|0)==0){Db=0;Eb=Cb}else{c[j>>2]=c[Ab+8>>2];Db=0;Eb=Cb}}else{Db=w;Eb=0}Ml(Db);c[vb>>2]=0;vb=o+8|0;Ml(c[vb>>2]|0);c[vb>>2]=0;vb=o+4|0;Ml(c[vb>>2]|0);c[vb>>2]=0;y=Eb;i=l;return y|0}c[6510]=26920;Eb=c[v>>2]|0;c[x>>2]=Eb;do{if(!(Eb>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)!=0){vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;Db=(c[t>>2]|0)+ -1|0;c[x>>2]=Db;a[Db>>0]=0;Fb=c[x>>2]|0;ga=285;break}else{c[x>>2]=pb;c[t>>2]=e+vb+40;Fb=pb;ga=285;break}}}else{Fb=Eb;ga=285}}while(0);q:do{if((ga|0)==285?(Eb=Fb+1|0,c[x>>2]=Eb,(a[Fb>>0]|0)==66):0){do{if(!(Eb>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){break q}vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;Db=(c[t>>2]|0)+ -1|0;c[x>>2]=Db;a[Db>>0]=0;Gb=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+vb+40;Gb=pb;break}}else{Gb=Eb}}while(0);Eb=Gb+1|0;c[x>>2]=Eb;if((a[Gb>>0]|0)==77){F=c[t>>2]|0;if(!(Eb>>>0<F>>>0)){if((c[yb>>2]|0)==0){Hb=Eb;Ib=F}else{Eb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Eb|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;Jb=c[t>>2]|0;Kb=c[x>>2]|0}else{c[x>>2]=pb;vb=e+Eb+40|0;c[t>>2]=vb;Jb=vb;Kb=pb}vb=Kb+1|0;c[x>>2]=vb;Hb=vb;Ib=Jb}}else{vb=Gb+2|0;c[x>>2]=vb;Hb=vb;Ib=F}if(!(Hb>>>0<Ib>>>0)){if((c[yb>>2]|0)==0){Lb=Hb;Mb=Ib}else{F=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((F|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;Nb=c[t>>2]|0;Ob=c[x>>2]|0}else{c[x>>2]=pb;vb=e+F+40|0;c[t>>2]=vb;Nb=vb;Ob=pb}vb=Ob+1|0;c[x>>2]=vb;Lb=vb;Mb=Nb}}else{vb=Hb+1|0;c[x>>2]=vb;Lb=vb;Mb=Ib}if(!(Lb>>>0<Mb>>>0)){if((c[yb>>2]|0)==0){Pb=Lb;Qb=Mb}else{vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;F=(c[t>>2]|0)+ -1|0;c[x>>2]=F;a[F>>0]=0;Rb=c[t>>2]|0;Sb=c[x>>2]|0}else{c[x>>2]=pb;F=e+vb+40|0;c[t>>2]=F;Rb=F;Sb=pb}F=Sb+1|0;c[x>>2]=F;Pb=F;Qb=Rb}}else{F=Lb+1|0;c[x>>2]=F;Pb=F;Qb=Mb}if(!(Pb>>>0<Qb>>>0)){if((c[yb>>2]|0)==0){Tb=Pb;Ub=Qb}else{F=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((F|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;Vb=c[t>>2]|0;Wb=c[x>>2]|0}else{c[x>>2]=pb;vb=e+F+40|0;c[t>>2]=vb;Vb=vb;Wb=pb}vb=Wb+1|0;c[x>>2]=vb;Tb=vb;Ub=Vb}}else{vb=Pb+1|0;c[x>>2]=vb;Tb=vb;Ub=Qb}if(!(Tb>>>0<Ub>>>0)){if((c[yb>>2]|0)==0){Xb=Tb;Yb=Ub}else{vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;F=(c[t>>2]|0)+ -1|0;c[x>>2]=F;a[F>>0]=0;Zb=c[t>>2]|0;_b=c[x>>2]|0}else{c[x>>2]=pb;F=e+vb+40|0;c[t>>2]=F;Zb=F;_b=pb}F=_b+1|0;c[x>>2]=F;Xb=F;Yb=Zb}}else{F=Tb+1|0;c[x>>2]=F;Xb=F;Yb=Ub}if(!(Xb>>>0<Yb>>>0)){if((c[yb>>2]|0)==0){$b=Xb;ac=Yb}else{F=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((F|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;bc=c[t>>2]|0;cc=c[x>>2]|0}else{c[x>>2]=pb;vb=e+F+40|0;c[t>>2]=vb;bc=vb;cc=pb}vb=cc+1|0;c[x>>2]=vb;$b=vb;ac=bc}}else{vb=Xb+1|0;c[x>>2]=vb;$b=vb;ac=Yb}if(!($b>>>0<ac>>>0)){if((c[yb>>2]|0)==0){dc=$b;ec=ac}else{vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;F=(c[t>>2]|0)+ -1|0;c[x>>2]=F;a[F>>0]=0;fc=c[t>>2]|0;gc=c[x>>2]|0}else{c[x>>2]=pb;F=e+vb+40|0;c[t>>2]=F;fc=F;gc=pb}F=gc+1|0;c[x>>2]=F;dc=F;ec=fc}}else{F=$b+1|0;c[x>>2]=F;dc=F;ec=ac}if(!(dc>>>0<ec>>>0)){if((c[yb>>2]|0)==0){hc=dc;ic=ec}else{F=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((F|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;jc=c[t>>2]|0;kc=c[x>>2]|0}else{c[x>>2]=pb;vb=e+F+40|0;c[t>>2]=vb;jc=vb;kc=pb}vb=kc+1|0;c[x>>2]=vb;hc=vb;ic=jc}}else{vb=dc+1|0;c[x>>2]=vb;hc=vb;ic=ec}if(!(hc>>>0<ic>>>0)){if((c[yb>>2]|0)==0){lc=hc;mc=ic}else{vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;F=(c[t>>2]|0)+ -1|0;c[x>>2]=F;a[F>>0]=0;nc=c[t>>2]|0;oc=c[x>>2]|0}else{c[x>>2]=pb;F=e+vb+40|0;c[t>>2]=F;nc=F;oc=pb}F=oc+1|0;c[x>>2]=F;lc=F;mc=nc}}else{F=hc+1|0;c[x>>2]=F;lc=F;mc=ic}if(!(lc>>>0<mc>>>0)){if((c[yb>>2]|0)==0){pc=lc;qc=mc}else{F=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((F|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;rc=c[t>>2]|0;sc=c[x>>2]|0}else{c[x>>2]=pb;vb=e+F+40|0;c[t>>2]=vb;rc=vb;sc=pb}vb=sc+1|0;c[x>>2]=vb;pc=vb;qc=rc}}else{vb=lc+1|0;c[x>>2]=vb;pc=vb;qc=mc}if(!(pc>>>0<qc>>>0)){if((c[yb>>2]|0)==0){tc=pc;uc=qc}else{vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;F=(c[t>>2]|0)+ -1|0;c[x>>2]=F;a[F>>0]=0;vc=c[t>>2]|0;wc=c[x>>2]|0}else{c[x>>2]=pb;F=e+vb+40|0;c[t>>2]=F;vc=F;wc=pb}F=wc+1|0;c[x>>2]=F;tc=F;uc=vc}}else{F=pc+1|0;c[x>>2]=F;tc=F;uc=qc}if(!(tc>>>0<uc>>>0)){if((c[yb>>2]|0)==0){xc=tc;yc=uc}else{F=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((F|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;zc=c[t>>2]|0;Ac=c[x>>2]|0}else{c[x>>2]=pb;vb=e+F+40|0;c[t>>2]=vb;zc=vb;Ac=pb}vb=Ac+1|0;c[x>>2]=vb;xc=vb;yc=zc}}else{vb=tc+1|0;c[x>>2]=vb;xc=vb;yc=uc}do{if(xc>>>0<yc>>>0){vb=xc+1|0;c[x>>2]=vb;Bc=d[xc>>0]|0;Cc=vb;Dc=yc}else{if((c[yb>>2]|0)==0){Bc=0;Cc=xc;Dc=yc;break}vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;F=(c[t>>2]|0)+ -1|0;c[x>>2]=F;a[F>>0]=0;Ec=c[t>>2]|0;Fc=c[x>>2]|0}else{c[x>>2]=pb;F=e+vb+40|0;c[t>>2]=F;Ec=F;Fc=pb}F=Fc+1|0;c[x>>2]=F;Bc=d[Fc>>0]|0;Cc=F;Dc=Ec}}while(0);do{if(Cc>>>0<Dc>>>0){F=Cc+1|0;c[x>>2]=F;Gc=d[Cc>>0]|0;Hc=F;Ic=Dc}else{if((c[yb>>2]|0)==0){Gc=0;Hc=Cc;Ic=Dc;break}F=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((F|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;Jc=c[t>>2]|0;Kc=c[x>>2]|0}else{c[x>>2]=pb;vb=e+F+40|0;c[t>>2]=vb;Jc=vb;Kc=pb}vb=Kc+1|0;c[x>>2]=vb;Gc=d[Kc>>0]|0;Hc=vb;Ic=Jc}}while(0);vb=Gc<<8|Bc;do{if(Hc>>>0<Ic>>>0){F=Hc+1|0;c[x>>2]=F;Lc=d[Hc>>0]|0;Mc=F;Nc=Ic}else{if((c[yb>>2]|0)==0){Lc=0;Mc=Hc;Nc=Ic;break}F=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((F|0)==0){c[yb>>2]=0;Eb=(c[t>>2]|0)+ -1|0;c[x>>2]=Eb;a[Eb>>0]=0;Oc=c[t>>2]|0;Pc=c[x>>2]|0}else{c[x>>2]=pb;Eb=e+F+40|0;c[t>>2]=Eb;Oc=Eb;Pc=pb}Eb=Pc+1|0;c[x>>2]=Eb;Lc=d[Pc>>0]|0;Mc=Eb;Nc=Oc}}while(0);do{if(Mc>>>0<Nc>>>0){c[x>>2]=Mc+1;Qc=d[Mc>>0]|0}else{if((c[yb>>2]|0)==0){Qc=0;break}Eb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Eb|0)==0){c[yb>>2]=0;F=(c[t>>2]|0)+ -1|0;c[x>>2]=F;a[F>>0]=0;Rc=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Eb+40;Rc=pb}c[x>>2]=Rc+1;Qc=d[Rc>>0]|0}}while(0);Eb=vb|(Qc<<8|Lc)<<16;if(!((Eb|0)==12|(Eb|0)==40|(Eb|0)==56|(Eb|0)==108)){break}c[x>>2]=c[v>>2];y=Nk(e,f,h,j,k)|0;i=l;return y|0}}}while(0);Lc=c[v>>2]|0;c[x>>2]=Lc;do{if(!(Lc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)!=0){Qc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Qc|0)==0){c[yb>>2]=0;Rc=(c[t>>2]|0)+ -1|0;c[x>>2]=Rc;a[Rc>>0]=0;Sc=c[x>>2]|0;ga=411;break}else{c[x>>2]=pb;c[t>>2]=e+Qc+40;Sc=pb;ga=411;break}}else{ga=444}}else{Sc=Lc;ga=411}}while(0);r:do{if((ga|0)==411){Lc=Sc+1|0;c[x>>2]=Lc;if((a[Sc>>0]|0)==71){do{if(!(Lc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){ga=444;break r}Qc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Qc|0)==0){c[yb>>2]=0;Rc=(c[t>>2]|0)+ -1|0;c[x>>2]=Rc;a[Rc>>0]=0;Tc=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+Qc+40;Tc=pb;break}}else{Tc=Lc}}while(0);Lc=Tc+1|0;c[x>>2]=Lc;if((a[Tc>>0]|0)==73){do{if(!(Lc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){ga=444;break r}vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;Qc=(c[t>>2]|0)+ -1|0;c[x>>2]=Qc;a[Qc>>0]=0;Uc=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+vb+40;Uc=pb;break}}else{Uc=Lc}}while(0);Lc=Uc+1|0;c[x>>2]=Lc;if((a[Uc>>0]|0)==70){do{if(!(Lc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){ga=444;break r}vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;Qc=(c[t>>2]|0)+ -1|0;c[x>>2]=Qc;a[Qc>>0]=0;Vc=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+vb+40;Vc=pb;break}}else{Vc=Lc}}while(0);Lc=Vc+1|0;c[x>>2]=Lc;if((a[Vc>>0]|0)==56){do{if(!(Lc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){ga=444;break r}vb=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((vb|0)==0){c[yb>>2]=0;Qc=(c[t>>2]|0)+ -1|0;c[x>>2]=Qc;a[Qc>>0]=0;Wc=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+vb+40;Wc=pb;break}}else{Wc=Lc}}while(0);Lc=Wc+1|0;c[x>>2]=Lc;vb=d[Wc>>0]|0;if((vb|0)==55|(vb|0)==57){if(Lc>>>0<(c[t>>2]|0)>>>0){Xc=Lc;Yc=Wc+2|0}else{if((c[yb>>2]|0)==0){Lc=c[v>>2]|0;c[x>>2]=Lc;Zc=Lc;break}Lc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Lc|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;_c=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Lc+40;_c=pb}Xc=_c;Yc=_c+1|0}c[x>>2]=Yc;Lc=(a[Xc>>0]|0)==97;vb=c[v>>2]|0;c[x>>2]=vb;if(Lc){Om(m|0,0,18508)|0;Lc=m+8|0;s:do{if((Dk(e,m,j,0)|0)==0){$c=0}else{Qc=m+4|0;Rc=da(c[m>>2]<<2,c[Qc>>2]|0)|0;Mc=Ll(Rc)|0;c[Lc>>2]=Mc;if((Mc|0)==0){c[6510]=26456;$c=0;break}Nc=c[m+16>>2]|0;Oc=m+(Nc<<2)+32|0;t:do{if((Rc|0)>0){Pc=m+(Nc<<2)+34|0;Ic=m+(Nc<<2)+33|0;Hc=m+(Nc<<2)+35|0;Bc=Mc;Gc=0;while(1){a[Bc+Gc>>0]=a[Pc>>0]|0;a[Bc+(Gc|1)>>0]=a[Ic>>0]|0;a[Bc+(Gc|2)>>0]=a[Oc>>0]|0;a[Bc+(Gc|3)>>0]=a[Hc>>0]|0;Jc=Gc+4|0;if((Jc|0)>=(da(c[m>>2]<<2,c[Qc>>2]|0)|0)){break t}Bc=c[Lc>>2]|0;Gc=Jc}}}while(0);Oc=m+28|0;Mc=m+24|0;Nc=e+20|0;u:while(1){Rc=c[x>>2]|0;do{if(!(Rc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){ga=680;break u}Gc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Gc|0)==0){c[yb>>2]=0;Bc=(c[t>>2]|0)+ -1|0;c[x>>2]=Bc;a[Bc>>0]=0;ad=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+Gc+40;ad=pb;break}}else{ad=Rc}}while(0);bd=ad+1|0;c[x>>2]=bd;Rc=d[ad>>0]|0;if((Rc|0)==44){break}else if((Rc|0)==59){$c=1;break s}else if((Rc|0)!=33){ga=680;break}do{if(!(bd>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){cd=bd;break}Rc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Rc|0)==0){c[yb>>2]=0;Gc=(c[t>>2]|0)+ -1|0;c[x>>2]=Gc;a[Gc>>0]=0;dd=c[x>>2]|0;ga=629;break}else{c[x>>2]=pb;c[t>>2]=e+Rc+40;dd=pb;ga=629;break}}else{dd=bd;ga=629}}while(0);v:do{if((ga|0)==629){ga=0;Rc=dd+1|0;c[x>>2]=Rc;if(!((a[dd>>0]|0)==-7)){cd=Rc;break}do{if(!(Rc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){ed=0;fd=Rc;break}Gc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Gc|0)==0){c[yb>>2]=0;Bc=(c[t>>2]|0)+ -1|0;c[x>>2]=Bc;a[Bc>>0]=0;gd=c[x>>2]|0;ga=635;break}else{c[x>>2]=pb;c[t>>2]=e+Gc+40;gd=pb;ga=635;break}}else{gd=Rc;ga=635}}while(0);do{if((ga|0)==635){ga=0;Rc=gd+1|0;c[x>>2]=Rc;Gc=a[gd>>0]|0;if(!(Gc<<24>>24==4)){ed=Gc&255;fd=Rc;break}Gc=c[t>>2]|0;do{if(Rc>>>0<Gc>>>0){Bc=gd+2|0;c[x>>2]=Bc;hd=d[Rc>>0]|0;id=Bc;jd=Gc}else{if((c[yb>>2]|0)==0){hd=0;id=Rc;jd=Gc;break}Bc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Bc|0)==0){c[yb>>2]=0;Hc=(c[t>>2]|0)+ -1|0;c[x>>2]=Hc;a[Hc>>0]=0;kd=c[t>>2]|0;ld=c[x>>2]|0}else{c[x>>2]=pb;Hc=e+Bc+40|0;c[t>>2]=Hc;kd=Hc;ld=pb}Hc=ld+1|0;c[x>>2]=Hc;hd=d[ld>>0]|0;id=Hc;jd=kd}}while(0);c[Oc>>2]=hd;do{if(id>>>0<jd>>>0){Gc=id+1|0;c[x>>2]=Gc;md=Gc;nd=jd}else{if((c[yb>>2]|0)==0){md=id;nd=jd;break}Gc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Gc|0)==0){c[yb>>2]=0;Rc=(c[t>>2]|0)+ -1|0;c[x>>2]=Rc;a[Rc>>0]=0;od=c[t>>2]|0;pd=c[x>>2]|0}else{c[x>>2]=pb;Rc=e+Gc+40|0;c[t>>2]=Rc;od=Rc;pd=pb}Rc=pd+1|0;c[x>>2]=Rc;md=Rc;nd=od}}while(0);do{if(md>>>0<nd>>>0){Rc=md+1|0;c[x>>2]=Rc;qd=Rc;rd=nd}else{if((c[yb>>2]|0)==0){qd=md;rd=nd;break}Rc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Rc|0)==0){c[yb>>2]=0;Gc=(c[t>>2]|0)+ -1|0;c[x>>2]=Gc;a[Gc>>0]=0;sd=c[t>>2]|0;td=c[x>>2]|0}else{c[x>>2]=pb;Gc=e+Rc+40|0;c[t>>2]=Gc;sd=Gc;td=pb}Gc=td+1|0;c[x>>2]=Gc;qd=Gc;rd=sd}}while(0);do{if(qd>>>0<rd>>>0){Gc=qd+1|0;c[x>>2]=Gc;ud=d[qd>>0]|0;vd=Gc}else{if((c[yb>>2]|0)==0){ud=0;vd=qd;break}Gc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Gc|0)==0){c[yb>>2]=0;Rc=(c[t>>2]|0)+ -1|0;c[x>>2]=Rc;a[Rc>>0]=0;wd=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Gc+40;wd=pb}Gc=wd+1|0;c[x>>2]=Gc;ud=d[wd>>0]|0;vd=Gc}}while(0);c[Mc>>2]=ud;cd=vd;break v}}while(0);do{if((c[xb>>2]|0)!=0){Gc=c[t>>2]|0;Rc=Gc-fd|0;if((Rc|0)>=(ed|0)){break}c[x>>2]=Gc;Md[c[Nc>>2]&63](c[lb>>2]|0,ed-Rc|0);continue u}}while(0);c[x>>2]=fd+ed;continue u}}while(0);w:while(1){do{if(!(cd>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){continue u}Rc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Rc|0)==0){c[yb>>2]=0;Gc=(c[t>>2]|0)+ -1|0;c[x>>2]=Gc;a[Gc>>0]=0;xd=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+Rc+40;xd=pb;break}}else{xd=cd}}while(0);Rc=xd+1|0;c[x>>2]=Rc;Gc=a[xd>>0]|0;Hc=Gc&255;if(Gc<<24>>24==0){continue u}do{if((c[xb>>2]|0)!=0){Gc=c[t>>2]|0;Bc=Gc-Rc|0;if((Bc|0)>=(Hc|0)){break}c[x>>2]=Gc;Md[c[Nc>>2]&63](c[lb>>2]|0,Hc-Bc|0);cd=c[x>>2]|0;continue w}}while(0);Rc=xd+(Hc+1)|0;c[x>>2]=Rc;cd=Rc}}if((ga|0)==680){c[6510]=28928;$c=0;break}Rc=c[t>>2]|0;do{if(bd>>>0<Rc>>>0){Bc=ad+2|0;c[x>>2]=Bc;yd=d[bd>>0]|0;zd=Bc;Ad=Rc}else{if((c[yb>>2]|0)==0){yd=0;zd=bd;Ad=Rc;break}Bc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Bc|0)==0){c[yb>>2]=0;Gc=(c[t>>2]|0)+ -1|0;c[x>>2]=Gc;a[Gc>>0]=0;Bd=c[t>>2]|0;Cd=c[x>>2]|0}else{c[x>>2]=pb;Gc=e+Bc+40|0;c[t>>2]=Gc;Bd=Gc;Cd=pb}Gc=Cd+1|0;c[x>>2]=Gc;yd=d[Cd>>0]|0;zd=Gc;Ad=Bd}}while(0);do{if(zd>>>0<Ad>>>0){Rc=zd+1|0;c[x>>2]=Rc;Dd=d[zd>>0]|0;Ed=Rc;Gd=Ad}else{if((c[yb>>2]|0)==0){Dd=0;Ed=zd;Gd=Ad;break}Rc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Rc|0)==0){c[yb>>2]=0;Gc=(c[t>>2]|0)+ -1|0;c[x>>2]=Gc;a[Gc>>0]=0;Hd=c[t>>2]|0;Id=c[x>>2]|0}else{c[x>>2]=pb;Gc=e+Rc+40|0;c[t>>2]=Gc;Hd=Gc;Id=pb}Gc=Id+1|0;c[x>>2]=Gc;Dd=d[Id>>0]|0;Ed=Gc;Gd=Hd}}while(0);Gc=Dd<<8|yd;do{if(Ed>>>0<Gd>>>0){Rc=Ed+1|0;c[x>>2]=Rc;Jd=d[Ed>>0]|0;Kd=Rc;Ld=Gd}else{if((c[yb>>2]|0)==0){Jd=0;Kd=Ed;Ld=Gd;break}Rc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Rc|0)==0){c[yb>>2]=0;Bc=(c[t>>2]|0)+ -1|0;c[x>>2]=Bc;a[Bc>>0]=0;Od=c[t>>2]|0;Pd=c[x>>2]|0}else{c[x>>2]=pb;Bc=e+Rc+40|0;c[t>>2]=Bc;Od=Bc;Pd=pb}Bc=Pd+1|0;c[x>>2]=Bc;Jd=d[Pd>>0]|0;Kd=Bc;Ld=Od}}while(0);do{if(Kd>>>0<Ld>>>0){Bc=Kd+1|0;c[x>>2]=Bc;Qd=d[Kd>>0]|0;Rd=Bc;Sd=Ld}else{if((c[yb>>2]|0)==0){Qd=0;Rd=Kd;Sd=Ld;break}Bc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Bc|0)==0){c[yb>>2]=0;Rc=(c[t>>2]|0)+ -1|0;c[x>>2]=Rc;a[Rc>>0]=0;Ud=c[t>>2]|0;Vd=c[x>>2]|0}else{c[x>>2]=pb;Rc=e+Bc+40|0;c[t>>2]=Rc;Ud=Rc;Vd=pb}Rc=Vd+1|0;c[x>>2]=Rc;Qd=d[Vd>>0]|0;Rd=Rc;Sd=Ud}}while(0);Rc=Qd<<8|Jd;do{if(Rd>>>0<Sd>>>0){Bc=Rd+1|0;c[x>>2]=Bc;Wd=d[Rd>>0]|0;Xd=Bc;Yd=Sd}else{if((c[yb>>2]|0)==0){Wd=0;Xd=Rd;Yd=Sd;break}Bc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Bc|0)==0){c[yb>>2]=0;Ic=(c[t>>2]|0)+ -1|0;c[x>>2]=Ic;a[Ic>>0]=0;Zd=c[t>>2]|0;_d=c[x>>2]|0}else{c[x>>2]=pb;Ic=e+Bc+40|0;c[t>>2]=Ic;Zd=Ic;_d=pb}Ic=_d+1|0;c[x>>2]=Ic;Wd=d[_d>>0]|0;Xd=Ic;Yd=Zd}}while(0);do{if(Xd>>>0<Yd>>>0){Ic=Xd+1|0;c[x>>2]=Ic;$d=d[Xd>>0]|0;ae=Ic;be=Yd}else{if((c[yb>>2]|0)==0){$d=0;ae=Xd;be=Yd;break}Ic=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ic|0)==0){c[yb>>2]=0;Bc=(c[t>>2]|0)+ -1|0;c[x>>2]=Bc;a[Bc>>0]=0;ce=c[t>>2]|0;de=c[x>>2]|0}else{c[x>>2]=pb;Bc=e+Ic+40|0;c[t>>2]=Bc;ce=Bc;de=pb}Bc=de+1|0;c[x>>2]=Bc;$d=d[de>>0]|0;ae=Bc;be=ce}}while(0);Bc=$d<<8|Wd;do{if(ae>>>0<be>>>0){Ic=ae+1|0;c[x>>2]=Ic;ee=d[ae>>0]|0;fe=Ic;ge=be}else{if((c[yb>>2]|0)==0){ee=0;fe=ae;ge=be;break}Ic=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ic|0)==0){c[yb>>2]=0;Pc=(c[t>>2]|0)+ -1|0;c[x>>2]=Pc;a[Pc>>0]=0;he=c[t>>2]|0;ie=c[x>>2]|0}else{c[x>>2]=pb;Pc=e+Ic+40|0;c[t>>2]=Pc;he=Pc;ie=pb}Pc=ie+1|0;c[x>>2]=Pc;ee=d[ie>>0]|0;fe=Pc;ge=he}}while(0);do{if(fe>>>0<ge>>>0){Pc=fe+1|0;c[x>>2]=Pc;je=d[fe>>0]|0;ke=Pc}else{if((c[yb>>2]|0)==0){je=0;ke=fe;break}Pc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Pc|0)==0){c[yb>>2]=0;Ic=(c[t>>2]|0)+ -1|0;c[x>>2]=Ic;a[Ic>>0]=0;le=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Pc+40;le=pb}Pc=le+1|0;c[x>>2]=Pc;je=d[le>>0]|0;ke=Pc}}while(0);Pc=c[m>>2]|0;do{if((Bc+Gc|0)<=(Pc|0)){Ic=(je<<8|ee)+Rc|0;if((Ic|0)>(c[Qc>>2]|0)){break}Jc=Pc<<2;Kc=m+18504|0;c[Kc>>2]=Jc;Dc=Gc<<2;c[m+18480>>2]=Dc;Cc=da(Jc,Rc)|0;c[m+18484>>2]=Cc;c[m+18488>>2]=(Bc<<2)+Dc;c[m+18492>>2]=da(Ic,Jc)|0;c[m+18496>>2]=Dc;c[m+18500>>2]=Cc;do{if(!(ke>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){Cc=m+18476|0;c[Cc>>2]=0;me=Jc;ne=Cc;oe=ke;ga=527;break}Cc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Cc|0)==0){c[yb>>2]=0;Dc=(c[t>>2]|0)+ -1|0;c[x>>2]=Dc;a[Dc>>0]=0;pe=c[x>>2]|0;ga=525;break}else{c[x>>2]=pb;c[t>>2]=e+Cc+40;pe=pb;ga=525;break}}else{pe=ke;ga=525}}while(0);do{if((ga|0)==525){Jc=pe+1|0;c[x>>2]=Jc;Cc=d[pe>>0]|0;Dc=m+18476|0;c[Dc>>2]=Cc;Ic=c[Kc>>2]|0;if((Cc&64|0)==0){me=Ic;ne=Dc;oe=Jc;ga=527;break}c[m+18472>>2]=Ic<<3;c[m+18468>>2]=3;qe=Cc;re=Jc}}while(0);if((ga|0)==527){c[m+18472>>2]=me;c[m+18468>>2]=0;qe=c[ne>>2]|0;re=oe}if((qe&128|0)==0){if((c[m+12>>2]&128|0)==0){c[6510]=28904;$c=0;break s}else{se=0}do{a[m+(se<<2)+35>>0]=-1;se=se+1|0}while((se|0)!=256);Kc=c[Mc>>2]|0;do{if((Kc|0)>-1){if((c[Oc>>2]&1|0)==0){break}a[m+(Kc<<2)+35>>0]=0}}while(0);c[m+18464>>2]=m+32;te=re}else{Kc=2<<(qe&7);if((Kc|0)>0){Jc=((c[Mc>>2]|0)==0&(c[Oc>>2]&1|0)!=0)<<31>>31;Cc=re;Ic=0;while(1){Dc=c[t>>2]|0;do{if(Cc>>>0<Dc>>>0){Ec=Cc+1|0;c[x>>2]=Ec;ue=d[Cc>>0]|0;ve=Ec;we=Dc}else{if((c[yb>>2]|0)==0){ue=0;ve=Cc;we=Dc;break}Ec=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ec|0)==0){c[yb>>2]=0;Fc=(c[t>>2]|0)+ -1|0;c[x>>2]=Fc;a[Fc>>0]=0;xe=c[t>>2]|0;ye=c[x>>2]|0}else{c[x>>2]=pb;Fc=e+Ec+40|0;c[t>>2]=Fc;xe=Fc;ye=pb}Fc=ye+1|0;c[x>>2]=Fc;ue=d[ye>>0]|0;ve=Fc;we=xe}}while(0);a[m+(Ic<<2)+1058>>0]=ue;do{if(ve>>>0<we>>>0){Dc=ve+1|0;c[x>>2]=Dc;ze=d[ve>>0]|0;Ae=Dc;Be=we}else{if((c[yb>>2]|0)==0){ze=0;Ae=ve;Be=we;break}Dc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Dc|0)==0){c[yb>>2]=0;Hc=(c[t>>2]|0)+ -1|0;c[x>>2]=Hc;a[Hc>>0]=0;Ce=c[t>>2]|0;De=c[x>>2]|0}else{c[x>>2]=pb;Hc=e+Dc+40|0;c[t>>2]=Hc;Ce=Hc;De=pb}Hc=De+1|0;c[x>>2]=Hc;ze=d[De>>0]|0;Ae=Hc;Be=Ce}}while(0);a[m+(Ic<<2)+1057>>0]=ze;do{if(Ae>>>0<Be>>>0){Hc=Ae+1|0;c[x>>2]=Hc;Ee=d[Ae>>0]|0;Fe=Hc}else{if((c[yb>>2]|0)==0){Ee=0;Fe=Ae;break}Hc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Hc|0)==0){c[yb>>2]=0;Dc=(c[t>>2]|0)+ -1|0;c[x>>2]=Dc;a[Dc>>0]=0;Ge=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Hc+40;Ge=pb}Hc=Ge+1|0;c[x>>2]=Hc;Ee=d[Ge>>0]|0;Fe=Hc}}while(0);a[m+(Ic<<2)+1056>>0]=Ee;a[m+(Ic<<2)+1059>>0]=Jc;Ic=Ic+1|0;if((Ic|0)==(Kc|0)){He=Fe;break}else{Cc=Fe}}}else{He=re}c[m+18464>>2]=m+1056;te=He}do{if(te>>>0<(c[t>>2]|0)>>>0){c[x>>2]=te+1;Ie=d[te>>0]|0}else{if((c[yb>>2]|0)==0){Ie=0;break}Cc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Cc|0)==0){c[yb>>2]=0;Kc=(c[t>>2]|0)+ -1|0;c[x>>2]=Kc;a[Kc>>0]=0;Je=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Cc+40;Je=pb}c[x>>2]=Je+1;Ie=d[Je>>0]|0}}while(0);Cc=1<<Ie;if((Cc|0)>0){Kc=0;do{b[m+(Kc<<2)+2080>>1]=-1;Ic=Kc&255;a[m+(Kc<<2)+2082>>0]=Ic;a[m+(Kc<<2)+2083>>0]=Ic;Kc=Kc+1|0}while((Kc|0)!=(Cc|0))}Kc=Cc+2|0;Ic=Cc+1|0;Jc=0;Hc=0;Dc=0;Fc=0;x:while(1){Ec=Kc;yc=Jc;xc=Ie;uc=Dc;tc=-1;zc=Fc;y:while(1){Ac=xc+1|0;qc=(1<<Ac)+ -1|0;pc=Ec;vc=yc;wc=uc;mc=tc;lc=zc;while(1){if((lc|0)<(Ac|0)){rc=c[x>>2]|0;sc=vc;ic=wc;hc=lc;while(1){if((ic|0)==0){do{if(!(rc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){break x}nc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((nc|0)==0){c[yb>>2]=0;oc=(c[t>>2]|0)+ -1|0;c[x>>2]=oc;a[oc>>0]=0;Ke=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+nc+40;Ke=pb;break}}else{Ke=rc}}while(0);nc=Ke+1|0;c[x>>2]=nc;oc=a[Ke>>0]|0;if(oc<<24>>24==0){break x}Le=nc;Me=oc&255}else{Le=rc;Me=ic}oc=Me+ -1|0;do{if(Le>>>0<(c[t>>2]|0)>>>0){nc=Le+1|0;c[x>>2]=nc;Ne=d[Le>>0]|0;Oe=nc}else{if((c[yb>>2]|0)==0){Ne=0;Oe=Le;break}nc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((nc|0)==0){c[yb>>2]=0;ec=(c[t>>2]|0)+ -1|0;c[x>>2]=ec;a[ec>>0]=0;Pe=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+nc+40;Pe=pb}nc=Pe+1|0;c[x>>2]=nc;Ne=d[Pe>>0]|0;Oe=nc}}while(0);nc=Ne<<hc|sc;ec=hc+8|0;if((ec|0)<(Ac|0)){rc=Oe;sc=nc;ic=oc;hc=ec}else{Qe=nc;Re=oc;Se=ec;break}}}else{Qe=vc;Re=wc;Se=lc}hc=Qe&qc;ic=Qe>>Ac;sc=Se-Ac|0;if((hc|0)==(Cc|0)){Jc=ic;Hc=1;Dc=Re;Fc=sc;continue x}if((hc|0)==(Ic|0)){ga=593;break x}if((hc|0)>(pc|0)){ga=620;break x}if(!Hc){ga=610;break x}if(!((mc|0)>-1)){if((hc|0)==(pc|0)){ga=618;break x}else{Te=pc}}else{rc=pc+1|0;if((pc|0)>4095){ga=613;break x}b[m+(pc<<2)+2080>>1]=mc;ma=a[m+(mc<<2)+2082>>0]|0;a[m+(pc<<2)+2082>>0]=ma;if((hc|0)==(rc|0)){Ue=ma}else{Ue=a[m+(hc<<2)+2082>>0]|0}a[m+(pc<<2)+2083>>0]=Ue;Te=rc}Mk(m,hc&65535);if((Te&qc|0)==0&(Te|0)<4096){Ec=Te;yc=ic;xc=Ac;uc=Re;tc=hc;zc=sc;continue y}else{pc=Te;vc=ic;wc=Re;mc=hc;lc=sc}}}}z:do{if((ga|0)==593){do{if((c[xb>>2]|0)==0){Ve=c[x>>2]|0;ga=597}else{Hc=c[t>>2]|0;Ic=c[x>>2]|0;Fc=Hc-Ic|0;if((Fc|0)>=(Re|0)){Ve=Ic;ga=597;break}c[x>>2]=Hc;Md[c[Nc>>2]&63](c[lb>>2]|0,Re-Fc|0)}}while(0);if((ga|0)==597){c[x>>2]=Ve+Re}A:while(1){Fc=c[x>>2]|0;do{if(!(Fc>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){break z}Hc=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Hc|0)==0){c[yb>>2]=0;Ic=(c[t>>2]|0)+ -1|0;c[x>>2]=Ic;a[Ic>>0]=0;We=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+Hc+40;We=pb;break}}else{We=Fc}}while(0);Fc=We+1|0;c[x>>2]=Fc;Hc=a[We>>0]|0;Ic=Hc&255;if(Hc<<24>>24==0){break z}do{if((c[xb>>2]|0)!=0){Hc=c[t>>2]|0;Dc=Hc-Fc|0;if((Dc|0)>=(Ic|0)){break}c[x>>2]=Hc;Md[c[Nc>>2]&63](c[lb>>2]|0,Ic-Dc|0);continue A}}while(0);c[x>>2]=We+(Ic+1)}}else if((ga|0)==610){c[6510]=28944;$c=0;break s}else if((ga|0)==613){c[6510]=28960;$c=0;break s}else if((ga|0)==618){c[6510]=28976;$c=0;break s}else if((ga|0)==620){c[6510]=28976;$c=0;break s}}while(0);Fc=c[Lc>>2]|0;if((Fc|0)==0){$c=0;break s}if((k|0)==0|(k|0)==4){$c=Fc;break s}$c=Lk(Fc,4,k,c[m>>2]|0,c[Qc>>2]|0)|0;break s}}while(0);c[6510]=28880;$c=0}}while(0);Lc=($c|0)==1?0:$c;if((Lc|0)==0){y=0;i=l;return y|0}c[f>>2]=c[m>>2];c[h>>2]=c[m+4>>2];y=Lc;i=l;return y|0}else{Zc=vb}}else{ga=444}}else{ga=444}}else{ga=444}}else{ga=444}}else{ga=444}}}while(0);if((ga|0)==444){$c=c[v>>2]|0;c[x>>2]=$c;Zc=$c}$c=c[t>>2]|0;if(!(Zc>>>0<$c>>>0)){if((c[yb>>2]|0)==0){Xe=0;Ye=Zc;Ze=$c}else{We=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((We|0)==0){c[yb>>2]=0;Re=(c[t>>2]|0)+ -1|0;c[x>>2]=Re;a[Re>>0]=0;_e=c[t>>2]|0;$e=c[x>>2]|0}else{c[x>>2]=pb;Re=e+We+40|0;c[t>>2]=Re;_e=Re;$e=pb}Re=$e+1|0;c[x>>2]=Re;Xe=d[$e>>0]|0;Ye=Re;Ze=_e}}else{_e=Zc+1|0;c[x>>2]=_e;Xe=d[Zc>>0]|0;Ye=_e;Ze=$c}$c=Xe<<8;if(!(Ye>>>0<Ze>>>0)){if((c[yb>>2]|0)==0){af=0;bf=Ye;cf=Ze}else{Xe=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Xe|0)==0){c[yb>>2]=0;_e=(c[t>>2]|0)+ -1|0;c[x>>2]=_e;a[_e>>0]=0;df=c[t>>2]|0;ef=c[x>>2]|0}else{c[x>>2]=pb;_e=e+Xe+40|0;c[t>>2]=_e;df=_e;ef=pb}_e=ef+1|0;c[x>>2]=_e;af=d[ef>>0]|0;bf=_e;cf=df}}else{df=Ye+1|0;c[x>>2]=df;af=d[Ye>>0]|0;bf=df;cf=Ze}Ze=(af|$c)<<16;if(!(bf>>>0<cf>>>0)){if((c[yb>>2]|0)==0){ff=0;gf=bf;hf=cf}else{$c=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if(($c|0)==0){c[yb>>2]=0;af=(c[t>>2]|0)+ -1|0;c[x>>2]=af;a[af>>0]=0;jf=c[t>>2]|0;kf=c[x>>2]|0}else{c[x>>2]=pb;af=e+$c+40|0;c[t>>2]=af;jf=af;kf=pb}af=kf+1|0;c[x>>2]=af;ff=d[kf>>0]|0;gf=af;hf=jf}}else{jf=bf+1|0;c[x>>2]=jf;ff=d[bf>>0]|0;gf=jf;hf=cf}cf=ff<<8;if(!(gf>>>0<hf>>>0)){if((c[yb>>2]|0)==0){lf=0}else{hf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((hf|0)==0){c[yb>>2]=0;ff=(c[t>>2]|0)+ -1|0;c[x>>2]=ff;a[ff>>0]=0;mf=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+hf+40;mf=pb}c[x>>2]=mf+1;lf=d[mf>>0]|0}}else{c[x>>2]=gf+1;lf=d[gf>>0]|0}gf=c[v>>2]|0;c[x>>2]=gf;if((cf|Ze|lf|0)==943870035){lf=c[t>>2]|0;if(!(gf>>>0<lf>>>0)){if((c[yb>>2]|0)==0){nf=0;of=gf;pf=lf}else{Ze=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ze|0)==0){c[yb>>2]=0;cf=(c[t>>2]|0)+ -1|0;c[x>>2]=cf;a[cf>>0]=0;qf=c[t>>2]|0;rf=c[x>>2]|0}else{c[x>>2]=pb;cf=e+Ze+40|0;c[t>>2]=cf;qf=cf;rf=pb}cf=rf+1|0;c[x>>2]=cf;nf=d[rf>>0]|0;of=cf;pf=qf}}else{qf=gf+1|0;c[x>>2]=qf;nf=d[gf>>0]|0;of=qf;pf=lf}lf=nf<<8;if(!(of>>>0<pf>>>0)){if((c[yb>>2]|0)==0){sf=0;tf=of;uf=pf}else{nf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((nf|0)==0){c[yb>>2]=0;qf=(c[t>>2]|0)+ -1|0;c[x>>2]=qf;a[qf>>0]=0;vf=c[t>>2]|0;wf=c[x>>2]|0}else{c[x>>2]=pb;qf=e+nf+40|0;c[t>>2]=qf;vf=qf;wf=pb}qf=wf+1|0;c[x>>2]=qf;sf=d[wf>>0]|0;tf=qf;uf=vf}}else{vf=of+1|0;c[x>>2]=vf;sf=d[of>>0]|0;tf=vf;uf=pf}pf=(sf|lf)<<16;if(!(tf>>>0<uf>>>0)){if((c[yb>>2]|0)==0){xf=0;yf=tf;zf=uf}else{lf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((lf|0)==0){c[yb>>2]=0;sf=(c[t>>2]|0)+ -1|0;c[x>>2]=sf;a[sf>>0]=0;Af=c[t>>2]|0;Bf=c[x>>2]|0}else{c[x>>2]=pb;sf=e+lf+40|0;c[t>>2]=sf;Af=sf;Bf=pb}sf=Bf+1|0;c[x>>2]=sf;xf=d[Bf>>0]|0;yf=sf;zf=Af}}else{Af=tf+1|0;c[x>>2]=Af;xf=d[tf>>0]|0;yf=Af;zf=uf}uf=xf<<8;if(!(yf>>>0<zf>>>0)){if((c[yb>>2]|0)==0){Cf=0;Df=yf}else{zf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((zf|0)==0){c[yb>>2]=0;xf=(c[t>>2]|0)+ -1|0;c[x>>2]=xf;a[xf>>0]=0;Ef=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+zf+40;Ef=pb}zf=Ef+1|0;c[x>>2]=zf;Cf=d[Ef>>0]|0;Df=zf}}else{zf=yf+1|0;c[x>>2]=zf;Cf=d[yf>>0]|0;Df=zf}if((uf|pf|Cf|0)!=943870035){c[6510]=28784;y=0;i=l;return y|0}Cf=c[t>>2]|0;if(!(Df>>>0<Cf>>>0)){if((c[yb>>2]|0)==0){Ff=0;Gf=Df;Hf=Cf}else{pf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((pf|0)==0){c[yb>>2]=0;uf=(c[t>>2]|0)+ -1|0;c[x>>2]=uf;a[uf>>0]=0;If=c[t>>2]|0;Jf=c[x>>2]|0}else{c[x>>2]=pb;uf=e+pf+40|0;c[t>>2]=uf;If=uf;Jf=pb}uf=Jf+1|0;c[x>>2]=uf;Ff=d[Jf>>0]|0;Gf=uf;Hf=If}}else{If=Df+1|0;c[x>>2]=If;Ff=d[Df>>0]|0;Gf=If;Hf=Cf}Cf=Ff<<8;if(!(Gf>>>0<Hf>>>0)){if((c[yb>>2]|0)==0){Kf=0;Lf=Gf}else{Hf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Hf|0)==0){c[yb>>2]=0;Ff=(c[t>>2]|0)+ -1|0;c[x>>2]=Ff;a[Ff>>0]=0;Mf=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Hf+40;Mf=pb}Hf=Mf+1|0;c[x>>2]=Hf;Kf=d[Mf>>0]|0;Lf=Hf}}else{Hf=Gf+1|0;c[x>>2]=Hf;Kf=d[Gf>>0]|0;Lf=Hf}if((Kf|Cf|0)!=1){c[6510]=28792;y=0;i=l;return y|0}if((c[xb>>2]|0)!=0?(Cf=c[t>>2]|0,Kf=Cf-Lf|0,(Kf|0)<6):0){c[x>>2]=Cf;Md[c[e+20>>2]&63](c[lb>>2]|0,6-Kf|0);Nf=c[x>>2]|0}else{Kf=Lf+6|0;c[x>>2]=Kf;Nf=Kf}Kf=c[t>>2]|0;do{if(Nf>>>0<Kf>>>0){Lf=Nf+1|0;c[x>>2]=Lf;Of=d[Nf>>0]|0;Pf=Lf;Qf=Kf}else{if((c[yb>>2]|0)==0){Of=0;Pf=Nf;Qf=Kf;break}Lf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Lf|0)==0){c[yb>>2]=0;Cf=(c[t>>2]|0)+ -1|0;c[x>>2]=Cf;a[Cf>>0]=0;Rf=c[t>>2]|0;Sf=c[x>>2]|0}else{c[x>>2]=pb;Cf=e+Lf+40|0;c[t>>2]=Cf;Rf=Cf;Sf=pb}Cf=Sf+1|0;c[x>>2]=Cf;Of=d[Sf>>0]|0;Pf=Cf;Qf=Rf}}while(0);Rf=Of<<8;do{if(Pf>>>0<Qf>>>0){Of=Pf+1|0;c[x>>2]=Of;Tf=d[Pf>>0]|0;Uf=Of}else{if((c[yb>>2]|0)==0){Tf=0;Uf=Pf;break}Of=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Of|0)==0){c[yb>>2]=0;Sf=(c[t>>2]|0)+ -1|0;c[x>>2]=Sf;a[Sf>>0]=0;Vf=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Of+40;Vf=pb}Of=Vf+1|0;c[x>>2]=Of;Tf=d[Vf>>0]|0;Uf=Of}}while(0);Vf=Tf|Rf;if(Vf>>>0>16){c[6510]=28808;y=0;i=l;return y|0}Rf=c[t>>2]|0;do{if(Uf>>>0<Rf>>>0){Tf=Uf+1|0;c[x>>2]=Tf;Wf=d[Uf>>0]|0;Xf=Tf;Yf=Rf}else{if((c[yb>>2]|0)==0){Wf=0;Xf=Uf;Yf=Rf;break}Tf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Tf|0)==0){c[yb>>2]=0;Pf=(c[t>>2]|0)+ -1|0;c[x>>2]=Pf;a[Pf>>0]=0;Zf=c[t>>2]|0;_f=c[x>>2]|0}else{c[x>>2]=pb;Pf=e+Tf+40|0;c[t>>2]=Pf;Zf=Pf;_f=pb}Pf=_f+1|0;c[x>>2]=Pf;Wf=d[_f>>0]|0;Xf=Pf;Yf=Zf}}while(0);Zf=Wf<<8;do{if(Xf>>>0<Yf>>>0){Wf=Xf+1|0;c[x>>2]=Wf;$f=d[Xf>>0]|0;ag=Wf;bg=Yf}else{if((c[yb>>2]|0)==0){$f=0;ag=Xf;bg=Yf;break}Wf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Wf|0)==0){c[yb>>2]=0;_f=(c[t>>2]|0)+ -1|0;c[x>>2]=_f;a[_f>>0]=0;cg=c[t>>2]|0;dg=c[x>>2]|0}else{c[x>>2]=pb;_f=e+Wf+40|0;c[t>>2]=_f;cg=_f;dg=pb}_f=dg+1|0;c[x>>2]=_f;$f=d[dg>>0]|0;ag=_f;bg=cg}}while(0);cg=($f|Zf)<<16;do{if(ag>>>0<bg>>>0){Zf=ag+1|0;c[x>>2]=Zf;eg=d[ag>>0]|0;fg=Zf;gg=bg}else{if((c[yb>>2]|0)==0){eg=0;fg=ag;gg=bg;break}Zf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Zf|0)==0){c[yb>>2]=0;$f=(c[t>>2]|0)+ -1|0;c[x>>2]=$f;a[$f>>0]=0;hg=c[t>>2]|0;ig=c[x>>2]|0}else{c[x>>2]=pb;$f=e+Zf+40|0;c[t>>2]=$f;hg=$f;ig=pb}$f=ig+1|0;c[x>>2]=$f;eg=d[ig>>0]|0;fg=$f;gg=hg}}while(0);hg=eg<<8;do{if(fg>>>0<gg>>>0){eg=fg+1|0;c[x>>2]=eg;jg=d[fg>>0]|0;kg=eg;lg=gg}else{if((c[yb>>2]|0)==0){jg=0;kg=fg;lg=gg;break}eg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((eg|0)==0){c[yb>>2]=0;ig=(c[t>>2]|0)+ -1|0;c[x>>2]=ig;a[ig>>0]=0;mg=c[t>>2]|0;ng=c[x>>2]|0}else{c[x>>2]=pb;ig=e+eg+40|0;c[t>>2]=ig;mg=ig;ng=pb}ig=ng+1|0;c[x>>2]=ig;jg=d[ng>>0]|0;kg=ig;lg=mg}}while(0);mg=hg|cg|jg;do{if(kg>>>0<lg>>>0){jg=kg+1|0;c[x>>2]=jg;og=d[kg>>0]|0;pg=jg;qg=lg}else{if((c[yb>>2]|0)==0){og=0;pg=kg;qg=lg;break}jg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((jg|0)==0){c[yb>>2]=0;cg=(c[t>>2]|0)+ -1|0;c[x>>2]=cg;a[cg>>0]=0;rg=c[t>>2]|0;sg=c[x>>2]|0}else{c[x>>2]=pb;cg=e+jg+40|0;c[t>>2]=cg;rg=cg;sg=pb}cg=sg+1|0;c[x>>2]=cg;og=d[sg>>0]|0;pg=cg;qg=rg}}while(0);rg=og<<8;do{if(pg>>>0<qg>>>0){og=pg+1|0;c[x>>2]=og;tg=d[pg>>0]|0;ug=og;vg=qg}else{if((c[yb>>2]|0)==0){tg=0;ug=pg;vg=qg;break}og=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((og|0)==0){c[yb>>2]=0;sg=(c[t>>2]|0)+ -1|0;c[x>>2]=sg;a[sg>>0]=0;wg=c[t>>2]|0;xg=c[x>>2]|0}else{c[x>>2]=pb;sg=e+og+40|0;c[t>>2]=sg;wg=sg;xg=pb}sg=xg+1|0;c[x>>2]=sg;tg=d[xg>>0]|0;ug=sg;vg=wg}}while(0);wg=(tg|rg)<<16;do{if(ug>>>0<vg>>>0){rg=ug+1|0;c[x>>2]=rg;yg=d[ug>>0]|0;zg=rg;Ag=vg}else{if((c[yb>>2]|0)==0){yg=0;zg=ug;Ag=vg;break}rg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((rg|0)==0){c[yb>>2]=0;tg=(c[t>>2]|0)+ -1|0;c[x>>2]=tg;a[tg>>0]=0;Bg=c[t>>2]|0;Cg=c[x>>2]|0}else{c[x>>2]=pb;tg=e+rg+40|0;c[t>>2]=tg;Bg=tg;Cg=pb}tg=Cg+1|0;c[x>>2]=tg;yg=d[Cg>>0]|0;zg=tg;Ag=Bg}}while(0);Bg=yg<<8;do{if(zg>>>0<Ag>>>0){yg=zg+1|0;c[x>>2]=yg;Dg=d[zg>>0]|0;Eg=yg;Fg=Ag}else{if((c[yb>>2]|0)==0){Dg=0;Eg=zg;Fg=Ag;break}yg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((yg|0)==0){c[yb>>2]=0;Cg=(c[t>>2]|0)+ -1|0;c[x>>2]=Cg;a[Cg>>0]=0;Gg=c[t>>2]|0;Hg=c[x>>2]|0}else{c[x>>2]=pb;Cg=e+yg+40|0;c[t>>2]=Cg;Gg=Cg;Hg=pb}Cg=Hg+1|0;c[x>>2]=Cg;Dg=d[Hg>>0]|0;Eg=Cg;Fg=Gg}}while(0);Gg=Bg|wg|Dg;do{if(Eg>>>0<Fg>>>0){Dg=Eg+1|0;c[x>>2]=Dg;Ig=d[Eg>>0]|0;Jg=Dg;Kg=Fg}else{if((c[yb>>2]|0)==0){Ig=0;Jg=Eg;Kg=Fg;break}Dg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Dg|0)==0){c[yb>>2]=0;wg=(c[t>>2]|0)+ -1|0;c[x>>2]=wg;a[wg>>0]=0;Lg=c[t>>2]|0;Mg=c[x>>2]|0}else{c[x>>2]=pb;wg=e+Dg+40|0;c[t>>2]=wg;Lg=wg;Mg=pb}wg=Mg+1|0;c[x>>2]=wg;Ig=d[Mg>>0]|0;Jg=wg;Kg=Lg}}while(0);Lg=Ig<<8;do{if(Jg>>>0<Kg>>>0){Ig=Jg+1|0;c[x>>2]=Ig;Ng=d[Jg>>0]|0;Og=Ig}else{if((c[yb>>2]|0)==0){Ng=0;Og=Jg;break}Ig=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ig|0)==0){c[yb>>2]=0;Mg=(c[t>>2]|0)+ -1|0;c[x>>2]=Mg;a[Mg>>0]=0;Pg=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Ig+40;Pg=pb}Ig=Pg+1|0;c[x>>2]=Ig;Ng=d[Pg>>0]|0;Og=Ig}}while(0);if((Ng|Lg|0)!=8){c[6510]=28832;y=0;i=l;return y|0}Lg=c[t>>2]|0;do{if(Og>>>0<Lg>>>0){Ng=Og+1|0;c[x>>2]=Ng;Qg=d[Og>>0]|0;Rg=Ng;Sg=Lg}else{if((c[yb>>2]|0)==0){Qg=0;Rg=Og;Sg=Lg;break}Ng=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ng|0)==0){c[yb>>2]=0;Pg=(c[t>>2]|0)+ -1|0;c[x>>2]=Pg;a[Pg>>0]=0;Tg=c[t>>2]|0;Ug=c[x>>2]|0}else{c[x>>2]=pb;Pg=e+Ng+40|0;c[t>>2]=Pg;Tg=Pg;Ug=pb}Pg=Ug+1|0;c[x>>2]=Pg;Qg=d[Ug>>0]|0;Rg=Pg;Sg=Tg}}while(0);Tg=Qg<<8;do{if(Rg>>>0<Sg>>>0){Qg=Rg+1|0;c[x>>2]=Qg;Vg=d[Rg>>0]|0;Wg=Qg}else{if((c[yb>>2]|0)==0){Vg=0;Wg=Rg;break}Qg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Qg|0)==0){c[yb>>2]=0;Ug=(c[t>>2]|0)+ -1|0;c[x>>2]=Ug;a[Ug>>0]=0;Xg=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Qg+40;Xg=pb}Qg=Xg+1|0;c[x>>2]=Qg;Vg=d[Xg>>0]|0;Wg=Qg}}while(0);if((Vg|Tg|0)!=3){c[6510]=28856;y=0;i=l;return y|0}Tg=c[t>>2]|0;do{if(Wg>>>0<Tg>>>0){Vg=Wg+1|0;c[x>>2]=Vg;Yg=d[Wg>>0]|0;Zg=Vg;_g=Tg}else{if((c[yb>>2]|0)==0){Yg=0;Zg=Wg;_g=Tg;break}Vg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Vg|0)==0){c[yb>>2]=0;Xg=(c[t>>2]|0)+ -1|0;c[x>>2]=Xg;a[Xg>>0]=0;$g=c[t>>2]|0;ah=c[x>>2]|0}else{c[x>>2]=pb;Xg=e+Vg+40|0;c[t>>2]=Xg;$g=Xg;ah=pb}Xg=ah+1|0;c[x>>2]=Xg;Yg=d[ah>>0]|0;Zg=Xg;_g=$g}}while(0);$g=Yg<<8;do{if(Zg>>>0<_g>>>0){Yg=Zg+1|0;c[x>>2]=Yg;bh=d[Zg>>0]|0;ch=Yg;dh=_g}else{if((c[yb>>2]|0)==0){bh=0;ch=Zg;dh=_g;break}Yg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Yg|0)==0){c[yb>>2]=0;ah=(c[t>>2]|0)+ -1|0;c[x>>2]=ah;a[ah>>0]=0;eh=c[t>>2]|0;fh=c[x>>2]|0}else{c[x>>2]=pb;ah=e+Yg+40|0;c[t>>2]=ah;eh=ah;fh=pb}ah=fh+1|0;c[x>>2]=ah;bh=d[fh>>0]|0;ch=ah;dh=eh}}while(0);eh=(bh|$g)<<16;do{if(ch>>>0<dh>>>0){$g=ch+1|0;c[x>>2]=$g;gh=d[ch>>0]|0;hh=$g;ih=dh}else{if((c[yb>>2]|0)==0){gh=0;hh=ch;ih=dh;break}$g=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if(($g|0)==0){c[yb>>2]=0;bh=(c[t>>2]|0)+ -1|0;c[x>>2]=bh;a[bh>>0]=0;jh=c[t>>2]|0;kh=c[x>>2]|0}else{c[x>>2]=pb;bh=e+$g+40|0;c[t>>2]=bh;jh=bh;kh=pb}bh=kh+1|0;c[x>>2]=bh;gh=d[kh>>0]|0;hh=bh;ih=jh}}while(0);jh=gh<<8;do{if(hh>>>0<ih>>>0){gh=hh+1|0;c[x>>2]=gh;lh=d[hh>>0]|0;mh=gh}else{if((c[yb>>2]|0)==0){lh=0;mh=hh;break}gh=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((gh|0)==0){c[yb>>2]=0;kh=(c[t>>2]|0)+ -1|0;c[x>>2]=kh;a[kh>>0]=0;nh=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+gh+40;nh=pb}gh=nh+1|0;c[x>>2]=gh;lh=d[nh>>0]|0;mh=gh}}while(0);nh=jh|eh|lh;do{if((c[xb>>2]|0)==0){ga=897}else{lh=c[t>>2]|0;eh=lh-mh|0;if((eh|0)>=(nh|0)){ga=897;break}c[x>>2]=lh;Md[c[e+20>>2]&63](c[lb>>2]|0,nh-eh|0);oh=c[x>>2]|0}}while(0);if((ga|0)==897){eh=mh+nh|0;c[x>>2]=eh;oh=eh}eh=c[t>>2]|0;do{if(oh>>>0<eh>>>0){nh=oh+1|0;c[x>>2]=nh;ph=d[oh>>0]|0;qh=nh;rh=eh}else{if((c[yb>>2]|0)==0){ph=0;qh=oh;rh=eh;break}nh=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((nh|0)==0){c[yb>>2]=0;mh=(c[t>>2]|0)+ -1|0;c[x>>2]=mh;a[mh>>0]=0;sh=c[t>>2]|0;th=c[x>>2]|0}else{c[x>>2]=pb;mh=e+nh+40|0;c[t>>2]=mh;sh=mh;th=pb}mh=th+1|0;c[x>>2]=mh;ph=d[th>>0]|0;qh=mh;rh=sh}}while(0);sh=ph<<8;do{if(qh>>>0<rh>>>0){ph=qh+1|0;c[x>>2]=ph;uh=d[qh>>0]|0;vh=ph;wh=rh}else{if((c[yb>>2]|0)==0){uh=0;vh=qh;wh=rh;break}ph=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ph|0)==0){c[yb>>2]=0;th=(c[t>>2]|0)+ -1|0;c[x>>2]=th;a[th>>0]=0;xh=c[t>>2]|0;yh=c[x>>2]|0}else{c[x>>2]=pb;th=e+ph+40|0;c[t>>2]=th;xh=th;yh=pb}th=yh+1|0;c[x>>2]=th;uh=d[yh>>0]|0;vh=th;wh=xh}}while(0);xh=(uh|sh)<<16;do{if(vh>>>0<wh>>>0){sh=vh+1|0;c[x>>2]=sh;zh=d[vh>>0]|0;Ah=sh;Bh=wh}else{if((c[yb>>2]|0)==0){zh=0;Ah=vh;Bh=wh;break}sh=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((sh|0)==0){c[yb>>2]=0;uh=(c[t>>2]|0)+ -1|0;c[x>>2]=uh;a[uh>>0]=0;Ch=c[t>>2]|0;Dh=c[x>>2]|0}else{c[x>>2]=pb;uh=e+sh+40|0;c[t>>2]=uh;Ch=uh;Dh=pb}uh=Dh+1|0;c[x>>2]=uh;zh=d[Dh>>0]|0;Ah=uh;Bh=Ch}}while(0);Ch=zh<<8;do{if(Ah>>>0<Bh>>>0){zh=Ah+1|0;c[x>>2]=zh;Eh=d[Ah>>0]|0;Fh=zh}else{if((c[yb>>2]|0)==0){Eh=0;Fh=Ah;break}zh=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((zh|0)==0){c[yb>>2]=0;Dh=(c[t>>2]|0)+ -1|0;c[x>>2]=Dh;a[Dh>>0]=0;Gh=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+zh+40;Gh=pb}zh=Gh+1|0;c[x>>2]=zh;Eh=d[Gh>>0]|0;Fh=zh}}while(0);Gh=Ch|xh|Eh;do{if((c[xb>>2]|0)==0){ga=929}else{Eh=c[t>>2]|0;xh=Eh-Fh|0;if((xh|0)>=(Gh|0)){ga=929;break}c[x>>2]=Eh;Md[c[e+20>>2]&63](c[lb>>2]|0,Gh-xh|0);Hh=c[x>>2]|0}}while(0);if((ga|0)==929){xh=Fh+Gh|0;c[x>>2]=xh;Hh=xh}xh=c[t>>2]|0;do{if(Hh>>>0<xh>>>0){Gh=Hh+1|0;c[x>>2]=Gh;Ih=d[Hh>>0]|0;Jh=Gh;Kh=xh}else{if((c[yb>>2]|0)==0){Ih=0;Jh=Hh;Kh=xh;break}Gh=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Gh|0)==0){c[yb>>2]=0;Fh=(c[t>>2]|0)+ -1|0;c[x>>2]=Fh;a[Fh>>0]=0;Lh=c[t>>2]|0;Mh=c[x>>2]|0}else{c[x>>2]=pb;Fh=e+Gh+40|0;c[t>>2]=Fh;Lh=Fh;Mh=pb}Fh=Mh+1|0;c[x>>2]=Fh;Ih=d[Mh>>0]|0;Jh=Fh;Kh=Lh}}while(0);Lh=Ih<<8;do{if(Jh>>>0<Kh>>>0){Ih=Jh+1|0;c[x>>2]=Ih;Nh=d[Jh>>0]|0;Oh=Ih;Ph=Kh}else{if((c[yb>>2]|0)==0){Nh=0;Oh=Jh;Ph=Kh;break}Ih=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ih|0)==0){c[yb>>2]=0;Mh=(c[t>>2]|0)+ -1|0;c[x>>2]=Mh;a[Mh>>0]=0;Qh=c[t>>2]|0;Rh=c[x>>2]|0}else{c[x>>2]=pb;Mh=e+Ih+40|0;c[t>>2]=Mh;Qh=Mh;Rh=pb}Mh=Rh+1|0;c[x>>2]=Mh;Nh=d[Rh>>0]|0;Oh=Mh;Ph=Qh}}while(0);Qh=(Nh|Lh)<<16;do{if(Oh>>>0<Ph>>>0){Lh=Oh+1|0;c[x>>2]=Lh;Sh=d[Oh>>0]|0;Th=Lh;Uh=Ph}else{if((c[yb>>2]|0)==0){Sh=0;Th=Oh;Uh=Ph;break}Lh=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Lh|0)==0){c[yb>>2]=0;Nh=(c[t>>2]|0)+ -1|0;c[x>>2]=Nh;a[Nh>>0]=0;Vh=c[t>>2]|0;Wh=c[x>>2]|0}else{c[x>>2]=pb;Nh=e+Lh+40|0;c[t>>2]=Nh;Vh=Nh;Wh=pb}Nh=Wh+1|0;c[x>>2]=Nh;Sh=d[Wh>>0]|0;Th=Nh;Uh=Vh}}while(0);Vh=Sh<<8;do{if(Th>>>0<Uh>>>0){Sh=Th+1|0;c[x>>2]=Sh;Xh=d[Th>>0]|0;Yh=Sh}else{if((c[yb>>2]|0)==0){Xh=0;Yh=Th;break}Sh=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Sh|0)==0){c[yb>>2]=0;Wh=(c[t>>2]|0)+ -1|0;c[x>>2]=Wh;a[Wh>>0]=0;Zh=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Sh+40;Zh=pb}Sh=Zh+1|0;c[x>>2]=Sh;Xh=d[Zh>>0]|0;Yh=Sh}}while(0);Zh=Vh|Qh|Xh;do{if((c[xb>>2]|0)==0){ga=961}else{Xh=c[t>>2]|0;Qh=Xh-Yh|0;if((Qh|0)>=(Zh|0)){ga=961;break}c[x>>2]=Xh;Md[c[e+20>>2]&63](c[lb>>2]|0,Zh-Qh|0);_h=c[x>>2]|0}}while(0);if((ga|0)==961){Qh=Yh+Zh|0;c[x>>2]=Qh;_h=Qh}Qh=c[t>>2]|0;do{if(_h>>>0<Qh>>>0){Zh=_h+1|0;c[x>>2]=Zh;$h=d[_h>>0]|0;ai=Zh;bi=Qh}else{if((c[yb>>2]|0)==0){$h=0;ai=_h;bi=Qh;break}Zh=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Zh|0)==0){c[yb>>2]=0;Yh=(c[t>>2]|0)+ -1|0;c[x>>2]=Yh;a[Yh>>0]=0;ci=c[t>>2]|0;di=c[x>>2]|0}else{c[x>>2]=pb;Yh=e+Zh+40|0;c[t>>2]=Yh;ci=Yh;di=pb}Yh=di+1|0;c[x>>2]=Yh;$h=d[di>>0]|0;ai=Yh;bi=ci}}while(0);ci=$h<<8;do{if(ai>>>0<bi>>>0){$h=ai+1|0;c[x>>2]=$h;ei=d[ai>>0]|0;fi=$h}else{if((c[yb>>2]|0)==0){ei=0;fi=ai;break}$h=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if(($h|0)==0){c[yb>>2]=0;di=(c[t>>2]|0)+ -1|0;c[x>>2]=di;a[di>>0]=0;gi=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+$h+40;gi=pb}$h=gi+1|0;c[x>>2]=$h;ei=d[gi>>0]|0;fi=$h}}while(0);gi=ei|ci;if(gi>>>0>1){c[6510]=28648;y=0;i=l;return y|0}ci=Ll(da(mg<<2,Gg)|0)|0;if((ci|0)==0){c[6510]=26456;y=0;i=l;return y|0}ei=da(Gg,mg)|0;if((gi|0)==0){gi=(ei|0)>0;ai=0;do{bi=ci+ai|0;B:do{if((ai|0)>(Vf|0)){if(!gi){break}$h=((ai|0)==3)<<31>>31;di=0;Qh=bi;while(1){a[Qh>>0]=$h;di=di+1|0;if((di|0)==(ei|0)){break}else{Qh=Qh+4|0}}}else{if(gi){hi=1;ii=bi}else{break}while(1){Qh=c[x>>2]|0;do{if(Qh>>>0<(c[t>>2]|0)>>>0){c[x>>2]=Qh+1;ji=d[Qh>>0]|0}else{if((c[yb>>2]|0)==0){ji=0;break}di=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((di|0)==0){c[yb>>2]=0;$h=(c[t>>2]|0)+ -1|0;c[x>>2]=$h;a[$h>>0]=0;ki=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+di+40;ki=pb}c[x>>2]=ki+1;ji=d[ki>>0]|0}}while(0);a[ii>>0]=ji;if((hi|0)==(ei|0)){break B}hi=hi+1|0;ii=ii+4|0}}}while(0);ai=ai+1|0}while((ai|0)!=4)}else{ai=da(mg,Vf<<1)|0;do{if((c[xb>>2]|0)==0){ga=985}else{ii=c[t>>2]|0;hi=ii-fi|0;if((hi|0)>=(ai|0)){ga=985;break}c[x>>2]=ii;Md[c[e+20>>2]&63](c[lb>>2]|0,ai-hi|0)}}while(0);if((ga|0)==985){c[x>>2]=fi+ai}ai=(ei|0)>0;fi=0;do{hi=ci+fi|0;C:do{if((fi|0)<(Vf|0)){ii=0;ji=hi;while(1){ki=(ii|0)<(ei|0);D:while(1){if(!ki){break C}gi=c[x>>2]|0;do{if(!(gi>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){li=0;mi=gi;ga=1003;break D}bi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((bi|0)==0){c[yb>>2]=0;vb=(c[t>>2]|0)+ -1|0;c[x>>2]=vb;a[vb>>0]=0;ni=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+bi+40;ni=pb;break}}else{ni=gi}}while(0);oi=ni+1|0;c[x>>2]=oi;pi=a[ni>>0]|0;qi=pi&255;if(!(pi<<24>>24==-128)){ga=1002;break}}do{if((ga|0)==1002){ga=0;if(pi<<24>>24>-1){li=qi;mi=oi;ga=1003;break}ki=257-qi|0;do{if(oi>>>0<(c[t>>2]|0)>>>0){c[x>>2]=ni+2;ri=d[oi>>0]|0}else{if((c[yb>>2]|0)==0){ri=0;break}gi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((gi|0)==0){c[yb>>2]=0;bi=(c[t>>2]|0)+ -1|0;c[x>>2]=bi;a[bi>>0]=0;si=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+gi+40;si=pb}c[x>>2]=si+1;ri=d[si>>0]|0}}while(0);gi=ri&255;bi=ki;vb=ji;while(1){a[vb>>0]=gi;bi=bi+ -1|0;if((bi|0)==0){break}else{vb=vb+4|0}}ti=ki;ui=(da(qi,-4)|0)+1028|0}}while(0);if((ga|0)==1003){ga=0;vb=li+1|0;bi=mi;gi=vb;Qh=ji;while(1){do{if(bi>>>0<(c[t>>2]|0)>>>0){c[x>>2]=bi+1;vi=d[bi>>0]|0}else{if((c[yb>>2]|0)==0){vi=0;break}di=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((di|0)==0){c[yb>>2]=0;$h=(c[t>>2]|0)+ -1|0;c[x>>2]=$h;a[$h>>0]=0;wi=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+di+40;wi=pb}c[x>>2]=wi+1;vi=d[wi>>0]|0}}while(0);a[Qh>>0]=vi;ki=gi+ -1|0;if((ki|0)==0){break}bi=c[x>>2]|0;gi=ki;Qh=Qh+4|0}ti=vb;ui=(li<<2)+4|0}ii=ti+ii|0;ji=ji+ui|0}}else{if(!ai){break}ji=((fi|0)==3)<<31>>31;ii=0;Qh=hi;while(1){a[Qh>>0]=ji;ii=ii+1|0;if((ii|0)==(ei|0)){break}else{Qh=Qh+4|0}}}}while(0);fi=fi+1|0}while((fi|0)!=4)}do{if((k|0)==0|(k|0)==4){xi=ci}else{fi=Lk(ci,4,k,Gg,mg)|0;if((fi|0)==0){y=0}else{xi=fi;break}i=l;return y|0}}while(0);if((j|0)!=0){c[j>>2]=Vf}c[h>>2]=mg;c[f>>2]=Gg;y=xi;i=l;return y|0}else{yi=gf;zi=0}while(1){if(!(yi>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){Ai=0;Bi=yi}else{gf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((gf|0)==0){c[yb>>2]=0;xi=(c[t>>2]|0)+ -1|0;c[x>>2]=xi;a[xi>>0]=0;Ci=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+gf+40;Ci=pb}gf=Ci+1|0;c[x>>2]=gf;Ai=d[Ci>>0]|0;Bi=gf}}else{gf=yi+1|0;c[x>>2]=gf;Ai=d[yi>>0]|0;Bi=gf}if((Ai|0)!=(d[28768+zi>>0]|0)){break}zi=zi+1|0;if((zi|0)>=4){Di=Bi;Ei=1;ga=1052;break}else{yi=Bi}}E:do{if((ga|0)==1052){while(1){ga=0;if(!(Di>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){Fi=Di}else{Bi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Bi|0)==0){c[yb>>2]=0;yi=(c[t>>2]|0)+ -1|0;c[x>>2]=yi;a[yi>>0]=0;Gi=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Bi+40;Gi=pb}Bi=Gi+1|0;c[x>>2]=Bi;Fi=Bi}}else{Bi=Di+1|0;c[x>>2]=Bi;Fi=Bi}if((Ei|0)==84){Hi=Fi;Ii=0;break}Di=Fi;Ei=Ei+1|0;ga=1052}while(1){if(!(Hi>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){Ji=0;Ki=Hi}else{Bi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Bi|0)==0){c[yb>>2]=0;yi=(c[t>>2]|0)+ -1|0;c[x>>2]=yi;a[yi>>0]=0;Li=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Bi+40;Li=pb}Bi=Li+1|0;c[x>>2]=Bi;Ji=d[Li>>0]|0;Ki=Bi}}else{Bi=Hi+1|0;c[x>>2]=Bi;Ji=d[Hi>>0]|0;Ki=Bi}if((Ji|0)!=(d[28776+Ii>>0]|0)){break E}Ii=Ii+1|0;if((Ii|0)>=4){break}else{Hi=Ki}}Bi=c[v>>2]|0;c[x>>2]=Bi;yi=c[t>>2]|0;zi=Bi;Ai=yi;Ci=Bi>>>0<yi>>>0;yi=0;while(1){if(!Ci){if((c[yb>>2]|0)==0){Mi=zi;Ni=Ai}else{Bi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Bi|0)==0){c[yb>>2]=0;gf=(c[t>>2]|0)+ -1|0;c[x>>2]=gf;a[gf>>0]=0;Oi=c[t>>2]|0;Pi=c[x>>2]|0}else{c[x>>2]=pb;gf=e+Bi+40|0;c[t>>2]=gf;Oi=gf;Pi=pb}gf=Pi+1|0;c[x>>2]=gf;Mi=gf;Ni=Oi}}else{gf=zi+1|0;c[x>>2]=gf;Mi=gf;Ni=Ai}yi=yi+1|0;Ci=Mi>>>0<Ni>>>0;if((yi|0)==92){break}else{zi=Mi;Ai=Ni}}if(!Ci){if((c[yb>>2]|0)==0){Qi=0;Ri=Mi;Si=Ni}else{Ai=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ai|0)==0){c[yb>>2]=0;zi=(c[t>>2]|0)+ -1|0;c[x>>2]=zi;a[zi>>0]=0;Ti=c[t>>2]|0;Ui=c[x>>2]|0}else{c[x>>2]=pb;zi=e+Ai+40|0;c[t>>2]=zi;Ti=zi;Ui=pb}zi=Ui+1|0;c[x>>2]=zi;Qi=d[Ui>>0]|0;Ri=zi;Si=Ti}}else{zi=Mi+1|0;c[x>>2]=zi;Qi=d[Mi>>0]|0;Ri=zi;Si=Ni}zi=Qi<<8;if(!(Ri>>>0<Si>>>0)){if((c[yb>>2]|0)==0){Vi=0;Wi=Ri;Xi=Si}else{Ai=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ai|0)==0){c[yb>>2]=0;yi=(c[t>>2]|0)+ -1|0;c[x>>2]=yi;a[yi>>0]=0;Yi=c[t>>2]|0;Zi=c[x>>2]|0}else{c[x>>2]=pb;yi=e+Ai+40|0;c[t>>2]=yi;Yi=yi;Zi=pb}yi=Zi+1|0;c[x>>2]=yi;Vi=d[Zi>>0]|0;Wi=yi;Xi=Yi}}else{yi=Ri+1|0;c[x>>2]=yi;Vi=d[Ri>>0]|0;Wi=yi;Xi=Si}yi=Vi|zi;if(!(Wi>>>0<Xi>>>0)){if((c[yb>>2]|0)==0){_i=0;$i=Wi;aj=Xi}else{zi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((zi|0)==0){c[yb>>2]=0;Ai=(c[t>>2]|0)+ -1|0;c[x>>2]=Ai;a[Ai>>0]=0;bj=c[t>>2]|0;cj=c[x>>2]|0}else{c[x>>2]=pb;Ai=e+zi+40|0;c[t>>2]=Ai;bj=Ai;cj=pb}Ai=cj+1|0;c[x>>2]=Ai;_i=d[cj>>0]|0;$i=Ai;aj=bj}}else{Ai=Wi+1|0;c[x>>2]=Ai;_i=d[Wi>>0]|0;$i=Ai;aj=Xi}Ai=_i<<8;if(!($i>>>0<aj>>>0)){if((c[yb>>2]|0)==0){dj=0;ej=$i}else{zi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((zi|0)==0){c[yb>>2]=0;gf=(c[t>>2]|0)+ -1|0;c[x>>2]=gf;a[gf>>0]=0;fj=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+zi+40;fj=pb}zi=fj+1|0;c[x>>2]=zi;dj=d[fj>>0]|0;ej=zi}}else{zi=$i+1|0;c[x>>2]=zi;dj=d[$i>>0]|0;ej=zi}zi=dj|Ai;if((c[xb>>2]|0)!=0){if((Nd[c[e+24>>2]&63](c[lb>>2]|0)|0)!=0){if((c[yb>>2]|0)==0){ga=1112}else{gj=c[x>>2]|0;ga=1111}}}else{gj=ej;ga=1111}if((ga|0)==1111?!(gj>>>0<(c[t>>2]|0)>>>0):0){ga=1112}if((ga|0)==1112){c[6510]=28680;y=0;i=l;return y|0}if((268435456/(yi>>>0)|0)>>>0<zi>>>0){c[6510]=26216;y=0;i=l;return y|0}Ai=c[x>>2]|0;gf=c[t>>2]|0;if(!(Ai>>>0<gf>>>0)){if((c[yb>>2]|0)==0){hj=Ai;ij=gf}else{Bi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Bi|0)==0){c[yb>>2]=0;xi=(c[t>>2]|0)+ -1|0;c[x>>2]=xi;a[xi>>0]=0;jj=c[t>>2]|0;kj=c[x>>2]|0}else{c[x>>2]=pb;xi=e+Bi+40|0;c[t>>2]=xi;jj=xi;kj=pb}xi=kj+1|0;c[x>>2]=xi;hj=xi;ij=jj}}else{xi=Ai+1|0;c[x>>2]=xi;hj=xi;ij=gf}if(!(hj>>>0<ij>>>0)){if((c[yb>>2]|0)==0){lj=hj;mj=ij}else{gf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((gf|0)==0){c[yb>>2]=0;xi=(c[t>>2]|0)+ -1|0;c[x>>2]=xi;a[xi>>0]=0;nj=c[t>>2]|0;oj=c[x>>2]|0}else{c[x>>2]=pb;xi=e+gf+40|0;c[t>>2]=xi;nj=xi;oj=pb}xi=oj+1|0;c[x>>2]=xi;lj=xi;mj=nj}}else{xi=hj+1|0;c[x>>2]=xi;lj=xi;mj=ij}if(!(lj>>>0<mj>>>0)){if((c[yb>>2]|0)==0){pj=lj;qj=mj}else{xi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((xi|0)==0){c[yb>>2]=0;gf=(c[t>>2]|0)+ -1|0;c[x>>2]=gf;a[gf>>0]=0;rj=c[t>>2]|0;sj=c[x>>2]|0}else{c[x>>2]=pb;gf=e+xi+40|0;c[t>>2]=gf;rj=gf;sj=pb}gf=sj+1|0;c[x>>2]=gf;pj=gf;qj=rj}}else{gf=lj+1|0;c[x>>2]=gf;pj=gf;qj=mj}do{if(pj>>>0<qj>>>0){gf=pj+1|0;c[x>>2]=gf;tj=gf;uj=qj}else{if((c[yb>>2]|0)==0){tj=pj;uj=qj;break}gf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((gf|0)==0){c[yb>>2]=0;xi=(c[t>>2]|0)+ -1|0;c[x>>2]=xi;a[xi>>0]=0;vj=c[t>>2]|0;wj=c[x>>2]|0}else{c[x>>2]=pb;xi=e+gf+40|0;c[t>>2]=xi;vj=xi;wj=pb}xi=wj+1|0;c[x>>2]=xi;tj=xi;uj=vj}}while(0);do{if(tj>>>0<uj>>>0){Ci=tj+1|0;c[x>>2]=Ci;xj=Ci;yj=uj}else{if((c[yb>>2]|0)==0){xj=tj;yj=uj;break}Ci=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ci|0)==0){c[yb>>2]=0;xi=(c[t>>2]|0)+ -1|0;c[x>>2]=xi;a[xi>>0]=0;zj=c[t>>2]|0;Aj=c[x>>2]|0}else{c[x>>2]=pb;xi=e+Ci+40|0;c[t>>2]=xi;zj=xi;Aj=pb}xi=Aj+1|0;c[x>>2]=xi;xj=xi;yj=zj}}while(0);do{if(xj>>>0<yj>>>0){xi=xj+1|0;c[x>>2]=xi;Bj=xi;Cj=yj}else{if((c[yb>>2]|0)==0){Bj=xj;Cj=yj;break}xi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((xi|0)==0){c[yb>>2]=0;Ci=(c[t>>2]|0)+ -1|0;c[x>>2]=Ci;a[Ci>>0]=0;Dj=c[t>>2]|0;Ej=c[x>>2]|0}else{c[x>>2]=pb;Ci=e+xi+40|0;c[t>>2]=Ci;Dj=Ci;Ej=pb}Ci=Ej+1|0;c[x>>2]=Ci;Bj=Ci;Cj=Dj}}while(0);do{if(Bj>>>0<Cj>>>0){Ci=Bj+1|0;c[x>>2]=Ci;Fj=Ci;Gj=Cj}else{if((c[yb>>2]|0)==0){Fj=Bj;Gj=Cj;break}Ci=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ci|0)==0){c[yb>>2]=0;xi=(c[t>>2]|0)+ -1|0;c[x>>2]=xi;a[xi>>0]=0;Hj=c[t>>2]|0;Ij=c[x>>2]|0}else{c[x>>2]=pb;xi=e+Ci+40|0;c[t>>2]=xi;Hj=xi;Ij=pb}xi=Ij+1|0;c[x>>2]=xi;Fj=xi;Gj=Hj}}while(0);do{if(Fj>>>0<Gj>>>0){c[x>>2]=Fj+1}else{if((c[yb>>2]|0)==0){break}xi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((xi|0)==0){c[yb>>2]=0;Ci=(c[t>>2]|0)+ -1|0;c[x>>2]=Ci;a[Ci>>0]=0;Jj=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+xi+40;Jj=pb}c[x>>2]=Jj+1}}while(0);xi=yi<<2;Ci=da(zi,xi)|0;gf=Ll(Ci)|0;Om(gf|0,-1,Ci|0)|0;Ci=e+24|0;Ai=0;Bi=0;F:while(1){if((Bi|0)==10){ga=1173;break}Kj=Bi+1|0;Gg=c[x>>2]|0;mg=c[t>>2]|0;do{if(Gg>>>0<mg>>>0){Vf=Gg+1|0;c[x>>2]=Vf;Lj=d[Gg>>0]|0;Mj=Vf;Nj=mg}else{if((c[yb>>2]|0)==0){Lj=0;Mj=Gg;Nj=mg;break}Vf=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Vf|0)==0){c[yb>>2]=0;ci=(c[t>>2]|0)+ -1|0;c[x>>2]=ci;a[ci>>0]=0;Oj=c[t>>2]|0;Pj=c[x>>2]|0}else{c[x>>2]=pb;ci=e+Vf+40|0;c[t>>2]=ci;Oj=ci;Pj=pb}ci=Pj+1|0;c[x>>2]=ci;Lj=d[Pj>>0]|0;Mj=ci;Nj=Oj}}while(0);do{if(Mj>>>0<Nj>>>0){mg=Mj+1|0;c[x>>2]=mg;Qj=d[Mj>>0]|0;Rj=mg;Sj=Nj}else{if((c[yb>>2]|0)==0){Qj=0;Rj=Mj;Sj=Nj;break}mg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((mg|0)==0){c[yb>>2]=0;Gg=(c[t>>2]|0)+ -1|0;c[x>>2]=Gg;a[Gg>>0]=0;Tj=c[t>>2]|0;Uj=c[x>>2]|0}else{c[x>>2]=pb;Gg=e+mg+40|0;c[t>>2]=Gg;Tj=Gg;Uj=pb}Gg=Uj+1|0;c[x>>2]=Gg;Qj=d[Uj>>0]|0;Rj=Gg;Sj=Tj}}while(0);Gg=Qj&255;a[m+(Bi*3|0)>>0]=Gg;do{if(Rj>>>0<Sj>>>0){mg=Rj+1|0;c[x>>2]=mg;Vj=d[Rj>>0]|0;Wj=mg;Xj=Sj}else{if((c[yb>>2]|0)==0){Vj=0;Wj=Rj;Xj=Sj;break}mg=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((mg|0)==0){c[yb>>2]=0;ci=(c[t>>2]|0)+ -1|0;c[x>>2]=ci;a[ci>>0]=0;Yj=c[t>>2]|0;Zj=c[x>>2]|0}else{c[x>>2]=pb;ci=e+mg+40|0;c[t>>2]=ci;Yj=ci;Zj=pb}ci=Zj+1|0;c[x>>2]=ci;Vj=d[Zj>>0]|0;Wj=ci;Xj=Yj}}while(0);a[m+(Bi*3|0)+1>>0]=Vj;do{if(Wj>>>0<Xj>>>0){ci=Wj+1|0;c[x>>2]=ci;_j=d[Wj>>0]|0;$j=ci}else{if((c[yb>>2]|0)==0){_j=0;$j=Wj;break}ci=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ci|0)==0){c[yb>>2]=0;mg=(c[t>>2]|0)+ -1|0;c[x>>2]=mg;a[mg>>0]=0;ak=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ci+40;ak=pb}ci=ak+1|0;c[x>>2]=ci;_j=d[ak>>0]|0;$j=ci}}while(0);a[m+(Bi*3|0)+2>>0]=_j;Ai=_j|Ai;do{if((c[xb>>2]|0)==0){bk=$j;ga=1206}else{if((Nd[c[Ci>>2]&63](c[lb>>2]|0)|0)==0){break}if((c[yb>>2]|0)==0){ga=1207;break F}bk=c[x>>2]|0;ga=1206}}while(0);if((ga|0)==1206?(ga=0,!(bk>>>0<(c[t>>2]|0)>>>0)):0){ga=1207;break}if(!(Gg<<24>>24==8)){ga=1209;break}if((Lj|0)==0){ga=1211;break}else{Bi=Kj}}G:do{if((ga|0)==1173){c[6510]=28752;ck=0}else if((ga|0)==1207){c[6510]=28680;ck=0}else if((ga|0)==1209){c[6510]=28752;ck=0}else if((ga|0)==1211){c[j>>2]=(Ai>>>4&1)+3;if((zi|0)==0){ck=gf;break}ci=(Bi|0)>-1;mg=(yi|0)!=0;Vf=o+3|0;fi=o+2|0;ei=o+1|0;ai=n+3|0;ui=n+2|0;ti=n+1|0;li=0;H:while(1){if(ci){vi=gf+(da(li,xi)|0)|0;wi=0;do{mi=d[m+(wi*3|0)+1>>0]|0;I:do{if((mi|0)==2){if(!mg){break}qi=m+(wi*3|0)+2|0;ri=vi;si=yi;while(1){oi=c[x>>2]|0;do{if(oi>>>0<(c[t>>2]|0)>>>0){ni=oi+1|0;c[x>>2]=ni;dk=d[oi>>0]|0;ek=ni}else{if((c[yb>>2]|0)==0){dk=0;ek=oi;break}ni=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ni|0)==0){c[yb>>2]=0;pi=(c[t>>2]|0)+ -1|0;c[x>>2]=pi;a[pi>>0]=0;fk=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ni+40;fk=pb}ni=fk+1|0;c[x>>2]=ni;dk=d[fk>>0]|0;ek=ni}}while(0);do{if((c[xb>>2]|0)==0){gk=ek;ga=1298}else{if((Nd[c[Ci>>2]&63](c[lb>>2]|0)|0)==0){break}if((c[yb>>2]|0)==0){ga=1299;break H}gk=c[x>>2]|0;ga=1298}}while(0);if((ga|0)==1298?(ga=0,!(gk>>>0<(c[t>>2]|0)>>>0)):0){ga=1299;break H}J:do{if(dk>>>0>127){if((dk|0)==128){oi=c[x>>2]|0;ni=c[t>>2]|0;do{if(oi>>>0<ni>>>0){pi=oi+1|0;c[x>>2]=pi;hk=d[oi>>0]|0;ik=pi;jk=ni}else{if((c[yb>>2]|0)==0){hk=0;ik=oi;jk=ni;break}pi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((pi|0)==0){c[yb>>2]=0;hi=(c[t>>2]|0)+ -1|0;c[x>>2]=hi;a[hi>>0]=0;kk=c[t>>2]|0;lk=c[x>>2]|0}else{c[x>>2]=pb;hi=e+pi+40|0;c[t>>2]=hi;kk=hi;lk=pb}hi=lk+1|0;c[x>>2]=hi;hk=d[lk>>0]|0;ik=hi;jk=kk}}while(0);ni=hk<<8;do{if(ik>>>0<jk>>>0){c[x>>2]=ik+1;mk=d[ik>>0]|0}else{if((c[yb>>2]|0)==0){mk=0;break}oi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((oi|0)==0){c[yb>>2]=0;oc=(c[t>>2]|0)+ -1|0;c[x>>2]=oc;a[oc>>0]=0;nk=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+oi+40;nk=pb}c[x>>2]=nk+1;mk=d[nk>>0]|0}}while(0);ok=mk|ni}else{ok=dk+ -127|0}if((ok|0)>(si|0)){ga=1319;break H}oi=a[qi>>0]|0;oc=oi&255;hi=0;pi=128;while(1){if((pi&oc|0)!=0){do{if((c[xb>>2]|0)!=0){if((Nd[c[Ci>>2]&63](c[lb>>2]|0)|0)!=0){if((c[yb>>2]|0)==0){ga=1327;break H}else{ga=1326;break}}else{pk=c[x>>2]|0;qk=c[t>>2]|0;break}}else{ga=1326}}while(0);if((ga|0)==1326){ga=0;Qh=c[x>>2]|0;ii=c[t>>2]|0;if(Qh>>>0<ii>>>0){pk=Qh;qk=ii}else{ga=1327;break H}}do{if(pk>>>0<qk>>>0){c[x>>2]=pk+1;rk=d[pk>>0]|0}else{if((c[yb>>2]|0)==0){rk=0;break}ii=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ii|0)==0){c[yb>>2]=0;Qh=(c[t>>2]|0)+ -1|0;c[x>>2]=Qh;a[Qh>>0]=0;sk=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ii+40;sk=pb}c[x>>2]=sk+1;rk=d[sk>>0]|0}}while(0);a[o+hi>>0]=rk}hi=hi+1|0;if((hi|0)>=4){break}else{pi=pi>>1}}if((ok|0)>0){tk=oi;uk=ri;vk=1}else{wk=ok;xk=ri;break}while(1){pi=tk&255;if((pi&128|0)!=0){a[uk>>0]=a[o>>0]|0}if((pi&64|0)!=0){a[uk+1>>0]=a[ei>>0]|0}if((pi&32|0)!=0){a[uk+2>>0]=a[fi>>0]|0}if((pi&16|0)!=0){a[uk+3>>0]=a[Vf>>0]|0}if((vk|0)==(ok|0)){break}tk=a[qi>>0]|0;uk=uk+4|0;vk=vk+1|0}wk=ok;xk=ri+(ok<<2)|0}else{oi=dk+1|0;if((dk|0)<(si|0)){zk=ri;Ak=1}else{ga=1349;break H}while(1){pi=d[qi>>0]|0;hi=0;oc=128;while(1){if((oc&pi|0)!=0){do{if((c[xb>>2]|0)!=0){if((Nd[c[Ci>>2]&63](c[lb>>2]|0)|0)!=0){if((c[yb>>2]|0)==0){ga=1357;break H}else{ga=1356;break}}else{Bk=c[x>>2]|0;Ck=c[t>>2]|0;break}}else{ga=1356}}while(0);if((ga|0)==1356){ga=0;X=c[x>>2]|0;ni=c[t>>2]|0;if(X>>>0<ni>>>0){Bk=X;Ck=ni}else{ga=1357;break H}}do{if(Bk>>>0<Ck>>>0){c[x>>2]=Bk+1;Fk=d[Bk>>0]|0}else{if((c[yb>>2]|0)==0){Fk=0;break}ni=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ni|0)==0){c[yb>>2]=0;X=(c[t>>2]|0)+ -1|0;c[x>>2]=X;a[X>>0]=0;Ik=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ni+40;Ik=pb}c[x>>2]=Ik+1;Fk=d[Ik>>0]|0}}while(0);a[zk+hi>>0]=Fk}hi=hi+1|0;if((hi|0)>=4){break}else{oc=oc>>1}}if((zk|0)==0){ck=0;break G}oc=zk+4|0;if((Ak|0)>=(oi|0)){wk=oi;xk=oc;break J}zk=oc;Ak=Ak+1|0}}}while(0);si=si-wk|0;if((si|0)<=0){break}else{ri=xk}}}else if((mi|0)==1){if(!mg){break}ri=m+(wi*3|0)+2|0;si=vi;qi=yi;while(1){Ic=c[x>>2]|0;do{if(Ic>>>0<(c[t>>2]|0)>>>0){oi=Ic+1|0;c[x>>2]=oi;Jk=d[Ic>>0]|0;Kk=oi}else{if((c[yb>>2]|0)==0){Jk=0;Kk=Ic;break}oi=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((oi|0)==0){c[yb>>2]=0;oc=(c[t>>2]|0)+ -1|0;c[x>>2]=oc;a[oc>>0]=0;Ok=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+oi+40;Ok=pb}oi=Ok+1|0;c[x>>2]=oi;Jk=d[Ok>>0]|0;Kk=oi}}while(0);do{if((c[xb>>2]|0)==0){Pk=Kk;ga=1254}else{if((Nd[c[Ci>>2]&63](c[lb>>2]|0)|0)==0){break}if((c[yb>>2]|0)==0){ga=1255;break H}Pk=c[x>>2]|0;ga=1254}}while(0);if((ga|0)==1254?(ga=0,!(Pk>>>0<(c[t>>2]|0)>>>0)):0){ga=1255;break H}Ic=(Jk|0)>(qi|0)?qi:Jk;oi=a[ri>>0]|0;oc=oi&255;hi=0;pi=128;while(1){if((pi&oc|0)!=0){do{if((c[xb>>2]|0)!=0){if((Nd[c[Ci>>2]&63](c[lb>>2]|0)|0)!=0){if((c[yb>>2]|0)==0){ga=1263;break H}else{ga=1262;break}}else{Qk=c[x>>2]|0;Rk=c[t>>2]|0;break}}else{ga=1262}}while(0);if((ga|0)==1262){ga=0;ni=c[x>>2]|0;X=c[t>>2]|0;if(ni>>>0<X>>>0){Qk=ni;Rk=X}else{ga=1263;break H}}do{if(Qk>>>0<Rk>>>0){c[x>>2]=Qk+1;Sk=d[Qk>>0]|0}else{if((c[yb>>2]|0)==0){Sk=0;break}X=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((X|0)==0){c[yb>>2]=0;ni=(c[t>>2]|0)+ -1|0;c[x>>2]=ni;a[ni>>0]=0;Vk=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+X+40;Vk=pb}c[x>>2]=Vk+1;Sk=d[Vk>>0]|0}}while(0);a[n+hi>>0]=Sk}hi=hi+1|0;if((hi|0)>=4){break}else{pi=pi>>1}}pi=Ic&255;if((pi|0)==0){Wk=si}else{hi=~Jk;oc=~qi;X=((hi|0)>(oc|0)?hi:oc)&255;oc=oi;hi=si;ni=1;while(1){ii=oc&255;if((ii&128|0)!=0){a[hi>>0]=a[n>>0]|0}if((ii&64|0)!=0){a[hi+1>>0]=a[ti>>0]|0}if((ii&32|0)!=0){a[hi+2>>0]=a[ui>>0]|0}if((ii&16|0)!=0){a[hi+3>>0]=a[ai>>0]|0}if((ni|0)>=(pi|0)){break}oc=a[ri>>0]|0;hi=hi+4|0;ni=ni+1|0}ni=X^255;Wk=si+(ni>>>0>1?ni<<2:4)|0}qi=qi-pi|0;if((qi|0)<=0){break}else{si=Wk}}}else if((mi|0)==0){if(!mg){break}si=m+(wi*3|0)+2|0;qi=vi;ri=1;while(1){ni=d[si>>0]|0;hi=0;oc=128;while(1){if((oc&ni|0)!=0){do{if((c[xb>>2]|0)!=0){if((Nd[c[Ci>>2]&63](c[lb>>2]|0)|0)!=0){if((c[yb>>2]|0)==0){ga=1230;break H}else{ga=1229;break}}else{Xk=c[x>>2]|0;Yk=c[t>>2]|0;break}}else{ga=1229}}while(0);if((ga|0)==1229){ga=0;oi=c[x>>2]|0;Ic=c[t>>2]|0;if(oi>>>0<Ic>>>0){Xk=oi;Yk=Ic}else{ga=1230;break H}}do{if(Xk>>>0<Yk>>>0){c[x>>2]=Xk+1;Zk=d[Xk>>0]|0}else{if((c[yb>>2]|0)==0){Zk=0;break}Ic=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Ic|0)==0){c[yb>>2]=0;oi=(c[t>>2]|0)+ -1|0;c[x>>2]=oi;a[oi>>0]=0;_k=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Ic+40;_k=pb}c[x>>2]=_k+1;Zk=d[_k>>0]|0}}while(0);a[qi+hi>>0]=Zk}hi=hi+1|0;if((hi|0)>=4){break}else{oc=oc>>1}}if((qi|0)==0){ck=0;break G}if((ri|0)>=(yi|0)){break I}qi=qi+4|0;ri=ri+1|0}}else{ga=1222;break H}}while(0);wi=wi+1|0}while((wi|0)<(Kj|0))}li=li+1|0;if((li|0)>=(zi|0)){ck=gf;break G}}if((ga|0)==1222){c[6510]=28752;ck=0;break}else if((ga|0)==1230){c[6510]=28680;ck=0;break}else if((ga|0)==1255){c[6510]=28680;ck=0;break}else if((ga|0)==1263){c[6510]=28680;ck=0;break}else if((ga|0)==1299){c[6510]=28680;ck=0;break}else if((ga|0)==1319){c[6510]=28680;ck=0;break}else if((ga|0)==1327){c[6510]=28680;ck=0;break}else if((ga|0)==1349){c[6510]=28680;ck=0;break}else if((ga|0)==1357){c[6510]=28680;ck=0;break}}}while(0);if((ck|0)==0){Ml(gf);$k=0}else{$k=gf}c[f>>2]=yi;c[h>>2]=zi;if((k|0)==0){al=c[j>>2]|0}else{al=k}y=Lk($k,4,al,yi,zi)|0;i=l;return y|0}}while(0);al=c[v>>2]|0;c[x>>2]=al;$k=al;al=0;while(1){ck=27384+al|0;if(!($k>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){bl=0;cl=$k}else{Kj=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Kj|0)==0){c[yb>>2]=0;Zk=(c[t>>2]|0)+ -1|0;c[x>>2]=Zk;a[Zk>>0]=0;dl=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Kj+40;dl=pb}Kj=dl+1|0;c[x>>2]=Kj;bl=d[dl>>0]|0;cl=Kj}}else{Kj=$k+1|0;c[x>>2]=Kj;bl=d[$k>>0]|0;cl=Kj}al=al+1|0;if((bl|0)!=(a[ck>>0]|0)){break}if((al|0)==11){ga=1389;break}else{$k=cl}}if((ga|0)==1389){c[x>>2]=c[v>>2];cl=yk(e,f,h,j,k)|0;if((k|0)==0){el=c[j>>2]|0}else{el=k}$k=da(c[h>>2]|0,c[f>>2]|0)|0;al=Ll(da(el,$k)|0)|0;if((al|0)==0){Ml(cl);c[6510]=26456;y=0;i=l;return y|0}if(($k|0)>0){bl=el+ -1+(el&1)|0;dl=(bl|0)>0;fl=+g[6520];gl=+g[6518];ck=0;do{if(dl){Kj=da(ck,el)|0;Zk=0;do{_k=Zk+Kj|0;hl=+U(+(fl*+g[cl+(_k<<2)>>2]),+gl)*255.0+.5;il=hl<0.0?0.0:hl;a[al+_k>>0]=il>255.0?-1:~~il&255;Zk=Zk+1|0}while((Zk|0)!=(bl|0));jl=bl}else{jl=0}if((jl|0)<(el|0)){Zk=jl+(da(ck,el)|0)|0;il=+g[cl+(Zk<<2)>>2]*255.0+.5;hl=il<0.0?0.0:il;a[al+Zk>>0]=hl>255.0?-1:~~hl&255}ck=ck+1|0}while((ck|0)!=($k|0))}Ml(cl);y=al;i=l;return y|0}al=c[v>>2]|0;c[x>>2]=al;cl=c[t>>2]|0;if(!(al>>>0<cl>>>0)){if((c[yb>>2]|0)==0){kl=al;ll=cl}else{$k=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if(($k|0)==0){c[yb>>2]=0;ck=(c[t>>2]|0)+ -1|0;c[x>>2]=ck;a[ck>>0]=0;ml=c[t>>2]|0;nl=c[x>>2]|0}else{c[x>>2]=pb;ck=e+$k+40|0;c[t>>2]=ck;ml=ck;nl=pb}ck=nl+1|0;c[x>>2]=ck;kl=ck;ll=ml}}else{ml=al+1|0;c[x>>2]=ml;kl=ml;ll=cl}if(!(kl>>>0<ll>>>0)){if((c[yb>>2]|0)==0){ol=0;pl=kl}else{ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;ql=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ll+40;ql=pb}ll=ql+1|0;c[x>>2]=ll;ol=d[ql>>0]|0;pl=ll}}else{ll=kl+1|0;c[x>>2]=ll;ol=d[kl>>0]|0;pl=ll}K:do{if(!((ol&255)>1)){if(!(pl>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){rl=0;sl=pl}else{ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;kl=(c[t>>2]|0)+ -1|0;c[x>>2]=kl;a[kl>>0]=0;tl=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ll+40;tl=pb}ll=tl+1|0;c[x>>2]=ll;rl=d[tl>>0]|0;sl=ll}}else{ll=pl+1|0;c[x>>2]=ll;rl=d[pl>>0]|0;sl=ll}ll=rl&255;if(!((ll+ -1<<24>>24&255)>1&ll<<24>>24!=3&ll<<24>>24!=9&ll<<24>>24!=10&ll<<24>>24!=11)){ll=c[t>>2]|0;if(!(sl>>>0<ll>>>0)){if((c[yb>>2]|0)==0){ul=sl;vl=ll}else{kl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((kl|0)==0){c[yb>>2]=0;ql=(c[t>>2]|0)+ -1|0;c[x>>2]=ql;a[ql>>0]=0;wl=c[t>>2]|0;xl=c[x>>2]|0}else{c[x>>2]=pb;ql=e+kl+40|0;c[t>>2]=ql;wl=ql;xl=pb}ql=xl+1|0;c[x>>2]=ql;ul=ql;vl=wl}}else{ql=sl+1|0;c[x>>2]=ql;ul=ql;vl=ll}if(!(ul>>>0<vl>>>0)){if((c[yb>>2]|0)==0){yl=ul;zl=vl}else{ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;ql=(c[t>>2]|0)+ -1|0;c[x>>2]=ql;a[ql>>0]=0;Al=c[t>>2]|0;Bl=c[x>>2]|0}else{c[x>>2]=pb;ql=e+ll+40|0;c[t>>2]=ql;Al=ql;Bl=pb}ql=Bl+1|0;c[x>>2]=ql;yl=ql;zl=Al}}else{ql=ul+1|0;c[x>>2]=ql;yl=ql;zl=vl}if(!(yl>>>0<zl>>>0)){if((c[yb>>2]|0)==0){Cl=yl;Dl=zl}else{ql=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ql|0)==0){c[yb>>2]=0;ll=(c[t>>2]|0)+ -1|0;c[x>>2]=ll;a[ll>>0]=0;El=c[t>>2]|0;Fl=c[x>>2]|0}else{c[x>>2]=pb;ll=e+ql+40|0;c[t>>2]=ll;El=ll;Fl=pb}ll=Fl+1|0;c[x>>2]=ll;Cl=ll;Dl=El}}else{ll=yl+1|0;c[x>>2]=ll;Cl=ll;Dl=zl}if(!(Cl>>>0<Dl>>>0)){if((c[yb>>2]|0)==0){Gl=Cl;Hl=Dl}else{ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;ql=(c[t>>2]|0)+ -1|0;c[x>>2]=ql;a[ql>>0]=0;Il=c[t>>2]|0;Jl=c[x>>2]|0}else{c[x>>2]=pb;ql=e+ll+40|0;c[t>>2]=ql;Il=ql;Jl=pb}ql=Jl+1|0;c[x>>2]=ql;Gl=ql;Hl=Il}}else{ql=Cl+1|0;c[x>>2]=ql;Gl=ql;Hl=Dl}do{if(Gl>>>0<Hl>>>0){ql=Gl+1|0;c[x>>2]=ql;Kl=ql;Nl=Hl}else{if((c[yb>>2]|0)==0){Kl=Gl;Nl=Hl;break}ql=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ql|0)==0){c[yb>>2]=0;ll=(c[t>>2]|0)+ -1|0;c[x>>2]=ll;a[ll>>0]=0;Ol=c[t>>2]|0;Pl=c[x>>2]|0}else{c[x>>2]=pb;ll=e+ql+40|0;c[t>>2]=ll;Ol=ll;Pl=pb}ll=Pl+1|0;c[x>>2]=ll;Kl=ll;Nl=Ol}}while(0);do{if(Kl>>>0<Nl>>>0){ll=Kl+1|0;c[x>>2]=ll;Ql=ll;Rl=Nl}else{if((c[yb>>2]|0)==0){Ql=Kl;Rl=Nl;break}ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;ql=(c[t>>2]|0)+ -1|0;c[x>>2]=ql;a[ql>>0]=0;Sl=c[t>>2]|0;Tl=c[x>>2]|0}else{c[x>>2]=pb;ql=e+ll+40|0;c[t>>2]=ql;Sl=ql;Tl=pb}ql=Tl+1|0;c[x>>2]=ql;Ql=ql;Rl=Sl}}while(0);do{if(Ql>>>0<Rl>>>0){ql=Ql+1|0;c[x>>2]=ql;Ul=ql;Vl=Rl}else{if((c[yb>>2]|0)==0){Ul=Ql;Vl=Rl;break}ql=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ql|0)==0){c[yb>>2]=0;ll=(c[t>>2]|0)+ -1|0;c[x>>2]=ll;a[ll>>0]=0;Wl=c[t>>2]|0;Xl=c[x>>2]|0}else{c[x>>2]=pb;ll=e+ql+40|0;c[t>>2]=ll;Wl=ll;Xl=pb}ll=Xl+1|0;c[x>>2]=ll;Ul=ll;Vl=Wl}}while(0);do{if(Ul>>>0<Vl>>>0){ll=Ul+1|0;c[x>>2]=ll;Yl=ll;Zl=Vl}else{if((c[yb>>2]|0)==0){Yl=Ul;Zl=Vl;break}ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;ql=(c[t>>2]|0)+ -1|0;c[x>>2]=ql;a[ql>>0]=0;_l=c[t>>2]|0;$l=c[x>>2]|0}else{c[x>>2]=pb;ql=e+ll+40|0;c[t>>2]=ql;_l=ql;$l=pb}ql=$l+1|0;c[x>>2]=ql;Yl=ql;Zl=_l}}while(0);do{if(Yl>>>0<Zl>>>0){ql=Yl+1|0;c[x>>2]=ql;am=ql;bm=Zl}else{if((c[yb>>2]|0)==0){am=Yl;bm=Zl;break}ql=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ql|0)==0){c[yb>>2]=0;ll=(c[t>>2]|0)+ -1|0;c[x>>2]=ll;a[ll>>0]=0;cm=c[t>>2]|0;dm=c[x>>2]|0}else{c[x>>2]=pb;ll=e+ql+40|0;c[t>>2]=ll;cm=ll;dm=pb}ll=dm+1|0;c[x>>2]=ll;am=ll;bm=cm}}while(0);do{if(am>>>0<bm>>>0){ll=am+1|0;c[x>>2]=ll;em=d[am>>0]|0;fm=ll;gm=bm}else{if((c[yb>>2]|0)==0){em=0;fm=am;gm=bm;break}ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;ql=(c[t>>2]|0)+ -1|0;c[x>>2]=ql;a[ql>>0]=0;hm=c[t>>2]|0;im=c[x>>2]|0}else{c[x>>2]=pb;ql=e+ll+40|0;c[t>>2]=ql;hm=ql;im=pb}ql=im+1|0;c[x>>2]=ql;em=d[im>>0]|0;fm=ql;gm=hm}}while(0);ql=em<<8;do{if(fm>>>0<gm>>>0){ll=fm+1|0;c[x>>2]=ll;jm=d[fm>>0]|0;km=ll}else{if((c[yb>>2]|0)==0){jm=0;km=fm;break}ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;kl=(c[t>>2]|0)+ -1|0;c[x>>2]=kl;a[kl>>0]=0;lm=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ll+40;lm=pb}ll=lm+1|0;c[x>>2]=ll;jm=d[lm>>0]|0;km=ll}}while(0);if((jm|ql|0)==0){break}ll=c[t>>2]|0;do{if(km>>>0<ll>>>0){kl=km+1|0;c[x>>2]=kl;mm=d[km>>0]|0;nm=kl;om=ll}else{if((c[yb>>2]|0)==0){mm=0;nm=km;om=ll;break}kl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((kl|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;pm=c[t>>2]|0;qm=c[x>>2]|0}else{c[x>>2]=pb;cl=e+kl+40|0;c[t>>2]=cl;pm=cl;qm=pb}cl=qm+1|0;c[x>>2]=cl;mm=d[qm>>0]|0;nm=cl;om=pm}}while(0);ll=mm<<8;do{if(nm>>>0<om>>>0){ql=nm+1|0;c[x>>2]=ql;rm=d[nm>>0]|0;sm=ql}else{if((c[yb>>2]|0)==0){rm=0;sm=nm;break}ql=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ql|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;tm=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+ql+40;tm=pb}ql=tm+1|0;c[x>>2]=ql;rm=d[tm>>0]|0;sm=ql}}while(0);if((rm|ll|0)==0){break}do{if(!(sm>>>0<(c[t>>2]|0)>>>0)){if((c[yb>>2]|0)==0){break K}ql=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ql|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;um=c[x>>2]|0;break}else{c[x>>2]=pb;c[t>>2]=e+ql+40;um=pb;break}}else{um=sm}}while(0);c[x>>2]=um+1;ll=d[um>>0]|0;if(!((ll|0)==8|(ll|0)==16|(ll|0)==24|(ll|0)==32)){break}ll=c[v>>2]|0;c[x>>2]=ll;ql=c[t>>2]|0;do{if(ll>>>0<ql>>>0){cl=ll+1|0;c[x>>2]=cl;vm=d[ll>>0]|0;wm=cl;xm=ql}else{if((c[yb>>2]|0)==0){vm=0;wm=ll;xm=ql;break}cl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((cl|0)==0){c[yb>>2]=0;kl=(c[t>>2]|0)+ -1|0;c[x>>2]=kl;a[kl>>0]=0;ym=c[t>>2]|0;zm=c[x>>2]|0}else{c[x>>2]=pb;kl=e+cl+40|0;c[t>>2]=kl;ym=kl;zm=pb}kl=zm+1|0;c[x>>2]=kl;vm=d[zm>>0]|0;wm=kl;xm=ym}}while(0);do{if(wm>>>0<xm>>>0){ql=wm+1|0;c[x>>2]=ql;Am=d[wm>>0]|0;Bm=ql;Cm=xm}else{if((c[yb>>2]|0)==0){Am=0;Bm=wm;Cm=xm;break}ql=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ql|0)==0){c[yb>>2]=0;ll=(c[t>>2]|0)+ -1|0;c[x>>2]=ll;a[ll>>0]=0;Dm=c[t>>2]|0;Em=c[x>>2]|0}else{c[x>>2]=pb;ll=e+ql+40|0;c[t>>2]=ll;Dm=ll;Em=pb}ll=Em+1|0;c[x>>2]=ll;Am=d[Em>>0]|0;Bm=ll;Cm=Dm}}while(0);do{if(Bm>>>0<Cm>>>0){ll=Bm+1|0;c[x>>2]=ll;Fm=d[Bm>>0]|0;Gm=ll;Hm=Cm}else{if((c[yb>>2]|0)==0){Fm=0;Gm=Bm;Hm=Cm;break}ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;ql=(c[t>>2]|0)+ -1|0;c[x>>2]=ql;a[ql>>0]=0;Im=c[t>>2]|0;Jm=c[x>>2]|0}else{c[x>>2]=pb;ql=e+ll+40|0;c[t>>2]=ql;Im=ql;Jm=pb}ql=Jm+1|0;c[x>>2]=ql;Fm=d[Jm>>0]|0;Gm=ql;Hm=Im}}while(0);ql=Fm&255;do{if(Gm>>>0<Hm>>>0){ll=Gm+1|0;c[x>>2]=ll;Km=d[Gm>>0]|0;Lm=ll;Nm=Hm}else{if((c[yb>>2]|0)==0){Km=0;Lm=Gm;Nm=Hm;break}ll=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ll|0)==0){c[yb>>2]=0;kl=(c[t>>2]|0)+ -1|0;c[x>>2]=kl;a[kl>>0]=0;Pm=c[t>>2]|0;Qm=c[x>>2]|0}else{c[x>>2]=pb;kl=e+ll+40|0;c[t>>2]=kl;Pm=kl;Qm=pb}kl=Qm+1|0;c[x>>2]=kl;Km=d[Qm>>0]|0;Lm=kl;Nm=Pm}}while(0);do{if(Lm>>>0<Nm>>>0){kl=Lm+1|0;c[x>>2]=kl;Rm=d[Lm>>0]|0;Sm=kl;Tm=Nm}else{if((c[yb>>2]|0)==0){Rm=0;Sm=Lm;Tm=Nm;break}kl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((kl|0)==0){c[yb>>2]=0;ll=(c[t>>2]|0)+ -1|0;c[x>>2]=ll;a[ll>>0]=0;Um=c[t>>2]|0;Vm=c[x>>2]|0}else{c[x>>2]=pb;ll=e+kl+40|0;c[t>>2]=ll;Um=ll;Vm=pb}ll=Vm+1|0;c[x>>2]=ll;Rm=d[Vm>>0]|0;Sm=ll;Tm=Um}}while(0);ll=Rm<<8|Km;do{if(Sm>>>0<Tm>>>0){kl=Sm+1|0;c[x>>2]=kl;Wm=d[Sm>>0]|0;Xm=kl;Ym=Tm}else{if((c[yb>>2]|0)==0){Wm=0;Xm=Sm;Ym=Tm;break}kl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((kl|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;Zm=c[t>>2]|0;_m=c[x>>2]|0}else{c[x>>2]=pb;cl=e+kl+40|0;c[t>>2]=cl;Zm=cl;_m=pb}cl=_m+1|0;c[x>>2]=cl;Wm=d[_m>>0]|0;Xm=cl;Ym=Zm}}while(0);do{if(Xm>>>0<Ym>>>0){cl=Xm+1|0;c[x>>2]=cl;$m=d[Xm>>0]|0;an=cl;bn=Ym}else{if((c[yb>>2]|0)==0){$m=0;an=Xm;bn=Ym;break}cl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((cl|0)==0){c[yb>>2]=0;kl=(c[t>>2]|0)+ -1|0;c[x>>2]=kl;a[kl>>0]=0;cn=c[t>>2]|0;dn=c[x>>2]|0}else{c[x>>2]=pb;kl=e+cl+40|0;c[t>>2]=kl;cn=kl;dn=pb}kl=dn+1|0;c[x>>2]=kl;$m=d[dn>>0]|0;an=kl;bn=cn}}while(0);kl=$m<<8|Wm;do{if(an>>>0<bn>>>0){cl=an+1|0;c[x>>2]=cl;en=d[an>>0]|0;fn=cl;gn=bn}else{if((c[yb>>2]|0)==0){en=0;fn=an;gn=bn;break}cl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((cl|0)==0){c[yb>>2]=0;ml=(c[t>>2]|0)+ -1|0;c[x>>2]=ml;a[ml>>0]=0;hn=c[t>>2]|0;jn=c[x>>2]|0}else{c[x>>2]=pb;ml=e+cl+40|0;c[t>>2]=ml;hn=ml;jn=pb}ml=jn+1|0;c[x>>2]=ml;en=d[jn>>0]|0;fn=ml;gn=hn}}while(0);do{if(fn>>>0<gn>>>0){ml=fn+1|0;c[x>>2]=ml;kn=ml;ln=gn}else{if((c[yb>>2]|0)==0){kn=fn;ln=gn;break}ml=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ml|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;mn=c[t>>2]|0;nn=c[x>>2]|0}else{c[x>>2]=pb;cl=e+ml+40|0;c[t>>2]=cl;mn=cl;nn=pb}cl=nn+1|0;c[x>>2]=cl;kn=cl;ln=mn}}while(0);do{if(kn>>>0<ln>>>0){cl=kn+1|0;c[x>>2]=cl;on=cl;pn=ln}else{if((c[yb>>2]|0)==0){on=kn;pn=ln;break}cl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((cl|0)==0){c[yb>>2]=0;ml=(c[t>>2]|0)+ -1|0;c[x>>2]=ml;a[ml>>0]=0;qn=c[t>>2]|0;rn=c[x>>2]|0}else{c[x>>2]=pb;ml=e+cl+40|0;c[t>>2]=ml;qn=ml;rn=pb}ml=rn+1|0;c[x>>2]=ml;on=ml;pn=qn}}while(0);do{if(on>>>0<pn>>>0){ml=on+1|0;c[x>>2]=ml;sn=ml;tn=pn}else{if((c[yb>>2]|0)==0){sn=on;tn=pn;break}ml=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ml|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;un=c[t>>2]|0;vn=c[x>>2]|0}else{c[x>>2]=pb;cl=e+ml+40|0;c[t>>2]=cl;un=cl;vn=pb}cl=vn+1|0;c[x>>2]=cl;sn=cl;tn=un}}while(0);do{if(sn>>>0<tn>>>0){cl=sn+1|0;c[x>>2]=cl;wn=cl;xn=tn}else{if((c[yb>>2]|0)==0){wn=sn;xn=tn;break}cl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((cl|0)==0){c[yb>>2]=0;ml=(c[t>>2]|0)+ -1|0;c[x>>2]=ml;a[ml>>0]=0;yn=c[t>>2]|0;zn=c[x>>2]|0}else{c[x>>2]=pb;ml=e+cl+40|0;c[t>>2]=ml;yn=ml;zn=pb}ml=zn+1|0;c[x>>2]=ml;wn=ml;xn=yn}}while(0);do{if(wn>>>0<xn>>>0){ml=wn+1|0;c[x>>2]=ml;An=d[wn>>0]|0;Bn=ml;Cn=xn}else{if((c[yb>>2]|0)==0){An=0;Bn=wn;Cn=xn;break}ml=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((ml|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;Dn=c[t>>2]|0;En=c[x>>2]|0}else{c[x>>2]=pb;cl=e+ml+40|0;c[t>>2]=cl;Dn=cl;En=pb}cl=En+1|0;c[x>>2]=cl;An=d[En>>0]|0;Bn=cl;Cn=Dn}}while(0);do{if(Bn>>>0<Cn>>>0){cl=Bn+1|0;c[x>>2]=cl;Fn=d[Bn>>0]|0;Gn=cl;Hn=Cn}else{if((c[yb>>2]|0)==0){Fn=0;Gn=Bn;Hn=Cn;break}cl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((cl|0)==0){c[yb>>2]=0;ml=(c[t>>2]|0)+ -1|0;c[x>>2]=ml;a[ml>>0]=0;In=c[t>>2]|0;Jn=c[x>>2]|0}else{c[x>>2]=pb;ml=e+cl+40|0;c[t>>2]=ml;In=ml;Jn=pb}ml=Jn+1|0;c[x>>2]=ml;Fn=d[Jn>>0]|0;Gn=ml;Hn=In}}while(0);ml=Fn<<8|An;do{if(Gn>>>0<Hn>>>0){cl=Gn+1|0;c[x>>2]=cl;Kn=d[Gn>>0]|0;Ln=cl;Mn=Hn}else{if((c[yb>>2]|0)==0){Kn=0;Ln=Gn;Mn=Hn;break}cl=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((cl|0)==0){c[yb>>2]=0;al=(c[t>>2]|0)+ -1|0;c[x>>2]=al;a[al>>0]=0;Nn=c[t>>2]|0;On=c[x>>2]|0}else{c[x>>2]=pb;al=e+cl+40|0;c[t>>2]=al;Nn=al;On=pb}al=On+1|0;c[x>>2]=al;Kn=d[On>>0]|0;Ln=al;Mn=Nn}}while(0);do{if(Ln>>>0<Mn>>>0){al=Ln+1|0;c[x>>2]=al;Pn=d[Ln>>0]|0;Qn=al;Rn=Mn}else{if((c[yb>>2]|0)==0){Pn=0;Qn=Ln;Rn=Mn;break}al=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((al|0)==0){c[yb>>2]=0;cl=(c[t>>2]|0)+ -1|0;c[x>>2]=cl;a[cl>>0]=0;Sn=c[t>>2]|0;Tn=c[x>>2]|0}else{c[x>>2]=pb;cl=e+al+40|0;c[t>>2]=cl;Sn=cl;Tn=pb}cl=Tn+1|0;c[x>>2]=cl;Pn=d[Tn>>0]|0;Qn=cl;Rn=Sn}}while(0);cl=Pn<<8|Kn;do{if(Qn>>>0<Rn>>>0){al=Qn+1|0;c[x>>2]=al;Un=d[Qn>>0]|0;Vn=al;Wn=Rn}else{if((c[yb>>2]|0)==0){Un=0;Vn=Qn;Wn=Rn;break}al=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((al|0)==0){c[yb>>2]=0;ck=(c[t>>2]|0)+ -1|0;c[x>>2]=ck;a[ck>>0]=0;Xn=c[t>>2]|0;Yn=c[x>>2]|0}else{c[x>>2]=pb;ck=e+al+40|0;c[t>>2]=ck;Xn=ck;Yn=pb}ck=Yn+1|0;c[x>>2]=ck;Un=d[Yn>>0]|0;Vn=ck;Wn=Xn}}while(0);ck=Un&255;do{if(Vn>>>0<Wn>>>0){al=Vn+1|0;c[x>>2]=al;Zn=d[Vn>>0]|0;_n=al}else{if((c[yb>>2]|0)==0){Zn=0;_n=Vn;break}al=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((al|0)==0){c[yb>>2]=0;nl=(c[t>>2]|0)+ -1|0;c[x>>2]=nl;a[nl>>0]=0;$n=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+al+40;$n=pb}al=$n+1|0;c[x>>2]=al;Zn=d[$n>>0]|0;_n=al}}while(0);al=(ql&255)>7;if((ml|0)==0|(cl|0)==0){y=0;i=l;return y|0}if(((al?Fm+ -8|0:Fm)+ -1|0)>>>0>2){y=0;i=l;return y|0}if(!(ck<<24>>24==8|ck<<24>>24==16|ck<<24>>24==24|ck<<24>>24==32)){y=0;i=l;return y|0}nl=(Am|0)!=0;$k=nl?en:Un;c[f>>2]=ml;c[h>>2]=cl;el=$k>>>3;jl=(k+ -1|0)>>>0>3?el:k;c[j>>2]=el;bl=da(cl,ml)|0;dl=Ll(da(jl,bl)|0)|0;if((dl|0)==0){c[6510]=26456;y=0;i=l;return y|0}do{if((c[xb>>2]|0)==0){ga=1658}else{Zk=c[t>>2]|0;Kj=Zk-_n|0;if((Kj|0)>=(vm|0)){ga=1658;break}c[x>>2]=Zk;Md[c[e+20>>2]&63](c[lb>>2]|0,vm-Kj|0)}}while(0);if((ga|0)==1658){c[x>>2]=_n+vm}L:do{if(nl){do{if((c[xb>>2]|0)==0){ao=c[x>>2]|0;ga=1664}else{ck=c[t>>2]|0;ql=c[x>>2]|0;Kj=ck-ql|0;if((Kj|0)>=(ll|0)){ao=ql;ga=1664;break}c[x>>2]=ck;Md[c[e+20>>2]&63](c[lb>>2]|0,ll-Kj|0)}}while(0);if((ga|0)==1664){c[x>>2]=ao+ll}Kj=(da(en,kl)|0)>>>3;ck=Ll(Kj)|0;if((ck|0)==0){c[6510]=26456;y=0;i=l;return y|0}ql=c[xb>>2]|0;do{if((ql|0)!=0){Zk=c[t>>2]|0;zi=c[x>>2]|0;yi=Zk-zi|0;if((yi|0)>=(Kj|0)){bo=zi;co=Zk;ga=1670;break}Mm(ck|0,zi|0,yi|0)|0;zi=Kj-yi|0;Zk=(Fd[ql&15](c[lb>>2]|0,ck+yi|0,zi)|0)==(zi|0);c[x>>2]=c[t>>2];if(Zk){eo=ck;break L}}else{bo=c[x>>2]|0;co=c[t>>2]|0;ga=1670}}while(0);do{if((ga|0)==1670){ql=bo+Kj|0;if(ql>>>0>co>>>0){break}Mm(ck|0,bo|0,Kj|0)|0;c[x>>2]=ql;eo=ck;break L}}while(0);Ml(dl);Ml(ck);c[6510]=28664;y=0;i=l;return y|0}else{eo=0}}while(0);if((bl|0)!=0){ll=($k|0)==0;Kj=n+1|0;ql=n+2|0;Zk=n+3|0;zi=0;yi=0;gf=0;_k=1;Xk=0;Yk=0;m=0;Wk=0;while(1){do{if(al){if((zi|0)!=0){if((_k|0)==0&(yi|0)!=0){fo=zi;go=yi;ho=Xk;io=Yk;jo=m;ko=Wk;break}else{lo=zi;mo=yi;ga=1687;break}}Jk=c[x>>2]|0;do{if(Jk>>>0<(c[t>>2]|0)>>>0){c[x>>2]=Jk+1;no=d[Jk>>0]|0}else{if((c[yb>>2]|0)==0){no=0;break}Sk=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Sk|0)==0){c[yb>>2]=0;Vk=(c[t>>2]|0)+ -1|0;c[x>>2]=Vk;a[Vk>>0]=0;oo=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Sk+40;oo=pb}c[x>>2]=oo+1;no=d[oo>>0]|0}}while(0);lo=(no&127)+1|0;mo=no>>>7;ga=1687}else{lo=zi;mo=yi;ga=1687}}while(0);do{if((ga|0)==1687){ga=0;if(nl){ck=c[x>>2]|0;do{if(ck>>>0<(c[t>>2]|0)>>>0){c[x>>2]=ck+1;po=d[ck>>0]|0}else{if((c[yb>>2]|0)==0){po=0;break}Jk=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Jk|0)==0){c[yb>>2]=0;Sk=(c[t>>2]|0)+ -1|0;c[x>>2]=Sk;a[Sk>>0]=0;qo=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Jk+40;qo=pb}c[x>>2]=qo+1;po=d[qo>>0]|0}}while(0);ck=da(po>>>0>=kl>>>0?0:po,el)|0;if(ll){fo=lo;go=mo;ho=Xk;io=Yk;jo=m;ko=Wk;break}else{ro=0}do{a[n+ro>>0]=a[eo+(ro+ck)>>0]|0;ro=ro+1|0}while((ro<<3|0)<($k|0))}else{if(ll){fo=lo;go=mo;ho=Xk;io=Yk;jo=m;ko=Wk;break}ck=c[x>>2]|0;Jk=0;while(1){do{if(ck>>>0<(c[t>>2]|0)>>>0){Sk=ck+1|0;c[x>>2]=Sk;so=d[ck>>0]|0;to=Sk}else{if((c[yb>>2]|0)==0){so=0;to=ck;break}Sk=Fd[c[xb>>2]&15](c[lb>>2]|0,pb,c[wb>>2]|0)|0;if((Sk|0)==0){c[yb>>2]=0;Vk=(c[t>>2]|0)+ -1|0;c[x>>2]=Vk;a[Vk>>0]=0;uo=c[x>>2]|0}else{c[x>>2]=pb;c[t>>2]=e+Sk+40;uo=pb}Sk=uo+1|0;c[x>>2]=Sk;so=d[uo>>0]|0;to=Sk}}while(0);a[n+Jk>>0]=so;Jk=Jk+1|0;if((Jk<<3|0)>=($k|0)){break}else{ck=to}}}if(($k|0)==8){ck=a[n>>0]|0;fo=lo;go=mo;ho=ck;io=ck;jo=ck;ko=-1;break}else if(($k|0)==16){ck=a[n>>0]|0;fo=lo;go=mo;ho=ck;io=ck;jo=ck;ko=a[Kj>>0]|0;break}else if(($k|0)==24){fo=lo;go=mo;ho=a[ql>>0]|0;io=a[Kj>>0]|0;jo=a[n>>0]|0;ko=-1;break}else if(($k|0)==32){fo=lo;go=mo;ho=a[ql>>0]|0;io=a[Kj>>0]|0;jo=a[n>>0]|0;ko=a[Zk>>0]|0;break}else{fo=lo;go=mo;ho=Xk;io=Yk;jo=m;ko=Wk;break}}}while(0);if((jl|0)==3){ck=gf*3|0;a[dl+ck>>0]=ho;a[dl+(ck+1)>>0]=io;a[dl+(ck+2)>>0]=jo}else if((jl|0)==2){ck=gf<<1;a[dl+ck>>0]=(((io&255)*150|0)+((jo&255)*29|0)+((ho&255)*77|0)|0)>>>8;a[dl+(ck|1)>>0]=ko}else if((jl|0)==4){ck=gf<<2;a[dl+ck>>0]=ho;a[dl+(ck|1)>>0]=io;a[dl+(ck|2)>>0]=jo;a[dl+(ck|3)>>0]=ko}else if((jl|0)==1){a[dl+gf>>0]=(((io&255)*150|0)+((jo&255)*29|0)+((ho&255)*77|0)|0)>>>8}gf=gf+1|0;if((gf|0)>=(bl|0)){break}else{zi=fo+ -1|0;yi=go;_k=0;Xk=ho;Yk=io;m=jo;Wk=ko}}}if((Zn&32|0)==0){Wk=da(jl,ml)|0;m=cl+ -1|0;Yk=(Wk|0)>0;Xk=0;do{if(Yk){_k=Wk;yi=da(Xk,Wk)|0;zi=da(m-Xk|0,Wk)|0;while(1){bl=dl+yi|0;gf=a[bl>>0]|0;Zk=dl+zi|0;a[bl>>0]=a[Zk>>0]|0;a[Zk>>0]=gf;_k=_k+ -1|0;if((_k|0)<=0){break}else{yi=yi+1|0;zi=zi+1|0}}}Xk=Xk+1|0}while((Xk<<1|0)<(cl|0))}if((eo|0)==0){y=dl;i=l;return y|0}Ml(eo);y=dl;i=l;return y|0}}}while(0);c[x>>2]=c[v>>2];c[6510]=26048;y=0;i=l;return y|0}function xk(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+192|0;j=h;c[j+16>>2]=0;c[j+32>>2]=0;c[j+176>>2]=a;c[j+168>>2]=a;c[j+172>>2]=a+b;b=wk(j,d,e,f,g)|0;i=h;return b|0}function yk(b,e,f,h,j){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0.0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0;k=i;i=i+1040|0;l=k+8|0;m=k;n=k+4|0;if((Cm(Bk(b,l)|0,26112)|0)!=0){c[6510]=27296;o=0;i=k;return o|0}p=Bk(b,l)|0;c[m>>2]=p;if((a[p>>0]|0)!=0){q=p;p=0;do{r=(Cm(q,26128)|0)==0;p=r?1:p;q=Bk(b,l)|0;c[m>>2]=q}while((a[q>>0]|0)!=0);if((p|0)!=0){p=Bk(b,l)|0;c[m>>2]=p;if((Dm(p,26152,3)|0)!=0){c[6510]=27328;o=0;i=k;return o|0}l=p+3|0;c[m>>2]=l;p=zm(l,m,10)|0;l=c[m>>2]|0;if((a[l>>0]|0)==32){q=l;do{q=q+1|0}while((a[q>>0]|0)==32);c[m>>2]=q;s=q}else{s=l}if((Dm(s,26160,3)|0)!=0){c[6510]=27328;o=0;i=k;return o|0}l=s+3|0;c[m>>2]=l;m=zm(l,0,10)|0;c[e>>2]=m;c[f>>2]=p;c[h>>2]=3;h=(j|0)==0?3:j;j=Ll(da(da(h<<2,p)|0,m)|0)|0;a:do{if((m+ -8|0)>>>0>32759){t=0;u=17}else{b:do{if((p|0)>0){f=b+168|0;e=b+172|0;l=m<<2;s=(m|0)>0;q=b+32|0;r=b+16|0;v=b+28|0;w=b+40|0;x=b+36|0;y=(h|0)<3;z=0;A=0;while(1){B=c[f>>2]|0;C=c[e>>2]|0;if(!(B>>>0<C>>>0)){if((c[q>>2]|0)==0){D=0;E=B;F=C}else{G=Fd[c[r>>2]&15](c[v>>2]|0,w,c[x>>2]|0)|0;if((G|0)==0){c[q>>2]=0;H=(c[e>>2]|0)+ -1|0;c[f>>2]=H;a[H>>0]=0;I=c[e>>2]|0;J=c[f>>2]|0}else{c[f>>2]=w;H=b+G+40|0;c[e>>2]=H;I=H;J=w}H=J+1|0;c[f>>2]=H;D=d[J>>0]|0;E=H;F=I}}else{H=B+1|0;c[f>>2]=H;D=d[B>>0]|0;E=H;F=C}if(!(E>>>0<F>>>0)){if((c[q>>2]|0)==0){K=0;L=E;M=F}else{C=Fd[c[r>>2]&15](c[v>>2]|0,w,c[x>>2]|0)|0;if((C|0)==0){c[q>>2]=0;H=(c[e>>2]|0)+ -1|0;c[f>>2]=H;a[H>>0]=0;N=c[e>>2]|0;O=c[f>>2]|0}else{c[f>>2]=w;H=b+C+40|0;c[e>>2]=H;N=H;O=w}H=O+1|0;c[f>>2]=H;K=d[O>>0]|0;L=H;M=N}}else{H=E+1|0;c[f>>2]=H;K=d[E>>0]|0;L=H;M=F}if(!(L>>>0<M>>>0)){if((c[q>>2]|0)==0){P=0;Q=L}else{H=Fd[c[r>>2]&15](c[v>>2]|0,w,c[x>>2]|0)|0;if((H|0)==0){c[q>>2]=0;C=(c[e>>2]|0)+ -1|0;c[f>>2]=C;a[C>>0]=0;R=c[f>>2]|0}else{c[f>>2]=w;c[e>>2]=b+H+40;R=w}H=R+1|0;c[f>>2]=H;P=d[R>>0]|0;Q=H}}else{H=L+1|0;c[f>>2]=H;P=d[L>>0]|0;Q=H}if(!((D|0)==2&(K|0)==2)){S=D;T=K;break}if((P&128|0)!=0){S=2;T=2;break}H=P<<8;if(!(Q>>>0<(c[e>>2]|0)>>>0)){if((c[q>>2]|0)==0){U=0}else{C=Fd[c[r>>2]&15](c[v>>2]|0,w,c[x>>2]|0)|0;if((C|0)==0){c[q>>2]=0;B=(c[e>>2]|0)+ -1|0;c[f>>2]=B;a[B>>0]=0;V=c[f>>2]|0}else{c[f>>2]=w;c[e>>2]=b+C+40;V=w}c[f>>2]=V+1;U=d[V>>0]|0}}else{c[f>>2]=Q+1;U=d[Q>>0]|0}if((U|H|0)!=(m|0)){u=89;break}if((A|0)==0){W=Ll(l)|0}else{W=A}H=0;do{if(s){C=0;while(1){B=c[f>>2]|0;do{if(B>>>0<(c[e>>2]|0)>>>0){G=B+1|0;c[f>>2]=G;X=d[B>>0]|0;Y=G}else{if((c[q>>2]|0)==0){X=0;Y=B;break}G=Fd[c[r>>2]&15](c[v>>2]|0,w,c[x>>2]|0)|0;if((G|0)==0){c[q>>2]=0;Z=(c[e>>2]|0)+ -1|0;c[f>>2]=Z;a[Z>>0]=0;_=c[f>>2]|0}else{c[f>>2]=w;c[e>>2]=b+G+40;_=w}G=_+1|0;c[f>>2]=G;X=d[_>>0]|0;Y=G}}while(0);do{if((X&255)>128){do{if(Y>>>0<(c[e>>2]|0)>>>0){c[f>>2]=Y+1;$=d[Y>>0]|0}else{if((c[q>>2]|0)==0){$=0;break}B=Fd[c[r>>2]&15](c[v>>2]|0,w,c[x>>2]|0)|0;if((B|0)==0){c[q>>2]=0;G=(c[e>>2]|0)+ -1|0;c[f>>2]=G;a[G>>0]=0;aa=c[f>>2]|0}else{c[f>>2]=w;c[e>>2]=b+B+40;aa=w}c[f>>2]=aa+1;$=d[aa>>0]|0}}while(0);B=$&255;G=X+128&255;if((G|0)==0){ba=C;break}Z=G>>>0>1;ca=C;ea=0;while(1){a[W+((ca<<2)+H)>>0]=B;ea=ea+1|0;if((ea|0)>=(G|0)){break}else{ca=ca+1|0}}ba=(Z?G:1)+C|0}else{if((X|0)==0){ba=C;break}ca=X>>>0>1;ea=Y;B=C;fa=1;while(1){do{if(ea>>>0<(c[e>>2]|0)>>>0){c[f>>2]=ea+1;ga=d[ea>>0]|0}else{if((c[q>>2]|0)==0){ga=0;break}ha=Fd[c[r>>2]&15](c[v>>2]|0,w,c[x>>2]|0)|0;if((ha|0)==0){c[q>>2]=0;ia=(c[e>>2]|0)+ -1|0;c[f>>2]=ia;a[ia>>0]=0;ja=c[f>>2]|0}else{c[f>>2]=w;c[e>>2]=b+ha+40;ja=w}c[f>>2]=ja+1;ga=d[ja>>0]|0}}while(0);a[W+((B<<2)+H)>>0]=ga;if((fa|0)>=(X|0)){break}ea=c[f>>2]|0;B=B+1|0;fa=fa+1|0}ba=(ca?X:1)+C|0}}while(0);if((ba|0)<(m|0)){C=ba}else{break}}}H=H+1|0}while((H|0)!=4);if(s){H=da(z,m)|0;C=0;do{fa=da(C+H|0,h)|0;B=j+(fa<<2)|0;ea=C<<2;G=a[W+(ea|3)>>0]|0;do{if(G<<24>>24==0){if((h|0)==4){g[j+(fa+3<<2)>>2]=1.0;u=138}else if((h|0)==3){u=138}else if((h|0)==2){g[j+(fa+1<<2)>>2]=1.0;u=140}else if((h|0)==1){u=140}else{break}if((u|0)==138){u=0;g[j+(fa+2<<2)>>2]=0.0;g[j+(fa+1<<2)>>2]=0.0;g[B>>2]=0.0;break}else if((u|0)==140){u=0;g[B>>2]=0.0;break}}else{ka=+sl(1.0,(G&255)+ -136|0);Z=d[W+ea>>0]|0;if(y){g[B>>2]=ka*+((d[W+(ea|1)>>0]|0)+Z+(d[W+(ea|2)>>0]|0)|0)/3.0}else{g[B>>2]=ka*+(Z|0);g[j+(fa+1<<2)>>2]=ka*+(d[W+(ea|1)>>0]|0);g[j+(fa+2<<2)>>2]=ka*+(d[W+(ea|2)>>0]|0)}if((h|0)==2){g[j+(fa+1<<2)>>2]=1.0;break}else if((h|0)==4){g[j+(fa+3<<2)>>2]=1.0;break}else{break}}}while(0);C=C+1|0}while((C|0)!=(m|0))}z=z+1|0;if((z|0)>=(p|0)){la=W;break b}else{A=W}}if((u|0)==89){Ml(j);Ml(A);c[6510]=27352;o=0;i=k;return o|0}do{if(!(Q>>>0<(c[e>>2]|0)>>>0)){if((c[q>>2]|0)!=0){z=Fd[c[r>>2]&15](c[v>>2]|0,w,c[x>>2]|0)|0;if((z|0)==0){c[q>>2]=0;s=(c[e>>2]|0)+ -1|0;c[f>>2]=s;a[s>>0]=0;ma=c[f>>2]|0;u=68;break}else{c[f>>2]=w;c[e>>2]=b+z+40;ma=w;u=68;break}}else{u=75}}else{ma=Q;u=68}}while(0);do{if((u|0)==68){c[f>>2]=ma+1;w=a[ma>>0]|0;if(!(w<<24>>24==0)){ka=+sl(1.0,(w&255)+ -136|0);if(y){g[j>>2]=+(T+P+S|0)*ka/3.0}else{g[j>>2]=+(S|0)*ka;g[j+4>>2]=+(T|0)*ka;g[j+8>>2]=+(P|0)*ka}if((h|0)==4){g[j+12>>2]=1.0;break}else if((h|0)==2){g[j+4>>2]=1.0;break}else{break}}else{u=75}}}while(0);do{if((u|0)==75){if((h|0)==4){g[j+12>>2]=1.0;u=77}else if((h|0)==3){u=77}else if((h|0)==2){g[j+4>>2]=1.0;u=79}else if((h|0)==1){u=79}else{break}if((u|0)==77){g[j+8>>2]=0.0;g[j+4>>2]=0.0;g[j>>2]=0.0;break}else if((u|0)==79){g[j>>2]=0.0;break}}}while(0);Ml(A);na=r;oa=1;pa=0;u=20;break a}else{la=0}}while(0);Ml(la);o=j;i=k;return o|0}}while(0);while(1){if((u|0)==17){u=0;if((t|0)<(p|0)){qa=0;ra=t}else{o=j;break}}else if((u|0)==20){u=0;la=c[na>>2]|0;if((la|0)!=0){P=b+172|0;T=c[P>>2]|0;S=b+168|0;ma=c[S>>2]|0;Q=T-ma|0;if((Q|0)<4){Mm(n|0,ma|0,Q|0)|0;Fd[la&15](c[b+28>>2]|0,n+Q|0,4-Q|0)|0;c[S>>2]=c[P>>2]}else{sa=ma;ta=T;u=24}}else{sa=c[b+168>>2]|0;ta=c[b+172>>2]|0;u=24}if((u|0)==24?(u=0,T=sa+4|0,!(T>>>0>ta>>>0)):0){c[n>>2]=d[sa>>0]|d[sa+1>>0]<<8|d[sa+2>>0]<<16|d[sa+3>>0]<<24;c[b+168>>2]=T}T=da((da(pa,m)|0)+oa|0,h)|0;ma=j+(T<<2)|0;P=a[n+3>>0]|0;do{if(P<<24>>24==0){if((h|0)==3){u=35}else if((h|0)==1){u=37}else if((h|0)==4){g[j+(T+3<<2)>>2]=1.0;u=35}else if((h|0)==2){g[j+(T+1<<2)>>2]=1.0;u=37}else{break}if((u|0)==35){u=0;g[j+(T+2<<2)>>2]=0.0;g[j+(T+1<<2)>>2]=0.0;g[ma>>2]=0.0;break}else if((u|0)==37){u=0;g[ma>>2]=0.0;break}}else{ka=+sl(1.0,(P&255)+ -136|0);S=c[n>>2]|0;Q=S&255;la=S>>>16;W=S>>>8&255;if((h|0)<3){g[ma>>2]=ka*+(W+Q+(la&255)|0)/3.0}else{g[ma>>2]=ka*+(Q|0);g[j+(T+1<<2)>>2]=ka*+(W|0);g[j+(T+2<<2)>>2]=ka*+(la&255|0)}if((h|0)==4){g[j+(T+3<<2)>>2]=1.0;break}else if((h|0)==2){g[j+(T+1<<2)>>2]=1.0;break}else{break}}}while(0);qa=oa+1|0;ra=pa}if((qa|0)<(m|0)){na=b+16|0;oa=qa;pa=ra;u=20;continue}else{t=ra+1|0;u=17;continue}}i=k;return o|0}}c[6510]=27304;o=0;i=k;return o|0}function zk(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0;j=i;i=i+2512|0;k=j;l=j+2044|0;m=j+2020|0;n=j+2040|0;o=b+20|0;c[o>>2]=e;p=b+16|0;c[p>>2]=e;q=b+24|0;c[q>>2]=e+f;f=b+28|0;c[f>>2]=g;if((h|0)!=0){h=c[b>>2]|0;g=b+4|0;e=c[g>>2]|0;if(h>>>0<e>>>0){r=h+1|0;c[b>>2]=r;s=d[h>>0]|0;t=r}else{s=0;t=h}if(t>>>0<e>>>0){c[b>>2]=t+1;u=d[t>>0]|0}else{u=0}if((((u|s<<8)>>>0)%31|0|0)!=0){c[6510]=28616;v=0;i=j;return v|0}if((u&32|0)!=0){c[6510]=28632;v=0;i=j;return v|0}if((s&15|0)==8){w=g}else{c[6510]=28648;v=0;i=j;return v|0}}else{w=b+4|0}g=b+8|0;c[g>>2]=0;s=b+12|0;c[s>>2]=0;u=b+32|0;t=b+2052|0;e=n+1|0;h=n+3|0;r=n+2|0;x=0;y=0;a:while(1){if((y|0)>=1){z=x&1;A=x>>>1;c[s>>2]=A;B=y+ -1|0;c[g>>2]=B;if((y|0)<3){C=B;D=A;while(1){if(!(D>>>0<1<<C>>>0)){E=23;break a}F=c[b>>2]|0;if(F>>>0<(c[w>>2]|0)>>>0){c[b>>2]=F+1;G=d[F>>0]|0}else{G=0}F=G<<C|D;c[s>>2]=F;H=C+8|0;c[g>>2]=H;if((H|0)<25){C=H;D=F}else{I=z;J=F;K=H;break}}}else{I=z;J=A;K=B}}else{D=y;C=x;while(1){if(!(C>>>0<1<<D>>>0)){E=16;break a}H=c[b>>2]|0;if(H>>>0<(c[w>>2]|0)>>>0){c[b>>2]=H+1;L=d[H>>0]|0}else{L=0}C=L<<D|C;c[s>>2]=C;H=D+8|0;c[g>>2]=H;if((H|0)>=25){break}else{D=H}}B=C>>>1;c[s>>2]=B;A=D+7|0;c[g>>2]=A;I=C&1;J=B;K=A}A=J&3;B=J>>>2;c[s>>2]=B;z=K+ -2|0;c[g>>2]=z;if((A|0)==0){H=z&7;if((H|0)==0){M=B;N=z}else{if((z|0)<(H|0)){F=z;O=B;while(1){if(!(O>>>0<1<<F>>>0)){E=31;break a}P=c[b>>2]|0;if(P>>>0<(c[w>>2]|0)>>>0){c[b>>2]=P+1;Q=d[P>>0]|0}else{Q=0}P=Q<<F|O;c[s>>2]=P;R=F+8|0;c[g>>2]=R;if((R|0)<25){F=R;O=P}else{S=P;T=R;break}}}else{S=B;T=z}O=S>>>H;c[s>>2]=O;F=T-H|0;c[g>>2]=F;M=O;N=F}if((N|0)>0){F=7-N|0;O=(((F|0)>-1?F:-1)+N|0)>>>3;F=M;C=N;D=0;while(1){a[n+D>>0]=F;F=F>>>8;C=C+ -8|0;if((C|0)<=0){break}else{D=D+1|0}}D=N+ -8-(O<<3)|0;c[s>>2]=F;c[g>>2]=D;U=D;V=O+1|0}else{U=N;V=0}if((U|0)!=0){E=43;break}if((V|0)<4){D=c[w>>2]|0;C=c[b>>2]|0;H=V;while(1){if(C>>>0<D>>>0){R=C+1|0;c[b>>2]=R;W=a[C>>0]|0;X=R}else{W=0;X=C}a[n+H>>0]=W;H=H+1|0;if((H|0)==4){break}else{C=X}}}C=d[e>>0]<<8|d[n>>0];if((d[h>>0]<<8|d[r>>0]|0)!=(C^65535|0)){E=48;break}H=c[b>>2]|0;if((H+C|0)>>>0>(c[w>>2]|0)>>>0){E=50;break}D=c[p>>2]|0;O=c[q>>2]|0;if((D+C|0)>>>0>O>>>0){if((c[f>>2]|0)==0){E=53;break}F=c[o>>2]|0;R=F;P=D-R|0;Y=P+C|0;Z=O-R|0;while(1){if((Y|0)>(Z|0)){Z=Z<<1}else{break}}Y=Ol(F,Z)|0;if((Y|0)==0){E=57;break}c[o>>2]=Y;R=Y+P|0;c[p>>2]=R;c[q>>2]=Y+Z;_=R;$=c[b>>2]|0}else{_=D;$=H}Mm(_|0,$|0,C|0)|0;c[b>>2]=(c[b>>2]|0)+C;c[p>>2]=(c[p>>2]|0)+C}else if((A|0)==1){if((a[27431>>0]|0)==0){Om(27432,8,144)|0;aa=27576|0;ba=aa+112|0;do{a[aa>>0]=9;aa=aa+1|0}while((aa|0)<(ba|0));aa=27688|0;ba=aa+24|0;do{a[aa>>0]=7;aa=aa+1|0}while((aa|0)<(ba|0));C=27712|0;H=C;a[H>>0]=134744072;a[H+1>>0]=526344;a[H+2>>0]=2056;a[H+3>>0]=8;H=C+4|0;a[H>>0]=134744072;a[H+1>>0]=526344;a[H+2>>0]=2056;a[H+3>>0]=8;aa=27400|0;ba=aa+32|0;do{a[aa>>0]=5;aa=aa+1|0}while((aa|0)<(ba|0))}if((Jk(u,27432,288)|0)==0){v=0;E=172;break}if((Jk(t,27400,32)|0)==0){v=0;E=172;break}else{E=124}}else if((A|0)!=3){if((z|0)<5){H=z;C=B;while(1){if(!(C>>>0<1<<H>>>0)){E=66;break a}D=c[b>>2]|0;if(D>>>0<(c[w>>2]|0)>>>0){c[b>>2]=D+1;ca=d[D>>0]|0}else{ca=0}D=ca<<H|C;c[s>>2]=D;Z=H+8|0;c[g>>2]=Z;if((Z|0)<25){H=Z;C=D}else{da=D;ea=Z;break}}}else{da=B;ea=z}C=da>>>5;c[s>>2]=C;H=ea+ -5|0;c[g>>2]=H;A=(da&31)+257|0;if((H|0)<5){Z=H;D=C;while(1){if(!(D>>>0<1<<Z>>>0)){E=72;break a}P=c[b>>2]|0;if(P>>>0<(c[w>>2]|0)>>>0){c[b>>2]=P+1;fa=d[P>>0]|0}else{fa=0}P=fa<<Z|D;c[s>>2]=P;F=Z+8|0;c[g>>2]=F;if((F|0)<25){Z=F;D=P}else{ga=P;ha=F;break}}}else{ga=C;ha=H}D=ga>>>5;c[s>>2]=D;Z=ha+ -5|0;c[g>>2]=Z;z=(ga&31)+1|0;if((Z|0)<4){B=Z;F=D;while(1){if(!(F>>>0<1<<B>>>0)){E=78;break a}P=c[b>>2]|0;if(P>>>0<(c[w>>2]|0)>>>0){c[b>>2]=P+1;ia=d[P>>0]|0}else{ia=0}P=ia<<B|F;c[s>>2]=P;R=B+8|0;c[g>>2]=R;if((R|0)<25){B=R;F=P}else{ja=P;ka=R;break}}}else{ja=D;ka=Z}F=ja>>>4;c[s>>2]=F;B=ka+ -4|0;c[g>>2]=B;H=(ja&15)+4|0;aa=m+0|0;ba=aa+19|0;do{a[aa>>0]=0;aa=aa+1|0}while((aa|0)<(ba|0));Z=F;D=B;C=0;do{if((D|0)<3){R=D;P=Z;while(1){if(!(P>>>0<1<<R>>>0)){E=85;break a}Y=c[b>>2]|0;if(Y>>>0<(c[w>>2]|0)>>>0){c[b>>2]=Y+1;la=d[Y>>0]|0}else{la=0}Y=la<<R|P;c[s>>2]=Y;O=R+8|0;c[g>>2]=O;if((O|0)<25){R=O;P=Y}else{ma=Y;na=O;break}}}else{ma=Z;na=D}Z=ma>>>3;c[s>>2]=Z;D=na+ -3|0;c[g>>2]=D;a[m+(d[28384+C>>0]|0)>>0]=ma&7;C=C+1|0}while((C|0)<(H|0));if((Jk(k,m,19)|0)==0){v=0;E=172;break}H=z+A|0;if((H|0)>0){C=0;while(1){D=Kk(b,k)|0;if(!(D>>>0<19)){E=93;break a}do{if((D|0)>=16){if((D|0)==18){Z=c[g>>2]|0;B=c[s>>2]|0;if((Z|0)<7){F=Z;P=B;while(1){if(!(P>>>0<1<<F>>>0)){E=115;break a}R=c[b>>2]|0;if(R>>>0<(c[w>>2]|0)>>>0){c[b>>2]=R+1;oa=d[R>>0]|0}else{oa=0}R=oa<<F|P;c[s>>2]=R;O=F+8|0;c[g>>2]=O;if((O|0)<25){F=O;P=R}else{pa=R;qa=O;break}}}else{pa=B;qa=Z}c[s>>2]=pa>>>7;c[g>>2]=qa+ -7;P=(pa&127)+11|0;Om(l+C|0,0,P|0)|0;ra=P+C|0;break}else if((D|0)==17){P=c[g>>2]|0;F=c[s>>2]|0;if((P|0)<3){O=P;R=F;while(1){if(!(R>>>0<1<<O>>>0)){E=107;break a}Y=c[b>>2]|0;if(Y>>>0<(c[w>>2]|0)>>>0){c[b>>2]=Y+1;sa=d[Y>>0]|0}else{sa=0}Y=sa<<O|R;c[s>>2]=Y;ta=O+8|0;c[g>>2]=ta;if((ta|0)<25){O=ta;R=Y}else{ua=Y;va=ta;break}}}else{ua=F;va=P}c[s>>2]=ua>>>3;c[g>>2]=va+ -3;R=(ua&7)+3|0;Om(l+C|0,0,R|0)|0;ra=R+C|0;break}else if((D|0)==16){R=c[g>>2]|0;O=c[s>>2]|0;if((R|0)<2){Z=R;B=O;while(1){if(!(B>>>0<1<<Z>>>0)){E=99;break a}ta=c[b>>2]|0;if(ta>>>0<(c[w>>2]|0)>>>0){c[b>>2]=ta+1;wa=d[ta>>0]|0}else{wa=0}ta=wa<<Z|B;c[s>>2]=ta;Y=Z+8|0;c[g>>2]=Y;if((Y|0)<25){Z=Y;B=ta}else{xa=ta;ya=Y;break}}}else{xa=O;ya=R}c[s>>2]=xa>>>2;c[g>>2]=ya+ -2;B=(xa&3)+3|0;Om(l+C|0,a[l+(C+ -1)>>0]|0,B|0)|0;ra=B+C|0;break}else{E=112;break a}}else{a[l+C>>0]=D;ra=C+1|0}}while(0);if((ra|0)<(H|0)){C=ra}else{za=ra;break}}}else{za=0}if((za|0)!=(H|0)){E=121;break}if((Jk(u,l,A)|0)==0){v=0;E=172;break}if((Jk(t,l+A|0,z)|0)!=0){E=124}else{v=0;E=172;break}}else{v=0;E=172;break}b:do{if((E|0)==124){c:while(1){E=0;C=Kk(b,u)|0;if((C|0)<256){if((C|0)<0){E=126;break a}D=c[p>>2]|0;B=c[q>>2]|0;if(D>>>0<B>>>0){Aa=D}else{if((c[f>>2]|0)==0){E=129;break a}Z=c[o>>2]|0;P=Z;F=D-P|0;D=B-P|0;while(1){if((F|0)<(D|0)){break}else{D=D<<1}}R=Ol(Z,D)|0;if((R|0)==0){E=133;break a}c[o>>2]=R;O=R+F|0;c[p>>2]=O;c[q>>2]=R+D;Aa=O}c[p>>2]=Aa+1;a[Aa>>0]=C;E=124;continue}if((C|0)==256){break b}O=C+ -257|0;R=c[27744+(O<<2)>>2]|0;if((C+ -265|0)>>>0<20){P=c[27872+(O<<2)>>2]|0;O=c[g>>2]|0;B=c[s>>2]|0;if((O|0)<(P|0)){Y=O;ta=B;while(1){if(!(ta>>>0<1<<Y>>>0)){E=140;break a}Ba=c[b>>2]|0;if(Ba>>>0<(c[w>>2]|0)>>>0){c[b>>2]=Ba+1;Ca=d[Ba>>0]|0}else{Ca=0}Ba=Ca<<Y|ta;c[s>>2]=Ba;Da=Y+8|0;c[g>>2]=Da;if((Da|0)<25){Y=Da;ta=Ba}else{Ea=Ba;Fa=Da;break}}}else{Ea=B;Fa=O}c[s>>2]=Ea>>>P;c[g>>2]=Fa-P;Ha=(Ea&(1<<P)+ -1)+R|0}else{Ha=R}ta=Kk(b,t)|0;if((ta|0)<0){E=146;break a}Y=c[28e3+(ta<<2)>>2]|0;if((ta+ -4|0)>>>0<26){C=c[28128+(ta<<2)>>2]|0;ta=c[g>>2]|0;D=c[s>>2]|0;if((ta|0)<(C|0)){F=ta;Z=D;while(1){if(!(Z>>>0<1<<F>>>0)){E=150;break a}Da=c[b>>2]|0;if(Da>>>0<(c[w>>2]|0)>>>0){c[b>>2]=Da+1;Ia=d[Da>>0]|0}else{Ia=0}Da=Ia<<F|Z;c[s>>2]=Da;Ba=F+8|0;c[g>>2]=Ba;if((Ba|0)<25){F=Ba;Z=Da}else{Ja=Da;Ka=Ba;break}}}else{Ja=D;Ka=ta}c[s>>2]=Ja>>>C;c[g>>2]=Ka-C;La=(Ja&(1<<C)+ -1)+Y|0}else{La=Y}Z=c[p>>2]|0;F=c[o>>2]|0;R=F;P=Z-R|0;if((P|0)<(La|0)){E=156;break a}O=c[q>>2]|0;if((Z+Ha|0)>>>0>O>>>0){if((c[f>>2]|0)==0){E=159;break a}B=P+Ha|0;Ba=O-R|0;while(1){if((B|0)>(Ba|0)){Ba=Ba<<1}else{break}}B=Ol(F,Ba)|0;if((B|0)==0){E=163;break a}c[o>>2]=B;Y=B+P|0;c[p>>2]=Y;c[q>>2]=B+Ba;Ma=Y}else{Ma=Z}if((Ha|0)==0){E=124;continue}Y=Ma+(0-La)|0;B=Ha+ -1|0;C=a[Y>>0]|0;c[p>>2]=Ma+1;a[Ma>>0]=C;if((B|0)==0){E=124;continue}else{Na=B;Oa=Y}while(1){Y=Oa+1|0;B=c[p>>2]|0;C=Na+ -1|0;ta=a[Y>>0]|0;c[p>>2]=B+1;a[B>>0]=ta;if((C|0)==0){E=124;continue c}else{Na=C;Oa=Y}}}}}while(0);if((c[6522]|0)==0){if((I|0)!=0){v=1;E=172;break}}else{if(!((I|0)==0?((c[p>>2]|0)-(c[o>>2]|0)|0)<65537:0)){v=1;E=172;break}}x=c[s>>2]|0;y=c[g>>2]|0}switch(E|0){case 16:{Ga(28328,26544,1727,28368);break};case 23:{Ga(28328,26544,1727,28368);break};case 31:{Ga(28328,26544,1727,28368);break};case 43:{Ga(28520,26544,1888,28544);break};case 48:{c[6510]=28576;v=0;i=j;return v|0};case 50:{c[6510]=28592;v=0;i=j;return v|0};case 53:{c[6510]=28272;v=0;i=j;return v|0};case 57:{c[6510]=26456;v=0;i=j;return v|0};case 66:{Ga(28328,26544,1727,28368);break};case 72:{Ga(28328,26544,1727,28368);break};case 78:{Ga(28328,26544,1727,28368);break};case 85:{Ga(28328,26544,1727,28368);break};case 93:{Ga(28408,26544,1851,28432);break};case 99:{Ga(28328,26544,1727,28368);break};case 107:{Ga(28328,26544,1727,28368);break};case 112:{Ga(28456,26544,1863,28432);break};case 115:{Ga(28328,26544,1727,28368);break};case 121:{c[6510]=28464;v=0;i=j;return v|0};case 126:{c[6510]=27720;v=0;i=j;return v|0};case 129:{c[6510]=28272;v=0;i=j;return v|0};case 133:{c[6510]=26456;v=0;i=j;return v|0};case 140:{Ga(28328,26544,1727,28368);break};case 146:{c[6510]=27720;v=0;i=j;return v|0};case 150:{Ga(28328,26544,1727,28368);break};case 156:{c[6510]=28256;v=0;i=j;return v|0};case 159:{c[6510]=28272;v=0;i=j;return v|0};case 163:{c[6510]=26456;v=0;i=j;return v|0};case 172:{i=j;return v|0}}return 0}function Ak(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=b+168|0;g=c[f>>2]|0;h=b+172|0;if(g>>>0<(c[h>>2]|0)>>>0){c[f>>2]=g+1;j=d[g>>0]|0;i=e;return j|0}g=b+32|0;if((c[g>>2]|0)==0){j=0;i=e;return j|0}k=b+40|0;l=Fd[c[b+16>>2]&15](c[b+28>>2]|0,k,c[b+36>>2]|0)|0;if((l|0)==0){c[g>>2]=0;g=(c[h>>2]|0)+ -1|0;c[f>>2]=g;a[g>>0]=0;m=c[f>>2]|0}else{c[f>>2]=k;c[h>>2]=b+l+40;m=k}c[f>>2]=m+1;j=d[m>>0]|0;i=e;return j|0}function Bk(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;e=Ak(b)|0;a:do{if((Ck(b)|0)==0){f=e;g=0;while(1){if((f&255|0)==10){h=g;break a}j=g+1|0;a[c+g>>0]=f;if((j|0)==1023){break}f=Ak(b)|0;if((Ck(b)|0)!=0){h=j;break a}else{g=j}}while(1){if((Ck(b)|0)!=0){h=1023;break a}if((Ak(b)|0)==10){h=1023;break}}}else{h=0}}while(0);a[c+h>>0]=0;i=d;return c|0}function Ck(a){a=a|0;var b=0,d=0;b=i;if((c[a+16>>2]|0)!=0){if((Nd[c[a+24>>2]&63](c[a+28>>2]|0)|0)==0){d=0;i=b;return d|0}if((c[a+32>>2]|0)==0){d=1;i=b;return d|0}}d=(c[a+168>>2]|0)>>>0>=(c[a+172>>2]|0)>>>0&1;i=b;return d|0}function Dk(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0;h=i;j=b+168|0;k=c[j>>2]|0;l=b+172|0;do{if(!(k>>>0<(c[l>>2]|0)>>>0)){m=b+32|0;if((c[m>>2]|0)!=0){n=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[l>>2]|0)+ -1|0;c[j>>2]=m;a[m>>0]=0;p=c[j>>2]|0;q=6;break}else{c[j>>2]=n;c[l>>2]=b+o+40;p=n;q=6;break}}}else{p=k;q=6}}while(0);a:do{if((q|0)==6?(k=p+1|0,c[j>>2]=k,(a[p>>0]|0)==71):0){do{if(!(k>>>0<(c[l>>2]|0)>>>0)){n=b+32|0;if((c[n>>2]|0)==0){break a}o=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((m|0)==0){c[n>>2]=0;n=(c[l>>2]|0)+ -1|0;c[j>>2]=n;a[n>>0]=0;r=c[j>>2]|0;break}else{c[j>>2]=o;c[l>>2]=b+m+40;r=o;break}}else{r=k}}while(0);k=r+1|0;c[j>>2]=k;if((a[r>>0]|0)==73){do{if(!(k>>>0<(c[l>>2]|0)>>>0)){o=b+32|0;if((c[o>>2]|0)==0){break a}m=b+40|0;n=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((n|0)==0){c[o>>2]=0;o=(c[l>>2]|0)+ -1|0;c[j>>2]=o;a[o>>0]=0;s=c[j>>2]|0;break}else{c[j>>2]=m;c[l>>2]=b+n+40;s=m;break}}else{s=k}}while(0);k=s+1|0;c[j>>2]=k;if((a[s>>0]|0)==70){do{if(!(k>>>0<(c[l>>2]|0)>>>0)){m=b+32|0;if((c[m>>2]|0)==0){break a}n=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[l>>2]|0)+ -1|0;c[j>>2]=m;a[m>>0]=0;t=c[j>>2]|0;break}else{c[j>>2]=n;c[l>>2]=b+o+40;t=n;break}}else{t=k}}while(0);k=t+1|0;c[j>>2]=k;if((a[t>>0]|0)==56){if(!(k>>>0<(c[l>>2]|0)>>>0)){n=b+32|0;if((c[n>>2]|0)==0){u=0;v=k}else{o=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((m|0)==0){c[n>>2]=0;n=(c[l>>2]|0)+ -1|0;c[j>>2]=n;a[n>>0]=0;w=c[j>>2]|0}else{c[j>>2]=o;c[l>>2]=b+m+40;w=o}o=w+1|0;c[j>>2]=o;u=d[w>>0]|0;v=o}}else{o=t+2|0;c[j>>2]=o;u=d[k>>0]|0;v=o}o=u&255;if(!(o<<24>>24==57|o<<24>>24==55)){c[6510]=26168;x=0;i=h;return x|0}do{if(!(v>>>0<(c[l>>2]|0)>>>0)){o=b+32|0;if((c[o>>2]|0)!=0){k=b+40|0;m=Fd[c[b+16>>2]&15](c[b+28>>2]|0,k,c[b+36>>2]|0)|0;if((m|0)==0){c[o>>2]=0;o=(c[l>>2]|0)+ -1|0;c[j>>2]=o;a[o>>0]=0;y=c[j>>2]|0;q=40;break}else{c[j>>2]=k;c[l>>2]=b+m+40;y=k;q=40;break}}}else{y=v;q=40}}while(0);if((q|0)==40?(c[j>>2]=y+1,(a[y>>0]|0)==97):0){c[6510]=26176;k=c[j>>2]|0;m=c[l>>2]|0;if(!(k>>>0<m>>>0)){o=b+32|0;if((c[o>>2]|0)==0){z=0;A=k;B=m}else{n=b+40|0;C=Fd[c[b+16>>2]&15](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((C|0)==0){c[o>>2]=0;o=(c[l>>2]|0)+ -1|0;c[j>>2]=o;a[o>>0]=0;D=c[l>>2]|0;E=c[j>>2]|0}else{c[j>>2]=n;o=b+C+40|0;c[l>>2]=o;D=o;E=n}n=E+1|0;c[j>>2]=n;z=d[E>>0]|0;A=n;B=D}}else{n=k+1|0;c[j>>2]=n;z=d[k>>0]|0;A=n;B=m}if(!(A>>>0<B>>>0)){m=b+32|0;if((c[m>>2]|0)==0){F=0;G=A;H=B}else{n=b+40|0;k=Fd[c[b+16>>2]&15](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((k|0)==0){c[m>>2]=0;m=(c[l>>2]|0)+ -1|0;c[j>>2]=m;a[m>>0]=0;I=c[l>>2]|0;J=c[j>>2]|0}else{c[j>>2]=n;m=b+k+40|0;c[l>>2]=m;I=m;J=n}n=J+1|0;c[j>>2]=n;F=d[J>>0]|0;G=n;H=I}}else{n=A+1|0;c[j>>2]=n;F=d[A>>0]|0;G=n;H=B}c[e>>2]=F<<8|z;if(!(G>>>0<H>>>0)){n=b+32|0;if((c[n>>2]|0)==0){K=0;L=G;M=H}else{m=b+40|0;k=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((k|0)==0){c[n>>2]=0;n=(c[l>>2]|0)+ -1|0;c[j>>2]=n;a[n>>0]=0;N=c[l>>2]|0;O=c[j>>2]|0}else{c[j>>2]=m;n=b+k+40|0;c[l>>2]=n;N=n;O=m}m=O+1|0;c[j>>2]=m;K=d[O>>0]|0;L=m;M=N}}else{m=G+1|0;c[j>>2]=m;K=d[G>>0]|0;L=m;M=H}if(!(L>>>0<M>>>0)){m=b+32|0;if((c[m>>2]|0)==0){P=0;Q=L;R=M}else{n=b+40|0;k=Fd[c[b+16>>2]&15](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((k|0)==0){c[m>>2]=0;m=(c[l>>2]|0)+ -1|0;c[j>>2]=m;a[m>>0]=0;S=c[l>>2]|0;T=c[j>>2]|0}else{c[j>>2]=n;m=b+k+40|0;c[l>>2]=m;S=m;T=n}n=T+1|0;c[j>>2]=n;P=d[T>>0]|0;Q=n;R=S}}else{n=L+1|0;c[j>>2]=n;P=d[L>>0]|0;Q=n;R=M}c[e+4>>2]=P<<8|K;do{if(Q>>>0<R>>>0){n=Q+1|0;c[j>>2]=n;U=d[Q>>0]|0;V=n;W=R}else{n=b+32|0;if((c[n>>2]|0)==0){U=0;V=Q;W=R;break}m=b+40|0;k=Fd[c[b+16>>2]&15](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((k|0)==0){c[n>>2]=0;n=(c[l>>2]|0)+ -1|0;c[j>>2]=n;a[n>>0]=0;X=c[l>>2]|0;Y=c[j>>2]|0}else{c[j>>2]=m;n=b+k+40|0;c[l>>2]=n;X=n;Y=m}m=Y+1|0;c[j>>2]=m;U=d[Y>>0]|0;V=m;W=X}}while(0);m=e+12|0;c[m>>2]=U;do{if(V>>>0<W>>>0){n=V+1|0;c[j>>2]=n;Z=d[V>>0]|0;_=n;$=W}else{n=b+32|0;if((c[n>>2]|0)==0){Z=0;_=V;$=W;break}k=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,k,c[b+36>>2]|0)|0;if((o|0)==0){c[n>>2]=0;n=(c[l>>2]|0)+ -1|0;c[j>>2]=n;a[n>>0]=0;aa=c[l>>2]|0;ba=c[j>>2]|0}else{c[j>>2]=k;n=b+o+40|0;c[l>>2]=n;aa=n;ba=k}k=ba+1|0;c[j>>2]=k;Z=d[ba>>0]|0;_=k;$=aa}}while(0);c[e+16>>2]=Z;do{if(_>>>0<$>>>0){k=_+1|0;c[j>>2]=k;ca=d[_>>0]|0;da=k}else{k=b+32|0;if((c[k>>2]|0)==0){ca=0;da=_;break}n=b+40|0;o=Fd[c[b+16>>2]&15](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((o|0)==0){c[k>>2]=0;k=(c[l>>2]|0)+ -1|0;c[j>>2]=k;a[k>>0]=0;ea=c[j>>2]|0}else{c[j>>2]=n;c[l>>2]=b+o+40;ea=n}n=ea+1|0;c[j>>2]=n;ca=d[ea>>0]|0;da=n}}while(0);c[e+20>>2]=ca;c[e+24>>2]=-1;if((f|0)!=0){c[f>>2]=4}if((g|0)!=0){x=1;i=h;return x|0}n=c[m>>2]|0;if((n&128|0)==0){x=1;i=h;return x|0}o=2<<(n&7);if((o|0)<=0){x=1;i=h;return x|0}n=b+32|0;k=b+16|0;C=b+28|0;fa=b+40|0;ga=b+36|0;ha=da;ia=0;while(1){do{if(ha>>>0<(c[l>>2]|0)>>>0){c[j>>2]=ha+1;ja=d[ha>>0]|0}else{if((c[n>>2]|0)==0){ja=0;break}ka=Fd[c[k>>2]&15](c[C>>2]|0,fa,c[ga>>2]|0)|0;if((ka|0)==0){c[n>>2]=0;la=(c[l>>2]|0)+ -1|0;c[j>>2]=la;a[la>>0]=0;ma=c[j>>2]|0}else{c[j>>2]=fa;c[l>>2]=b+ka+40;ma=fa}c[j>>2]=ma+1;ja=d[ma>>0]|0}}while(0);a[e+(ia<<2)+34>>0]=ja;ka=c[j>>2]|0;do{if(ka>>>0<(c[l>>2]|0)>>>0){c[j>>2]=ka+1;na=d[ka>>0]|0}else{if((c[n>>2]|0)==0){na=0;break}la=Fd[c[k>>2]&15](c[C>>2]|0,fa,c[ga>>2]|0)|0;if((la|0)==0){c[n>>2]=0;oa=(c[l>>2]|0)+ -1|0;c[j>>2]=oa;a[oa>>0]=0;pa=c[j>>2]|0}else{c[j>>2]=fa;c[l>>2]=b+la+40;pa=fa}c[j>>2]=pa+1;na=d[pa>>0]|0}}while(0);a[e+(ia<<2)+33>>0]=na;ka=c[j>>2]|0;do{if(ka>>>0<(c[l>>2]|0)>>>0){c[j>>2]=ka+1;qa=d[ka>>0]|0}else{if((c[n>>2]|0)==0){qa=0;break}la=Fd[c[k>>2]&15](c[C>>2]|0,fa,c[ga>>2]|0)|0;if((la|0)==0){c[n>>2]=0;oa=(c[l>>2]|0)+ -1|0;c[j>>2]=oa;a[oa>>0]=0;ra=c[j>>2]|0}else{c[j>>2]=fa;c[l>>2]=b+la+40;ra=fa}c[j>>2]=ra+1;qa=d[ra>>0]|0}}while(0);a[e+(ia<<2)+32>>0]=qa;a[e+(ia<<2)+35>>0]=0;ka=ia+1|0;if((ka|0)==(o|0)){x=1;break}ha=c[j>>2]|0;ia=ka}i=h;return x|0}c[6510]=26168;x=0;i=h;return x|0}}}}}while(0);c[6510]=26168;x=0;i=h;return x|0}



function $k(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;e=i;i=i+1536|0;f=e+1280|0;g=e;h=e+256|0;j=e+512|0;k=e+768|0;l=e+1024|0;if((d&16|0)!=0?(m=a[b>>0]|0,!(m<<24>>24==0)):0){n=m;m=b;while(1){a[m>>0]=$l(n&255)|0;o=m+1|0;if((n&255)>128){p=(n+96<<24>>24&255)>63?m+2|0:o}else{p=o}n=a[p>>0]|0;if(n<<24>>24==0){break}else{m=p}}}a[h>>0]=0;Rm(f|0,b|0)|0;p=a[f>>0]|0;if(!(p<<24>>24==0)){m=p&255;n=f;o=0;while(1){o=(m|0)==46?n:o;q=n+1|0;if((m&128|0)==0){r=a[q>>0]|0;s=q}else{t=q;while(1){q=a[t>>0]|0;if(q<<24>>24!=0&(q&-64)<<24>>24==-128){t=t+1|0}else{r=q;s=t;break}}}if(r<<24>>24==0){break}else{m=r&255;n=s}}if((o|0)!=0){Rm(l|0,o|0)|0;a[o>>0]=0;u=a[f>>0]|0}else{v=13}}else{v=13}if((v|0)==13){a[l>>0]=0;u=p}if(!(u<<24>>24==0)){p=u&255;u=f;o=0;while(1){o=(p|0)==47?u:o;s=u+1|0;if((p&128|0)==0){w=a[s>>0]|0;x=s}else{n=s;while(1){s=a[n>>0]|0;if(s<<24>>24!=0&(s&-64)<<24>>24==-128){n=n+1|0}else{w=s;x=n;break}}}if(w<<24>>24==0){break}else{p=w&255;u=x}}if((o|0)!=0){x=o+1|0;Rm(k|0,x|0)|0;a[x>>0]=0;Rm(j|0,f|0)|0}else{v=22}}else{v=22}if((v|0)==22){a[j>>0]=0;Rm(k|0,f|0)|0}Pm(h|0,j|0)|0;do{if((d&8|0)==0){if((d&32|0)==0){Rm(g|0,b|0)|0;break}else{Rm(g|0,h|0)|0;break}}else{Rm(g|0,k|0)|0;Pm(g|0,l|0)|0}}while(0);k=d&7;if((k|0)==1){d=Jm(g|0)|0;a[b+(d-(Jm(l|0)|0))>>0]=0;Rm(c|0,g|0)|0;i=e;return}else if((k|0)==2){Rm(c|0,l|0)|0;i=e;return}else{Rm(c|0,g|0)|0;i=e;return}}function al(a){a=a|0;var b=0,c=0;b=i;c=ib(a|0,493)|0;i=b;return c|0}function bl(a){a=a|0;var b=0,c=0;b=i;c=hc(a|0)|0;i=b;return c|0}function cl(a){a=a|0;var b=0,c=0;b=i;c=id(a|0)|0;i=b;return c|0}function dl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;f=i;i=i+336|0;g=f;h=f+76|0;$b(h|0,256)|0;j=vb(h|0)|0;h=Wa(j|0)|0;if((h|0)==0){k=0;jb(j|0)|0;i=f;return k|0}l=(e&4|0)==0;m=g+12|0;if((e|0)==0){n=h;o=0;while(1){p=n+11|0;q=a[p>>0]|0;r=q<<24>>24!=0&1;if(q<<24>>24==46){q=a[n+12>>0]|0;s=q<<24>>24==0?0:r;if(q<<24>>24==46){t=(a[n+13>>0]|0)==0?0:s}else{t=s}}else{t=r}if((t|0)!=0?(el(p,b)|0)!=0:0){Ri(d,p);Ri(d,29392);u=o+1|0}else{u=o}n=Wa(j|0)|0;if((n|0)==0){k=u;break}else{o=u}}jb(j|0)|0;i=f;return k|0}else{v=h;w=0}while(1){h=v+11|0;u=a[h>>0]|0;o=u<<24>>24!=0&1;if(u<<24>>24==46){u=a[v+12>>0]|0;n=u<<24>>24==0?0:o;if(u<<24>>24==46){x=(a[v+13>>0]|0)==0?0:n}else{x=n}}else{x=o}do{if((x|0)==1){Mb(h|0,g|0)|0;if(!l){if((c[m>>2]&61440|0)==32768?(a[h>>0]|0)!=46:0){y=w;break}else{z=3}}else{z=0}o=z^e;if((o&1|0)==0){A=1}else{A=(c[m>>2]&61440|0)!=16384&1}if((o&2|0)==0){B=A;C=14}else{B=(a[h>>0]|0)==46?0:A;C=14}}else{B=x;C=14}}while(0);if((C|0)==14){C=0;if((B|0)!=0?(el(h,b)|0)!=0:0){Ri(d,h);Ri(d,29392);y=w+1|0}else{y=w}}v=Wa(j|0)|0;if((v|0)==0){k=y;break}else{w=y}}jb(j|0)|0;i=f;return k|0}function el(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;e=b;b=c;a:while(1){c=a[b>>0]|0;f=b+1|0;if(c<<24>>24==0){g=a[e>>0]|0;if(g<<24>>24==0){h=1;j=14;break}else{k=g;l=e}}else{g=e;while(1){m=a[g>>0]|0;n=m<<24>>24==0;if(!(c<<24>>24==42)){break}o=a[f>>0]|0;if(n){j=6;break a}if(((o<<24>>24==42?1:o<<24>>24==m<<24>>24)|0)==0){g=g+1|0;continue}if((el(g,f)|0)!=0){h=1;j=14;break a}if(n){h=0;j=14;break a}else{g=g+1|0}}if(n){h=0;j=14;break}else{k=m;l=g}}if(!(c<<24>>24==k<<24>>24)){h=0;j=14;break}e=l+1|0;b=f}if((j|0)==6){i=d;return o<<24>>24==0|0}else if((j|0)==14){i=d;return h|0}return 0}function fl(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b;Vb(d|0,0)|0;e=Kb(d|0)|0;switch(a|0){case 8:{f=(c[d+4>>2]|0)%1e4|0;break};case 4:{f=c[e+8>>2]|0;break};case 6:{f=c[e>>2]|0;break};case 3:{f=c[e+12>>2]|0;break};case 5:{f=c[e+4>>2]|0;break};case 0:{f=(c[e+20>>2]|0)+1900|0;break};case 1:{f=(c[e+16>>2]|0)+1|0;break};case 7:{f=(c[d+4>>2]|0)/1e4|0;break};case 2:{f=c[e+24>>2]|0;break};default:{f=0}}i=b;return f|0}function gl(){c[7350]=0;return}function hl(){return c[7350]|0}function il(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;g=i;h=e<<24>>24;e=0;while(1){j=c[7350]|0;k=a[b+j>>0]|0;l=k&255;if(k<<24>>24==0){m=e;n=0;break}o=j+1|0;c[7350]=o;if((l|0)==(h|0)){m=e;n=k;break}if(k<<24>>24==13){p=5;break}else if(k<<24>>24==10){m=e;n=10;break}q=e+1|0;a[d+e>>0]=k;if((l&128|0)!=0){l=c[7350]|0;r=a[b+l>>0]|0;if(r<<24>>24!=0&(r&-64)<<24>>24==-128){s=l;l=r;t=q;while(1){c[7350]=s+1;u=t+1|0;a[d+t>>0]=l;s=c[7350]|0;v=a[b+s>>0]|0;if(!(v<<24>>24!=0&(v&-64)<<24>>24==-128)){w=u;x=v;break}else{l=v;t=u}}}else{w=q;x=r}}else{w=q;x=k}if((w|0)<(f|0)){e=w}else{m=w;n=x;break}}if((p|0)==5){if((a[b+o>>0]|0)==10){c[7350]=j+2;m=e;n=13}else{m=e;n=13}}a[d+m>>0]=0;i=g;return n&255|0}function jl(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if((a|0)>(c|0)){d=c}else{d=(a|0)<(b|0)?b:a}return d|0}function kl(b){b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0;c=i;d=a[b>>0]|0;if(d<<24>>24==0){e=0;i=c;return e|0}else{f=d;g=0;h=0}while(1){h=h+1|0;d=($l(f<<24>>24)|0)<<24;j=d>>24;if((d+ -788529153|0)>>>0<184549375){k=j+ -48|0}else{k=(d+ -1610612737|0)>>>0<117440511?j+ -87|0:0}j=k+(g<<4)|0;f=a[b+h>>0]|0;if(f<<24>>24==0){e=j;break}else{g=j}}i=c;return e|0}function ll(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;e=a[b>>0]|0;if(e<<24>>24==0){i=d;return}f=c&255;c=Jm(b|0)|0;g=e;while(1){e=g&255;h=0;j=b;k=0;while(1){l=j+1|0;if((e&128|0)==0){m=a[l>>0]|0;n=l}else{o=l;while(1){l=a[o>>0]|0;if(l<<24>>24!=0&(l&-64)<<24>>24==-128){o=o+1|0}else{m=l;n=o;break}}}o=(j|0)==0|(e|0)!=(f|0);h=o?h:j;k=o?k:n;if(m<<24>>24==0){break}else{e=m&255;j=n}}if((h|0)==0){p=11;break}if((k|0)!=(b+c|0)){p=11;break}a[h>>0]=0;c=Jm(b|0)|0;g=a[b>>0]|0;if(g<<24>>24==0){p=11;break}}if((p|0)==11){i=d;return}}function ml(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;e=a[b>>0]|0;if(e<<24>>24==0){i=d;return}f=c&255;c=e;a:while(1){e=c&255;g=b;while(1){h=g+1|0;if((e&128|0)==0){j=h}else{k=h;while(1){h=a[k>>0]|0;if(h<<24>>24!=0&(h&-64)<<24>>24==-128){k=k+1|0}else{j=k;break}}}if(!((g|0)==0|(e|0)!=(f|0))){break}k=a[j>>0]|0;if(k<<24>>24==0){l=9;break a}else{e=k&255;g=j}}Rm(g|0,j|0)|0;c=a[b>>0]|0;if(c<<24>>24==0){l=9;break}}if((l|0)==9){i=d;return}}function nl(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;e=a[b>>0]|0;if(e<<24>>24==0){i=d;return}f=c&255;c=b+1|0;g=e;while(1){e=g&255;h=(e|0)==(f|0)?b:0;if((e&128|0)==0){j=c}else{e=c;while(1){k=a[e>>0]|0;if(k<<24>>24!=0&(k&-64)<<24>>24==-128){e=e+1|0}else{j=e;break}}}if((h|0)==0){l=7;break}Rm(h|0,j|0)|0;g=a[b>>0]|0;if(g<<24>>24==0){l=7;break}}if((l|0)==7){i=d;return}}function ol(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;c[7352]=b;f=(Jm(b|0)|0)+16384|0;b=(f|0)<32768?32768:f;c[7354]=b;f=Mi(b)|0;c[7356]=f;a[f>>0]=0;f=Jm(d|0)|0;c[7358]=f;b=Mi(f+1|0)|0;c[7360]=b;Mm(b|0,d|0,(c[7358]|0)+1|0)|0;i=e;return}function pl(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=i;c[7362]=b;c[7364]=Jm(b|0)|0;c[7366]=0;b=c[7352]|0;e=a[c[7360]>>0]|0;f=a[b>>0]|0;if(f<<24>>24==0){g=0;h=c[7356]|0;j=h+g|0;a[j>>0]=0;k=c[7356]|0;i=d;return k|0}else{l=f;m=0;n=b}while(1){if(l<<24>>24==e<<24>>24){b=c[7358]|0;f=(Bm(n,c[7360]|0,b)|0)==0;o=f?c[7364]|0:1;p=f?b:0}else{o=1;p=0}b=o+m|0;f=c[7354]|0;if((b|0)>=(f|0)){q=f+32768|0;c[7354]=q;c[7356]=Pi(c[7356]|0,q)|0}if((p|0)==0){q=m+1|0;a[(c[7356]|0)+m>>0]=l;f=n+1|0;if(l<<24>>24<0?(r=a[f>>0]|0,r<<24>>24!=0&(r&-64)<<24>>24==-128):0){s=r;r=q;t=f;while(1){u=t+1|0;v=r+1|0;a[(c[7356]|0)+r>>0]=s;s=a[u>>0]|0;if(!(s<<24>>24!=0&(s&-64)<<24>>24==-128)){w=v;x=u;break}else{r=v;t=u}}}else{w=q;x=f}}else{Mm((c[7356]|0)+m|0,c[7362]|0,o|0)|0;c[7366]=(c[7366]|0)+1;w=b;x=n+p|0}l=a[x>>0]|0;if(l<<24>>24==0){g=w;break}else{m=w;n=x}}h=c[7356]|0;j=h+g|0;a[j>>0]=0;k=c[7356]|0;i=d;return k|0}function ql(){var a=0;a=i;Oi(c[7360]|0);Oi(c[7356]|0);i=a;return c[7366]|0}function rl(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+4112|0;e=d+16|0;f=d;c[f>>2]=b;vm(e,a,f)|0;Rc(29472,e|0)|0;i=d;return}function sl(a,b){a=+a;b=b|0;var c=0,d=0.0;c=i;d=+hm(a,b);i=c;return+d}function tl(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=b+(Jm(b|0)|0)|0;a:do{if((d|0)==0){g=f}else{h=d;j=c;k=f;while(1){l=a[j>>0]|0;if(l<<24>>24==0){g=k;break a}h=h+ -1|0;m=k+1|0;a[k>>0]=l;if((h|0)==0){g=m;break}else{j=j+1|0;k=m}}}}while(0);a[g>>0]=0;i=e;return b|0}function ul(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;g=a[d>>0]|0;if(g<<24>>24==0){h=0;i=e;return h|0}if((a[d+1>>0]|0)==0){j=b;while(1){if((a[j>>0]|0)==g<<24>>24){j=j+1|0}else{break}}h=j-b|0;i=e;return h|0}else{k=d;l=g}do{g=l&255;d=f+(g>>>5<<2)|0;c[d>>2]=c[d>>2]|1<<(g&31);k=k+1|0;l=a[k>>0]|0}while(!(l<<24>>24==0));l=a[b>>0]|0;a:do{if(l<<24>>24==0){m=b}else{k=b;g=l;while(1){d=g&255;j=k+1|0;if((c[f+(d>>>5<<2)>>2]&1<<(d&31)|0)==0){m=k;break a}g=a[j>>0]|0;if(g<<24>>24==0){m=j;break}else{k=j}}}}while(0);h=m-b|0;i=e;return h|0}function vl(a){a=a|0;return}function wl(a){a=a|0;return}function xl(a){a=a|0;return}function yl(a){a=a|0;return}function zl(a){a=a|0;var b=0;b=i;Tl(a);i=b;return}function Al(a){a=a|0;var b=0;b=i;Tl(a);i=b;return}function Bl(a){a=a|0;var b=0;b=i;Tl(a);i=b;return}function Cl(a,b,c){a=a|0;b=b|0;c=c|0;return(a|0)==(b|0)|0}function Dl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+64|0;f=e;if((a|0)==(b|0)){g=1;i=e;return g|0}if((b|0)==0){g=0;i=e;return g|0}h=Gl(b,29576,29632,0)|0;if((h|0)==0){g=0;i=e;return g|0}b=f+0|0;j=b+56|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(j|0));c[f>>2]=h;c[f+8>>2]=a;c[f+12>>2]=-1;c[f+48>>2]=1;Ud[c[(c[h>>2]|0)+28>>2]&3](h,f,c[d>>2]|0,1);if((c[f+24>>2]|0)!=1){g=0;i=e;return g|0}c[d>>2]=c[f+16>>2];g=1;i=e;return g|0}function El(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;if((c[d+8>>2]|0)!=(b|0)){i=g;return}b=d+16|0;h=c[b>>2]|0;if((h|0)==0){c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=g;return}if((h|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=g;return}e=d+24|0;if((c[e>>2]|0)!=2){i=g;return}c[e>>2]=f;i=g;return}function Fl(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;if((b|0)!=(c[d+8>>2]|0)){h=c[b+8>>2]|0;Ud[c[(c[h>>2]|0)+28>>2]&3](h,d,e,f);i=g;return}h=d+16|0;b=c[h>>2]|0;if((b|0)==0){c[h>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=g;return}if((b|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=g;return}e=d+24|0;if((c[e>>2]|0)!=2){i=g;return}c[e>>2]=f;i=g;return}function Gl(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;i=i+64|0;j=h;k=c[d>>2]|0;l=d+(c[k+ -8>>2]|0)|0;m=c[k+ -4>>2]|0;c[j>>2]=f;c[j+4>>2]=d;c[j+8>>2]=e;c[j+12>>2]=g;g=j+16|0;e=j+20|0;d=j+24|0;k=j+28|0;n=j+32|0;o=j+40|0;p=(m|0)==(f|0);f=g+0|0;q=f+36|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(q|0));b[g+36>>1]=0;a[g+38>>0]=0;if(p){c[j+48>>2]=1;Rd[c[(c[m>>2]|0)+20>>2]&3](m,j,l,l,1,0);r=(c[d>>2]|0)==1?l:0;i=h;return r|0}Id[c[(c[m>>2]|0)+24>>2]&3](m,j,l,1,0);l=c[j+36>>2]|0;if((l|0)==1){if((c[d>>2]|0)!=1){if((c[o>>2]|0)!=0){r=0;i=h;return r|0}if((c[k>>2]|0)!=1){r=0;i=h;return r|0}if((c[n>>2]|0)!=1){r=0;i=h;return r|0}}r=c[g>>2]|0;i=h;return r|0}else if((l|0)==0){if((c[o>>2]|0)!=1){r=0;i=h;return r|0}if((c[k>>2]|0)!=1){r=0;i=h;return r|0}r=(c[n>>2]|0)==1?c[e>>2]|0:0;i=h;return r|0}else{r=0;i=h;return r|0}return 0}function Hl(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=i;if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){i=h;return}j=d+28|0;if((c[j>>2]|0)==1){i=h;return}c[j>>2]=f;i=h;return}if((b|0)!=(c[d>>2]|0)){j=c[b+8>>2]|0;Id[c[(c[j>>2]|0)+24>>2]&3](j,d,e,f,g);i=h;return}if((c[d+16>>2]|0)!=(e|0)?(j=d+20|0,(c[j>>2]|0)!=(e|0)):0){c[d+32>>2]=f;k=d+44|0;if((c[k>>2]|0)==4){i=h;return}l=d+52|0;a[l>>0]=0;m=d+53|0;a[m>>0]=0;n=c[b+8>>2]|0;Rd[c[(c[n>>2]|0)+20>>2]&3](n,d,e,e,1,g);if((a[m>>0]|0)!=0){if((a[l>>0]|0)==0){o=1;p=13}}else{o=0;p=13}do{if((p|0)==13){c[j>>2]=e;l=d+40|0;c[l>>2]=(c[l>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(o){break}}else{p=16}if((p|0)==16?o:0){break}c[k>>2]=4;i=h;return}}while(0);c[k>>2]=3;i=h;return}if((f|0)!=1){i=h;return}c[d+32>>2]=1;i=h;return}function Il(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;g=i;if((c[d+8>>2]|0)==(b|0)){if((c[d+4>>2]|0)!=(e|0)){i=g;return}h=d+28|0;if((c[h>>2]|0)==1){i=g;return}c[h>>2]=f;i=g;return}if((c[d>>2]|0)!=(b|0)){i=g;return}if((c[d+16>>2]|0)!=(e|0)?(b=d+20|0,(c[b>>2]|0)!=(e|0)):0){c[d+32>>2]=f;c[b>>2]=e;e=d+40|0;c[e>>2]=(c[e>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1}c[d+44>>2]=4;i=g;return}if((f|0)!=1){i=g;return}c[d+32>>2]=1;i=g;return}function Jl(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0;j=i;if((b|0)!=(c[d+8>>2]|0)){k=c[b+8>>2]|0;Rd[c[(c[k>>2]|0)+20>>2]&3](k,d,e,f,g,h);i=j;return}a[d+53>>0]=1;if((c[d+4>>2]|0)!=(f|0)){i=j;return}a[d+52>>0]=1;f=d+16|0;h=c[f>>2]|0;if((h|0)==0){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=j;return}a[d+54>>0]=1;i=j;return}if((h|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;a[d+54>>0]=1;i=j;return}e=d+24|0;h=c[e>>2]|0;if((h|0)==2){c[e>>2]=g;l=g}else{l=h}if(!((l|0)==1?(c[d+48>>2]|0)==1:0)){i=j;return}a[d+54>>0]=1;i=j;return}function Kl(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0;h=i;if((c[d+8>>2]|0)!=(b|0)){i=h;return}a[d+53>>0]=1;if((c[d+4>>2]|0)!=(f|0)){i=h;return}a[d+52>>0]=1;f=d+16|0;b=c[f>>2]|0;if((b|0)==0){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=h;return}a[d+54>>0]=1;i=h;return}if((b|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;a[d+54>>0]=1;i=h;return}e=d+24|0;b=c[e>>2]|0;if((b|0)==2){c[e>>2]=g;j=g}else{j=b}if(!((j|0)==1?(c[d+48>>2]|0)==1:0)){i=h;return}a[d+54>>0]=1;i=h;return}function Ll(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0;b=i;do{if(a>>>0<245){if(a>>>0<11){d=16}else{d=a+11&-8}e=d>>>3;f=c[7468]|0;g=f>>>e;if((g&3|0)!=0){h=(g&1^1)+e|0;j=h<<1;k=29912+(j<<2)|0;l=29912+(j+2<<2)|0;j=c[l>>2]|0;m=j+8|0;n=c[m>>2]|0;do{if((k|0)!=(n|0)){if(n>>>0<(c[29888>>2]|0)>>>0){Gc()}o=n+12|0;if((c[o>>2]|0)==(j|0)){c[o>>2]=k;c[l>>2]=n;break}else{Gc()}}else{c[7468]=f&~(1<<h)}}while(0);n=h<<3;c[j+4>>2]=n|3;l=j+(n|4)|0;c[l>>2]=c[l>>2]|1;p=m;i=b;return p|0}if(d>>>0>(c[29880>>2]|0)>>>0){if((g|0)!=0){l=2<<e;n=g<<e&(l|0-l);l=(n&0-n)+ -1|0;n=l>>>12&16;k=l>>>n;l=k>>>5&8;o=k>>>l;k=o>>>2&4;q=o>>>k;o=q>>>1&2;r=q>>>o;q=r>>>1&1;s=(l|n|k|o|q)+(r>>>q)|0;q=s<<1;r=29912+(q<<2)|0;o=29912+(q+2<<2)|0;q=c[o>>2]|0;k=q+8|0;n=c[k>>2]|0;do{if((r|0)!=(n|0)){if(n>>>0<(c[29888>>2]|0)>>>0){Gc()}l=n+12|0;if((c[l>>2]|0)==(q|0)){c[l>>2]=r;c[o>>2]=n;break}else{Gc()}}else{c[7468]=f&~(1<<s)}}while(0);f=s<<3;n=f-d|0;c[q+4>>2]=d|3;o=q+d|0;c[q+(d|4)>>2]=n|1;c[q+f>>2]=n;f=c[29880>>2]|0;if((f|0)!=0){r=c[29892>>2]|0;e=f>>>3;f=e<<1;g=29912+(f<<2)|0;m=c[7468]|0;j=1<<e;if((m&j|0)!=0){e=29912+(f+2<<2)|0;h=c[e>>2]|0;if(h>>>0<(c[29888>>2]|0)>>>0){Gc()}else{t=e;u=h}}else{c[7468]=m|j;t=29912+(f+2<<2)|0;u=g}c[t>>2]=r;c[u+12>>2]=r;c[r+8>>2]=u;c[r+12>>2]=g}c[29880>>2]=n;c[29892>>2]=o;p=k;i=b;return p|0}o=c[29876>>2]|0;if((o|0)!=0){n=(o&0-o)+ -1|0;o=n>>>12&16;g=n>>>o;n=g>>>5&8;r=g>>>n;g=r>>>2&4;f=r>>>g;r=f>>>1&2;j=f>>>r;f=j>>>1&1;m=c[30176+((n|o|g|r|f)+(j>>>f)<<2)>>2]|0;f=(c[m+4>>2]&-8)-d|0;j=m;r=m;while(1){m=c[j+16>>2]|0;if((m|0)==0){g=c[j+20>>2]|0;if((g|0)==0){break}else{v=g}}else{v=m}m=(c[v+4>>2]&-8)-d|0;g=m>>>0<f>>>0;f=g?m:f;j=v;r=g?v:r}j=c[29888>>2]|0;if(r>>>0<j>>>0){Gc()}k=r+d|0;if(!(r>>>0<k>>>0)){Gc()}q=c[r+24>>2]|0;s=c[r+12>>2]|0;do{if((s|0)==(r|0)){g=r+20|0;m=c[g>>2]|0;if((m|0)==0){o=r+16|0;n=c[o>>2]|0;if((n|0)==0){w=0;break}else{x=n;y=o}}else{x=m;y=g}while(1){g=x+20|0;m=c[g>>2]|0;if((m|0)!=0){x=m;y=g;continue}g=x+16|0;m=c[g>>2]|0;if((m|0)==0){break}else{x=m;y=g}}if(y>>>0<j>>>0){Gc()}else{c[y>>2]=0;w=x;break}}else{g=c[r+8>>2]|0;if(g>>>0<j>>>0){Gc()}m=g+12|0;if((c[m>>2]|0)!=(r|0)){Gc()}o=s+8|0;if((c[o>>2]|0)==(r|0)){c[m>>2]=s;c[o>>2]=g;w=s;break}else{Gc()}}}while(0);do{if((q|0)!=0){s=c[r+28>>2]|0;j=30176+(s<<2)|0;if((r|0)==(c[j>>2]|0)){c[j>>2]=w;if((w|0)==0){c[29876>>2]=c[29876>>2]&~(1<<s);break}}else{if(q>>>0<(c[29888>>2]|0)>>>0){Gc()}s=q+16|0;if((c[s>>2]|0)==(r|0)){c[s>>2]=w}else{c[q+20>>2]=w}if((w|0)==0){break}}if(w>>>0<(c[29888>>2]|0)>>>0){Gc()}c[w+24>>2]=q;s=c[r+16>>2]|0;do{if((s|0)!=0){if(s>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[w+16>>2]=s;c[s+24>>2]=w;break}}}while(0);s=c[r+20>>2]|0;if((s|0)!=0){if(s>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[w+20>>2]=s;c[s+24>>2]=w;break}}}}while(0);if(f>>>0<16){q=f+d|0;c[r+4>>2]=q|3;s=r+(q+4)|0;c[s>>2]=c[s>>2]|1}else{c[r+4>>2]=d|3;c[r+(d|4)>>2]=f|1;c[r+(f+d)>>2]=f;s=c[29880>>2]|0;if((s|0)!=0){q=c[29892>>2]|0;j=s>>>3;s=j<<1;g=29912+(s<<2)|0;o=c[7468]|0;m=1<<j;if((o&m|0)!=0){j=29912+(s+2<<2)|0;n=c[j>>2]|0;if(n>>>0<(c[29888>>2]|0)>>>0){Gc()}else{z=j;A=n}}else{c[7468]=o|m;z=29912+(s+2<<2)|0;A=g}c[z>>2]=q;c[A+12>>2]=q;c[q+8>>2]=A;c[q+12>>2]=g}c[29880>>2]=f;c[29892>>2]=k}p=r+8|0;i=b;return p|0}else{B=d}}else{B=d}}else{if(!(a>>>0>4294967231)){g=a+11|0;q=g&-8;s=c[29876>>2]|0;if((s|0)!=0){m=0-q|0;o=g>>>8;if((o|0)!=0){if(q>>>0>16777215){C=31}else{g=(o+1048320|0)>>>16&8;n=o<<g;o=(n+520192|0)>>>16&4;j=n<<o;n=(j+245760|0)>>>16&2;h=14-(o|g|n)+(j<<n>>>15)|0;C=q>>>(h+7|0)&1|h<<1}}else{C=0}h=c[30176+(C<<2)>>2]|0;a:do{if((h|0)==0){D=m;E=0;F=0}else{if((C|0)==31){G=0}else{G=25-(C>>>1)|0}n=m;j=0;g=q<<G;o=h;e=0;while(1){l=c[o+4>>2]&-8;H=l-q|0;if(H>>>0<n>>>0){if((l|0)==(q|0)){D=H;E=o;F=o;break a}else{I=H;J=o}}else{I=n;J=e}H=c[o+20>>2]|0;o=c[o+(g>>>31<<2)+16>>2]|0;l=(H|0)==0|(H|0)==(o|0)?j:H;if((o|0)==0){D=I;E=l;F=J;break}else{n=I;j=l;g=g<<1;e=J}}}}while(0);if((E|0)==0&(F|0)==0){h=2<<C;m=s&(h|0-h);if((m|0)==0){B=q;break}h=(m&0-m)+ -1|0;m=h>>>12&16;r=h>>>m;h=r>>>5&8;k=r>>>h;r=k>>>2&4;f=k>>>r;k=f>>>1&2;e=f>>>k;f=e>>>1&1;K=c[30176+((h|m|r|k|f)+(e>>>f)<<2)>>2]|0}else{K=E}if((K|0)==0){L=D;M=F}else{f=D;e=K;k=F;while(1){r=(c[e+4>>2]&-8)-q|0;m=r>>>0<f>>>0;h=m?r:f;r=m?e:k;m=c[e+16>>2]|0;if((m|0)!=0){f=h;e=m;k=r;continue}e=c[e+20>>2]|0;if((e|0)==0){L=h;M=r;break}else{f=h;k=r}}}if((M|0)!=0?L>>>0<((c[29880>>2]|0)-q|0)>>>0:0){k=c[29888>>2]|0;if(M>>>0<k>>>0){Gc()}f=M+q|0;if(!(M>>>0<f>>>0)){Gc()}e=c[M+24>>2]|0;s=c[M+12>>2]|0;do{if((s|0)==(M|0)){r=M+20|0;h=c[r>>2]|0;if((h|0)==0){m=M+16|0;g=c[m>>2]|0;if((g|0)==0){N=0;break}else{O=g;P=m}}else{O=h;P=r}while(1){r=O+20|0;h=c[r>>2]|0;if((h|0)!=0){O=h;P=r;continue}r=O+16|0;h=c[r>>2]|0;if((h|0)==0){break}else{O=h;P=r}}if(P>>>0<k>>>0){Gc()}else{c[P>>2]=0;N=O;break}}else{r=c[M+8>>2]|0;if(r>>>0<k>>>0){Gc()}h=r+12|0;if((c[h>>2]|0)!=(M|0)){Gc()}m=s+8|0;if((c[m>>2]|0)==(M|0)){c[h>>2]=s;c[m>>2]=r;N=s;break}else{Gc()}}}while(0);do{if((e|0)!=0){s=c[M+28>>2]|0;k=30176+(s<<2)|0;if((M|0)==(c[k>>2]|0)){c[k>>2]=N;if((N|0)==0){c[29876>>2]=c[29876>>2]&~(1<<s);break}}else{if(e>>>0<(c[29888>>2]|0)>>>0){Gc()}s=e+16|0;if((c[s>>2]|0)==(M|0)){c[s>>2]=N}else{c[e+20>>2]=N}if((N|0)==0){break}}if(N>>>0<(c[29888>>2]|0)>>>0){Gc()}c[N+24>>2]=e;s=c[M+16>>2]|0;do{if((s|0)!=0){if(s>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[N+16>>2]=s;c[s+24>>2]=N;break}}}while(0);s=c[M+20>>2]|0;if((s|0)!=0){if(s>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[N+20>>2]=s;c[s+24>>2]=N;break}}}}while(0);b:do{if(!(L>>>0<16)){c[M+4>>2]=q|3;c[M+(q|4)>>2]=L|1;c[M+(L+q)>>2]=L;e=L>>>3;if(L>>>0<256){s=e<<1;k=29912+(s<<2)|0;r=c[7468]|0;m=1<<e;do{if((r&m|0)==0){c[7468]=r|m;Q=29912+(s+2<<2)|0;R=k}else{e=29912+(s+2<<2)|0;h=c[e>>2]|0;if(!(h>>>0<(c[29888>>2]|0)>>>0)){Q=e;R=h;break}Gc()}}while(0);c[Q>>2]=f;c[R+12>>2]=f;c[M+(q+8)>>2]=R;c[M+(q+12)>>2]=k;break}s=L>>>8;if((s|0)!=0){if(L>>>0>16777215){S=31}else{m=(s+1048320|0)>>>16&8;r=s<<m;s=(r+520192|0)>>>16&4;h=r<<s;r=(h+245760|0)>>>16&2;e=14-(s|m|r)+(h<<r>>>15)|0;S=L>>>(e+7|0)&1|e<<1}}else{S=0}e=30176+(S<<2)|0;c[M+(q+28)>>2]=S;c[M+(q+20)>>2]=0;c[M+(q+16)>>2]=0;r=c[29876>>2]|0;h=1<<S;if((r&h|0)==0){c[29876>>2]=r|h;c[e>>2]=f;c[M+(q+24)>>2]=e;c[M+(q+12)>>2]=f;c[M+(q+8)>>2]=f;break}h=c[e>>2]|0;if((S|0)==31){T=0}else{T=25-(S>>>1)|0}c:do{if((c[h+4>>2]&-8|0)!=(L|0)){e=L<<T;r=h;while(1){U=r+(e>>>31<<2)+16|0;m=c[U>>2]|0;if((m|0)==0){break}if((c[m+4>>2]&-8|0)==(L|0)){V=m;break c}else{e=e<<1;r=m}}if(U>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[U>>2]=f;c[M+(q+24)>>2]=r;c[M+(q+12)>>2]=f;c[M+(q+8)>>2]=f;break b}}else{V=h}}while(0);h=V+8|0;k=c[h>>2]|0;e=c[29888>>2]|0;if(V>>>0<e>>>0){Gc()}if(k>>>0<e>>>0){Gc()}else{c[k+12>>2]=f;c[h>>2]=f;c[M+(q+8)>>2]=k;c[M+(q+12)>>2]=V;c[M+(q+24)>>2]=0;break}}else{k=L+q|0;c[M+4>>2]=k|3;h=M+(k+4)|0;c[h>>2]=c[h>>2]|1}}while(0);p=M+8|0;i=b;return p|0}else{B=q}}else{B=q}}else{B=-1}}}while(0);M=c[29880>>2]|0;if(!(B>>>0>M>>>0)){L=M-B|0;V=c[29892>>2]|0;if(L>>>0>15){c[29892>>2]=V+B;c[29880>>2]=L;c[V+(B+4)>>2]=L|1;c[V+M>>2]=L;c[V+4>>2]=B|3}else{c[29880>>2]=0;c[29892>>2]=0;c[V+4>>2]=M|3;L=V+(M+4)|0;c[L>>2]=c[L>>2]|1}p=V+8|0;i=b;return p|0}V=c[29884>>2]|0;if(B>>>0<V>>>0){L=V-B|0;c[29884>>2]=L;V=c[29896>>2]|0;c[29896>>2]=V+B;c[V+(B+4)>>2]=L|1;c[V+4>>2]=B|3;p=V+8|0;i=b;return p|0}do{if((c[7586]|0)==0){V=Sa(30)|0;if((V+ -1&V|0)==0){c[30352>>2]=V;c[30348>>2]=V;c[30356>>2]=-1;c[30360>>2]=-1;c[30364>>2]=0;c[30316>>2]=0;c[7586]=(Sb(0)|0)&-16^1431655768;break}else{Gc()}}}while(0);V=B+48|0;L=c[30352>>2]|0;M=B+47|0;U=L+M|0;T=0-L|0;L=U&T;if(!(L>>>0>B>>>0)){p=0;i=b;return p|0}S=c[30312>>2]|0;if((S|0)!=0?(R=c[30304>>2]|0,Q=R+L|0,Q>>>0<=R>>>0|Q>>>0>S>>>0):0){p=0;i=b;return p|0}d:do{if((c[30316>>2]&4|0)==0){S=c[29896>>2]|0;e:do{if((S|0)!=0){Q=30320|0;while(1){R=c[Q>>2]|0;if(!(R>>>0>S>>>0)?(W=Q+4|0,(R+(c[W>>2]|0)|0)>>>0>S>>>0):0){break}R=c[Q+8>>2]|0;if((R|0)==0){X=182;break e}else{Q=R}}if((Q|0)!=0){R=U-(c[29884>>2]|0)&T;if(R>>>0<2147483647){N=Na(R|0)|0;O=(N|0)==((c[Q>>2]|0)+(c[W>>2]|0)|0);Y=N;Z=R;_=O?N:-1;$=O?R:0;X=191}else{aa=0}}else{X=182}}else{X=182}}while(0);do{if((X|0)==182){S=Na(0)|0;if((S|0)!=(-1|0)){q=S;R=c[30348>>2]|0;O=R+ -1|0;if((O&q|0)==0){ba=L}else{ba=L-q+(O+q&0-R)|0}R=c[30304>>2]|0;q=R+ba|0;if(ba>>>0>B>>>0&ba>>>0<2147483647){O=c[30312>>2]|0;if((O|0)!=0?q>>>0<=R>>>0|q>>>0>O>>>0:0){aa=0;break}O=Na(ba|0)|0;q=(O|0)==(S|0);Y=O;Z=ba;_=q?S:-1;$=q?ba:0;X=191}else{aa=0}}else{aa=0}}}while(0);f:do{if((X|0)==191){q=0-Z|0;if((_|0)!=(-1|0)){ca=_;da=$;X=202;break d}do{if((Y|0)!=(-1|0)&Z>>>0<2147483647&Z>>>0<V>>>0?(S=c[30352>>2]|0,O=M-Z+S&0-S,O>>>0<2147483647):0){if((Na(O|0)|0)==(-1|0)){Na(q|0)|0;aa=$;break f}else{ea=O+Z|0;break}}else{ea=Z}}while(0);if((Y|0)==(-1|0)){aa=$}else{ca=Y;da=ea;X=202;break d}}}while(0);c[30316>>2]=c[30316>>2]|4;fa=aa;X=199}else{fa=0;X=199}}while(0);if((((X|0)==199?L>>>0<2147483647:0)?(aa=Na(L|0)|0,L=Na(0)|0,(L|0)!=(-1|0)&(aa|0)!=(-1|0)&aa>>>0<L>>>0):0)?(ea=L-aa|0,L=ea>>>0>(B+40|0)>>>0,L):0){ca=aa;da=L?ea:fa;X=202}if((X|0)==202){fa=(c[30304>>2]|0)+da|0;c[30304>>2]=fa;if(fa>>>0>(c[30308>>2]|0)>>>0){c[30308>>2]=fa}fa=c[29896>>2]|0;g:do{if((fa|0)!=0){ea=30320|0;while(1){ga=c[ea>>2]|0;ha=ea+4|0;ia=c[ha>>2]|0;if((ca|0)==(ga+ia|0)){X=214;break}L=c[ea+8>>2]|0;if((L|0)==0){break}else{ea=L}}if(((X|0)==214?(c[ea+12>>2]&8|0)==0:0)?fa>>>0>=ga>>>0&fa>>>0<ca>>>0:0){c[ha>>2]=ia+da;L=(c[29884>>2]|0)+da|0;aa=fa+8|0;if((aa&7|0)==0){ja=0}else{ja=0-aa&7}aa=L-ja|0;c[29896>>2]=fa+ja;c[29884>>2]=aa;c[fa+(ja+4)>>2]=aa|1;c[fa+(L+4)>>2]=40;c[29900>>2]=c[30360>>2];break}if(ca>>>0<(c[29888>>2]|0)>>>0){c[29888>>2]=ca}L=ca+da|0;aa=30320|0;while(1){if((c[aa>>2]|0)==(L|0)){X=224;break}Y=c[aa+8>>2]|0;if((Y|0)==0){break}else{aa=Y}}if((X|0)==224?(c[aa+12>>2]&8|0)==0:0){c[aa>>2]=ca;L=aa+4|0;c[L>>2]=(c[L>>2]|0)+da;L=ca+8|0;if((L&7|0)==0){ka=0}else{ka=0-L&7}L=ca+(da+8)|0;if((L&7|0)==0){la=0}else{la=0-L&7}L=ca+(la+da)|0;ea=ka+B|0;Y=ca+ea|0;$=L-(ca+ka)-B|0;c[ca+(ka+4)>>2]=B|3;h:do{if((L|0)!=(c[29896>>2]|0)){if((L|0)==(c[29892>>2]|0)){Z=(c[29880>>2]|0)+$|0;c[29880>>2]=Z;c[29892>>2]=Y;c[ca+(ea+4)>>2]=Z|1;c[ca+(Z+ea)>>2]=Z;break}Z=da+4|0;M=c[ca+(Z+la)>>2]|0;if((M&3|0)==1){V=M&-8;_=M>>>3;i:do{if(!(M>>>0<256)){ba=c[ca+((la|24)+da)>>2]|0;W=c[ca+(da+12+la)>>2]|0;do{if((W|0)==(L|0)){T=la|16;U=ca+(Z+T)|0;q=c[U>>2]|0;if((q|0)==0){Q=ca+(T+da)|0;T=c[Q>>2]|0;if((T|0)==0){ma=0;break}else{na=T;oa=Q}}else{na=q;oa=U}while(1){U=na+20|0;q=c[U>>2]|0;if((q|0)!=0){na=q;oa=U;continue}U=na+16|0;q=c[U>>2]|0;if((q|0)==0){break}else{na=q;oa=U}}if(oa>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[oa>>2]=0;ma=na;break}}else{U=c[ca+((la|8)+da)>>2]|0;if(U>>>0<(c[29888>>2]|0)>>>0){Gc()}q=U+12|0;if((c[q>>2]|0)!=(L|0)){Gc()}Q=W+8|0;if((c[Q>>2]|0)==(L|0)){c[q>>2]=W;c[Q>>2]=U;ma=W;break}else{Gc()}}}while(0);if((ba|0)==0){break}W=c[ca+(da+28+la)>>2]|0;r=30176+(W<<2)|0;do{if((L|0)!=(c[r>>2]|0)){if(ba>>>0<(c[29888>>2]|0)>>>0){Gc()}U=ba+16|0;if((c[U>>2]|0)==(L|0)){c[U>>2]=ma}else{c[ba+20>>2]=ma}if((ma|0)==0){break i}}else{c[r>>2]=ma;if((ma|0)!=0){break}c[29876>>2]=c[29876>>2]&~(1<<W);break i}}while(0);if(ma>>>0<(c[29888>>2]|0)>>>0){Gc()}c[ma+24>>2]=ba;W=la|16;r=c[ca+(W+da)>>2]|0;do{if((r|0)!=0){if(r>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[ma+16>>2]=r;c[r+24>>2]=ma;break}}}while(0);r=c[ca+(Z+W)>>2]|0;if((r|0)==0){break}if(r>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[ma+20>>2]=r;c[r+24>>2]=ma;break}}else{r=c[ca+((la|8)+da)>>2]|0;ba=c[ca+(da+12+la)>>2]|0;U=29912+(_<<1<<2)|0;do{if((r|0)!=(U|0)){if(r>>>0<(c[29888>>2]|0)>>>0){Gc()}if((c[r+12>>2]|0)==(L|0)){break}Gc()}}while(0);if((ba|0)==(r|0)){c[7468]=c[7468]&~(1<<_);break}do{if((ba|0)==(U|0)){pa=ba+8|0}else{if(ba>>>0<(c[29888>>2]|0)>>>0){Gc()}W=ba+8|0;if((c[W>>2]|0)==(L|0)){pa=W;break}Gc()}}while(0);c[r+12>>2]=ba;c[pa>>2]=r}}while(0);qa=ca+((V|la)+da)|0;ra=V+$|0}else{qa=L;ra=$}_=qa+4|0;c[_>>2]=c[_>>2]&-2;c[ca+(ea+4)>>2]=ra|1;c[ca+(ra+ea)>>2]=ra;_=ra>>>3;if(ra>>>0<256){Z=_<<1;M=29912+(Z<<2)|0;U=c[7468]|0;W=1<<_;do{if((U&W|0)==0){c[7468]=U|W;sa=29912+(Z+2<<2)|0;ta=M}else{_=29912+(Z+2<<2)|0;Q=c[_>>2]|0;if(!(Q>>>0<(c[29888>>2]|0)>>>0)){sa=_;ta=Q;break}Gc()}}while(0);c[sa>>2]=Y;c[ta+12>>2]=Y;c[ca+(ea+8)>>2]=ta;c[ca+(ea+12)>>2]=M;break}Z=ra>>>8;do{if((Z|0)==0){ua=0}else{if(ra>>>0>16777215){ua=31;break}W=(Z+1048320|0)>>>16&8;U=Z<<W;V=(U+520192|0)>>>16&4;Q=U<<V;U=(Q+245760|0)>>>16&2;_=14-(V|W|U)+(Q<<U>>>15)|0;ua=ra>>>(_+7|0)&1|_<<1}}while(0);Z=30176+(ua<<2)|0;c[ca+(ea+28)>>2]=ua;c[ca+(ea+20)>>2]=0;c[ca+(ea+16)>>2]=0;M=c[29876>>2]|0;_=1<<ua;if((M&_|0)==0){c[29876>>2]=M|_;c[Z>>2]=Y;c[ca+(ea+24)>>2]=Z;c[ca+(ea+12)>>2]=Y;c[ca+(ea+8)>>2]=Y;break}_=c[Z>>2]|0;if((ua|0)==31){va=0}else{va=25-(ua>>>1)|0}j:do{if((c[_+4>>2]&-8|0)!=(ra|0)){Z=ra<<va;M=_;while(1){wa=M+(Z>>>31<<2)+16|0;U=c[wa>>2]|0;if((U|0)==0){break}if((c[U+4>>2]&-8|0)==(ra|0)){xa=U;break j}else{Z=Z<<1;M=U}}if(wa>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[wa>>2]=Y;c[ca+(ea+24)>>2]=M;c[ca+(ea+12)>>2]=Y;c[ca+(ea+8)>>2]=Y;break h}}else{xa=_}}while(0);_=xa+8|0;Z=c[_>>2]|0;r=c[29888>>2]|0;if(xa>>>0<r>>>0){Gc()}if(Z>>>0<r>>>0){Gc()}else{c[Z+12>>2]=Y;c[_>>2]=Y;c[ca+(ea+8)>>2]=Z;c[ca+(ea+12)>>2]=xa;c[ca+(ea+24)>>2]=0;break}}else{Z=(c[29884>>2]|0)+$|0;c[29884>>2]=Z;c[29896>>2]=Y;c[ca+(ea+4)>>2]=Z|1}}while(0);p=ca+(ka|8)|0;i=b;return p|0}ea=30320|0;while(1){ya=c[ea>>2]|0;if(!(ya>>>0>fa>>>0)?(za=c[ea+4>>2]|0,Aa=ya+za|0,Aa>>>0>fa>>>0):0){break}ea=c[ea+8>>2]|0}ea=ya+(za+ -39)|0;if((ea&7|0)==0){Ba=0}else{Ba=0-ea&7}ea=ya+(za+ -47+Ba)|0;Y=ea>>>0<(fa+16|0)>>>0?fa:ea;ea=Y+8|0;$=ca+8|0;if(($&7|0)==0){Ca=0}else{Ca=0-$&7}$=da+ -40-Ca|0;c[29896>>2]=ca+Ca;c[29884>>2]=$;c[ca+(Ca+4)>>2]=$|1;c[ca+(da+ -36)>>2]=40;c[29900>>2]=c[30360>>2];c[Y+4>>2]=27;c[ea+0>>2]=c[30320>>2];c[ea+4>>2]=c[30324>>2];c[ea+8>>2]=c[30328>>2];c[ea+12>>2]=c[30332>>2];c[30320>>2]=ca;c[30324>>2]=da;c[30332>>2]=0;c[30328>>2]=ea;ea=Y+28|0;c[ea>>2]=7;if((Y+32|0)>>>0<Aa>>>0){$=ea;do{ea=$;$=$+4|0;c[$>>2]=7}while((ea+8|0)>>>0<Aa>>>0)}if((Y|0)!=(fa|0)){$=Y-fa|0;ea=fa+($+4)|0;c[ea>>2]=c[ea>>2]&-2;c[fa+4>>2]=$|1;c[fa+$>>2]=$;ea=$>>>3;if($>>>0<256){L=ea<<1;aa=29912+(L<<2)|0;Z=c[7468]|0;_=1<<ea;do{if((Z&_|0)==0){c[7468]=Z|_;Da=29912+(L+2<<2)|0;Ea=aa}else{ea=29912+(L+2<<2)|0;r=c[ea>>2]|0;if(!(r>>>0<(c[29888>>2]|0)>>>0)){Da=ea;Ea=r;break}Gc()}}while(0);c[Da>>2]=fa;c[Ea+12>>2]=fa;c[fa+8>>2]=Ea;c[fa+12>>2]=aa;break}L=$>>>8;if((L|0)!=0){if($>>>0>16777215){Fa=31}else{_=(L+1048320|0)>>>16&8;Z=L<<_;L=(Z+520192|0)>>>16&4;Y=Z<<L;Z=(Y+245760|0)>>>16&2;r=14-(L|_|Z)+(Y<<Z>>>15)|0;Fa=$>>>(r+7|0)&1|r<<1}}else{Fa=0}r=30176+(Fa<<2)|0;c[fa+28>>2]=Fa;c[fa+20>>2]=0;c[fa+16>>2]=0;Z=c[29876>>2]|0;Y=1<<Fa;if((Z&Y|0)==0){c[29876>>2]=Z|Y;c[r>>2]=fa;c[fa+24>>2]=r;c[fa+12>>2]=fa;c[fa+8>>2]=fa;break}Y=c[r>>2]|0;if((Fa|0)==31){Ga=0}else{Ga=25-(Fa>>>1)|0}k:do{if((c[Y+4>>2]&-8|0)!=($|0)){r=$<<Ga;Z=Y;while(1){Ha=Z+(r>>>31<<2)+16|0;_=c[Ha>>2]|0;if((_|0)==0){break}if((c[_+4>>2]&-8|0)==($|0)){Ia=_;break k}else{r=r<<1;Z=_}}if(Ha>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[Ha>>2]=fa;c[fa+24>>2]=Z;c[fa+12>>2]=fa;c[fa+8>>2]=fa;break g}}else{Ia=Y}}while(0);Y=Ia+8|0;$=c[Y>>2]|0;aa=c[29888>>2]|0;if(Ia>>>0<aa>>>0){Gc()}if($>>>0<aa>>>0){Gc()}else{c[$+12>>2]=fa;c[Y>>2]=fa;c[fa+8>>2]=$;c[fa+12>>2]=Ia;c[fa+24>>2]=0;break}}}else{$=c[29888>>2]|0;if(($|0)==0|ca>>>0<$>>>0){c[29888>>2]=ca}c[30320>>2]=ca;c[30324>>2]=da;c[30332>>2]=0;c[29908>>2]=c[7586];c[29904>>2]=-1;$=0;do{Y=$<<1;aa=29912+(Y<<2)|0;c[29912+(Y+3<<2)>>2]=aa;c[29912+(Y+2<<2)>>2]=aa;$=$+1|0}while(($|0)!=32);$=ca+8|0;if(($&7|0)==0){Ja=0}else{Ja=0-$&7}$=da+ -40-Ja|0;c[29896>>2]=ca+Ja;c[29884>>2]=$;c[ca+(Ja+4)>>2]=$|1;c[ca+(da+ -36)>>2]=40;c[29900>>2]=c[30360>>2]}}while(0);da=c[29884>>2]|0;if(da>>>0>B>>>0){ca=da-B|0;c[29884>>2]=ca;da=c[29896>>2]|0;c[29896>>2]=da+B;c[da+(B+4)>>2]=ca|1;c[da+4>>2]=B|3;p=da+8|0;i=b;return p|0}}c[(qd()|0)>>2]=12;p=0;i=b;return p|0}function Ml(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;b=i;if((a|0)==0){i=b;return}d=a+ -8|0;e=c[29888>>2]|0;if(d>>>0<e>>>0){Gc()}f=c[a+ -4>>2]|0;g=f&3;if((g|0)==1){Gc()}h=f&-8;j=a+(h+ -8)|0;do{if((f&1|0)==0){k=c[d>>2]|0;if((g|0)==0){i=b;return}l=-8-k|0;m=a+l|0;n=k+h|0;if(m>>>0<e>>>0){Gc()}if((m|0)==(c[29892>>2]|0)){o=a+(h+ -4)|0;if((c[o>>2]&3|0)!=3){p=m;q=n;break}c[29880>>2]=n;c[o>>2]=c[o>>2]&-2;c[a+(l+4)>>2]=n|1;c[j>>2]=n;i=b;return}o=k>>>3;if(k>>>0<256){k=c[a+(l+8)>>2]|0;r=c[a+(l+12)>>2]|0;s=29912+(o<<1<<2)|0;if((k|0)!=(s|0)){if(k>>>0<e>>>0){Gc()}if((c[k+12>>2]|0)!=(m|0)){Gc()}}if((r|0)==(k|0)){c[7468]=c[7468]&~(1<<o);p=m;q=n;break}if((r|0)!=(s|0)){if(r>>>0<e>>>0){Gc()}s=r+8|0;if((c[s>>2]|0)==(m|0)){t=s}else{Gc()}}else{t=r+8|0}c[k+12>>2]=r;c[t>>2]=k;p=m;q=n;break}k=c[a+(l+24)>>2]|0;r=c[a+(l+12)>>2]|0;do{if((r|0)==(m|0)){s=a+(l+20)|0;o=c[s>>2]|0;if((o|0)==0){u=a+(l+16)|0;v=c[u>>2]|0;if((v|0)==0){w=0;break}else{x=v;y=u}}else{x=o;y=s}while(1){s=x+20|0;o=c[s>>2]|0;if((o|0)!=0){x=o;y=s;continue}s=x+16|0;o=c[s>>2]|0;if((o|0)==0){break}else{x=o;y=s}}if(y>>>0<e>>>0){Gc()}else{c[y>>2]=0;w=x;break}}else{s=c[a+(l+8)>>2]|0;if(s>>>0<e>>>0){Gc()}o=s+12|0;if((c[o>>2]|0)!=(m|0)){Gc()}u=r+8|0;if((c[u>>2]|0)==(m|0)){c[o>>2]=r;c[u>>2]=s;w=r;break}else{Gc()}}}while(0);if((k|0)!=0){r=c[a+(l+28)>>2]|0;s=30176+(r<<2)|0;if((m|0)==(c[s>>2]|0)){c[s>>2]=w;if((w|0)==0){c[29876>>2]=c[29876>>2]&~(1<<r);p=m;q=n;break}}else{if(k>>>0<(c[29888>>2]|0)>>>0){Gc()}r=k+16|0;if((c[r>>2]|0)==(m|0)){c[r>>2]=w}else{c[k+20>>2]=w}if((w|0)==0){p=m;q=n;break}}if(w>>>0<(c[29888>>2]|0)>>>0){Gc()}c[w+24>>2]=k;r=c[a+(l+16)>>2]|0;do{if((r|0)!=0){if(r>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[w+16>>2]=r;c[r+24>>2]=w;break}}}while(0);r=c[a+(l+20)>>2]|0;if((r|0)!=0){if(r>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[w+20>>2]=r;c[r+24>>2]=w;p=m;q=n;break}}else{p=m;q=n}}else{p=m;q=n}}else{p=d;q=h}}while(0);if(!(p>>>0<j>>>0)){Gc()}d=a+(h+ -4)|0;w=c[d>>2]|0;if((w&1|0)==0){Gc()}if((w&2|0)==0){if((j|0)==(c[29896>>2]|0)){e=(c[29884>>2]|0)+q|0;c[29884>>2]=e;c[29896>>2]=p;c[p+4>>2]=e|1;if((p|0)!=(c[29892>>2]|0)){i=b;return}c[29892>>2]=0;c[29880>>2]=0;i=b;return}if((j|0)==(c[29892>>2]|0)){e=(c[29880>>2]|0)+q|0;c[29880>>2]=e;c[29892>>2]=p;c[p+4>>2]=e|1;c[p+e>>2]=e;i=b;return}e=(w&-8)+q|0;x=w>>>3;do{if(!(w>>>0<256)){y=c[a+(h+16)>>2]|0;t=c[a+(h|4)>>2]|0;do{if((t|0)==(j|0)){g=a+(h+12)|0;f=c[g>>2]|0;if((f|0)==0){r=a+(h+8)|0;k=c[r>>2]|0;if((k|0)==0){z=0;break}else{A=k;B=r}}else{A=f;B=g}while(1){g=A+20|0;f=c[g>>2]|0;if((f|0)!=0){A=f;B=g;continue}g=A+16|0;f=c[g>>2]|0;if((f|0)==0){break}else{A=f;B=g}}if(B>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[B>>2]=0;z=A;break}}else{g=c[a+h>>2]|0;if(g>>>0<(c[29888>>2]|0)>>>0){Gc()}f=g+12|0;if((c[f>>2]|0)!=(j|0)){Gc()}r=t+8|0;if((c[r>>2]|0)==(j|0)){c[f>>2]=t;c[r>>2]=g;z=t;break}else{Gc()}}}while(0);if((y|0)!=0){t=c[a+(h+20)>>2]|0;n=30176+(t<<2)|0;if((j|0)==(c[n>>2]|0)){c[n>>2]=z;if((z|0)==0){c[29876>>2]=c[29876>>2]&~(1<<t);break}}else{if(y>>>0<(c[29888>>2]|0)>>>0){Gc()}t=y+16|0;if((c[t>>2]|0)==(j|0)){c[t>>2]=z}else{c[y+20>>2]=z}if((z|0)==0){break}}if(z>>>0<(c[29888>>2]|0)>>>0){Gc()}c[z+24>>2]=y;t=c[a+(h+8)>>2]|0;do{if((t|0)!=0){if(t>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[z+16>>2]=t;c[t+24>>2]=z;break}}}while(0);t=c[a+(h+12)>>2]|0;if((t|0)!=0){if(t>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[z+20>>2]=t;c[t+24>>2]=z;break}}}}else{t=c[a+h>>2]|0;y=c[a+(h|4)>>2]|0;n=29912+(x<<1<<2)|0;if((t|0)!=(n|0)){if(t>>>0<(c[29888>>2]|0)>>>0){Gc()}if((c[t+12>>2]|0)!=(j|0)){Gc()}}if((y|0)==(t|0)){c[7468]=c[7468]&~(1<<x);break}if((y|0)!=(n|0)){if(y>>>0<(c[29888>>2]|0)>>>0){Gc()}n=y+8|0;if((c[n>>2]|0)==(j|0)){C=n}else{Gc()}}else{C=y+8|0}c[t+12>>2]=y;c[C>>2]=t}}while(0);c[p+4>>2]=e|1;c[p+e>>2]=e;if((p|0)==(c[29892>>2]|0)){c[29880>>2]=e;i=b;return}else{D=e}}else{c[d>>2]=w&-2;c[p+4>>2]=q|1;c[p+q>>2]=q;D=q}q=D>>>3;if(D>>>0<256){w=q<<1;d=29912+(w<<2)|0;e=c[7468]|0;C=1<<q;if((e&C|0)!=0){q=29912+(w+2<<2)|0;j=c[q>>2]|0;if(j>>>0<(c[29888>>2]|0)>>>0){Gc()}else{E=q;F=j}}else{c[7468]=e|C;E=29912+(w+2<<2)|0;F=d}c[E>>2]=p;c[F+12>>2]=p;c[p+8>>2]=F;c[p+12>>2]=d;i=b;return}d=D>>>8;if((d|0)!=0){if(D>>>0>16777215){G=31}else{F=(d+1048320|0)>>>16&8;E=d<<F;d=(E+520192|0)>>>16&4;w=E<<d;E=(w+245760|0)>>>16&2;C=14-(d|F|E)+(w<<E>>>15)|0;G=D>>>(C+7|0)&1|C<<1}}else{G=0}C=30176+(G<<2)|0;c[p+28>>2]=G;c[p+20>>2]=0;c[p+16>>2]=0;E=c[29876>>2]|0;w=1<<G;a:do{if((E&w|0)!=0){F=c[C>>2]|0;if((G|0)==31){H=0}else{H=25-(G>>>1)|0}b:do{if((c[F+4>>2]&-8|0)!=(D|0)){d=D<<H;e=F;while(1){I=e+(d>>>31<<2)+16|0;j=c[I>>2]|0;if((j|0)==0){break}if((c[j+4>>2]&-8|0)==(D|0)){J=j;break b}else{d=d<<1;e=j}}if(I>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[I>>2]=p;c[p+24>>2]=e;c[p+12>>2]=p;c[p+8>>2]=p;break a}}else{J=F}}while(0);F=J+8|0;d=c[F>>2]|0;j=c[29888>>2]|0;if(J>>>0<j>>>0){Gc()}if(d>>>0<j>>>0){Gc()}else{c[d+12>>2]=p;c[F>>2]=p;c[p+8>>2]=d;c[p+12>>2]=J;c[p+24>>2]=0;break}}else{c[29876>>2]=E|w;c[C>>2]=p;c[p+24>>2]=C;c[p+12>>2]=p;c[p+8>>2]=p}}while(0);p=(c[29904>>2]|0)+ -1|0;c[29904>>2]=p;if((p|0)==0){K=30328|0}else{i=b;return}while(1){p=c[K>>2]|0;if((p|0)==0){break}else{K=p+8|0}}c[29904>>2]=-1;i=b;return}function Nl(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;if((a|0)!=0){e=da(b,a)|0;if((b|a)>>>0>65535){f=((e>>>0)/(a>>>0)|0|0)==(b|0)?e:-1}else{f=e}}else{f=0}e=Ll(f)|0;if((e|0)==0){i=d;return e|0}if((c[e+ -4>>2]&3|0)==0){i=d;return e|0}Om(e|0,0,f|0)|0;i=d;return e|0}function Ol(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;do{if((a|0)!=0){if(b>>>0>4294967231){c[(qd()|0)>>2]=12;e=0;break}if(b>>>0<11){f=16}else{f=b+11&-8}g=Pl(a+ -8|0,f)|0;if((g|0)!=0){e=g+8|0;break}g=Ll(b)|0;if((g|0)==0){e=0}else{h=c[a+ -4>>2]|0;j=(h&-8)-((h&3|0)==0?8:4)|0;Mm(g|0,a|0,(j>>>0<b>>>0?j:b)|0)|0;Ml(a);e=g}}else{e=Ll(b)|0}}while(0);i=d;return e|0}function Pl(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=i;e=a+4|0;f=c[e>>2]|0;g=f&-8;h=a+g|0;j=c[29888>>2]|0;if(a>>>0<j>>>0){Gc()}k=f&3;if(!((k|0)!=1&a>>>0<h>>>0)){Gc()}l=a+(g|4)|0;m=c[l>>2]|0;if((m&1|0)==0){Gc()}if((k|0)==0){if(b>>>0<256){n=0;i=d;return n|0}if(!(g>>>0<(b+4|0)>>>0)?!((g-b|0)>>>0>c[30352>>2]<<1>>>0):0){n=a;i=d;return n|0}n=0;i=d;return n|0}if(!(g>>>0<b>>>0)){k=g-b|0;if(!(k>>>0>15)){n=a;i=d;return n|0}c[e>>2]=f&1|b|2;c[a+(b+4)>>2]=k|3;c[l>>2]=c[l>>2]|1;Ql(a+b|0,k);n=a;i=d;return n|0}if((h|0)==(c[29896>>2]|0)){k=(c[29884>>2]|0)+g|0;if(!(k>>>0>b>>>0)){n=0;i=d;return n|0}l=k-b|0;c[e>>2]=f&1|b|2;c[a+(b+4)>>2]=l|1;c[29896>>2]=a+b;c[29884>>2]=l;n=a;i=d;return n|0}if((h|0)==(c[29892>>2]|0)){l=(c[29880>>2]|0)+g|0;if(l>>>0<b>>>0){n=0;i=d;return n|0}k=l-b|0;if(k>>>0>15){c[e>>2]=f&1|b|2;c[a+(b+4)>>2]=k|1;c[a+l>>2]=k;o=a+(l+4)|0;c[o>>2]=c[o>>2]&-2;p=a+b|0;q=k}else{c[e>>2]=f&1|l|2;f=a+(l+4)|0;c[f>>2]=c[f>>2]|1;p=0;q=0}c[29880>>2]=q;c[29892>>2]=p;n=a;i=d;return n|0}if((m&2|0)!=0){n=0;i=d;return n|0}p=(m&-8)+g|0;if(p>>>0<b>>>0){n=0;i=d;return n|0}q=p-b|0;f=m>>>3;do{if(!(m>>>0<256)){l=c[a+(g+24)>>2]|0;k=c[a+(g+12)>>2]|0;do{if((k|0)==(h|0)){o=a+(g+20)|0;r=c[o>>2]|0;if((r|0)==0){s=a+(g+16)|0;t=c[s>>2]|0;if((t|0)==0){u=0;break}else{v=t;w=s}}else{v=r;w=o}while(1){o=v+20|0;r=c[o>>2]|0;if((r|0)!=0){v=r;w=o;continue}o=v+16|0;r=c[o>>2]|0;if((r|0)==0){break}else{v=r;w=o}}if(w>>>0<j>>>0){Gc()}else{c[w>>2]=0;u=v;break}}else{o=c[a+(g+8)>>2]|0;if(o>>>0<j>>>0){Gc()}r=o+12|0;if((c[r>>2]|0)!=(h|0)){Gc()}s=k+8|0;if((c[s>>2]|0)==(h|0)){c[r>>2]=k;c[s>>2]=o;u=k;break}else{Gc()}}}while(0);if((l|0)!=0){k=c[a+(g+28)>>2]|0;o=30176+(k<<2)|0;if((h|0)==(c[o>>2]|0)){c[o>>2]=u;if((u|0)==0){c[29876>>2]=c[29876>>2]&~(1<<k);break}}else{if(l>>>0<(c[29888>>2]|0)>>>0){Gc()}k=l+16|0;if((c[k>>2]|0)==(h|0)){c[k>>2]=u}else{c[l+20>>2]=u}if((u|0)==0){break}}if(u>>>0<(c[29888>>2]|0)>>>0){Gc()}c[u+24>>2]=l;k=c[a+(g+16)>>2]|0;do{if((k|0)!=0){if(k>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[u+16>>2]=k;c[k+24>>2]=u;break}}}while(0);k=c[a+(g+20)>>2]|0;if((k|0)!=0){if(k>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[u+20>>2]=k;c[k+24>>2]=u;break}}}}else{k=c[a+(g+8)>>2]|0;l=c[a+(g+12)>>2]|0;o=29912+(f<<1<<2)|0;if((k|0)!=(o|0)){if(k>>>0<j>>>0){Gc()}if((c[k+12>>2]|0)!=(h|0)){Gc()}}if((l|0)==(k|0)){c[7468]=c[7468]&~(1<<f);break}if((l|0)!=(o|0)){if(l>>>0<j>>>0){Gc()}o=l+8|0;if((c[o>>2]|0)==(h|0)){x=o}else{Gc()}}else{x=l+8|0}c[k+12>>2]=l;c[x>>2]=k}}while(0);if(q>>>0<16){c[e>>2]=p|c[e>>2]&1|2;x=a+(p|4)|0;c[x>>2]=c[x>>2]|1;n=a;i=d;return n|0}else{c[e>>2]=c[e>>2]&1|b|2;c[a+(b+4)>>2]=q|3;e=a+(p|4)|0;c[e>>2]=c[e>>2]|1;Ql(a+b|0,q);n=a;i=d;return n|0}return 0}function Ql(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;d=i;e=a+b|0;f=c[a+4>>2]|0;do{if((f&1|0)==0){g=c[a>>2]|0;if((f&3|0)==0){i=d;return}h=a+(0-g)|0;j=g+b|0;k=c[29888>>2]|0;if(h>>>0<k>>>0){Gc()}if((h|0)==(c[29892>>2]|0)){l=a+(b+4)|0;if((c[l>>2]&3|0)!=3){m=h;n=j;break}c[29880>>2]=j;c[l>>2]=c[l>>2]&-2;c[a+(4-g)>>2]=j|1;c[e>>2]=j;i=d;return}l=g>>>3;if(g>>>0<256){o=c[a+(8-g)>>2]|0;p=c[a+(12-g)>>2]|0;q=29912+(l<<1<<2)|0;if((o|0)!=(q|0)){if(o>>>0<k>>>0){Gc()}if((c[o+12>>2]|0)!=(h|0)){Gc()}}if((p|0)==(o|0)){c[7468]=c[7468]&~(1<<l);m=h;n=j;break}if((p|0)!=(q|0)){if(p>>>0<k>>>0){Gc()}q=p+8|0;if((c[q>>2]|0)==(h|0)){r=q}else{Gc()}}else{r=p+8|0}c[o+12>>2]=p;c[r>>2]=o;m=h;n=j;break}o=c[a+(24-g)>>2]|0;p=c[a+(12-g)>>2]|0;do{if((p|0)==(h|0)){q=16-g|0;l=a+(q+4)|0;s=c[l>>2]|0;if((s|0)==0){t=a+q|0;q=c[t>>2]|0;if((q|0)==0){u=0;break}else{v=q;w=t}}else{v=s;w=l}while(1){l=v+20|0;s=c[l>>2]|0;if((s|0)!=0){v=s;w=l;continue}l=v+16|0;s=c[l>>2]|0;if((s|0)==0){break}else{v=s;w=l}}if(w>>>0<k>>>0){Gc()}else{c[w>>2]=0;u=v;break}}else{l=c[a+(8-g)>>2]|0;if(l>>>0<k>>>0){Gc()}s=l+12|0;if((c[s>>2]|0)!=(h|0)){Gc()}t=p+8|0;if((c[t>>2]|0)==(h|0)){c[s>>2]=p;c[t>>2]=l;u=p;break}else{Gc()}}}while(0);if((o|0)!=0){p=c[a+(28-g)>>2]|0;k=30176+(p<<2)|0;if((h|0)==(c[k>>2]|0)){c[k>>2]=u;if((u|0)==0){c[29876>>2]=c[29876>>2]&~(1<<p);m=h;n=j;break}}else{if(o>>>0<(c[29888>>2]|0)>>>0){Gc()}p=o+16|0;if((c[p>>2]|0)==(h|0)){c[p>>2]=u}else{c[o+20>>2]=u}if((u|0)==0){m=h;n=j;break}}if(u>>>0<(c[29888>>2]|0)>>>0){Gc()}c[u+24>>2]=o;p=16-g|0;k=c[a+p>>2]|0;do{if((k|0)!=0){if(k>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[u+16>>2]=k;c[k+24>>2]=u;break}}}while(0);k=c[a+(p+4)>>2]|0;if((k|0)!=0){if(k>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[u+20>>2]=k;c[k+24>>2]=u;m=h;n=j;break}}else{m=h;n=j}}else{m=h;n=j}}else{m=a;n=b}}while(0);u=c[29888>>2]|0;if(e>>>0<u>>>0){Gc()}v=a+(b+4)|0;w=c[v>>2]|0;if((w&2|0)==0){if((e|0)==(c[29896>>2]|0)){r=(c[29884>>2]|0)+n|0;c[29884>>2]=r;c[29896>>2]=m;c[m+4>>2]=r|1;if((m|0)!=(c[29892>>2]|0)){i=d;return}c[29892>>2]=0;c[29880>>2]=0;i=d;return}if((e|0)==(c[29892>>2]|0)){r=(c[29880>>2]|0)+n|0;c[29880>>2]=r;c[29892>>2]=m;c[m+4>>2]=r|1;c[m+r>>2]=r;i=d;return}r=(w&-8)+n|0;f=w>>>3;do{if(!(w>>>0<256)){k=c[a+(b+24)>>2]|0;g=c[a+(b+12)>>2]|0;do{if((g|0)==(e|0)){o=a+(b+20)|0;l=c[o>>2]|0;if((l|0)==0){t=a+(b+16)|0;s=c[t>>2]|0;if((s|0)==0){x=0;break}else{y=s;z=t}}else{y=l;z=o}while(1){o=y+20|0;l=c[o>>2]|0;if((l|0)!=0){y=l;z=o;continue}o=y+16|0;l=c[o>>2]|0;if((l|0)==0){break}else{y=l;z=o}}if(z>>>0<u>>>0){Gc()}else{c[z>>2]=0;x=y;break}}else{o=c[a+(b+8)>>2]|0;if(o>>>0<u>>>0){Gc()}l=o+12|0;if((c[l>>2]|0)!=(e|0)){Gc()}t=g+8|0;if((c[t>>2]|0)==(e|0)){c[l>>2]=g;c[t>>2]=o;x=g;break}else{Gc()}}}while(0);if((k|0)!=0){g=c[a+(b+28)>>2]|0;j=30176+(g<<2)|0;if((e|0)==(c[j>>2]|0)){c[j>>2]=x;if((x|0)==0){c[29876>>2]=c[29876>>2]&~(1<<g);break}}else{if(k>>>0<(c[29888>>2]|0)>>>0){Gc()}g=k+16|0;if((c[g>>2]|0)==(e|0)){c[g>>2]=x}else{c[k+20>>2]=x}if((x|0)==0){break}}if(x>>>0<(c[29888>>2]|0)>>>0){Gc()}c[x+24>>2]=k;g=c[a+(b+16)>>2]|0;do{if((g|0)!=0){if(g>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[x+16>>2]=g;c[g+24>>2]=x;break}}}while(0);g=c[a+(b+20)>>2]|0;if((g|0)!=0){if(g>>>0<(c[29888>>2]|0)>>>0){Gc()}else{c[x+20>>2]=g;c[g+24>>2]=x;break}}}}else{g=c[a+(b+8)>>2]|0;k=c[a+(b+12)>>2]|0;j=29912+(f<<1<<2)|0;if((g|0)!=(j|0)){if(g>>>0<u>>>0){Gc()}if((c[g+12>>2]|0)!=(e|0)){Gc()}}if((k|0)==(g|0)){c[7468]=c[7468]&~(1<<f);break}if((k|0)!=(j|0)){if(k>>>0<u>>>0){Gc()}j=k+8|0;if((c[j>>2]|0)==(e|0)){A=j}else{Gc()}}else{A=k+8|0}c[g+12>>2]=k;c[A>>2]=g}}while(0);c[m+4>>2]=r|1;c[m+r>>2]=r;if((m|0)==(c[29892>>2]|0)){c[29880>>2]=r;i=d;return}else{B=r}}else{c[v>>2]=w&-2;c[m+4>>2]=n|1;c[m+n>>2]=n;B=n}n=B>>>3;if(B>>>0<256){w=n<<1;v=29912+(w<<2)|0;r=c[7468]|0;A=1<<n;if((r&A|0)!=0){n=29912+(w+2<<2)|0;e=c[n>>2]|0;if(e>>>0<(c[29888>>2]|0)>>>0){Gc()}else{C=n;D=e}}else{c[7468]=r|A;C=29912+(w+2<<2)|0;D=v}c[C>>2]=m;c[D+12>>2]=m;c[m+8>>2]=D;c[m+12>>2]=v;i=d;return}v=B>>>8;if((v|0)!=0){if(B>>>0>16777215){E=31}else{D=(v+1048320|0)>>>16&8;C=v<<D;v=(C+520192|0)>>>16&4;w=C<<v;C=(w+245760|0)>>>16&2;A=14-(v|D|C)+(w<<C>>>15)|0;E=B>>>(A+7|0)&1|A<<1}}else{E=0}A=30176+(E<<2)|0;c[m+28>>2]=E;c[m+20>>2]=0;c[m+16>>2]=0;C=c[29876>>2]|0;w=1<<E;if((C&w|0)==0){c[29876>>2]=C|w;c[A>>2]=m;c[m+24>>2]=A;c[m+12>>2]=m;c[m+8>>2]=m;i=d;return}w=c[A>>2]|0;if((E|0)==31){F=0}else{F=25-(E>>>1)|0}a:do{if((c[w+4>>2]&-8|0)==(B|0)){G=w}else{E=B<<F;A=w;while(1){H=A+(E>>>31<<2)+16|0;C=c[H>>2]|0;if((C|0)==0){break}if((c[C+4>>2]&-8|0)==(B|0)){G=C;break a}else{E=E<<1;A=C}}if(H>>>0<(c[29888>>2]|0)>>>0){Gc()}c[H>>2]=m;c[m+24>>2]=A;c[m+12>>2]=m;c[m+8>>2]=m;i=d;return}}while(0);H=G+8|0;B=c[H>>2]|0;w=c[29888>>2]|0;if(G>>>0<w>>>0){Gc()}if(B>>>0<w>>>0){Gc()}c[B+12>>2]=m;c[H>>2]=m;c[m+8>>2]=B;c[m+12>>2]=G;c[m+24>>2]=0;i=d;return}function Rl(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;d=(a|0)==0?1:a;while(1){e=Ll(d)|0;if((e|0)!=0){f=10;break}a=c[7592]|0;c[7592]=a+0;if((a|0)==0){f=9;break}s=0;ta(a|0);a=s;s=0;if(a&1){f=5;break}}do{if((f|0)==5){d=ub(-1,-1,30432)|0;g=d;h=H}else if((f|0)==9){d=dc(4)|0;c[d>>2]=30384;s=0;sa(2,d|0,30432,7);d=s;s=0;if(d&1){d=ub(-1,-1,30432)|0;g=d;h=H;break}}else if((f|0)==10){i=b;return e|0}}while(0);if((h|0)<0){Eb(g|0)}else{Cb(g|0)}return 0}function Sl(a){a=a|0;var b=0,c=0;b=i;s=0;c=ra(37,a|0)|0;a=s;s=0;if(!(a&1)){i=b;return c|0}c=ub(-1,-1,30432)|0;if((H|0)<0){Eb(c|0)}else{Cb(c|0)}return 0}function Tl(a){a=a|0;var b=0;b=i;if((a|0)!=0){Ml(a)}i=b;return}function Ul(a){a=a|0;var b=0;b=i;Tl(a);i=b;return}function Vl(a){a=a|0;var b=0;b=i;bb(a|0);Tl(a);i=b;return}function Wl(a){a=a|0;var b=0;b=i;bb(a|0);i=b;return}function Xl(a){a=a|0;return 30400}function Yl(a){a=a|0;return(a+ -48|0)>>>0<10|0}function Zl(a){a=a|0;var b=0;if((a|0)==32){b=1}else{b=(a+ -9|0)>>>0<5}return b&1|0}function _l(a){a=a|0;return(a+ -65|0)>>>0<26|0}function $l(a){a=a|0;var b=0,c=0;b=i;c=(_l(a)|0)==0;i=b;return(c?a:a|32)|0}function am(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,ea=0,fa=0,ga=0,ha=0;j=i;if(e>>>0>36){c[(qd()|0)>>2]=22;k=0;l=0;H=k;i=j;return l|0}m=b+4|0;n=b+100|0;do{o=c[m>>2]|0;if(o>>>0<(c[n>>2]|0)>>>0){c[m>>2]=o+1;p=d[o>>0]|0}else{p=em(b)|0}}while((Zl(p)|0)!=0);do{if((p|0)==43|(p|0)==45){o=((p|0)==45)<<31>>31;q=c[m>>2]|0;if(q>>>0<(c[n>>2]|0)>>>0){c[m>>2]=q+1;r=d[q>>0]|0;s=o;break}else{r=em(b)|0;s=o;break}}else{r=p;s=0}}while(0);p=(e|0)==0;do{if((e&-17|0)==0&(r|0)==48){o=c[m>>2]|0;if(o>>>0<(c[n>>2]|0)>>>0){c[m>>2]=o+1;t=d[o>>0]|0}else{t=em(b)|0}if((t|32|0)!=120){u=p?8:e;v=t;w=32;break}o=c[m>>2]|0;if(o>>>0<(c[n>>2]|0)>>>0){c[m>>2]=o+1;x=d[o>>0]|0}else{x=em(b)|0}if((d[x+30449>>0]|0)>15){o=(c[n>>2]|0)==0;if(!o){c[m>>2]=(c[m>>2]|0)+ -1}if((f|0)==0){dm(b,0);k=0;l=0;H=k;i=j;return l|0}if(o){k=0;l=0;H=k;i=j;return l|0}c[m>>2]=(c[m>>2]|0)+ -1;k=0;l=0;H=k;i=j;return l|0}else{y=16;z=x;w=47}}else{o=p?10:e;if((d[r+30449>>0]|0)>>>0<o>>>0){u=o;v=r;w=32}else{if((c[n>>2]|0)!=0){c[m>>2]=(c[m>>2]|0)+ -1}dm(b,0);c[(qd()|0)>>2]=22;k=0;l=0;H=k;i=j;return l|0}}}while(0);if((w|0)==32){if((u|0)==10){r=v+ -48|0;if(r>>>0<10){e=r;r=0;while(1){A=r+e|0;p=c[m>>2]|0;if(p>>>0<(c[n>>2]|0)>>>0){c[m>>2]=p+1;B=d[p>>0]|0}else{B=em(b)|0}p=B+ -48|0;if(!(p>>>0<10&A>>>0<429496729)){break}e=p;r=A*10|0}C=A;D=0;E=B}else{C=0;D=0;E=v}B=E+ -48|0;if(B>>>0<10){A=C;r=D;e=B;B=E;while(1){E=Ym(A|0,r|0,10,0)|0;p=H;x=((e|0)<0)<<31>>31;f=~x;if(p>>>0>f>>>0|(p|0)==(f|0)&E>>>0>~e>>>0){F=e;G=A;I=r;J=B;break}f=Im(E|0,p|0,e|0,x|0)|0;x=H;p=c[m>>2]|0;if(p>>>0<(c[n>>2]|0)>>>0){c[m>>2]=p+1;K=d[p>>0]|0}else{K=em(b)|0}p=K+ -48|0;if(p>>>0<10&(x>>>0<429496729|(x|0)==429496729&f>>>0<2576980378)){A=f;r=x;e=p;B=K}else{F=p;G=f;I=x;J=K;break}}if(F>>>0>9){L=I;M=G}else{N=10;O=G;P=I;Q=J;w=73}}else{L=D;M=C}}else{y=u;z=v;w=47}}a:do{if((w|0)==47){if((y+ -1&y|0)==0){v=a[30712+((y*23|0)>>>5&7)>>0]|0;u=a[z+30449>>0]|0;C=u&255;if(C>>>0<y>>>0){D=C;C=0;do{C=D|C<<v;J=c[m>>2]|0;if(J>>>0<(c[n>>2]|0)>>>0){c[m>>2]=J+1;R=d[J>>0]|0}else{R=em(b)|0}S=a[R+30449>>0]|0;D=S&255}while(D>>>0<y>>>0&C>>>0<134217728);T=S;U=0;V=C;W=R}else{T=u;U=0;V=0;W=z}D=Lm(-1,-1,v|0)|0;J=H;if((T&255)>>>0>=y>>>0|(U>>>0>J>>>0|(U|0)==(J|0)&V>>>0>D>>>0)){N=y;O=V;P=U;Q=W;w=73;break}else{X=V;Y=U;Z=T}while(1){I=Qm(X|0,Y|0,v|0)|0;G=H;F=Z&255|I;I=c[m>>2]|0;if(I>>>0<(c[n>>2]|0)>>>0){c[m>>2]=I+1;_=d[I>>0]|0}else{_=em(b)|0}Z=a[_+30449>>0]|0;if((Z&255)>>>0>=y>>>0|(G>>>0>J>>>0|(G|0)==(J|0)&F>>>0>D>>>0)){N=y;O=F;P=G;Q=_;w=73;break a}else{X=F;Y=G}}}D=a[z+30449>>0]|0;J=D&255;if(J>>>0<y>>>0){v=J;J=0;do{J=v+(da(J,y)|0)|0;u=c[m>>2]|0;if(u>>>0<(c[n>>2]|0)>>>0){c[m>>2]=u+1;$=d[u>>0]|0}else{$=em(b)|0}aa=a[$+30449>>0]|0;v=aa&255}while(v>>>0<y>>>0&J>>>0<119304647);ba=aa;ca=J;ea=0;fa=$}else{ba=D;ca=0;ea=0;fa=z}if((ba&255)>>>0<y>>>0){v=Zm(-1,-1,y|0,0)|0;u=H;C=ea;G=ca;F=ba;I=fa;while(1){if(C>>>0>u>>>0|(C|0)==(u|0)&G>>>0>v>>>0){N=y;O=G;P=C;Q=I;w=73;break a}K=Ym(G|0,C|0,y|0,0)|0;B=H;e=F&255;if(B>>>0>4294967295|(B|0)==-1&K>>>0>~e>>>0){N=y;O=G;P=C;Q=I;w=73;break a}r=Im(e|0,0,K|0,B|0)|0;B=H;K=c[m>>2]|0;if(K>>>0<(c[n>>2]|0)>>>0){c[m>>2]=K+1;ga=d[K>>0]|0}else{ga=em(b)|0}F=a[ga+30449>>0]|0;if(!((F&255)>>>0<y>>>0)){N=y;O=r;P=B;Q=ga;w=73;break}else{C=B;G=r;I=ga}}}else{N=y;O=ca;P=ea;Q=fa;w=73}}}while(0);if((w|0)==73){if((d[Q+30449>>0]|0)>>>0<N>>>0){do{Q=c[m>>2]|0;if(Q>>>0<(c[n>>2]|0)>>>0){c[m>>2]=Q+1;ha=d[Q>>0]|0}else{ha=em(b)|0}}while((d[ha+30449>>0]|0)>>>0<N>>>0);c[(qd()|0)>>2]=34;L=h;M=g}else{L=P;M=O}}if((c[n>>2]|0)!=0){c[m>>2]=(c[m>>2]|0)+ -1}if(!(L>>>0<h>>>0|(L|0)==(h|0)&M>>>0<g>>>0)){if((g&1|0)==0&0==0&(s|0)==0){c[(qd()|0)>>2]=34;m=Im(g|0,h|0,-1,-1)|0;k=H;l=m;H=k;i=j;return l|0}if(L>>>0>h>>>0|(L|0)==(h|0)&M>>>0>g>>>0){c[(qd()|0)>>2]=34;k=h;l=g;H=k;i=j;return l|0}}g=((s|0)<0)<<31>>31;h=Hm(M^s|0,L^g|0,s|0,g|0)|0;k=H;l=h;H=k;i=j;return l|0}function bm(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0.0,P=0,Q=0.0,R=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0.0,ba=0,ca=0.0,ea=0,fa=0.0,ga=0,ha=0.0,ia=0,ja=0.0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0.0,sa=0,ta=0.0,ua=0,va=0,wa=0,xa=0,ya=0.0,za=0,Aa=0.0,Ba=0.0,Ca=0,Da=0.0,Ea=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0.0,oc=0,pc=0,qc=0.0,rc=0.0,sc=0.0,tc=0.0,uc=0.0,vc=0.0,wc=0,xc=0,yc=0.0,zc=0,Ac=0.0,Bc=0,Cc=0,Dc=0,Ec=0;g=i;i=i+512|0;h=g;if((e|0)==2){j=53;k=-1074}else if((e|0)==1){j=53;k=-1074}else if((e|0)==0){j=24;k=-149}else{l=0.0;i=g;return+l}e=b+4|0;m=b+100|0;do{n=c[e>>2]|0;if(n>>>0<(c[m>>2]|0)>>>0){c[e>>2]=n+1;o=d[n>>0]|0}else{o=em(b)|0}}while((Zl(o)|0)!=0);do{if((o|0)==43|(o|0)==45){n=1-(((o|0)==45&1)<<1)|0;p=c[e>>2]|0;if(p>>>0<(c[m>>2]|0)>>>0){c[e>>2]=p+1;q=d[p>>0]|0;r=n;break}else{q=em(b)|0;r=n;break}}else{q=o;r=1}}while(0);o=q;q=0;while(1){if((o|32|0)!=(a[30728+q>>0]|0)){s=o;t=q;break}do{if(q>>>0<7){n=c[e>>2]|0;if(n>>>0<(c[m>>2]|0)>>>0){c[e>>2]=n+1;u=d[n>>0]|0;break}else{u=em(b)|0;break}}else{u=o}}while(0);n=q+1|0;if(n>>>0<8){o=u;q=n}else{s=u;t=n;break}}do{if((t|0)==3){v=23}else if((t|0)!=8){u=(f|0)==0;if(!(t>>>0<4|u)){if((t|0)==8){break}else{v=23;break}}a:do{if((t|0)==0){q=s;o=0;while(1){if((q|32|0)!=(a[30744+o>>0]|0)){y=q;z=o;break a}do{if(o>>>0<2){n=c[e>>2]|0;if(n>>>0<(c[m>>2]|0)>>>0){c[e>>2]=n+1;A=d[n>>0]|0;break}else{A=em(b)|0;break}}else{A=q}}while(0);n=o+1|0;if(n>>>0<3){q=A;o=n}else{y=A;z=n;break}}}else{y=s;z=t}}while(0);if((z|0)==0){do{if((y|0)==48){o=c[e>>2]|0;if(o>>>0<(c[m>>2]|0)>>>0){c[e>>2]=o+1;B=d[o>>0]|0}else{B=em(b)|0}if((B|32|0)!=120){if((c[m>>2]|0)==0){C=48;break}c[e>>2]=(c[e>>2]|0)+ -1;C=48;break}o=c[e>>2]|0;if(o>>>0<(c[m>>2]|0)>>>0){c[e>>2]=o+1;D=d[o>>0]|0;E=0}else{D=em(b)|0;E=0}while(1){if((D|0)==46){v=70;break}else if((D|0)!=48){F=0;G=0;I=0;J=0;K=D;L=E;M=0;N=0;O=1.0;P=0;Q=0.0;break}o=c[e>>2]|0;if(o>>>0<(c[m>>2]|0)>>>0){c[e>>2]=o+1;D=d[o>>0]|0;E=1;continue}else{D=em(b)|0;E=1;continue}}b:do{if((v|0)==70){o=c[e>>2]|0;if(o>>>0<(c[m>>2]|0)>>>0){c[e>>2]=o+1;R=d[o>>0]|0}else{R=em(b)|0}if((R|0)==48){o=-1;q=-1;while(1){n=c[e>>2]|0;if(n>>>0<(c[m>>2]|0)>>>0){c[e>>2]=n+1;T=d[n>>0]|0}else{T=em(b)|0}if((T|0)!=48){F=0;G=0;I=o;J=q;K=T;L=1;M=1;N=0;O=1.0;P=0;Q=0.0;break b}n=Im(o|0,q|0,-1,-1)|0;o=n;q=H}}else{F=0;G=0;I=0;J=0;K=R;L=E;M=1;N=0;O=1.0;P=0;Q=0.0}}}while(0);c:while(1){q=K+ -48|0;do{if(!(q>>>0<10)){o=K|32;n=(K|0)==46;if(!((o+ -97|0)>>>0<6|n)){U=K;break c}if(n){if((M|0)==0){V=G;W=F;X=G;Y=F;Z=L;_=1;$=N;aa=O;ba=P;ca=Q;break}else{U=46;break c}}else{ea=(K|0)>57?o+ -87|0:q;v=84;break}}else{ea=q;v=84}}while(0);if((v|0)==84){v=0;do{if(!((F|0)<0|(F|0)==0&G>>>0<8)){if((F|0)<0|(F|0)==0&G>>>0<14){fa=O*.0625;ga=N;ha=fa;ia=P;ja=Q+fa*+(ea|0);break}if((ea|0)!=0&(N|0)==0){ga=1;ha=O;ia=P;ja=Q+O*.5}else{ga=N;ha=O;ia=P;ja=Q}}else{ga=N;ha=O;ia=ea+(P<<4)|0;ja=Q}}while(0);q=Im(G|0,F|0,1,0)|0;V=I;W=J;X=q;Y=H;Z=1;_=M;$=ga;aa=ha;ba=ia;ca=ja}q=c[e>>2]|0;if(q>>>0<(c[m>>2]|0)>>>0){c[e>>2]=q+1;F=Y;G=X;I=V;J=W;K=d[q>>0]|0;L=Z;M=_;N=$;O=aa;P=ba;Q=ca;continue}else{F=Y;G=X;I=V;J=W;K=em(b)|0;L=Z;M=_;N=$;O=aa;P=ba;Q=ca;continue}}if((L|0)==0){q=(c[m>>2]|0)==0;if(!q){c[e>>2]=(c[e>>2]|0)+ -1}if(!u){if(!q?(q=c[e>>2]|0,c[e>>2]=q+ -1,(M|0)!=0):0){c[e>>2]=q+ -2}}else{dm(b,0)}l=+(r|0)*0.0;i=g;return+l}q=(M|0)==0;o=q?G:I;n=q?F:J;if((F|0)<0|(F|0)==0&G>>>0<8){q=G;p=F;ka=P;while(1){la=ka<<4;q=Im(q|0,p|0,1,0)|0;p=H;if(!((p|0)<0|(p|0)==0&q>>>0<8)){ma=la;break}else{ka=la}}}else{ma=P}do{if((U|32|0)==112){ka=cm(b,f)|0;q=H;if((ka|0)==0&(q|0)==-2147483648){if(u){dm(b,0);l=0.0;i=g;return+l}else{if((c[m>>2]|0)==0){na=0;oa=0;break}c[e>>2]=(c[e>>2]|0)+ -1;na=0;oa=0;break}}else{na=ka;oa=q}}else{if((c[m>>2]|0)==0){na=0;oa=0}else{c[e>>2]=(c[e>>2]|0)+ -1;na=0;oa=0}}}while(0);q=Qm(o|0,n|0,2)|0;ka=Im(q|0,H|0,-32,-1)|0;q=Im(ka|0,H|0,na|0,oa|0)|0;ka=H;if((ma|0)==0){l=+(r|0)*0.0;i=g;return+l}if((ka|0)>0|(ka|0)==0&q>>>0>(0-k|0)>>>0){c[(qd()|0)>>2]=34;l=+(r|0)*1.7976931348623157e+308*1.7976931348623157e+308;i=g;return+l}p=k+ -106|0;la=((p|0)<0)<<31>>31;if((ka|0)<(la|0)|(ka|0)==(la|0)&q>>>0<p>>>0){c[(qd()|0)>>2]=34;l=+(r|0)*2.2250738585072014e-308*2.2250738585072014e-308;i=g;return+l}if((ma|0)>-1){p=q;la=ka;pa=ma;fa=Q;while(1){qa=pa<<1;if(!(fa>=.5)){ra=fa;sa=qa}else{ra=fa+-1.0;sa=qa|1}ta=fa+ra;qa=Im(p|0,la|0,-1,-1)|0;ua=H;if((sa|0)>-1){p=qa;la=ua;pa=sa;fa=ta}else{va=qa;wa=ua;xa=sa;ya=ta;break}}}else{va=q;wa=ka;xa=ma;ya=Q}pa=Hm(32,0,k|0,((k|0)<0)<<31>>31|0)|0;la=Im(va|0,wa|0,pa|0,H|0)|0;pa=H;if(0>(pa|0)|0==(pa|0)&j>>>0>la>>>0){za=(la|0)<0?0:la}else{za=j}do{if((za|0)<53){fa=+(r|0);ta=+vd(+(+hm(1.0,84-za|0)),+fa);if(!((za|0)<32&ya!=0.0)){Aa=fa;Ba=ta;Ca=xa;Da=ya;break}la=xa&1;Aa=fa;Ba=ta;Ca=(la^1)+xa|0;Da=(la|0)==0?0.0:ya}else{Aa=+(r|0);Ba=0.0;Ca=xa;Da=ya}}while(0);ta=Aa*Da+(Ba+Aa*+(Ca>>>0))-Ba;if(!(ta!=0.0)){c[(qd()|0)>>2]=34}l=+im(ta,va);i=g;return+l}else{C=y}}while(0);ka=k+j|0;q=0-ka|0;la=C;pa=0;while(1){if((la|0)==46){v=139;break}else if((la|0)!=48){Ea=la;Ga=0;Ha=0;Ia=pa;Ja=0;break}p=c[e>>2]|0;if(p>>>0<(c[m>>2]|0)>>>0){c[e>>2]=p+1;la=d[p>>0]|0;pa=1;continue}else{la=em(b)|0;pa=1;continue}}d:do{if((v|0)==139){la=c[e>>2]|0;if(la>>>0<(c[m>>2]|0)>>>0){c[e>>2]=la+1;Ka=d[la>>0]|0}else{Ka=em(b)|0}if((Ka|0)==48){la=-1;p=-1;while(1){n=c[e>>2]|0;if(n>>>0<(c[m>>2]|0)>>>0){c[e>>2]=n+1;La=d[n>>0]|0}else{La=em(b)|0}if((La|0)!=48){Ea=La;Ga=la;Ha=p;Ia=1;Ja=1;break d}n=Im(la|0,p|0,-1,-1)|0;la=n;p=H}}else{Ea=Ka;Ga=0;Ha=0;Ia=pa;Ja=1}}}while(0);c[h>>2]=0;pa=Ea+ -48|0;p=(Ea|0)==46;e:do{if(pa>>>0<10|p){la=h+496|0;n=Ea;o=0;ua=0;qa=p;Ma=pa;Na=Ga;Oa=Ha;Pa=Ia;Qa=Ja;Ra=0;Sa=0;Ta=0;while(1){do{if(qa){if((Qa|0)==0){Ua=o;Va=ua;Wa=o;Xa=ua;Ya=Pa;Za=1;_a=Ra;$a=Sa;ab=Ta}else{bb=n;cb=Na;db=Oa;eb=o;fb=ua;gb=Pa;hb=Ra;ib=Sa;jb=Ta;break e}}else{kb=Im(o|0,ua|0,1,0)|0;lb=H;mb=(n|0)!=48;if((Sa|0)>=125){if(!mb){Ua=Na;Va=Oa;Wa=kb;Xa=lb;Ya=Pa;Za=Qa;_a=Ra;$a=Sa;ab=Ta;break}c[la>>2]=c[la>>2]|1;Ua=Na;Va=Oa;Wa=kb;Xa=lb;Ya=Pa;Za=Qa;_a=Ra;$a=Sa;ab=Ta;break}nb=h+(Sa<<2)|0;if((Ra|0)==0){ob=Ma}else{ob=n+ -48+((c[nb>>2]|0)*10|0)|0}c[nb>>2]=ob;nb=Ra+1|0;pb=(nb|0)==9;Ua=Na;Va=Oa;Wa=kb;Xa=lb;Ya=1;Za=Qa;_a=pb?0:nb;$a=(pb&1)+Sa|0;ab=mb?kb:Ta}}while(0);kb=c[e>>2]|0;if(kb>>>0<(c[m>>2]|0)>>>0){c[e>>2]=kb+1;qb=d[kb>>0]|0}else{qb=em(b)|0}Ma=qb+ -48|0;qa=(qb|0)==46;if(!(Ma>>>0<10|qa)){rb=qb;sb=Wa;tb=Ua;ub=Xa;vb=Va;wb=Ya;xb=Za;yb=_a;zb=$a;Ab=ab;v=162;break}else{n=qb;o=Wa;ua=Xa;Na=Ua;Oa=Va;Pa=Ya;Qa=Za;Ra=_a;Sa=$a;Ta=ab}}}else{rb=Ea;sb=0;tb=Ga;ub=0;vb=Ha;wb=Ia;xb=Ja;yb=0;zb=0;Ab=0;v=162}}while(0);if((v|0)==162){pa=(xb|0)==0;bb=rb;cb=pa?sb:tb;db=pa?ub:vb;eb=sb;fb=ub;gb=wb;hb=yb;ib=zb;jb=Ab}pa=(gb|0)!=0;if(pa?(bb|32|0)==101:0){p=cm(b,f)|0;Ta=H;do{if((p|0)==0&(Ta|0)==-2147483648){if(u){dm(b,0);l=0.0;i=g;return+l}else{if((c[m>>2]|0)==0){Bb=0;Cb=0;break}c[e>>2]=(c[e>>2]|0)+ -1;Bb=0;Cb=0;break}}else{Bb=p;Cb=Ta}}while(0);Ta=Im(Bb|0,Cb|0,cb|0,db|0)|0;Db=Ta;Eb=H}else{if((bb|0)>-1?(c[m>>2]|0)!=0:0){c[e>>2]=(c[e>>2]|0)+ -1;Db=cb;Eb=db}else{Db=cb;Eb=db}}if(!pa){c[(qd()|0)>>2]=22;dm(b,0);l=0.0;i=g;return+l}Ta=c[h>>2]|0;if((Ta|0)==0){l=+(r|0)*0.0;i=g;return+l}do{if((Db|0)==(eb|0)&(Eb|0)==(fb|0)&((fb|0)<0|(fb|0)==0&eb>>>0<10)){if(!(j>>>0>30)?(Ta>>>j|0)!=0:0){break}l=+(r|0)*+(Ta>>>0);i=g;return+l}}while(0);Ta=(k|0)/-2|0;pa=((Ta|0)<0)<<31>>31;if((Eb|0)>(pa|0)|(Eb|0)==(pa|0)&Db>>>0>Ta>>>0){c[(qd()|0)>>2]=34;l=+(r|0)*1.7976931348623157e+308*1.7976931348623157e+308;i=g;return+l}Ta=k+ -106|0;pa=((Ta|0)<0)<<31>>31;if((Eb|0)<(pa|0)|(Eb|0)==(pa|0)&Db>>>0<Ta>>>0){c[(qd()|0)>>2]=34;l=+(r|0)*2.2250738585072014e-308*2.2250738585072014e-308;i=g;return+l}if((hb|0)==0){Fb=ib}else{if((hb|0)<9){Ta=h+(ib<<2)|0;pa=c[Ta>>2]|0;p=hb;do{pa=pa*10|0;p=p+1|0}while((p|0)!=9);c[Ta>>2]=pa}Fb=ib+1|0}do{if((jb|0)<9?(jb|0)<=(Db|0)&(Db|0)<18:0){if((Db|0)==9){l=+(r|0)*+((c[h>>2]|0)>>>0);i=g;return+l}if((Db|0)<9){l=+(r|0)*+((c[h>>2]|0)>>>0)/+(c[30760+(8-Db<<2)>>2]|0);i=g;return+l}p=j+27+(da(Db,-3)|0)|0;Sa=c[h>>2]|0;if((p|0)<=30?(Sa>>>p|0)!=0:0){break}l=+(r|0)*+(Sa>>>0)*+(c[30760+(Db+ -10<<2)>>2]|0);i=g;return+l}}while(0);pa=(Db|0)%9|0;if((pa|0)==0){Gb=0;Hb=0;Ib=Db;Jb=Fb}else{Ta=(Db|0)>-1?pa:pa+9|0;pa=c[30760+(8-Ta<<2)>>2]|0;if((Fb|0)!=0){Sa=1e9/(pa|0)|0;p=0;Ra=0;Qa=0;Pa=Db;while(1){Oa=h+(Qa<<2)|0;Na=c[Oa>>2]|0;ua=((Na>>>0)/(pa>>>0)|0)+Ra|0;c[Oa>>2]=ua;Ra=da((Na>>>0)%(pa>>>0)|0,Sa)|0;Na=Qa;Qa=Qa+1|0;if((Na|0)==(p|0)&(ua|0)==0){Kb=Qa&127;Lb=Pa+ -9|0}else{Kb=p;Lb=Pa}if((Qa|0)==(Fb|0)){break}else{p=Kb;Pa=Lb}}if((Ra|0)==0){Mb=Kb;Nb=Lb;Ob=Fb}else{c[h+(Fb<<2)>>2]=Ra;Mb=Kb;Nb=Lb;Ob=Fb+1|0}}else{Mb=0;Nb=Db;Ob=0}Gb=Mb;Hb=0;Ib=9-Ta+Nb|0;Jb=Ob}f:while(1){Pa=h+(Gb<<2)|0;if((Ib|0)<18){p=Hb;Qa=Jb;while(1){Sa=0;pa=Qa+127|0;ua=Qa;while(1){Na=pa&127;Oa=h+(Na<<2)|0;o=Qm(c[Oa>>2]|0,0,29)|0;n=Im(o|0,H|0,Sa|0,0)|0;o=H;if(o>>>0>0|(o|0)==0&n>>>0>1e9){qa=Zm(n|0,o|0,1e9,0)|0;Ma=_m(n|0,o|0,1e9,0)|0;Pb=Ma;Qb=qa}else{Pb=n;Qb=0}c[Oa>>2]=Pb;Oa=(Na|0)==(Gb|0);if((Na|0)!=(ua+127&127|0)|Oa){Rb=ua}else{Rb=(Pb|0)==0?Na:ua}if(Oa){break}else{Sa=Qb;pa=Na+ -1|0;ua=Rb}}ua=p+ -29|0;if((Qb|0)==0){p=ua;Qa=Rb}else{Sb=ua;Tb=Qb;Ub=Rb;break}}}else{if((Ib|0)==18){Vb=Hb;Wb=Jb}else{Xb=Gb;Yb=Hb;Zb=Ib;_b=Jb;break}while(1){if(!((c[Pa>>2]|0)>>>0<9007199)){Xb=Gb;Yb=Vb;Zb=18;_b=Wb;break f}Qa=0;p=Wb+127|0;ua=Wb;while(1){pa=p&127;Sa=h+(pa<<2)|0;Na=Qm(c[Sa>>2]|0,0,29)|0;Oa=Im(Na|0,H|0,Qa|0,0)|0;Na=H;if(Na>>>0>0|(Na|0)==0&Oa>>>0>1e9){n=Zm(Oa|0,Na|0,1e9,0)|0;qa=_m(Oa|0,Na|0,1e9,0)|0;$b=qa;ac=n}else{$b=Oa;ac=0}c[Sa>>2]=$b;Sa=(pa|0)==(Gb|0);if((pa|0)!=(ua+127&127|0)|Sa){bc=ua}else{bc=($b|0)==0?pa:ua}if(Sa){break}else{Qa=ac;p=pa+ -1|0;ua=bc}}ua=Vb+ -29|0;if((ac|0)==0){Vb=ua;Wb=bc}else{Sb=ua;Tb=ac;Ub=bc;break}}}Pa=Gb+127&127;if((Pa|0)==(Ub|0)){ua=Ub+127&127;p=h+((Ub+126&127)<<2)|0;c[p>>2]=c[p>>2]|c[h+(ua<<2)>>2];cc=ua}else{cc=Ub}c[h+(Pa<<2)>>2]=Tb;Gb=Pa;Hb=Sb;Ib=Ib+9|0;Jb=cc}g:while(1){dc=_b+1&127;Ta=h+((_b+127&127)<<2)|0;Ra=Xb;Pa=Yb;ua=Zb;while(1){p=(ua|0)==18;Qa=(ua|0)>27?9:1;ec=Ra;fc=Pa;while(1){pa=0;while(1){Sa=pa+ec&127;if((Sa|0)==(_b|0)){gc=2;break}Oa=c[h+(Sa<<2)>>2]|0;Sa=c[30752+(pa<<2)>>2]|0;if(Oa>>>0<Sa>>>0){gc=2;break}n=pa+1|0;if(Oa>>>0>Sa>>>0){gc=pa;break}if((n|0)<2){pa=n}else{gc=n;break}}if((gc|0)==2&p){break g}hc=Qa+fc|0;if((ec|0)==(_b|0)){ec=_b;fc=hc}else{break}}p=(1<<Qa)+ -1|0;pa=1e9>>>Qa;ic=ec;jc=0;n=ec;kc=ua;do{Sa=h+(n<<2)|0;Oa=c[Sa>>2]|0;qa=(Oa>>>Qa)+jc|0;c[Sa>>2]=qa;jc=da(Oa&p,pa)|0;Oa=(n|0)==(ic|0)&(qa|0)==0;n=n+1&127;kc=Oa?kc+ -9|0:kc;ic=Oa?n:ic}while((n|0)!=(_b|0));if((jc|0)==0){Ra=ic;Pa=hc;ua=kc;continue}if((dc|0)!=(ic|0)){break}c[Ta>>2]=c[Ta>>2]|1;Ra=ic;Pa=hc;ua=kc}c[h+(_b<<2)>>2]=jc;Xb=ic;Yb=hc;Zb=kc;_b=dc}ua=ec&127;if((ua|0)==(_b|0)){c[h+(dc+ -1<<2)>>2]=0;lc=dc}else{lc=_b}ta=+((c[h+(ua<<2)>>2]|0)>>>0);ua=ec+1&127;if((ua|0)==(lc|0)){Pa=lc+1&127;c[h+(Pa+ -1<<2)>>2]=0;mc=Pa}else{mc=lc}fa=+(r|0);nc=fa*(ta*1.0e9+ +((c[h+(ua<<2)>>2]|0)>>>0));ua=fc+53|0;Pa=ua-k|0;if((Pa|0)<(j|0)){oc=(Pa|0)<0?0:Pa;pc=1}else{oc=j;pc=0}if((oc|0)<53){ta=+vd(+(+hm(1.0,105-oc|0)),+nc);qc=+Fa(+nc,+(+hm(1.0,53-oc|0)));rc=ta;sc=qc;tc=ta+(nc-qc)}else{rc=0.0;sc=0.0;tc=nc}Ra=ec+2&127;do{if((Ra|0)==(mc|0)){uc=sc}else{Ta=c[h+(Ra<<2)>>2]|0;do{if(!(Ta>>>0<5e8)){if(Ta>>>0>5e8){vc=fa*.75+sc;break}if((ec+3&127|0)==(mc|0)){vc=fa*.5+sc;break}else{vc=fa*.75+sc;break}}else{if((Ta|0)==0?(ec+3&127|0)==(mc|0):0){vc=sc;break}vc=fa*.25+sc}}while(0);if((53-oc|0)<=1){uc=vc;break}if(+Fa(+vc,1.0)!=0.0){uc=vc;break}uc=vc+1.0}}while(0);fa=tc+uc-rc;do{if((ua&2147483647|0)>(-2-ka|0)){if(!(+S(+fa)>=9007199254740992.0)){wc=pc;xc=fc;yc=fa}else{wc=(pc|0)!=0&(oc|0)==(Pa|0)?0:pc;xc=fc+1|0;yc=fa*.5}if((xc+50|0)<=(q|0)?!((wc|0)!=0&uc!=0.0):0){zc=xc;Ac=yc;break}c[(qd()|0)>>2]=34;zc=xc;Ac=yc}else{zc=fc;Ac=fa}}while(0);l=+im(Ac,zc);i=g;return+l}else if((z|0)==3){q=c[e>>2]|0;if(q>>>0<(c[m>>2]|0)>>>0){c[e>>2]=q+1;Bc=d[q>>0]|0}else{Bc=em(b)|0}if((Bc|0)==40){Cc=1}else{if((c[m>>2]|0)==0){l=w;i=g;return+l}c[e>>2]=(c[e>>2]|0)+ -1;l=w;i=g;return+l}while(1){q=c[e>>2]|0;if(q>>>0<(c[m>>2]|0)>>>0){c[e>>2]=q+1;Dc=d[q>>0]|0}else{Dc=em(b)|0}if(!((Dc+ -48|0)>>>0<10|(Dc+ -65|0)>>>0<26)?!((Dc+ -97|0)>>>0<26|(Dc|0)==95):0){break}Cc=Cc+1|0}if((Dc|0)==41){l=w;i=g;return+l}q=(c[m>>2]|0)==0;if(!q){c[e>>2]=(c[e>>2]|0)+ -1}if(u){c[(qd()|0)>>2]=22;dm(b,0);l=0.0;i=g;return+l}if((Cc|0)==0|q){l=w;i=g;return+l}else{Ec=Cc}do{Ec=Ec+ -1|0;c[e>>2]=(c[e>>2]|0)+ -1}while((Ec|0)!=0);l=w;i=g;return+l}else{if((c[m>>2]|0)!=0){c[e>>2]=(c[e>>2]|0)+ -1}c[(qd()|0)>>2]=22;dm(b,0);l=0.0;i=g;return+l}}}while(0);if((v|0)==23){v=(c[m>>2]|0)==0;if(!v){c[e>>2]=(c[e>>2]|0)+ -1}if(!(t>>>0<4|(f|0)==0|v)){v=t;do{c[e>>2]=(c[e>>2]|0)+ -1;v=v+ -1|0}while(v>>>0>3)}}l=+(r|0)*x;i=g;return+l}function cm(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;e=i;f=a+4|0;g=c[f>>2]|0;h=a+100|0;if(g>>>0<(c[h>>2]|0)>>>0){c[f>>2]=g+1;j=d[g>>0]|0}else{j=em(a)|0}if((j|0)==43|(j|0)==45){g=(j|0)==45&1;k=c[f>>2]|0;if(k>>>0<(c[h>>2]|0)>>>0){c[f>>2]=k+1;l=d[k>>0]|0}else{l=em(a)|0}if(!((l+ -48|0)>>>0<10|(b|0)==0)?(c[h>>2]|0)!=0:0){c[f>>2]=(c[f>>2]|0)+ -1;m=l;n=g}else{m=l;n=g}}else{m=j;n=0}if((m+ -48|0)>>>0>9){if((c[h>>2]|0)==0){o=-2147483648;p=0;H=o;i=e;return p|0}c[f>>2]=(c[f>>2]|0)+ -1;o=-2147483648;p=0;H=o;i=e;return p|0}else{q=m;r=0}while(1){s=q+ -48+r|0;m=c[f>>2]|0;if(m>>>0<(c[h>>2]|0)>>>0){c[f>>2]=m+1;t=d[m>>0]|0}else{t=em(a)|0}if(!((t+ -48|0)>>>0<10&(s|0)<214748364)){break}q=t;r=s*10|0}r=((s|0)<0)<<31>>31;if((t+ -48|0)>>>0<10){q=s;m=r;j=t;while(1){g=Ym(q|0,m|0,10,0)|0;l=H;b=Im(j|0,((j|0)<0)<<31>>31|0,-48,-1)|0;k=Im(b|0,H|0,g|0,l|0)|0;l=H;g=c[f>>2]|0;if(g>>>0<(c[h>>2]|0)>>>0){c[f>>2]=g+1;u=d[g>>0]|0}else{u=em(a)|0}if((u+ -48|0)>>>0<10&((l|0)<21474836|(l|0)==21474836&k>>>0<2061584302)){q=k;m=l;j=u}else{v=k;w=l;x=u;break}}}else{v=s;w=r;x=t}if((x+ -48|0)>>>0<10){do{x=c[f>>2]|0;if(x>>>0<(c[h>>2]|0)>>>0){c[f>>2]=x+1;y=d[x>>0]|0}else{y=em(a)|0}}while((y+ -48|0)>>>0<10)}if((c[h>>2]|0)!=0){c[f>>2]=(c[f>>2]|0)+ -1}f=(n|0)!=0;n=Hm(0,0,v|0,w|0)|0;o=f?H:w;p=f?n:v;H=o;i=e;return p|0}function dm(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;c[a+104>>2]=b;e=c[a+8>>2]|0;f=c[a+4>>2]|0;g=e-f|0;c[a+108>>2]=g;if((b|0)!=0&(g|0)>(b|0)){c[a+100>>2]=f+b;i=d;return}else{c[a+100>>2]=e;i=d;return}}function em(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=b+104|0;g=c[f>>2]|0;if(!((g|0)!=0?(c[b+108>>2]|0)>=(g|0):0)){h=3}if((h|0)==3?(h=nm(b)|0,(h|0)>=0):0){g=c[f>>2]|0;f=c[b+8>>2]|0;if((g|0)!=0?(j=c[b+4>>2]|0,k=g-(c[b+108>>2]|0)+ -1|0,(f-j|0)>(k|0)):0){c[b+100>>2]=j+k}else{c[b+100>>2]=f}k=c[b+4>>2]|0;if((f|0)!=0){j=b+108|0;c[j>>2]=f+1-k+(c[j>>2]|0)}j=k+ -1|0;if((d[j>>0]|0|0)==(h|0)){l=h;i=e;return l|0}a[j>>0]=h;l=h;i=e;return l|0}c[b+100>>2]=0;l=-1;i=e;return l|0}function fm(a,b){a=+a;b=b|0;var d=0,e=0,f=0,g=0,j=0,l=0.0,m=0.0,n=0,o=0.0;d=i;h[k>>3]=a;e=c[k>>2]|0;f=c[k+4>>2]|0;g=Lm(e|0,f|0,52)|0;j=g&2047;if((j|0)==0){if(a!=0.0){l=+fm(a*18446744073709552000.0,b);m=l;n=(c[b>>2]|0)+ -64|0}else{m=a;n=0}c[b>>2]=n;o=m;i=d;return+o}else if((j|0)==2047){o=a;i=d;return+o}else{c[b>>2]=j+ -1022;c[k>>2]=e;c[k+4>>2]=f&-2146435073|1071644672;o=+h[k>>3];i=d;return+o}return 0.0}function gm(a,b){a=+a;b=b|0;var c=0,d=0.0;c=i;d=+fm(a,b);i=c;return+d}function hm(a,b){a=+a;b=b|0;var d=0,e=0.0,f=0,g=0,j=0,l=0.0;d=i;if((b|0)>1023){e=a*8.98846567431158e+307;f=b+ -1023|0;if((f|0)>1023){g=b+ -2046|0;j=(g|0)>1023?1023:g;l=e*8.98846567431158e+307}else{j=f;l=e}}else{if((b|0)<-1022){e=a*2.2250738585072014e-308;f=b+1022|0;if((f|0)<-1022){g=b+2044|0;j=(g|0)<-1022?-1022:g;l=e*2.2250738585072014e-308}else{j=f;l=e}}else{j=b;l=a}}b=Qm(j+1023|0,0,52)|0;j=H;c[k>>2]=b;c[k+4>>2]=j;a=l*+h[k>>3];i=d;return+a}function im(a,b){a=+a;b=b|0;var c=0,d=0.0;c=i;d=+hm(a,b);i=c;return+d}function jm(a,b){a=a|0;b=b|0;var c=0,d=0;c=i;if((a|0)==0){d=0}else{d=km(a,b,0)|0}i=c;return d|0}function km(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;e=i;if((b|0)==0){f=1;i=e;return f|0}if(d>>>0<128){a[b>>0]=d;f=1;i=e;return f|0}if(d>>>0<2048){a[b>>0]=d>>>6|192;a[b+1>>0]=d&63|128;f=2;i=e;return f|0}if(d>>>0<55296|(d+ -57344|0)>>>0<8192){a[b>>0]=d>>>12|224;a[b+1>>0]=d>>>6&63|128;a[b+2>>0]=d&63|128;f=3;i=e;return f|0}if((d+ -65536|0)>>>0<1048576){a[b>>0]=d>>>18|240;a[b+1>>0]=d>>>12&63|128;a[b+2>>0]=d>>>6&63|128;a[b+3>>0]=d&63|128;f=4;i=e;return f|0}else{c[(qd()|0)>>2]=84;f=-1;i=e;return f|0}return 0}function lm(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;e=b+74|0;f=a[e>>0]|0;a[e>>0]=f+255|f;f=b+20|0;e=b+44|0;if((c[f>>2]|0)>>>0>(c[e>>2]|0)>>>0){Fd[c[b+36>>2]&15](b,0,0)|0}c[b+16>>2]=0;c[b+28>>2]=0;c[f>>2]=0;f=c[b>>2]|0;if((f&20|0)==0){g=c[e>>2]|0;c[b+8>>2]=g;c[b+4>>2]=g;h=0;i=d;return h|0}if((f&4|0)==0){h=-1;i=d;return h|0}c[b>>2]=f|32;h=-1;i=d;return h|0}function mm(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;e=b+74|0;f=a[e>>0]|0;a[e>>0]=f+255|f;f=c[b>>2]|0;if((f&8|0)==0){c[b+8>>2]=0;c[b+4>>2]=0;e=c[b+44>>2]|0;c[b+28>>2]=e;c[b+20>>2]=e;c[b+16>>2]=e+(c[b+48>>2]|0);g=0;i=d;return g|0}else{c[b>>2]=f|32;g=-1;i=d;return g|0}return 0}function nm(a){a=a|0;var b=0,e=0,f=0;b=i;i=i+16|0;e=b;if((c[a+8>>2]|0)==0?(lm(a)|0)!=0:0){f=-1}else{if((Fd[c[a+32>>2]&15](a,e,1)|0)==1){f=d[e>>0]|0}else{f=-1}}i=b;return f|0}function om(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;g=e+16|0;h=c[g>>2]|0;do{if((h|0)==0){if((mm(e)|0)==0){j=c[g>>2]|0;break}else{k=0;i=f;return k|0}}else{j=h}}while(0);h=e+20|0;g=c[h>>2]|0;if((j-g|0)>>>0<d>>>0){k=Fd[c[e+36>>2]&15](e,b,d)|0;i=f;return k|0}a:do{if((a[e+75>>0]|0)>-1){j=d;while(1){if((j|0)==0){l=d;m=b;n=g;o=0;break a}p=j+ -1|0;if((a[b+p>>0]|0)==10){break}else{j=p}}if((Fd[c[e+36>>2]&15](e,b,j)|0)>>>0<j>>>0){k=j;i=f;return k|0}else{l=d-j|0;m=b+j|0;n=c[h>>2]|0;o=j;break}}else{l=d;m=b;n=g;o=0}}while(0);Mm(n|0,m|0,l|0)|0;c[h>>2]=(c[h>>2]|0)+l;k=o+l|0;i=f;return k|0}function pm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;e=tm(a,b,d,g)|0;i=f;return e|0}function qm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=d;d=vm(a,b,f)|0;i=e;return d|0}function rm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+224|0;f=e+120|0;g=e+80|0;h=e;j=e+136|0;k=g+0|0;l=k+40|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));c[f>>2]=c[d>>2];if((sm(0,b,f,h,g)|0)<0){m=-1;i=e;return m|0}d=a+48|0;if((c[d>>2]|0)==0){k=a+44|0;l=c[k>>2]|0;c[k>>2]=j;n=a+28|0;c[n>>2]=j;o=a+20|0;c[o>>2]=j;c[d>>2]=80;p=a+16|0;c[p>>2]=j+80;j=sm(a,b,f,h,g)|0;if((l|0)==0){q=j}else{Fd[c[a+36>>2]&15](a,0,0)|0;r=(c[o>>2]|0)==0?-1:j;c[k>>2]=l;c[d>>2]=0;c[p>>2]=0;c[n>>2]=0;c[o>>2]=0;q=r}}else{q=sm(a,b,f,h,g)|0}m=q;i=e;return m|0}function sm(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0.0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0.0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0.0,Db=0.0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0.0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0.0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0.0,zc=0.0,Ac=0.0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Yc=0,Zc=0,_c=0,ad=0,bd=0,cd=0,dd=0,ed=0,fd=0,gd=0,hd=0,id=0,jd=0,kd=0,ld=0,md=0,nd=0,od=0,pd=0,rd=0,sd=0,td=0,ud=0;m=i;i=i+832|0;n=m+16|0;o=m;p=m+808|0;q=p;r=m+792|0;s=m+496|0;t=m+752|0;u=m+8|0;v=m+804|0;w=(e|0)!=0;x=t+40|0;y=x;z=t+39|0;t=u+4|0;A=r+12|0;B=r+11|0;r=A;C=r-q|0;D=-2-q|0;E=r+2|0;F=n+264|0;G=p+9|0;I=G;J=p+8|0;K=0;L=0;M=f;f=0;N=0;O=0;a:while(1){do{if((f|0)>-1){if((N|0)>(2147483647-f|0)){c[(qd()|0)>>2]=75;P=-1;break}else{P=N+f|0;break}}else{P=f}}while(0);Q=a[M>>0]|0;if(Q<<24>>24==0){R=339;break}else{S=Q;T=M}while(1){if(S<<24>>24==0){U=T;V=T;break}else if(S<<24>>24==37){W=T;X=T;R=9;break}Q=T+1|0;S=a[Q>>0]|0;T=Q}b:do{if((R|0)==9){while(1){R=0;if((a[W+1>>0]|0)!=37){U=W;V=X;break b}Q=X+1|0;Y=W+2|0;if((a[Y>>0]|0)==37){W=Y;X=Q;R=9}else{U=Y;V=Q;break}}}}while(0);Q=V-M|0;if(w){om(M,Q,e)|0}if((V|0)!=(M|0)){Z=L;_=K;M=U;f=P;N=Q;L=Z;K=_;continue}Y=U+1|0;$=a[Y>>0]|0;aa=($<<24>>24)+ -48|0;if(aa>>>0<10?(a[U+2>>0]|0)==36:0){ba=U+3|0;ca=a[ba>>0]|0;ea=aa;fa=1;ga=ba}else{ca=$;ea=-1;fa=O;ga=Y}Y=ca<<24>>24;c:do{if((Y+ -32|0)>>>0<32){$=Y;ba=ca;aa=0;ha=ga;while(1){if((1<<$+ -32&75913|0)==0){ia=ba;ja=aa;ka=ha;break c}la=1<<(ba<<24>>24)+ -32|aa;ma=ha+1|0;na=a[ma>>0]|0;$=na<<24>>24;if(!(($+ -32|0)>>>0<32)){ia=na;ja=la;ka=ma;break}else{ba=na;aa=la;ha=ma}}}else{ia=ca;ja=0;ka=ga}}while(0);do{if(ia<<24>>24==42){Y=ka+1|0;ha=(a[Y>>0]|0)+ -48|0;if(ha>>>0<10?(a[ka+2>>0]|0)==36:0){c[l+(ha<<2)>>2]=10;oa=1;pa=ka+3|0;qa=c[j+((a[Y>>0]|0)+ -48<<3)>>2]|0}else{if((fa|0)!=0){ra=-1;R=357;break a}if(!w){sa=Y;ta=ja;ua=0;va=0;break}ha=c[g>>2]|0;aa=c[ha>>2]|0;c[g>>2]=ha+4;oa=0;pa=Y;qa=aa}if((qa|0)<0){sa=pa;ta=ja|8192;ua=oa;va=0-qa|0}else{sa=pa;ta=ja;ua=oa;va=qa}}else{aa=ia<<24>>24;if((aa+ -48|0)>>>0<10){Y=aa;aa=ka;ha=0;do{ha=Y+ -48+(ha*10|0)|0;aa=aa+1|0;Y=a[aa>>0]|0}while((Y+ -48|0)>>>0<10);if((ha|0)<0){ra=-1;R=357;break a}else{sa=aa;ta=ja;ua=fa;va=ha}}else{sa=ka;ta=ja;ua=fa;va=0}}}while(0);d:do{if((a[sa>>0]|0)==46){Y=sa+1|0;ba=a[Y>>0]|0;if(!(ba<<24>>24==42)){$=ba<<24>>24;if(($+ -48|0)>>>0<10){wa=$;xa=Y;ya=0}else{za=Y;Aa=0;break}while(1){Y=wa+ -48+(ya*10|0)|0;$=xa+1|0;wa=a[$>>0]|0;if(!((wa+ -48|0)>>>0<10)){za=$;Aa=Y;break d}else{xa=$;ya=Y}}}ha=sa+2|0;aa=(a[ha>>0]|0)+ -48|0;if(aa>>>0<10?(a[sa+3>>0]|0)==36:0){c[l+(aa<<2)>>2]=10;za=sa+4|0;Aa=c[j+((a[ha>>0]|0)+ -48<<3)>>2]|0;break}if((ua|0)!=0){ra=-1;R=357;break a}if(w){aa=c[g>>2]|0;Y=c[aa>>2]|0;c[g>>2]=aa+4;za=ha;Aa=Y}else{za=ha;Aa=0}}else{za=sa;Aa=-1}}while(0);ha=za;Y=0;while(1){Ba=a[ha>>0]|0;aa=(Ba<<24>>24)+ -65|0;if(aa>>>0>57){ra=-1;R=357;break a}Ca=ha+1|0;Da=a[30792+(Y*58|0)+aa>>0]|0;Ea=Da&255;if((Ea+ -1|0)>>>0<8){ha=Ca;Y=Ea}else{break}}if(Da<<24>>24==0){ra=-1;R=357;break}aa=(ea|0)>-1;e:do{if(Da<<24>>24==19){if(aa){ra=-1;R=357;break a}if(w){Fa=Ba;Ga=L;Ha=K}else{Z=L;_=K;M=Ca;f=P;N=Q;O=ua;L=Z;K=_;continue a}}else{f:do{if(aa){c[l+(ea<<2)>>2]=Ea;$=j+(ea<<3)|0;Ia=c[$>>2]|0;Ja=c[$+4>>2]|0;R=64}else{if(!w){ra=0;R=357;break a}if((Da&255)>20){Fa=Ba;Ga=L;Ha=K;break e}do{switch(Ea|0){case 17:{$=c[g>>2]|0;c[k>>2]=c[$>>2];c[k+4>>2]=c[$+4>>2];Ka=+h[k>>3];c[g>>2]=$+8;h[k>>3]=Ka;La=c[k>>2]|0;Ma=c[k+4>>2]|0;break f;break};case 13:{$=c[g>>2]|0;ba=c[$>>2]|0;c[g>>2]=$+4;La=ba<<16>>16;Ma=(((ba&65535)<<16>>16|0)<0)<<31>>31;break f;break};case 10:{ba=c[g>>2]|0;$=c[ba>>2]|0;c[g>>2]=ba+4;La=$;Ma=(($|0)<0)<<31>>31;break f;break};case 15:{$=c[g>>2]|0;ba=c[$>>2]|0;c[g>>2]=$+4;La=ba<<24>>24;Ma=(((ba&255)<<24>>24|0)<0)<<31>>31;break f;break};case 14:{ba=c[g>>2]|0;$=c[ba>>2]|0;c[g>>2]=ba+4;La=$&65535;Ma=0;break f;break};case 16:{$=c[g>>2]|0;ba=c[$>>2]|0;c[g>>2]=$+4;La=ba&255;Ma=0;break f;break};case 9:{ba=c[g>>2]|0;$=c[ba>>2]|0;c[g>>2]=ba+4;La=$;Ma=K;break f;break};case 18:{$=c[g>>2]|0;c[k>>2]=c[$>>2];c[k+4>>2]=c[$+4>>2];Ka=+h[k>>3];c[g>>2]=$+8;h[k>>3]=Ka;Ia=c[k>>2]|0;Ja=c[k+4>>2]|0;R=64;break f;break};case 11:{$=c[g>>2]|0;ba=c[$>>2]|0;c[g>>2]=$+4;La=ba;Ma=0;break f;break};case 12:{ba=c[g>>2]|0;$=ba;ma=c[$>>2]|0;la=c[$+4>>2]|0;c[g>>2]=ba+8;La=ma;Ma=la;break f;break};default:{La=L;Ma=K;break f}}}while(0)}}while(0);if((R|0)==64){R=0;la=Ia;if(w){La=la;Ma=Ja}else{K=Ja;L=la;M=Ca;f=P;N=Q;O=ua;continue a}}Fa=a[ha>>0]|0;Ga=La;Ha=Ma}}while(0);ha=Fa<<24>>24;if((Y|0)==0){Na=ha}else{Na=(ha&15|0)==3?ha&-33:ha}ha=ta&-65537;aa=(ta&8192|0)==0?ta:ha;g:do{switch(Na|0){case 112:{Oa=aa|8;Pa=Aa>>>0>8?Aa:8;Qa=120;R=78;break};case 110:{switch(Y|0){case 0:{c[Ga>>2]=P;K=Ha;L=Ga;M=Ca;f=P;N=Q;O=ua;continue a;break};case 2:{la=Ga;c[la>>2]=P;c[la+4>>2]=((P|0)<0)<<31>>31;K=Ha;L=Ga;M=Ca;f=P;N=Q;O=ua;continue a;break};case 1:{c[Ga>>2]=P;K=Ha;L=Ga;M=Ca;f=P;N=Q;O=ua;continue a;break};case 3:{b[Ga>>1]=P;K=Ha;L=Ga;M=Ca;f=P;N=Q;O=ua;continue a;break};case 4:{a[Ga>>0]=P;K=Ha;L=Ga;M=Ca;f=P;N=Q;O=ua;continue a;break};case 6:{c[Ga>>2]=P;K=Ha;L=Ga;M=Ca;f=P;N=Q;O=ua;continue a;break};case 7:{la=Ga;c[la>>2]=P;c[la+4>>2]=((P|0)<0)<<31>>31;K=Ha;L=Ga;M=Ca;f=P;N=Q;O=ua;continue a;break};default:{K=Ha;L=Ga;M=Ca;f=P;N=Q;O=ua;continue a}}break};case 111:{la=Ga;ma=(la|0)==0&(Ha|0)==0;if(ma){Ra=x}else{ba=x;$=la;la=Ha;while(1){na=ba+ -1|0;a[na>>0]=$&7|48;$=Lm($|0,la|0,3)|0;la=H;if(($|0)==0&(la|0)==0){Ra=na;break}else{ba=na}}}if((aa&8|0)==0){Sa=Ga;Ta=Ha;Ua=Ra;Va=aa;Wa=Aa;Xa=0;Ya=31256;R=95}else{Sa=Ga;Ta=Ha;Ua=Ra;Va=aa;Wa=Aa;Xa=ma&1^1;Ya=ma?31256:31261|0;R=95}break};case 105:case 100:{if((Ha|0)<0){ba=Hm(0,0,Ga|0,Ha|0)|0;Za=ba;_a=H;$a=1;ab=31256;R=90;break g}if((aa&2048|0)==0){ba=aa&1;Za=Ga;_a=Ha;$a=ba;ab=(ba|0)==0?31256:31258|0;R=90}else{Za=Ga;_a=Ha;$a=1;ab=31257|0;R=90}break};case 117:{Za=Ga;_a=Ha;$a=0;ab=31256;R=90;break};case 88:case 120:{Oa=aa;Pa=Aa;Qa=Na;R=78;break};case 99:{a[z>>0]=Ga;bb=Ha;cb=Ga;db=z;eb=ha;fb=1;gb=0;hb=31256;ib=x;break};case 67:{c[u>>2]=Ga;c[t>>2]=0;jb=u;kb=u;lb=-1;R=105;break};case 115:{mb=(Ga|0)==0?31272:Ga;R=100;break};case 83:{if((Aa|0)==0){nb=Ga;ob=Ga;pb=0;R=111}else{jb=Ga;kb=Ga;lb=Aa;R=105}break};case 109:{mb=$c(c[(qd()|0)>>2]|0)|0;R=100;break};case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{c[k>>2]=Ga;c[k+4>>2]=Ha;Ka=+h[k>>3];c[o>>2]=0;if((Ha|0)>=0){if((aa&2048|0)==0){ba=aa&1;qb=Ka;rb=ba;sb=(ba|0)==0?31281|0:31286|0}else{qb=Ka;rb=1;sb=31283|0}}else{qb=-Ka;rb=1;sb=31280}h[k>>3]=qb;ba=c[k+4>>2]&2146435072;if(!(ba>>>0<2146435072|(ba|0)==2146435072&0<0)){ba=(Na&32|0)!=0;if(qb!=qb|0.0!=0.0){tb=0;ub=ba?31320:31328}else{tb=rb;ub=ba?31304:31312}ba=tb+3|0;la=(ba|0)<(va|0);if((aa&8192|0)==0&la){$=va-ba|0;Om(s|0,32,($>>>0>256?256:$)|0)|0;if($>>>0>255){na=$;while(1){om(s,256,e)|0;vb=na+ -256|0;if(vb>>>0>255){na=vb}else{wb=vb;break}}}else{wb=$}om(s,wb,e)|0}om(sb,tb,e)|0;om(ub,3,e)|0;if((aa&73728|0)==8192&la){na=va-ba|0;Om(s|0,32,(na>>>0>256?256:na)|0)|0;if(na>>>0>255){ma=na;while(1){om(s,256,e)|0;vb=ma+ -256|0;if(vb>>>0>255){ma=vb}else{xb=vb;break}}}else{xb=na}om(s,xb,e)|0}K=Ha;L=Ga;M=Ca;f=P;N=la?va:ba;O=ua;continue a}Ka=+gm(qb,o)*2.0;ma=Ka!=0.0;if(ma){c[o>>2]=(c[o>>2]|0)+ -1}$=Na|32;if(($|0)==97){vb=Na&32;yb=(vb|0)==0?sb:sb+9|0;zb=rb|2;Ab=Aa>>>0>11?0:12-Aa|0;do{if((Ab|0)!=0){Bb=Ab;Cb=8.0;do{Bb=Bb+ -1|0;Cb=Cb*16.0}while((Bb|0)!=0);if((a[yb>>0]|0)==45){Db=-(Cb+(-Ka-Cb));break}else{Db=Ka+Cb-Cb;break}}else{Db=Ka}}while(0);Ab=c[o>>2]|0;ba=(Ab|0)<0?0-Ab|0:Ab;if((ba|0)<0){Ab=A;la=ba;na=((ba|0)<0)<<31>>31;while(1){Bb=_m(la|0,na|0,10,0)|0;Ab=Ab+ -1|0;a[Ab>>0]=Bb|48;Bb=la;la=Zm(la|0,na|0,10,0)|0;if(!(na>>>0>9|(na|0)==9&Bb>>>0>4294967295)){break}else{na=H}}Eb=Ab;Fb=la}else{Eb=A;Fb=ba}if((Fb|0)==0){Gb=Eb}else{na=Eb;Bb=Fb;while(1){Hb=na+ -1|0;a[Hb>>0]=(Bb>>>0)%10|0|48;if(Bb>>>0<10){Gb=Hb;break}else{na=Hb;Bb=(Bb>>>0)/10|0}}}if((Gb|0)==(A|0)){a[B>>0]=48;Ib=B}else{Ib=Gb}a[Ib+ -1>>0]=(c[o>>2]>>31&2)+43;Bb=Ib+ -2|0;a[Bb>>0]=Na+15;na=(aa&8|0)==0;if((Aa|0)>0){if(na){Jb=Db;ba=p;while(1){la=~~Jb;Ab=ba+1|0;a[ba>>0]=d[31336+la>>0]|vb;Jb=(Jb- +(la|0))*16.0;if((Ab-q|0)==1){a[Ab>>0]=46;Kb=ba+2|0}else{Kb=Ab}if(!(Jb!=0.0)){Lb=Kb;break}else{ba=Kb}}}else{Jb=Db;ba=p;while(1){Ab=~~Jb;la=ba+1|0;a[ba>>0]=d[31336+Ab>>0]|vb;Jb=(Jb- +(Ab|0))*16.0;if((la-q|0)==1){a[la>>0]=46;Mb=ba+2|0}else{Mb=la}if(!(Jb!=0.0)){Lb=Mb;break}else{ba=Mb}}}}else{if(na){Jb=Db;ba=p;while(1){la=~~Jb;Ab=ba+1|0;a[ba>>0]=d[31336+la>>0]|vb;Jb=(Jb- +(la|0))*16.0;la=Jb!=0.0;if((Ab-q|0)==1&la){a[Ab>>0]=46;Nb=ba+2|0}else{Nb=Ab}if(!la){Lb=Nb;break}else{ba=Nb}}}else{Jb=Db;ba=p;while(1){na=~~Jb;la=ba+1|0;a[ba>>0]=d[31336+na>>0]|vb;Jb=(Jb- +(na|0))*16.0;if((la-q|0)==1){a[la>>0]=46;Ob=ba+2|0}else{Ob=la}if(!(Jb!=0.0)){Lb=Ob;break}else{ba=Ob}}}}ba=Lb;do{if((Aa|0)==0){R=174}else{if((D+ba|0)>=(Aa|0)){R=174;break}Pb=E+Aa-Bb|0}}while(0);if((R|0)==174){R=0;Pb=C-Bb+ba|0}vb=Pb+zb|0;la=aa&73728;na=(vb|0)<(va|0);if((la|0)==0&na){Ab=va-vb|0;Om(s|0,32,(Ab>>>0>256?256:Ab)|0)|0;if(Ab>>>0>255){Hb=Ab;while(1){om(s,256,e)|0;Qb=Hb+ -256|0;if(Qb>>>0>255){Hb=Qb}else{Rb=Qb;break}}}else{Rb=Ab}om(s,Rb,e)|0}om(yb,zb,e)|0;if((la|0)==65536&na){Hb=va-vb|0;Om(s|0,48,(Hb>>>0>256?256:Hb)|0)|0;if(Hb>>>0>255){Qb=Hb;while(1){om(s,256,e)|0;Sb=Qb+ -256|0;if(Sb>>>0>255){Qb=Sb}else{Tb=Sb;break}}}else{Tb=Hb}om(s,Tb,e)|0}Qb=ba-q|0;om(p,Qb,e)|0;zb=r-Bb|0;yb=Pb-zb-Qb|0;if((yb|0)>0){Om(s|0,48,(yb>>>0>256?256:yb)|0)|0;if(yb>>>0>255){Qb=yb;while(1){om(s,256,e)|0;Ab=Qb+ -256|0;if(Ab>>>0>255){Qb=Ab}else{Ub=Ab;break}}}else{Ub=yb}om(s,Ub,e)|0}om(Bb,zb,e)|0;if((la|0)==8192&na){Qb=va-vb|0;Om(s|0,32,(Qb>>>0>256?256:Qb)|0)|0;if(Qb>>>0>255){ba=Qb;while(1){om(s,256,e)|0;Hb=ba+ -256|0;if(Hb>>>0>255){ba=Hb}else{Vb=Hb;break}}}else{Vb=Qb}om(s,Vb,e)|0}K=Ha;L=Ga;M=Ca;f=P;N=na?va:vb;O=ua;continue a}ba=(Aa|0)<0?6:Aa;if(ma){la=(c[o>>2]|0)+ -28|0;c[o>>2]=la;Wb=Ka*268435456.0;Xb=la}else{Wb=Ka;Xb=c[o>>2]|0}la=(Xb|0)<0?n:F;Jb=Wb;zb=la;do{Bb=~~Jb>>>0;c[zb>>2]=Bb;zb=zb+4|0;Jb=(Jb- +(Bb>>>0))*1.0e9}while(Jb!=0.0);ma=c[o>>2]|0;if((ma|0)>0){vb=ma;na=la;Qb=zb;while(1){Bb=(vb|0)>29?29:vb;yb=Qb+ -4|0;do{if(yb>>>0<na>>>0){Yb=na;Zb=(c[yb>>2]|0)==0&Qb>>>0>na>>>0?yb:Qb}else{Hb=0;Ab=yb;do{Sb=Qm(c[Ab>>2]|0,0,Bb|0)|0;_b=Im(Sb|0,H|0,Hb|0,0)|0;Sb=H;$b=_m(_b|0,Sb|0,1e9,0)|0;c[Ab>>2]=$b;Hb=Zm(_b|0,Sb|0,1e9,0)|0;Ab=Ab+ -4|0}while(!(Ab>>>0<na>>>0));Ab=(c[yb>>2]|0)==0&Qb>>>0>na>>>0?yb:Qb;if((Hb|0)==0){Yb=na;Zb=Ab;break}Sb=na+ -4|0;c[Sb>>2]=Hb;Yb=Sb;Zb=Ab}}while(0);yb=(c[o>>2]|0)-Bb|0;c[o>>2]=yb;if((yb|0)>0){vb=yb;na=Yb;Qb=Zb}else{ac=yb;bc=Yb;cc=Zb;break}}}else{ac=ma;bc=la;cc=zb}h:do{if((ac|0)<0){Qb=((ba|0)/9|0)+2|0;if(($|0)==102){na=la;vb=la+(Qb<<2)|0;yb=ac;Ab=bc;Sb=cc;while(1){_b=0-yb|0;$b=(_b|0)>9?9:_b;do{if(Ab>>>0<Sb>>>0){_b=(1<<$b)+ -1|0;dc=1e9>>>$b;ec=0;fc=Ab;do{gc=c[fc>>2]|0;c[fc>>2]=(gc>>>$b)+ec;ec=da(gc&_b,dc)|0;fc=fc+4|0}while(fc>>>0<Sb>>>0);fc=(c[Ab>>2]|0)==0?Ab+4|0:Ab;if((ec|0)==0){hc=fc;ic=Sb;break}c[Sb>>2]=ec;hc=fc;ic=Sb+4|0}else{hc=(c[Ab>>2]|0)==0?Ab+4|0:Ab;ic=Sb}}while(0);Hb=(ic-na>>2|0)>(Qb|0)?vb:ic;yb=(c[o>>2]|0)+$b|0;c[o>>2]=yb;if((yb|0)>=0){jc=hc;kc=Hb;break h}else{Ab=hc;Sb=Hb}}}else{lc=ac;mc=bc;nc=cc}while(1){Sb=0-lc|0;Ab=(Sb|0)>9?9:Sb;do{if(mc>>>0<nc>>>0){Sb=(1<<Ab)+ -1|0;yb=1e9>>>Ab;vb=0;na=mc;do{Bb=c[na>>2]|0;c[na>>2]=(Bb>>>Ab)+vb;vb=da(Bb&Sb,yb)|0;na=na+4|0}while(na>>>0<nc>>>0);na=(c[mc>>2]|0)==0?mc+4|0:mc;if((vb|0)==0){oc=na;pc=nc;break}c[nc>>2]=vb;oc=na;pc=nc+4|0}else{oc=(c[mc>>2]|0)==0?mc+4|0:mc;pc=nc}}while(0);if((pc-oc>>2|0)>(Qb|0)){qc=oc+(Qb<<2)|0}else{qc=pc}lc=(c[o>>2]|0)+Ab|0;c[o>>2]=lc;if((lc|0)>=0){jc=oc;kc=qc;break}else{mc=oc;nc=qc}}}else{jc=bc;kc=cc}}while(0);zb=la;do{if(jc>>>0<kc>>>0){ma=(zb-jc>>2)*9|0;Qb=c[jc>>2]|0;if(Qb>>>0<10){rc=ma;break}else{sc=ma;tc=10}while(1){tc=tc*10|0;ma=sc+1|0;if(Qb>>>0<tc>>>0){rc=ma;break}else{sc=ma}}}else{rc=0}}while(0);Qb=($|0)==103;ma=ba-(($|0)!=102?rc:0)+((Qb&(ba|0)!=0)<<31>>31)|0;if((ma|0)<(((kc-zb>>2)*9|0)+ -9|0)){$b=ma+9216|0;ma=($b|0)/9|0;na=la+(ma+ -1023<<2)|0;yb=(($b|0)%9|0)+1|0;if((yb|0)<9){$b=10;Sb=yb;while(1){yb=$b*10|0;Sb=Sb+1|0;if((Sb|0)==9){uc=yb;break}else{$b=yb}}}else{uc=10}$b=c[na>>2]|0;Sb=($b>>>0)%(uc>>>0)|0;if((Sb|0)==0?(la+(ma+ -1022<<2)|0)==(kc|0):0){vc=jc;wc=na;xc=rc}else{R=232}do{if((R|0)==232){R=0;Cb=((($b>>>0)/(uc>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;$=(uc|0)/2|0;do{if(Sb>>>0<$>>>0){yc=.5}else{if((Sb|0)==($|0)?(la+(ma+ -1022<<2)|0)==(kc|0):0){yc=1.0;break}yc=1.5}}while(0);do{if((rb|0)==0){zc=Cb;Ac=yc}else{if((a[sb>>0]|0)!=45){zc=Cb;Ac=yc;break}zc=Cb*-1.0;Ac=yc*-1.0}}while(0);$=$b-Sb|0;c[na>>2]=$;if(!(zc+Ac!=zc)){vc=jc;wc=na;xc=rc;break}yb=$+uc|0;c[na>>2]=yb;if(yb>>>0>999999999){yb=na;while(1){$=yb+ -4|0;c[yb>>2]=0;ec=(c[$>>2]|0)+1|0;c[$>>2]=ec;if(ec>>>0>999999999){yb=$}else{Bc=$;break}}}else{Bc=na}yb=Bc>>>0<jc>>>0?Bc:jc;$=(zb-yb>>2)*9|0;ec=c[yb>>2]|0;if(ec>>>0<10){vc=yb;wc=Bc;xc=$;break}else{Cc=$;Dc=10}while(1){Dc=Dc*10|0;$=Cc+1|0;if(ec>>>0<Dc>>>0){vc=yb;wc=Bc;xc=$;break}else{Cc=$}}}}while(0);na=wc+4|0;Sb=kc>>>0>na>>>0?na:kc;while(1){na=Sb+ -4|0;if((c[na>>2]|0)==0&Sb>>>0>vc>>>0){Sb=na}else{Ec=vc;Fc=xc;Gc=Sb;break}}}else{Ec=jc;Fc=rc;Gc=kc}Sb=0-Fc|0;do{if(Qb){na=((ba|0)==0&1)+ba|0;if((na|0)>(Fc|0)&(Fc|0)>-5){Hc=Na+ -1|0;Ic=na+ -1-Fc|0}else{Hc=Na+ -2|0;Ic=na+ -1|0}if((aa&8|0)!=0){Jc=Hc;Kc=Ic;break}do{if(Gc>>>0>Ec>>>0){na=c[Gc+ -4>>2]|0;if((na|0)==0){Lc=9;break}if(((na>>>0)%10|0|0)==0){Mc=10;Nc=0}else{Lc=0;break}while(1){Mc=Mc*10|0;$b=Nc+1|0;if(((na>>>0)%(Mc>>>0)|0|0)!=0){Lc=$b;break}else{Nc=$b}}}else{Lc=9}}while(0);na=((Gc-zb>>2)*9|0)+ -9|0;if((Hc|32|0)==102){Ab=na-Lc|0;$b=(Ab|0)<0?0:Ab;Jc=Hc;Kc=(Ic|0)<($b|0)?Ic:$b;break}else{$b=na+Fc-Lc|0;na=($b|0)<0?0:$b;Jc=Hc;Kc=(Ic|0)<(na|0)?Ic:na;break}}else{Jc=Na;Kc=ba}}while(0);ba=(Kc|0)!=0;if(ba){Oc=1}else{Oc=(aa&8|0)!=0}zb=Oc&1;Qb=(Jc|32|0)==102;if(Qb){Pc=(Fc|0)>0?Fc:0;Qc=0}else{na=(Fc|0)<0?Sb:Fc;if((na|0)<0){$b=A;Ab=na;ma=((na|0)<0)<<31>>31;while(1){yb=_m(Ab|0,ma|0,10,0)|0;$b=$b+ -1|0;a[$b>>0]=yb|48;yb=Ab;Ab=Zm(Ab|0,ma|0,10,0)|0;if(!(ma>>>0>9|(ma|0)==9&yb>>>0>4294967295)){break}else{ma=H}}Rc=$b;Sc=Ab}else{Rc=A;Sc=na}if((Sc|0)==0){Tc=Rc}else{ma=Rc;Sb=Sc;while(1){yb=ma+ -1|0;a[yb>>0]=(Sb>>>0)%10|0|48;if(Sb>>>0<10){Tc=yb;break}else{ma=yb;Sb=(Sb>>>0)/10|0}}}if((r-Tc|0)<2){Sb=Tc;while(1){ma=Sb+ -1|0;a[ma>>0]=48;if((r-ma|0)<2){Sb=ma}else{Uc=ma;break}}}else{Uc=Tc}a[Uc+ -1>>0]=(Fc>>31&2)+43;Sb=Uc+ -2|0;a[Sb>>0]=Jc;Pc=r-Sb|0;Qc=Sb}Sb=rb+1+Kc+zb+Pc|0;ma=aa&73728;na=(Sb|0)<(va|0);if((ma|0)==0&na){Ab=va-Sb|0;Om(s|0,32,(Ab>>>0>256?256:Ab)|0)|0;if(Ab>>>0>255){$b=Ab;while(1){om(s,256,e)|0;yb=$b+ -256|0;if(yb>>>0>255){$b=yb}else{Vc=yb;break}}}else{Vc=Ab}om(s,Vc,e)|0}om(sb,rb,e)|0;if((ma|0)==65536&na){$b=va-Sb|0;Om(s|0,48,($b>>>0>256?256:$b)|0)|0;if($b>>>0>255){zb=$b;while(1){om(s,256,e)|0;yb=zb+ -256|0;if(yb>>>0>255){zb=yb}else{Wc=yb;break}}}else{Wc=$b}om(s,Wc,e)|0}do{if(Qb){zb=Ec>>>0>la>>>0?la:Ec;Ab=zb;do{yb=c[Ab>>2]|0;if((yb|0)==0){Xc=G}else{ec=G;$=yb;while(1){yb=ec+ -1|0;a[yb>>0]=($>>>0)%10|0|48;if($>>>0<10){Xc=yb;break}else{ec=yb;$=($>>>0)/10|0}}}do{if((Ab|0)==(zb|0)){if((Xc|0)!=(G|0)){Yc=Xc;break}a[J>>0]=48;Yc=J}else{if(Xc>>>0>p>>>0){Zc=Xc}else{Yc=Xc;break}while(1){$=Zc+ -1|0;a[$>>0]=48;if($>>>0>p>>>0){Zc=$}else{Yc=$;break}}}}while(0);om(Yc,I-Yc|0,e)|0;Ab=Ab+4|0}while(!(Ab>>>0>la>>>0));if(!ba?(aa&8|0)==0:0){break}om(31352,1,e)|0;if(Ab>>>0<Gc>>>0&(Kc|0)>0){zb=Kc;vb=Ab;while(1){$=c[vb>>2]|0;if(($|0)!=0){ec=G;yb=$;while(1){ec=ec+ -1|0;a[ec>>0]=(yb>>>0)%10|0|48;if(yb>>>0<10){break}else{yb=(yb>>>0)/10|0}}if(ec>>>0>p>>>0){_c=ec;R=295}else{ad=ec}}else{_c=G;R=295}if((R|0)==295){while(1){R=0;yb=_c+ -1|0;a[yb>>0]=48;if(yb>>>0>p>>>0){_c=yb;R=295}else{ad=yb;break}}}om(ad,(zb|0)>9?9:zb,e)|0;vb=vb+4|0;ec=zb+ -9|0;if(!(vb>>>0<Gc>>>0&(ec|0)>0)){bd=ec;break}else{zb=ec}}}else{bd=Kc}if((bd|0)<=0){break}Om(s|0,48,(bd>>>0>256?256:bd)|0)|0;if(bd>>>0>255){zb=bd;while(1){om(s,256,e)|0;vb=zb+ -256|0;if(vb>>>0>255){zb=vb}else{cd=vb;break}}}else{cd=bd}om(s,cd,e)|0}else{zb=Gc>>>0>Ec>>>0?Gc:Ec+4|0;do{if((Kc|0)>-1){vb=(aa&8|0)!=0;Ab=Kc;ec=Ec;do{yb=c[ec>>2]|0;if((yb|0)!=0){$=G;Bb=yb;while(1){$=$+ -1|0;a[$>>0]=(Bb>>>0)%10|0|48;if(Bb>>>0<10){break}else{Bb=(Bb>>>0)/10|0}}if(($|0)!=(G|0)){dd=$}else{R=306}}else{R=306}if((R|0)==306){R=0;a[J>>0]=48;dd=J}do{if((ec|0)==(Ec|0)){Bb=dd+1|0;om(dd,1,e)|0;if(!((Ab|0)>0|vb)){ed=Bb;break}om(31352,1,e)|0;ed=Bb}else{if(dd>>>0>p>>>0){fd=dd}else{ed=dd;break}while(1){Bb=fd+ -1|0;a[Bb>>0]=48;if(Bb>>>0>p>>>0){fd=Bb}else{ed=Bb;break}}}}while(0);$=I-ed|0;om(ed,($|0)<(Ab|0)?$:Ab,e)|0;Ab=Ab-$|0;ec=ec+4|0}while(ec>>>0<zb>>>0&(Ab|0)>-1);if((Ab|0)<=0){break}Om(s|0,48,(Ab>>>0>256?256:Ab)|0)|0;if(Ab>>>0>255){ec=Ab;while(1){om(s,256,e)|0;vb=ec+ -256|0;if(vb>>>0>255){ec=vb}else{gd=vb;break}}}else{gd=Ab}om(s,gd,e)|0}}while(0);om(Qc,r-Qc|0,e)|0}}while(0);if((ma|0)==8192&na){ba=va-Sb|0;Om(s|0,32,(ba>>>0>256?256:ba)|0)|0;if(ba>>>0>255){la=ba;while(1){om(s,256,e)|0;Qb=la+ -256|0;if(Qb>>>0>255){la=Qb}else{hd=Qb;break}}}else{hd=ba}om(s,hd,e)|0}K=Ha;L=Ga;M=Ca;f=P;N=na?va:Sb;O=ua;continue a;break};default:{bb=Ha;cb=Ga;db=M;eb=aa;fb=Aa;gb=0;hb=31256;ib=x}}}while(0);i:do{if((R|0)==78){R=0;Q=Ga;Y=Qa&32;if(!((Q|0)==0&(Ha|0)==0)){la=x;ma=Q;Q=Ha;do{la=la+ -1|0;a[la>>0]=d[31336+(ma&15)>>0]|Y;ma=Lm(ma|0,Q|0,4)|0;Q=H}while(!((ma|0)==0&(Q|0)==0));if((Oa&8|0)==0){Sa=Ga;Ta=Ha;Ua=la;Va=Oa;Wa=Pa;Xa=0;Ya=31256;R=95}else{Sa=Ga;Ta=Ha;Ua=la;Va=Oa;Wa=Pa;Xa=2;Ya=31256+(Qa>>4)|0;R=95}}else{Sa=Ga;Ta=Ha;Ua=x;Va=Oa;Wa=Pa;Xa=0;Ya=31256;R=95}}else if((R|0)==90){R=0;Q=Za;if(_a>>>0>0|(_a|0)==0&Q>>>0>4294967295){ma=x;Y=Q;Sb=_a;while(1){na=_m(Y|0,Sb|0,10,0)|0;ma=ma+ -1|0;a[ma>>0]=na|48;na=Y;Y=Zm(Y|0,Sb|0,10,0)|0;if(!(Sb>>>0>9|(Sb|0)==9&na>>>0>4294967295)){break}else{Sb=H}}id=ma;jd=Y}else{id=x;jd=Q}if((jd|0)==0){Sa=Za;Ta=_a;Ua=id;Va=aa;Wa=Aa;Xa=$a;Ya=ab;R=95}else{Sb=id;la=jd;while(1){na=Sb+ -1|0;a[na>>0]=(la>>>0)%10|0|48;if(la>>>0<10){Sa=Za;Ta=_a;Ua=na;Va=aa;Wa=Aa;Xa=$a;Ya=ab;R=95;break}else{Sb=na;la=(la>>>0)/10|0}}}}else if((R|0)==100){R=0;la=Am(mb,0,Aa)|0;if((la|0)==0){bb=Ha;cb=Ga;db=mb;eb=ha;fb=Aa;gb=0;hb=31256;ib=mb+Aa|0;break}else{bb=Ha;cb=Ga;db=mb;eb=ha;fb=la-mb|0;gb=0;hb=31256;ib=la;break}}else if((R|0)==105){R=0;la=0;Sb=0;Q=jb;while(1){Y=c[Q>>2]|0;if((Y|0)==0){kd=la;ld=Sb;break}ma=jm(v,Y)|0;if(!((ma|0)>-1)){ra=-1;R=357;break a}Y=ma+la|0;if(ma>>>0>(lb-la|0)>>>0){nb=jb;ob=kb;pb=la;R=111;break i}if(Y>>>0<lb>>>0){la=Y;Sb=ma;Q=Q+4|0}else{kd=Y;ld=ma;break}}if((ld|0)<0){ra=-1;R=357;break a}else{nb=jb;ob=kb;pb=kd;R=111}}}while(0);if((R|0)==95){R=0;ha=(Wa|0)>-1?Va&-65537:Va;Q=(Sa|0)==0&(Ta|0)==0;if(Q&(Wa|0)==0){bb=Ta;cb=Sa;db=x;eb=ha;fb=0;gb=Xa;hb=Ya;ib=x}else{Sb=(Q&1)+(y-Ua)|0;bb=Ta;cb=Sa;db=Ua;eb=ha;fb=(Wa|0)>(Sb|0)?Wa:Sb;gb=Xa;hb=Ya;ib=x}}else if((R|0)==111){R=0;Sb=aa&73728;ha=(pb|0)<(va|0);if((Sb|0)==0&ha){Q=va-pb|0;Om(s|0,32,(Q>>>0>256?256:Q)|0)|0;if(Q>>>0>255){la=Q;while(1){om(s,256,e)|0;ma=la+ -256|0;if(ma>>>0>255){la=ma}else{md=ma;break}}}else{md=Q}om(s,md,e)|0}j:do{if((pb|0)!=0){la=0;aa=nb;while(1){ma=c[aa>>2]|0;if((ma|0)==0){break j}Y=jm(v,ma)|0;la=Y+la|0;if((la|0)>(pb|0)){break j}om(v,Y,e)|0;if(!(la>>>0<pb>>>0)){break}else{aa=aa+4|0}}}}while(0);if((Sb|0)==8192&ha){Q=va-pb|0;Om(s|0,32,(Q>>>0>256?256:Q)|0)|0;if(Q>>>0>255){aa=Q;while(1){om(s,256,e)|0;la=aa+ -256|0;if(la>>>0>255){aa=la}else{nd=la;break}}}else{nd=Q}om(s,nd,e)|0}K=Ha;L=ob;M=Ca;f=P;N=ha?va:pb;O=ua;continue}aa=ib-db|0;Sb=(fb|0)<(aa|0)?aa:fb;la=gb+Sb|0;Y=(va|0)<(la|0)?la:va;ma=eb&73728;na=(la|0)<(Y|0);if((ma|0)==0&na){ba=Y-la|0;Om(s|0,32,(ba>>>0>256?256:ba)|0)|0;if(ba>>>0>255){Qb=ba;while(1){om(s,256,e)|0;$b=Qb+ -256|0;if($b>>>0>255){Qb=$b}else{od=$b;break}}}else{od=ba}om(s,od,e)|0}om(hb,gb,e)|0;if((ma|0)==65536&na){Qb=Y-la|0;Om(s|0,48,(Qb>>>0>256?256:Qb)|0)|0;if(Qb>>>0>255){ha=Qb;while(1){om(s,256,e)|0;Q=ha+ -256|0;if(Q>>>0>255){ha=Q}else{pd=Q;break}}}else{pd=Qb}om(s,pd,e)|0}if((aa|0)<(Sb|0)){ha=Sb-aa|0;Om(s|0,48,(ha>>>0>256?256:ha)|0)|0;if(ha>>>0>255){ba=ha;while(1){om(s,256,e)|0;Q=ba+ -256|0;if(Q>>>0>255){ba=Q}else{rd=Q;break}}}else{rd=ha}om(s,rd,e)|0}om(db,aa,e)|0;if(!((ma|0)==8192&na)){K=bb;L=cb;M=Ca;f=P;N=Y;O=ua;continue}ba=Y-la|0;Om(s|0,32,(ba>>>0>256?256:ba)|0)|0;if(ba>>>0>255){Sb=ba;while(1){om(s,256,e)|0;Qb=Sb+ -256|0;if(Qb>>>0>255){Sb=Qb}else{sd=Qb;break}}}else{sd=ba}om(s,sd,e)|0;K=bb;L=cb;M=Ca;f=P;N=Y;O=ua}if((R|0)==339){if((e|0)!=0){ra=P;i=m;return ra|0}if((O|0)==0){ra=0;i=m;return ra|0}else{td=1}while(1){O=c[l+(td<<2)>>2]|0;if((O|0)==0){ud=td;break}P=j+(td<<3)|0;k:do{if(!(O>>>0>20)){do{switch(O|0){case 16:{e=c[g>>2]|0;ua=c[e>>2]|0;c[g>>2]=e+4;e=P;c[e>>2]=ua&255;c[e+4>>2]=0;break k;break};case 9:{e=c[g>>2]|0;ua=c[e>>2]|0;c[g>>2]=e+4;c[P>>2]=ua;break k;break};case 10:{ua=c[g>>2]|0;e=c[ua>>2]|0;c[g>>2]=ua+4;ua=P;c[ua>>2]=e;c[ua+4>>2]=((e|0)<0)<<31>>31;break k;break};case 11:{e=c[g>>2]|0;ua=c[e>>2]|0;c[g>>2]=e+4;e=P;c[e>>2]=ua;c[e+4>>2]=0;break k;break};case 14:{e=c[g>>2]|0;ua=c[e>>2]|0;c[g>>2]=e+4;e=P;c[e>>2]=ua&65535;c[e+4>>2]=0;break k;break};case 17:{e=c[g>>2]|0;c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];zc=+h[k>>3];c[g>>2]=e+8;h[P>>3]=zc;break k;break};case 13:{e=c[g>>2]|0;ua=c[e>>2]|0;c[g>>2]=e+4;e=(ua&65535)<<16>>16;ua=P;c[ua>>2]=e;c[ua+4>>2]=((e|0)<0)<<31>>31;break k;break};case 18:{e=c[g>>2]|0;c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];zc=+h[k>>3];c[g>>2]=e+8;h[P>>3]=zc;break k;break};case 12:{e=c[g>>2]|0;ua=e;N=c[ua>>2]|0;f=c[ua+4>>2]|0;c[g>>2]=e+8;e=P;c[e>>2]=N;c[e+4>>2]=f;break k;break};case 15:{f=c[g>>2]|0;e=c[f>>2]|0;c[g>>2]=f+4;f=(e&255)<<24>>24;e=P;c[e>>2]=f;c[e+4>>2]=((f|0)<0)<<31>>31;break k;break};default:{break k}}}while(0)}}while(0);td=td+1|0;if((td|0)>=10){ra=1;R=357;break}}if((R|0)==357){i=m;return ra|0}while(1){if((c[l+(ud<<2)>>2]|0)!=0){ra=-1;R=357;break}ud=ud+1|0;if((ud|0)>=10){ra=1;R=357;break}}if((R|0)==357){i=m;return ra|0}}else if((R|0)==357){i=m;return ra|0}return 0}function tm(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=i;i=i+128|0;h=g+112|0;j=g;k=j+0|0;l=31360|0;m=k+112|0;do{c[k>>2]=c[l>>2];k=k+4|0;l=l+4|0}while((k|0)<(m|0));if((d+ -1|0)>>>0>2147483646){if((d|0)==0){n=h;o=1}else{c[(qd()|0)>>2]=75;p=-1;i=g;return p|0}}else{n=b;o=d}d=-2-n|0;b=o>>>0>d>>>0?d:o;c[j+48>>2]=b;o=j+20|0;c[o>>2]=n;c[j+44>>2]=n;d=n+b|0;n=j+16|0;c[n>>2]=d;c[j+28>>2]=d;d=rm(j,e,f)|0;if((b|0)==0){p=d;i=g;return p|0}b=c[o>>2]|0;a[b+(((b|0)==(c[n>>2]|0))<<31>>31)>>0]=0;p=d;i=g;return p|0}function um(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;f=a+20|0;g=c[f>>2]|0;h=(c[a+16>>2]|0)-g|0;a=h>>>0>d>>>0?d:h;Mm(g|0,b|0,a|0)|0;c[f>>2]=(c[f>>2]|0)+a;i=e;return d|0}function vm(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=i;e=tm(a,2147483647,b,c)|0;i=d;return e|0}function wm(a){a=a|0;var b=0,c=0.0;b=i;c=+ym(a,0);i=b;return+c}function xm(b){b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;c=i;d=b;while(1){e=d+1|0;if((Zl(a[d>>0]|0)|0)==0){break}else{d=e}}b=a[d>>0]|0;f=b<<24>>24;if((f|0)==43){g=0;h=5}else if((f|0)==45){g=1;h=5}else{j=d;k=b;l=0}if((h|0)==5){j=e;k=a[e>>0]|0;l=g}if((Yl(k<<24>>24)|0)==0){m=0;n=(l|0)!=0;o=0-m|0;p=n?m:o;i=c;return p|0}else{q=j;r=0}while(1){j=(r*10|0)+48-(a[q>>0]|0)|0;q=q+1|0;if((Yl(a[q>>0]|0)|0)==0){m=j;break}else{r=j}}n=(l|0)!=0;o=0-m|0;p=n?m:o;i=c;return p|0}function ym(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0.0,j=0,k=0;d=i;i=i+112|0;e=d;f=e+0|0;g=f+112|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));f=e+4|0;c[f>>2]=a;g=e+8|0;c[g>>2]=-1;c[e+44>>2]=a;c[e+76>>2]=-1;dm(e,0);h=+bm(e,1,1);j=(c[f>>2]|0)-(c[g>>2]|0)+(c[e+108>>2]|0)|0;if((b|0)==0){i=d;return+h}if((j|0)==0){k=a}else{k=a+j|0}c[b>>2]=k;i=d;return+h}function zm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+112|0;f=e;c[f>>2]=0;g=f+4|0;c[g>>2]=a;c[f+44>>2]=a;if((a|0)<0){c[f+8>>2]=-1}else{c[f+8>>2]=a+2147483647}c[f+76>>2]=-1;dm(f,0);h=am(f,d,1,-2147483648,0)|0;if((b|0)==0){i=e;return h|0}c[b>>2]=a+((c[g>>2]|0)+(c[f+108>>2]|0)-(c[f+8>>2]|0));i=e;return h|0}function Am(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;f=i;g=d&255;h=(e|0)==0;a:do{if((b&3|0)==0|h){j=e;k=h;l=b;m=5}else{n=d&255;o=e;p=b;while(1){if((a[p>>0]|0)==n<<24>>24){q=o;r=p;m=6;break a}s=p+1|0;t=o+ -1|0;u=(t|0)==0;if((s&3|0)==0|u){j=t;k=u;l=s;m=5;break}else{o=t;p=s}}}}while(0);if((m|0)==5){if(k){v=0;w=l}else{q=j;r=l;m=6}}b:do{if((m|0)==6){l=d&255;if(!((a[r>>0]|0)==l<<24>>24)){j=da(g,16843009)|0;c:do{if(q>>>0>3){k=q;b=r;while(1){e=c[b>>2]^j;if(((e&-2139062144^-2139062144)&e+ -16843009|0)!=0){x=k;y=b;break c}e=b+4|0;h=k+ -4|0;if(h>>>0>3){k=h;b=e}else{x=h;y=e;break}}}else{x=q;y=r}}while(0);if((x|0)==0){v=0;w=y}else{j=x;b=y;while(1){if((a[b>>0]|0)==l<<24>>24){v=j;w=b;break b}k=b+1|0;j=j+ -1|0;if((j|0)==0){v=0;w=k;break}else{b=k}}}}else{v=q;w=r}}}while(0);i=f;return((v|0)!=0?w:0)|0}function Bm(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;a:do{if((d|0)==0){f=0}else{g=d;h=b;j=c;while(1){k=a[h>>0]|0;l=a[j>>0]|0;if(!(k<<24>>24==l<<24>>24)){break}g=g+ -1|0;if((g|0)==0){f=0;break a}else{h=h+1|0;j=j+1|0}}f=(k&255)-(l&255)|0}}while(0);i=e;return f|0}function Cm(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;e=a[b>>0]|0;f=a[c>>0]|0;if((e<<24>>24==0?1:e<<24>>24!=f<<24>>24)|f<<24>>24==0){g=e;h=f;j=g&255;k=h&255;l=j-k|0;i=d;return l|0}else{m=b;n=c}do{m=m+1|0;n=n+1|0;c=a[m>>0]|0;b=a[n>>0]|0}while(!((c<<24>>24==0?1:c<<24>>24!=b<<24>>24)|b<<24>>24==0));g=c;h=b;j=g&255;k=h&255;l=j-k|0;i=d;return l|0}function Dm(b,c,e){b=b|0;c=c|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;if((e|0)==0){g=0;i=f;return g|0}h=a[b>>0]|0;a:do{if(h<<24>>24==0){j=0;k=c}else{l=e;m=h;n=b;o=c;while(1){l=l+ -1|0;p=a[o>>0]|0;if(!((l|0)!=0&p<<24>>24!=0&m<<24>>24==p<<24>>24)){j=m;k=o;break a}n=n+1|0;p=o+1|0;m=a[n>>0]|0;if(m<<24>>24==0){j=0;k=p;break}else{o=p}}}}while(0);g=(j&255)-(d[k>>0]|0)|0;i=f;return g|0}function Em(){c[7610]=p}function Fm(a){a=a|0;var b=0;b=(da(c[a>>2]|0,31010991)|0)+1735287159&2147483647;c[a>>2]=b;return b|0}function Gm(){return Fm(o)|0}function Hm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=b-d>>>0;e=b-d-(c>>>0>a>>>0|0)>>>0;return(H=e,a-c>>>0|0)|0}function Im(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+c>>>0;return(H=b+d+(e>>>0<a>>>0|0)>>>0,e|0)|0}function Jm(b){b=b|0;var c=0;c=b;while(a[c>>0]|0){c=c+1|0}return c-b|0}function Km(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0;while((e|0)<(d|0)){a[b+e>>0]=f?0:a[c+e>>0]|0;f=f?1:(a[c+e>>0]|0)==0;e=e+1|0}return b|0}function Lm(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){H=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}H=0;return b>>>c-32|0}function Mm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)>=4096)return od(b|0,d|0,e|0)|0;f=b|0;if((b&3)==(d&3)){while(b&3){if((e|0)==0)return f|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function Nm(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else{Mm(b,c,d)|0}return b|0}function Om(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=b+e|0;if((e|0)>=20){d=d&255;g=b&3;h=d|d<<8|d<<16|d<<24;i=f&~3;if(g){g=b+4-g|0;while((b|0)<(g|0)){a[b>>0]=d;b=b+1|0}}while((b|0)<(i|0)){c[b>>2]=h;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return b-e|0}function Pm(b,c){b=b|0;c=c|0;var d=0,e=0;d=b+(Jm(b)|0)|0;do{a[d+e>>0]=a[c+e>>0];e=e+1|0}while(a[c+(e-1)>>0]|0);return b|0}function Qm(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){H=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}H=a<<c-32;return 0}function Rm(b,c){b=b|0;c=c|0;var d=0;do{a[b+d>>0]=a[c+d>>0];d=d+1|0}while(a[c+(d-1)>>0]|0);return b|0}function Sm(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){H=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}H=(b|0)<0?-1:0;return b>>c-32|0}function Tm(b){b=b|0;var c=0;c=a[n+(b>>>24)>>0]|0;if((c|0)<8)return c|0;c=a[n+(b>>16&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[n+(b>>8&255)>>0]|0;if((c|0)<8)return c+16|0;return(a[n+(b&255)>>0]|0)+24|0}function Um(b){b=b|0;var c=0;c=a[m+(b&255)>>0]|0;if((c|0)<8)return c|0;c=a[m+(b>>8&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[m+(b>>16&255)>>0]|0;if((c|0)<8)return c+16|0;return(a[m+(b>>>24)>>0]|0)+24|0}function Vm(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;c=a&65535;d=b&65535;e=da(d,c)|0;f=a>>>16;a=(e>>>16)+(da(d,f)|0)|0;d=b>>>16;b=da(d,c)|0;return(H=(a>>>16)+(da(d,f)|0)+(((a&65535)+b|0)>>>16)|0,a+b<<16|e&65535|0)|0}function Wm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=b>>31|((b|0)<0?-1:0)<<1;f=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;g=d>>31|((d|0)<0?-1:0)<<1;h=((d|0)<0?-1:0)>>31|((d|0)<0?-1:0)<<1;i=Hm(e^a,f^b,e,f)|0;b=H;a=g^e;e=h^f;f=Hm(($m(i,b,Hm(g^c,h^d,g,h)|0,H,0)|0)^a,H^e,a,e)|0;return f|0}function Xm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+8|0;g=f|0;h=b>>31|((b|0)<0?-1:0)<<1;j=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;k=e>>31|((e|0)<0?-1:0)<<1;l=((e|0)<0?-1:0)>>31|((e|0)<0?-1:0)<<1;m=Hm(h^a,j^b,h,j)|0;b=H;$m(m,b,Hm(k^d,l^e,k,l)|0,H,g)|0;l=Hm(c[g>>2]^h,c[g+4>>2]^j,h,j)|0;j=H;i=f;return(H=j,l)|0}function Ym(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=a;a=c;c=Vm(e,a)|0;f=H;return(H=(da(b,a)|0)+(da(d,e)|0)+f|f&0,c|0|0)|0}function Zm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=$m(a,b,c,d,0)|0;return e|0}function _m(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+8|0;g=f|0;$m(a,b,d,e,g)|0;i=f;return(H=c[g+4>>2]|0,c[g>>2]|0)|0}function $m(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;g=a;h=b;i=h;j=d;k=e;l=k;if((i|0)==0){m=(f|0)!=0;if((l|0)==0){if(m){c[f>>2]=(g>>>0)%(j>>>0);c[f+4>>2]=0}n=0;o=(g>>>0)/(j>>>0)>>>0;return(H=n,o)|0}else{if(!m){n=0;o=0;return(H=n,o)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;n=0;o=0;return(H=n,o)|0}}m=(l|0)==0;do{if((j|0)!=0){if(!m){p=(Tm(l|0)|0)-(Tm(i|0)|0)|0;if(p>>>0<=31){q=p+1|0;r=31-p|0;s=p-31>>31;t=q;u=g>>>(q>>>0)&s|i<<r;v=i>>>(q>>>0)&s;w=0;x=g<<r;break}if((f|0)==0){n=0;o=0;return(H=n,o)|0}c[f>>2]=a|0;c[f+4>>2]=h|b&0;n=0;o=0;return(H=n,o)|0}r=j-1|0;if((r&j|0)!=0){s=(Tm(j|0)|0)+33-(Tm(i|0)|0)|0;q=64-s|0;p=32-s|0;y=p>>31;z=s-32|0;A=z>>31;t=s;u=p-1>>31&i>>>(z>>>0)|(i<<p|g>>>(s>>>0))&A;v=A&i>>>(s>>>0);w=g<<q&y;x=(i<<q|g>>>(z>>>0))&y|g<<p&s-33>>31;break}if((f|0)!=0){c[f>>2]=r&g;c[f+4>>2]=0}if((j|0)==1){n=h|b&0;o=a|0|0;return(H=n,o)|0}else{r=Um(j|0)|0;n=i>>>(r>>>0)|0;o=i<<32-r|g>>>(r>>>0)|0;return(H=n,o)|0}}else{if(m){if((f|0)!=0){c[f>>2]=(i>>>0)%(j>>>0);c[f+4>>2]=0}n=0;o=(i>>>0)/(j>>>0)>>>0;return(H=n,o)|0}if((g|0)==0){if((f|0)!=0){c[f>>2]=0;c[f+4>>2]=(i>>>0)%(l>>>0)}n=0;o=(i>>>0)/(l>>>0)>>>0;return(H=n,o)|0}r=l-1|0;if((r&l|0)==0){if((f|0)!=0){c[f>>2]=a|0;c[f+4>>2]=r&i|b&0}n=0;o=i>>>((Um(l|0)|0)>>>0);return(H=n,o)|0}r=(Tm(l|0)|0)-(Tm(i|0)|0)|0;if(r>>>0<=30){s=r+1|0;p=31-r|0;t=s;u=i<<p|g>>>(s>>>0);v=i>>>(s>>>0);w=0;x=g<<p;break}if((f|0)==0){n=0;o=0;return(H=n,o)|0}c[f>>2]=a|0;c[f+4>>2]=h|b&0;n=0;o=0;return(H=n,o)|0}}while(0);if((t|0)==0){B=x;C=w;D=v;E=u;F=0;G=0}else{b=d|0|0;d=k|e&0;e=Im(b,d,-1,-1)|0;k=H;h=x;x=w;w=v;v=u;u=t;t=0;do{a=h;h=x>>>31|h<<1;x=t|x<<1;g=v<<1|a>>>31|0;a=v>>>31|w<<1|0;Hm(e,k,g,a)|0;i=H;l=i>>31|((i|0)<0?-1:0)<<1;t=l&1;v=Hm(g,a,l&b,(((i|0)<0?-1:0)>>31|((i|0)<0?-1:0)<<1)&d)|0;w=H;u=u-1|0}while((u|0)!=0);B=h;C=x;D=w;E=v;F=0;G=t}t=C;C=0;if((f|0)!=0){c[f>>2]=E;c[f+4>>2]=D}n=(t|0)>>>31|(B|C)<<1|(C<<1|t>>>31)&0|F;o=(t<<1|0>>>31)&-2|G;return(H=n,o)|0}function an(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Fd[a&15](b|0,c|0,d|0)|0}function bn(a){a=a|0;return+Gd[a&1]()}function cn(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;Hd[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0)}function dn(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;Id[a&3](b|0,c|0,d|0,e|0,f|0)}function en(a){a=a|0;return Jd[a&15]()|0}function fn(a,b){a=a|0;b=b|0;Kd[a&31](b|0)}function gn(a,b){a=a|0;b=+b;return+Ld[a&1](+b)}function hn(a,b,c){a=a|0;b=b|0;c=c|0;Md[a&63](b|0,c|0)}function jn(a,b){a=a|0;b=b|0;return Nd[a&63](b|0)|0}function kn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;Od[a&15](b|0,c|0,d|0)}function ln(a){a=a|0;Pd[a&7]()}function mn(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Qd[a&3](b|0,c|0,d|0,e|0)|0}function nn(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Rd[a&3](b|0,c|0,d|0,e|0,f|0,g|0)}function on(a,b,c){a=a|0;b=b|0;c=c|0;return Sd[a&15](b|0,c|0)|0}function pn(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return Td[a&7](b|0,c|0,d|0,e|0,f|0)|0}function qn(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;Ud[a&3](b|0,c|0,d|0,e|0)}function rn(a,b,c){a=a|0;b=b|0;c=c|0;ea(0);return 0}function sn(){ea(1);return 0.0}function tn(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;ea(2)}function un(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ea(3)}function vn(){ea(4);return 0}function wn(a){a=a|0;ea(5)}function xn(a){a=+a;ea(6);return 0.0}function yn(a,b){a=a|0;b=b|0;ea(7)}function zn(a){a=a|0;ea(8);return 0}function An(a,b,c){a=a|0;b=b|0;c=c|0;ea(9)}function Bn(a,b,c){a=a|0;b=b|0;c=c|0;td(a|0,b|0,c|0)}function Cn(){ea(10)}function Dn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ea(11);return 0}function En(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ea(12)}function Fn(a,b){a=a|0;b=b|0;ea(13);return 0}function Gn(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ea(14);return 0}function Hn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ea(15)}



function mi(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;h=a+296|0;a=0;j=h;while(1){if((c[j>>2]|0)!=0?(c[j+12>>2]|0)==(b|0):0){k=j;break}a=a+1|0;if((a|0)>=16){l=0;m=h;n=5;break}else{j=j+16|0}}do{if((n|0)==5){while(1){n=0;if((c[m>>2]|0)==0){n=7;break}l=l+1|0;if((l|0)>=16){n=11;break}else{m=m+16|0;n=5}}if((n|0)==7){c[m+12>>2]=b;k=m;break}else if((n|0)==11){i=g;return}}}while(0);if(f){c[k>>2]=1;c[k+4>>2]=d;c[k+8>>2]=e;i=g;return}else{c[k>>2]=0;i=g;return}}function ni(a,b){a=a|0;b=b|0;var c=0;if(b>>>0>15){c=0}else{c=a+(b<<4)+296|0}return c|0}function oi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;e=a+292|0;c[e>>2]=0;f=0;g=b;b=0;h=a+296|0;while(1){if((c[h>>2]|0)==0){j=f;k=g}else{c[g>>2]=b;a=(c[e>>2]|0)+1|0;c[e>>2]=a;j=a;k=g+4|0}b=b+1|0;if((b|0)==16){break}else{f=j;g=k;h=h+16|0}}i=d;return j|0}function pi(a){a=a|0;c[976]=a;return}function qi(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;e=a+164|0;f=c[e>>2]|0;g=a+168|0;if((f|0)==0){c[e>>2]=0;c[g>>2]=0;h=a+172|0;c[h>>2]=128;i=d;return}j=c[g>>2]|0;if((j|0)>0){k=j;j=0;while(1){l=c[e>>2]|0;m=l+(j*52|0)|0;if((b[m>>1]|0)==0){n=k}else{o=c[l+(j*52|0)+48>>2]|0;if((o|0)!=0){Kd[o&31](m)}o=l+(j*52|0)+32|0;l=c[o>>2]|0;if((l|0)!=0){Oi(l);c[o>>2]=0}b[m>>1]=0;n=c[g>>2]|0}j=j+1|0;if((j|0)>=(n|0)){break}else{k=n}}p=c[e>>2]|0}else{p=f}Oi(p);c[e>>2]=0;c[g>>2]=0;h=a+172|0;c[h>>2]=128;i=d;return}function ri(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;e=i;if((d|0)<0){f=dc(4)|0;c[f>>2]=3;td(f|0,568,0)}if((c[a+168>>2]|0)<=(d|0)){f=dc(4)|0;c[f>>2]=3;td(f|0,568,0)}f=c[a+164>>2]|0;a=f+(d*52|0)|0;if((b[a>>1]|0)==0){i=e;return}g=c[f+(d*52|0)+48>>2]|0;if((g|0)!=0){Kd[g&31](a)}g=f+(d*52|0)+32|0;d=c[g>>2]|0;if((d|0)!=0){Oi(d);c[g>>2]=0}b[a>>1]=0;i=e;return}function si(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0;f=i;if((d|0)>=0?(c[a+168>>2]|0)>(d|0):0){g=c[a+164>>2]|0;if((b[g+(d*52|0)>>1]|0)==0){a=dc(4)|0;c[a>>2]=3;td(a|0,568,0)}else{b[g+(d*52|0)+2>>1]=e;i=f;return}}f=dc(4)|0;c[f>>2]=3;td(f|0,568,0)}function ti(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0;f=i;if((d|0)<0){g=dc(4)|0;c[g>>2]=3;td(g|0,568,0)}if((c[a+168>>2]|0)<=(d|0)){g=dc(4)|0;c[g>>2]=3;td(g|0,568,0)}g=(c[a+164>>2]|0)+(d*52|0)|0;if((b[g>>1]|0)==0){d=dc(4)|0;c[d>>2]=3;td(d|0,568,0)}if((e|0)<1){d=dc(4)|0;c[d>>2]=3;td(d|0,568,0)}else{b[g>>1]=e;i=f;return}}function ui(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;e=a+164|0;f=c[e>>2]|0;if((f|0)==0){c[e>>2]=Mi(52)|0;g=a+168|0;c[g>>2]=(c[g>>2]|0)+1;h=0;i=d;return h|0}g=a+168|0;j=c[g>>2]|0;a:do{if((j|0)!=0){if((j|0)>0){k=0;while(1){if((b[f+(k*52|0)>>1]|0)==0){h=k;break}k=k+1|0;if((k|0)>=(j|0)){l=j;break a}}i=d;return h|0}else{l=j}}else{l=0}}while(0);if((l|0)>=(c[a+172>>2]|0)){a=dc(4)|0;c[a>>2]=33;td(a|0,568,0)}a=l+1|0;c[g>>2]=a;c[e>>2]=Pi(f,a*52|0)|0;h=l;i=d;return h|0}function vi(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;h=ui(a)|0;j=c[a+164>>2]|0;c[j+(h*52|0)+8>>2]=0;b[j+(h*52|0)>>1]=1;b[j+(h*52|0)+2>>1]=1;c[j+(h*52|0)+4>>2]=a;k=j+(h*52|0)+12|0;c[k>>2]=0;l=j+(h*52|0)+16|0;c[l>>2]=0;m=j+(h*52|0)+32|0;n=a+68|0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;b[j+(h*52|0)+20>>1]=c[n>>2];b[j+(h*52|0)+22>>1]=c[a+72>>2];b[j+(h*52|0)+24>>1]=c[a+76>>2];n=a+80|0;b[j+(h*52|0)+26>>1]=c[n>>2];b[j+(h*52|0)+28>>1]=0;b[j+(h*52|0)+30>>1]=-1;c[k>>2]=-1;c[l>>2]=h;l=Mi(88)|0;c[m>>2]=l;Km(l|0,d|0,63)|0;b[l+80>>1]=e;c[l+84>>2]=f;b[l+64>>1]=-1;b[l+66>>1]=-1;c[j+(h*52|0)+36>>2]=28;c[j+(h*52|0)+40>>2]=40;Uh(a,c[n>>2]|0);i=g;return h|0}function wi(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;d=i;e=c[a+4>>2]|0;Xh(e,3912,18,0);f=a+20|0;g=b[f>>1]|0;h=a+22|0;j=b[h>>1]|0;k=a+24|0;l=g+ -1+(b[k>>1]|0)|0;m=a+26|0;n=j+ -1+(b[m>>1]|0)|0;o=a+32|0;p=c[o>>2]|0;q=p+64|0;if((b[q>>1]|0)<0){c[e+100>>2]=3;c[e+144>>2]=0;c[e+68>>2]=g;c[e+72>>2]=j;Vh(e,0);Yh(e,c[o>>2]|0);b[q>>1]=b[e+156>>1]|0;b[p+66>>1]=b[e+158>>1]|0}r=a+30|0;if((b[r>>1]|0)<0){if((b[a+2>>1]|0)==0){s=-8355712;t=-10461088;u=-12566464}else{s=(b[a+28>>1]|0)==1?-7303024:-986896;t=-4144960;u=-16777216}c[e+100>>2]=0;c[e+144>>2]=255;fi(e,g+1|0,j+1|0,(b[k>>1]|0)+ -2|0,(b[m>>1]|0)+ -2|0,1,s,t);Vh(e,-8355712);c[e+68>>2]=g;c[e+72>>2]=j;$h(e,l,j);$h(e,l,n);$h(e,g,n);$h(e,g,j);v=u}else{u=b[p+68>>1]|0;n=b[p+70>>1]|0;if((b[a+2>>1]|0)!=0){if((b[a+28>>1]|0)==1){w=b[p+72>>1]|0;x=b[p+74>>1]|0;y=-16777216}else{w=u;x=n;y=-16777216}}else{w=u;x=n;y=-8355712}c[e+100>>2]=3;c[e+144>>2]=255;Vh(e,y);c[e+68>>2]=g;c[e+72>>2]=j;j=Mh(c[e+184>>2]|0,b[r>>1]|0)|0;bi(e,j,w,x,b[k>>1]|0,b[m>>1]|0)|0;v=y}c[e+100>>2]=3;c[e+144>>2]=255;Vh(e,v);v=(((b[k>>1]|0)-(b[q>>1]|0)|0)/2|0)+(b[f>>1]|0)|0;f=e+68|0;c[f>>2]=v;q=(((b[m>>1]|0)-(b[p+66>>1]|0)|0)/2|0)+(b[h>>1]|0)|0;h=e+72|0;c[h>>2]=q;if((b[a+28>>1]|0)!=1){z=c[o>>2]|0;Yh(e,z);i=d;return}c[f>>2]=v+1;c[h>>2]=q+1;z=c[o>>2]|0;Yh(e,z);i=d;return}function xi(a,d){a=a|0;d=d|0;var e=0;d=i;if((b[a+2>>1]|0)==0){i=d;return}c[c[976]>>2]=c[a+16>>2];e=c[a+32>>2]|0;a=c[e+84>>2]|0;if((b[e+80>>1]&1)==0){Xe(a);i=d;return}else{Ye(a);i=d;return}}function yi(a,d,e,f,g,h,j,k,l){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0;m=i;if((d|0)<0){n=dc(4)|0;c[n>>2]=3;td(n|0,568,0)}if((c[a+168>>2]|0)<=(d|0)){n=dc(4)|0;c[n>>2]=3;td(n|0,568,0)}n=c[a+164>>2]|0;if((c[n+(d*52|0)+40>>2]|0)!=40){a=dc(4)|0;c[a>>2]=21;td(a|0,568,0)}b[n+(d*52|0)+30>>1]=e;e=c[n+(d*52|0)+32>>2]|0;if((e|0)==0){i=m;return}b[e+68>>1]=f;b[e+70>>1]=g;b[e+72>>1]=h;b[e+74>>1]=j;b[e+76>>1]=k;b[e+78>>1]=l;i=m;return}function zi(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;e=c[a+164>>2]|0;if((e|0)==0){i=d;return-1}f=a+168|0;a=c[f>>2]|0;if((a|0)>0){g=a;h=0;j=e}else{i=d;return-1}while(1){if((b[j>>1]|0)!=0?(e=c[j+36>>2]|0,(e|0)!=0):0){Kd[e&31](j);k=c[f>>2]|0}else{k=g}h=h+1|0;if((h|0)>=(k|0)){break}else{g=k;j=j+52|0}}i=d;return-1}function Ai(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;d=i;e=c[a+164>>2]|0;if((e|0)==0){i=d;return-1}f=b[a+176>>1]|0;g=b[a+178>>1]|0;h=a+286|0;if((b[h>>1]|0)!=0){if((b[a+284>>1]|0)!=0){i=d;return-1}b[h>>1]=0;i=d;return-1}j=a+288|0;k=c[j>>2]|0;if((k|0)!=0){l=g-(b[k+22>>1]|0)|0;if((((l|0)>-1?(l|0)<(b[k+26>>1]|0):0)?(l=f-(b[k+20>>1]|0)|0,(l|0)>-1):0)?(l|0)<(b[k+24>>1]|0):0){m=b[a+284>>1]|0}else{m=-1}b[k+28>>1]=m;if((b[a+284>>1]|0)!=0){i=d;return-1}c[j>>2]=0;if(!((m|0)>-1)){i=d;return-1}Md[c[k+40>>2]&63](k,m);i=d;return-1}m=c[a+168>>2]|0;k=a+284|0;if((m|0)>0){a=0;l=0;n=0;o=e;while(1){if((((((b[o>>1]|0)!=0?(c[o+40>>2]|0)!=0:0)?(e=g-(b[o+22>>1]|0)|0,(e|0)>-1):0)?(e|0)<(b[o+26>>1]|0):0)?(e=f-(b[o+20>>1]|0)|0,(e|0)>-1):0)?(e|0)<(b[o+24>>1]|0):0){p=o;q=b[k>>1]|0}else{p=a;q=l}n=n+1|0;if((n|0)>=(m|0)){r=p;s=q;break}else{a=p;l=q;o=o+52|0}}}else{r=0;s=0}if((b[k>>1]|0)!=1){i=d;return-1}if((r|0)==0){b[h>>1]=1;i=d;return-1}else{b[h>>1]=0;c[j>>2]=r;b[r+28>>1]=s;i=d;return-1}return 0}function Bi(){var a=0,d=0,e=0,f=0;a=i;c[980]=512;d=Ll(36864)|0;c[982]=d;c[986]=d+36864;c[984]=d;e=0;f=d;while(1){b[f>>1]=4;b[f+2>>1]=0;c[f+4>>2]=f+8;e=e+1|0;if((e|0)>=512){break}else{f=f+72|0}}i=a;return}function Ci(){var a=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0;a=i;d=c[984]|0;e=c[982]|0;if((d|0)==(e|0)){f=d;Ml(f);i=a;return}else{g=e;h=d}while(1){d=h+ -72|0;c[984]=d;if((b[h+ -70>>1]|0)==0){j=g;k=d}else{Ml(c[h+ -68>>2]|0);d=c[984]|0;b[d+2>>1]=0;c[d+4>>2]=d+8;j=c[982]|0;k=c[984]|0}if((k|0)==(j|0)){f=j;break}else{g=j;h=k}}Ml(f);i=a;return}function Di(){var a=0,d=0,e=0,f=0,g=0,h=0,j=0;a=i;d=c[984]|0;e=c[982]|0;if((d|0)==(e|0)){i=a;return}else{f=e;g=d}while(1){d=g+ -72|0;c[984]=d;if((b[g+ -70>>1]|0)==0){h=f;j=d}else{Ml(c[g+ -68>>2]|0);d=c[984]|0;b[d+2>>1]=0;c[d+4>>2]=d+8;h=c[982]|0;j=c[984]|0}if((j|0)==(h|0)){break}else{f=h;g=j}}i=a;return}function Ei(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0;h=i;j=c[984]|0;if(!(j>>>0<(c[986]|0)>>>0)){k=dc(4)|0;c[k>>2]=29;td(k|0,568,0)}b[j>>1]=e;if((e|0)==4|(e|0)==1){c[j+8>>2]=c[f>>2];c[984]=j+72;i=h;return}else if((e|0)==3){e=f;k=e;l=d[k>>0]|d[k+1>>0]<<8|d[k+2>>0]<<16|d[k+3>>0]<<24;k=e+4|0;e=d[k>>0]|d[k+1>>0]<<8|d[k+2>>0]<<16|d[k+3>>0]<<24;k=j+8|0;m=k;a[m>>0]=l;a[m+1>>0]=l>>8;a[m+2>>0]=l>>16;a[m+3>>0]=l>>24;l=k+4|0;a[l>>0]=e;a[l+1>>0]=e>>8;a[l+2>>0]=e>>16;a[l+3>>0]=e>>24;c[984]=j+72;i=h;return}else{if((g|0)<65){n=c[j+4>>2]|0}else{b[j+2>>1]=1;e=Ll(g)|0;c[j+4>>2]=e;n=e}Mm(n|0,f|0,g|0)|0;c[984]=(c[984]|0)+72;i=h;return}}function Fi(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;h=(Jm(f|0)|0)+1|0;j=c[984]|0;if(!(j>>>0<(c[986]|0)>>>0)){k=dc(4)|0;c[k>>2]=29;td(k|0,568,0)}b[j>>1]=e;if((e|0)==4|(e|0)==1){c[j+8>>2]=c[f>>2];c[984]=j+72;i=g;return}else if((e|0)==3){e=f;k=e;l=d[k>>0]|d[k+1>>0]<<8|d[k+2>>0]<<16|d[k+3>>0]<<24;k=e+4|0;e=d[k>>0]|d[k+1>>0]<<8|d[k+2>>0]<<16|d[k+3>>0]<<24;k=j+8|0;m=k;a[m>>0]=l;a[m+1>>0]=l>>8;a[m+2>>0]=l>>16;a[m+3>>0]=l>>24;l=k+4|0;a[l>>0]=e;a[l+1>>0]=e>>8;a[l+2>>0]=e>>16;a[l+3>>0]=e>>24;c[984]=j+72;i=g;return}else{if((h|0)<65){n=c[j+4>>2]|0}else{b[j+2>>1]=1;e=Ll(h)|0;c[j+4>>2]=e;n=e}Mm(n|0,f|0,h|0)|0;c[984]=(c[984]|0)+72;i=g;return}}function Gi(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;f=c[984]|0;if(!(f>>>0<(c[986]|0)>>>0)){g=dc(4)|0;c[g>>2]=29;td(g|0,568,0)}b[f>>1]=a;if((d|0)<65){h=f+4|0;j=f}else{b[f+2>>1]=1;a=f+4|0;c[a>>2]=Ll(d)|0;h=a;j=c[984]|0}c[984]=j+72;i=e;return c[h>>2]|0}function Hi(){var a=0,d=0;a=i;Ml(c[(c[984]|0)+4>>2]|0);d=c[984]|0;b[d+2>>1]=0;c[d+4>>2]=d+8;i=a;return}function Ii(){var a=0;a=i;c[988]=0;c[990]=0;c[992]=1024;Ji();i=a;return}function Ji(){var a=0,d=0,e=0,f=0,g=0,h=0,j=0;a=i;d=c[988]|0;if((d|0)==0){e=Ll(8)|0}else{e=Ol(c[994]|0,(d<<3)+8|0)|0}c[994]=e;d=c[992]|0;f=Ll(d*88|0)|0;if((f|0)==0){g=dc(4)|0;c[g>>2]=26;td(g|0,568,0)}g=f+(d*88|0)|0;h=c[988]|0;c[e+(h<<3)>>2]=f;c[e+(h<<3)+4>>2]=d;c[988]=h+1;c[992]=~~(+(d|0)*1.8);if(f>>>0<g>>>0){j=f}else{i=a;return}do{c[j+4>>2]=j;b[j>>1]=0;c[j+16>>2]=c[990];c[990]=j;j=j+88|0}while(j>>>0<g>>>0);i=a;return}function Ki(){var a=0,d=0,e=0,f=0,g=0,h=0,j=0;a=i;d=c[994]|0;if((c[988]|0)>0){e=d;f=0}else{g=d;Ml(g);i=a;return}while(1){d=c[e+(f<<3)>>2]|0;h=c[e+(f<<3)+4>>2]|0;j=d+(h*88|0)|0;if((h|0)>0){h=d;do{if((b[h>>1]|0)==2){Ml(c[h+16>>2]|0)}h=h+88|0}while(h>>>0<j>>>0)}Ml(d);f=f+1|0;j=c[994]|0;if((f|0)>=(c[988]|0)){g=j;break}else{e=j}}Ml(g);i=a;return}function Li(a){a=a|0;return a+ -24|0}function Mi(a){a=a|0;var d=0,e=0,f=0,g=0,h=0;d=i;e=(a|0)<64?64:a;a=c[990]|0;if((a|0)==0){Ji();f=c[990]|0}else{f=a}a=f+16|0;c[990]=c[a>>2];if((e|0)<65){b[f>>1]=1;c[f+8>>2]=64;g=f+24|0;c[f+12>>2]=g;h=g;c[h>>2]=0;i=d;return h|0}else{b[f>>1]=2;c[f+8>>2]=e;g=Ll(e+24|0)|0;e=g+24|0;c[a>>2]=g;c[f+12>>2]=e;c[g+0>>2]=c[f+0>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[g+16>>2]=c[f+16>>2];c[g+20>>2]=c[f+20>>2];h=e;c[h>>2]=0;i=d;return h|0}return 0}function Ni(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;e=(a|0)<64?64:a;f=c[990]|0;if((f|0)==0){Ji();g=c[990]|0}else{g=f}f=g+16|0;c[990]=c[f>>2];if((e|0)<65){b[g>>1]=1;c[g+8>>2]=64;h=g+24|0;c[g+12>>2]=h;j=h;c[j>>2]=0;Om(j|0,0,a|0)|0;i=d;return j|0}else{b[g>>1]=2;c[g+8>>2]=e;h=Ll(e+24|0)|0;e=h+24|0;c[f>>2]=h;c[g+12>>2]=e;c[h+0>>2]=c[g+0>>2];c[h+4>>2]=c[g+4>>2];c[h+8>>2]=c[g+8>>2];c[h+12>>2]=c[g+12>>2];c[h+16>>2]=c[g+16>>2];c[h+20>>2]=c[g+20>>2];j=e;c[j>>2]=0;Om(j|0,0,a|0)|0;i=d;return j|0}return 0}function Oi(a){a=a|0;var d=0,e=0;d=i;e=c[a+ -20>>2]|0;if((c[e+12>>2]|0)!=(a|0)){i=d;return}a=e+16|0;if((b[e>>1]|0)==2){Ml(c[a>>2]|0)}c[a>>2]=c[990];c[990]=e;b[e>>1]=0;i=d;return}function Pi(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=c[a+ -20>>2]|0;a=f+8|0;g=c[a>>2]|0;if((g|0)>=(d|0)){h=c[f+12>>2]|0;i=e;return h|0}j=Ll(d+24|0)|0;k=j+24|0;l=f+12|0;Mm(k|0,c[l>>2]|0,g|0)|0;g=f+16|0;if((b[f>>1]|0)==2){Ml(c[g>>2]|0)}c[a>>2]=d;b[f>>1]=2;c[l>>2]=k;c[g>>2]=j;c[j+0>>2]=c[f+0>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];c[j+16>>2]=c[f+16>>2];c[j+20>>2]=c[f+20>>2];h=k;i=e;return h|0}function Qi(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;f=Jm(d|0)|0;g=f+1|0;h=c[a>>2]|0;if((c[h+ -16>>2]|0)>=(g|0)){j=c[h+ -12>>2]|0;Mm(j|0,d|0,g|0)|0;i=e;return}k=c[h+ -20>>2]|0;h=k+8|0;l=c[h>>2]|0;if((l|0)<(g|0)){m=Ll(f+25|0)|0;f=m+24|0;n=k+12|0;Mm(f|0,c[n>>2]|0,l|0)|0;l=k+16|0;if((b[k>>1]|0)==2){Ml(c[l>>2]|0)}c[h>>2]=g;b[k>>1]=2;c[n>>2]=f;c[l>>2]=m;c[m+0>>2]=c[k+0>>2];c[m+4>>2]=c[k+4>>2];c[m+8>>2]=c[k+8>>2];c[m+12>>2]=c[k+12>>2];c[m+16>>2]=c[k+16>>2];c[m+20>>2]=c[k+20>>2];o=f}else{o=c[k+12>>2]|0}c[a>>2]=o;j=o;Mm(j|0,d|0,g|0)|0;i=e;return}function Ri(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;f=(Jm(d|0)|0)+1|0;g=c[a>>2]|0;h=c[g+ -12>>2]|0;j=Jm(h|0)|0;k=j+f|0;if((k|0)<=(c[g+ -16>>2]|0)){l=h;m=l+j|0;Mm(m|0,d|0,f|0)|0;i=e;return}h=k+4095&-4096;k=c[g+ -20>>2]|0;g=k+8|0;n=c[g>>2]|0;if((n|0)<(h|0)){o=Ll(h|24)|0;p=o+24|0;q=k+12|0;Mm(p|0,c[q>>2]|0,n|0)|0;n=k+16|0;if((b[k>>1]|0)==2){Ml(c[n>>2]|0)}c[g>>2]=h;b[k>>1]=2;c[q>>2]=p;c[n>>2]=o;c[o+0>>2]=c[k+0>>2];c[o+4>>2]=c[k+4>>2];c[o+8>>2]=c[k+8>>2];c[o+12>>2]=c[k+12>>2];c[o+16>>2]=c[k+16>>2];c[o+20>>2]=c[k+20>>2];r=p}else{r=c[k+12>>2]|0}c[a>>2]=r;l=r;m=l+j|0;Mm(m|0,d|0,f|0)|0;i=e;return}function Si(a){a=a|0;return c[a+ -4>>2]|0}function Ti(a,b){a=a|0;b=b|0;c[a+ -4>>2]=b;c[(c[a+ -20>>2]|0)+20>>2]=b;return}function Ui(b){b=b|0;c[b>>2]=0;a[b+17>>0]=0;return}function Vi(a){a=a|0;return}function Wi(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Xi(a){a=a|0;var b=0,d=0;b=i;d=Jm(c[a>>2]|0)|0;i=b;return d|0}function Yi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;e=i;f=c[b>>2]|0;g=b+4|0;c[g>>2]=0;h=b+8|0;c[h>>2]=f;a:do{if((d|0)<0){j=Jm(f|0)|0;if((j|0)!=0){k=f+j|0;c[h>>2]=k;l=a[f+(j+ -1)>>0]|0;if(l<<24>>24==13|l<<24>>24==10){c[g>>2]=1;m=k}else{m=k}}else{m=f}}else{b:do{if((d|0)==0){n=f}else{k=f;l=0;c:while(1){j=k;while(1){o=a[j>>0]|0;if(o<<24>>24==0){break c}p=j+1|0;c[h>>2]=p;if(o<<24>>24==10){q=9;break}else if(o<<24>>24==13){break}else{j=p}}if((q|0)==9){q=0;o=l+1|0;if((o|0)==(d|0)){n=p;break b}else{k=p;l=o;continue}}if((a[p>>0]|0)==10){o=j+2|0;c[h>>2]=o;r=o}else{r=p}l=l+1|0;if((l|0)==(d|0)){n=r;break b}else{k=r}}k=b+17|0;c[h>>2]=k;m=k;break a}}while(0);c[g>>2]=1;m=n}}while(0);n=b+12|0;g=m;while(1){c[n>>2]=g;s=a[g>>0]|0;if(s<<24>>24==10|s<<24>>24==13|s<<24>>24==0){break}g=g+1|0}a[b+16>>0]=s;a[g>>0]=0;i=e;return c[h>>2]|0}function Zi(b){b=b|0;a[c[b+12>>2]>>0]=a[b+16>>0]|0;return}function _i(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;e=c[b>>2]|0;f=b+8|0;c[f>>2]=e;b=e;e=1;a:while(1){g=b;h=0;while(1){j=g+1|0;c[f>>2]=j;k=a[g>>0]|0;if(k<<24>>24==0){break a}else if(k<<24>>24==10|k<<24>>24==13){break}g=j;h=h+1|0}b=j;e=e+1|0}i=d;return(((h|0)==0)<<31>>31)+e|0}function $i(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;g=i;h=c[b>>2]|0;j=b+4|0;c[j>>2]=0;k=b+8|0;c[k>>2]=h;do{if((e|0)<0){l=Jm(h|0)|0;if((l|0)!=0){m=h+l|0;c[k>>2]=m;n=a[h+(l+ -1)>>0]|0;if(n<<24>>24==13|n<<24>>24==10){c[j>>2]=1;o=m;break}if((l|0)!=0){l=h+(Jm(h|0)|0)|0;a[l+0>>0]=a[3984>>0]|0;a[l+1>>0]=a[3985>>0]|0;a[l+2>>0]=a[3986>>0]|0;l=(c[k>>2]|0)+2|0;c[k>>2]=l;o=l}else{o=h}}else{o=h}}else{a:do{if((e|0)==0){p=h}else{l=h;m=0;b:while(1){n=l;while(1){q=a[n>>0]|0;if(q<<24>>24==0){r=1;break b}s=n+1|0;c[k>>2]=s;if(q<<24>>24==10){t=9;break}else if(q<<24>>24==13){break}else{n=s}}if((t|0)==9){t=0;q=m+1|0;if((q|0)==(e|0)){p=s;break a}else{l=s;m=q;continue}}if((a[s>>0]|0)==10){q=n+2|0;c[k>>2]=q;u=q}else{u=s}m=m+1|0;if((m|0)==(e|0)){p=u;break a}else{l=u}}i=g;return r|0}}while(0);c[j>>2]=1;o=p}}while(0);p=(d|0)==0;j=p?3992:d;if(p){v=o}else{o=j+(Jm(j|0)|0)|0;a[o+0>>0]=a[3984>>0]|0;a[o+1>>0]=a[3985>>0]|0;a[o+2>>0]=a[3986>>0]|0;v=c[k>>2]|0}o=Jm(j|0)|0;p=c[b>>2]|0;b=Jm(p|0)|0;d=p+1+b-v|0;if((f|0)==0){w=0;x=o;y=d}else{f=0;u=v;while(1){e=a[u>>0]|0;if(e<<24>>24==0){z=f;break}s=f+1|0;if(e<<24>>24==10|e<<24>>24==13){z=s;break}else{f=s;u=u+1|0}}u=d-z|0;w=z;x=o-z|0;y=(u|0)<1?1:u}u=(y|0)>0;if((x|0)>-1){if(u){z=0;o=p+(x+b)|0;d=p+b|0;while(1){a[o>>0]=a[d>>0]|0;z=z+1|0;if((z|0)==(y|0)){break}else{o=o+ -1|0;d=d+ -1|0}}}}else{if(u){u=0;d=v+(x+w)|0;x=v+w|0;while(1){a[d>>0]=a[x>>0]|0;u=u+1|0;if((u|0)==(y|0)){break}else{d=d+1|0;x=x+1|0}}}}x=a[j>>0]|0;if(x<<24>>24==0){r=0;i=g;return r|0}else{A=x;B=j}do{B=B+1|0;j=c[k>>2]|0;c[k>>2]=j+1;a[j>>0]=A;A=a[B>>0]|0}while(!(A<<24>>24==0));r=0;i=g;return r|0}function aj(a,b){a=a|0;b=b|0;var d=0;d=i;if(a>>>0>46){i=d;return}c[4e3+(a<<2)>>2]=b;g[4192+(a<<2)>>2]=+(b|0);i=d;return}function bj(a){a=a|0;var b=0,d=0;b=i;if((a|0)==34){d=Tj()|0}else{d=c[4e3+(a<<2)>>2]|0}i=b;return d|0}function cj(){var b=0;b=i;Om(4e3,0,184)|0;Om(4192,0,184)|0;c[4004>>2]=128;c[4008>>2]=1024;c[4012>>2]=128;c[4016>>2]=4096;c[4048>>2]=1048576;c[4052>>2]=256;c[4064>>2]=16;c[4104>>2]=16;c[4112>>2]=1024;c[4072>>2]=1;c[4116>>2]=1;c[4076>>2]=2;c[4152>>2]=128;c[4184>>2]=64;g[4376>>2]=64.0;c[4140>>2]=3;a[4384]=0;i=b;return}function dj(a){a=a|0;return 4896+(a*72|0)|0}function ej(a){a=a|0;var d=0,e=0,f=0;d=i;e=4896+(a*72|0)|0;if((b[e>>1]|0)==0){i=d;return}Bb(1,4908+(a*72|0)|0);f=4924+(a*72|0)|0;a=c[f>>2]|0;if((a|0)!=0){Ml(a);c[f>>2]=0}b[e>>1]=0;i=d;return}function fj(){return}function gj(){var a=0,d=0;a=i;d=0;do{b[4896+(d*72|0)>>1]=0;d=d+1|0}while((d|0)!=256);c[5832]=0;i=a;return}function hj(a){a=a|0;var b=0;b=i;if((a|0)<0){dd(3553,0);xd(3553);i=b;return}else{dd(3553,a|0);Fb(3553);i=b;return}}function ij(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;e=i;i=i+48|0;f=e;h=e+32|0;j=e+20|0;k=e+24|0;l=xk(a,d,j,k,e+28|0,4)|0;c[h>>2]=-1;if((l|0)==0){rl(23360,f);m=-1;i=e;return m|0}d=c[j>>2]|0;a=1;while(1){if((a|0)<(d|0)){a=a<<1}else{break}}n=c[k>>2]|0;o=1;while(1){if((o|0)<(n|0)){o=o<<1}else{break}}if((a|0)==(d|0)&(o|0)==(n|0)){p=l}else{n=a<<2;d=Wk(da(n,o)|0)|0;if((c[k>>2]|0)>0){q=c[j>>2]|0;r=l;s=d;t=0;while(1){Mm(s|0,r|0,q<<2|0)|0;u=c[j>>2]|0;t=t+1|0;if((t|0)>=(c[k>>2]|0)){break}else{q=u;r=r+(u<<2)|0;s=s+n|0}}}Xk(l);p=d}Hb(1,h|0);dd(3553,c[h>>2]|0);Ic(3553,0,6408,a|0,o|0,0,6408,5121,p|0);Xk(p);p=a&65535;d=o&65535;l=c[j>>2]|0;j=l&65535;n=c[k>>2]|0;k=n&65535;s=c[h>>2]|0;h=0;while(1){v=4896+(h*72|0)|0;r=h+1|0;if((b[v>>1]|0)==0){w=14;break}if((r|0)<256){h=r}else{x=-1;break}}if((w|0)==14){if((h|0)<0){x=h}else{b[v>>1]=1;b[4898+(h*72|0)>>1]=0;b[4900+(h*72|0)>>1]=p;b[4902+(h*72|0)>>1]=d;b[4904+(h*72|0)>>1]=j;b[4906+(h*72|0)>>1]=k;g[4912+(h*72|0)>>2]=1.0/+(p<<16>>16);g[4916+(h*72|0)>>2]=1.0/+(d<<16>>16);c[4908+(h*72|0)>>2]=s;b[4920+(h*72|0)>>1]=0;b[4922+(h*72|0)>>1]=8;c[4924+(h*72|0)>>2]=0;x=h}}c[f>>2]=x;c[f+4>>2]=a;c[f+8>>2]=o;c[f+12>>2]=l;c[f+16>>2]=n;rl(23336,f);m=x;i=e;return m|0}function jj(a){a=a|0;var b=0,c=0,d=0,e=0;b=i;c=ge(a)|0;if((c|0)<0){d=-1;i=b;return d|0}e=Wk(c)|0;fe(a,e,c,0)|0;a=ij(e,c)|0;Xk(e);d=a;i=b;return d|0}function kj(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+16|0;f=e;h=e+12|0;j=1;while(1){if((j|0)<(a|0)){j=j<<1}else{k=1;break}}while(1){if((k|0)<(d|0)){k=k<<1}else{break}}Hb(1,h|0);dd(3553,c[h>>2]|0);Ic(3553,0,6406,j|0,k|0,0,6406,5121,0);l=j&65535;m=k&65535;n=a&65535;a=d&65535;d=c[h>>2]|0;h=0;while(1){o=4896+(h*72|0)|0;p=h+1|0;if((b[o>>1]|0)==0){q=7;break}if((p|0)<256){h=p}else{r=-1;break}}if((q|0)==7){if((h|0)<0){r=h}else{b[o>>1]=2;b[4898+(h*72|0)>>1]=0;b[4900+(h*72|0)>>1]=l;b[4902+(h*72|0)>>1]=m;b[4904+(h*72|0)>>1]=n;b[4906+(h*72|0)>>1]=a;g[4912+(h*72|0)>>2]=1.0/+(l<<16>>16);g[4916+(h*72|0)>>2]=1.0/+(m<<16>>16);c[4908+(h*72|0)>>2]=d;b[4920+(h*72|0)>>1]=0;b[4922+(h*72|0)>>1]=8;c[4924+(h*72|0)>>2]=0;r=h}}c[f>>2]=r;c[f+4>>2]=j;c[f+8>>2]=k;rl(23376,f);i=e;return r|0}function lj(){var a=0,d=0,e=0,f=0,g=0;a=i;c[5832]=0;d=0;e=4896;while(1){do{if((b[e>>1]|0)==2){f=e+26|0;g=b[f>>1]|0;if(g<<16>>16>0){b[f>>1]=g+ -1<<16>>16;c[5832]=(c[5832]|0)+1;break}Bb(1,e+12|0);g=e+28|0;f=c[g>>2]|0;if((f|0)!=0){Ml(f);c[g>>2]=0}b[e>>1]=0}}while(0);d=d+1|0;if((d|0)==256){break}else{e=e+72|0}}i=a;return}function mj(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=i;h=a[d>>0]|0;j=(h&255)<<8;if(h<<24>>24==0){k=-1;i=g;return k|0}else{l=1;m=d}while(1){m=m+1|0;n=l+1|0;if((a[m>>0]|0)==0){break}else{l=n}}if((n|0)<=0){k=-1;i=g;return k|0}m=j&65535;j=0;h=4896;a:while(1){do{if((((b[h>>1]|0)==2?(b[h+24>>1]|0)==m<<16>>16:0)?(c[h+32>>2]|0)==(e|0):0)?(c[h+36>>2]|0)==(f|0):0){o=c[h+28>>2]|0;if((o|0)==0){if((Cm(d,h+40|0)|0)==0){p=13;break a}else{break}}else{if((Cm(d,o)|0)==0){p=11;break a}else{break}}}}while(0);o=j+1|0;if((o|0)<256){j=o;h=h+72|0}else{break}}if((p|0)==11){b[h+26>>1]=8;p=15}else if((p|0)==13){b[h+26>>1]=8;p=15}if((p|0)==15?(j|0)>-1:0){k=j;i=g;return k|0}Rc(23400,d|0,e|0)|0;j=Rc(23912)|0;p=kj(j,Rc(23992)|0)|0;if((p|0)<0){k=-1;i=g;return k|0}b[4920+(p*72|0)>>1]=m;c[4928+(p*72|0)>>2]=e;c[4932+(p*72|0)>>2]=f;f=c[5832]|0;do{if((f|0)<(bj(46)|0)){if((n|0)>30){m=Ll(l+2|0)|0;c[4924+(p*72|0)>>2]=m;Rm(m|0,d|0)|0;break}else{Rm(4936+(p*72|0)|0,d|0)|0;break}}else{b[4922+(p*72|0)>>1]=0;a[4936+(p*72|0)>>0]=0}}while(0);dd(3553,c[4908+(p*72|0)>>2]|0);Sc(3553,10240,9729);Sc(3553,10241,9729);hd(3317,1);Rc(24072,d|0,e|0,b[4900+(p*72|0)>>1]|0,b[4902+(p*72|0)>>1]|0)|0;dd(3553,0);k=p;i=g;return k|0}function nj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;b=i;i=i+16|0;h=b;gj();c[6182]=d;c[6184]=e;c[6186]=d;c[6188]=e;g[6190]=1.0;g[6192]=1.0;g[6194]=1.0;g[6196]=1.0;c[6198]=0;a[25096]=0;a[25104]=0;a[25112]=0;a[25120]=-1;c[6200]=0;c[6202]=0;c[6204]=9728;c[6206]=0;c[6208]=0;c[6210]=f;c[6384]=0;c[6386]=0;c[6282]=0;aj(10,0);aj(11,0);aj(31,1);aj(32,0);c[h>>2]=d;c[h+4>>2]=e;rl(24848,h);h=24872|0;e=h+128|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(e|0));i=b;return}function oj(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,h=0;f=i;h=~~(+g[6194]*+(a-(c[6200]|0)|0));c[6384]=h;a=~~(+g[6196]*+(d-(c[6202]|0)|0));c[6386]=a;c[6282]=e;d=c[6208]|0;if((d|0)==0){i=f;return}b[d+176>>1]=h;b[d+178>>1]=a;b[d+284>>1]=e;Ai(d)|0;mi(d,0,c[6384]|0,c[6386]|0,(e|0)!=0);i=f;return}function pj(a,b){a=a|0;b=b|0;c[6186]=a;c[6188]=b;return}function qj(a,b){a=a|0;b=b|0;c[6182]=a;c[6184]=b;return}function rj(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0;b=i;i=i+16|0;d=b;e=+(c[6186]|0);f=+(c[6182]|0);j=e/f;l=+(c[6188]|0);m=+(c[6184]|0);n=l/m;do{if((a|0)==2){o=6}else if((a|0)==1){o=5}else if((a|0)==0){if(j>n){if(j*m>l){o=6;break}else{o=5;break}}else{if(f*n>e){o=5;break}else{o=6;break}}}else{g[6190]=j;g[6192]=n;p=j;q=n}}while(0);if((o|0)==5){g[6190]=j;g[6192]=j;p=j;q=j}else if((o|0)==6){g[6190]=n;g[6192]=n;p=n;q=n}h[k>>3]=p;c[d>>2]=c[k>>2];c[d+4>>2]=c[k+4>>2];o=d+8|0;h[k>>3]=q;c[o>>2]=c[k>>2];c[o+4>>2]=c[k+4>>2];rl(25e3,d);i=b;return}function sj(){var a=0,b=0.0,d=0.0,e=0.0,f=0,h=0;a=i;Za(5889);Ya();g[6194]=1.0/+g[6190];g[6196]=1.0/+g[6192];b=+(c[6182]|0);d=+(c[6184]|0);fb(0.0,+b,+-d,0.0,-100.0,100.0);e=b*+g[6190];f=~~((+(c[6186]|0)-e)*.5);c[6200]=f;b=d*+g[6192];h=~~((+(c[6188]|0)-b)*.5);c[6202]=h;yb(~~+(f|0)|0,~~+(h|0)|0,~~e|0,~~b|0);Za(5888);Ya();xd(2896);xd(2884);xd(256);xd(2929);eb(2,5126,0,25016);gc(32884);Ac(2,5126,0,25048);gc(32888);xd(3553);Fb(3042);Oa(1,771);Fb(2832);Sc(3553,10240,9728);Sc(3553,10241,9728);lj();i=a;return}function tj(){var a=0;a=i;if((c[6206]|0)!=0){wd();c[6206]=0}i=a;return 0}function uj(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;if((b|0)==1|(b|0)==0){xd(3042);f=7}else if((b|0)==6){Fb(3042);Oa(770,1);f=6}else if((b|0)!=5){Fb(3042);Oa(770,771);if((b|0)>2){f=6}else{f=7}}else{Fb(3042);Oa(770,1);f=6}if((f|0)==6){b=d&255;a[25095>>0]=b;a[25091>>0]=b;a[25087>>0]=b;a[25083>>0]=b;gc(32886);Wc(4,5121,0,25080)}else if((f|0)==7){Lc(32886)}Sc(3553,10240,c[6204]|0);Sc(3553,10241,c[6204]|0);i=e;return}function vj(a){a=a|0;var b=0;b=i;switch(a|0){case 0:{xd(3042);break};case 5:{Fb(3042);Oa(770,1);break};case 4:case 3:{Fb(3042);Oa(1,771);break};case 6:{Fb(3042);Oa(770,1);break};default:{Fb(3042);Oa(1,771)}}i=b;return}function wj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d>>2]=~~(+g[6194]*+(a-(c[6200]|0)|0));c[e>>2]=~~(+g[6196]*+(b-(c[6202]|0)|0));return}function xj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;aj(31,a);aj(32,b);aj(33,c);i=d;return}function yj(){return c[6182]|0}function zj(){return c[6184]|0}function Aj(a,b){a=a|0;b=b|0;c[6204]=(a|0)==0?9728:9729;return}function Bj(a){a=a|0;return 0}function Cj(a){a=a|0;return((c[6282]|0)==0?0:256)|0}function Dj(a,b,d){a=a|0;b=b|0;d=d|0;c[6284]=b;c[6286]=d;return 0}function Ej(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=c[a+68>>2]|0;g=c[a+72>>2]|0;h=c[a+104>>2]|0;j=mj(d,c[6284]|0,c[6286]|0)|0;if((j|0)>-1){d=dj(j)|0;k=b[d+8>>1]|0;c[6288]=k<<16>>16;l=b[d+10>>1]|0;c[6290]=l<<16>>16;Oj(+(f|0),+(g|0),0,0,k,l,j,h)}b[a+156>>1]=c[6288];b[a+158>>1]=c[6290];i=e;return 0}function Fj(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;if((c[a>>2]|0)!=0?(f=a+280|0,g=c[f>>2]|0,!((g|0)==-1)):0){ej(g);c[f>>2]=-1}f=jj(d)|0;if((f|0)<0){h=-1;i=e;return h|0}d=dj(f)|0;if((b[d>>1]|0)==0){h=-1;i=e;return h|0}c[a+4>>2]=b[d+8>>1]|0;c[a+8>>2]=b[d+10>>1]|0;c[a+280>>2]=f;h=f;i=e;return h|0}function Gj(a){a=a|0;var b=0,d=0;b=i;if((c[a>>2]|0)!=0?(d=a+280|0,a=c[d>>2]|0,!((a|0)==-1)):0){ej(a);c[d>>2]=-1}i=b;return}function Hj(b,c,d,e){b=+b;c=+c;d=+d;e=+e;var f=0,h=0,j=0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0;f=i;i=i+4096|0;h=f;j=f+3072|0;k=b;b=d;d=-c;c=e;l=0;do{e=+(l|0)*6.283185307179586/20.0;m=l*3|0;g[h+(m<<2)>>2]=k+b*+V(+e);g[h+(m+1<<2)>>2]=d+c*+W(+e);g[h+(m+2<<2)>>2]=0.0;l=l+1|0}while((l|0)!=20);l=a[25096]|0;m=a[25104]|0;n=a[25112]|0;o=a[25120]|0;p=0;do{q=p<<2;a[j+q>>0]=l;a[j+(q|1)>>0]=m;a[j+(q|2)>>0]=n;a[j+(q|3)>>0]=o;p=p+1|0}while((p|0)!=20);xd(3042);gc(32886);eb(3,5126,0,h|0);Wc(4,5121,0,j|0);sc(2,0,20);sc(0,0,20);i=f;return}function Ij(b,c,d,e){b=+b;c=+c;d=+d;e=+e;var f=0,h=0,j=0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0;f=i;i=i+4096|0;h=f;j=f+3072|0;g[h>>2]=b;k=-c;g[h+4>>2]=k;g[h+8>>2]=0.0;c=b;b=d;d=k;k=e;l=1;do{e=+(l|0)*6.283185307179586/20.0;m=l*3|0;g[h+(m<<2)>>2]=c+b*+V(+e);g[h+(m+1<<2)>>2]=d+k*+W(+e);g[h+(m+2<<2)>>2]=0.0;l=l+1|0}while((l|0)!=22);l=a[25096]|0;m=a[25104]|0;n=a[25112]|0;o=a[25120]|0;p=0;do{q=p<<2;a[j+q>>0]=l;a[j+(q|1)>>0]=m;a[j+(q|2)>>0]=n;a[j+(q|3)>>0]=o;p=p+1|0}while((p|0)!=22);xd(3042);gc(32886);eb(3,5126,0,h|0);Wc(4,5121,0,j|0);sc(6,0,22);i=f;return}function Jj(b,d,e){b=b|0;d=+d;e=+e;var f=0,h=0,j=0,k=0;f=i;if((b|0)==0){i=f;return}if((c[b+28>>2]|0)!=2){h=dc(4)|0;c[h>>2]=21;td(h|0,568,0)}h=c[b+104>>2]|0;b=h>>>16&255;a[25096]=b;j=h>>>8&255;a[25104]=j;k=h&255;a[25112]=k;a[25120]=-1;a[25184]=b;a[25185>>0]=j;a[25186>>0]=k;a[25187>>0]=-1;a[25188>>0]=b;a[25189>>0]=j;a[25190>>0]=k;a[25191>>0]=-1;g[6312]=d+.375;g[6314]=e+.375;xd(3042);hj(-1);i=f;return}function Kj(a,b){a=+a;b=+b;var c=0,d=0.0;c=i;g[6316]=+g[6312];g[25268>>2]=-+g[6314];g[25272>>2]=0.0;d=a+.375;g[6312]=d;a=b+.375;g[6314]=a;g[25276>>2]=d;g[25280>>2]=-a;g[25284>>2]=0.0;gc(32886);eb(3,5126,0,25264);Wc(4,5121,0,25184);sc(3,0,2);i=c;return}function Lj(b,d,e,f,h){b=b|0;d=+d;e=+e;f=+f;h=+h;var j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0;j=i;i=i+256|0;k=j;l=j+192|0;if((b|0)==0){i=j;return}if((c[b+28>>2]|0)!=2){m=dc(4)|0;c[m>>2]=21;td(m|0,568,0)}hj(-1);m=c[b+104>>2]|0;b=m>>>16&255;a[25096]=b;n=m>>>8&255;a[25104]=n;o=m&255;a[25112]=o;a[25120]=-1;g[k>>2]=d;p=-e;g[k+4>>2]=p;g[k+8>>2]=0.0;g[k+12>>2]=d;q=p-(h-e);g[k+16>>2]=q;g[k+20>>2]=0.0;e=f-d+d;g[k+24>>2]=e;g[k+28>>2]=p;g[k+32>>2]=0.0;g[k+36>>2]=e;g[k+40>>2]=q;g[k+44>>2]=0.0;a[l>>0]=b;a[l+1>>0]=n;a[l+2>>0]=o;a[l+3>>0]=-1;a[l+4>>0]=b;a[l+5>>0]=n;a[l+6>>0]=o;a[l+7>>0]=-1;a[l+8>>0]=b;a[l+9>>0]=n;a[l+10>>0]=o;a[l+11>>0]=-1;a[l+12>>0]=b;a[l+13>>0]=n;a[l+14>>0]=o;a[l+15>>0]=-1;xd(3042);gc(32886);eb(3,5126,0,k|0);Wc(4,5121,0,l|0);sc(5,0,4);i=j;return}function Mj(b,d,e,f,g,h){b=b|0;d=+d;e=+e;f=+f;g=+g;h=h|0;var j=0,k=0,l=0.0;j=i;if((b|0)==0){i=j;return}if((c[b+28>>2]|0)!=2){k=dc(4)|0;c[k>>2]=21;td(k|0,568,0)}k=~~(f-d);f=+(((k|0)>-1?k:0-k|0)|0)*.5;k=~~(g-e);g=+(((k|0)>-1?k:0-k|0)|0)*.5;l=f+d;d=g+e;hj(-1);k=c[b+104>>2]|0;a[25096]=k>>>16;a[25104]=k>>>8;a[25112]=k;a[25120]=-1;if((h|0)==0){Hj(l,d,f,g);i=j;return}else{Ij(l,d,f,g);i=j;return}}function Nj(b,d,e,f,h,j){b=b|0;d=+d;e=+e;f=+f;h=+h;j=+j;var k=0,l=0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0;k=i;if((b|0)==0){i=k;return}if((c[b+28>>2]|0)!=2){l=dc(4)|0;c[l>>2]=21;td(l|0,568,0)}m=j;j=-+W(+m);n=+V(+m);m=f*-.5;f=h*-.5;h=f*j;o=f*n;f=m*n;n=m*j;g[6364]=f-h+d;g[25460>>2]=-(-o-n+e);g[25464>>2]=-f-h+d;g[25468>>2]=-(n-o+e);g[25472>>2]=h+f+d;g[25476>>2]=-(o-n+e);g[25480>>2]=h-f+d;g[25484>>2]=-(o+n+e);hj(-1);eb(2,5126,0,25456);l=c[b+104>>2]|0;p=l>>>16&255;q=l>>>8&255;r=l&255;l=c[b+144>>2]&255;a[25168]=p;a[25169>>0]=q;a[25170>>0]=r;a[25171>>0]=l;a[25172>>0]=p;a[25173>>0]=q;a[25174>>0]=r;a[25175>>0]=l;a[25176>>0]=p;a[25177>>0]=q;a[25178>>0]=r;a[25179>>0]=l;a[25180>>0]=p;a[25181>>0]=q;a[25182>>0]=r;a[25183>>0]=l;gc(32886);Wc(4,5121,0,25168);vj(c[b+100>>2]|0);sc(5,0,4);i=k;return}function Oj(d,e,f,h,j,k,l,m){d=+d;e=+e;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;n=i;o=dj(l)|0;if((b[o>>1]|0)==0){i=n;return}p=-e;l=j<<16>>16;e=+(j<<16>>16)+d;j=k<<16>>16;q=p- +(k<<16>>16);g[6364]=d;g[25460>>2]=p;g[25464>>2]=d;g[25468>>2]=q;g[25472>>2]=e;g[25476>>2]=p;g[25480>>2]=e;g[25484>>2]=q;q=+g[o+16>>2];e=+g[o+20>>2];p=+(f<<16>>16);if((c[6198]|0)==0){r=+(h<<16>>16);s=+(l+(f<<16>>16)|0);t=+(j+(h<<16>>16)|0);u=p}else{r=+(h<<16>>16)+.5;s=+(l+(f<<16>>16)|0)+-.5;t=+(j+(h<<16>>16)|0)+-.5;u=p+.5}p=q*u;u=e*t;t=q*s;s=e*r;g[6372]=p;g[25492>>2]=s;g[25496>>2]=p;g[25500>>2]=u;g[25504>>2]=t;g[25508>>2]=s;g[25512>>2]=t;g[25516>>2]=u;Fb(3553);hj(c[o+12>>2]|0);eb(2,5126,0,25456);Ac(2,5126,0,25488);Fb(3042);Oa(770,771);a[25095>>0]=-1;a[25091>>0]=-1;a[25087>>0]=-1;a[25083>>0]=-1;gc(32886);Wc(4,5121,0,25080);Sc(3553,10240,c[6204]|0);Sc(3553,10241,c[6204]|0);o=m>>>16&255;h=m>>>8&255;j=m&255;a[25168]=o;a[25169>>0]=h;a[25170>>0]=j;a[25171>>0]=-1;a[25172>>0]=o;a[25173>>0]=h;a[25174>>0]=j;a[25175>>0]=-1;a[25176>>0]=o;a[25177>>0]=h;a[25178>>0]=j;a[25179>>0]=-1;a[25180>>0]=o;a[25181>>0]=h;a[25182>>0]=j;a[25183>>0]=-1;gc(32886);Wc(4,5121,0,25168);sc(5,0,4);xd(3553);i=n;return}function Pj(a,d,e,f,h,j,k,l){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;l=+l;var m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;m=i;if((a|0)==0){i=m;return}if((c[a+28>>2]|0)!=2){n=dc(4)|0;c[n>>2]=21;td(n|0,568,0)}n=dj(c[j+280>>2]|0)|0;if((b[n>>1]|0)==0){i=m;return}if(k<0.0){o=-k;p=+((f<<16>>16)+(d<<16>>16)|0);q=+(d<<16>>16)}else{o=k;p=+(d<<16>>16);q=+((f<<16>>16)+(d<<16>>16)|0)}if(l<0.0){r=-l;s=+((h<<16>>16)+(e<<16>>16)|0);t=+(e<<16>>16)}else{r=l;s=+(e<<16>>16);t=+((h<<16>>16)+(e<<16>>16)|0)}l=+(c[a+68>>2]|0);k=+(0-(c[a+72>>2]|0)|0);u=o+l;o=k-r;g[6364]=l;g[25460>>2]=k;g[25464>>2]=l;g[25468>>2]=o;g[25472>>2]=u;g[25476>>2]=k;g[25480>>2]=u;g[25484>>2]=o;if((c[6198]|0)==0){v=p;w=q;x=s;y=t}else{v=p+.5;w=q+-.5;x=s+.5;y=t+-.5}t=+g[n+16>>2];s=+g[n+20>>2];q=v*t;v=x*s;x=w*t;t=y*s;g[6372]=q;g[25492>>2]=v;g[25496>>2]=q;g[25500>>2]=t;g[25504>>2]=x;g[25508>>2]=v;g[25512>>2]=x;g[25516>>2]=t;hj(c[n+12>>2]|0);eb(2,5126,0,25456);Ac(2,5126,0,25488);uj(c[a+100>>2]|0,c[a+144>>2]|0);sc(5,0,4);i=m;return}function Qj(a,d,e,f,h,j,k,l,m,n,o){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;j=+j;k=+k;l=l|0;m=+m;n=+n;o=+o;var p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;p=i;if((a|0)==0){i=p;return}if((c[a+28>>2]|0)!=2){q=dc(4)|0;c[q>>2]=21;td(q|0,568,0)}q=dj(c[l+280>>2]|0)|0;if((b[q>>1]|0)==0){i=p;return}r=o;o=+W(+r);s=+V(+r);r=+(c[a+68>>2]|0)-(s*j-o*k);t=+(c[a+72>>2]|0)-(o*j+s*k);k=o*n;j=s*n;n=s*m;s=o*m;m=+g[q+16>>2];o=+g[q+20>>2];u=+(d<<16>>16)*m;v=+(e<<16>>16)*o;w=+((f<<16>>16)+(d<<16>>16)|0)*m;m=+((h<<16>>16)+(e<<16>>16)|0)*o;g[6372]=u;g[25492>>2]=v;g[25496>>2]=u;g[25500>>2]=m;g[25504>>2]=w;g[25508>>2]=v;g[25512>>2]=w;g[25516>>2]=m;g[6364]=r;g[25460>>2]=-t;g[25464>>2]=r-k;g[25468>>2]=-(j+t);g[25472>>2]=n+r;g[25476>>2]=-(s+t);g[25480>>2]=n-k+r;g[25484>>2]=-(s+j+t);hj(c[q+12>>2]|0);eb(2,5126,0,25456);Ac(2,5126,0,25488);uj(c[a+100>>2]|0,c[a+144>>2]|0);sc(5,0,4);i=p;return}function Rj(a,d,e,f,h,j){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0.0,n=0.0;k=i;if((a|0)==0){i=k;return}if((c[a+28>>2]|0)!=2){l=dc(4)|0;c[l>>2]=21;td(l|0,568,0)}l=dj(c[f+280>>2]|0)|0;if((b[l>>1]|0)==0){i=k;return}m=+g[l+16>>2];n=+g[l+20>>2];g[6372]=m*+(c[h>>2]|0);g[25492>>2]=n*+(c[j>>2]|0);g[25496>>2]=m*+(c[h+12>>2]|0);g[25500>>2]=n*+(c[j+12>>2]|0);g[25504>>2]=m*+(c[h+4>>2]|0);g[25508>>2]=n*+(c[j+4>>2]|0);g[25512>>2]=m*+(c[h+8>>2]|0);g[25516>>2]=n*+(c[j+8>>2]|0);g[6364]=+(c[d>>2]|0);g[25460>>2]=+(0-(c[e>>2]|0)|0);g[25464>>2]=+(c[d+12>>2]|0);g[25468>>2]=+(0-(c[e+12>>2]|0)|0);g[25472>>2]=+(c[d+4>>2]|0);g[25476>>2]=+(0-(c[e+4>>2]|0)|0);g[25480>>2]=+(c[d+8>>2]|0);g[25484>>2]=+(0-(c[e+8>>2]|0)|0);hj(c[l+12>>2]|0);eb(2,5126,0,25456);Ac(2,5126,0,25488);uj(c[a+100>>2]|0,c[a+144>>2]|0);sc(5,0,4);i=k;return}function Sj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;h=i;if((b|0)==0){i=h;return}if((c[b+28>>2]|0)!=2){j=dc(4)|0;c[j>>2]=21;td(j|0,568,0)}g[6364]=+(c[d>>2]|0);g[25460>>2]=+(0-(c[e>>2]|0)|0);g[25464>>2]=+(c[d+12>>2]|0);g[25468>>2]=+(0-(c[e+12>>2]|0)|0);g[25472>>2]=+(c[d+4>>2]|0);g[25476>>2]=+(0-(c[e+4>>2]|0)|0);g[25480>>2]=+(c[d+8>>2]|0);g[25484>>2]=+(0-(c[e+8>>2]|0)|0);hj(-1);eb(2,5126,0,25456);e=c[b+144>>2]|0;d=b+100|0;b=(c[d>>2]|0)<3;j=c[f>>2]|0;a[25168]=j>>>16;a[25169>>0]=j>>>8;a[25170>>0]=j;j=b?-1:e&255;a[25171>>0]=j;e=c[f+12>>2]|0;a[25172>>0]=e>>>16;a[25173>>0]=e>>>8;a[25174>>0]=e;a[25175>>0]=j;e=c[f+4>>2]|0;a[25176>>0]=e>>>16;a[25177>>0]=e>>>8;a[25178>>0]=e;a[25179>>0]=j;e=c[f+8>>2]|0;a[25180>>0]=e>>>16;a[25181>>0]=e>>>8;a[25182>>0]=e;a[25183>>0]=j;gc(32886);Wc(4,5121,0,25168);vj(c[d>>2]|0);sc(5,0,4);i=h;return}function Tj(){var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b;Pb(0,d|0)|0;e=~~(+(c[d+4>>2]|0)*.001*.001)+((c[d>>2]|0)*1e3|0)|0;if((a[25520]|0)==0){a[25520]=1;c[6382]=e;f=e;g=e-f|0;i=b;return g|0}else{f=c[6382]|0;g=e-f|0;i=b;return g|0}return 0}function Uj(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function Vj(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function Wj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;a[e>>0]=0;if(b>>>0<3){c[d>>2]=2;f=e}else{f=0}return f|0}function Xj(){var a=0,b=0;a=i;if((c[6206]|0)!=0){wd();c[6206]=0}if((bj(31)|0)!=1){sj();c[6206]=1;i=a;return 0}b=bj(32)|0;lc(+(+(b>>>16&255|0)*.00390625),+(+(b>>>8&255|0)*.00390625),+(+(b&255|0)*.00390625),1.0);ad(16384);sj();c[6206]=1;i=a;return 0}function Yj(a){a=a|0;var b=0,c=0.0;b=a+ -256|0;if(b>>>0<16){c=+h[24872+(b<<3)>>3]}else{c=0.0}return+c}function Zj(a){a=a|0;c[6208]=a;return}function _j(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;do{if((a|0)!=0){if((c[a+28>>2]|0)!=2){e=dc(4)|0;c[e>>2]=21;td(e|0,568,0)}if((b&1|0)==0){Xj()|0;f=0;break}if((c[6206]|0)==0){f=0}else{wd();c[6206]=0;f=0}}else{f=-1}}while(0);i=d;return f|0}function $j(a){a=a|0;return 25552}function ak(){var a=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+64|0;d=a;e=a+52|0;f=a+48|0;if((Zc(d|0)|0)==0){i=a;return}g=d+20|0;h=d+24|0;j=d+20|0;do{k=c[d>>2]|0;if((k|0)==1024){if((c[6390]|0)!=0){wj(c[g>>2]|0,c[h>>2]|0,e,f);l=Nd[c[(c[6390]|0)+72>>2]&63](0)|0;b[l+176>>1]=c[e>>2];b[l+178>>1]=c[f>>2];Ai(l)|0;mi(l,-1,c[e>>2]|0,c[f>>2]|0,1)}}else if((k|0)==1026){oj(c[j>>2]|0,c[h>>2]|0,0)}else if((k|0)==1025){oj(c[j>>2]|0,c[h>>2]|0,1)}}while((Zc(d|0)|0)!=0);i=a;return}function bk(a){a=a|0;var b=0,d=0,e=0;b=i;d=a+236|0;a=c[d>>2]|0;a:while(1){switch(a|0){case 1:{e=4;break a;break};case 7:{e=8;break a;break};case 9:{e=3;break a;break};case 2:{break a;break};case 6:{e=7;break a;break};case 8:{break};default:{e=10;break a}}c[d>>2]=3;a=3}if((e|0)==3){c[d>>2]=0;i=b;return}else if((e|0)==4){c[d>>2]=cf(Tj()|0)|0}else if((e|0)==7){d=dc(4)|0;c[d>>2]=10;td(d|0,568,0)}else if((e|0)==8){d=dc(4)|0;c[d>>2]=42;td(d|0,568,0)}else if((e|0)==10){i=b;return}if((df(Tj()|0)|0)!=0){i=b;return}c[(c[6394]|0)+236>>2]=2;i=b;return}function ck(d){d=d|0;var f=0,g=0,j=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,t=0;f=i;i=i+16|0;g=f;cj();j=Rl(912)|0;s=0;oa(29,j|0);l=s;s=0;if(l&1){l=ub(-1,-1)|0;Tl(j);Cb(l|0)}c[6396]=j;if((d|0)!=0){ne(j,d)}c[6398]=320;c[6400]=480;if(((a[25615>>0]|0)==126|0)==(0-(((a[25614>>0]|0)==126&1)+(((a[25613>>0]|0)==68&1)+(((a[25612>>0]|0)==69&1)+(((a[25611>>0]|0)==72&1)+(((a[25610>>0]|0)==80&1)+(((a[25609>>0]|0)==83&1)+((a[25608]|0)==72&1)))))))|0)){d=(xm(25617|0)|0)+65536|0;c[6398]=b[25628>>1]|0;c[6400]=b[25631>>1]|0;pe(c[6396]|0,e[25637>>1]|0,c[25640>>2]|0);m=d}else{m=0}d=vc(25648)|0;if((d|0)!=0?(j=xm(d)|0,(j|0)>0):0){c[6398]=j}j=vc(25656)|0;if((j|0)!=0?(d=xm(j)|0,(d|0)>0):0){c[6400]=d}d=vc(25664)|0;if((d|0)==0){n=0.0}else{n=+wm(d)}d=vc(25672)|0;if((d|0)!=0?(o=+wm(d),n>0.0&o>0.0):0){p=n;q=o}else{p=+(c[6398]|0);q=+(c[6400]|0)}d=vc(25680)|0;if((d|0)==0){r=0}else{r=xm(d)|0}h[k>>3]=p;c[g>>2]=c[k>>2];c[g+4>>2]=c[k+4>>2];d=g+8|0;h[k>>3]=q;c[d>>2]=c[k>>2];c[d+4>>2]=c[k+4>>2];Gb(25696,g|0)|0;if((oe(c[6396]|0,m)|0)!=0){Xa(25712)|0;t=1;i=f;return t|0}m=c[6396]|0;c[6394]=m;c[6392]=0;c[m+852>>2]=30;m=~~p;d=~~q;c[g>>2]=m;c[g+4>>2]=d;c[g+8>>2]=25728;Gb(25864,g|0)|0;do{if((nc(32)|0)==0){pb(5,1)|0;if((Qb(m|0,d|0,16,67108864)|0)==0){c[g>>2]=Ma()|0;Gb(25912,g|0)|0;break}else{nj(0,m,d,0);xj(1,16777215,0);break}}else{c[g>>2]=Ma()|0;Gb(25880,g|0)|0}}while(0);g=c[6398]|0;j=c[6400]|0;if(!(!(p!=+(g|0))?!(q!=+(j|0)):0)){qj(g,j);pj(m,d);rj(r)}Kf(Re(9)|0);Nf(Re(10)|0);c[6390]=c[(c[6394]|0)+876>>2];r=Pf()|0;c[6454]=r;c[r>>2]=25824;c[r+4>>2]=25840;c[r+8>>2]=11;c[r+12>>2]=3;c[r+20>>2]=36;c[r+16>>2]=12;t=0;i=f;return t|0}function dk(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0;a=i;i=i+1040|0;b=a;d=a+16|0;e=Ve()|0;f=Ze()|0;g=Hf(e)|0;h=bf()|0;if((f|0)<0){c[b>>2]=e;c[b+4>>2]=g;qm(d,25744,b)|0;Xa(d|0)|0;i=a;return}else{c[b>>2]=e;c[b+4>>2]=f;c[b+8>>2]=h;c[b+12>>2]=g;qm(d,25768,b)|0;Xa(d|0)|0;i=a;return}}function ek(){var a=0,b=0,d=0,e=0;a=i;b=c[(c[6394]|0)+236>>2]|0;if((b|0)==2){d=3}else if((b|0)==1){b=cf(Tj()|0)|0;c[(c[6394]|0)+236>>2]=b;d=3}if((d|0)==3?(df(Tj()|0)|0)!=0:0){i=a;return}ak();b=0;do{e=vf(25808)|0;b=b+1|0;if(((c[(c[6394]|0)+236>>2]|0)+ -1|0)>>>0<2){d=18;break}}while((b|0)<5e3);if((d|0)==18){i=a;return}if((e|0)==5){s=0;ta(5);d=s;s=0;if(!(d&1)){Xb(-1)}d=ub(-1,-1,0)|0;Qa(d|0)|0;oc();Xb(-1)}else if((e|0)==0){i=a;return}else{if((c[6392]|0)!=0){tj()|0;c[6392]=0}zd();a=c[6396]|0;if((a|0)==0){Xb(0)}s=0;oa(31,a|0);e=s;s=0;if(e&1){e=ub(-1,-1)|0;Tl(a);Cb(e|0)}Tl(a);c[6396]=0;Xb(0)}}function fk(){bk(c[6394]|0);pd(6,60,1);return 0}function gk(a,b){a=a|0;b=b|0;return-1}function hk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return-1}function ik(a){a=a|0;var b=0,d=0;b=i;if((Cm(a,25848)|0)!=0){if((Cm(a,25856)|0)==0){d=c[(c[6454]|0)+4>>2]|0}else{d=0}}else{d=c[c[6454]>>2]|0}i=b;return d|0}function jk(a,b){a=a|0;b=b|0;c[b>>2]=-1;return 0}function kk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;if((a|0)>1){e=c[b+4>>2]|0}else{e=25944}b=ck(e)|0;if((b|0)!=0){f=b;i=d;return f|0}f=fk()|0;i=d;return f|0}function lk(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=0;c[b+4>>2]=0;e=b+8|0;a[e>>0]=0;rc(8)|0;Kc(16)|0;if((_c(0,0,0,0)|0)==0){a[e>>0]=1;i=d;return}else{Ga(25952,25968,59,25992)}}function mk(a){a=a|0;var b=0;b=i;nk(a);if((rc(0)|0)!=0){do{ud()}while((rc(0)|0)!=0)}sb();i=b;return}function nk(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;b=i;d=a+4|0;e=c[d>>2]|0;if((e|0)==0){i=b;return}f=c[a>>2]|0;if((f|0)>0){g=f;f=0;h=e;while(1){if((h|0)==0){j=g}else{kd(c[h+36>>2]|0)|0;c[h+40>>2]=0;j=c[a>>2]|0}f=f+1|0;if((f|0)>=(j|0)){break}else{g=j;h=h+44|0}}h=c[d>>2]|0;if((j|0)>0){j=h;g=0;while(1){f=j+(g*44|0)|0;if((c[f>>2]|0)==1){if((f|0)!=0){kd(c[j+(g*44|0)+36>>2]|0)|0;c[j+(g*44|0)+40>>2]=0}cd(c[j+(g*44|0)+32>>2]|0);k=c[d>>2]|0}else{k=j}f=c[k+(g*44|0)+16>>2]|0;if((f|0)==0){l=k}else{Ml(f);l=c[d>>2]|0}c[l+(g*44|0)+16>>2]=0;g=g+1|0;f=c[d>>2]|0;if((g|0)>=(c[a>>2]|0)){m=f;break}else{j=f}}}else{m=h}}else{m=e}Oi(m);c[d>>2]=0;c[a>>2]=0;i=b;return}function ok(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;h=i;j=c[b>>2]|0;a:do{if((j|0)>0){k=b+4|0;l=c[k>>2]|0;m=0;while(1){n=m+1|0;if((c[l+(m*44|0)+8>>2]|0)==(d|0)){break}if((n|0)<(j|0)){m=n}else{o=6;break a}}if((m|0)>=0){n=l+(m*44|0)|0;if((c[n>>2]|0)==1){if((n|0)!=0){kd(c[l+(m*44|0)+36>>2]|0)|0;c[l+(m*44|0)+40>>2]=0}cd(c[l+(m*44|0)+32>>2]|0);p=c[k>>2]|0}else{p=l}n=c[p+(m*44|0)+16>>2]|0;if((n|0)==0){q=p}else{Ml(n);q=c[k>>2]|0}c[q+(m*44|0)+16>>2]=0;r=m}else{o=6}}else{o=6}}while(0);if((o|0)==6){if((a[b+8>>0]|0)==0){s=0;i=h;return s|0}o=j+1|0;c[b>>2]=o;q=o*44|0;o=b+4|0;p=c[o>>2]|0;if((p|0)==0){t=Mi(q)|0}else{t=Pi(p,q)|0}c[o>>2]=t;c[t+(j*44|0)>>2]=0;c[t+(j*44|0)+8>>2]=-1;c[t+(j*44|0)+36>>2]=-1;r=j}if((r|0)<0){s=0;i=h;return s|0}j=c[b+4>>2]|0;b=j+(r*44|0)|0;c[b>>2]=e;c[j+(r*44|0)+4>>2]=f;c[j+(r*44|0)+8>>2]=d;c[j+(r*44|0)+16>>2]=g;c[j+(r*44|0)+20>>2]=0;c[j+(r*44|0)+40>>2]=0;c[j+(r*44|0)+24>>2]=0;c[j+(r*44|0)+28>>2]=0;s=b;i=h;return s|0}function pk(a,b){a=a|0;b=b|0;b=i;nk(a);i=b;return}function qk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f;h=ok(a,d,1,e,0,0)|0;if((h|0)!=0){c[h+32>>2]=Mc(kb(b|0,26e3)|0,1)|0;c[h+36>>2]=-1}c[g>>2]=b;c[g+4>>2]=d;rl(26008,g);i=f;return 0}function rk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;e=c[a>>2]|0;if((e|0)<=0){f=1;i=d;return f|0}g=c[a+4>>2]|0;a=0;while(1){h=a+1|0;if((c[g+(a*44|0)+8>>2]|0)==(b|0)){break}if((h|0)<(e|0)){a=h}else{f=1;j=10;break}}if((j|0)==10){i=d;return f|0}if((a|0)<0){f=1;i=d;return f|0}j=g+(a*44|0)|0;if((c[j>>2]|0)!=1|(j|0)==0){f=0;i=d;return f|0}j=c[g+(a*44|0)+4>>2]|0;e=g+(a*44|0)+36|0;b=c[e>>2]|0;if((b|0)>-1){kd(b|0)|0}c[e>>2]=Hc(-1,c[g+(a*44|0)+32>>2]|0,j<<31>>31|0,-1)|0;c[g+(a*44|0)+40>>2]=0;f=0;i=d;return f|0}function sk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;f=c[a>>2]|0;if((f|0)<=0){i=e;return}g=c[a+4>>2]|0;a=0;while(1){h=a+1|0;if((c[g+(a*44|0)+8>>2]|0)==(b|0)){break}if((h|0)<(f|0)){a=h}else{j=8;break}}if((j|0)==8){i=e;return}if((a|0)<0){i=e;return}j=(d|0)>0?0:d;d=(j|0)<-1e3?-1e3:j;c[g+(a*44|0)+24>>2]=d;if((c[g+(a*44|0)>>2]|0)!=1){i=e;return}Ka(c[g+(a*44|0)+36>>2]|0,~~(+(d+1e3|0)/1.0e3*128.0)|0)|0;i=e;return}function tk(a,b,c){a=a|0;b=b|0;c=c|0;return}function uk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;f=c[a>>2]|0;a:do{if((f|0)>0){g=c[a+4>>2]|0;h=0;while(1){j=h+1|0;if((c[g+(h*44|0)+8>>2]|0)==(b|0)){break}if((j|0)<(f|0)){h=j}else{k=0;break a}}if((h|0)>=0?(c[g+(h*44|0)>>2]|0)==1:0){if((d|0)==0){k=c[g+(h*44|0)+4>>2]|0;break}else if((d|0)==2){k=c[g+(h*44|0)+28>>2]|0;break}else if((d|0)==1){k=c[g+(h*44|0)+24>>2]|0;break}else if((d|0)==16){j=(Ca(c[g+(h*44|0)+36>>2]|0)|0)!=0&1;i=e;return j|0}else{k=0;break}}else{k=0}}else{k=0}}while(0);i=e;return k|0}function vk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;e=c[a>>2]|0;f=(e|0)>0;if((b|0)<0){if(!f){i=d;return}g=e;h=0;j=c[a+4>>2]|0;while(1){if((j|0)==0){k=g}else{kd(c[j+36>>2]|0)|0;c[j+40>>2]=0;k=c[a>>2]|0}h=h+1|0;if((h|0)>=(k|0)){break}else{g=k;j=j+44|0}}i=d;return}if(!f){i=d;return}f=c[a+4>>2]|0;a=0;while(1){j=a+1|0;if((c[f+(a*44|0)+8>>2]|0)==(b|0)){break}if((j|0)<(e|0)){a=j}else{l=14;break}}if((l|0)==14){i=d;return}if((a|0)<0){i=d;return}if((f+(a*44|0)|0)==0){i=d;return}kd(c[f+(a*44|0)+36>>2]|0)|0;c[f+(a*44|0)+40>>2]=0;i=d;return}




// EMSCRIPTEN_END_FUNCS
var Fd=[rn,Dl,Cl,um,gf,qg,Kg,hh,qh,Ch,rn,rn,rn,rn,rn,rn];var Gd=[sn,Ae];var Hd=[tn,eg];var Id=[un,Il,Hl,un];var Jd=[vn,ff,ye,ve,jf,He,Fe,kf,ue,vn,vn,vn,vn,vn,vn,vn];var Kd=[wn,wl,Al,xl,yl,zl,Bl,Wl,Vl,Te,re,Oi,We,Ye,pf,Ne,Gh,lk,mk,Hh,Vi,tg,Ng,kh,th,Fh,qi,Gj,wi,le,bk,me];var Ld=[xn,Be];var Md=[yn,$f,kg,Me,Jf,sg,ug,vg,wg,xg,yg,zg,Ag,Bg,Cg,Dg,Eg,Mg,Og,Pg,Qg,Rg,Sg,Tg,Ug,Vg,Wg,Xg,Yg,Zg,_g,$g,ah,bh,jh,sh,uh,vh,wh,Eh,xi,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn,yn];var Nd=[zn,Xl,Gf,ge,ze,we,hf,jg,Ee,Mi,$e,af,Df,Cf,Bf,yf,nf,rf,Lf,Mf,If,Rf,Sf,Pe,og,pg,Ig,Jg,eh,fh,gh,oh,ph,zh,Ah,Bh,ik,Rl,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn,zn];var Od=[An,fg,Bn,mg,rg,Gg,Lg,dh,ih,mh,rh,yh,Dh,An,An,An];var Pd=[Cn,qe,qf,uf,ag,dk,ek,Cn];var Qd=[Dn,fe,lf,hk];var Rd=[En,Kl,Jl,En];var Sd=[Fn,Pi,Af,zf,of,Of,Uf,ig,ng,Hg,nh,gk,jk,Fn,Fn,Fn];var Td=[Gn,Ok,Pk,Qk,Rk,Sk,Gn,Gn];var Ud=[Hn,El,Fl,Je];return{_i64Subtract:Hm,_strcat:Pm,_free:Ml,_main:kk,_rand_r:Fm,_realloc:Ol,_i64Add:Im,_memmove:Nm,_strlen:Jm,_memset:Om,_malloc:Ll,_strncpy:Km,_memcpy:Mm,_bitshift64Lshr:Lm,_rand:Gm,_strcpy:Rm,_calloc:Nl,_bitshift64Shl:Qm,__GLOBAL__I_a:Xf,runPostSets:Em,stackAlloc:Vd,stackSave:Wd,stackRestore:Xd,setThrew:Yd,setTempRet0:$d,getTempRet0:ae,dynCall_iiii:an,dynCall_d:bn,dynCall_viiiiiii:cn,dynCall_viiiii:dn,dynCall_i:en,dynCall_vi:fn,dynCall_dd:gn,dynCall_vii:hn,dynCall_ii:jn,dynCall_viii:kn,dynCall_v:ln,dynCall_iiiii:mn,dynCall_viiiiii:nn,dynCall_iii:on,dynCall_iiiiii:pn,dynCall_viiii:qn}
// EMSCRIPTEN_END_ASM

})({"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array},{"abort":abort,"assert":assert,"asmPrintInt":asmPrintInt,"asmPrintFloat":asmPrintFloat,"min":Math_min,"invoke_iiii":invoke_iiii,"invoke_d":invoke_d,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiii":invoke_viiiii,"invoke_i":invoke_i,"invoke_vi":invoke_vi,"invoke_dd":invoke_dd,"invoke_vii":invoke_vii,"invoke_ii":invoke_ii,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_iiiii":invoke_iiiii,"invoke_viiiiii":invoke_viiiiii,"invoke_iii":invoke_iii,"invoke_iiiiii":invoke_iiiiii,"invoke_viiii":invoke_viiii,"_glUseProgram":_glUseProgram,"_fabs":_fabs,"_exp":_exp,"_Mix_Playing":_Mix_Playing,"_fread":_fread,"__ZSt9terminatev":__ZSt9terminatev,"_fmodl":_fmodl,"___assert_fail":___assert_fail,"_glDeleteProgram":_glDeleteProgram,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_glBindBuffer":_glBindBuffer,"_Mix_Volume":_Mix_Volume,"_fsync":_fsync,"_SDL_GetError":_SDL_GetError,"_sbrk":_sbrk,"_glBlendFunc":_glBlendFunc,"_glDisableVertexAttribArray":_glDisableVertexAttribArray,"___cxa_begin_catch":___cxa_begin_catch,"_glCreateShader":_glCreateShader,"_sysconf":_sysconf,"_close":_close,"_Mix_PlayMusic":_Mix_PlayMusic,"_cos":_cos,"_readdir":_readdir,"_puts":_puts,"_glLoadIdentity":_glLoadIdentity,"_glMatrixMode":_glMatrixMode,"_write":_write,"_ftell":_ftell,"_glShaderSource":_glShaderSource,"__ZNSt9exceptionD2Ev":__ZNSt9exceptionD2Ev,"___cxa_atexit":___cxa_atexit,"___cxa_does_inherit":___cxa_does_inherit,"_glVertexPointer":_glVertexPointer,"_glOrtho":_glOrtho,"_Mix_HaltMusic":_Mix_HaltMusic,"_mknod":_mknod,"_mkdir":_mkdir,"_closedir":_closedir,"_SDL_RWFromFile":_SDL_RWFromFile,"_glVertexAttribPointer":_glVertexAttribPointer,"_glHint":_glHint,"__reallyNegative":__reallyNegative,"_send":_send,"_SDL_GL_SetAttribute":_SDL_GL_SetAttribute,"_atan2":_atan2,"___cxa_is_number_type":___cxa_is_number_type,"_Mix_CloseAudio":_Mix_CloseAudio,"___cxa_free_exception":___cxa_free_exception,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_opendir":_opendir,"_SDL_LockSurface":_SDL_LockSurface,"_strerror_r":_strerror_r,"_glViewport":_glViewport,"_glGetBooleanv":_glGetBooleanv,"___setErrNo":___setErrNo,"_glDeleteTextures":_glDeleteTextures,"___resumeException":___resumeException,"_srand":_srand,"___cxa_call_unexpected":___cxa_call_unexpected,"_glEnable":_glEnable,"_printf":_printf,"_glGenTextures":_glGenTextures,"_glGetIntegerv":_glGetIntegerv,"_glGetString":_glGetString,"_localtime":_localtime,"_emscripten_get_now":_emscripten_get_now,"_stat":_stat,"_glAttachShader":_glAttachShader,"_read":_read,"_clock_gettime":_clock_gettime,"_SDL_SetVideoMode":_SDL_SetVideoMode,"_fwrite":_fwrite,"_time":_time,"_fprintf":_fprintf,"_glDetachShader":_glDetachShader,"_gettimeofday":_gettimeofday,"_pwrite":_pwrite,"_exit":_exit,"_readdir_r":_readdir_r,"_putenv":_putenv,"_llvm_pow_f64":_llvm_pow_f64,"_getcwd":_getcwd,"_IMG_Load":_IMG_Load,"_fmod":_fmod,"_lseek":_lseek,"___cxa_allocate_exception":___cxa_allocate_exception,"_getchar":_getchar,"___buildEnvironment":___buildEnvironment,"_glEnableClientState":_glEnableClientState,"_chdir":_chdir,"_localtime_r":_localtime_r,"_tzset":_tzset,"_open":_open,"_glClearColor":_glClearColor,"_glIsEnabled":_glIsEnabled,"_SDL_Init":_SDL_Init,"___cxa_end_catch":___cxa_end_catch,"_glGetFloatv":_glGetFloatv,"_Mix_PlayChannel":_Mix_PlayChannel,"_Mix_Init":_Mix_Init,"_glDrawArrays":_glDrawArrays,"_TTF_RenderText_Solid":_TTF_RenderText_Solid,"_fseek":_fseek,"_getenv":_getenv,"_fclose":_fclose,"_SDL_UpperBlit":_SDL_UpperBlit,"_log":_log,"_glActiveTexture":_glActiveTexture,"_glTexCoordPointer":_glTexCoordPointer,"_recv":_recv,"_tan":_tan,"_fgetc":_fgetc,"_glCompileShader":_glCompileShader,"_glEnableVertexAttribArray":_glEnableVertexAttribArray,"_abort":_abort,"_Mix_PlayChannelTimed":_Mix_PlayChannelTimed,"_glTexImage2D":_glTexImage2D,"_fopen":_fopen,"_Mix_ReserveChannels":_Mix_ReserveChannels,"_glDisableClientState":_glDisableClientState,"_Mix_LoadWAV_RW":_Mix_LoadWAV_RW,"_sin":_sin,"_SDL_GetTicks":_SDL_GetTicks,"_SDL_CloseAudio":_SDL_CloseAudio,"___gxx_personality_v0":___gxx_personality_v0,"_emscripten_asm_const_int":_emscripten_asm_const_int,"_glTexParameteri":_glTexParameteri,"_ungetc":_ungetc,"_glLinkProgram":_glLinkProgram,"_SDL_FreeRW":_SDL_FreeRW,"_glColorPointer":_glColorPointer,"_SDL_PauseAudio":_SDL_PauseAudio,"_llvm_eh_typeid_for":_llvm_eh_typeid_for,"_SDL_PollEvent":_SDL_PollEvent,"_Mix_OpenAudio":_Mix_OpenAudio,"_strerror":_strerror,"_glClear":_glClear,"_fileno":_fileno,"_Mix_FreeChunk":_Mix_FreeChunk,"_glBindTexture":_glBindTexture,"__exit":__exit,"_IMG_Load_RW":_IMG_Load_RW,"_glBindAttribLocation":_glBindAttribLocation,"_glPixelStorei":_glPixelStorei,"_unlink":_unlink,"_fputs":_fputs,"_Mix_HaltChannel":_Mix_HaltChannel,"_pread":_pread,"_mkport":_mkport,"_fflush":_fflush,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_emscripten_set_main_loop":_emscripten_set_main_loop,"___errno_location":___errno_location,"_copysign":_copysign,"_fputc":_fputc,"___cxa_throw":___cxa_throw,"_Mix_Quit":_Mix_Quit,"_copysignl":_copysignl,"_SDL_GL_SwapBuffers":_SDL_GL_SwapBuffers,"_glDisable":_glDisable,"_modf":_modf,"_emscripten_cancel_main_loop":_emscripten_cancel_main_loop,"__formatString":__formatString,"_atexit":_atexit,"_sqrt":_sqrt,"_SDL_RWFromConstMem":_SDL_RWFromConstMem,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"ctlz_i8":ctlz_i8,"___rand_seed":___rand_seed,"NaN":NaN,"Infinity":Infinity,"__ZTISt9exception":__ZTISt9exception,"___dso_handle":___dso_handle,"_stdin":_stdin},buffer);var _i64Subtract=Module["_i64Subtract"]=asm["_i64Subtract"];var _strcat=Module["_strcat"]=asm["_strcat"];var _free=Module["_free"]=asm["_free"];var _main=Module["_main"]=asm["_main"];var _rand_r=Module["_rand_r"]=asm["_rand_r"];var _realloc=Module["_realloc"]=asm["_realloc"];var _i64Add=Module["_i64Add"]=asm["_i64Add"];var _memmove=Module["_memmove"]=asm["_memmove"];var _strlen=Module["_strlen"]=asm["_strlen"];var _memset=Module["_memset"]=asm["_memset"];var _malloc=Module["_malloc"]=asm["_malloc"];var _strncpy=Module["_strncpy"]=asm["_strncpy"];var _memcpy=Module["_memcpy"]=asm["_memcpy"];var _bitshift64Lshr=Module["_bitshift64Lshr"]=asm["_bitshift64Lshr"];var _rand=Module["_rand"]=asm["_rand"];var _strcpy=Module["_strcpy"]=asm["_strcpy"];var _calloc=Module["_calloc"]=asm["_calloc"];var _bitshift64Shl=Module["_bitshift64Shl"]=asm["_bitshift64Shl"];var __GLOBAL__I_a=Module["__GLOBAL__I_a"]=asm["__GLOBAL__I_a"];var runPostSets=Module["runPostSets"]=asm["runPostSets"];var dynCall_iiii=Module["dynCall_iiii"]=asm["dynCall_iiii"];var dynCall_d=Module["dynCall_d"]=asm["dynCall_d"];var dynCall_viiiiiii=Module["dynCall_viiiiiii"]=asm["dynCall_viiiiiii"];var dynCall_viiiii=Module["dynCall_viiiii"]=asm["dynCall_viiiii"];var dynCall_i=Module["dynCall_i"]=asm["dynCall_i"];var dynCall_vi=Module["dynCall_vi"]=asm["dynCall_vi"];var dynCall_dd=Module["dynCall_dd"]=asm["dynCall_dd"];var dynCall_vii=Module["dynCall_vii"]=asm["dynCall_vii"];var dynCall_ii=Module["dynCall_ii"]=asm["dynCall_ii"];var dynCall_viii=Module["dynCall_viii"]=asm["dynCall_viii"];var dynCall_v=Module["dynCall_v"]=asm["dynCall_v"];var dynCall_iiiii=Module["dynCall_iiiii"]=asm["dynCall_iiiii"];var dynCall_viiiiii=Module["dynCall_viiiiii"]=asm["dynCall_viiiiii"];var dynCall_iii=Module["dynCall_iii"]=asm["dynCall_iii"];var dynCall_iiiiii=Module["dynCall_iiiiii"]=asm["dynCall_iiiiii"];var dynCall_viiii=Module["dynCall_viiii"]=asm["dynCall_viiii"];Runtime.stackAlloc=asm["stackAlloc"];Runtime.stackSave=asm["stackSave"];Runtime.stackRestore=asm["stackRestore"];Runtime.setTempRet0=asm["setTempRet0"];Runtime.getTempRet0=asm["getTempRet0"];var i64Math=(function(){var goog={math:{}};goog.math.Long=(function(low,high){this.low_=low|0;this.high_=high|0});goog.math.Long.IntCache_={};goog.math.Long.fromInt=(function(value){if(-128<=value&&value<128){var cachedObj=goog.math.Long.IntCache_[value];if(cachedObj){return cachedObj}}var obj=new goog.math.Long(value|0,value<0?-1:0);if(-128<=value&&value<128){goog.math.Long.IntCache_[value]=obj}return obj});goog.math.Long.fromNumber=(function(value){if(isNaN(value)||!isFinite(value)){return goog.math.Long.ZERO}else if(value<=-goog.math.Long.TWO_PWR_63_DBL_){return goog.math.Long.MIN_VALUE}else if(value+1>=goog.math.Long.TWO_PWR_63_DBL_){return goog.math.Long.MAX_VALUE}else if(value<0){return goog.math.Long.fromNumber(-value).negate()}else{return new goog.math.Long(value%goog.math.Long.TWO_PWR_32_DBL_|0,value/goog.math.Long.TWO_PWR_32_DBL_|0)}});goog.math.Long.fromBits=(function(lowBits,highBits){return new goog.math.Long(lowBits,highBits)});goog.math.Long.fromString=(function(str,opt_radix){if(str.length==0){throw Error("number format error: empty string")}var radix=opt_radix||10;if(radix<2||36<radix){throw Error("radix out of range: "+radix)}if(str.charAt(0)=="-"){return goog.math.Long.fromString(str.substring(1),radix).negate()}else if(str.indexOf("-")>=0){throw Error('number format error: interior "-" character: '+str)}var radixToPower=goog.math.Long.fromNumber(Math.pow(radix,8));var result=goog.math.Long.ZERO;for(var i=0;i<str.length;i+=8){var size=Math.min(8,str.length-i);var value=parseInt(str.substring(i,i+size),radix);if(size<8){var power=goog.math.Long.fromNumber(Math.pow(radix,size));result=result.multiply(power).add(goog.math.Long.fromNumber(value))}else{result=result.multiply(radixToPower);result=result.add(goog.math.Long.fromNumber(value))}}return result});goog.math.Long.TWO_PWR_16_DBL_=1<<16;goog.math.Long.TWO_PWR_24_DBL_=1<<24;goog.math.Long.TWO_PWR_32_DBL_=goog.math.Long.TWO_PWR_16_DBL_*goog.math.Long.TWO_PWR_16_DBL_;goog.math.Long.TWO_PWR_31_DBL_=goog.math.Long.TWO_PWR_32_DBL_/2;goog.math.Long.TWO_PWR_48_DBL_=goog.math.Long.TWO_PWR_32_DBL_*goog.math.Long.TWO_PWR_16_DBL_;goog.math.Long.TWO_PWR_64_DBL_=goog.math.Long.TWO_PWR_32_DBL_*goog.math.Long.TWO_PWR_32_DBL_;goog.math.Long.TWO_PWR_63_DBL_=goog.math.Long.TWO_PWR_64_DBL_/2;goog.math.Long.ZERO=goog.math.Long.fromInt(0);goog.math.Long.ONE=goog.math.Long.fromInt(1);goog.math.Long.NEG_ONE=goog.math.Long.fromInt(-1);goog.math.Long.MAX_VALUE=goog.math.Long.fromBits(4294967295|0,2147483647|0);goog.math.Long.MIN_VALUE=goog.math.Long.fromBits(0,2147483648|0);goog.math.Long.TWO_PWR_24_=goog.math.Long.fromInt(1<<24);goog.math.Long.prototype.toInt=(function(){return this.low_});goog.math.Long.prototype.toNumber=(function(){return this.high_*goog.math.Long.TWO_PWR_32_DBL_+this.getLowBitsUnsigned()});goog.math.Long.prototype.toString=(function(opt_radix){var radix=opt_radix||10;if(radix<2||36<radix){throw Error("radix out of range: "+radix)}if(this.isZero()){return"0"}if(this.isNegative()){if(this.equals(goog.math.Long.MIN_VALUE)){var radixLong=goog.math.Long.fromNumber(radix);var div=this.div(radixLong);var rem=div.multiply(radixLong).subtract(this);return div.toString(radix)+rem.toInt().toString(radix)}else{return"-"+this.negate().toString(radix)}}var radixToPower=goog.math.Long.fromNumber(Math.pow(radix,6));var rem=this;var result="";while(true){var remDiv=rem.div(radixToPower);var intval=rem.subtract(remDiv.multiply(radixToPower)).toInt();var digits=intval.toString(radix);rem=remDiv;if(rem.isZero()){return digits+result}else{while(digits.length<6){digits="0"+digits}result=""+digits+result}}});goog.math.Long.prototype.getHighBits=(function(){return this.high_});goog.math.Long.prototype.getLowBits=(function(){return this.low_});goog.math.Long.prototype.getLowBitsUnsigned=(function(){return this.low_>=0?this.low_:goog.math.Long.TWO_PWR_32_DBL_+this.low_});goog.math.Long.prototype.getNumBitsAbs=(function(){if(this.isNegative()){if(this.equals(goog.math.Long.MIN_VALUE)){return 64}else{return this.negate().getNumBitsAbs()}}else{var val=this.high_!=0?this.high_:this.low_;for(var bit=31;bit>0;bit--){if((val&1<<bit)!=0){break}}return this.high_!=0?bit+33:bit+1}});goog.math.Long.prototype.isZero=(function(){return this.high_==0&&this.low_==0});goog.math.Long.prototype.isNegative=(function(){return this.high_<0});goog.math.Long.prototype.isOdd=(function(){return(this.low_&1)==1});goog.math.Long.prototype.equals=(function(other){return this.high_==other.high_&&this.low_==other.low_});goog.math.Long.prototype.notEquals=(function(other){return this.high_!=other.high_||this.low_!=other.low_});goog.math.Long.prototype.lessThan=(function(other){return this.compare(other)<0});goog.math.Long.prototype.lessThanOrEqual=(function(other){return this.compare(other)<=0});goog.math.Long.prototype.greaterThan=(function(other){return this.compare(other)>0});goog.math.Long.prototype.greaterThanOrEqual=(function(other){return this.compare(other)>=0});goog.math.Long.prototype.compare=(function(other){if(this.equals(other)){return 0}var thisNeg=this.isNegative();var otherNeg=other.isNegative();if(thisNeg&&!otherNeg){return-1}if(!thisNeg&&otherNeg){return 1}if(this.subtract(other).isNegative()){return-1}else{return 1}});goog.math.Long.prototype.negate=(function(){if(this.equals(goog.math.Long.MIN_VALUE)){return goog.math.Long.MIN_VALUE}else{return this.not().add(goog.math.Long.ONE)}});goog.math.Long.prototype.add=(function(other){var a48=this.high_>>>16;var a32=this.high_&65535;var a16=this.low_>>>16;var a00=this.low_&65535;var b48=other.high_>>>16;var b32=other.high_&65535;var b16=other.low_>>>16;var b00=other.low_&65535;var c48=0,c32=0,c16=0,c00=0;c00+=a00+b00;c16+=c00>>>16;c00&=65535;c16+=a16+b16;c32+=c16>>>16;c16&=65535;c32+=a32+b32;c48+=c32>>>16;c32&=65535;c48+=a48+b48;c48&=65535;return goog.math.Long.fromBits(c16<<16|c00,c48<<16|c32)});goog.math.Long.prototype.subtract=(function(other){return this.add(other.negate())});goog.math.Long.prototype.multiply=(function(other){if(this.isZero()){return goog.math.Long.ZERO}else if(other.isZero()){return goog.math.Long.ZERO}if(this.equals(goog.math.Long.MIN_VALUE)){return other.isOdd()?goog.math.Long.MIN_VALUE:goog.math.Long.ZERO}else if(other.equals(goog.math.Long.MIN_VALUE)){return this.isOdd()?goog.math.Long.MIN_VALUE:goog.math.Long.ZERO}if(this.isNegative()){if(other.isNegative()){return this.negate().multiply(other.negate())}else{return this.negate().multiply(other).negate()}}else if(other.isNegative()){return this.multiply(other.negate()).negate()}if(this.lessThan(goog.math.Long.TWO_PWR_24_)&&other.lessThan(goog.math.Long.TWO_PWR_24_)){return goog.math.Long.fromNumber(this.toNumber()*other.toNumber())}var a48=this.high_>>>16;var a32=this.high_&65535;var a16=this.low_>>>16;var a00=this.low_&65535;var b48=other.high_>>>16;var b32=other.high_&65535;var b16=other.low_>>>16;var b00=other.low_&65535;var c48=0,c32=0,c16=0,c00=0;c00+=a00*b00;c16+=c00>>>16;c00&=65535;c16+=a16*b00;c32+=c16>>>16;c16&=65535;c16+=a00*b16;c32+=c16>>>16;c16&=65535;c32+=a32*b00;c48+=c32>>>16;c32&=65535;c32+=a16*b16;c48+=c32>>>16;c32&=65535;c32+=a00*b32;c48+=c32>>>16;c32&=65535;c48+=a48*b00+a32*b16+a16*b32+a00*b48;c48&=65535;return goog.math.Long.fromBits(c16<<16|c00,c48<<16|c32)});goog.math.Long.prototype.div=(function(other){if(other.isZero()){throw Error("division by zero")}else if(this.isZero()){return goog.math.Long.ZERO}if(this.equals(goog.math.Long.MIN_VALUE)){if(other.equals(goog.math.Long.ONE)||other.equals(goog.math.Long.NEG_ONE)){return goog.math.Long.MIN_VALUE}else if(other.equals(goog.math.Long.MIN_VALUE)){return goog.math.Long.ONE}else{var halfThis=this.shiftRight(1);var approx=halfThis.div(other).shiftLeft(1);if(approx.equals(goog.math.Long.ZERO)){return other.isNegative()?goog.math.Long.ONE:goog.math.Long.NEG_ONE}else{var rem=this.subtract(other.multiply(approx));var result=approx.add(rem.div(other));return result}}}else if(other.equals(goog.math.Long.MIN_VALUE)){return goog.math.Long.ZERO}if(this.isNegative()){if(other.isNegative()){return this.negate().div(other.negate())}else{return this.negate().div(other).negate()}}else if(other.isNegative()){return this.div(other.negate()).negate()}var res=goog.math.Long.ZERO;var rem=this;while(rem.greaterThanOrEqual(other)){var approx=Math.max(1,Math.floor(rem.toNumber()/other.toNumber()));var log2=Math.ceil(Math.log(approx)/Math.LN2);var delta=log2<=48?1:Math.pow(2,log2-48);var approxRes=goog.math.Long.fromNumber(approx);var approxRem=approxRes.multiply(other);while(approxRem.isNegative()||approxRem.greaterThan(rem)){approx-=delta;approxRes=goog.math.Long.fromNumber(approx);approxRem=approxRes.multiply(other)}if(approxRes.isZero()){approxRes=goog.math.Long.ONE}res=res.add(approxRes);rem=rem.subtract(approxRem)}return res});goog.math.Long.prototype.modulo=(function(other){return this.subtract(this.div(other).multiply(other))});goog.math.Long.prototype.not=(function(){return goog.math.Long.fromBits(~this.low_,~this.high_)});goog.math.Long.prototype.and=(function(other){return goog.math.Long.fromBits(this.low_&other.low_,this.high_&other.high_)});goog.math.Long.prototype.or=(function(other){return goog.math.Long.fromBits(this.low_|other.low_,this.high_|other.high_)});goog.math.Long.prototype.xor=(function(other){return goog.math.Long.fromBits(this.low_^other.low_,this.high_^other.high_)});goog.math.Long.prototype.shiftLeft=(function(numBits){numBits&=63;if(numBits==0){return this}else{var low=this.low_;if(numBits<32){var high=this.high_;return goog.math.Long.fromBits(low<<numBits,high<<numBits|low>>>32-numBits)}else{return goog.math.Long.fromBits(0,low<<numBits-32)}}});goog.math.Long.prototype.shiftRight=(function(numBits){numBits&=63;if(numBits==0){return this}else{var high=this.high_;if(numBits<32){var low=this.low_;return goog.math.Long.fromBits(low>>>numBits|high<<32-numBits,high>>numBits)}else{return goog.math.Long.fromBits(high>>numBits-32,high>=0?0:-1)}}});goog.math.Long.prototype.shiftRightUnsigned=(function(numBits){numBits&=63;if(numBits==0){return this}else{var high=this.high_;if(numBits<32){var low=this.low_;return goog.math.Long.fromBits(low>>>numBits|high<<32-numBits,high>>>numBits)}else if(numBits==32){return goog.math.Long.fromBits(high,0)}else{return goog.math.Long.fromBits(high>>>numBits-32,0)}}});var navigator={appName:"Modern Browser"};var dbits;var canary=0xdeadbeefcafe;var j_lm=(canary&16777215)==15715070;function BigInteger(a,b,c){if(a!=null)if("number"==typeof a)this.fromNumber(a,b,c);else if(b==null&&"string"!=typeof a)this.fromString(a,256);else this.fromString(a,b)}function nbi(){return new BigInteger(null)}function am1(i,x,w,j,c,n){while(--n>=0){var v=x*this[i++]+w[j]+c;c=Math.floor(v/67108864);w[j++]=v&67108863}return c}function am2(i,x,w,j,c,n){var xl=x&32767,xh=x>>15;while(--n>=0){var l=this[i]&32767;var h=this[i++]>>15;var m=xh*l+h*xl;l=xl*l+((m&32767)<<15)+w[j]+(c&1073741823);c=(l>>>30)+(m>>>15)+xh*h+(c>>>30);w[j++]=l&1073741823}return c}function am3(i,x,w,j,c,n){var xl=x&16383,xh=x>>14;while(--n>=0){var l=this[i]&16383;var h=this[i++]>>14;var m=xh*l+h*xl;l=xl*l+((m&16383)<<14)+w[j]+c;c=(l>>28)+(m>>14)+xh*h;w[j++]=l&268435455}return c}if(j_lm&&navigator.appName=="Microsoft Internet Explorer"){BigInteger.prototype.am=am2;dbits=30}else if(j_lm&&navigator.appName!="Netscape"){BigInteger.prototype.am=am1;dbits=26}else{BigInteger.prototype.am=am3;dbits=28}BigInteger.prototype.DB=dbits;BigInteger.prototype.DM=(1<<dbits)-1;BigInteger.prototype.DV=1<<dbits;var BI_FP=52;BigInteger.prototype.FV=Math.pow(2,BI_FP);BigInteger.prototype.F1=BI_FP-dbits;BigInteger.prototype.F2=2*dbits-BI_FP;var BI_RM="0123456789abcdefghijklmnopqrstuvwxyz";var BI_RC=new Array;var rr,vv;rr="0".charCodeAt(0);for(vv=0;vv<=9;++vv)BI_RC[rr++]=vv;rr="a".charCodeAt(0);for(vv=10;vv<36;++vv)BI_RC[rr++]=vv;rr="A".charCodeAt(0);for(vv=10;vv<36;++vv)BI_RC[rr++]=vv;function int2char(n){return BI_RM.charAt(n)}function intAt(s,i){var c=BI_RC[s.charCodeAt(i)];return c==null?-1:c}function bnpCopyTo(r){for(var i=this.t-1;i>=0;--i)r[i]=this[i];r.t=this.t;r.s=this.s}function bnpFromInt(x){this.t=1;this.s=x<0?-1:0;if(x>0)this[0]=x;else if(x<-1)this[0]=x+DV;else this.t=0}function nbv(i){var r=nbi();r.fromInt(i);return r}function bnpFromString(s,b){var k;if(b==16)k=4;else if(b==8)k=3;else if(b==256)k=8;else if(b==2)k=1;else if(b==32)k=5;else if(b==4)k=2;else{this.fromRadix(s,b);return}this.t=0;this.s=0;var i=s.length,mi=false,sh=0;while(--i>=0){var x=k==8?s[i]&255:intAt(s,i);if(x<0){if(s.charAt(i)=="-")mi=true;continue}mi=false;if(sh==0)this[this.t++]=x;else if(sh+k>this.DB){this[this.t-1]|=(x&(1<<this.DB-sh)-1)<<sh;this[this.t++]=x>>this.DB-sh}else this[this.t-1]|=x<<sh;sh+=k;if(sh>=this.DB)sh-=this.DB}if(k==8&&(s[0]&128)!=0){this.s=-1;if(sh>0)this[this.t-1]|=(1<<this.DB-sh)-1<<sh}this.clamp();if(mi)BigInteger.ZERO.subTo(this,this)}function bnpClamp(){var c=this.s&this.DM;while(this.t>0&&this[this.t-1]==c)--this.t}function bnToString(b){if(this.s<0)return"-"+this.negate().toString(b);var k;if(b==16)k=4;else if(b==8)k=3;else if(b==2)k=1;else if(b==32)k=5;else if(b==4)k=2;else return this.toRadix(b);var km=(1<<k)-1,d,m=false,r="",i=this.t;var p=this.DB-i*this.DB%k;if(i-->0){if(p<this.DB&&(d=this[i]>>p)>0){m=true;r=int2char(d)}while(i>=0){if(p<k){d=(this[i]&(1<<p)-1)<<k-p;d|=this[--i]>>(p+=this.DB-k)}else{d=this[i]>>(p-=k)&km;if(p<=0){p+=this.DB;--i}}if(d>0)m=true;if(m)r+=int2char(d)}}return m?r:"0"}function bnNegate(){var r=nbi();BigInteger.ZERO.subTo(this,r);return r}function bnAbs(){return this.s<0?this.negate():this}function bnCompareTo(a){var r=this.s-a.s;if(r!=0)return r;var i=this.t;r=i-a.t;if(r!=0)return this.s<0?-r:r;while(--i>=0)if((r=this[i]-a[i])!=0)return r;return 0}function nbits(x){var r=1,t;if((t=x>>>16)!=0){x=t;r+=16}if((t=x>>8)!=0){x=t;r+=8}if((t=x>>4)!=0){x=t;r+=4}if((t=x>>2)!=0){x=t;r+=2}if((t=x>>1)!=0){x=t;r+=1}return r}function bnBitLength(){if(this.t<=0)return 0;return this.DB*(this.t-1)+nbits(this[this.t-1]^this.s&this.DM)}function bnpDLShiftTo(n,r){var i;for(i=this.t-1;i>=0;--i)r[i+n]=this[i];for(i=n-1;i>=0;--i)r[i]=0;r.t=this.t+n;r.s=this.s}function bnpDRShiftTo(n,r){for(var i=n;i<this.t;++i)r[i-n]=this[i];r.t=Math.max(this.t-n,0);r.s=this.s}function bnpLShiftTo(n,r){var bs=n%this.DB;var cbs=this.DB-bs;var bm=(1<<cbs)-1;var ds=Math.floor(n/this.DB),c=this.s<<bs&this.DM,i;for(i=this.t-1;i>=0;--i){r[i+ds+1]=this[i]>>cbs|c;c=(this[i]&bm)<<bs}for(i=ds-1;i>=0;--i)r[i]=0;r[ds]=c;r.t=this.t+ds+1;r.s=this.s;r.clamp()}function bnpRShiftTo(n,r){r.s=this.s;var ds=Math.floor(n/this.DB);if(ds>=this.t){r.t=0;return}var bs=n%this.DB;var cbs=this.DB-bs;var bm=(1<<bs)-1;r[0]=this[ds]>>bs;for(var i=ds+1;i<this.t;++i){r[i-ds-1]|=(this[i]&bm)<<cbs;r[i-ds]=this[i]>>bs}if(bs>0)r[this.t-ds-1]|=(this.s&bm)<<cbs;r.t=this.t-ds;r.clamp()}function bnpSubTo(a,r){var i=0,c=0,m=Math.min(a.t,this.t);while(i<m){c+=this[i]-a[i];r[i++]=c&this.DM;c>>=this.DB}if(a.t<this.t){c-=a.s;while(i<this.t){c+=this[i];r[i++]=c&this.DM;c>>=this.DB}c+=this.s}else{c+=this.s;while(i<a.t){c-=a[i];r[i++]=c&this.DM;c>>=this.DB}c-=a.s}r.s=c<0?-1:0;if(c<-1)r[i++]=this.DV+c;else if(c>0)r[i++]=c;r.t=i;r.clamp()}function bnpMultiplyTo(a,r){var x=this.abs(),y=a.abs();var i=x.t;r.t=i+y.t;while(--i>=0)r[i]=0;for(i=0;i<y.t;++i)r[i+x.t]=x.am(0,y[i],r,i,0,x.t);r.s=0;r.clamp();if(this.s!=a.s)BigInteger.ZERO.subTo(r,r)}function bnpSquareTo(r){var x=this.abs();var i=r.t=2*x.t;while(--i>=0)r[i]=0;for(i=0;i<x.t-1;++i){var c=x.am(i,x[i],r,2*i,0,1);if((r[i+x.t]+=x.am(i+1,2*x[i],r,2*i+1,c,x.t-i-1))>=x.DV){r[i+x.t]-=x.DV;r[i+x.t+1]=1}}if(r.t>0)r[r.t-1]+=x.am(i,x[i],r,2*i,0,1);r.s=0;r.clamp()}function bnpDivRemTo(m,q,r){var pm=m.abs();if(pm.t<=0)return;var pt=this.abs();if(pt.t<pm.t){if(q!=null)q.fromInt(0);if(r!=null)this.copyTo(r);return}if(r==null)r=nbi();var y=nbi(),ts=this.s,ms=m.s;var nsh=this.DB-nbits(pm[pm.t-1]);if(nsh>0){pm.lShiftTo(nsh,y);pt.lShiftTo(nsh,r)}else{pm.copyTo(y);pt.copyTo(r)}var ys=y.t;var y0=y[ys-1];if(y0==0)return;var yt=y0*(1<<this.F1)+(ys>1?y[ys-2]>>this.F2:0);var d1=this.FV/yt,d2=(1<<this.F1)/yt,e=1<<this.F2;var i=r.t,j=i-ys,t=q==null?nbi():q;y.dlShiftTo(j,t);if(r.compareTo(t)>=0){r[r.t++]=1;r.subTo(t,r)}BigInteger.ONE.dlShiftTo(ys,t);t.subTo(y,y);while(y.t<ys)y[y.t++]=0;while(--j>=0){var qd=r[--i]==y0?this.DM:Math.floor(r[i]*d1+(r[i-1]+e)*d2);if((r[i]+=y.am(0,qd,r,j,0,ys))<qd){y.dlShiftTo(j,t);r.subTo(t,r);while(r[i]<--qd)r.subTo(t,r)}}if(q!=null){r.drShiftTo(ys,q);if(ts!=ms)BigInteger.ZERO.subTo(q,q)}r.t=ys;r.clamp();if(nsh>0)r.rShiftTo(nsh,r);if(ts<0)BigInteger.ZERO.subTo(r,r)}function bnMod(a){var r=nbi();this.abs().divRemTo(a,null,r);if(this.s<0&&r.compareTo(BigInteger.ZERO)>0)a.subTo(r,r);return r}function Classic(m){this.m=m}function cConvert(x){if(x.s<0||x.compareTo(this.m)>=0)return x.mod(this.m);else return x}function cRevert(x){return x}function cReduce(x){x.divRemTo(this.m,null,x)}function cMulTo(x,y,r){x.multiplyTo(y,r);this.reduce(r)}function cSqrTo(x,r){x.squareTo(r);this.reduce(r)}Classic.prototype.convert=cConvert;Classic.prototype.revert=cRevert;Classic.prototype.reduce=cReduce;Classic.prototype.mulTo=cMulTo;Classic.prototype.sqrTo=cSqrTo;function bnpInvDigit(){if(this.t<1)return 0;var x=this[0];if((x&1)==0)return 0;var y=x&3;y=y*(2-(x&15)*y)&15;y=y*(2-(x&255)*y)&255;y=y*(2-((x&65535)*y&65535))&65535;y=y*(2-x*y%this.DV)%this.DV;return y>0?this.DV-y:-y}function Montgomery(m){this.m=m;this.mp=m.invDigit();this.mpl=this.mp&32767;this.mph=this.mp>>15;this.um=(1<<m.DB-15)-1;this.mt2=2*m.t}function montConvert(x){var r=nbi();x.abs().dlShiftTo(this.m.t,r);r.divRemTo(this.m,null,r);if(x.s<0&&r.compareTo(BigInteger.ZERO)>0)this.m.subTo(r,r);return r}function montRevert(x){var r=nbi();x.copyTo(r);this.reduce(r);return r}function montReduce(x){while(x.t<=this.mt2)x[x.t++]=0;for(var i=0;i<this.m.t;++i){var j=x[i]&32767;var u0=j*this.mpl+((j*this.mph+(x[i]>>15)*this.mpl&this.um)<<15)&x.DM;j=i+this.m.t;x[j]+=this.m.am(0,u0,x,i,0,this.m.t);while(x[j]>=x.DV){x[j]-=x.DV;x[++j]++}}x.clamp();x.drShiftTo(this.m.t,x);if(x.compareTo(this.m)>=0)x.subTo(this.m,x)}function montSqrTo(x,r){x.squareTo(r);this.reduce(r)}function montMulTo(x,y,r){x.multiplyTo(y,r);this.reduce(r)}Montgomery.prototype.convert=montConvert;Montgomery.prototype.revert=montRevert;Montgomery.prototype.reduce=montReduce;Montgomery.prototype.mulTo=montMulTo;Montgomery.prototype.sqrTo=montSqrTo;function bnpIsEven(){return(this.t>0?this[0]&1:this.s)==0}function bnpExp(e,z){if(e>4294967295||e<1)return BigInteger.ONE;var r=nbi(),r2=nbi(),g=z.convert(this),i=nbits(e)-1;g.copyTo(r);while(--i>=0){z.sqrTo(r,r2);if((e&1<<i)>0)z.mulTo(r2,g,r);else{var t=r;r=r2;r2=t}}return z.revert(r)}function bnModPowInt(e,m){var z;if(e<256||m.isEven())z=new Classic(m);else z=new Montgomery(m);return this.exp(e,z)}BigInteger.prototype.copyTo=bnpCopyTo;BigInteger.prototype.fromInt=bnpFromInt;BigInteger.prototype.fromString=bnpFromString;BigInteger.prototype.clamp=bnpClamp;BigInteger.prototype.dlShiftTo=bnpDLShiftTo;BigInteger.prototype.drShiftTo=bnpDRShiftTo;BigInteger.prototype.lShiftTo=bnpLShiftTo;BigInteger.prototype.rShiftTo=bnpRShiftTo;BigInteger.prototype.subTo=bnpSubTo;BigInteger.prototype.multiplyTo=bnpMultiplyTo;BigInteger.prototype.squareTo=bnpSquareTo;BigInteger.prototype.divRemTo=bnpDivRemTo;BigInteger.prototype.invDigit=bnpInvDigit;BigInteger.prototype.isEven=bnpIsEven;BigInteger.prototype.exp=bnpExp;BigInteger.prototype.toString=bnToString;BigInteger.prototype.negate=bnNegate;BigInteger.prototype.abs=bnAbs;BigInteger.prototype.compareTo=bnCompareTo;BigInteger.prototype.bitLength=bnBitLength;BigInteger.prototype.mod=bnMod;BigInteger.prototype.modPowInt=bnModPowInt;BigInteger.ZERO=nbv(0);BigInteger.ONE=nbv(1);function bnpFromRadix(s,b){this.fromInt(0);if(b==null)b=10;var cs=this.chunkSize(b);var d=Math.pow(b,cs),mi=false,j=0,w=0;for(var i=0;i<s.length;++i){var x=intAt(s,i);if(x<0){if(s.charAt(i)=="-"&&this.signum()==0)mi=true;continue}w=b*w+x;if(++j>=cs){this.dMultiply(d);this.dAddOffset(w,0);j=0;w=0}}if(j>0){this.dMultiply(Math.pow(b,j));this.dAddOffset(w,0)}if(mi)BigInteger.ZERO.subTo(this,this)}function bnpChunkSize(r){return Math.floor(Math.LN2*this.DB/Math.log(r))}function bnSigNum(){if(this.s<0)return-1;else if(this.t<=0||this.t==1&&this[0]<=0)return 0;else return 1}function bnpDMultiply(n){this[this.t]=this.am(0,n-1,this,0,0,this.t);++this.t;this.clamp()}function bnpDAddOffset(n,w){if(n==0)return;while(this.t<=w)this[this.t++]=0;this[w]+=n;while(this[w]>=this.DV){this[w]-=this.DV;if(++w>=this.t)this[this.t++]=0;++this[w]}}function bnpToRadix(b){if(b==null)b=10;if(this.signum()==0||b<2||b>36)return"0";var cs=this.chunkSize(b);var a=Math.pow(b,cs);var d=nbv(a),y=nbi(),z=nbi(),r="";this.divRemTo(d,y,z);while(y.signum()>0){r=(a+z.intValue()).toString(b).substr(1)+r;y.divRemTo(d,y,z)}return z.intValue().toString(b)+r}function bnIntValue(){if(this.s<0){if(this.t==1)return this[0]-this.DV;else if(this.t==0)return-1}else if(this.t==1)return this[0];else if(this.t==0)return 0;return(this[1]&(1<<32-this.DB)-1)<<this.DB|this[0]}function bnpAddTo(a,r){var i=0,c=0,m=Math.min(a.t,this.t);while(i<m){c+=this[i]+a[i];r[i++]=c&this.DM;c>>=this.DB}if(a.t<this.t){c+=a.s;while(i<this.t){c+=this[i];r[i++]=c&this.DM;c>>=this.DB}c+=this.s}else{c+=this.s;while(i<a.t){c+=a[i];r[i++]=c&this.DM;c>>=this.DB}c+=a.s}r.s=c<0?-1:0;if(c>0)r[i++]=c;else if(c<-1)r[i++]=this.DV+c;r.t=i;r.clamp()}BigInteger.prototype.fromRadix=bnpFromRadix;BigInteger.prototype.chunkSize=bnpChunkSize;BigInteger.prototype.signum=bnSigNum;BigInteger.prototype.dMultiply=bnpDMultiply;BigInteger.prototype.dAddOffset=bnpDAddOffset;BigInteger.prototype.toRadix=bnpToRadix;BigInteger.prototype.intValue=bnIntValue;BigInteger.prototype.addTo=bnpAddTo;var Wrapper={abs:(function(l,h){var x=new goog.math.Long(l,h);var ret;if(x.isNegative()){ret=x.negate()}else{ret=x}HEAP32[tempDoublePtr>>2]=ret.low_;HEAP32[tempDoublePtr+4>>2]=ret.high_}),ensureTemps:(function(){if(Wrapper.ensuredTemps)return;Wrapper.ensuredTemps=true;Wrapper.two32=new BigInteger;Wrapper.two32.fromString("4294967296",10);Wrapper.two64=new BigInteger;Wrapper.two64.fromString("18446744073709551616",10);Wrapper.temp1=new BigInteger;Wrapper.temp2=new BigInteger}),lh2bignum:(function(l,h){var a=new BigInteger;a.fromString(h.toString(),10);var b=new BigInteger;a.multiplyTo(Wrapper.two32,b);var c=new BigInteger;c.fromString(l.toString(),10);var d=new BigInteger;c.addTo(b,d);return d}),stringify:(function(l,h,unsigned){var ret=(new goog.math.Long(l,h)).toString();if(unsigned&&ret[0]=="-"){Wrapper.ensureTemps();var bignum=new BigInteger;bignum.fromString(ret,10);ret=new BigInteger;Wrapper.two64.addTo(bignum,ret);ret=ret.toString(10)}return ret}),fromString:(function(str,base,min,max,unsigned){Wrapper.ensureTemps();var bignum=new BigInteger;bignum.fromString(str,base);var bigmin=new BigInteger;bigmin.fromString(min,10);var bigmax=new BigInteger;bigmax.fromString(max,10);if(unsigned&&bignum.compareTo(BigInteger.ZERO)<0){var temp=new BigInteger;bignum.addTo(Wrapper.two64,temp);bignum=temp}var error=false;if(bignum.compareTo(bigmin)<0){bignum=bigmin;error=true}else if(bignum.compareTo(bigmax)>0){bignum=bigmax;error=true}var ret=goog.math.Long.fromString(bignum.toString());HEAP32[tempDoublePtr>>2]=ret.low_;HEAP32[tempDoublePtr+4>>2]=ret.high_;if(error)throw"range error"})};return Wrapper})();if(memoryInitializer){if(ENVIRONMENT_IS_NODE||ENVIRONMENT_IS_SHELL){var data=Module["readBinary"](memoryInitializer);HEAPU8.set(data,STATIC_BASE)}else{addRunDependency("memory initializer");Browser.asyncLoad(memoryInitializer,(function(data){HEAPU8.set(data,STATIC_BASE);removeRunDependency("memory initializer")}),(function(data){throw"could not load memory initializer "+memoryInitializer}))}}function ExitStatus(status){this.name="ExitStatus";this.message="Program terminated with exit("+status+")";this.status=status}ExitStatus.prototype=new Error;ExitStatus.prototype.constructor=ExitStatus;var initialStackTop;var preloadStartTime=null;var calledMain=false;dependenciesFulfilled=function runCaller(){if(!Module["calledRun"]&&shouldRunNow)run();if(!Module["calledRun"])dependenciesFulfilled=runCaller};Module["callMain"]=Module.callMain=function callMain(args){assert(runDependencies==0,"cannot call main when async dependencies remain! (listen on __ATMAIN__)");assert(__ATPRERUN__.length==0,"cannot call main when preRun functions remain to be called");args=args||[];ensureInitRuntime();var argc=args.length+1;function pad(){for(var i=0;i<4-1;i++){argv.push(0)}}var argv=[allocate(intArrayFromString(Module["thisProgram"]||"/bin/this.program"),"i8",ALLOC_NORMAL)];pad();for(var i=0;i<argc-1;i=i+1){argv.push(allocate(intArrayFromString(args[i]),"i8",ALLOC_NORMAL));pad()}argv.push(0);argv=allocate(argv,"i32",ALLOC_NORMAL);initialStackTop=STACKTOP;try{var ret=Module["_main"](argc,argv,0);if(!Module["noExitRuntime"]){exit(ret)}}catch(e){if(e instanceof ExitStatus){return}else if(e=="SimulateInfiniteLoop"){Module["noExitRuntime"]=true;return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}finally{calledMain=true}};function run(args){args=args||Module["arguments"];if(preloadStartTime===null)preloadStartTime=Date.now();if(runDependencies>0){Module.printErr("run() called, but dependencies remain, so not running");return}preRun();if(runDependencies>0)return;if(Module["calledRun"])return;function doRun(){if(Module["calledRun"])return;Module["calledRun"]=true;ensureInitRuntime();preMain();if(ENVIRONMENT_IS_WEB&&preloadStartTime!==null){Module.printErr("pre-main prep time: "+(Date.now()-preloadStartTime)+" ms")}if(Module["_main"]&&shouldRunNow){Module["callMain"](args)}postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout((function(){setTimeout((function(){Module["setStatus"]("")}),1);if(!ABORT)doRun()}),1)}else{doRun()}}Module["run"]=Module.run=run;function exit(status){ABORT=true;EXITSTATUS=status;STACKTOP=initialStackTop;exitRuntime();throw new ExitStatus(status)}Module["exit"]=Module.exit=exit;function abort(text){if(text){Module.print(text);Module.printErr(text)}ABORT=true;EXITSTATUS=1;var extra="\nIf this abort() is unexpected, build with -s ASSERTIONS=1 which can give more information.";throw"abort() at "+stackTrace()+extra}Module["abort"]=Module.abort=abort;if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}var shouldRunNow=true;if(Module["noInitialRun"]){shouldRunNow=false}run()




