/*
 * $Id: JumpTask.java,v 1.3 2006/01/13 20:32:10 Yuki Exp $
 */
package hsplet;

import hsplet.function.JumpStatement;
import hsplet.function.ProgramCommand;

/**
 * {^L[͂ȂǂɂĔ銄荞݃Wv^XNB
 * 
 * @author Yuki
 * @version $Revision: 1.3 $, $Date: 2006/01/13 20:32:10 $
 */
public class JumpTask implements Task {

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: JumpTask.java,v 1.3 2006/01/13 20:32:10 Yuki Exp $";

	/** 񉻕ɁAf[^̌݊mF邽߂̃o[WԍB */
	private static final long serialVersionUID = -6548767826568493395L;

	private final JumpStatement jump;

	private final int label;

	private final Integer iparam;

	private final Integer wparam;

	private final Integer lparam;

	/**
	 * IuWFNg\zB
	 * @param jump Wv̎ށB
	 * @param label Wv惉xB
	 * @param iparam VXeϐ iparam ɃZbglB
	 * ZbgKvƂ nullB
	 * @param wparam VXeϐ wparam ɃZbglB
	 * ZbgKvƂ nullB
	 * @param lparam VXeϐ lparam ɃZbglB
	 * ZbgKvƂ nullB
	 */
	public JumpTask(final JumpStatement jump, final int label,
			final Integer iparam, final Integer wparam, final Integer lparam) {

		this.jump = jump;
		this.label = label;
		this.iparam = iparam;
		this.wparam = wparam;
		this.lparam = lparam;
	}

	public void run(Context context) {

		if (iparam != null) {
			context.iparam.value = iparam.intValue();
		}
		if (lparam != null) {
			context.lparam.value = lparam.intValue();
		}
		if (wparam != null) {
			context.wparam.value = wparam.intValue();
		}

		if ( jump==JumpStatement.Goto ){
			ProgramCommand.goto_(context, label, true);
		}else {
			ProgramCommand.gosub(context, label);
		}
	}

}
