/*
 * Decompiled with CFR 0.152.
 */
package hsplet.gui;

import hsplet.gui.Bmscr;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class GraphicsRenderer {
    private static int[] srcPixels = new int[32768];
    private static int[] destPixels = new int[32768];

    public static synchronized void gcopy(Bmscr win, int dx, int dy, BufferedImage src, int sx, int sy, int w, int h) {
        BufferedImage dest = win.backImage;
        Graphics2D destG = win.backGraphics;
        if (dest.getType() != 5) {
            throw new IllegalArgumentException("\u30d3\u30c3\u30c8\u30bf\u30a4\u30d7 " + dest.getType() + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002");
        }
        if (src.getType() != 5) {
            throw new IllegalArgumentException("\u30d3\u30c3\u30c8\u30bf\u30a4\u30d7 " + src.getType() + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002");
        }
        if (dx < 0) {
            sx += -dx;
            w -= -dx;
            dx += -dx;
        }
        if (sx < 0) {
            dx += -sx;
            w -= -sx;
            sx += -sx;
        }
        if (dx + w > dest.getWidth()) {
            w = dest.getWidth() - dx;
        }
        if (sx + w > src.getWidth()) {
            w = src.getWidth() - sx;
        }
        if (dy < 0) {
            sy += -dy;
            h -= -dy;
            dy += -dy;
        }
        if (sy < 0) {
            dy += -sy;
            h -= -sy;
            sy += -sy;
        }
        if (dy + h > dest.getHeight()) {
            h = dest.getHeight() - dy;
        }
        if (sy + h > src.getHeight()) {
            h = src.getHeight() - sy;
        }
        if (w <= 0 || h <= 0) {
            return;
        }
        if (win.gmode < 2) {
            destG.drawImage(src, dx, dy, dx + w, dy + h, sx, sy, sx + w, sy + h, null);
        } else if (win.gmode == 3) {
            Composite prev = win.backGraphics.getComposite();
            try {
                destG.setComposite(AlphaComposite.getInstance(3, (float)win.galpha / 256.0f));
                destG.drawImage(src, dx, dy, dx + w, dy + h, sx, sy, sx + w, sy + h, null);
            }
            finally {
                destG.setComposite(prev);
            }
        } else {
            WritableRaster dr = dest.getRaster();
            WritableRaster sr = src.getRaster();
            int i = 0;
            while (i < h) {
                sr.getPixels(sx, sy + i, w, 1, srcPixels);
                dr.getPixels(dx, dy + i, w, 1, destPixels);
                GraphicsRenderer.gcopy_line(win, destPixels, srcPixels, w);
                dr.setPixels(dx, dy + i, w, 1, destPixels);
                ++i;
            }
        }
    }

    private static void gcopy_line(Bmscr win, int[] destPixels, int[] srcPixels, int w) {
        int byteCount = w * 3;
        switch (win.gmode) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < byteCount) {
                    destPixels[i] = srcPixels[i];
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < byteCount) {
                    if (srcPixels[i] != 0 || srcPixels[i + 1] != 0 || srcPixels[i + 2] != 0) {
                        destPixels[i] = srcPixels[i];
                        destPixels[i + 1] = srcPixels[i + 1];
                        destPixels[i + 2] = srcPixels[i + 2];
                    }
                    i += 3;
                }
                break;
            }
            case 3: {
                int srcA = win.galpha;
                if (srcA == 256) {
                    int i = 0;
                    while (i < byteCount) {
                        destPixels[i] = srcPixels[i];
                        ++i;
                    }
                } else {
                    if (srcA == 0) break;
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] + ((srcPixels[i] - destPixels[i]) * srcA >> 8);
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                int srcA = win.galpha;
                int transR = win.transColor.getRed();
                int transG = win.transColor.getGreen();
                int transB = win.transColor.getBlue();
                if (srcA == 256) {
                    int i = 0;
                    while (i < byteCount) {
                        if (srcPixels[i] != transR || srcPixels[i + 1] != transG || srcPixels[i + 2] != transB) {
                            destPixels[i] = srcPixels[i];
                            destPixels[i + 1] = srcPixels[i + 1];
                            destPixels[i + 2] = srcPixels[i + 2];
                        }
                        i += 3;
                    }
                } else {
                    if (srcA == 0) break;
                    int i = 0;
                    while (i < byteCount) {
                        if (srcPixels[i] != transR || srcPixels[i + 1] != transG || srcPixels[i + 2] != transB) {
                            int n = i;
                            destPixels[n] = destPixels[n] + ((srcPixels[i] - destPixels[i]) * srcA >> 8);
                            int n2 = i + 1;
                            destPixels[n2] = destPixels[n2] + ((srcPixels[i + 1] - destPixels[i + 1]) * srcA >> 8);
                            int n3 = i + 2;
                            destPixels[n3] = destPixels[n3] + ((srcPixels[i + 2] - destPixels[i + 2]) * srcA >> 8);
                        }
                        i += 3;
                    }
                }
                break;
            }
            case 5: {
                int srcA = win.galpha;
                if (srcA == 256) {
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] + srcPixels[i];
                        if (destPixels[i] > 255) {
                            destPixels[i] = 255;
                        }
                        ++i;
                    }
                } else {
                    if (srcA == 0) break;
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] + (srcPixels[i] * srcA >> 8);
                        if (destPixels[i] > 255) {
                            destPixels[i] = 255;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 6: {
                int srcA = win.galpha;
                if (srcA == 256) {
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] - srcPixels[i];
                        if (destPixels[i] < 0) {
                            destPixels[i] = 0;
                        }
                        ++i;
                    }
                } else {
                    if (srcA == 0) break;
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] - (srcPixels[i] * srcA >> 8);
                        if (destPixels[i] < 0) {
                            destPixels[i] = 0;
                        }
                        ++i;
                    }
                }
                break;
            }
        }
    }

    public static synchronized void gsquare(Bmscr win, int[] dx, int[] dy, BufferedImage src, int[] sx, int[] sy) {
        BufferedImage dest = win.backImage;
        if (dest.getType() != 5) {
            throw new IllegalArgumentException("\u30d3\u30c3\u30c8\u30bf\u30a4\u30d7 " + dest.getType() + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002");
        }
        if (src.getType() != 5) {
            throw new IllegalArgumentException("\u30d3\u30c3\u30c8\u30bf\u30a4\u30d7 " + src.getType() + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002");
        }
        int minY = dy[0];
        int maxY = dy[0];
        int i = 1;
        while (i < 4) {
            if (dy[i] < minY) {
                minY = dy[i];
            }
            if (dy[i] > maxY) {
                maxY = dy[i];
            }
            ++i;
        }
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > dest.getHeight()) {
            maxY = dest.getHeight();
        }
        int[] dxs = new int[2];
        int[] dys = new int[2];
        float[] sxs = new float[2];
        float[] sys = new float[2];
        int y = minY;
        while (y < maxY) {
            dys[0] = dys[1] = y;
            dxs[0] = Integer.MAX_VALUE;
            dxs[1] = Integer.MIN_VALUE;
            int i2 = 0;
            while (i2 < 4) {
                block17: {
                    float sry;
                    float srx;
                    int x;
                    block15: {
                        int j;
                        block16: {
                            block14: {
                                j = i2 + 1 & 3;
                                if (dy[i2] != y) break block14;
                                x = dx[i2];
                                srx = sx[i2];
                                sry = sy[i2];
                                break block15;
                            }
                            if (dy[j] != y) break block16;
                            x = dx[j];
                            srx = sx[j];
                            sry = sy[j];
                            break block15;
                        }
                        if (!(dy[i2] > y ^ dy[j] > y)) break block17;
                        int toY = y - dy[i2];
                        int toJ = dy[j] - dy[i2];
                        x = ((dx[j] - dx[i2]) * toY + toJ * dx[i2]) / toJ;
                        srx = (float)((sx[j] - sx[i2]) * toY) / (float)toJ + (float)sx[i2];
                        sry = (float)((sy[j] - sy[i2]) * toY) / (float)toJ + (float)sy[i2];
                    }
                    if (x < dxs[0]) {
                        dxs[0] = x;
                        sxs[0] = srx;
                        sys[0] = sry;
                    }
                    if (x > dxs[1]) {
                        dxs[1] = x;
                        sxs[1] = srx;
                        sys[1] = sry;
                    }
                }
                ++i2;
            }
            GraphicsRenderer.gsquare_line(win, dest, dxs, dys, src, sxs, sys);
            ++y;
        }
    }

    private static void gsquare_line(Bmscr win, BufferedImage dest, int[] dxs, int[] dys, BufferedImage src, float[] sxs, float[] sys) {
        if (dxs[1] == dxs[0]) {
            return;
        }
        if (dxs[1] <= 0 || dxs[0] >= dest.getWidth()) {
            return;
        }
        if (dys[0] < 0 || dys[0] >= dest.getHeight()) {
            return;
        }
        int dx = dxs[0];
        int dw = dxs[1] - dxs[0];
        int dy = dys[0];
        float sx = sxs[0];
        float sw = sxs[1] - sxs[0];
        float sy = sys[0];
        float sh = sys[1] - sys[0];
        if (dx >= dest.getWidth()) {
            return;
        }
        if (dx < 0) {
            sx += sw * (float)(0 - dx) / (float)dw;
            sw -= sw * (float)(0 - dx) / (float)dw;
            sy += sh * (float)(0 - dx) / (float)dw;
            sh -= sh * (float)(0 - dx) / (float)dw;
            dw -= -dx;
            dx += -dx;
        }
        if (dw <= 0) {
            return;
        }
        if (dx + dw > dest.getWidth()) {
            sw = sw * (float)(dest.getWidth() - dx) / (float)dw;
            sh = sh * (float)(dest.getWidth() - dx) / (float)dw;
            dw = dest.getWidth() - dx;
        }
        int[] srcPixels = GraphicsRenderer.srcPixels;
        WritableRaster dr = dest.getRaster();
        WritableRaster sr = src.getRaster();
        int vsx = (int)(sw * 65536.0f / (float)dw);
        int vsy = (int)(sh * 65536.0f / (float)dw);
        int srx = (int)(sx * 65536.0f);
        int sry = (int)(sy * 65536.0f);
        if (vsy == 0) {
            int syi = (int)sy;
            int i = 0;
            int end = dw * 3;
            while (i < end) {
                srcPixels[i] = sr.getSample(srx >> 16, syi, 0);
                srcPixels[i + 1] = sr.getSample(srx >> 16, syi, 1);
                srcPixels[i + 2] = sr.getSample(srx >> 16, syi, 2);
                srx += vsx;
                i += 3;
            }
        } else {
            int i = 0;
            int end = dw * 3;
            while (i < end) {
                srcPixels[i] = sr.getSample(srx >> 16, sry >> 16, 0);
                srcPixels[i + 1] = sr.getSample(srx >> 16, sry >> 16, 1);
                srcPixels[i + 2] = sr.getSample(srx >> 16, sry >> 16, 2);
                srx += vsx;
                sry += vsy;
                i += 3;
            }
        }
        if (win.gmode >= 2) {
            dr.getPixels(dx, dy, dw, 1, destPixels);
        }
        GraphicsRenderer.gcopy_line(win, destPixels, srcPixels, dw);
        dr.setPixels(dx, dy, dw, 1, destPixels);
    }

    public static synchronized void gsquare(Bmscr win, int[] dx, int[] dy) {
        block19: {
            BufferedImage dest;
            block18: {
                dest = win.backImage;
                if (dest.getType() != 5) {
                    throw new IllegalArgumentException("\u30d3\u30c3\u30c8\u30bf\u30a4\u30d7 " + dest.getType() + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093\u3002");
                }
                if (win.gmode >= 3) break block18;
                win.backGraphics.fillPolygon(dx, dy, 4);
                break block19;
            }
            if (win.gmode == 3) {
                Composite prev = win.backGraphics.getComposite();
                try {
                    win.backGraphics.setComposite(AlphaComposite.getInstance(3, (float)win.galpha / 256.0f));
                    win.backGraphics.fillPolygon(dx, dy, 4);
                }
                finally {
                    win.backGraphics.setComposite(prev);
                }
            }
            int minY = dy[0];
            int maxY = dy[0];
            int i = 1;
            while (i < 4) {
                if (dy[i] < minY) {
                    minY = dy[i];
                }
                if (dy[i] > maxY) {
                    maxY = dy[i];
                }
                ++i;
            }
            if (minY < 0) {
                minY = 0;
            }
            if (maxY > dest.getHeight()) {
                maxY = dest.getHeight();
            }
            int y = minY;
            while (y < maxY) {
                int dx1 = Integer.MAX_VALUE;
                int dx2 = Integer.MIN_VALUE;
                int i2 = 0;
                while (i2 < 4) {
                    block23: {
                        int x;
                        block21: {
                            int j;
                            block22: {
                                block20: {
                                    j = i2 + 1 & 3;
                                    if (dy[i2] != y) break block20;
                                    x = dx[i2];
                                    break block21;
                                }
                                if (dy[j] != y) break block22;
                                x = dx[j];
                                break block21;
                            }
                            if (!(dy[i2] > y ^ dy[j] > y)) break block23;
                            int toJ = dy[j] - dy[i2];
                            x = ((dx[j] - dx[i2]) * (y - dy[i2]) + toJ * dx[i2]) / toJ;
                        }
                        if (x < dx1) {
                            dx1 = x;
                        }
                        if (x > dx2) {
                            dx2 = x;
                        }
                    }
                    ++i2;
                }
                GraphicsRenderer.gsquare_line(win, dest, dx1, dx2, y);
                ++y;
            }
        }
    }

    private static void gsquare_line(Bmscr win, BufferedImage dest, int x1, int x2, int y) {
        if (x1 == x2) {
            return;
        }
        if (y < 0 || y >= dest.getHeight()) {
            return;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 > dest.getWidth()) {
            x2 = dest.getWidth();
        }
        if (x2 <= x1) {
            return;
        }
        WritableRaster dr = dest.getRaster();
        dr.getPixels(x1, y, x2 - x1, 1, destPixels);
        GraphicsRenderer.fill_line(win, destPixels, x2 - x1);
        dr.setPixels(x1, y, x2 - x1, 1, destPixels);
    }

    private static void fill_line(Bmscr win, int[] destPixels, int w) {
        int byteCount = w * 3;
        int red = win.color.getRed();
        int green = win.color.getGreen();
        int blue = win.color.getBlue();
        switch (win.gmode) {
            case 0: 
            case 1: 
            case 2: {
                int i = 0;
                while (i < byteCount) {
                    destPixels[i] = red;
                    destPixels[i + 1] = green;
                    destPixels[i + 2] = blue;
                    i += 3;
                }
                break;
            }
            case 3: 
            case 4: {
                int srcA = win.galpha;
                if (srcA == 256) {
                    int i = 0;
                    while (i < byteCount) {
                        destPixels[i] = red;
                        destPixels[i + 1] = green;
                        destPixels[i + 2] = blue;
                        i += 3;
                    }
                } else {
                    if (srcA == 0) break;
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] + ((red - destPixels[i]) * srcA >> 8);
                        int n2 = i + 1;
                        destPixels[n2] = destPixels[n2] + ((green - destPixels[i + 1]) * srcA >> 8);
                        int n3 = i + 2;
                        destPixels[n3] = destPixels[n3] + ((blue - destPixels[i + 2]) * srcA >> 8);
                        i += 3;
                    }
                }
                break;
            }
            case 5: {
                int srcA = win.galpha;
                if (srcA == 256) {
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] + red;
                        if (destPixels[i] > 255) {
                            destPixels[i] = 255;
                        }
                        int n4 = i + 1;
                        destPixels[n4] = destPixels[n4] + green;
                        if (destPixels[i + 1] > 255) {
                            destPixels[i + 1] = 255;
                        }
                        int n5 = i + 2;
                        destPixels[n5] = destPixels[n5] + blue;
                        if (destPixels[i + 2] > 255) {
                            destPixels[i + 2] = 255;
                        }
                        i += 3;
                    }
                } else {
                    if (srcA == 0) break;
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] + (red * srcA >> 8);
                        if (destPixels[i] > 255) {
                            destPixels[i] = 255;
                        }
                        int n6 = i + 1;
                        destPixels[n6] = destPixels[n6] + (green * srcA >> 8);
                        if (destPixels[i + 1] > 255) {
                            destPixels[i + 1] = 255;
                        }
                        int n7 = i + 2;
                        destPixels[n7] = destPixels[n7] + (blue * srcA >> 8);
                        if (destPixels[i + 2] > 255) {
                            destPixels[i + 2] = 255;
                        }
                        i += 3;
                    }
                }
                break;
            }
            case 6: {
                int srcA = win.galpha;
                if (srcA == 256) {
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] - red;
                        if (destPixels[i] < 0) {
                            destPixels[i] = 0;
                        }
                        int n8 = i + 1;
                        destPixels[n8] = destPixels[n8] - green;
                        if (destPixels[i + 1] < 0) {
                            destPixels[i + 1] = 0;
                        }
                        int n9 = i + 2;
                        destPixels[n9] = destPixels[n9] - blue;
                        if (destPixels[i + 2] < 0) {
                            destPixels[i + 2] = 0;
                        }
                        i += 3;
                    }
                } else {
                    if (srcA == 0) break;
                    int i = 0;
                    while (i < byteCount) {
                        int n = i;
                        destPixels[n] = destPixels[n] - (red * srcA >> 8);
                        if (destPixels[i] < 0) {
                            destPixels[i] = 0;
                        }
                        int n10 = i + 1;
                        destPixels[n10] = destPixels[n10] - (green * srcA >> 8);
                        if (destPixels[i + 1] < 0) {
                            destPixels[i + 1] = 0;
                        }
                        int n11 = i + 2;
                        destPixels[n11] = destPixels[n11] - (blue * srcA >> 8);
                        if (destPixels[i + 2] < 0) {
                            destPixels[i + 2] = 0;
                        }
                        i += 3;
                    }
                }
                break;
            }
        }
    }
}

