/*
 * Decompiled with CFR 0.152.
 */
package hsplet.function;

import hsplet.Context;
import hsplet.function.FunctionBase;
import hsplet.gui.Bmscr;
import hsplet.gui.HSPControl;
import hsplet.gui.WindowManager;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class GuiFunction
extends FunctionBase {
    private static final String fileVersionID = "$Id: GuiFunction.java,v 1.7 2006/02/11 17:19:34 Yuki Exp $";
    public static final int HWND_MASK_WINDOW = 0;
    public static final int HWND_MASK_OBJECT = 0x1000000;

    public static int mousex(Context context) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.contents == null) {
            return context.mouseX;
        }
        try {
            return context.mouseX - win.contents.getLocationOnScreen().x;
        }
        catch (IllegalComponentStateException e) {
            return context.mouseX;
        }
    }

    public static int mousey(Context context) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        if (win.contents == null) {
            return context.mouseY;
        }
        try {
            return context.mouseY - win.contents.getLocationOnScreen().y;
        }
        catch (IllegalComponentStateException e) {
            return context.mouseY;
        }
    }

    public static int mousew(Context context) {
        context.error(21, "mousew");
        return 0;
    }

    public static int hwnd(Context context) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        return WindowManager.getHandle(win.screen.asComponent());
    }

    public static int hinstance(Context context) {
        context.error(21, "hinstance");
        return 0;
    }

    public static int hdc(Context context) {
        return context.targetWindow;
    }

    public static int ginfo(Context context, int type) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        switch (type) {
            case 0: {
                return context.mouseX;
            }
            case 1: {
                return context.mouseY;
            }
            case 2: {
                return context.activeWindow;
            }
            case 3: {
                return context.targetWindow;
            }
            case 4: {
                if (win.window != null) {
                    return win.window.getX();
                }
                return 0;
            }
            case 5: {
                if (win.window != null) {
                    return win.window.getY();
                }
                return 0;
            }
            case 6: {
                if (win.window != null) {
                    return win.window.getX() + win.window.getWidth();
                }
                if (win.contents != null) {
                    return win.contents.getWidth();
                }
                return win.backImage.getWidth();
            }
            case 7: {
                if (win.window != null) {
                    return win.window.getY() + win.window.getHeight();
                }
                if (win.contents != null) {
                    return win.contents.getHeight();
                }
                return win.backImage.getHeight();
            }
            case 8: {
                return win.originx;
            }
            case 9: {
                return win.originy;
            }
            case 10: {
                if (win.window != null) {
                    return win.window.getWidth();
                }
                if (win.contents != null) {
                    return win.contents.getWidth();
                }
                return win.backImage.getWidth();
            }
            case 11: {
                if (win.window != null) {
                    return win.window.getHeight();
                }
                if (win.contents != null) {
                    return win.contents.getHeight();
                }
                return win.backImage.getHeight();
            }
            case 12: {
                return win.backImage.getWidth();
            }
            case 13: {
                return win.backImage.getHeight();
            }
            case 14: {
                return win.mesw;
            }
            case 15: {
                return win.mesh;
            }
            case 16: {
                return win.color.getRed();
            }
            case 17: {
                return win.color.getGreen();
            }
            case 18: {
                return win.color.getBlue();
            }
            case 19: {
                return 0;
            }
            case 20: {
                return Toolkit.getDefaultToolkit().getScreenSize().width;
            }
            case 21: {
                return Toolkit.getDefaultToolkit().getScreenSize().height;
            }
            case 22: {
                return win.cx;
            }
            case 23: {
                return win.cy;
            }
            case 24: {
                return context.messageWindow;
            }
        }
        context.error(3, "ginfo", "type==" + type);
        return 0;
    }

    public static int objinfo(Context context, int id, int type) {
        Bmscr win = (Bmscr)context.windows.get(context.targetWindow);
        switch (type) {
            case 2: {
                return WindowManager.getHandle(((HSPControl)win.controls.get(id)).asComponent());
            }
        }
        context.error(3, "objinfo", "type==" + type);
        return 0;
    }

    public static String dirinfo(Context context, int type) {
        switch (type) {
            case 0: {
                return context.curdir.toString();
            }
            case 1: {
                return context.exedir.toString();
            }
            case 4: {
                return context.cmdline;
            }
        }
        context.error(3, "dirinfo", "type==" + type);
        return "";
    }

    public static Operand sysinfo(Context context, int type) {
        switch (type) {
            case 0: {
                return Scalar.fromValue(System.getProperty("os.name"));
            }
            case 1: {
                return Scalar.fromValue(System.getProperty("user.name"));
            }
            case 2: {
                try {
                    return Scalar.fromValue(new InetSocketAddress(InetAddress.getLocalHost(), 80).getHostName());
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    return Scalar.fromValue("localhost");
                }
            }
            case 16: {
                return Scalar.fromValue(System.getProperty("os.arch"));
            }
            case 33: {
                return Scalar.fromValue((int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) * 100L / Runtime.getRuntime().totalMemory()));
            }
            case 34: {
                return Scalar.fromValue((int)Runtime.getRuntime().totalMemory());
            }
            case 35: {
                return Scalar.fromValue((int)Runtime.getRuntime().freeMemory());
            }
            case 36: {
                return Scalar.fromValue(0);
            }
            case 37: {
                return Scalar.fromValue(0);
            }
            case 38: {
                return Scalar.fromValue((int)Runtime.getRuntime().totalMemory());
            }
            case 39: {
                return Scalar.fromValue((int)Runtime.getRuntime().freeMemory());
            }
        }
        context.error(3, "sysinfo", "type==" + type);
        return Scalar.fromValue(0);
    }
}

