/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler.http;

import hsplet.compiler.http.HttpServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;

public class HttpSession
implements Runnable {
    private static final String CRLF = "\r\n";
    private final Socket socket;
    private final HttpServer server;

    public HttpSession(Socket socket, HttpServer server) {
        this.socket = socket;
        this.server = server;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        BufferedReader r;
        try {
            HashSet<InetAddress> addressSet = new HashSet<InetAddress>();
            addressSet.addAll(Arrays.asList(InetAddress.getAllByName(null)));
            addressSet.add(InetAddress.getLocalHost());
            if (!addressSet.contains(((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress())) {
                System.out.println("Reject request from " + this.socket.getRemoteSocketAddress());
                this.socket.close();
                return;
            }
            r = new BufferedReader(new InputStreamReader(this.socket.getInputStream()), 1024);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        {
            String request = r.readLine();
            StringTokenizer tokenizer = new StringTokenizer(request, " ");
            String method = tokenizer.nextToken();
            String uri = tokenizer.nextToken();
            this.sendContent(uri);
            return;
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getContentType(String uri) {
        if (uri.endsWith(".htm") || uri.endsWith(".html")) {
            return "text/html";
        }
        if (uri.endsWith(".gif")) {
            return "image/gif";
        }
        if (uri.endsWith(".txt")) {
            return "text/plain";
        }
        return "application/octet-stream";
    }

    private File getFile(String uri) {
        File file = HttpServer.mapPath(uri);
        if (file != null && file.isDirectory()) {
            if (new File(file, "index.htm").isFile()) {
                file = new File(file, "index.htm");
            } else if (new File(file, "index.html").isFile()) {
                file = new File(file, "index.html");
            }
        }
        return file;
    }

    private void sendContent(String uri) throws IOException {
        File file = this.getFile(uri);
        OutputStream o = this.socket.getOutputStream();
        OutputStreamWriter w = new OutputStreamWriter(o, "UTF-8");
        if (file != null && file.isFile()) {
            int l;
            String contentType = this.getContentType(uri);
            w.write("HTTP/1.0 200 OK\r\n");
            w.write("Content-type: " + contentType + CRLF);
            w.write("Pragma: no-cache\r\n");
            w.write("Cache-Control: no-cache\r\n");
            w.write("Expires: Thu, 01 Dec 1994 16:00:00 GMT\r\n");
            w.write(CRLF);
            w.flush();
            FileInputStream in = new FileInputStream(file);
            byte[] buf = new byte[1024];
            while ((l = ((InputStream)in).read(buf)) >= 0) {
                o.write(buf, 0, l);
            }
        } else {
            w.write("HTTP/1.0 404 Not found\r\n");
            w.write("Content-type: text/html\r\n");
            w.write("Pragma: no-cache\r\n");
            w.write("Cache-Control: no-cache\r\n");
            w.write("Expires: Thu, 01 Dec 1994 16:00:00 GMT\r\n");
            w.write(CRLF);
            w.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
            w.write("<html><head><title>404 Not Found</title></head><body>");
            w.write("<h1>404 Not found</h1>");
            w.write("<hr>");
            w.write("<table summary='Query Information'><tr><th>URI:</th><td>" + uri + "</td></tr>");
            w.write("<tr><th>File:</th><td>" + file + "</td></tr></table>");
            w.write("</p></body></html>");
            w.flush();
        }
        o.close();
    }
}

