/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler;

import java.io.IOException;
import java.io.InputStream;

public final class LEInputStream
extends InputStream {
    private static final String fileVersionID = "$Id: LEInputStream.java,v 1.3 2006/01/13 20:32:11 Yuki Exp $";
    private final InputStream inner;
    private int offset;

    public LEInputStream(InputStream inner) {
        this.inner = inner;
        this.offset = 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public int readInt() throws IOException {
        byte[] bits = new byte[4];
        this.readBytes(bits);
        return bits[0] & 0xFF | bits[1] << 8 & 0xFF00 | bits[2] << 16 & 0xFF0000 | bits[3] << 24 & 0xFF000000;
    }

    public int readShort() throws IOException {
        byte[] bits = new byte[2];
        this.readBytes(bits);
        return bits[0] & 0xFF | bits[1] << 8 & 0xFF00;
    }

    public void readBytes(byte[] bytes) throws IOException {
        int totalReadSize = 0;
        while (totalReadSize < bytes.length) {
            int readSize = this.read(bytes, totalReadSize, bytes.length - totalReadSize);
            if (readSize < 0) {
                throw new IOException("Unexpected EOF");
            }
            totalReadSize += readSize;
        }
        this.offset += bytes.length;
    }

    public void seekTo(int offset) throws IOException {
        if (offset < this.offset) {
            throw new IOException("Cannot seek back.");
        }
        this.offset = (int)((long)this.offset + this.skip(offset - this.offset));
        if (this.offset < offset) {
            throw new IOException("Unexpected EOF");
        }
    }

    public int read() throws IOException {
        return this.inner.read();
    }
}

