/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler;

import hsplet.compiler.ByteCode;
import hsplet.compiler.DefaultRuntimeInfo;
import hsplet.compiler.EmptyVisitor;
import hsplet.compiler.HtmlGenerator;
import hsplet.compiler.LibraryLoader;
import hsplet.compiler.RuntimeInfo;
import hsplet.variable.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class Compiler
implements Opcodes,
Serializable {
    private static final String fileVersionID = "$Id: Compiler.java,v 1.11 2006/05/09 11:57:31 Yuki Exp $";
    private static final long serialVersionUID = 8668239863505235428L;
    private static final boolean DEBUG_ENABLED = false;
    private static final String contextDesc;
    private static final String contextIName;
    private static final String opeDesc;
    private static final String opeIName;
    private static final String varDesc;
    private static final String varIName;
    private static final String literalDesc;
    private static final String literalIName;
    private static final String parentDesc;
    private static final String parentIName;
    private static final int thisIndex = 0;
    private static final int jumpLabelIndex = 1;
    private static final int contextIndex = 2;
    private static final int assignOffsetIndex = 3;
    private ClassVisitor cw;
    private String inputName;
    private String className;
    private String classIName;
    private ByteCode ax;
    private int codeIndex;
    private List literals;
    private Stack loopStarts;
    private boolean enableVariableOptimization;
    private RuntimeInfo runtime;
    private List instancedLibraries;
    private Map labels;
    private List submethodStartEnds = new ArrayList();
    private static final String[] assignOperators;
    private static final String[] unaryOperators;
    private static final String[] binaryOperators;
    private static final String[] systemVariables;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("hsplet.Context");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        contextDesc = Type.getDescriptor(clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("hsplet.Context");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        contextIName = Type.getInternalName(clazz2);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("hsplet.variable.Operand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        opeDesc = Type.getDescriptor(clazz3);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("hsplet.variable.Operand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        opeIName = Type.getInternalName(clazz4);
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("hsplet.variable.Variable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        varDesc = Type.getDescriptor(clazz5);
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("hsplet.variable.Variable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        varIName = Type.getInternalName(clazz6);
        Class<?> clazz7 = class$3;
        if (clazz7 == null) {
            try {
                clazz7 = class$3 = Class.forName("hsplet.variable.Scalar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        literalDesc = Type.getDescriptor(clazz7);
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("hsplet.variable.Scalar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        literalIName = Type.getInternalName(clazz8);
        Class<?> clazz9 = class$4;
        if (clazz9 == null) {
            try {
                clazz9 = class$4 = Class.forName("hsplet.RunnableCode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        parentDesc = Type.getDescriptor(clazz9);
        Class<?> clazz10 = class$4;
        if (clazz10 == null) {
            try {
                clazz10 = class$4 = Class.forName("hsplet.RunnableCode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        parentIName = Type.getInternalName(clazz10);
        String[] stringArray = new String[16];
        stringArray[0] = "assignAdd";
        stringArray[1] = "assignSub";
        stringArray[2] = "assignMul";
        stringArray[3] = "assignDiv";
        stringArray[4] = "assignMod";
        stringArray[5] = "assignAnd";
        stringArray[6] = "assignOr";
        stringArray[7] = "assignXor";
        stringArray[8] = "assign";
        stringArray[14] = "assignSr";
        stringArray[15] = "assignSl";
        assignOperators = stringArray;
        unaryOperators = new String[]{"inc", "dec"};
        binaryOperators = new String[]{"add", "sub", "mul", "div", "mod", "and", "or", "xor", "eq", "ne", "gt", "lt", "ge", "le", "sr", "sl"};
        systemVariables = new String[]{"system", "hspstat", "hspver", "stat", "cnt", "err", "strsize", "looplev", "sublev", "iparam", "wparam", "lparam", "refstr", "refdval"};
    }

    public static void main(String[] args) throws IOException {
        int width = 640;
        int height = 480;
        HashSet<String> libs = new HashSet<String>();
        HashSet<String> libdirs = new HashSet<String>();
        HashSet<String> packs = new HashSet<String>();
        String title = "HSPLet";
        File jarFile = null;
        File htmlFile = null;
        File templateFile = null;
        String startClass = "start";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("--jar=")) {
                jarFile = new File(arg.substring("--jar=".length()));
            } else if (arg.startsWith("--html=")) {
                htmlFile = new File(arg.substring("--html=".length()));
            } else if (arg.startsWith("--template=")) {
                templateFile = new File(arg.substring("--template=".length()));
            } else if (arg.startsWith("--startClass=")) {
                startClass = arg.substring("--startClass=".length());
            } else if (arg.startsWith("--lib=")) {
                libs.add(arg.substring("--lib=".length()));
            } else if (arg.startsWith("--libdir=")) {
                libdirs.add(arg.substring("--libdir=".length()));
            } else if (arg.startsWith("--pack=")) {
                packs.add(arg.substring("--pack=".length()));
            } else if (arg.startsWith("--title=")) {
                title = arg.substring("--title=".length());
            } else if (arg.startsWith("--width=")) {
                width = Integer.parseInt(arg.substring("--width=".length()));
            } else if (arg.startsWith("--height=")) {
                height = Integer.parseInt(arg.substring("--height=".length()));
            }
            ++i;
        }
        if (jarFile == null) {
            throw new RuntimeException("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        Compiler.build(jarFile, htmlFile, templateFile, startClass, title, packs, libs, libdirs, width, height);
    }

    public static String generateClassName(String fileName) {
        String result = fileName.split("\\.")[0].replaceAll("[^a-zA-Z0-9_]", "");
        if (result.length() == 0) {
            return "_start";
        }
        if (Character.isDigit(result.charAt(0))) {
            return "_" + result;
        }
        return result;
    }

    public static void build(File jarFile, File htmlFile, File templateFile, String startClass, String title, Collection packs, Collection libs, Collection libdirs, int w, int h) throws IOException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("hsplet.compiler.Compiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LibraryLoader libraryLoader = new LibraryLoader(libs.toArray(new String[0]), libdirs.toArray(new String[0]), clazz.getClassLoader());
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarFile));
        try {
            if (jarFile.getName().equalsIgnoreCase("hsplet.jar")) {
                throw new IllegalArgumentException(String.valueOf(jarFile.getName()) + " \u3068\u3044\u3046\u540d\u524d\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            Iterator i = libs.iterator();
            while (i.hasNext()) {
                String extLib = (String)i.next();
                if (!jarFile.getName().equalsIgnoreCase(new File(extLib).getName())) continue;
                throw new IllegalArgumentException(String.valueOf(jarFile.getName()) + " \u3068\u3044\u3046\u540d\u524d\u306f\u3059\u3067\u306b\u62e1\u5f35\u30e9\u30a4\u30d6\u30e9\u30ea\u3067\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
            i = packs.iterator();
            while (i.hasNext()) {
                String pack = (String)i.next();
                File packFile = new File(pack);
                if (packFile.getName().toLowerCase().endsWith(".ax")) {
                    String className = Compiler.generateClassName(packFile.getName());
                    JarEntry je = new JarEntry(String.valueOf(className) + ".class");
                    je.setMethod(8);
                    jar.putNextEntry(je);
                    try {
                        Compiler c = new Compiler(new ByteCode(new FileInputStream(packFile)), packFile.getName(), libraryLoader);
                        c.compile(className, jar);
                        continue;
                    }
                    finally {
                        jar.closeEntry();
                    }
                }
                JarEntry je = new JarEntry(packFile.getName());
                je.setMethod(8);
                jar.putNextEntry(je);
                FileInputStream in = new FileInputStream(packFile);
                try {
                    Compiler.connectStream(in, jar);
                }
                finally {
                    ((InputStream)in).close();
                    jar.closeEntry();
                }
            }
        }
        finally {
            jar.close();
        }
        if (htmlFile != null) {
            HashSet<String> libNames = new HashSet<String>();
            Compiler.deploy(htmlFile.getAbsoluteFile().getParentFile(), jarFile);
            libNames.add(jarFile.getName());
            Compiler.deploy(htmlFile.getAbsoluteFile().getParentFile(), new File("hsplet.jar"));
            libNames.add("hsplet.jar");
            Iterator i = libraryLoader.getUsedLibs().iterator();
            while (i.hasNext()) {
                String extLib = (String)i.next();
                Compiler.deploy(htmlFile.getAbsoluteFile().getParentFile(), new File(extLib));
                libNames.add(new File(extLib).getName());
            }
            FileOutputStream html = new FileOutputStream(htmlFile);
            try {
                new HtmlGenerator(Compiler.generateClassName(startClass), title, libNames, w, h, templateFile).generate(html);
            }
            finally {
                ((OutputStream)html).close();
            }
        }
    }

    private static void deploy(File destDir, File file) throws IOException {
        if (file.getAbsoluteFile().getParentFile().equals(destDir)) {
            return;
        }
        FileInputStream in = new FileInputStream(file);
        try {
            FileOutputStream out = new FileOutputStream(new File(destDir, file.getName()));
            try {
                Compiler.connectStream(in, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private static void connectStream(InputStream in, OutputStream out) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
        }
    }

    public Compiler(ByteCode ax, String inputName, ClassLoader libraryLoader) {
        this.ax = ax;
        this.inputName = inputName;
        this.runtime = new DefaultRuntimeInfo(libraryLoader);
    }

    public void compile(String className, OutputStream out) throws IOException {
        this.className = className;
        this.classIName = className.replace('.', '/');
        ClassWriter writer = new ClassWriter(true);
        this.cw = writer;
        this.literals = new ArrayList();
        this.loopStarts = new Stack();
        this.submethodStartEnds = new ArrayList();
        this.instancedLibraries = new ArrayList();
        this.codeIndex = 0;
        this.enableVariableOptimization = false;
        this.cw.visit(48, 1, this.classIName, null, parentIName, new String[0]);
        this.collectLiterals();
        this.createRun();
        this.createSubMethods();
        this.createConstructor();
        this.createFields();
        this.cw.visitEnd();
        out.write(writer.toByteArray());
    }

    private void collectLiterals() {
        this.literals.add(new Integer(0));
        this.literals.add(new Double(0.0));
        this.literals.add(new String(""));
        int i = 0;
        while (i < this.ax.codes.length) {
            Object o = this.literalValueOf(this.ax.codes[i]);
            if (o != null && this.literals.indexOf(o) < 0) {
                this.literals.add(o);
            }
            ++i;
        }
    }

    private Object literalValueOf(ByteCode.Code code) {
        switch (code.type) {
            case 2: {
                return new ByteString(this.ax.datas, code.value, false).toString();
            }
            case 3: {
                byte[] b = this.ax.datas;
                int o = code.value;
                long bits = 0L;
                int i = 0;
                while (i < 8) {
                    bits |= ((long)b[o + i] & 0xFFL) << 8 * i;
                    ++i;
                }
                return new Double(Double.longBitsToDouble(bits));
            }
            case 4: {
                return new Integer(code.value);
            }
        }
        return null;
    }

    private void createFields() {
        this.cw.visitField(18, "context", contextDesc, null, null);
        int i = 0;
        while (i < this.ax.header.variableCount) {
            this.cw.visitField(18, "v" + i, varDesc, null, null);
            ++i;
        }
        i = 0;
        while (i < this.ax.parameters.length) {
            this.cw.visitField(18, "p" + i, opeDesc, null, null);
            ++i;
        }
        i = 0;
        while (i < this.literals.size()) {
            this.cw.visitField(18, "c" + i, literalDesc, null, null);
            ++i;
        }
        i = 0;
        while (i < this.instancedLibraries.size()) {
            this.cw.visitField(18, "l" + i, Type.getDescriptor((Class)this.instancedLibraries.get(i)), null, null);
            ++i;
        }
    }

    private void createConstructor() {
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "(" + contextDesc + ")V", null, new String[0]);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parentIName, "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.classIName, "context", contextDesc);
        int i = 0;
        while (i < this.ax.header.variableCount) {
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, varIName);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, varIName, "<init>", "()V");
            mv.visitFieldInsn(181, this.classIName, "v" + i, varDesc);
            ++i;
        }
        i = 0;
        while (i < this.literals.size()) {
            Class<?> clazz;
            Object value = this.literals.get(i);
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(value);
            StringBuffer stringBuffer = new StringBuffer("(");
            if (value instanceof Integer) {
                clazz = Integer.TYPE;
            } else if (value instanceof Double) {
                clazz = Double.TYPE;
            } else {
                clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }
            mv.visitMethodInsn(184, literalIName, "fromValue", stringBuffer.append(Type.getDescriptor(clazz)).append(")").append(literalDesc).toString());
            mv.visitFieldInsn(181, this.classIName, "c" + i, literalDesc);
            ++i;
        }
        i = 0;
        while (i < this.instancedLibraries.size()) {
            Class clazz = (Class)this.instancedLibraries.get(i);
            mv.visitVarInsn(25, 0);
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("hsplet.Context");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                clazz.getConstructor(classArray);
                mv.visitTypeInsn(187, Type.getInternalName(clazz));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, Type.getInternalName(clazz), "<init>", "(" + contextDesc + ")V");
            }
            catch (Exception e) {
                try {
                    clazz.getConstructor(new Class[0]);
                    mv.visitTypeInsn(187, Type.getInternalName(clazz));
                    mv.visitInsn(89);
                    mv.visitMethodInsn(183, Type.getInternalName(clazz), "<init>", "()V");
                }
                catch (Exception e1) {
                    mv.visitInsn(1);
                }
            }
            mv.visitFieldInsn(181, this.classIName, "l" + i, Type.getDescriptor(clazz));
            ++i;
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRun() {
        MethodVisitor mv = this.cw.visitMethod(17, "run", "(I)" + opeDesc, null, new String[0]);
        this.compileLocalVariables(mv);
        this.prepareLabels();
        Label start_try = new Label();
        mv.visitLabel(start_try);
        this.compileLabelJumpTable(mv);
        this.compileCodes(mv);
        Label end_try = new Label();
        mv.visitLabel(end_try);
        Label after_try = new Label();
        mv.visitJumpInsn(167, after_try);
        Label try_handler = new Label();
        mv.visitLabel(try_handler);
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("hsplet.function.GotoException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mv.visitTryCatchBlock(start_try, end_try, try_handler, Type.getInternalName(clazz));
        Class<?> clazz2 = class$7;
        if (clazz2 == null) {
            try {
                clazz2 = class$7 = Class.forName("hsplet.function.GotoException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mv.visitFieldInsn(180, Type.getInternalName(clazz2), "label", "I");
        mv.visitVarInsn(54, 1);
        mv.visitJumpInsn(167, start_try);
        mv.visitLabel(after_try);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void prepareLabels() {
        this.labels = new HashMap();
        this.labels.put(new Integer(this.ax.codes[0].offset), new Label());
        int i = 0;
        while (i < this.ax.labels.length) {
            this.labels.put(new Integer(this.ax.labels[i]), new Label());
            ++i;
        }
    }

    private Label getLabel(int index) {
        return (Label)this.labels.get(new Integer(this.ax.labels[index]));
    }

    private void compileLocalVariables(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.classIName, "context", contextDesc);
        mv.visitVarInsn(58, 2);
    }

    private void compileLabelJumpTable(MethodVisitor mv) {
        mv.visitVarInsn(21, 1);
        mv.visitInsn(2);
        mv.visitVarInsn(54, 1);
        Label[] labels = new Label[this.ax.labels.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = this.getLabel(i);
            ++i;
        }
        mv.visitTableSwitchInsn(0, this.ax.labels.length - 1, (Label)this.labels.get(new Integer(this.ax.codes[0].offset)), labels);
    }

    private void compileCodes(MethodVisitor mv) {
        int nextBlock = 1;
        HashSet unusedLabels = new HashSet(this.labels.values());
        while (this.codeIndex < this.ax.codes.length) {
            int nextLabelIndex;
            Label label = (Label)this.labels.get(new Integer(this.ax.codes[this.codeIndex].offset));
            if (label != null) {
                mv.visitLabel(label);
                unusedLabels.remove(label);
            }
            if (this.codeIndex >= nextBlock && (nextLabelIndex = Math.min(this.codeIndex + 10000, this.findNextLabelGotoReturn())) != this.codeIndex) {
                int blockEnd = this.findBlockEnd(this.codeIndex, nextLabelIndex);
                int blockSize = blockEnd - this.codeIndex;
                if (blockSize >= 20) {
                    this.submethodStartEnds.add(new int[]{this.codeIndex, blockEnd});
                    this.compileSeparatedMethod(new EmptyVisitor(), blockEnd);
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(182, this.classIName, "m" + (this.submethodStartEnds.size() - 1), "()V");
                    continue;
                }
                nextBlock = blockEnd;
            }
            this.compileStatement(mv);
        }
        Iterator i = unusedLabels.iterator();
        while (i.hasNext()) {
            Label label = (Label)i.next();
            mv.visitLabel(label);
        }
    }

    private void compileSeparatedMethod(MethodVisitor mv, int endIndex) {
        Label label;
        this.compileLocalVariables(mv);
        while (this.codeIndex < endIndex) {
            label = (Label)this.labels.get(new Integer(this.ax.codes[this.codeIndex].offset));
            if (label != null) {
                mv.visitLabel(label);
            }
            this.compileStatement(mv);
        }
        if (this.codeIndex < this.ax.codes.length && (label = (Label)this.labels.get(new Integer(this.ax.codes[this.codeIndex].offset))) != null) {
            mv.visitLabel(label);
        }
    }

    private int findNextLabelGotoReturn() {
        int i = this.codeIndex;
        while (i < this.ax.codes.length) {
            if (i != this.codeIndex && this.labels.get(new Integer(this.ax.codes[i].offset)) != null && !this.isLoopLabel(this.ax.codes[i].offset)) {
                return i;
            }
            if (this.ax.codes[i].type == 15 && this.ax.codes[i].newLine && (this.ax.codes[i].value == 0 || this.ax.codes[i].value == 2 || this.ax.codes[i].value == 24 || this.ax.codes[i].value == 25)) {
                return i;
            }
            ++i;
        }
        return this.ax.codes.length;
    }

    private boolean isLoopLabel(int offset) {
        int i = 0;
        while (i < this.ax.codes.length) {
            ByteCode.Code code = this.ax.codes[i];
            if (code.type == 11) {
                if ((code.value == 0 || code.value == 1) && this.ax.codes[i + 1].value + this.ax.codes[i + 2].offset == offset) {
                    return false;
                }
            } else if (code.type == 15) {
                if (code.value == 3 || code.value == 4 || code.value == 6 || code.value == 11 || code.value == 12) {
                    ++i;
                }
            } else if (code.type == 7 && this.ax.labels[code.value] == offset) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int findBlockEnd(int startIndex, int endIndex) {
        int i = startIndex;
        while (i < endIndex) {
            if (this.ax.codes[i].type == 11) {
                if (this.ax.codes[i].value == 1) {
                    return i;
                }
                int ifEndOffset = this.ax.codes[i + 2].offset + this.ax.codes[i + 1].value;
                int ifEnd = this.findCodeForOffset(i, endIndex, ifEndOffset);
                if (ifEnd < 0) {
                    return i;
                }
                int ifEnd2 = this.findBlockEnd(i + 2, ifEnd);
                if (ifEnd2 == ifEnd) {
                    i = ifEnd;
                    continue;
                }
                if (ifEnd2 == ifEnd - 2 && this.ax.codes[ifEnd - 1].type == 19) {
                    int elseEndOffset = this.ax.codes[ifEnd].offset + this.ax.codes[ifEnd - 1].value;
                    int elseEnd = this.findCodeForOffset(ifEnd, endIndex, elseEndOffset);
                    if (elseEnd < 0) {
                        return i;
                    }
                    int elseEnd2 = this.findBlockEnd(ifEnd, elseEnd);
                    if (elseEnd2 == elseEnd) {
                        i = elseEnd;
                        continue;
                    }
                    return i;
                }
                return i;
            }
            if (this.ax.codes[i].type == 15) {
                if (this.ax.codes[i].value == 3 || this.ax.codes[i].value == 5 || this.ax.codes[i].value == 6 || this.ax.codes[i].value == 12) {
                    return i;
                }
                if (this.ax.codes[i].value == 4 || this.ax.codes[i].value == 11) {
                    int loopEndOffset = this.ax.labels[this.ax.codes[i + 1].value];
                    int loopEnd = this.findCodeForOffset(i, endIndex, loopEndOffset);
                    if (loopEnd < 0) {
                        return i;
                    }
                    i = loopEnd;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return endIndex;
    }

    private boolean containsOuterRepeatLoop(int startIndex, int endIndex, int blockEnd) {
        int i = startIndex;
        while (i < endIndex) {
            if (this.ax.codes[i].type == 15 && (this.ax.codes[i].value == 3 || this.ax.codes[i].value == 4 || this.ax.codes[i].value == 5 || this.ax.codes[i].value == 6 || this.ax.codes[i].value == 11 || this.ax.codes[i].value == 12)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int findCodeForOffset(int startIndex, int endIndex, int offset) {
        int i = startIndex;
        while (i < this.ax.codes.length && i <= endIndex) {
            if (this.ax.codes[i].offset == offset) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void compileStatement(MethodVisitor mv) {
        switch (this.ax.codes[this.codeIndex].type) {
            case 1: 
            case 5: {
                this.compileAssignment(mv);
                break;
            }
            case 8: 
            case 9: {
                this.compileCommand(mv);
                break;
            }
            case 11: {
                this.compileCompareCommand(mv);
                break;
            }
            case 12: {
                this.compileModuleCommand(mv, false);
                break;
            }
            case 15: {
                this.compileProgramCommand(mv);
                break;
            }
            case 16: {
                this.compileDllCommand(mv);
                break;
            }
            case 17: {
                this.compileCommand(mv);
                break;
            }
            default: {
                throw new RuntimeException("\u547d\u4ee4\u30b3\u30fc\u30c9 " + this.ax.codes[this.codeIndex].type + " \u306f\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        }
    }

    private void compileAssignment(MethodVisitor mv) {
        boolean prevEnableVariableOptimization = this.enableVariableOptimization;
        int index = this.codeIndex;
        if (this.ax.codes[this.codeIndex].type == 1) {
            this.compileVariable(new EmptyVisitor());
        } else {
            this.compileParameter(new EmptyVisitor());
        }
        this.enableVariableOptimization |= this.ax.codes[this.codeIndex].value != 8;
        this.codeIndex = index;
        if (this.ax.codes[this.codeIndex].type == 1) {
            this.compileVariable(mv);
        } else {
            this.compileParameter(mv);
        }
        this.enableVariableOptimization = true;
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        if (this.codeIndex < this.ax.codes.length && !this.ax.codes[this.codeIndex].newLine) {
            String name = assignOperators[code.value];
            mv.visitVarInsn(54, 3);
            do {
                mv.visitInsn(89);
                mv.visitVarInsn(21, 3);
                mv.visitIincInsn(3, 1);
                this.compileExpression(mv);
                mv.visitMethodInsn(182, opeIName, name, "(I" + opeDesc + "I)V");
            } while (this.codeIndex < this.ax.codes.length && !this.ax.codes[this.codeIndex].newLine);
            mv.visitInsn(87);
        } else {
            String name = unaryOperators[code.value];
            mv.visitMethodInsn(182, opeIName, name, "(I)V");
        }
        this.enableVariableOptimization = prevEnableVariableOptimization;
    }

    private void compileVariable(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.classIName, "v" + code.value, varDesc);
        if (this.enableVariableOptimization) {
            mv.visitFieldInsn(180, varIName, "value", opeDesc);
        }
        this.compileArrayIndex(mv);
    }

    private void compileArrayIndex(MethodVisitor mv) {
        int paramCount = 0;
        if (this.codeIndex < this.ax.codes.length && this.ax.codes[this.codeIndex].type == 0 && this.ax.codes[this.codeIndex].value == 40) {
            ++this.codeIndex;
            int index = this.codeIndex;
            this.compileExpression(new EmptyVisitor());
            boolean moreThan2Dim = this.codeIndex < this.ax.codes.length && (this.ax.codes[this.codeIndex].type != 0 || this.ax.codes[this.codeIndex].value != 41);
            this.codeIndex = index;
            if (!moreThan2Dim) {
                this.compileExpression(mv);
                mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
            } else {
                mv.visitInsn(89);
                do {
                    ++paramCount;
                    this.compileExpression(mv);
                    mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
                } while (this.codeIndex < this.ax.codes.length && (this.ax.codes[this.codeIndex].type != 0 || this.ax.codes[this.codeIndex].value != 41));
                mv.visitMethodInsn(182, opeIName, "getIndex", "(" + "IIII".substring(0, paramCount) + ")I");
            }
            ++this.codeIndex;
        } else {
            mv.visitInsn(3);
        }
    }

    private void compileExpression(MethodVisitor mv) {
        boolean prevEnableVariableOptimization = this.enableVariableOptimization;
        int index = this.codeIndex;
        this.compileToken(new EmptyVisitor());
        this.enableVariableOptimization |= this.codeIndex < this.ax.codes.length && (this.ax.codes[this.codeIndex].type != 0 || this.ax.codes[this.codeIndex].value != 41 && this.ax.codes[this.codeIndex].value != 63) && !(this.ax.codes[this.codeIndex].newLine | this.ax.codes[this.codeIndex].comma);
        this.codeIndex = index;
        do {
            this.compileToken(mv);
        } while (this.codeIndex < this.ax.codes.length && (this.ax.codes[this.codeIndex].type != 0 || this.ax.codes[this.codeIndex].value != 41 && this.ax.codes[this.codeIndex].value != 63) && !(this.ax.codes[this.codeIndex].newLine | this.ax.codes[this.codeIndex].comma));
        this.enableVariableOptimization = prevEnableVariableOptimization;
    }

    private void compileToken(MethodVisitor mv) {
        switch (this.ax.codes[this.codeIndex].type) {
            case 0: {
                this.compileOperator(mv);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.compileLiteral(mv);
                break;
            }
            case 5: {
                this.compileParameter(mv);
                break;
            }
            case 7: {
                this.compileLabel(mv);
                break;
            }
            case 1: {
                this.compileVariable(mv);
                break;
            }
            case 10: {
                this.compileGuiSystmVariable(mv);
                break;
            }
            case 12: {
                this.compileModuleCommand(mv, true);
                break;
            }
            case 13: {
                this.compileFunction(mv);
                break;
            }
            case 14: {
                this.compileSystemVariable(mv);
                break;
            }
            case 15: {
                this.compileProgramCommand(mv);
                break;
            }
            case 16: {
                this.compileDllFunction(mv);
                break;
            }
            default: {
                throw new RuntimeException("\u547d\u4ee4\u30b3\u30fc\u30c9 " + this.ax.codes[this.codeIndex].type + " \u306f\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        }
    }

    private void compileLabel(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        mv.visitLdcInsn(new Integer(code.value));
        mv.visitMethodInsn(184, literalIName, "fromLabel", "(I)" + literalDesc);
        mv.visitInsn(3);
    }

    private void compileOperator(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        String name = binaryOperators[code.value];
        mv.visitMethodInsn(182, opeIName, name, "(I" + opeDesc + "I)" + opeDesc);
        mv.visitInsn(3);
    }

    private void compileLiteral(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        this.compileLiteral(mv, this.literalValueOf(code));
    }

    private void compileLiteral(MethodVisitor mv, Object o) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.classIName, "c" + this.literals.indexOf(o), literalDesc);
        mv.visitInsn(3);
    }

    private void compileParameter(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.classIName, "p" + code.value, opeDesc);
        this.compileArrayIndex(mv);
    }

    private void compileGuiSystmVariable(MethodVisitor mv) {
        this.compileInvocation(mv, true, true);
    }

    private void compileInvocation(MethodVisitor mv, boolean bracket, boolean hasresult) {
        boolean noeatparam;
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        Class libraryClass = this.runtime.getClassFor(this.ax, code);
        Method method = this.runtime.getMethodFor(this.ax, code);
        String methodDesc = Type.getMethodDescriptor(method);
        if (!Modifier.isStatic(method.getModifiers())) {
            if (!this.instancedLibraries.contains(libraryClass)) {
                this.instancedLibraries.add(libraryClass);
            }
            mv.visitIntInsn(25, 0);
            mv.visitFieldInsn(180, this.classIName, "l" + this.instancedLibraries.indexOf(libraryClass), Type.getDescriptor(libraryClass));
        }
        if (bracket && (this.ax.codes[this.codeIndex].type != 0 || this.ax.codes[this.codeIndex].value != 40)) {
            noeatparam = true;
            bracket = false;
        } else {
            noeatparam = false;
        }
        if (bracket) {
            ++this.codeIndex;
        }
        this.compileInvocationParameters(mv, method, noeatparam);
        if (bracket) {
            if (this.ax.codes[this.codeIndex].type != 0 || this.ax.codes[this.codeIndex].value != 41) {
                throw new RuntimeException("\u5bfe\u5fdc\u3059\u308b ) \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            }
            ++this.codeIndex;
        }
        mv.visitMethodInsn(Modifier.isStatic(method.getModifiers()) ? 184 : 182, Type.getInternalName(libraryClass), method.getName(), methodDesc);
        if (hasresult) {
            if (method.getReturnType().equals(Void.TYPE)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.classIName, "c" + this.literals.indexOf(new Integer(0)), literalDesc);
            } else {
                Class<?> clazz = method.getReturnType();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("hsplet.variable.Operand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.equals(clazz2)) {
                    mv.visitMethodInsn(184, literalIName, "fromValue", "(" + Type.getDescriptor(method.getReturnType()) + ")" + literalDesc);
                }
            }
            mv.visitInsn(3);
        } else if (method.getReturnType().equals(Integer.TYPE)) {
            mv.visitVarInsn(25, 2);
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("hsplet.variable.IntScalar");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            mv.visitFieldInsn(180, contextIName, "stat", Type.getDescriptor(clazz));
            mv.visitInsn(95);
            Class<?> clazz3 = class$8;
            if (clazz3 == null) {
                try {
                    clazz3 = class$8 = Class.forName("hsplet.variable.IntScalar");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            mv.visitFieldInsn(181, Type.getInternalName(clazz3), "value", "I");
        } else if (!method.getReturnType().equals(Void.TYPE)) {
            mv.visitInsn(87);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compileInvocationParameters(MethodVisitor mv, Method method, boolean noeatparam) {
        boolean firstParam = true;
        int paramIndex = 0;
        while (paramIndex < method.getParameterTypes().length) {
            Class<?> type = method.getParameterTypes()[paramIndex];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("hsplet.Context");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (type.equals(clazz)) {
                mv.visitVarInsn(25, 2);
            } else {
                Class<?> clazz2 = class$9;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("hsplet.function.JumpStatement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz2)) {
                    if (!(noeatparam || this.codeIndex >= this.ax.codes.length || this.ax.codes[this.codeIndex].newLine || this.ax.codes[this.codeIndex].type == 0 && this.ax.codes[this.codeIndex].value == 41 || this.ax.codes[this.codeIndex].type != 15)) {
                        Class<?> clazz3 = class$9;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("hsplet.function.JumpStatement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        String string = Type.getInternalName(clazz3);
                        String string2 = this.ax.codes[this.codeIndex].value == 0 ? "Goto" : "Gosub";
                        Class<?> clazz4 = class$9;
                        if (clazz4 == null) {
                            try {
                                clazz4 = Class.forName("hsplet.function.JumpStatement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        mv.visitFieldInsn(178, string, string2, Type.getDescriptor(clazz4));
                        ++this.codeIndex;
                    } else {
                        mv.visitInsn(1);
                    }
                } else {
                    boolean omitted;
                    ByteCode.Code code = this.ax.codes[this.codeIndex];
                    if (!(noeatparam || this.codeIndex >= this.ax.codes.length || code.newLine || code.type == 0 && code.value == 41)) {
                        if (firstParam && code.comma) {
                            omitted = true;
                        } else if (code.type == 0 && code.value == 63) {
                            omitted = true;
                            ++this.codeIndex;
                        } else {
                            omitted = false;
                        }
                    } else {
                        omitted = true;
                    }
                    firstParam = false;
                    if (!omitted) {
                        this.compileExpression(mv);
                        Class<?> clazz5 = class$1;
                        if (clazz5 == null) {
                            try {
                                clazz5 = Class.forName("hsplet.variable.Operand");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (type.equals(clazz5)) {
                            if (!method.getParameterTypes()[++paramIndex].equals(Integer.TYPE)) {
                                throw new RuntimeException();
                            }
                        } else if (type.equals(Integer.TYPE)) {
                            mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
                        } else if (type.equals(Double.TYPE)) {
                            mv.visitMethodInsn(182, opeIName, "toDouble", "(I)D");
                        } else {
                            Class<?> clazz6 = class$10;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = Class.forName("hsplet.variable.ByteString");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (type.equals(clazz6)) {
                                mv.visitMethodInsn(182, opeIName, "toByteString", "(I)" + Type.getDescriptor(type));
                            } else {
                                Class<?> clazz7 = class$6;
                                if (clazz7 == null) {
                                    try {
                                        clazz7 = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (!type.equals(clazz7)) throw new UnsupportedOperationException("\u62e1\u5f35\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u5f15\u6570\u578b " + type + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                                StringBuffer stringBuffer = new StringBuffer("(I)");
                                Class<?> clazz8 = class$6;
                                if (clazz8 == null) {
                                    try {
                                        clazz8 = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                mv.visitMethodInsn(182, opeIName, "toString", stringBuffer.append(Type.getDescriptor(clazz8)).toString());
                            }
                        }
                    } else {
                        Class<?> clazz9 = class$1;
                        if (clazz9 == null) {
                            try {
                                clazz9 = Class.forName("hsplet.variable.Operand");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (type.equals(clazz9)) {
                            mv.visitInsn(1);
                            mv.visitInsn(3);
                            if (!method.getParameterTypes()[++paramIndex].equals(Integer.TYPE)) {
                                throw new RuntimeException("\u62e1\u5f35\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u5f15\u6570\u306b Operand \u3092\u53d7\u3051\u53d6\u3063\u305f\u3068\u304d\u306f\u304b\u306a\u3089\u305a\u305d\u306e\u6b21\u306e\u5f15\u6570\u3067\u914d\u5217\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3092\u53d7\u3051\u53d6\u3089\u306a\u3051\u308c\u3070\u3044\u3051\u307e\u305b\u3093\u3002");
                            }
                        } else if (type.equals(Integer.TYPE)) {
                            mv.visitInsn(3);
                        } else if (type.equals(Double.TYPE)) {
                            mv.visitInsn(14);
                        } else {
                            mv.visitInsn(1);
                        }
                    }
                }
            }
            ++paramIndex;
        }
        while (!(noeatparam || this.codeIndex >= this.ax.codes.length || this.ax.codes[this.codeIndex].newLine || this.ax.codes[this.codeIndex].type == 0 && this.ax.codes[this.codeIndex].value == 41)) {
            this.compileExpression(new EmptyVisitor());
        }
    }

    private void compileModuleCommand(MethodVisitor mv, boolean hasresult) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        Method method = this.runtime.getMethodFor(this.ax, code);
        String methodDesc = Type.getMethodDescriptor(method);
        ByteCode.Function function = this.ax.functions[code.value];
        if (function.isFunction()) {
            ++this.codeIndex;
        }
        this.compileModuleParameters(mv, function);
        if (function.isFunction()) {
            ++this.codeIndex;
        }
        mv.visitVarInsn(25, 2);
        mv.visitLdcInsn(new Integer(this.ax.functions[code.value].otindex));
        mv.visitMethodInsn(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), methodDesc);
        if (hasresult) {
            if (!function.isFunction()) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.classIName, "c" + this.literals.indexOf(new Integer(0)), literalDesc);
            } else {
                mv.visitInsn(3);
            }
        } else {
            mv.visitInsn(89);
            Label noassign = new Label();
            mv.visitJumpInsn(198, noassign);
            mv.visitVarInsn(25, 2);
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("hsplet.variable.IntScalar");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            mv.visitFieldInsn(180, contextIName, "stat", Type.getDescriptor(clazz));
            mv.visitInsn(95);
            mv.visitInsn(3);
            mv.visitInsn(95);
            mv.visitInsn(3);
            mv.visitMethodInsn(182, opeIName, "assign", "(I" + opeDesc + "I)V");
            Label end = new Label();
            mv.visitJumpInsn(167, end);
            mv.visitLabel(noassign);
            mv.visitInsn(87);
            mv.visitLabel(end);
        }
    }

    private void compileModuleParameters(MethodVisitor mv, ByteCode.Function function) {
        boolean firstParam = true;
        int paramIndex = 0;
        while (paramIndex < function.prmmax) {
            block32: {
                short type;
                block31: {
                    boolean omitted;
                    ByteCode.Parameter param = this.ax.parameters[function.prmindex + paramIndex];
                    type = param.mptype;
                    mv.visitVarInsn(25, 0);
                    ByteCode.Code code = this.ax.codes[this.codeIndex];
                    if (!(this.codeIndex >= this.ax.codes.length || code.newLine || code.type == 0 && code.value == 41)) {
                        if (firstParam && code.comma) {
                            omitted = true;
                        } else if (code.type == 0 && code.value == 63) {
                            omitted = true;
                            ++this.codeIndex;
                        } else {
                            omitted = false;
                        }
                    } else {
                        omitted = true;
                    }
                    firstParam = false;
                    if (omitted) break block31;
                    this.compileExpression(mv);
                    switch (type) {
                        case -3: 
                        case -1: 
                        case 1: {
                            mv.visitMethodInsn(182, opeIName, "ref", "(I)" + opeDesc);
                            break block32;
                        }
                        case -2: {
                            mv.visitInsn(87);
                            mv.visitInsn(3);
                            mv.visitMethodInsn(182, opeIName, "ref", "(I)" + opeDesc);
                            break block32;
                        }
                        case -6: 
                        case 2: {
                            StringBuffer stringBuffer = new StringBuffer("(I)");
                            Class<?> clazz = class$10;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("hsplet.variable.ByteString");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            mv.visitMethodInsn(182, opeIName, "toByteString", stringBuffer.append(Type.getDescriptor(clazz)).toString());
                            StringBuffer stringBuffer2 = new StringBuffer("(");
                            Class<?> clazz2 = class$10;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = Class.forName("hsplet.variable.ByteString");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            mv.visitMethodInsn(184, literalIName, "fromValue", stringBuffer2.append(Type.getDescriptor(clazz2)).append(")").append(literalDesc).toString());
                            break block32;
                        }
                        case 3: {
                            mv.visitMethodInsn(182, opeIName, "toDouble", "(I)D");
                            mv.visitMethodInsn(184, literalIName, "fromValue", "(D)" + literalDesc);
                            break block32;
                        }
                        case 4: {
                            mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
                            mv.visitMethodInsn(184, literalIName, "fromValue", "(I)" + literalDesc);
                            break block32;
                        }
                        case 5: {
                            throw new UnsupportedOperationException("\u30e6\u30fc\u30b6\u5b9a\u7fa9\u547d\u4ee4\u306e\u5f15\u6570\u578b struct \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        }
                        case 6: {
                            throw new UnsupportedOperationException("\u30e6\u30fc\u30b6\u5b9a\u7fa9\u547d\u4ee4\u306e\u5f15\u6570\u578b label \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        }
                        default: {
                            throw new UnsupportedOperationException("\u30e6\u30fc\u30b6\u5b9a\u7fa9\u547d\u4ee4\u306e\u5f15\u6570\u578b " + type + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        }
                    }
                }
                switch (type) {
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: {
                        throw new RuntimeException("\u30e6\u30fc\u30b6\u5b9a\u7fa9\u547d\u4ee4\u306e\u5f15\u6570\u306e\u5909\u6570\u306f\u7701\u7565\u3067\u304d\u307e\u305b\u3093\u3002");
                    }
                    case -6: 
                    case 2: {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, this.classIName, "c" + this.literals.indexOf(""), literalDesc);
                        break;
                    }
                    case 3: {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, this.classIName, "c" + this.literals.indexOf(new Double(0.0)), literalDesc);
                        break;
                    }
                    case 4: {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, this.classIName, "c" + this.literals.indexOf(new Integer(0)), literalDesc);
                        break;
                    }
                    case 5: {
                        throw new UnsupportedOperationException("\u30e6\u30fc\u30b6\u5b9a\u7fa9\u547d\u4ee4\u306e\u5f15\u6570\u578b struct \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    case 6: {
                        throw new UnsupportedOperationException("\u30e6\u30fc\u30b6\u5b9a\u7fa9\u547d\u4ee4\u306e\u5f15\u6570\u578b label \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    default: {
                        throw new UnsupportedOperationException("\u30e6\u30fc\u30b6\u5b9a\u7fa9\u547d\u4ee4\u306e\u5f15\u6570\u578b " + type + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                }
            }
            mv.visitFieldInsn(181, this.classIName, "p" + (function.prmindex + paramIndex), opeDesc);
            ++paramIndex;
        }
        while (!(this.codeIndex >= this.ax.codes.length || this.ax.codes[this.codeIndex].newLine || this.ax.codes[this.codeIndex].type == 0 && this.ax.codes[this.codeIndex].value == 41)) {
            this.compileExpression(new EmptyVisitor());
        }
    }

    private void compileFunction(MethodVisitor mv) {
        this.compileInvocation(mv, true, true);
    }

    private void compileSystemVariable(MethodVisitor mv) {
        Field field;
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 2);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("hsplet.Context");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            field = clazz.getField(systemVariables[code.value]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        mv.visitFieldInsn(180, contextIName, field.getName(), Type.getDescriptor(field.getType()));
        mv.visitInsn(3);
    }

    private void compileProgramCommand(MethodVisitor mv) {
        switch (this.ax.codes[this.codeIndex].value) {
            case 0: {
                this.compileGoto(mv);
                break;
            }
            case 2: {
                this.compileReturn(mv);
                break;
            }
            case 3: {
                this.compileBreak(mv);
                break;
            }
            case 4: {
                this.compileRepeat(mv);
                break;
            }
            case 5: {
                this.compileLoop(mv);
                break;
            }
            case 6: {
                this.compileContinue(mv);
                break;
            }
            case 11: {
                this.compileForeach(mv);
                break;
            }
            case 12: {
                this.compileForeachcheck(mv);
                break;
            }
            case 24: {
                this.compileExgoto(mv);
                break;
            }
            case 25: {
                this.compileOn(mv);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                this.compileCommand(mv);
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u30d7\u30ed\u30b0\u30e9\u30e0\u5236\u5fa1\u547d\u4ee4 " + this.ax.codes[this.codeIndex].value + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
        }
    }

    private void compileGoto(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        ByteCode.Code label = this.ax.codes[this.codeIndex++];
        mv.visitJumpInsn(167, this.getLabel(label.value));
    }

    private void compileReturn(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        if (this.codeIndex < this.ax.codes.length && !this.ax.codes[this.codeIndex].newLine) {
            this.compileExpression(mv);
            mv.visitMethodInsn(182, opeIName, "ref", "(I)" + opeDesc);
        } else {
            mv.visitInsn(1);
        }
        mv.visitInsn(176);
    }

    private void compileRepeat(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        ByteCode.Code label = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 2);
        if (this.codeIndex < this.ax.codes.length && !this.ax.codes[this.codeIndex].newLine) {
            this.compileExpression(mv);
            mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
        } else {
            mv.visitInsn(2);
        }
        if (this.codeIndex < this.ax.codes.length && !this.ax.codes[this.codeIndex].newLine) {
            this.compileExpression(mv);
            mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
        } else {
            mv.visitInsn(3);
        }
        mv.visitMethodInsn(182, contextIName, "startLoop", "(II)Z");
        mv.visitJumpInsn(153, this.getLabel(label.value));
        Label startLabel = new Label();
        mv.visitLabel(startLabel);
        this.loopStarts.add(startLabel);
    }

    private void compileBreak(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        ByteCode.Code label = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, contextIName, "endLoop", "()V");
        mv.visitJumpInsn(167, this.getLabel(label.value));
    }

    private void compileLoop(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, contextIName, "nextLoop", "()Z");
        mv.visitJumpInsn(154, (Label)this.loopStarts.pop());
    }

    private void compileContinue(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        ByteCode.Code label = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 2);
        if (this.codeIndex < this.ax.codes.length && !this.ax.codes[this.codeIndex].newLine) {
            this.compileExpression(mv);
            mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
            mv.visitMethodInsn(182, contextIName, "nextLoop", "(I)Z");
        } else {
            mv.visitMethodInsn(182, contextIName, "nextLoop", "()Z");
        }
        mv.visitJumpInsn(154, (Label)this.loopStarts.peek());
        mv.visitJumpInsn(167, this.getLabel(label.value));
    }

    private void compileForeach(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        ByteCode.Code label = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 2);
        mv.visitInsn(2);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, contextIName, "startLoop", "(II)Z");
        mv.visitJumpInsn(153, this.getLabel(label.value));
        Label startLabel = new Label();
        mv.visitLabel(startLabel);
        this.loopStarts.add(startLabel);
    }

    private void compileForeachcheck(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        ByteCode.Code label = this.ax.codes[this.codeIndex++];
        mv.visitVarInsn(25, 2);
        this.compileExpression(mv);
        mv.visitInsn(87);
        mv.visitMethodInsn(182, contextIName, "checkForeach", "(" + opeDesc + ")Z");
        mv.visitJumpInsn(153, this.getLabel(label.value));
    }

    private void compileExgoto(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        this.compileExpression(mv);
        mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
        this.compileExpression(mv);
        mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
        this.compileExpression(mv);
        mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
        mv.visitInsn(95);
        ByteCode.Code label = this.ax.codes[this.codeIndex++];
        Label negative = new Label();
        mv.visitJumpInsn(158, negative);
        Label nojump = new Label();
        mv.visitJumpInsn(162, this.getLabel(label.value));
        mv.visitJumpInsn(167, nojump);
        mv.visitLabel(negative);
        mv.visitJumpInsn(164, this.getLabel(label.value));
        mv.visitLabel(nojump);
    }

    private void compileOn(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        this.compileExpression(mv);
        mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
        ByteCode.Code statement = this.ax.codes[this.codeIndex++];
        ArrayList<Label> labels = new ArrayList<Label>();
        ArrayList<Integer> labelIndexs = new ArrayList<Integer>();
        while (this.codeIndex < this.ax.codes.length && !this.ax.codes[this.codeIndex].newLine) {
            ByteCode.Code label = this.ax.codes[this.codeIndex++];
            labels.add(this.getLabel(label.value));
            labelIndexs.add(new Integer(label.value));
        }
        if (statement.value == 0) {
            Label nojump = new Label();
            mv.visitTableSwitchInsn(0, labels.size() - 1, nojump, labels.toArray(new Label[0]));
            mv.visitLabel(nojump);
        } else {
            Method method = this.runtime.getMethodFor(this.ax, statement);
            String methodDesc = Type.getMethodDescriptor(method);
            Label[] pushLabels = new Label[labels.size()];
            int i = 0;
            while (i < pushLabels.length) {
                pushLabels[i] = new Label();
                ++i;
            }
            Label endSwitch = new Label();
            Label nojump = new Label();
            mv.visitTableSwitchInsn(0, labels.size() - 1, nojump, pushLabels);
            int i2 = 0;
            while (i2 < pushLabels.length) {
                Label label = pushLabels[i2];
                mv.visitLabel(label);
                mv.visitLdcInsn(labelIndexs.get(i2));
                mv.visitJumpInsn(167, endSwitch);
                ++i2;
            }
            mv.visitLabel(endSwitch);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(95);
            mv.visitMethodInsn(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), methodDesc);
            if (!method.getReturnType().equals(Void.TYPE)) {
                mv.visitInsn(87);
            }
            mv.visitLabel(nojump);
        }
    }

    private void compileCommand(MethodVisitor mv) {
        this.compileInvocation(mv, false, false);
    }

    private void compileDllFunction(MethodVisitor mv) {
        this.compileInvocation(mv, true, true);
    }

    private void compileDllCommand(MethodVisitor mv) {
        mv.visitVarInsn(25, 2);
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("hsplet.variable.IntScalar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mv.visitFieldInsn(180, contextIName, "stat", Type.getDescriptor(clazz));
        mv.visitInsn(3);
        this.compileInvocation(mv, false, true);
        mv.visitMethodInsn(182, opeIName, "assign", "(I" + opeDesc + "I)V");
    }

    private void compileCompareCommand(MethodVisitor mv) {
        switch (this.ax.codes[this.codeIndex].value) {
            case 0: {
                this.compileIf(mv);
                break;
            }
            case 1: {
                this.compileElse(mv);
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u6761\u4ef6\u5206\u5c90\u547d\u4ee4 " + this.ax.codes[this.codeIndex].value + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
        }
    }

    private void compileIf(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        int offset = this.ax.codes[this.codeIndex++].value;
        int base = this.ax.codes[this.codeIndex].offset;
        this.compileExpression(mv);
        mv.visitMethodInsn(182, opeIName, "toInt", "(I)I");
        Label existingLabel = (Label)this.labels.get(new Integer(base + offset));
        if (existingLabel != null) {
            mv.visitJumpInsn(153, existingLabel);
        } else {
            Label label = new Label();
            this.labels.put(new Integer(base + offset), label);
            mv.visitJumpInsn(153, label);
        }
    }

    private void compileElse(MethodVisitor mv) {
        ByteCode.Code code = this.ax.codes[this.codeIndex++];
        int base = this.ax.codes[this.codeIndex].offset;
        int offset = this.ax.codes[this.codeIndex++].value;
        Label existingLabel = (Label)this.labels.get(new Integer(base + offset));
        if (existingLabel != null) {
            mv.visitJumpInsn(167, existingLabel);
        } else {
            Label label = new Label();
            this.labels.put(new Integer(base + offset), label);
            mv.visitJumpInsn(167, label);
        }
    }

    private void createSubMethods() {
        int totalSize = 0;
        int i = 0;
        while (i < this.submethodStartEnds.size()) {
            totalSize += ((int[])this.submethodStartEnds.get(i))[1] - ((int[])this.submethodStartEnds.get(i))[0];
            this.prepareLabels();
            this.codeIndex = ((int[])this.submethodStartEnds.get(i))[0];
            MethodVisitor mv = this.cw.visitMethod(2, "m" + i, "()V", null, new String[0]);
            this.compileSeparatedMethod(mv, ((int[])this.submethodStartEnds.get(i))[1]);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            ++i;
        }
    }
}

