package hsplet.gui;

import hsplet.variable.Operand;

import java.awt.Component;
import java.awt.TextField;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;

/**
 * EBhEǗNXB
 * 
 * @author Yuki
 * @version $Revision: 1.3 $, $Date: 2006/05/20 06:12:07 $
 */
public class WindowManager {

	private static final Map handleToObject = new HashMap();

	private static final Map objectToHandle = new WeakHashMap();

	private static int lastHandle = 0;

	public static synchronized void registerComponent(Component c) {

		getHandle(c);
	}

	public static synchronized int getHandle(Component c) {

		Integer handle = (Integer) objectToHandle.get(c);

		if (handle == null) {

			handle = new Integer(++lastHandle);

			handleToObject.put(handle, new WeakReference(c));
			objectToHandle.put(c, handle);
		}

		return handle.intValue();
	}

	public static synchronized Component getComponent(int handle) {

		final WeakReference ref = (WeakReference) handleToObject.get(new Integer(handle));

		if (ref == null) {
			return null;
		}

		return (Component) ref.get();
	}

}
