/*
 * $Id: Mesbox.java,v 1.4 2006/02/27 15:52:05 Yuki Exp $
 */
package hsplet.gui;

import hsplet.function.ControlCommand;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import hsplet.variable.VolatileValue;
import hsplet.variable.VolatileValueUpdater;

import java.awt.Component;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;

/**
 * mesbox Rg[B
 * <p>
 * eύXꂽϐXVB
 * </p>
 * 
 * @author Yuki
 * @version $Revision: 1.4 $, $Date: 2006/02/27 15:52:05 $
 */
public class Mesbox extends JScrollPane implements VolatileValueUpdater, HSPControl, DocumentListener {

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: Mesbox.java,v 1.4 2006/02/27 15:52:05 Yuki Exp $";

	/** 񉻕ɁAf[^̌݊mF邽߂̃o[WԍB */
	private static final long serialVersionUID = 2562206890409286100L;

	/** ϐ */
	private VolatileValue v;

	/** ϐCfbNX */
	private int vi;

	/** eLXgGA */
	private final JTextArea text;

	/** UNDO ǗIuWFNg */
	private UndoManager undo = new UndoManager();

	/**
	 * IuWFNg\zB
	 * @param v \ϐB
	 * @param vi \ϐ̃CfbNXB
	 * @param editable ҏW\ǂB
	 * @param hscroll XN[\ǂB
	 */
	public Mesbox(final Variable v, final int vi, boolean editable, boolean hscroll) {

		super(VERTICAL_SCROLLBAR_ALWAYS, hscroll ? HORIZONTAL_SCROLLBAR_ALWAYS : HORIZONTAL_SCROLLBAR_NEVER);

		text = new JTextArea(v.toString(vi));

		text.setEditable(editable);

		text.getDocument().addUndoableEditListener(new UndoableEditListener() {
			public void undoableEditHappened(UndoableEditEvent e) {
				undo.addEdit(e.getEdit());
			}
		});

		this.v = v.makeVolatile();
		this.vi = vi;

		text.getDocument().addDocumentListener(this);

		setViewportView(text);
	}
	
	public void requestFocus() {
		text.requestFocus();
	}
	
	public boolean requestFocus(boolean temporary) {
		return text.requestFocus(temporary);
	}

	public boolean requestFocusInWindow() {
		return text.requestFocusInWindow();
	}

	public void update(final Operand value) {

		value.assign(vi, Scalar.fromValue(text.getText()), 0);
	}

	public Component asComponent() {
		return this;
	}

	public void setValue(Operand v, int vi) {

		text.setText(v.toString(vi));

		this.v.updaters.add(this);
	}

	public void changedUpdate(DocumentEvent e) {
		this.v.updaters.add(this);

	}

	public void insertUpdate(DocumentEvent e) {
		this.v.updaters.add(this);

	}

	public void removeUpdate(DocumentEvent e) {
		this.v.updaters.add(this);

	}

	public int sendMessage(int message, Operand wparam, Operand lparam) {

		switch (message) {
		case 0x00C6: //EM_CANUNDO
			return undo.canUndo() ? 1 : 0;
		case 0x00C7: //EM_UNDO
			if (undo.canUndo()) {
				undo.undoOrRedo();
				return 1;
			} else {
				return 0;
			}
		}

		return ControlCommand.defaultSendMessage(text, message, wparam, 0, lparam, 0);
	}
}
