/*
 * Decompiled with CFR 0.152.
 */
package hsplet.variable;

import hsplet.variable.Array;
import hsplet.variable.ByteString;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;

public final class IntArray
extends Array {
    private static final long serialVersionUID = -4406165790569093040L;
    private static final String fileVersionID = "$Id: IntArray.java,v 1.2 2006/01/13 20:32:12 Yuki Exp $";
    private int[] values;

    public IntArray() {
        this(16, 1, 1, 1);
    }

    public IntArray(int l0, int l1, int l2, int l3) {
        super(l0, l1, l2, l3);
        this.values = new int[l0 * l1 * l2 * l3];
    }

    public int getType() {
        return 4;
    }

    public String toString(int index) {
        return Integer.toString(this.values[index]);
    }

    public ByteString toByteString(int index) {
        return new ByteString(Integer.toString(this.values[index]));
    }

    public int toInt(int index) {
        return this.values[index];
    }

    public double toDouble(int index) {
        return this.values[index];
    }

    public void inc(int index) {
        int n = index;
        this.values[n] = this.values[n] + 1;
    }

    public void dec(int index) {
        int n = index;
        this.values[n] = this.values[n] - 1;
    }

    public void assign(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        this.values[index] = rhs.toInt(rhi);
    }

    public void assignAdd(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] + rhs.toInt(rhi);
    }

    public void assignSub(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] - rhs.toInt(rhi);
    }

    public void assignMul(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] * rhs.toInt(rhi);
    }

    public void assignDiv(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] / rhs.toInt(rhi);
    }

    public void assignMod(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] % rhs.toInt(rhi);
    }

    public void assignAnd(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] & rhs.toInt(rhi);
    }

    public void assignOr(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] | rhs.toInt(rhi);
    }

    public void assignXor(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] ^ rhs.toInt(rhi);
    }

    public void assignSr(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] >> rhs.toInt(rhi);
    }

    public void assignSl(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] << rhs.toInt(rhi);
    }

    public void expand(int index) {
        super.expand(index);
        int[] newValues = new int[this.l0 * this.l1 * this.l2 * this.l3];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        this.values = newValues;
    }

    public Operand add(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] + rhs.toInt(rhi));
    }

    public Operand eq(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] == rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand ne(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] != rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand gt(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] > rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand lt(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] < rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand ge(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] >= rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand le(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] <= rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand sub(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] - rhs.toInt(rhi));
    }

    public Operand mul(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] * rhs.toInt(rhi));
    }

    public Operand div(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] / rhs.toInt(rhi));
    }

    public Operand mod(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] % rhs.toInt(rhi));
    }

    public Operand and(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] & rhs.toInt(rhi));
    }

    public Operand or(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] | rhs.toInt(rhi));
    }

    public Operand xor(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] ^ rhs.toInt(rhi));
    }

    public Operand sl(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] << rhs.toInt(rhi));
    }

    public Operand sr(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.values[index] >> rhs.toInt(rhi));
    }

    public byte peek(int index, int offset) {
        return (byte)(this.values[index + offset / 4] >> offset % 4 * 8);
    }

    public void poke(int index, int offset, byte value) {
        int bits = this.values[index + offset / 4];
        bits &= ~(255 << offset % 4 * 8);
        this.values[index + offset / 4] = bits |= (value & 0xFF) << offset % 4 * 8;
    }
}

