/*
 * Decompiled with CFR 0.152.
 */
package hsplet.media;

import hsplet.Context;
import hsplet.media.HSPMedia;
import hsplet.media.Mp3;
import hsplet.media.Music;
import hsplet.media.Sound;
import hsplet.util.Conversion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Mci
implements Serializable {
    private static final String fileVersionID = "$Id: Mci.java,v 1.6 2006/02/05 10:08:14 Yuki Exp $";
    private static final long serialVersionUID = -3044829753912949031L;
    private final Context context;
    private Map medias = new HashMap();

    public Mci(Context context) {
        this.context = context;
    }

    public void exec(String command) {
        String[] commands = Mci.split(command);
        if (commands.length < 1) {
            return;
        }
        if (commands[0].equalsIgnoreCase("open")) {
            this.open(commands);
        } else if (commands[0].equalsIgnoreCase("set")) {
            this.set(commands);
        } else if (commands[0].equalsIgnoreCase("seek")) {
            this.seek(commands);
        } else if (commands[0].equalsIgnoreCase("play")) {
            this.play(commands);
        } else if (commands[0].equalsIgnoreCase("status")) {
            this.status(commands);
        } else if (commands[0].equalsIgnoreCase("stop")) {
            this.stop(commands);
        } else if (commands[0].equalsIgnoreCase("close")) {
            this.close(commands);
        } else {
            throw new UnsupportedOperationException("mci \u547d\u4ee4 " + command + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    private void open(String[] commands) {
        try {
            String fileName = commands[1];
            String name = commands.length >= 4 && commands[2].equalsIgnoreCase("alias") ? commands[3] : fileName;
            HSPMedia media = this.open(fileName, 0);
            this.medias.put(name, media);
            this.context.stat.value = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.context.stat.value = -1;
        }
    }

    public HSPMedia open(String fileName, int mode) throws Exception {
        HSPMedia media = null;
        if (fileName.toLowerCase().endsWith(".mp3")) {
            try {
                media = new Mp3(this.context, fileName, mode);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (fileName.toLowerCase().endsWith(".mid")) {
            try {
                media = new Music(this.context, fileName, mode);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (media == null) {
            try {
                media = new Sound(this.context, fileName, mode);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (media == null) {
            try {
                media = new Music(this.context, fileName, mode);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (media == null) {
            try {
                media = new Mp3(this.context, fileName, mode);
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw new Exception(e);
            }
        }
        return media;
    }

    private final void set(String[] commands) {
        HSPMedia media = (HSPMedia)this.medias.get(commands[1]);
        if (media == null) {
            this.context.stat.value = -1;
            return;
        }
        String prop = commands[2];
        prop.equalsIgnoreCase("time");
    }

    private void play(String[] commands) {
        HSPMedia media = (HSPMedia)this.medias.get(commands[1]);
        if (media == null) {
            this.context.stat.value = -1;
            return;
        }
        media.play();
    }

    private void seek(String[] commands) {
        HSPMedia media = (HSPMedia)this.medias.get(commands[1]);
        if (media == null) {
            this.context.stat.value = -1;
            return;
        }
        if (!commands[2].equalsIgnoreCase("to")) {
            this.context.stat.value = -1;
            return;
        }
        String position = commands[3];
        media.setPosition(Conversion.strtoi(position));
        this.context.stat.value = 0;
    }

    private void status(String[] commands) {
        HSPMedia media = (HSPMedia)this.medias.get(commands[1]);
        if (media == null) {
            this.context.stat.value = -1;
            return;
        }
        String prop = commands[2];
        if (prop.equalsIgnoreCase("position")) {
            this.context.stat.value = media.getPosition();
        }
    }

    private void close(String[] commands) {
        HSPMedia media = (HSPMedia)this.medias.get(commands[1]);
        if (media == null) {
            this.context.stat.value = -1;
            return;
        }
        media.dispose();
    }

    private void stop(String[] commands) {
        HSPMedia media = (HSPMedia)this.medias.get(commands[1]);
        if (media == null) {
            this.context.stat.value = -1;
            return;
        }
        media.stop();
    }

    private static String[] split(String command) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < command.length()) {
            char ch = command.charAt(i);
            if (Character.isWhitespace(ch)) {
                ++i;
                continue;
            }
            if (ch == '\"') {
                int end = command.indexOf(34, i + 1);
                if (end < 0) {
                    end = command.length();
                }
                result.add(command.substring(i + 1, end));
                i = end + 1;
                continue;
            }
            int start = i;
            while (i < command.length() && !Character.isWhitespace(command.charAt(i))) {
                ++i;
            }
            result.add(command.substring(start, i));
        }
        return result.toArray(new String[0]);
    }

    public void dispose() {
        Iterator i = this.medias.values().iterator();
        while (i.hasNext()) {
            HSPMedia media = (HSPMedia)i.next();
            media.stop();
            media.dispose();
        }
        this.medias.clear();
    }
}

