/*
 * Decompiled with CFR 0.152.
 */
package hsplet.gui;

import hsplet.function.ControlCommand;
import hsplet.gui.HSPControl;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import hsplet.variable.VolatileValue;
import hsplet.variable.VolatileValueUpdater;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;

public class Mesbox
extends JScrollPane
implements VolatileValueUpdater,
HSPControl,
DocumentListener {
    private static final String fileVersionID = "$Id: Mesbox.java,v 1.4 2006/02/27 15:52:05 Yuki Exp $";
    private static final long serialVersionUID = 2562206890409286100L;
    private VolatileValue v;
    private int vi;
    private final JTextArea text;
    private UndoManager undo = new UndoManager();

    public Mesbox(Variable v, int vi, boolean editable, boolean hscroll) {
        super(22, hscroll ? 32 : 31);
        this.text = new JTextArea(v.toString(vi));
        this.text.setEditable(editable);
        this.text.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent e) {
                Mesbox.this.undo.addEdit(e.getEdit());
            }
        });
        this.v = v.makeVolatile();
        this.vi = vi;
        this.text.getDocument().addDocumentListener(this);
        this.setViewportView(this.text);
    }

    public void requestFocus() {
        this.text.requestFocus();
    }

    public boolean requestFocus(boolean temporary) {
        return this.text.requestFocus(temporary);
    }

    public boolean requestFocusInWindow() {
        return this.text.requestFocusInWindow();
    }

    public void update(Operand value) {
        value.assign(this.vi, Scalar.fromValue(this.text.getText()), 0);
    }

    public Component asComponent() {
        return this;
    }

    public void setValue(Operand v, int vi) {
        this.text.setText(v.toString(vi));
        this.v.updaters.add(this);
    }

    public void changedUpdate(DocumentEvent e) {
        this.v.updaters.add(this);
    }

    public void insertUpdate(DocumentEvent e) {
        this.v.updaters.add(this);
    }

    public void removeUpdate(DocumentEvent e) {
        this.v.updaters.add(this);
    }

    public int sendMessage(int message, Operand wparam, Operand lparam) {
        switch (message) {
            case 198: {
                return this.undo.canUndo() ? 1 : 0;
            }
            case 199: {
                if (this.undo.canUndo()) {
                    this.undo.undoOrRedo();
                    return 1;
                }
                return 0;
            }
        }
        return ControlCommand.defaultSendMessage(this.text, message, wparam, 0, lparam, 0);
    }
}

