/*
 * Decompiled with CFR 0.152.
 */
package hsplet;

import hsplet.Applet;
import hsplet.gui.Browser;
import hsplet.gui.DebugWindow;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.UIManager;

public final class Application
extends JFrame
implements AppletStub,
AppletContext {
    private static final String fileVersionID = "$Id: Application.java,v 1.7 2006/02/11 18:00:38 Yuki Exp $";
    private static final long serialVersionUID = 3051070041292384848L;
    public static final String APPLET_NAME = "HSPLet";
    private final Map parameters = new HashMap();
    private final Map streams = Collections.synchronizedMap(new HashMap());
    private final Applet applet;

    public static void main(String[] args) {
        int width = 640;
        int height = 480;
        boolean debug = false;
        String startClass = "start";
        String cmdline = "";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("--width=")) {
                width = Integer.parseInt(arg.substring("--width=".length()));
            } else if (arg.startsWith("--height=")) {
                height = Integer.parseInt(arg.substring("--height=".length()));
            } else if (arg.startsWith("--debug=")) {
                debug = Boolean.valueOf(arg.substring("--debug=".length()));
            } else if (arg.startsWith("--startClass=")) {
                startClass = arg.substring("--startClass=".length());
            } else if (arg.startsWith("--cmdline=")) {
                cmdline = arg.substring("--cmdline=".length());
            }
            ++i;
        }
        try {
            Application.run(Class.forName(startClass), width, height, debug, cmdline);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Application run(Class startClass, int width, int height, boolean debug, String cmdline) {
        return new Application(startClass, width, height, debug, cmdline);
    }

    private Application(Class startClass, int width, int height, boolean debug, String cmdline) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (debug) {
            final DebugWindow debugWindow = new DebugWindow();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    debugWindow.dispose();
                }
            });
        }
        this.parameters.put("startClass", startClass.getName());
        this.parameters.put("cmdline", cmdline);
        this.parameters.putAll(System.getProperties());
        this.applet = new Applet();
        this.applet.setStub(this);
        this.setContentPane(this.applet);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.applet.getBmscr().contents.setPreferredSize(new Dimension(width, height));
        this.applet.getBmscr().contents.setSize(new Dimension(width, height));
        this.pack();
        ((Component)this).setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - this.getHeight()) / 2);
        this.getContentPane().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Application.this.pack();
            }
        });
        this.applet.init(startClass);
        this.applet.start();
        ((Component)this).setVisible(true);
    }

    public void dispose() {
        this.applet.stop();
        this.applet.destroy();
        super.dispose();
        System.exit(0);
    }

    public java.applet.Applet getApplet(String name) {
        return name != null && name.equals(APPLET_NAME) ? this.applet : null;
    }

    public void showDocument(URL url) {
        this.showDocument(url, "_self");
    }

    public void showDocument(URL url, String target) {
        Browser.showPage(url, target);
    }

    public AudioClip getAudioClip(URL url) {
        return java.applet.Applet.newAudioClip(url);
    }

    public Enumeration getApplets() {
        Vector<Applet> v = new Vector<Applet>();
        v.add(this.applet);
        return v.elements();
    }

    public void showStatus(String status) {
        this.setTitle(status);
    }

    public Image getImage(URL url) {
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public void appletResize(int width, int height) {
        Dimension prevSize = this.applet.getPreferredSize();
        if (prevSize.width != width || prevSize.height != height) {
            this.applet.setSize(new Dimension(width, height));
        }
    }

    public URL getCodeBase() {
        return this.getDocumentBase();
    }

    public URL getDocumentBase() {
        String classPath = System.getProperty("user.dir");
        try {
            return new File(String.valueOf(classPath) + "/").toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public void setStream(String key, InputStream stream) {
        this.streams.put(key, stream);
    }

    public InputStream getStream(String key) {
        return (InputStream)this.streams.get(key);
    }

    public Iterator getStreamKeys() {
        return this.streams.keySet().iterator();
    }
}

