/*
 * Decompiled with CFR 0.152.
 */
package hsplet.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DebugWindow
extends JFrame {
    private static final String fileVersionID = "$Id: DebugWindow.java,v 1.4 2006/03/26 14:35:36 Yuki Exp $";
    private static final long serialVersionUID = -9025077661160161316L;
    private PrintStream oldOut;
    private PrintStream oldError;
    private JScrollPane scrollPane = null;
    JTextArea logText = null;

    public DebugWindow() {
        this.initialize();
        this.oldOut = System.out;
        this.oldError = System.err;
        final ByteArrayOutputStream logBuffer = new ByteArrayOutputStream();
        try {
            System.setOut(new PrintStream(new OutputStream(){

                public void write(byte[] b) throws IOException {
                    logBuffer.write(b);
                    try {
                        DebugWindow.this.logText.setText(new String(logBuffer.toByteArray(), "MS932"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void write(byte[] b, int off, int len) {
                    logBuffer.write(b, off, len);
                    try {
                        DebugWindow.this.logText.setText(new String(logBuffer.toByteArray(), "MS932"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void write(int b) {
                    logBuffer.write(b);
                    try {
                        DebugWindow.this.logText.setText(new String(logBuffer.toByteArray(), "MS932"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, true, "MS932"));
            System.setErr(System.out);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
        ((Component)this).setVisible(true);
    }

    public void dispose() {
        super.dispose();
        System.setOut(this.oldOut);
        System.setErr(this.oldError);
    }

    private void initialize() {
        ((Component)this).setSize(new Dimension(493, 210));
        this.setContentPane(this.getScrollPane());
        this.setTitle("Debug Window");
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getLogText());
        }
        return this.scrollPane;
    }

    private JTextArea getLogText() {
        if (this.logText == null) {
            this.logText = new JTextArea();
            this.logText.setFont(new Font("Dialog", 0, 10));
        }
        return this.logText;
    }
}

