/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.Opcodes;

public class MethodDebugger
extends MethodAdapter
implements Serializable,
Opcodes {
    private static final String fileVersionID = "$Id: MethodDebugger.java,v 1.3 2006/01/13 20:32:11 Yuki Exp $";
    private static final long serialVersionUID = -8947987460775942821L;
    static /* synthetic */ Class class$0;

    public MethodDebugger(ClassVisitor cv, int access, String name, String desc, String signature, String[] exceptions) {
        super(cv.visitMethod(access, name, desc, signature, exceptions));
        System.out.println("METHOD " + name + desc + " START >>>>");
    }

    public void visitEnd() {
        System.out.println("<<<< METHOD END");
        System.out.println();
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        System.out.println("\tLABEL:" + label.hashCode());
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        System.out.println("\t" + MethodDebugger.opcodeName(opcode) + " -> LABEL:" + label.hashCode());
    }

    public void visitLookupSwitchInsn(Label def, int[] values, Label[] labels) {
        super.visitLookupSwitchInsn(def, values, labels);
        System.out.println("\tSWITCH -> LABEL:" + def);
        int i = 0;
        while (i < labels.length) {
            System.out.println("\tSWITCH -> LABEL:" + labels[i].hashCode());
            ++i;
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label def, Label[] labels) {
        super.visitTableSwitchInsn(min, max, def, labels);
        System.out.println("\tSWITCH -> LABEL:" + def);
        int i = 0;
        while (i < labels.length) {
            System.out.println("\tSWITCH -> LABEL:" + labels[i].hashCode());
            ++i;
        }
    }

    private static String opcodeName(int opcode) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.objectweb.asm.Opcodes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field[] fields = clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!field.getName().startsWith("V1_")) {
                try {
                    Object o = field.get(null);
                    if (o instanceof Integer && (Integer)o == opcode) {
                        return field.getName();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return "";
    }
}

