/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LibraryLoader
extends ClassLoader {
    Set usedLibs = new HashSet();
    Map loadedClasses = new HashMap();
    String[] optlibs;
    URLClassLoader[] optloaders;

    public LibraryLoader(String[] libs, String[] libdirs, ClassLoader parent) throws MalformedURLException {
        super(new URLClassLoader(LibraryLoader.toURLs(libs), parent));
        this.usedLibs.addAll(Arrays.asList(libs));
        this.optlibs = LibraryLoader.collectLibs(libdirs);
        this.optloaders = new URLClassLoader[this.optlibs.length];
        int i = 0;
        while (i < this.optlibs.length) {
            this.optloaders[i] = new URLClassLoader(new URL[]{new File(this.optlibs[i]).getAbsoluteFile().toURL()}, parent);
            ++i;
        }
    }

    public Set getUsedLibs() {
        return this.usedLibs;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class existing = (Class)this.loadedClasses.get(name);
        if (existing != null) {
            return existing;
        }
        int i = 0;
        while (i < this.optloaders.length) {
            try {
                Class<?> loaded = this.optloaders[i].loadClass(name);
                this.usedLibs.add(this.optlibs[i]);
                this.loadedClasses.put(name, loaded);
                return loaded;
            }
            catch (Exception exception) {
                ++i;
            }
        }
        i = 0;
        while (i < this.optlibs.length) {
            System.out.println("Found jar:" + this.optlibs[i]);
            ++i;
        }
        return super.findClass(name);
    }

    private static URL[] toURLs(String[] libs) throws MalformedURLException {
        URL[] result = new URL[libs.length];
        int i = 0;
        while (i < libs.length) {
            result[i] = new File(libs[i]).getAbsoluteFile().toURL();
            ++i;
        }
        return result;
    }

    private static String[] collectLibs(String[] libdirs) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < libdirs.length) {
            File[] files = new File(libdirs[i]).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".jar");
                }
            });
            int j = 0;
            while (j < files.length) {
                result.add(files[j].getPath());
                ++j;
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }
}

