/*
 * Decompiled with CFR 0.152.
 */
package hsplet.function;

import hsplet.Context;
import hsplet.function.Formatter;
import hsplet.function.FunctionBase;
import hsplet.variable.ByteString;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import java.io.File;
import java.util.Calendar;

public class BasicFunction
extends FunctionBase {
    private static final String fileVersionID = "$Id: BasicFunction.java,v 1.6 2006/02/05 10:08:13 Yuki Exp $";
    private static final Calendar calendar = Calendar.getInstance();

    public static int int_(int i) {
        return i;
    }

    public static int rnd(Context context, Operand v, int vi) {
        return context.random.rand() % Math.abs(FunctionBase.toInt(v, vi, Integer.MIN_VALUE));
    }

    public static int strlen(Context context, ByteString str) {
        if (str == null) {
            context.error(5, "strlen", "str");
            return 0;
        }
        return str.length();
    }

    public static int length(Context context, Operand v, int vi) {
        if (v == null) {
            context.error(5, "length", "v");
            return 0;
        }
        return v.l0();
    }

    public static int length2(Context context, Operand v, int vi) {
        if (v == null) {
            context.error(5, "length2", "v");
            return 0;
        }
        return v.l1();
    }

    public static int length3(Context context, Operand v, int vi) {
        if (v == null) {
            context.error(5, "length3", "v");
            return 0;
        }
        return v.l2();
    }

    public static int length4(Context context, Operand v, int vi) {
        if (v == null) {
            context.error(5, "length4", "v");
            return 0;
        }
        return v.l3();
    }

    public static int vartype(Context context, String name) {
        if (name == null) {
            context.error(5, "vartype", "name");
            return 0;
        }
        if (name.equals("int")) {
            return 4;
        }
        if (name.equals("str")) {
            return 2;
        }
        if (name.equals("double")) {
            return 3;
        }
        return 0;
    }

    public static Operand gettime(Context context, int type) {
        int result;
        calendar.setTimeInMillis(System.currentTimeMillis());
        switch (type) {
            case 0: {
                result = calendar.get(1);
                break;
            }
            case 1: {
                result = calendar.get(2) + 1;
                break;
            }
            case 2: {
                result = calendar.get(7) - 1;
                break;
            }
            case 3: {
                result = calendar.get(5);
                break;
            }
            case 4: {
                result = calendar.get(11);
                break;
            }
            case 5: {
                result = calendar.get(12);
                break;
            }
            case 6: {
                result = calendar.get(13);
                break;
            }
            case 7: {
                result = calendar.get(14);
                break;
            }
            default: {
                context.error(3, "gettime", "type==" + type);
                result = 0;
            }
        }
        return Scalar.fromValue(result);
    }

    public static int peek(Context context, Operand v, int vi, int index) {
        if (v == null) {
            context.error(5, "peek", "v");
            return 0;
        }
        return v.peek(vi, index) & 0xFF;
    }

    public static int wpeek(Context context, Operand v, int vi, int index) {
        if (v == null) {
            context.error(5, "wpeek", "v");
            return 0;
        }
        return BasicFunction.peek(context, v, vi, index) | BasicFunction.peek(context, v, vi, index) << 8;
    }

    public static int lpeek(Context context, Operand v, int vi, int index) {
        if (v == null) {
            context.error(5, "lpeek", "v");
            return 0;
        }
        return BasicFunction.wpeek(context, v, vi, index) | BasicFunction.wpeek(context, v, vi, index) << 16;
    }

    public static int varptr(Context context, Operand v, int vi) {
        context.error(21, "varptr");
        return 0;
    }

    public static int varuse(Context context, Operand v, int vi) {
        context.error(21, "varuse");
        return 0;
    }

    public static int noteinfo(Context context, int type) {
        switch (type) {
            case 0: {
                ByteString note = context.note.toByteString(0);
                if (note.length() == 0) {
                    return 0;
                }
                int lineCount = 1;
                int i = 0;
                while (i < note.length() - 1) {
                    if ((note.get(i) & 0xFF) == 10) {
                        ++lineCount;
                    }
                    ++i;
                }
                return lineCount;
            }
            case 1: {
                return context.note.toByteString(0).length();
            }
        }
        context.error(3, "noteinfo", "type==" + type);
        return 0;
    }

    public static int instr(Context context, ByteString str, int index, ByteString substr) {
        if (str == null) {
            context.error(5, "instr", "str");
            return 0;
        }
        if (substr == null) {
            context.error(5, "instr", "substr");
            return 0;
        }
        return str.indexOf(substr, index);
    }

    public static int abs(int i) {
        return Math.abs(i);
    }

    public static int limit(int val, int min, int max) {
        return Math.min(Math.max(min, val), max);
    }

    public static ByteString str(Context context, ByteString str) {
        if (str == null) {
            context.error(5, "str", "str");
            return new ByteString("");
        }
        return str;
    }

    public static ByteString strmid(Context context, ByteString str, int index, int count) {
        if (str == null) {
            context.error(5, "strmid", "str");
            return new ByteString("");
        }
        if (index >= 0) {
            return str.substring(index, count);
        }
        return str.substring(str.length() + index, count);
    }

    public static String strf(Context context, String format, Operand v, int vi) {
        if (format == null) {
            context.error(5, "strf", "format");
            return "";
        }
        if (v == null) {
            context.error(5, "strf", "v");
            return "";
        }
        try {
            switch (v.getType()) {
                case 1: 
                case 4: {
                    return Formatter.format(format, new Integer(v.toInt(vi)));
                }
                case 3: {
                    return Formatter.format(format, new Double(v.toDouble(vi)));
                }
                case 2: {
                    return Formatter.format(format, v.toByteString(vi));
                }
            }
            return format;
        }
        catch (Exception e) {
            context.error(3, "strf", "format=" + format + ", v=" + v.toString(vi));
            return format;
        }
        catch (Throwable e) {
            context.error(21, "strf");
            return format;
        }
    }

    public static String getpath(Context context, String str, int type) {
        if (str == null) {
            context.error(5, "getpath", "str");
            return "";
        }
        File file = new File(str);
        String result = str;
        if ((type & 1) != 0) {
            result = file.getName().lastIndexOf(46) >= 0 ? str.substring(0, str.length() - (file.getName().length() - file.getName().lastIndexOf(46))) : str;
        } else if ((type & 2) != 0) {
            result = file.getName().lastIndexOf(46) >= 0 ? file.getName().substring(file.getName().lastIndexOf(46)) : "";
        }
        file = new File(result);
        if ((type & 8) != 0) {
            result = file.getName();
        } else if ((type & 0x20) != 0) {
            result = file.getParent();
        }
        if ((type & 0x10) != 0) {
            result = result.toLowerCase();
        }
        return result;
    }

    public static double sin(double a) {
        return Math.sin(a);
    }

    public static double cos(double a) {
        return Math.cos(a);
    }

    public static double tan(double a) {
        return Math.tan(a);
    }

    public static double atan(double y, Operand xv, int xvi) {
        return Math.atan2(y, FunctionBase.toDouble(xv, xvi, 1.0));
    }

    public static double sqrt(double a) {
        return Math.sqrt(a);
    }

    public static double double_(double a) {
        return a;
    }

    public static double absf(double a) {
        return Math.abs(a);
    }

    public static double expf(double a) {
        return Math.exp(a);
    }

    public static double logf(double a) {
        return Math.log(a);
    }

    public static double limitf(double val, double min, double max) {
        return Math.min(Math.max(min, val), max);
    }
}

