/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler;

import hsplet.compiler.LEInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public final class ByteCode
implements Serializable {
    private static final long serialVersionUID = 6171509589300649390L;
    private static final String fileVersionID = "$Id: ByteCode.java,v 1.2 2006/01/13 20:32:11 Yuki Exp $";
    public final Header header;
    public final Code[] codes;
    public final byte[] datas;
    public final int[] labels;
    public final int[] debugInfo;
    public final Library[] libraries;
    public final Function[] functions;
    public final Parameter[] parameters;
    private LEInputStream in;

    public ByteCode(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes));
    }

    public ByteCode(InputStream stream) throws IOException {
        this.in = new LEInputStream(stream);
        this.header = new Header(this.in);
        this.codes = this.readCodes();
        this.datas = this.readDatas();
        this.labels = this.readLabels();
        this.debugInfo = this.readDebugInfo();
        this.libraries = this.readLibraries();
        this.functions = this.readFunctions();
        this.parameters = this.readParameters();
        this.in = null;
    }

    private Code[] readCodes() throws IOException {
        this.in.seekTo(this.header.codes.offset);
        Code[] codes = new Code[this.header.codes.size / 2];
        int codeCount = 0;
        while (this.in.getOffset() < this.header.codes.offset + this.header.codes.size) {
            codes[codeCount++] = new Code(this.in);
            if (codes[codeCount - 1].type != 11) continue;
            codes[codeCount++] = new Code(19, this.in.readShort() * 2);
        }
        Code[] result = new Code[codeCount -= 2];
        System.arraycopy(codes, 0, result, 0, codeCount);
        return result;
    }

    private byte[] readDatas() throws IOException {
        this.in.seekTo(this.header.datas.offset);
        byte[] result = new byte[this.header.datas.size];
        this.in.readBytes(result);
        return result;
    }

    private int[] readLabels() throws IOException {
        this.in.seekTo(this.header.labels.offset);
        int[] result = new int[this.header.labels.size / 4];
        int index = 0;
        while (index < result.length) {
            result[index] = this.header.codes.offset + this.in.readInt() * 2;
            ++index;
        }
        return result;
    }

    private int[] readDebugInfo() throws IOException {
        this.in.seekTo(this.header.debugInfo.offset);
        int[] result = new int[this.header.debugInfo.size / 4];
        int index = 0;
        while (index < result.length) {
            result[index] = this.in.readInt();
            ++index;
        }
        return result;
    }

    private Library[] readLibraries() throws IOException {
        this.in.seekTo(this.header.libraries.offset);
        Library[] result = new Library[this.header.libraries.size / 16];
        int index = 0;
        while (index < result.length) {
            result[index] = new Library(this.in);
            ++index;
        }
        return result;
    }

    private Function[] readFunctions() throws IOException {
        this.in.seekTo(this.header.functions.offset);
        Function[] result = new Function[this.header.functions.size / 28];
        int index = 0;
        while (index < result.length) {
            result[index] = new Function(this.in);
            ++index;
        }
        return result;
    }

    private Parameter[] readParameters() throws IOException {
        this.in.seekTo(this.header.parameters.offset);
        Parameter[] result = new Parameter[this.header.parameters.size / 8];
        int index = 0;
        while (index < result.length) {
            result[index] = new Parameter(this.in);
            ++index;
        }
        return result;
    }

    public static final class Header
    implements Serializable {
        public final int magicNumber;
        public final int version;
        public final int variableCount;
        public final int totalSize;
        public final OffsetSize codes;
        public final OffsetSize datas;
        public final OffsetSize labels;
        public final OffsetSize debugInfo;
        public final OffsetSize libraries;
        public final OffsetSize functions;
        public final OffsetSize parameters;

        public Header(LEInputStream in) throws IOException {
            this.magicNumber = in.readInt();
            this.version = in.readInt();
            this.variableCount = in.readInt();
            this.totalSize = in.readInt();
            this.codes = new OffsetSize(in.readInt(), in.readInt());
            this.datas = new OffsetSize(in.readInt(), in.readInt());
            this.labels = new OffsetSize(in.readInt(), in.readInt());
            this.debugInfo = new OffsetSize(in.readInt(), in.readInt());
            this.libraries = new OffsetSize(in.readInt(), in.readInt());
            this.functions = new OffsetSize(in.readInt(), in.readInt());
            this.parameters = new OffsetSize(in.readInt(), in.readInt());
            new OffsetSize(in.readInt(), in.readInt());
            new OffsetSize(in.readInt(), in.readInt());
        }

        public static final class OffsetSize
        implements Serializable {
            public final int offset;
            public final int size;

            public OffsetSize(int offset, int size) {
                this.offset = offset;
                this.size = size;
            }
        }
    }

    public static final class Code
    implements Serializable {
        public static final int TYPE_BITS = 8191;
        public static final int NEWLINE_BIT = 8192;
        public static final int COMMA_BIT = 16384;
        public static final int LARGEDATA_BIT = 32768;
        public final int offset;
        public final int type;
        public final boolean newLine;
        public final boolean comma;
        public final int value;

        public Code(LEInputStream in) throws IOException {
            this.offset = in.getOffset();
            int bits = in.readShort();
            this.type = bits & 0x1FFF;
            this.newLine = (bits & 0x2000) != 0;
            this.comma = (bits & 0x4000) != 0;
            this.value = (bits & 0x8000) == 0 ? in.readShort() : in.readInt();
        }

        public Code(int type, int value) {
            this.type = type;
            this.value = value;
            this.offset = 0;
            this.newLine = false;
            this.comma = false;
        }

        public static final class Type {
            public static final int Mark = 0;
            public static final int Var = 1;
            public static final int String = 2;
            public static final int DNum = 3;
            public static final int INum = 4;
            public static final int Struct = 5;
            public static final int XLabel = 6;
            public static final int Label = 7;
            public static final int IntCmd = 8;
            public static final int ExtCmd = 9;
            public static final int ExtSysVar = 10;
            public static final int CmpCmd = 11;
            public static final int ModCmd = 12;
            public static final int IntFunc = 13;
            public static final int SysVar = 14;
            public static final int ProgCmd = 15;
            public static final int DllFunc = 16;
            public static final int DllCtrl = 17;
            public static final int UserDef = 18;
            public static final int JumpOffset = 19;
        }
    }

    public static final class Library
    implements Serializable {
        public static final int SIZE = 16;
        public final int flag;
        public final int nameidx;
        public final int hlib;
        public final int clsid;

        public Library(LEInputStream in) throws IOException {
            this.flag = in.readInt();
            this.nameidx = in.readInt();
            this.hlib = in.readInt();
            this.clsid = in.readInt();
        }
    }

    public static final class Function
    implements Serializable {
        public static final int SIZE = 28;
        public final short index;
        public final short subid;
        public final int prmindex;
        public final int prmmax;
        public final int nameidx;
        public final int size;
        public final int otindex;
        public final int funcflag;

        public Function(LEInputStream in) throws IOException {
            this.index = (short)in.readShort();
            this.subid = (short)in.readShort();
            this.prmindex = in.readInt();
            this.prmmax = in.readInt();
            this.nameidx = in.readInt();
            this.size = in.readInt();
            this.otindex = in.readInt();
            this.funcflag = in.readInt();
        }

        public boolean isFunction() {
            return this.index == -2;
        }
    }

    public static final class Parameter
    implements Serializable {
        public static final int SIZE = 8;
        public final short mptype;
        public final int subid;
        public final int offset;

        public Parameter(LEInputStream in) throws IOException {
            this.mptype = (short)in.readShort();
            this.subid = in.readShort();
            this.offset = in.readInt();
        }
    }
}

