/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherDefaultErrorHandler;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherErrorHandler;

public class BrowserLauncherRunner
implements Runnable {
    private String targetBrowser;
    private String url;
    private BrowserLauncherErrorHandler errorHandler;
    private BrowserLauncher launcher;

    public BrowserLauncherRunner(BrowserLauncher launcher, String url, BrowserLauncherErrorHandler errorHandler) {
        this(launcher, null, url, errorHandler);
    }

    public BrowserLauncherRunner(BrowserLauncher launcher, String browserName, String url, BrowserLauncherErrorHandler errorHandler) {
        if (launcher == null) {
            throw new IllegalArgumentException("launcher instance cannot be null.");
        }
        this.launcher = launcher;
        this.url = url;
        this.targetBrowser = browserName;
        if (errorHandler == null) {
            errorHandler = new BrowserLauncherDefaultErrorHandler();
        }
        this.errorHandler = errorHandler;
    }

    public void run() {
        try {
            if (this.targetBrowser != null) {
                this.launcher.openURLinBrowser(this.targetBrowser, this.url);
            } else {
                this.launcher.openURLinBrowser(this.url);
            }
        }
        catch (Exception ex) {
            this.launcher.getLogger().error("fatal error opening url", ex);
            this.errorHandler.handleException(ex);
        }
    }
}

