/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler;

import edu.stanford.ejalbert.BrowserLauncher;
import hsplet.compiler.Compiler;
import hsplet.compiler.GuiFrontEnd;
import hsplet.compiler.http.HttpServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public class GuiFrontEndModel
implements Serializable {
    private static final String fileVersionID = "$Id: GuiFrontEndModel.java,v 1.5 2006/05/09 11:57:31 Yuki Exp $";
    private static final long serialVersionUID = 8731834569307009875L;
    private static final String MP3_LIB_NAME = "lib/jl1.0.jar";
    private static final String STRF_LIB_NAME = "lib/hb16.jar";
    private String title = "";
    private int width = 640;
    private int height = 480;
    private List packFiles = new ArrayList();
    private boolean mp3;
    private boolean strf;
    private List extLibs = new ArrayList();
    private String htmlName = "";
    private String jarName = "";
    private String templateName = "";
    private String startClass = "";
    static HttpServer server = new HttpServer(6791);
    static Thread serverThread = new Thread(server);

    void synch(GuiFrontEnd gui, boolean save) {
        if (save) {
            this.title = gui.titleText.getText();
            try {
                this.width = Integer.parseInt(gui.widthText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.height = Integer.parseInt(gui.heightText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.jarName = gui.jarText.getText();
            this.htmlName = gui.htmlText.getText();
            this.templateName = gui.templateText.getText();
            this.startClass = gui.startClassText.getText();
            this.packFiles.clear();
            int i = 0;
            while (i < gui.packListModel.getSize()) {
                this.packFiles.add(gui.packListModel.get(i));
                ++i;
            }
            this.mp3 = gui.mp3CheckBox.isSelected();
            this.strf = gui.strfCheckBox.isSelected();
            this.extLibs.clear();
            Iterator i2 = gui.libChecks.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry libCheck = i2.next();
                if (!((JCheckBox)libCheck.getValue()).isSelected()) continue;
                this.extLibs.add(libCheck.getKey());
            }
        } else {
            gui.titleText.setText(this.title);
            gui.widthText.setText("" + this.width);
            gui.heightText.setText("" + this.height);
            gui.jarText.setText(this.jarName);
            gui.htmlText.setText(this.htmlName);
            gui.templateText.setText(this.templateName);
            gui.startClassText.setText(this.startClass);
            gui.packListModel.clear();
            i = 0;
            while (i < this.packFiles.size()) {
                gui.packListModel.add(i, this.packFiles.get(i));
                ++i;
            }
            gui.mp3CheckBox.setSelected(this.mp3);
            gui.strfCheckBox.setSelected(this.strf);
            Iterator i3 = gui.libChecks.entrySet().iterator();
            while (i3.hasNext()) {
                Map.Entry libCheck = i3.next();
                ((JCheckBox)libCheck.getValue()).setSelected(this.extLibs.contains(libCheck.getKey()));
            }
        }
    }

    public void compile(boolean run) {
        try {
            HashSet<String> packs = new HashSet<String>();
            int i = 0;
            while (i < this.packFiles.size()) {
                packs.add("" + this.packFiles.get(i));
                ++i;
            }
            HashSet<String> libs = new HashSet<String>();
            libs.addAll(this.extLibs);
            if (this.mp3) {
                libs.add(MP3_LIB_NAME);
            }
            if (this.strf) {
                libs.add(STRF_LIB_NAME);
            }
            HashSet<String> libdirs = new HashSet<String>();
            libdirs.add("ext");
            libdirs.add("lib");
            Compiler.build(this.jarName.length() == 0 ? null : new File(this.jarName), this.htmlName.length() == 0 ? null : new File(this.htmlName), this.templateName.length() == 0 ? null : new File(this.templateName), this.startClass, this.title, packs, libs, libdirs, this.width, this.height);
            if (run && this.htmlName.length() != 0) {
                System.out.println(server);
                if (!serverThread.isAlive()) {
                    serverThread = new Thread(server);
                    serverThread.start();
                }
                BrowserLauncher.openURL("http://localhost:6791" + HttpServer.mapURL(new File(this.htmlName)));
            } else {
                JOptionPane.showMessageDialog(null, "\u30b3\u30f3\u30d1\u30a4\u30eb\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002", "HSPLet", 1);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "HSPLet", 0);
        }
    }

    private static void execTest(File folder, String className, int width, int height) throws IOException {
        File java = new File(System.getProperty("java.home"), "bin/java");
        String pathSeparator = System.getProperty("path.separator");
        String[] jars = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        StringBuffer cmdline = new StringBuffer();
        cmdline.append("\"" + java + "\" -cp \".");
        int i = 0;
        while (i < jars.length) {
            cmdline.append(String.valueOf(pathSeparator) + jars[i]);
            ++i;
        }
        cmdline.append(String.valueOf(pathSeparator) + new File("./BrowserLauncher2-10rc4.jar").getAbsolutePath());
        cmdline.append("\" hsplet.Application --debug=true --width=" + width + " --height=" + height + " --startClass=" + Compiler.generateClassName(className));
        Runtime.getRuntime().exec(cmdline.toString(), null, folder);
    }

    public static GuiFrontEndModel load(String path) {
        try {
            ObjectInputStream i = new ObjectInputStream(new FileInputStream(path));
            GuiFrontEndModel result = (GuiFrontEndModel)i.readObject();
            i.close();
            return result;
        }
        catch (FileNotFoundException i) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new GuiFrontEndModel();
    }

    public void save(String path) {
        try {
            ObjectOutputStream o = new ObjectOutputStream(new FileOutputStream(path));
            o.writeObject(this);
            o.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

