/*
 * $Id: Input.java,v 1.6 2006/05/20 06:12:06 Yuki Exp $
 */
package hsplet.gui;

import hsplet.util.Conversion;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import hsplet.variable.VolatileValue;
import hsplet.variable.VolatileValueUpdater;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoManager;

/**
 * input Rg[B
 * <p>eύXꂽϐXVB
 * </p>
 * 
 * @author Yuki
 * @version $Revision: 1.6 $, $Date: 2006/05/20 06:12:06 $
 */
public class Input extends JTextField implements VolatileValueUpdater, HSPControl, DocumentListener {

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: Input.java,v 1.6 2006/05/20 06:12:06 Yuki Exp $";

	/** 񉻕ɁAf[^̌݊mF邽߂̃o[WԍB */
	private static final long serialVersionUID = -1371744407933876506L;

	/** ϐ */
	private VolatileValue v;

	/** ϐCfbNX */
	private int vi;

	/** UNDO ǗIuWFNg */
	private UndoManager undo = new UndoManager();

	/**
	 * IuWFNg\zB
	 * @param v \ϐB
	 * @param vi \ϐ̃CfbNXB
	 * @param length ő啶B
	 */
	public Input(final Variable v, final int vi, final int length) {

		setDocument(new PlainDocument() {
			public void remove(int offs, int len) throws BadLocationException {

				final String text = getText(0, offs) + getText(offs + len, getLength() - offs - len);

				if (isValidText(text)) {
					super.remove(offs, len);
				}
			}

			public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {

				final String text = getText(0, offs) + str + getText(offs, getLength() - offs);

				if (isValidText(text)) {
					super.insertString(offs, str, a);
				}
			}

			private boolean isValidText(final String text) {

				if (text.length() == 0) {
					return true;
				}

				if (length > 0 && text.length() == length) {
					return false;
				}

				try {
					switch (v.getType()) {
					case Operand.Type.INTEGER:
						if (!text.equals("-") && !text.equals("+")) {
							Integer.parseInt(text);
						}
						break;
					case Operand.Type.DOUBLE:
						if (!text.equals("-") && !text.equals("+")) {
							Double.parseDouble(text);
						}
						break;
					default:
						break;
					}
				} catch (NumberFormatException e) {
					return false;
				}

				return true;
			}

		});

		getDocument().addUndoableEditListener(new UndoableEditListener() {
			public void undoableEditHappened(UndoableEditEvent e) {
				undo.addEdit(e.getEdit());
			}
		});

		this.setText(v.toByteString(vi).toString());
		this.v = v.makeVolatile();
		this.vi = vi;

		getDocument().addDocumentListener(this);
	}

	public Component asComponent() {
		return this;
	}

	public void setValue(Operand v, int vi) {

		setText(v.toString(vi));

		this.v.updaters.add(this);
	}

	public void update(Operand value) {
		switch (value.getType()) {
		case Operand.Type.INTEGER:
			value.assign(vi, Scalar.fromValue(Conversion.strtoi(getText())), 0);
			break;
		case Operand.Type.DOUBLE:
			value.assign(vi, Scalar.fromValue(Conversion.strtod(getText())), 0);
			break;
		default:
			value.assign(vi, Scalar.fromValue(getText()), 0);
			break;

		}

	}

	public void changedUpdate(DocumentEvent e) {
		this.v.updaters.add(this);

	}

	public void insertUpdate(DocumentEvent e) {
		this.v.updaters.add(this);

	}

	public void removeUpdate(DocumentEvent e) {
		this.v.updaters.add(this);

	}

	public int sendMessage(int message, Operand wparam, Operand lparam) {

		switch (message) {
		case 0x00C6: //EM_CANUNDO
			return undo.canUndo() ? 1 : 0;
		case 0x00C7: //EM_UNDO
			undo.undoOrRedo();
			return 1;
		}

		throw new UnsupportedOperationException();
	}

}
