/*
 * Decompiled with CFR 0.152.
 */
package hsplet.gui;

import hsplet.gui.HSPControl;
import hsplet.util.Conversion;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import hsplet.variable.VolatileValue;
import hsplet.variable.VolatileValueUpdater;
import java.awt.Component;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoManager;

public class Password
extends JPasswordField
implements VolatileValueUpdater,
HSPControl,
DocumentListener {
    private static final String fileVersionID = "$Id: Input.java,v 1.6 2006/05/20 06:12:06 Yuki Exp $";
    private static final long serialVersionUID = -1371744407933876506L;
    private VolatileValue v;
    private int vi;
    private UndoManager undo = new UndoManager();

    public Password(final Variable v, int vi, final int length) {
        this.setDocument(new PlainDocument(){

            public void remove(int offs, int len) throws BadLocationException {
                String text = String.valueOf(this.getText(0, offs)) + this.getText(offs + len, this.getLength() - offs - len);
                if (this.isValidText(text)) {
                    super.remove(offs, len);
                }
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                String text = String.valueOf(this.getText(0, offs)) + str + this.getText(offs, this.getLength() - offs);
                if (this.isValidText(text)) {
                    super.insertString(offs, str, a);
                }
            }

            private boolean isValidText(String text) {
                if (text.length() == 0) {
                    return true;
                }
                if (length > 0 && text.length() == length) {
                    return false;
                }
                try {
                    switch (v.getType()) {
                        case 4: {
                            if (!text.equals("-") && !text.equals("+")) {
                                Integer.parseInt(text);
                            }
                            break;
                        }
                        case 3: {
                            if (!text.equals("-") && !text.equals("+")) {
                                Double.parseDouble(text);
                            }
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }
        });
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent e) {
                Password.this.undo.addEdit(e.getEdit());
            }
        });
        ((JTextComponent)this).setText(v.toByteString(vi).toString());
        this.v = v.makeVolatile();
        this.vi = vi;
        this.getDocument().addDocumentListener(this);
    }

    public Component asComponent() {
        return this;
    }

    public void setValue(Operand v, int vi) {
        ((JTextComponent)this).setText(v.toString(vi));
        this.v.updaters.add(this);
    }

    public void update(Operand value) {
        switch (value.getType()) {
            case 4: {
                value.assign(this.vi, Scalar.fromValue(Conversion.strtoi(this.getText())), 0);
                break;
            }
            case 3: {
                value.assign(this.vi, Scalar.fromValue(Conversion.strtod(this.getText())), 0);
                break;
            }
            default: {
                value.assign(this.vi, Scalar.fromValue(this.getText()), 0);
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.v.updaters.add(this);
    }

    public void insertUpdate(DocumentEvent e) {
        this.v.updaters.add(this);
    }

    public void removeUpdate(DocumentEvent e) {
        this.v.updaters.add(this);
    }

    public int sendMessage(int message, Operand wparam, Operand lparam) {
        switch (message) {
            case 198: {
                return this.undo.canUndo() ? 1 : 0;
            }
            case 199: {
                this.undo.undoOrRedo();
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }
}

