/*
 * $Id: Scalar.java,v 1.3 2006/02/11 18:00:37 Yuki Exp $
 */
package hsplet.variable;

/**
 * P̗vfIyh킷{NXB
 * <p>
 * Array ̗vf̂ɑ΂āÃNX͈vfB
 * </p>
 * <p>
 * 萔≉ŽʁA֐̖߂lȂǁA͂߂vfȂƂ킩ĂƂ́Az肱gpقɎsłB
 * </p>
 * 
 * @author Yuki
 * @version $Revision: 1.3 $, $Date: 2006/02/11 18:00:37 $
 */
public abstract class Scalar extends Operand {

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: Scalar.java,v 1.3 2006/02/11 18:00:37 Yuki Exp $";

	private static final Scalar[] intCache = new Scalar[256];

	static {

		for (int i = 0; i < intCache.length; ++i) {
			intCache[i] = new IntScalar(i - 128);
		}
	}

	/**
	 * ̒l킷IuWFNg擾B
	 * <p>
	 * ̃\bhԂꂽIuWFNg̒l͕ύXĂ͂ȂȂB
	 * </p>
	 * 
	 * @param rawValue ̒lB
	 * @return w肳ꂽl\XJ[IuWFNgB
	 */
	public static Scalar fromValue(final String rawValue) {

		return new StringScalar(rawValue);
	}

	/**
	 * ̒l킷IuWFNg擾B
	 * <p>
	 * ̃\bhԂꂽIuWFNg̒l͕ύXĂ͂ȂȂB
	 * </p>
	 * 
	 * @param rawValue ̒lB
	 * @return w肳ꂽl\XJ[IuWFNgB
	 */
	public static Scalar fromValue(final ByteString rawValue) {

		return new StringScalar(rawValue);
	}

	/**
	 * ̒l킷IuWFNg擾B
	 * <p>
	 * ̃\bhԂꂽIuWFNg̒l͕ύXĂ͂ȂȂB
	 * </p>
	 * 
	 * @param rawValue ̒lB
	 * @return w肳ꂽl\XJ[IuWFNgB
	 */
	public static Scalar fromValue(final double rawValue) {

		return new DoubleScalar(rawValue);
	}

	/**
	 * ̒l킷IuWFNg擾B
	 * <p>
	 * ̃\bhԂꂽIuWFNg̒l͕ύXĂ͂ȂȂB
	 * </p>
	 * 
	 * @param rawValue ̒lB
	 * @return w肳ꂽl\XJ[IuWFNgB
	 */
	public static Scalar fromValue(final int rawValue) {

		if (rawValue >= -128 && rawValue <= 127) {
			return intCache[rawValue + 128];
		} else {
			return new IntScalar(rawValue);
		}
	}

	/**
	 * ̒l킷IuWFNg擾B
	 * <p>
	 * ̃\bhԂꂽIuWFNg̒l͕ύXĂ͂ȂȂB
	 * </p>
	 * 
	 * @param rawValue ̒lB
	 * @return w肳ꂽl\XJ[IuWFNgB
	 */
	public static Scalar fromLabel(final int rawValue) {

		return new Label(rawValue);
	}

	//@Override
	public int getIndex(final int i0, final int i1) {

		return 0;
	}

	//@Override
	public int getIndex(final int i0, final int i1, final int i2) {

		return 0;
	}

	//@Override
	public int getIndex(final int i0, final int i1, final int i2, final int i3) {

		return 0;
	}

	//@Override
	public int l0() {

		return 1;
	}

	//@Override
	public int l1() {

		return 1;
	}

	//@Override
	public int l2() {

		return 1;
	}

	//@Override
	public int l3() {

		return 1;
	}
}
