/*
 * $Id: Applet.java,v 1.9 2006/05/09 11:57:31 Yuki Exp $
 */
package hsplet;

import hsplet.gui.Bmscr;
import hsplet.gui.ContentPane;
import hsplet.gui.HSPScreen;
import hsplet.variable.Operand;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.JApplet;
import javax.swing.UIManager;

/**
 * HSPLet ̃CAvbgNXB
 * 
 * @author Yuki
 * @version $Revision: 1.9 $, $Date: 2006/05/09 11:57:31 $
 */
public final class Applet extends JApplet implements HSPScreen {

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: Applet.java,v 1.9 2006/05/09 11:57:31 Yuki Exp $";

	/** 񉻕ɁAf[^̌݊mF邽߂̃o[WԍB */
	private static final long serialVersionUID = -1458193602845132311L;

	/** JnNXnp[^B */
	public static final String START_CLASSNAME_PARAM = "startClass";

	/** ftHg̊JnNXB*/
	public static final String DEFAULT_START_CLASSNAME = "start";

	private final Context context = new Context();

	/**
	 * IuWFNg\zB
	 */
	public Applet() {

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}

		setContentPane(new ContentPane(this));
		this.info = new Bmscr(this, (ContentPane) getContentPane());

		getContentPane().addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent e) {
				if (getJMenuBar() != null) {

					setSize(getContentPane().getWidth(), getJMenuBar().getHeight() + getContentPane().getHeight());
				} else {
					setSize(getContentPane().getSize());
				}
			}
		});
	}

	//@Override
	public void init() {

		try {
			init(Class.forName(getParameter(START_CLASSNAME_PARAM) == null ? DEFAULT_START_CLASSNAME
					: getParameter(START_CLASSNAME_PARAM)));

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * NXw肵ăAvbgJnB
	 * @param codeClass sR[h̃NXB
	 */
	public void init(final Class codeClass) {

		context.init(this, codeClass);

		info.init(getBackground(), getSize());

	}

	//@SuppressWarnings("unchecked")
	//@Override
	public void start() {

		// N͂܂tH[JX𓾂B
		new Timer().schedule(new TimerTask() {

			//@Override
			public void run() {
				requestFocus();

			}
		}, 100);

		context.start();
	}

	//@Override
	public void stop() {
		context.stop();

		System.gc();
	}

	//@Override
	public void destroy() {
		context.stop();

		System.gc();
	}

	private Bmscr info;

	public Bmscr getBmscr() {

		return info;
	}

	//@Override
	public void update(Graphics g) {

		paint(g);
	}

	public Component asComponent() {

		return this;
	}

	public void setTitle(final String text) {

		showStatus(text);
	}

	public Dimension getPreferredSize() {
		return info.contents.getPreferredSize();
	}

	public int sendMessage(int message, Operand wparam, Operand lparam) {

		throw new UnsupportedOperationException();
	}
}
