/*
 * Decompiled with CFR 0.152.
 */
package hsplet.variable;

import hsplet.util.Conversion;
import hsplet.variable.ByteString;
import hsplet.variable.IntScalar;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;

public final class StringScalar
extends Scalar {
    private static final long serialVersionUID = 4664482061973809570L;
    private static final String fileVersionID = "$Id: StringScalar.java,v 1.4 2006/02/27 15:48:01 Yuki Exp $";
    public ByteString value;

    public StringScalar(String value) {
        this(new ByteString(value));
    }

    public StringScalar(ByteString value) {
        this.value = value;
    }

    public int getType() {
        return 2;
    }

    public String toString(int index) {
        return this.value.toString();
    }

    public ByteString toByteString(int index) {
        return this.value;
    }

    public int toInt(int index) {
        return Conversion.strtoi(this.value.toString());
    }

    public double toDouble(int index) {
        return Conversion.strtod(this.value.toString());
    }

    public void inc(int index) {
    }

    public void dec(int index) {
    }

    public void assign(int index, Operand rhs, int rhi) {
        this.value.assign(rhs.toByteString(rhi));
    }

    public void assignAdd(int index, Operand rhs, int rhi) {
        this.value.append(rhs.toByteString(rhi));
    }

    public void assignSub(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("-=");
    }

    public void assignMul(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("*=");
    }

    public void assignDiv(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("/=");
    }

    public void assignMod(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("%=");
    }

    public void assignAnd(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("&=");
    }

    public void assignOr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("|=");
    }

    public void assignXor(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("^=");
    }

    public void assignSr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator(">>=");
    }

    public void assignSl(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("<<=");
    }

    public Operand add(int index, Operand rhs, int rhi) {
        return new StringScalar(ByteString.concat(this.value, rhs.toByteString(rhi)));
    }

    public Operand eq(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value.equals(rhs.toByteString(rhi)) ? 1 : 0);
    }

    public Operand ne(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value.compareTo(rhs.toByteString(rhi)));
    }

    public Operand gt(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value.compareTo(rhs.toByteString(rhi)) > 0 ? 1 : 0);
    }

    public Operand lt(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value.compareTo(rhs.toByteString(rhi)) < 0 ? 1 : 0);
    }

    public Operand ge(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value.compareTo(rhs.toByteString(rhi)) >= 0 ? 1 : 0);
    }

    public Operand le(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value.compareTo(rhs.toByteString(rhi)) <= 0 ? 1 : 0);
    }

    public Operand sub(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("-");
    }

    public Operand mul(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("*");
    }

    public Operand div(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("/");
    }

    public Operand mod(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("%");
    }

    public Operand and(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("&");
    }

    public Operand or(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("|");
    }

    public Operand xor(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("^");
    }

    public Operand sl(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("<<");
    }

    public Operand sr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator(">>");
    }

    public byte peek(int index, int offset) {
        return this.value.get(offset);
    }

    public void poke(int index, int offset, byte value) {
        this.value.set(offset, value);
    }
}

