/*
 * Decompiled with CFR 0.152.
 */
import hsplet.Context;
import hsplet.function.FunctionBase;
import hsplet.variable.Operand;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public abstract class hspsockBase
extends FunctionBase
implements Serializable {
    private static final String fileVersionID = "$Id: hspsockBase.java,v 1.4 2006/05/20 06:12:07 Yuki Exp $";
    protected BufferedSocket[] sockets = new BufferedSocket[32];
    protected final Context context;

    public hspsockBase(Context context) {
        this.context = context;
    }

    public void ipget() {
        try {
            this.context.refstr.value.assign(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            this.context.refstr.value.assign("");
        }
    }

    public void sockbye() {
        int i = 0;
        while (i < this.sockets.length) {
            if (this.sockets[i] != null) {
                try {
                    this.sockets[i].close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.sockets[i] = null;
            }
            ++i;
        }
    }

    public int sockclose(int id) {
        if (id < 0 || id >= this.sockets.length || this.sockets[id] == null) {
            this.context.error(3, "sockclose", "id==" + id);
            return 1;
        }
        BufferedSocket socket = this.sockets[id];
        try {
            socket.close();
            this.sockets[id] = null;
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int sockput(Operand buf, int bufi, int id) {
        if (id < 0 || id >= this.sockets.length || this.sockets[id] == null) {
            this.context.error(3, "sockput", "id==" + id);
            return 1;
        }
        int length = buf.toByteString(bufi).length();
        return this.sockputb(buf, bufi, 0, length, id) == length ? 0 : 1;
    }

    public int sockputc(Operand buf, int bufi, int id) {
        if (id < 0 || id >= this.sockets.length || this.sockets[id] == null) {
            this.context.error(3, "sockputc", "id==" + id);
            return 1;
        }
        return this.sockputb(buf, bufi, 0, 1, id) == 1 ? 0 : 1;
    }

    public int sockputb(Operand buf, int bufi, int offset2, int length, int id) {
        if (id < 0 || id >= this.sockets.length || this.sockets[id] == null) {
            this.context.error(3, "sockputb", "id==" + id);
            return 0;
        }
        BufferedSocket socket = this.sockets[id];
        try {
            byte[] data = new byte[length];
            int i = 0;
            while (i < length) {
                data[i] = buf.peek(bufi, offset2 + i);
                ++i;
            }
            int writeLength = 0;
            while (writeLength < length) {
                int result = socket.write(ByteBuffer.wrap(data, writeLength, length - writeLength));
                if (result < 0) break;
                writeLength += result;
            }
            return writeLength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int sockgetc(Operand buf, int bufi, int id) {
        if (id < 0 || id >= this.sockets.length || this.sockets[id] == null) {
            this.context.error(3, "sockgetc", "id==" + id);
            return 1;
        }
        return this.sockgetb(buf, bufi, 0, 1, id) == 1 ? 0 : 1;
    }

    public int sockget(Operand buf, int bufi, int length, int id) {
        if (id < 0 || id >= this.sockets.length || this.sockets[id] == null) {
            this.context.error(3, "sockget", "id==" + id);
            return 0;
        }
        int result = this.sockgetb(buf, bufi, 0, length == 0 ? 63 : length - 1, id);
        buf.poke(bufi, result, (byte)0);
        return result == 0 && length != -1 && !this.sockets[id].isClosed() ? 1 : 0;
    }

    public int sockgetb(Operand buf, int bufi, int offset, int length, int id) {
        if (id < 0 || id >= this.sockets.length || this.sockets[id] == null) {
            this.context.error(3, "sockgetb", "id==" + id);
            return 0;
        }
        BufferedSocket socket = this.sockets[id];
        try {
            byte[] data = new byte[length];
            int readLength = 0;
            while (readLength < length) {
                int result = socket.read(ByteBuffer.wrap(data, readLength, length - readLength));
                if (result < 0) break;
                readLength += result;
            }
            int i = 0;
            while (i < length) {
                buf.poke(bufi, offset + i, data[i]);
                ++i;
            }
            return readLength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int sockcheck(int id) {
        if (id < 0 || id >= this.sockets.length || this.sockets[id] == null) {
            this.context.error(3, "sockcheck", "id==" + id);
            return 3;
        }
        BufferedSocket socket = this.sockets[id];
        try {
            if (!socket.isConnected()) {
                return 3;
            }
            if (socket.avail() > 0) {
                return 0;
            }
            if (socket.avail() == 0) {
                return 1;
            }
            return 2;
        }
        catch (IOException e) {
            return 3;
        }
    }

    protected static class BufferedSocket {
        private final SocketChannel socket;
        private byte[] readBuffer = new byte[65536];
        private int readOffset = 0;
        private int readLength = 0;

        public BufferedSocket(SocketChannel socket) {
            this.socket = socket;
        }

        public void finishConnect() throws IOException {
            this.socket.finishConnect();
        }

        public boolean isConnectionPending() {
            return this.socket.isConnectionPending();
        }

        public boolean isConnected() {
            return this.socket.isConnected();
        }

        public Socket socket() {
            return this.socket.socket();
        }

        public void close() throws IOException {
            this.socket.close();
        }

        public int read(ByteBuffer buffer) throws IOException {
            this.readBuffer();
            if (this.readLength < 0) {
                return -1;
            }
            int i = 0;
            while (i < buffer.capacity()) {
                if (this.readOffset + i >= this.readLength) break;
                buffer.put(i, this.readBuffer[this.readOffset + i]);
                ++i;
            }
            this.readOffset += i;
            if (this.readOffset == this.readLength) {
                this.readOffset = 0;
                this.readLength = 0;
            } else if (this.readOffset >= this.readBuffer.length / 2) {
                System.arraycopy(this.readBuffer, this.readOffset, this.readBuffer, 0, this.readLength - this.readOffset);
                this.readLength -= this.readOffset;
                this.readOffset = 0;
            }
            return i;
        }

        private void readBuffer() throws IOException {
            if (this.readLength >= 0 && this.readLength < this.readBuffer.length) {
                int l = this.socket.read(ByteBuffer.wrap(this.readBuffer, this.readLength, this.readBuffer.length - this.readLength));
                if (l < 0) {
                    if (this.readLength == 0) {
                        this.readLength = -1;
                    }
                } else {
                    this.readLength += l;
                }
            }
        }

        public int avail() throws IOException {
            this.readBuffer();
            return this.readLength - this.readOffset;
        }

        public int write(ByteBuffer buffer) throws IOException {
            return this.socket.write(buffer);
        }

        public boolean isClosed() {
            return this.readLength < 0;
        }
    }
}

