//---------------------------------------------------------------------------
#ifndef __geometry_h
#define __geometry_h

#define PI 3.14159265358979f
#define PI2 6.28318530717958f
#define HPI 1.570796326794895f

#define DEG2ANG(x) ((int)((x) * 32768.0f / 180.0f) & 0xffff)
#define RAD2ANG(x) ((int)((x) * 32768.0f / PI) & 0xffff)
#define DEG2RAD(x) ((x) * PI / 180.0f)
#define RAD2DEG(x) ((x) * 180.0f / PI)

typedef struct {
	float x, y, z, w;
} VECTOR;

typedef struct {
  float m00, m01, m02, m03;
  float m10, m11, m12, m13;
  float m20, m21, m22, m23;
  float m30, m31, m32, m33;
} MATRIX;

typedef float FVECTOR[4];
typedef float * FVRef;
typedef int * IVRef;
typedef float (*FMatRef)[4];

#define VECREF (VECTOR *)(FVRef)

// VECTOR^
typedef struct {
int x,y,z,w;
} IVECTOR;

/*
// VECTOR^
typedef struct {
float x,y,z,w;
} FVECTOR;
*/

// AXIS^
typedef struct {
int x,y;
} IAXIS;

// AXIS^
typedef struct {
float x,y;
} FAXIS;

// AXIS2^(UVt)
typedef struct {
short x,y,tx,ty;
} IAXIS2;

#define setIAXIS( a,b,c ) a.x=(int)b;a.y=(int)c;
#define setIAXIS2( a,b,c,d,e ) a.x=(int)b;a.y=(int)c;a.tx=(int)d;a.ty=(int)e;

typedef struct {
	VECTOR a;			// ϊšW(x, y, z0, z1)
	VECTOR b;			// ϊs̉Zl (0, 0, z2, z3)
	VECTOR ra;			// W̋t(1/K)
	VECTOR rb;			// Zl̕␔ (-K)
	VECTOR v;			// yobt@ƃtHÕp[^
	VECTOR t;			// ItZbgwxWƂyobt@ƃtHÕp[^
	VECTOR cmin;		// Nbvŏ͈́{eNX`␳W
	VECTOR cmax;		// Nbvő͈
} ViewScreen;


//---------------------------------------------------------------------------

void GeometryInit(void);
void GeometryTerm(void);

//void CopyVector( VECTOR *dst, VECTOR *src );
#define CopyVector( dst,src ) *(dst) = *(src)

//void SetVector( VECTOR *dst, float x, float y, float z, float w );
#define SetVector(dst,xarg,yarg,zarg,warg)	(dst)->x=xarg;(dst)->y=yarg;(dst)->z=zarg;(dst)->w=warg
#define SetVector3(dst,xarg,yarg,zarg)	(dst)->x=xarg;(dst)->y=yarg;(dst)->z=zarg


void AddVector( VECTOR *dst, VECTOR *v0, VECTOR *v1 );
void SubVector( VECTOR *dst, VECTOR *v0, VECTOR *v1 );
void MulVector( VECTOR *dst, VECTOR *v0, VECTOR *v1 );
void DivVector( VECTOR *dst, VECTOR *v0, float r );
void ScaleVector( VECTOR *dst, VECTOR *v0, float r );

//  }gbNX
void  InitMatrix(void);
//  nɂ
void  LeftHand(void);
//  Enɂ(default)
void  RightHand(void);
//  }gbNX̃Rs[
void  CopyMatrix( MATRIX *src, MATRIX *dst );
//  }gbNXޔ
void  PushMatrix(void);
//  }gbNXA
void  PopMatrix(void);
//  Jg}gbNX擾
void  GetCurrentMatrix(MATRIX *dst);
MATRIX *GetCurrentMatrixPtr( void );
//  Jg}gbNXݒ
void  SetCurrentMatrix(MATRIX *dst);
//  Jg}gbNX̃gX𓾂
void  GetCurrentTrans(VECTOR *v);
//  Pʃ}gbNX
void  UnitMatrix(void);
//  w]
void  RotX(float x);
//  x]
void  RotY(float y);
//  y]
void  RotZ(float z);
//  sړ
void  Trans(float x, float y, float z);
//  XP[
void  Scale(float x, float y, float z);
//  e
void  Perspective(float r);
//  eyyobt@l
void  PerspectiveWithZBuffer(float r, float N, float F, float Zn, float Zf);
//  }gbNXm̐ρiJg}gbNXɍ|j
void  MulMatrix(MATRIX *left);
//  }gbNXm̐ρiJg}gbNXɉE|j
void  MulMatrixR(MATRIX *right);
//  ]us
void  Transpose(MATRIX *mat);
//  }gbNX̍s
float  Determinant(MATRIX *mat);
//  3x3s񎮂̒litspj
float  Determinant3(MATRIX *src);
//  ts
int  InverseMatrix(MATRIX *mat);
//  xNg}gbNX -> xNg
void  ApplyMatrix(VECTOR *v0, VECTOR *v1);
void  ApplyMatrixN(VECTOR *v0, VECTOR *v1, int nb);
//  xNg}gbNX -> xNgi]̂݁j
void  ApplyMatrixRot(VECTOR *v0, VECTOR *v1);
//  xNg}gbNX -> xNgisړ̂݁j
void  ApplyMatrixTrans(VECTOR *v0, VECTOR *v1);
//  QxNg̊O
void  OuterProduct(VECTOR *v1, VECTOR *v2, VECTOR *dst);
//  QxNg̓
float  InnerProduct(VECTOR *v1, VECTOR *v2);
//  PʃxNg
void  UnitVector(VECTOR *v);
//  J}gbNX
void  LookAt(VECTOR *cam_pos, VECTOR *cam_int);
void  LookAtWithRoll(VECTOR *cam_pos, VECTOR *cam_int, float roll);
void GetTargetAngle( VECTOR *ang, VECTOR *src, VECTOR *target );

//	View->Screen}gNX
void PerspectiveViewScreen( ViewScreen * vs, float scrz, float ax, float ay, 
	       float xcenter, float ycenter, float zbufsmall, float zbufbig, float D, float F, float fognearz, float fogfarz, float W, float H);

//	|SڐG
int HasPoint2D( float x, float y, VECTOR *v );
int HasPoint3D( VECTOR *p, VECTOR *v );
int IntersectLinePlane( VECTOR *lpoint, VECTOR *lvector, VECTOR *ppoint, VECTOR *pnormal, VECTOR *result );
float GetVectorDistance( VECTOR *v1, VECTOR *v2 );


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#endif
