#import "HspView.h"
#import "iOSBridge.h"
#include "../hsp3/hsp3config.h"
#include "../hsp3/hgio.h"
#include "../hsp3embed/hsp3embed.h"
#include "../hsp3/sysreq.h"

void gb_setogl( EAGLContext *context, GLuint viewRenderBuff, GLuint viewFrameBuff );

//HspViewの実装
@implementation HspView

//フレームの初期化
- (id)initWithFrame:(CGRect)frame {
    if (self=[super initWithFrame:frame]) {
        InitSysReq();
        //グラフィックスの生成
        int sx,sy;
        sx = frame.size.width;
        sy = frame.size.height;
        NSLog(@"Init HspView(%d,%d)",sx,sy);
        hgio_init( 0, sx, sy, NULL );
    }
    act_mode = 0;
    return self;
}

//メモリ解放
- (void)dealloc {
	hsp3eb_bye();
	hgio_term();
    [super dealloc];
}

//セットアップ
- (void)setup {
    //グラフィックスのセットアップ
    gb_sethspview( self );
    gb_setogl( _context, _viewRenderBuff, _viewFrameBuff );
    gb_reset( self.bgWidth, self.bgHeight );
	hsp3eb_init();
    act_mode = 1;
}

//定期処理
- (void)onTick {

    if ( act_mode == ACTMODE_NORMAL ) {
        //hsp3eb_exec();
        hsp3eb_exectime( hgio_gettick() );
        //	gb_dbgtest();
    }
}


- (void)clsMode:(int)mode color:(int)color
{
    hgio_clsmode( mode, color, 0 );
    cls_mode = mode;
    cls_color = color;
}


- (void)actMode:(int)amode
{
    if ( act_mode & ACTMODE_LOCK ) {
        if ( amode & ACTMODE_LOCK ) {
            act_mode = amode & ACTMODE_NORMAL;
        }
    } else {
        act_mode = amode;
    }
}


- (void)dispMode:(int)dmode
{
    disp_mode = dmode;
}


- (void)dispDialog:(int)type Msg:(char *)msg MsgSub:(char *)msg_sub
{
	NSString *msg1 = [[NSString alloc] initWithUTF8String:msg];
	NSString *msg2 = nil;
    UIAlertView *view_alert;
    if ( *msg_sub != 0 ) {
        msg2 = [[NSString alloc] initWithUTF8String:msg_sub];
    }
    
    dialog_type = type;
    if ( type&2 ) {
        view_alert = [[UIAlertView alloc] initWithTitle:msg2
                                                message:msg1
                                               delegate:self
                                      cancelButtonTitle:@"いいえ"
                                      otherButtonTitles:@"はい",nil
                      ];
    } else {
        view_alert = [[UIAlertView alloc] initWithTitle:msg2
                                                message:msg1
                                               delegate:self
                                      cancelButtonTitle:@"OK"
                                      otherButtonTitles:nil
                      ];
    }

    [self actMode:ACTMODE_LOCK|ACTMODE_STOP];
    
    [view_alert show];
    [view_alert release];
    [msg1 release];
}


- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex {
    if ( dialog_type & 2 ) {
        if ( buttonIndex == 0 )  hsp3eb_setstat(7);
        if ( buttonIndex == 1 )  hsp3eb_setstat(6);
    } else {
        hsp3eb_setstat(0);
    }
    [self actMode:ACTMODE_LOCK|ACTMODE_NORMAL];
}


- (void) touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
	UITouch *touch = [touches anyObject];
	CGPoint location = [touch locationInView:self];
	NSInteger taps = [touch tapCount];
	
	[super touchesBegan:touches withEvent:event];

	hgio_touch( location.x, location.y, 1 );
	//NSLog(@"タップ開始 %f, %f  タップ数：%d", location.x, location.y, taps);
}


- (void) touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {
	UITouch *touch = [touches anyObject];
	CGPoint oldLocation = [touch previousLocationInView:self];
	CGPoint newLocation = [touch locationInView:self];
	
	[super touchesMoved:touches withEvent:event];
	
	hgio_touch( newLocation.x, newLocation.y, 1 );
	//NSLog(@"指の動き：%f , %f から %f, %f", oldLocation.x, oldLocation.y, newLocation.x, newLocation.y);	
}


- (void) touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {	
	UITouch *touch = [touches anyObject];
	CGPoint location = [touch locationInView:self];
	
	[super touchesEnded:touches withEvent:event];
	
	hgio_touch( location.x, location.y, 0 );
	//NSLog(@"タップ終了 %f, %f", location.x, location.y);	
}

@end
