/*
 * Decompiled with CFR 0.152.
 */
package hsplet.gui;

import hsplet.Context;
import hsplet.JumpTask;
import hsplet.gui.Bmscr;
import hsplet.gui.HSPControl;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class EventListener
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener,
Serializable {
    private static final String fileVersionID = "$Id: EventListener.java,v 1.8 2006/05/20 06:12:06 Yuki Exp $";
    private static final long serialVersionUID = -7715847659889033067L;
    private final Context context;
    private static final int[] vkJtoW = new int[1024];
    private static final int[] vkJtoC = new int[1024];

    static {
        int i = 0;
        while (i < vkJtoW.length) {
            EventListener.vkJtoW[i] = i;
            ++i;
        }
        EventListener.vkJtoW[155] = 45;
        EventListener.vkJtoW[127] = 46;
        EventListener.vkJtoW[45] = 189;
        EventListener.vkJtoW[514] = 222;
        EventListener.vkJtoW[92] = 220;
        EventListener.vkJtoW[512] = 192;
        EventListener.vkJtoW[91] = 219;
        EventListener.vkJtoW[59] = 187;
        EventListener.vkJtoW[513] = 186;
        EventListener.vkJtoW[93] = 221;
        EventListener.vkJtoW[44] = 188;
        EventListener.vkJtoW[46] = 190;
        EventListener.vkJtoW[47] = 191;
        EventListener.vkJtoW[524] = 91;
        EventListener.vkJtoW[525] = 93;
        EventListener.vkJtoW[10] = 13;
        i = 48;
        while (i <= 57) {
            EventListener.vkJtoC[i] = i;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            EventListener.vkJtoC[i] = i;
            ++i;
        }
        EventListener.vkJtoC[45] = 45;
        EventListener.vkJtoC[514] = 94;
        EventListener.vkJtoC[92] = 92;
        EventListener.vkJtoC[512] = 64;
        EventListener.vkJtoC[91] = 91;
        EventListener.vkJtoC[59] = 59;
        EventListener.vkJtoC[513] = 58;
        EventListener.vkJtoC[93] = 93;
        EventListener.vkJtoC[44] = 44;
        EventListener.vkJtoC[46] = 46;
        EventListener.vkJtoC[47] = 47;
        EventListener.vkJtoC[10] = 13;
    }

    public EventListener(Context context) {
        this.context = context;
    }

    public void listen(Bmscr info) {
        Component component = info.component;
        if (component != null) {
            component.addKeyListener(this);
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            component.addFocusListener(this);
        }
    }

    public void listen(HSPControl control) {
        Component component = control.asComponent();
        if (component != null) {
            component.addKeyListener(this);
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }
    }

    private static int getStickCode(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                return 1;
            }
            case 38: {
                return 2;
            }
            case 39: {
                return 4;
            }
            case 40: {
                return 8;
            }
            case 32: {
                return 16;
            }
            case 10: {
                return 32;
            }
            case 17: {
                return 64;
            }
            case 27: {
                return 128;
            }
            case 9: {
                return 1024;
            }
        }
        return -1;
    }

    private static int getStickCode(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            return 256;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return 512;
        }
        return -1;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int stickCode = EventListener.getStickCode(e);
        if (stickCode >= 0 && (this.context.stickState & stickCode) == 0) {
            if (this.context.stickTriggerTime < System.currentTimeMillis() - 500L) {
                this.context.stickTrigger = 0;
            }
            this.context.stickTrigger |= stickCode;
            this.context.stickState |= stickCode;
            this.context.stickTriggerTime = System.currentTimeMillis();
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.context.keyPressed[1] = true;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.context.keyPressed[2] = true;
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            this.context.keyPressed[4] = true;
        }
        if (this.context.onclick.enabled && this.context.onclick.jump != null) {
            this.context.tasks.add(new JumpTask(this.context.onclick.jump, this.context.onclick.label, new Integer(SwingUtilities.isLeftMouseButton(e) ? 0 : (SwingUtilities.isRightMouseButton(e) ? 3 : 6)), new Integer(((((InputEvent)e).getModifiersEx() & 0x80) != 0 ? 8 : 0) | ((((InputEvent)e).getModifiersEx() & 0x40) != 0 ? 4 : 0) | (SwingUtilities.isLeftMouseButton(e) ? 1 : 0) | (SwingUtilities.isRightMouseButton(e) ? 2 : 0) | (SwingUtilities.isMiddleMouseButton(e) ? 16 : 0)), new Integer(e.getX() | e.getY() << 16)));
        }
    }

    public void mouseReleased(MouseEvent e) {
        int stickCode = EventListener.getStickCode(e);
        if (stickCode >= 0) {
            this.context.stickState &= ~stickCode;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.context.keyPressed[1] = false;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.context.keyPressed[2] = false;
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            this.context.keyPressed[4] = false;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        try {
            this.context.mouseX = e.getComponent().getLocationOnScreen().x + e.getX();
            this.context.mouseY = e.getComponent().getLocationOnScreen().y + e.getY();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void mouseMoved(MouseEvent e) {
        try {
            this.context.mouseX = e.getComponent().getLocationOnScreen().x + e.getX();
            this.context.mouseY = e.getComponent().getLocationOnScreen().y + e.getY();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        this.context.keyPressed[EventListener.vkJtoW[e.getKeyCode()]] = true;
        int stickCode = EventListener.getStickCode(e);
        if (stickCode >= 0 && (this.context.stickState & stickCode) == 0) {
            if (this.context.stickTriggerTime < System.currentTimeMillis() - 500L) {
                this.context.stickTrigger = 0;
            }
            this.context.stickTrigger |= stickCode;
            this.context.stickState |= stickCode;
            this.context.stickTriggerTime = System.currentTimeMillis();
        }
        if (this.context.onkey.enabled && this.context.onkey.jump != null) {
            this.context.tasks.add(new JumpTask(this.context.onkey.jump, this.context.onkey.label, new Integer(vkJtoC[e.getKeyCode()]), new Integer(vkJtoW[e.getKeyCode()]), new Integer(0)));
        }
    }

    public void keyReleased(KeyEvent e) {
        this.context.keyPressed[EventListener.vkJtoW[e.getKeyCode()]] = false;
        int stickCode = EventListener.getStickCode(e);
        if (stickCode >= 0) {
            this.context.stickState &= ~stickCode;
        }
    }

    public void focusGained(FocusEvent e) {
        this.context.activeWindow = -1;
        int i = 0;
        while (i < this.context.windows.size()) {
            Bmscr info = (Bmscr)this.context.windows.get(i);
            if (info != null && info.component == e.getComponent()) {
                this.context.activeWindow = i;
            }
            ++i;
        }
    }

    public void focusLost(FocusEvent e) {
        this.context.activeWindow = -1;
    }
}

