//
//		Draw lib (ios)
//			onion software/onitama 2001/6
//			               onitama 2011/5
//

//#include <stdio.h>
//#include <math.h>

#import "HspView.h"
#import "misc.h"
#import "Graphics.h"

#include "../hsp3/supio.h"
#include "../hsp3/sysreq.h"

#include "../hsp3/hsp3config.h"
#include "../hsp3/hgio.h"

#define CIRCLE_DIV 16
#define DEFAULT_FONT_NAME ""
#define DEFAULT_FONT_SIZE 14
#define DEFAULT_FONT_STYLE 0

static int		nDestWidth,nDestHeight;
static int		drawflag;
static BMSCR    *mainbm = NULL;

/*------------------------------------------------------------*/
/*
		iOS Base System
*/
/*------------------------------------------------------------*/

#define IMGARRAY_MAX 32

static Graphics* _g;     
static Image*    _image[IMGARRAY_MAX];
static int mouse_x, mouse_y, mouse_btn;

static EAGLContext* _context;        //コンテキスト
static GLuint       _viewRenderBuff; //レンダーバッファ
static GLuint       _viewFrameBuff;  //フレームバッファ

void gb_init( void )
{
	//グラフィックスの生成
	_g=[[Graphics alloc] init];
	
	//イメージの初期化
	for(int i=0;i<IMGARRAY_MAX;i++) {
		_image[i]=nil;
	}
}

void gb_setogl( EAGLContext *context, GLuint viewRenderBuff, GLuint viewFrameBuff )
{
    _context = context;
    _viewRenderBuff = viewRenderBuff;
    _viewFrameBuff = viewFrameBuff;
}


void gb_delimage( int i )
{
	if ( _image[i]!=nil ) {
		[_image[i] release];
		_image[i]=nil;
	}
}


void gb_bye( void )
{
	for(int i=0;i<IMGARRAY_MAX;i++) {
		gb_delimage( i );
	}
	[_g release];
}


void gb_reset( int sx, int sy )
{
    [_g initSize:CGSizeMake(sx,sy)];
    [_g setLineWidth:1];
    [_g setFontSize:14];
    [_g setColor:rgb(0,0,0)];
}


void gb_gcls( int r, int g, int b )
{
    //バッファのクリア
	[_g clear_r:r g:g b:b ];
    [_g clear];
}


void gb_dbgtest( void )
{
    gb_gcls( 0, 0, 0 );

    [_g setColor:rgb(255,255,255)];
    [_g setLineWidth:1];
    [_g drawRect_x:10 y:100 w:60 h:60];
    
    //テキストの描画
    [_g setFontSize:12];
    [_g drawString:@"HSP3Dish Ready" x:10 y:10];
}


void gb_color( int r, int g, int b )
{
    [_g setColor:rgb(r,g,b)];
}


void gb_colorset( BMSCR *bm )
{
    int r,g,b;
    r = ( bm->color >>16 ) & 0xff;
    g = ( bm->color >>8  ) & 0xff;
    b = ( bm->color ) & 0xff;
    [_g setColor:rgb(r,g,b)];
}


void gb_font( int size, int style, char *msg )
{
	//	とりあえずサイズのみ反映
	[_g setFontSize:size];
}


void gb_mes( int xx, int yy, char *msg )
{
	NSString *nsstr = [[NSString alloc] initWithUTF8String:msg];
	[_g drawString:nsstr x:xx y:yy];
	[nsstr release];
}


void gb_boxf( int x1, int y1, int x2, int y2 )
{
    [_g fillRect_x:x1 y:y1 w:x2-x1 h:y2-y1];
}


void gb_celput( int xx, int yy, int bufid, int srcx, int srcy, int sx, int sy )
{
    [_g drawScaledImage:_image[bufid]
					  x:xx y:yy w:sx h:sy
					 sx:srcx sy:srcy sw:sx sh:sy];
}


void gb_celput2( int xx, int yy, int dx, int dy, int bufid, int srcx, int srcy, int sx, int sy )
{
    [_g drawScaledImage:_image[bufid]
					  x:xx y:yy w:dx h:dy
					 sx:srcx sy:srcy sw:sx sh:sy];
}


void gb_zoom( int xx, int yy, int dx, int dy, int bufid, int srcx, int srcy, int sx, int sy )
{
    [_g drawScaledFlipImage:_image[bufid]
					  x:xx y:yy w:dx h:dy
					 sx:srcx sy:srcy sw:sx sh:sy];
}


void gb_circle( float x1, float y1, float x2, float y2, int mode )
{
	float xx,yy,rx,ry;

	rx = ((float)abs(x2-x1))*0.5f;
	ry = ((float)abs(y2-y1))*0.5f;
	xx = ((float)x1) + rx;
	yy = ((float)y1) + ry;

	if ( mode ) {
		[_g fillCircle_x:xx y:yy rx:rx ry:ry ];
	} else {
		[_g drawCircle_x:xx y:yy rx:rx ry:ry ];
	}
}


void gb_line( float x1, float y1, float x2, float y2 )
{
    [_g drawLine_x0:x1 y0:y1 x1:x2 y1:y2];
}


int gb_celload( int bufid, char *fname, int *sx, int *sy )
{
	NSString *nsstr = [[NSString alloc] initWithUTF8String:fname];

	gb_delimage( bufid );
	_image[bufid] = [[Image makeImage:[UIImage imageNamed:nsstr]] retain];
	[nsstr release];
	if ( _image[bufid] == nil ) return -1;

	*sx = [_image[bufid] width];
	*sy = [_image[bufid] height];
	return 0;
}


void gb_mouse( int xx, int yy, int button )
{
	mouse_x = xx;
	mouse_y = yy;
	mouse_btn = button;
    if ( mainbm != NULL ) {
        mainbm->savepos[BMSCR_SAVEPOS_MOSUEX] = xx;
        mainbm->savepos[BMSCR_SAVEPOS_MOSUEY] = yy;
    }
}

int gb_getmousex( void )
{
	return mouse_x;
}


int gb_getmousey( void )
{
	return mouse_y;
}


int gb_getmousebtn( void )
{
	return mouse_btn;
}


/*------------------------------------------------------------*/
/*
		interface
*/
/*------------------------------------------------------------*/

void hgio_init( int mode, int sx, int sy, void *hwnd )
{
	//		ファイルサービス設定
	//
	nDestWidth = sx;
	nDestHeight = sy;
	drawflag = 0;

	//		設定の初期化
	//
	SetSysReq( SYSREQ_RESULT, 0 );
	SetSysReq( SYSREQ_RESVMODE, 0 );
	SetSysReq( SYSREQ_CLSMODE, CLSMODE_SOLID );
	SetSysReq( SYSREQ_CLSCOLOR, 0xffffff );

	//		IOS グラフィック初期化
	//
	gb_init();

	//SetSysReq( SYSREQ_RESULT, 1 );
}


void hgio_clsmode( int mode, int color, int tex )
{
	SetSysReq( SYSREQ_CLSMODE, mode );
	SetSysReq( SYSREQ_CLSCOLOR, color );
	SetSysReq( SYSREQ_CLSTEX, tex );
}


int hgio_getWidth( void )
{
	return nDestWidth;
}


int hgio_getHeight( void )
{
	return nDestHeight;
}


int hgio_device_restore( void )
{
	//	デバイスの修復
	//		(0=OK/1=NG)
	//
	return 0;
}


int hgio_render_end( void )
{
	int res;
	res = 0;
	if ( drawflag == 0 ) return 0;

    //後処理
    glBindRenderbufferOES(GL_RENDERBUFFER_OES,_viewRenderBuff);
    [_context presentRenderbuffer:GL_RENDERBUFFER_OES];

	drawflag = 0;
	return res;
}


void hgio_term( void )
{
	hgio_render_end();
	gb_bye();
}


int hgio_render_start( void )
{
	if ( drawflag ) {
		hgio_render_end();
	}

	if ( GetSysReq( SYSREQ_CLSMODE ) == CLSMODE_SOLID ) {
		int ccol = GetSysReq( SYSREQ_CLSCOLOR );
		gb_gcls( (ccol>>16)&0xff, (ccol>>8)&0xff, ccol&0xff );
	}

    //前処理
    [EAGLContext setCurrentContext:_context];
    glBindFramebufferOES(GL_FRAMEBUFFER_OES,_viewFrameBuff);
    
	drawflag = 1;
	return 0;
}


void hgio_screen( BMSCR *bm )
{
	//		スクリーン再設定
	//		(cls相当)
	//
    mainbm = bm;
	gb_reset( bm->sx, bm->sy );
//	hgio_font( DEFAULT_FONT_NAME, DEFAULT_FONT_SIZE, DEFAULT_FONT_STYLE );
}


void hgio_delscreen( BMSCR *bm )
{
	//		スクリーンを破棄
	//		(Bmscrクラスのdelete時)
	//
	if ( bm->flag == BMSCR_FLAG_NOUSE ) return;
	if ( bm->texid != -1 ) {
		gb_delimage( bm->texid );
		bm->texid = -1;
	}
}


int hgio_stick( int actsw )
{
	//		stick用の入力を返す
	//
//	HWND hwnd;
	int ckey = 0;
/*
	if ( actsw ) {
		hwnd = GetActiveWindow();
		if ( hwnd != master_wnd ) return 0;
	}

	if ( GetAsyncKeyState(37)&0x8000 ) ckey|=1;		// [left]
	if ( GetAsyncKeyState(38)&0x8000 ) ckey|=2;		// [up]
	if ( GetAsyncKeyState(39)&0x8000 ) ckey|=4;		// [right]
	if ( GetAsyncKeyState(40)&0x8000 ) ckey|=8;		// [down]
	if ( GetAsyncKeyState(32)&0x8000 ) ckey|=16;	// [spc]
	if ( GetAsyncKeyState(13)&0x8000 ) ckey|=32;	// [ent]
	if ( GetAsyncKeyState(17)&0x8000 ) ckey|=64;	// [ctrl]
	if ( GetAsyncKeyState(27)&0x8000 ) ckey|=128;	// [esc]
	if ( GetAsyncKeyState(1)&0x8000 )  ckey|=256;	// mouse_l
	if ( GetAsyncKeyState(2)&0x8000 )  ckey|=512;	// mouse_r
	if ( GetAsyncKeyState(9)&0x8000 )  ckey|=1024;	// [tab]
*/

	if ( gb_getmousebtn() ) ckey|=256;	// mouse_l
    return ckey;
}


int hgio_redraw( BMSCR *bm, int flag )
{
	//		redrawモード設定
	//		(必ずredraw 0～redraw 1をペアにすること)
	//
	if ( bm == NULL ) return -1;
	if ( bm->type != HSPWND_TYPE_MAIN ) throw HSPERR_UNSUPPORTED_FUNCTION;

	if ( flag & 1 ) {
		hgio_render_end();
	} else {
		hgio_render_start();
	}
	return 0;
}


int hgio_dialog( int mode, char *str1, char *str2 )
{
	//		dialog表示
	//
/*
	int i,res;
	i = 0;
	if (mode&1) i|=MB_ICONEXCLAMATION; else i|=MB_ICONINFORMATION;
	if (mode&2) i|=MB_YESNO; else i|=MB_OK;
	res = MessageBox( master_wnd, str1, str2, i );
*/
	return 0;
}


int hgio_title( char *str1 )
{
	//		title変更
	//
	//SetWindowText( master_wnd, str1 );
	return 0;
}


int hgio_texload( BMSCR *bm, char *fname )
{
	//		テクスチャ読み込み
	//
	int i,sx,sy;
	i = gb_celload( bm->wid, fname, &sx, &sy );
	if ( i ) return i;

	bm->sx = sx;
	bm->sy = sy;
	bm->texid = bm->wid;

	return 0;
}


int hgio_mes( BMSCR *bm, char *str1 )
{
	//		mes,print 文字表示
	//
	if ( bm->type != HSPWND_TYPE_MAIN ) throw HSPERR_UNSUPPORTED_FUNCTION;

    gb_colorset( bm );
    
    NSString *nsstr = [[NSString alloc] initWithUTF8String:str1];
	[_g drawString:nsstr x:bm->cx y:bm->cy];
	[nsstr release];
    
	//gb_mes( bm->cx, bm->cy, str1 );
	return 0;
}


int hgio_font( char *fontname, int size, int style )
{
	//		文字フォント指定
	//
	gb_font( size, style, fontname );
	return 0;
}


/*------------------------------------------------------------*/
/*
		Polygon Draw Routines
*/
/*------------------------------------------------------------*/

//テクスチャ頂点情報
static GLfloat vert2D[]={
    0,  0, //左上
    0, -1, //左下
    1,  0, //右上
    1, -1, //右下
};

static GLfloat vertf2D[]={
    0,  0, //左上
    0, -1, //左下
    1,  0, //右上
    1, -1, //右下
};

//テクスチャUV情報
static GLfloat uv2D[]={
    0.0f, 0.0f, //左上
    0.0f, 1.0f, //左下
    1.0f, 0.0f, //右上
    1.0f, 1.0f, //右下
};

static GLfloat uvf2D[]={
    0.0f, 0.0f, //左上
    0.0f, 1.0f, //左下
    1.0f, 0.0f, //右上
    1.0f, 1.0f, //右下
};

/*------------------------------------------------------------*/
/*
		Universal Draw Service
*/
/*------------------------------------------------------------*/

static 	float linebasex, linebasey;

void hgio_line( BMSCR *bm, float x, float y )
{
	//		ライン描画
	//		(bm!=NULL の場合、ライン描画開始)
	//		(bm==NULL の場合、ライン描画完了)
	//		(ラインの座標は必要な数だけhgio_line2を呼び出す)
	//
	if ( bm == NULL ) return;

    gb_colorset( bm );
	linebasex = x;
	linebasey = y;
}


void hgio_line2( float x, float y )
{
	//		ライン描画
	//		(hgio_lineで開始後に必要な回数呼ぶ、hgio_line(NULL)で終了すること)
	//
    gb_line( linebasex, linebasey, x, y );
	linebasex = x;
	linebasey = y;
}


void hgio_boxf( BMSCR *bm, float x1, float y1, float x2, float y2 )
{
	//		矩形描画
	//
    gb_colorset( bm );
    gb_boxf( x1, y1, x2, y2 );
}


void hgio_circle( BMSCR *bm, float x1, float y1, float x2, float y2, int mode )
{
	//		円描画
	//
    gb_colorset( bm );
    gb_circle( x1, y1, x2, y2, mode );
}


void hgio_fillrot( BMSCR *bm, float x, float y, float sx, float sy, float ang )
{
	//		矩形(回転)描画
	//
	if ( bm == NULL ) return;
	if ( bm->type != HSPWND_TYPE_MAIN ) throw HSPERR_UNSUPPORTED_FUNCTION;
    
    GLfloat *flp;
	GLfloat x0,y0,x1,y1,ofsx,ofsy;
    int arate;
    
	ofsx = sx;
	ofsy = sy;
	x0 = -(float)sin( ang );
	y0 = (float)cos( ang );
	x1 = -y0;
	y1 = x0;
    
	ofsx *= -0.5f;
	ofsy *= -0.5f;
	x0 *= ofsy;
	y0 *= ofsy;
	x1 *= ofsx;
	y1 *= ofsx;
    
    flp = vertf2D;
    
	*flp++ = (-x0-x1) + x;
	*flp++ = -((-y0-y1) + y);

	*flp++ = (-x0+x1) + x;
	*flp++ = -((-y0+y1) + y);
    
	*flp++ = (x0-x1) + x;
	*flp++ = -((y0-y1) + y);
    
	*flp++ = (x0+x1) + x;
	*flp++ = -((y0+y1) + y);

    glBindTexture(GL_TEXTURE_2D,0);
    glVertexPointer(2,GL_FLOAT,0,vertf2D);
    arate = bm->gfrate;
    if ( bm->gmode < 3 ) arate = 255;
    [_g setColorVertex:bm->color alpha:arate];
    [_g setBlendModeFlat:bm->gmode];
    glDrawArrays(GL_TRIANGLE_STRIP,0,4);
}


void hgio_copy( BMSCR *bm, short xx, short yy, short srcsx, short srcsy, BMSCR *bmsrc, float psx, float psy )
{
	//		画像コピー
	//		texid内の(xx,yy)-(xx+srcsx,yy+srcsy)を現在の画面に(psx,psy)サイズでコピー
	//		カレントポジション、描画モードはBMSCRから取得
	//
//    gb_zoom( bm->cx, bm->cy, psx, psy, bmsrc->texid, xx, yy, srcsx, srcsy );
//    int dx,dy,dh,dw;

	if ( bm == NULL ) return;
	if ( bm->type != HSPWND_TYPE_MAIN ) throw HSPERR_UNSUPPORTED_FUNCTION;

    Image *image = _image[bmsrc->texid];
    if (image==nil) return;

    GLfloat *flp;
    GLfloat x1,y1,x2,y2;
    float ratex,ratey;
    
    flp = vertf2D;
    x1 = (GLfloat)bm->cx;
    y1 = (GLfloat)-bm->cy;
    x2 = x1+psx;
    y2 = y1-psy;
    
    *flp++ = x1;
    *flp++ = y1;
    *flp++ = x1;
    *flp++ = y2;
    *flp++ = x2;
    *flp++ = y1;
    *flp++ = x2;
    *flp++ = y2;

    //ratex = 1.0f / image.width;
    //ratey = 1.0f / image.height;
    ratex = image.ratex;
    ratey = image.ratey;

    flp = uvf2D;
    x1 = ((GLfloat)xx) * ratex;
    y1 = ((GLfloat)yy) * ratey;
    x2 = ((GLfloat)(xx+srcsx)) * ratex;
    y2 = ((GLfloat)(yy+srcsy)) * ratey;
    
    *flp++ = x1;
    *flp++ = y1;
    *flp++ = x1;
    *flp++ = y2;
    *flp++ = x2;
    *flp++ = y1;
    *flp++ = x2;
    *flp++ = y2;

    glBindTexture(GL_TEXTURE_2D,image.name);
    glVertexPointer(2,GL_FLOAT,0,vertf2D);
    glTexCoordPointer(2,GL_FLOAT,0,uvf2D);

    [_g setBlendMode:bm->gmode alpha:bm->gfrate];
//    glDisableClientState(GL_COLOR_ARRAY);
    glDrawArrays(GL_TRIANGLE_STRIP,0,4);
    
#if 0
    dw = image.width*srcsx/psx;
    dx = bm->cx - xx*srcsx/psx;
    dh = image.height*srcsy/psy;
    dy = bm->cy - yy*srcsy/psy;

    [_g clipRect_x:bm->cx y:bm->cy w:psx h:psy];
    glBindTexture(GL_TEXTURE_2D,image.name);
    glVertexPointer(2,GL_FLOAT,0,vert2D);
    glDisableClientState(GL_COLOR_ARRAY);
    glPushMatrix();
    glTranslatef(dx,-dy,0);
    glScalef(dw,dh,1);
    glDrawArrays(GL_TRIANGLE_STRIP,0,4);
    glPopMatrix();
    [_g clearClip];
#endif    
}


void hgio_copyrot( BMSCR *bm, short xx, short yy, short srcsx, short srcsy, float s_ofsx, float s_ofsy, BMSCR *bmsrc, float psx, float psy, float ang )
{
	//		画像コピー
	//		texid内の(xx,yy)-(xx+srcsx,yy+srcsy)を現在の画面に(psx,psy)サイズでコピー
	//		カレントポジション、描画モードはBMSCRから取得
	//
    //gb_zoom( bm->cx, bm->cy, psx, psy, bmsrc->texid, xx, yy, srcsx, srcsy );

	if ( bm == NULL ) return;
	if ( bm->type != HSPWND_TYPE_MAIN ) throw HSPERR_UNSUPPORTED_FUNCTION;

    Image *image = _image[bmsrc->texid];
    if (image==nil) return;
    
    GLfloat *flp;
    float ratex,ratey;

	int texpx,texpy,texid;
	GLfloat x,y,x0,y0,x1,y1,ofsx,ofsy,mx0,mx1,my0,my1;
	GLfloat tx0,ty0,tx1,ty1,sx,sy;
    
	mx0=-(float)sin( ang );
	my0=(float)cos( ang );
	mx1 = -my0;
	my1 = mx0;
    
	ofsx = -s_ofsx;
	ofsy = -s_ofsy;
	x0 = mx0 * ofsy;
	y0 = my0 * ofsy;
	x1 = mx1 * ofsx;
	y1 = my1 * ofsx;
    
	//		基点の算出
	x = ( (float)bm->cx - (-x0+x1) );
	y = ( (float)bm->cy - (-y0+y1) );
    
	/*-------------------------------*/
    
	//		回転座標の算出
	ofsx = -psx;
	ofsy = -psy;
	x0 = mx0 * ofsy;
	y0 = my0 * ofsy;
	x1 = mx1 * ofsx;
	y1 = my1 * ofsx;
    
	/*-------------------------------*/
    
    sx = image.ratex;
    sy = image.ratey;
    //sx = 1.0f / image.width;
    //sy = 1.0f / image.height;
	texpx = xx + srcsx;
	texpy = yy + srcsy;
    
	tx0 = ((float)xx) * sx;
	ty0 = ((float)yy) * sy;
	tx1 = ((float)(texpx)) * sx;
	ty1 = ((float)(texpy)) * sy;

    flp = uvf2D;
    *flp++ = tx0;
    *flp++ = ty0;
    *flp++ = tx0;
    *flp++ = ty1;
    *flp++ = tx1;
    *flp++ = ty0;
    *flp++ = tx1;
    *flp++ = ty1;

	/*-------------------------------*/

    flp = vertf2D;
    
	*flp++ = (x);
	*flp++ = -(y);
    
	/*-------------------------------*/

	*flp++ = ((-x0) + x);
	*flp++ = -((-y0) + y);
    
	/*-------------------------------*/
    
	*flp++ = ((x1) + x);
	*flp++ = -((y1) + y);
    
	/*-------------------------------*/

	*flp++ = ((-x0+x1) + x);
	*flp++ = -((-y0+y1) + y);
    
	/*-------------------------------*/
    
    glBindTexture(GL_TEXTURE_2D,image.name);
    glVertexPointer(2,GL_FLOAT,0,vertf2D);
    glTexCoordPointer(2,GL_FLOAT,0,uvf2D);

    [_g setBlendMode:bm->gmode alpha:bm->gfrate];
    //glDisableClientState(GL_COLOR_ARRAY);
    glDrawArrays(GL_TRIANGLE_STRIP,0,4);


}

