#import "HspView.h"
#import "hgiox.h"
#include "../hsp3/hsp3config.h"
#include "../hsp3/hgio.h"
#include "../hsp3embed/hsp3embed.h"

void gb_setogl( EAGLContext *context, GLuint viewRenderBuff, GLuint viewFrameBuff );

//HspViewの実装
@implementation HspView

//フレームの初期化
- (id)initWithFrame:(CGRect)frame {
    if (self=[super initWithFrame:frame]) {
        //グラフィックスの生成
        int sx,sy;
        sx = frame.size.width;
        sy = frame.size.height;
        NSLog(@"Init HspView(%d,%d)",sx,sy);
        hgio_init( 0, sx, sy, NULL );
    }
    return self;
}

//メモリ解放
- (void)dealloc {
	hsp3eb_bye();
	hgio_term();
    [super dealloc];
}

//セットアップ
- (void)setup {
    //グラフィックスのセットアップ
    gb_setogl( _context, _viewRenderBuff, _viewFrameBuff );
    gb_reset( self.bgWidth, self.bgHeight );
	hsp3eb_init();
}

//定期処理
- (void)onTick {

	hsp3eb_exec();
//	gb_dbgtest();
}


- (void)clsMode:(int)mode color:(int)color
{
    hgio_clsmode( mode, color, 0 );
    cls_mode = mode;
    cls_color = color;
}


- (void) touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
	UITouch *touch = [touches anyObject];
	CGPoint location = [touch locationInView:self];
	NSInteger taps = [touch tapCount];
	
	[super touchesBegan:touches withEvent:event];

	gb_mouse( location.x, location.y, 1 );
	//NSLog(@"タップ開始 %f, %f  タップ数：%d", location.x, location.y, taps);
}


- (void) touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {
	UITouch *touch = [touches anyObject];
	CGPoint oldLocation = [touch previousLocationInView:self];
	CGPoint newLocation = [touch locationInView:self];
	
	[super touchesMoved:touches withEvent:event];
	
	gb_mouse( newLocation.x, newLocation.y, 1 );
	//NSLog(@"指の動き：%f , %f から %f, %f", oldLocation.x, oldLocation.y, newLocation.x, newLocation.y);	
}


- (void) touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {	
	UITouch *touch = [touches anyObject];
	CGPoint location = [touch locationInView:self];
	
	[super touchesEnded:touches withEvent:event];
	
	gb_mouse( location.x, location.y, 0 );
	//NSLog(@"タップ終了 %f, %f", location.x, location.y);	
}

@end
